#![allow(unused_variables, non_upper_case_globals, non_snake_case, unused_unsafe, non_camel_case_types, dead_code, clippy::all)]
pub const CLSID_D3D12Debug: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4063570667, 56708, 18942, [185, 123, 169, 220, 253, 204, 27, 79]);
pub const CLSID_D3D12DeviceRemovedExtendedData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1249229764, 40948, 19160, [159, 24, 171, 174, 132, 220, 95, 242]);
pub const CLSID_D3D12SDKConfiguration: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2094688970, 41022, 18888, [148, 88, 3, 52, 210, 14, 7, 206]);
pub const CLSID_D3D12Tools: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3816953521, 15500, 18483, [170, 9, 10, 6, 182, 93, 150, 200]);
#[cfg(feature = "Win32_Graphics_Direct3D11")]
#[inline]
pub unsafe fn D3D11On12CreateDevice<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(
    pdevice: Param0,
    flags: u32,
    pfeaturelevels: *const super::Direct3D11::D3D_FEATURE_LEVEL,
    featurelevels: u32,
    ppcommandqueues: *const ::std::option::Option<::windows::runtime::IUnknown>,
    numqueues: u32,
    nodemask: u32,
    ppdevice: *mut ::std::option::Option<super::Direct3D11::ID3D11Device>,
    ppimmediatecontext: *mut ::std::option::Option<super::Direct3D11::ID3D11DeviceContext>,
    pchosenfeaturelevel: *mut super::Direct3D11::D3D_FEATURE_LEVEL,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D11On12CreateDevice(pdevice: ::windows::runtime::RawPtr, flags: u32, pfeaturelevels: *const super::Direct3D11::D3D_FEATURE_LEVEL, featurelevels: u32, ppcommandqueues: *const ::windows::runtime::RawPtr, numqueues: u32, nodemask: u32, ppdevice: *mut ::windows::runtime::RawPtr, ppimmediatecontext: *mut ::windows::runtime::RawPtr, pchosenfeaturelevel: *mut super::Direct3D11::D3D_FEATURE_LEVEL) -> ::windows::runtime::HRESULT;
        }
        D3D11On12CreateDevice(
            pdevice.into_param().abi(),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pfeaturelevels),
            ::std::mem::transmute(featurelevels),
            ::std::mem::transmute(ppcommandqueues),
            ::std::mem::transmute(numqueues),
            ::std::mem::transmute(nodemask),
            ::std::mem::transmute(ppdevice),
            ::std::mem::transmute(ppimmediatecontext),
            ::std::mem::transmute(pchosenfeaturelevel),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct D3D11On12CreatorID(::windows::runtime::IUnknown);
impl D3D11On12CreatorID {}
unsafe impl ::windows::runtime::Interface for D3D11On12CreatorID {
    type Vtable = D3D11On12CreatorID_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3988739704, 10592, 20097, [132, 41, 153, 212, 178, 99, 12, 78]);
}
impl ::std::convert::From<D3D11On12CreatorID> for ::windows::runtime::IUnknown {
    fn from(value: D3D11On12CreatorID) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&D3D11On12CreatorID> for ::windows::runtime::IUnknown {
    fn from(value: &D3D11On12CreatorID) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for D3D11On12CreatorID {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &D3D11On12CreatorID {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct D3D11On12CreatorID_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_RESOURCE_FLAGS {
    pub BindFlags: u32,
    pub MiscFlags: u32,
    pub CPUAccessFlags: u32,
    pub StructureByteStride: u32,
}
impl D3D11_RESOURCE_FLAGS {}
impl ::std::default::Default for D3D11_RESOURCE_FLAGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_RESOURCE_FLAGS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_RESOURCE_FLAGS").field("BindFlags", &self.BindFlags).field("MiscFlags", &self.MiscFlags).field("CPUAccessFlags", &self.CPUAccessFlags).field("StructureByteStride", &self.StructureByteStride).finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_RESOURCE_FLAGS {
    fn eq(&self, other: &Self) -> bool {
        self.BindFlags == other.BindFlags && self.MiscFlags == other.MiscFlags && self.CPUAccessFlags == other.CPUAccessFlags && self.StructureByteStride == other.StructureByteStride
    }
}
impl ::std::cmp::Eq for D3D11_RESOURCE_FLAGS {}
unsafe impl ::windows::runtime::Abi for D3D11_RESOURCE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
#[inline]
pub unsafe fn D3D12CreateDevice<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>, T: ::windows::runtime::Interface>(padapter: Param0, minimumfeaturelevel: super::Direct3D11::D3D_FEATURE_LEVEL, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12CreateDevice(padapter: ::windows::runtime::RawPtr, minimumfeaturelevel: super::Direct3D11::D3D_FEATURE_LEVEL, riid: *const ::windows::runtime::GUID, ppdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        D3D12CreateDevice(padapter.into_param().abi(), ::std::mem::transmute(minimumfeaturelevel), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn D3D12CreateRootSignatureDeserializer(psrcdata: *const ::std::ffi::c_void, srcdatasizeinbytes: usize, prootsignaturedeserializerinterface: *const ::windows::runtime::GUID, pprootsignaturedeserializer: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12CreateRootSignatureDeserializer(psrcdata: *const ::std::ffi::c_void, srcdatasizeinbytes: usize, prootsignaturedeserializerinterface: *const ::windows::runtime::GUID, pprootsignaturedeserializer: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        D3D12CreateRootSignatureDeserializer(::std::mem::transmute(psrcdata), ::std::mem::transmute(srcdatasizeinbytes), ::std::mem::transmute(prootsignaturedeserializerinterface), ::std::mem::transmute(pprootsignaturedeserializer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn D3D12CreateVersionedRootSignatureDeserializer(psrcdata: *const ::std::ffi::c_void, srcdatasizeinbytes: usize, prootsignaturedeserializerinterface: *const ::windows::runtime::GUID, pprootsignaturedeserializer: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12CreateVersionedRootSignatureDeserializer(psrcdata: *const ::std::ffi::c_void, srcdatasizeinbytes: usize, prootsignaturedeserializerinterface: *const ::windows::runtime::GUID, pprootsignaturedeserializer: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        D3D12CreateVersionedRootSignatureDeserializer(::std::mem::transmute(psrcdata), ::std::mem::transmute(srcdatasizeinbytes), ::std::mem::transmute(prootsignaturedeserializerinterface), ::std::mem::transmute(pprootsignaturedeserializer)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn D3D12EnableExperimentalFeatures(numfeatures: u32, piids: *const ::windows::runtime::GUID, pconfigurationstructs: *const ::std::ffi::c_void, pconfigurationstructsizes: *const u32) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12EnableExperimentalFeatures(numfeatures: u32, piids: *const ::windows::runtime::GUID, pconfigurationstructs: *const ::std::ffi::c_void, pconfigurationstructsizes: *const u32) -> ::windows::runtime::HRESULT;
        }
        D3D12EnableExperimentalFeatures(::std::mem::transmute(numfeatures), ::std::mem::transmute(piids), ::std::mem::transmute(pconfigurationstructs), ::std::mem::transmute(pconfigurationstructsizes)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const D3D12ExperimentalShaderModels: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1995790142, 61754, 16629, [178, 151, 129, 206, 158, 24, 147, 63]);
#[inline]
pub unsafe fn D3D12GetDebugInterface<T: ::windows::runtime::Interface>(result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12GetDebugInterface(riid: *const ::windows::runtime::GUID, ppvdebug: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        D3D12GetDebugInterface(&<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn D3D12GetInterface<T: ::windows::runtime::Interface>(rclsid: *const ::windows::runtime::GUID, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12GetInterface(rclsid: *const ::windows::runtime::GUID, riid: *const ::windows::runtime::GUID, ppvdebug: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        D3D12GetInterface(::std::mem::transmute(rclsid), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub type D3D12MessageFunc = unsafe extern "system" fn(category: D3D12_MESSAGE_CATEGORY, severity: D3D12_MESSAGE_SEVERITY, id: D3D12_MESSAGE_ID, pdescription: super::super::Foundation::PSTR, pcontext: *mut ::std::ffi::c_void);
pub const D3D12MetaCommand: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3342125438, 32887, 18632, [159, 220, 217, 209, 221, 49, 221, 119]);
#[cfg(feature = "Win32_Graphics_Direct3D11")]
#[inline]
pub unsafe fn D3D12SerializeRootSignature(prootsignature: *const D3D12_ROOT_SIGNATURE_DESC, version: D3D_ROOT_SIGNATURE_VERSION, ppblob: *mut ::std::option::Option<super::Direct3D11::ID3DBlob>, pperrorblob: *mut ::std::option::Option<super::Direct3D11::ID3DBlob>) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12SerializeRootSignature(prootsignature: *const D3D12_ROOT_SIGNATURE_DESC, version: D3D_ROOT_SIGNATURE_VERSION, ppblob: *mut ::windows::runtime::RawPtr, pperrorblob: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        D3D12SerializeRootSignature(::std::mem::transmute(prootsignature), ::std::mem::transmute(version), ::std::mem::transmute(ppblob), ::std::mem::transmute(pperrorblob)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
#[inline]
pub unsafe fn D3D12SerializeVersionedRootSignature(prootsignature: *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC, ppblob: *mut ::std::option::Option<super::Direct3D11::ID3DBlob>, pperrorblob: *mut ::std::option::Option<super::Direct3D11::ID3DBlob>) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D12SerializeVersionedRootSignature(prootsignature: *const D3D12_VERSIONED_ROOT_SIGNATURE_DESC, ppblob: *mut ::windows::runtime::RawPtr, pperrorblob: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        D3D12SerializeVersionedRootSignature(::std::mem::transmute(prootsignature), ::std::mem::transmute(ppblob), ::std::mem::transmute(pperrorblob)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const D3D12TiledResourceTier4: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3385094751, 43034, 20310, [140, 91, 197, 16, 57, 214, 148, 251]);
pub const D3D12_16BIT_INDEX_STRIP_CUT_VALUE: u32 = 65535u32;
pub const D3D12_32BIT_INDEX_STRIP_CUT_VALUE: u32 = 4294967295u32;
pub const D3D12_8BIT_INDEX_STRIP_CUT_VALUE: u32 = 255u32;
pub const D3D12_ANISOTROPIC_FILTERING_BIT: u32 = 64u32;
pub const D3D12_APPEND_ALIGNED_ELEMENT: u32 = 4294967295u32;
pub const D3D12_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT: u32 = 9u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_AUTO_BREADCRUMB_NODE {
    pub pCommandListDebugNameA: *mut u8,
    pub pCommandListDebugNameW: super::super::Foundation::PWSTR,
    pub pCommandQueueDebugNameA: *mut u8,
    pub pCommandQueueDebugNameW: super::super::Foundation::PWSTR,
    pub pCommandList: ::std::option::Option<ID3D12GraphicsCommandList>,
    pub pCommandQueue: ::std::option::Option<ID3D12CommandQueue>,
    pub BreadcrumbCount: u32,
    pub pLastBreadcrumbValue: *mut u32,
    pub pCommandHistory: *mut D3D12_AUTO_BREADCRUMB_OP,
    pub pNext: *mut D3D12_AUTO_BREADCRUMB_NODE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_AUTO_BREADCRUMB_NODE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_AUTO_BREADCRUMB_NODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_AUTO_BREADCRUMB_NODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_AUTO_BREADCRUMB_NODE")
            .field("pCommandListDebugNameA", &self.pCommandListDebugNameA)
            .field("pCommandListDebugNameW", &self.pCommandListDebugNameW)
            .field("pCommandQueueDebugNameA", &self.pCommandQueueDebugNameA)
            .field("pCommandQueueDebugNameW", &self.pCommandQueueDebugNameW)
            .field("pCommandList", &self.pCommandList)
            .field("pCommandQueue", &self.pCommandQueue)
            .field("BreadcrumbCount", &self.BreadcrumbCount)
            .field("pLastBreadcrumbValue", &self.pLastBreadcrumbValue)
            .field("pCommandHistory", &self.pCommandHistory)
            .field("pNext", &self.pNext)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_AUTO_BREADCRUMB_NODE {
    fn eq(&self, other: &Self) -> bool {
        self.pCommandListDebugNameA == other.pCommandListDebugNameA
            && self.pCommandListDebugNameW == other.pCommandListDebugNameW
            && self.pCommandQueueDebugNameA == other.pCommandQueueDebugNameA
            && self.pCommandQueueDebugNameW == other.pCommandQueueDebugNameW
            && self.pCommandList == other.pCommandList
            && self.pCommandQueue == other.pCommandQueue
            && self.BreadcrumbCount == other.BreadcrumbCount
            && self.pLastBreadcrumbValue == other.pLastBreadcrumbValue
            && self.pCommandHistory == other.pCommandHistory
            && self.pNext == other.pNext
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_AUTO_BREADCRUMB_NODE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_AUTO_BREADCRUMB_NODE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_AUTO_BREADCRUMB_NODE1 {
    pub pCommandListDebugNameA: *mut u8,
    pub pCommandListDebugNameW: super::super::Foundation::PWSTR,
    pub pCommandQueueDebugNameA: *mut u8,
    pub pCommandQueueDebugNameW: super::super::Foundation::PWSTR,
    pub pCommandList: ::std::option::Option<ID3D12GraphicsCommandList>,
    pub pCommandQueue: ::std::option::Option<ID3D12CommandQueue>,
    pub BreadcrumbCount: u32,
    pub pLastBreadcrumbValue: *mut u32,
    pub pCommandHistory: *mut D3D12_AUTO_BREADCRUMB_OP,
    pub pNext: *mut D3D12_AUTO_BREADCRUMB_NODE1,
    pub BreadcrumbContextsCount: u32,
    pub pBreadcrumbContexts: *mut D3D12_DRED_BREADCRUMB_CONTEXT,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_AUTO_BREADCRUMB_NODE1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_AUTO_BREADCRUMB_NODE1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_AUTO_BREADCRUMB_NODE1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_AUTO_BREADCRUMB_NODE1")
            .field("pCommandListDebugNameA", &self.pCommandListDebugNameA)
            .field("pCommandListDebugNameW", &self.pCommandListDebugNameW)
            .field("pCommandQueueDebugNameA", &self.pCommandQueueDebugNameA)
            .field("pCommandQueueDebugNameW", &self.pCommandQueueDebugNameW)
            .field("pCommandList", &self.pCommandList)
            .field("pCommandQueue", &self.pCommandQueue)
            .field("BreadcrumbCount", &self.BreadcrumbCount)
            .field("pLastBreadcrumbValue", &self.pLastBreadcrumbValue)
            .field("pCommandHistory", &self.pCommandHistory)
            .field("pNext", &self.pNext)
            .field("BreadcrumbContextsCount", &self.BreadcrumbContextsCount)
            .field("pBreadcrumbContexts", &self.pBreadcrumbContexts)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_AUTO_BREADCRUMB_NODE1 {
    fn eq(&self, other: &Self) -> bool {
        self.pCommandListDebugNameA == other.pCommandListDebugNameA
            && self.pCommandListDebugNameW == other.pCommandListDebugNameW
            && self.pCommandQueueDebugNameA == other.pCommandQueueDebugNameA
            && self.pCommandQueueDebugNameW == other.pCommandQueueDebugNameW
            && self.pCommandList == other.pCommandList
            && self.pCommandQueue == other.pCommandQueue
            && self.BreadcrumbCount == other.BreadcrumbCount
            && self.pLastBreadcrumbValue == other.pLastBreadcrumbValue
            && self.pCommandHistory == other.pCommandHistory
            && self.pNext == other.pNext
            && self.BreadcrumbContextsCount == other.BreadcrumbContextsCount
            && self.pBreadcrumbContexts == other.pBreadcrumbContexts
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_AUTO_BREADCRUMB_NODE1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_AUTO_BREADCRUMB_NODE1 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_AUTO_BREADCRUMB_OP(pub i32);
pub const D3D12_AUTO_BREADCRUMB_OP_SETMARKER: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(0i32);
pub const D3D12_AUTO_BREADCRUMB_OP_BEGINEVENT: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(1i32);
pub const D3D12_AUTO_BREADCRUMB_OP_ENDEVENT: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(2i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DRAWINSTANCED: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(3i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DRAWINDEXEDINSTANCED: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(4i32);
pub const D3D12_AUTO_BREADCRUMB_OP_EXECUTEINDIRECT: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(5i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DISPATCH: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(6i32);
pub const D3D12_AUTO_BREADCRUMB_OP_COPYBUFFERREGION: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(7i32);
pub const D3D12_AUTO_BREADCRUMB_OP_COPYTEXTUREREGION: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(8i32);
pub const D3D12_AUTO_BREADCRUMB_OP_COPYRESOURCE: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(9i32);
pub const D3D12_AUTO_BREADCRUMB_OP_COPYTILES: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(10i32);
pub const D3D12_AUTO_BREADCRUMB_OP_RESOLVESUBRESOURCE: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(11i32);
pub const D3D12_AUTO_BREADCRUMB_OP_CLEARRENDERTARGETVIEW: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(12i32);
pub const D3D12_AUTO_BREADCRUMB_OP_CLEARUNORDEREDACCESSVIEW: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(13i32);
pub const D3D12_AUTO_BREADCRUMB_OP_CLEARDEPTHSTENCILVIEW: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(14i32);
pub const D3D12_AUTO_BREADCRUMB_OP_RESOURCEBARRIER: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(15i32);
pub const D3D12_AUTO_BREADCRUMB_OP_EXECUTEBUNDLE: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(16i32);
pub const D3D12_AUTO_BREADCRUMB_OP_PRESENT: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(17i32);
pub const D3D12_AUTO_BREADCRUMB_OP_RESOLVEQUERYDATA: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(18i32);
pub const D3D12_AUTO_BREADCRUMB_OP_BEGINSUBMISSION: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(19i32);
pub const D3D12_AUTO_BREADCRUMB_OP_ENDSUBMISSION: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(20i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(21i32);
pub const D3D12_AUTO_BREADCRUMB_OP_PROCESSFRAMES: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(22i32);
pub const D3D12_AUTO_BREADCRUMB_OP_ATOMICCOPYBUFFERUINT: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(23i32);
pub const D3D12_AUTO_BREADCRUMB_OP_ATOMICCOPYBUFFERUINT64: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(24i32);
pub const D3D12_AUTO_BREADCRUMB_OP_RESOLVESUBRESOURCEREGION: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(25i32);
pub const D3D12_AUTO_BREADCRUMB_OP_WRITEBUFFERIMMEDIATE: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(26i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME1: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(27i32);
pub const D3D12_AUTO_BREADCRUMB_OP_SETPROTECTEDRESOURCESESSION: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(28i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DECODEFRAME2: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(29i32);
pub const D3D12_AUTO_BREADCRUMB_OP_PROCESSFRAMES1: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(30i32);
pub const D3D12_AUTO_BREADCRUMB_OP_BUILDRAYTRACINGACCELERATIONSTRUCTURE: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(31i32);
pub const D3D12_AUTO_BREADCRUMB_OP_EMITRAYTRACINGACCELERATIONSTRUCTUREPOSTBUILDINFO: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(32i32);
pub const D3D12_AUTO_BREADCRUMB_OP_COPYRAYTRACINGACCELERATIONSTRUCTURE: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(33i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DISPATCHRAYS: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(34i32);
pub const D3D12_AUTO_BREADCRUMB_OP_INITIALIZEMETACOMMAND: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(35i32);
pub const D3D12_AUTO_BREADCRUMB_OP_EXECUTEMETACOMMAND: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(36i32);
pub const D3D12_AUTO_BREADCRUMB_OP_ESTIMATEMOTION: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(37i32);
pub const D3D12_AUTO_BREADCRUMB_OP_RESOLVEMOTIONVECTORHEAP: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(38i32);
pub const D3D12_AUTO_BREADCRUMB_OP_SETPIPELINESTATE1: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(39i32);
pub const D3D12_AUTO_BREADCRUMB_OP_INITIALIZEEXTENSIONCOMMAND: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(40i32);
pub const D3D12_AUTO_BREADCRUMB_OP_EXECUTEEXTENSIONCOMMAND: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(41i32);
pub const D3D12_AUTO_BREADCRUMB_OP_DISPATCHMESH: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(42i32);
pub const D3D12_AUTO_BREADCRUMB_OP_ENCODEFRAME: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(43i32);
pub const D3D12_AUTO_BREADCRUMB_OP_RESOLVEENCODEROUTPUTMETADATA: D3D12_AUTO_BREADCRUMB_OP = D3D12_AUTO_BREADCRUMB_OP(44i32);
impl ::std::convert::From<i32> for D3D12_AUTO_BREADCRUMB_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_AUTO_BREADCRUMB_OP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_AXIS_SHADING_RATE(pub i32);
pub const D3D12_AXIS_SHADING_RATE_1X: D3D12_AXIS_SHADING_RATE = D3D12_AXIS_SHADING_RATE(0i32);
pub const D3D12_AXIS_SHADING_RATE_2X: D3D12_AXIS_SHADING_RATE = D3D12_AXIS_SHADING_RATE(1i32);
pub const D3D12_AXIS_SHADING_RATE_4X: D3D12_AXIS_SHADING_RATE = D3D12_AXIS_SHADING_RATE(2i32);
impl ::std::convert::From<i32> for D3D12_AXIS_SHADING_RATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_AXIS_SHADING_RATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_BACKGROUND_PROCESSING_MODE(pub i32);
pub const D3D12_BACKGROUND_PROCESSING_MODE_ALLOWED: D3D12_BACKGROUND_PROCESSING_MODE = D3D12_BACKGROUND_PROCESSING_MODE(0i32);
pub const D3D12_BACKGROUND_PROCESSING_MODE_ALLOW_INTRUSIVE_MEASUREMENTS: D3D12_BACKGROUND_PROCESSING_MODE = D3D12_BACKGROUND_PROCESSING_MODE(1i32);
pub const D3D12_BACKGROUND_PROCESSING_MODE_DISABLE_BACKGROUND_WORK: D3D12_BACKGROUND_PROCESSING_MODE = D3D12_BACKGROUND_PROCESSING_MODE(2i32);
pub const D3D12_BACKGROUND_PROCESSING_MODE_DISABLE_PROFILING_BY_SYSTEM: D3D12_BACKGROUND_PROCESSING_MODE = D3D12_BACKGROUND_PROCESSING_MODE(3i32);
impl ::std::convert::From<i32> for D3D12_BACKGROUND_PROCESSING_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_BACKGROUND_PROCESSING_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_BLEND(pub i32);
pub const D3D12_BLEND_ZERO: D3D12_BLEND = D3D12_BLEND(1i32);
pub const D3D12_BLEND_ONE: D3D12_BLEND = D3D12_BLEND(2i32);
pub const D3D12_BLEND_SRC_COLOR: D3D12_BLEND = D3D12_BLEND(3i32);
pub const D3D12_BLEND_INV_SRC_COLOR: D3D12_BLEND = D3D12_BLEND(4i32);
pub const D3D12_BLEND_SRC_ALPHA: D3D12_BLEND = D3D12_BLEND(5i32);
pub const D3D12_BLEND_INV_SRC_ALPHA: D3D12_BLEND = D3D12_BLEND(6i32);
pub const D3D12_BLEND_DEST_ALPHA: D3D12_BLEND = D3D12_BLEND(7i32);
pub const D3D12_BLEND_INV_DEST_ALPHA: D3D12_BLEND = D3D12_BLEND(8i32);
pub const D3D12_BLEND_DEST_COLOR: D3D12_BLEND = D3D12_BLEND(9i32);
pub const D3D12_BLEND_INV_DEST_COLOR: D3D12_BLEND = D3D12_BLEND(10i32);
pub const D3D12_BLEND_SRC_ALPHA_SAT: D3D12_BLEND = D3D12_BLEND(11i32);
pub const D3D12_BLEND_BLEND_FACTOR: D3D12_BLEND = D3D12_BLEND(14i32);
pub const D3D12_BLEND_INV_BLEND_FACTOR: D3D12_BLEND = D3D12_BLEND(15i32);
pub const D3D12_BLEND_SRC1_COLOR: D3D12_BLEND = D3D12_BLEND(16i32);
pub const D3D12_BLEND_INV_SRC1_COLOR: D3D12_BLEND = D3D12_BLEND(17i32);
pub const D3D12_BLEND_SRC1_ALPHA: D3D12_BLEND = D3D12_BLEND(18i32);
pub const D3D12_BLEND_INV_SRC1_ALPHA: D3D12_BLEND = D3D12_BLEND(19i32);
impl ::std::convert::From<i32> for D3D12_BLEND {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_BLEND {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_BLEND_DESC {
    pub AlphaToCoverageEnable: super::super::Foundation::BOOL,
    pub IndependentBlendEnable: super::super::Foundation::BOOL,
    pub RenderTarget: [D3D12_RENDER_TARGET_BLEND_DESC; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_BLEND_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_BLEND_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_BLEND_DESC").field("AlphaToCoverageEnable", &self.AlphaToCoverageEnable).field("IndependentBlendEnable", &self.IndependentBlendEnable).field("RenderTarget", &self.RenderTarget).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_BLEND_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.AlphaToCoverageEnable == other.AlphaToCoverageEnable && self.IndependentBlendEnable == other.IndependentBlendEnable && self.RenderTarget == other.RenderTarget
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_BLEND_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_BLEND_OP(pub i32);
pub const D3D12_BLEND_OP_ADD: D3D12_BLEND_OP = D3D12_BLEND_OP(1i32);
pub const D3D12_BLEND_OP_SUBTRACT: D3D12_BLEND_OP = D3D12_BLEND_OP(2i32);
pub const D3D12_BLEND_OP_REV_SUBTRACT: D3D12_BLEND_OP = D3D12_BLEND_OP(3i32);
pub const D3D12_BLEND_OP_MIN: D3D12_BLEND_OP = D3D12_BLEND_OP(4i32);
pub const D3D12_BLEND_OP_MAX: D3D12_BLEND_OP = D3D12_BLEND_OP(5i32);
impl ::std::convert::From<i32> for D3D12_BLEND_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_BLEND_OP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_BOX {
    pub left: u32,
    pub top: u32,
    pub front: u32,
    pub right: u32,
    pub bottom: u32,
    pub back: u32,
}
impl D3D12_BOX {}
impl ::std::default::Default for D3D12_BOX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_BOX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_BOX").field("left", &self.left).field("top", &self.top).field("front", &self.front).field("right", &self.right).field("bottom", &self.bottom).field("back", &self.back).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_BOX {
    fn eq(&self, other: &Self) -> bool {
        self.left == other.left && self.top == other.top && self.front == other.front && self.right == other.right && self.bottom == other.bottom && self.back == other.back
    }
}
impl ::std::cmp::Eq for D3D12_BOX {}
unsafe impl ::windows::runtime::Abi for D3D12_BOX {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_BUFFER_RTV {
    pub FirstElement: u64,
    pub NumElements: u32,
}
impl D3D12_BUFFER_RTV {}
impl ::std::default::Default for D3D12_BUFFER_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_BUFFER_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_BUFFER_RTV").field("FirstElement", &self.FirstElement).field("NumElements", &self.NumElements).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_BUFFER_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstElement == other.FirstElement && self.NumElements == other.NumElements
    }
}
impl ::std::cmp::Eq for D3D12_BUFFER_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_BUFFER_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_BUFFER_SRV {
    pub FirstElement: u64,
    pub NumElements: u32,
    pub StructureByteStride: u32,
    pub Flags: D3D12_BUFFER_SRV_FLAGS,
}
impl D3D12_BUFFER_SRV {}
impl ::std::default::Default for D3D12_BUFFER_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_BUFFER_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_BUFFER_SRV").field("FirstElement", &self.FirstElement).field("NumElements", &self.NumElements).field("StructureByteStride", &self.StructureByteStride).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_BUFFER_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstElement == other.FirstElement && self.NumElements == other.NumElements && self.StructureByteStride == other.StructureByteStride && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_BUFFER_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_BUFFER_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_BUFFER_SRV_FLAGS(pub u32);
pub const D3D12_BUFFER_SRV_FLAG_NONE: D3D12_BUFFER_SRV_FLAGS = D3D12_BUFFER_SRV_FLAGS(0u32);
pub const D3D12_BUFFER_SRV_FLAG_RAW: D3D12_BUFFER_SRV_FLAGS = D3D12_BUFFER_SRV_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_BUFFER_SRV_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_BUFFER_SRV_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_BUFFER_SRV_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_BUFFER_SRV_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_BUFFER_SRV_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_BUFFER_SRV_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_BUFFER_SRV_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_BUFFER_UAV {
    pub FirstElement: u64,
    pub NumElements: u32,
    pub StructureByteStride: u32,
    pub CounterOffsetInBytes: u64,
    pub Flags: D3D12_BUFFER_UAV_FLAGS,
}
impl D3D12_BUFFER_UAV {}
impl ::std::default::Default for D3D12_BUFFER_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_BUFFER_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_BUFFER_UAV").field("FirstElement", &self.FirstElement).field("NumElements", &self.NumElements).field("StructureByteStride", &self.StructureByteStride).field("CounterOffsetInBytes", &self.CounterOffsetInBytes).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_BUFFER_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstElement == other.FirstElement && self.NumElements == other.NumElements && self.StructureByteStride == other.StructureByteStride && self.CounterOffsetInBytes == other.CounterOffsetInBytes && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_BUFFER_UAV {}
unsafe impl ::windows::runtime::Abi for D3D12_BUFFER_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_BUFFER_UAV_FLAGS(pub u32);
pub const D3D12_BUFFER_UAV_FLAG_NONE: D3D12_BUFFER_UAV_FLAGS = D3D12_BUFFER_UAV_FLAGS(0u32);
pub const D3D12_BUFFER_UAV_FLAG_RAW: D3D12_BUFFER_UAV_FLAGS = D3D12_BUFFER_UAV_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_BUFFER_UAV_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_BUFFER_UAV_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_BUFFER_UAV_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_BUFFER_UAV_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_BUFFER_UAV_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_BUFFER_UAV_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_BUFFER_UAV_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {
    pub DestAccelerationStructureData: u64,
    pub Inputs: D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS,
    pub SourceAccelerationStructureData: u64,
    pub ScratchAccelerationStructureData: u64,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {
    pub Type: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE,
    pub Flags: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS,
    pub NumDescs: u32,
    pub DescsLayout: D3D12_ELEMENTS_LAYOUT,
    pub Anonymous: D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub union D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS_0 {
    pub InstanceDescs: u64,
    pub pGeometryDescs: *mut D3D12_RAYTRACING_GEOMETRY_DESC,
    pub ppGeometryDescs: *mut *mut D3D12_RAYTRACING_GEOMETRY_DESC,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INPUTS_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER {
    pub Type: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE,
    pub NumDescs: u32,
}
impl D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER {}
impl ::std::default::Default for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER").field("Type", &self.Type).field("NumDescs", &self.NumDescs).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.NumDescs == other.NumDescs
    }
}
impl ::std::cmp::Eq for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER {}
unsafe impl ::windows::runtime::Abi for D3D12_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_TOOLS_VISUALIZATION_HEADER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_CACHED_PIPELINE_STATE {
    pub pCachedBlob: *mut ::std::ffi::c_void,
    pub CachedBlobSizeInBytes: usize,
}
impl D3D12_CACHED_PIPELINE_STATE {}
impl ::std::default::Default for D3D12_CACHED_PIPELINE_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_CACHED_PIPELINE_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_CACHED_PIPELINE_STATE").field("pCachedBlob", &self.pCachedBlob).field("CachedBlobSizeInBytes", &self.CachedBlobSizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_CACHED_PIPELINE_STATE {
    fn eq(&self, other: &Self) -> bool {
        self.pCachedBlob == other.pCachedBlob && self.CachedBlobSizeInBytes == other.CachedBlobSizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_CACHED_PIPELINE_STATE {}
unsafe impl ::windows::runtime::Abi for D3D12_CACHED_PIPELINE_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_CLEAR_FLAGS(pub u32);
pub const D3D12_CLEAR_FLAG_DEPTH: D3D12_CLEAR_FLAGS = D3D12_CLEAR_FLAGS(1u32);
pub const D3D12_CLEAR_FLAG_STENCIL: D3D12_CLEAR_FLAGS = D3D12_CLEAR_FLAGS(2u32);
impl ::std::convert::From<u32> for D3D12_CLEAR_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_CLEAR_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_CLEAR_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_CLEAR_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_CLEAR_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_CLEAR_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_CLEAR_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_CLEAR_VALUE {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub Anonymous: D3D12_CLEAR_VALUE_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_CLEAR_VALUE {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_CLEAR_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_CLEAR_VALUE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_CLEAR_VALUE {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_CLEAR_VALUE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_CLEAR_VALUE_0 {
    pub Color: [f32; 4],
    pub DepthStencil: D3D12_DEPTH_STENCIL_VALUE,
}
impl D3D12_CLEAR_VALUE_0 {}
impl ::std::default::Default for D3D12_CLEAR_VALUE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_CLEAR_VALUE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_CLEAR_VALUE_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_CLEAR_VALUE_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_CLIP_OR_CULL_DISTANCE_COUNT: u32 = 8u32;
pub const D3D12_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: u32 = 2u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COLOR_WRITE_ENABLE(pub i32);
pub const D3D12_COLOR_WRITE_ENABLE_RED: D3D12_COLOR_WRITE_ENABLE = D3D12_COLOR_WRITE_ENABLE(1i32);
pub const D3D12_COLOR_WRITE_ENABLE_GREEN: D3D12_COLOR_WRITE_ENABLE = D3D12_COLOR_WRITE_ENABLE(2i32);
pub const D3D12_COLOR_WRITE_ENABLE_BLUE: D3D12_COLOR_WRITE_ENABLE = D3D12_COLOR_WRITE_ENABLE(4i32);
pub const D3D12_COLOR_WRITE_ENABLE_ALPHA: D3D12_COLOR_WRITE_ENABLE = D3D12_COLOR_WRITE_ENABLE(8i32);
pub const D3D12_COLOR_WRITE_ENABLE_ALL: D3D12_COLOR_WRITE_ENABLE = D3D12_COLOR_WRITE_ENABLE(15i32);
impl ::std::convert::From<i32> for D3D12_COLOR_WRITE_ENABLE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COLOR_WRITE_ENABLE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMMAND_LIST_FLAGS(pub u32);
pub const D3D12_COMMAND_LIST_FLAG_NONE: D3D12_COMMAND_LIST_FLAGS = D3D12_COMMAND_LIST_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D12_COMMAND_LIST_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_LIST_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_COMMAND_LIST_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_COMMAND_LIST_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_COMMAND_LIST_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_COMMAND_LIST_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_COMMAND_LIST_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMMAND_LIST_SUPPORT_FLAGS(pub u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_NONE: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(0u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_DIRECT: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(1u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_BUNDLE: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(2u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_COMPUTE: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(4u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_COPY: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(8u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_VIDEO_DECODE: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(16u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_VIDEO_PROCESS: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(32u32);
pub const D3D12_COMMAND_LIST_SUPPORT_FLAG_VIDEO_ENCODE: D3D12_COMMAND_LIST_SUPPORT_FLAGS = D3D12_COMMAND_LIST_SUPPORT_FLAGS(64u32);
impl ::std::convert::From<u32> for D3D12_COMMAND_LIST_SUPPORT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_LIST_SUPPORT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_COMMAND_LIST_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_COMMAND_LIST_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_COMMAND_LIST_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_COMMAND_LIST_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_COMMAND_LIST_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMMAND_LIST_TYPE(pub i32);
pub const D3D12_COMMAND_LIST_TYPE_DIRECT: D3D12_COMMAND_LIST_TYPE = D3D12_COMMAND_LIST_TYPE(0i32);
pub const D3D12_COMMAND_LIST_TYPE_BUNDLE: D3D12_COMMAND_LIST_TYPE = D3D12_COMMAND_LIST_TYPE(1i32);
pub const D3D12_COMMAND_LIST_TYPE_COMPUTE: D3D12_COMMAND_LIST_TYPE = D3D12_COMMAND_LIST_TYPE(2i32);
pub const D3D12_COMMAND_LIST_TYPE_COPY: D3D12_COMMAND_LIST_TYPE = D3D12_COMMAND_LIST_TYPE(3i32);
pub const D3D12_COMMAND_LIST_TYPE_VIDEO_DECODE: D3D12_COMMAND_LIST_TYPE = D3D12_COMMAND_LIST_TYPE(4i32);
pub const D3D12_COMMAND_LIST_TYPE_VIDEO_PROCESS: D3D12_COMMAND_LIST_TYPE = D3D12_COMMAND_LIST_TYPE(5i32);
pub const D3D12_COMMAND_LIST_TYPE_VIDEO_ENCODE: D3D12_COMMAND_LIST_TYPE = D3D12_COMMAND_LIST_TYPE(6i32);
impl ::std::convert::From<i32> for D3D12_COMMAND_LIST_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_LIST_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMMAND_POOL_FLAGS(pub u32);
pub const D3D12_COMMAND_POOL_FLAG_NONE: D3D12_COMMAND_POOL_FLAGS = D3D12_COMMAND_POOL_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D12_COMMAND_POOL_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_POOL_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_COMMAND_POOL_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_COMMAND_POOL_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_COMMAND_POOL_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_COMMAND_POOL_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_COMMAND_POOL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_COMMAND_QUEUE_DESC {
    pub Type: D3D12_COMMAND_LIST_TYPE,
    pub Priority: i32,
    pub Flags: D3D12_COMMAND_QUEUE_FLAGS,
    pub NodeMask: u32,
}
impl D3D12_COMMAND_QUEUE_DESC {}
impl ::std::default::Default for D3D12_COMMAND_QUEUE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_COMMAND_QUEUE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_COMMAND_QUEUE_DESC").field("Type", &self.Type).field("Priority", &self.Priority).field("Flags", &self.Flags).field("NodeMask", &self.NodeMask).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_COMMAND_QUEUE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.Priority == other.Priority && self.Flags == other.Flags && self.NodeMask == other.NodeMask
    }
}
impl ::std::cmp::Eq for D3D12_COMMAND_QUEUE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_QUEUE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMMAND_QUEUE_FLAGS(pub u32);
pub const D3D12_COMMAND_QUEUE_FLAG_NONE: D3D12_COMMAND_QUEUE_FLAGS = D3D12_COMMAND_QUEUE_FLAGS(0u32);
pub const D3D12_COMMAND_QUEUE_FLAG_DISABLE_GPU_TIMEOUT: D3D12_COMMAND_QUEUE_FLAGS = D3D12_COMMAND_QUEUE_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_COMMAND_QUEUE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_QUEUE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_COMMAND_QUEUE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_COMMAND_QUEUE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_COMMAND_QUEUE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_COMMAND_QUEUE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_COMMAND_QUEUE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMMAND_QUEUE_PRIORITY(pub i32);
pub const D3D12_COMMAND_QUEUE_PRIORITY_NORMAL: D3D12_COMMAND_QUEUE_PRIORITY = D3D12_COMMAND_QUEUE_PRIORITY(0i32);
pub const D3D12_COMMAND_QUEUE_PRIORITY_HIGH: D3D12_COMMAND_QUEUE_PRIORITY = D3D12_COMMAND_QUEUE_PRIORITY(100i32);
pub const D3D12_COMMAND_QUEUE_PRIORITY_GLOBAL_REALTIME: D3D12_COMMAND_QUEUE_PRIORITY = D3D12_COMMAND_QUEUE_PRIORITY(10000i32);
impl ::std::convert::From<i32> for D3D12_COMMAND_QUEUE_PRIORITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_QUEUE_PRIORITY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMMAND_RECORDER_FLAGS(pub u32);
pub const D3D12_COMMAND_RECORDER_FLAG_NONE: D3D12_COMMAND_RECORDER_FLAGS = D3D12_COMMAND_RECORDER_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D12_COMMAND_RECORDER_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_RECORDER_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_COMMAND_RECORDER_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_COMMAND_RECORDER_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_COMMAND_RECORDER_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_COMMAND_RECORDER_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_COMMAND_RECORDER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_COMMAND_SIGNATURE_DESC {
    pub ByteStride: u32,
    pub NumArgumentDescs: u32,
    pub pArgumentDescs: *mut D3D12_INDIRECT_ARGUMENT_DESC,
    pub NodeMask: u32,
}
impl D3D12_COMMAND_SIGNATURE_DESC {}
impl ::std::default::Default for D3D12_COMMAND_SIGNATURE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_COMMAND_SIGNATURE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_COMMAND_SIGNATURE_DESC").field("ByteStride", &self.ByteStride).field("NumArgumentDescs", &self.NumArgumentDescs).field("pArgumentDescs", &self.pArgumentDescs).field("NodeMask", &self.NodeMask).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_COMMAND_SIGNATURE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.ByteStride == other.ByteStride && self.NumArgumentDescs == other.NumArgumentDescs && self.pArgumentDescs == other.pArgumentDescs && self.NodeMask == other.NodeMask
    }
}
impl ::std::cmp::Eq for D3D12_COMMAND_SIGNATURE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_COMMAND_SIGNATURE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT: u32 = 14u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS: u32 = 4u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT: u32 = 15u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT: u32 = 16u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT: u32 = 15u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D12_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT: u32 = 64u32;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D12_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT: u32 = 128u32;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT: u32 = 128u32;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_COUNT: u32 = 16u32;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D12_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_COMMONSHADER_SAMPLER_SLOT_COUNT: u32 = 16u32;
pub const D3D12_COMMONSHADER_SUBROUTINE_NESTING_LIMIT: u32 = 32u32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_COUNT: u32 = 4096u32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_READS_PER_INST: u32 = 3u32;
pub const D3D12_COMMONSHADER_TEMP_REGISTER_READ_PORTS: u32 = 3u32;
pub const D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX: u32 = 10u32;
pub const D3D12_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN: i32 = -10i32;
pub const D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE: i32 = -8i32;
pub const D3D12_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE: u32 = 7u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMPARISON_FUNC(pub i32);
pub const D3D12_COMPARISON_FUNC_NEVER: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(1i32);
pub const D3D12_COMPARISON_FUNC_LESS: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(2i32);
pub const D3D12_COMPARISON_FUNC_EQUAL: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(3i32);
pub const D3D12_COMPARISON_FUNC_LESS_EQUAL: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(4i32);
pub const D3D12_COMPARISON_FUNC_GREATER: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(5i32);
pub const D3D12_COMPARISON_FUNC_NOT_EQUAL: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(6i32);
pub const D3D12_COMPARISON_FUNC_GREATER_EQUAL: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(7i32);
pub const D3D12_COMPARISON_FUNC_ALWAYS: D3D12_COMPARISON_FUNC = D3D12_COMPARISON_FUNC(8i32);
impl ::std::convert::From<i32> for D3D12_COMPARISON_FUNC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMPARISON_FUNC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_COMPATIBILITY_SHARED_FLAGS(pub u32);
pub const D3D12_COMPATIBILITY_SHARED_FLAG_NONE: D3D12_COMPATIBILITY_SHARED_FLAGS = D3D12_COMPATIBILITY_SHARED_FLAGS(0u32);
pub const D3D12_COMPATIBILITY_SHARED_FLAG_NON_NT_HANDLE: D3D12_COMPATIBILITY_SHARED_FLAGS = D3D12_COMPATIBILITY_SHARED_FLAGS(1u32);
pub const D3D12_COMPATIBILITY_SHARED_FLAG_KEYED_MUTEX: D3D12_COMPATIBILITY_SHARED_FLAGS = D3D12_COMPATIBILITY_SHARED_FLAGS(2u32);
pub const D3D12_COMPATIBILITY_SHARED_FLAG_9_ON_12: D3D12_COMPATIBILITY_SHARED_FLAGS = D3D12_COMPATIBILITY_SHARED_FLAGS(4u32);
impl ::std::convert::From<u32> for D3D12_COMPATIBILITY_SHARED_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_COMPATIBILITY_SHARED_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_COMPATIBILITY_SHARED_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_COMPATIBILITY_SHARED_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_COMPATIBILITY_SHARED_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_COMPATIBILITY_SHARED_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_COMPATIBILITY_SHARED_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D3D12_COMPUTE_PIPELINE_STATE_DESC {
    pub pRootSignature: ::std::option::Option<ID3D12RootSignature>,
    pub CS: D3D12_SHADER_BYTECODE,
    pub NodeMask: u32,
    pub CachedPSO: D3D12_CACHED_PIPELINE_STATE,
    pub Flags: D3D12_PIPELINE_STATE_FLAGS,
}
impl D3D12_COMPUTE_PIPELINE_STATE_DESC {}
impl ::std::default::Default for D3D12_COMPUTE_PIPELINE_STATE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_COMPUTE_PIPELINE_STATE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_COMPUTE_PIPELINE_STATE_DESC").field("pRootSignature", &self.pRootSignature).field("CS", &self.CS).field("NodeMask", &self.NodeMask).field("CachedPSO", &self.CachedPSO).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_COMPUTE_PIPELINE_STATE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.pRootSignature == other.pRootSignature && self.CS == other.CS && self.NodeMask == other.NodeMask && self.CachedPSO == other.CachedPSO && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_COMPUTE_PIPELINE_STATE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_COMPUTE_PIPELINE_STATE_DESC {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_CONSERVATIVE_RASTERIZATION_MODE(pub i32);
pub const D3D12_CONSERVATIVE_RASTERIZATION_MODE_OFF: D3D12_CONSERVATIVE_RASTERIZATION_MODE = D3D12_CONSERVATIVE_RASTERIZATION_MODE(0i32);
pub const D3D12_CONSERVATIVE_RASTERIZATION_MODE_ON: D3D12_CONSERVATIVE_RASTERIZATION_MODE = D3D12_CONSERVATIVE_RASTERIZATION_MODE(1i32);
impl ::std::convert::From<i32> for D3D12_CONSERVATIVE_RASTERIZATION_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_CONSERVATIVE_RASTERIZATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_CONSERVATIVE_RASTERIZATION_TIER(pub i32);
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_NOT_SUPPORTED: D3D12_CONSERVATIVE_RASTERIZATION_TIER = D3D12_CONSERVATIVE_RASTERIZATION_TIER(0i32);
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_1: D3D12_CONSERVATIVE_RASTERIZATION_TIER = D3D12_CONSERVATIVE_RASTERIZATION_TIER(1i32);
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_2: D3D12_CONSERVATIVE_RASTERIZATION_TIER = D3D12_CONSERVATIVE_RASTERIZATION_TIER(2i32);
pub const D3D12_CONSERVATIVE_RASTERIZATION_TIER_3: D3D12_CONSERVATIVE_RASTERIZATION_TIER = D3D12_CONSERVATIVE_RASTERIZATION_TIER(3i32);
impl ::std::convert::From<i32> for D3D12_CONSERVATIVE_RASTERIZATION_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_CONSERVATIVE_RASTERIZATION_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_CONSTANT_BUFFER_DATA_PLACEMENT_ALIGNMENT: u32 = 256u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_CONSTANT_BUFFER_VIEW_DESC {
    pub BufferLocation: u64,
    pub SizeInBytes: u32,
}
impl D3D12_CONSTANT_BUFFER_VIEW_DESC {}
impl ::std::default::Default for D3D12_CONSTANT_BUFFER_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_CONSTANT_BUFFER_VIEW_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_CONSTANT_BUFFER_VIEW_DESC").field("BufferLocation", &self.BufferLocation).field("SizeInBytes", &self.SizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_CONSTANT_BUFFER_VIEW_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.BufferLocation == other.BufferLocation && self.SizeInBytes == other.SizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_CONSTANT_BUFFER_VIEW_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_CONSTANT_BUFFER_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_CPU_DESCRIPTOR_HANDLE {
    pub ptr: usize,
}
impl D3D12_CPU_DESCRIPTOR_HANDLE {}
impl ::std::default::Default for D3D12_CPU_DESCRIPTOR_HANDLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_CPU_DESCRIPTOR_HANDLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_CPU_DESCRIPTOR_HANDLE").field("ptr", &self.ptr).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_CPU_DESCRIPTOR_HANDLE {
    fn eq(&self, other: &Self) -> bool {
        self.ptr == other.ptr
    }
}
impl ::std::cmp::Eq for D3D12_CPU_DESCRIPTOR_HANDLE {}
unsafe impl ::windows::runtime::Abi for D3D12_CPU_DESCRIPTOR_HANDLE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_CPU_PAGE_PROPERTY(pub i32);
pub const D3D12_CPU_PAGE_PROPERTY_UNKNOWN: D3D12_CPU_PAGE_PROPERTY = D3D12_CPU_PAGE_PROPERTY(0i32);
pub const D3D12_CPU_PAGE_PROPERTY_NOT_AVAILABLE: D3D12_CPU_PAGE_PROPERTY = D3D12_CPU_PAGE_PROPERTY(1i32);
pub const D3D12_CPU_PAGE_PROPERTY_WRITE_COMBINE: D3D12_CPU_PAGE_PROPERTY = D3D12_CPU_PAGE_PROPERTY(2i32);
pub const D3D12_CPU_PAGE_PROPERTY_WRITE_BACK: D3D12_CPU_PAGE_PROPERTY = D3D12_CPU_PAGE_PROPERTY(3i32);
impl ::std::convert::From<i32> for D3D12_CPU_PAGE_PROPERTY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_CPU_PAGE_PROPERTY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_CROSS_NODE_SHARING_TIER(pub i32);
pub const D3D12_CROSS_NODE_SHARING_TIER_NOT_SUPPORTED: D3D12_CROSS_NODE_SHARING_TIER = D3D12_CROSS_NODE_SHARING_TIER(0i32);
pub const D3D12_CROSS_NODE_SHARING_TIER_1_EMULATED: D3D12_CROSS_NODE_SHARING_TIER = D3D12_CROSS_NODE_SHARING_TIER(1i32);
pub const D3D12_CROSS_NODE_SHARING_TIER_1: D3D12_CROSS_NODE_SHARING_TIER = D3D12_CROSS_NODE_SHARING_TIER(2i32);
pub const D3D12_CROSS_NODE_SHARING_TIER_2: D3D12_CROSS_NODE_SHARING_TIER = D3D12_CROSS_NODE_SHARING_TIER(3i32);
pub const D3D12_CROSS_NODE_SHARING_TIER_3: D3D12_CROSS_NODE_SHARING_TIER = D3D12_CROSS_NODE_SHARING_TIER(4i32);
impl ::std::convert::From<i32> for D3D12_CROSS_NODE_SHARING_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_CROSS_NODE_SHARING_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 256u32;
pub const D3D12_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP: u32 = 64u32;
pub const D3D12_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 240u32;
pub const D3D12_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP: u32 = 68u32;
pub const D3D12_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 224u32;
pub const D3D12_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP: u32 = 72u32;
pub const D3D12_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 208u32;
pub const D3D12_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP: u32 = 76u32;
pub const D3D12_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 192u32;
pub const D3D12_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP: u32 = 84u32;
pub const D3D12_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 176u32;
pub const D3D12_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP: u32 = 92u32;
pub const D3D12_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 160u32;
pub const D3D12_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP: u32 = 100u32;
pub const D3D12_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 144u32;
pub const D3D12_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP: u32 = 112u32;
pub const D3D12_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 128u32;
pub const D3D12_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP: u32 = 128u32;
pub const D3D12_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 112u32;
pub const D3D12_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP: u32 = 144u32;
pub const D3D12_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 96u32;
pub const D3D12_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP: u32 = 168u32;
pub const D3D12_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 80u32;
pub const D3D12_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP: u32 = 204u32;
pub const D3D12_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 64u32;
pub const D3D12_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP: u32 = 256u32;
pub const D3D12_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 48u32;
pub const D3D12_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP: u32 = 340u32;
pub const D3D12_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 32u32;
pub const D3D12_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP: u32 = 512u32;
pub const D3D12_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 16u32;
pub const D3D12_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP: u32 = 768u32;
pub const D3D12_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION: u32 = 1u32;
pub const D3D12_CS_4_X_RAW_UAV_BYTE_ALIGNMENT: u32 = 256u32;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 = 768u32;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_X: u32 = 768u32;
pub const D3D12_CS_4_X_THREAD_GROUP_MAX_Y: u32 = 768u32;
pub const D3D12_CS_4_X_UAV_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION: u32 = 65535u32;
pub const D3D12_CS_TGSM_REGISTER_COUNT: u32 = 8192u32;
pub const D3D12_CS_TGSM_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D12_CS_TGSM_RESOURCE_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_CS_TGSM_RESOURCE_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_CS_THREADGROUPID_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D12_CS_THREADGROUPID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_CS_THREADIDINGROUP_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D12_CS_THREADIDINGROUP_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_CS_THREADID_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D12_CS_THREADID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 = 1024u32;
pub const D3D12_CS_THREAD_GROUP_MAX_X: u32 = 1024u32;
pub const D3D12_CS_THREAD_GROUP_MAX_Y: u32 = 1024u32;
pub const D3D12_CS_THREAD_GROUP_MAX_Z: u32 = 64u32;
pub const D3D12_CS_THREAD_GROUP_MIN_X: u32 = 1u32;
pub const D3D12_CS_THREAD_GROUP_MIN_Y: u32 = 1u32;
pub const D3D12_CS_THREAD_GROUP_MIN_Z: u32 = 1u32;
pub const D3D12_CS_THREAD_LOCAL_TEMP_REGISTER_POOL: u32 = 16384u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_CULL_MODE(pub i32);
pub const D3D12_CULL_MODE_NONE: D3D12_CULL_MODE = D3D12_CULL_MODE(1i32);
pub const D3D12_CULL_MODE_FRONT: D3D12_CULL_MODE = D3D12_CULL_MODE(2i32);
pub const D3D12_CULL_MODE_BACK: D3D12_CULL_MODE = D3D12_CULL_MODE(3i32);
impl ::std::convert::From<i32> for D3D12_CULL_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_CULL_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    pub ShaderPatchMode: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE,
}
impl D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {}
impl ::std::default::Default for D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS").field("ShaderPatchMode", &self.ShaderPatchMode).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    fn eq(&self, other: &Self) -> bool {
        self.ShaderPatchMode == other.ShaderPatchMode
    }
}
impl ::std::cmp::Eq for D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {}
unsafe impl ::windows::runtime::Abi for D3D12_DEBUG_COMMAND_LIST_GPU_BASED_VALIDATION_SETTINGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE(pub i32);
pub const D3D12_DEBUG_COMMAND_LIST_PARAMETER_GPU_BASED_VALIDATION_SETTINGS: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE = D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE(0i32);
impl ::std::convert::From<i32> for D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    pub MaxMessagesPerCommandList: u32,
    pub DefaultShaderPatchMode: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE,
    pub PipelineStateCreateFlags: D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS,
}
impl D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {}
impl ::std::default::Default for D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS").field("MaxMessagesPerCommandList", &self.MaxMessagesPerCommandList).field("DefaultShaderPatchMode", &self.DefaultShaderPatchMode).field("PipelineStateCreateFlags", &self.PipelineStateCreateFlags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    fn eq(&self, other: &Self) -> bool {
        self.MaxMessagesPerCommandList == other.MaxMessagesPerCommandList && self.DefaultShaderPatchMode == other.DefaultShaderPatchMode && self.PipelineStateCreateFlags == other.PipelineStateCreateFlags
    }
}
impl ::std::cmp::Eq for D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {}
unsafe impl ::windows::runtime::Abi for D3D12_DEBUG_DEVICE_GPU_BASED_VALIDATION_SETTINGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {
    pub SlowdownFactor: f32,
}
impl D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {}
impl ::std::default::Default for D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR").field("SlowdownFactor", &self.SlowdownFactor).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {
    fn eq(&self, other: &Self) -> bool {
        self.SlowdownFactor == other.SlowdownFactor
    }
}
impl ::std::cmp::Eq for D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {}
unsafe impl ::windows::runtime::Abi for D3D12_DEBUG_DEVICE_GPU_SLOWDOWN_PERFORMANCE_FACTOR {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DEBUG_DEVICE_PARAMETER_TYPE(pub i32);
pub const D3D12_DEBUG_DEVICE_PARAMETER_FEATURE_FLAGS: D3D12_DEBUG_DEVICE_PARAMETER_TYPE = D3D12_DEBUG_DEVICE_PARAMETER_TYPE(0i32);
pub const D3D12_DEBUG_DEVICE_PARAMETER_GPU_BASED_VALIDATION_SETTINGS: D3D12_DEBUG_DEVICE_PARAMETER_TYPE = D3D12_DEBUG_DEVICE_PARAMETER_TYPE(1i32);
pub const D3D12_DEBUG_DEVICE_PARAMETER_GPU_SLOWDOWN_PERFORMANCE_FACTOR: D3D12_DEBUG_DEVICE_PARAMETER_TYPE = D3D12_DEBUG_DEVICE_PARAMETER_TYPE(2i32);
impl ::std::convert::From<i32> for D3D12_DEBUG_DEVICE_PARAMETER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DEBUG_DEVICE_PARAMETER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DEBUG_FEATURE(pub i32);
pub const D3D12_DEBUG_FEATURE_NONE: D3D12_DEBUG_FEATURE = D3D12_DEBUG_FEATURE(0i32);
pub const D3D12_DEBUG_FEATURE_ALLOW_BEHAVIOR_CHANGING_DEBUG_AIDS: D3D12_DEBUG_FEATURE = D3D12_DEBUG_FEATURE(1i32);
pub const D3D12_DEBUG_FEATURE_CONSERVATIVE_RESOURCE_STATE_TRACKING: D3D12_DEBUG_FEATURE = D3D12_DEBUG_FEATURE(2i32);
pub const D3D12_DEBUG_FEATURE_DISABLE_VIRTUALIZED_BUNDLES_VALIDATION: D3D12_DEBUG_FEATURE = D3D12_DEBUG_FEATURE(4i32);
pub const D3D12_DEBUG_FEATURE_EMULATE_WINDOWS7: D3D12_DEBUG_FEATURE = D3D12_DEBUG_FEATURE(8i32);
impl ::std::convert::From<i32> for D3D12_DEBUG_FEATURE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DEBUG_FEATURE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_DEFAULT_BLEND_FACTOR_ALPHA: f32 = 1f32;
pub const D3D12_DEFAULT_BLEND_FACTOR_BLUE: f32 = 1f32;
pub const D3D12_DEFAULT_BLEND_FACTOR_GREEN: f32 = 1f32;
pub const D3D12_DEFAULT_BLEND_FACTOR_RED: f32 = 1f32;
pub const D3D12_DEFAULT_BORDER_COLOR_COMPONENT: f32 = 0f32;
pub const D3D12_DEFAULT_DEPTH_BIAS: i32 = 0i32;
pub const D3D12_DEFAULT_DEPTH_BIAS_CLAMP: f32 = 0f32;
pub const D3D12_DEFAULT_MAX_ANISOTROPY: u32 = 16u32;
pub const D3D12_DEFAULT_MIP_LOD_BIAS: f32 = 0f32;
pub const D3D12_DEFAULT_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 4194304u32;
pub const D3D12_DEFAULT_RENDER_TARGET_ARRAY_INDEX: u32 = 0u32;
pub const D3D12_DEFAULT_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 65536u32;
pub const D3D12_DEFAULT_SAMPLE_MASK: u32 = 4294967295u32;
pub const D3D12_DEFAULT_SCISSOR_ENDX: u32 = 0u32;
pub const D3D12_DEFAULT_SCISSOR_ENDY: u32 = 0u32;
pub const D3D12_DEFAULT_SCISSOR_STARTX: u32 = 0u32;
pub const D3D12_DEFAULT_SCISSOR_STARTY: u32 = 0u32;
pub const D3D12_DEFAULT_SHADER_4_COMPONENT_MAPPING: u32 = 5768u32;
pub const D3D12_DEFAULT_SLOPE_SCALED_DEPTH_BIAS: f32 = 0f32;
pub const D3D12_DEFAULT_STENCIL_READ_MASK: u32 = 255u32;
pub const D3D12_DEFAULT_STENCIL_REFERENCE: u32 = 0u32;
pub const D3D12_DEFAULT_STENCIL_WRITE_MASK: u32 = 255u32;
pub const D3D12_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX: u32 = 0u32;
pub const D3D12_DEFAULT_VIEWPORT_HEIGHT: u32 = 0u32;
pub const D3D12_DEFAULT_VIEWPORT_MAX_DEPTH: f32 = 0f32;
pub const D3D12_DEFAULT_VIEWPORT_MIN_DEPTH: f32 = 0f32;
pub const D3D12_DEFAULT_VIEWPORT_TOPLEFTX: u32 = 0u32;
pub const D3D12_DEFAULT_VIEWPORT_TOPLEFTY: u32 = 0u32;
pub const D3D12_DEFAULT_VIEWPORT_WIDTH: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DEPTH_STENCILOP_DESC {
    pub StencilFailOp: D3D12_STENCIL_OP,
    pub StencilDepthFailOp: D3D12_STENCIL_OP,
    pub StencilPassOp: D3D12_STENCIL_OP,
    pub StencilFunc: D3D12_COMPARISON_FUNC,
}
impl D3D12_DEPTH_STENCILOP_DESC {}
impl ::std::default::Default for D3D12_DEPTH_STENCILOP_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DEPTH_STENCILOP_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEPTH_STENCILOP_DESC").field("StencilFailOp", &self.StencilFailOp).field("StencilDepthFailOp", &self.StencilDepthFailOp).field("StencilPassOp", &self.StencilPassOp).field("StencilFunc", &self.StencilFunc).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DEPTH_STENCILOP_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.StencilFailOp == other.StencilFailOp && self.StencilDepthFailOp == other.StencilDepthFailOp && self.StencilPassOp == other.StencilPassOp && self.StencilFunc == other.StencilFunc
    }
}
impl ::std::cmp::Eq for D3D12_DEPTH_STENCILOP_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_DEPTH_STENCILOP_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DEPTH_STENCIL_DESC {
    pub DepthEnable: super::super::Foundation::BOOL,
    pub DepthWriteMask: D3D12_DEPTH_WRITE_MASK,
    pub DepthFunc: D3D12_COMPARISON_FUNC,
    pub StencilEnable: super::super::Foundation::BOOL,
    pub StencilReadMask: u8,
    pub StencilWriteMask: u8,
    pub FrontFace: D3D12_DEPTH_STENCILOP_DESC,
    pub BackFace: D3D12_DEPTH_STENCILOP_DESC,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DEPTH_STENCIL_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DEPTH_STENCIL_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DEPTH_STENCIL_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEPTH_STENCIL_DESC")
            .field("DepthEnable", &self.DepthEnable)
            .field("DepthWriteMask", &self.DepthWriteMask)
            .field("DepthFunc", &self.DepthFunc)
            .field("StencilEnable", &self.StencilEnable)
            .field("StencilReadMask", &self.StencilReadMask)
            .field("StencilWriteMask", &self.StencilWriteMask)
            .field("FrontFace", &self.FrontFace)
            .field("BackFace", &self.BackFace)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DEPTH_STENCIL_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.DepthEnable == other.DepthEnable && self.DepthWriteMask == other.DepthWriteMask && self.DepthFunc == other.DepthFunc && self.StencilEnable == other.StencilEnable && self.StencilReadMask == other.StencilReadMask && self.StencilWriteMask == other.StencilWriteMask && self.FrontFace == other.FrontFace && self.BackFace == other.BackFace
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DEPTH_STENCIL_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DEPTH_STENCIL_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DEPTH_STENCIL_DESC1 {
    pub DepthEnable: super::super::Foundation::BOOL,
    pub DepthWriteMask: D3D12_DEPTH_WRITE_MASK,
    pub DepthFunc: D3D12_COMPARISON_FUNC,
    pub StencilEnable: super::super::Foundation::BOOL,
    pub StencilReadMask: u8,
    pub StencilWriteMask: u8,
    pub FrontFace: D3D12_DEPTH_STENCILOP_DESC,
    pub BackFace: D3D12_DEPTH_STENCILOP_DESC,
    pub DepthBoundsTestEnable: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DEPTH_STENCIL_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DEPTH_STENCIL_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DEPTH_STENCIL_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEPTH_STENCIL_DESC1")
            .field("DepthEnable", &self.DepthEnable)
            .field("DepthWriteMask", &self.DepthWriteMask)
            .field("DepthFunc", &self.DepthFunc)
            .field("StencilEnable", &self.StencilEnable)
            .field("StencilReadMask", &self.StencilReadMask)
            .field("StencilWriteMask", &self.StencilWriteMask)
            .field("FrontFace", &self.FrontFace)
            .field("BackFace", &self.BackFace)
            .field("DepthBoundsTestEnable", &self.DepthBoundsTestEnable)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DEPTH_STENCIL_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.DepthEnable == other.DepthEnable && self.DepthWriteMask == other.DepthWriteMask && self.DepthFunc == other.DepthFunc && self.StencilEnable == other.StencilEnable && self.StencilReadMask == other.StencilReadMask && self.StencilWriteMask == other.StencilWriteMask && self.FrontFace == other.FrontFace && self.BackFace == other.BackFace && self.DepthBoundsTestEnable == other.DepthBoundsTestEnable
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DEPTH_STENCIL_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DEPTH_STENCIL_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DEPTH_STENCIL_VALUE {
    pub Depth: f32,
    pub Stencil: u8,
}
impl D3D12_DEPTH_STENCIL_VALUE {}
impl ::std::default::Default for D3D12_DEPTH_STENCIL_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DEPTH_STENCIL_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEPTH_STENCIL_VALUE").field("Depth", &self.Depth).field("Stencil", &self.Stencil).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DEPTH_STENCIL_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.Depth == other.Depth && self.Stencil == other.Stencil
    }
}
impl ::std::cmp::Eq for D3D12_DEPTH_STENCIL_VALUE {}
unsafe impl ::windows::runtime::Abi for D3D12_DEPTH_STENCIL_VALUE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_DEPTH_STENCIL_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D12_DSV_DIMENSION,
    pub Flags: D3D12_DSV_FLAGS,
    pub Anonymous: D3D12_DEPTH_STENCIL_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_DEPTH_STENCIL_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_DEPTH_STENCIL_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_DEPTH_STENCIL_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_DEPTH_STENCIL_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_DEPTH_STENCIL_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_DEPTH_STENCIL_VIEW_DESC_0 {
    pub Texture1D: D3D12_TEX1D_DSV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_DSV,
    pub Texture2D: D3D12_TEX2D_DSV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_DSV,
    pub Texture2DMS: D3D12_TEX2DMS_DSV,
    pub Texture2DMSArray: D3D12_TEX2DMS_ARRAY_DSV,
}
impl D3D12_DEPTH_STENCIL_VIEW_DESC_0 {}
impl ::std::default::Default for D3D12_DEPTH_STENCIL_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_DEPTH_STENCIL_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_DEPTH_STENCIL_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_DEPTH_STENCIL_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DEPTH_WRITE_MASK(pub i32);
pub const D3D12_DEPTH_WRITE_MASK_ZERO: D3D12_DEPTH_WRITE_MASK = D3D12_DEPTH_WRITE_MASK(0i32);
pub const D3D12_DEPTH_WRITE_MASK_ALL: D3D12_DEPTH_WRITE_MASK = D3D12_DEPTH_WRITE_MASK(1i32);
impl ::std::convert::From<i32> for D3D12_DEPTH_WRITE_MASK {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DEPTH_WRITE_MASK {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DESCRIPTOR_HEAP_DESC {
    pub Type: D3D12_DESCRIPTOR_HEAP_TYPE,
    pub NumDescriptors: u32,
    pub Flags: D3D12_DESCRIPTOR_HEAP_FLAGS,
    pub NodeMask: u32,
}
impl D3D12_DESCRIPTOR_HEAP_DESC {}
impl ::std::default::Default for D3D12_DESCRIPTOR_HEAP_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DESCRIPTOR_HEAP_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DESCRIPTOR_HEAP_DESC").field("Type", &self.Type).field("NumDescriptors", &self.NumDescriptors).field("Flags", &self.Flags).field("NodeMask", &self.NodeMask).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DESCRIPTOR_HEAP_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.NumDescriptors == other.NumDescriptors && self.Flags == other.Flags && self.NodeMask == other.NodeMask
    }
}
impl ::std::cmp::Eq for D3D12_DESCRIPTOR_HEAP_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_DESCRIPTOR_HEAP_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DESCRIPTOR_HEAP_FLAGS(pub u32);
pub const D3D12_DESCRIPTOR_HEAP_FLAG_NONE: D3D12_DESCRIPTOR_HEAP_FLAGS = D3D12_DESCRIPTOR_HEAP_FLAGS(0u32);
pub const D3D12_DESCRIPTOR_HEAP_FLAG_SHADER_VISIBLE: D3D12_DESCRIPTOR_HEAP_FLAGS = D3D12_DESCRIPTOR_HEAP_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_DESCRIPTOR_HEAP_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DESCRIPTOR_HEAP_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_DESCRIPTOR_HEAP_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_DESCRIPTOR_HEAP_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_DESCRIPTOR_HEAP_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_DESCRIPTOR_HEAP_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_DESCRIPTOR_HEAP_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DESCRIPTOR_HEAP_TYPE(pub i32);
pub const D3D12_DESCRIPTOR_HEAP_TYPE_CBV_SRV_UAV: D3D12_DESCRIPTOR_HEAP_TYPE = D3D12_DESCRIPTOR_HEAP_TYPE(0i32);
pub const D3D12_DESCRIPTOR_HEAP_TYPE_SAMPLER: D3D12_DESCRIPTOR_HEAP_TYPE = D3D12_DESCRIPTOR_HEAP_TYPE(1i32);
pub const D3D12_DESCRIPTOR_HEAP_TYPE_RTV: D3D12_DESCRIPTOR_HEAP_TYPE = D3D12_DESCRIPTOR_HEAP_TYPE(2i32);
pub const D3D12_DESCRIPTOR_HEAP_TYPE_DSV: D3D12_DESCRIPTOR_HEAP_TYPE = D3D12_DESCRIPTOR_HEAP_TYPE(3i32);
pub const D3D12_DESCRIPTOR_HEAP_TYPE_NUM_TYPES: D3D12_DESCRIPTOR_HEAP_TYPE = D3D12_DESCRIPTOR_HEAP_TYPE(4i32);
impl ::std::convert::From<i32> for D3D12_DESCRIPTOR_HEAP_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DESCRIPTOR_HEAP_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DESCRIPTOR_RANGE {
    pub RangeType: D3D12_DESCRIPTOR_RANGE_TYPE,
    pub NumDescriptors: u32,
    pub BaseShaderRegister: u32,
    pub RegisterSpace: u32,
    pub OffsetInDescriptorsFromTableStart: u32,
}
impl D3D12_DESCRIPTOR_RANGE {}
impl ::std::default::Default for D3D12_DESCRIPTOR_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DESCRIPTOR_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DESCRIPTOR_RANGE")
            .field("RangeType", &self.RangeType)
            .field("NumDescriptors", &self.NumDescriptors)
            .field("BaseShaderRegister", &self.BaseShaderRegister)
            .field("RegisterSpace", &self.RegisterSpace)
            .field("OffsetInDescriptorsFromTableStart", &self.OffsetInDescriptorsFromTableStart)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DESCRIPTOR_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.RangeType == other.RangeType && self.NumDescriptors == other.NumDescriptors && self.BaseShaderRegister == other.BaseShaderRegister && self.RegisterSpace == other.RegisterSpace && self.OffsetInDescriptorsFromTableStart == other.OffsetInDescriptorsFromTableStart
    }
}
impl ::std::cmp::Eq for D3D12_DESCRIPTOR_RANGE {}
unsafe impl ::windows::runtime::Abi for D3D12_DESCRIPTOR_RANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DESCRIPTOR_RANGE1 {
    pub RangeType: D3D12_DESCRIPTOR_RANGE_TYPE,
    pub NumDescriptors: u32,
    pub BaseShaderRegister: u32,
    pub RegisterSpace: u32,
    pub Flags: D3D12_DESCRIPTOR_RANGE_FLAGS,
    pub OffsetInDescriptorsFromTableStart: u32,
}
impl D3D12_DESCRIPTOR_RANGE1 {}
impl ::std::default::Default for D3D12_DESCRIPTOR_RANGE1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DESCRIPTOR_RANGE1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DESCRIPTOR_RANGE1")
            .field("RangeType", &self.RangeType)
            .field("NumDescriptors", &self.NumDescriptors)
            .field("BaseShaderRegister", &self.BaseShaderRegister)
            .field("RegisterSpace", &self.RegisterSpace)
            .field("Flags", &self.Flags)
            .field("OffsetInDescriptorsFromTableStart", &self.OffsetInDescriptorsFromTableStart)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DESCRIPTOR_RANGE1 {
    fn eq(&self, other: &Self) -> bool {
        self.RangeType == other.RangeType && self.NumDescriptors == other.NumDescriptors && self.BaseShaderRegister == other.BaseShaderRegister && self.RegisterSpace == other.RegisterSpace && self.Flags == other.Flags && self.OffsetInDescriptorsFromTableStart == other.OffsetInDescriptorsFromTableStart
    }
}
impl ::std::cmp::Eq for D3D12_DESCRIPTOR_RANGE1 {}
unsafe impl ::windows::runtime::Abi for D3D12_DESCRIPTOR_RANGE1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DESCRIPTOR_RANGE_FLAGS(pub u32);
pub const D3D12_DESCRIPTOR_RANGE_FLAG_NONE: D3D12_DESCRIPTOR_RANGE_FLAGS = D3D12_DESCRIPTOR_RANGE_FLAGS(0u32);
pub const D3D12_DESCRIPTOR_RANGE_FLAG_DESCRIPTORS_VOLATILE: D3D12_DESCRIPTOR_RANGE_FLAGS = D3D12_DESCRIPTOR_RANGE_FLAGS(1u32);
pub const D3D12_DESCRIPTOR_RANGE_FLAG_DATA_VOLATILE: D3D12_DESCRIPTOR_RANGE_FLAGS = D3D12_DESCRIPTOR_RANGE_FLAGS(2u32);
pub const D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE: D3D12_DESCRIPTOR_RANGE_FLAGS = D3D12_DESCRIPTOR_RANGE_FLAGS(4u32);
pub const D3D12_DESCRIPTOR_RANGE_FLAG_DATA_STATIC: D3D12_DESCRIPTOR_RANGE_FLAGS = D3D12_DESCRIPTOR_RANGE_FLAGS(8u32);
pub const D3D12_DESCRIPTOR_RANGE_FLAG_DESCRIPTORS_STATIC_KEEPING_BUFFER_BOUNDS_CHECKS: D3D12_DESCRIPTOR_RANGE_FLAGS = D3D12_DESCRIPTOR_RANGE_FLAGS(65536u32);
impl ::std::convert::From<u32> for D3D12_DESCRIPTOR_RANGE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DESCRIPTOR_RANGE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_DESCRIPTOR_RANGE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_DESCRIPTOR_RANGE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_DESCRIPTOR_RANGE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_DESCRIPTOR_RANGE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_DESCRIPTOR_RANGE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_DESCRIPTOR_RANGE_OFFSET_APPEND: u32 = 4294967295u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DESCRIPTOR_RANGE_TYPE(pub i32);
pub const D3D12_DESCRIPTOR_RANGE_TYPE_SRV: D3D12_DESCRIPTOR_RANGE_TYPE = D3D12_DESCRIPTOR_RANGE_TYPE(0i32);
pub const D3D12_DESCRIPTOR_RANGE_TYPE_UAV: D3D12_DESCRIPTOR_RANGE_TYPE = D3D12_DESCRIPTOR_RANGE_TYPE(1i32);
pub const D3D12_DESCRIPTOR_RANGE_TYPE_CBV: D3D12_DESCRIPTOR_RANGE_TYPE = D3D12_DESCRIPTOR_RANGE_TYPE(2i32);
pub const D3D12_DESCRIPTOR_RANGE_TYPE_SAMPLER: D3D12_DESCRIPTOR_RANGE_TYPE = D3D12_DESCRIPTOR_RANGE_TYPE(3i32);
impl ::std::convert::From<i32> for D3D12_DESCRIPTOR_RANGE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DESCRIPTOR_RANGE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA {
    pub Flags: D3D12_DRED_FLAGS,
    pub pHeadAutoBreadcrumbNode: *mut D3D12_AUTO_BREADCRUMB_NODE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DEVICE_REMOVED_EXTENDED_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DEVICE_REMOVED_EXTENDED_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEVICE_REMOVED_EXTENDED_DATA").field("Flags", &self.Flags).field("pHeadAutoBreadcrumbNode", &self.pHeadAutoBreadcrumbNode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DEVICE_REMOVED_EXTENDED_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags && self.pHeadAutoBreadcrumbNode == other.pHeadAutoBreadcrumbNode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DEVICE_REMOVED_EXTENDED_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DEVICE_REMOVED_EXTENDED_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {
    pub DeviceRemovedReason: ::windows::runtime::HRESULT,
    pub AutoBreadcrumbsOutput: D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT,
    pub PageFaultOutput: D3D12_DRED_PAGE_FAULT_OUTPUT,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEVICE_REMOVED_EXTENDED_DATA1").field("DeviceRemovedReason", &self.DeviceRemovedReason).field("AutoBreadcrumbsOutput", &self.AutoBreadcrumbsOutput).field("PageFaultOutput", &self.PageFaultOutput).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {
    fn eq(&self, other: &Self) -> bool {
        self.DeviceRemovedReason == other.DeviceRemovedReason && self.AutoBreadcrumbsOutput == other.AutoBreadcrumbsOutput && self.PageFaultOutput == other.PageFaultOutput
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DEVICE_REMOVED_EXTENDED_DATA1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {
    pub DeviceRemovedReason: ::windows::runtime::HRESULT,
    pub AutoBreadcrumbsOutput: D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1,
    pub PageFaultOutput: D3D12_DRED_PAGE_FAULT_OUTPUT1,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEVICE_REMOVED_EXTENDED_DATA2").field("DeviceRemovedReason", &self.DeviceRemovedReason).field("AutoBreadcrumbsOutput", &self.AutoBreadcrumbsOutput).field("PageFaultOutput", &self.PageFaultOutput).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {
    fn eq(&self, other: &Self) -> bool {
        self.DeviceRemovedReason == other.DeviceRemovedReason && self.AutoBreadcrumbsOutput == other.AutoBreadcrumbsOutput && self.PageFaultOutput == other.PageFaultOutput
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DEVICE_REMOVED_EXTENDED_DATA2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {
    pub DeviceRemovedReason: ::windows::runtime::HRESULT,
    pub AutoBreadcrumbsOutput: D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1,
    pub PageFaultOutput: D3D12_DRED_PAGE_FAULT_OUTPUT2,
    pub DeviceState: D3D12_DRED_DEVICE_STATE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DEVICE_REMOVED_EXTENDED_DATA3").field("DeviceRemovedReason", &self.DeviceRemovedReason).field("AutoBreadcrumbsOutput", &self.AutoBreadcrumbsOutput).field("PageFaultOutput", &self.PageFaultOutput).field("DeviceState", &self.DeviceState).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {
    fn eq(&self, other: &Self) -> bool {
        self.DeviceRemovedReason == other.DeviceRemovedReason && self.AutoBreadcrumbsOutput == other.AutoBreadcrumbsOutput && self.PageFaultOutput == other.PageFaultOutput && self.DeviceState == other.DeviceState
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DEVICE_REMOVED_EXTENDED_DATA3 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DISCARD_REGION {
    pub NumRects: u32,
    pub pRects: *mut super::super::Foundation::RECT,
    pub FirstSubresource: u32,
    pub NumSubresources: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DISCARD_REGION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DISCARD_REGION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DISCARD_REGION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DISCARD_REGION").field("NumRects", &self.NumRects).field("pRects", &self.pRects).field("FirstSubresource", &self.FirstSubresource).field("NumSubresources", &self.NumSubresources).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DISCARD_REGION {
    fn eq(&self, other: &Self) -> bool {
        self.NumRects == other.NumRects && self.pRects == other.pRects && self.FirstSubresource == other.FirstSubresource && self.NumSubresources == other.NumSubresources
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DISCARD_REGION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DISCARD_REGION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DISPATCH_ARGUMENTS {
    pub ThreadGroupCountX: u32,
    pub ThreadGroupCountY: u32,
    pub ThreadGroupCountZ: u32,
}
impl D3D12_DISPATCH_ARGUMENTS {}
impl ::std::default::Default for D3D12_DISPATCH_ARGUMENTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DISPATCH_ARGUMENTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DISPATCH_ARGUMENTS").field("ThreadGroupCountX", &self.ThreadGroupCountX).field("ThreadGroupCountY", &self.ThreadGroupCountY).field("ThreadGroupCountZ", &self.ThreadGroupCountZ).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DISPATCH_ARGUMENTS {
    fn eq(&self, other: &Self) -> bool {
        self.ThreadGroupCountX == other.ThreadGroupCountX && self.ThreadGroupCountY == other.ThreadGroupCountY && self.ThreadGroupCountZ == other.ThreadGroupCountZ
    }
}
impl ::std::cmp::Eq for D3D12_DISPATCH_ARGUMENTS {}
unsafe impl ::windows::runtime::Abi for D3D12_DISPATCH_ARGUMENTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DISPATCH_MESH_ARGUMENTS {
    pub ThreadGroupCountX: u32,
    pub ThreadGroupCountY: u32,
    pub ThreadGroupCountZ: u32,
}
impl D3D12_DISPATCH_MESH_ARGUMENTS {}
impl ::std::default::Default for D3D12_DISPATCH_MESH_ARGUMENTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DISPATCH_MESH_ARGUMENTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DISPATCH_MESH_ARGUMENTS").field("ThreadGroupCountX", &self.ThreadGroupCountX).field("ThreadGroupCountY", &self.ThreadGroupCountY).field("ThreadGroupCountZ", &self.ThreadGroupCountZ).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DISPATCH_MESH_ARGUMENTS {
    fn eq(&self, other: &Self) -> bool {
        self.ThreadGroupCountX == other.ThreadGroupCountX && self.ThreadGroupCountY == other.ThreadGroupCountY && self.ThreadGroupCountZ == other.ThreadGroupCountZ
    }
}
impl ::std::cmp::Eq for D3D12_DISPATCH_MESH_ARGUMENTS {}
unsafe impl ::windows::runtime::Abi for D3D12_DISPATCH_MESH_ARGUMENTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DISPATCH_RAYS_DESC {
    pub RayGenerationShaderRecord: D3D12_GPU_VIRTUAL_ADDRESS_RANGE,
    pub MissShaderTable: D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE,
    pub HitGroupTable: D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE,
    pub CallableShaderTable: D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE,
    pub Width: u32,
    pub Height: u32,
    pub Depth: u32,
}
impl D3D12_DISPATCH_RAYS_DESC {}
impl ::std::default::Default for D3D12_DISPATCH_RAYS_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DISPATCH_RAYS_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DISPATCH_RAYS_DESC")
            .field("RayGenerationShaderRecord", &self.RayGenerationShaderRecord)
            .field("MissShaderTable", &self.MissShaderTable)
            .field("HitGroupTable", &self.HitGroupTable)
            .field("CallableShaderTable", &self.CallableShaderTable)
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("Depth", &self.Depth)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DISPATCH_RAYS_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.RayGenerationShaderRecord == other.RayGenerationShaderRecord && self.MissShaderTable == other.MissShaderTable && self.HitGroupTable == other.HitGroupTable && self.CallableShaderTable == other.CallableShaderTable && self.Width == other.Width && self.Height == other.Height && self.Depth == other.Depth
    }
}
impl ::std::cmp::Eq for D3D12_DISPATCH_RAYS_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_DISPATCH_RAYS_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DRAW_ARGUMENTS {
    pub VertexCountPerInstance: u32,
    pub InstanceCount: u32,
    pub StartVertexLocation: u32,
    pub StartInstanceLocation: u32,
}
impl D3D12_DRAW_ARGUMENTS {}
impl ::std::default::Default for D3D12_DRAW_ARGUMENTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DRAW_ARGUMENTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRAW_ARGUMENTS").field("VertexCountPerInstance", &self.VertexCountPerInstance).field("InstanceCount", &self.InstanceCount).field("StartVertexLocation", &self.StartVertexLocation).field("StartInstanceLocation", &self.StartInstanceLocation).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DRAW_ARGUMENTS {
    fn eq(&self, other: &Self) -> bool {
        self.VertexCountPerInstance == other.VertexCountPerInstance && self.InstanceCount == other.InstanceCount && self.StartVertexLocation == other.StartVertexLocation && self.StartInstanceLocation == other.StartInstanceLocation
    }
}
impl ::std::cmp::Eq for D3D12_DRAW_ARGUMENTS {}
unsafe impl ::windows::runtime::Abi for D3D12_DRAW_ARGUMENTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_DRAW_INDEXED_ARGUMENTS {
    pub IndexCountPerInstance: u32,
    pub InstanceCount: u32,
    pub StartIndexLocation: u32,
    pub BaseVertexLocation: i32,
    pub StartInstanceLocation: u32,
}
impl D3D12_DRAW_INDEXED_ARGUMENTS {}
impl ::std::default::Default for D3D12_DRAW_INDEXED_ARGUMENTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_DRAW_INDEXED_ARGUMENTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRAW_INDEXED_ARGUMENTS")
            .field("IndexCountPerInstance", &self.IndexCountPerInstance)
            .field("InstanceCount", &self.InstanceCount)
            .field("StartIndexLocation", &self.StartIndexLocation)
            .field("BaseVertexLocation", &self.BaseVertexLocation)
            .field("StartInstanceLocation", &self.StartInstanceLocation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_DRAW_INDEXED_ARGUMENTS {
    fn eq(&self, other: &Self) -> bool {
        self.IndexCountPerInstance == other.IndexCountPerInstance && self.InstanceCount == other.InstanceCount && self.StartIndexLocation == other.StartIndexLocation && self.BaseVertexLocation == other.BaseVertexLocation && self.StartInstanceLocation == other.StartInstanceLocation
    }
}
impl ::std::cmp::Eq for D3D12_DRAW_INDEXED_ARGUMENTS {}
unsafe impl ::windows::runtime::Abi for D3D12_DRAW_INDEXED_ARGUMENTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_ALLOCATION_NODE {
    pub ObjectNameA: *mut u8,
    pub ObjectNameW: super::super::Foundation::PWSTR,
    pub AllocationType: D3D12_DRED_ALLOCATION_TYPE,
    pub pNext: *mut D3D12_DRED_ALLOCATION_NODE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_ALLOCATION_NODE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_ALLOCATION_NODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_ALLOCATION_NODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_ALLOCATION_NODE").field("ObjectNameA", &self.ObjectNameA).field("ObjectNameW", &self.ObjectNameW).field("AllocationType", &self.AllocationType).field("pNext", &self.pNext).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_ALLOCATION_NODE {
    fn eq(&self, other: &Self) -> bool {
        self.ObjectNameA == other.ObjectNameA && self.ObjectNameW == other.ObjectNameW && self.AllocationType == other.AllocationType && self.pNext == other.pNext
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_ALLOCATION_NODE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_ALLOCATION_NODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_ALLOCATION_NODE1 {
    pub ObjectNameA: *mut u8,
    pub ObjectNameW: super::super::Foundation::PWSTR,
    pub AllocationType: D3D12_DRED_ALLOCATION_TYPE,
    pub pNext: *mut D3D12_DRED_ALLOCATION_NODE1,
    pub pObject: ::std::option::Option<::windows::runtime::IUnknown>,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_ALLOCATION_NODE1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_ALLOCATION_NODE1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_ALLOCATION_NODE1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_ALLOCATION_NODE1").field("ObjectNameA", &self.ObjectNameA).field("ObjectNameW", &self.ObjectNameW).field("AllocationType", &self.AllocationType).field("pNext", &self.pNext).field("pObject", &self.pObject).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_ALLOCATION_NODE1 {
    fn eq(&self, other: &Self) -> bool {
        self.ObjectNameA == other.ObjectNameA && self.ObjectNameW == other.ObjectNameW && self.AllocationType == other.AllocationType && self.pNext == other.pNext && self.pObject == other.pObject
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_ALLOCATION_NODE1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_ALLOCATION_NODE1 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DRED_ALLOCATION_TYPE(pub i32);
pub const D3D12_DRED_ALLOCATION_TYPE_COMMAND_QUEUE: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(19i32);
pub const D3D12_DRED_ALLOCATION_TYPE_COMMAND_ALLOCATOR: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(20i32);
pub const D3D12_DRED_ALLOCATION_TYPE_PIPELINE_STATE: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(21i32);
pub const D3D12_DRED_ALLOCATION_TYPE_COMMAND_LIST: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(22i32);
pub const D3D12_DRED_ALLOCATION_TYPE_FENCE: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(23i32);
pub const D3D12_DRED_ALLOCATION_TYPE_DESCRIPTOR_HEAP: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(24i32);
pub const D3D12_DRED_ALLOCATION_TYPE_HEAP: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(25i32);
pub const D3D12_DRED_ALLOCATION_TYPE_QUERY_HEAP: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(27i32);
pub const D3D12_DRED_ALLOCATION_TYPE_COMMAND_SIGNATURE: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(28i32);
pub const D3D12_DRED_ALLOCATION_TYPE_PIPELINE_LIBRARY: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(29i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_DECODER: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(30i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_PROCESSOR: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(32i32);
pub const D3D12_DRED_ALLOCATION_TYPE_RESOURCE: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(34i32);
pub const D3D12_DRED_ALLOCATION_TYPE_PASS: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(35i32);
pub const D3D12_DRED_ALLOCATION_TYPE_CRYPTOSESSION: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(36i32);
pub const D3D12_DRED_ALLOCATION_TYPE_CRYPTOSESSIONPOLICY: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(37i32);
pub const D3D12_DRED_ALLOCATION_TYPE_PROTECTEDRESOURCESESSION: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(38i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_DECODER_HEAP: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(39i32);
pub const D3D12_DRED_ALLOCATION_TYPE_COMMAND_POOL: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(40i32);
pub const D3D12_DRED_ALLOCATION_TYPE_COMMAND_RECORDER: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(41i32);
pub const D3D12_DRED_ALLOCATION_TYPE_STATE_OBJECT: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(42i32);
pub const D3D12_DRED_ALLOCATION_TYPE_METACOMMAND: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(43i32);
pub const D3D12_DRED_ALLOCATION_TYPE_SCHEDULINGGROUP: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(44i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_MOTION_ESTIMATOR: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(45i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_MOTION_VECTOR_HEAP: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(46i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_EXTENSION_COMMAND: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(47i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_ENCODER: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(48i32);
pub const D3D12_DRED_ALLOCATION_TYPE_VIDEO_ENCODER_HEAP: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(49i32);
pub const D3D12_DRED_ALLOCATION_TYPE_INVALID: D3D12_DRED_ALLOCATION_TYPE = D3D12_DRED_ALLOCATION_TYPE(-1i32);
impl ::std::convert::From<i32> for D3D12_DRED_ALLOCATION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DRED_ALLOCATION_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {
    pub pHeadAutoBreadcrumbNode: *mut D3D12_AUTO_BREADCRUMB_NODE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT").field("pHeadAutoBreadcrumbNode", &self.pHeadAutoBreadcrumbNode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.pHeadAutoBreadcrumbNode == other.pHeadAutoBreadcrumbNode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {
    pub pHeadAutoBreadcrumbNode: *mut D3D12_AUTO_BREADCRUMB_NODE1,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1").field("pHeadAutoBreadcrumbNode", &self.pHeadAutoBreadcrumbNode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {
    fn eq(&self, other: &Self) -> bool {
        self.pHeadAutoBreadcrumbNode == other.pHeadAutoBreadcrumbNode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_AUTO_BREADCRUMBS_OUTPUT1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_BREADCRUMB_CONTEXT {
    pub BreadcrumbIndex: u32,
    pub pContextString: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_BREADCRUMB_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_BREADCRUMB_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_BREADCRUMB_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_BREADCRUMB_CONTEXT").field("BreadcrumbIndex", &self.BreadcrumbIndex).field("pContextString", &self.pContextString).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_BREADCRUMB_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.BreadcrumbIndex == other.BreadcrumbIndex && self.pContextString == other.pContextString
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_BREADCRUMB_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_BREADCRUMB_CONTEXT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DRED_DEVICE_STATE(pub i32);
pub const D3D12_DRED_DEVICE_STATE_UNKNOWN: D3D12_DRED_DEVICE_STATE = D3D12_DRED_DEVICE_STATE(0i32);
pub const D3D12_DRED_DEVICE_STATE_HUNG: D3D12_DRED_DEVICE_STATE = D3D12_DRED_DEVICE_STATE(3i32);
pub const D3D12_DRED_DEVICE_STATE_FAULT: D3D12_DRED_DEVICE_STATE = D3D12_DRED_DEVICE_STATE(6i32);
pub const D3D12_DRED_DEVICE_STATE_PAGEFAULT: D3D12_DRED_DEVICE_STATE = D3D12_DRED_DEVICE_STATE(7i32);
impl ::std::convert::From<i32> for D3D12_DRED_DEVICE_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DRED_DEVICE_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DRED_ENABLEMENT(pub i32);
pub const D3D12_DRED_ENABLEMENT_SYSTEM_CONTROLLED: D3D12_DRED_ENABLEMENT = D3D12_DRED_ENABLEMENT(0i32);
pub const D3D12_DRED_ENABLEMENT_FORCED_OFF: D3D12_DRED_ENABLEMENT = D3D12_DRED_ENABLEMENT(1i32);
pub const D3D12_DRED_ENABLEMENT_FORCED_ON: D3D12_DRED_ENABLEMENT = D3D12_DRED_ENABLEMENT(2i32);
impl ::std::convert::From<i32> for D3D12_DRED_ENABLEMENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DRED_ENABLEMENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DRED_FLAGS(pub u32);
pub const D3D12_DRED_FLAG_NONE: D3D12_DRED_FLAGS = D3D12_DRED_FLAGS(0u32);
pub const D3D12_DRED_FLAG_FORCE_ENABLE: D3D12_DRED_FLAGS = D3D12_DRED_FLAGS(1u32);
pub const D3D12_DRED_FLAG_DISABLE_AUTOBREADCRUMBS: D3D12_DRED_FLAGS = D3D12_DRED_FLAGS(2u32);
impl ::std::convert::From<u32> for D3D12_DRED_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DRED_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_DRED_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_DRED_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_DRED_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_DRED_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_DRED_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DRED_PAGE_FAULT_FLAGS(pub u32);
pub const D3D12_DRED_PAGE_FAULT_FLAGS_NONE: D3D12_DRED_PAGE_FAULT_FLAGS = D3D12_DRED_PAGE_FAULT_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D12_DRED_PAGE_FAULT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DRED_PAGE_FAULT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_DRED_PAGE_FAULT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_DRED_PAGE_FAULT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_DRED_PAGE_FAULT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_DRED_PAGE_FAULT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_DRED_PAGE_FAULT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_PAGE_FAULT_OUTPUT {
    pub PageFaultVA: u64,
    pub pHeadExistingAllocationNode: *mut D3D12_DRED_ALLOCATION_NODE,
    pub pHeadRecentFreedAllocationNode: *mut D3D12_DRED_ALLOCATION_NODE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_PAGE_FAULT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_PAGE_FAULT_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_PAGE_FAULT_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_PAGE_FAULT_OUTPUT").field("PageFaultVA", &self.PageFaultVA).field("pHeadExistingAllocationNode", &self.pHeadExistingAllocationNode).field("pHeadRecentFreedAllocationNode", &self.pHeadRecentFreedAllocationNode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_PAGE_FAULT_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.PageFaultVA == other.PageFaultVA && self.pHeadExistingAllocationNode == other.pHeadExistingAllocationNode && self.pHeadRecentFreedAllocationNode == other.pHeadRecentFreedAllocationNode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_PAGE_FAULT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_PAGE_FAULT_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_PAGE_FAULT_OUTPUT1 {
    pub PageFaultVA: u64,
    pub pHeadExistingAllocationNode: *mut D3D12_DRED_ALLOCATION_NODE1,
    pub pHeadRecentFreedAllocationNode: *mut D3D12_DRED_ALLOCATION_NODE1,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_PAGE_FAULT_OUTPUT1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_PAGE_FAULT_OUTPUT1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_PAGE_FAULT_OUTPUT1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_PAGE_FAULT_OUTPUT1").field("PageFaultVA", &self.PageFaultVA).field("pHeadExistingAllocationNode", &self.pHeadExistingAllocationNode).field("pHeadRecentFreedAllocationNode", &self.pHeadRecentFreedAllocationNode).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_PAGE_FAULT_OUTPUT1 {
    fn eq(&self, other: &Self) -> bool {
        self.PageFaultVA == other.PageFaultVA && self.pHeadExistingAllocationNode == other.pHeadExistingAllocationNode && self.pHeadRecentFreedAllocationNode == other.pHeadRecentFreedAllocationNode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_PAGE_FAULT_OUTPUT1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_PAGE_FAULT_OUTPUT1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DRED_PAGE_FAULT_OUTPUT2 {
    pub PageFaultVA: u64,
    pub pHeadExistingAllocationNode: *mut D3D12_DRED_ALLOCATION_NODE1,
    pub pHeadRecentFreedAllocationNode: *mut D3D12_DRED_ALLOCATION_NODE1,
    pub PageFaultFlags: D3D12_DRED_PAGE_FAULT_FLAGS,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DRED_PAGE_FAULT_OUTPUT2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DRED_PAGE_FAULT_OUTPUT2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DRED_PAGE_FAULT_OUTPUT2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DRED_PAGE_FAULT_OUTPUT2").field("PageFaultVA", &self.PageFaultVA).field("pHeadExistingAllocationNode", &self.pHeadExistingAllocationNode).field("pHeadRecentFreedAllocationNode", &self.pHeadRecentFreedAllocationNode).field("PageFaultFlags", &self.PageFaultFlags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DRED_PAGE_FAULT_OUTPUT2 {
    fn eq(&self, other: &Self) -> bool {
        self.PageFaultVA == other.PageFaultVA && self.pHeadExistingAllocationNode == other.pHeadExistingAllocationNode && self.pHeadRecentFreedAllocationNode == other.pHeadRecentFreedAllocationNode && self.PageFaultFlags == other.PageFaultFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DRED_PAGE_FAULT_OUTPUT2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DRED_PAGE_FAULT_OUTPUT2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DRED_VERSION(pub i32);
pub const D3D12_DRED_VERSION_1_0: D3D12_DRED_VERSION = D3D12_DRED_VERSION(1i32);
pub const D3D12_DRED_VERSION_1_1: D3D12_DRED_VERSION = D3D12_DRED_VERSION(2i32);
pub const D3D12_DRED_VERSION_1_2: D3D12_DRED_VERSION = D3D12_DRED_VERSION(3i32);
pub const D3D12_DRED_VERSION_1_3: D3D12_DRED_VERSION = D3D12_DRED_VERSION(4i32);
impl ::std::convert::From<i32> for D3D12_DRED_VERSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DRED_VERSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS(pub i32);
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_COMPATIBLE_WITH_DEVICE: D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS(0i32);
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_UNSUPPORTED_TYPE: D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS(1i32);
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_UNRECOGNIZED: D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS(2i32);
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_INCOMPATIBLE_VERSION: D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS(3i32);
pub const D3D12_DRIVER_MATCHING_IDENTIFIER_INCOMPATIBLE_TYPE: D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS = D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS(4i32);
impl ::std::convert::From<i32> for D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DRIVER_MATCHING_IDENTIFIER_STATUS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_END: u32 = 4294967287u32;
pub const D3D12_DRIVER_RESERVED_REGISTER_SPACE_VALUES_START: u32 = 4294967280u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DSV_DIMENSION(pub i32);
pub const D3D12_DSV_DIMENSION_UNKNOWN: D3D12_DSV_DIMENSION = D3D12_DSV_DIMENSION(0i32);
pub const D3D12_DSV_DIMENSION_TEXTURE1D: D3D12_DSV_DIMENSION = D3D12_DSV_DIMENSION(1i32);
pub const D3D12_DSV_DIMENSION_TEXTURE1DARRAY: D3D12_DSV_DIMENSION = D3D12_DSV_DIMENSION(2i32);
pub const D3D12_DSV_DIMENSION_TEXTURE2D: D3D12_DSV_DIMENSION = D3D12_DSV_DIMENSION(3i32);
pub const D3D12_DSV_DIMENSION_TEXTURE2DARRAY: D3D12_DSV_DIMENSION = D3D12_DSV_DIMENSION(4i32);
pub const D3D12_DSV_DIMENSION_TEXTURE2DMS: D3D12_DSV_DIMENSION = D3D12_DSV_DIMENSION(5i32);
pub const D3D12_DSV_DIMENSION_TEXTURE2DMSARRAY: D3D12_DSV_DIMENSION = D3D12_DSV_DIMENSION(6i32);
impl ::std::convert::From<i32> for D3D12_DSV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DSV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_DSV_FLAGS(pub u32);
pub const D3D12_DSV_FLAG_NONE: D3D12_DSV_FLAGS = D3D12_DSV_FLAGS(0u32);
pub const D3D12_DSV_FLAG_READ_ONLY_DEPTH: D3D12_DSV_FLAGS = D3D12_DSV_FLAGS(1u32);
pub const D3D12_DSV_FLAG_READ_ONLY_STENCIL: D3D12_DSV_FLAGS = D3D12_DSV_FLAGS(2u32);
impl ::std::convert::From<u32> for D3D12_DSV_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_DSV_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_DSV_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_DSV_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_DSV_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_DSV_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_DSV_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 = 3968u32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_DS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_DS_OUTPUT_REGISTER_COUNT: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DXIL_LIBRARY_DESC {
    pub DXILLibrary: D3D12_SHADER_BYTECODE,
    pub NumExports: u32,
    pub pExports: *mut D3D12_EXPORT_DESC,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DXIL_LIBRARY_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DXIL_LIBRARY_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DXIL_LIBRARY_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DXIL_LIBRARY_DESC").field("DXILLibrary", &self.DXILLibrary).field("NumExports", &self.NumExports).field("pExports", &self.pExports).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DXIL_LIBRARY_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.DXILLibrary == other.DXILLibrary && self.NumExports == other.NumExports && self.pExports == other.pExports
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DXIL_LIBRARY_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DXIL_LIBRARY_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    pub SubobjectToAssociate: super::super::Foundation::PWSTR,
    pub NumExports: u32,
    pub pExports: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION").field("SubobjectToAssociate", &self.SubobjectToAssociate).field("NumExports", &self.NumExports).field("pExports", &self.pExports).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn eq(&self, other: &Self) -> bool {
        self.SubobjectToAssociate == other.SubobjectToAssociate && self.NumExports == other.NumExports && self.pExports == other.pExports
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_ELEMENTS_LAYOUT(pub i32);
pub const D3D12_ELEMENTS_LAYOUT_ARRAY: D3D12_ELEMENTS_LAYOUT = D3D12_ELEMENTS_LAYOUT(0i32);
pub const D3D12_ELEMENTS_LAYOUT_ARRAY_OF_POINTERS: D3D12_ELEMENTS_LAYOUT = D3D12_ELEMENTS_LAYOUT(1i32);
impl ::std::convert::From<i32> for D3D12_ELEMENTS_LAYOUT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_ELEMENTS_LAYOUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_EXISTING_COLLECTION_DESC {
    pub pExistingCollection: ::std::option::Option<ID3D12StateObject>,
    pub NumExports: u32,
    pub pExports: *mut D3D12_EXPORT_DESC,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_EXISTING_COLLECTION_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_EXISTING_COLLECTION_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_EXISTING_COLLECTION_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_EXISTING_COLLECTION_DESC").field("pExistingCollection", &self.pExistingCollection).field("NumExports", &self.NumExports).field("pExports", &self.pExports).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_EXISTING_COLLECTION_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.pExistingCollection == other.pExistingCollection && self.NumExports == other.NumExports && self.pExports == other.pExports
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_EXISTING_COLLECTION_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_EXISTING_COLLECTION_DESC {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_EXPORT_DESC {
    pub Name: super::super::Foundation::PWSTR,
    pub ExportToRename: super::super::Foundation::PWSTR,
    pub Flags: D3D12_EXPORT_FLAGS,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_EXPORT_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_EXPORT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_EXPORT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_EXPORT_DESC").field("Name", &self.Name).field("ExportToRename", &self.ExportToRename).field("Flags", &self.Flags).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_EXPORT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.ExportToRename == other.ExportToRename && self.Flags == other.Flags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_EXPORT_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_EXPORT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_EXPORT_FLAGS(pub u32);
pub const D3D12_EXPORT_FLAG_NONE: D3D12_EXPORT_FLAGS = D3D12_EXPORT_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D12_EXPORT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_EXPORT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_EXPORT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_EXPORT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_EXPORT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_EXPORT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_EXPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FEATURE(pub i32);
pub const D3D12_FEATURE_D3D12_OPTIONS: D3D12_FEATURE = D3D12_FEATURE(0i32);
pub const D3D12_FEATURE_ARCHITECTURE: D3D12_FEATURE = D3D12_FEATURE(1i32);
pub const D3D12_FEATURE_FEATURE_LEVELS: D3D12_FEATURE = D3D12_FEATURE(2i32);
pub const D3D12_FEATURE_FORMAT_SUPPORT: D3D12_FEATURE = D3D12_FEATURE(3i32);
pub const D3D12_FEATURE_MULTISAMPLE_QUALITY_LEVELS: D3D12_FEATURE = D3D12_FEATURE(4i32);
pub const D3D12_FEATURE_FORMAT_INFO: D3D12_FEATURE = D3D12_FEATURE(5i32);
pub const D3D12_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT: D3D12_FEATURE = D3D12_FEATURE(6i32);
pub const D3D12_FEATURE_SHADER_MODEL: D3D12_FEATURE = D3D12_FEATURE(7i32);
pub const D3D12_FEATURE_D3D12_OPTIONS1: D3D12_FEATURE = D3D12_FEATURE(8i32);
pub const D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_SUPPORT: D3D12_FEATURE = D3D12_FEATURE(10i32);
pub const D3D12_FEATURE_ROOT_SIGNATURE: D3D12_FEATURE = D3D12_FEATURE(12i32);
pub const D3D12_FEATURE_ARCHITECTURE1: D3D12_FEATURE = D3D12_FEATURE(16i32);
pub const D3D12_FEATURE_D3D12_OPTIONS2: D3D12_FEATURE = D3D12_FEATURE(18i32);
pub const D3D12_FEATURE_SHADER_CACHE: D3D12_FEATURE = D3D12_FEATURE(19i32);
pub const D3D12_FEATURE_COMMAND_QUEUE_PRIORITY: D3D12_FEATURE = D3D12_FEATURE(20i32);
pub const D3D12_FEATURE_D3D12_OPTIONS3: D3D12_FEATURE = D3D12_FEATURE(21i32);
pub const D3D12_FEATURE_EXISTING_HEAPS: D3D12_FEATURE = D3D12_FEATURE(22i32);
pub const D3D12_FEATURE_D3D12_OPTIONS4: D3D12_FEATURE = D3D12_FEATURE(23i32);
pub const D3D12_FEATURE_SERIALIZATION: D3D12_FEATURE = D3D12_FEATURE(24i32);
pub const D3D12_FEATURE_CROSS_NODE: D3D12_FEATURE = D3D12_FEATURE(25i32);
pub const D3D12_FEATURE_D3D12_OPTIONS5: D3D12_FEATURE = D3D12_FEATURE(27i32);
pub const D3D12_FEATURE_DISPLAYABLE: D3D12_FEATURE = D3D12_FEATURE(28i32);
pub const D3D12_FEATURE_D3D12_OPTIONS6: D3D12_FEATURE = D3D12_FEATURE(30i32);
pub const D3D12_FEATURE_QUERY_META_COMMAND: D3D12_FEATURE = D3D12_FEATURE(31i32);
pub const D3D12_FEATURE_D3D12_OPTIONS7: D3D12_FEATURE = D3D12_FEATURE(32i32);
pub const D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_TYPE_COUNT: D3D12_FEATURE = D3D12_FEATURE(33i32);
pub const D3D12_FEATURE_PROTECTED_RESOURCE_SESSION_TYPES: D3D12_FEATURE = D3D12_FEATURE(34i32);
pub const D3D12_FEATURE_D3D12_OPTIONS8: D3D12_FEATURE = D3D12_FEATURE(36i32);
pub const D3D12_FEATURE_D3D12_OPTIONS9: D3D12_FEATURE = D3D12_FEATURE(37i32);
pub const D3D12_FEATURE_D3D12_OPTIONS10: D3D12_FEATURE = D3D12_FEATURE(39i32);
pub const D3D12_FEATURE_D3D12_OPTIONS11: D3D12_FEATURE = D3D12_FEATURE(40i32);
impl ::std::convert::From<i32> for D3D12_FEATURE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_ARCHITECTURE {
    pub NodeIndex: u32,
    pub TileBasedRenderer: super::super::Foundation::BOOL,
    pub UMA: super::super::Foundation::BOOL,
    pub CacheCoherentUMA: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_ARCHITECTURE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_ARCHITECTURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_ARCHITECTURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_ARCHITECTURE").field("NodeIndex", &self.NodeIndex).field("TileBasedRenderer", &self.TileBasedRenderer).field("UMA", &self.UMA).field("CacheCoherentUMA", &self.CacheCoherentUMA).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_ARCHITECTURE {
    fn eq(&self, other: &Self) -> bool {
        self.NodeIndex == other.NodeIndex && self.TileBasedRenderer == other.TileBasedRenderer && self.UMA == other.UMA && self.CacheCoherentUMA == other.CacheCoherentUMA
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_ARCHITECTURE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_ARCHITECTURE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_ARCHITECTURE1 {
    pub NodeIndex: u32,
    pub TileBasedRenderer: super::super::Foundation::BOOL,
    pub UMA: super::super::Foundation::BOOL,
    pub CacheCoherentUMA: super::super::Foundation::BOOL,
    pub IsolatedMMU: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_ARCHITECTURE1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_ARCHITECTURE1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_ARCHITECTURE1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_ARCHITECTURE1").field("NodeIndex", &self.NodeIndex).field("TileBasedRenderer", &self.TileBasedRenderer).field("UMA", &self.UMA).field("CacheCoherentUMA", &self.CacheCoherentUMA).field("IsolatedMMU", &self.IsolatedMMU).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_ARCHITECTURE1 {
    fn eq(&self, other: &Self) -> bool {
        self.NodeIndex == other.NodeIndex && self.TileBasedRenderer == other.TileBasedRenderer && self.UMA == other.UMA && self.CacheCoherentUMA == other.CacheCoherentUMA && self.IsolatedMMU == other.IsolatedMMU
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_ARCHITECTURE1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_ARCHITECTURE1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    pub CommandListType: D3D12_COMMAND_LIST_TYPE,
    pub Priority: u32,
    pub PriorityForTypeIsSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY").field("CommandListType", &self.CommandListType).field("Priority", &self.Priority).field("PriorityForTypeIsSupported", &self.PriorityForTypeIsSupported).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    fn eq(&self, other: &Self) -> bool {
        self.CommandListType == other.CommandListType && self.Priority == other.Priority && self.PriorityForTypeIsSupported == other.PriorityForTypeIsSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_COMMAND_QUEUE_PRIORITY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_CROSS_NODE {
    pub SharingTier: D3D12_CROSS_NODE_SHARING_TIER,
    pub AtomicShaderInstructions: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_CROSS_NODE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_CROSS_NODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_CROSS_NODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_CROSS_NODE").field("SharingTier", &self.SharingTier).field("AtomicShaderInstructions", &self.AtomicShaderInstructions).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_CROSS_NODE {
    fn eq(&self, other: &Self) -> bool {
        self.SharingTier == other.SharingTier && self.AtomicShaderInstructions == other.AtomicShaderInstructions
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_CROSS_NODE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_CROSS_NODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS {
    pub DoublePrecisionFloatShaderOps: super::super::Foundation::BOOL,
    pub OutputMergerLogicOp: super::super::Foundation::BOOL,
    pub MinPrecisionSupport: D3D12_SHADER_MIN_PRECISION_SUPPORT,
    pub TiledResourcesTier: D3D12_TILED_RESOURCES_TIER,
    pub ResourceBindingTier: D3D12_RESOURCE_BINDING_TIER,
    pub PSSpecifiedStencilRefSupported: super::super::Foundation::BOOL,
    pub TypedUAVLoadAdditionalFormats: super::super::Foundation::BOOL,
    pub ROVsSupported: super::super::Foundation::BOOL,
    pub ConservativeRasterizationTier: D3D12_CONSERVATIVE_RASTERIZATION_TIER,
    pub MaxGPUVirtualAddressBitsPerResource: u32,
    pub StandardSwizzle64KBSupported: super::super::Foundation::BOOL,
    pub CrossNodeSharingTier: D3D12_CROSS_NODE_SHARING_TIER,
    pub CrossAdapterRowMajorTextureSupported: super::super::Foundation::BOOL,
    pub VPAndRTArrayIndexFromAnyShaderFeedingRasterizerSupportedWithoutGSEmulation: super::super::Foundation::BOOL,
    pub ResourceHeapTier: D3D12_RESOURCE_HEAP_TIER,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS")
            .field("DoublePrecisionFloatShaderOps", &self.DoublePrecisionFloatShaderOps)
            .field("OutputMergerLogicOp", &self.OutputMergerLogicOp)
            .field("MinPrecisionSupport", &self.MinPrecisionSupport)
            .field("TiledResourcesTier", &self.TiledResourcesTier)
            .field("ResourceBindingTier", &self.ResourceBindingTier)
            .field("PSSpecifiedStencilRefSupported", &self.PSSpecifiedStencilRefSupported)
            .field("TypedUAVLoadAdditionalFormats", &self.TypedUAVLoadAdditionalFormats)
            .field("ROVsSupported", &self.ROVsSupported)
            .field("ConservativeRasterizationTier", &self.ConservativeRasterizationTier)
            .field("MaxGPUVirtualAddressBitsPerResource", &self.MaxGPUVirtualAddressBitsPerResource)
            .field("StandardSwizzle64KBSupported", &self.StandardSwizzle64KBSupported)
            .field("CrossNodeSharingTier", &self.CrossNodeSharingTier)
            .field("CrossAdapterRowMajorTextureSupported", &self.CrossAdapterRowMajorTextureSupported)
            .field("VPAndRTArrayIndexFromAnyShaderFeedingRasterizerSupportedWithoutGSEmulation", &self.VPAndRTArrayIndexFromAnyShaderFeedingRasterizerSupportedWithoutGSEmulation)
            .field("ResourceHeapTier", &self.ResourceHeapTier)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.DoublePrecisionFloatShaderOps == other.DoublePrecisionFloatShaderOps
            && self.OutputMergerLogicOp == other.OutputMergerLogicOp
            && self.MinPrecisionSupport == other.MinPrecisionSupport
            && self.TiledResourcesTier == other.TiledResourcesTier
            && self.ResourceBindingTier == other.ResourceBindingTier
            && self.PSSpecifiedStencilRefSupported == other.PSSpecifiedStencilRefSupported
            && self.TypedUAVLoadAdditionalFormats == other.TypedUAVLoadAdditionalFormats
            && self.ROVsSupported == other.ROVsSupported
            && self.ConservativeRasterizationTier == other.ConservativeRasterizationTier
            && self.MaxGPUVirtualAddressBitsPerResource == other.MaxGPUVirtualAddressBitsPerResource
            && self.StandardSwizzle64KBSupported == other.StandardSwizzle64KBSupported
            && self.CrossNodeSharingTier == other.CrossNodeSharingTier
            && self.CrossAdapterRowMajorTextureSupported == other.CrossAdapterRowMajorTextureSupported
            && self.VPAndRTArrayIndexFromAnyShaderFeedingRasterizerSupportedWithoutGSEmulation == other.VPAndRTArrayIndexFromAnyShaderFeedingRasterizerSupportedWithoutGSEmulation
            && self.ResourceHeapTier == other.ResourceHeapTier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS1 {
    pub WaveOps: super::super::Foundation::BOOL,
    pub WaveLaneCountMin: u32,
    pub WaveLaneCountMax: u32,
    pub TotalLaneCount: u32,
    pub ExpandedComputeResourceStates: super::super::Foundation::BOOL,
    pub Int64ShaderOps: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS1")
            .field("WaveOps", &self.WaveOps)
            .field("WaveLaneCountMin", &self.WaveLaneCountMin)
            .field("WaveLaneCountMax", &self.WaveLaneCountMax)
            .field("TotalLaneCount", &self.TotalLaneCount)
            .field("ExpandedComputeResourceStates", &self.ExpandedComputeResourceStates)
            .field("Int64ShaderOps", &self.Int64ShaderOps)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS1 {
    fn eq(&self, other: &Self) -> bool {
        self.WaveOps == other.WaveOps && self.WaveLaneCountMin == other.WaveLaneCountMin && self.WaveLaneCountMax == other.WaveLaneCountMax && self.TotalLaneCount == other.TotalLaneCount && self.ExpandedComputeResourceStates == other.ExpandedComputeResourceStates && self.Int64ShaderOps == other.Int64ShaderOps
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS10 {
    pub VariableRateShadingSumCombinerSupported: super::super::Foundation::BOOL,
    pub MeshShaderPerPrimitiveShadingRateSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS10 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS10 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS10 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS10").field("VariableRateShadingSumCombinerSupported", &self.VariableRateShadingSumCombinerSupported).field("MeshShaderPerPrimitiveShadingRateSupported", &self.MeshShaderPerPrimitiveShadingRateSupported).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS10 {
    fn eq(&self, other: &Self) -> bool {
        self.VariableRateShadingSumCombinerSupported == other.VariableRateShadingSumCombinerSupported && self.MeshShaderPerPrimitiveShadingRateSupported == other.MeshShaderPerPrimitiveShadingRateSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS10 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS10 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS11 {
    pub AtomicInt64OnDescriptorHeapResourceSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS11 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS11 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS11 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS11").field("AtomicInt64OnDescriptorHeapResourceSupported", &self.AtomicInt64OnDescriptorHeapResourceSupported).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS11 {
    fn eq(&self, other: &Self) -> bool {
        self.AtomicInt64OnDescriptorHeapResourceSupported == other.AtomicInt64OnDescriptorHeapResourceSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS11 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS11 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    pub DepthBoundsTestSupported: super::super::Foundation::BOOL,
    pub ProgrammableSamplePositionsTier: D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS2").field("DepthBoundsTestSupported", &self.DepthBoundsTestSupported).field("ProgrammableSamplePositionsTier", &self.ProgrammableSamplePositionsTier).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    fn eq(&self, other: &Self) -> bool {
        self.DepthBoundsTestSupported == other.DepthBoundsTestSupported && self.ProgrammableSamplePositionsTier == other.ProgrammableSamplePositionsTier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS3 {
    pub CopyQueueTimestampQueriesSupported: super::super::Foundation::BOOL,
    pub CastingFullyTypedFormatSupported: super::super::Foundation::BOOL,
    pub WriteBufferImmediateSupportFlags: D3D12_COMMAND_LIST_SUPPORT_FLAGS,
    pub ViewInstancingTier: D3D12_VIEW_INSTANCING_TIER,
    pub BarycentricsSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS3 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS3")
            .field("CopyQueueTimestampQueriesSupported", &self.CopyQueueTimestampQueriesSupported)
            .field("CastingFullyTypedFormatSupported", &self.CastingFullyTypedFormatSupported)
            .field("WriteBufferImmediateSupportFlags", &self.WriteBufferImmediateSupportFlags)
            .field("ViewInstancingTier", &self.ViewInstancingTier)
            .field("BarycentricsSupported", &self.BarycentricsSupported)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS3 {
    fn eq(&self, other: &Self) -> bool {
        self.CopyQueueTimestampQueriesSupported == other.CopyQueueTimestampQueriesSupported && self.CastingFullyTypedFormatSupported == other.CastingFullyTypedFormatSupported && self.WriteBufferImmediateSupportFlags == other.WriteBufferImmediateSupportFlags && self.ViewInstancingTier == other.ViewInstancingTier && self.BarycentricsSupported == other.BarycentricsSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS3 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS3 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS4 {
    pub MSAA64KBAlignedTextureSupported: super::super::Foundation::BOOL,
    pub SharedResourceCompatibilityTier: D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER,
    pub Native16BitShaderOpsSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS4 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS4 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS4").field("MSAA64KBAlignedTextureSupported", &self.MSAA64KBAlignedTextureSupported).field("SharedResourceCompatibilityTier", &self.SharedResourceCompatibilityTier).field("Native16BitShaderOpsSupported", &self.Native16BitShaderOpsSupported).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS4 {
    fn eq(&self, other: &Self) -> bool {
        self.MSAA64KBAlignedTextureSupported == other.MSAA64KBAlignedTextureSupported && self.SharedResourceCompatibilityTier == other.SharedResourceCompatibilityTier && self.Native16BitShaderOpsSupported == other.Native16BitShaderOpsSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS4 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS4 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS5 {
    pub SRVOnlyTiledResourceTier3: super::super::Foundation::BOOL,
    pub RenderPassesTier: D3D12_RENDER_PASS_TIER,
    pub RaytracingTier: D3D12_RAYTRACING_TIER,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS5 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS5 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS5").field("SRVOnlyTiledResourceTier3", &self.SRVOnlyTiledResourceTier3).field("RenderPassesTier", &self.RenderPassesTier).field("RaytracingTier", &self.RaytracingTier).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS5 {
    fn eq(&self, other: &Self) -> bool {
        self.SRVOnlyTiledResourceTier3 == other.SRVOnlyTiledResourceTier3 && self.RenderPassesTier == other.RenderPassesTier && self.RaytracingTier == other.RaytracingTier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS5 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS5 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS6 {
    pub AdditionalShadingRatesSupported: super::super::Foundation::BOOL,
    pub PerPrimitiveShadingRateSupportedWithViewportIndexing: super::super::Foundation::BOOL,
    pub VariableShadingRateTier: D3D12_VARIABLE_SHADING_RATE_TIER,
    pub ShadingRateImageTileSize: u32,
    pub BackgroundProcessingSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS6 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS6 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS6 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS6")
            .field("AdditionalShadingRatesSupported", &self.AdditionalShadingRatesSupported)
            .field("PerPrimitiveShadingRateSupportedWithViewportIndexing", &self.PerPrimitiveShadingRateSupportedWithViewportIndexing)
            .field("VariableShadingRateTier", &self.VariableShadingRateTier)
            .field("ShadingRateImageTileSize", &self.ShadingRateImageTileSize)
            .field("BackgroundProcessingSupported", &self.BackgroundProcessingSupported)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS6 {
    fn eq(&self, other: &Self) -> bool {
        self.AdditionalShadingRatesSupported == other.AdditionalShadingRatesSupported && self.PerPrimitiveShadingRateSupportedWithViewportIndexing == other.PerPrimitiveShadingRateSupportedWithViewportIndexing && self.VariableShadingRateTier == other.VariableShadingRateTier && self.ShadingRateImageTileSize == other.ShadingRateImageTileSize && self.BackgroundProcessingSupported == other.BackgroundProcessingSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS6 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS6 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS7 {
    pub MeshShaderTier: D3D12_MESH_SHADER_TIER,
    pub SamplerFeedbackTier: D3D12_SAMPLER_FEEDBACK_TIER,
}
impl D3D12_FEATURE_DATA_D3D12_OPTIONS7 {}
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS7 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS7 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS7").field("MeshShaderTier", &self.MeshShaderTier).field("SamplerFeedbackTier", &self.SamplerFeedbackTier).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS7 {
    fn eq(&self, other: &Self) -> bool {
        self.MeshShaderTier == other.MeshShaderTier && self.SamplerFeedbackTier == other.SamplerFeedbackTier
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS7 {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS7 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS8 {
    pub UnalignedBlockTexturesSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS8 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS8 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS8 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS8").field("UnalignedBlockTexturesSupported", &self.UnalignedBlockTexturesSupported).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS8 {
    fn eq(&self, other: &Self) -> bool {
        self.UnalignedBlockTexturesSupported == other.UnalignedBlockTexturesSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS8 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS8 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_D3D12_OPTIONS9 {
    pub MeshShaderPipelineStatsSupported: super::super::Foundation::BOOL,
    pub MeshShaderSupportsFullRangeRenderTargetArrayIndex: super::super::Foundation::BOOL,
    pub AtomicInt64OnTypedResourceSupported: super::super::Foundation::BOOL,
    pub AtomicInt64OnGroupSharedSupported: super::super::Foundation::BOOL,
    pub DerivativesInMeshAndAmplificationShadersSupported: super::super::Foundation::BOOL,
    pub WaveMMATier: D3D12_WAVE_MMA_TIER,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_D3D12_OPTIONS9 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_D3D12_OPTIONS9 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_D3D12_OPTIONS9 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_D3D12_OPTIONS9")
            .field("MeshShaderPipelineStatsSupported", &self.MeshShaderPipelineStatsSupported)
            .field("MeshShaderSupportsFullRangeRenderTargetArrayIndex", &self.MeshShaderSupportsFullRangeRenderTargetArrayIndex)
            .field("AtomicInt64OnTypedResourceSupported", &self.AtomicInt64OnTypedResourceSupported)
            .field("AtomicInt64OnGroupSharedSupported", &self.AtomicInt64OnGroupSharedSupported)
            .field("DerivativesInMeshAndAmplificationShadersSupported", &self.DerivativesInMeshAndAmplificationShadersSupported)
            .field("WaveMMATier", &self.WaveMMATier)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_D3D12_OPTIONS9 {
    fn eq(&self, other: &Self) -> bool {
        self.MeshShaderPipelineStatsSupported == other.MeshShaderPipelineStatsSupported
            && self.MeshShaderSupportsFullRangeRenderTargetArrayIndex == other.MeshShaderSupportsFullRangeRenderTargetArrayIndex
            && self.AtomicInt64OnTypedResourceSupported == other.AtomicInt64OnTypedResourceSupported
            && self.AtomicInt64OnGroupSharedSupported == other.AtomicInt64OnGroupSharedSupported
            && self.DerivativesInMeshAndAmplificationShadersSupported == other.DerivativesInMeshAndAmplificationShadersSupported
            && self.WaveMMATier == other.WaveMMATier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_D3D12_OPTIONS9 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_D3D12_OPTIONS9 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_DISPLAYABLE {
    pub DisplayableTexture: super::super::Foundation::BOOL,
    pub SharedResourceCompatibilityTier: D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_DISPLAYABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_DISPLAYABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_DISPLAYABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_DISPLAYABLE").field("DisplayableTexture", &self.DisplayableTexture).field("SharedResourceCompatibilityTier", &self.SharedResourceCompatibilityTier).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_DISPLAYABLE {
    fn eq(&self, other: &Self) -> bool {
        self.DisplayableTexture == other.DisplayableTexture && self.SharedResourceCompatibilityTier == other.SharedResourceCompatibilityTier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_DISPLAYABLE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_DISPLAYABLE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_FEATURE_DATA_EXISTING_HEAPS {
    pub Supported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_FEATURE_DATA_EXISTING_HEAPS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_FEATURE_DATA_EXISTING_HEAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_EXISTING_HEAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_EXISTING_HEAPS").field("Supported", &self.Supported).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_EXISTING_HEAPS {
    fn eq(&self, other: &Self) -> bool {
        self.Supported == other.Supported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_EXISTING_HEAPS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_EXISTING_HEAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Direct3D11")]
pub struct D3D12_FEATURE_DATA_FEATURE_LEVELS {
    pub NumFeatureLevels: u32,
    pub pFeatureLevelsRequested: *mut super::Direct3D11::D3D_FEATURE_LEVEL,
    pub MaxSupportedFeatureLevel: super::Direct3D11::D3D_FEATURE_LEVEL,
}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
impl D3D12_FEATURE_DATA_FEATURE_LEVELS {}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
impl ::std::default::Default for D3D12_FEATURE_DATA_FEATURE_LEVELS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_FEATURE_LEVELS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_FEATURE_LEVELS").field("NumFeatureLevels", &self.NumFeatureLevels).field("pFeatureLevelsRequested", &self.pFeatureLevelsRequested).field("MaxSupportedFeatureLevel", &self.MaxSupportedFeatureLevel).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_FEATURE_LEVELS {
    fn eq(&self, other: &Self) -> bool {
        self.NumFeatureLevels == other.NumFeatureLevels && self.pFeatureLevelsRequested == other.pFeatureLevelsRequested && self.MaxSupportedFeatureLevel == other.MaxSupportedFeatureLevel
    }
}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_FEATURE_LEVELS {}
#[cfg(feature = "Win32_Graphics_Direct3D11")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_FEATURE_LEVELS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_FEATURE_DATA_FORMAT_INFO {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub PlaneCount: u8,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_FEATURE_DATA_FORMAT_INFO {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_FEATURE_DATA_FORMAT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_FORMAT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_FORMAT_INFO").field("Format", &self.Format).field("PlaneCount", &self.PlaneCount).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_FORMAT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Format == other.Format && self.PlaneCount == other.PlaneCount
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_FORMAT_INFO {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_FORMAT_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub Support1: D3D12_FORMAT_SUPPORT1,
    pub Support2: D3D12_FORMAT_SUPPORT2,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_FEATURE_DATA_FORMAT_SUPPORT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_FORMAT_SUPPORT").field("Format", &self.Format).field("Support1", &self.Support1).field("Support2", &self.Support2).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.Format == other.Format && self.Support1 == other.Support1 && self.Support2 == other.Support2
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_FORMAT_SUPPORT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_FORMAT_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    pub MaxGPUVirtualAddressBitsPerResource: u32,
    pub MaxGPUVirtualAddressBitsPerProcess: u32,
}
impl D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {}
impl ::std::default::Default for D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT").field("MaxGPUVirtualAddressBitsPerResource", &self.MaxGPUVirtualAddressBitsPerResource).field("MaxGPUVirtualAddressBitsPerProcess", &self.MaxGPUVirtualAddressBitsPerProcess).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.MaxGPUVirtualAddressBitsPerResource == other.MaxGPUVirtualAddressBitsPerResource && self.MaxGPUVirtualAddressBitsPerProcess == other.MaxGPUVirtualAddressBitsPerProcess
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub SampleCount: u32,
    pub Flags: D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS,
    pub NumQualityLevels: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS").field("Format", &self.Format).field("SampleCount", &self.SampleCount).field("Flags", &self.Flags).field("NumQualityLevels", &self.NumQualityLevels).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    fn eq(&self, other: &Self) -> bool {
        self.Format == other.Format && self.SampleCount == other.SampleCount && self.Flags == other.Flags && self.NumQualityLevels == other.NumQualityLevels
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_MULTISAMPLE_QUALITY_LEVELS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {
    pub NodeIndex: u32,
    pub Support: D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS,
}
impl D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {}
impl ::std::default::Default for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT").field("NodeIndex", &self.NodeIndex).field("Support", &self.Support).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.NodeIndex == other.NodeIndex && self.Support == other.Support
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {
    pub NodeIndex: u32,
    pub Count: u32,
    pub pTypes: *mut ::windows::runtime::GUID,
}
impl D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {}
impl ::std::default::Default for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES").field("NodeIndex", &self.NodeIndex).field("Count", &self.Count).field("pTypes", &self.pTypes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {
    fn eq(&self, other: &Self) -> bool {
        self.NodeIndex == other.NodeIndex && self.Count == other.Count && self.pTypes == other.pTypes
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {
    pub NodeIndex: u32,
    pub Count: u32,
}
impl D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {}
impl ::std::default::Default for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT").field("NodeIndex", &self.NodeIndex).field("Count", &self.Count).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {
    fn eq(&self, other: &Self) -> bool {
        self.NodeIndex == other.NodeIndex && self.Count == other.Count
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_PROTECTED_RESOURCE_SESSION_TYPE_COUNT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_QUERY_META_COMMAND {
    pub CommandId: ::windows::runtime::GUID,
    pub NodeMask: u32,
    pub pQueryInputData: *mut ::std::ffi::c_void,
    pub QueryInputDataSizeInBytes: usize,
    pub pQueryOutputData: *mut ::std::ffi::c_void,
    pub QueryOutputDataSizeInBytes: usize,
}
impl D3D12_FEATURE_DATA_QUERY_META_COMMAND {}
impl ::std::default::Default for D3D12_FEATURE_DATA_QUERY_META_COMMAND {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_QUERY_META_COMMAND {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_QUERY_META_COMMAND")
            .field("CommandId", &self.CommandId)
            .field("NodeMask", &self.NodeMask)
            .field("pQueryInputData", &self.pQueryInputData)
            .field("QueryInputDataSizeInBytes", &self.QueryInputDataSizeInBytes)
            .field("pQueryOutputData", &self.pQueryOutputData)
            .field("QueryOutputDataSizeInBytes", &self.QueryOutputDataSizeInBytes)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_QUERY_META_COMMAND {
    fn eq(&self, other: &Self) -> bool {
        self.CommandId == other.CommandId && self.NodeMask == other.NodeMask && self.pQueryInputData == other.pQueryInputData && self.QueryInputDataSizeInBytes == other.QueryInputDataSizeInBytes && self.pQueryOutputData == other.pQueryOutputData && self.QueryOutputDataSizeInBytes == other.QueryOutputDataSizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_QUERY_META_COMMAND {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_QUERY_META_COMMAND {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    pub HighestVersion: D3D_ROOT_SIGNATURE_VERSION,
}
impl D3D12_FEATURE_DATA_ROOT_SIGNATURE {}
impl ::std::default::Default for D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_ROOT_SIGNATURE").field("HighestVersion", &self.HighestVersion).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.HighestVersion == other.HighestVersion
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_ROOT_SIGNATURE {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_ROOT_SIGNATURE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_SERIALIZATION {
    pub NodeIndex: u32,
    pub HeapSerializationTier: D3D12_HEAP_SERIALIZATION_TIER,
}
impl D3D12_FEATURE_DATA_SERIALIZATION {}
impl ::std::default::Default for D3D12_FEATURE_DATA_SERIALIZATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_SERIALIZATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_SERIALIZATION").field("NodeIndex", &self.NodeIndex).field("HeapSerializationTier", &self.HeapSerializationTier).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_SERIALIZATION {
    fn eq(&self, other: &Self) -> bool {
        self.NodeIndex == other.NodeIndex && self.HeapSerializationTier == other.HeapSerializationTier
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_SERIALIZATION {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_SERIALIZATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_SHADER_CACHE {
    pub SupportFlags: D3D12_SHADER_CACHE_SUPPORT_FLAGS,
}
impl D3D12_FEATURE_DATA_SHADER_CACHE {}
impl ::std::default::Default for D3D12_FEATURE_DATA_SHADER_CACHE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_SHADER_CACHE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_SHADER_CACHE").field("SupportFlags", &self.SupportFlags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_SHADER_CACHE {
    fn eq(&self, other: &Self) -> bool {
        self.SupportFlags == other.SupportFlags
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_SHADER_CACHE {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_SHADER_CACHE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_FEATURE_DATA_SHADER_MODEL {
    pub HighestShaderModel: D3D_SHADER_MODEL,
}
impl D3D12_FEATURE_DATA_SHADER_MODEL {}
impl ::std::default::Default for D3D12_FEATURE_DATA_SHADER_MODEL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_FEATURE_DATA_SHADER_MODEL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FEATURE_DATA_SHADER_MODEL").field("HighestShaderModel", &self.HighestShaderModel).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_FEATURE_DATA_SHADER_MODEL {
    fn eq(&self, other: &Self) -> bool {
        self.HighestShaderModel == other.HighestShaderModel
    }
}
impl ::std::cmp::Eq for D3D12_FEATURE_DATA_SHADER_MODEL {}
unsafe impl ::windows::runtime::Abi for D3D12_FEATURE_DATA_SHADER_MODEL {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FENCE_FLAGS(pub u32);
pub const D3D12_FENCE_FLAG_NONE: D3D12_FENCE_FLAGS = D3D12_FENCE_FLAGS(0u32);
pub const D3D12_FENCE_FLAG_SHARED: D3D12_FENCE_FLAGS = D3D12_FENCE_FLAGS(1u32);
pub const D3D12_FENCE_FLAG_SHARED_CROSS_ADAPTER: D3D12_FENCE_FLAGS = D3D12_FENCE_FLAGS(2u32);
pub const D3D12_FENCE_FLAG_NON_MONITORED: D3D12_FENCE_FLAGS = D3D12_FENCE_FLAGS(4u32);
impl ::std::convert::From<u32> for D3D12_FENCE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FENCE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_FENCE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_FENCE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_FENCE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_FENCE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_FENCE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FILL_MODE(pub i32);
pub const D3D12_FILL_MODE_WIREFRAME: D3D12_FILL_MODE = D3D12_FILL_MODE(2i32);
pub const D3D12_FILL_MODE_SOLID: D3D12_FILL_MODE = D3D12_FILL_MODE(3i32);
impl ::std::convert::From<i32> for D3D12_FILL_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FILL_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FILTER(pub i32);
pub const D3D12_FILTER_MIN_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(0i32);
pub const D3D12_FILTER_MIN_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(1i32);
pub const D3D12_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(4i32);
pub const D3D12_FILTER_MIN_POINT_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(5i32);
pub const D3D12_FILTER_MIN_LINEAR_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(16i32);
pub const D3D12_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(17i32);
pub const D3D12_FILTER_MIN_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(20i32);
pub const D3D12_FILTER_MIN_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(21i32);
pub const D3D12_FILTER_ANISOTROPIC: D3D12_FILTER = D3D12_FILTER(85i32);
pub const D3D12_FILTER_COMPARISON_MIN_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(128i32);
pub const D3D12_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(129i32);
pub const D3D12_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(132i32);
pub const D3D12_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(133i32);
pub const D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(144i32);
pub const D3D12_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(145i32);
pub const D3D12_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(148i32);
pub const D3D12_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(149i32);
pub const D3D12_FILTER_COMPARISON_ANISOTROPIC: D3D12_FILTER = D3D12_FILTER(213i32);
pub const D3D12_FILTER_MINIMUM_MIN_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(256i32);
pub const D3D12_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(257i32);
pub const D3D12_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(260i32);
pub const D3D12_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(261i32);
pub const D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(272i32);
pub const D3D12_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(273i32);
pub const D3D12_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(276i32);
pub const D3D12_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(277i32);
pub const D3D12_FILTER_MINIMUM_ANISOTROPIC: D3D12_FILTER = D3D12_FILTER(341i32);
pub const D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(384i32);
pub const D3D12_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(385i32);
pub const D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(388i32);
pub const D3D12_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(389i32);
pub const D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT: D3D12_FILTER = D3D12_FILTER(400i32);
pub const D3D12_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(401i32);
pub const D3D12_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT: D3D12_FILTER = D3D12_FILTER(404i32);
pub const D3D12_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR: D3D12_FILTER = D3D12_FILTER(405i32);
pub const D3D12_FILTER_MAXIMUM_ANISOTROPIC: D3D12_FILTER = D3D12_FILTER(469i32);
impl ::std::convert::From<i32> for D3D12_FILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FILTER_REDUCTION_TYPE(pub i32);
pub const D3D12_FILTER_REDUCTION_TYPE_STANDARD: D3D12_FILTER_REDUCTION_TYPE = D3D12_FILTER_REDUCTION_TYPE(0i32);
pub const D3D12_FILTER_REDUCTION_TYPE_COMPARISON: D3D12_FILTER_REDUCTION_TYPE = D3D12_FILTER_REDUCTION_TYPE(1i32);
pub const D3D12_FILTER_REDUCTION_TYPE_MINIMUM: D3D12_FILTER_REDUCTION_TYPE = D3D12_FILTER_REDUCTION_TYPE(2i32);
pub const D3D12_FILTER_REDUCTION_TYPE_MAXIMUM: D3D12_FILTER_REDUCTION_TYPE = D3D12_FILTER_REDUCTION_TYPE(3i32);
impl ::std::convert::From<i32> for D3D12_FILTER_REDUCTION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FILTER_REDUCTION_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_FILTER_REDUCTION_TYPE_MASK: u32 = 3u32;
pub const D3D12_FILTER_REDUCTION_TYPE_SHIFT: u32 = 7u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FILTER_TYPE(pub i32);
pub const D3D12_FILTER_TYPE_POINT: D3D12_FILTER_TYPE = D3D12_FILTER_TYPE(0i32);
pub const D3D12_FILTER_TYPE_LINEAR: D3D12_FILTER_TYPE = D3D12_FILTER_TYPE(1i32);
impl ::std::convert::From<i32> for D3D12_FILTER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FILTER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_FILTER_TYPE_MASK: u32 = 3u32;
pub const D3D12_FLOAT16_FUSED_TOLERANCE_IN_ULP: f64 = 0.6f64;
pub const D3D12_FLOAT32_MAX: f32 = 340282350000000000000000000000000000000f32;
pub const D3D12_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP: f32 = 0.6f32;
pub const D3D12_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR: f32 = 2.4f32;
pub const D3D12_FLOAT_TO_SRGB_EXPONENT_NUMERATOR: f32 = 1f32;
pub const D3D12_FLOAT_TO_SRGB_OFFSET: f32 = 0.055f32;
pub const D3D12_FLOAT_TO_SRGB_SCALE_1: f32 = 12.92f32;
pub const D3D12_FLOAT_TO_SRGB_SCALE_2: f32 = 1.055f32;
pub const D3D12_FLOAT_TO_SRGB_THRESHOLD: f32 = 0.0031308f32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FORMAT_SUPPORT1(pub u32);
pub const D3D12_FORMAT_SUPPORT1_NONE: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(0u32);
pub const D3D12_FORMAT_SUPPORT1_BUFFER: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(1u32);
pub const D3D12_FORMAT_SUPPORT1_IA_VERTEX_BUFFER: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(2u32);
pub const D3D12_FORMAT_SUPPORT1_IA_INDEX_BUFFER: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(4u32);
pub const D3D12_FORMAT_SUPPORT1_SO_BUFFER: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(8u32);
pub const D3D12_FORMAT_SUPPORT1_TEXTURE1D: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(16u32);
pub const D3D12_FORMAT_SUPPORT1_TEXTURE2D: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(32u32);
pub const D3D12_FORMAT_SUPPORT1_TEXTURE3D: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(64u32);
pub const D3D12_FORMAT_SUPPORT1_TEXTURECUBE: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(128u32);
pub const D3D12_FORMAT_SUPPORT1_SHADER_LOAD: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(256u32);
pub const D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(512u32);
pub const D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE_COMPARISON: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(1024u32);
pub const D3D12_FORMAT_SUPPORT1_SHADER_SAMPLE_MONO_TEXT: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(2048u32);
pub const D3D12_FORMAT_SUPPORT1_MIP: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(4096u32);
pub const D3D12_FORMAT_SUPPORT1_RENDER_TARGET: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(16384u32);
pub const D3D12_FORMAT_SUPPORT1_BLENDABLE: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(32768u32);
pub const D3D12_FORMAT_SUPPORT1_DEPTH_STENCIL: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(65536u32);
pub const D3D12_FORMAT_SUPPORT1_MULTISAMPLE_RESOLVE: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(262144u32);
pub const D3D12_FORMAT_SUPPORT1_DISPLAY: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(524288u32);
pub const D3D12_FORMAT_SUPPORT1_CAST_WITHIN_BIT_LAYOUT: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(1048576u32);
pub const D3D12_FORMAT_SUPPORT1_MULTISAMPLE_RENDERTARGET: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(2097152u32);
pub const D3D12_FORMAT_SUPPORT1_MULTISAMPLE_LOAD: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(4194304u32);
pub const D3D12_FORMAT_SUPPORT1_SHADER_GATHER: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(8388608u32);
pub const D3D12_FORMAT_SUPPORT1_BACK_BUFFER_CAST: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(16777216u32);
pub const D3D12_FORMAT_SUPPORT1_TYPED_UNORDERED_ACCESS_VIEW: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(33554432u32);
pub const D3D12_FORMAT_SUPPORT1_SHADER_GATHER_COMPARISON: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(67108864u32);
pub const D3D12_FORMAT_SUPPORT1_DECODER_OUTPUT: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(134217728u32);
pub const D3D12_FORMAT_SUPPORT1_VIDEO_PROCESSOR_OUTPUT: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(268435456u32);
pub const D3D12_FORMAT_SUPPORT1_VIDEO_PROCESSOR_INPUT: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(536870912u32);
pub const D3D12_FORMAT_SUPPORT1_VIDEO_ENCODER: D3D12_FORMAT_SUPPORT1 = D3D12_FORMAT_SUPPORT1(1073741824u32);
impl ::std::convert::From<u32> for D3D12_FORMAT_SUPPORT1 {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FORMAT_SUPPORT1 {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_FORMAT_SUPPORT1 {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_FORMAT_SUPPORT1 {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_FORMAT_SUPPORT1 {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_FORMAT_SUPPORT1 {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_FORMAT_SUPPORT1 {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_FORMAT_SUPPORT2(pub u32);
pub const D3D12_FORMAT_SUPPORT2_NONE: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(0u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_ADD: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(1u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(2u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(4u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(8u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(16u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(32u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_TYPED_LOAD: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(64u32);
pub const D3D12_FORMAT_SUPPORT2_UAV_TYPED_STORE: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(128u32);
pub const D3D12_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(256u32);
pub const D3D12_FORMAT_SUPPORT2_TILED: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(512u32);
pub const D3D12_FORMAT_SUPPORT2_MULTIPLANE_OVERLAY: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(16384u32);
pub const D3D12_FORMAT_SUPPORT2_SAMPLER_FEEDBACK: D3D12_FORMAT_SUPPORT2 = D3D12_FORMAT_SUPPORT2(32768u32);
impl ::std::convert::From<u32> for D3D12_FORMAT_SUPPORT2 {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_FORMAT_SUPPORT2 {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_FORMAT_SUPPORT2 {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_FORMAT_SUPPORT2 {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_FORMAT_SUPPORT2 {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_FORMAT_SUPPORT2 {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_FORMAT_SUPPORT2 {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_FTOI_INSTRUCTION_MAX_INPUT: f32 = 2147483600f32;
pub const D3D12_FTOI_INSTRUCTION_MIN_INPUT: f32 = -2147483600f32;
pub const D3D12_FTOU_INSTRUCTION_MAX_INPUT: f32 = 4294967300f32;
pub const D3D12_FTOU_INSTRUCTION_MIN_INPUT: f32 = 0f32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
pub struct D3D12_FUNCTION_DESC {
    pub Version: u32,
    pub Creator: super::super::Foundation::PSTR,
    pub Flags: u32,
    pub ConstantBuffers: u32,
    pub BoundResources: u32,
    pub InstructionCount: u32,
    pub TempRegisterCount: u32,
    pub TempArrayCount: u32,
    pub DefCount: u32,
    pub DclCount: u32,
    pub TextureNormalInstructions: u32,
    pub TextureLoadInstructions: u32,
    pub TextureCompInstructions: u32,
    pub TextureBiasInstructions: u32,
    pub TextureGradientInstructions: u32,
    pub FloatInstructionCount: u32,
    pub IntInstructionCount: u32,
    pub UintInstructionCount: u32,
    pub StaticFlowControlCount: u32,
    pub DynamicFlowControlCount: u32,
    pub MacroInstructionCount: u32,
    pub ArrayInstructionCount: u32,
    pub MovInstructionCount: u32,
    pub MovcInstructionCount: u32,
    pub ConversionInstructionCount: u32,
    pub BitwiseInstructionCount: u32,
    pub MinFeatureLevel: super::Direct3D11::D3D_FEATURE_LEVEL,
    pub RequiredFeatureFlags: u64,
    pub Name: super::super::Foundation::PSTR,
    pub FunctionParameterCount: i32,
    pub HasReturn: super::super::Foundation::BOOL,
    pub Has10Level9VertexShader: super::super::Foundation::BOOL,
    pub Has10Level9PixelShader: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl D3D12_FUNCTION_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::default::Default for D3D12_FUNCTION_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::fmt::Debug for D3D12_FUNCTION_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_FUNCTION_DESC")
            .field("Version", &self.Version)
            .field("Creator", &self.Creator)
            .field("Flags", &self.Flags)
            .field("ConstantBuffers", &self.ConstantBuffers)
            .field("BoundResources", &self.BoundResources)
            .field("InstructionCount", &self.InstructionCount)
            .field("TempRegisterCount", &self.TempRegisterCount)
            .field("TempArrayCount", &self.TempArrayCount)
            .field("DefCount", &self.DefCount)
            .field("DclCount", &self.DclCount)
            .field("TextureNormalInstructions", &self.TextureNormalInstructions)
            .field("TextureLoadInstructions", &self.TextureLoadInstructions)
            .field("TextureCompInstructions", &self.TextureCompInstructions)
            .field("TextureBiasInstructions", &self.TextureBiasInstructions)
            .field("TextureGradientInstructions", &self.TextureGradientInstructions)
            .field("FloatInstructionCount", &self.FloatInstructionCount)
            .field("IntInstructionCount", &self.IntInstructionCount)
            .field("UintInstructionCount", &self.UintInstructionCount)
            .field("StaticFlowControlCount", &self.StaticFlowControlCount)
            .field("DynamicFlowControlCount", &self.DynamicFlowControlCount)
            .field("MacroInstructionCount", &self.MacroInstructionCount)
            .field("ArrayInstructionCount", &self.ArrayInstructionCount)
            .field("MovInstructionCount", &self.MovInstructionCount)
            .field("MovcInstructionCount", &self.MovcInstructionCount)
            .field("ConversionInstructionCount", &self.ConversionInstructionCount)
            .field("BitwiseInstructionCount", &self.BitwiseInstructionCount)
            .field("MinFeatureLevel", &self.MinFeatureLevel)
            .field("RequiredFeatureFlags", &self.RequiredFeatureFlags)
            .field("Name", &self.Name)
            .field("FunctionParameterCount", &self.FunctionParameterCount)
            .field("HasReturn", &self.HasReturn)
            .field("Has10Level9VertexShader", &self.Has10Level9VertexShader)
            .field("Has10Level9PixelShader", &self.Has10Level9PixelShader)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::PartialEq for D3D12_FUNCTION_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version
            && self.Creator == other.Creator
            && self.Flags == other.Flags
            && self.ConstantBuffers == other.ConstantBuffers
            && self.BoundResources == other.BoundResources
            && self.InstructionCount == other.InstructionCount
            && self.TempRegisterCount == other.TempRegisterCount
            && self.TempArrayCount == other.TempArrayCount
            && self.DefCount == other.DefCount
            && self.DclCount == other.DclCount
            && self.TextureNormalInstructions == other.TextureNormalInstructions
            && self.TextureLoadInstructions == other.TextureLoadInstructions
            && self.TextureCompInstructions == other.TextureCompInstructions
            && self.TextureBiasInstructions == other.TextureBiasInstructions
            && self.TextureGradientInstructions == other.TextureGradientInstructions
            && self.FloatInstructionCount == other.FloatInstructionCount
            && self.IntInstructionCount == other.IntInstructionCount
            && self.UintInstructionCount == other.UintInstructionCount
            && self.StaticFlowControlCount == other.StaticFlowControlCount
            && self.DynamicFlowControlCount == other.DynamicFlowControlCount
            && self.MacroInstructionCount == other.MacroInstructionCount
            && self.ArrayInstructionCount == other.ArrayInstructionCount
            && self.MovInstructionCount == other.MovInstructionCount
            && self.MovcInstructionCount == other.MovcInstructionCount
            && self.ConversionInstructionCount == other.ConversionInstructionCount
            && self.BitwiseInstructionCount == other.BitwiseInstructionCount
            && self.MinFeatureLevel == other.MinFeatureLevel
            && self.RequiredFeatureFlags == other.RequiredFeatureFlags
            && self.Name == other.Name
            && self.FunctionParameterCount == other.FunctionParameterCount
            && self.HasReturn == other.HasReturn
            && self.Has10Level9VertexShader == other.Has10Level9VertexShader
            && self.Has10Level9PixelShader == other.Has10Level9PixelShader
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::Eq for D3D12_FUNCTION_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
unsafe impl ::windows::runtime::Abi for D3D12_FUNCTION_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D3D12_GLOBAL_ROOT_SIGNATURE {
    pub pGlobalRootSignature: ::std::option::Option<ID3D12RootSignature>,
}
impl D3D12_GLOBAL_ROOT_SIGNATURE {}
impl ::std::default::Default for D3D12_GLOBAL_ROOT_SIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_GLOBAL_ROOT_SIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_GLOBAL_ROOT_SIGNATURE").field("pGlobalRootSignature", &self.pGlobalRootSignature).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_GLOBAL_ROOT_SIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.pGlobalRootSignature == other.pGlobalRootSignature
    }
}
impl ::std::cmp::Eq for D3D12_GLOBAL_ROOT_SIGNATURE {}
unsafe impl ::windows::runtime::Abi for D3D12_GLOBAL_ROOT_SIGNATURE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_GPU_BASED_VALIDATION_FLAGS(pub i32);
pub const D3D12_GPU_BASED_VALIDATION_FLAGS_NONE: D3D12_GPU_BASED_VALIDATION_FLAGS = D3D12_GPU_BASED_VALIDATION_FLAGS(0i32);
pub const D3D12_GPU_BASED_VALIDATION_FLAGS_DISABLE_STATE_TRACKING: D3D12_GPU_BASED_VALIDATION_FLAGS = D3D12_GPU_BASED_VALIDATION_FLAGS(1i32);
impl ::std::convert::From<i32> for D3D12_GPU_BASED_VALIDATION_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_GPU_BASED_VALIDATION_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS(pub i32);
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_NONE: D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS(0i32);
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_TRACKING_ONLY_SHADERS: D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS(1i32);
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_UNGUARDED_VALIDATION_SHADERS: D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS(2i32);
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAG_FRONT_LOAD_CREATE_GUARDED_VALIDATION_SHADERS: D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS(4i32);
pub const D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS_VALID_MASK: D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS = D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS(7i32);
impl ::std::convert::From<i32> for D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_GPU_BASED_VALIDATION_PIPELINE_STATE_CREATE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE(pub i32);
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_NONE: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE(0i32);
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_STATE_TRACKING_ONLY: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE(1i32);
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_UNGUARDED_VALIDATION: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE(2i32);
pub const D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE_GUARDED_VALIDATION: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE(3i32);
pub const NUM_D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODES: D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE = D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE(4i32);
impl ::std::convert::From<i32> for D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_GPU_BASED_VALIDATION_SHADER_PATCH_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_GPU_DESCRIPTOR_HANDLE {
    pub ptr: u64,
}
impl D3D12_GPU_DESCRIPTOR_HANDLE {}
impl ::std::default::Default for D3D12_GPU_DESCRIPTOR_HANDLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_GPU_DESCRIPTOR_HANDLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_GPU_DESCRIPTOR_HANDLE").field("ptr", &self.ptr).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_GPU_DESCRIPTOR_HANDLE {
    fn eq(&self, other: &Self) -> bool {
        self.ptr == other.ptr
    }
}
impl ::std::cmp::Eq for D3D12_GPU_DESCRIPTOR_HANDLE {}
unsafe impl ::windows::runtime::Abi for D3D12_GPU_DESCRIPTOR_HANDLE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {
    pub StartAddress: u64,
    pub StrideInBytes: u64,
}
impl D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {}
impl ::std::default::Default for D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE").field("StartAddress", &self.StartAddress).field("StrideInBytes", &self.StrideInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {
    fn eq(&self, other: &Self) -> bool {
        self.StartAddress == other.StartAddress && self.StrideInBytes == other.StrideInBytes
    }
}
impl ::std::cmp::Eq for D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {}
unsafe impl ::windows::runtime::Abi for D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_GPU_VIRTUAL_ADDRESS_RANGE {
    pub StartAddress: u64,
    pub SizeInBytes: u64,
}
impl D3D12_GPU_VIRTUAL_ADDRESS_RANGE {}
impl ::std::default::Default for D3D12_GPU_VIRTUAL_ADDRESS_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_GPU_VIRTUAL_ADDRESS_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_GPU_VIRTUAL_ADDRESS_RANGE").field("StartAddress", &self.StartAddress).field("SizeInBytes", &self.SizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_GPU_VIRTUAL_ADDRESS_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.StartAddress == other.StartAddress && self.SizeInBytes == other.SizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_GPU_VIRTUAL_ADDRESS_RANGE {}
unsafe impl ::windows::runtime::Abi for D3D12_GPU_VIRTUAL_ADDRESS_RANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {
    pub StartAddress: u64,
    pub SizeInBytes: u64,
    pub StrideInBytes: u64,
}
impl D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {}
impl ::std::default::Default for D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE").field("StartAddress", &self.StartAddress).field("SizeInBytes", &self.SizeInBytes).field("StrideInBytes", &self.StrideInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {
    fn eq(&self, other: &Self) -> bool {
        self.StartAddress == other.StartAddress && self.SizeInBytes == other.SizeInBytes && self.StrideInBytes == other.StrideInBytes
    }
}
impl ::std::cmp::Eq for D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {}
unsafe impl ::windows::runtime::Abi for D3D12_GPU_VIRTUAL_ADDRESS_RANGE_AND_STRIDE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    pub pRootSignature: ::std::option::Option<ID3D12RootSignature>,
    pub VS: D3D12_SHADER_BYTECODE,
    pub PS: D3D12_SHADER_BYTECODE,
    pub DS: D3D12_SHADER_BYTECODE,
    pub HS: D3D12_SHADER_BYTECODE,
    pub GS: D3D12_SHADER_BYTECODE,
    pub StreamOutput: D3D12_STREAM_OUTPUT_DESC,
    pub BlendState: D3D12_BLEND_DESC,
    pub SampleMask: u32,
    pub RasterizerState: D3D12_RASTERIZER_DESC,
    pub DepthStencilState: D3D12_DEPTH_STENCIL_DESC,
    pub InputLayout: D3D12_INPUT_LAYOUT_DESC,
    pub IBStripCutValue: D3D12_INDEX_BUFFER_STRIP_CUT_VALUE,
    pub PrimitiveTopologyType: D3D12_PRIMITIVE_TOPOLOGY_TYPE,
    pub NumRenderTargets: u32,
    pub RTVFormats: [super::Dxgi::DXGI_FORMAT; 8],
    pub DSVFormat: super::Dxgi::DXGI_FORMAT,
    pub SampleDesc: super::Dxgi::DXGI_SAMPLE_DESC,
    pub NodeMask: u32,
    pub CachedPSO: D3D12_CACHED_PIPELINE_STATE,
    pub Flags: D3D12_PIPELINE_STATE_FLAGS,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_GRAPHICS_PIPELINE_STATE_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_GRAPHICS_PIPELINE_STATE_DESC")
            .field("pRootSignature", &self.pRootSignature)
            .field("VS", &self.VS)
            .field("PS", &self.PS)
            .field("DS", &self.DS)
            .field("HS", &self.HS)
            .field("GS", &self.GS)
            .field("StreamOutput", &self.StreamOutput)
            .field("BlendState", &self.BlendState)
            .field("SampleMask", &self.SampleMask)
            .field("RasterizerState", &self.RasterizerState)
            .field("DepthStencilState", &self.DepthStencilState)
            .field("InputLayout", &self.InputLayout)
            .field("IBStripCutValue", &self.IBStripCutValue)
            .field("PrimitiveTopologyType", &self.PrimitiveTopologyType)
            .field("NumRenderTargets", &self.NumRenderTargets)
            .field("RTVFormats", &self.RTVFormats)
            .field("DSVFormat", &self.DSVFormat)
            .field("SampleDesc", &self.SampleDesc)
            .field("NodeMask", &self.NodeMask)
            .field("CachedPSO", &self.CachedPSO)
            .field("Flags", &self.Flags)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.pRootSignature == other.pRootSignature
            && self.VS == other.VS
            && self.PS == other.PS
            && self.DS == other.DS
            && self.HS == other.HS
            && self.GS == other.GS
            && self.StreamOutput == other.StreamOutput
            && self.BlendState == other.BlendState
            && self.SampleMask == other.SampleMask
            && self.RasterizerState == other.RasterizerState
            && self.DepthStencilState == other.DepthStencilState
            && self.InputLayout == other.InputLayout
            && self.IBStripCutValue == other.IBStripCutValue
            && self.PrimitiveTopologyType == other.PrimitiveTopologyType
            && self.NumRenderTargets == other.NumRenderTargets
            && self.RTVFormats == other.RTVFormats
            && self.DSVFormat == other.DSVFormat
            && self.SampleDesc == other.SampleDesc
            && self.NodeMask == other.NodeMask
            && self.CachedPSO == other.CachedPSO
            && self.Flags == other.Flags
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_GRAPHICS_PIPELINE_STATE_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_GRAPHICS_PIPELINE_STATE_DESC {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_GRAPHICS_STATES(pub u32);
pub const D3D12_GRAPHICS_STATE_NONE: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(0u32);
pub const D3D12_GRAPHICS_STATE_IA_VERTEX_BUFFERS: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(1u32);
pub const D3D12_GRAPHICS_STATE_IA_INDEX_BUFFER: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(2u32);
pub const D3D12_GRAPHICS_STATE_IA_PRIMITIVE_TOPOLOGY: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(4u32);
pub const D3D12_GRAPHICS_STATE_DESCRIPTOR_HEAP: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(8u32);
pub const D3D12_GRAPHICS_STATE_GRAPHICS_ROOT_SIGNATURE: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(16u32);
pub const D3D12_GRAPHICS_STATE_COMPUTE_ROOT_SIGNATURE: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(32u32);
pub const D3D12_GRAPHICS_STATE_RS_VIEWPORTS: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(64u32);
pub const D3D12_GRAPHICS_STATE_RS_SCISSOR_RECTS: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(128u32);
pub const D3D12_GRAPHICS_STATE_PREDICATION: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(256u32);
pub const D3D12_GRAPHICS_STATE_OM_RENDER_TARGETS: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(512u32);
pub const D3D12_GRAPHICS_STATE_OM_STENCIL_REF: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(1024u32);
pub const D3D12_GRAPHICS_STATE_OM_BLEND_FACTOR: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(2048u32);
pub const D3D12_GRAPHICS_STATE_PIPELINE_STATE: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(4096u32);
pub const D3D12_GRAPHICS_STATE_SO_TARGETS: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(8192u32);
pub const D3D12_GRAPHICS_STATE_OM_DEPTH_BOUNDS: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(16384u32);
pub const D3D12_GRAPHICS_STATE_SAMPLE_POSITIONS: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(32768u32);
pub const D3D12_GRAPHICS_STATE_VIEW_INSTANCE_MASK: D3D12_GRAPHICS_STATES = D3D12_GRAPHICS_STATES(65536u32);
impl ::std::convert::From<u32> for D3D12_GRAPHICS_STATES {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_GRAPHICS_STATES {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_GRAPHICS_STATES {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_GRAPHICS_STATES {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_GRAPHICS_STATES {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_GRAPHICS_STATES {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_GRAPHICS_STATES {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_GS_INPUT_INSTANCE_ID_READS_PER_INST: u32 = 2u32;
pub const D3D12_GS_INPUT_INSTANCE_ID_READ_PORTS: u32 = 1u32;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_GS_INPUT_INSTANCE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_GS_INPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_GS_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_GS_INPUT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_GS_INPUT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_GS_INPUT_REGISTER_VERTICES: u32 = 32u32;
pub const D3D12_GS_MAX_INSTANCE_COUNT: u32 = 32u32;
pub const D3D12_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES: u32 = 1024u32;
pub const D3D12_GS_OUTPUT_ELEMENTS: u32 = 32u32;
pub const D3D12_GS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_GS_OUTPUT_REGISTER_COUNT: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_HEAP_DESC {
    pub SizeInBytes: u64,
    pub Properties: D3D12_HEAP_PROPERTIES,
    pub Alignment: u64,
    pub Flags: D3D12_HEAP_FLAGS,
}
impl D3D12_HEAP_DESC {}
impl ::std::default::Default for D3D12_HEAP_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_HEAP_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_HEAP_DESC").field("SizeInBytes", &self.SizeInBytes).field("Properties", &self.Properties).field("Alignment", &self.Alignment).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_HEAP_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.SizeInBytes == other.SizeInBytes && self.Properties == other.Properties && self.Alignment == other.Alignment && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_HEAP_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_HEAP_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_HEAP_FLAGS(pub u32);
pub const D3D12_HEAP_FLAG_NONE: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(0u32);
pub const D3D12_HEAP_FLAG_SHARED: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(1u32);
pub const D3D12_HEAP_FLAG_DENY_BUFFERS: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(4u32);
pub const D3D12_HEAP_FLAG_ALLOW_DISPLAY: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(8u32);
pub const D3D12_HEAP_FLAG_SHARED_CROSS_ADAPTER: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(32u32);
pub const D3D12_HEAP_FLAG_DENY_RT_DS_TEXTURES: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(64u32);
pub const D3D12_HEAP_FLAG_DENY_NON_RT_DS_TEXTURES: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(128u32);
pub const D3D12_HEAP_FLAG_HARDWARE_PROTECTED: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(256u32);
pub const D3D12_HEAP_FLAG_ALLOW_WRITE_WATCH: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(512u32);
pub const D3D12_HEAP_FLAG_ALLOW_SHADER_ATOMICS: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(1024u32);
pub const D3D12_HEAP_FLAG_CREATE_NOT_RESIDENT: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(2048u32);
pub const D3D12_HEAP_FLAG_CREATE_NOT_ZEROED: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(4096u32);
pub const D3D12_HEAP_FLAG_ALLOW_ALL_BUFFERS_AND_TEXTURES: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(0u32);
pub const D3D12_HEAP_FLAG_ALLOW_ONLY_BUFFERS: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(192u32);
pub const D3D12_HEAP_FLAG_ALLOW_ONLY_NON_RT_DS_TEXTURES: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(68u32);
pub const D3D12_HEAP_FLAG_ALLOW_ONLY_RT_DS_TEXTURES: D3D12_HEAP_FLAGS = D3D12_HEAP_FLAGS(132u32);
impl ::std::convert::From<u32> for D3D12_HEAP_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_HEAP_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_HEAP_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_HEAP_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_HEAP_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_HEAP_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_HEAP_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_HEAP_PROPERTIES {
    pub Type: D3D12_HEAP_TYPE,
    pub CPUPageProperty: D3D12_CPU_PAGE_PROPERTY,
    pub MemoryPoolPreference: D3D12_MEMORY_POOL,
    pub CreationNodeMask: u32,
    pub VisibleNodeMask: u32,
}
impl D3D12_HEAP_PROPERTIES {}
impl ::std::default::Default for D3D12_HEAP_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_HEAP_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_HEAP_PROPERTIES").field("Type", &self.Type).field("CPUPageProperty", &self.CPUPageProperty).field("MemoryPoolPreference", &self.MemoryPoolPreference).field("CreationNodeMask", &self.CreationNodeMask).field("VisibleNodeMask", &self.VisibleNodeMask).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_HEAP_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.CPUPageProperty == other.CPUPageProperty && self.MemoryPoolPreference == other.MemoryPoolPreference && self.CreationNodeMask == other.CreationNodeMask && self.VisibleNodeMask == other.VisibleNodeMask
    }
}
impl ::std::cmp::Eq for D3D12_HEAP_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D3D12_HEAP_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_HEAP_SERIALIZATION_TIER(pub i32);
pub const D3D12_HEAP_SERIALIZATION_TIER_0: D3D12_HEAP_SERIALIZATION_TIER = D3D12_HEAP_SERIALIZATION_TIER(0i32);
pub const D3D12_HEAP_SERIALIZATION_TIER_10: D3D12_HEAP_SERIALIZATION_TIER = D3D12_HEAP_SERIALIZATION_TIER(10i32);
impl ::std::convert::From<i32> for D3D12_HEAP_SERIALIZATION_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_HEAP_SERIALIZATION_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_HEAP_TYPE(pub i32);
pub const D3D12_HEAP_TYPE_DEFAULT: D3D12_HEAP_TYPE = D3D12_HEAP_TYPE(1i32);
pub const D3D12_HEAP_TYPE_UPLOAD: D3D12_HEAP_TYPE = D3D12_HEAP_TYPE(2i32);
pub const D3D12_HEAP_TYPE_READBACK: D3D12_HEAP_TYPE = D3D12_HEAP_TYPE(3i32);
pub const D3D12_HEAP_TYPE_CUSTOM: D3D12_HEAP_TYPE = D3D12_HEAP_TYPE(4i32);
impl ::std::convert::From<i32> for D3D12_HEAP_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_HEAP_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_HIT_GROUP_DESC {
    pub HitGroupExport: super::super::Foundation::PWSTR,
    pub Type: D3D12_HIT_GROUP_TYPE,
    pub AnyHitShaderImport: super::super::Foundation::PWSTR,
    pub ClosestHitShaderImport: super::super::Foundation::PWSTR,
    pub IntersectionShaderImport: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_HIT_GROUP_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_HIT_GROUP_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_HIT_GROUP_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_HIT_GROUP_DESC")
            .field("HitGroupExport", &self.HitGroupExport)
            .field("Type", &self.Type)
            .field("AnyHitShaderImport", &self.AnyHitShaderImport)
            .field("ClosestHitShaderImport", &self.ClosestHitShaderImport)
            .field("IntersectionShaderImport", &self.IntersectionShaderImport)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_HIT_GROUP_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.HitGroupExport == other.HitGroupExport && self.Type == other.Type && self.AnyHitShaderImport == other.AnyHitShaderImport && self.ClosestHitShaderImport == other.ClosestHitShaderImport && self.IntersectionShaderImport == other.IntersectionShaderImport
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_HIT_GROUP_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_HIT_GROUP_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_HIT_GROUP_TYPE(pub i32);
pub const D3D12_HIT_GROUP_TYPE_TRIANGLES: D3D12_HIT_GROUP_TYPE = D3D12_HIT_GROUP_TYPE(0i32);
pub const D3D12_HIT_GROUP_TYPE_PROCEDURAL_PRIMITIVE: D3D12_HIT_GROUP_TYPE = D3D12_HIT_GROUP_TYPE(1i32);
impl ::std::convert::From<i32> for D3D12_HIT_GROUP_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_HIT_GROUP_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_HIT_KIND(pub i32);
pub const D3D12_HIT_KIND_TRIANGLE_FRONT_FACE: D3D12_HIT_KIND = D3D12_HIT_KIND(254i32);
pub const D3D12_HIT_KIND_TRIANGLE_BACK_FACE: D3D12_HIT_KIND = D3D12_HIT_KIND(255i32);
impl ::std::convert::From<i32> for D3D12_HIT_KIND {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_HIT_KIND {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_HS_CONTROL_POINT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 = 4294967295u32;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 = 4294967295u32;
pub const D3D12_HS_MAXTESSFACTOR_LOWER_BOUND: f32 = 1f32;
pub const D3D12_HS_MAXTESSFACTOR_UPPER_BOUND: f32 = 64f32;
pub const D3D12_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 = 3968u32;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS: u32 = 128u32;
pub const D3D12_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES: u32 = 0u32;
pub const D3D12_IA_DEFAULT_PRIMITIVE_TOPOLOGY: u32 = 0u32;
pub const D3D12_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES: u32 = 0u32;
pub const D3D12_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT: u32 = 1u32;
pub const D3D12_IA_INSTANCE_ID_BIT_COUNT: u32 = 32u32;
pub const D3D12_IA_INTEGER_ARITHMETIC_BIT_COUNT: u32 = 32u32;
pub const D3D12_IA_PATCH_MAX_CONTROL_POINT_COUNT: u32 = 32u32;
pub const D3D12_IA_PRIMITIVE_ID_BIT_COUNT: u32 = 32u32;
pub const D3D12_IA_VERTEX_ID_BIT_COUNT: u32 = 32u32;
pub const D3D12_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT: u32 = 32u32;
pub const D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS: u32 = 128u32;
pub const D3D12_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT: u32 = 32u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_INDEX_BUFFER_STRIP_CUT_VALUE(pub i32);
pub const D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_DISABLED: D3D12_INDEX_BUFFER_STRIP_CUT_VALUE = D3D12_INDEX_BUFFER_STRIP_CUT_VALUE(0i32);
pub const D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFF: D3D12_INDEX_BUFFER_STRIP_CUT_VALUE = D3D12_INDEX_BUFFER_STRIP_CUT_VALUE(1i32);
pub const D3D12_INDEX_BUFFER_STRIP_CUT_VALUE_0xFFFFFFFF: D3D12_INDEX_BUFFER_STRIP_CUT_VALUE = D3D12_INDEX_BUFFER_STRIP_CUT_VALUE(2i32);
impl ::std::convert::From<i32> for D3D12_INDEX_BUFFER_STRIP_CUT_VALUE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_INDEX_BUFFER_STRIP_CUT_VALUE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_INDEX_BUFFER_VIEW {
    pub BufferLocation: u64,
    pub SizeInBytes: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_INDEX_BUFFER_VIEW {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_INDEX_BUFFER_VIEW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_INDEX_BUFFER_VIEW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_INDEX_BUFFER_VIEW").field("BufferLocation", &self.BufferLocation).field("SizeInBytes", &self.SizeInBytes).field("Format", &self.Format).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_INDEX_BUFFER_VIEW {
    fn eq(&self, other: &Self) -> bool {
        self.BufferLocation == other.BufferLocation && self.SizeInBytes == other.SizeInBytes && self.Format == other.Format
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_INDEX_BUFFER_VIEW {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_INDEX_BUFFER_VIEW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC {
    pub Type: D3D12_INDIRECT_ARGUMENT_TYPE,
    pub Anonymous: D3D12_INDIRECT_ARGUMENT_DESC_0,
}
impl D3D12_INDIRECT_ARGUMENT_DESC {}
impl ::std::default::Default for D3D12_INDIRECT_ARGUMENT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_INDIRECT_ARGUMENT_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_INDIRECT_ARGUMENT_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_INDIRECT_ARGUMENT_DESC_0 {
    pub VertexBuffer: D3D12_INDIRECT_ARGUMENT_DESC_0_4,
    pub Constant: D3D12_INDIRECT_ARGUMENT_DESC_0_1,
    pub ConstantBufferView: D3D12_INDIRECT_ARGUMENT_DESC_0_0,
    pub ShaderResourceView: D3D12_INDIRECT_ARGUMENT_DESC_0_2,
    pub UnorderedAccessView: D3D12_INDIRECT_ARGUMENT_DESC_0_3,
}
impl D3D12_INDIRECT_ARGUMENT_DESC_0 {}
impl ::std::default::Default for D3D12_INDIRECT_ARGUMENT_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_INDIRECT_ARGUMENT_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_INDIRECT_ARGUMENT_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC_0_0 {
    pub RootParameterIndex: u32,
}
impl D3D12_INDIRECT_ARGUMENT_DESC_0_0 {}
impl ::std::default::Default for D3D12_INDIRECT_ARGUMENT_DESC_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_INDIRECT_ARGUMENT_DESC_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_ConstantBufferView_e__Struct").field("RootParameterIndex", &self.RootParameterIndex).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_INDIRECT_ARGUMENT_DESC_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.RootParameterIndex == other.RootParameterIndex
    }
}
impl ::std::cmp::Eq for D3D12_INDIRECT_ARGUMENT_DESC_0_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_DESC_0_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC_0_1 {
    pub RootParameterIndex: u32,
    pub DestOffsetIn32BitValues: u32,
    pub Num32BitValuesToSet: u32,
}
impl D3D12_INDIRECT_ARGUMENT_DESC_0_1 {}
impl ::std::default::Default for D3D12_INDIRECT_ARGUMENT_DESC_0_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_INDIRECT_ARGUMENT_DESC_0_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Constant_e__Struct").field("RootParameterIndex", &self.RootParameterIndex).field("DestOffsetIn32BitValues", &self.DestOffsetIn32BitValues).field("Num32BitValuesToSet", &self.Num32BitValuesToSet).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_INDIRECT_ARGUMENT_DESC_0_1 {
    fn eq(&self, other: &Self) -> bool {
        self.RootParameterIndex == other.RootParameterIndex && self.DestOffsetIn32BitValues == other.DestOffsetIn32BitValues && self.Num32BitValuesToSet == other.Num32BitValuesToSet
    }
}
impl ::std::cmp::Eq for D3D12_INDIRECT_ARGUMENT_DESC_0_1 {}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_DESC_0_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC_0_2 {
    pub RootParameterIndex: u32,
}
impl D3D12_INDIRECT_ARGUMENT_DESC_0_2 {}
impl ::std::default::Default for D3D12_INDIRECT_ARGUMENT_DESC_0_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_INDIRECT_ARGUMENT_DESC_0_2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_ShaderResourceView_e__Struct").field("RootParameterIndex", &self.RootParameterIndex).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_INDIRECT_ARGUMENT_DESC_0_2 {
    fn eq(&self, other: &Self) -> bool {
        self.RootParameterIndex == other.RootParameterIndex
    }
}
impl ::std::cmp::Eq for D3D12_INDIRECT_ARGUMENT_DESC_0_2 {}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_DESC_0_2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC_0_3 {
    pub RootParameterIndex: u32,
}
impl D3D12_INDIRECT_ARGUMENT_DESC_0_3 {}
impl ::std::default::Default for D3D12_INDIRECT_ARGUMENT_DESC_0_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_INDIRECT_ARGUMENT_DESC_0_3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_UnorderedAccessView_e__Struct").field("RootParameterIndex", &self.RootParameterIndex).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_INDIRECT_ARGUMENT_DESC_0_3 {
    fn eq(&self, other: &Self) -> bool {
        self.RootParameterIndex == other.RootParameterIndex
    }
}
impl ::std::cmp::Eq for D3D12_INDIRECT_ARGUMENT_DESC_0_3 {}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_DESC_0_3 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INDIRECT_ARGUMENT_DESC_0_4 {
    pub Slot: u32,
}
impl D3D12_INDIRECT_ARGUMENT_DESC_0_4 {}
impl ::std::default::Default for D3D12_INDIRECT_ARGUMENT_DESC_0_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_INDIRECT_ARGUMENT_DESC_0_4 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_VertexBuffer_e__Struct").field("Slot", &self.Slot).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_INDIRECT_ARGUMENT_DESC_0_4 {
    fn eq(&self, other: &Self) -> bool {
        self.Slot == other.Slot
    }
}
impl ::std::cmp::Eq for D3D12_INDIRECT_ARGUMENT_DESC_0_4 {}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_DESC_0_4 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_INDIRECT_ARGUMENT_TYPE(pub i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_DRAW: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(0i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_DRAW_INDEXED: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(1i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(2i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_VERTEX_BUFFER_VIEW: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(3i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_INDEX_BUFFER_VIEW: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(4i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(5i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_CONSTANT_BUFFER_VIEW: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(6i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_SHADER_RESOURCE_VIEW: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(7i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_UNORDERED_ACCESS_VIEW: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(8i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH_RAYS: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(9i32);
pub const D3D12_INDIRECT_ARGUMENT_TYPE_DISPATCH_MESH: D3D12_INDIRECT_ARGUMENT_TYPE = D3D12_INDIRECT_ARGUMENT_TYPE(10i32);
impl ::std::convert::From<i32> for D3D12_INDIRECT_ARGUMENT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_INDIRECT_ARGUMENT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_INFO_QUEUE_DEFAULT_MESSAGE_COUNT_LIMIT: u32 = 1024u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INFO_QUEUE_FILTER {
    pub AllowList: D3D12_INFO_QUEUE_FILTER_DESC,
    pub DenyList: D3D12_INFO_QUEUE_FILTER_DESC,
}
impl D3D12_INFO_QUEUE_FILTER {}
impl ::std::default::Default for D3D12_INFO_QUEUE_FILTER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_INFO_QUEUE_FILTER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_INFO_QUEUE_FILTER").field("AllowList", &self.AllowList).field("DenyList", &self.DenyList).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_INFO_QUEUE_FILTER {
    fn eq(&self, other: &Self) -> bool {
        self.AllowList == other.AllowList && self.DenyList == other.DenyList
    }
}
impl ::std::cmp::Eq for D3D12_INFO_QUEUE_FILTER {}
unsafe impl ::windows::runtime::Abi for D3D12_INFO_QUEUE_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_INFO_QUEUE_FILTER_DESC {
    pub NumCategories: u32,
    pub pCategoryList: *mut D3D12_MESSAGE_CATEGORY,
    pub NumSeverities: u32,
    pub pSeverityList: *mut D3D12_MESSAGE_SEVERITY,
    pub NumIDs: u32,
    pub pIDList: *mut D3D12_MESSAGE_ID,
}
impl D3D12_INFO_QUEUE_FILTER_DESC {}
impl ::std::default::Default for D3D12_INFO_QUEUE_FILTER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_INFO_QUEUE_FILTER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_INFO_QUEUE_FILTER_DESC").field("NumCategories", &self.NumCategories).field("pCategoryList", &self.pCategoryList).field("NumSeverities", &self.NumSeverities).field("pSeverityList", &self.pSeverityList).field("NumIDs", &self.NumIDs).field("pIDList", &self.pIDList).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_INFO_QUEUE_FILTER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.NumCategories == other.NumCategories && self.pCategoryList == other.pCategoryList && self.NumSeverities == other.NumSeverities && self.pSeverityList == other.pSeverityList && self.NumIDs == other.NumIDs && self.pIDList == other.pIDList
    }
}
impl ::std::cmp::Eq for D3D12_INFO_QUEUE_FILTER_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_INFO_QUEUE_FILTER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_INPUT_CLASSIFICATION(pub i32);
pub const D3D12_INPUT_CLASSIFICATION_PER_VERTEX_DATA: D3D12_INPUT_CLASSIFICATION = D3D12_INPUT_CLASSIFICATION(0i32);
pub const D3D12_INPUT_CLASSIFICATION_PER_INSTANCE_DATA: D3D12_INPUT_CLASSIFICATION = D3D12_INPUT_CLASSIFICATION(1i32);
impl ::std::convert::From<i32> for D3D12_INPUT_CLASSIFICATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_INPUT_CLASSIFICATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D12_INPUT_ELEMENT_DESC {
    pub SemanticName: super::super::Foundation::PSTR,
    pub SemanticIndex: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub InputSlot: u32,
    pub AlignedByteOffset: u32,
    pub InputSlotClass: D3D12_INPUT_CLASSIFICATION,
    pub InstanceDataStepRate: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_INPUT_ELEMENT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D3D12_INPUT_ELEMENT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_INPUT_ELEMENT_DESC")
            .field("SemanticName", &self.SemanticName)
            .field("SemanticIndex", &self.SemanticIndex)
            .field("Format", &self.Format)
            .field("InputSlot", &self.InputSlot)
            .field("AlignedByteOffset", &self.AlignedByteOffset)
            .field("InputSlotClass", &self.InputSlotClass)
            .field("InstanceDataStepRate", &self.InstanceDataStepRate)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_INPUT_ELEMENT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.SemanticName == other.SemanticName && self.SemanticIndex == other.SemanticIndex && self.Format == other.Format && self.InputSlot == other.InputSlot && self.AlignedByteOffset == other.AlignedByteOffset && self.InputSlotClass == other.InputSlotClass && self.InstanceDataStepRate == other.InstanceDataStepRate
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_INPUT_ELEMENT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D12_INPUT_LAYOUT_DESC {
    pub pInputElementDescs: *mut D3D12_INPUT_ELEMENT_DESC,
    pub NumElements: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_INPUT_LAYOUT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_INPUT_LAYOUT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D3D12_INPUT_LAYOUT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_INPUT_LAYOUT_DESC").field("pInputElementDescs", &self.pInputElementDescs).field("NumElements", &self.NumElements).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_INPUT_LAYOUT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.pInputElementDescs == other.pInputElementDescs && self.NumElements == other.NumElements
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_INPUT_LAYOUT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_INPUT_LAYOUT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_INTEGER_DIVIDE_BY_ZERO_QUOTIENT: u32 = 4294967295u32;
pub const D3D12_INTEGER_DIVIDE_BY_ZERO_REMAINDER: u32 = 4294967295u32;
pub const D3D12_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL: u32 = 4294967295u32;
pub const D3D12_KEEP_UNORDERED_ACCESS_VIEWS: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_LIBRARY_DESC {
    pub Creator: super::super::Foundation::PSTR,
    pub Flags: u32,
    pub FunctionCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_LIBRARY_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_LIBRARY_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_LIBRARY_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_LIBRARY_DESC").field("Creator", &self.Creator).field("Flags", &self.Flags).field("FunctionCount", &self.FunctionCount).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_LIBRARY_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Creator == other.Creator && self.Flags == other.Flags && self.FunctionCount == other.FunctionCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_LIBRARY_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_LIBRARY_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_LIFETIME_STATE(pub i32);
pub const D3D12_LIFETIME_STATE_IN_USE: D3D12_LIFETIME_STATE = D3D12_LIFETIME_STATE(0i32);
pub const D3D12_LIFETIME_STATE_NOT_IN_USE: D3D12_LIFETIME_STATE = D3D12_LIFETIME_STATE(1i32);
impl ::std::convert::From<i32> for D3D12_LIFETIME_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_LIFETIME_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_LINEAR_GAMMA: f32 = 1f32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D3D12_LOCAL_ROOT_SIGNATURE {
    pub pLocalRootSignature: ::std::option::Option<ID3D12RootSignature>,
}
impl D3D12_LOCAL_ROOT_SIGNATURE {}
impl ::std::default::Default for D3D12_LOCAL_ROOT_SIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_LOCAL_ROOT_SIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_LOCAL_ROOT_SIGNATURE").field("pLocalRootSignature", &self.pLocalRootSignature).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_LOCAL_ROOT_SIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.pLocalRootSignature == other.pLocalRootSignature
    }
}
impl ::std::cmp::Eq for D3D12_LOCAL_ROOT_SIGNATURE {}
unsafe impl ::windows::runtime::Abi for D3D12_LOCAL_ROOT_SIGNATURE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_LOGIC_OP(pub i32);
pub const D3D12_LOGIC_OP_CLEAR: D3D12_LOGIC_OP = D3D12_LOGIC_OP(0i32);
pub const D3D12_LOGIC_OP_SET: D3D12_LOGIC_OP = D3D12_LOGIC_OP(1i32);
pub const D3D12_LOGIC_OP_COPY: D3D12_LOGIC_OP = D3D12_LOGIC_OP(2i32);
pub const D3D12_LOGIC_OP_COPY_INVERTED: D3D12_LOGIC_OP = D3D12_LOGIC_OP(3i32);
pub const D3D12_LOGIC_OP_NOOP: D3D12_LOGIC_OP = D3D12_LOGIC_OP(4i32);
pub const D3D12_LOGIC_OP_INVERT: D3D12_LOGIC_OP = D3D12_LOGIC_OP(5i32);
pub const D3D12_LOGIC_OP_AND: D3D12_LOGIC_OP = D3D12_LOGIC_OP(6i32);
pub const D3D12_LOGIC_OP_NAND: D3D12_LOGIC_OP = D3D12_LOGIC_OP(7i32);
pub const D3D12_LOGIC_OP_OR: D3D12_LOGIC_OP = D3D12_LOGIC_OP(8i32);
pub const D3D12_LOGIC_OP_NOR: D3D12_LOGIC_OP = D3D12_LOGIC_OP(9i32);
pub const D3D12_LOGIC_OP_XOR: D3D12_LOGIC_OP = D3D12_LOGIC_OP(10i32);
pub const D3D12_LOGIC_OP_EQUIV: D3D12_LOGIC_OP = D3D12_LOGIC_OP(11i32);
pub const D3D12_LOGIC_OP_AND_REVERSE: D3D12_LOGIC_OP = D3D12_LOGIC_OP(12i32);
pub const D3D12_LOGIC_OP_AND_INVERTED: D3D12_LOGIC_OP = D3D12_LOGIC_OP(13i32);
pub const D3D12_LOGIC_OP_OR_REVERSE: D3D12_LOGIC_OP = D3D12_LOGIC_OP(14i32);
pub const D3D12_LOGIC_OP_OR_INVERTED: D3D12_LOGIC_OP = D3D12_LOGIC_OP(15i32);
impl ::std::convert::From<i32> for D3D12_LOGIC_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_LOGIC_OP {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_MAG_FILTER_SHIFT: u32 = 2u32;
pub const D3D12_MAJOR_VERSION: u32 = 12u32;
pub const D3D12_MAX_BORDER_COLOR_COMPONENT: f32 = 1f32;
pub const D3D12_MAX_DEPTH: f32 = 1f32;
pub const D3D12_MAX_LIVE_STATIC_SAMPLERS: u32 = 2032u32;
pub const D3D12_MAX_MAXANISOTROPY: u32 = 16u32;
pub const D3D12_MAX_MULTISAMPLE_SAMPLE_COUNT: u32 = 32u32;
pub const D3D12_MAX_POSITION_VALUE: f32 = 34028236000000000000000000000000000f32;
pub const D3D12_MAX_ROOT_COST: u32 = 64u32;
pub const D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_1: u32 = 1000000u32;
pub const D3D12_MAX_SHADER_VISIBLE_DESCRIPTOR_HEAP_SIZE_TIER_2: u32 = 1000000u32;
pub const D3D12_MAX_SHADER_VISIBLE_SAMPLER_HEAP_SIZE: u32 = 2048u32;
pub const D3D12_MAX_TEXTURE_DIMENSION_2_TO_EXP: u32 = 17u32;
pub const D3D12_MAX_VIEW_INSTANCE_COUNT: u32 = 4u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MEASUREMENTS_ACTION(pub i32);
pub const D3D12_MEASUREMENTS_ACTION_KEEP_ALL: D3D12_MEASUREMENTS_ACTION = D3D12_MEASUREMENTS_ACTION(0i32);
pub const D3D12_MEASUREMENTS_ACTION_COMMIT_RESULTS: D3D12_MEASUREMENTS_ACTION = D3D12_MEASUREMENTS_ACTION(1i32);
pub const D3D12_MEASUREMENTS_ACTION_COMMIT_RESULTS_HIGH_PRIORITY: D3D12_MEASUREMENTS_ACTION = D3D12_MEASUREMENTS_ACTION(2i32);
pub const D3D12_MEASUREMENTS_ACTION_DISCARD_PREVIOUS: D3D12_MEASUREMENTS_ACTION = D3D12_MEASUREMENTS_ACTION(3i32);
impl ::std::convert::From<i32> for D3D12_MEASUREMENTS_ACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MEASUREMENTS_ACTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_MEMCPY_DEST {
    pub pData: *mut ::std::ffi::c_void,
    pub RowPitch: usize,
    pub SlicePitch: usize,
}
impl D3D12_MEMCPY_DEST {}
impl ::std::default::Default for D3D12_MEMCPY_DEST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_MEMCPY_DEST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_MEMCPY_DEST").field("pData", &self.pData).field("RowPitch", &self.RowPitch).field("SlicePitch", &self.SlicePitch).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_MEMCPY_DEST {
    fn eq(&self, other: &Self) -> bool {
        self.pData == other.pData && self.RowPitch == other.RowPitch && self.SlicePitch == other.SlicePitch
    }
}
impl ::std::cmp::Eq for D3D12_MEMCPY_DEST {}
unsafe impl ::windows::runtime::Abi for D3D12_MEMCPY_DEST {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MEMORY_POOL(pub i32);
pub const D3D12_MEMORY_POOL_UNKNOWN: D3D12_MEMORY_POOL = D3D12_MEMORY_POOL(0i32);
pub const D3D12_MEMORY_POOL_L0: D3D12_MEMORY_POOL = D3D12_MEMORY_POOL(1i32);
pub const D3D12_MEMORY_POOL_L1: D3D12_MEMORY_POOL = D3D12_MEMORY_POOL(2i32);
impl ::std::convert::From<i32> for D3D12_MEMORY_POOL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MEMORY_POOL {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MESH_SHADER_TIER(pub i32);
pub const D3D12_MESH_SHADER_TIER_NOT_SUPPORTED: D3D12_MESH_SHADER_TIER = D3D12_MESH_SHADER_TIER(0i32);
pub const D3D12_MESH_SHADER_TIER_1: D3D12_MESH_SHADER_TIER = D3D12_MESH_SHADER_TIER(10i32);
impl ::std::convert::From<i32> for D3D12_MESH_SHADER_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MESH_SHADER_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_MESSAGE {
    pub Category: D3D12_MESSAGE_CATEGORY,
    pub Severity: D3D12_MESSAGE_SEVERITY,
    pub ID: D3D12_MESSAGE_ID,
    pub pDescription: *mut u8,
    pub DescriptionByteLength: usize,
}
impl D3D12_MESSAGE {}
impl ::std::default::Default for D3D12_MESSAGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_MESSAGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_MESSAGE").field("Category", &self.Category).field("Severity", &self.Severity).field("ID", &self.ID).field("pDescription", &self.pDescription).field("DescriptionByteLength", &self.DescriptionByteLength).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_MESSAGE {
    fn eq(&self, other: &Self) -> bool {
        self.Category == other.Category && self.Severity == other.Severity && self.ID == other.ID && self.pDescription == other.pDescription && self.DescriptionByteLength == other.DescriptionByteLength
    }
}
impl ::std::cmp::Eq for D3D12_MESSAGE {}
unsafe impl ::windows::runtime::Abi for D3D12_MESSAGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MESSAGE_CALLBACK_FLAGS(pub i32);
pub const D3D12_MESSAGE_CALLBACK_FLAG_NONE: D3D12_MESSAGE_CALLBACK_FLAGS = D3D12_MESSAGE_CALLBACK_FLAGS(0i32);
pub const D3D12_MESSAGE_CALLBACK_IGNORE_FILTERS: D3D12_MESSAGE_CALLBACK_FLAGS = D3D12_MESSAGE_CALLBACK_FLAGS(1i32);
impl ::std::convert::From<i32> for D3D12_MESSAGE_CALLBACK_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MESSAGE_CALLBACK_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MESSAGE_CATEGORY(pub i32);
pub const D3D12_MESSAGE_CATEGORY_APPLICATION_DEFINED: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(0i32);
pub const D3D12_MESSAGE_CATEGORY_MISCELLANEOUS: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(1i32);
pub const D3D12_MESSAGE_CATEGORY_INITIALIZATION: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(2i32);
pub const D3D12_MESSAGE_CATEGORY_CLEANUP: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(3i32);
pub const D3D12_MESSAGE_CATEGORY_COMPILATION: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(4i32);
pub const D3D12_MESSAGE_CATEGORY_STATE_CREATION: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(5i32);
pub const D3D12_MESSAGE_CATEGORY_STATE_SETTING: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(6i32);
pub const D3D12_MESSAGE_CATEGORY_STATE_GETTING: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(7i32);
pub const D3D12_MESSAGE_CATEGORY_RESOURCE_MANIPULATION: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(8i32);
pub const D3D12_MESSAGE_CATEGORY_EXECUTION: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(9i32);
pub const D3D12_MESSAGE_CATEGORY_SHADER: D3D12_MESSAGE_CATEGORY = D3D12_MESSAGE_CATEGORY(10i32);
impl ::std::convert::From<i32> for D3D12_MESSAGE_CATEGORY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MESSAGE_CATEGORY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MESSAGE_ID(pub i32);
pub const D3D12_MESSAGE_ID_UNKNOWN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(0i32);
pub const D3D12_MESSAGE_ID_STRING_FROM_APPLICATION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_THIS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(2i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER1: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(3i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER2: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(4i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER3: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(5i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER4: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(6i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER5: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(7i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER6: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(8i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER7: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(9i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER8: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(10i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER9: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(11i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER10: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(12i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER11: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(13i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER12: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(14i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER13: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(15i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER14: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(16i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_PARAMETER15: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(17i32);
pub const D3D12_MESSAGE_ID_CORRUPTED_MULTITHREADING: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(18i32);
pub const D3D12_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(19i32);
pub const D3D12_MESSAGE_ID_GETPRIVATEDATA_MOREDATA: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(20i32);
pub const D3D12_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(21i32);
pub const D3D12_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(24i32);
pub const D3D12_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(25i32);
pub const D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(26i32);
pub const D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(27i32);
pub const D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(28i32);
pub const D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANESLICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(29i32);
pub const D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANESLICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(30i32);
pub const D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(31i32);
pub const D3D12_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(32i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(35i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(36i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(37i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(38i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANESLICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(39i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANESLICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(40i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(41i32);
pub const D3D12_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(42i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(45i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(46i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(47i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(48i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(49i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(52i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(53i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(54i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(55i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(56i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(57i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(58i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(59i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(60i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(61i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(62i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(63i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(64i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(65i32);
pub const D3D12_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(66i32);
pub const D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(67i32);
pub const D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(68i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(69i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(70i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(71i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(72i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(73i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(74i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(75i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(76i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(79i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(80i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(81i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(82i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(83i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(84i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(85i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(86i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(87i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(88i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(89i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(90i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(91i32);
pub const D3D12_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(92i32);
pub const D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(93i32);
pub const D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(94i32);
pub const D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(95i32);
pub const D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(96i32);
pub const D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(97i32);
pub const D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(98i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(100i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(101i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(102i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(103i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(104i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(105i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(106i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(107i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(108i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(109i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(111i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(112i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(113i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(114i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(115i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(116i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(117i32);
pub const D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(135i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(200i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(201i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(202i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(209i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_BUFFER_TOO_SMALL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(210i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(211i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_FORMAT_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(212i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_BUFFER_TOO_SMALL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(213i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INVALID_PRIMITIVETOPOLOGY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(219i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_VERTEX_STRIDE_UNALIGNED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(221i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_INDEX_OFFSET_UNALIGNED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(222i32);
pub const D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(232i32);
pub const D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(233i32);
pub const D3D12_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(234i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(239i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(240i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(245i32);
pub const D3D12_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(253i32);
pub const D3D12_MESSAGE_ID_LIVE_OBJECT_SUMMARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(255i32);
pub const D3D12_MESSAGE_ID_LIVE_DEVICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(274i32);
pub const D3D12_MESSAGE_ID_LIVE_SWAPCHAIN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(275i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(276i32);
pub const D3D12_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(277i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(278i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(280i32);
pub const D3D12_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(283i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(284i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(285i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(286i32);
pub const D3D12_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(287i32);
pub const D3D12_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(289i32);
pub const D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(290i32);
pub const D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(291i32);
pub const D3D12_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(292i32);
pub const D3D12_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(294i32);
pub const D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(295i32);
pub const D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(296i32);
pub const D3D12_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(297i32);
pub const D3D12_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(310i32);
pub const D3D12_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(318i32);
pub const D3D12_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(321i32);
pub const D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(322i32);
pub const D3D12_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(323i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(331i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(332i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(333i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(334i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(335i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(336i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(337i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(340i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(341i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(342i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANESLICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(343i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANESLICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(344i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(345i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(346i32);
pub const D3D12_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(354i32);
pub const D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(401i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(403i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(410i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(412i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(414i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(416i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(418i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(420i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(422i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(425i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(426i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(427i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(428i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(429i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(430i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(431i32);
pub const D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(447i32);
pub const D3D12_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(448i32);
pub const D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(493i32);
pub const D3D12_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(494i32);
pub const D3D12_MESSAGE_ID_CREATEDEVICE_INVALIDARGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(506i32);
pub const D3D12_MESSAGE_ID_CREATEDEVICE_WARNING: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(507i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(519i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_NULL_POINTER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(520i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(521i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_RESERVED_BITS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(522i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISSING_BIND_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(523i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_MISC_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(524i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_MATCHING_STATES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(525i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINATION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(526i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_BEFORE_AFTER_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(527i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(528i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_SAMPLE_COUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(529i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(530i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMBINED_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(531i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAGS_FOR_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(532i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_SPLIT_BARRIER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(533i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_END: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(534i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_UNMATCHED_BEGIN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(535i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_FLAG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(536i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_COMMAND_LIST_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(537i32);
pub const D3D12_MESSAGE_ID_INVALID_SUBRESOURCE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(538i32);
pub const D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CONTENTION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(540i32);
pub const D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(541i32);
pub const D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_RESET_BUNDLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(542i32);
pub const D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_CANNOT_RESET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(543i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_OPEN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(544i32);
pub const D3D12_MESSAGE_ID_INVALID_BUNDLE_API: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(546i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_CLOSED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(547i32);
pub const D3D12_MESSAGE_ID_WRONG_COMMAND_ALLOCATOR_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(549i32);
pub const D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_SYNC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(552i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_SYNC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(553i32);
pub const D3D12_MESSAGE_ID_SET_DESCRIPTOR_HEAP_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(554i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(557i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMANDALLOCATOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(558i32);
pub const D3D12_MESSAGE_ID_CREATE_PIPELINESTATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(559i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMANDLIST12: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(560i32);
pub const D3D12_MESSAGE_ID_CREATE_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(562i32);
pub const D3D12_MESSAGE_ID_CREATE_DESCRIPTORHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(563i32);
pub const D3D12_MESSAGE_ID_CREATE_ROOTSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(564i32);
pub const D3D12_MESSAGE_ID_CREATE_LIBRARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(565i32);
pub const D3D12_MESSAGE_ID_CREATE_HEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(566i32);
pub const D3D12_MESSAGE_ID_CREATE_MONITOREDFENCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(567i32);
pub const D3D12_MESSAGE_ID_CREATE_QUERYHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(568i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMANDSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(569i32);
pub const D3D12_MESSAGE_ID_LIVE_COMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(570i32);
pub const D3D12_MESSAGE_ID_LIVE_COMMANDALLOCATOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(571i32);
pub const D3D12_MESSAGE_ID_LIVE_PIPELINESTATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(572i32);
pub const D3D12_MESSAGE_ID_LIVE_COMMANDLIST12: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(573i32);
pub const D3D12_MESSAGE_ID_LIVE_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(575i32);
pub const D3D12_MESSAGE_ID_LIVE_DESCRIPTORHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(576i32);
pub const D3D12_MESSAGE_ID_LIVE_ROOTSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(577i32);
pub const D3D12_MESSAGE_ID_LIVE_LIBRARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(578i32);
pub const D3D12_MESSAGE_ID_LIVE_HEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(579i32);
pub const D3D12_MESSAGE_ID_LIVE_MONITOREDFENCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(580i32);
pub const D3D12_MESSAGE_ID_LIVE_QUERYHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(581i32);
pub const D3D12_MESSAGE_ID_LIVE_COMMANDSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(582i32);
pub const D3D12_MESSAGE_ID_DESTROY_COMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(583i32);
pub const D3D12_MESSAGE_ID_DESTROY_COMMANDALLOCATOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(584i32);
pub const D3D12_MESSAGE_ID_DESTROY_PIPELINESTATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(585i32);
pub const D3D12_MESSAGE_ID_DESTROY_COMMANDLIST12: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(586i32);
pub const D3D12_MESSAGE_ID_DESTROY_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(588i32);
pub const D3D12_MESSAGE_ID_DESTROY_DESCRIPTORHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(589i32);
pub const D3D12_MESSAGE_ID_DESTROY_ROOTSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(590i32);
pub const D3D12_MESSAGE_ID_DESTROY_LIBRARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(591i32);
pub const D3D12_MESSAGE_ID_DESTROY_HEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(592i32);
pub const D3D12_MESSAGE_ID_DESTROY_MONITOREDFENCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(593i32);
pub const D3D12_MESSAGE_ID_DESTROY_QUERYHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(594i32);
pub const D3D12_MESSAGE_ID_DESTROY_COMMANDSIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(595i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(597i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMISCFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(599i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDARG_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(602i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_OUTOFMEMORY_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(603i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(604i32);
pub const D3D12_MESSAGE_ID_POSSIBLY_INVALID_SUBRESOURCE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(607i32);
pub const D3D12_MESSAGE_ID_INVALID_USE_OF_NON_RESIDENT_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(608i32);
pub const D3D12_MESSAGE_ID_POSSIBLE_INVALID_USE_OF_NON_RESIDENT_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(609i32);
pub const D3D12_MESSAGE_ID_BUNDLE_PIPELINE_STATE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(610i32);
pub const D3D12_MESSAGE_ID_PRIMITIVE_TOPOLOGY_MISMATCH_PIPELINE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(611i32);
pub const D3D12_MESSAGE_ID_RENDER_TARGET_FORMAT_MISMATCH_PIPELINE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(613i32);
pub const D3D12_MESSAGE_ID_RENDER_TARGET_SAMPLE_DESC_MISMATCH_PIPELINE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(614i32);
pub const D3D12_MESSAGE_ID_DEPTH_STENCIL_FORMAT_MISMATCH_PIPELINE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(615i32);
pub const D3D12_MESSAGE_ID_DEPTH_STENCIL_SAMPLE_DESC_MISMATCH_PIPELINE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(616i32);
pub const D3D12_MESSAGE_ID_CREATESHADER_INVALIDBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(622i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_NULLDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(623i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_INVALIDSIZE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(624i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDHEAPTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(625i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(626i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMEMORYPOOL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(627i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_INVALIDPROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(628i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_INVALIDALIGNMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(629i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_UNRECOGNIZEDMISCFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(630i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_INVALIDMISCFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(631i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_INVALIDARG_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(632i32);
pub const D3D12_MESSAGE_ID_CREATEHEAP_OUTOFMEMORY_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(633i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAPPROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(634i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(635i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDCPUPAGEPROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(636i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDMEMORYPOOL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(637i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPPROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(638i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_UNRECOGNIZEDHEAPMISCFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(639i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDHEAPMISCFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(640i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_INVALIDARG_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(641i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_OUTOFMEMORY_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(642i32);
pub const D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_UNRECOGNIZEDHEAPTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(643i32);
pub const D3D12_MESSAGE_ID_GETCUSTOMHEAPPROPERTIES_INVALIDHEAPTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(644i32);
pub const D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_INVALID_DESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(645i32);
pub const D3D12_MESSAGE_ID_INVALID_DESCRIPTOR_HANDLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(646i32);
pub const D3D12_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(647i32);
pub const D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(649i32);
pub const D3D12_MESSAGE_ID_CREATE_CONSTANT_BUFFER_VIEW_INVALID_DESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(650i32);
pub const D3D12_MESSAGE_ID_CREATE_UNORDEREDACCESS_VIEW_INVALID_COUNTER_USAGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(652i32);
pub const D3D12_MESSAGE_ID_COPY_DESCRIPTORS_INVALID_RANGES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(653i32);
pub const D3D12_MESSAGE_ID_COPY_DESCRIPTORS_WRITE_ONLY_DESCRIPTOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(654i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RTV_FORMAT_NOT_UNKNOWN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(655i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_RENDER_TARGET_COUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(656i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VERTEX_SHADER_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(657i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(658i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_HS_DS_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(659i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERINDEX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(660i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_COMPONENTTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(661i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_REGISTERMASK: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(662i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SYSTEMVALUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(663i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(664i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_MINPRECISION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(665i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(666i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_XOR_DS_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(667i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(668i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_CONTROL_POINT_COUNT_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(669i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_DS_TESSELLATOR_DOMAIN_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(670i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(671i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_USE_OF_FORCED_SAMPLE_COUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(672i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_PRIMITIVETOPOLOGY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(673i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SYSTEMVALUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(674i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(675i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(676i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_TYPE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(677i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(678i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RENDERTARGETVIEW_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(679i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DEPTHSTENCILVIEW_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(680i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_INPUT_PRIMITIVE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(681i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_POSITION_NOT_PRESENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(682i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(683i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_INDEX_BUFFER_PROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(684i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INVALID_SAMPLE_DESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(685i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_HS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(686i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_DS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(687i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(688i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_GS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(689i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(690i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MISSING_ROOT_SIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(691i32);
pub const D3D12_MESSAGE_ID_EXECUTE_BUNDLE_OPEN_BUNDLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(692i32);
pub const D3D12_MESSAGE_ID_EXECUTE_BUNDLE_DESCRIPTOR_HEAP_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(693i32);
pub const D3D12_MESSAGE_ID_EXECUTE_BUNDLE_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(694i32);
pub const D3D12_MESSAGE_ID_DRAW_EMPTY_SCISSOR_RECTANGLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(695i32);
pub const D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_BLOB_NOT_FOUND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(696i32);
pub const D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_DESERIALIZE_FAILED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(697i32);
pub const D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_INVALID_CONFIGURATION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(698i32);
pub const D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_SUPPORTED_ON_DEVICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(699i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLRESOURCEPROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(700i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCEANDHEAP_NULLHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(701i32);
pub const D3D12_MESSAGE_ID_GETRESOURCEALLOCATIONINFO_INVALIDRDESCS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(702i32);
pub const D3D12_MESSAGE_ID_MAKERESIDENT_NULLOBJECTARRAY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(703i32);
pub const D3D12_MESSAGE_ID_EVICT_NULLOBJECTARRAY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(705i32);
pub const D3D12_MESSAGE_ID_SET_DESCRIPTOR_TABLE_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(708i32);
pub const D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(709i32);
pub const D3D12_MESSAGE_ID_SET_ROOT_CONSTANT_BUFFER_VIEW_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(710i32);
pub const D3D12_MESSAGE_ID_SET_ROOT_SHADER_RESOURCE_VIEW_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(711i32);
pub const D3D12_MESSAGE_ID_SET_ROOT_UNORDERED_ACCESS_VIEW_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(712i32);
pub const D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID_DESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(713i32);
pub const D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID_DESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(715i32);
pub const D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID_DESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(717i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDDIMENSIONALITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(718i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDLAYOUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(719i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDDIMENSIONALITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(720i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDALIGNMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(721i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDMIPLEVELS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(722i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDSAMPLEDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(723i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDLAYOUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(724i32);
pub const D3D12_MESSAGE_ID_SET_INDEX_BUFFER_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(725i32);
pub const D3D12_MESSAGE_ID_SET_VERTEX_BUFFERS_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(726i32);
pub const D3D12_MESSAGE_ID_SET_STREAM_OUTPUT_BUFFERS_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(727i32);
pub const D3D12_MESSAGE_ID_SET_RENDER_TARGETS_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(728i32);
pub const D3D12_MESSAGE_ID_CREATEQUERY_HEAP_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(729i32);
pub const D3D12_MESSAGE_ID_BEGIN_END_QUERY_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(731i32);
pub const D3D12_MESSAGE_ID_CLOSE_COMMAND_LIST_OPEN_QUERY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(732i32);
pub const D3D12_MESSAGE_ID_RESOLVE_QUERY_DATA_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(733i32);
pub const D3D12_MESSAGE_ID_SET_PREDICATION_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(734i32);
pub const D3D12_MESSAGE_ID_TIMESTAMPS_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(735i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(737i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(738i32);
pub const D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDSUBRESOURCERANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(739i32);
pub const D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_INVALIDBASEOFFSET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(740i32);
pub const D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDSUBRESOURCERANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(739i32);
pub const D3D12_MESSAGE_ID_GETCOPYABLELAYOUT_INVALIDBASEOFFSET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(740i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_INVALID_HEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(741i32);
pub const D3D12_MESSAGE_ID_CREATE_SAMPLER_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(742i32);
pub const D3D12_MESSAGE_ID_CREATECOMMANDSIGNATURE_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(743i32);
pub const D3D12_MESSAGE_ID_EXECUTE_INDIRECT_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(744i32);
pub const D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_RESOURCE_DIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(745i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(815i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_UNRECOGNIZEDCLEARVALUEFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(816i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_INVALIDCLEARVALUEFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(817i32);
pub const D3D12_MESSAGE_ID_CREATERESOURCE_CLEARVALUEDENORMFLUSH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(818i32);
pub const D3D12_MESSAGE_ID_CLEARRENDERTARGETVIEW_MISMATCHINGCLEARVALUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(820i32);
pub const D3D12_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_MISMATCHINGCLEARVALUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(821i32);
pub const D3D12_MESSAGE_ID_MAP_INVALIDHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(822i32);
pub const D3D12_MESSAGE_ID_UNMAP_INVALIDHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(823i32);
pub const D3D12_MESSAGE_ID_MAP_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(824i32);
pub const D3D12_MESSAGE_ID_UNMAP_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(825i32);
pub const D3D12_MESSAGE_ID_MAP_INVALIDSUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(826i32);
pub const D3D12_MESSAGE_ID_UNMAP_INVALIDSUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(827i32);
pub const D3D12_MESSAGE_ID_MAP_INVALIDRANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(828i32);
pub const D3D12_MESSAGE_ID_UNMAP_INVALIDRANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(829i32);
pub const D3D12_MESSAGE_ID_MAP_INVALIDDATAPOINTER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(832i32);
pub const D3D12_MESSAGE_ID_MAP_INVALIDARG_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(833i32);
pub const D3D12_MESSAGE_ID_MAP_OUTOFMEMORY_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(834i32);
pub const D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_BUNDLENOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(835i32);
pub const D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_COMMANDLISTMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(836i32);
pub const D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_OPENCOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(837i32);
pub const D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_FAILEDCOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(838i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLDST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(839i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDDSTRESOURCEDIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(840i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_DSTRANGEOUTOFBOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(841i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_NULLSRC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(842i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDSRCRESOURCEDIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(843i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_SRCRANGEOUTOFBOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(844i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALIDCOPYFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(845i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLDST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(846i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(847i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCEDIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(848i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(849i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTSUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(850i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTOFFSET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(851i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDDSTFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(852i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(853i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDIMENSIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(854i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTROWPITCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(855i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTPLACEMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(856i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTDSPLACEDFOOTPRINTFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(857i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_DSTREGIONOUTOFBOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(858i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_NULLSRC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(859i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(860i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCEDIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(861i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(862i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCSUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(863i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCOFFSET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(864i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_UNRECOGNIZEDSRCFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(865i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(866i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDIMENSIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(867i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCROWPITCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(868i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCPLACEMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(869i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCDSPLACEDFOOTPRINTFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(870i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_SRCREGIONOUTOFBOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(871i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDDSTCOORDINATES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(872i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDSRCBOX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(873i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_FORMATMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(874i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_EMPTYBOX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(875i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_INVALIDCOPYFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(876i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SUBRESOURCE_INDEX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(877i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(878i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(879i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALID_SAMPLE_COUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(880i32);
pub const D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_INVALID_SHADER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(881i32);
pub const D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_CS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(882i32);
pub const D3D12_MESSAGE_ID_CREATECOMPUTEPIPELINESTATE_MISSING_ROOT_SIGNATURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(883i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALIDCACHEDBLOB: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(884i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBADAPTERMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(885i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDRIVERVERSIONMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(886i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBDESCMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(887i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CACHEDBLOBIGNORED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(888i32);
pub const D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(889i32);
pub const D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(890i32);
pub const D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDBOX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(891i32);
pub const D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_INVALIDSUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(892i32);
pub const D3D12_MESSAGE_ID_WRITETOSUBRESOURCE_EMPTYBOX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(893i32);
pub const D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(894i32);
pub const D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(895i32);
pub const D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDBOX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(896i32);
pub const D3D12_MESSAGE_ID_READFROMSUBRESOURCE_INVALIDSUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(897i32);
pub const D3D12_MESSAGE_ID_READFROMSUBRESOURCE_EMPTYBOX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(898i32);
pub const D3D12_MESSAGE_ID_TOO_MANY_NODES_SPECIFIED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(899i32);
pub const D3D12_MESSAGE_ID_INVALID_NODE_INDEX: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(900i32);
pub const D3D12_MESSAGE_ID_GETHEAPPROPERTIES_INVALIDRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(901i32);
pub const D3D12_MESSAGE_ID_NODE_MASK_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(902i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(903i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_MULTIPLE_SWAPCHAIN_BUFFER_REFERENCES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(904i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_TOO_MANY_SWAPCHAIN_REFERENCES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(905i32);
pub const D3D12_MESSAGE_ID_COMMAND_QUEUE_TOO_MANY_SWAPCHAIN_REFERENCES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(906i32);
pub const D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_WRONGSWAPCHAINBUFFERREFERENCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(907i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_SETRENDERTARGETS_INVALIDNUMRENDERTARGETS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(908i32);
pub const D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(909i32);
pub const D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(910i32);
pub const D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(911i32);
pub const D3D12_MESSAGE_ID_CREATESHAREDRESOURCE_INVALIDFORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(912i32);
pub const D3D12_MESSAGE_ID_CREATESHAREDHEAP_INVALIDFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(913i32);
pub const D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_UNRECOGNIZEDPROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(914i32);
pub const D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDSIZE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(915i32);
pub const D3D12_MESSAGE_ID_REFLECTSHAREDPROPERTIES_INVALIDOBJECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(916i32);
pub const D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDOBJECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(917i32);
pub const D3D12_MESSAGE_ID_KEYEDMUTEX_INVALIDKEY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(918i32);
pub const D3D12_MESSAGE_ID_KEYEDMUTEX_WRONGSTATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(919i32);
pub const D3D12_MESSAGE_ID_CREATE_QUEUE_INVALID_PRIORITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(920i32);
pub const D3D12_MESSAGE_ID_OBJECT_DELETED_WHILE_STILL_IN_USE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(921i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(922i32);
pub const D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_HAS_NO_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(923i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DRAW_RENDER_TARGET_DELETED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(924i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_ALL_RENDER_TARGETS_HAVE_UNKNOWN_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(925i32);
pub const D3D12_MESSAGE_ID_HEAP_ADDRESS_RANGE_INTERSECTS_MULTIPLE_BUFFERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(926i32);
pub const D3D12_MESSAGE_ID_EXECUTECOMMANDLISTS_GPU_WRITTEN_READBACK_RESOURCE_MAPPED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(927i32);
pub const D3D12_MESSAGE_ID_UNMAP_RANGE_NOT_EMPTY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(929i32);
pub const D3D12_MESSAGE_ID_MAP_INVALID_NULLRANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(930i32);
pub const D3D12_MESSAGE_ID_UNMAP_INVALID_NULLRANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(931i32);
pub const D3D12_MESSAGE_ID_NO_GRAPHICS_API_SUPPORT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(932i32);
pub const D3D12_MESSAGE_ID_NO_COMPUTE_API_SUPPORT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(933i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_RESOURCE_FLAGS_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(934i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_ARGUMENT_UNINITIALIZED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(935i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_HEAP_INDEX_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(936i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TABLE_REGISTER_INDEX_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(937i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_UNINITIALIZED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(938i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_DESCRIPTOR_TYPE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(939i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SRV_RESOURCE_DIMENSION_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(940i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UAV_RESOURCE_DIMENSION_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(941i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INCOMPATIBLE_RESOURCE_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(942i32);
pub const D3D12_MESSAGE_ID_COPYRESOURCE_NULLDST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(943i32);
pub const D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDDSTRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(944i32);
pub const D3D12_MESSAGE_ID_COPYRESOURCE_NULLSRC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(945i32);
pub const D3D12_MESSAGE_ID_COPYRESOURCE_INVALIDSRCRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(946i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLDST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(947i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDDSTRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(948i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_NULLSRC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(949i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_INVALIDSRCRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(950i32);
pub const D3D12_MESSAGE_ID_PIPELINE_STATE_TYPE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(951i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(952i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DISPATCH_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(953i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_ZERO_BARRIERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(954i32);
pub const D3D12_MESSAGE_ID_BEGIN_END_EVENT_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(955i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_POSSIBLE_BEFORE_AFTER_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(956i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_BEGIN_END: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(957i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_INVALID_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(958i32);
pub const D3D12_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(959i32);
pub const D3D12_MESSAGE_ID_OBJECT_EVICTED_WHILE_STILL_IN_USE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(960i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_ROOT_DESCRIPTOR_ACCESS_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(961i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_INVALIDLIBRARYBLOB: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(962i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_DRIVERVERSIONMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(963i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_ADAPTERVERSIONMISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(964i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINELIBRARY_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(965i32);
pub const D3D12_MESSAGE_ID_CREATE_PIPELINELIBRARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(966i32);
pub const D3D12_MESSAGE_ID_LIVE_PIPELINELIBRARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(967i32);
pub const D3D12_MESSAGE_ID_DESTROY_PIPELINELIBRARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(968i32);
pub const D3D12_MESSAGE_ID_STOREPIPELINE_NONAME: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(969i32);
pub const D3D12_MESSAGE_ID_STOREPIPELINE_DUPLICATENAME: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(970i32);
pub const D3D12_MESSAGE_ID_LOADPIPELINE_NAMENOTFOUND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(971i32);
pub const D3D12_MESSAGE_ID_LOADPIPELINE_INVALIDDESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(972i32);
pub const D3D12_MESSAGE_ID_PIPELINELIBRARY_SERIALIZE_NOTENOUGHMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(973i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_PS_OUTPUT_RT_OUTPUT_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(974i32);
pub const D3D12_MESSAGE_ID_SETEVENTONMULTIPLEFENCECOMPLETION_INVALIDFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(975i32);
pub const D3D12_MESSAGE_ID_CREATE_QUEUE_VIDEO_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(976i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_ALLOCATOR_VIDEO_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(977i32);
pub const D3D12_MESSAGE_ID_CREATEQUERY_HEAP_VIDEO_DECODE_STATISTICS_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(978i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(979i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEODECODER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(980i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEODECODESTREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(981i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(982i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEODECODER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(983i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEODECODESTREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(984i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(985i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEODECODER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(986i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEODECODESTREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(987i32);
pub const D3D12_MESSAGE_ID_DECODE_FRAME_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(988i32);
pub const D3D12_MESSAGE_ID_DEPRECATED_API: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(989i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_MISMATCHING_COMMAND_LIST_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(990i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_DESCRIPTOR_TABLE_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(991i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_CONSTANT_BUFFER_VIEW_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(992i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_SHADER_RESOURCE_VIEW_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(993i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_ROOT_UNORDERED_ACCESS_VIEW_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(994i32);
pub const D3D12_MESSAGE_ID_DISCARD_INVALID_SUBRESOURCE_RANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(995i32);
pub const D3D12_MESSAGE_ID_DISCARD_ONE_SUBRESOURCE_FOR_MIPS_WITH_RECTS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(996i32);
pub const D3D12_MESSAGE_ID_DISCARD_NO_RECTS_FOR_NON_TEXTURE2D: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(997i32);
pub const D3D12_MESSAGE_ID_COPY_ON_SAME_SUBRESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(998i32);
pub const D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PAGEABLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(999i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1000i32);
pub const D3D12_MESSAGE_ID_STATIC_DESCRIPTOR_INVALID_DESCRIPTOR_CHANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1001i32);
pub const D3D12_MESSAGE_ID_DATA_STATIC_DESCRIPTOR_INVALID_DATA_CHANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1002i32);
pub const D3D12_MESSAGE_ID_DATA_STATIC_WHILE_SET_AT_EXECUTE_DESCRIPTOR_INVALID_DATA_CHANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1003i32);
pub const D3D12_MESSAGE_ID_EXECUTE_BUNDLE_STATIC_DESCRIPTOR_DATA_STATIC_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1004i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_ACCESS_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1005i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_SAMPLER_MODE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1006i32);
pub const D3D12_MESSAGE_ID_CREATE_FENCE_INVALID_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1007i32);
pub const D3D12_MESSAGE_ID_RESOURCE_BARRIER_DUPLICATE_SUBRESOURCE_TRANSITIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1008i32);
pub const D3D12_MESSAGE_ID_SETRESIDENCYPRIORITY_INVALID_PRIORITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1009i32);
pub const D3D12_MESSAGE_ID_CREATE_DESCRIPTOR_HEAP_LARGE_NUM_DESCRIPTORS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1013i32);
pub const D3D12_MESSAGE_ID_BEGIN_EVENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1014i32);
pub const D3D12_MESSAGE_ID_END_EVENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1015i32);
pub const D3D12_MESSAGE_ID_CREATEDEVICE_DEBUG_LAYER_STARTUP_OPTIONS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1016i32);
pub const D3D12_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_DEPTHBOUNDSTEST_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1017i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_DUPLICATE_SUBOBJECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1018i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_UNKNOWN_SUBOBJECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1019i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_ZERO_SIZE_STREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1020i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_INVALID_STREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1021i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_CANNOT_DEDUCE_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1022i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_RESOURCE_DIMENSION_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1023i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_PRIVILEGE_FOR_GLOBAL_REALTIME: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1024i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_QUEUE_INSUFFICIENT_HARDWARE_SUPPORT_FOR_GLOBAL_REALTIME: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1025i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_ARCHITECTURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1026i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1027i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE_DIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1028i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DST_RANGE_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1029i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_SRC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1030i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE_DIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1031i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_SRC_RANGE_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1032i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_OFFSET_ALIGNMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1033i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_RESOURCES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1034i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_NULL_DEPENDENT_SUBRESOURCE_RANGES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1035i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1036i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DEPENDENT_SUBRESOURCE_RANGE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1037i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_SUBRESOURCE_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1038i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_DEPENDENT_RANGE_OUT_OF_BOUNDS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1039i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_ZERO_DEPENDENCIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1040i32);
pub const D3D12_MESSAGE_ID_DEVICE_CREATE_SHARED_HANDLE_INVALIDARG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1041i32);
pub const D3D12_MESSAGE_ID_DESCRIPTOR_HANDLE_WITH_INVALID_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1042i32);
pub const D3D12_MESSAGE_ID_SETDEPTHBOUNDS_INVALIDARGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1043i32);
pub const D3D12_MESSAGE_ID_GPU_BASED_VALIDATION_RESOURCE_STATE_IMPRECISE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1044i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_PIPELINE_STATE_NOT_SET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1045i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_SHADER_MODEL_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1046i32);
pub const D3D12_MESSAGE_ID_OBJECT_ACCESSED_WHILE_STILL_IN_USE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1047i32);
pub const D3D12_MESSAGE_ID_PROGRAMMABLE_MSAA_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1048i32);
pub const D3D12_MESSAGE_ID_SETSAMPLEPOSITIONS_INVALIDARGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1049i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCEREGION_INVALID_RECT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1050i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEODECODECOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1051i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1052i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSCOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1053i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEODECODECOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1054i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1055i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSCOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1056i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEODECODECOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1057i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1058i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSCOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1059i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1060i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOPROCESSSTREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1061i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1062i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOPROCESSSTREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1063i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1064i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOPROCESSSTREAM: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1065i32);
pub const D3D12_MESSAGE_ID_PROCESS_FRAME_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1066i32);
pub const D3D12_MESSAGE_ID_COPY_INVALIDLAYOUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1067i32);
pub const D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1068i32);
pub const D3D12_MESSAGE_ID_CREATE_CRYPTO_SESSION_POLICY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1069i32);
pub const D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1070i32);
pub const D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1071i32);
pub const D3D12_MESSAGE_ID_LIVE_CRYPTO_SESSION_POLICY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1072i32);
pub const D3D12_MESSAGE_ID_LIVE_PROTECTED_RESOURCE_SESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1073i32);
pub const D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1074i32);
pub const D3D12_MESSAGE_ID_DESTROY_CRYPTO_SESSION_POLICY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1075i32);
pub const D3D12_MESSAGE_ID_DESTROY_PROTECTED_RESOURCE_SESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1076i32);
pub const D3D12_MESSAGE_ID_PROTECTED_RESOURCE_SESSION_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1077i32);
pub const D3D12_MESSAGE_ID_FENCE_INVALIDOPERATION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1078i32);
pub const D3D12_MESSAGE_ID_CREATEQUERY_HEAP_COPY_QUEUE_TIMESTAMPS_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1079i32);
pub const D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_DEFERRED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1080i32);
pub const D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMFIRSTUSE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1081i32);
pub const D3D12_MESSAGE_ID_SAMPLEPOSITIONS_MISMATCH_RECORDTIME_ASSUMEDFROMCLEAR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1082i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEODECODERHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1083i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEODECODERHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1084i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEODECODERHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1085i32);
pub const D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDARG_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1086i32);
pub const D3D12_MESSAGE_ID_OPENEXISTINGHEAP_OUTOFMEMORY_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1087i32);
pub const D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDADDRESS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1088i32);
pub const D3D12_MESSAGE_ID_OPENEXISTINGHEAP_INVALIDHANDLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1089i32);
pub const D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_DEST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1090i32);
pub const D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_MODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1091i32);
pub const D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_INVALID_ALIGNMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1092i32);
pub const D3D12_MESSAGE_ID_WRITEBUFFERIMMEDIATE_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1093i32);
pub const D3D12_MESSAGE_ID_SETVIEWINSTANCEMASK_INVALIDARGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1094i32);
pub const D3D12_MESSAGE_ID_VIEW_INSTANCING_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1095i32);
pub const D3D12_MESSAGE_ID_VIEW_INSTANCING_INVALIDARGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1096i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_DECODE_REFERENCE_ONLY_FLAG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1097i32);
pub const D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_DECODE_REFERENCE_ONLY_FLAG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1098i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_FAILURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1099i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_DECODE_HEAP_CAPS_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1100i32);
pub const D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_INVALID_INPUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1101i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_DECODER_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1102i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_METADATA_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1103i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_VIEW_INSTANCING_VERTEX_SIZE_EXCEEDED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1104i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_RUNTIME_INTERNAL_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1105i32);
pub const D3D12_MESSAGE_ID_NO_VIDEO_API_SUPPORT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1106i32);
pub const D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_INVALID_INPUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1107i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_PROCESSOR_CAPS_FAILURE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1108i32);
pub const D3D12_MESSAGE_ID_VIDEO_PROCESS_SUPPORT_UNSUPPORTED_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1109i32);
pub const D3D12_MESSAGE_ID_VIDEO_DECODE_FRAME_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1110i32);
pub const D3D12_MESSAGE_ID_ENQUEUE_MAKE_RESIDENT_INVALID_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1111i32);
pub const D3D12_MESSAGE_ID_OPENEXISTINGHEAP_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1112i32);
pub const D3D12_MESSAGE_ID_VIDEO_PROCESS_FRAMES_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1113i32);
pub const D3D12_MESSAGE_ID_VIDEO_DECODE_SUPPORT_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1114i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMANDRECORDER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1115i32);
pub const D3D12_MESSAGE_ID_LIVE_COMMANDRECORDER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1116i32);
pub const D3D12_MESSAGE_ID_DESTROY_COMMANDRECORDER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1117i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_VIDEO_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1118i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_SUPPORT_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1119i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_INVALID_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1120i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_RECORDER_MORE_RECORDERS_THAN_LOGICAL_PROCESSORS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1121i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMANDPOOL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1122i32);
pub const D3D12_MESSAGE_ID_LIVE_COMMANDPOOL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1123i32);
pub const D3D12_MESSAGE_ID_DESTROY_COMMANDPOOL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1124i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_POOL_INVALID_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1125i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_VIDEO_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1126i32);
pub const D3D12_MESSAGE_ID_COMMAND_RECORDER_SUPPORT_FLAGS_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1127i32);
pub const D3D12_MESSAGE_ID_COMMAND_RECORDER_CONTENTION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1128i32);
pub const D3D12_MESSAGE_ID_COMMAND_RECORDER_USAGE_WITH_CREATECOMMANDLIST_COMMAND_LIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1129i32);
pub const D3D12_MESSAGE_ID_COMMAND_ALLOCATOR_USAGE_WITH_CREATECOMMANDLIST1_COMMAND_LIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1130i32);
pub const D3D12_MESSAGE_ID_CANNOT_EXECUTE_EMPTY_COMMAND_LIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1131i32);
pub const D3D12_MESSAGE_ID_CANNOT_RESET_COMMAND_POOL_WITH_OPEN_COMMAND_LISTS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1132i32);
pub const D3D12_MESSAGE_ID_CANNOT_USE_COMMAND_RECORDER_WITHOUT_CURRENT_TARGET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1133i32);
pub const D3D12_MESSAGE_ID_CANNOT_CHANGE_COMMAND_RECORDER_TARGET_WHILE_RECORDING: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1134i32);
pub const D3D12_MESSAGE_ID_COMMAND_POOL_SYNC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1135i32);
pub const D3D12_MESSAGE_ID_EVICT_UNDERFLOW: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1136i32);
pub const D3D12_MESSAGE_ID_CREATE_META_COMMAND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1137i32);
pub const D3D12_MESSAGE_ID_LIVE_META_COMMAND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1138i32);
pub const D3D12_MESSAGE_ID_DESTROY_META_COMMAND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1139i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_DST_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1140i32);
pub const D3D12_MESSAGE_ID_COPYBUFFERREGION_INVALID_SRC_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1141i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_DST_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1142i32);
pub const D3D12_MESSAGE_ID_ATOMICCOPYBUFFER_INVALID_SRC_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1143i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_BUFFER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1144i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_NULL_RESOURCE_DESC: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1145i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1146i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_DIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1147i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1148i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_BUFFER_OFFSET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1149i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_DIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1150i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_INVALID_RESOURCE_FLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1151i32);
pub const D3D12_MESSAGE_ID_CREATEPLACEDRESOURCEONBUFFER_OUTOFMEMORY_RETURN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1152i32);
pub const D3D12_MESSAGE_ID_CANNOT_CREATE_GRAPHICS_AND_VIDEO_COMMAND_RECORDER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1153i32);
pub const D3D12_MESSAGE_ID_UPDATETILEMAPPINGS_POSSIBLY_MISMATCHING_PROPERTIES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1154i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1155i32);
pub const D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INCOMPATIBLE_WITH_STRUCTURED_BUFFERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1156i32);
pub const D3D12_MESSAGE_ID_COMPUTE_ONLY_DEVICE_OPERATION_UNSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1157i32);
pub const D3D12_MESSAGE_ID_BUILD_RAYTRACING_ACCELERATION_STRUCTURE_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1158i32);
pub const D3D12_MESSAGE_ID_EMIT_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1159i32);
pub const D3D12_MESSAGE_ID_COPY_RAYTRACING_ACCELERATION_STRUCTURE_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1160i32);
pub const D3D12_MESSAGE_ID_DISPATCH_RAYS_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1161i32);
pub const D3D12_MESSAGE_ID_GET_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1162i32);
pub const D3D12_MESSAGE_ID_CREATE_LIFETIMETRACKER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1163i32);
pub const D3D12_MESSAGE_ID_LIVE_LIFETIMETRACKER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1164i32);
pub const D3D12_MESSAGE_ID_DESTROY_LIFETIMETRACKER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1165i32);
pub const D3D12_MESSAGE_ID_DESTROYOWNEDOBJECT_OBJECTNOTOWNED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1166i32);
pub const D3D12_MESSAGE_ID_CREATE_TRACKEDWORKLOAD: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1167i32);
pub const D3D12_MESSAGE_ID_LIVE_TRACKEDWORKLOAD: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1168i32);
pub const D3D12_MESSAGE_ID_DESTROY_TRACKEDWORKLOAD: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1169i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1170i32);
pub const D3D12_MESSAGE_ID_META_COMMAND_ID_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1171i32);
pub const D3D12_MESSAGE_ID_META_COMMAND_UNSUPPORTED_PARAMS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1172i32);
pub const D3D12_MESSAGE_ID_META_COMMAND_FAILED_ENUMERATION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1173i32);
pub const D3D12_MESSAGE_ID_META_COMMAND_PARAMETER_SIZE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1174i32);
pub const D3D12_MESSAGE_ID_UNINITIALIZED_META_COMMAND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1175i32);
pub const D3D12_MESSAGE_ID_META_COMMAND_INVALID_GPU_VIRTUAL_ADDRESS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1176i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1177i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1178i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDLIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1179i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOENCODECOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1180i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOENCODECOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1181i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOENCODECOMMANDQUEUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1182i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONESTIMATOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1183i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONESTIMATOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1184i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONESTIMATOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1185i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOMOTIONVECTORHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1186i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOMOTIONVECTORHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1187i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOMOTIONVECTORHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1188i32);
pub const D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOADS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1189i32);
pub const D3D12_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOAD_PAIRS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1190i32);
pub const D3D12_MESSAGE_ID_OUT_OF_ORDER_TRACKED_WORKLOAD_PAIR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1191i32);
pub const D3D12_MESSAGE_ID_CANNOT_ADD_TRACKED_WORKLOAD: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1192i32);
pub const D3D12_MESSAGE_ID_INCOMPLETE_TRACKED_WORKLOAD_PAIR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1193i32);
pub const D3D12_MESSAGE_ID_CREATE_STATE_OBJECT_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1194i32);
pub const D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1195i32);
pub const D3D12_MESSAGE_ID_GET_SHADER_STACK_SIZE_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1196i32);
pub const D3D12_MESSAGE_ID_GET_PIPELINE_STACK_SIZE_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1197i32);
pub const D3D12_MESSAGE_ID_SET_PIPELINE_STACK_SIZE_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1198i32);
pub const D3D12_MESSAGE_ID_GET_SHADER_IDENTIFIER_SIZE_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1199i32);
pub const D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_INVALID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1200i32);
pub const D3D12_MESSAGE_ID_CHECK_DRIVER_MATCHING_IDENTIFIER_DRIVER_REPORTED_ISSUE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1201i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_INVALID_RESOURCE_BARRIER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1202i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_DISALLOWED_API_CALLED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1203i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_NEST_RENDER_PASSES: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1204i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_END_WITHOUT_BEGIN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1205i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_CANNOT_CLOSE_COMMAND_LIST: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1206i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_GPU_WORK_WHILE_SUSPENDED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1207i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_SUSPEND_RESUME: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1208i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_NO_PRIOR_SUSPEND_WITHIN_EXECUTECOMMANDLISTS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1209i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_NO_SUBSEQUENT_RESUME_WITHIN_EXECUTECOMMANDLISTS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1210i32);
pub const D3D12_MESSAGE_ID_TRACKED_WORKLOAD_COMMAND_QUEUE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1211i32);
pub const D3D12_MESSAGE_ID_TRACKED_WORKLOAD_NOT_SUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1212i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_MISMATCHING_NO_ACCESS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1213i32);
pub const D3D12_MESSAGE_ID_RENDER_PASS_UNSUPPORTED_RESOLVE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1214i32);
pub const D3D12_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_INVALID_RESOURCE_PTR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1215i32);
pub const D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_SIGNAL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1216i32);
pub const D3D12_MESSAGE_ID_WINDOWS7_FENCE_OUTOFORDER_WAIT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1217i32);
pub const D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_ESTIMATOR_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1218i32);
pub const D3D12_MESSAGE_ID_VIDEO_CREATE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1219i32);
pub const D3D12_MESSAGE_ID_ESTIMATE_MOTION_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1220i32);
pub const D3D12_MESSAGE_ID_RESOLVE_MOTION_VECTOR_HEAP_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1221i32);
pub const D3D12_MESSAGE_ID_GETGPUVIRTUALADDRESS_INVALID_HEAP_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1222i32);
pub const D3D12_MESSAGE_ID_SET_BACKGROUND_PROCESSING_MODE_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1223i32);
pub const D3D12_MESSAGE_ID_CREATE_COMMAND_LIST_INVALID_COMMAND_LIST_TYPE_FOR_FEATURE_LEVEL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1224i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOEXTENSIONCOMMAND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1225i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOEXTENSIONCOMMAND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1226i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOEXTENSIONCOMMAND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1227i32);
pub const D3D12_MESSAGE_ID_INVALID_VIDEO_EXTENSION_COMMAND_ID: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1228i32);
pub const D3D12_MESSAGE_ID_VIDEO_EXTENSION_COMMAND_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1229i32);
pub const D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_NOT_UNIQUE_IN_DXIL_LIBRARY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1230i32);
pub const D3D12_MESSAGE_ID_VARIABLE_SHADING_RATE_NOT_ALLOWED_WITH_TIR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1231i32);
pub const D3D12_MESSAGE_ID_GEOMETRY_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1232i32);
pub const D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_SHADING_RATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1233i32);
pub const D3D12_MESSAGE_ID_RSSETSHADING_RATE_SHADING_RATE_NOT_PERMITTED_BY_CAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1234i32);
pub const D3D12_MESSAGE_ID_RSSETSHADING_RATE_INVALID_COMBINER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1235i32);
pub const D3D12_MESSAGE_ID_RSSETSHADINGRATEIMAGE_REQUIRES_TIER_2: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1236i32);
pub const D3D12_MESSAGE_ID_RSSETSHADINGRATE_REQUIRES_TIER_1: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1237i32);
pub const D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1238i32);
pub const D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_ARRAY_SIZE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1239i32);
pub const D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_MIP_LEVEL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1240i32);
pub const D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_COUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1241i32);
pub const D3D12_MESSAGE_ID_SHADING_RATE_IMAGE_INCORRECT_SAMPLE_QUALITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1242i32);
pub const D3D12_MESSAGE_ID_NON_RETAIL_SHADER_MODEL_WONT_VALIDATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1243i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1244i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_ROOT_SIGNATURE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1245i32);
pub const D3D12_MESSAGE_ID_ADD_TO_STATE_OBJECT_ERROR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1246i32);
pub const D3D12_MESSAGE_ID_CREATE_PROTECTED_RESOURCE_SESSION_INVALID_ARGUMENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1247i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_PSO_DESC_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1248i32);
pub const D3D12_MESSAGE_ID_CREATEPIPELINESTATE_MS_INCOMPLETE_TYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1249i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_AS_NOT_MS_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1250i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_MS_NOT_PS_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1251i32);
pub const D3D12_MESSAGE_ID_NONZERO_SAMPLER_FEEDBACK_MIP_REGION_WITH_INCOMPATIBLE_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1252i32);
pub const D3D12_MESSAGE_ID_CREATEGRAPHICSPIPELINESTATE_INPUTLAYOUT_SHADER_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1253i32);
pub const D3D12_MESSAGE_ID_EMPTY_DISPATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1254i32);
pub const D3D12_MESSAGE_ID_RESOURCE_FORMAT_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1255i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_MIP_REGION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1256i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_DIMENSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1257i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_COUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1258i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_SAMPLE_QUALITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1259i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_INVALID_LAYOUT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1260i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_MAP_REQUIRES_UNORDERED_ACCESS_FLAG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1261i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_NULL_ARGUMENTS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1262i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_UAV_REQUIRES_SAMPLER_FEEDBACK_CAPABILITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1263i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_REQUIRES_FEEDBACK_MAP_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1264i32);
pub const D3D12_MESSAGE_ID_CREATEMESHSHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1265i32);
pub const D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1266i32);
pub const D3D12_MESSAGE_ID_CREATEMESHSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1267i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_INVALID_FORMAT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1268i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_INVALID_MIP_LEVEL_COUNT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1269i32);
pub const D3D12_MESSAGE_ID_RESOLVESUBRESOURCE_SAMPLER_FEEDBACK_TRANSCODE_ARRAY_SIZE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1270i32);
pub const D3D12_MESSAGE_ID_SAMPLER_FEEDBACK_CREATE_UAV_MISMATCHING_TARGETED_RESOURCE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1271i32);
pub const D3D12_MESSAGE_ID_CREATEMESHSHADER_OUTPUTEXCEEDSMAXSIZE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1272i32);
pub const D3D12_MESSAGE_ID_CREATEMESHSHADER_GROUPSHAREDEXCEEDSMAXSIZE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1273i32);
pub const D3D12_MESSAGE_ID_VERTEX_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1274i32);
pub const D3D12_MESSAGE_ID_MESH_SHADER_OUTPUTTING_BOTH_VIEWPORT_ARRAY_INDEX_AND_SHADING_RATE_NOT_SUPPORTED_ON_DEVICE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1275i32);
pub const D3D12_MESSAGE_ID_CREATEMESHSHADER_MISMATCHEDASMSPAYLOADSIZE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1276i32);
pub const D3D12_MESSAGE_ID_CREATE_ROOT_SIGNATURE_UNBOUNDED_STATIC_DESCRIPTORS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1277i32);
pub const D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_INVALIDSHADERBYTECODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1278i32);
pub const D3D12_MESSAGE_ID_CREATEAMPLIFICATIONSHADER_OUTOFMEMORY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1279i32);
pub const D3D12_MESSAGE_ID_CREATE_SHADERCACHESESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1280i32);
pub const D3D12_MESSAGE_ID_LIVE_SHADERCACHESESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1281i32);
pub const D3D12_MESSAGE_ID_DESTROY_SHADERCACHESESSION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1282i32);
pub const D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_INVALIDARGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1283i32);
pub const D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_DISABLED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1284i32);
pub const D3D12_MESSAGE_ID_CREATESHADERCACHESESSION_ALREADYOPEN: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1285i32);
pub const D3D12_MESSAGE_ID_SHADERCACHECONTROL_DEVELOPERMODE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1286i32);
pub const D3D12_MESSAGE_ID_SHADERCACHECONTROL_INVALIDFLAGS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1287i32);
pub const D3D12_MESSAGE_ID_SHADERCACHECONTROL_STATEALREADYSET: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1288i32);
pub const D3D12_MESSAGE_ID_SHADERCACHECONTROL_IGNOREDFLAG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1289i32);
pub const D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_ALREADYPRESENT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1290i32);
pub const D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_HASHCOLLISION: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1291i32);
pub const D3D12_MESSAGE_ID_SHADERCACHESESSION_STOREVALUE_CACHEFULL: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1292i32);
pub const D3D12_MESSAGE_ID_SHADERCACHESESSION_FINDVALUE_NOTFOUND: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1293i32);
pub const D3D12_MESSAGE_ID_SHADERCACHESESSION_CORRUPT: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1294i32);
pub const D3D12_MESSAGE_ID_SHADERCACHESESSION_DISABLED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1295i32);
pub const D3D12_MESSAGE_ID_OVERSIZED_DISPATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1296i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOENCODER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1297i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOENCODER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1298i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOENCODER: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1299i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEOENCODERHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1300i32);
pub const D3D12_MESSAGE_ID_LIVE_VIDEOENCODERHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1301i32);
pub const D3D12_MESSAGE_ID_DESTROY_VIDEOENCODERHEAP: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1302i32);
pub const D3D12_MESSAGE_ID_COPYTEXTUREREGION_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1303i32);
pub const D3D12_MESSAGE_ID_COPYRESOURCE_MISMATCH_ENCODE_REFERENCE_ONLY_FLAG: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1304i32);
pub const D3D12_MESSAGE_ID_ENCODE_FRAME_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1305i32);
pub const D3D12_MESSAGE_ID_ENCODE_FRAME_UNSUPPORTED_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1306i32);
pub const D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1307i32);
pub const D3D12_MESSAGE_ID_RESOLVE_ENCODER_OUTPUT_METADATA_UNSUPPORTED_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1308i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1309i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_UNSUPPORTED_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1310i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_INVALID_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1311i32);
pub const D3D12_MESSAGE_ID_CREATE_VIDEO_ENCODER_HEAP_UNSUPPORTED_PARAMETERS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1312i32);
pub const D3D12_MESSAGE_ID_CREATECOMMANDLIST_NULL_COMMANDALLOCATOR: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1313i32);
pub const D3D12_MESSAGE_ID_CLEAR_UNORDERED_ACCESS_VIEW_INVALID_DESCRIPTOR_HANDLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1314i32);
pub const D3D12_MESSAGE_ID_DESCRIPTOR_HEAP_NOT_SHADER_VISIBLE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1315i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOP_WARNING: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1316i32);
pub const D3D12_MESSAGE_ID_CREATEBLENDSTATE_BLENDOPALPHA_WARNING: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1317i32);
pub const D3D12_MESSAGE_ID_WRITE_COMBINE_PERFORMANCE_WARNING: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1318i32);
pub const D3D12_MESSAGE_ID_RESOLVE_QUERY_INVALID_QUERY_STATE: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1319i32);
pub const D3D12_MESSAGE_ID_SETPRIVATEDATA_NO_ACCESS: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1320i32);
pub const D3D12_MESSAGE_ID_COMMAND_LIST_STATIC_DESCRIPTOR_SAMPLER_MODE_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1321i32);
pub const D3D12_MESSAGE_ID_GETCOPYABLEFOOTPRINTS_UNSUPPORTED_BUFFER_WIDTH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1322i32);
pub const D3D12_MESSAGE_ID_CREATEMESHSHADER_TOPOLOGY_MISMATCH: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1323i32);
pub const D3D12_MESSAGE_ID_VRS_SUM_COMBINER_REQUIRES_CAPABILITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1324i32);
pub const D3D12_MESSAGE_ID_SETTING_SHADING_RATE_FROM_MS_REQUIRES_CAPABILITY: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1325i32);
pub const D3D12_MESSAGE_ID_SHADERCACHESESSION_SHADERCACHEDELETE_NOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1326i32);
pub const D3D12_MESSAGE_ID_SHADERCACHECONTROL_SHADERCACHECLEAR_NOTSUPPORTED: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1327i32);
pub const D3D12_MESSAGE_ID_D3D12_MESSAGES_END: D3D12_MESSAGE_ID = D3D12_MESSAGE_ID(1328i32);
impl ::std::convert::From<i32> for D3D12_MESSAGE_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MESSAGE_ID {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MESSAGE_SEVERITY(pub i32);
pub const D3D12_MESSAGE_SEVERITY_CORRUPTION: D3D12_MESSAGE_SEVERITY = D3D12_MESSAGE_SEVERITY(0i32);
pub const D3D12_MESSAGE_SEVERITY_ERROR: D3D12_MESSAGE_SEVERITY = D3D12_MESSAGE_SEVERITY(1i32);
pub const D3D12_MESSAGE_SEVERITY_WARNING: D3D12_MESSAGE_SEVERITY = D3D12_MESSAGE_SEVERITY(2i32);
pub const D3D12_MESSAGE_SEVERITY_INFO: D3D12_MESSAGE_SEVERITY = D3D12_MESSAGE_SEVERITY(3i32);
pub const D3D12_MESSAGE_SEVERITY_MESSAGE: D3D12_MESSAGE_SEVERITY = D3D12_MESSAGE_SEVERITY(4i32);
impl ::std::convert::From<i32> for D3D12_MESSAGE_SEVERITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MESSAGE_SEVERITY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_META_COMMAND_DESC {
    pub Id: ::windows::runtime::GUID,
    pub Name: super::super::Foundation::PWSTR,
    pub InitializationDirtyState: D3D12_GRAPHICS_STATES,
    pub ExecutionDirtyState: D3D12_GRAPHICS_STATES,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_META_COMMAND_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_META_COMMAND_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_META_COMMAND_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_META_COMMAND_DESC").field("Id", &self.Id).field("Name", &self.Name).field("InitializationDirtyState", &self.InitializationDirtyState).field("ExecutionDirtyState", &self.ExecutionDirtyState).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_META_COMMAND_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Id == other.Id && self.Name == other.Name && self.InitializationDirtyState == other.InitializationDirtyState && self.ExecutionDirtyState == other.ExecutionDirtyState
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_META_COMMAND_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_META_COMMAND_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_META_COMMAND_PARAMETER_DESC {
    pub Name: super::super::Foundation::PWSTR,
    pub Type: D3D12_META_COMMAND_PARAMETER_TYPE,
    pub Flags: D3D12_META_COMMAND_PARAMETER_FLAGS,
    pub RequiredResourceState: D3D12_RESOURCE_STATES,
    pub StructureOffset: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_META_COMMAND_PARAMETER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_META_COMMAND_PARAMETER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_META_COMMAND_PARAMETER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_META_COMMAND_PARAMETER_DESC").field("Name", &self.Name).field("Type", &self.Type).field("Flags", &self.Flags).field("RequiredResourceState", &self.RequiredResourceState).field("StructureOffset", &self.StructureOffset).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_META_COMMAND_PARAMETER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.Type == other.Type && self.Flags == other.Flags && self.RequiredResourceState == other.RequiredResourceState && self.StructureOffset == other.StructureOffset
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_META_COMMAND_PARAMETER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_META_COMMAND_PARAMETER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_META_COMMAND_PARAMETER_FLAGS(pub u32);
pub const D3D12_META_COMMAND_PARAMETER_FLAG_INPUT: D3D12_META_COMMAND_PARAMETER_FLAGS = D3D12_META_COMMAND_PARAMETER_FLAGS(1u32);
pub const D3D12_META_COMMAND_PARAMETER_FLAG_OUTPUT: D3D12_META_COMMAND_PARAMETER_FLAGS = D3D12_META_COMMAND_PARAMETER_FLAGS(2u32);
impl ::std::convert::From<u32> for D3D12_META_COMMAND_PARAMETER_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_META_COMMAND_PARAMETER_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_META_COMMAND_PARAMETER_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_META_COMMAND_PARAMETER_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_META_COMMAND_PARAMETER_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_META_COMMAND_PARAMETER_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_META_COMMAND_PARAMETER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_META_COMMAND_PARAMETER_STAGE(pub i32);
pub const D3D12_META_COMMAND_PARAMETER_STAGE_CREATION: D3D12_META_COMMAND_PARAMETER_STAGE = D3D12_META_COMMAND_PARAMETER_STAGE(0i32);
pub const D3D12_META_COMMAND_PARAMETER_STAGE_INITIALIZATION: D3D12_META_COMMAND_PARAMETER_STAGE = D3D12_META_COMMAND_PARAMETER_STAGE(1i32);
pub const D3D12_META_COMMAND_PARAMETER_STAGE_EXECUTION: D3D12_META_COMMAND_PARAMETER_STAGE = D3D12_META_COMMAND_PARAMETER_STAGE(2i32);
impl ::std::convert::From<i32> for D3D12_META_COMMAND_PARAMETER_STAGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_META_COMMAND_PARAMETER_STAGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_META_COMMAND_PARAMETER_TYPE(pub i32);
pub const D3D12_META_COMMAND_PARAMETER_TYPE_FLOAT: D3D12_META_COMMAND_PARAMETER_TYPE = D3D12_META_COMMAND_PARAMETER_TYPE(0i32);
pub const D3D12_META_COMMAND_PARAMETER_TYPE_UINT64: D3D12_META_COMMAND_PARAMETER_TYPE = D3D12_META_COMMAND_PARAMETER_TYPE(1i32);
pub const D3D12_META_COMMAND_PARAMETER_TYPE_GPU_VIRTUAL_ADDRESS: D3D12_META_COMMAND_PARAMETER_TYPE = D3D12_META_COMMAND_PARAMETER_TYPE(2i32);
pub const D3D12_META_COMMAND_PARAMETER_TYPE_CPU_DESCRIPTOR_HANDLE_HEAP_TYPE_CBV_SRV_UAV: D3D12_META_COMMAND_PARAMETER_TYPE = D3D12_META_COMMAND_PARAMETER_TYPE(3i32);
pub const D3D12_META_COMMAND_PARAMETER_TYPE_GPU_DESCRIPTOR_HANDLE_HEAP_TYPE_CBV_SRV_UAV: D3D12_META_COMMAND_PARAMETER_TYPE = D3D12_META_COMMAND_PARAMETER_TYPE(4i32);
impl ::std::convert::From<i32> for D3D12_META_COMMAND_PARAMETER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_META_COMMAND_PARAMETER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_MINOR_VERSION: u32 = 0u32;
pub const D3D12_MIN_BORDER_COLOR_COMPONENT: f32 = 0f32;
pub const D3D12_MIN_DEPTH: f32 = 0f32;
pub const D3D12_MIN_FILTER_SHIFT: u32 = 4u32;
pub const D3D12_MIN_MAXANISOTROPY: u32 = 0u32;
pub const D3D12_MIP_FILTER_SHIFT: u32 = 0u32;
pub const D3D12_MIP_LOD_BIAS_MAX: f32 = 15.99f32;
pub const D3D12_MIP_LOD_BIAS_MIN: f32 = -16f32;
pub const D3D12_MIP_LOD_FRACTIONAL_BIT_COUNT: u32 = 8u32;
pub const D3D12_MIP_LOD_RANGE_BIT_COUNT: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_MIP_REGION {
    pub Width: u32,
    pub Height: u32,
    pub Depth: u32,
}
impl D3D12_MIP_REGION {}
impl ::std::default::Default for D3D12_MIP_REGION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_MIP_REGION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_MIP_REGION").field("Width", &self.Width).field("Height", &self.Height).field("Depth", &self.Depth).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_MIP_REGION {
    fn eq(&self, other: &Self) -> bool {
        self.Width == other.Width && self.Height == other.Height && self.Depth == other.Depth
    }
}
impl ::std::cmp::Eq for D3D12_MIP_REGION {}
unsafe impl ::windows::runtime::Abi for D3D12_MIP_REGION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MULTIPLE_FENCE_WAIT_FLAGS(pub u32);
pub const D3D12_MULTIPLE_FENCE_WAIT_FLAG_NONE: D3D12_MULTIPLE_FENCE_WAIT_FLAGS = D3D12_MULTIPLE_FENCE_WAIT_FLAGS(0u32);
pub const D3D12_MULTIPLE_FENCE_WAIT_FLAG_ANY: D3D12_MULTIPLE_FENCE_WAIT_FLAGS = D3D12_MULTIPLE_FENCE_WAIT_FLAGS(1u32);
pub const D3D12_MULTIPLE_FENCE_WAIT_FLAG_ALL: D3D12_MULTIPLE_FENCE_WAIT_FLAGS = D3D12_MULTIPLE_FENCE_WAIT_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_MULTIPLE_FENCE_WAIT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_MULTISAMPLE_ANTIALIAS_LINE_WIDTH: f32 = 1.4f32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS(pub u32);
pub const D3D12_MULTISAMPLE_QUALITY_LEVELS_FLAG_NONE: D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS = D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS(0u32);
pub const D3D12_MULTISAMPLE_QUALITY_LEVELS_FLAG_TILED_RESOURCE: D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS = D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_MULTISAMPLE_QUALITY_LEVEL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_NODE_MASK {
    pub NodeMask: u32,
}
impl D3D12_NODE_MASK {}
impl ::std::default::Default for D3D12_NODE_MASK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_NODE_MASK {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_NODE_MASK").field("NodeMask", &self.NodeMask).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_NODE_MASK {
    fn eq(&self, other: &Self) -> bool {
        self.NodeMask == other.NodeMask
    }
}
impl ::std::cmp::Eq for D3D12_NODE_MASK {}
unsafe impl ::windows::runtime::Abi for D3D12_NODE_MASK {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT: u32 = 0u32;
pub const D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_END: u32 = 4294967295u32;
pub const D3D12_OS_RESERVED_REGISTER_SPACE_VALUES_START: u32 = 4294967288u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_PACKED_MIP_INFO {
    pub NumStandardMips: u8,
    pub NumPackedMips: u8,
    pub NumTilesForPackedMips: u32,
    pub StartTileIndexInOverallResource: u32,
}
impl D3D12_PACKED_MIP_INFO {}
impl ::std::default::Default for D3D12_PACKED_MIP_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_PACKED_MIP_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_PACKED_MIP_INFO").field("NumStandardMips", &self.NumStandardMips).field("NumPackedMips", &self.NumPackedMips).field("NumTilesForPackedMips", &self.NumTilesForPackedMips).field("StartTileIndexInOverallResource", &self.StartTileIndexInOverallResource).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_PACKED_MIP_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.NumStandardMips == other.NumStandardMips && self.NumPackedMips == other.NumPackedMips && self.NumTilesForPackedMips == other.NumTilesForPackedMips && self.StartTileIndexInOverallResource == other.StartTileIndexInOverallResource
    }
}
impl ::std::cmp::Eq for D3D12_PACKED_MIP_INFO {}
unsafe impl ::windows::runtime::Abi for D3D12_PACKED_MIP_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_PACKED_TILE: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
pub struct D3D12_PARAMETER_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub SemanticName: super::super::Foundation::PSTR,
    pub Type: super::Direct3D11::D3D_SHADER_VARIABLE_TYPE,
    pub Class: super::Direct3D11::D3D_SHADER_VARIABLE_CLASS,
    pub Rows: u32,
    pub Columns: u32,
    pub InterpolationMode: super::Direct3D11::D3D_INTERPOLATION_MODE,
    pub Flags: super::Direct3D11::D3D_PARAMETER_FLAGS,
    pub FirstInRegister: u32,
    pub FirstInComponent: u32,
    pub FirstOutRegister: u32,
    pub FirstOutComponent: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl D3D12_PARAMETER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::default::Default for D3D12_PARAMETER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::fmt::Debug for D3D12_PARAMETER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_PARAMETER_DESC")
            .field("Name", &self.Name)
            .field("SemanticName", &self.SemanticName)
            .field("Type", &self.Type)
            .field("Class", &self.Class)
            .field("Rows", &self.Rows)
            .field("Columns", &self.Columns)
            .field("InterpolationMode", &self.InterpolationMode)
            .field("Flags", &self.Flags)
            .field("FirstInRegister", &self.FirstInRegister)
            .field("FirstInComponent", &self.FirstInComponent)
            .field("FirstOutRegister", &self.FirstOutRegister)
            .field("FirstOutComponent", &self.FirstOutComponent)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::PartialEq for D3D12_PARAMETER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.SemanticName == other.SemanticName && self.Type == other.Type && self.Class == other.Class && self.Rows == other.Rows && self.Columns == other.Columns && self.InterpolationMode == other.InterpolationMode && self.Flags == other.Flags && self.FirstInRegister == other.FirstInRegister && self.FirstInComponent == other.FirstInComponent && self.FirstOutRegister == other.FirstOutRegister && self.FirstOutComponent == other.FirstOutComponent
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::Eq for D3D12_PARAMETER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
unsafe impl ::windows::runtime::Abi for D3D12_PARAMETER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PIPELINE_STATE_FLAGS(pub u32);
pub const D3D12_PIPELINE_STATE_FLAG_NONE: D3D12_PIPELINE_STATE_FLAGS = D3D12_PIPELINE_STATE_FLAGS(0u32);
pub const D3D12_PIPELINE_STATE_FLAG_TOOL_DEBUG: D3D12_PIPELINE_STATE_FLAGS = D3D12_PIPELINE_STATE_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_PIPELINE_STATE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PIPELINE_STATE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_PIPELINE_STATE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_PIPELINE_STATE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_PIPELINE_STATE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_PIPELINE_STATE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_PIPELINE_STATE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_PIPELINE_STATE_STREAM_DESC {
    pub SizeInBytes: usize,
    pub pPipelineStateSubobjectStream: *mut ::std::ffi::c_void,
}
impl D3D12_PIPELINE_STATE_STREAM_DESC {}
impl ::std::default::Default for D3D12_PIPELINE_STATE_STREAM_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_PIPELINE_STATE_STREAM_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_PIPELINE_STATE_STREAM_DESC").field("SizeInBytes", &self.SizeInBytes).field("pPipelineStateSubobjectStream", &self.pPipelineStateSubobjectStream).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_PIPELINE_STATE_STREAM_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.SizeInBytes == other.SizeInBytes && self.pPipelineStateSubobjectStream == other.pPipelineStateSubobjectStream
    }
}
impl ::std::cmp::Eq for D3D12_PIPELINE_STATE_STREAM_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_PIPELINE_STATE_STREAM_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(pub i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_ROOT_SIGNATURE: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(0i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(1i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(2i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(3i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_HS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(4i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_GS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(5i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(6i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_STREAM_OUTPUT: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(7i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_BLEND: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(8i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_MASK: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(9i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RASTERIZER: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(10i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(11i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_INPUT_LAYOUT: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(12i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_IB_STRIP_CUT_VALUE: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(13i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_PRIMITIVE_TOPOLOGY: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(14i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_RENDER_TARGET_FORMATS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(15i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL_FORMAT: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(16i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_SAMPLE_DESC: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(17i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_NODE_MASK: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(18i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_CACHED_PSO: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(19i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_FLAGS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(20i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_DEPTH_STENCIL1: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(21i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_VIEW_INSTANCING: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(22i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_AS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(24i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MS: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(25i32);
pub const D3D12_PIPELINE_STATE_SUBOBJECT_TYPE_MAX_VALID: D3D12_PIPELINE_STATE_SUBOBJECT_TYPE = D3D12_PIPELINE_STATE_SUBOBJECT_TYPE(26i32);
impl ::std::convert::From<i32> for D3D12_PIPELINE_STATE_SUBOBJECT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PIPELINE_STATE_SUBOBJECT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 15u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    pub Offset: u64,
    pub Footprint: D3D12_SUBRESOURCE_FOOTPRINT,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_PLACED_SUBRESOURCE_FOOTPRINT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_PLACED_SUBRESOURCE_FOOTPRINT").field("Offset", &self.Offset).field("Footprint", &self.Footprint).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    fn eq(&self, other: &Self) -> bool {
        self.Offset == other.Offset && self.Footprint == other.Footprint
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_PLACED_SUBRESOURCE_FOOTPRINT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_PLACED_SUBRESOURCE_FOOTPRINT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PREDICATION_OP(pub i32);
pub const D3D12_PREDICATION_OP_EQUAL_ZERO: D3D12_PREDICATION_OP = D3D12_PREDICATION_OP(0i32);
pub const D3D12_PREDICATION_OP_NOT_EQUAL_ZERO: D3D12_PREDICATION_OP = D3D12_PREDICATION_OP(1i32);
impl ::std::convert::From<i32> for D3D12_PREDICATION_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PREDICATION_OP {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 16u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PRIMITIVE_TOPOLOGY_TYPE(pub i32);
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_UNDEFINED: D3D12_PRIMITIVE_TOPOLOGY_TYPE = D3D12_PRIMITIVE_TOPOLOGY_TYPE(0i32);
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_POINT: D3D12_PRIMITIVE_TOPOLOGY_TYPE = D3D12_PRIMITIVE_TOPOLOGY_TYPE(1i32);
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_LINE: D3D12_PRIMITIVE_TOPOLOGY_TYPE = D3D12_PRIMITIVE_TOPOLOGY_TYPE(2i32);
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_TRIANGLE: D3D12_PRIMITIVE_TOPOLOGY_TYPE = D3D12_PRIMITIVE_TOPOLOGY_TYPE(3i32);
pub const D3D12_PRIMITIVE_TOPOLOGY_TYPE_PATCH: D3D12_PRIMITIVE_TOPOLOGY_TYPE = D3D12_PRIMITIVE_TOPOLOGY_TYPE(4i32);
impl ::std::convert::From<i32> for D3D12_PRIMITIVE_TOPOLOGY_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PRIMITIVE_TOPOLOGY_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER(pub i32);
pub const D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_NOT_SUPPORTED: D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER = D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER(0i32);
pub const D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_1: D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER = D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER(1i32);
pub const D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER_2: D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER = D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER(2i32);
impl ::std::convert::From<i32> for D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PROGRAMMABLE_SAMPLE_POSITIONS_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_PROTECTED_RESOURCES_SESSION_HARDWARE_PROTECTED: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1655703630, 50958, 19882, [161, 9, 48, 255, 141, 90, 4, 130]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_PROTECTED_RESOURCE_SESSION_DESC {
    pub NodeMask: u32,
    pub Flags: D3D12_PROTECTED_RESOURCE_SESSION_FLAGS,
}
impl D3D12_PROTECTED_RESOURCE_SESSION_DESC {}
impl ::std::default::Default for D3D12_PROTECTED_RESOURCE_SESSION_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_PROTECTED_RESOURCE_SESSION_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_PROTECTED_RESOURCE_SESSION_DESC").field("NodeMask", &self.NodeMask).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_PROTECTED_RESOURCE_SESSION_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.NodeMask == other.NodeMask && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_PROTECTED_RESOURCE_SESSION_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_PROTECTED_RESOURCE_SESSION_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {
    pub NodeMask: u32,
    pub Flags: D3D12_PROTECTED_RESOURCE_SESSION_FLAGS,
    pub ProtectionType: ::windows::runtime::GUID,
}
impl D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {}
impl ::std::default::Default for D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_PROTECTED_RESOURCE_SESSION_DESC1").field("NodeMask", &self.NodeMask).field("Flags", &self.Flags).field("ProtectionType", &self.ProtectionType).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.NodeMask == other.NodeMask && self.Flags == other.Flags && self.ProtectionType == other.ProtectionType
    }
}
impl ::std::cmp::Eq for D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {}
unsafe impl ::windows::runtime::Abi for D3D12_PROTECTED_RESOURCE_SESSION_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PROTECTED_RESOURCE_SESSION_FLAGS(pub u32);
pub const D3D12_PROTECTED_RESOURCE_SESSION_FLAG_NONE: D3D12_PROTECTED_RESOURCE_SESSION_FLAGS = D3D12_PROTECTED_RESOURCE_SESSION_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D12_PROTECTED_RESOURCE_SESSION_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PROTECTED_RESOURCE_SESSION_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_PROTECTED_RESOURCE_SESSION_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_PROTECTED_RESOURCE_SESSION_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_PROTECTED_RESOURCE_SESSION_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_PROTECTED_RESOURCE_SESSION_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_PROTECTED_RESOURCE_SESSION_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS(pub u32);
pub const D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAG_NONE: D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS = D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS(0u32);
pub const D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAG_SUPPORTED: D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS = D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_PROTECTED_RESOURCE_SESSION_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_PROTECTED_SESSION_STATUS(pub i32);
pub const D3D12_PROTECTED_SESSION_STATUS_OK: D3D12_PROTECTED_SESSION_STATUS = D3D12_PROTECTED_SESSION_STATUS(0i32);
pub const D3D12_PROTECTED_SESSION_STATUS_INVALID: D3D12_PROTECTED_SESSION_STATUS = D3D12_PROTECTED_SESSION_STATUS(1i32);
impl ::std::convert::From<i32> for D3D12_PROTECTED_SESSION_STATUS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_PROTECTED_SESSION_STATUS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_PS_CS_UAV_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_PS_CS_UAV_REGISTER_COUNT: u32 = 8u32;
pub const D3D12_PS_CS_UAV_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D12_PS_CS_UAV_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_PS_FRONTFACING_DEFAULT_VALUE: u32 = 4294967295u32;
pub const D3D12_PS_FRONTFACING_FALSE_VALUE: u32 = 0u32;
pub const D3D12_PS_FRONTFACING_TRUE_VALUE: u32 = 4294967295u32;
pub const D3D12_PS_INPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_PS_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_PS_INPUT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_PS_INPUT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT: f32 = 0f32;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_PS_OUTPUT_DEPTH_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_PS_OUTPUT_MASK_REGISTER_COUNT: u32 = 1u32;
pub const D3D12_PS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_PS_OUTPUT_REGISTER_COUNT: u32 = 8u32;
pub const D3D12_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT: f32 = 0.5f32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_QUERY_DATA_PIPELINE_STATISTICS {
    pub IAVertices: u64,
    pub IAPrimitives: u64,
    pub VSInvocations: u64,
    pub GSInvocations: u64,
    pub GSPrimitives: u64,
    pub CInvocations: u64,
    pub CPrimitives: u64,
    pub PSInvocations: u64,
    pub HSInvocations: u64,
    pub DSInvocations: u64,
    pub CSInvocations: u64,
}
impl D3D12_QUERY_DATA_PIPELINE_STATISTICS {}
impl ::std::default::Default for D3D12_QUERY_DATA_PIPELINE_STATISTICS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_QUERY_DATA_PIPELINE_STATISTICS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_QUERY_DATA_PIPELINE_STATISTICS")
            .field("IAVertices", &self.IAVertices)
            .field("IAPrimitives", &self.IAPrimitives)
            .field("VSInvocations", &self.VSInvocations)
            .field("GSInvocations", &self.GSInvocations)
            .field("GSPrimitives", &self.GSPrimitives)
            .field("CInvocations", &self.CInvocations)
            .field("CPrimitives", &self.CPrimitives)
            .field("PSInvocations", &self.PSInvocations)
            .field("HSInvocations", &self.HSInvocations)
            .field("DSInvocations", &self.DSInvocations)
            .field("CSInvocations", &self.CSInvocations)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_QUERY_DATA_PIPELINE_STATISTICS {
    fn eq(&self, other: &Self) -> bool {
        self.IAVertices == other.IAVertices && self.IAPrimitives == other.IAPrimitives && self.VSInvocations == other.VSInvocations && self.GSInvocations == other.GSInvocations && self.GSPrimitives == other.GSPrimitives && self.CInvocations == other.CInvocations && self.CPrimitives == other.CPrimitives && self.PSInvocations == other.PSInvocations && self.HSInvocations == other.HSInvocations && self.DSInvocations == other.DSInvocations && self.CSInvocations == other.CSInvocations
    }
}
impl ::std::cmp::Eq for D3D12_QUERY_DATA_PIPELINE_STATISTICS {}
unsafe impl ::windows::runtime::Abi for D3D12_QUERY_DATA_PIPELINE_STATISTICS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {
    pub IAVertices: u64,
    pub IAPrimitives: u64,
    pub VSInvocations: u64,
    pub GSInvocations: u64,
    pub GSPrimitives: u64,
    pub CInvocations: u64,
    pub CPrimitives: u64,
    pub PSInvocations: u64,
    pub HSInvocations: u64,
    pub DSInvocations: u64,
    pub CSInvocations: u64,
    pub ASInvocations: u64,
    pub MSInvocations: u64,
    pub MSPrimitives: u64,
}
impl D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {}
impl ::std::default::Default for D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_QUERY_DATA_PIPELINE_STATISTICS1")
            .field("IAVertices", &self.IAVertices)
            .field("IAPrimitives", &self.IAPrimitives)
            .field("VSInvocations", &self.VSInvocations)
            .field("GSInvocations", &self.GSInvocations)
            .field("GSPrimitives", &self.GSPrimitives)
            .field("CInvocations", &self.CInvocations)
            .field("CPrimitives", &self.CPrimitives)
            .field("PSInvocations", &self.PSInvocations)
            .field("HSInvocations", &self.HSInvocations)
            .field("DSInvocations", &self.DSInvocations)
            .field("CSInvocations", &self.CSInvocations)
            .field("ASInvocations", &self.ASInvocations)
            .field("MSInvocations", &self.MSInvocations)
            .field("MSPrimitives", &self.MSPrimitives)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {
    fn eq(&self, other: &Self) -> bool {
        self.IAVertices == other.IAVertices
            && self.IAPrimitives == other.IAPrimitives
            && self.VSInvocations == other.VSInvocations
            && self.GSInvocations == other.GSInvocations
            && self.GSPrimitives == other.GSPrimitives
            && self.CInvocations == other.CInvocations
            && self.CPrimitives == other.CPrimitives
            && self.PSInvocations == other.PSInvocations
            && self.HSInvocations == other.HSInvocations
            && self.DSInvocations == other.DSInvocations
            && self.CSInvocations == other.CSInvocations
            && self.ASInvocations == other.ASInvocations
            && self.MSInvocations == other.MSInvocations
            && self.MSPrimitives == other.MSPrimitives
    }
}
impl ::std::cmp::Eq for D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {}
unsafe impl ::windows::runtime::Abi for D3D12_QUERY_DATA_PIPELINE_STATISTICS1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_QUERY_DATA_SO_STATISTICS {
    pub NumPrimitivesWritten: u64,
    pub PrimitivesStorageNeeded: u64,
}
impl D3D12_QUERY_DATA_SO_STATISTICS {}
impl ::std::default::Default for D3D12_QUERY_DATA_SO_STATISTICS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_QUERY_DATA_SO_STATISTICS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_QUERY_DATA_SO_STATISTICS").field("NumPrimitivesWritten", &self.NumPrimitivesWritten).field("PrimitivesStorageNeeded", &self.PrimitivesStorageNeeded).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_QUERY_DATA_SO_STATISTICS {
    fn eq(&self, other: &Self) -> bool {
        self.NumPrimitivesWritten == other.NumPrimitivesWritten && self.PrimitivesStorageNeeded == other.PrimitivesStorageNeeded
    }
}
impl ::std::cmp::Eq for D3D12_QUERY_DATA_SO_STATISTICS {}
unsafe impl ::windows::runtime::Abi for D3D12_QUERY_DATA_SO_STATISTICS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_QUERY_HEAP_DESC {
    pub Type: D3D12_QUERY_HEAP_TYPE,
    pub Count: u32,
    pub NodeMask: u32,
}
impl D3D12_QUERY_HEAP_DESC {}
impl ::std::default::Default for D3D12_QUERY_HEAP_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_QUERY_HEAP_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_QUERY_HEAP_DESC").field("Type", &self.Type).field("Count", &self.Count).field("NodeMask", &self.NodeMask).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_QUERY_HEAP_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.Count == other.Count && self.NodeMask == other.NodeMask
    }
}
impl ::std::cmp::Eq for D3D12_QUERY_HEAP_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_QUERY_HEAP_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_QUERY_HEAP_TYPE(pub i32);
pub const D3D12_QUERY_HEAP_TYPE_OCCLUSION: D3D12_QUERY_HEAP_TYPE = D3D12_QUERY_HEAP_TYPE(0i32);
pub const D3D12_QUERY_HEAP_TYPE_TIMESTAMP: D3D12_QUERY_HEAP_TYPE = D3D12_QUERY_HEAP_TYPE(1i32);
pub const D3D12_QUERY_HEAP_TYPE_PIPELINE_STATISTICS: D3D12_QUERY_HEAP_TYPE = D3D12_QUERY_HEAP_TYPE(2i32);
pub const D3D12_QUERY_HEAP_TYPE_SO_STATISTICS: D3D12_QUERY_HEAP_TYPE = D3D12_QUERY_HEAP_TYPE(3i32);
pub const D3D12_QUERY_HEAP_TYPE_VIDEO_DECODE_STATISTICS: D3D12_QUERY_HEAP_TYPE = D3D12_QUERY_HEAP_TYPE(4i32);
pub const D3D12_QUERY_HEAP_TYPE_COPY_QUEUE_TIMESTAMP: D3D12_QUERY_HEAP_TYPE = D3D12_QUERY_HEAP_TYPE(5i32);
pub const D3D12_QUERY_HEAP_TYPE_PIPELINE_STATISTICS1: D3D12_QUERY_HEAP_TYPE = D3D12_QUERY_HEAP_TYPE(7i32);
impl ::std::convert::From<i32> for D3D12_QUERY_HEAP_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_QUERY_HEAP_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_QUERY_TYPE(pub i32);
pub const D3D12_QUERY_TYPE_OCCLUSION: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(0i32);
pub const D3D12_QUERY_TYPE_BINARY_OCCLUSION: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(1i32);
pub const D3D12_QUERY_TYPE_TIMESTAMP: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(2i32);
pub const D3D12_QUERY_TYPE_PIPELINE_STATISTICS: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(3i32);
pub const D3D12_QUERY_TYPE_SO_STATISTICS_STREAM0: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(4i32);
pub const D3D12_QUERY_TYPE_SO_STATISTICS_STREAM1: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(5i32);
pub const D3D12_QUERY_TYPE_SO_STATISTICS_STREAM2: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(6i32);
pub const D3D12_QUERY_TYPE_SO_STATISTICS_STREAM3: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(7i32);
pub const D3D12_QUERY_TYPE_VIDEO_DECODE_STATISTICS: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(8i32);
pub const D3D12_QUERY_TYPE_PIPELINE_STATISTICS1: D3D12_QUERY_TYPE = D3D12_QUERY_TYPE(10i32);
impl ::std::convert::From<i32> for D3D12_QUERY_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_QUERY_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RANGE {
    pub Begin: usize,
    pub End: usize,
}
impl D3D12_RANGE {}
impl ::std::default::Default for D3D12_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RANGE").field("Begin", &self.Begin).field("End", &self.End).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.Begin == other.Begin && self.End == other.End
    }
}
impl ::std::cmp::Eq for D3D12_RANGE {}
unsafe impl ::windows::runtime::Abi for D3D12_RANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RANGE_UINT64 {
    pub Begin: u64,
    pub End: u64,
}
impl D3D12_RANGE_UINT64 {}
impl ::std::default::Default for D3D12_RANGE_UINT64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RANGE_UINT64 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RANGE_UINT64").field("Begin", &self.Begin).field("End", &self.End).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RANGE_UINT64 {
    fn eq(&self, other: &Self) -> bool {
        self.Begin == other.Begin && self.End == other.End
    }
}
impl ::std::cmp::Eq for D3D12_RANGE_UINT64 {}
unsafe impl ::windows::runtime::Abi for D3D12_RANGE_UINT64 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_RASTERIZER_DESC {
    pub FillMode: D3D12_FILL_MODE,
    pub CullMode: D3D12_CULL_MODE,
    pub FrontCounterClockwise: super::super::Foundation::BOOL,
    pub DepthBias: i32,
    pub DepthBiasClamp: f32,
    pub SlopeScaledDepthBias: f32,
    pub DepthClipEnable: super::super::Foundation::BOOL,
    pub MultisampleEnable: super::super::Foundation::BOOL,
    pub AntialiasedLineEnable: super::super::Foundation::BOOL,
    pub ForcedSampleCount: u32,
    pub ConservativeRaster: D3D12_CONSERVATIVE_RASTERIZATION_MODE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_RASTERIZER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_RASTERIZER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_RASTERIZER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RASTERIZER_DESC")
            .field("FillMode", &self.FillMode)
            .field("CullMode", &self.CullMode)
            .field("FrontCounterClockwise", &self.FrontCounterClockwise)
            .field("DepthBias", &self.DepthBias)
            .field("DepthBiasClamp", &self.DepthBiasClamp)
            .field("SlopeScaledDepthBias", &self.SlopeScaledDepthBias)
            .field("DepthClipEnable", &self.DepthClipEnable)
            .field("MultisampleEnable", &self.MultisampleEnable)
            .field("AntialiasedLineEnable", &self.AntialiasedLineEnable)
            .field("ForcedSampleCount", &self.ForcedSampleCount)
            .field("ConservativeRaster", &self.ConservativeRaster)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_RASTERIZER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.FillMode == other.FillMode
            && self.CullMode == other.CullMode
            && self.FrontCounterClockwise == other.FrontCounterClockwise
            && self.DepthBias == other.DepthBias
            && self.DepthBiasClamp == other.DepthBiasClamp
            && self.SlopeScaledDepthBias == other.SlopeScaledDepthBias
            && self.DepthClipEnable == other.DepthClipEnable
            && self.MultisampleEnable == other.MultisampleEnable
            && self.AntialiasedLineEnable == other.AntialiasedLineEnable
            && self.ForcedSampleCount == other.ForcedSampleCount
            && self.ConservativeRaster == other.ConservativeRaster
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_RASTERIZER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_RASTERIZER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_RAW_UAV_SRV_BYTE_ALIGNMENT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_AABB {
    pub MinX: f32,
    pub MinY: f32,
    pub MinZ: f32,
    pub MaxX: f32,
    pub MaxY: f32,
    pub MaxZ: f32,
}
impl D3D12_RAYTRACING_AABB {}
impl ::std::default::Default for D3D12_RAYTRACING_AABB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_AABB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_AABB").field("MinX", &self.MinX).field("MinY", &self.MinY).field("MinZ", &self.MinZ).field("MaxX", &self.MaxX).field("MaxY", &self.MaxY).field("MaxZ", &self.MaxZ).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_AABB {
    fn eq(&self, other: &Self) -> bool {
        self.MinX == other.MinX && self.MinY == other.MinY && self.MinZ == other.MinZ && self.MaxX == other.MaxX && self.MaxY == other.MaxY && self.MaxZ == other.MaxZ
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_AABB {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_AABB {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_RAYTRACING_AABB_BYTE_ALIGNMENT: u32 = 8u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(pub u32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_NONE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(0u32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_ALLOW_UPDATE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(1u32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_ALLOW_COMPACTION: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(2u32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PREFER_FAST_TRACE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(4u32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PREFER_FAST_BUILD: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(8u32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_MINIMIZE_MEMORY: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(16u32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAG_PERFORM_UPDATE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS(32u32);
impl ::std::convert::From<u32> for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BUILD_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_BYTE_ALIGNMENT: u32 = 256u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE(pub i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_CLONE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE(0i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_COMPACT: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE(1i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_VISUALIZATION_DECODE_FOR_TOOLS: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE(2i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_SERIALIZE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE(3i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE_DESERIALIZE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE(4i32);
impl ::std::convert::From<i32> for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_COPY_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC {
    pub CompactedSizeInBytes: u64,
}
impl D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC {}
impl ::std::default::Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC").field("CompactedSizeInBytes", &self.CompactedSizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.CompactedSizeInBytes == other.CompactedSizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC {
    pub CurrentSizeInBytes: u64,
}
impl D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC {}
impl ::std::default::Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC").field("CurrentSizeInBytes", &self.CurrentSizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.CurrentSizeInBytes == other.CurrentSizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {
    pub DestBuffer: u64,
    pub InfoType: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE,
}
impl D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {}
impl ::std::default::Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC").field("DestBuffer", &self.DestBuffer).field("InfoType", &self.InfoType).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.DestBuffer == other.DestBuffer && self.InfoType == other.InfoType
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC {
    pub SerializedSizeInBytes: u64,
    pub NumBottomLevelAccelerationStructurePointers: u64,
}
impl D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC {}
impl ::std::default::Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC").field("SerializedSizeInBytes", &self.SerializedSizeInBytes).field("NumBottomLevelAccelerationStructurePointers", &self.NumBottomLevelAccelerationStructurePointers).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.SerializedSizeInBytes == other.SerializedSizeInBytes && self.NumBottomLevelAccelerationStructurePointers == other.NumBottomLevelAccelerationStructurePointers
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC {
    pub DecodedSizeInBytes: u64,
}
impl D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC {}
impl ::std::default::Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC").field("DecodedSizeInBytes", &self.DecodedSizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.DecodedSizeInBytes == other.DecodedSizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE(pub i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_COMPACTED_SIZE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE(0i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TOOLS_VISUALIZATION: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE(1i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_SERIALIZATION: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE(2i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_CURRENT_SIZE: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE(3i32);
impl ::std::convert::From<i32> for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_POSTBUILD_INFO_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {
    pub ResultDataMaxSizeInBytes: u64,
    pub ScratchDataSizeInBytes: u64,
    pub UpdateScratchDataSizeInBytes: u64,
}
impl D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {}
impl ::std::default::Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO").field("ResultDataMaxSizeInBytes", &self.ResultDataMaxSizeInBytes).field("ScratchDataSizeInBytes", &self.ScratchDataSizeInBytes).field("UpdateScratchDataSizeInBytes", &self.UpdateScratchDataSizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.ResultDataMaxSizeInBytes == other.ResultDataMaxSizeInBytes && self.ScratchDataSizeInBytes == other.ScratchDataSizeInBytes && self.UpdateScratchDataSizeInBytes == other.UpdateScratchDataSizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_PREBUILD_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {
    pub Location: u64,
}
impl D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {}
impl ::std::default::Default for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV").field("Location", &self.Location).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.Location == other.Location
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE(pub i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_TOP_LEVEL: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE(0i32);
pub const D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE_BOTTOM_LEVEL: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE = D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE(1i32);
impl ::std::convert::From<i32> for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_ACCELERATION_STRUCTURE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {
    pub AABBCount: u64,
    pub AABBs: D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE,
}
impl D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {}
impl ::std::default::Default for D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_GEOMETRY_AABBS_DESC").field("AABBCount", &self.AABBCount).field("AABBs", &self.AABBs).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.AABBCount == other.AABBCount && self.AABBs == other.AABBs
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_GEOMETRY_AABBS_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RAYTRACING_GEOMETRY_DESC {
    pub Type: D3D12_RAYTRACING_GEOMETRY_TYPE,
    pub Flags: D3D12_RAYTRACING_GEOMETRY_FLAGS,
    pub Anonymous: D3D12_RAYTRACING_GEOMETRY_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RAYTRACING_GEOMETRY_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RAYTRACING_GEOMETRY_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_GEOMETRY_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RAYTRACING_GEOMETRY_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_GEOMETRY_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub union D3D12_RAYTRACING_GEOMETRY_DESC_0 {
    pub Triangles: D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC,
    pub AABBs: D3D12_RAYTRACING_GEOMETRY_AABBS_DESC,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RAYTRACING_GEOMETRY_DESC_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RAYTRACING_GEOMETRY_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_GEOMETRY_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RAYTRACING_GEOMETRY_DESC_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_GEOMETRY_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_GEOMETRY_FLAGS(pub u32);
pub const D3D12_RAYTRACING_GEOMETRY_FLAG_NONE: D3D12_RAYTRACING_GEOMETRY_FLAGS = D3D12_RAYTRACING_GEOMETRY_FLAGS(0u32);
pub const D3D12_RAYTRACING_GEOMETRY_FLAG_OPAQUE: D3D12_RAYTRACING_GEOMETRY_FLAGS = D3D12_RAYTRACING_GEOMETRY_FLAGS(1u32);
pub const D3D12_RAYTRACING_GEOMETRY_FLAG_NO_DUPLICATE_ANYHIT_INVOCATION: D3D12_RAYTRACING_GEOMETRY_FLAGS = D3D12_RAYTRACING_GEOMETRY_FLAGS(2u32);
impl ::std::convert::From<u32> for D3D12_RAYTRACING_GEOMETRY_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_GEOMETRY_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RAYTRACING_GEOMETRY_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RAYTRACING_GEOMETRY_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RAYTRACING_GEOMETRY_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RAYTRACING_GEOMETRY_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RAYTRACING_GEOMETRY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {
    pub Transform3x4: u64,
    pub IndexFormat: super::Dxgi::DXGI_FORMAT,
    pub VertexFormat: super::Dxgi::DXGI_FORMAT,
    pub IndexCount: u32,
    pub VertexCount: u32,
    pub IndexBuffer: u64,
    pub VertexBuffer: D3D12_GPU_VIRTUAL_ADDRESS_AND_STRIDE,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC")
            .field("Transform3x4", &self.Transform3x4)
            .field("IndexFormat", &self.IndexFormat)
            .field("VertexFormat", &self.VertexFormat)
            .field("IndexCount", &self.IndexCount)
            .field("VertexCount", &self.VertexCount)
            .field("IndexBuffer", &self.IndexBuffer)
            .field("VertexBuffer", &self.VertexBuffer)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Transform3x4 == other.Transform3x4 && self.IndexFormat == other.IndexFormat && self.VertexFormat == other.VertexFormat && self.IndexCount == other.IndexCount && self.VertexCount == other.VertexCount && self.IndexBuffer == other.IndexBuffer && self.VertexBuffer == other.VertexBuffer
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_GEOMETRY_TRIANGLES_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_GEOMETRY_TYPE(pub i32);
pub const D3D12_RAYTRACING_GEOMETRY_TYPE_TRIANGLES: D3D12_RAYTRACING_GEOMETRY_TYPE = D3D12_RAYTRACING_GEOMETRY_TYPE(0i32);
pub const D3D12_RAYTRACING_GEOMETRY_TYPE_PROCEDURAL_PRIMITIVE_AABBS: D3D12_RAYTRACING_GEOMETRY_TYPE = D3D12_RAYTRACING_GEOMETRY_TYPE(1i32);
impl ::std::convert::From<i32> for D3D12_RAYTRACING_GEOMETRY_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_GEOMETRY_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_INSTANCE_DESC {
    pub Transform: [f32; 12],
    pub _bitfield1: u32,
    pub _bitfield2: u32,
    pub AccelerationStructure: u64,
}
impl D3D12_RAYTRACING_INSTANCE_DESC {}
impl ::std::default::Default for D3D12_RAYTRACING_INSTANCE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_INSTANCE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_INSTANCE_DESC").field("Transform", &self.Transform).field("_bitfield1", &self._bitfield1).field("_bitfield2", &self._bitfield2).field("AccelerationStructure", &self.AccelerationStructure).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_INSTANCE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Transform == other.Transform && self._bitfield1 == other._bitfield1 && self._bitfield2 == other._bitfield2 && self.AccelerationStructure == other.AccelerationStructure
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_INSTANCE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_INSTANCE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_RAYTRACING_INSTANCE_DESCS_BYTE_ALIGNMENT: u32 = 16u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_INSTANCE_FLAGS(pub u32);
pub const D3D12_RAYTRACING_INSTANCE_FLAG_NONE: D3D12_RAYTRACING_INSTANCE_FLAGS = D3D12_RAYTRACING_INSTANCE_FLAGS(0u32);
pub const D3D12_RAYTRACING_INSTANCE_FLAG_TRIANGLE_CULL_DISABLE: D3D12_RAYTRACING_INSTANCE_FLAGS = D3D12_RAYTRACING_INSTANCE_FLAGS(1u32);
pub const D3D12_RAYTRACING_INSTANCE_FLAG_TRIANGLE_FRONT_COUNTERCLOCKWISE: D3D12_RAYTRACING_INSTANCE_FLAGS = D3D12_RAYTRACING_INSTANCE_FLAGS(2u32);
pub const D3D12_RAYTRACING_INSTANCE_FLAG_FORCE_OPAQUE: D3D12_RAYTRACING_INSTANCE_FLAGS = D3D12_RAYTRACING_INSTANCE_FLAGS(4u32);
pub const D3D12_RAYTRACING_INSTANCE_FLAG_FORCE_NON_OPAQUE: D3D12_RAYTRACING_INSTANCE_FLAGS = D3D12_RAYTRACING_INSTANCE_FLAGS(8u32);
impl ::std::convert::From<u32> for D3D12_RAYTRACING_INSTANCE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_INSTANCE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RAYTRACING_INSTANCE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RAYTRACING_INSTANCE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RAYTRACING_INSTANCE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RAYTRACING_INSTANCE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RAYTRACING_INSTANCE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_RAYTRACING_MAX_ATTRIBUTE_SIZE_IN_BYTES: u32 = 32u32;
pub const D3D12_RAYTRACING_MAX_DECLARABLE_TRACE_RECURSION_DEPTH: u32 = 31u32;
pub const D3D12_RAYTRACING_MAX_GEOMETRIES_PER_BOTTOM_LEVEL_ACCELERATION_STRUCTURE: u32 = 16777216u32;
pub const D3D12_RAYTRACING_MAX_INSTANCES_PER_TOP_LEVEL_ACCELERATION_STRUCTURE: u32 = 16777216u32;
pub const D3D12_RAYTRACING_MAX_PRIMITIVES_PER_BOTTOM_LEVEL_ACCELERATION_STRUCTURE: u32 = 536870912u32;
pub const D3D12_RAYTRACING_MAX_RAY_GENERATION_SHADER_THREADS: u32 = 1073741824u32;
pub const D3D12_RAYTRACING_MAX_SHADER_RECORD_STRIDE: u32 = 4096u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_PIPELINE_CONFIG {
    pub MaxTraceRecursionDepth: u32,
}
impl D3D12_RAYTRACING_PIPELINE_CONFIG {}
impl ::std::default::Default for D3D12_RAYTRACING_PIPELINE_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_PIPELINE_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_PIPELINE_CONFIG").field("MaxTraceRecursionDepth", &self.MaxTraceRecursionDepth).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_PIPELINE_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.MaxTraceRecursionDepth == other.MaxTraceRecursionDepth
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_PIPELINE_CONFIG {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_PIPELINE_CONFIG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_PIPELINE_CONFIG1 {
    pub MaxTraceRecursionDepth: u32,
    pub Flags: D3D12_RAYTRACING_PIPELINE_FLAGS,
}
impl D3D12_RAYTRACING_PIPELINE_CONFIG1 {}
impl ::std::default::Default for D3D12_RAYTRACING_PIPELINE_CONFIG1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_PIPELINE_CONFIG1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_PIPELINE_CONFIG1").field("MaxTraceRecursionDepth", &self.MaxTraceRecursionDepth).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_PIPELINE_CONFIG1 {
    fn eq(&self, other: &Self) -> bool {
        self.MaxTraceRecursionDepth == other.MaxTraceRecursionDepth && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_PIPELINE_CONFIG1 {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_PIPELINE_CONFIG1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_PIPELINE_FLAGS(pub u32);
pub const D3D12_RAYTRACING_PIPELINE_FLAG_NONE: D3D12_RAYTRACING_PIPELINE_FLAGS = D3D12_RAYTRACING_PIPELINE_FLAGS(0u32);
pub const D3D12_RAYTRACING_PIPELINE_FLAG_SKIP_TRIANGLES: D3D12_RAYTRACING_PIPELINE_FLAGS = D3D12_RAYTRACING_PIPELINE_FLAGS(256u32);
pub const D3D12_RAYTRACING_PIPELINE_FLAG_SKIP_PROCEDURAL_PRIMITIVES: D3D12_RAYTRACING_PIPELINE_FLAGS = D3D12_RAYTRACING_PIPELINE_FLAGS(512u32);
impl ::std::convert::From<u32> for D3D12_RAYTRACING_PIPELINE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_PIPELINE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RAYTRACING_PIPELINE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RAYTRACING_PIPELINE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RAYTRACING_PIPELINE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RAYTRACING_PIPELINE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RAYTRACING_PIPELINE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RAYTRACING_SHADER_CONFIG {
    pub MaxPayloadSizeInBytes: u32,
    pub MaxAttributeSizeInBytes: u32,
}
impl D3D12_RAYTRACING_SHADER_CONFIG {}
impl ::std::default::Default for D3D12_RAYTRACING_SHADER_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RAYTRACING_SHADER_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RAYTRACING_SHADER_CONFIG").field("MaxPayloadSizeInBytes", &self.MaxPayloadSizeInBytes).field("MaxAttributeSizeInBytes", &self.MaxAttributeSizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RAYTRACING_SHADER_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.MaxPayloadSizeInBytes == other.MaxPayloadSizeInBytes && self.MaxAttributeSizeInBytes == other.MaxAttributeSizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_RAYTRACING_SHADER_CONFIG {}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_SHADER_CONFIG {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_RAYTRACING_SHADER_RECORD_BYTE_ALIGNMENT: u32 = 32u32;
pub const D3D12_RAYTRACING_SHADER_TABLE_BYTE_ALIGNMENT: u32 = 64u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAYTRACING_TIER(pub i32);
pub const D3D12_RAYTRACING_TIER_NOT_SUPPORTED: D3D12_RAYTRACING_TIER = D3D12_RAYTRACING_TIER(0i32);
pub const D3D12_RAYTRACING_TIER_1_0: D3D12_RAYTRACING_TIER = D3D12_RAYTRACING_TIER(10i32);
pub const D3D12_RAYTRACING_TIER_1_1: D3D12_RAYTRACING_TIER = D3D12_RAYTRACING_TIER(11i32);
impl ::std::convert::From<i32> for D3D12_RAYTRACING_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAYTRACING_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_RAYTRACING_TRANSFORM3X4_BYTE_ALIGNMENT: u32 = 16u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RAY_FLAGS(pub u32);
pub const D3D12_RAY_FLAG_NONE: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(0u32);
pub const D3D12_RAY_FLAG_FORCE_OPAQUE: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(1u32);
pub const D3D12_RAY_FLAG_FORCE_NON_OPAQUE: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(2u32);
pub const D3D12_RAY_FLAG_ACCEPT_FIRST_HIT_AND_END_SEARCH: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(4u32);
pub const D3D12_RAY_FLAG_SKIP_CLOSEST_HIT_SHADER: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(8u32);
pub const D3D12_RAY_FLAG_CULL_BACK_FACING_TRIANGLES: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(16u32);
pub const D3D12_RAY_FLAG_CULL_FRONT_FACING_TRIANGLES: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(32u32);
pub const D3D12_RAY_FLAG_CULL_OPAQUE: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(64u32);
pub const D3D12_RAY_FLAG_CULL_NON_OPAQUE: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(128u32);
pub const D3D12_RAY_FLAG_SKIP_TRIANGLES: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(256u32);
pub const D3D12_RAY_FLAG_SKIP_PROCEDURAL_PRIMITIVES: D3D12_RAY_FLAGS = D3D12_RAY_FLAGS(512u32);
impl ::std::convert::From<u32> for D3D12_RAY_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RAY_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RAY_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RAY_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RAY_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RAY_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RAY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_REFLECT_SHARED_PROPERTY(pub i32);
pub const D3D12_REFLECT_SHARED_PROPERTY_D3D11_RESOURCE_FLAGS: D3D12_REFLECT_SHARED_PROPERTY = D3D12_REFLECT_SHARED_PROPERTY(0i32);
pub const D3D12_REFELCT_SHARED_PROPERTY_COMPATIBILITY_SHARED_FLAGS: D3D12_REFLECT_SHARED_PROPERTY = D3D12_REFLECT_SHARED_PROPERTY(1i32);
pub const D3D12_REFLECT_SHARED_PROPERTY_NON_NT_SHARED_HANDLE: D3D12_REFLECT_SHARED_PROPERTY = D3D12_REFLECT_SHARED_PROPERTY(2i32);
impl ::std::convert::From<i32> for D3D12_REFLECT_SHARED_PROPERTY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_REFLECT_SHARED_PROPERTY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RENDER_PASS_BEGINNING_ACCESS {
    pub Type: D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE,
    pub Anonymous: D3D12_RENDER_PASS_BEGINNING_ACCESS_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RENDER_PASS_BEGINNING_ACCESS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RENDER_PASS_BEGINNING_ACCESS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_BEGINNING_ACCESS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_BEGINNING_ACCESS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_BEGINNING_ACCESS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub union D3D12_RENDER_PASS_BEGINNING_ACCESS_0 {
    pub Clear: D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RENDER_PASS_BEGINNING_ACCESS_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RENDER_PASS_BEGINNING_ACCESS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_BEGINNING_ACCESS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_BEGINNING_ACCESS_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_BEGINNING_ACCESS_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {
    pub ClearValue: D3D12_CLEAR_VALUE,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_BEGINNING_ACCESS_CLEAR_PARAMETERS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE(pub i32);
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_DISCARD: D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE(0i32);
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_PRESERVE: D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE(1i32);
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_CLEAR: D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE(2i32);
pub const D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE_NO_ACCESS: D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE = D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE(3i32);
impl ::std::convert::From<i32> for D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_BEGINNING_ACCESS_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::clone::Clone for D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    pub cpuDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    pub DepthBeginningAccess: D3D12_RENDER_PASS_BEGINNING_ACCESS,
    pub StencilBeginningAccess: D3D12_RENDER_PASS_BEGINNING_ACCESS,
    pub DepthEndingAccess: D3D12_RENDER_PASS_ENDING_ACCESS,
    pub StencilEndingAccess: D3D12_RENDER_PASS_ENDING_ACCESS,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_DEPTH_STENCIL_DESC {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::clone::Clone for D3D12_RENDER_PASS_ENDING_ACCESS {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D12_RENDER_PASS_ENDING_ACCESS {
    pub Type: D3D12_RENDER_PASS_ENDING_ACCESS_TYPE,
    pub Anonymous: D3D12_RENDER_PASS_ENDING_ACCESS_0,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_RENDER_PASS_ENDING_ACCESS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_RENDER_PASS_ENDING_ACCESS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_ENDING_ACCESS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_ENDING_ACCESS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_ENDING_ACCESS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::clone::Clone for D3D12_RENDER_PASS_ENDING_ACCESS_0 {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub union D3D12_RENDER_PASS_ENDING_ACCESS_0 {
    pub Resolve: ::std::mem::ManuallyDrop<D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS>,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_RENDER_PASS_ENDING_ACCESS_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_RENDER_PASS_ENDING_ACCESS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_ENDING_ACCESS_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_ENDING_ACCESS_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_ENDING_ACCESS_0 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {
    pub pSrcResource: ::std::option::Option<ID3D12Resource>,
    pub pDstResource: ::std::option::Option<ID3D12Resource>,
    pub SubresourceCount: u32,
    pub pSubresourceParameters: *mut D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ResolveMode: D3D12_RESOLVE_MODE,
    pub PreserveResolveSource: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS")
            .field("pSrcResource", &self.pSrcResource)
            .field("pDstResource", &self.pDstResource)
            .field("SubresourceCount", &self.SubresourceCount)
            .field("pSubresourceParameters", &self.pSubresourceParameters)
            .field("Format", &self.Format)
            .field("ResolveMode", &self.ResolveMode)
            .field("PreserveResolveSource", &self.PreserveResolveSource)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.pSrcResource == other.pSrcResource && self.pDstResource == other.pDstResource && self.SubresourceCount == other.SubresourceCount && self.pSubresourceParameters == other.pSubresourceParameters && self.Format == other.Format && self.ResolveMode == other.ResolveMode && self.PreserveResolveSource == other.PreserveResolveSource
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_PARAMETERS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {
    pub SrcSubresource: u32,
    pub DstSubresource: u32,
    pub DstX: u32,
    pub DstY: u32,
    pub SrcRect: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS").field("SrcSubresource", &self.SrcSubresource).field("DstSubresource", &self.DstSubresource).field("DstX", &self.DstX).field("DstY", &self.DstY).field("SrcRect", &self.SrcRect).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.SrcSubresource == other.SrcSubresource && self.DstSubresource == other.DstSubresource && self.DstX == other.DstX && self.DstY == other.DstY && self.SrcRect == other.SrcRect
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_ENDING_ACCESS_RESOLVE_SUBRESOURCE_PARAMETERS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RENDER_PASS_ENDING_ACCESS_TYPE(pub i32);
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_DISCARD: D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = D3D12_RENDER_PASS_ENDING_ACCESS_TYPE(0i32);
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_PRESERVE: D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = D3D12_RENDER_PASS_ENDING_ACCESS_TYPE(1i32);
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_RESOLVE: D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = D3D12_RENDER_PASS_ENDING_ACCESS_TYPE(2i32);
pub const D3D12_RENDER_PASS_ENDING_ACCESS_TYPE_NO_ACCESS: D3D12_RENDER_PASS_ENDING_ACCESS_TYPE = D3D12_RENDER_PASS_ENDING_ACCESS_TYPE(3i32);
impl ::std::convert::From<i32> for D3D12_RENDER_PASS_ENDING_ACCESS_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_ENDING_ACCESS_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RENDER_PASS_FLAGS(pub u32);
pub const D3D12_RENDER_PASS_FLAG_NONE: D3D12_RENDER_PASS_FLAGS = D3D12_RENDER_PASS_FLAGS(0u32);
pub const D3D12_RENDER_PASS_FLAG_ALLOW_UAV_WRITES: D3D12_RENDER_PASS_FLAGS = D3D12_RENDER_PASS_FLAGS(1u32);
pub const D3D12_RENDER_PASS_FLAG_SUSPENDING_PASS: D3D12_RENDER_PASS_FLAGS = D3D12_RENDER_PASS_FLAGS(2u32);
pub const D3D12_RENDER_PASS_FLAG_RESUMING_PASS: D3D12_RENDER_PASS_FLAGS = D3D12_RENDER_PASS_FLAGS(4u32);
impl ::std::convert::From<u32> for D3D12_RENDER_PASS_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RENDER_PASS_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RENDER_PASS_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RENDER_PASS_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RENDER_PASS_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RENDER_PASS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::clone::Clone for D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    pub cpuDescriptor: D3D12_CPU_DESCRIPTOR_HANDLE,
    pub BeginningAccess: D3D12_RENDER_PASS_BEGINNING_ACCESS,
    pub EndingAccess: D3D12_RENDER_PASS_ENDING_ACCESS,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D12_RENDER_PASS_RENDER_TARGET_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D12_RENDER_PASS_RENDER_TARGET_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_RENDER_TARGET_DESC {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RENDER_PASS_TIER(pub i32);
pub const D3D12_RENDER_PASS_TIER_0: D3D12_RENDER_PASS_TIER = D3D12_RENDER_PASS_TIER(0i32);
pub const D3D12_RENDER_PASS_TIER_1: D3D12_RENDER_PASS_TIER = D3D12_RENDER_PASS_TIER(1i32);
pub const D3D12_RENDER_PASS_TIER_2: D3D12_RENDER_PASS_TIER = D3D12_RENDER_PASS_TIER(2i32);
impl ::std::convert::From<i32> for D3D12_RENDER_PASS_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_PASS_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_RENDER_TARGET_BLEND_DESC {
    pub BlendEnable: super::super::Foundation::BOOL,
    pub LogicOpEnable: super::super::Foundation::BOOL,
    pub SrcBlend: D3D12_BLEND,
    pub DestBlend: D3D12_BLEND,
    pub BlendOp: D3D12_BLEND_OP,
    pub SrcBlendAlpha: D3D12_BLEND,
    pub DestBlendAlpha: D3D12_BLEND,
    pub BlendOpAlpha: D3D12_BLEND_OP,
    pub LogicOp: D3D12_LOGIC_OP,
    pub RenderTargetWriteMask: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_RENDER_TARGET_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_RENDER_TARGET_BLEND_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_RENDER_TARGET_BLEND_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RENDER_TARGET_BLEND_DESC")
            .field("BlendEnable", &self.BlendEnable)
            .field("LogicOpEnable", &self.LogicOpEnable)
            .field("SrcBlend", &self.SrcBlend)
            .field("DestBlend", &self.DestBlend)
            .field("BlendOp", &self.BlendOp)
            .field("SrcBlendAlpha", &self.SrcBlendAlpha)
            .field("DestBlendAlpha", &self.DestBlendAlpha)
            .field("BlendOpAlpha", &self.BlendOpAlpha)
            .field("LogicOp", &self.LogicOp)
            .field("RenderTargetWriteMask", &self.RenderTargetWriteMask)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_RENDER_TARGET_BLEND_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.BlendEnable == other.BlendEnable && self.LogicOpEnable == other.LogicOpEnable && self.SrcBlend == other.SrcBlend && self.DestBlend == other.DestBlend && self.BlendOp == other.BlendOp && self.SrcBlendAlpha == other.SrcBlendAlpha && self.DestBlendAlpha == other.DestBlendAlpha && self.BlendOpAlpha == other.BlendOpAlpha && self.LogicOp == other.LogicOp && self.RenderTargetWriteMask == other.RenderTargetWriteMask
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_RENDER_TARGET_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_TARGET_BLEND_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RENDER_TARGET_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D12_RTV_DIMENSION,
    pub Anonymous: D3D12_RENDER_TARGET_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RENDER_TARGET_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RENDER_TARGET_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RENDER_TARGET_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RENDER_TARGET_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_TARGET_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_RENDER_TARGET_VIEW_DESC_0 {
    pub Buffer: D3D12_BUFFER_RTV,
    pub Texture1D: D3D12_TEX1D_RTV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_RTV,
    pub Texture2D: D3D12_TEX2D_RTV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_RTV,
    pub Texture2DMS: D3D12_TEX2DMS_RTV,
    pub Texture2DMSArray: D3D12_TEX2DMS_ARRAY_RTV,
    pub Texture3D: D3D12_TEX3D_RTV,
}
impl D3D12_RENDER_TARGET_VIEW_DESC_0 {}
impl ::std::default::Default for D3D12_RENDER_TARGET_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_RENDER_TARGET_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_RENDER_TARGET_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_RENDER_TARGET_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_REQ_BLEND_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D12_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP: u32 = 27u32;
pub const D3D12_REQ_CONSTANT_BUFFER_ELEMENT_COUNT: u32 = 4096u32;
pub const D3D12_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D12_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 = 32u32;
pub const D3D12_REQ_DRAW_VERTEX_COUNT_2_TO_EXP: u32 = 32u32;
pub const D3D12_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION: u32 = 16384u32;
pub const D3D12_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT: u32 = 1024u32;
pub const D3D12_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT: u32 = 4096u32;
pub const D3D12_REQ_MAXANISOTROPY: u32 = 16u32;
pub const D3D12_REQ_MIP_LEVELS: u32 = 15u32;
pub const D3D12_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES: u32 = 2048u32;
pub const D3D12_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D12_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH: u32 = 16384u32;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM: u32 = 128u32;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM: f32 = 0.25f32;
pub const D3D12_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM: u32 = 2048u32;
pub const D3D12_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP: u32 = 20u32;
pub const D3D12_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D12_REQ_SUBRESOURCES: u32 = 30720u32;
pub const D3D12_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION: u32 = 2048u32;
pub const D3D12_REQ_TEXTURE1D_U_DIMENSION: u32 = 16384u32;
pub const D3D12_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION: u32 = 2048u32;
pub const D3D12_REQ_TEXTURE2D_U_OR_V_DIMENSION: u32 = 16384u32;
pub const D3D12_REQ_TEXTURE3D_U_V_OR_W_DIMENSION: u32 = 2048u32;
pub const D3D12_REQ_TEXTURECUBE_DIMENSION: u32 = 16384u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESIDENCY_FLAGS(pub u32);
pub const D3D12_RESIDENCY_FLAG_NONE: D3D12_RESIDENCY_FLAGS = D3D12_RESIDENCY_FLAGS(0u32);
pub const D3D12_RESIDENCY_FLAG_DENY_OVERBUDGET: D3D12_RESIDENCY_FLAGS = D3D12_RESIDENCY_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_RESIDENCY_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESIDENCY_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RESIDENCY_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RESIDENCY_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RESIDENCY_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RESIDENCY_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RESIDENCY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESIDENCY_PRIORITY(pub i32);
pub const D3D12_RESIDENCY_PRIORITY_MINIMUM: D3D12_RESIDENCY_PRIORITY = D3D12_RESIDENCY_PRIORITY(671088640i32);
pub const D3D12_RESIDENCY_PRIORITY_LOW: D3D12_RESIDENCY_PRIORITY = D3D12_RESIDENCY_PRIORITY(1342177280i32);
pub const D3D12_RESIDENCY_PRIORITY_NORMAL: D3D12_RESIDENCY_PRIORITY = D3D12_RESIDENCY_PRIORITY(2013265920i32);
pub const D3D12_RESIDENCY_PRIORITY_HIGH: D3D12_RESIDENCY_PRIORITY = D3D12_RESIDENCY_PRIORITY(-1610547200i32);
pub const D3D12_RESIDENCY_PRIORITY_MAXIMUM: D3D12_RESIDENCY_PRIORITY = D3D12_RESIDENCY_PRIORITY(-939524096i32);
impl ::std::convert::From<i32> for D3D12_RESIDENCY_PRIORITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESIDENCY_PRIORITY {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL: u32 = 0u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOLVE_MODE(pub i32);
pub const D3D12_RESOLVE_MODE_DECOMPRESS: D3D12_RESOLVE_MODE = D3D12_RESOLVE_MODE(0i32);
pub const D3D12_RESOLVE_MODE_MIN: D3D12_RESOLVE_MODE = D3D12_RESOLVE_MODE(1i32);
pub const D3D12_RESOLVE_MODE_MAX: D3D12_RESOLVE_MODE = D3D12_RESOLVE_MODE(2i32);
pub const D3D12_RESOLVE_MODE_AVERAGE: D3D12_RESOLVE_MODE = D3D12_RESOLVE_MODE(3i32);
pub const D3D12_RESOLVE_MODE_ENCODE_SAMPLER_FEEDBACK: D3D12_RESOLVE_MODE = D3D12_RESOLVE_MODE(4i32);
pub const D3D12_RESOLVE_MODE_DECODE_SAMPLER_FEEDBACK: D3D12_RESOLVE_MODE = D3D12_RESOLVE_MODE(5i32);
impl ::std::convert::From<i32> for D3D12_RESOLVE_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOLVE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D3D12_RESOURCE_ALIASING_BARRIER {
    pub pResourceBefore: ::std::option::Option<ID3D12Resource>,
    pub pResourceAfter: ::std::option::Option<ID3D12Resource>,
}
impl D3D12_RESOURCE_ALIASING_BARRIER {}
impl ::std::default::Default for D3D12_RESOURCE_ALIASING_BARRIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RESOURCE_ALIASING_BARRIER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RESOURCE_ALIASING_BARRIER").field("pResourceBefore", &self.pResourceBefore).field("pResourceAfter", &self.pResourceAfter).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RESOURCE_ALIASING_BARRIER {
    fn eq(&self, other: &Self) -> bool {
        self.pResourceBefore == other.pResourceBefore && self.pResourceAfter == other.pResourceAfter
    }
}
impl ::std::cmp::Eq for D3D12_RESOURCE_ALIASING_BARRIER {}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_ALIASING_BARRIER {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RESOURCE_ALLOCATION_INFO {
    pub SizeInBytes: u64,
    pub Alignment: u64,
}
impl D3D12_RESOURCE_ALLOCATION_INFO {}
impl ::std::default::Default for D3D12_RESOURCE_ALLOCATION_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RESOURCE_ALLOCATION_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RESOURCE_ALLOCATION_INFO").field("SizeInBytes", &self.SizeInBytes).field("Alignment", &self.Alignment).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RESOURCE_ALLOCATION_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.SizeInBytes == other.SizeInBytes && self.Alignment == other.Alignment
    }
}
impl ::std::cmp::Eq for D3D12_RESOURCE_ALLOCATION_INFO {}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_ALLOCATION_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_RESOURCE_ALLOCATION_INFO1 {
    pub Offset: u64,
    pub Alignment: u64,
    pub SizeInBytes: u64,
}
impl D3D12_RESOURCE_ALLOCATION_INFO1 {}
impl ::std::default::Default for D3D12_RESOURCE_ALLOCATION_INFO1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RESOURCE_ALLOCATION_INFO1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RESOURCE_ALLOCATION_INFO1").field("Offset", &self.Offset).field("Alignment", &self.Alignment).field("SizeInBytes", &self.SizeInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RESOURCE_ALLOCATION_INFO1 {
    fn eq(&self, other: &Self) -> bool {
        self.Offset == other.Offset && self.Alignment == other.Alignment && self.SizeInBytes == other.SizeInBytes
    }
}
impl ::std::cmp::Eq for D3D12_RESOURCE_ALLOCATION_INFO1 {}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_ALLOCATION_INFO1 {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::clone::Clone for D3D12_RESOURCE_BARRIER {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
pub struct D3D12_RESOURCE_BARRIER {
    pub Type: D3D12_RESOURCE_BARRIER_TYPE,
    pub Flags: D3D12_RESOURCE_BARRIER_FLAGS,
    pub Anonymous: D3D12_RESOURCE_BARRIER_0,
}
impl D3D12_RESOURCE_BARRIER {}
impl ::std::default::Default for D3D12_RESOURCE_BARRIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_RESOURCE_BARRIER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_RESOURCE_BARRIER {}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_BARRIER {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
impl ::std::clone::Clone for D3D12_RESOURCE_BARRIER_0 {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
pub union D3D12_RESOURCE_BARRIER_0 {
    pub Transition: ::std::mem::ManuallyDrop<D3D12_RESOURCE_TRANSITION_BARRIER>,
    pub Aliasing: ::std::mem::ManuallyDrop<D3D12_RESOURCE_ALIASING_BARRIER>,
    pub UAV: ::std::mem::ManuallyDrop<D3D12_RESOURCE_UAV_BARRIER>,
}
impl D3D12_RESOURCE_BARRIER_0 {}
impl ::std::default::Default for D3D12_RESOURCE_BARRIER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_RESOURCE_BARRIER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_RESOURCE_BARRIER_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_BARRIER_0 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
pub const D3D12_RESOURCE_BARRIER_ALL_SUBRESOURCES: u32 = 4294967295u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOURCE_BARRIER_FLAGS(pub u32);
pub const D3D12_RESOURCE_BARRIER_FLAG_NONE: D3D12_RESOURCE_BARRIER_FLAGS = D3D12_RESOURCE_BARRIER_FLAGS(0u32);
pub const D3D12_RESOURCE_BARRIER_FLAG_BEGIN_ONLY: D3D12_RESOURCE_BARRIER_FLAGS = D3D12_RESOURCE_BARRIER_FLAGS(1u32);
pub const D3D12_RESOURCE_BARRIER_FLAG_END_ONLY: D3D12_RESOURCE_BARRIER_FLAGS = D3D12_RESOURCE_BARRIER_FLAGS(2u32);
impl ::std::convert::From<u32> for D3D12_RESOURCE_BARRIER_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_BARRIER_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RESOURCE_BARRIER_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RESOURCE_BARRIER_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RESOURCE_BARRIER_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RESOURCE_BARRIER_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RESOURCE_BARRIER_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOURCE_BARRIER_TYPE(pub i32);
pub const D3D12_RESOURCE_BARRIER_TYPE_TRANSITION: D3D12_RESOURCE_BARRIER_TYPE = D3D12_RESOURCE_BARRIER_TYPE(0i32);
pub const D3D12_RESOURCE_BARRIER_TYPE_ALIASING: D3D12_RESOURCE_BARRIER_TYPE = D3D12_RESOURCE_BARRIER_TYPE(1i32);
pub const D3D12_RESOURCE_BARRIER_TYPE_UAV: D3D12_RESOURCE_BARRIER_TYPE = D3D12_RESOURCE_BARRIER_TYPE(2i32);
impl ::std::convert::From<i32> for D3D12_RESOURCE_BARRIER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_BARRIER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOURCE_BINDING_TIER(pub i32);
pub const D3D12_RESOURCE_BINDING_TIER_1: D3D12_RESOURCE_BINDING_TIER = D3D12_RESOURCE_BINDING_TIER(1i32);
pub const D3D12_RESOURCE_BINDING_TIER_2: D3D12_RESOURCE_BINDING_TIER = D3D12_RESOURCE_BINDING_TIER(2i32);
pub const D3D12_RESOURCE_BINDING_TIER_3: D3D12_RESOURCE_BINDING_TIER = D3D12_RESOURCE_BINDING_TIER(3i32);
impl ::std::convert::From<i32> for D3D12_RESOURCE_BINDING_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_BINDING_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RESOURCE_DESC {
    pub Dimension: D3D12_RESOURCE_DIMENSION,
    pub Alignment: u64,
    pub Width: u64,
    pub Height: u32,
    pub DepthOrArraySize: u16,
    pub MipLevels: u16,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub SampleDesc: super::Dxgi::DXGI_SAMPLE_DESC,
    pub Layout: D3D12_TEXTURE_LAYOUT,
    pub Flags: D3D12_RESOURCE_FLAGS,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RESOURCE_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RESOURCE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_RESOURCE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RESOURCE_DESC")
            .field("Dimension", &self.Dimension)
            .field("Alignment", &self.Alignment)
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("DepthOrArraySize", &self.DepthOrArraySize)
            .field("MipLevels", &self.MipLevels)
            .field("Format", &self.Format)
            .field("SampleDesc", &self.SampleDesc)
            .field("Layout", &self.Layout)
            .field("Flags", &self.Flags)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RESOURCE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Dimension == other.Dimension && self.Alignment == other.Alignment && self.Width == other.Width && self.Height == other.Height && self.DepthOrArraySize == other.DepthOrArraySize && self.MipLevels == other.MipLevels && self.Format == other.Format && self.SampleDesc == other.SampleDesc && self.Layout == other.Layout && self.Flags == other.Flags
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RESOURCE_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RESOURCE_DESC1 {
    pub Dimension: D3D12_RESOURCE_DIMENSION,
    pub Alignment: u64,
    pub Width: u64,
    pub Height: u32,
    pub DepthOrArraySize: u16,
    pub MipLevels: u16,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub SampleDesc: super::Dxgi::DXGI_SAMPLE_DESC,
    pub Layout: D3D12_TEXTURE_LAYOUT,
    pub Flags: D3D12_RESOURCE_FLAGS,
    pub SamplerFeedbackMipRegion: D3D12_MIP_REGION,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RESOURCE_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RESOURCE_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_RESOURCE_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RESOURCE_DESC1")
            .field("Dimension", &self.Dimension)
            .field("Alignment", &self.Alignment)
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("DepthOrArraySize", &self.DepthOrArraySize)
            .field("MipLevels", &self.MipLevels)
            .field("Format", &self.Format)
            .field("SampleDesc", &self.SampleDesc)
            .field("Layout", &self.Layout)
            .field("Flags", &self.Flags)
            .field("SamplerFeedbackMipRegion", &self.SamplerFeedbackMipRegion)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RESOURCE_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.Dimension == other.Dimension && self.Alignment == other.Alignment && self.Width == other.Width && self.Height == other.Height && self.DepthOrArraySize == other.DepthOrArraySize && self.MipLevels == other.MipLevels && self.Format == other.Format && self.SampleDesc == other.SampleDesc && self.Layout == other.Layout && self.Flags == other.Flags && self.SamplerFeedbackMipRegion == other.SamplerFeedbackMipRegion
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RESOURCE_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOURCE_DIMENSION(pub i32);
pub const D3D12_RESOURCE_DIMENSION_UNKNOWN: D3D12_RESOURCE_DIMENSION = D3D12_RESOURCE_DIMENSION(0i32);
pub const D3D12_RESOURCE_DIMENSION_BUFFER: D3D12_RESOURCE_DIMENSION = D3D12_RESOURCE_DIMENSION(1i32);
pub const D3D12_RESOURCE_DIMENSION_TEXTURE1D: D3D12_RESOURCE_DIMENSION = D3D12_RESOURCE_DIMENSION(2i32);
pub const D3D12_RESOURCE_DIMENSION_TEXTURE2D: D3D12_RESOURCE_DIMENSION = D3D12_RESOURCE_DIMENSION(3i32);
pub const D3D12_RESOURCE_DIMENSION_TEXTURE3D: D3D12_RESOURCE_DIMENSION = D3D12_RESOURCE_DIMENSION(4i32);
impl ::std::convert::From<i32> for D3D12_RESOURCE_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOURCE_FLAGS(pub u32);
pub const D3D12_RESOURCE_FLAG_NONE: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(0u32);
pub const D3D12_RESOURCE_FLAG_ALLOW_RENDER_TARGET: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(1u32);
pub const D3D12_RESOURCE_FLAG_ALLOW_DEPTH_STENCIL: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(2u32);
pub const D3D12_RESOURCE_FLAG_ALLOW_UNORDERED_ACCESS: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(4u32);
pub const D3D12_RESOURCE_FLAG_DENY_SHADER_RESOURCE: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(8u32);
pub const D3D12_RESOURCE_FLAG_ALLOW_CROSS_ADAPTER: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(16u32);
pub const D3D12_RESOURCE_FLAG_ALLOW_SIMULTANEOUS_ACCESS: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(32u32);
pub const D3D12_RESOURCE_FLAG_VIDEO_DECODE_REFERENCE_ONLY: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(64u32);
pub const D3D12_RESOURCE_FLAG_VIDEO_ENCODE_REFERENCE_ONLY: D3D12_RESOURCE_FLAGS = D3D12_RESOURCE_FLAGS(128u32);
impl ::std::convert::From<u32> for D3D12_RESOURCE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RESOURCE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RESOURCE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RESOURCE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RESOURCE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RESOURCE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOURCE_HEAP_TIER(pub i32);
pub const D3D12_RESOURCE_HEAP_TIER_1: D3D12_RESOURCE_HEAP_TIER = D3D12_RESOURCE_HEAP_TIER(1i32);
pub const D3D12_RESOURCE_HEAP_TIER_2: D3D12_RESOURCE_HEAP_TIER = D3D12_RESOURCE_HEAP_TIER(2i32);
impl ::std::convert::From<i32> for D3D12_RESOURCE_HEAP_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_HEAP_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RESOURCE_STATES(pub u32);
pub const D3D12_RESOURCE_STATE_COMMON: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(0u32);
pub const D3D12_RESOURCE_STATE_VERTEX_AND_CONSTANT_BUFFER: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(1u32);
pub const D3D12_RESOURCE_STATE_INDEX_BUFFER: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(2u32);
pub const D3D12_RESOURCE_STATE_RENDER_TARGET: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(4u32);
pub const D3D12_RESOURCE_STATE_UNORDERED_ACCESS: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(8u32);
pub const D3D12_RESOURCE_STATE_DEPTH_WRITE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(16u32);
pub const D3D12_RESOURCE_STATE_DEPTH_READ: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(32u32);
pub const D3D12_RESOURCE_STATE_NON_PIXEL_SHADER_RESOURCE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(64u32);
pub const D3D12_RESOURCE_STATE_PIXEL_SHADER_RESOURCE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(128u32);
pub const D3D12_RESOURCE_STATE_STREAM_OUT: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(256u32);
pub const D3D12_RESOURCE_STATE_INDIRECT_ARGUMENT: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(512u32);
pub const D3D12_RESOURCE_STATE_COPY_DEST: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(1024u32);
pub const D3D12_RESOURCE_STATE_COPY_SOURCE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(2048u32);
pub const D3D12_RESOURCE_STATE_RESOLVE_DEST: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(4096u32);
pub const D3D12_RESOURCE_STATE_RESOLVE_SOURCE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(8192u32);
pub const D3D12_RESOURCE_STATE_RAYTRACING_ACCELERATION_STRUCTURE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(4194304u32);
pub const D3D12_RESOURCE_STATE_SHADING_RATE_SOURCE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(16777216u32);
pub const D3D12_RESOURCE_STATE_GENERIC_READ: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(2755u32);
pub const D3D12_RESOURCE_STATE_ALL_SHADER_RESOURCE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(192u32);
pub const D3D12_RESOURCE_STATE_PRESENT: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(0u32);
pub const D3D12_RESOURCE_STATE_PREDICATION: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(512u32);
pub const D3D12_RESOURCE_STATE_VIDEO_DECODE_READ: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(65536u32);
pub const D3D12_RESOURCE_STATE_VIDEO_DECODE_WRITE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(131072u32);
pub const D3D12_RESOURCE_STATE_VIDEO_PROCESS_READ: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(262144u32);
pub const D3D12_RESOURCE_STATE_VIDEO_PROCESS_WRITE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(524288u32);
pub const D3D12_RESOURCE_STATE_VIDEO_ENCODE_READ: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(2097152u32);
pub const D3D12_RESOURCE_STATE_VIDEO_ENCODE_WRITE: D3D12_RESOURCE_STATES = D3D12_RESOURCE_STATES(8388608u32);
impl ::std::convert::From<u32> for D3D12_RESOURCE_STATES {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_STATES {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_RESOURCE_STATES {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_RESOURCE_STATES {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_RESOURCE_STATES {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_RESOURCE_STATES {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_RESOURCE_STATES {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D3D12_RESOURCE_TRANSITION_BARRIER {
    pub pResource: ::std::option::Option<ID3D12Resource>,
    pub Subresource: u32,
    pub StateBefore: D3D12_RESOURCE_STATES,
    pub StateAfter: D3D12_RESOURCE_STATES,
}
impl D3D12_RESOURCE_TRANSITION_BARRIER {}
impl ::std::default::Default for D3D12_RESOURCE_TRANSITION_BARRIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RESOURCE_TRANSITION_BARRIER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RESOURCE_TRANSITION_BARRIER").field("pResource", &self.pResource).field("Subresource", &self.Subresource).field("StateBefore", &self.StateBefore).field("StateAfter", &self.StateAfter).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RESOURCE_TRANSITION_BARRIER {
    fn eq(&self, other: &Self) -> bool {
        self.pResource == other.pResource && self.Subresource == other.Subresource && self.StateBefore == other.StateBefore && self.StateAfter == other.StateAfter
    }
}
impl ::std::cmp::Eq for D3D12_RESOURCE_TRANSITION_BARRIER {}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_TRANSITION_BARRIER {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D3D12_RESOURCE_UAV_BARRIER {
    pub pResource: ::std::option::Option<ID3D12Resource>,
}
impl D3D12_RESOURCE_UAV_BARRIER {}
impl ::std::default::Default for D3D12_RESOURCE_UAV_BARRIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_RESOURCE_UAV_BARRIER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RESOURCE_UAV_BARRIER").field("pResource", &self.pResource).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_RESOURCE_UAV_BARRIER {
    fn eq(&self, other: &Self) -> bool {
        self.pResource == other.pResource
    }
}
impl ::std::cmp::Eq for D3D12_RESOURCE_UAV_BARRIER {}
unsafe impl ::windows::runtime::Abi for D3D12_RESOURCE_UAV_BARRIER {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RLDO_FLAGS(pub i32);
pub const D3D12_RLDO_NONE: D3D12_RLDO_FLAGS = D3D12_RLDO_FLAGS(0i32);
pub const D3D12_RLDO_SUMMARY: D3D12_RLDO_FLAGS = D3D12_RLDO_FLAGS(1i32);
pub const D3D12_RLDO_DETAIL: D3D12_RLDO_FLAGS = D3D12_RLDO_FLAGS(2i32);
pub const D3D12_RLDO_IGNORE_INTERNAL: D3D12_RLDO_FLAGS = D3D12_RLDO_FLAGS(4i32);
impl ::std::convert::From<i32> for D3D12_RLDO_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RLDO_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_CONSTANTS {
    pub ShaderRegister: u32,
    pub RegisterSpace: u32,
    pub Num32BitValues: u32,
}
impl D3D12_ROOT_CONSTANTS {}
impl ::std::default::Default for D3D12_ROOT_CONSTANTS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_CONSTANTS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_ROOT_CONSTANTS").field("ShaderRegister", &self.ShaderRegister).field("RegisterSpace", &self.RegisterSpace).field("Num32BitValues", &self.Num32BitValues).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_CONSTANTS {
    fn eq(&self, other: &Self) -> bool {
        self.ShaderRegister == other.ShaderRegister && self.RegisterSpace == other.RegisterSpace && self.Num32BitValues == other.Num32BitValues
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_CONSTANTS {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_CONSTANTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_DESCRIPTOR {
    pub ShaderRegister: u32,
    pub RegisterSpace: u32,
}
impl D3D12_ROOT_DESCRIPTOR {}
impl ::std::default::Default for D3D12_ROOT_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_ROOT_DESCRIPTOR").field("ShaderRegister", &self.ShaderRegister).field("RegisterSpace", &self.RegisterSpace).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.ShaderRegister == other.ShaderRegister && self.RegisterSpace == other.RegisterSpace
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_DESCRIPTOR {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_DESCRIPTOR {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_DESCRIPTOR1 {
    pub ShaderRegister: u32,
    pub RegisterSpace: u32,
    pub Flags: D3D12_ROOT_DESCRIPTOR_FLAGS,
}
impl D3D12_ROOT_DESCRIPTOR1 {}
impl ::std::default::Default for D3D12_ROOT_DESCRIPTOR1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_DESCRIPTOR1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_ROOT_DESCRIPTOR1").field("ShaderRegister", &self.ShaderRegister).field("RegisterSpace", &self.RegisterSpace).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_DESCRIPTOR1 {
    fn eq(&self, other: &Self) -> bool {
        self.ShaderRegister == other.ShaderRegister && self.RegisterSpace == other.RegisterSpace && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_DESCRIPTOR1 {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_DESCRIPTOR1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_ROOT_DESCRIPTOR_FLAGS(pub u32);
pub const D3D12_ROOT_DESCRIPTOR_FLAG_NONE: D3D12_ROOT_DESCRIPTOR_FLAGS = D3D12_ROOT_DESCRIPTOR_FLAGS(0u32);
pub const D3D12_ROOT_DESCRIPTOR_FLAG_DATA_VOLATILE: D3D12_ROOT_DESCRIPTOR_FLAGS = D3D12_ROOT_DESCRIPTOR_FLAGS(2u32);
pub const D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC_WHILE_SET_AT_EXECUTE: D3D12_ROOT_DESCRIPTOR_FLAGS = D3D12_ROOT_DESCRIPTOR_FLAGS(4u32);
pub const D3D12_ROOT_DESCRIPTOR_FLAG_DATA_STATIC: D3D12_ROOT_DESCRIPTOR_FLAGS = D3D12_ROOT_DESCRIPTOR_FLAGS(8u32);
impl ::std::convert::From<u32> for D3D12_ROOT_DESCRIPTOR_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_DESCRIPTOR_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_ROOT_DESCRIPTOR_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_ROOT_DESCRIPTOR_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_ROOT_DESCRIPTOR_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_ROOT_DESCRIPTOR_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_ROOT_DESCRIPTOR_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_DESCRIPTOR_TABLE {
    pub NumDescriptorRanges: u32,
    pub pDescriptorRanges: *mut D3D12_DESCRIPTOR_RANGE,
}
impl D3D12_ROOT_DESCRIPTOR_TABLE {}
impl ::std::default::Default for D3D12_ROOT_DESCRIPTOR_TABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_DESCRIPTOR_TABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_ROOT_DESCRIPTOR_TABLE").field("NumDescriptorRanges", &self.NumDescriptorRanges).field("pDescriptorRanges", &self.pDescriptorRanges).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_DESCRIPTOR_TABLE {
    fn eq(&self, other: &Self) -> bool {
        self.NumDescriptorRanges == other.NumDescriptorRanges && self.pDescriptorRanges == other.pDescriptorRanges
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_DESCRIPTOR_TABLE {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_DESCRIPTOR_TABLE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_DESCRIPTOR_TABLE1 {
    pub NumDescriptorRanges: u32,
    pub pDescriptorRanges: *mut D3D12_DESCRIPTOR_RANGE1,
}
impl D3D12_ROOT_DESCRIPTOR_TABLE1 {}
impl ::std::default::Default for D3D12_ROOT_DESCRIPTOR_TABLE1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_DESCRIPTOR_TABLE1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_ROOT_DESCRIPTOR_TABLE1").field("NumDescriptorRanges", &self.NumDescriptorRanges).field("pDescriptorRanges", &self.pDescriptorRanges).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_DESCRIPTOR_TABLE1 {
    fn eq(&self, other: &Self) -> bool {
        self.NumDescriptorRanges == other.NumDescriptorRanges && self.pDescriptorRanges == other.pDescriptorRanges
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_DESCRIPTOR_TABLE1 {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_DESCRIPTOR_TABLE1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_PARAMETER {
    pub ParameterType: D3D12_ROOT_PARAMETER_TYPE,
    pub Anonymous: D3D12_ROOT_PARAMETER_0,
    pub ShaderVisibility: D3D12_SHADER_VISIBILITY,
}
impl D3D12_ROOT_PARAMETER {}
impl ::std::default::Default for D3D12_ROOT_PARAMETER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_PARAMETER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_PARAMETER {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_PARAMETER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_ROOT_PARAMETER_0 {
    pub DescriptorTable: D3D12_ROOT_DESCRIPTOR_TABLE,
    pub Constants: D3D12_ROOT_CONSTANTS,
    pub Descriptor: D3D12_ROOT_DESCRIPTOR,
}
impl D3D12_ROOT_PARAMETER_0 {}
impl ::std::default::Default for D3D12_ROOT_PARAMETER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_PARAMETER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_PARAMETER_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_PARAMETER_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_PARAMETER1 {
    pub ParameterType: D3D12_ROOT_PARAMETER_TYPE,
    pub Anonymous: D3D12_ROOT_PARAMETER1_0,
    pub ShaderVisibility: D3D12_SHADER_VISIBILITY,
}
impl D3D12_ROOT_PARAMETER1 {}
impl ::std::default::Default for D3D12_ROOT_PARAMETER1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_PARAMETER1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_PARAMETER1 {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_PARAMETER1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_ROOT_PARAMETER1_0 {
    pub DescriptorTable: D3D12_ROOT_DESCRIPTOR_TABLE1,
    pub Constants: D3D12_ROOT_CONSTANTS,
    pub Descriptor: D3D12_ROOT_DESCRIPTOR1,
}
impl D3D12_ROOT_PARAMETER1_0 {}
impl ::std::default::Default for D3D12_ROOT_PARAMETER1_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_PARAMETER1_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_PARAMETER1_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_PARAMETER1_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_ROOT_PARAMETER_TYPE(pub i32);
pub const D3D12_ROOT_PARAMETER_TYPE_DESCRIPTOR_TABLE: D3D12_ROOT_PARAMETER_TYPE = D3D12_ROOT_PARAMETER_TYPE(0i32);
pub const D3D12_ROOT_PARAMETER_TYPE_32BIT_CONSTANTS: D3D12_ROOT_PARAMETER_TYPE = D3D12_ROOT_PARAMETER_TYPE(1i32);
pub const D3D12_ROOT_PARAMETER_TYPE_CBV: D3D12_ROOT_PARAMETER_TYPE = D3D12_ROOT_PARAMETER_TYPE(2i32);
pub const D3D12_ROOT_PARAMETER_TYPE_SRV: D3D12_ROOT_PARAMETER_TYPE = D3D12_ROOT_PARAMETER_TYPE(3i32);
pub const D3D12_ROOT_PARAMETER_TYPE_UAV: D3D12_ROOT_PARAMETER_TYPE = D3D12_ROOT_PARAMETER_TYPE(4i32);
impl ::std::convert::From<i32> for D3D12_ROOT_PARAMETER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_PARAMETER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_SIGNATURE_DESC {
    pub NumParameters: u32,
    pub pParameters: *mut D3D12_ROOT_PARAMETER,
    pub NumStaticSamplers: u32,
    pub pStaticSamplers: *mut D3D12_STATIC_SAMPLER_DESC,
    pub Flags: D3D12_ROOT_SIGNATURE_FLAGS,
}
impl D3D12_ROOT_SIGNATURE_DESC {}
impl ::std::default::Default for D3D12_ROOT_SIGNATURE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_SIGNATURE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_ROOT_SIGNATURE_DESC").field("NumParameters", &self.NumParameters).field("pParameters", &self.pParameters).field("NumStaticSamplers", &self.NumStaticSamplers).field("pStaticSamplers", &self.pStaticSamplers).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_SIGNATURE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.NumParameters == other.NumParameters && self.pParameters == other.pParameters && self.NumStaticSamplers == other.NumStaticSamplers && self.pStaticSamplers == other.pStaticSamplers && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_SIGNATURE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_SIGNATURE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_ROOT_SIGNATURE_DESC1 {
    pub NumParameters: u32,
    pub pParameters: *mut D3D12_ROOT_PARAMETER1,
    pub NumStaticSamplers: u32,
    pub pStaticSamplers: *mut D3D12_STATIC_SAMPLER_DESC,
    pub Flags: D3D12_ROOT_SIGNATURE_FLAGS,
}
impl D3D12_ROOT_SIGNATURE_DESC1 {}
impl ::std::default::Default for D3D12_ROOT_SIGNATURE_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_ROOT_SIGNATURE_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_ROOT_SIGNATURE_DESC1").field("NumParameters", &self.NumParameters).field("pParameters", &self.pParameters).field("NumStaticSamplers", &self.NumStaticSamplers).field("pStaticSamplers", &self.pStaticSamplers).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_ROOT_SIGNATURE_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.NumParameters == other.NumParameters && self.pParameters == other.pParameters && self.NumStaticSamplers == other.NumStaticSamplers && self.pStaticSamplers == other.pStaticSamplers && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_ROOT_SIGNATURE_DESC1 {}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_SIGNATURE_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_ROOT_SIGNATURE_FLAGS(pub u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_NONE: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(0u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_ALLOW_INPUT_ASSEMBLER_INPUT_LAYOUT: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(1u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_DENY_VERTEX_SHADER_ROOT_ACCESS: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(2u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_DENY_HULL_SHADER_ROOT_ACCESS: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(4u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_DENY_DOMAIN_SHADER_ROOT_ACCESS: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(8u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_DENY_GEOMETRY_SHADER_ROOT_ACCESS: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(16u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_DENY_PIXEL_SHADER_ROOT_ACCESS: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(32u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_ALLOW_STREAM_OUTPUT: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(64u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_LOCAL_ROOT_SIGNATURE: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(128u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_DENY_AMPLIFICATION_SHADER_ROOT_ACCESS: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(256u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_DENY_MESH_SHADER_ROOT_ACCESS: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(512u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_CBV_SRV_UAV_HEAP_DIRECTLY_INDEXED: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(1024u32);
pub const D3D12_ROOT_SIGNATURE_FLAG_SAMPLER_HEAP_DIRECTLY_INDEXED: D3D12_ROOT_SIGNATURE_FLAGS = D3D12_ROOT_SIGNATURE_FLAGS(2048u32);
impl ::std::convert::From<u32> for D3D12_ROOT_SIGNATURE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_ROOT_SIGNATURE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_ROOT_SIGNATURE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_ROOT_SIGNATURE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_ROOT_SIGNATURE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_ROOT_SIGNATURE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_ROOT_SIGNATURE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D3D12_RS_SET_SHADING_RATE_COMBINER_COUNT: u32 = 2u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_RTV_DIMENSION(pub i32);
pub const D3D12_RTV_DIMENSION_UNKNOWN: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(0i32);
pub const D3D12_RTV_DIMENSION_BUFFER: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(1i32);
pub const D3D12_RTV_DIMENSION_TEXTURE1D: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(2i32);
pub const D3D12_RTV_DIMENSION_TEXTURE1DARRAY: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(3i32);
pub const D3D12_RTV_DIMENSION_TEXTURE2D: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(4i32);
pub const D3D12_RTV_DIMENSION_TEXTURE2DARRAY: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(5i32);
pub const D3D12_RTV_DIMENSION_TEXTURE2DMS: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(6i32);
pub const D3D12_RTV_DIMENSION_TEXTURE2DMSARRAY: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(7i32);
pub const D3D12_RTV_DIMENSION_TEXTURE3D: D3D12_RTV_DIMENSION = D3D12_RTV_DIMENSION(8i32);
impl ::std::convert::From<i32> for D3D12_RTV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_RTV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_RT_FORMAT_ARRAY {
    pub RTFormats: [super::Dxgi::DXGI_FORMAT; 8],
    pub NumRenderTargets: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_RT_FORMAT_ARRAY {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_RT_FORMAT_ARRAY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_RT_FORMAT_ARRAY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_RT_FORMAT_ARRAY").field("RTFormats", &self.RTFormats).field("NumRenderTargets", &self.NumRenderTargets).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_RT_FORMAT_ARRAY {
    fn eq(&self, other: &Self) -> bool {
        self.RTFormats == other.RTFormats && self.NumRenderTargets == other.NumRenderTargets
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_RT_FORMAT_ARRAY {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_RT_FORMAT_ARRAY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SAMPLER_DESC {
    pub Filter: D3D12_FILTER,
    pub AddressU: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressV: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressW: D3D12_TEXTURE_ADDRESS_MODE,
    pub MipLODBias: f32,
    pub MaxAnisotropy: u32,
    pub ComparisonFunc: D3D12_COMPARISON_FUNC,
    pub BorderColor: [f32; 4],
    pub MinLOD: f32,
    pub MaxLOD: f32,
}
impl D3D12_SAMPLER_DESC {}
impl ::std::default::Default for D3D12_SAMPLER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SAMPLER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SAMPLER_DESC")
            .field("Filter", &self.Filter)
            .field("AddressU", &self.AddressU)
            .field("AddressV", &self.AddressV)
            .field("AddressW", &self.AddressW)
            .field("MipLODBias", &self.MipLODBias)
            .field("MaxAnisotropy", &self.MaxAnisotropy)
            .field("ComparisonFunc", &self.ComparisonFunc)
            .field("BorderColor", &self.BorderColor)
            .field("MinLOD", &self.MinLOD)
            .field("MaxLOD", &self.MaxLOD)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SAMPLER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Filter == other.Filter && self.AddressU == other.AddressU && self.AddressV == other.AddressV && self.AddressW == other.AddressW && self.MipLODBias == other.MipLODBias && self.MaxAnisotropy == other.MaxAnisotropy && self.ComparisonFunc == other.ComparisonFunc && self.BorderColor == other.BorderColor && self.MinLOD == other.MinLOD && self.MaxLOD == other.MaxLOD
    }
}
impl ::std::cmp::Eq for D3D12_SAMPLER_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_SAMPLER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SAMPLER_FEEDBACK_TIER(pub i32);
pub const D3D12_SAMPLER_FEEDBACK_TIER_NOT_SUPPORTED: D3D12_SAMPLER_FEEDBACK_TIER = D3D12_SAMPLER_FEEDBACK_TIER(0i32);
pub const D3D12_SAMPLER_FEEDBACK_TIER_0_9: D3D12_SAMPLER_FEEDBACK_TIER = D3D12_SAMPLER_FEEDBACK_TIER(90i32);
pub const D3D12_SAMPLER_FEEDBACK_TIER_1_0: D3D12_SAMPLER_FEEDBACK_TIER = D3D12_SAMPLER_FEEDBACK_TIER(100i32);
impl ::std::convert::From<i32> for D3D12_SAMPLER_FEEDBACK_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SAMPLER_FEEDBACK_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SAMPLE_POSITION {
    pub X: i8,
    pub Y: i8,
}
impl D3D12_SAMPLE_POSITION {}
impl ::std::default::Default for D3D12_SAMPLE_POSITION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SAMPLE_POSITION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SAMPLE_POSITION").field("X", &self.X).field("Y", &self.Y).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SAMPLE_POSITION {
    fn eq(&self, other: &Self) -> bool {
        self.X == other.X && self.Y == other.Y
    }
}
impl ::std::cmp::Eq for D3D12_SAMPLE_POSITION {}
unsafe impl ::windows::runtime::Abi for D3D12_SAMPLE_POSITION {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SDK_VERSION: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {
    pub DriverOpaqueGUID: ::windows::runtime::GUID,
    pub DriverOpaqueVersioningData: [u8; 16],
}
impl D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {}
impl ::std::default::Default for D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER").field("DriverOpaqueGUID", &self.DriverOpaqueGUID).field("DriverOpaqueVersioningData", &self.DriverOpaqueVersioningData).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {
    fn eq(&self, other: &Self) -> bool {
        self.DriverOpaqueGUID == other.DriverOpaqueGUID && self.DriverOpaqueVersioningData == other.DriverOpaqueVersioningData
    }
}
impl ::std::cmp::Eq for D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {}
unsafe impl ::windows::runtime::Abi for D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SERIALIZED_DATA_TYPE(pub i32);
pub const D3D12_SERIALIZED_DATA_RAYTRACING_ACCELERATION_STRUCTURE: D3D12_SERIALIZED_DATA_TYPE = D3D12_SERIALIZED_DATA_TYPE(0i32);
impl ::std::convert::From<i32> for D3D12_SERIALIZED_DATA_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SERIALIZED_DATA_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {
    pub DriverMatchingIdentifier: D3D12_SERIALIZED_DATA_DRIVER_MATCHING_IDENTIFIER,
    pub SerializedSizeInBytesIncludingHeader: u64,
    pub DeserializedSizeInBytes: u64,
    pub NumBottomLevelAccelerationStructurePointersAfterHeader: u64,
}
impl D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {}
impl ::std::default::Default for D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER")
            .field("DriverMatchingIdentifier", &self.DriverMatchingIdentifier)
            .field("SerializedSizeInBytesIncludingHeader", &self.SerializedSizeInBytesIncludingHeader)
            .field("DeserializedSizeInBytes", &self.DeserializedSizeInBytes)
            .field("NumBottomLevelAccelerationStructurePointersAfterHeader", &self.NumBottomLevelAccelerationStructurePointersAfterHeader)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.DriverMatchingIdentifier == other.DriverMatchingIdentifier && self.SerializedSizeInBytesIncludingHeader == other.SerializedSizeInBytesIncludingHeader && self.DeserializedSizeInBytes == other.DeserializedSizeInBytes && self.NumBottomLevelAccelerationStructurePointersAfterHeader == other.NumBottomLevelAccelerationStructurePointersAfterHeader
    }
}
impl ::std::cmp::Eq for D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {}
unsafe impl ::windows::runtime::Abi for D3D12_SERIALIZED_RAYTRACING_ACCELERATION_STRUCTURE_HEADER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
pub struct D3D12_SHADER_BUFFER_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub Type: super::Direct3D11::D3D_CBUFFER_TYPE,
    pub Variables: u32,
    pub Size: u32,
    pub uFlags: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl D3D12_SHADER_BUFFER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::default::Default for D3D12_SHADER_BUFFER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::fmt::Debug for D3D12_SHADER_BUFFER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SHADER_BUFFER_DESC").field("Name", &self.Name).field("Type", &self.Type).field("Variables", &self.Variables).field("Size", &self.Size).field("uFlags", &self.uFlags).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::PartialEq for D3D12_SHADER_BUFFER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.Type == other.Type && self.Variables == other.Variables && self.Size == other.Size && self.uFlags == other.uFlags
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::Eq for D3D12_SHADER_BUFFER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_BUFFER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SHADER_BYTECODE {
    pub pShaderBytecode: *mut ::std::ffi::c_void,
    pub BytecodeLength: usize,
}
impl D3D12_SHADER_BYTECODE {}
impl ::std::default::Default for D3D12_SHADER_BYTECODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SHADER_BYTECODE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SHADER_BYTECODE").field("pShaderBytecode", &self.pShaderBytecode).field("BytecodeLength", &self.BytecodeLength).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SHADER_BYTECODE {
    fn eq(&self, other: &Self) -> bool {
        self.pShaderBytecode == other.pShaderBytecode && self.BytecodeLength == other.BytecodeLength
    }
}
impl ::std::cmp::Eq for D3D12_SHADER_BYTECODE {}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_BYTECODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_CACHE_CONTROL_FLAGS(pub u32);
pub const D3D12_SHADER_CACHE_CONTROL_FLAG_DISABLE: D3D12_SHADER_CACHE_CONTROL_FLAGS = D3D12_SHADER_CACHE_CONTROL_FLAGS(1u32);
pub const D3D12_SHADER_CACHE_CONTROL_FLAG_ENABLE: D3D12_SHADER_CACHE_CONTROL_FLAGS = D3D12_SHADER_CACHE_CONTROL_FLAGS(2u32);
pub const D3D12_SHADER_CACHE_CONTROL_FLAG_CLEAR: D3D12_SHADER_CACHE_CONTROL_FLAGS = D3D12_SHADER_CACHE_CONTROL_FLAGS(4u32);
impl ::std::convert::From<u32> for D3D12_SHADER_CACHE_CONTROL_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_CACHE_CONTROL_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_SHADER_CACHE_CONTROL_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_SHADER_CACHE_CONTROL_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_SHADER_CACHE_CONTROL_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_SHADER_CACHE_CONTROL_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_SHADER_CACHE_CONTROL_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_CACHE_FLAGS(pub u32);
pub const D3D12_SHADER_CACHE_FLAG_NONE: D3D12_SHADER_CACHE_FLAGS = D3D12_SHADER_CACHE_FLAGS(0u32);
pub const D3D12_SHADER_CACHE_FLAG_DRIVER_VERSIONED: D3D12_SHADER_CACHE_FLAGS = D3D12_SHADER_CACHE_FLAGS(1u32);
pub const D3D12_SHADER_CACHE_FLAG_USE_WORKING_DIR: D3D12_SHADER_CACHE_FLAGS = D3D12_SHADER_CACHE_FLAGS(2u32);
impl ::std::convert::From<u32> for D3D12_SHADER_CACHE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_CACHE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_SHADER_CACHE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_SHADER_CACHE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_SHADER_CACHE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_SHADER_CACHE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_SHADER_CACHE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_CACHE_KIND_FLAGS(pub u32);
pub const D3D12_SHADER_CACHE_KIND_FLAG_IMPLICIT_D3D_CACHE_FOR_DRIVER: D3D12_SHADER_CACHE_KIND_FLAGS = D3D12_SHADER_CACHE_KIND_FLAGS(1u32);
pub const D3D12_SHADER_CACHE_KIND_FLAG_IMPLICIT_D3D_CONVERSIONS: D3D12_SHADER_CACHE_KIND_FLAGS = D3D12_SHADER_CACHE_KIND_FLAGS(2u32);
pub const D3D12_SHADER_CACHE_KIND_FLAG_IMPLICIT_DRIVER_MANAGED: D3D12_SHADER_CACHE_KIND_FLAGS = D3D12_SHADER_CACHE_KIND_FLAGS(4u32);
pub const D3D12_SHADER_CACHE_KIND_FLAG_APPLICATION_MANAGED: D3D12_SHADER_CACHE_KIND_FLAGS = D3D12_SHADER_CACHE_KIND_FLAGS(8u32);
impl ::std::convert::From<u32> for D3D12_SHADER_CACHE_KIND_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_CACHE_KIND_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_SHADER_CACHE_KIND_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_SHADER_CACHE_KIND_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_SHADER_CACHE_KIND_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_SHADER_CACHE_KIND_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_SHADER_CACHE_KIND_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_CACHE_MODE(pub i32);
pub const D3D12_SHADER_CACHE_MODE_MEMORY: D3D12_SHADER_CACHE_MODE = D3D12_SHADER_CACHE_MODE(0i32);
pub const D3D12_SHADER_CACHE_MODE_DISK: D3D12_SHADER_CACHE_MODE = D3D12_SHADER_CACHE_MODE(1i32);
impl ::std::convert::From<i32> for D3D12_SHADER_CACHE_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_CACHE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SHADER_CACHE_SESSION_DESC {
    pub Identifier: ::windows::runtime::GUID,
    pub Mode: D3D12_SHADER_CACHE_MODE,
    pub Flags: D3D12_SHADER_CACHE_FLAGS,
    pub MaximumInMemoryCacheSizeBytes: u32,
    pub MaximumInMemoryCacheEntries: u32,
    pub MaximumValueFileSizeBytes: u32,
    pub Version: u64,
}
impl D3D12_SHADER_CACHE_SESSION_DESC {}
impl ::std::default::Default for D3D12_SHADER_CACHE_SESSION_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SHADER_CACHE_SESSION_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SHADER_CACHE_SESSION_DESC")
            .field("Identifier", &self.Identifier)
            .field("Mode", &self.Mode)
            .field("Flags", &self.Flags)
            .field("MaximumInMemoryCacheSizeBytes", &self.MaximumInMemoryCacheSizeBytes)
            .field("MaximumInMemoryCacheEntries", &self.MaximumInMemoryCacheEntries)
            .field("MaximumValueFileSizeBytes", &self.MaximumValueFileSizeBytes)
            .field("Version", &self.Version)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SHADER_CACHE_SESSION_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Identifier == other.Identifier && self.Mode == other.Mode && self.Flags == other.Flags && self.MaximumInMemoryCacheSizeBytes == other.MaximumInMemoryCacheSizeBytes && self.MaximumInMemoryCacheEntries == other.MaximumInMemoryCacheEntries && self.MaximumValueFileSizeBytes == other.MaximumValueFileSizeBytes && self.Version == other.Version
    }
}
impl ::std::cmp::Eq for D3D12_SHADER_CACHE_SESSION_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_CACHE_SESSION_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_CACHE_SUPPORT_FLAGS(pub u32);
pub const D3D12_SHADER_CACHE_SUPPORT_NONE: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(0u32);
pub const D3D12_SHADER_CACHE_SUPPORT_SINGLE_PSO: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(1u32);
pub const D3D12_SHADER_CACHE_SUPPORT_LIBRARY: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(2u32);
pub const D3D12_SHADER_CACHE_SUPPORT_AUTOMATIC_INPROC_CACHE: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(4u32);
pub const D3D12_SHADER_CACHE_SUPPORT_AUTOMATIC_DISK_CACHE: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(8u32);
pub const D3D12_SHADER_CACHE_SUPPORT_DRIVER_MANAGED_CACHE: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(16u32);
pub const D3D12_SHADER_CACHE_SUPPORT_SHADER_CONTROL_CLEAR: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(32u32);
pub const D3D12_SHADER_CACHE_SUPPORT_SHADER_SESSION_DELETE: D3D12_SHADER_CACHE_SUPPORT_FLAGS = D3D12_SHADER_CACHE_SUPPORT_FLAGS(64u32);
impl ::std::convert::From<u32> for D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_SHADER_CACHE_SUPPORT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_COMPONENT_MAPPING(pub i32);
pub const D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_0: D3D12_SHADER_COMPONENT_MAPPING = D3D12_SHADER_COMPONENT_MAPPING(0i32);
pub const D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_1: D3D12_SHADER_COMPONENT_MAPPING = D3D12_SHADER_COMPONENT_MAPPING(1i32);
pub const D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_2: D3D12_SHADER_COMPONENT_MAPPING = D3D12_SHADER_COMPONENT_MAPPING(2i32);
pub const D3D12_SHADER_COMPONENT_MAPPING_FROM_MEMORY_COMPONENT_3: D3D12_SHADER_COMPONENT_MAPPING = D3D12_SHADER_COMPONENT_MAPPING(3i32);
pub const D3D12_SHADER_COMPONENT_MAPPING_FORCE_VALUE_0: D3D12_SHADER_COMPONENT_MAPPING = D3D12_SHADER_COMPONENT_MAPPING(4i32);
pub const D3D12_SHADER_COMPONENT_MAPPING_FORCE_VALUE_1: D3D12_SHADER_COMPONENT_MAPPING = D3D12_SHADER_COMPONENT_MAPPING(5i32);
impl ::std::convert::From<i32> for D3D12_SHADER_COMPONENT_MAPPING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_COMPONENT_MAPPING {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SHADER_COMPONENT_MAPPING_ALWAYS_SET_BIT_AVOIDING_ZEROMEM_MISTAKES: u32 = 4096u32;
pub const D3D12_SHADER_COMPONENT_MAPPING_MASK: u32 = 7u32;
pub const D3D12_SHADER_COMPONENT_MAPPING_SHIFT: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
pub struct D3D12_SHADER_DESC {
    pub Version: u32,
    pub Creator: super::super::Foundation::PSTR,
    pub Flags: u32,
    pub ConstantBuffers: u32,
    pub BoundResources: u32,
    pub InputParameters: u32,
    pub OutputParameters: u32,
    pub InstructionCount: u32,
    pub TempRegisterCount: u32,
    pub TempArrayCount: u32,
    pub DefCount: u32,
    pub DclCount: u32,
    pub TextureNormalInstructions: u32,
    pub TextureLoadInstructions: u32,
    pub TextureCompInstructions: u32,
    pub TextureBiasInstructions: u32,
    pub TextureGradientInstructions: u32,
    pub FloatInstructionCount: u32,
    pub IntInstructionCount: u32,
    pub UintInstructionCount: u32,
    pub StaticFlowControlCount: u32,
    pub DynamicFlowControlCount: u32,
    pub MacroInstructionCount: u32,
    pub ArrayInstructionCount: u32,
    pub CutInstructionCount: u32,
    pub EmitInstructionCount: u32,
    pub GSOutputTopology: super::Direct3D11::D3D_PRIMITIVE_TOPOLOGY,
    pub GSMaxOutputVertexCount: u32,
    pub InputPrimitive: super::Direct3D11::D3D_PRIMITIVE,
    pub PatchConstantParameters: u32,
    pub cGSInstanceCount: u32,
    pub cControlPoints: u32,
    pub HSOutputPrimitive: super::Direct3D11::D3D_TESSELLATOR_OUTPUT_PRIMITIVE,
    pub HSPartitioning: super::Direct3D11::D3D_TESSELLATOR_PARTITIONING,
    pub TessellatorDomain: super::Direct3D11::D3D_TESSELLATOR_DOMAIN,
    pub cBarrierInstructions: u32,
    pub cInterlockedInstructions: u32,
    pub cTextureStoreInstructions: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl D3D12_SHADER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::default::Default for D3D12_SHADER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::fmt::Debug for D3D12_SHADER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SHADER_DESC")
            .field("Version", &self.Version)
            .field("Creator", &self.Creator)
            .field("Flags", &self.Flags)
            .field("ConstantBuffers", &self.ConstantBuffers)
            .field("BoundResources", &self.BoundResources)
            .field("InputParameters", &self.InputParameters)
            .field("OutputParameters", &self.OutputParameters)
            .field("InstructionCount", &self.InstructionCount)
            .field("TempRegisterCount", &self.TempRegisterCount)
            .field("TempArrayCount", &self.TempArrayCount)
            .field("DefCount", &self.DefCount)
            .field("DclCount", &self.DclCount)
            .field("TextureNormalInstructions", &self.TextureNormalInstructions)
            .field("TextureLoadInstructions", &self.TextureLoadInstructions)
            .field("TextureCompInstructions", &self.TextureCompInstructions)
            .field("TextureBiasInstructions", &self.TextureBiasInstructions)
            .field("TextureGradientInstructions", &self.TextureGradientInstructions)
            .field("FloatInstructionCount", &self.FloatInstructionCount)
            .field("IntInstructionCount", &self.IntInstructionCount)
            .field("UintInstructionCount", &self.UintInstructionCount)
            .field("StaticFlowControlCount", &self.StaticFlowControlCount)
            .field("DynamicFlowControlCount", &self.DynamicFlowControlCount)
            .field("MacroInstructionCount", &self.MacroInstructionCount)
            .field("ArrayInstructionCount", &self.ArrayInstructionCount)
            .field("CutInstructionCount", &self.CutInstructionCount)
            .field("EmitInstructionCount", &self.EmitInstructionCount)
            .field("GSOutputTopology", &self.GSOutputTopology)
            .field("GSMaxOutputVertexCount", &self.GSMaxOutputVertexCount)
            .field("InputPrimitive", &self.InputPrimitive)
            .field("PatchConstantParameters", &self.PatchConstantParameters)
            .field("cGSInstanceCount", &self.cGSInstanceCount)
            .field("cControlPoints", &self.cControlPoints)
            .field("HSOutputPrimitive", &self.HSOutputPrimitive)
            .field("HSPartitioning", &self.HSPartitioning)
            .field("TessellatorDomain", &self.TessellatorDomain)
            .field("cBarrierInstructions", &self.cBarrierInstructions)
            .field("cInterlockedInstructions", &self.cInterlockedInstructions)
            .field("cTextureStoreInstructions", &self.cTextureStoreInstructions)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::PartialEq for D3D12_SHADER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version
            && self.Creator == other.Creator
            && self.Flags == other.Flags
            && self.ConstantBuffers == other.ConstantBuffers
            && self.BoundResources == other.BoundResources
            && self.InputParameters == other.InputParameters
            && self.OutputParameters == other.OutputParameters
            && self.InstructionCount == other.InstructionCount
            && self.TempRegisterCount == other.TempRegisterCount
            && self.TempArrayCount == other.TempArrayCount
            && self.DefCount == other.DefCount
            && self.DclCount == other.DclCount
            && self.TextureNormalInstructions == other.TextureNormalInstructions
            && self.TextureLoadInstructions == other.TextureLoadInstructions
            && self.TextureCompInstructions == other.TextureCompInstructions
            && self.TextureBiasInstructions == other.TextureBiasInstructions
            && self.TextureGradientInstructions == other.TextureGradientInstructions
            && self.FloatInstructionCount == other.FloatInstructionCount
            && self.IntInstructionCount == other.IntInstructionCount
            && self.UintInstructionCount == other.UintInstructionCount
            && self.StaticFlowControlCount == other.StaticFlowControlCount
            && self.DynamicFlowControlCount == other.DynamicFlowControlCount
            && self.MacroInstructionCount == other.MacroInstructionCount
            && self.ArrayInstructionCount == other.ArrayInstructionCount
            && self.CutInstructionCount == other.CutInstructionCount
            && self.EmitInstructionCount == other.EmitInstructionCount
            && self.GSOutputTopology == other.GSOutputTopology
            && self.GSMaxOutputVertexCount == other.GSMaxOutputVertexCount
            && self.InputPrimitive == other.InputPrimitive
            && self.PatchConstantParameters == other.PatchConstantParameters
            && self.cGSInstanceCount == other.cGSInstanceCount
            && self.cControlPoints == other.cControlPoints
            && self.HSOutputPrimitive == other.HSOutputPrimitive
            && self.HSPartitioning == other.HSPartitioning
            && self.TessellatorDomain == other.TessellatorDomain
            && self.cBarrierInstructions == other.cBarrierInstructions
            && self.cInterlockedInstructions == other.cInterlockedInstructions
            && self.cTextureStoreInstructions == other.cTextureStoreInstructions
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::Eq for D3D12_SHADER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SHADER_IDENTIFIER_SIZE_IN_BYTES: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
pub struct D3D12_SHADER_INPUT_BIND_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub Type: super::Direct3D11::D3D_SHADER_INPUT_TYPE,
    pub BindPoint: u32,
    pub BindCount: u32,
    pub uFlags: u32,
    pub ReturnType: super::Direct3D11::D3D_RESOURCE_RETURN_TYPE,
    pub Dimension: super::Direct3D11::D3D_SRV_DIMENSION,
    pub NumSamples: u32,
    pub Space: u32,
    pub uID: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl D3D12_SHADER_INPUT_BIND_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::default::Default for D3D12_SHADER_INPUT_BIND_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::fmt::Debug for D3D12_SHADER_INPUT_BIND_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SHADER_INPUT_BIND_DESC")
            .field("Name", &self.Name)
            .field("Type", &self.Type)
            .field("BindPoint", &self.BindPoint)
            .field("BindCount", &self.BindCount)
            .field("uFlags", &self.uFlags)
            .field("ReturnType", &self.ReturnType)
            .field("Dimension", &self.Dimension)
            .field("NumSamples", &self.NumSamples)
            .field("Space", &self.Space)
            .field("uID", &self.uID)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::PartialEq for D3D12_SHADER_INPUT_BIND_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.Type == other.Type && self.BindPoint == other.BindPoint && self.BindCount == other.BindCount && self.uFlags == other.uFlags && self.ReturnType == other.ReturnType && self.Dimension == other.Dimension && self.NumSamples == other.NumSamples && self.Space == other.Space && self.uID == other.uID
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::Eq for D3D12_SHADER_INPUT_BIND_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_INPUT_BIND_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SHADER_MAJOR_VERSION: u32 = 5u32;
pub const D3D12_SHADER_MAX_INSTANCES: u32 = 65535u32;
pub const D3D12_SHADER_MAX_INTERFACES: u32 = 253u32;
pub const D3D12_SHADER_MAX_INTERFACE_CALL_SITES: u32 = 4096u32;
pub const D3D12_SHADER_MAX_TYPES: u32 = 65535u32;
pub const D3D12_SHADER_MINOR_VERSION: u32 = 1u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_MIN_PRECISION_SUPPORT(pub u32);
pub const D3D12_SHADER_MIN_PRECISION_SUPPORT_NONE: D3D12_SHADER_MIN_PRECISION_SUPPORT = D3D12_SHADER_MIN_PRECISION_SUPPORT(0u32);
pub const D3D12_SHADER_MIN_PRECISION_SUPPORT_10_BIT: D3D12_SHADER_MIN_PRECISION_SUPPORT = D3D12_SHADER_MIN_PRECISION_SUPPORT(1u32);
pub const D3D12_SHADER_MIN_PRECISION_SUPPORT_16_BIT: D3D12_SHADER_MIN_PRECISION_SUPPORT = D3D12_SHADER_MIN_PRECISION_SUPPORT(2u32);
impl ::std::convert::From<u32> for D3D12_SHADER_MIN_PRECISION_SUPPORT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_MIN_PRECISION_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_SHADER_MIN_PRECISION_SUPPORT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_SHADER_MIN_PRECISION_SUPPORT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_SHADER_MIN_PRECISION_SUPPORT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_SHADER_MIN_PRECISION_SUPPORT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_SHADER_MIN_PRECISION_SUPPORT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_SHADER_RESOURCE_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D12_SRV_DIMENSION,
    pub Shader4ComponentMapping: u32,
    pub Anonymous: D3D12_SHADER_RESOURCE_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_SHADER_RESOURCE_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_SHADER_RESOURCE_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_SHADER_RESOURCE_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_SHADER_RESOURCE_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_RESOURCE_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_SHADER_RESOURCE_VIEW_DESC_0 {
    pub Buffer: D3D12_BUFFER_SRV,
    pub Texture1D: D3D12_TEX1D_SRV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_SRV,
    pub Texture2D: D3D12_TEX2D_SRV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_SRV,
    pub Texture2DMS: D3D12_TEX2DMS_SRV,
    pub Texture2DMSArray: D3D12_TEX2DMS_ARRAY_SRV,
    pub Texture3D: D3D12_TEX3D_SRV,
    pub TextureCube: D3D12_TEXCUBE_SRV,
    pub TextureCubeArray: D3D12_TEXCUBE_ARRAY_SRV,
    pub RaytracingAccelerationStructure: D3D12_RAYTRACING_ACCELERATION_STRUCTURE_SRV,
}
impl D3D12_SHADER_RESOURCE_VIEW_DESC_0 {}
impl ::std::default::Default for D3D12_SHADER_RESOURCE_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_SHADER_RESOURCE_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_SHADER_RESOURCE_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_RESOURCE_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
pub struct D3D12_SHADER_TYPE_DESC {
    pub Class: super::Direct3D11::D3D_SHADER_VARIABLE_CLASS,
    pub Type: super::Direct3D11::D3D_SHADER_VARIABLE_TYPE,
    pub Rows: u32,
    pub Columns: u32,
    pub Elements: u32,
    pub Members: u32,
    pub Offset: u32,
    pub Name: super::super::Foundation::PSTR,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl D3D12_SHADER_TYPE_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::default::Default for D3D12_SHADER_TYPE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::fmt::Debug for D3D12_SHADER_TYPE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SHADER_TYPE_DESC").field("Class", &self.Class).field("Type", &self.Type).field("Rows", &self.Rows).field("Columns", &self.Columns).field("Elements", &self.Elements).field("Members", &self.Members).field("Offset", &self.Offset).field("Name", &self.Name).finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::PartialEq for D3D12_SHADER_TYPE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Class == other.Class && self.Type == other.Type && self.Rows == other.Rows && self.Columns == other.Columns && self.Elements == other.Elements && self.Members == other.Members && self.Offset == other.Offset && self.Name == other.Name
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::Eq for D3D12_SHADER_TYPE_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_TYPE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_SHADER_VARIABLE_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub StartOffset: u32,
    pub Size: u32,
    pub uFlags: u32,
    pub DefaultValue: *mut ::std::ffi::c_void,
    pub StartTexture: u32,
    pub TextureSize: u32,
    pub StartSampler: u32,
    pub SamplerSize: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_SHADER_VARIABLE_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_SHADER_VARIABLE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_SHADER_VARIABLE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SHADER_VARIABLE_DESC")
            .field("Name", &self.Name)
            .field("StartOffset", &self.StartOffset)
            .field("Size", &self.Size)
            .field("uFlags", &self.uFlags)
            .field("DefaultValue", &self.DefaultValue)
            .field("StartTexture", &self.StartTexture)
            .field("TextureSize", &self.TextureSize)
            .field("StartSampler", &self.StartSampler)
            .field("SamplerSize", &self.SamplerSize)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_SHADER_VARIABLE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.StartOffset == other.StartOffset && self.Size == other.Size && self.uFlags == other.uFlags && self.DefaultValue == other.DefaultValue && self.StartTexture == other.StartTexture && self.TextureSize == other.TextureSize && self.StartSampler == other.StartSampler && self.SamplerSize == other.SamplerSize
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_SHADER_VARIABLE_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_VARIABLE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_VERSION_TYPE(pub i32);
pub const D3D12_SHVER_PIXEL_SHADER: D3D12_SHADER_VERSION_TYPE = D3D12_SHADER_VERSION_TYPE(0i32);
pub const D3D12_SHVER_VERTEX_SHADER: D3D12_SHADER_VERSION_TYPE = D3D12_SHADER_VERSION_TYPE(1i32);
pub const D3D12_SHVER_GEOMETRY_SHADER: D3D12_SHADER_VERSION_TYPE = D3D12_SHADER_VERSION_TYPE(2i32);
pub const D3D12_SHVER_HULL_SHADER: D3D12_SHADER_VERSION_TYPE = D3D12_SHADER_VERSION_TYPE(3i32);
pub const D3D12_SHVER_DOMAIN_SHADER: D3D12_SHADER_VERSION_TYPE = D3D12_SHADER_VERSION_TYPE(4i32);
pub const D3D12_SHVER_COMPUTE_SHADER: D3D12_SHADER_VERSION_TYPE = D3D12_SHADER_VERSION_TYPE(5i32);
pub const D3D12_SHVER_RESERVED0: D3D12_SHADER_VERSION_TYPE = D3D12_SHADER_VERSION_TYPE(65520i32);
impl ::std::convert::From<i32> for D3D12_SHADER_VERSION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_VERSION_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADER_VISIBILITY(pub i32);
pub const D3D12_SHADER_VISIBILITY_ALL: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(0i32);
pub const D3D12_SHADER_VISIBILITY_VERTEX: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(1i32);
pub const D3D12_SHADER_VISIBILITY_HULL: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(2i32);
pub const D3D12_SHADER_VISIBILITY_DOMAIN: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(3i32);
pub const D3D12_SHADER_VISIBILITY_GEOMETRY: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(4i32);
pub const D3D12_SHADER_VISIBILITY_PIXEL: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(5i32);
pub const D3D12_SHADER_VISIBILITY_AMPLIFICATION: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(6i32);
pub const D3D12_SHADER_VISIBILITY_MESH: D3D12_SHADER_VISIBILITY = D3D12_SHADER_VISIBILITY(7i32);
impl ::std::convert::From<i32> for D3D12_SHADER_VISIBILITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADER_VISIBILITY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADING_RATE(pub i32);
pub const D3D12_SHADING_RATE_1X1: D3D12_SHADING_RATE = D3D12_SHADING_RATE(0i32);
pub const D3D12_SHADING_RATE_1X2: D3D12_SHADING_RATE = D3D12_SHADING_RATE(1i32);
pub const D3D12_SHADING_RATE_2X1: D3D12_SHADING_RATE = D3D12_SHADING_RATE(4i32);
pub const D3D12_SHADING_RATE_2X2: D3D12_SHADING_RATE = D3D12_SHADING_RATE(5i32);
pub const D3D12_SHADING_RATE_2X4: D3D12_SHADING_RATE = D3D12_SHADING_RATE(6i32);
pub const D3D12_SHADING_RATE_4X2: D3D12_SHADING_RATE = D3D12_SHADING_RATE(9i32);
pub const D3D12_SHADING_RATE_4X4: D3D12_SHADING_RATE = D3D12_SHADING_RATE(10i32);
impl ::std::convert::From<i32> for D3D12_SHADING_RATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADING_RATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHADING_RATE_COMBINER(pub i32);
pub const D3D12_SHADING_RATE_COMBINER_PASSTHROUGH: D3D12_SHADING_RATE_COMBINER = D3D12_SHADING_RATE_COMBINER(0i32);
pub const D3D12_SHADING_RATE_COMBINER_OVERRIDE: D3D12_SHADING_RATE_COMBINER = D3D12_SHADING_RATE_COMBINER(1i32);
pub const D3D12_SHADING_RATE_COMBINER_MIN: D3D12_SHADING_RATE_COMBINER = D3D12_SHADING_RATE_COMBINER(2i32);
pub const D3D12_SHADING_RATE_COMBINER_MAX: D3D12_SHADING_RATE_COMBINER = D3D12_SHADING_RATE_COMBINER(3i32);
pub const D3D12_SHADING_RATE_COMBINER_SUM: D3D12_SHADING_RATE_COMBINER = D3D12_SHADING_RATE_COMBINER(4i32);
impl ::std::convert::From<i32> for D3D12_SHADING_RATE_COMBINER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHADING_RATE_COMBINER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SHADING_RATE_VALID_MASK: u32 = 3u32;
pub const D3D12_SHADING_RATE_X_AXIS_SHIFT: u32 = 2u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER(pub i32);
pub const D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_0: D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER = D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER(0i32);
pub const D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_1: D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER = D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER(1i32);
pub const D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER_2: D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER = D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER(2i32);
impl ::std::convert::From<i32> for D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SHARED_RESOURCE_COMPATIBILITY_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SHIFT_INSTRUCTION_PAD_VALUE: u32 = 0u32;
pub const D3D12_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
pub struct D3D12_SIGNATURE_PARAMETER_DESC {
    pub SemanticName: super::super::Foundation::PSTR,
    pub SemanticIndex: u32,
    pub Register: u32,
    pub SystemValueType: super::Direct3D11::D3D_NAME,
    pub ComponentType: super::Direct3D11::D3D_REGISTER_COMPONENT_TYPE,
    pub Mask: u8,
    pub ReadWriteMask: u8,
    pub Stream: u32,
    pub MinPrecision: super::Direct3D11::D3D_MIN_PRECISION,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl D3D12_SIGNATURE_PARAMETER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::default::Default for D3D12_SIGNATURE_PARAMETER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::fmt::Debug for D3D12_SIGNATURE_PARAMETER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SIGNATURE_PARAMETER_DESC")
            .field("SemanticName", &self.SemanticName)
            .field("SemanticIndex", &self.SemanticIndex)
            .field("Register", &self.Register)
            .field("SystemValueType", &self.SystemValueType)
            .field("ComponentType", &self.ComponentType)
            .field("Mask", &self.Mask)
            .field("ReadWriteMask", &self.ReadWriteMask)
            .field("Stream", &self.Stream)
            .field("MinPrecision", &self.MinPrecision)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::PartialEq for D3D12_SIGNATURE_PARAMETER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.SemanticName == other.SemanticName && self.SemanticIndex == other.SemanticIndex && self.Register == other.Register && self.SystemValueType == other.SystemValueType && self.ComponentType == other.ComponentType && self.Mask == other.Mask && self.ReadWriteMask == other.ReadWriteMask && self.Stream == other.Stream && self.MinPrecision == other.MinPrecision
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
impl ::std::cmp::Eq for D3D12_SIGNATURE_PARAMETER_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D11"))]
unsafe impl ::windows::runtime::Abi for D3D12_SIGNATURE_PARAMETER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SIMULTANEOUS_RENDER_TARGET_COUNT: u32 = 8u32;
pub const D3D12_SMALL_MSAA_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 65536u32;
pub const D3D12_SMALL_RESOURCE_PLACEMENT_ALIGNMENT: u32 = 4096u32;
pub const D3D12_SO_BUFFER_MAX_STRIDE_IN_BYTES: u32 = 2048u32;
pub const D3D12_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES: u32 = 512u32;
pub const D3D12_SO_BUFFER_SLOT_COUNT: u32 = 4u32;
pub const D3D12_SO_DDI_REGISTER_INDEX_DENOTING_GAP: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_SO_DECLARATION_ENTRY {
    pub Stream: u32,
    pub SemanticName: super::super::Foundation::PSTR,
    pub SemanticIndex: u32,
    pub StartComponent: u8,
    pub ComponentCount: u8,
    pub OutputSlot: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_SO_DECLARATION_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_SO_DECLARATION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_SO_DECLARATION_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SO_DECLARATION_ENTRY")
            .field("Stream", &self.Stream)
            .field("SemanticName", &self.SemanticName)
            .field("SemanticIndex", &self.SemanticIndex)
            .field("StartComponent", &self.StartComponent)
            .field("ComponentCount", &self.ComponentCount)
            .field("OutputSlot", &self.OutputSlot)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_SO_DECLARATION_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.Stream == other.Stream && self.SemanticName == other.SemanticName && self.SemanticIndex == other.SemanticIndex && self.StartComponent == other.StartComponent && self.ComponentCount == other.ComponentCount && self.OutputSlot == other.OutputSlot
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_SO_DECLARATION_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_SO_DECLARATION_ENTRY {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SO_NO_RASTERIZED_STREAM: u32 = 4294967295u32;
pub const D3D12_SO_OUTPUT_COMPONENT_COUNT: u32 = 128u32;
pub const D3D12_SO_STREAM_COUNT: u32 = 4u32;
pub const D3D12_SPEC_DATE_DAY: u32 = 14u32;
pub const D3D12_SPEC_DATE_MONTH: u32 = 11u32;
pub const D3D12_SPEC_DATE_YEAR: u32 = 2014u32;
pub const D3D12_SPEC_VERSION: f64 = 1.16f64;
pub const D3D12_SRGB_GAMMA: f32 = 2.2f32;
pub const D3D12_SRGB_TO_FLOAT_DENOMINATOR_1: f32 = 12.92f32;
pub const D3D12_SRGB_TO_FLOAT_DENOMINATOR_2: f32 = 1.055f32;
pub const D3D12_SRGB_TO_FLOAT_EXPONENT: f32 = 2.4f32;
pub const D3D12_SRGB_TO_FLOAT_OFFSET: f32 = 0.055f32;
pub const D3D12_SRGB_TO_FLOAT_THRESHOLD: f32 = 0.04045f32;
pub const D3D12_SRGB_TO_FLOAT_TOLERANCE_IN_ULP: f32 = 0.5f32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_SRV_DIMENSION(pub i32);
pub const D3D12_SRV_DIMENSION_UNKNOWN: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(0i32);
pub const D3D12_SRV_DIMENSION_BUFFER: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(1i32);
pub const D3D12_SRV_DIMENSION_TEXTURE1D: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(2i32);
pub const D3D12_SRV_DIMENSION_TEXTURE1DARRAY: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(3i32);
pub const D3D12_SRV_DIMENSION_TEXTURE2D: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(4i32);
pub const D3D12_SRV_DIMENSION_TEXTURE2DARRAY: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(5i32);
pub const D3D12_SRV_DIMENSION_TEXTURE2DMS: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(6i32);
pub const D3D12_SRV_DIMENSION_TEXTURE2DMSARRAY: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(7i32);
pub const D3D12_SRV_DIMENSION_TEXTURE3D: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(8i32);
pub const D3D12_SRV_DIMENSION_TEXTURECUBE: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(9i32);
pub const D3D12_SRV_DIMENSION_TEXTURECUBEARRAY: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(10i32);
pub const D3D12_SRV_DIMENSION_RAYTRACING_ACCELERATION_STRUCTURE: D3D12_SRV_DIMENSION = D3D12_SRV_DIMENSION(11i32);
impl ::std::convert::From<i32> for D3D12_SRV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_SRV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_STANDARD_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_STANDARD_COMPONENT_BIT_COUNT_DOUBLED: u32 = 64u32;
pub const D3D12_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE: u32 = 4u32;
pub const D3D12_STANDARD_PIXEL_COMPONENT_COUNT: u32 = 128u32;
pub const D3D12_STANDARD_PIXEL_ELEMENT_COUNT: u32 = 32u32;
pub const D3D12_STANDARD_VECTOR_SIZE: u32 = 4u32;
pub const D3D12_STANDARD_VERTEX_ELEMENT_COUNT: u32 = 32u32;
pub const D3D12_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_STATE_OBJECT_CONFIG {
    pub Flags: D3D12_STATE_OBJECT_FLAGS,
}
impl D3D12_STATE_OBJECT_CONFIG {}
impl ::std::default::Default for D3D12_STATE_OBJECT_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_STATE_OBJECT_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_STATE_OBJECT_CONFIG").field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_STATE_OBJECT_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_STATE_OBJECT_CONFIG {}
unsafe impl ::windows::runtime::Abi for D3D12_STATE_OBJECT_CONFIG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_STATE_OBJECT_DESC {
    pub Type: D3D12_STATE_OBJECT_TYPE,
    pub NumSubobjects: u32,
    pub pSubobjects: *mut D3D12_STATE_SUBOBJECT,
}
impl D3D12_STATE_OBJECT_DESC {}
impl ::std::default::Default for D3D12_STATE_OBJECT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_STATE_OBJECT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_STATE_OBJECT_DESC").field("Type", &self.Type).field("NumSubobjects", &self.NumSubobjects).field("pSubobjects", &self.pSubobjects).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_STATE_OBJECT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.NumSubobjects == other.NumSubobjects && self.pSubobjects == other.pSubobjects
    }
}
impl ::std::cmp::Eq for D3D12_STATE_OBJECT_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_STATE_OBJECT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_STATE_OBJECT_FLAGS(pub u32);
pub const D3D12_STATE_OBJECT_FLAG_NONE: D3D12_STATE_OBJECT_FLAGS = D3D12_STATE_OBJECT_FLAGS(0u32);
pub const D3D12_STATE_OBJECT_FLAG_ALLOW_LOCAL_DEPENDENCIES_ON_EXTERNAL_DEFINITIONS: D3D12_STATE_OBJECT_FLAGS = D3D12_STATE_OBJECT_FLAGS(1u32);
pub const D3D12_STATE_OBJECT_FLAG_ALLOW_EXTERNAL_DEPENDENCIES_ON_LOCAL_DEFINITIONS: D3D12_STATE_OBJECT_FLAGS = D3D12_STATE_OBJECT_FLAGS(2u32);
pub const D3D12_STATE_OBJECT_FLAG_ALLOW_STATE_OBJECT_ADDITIONS: D3D12_STATE_OBJECT_FLAGS = D3D12_STATE_OBJECT_FLAGS(4u32);
impl ::std::convert::From<u32> for D3D12_STATE_OBJECT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_STATE_OBJECT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_STATE_OBJECT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_STATE_OBJECT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_STATE_OBJECT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_STATE_OBJECT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_STATE_OBJECT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_STATE_OBJECT_TYPE(pub i32);
pub const D3D12_STATE_OBJECT_TYPE_COLLECTION: D3D12_STATE_OBJECT_TYPE = D3D12_STATE_OBJECT_TYPE(0i32);
pub const D3D12_STATE_OBJECT_TYPE_RAYTRACING_PIPELINE: D3D12_STATE_OBJECT_TYPE = D3D12_STATE_OBJECT_TYPE(3i32);
impl ::std::convert::From<i32> for D3D12_STATE_OBJECT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_STATE_OBJECT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_STATE_SUBOBJECT {
    pub Type: D3D12_STATE_SUBOBJECT_TYPE,
    pub pDesc: *mut ::std::ffi::c_void,
}
impl D3D12_STATE_SUBOBJECT {}
impl ::std::default::Default for D3D12_STATE_SUBOBJECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_STATE_SUBOBJECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_STATE_SUBOBJECT").field("Type", &self.Type).field("pDesc", &self.pDesc).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_STATE_SUBOBJECT {
    fn eq(&self, other: &Self) -> bool {
        self.Type == other.Type && self.pDesc == other.pDesc
    }
}
impl ::std::cmp::Eq for D3D12_STATE_SUBOBJECT {}
unsafe impl ::windows::runtime::Abi for D3D12_STATE_SUBOBJECT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_STATE_SUBOBJECT_TYPE(pub i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_STATE_OBJECT_CONFIG: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(0i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_GLOBAL_ROOT_SIGNATURE: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(1i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_LOCAL_ROOT_SIGNATURE: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(2i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_NODE_MASK: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(3i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_DXIL_LIBRARY: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(5i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_EXISTING_COLLECTION: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(6i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_SUBOBJECT_TO_EXPORTS_ASSOCIATION: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(7i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_DXIL_SUBOBJECT_TO_EXPORTS_ASSOCIATION: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(8i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_SHADER_CONFIG: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(9i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_PIPELINE_CONFIG: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(10i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_HIT_GROUP: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(11i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_RAYTRACING_PIPELINE_CONFIG1: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(12i32);
pub const D3D12_STATE_SUBOBJECT_TYPE_MAX_VALID: D3D12_STATE_SUBOBJECT_TYPE = D3D12_STATE_SUBOBJECT_TYPE(13i32);
impl ::std::convert::From<i32> for D3D12_STATE_SUBOBJECT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_STATE_SUBOBJECT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_STATIC_BORDER_COLOR(pub i32);
pub const D3D12_STATIC_BORDER_COLOR_TRANSPARENT_BLACK: D3D12_STATIC_BORDER_COLOR = D3D12_STATIC_BORDER_COLOR(0i32);
pub const D3D12_STATIC_BORDER_COLOR_OPAQUE_BLACK: D3D12_STATIC_BORDER_COLOR = D3D12_STATIC_BORDER_COLOR(1i32);
pub const D3D12_STATIC_BORDER_COLOR_OPAQUE_WHITE: D3D12_STATIC_BORDER_COLOR = D3D12_STATIC_BORDER_COLOR(2i32);
impl ::std::convert::From<i32> for D3D12_STATIC_BORDER_COLOR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_STATIC_BORDER_COLOR {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_STATIC_SAMPLER_DESC {
    pub Filter: D3D12_FILTER,
    pub AddressU: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressV: D3D12_TEXTURE_ADDRESS_MODE,
    pub AddressW: D3D12_TEXTURE_ADDRESS_MODE,
    pub MipLODBias: f32,
    pub MaxAnisotropy: u32,
    pub ComparisonFunc: D3D12_COMPARISON_FUNC,
    pub BorderColor: D3D12_STATIC_BORDER_COLOR,
    pub MinLOD: f32,
    pub MaxLOD: f32,
    pub ShaderRegister: u32,
    pub RegisterSpace: u32,
    pub ShaderVisibility: D3D12_SHADER_VISIBILITY,
}
impl D3D12_STATIC_SAMPLER_DESC {}
impl ::std::default::Default for D3D12_STATIC_SAMPLER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_STATIC_SAMPLER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_STATIC_SAMPLER_DESC")
            .field("Filter", &self.Filter)
            .field("AddressU", &self.AddressU)
            .field("AddressV", &self.AddressV)
            .field("AddressW", &self.AddressW)
            .field("MipLODBias", &self.MipLODBias)
            .field("MaxAnisotropy", &self.MaxAnisotropy)
            .field("ComparisonFunc", &self.ComparisonFunc)
            .field("BorderColor", &self.BorderColor)
            .field("MinLOD", &self.MinLOD)
            .field("MaxLOD", &self.MaxLOD)
            .field("ShaderRegister", &self.ShaderRegister)
            .field("RegisterSpace", &self.RegisterSpace)
            .field("ShaderVisibility", &self.ShaderVisibility)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_STATIC_SAMPLER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Filter == other.Filter
            && self.AddressU == other.AddressU
            && self.AddressV == other.AddressV
            && self.AddressW == other.AddressW
            && self.MipLODBias == other.MipLODBias
            && self.MaxAnisotropy == other.MaxAnisotropy
            && self.ComparisonFunc == other.ComparisonFunc
            && self.BorderColor == other.BorderColor
            && self.MinLOD == other.MinLOD
            && self.MaxLOD == other.MaxLOD
            && self.ShaderRegister == other.ShaderRegister
            && self.RegisterSpace == other.RegisterSpace
            && self.ShaderVisibility == other.ShaderVisibility
    }
}
impl ::std::cmp::Eq for D3D12_STATIC_SAMPLER_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_STATIC_SAMPLER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_STENCIL_OP(pub i32);
pub const D3D12_STENCIL_OP_KEEP: D3D12_STENCIL_OP = D3D12_STENCIL_OP(1i32);
pub const D3D12_STENCIL_OP_ZERO: D3D12_STENCIL_OP = D3D12_STENCIL_OP(2i32);
pub const D3D12_STENCIL_OP_REPLACE: D3D12_STENCIL_OP = D3D12_STENCIL_OP(3i32);
pub const D3D12_STENCIL_OP_INCR_SAT: D3D12_STENCIL_OP = D3D12_STENCIL_OP(4i32);
pub const D3D12_STENCIL_OP_DECR_SAT: D3D12_STENCIL_OP = D3D12_STENCIL_OP(5i32);
pub const D3D12_STENCIL_OP_INVERT: D3D12_STENCIL_OP = D3D12_STENCIL_OP(6i32);
pub const D3D12_STENCIL_OP_INCR: D3D12_STENCIL_OP = D3D12_STENCIL_OP(7i32);
pub const D3D12_STENCIL_OP_DECR: D3D12_STENCIL_OP = D3D12_STENCIL_OP(8i32);
impl ::std::convert::From<i32> for D3D12_STENCIL_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_STENCIL_OP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_STREAM_OUTPUT_BUFFER_VIEW {
    pub BufferLocation: u64,
    pub SizeInBytes: u64,
    pub BufferFilledSizeLocation: u64,
}
impl D3D12_STREAM_OUTPUT_BUFFER_VIEW {}
impl ::std::default::Default for D3D12_STREAM_OUTPUT_BUFFER_VIEW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_STREAM_OUTPUT_BUFFER_VIEW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_STREAM_OUTPUT_BUFFER_VIEW").field("BufferLocation", &self.BufferLocation).field("SizeInBytes", &self.SizeInBytes).field("BufferFilledSizeLocation", &self.BufferFilledSizeLocation).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_STREAM_OUTPUT_BUFFER_VIEW {
    fn eq(&self, other: &Self) -> bool {
        self.BufferLocation == other.BufferLocation && self.SizeInBytes == other.SizeInBytes && self.BufferFilledSizeLocation == other.BufferFilledSizeLocation
    }
}
impl ::std::cmp::Eq for D3D12_STREAM_OUTPUT_BUFFER_VIEW {}
unsafe impl ::windows::runtime::Abi for D3D12_STREAM_OUTPUT_BUFFER_VIEW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_STREAM_OUTPUT_DESC {
    pub pSODeclaration: *mut D3D12_SO_DECLARATION_ENTRY,
    pub NumEntries: u32,
    pub pBufferStrides: *mut u32,
    pub NumStrides: u32,
    pub RasterizedStream: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_STREAM_OUTPUT_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_STREAM_OUTPUT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_STREAM_OUTPUT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_STREAM_OUTPUT_DESC").field("pSODeclaration", &self.pSODeclaration).field("NumEntries", &self.NumEntries).field("pBufferStrides", &self.pBufferStrides).field("NumStrides", &self.NumStrides).field("RasterizedStream", &self.RasterizedStream).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_STREAM_OUTPUT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.pSODeclaration == other.pSODeclaration && self.NumEntries == other.NumEntries && self.pBufferStrides == other.pBufferStrides && self.NumStrides == other.NumStrides && self.RasterizedStream == other.RasterizedStream
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_STREAM_OUTPUT_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_STREAM_OUTPUT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    pub pSubobjectToAssociate: *mut D3D12_STATE_SUBOBJECT,
    pub NumExports: u32,
    pub pExports: *mut super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION").field("pSubobjectToAssociate", &self.pSubobjectToAssociate).field("NumExports", &self.NumExports).field("pExports", &self.pExports).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    fn eq(&self, other: &Self) -> bool {
        self.pSubobjectToAssociate == other.pSubobjectToAssociate && self.NumExports == other.NumExports && self.pExports == other.pExports
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_SUBOBJECT_TO_EXPORTS_ASSOCIATION {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SUBPIXEL_FRACTIONAL_BIT_COUNT: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SUBRESOURCE_DATA {
    pub pData: *mut ::std::ffi::c_void,
    pub RowPitch: isize,
    pub SlicePitch: isize,
}
impl D3D12_SUBRESOURCE_DATA {}
impl ::std::default::Default for D3D12_SUBRESOURCE_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SUBRESOURCE_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SUBRESOURCE_DATA").field("pData", &self.pData).field("RowPitch", &self.RowPitch).field("SlicePitch", &self.SlicePitch).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SUBRESOURCE_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.pData == other.pData && self.RowPitch == other.RowPitch && self.SlicePitch == other.SlicePitch
    }
}
impl ::std::cmp::Eq for D3D12_SUBRESOURCE_DATA {}
unsafe impl ::windows::runtime::Abi for D3D12_SUBRESOURCE_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_SUBRESOURCE_FOOTPRINT {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub Width: u32,
    pub Height: u32,
    pub Depth: u32,
    pub RowPitch: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_SUBRESOURCE_FOOTPRINT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_SUBRESOURCE_FOOTPRINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D12_SUBRESOURCE_FOOTPRINT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SUBRESOURCE_FOOTPRINT").field("Format", &self.Format).field("Width", &self.Width).field("Height", &self.Height).field("Depth", &self.Depth).field("RowPitch", &self.RowPitch).finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_SUBRESOURCE_FOOTPRINT {
    fn eq(&self, other: &Self) -> bool {
        self.Format == other.Format && self.Width == other.Width && self.Height == other.Height && self.Depth == other.Depth && self.RowPitch == other.RowPitch
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_SUBRESOURCE_FOOTPRINT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_SUBRESOURCE_FOOTPRINT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SUBRESOURCE_INFO {
    pub Offset: u64,
    pub RowPitch: u32,
    pub DepthPitch: u32,
}
impl D3D12_SUBRESOURCE_INFO {}
impl ::std::default::Default for D3D12_SUBRESOURCE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SUBRESOURCE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SUBRESOURCE_INFO").field("Offset", &self.Offset).field("RowPitch", &self.RowPitch).field("DepthPitch", &self.DepthPitch).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SUBRESOURCE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Offset == other.Offset && self.RowPitch == other.RowPitch && self.DepthPitch == other.DepthPitch
    }
}
impl ::std::cmp::Eq for D3D12_SUBRESOURCE_INFO {}
unsafe impl ::windows::runtime::Abi for D3D12_SUBRESOURCE_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SUBRESOURCE_RANGE_UINT64 {
    pub Subresource: u32,
    pub Range: D3D12_RANGE_UINT64,
}
impl D3D12_SUBRESOURCE_RANGE_UINT64 {}
impl ::std::default::Default for D3D12_SUBRESOURCE_RANGE_UINT64 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SUBRESOURCE_RANGE_UINT64 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SUBRESOURCE_RANGE_UINT64").field("Subresource", &self.Subresource).field("Range", &self.Range).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SUBRESOURCE_RANGE_UINT64 {
    fn eq(&self, other: &Self) -> bool {
        self.Subresource == other.Subresource && self.Range == other.Range
    }
}
impl ::std::cmp::Eq for D3D12_SUBRESOURCE_RANGE_UINT64 {}
unsafe impl ::windows::runtime::Abi for D3D12_SUBRESOURCE_RANGE_UINT64 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_SUBRESOURCE_TILING {
    pub WidthInTiles: u32,
    pub HeightInTiles: u16,
    pub DepthInTiles: u16,
    pub StartTileIndexInOverallResource: u32,
}
impl D3D12_SUBRESOURCE_TILING {}
impl ::std::default::Default for D3D12_SUBRESOURCE_TILING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_SUBRESOURCE_TILING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_SUBRESOURCE_TILING").field("WidthInTiles", &self.WidthInTiles).field("HeightInTiles", &self.HeightInTiles).field("DepthInTiles", &self.DepthInTiles).field("StartTileIndexInOverallResource", &self.StartTileIndexInOverallResource).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_SUBRESOURCE_TILING {
    fn eq(&self, other: &Self) -> bool {
        self.WidthInTiles == other.WidthInTiles && self.HeightInTiles == other.HeightInTiles && self.DepthInTiles == other.DepthInTiles && self.StartTileIndexInOverallResource == other.StartTileIndexInOverallResource
    }
}
impl ::std::cmp::Eq for D3D12_SUBRESOURCE_TILING {}
unsafe impl ::windows::runtime::Abi for D3D12_SUBRESOURCE_TILING {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_SUBTEXEL_FRACTIONAL_BIT_COUNT: u32 = 8u32;
pub const D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_END: u32 = 4294967295u32;
pub const D3D12_SYSTEM_RESERVED_REGISTER_SPACE_VALUES_START: u32 = 4294967280u32;
pub const D3D12_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR: u32 = 64u32;
pub const D3D12_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 = 64u32;
pub const D3D12_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR: u32 = 63u32;
pub const D3D12_TESSELLATOR_MAX_TESSELLATION_FACTOR: u32 = 64u32;
pub const D3D12_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR: u32 = 2u32;
pub const D3D12_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 = 1u32;
pub const D3D12_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_ARRAY_DSV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D12_TEX1D_ARRAY_DSV {}
impl ::std::default::Default for D3D12_TEX1D_ARRAY_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_ARRAY_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_ARRAY_DSV").field("MipSlice", &self.MipSlice).field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_ARRAY_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_ARRAY_DSV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_ARRAY_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_ARRAY_RTV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D12_TEX1D_ARRAY_RTV {}
impl ::std::default::Default for D3D12_TEX1D_ARRAY_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_ARRAY_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_ARRAY_RTV").field("MipSlice", &self.MipSlice).field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_ARRAY_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_ARRAY_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_ARRAY_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_ARRAY_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
    pub ResourceMinLODClamp: f32,
}
impl D3D12_TEX1D_ARRAY_SRV {}
impl ::std::default::Default for D3D12_TEX1D_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_ARRAY_SRV").field("MostDetailedMip", &self.MostDetailedMip).field("MipLevels", &self.MipLevels).field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).field("ResourceMinLODClamp", &self.ResourceMinLODClamp).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize && self.ResourceMinLODClamp == other.ResourceMinLODClamp
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_ARRAY_UAV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D12_TEX1D_ARRAY_UAV {}
impl ::std::default::Default for D3D12_TEX1D_ARRAY_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_ARRAY_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_ARRAY_UAV").field("MipSlice", &self.MipSlice).field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_ARRAY_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_ARRAY_UAV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_ARRAY_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_DSV {
    pub MipSlice: u32,
}
impl D3D12_TEX1D_DSV {}
impl ::std::default::Default for D3D12_TEX1D_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_DSV").field("MipSlice", &self.MipSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_DSV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_RTV {
    pub MipSlice: u32,
}
impl D3D12_TEX1D_RTV {}
impl ::std::default::Default for D3D12_TEX1D_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_RTV").field("MipSlice", &self.MipSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub ResourceMinLODClamp: f32,
}
impl D3D12_TEX1D_SRV {}
impl ::std::default::Default for D3D12_TEX1D_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_SRV").field("MostDetailedMip", &self.MostDetailedMip).field("MipLevels", &self.MipLevels).field("ResourceMinLODClamp", &self.ResourceMinLODClamp).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels && self.ResourceMinLODClamp == other.ResourceMinLODClamp
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX1D_UAV {
    pub MipSlice: u32,
}
impl D3D12_TEX1D_UAV {}
impl ::std::default::Default for D3D12_TEX1D_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX1D_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX1D_UAV").field("MipSlice", &self.MipSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX1D_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX1D_UAV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX1D_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2DMS_ARRAY_DSV {
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D12_TEX2DMS_ARRAY_DSV {}
impl ::std::default::Default for D3D12_TEX2DMS_ARRAY_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2DMS_ARRAY_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2DMS_ARRAY_DSV").field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2DMS_ARRAY_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D12_TEX2DMS_ARRAY_DSV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2DMS_ARRAY_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2DMS_ARRAY_RTV {
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D12_TEX2DMS_ARRAY_RTV {}
impl ::std::default::Default for D3D12_TEX2DMS_ARRAY_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2DMS_ARRAY_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2DMS_ARRAY_RTV").field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2DMS_ARRAY_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D12_TEX2DMS_ARRAY_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2DMS_ARRAY_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2DMS_ARRAY_SRV {
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D12_TEX2DMS_ARRAY_SRV {}
impl ::std::default::Default for D3D12_TEX2DMS_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2DMS_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2DMS_ARRAY_SRV").field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2DMS_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D12_TEX2DMS_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2DMS_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2DMS_DSV {
    pub UnusedField_NothingToDefine: u32,
}
impl D3D12_TEX2DMS_DSV {}
impl ::std::default::Default for D3D12_TEX2DMS_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2DMS_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2DMS_DSV").field("UnusedField_NothingToDefine", &self.UnusedField_NothingToDefine).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2DMS_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.UnusedField_NothingToDefine == other.UnusedField_NothingToDefine
    }
}
impl ::std::cmp::Eq for D3D12_TEX2DMS_DSV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2DMS_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2DMS_RTV {
    pub UnusedField_NothingToDefine: u32,
}
impl D3D12_TEX2DMS_RTV {}
impl ::std::default::Default for D3D12_TEX2DMS_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2DMS_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2DMS_RTV").field("UnusedField_NothingToDefine", &self.UnusedField_NothingToDefine).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2DMS_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.UnusedField_NothingToDefine == other.UnusedField_NothingToDefine
    }
}
impl ::std::cmp::Eq for D3D12_TEX2DMS_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2DMS_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2DMS_SRV {
    pub UnusedField_NothingToDefine: u32,
}
impl D3D12_TEX2DMS_SRV {}
impl ::std::default::Default for D3D12_TEX2DMS_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2DMS_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2DMS_SRV").field("UnusedField_NothingToDefine", &self.UnusedField_NothingToDefine).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2DMS_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.UnusedField_NothingToDefine == other.UnusedField_NothingToDefine
    }
}
impl ::std::cmp::Eq for D3D12_TEX2DMS_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2DMS_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_ARRAY_DSV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D12_TEX2D_ARRAY_DSV {}
impl ::std::default::Default for D3D12_TEX2D_ARRAY_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_ARRAY_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_ARRAY_DSV").field("MipSlice", &self.MipSlice).field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_ARRAY_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_ARRAY_DSV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_ARRAY_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_ARRAY_RTV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
    pub PlaneSlice: u32,
}
impl D3D12_TEX2D_ARRAY_RTV {}
impl ::std::default::Default for D3D12_TEX2D_ARRAY_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_ARRAY_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_ARRAY_RTV").field("MipSlice", &self.MipSlice).field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).field("PlaneSlice", &self.PlaneSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_ARRAY_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_ARRAY_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_ARRAY_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_ARRAY_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
    pub PlaneSlice: u32,
    pub ResourceMinLODClamp: f32,
}
impl D3D12_TEX2D_ARRAY_SRV {}
impl ::std::default::Default for D3D12_TEX2D_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_ARRAY_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .field("PlaneSlice", &self.PlaneSlice)
            .field("ResourceMinLODClamp", &self.ResourceMinLODClamp)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize && self.PlaneSlice == other.PlaneSlice && self.ResourceMinLODClamp == other.ResourceMinLODClamp
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_ARRAY_UAV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
    pub PlaneSlice: u32,
}
impl D3D12_TEX2D_ARRAY_UAV {}
impl ::std::default::Default for D3D12_TEX2D_ARRAY_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_ARRAY_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_ARRAY_UAV").field("MipSlice", &self.MipSlice).field("FirstArraySlice", &self.FirstArraySlice).field("ArraySize", &self.ArraySize).field("PlaneSlice", &self.PlaneSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_ARRAY_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_ARRAY_UAV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_ARRAY_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_DSV {
    pub MipSlice: u32,
}
impl D3D12_TEX2D_DSV {}
impl ::std::default::Default for D3D12_TEX2D_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_DSV").field("MipSlice", &self.MipSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_DSV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_RTV {
    pub MipSlice: u32,
    pub PlaneSlice: u32,
}
impl D3D12_TEX2D_RTV {}
impl ::std::default::Default for D3D12_TEX2D_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_RTV").field("MipSlice", &self.MipSlice).field("PlaneSlice", &self.PlaneSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub PlaneSlice: u32,
    pub ResourceMinLODClamp: f32,
}
impl D3D12_TEX2D_SRV {}
impl ::std::default::Default for D3D12_TEX2D_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_SRV").field("MostDetailedMip", &self.MostDetailedMip).field("MipLevels", &self.MipLevels).field("PlaneSlice", &self.PlaneSlice).field("ResourceMinLODClamp", &self.ResourceMinLODClamp).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels && self.PlaneSlice == other.PlaneSlice && self.ResourceMinLODClamp == other.ResourceMinLODClamp
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX2D_UAV {
    pub MipSlice: u32,
    pub PlaneSlice: u32,
}
impl D3D12_TEX2D_UAV {}
impl ::std::default::Default for D3D12_TEX2D_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX2D_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX2D_UAV").field("MipSlice", &self.MipSlice).field("PlaneSlice", &self.PlaneSlice).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX2D_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D12_TEX2D_UAV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX2D_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX3D_RTV {
    pub MipSlice: u32,
    pub FirstWSlice: u32,
    pub WSize: u32,
}
impl D3D12_TEX3D_RTV {}
impl ::std::default::Default for D3D12_TEX3D_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX3D_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX3D_RTV").field("MipSlice", &self.MipSlice).field("FirstWSlice", &self.FirstWSlice).field("WSize", &self.WSize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX3D_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstWSlice == other.FirstWSlice && self.WSize == other.WSize
    }
}
impl ::std::cmp::Eq for D3D12_TEX3D_RTV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX3D_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX3D_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub ResourceMinLODClamp: f32,
}
impl D3D12_TEX3D_SRV {}
impl ::std::default::Default for D3D12_TEX3D_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX3D_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX3D_SRV").field("MostDetailedMip", &self.MostDetailedMip).field("MipLevels", &self.MipLevels).field("ResourceMinLODClamp", &self.ResourceMinLODClamp).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX3D_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels && self.ResourceMinLODClamp == other.ResourceMinLODClamp
    }
}
impl ::std::cmp::Eq for D3D12_TEX3D_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX3D_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEX3D_UAV {
    pub MipSlice: u32,
    pub FirstWSlice: u32,
    pub WSize: u32,
}
impl D3D12_TEX3D_UAV {}
impl ::std::default::Default for D3D12_TEX3D_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEX3D_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEX3D_UAV").field("MipSlice", &self.MipSlice).field("FirstWSlice", &self.FirstWSlice).field("WSize", &self.WSize).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEX3D_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.FirstWSlice == other.FirstWSlice && self.WSize == other.WSize
    }
}
impl ::std::cmp::Eq for D3D12_TEX3D_UAV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEX3D_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEXCUBE_ARRAY_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub First2DArrayFace: u32,
    pub NumCubes: u32,
    pub ResourceMinLODClamp: f32,
}
impl D3D12_TEXCUBE_ARRAY_SRV {}
impl ::std::default::Default for D3D12_TEXCUBE_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEXCUBE_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEXCUBE_ARRAY_SRV").field("MostDetailedMip", &self.MostDetailedMip).field("MipLevels", &self.MipLevels).field("First2DArrayFace", &self.First2DArrayFace).field("NumCubes", &self.NumCubes).field("ResourceMinLODClamp", &self.ResourceMinLODClamp).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEXCUBE_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels && self.First2DArrayFace == other.First2DArrayFace && self.NumCubes == other.NumCubes && self.ResourceMinLODClamp == other.ResourceMinLODClamp
    }
}
impl ::std::cmp::Eq for D3D12_TEXCUBE_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEXCUBE_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TEXCUBE_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub ResourceMinLODClamp: f32,
}
impl D3D12_TEXCUBE_SRV {}
impl ::std::default::Default for D3D12_TEXCUBE_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TEXCUBE_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TEXCUBE_SRV").field("MostDetailedMip", &self.MostDetailedMip).field("MipLevels", &self.MipLevels).field("ResourceMinLODClamp", &self.ResourceMinLODClamp).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TEXCUBE_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels && self.ResourceMinLODClamp == other.ResourceMinLODClamp
    }
}
impl ::std::cmp::Eq for D3D12_TEXCUBE_SRV {}
unsafe impl ::windows::runtime::Abi for D3D12_TEXCUBE_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_TEXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 16u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_TEXTURE_ADDRESS_MODE(pub i32);
pub const D3D12_TEXTURE_ADDRESS_MODE_WRAP: D3D12_TEXTURE_ADDRESS_MODE = D3D12_TEXTURE_ADDRESS_MODE(1i32);
pub const D3D12_TEXTURE_ADDRESS_MODE_MIRROR: D3D12_TEXTURE_ADDRESS_MODE = D3D12_TEXTURE_ADDRESS_MODE(2i32);
pub const D3D12_TEXTURE_ADDRESS_MODE_CLAMP: D3D12_TEXTURE_ADDRESS_MODE = D3D12_TEXTURE_ADDRESS_MODE(3i32);
pub const D3D12_TEXTURE_ADDRESS_MODE_BORDER: D3D12_TEXTURE_ADDRESS_MODE = D3D12_TEXTURE_ADDRESS_MODE(4i32);
pub const D3D12_TEXTURE_ADDRESS_MODE_MIRROR_ONCE: D3D12_TEXTURE_ADDRESS_MODE = D3D12_TEXTURE_ADDRESS_MODE(5i32);
impl ::std::convert::From<i32> for D3D12_TEXTURE_ADDRESS_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_TEXTURE_ADDRESS_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::clone::Clone for D3D12_TEXTURE_COPY_LOCATION {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_TEXTURE_COPY_LOCATION {
    pub pResource: ::std::option::Option<ID3D12Resource>,
    pub Type: D3D12_TEXTURE_COPY_TYPE,
    pub Anonymous: D3D12_TEXTURE_COPY_LOCATION_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_TEXTURE_COPY_LOCATION {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_TEXTURE_COPY_LOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_TEXTURE_COPY_LOCATION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_TEXTURE_COPY_LOCATION {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_TEXTURE_COPY_LOCATION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub union D3D12_TEXTURE_COPY_LOCATION_0 {
    pub PlacedFootprint: D3D12_PLACED_SUBRESOURCE_FOOTPRINT,
    pub SubresourceIndex: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_TEXTURE_COPY_LOCATION_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_TEXTURE_COPY_LOCATION_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_TEXTURE_COPY_LOCATION_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_TEXTURE_COPY_LOCATION_0 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_TEXTURE_COPY_LOCATION_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_TEXTURE_COPY_TYPE(pub i32);
pub const D3D12_TEXTURE_COPY_TYPE_SUBRESOURCE_INDEX: D3D12_TEXTURE_COPY_TYPE = D3D12_TEXTURE_COPY_TYPE(0i32);
pub const D3D12_TEXTURE_COPY_TYPE_PLACED_FOOTPRINT: D3D12_TEXTURE_COPY_TYPE = D3D12_TEXTURE_COPY_TYPE(1i32);
impl ::std::convert::From<i32> for D3D12_TEXTURE_COPY_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_TEXTURE_COPY_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_TEXTURE_DATA_PITCH_ALIGNMENT: u32 = 256u32;
pub const D3D12_TEXTURE_DATA_PLACEMENT_ALIGNMENT: u32 = 512u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_TEXTURE_LAYOUT(pub i32);
pub const D3D12_TEXTURE_LAYOUT_UNKNOWN: D3D12_TEXTURE_LAYOUT = D3D12_TEXTURE_LAYOUT(0i32);
pub const D3D12_TEXTURE_LAYOUT_ROW_MAJOR: D3D12_TEXTURE_LAYOUT = D3D12_TEXTURE_LAYOUT(1i32);
pub const D3D12_TEXTURE_LAYOUT_64KB_UNDEFINED_SWIZZLE: D3D12_TEXTURE_LAYOUT = D3D12_TEXTURE_LAYOUT(2i32);
pub const D3D12_TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE: D3D12_TEXTURE_LAYOUT = D3D12_TEXTURE_LAYOUT(3i32);
impl ::std::convert::From<i32> for D3D12_TEXTURE_LAYOUT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_TEXTURE_LAYOUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_TILED_RESOURCES_TIER(pub i32);
pub const D3D12_TILED_RESOURCES_TIER_NOT_SUPPORTED: D3D12_TILED_RESOURCES_TIER = D3D12_TILED_RESOURCES_TIER(0i32);
pub const D3D12_TILED_RESOURCES_TIER_1: D3D12_TILED_RESOURCES_TIER = D3D12_TILED_RESOURCES_TIER(1i32);
pub const D3D12_TILED_RESOURCES_TIER_2: D3D12_TILED_RESOURCES_TIER = D3D12_TILED_RESOURCES_TIER(2i32);
pub const D3D12_TILED_RESOURCES_TIER_3: D3D12_TILED_RESOURCES_TIER = D3D12_TILED_RESOURCES_TIER(3i32);
pub const D3D12_TILED_RESOURCES_TIER_4: D3D12_TILED_RESOURCES_TIER = D3D12_TILED_RESOURCES_TIER(4i32);
impl ::std::convert::From<i32> for D3D12_TILED_RESOURCES_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_TILED_RESOURCES_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TILED_RESOURCE_COORDINATE {
    pub X: u32,
    pub Y: u32,
    pub Z: u32,
    pub Subresource: u32,
}
impl D3D12_TILED_RESOURCE_COORDINATE {}
impl ::std::default::Default for D3D12_TILED_RESOURCE_COORDINATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TILED_RESOURCE_COORDINATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TILED_RESOURCE_COORDINATE").field("X", &self.X).field("Y", &self.Y).field("Z", &self.Z).field("Subresource", &self.Subresource).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TILED_RESOURCE_COORDINATE {
    fn eq(&self, other: &Self) -> bool {
        self.X == other.X && self.Y == other.Y && self.Z == other.Z && self.Subresource == other.Subresource
    }
}
impl ::std::cmp::Eq for D3D12_TILED_RESOURCE_COORDINATE {}
unsafe impl ::windows::runtime::Abi for D3D12_TILED_RESOURCE_COORDINATE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_TILED_RESOURCE_TILE_SIZE_IN_BYTES: u32 = 65536u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_TILE_COPY_FLAGS(pub u32);
pub const D3D12_TILE_COPY_FLAG_NONE: D3D12_TILE_COPY_FLAGS = D3D12_TILE_COPY_FLAGS(0u32);
pub const D3D12_TILE_COPY_FLAG_NO_HAZARD: D3D12_TILE_COPY_FLAGS = D3D12_TILE_COPY_FLAGS(1u32);
pub const D3D12_TILE_COPY_FLAG_LINEAR_BUFFER_TO_SWIZZLED_TILED_RESOURCE: D3D12_TILE_COPY_FLAGS = D3D12_TILE_COPY_FLAGS(2u32);
pub const D3D12_TILE_COPY_FLAG_SWIZZLED_TILED_RESOURCE_TO_LINEAR_BUFFER: D3D12_TILE_COPY_FLAGS = D3D12_TILE_COPY_FLAGS(4u32);
impl ::std::convert::From<u32> for D3D12_TILE_COPY_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_TILE_COPY_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_TILE_COPY_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_TILE_COPY_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_TILE_COPY_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_TILE_COPY_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_TILE_COPY_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_TILE_MAPPING_FLAGS(pub u32);
pub const D3D12_TILE_MAPPING_FLAG_NONE: D3D12_TILE_MAPPING_FLAGS = D3D12_TILE_MAPPING_FLAGS(0u32);
pub const D3D12_TILE_MAPPING_FLAG_NO_HAZARD: D3D12_TILE_MAPPING_FLAGS = D3D12_TILE_MAPPING_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_TILE_MAPPING_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_TILE_MAPPING_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_TILE_MAPPING_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_TILE_MAPPING_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_TILE_MAPPING_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_TILE_MAPPING_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_TILE_MAPPING_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_TILE_RANGE_FLAGS(pub i32);
pub const D3D12_TILE_RANGE_FLAG_NONE: D3D12_TILE_RANGE_FLAGS = D3D12_TILE_RANGE_FLAGS(0i32);
pub const D3D12_TILE_RANGE_FLAG_NULL: D3D12_TILE_RANGE_FLAGS = D3D12_TILE_RANGE_FLAGS(1i32);
pub const D3D12_TILE_RANGE_FLAG_SKIP: D3D12_TILE_RANGE_FLAGS = D3D12_TILE_RANGE_FLAGS(2i32);
pub const D3D12_TILE_RANGE_FLAG_REUSE_SINGLE_TILE: D3D12_TILE_RANGE_FLAGS = D3D12_TILE_RANGE_FLAGS(4i32);
impl ::std::convert::From<i32> for D3D12_TILE_RANGE_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_TILE_RANGE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_TILE_REGION_SIZE {
    pub NumTiles: u32,
    pub UseBox: super::super::Foundation::BOOL,
    pub Width: u32,
    pub Height: u16,
    pub Depth: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_TILE_REGION_SIZE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_TILE_REGION_SIZE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D12_TILE_REGION_SIZE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TILE_REGION_SIZE").field("NumTiles", &self.NumTiles).field("UseBox", &self.UseBox).field("Width", &self.Width).field("Height", &self.Height).field("Depth", &self.Depth).finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_TILE_REGION_SIZE {
    fn eq(&self, other: &Self) -> bool {
        self.NumTiles == other.NumTiles && self.UseBox == other.UseBox && self.Width == other.Width && self.Height == other.Height && self.Depth == other.Depth
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_TILE_REGION_SIZE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_TILE_REGION_SIZE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_TILE_SHAPE {
    pub WidthInTexels: u32,
    pub HeightInTexels: u32,
    pub DepthInTexels: u32,
}
impl D3D12_TILE_SHAPE {}
impl ::std::default::Default for D3D12_TILE_SHAPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_TILE_SHAPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_TILE_SHAPE").field("WidthInTexels", &self.WidthInTexels).field("HeightInTexels", &self.HeightInTexels).field("DepthInTexels", &self.DepthInTexels).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_TILE_SHAPE {
    fn eq(&self, other: &Self) -> bool {
        self.WidthInTexels == other.WidthInTexels && self.HeightInTexels == other.HeightInTexels && self.DepthInTexels == other.DepthInTexels
    }
}
impl ::std::cmp::Eq for D3D12_TILE_SHAPE {}
unsafe impl ::windows::runtime::Abi for D3D12_TILE_SHAPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_TRACKED_WORKLOAD_MAX_INSTANCES: u32 = 32u32;
pub const D3D12_UAV_COUNTER_PLACEMENT_ALIGNMENT: u32 = 4096u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_UAV_DIMENSION(pub i32);
pub const D3D12_UAV_DIMENSION_UNKNOWN: D3D12_UAV_DIMENSION = D3D12_UAV_DIMENSION(0i32);
pub const D3D12_UAV_DIMENSION_BUFFER: D3D12_UAV_DIMENSION = D3D12_UAV_DIMENSION(1i32);
pub const D3D12_UAV_DIMENSION_TEXTURE1D: D3D12_UAV_DIMENSION = D3D12_UAV_DIMENSION(2i32);
pub const D3D12_UAV_DIMENSION_TEXTURE1DARRAY: D3D12_UAV_DIMENSION = D3D12_UAV_DIMENSION(3i32);
pub const D3D12_UAV_DIMENSION_TEXTURE2D: D3D12_UAV_DIMENSION = D3D12_UAV_DIMENSION(4i32);
pub const D3D12_UAV_DIMENSION_TEXTURE2DARRAY: D3D12_UAV_DIMENSION = D3D12_UAV_DIMENSION(5i32);
pub const D3D12_UAV_DIMENSION_TEXTURE3D: D3D12_UAV_DIMENSION = D3D12_UAV_DIMENSION(8i32);
impl ::std::convert::From<i32> for D3D12_UAV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_UAV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_UAV_SLOT_COUNT: u32 = 64u32;
pub const D3D12_UNBOUND_MEMORY_ACCESS_RESULT: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D12_UNORDERED_ACCESS_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D12_UAV_DIMENSION,
    pub Anonymous: D3D12_UNORDERED_ACCESS_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D12_UNORDERED_ACCESS_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D12_UNORDERED_ACCESS_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D12_UNORDERED_ACCESS_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D12_UNORDERED_ACCESS_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D12_UNORDERED_ACCESS_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_UNORDERED_ACCESS_VIEW_DESC_0 {
    pub Buffer: D3D12_BUFFER_UAV,
    pub Texture1D: D3D12_TEX1D_UAV,
    pub Texture1DArray: D3D12_TEX1D_ARRAY_UAV,
    pub Texture2D: D3D12_TEX2D_UAV,
    pub Texture2DArray: D3D12_TEX2D_ARRAY_UAV,
    pub Texture3D: D3D12_TEX3D_UAV,
}
impl D3D12_UNORDERED_ACCESS_VIEW_DESC_0 {}
impl ::std::default::Default for D3D12_UNORDERED_ACCESS_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_UNORDERED_ACCESS_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_UNORDERED_ACCESS_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_UNORDERED_ACCESS_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_VARIABLE_SHADING_RATE_TIER(pub i32);
pub const D3D12_VARIABLE_SHADING_RATE_TIER_NOT_SUPPORTED: D3D12_VARIABLE_SHADING_RATE_TIER = D3D12_VARIABLE_SHADING_RATE_TIER(0i32);
pub const D3D12_VARIABLE_SHADING_RATE_TIER_1: D3D12_VARIABLE_SHADING_RATE_TIER = D3D12_VARIABLE_SHADING_RATE_TIER(1i32);
pub const D3D12_VARIABLE_SHADING_RATE_TIER_2: D3D12_VARIABLE_SHADING_RATE_TIER = D3D12_VARIABLE_SHADING_RATE_TIER(2i32);
impl ::std::convert::From<i32> for D3D12_VARIABLE_SHADING_RATE_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_VARIABLE_SHADING_RATE_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {
    pub Version: D3D12_DRED_VERSION,
    pub Anonymous: D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA_0,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA_0 {
    pub Dred_1_0: D3D12_DEVICE_REMOVED_EXTENDED_DATA,
    pub Dred_1_1: D3D12_DEVICE_REMOVED_EXTENDED_DATA1,
    pub Dred_1_2: D3D12_DEVICE_REMOVED_EXTENDED_DATA2,
    pub Dred_1_3: D3D12_DEVICE_REMOVED_EXTENDED_DATA3,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D12_VERSIONED_DEVICE_REMOVED_EXTENDED_DATA_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    pub Version: D3D_ROOT_SIGNATURE_VERSION,
    pub Anonymous: D3D12_VERSIONED_ROOT_SIGNATURE_DESC_0,
}
impl D3D12_VERSIONED_ROOT_SIGNATURE_DESC {}
impl ::std::default::Default for D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_VERSIONED_ROOT_SIGNATURE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_VERSIONED_ROOT_SIGNATURE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D12_VERSIONED_ROOT_SIGNATURE_DESC_0 {
    pub Desc_1_0: D3D12_ROOT_SIGNATURE_DESC,
    pub Desc_1_1: D3D12_ROOT_SIGNATURE_DESC1,
}
impl D3D12_VERSIONED_ROOT_SIGNATURE_DESC_0 {}
impl ::std::default::Default for D3D12_VERSIONED_ROOT_SIGNATURE_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D12_VERSIONED_ROOT_SIGNATURE_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D12_VERSIONED_ROOT_SIGNATURE_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D12_VERSIONED_ROOT_SIGNATURE_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_VERTEX_BUFFER_VIEW {
    pub BufferLocation: u64,
    pub SizeInBytes: u32,
    pub StrideInBytes: u32,
}
impl D3D12_VERTEX_BUFFER_VIEW {}
impl ::std::default::Default for D3D12_VERTEX_BUFFER_VIEW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_VERTEX_BUFFER_VIEW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_VERTEX_BUFFER_VIEW").field("BufferLocation", &self.BufferLocation).field("SizeInBytes", &self.SizeInBytes).field("StrideInBytes", &self.StrideInBytes).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_VERTEX_BUFFER_VIEW {
    fn eq(&self, other: &Self) -> bool {
        self.BufferLocation == other.BufferLocation && self.SizeInBytes == other.SizeInBytes && self.StrideInBytes == other.StrideInBytes
    }
}
impl ::std::cmp::Eq for D3D12_VERTEX_BUFFER_VIEW {}
unsafe impl ::windows::runtime::Abi for D3D12_VERTEX_BUFFER_VIEW {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_VIDEO_DECODE_MAX_ARGUMENTS: u32 = 10u32;
pub const D3D12_VIDEO_DECODE_MAX_HISTOGRAM_COMPONENTS: u32 = 4u32;
pub const D3D12_VIDEO_DECODE_MIN_BITSTREAM_OFFSET_ALIGNMENT: u32 = 256u32;
pub const D3D12_VIDEO_DECODE_MIN_HISTOGRAM_OFFSET_ALIGNMENT: u32 = 256u32;
pub const D3D12_VIDEO_DECODE_STATUS_MACROBLOCKS_AFFECTED_UNKNOWN: u32 = 4294967295u32;
pub const D3D12_VIDEO_PROCESS_MAX_FILTERS: u32 = 32u32;
pub const D3D12_VIDEO_PROCESS_STEREO_VIEWS: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_VIEWPORT {
    pub TopLeftX: f32,
    pub TopLeftY: f32,
    pub Width: f32,
    pub Height: f32,
    pub MinDepth: f32,
    pub MaxDepth: f32,
}
impl D3D12_VIEWPORT {}
impl ::std::default::Default for D3D12_VIEWPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_VIEWPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_VIEWPORT").field("TopLeftX", &self.TopLeftX).field("TopLeftY", &self.TopLeftY).field("Width", &self.Width).field("Height", &self.Height).field("MinDepth", &self.MinDepth).field("MaxDepth", &self.MaxDepth).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_VIEWPORT {
    fn eq(&self, other: &Self) -> bool {
        self.TopLeftX == other.TopLeftX && self.TopLeftY == other.TopLeftY && self.Width == other.Width && self.Height == other.Height && self.MinDepth == other.MinDepth && self.MaxDepth == other.MaxDepth
    }
}
impl ::std::cmp::Eq for D3D12_VIEWPORT {}
unsafe impl ::windows::runtime::Abi for D3D12_VIEWPORT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_VIEWPORT_AND_SCISSORRECT_MAX_INDEX: u32 = 15u32;
pub const D3D12_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE: u32 = 16u32;
pub const D3D12_VIEWPORT_BOUNDS_MAX: u32 = 32767u32;
pub const D3D12_VIEWPORT_BOUNDS_MIN: i32 = -32768i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_VIEW_INSTANCE_LOCATION {
    pub ViewportArrayIndex: u32,
    pub RenderTargetArrayIndex: u32,
}
impl D3D12_VIEW_INSTANCE_LOCATION {}
impl ::std::default::Default for D3D12_VIEW_INSTANCE_LOCATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_VIEW_INSTANCE_LOCATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_VIEW_INSTANCE_LOCATION").field("ViewportArrayIndex", &self.ViewportArrayIndex).field("RenderTargetArrayIndex", &self.RenderTargetArrayIndex).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_VIEW_INSTANCE_LOCATION {
    fn eq(&self, other: &Self) -> bool {
        self.ViewportArrayIndex == other.ViewportArrayIndex && self.RenderTargetArrayIndex == other.RenderTargetArrayIndex
    }
}
impl ::std::cmp::Eq for D3D12_VIEW_INSTANCE_LOCATION {}
unsafe impl ::windows::runtime::Abi for D3D12_VIEW_INSTANCE_LOCATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_VIEW_INSTANCING_DESC {
    pub ViewInstanceCount: u32,
    pub pViewInstanceLocations: *mut D3D12_VIEW_INSTANCE_LOCATION,
    pub Flags: D3D12_VIEW_INSTANCING_FLAGS,
}
impl D3D12_VIEW_INSTANCING_DESC {}
impl ::std::default::Default for D3D12_VIEW_INSTANCING_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_VIEW_INSTANCING_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_VIEW_INSTANCING_DESC").field("ViewInstanceCount", &self.ViewInstanceCount).field("pViewInstanceLocations", &self.pViewInstanceLocations).field("Flags", &self.Flags).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_VIEW_INSTANCING_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.ViewInstanceCount == other.ViewInstanceCount && self.pViewInstanceLocations == other.pViewInstanceLocations && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D12_VIEW_INSTANCING_DESC {}
unsafe impl ::windows::runtime::Abi for D3D12_VIEW_INSTANCING_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_VIEW_INSTANCING_FLAGS(pub u32);
pub const D3D12_VIEW_INSTANCING_FLAG_NONE: D3D12_VIEW_INSTANCING_FLAGS = D3D12_VIEW_INSTANCING_FLAGS(0u32);
pub const D3D12_VIEW_INSTANCING_FLAG_ENABLE_VIEW_INSTANCE_MASKING: D3D12_VIEW_INSTANCING_FLAGS = D3D12_VIEW_INSTANCING_FLAGS(1u32);
impl ::std::convert::From<u32> for D3D12_VIEW_INSTANCING_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_VIEW_INSTANCING_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D12_VIEW_INSTANCING_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D12_VIEW_INSTANCING_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D12_VIEW_INSTANCING_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D12_VIEW_INSTANCING_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D12_VIEW_INSTANCING_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_VIEW_INSTANCING_TIER(pub i32);
pub const D3D12_VIEW_INSTANCING_TIER_NOT_SUPPORTED: D3D12_VIEW_INSTANCING_TIER = D3D12_VIEW_INSTANCING_TIER(0i32);
pub const D3D12_VIEW_INSTANCING_TIER_1: D3D12_VIEW_INSTANCING_TIER = D3D12_VIEW_INSTANCING_TIER(1i32);
pub const D3D12_VIEW_INSTANCING_TIER_2: D3D12_VIEW_INSTANCING_TIER = D3D12_VIEW_INSTANCING_TIER(2i32);
pub const D3D12_VIEW_INSTANCING_TIER_3: D3D12_VIEW_INSTANCING_TIER = D3D12_VIEW_INSTANCING_TIER(3i32);
impl ::std::convert::From<i32> for D3D12_VIEW_INSTANCING_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_VIEW_INSTANCING_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_VS_INPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_VS_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D12_VS_INPUT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D12_VS_INPUT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D12_VS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D12_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D12_VS_OUTPUT_REGISTER_COUNT: u32 = 32u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_WAVE_MMA_TIER(pub i32);
pub const D3D12_WAVE_MMA_TIER_NOT_SUPPORTED: D3D12_WAVE_MMA_TIER = D3D12_WAVE_MMA_TIER(0i32);
pub const D3D12_WAVE_MMA_TIER_1_0: D3D12_WAVE_MMA_TIER = D3D12_WAVE_MMA_TIER(10i32);
impl ::std::convert::From<i32> for D3D12_WAVE_MMA_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_WAVE_MMA_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D12_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT: u32 = 10u32;
pub const D3D12_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 = 25u32;
pub const D3D12_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP: u32 = 25u32;
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D12_WRITEBUFFERIMMEDIATE_MODE(pub i32);
pub const D3D12_WRITEBUFFERIMMEDIATE_MODE_DEFAULT: D3D12_WRITEBUFFERIMMEDIATE_MODE = D3D12_WRITEBUFFERIMMEDIATE_MODE(0i32);
pub const D3D12_WRITEBUFFERIMMEDIATE_MODE_MARKER_IN: D3D12_WRITEBUFFERIMMEDIATE_MODE = D3D12_WRITEBUFFERIMMEDIATE_MODE(1i32);
pub const D3D12_WRITEBUFFERIMMEDIATE_MODE_MARKER_OUT: D3D12_WRITEBUFFERIMMEDIATE_MODE = D3D12_WRITEBUFFERIMMEDIATE_MODE(2i32);
impl ::std::convert::From<i32> for D3D12_WRITEBUFFERIMMEDIATE_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D12_WRITEBUFFERIMMEDIATE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {
    pub Dest: u64,
    pub Value: u32,
}
impl D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {}
impl ::std::default::Default for D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D12_WRITEBUFFERIMMEDIATE_PARAMETER").field("Dest", &self.Dest).field("Value", &self.Value).finish()
    }
}
impl ::std::cmp::PartialEq for D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {
    fn eq(&self, other: &Self) -> bool {
        self.Dest == other.Dest && self.Value == other.Value
    }
}
impl ::std::cmp::Eq for D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {}
unsafe impl ::windows::runtime::Abi for D3D12_WRITEBUFFERIMMEDIATE_PARAMETER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D9ON12_ARGS {
    pub Enable9On12: super::super::Foundation::BOOL,
    pub pD3D12Device: ::std::option::Option<::windows::runtime::IUnknown>,
    pub ppD3D12Queues: [::std::option::Option<::windows::runtime::IUnknown>; 2],
    pub NumQueues: u32,
    pub NodeMask: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D9ON12_ARGS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D9ON12_ARGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D9ON12_ARGS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D9ON12_ARGS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D9ON12_ARGS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct D3D9On12CreatorID(::windows::runtime::IUnknown);
impl D3D9On12CreatorID {}
unsafe impl ::windows::runtime::Interface for D3D9On12CreatorID {
    type Vtable = D3D9On12CreatorID_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(4294753151, 5587, 17058, [132, 30, 157, 141, 50, 243, 125, 221]);
}
impl ::std::convert::From<D3D9On12CreatorID> for ::windows::runtime::IUnknown {
    fn from(value: D3D9On12CreatorID) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&D3D9On12CreatorID> for ::windows::runtime::IUnknown {
    fn from(value: &D3D9On12CreatorID) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for D3D9On12CreatorID {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &D3D9On12CreatorID {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct D3D9On12CreatorID_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D_ROOT_SIGNATURE_VERSION(pub i32);
pub const D3D_ROOT_SIGNATURE_VERSION_1: D3D_ROOT_SIGNATURE_VERSION = D3D_ROOT_SIGNATURE_VERSION(1i32);
pub const D3D_ROOT_SIGNATURE_VERSION_1_0: D3D_ROOT_SIGNATURE_VERSION = D3D_ROOT_SIGNATURE_VERSION(1i32);
pub const D3D_ROOT_SIGNATURE_VERSION_1_1: D3D_ROOT_SIGNATURE_VERSION = D3D_ROOT_SIGNATURE_VERSION(2i32);
impl ::std::convert::From<i32> for D3D_ROOT_SIGNATURE_VERSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_ROOT_SIGNATURE_VERSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: marker :: Copy, :: std :: clone :: Clone, :: std :: default :: Default, :: std :: fmt :: Debug)]
#[repr(transparent)]
pub struct D3D_SHADER_MODEL(pub i32);
pub const D3D_SHADER_MODEL_5_1: D3D_SHADER_MODEL = D3D_SHADER_MODEL(81i32);
pub const D3D_SHADER_MODEL_6_0: D3D_SHADER_MODEL = D3D_SHADER_MODEL(96i32);
pub const D3D_SHADER_MODEL_6_1: D3D_SHADER_MODEL = D3D_SHADER_MODEL(97i32);
pub const D3D_SHADER_MODEL_6_2: D3D_SHADER_MODEL = D3D_SHADER_MODEL(98i32);
pub const D3D_SHADER_MODEL_6_3: D3D_SHADER_MODEL = D3D_SHADER_MODEL(99i32);
pub const D3D_SHADER_MODEL_6_4: D3D_SHADER_MODEL = D3D_SHADER_MODEL(100i32);
pub const D3D_SHADER_MODEL_6_5: D3D_SHADER_MODEL = D3D_SHADER_MODEL(101i32);
pub const D3D_SHADER_MODEL_6_6: D3D_SHADER_MODEL = D3D_SHADER_MODEL(102i32);
pub const D3D_SHADER_MODEL_6_7: D3D_SHADER_MODEL = D3D_SHADER_MODEL(103i32);
impl ::std::convert::From<i32> for D3D_SHADER_MODEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SHADER_MODEL {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D_SHADER_REQUIRES_ATOMIC_INT64_ON_DESCRIPTOR_HEAP_RESOURCE: u32 = 268435456u32;
pub const D3D_SHADER_REQUIRES_ATOMIC_INT64_ON_GROUP_SHARED: u32 = 8388608u32;
pub const D3D_SHADER_REQUIRES_ATOMIC_INT64_ON_TYPED_RESOURCE: u32 = 4194304u32;
pub const D3D_SHADER_REQUIRES_BARYCENTRICS: u32 = 131072u32;
pub const D3D_SHADER_REQUIRES_DERIVATIVES_IN_MESH_AND_AMPLIFICATION_SHADERS: u32 = 16777216u32;
pub const D3D_SHADER_REQUIRES_INNER_COVERAGE: u32 = 1024u32;
pub const D3D_SHADER_REQUIRES_INT64_OPS: u32 = 32768u32;
pub const D3D_SHADER_REQUIRES_NATIVE_16BIT_OPS: u32 = 262144u32;
pub const D3D_SHADER_REQUIRES_RAYTRACING_TIER_1_1: u32 = 1048576u32;
pub const D3D_SHADER_REQUIRES_RESOURCE_DESCRIPTOR_HEAP_INDEXING: u32 = 33554432u32;
pub const D3D_SHADER_REQUIRES_ROVS: u32 = 4096u32;
pub const D3D_SHADER_REQUIRES_SAMPLER_DESCRIPTOR_HEAP_INDEXING: u32 = 67108864u32;
pub const D3D_SHADER_REQUIRES_SAMPLER_FEEDBACK: u32 = 2097152u32;
pub const D3D_SHADER_REQUIRES_SHADING_RATE: u32 = 524288u32;
pub const D3D_SHADER_REQUIRES_STENCIL_REF: u32 = 512u32;
pub const D3D_SHADER_REQUIRES_TYPED_UAV_LOAD_ADDITIONAL_FORMATS: u32 = 2048u32;
pub const D3D_SHADER_REQUIRES_VIEWPORT_AND_RT_ARRAY_INDEX_FROM_ANY_SHADER_FEEDING_RASTERIZER: u32 = 8192u32;
pub const D3D_SHADER_REQUIRES_VIEW_ID: u32 = 65536u32;
pub const D3D_SHADER_REQUIRES_WAVE_MMA: u32 = 134217728u32;
pub const D3D_SHADER_REQUIRES_WAVE_OPS: u32 = 16384u32;
pub const DXGI_DEBUG_D3D12: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3478759820, 43344, 17190, [145, 239, 155, 186, 161, 123, 253, 149]);
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9"))]
#[inline]
pub unsafe fn Direct3DCreate9On12(sdkversion: u32, poverridelist: *mut D3D9ON12_ARGS, numoverrideentries: u32) -> ::std::option::Option<super::Direct3D9::IDirect3D9> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn Direct3DCreate9On12(sdkversion: u32, poverridelist: *mut ::std::mem::ManuallyDrop<D3D9ON12_ARGS>, numoverrideentries: u32) -> ::std::option::Option<super::Direct3D9::IDirect3D9>;
        }
        ::std::mem::transmute(Direct3DCreate9On12(::std::mem::transmute(sdkversion), ::std::mem::transmute(poverridelist), ::std::mem::transmute(numoverrideentries)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Direct3D9"))]
#[inline]
pub unsafe fn Direct3DCreate9On12Ex(sdkversion: u32, poverridelist: *mut D3D9ON12_ARGS, numoverrideentries: u32, ppoutputinterface: *mut ::std::option::Option<super::Direct3D9::IDirect3D9Ex>) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn Direct3DCreate9On12Ex(sdkversion: u32, poverridelist: *mut ::std::mem::ManuallyDrop<D3D9ON12_ARGS>, numoverrideentries: u32, ppoutputinterface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT;
        }
        Direct3DCreate9On12Ex(::std::mem::transmute(sdkversion), ::std::mem::transmute(poverridelist), ::std::mem::transmute(numoverrideentries), ::std::mem::transmute(ppoutputinterface)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct DirectMLTensorFlowCreatorID(::windows::runtime::IUnknown);
impl DirectMLTensorFlowCreatorID {}
unsafe impl ::windows::runtime::Interface for DirectMLTensorFlowCreatorID {
    type Vtable = DirectMLTensorFlowCreatorID_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3413414060, 35343, 17644, [155, 123, 111, 76, 175, 232, 233, 171]);
}
impl ::std::convert::From<DirectMLTensorFlowCreatorID> for ::windows::runtime::IUnknown {
    fn from(value: DirectMLTensorFlowCreatorID) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&DirectMLTensorFlowCreatorID> for ::windows::runtime::IUnknown {
    fn from(value: &DirectMLTensorFlowCreatorID) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for DirectMLTensorFlowCreatorID {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &DirectMLTensorFlowCreatorID {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct DirectMLTensorFlowCreatorID_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D11On12Device(::windows::runtime::IUnknown);
impl ID3D11On12Device {
    pub unsafe fn CreateWrappedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>, T: ::windows::runtime::Interface>(&self, presource12: Param0, pflags11: *const D3D11_RESOURCE_FLAGS, instate: D3D12_RESOURCE_STATES, outstate: D3D12_RESOURCE_STATES, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), presource12.into_param().abi(), ::std::mem::transmute(pflags11), ::std::mem::transmute(instate), ::std::mem::transmute(outstate), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn ReleaseWrappedResources(&self, ppresources: *const ::std::option::Option<super::Direct3D11::ID3D11Resource>, numresources: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppresources), ::std::mem::transmute(numresources)))
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn AcquireWrappedResources(&self, ppresources: *const ::std::option::Option<super::Direct3D11::ID3D11Resource>, numresources: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppresources), ::std::mem::transmute(numresources)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11On12Device {
    type Vtable = ID3D11On12Device_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2237734515, 28841, 18702, [150, 20, 169, 227, 2, 119, 121, 4]);
}
impl ::std::convert::From<ID3D11On12Device> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11On12Device) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11On12Device> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11On12Device) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11On12Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11On12Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11On12Device_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource12: ::windows::runtime::RawPtr, pflags11: *const D3D11_RESOURCE_FLAGS, instate: D3D12_RESOURCE_STATES, outstate: D3D12_RESOURCE_STATES, riid: *const ::windows::runtime::GUID, ppresource11: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppresources: *const ::windows::runtime::RawPtr, numresources: u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppresources: *const ::windows::runtime::RawPtr, numresources: u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D11On12Device1(::windows::runtime::IUnknown);
impl ID3D11On12Device1 {
    pub unsafe fn CreateWrappedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>, T: ::windows::runtime::Interface>(&self, presource12: Param0, pflags11: *const D3D11_RESOURCE_FLAGS, instate: D3D12_RESOURCE_STATES, outstate: D3D12_RESOURCE_STATES, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), presource12.into_param().abi(), ::std::mem::transmute(pflags11), ::std::mem::transmute(instate), ::std::mem::transmute(outstate), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn ReleaseWrappedResources(&self, ppresources: *const ::std::option::Option<super::Direct3D11::ID3D11Resource>, numresources: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppresources), ::std::mem::transmute(numresources)))
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn AcquireWrappedResources(&self, ppresources: *const ::std::option::Option<super::Direct3D11::ID3D11Resource>, numresources: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppresources), ::std::mem::transmute(numresources)))
    }
    pub unsafe fn GetD3D12Device<T: ::windows::runtime::Interface>(&self) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11On12Device1 {
    type Vtable = ID3D11On12Device1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3182841332, 59951, 19568, [184, 97, 170, 171, 18, 88, 187, 93]);
}
impl ::std::convert::From<ID3D11On12Device1> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11On12Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11On12Device1> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11On12Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11On12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11On12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D11On12Device1> for ID3D11On12Device {
    fn from(value: ID3D11On12Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11On12Device1> for ID3D11On12Device {
    fn from(value: &ID3D11On12Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11On12Device> for ID3D11On12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11On12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11On12Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11On12Device> for &ID3D11On12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11On12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11On12Device>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11On12Device1_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource12: ::windows::runtime::RawPtr, pflags11: *const D3D11_RESOURCE_FLAGS, instate: D3D12_RESOURCE_STATES, outstate: D3D12_RESOURCE_STATES, riid: *const ::windows::runtime::GUID, ppresource11: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppresources: *const ::windows::runtime::RawPtr, numresources: u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppresources: *const ::windows::runtime::RawPtr, numresources: u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D11On12Device2(::windows::runtime::IUnknown);
impl ID3D11On12Device2 {
    pub unsafe fn CreateWrappedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>, T: ::windows::runtime::Interface>(&self, presource12: Param0, pflags11: *const D3D11_RESOURCE_FLAGS, instate: D3D12_RESOURCE_STATES, outstate: D3D12_RESOURCE_STATES, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), presource12.into_param().abi(), ::std::mem::transmute(pflags11), ::std::mem::transmute(instate), ::std::mem::transmute(outstate), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn ReleaseWrappedResources(&self, ppresources: *const ::std::option::Option<super::Direct3D11::ID3D11Resource>, numresources: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppresources), ::std::mem::transmute(numresources)))
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn AcquireWrappedResources(&self, ppresources: *const ::std::option::Option<super::Direct3D11::ID3D11Resource>, numresources: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppresources), ::std::mem::transmute(numresources)))
    }
    pub unsafe fn GetD3D12Device<T: ::windows::runtime::Interface>(&self) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn UnwrapUnderlyingResource<'a, Param0: ::windows::runtime::IntoParam<'a, super::Direct3D11::ID3D11Resource>, Param1: ::windows::runtime::IntoParam<'a, ID3D12CommandQueue>, T: ::windows::runtime::Interface>(&self, presource11: Param0, pcommandqueue: Param1) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), presource11.into_param().abi(), pcommandqueue.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Graphics_Direct3D11")]
    pub unsafe fn ReturnUnderlyingResource<'a, Param0: ::windows::runtime::IntoParam<'a, super::Direct3D11::ID3D11Resource>>(&self, presource11: Param0, numsync: u32, psignalvalues: *const u64, ppfences: *const ::std::option::Option<ID3D12Fence>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), presource11.into_param().abi(), ::std::mem::transmute(numsync), ::std::mem::transmute(psignalvalues), ::std::mem::transmute(ppfences)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11On12Device2 {
    type Vtable = ID3D11On12Device2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3700486961, 18240, 17402, [134, 110, 103, 241, 44, 181, 130, 35]);
}
impl ::std::convert::From<ID3D11On12Device2> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11On12Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11On12Device2> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11On12Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11On12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11On12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D11On12Device2> for ID3D11On12Device1 {
    fn from(value: ID3D11On12Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11On12Device2> for ID3D11On12Device1 {
    fn from(value: &ID3D11On12Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11On12Device1> for ID3D11On12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11On12Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11On12Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11On12Device1> for &ID3D11On12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11On12Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11On12Device1>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D11On12Device2> for ID3D11On12Device {
    fn from(value: ID3D11On12Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11On12Device2> for ID3D11On12Device {
    fn from(value: &ID3D11On12Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11On12Device> for ID3D11On12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11On12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11On12Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11On12Device> for &ID3D11On12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11On12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11On12Device>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11On12Device2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource12: ::windows::runtime::RawPtr, pflags11: *const D3D11_RESOURCE_FLAGS, instate: D3D12_RESOURCE_STATES, outstate: D3D12_RESOURCE_STATES, riid: *const ::windows::runtime::GUID, ppresource11: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppresources: *const ::windows::runtime::RawPtr, numresources: u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppresources: *const ::windows::runtime::RawPtr, numresources: u32),
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource11: ::windows::runtime::RawPtr, pcommandqueue: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvresource12: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
    #[cfg(feature = "Win32_Graphics_Direct3D11")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource11: ::windows::runtime::RawPtr, numsync: u32, psignalvalues: *const u64, ppfences: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Direct3D11"))] usize,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12CommandAllocator(::windows::runtime::IUnknown);
impl ID3D12CommandAllocator {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetDevice<T: ::windows::runtime::Interface>(&self, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12CommandAllocator {
    type Vtable = ID3D12CommandAllocator_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1627578084, 44889, 19209, [185, 153, 180, 77, 115, 240, 155, 36]);
}
impl ::std::convert::From<ID3D12CommandAllocator> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12CommandAllocator) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandAllocator> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12CommandAllocator) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandAllocator> for ID3D12Pageable {
    fn from(value: ID3D12CommandAllocator) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandAllocator> for ID3D12Pageable {
    fn from(value: &ID3D12CommandAllocator) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for &ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandAllocator> for ID3D12DeviceChild {
    fn from(value: ID3D12CommandAllocator) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandAllocator> for ID3D12DeviceChild {
    fn from(value: &ID3D12CommandAllocator) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for &ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandAllocator> for ID3D12Object {
    fn from(value: ID3D12CommandAllocator) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandAllocator> for ID3D12Object {
    fn from(value: &ID3D12CommandAllocator) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12CommandAllocator {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12CommandAllocator_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12CommandList(::windows::runtime::IUnknown);
impl ID3D12CommandList {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetDevice<T: ::windows::runtime::Interface>(&self, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn GetType(&self) -> D3D12_COMMAND_LIST_TYPE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12CommandList {
    type Vtable = ID3D12CommandList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1897322780, 59364, 18382, [184, 198, 236, 129, 104, 244, 55, 229]);
}
impl ::std::convert::From<ID3D12CommandList> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandList> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandList> for ID3D12DeviceChild {
    fn from(value: ID3D12CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandList> for ID3D12DeviceChild {
    fn from(value: &ID3D12CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for ID3D12CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for &ID3D12CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandList> for ID3D12Object {
    fn from(value: ID3D12CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandList> for ID3D12Object {
    fn from(value: &ID3D12CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12CommandList_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D12_COMMAND_LIST_TYPE,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12CommandQueue(::windows::runtime::IUnknown);
impl ID3D12CommandQueue {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetDevice<T: ::windows::runtime::Interface>(&self, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UpdateTileMappings<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param4: ::windows::runtime::IntoParam<'a, ID3D12Heap>>(
        &self,
        presource: Param0,
        numresourceregions: u32,
        presourceregionstartcoordinates: *const D3D12_TILED_RESOURCE_COORDINATE,
        presourceregionsizes: *const D3D12_TILE_REGION_SIZE,
        pheap: Param4,
        numranges: u32,
        prangeflags: *const D3D12_TILE_RANGE_FLAGS,
        pheaprangestartoffsets: *const u32,
        prangetilecounts: *const u32,
        flags: D3D12_TILE_MAPPING_FLAGS,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(numresourceregions),
            ::std::mem::transmute(presourceregionstartcoordinates),
            ::std::mem::transmute(presourceregionsizes),
            pheap.into_param().abi(),
            ::std::mem::transmute(numranges),
            ::std::mem::transmute(prangeflags),
            ::std::mem::transmute(pheaprangestartoffsets),
            ::std::mem::transmute(prangetilecounts),
            ::std::mem::transmute(flags),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CopyTileMappings<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, pdstresource: Param0, pdstregionstartcoordinate: *const D3D12_TILED_RESOURCE_COORDINATE, psrcresource: Param2, psrcregionstartcoordinate: *const D3D12_TILED_RESOURCE_COORDINATE, pregionsize: *const D3D12_TILE_REGION_SIZE, flags: D3D12_TILE_MAPPING_FLAGS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            pdstresource.into_param().abi(),
            ::std::mem::transmute(pdstregionstartcoordinate),
            psrcresource.into_param().abi(),
            ::std::mem::transmute(psrcregionstartcoordinate),
            ::std::mem::transmute(pregionsize),
            ::std::mem::transmute(flags),
        ))
    }
    pub unsafe fn ExecuteCommandLists(&self, numcommandlists: u32, ppcommandlists: *const ::std::option::Option<ID3D12CommandList>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(numcommandlists), ::std::mem::transmute(ppcommandlists)))
    }
    pub unsafe fn SetMarker(&self, metadata: u32, pdata: *const ::std::ffi::c_void, size: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(metadata), ::std::mem::transmute(pdata), ::std::mem::transmute(size)))
    }
    pub unsafe fn BeginEvent(&self, metadata: u32, pdata: *const ::std::ffi::c_void, size: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(metadata), ::std::mem::transmute(pdata), ::std::mem::transmute(size)))
    }
    pub unsafe fn EndEvent(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn Signal<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Fence>>(&self, pfence: Param0, value: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), pfence.into_param().abi(), ::std::mem::transmute(value)).ok()
    }
    pub unsafe fn Wait<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Fence>>(&self, pfence: Param0, value: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), pfence.into_param().abi(), ::std::mem::transmute(value)).ok()
    }
    pub unsafe fn GetTimestampFrequency(&self) -> ::windows::runtime::Result<u64> {
        let mut result__: <u64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), &mut result__).from_abi::<u64>(result__)
    }
    pub unsafe fn GetClockCalibration(&self, pgputimestamp: *mut u64, pcputimestamp: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pgputimestamp), ::std::mem::transmute(pcputimestamp)).ok()
    }
    pub unsafe fn GetDesc(&self) -> D3D12_COMMAND_QUEUE_DESC {
        let mut result__: D3D12_COMMAND_QUEUE_DESC = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12CommandQueue {
    type Vtable = ID3D12CommandQueue_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(248017062, 23934, 19490, [140, 252, 91, 170, 224, 118, 22, 237]);
}
impl ::std::convert::From<ID3D12CommandQueue> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12CommandQueue) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandQueue> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12CommandQueue) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandQueue> for ID3D12Pageable {
    fn from(value: ID3D12CommandQueue) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandQueue> for ID3D12Pageable {
    fn from(value: &ID3D12CommandQueue) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for &ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandQueue> for ID3D12DeviceChild {
    fn from(value: ID3D12CommandQueue) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandQueue> for ID3D12DeviceChild {
    fn from(value: &ID3D12CommandQueue) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for &ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandQueue> for ID3D12Object {
    fn from(value: ID3D12CommandQueue) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandQueue> for ID3D12Object {
    fn from(value: &ID3D12CommandQueue) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12CommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12CommandQueue_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, numresourceregions: u32, presourceregionstartcoordinates: *const D3D12_TILED_RESOURCE_COORDINATE, presourceregionsizes: *const D3D12_TILE_REGION_SIZE, pheap: ::windows::runtime::RawPtr, numranges: u32, prangeflags: *const D3D12_TILE_RANGE_FLAGS, pheaprangestartoffsets: *const u32, prangetilecounts: *const u32, flags: D3D12_TILE_MAPPING_FLAGS),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdstresource: ::windows::runtime::RawPtr, pdstregionstartcoordinate: *const D3D12_TILED_RESOURCE_COORDINATE, psrcresource: ::windows::runtime::RawPtr, psrcregionstartcoordinate: *const D3D12_TILED_RESOURCE_COORDINATE, pregionsize: *const D3D12_TILE_REGION_SIZE, flags: D3D12_TILE_MAPPING_FLAGS),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numcommandlists: u32, ppcommandlists: *const ::windows::runtime::RawPtr),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadata: u32, pdata: *const ::std::ffi::c_void, size: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, metadata: u32, pdata: *const ::std::ffi::c_void, size: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfence: ::windows::runtime::RawPtr, value: u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfence: ::windows::runtime::RawPtr, value: u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pfrequency: *mut u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pgputimestamp: *mut u64, pcputimestamp: *mut u64) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_COMMAND_QUEUE_DESC),
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12CommandSignature(::windows::runtime::IUnknown);
impl ID3D12CommandSignature {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetDevice<T: ::windows::runtime::Interface>(&self, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12CommandSignature {
    type Vtable = ID3D12CommandSignature_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3278535036, 60544, 20234, [137, 133, 167, 178, 71, 80, 130, 209]);
}
impl ::std::convert::From<ID3D12CommandSignature> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12CommandSignature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandSignature> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12CommandSignature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandSignature> for ID3D12Pageable {
    fn from(value: ID3D12CommandSignature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandSignature> for ID3D12Pageable {
    fn from(value: &ID3D12CommandSignature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for &ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandSignature> for ID3D12DeviceChild {
    fn from(value: ID3D12CommandSignature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandSignature> for ID3D12DeviceChild {
    fn from(value: &ID3D12CommandSignature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for &ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12CommandSignature> for ID3D12Object {
    fn from(value: ID3D12CommandSignature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CommandSignature> for ID3D12Object {
    fn from(value: &ID3D12CommandSignature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12CommandSignature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12CommandSignature_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12CompatibilityDevice(::windows::runtime::IUnknown);
impl ID3D12CompatibilityDevice {
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateSharedResource<'a, Param7: ::windows::runtime::IntoParam<'a, ID3D12LifetimeTracker>, Param8: ::windows::runtime::IntoParam<'a, ID3D12SwapChainAssistant>, T: ::windows::runtime::Interface>(
        &self,
        pheapproperties: *const D3D12_HEAP_PROPERTIES,
        heapflags: D3D12_HEAP_FLAGS,
        pdesc: *const D3D12_RESOURCE_DESC,
        initialresourcestate: D3D12_RESOURCE_STATES,
        poptimizedclearvalue: *const D3D12_CLEAR_VALUE,
        pflags11: *const D3D11_RESOURCE_FLAGS,
        compatibilityflags: D3D12_COMPATIBILITY_SHARED_FLAGS,
        plifetimetracker: Param7,
        powningswapchain: Param8,
        result__: *mut ::std::option::Option<T>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pheapproperties),
            ::std::mem::transmute(heapflags),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(initialresourcestate),
            ::std::mem::transmute(poptimizedclearvalue),
            ::std::mem::transmute(pflags11),
            ::std::mem::transmute(compatibilityflags),
            plifetimetracker.into_param().abi(),
            powningswapchain.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            result__ as *mut _ as *mut _,
        )
        .ok()
    }
    pub unsafe fn CreateSharedHeap<T: ::windows::runtime::Interface>(&self, pheapdesc: *const D3D12_HEAP_DESC, compatibilityflags: D3D12_COMPATIBILITY_SHARED_FLAGS, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(pheapdesc), ::std::mem::transmute(compatibilityflags), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn ReflectSharedProperties<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Object>>(&self, pheaporresource: Param0, reflecttype: D3D12_REFLECT_SHARED_PROPERTY, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), pheaporresource.into_param().abi(), ::std::mem::transmute(reflecttype), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12CompatibilityDevice {
    type Vtable = ID3D12CompatibilityDevice_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2400980540, 64227, 19074, [176, 152, 191, 225, 112, 130, 7, 255]);
}
impl ::std::convert::From<ID3D12CompatibilityDevice> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12CompatibilityDevice) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12CompatibilityDevice> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12CompatibilityDevice) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12CompatibilityDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12CompatibilityDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12CompatibilityDevice_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pheapproperties: *const D3D12_HEAP_PROPERTIES,
        heapflags: D3D12_HEAP_FLAGS,
        pdesc: *const D3D12_RESOURCE_DESC,
        initialresourcestate: D3D12_RESOURCE_STATES,
        poptimizedclearvalue: *const D3D12_CLEAR_VALUE,
        pflags11: *const D3D11_RESOURCE_FLAGS,
        compatibilityflags: D3D12_COMPATIBILITY_SHARED_FLAGS,
        plifetimetracker: ::windows::runtime::RawPtr,
        powningswapchain: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheapdesc: *const D3D12_HEAP_DESC, compatibilityflags: D3D12_COMPATIBILITY_SHARED_FLAGS, riid: *const ::windows::runtime::GUID, ppheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheaporresource: ::windows::runtime::RawPtr, reflecttype: D3D12_REFLECT_SHARED_PROPERTY, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Debug(::windows::runtime::IUnknown);
impl ID3D12Debug {
    pub unsafe fn EnableDebugLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Debug {
    type Vtable = ID3D12Debug_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(876906679, 26694, 18251, [185, 137, 240, 39, 68, 130, 69, 224]);
}
impl ::std::convert::From<ID3D12Debug> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Debug) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Debug) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Debug {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Debug {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Debug_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Debug1(::windows::runtime::IUnknown);
impl ID3D12Debug1 {
    pub unsafe fn EnableDebugLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableGPUBasedValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableSynchronizedCommandQueueValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Debug1 {
    type Vtable = ID3D12Debug1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2952438986, 25598, 19854, [184, 173, 21, 144, 0, 175, 67, 4]);
}
impl ::std::convert::From<ID3D12Debug1> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Debug1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug1> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Debug1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Debug1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Debug1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Debug1_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Debug2(::windows::runtime::IUnknown);
impl ID3D12Debug2 {
    pub unsafe fn SetGPUBasedValidationFlags(&self, flags: D3D12_GPU_BASED_VALIDATION_FLAGS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Debug2 {
    type Vtable = ID3D12Debug2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2477155780, 41906, 20061, [182, 146, 162, 106, 225, 78, 51, 116]);
}
impl ::std::convert::From<ID3D12Debug2> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Debug2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug2> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Debug2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Debug2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Debug2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Debug2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_GPU_BASED_VALIDATION_FLAGS),
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Debug3(::windows::runtime::IUnknown);
impl ID3D12Debug3 {
    pub unsafe fn EnableDebugLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableGPUBasedValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableSynchronizedCommandQueueValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
    pub unsafe fn SetGPUBasedValidationFlags(&self, flags: D3D12_GPU_BASED_VALIDATION_FLAGS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Debug3 {
    type Vtable = ID3D12Debug3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1559553423, 63089, 20465, [165, 66, 54, 134, 227, 209, 83, 209]);
}
impl ::std::convert::From<ID3D12Debug3> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Debug3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug3> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Debug3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Debug3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Debug3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Debug3> for ID3D12Debug {
    fn from(value: ID3D12Debug3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug3> for ID3D12Debug {
    fn from(value: &ID3D12Debug3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug> for ID3D12Debug3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug> for &ID3D12Debug3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Debug3_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_GPU_BASED_VALIDATION_FLAGS),
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Debug4(::windows::runtime::IUnknown);
impl ID3D12Debug4 {
    pub unsafe fn EnableDebugLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableGPUBasedValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableSynchronizedCommandQueueValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
    pub unsafe fn SetGPUBasedValidationFlags(&self, flags: D3D12_GPU_BASED_VALIDATION_FLAGS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)))
    }
    pub unsafe fn DisableDebugLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Debug4 {
    type Vtable = ID3D12Debug4_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(21725550, 40645, 18991, [168, 69, 255, 190, 68, 28, 225, 58]);
}
impl ::std::convert::From<ID3D12Debug4> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Debug4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug4> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Debug4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Debug4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Debug4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Debug4> for ID3D12Debug3 {
    fn from(value: ID3D12Debug4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug4> for ID3D12Debug3 {
    fn from(value: &ID3D12Debug4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug3> for ID3D12Debug4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug3> for &ID3D12Debug4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug3>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Debug4> for ID3D12Debug {
    fn from(value: ID3D12Debug4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug4> for ID3D12Debug {
    fn from(value: &ID3D12Debug4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug> for ID3D12Debug4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug> for &ID3D12Debug4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Debug4_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_GPU_BASED_VALIDATION_FLAGS),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Debug5(::windows::runtime::IUnknown);
impl ID3D12Debug5 {
    pub unsafe fn EnableDebugLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableGPUBasedValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableSynchronizedCommandQueueValidation<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
    pub unsafe fn SetGPUBasedValidationFlags(&self, flags: D3D12_GPU_BASED_VALIDATION_FLAGS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)))
    }
    pub unsafe fn DisableDebugLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEnableAutoName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), enable.into_param().abi()))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Debug5 {
    type Vtable = ID3D12Debug5_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1418554130, 2554, 16608, [144, 105, 93, 205, 88, 154, 82, 201]);
}
impl ::std::convert::From<ID3D12Debug5> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Debug5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug5> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Debug5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Debug5> for ID3D12Debug4 {
    fn from(value: ID3D12Debug5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug5> for ID3D12Debug4 {
    fn from(value: &ID3D12Debug5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug4> for ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug4>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug4> for &ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug4>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Debug5> for ID3D12Debug3 {
    fn from(value: ID3D12Debug5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug5> for ID3D12Debug3 {
    fn from(value: &ID3D12Debug5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug3> for ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug3> for &ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug3>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Debug5> for ID3D12Debug {
    fn from(value: ID3D12Debug5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Debug5> for ID3D12Debug {
    fn from(value: &ID3D12Debug5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug> for ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Debug> for &ID3D12Debug5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Debug> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Debug>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Debug5_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_GPU_BASED_VALIDATION_FLAGS),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DebugCommandList(::windows::runtime::IUnknown);
impl ID3D12DebugCommandList {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssertResourceState<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, presource: Param0, subresource: u32, state: u32) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(subresource), ::std::mem::transmute(state)))
    }
    pub unsafe fn SetFeatureMask(&self, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetFeatureMask(&self) -> D3D12_DEBUG_FEATURE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DebugCommandList {
    type Vtable = ID3D12DebugCommandList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(165723958, 21676, 18511, [136, 71, 75, 174, 234, 182, 5, 63]);
}
impl ::std::convert::From<ID3D12DebugCommandList> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DebugCommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugCommandList> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DebugCommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DebugCommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DebugCommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DebugCommandList_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, subresource: u32, state: u32) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D12_DEBUG_FEATURE,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DebugCommandList1(::windows::runtime::IUnknown);
impl ID3D12DebugCommandList1 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssertResourceState<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, presource: Param0, subresource: u32, state: u32) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(subresource), ::std::mem::transmute(state)))
    }
    pub unsafe fn SetDebugParameter(&self, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
    pub unsafe fn GetDebugParameter(&self, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DebugCommandList1 {
    type Vtable = ID3D12DebugCommandList1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(271362385, 12571, 19201, [177, 31, 236, 184, 62, 6, 27, 55]);
}
impl ::std::convert::From<ID3D12DebugCommandList1> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DebugCommandList1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugCommandList1> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DebugCommandList1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DebugCommandList1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DebugCommandList1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DebugCommandList1_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, subresource: u32, state: u32) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DebugCommandList2(::windows::runtime::IUnknown);
impl ID3D12DebugCommandList2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssertResourceState<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, presource: Param0, subresource: u32, state: u32) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(subresource), ::std::mem::transmute(state)))
    }
    pub unsafe fn SetFeatureMask(&self, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetFeatureMask(&self) -> D3D12_DEBUG_FEATURE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn SetDebugParameter(&self, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
    pub unsafe fn GetDebugParameter(&self, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DebugCommandList2 {
    type Vtable = ID3D12DebugCommandList2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2931127759, 19974, 18622, [186, 59, 196, 80, 252, 150, 101, 46]);
}
impl ::std::convert::From<ID3D12DebugCommandList2> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DebugCommandList2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugCommandList2> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DebugCommandList2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DebugCommandList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DebugCommandList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12DebugCommandList2> for ID3D12DebugCommandList {
    fn from(value: ID3D12DebugCommandList2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugCommandList2> for ID3D12DebugCommandList {
    fn from(value: &ID3D12DebugCommandList2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DebugCommandList> for ID3D12DebugCommandList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DebugCommandList> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DebugCommandList>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DebugCommandList> for &ID3D12DebugCommandList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DebugCommandList> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DebugCommandList>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DebugCommandList2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, subresource: u32, state: u32) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D12_DEBUG_FEATURE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_COMMAND_LIST_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DebugCommandQueue(::windows::runtime::IUnknown);
impl ID3D12DebugCommandQueue {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssertResourceState<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, presource: Param0, subresource: u32, state: u32) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(subresource), ::std::mem::transmute(state)))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DebugCommandQueue {
    type Vtable = ID3D12DebugCommandQueue_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(165723958, 21676, 18511, [136, 71, 75, 174, 234, 182, 5, 58]);
}
impl ::std::convert::From<ID3D12DebugCommandQueue> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DebugCommandQueue) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugCommandQueue> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DebugCommandQueue) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DebugCommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DebugCommandQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DebugCommandQueue_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, subresource: u32, state: u32) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DebugDevice(::windows::runtime::IUnknown);
impl ID3D12DebugDevice {
    pub unsafe fn SetFeatureMask(&self, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetFeatureMask(&self) -> D3D12_DEBUG_FEATURE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn ReportLiveDeviceObjects(&self, flags: D3D12_RLDO_FLAGS) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DebugDevice {
    type Vtable = ID3D12DebugDevice_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1072420573, 18803, 18311, [129, 148, 228, 95, 158, 40, 146, 62]);
}
impl ::std::convert::From<ID3D12DebugDevice> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DebugDevice) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugDevice> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DebugDevice) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DebugDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DebugDevice {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DebugDevice_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D12_DEBUG_FEATURE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_RLDO_FLAGS) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DebugDevice1(::windows::runtime::IUnknown);
impl ID3D12DebugDevice1 {
    pub unsafe fn SetDebugParameter(&self, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
    pub unsafe fn GetDebugParameter(&self, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
    pub unsafe fn ReportLiveDeviceObjects(&self, flags: D3D12_RLDO_FLAGS) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DebugDevice1 {
    type Vtable = ID3D12DebugDevice1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2847348592, 53401, 19045, [166, 152, 61, 238, 16, 2, 15, 136]);
}
impl ::std::convert::From<ID3D12DebugDevice1> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DebugDevice1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugDevice1> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DebugDevice1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DebugDevice1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DebugDevice1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DebugDevice1_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_RLDO_FLAGS) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DebugDevice2(::windows::runtime::IUnknown);
impl ID3D12DebugDevice2 {
    pub unsafe fn SetFeatureMask(&self, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(mask)).ok()
    }
    pub unsafe fn GetFeatureMask(&self) -> D3D12_DEBUG_FEATURE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn ReportLiveDeviceObjects(&self, flags: D3D12_RLDO_FLAGS) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags)).ok()
    }
    pub unsafe fn SetDebugParameter(&self, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
    pub unsafe fn GetDebugParameter(&self, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), ::std::mem::transmute(pdata), ::std::mem::transmute(datasize)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DebugDevice2 {
    type Vtable = ID3D12DebugDevice2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(1626131393, 14221, 19953, [137, 76, 248, 172, 92, 228, 215, 221]);
}
impl ::std::convert::From<ID3D12DebugDevice2> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DebugDevice2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugDevice2> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DebugDevice2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DebugDevice2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DebugDevice2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12DebugDevice2> for ID3D12DebugDevice {
    fn from(value: ID3D12DebugDevice2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DebugDevice2> for ID3D12DebugDevice {
    fn from(value: &ID3D12DebugDevice2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DebugDevice> for ID3D12DebugDevice2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DebugDevice> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DebugDevice>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DebugDevice> for &ID3D12DebugDevice2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DebugDevice> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DebugDevice>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DebugDevice2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, mask: D3D12_DEBUG_FEATURE) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D12_DEBUG_FEATURE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_RLDO_FLAGS) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *const ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_DEBUG_DEVICE_PARAMETER_TYPE, pdata: *mut ::std::ffi::c_void, datasize: u32) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12DescriptorHeap(::windows::runtime::IUnknown);
impl ID3D12DescriptorHeap {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetDevice<T: ::windows::runtime::Interface>(&self, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn GetDesc(&self) -> D3D12_DESCRIPTOR_HEAP_DESC {
        let mut result__: D3D12_DESCRIPTOR_HEAP_DESC = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
    pub unsafe fn GetCPUDescriptorHandleForHeapStart(&self) -> D3D12_CPU_DESCRIPTOR_HANDLE {
        let mut result__: D3D12_CPU_DESCRIPTOR_HANDLE = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
    pub unsafe fn GetGPUDescriptorHandleForHeapStart(&self) -> D3D12_GPU_DESCRIPTOR_HANDLE {
        let mut result__: D3D12_GPU_DESCRIPTOR_HANDLE = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12DescriptorHeap {
    type Vtable = ID3D12DescriptorHeap_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2398832413, 24940, 20297, [144, 247, 18, 123, 183, 99, 250, 81]);
}
impl ::std::convert::From<ID3D12DescriptorHeap> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12DescriptorHeap) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DescriptorHeap> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12DescriptorHeap) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12DescriptorHeap> for ID3D12Pageable {
    fn from(value: ID3D12DescriptorHeap) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DescriptorHeap> for ID3D12Pageable {
    fn from(value: &ID3D12DescriptorHeap) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Pageable> for &ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Pageable> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Pageable>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12DescriptorHeap> for ID3D12DeviceChild {
    fn from(value: ID3D12DescriptorHeap) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DescriptorHeap> for ID3D12DeviceChild {
    fn from(value: &ID3D12DescriptorHeap) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12DeviceChild> for &ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12DeviceChild>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12DescriptorHeap> for ID3D12Object {
    fn from(value: ID3D12DescriptorHeap) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12DescriptorHeap> for ID3D12Object {
    fn from(value: &ID3D12DescriptorHeap) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12DescriptorHeap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12DescriptorHeap_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvdevice: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_DESCRIPTOR_HEAP_DESC),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_CPU_DESCRIPTOR_HANDLE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_GPU_DESCRIPTOR_HANDLE),
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Device(::windows::runtime::IUnknown);
impl ID3D12Device {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetNodeCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn CreateCommandQueue<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_QUEUE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandAllocator<T: ::windows::runtime::Interface>(&self, r#type: D3D12_COMMAND_LIST_TYPE) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateGraphicsPipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateComputePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandList<'a, Param2: ::windows::runtime::IntoParam<'a, ID3D12CommandAllocator>, Param3: ::windows::runtime::IntoParam<'a, ID3D12PipelineState>, T: ::windows::runtime::Interface>(&self, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: Param2, pinitialstate: Param3) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(r#type), pcommandallocator.into_param().abi(), pinitialstate.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CheckFeatureSupport(&self, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(feature), ::std::mem::transmute(pfeaturesupportdata), ::std::mem::transmute(featuresupportdatasize)).ok()
    }
    pub unsafe fn CreateDescriptorHeap<T: ::windows::runtime::Interface>(&self, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdescriptorheapdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDescriptorHandleIncrementSize(&self, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(descriptorheaptype)))
    }
    pub unsafe fn CreateRootSignature<T: ::windows::runtime::Interface>(&self, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(pblobwithrootsignature), ::std::mem::transmute(bloblengthinbytes), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateConstantBufferView<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param1: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param3: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pcounterresource: Param1, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: Param3) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), presource.into_param().abi(), pcounterresource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CreateSampler<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CopyDescriptors(&self, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(numdestdescriptorranges),
            ::std::mem::transmute(pdestdescriptorrangestarts),
            ::std::mem::transmute(pdestdescriptorrangesizes),
            ::std::mem::transmute(numsrcdescriptorranges),
            ::std::mem::transmute(psrcdescriptorrangestarts),
            ::std::mem::transmute(psrcdescriptorrangesizes),
            ::std::mem::transmute(descriptorheapstype),
        ))
    }
    pub unsafe fn CopyDescriptorsSimple<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, numdescriptors: u32, destdescriptorrangestart: Param1, srcdescriptorrangestart: Param2, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(numdescriptors), destdescriptorrangestart.into_param().abi(), srcdescriptorrangestart.into_param().abi(), ::std::mem::transmute(descriptorheapstype)))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetResourceAllocationInfo(&self, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC) -> D3D12_RESOURCE_ALLOCATION_INFO {
        let mut result__: D3D12_RESOURCE_ALLOCATION_INFO = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(visiblemask), ::std::mem::transmute(numresourcedescs), ::std::mem::transmute(presourcedescs));
        result__
    }
    pub unsafe fn GetCustomHeapProperties(&self, nodemask: u32, heaptype: D3D12_HEAP_TYPE) -> D3D12_HEAP_PROPERTIES {
        let mut result__: D3D12_HEAP_PROPERTIES = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(nodemask), ::std::mem::transmute(heaptype));
        result__
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCommittedResource<T: ::windows::runtime::Interface>(&self, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(pheapproperties), ::std::mem::transmute(heapflags), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialresourcestate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn CreateHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreatePlacedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Heap>, T: ::windows::runtime::Interface>(&self, pheap: Param0, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), pheap.into_param().abi(), ::std::mem::transmute(heapoffset), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateReservedResource<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub unsafe fn CreateSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12DeviceChild>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pobject: Param0, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: Param3) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(::std::mem::transmute_copy(self), pobject.into_param().abi(), ::std::mem::transmute(pattributes), ::std::mem::transmute(access), name.into_param().abi(), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>, T: ::windows::runtime::Interface>(&self, nthandle: Param0, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(::std::mem::transmute_copy(self), nthandle.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandleByName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0, access: u32) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(::std::mem::transmute_copy(self), name.into_param().abi(), ::std::mem::transmute(access), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    pub unsafe fn MakeResident(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn Evict(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn CreateFence<T: ::windows::runtime::Interface>(&self, initialvalue: u64, flags: D3D12_FENCE_FLAGS) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).36)(::std::mem::transmute_copy(self), ::std::mem::transmute(initialvalue), ::std::mem::transmute(flags), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetCopyableFootprints(&self, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(presourcedesc),
            ::std::mem::transmute(firstsubresource),
            ::std::mem::transmute(numsubresources),
            ::std::mem::transmute(baseoffset),
            ::std::mem::transmute(playouts),
            ::std::mem::transmute(pnumrows),
            ::std::mem::transmute(prowsizeinbytes),
            ::std::mem::transmute(ptotalbytes),
        ))
    }
    pub unsafe fn CreateQueryHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_QUERY_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStablePowerState<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(::std::mem::transmute_copy(self), enable.into_param().abi()).ok()
    }
    pub unsafe fn CreateCommandSignature<'a, Param1: ::windows::runtime::IntoParam<'a, ID3D12RootSignature>, T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: Param1, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), prootsignature.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn GetResourceTiling<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, ptiledresource: Param0, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ptiledresource.into_param().abi(),
            ::std::mem::transmute(pnumtilesforentireresource),
            ::std::mem::transmute(ppackedmipdesc),
            ::std::mem::transmute(pstandardtileshapefornonpackedmips),
            ::std::mem::transmute(pnumsubresourcetilings),
            ::std::mem::transmute(firstsubresourcetilingtoget),
            ::std::mem::transmute(psubresourcetilingsfornonpackedmips),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAdapterLuid(&self) -> super::super::Foundation::LUID {
        let mut result__: super::super::Foundation::LUID = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Device {
    type Vtable = ID3D12Device_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(412621297, 7606, 19287, [190, 84, 24, 33, 51, 155, 133, 247]);
}
impl ::std::convert::From<ID3D12Device> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Device) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Device) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device> for ID3D12Object {
    fn from(value: ID3D12Device) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device> for ID3D12Object {
    fn from(value: &ID3D12Device) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Device_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_QUEUE_DESC, riid: *const ::windows::runtime::GUID, ppcommandqueue: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_COMMAND_LIST_TYPE, riid: *const ::windows::runtime::GUID, ppcommandallocator: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_GRAPHICS_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_COMPUTE_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: ::windows::runtime::RawPtr, pinitialstate: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppcommandlist: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize, riid: *const ::windows::runtime::GUID, ppvrootsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pcounterresource: ::windows::runtime::RawPtr, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdescriptors: u32, destdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, srcdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_RESOURCE_ALLOCATION_INFO, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_HEAP_PROPERTIES, nodemask: u32, heaptype: D3D12_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riidresource: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheap: ::windows::runtime::RawPtr, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pobject: ::windows::runtime::RawPtr, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: super::super::Foundation::PWSTR, phandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nthandle: super::super::Foundation::HANDLE, riid: *const ::windows::runtime::GUID, ppvobj: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR, access: u32, pnthandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, initialvalue: u64, flags: D3D12_FENCE_FLAGS, riid: *const ::windows::runtime::GUID, ppfence: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_QUERY_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvcommandsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptiledresource: ::windows::runtime::RawPtr, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut super::super::Foundation::LUID),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Device1(::windows::runtime::IUnknown);
impl ID3D12Device1 {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetNodeCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn CreateCommandQueue<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_QUEUE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandAllocator<T: ::windows::runtime::Interface>(&self, r#type: D3D12_COMMAND_LIST_TYPE) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateGraphicsPipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateComputePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandList<'a, Param2: ::windows::runtime::IntoParam<'a, ID3D12CommandAllocator>, Param3: ::windows::runtime::IntoParam<'a, ID3D12PipelineState>, T: ::windows::runtime::Interface>(&self, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: Param2, pinitialstate: Param3) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(r#type), pcommandallocator.into_param().abi(), pinitialstate.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CheckFeatureSupport(&self, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(feature), ::std::mem::transmute(pfeaturesupportdata), ::std::mem::transmute(featuresupportdatasize)).ok()
    }
    pub unsafe fn CreateDescriptorHeap<T: ::windows::runtime::Interface>(&self, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdescriptorheapdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDescriptorHandleIncrementSize(&self, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(descriptorheaptype)))
    }
    pub unsafe fn CreateRootSignature<T: ::windows::runtime::Interface>(&self, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(pblobwithrootsignature), ::std::mem::transmute(bloblengthinbytes), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateConstantBufferView<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param1: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param3: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pcounterresource: Param1, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: Param3) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), presource.into_param().abi(), pcounterresource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CreateSampler<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CopyDescriptors(&self, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(numdestdescriptorranges),
            ::std::mem::transmute(pdestdescriptorrangestarts),
            ::std::mem::transmute(pdestdescriptorrangesizes),
            ::std::mem::transmute(numsrcdescriptorranges),
            ::std::mem::transmute(psrcdescriptorrangestarts),
            ::std::mem::transmute(psrcdescriptorrangesizes),
            ::std::mem::transmute(descriptorheapstype),
        ))
    }
    pub unsafe fn CopyDescriptorsSimple<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, numdescriptors: u32, destdescriptorrangestart: Param1, srcdescriptorrangestart: Param2, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(numdescriptors), destdescriptorrangestart.into_param().abi(), srcdescriptorrangestart.into_param().abi(), ::std::mem::transmute(descriptorheapstype)))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetResourceAllocationInfo(&self, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC) -> D3D12_RESOURCE_ALLOCATION_INFO {
        let mut result__: D3D12_RESOURCE_ALLOCATION_INFO = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(visiblemask), ::std::mem::transmute(numresourcedescs), ::std::mem::transmute(presourcedescs));
        result__
    }
    pub unsafe fn GetCustomHeapProperties(&self, nodemask: u32, heaptype: D3D12_HEAP_TYPE) -> D3D12_HEAP_PROPERTIES {
        let mut result__: D3D12_HEAP_PROPERTIES = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(nodemask), ::std::mem::transmute(heaptype));
        result__
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCommittedResource<T: ::windows::runtime::Interface>(&self, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(pheapproperties), ::std::mem::transmute(heapflags), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialresourcestate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn CreateHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreatePlacedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Heap>, T: ::windows::runtime::Interface>(&self, pheap: Param0, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), pheap.into_param().abi(), ::std::mem::transmute(heapoffset), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateReservedResource<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub unsafe fn CreateSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12DeviceChild>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pobject: Param0, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: Param3) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(::std::mem::transmute_copy(self), pobject.into_param().abi(), ::std::mem::transmute(pattributes), ::std::mem::transmute(access), name.into_param().abi(), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>, T: ::windows::runtime::Interface>(&self, nthandle: Param0, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(::std::mem::transmute_copy(self), nthandle.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandleByName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0, access: u32) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(::std::mem::transmute_copy(self), name.into_param().abi(), ::std::mem::transmute(access), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    pub unsafe fn MakeResident(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn Evict(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn CreateFence<T: ::windows::runtime::Interface>(&self, initialvalue: u64, flags: D3D12_FENCE_FLAGS) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).36)(::std::mem::transmute_copy(self), ::std::mem::transmute(initialvalue), ::std::mem::transmute(flags), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetCopyableFootprints(&self, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(presourcedesc),
            ::std::mem::transmute(firstsubresource),
            ::std::mem::transmute(numsubresources),
            ::std::mem::transmute(baseoffset),
            ::std::mem::transmute(playouts),
            ::std::mem::transmute(pnumrows),
            ::std::mem::transmute(prowsizeinbytes),
            ::std::mem::transmute(ptotalbytes),
        ))
    }
    pub unsafe fn CreateQueryHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_QUERY_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStablePowerState<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(::std::mem::transmute_copy(self), enable.into_param().abi()).ok()
    }
    pub unsafe fn CreateCommandSignature<'a, Param1: ::windows::runtime::IntoParam<'a, ID3D12RootSignature>, T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: Param1, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), prootsignature.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn GetResourceTiling<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, ptiledresource: Param0, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ptiledresource.into_param().abi(),
            ::std::mem::transmute(pnumtilesforentireresource),
            ::std::mem::transmute(ppackedmipdesc),
            ::std::mem::transmute(pstandardtileshapefornonpackedmips),
            ::std::mem::transmute(pnumsubresourcetilings),
            ::std::mem::transmute(firstsubresourcetilingtoget),
            ::std::mem::transmute(psubresourcetilingsfornonpackedmips),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAdapterLuid(&self) -> super::super::Foundation::LUID {
        let mut result__: super::super::Foundation::LUID = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
    pub unsafe fn CreatePipelineLibrary<T: ::windows::runtime::Interface>(&self, plibraryblob: *const ::std::ffi::c_void, bloblength: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).44)(::std::mem::transmute_copy(self), ::std::mem::transmute(plibraryblob), ::std::mem::transmute(bloblength), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEventOnMultipleFenceCompletion<'a, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, ppfences: *const ::std::option::Option<ID3D12Fence>, pfencevalues: *const u64, numfences: u32, flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS, hevent: Param4) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).45)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppfences), ::std::mem::transmute(pfencevalues), ::std::mem::transmute(numfences), ::std::mem::transmute(flags), hevent.into_param().abi()).ok()
    }
    pub unsafe fn SetResidencyPriority(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>, ppriorities: *const D3D12_RESIDENCY_PRIORITY) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects), ::std::mem::transmute(ppriorities)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Device1 {
    type Vtable = ID3D12Device1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2007813760, 25486, 20069, [136, 149, 193, 242, 51, 134, 134, 62]);
}
impl ::std::convert::From<ID3D12Device1> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device1> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device1> for ID3D12Device {
    fn from(value: ID3D12Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device1> for ID3D12Device {
    fn from(value: &ID3D12Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device> for ID3D12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device> for &ID3D12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device1> for ID3D12Object {
    fn from(value: ID3D12Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device1> for ID3D12Object {
    fn from(value: &ID3D12Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Device1_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_QUEUE_DESC, riid: *const ::windows::runtime::GUID, ppcommandqueue: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_COMMAND_LIST_TYPE, riid: *const ::windows::runtime::GUID, ppcommandallocator: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_GRAPHICS_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_COMPUTE_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: ::windows::runtime::RawPtr, pinitialstate: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppcommandlist: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize, riid: *const ::windows::runtime::GUID, ppvrootsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pcounterresource: ::windows::runtime::RawPtr, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdescriptors: u32, destdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, srcdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_RESOURCE_ALLOCATION_INFO, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_HEAP_PROPERTIES, nodemask: u32, heaptype: D3D12_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riidresource: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheap: ::windows::runtime::RawPtr, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pobject: ::windows::runtime::RawPtr, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: super::super::Foundation::PWSTR, phandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nthandle: super::super::Foundation::HANDLE, riid: *const ::windows::runtime::GUID, ppvobj: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR, access: u32, pnthandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, initialvalue: u64, flags: D3D12_FENCE_FLAGS, riid: *const ::windows::runtime::GUID, ppfence: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_QUERY_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvcommandsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptiledresource: ::windows::runtime::RawPtr, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut super::super::Foundation::LUID),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plibraryblob: *const ::std::ffi::c_void, bloblength: usize, riid: *const ::windows::runtime::GUID, pppipelinelibrary: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppfences: *const ::windows::runtime::RawPtr, pfencevalues: *const u64, numfences: u32, flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS, hevent: super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr, ppriorities: *const D3D12_RESIDENCY_PRIORITY) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Device2(::windows::runtime::IUnknown);
impl ID3D12Device2 {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetNodeCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn CreateCommandQueue<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_QUEUE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandAllocator<T: ::windows::runtime::Interface>(&self, r#type: D3D12_COMMAND_LIST_TYPE) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateGraphicsPipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateComputePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandList<'a, Param2: ::windows::runtime::IntoParam<'a, ID3D12CommandAllocator>, Param3: ::windows::runtime::IntoParam<'a, ID3D12PipelineState>, T: ::windows::runtime::Interface>(&self, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: Param2, pinitialstate: Param3) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(r#type), pcommandallocator.into_param().abi(), pinitialstate.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CheckFeatureSupport(&self, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(feature), ::std::mem::transmute(pfeaturesupportdata), ::std::mem::transmute(featuresupportdatasize)).ok()
    }
    pub unsafe fn CreateDescriptorHeap<T: ::windows::runtime::Interface>(&self, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdescriptorheapdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDescriptorHandleIncrementSize(&self, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(descriptorheaptype)))
    }
    pub unsafe fn CreateRootSignature<T: ::windows::runtime::Interface>(&self, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(pblobwithrootsignature), ::std::mem::transmute(bloblengthinbytes), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateConstantBufferView<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param1: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param3: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pcounterresource: Param1, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: Param3) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), presource.into_param().abi(), pcounterresource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CreateSampler<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CopyDescriptors(&self, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(numdestdescriptorranges),
            ::std::mem::transmute(pdestdescriptorrangestarts),
            ::std::mem::transmute(pdestdescriptorrangesizes),
            ::std::mem::transmute(numsrcdescriptorranges),
            ::std::mem::transmute(psrcdescriptorrangestarts),
            ::std::mem::transmute(psrcdescriptorrangesizes),
            ::std::mem::transmute(descriptorheapstype),
        ))
    }
    pub unsafe fn CopyDescriptorsSimple<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, numdescriptors: u32, destdescriptorrangestart: Param1, srcdescriptorrangestart: Param2, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(numdescriptors), destdescriptorrangestart.into_param().abi(), srcdescriptorrangestart.into_param().abi(), ::std::mem::transmute(descriptorheapstype)))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetResourceAllocationInfo(&self, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC) -> D3D12_RESOURCE_ALLOCATION_INFO {
        let mut result__: D3D12_RESOURCE_ALLOCATION_INFO = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(visiblemask), ::std::mem::transmute(numresourcedescs), ::std::mem::transmute(presourcedescs));
        result__
    }
    pub unsafe fn GetCustomHeapProperties(&self, nodemask: u32, heaptype: D3D12_HEAP_TYPE) -> D3D12_HEAP_PROPERTIES {
        let mut result__: D3D12_HEAP_PROPERTIES = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(nodemask), ::std::mem::transmute(heaptype));
        result__
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCommittedResource<T: ::windows::runtime::Interface>(&self, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(pheapproperties), ::std::mem::transmute(heapflags), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialresourcestate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn CreateHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreatePlacedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Heap>, T: ::windows::runtime::Interface>(&self, pheap: Param0, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), pheap.into_param().abi(), ::std::mem::transmute(heapoffset), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateReservedResource<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub unsafe fn CreateSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12DeviceChild>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pobject: Param0, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: Param3) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(::std::mem::transmute_copy(self), pobject.into_param().abi(), ::std::mem::transmute(pattributes), ::std::mem::transmute(access), name.into_param().abi(), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>, T: ::windows::runtime::Interface>(&self, nthandle: Param0, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(::std::mem::transmute_copy(self), nthandle.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandleByName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0, access: u32) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(::std::mem::transmute_copy(self), name.into_param().abi(), ::std::mem::transmute(access), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    pub unsafe fn MakeResident(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn Evict(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn CreateFence<T: ::windows::runtime::Interface>(&self, initialvalue: u64, flags: D3D12_FENCE_FLAGS) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).36)(::std::mem::transmute_copy(self), ::std::mem::transmute(initialvalue), ::std::mem::transmute(flags), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetCopyableFootprints(&self, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(presourcedesc),
            ::std::mem::transmute(firstsubresource),
            ::std::mem::transmute(numsubresources),
            ::std::mem::transmute(baseoffset),
            ::std::mem::transmute(playouts),
            ::std::mem::transmute(pnumrows),
            ::std::mem::transmute(prowsizeinbytes),
            ::std::mem::transmute(ptotalbytes),
        ))
    }
    pub unsafe fn CreateQueryHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_QUERY_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStablePowerState<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(::std::mem::transmute_copy(self), enable.into_param().abi()).ok()
    }
    pub unsafe fn CreateCommandSignature<'a, Param1: ::windows::runtime::IntoParam<'a, ID3D12RootSignature>, T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: Param1, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), prootsignature.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn GetResourceTiling<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, ptiledresource: Param0, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ptiledresource.into_param().abi(),
            ::std::mem::transmute(pnumtilesforentireresource),
            ::std::mem::transmute(ppackedmipdesc),
            ::std::mem::transmute(pstandardtileshapefornonpackedmips),
            ::std::mem::transmute(pnumsubresourcetilings),
            ::std::mem::transmute(firstsubresourcetilingtoget),
            ::std::mem::transmute(psubresourcetilingsfornonpackedmips),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAdapterLuid(&self) -> super::super::Foundation::LUID {
        let mut result__: super::super::Foundation::LUID = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
    pub unsafe fn CreatePipelineLibrary<T: ::windows::runtime::Interface>(&self, plibraryblob: *const ::std::ffi::c_void, bloblength: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).44)(::std::mem::transmute_copy(self), ::std::mem::transmute(plibraryblob), ::std::mem::transmute(bloblength), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEventOnMultipleFenceCompletion<'a, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, ppfences: *const ::std::option::Option<ID3D12Fence>, pfencevalues: *const u64, numfences: u32, flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS, hevent: Param4) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).45)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppfences), ::std::mem::transmute(pfencevalues), ::std::mem::transmute(numfences), ::std::mem::transmute(flags), hevent.into_param().abi()).ok()
    }
    pub unsafe fn SetResidencyPriority(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>, ppriorities: *const D3D12_RESIDENCY_PRIORITY) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects), ::std::mem::transmute(ppriorities)).ok()
    }
    pub unsafe fn CreatePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_PIPELINE_STATE_STREAM_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).47)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Device2 {
    type Vtable = ID3D12Device2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(817538078, 45403, 18268, [160, 187, 26, 245, 197, 182, 67, 40]);
}
impl ::std::convert::From<ID3D12Device2> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device2> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device2> for ID3D12Device1 {
    fn from(value: ID3D12Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device2> for ID3D12Device1 {
    fn from(value: &ID3D12Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device1> for ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device1> for &ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device1>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device2> for ID3D12Device {
    fn from(value: ID3D12Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device2> for ID3D12Device {
    fn from(value: &ID3D12Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device> for ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device> for &ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device2> for ID3D12Object {
    fn from(value: ID3D12Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device2> for ID3D12Object {
    fn from(value: &ID3D12Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Device2_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_QUEUE_DESC, riid: *const ::windows::runtime::GUID, ppcommandqueue: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_COMMAND_LIST_TYPE, riid: *const ::windows::runtime::GUID, ppcommandallocator: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_GRAPHICS_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_COMPUTE_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: ::windows::runtime::RawPtr, pinitialstate: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppcommandlist: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize, riid: *const ::windows::runtime::GUID, ppvrootsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pcounterresource: ::windows::runtime::RawPtr, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdescriptors: u32, destdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, srcdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_RESOURCE_ALLOCATION_INFO, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_HEAP_PROPERTIES, nodemask: u32, heaptype: D3D12_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riidresource: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheap: ::windows::runtime::RawPtr, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pobject: ::windows::runtime::RawPtr, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: super::super::Foundation::PWSTR, phandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nthandle: super::super::Foundation::HANDLE, riid: *const ::windows::runtime::GUID, ppvobj: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR, access: u32, pnthandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, initialvalue: u64, flags: D3D12_FENCE_FLAGS, riid: *const ::windows::runtime::GUID, ppfence: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_QUERY_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvcommandsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptiledresource: ::windows::runtime::RawPtr, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut super::super::Foundation::LUID),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plibraryblob: *const ::std::ffi::c_void, bloblength: usize, riid: *const ::windows::runtime::GUID, pppipelinelibrary: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppfences: *const ::windows::runtime::RawPtr, pfencevalues: *const u64, numfences: u32, flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS, hevent: super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr, ppriorities: *const D3D12_RESIDENCY_PRIORITY) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_PIPELINE_STATE_STREAM_DESC, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Device3(::windows::runtime::IUnknown);
impl ID3D12Device3 {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetNodeCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn CreateCommandQueue<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_QUEUE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandAllocator<T: ::windows::runtime::Interface>(&self, r#type: D3D12_COMMAND_LIST_TYPE) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateGraphicsPipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateComputePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandList<'a, Param2: ::windows::runtime::IntoParam<'a, ID3D12CommandAllocator>, Param3: ::windows::runtime::IntoParam<'a, ID3D12PipelineState>, T: ::windows::runtime::Interface>(&self, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: Param2, pinitialstate: Param3) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(r#type), pcommandallocator.into_param().abi(), pinitialstate.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CheckFeatureSupport(&self, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(feature), ::std::mem::transmute(pfeaturesupportdata), ::std::mem::transmute(featuresupportdatasize)).ok()
    }
    pub unsafe fn CreateDescriptorHeap<T: ::windows::runtime::Interface>(&self, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdescriptorheapdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDescriptorHandleIncrementSize(&self, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(descriptorheaptype)))
    }
    pub unsafe fn CreateRootSignature<T: ::windows::runtime::Interface>(&self, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(pblobwithrootsignature), ::std::mem::transmute(bloblengthinbytes), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateConstantBufferView<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param1: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param3: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pcounterresource: Param1, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: Param3) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), presource.into_param().abi(), pcounterresource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CreateSampler<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CopyDescriptors(&self, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(numdestdescriptorranges),
            ::std::mem::transmute(pdestdescriptorrangestarts),
            ::std::mem::transmute(pdestdescriptorrangesizes),
            ::std::mem::transmute(numsrcdescriptorranges),
            ::std::mem::transmute(psrcdescriptorrangestarts),
            ::std::mem::transmute(psrcdescriptorrangesizes),
            ::std::mem::transmute(descriptorheapstype),
        ))
    }
    pub unsafe fn CopyDescriptorsSimple<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, numdescriptors: u32, destdescriptorrangestart: Param1, srcdescriptorrangestart: Param2, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(numdescriptors), destdescriptorrangestart.into_param().abi(), srcdescriptorrangestart.into_param().abi(), ::std::mem::transmute(descriptorheapstype)))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetResourceAllocationInfo(&self, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC) -> D3D12_RESOURCE_ALLOCATION_INFO {
        let mut result__: D3D12_RESOURCE_ALLOCATION_INFO = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(visiblemask), ::std::mem::transmute(numresourcedescs), ::std::mem::transmute(presourcedescs));
        result__
    }
    pub unsafe fn GetCustomHeapProperties(&self, nodemask: u32, heaptype: D3D12_HEAP_TYPE) -> D3D12_HEAP_PROPERTIES {
        let mut result__: D3D12_HEAP_PROPERTIES = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(nodemask), ::std::mem::transmute(heaptype));
        result__
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCommittedResource<T: ::windows::runtime::Interface>(&self, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(pheapproperties), ::std::mem::transmute(heapflags), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialresourcestate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn CreateHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreatePlacedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Heap>, T: ::windows::runtime::Interface>(&self, pheap: Param0, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), pheap.into_param().abi(), ::std::mem::transmute(heapoffset), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateReservedResource<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub unsafe fn CreateSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12DeviceChild>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pobject: Param0, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: Param3) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(::std::mem::transmute_copy(self), pobject.into_param().abi(), ::std::mem::transmute(pattributes), ::std::mem::transmute(access), name.into_param().abi(), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>, T: ::windows::runtime::Interface>(&self, nthandle: Param0, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(::std::mem::transmute_copy(self), nthandle.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandleByName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0, access: u32) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(::std::mem::transmute_copy(self), name.into_param().abi(), ::std::mem::transmute(access), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    pub unsafe fn MakeResident(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn Evict(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn CreateFence<T: ::windows::runtime::Interface>(&self, initialvalue: u64, flags: D3D12_FENCE_FLAGS) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).36)(::std::mem::transmute_copy(self), ::std::mem::transmute(initialvalue), ::std::mem::transmute(flags), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetCopyableFootprints(&self, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(presourcedesc),
            ::std::mem::transmute(firstsubresource),
            ::std::mem::transmute(numsubresources),
            ::std::mem::transmute(baseoffset),
            ::std::mem::transmute(playouts),
            ::std::mem::transmute(pnumrows),
            ::std::mem::transmute(prowsizeinbytes),
            ::std::mem::transmute(ptotalbytes),
        ))
    }
    pub unsafe fn CreateQueryHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_QUERY_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStablePowerState<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(::std::mem::transmute_copy(self), enable.into_param().abi()).ok()
    }
    pub unsafe fn CreateCommandSignature<'a, Param1: ::windows::runtime::IntoParam<'a, ID3D12RootSignature>, T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: Param1, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), prootsignature.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn GetResourceTiling<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, ptiledresource: Param0, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ptiledresource.into_param().abi(),
            ::std::mem::transmute(pnumtilesforentireresource),
            ::std::mem::transmute(ppackedmipdesc),
            ::std::mem::transmute(pstandardtileshapefornonpackedmips),
            ::std::mem::transmute(pnumsubresourcetilings),
            ::std::mem::transmute(firstsubresourcetilingtoget),
            ::std::mem::transmute(psubresourcetilingsfornonpackedmips),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAdapterLuid(&self) -> super::super::Foundation::LUID {
        let mut result__: super::super::Foundation::LUID = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
    pub unsafe fn CreatePipelineLibrary<T: ::windows::runtime::Interface>(&self, plibraryblob: *const ::std::ffi::c_void, bloblength: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).44)(::std::mem::transmute_copy(self), ::std::mem::transmute(plibraryblob), ::std::mem::transmute(bloblength), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEventOnMultipleFenceCompletion<'a, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, ppfences: *const ::std::option::Option<ID3D12Fence>, pfencevalues: *const u64, numfences: u32, flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS, hevent: Param4) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).45)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppfences), ::std::mem::transmute(pfencevalues), ::std::mem::transmute(numfences), ::std::mem::transmute(flags), hevent.into_param().abi()).ok()
    }
    pub unsafe fn SetResidencyPriority(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>, ppriorities: *const D3D12_RESIDENCY_PRIORITY) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects), ::std::mem::transmute(ppriorities)).ok()
    }
    pub unsafe fn CreatePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_PIPELINE_STATE_STREAM_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).47)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn OpenExistingHeapFromAddress<T: ::windows::runtime::Interface>(&self, paddress: *const ::std::ffi::c_void) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).48)(::std::mem::transmute_copy(self), ::std::mem::transmute(paddress), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenExistingHeapFromFileMapping<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>, T: ::windows::runtime::Interface>(&self, hfilemapping: Param0) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).49)(::std::mem::transmute_copy(self), hfilemapping.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn EnqueueMakeResident<'a, Param3: ::windows::runtime::IntoParam<'a, ID3D12Fence>>(&self, flags: D3D12_RESIDENCY_FLAGS, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>, pfencetosignal: Param3, fencevaluetosignal: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).50)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects), pfencetosignal.into_param().abi(), ::std::mem::transmute(fencevaluetosignal)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Device3 {
    type Vtable = ID3D12Device3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(2178604053, 11181, 17298, [147, 197, 16, 19, 69, 196, 170, 152]);
}
impl ::std::convert::From<ID3D12Device3> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device3> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device3> for ID3D12Device2 {
    fn from(value: ID3D12Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device3> for ID3D12Device2 {
    fn from(value: &ID3D12Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device2> for ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device2> for &ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device2>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device3> for ID3D12Device1 {
    fn from(value: ID3D12Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device3> for ID3D12Device1 {
    fn from(value: &ID3D12Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device1> for ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device1> for &ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device1>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device3> for ID3D12Device {
    fn from(value: ID3D12Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device3> for ID3D12Device {
    fn from(value: &ID3D12Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device> for ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device> for &ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device3> for ID3D12Object {
    fn from(value: ID3D12Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device3> for ID3D12Object {
    fn from(value: &ID3D12Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Object> for &ID3D12Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Object> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Object>::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D12Device3_abi(
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, iid: &::windows::runtime::GUID, interface: *mut ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, guid: *const ::windows::runtime::GUID, pdata: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_QUEUE_DESC, riid: *const ::windows::runtime::GUID, ppcommandqueue: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, r#type: D3D12_COMMAND_LIST_TYPE, riid: *const ::windows::runtime::GUID, ppcommandallocator: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_GRAPHICS_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const ::std::mem::ManuallyDrop<D3D12_COMPUTE_PIPELINE_STATE_DESC>, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: ::windows::runtime::RawPtr, pinitialstate: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppcommandlist: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize, riid: *const ::windows::runtime::GUID, ppvrootsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pcounterresource: ::windows::runtime::RawPtr, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presource: ::windows::runtime::RawPtr, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: D3D12_CPU_DESCRIPTOR_HANDLE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numdescriptors: u32, destdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, srcdescriptorrangestart: D3D12_CPU_DESCRIPTOR_HANDLE, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_RESOURCE_ALLOCATION_INFO, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D3D12_HEAP_PROPERTIES, nodemask: u32, heaptype: D3D12_HEAP_TYPE),
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riidresource: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pheap: ::windows::runtime::RawPtr, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, riid: *const ::windows::runtime::GUID, ppvresource: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pobject: ::windows::runtime::RawPtr, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: super::super::Foundation::PWSTR, phandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Security")))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, nthandle: super::super::Foundation::HANDLE, riid: *const ::windows::runtime::GUID, ppvobj: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, name: super::super::Foundation::PWSTR, access: u32, pnthandle: *mut super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, initialvalue: u64, flags: D3D12_FENCE_FLAGS, riid: *const ::windows::runtime::GUID, ppfence: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_QUERY_HEAP_DESC, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, enable: super::super::Foundation::BOOL) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: ::windows::runtime::RawPtr, riid: *const ::windows::runtime::GUID, ppvcommandsignature: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ptiledresource: ::windows::runtime::RawPtr, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING),
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut super::super::Foundation::LUID),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, plibraryblob: *const ::std::ffi::c_void, bloblength: usize, riid: *const ::windows::runtime::GUID, pppipelinelibrary: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, ppfences: *const ::windows::runtime::RawPtr, pfencevalues: *const u64, numfences: u32, flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS, hevent: super::super::Foundation::HANDLE) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr, ppriorities: *const D3D12_RESIDENCY_PRIORITY) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *const D3D12_PIPELINE_STATE_STREAM_DESC, riid: *const ::windows::runtime::GUID, pppipelinestate: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, paddress: *const ::std::ffi::c_void, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")] pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, hfilemapping: super::super::Foundation::HANDLE, riid: *const ::windows::runtime::GUID, ppvheap: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, flags: D3D12_RESIDENCY_FLAGS, numobjects: u32, ppobjects: *const ::windows::runtime::RawPtr, pfencetosignal: ::windows::runtime::RawPtr, fencevaluetosignal: u64) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(:: std :: cmp :: PartialEq, :: std :: cmp :: Eq, :: std :: clone :: Clone, :: std :: fmt :: Debug)]
pub struct ID3D12Device4(::windows::runtime::IUnknown);
impl ID3D12Device4 {
    pub unsafe fn GetPrivateData(&self, guid: *const ::windows::runtime::GUID, pdatasize: *mut u32, pdata: *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(pdatasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateData(&self, guid: *const ::windows::runtime::GUID, datasize: u32, pdata: *const ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), ::std::mem::transmute(datasize), ::std::mem::transmute(pdata)).ok()
    }
    pub unsafe fn SetPrivateDataInterface<'a, Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>>(&self, guid: *const ::windows::runtime::GUID, pdata: Param1) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self), ::std::mem::transmute(guid), pdata.into_param().abi()).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self), name.into_param().abi()).ok()
    }
    pub unsafe fn GetNodeCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)))
    }
    pub unsafe fn CreateCommandQueue<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_QUEUE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandAllocator<T: ::windows::runtime::Interface>(&self, r#type: D3D12_COMMAND_LIST_TYPE) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self), ::std::mem::transmute(r#type), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateGraphicsPipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_GRAPHICS_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateComputePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMPUTE_PIPELINE_STATE_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateCommandList<'a, Param2: ::windows::runtime::IntoParam<'a, ID3D12CommandAllocator>, Param3: ::windows::runtime::IntoParam<'a, ID3D12PipelineState>, T: ::windows::runtime::Interface>(&self, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, pcommandallocator: Param2, pinitialstate: Param3) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(r#type), pcommandallocator.into_param().abi(), pinitialstate.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CheckFeatureSupport(&self, feature: D3D12_FEATURE, pfeaturesupportdata: *mut ::std::ffi::c_void, featuresupportdatasize: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(::std::mem::transmute_copy(self), ::std::mem::transmute(feature), ::std::mem::transmute(pfeaturesupportdata), ::std::mem::transmute(featuresupportdatasize)).ok()
    }
    pub unsafe fn CreateDescriptorHeap<T: ::windows::runtime::Interface>(&self, pdescriptorheapdesc: *const D3D12_DESCRIPTOR_HEAP_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdescriptorheapdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDescriptorHandleIncrementSize(&self, descriptorheaptype: D3D12_DESCRIPTOR_HEAP_TYPE) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self), ::std::mem::transmute(descriptorheaptype)))
    }
    pub unsafe fn CreateRootSignature<T: ::windows::runtime::Interface>(&self, nodemask: u32, pblobwithrootsignature: *const ::std::ffi::c_void, bloblengthinbytes: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(pblobwithrootsignature), ::std::mem::transmute(bloblengthinbytes), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateConstantBufferView<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_CONSTANT_BUFFER_VIEW_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_SHADER_RESOURCE_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param1: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param3: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pcounterresource: Param1, pdesc: *const D3D12_UNORDERED_ACCESS_VIEW_DESC, destdescriptor: Param3) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self), presource.into_param().abi(), pcounterresource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_RENDER_TARGET_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, presource: Param0, pdesc: *const D3D12_DEPTH_STENCIL_VIEW_DESC, destdescriptor: Param2) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self), presource.into_param().abi(), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CreateSampler<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, pdesc: *const D3D12_SAMPLER_DESC, destdescriptor: Param1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), destdescriptor.into_param().abi()))
    }
    pub unsafe fn CopyDescriptors(&self, numdestdescriptorranges: u32, pdestdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, pdestdescriptorrangesizes: *const u32, numsrcdescriptorranges: u32, psrcdescriptorrangestarts: *const D3D12_CPU_DESCRIPTOR_HANDLE, psrcdescriptorrangesizes: *const u32, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(numdestdescriptorranges),
            ::std::mem::transmute(pdestdescriptorrangestarts),
            ::std::mem::transmute(pdestdescriptorrangesizes),
            ::std::mem::transmute(numsrcdescriptorranges),
            ::std::mem::transmute(psrcdescriptorrangestarts),
            ::std::mem::transmute(psrcdescriptorrangesizes),
            ::std::mem::transmute(descriptorheapstype),
        ))
    }
    pub unsafe fn CopyDescriptorsSimple<'a, Param1: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>, Param2: ::windows::runtime::IntoParam<'a, D3D12_CPU_DESCRIPTOR_HANDLE>>(&self, numdescriptors: u32, destdescriptorrangestart: Param1, srcdescriptorrangestart: Param2, descriptorheapstype: D3D12_DESCRIPTOR_HEAP_TYPE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(::std::mem::transmute_copy(self), ::std::mem::transmute(numdescriptors), destdescriptorrangestart.into_param().abi(), srcdescriptorrangestart.into_param().abi(), ::std::mem::transmute(descriptorheapstype)))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetResourceAllocationInfo(&self, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC) -> D3D12_RESOURCE_ALLOCATION_INFO {
        let mut result__: D3D12_RESOURCE_ALLOCATION_INFO = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).25)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(visiblemask), ::std::mem::transmute(numresourcedescs), ::std::mem::transmute(presourcedescs));
        result__
    }
    pub unsafe fn GetCustomHeapProperties(&self, nodemask: u32, heaptype: D3D12_HEAP_TYPE) -> D3D12_HEAP_PROPERTIES {
        let mut result__: D3D12_HEAP_PROPERTIES = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(nodemask), ::std::mem::transmute(heaptype));
        result__
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCommittedResource<T: ::windows::runtime::Interface>(&self, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self), ::std::mem::transmute(pheapproperties), ::std::mem::transmute(heapflags), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialresourcestate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn CreateHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreatePlacedResource<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Heap>, T: ::windows::runtime::Interface>(&self, pheap: Param0, heapoffset: u64, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(::std::mem::transmute_copy(self), pheap.into_param().abi(), ::std::mem::transmute(heapoffset), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateReservedResource<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
    pub unsafe fn CreateSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12DeviceChild>, Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, pobject: Param0, pattributes: *const super::super::Security::SECURITY_ATTRIBUTES, access: u32, name: Param3) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(::std::mem::transmute_copy(self), pobject.into_param().abi(), ::std::mem::transmute(pattributes), ::std::mem::transmute(access), name.into_param().abi(), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandle<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>, T: ::windows::runtime::Interface>(&self, nthandle: Param0, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(::std::mem::transmute_copy(self), nthandle.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedHandleByName<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>>(&self, name: Param0, access: u32) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(::std::mem::transmute_copy(self), name.into_param().abi(), ::std::mem::transmute(access), &mut result__).from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    pub unsafe fn MakeResident(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn Evict(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects)).ok()
    }
    pub unsafe fn CreateFence<T: ::windows::runtime::Interface>(&self, initialvalue: u64, flags: D3D12_FENCE_FLAGS) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).36)(::std::mem::transmute_copy(self), ::std::mem::transmute(initialvalue), ::std::mem::transmute(flags), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetCopyableFootprints(&self, presourcedesc: *const D3D12_RESOURCE_DESC, firstsubresource: u32, numsubresources: u32, baseoffset: u64, playouts: *mut D3D12_PLACED_SUBRESOURCE_FOOTPRINT, pnumrows: *mut u32, prowsizeinbytes: *mut u64, ptotalbytes: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(presourcedesc),
            ::std::mem::transmute(firstsubresource),
            ::std::mem::transmute(numsubresources),
            ::std::mem::transmute(baseoffset),
            ::std::mem::transmute(playouts),
            ::std::mem::transmute(pnumrows),
            ::std::mem::transmute(prowsizeinbytes),
            ::std::mem::transmute(ptotalbytes),
        ))
    }
    pub unsafe fn CreateQueryHeap<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_QUERY_HEAP_DESC, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStablePowerState<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>>(&self, enable: Param0) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(::std::mem::transmute_copy(self), enable.into_param().abi()).ok()
    }
    pub unsafe fn CreateCommandSignature<'a, Param1: ::windows::runtime::IntoParam<'a, ID3D12RootSignature>, T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_COMMAND_SIGNATURE_DESC, prootsignature: Param1, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), prootsignature.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    pub unsafe fn GetResourceTiling<'a, Param0: ::windows::runtime::IntoParam<'a, ID3D12Resource>>(&self, ptiledresource: Param0, pnumtilesforentireresource: *mut u32, ppackedmipdesc: *mut D3D12_PACKED_MIP_INFO, pstandardtileshapefornonpackedmips: *mut D3D12_TILE_SHAPE, pnumsubresourcetilings: *mut u32, firstsubresourcetilingtoget: u32, psubresourcetilingsfornonpackedmips: *mut D3D12_SUBRESOURCE_TILING) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ptiledresource.into_param().abi(),
            ::std::mem::transmute(pnumtilesforentireresource),
            ::std::mem::transmute(ppackedmipdesc),
            ::std::mem::transmute(pstandardtileshapefornonpackedmips),
            ::std::mem::transmute(pnumsubresourcetilings),
            ::std::mem::transmute(firstsubresourcetilingtoget),
            ::std::mem::transmute(psubresourcetilingsfornonpackedmips),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAdapterLuid(&self) -> super::super::Foundation::LUID {
        let mut result__: super::super::Foundation::LUID = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self), &mut result__);
        result__
    }
    pub unsafe fn CreatePipelineLibrary<T: ::windows::runtime::Interface>(&self, plibraryblob: *const ::std::ffi::c_void, bloblength: usize) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).44)(::std::mem::transmute_copy(self), ::std::mem::transmute(plibraryblob), ::std::mem::transmute(bloblength), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetEventOnMultipleFenceCompletion<'a, Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>>(&self, ppfences: *const ::std::option::Option<ID3D12Fence>, pfencevalues: *const u64, numfences: u32, flags: D3D12_MULTIPLE_FENCE_WAIT_FLAGS, hevent: Param4) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).45)(::std::mem::transmute_copy(self), ::std::mem::transmute(ppfences), ::std::mem::transmute(pfencevalues), ::std::mem::transmute(numfences), ::std::mem::transmute(flags), hevent.into_param().abi()).ok()
    }
    pub unsafe fn SetResidencyPriority(&self, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>, ppriorities: *const D3D12_RESIDENCY_PRIORITY) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(::std::mem::transmute_copy(self), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects), ::std::mem::transmute(ppriorities)).ok()
    }
    pub unsafe fn CreatePipelineState<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_PIPELINE_STATE_STREAM_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).47)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn OpenExistingHeapFromAddress<T: ::windows::runtime::Interface>(&self, paddress: *const ::std::ffi::c_void) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).48)(::std::mem::transmute_copy(self), ::std::mem::transmute(paddress), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenExistingHeapFromFileMapping<'a, Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>, T: ::windows::runtime::Interface>(&self, hfilemapping: Param0) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).49)(::std::mem::transmute_copy(self), hfilemapping.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn EnqueueMakeResident<'a, Param3: ::windows::runtime::IntoParam<'a, ID3D12Fence>>(&self, flags: D3D12_RESIDENCY_FLAGS, numobjects: u32, ppobjects: *const ::std::option::Option<ID3D12Pageable>, pfencetosignal: Param3, fencevaluetosignal: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).50)(::std::mem::transmute_copy(self), ::std::mem::transmute(flags), ::std::mem::transmute(numobjects), ::std::mem::transmute(ppobjects), pfencetosignal.into_param().abi(), ::std::mem::transmute(fencevaluetosignal)).ok()
    }
    pub unsafe fn CreateCommandList1<T: ::windows::runtime::Interface>(&self, nodemask: u32, r#type: D3D12_COMMAND_LIST_TYPE, flags: D3D12_COMMAND_LIST_FLAGS) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).51)(::std::mem::transmute_copy(self), ::std::mem::transmute(nodemask), ::std::mem::transmute(r#type), ::std::mem::transmute(flags), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    pub unsafe fn CreateProtectedResourceSession<T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_PROTECTED_RESOURCE_SESSION_DESC) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).52)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), &<T as ::windows::runtime::Interface>::IID, &mut result__ as *mut _ as *mut _).and_some(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCommittedResource1<'a, Param5: ::windows::runtime::IntoParam<'a, ID3D12ProtectedResourceSession>, T: ::windows::runtime::Interface>(&self, pheapproperties: *const D3D12_HEAP_PROPERTIES, heapflags: D3D12_HEAP_FLAGS, pdesc: *const D3D12_RESOURCE_DESC, initialresourcestate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, pprotectedsession: Param5, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pheapproperties),
            ::std::mem::transmute(heapflags),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(initialresourcestate),
            ::std::mem::transmute(poptimizedclearvalue),
            pprotectedsession.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            result__ as *mut _ as *mut _,
        )
        .ok()
    }
    pub unsafe fn CreateHeap1<'a, Param1: ::windows::runtime::IntoParam<'a, ID3D12ProtectedResourceSession>, T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_HEAP_DESC, pprotectedsession: Param1, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).54)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), pprotectedsession.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateReservedResource1<'a, Param3: ::windows::runtime::IntoParam<'a, ID3D12ProtectedResourceSession>, T: ::windows::runtime::Interface>(&self, pdesc: *const D3D12_RESOURCE_DESC, initialstate: D3D12_RESOURCE_STATES, poptimizedclearvalue: *const D3D12_CLEAR_VALUE, pprotectedsession: Param3, result__: *mut ::std::option::Option<T>) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).55)(::std::mem::transmute_copy(self), ::std::mem::transmute(pdesc), ::std::mem::transmute(initialstate), ::std::mem::transmute(poptimizedclearvalue), pprotectedsession.into_param().abi(), &<T as ::windows::runtime::Interface>::IID, result__ as *mut _ as *mut _).ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetResourceAllocationInfo1(&self, visiblemask: u32, numresourcedescs: u32, presourcedescs: *const D3D12_RESOURCE_DESC, presourceallocationinfo1: *mut D3D12_RESOURCE_ALLOCATION_INFO1) -> D3D12_RESOURCE_ALLOCATION_INFO {
        let mut result__: D3D12_RESOURCE_ALLOCATION_INFO = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).56)(::std::mem::transmute_copy(self), &mut result__, ::std::mem::transmute(visiblemask), ::std::mem::transmute(numresourcedescs), ::std::mem::transmute(presourcedescs), ::std::mem::transmute(presourceallocationinfo1));
        result__
    }
}
unsafe impl ::windows::runtime::Interface for ID3D12Device4 {
    type Vtable = ID3D12Device4_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(3898990359, 43502, 18169, [164, 99, 48, 152, 49, 90, 162, 229]);
}
impl ::std::convert::From<ID3D12Device4> for ::windows::runtime::IUnknown {
    fn from(value: ID3D12Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device4> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D12Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D12Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D12Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(self)))
    }
}
impl ::std::convert::From<ID3D12Device4> for ID3D12Device3 {
    fn from(value: ID3D12Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D12Device4> for ID3D12Device3 {
    fn from(value: &ID3D12Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device3> for ID3D12Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D12Device3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D12Device3> for &ID3D12Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D12Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into: