#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FreeInterfaceContextTable(interfacecontexttable: *const NET_INTERFACE_CONTEXT_TABLE) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FreeInterfaceContextTable(interfacecontexttable: *const NET_INTERFACE_CONTEXT_TABLE);
        }
        ::std::mem::transmute(FreeInterfaceContextTable(::std::mem::transmute(
            interfacecontexttable,
        )))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetInterfaceContextTableForHostName<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hostname: Param0,
    proxyname: Param1,
    flags: u32,
    connectionprofilefilterrawdata: *const u8,
    connectionprofilefilterrawdatasize: u32,
) -> ::windows::runtime::Result<*mut NET_INTERFACE_CONTEXT_TABLE> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetInterfaceContextTableForHostName(
                hostname: super::super::Foundation::PWSTR,
                proxyname: super::super::Foundation::PWSTR,
                flags: u32,
                connectionprofilefilterrawdata: *const u8,
                connectionprofilefilterrawdatasize: u32,
                interfacecontexttable: *mut *mut NET_INTERFACE_CONTEXT_TABLE,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <*mut NET_INTERFACE_CONTEXT_TABLE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        GetInterfaceContextTableForHostName(
            hostname.into_param().abi(),
            proxyname.into_param().abi(),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(connectionprofilefilterrawdata),
            ::std::mem::transmute(connectionprofilefilterrawdatasize),
            &mut result__,
        )
        .from_abi::<*mut NET_INTERFACE_CONTEXT_TABLE>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct NET_INTERFACE_CONTEXT {
    pub InterfaceIndex: u32,
    pub ConfigurationName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl NET_INTERFACE_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for NET_INTERFACE_CONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for NET_INTERFACE_CONTEXT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NET_INTERFACE_CONTEXT")
            .field("InterfaceIndex", &self.InterfaceIndex)
            .field("ConfigurationName", &self.ConfigurationName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for NET_INTERFACE_CONTEXT {
    fn eq(&self, other: &Self) -> bool {
        self.InterfaceIndex == other.InterfaceIndex
            && self.ConfigurationName == other.ConfigurationName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for NET_INTERFACE_CONTEXT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for NET_INTERFACE_CONTEXT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct NET_INTERFACE_CONTEXT_TABLE {
    pub InterfaceContextHandle: super::super::Foundation::HANDLE,
    pub NumberOfEntries: u32,
    pub InterfaceContextArray: *mut NET_INTERFACE_CONTEXT,
}
#[cfg(feature = "Win32_Foundation")]
impl NET_INTERFACE_CONTEXT_TABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for NET_INTERFACE_CONTEXT_TABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for NET_INTERFACE_CONTEXT_TABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NET_INTERFACE_CONTEXT_TABLE")
            .field("InterfaceContextHandle", &self.InterfaceContextHandle)
            .field("NumberOfEntries", &self.NumberOfEntries)
            .field("InterfaceContextArray", &self.InterfaceContextArray)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for NET_INTERFACE_CONTEXT_TABLE {
    fn eq(&self, other: &Self) -> bool {
        self.InterfaceContextHandle == other.InterfaceContextHandle
            && self.NumberOfEntries == other.NumberOfEntries
            && self.InterfaceContextArray == other.InterfaceContextArray
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for NET_INTERFACE_CONTEXT_TABLE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for NET_INTERFACE_CONTEXT_TABLE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const NET_INTERFACE_FLAG_CONNECT_IF_NEEDED: u32 = 1u32;
pub const NET_INTERFACE_FLAG_NONE: u32 = 0u32;
pub type ONDEMAND_NOTIFICATION_CALLBACK =
    unsafe extern "system" fn(param0: *const ::std::ffi::c_void);
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn OnDemandGetRoutingHint<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    destinationhostname: Param0,
) -> ::windows::runtime::Result<u32> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn OnDemandGetRoutingHint(
                destinationhostname: super::super::Foundation::PWSTR,
                interfaceindex: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        OnDemandGetRoutingHint(destinationhostname.into_param().abi(), &mut result__)
            .from_abi::<u32>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn OnDemandRegisterNotification(
    callback: ::std::option::Option<ONDEMAND_NOTIFICATION_CALLBACK>,
    callbackcontext: *const ::std::ffi::c_void,
) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn OnDemandRegisterNotification(
                callback: ::windows::runtime::RawPtr,
                callbackcontext: *const ::std::ffi::c_void,
                registrationhandle: *mut super::super::Foundation::HANDLE,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        OnDemandRegisterNotification(
            ::std::mem::transmute(callback),
            ::std::mem::transmute(callbackcontext),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn OnDemandUnRegisterNotification<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    registrationhandle: Param0,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn OnDemandUnRegisterNotification(
                registrationhandle: super::super::Foundation::HANDLE,
            ) -> ::windows::runtime::HRESULT;
        }
        OnDemandUnRegisterNotification(registrationhandle.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const WCM_API_VERSION: u32 = 1u32;
pub const WCM_API_VERSION_1_0: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WCM_BILLING_CYCLE_INFO {
    pub StartDate: super::super::Foundation::FILETIME,
    pub Duration: WCM_TIME_INTERVAL,
    pub Reset: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl WCM_BILLING_CYCLE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WCM_BILLING_CYCLE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WCM_BILLING_CYCLE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_BILLING_CYCLE_INFO")
            .field("StartDate", &self.StartDate)
            .field("Duration", &self.Duration)
            .field("Reset", &self.Reset)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WCM_BILLING_CYCLE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.StartDate == other.StartDate
            && self.Duration == other.Duration
            && self.Reset == other.Reset
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WCM_BILLING_CYCLE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WCM_BILLING_CYCLE_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct WCM_CONNECTION_COST(pub i32);
pub const WCM_CONNECTION_COST_UNKNOWN: WCM_CONNECTION_COST = WCM_CONNECTION_COST(0i32);
pub const WCM_CONNECTION_COST_UNRESTRICTED: WCM_CONNECTION_COST = WCM_CONNECTION_COST(1i32);
pub const WCM_CONNECTION_COST_FIXED: WCM_CONNECTION_COST = WCM_CONNECTION_COST(2i32);
pub const WCM_CONNECTION_COST_VARIABLE: WCM_CONNECTION_COST = WCM_CONNECTION_COST(4i32);
pub const WCM_CONNECTION_COST_OVERDATALIMIT: WCM_CONNECTION_COST = WCM_CONNECTION_COST(65536i32);
pub const WCM_CONNECTION_COST_CONGESTED: WCM_CONNECTION_COST = WCM_CONNECTION_COST(131072i32);
pub const WCM_CONNECTION_COST_ROAMING: WCM_CONNECTION_COST = WCM_CONNECTION_COST(262144i32);
pub const WCM_CONNECTION_COST_APPROACHINGDATALIMIT: WCM_CONNECTION_COST =
    WCM_CONNECTION_COST(524288i32);
impl ::std::convert::From<i32> for WCM_CONNECTION_COST {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WCM_CONNECTION_COST {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WCM_CONNECTION_COST_DATA {
    pub ConnectionCost: u32,
    pub CostSource: WCM_CONNECTION_COST_SOURCE,
}
impl WCM_CONNECTION_COST_DATA {}
impl ::std::default::Default for WCM_CONNECTION_COST_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WCM_CONNECTION_COST_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_CONNECTION_COST_DATA")
            .field("ConnectionCost", &self.ConnectionCost)
            .field("CostSource", &self.CostSource)
            .finish()
    }
}
impl ::std::cmp::PartialEq for WCM_CONNECTION_COST_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.ConnectionCost == other.ConnectionCost && self.CostSource == other.CostSource
    }
}
impl ::std::cmp::Eq for WCM_CONNECTION_COST_DATA {}
unsafe impl ::windows::runtime::Abi for WCM_CONNECTION_COST_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct WCM_CONNECTION_COST_SOURCE(pub i32);
pub const WCM_CONNECTION_COST_SOURCE_DEFAULT: WCM_CONNECTION_COST_SOURCE =
    WCM_CONNECTION_COST_SOURCE(0i32);
pub const WCM_CONNECTION_COST_SOURCE_GP: WCM_CONNECTION_COST_SOURCE =
    WCM_CONNECTION_COST_SOURCE(1i32);
pub const WCM_CONNECTION_COST_SOURCE_USER: WCM_CONNECTION_COST_SOURCE =
    WCM_CONNECTION_COST_SOURCE(2i32);
pub const WCM_CONNECTION_COST_SOURCE_OPERATOR: WCM_CONNECTION_COST_SOURCE =
    WCM_CONNECTION_COST_SOURCE(3i32);
impl ::std::convert::From<i32> for WCM_CONNECTION_COST_SOURCE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WCM_CONNECTION_COST_SOURCE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WCM_DATAPLAN_STATUS {
    pub UsageData: WCM_USAGE_DATA,
    pub DataLimitInMegabytes: u32,
    pub InboundBandwidthInKbps: u32,
    pub OutboundBandwidthInKbps: u32,
    pub BillingCycle: WCM_BILLING_CYCLE_INFO,
    pub MaxTransferSizeInMegabytes: u32,
    pub Reserved: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl WCM_DATAPLAN_STATUS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WCM_DATAPLAN_STATUS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WCM_DATAPLAN_STATUS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_DATAPLAN_STATUS")
            .field("UsageData", &self.UsageData)
            .field("DataLimitInMegabytes", &self.DataLimitInMegabytes)
            .field("InboundBandwidthInKbps", &self.InboundBandwidthInKbps)
            .field("OutboundBandwidthInKbps", &self.OutboundBandwidthInKbps)
            .field("BillingCycle", &self.BillingCycle)
            .field(
                "MaxTransferSizeInMegabytes",
                &self.MaxTransferSizeInMegabytes,
            )
            .field("Reserved", &self.Reserved)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WCM_DATAPLAN_STATUS {
    fn eq(&self, other: &Self) -> bool {
        self.UsageData == other.UsageData
            && self.DataLimitInMegabytes == other.DataLimitInMegabytes
            && self.InboundBandwidthInKbps == other.InboundBandwidthInKbps
            && self.OutboundBandwidthInKbps == other.OutboundBandwidthInKbps
            && self.BillingCycle == other.BillingCycle
            && self.MaxTransferSizeInMegabytes == other.MaxTransferSizeInMegabytes
            && self.Reserved == other.Reserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WCM_DATAPLAN_STATUS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WCM_DATAPLAN_STATUS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WCM_MAX_PROFILE_NAME: u32 = 256u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct WCM_MEDIA_TYPE(pub i32);
pub const wcm_media_unknown: WCM_MEDIA_TYPE = WCM_MEDIA_TYPE(0i32);
pub const wcm_media_ethernet: WCM_MEDIA_TYPE = WCM_MEDIA_TYPE(1i32);
pub const wcm_media_wlan: WCM_MEDIA_TYPE = WCM_MEDIA_TYPE(2i32);
pub const wcm_media_mbn: WCM_MEDIA_TYPE = WCM_MEDIA_TYPE(3i32);
pub const wcm_media_invalid: WCM_MEDIA_TYPE = WCM_MEDIA_TYPE(4i32);
pub const wcm_media_max: WCM_MEDIA_TYPE = WCM_MEDIA_TYPE(5i32);
impl ::std::convert::From<i32> for WCM_MEDIA_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WCM_MEDIA_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WCM_POLICY_VALUE {
    pub fValue: super::super::Foundation::BOOL,
    pub fIsGroupPolicy: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl WCM_POLICY_VALUE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WCM_POLICY_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WCM_POLICY_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_POLICY_VALUE")
            .field("fValue", &self.fValue)
            .field("fIsGroupPolicy", &self.fIsGroupPolicy)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WCM_POLICY_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.fValue == other.fValue && self.fIsGroupPolicy == other.fIsGroupPolicy
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WCM_POLICY_VALUE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WCM_POLICY_VALUE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WCM_PROFILE_INFO {
    pub strProfileName: [u16; 256],
    pub AdapterGUID: ::windows::runtime::GUID,
    pub Media: WCM_MEDIA_TYPE,
}
impl WCM_PROFILE_INFO {}
impl ::std::default::Default for WCM_PROFILE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WCM_PROFILE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_PROFILE_INFO")
            .field("strProfileName", &self.strProfileName)
            .field("AdapterGUID", &self.AdapterGUID)
            .field("Media", &self.Media)
            .finish()
    }
}
impl ::std::cmp::PartialEq for WCM_PROFILE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.strProfileName == other.strProfileName
            && self.AdapterGUID == other.AdapterGUID
            && self.Media == other.Media
    }
}
impl ::std::cmp::Eq for WCM_PROFILE_INFO {}
unsafe impl ::windows::runtime::Abi for WCM_PROFILE_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WCM_PROFILE_INFO_LIST {
    pub dwNumberOfItems: u32,
    pub ProfileInfo: [WCM_PROFILE_INFO; 1],
}
impl WCM_PROFILE_INFO_LIST {}
impl ::std::default::Default for WCM_PROFILE_INFO_LIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WCM_PROFILE_INFO_LIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_PROFILE_INFO_LIST")
            .field("dwNumberOfItems", &self.dwNumberOfItems)
            .field("ProfileInfo", &self.ProfileInfo)
            .finish()
    }
}
impl ::std::cmp::PartialEq for WCM_PROFILE_INFO_LIST {
    fn eq(&self, other: &Self) -> bool {
        self.dwNumberOfItems == other.dwNumberOfItems && self.ProfileInfo == other.ProfileInfo
    }
}
impl ::std::cmp::Eq for WCM_PROFILE_INFO_LIST {}
unsafe impl ::windows::runtime::Abi for WCM_PROFILE_INFO_LIST {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct WCM_PROPERTY(pub i32);
pub const wcm_global_property_domain_policy: WCM_PROPERTY = WCM_PROPERTY(0i32);
pub const wcm_global_property_minimize_policy: WCM_PROPERTY = WCM_PROPERTY(1i32);
pub const wcm_global_property_roaming_policy: WCM_PROPERTY = WCM_PROPERTY(2i32);
pub const wcm_global_property_powermanagement_policy: WCM_PROPERTY = WCM_PROPERTY(3i32);
pub const wcm_intf_property_connection_cost: WCM_PROPERTY = WCM_PROPERTY(4i32);
pub const wcm_intf_property_dataplan_status: WCM_PROPERTY = WCM_PROPERTY(5i32);
pub const wcm_intf_property_hotspot_profile: WCM_PROPERTY = WCM_PROPERTY(6i32);
impl ::std::convert::From<i32> for WCM_PROPERTY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for WCM_PROPERTY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct WCM_TIME_INTERVAL {
    pub wYear: u16,
    pub wMonth: u16,
    pub wDay: u16,
    pub wHour: u16,
    pub wMinute: u16,
    pub wSecond: u16,
    pub wMilliseconds: u16,
}
impl WCM_TIME_INTERVAL {}
impl ::std::default::Default for WCM_TIME_INTERVAL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for WCM_TIME_INTERVAL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_TIME_INTERVAL")
            .field("wYear", &self.wYear)
            .field("wMonth", &self.wMonth)
            .field("wDay", &self.wDay)
            .field("wHour", &self.wHour)
            .field("wMinute", &self.wMinute)
            .field("wSecond", &self.wSecond)
            .field("wMilliseconds", &self.wMilliseconds)
            .finish()
    }
}
impl ::std::cmp::PartialEq for WCM_TIME_INTERVAL {
    fn eq(&self, other: &Self) -> bool {
        self.wYear == other.wYear
            && self.wMonth == other.wMonth
            && self.wDay == other.wDay
            && self.wHour == other.wHour
            && self.wMinute == other.wMinute
            && self.wSecond == other.wSecond
            && self.wMilliseconds == other.wMilliseconds
    }
}
impl ::std::cmp::Eq for WCM_TIME_INTERVAL {}
unsafe impl ::windows::runtime::Abi for WCM_TIME_INTERVAL {
    type Abi = Self;
    type DefaultType = Self;
}
pub const WCM_UNKNOWN_DATAPLAN_STATUS: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct WCM_USAGE_DATA {
    pub UsageInMegabytes: u32,
    pub LastSyncTime: super::super::Foundation::FILETIME,
}
#[cfg(feature = "Win32_Foundation")]
impl WCM_USAGE_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for WCM_USAGE_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for WCM_USAGE_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("WCM_USAGE_DATA")
            .field("UsageInMegabytes", &self.UsageInMegabytes)
            .field("LastSyncTime", &self.LastSyncTime)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for WCM_USAGE_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.UsageInMegabytes == other.UsageInMegabytes && self.LastSyncTime == other.LastSyncTime
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for WCM_USAGE_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for WCM_USAGE_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
pub unsafe fn WcmFreeMemory(pmemory: *mut ::std::ffi::c_void) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WcmFreeMemory(pmemory: *mut ::std::ffi::c_void);
        }
        ::std::mem::transmute(WcmFreeMemory(::std::mem::transmute(pmemory)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn WcmGetProfileList(
    preserved: *mut ::std::ffi::c_void,
    ppprofilelist: *mut *mut WCM_PROFILE_INFO_LIST,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WcmGetProfileList(
                preserved: *mut ::std::ffi::c_void,
                ppprofilelist: *mut *mut WCM_PROFILE_INFO_LIST,
            ) -> u32;
        }
        ::std::mem::transmute(WcmGetProfileList(
            ::std::mem::transmute(preserved),
            ::std::mem::transmute(ppprofilelist),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn WcmQueryProperty<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pinterface: *const ::windows::runtime::GUID,
    strprofilename: Param1,
    property: WCM_PROPERTY,
    preserved: *mut ::std::ffi::c_void,
    pdwdatasize: *mut u32,
    ppdata: *mut *mut u8,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WcmQueryProperty(
                pinterface: *const ::windows::runtime::GUID,
                strprofilename: super::super::Foundation::PWSTR,
                property: WCM_PROPERTY,
                preserved: *mut ::std::ffi::c_void,
                pdwdatasize: *mut u32,
                ppdata: *mut *mut u8,
            ) -> u32;
        }
        ::std::mem::transmute(WcmQueryProperty(
            ::std::mem::transmute(pinterface),
            strprofilename.into_param().abi(),
            ::std::mem::transmute(property),
            ::std::mem::transmute(preserved),
            ::std::mem::transmute(pdwdatasize),
            ::std::mem::transmute(ppdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn WcmSetProfileList<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
>(
    pprofilelist: *const WCM_PROFILE_INFO_LIST,
    dwposition: u32,
    fignoreunknownprofiles: Param2,
    preserved: *mut ::std::ffi::c_void,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WcmSetProfileList(
                pprofilelist: *const WCM_PROFILE_INFO_LIST,
                dwposition: u32,
                fignoreunknownprofiles: super::super::Foundation::BOOL,
                preserved: *mut ::std::ffi::c_void,
            ) -> u32;
        }
        ::std::mem::transmute(WcmSetProfileList(
            ::std::mem::transmute(pprofilelist),
            ::std::mem::transmute(dwposition),
            fignoreunknownprofiles.into_param().abi(),
            ::std::mem::transmute(preserved),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn WcmSetProperty<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pinterface: *const ::windows::runtime::GUID,
    strprofilename: Param1,
    property: WCM_PROPERTY,
    preserved: *mut ::std::ffi::c_void,
    dwdatasize: u32,
    pbdata: *const u8,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn WcmSetProperty(
                pinterface: *const ::windows::runtime::GUID,
                strprofilename: super::super::Foundation::PWSTR,
                property: WCM_PROPERTY,
                preserved: *mut ::std::ffi::c_void,
                dwdatasize: u32,
                pbdata: *const u8,
            ) -> u32;
        }
        ::std::mem::transmute(WcmSetProperty(
            ::std::mem::transmute(pinterface),
            strprofilename.into_param().abi(),
            ::std::mem::transmute(property),
            ::std::mem::transmute(preserved),
            ::std::mem::transmute(dwdatasize),
            ::std::mem::transmute(pbdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
