#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
#[repr(C)]
#[derive(
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
)]
pub struct CD3D11_VIDEO_DEFAULT(pub u8);
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub unsafe fn D3D11CreateDevice<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGIAdapter>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
>(
    padapter: Param0,
    drivertype: D3D_DRIVER_TYPE,
    software: Param2,
    flags: D3D11_CREATE_DEVICE_FLAG,
    pfeaturelevels: *const D3D_FEATURE_LEVEL,
    featurelevels: u32,
    sdkversion: u32,
    ppdevice: *mut ::std::option::Option<ID3D11Device>,
    pfeaturelevel: *mut D3D_FEATURE_LEVEL,
    ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D11CreateDevice(
                padapter: ::windows::runtime::RawPtr,
                drivertype: D3D_DRIVER_TYPE,
                software: super::super::Foundation::HINSTANCE,
                flags: D3D11_CREATE_DEVICE_FLAG,
                pfeaturelevels: *const D3D_FEATURE_LEVEL,
                featurelevels: u32,
                sdkversion: u32,
                ppdevice: *mut ::windows::runtime::RawPtr,
                pfeaturelevel: *mut D3D_FEATURE_LEVEL,
                ppimmediatecontext: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3D11CreateDevice(
            padapter.into_param().abi(),
            ::std::mem::transmute(drivertype),
            software.into_param().abi(),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pfeaturelevels),
            ::std::mem::transmute(featurelevels),
            ::std::mem::transmute(sdkversion),
            ::std::mem::transmute(ppdevice),
            ::std::mem::transmute(pfeaturelevel),
            ::std::mem::transmute(ppimmediatecontext),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub unsafe fn D3D11CreateDeviceAndSwapChain<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGIAdapter>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
>(
    padapter: Param0,
    drivertype: D3D_DRIVER_TYPE,
    software: Param2,
    flags: D3D11_CREATE_DEVICE_FLAG,
    pfeaturelevels: *const D3D_FEATURE_LEVEL,
    featurelevels: u32,
    sdkversion: u32,
    pswapchaindesc: *const super::Dxgi::DXGI_SWAP_CHAIN_DESC,
    ppswapchain: *mut ::std::option::Option<super::Dxgi::IDXGISwapChain>,
    ppdevice: *mut ::std::option::Option<ID3D11Device>,
    pfeaturelevel: *mut D3D_FEATURE_LEVEL,
    ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3D11CreateDeviceAndSwapChain(
                padapter: ::windows::runtime::RawPtr,
                drivertype: D3D_DRIVER_TYPE,
                software: super::super::Foundation::HINSTANCE,
                flags: D3D11_CREATE_DEVICE_FLAG,
                pfeaturelevels: *const D3D_FEATURE_LEVEL,
                featurelevels: u32,
                sdkversion: u32,
                pswapchaindesc: *const super::Dxgi::DXGI_SWAP_CHAIN_DESC,
                ppswapchain: *mut ::windows::runtime::RawPtr,
                ppdevice: *mut ::windows::runtime::RawPtr,
                pfeaturelevel: *mut D3D_FEATURE_LEVEL,
                ppimmediatecontext: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3D11CreateDeviceAndSwapChain(
            padapter.into_param().abi(),
            ::std::mem::transmute(drivertype),
            software.into_param().abi(),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pfeaturelevels),
            ::std::mem::transmute(featurelevels),
            ::std::mem::transmute(sdkversion),
            ::std::mem::transmute(pswapchaindesc),
            ::std::mem::transmute(ppswapchain),
            ::std::mem::transmute(ppdevice),
            ::std::mem::transmute(pfeaturelevel),
            ::std::mem::transmute(ppimmediatecontext),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const D3D11_16BIT_INDEX_STRIP_CUT_VALUE: u32 = 65535u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG(pub i32);
pub const D3D11_1_CREATE_DEVICE_CONTEXT_STATE_SINGLETHREADED:
    D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG = D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG(1i32);
impl ::std::convert::From<i32> for D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_1_CREATE_DEVICE_CONTEXT_STATE_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_1_UAV_SLOT_COUNT: u32 = 64u32;
pub const D3D11_2_TILED_RESOURCE_TILE_SIZE_IN_BYTES: u32 = 65536u32;
pub const D3D11_32BIT_INDEX_STRIP_CUT_VALUE: u32 = 4294967295u32;
pub const D3D11_4_VIDEO_DECODER_HISTOGRAM_OFFSET_ALIGNMENT: u32 = 256u32;
pub const D3D11_4_VIDEO_DECODER_MAX_HISTOGRAM_COMPONENTS: u32 = 4u32;
pub const D3D11_8BIT_INDEX_STRIP_CUT_VALUE: u32 = 255u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_AES_CTR_IV {
    pub IV: u64,
    pub Count: u64,
}
impl D3D11_AES_CTR_IV {}
impl ::std::default::Default for D3D11_AES_CTR_IV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_AES_CTR_IV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AES_CTR_IV")
            .field("IV", &self.IV)
            .field("Count", &self.Count)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_AES_CTR_IV {
    fn eq(&self, other: &Self) -> bool {
        self.IV == other.IV && self.Count == other.Count
    }
}
impl ::std::cmp::Eq for D3D11_AES_CTR_IV {}
unsafe impl ::windows::runtime::Abi for D3D11_AES_CTR_IV {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_ANISOTROPIC_FILTERING_BIT: u32 = 64u32;
pub const D3D11_APPEND_ALIGNED_ELEMENT: u32 = 4294967295u32;
pub const D3D11_ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT: u32 = 9u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_ASYNC_GETDATA_FLAG(pub i32);
pub const D3D11_ASYNC_GETDATA_DONOTFLUSH: D3D11_ASYNC_GETDATA_FLAG = D3D11_ASYNC_GETDATA_FLAG(1i32);
impl ::std::convert::From<i32> for D3D11_ASYNC_GETDATA_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_ASYNC_GETDATA_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_AUTHENTICATED_CHANNEL_TYPE(pub i32);
pub const D3D11_AUTHENTICATED_CHANNEL_D3D11: D3D11_AUTHENTICATED_CHANNEL_TYPE =
    D3D11_AUTHENTICATED_CHANNEL_TYPE(1i32);
pub const D3D11_AUTHENTICATED_CHANNEL_DRIVER_SOFTWARE: D3D11_AUTHENTICATED_CHANNEL_TYPE =
    D3D11_AUTHENTICATED_CHANNEL_TYPE(2i32);
pub const D3D11_AUTHENTICATED_CHANNEL_DRIVER_HARDWARE: D3D11_AUTHENTICATED_CHANNEL_TYPE =
    D3D11_AUTHENTICATED_CHANNEL_TYPE(3i32);
impl ::std::convert::From<i32> for D3D11_AUTHENTICATED_CHANNEL_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CHANNEL_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {
    pub Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    pub EncryptionGuid: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT")
            .field("Parameters", &self.Parameters)
            .field("EncryptionGuid", &self.EncryptionGuid)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Parameters == other.Parameters && self.EncryptionGuid == other.EncryptionGuid
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1665584212,
        11516,
        19156,
        [130, 36, 209, 88, 55, 222, 119, 0],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {
    pub Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    pub DecoderHandle: super::super::Foundation::HANDLE,
    pub CryptoSessionHandle: super::super::Foundation::HANDLE,
    pub DeviceHandle: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT")
            .field("Parameters", &self.Parameters)
            .field("DecoderHandle", &self.DecoderHandle)
            .field("CryptoSessionHandle", &self.CryptoSessionHandle)
            .field("DeviceHandle", &self.DeviceHandle)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Parameters == other.Parameters
            && self.DecoderHandle == other.DecoderHandle
            && self.CryptoSessionHandle == other.CryptoSessionHandle
            && self.DeviceHandle == other.DeviceHandle
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_CONFIGURE_ENCRYPTION_WHEN_ACCESSIBLE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1107292806,
        27360,
        19779,
        [157, 85, 164, 110, 158, 253, 21, 138],
    );
pub const D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        101796827,
        13603,
        18186,
        [141, 202, 251, 194, 132, 81, 84, 240],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {
    pub Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    pub StartSequenceQuery: u32,
    pub StartSequenceConfigure: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT")
            .field("Parameters", &self.Parameters)
            .field("StartSequenceQuery", &self.StartSequenceQuery)
            .field("StartSequenceConfigure", &self.StartSequenceConfigure)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Parameters == other.Parameters
            && self.StartSequenceQuery == other.StartSequenceQuery
            && self.StartSequenceConfigure == other.StartSequenceConfigure
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_CONFIGURE_INPUT {
    pub omac: D3D11_OMAC,
    pub ConfigureType: ::windows::runtime::GUID,
    pub hChannel: super::super::Foundation::HANDLE,
    pub SequenceNumber: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_CONFIGURE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_CONFIGURE_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_CONFIGURE_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_CONFIGURE_INPUT")
            .field("omac", &self.omac)
            .field("ConfigureType", &self.ConfigureType)
            .field("hChannel", &self.hChannel)
            .field("SequenceNumber", &self.SequenceNumber)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_CONFIGURE_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.omac == other.omac
            && self.ConfigureType == other.ConfigureType
            && self.hChannel == other.hChannel
            && self.SequenceNumber == other.SequenceNumber
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_CONFIGURE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CONFIGURE_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {
    pub omac: D3D11_OMAC,
    pub ConfigureType: ::windows::runtime::GUID,
    pub hChannel: super::super::Foundation::HANDLE,
    pub SequenceNumber: u32,
    pub ReturnCode: ::windows::runtime::HRESULT,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_CONFIGURE_OUTPUT")
            .field("omac", &self.omac)
            .field("ConfigureType", &self.ConfigureType)
            .field("hChannel", &self.hChannel)
            .field("SequenceNumber", &self.SequenceNumber)
            .field("ReturnCode", &self.ReturnCode)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.omac == other.omac
            && self.ConfigureType == other.ConfigureType
            && self.hChannel == other.hChannel
            && self.SequenceNumber == other.SequenceNumber
            && self.ReturnCode == other.ReturnCode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CONFIGURE_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_CONFIGURE_PROTECTION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1346721368,
        16199,
        17250,
        [191, 153, 191, 223, 205, 233, 237, 41],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {
    pub Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    pub Protections: D3D11_AUTHENTICATED_PROTECTION_FLAGS,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CONFIGURE_PROTECTION_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        124964935,
        6976,
        18664,
        [156, 166, 181, 245, 16, 222, 159, 1],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {
    pub Parameters: D3D11_AUTHENTICATED_CONFIGURE_INPUT,
    pub ProcessType: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
    pub ProcessHandle: super::super::Foundation::HANDLE,
    pub AllowAccess: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT")
            .field("Parameters", &self.Parameters)
            .field("ProcessType", &self.ProcessType)
            .field("ProcessHandle", &self.ProcessHandle)
            .field("AllowAccess", &self.AllowAccess)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Parameters == other.Parameters
            && self.ProcessType == other.ProcessType
            && self.ProcessHandle == other.ProcessHandle
            && self.AllowAccess == other.AllowAccess
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE(pub i32);
pub const D3D11_PROCESSIDTYPE_UNKNOWN: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE =
    D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE(0i32);
pub const D3D11_PROCESSIDTYPE_DWM: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE =
    D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE(1i32);
pub const D3D11_PROCESSIDTYPE_HANDLE: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE =
    D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE(2i32);
impl ::std::convert::From<i32> for D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_AUTHENTICATED_PROTECTION_FLAGS {
    pub Flags: D3D11_AUTHENTICATED_PROTECTION_FLAGS_0,
    pub Value: u32,
}
impl D3D11_AUTHENTICATED_PROTECTION_FLAGS {}
impl ::std::default::Default for D3D11_AUTHENTICATED_PROTECTION_FLAGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_PROTECTION_FLAGS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_PROTECTION_FLAGS {}
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_PROTECTION_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_AUTHENTICATED_PROTECTION_FLAGS_0 {
    pub _bitfield: u32,
}
impl D3D11_AUTHENTICATED_PROTECTION_FLAGS_0 {}
impl ::std::default::Default for D3D11_AUTHENTICATED_PROTECTION_FLAGS_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_PROTECTION_FLAGS_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Flags_e__Struct")
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_PROTECTION_FLAGS_0 {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_PROTECTION_FLAGS_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_PROTECTION_FLAGS_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ATTRIBUTES: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1645533650,
        17196,
        19131,
        [159, 206, 33, 110, 234, 38, 158, 59],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub EncryptionGuidCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default
    for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT
{
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT")
            .field("Output", &self.Output)
            .field("EncryptionGuidCount", &self.EncryptionGuidCount)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq
    for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT
{
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output && self.EncryptionGuidCount == other.EncryptionGuidCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {
    pub Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    pub EncryptionGuidIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT")
            .field("Input", &self.Input)
            .field("EncryptionGuidIndex", &self.EncryptionGuidIndex)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Input == other.Input && self.EncryptionGuidIndex == other.EncryptionGuidIndex
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub EncryptionGuidIndex: u32,
    pub EncryptionGuid: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT")
            .field("Output", &self.Output)
            .field("EncryptionGuidIndex", &self.EncryptionGuidIndex)
            .field("EncryptionGuid", &self.EncryptionGuid)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.EncryptionGuidIndex == other.EncryptionGuidIndex
            && self.EncryptionGuid == other.EncryptionGuid
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub BusType: D3D11_BUS_TYPE,
    pub AccessibleInContiguousBlocks: super::super::Foundation::BOOL,
    pub AccessibleInNonContiguousBlocks: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT")
            .field("Output", &self.Output)
            .field("BusType", &self.BusType)
            .field(
                "AccessibleInContiguousBlocks",
                &self.AccessibleInContiguousBlocks,
            )
            .field(
                "AccessibleInNonContiguousBlocks",
                &self.AccessibleInNonContiguousBlocks,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.BusType == other.BusType
            && self.AccessibleInContiguousBlocks == other.AccessibleInContiguousBlocks
            && self.AccessibleInNonContiguousBlocks == other.AccessibleInNonContiguousBlocks
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3155892389,
        45563,
        17067,
        [189, 148, 181, 130, 139, 75, 247, 190],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub ChannelType: D3D11_AUTHENTICATED_CHANNEL_TYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT")
            .field("Output", &self.Output)
            .field("ChannelType", &self.ChannelType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output && self.ChannelType == other.ChannelType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        640960926,
        53272,
        19828,
        [172, 23, 127, 114, 64, 89, 82, 141],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {
    pub Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    pub DecoderHandle: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT")
            .field("Input", &self.Input)
            .field("DecoderHandle", &self.DecoderHandle)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Input == other.Input && self.DecoderHandle == other.DecoderHandle
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub DecoderHandle: super::super::Foundation::HANDLE,
    pub CryptoSessionHandle: super::super::Foundation::HANDLE,
    pub DeviceHandle: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT")
            .field("Output", &self.Output)
            .field("DecoderHandle", &self.DecoderHandle)
            .field("CryptoSessionHandle", &self.CryptoSessionHandle)
            .field("DeviceHandle", &self.DeviceHandle)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.DecoderHandle == other.DecoderHandle
            && self.CryptoSessionHandle == other.CryptoSessionHandle
            && self.DeviceHandle == other.DeviceHandle
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub EncryptionGuid: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT")
            .field("Output", &self.Output)
            .field("EncryptionGuid", &self.EncryptionGuid)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output && self.EncryptionGuid == other.EncryptionGuid
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_CURRENT_ENCRYPTION_WHEN_ACCESSIBLE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3960967623,
        56019,
        20245,
        [158, 195, 250, 169, 61, 96, 212, 240],
    );
pub const D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3961279389,
        36095,
        20010,
        [188, 196, 245, 105, 47, 153, 244, 128],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub DeviceHandle: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT")
            .field("Output", &self.Output)
            .field("DeviceHandle", &self.DeviceHandle)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output && self.DeviceHandle == other.DeviceHandle
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4164573528,
        59782,
        19418,
        [190, 176, 65, 31, 106, 122, 1, 183],
    );
pub const D3D11_AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID_COUNT:
    ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3004133478,
    8252,
    19207,
    [147, 252, 206, 170, 253, 97, 36, 30],
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_INPUT {
    pub QueryType: ::windows::runtime::GUID,
    pub hChannel: super::super::Foundation::HANDLE,
    pub SequenceNumber: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_INPUT")
            .field("QueryType", &self.QueryType)
            .field("hChannel", &self.hChannel)
            .field("SequenceNumber", &self.SequenceNumber)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.QueryType == other.QueryType
            && self.hChannel == other.hChannel
            && self.SequenceNumber == other.SequenceNumber
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_OUTPUT {
    pub omac: D3D11_OMAC,
    pub QueryType: ::windows::runtime::GUID,
    pub hChannel: super::super::Foundation::HANDLE,
    pub SequenceNumber: u32,
    pub ReturnCode: ::windows::runtime::HRESULT,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_OUTPUT")
            .field("omac", &self.omac)
            .field("QueryType", &self.QueryType)
            .field("hChannel", &self.hChannel)
            .field("SequenceNumber", &self.SequenceNumber)
            .field("ReturnCode", &self.ReturnCode)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.omac == other.omac
            && self.QueryType == other.QueryType
            && self.hChannel == other.hChannel
            && self.SequenceNumber == other.SequenceNumber
            && self.ReturnCode == other.ReturnCode
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_OUTPUT_ID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2208160931,
        39758,
        16868,
        [176, 83, 137, 43, 210, 161, 30, 231],
    );
pub const D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        738470750,
        35847,
        18133,
        [170, 190, 143, 117, 203, 173, 76, 49],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {
    pub Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    pub DeviceHandle: super::super::Foundation::HANDLE,
    pub CryptoSessionHandle: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT")
            .field("Input", &self.Input)
            .field("DeviceHandle", &self.DeviceHandle)
            .field("CryptoSessionHandle", &self.CryptoSessionHandle)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Input == other.Input
            && self.DeviceHandle == other.DeviceHandle
            && self.CryptoSessionHandle == other.CryptoSessionHandle
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub DeviceHandle: super::super::Foundation::HANDLE,
    pub CryptoSessionHandle: super::super::Foundation::HANDLE,
    pub OutputIDCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT")
            .field("Output", &self.Output)
            .field("DeviceHandle", &self.DeviceHandle)
            .field("CryptoSessionHandle", &self.CryptoSessionHandle)
            .field("OutputIDCount", &self.OutputIDCount)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.DeviceHandle == other.DeviceHandle
            && self.CryptoSessionHandle == other.CryptoSessionHandle
            && self.OutputIDCount == other.OutputIDCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {
    pub Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    pub DeviceHandle: super::super::Foundation::HANDLE,
    pub CryptoSessionHandle: super::super::Foundation::HANDLE,
    pub OutputIDIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT")
            .field("Input", &self.Input)
            .field("DeviceHandle", &self.DeviceHandle)
            .field("CryptoSessionHandle", &self.CryptoSessionHandle)
            .field("OutputIDIndex", &self.OutputIDIndex)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Input == other.Input
            && self.DeviceHandle == other.DeviceHandle
            && self.CryptoSessionHandle == other.CryptoSessionHandle
            && self.OutputIDIndex == other.OutputIDIndex
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_INPUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub DeviceHandle: super::super::Foundation::HANDLE,
    pub CryptoSessionHandle: super::super::Foundation::HANDLE,
    pub OutputIDIndex: u32,
    pub OutputID: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT")
            .field("Output", &self.Output)
            .field("DeviceHandle", &self.DeviceHandle)
            .field("CryptoSessionHandle", &self.CryptoSessionHandle)
            .field("OutputIDIndex", &self.OutputIDIndex)
            .field("OutputID", &self.OutputID)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.DeviceHandle == other.DeviceHandle
            && self.CryptoSessionHandle == other.CryptoSessionHandle
            && self.OutputIDIndex == other.OutputIDIndex
            && self.OutputID == other.OutputID
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_PROTECTION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2823730564,
        50325,
        18602,
        [185, 77, 139, 210, 214, 251, 206, 5],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub ProtectionFlags: D3D11_AUTHENTICATED_PROTECTION_FLAGS,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_AUTHENTICATED_QUERY_PROTECTION_OUTPUT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1687927515,
        61684,
        17977,
        [161, 91, 36, 57, 63, 195, 171, 172],
    );
pub const D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT:
    ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    229771187,
    37968,
    18086,
    [130, 222, 27, 150, 212, 79, 156, 242],
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub RestrictedSharedResourceProcessCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT
{
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT
{
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct(
            "D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT",
        )
        .field("Output", &self.Output)
        .field(
            "RestrictedSharedResourceProcessCount",
            &self.RestrictedSharedResourceProcessCount,
        )
        .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT
{
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.RestrictedSharedResourceProcessCount
                == other.RestrictedSharedResourceProcessCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT {
    pub Input: D3D11_AUTHENTICATED_QUERY_INPUT,
    pub ProcessIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT
{
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT")
            .field("Input", &self.Input)
            .field("ProcessIndex", &self.ProcessIndex)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Input == other.Input && self.ProcessIndex == other.ProcessIndex
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub ProcessIndex: u32,
    pub ProcessIdentifier: D3D11_AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
    pub ProcessHandle: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT
{
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT")
            .field("Output", &self.Output)
            .field("ProcessIndex", &self.ProcessIndex)
            .field("ProcessIdentifier", &self.ProcessIdentifier)
            .field("ProcessHandle", &self.ProcessHandle)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT {
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.ProcessIndex == other.ProcessIndex
            && self.ProcessIdentifier == other.ProcessIdentifier
            && self.ProcessHandle == other.ProcessHandle
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT:
    ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    19860438,
    58978,
    17524,
    [190, 253, 170, 83, 229, 20, 60, 109],
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT {
    pub Output: D3D11_AUTHENTICATED_QUERY_OUTPUT,
    pub UnrestrictedProtectedSharedResourceCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default
    for D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT
{
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug
    for D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT
{
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct(
            "D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT",
        )
        .field("Output", &self.Output)
        .field(
            "UnrestrictedProtectedSharedResourceCount",
            &self.UnrestrictedProtectedSharedResourceCount,
        )
        .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq
    for D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT
{
    fn eq(&self, other: &Self) -> bool {
        self.Output == other.Output
            && self.UnrestrictedProtectedSharedResourceCount
                == other.UnrestrictedProtectedSharedResourceCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq
    for D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT
{
}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi
    for D3D11_AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT
{
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_BIND_FLAG(pub u32);
pub const D3D11_BIND_VERTEX_BUFFER: D3D11_BIND_FLAG = D3D11_BIND_FLAG(1u32);
pub const D3D11_BIND_INDEX_BUFFER: D3D11_BIND_FLAG = D3D11_BIND_FLAG(2u32);
pub const D3D11_BIND_CONSTANT_BUFFER: D3D11_BIND_FLAG = D3D11_BIND_FLAG(4u32);
pub const D3D11_BIND_SHADER_RESOURCE: D3D11_BIND_FLAG = D3D11_BIND_FLAG(8u32);
pub const D3D11_BIND_STREAM_OUTPUT: D3D11_BIND_FLAG = D3D11_BIND_FLAG(16u32);
pub const D3D11_BIND_RENDER_TARGET: D3D11_BIND_FLAG = D3D11_BIND_FLAG(32u32);
pub const D3D11_BIND_DEPTH_STENCIL: D3D11_BIND_FLAG = D3D11_BIND_FLAG(64u32);
pub const D3D11_BIND_UNORDERED_ACCESS: D3D11_BIND_FLAG = D3D11_BIND_FLAG(128u32);
pub const D3D11_BIND_DECODER: D3D11_BIND_FLAG = D3D11_BIND_FLAG(512u32);
pub const D3D11_BIND_VIDEO_ENCODER: D3D11_BIND_FLAG = D3D11_BIND_FLAG(1024u32);
impl ::std::convert::From<u32> for D3D11_BIND_FLAG {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_BIND_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D11_BIND_FLAG {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D11_BIND_FLAG {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D11_BIND_FLAG {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D11_BIND_FLAG {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D11_BIND_FLAG {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_BLEND(pub i32);
pub const D3D11_BLEND_ZERO: D3D11_BLEND = D3D11_BLEND(1i32);
pub const D3D11_BLEND_ONE: D3D11_BLEND = D3D11_BLEND(2i32);
pub const D3D11_BLEND_SRC_COLOR: D3D11_BLEND = D3D11_BLEND(3i32);
pub const D3D11_BLEND_INV_SRC_COLOR: D3D11_BLEND = D3D11_BLEND(4i32);
pub const D3D11_BLEND_SRC_ALPHA: D3D11_BLEND = D3D11_BLEND(5i32);
pub const D3D11_BLEND_INV_SRC_ALPHA: D3D11_BLEND = D3D11_BLEND(6i32);
pub const D3D11_BLEND_DEST_ALPHA: D3D11_BLEND = D3D11_BLEND(7i32);
pub const D3D11_BLEND_INV_DEST_ALPHA: D3D11_BLEND = D3D11_BLEND(8i32);
pub const D3D11_BLEND_DEST_COLOR: D3D11_BLEND = D3D11_BLEND(9i32);
pub const D3D11_BLEND_INV_DEST_COLOR: D3D11_BLEND = D3D11_BLEND(10i32);
pub const D3D11_BLEND_SRC_ALPHA_SAT: D3D11_BLEND = D3D11_BLEND(11i32);
pub const D3D11_BLEND_BLEND_FACTOR: D3D11_BLEND = D3D11_BLEND(14i32);
pub const D3D11_BLEND_INV_BLEND_FACTOR: D3D11_BLEND = D3D11_BLEND(15i32);
pub const D3D11_BLEND_SRC1_COLOR: D3D11_BLEND = D3D11_BLEND(16i32);
pub const D3D11_BLEND_INV_SRC1_COLOR: D3D11_BLEND = D3D11_BLEND(17i32);
pub const D3D11_BLEND_SRC1_ALPHA: D3D11_BLEND = D3D11_BLEND(18i32);
pub const D3D11_BLEND_INV_SRC1_ALPHA: D3D11_BLEND = D3D11_BLEND(19i32);
impl ::std::convert::From<i32> for D3D11_BLEND {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_BLEND {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_BLEND_DESC {
    pub AlphaToCoverageEnable: super::super::Foundation::BOOL,
    pub IndependentBlendEnable: super::super::Foundation::BOOL,
    pub RenderTarget: [D3D11_RENDER_TARGET_BLEND_DESC; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_BLEND_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_BLEND_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_BLEND_DESC")
            .field("AlphaToCoverageEnable", &self.AlphaToCoverageEnable)
            .field("IndependentBlendEnable", &self.IndependentBlendEnable)
            .field("RenderTarget", &self.RenderTarget)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_BLEND_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.AlphaToCoverageEnable == other.AlphaToCoverageEnable
            && self.IndependentBlendEnable == other.IndependentBlendEnable
            && self.RenderTarget == other.RenderTarget
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_BLEND_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_BLEND_DESC1 {
    pub AlphaToCoverageEnable: super::super::Foundation::BOOL,
    pub IndependentBlendEnable: super::super::Foundation::BOOL,
    pub RenderTarget: [D3D11_RENDER_TARGET_BLEND_DESC1; 8],
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_BLEND_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_BLEND_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_BLEND_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_BLEND_DESC1")
            .field("AlphaToCoverageEnable", &self.AlphaToCoverageEnable)
            .field("IndependentBlendEnable", &self.IndependentBlendEnable)
            .field("RenderTarget", &self.RenderTarget)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_BLEND_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.AlphaToCoverageEnable == other.AlphaToCoverageEnable
            && self.IndependentBlendEnable == other.IndependentBlendEnable
            && self.RenderTarget == other.RenderTarget
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_BLEND_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_BLEND_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_BLEND_OP(pub i32);
pub const D3D11_BLEND_OP_ADD: D3D11_BLEND_OP = D3D11_BLEND_OP(1i32);
pub const D3D11_BLEND_OP_SUBTRACT: D3D11_BLEND_OP = D3D11_BLEND_OP(2i32);
pub const D3D11_BLEND_OP_REV_SUBTRACT: D3D11_BLEND_OP = D3D11_BLEND_OP(3i32);
pub const D3D11_BLEND_OP_MIN: D3D11_BLEND_OP = D3D11_BLEND_OP(4i32);
pub const D3D11_BLEND_OP_MAX: D3D11_BLEND_OP = D3D11_BLEND_OP(5i32);
impl ::std::convert::From<i32> for D3D11_BLEND_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_BLEND_OP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_BOX {
    pub left: u32,
    pub top: u32,
    pub front: u32,
    pub right: u32,
    pub bottom: u32,
    pub back: u32,
}
impl D3D11_BOX {}
impl ::std::default::Default for D3D11_BOX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_BOX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_BOX")
            .field("left", &self.left)
            .field("top", &self.top)
            .field("front", &self.front)
            .field("right", &self.right)
            .field("bottom", &self.bottom)
            .field("back", &self.back)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_BOX {
    fn eq(&self, other: &Self) -> bool {
        self.left == other.left
            && self.top == other.top
            && self.front == other.front
            && self.right == other.right
            && self.bottom == other.bottom
            && self.back == other.back
    }
}
impl ::std::cmp::Eq for D3D11_BOX {}
unsafe impl ::windows::runtime::Abi for D3D11_BOX {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_BUFFEREX_SRV {
    pub FirstElement: u32,
    pub NumElements: u32,
    pub Flags: u32,
}
impl D3D11_BUFFEREX_SRV {}
impl ::std::default::Default for D3D11_BUFFEREX_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_BUFFEREX_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_BUFFEREX_SRV")
            .field("FirstElement", &self.FirstElement)
            .field("NumElements", &self.NumElements)
            .field("Flags", &self.Flags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFEREX_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstElement == other.FirstElement
            && self.NumElements == other.NumElements
            && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D11_BUFFEREX_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFEREX_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_BUFFEREX_SRV_FLAG(pub i32);
pub const D3D11_BUFFEREX_SRV_FLAG_RAW: D3D11_BUFFEREX_SRV_FLAG = D3D11_BUFFEREX_SRV_FLAG(1i32);
impl ::std::convert::From<i32> for D3D11_BUFFEREX_SRV_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFEREX_SRV_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_BUFFER_DESC {
    pub ByteWidth: u32,
    pub Usage: D3D11_USAGE,
    pub BindFlags: u32,
    pub CPUAccessFlags: u32,
    pub MiscFlags: u32,
    pub StructureByteStride: u32,
}
impl D3D11_BUFFER_DESC {}
impl ::std::default::Default for D3D11_BUFFER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_BUFFER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_BUFFER_DESC")
            .field("ByteWidth", &self.ByteWidth)
            .field("Usage", &self.Usage)
            .field("BindFlags", &self.BindFlags)
            .field("CPUAccessFlags", &self.CPUAccessFlags)
            .field("MiscFlags", &self.MiscFlags)
            .field("StructureByteStride", &self.StructureByteStride)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.ByteWidth == other.ByteWidth
            && self.Usage == other.Usage
            && self.BindFlags == other.BindFlags
            && self.CPUAccessFlags == other.CPUAccessFlags
            && self.MiscFlags == other.MiscFlags
            && self.StructureByteStride == other.StructureByteStride
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_BUFFER_RTV {
    pub Anonymous1: D3D11_BUFFER_RTV_0,
    pub Anonymous2: D3D11_BUFFER_RTV_1,
}
impl D3D11_BUFFER_RTV {}
impl ::std::default::Default for D3D11_BUFFER_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_RTV {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_BUFFER_RTV_0 {
    pub FirstElement: u32,
    pub ElementOffset: u32,
}
impl D3D11_BUFFER_RTV_0 {}
impl ::std::default::Default for D3D11_BUFFER_RTV_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_RTV_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_RTV_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_RTV_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_BUFFER_RTV_1 {
    pub NumElements: u32,
    pub ElementWidth: u32,
}
impl D3D11_BUFFER_RTV_1 {}
impl ::std::default::Default for D3D11_BUFFER_RTV_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_RTV_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_RTV_1 {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_RTV_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_BUFFER_SRV {
    pub Anonymous1: D3D11_BUFFER_SRV_0,
    pub Anonymous2: D3D11_BUFFER_SRV_1,
}
impl D3D11_BUFFER_SRV {}
impl ::std::default::Default for D3D11_BUFFER_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_SRV {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_BUFFER_SRV_0 {
    pub FirstElement: u32,
    pub ElementOffset: u32,
}
impl D3D11_BUFFER_SRV_0 {}
impl ::std::default::Default for D3D11_BUFFER_SRV_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_SRV_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_SRV_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_SRV_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_BUFFER_SRV_1 {
    pub NumElements: u32,
    pub ElementWidth: u32,
}
impl D3D11_BUFFER_SRV_1 {}
impl ::std::default::Default for D3D11_BUFFER_SRV_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_SRV_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_SRV_1 {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_SRV_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_BUFFER_UAV {
    pub FirstElement: u32,
    pub NumElements: u32,
    pub Flags: u32,
}
impl D3D11_BUFFER_UAV {}
impl ::std::default::Default for D3D11_BUFFER_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_BUFFER_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_BUFFER_UAV")
            .field("FirstElement", &self.FirstElement)
            .field("NumElements", &self.NumElements)
            .field("Flags", &self.Flags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_BUFFER_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstElement == other.FirstElement
            && self.NumElements == other.NumElements
            && self.Flags == other.Flags
    }
}
impl ::std::cmp::Eq for D3D11_BUFFER_UAV {}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_BUFFER_UAV_FLAG(pub i32);
pub const D3D11_BUFFER_UAV_FLAG_RAW: D3D11_BUFFER_UAV_FLAG = D3D11_BUFFER_UAV_FLAG(1i32);
pub const D3D11_BUFFER_UAV_FLAG_APPEND: D3D11_BUFFER_UAV_FLAG = D3D11_BUFFER_UAV_FLAG(2i32);
pub const D3D11_BUFFER_UAV_FLAG_COUNTER: D3D11_BUFFER_UAV_FLAG = D3D11_BUFFER_UAV_FLAG(4i32);
impl ::std::convert::From<i32> for D3D11_BUFFER_UAV_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_BUFFER_UAV_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_BUS_TYPE(pub i32);
pub const D3D11_BUS_TYPE_OTHER: D3D11_BUS_TYPE = D3D11_BUS_TYPE(0i32);
pub const D3D11_BUS_TYPE_PCI: D3D11_BUS_TYPE = D3D11_BUS_TYPE(1i32);
pub const D3D11_BUS_TYPE_PCIX: D3D11_BUS_TYPE = D3D11_BUS_TYPE(2i32);
pub const D3D11_BUS_TYPE_PCIEXPRESS: D3D11_BUS_TYPE = D3D11_BUS_TYPE(3i32);
pub const D3D11_BUS_TYPE_AGP: D3D11_BUS_TYPE = D3D11_BUS_TYPE(4i32);
pub const D3D11_BUS_IMPL_MODIFIER_INSIDE_OF_CHIPSET: D3D11_BUS_TYPE = D3D11_BUS_TYPE(65536i32);
pub const D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_CHIP: D3D11_BUS_TYPE =
    D3D11_BUS_TYPE(131072i32);
pub const D3D11_BUS_IMPL_MODIFIER_TRACKS_ON_MOTHER_BOARD_TO_SOCKET: D3D11_BUS_TYPE =
    D3D11_BUS_TYPE(196608i32);
pub const D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR: D3D11_BUS_TYPE =
    D3D11_BUS_TYPE(262144i32);
pub const D3D11_BUS_IMPL_MODIFIER_DAUGHTER_BOARD_CONNECTOR_INSIDE_OF_NUAE: D3D11_BUS_TYPE =
    D3D11_BUS_TYPE(327680i32);
pub const D3D11_BUS_IMPL_MODIFIER_NON_STANDARD: D3D11_BUS_TYPE = D3D11_BUS_TYPE(-2147483648i32);
impl ::std::convert::From<i32> for D3D11_BUS_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_BUS_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG(pub i32);
pub const D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_TILED_RESOURCE:
    D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG = D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG(1i32);
impl ::std::convert::From<i32> for D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CHECK_MULTISAMPLE_QUALITY_LEVELS_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_CLASS_INSTANCE_DESC {
    pub InstanceId: u32,
    pub InstanceIndex: u32,
    pub TypeId: u32,
    pub ConstantBuffer: u32,
    pub BaseConstantBufferOffset: u32,
    pub BaseTexture: u32,
    pub BaseSampler: u32,
    pub Created: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_CLASS_INSTANCE_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_CLASS_INSTANCE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_CLASS_INSTANCE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_CLASS_INSTANCE_DESC")
            .field("InstanceId", &self.InstanceId)
            .field("InstanceIndex", &self.InstanceIndex)
            .field("TypeId", &self.TypeId)
            .field("ConstantBuffer", &self.ConstantBuffer)
            .field("BaseConstantBufferOffset", &self.BaseConstantBufferOffset)
            .field("BaseTexture", &self.BaseTexture)
            .field("BaseSampler", &self.BaseSampler)
            .field("Created", &self.Created)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_CLASS_INSTANCE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.InstanceId == other.InstanceId
            && self.InstanceIndex == other.InstanceIndex
            && self.TypeId == other.TypeId
            && self.ConstantBuffer == other.ConstantBuffer
            && self.BaseConstantBufferOffset == other.BaseConstantBufferOffset
            && self.BaseTexture == other.BaseTexture
            && self.BaseSampler == other.BaseSampler
            && self.Created == other.Created
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_CLASS_INSTANCE_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_CLASS_INSTANCE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CLEAR_FLAG(pub i32);
pub const D3D11_CLEAR_DEPTH: D3D11_CLEAR_FLAG = D3D11_CLEAR_FLAG(1i32);
pub const D3D11_CLEAR_STENCIL: D3D11_CLEAR_FLAG = D3D11_CLEAR_FLAG(2i32);
impl ::std::convert::From<i32> for D3D11_CLEAR_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CLEAR_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_CLIP_OR_CULL_DISTANCE_COUNT: u32 = 8u32;
pub const D3D11_CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT: u32 = 2u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_COLOR_WRITE_ENABLE(pub i32);
pub const D3D11_COLOR_WRITE_ENABLE_RED: D3D11_COLOR_WRITE_ENABLE = D3D11_COLOR_WRITE_ENABLE(1i32);
pub const D3D11_COLOR_WRITE_ENABLE_GREEN: D3D11_COLOR_WRITE_ENABLE = D3D11_COLOR_WRITE_ENABLE(2i32);
pub const D3D11_COLOR_WRITE_ENABLE_BLUE: D3D11_COLOR_WRITE_ENABLE = D3D11_COLOR_WRITE_ENABLE(4i32);
pub const D3D11_COLOR_WRITE_ENABLE_ALPHA: D3D11_COLOR_WRITE_ENABLE = D3D11_COLOR_WRITE_ENABLE(8i32);
pub const D3D11_COLOR_WRITE_ENABLE_ALL: D3D11_COLOR_WRITE_ENABLE = D3D11_COLOR_WRITE_ENABLE(15i32);
impl ::std::convert::From<i32> for D3D11_COLOR_WRITE_ENABLE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_COLOR_WRITE_ENABLE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT: u32 = 14u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENTS: u32 = 4u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT: u32 = 15u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT: u32 = 16u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT: u32 = 15u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D11_COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_COMMONSHADER_FLOWCONTROL_NESTING_LIMIT: u32 = 64u32;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D11_COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT: u32 = 128u32;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT: u32 = 128u32;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_COUNT: u32 = 16u32;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D11_COMMONSHADER_SAMPLER_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_COMMONSHADER_SAMPLER_SLOT_COUNT: u32 = 16u32;
pub const D3D11_COMMONSHADER_SUBROUTINE_NESTING_LIMIT: u32 = 32u32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_COUNT: u32 = 4096u32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_READS_PER_INST: u32 = 3u32;
pub const D3D11_COMMONSHADER_TEMP_REGISTER_READ_PORTS: u32 = 3u32;
pub const D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX: u32 = 10u32;
pub const D3D11_COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN: i32 = -10i32;
pub const D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE: i32 = -8i32;
pub const D3D11_COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE: u32 = 7u32;
pub const D3D11_COMPARISON_FILTERING_BIT: u32 = 128u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_COMPARISON_FUNC(pub i32);
pub const D3D11_COMPARISON_NEVER: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(1i32);
pub const D3D11_COMPARISON_LESS: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(2i32);
pub const D3D11_COMPARISON_EQUAL: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(3i32);
pub const D3D11_COMPARISON_LESS_EQUAL: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(4i32);
pub const D3D11_COMPARISON_GREATER: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(5i32);
pub const D3D11_COMPARISON_NOT_EQUAL: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(6i32);
pub const D3D11_COMPARISON_GREATER_EQUAL: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(7i32);
pub const D3D11_COMPARISON_ALWAYS: D3D11_COMPARISON_FUNC = D3D11_COMPARISON_FUNC(8i32);
impl ::std::convert::From<i32> for D3D11_COMPARISON_FUNC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_COMPARISON_FUNC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_COMPUTE_SHADER_TRACE_DESC {
    pub Invocation: u64,
    pub ThreadIDInGroup: [u32; 3],
    pub ThreadGroupID: [u32; 3],
}
impl D3D11_COMPUTE_SHADER_TRACE_DESC {}
impl ::std::default::Default for D3D11_COMPUTE_SHADER_TRACE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_COMPUTE_SHADER_TRACE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_COMPUTE_SHADER_TRACE_DESC")
            .field("Invocation", &self.Invocation)
            .field("ThreadIDInGroup", &self.ThreadIDInGroup)
            .field("ThreadGroupID", &self.ThreadGroupID)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_COMPUTE_SHADER_TRACE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Invocation == other.Invocation
            && self.ThreadIDInGroup == other.ThreadIDInGroup
            && self.ThreadGroupID == other.ThreadGroupID
    }
}
impl ::std::cmp::Eq for D3D11_COMPUTE_SHADER_TRACE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_COMPUTE_SHADER_TRACE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CONSERVATIVE_RASTERIZATION_MODE(pub i32);
pub const D3D11_CONSERVATIVE_RASTERIZATION_MODE_OFF: D3D11_CONSERVATIVE_RASTERIZATION_MODE =
    D3D11_CONSERVATIVE_RASTERIZATION_MODE(0i32);
pub const D3D11_CONSERVATIVE_RASTERIZATION_MODE_ON: D3D11_CONSERVATIVE_RASTERIZATION_MODE =
    D3D11_CONSERVATIVE_RASTERIZATION_MODE(1i32);
impl ::std::convert::From<i32> for D3D11_CONSERVATIVE_RASTERIZATION_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CONSERVATIVE_RASTERIZATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CONSERVATIVE_RASTERIZATION_TIER(pub i32);
pub const D3D11_CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED: D3D11_CONSERVATIVE_RASTERIZATION_TIER =
    D3D11_CONSERVATIVE_RASTERIZATION_TIER(0i32);
pub const D3D11_CONSERVATIVE_RASTERIZATION_TIER_1: D3D11_CONSERVATIVE_RASTERIZATION_TIER =
    D3D11_CONSERVATIVE_RASTERIZATION_TIER(1i32);
pub const D3D11_CONSERVATIVE_RASTERIZATION_TIER_2: D3D11_CONSERVATIVE_RASTERIZATION_TIER =
    D3D11_CONSERVATIVE_RASTERIZATION_TIER(2i32);
pub const D3D11_CONSERVATIVE_RASTERIZATION_TIER_3: D3D11_CONSERVATIVE_RASTERIZATION_TIER =
    D3D11_CONSERVATIVE_RASTERIZATION_TIER(3i32);
impl ::std::convert::From<i32> for D3D11_CONSERVATIVE_RASTERIZATION_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CONSERVATIVE_RASTERIZATION_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CONTENT_PROTECTION_CAPS(pub i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_SOFTWARE: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(1i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_HARDWARE: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(2i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_PROTECTION_ALWAYS_ON: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(4i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_PARTIAL_DECRYPTION: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(8i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_CONTENT_KEY: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(16i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_FRESHEN_SESSION_KEY: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(32i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(64i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_ENCRYPTED_READ_BACK_KEY: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(128i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_SEQUENTIAL_CTR_IV: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(256i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_ENCRYPT_SLICEDATA_ONLY: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(512i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_DECRYPTION_BLT: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(1024i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECT_UNCOMPRESSED:
    D3D11_CONTENT_PROTECTION_CAPS = D3D11_CONTENT_PROTECTION_CAPS(2048i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_PROTECTED_MEMORY_PAGEABLE:
    D3D11_CONTENT_PROTECTION_CAPS = D3D11_CONTENT_PROTECTION_CAPS(4096i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_TEARDOWN: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(8192i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_DRM_COMMUNICATION: D3D11_CONTENT_PROTECTION_CAPS =
    D3D11_CONTENT_PROTECTION_CAPS(16384i32);
pub const D3D11_CONTENT_PROTECTION_CAPS_HARDWARE_DRM_COMMUNICATION_MULTI_THREADED:
    D3D11_CONTENT_PROTECTION_CAPS = D3D11_CONTENT_PROTECTION_CAPS(32768i32);
impl ::std::convert::From<i32> for D3D11_CONTENT_PROTECTION_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CONTENT_PROTECTION_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CONTEXT_TYPE(pub i32);
pub const D3D11_CONTEXT_TYPE_ALL: D3D11_CONTEXT_TYPE = D3D11_CONTEXT_TYPE(0i32);
pub const D3D11_CONTEXT_TYPE_3D: D3D11_CONTEXT_TYPE = D3D11_CONTEXT_TYPE(1i32);
pub const D3D11_CONTEXT_TYPE_COMPUTE: D3D11_CONTEXT_TYPE = D3D11_CONTEXT_TYPE(2i32);
pub const D3D11_CONTEXT_TYPE_COPY: D3D11_CONTEXT_TYPE = D3D11_CONTEXT_TYPE(3i32);
pub const D3D11_CONTEXT_TYPE_VIDEO: D3D11_CONTEXT_TYPE = D3D11_CONTEXT_TYPE(4i32);
impl ::std::convert::From<i32> for D3D11_CONTEXT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CONTEXT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_COPY_FLAGS(pub i32);
pub const D3D11_COPY_NO_OVERWRITE: D3D11_COPY_FLAGS = D3D11_COPY_FLAGS(1i32);
pub const D3D11_COPY_DISCARD: D3D11_COPY_FLAGS = D3D11_COPY_FLAGS(2i32);
impl ::std::convert::From<i32> for D3D11_COPY_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_COPY_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_COUNTER(pub i32);
pub const D3D11_COUNTER_DEVICE_DEPENDENT_0: D3D11_COUNTER = D3D11_COUNTER(1073741824i32);
impl ::std::convert::From<i32> for D3D11_COUNTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_COUNTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_COUNTER_DESC {
    pub Counter: D3D11_COUNTER,
    pub MiscFlags: u32,
}
impl D3D11_COUNTER_DESC {}
impl ::std::default::Default for D3D11_COUNTER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_COUNTER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_COUNTER_DESC")
            .field("Counter", &self.Counter)
            .field("MiscFlags", &self.MiscFlags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_COUNTER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Counter == other.Counter && self.MiscFlags == other.MiscFlags
    }
}
impl ::std::cmp::Eq for D3D11_COUNTER_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_COUNTER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_COUNTER_INFO {
    pub LastDeviceDependentCounter: D3D11_COUNTER,
    pub NumSimultaneousCounters: u32,
    pub NumDetectableParallelUnits: u8,
}
impl D3D11_COUNTER_INFO {}
impl ::std::default::Default for D3D11_COUNTER_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_COUNTER_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_COUNTER_INFO")
            .field(
                "LastDeviceDependentCounter",
                &self.LastDeviceDependentCounter,
            )
            .field("NumSimultaneousCounters", &self.NumSimultaneousCounters)
            .field(
                "NumDetectableParallelUnits",
                &self.NumDetectableParallelUnits,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_COUNTER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.LastDeviceDependentCounter == other.LastDeviceDependentCounter
            && self.NumSimultaneousCounters == other.NumSimultaneousCounters
            && self.NumDetectableParallelUnits == other.NumDetectableParallelUnits
    }
}
impl ::std::cmp::Eq for D3D11_COUNTER_INFO {}
unsafe impl ::windows::runtime::Abi for D3D11_COUNTER_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_COUNTER_TYPE(pub i32);
pub const D3D11_COUNTER_TYPE_FLOAT32: D3D11_COUNTER_TYPE = D3D11_COUNTER_TYPE(0i32);
pub const D3D11_COUNTER_TYPE_UINT16: D3D11_COUNTER_TYPE = D3D11_COUNTER_TYPE(1i32);
pub const D3D11_COUNTER_TYPE_UINT32: D3D11_COUNTER_TYPE = D3D11_COUNTER_TYPE(2i32);
pub const D3D11_COUNTER_TYPE_UINT64: D3D11_COUNTER_TYPE = D3D11_COUNTER_TYPE(3i32);
impl ::std::convert::From<i32> for D3D11_COUNTER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_COUNTER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CPU_ACCESS_FLAG(pub u32);
pub const D3D11_CPU_ACCESS_WRITE: D3D11_CPU_ACCESS_FLAG = D3D11_CPU_ACCESS_FLAG(65536u32);
pub const D3D11_CPU_ACCESS_READ: D3D11_CPU_ACCESS_FLAG = D3D11_CPU_ACCESS_FLAG(131072u32);
impl ::std::convert::From<u32> for D3D11_CPU_ACCESS_FLAG {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CPU_ACCESS_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D11_CPU_ACCESS_FLAG {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D11_CPU_ACCESS_FLAG {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D11_CPU_ACCESS_FLAG {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D11_CPU_ACCESS_FLAG {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D11_CPU_ACCESS_FLAG {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CREATE_DEVICE_FLAG(pub u32);
pub const D3D11_CREATE_DEVICE_SINGLETHREADED: D3D11_CREATE_DEVICE_FLAG =
    D3D11_CREATE_DEVICE_FLAG(1u32);
pub const D3D11_CREATE_DEVICE_DEBUG: D3D11_CREATE_DEVICE_FLAG = D3D11_CREATE_DEVICE_FLAG(2u32);
pub const D3D11_CREATE_DEVICE_SWITCH_TO_REF: D3D11_CREATE_DEVICE_FLAG =
    D3D11_CREATE_DEVICE_FLAG(4u32);
pub const D3D11_CREATE_DEVICE_PREVENT_INTERNAL_THREADING_OPTIMIZATIONS: D3D11_CREATE_DEVICE_FLAG =
    D3D11_CREATE_DEVICE_FLAG(8u32);
pub const D3D11_CREATE_DEVICE_BGRA_SUPPORT: D3D11_CREATE_DEVICE_FLAG =
    D3D11_CREATE_DEVICE_FLAG(32u32);
pub const D3D11_CREATE_DEVICE_DEBUGGABLE: D3D11_CREATE_DEVICE_FLAG =
    D3D11_CREATE_DEVICE_FLAG(64u32);
pub const D3D11_CREATE_DEVICE_PREVENT_ALTERING_LAYER_SETTINGS_FROM_REGISTRY:
    D3D11_CREATE_DEVICE_FLAG = D3D11_CREATE_DEVICE_FLAG(128u32);
pub const D3D11_CREATE_DEVICE_DISABLE_GPU_TIMEOUT: D3D11_CREATE_DEVICE_FLAG =
    D3D11_CREATE_DEVICE_FLAG(256u32);
pub const D3D11_CREATE_DEVICE_VIDEO_SUPPORT: D3D11_CREATE_DEVICE_FLAG =
    D3D11_CREATE_DEVICE_FLAG(2048u32);
impl ::std::convert::From<u32> for D3D11_CREATE_DEVICE_FLAG {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CREATE_DEVICE_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D11_CREATE_DEVICE_FLAG {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D11_CREATE_DEVICE_FLAG {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D11_CREATE_DEVICE_FLAG {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D11_CREATE_DEVICE_FLAG {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D11_CREATE_DEVICE_FLAG {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS(pub u32);
pub const D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAG_NONE: D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS =
    D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS(0u32);
impl ::std::convert::From<u32> for D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D11_CRYPTO_SESSION_KEY_EXCHANGE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CRYPTO_SESSION_STATUS(pub i32);
pub const D3D11_CRYPTO_SESSION_STATUS_OK: D3D11_CRYPTO_SESSION_STATUS =
    D3D11_CRYPTO_SESSION_STATUS(0i32);
pub const D3D11_CRYPTO_SESSION_STATUS_KEY_LOST: D3D11_CRYPTO_SESSION_STATUS =
    D3D11_CRYPTO_SESSION_STATUS(1i32);
pub const D3D11_CRYPTO_SESSION_STATUS_KEY_AND_CONTENT_LOST: D3D11_CRYPTO_SESSION_STATUS =
    D3D11_CRYPTO_SESSION_STATUS(2i32);
impl ::std::convert::From<i32> for D3D11_CRYPTO_SESSION_STATUS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CRYPTO_SESSION_STATUS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_CRYPTO_TYPE_AES128_CTR: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2607535889,
        20340,
        16841,
        [158, 123, 11, 226, 215, 217, 59, 79],
    );
pub const D3D11_CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 256u32;
pub const D3D11_CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP: u32 = 64u32;
pub const D3D11_CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 240u32;
pub const D3D11_CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP: u32 = 68u32;
pub const D3D11_CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 224u32;
pub const D3D11_CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP: u32 = 72u32;
pub const D3D11_CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 208u32;
pub const D3D11_CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP: u32 = 76u32;
pub const D3D11_CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 192u32;
pub const D3D11_CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP: u32 = 84u32;
pub const D3D11_CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 176u32;
pub const D3D11_CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP: u32 = 92u32;
pub const D3D11_CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 160u32;
pub const D3D11_CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP: u32 = 100u32;
pub const D3D11_CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 144u32;
pub const D3D11_CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP: u32 = 112u32;
pub const D3D11_CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 128u32;
pub const D3D11_CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP: u32 = 128u32;
pub const D3D11_CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 112u32;
pub const D3D11_CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP: u32 = 144u32;
pub const D3D11_CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 96u32;
pub const D3D11_CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP: u32 = 168u32;
pub const D3D11_CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 80u32;
pub const D3D11_CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP: u32 = 204u32;
pub const D3D11_CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 64u32;
pub const D3D11_CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP: u32 = 256u32;
pub const D3D11_CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 48u32;
pub const D3D11_CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP: u32 = 340u32;
pub const D3D11_CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 32u32;
pub const D3D11_CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP: u32 = 512u32;
pub const D3D11_CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD: u32 = 16u32;
pub const D3D11_CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP: u32 = 768u32;
pub const D3D11_CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION: u32 = 1u32;
pub const D3D11_CS_4_X_RAW_UAV_BYTE_ALIGNMENT: u32 = 256u32;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 = 768u32;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_X: u32 = 768u32;
pub const D3D11_CS_4_X_THREAD_GROUP_MAX_Y: u32 = 768u32;
pub const D3D11_CS_4_X_UAV_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION: u32 = 65535u32;
pub const D3D11_CS_TGSM_REGISTER_COUNT: u32 = 8192u32;
pub const D3D11_CS_TGSM_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D11_CS_TGSM_RESOURCE_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_CS_TGSM_RESOURCE_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_CS_THREADGROUPID_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D11_CS_THREADGROUPID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_CS_THREADIDINGROUP_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D11_CS_THREADIDINGROUP_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_CS_THREADID_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D11_CS_THREADID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_CS_THREAD_GROUP_MAX_THREADS_PER_GROUP: u32 = 1024u32;
pub const D3D11_CS_THREAD_GROUP_MAX_X: u32 = 1024u32;
pub const D3D11_CS_THREAD_GROUP_MAX_Y: u32 = 1024u32;
pub const D3D11_CS_THREAD_GROUP_MAX_Z: u32 = 64u32;
pub const D3D11_CS_THREAD_GROUP_MIN_X: u32 = 1u32;
pub const D3D11_CS_THREAD_GROUP_MIN_Y: u32 = 1u32;
pub const D3D11_CS_THREAD_GROUP_MIN_Z: u32 = 1u32;
pub const D3D11_CS_THREAD_LOCAL_TEMP_REGISTER_POOL: u32 = 16384u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_CULL_MODE(pub i32);
pub const D3D11_CULL_NONE: D3D11_CULL_MODE = D3D11_CULL_MODE(1i32);
pub const D3D11_CULL_FRONT: D3D11_CULL_MODE = D3D11_CULL_MODE(2i32);
pub const D3D11_CULL_BACK: D3D11_CULL_MODE = D3D11_CULL_MODE(3i32);
impl ::std::convert::From<i32> for D3D11_CULL_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_CULL_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_DEBUG_FEATURE_ALWAYS_DISCARD_OFFERED_RESOURCE: u32 = 8u32;
pub const D3D11_DEBUG_FEATURE_AVOID_BEHAVIOR_CHANGING_DEBUG_AIDS: u32 = 64u32;
pub const D3D11_DEBUG_FEATURE_DISABLE_TILED_RESOURCE_MAPPING_TRACKING_AND_VALIDATION: u32 = 128u32;
pub const D3D11_DEBUG_FEATURE_FINISH_PER_RENDER_OP: u32 = 2u32;
pub const D3D11_DEBUG_FEATURE_FLUSH_PER_RENDER_OP: u32 = 1u32;
pub const D3D11_DEBUG_FEATURE_NEVER_DISCARD_OFFERED_RESOURCE: u32 = 16u32;
pub const D3D11_DEBUG_FEATURE_PRESENT_PER_RENDER_OP: u32 = 4u32;
pub const D3D11_DECODER_BITSTREAM_ENCRYPTION_TYPE_CBCS: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1110283033,
        40225,
        19383,
        [147, 113, 250, 245, 168, 44, 62, 4],
    );
pub const D3D11_DECODER_BITSTREAM_ENCRYPTION_TYPE_CENC: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2957005365,
        49469,
        17650,
        [154, 229, 221, 72, 224, 142, 91, 103],
    );
pub const D3D11_DECODER_ENCRYPTION_HW_CENC: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2312547407,
        2546,
        16937,
        [178, 205, 55, 116, 10, 109, 253, 129],
    );
pub const D3D11_DECODER_PROFILE_AV1_VLD_12BIT_PROFILE2: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        387084297,
        40975,
        19681,
        [153, 78, 191, 64, 129, 246, 243, 240],
    );
pub const D3D11_DECODER_PROFILE_AV1_VLD_12BIT_PROFILE2_420: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        763412182,
        40108,
        18485,
        [158, 145, 50, 123, 188, 79, 158, 232],
    );
pub const D3D11_DECODER_PROFILE_AV1_VLD_PROFILE0: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3099479243,
        53075,
        18106,
        [141, 89, 214, 184, 166, 218, 93, 42],
    );
pub const D3D11_DECODER_PROFILE_AV1_VLD_PROFILE1: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1765211919,
        17841,
        16739,
        [156, 193, 100, 110, 246, 148, 97, 8],
    );
pub const D3D11_DECODER_PROFILE_AV1_VLD_PROFILE2: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        207563425,
        58689,
        16521,
        [187, 123, 152, 17, 10, 25, 215, 200],
    );
pub const D3D11_DECODER_PROFILE_H264_IDCT_FGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487719,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_H264_IDCT_NOFGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487718,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_H264_MOCOMP_FGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487717,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_H264_MOCOMP_NOFGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487716,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_H264_VLD_FGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487721,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_H264_VLD_MULTIVIEW_NOFGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1885052290,
        30415,
        18902,
        [183, 230, 172, 136, 114, 219, 1, 60],
    );
pub const D3D11_DECODER_PROFILE_H264_VLD_NOFGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487720,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_H264_VLD_STEREO_NOFGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4188720315,
        49846,
        19708,
        [135, 121, 87, 7, 177, 118, 5, 82],
    );
pub const D3D11_DECODER_PROFILE_H264_VLD_STEREO_PROGRESSIVE_NOFGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3617319130,
        3313,
        19585,
        [184, 42, 105, 164, 226, 54, 244, 61],
    );
pub const D3D11_DECODER_PROFILE_H264_VLD_WITHFMOASO_NOFGT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3589296121,
        13336,
        17880,
        [149, 97, 50, 167, 106, 174, 45, 221],
    );
pub const D3D11_DECODER_PROFILE_HEVC_VLD_MAIN: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1527895323,
        12108,
        17490,
        [188, 195, 9, 242, 161, 22, 12, 192],
    );
pub const D3D11_DECODER_PROFILE_HEVC_VLD_MAIN10: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        276492512,
        61210,
        19737,
        [171, 168, 103, 161, 99, 7, 61, 19],
    );
pub const D3D11_DECODER_PROFILE_MPEG1_VLD: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1866385177,
        14133,
        17100,
        [128, 99, 101, 204, 60, 179, 102, 22],
    );
pub const D3D11_DECODER_PROFILE_MPEG2_IDCT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3206720768,
        1002,
        18064,
        [128, 119, 71, 51, 70, 32, 155, 126],
    );
pub const D3D11_DECODER_PROFILE_MPEG2_MOCOMP: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3869897803,
        25008,
        17763,
        [158, 164, 99, 210, 163, 198, 254, 102],
    );
pub const D3D11_DECODER_PROFILE_MPEG2_VLD: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3995550079,
        24104,
        20069,
        [190, 234, 29, 38, 181, 8, 173, 201],
    );
pub const D3D11_DECODER_PROFILE_MPEG2and1_VLD: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2255052562,
        13326,
        20228,
        [159, 211, 146, 83, 221, 50, 116, 96],
    );
pub const D3D11_DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_GMC: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2878966619,
        16984,
        17577,
        [159, 235, 148, 229, 151, 166, 186, 174],
    );
pub const D3D11_DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_NOGMC: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3980495519,
        269,
        20186,
        [154, 227, 154, 101, 53, 141, 141, 46],
    );
pub const D3D11_DECODER_PROFILE_MPEG4PT2_VLD_SIMPLE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4023799156,
        51688,
        16855,
        [165, 233, 233, 176, 227, 159, 163, 25],
    );
pub const D3D11_DECODER_PROFILE_VC1_D2010: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487780,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_VC1_IDCT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487778,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_VC1_MOCOMP: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487777,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_VC1_POSTPROC: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487776,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_VC1_VLD: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487779,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_VP8_VLD: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2428017130,
        14946,
        18181,
        [136, 179, 141, 240, 75, 39, 68, 231],
    );
pub const D3D11_DECODER_PROFILE_VP9_VLD_10BIT_PROFILE2: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2764524015,
        28367,
        18602,
        [132, 72, 80, 167, 161, 22, 95, 247],
    );
pub const D3D11_DECODER_PROFILE_VP9_VLD_PROFILE0: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1178011640,
        41424,
        17797,
        [135, 109, 131, 170, 109, 96, 184, 158],
    );
pub const D3D11_DECODER_PROFILE_WMV8_MOCOMP: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487745,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_WMV8_POSTPROC: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487744,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_WMV9_IDCT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487764,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_WMV9_MOCOMP: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487761,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DECODER_PROFILE_WMV9_POSTPROC: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        461487760,
        41159,
        4563,
        [185, 132, 0, 192, 79, 46, 115, 197],
    );
pub const D3D11_DEFAULT_BLEND_FACTOR_ALPHA: f32 = 1f32;
pub const D3D11_DEFAULT_BLEND_FACTOR_BLUE: f32 = 1f32;
pub const D3D11_DEFAULT_BLEND_FACTOR_GREEN: f32 = 1f32;
pub const D3D11_DEFAULT_BLEND_FACTOR_RED: f32 = 1f32;
pub const D3D11_DEFAULT_BORDER_COLOR_COMPONENT: f32 = 0f32;
pub const D3D11_DEFAULT_DEPTH_BIAS: u32 = 0u32;
pub const D3D11_DEFAULT_DEPTH_BIAS_CLAMP: f32 = 0f32;
pub const D3D11_DEFAULT_MAX_ANISOTROPY: u32 = 16u32;
pub const D3D11_DEFAULT_MIP_LOD_BIAS: f32 = 0f32;
pub const D3D11_DEFAULT_RENDER_TARGET_ARRAY_INDEX: u32 = 0u32;
pub const D3D11_DEFAULT_SAMPLE_MASK: u32 = 4294967295u32;
pub const D3D11_DEFAULT_SCISSOR_ENDX: u32 = 0u32;
pub const D3D11_DEFAULT_SCISSOR_ENDY: u32 = 0u32;
pub const D3D11_DEFAULT_SCISSOR_STARTX: u32 = 0u32;
pub const D3D11_DEFAULT_SCISSOR_STARTY: u32 = 0u32;
pub const D3D11_DEFAULT_SLOPE_SCALED_DEPTH_BIAS: f32 = 0f32;
pub const D3D11_DEFAULT_STENCIL_READ_MASK: u32 = 255u32;
pub const D3D11_DEFAULT_STENCIL_REFERENCE: u32 = 0u32;
pub const D3D11_DEFAULT_STENCIL_WRITE_MASK: u32 = 255u32;
pub const D3D11_DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX: u32 = 0u32;
pub const D3D11_DEFAULT_VIEWPORT_HEIGHT: u32 = 0u32;
pub const D3D11_DEFAULT_VIEWPORT_MAX_DEPTH: f32 = 0f32;
pub const D3D11_DEFAULT_VIEWPORT_MIN_DEPTH: f32 = 0f32;
pub const D3D11_DEFAULT_VIEWPORT_TOPLEFTX: u32 = 0u32;
pub const D3D11_DEFAULT_VIEWPORT_TOPLEFTY: u32 = 0u32;
pub const D3D11_DEFAULT_VIEWPORT_WIDTH: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_DEPTH_STENCILOP_DESC {
    pub StencilFailOp: D3D11_STENCIL_OP,
    pub StencilDepthFailOp: D3D11_STENCIL_OP,
    pub StencilPassOp: D3D11_STENCIL_OP,
    pub StencilFunc: D3D11_COMPARISON_FUNC,
}
impl D3D11_DEPTH_STENCILOP_DESC {}
impl ::std::default::Default for D3D11_DEPTH_STENCILOP_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_DEPTH_STENCILOP_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_DEPTH_STENCILOP_DESC")
            .field("StencilFailOp", &self.StencilFailOp)
            .field("StencilDepthFailOp", &self.StencilDepthFailOp)
            .field("StencilPassOp", &self.StencilPassOp)
            .field("StencilFunc", &self.StencilFunc)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_DEPTH_STENCILOP_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.StencilFailOp == other.StencilFailOp
            && self.StencilDepthFailOp == other.StencilDepthFailOp
            && self.StencilPassOp == other.StencilPassOp
            && self.StencilFunc == other.StencilFunc
    }
}
impl ::std::cmp::Eq for D3D11_DEPTH_STENCILOP_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_DEPTH_STENCILOP_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_DEPTH_STENCIL_DESC {
    pub DepthEnable: super::super::Foundation::BOOL,
    pub DepthWriteMask: D3D11_DEPTH_WRITE_MASK,
    pub DepthFunc: D3D11_COMPARISON_FUNC,
    pub StencilEnable: super::super::Foundation::BOOL,
    pub StencilReadMask: u8,
    pub StencilWriteMask: u8,
    pub FrontFace: D3D11_DEPTH_STENCILOP_DESC,
    pub BackFace: D3D11_DEPTH_STENCILOP_DESC,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_DEPTH_STENCIL_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_DEPTH_STENCIL_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_DEPTH_STENCIL_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_DEPTH_STENCIL_DESC")
            .field("DepthEnable", &self.DepthEnable)
            .field("DepthWriteMask", &self.DepthWriteMask)
            .field("DepthFunc", &self.DepthFunc)
            .field("StencilEnable", &self.StencilEnable)
            .field("StencilReadMask", &self.StencilReadMask)
            .field("StencilWriteMask", &self.StencilWriteMask)
            .field("FrontFace", &self.FrontFace)
            .field("BackFace", &self.BackFace)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_DEPTH_STENCIL_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.DepthEnable == other.DepthEnable
            && self.DepthWriteMask == other.DepthWriteMask
            && self.DepthFunc == other.DepthFunc
            && self.StencilEnable == other.StencilEnable
            && self.StencilReadMask == other.StencilReadMask
            && self.StencilWriteMask == other.StencilWriteMask
            && self.FrontFace == other.FrontFace
            && self.BackFace == other.BackFace
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_DEPTH_STENCIL_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_DEPTH_STENCIL_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_DEPTH_STENCIL_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D11_DSV_DIMENSION,
    pub Flags: u32,
    pub Anonymous: D3D11_DEPTH_STENCIL_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_DEPTH_STENCIL_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_DEPTH_STENCIL_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_DEPTH_STENCIL_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_DEPTH_STENCIL_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_DEPTH_STENCIL_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_DEPTH_STENCIL_VIEW_DESC_0 {
    pub Texture1D: D3D11_TEX1D_DSV,
    pub Texture1DArray: D3D11_TEX1D_ARRAY_DSV,
    pub Texture2D: D3D11_TEX2D_DSV,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_DSV,
    pub Texture2DMS: D3D11_TEX2DMS_DSV,
    pub Texture2DMSArray: D3D11_TEX2DMS_ARRAY_DSV,
}
impl D3D11_DEPTH_STENCIL_VIEW_DESC_0 {}
impl ::std::default::Default for D3D11_DEPTH_STENCIL_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_DEPTH_STENCIL_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_DEPTH_STENCIL_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_DEPTH_STENCIL_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_DEPTH_WRITE_MASK(pub i32);
pub const D3D11_DEPTH_WRITE_MASK_ZERO: D3D11_DEPTH_WRITE_MASK = D3D11_DEPTH_WRITE_MASK(0i32);
pub const D3D11_DEPTH_WRITE_MASK_ALL: D3D11_DEPTH_WRITE_MASK = D3D11_DEPTH_WRITE_MASK(1i32);
impl ::std::convert::From<i32> for D3D11_DEPTH_WRITE_MASK {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_DEPTH_WRITE_MASK {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_DEVICE_CONTEXT_TYPE(pub i32);
pub const D3D11_DEVICE_CONTEXT_IMMEDIATE: D3D11_DEVICE_CONTEXT_TYPE =
    D3D11_DEVICE_CONTEXT_TYPE(0i32);
pub const D3D11_DEVICE_CONTEXT_DEFERRED: D3D11_DEVICE_CONTEXT_TYPE =
    D3D11_DEVICE_CONTEXT_TYPE(1i32);
impl ::std::convert::From<i32> for D3D11_DEVICE_CONTEXT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_DEVICE_CONTEXT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_DOMAIN_SHADER_TRACE_DESC {
    pub Invocation: u64,
}
impl D3D11_DOMAIN_SHADER_TRACE_DESC {}
impl ::std::default::Default for D3D11_DOMAIN_SHADER_TRACE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_DOMAIN_SHADER_TRACE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_DOMAIN_SHADER_TRACE_DESC")
            .field("Invocation", &self.Invocation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_DOMAIN_SHADER_TRACE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Invocation == other.Invocation
    }
}
impl ::std::cmp::Eq for D3D11_DOMAIN_SHADER_TRACE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_DOMAIN_SHADER_TRACE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {
    pub IndexCountPerInstance: u32,
    pub InstanceCount: u32,
    pub StartIndexLocation: u32,
    pub BaseVertexLocation: i32,
    pub StartInstanceLocation: u32,
}
impl D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {}
impl ::std::default::Default for D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS")
            .field("IndexCountPerInstance", &self.IndexCountPerInstance)
            .field("InstanceCount", &self.InstanceCount)
            .field("StartIndexLocation", &self.StartIndexLocation)
            .field("BaseVertexLocation", &self.BaseVertexLocation)
            .field("StartInstanceLocation", &self.StartInstanceLocation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {
    fn eq(&self, other: &Self) -> bool {
        self.IndexCountPerInstance == other.IndexCountPerInstance
            && self.InstanceCount == other.InstanceCount
            && self.StartIndexLocation == other.StartIndexLocation
            && self.BaseVertexLocation == other.BaseVertexLocation
            && self.StartInstanceLocation == other.StartInstanceLocation
    }
}
impl ::std::cmp::Eq for D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {}
unsafe impl ::windows::runtime::Abi for D3D11_DRAW_INDEXED_INSTANCED_INDIRECT_ARGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_DRAW_INSTANCED_INDIRECT_ARGS {
    pub VertexCountPerInstance: u32,
    pub InstanceCount: u32,
    pub StartVertexLocation: u32,
    pub StartInstanceLocation: u32,
}
impl D3D11_DRAW_INSTANCED_INDIRECT_ARGS {}
impl ::std::default::Default for D3D11_DRAW_INSTANCED_INDIRECT_ARGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_DRAW_INSTANCED_INDIRECT_ARGS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_DRAW_INSTANCED_INDIRECT_ARGS")
            .field("VertexCountPerInstance", &self.VertexCountPerInstance)
            .field("InstanceCount", &self.InstanceCount)
            .field("StartVertexLocation", &self.StartVertexLocation)
            .field("StartInstanceLocation", &self.StartInstanceLocation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_DRAW_INSTANCED_INDIRECT_ARGS {
    fn eq(&self, other: &Self) -> bool {
        self.VertexCountPerInstance == other.VertexCountPerInstance
            && self.InstanceCount == other.InstanceCount
            && self.StartVertexLocation == other.StartVertexLocation
            && self.StartInstanceLocation == other.StartInstanceLocation
    }
}
impl ::std::cmp::Eq for D3D11_DRAW_INSTANCED_INDIRECT_ARGS {}
unsafe impl ::windows::runtime::Abi for D3D11_DRAW_INSTANCED_INDIRECT_ARGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_DSV_DIMENSION(pub i32);
pub const D3D11_DSV_DIMENSION_UNKNOWN: D3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION(0i32);
pub const D3D11_DSV_DIMENSION_TEXTURE1D: D3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION(1i32);
pub const D3D11_DSV_DIMENSION_TEXTURE1DARRAY: D3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION(2i32);
pub const D3D11_DSV_DIMENSION_TEXTURE2D: D3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION(3i32);
pub const D3D11_DSV_DIMENSION_TEXTURE2DARRAY: D3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION(4i32);
pub const D3D11_DSV_DIMENSION_TEXTURE2DMS: D3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION(5i32);
pub const D3D11_DSV_DIMENSION_TEXTURE2DMSARRAY: D3D11_DSV_DIMENSION = D3D11_DSV_DIMENSION(6i32);
impl ::std::convert::From<i32> for D3D11_DSV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_DSV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_DSV_FLAG(pub i32);
pub const D3D11_DSV_READ_ONLY_DEPTH: D3D11_DSV_FLAG = D3D11_DSV_FLAG(1i32);
pub const D3D11_DSV_READ_ONLY_STENCIL: D3D11_DSV_FLAG = D3D11_DSV_FLAG(2i32);
impl ::std::convert::From<i32> for D3D11_DSV_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_DSV_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 = 3968u32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS: u32 = 3u32;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_DS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_DS_OUTPUT_REGISTER_COUNT: u32 = 32u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_ENCRYPTED_BLOCK_INFO {
    pub NumEncryptedBytesAtBeginning: u32,
    pub NumBytesInSkipPattern: u32,
    pub NumBytesInEncryptPattern: u32,
}
impl D3D11_ENCRYPTED_BLOCK_INFO {}
impl ::std::default::Default for D3D11_ENCRYPTED_BLOCK_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_ENCRYPTED_BLOCK_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_ENCRYPTED_BLOCK_INFO")
            .field(
                "NumEncryptedBytesAtBeginning",
                &self.NumEncryptedBytesAtBeginning,
            )
            .field("NumBytesInSkipPattern", &self.NumBytesInSkipPattern)
            .field("NumBytesInEncryptPattern", &self.NumBytesInEncryptPattern)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_ENCRYPTED_BLOCK_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.NumEncryptedBytesAtBeginning == other.NumEncryptedBytesAtBeginning
            && self.NumBytesInSkipPattern == other.NumBytesInSkipPattern
            && self.NumBytesInEncryptPattern == other.NumBytesInEncryptPattern
    }
}
impl ::std::cmp::Eq for D3D11_ENCRYPTED_BLOCK_INFO {}
unsafe impl ::windows::runtime::Abi for D3D11_ENCRYPTED_BLOCK_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FEATURE(pub i32);
pub const D3D11_FEATURE_THREADING: D3D11_FEATURE = D3D11_FEATURE(0i32);
pub const D3D11_FEATURE_DOUBLES: D3D11_FEATURE = D3D11_FEATURE(1i32);
pub const D3D11_FEATURE_FORMAT_SUPPORT: D3D11_FEATURE = D3D11_FEATURE(2i32);
pub const D3D11_FEATURE_FORMAT_SUPPORT2: D3D11_FEATURE = D3D11_FEATURE(3i32);
pub const D3D11_FEATURE_D3D10_X_HARDWARE_OPTIONS: D3D11_FEATURE = D3D11_FEATURE(4i32);
pub const D3D11_FEATURE_D3D11_OPTIONS: D3D11_FEATURE = D3D11_FEATURE(5i32);
pub const D3D11_FEATURE_ARCHITECTURE_INFO: D3D11_FEATURE = D3D11_FEATURE(6i32);
pub const D3D11_FEATURE_D3D9_OPTIONS: D3D11_FEATURE = D3D11_FEATURE(7i32);
pub const D3D11_FEATURE_SHADER_MIN_PRECISION_SUPPORT: D3D11_FEATURE = D3D11_FEATURE(8i32);
pub const D3D11_FEATURE_D3D9_SHADOW_SUPPORT: D3D11_FEATURE = D3D11_FEATURE(9i32);
pub const D3D11_FEATURE_D3D11_OPTIONS1: D3D11_FEATURE = D3D11_FEATURE(10i32);
pub const D3D11_FEATURE_D3D9_SIMPLE_INSTANCING_SUPPORT: D3D11_FEATURE = D3D11_FEATURE(11i32);
pub const D3D11_FEATURE_MARKER_SUPPORT: D3D11_FEATURE = D3D11_FEATURE(12i32);
pub const D3D11_FEATURE_D3D9_OPTIONS1: D3D11_FEATURE = D3D11_FEATURE(13i32);
pub const D3D11_FEATURE_D3D11_OPTIONS2: D3D11_FEATURE = D3D11_FEATURE(14i32);
pub const D3D11_FEATURE_D3D11_OPTIONS3: D3D11_FEATURE = D3D11_FEATURE(15i32);
pub const D3D11_FEATURE_GPU_VIRTUAL_ADDRESS_SUPPORT: D3D11_FEATURE = D3D11_FEATURE(16i32);
pub const D3D11_FEATURE_D3D11_OPTIONS4: D3D11_FEATURE = D3D11_FEATURE(17i32);
pub const D3D11_FEATURE_SHADER_CACHE: D3D11_FEATURE = D3D11_FEATURE(18i32);
pub const D3D11_FEATURE_D3D11_OPTIONS5: D3D11_FEATURE = D3D11_FEATURE(19i32);
pub const D3D11_FEATURE_DISPLAYABLE: D3D11_FEATURE = D3D11_FEATURE(20i32);
impl ::std::convert::From<i32> for D3D11_FEATURE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_ARCHITECTURE_INFO {
    pub TileBasedDeferredRenderer: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_ARCHITECTURE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_ARCHITECTURE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_ARCHITECTURE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_ARCHITECTURE_INFO")
            .field("TileBasedDeferredRenderer", &self.TileBasedDeferredRenderer)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_ARCHITECTURE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.TileBasedDeferredRenderer == other.TileBasedDeferredRenderer
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_ARCHITECTURE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_ARCHITECTURE_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    pub ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS")
            .field(
                "ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x",
                &self.ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x
            == other.ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D11_OPTIONS {
    pub OutputMergerLogicOp: super::super::Foundation::BOOL,
    pub UAVOnlyRenderingForcedSampleCount: super::super::Foundation::BOOL,
    pub DiscardAPIsSeenByDriver: super::super::Foundation::BOOL,
    pub FlagsForUpdateAndCopySeenByDriver: super::super::Foundation::BOOL,
    pub ClearView: super::super::Foundation::BOOL,
    pub CopyWithOverlap: super::super::Foundation::BOOL,
    pub ConstantBufferPartialUpdate: super::super::Foundation::BOOL,
    pub ConstantBufferOffsetting: super::super::Foundation::BOOL,
    pub MapNoOverwriteOnDynamicConstantBuffer: super::super::Foundation::BOOL,
    pub MapNoOverwriteOnDynamicBufferSRV: super::super::Foundation::BOOL,
    pub MultisampleRTVWithForcedSampleCountOne: super::super::Foundation::BOOL,
    pub SAD4ShaderInstructions: super::super::Foundation::BOOL,
    pub ExtendedDoublesShaderInstructions: super::super::Foundation::BOOL,
    pub ExtendedResourceSharing: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D11_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D11_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D11_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D11_OPTIONS")
            .field("OutputMergerLogicOp", &self.OutputMergerLogicOp)
            .field(
                "UAVOnlyRenderingForcedSampleCount",
                &self.UAVOnlyRenderingForcedSampleCount,
            )
            .field("DiscardAPIsSeenByDriver", &self.DiscardAPIsSeenByDriver)
            .field(
                "FlagsForUpdateAndCopySeenByDriver",
                &self.FlagsForUpdateAndCopySeenByDriver,
            )
            .field("ClearView", &self.ClearView)
            .field("CopyWithOverlap", &self.CopyWithOverlap)
            .field(
                "ConstantBufferPartialUpdate",
                &self.ConstantBufferPartialUpdate,
            )
            .field("ConstantBufferOffsetting", &self.ConstantBufferOffsetting)
            .field(
                "MapNoOverwriteOnDynamicConstantBuffer",
                &self.MapNoOverwriteOnDynamicConstantBuffer,
            )
            .field(
                "MapNoOverwriteOnDynamicBufferSRV",
                &self.MapNoOverwriteOnDynamicBufferSRV,
            )
            .field(
                "MultisampleRTVWithForcedSampleCountOne",
                &self.MultisampleRTVWithForcedSampleCountOne,
            )
            .field("SAD4ShaderInstructions", &self.SAD4ShaderInstructions)
            .field(
                "ExtendedDoublesShaderInstructions",
                &self.ExtendedDoublesShaderInstructions,
            )
            .field("ExtendedResourceSharing", &self.ExtendedResourceSharing)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D11_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.OutputMergerLogicOp == other.OutputMergerLogicOp
            && self.UAVOnlyRenderingForcedSampleCount == other.UAVOnlyRenderingForcedSampleCount
            && self.DiscardAPIsSeenByDriver == other.DiscardAPIsSeenByDriver
            && self.FlagsForUpdateAndCopySeenByDriver == other.FlagsForUpdateAndCopySeenByDriver
            && self.ClearView == other.ClearView
            && self.CopyWithOverlap == other.CopyWithOverlap
            && self.ConstantBufferPartialUpdate == other.ConstantBufferPartialUpdate
            && self.ConstantBufferOffsetting == other.ConstantBufferOffsetting
            && self.MapNoOverwriteOnDynamicConstantBuffer
                == other.MapNoOverwriteOnDynamicConstantBuffer
            && self.MapNoOverwriteOnDynamicBufferSRV == other.MapNoOverwriteOnDynamicBufferSRV
            && self.MultisampleRTVWithForcedSampleCountOne
                == other.MultisampleRTVWithForcedSampleCountOne
            && self.SAD4ShaderInstructions == other.SAD4ShaderInstructions
            && self.ExtendedDoublesShaderInstructions == other.ExtendedDoublesShaderInstructions
            && self.ExtendedResourceSharing == other.ExtendedResourceSharing
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D11_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D11_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D11_OPTIONS1 {
    pub TiledResourcesTier: D3D11_TILED_RESOURCES_TIER,
    pub MinMaxFiltering: super::super::Foundation::BOOL,
    pub ClearViewAlsoSupportsDepthOnlyFormats: super::super::Foundation::BOOL,
    pub MapOnDefaultBuffers: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D11_OPTIONS1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D11_OPTIONS1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D11_OPTIONS1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D11_OPTIONS1")
            .field("TiledResourcesTier", &self.TiledResourcesTier)
            .field("MinMaxFiltering", &self.MinMaxFiltering)
            .field(
                "ClearViewAlsoSupportsDepthOnlyFormats",
                &self.ClearViewAlsoSupportsDepthOnlyFormats,
            )
            .field("MapOnDefaultBuffers", &self.MapOnDefaultBuffers)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D11_OPTIONS1 {
    fn eq(&self, other: &Self) -> bool {
        self.TiledResourcesTier == other.TiledResourcesTier
            && self.MinMaxFiltering == other.MinMaxFiltering
            && self.ClearViewAlsoSupportsDepthOnlyFormats
                == other.ClearViewAlsoSupportsDepthOnlyFormats
            && self.MapOnDefaultBuffers == other.MapOnDefaultBuffers
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D11_OPTIONS1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D11_OPTIONS1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D11_OPTIONS2 {
    pub PSSpecifiedStencilRefSupported: super::super::Foundation::BOOL,
    pub TypedUAVLoadAdditionalFormats: super::super::Foundation::BOOL,
    pub ROVsSupported: super::super::Foundation::BOOL,
    pub ConservativeRasterizationTier: D3D11_CONSERVATIVE_RASTERIZATION_TIER,
    pub TiledResourcesTier: D3D11_TILED_RESOURCES_TIER,
    pub MapOnDefaultTextures: super::super::Foundation::BOOL,
    pub StandardSwizzle: super::super::Foundation::BOOL,
    pub UnifiedMemoryArchitecture: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D11_OPTIONS2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D11_OPTIONS2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D11_OPTIONS2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D11_OPTIONS2")
            .field(
                "PSSpecifiedStencilRefSupported",
                &self.PSSpecifiedStencilRefSupported,
            )
            .field(
                "TypedUAVLoadAdditionalFormats",
                &self.TypedUAVLoadAdditionalFormats,
            )
            .field("ROVsSupported", &self.ROVsSupported)
            .field(
                "ConservativeRasterizationTier",
                &self.ConservativeRasterizationTier,
            )
            .field("TiledResourcesTier", &self.TiledResourcesTier)
            .field("MapOnDefaultTextures", &self.MapOnDefaultTextures)
            .field("StandardSwizzle", &self.StandardSwizzle)
            .field("UnifiedMemoryArchitecture", &self.UnifiedMemoryArchitecture)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D11_OPTIONS2 {
    fn eq(&self, other: &Self) -> bool {
        self.PSSpecifiedStencilRefSupported == other.PSSpecifiedStencilRefSupported
            && self.TypedUAVLoadAdditionalFormats == other.TypedUAVLoadAdditionalFormats
            && self.ROVsSupported == other.ROVsSupported
            && self.ConservativeRasterizationTier == other.ConservativeRasterizationTier
            && self.TiledResourcesTier == other.TiledResourcesTier
            && self.MapOnDefaultTextures == other.MapOnDefaultTextures
            && self.StandardSwizzle == other.StandardSwizzle
            && self.UnifiedMemoryArchitecture == other.UnifiedMemoryArchitecture
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D11_OPTIONS2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D11_OPTIONS2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D11_OPTIONS3 {
    pub VPAndRTArrayIndexFromAnyShaderFeedingRasterizer: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D11_OPTIONS3 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D11_OPTIONS3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D11_OPTIONS3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D11_OPTIONS3")
            .field(
                "VPAndRTArrayIndexFromAnyShaderFeedingRasterizer",
                &self.VPAndRTArrayIndexFromAnyShaderFeedingRasterizer,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D11_OPTIONS3 {
    fn eq(&self, other: &Self) -> bool {
        self.VPAndRTArrayIndexFromAnyShaderFeedingRasterizer
            == other.VPAndRTArrayIndexFromAnyShaderFeedingRasterizer
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D11_OPTIONS3 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D11_OPTIONS3 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D11_OPTIONS4 {
    pub ExtendedNV12SharedTextureSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D11_OPTIONS4 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D11_OPTIONS4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D11_OPTIONS4 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D11_OPTIONS4")
            .field(
                "ExtendedNV12SharedTextureSupported",
                &self.ExtendedNV12SharedTextureSupported,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D11_OPTIONS4 {
    fn eq(&self, other: &Self) -> bool {
        self.ExtendedNV12SharedTextureSupported == other.ExtendedNV12SharedTextureSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D11_OPTIONS4 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D11_OPTIONS4 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_FEATURE_DATA_D3D11_OPTIONS5 {
    pub SharedResourceTier: D3D11_SHARED_RESOURCE_TIER,
}
impl D3D11_FEATURE_DATA_D3D11_OPTIONS5 {}
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D11_OPTIONS5 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D11_OPTIONS5 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D11_OPTIONS5")
            .field("SharedResourceTier", &self.SharedResourceTier)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D11_OPTIONS5 {
    fn eq(&self, other: &Self) -> bool {
        self.SharedResourceTier == other.SharedResourceTier
    }
}
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D11_OPTIONS5 {}
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D11_OPTIONS5 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D9_OPTIONS {
    pub FullNonPow2TextureSupport: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D9_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D9_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D9_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D9_OPTIONS")
            .field("FullNonPow2TextureSupport", &self.FullNonPow2TextureSupport)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D9_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.FullNonPow2TextureSupport == other.FullNonPow2TextureSupport
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D9_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D9_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D9_OPTIONS1 {
    pub FullNonPow2TextureSupported: super::super::Foundation::BOOL,
    pub DepthAsTextureWithLessEqualComparisonFilterSupported: super::super::Foundation::BOOL,
    pub SimpleInstancingSupported: super::super::Foundation::BOOL,
    pub TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D9_OPTIONS1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D9_OPTIONS1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D9_OPTIONS1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D9_OPTIONS1")
            .field(
                "FullNonPow2TextureSupported",
                &self.FullNonPow2TextureSupported,
            )
            .field(
                "DepthAsTextureWithLessEqualComparisonFilterSupported",
                &self.DepthAsTextureWithLessEqualComparisonFilterSupported,
            )
            .field("SimpleInstancingSupported", &self.SimpleInstancingSupported)
            .field(
                "TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported",
                &self.TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D9_OPTIONS1 {
    fn eq(&self, other: &Self) -> bool {
        self.FullNonPow2TextureSupported == other.FullNonPow2TextureSupported
            && self.DepthAsTextureWithLessEqualComparisonFilterSupported
                == other.DepthAsTextureWithLessEqualComparisonFilterSupported
            && self.SimpleInstancingSupported == other.SimpleInstancingSupported
            && self.TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported
                == other.TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D9_OPTIONS1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D9_OPTIONS1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {
    pub SupportsDepthAsTextureWithLessEqualComparisonFilter: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT")
            .field(
                "SupportsDepthAsTextureWithLessEqualComparisonFilter",
                &self.SupportsDepthAsTextureWithLessEqualComparisonFilter,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.SupportsDepthAsTextureWithLessEqualComparisonFilter
            == other.SupportsDepthAsTextureWithLessEqualComparisonFilter
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D9_SHADOW_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {
    pub SimpleInstancingSupported: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT")
            .field("SimpleInstancingSupported", &self.SimpleInstancingSupported)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.SimpleInstancingSupported == other.SimpleInstancingSupported
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_DISPLAYABLE {
    pub DisplayableTexture: super::super::Foundation::BOOL,
    pub SharedResourceTier: D3D11_SHARED_RESOURCE_TIER,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_DISPLAYABLE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_DISPLAYABLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_DISPLAYABLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_DISPLAYABLE")
            .field("DisplayableTexture", &self.DisplayableTexture)
            .field("SharedResourceTier", &self.SharedResourceTier)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_DISPLAYABLE {
    fn eq(&self, other: &Self) -> bool {
        self.DisplayableTexture == other.DisplayableTexture
            && self.SharedResourceTier == other.SharedResourceTier
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_DISPLAYABLE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_DISPLAYABLE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_DOUBLES {
    pub DoublePrecisionFloatShaderOps: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_DOUBLES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_DOUBLES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_DOUBLES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_DOUBLES")
            .field(
                "DoublePrecisionFloatShaderOps",
                &self.DoublePrecisionFloatShaderOps,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_DOUBLES {
    fn eq(&self, other: &Self) -> bool {
        self.DoublePrecisionFloatShaderOps == other.DoublePrecisionFloatShaderOps
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_DOUBLES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_DOUBLES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_FEATURE_DATA_FORMAT_SUPPORT {
    pub InFormat: super::Dxgi::DXGI_FORMAT,
    pub OutFormatSupport: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_FEATURE_DATA_FORMAT_SUPPORT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_FEATURE_DATA_FORMAT_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_FORMAT_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_FORMAT_SUPPORT")
            .field("InFormat", &self.InFormat)
            .field("OutFormatSupport", &self.OutFormatSupport)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_FORMAT_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.InFormat == other.InFormat && self.OutFormatSupport == other.OutFormatSupport
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_FORMAT_SUPPORT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_FORMAT_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {
    pub InFormat: super::Dxgi::DXGI_FORMAT,
    pub OutFormatSupport2: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_FORMAT_SUPPORT2")
            .field("InFormat", &self.InFormat)
            .field("OutFormatSupport2", &self.OutFormatSupport2)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {
    fn eq(&self, other: &Self) -> bool {
        self.InFormat == other.InFormat && self.OutFormatSupport2 == other.OutFormatSupport2
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_FORMAT_SUPPORT2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    pub MaxGPUVirtualAddressBitsPerResource: u32,
    pub MaxGPUVirtualAddressBitsPerProcess: u32,
}
impl D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {}
impl ::std::default::Default for D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT")
            .field(
                "MaxGPUVirtualAddressBitsPerResource",
                &self.MaxGPUVirtualAddressBitsPerResource,
            )
            .field(
                "MaxGPUVirtualAddressBitsPerProcess",
                &self.MaxGPUVirtualAddressBitsPerProcess,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.MaxGPUVirtualAddressBitsPerResource == other.MaxGPUVirtualAddressBitsPerResource
            && self.MaxGPUVirtualAddressBitsPerProcess == other.MaxGPUVirtualAddressBitsPerProcess
    }
}
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {}
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_MARKER_SUPPORT {
    pub Profile: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_MARKER_SUPPORT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_MARKER_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_MARKER_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_MARKER_SUPPORT")
            .field("Profile", &self.Profile)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_MARKER_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.Profile == other.Profile
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_MARKER_SUPPORT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_MARKER_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_FEATURE_DATA_SHADER_CACHE {
    pub SupportFlags: u32,
}
impl D3D11_FEATURE_DATA_SHADER_CACHE {}
impl ::std::default::Default for D3D11_FEATURE_DATA_SHADER_CACHE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_SHADER_CACHE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_SHADER_CACHE")
            .field("SupportFlags", &self.SupportFlags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_SHADER_CACHE {
    fn eq(&self, other: &Self) -> bool {
        self.SupportFlags == other.SupportFlags
    }
}
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_SHADER_CACHE {}
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_SHADER_CACHE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {
    pub PixelShaderMinPrecision: u32,
    pub AllOtherShaderStagesMinPrecision: u32,
}
impl D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {}
impl ::std::default::Default for D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT")
            .field("PixelShaderMinPrecision", &self.PixelShaderMinPrecision)
            .field(
                "AllOtherShaderStagesMinPrecision",
                &self.AllOtherShaderStagesMinPrecision,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {
    fn eq(&self, other: &Self) -> bool {
        self.PixelShaderMinPrecision == other.PixelShaderMinPrecision
            && self.AllOtherShaderStagesMinPrecision == other.AllOtherShaderStagesMinPrecision
    }
}
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {}
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FEATURE_DATA_THREADING {
    pub DriverConcurrentCreates: super::super::Foundation::BOOL,
    pub DriverCommandLists: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FEATURE_DATA_THREADING {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FEATURE_DATA_THREADING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_THREADING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_THREADING")
            .field("DriverConcurrentCreates", &self.DriverConcurrentCreates)
            .field("DriverCommandLists", &self.DriverCommandLists)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_THREADING {
    fn eq(&self, other: &Self) -> bool {
        self.DriverConcurrentCreates == other.DriverConcurrentCreates
            && self.DriverCommandLists == other.DriverCommandLists
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_THREADING {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_THREADING {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM {
    pub DecoderDesc: D3D11_VIDEO_DECODER_DESC,
    pub Components: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS,
    pub BinCount: u32,
    pub CounterBitDepth: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM")
            .field("DecoderDesc", &self.DecoderDesc)
            .field("Components", &self.Components)
            .field("BinCount", &self.BinCount)
            .field("CounterBitDepth", &self.CounterBitDepth)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM {
    fn eq(&self, other: &Self) -> bool {
        self.DecoderDesc == other.DecoderDesc
            && self.Components == other.Components
            && self.BinCount == other.BinCount
            && self.CounterBitDepth == other.CounterBitDepth
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_DATA_VIDEO_DECODER_HISTOGRAM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FEATURE_VIDEO(pub i32);
pub const D3D11_FEATURE_VIDEO_DECODER_HISTOGRAM: D3D11_FEATURE_VIDEO = D3D11_FEATURE_VIDEO(0i32);
impl ::std::convert::From<i32> for D3D11_FEATURE_VIDEO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FEATURE_VIDEO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FENCE_FLAG(pub u32);
pub const D3D11_FENCE_FLAG_NONE: D3D11_FENCE_FLAG = D3D11_FENCE_FLAG(0u32);
pub const D3D11_FENCE_FLAG_SHARED: D3D11_FENCE_FLAG = D3D11_FENCE_FLAG(2u32);
pub const D3D11_FENCE_FLAG_SHARED_CROSS_ADAPTER: D3D11_FENCE_FLAG = D3D11_FENCE_FLAG(4u32);
pub const D3D11_FENCE_FLAG_NON_MONITORED: D3D11_FENCE_FLAG = D3D11_FENCE_FLAG(8u32);
impl ::std::convert::From<u32> for D3D11_FENCE_FLAG {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FENCE_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D11_FENCE_FLAG {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D11_FENCE_FLAG {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D11_FENCE_FLAG {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D11_FENCE_FLAG {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D11_FENCE_FLAG {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FILL_MODE(pub i32);
pub const D3D11_FILL_WIREFRAME: D3D11_FILL_MODE = D3D11_FILL_MODE(2i32);
pub const D3D11_FILL_SOLID: D3D11_FILL_MODE = D3D11_FILL_MODE(3i32);
impl ::std::convert::From<i32> for D3D11_FILL_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FILL_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FILTER(pub i32);
pub const D3D11_FILTER_MIN_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(0i32);
pub const D3D11_FILTER_MIN_MAG_POINT_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(1i32);
pub const D3D11_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D11_FILTER = D3D11_FILTER(4i32);
pub const D3D11_FILTER_MIN_POINT_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(5i32);
pub const D3D11_FILTER_MIN_LINEAR_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(16i32);
pub const D3D11_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(17i32);
pub const D3D11_FILTER_MIN_MAG_LINEAR_MIP_POINT: D3D11_FILTER = D3D11_FILTER(20i32);
pub const D3D11_FILTER_MIN_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(21i32);
pub const D3D11_FILTER_ANISOTROPIC: D3D11_FILTER = D3D11_FILTER(85i32);
pub const D3D11_FILTER_COMPARISON_MIN_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(128i32);
pub const D3D11_FILTER_COMPARISON_MIN_MAG_POINT_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(129i32);
pub const D3D11_FILTER_COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D11_FILTER =
    D3D11_FILTER(132i32);
pub const D3D11_FILTER_COMPARISON_MIN_POINT_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(133i32);
pub const D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(144i32);
pub const D3D11_FILTER_COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D11_FILTER =
    D3D11_FILTER(145i32);
pub const D3D11_FILTER_COMPARISON_MIN_MAG_LINEAR_MIP_POINT: D3D11_FILTER = D3D11_FILTER(148i32);
pub const D3D11_FILTER_COMPARISON_MIN_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(149i32);
pub const D3D11_FILTER_COMPARISON_ANISOTROPIC: D3D11_FILTER = D3D11_FILTER(213i32);
pub const D3D11_FILTER_MINIMUM_MIN_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(256i32);
pub const D3D11_FILTER_MINIMUM_MIN_MAG_POINT_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(257i32);
pub const D3D11_FILTER_MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D11_FILTER = D3D11_FILTER(260i32);
pub const D3D11_FILTER_MINIMUM_MIN_POINT_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(261i32);
pub const D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(272i32);
pub const D3D11_FILTER_MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(273i32);
pub const D3D11_FILTER_MINIMUM_MIN_MAG_LINEAR_MIP_POINT: D3D11_FILTER = D3D11_FILTER(276i32);
pub const D3D11_FILTER_MINIMUM_MIN_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(277i32);
pub const D3D11_FILTER_MINIMUM_ANISOTROPIC: D3D11_FILTER = D3D11_FILTER(341i32);
pub const D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(384i32);
pub const D3D11_FILTER_MAXIMUM_MIN_MAG_POINT_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(385i32);
pub const D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT: D3D11_FILTER = D3D11_FILTER(388i32);
pub const D3D11_FILTER_MAXIMUM_MIN_POINT_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(389i32);
pub const D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_MIP_POINT: D3D11_FILTER = D3D11_FILTER(400i32);
pub const D3D11_FILTER_MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(401i32);
pub const D3D11_FILTER_MAXIMUM_MIN_MAG_LINEAR_MIP_POINT: D3D11_FILTER = D3D11_FILTER(404i32);
pub const D3D11_FILTER_MAXIMUM_MIN_MAG_MIP_LINEAR: D3D11_FILTER = D3D11_FILTER(405i32);
pub const D3D11_FILTER_MAXIMUM_ANISOTROPIC: D3D11_FILTER = D3D11_FILTER(469i32);
impl ::std::convert::From<i32> for D3D11_FILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FILTER_REDUCTION_TYPE(pub i32);
pub const D3D11_FILTER_REDUCTION_TYPE_STANDARD: D3D11_FILTER_REDUCTION_TYPE =
    D3D11_FILTER_REDUCTION_TYPE(0i32);
pub const D3D11_FILTER_REDUCTION_TYPE_COMPARISON: D3D11_FILTER_REDUCTION_TYPE =
    D3D11_FILTER_REDUCTION_TYPE(1i32);
pub const D3D11_FILTER_REDUCTION_TYPE_MINIMUM: D3D11_FILTER_REDUCTION_TYPE =
    D3D11_FILTER_REDUCTION_TYPE(2i32);
pub const D3D11_FILTER_REDUCTION_TYPE_MAXIMUM: D3D11_FILTER_REDUCTION_TYPE =
    D3D11_FILTER_REDUCTION_TYPE(3i32);
impl ::std::convert::From<i32> for D3D11_FILTER_REDUCTION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FILTER_REDUCTION_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_FILTER_REDUCTION_TYPE_MASK: u32 = 3u32;
pub const D3D11_FILTER_REDUCTION_TYPE_SHIFT: u32 = 7u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FILTER_TYPE(pub i32);
pub const D3D11_FILTER_TYPE_POINT: D3D11_FILTER_TYPE = D3D11_FILTER_TYPE(0i32);
pub const D3D11_FILTER_TYPE_LINEAR: D3D11_FILTER_TYPE = D3D11_FILTER_TYPE(1i32);
impl ::std::convert::From<i32> for D3D11_FILTER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FILTER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_FILTER_TYPE_MASK: u32 = 3u32;
pub const D3D11_FLOAT16_FUSED_TOLERANCE_IN_ULP: f64 = 0.6f64;
pub const D3D11_FLOAT32_MAX: f32 = 340282350000000000000000000000000000000f32;
pub const D3D11_FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP: f32 = 0.6f32;
pub const D3D11_FLOAT_TO_SRGB_EXPONENT_DENOMINATOR: f32 = 2.4f32;
pub const D3D11_FLOAT_TO_SRGB_EXPONENT_NUMERATOR: f32 = 1f32;
pub const D3D11_FLOAT_TO_SRGB_OFFSET: f32 = 0.055f32;
pub const D3D11_FLOAT_TO_SRGB_SCALE_1: f32 = 12.92f32;
pub const D3D11_FLOAT_TO_SRGB_SCALE_2: f32 = 1.055f32;
pub const D3D11_FLOAT_TO_SRGB_THRESHOLD: f32 = 0.0031308f32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FORMAT_SUPPORT(pub i32);
pub const D3D11_FORMAT_SUPPORT_BUFFER: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(1i32);
pub const D3D11_FORMAT_SUPPORT_IA_VERTEX_BUFFER: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(2i32);
pub const D3D11_FORMAT_SUPPORT_IA_INDEX_BUFFER: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(4i32);
pub const D3D11_FORMAT_SUPPORT_SO_BUFFER: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(8i32);
pub const D3D11_FORMAT_SUPPORT_TEXTURE1D: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(16i32);
pub const D3D11_FORMAT_SUPPORT_TEXTURE2D: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(32i32);
pub const D3D11_FORMAT_SUPPORT_TEXTURE3D: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(64i32);
pub const D3D11_FORMAT_SUPPORT_TEXTURECUBE: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(128i32);
pub const D3D11_FORMAT_SUPPORT_SHADER_LOAD: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(256i32);
pub const D3D11_FORMAT_SUPPORT_SHADER_SAMPLE: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(512i32);
pub const D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_COMPARISON: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(1024i32);
pub const D3D11_FORMAT_SUPPORT_SHADER_SAMPLE_MONO_TEXT: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(2048i32);
pub const D3D11_FORMAT_SUPPORT_MIP: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(4096i32);
pub const D3D11_FORMAT_SUPPORT_MIP_AUTOGEN: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(8192i32);
pub const D3D11_FORMAT_SUPPORT_RENDER_TARGET: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(16384i32);
pub const D3D11_FORMAT_SUPPORT_BLENDABLE: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(32768i32);
pub const D3D11_FORMAT_SUPPORT_DEPTH_STENCIL: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(65536i32);
pub const D3D11_FORMAT_SUPPORT_CPU_LOCKABLE: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(131072i32);
pub const D3D11_FORMAT_SUPPORT_MULTISAMPLE_RESOLVE: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(262144i32);
pub const D3D11_FORMAT_SUPPORT_DISPLAY: D3D11_FORMAT_SUPPORT = D3D11_FORMAT_SUPPORT(524288i32);
pub const D3D11_FORMAT_SUPPORT_CAST_WITHIN_BIT_LAYOUT: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(1048576i32);
pub const D3D11_FORMAT_SUPPORT_MULTISAMPLE_RENDERTARGET: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(2097152i32);
pub const D3D11_FORMAT_SUPPORT_MULTISAMPLE_LOAD: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(4194304i32);
pub const D3D11_FORMAT_SUPPORT_SHADER_GATHER: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(8388608i32);
pub const D3D11_FORMAT_SUPPORT_BACK_BUFFER_CAST: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(16777216i32);
pub const D3D11_FORMAT_SUPPORT_TYPED_UNORDERED_ACCESS_VIEW: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(33554432i32);
pub const D3D11_FORMAT_SUPPORT_SHADER_GATHER_COMPARISON: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(67108864i32);
pub const D3D11_FORMAT_SUPPORT_DECODER_OUTPUT: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(134217728i32);
pub const D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_OUTPUT: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(268435456i32);
pub const D3D11_FORMAT_SUPPORT_VIDEO_PROCESSOR_INPUT: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(536870912i32);
pub const D3D11_FORMAT_SUPPORT_VIDEO_ENCODER: D3D11_FORMAT_SUPPORT =
    D3D11_FORMAT_SUPPORT(1073741824i32);
impl ::std::convert::From<i32> for D3D11_FORMAT_SUPPORT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FORMAT_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_FORMAT_SUPPORT2(pub i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_ADD: D3D11_FORMAT_SUPPORT2 = D3D11_FORMAT_SUPPORT2(1i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_BITWISE_OPS: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(2i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE:
    D3D11_FORMAT_SUPPORT2 = D3D11_FORMAT_SUPPORT2(4i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_EXCHANGE: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(8i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_SIGNED_MIN_OR_MAX: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(16i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_ATOMIC_UNSIGNED_MIN_OR_MAX: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(32i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_TYPED_LOAD: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(64i32);
pub const D3D11_FORMAT_SUPPORT2_UAV_TYPED_STORE: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(128i32);
pub const D3D11_FORMAT_SUPPORT2_OUTPUT_MERGER_LOGIC_OP: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(256i32);
pub const D3D11_FORMAT_SUPPORT2_TILED: D3D11_FORMAT_SUPPORT2 = D3D11_FORMAT_SUPPORT2(512i32);
pub const D3D11_FORMAT_SUPPORT2_SHAREABLE: D3D11_FORMAT_SUPPORT2 = D3D11_FORMAT_SUPPORT2(1024i32);
pub const D3D11_FORMAT_SUPPORT2_MULTIPLANE_OVERLAY: D3D11_FORMAT_SUPPORT2 =
    D3D11_FORMAT_SUPPORT2(16384i32);
impl ::std::convert::From<i32> for D3D11_FORMAT_SUPPORT2 {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_FORMAT_SUPPORT2 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_FTOI_INSTRUCTION_MAX_INPUT: f32 = 2147483600f32;
pub const D3D11_FTOI_INSTRUCTION_MIN_INPUT: f32 = -2147483600f32;
pub const D3D11_FTOU_INSTRUCTION_MAX_INPUT: f32 = 4294967300f32;
pub const D3D11_FTOU_INSTRUCTION_MIN_INPUT: f32 = 0f32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_FUNCTION_DESC {
    pub Version: u32,
    pub Creator: super::super::Foundation::PSTR,
    pub Flags: u32,
    pub ConstantBuffers: u32,
    pub BoundResources: u32,
    pub InstructionCount: u32,
    pub TempRegisterCount: u32,
    pub TempArrayCount: u32,
    pub DefCount: u32,
    pub DclCount: u32,
    pub TextureNormalInstructions: u32,
    pub TextureLoadInstructions: u32,
    pub TextureCompInstructions: u32,
    pub TextureBiasInstructions: u32,
    pub TextureGradientInstructions: u32,
    pub FloatInstructionCount: u32,
    pub IntInstructionCount: u32,
    pub UintInstructionCount: u32,
    pub StaticFlowControlCount: u32,
    pub DynamicFlowControlCount: u32,
    pub MacroInstructionCount: u32,
    pub ArrayInstructionCount: u32,
    pub MovInstructionCount: u32,
    pub MovcInstructionCount: u32,
    pub ConversionInstructionCount: u32,
    pub BitwiseInstructionCount: u32,
    pub MinFeatureLevel: D3D_FEATURE_LEVEL,
    pub RequiredFeatureFlags: u64,
    pub Name: super::super::Foundation::PSTR,
    pub FunctionParameterCount: i32,
    pub HasReturn: super::super::Foundation::BOOL,
    pub Has10Level9VertexShader: super::super::Foundation::BOOL,
    pub Has10Level9PixelShader: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_FUNCTION_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_FUNCTION_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_FUNCTION_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_FUNCTION_DESC")
            .field("Version", &self.Version)
            .field("Creator", &self.Creator)
            .field("Flags", &self.Flags)
            .field("ConstantBuffers", &self.ConstantBuffers)
            .field("BoundResources", &self.BoundResources)
            .field("InstructionCount", &self.InstructionCount)
            .field("TempRegisterCount", &self.TempRegisterCount)
            .field("TempArrayCount", &self.TempArrayCount)
            .field("DefCount", &self.DefCount)
            .field("DclCount", &self.DclCount)
            .field("TextureNormalInstructions", &self.TextureNormalInstructions)
            .field("TextureLoadInstructions", &self.TextureLoadInstructions)
            .field("TextureCompInstructions", &self.TextureCompInstructions)
            .field("TextureBiasInstructions", &self.TextureBiasInstructions)
            .field(
                "TextureGradientInstructions",
                &self.TextureGradientInstructions,
            )
            .field("FloatInstructionCount", &self.FloatInstructionCount)
            .field("IntInstructionCount", &self.IntInstructionCount)
            .field("UintInstructionCount", &self.UintInstructionCount)
            .field("StaticFlowControlCount", &self.StaticFlowControlCount)
            .field("DynamicFlowControlCount", &self.DynamicFlowControlCount)
            .field("MacroInstructionCount", &self.MacroInstructionCount)
            .field("ArrayInstructionCount", &self.ArrayInstructionCount)
            .field("MovInstructionCount", &self.MovInstructionCount)
            .field("MovcInstructionCount", &self.MovcInstructionCount)
            .field(
                "ConversionInstructionCount",
                &self.ConversionInstructionCount,
            )
            .field("BitwiseInstructionCount", &self.BitwiseInstructionCount)
            .field("MinFeatureLevel", &self.MinFeatureLevel)
            .field("RequiredFeatureFlags", &self.RequiredFeatureFlags)
            .field("Name", &self.Name)
            .field("FunctionParameterCount", &self.FunctionParameterCount)
            .field("HasReturn", &self.HasReturn)
            .field("Has10Level9VertexShader", &self.Has10Level9VertexShader)
            .field("Has10Level9PixelShader", &self.Has10Level9PixelShader)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_FUNCTION_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version
            && self.Creator == other.Creator
            && self.Flags == other.Flags
            && self.ConstantBuffers == other.ConstantBuffers
            && self.BoundResources == other.BoundResources
            && self.InstructionCount == other.InstructionCount
            && self.TempRegisterCount == other.TempRegisterCount
            && self.TempArrayCount == other.TempArrayCount
            && self.DefCount == other.DefCount
            && self.DclCount == other.DclCount
            && self.TextureNormalInstructions == other.TextureNormalInstructions
            && self.TextureLoadInstructions == other.TextureLoadInstructions
            && self.TextureCompInstructions == other.TextureCompInstructions
            && self.TextureBiasInstructions == other.TextureBiasInstructions
            && self.TextureGradientInstructions == other.TextureGradientInstructions
            && self.FloatInstructionCount == other.FloatInstructionCount
            && self.IntInstructionCount == other.IntInstructionCount
            && self.UintInstructionCount == other.UintInstructionCount
            && self.StaticFlowControlCount == other.StaticFlowControlCount
            && self.DynamicFlowControlCount == other.DynamicFlowControlCount
            && self.MacroInstructionCount == other.MacroInstructionCount
            && self.ArrayInstructionCount == other.ArrayInstructionCount
            && self.MovInstructionCount == other.MovInstructionCount
            && self.MovcInstructionCount == other.MovcInstructionCount
            && self.ConversionInstructionCount == other.ConversionInstructionCount
            && self.BitwiseInstructionCount == other.BitwiseInstructionCount
            && self.MinFeatureLevel == other.MinFeatureLevel
            && self.RequiredFeatureFlags == other.RequiredFeatureFlags
            && self.Name == other.Name
            && self.FunctionParameterCount == other.FunctionParameterCount
            && self.HasReturn == other.HasReturn
            && self.Has10Level9VertexShader == other.Has10Level9VertexShader
            && self.Has10Level9PixelShader == other.Has10Level9PixelShader
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_FUNCTION_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_FUNCTION_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_GEOMETRY_SHADER_TRACE_DESC {
    pub Invocation: u64,
}
impl D3D11_GEOMETRY_SHADER_TRACE_DESC {}
impl ::std::default::Default for D3D11_GEOMETRY_SHADER_TRACE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_GEOMETRY_SHADER_TRACE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_GEOMETRY_SHADER_TRACE_DESC")
            .field("Invocation", &self.Invocation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_GEOMETRY_SHADER_TRACE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Invocation == other.Invocation
    }
}
impl ::std::cmp::Eq for D3D11_GEOMETRY_SHADER_TRACE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_GEOMETRY_SHADER_TRACE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_GS_INPUT_INSTANCE_ID_READS_PER_INST: u32 = 2u32;
pub const D3D11_GS_INPUT_INSTANCE_ID_READ_PORTS: u32 = 1u32;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_GS_INPUT_INSTANCE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_GS_INPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_GS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_GS_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_GS_INPUT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_GS_INPUT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_GS_INPUT_REGISTER_VERTICES: u32 = 32u32;
pub const D3D11_GS_MAX_INSTANCE_COUNT: u32 = 32u32;
pub const D3D11_GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES: u32 = 1024u32;
pub const D3D11_GS_OUTPUT_ELEMENTS: u32 = 32u32;
pub const D3D11_GS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_GS_OUTPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_HS_CONTROL_POINT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 = 4294967295u32;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND: u32 = 4294967295u32;
pub const D3D11_HS_MAXTESSFACTOR_LOWER_BOUND: f32 = 1f32;
pub const D3D11_HS_MAXTESSFACTOR_UPPER_BOUND: f32 = 64f32;
pub const D3D11_HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS: u32 = 3968u32;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS: u32 = 128u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_HULL_SHADER_TRACE_DESC {
    pub Invocation: u64,
}
impl D3D11_HULL_SHADER_TRACE_DESC {}
impl ::std::default::Default for D3D11_HULL_SHADER_TRACE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_HULL_SHADER_TRACE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_HULL_SHADER_TRACE_DESC")
            .field("Invocation", &self.Invocation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_HULL_SHADER_TRACE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Invocation == other.Invocation
    }
}
impl ::std::cmp::Eq for D3D11_HULL_SHADER_TRACE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_HULL_SHADER_TRACE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES: u32 = 0u32;
pub const D3D11_IA_DEFAULT_PRIMITIVE_TOPOLOGY: u32 = 0u32;
pub const D3D11_IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES: u32 = 0u32;
pub const D3D11_IA_INDEX_INPUT_RESOURCE_SLOT_COUNT: u32 = 1u32;
pub const D3D11_IA_INSTANCE_ID_BIT_COUNT: u32 = 32u32;
pub const D3D11_IA_INTEGER_ARITHMETIC_BIT_COUNT: u32 = 32u32;
pub const D3D11_IA_PATCH_MAX_CONTROL_POINT_COUNT: u32 = 32u32;
pub const D3D11_IA_PRIMITIVE_ID_BIT_COUNT: u32 = 32u32;
pub const D3D11_IA_VERTEX_ID_BIT_COUNT: u32 = 32u32;
pub const D3D11_IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT: u32 = 32u32;
pub const D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS: u32 = 128u32;
pub const D3D11_IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT: u32 = 32u32;
pub const D3D11_INFO_QUEUE_DEFAULT_MESSAGE_COUNT_LIMIT: u32 = 1024u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_INFO_QUEUE_FILTER {
    pub AllowList: D3D11_INFO_QUEUE_FILTER_DESC,
    pub DenyList: D3D11_INFO_QUEUE_FILTER_DESC,
}
impl D3D11_INFO_QUEUE_FILTER {}
impl ::std::default::Default for D3D11_INFO_QUEUE_FILTER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_INFO_QUEUE_FILTER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_INFO_QUEUE_FILTER")
            .field("AllowList", &self.AllowList)
            .field("DenyList", &self.DenyList)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_INFO_QUEUE_FILTER {
    fn eq(&self, other: &Self) -> bool {
        self.AllowList == other.AllowList && self.DenyList == other.DenyList
    }
}
impl ::std::cmp::Eq for D3D11_INFO_QUEUE_FILTER {}
unsafe impl ::windows::runtime::Abi for D3D11_INFO_QUEUE_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_INFO_QUEUE_FILTER_DESC {
    pub NumCategories: u32,
    pub pCategoryList: *mut D3D11_MESSAGE_CATEGORY,
    pub NumSeverities: u32,
    pub pSeverityList: *mut D3D11_MESSAGE_SEVERITY,
    pub NumIDs: u32,
    pub pIDList: *mut D3D11_MESSAGE_ID,
}
impl D3D11_INFO_QUEUE_FILTER_DESC {}
impl ::std::default::Default for D3D11_INFO_QUEUE_FILTER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_INFO_QUEUE_FILTER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_INFO_QUEUE_FILTER_DESC")
            .field("NumCategories", &self.NumCategories)
            .field("pCategoryList", &self.pCategoryList)
            .field("NumSeverities", &self.NumSeverities)
            .field("pSeverityList", &self.pSeverityList)
            .field("NumIDs", &self.NumIDs)
            .field("pIDList", &self.pIDList)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_INFO_QUEUE_FILTER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.NumCategories == other.NumCategories
            && self.pCategoryList == other.pCategoryList
            && self.NumSeverities == other.NumSeverities
            && self.pSeverityList == other.pSeverityList
            && self.NumIDs == other.NumIDs
            && self.pIDList == other.pIDList
    }
}
impl ::std::cmp::Eq for D3D11_INFO_QUEUE_FILTER_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_INFO_QUEUE_FILTER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_INPUT_CLASSIFICATION(pub i32);
pub const D3D11_INPUT_PER_VERTEX_DATA: D3D11_INPUT_CLASSIFICATION =
    D3D11_INPUT_CLASSIFICATION(0i32);
pub const D3D11_INPUT_PER_INSTANCE_DATA: D3D11_INPUT_CLASSIFICATION =
    D3D11_INPUT_CLASSIFICATION(1i32);
impl ::std::convert::From<i32> for D3D11_INPUT_CLASSIFICATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_INPUT_CLASSIFICATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D11_INPUT_ELEMENT_DESC {
    pub SemanticName: super::super::Foundation::PSTR,
    pub SemanticIndex: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub InputSlot: u32,
    pub AlignedByteOffset: u32,
    pub InputSlotClass: D3D11_INPUT_CLASSIFICATION,
    pub InstanceDataStepRate: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D11_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D11_INPUT_ELEMENT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D3D11_INPUT_ELEMENT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_INPUT_ELEMENT_DESC")
            .field("SemanticName", &self.SemanticName)
            .field("SemanticIndex", &self.SemanticIndex)
            .field("Format", &self.Format)
            .field("InputSlot", &self.InputSlot)
            .field("AlignedByteOffset", &self.AlignedByteOffset)
            .field("InputSlotClass", &self.InputSlotClass)
            .field("InstanceDataStepRate", &self.InstanceDataStepRate)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D11_INPUT_ELEMENT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.SemanticName == other.SemanticName
            && self.SemanticIndex == other.SemanticIndex
            && self.Format == other.Format
            && self.InputSlot == other.InputSlot
            && self.AlignedByteOffset == other.AlignedByteOffset
            && self.InputSlotClass == other.InputSlotClass
            && self.InstanceDataStepRate == other.InstanceDataStepRate
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D11_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D11_INPUT_ELEMENT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_INTEGER_DIVIDE_BY_ZERO_QUOTIENT: u32 = 4294967295u32;
pub const D3D11_INTEGER_DIVIDE_BY_ZERO_REMAINDER: u32 = 4294967295u32;
pub const D3D11_KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL: u32 = 4294967295u32;
pub const D3D11_KEEP_UNORDERED_ACCESS_VIEWS: u32 = 4294967295u32;
pub const D3D11_KEY_EXCHANGE_HW_PROTECTION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2971078026,
        25229,
        19875,
        [173, 59, 130, 221, 176, 139, 73, 112],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA {
    pub HWProtectionFunctionID: u32,
    pub pInputData: *mut D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA,
    pub pOutputData: *mut D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA,
    pub Status: ::windows::runtime::HRESULT,
}
impl D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA {}
impl ::std::default::Default for D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA")
            .field("HWProtectionFunctionID", &self.HWProtectionFunctionID)
            .field("pInputData", &self.pInputData)
            .field("pOutputData", &self.pOutputData)
            .field("Status", &self.Status)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.HWProtectionFunctionID == other.HWProtectionFunctionID
            && self.pInputData == other.pInputData
            && self.pOutputData == other.pOutputData
            && self.Status == other.Status
    }
}
impl ::std::cmp::Eq for D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA {}
unsafe impl ::windows::runtime::Abi for D3D11_KEY_EXCHANGE_HW_PROTECTION_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA {
    pub PrivateDataSize: u32,
    pub HWProtectionDataSize: u32,
    pub pbInput: [u8; 4],
}
impl D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA {}
impl ::std::default::Default for D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA")
            .field("PrivateDataSize", &self.PrivateDataSize)
            .field("HWProtectionDataSize", &self.HWProtectionDataSize)
            .field("pbInput", &self.pbInput)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.PrivateDataSize == other.PrivateDataSize
            && self.HWProtectionDataSize == other.HWProtectionDataSize
            && self.pbInput == other.pbInput
    }
}
impl ::std::cmp::Eq for D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA {}
unsafe impl ::windows::runtime::Abi for D3D11_KEY_EXCHANGE_HW_PROTECTION_INPUT_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA {
    pub PrivateDataSize: u32,
    pub MaxHWProtectionDataSize: u32,
    pub HWProtectionDataSize: u32,
    pub TransportTime: u64,
    pub ExecutionTime: u64,
    pub pbOutput: [u8; 4],
}
impl D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA {}
impl ::std::default::Default for D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA")
            .field("PrivateDataSize", &self.PrivateDataSize)
            .field("MaxHWProtectionDataSize", &self.MaxHWProtectionDataSize)
            .field("HWProtectionDataSize", &self.HWProtectionDataSize)
            .field("TransportTime", &self.TransportTime)
            .field("ExecutionTime", &self.ExecutionTime)
            .field("pbOutput", &self.pbOutput)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.PrivateDataSize == other.PrivateDataSize
            && self.MaxHWProtectionDataSize == other.MaxHWProtectionDataSize
            && self.HWProtectionDataSize == other.HWProtectionDataSize
            && self.TransportTime == other.TransportTime
            && self.ExecutionTime == other.ExecutionTime
            && self.pbOutput == other.pbOutput
    }
}
impl ::std::cmp::Eq for D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA {}
unsafe impl ::windows::runtime::Abi for D3D11_KEY_EXCHANGE_HW_PROTECTION_OUTPUT_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_KEY_EXCHANGE_RSAES_OAEP: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3247741077,
        55082,
        18973,
        [142, 93, 237, 133, 125, 23, 21, 32],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_LIBRARY_DESC {
    pub Creator: super::super::Foundation::PSTR,
    pub Flags: u32,
    pub FunctionCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_LIBRARY_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_LIBRARY_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_LIBRARY_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_LIBRARY_DESC")
            .field("Creator", &self.Creator)
            .field("Flags", &self.Flags)
            .field("FunctionCount", &self.FunctionCount)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_LIBRARY_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Creator == other.Creator
            && self.Flags == other.Flags
            && self.FunctionCount == other.FunctionCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_LIBRARY_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_LIBRARY_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_LINEAR_GAMMA: f32 = 1f32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_LOGIC_OP(pub i32);
pub const D3D11_LOGIC_OP_CLEAR: D3D11_LOGIC_OP = D3D11_LOGIC_OP(0i32);
pub const D3D11_LOGIC_OP_SET: D3D11_LOGIC_OP = D3D11_LOGIC_OP(1i32);
pub const D3D11_LOGIC_OP_COPY: D3D11_LOGIC_OP = D3D11_LOGIC_OP(2i32);
pub const D3D11_LOGIC_OP_COPY_INVERTED: D3D11_LOGIC_OP = D3D11_LOGIC_OP(3i32);
pub const D3D11_LOGIC_OP_NOOP: D3D11_LOGIC_OP = D3D11_LOGIC_OP(4i32);
pub const D3D11_LOGIC_OP_INVERT: D3D11_LOGIC_OP = D3D11_LOGIC_OP(5i32);
pub const D3D11_LOGIC_OP_AND: D3D11_LOGIC_OP = D3D11_LOGIC_OP(6i32);
pub const D3D11_LOGIC_OP_NAND: D3D11_LOGIC_OP = D3D11_LOGIC_OP(7i32);
pub const D3D11_LOGIC_OP_OR: D3D11_LOGIC_OP = D3D11_LOGIC_OP(8i32);
pub const D3D11_LOGIC_OP_NOR: D3D11_LOGIC_OP = D3D11_LOGIC_OP(9i32);
pub const D3D11_LOGIC_OP_XOR: D3D11_LOGIC_OP = D3D11_LOGIC_OP(10i32);
pub const D3D11_LOGIC_OP_EQUIV: D3D11_LOGIC_OP = D3D11_LOGIC_OP(11i32);
pub const D3D11_LOGIC_OP_AND_REVERSE: D3D11_LOGIC_OP = D3D11_LOGIC_OP(12i32);
pub const D3D11_LOGIC_OP_AND_INVERTED: D3D11_LOGIC_OP = D3D11_LOGIC_OP(13i32);
pub const D3D11_LOGIC_OP_OR_REVERSE: D3D11_LOGIC_OP = D3D11_LOGIC_OP(14i32);
pub const D3D11_LOGIC_OP_OR_INVERTED: D3D11_LOGIC_OP = D3D11_LOGIC_OP(15i32);
impl ::std::convert::From<i32> for D3D11_LOGIC_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_LOGIC_OP {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_MAG_FILTER_SHIFT: u32 = 2u32;
pub const D3D11_MAJOR_VERSION: u32 = 11u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_MAP(pub i32);
pub const D3D11_MAP_READ: D3D11_MAP = D3D11_MAP(1i32);
pub const D3D11_MAP_WRITE: D3D11_MAP = D3D11_MAP(2i32);
pub const D3D11_MAP_READ_WRITE: D3D11_MAP = D3D11_MAP(3i32);
pub const D3D11_MAP_WRITE_DISCARD: D3D11_MAP = D3D11_MAP(4i32);
pub const D3D11_MAP_WRITE_NO_OVERWRITE: D3D11_MAP = D3D11_MAP(5i32);
impl ::std::convert::From<i32> for D3D11_MAP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_MAP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_MAPPED_SUBRESOURCE {
    pub pData: *mut ::std::ffi::c_void,
    pub RowPitch: u32,
    pub DepthPitch: u32,
}
impl D3D11_MAPPED_SUBRESOURCE {}
impl ::std::default::Default for D3D11_MAPPED_SUBRESOURCE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_MAPPED_SUBRESOURCE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_MAPPED_SUBRESOURCE")
            .field("pData", &self.pData)
            .field("RowPitch", &self.RowPitch)
            .field("DepthPitch", &self.DepthPitch)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_MAPPED_SUBRESOURCE {
    fn eq(&self, other: &Self) -> bool {
        self.pData == other.pData
            && self.RowPitch == other.RowPitch
            && self.DepthPitch == other.DepthPitch
    }
}
impl ::std::cmp::Eq for D3D11_MAPPED_SUBRESOURCE {}
unsafe impl ::windows::runtime::Abi for D3D11_MAPPED_SUBRESOURCE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_MAP_FLAG(pub i32);
pub const D3D11_MAP_FLAG_DO_NOT_WAIT: D3D11_MAP_FLAG = D3D11_MAP_FLAG(1048576i32);
impl ::std::convert::From<i32> for D3D11_MAP_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_MAP_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_MAX_BORDER_COLOR_COMPONENT: f32 = 1f32;
pub const D3D11_MAX_DEPTH: f32 = 1f32;
pub const D3D11_MAX_MAXANISOTROPY: u32 = 16u32;
pub const D3D11_MAX_MULTISAMPLE_SAMPLE_COUNT: u32 = 32u32;
pub const D3D11_MAX_POSITION_VALUE: f32 = 34028236000000000000000000000000000f32;
pub const D3D11_MAX_TEXTURE_DIMENSION_2_TO_EXP: u32 = 17u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_MESSAGE {
    pub Category: D3D11_MESSAGE_CATEGORY,
    pub Severity: D3D11_MESSAGE_SEVERITY,
    pub ID: D3D11_MESSAGE_ID,
    pub pDescription: *mut u8,
    pub DescriptionByteLength: usize,
}
impl D3D11_MESSAGE {}
impl ::std::default::Default for D3D11_MESSAGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_MESSAGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_MESSAGE")
            .field("Category", &self.Category)
            .field("Severity", &self.Severity)
            .field("ID", &self.ID)
            .field("pDescription", &self.pDescription)
            .field("DescriptionByteLength", &self.DescriptionByteLength)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_MESSAGE {
    fn eq(&self, other: &Self) -> bool {
        self.Category == other.Category
            && self.Severity == other.Severity
            && self.ID == other.ID
            && self.pDescription == other.pDescription
            && self.DescriptionByteLength == other.DescriptionByteLength
    }
}
impl ::std::cmp::Eq for D3D11_MESSAGE {}
unsafe impl ::windows::runtime::Abi for D3D11_MESSAGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_MESSAGE_CATEGORY(pub i32);
pub const D3D11_MESSAGE_CATEGORY_APPLICATION_DEFINED: D3D11_MESSAGE_CATEGORY =
    D3D11_MESSAGE_CATEGORY(0i32);
pub const D3D11_MESSAGE_CATEGORY_MISCELLANEOUS: D3D11_MESSAGE_CATEGORY =
    D3D11_MESSAGE_CATEGORY(1i32);
pub const D3D11_MESSAGE_CATEGORY_INITIALIZATION: D3D11_MESSAGE_CATEGORY =
    D3D11_MESSAGE_CATEGORY(2i32);
pub const D3D11_MESSAGE_CATEGORY_CLEANUP: D3D11_MESSAGE_CATEGORY = D3D11_MESSAGE_CATEGORY(3i32);
pub const D3D11_MESSAGE_CATEGORY_COMPILATION: D3D11_MESSAGE_CATEGORY = D3D11_MESSAGE_CATEGORY(4i32);
pub const D3D11_MESSAGE_CATEGORY_STATE_CREATION: D3D11_MESSAGE_CATEGORY =
    D3D11_MESSAGE_CATEGORY(5i32);
pub const D3D11_MESSAGE_CATEGORY_STATE_SETTING: D3D11_MESSAGE_CATEGORY =
    D3D11_MESSAGE_CATEGORY(6i32);
pub const D3D11_MESSAGE_CATEGORY_STATE_GETTING: D3D11_MESSAGE_CATEGORY =
    D3D11_MESSAGE_CATEGORY(7i32);
pub const D3D11_MESSAGE_CATEGORY_RESOURCE_MANIPULATION: D3D11_MESSAGE_CATEGORY =
    D3D11_MESSAGE_CATEGORY(8i32);
pub const D3D11_MESSAGE_CATEGORY_EXECUTION: D3D11_MESSAGE_CATEGORY = D3D11_MESSAGE_CATEGORY(9i32);
pub const D3D11_MESSAGE_CATEGORY_SHADER: D3D11_MESSAGE_CATEGORY = D3D11_MESSAGE_CATEGORY(10i32);
impl ::std::convert::From<i32> for D3D11_MESSAGE_CATEGORY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_MESSAGE_CATEGORY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_MESSAGE_ID(pub i32);
pub const D3D11_MESSAGE_ID_UNKNOWN: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(0i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(4i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(5i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(6i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(7i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(8i32);
pub const D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(9i32);
pub const D3D11_MESSAGE_ID_DEVICE_SOSETTARGETS_HAZARD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(10i32);
pub const D3D11_MESSAGE_ID_STRING_FROM_APPLICATION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(11i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_THIS: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(12i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER1: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(13i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER2: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(14i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER3: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(15i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER4: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(16i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER5: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(17i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER6: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(18i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(19i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER8: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(20i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER9: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(21i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER10: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(22i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER11: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(23i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER12: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(24i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER13: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(25i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER14: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(26i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_PARAMETER15: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(27i32);
pub const D3D11_MESSAGE_ID_CORRUPTED_MULTITHREADING: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(28i32);
pub const D3D11_MESSAGE_ID_MESSAGE_REPORTING_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(29i32);
pub const D3D11_MESSAGE_ID_IASETINPUTLAYOUT_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(30i32);
pub const D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(31i32);
pub const D3D11_MESSAGE_ID_IASETINDEXBUFFER_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(32i32);
pub const D3D11_MESSAGE_ID_VSSETSHADER_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(33i32);
pub const D3D11_MESSAGE_ID_VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(34i32);
pub const D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(35i32);
pub const D3D11_MESSAGE_ID_VSSETSAMPLERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(36i32);
pub const D3D11_MESSAGE_ID_GSSETSHADER_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(37i32);
pub const D3D11_MESSAGE_ID_GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(38i32);
pub const D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(39i32);
pub const D3D11_MESSAGE_ID_GSSETSAMPLERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(40i32);
pub const D3D11_MESSAGE_ID_SOSETTARGETS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(41i32);
pub const D3D11_MESSAGE_ID_PSSETSHADER_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(42i32);
pub const D3D11_MESSAGE_ID_PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(43i32);
pub const D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(44i32);
pub const D3D11_MESSAGE_ID_PSSETSAMPLERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(45i32);
pub const D3D11_MESSAGE_ID_RSSETSTATE_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(46i32);
pub const D3D11_MESSAGE_ID_OMSETBLENDSTATE_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(47i32);
pub const D3D11_MESSAGE_ID_OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(48i32);
pub const D3D11_MESSAGE_ID_OMSETRENDERTARGETS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(49i32);
pub const D3D11_MESSAGE_ID_SETPREDICATION_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(50i32);
pub const D3D11_MESSAGE_ID_GETPRIVATEDATA_MOREDATA: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(51i32);
pub const D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDFREEDATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(52i32);
pub const D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDIUNKNOWN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(53i32);
pub const D3D11_MESSAGE_ID_SETPRIVATEDATA_INVALIDFLAGS: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(54i32);
pub const D3D11_MESSAGE_ID_SETPRIVATEDATA_CHANGINGPARAMS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(55i32);
pub const D3D11_MESSAGE_ID_SETPRIVATEDATA_OUTOFMEMORY: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(56i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(57i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDSAMPLES: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(58i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(59i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(60i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(61i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_UNRECOGNIZEDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(62i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(63i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(64i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDINITIALDATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(65i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(66i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDMIPLEVELS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(67i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(68i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(69i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(70i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(71i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(72i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_LARGEALLOCATION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(73i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(74i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_UNSUPPORTEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(75i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDSAMPLES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(76i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(77i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(78i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(79i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(80i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(81i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(82i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDINITIALDATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(83i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(84i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDMIPLEVELS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(85i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(86i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(87i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(88i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(89i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_LARGEALLOCATION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(90i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(91i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_UNSUPPORTEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(92i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDSAMPLES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(93i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(94i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(95i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(96i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(97i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(98i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(99i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDINITIALDATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(100i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(101i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDMIPLEVELS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(102i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(103i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(104i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(105i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(106i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_LARGEALLOCATION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(107i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(108i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_UNSUPPORTEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(109i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDSAMPLES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(110i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(111i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(112i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(113i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(114i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDCPUACCESSFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(115i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDBINDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(116i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDINITIALDATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(117i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(118i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDMIPLEVELS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(119i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(120i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(121i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(122i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(123i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE3D_LARGEALLOCATION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(124i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(125i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDESC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(126i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(127i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(128i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(129i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(130i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(131i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(132i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(133i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(134i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDESC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(135i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(136i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(137i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(138i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(139i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(140i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(141i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(142i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDESC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(143i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(144i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(145i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(146i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(147i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(148i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(149i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(150i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TOOMANYELEMENTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(151i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(152i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(153i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(154i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(155i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(156i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(157i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(158i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_INVALIDALIGNMENT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(159i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_DUPLICATESEMANTIC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(160i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(161i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_NULLSEMANTIC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(162i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_MISSINGELEMENT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(163i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(164i32);
pub const D3D11_MESSAGE_ID_CREATEVERTEXSHADER_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(165i32);
pub const D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERBYTECODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(166i32);
pub const D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDSHADERTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(167i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(168i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(169i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDSHADERTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(170i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(171i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(172i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(173i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(174i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(175i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(176i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(177i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(178i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(179i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(180i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(181i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT : D3D11_MESSAGE_ID = D3D11_MESSAGE_ID ( 182i32 ) ;
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(183i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(184i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(185i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(186i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(187i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(188i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(189i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(190i32);
pub const D3D11_MESSAGE_ID_CREATEPIXELSHADER_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(191i32);
pub const D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERBYTECODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(192i32);
pub const D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDSHADERTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(193i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFILLMODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(194i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDCULLMODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(195i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(196i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(197i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(198i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_NULLDESC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(199i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(200i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(201i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(202i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(203i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(204i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(205i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(206i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(207i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(208i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(209i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(210i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_NULLDESC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(211i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLEND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(212i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLEND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(213i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(214i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDSRCBLENDALPHA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(215i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDDESTBLENDALPHA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(216i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDBLENDOPALPHA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(217i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(218i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(219i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(220i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDFILTER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(221i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSU: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(222i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSV: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(223i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDADDRESSW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(224i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMIPLODBIAS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(225i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXANISOTROPY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(226i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(227i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMINLOD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(228i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_INVALIDMAXLOD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(229i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(230i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(231i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDQUERY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(232i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(233i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(234i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_NULLDESC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(235i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(236i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(237i32);
pub const D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(238i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(239i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(240i32);
pub const D3D11_MESSAGE_ID_IASETINDEXBUFFER_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(241i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_FORMAT_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(242i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(243i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(244i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(245i32);
pub const D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(246i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(247i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(248i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(249i32);
pub const D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(250i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(251i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(252i32);
pub const D3D11_MESSAGE_ID_SOSETTARGETS_INVALIDBUFFER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(253i32);
pub const D3D11_MESSAGE_ID_DEVICE_SOSETTARGETS_OFFSET_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(254i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(255i32);
pub const D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(256i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(257i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(258i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(259i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(260i32);
pub const D3D11_MESSAGE_ID_CLEARRENDERTARGETVIEW_DENORMFLUSH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(261i32);
pub const D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DENORMFLUSH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(262i32);
pub const D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(263i32);
pub const D3D11_MESSAGE_ID_DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(264i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(265i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(266i32);
pub const D3D11_MESSAGE_ID_DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(267i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(268i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(269i32);
pub const D3D11_MESSAGE_ID_DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(270i32);
pub const D3D11_MESSAGE_ID_DEVICE_SOGETTARGETS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(271i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(272i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(273i32);
pub const D3D11_MESSAGE_ID_DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(274i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(275i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(276i32);
pub const D3D11_MESSAGE_ID_DEVICE_GENERATEMIPS_RESOURCE_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(277i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(278i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(279i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCEBOX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(280i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(281i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(282i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_INVALIDSOURCESTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(283i32);
pub const D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(284i32);
pub const D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDDESTINATIONSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(285i32);
pub const D3D11_MESSAGE_ID_COPYRESOURCE_INVALIDSOURCESTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(286i32);
pub const D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(287i32);
pub const D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONBOX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(288i32);
pub const D3D11_MESSAGE_ID_UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(289i32);
pub const D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(290i32);
pub const D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(291i32);
pub const D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(292i32);
pub const D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(293i32);
pub const D3D11_MESSAGE_ID_DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(294i32);
pub const D3D11_MESSAGE_ID_BUFFER_MAP_INVALIDMAPTYPE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(295i32);
pub const D3D11_MESSAGE_ID_BUFFER_MAP_INVALIDFLAGS: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(296i32);
pub const D3D11_MESSAGE_ID_BUFFER_MAP_ALREADYMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(297i32);
pub const D3D11_MESSAGE_ID_BUFFER_MAP_DEVICEREMOVED_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(298i32);
pub const D3D11_MESSAGE_ID_BUFFER_UNMAP_NOTMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(299i32);
pub const D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDMAPTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(300i32);
pub const D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(301i32);
pub const D3D11_MESSAGE_ID_TEXTURE1D_MAP_INVALIDFLAGS: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(302i32);
pub const D3D11_MESSAGE_ID_TEXTURE1D_MAP_ALREADYMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(303i32);
pub const D3D11_MESSAGE_ID_TEXTURE1D_MAP_DEVICEREMOVED_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(304i32);
pub const D3D11_MESSAGE_ID_TEXTURE1D_UNMAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(305i32);
pub const D3D11_MESSAGE_ID_TEXTURE1D_UNMAP_NOTMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(306i32);
pub const D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDMAPTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(307i32);
pub const D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(308i32);
pub const D3D11_MESSAGE_ID_TEXTURE2D_MAP_INVALIDFLAGS: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(309i32);
pub const D3D11_MESSAGE_ID_TEXTURE2D_MAP_ALREADYMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(310i32);
pub const D3D11_MESSAGE_ID_TEXTURE2D_MAP_DEVICEREMOVED_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(311i32);
pub const D3D11_MESSAGE_ID_TEXTURE2D_UNMAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(312i32);
pub const D3D11_MESSAGE_ID_TEXTURE2D_UNMAP_NOTMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(313i32);
pub const D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDMAPTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(314i32);
pub const D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(315i32);
pub const D3D11_MESSAGE_ID_TEXTURE3D_MAP_INVALIDFLAGS: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(316i32);
pub const D3D11_MESSAGE_ID_TEXTURE3D_MAP_ALREADYMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(317i32);
pub const D3D11_MESSAGE_ID_TEXTURE3D_MAP_DEVICEREMOVED_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(318i32);
pub const D3D11_MESSAGE_ID_TEXTURE3D_UNMAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(319i32);
pub const D3D11_MESSAGE_ID_TEXTURE3D_UNMAP_NOTMAPPED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(320i32);
pub const D3D11_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_DEPRECATED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(321i32);
pub const D3D11_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(322i32);
pub const D3D11_MESSAGE_ID_SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(323i32);
pub const D3D11_MESSAGE_ID_SETEXCEPTIONMODE_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(324i32);
pub const D3D11_MESSAGE_ID_SETEXCEPTIONMODE_DEVICEREMOVED_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(325i32);
pub const D3D11_MESSAGE_ID_REF_SIMULATING_INFINITELY_FAST_HARDWARE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(326i32);
pub const D3D11_MESSAGE_ID_REF_THREADING_MODE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(327i32);
pub const D3D11_MESSAGE_ID_REF_UMDRIVER_EXCEPTION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(328i32);
pub const D3D11_MESSAGE_ID_REF_KMDRIVER_EXCEPTION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(329i32);
pub const D3D11_MESSAGE_ID_REF_HARDWARE_EXCEPTION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(330i32);
pub const D3D11_MESSAGE_ID_REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(331i32);
pub const D3D11_MESSAGE_ID_REF_PROBLEM_PARSING_SHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(332i32);
pub const D3D11_MESSAGE_ID_REF_OUT_OF_MEMORY: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(333i32);
pub const D3D11_MESSAGE_ID_REF_INFO: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(334i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEXPOS_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(335i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(336i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(337i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(338i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(339i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(340i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_SHADER_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(341i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(342i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(343i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_COMPONENTTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(344i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_REGISTERMASK: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(345i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_SYSTEMVALUE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(346i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(347i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(348i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INPUTLAYOUT_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(349i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(350i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(351i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLER_NOT_SET: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(352i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(353i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VIEW_DIMENSION_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(354i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(355i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(356i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(357i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(358i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(359i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(360i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(361i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_POSITION_NOT_PRESENT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(362i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(363i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_BOUND_RESOURCE_MAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(364i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(365i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(366i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(367i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INDEX_OFFSET_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(368i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(369i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(370i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(371i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(372i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(373i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(374i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(375i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(376i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(377i32);
pub const D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_AT_FAULT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(378i32);
pub const D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(379i32);
pub const D3D11_MESSAGE_ID_DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(380i32);
pub const D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(381i32);
pub const D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(382i32);
pub const D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(383i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_VIEWPORT_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(384i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(385i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(386i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_DENORMFLUSH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(387i32);
pub const D3D11_MESSAGE_ID_OMSETRENDERTARGETS_INVALIDVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(388i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(389i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLER_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(390i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_TYPE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(391i32);
pub const D3D11_MESSAGE_ID_BLENDSTATE_GETDESC_LEGACY: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(392i32);
pub const D3D11_MESSAGE_ID_SHADERRESOURCEVIEW_GETDESC_LEGACY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(393i32);
pub const D3D11_MESSAGE_ID_CREATEQUERY_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(394i32);
pub const D3D11_MESSAGE_ID_CREATEPREDICATE_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(395i32);
pub const D3D11_MESSAGE_ID_CREATECOUNTER_OUTOFRANGE_COUNTER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(396i32);
pub const D3D11_MESSAGE_ID_CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(397i32);
pub const D3D11_MESSAGE_ID_CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(398i32);
pub const D3D11_MESSAGE_ID_CREATECOUNTER_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(399i32);
pub const D3D11_MESSAGE_ID_CREATECOUNTER_NONEXCLUSIVE_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(400i32);
pub const D3D11_MESSAGE_ID_CREATECOUNTER_NULLDESC: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(401i32);
pub const D3D11_MESSAGE_ID_CHECKCOUNTER_OUTOFRANGE_COUNTER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(402i32);
pub const D3D11_MESSAGE_ID_CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(403i32);
pub const D3D11_MESSAGE_ID_SETPREDICATION_INVALID_PREDICATE_STATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(404i32);
pub const D3D11_MESSAGE_ID_QUERY_BEGIN_UNSUPPORTED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(405i32);
pub const D3D11_MESSAGE_ID_PREDICATE_BEGIN_DURING_PREDICATION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(406i32);
pub const D3D11_MESSAGE_ID_QUERY_BEGIN_DUPLICATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(407i32);
pub const D3D11_MESSAGE_ID_QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(408i32);
pub const D3D11_MESSAGE_ID_PREDICATE_END_DURING_PREDICATION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(409i32);
pub const D3D11_MESSAGE_ID_QUERY_END_ABANDONING_PREVIOUS_RESULTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(410i32);
pub const D3D11_MESSAGE_ID_QUERY_END_WITHOUT_BEGIN: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(411i32);
pub const D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_DATASIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(412i32);
pub const D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_FLAGS: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(413i32);
pub const D3D11_MESSAGE_ID_QUERY_GETDATA_INVALID_CALL: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(414i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(415i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(416i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(417i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(418i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(419i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_EMPTY_LAYOUT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(420i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(421i32);
pub const D3D11_MESSAGE_ID_LIVE_OBJECT_SUMMARY: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(422i32);
pub const D3D11_MESSAGE_ID_LIVE_BUFFER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(423i32);
pub const D3D11_MESSAGE_ID_LIVE_TEXTURE1D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(424i32);
pub const D3D11_MESSAGE_ID_LIVE_TEXTURE2D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(425i32);
pub const D3D11_MESSAGE_ID_LIVE_TEXTURE3D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(426i32);
pub const D3D11_MESSAGE_ID_LIVE_SHADERRESOURCEVIEW: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(427i32);
pub const D3D11_MESSAGE_ID_LIVE_RENDERTARGETVIEW: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(428i32);
pub const D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILVIEW: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(429i32);
pub const D3D11_MESSAGE_ID_LIVE_VERTEXSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(430i32);
pub const D3D11_MESSAGE_ID_LIVE_GEOMETRYSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(431i32);
pub const D3D11_MESSAGE_ID_LIVE_PIXELSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(432i32);
pub const D3D11_MESSAGE_ID_LIVE_INPUTLAYOUT: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(433i32);
pub const D3D11_MESSAGE_ID_LIVE_SAMPLER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(434i32);
pub const D3D11_MESSAGE_ID_LIVE_BLENDSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(435i32);
pub const D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(436i32);
pub const D3D11_MESSAGE_ID_LIVE_RASTERIZERSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(437i32);
pub const D3D11_MESSAGE_ID_LIVE_QUERY: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(438i32);
pub const D3D11_MESSAGE_ID_LIVE_PREDICATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(439i32);
pub const D3D11_MESSAGE_ID_LIVE_COUNTER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(440i32);
pub const D3D11_MESSAGE_ID_LIVE_DEVICE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(441i32);
pub const D3D11_MESSAGE_ID_LIVE_SWAPCHAIN: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(442i32);
pub const D3D11_MESSAGE_ID_D3D10_MESSAGES_END: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(443i32);
pub const D3D11_MESSAGE_ID_D3D10L9_MESSAGES_START: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(1048576i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048577i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048578i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048579i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048580i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048581i32);
pub const D3D11_MESSAGE_ID_VSSETSAMPLERS_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048582i32);
pub const D3D11_MESSAGE_ID_VSSETSAMPLERS_TOO_MANY_SAMPLERS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048583i32);
pub const D3D11_MESSAGE_ID_PSSETSAMPLERS_TOO_MANY_SAMPLERS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048584i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NO_ARRAYS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048585i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NO_VB_AND_IB_BIND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048586i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NO_TEXTURE_1D: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048587i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_DIMENSION_OUT_OF_RANGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048588i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048589i32);
pub const D3D11_MESSAGE_ID_OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048590i32);
pub const D3D11_MESSAGE_ID_OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048591i32);
pub const D3D11_MESSAGE_ID_IASETVERTEXBUFFERS_BAD_BUFFER_INDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048592i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048593i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048594i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048595i32);
pub const D3D11_MESSAGE_ID_COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048596i32);
pub const D3D11_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_3D_READBACK: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048597i32);
pub const D3D11_MESSAGE_ID_COPYRESOURCE_NO_TEXTURE_ONLY_READBACK: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048598i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048599i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048600i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048601i32);
pub const D3D11_MESSAGE_ID_DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048602i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048603i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048604i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048605i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048606i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048607i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048608i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NO_DWORD_INDEX_BUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048609i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048610i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048611i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048612i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048613i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NO_STREAM_OUT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048614i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048615i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048616i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048617i32);
pub const D3D11_MESSAGE_ID_VSSHADERRESOURCES_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048618i32);
pub const D3D11_MESSAGE_ID_GEOMETRY_SHADER_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048619i32);
pub const D3D11_MESSAGE_ID_STREAM_OUT_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048620i32);
pub const D3D11_MESSAGE_ID_TEXT_FILTER_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048621i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048622i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_NO_MRT_BLEND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048623i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048624i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_NO_MIRRORONCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048625i32);
pub const D3D11_MESSAGE_ID_DRAWINSTANCED_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048626i32);
pub const D3D11_MESSAGE_ID_DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048627i32);
pub const D3D11_MESSAGE_ID_DRAWINDEXED_POINTLIST_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048628i32);
pub const D3D11_MESSAGE_ID_SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048629i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(1048630i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(1048631i32);
pub const D3D11_MESSAGE_ID_DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048632i32);
pub const D3D11_MESSAGE_ID_SLOT_ZERO_MUST_BE_D3D10_INPUT_PER_VERTEX_DATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048633i32);
pub const D3D11_MESSAGE_ID_CREATERESOURCE_NON_POW_2_MIPMAP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048634i32);
pub const D3D11_MESSAGE_ID_CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048635i32);
pub const D3D11_MESSAGE_ID_OMSETRENDERTARGETS_NO_SRGB_MRT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048636i32);
pub const D3D11_MESSAGE_ID_COPYRESOURCE_NO_3D_MISMATCHED_UPDATES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(1048637i32);
pub const D3D11_MESSAGE_ID_D3D10L9_MESSAGES_END: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(1048638i32);
pub const D3D11_MESSAGE_ID_D3D11_MESSAGES_START: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097152i32);
pub const D3D11_MESSAGE_ID_CREATEDEPTHSTENCILVIEW_INVALIDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097153i32);
pub const D3D11_MESSAGE_ID_CREATEVERTEXSHADER_INVALIDCLASSLINKAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097154i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097155i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTREAMS:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097156i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097157i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTREAMS:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097158i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCLASSLINKAGE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097159i32);
pub const D3D11_MESSAGE_ID_CREATEPIXELSHADER_INVALIDCLASSLINKAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097160i32);
pub const D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALID_COMMANDLISTFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097161i32);
pub const D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_SINGLETHREADED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097162i32);
pub const D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097163i32);
pub const D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_INVALID_CALL_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097164i32);
pub const D3D11_MESSAGE_ID_CREATEDEFERREDCONTEXT_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097165i32);
pub const D3D11_MESSAGE_ID_FINISHDISPLAYLIST_ONIMMEDIATECONTEXT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097166i32);
pub const D3D11_MESSAGE_ID_FINISHDISPLAYLIST_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097167i32);
pub const D3D11_MESSAGE_ID_FINISHDISPLAYLIST_INVALID_CALL_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097168i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097169i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097170i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097171i32);
pub const D3D11_MESSAGE_ID_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097172i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSSETSHADERRESOURCES_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097173i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSSETCONSTANTBUFFERS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097174i32);
pub const D3D11_MESSAGE_ID_HSSETSHADERRESOURCES_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097175i32);
pub const D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097176i32);
pub const D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDCALL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097177i32);
pub const D3D11_MESSAGE_ID_CREATEHULLSHADER_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097178i32);
pub const D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERBYTECODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097179i32);
pub const D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDSHADERTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097180i32);
pub const D3D11_MESSAGE_ID_CREATEHULLSHADER_INVALIDCLASSLINKAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097181i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSSETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097182i32);
pub const D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097183i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSSETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097184i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSSETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097185i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSGETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097186i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSGETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097187i32);
pub const D3D11_MESSAGE_ID_DEVICE_HSGETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097188i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSSETSHADERRESOURCES_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097189i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSSETCONSTANTBUFFERS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097190i32);
pub const D3D11_MESSAGE_ID_DSSETSHADERRESOURCES_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097191i32);
pub const D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097192i32);
pub const D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCALL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097193i32);
pub const D3D11_MESSAGE_ID_CREATEDOMAINSHADER_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097194i32);
pub const D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERBYTECODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097195i32);
pub const D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDSHADERTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097196i32);
pub const D3D11_MESSAGE_ID_CREATEDOMAINSHADER_INVALIDCLASSLINKAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097197i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSSETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097198i32);
pub const D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097199i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSSETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097200i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSSETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097201i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSGETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097202i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSGETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097203i32);
pub const D3D11_MESSAGE_ID_DEVICE_DSGETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097204i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_HS_XOR_DS_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097205i32);
pub const D3D11_MESSAGE_ID_DEFERRED_CONTEXT_REMOVAL_PROCESS_AT_FAULT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097206i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_INVALID_ARG_BUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097207i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097208i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAWINDIRECT_OFFSET_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097209i32);
pub const D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDMAPTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097210i32);
pub const D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097211i32);
pub const D3D11_MESSAGE_ID_RESOURCE_MAP_INVALIDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097212i32);
pub const D3D11_MESSAGE_ID_RESOURCE_MAP_ALREADYMAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097213i32);
pub const D3D11_MESSAGE_ID_RESOURCE_MAP_DEVICEREMOVED_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097214i32);
pub const D3D11_MESSAGE_ID_RESOURCE_MAP_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097215i32);
pub const D3D11_MESSAGE_ID_RESOURCE_MAP_WITHOUT_INITIAL_DISCARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097216i32);
pub const D3D11_MESSAGE_ID_RESOURCE_UNMAP_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097217i32);
pub const D3D11_MESSAGE_ID_RESOURCE_UNMAP_NOTMAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097218i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RASTERIZING_CONTROL_POINTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097219i32);
pub const D3D11_MESSAGE_ID_DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097220i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_SIGNATURE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097221i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097222i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_CONTROL_POINT_COUNT_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097223i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_HS_DS_TESSELLATOR_DOMAIN_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097224i32);
pub const D3D11_MESSAGE_ID_CREATE_CONTEXT: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097225i32);
pub const D3D11_MESSAGE_ID_LIVE_CONTEXT: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097226i32);
pub const D3D11_MESSAGE_ID_DESTROY_CONTEXT: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097227i32);
pub const D3D11_MESSAGE_ID_CREATE_BUFFER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097228i32);
pub const D3D11_MESSAGE_ID_LIVE_BUFFER_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097229i32);
pub const D3D11_MESSAGE_ID_DESTROY_BUFFER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097230i32);
pub const D3D11_MESSAGE_ID_CREATE_TEXTURE1D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097231i32);
pub const D3D11_MESSAGE_ID_LIVE_TEXTURE1D_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097232i32);
pub const D3D11_MESSAGE_ID_DESTROY_TEXTURE1D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097233i32);
pub const D3D11_MESSAGE_ID_CREATE_TEXTURE2D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097234i32);
pub const D3D11_MESSAGE_ID_LIVE_TEXTURE2D_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097235i32);
pub const D3D11_MESSAGE_ID_DESTROY_TEXTURE2D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097236i32);
pub const D3D11_MESSAGE_ID_CREATE_TEXTURE3D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097237i32);
pub const D3D11_MESSAGE_ID_LIVE_TEXTURE3D_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097238i32);
pub const D3D11_MESSAGE_ID_DESTROY_TEXTURE3D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097239i32);
pub const D3D11_MESSAGE_ID_CREATE_SHADERRESOURCEVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097240i32);
pub const D3D11_MESSAGE_ID_LIVE_SHADERRESOURCEVIEW_WIN7: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097241i32);
pub const D3D11_MESSAGE_ID_DESTROY_SHADERRESOURCEVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097242i32);
pub const D3D11_MESSAGE_ID_CREATE_RENDERTARGETVIEW: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097243i32);
pub const D3D11_MESSAGE_ID_LIVE_RENDERTARGETVIEW_WIN7: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097244i32);
pub const D3D11_MESSAGE_ID_DESTROY_RENDERTARGETVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097245i32);
pub const D3D11_MESSAGE_ID_CREATE_DEPTHSTENCILVIEW: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097246i32);
pub const D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILVIEW_WIN7: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097247i32);
pub const D3D11_MESSAGE_ID_DESTROY_DEPTHSTENCILVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097248i32);
pub const D3D11_MESSAGE_ID_CREATE_VERTEXSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097249i32);
pub const D3D11_MESSAGE_ID_LIVE_VERTEXSHADER_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097250i32);
pub const D3D11_MESSAGE_ID_DESTROY_VERTEXSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097251i32);
pub const D3D11_MESSAGE_ID_CREATE_HULLSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097252i32);
pub const D3D11_MESSAGE_ID_LIVE_HULLSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097253i32);
pub const D3D11_MESSAGE_ID_DESTROY_HULLSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097254i32);
pub const D3D11_MESSAGE_ID_CREATE_DOMAINSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097255i32);
pub const D3D11_MESSAGE_ID_LIVE_DOMAINSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097256i32);
pub const D3D11_MESSAGE_ID_DESTROY_DOMAINSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097257i32);
pub const D3D11_MESSAGE_ID_CREATE_GEOMETRYSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097258i32);
pub const D3D11_MESSAGE_ID_LIVE_GEOMETRYSHADER_WIN7: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097259i32);
pub const D3D11_MESSAGE_ID_DESTROY_GEOMETRYSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097260i32);
pub const D3D11_MESSAGE_ID_CREATE_PIXELSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097261i32);
pub const D3D11_MESSAGE_ID_LIVE_PIXELSHADER_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097262i32);
pub const D3D11_MESSAGE_ID_DESTROY_PIXELSHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097263i32);
pub const D3D11_MESSAGE_ID_CREATE_INPUTLAYOUT: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097264i32);
pub const D3D11_MESSAGE_ID_LIVE_INPUTLAYOUT_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097265i32);
pub const D3D11_MESSAGE_ID_DESTROY_INPUTLAYOUT: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097266i32);
pub const D3D11_MESSAGE_ID_CREATE_SAMPLER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097267i32);
pub const D3D11_MESSAGE_ID_LIVE_SAMPLER_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097268i32);
pub const D3D11_MESSAGE_ID_DESTROY_SAMPLER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097269i32);
pub const D3D11_MESSAGE_ID_CREATE_BLENDSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097270i32);
pub const D3D11_MESSAGE_ID_LIVE_BLENDSTATE_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097271i32);
pub const D3D11_MESSAGE_ID_DESTROY_BLENDSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097272i32);
pub const D3D11_MESSAGE_ID_CREATE_DEPTHSTENCILSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097273i32);
pub const D3D11_MESSAGE_ID_LIVE_DEPTHSTENCILSTATE_WIN7: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097274i32);
pub const D3D11_MESSAGE_ID_DESTROY_DEPTHSTENCILSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097275i32);
pub const D3D11_MESSAGE_ID_CREATE_RASTERIZERSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097276i32);
pub const D3D11_MESSAGE_ID_LIVE_RASTERIZERSTATE_WIN7: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097277i32);
pub const D3D11_MESSAGE_ID_DESTROY_RASTERIZERSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097278i32);
pub const D3D11_MESSAGE_ID_CREATE_QUERY: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097279i32);
pub const D3D11_MESSAGE_ID_LIVE_QUERY_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097280i32);
pub const D3D11_MESSAGE_ID_DESTROY_QUERY: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097281i32);
pub const D3D11_MESSAGE_ID_CREATE_PREDICATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097282i32);
pub const D3D11_MESSAGE_ID_LIVE_PREDICATE_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097283i32);
pub const D3D11_MESSAGE_ID_DESTROY_PREDICATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097284i32);
pub const D3D11_MESSAGE_ID_CREATE_COUNTER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097285i32);
pub const D3D11_MESSAGE_ID_DESTROY_COUNTER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097286i32);
pub const D3D11_MESSAGE_ID_CREATE_COMMANDLIST: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097287i32);
pub const D3D11_MESSAGE_ID_LIVE_COMMANDLIST: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097288i32);
pub const D3D11_MESSAGE_ID_DESTROY_COMMANDLIST: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097289i32);
pub const D3D11_MESSAGE_ID_CREATE_CLASSINSTANCE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097290i32);
pub const D3D11_MESSAGE_ID_LIVE_CLASSINSTANCE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097291i32);
pub const D3D11_MESSAGE_ID_DESTROY_CLASSINSTANCE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097292i32);
pub const D3D11_MESSAGE_ID_CREATE_CLASSLINKAGE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097293i32);
pub const D3D11_MESSAGE_ID_LIVE_CLASSLINKAGE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097294i32);
pub const D3D11_MESSAGE_ID_DESTROY_CLASSLINKAGE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097295i32);
pub const D3D11_MESSAGE_ID_LIVE_DEVICE_WIN7: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097296i32);
pub const D3D11_MESSAGE_ID_LIVE_OBJECT_SUMMARY_WIN7: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097297i32);
pub const D3D11_MESSAGE_ID_CREATE_COMPUTESHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097298i32);
pub const D3D11_MESSAGE_ID_LIVE_COMPUTESHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097299i32);
pub const D3D11_MESSAGE_ID_DESTROY_COMPUTESHADER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097300i32);
pub const D3D11_MESSAGE_ID_CREATE_UNORDEREDACCESSVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097301i32);
pub const D3D11_MESSAGE_ID_LIVE_UNORDEREDACCESSVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097302i32);
pub const D3D11_MESSAGE_ID_DESTROY_UNORDEREDACCESSVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097303i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_INTERFACES_FEATURELEVEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097304i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_INTERFACE_COUNT_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097305i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097306i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_INDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097307i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_TYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097308i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_INVALID_INSTANCE_DATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097309i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_UNBOUND_INSTANCE_DATA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097310i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETSHADER_INSTANCE_DATA_BINDINGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097311i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATESHADER_CLASSLINKAGE_FULL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097312i32);
pub const D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_UNRECOGNIZED_FEATURE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097313i32);
pub const D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097314i32);
pub const D3D11_MESSAGE_ID_DEVICE_CHECKFEATURESUPPORT_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097315i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETSHADERRESOURCES_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097316i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETCONSTANTBUFFERS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097317i32);
pub const D3D11_MESSAGE_ID_CSSETSHADERRESOURCES_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097318i32);
pub const D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097319i32);
pub const D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCALL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097320i32);
pub const D3D11_MESSAGE_ID_CREATECOMPUTESHADER_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097321i32);
pub const D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERBYTECODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097322i32);
pub const D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDSHADERTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097323i32);
pub const D3D11_MESSAGE_ID_CREATECOMPUTESHADER_INVALIDCLASSLINKAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097324i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097325i32);
pub const D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097326i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097327i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097328i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSGETSHADERRESOURCES_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097329i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSGETCONSTANTBUFFERS_BUFFERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097330i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSGETSAMPLERS_SAMPLERS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097331i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097332i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097333i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097334i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097335i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED : D3D11_MESSAGE_ID = D3D11_MESSAGE_ID ( 2097336i32 ) ;
pub const D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097337i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097338i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDSTRUCTURESTRIDE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097339i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097340i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097341i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDESC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097342i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097343i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097344i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097345i32);
pub const D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_HAZARD:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097346i32);
pub const D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_OVERLAPPING_OLD_SLOTS : D3D11_MESSAGE_ID = D3D11_MESSAGE_ID ( 2097347i32 ) ;
pub const D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NO_OP:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097348i32);
pub const D3D11_MESSAGE_ID_CSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097349i32);
pub const D3D11_MESSAGE_ID_PSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097350i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097351i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097352i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097353i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097354i32);
pub const D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEW_DENORMFLUSH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097355i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSS_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097356i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSGETUNORDEREDACCESSS_VIEWS_EMPTY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097357i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097358i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESESOURCEVIEW_TOOMANYOBJECTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097359i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_INVALID_ARG_BUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097360i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_UNALIGNED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097361i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_OFFSET_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097362i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDCONTEXT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097363i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097364i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETRESOURCEMINLOD_INVALIDMINLOD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097365i32);
pub const D3D11_MESSAGE_ID_DEVICE_GETRESOURCEMINLOD_INVALIDCONTEXT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097366i32);
pub const D3D11_MESSAGE_ID_DEVICE_GETRESOURCEMINLOD_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097367i32);
pub const D3D11_MESSAGE_ID_OMSETDEPTHSTENCIL_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097368i32);
pub const D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_DEPTH_READONLY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097369i32);
pub const D3D11_MESSAGE_ID_CLEARDEPTHSTENCILVIEW_STENCIL_READONLY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097370i32);
pub const D3D11_MESSAGE_ID_CHECKFEATURESUPPORT_FORMAT_DEPRECATED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097371i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RETURN_TYPE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097372i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097373i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_UNORDEREDACCESSVIEW_RENDERTARGETVIEW_OVERLAP:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097374i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_DIMENSION_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097375i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_APPEND_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097376i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMICS_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097377i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_STRUCTURE_STRIDE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097378i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_BUFFER_TYPE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097379i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_RAW_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097380i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_LD_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097381i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_FORMAT_STORE_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097382i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_ADD_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097383i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_BITWISE_OPS_UNSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097384i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_CMPSTORE_CMPEXCHANGE_UNSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097385i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_EXCHANGE_UNSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097386i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_SIGNED_MINMAX_UNSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097387i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_ATOMIC_UNSIGNED_MINMAX_UNSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097388i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCH_BOUND_RESOURCE_MAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097389i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_OVERFLOW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097390i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCH_THREADGROUPCOUNT_ZERO: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097391i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_STRUCTURE_STRIDE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097392i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_BUFFER_TYPE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097393i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADERRESOURCEVIEW_RAW_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097394i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCH_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097395i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISPATCHINDIRECT_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097396i32);
pub const D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDOFFSET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097397i32);
pub const D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_LARGEOFFSET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097398i32);
pub const D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDDESTINATIONSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097399i32);
pub const D3D11_MESSAGE_ID_COPYSTRUCTURECOUNT_INVALIDSOURCESTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097400i32);
pub const D3D11_MESSAGE_ID_CHECKFORMATSUPPORT_FORMAT_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097401i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097402i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDOFFSET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097403i32);
pub const D3D11_MESSAGE_ID_DEVICE_CSSETUNORDEREDACCESSVIEWS_TOOMANYVIEWS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097404i32);
pub const D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWFLOAT_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097405i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_COUNTER_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097406i32);
pub const D3D11_MESSAGE_ID_REF_WARNING: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097407i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_PIXEL_SHADER_WITHOUT_RTV_OR_DSV: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097408i32);
pub const D3D11_MESSAGE_ID_SHADER_ABORT: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097409i32);
pub const D3D11_MESSAGE_ID_SHADER_MESSAGE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097410i32);
pub const D3D11_MESSAGE_ID_SHADER_ERROR: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097411i32);
pub const D3D11_MESSAGE_ID_OFFERRESOURCES_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097412i32);
pub const D3D11_MESSAGE_ID_HSSETSAMPLERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097413i32);
pub const D3D11_MESSAGE_ID_DSSETSAMPLERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097414i32);
pub const D3D11_MESSAGE_ID_CSSETSAMPLERS_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097415i32);
pub const D3D11_MESSAGE_ID_HSSETSHADER_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097416i32);
pub const D3D11_MESSAGE_ID_DSSETSHADER_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097417i32);
pub const D3D11_MESSAGE_ID_CSSETSHADER_UNBINDDELETINGOBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097418i32);
pub const D3D11_MESSAGE_ID_ENQUEUESETEVENT_INVALIDARG_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097419i32);
pub const D3D11_MESSAGE_ID_ENQUEUESETEVENT_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097420i32);
pub const D3D11_MESSAGE_ID_ENQUEUESETEVENT_ACCESSDENIED_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097421i32);
pub const D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NUMUAVS_INVALIDRANGE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097422i32);
pub const D3D11_MESSAGE_ID_USE_OF_ZERO_REFCOUNT_OBJECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(2097423i32);
pub const D3D11_MESSAGE_ID_D3D11_MESSAGES_END: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(2097424i32);
pub const D3D11_MESSAGE_ID_D3D11_1_MESSAGES_START: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145728i32);
pub const D3D11_MESSAGE_ID_CREATE_VIDEODECODER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145729i32);
pub const D3D11_MESSAGE_ID_CREATE_VIDEOPROCESSORENUM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145730i32);
pub const D3D11_MESSAGE_ID_CREATE_VIDEOPROCESSOR: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145731i32);
pub const D3D11_MESSAGE_ID_CREATE_DECODEROUTPUTVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145732i32);
pub const D3D11_MESSAGE_ID_CREATE_PROCESSORINPUTVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145733i32);
pub const D3D11_MESSAGE_ID_CREATE_PROCESSOROUTPUTVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145734i32);
pub const D3D11_MESSAGE_ID_CREATE_DEVICECONTEXTSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145735i32);
pub const D3D11_MESSAGE_ID_LIVE_VIDEODECODER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145736i32);
pub const D3D11_MESSAGE_ID_LIVE_VIDEOPROCESSORENUM: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145737i32);
pub const D3D11_MESSAGE_ID_LIVE_VIDEOPROCESSOR: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145738i32);
pub const D3D11_MESSAGE_ID_LIVE_DECODEROUTPUTVIEW: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145739i32);
pub const D3D11_MESSAGE_ID_LIVE_PROCESSORINPUTVIEW: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145740i32);
pub const D3D11_MESSAGE_ID_LIVE_PROCESSOROUTPUTVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145741i32);
pub const D3D11_MESSAGE_ID_LIVE_DEVICECONTEXTSTATE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145742i32);
pub const D3D11_MESSAGE_ID_DESTROY_VIDEODECODER: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145743i32);
pub const D3D11_MESSAGE_ID_DESTROY_VIDEOPROCESSORENUM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145744i32);
pub const D3D11_MESSAGE_ID_DESTROY_VIDEOPROCESSOR: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145745i32);
pub const D3D11_MESSAGE_ID_DESTROY_DECODEROUTPUTVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145746i32);
pub const D3D11_MESSAGE_ID_DESTROY_PROCESSORINPUTVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145747i32);
pub const D3D11_MESSAGE_ID_DESTROY_PROCESSOROUTPUTVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145748i32);
pub const D3D11_MESSAGE_ID_DESTROY_DEVICECONTEXTSTATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145749i32);
pub const D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145750i32);
pub const D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDFEATURELEVEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145751i32);
pub const D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_FEATURELEVELS_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145752i32);
pub const D3D11_MESSAGE_ID_CREATEDEVICECONTEXTSTATE_INVALIDREFIID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145753i32);
pub const D3D11_MESSAGE_ID_DEVICE_DISCARDVIEW_INVALIDVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145754i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION1_INVALIDCOPYFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145755i32);
pub const D3D11_MESSAGE_ID_UPDATESUBRESOURCE1_INVALIDCOPYFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145756i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145757i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODER_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145758i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODER_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145759i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODER_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145760i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODER_ZEROWIDTHHEIGHT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145761i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODER_DRIVER_INVALIDBUFFERSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145762i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODER_DRIVER_INVALIDBUFFERUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145763i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERPROFILECOUNT_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145764i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145765i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_INVALIDINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145766i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERPROFILE_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145767i32);
pub const D3D11_MESSAGE_ID_CHECKVIDEODECODERFORMAT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145768i32);
pub const D3D11_MESSAGE_ID_CHECKVIDEODECODERFORMAT_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145769i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERCONFIGCOUNT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145770i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERCONFIGCOUNT_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145771i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145772i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_INVALIDINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145773i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERCONFIG_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145774i32);
pub const D3D11_MESSAGE_ID_GETDECODERCREATIONPARAMS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145775i32);
pub const D3D11_MESSAGE_ID_GETDECODERDRIVERHANDLE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145776i32);
pub const D3D11_MESSAGE_ID_GETDECODERBUFFER_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145777i32);
pub const D3D11_MESSAGE_ID_GETDECODERBUFFER_INVALIDBUFFER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145778i32);
pub const D3D11_MESSAGE_ID_GETDECODERBUFFER_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145779i32);
pub const D3D11_MESSAGE_ID_GETDECODERBUFFER_LOCKED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145780i32);
pub const D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145781i32);
pub const D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145782i32);
pub const D3D11_MESSAGE_ID_RELEASEDECODERBUFFER_NOTLOCKED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145783i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145784i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145785i32);
pub const D3D11_MESSAGE_ID_DECODERENDFRAME_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145786i32);
pub const D3D11_MESSAGE_ID_SUBMITDECODERBUFFERS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145787i32);
pub const D3D11_MESSAGE_ID_SUBMITDECODERBUFFERS_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145788i32);
pub const D3D11_MESSAGE_ID_DECODEREXTENSION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145789i32);
pub const D3D11_MESSAGE_ID_DECODEREXTENSION_INVALIDRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145790i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145791i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145792i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDFRAMEFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145793i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145794i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDINPUTFRAMERATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145795i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDOUTPUTFRAMERATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145796i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORENUMERATOR_INVALIDWIDTHHEIGHT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145797i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORCONTENTDESC_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145798i32);
pub const D3D11_MESSAGE_ID_CHECKVIDEOPROCESSORFORMAT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145799i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORCAPS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145800i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORRATECONVERSIONCAPS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145801i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORRATECONVERSIONCAPS_INVALIDINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145802i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORCUSTOMRATE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145803i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORCUSTOMRATE_INVALIDINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145804i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORFILTERRANGE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145805i32);
pub const D3D11_MESSAGE_ID_GETVIDEOPROCESSORFILTERRANGE_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145806i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOR_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145807i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOR_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145808i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTTARGETRECT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145809i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145810i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_INVALIDALPHA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145811i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCOLORSPACE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145812i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145813i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145814i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145815i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDFILLMODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145816i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145817i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSTEREOMODE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145818i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSTEREOMODE_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145819i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTEXTENSION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145820i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTTARGETRECT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145821i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTBACKGROUNDCOLOR_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145822i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCOLORSPACE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145823i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTALPHAFILLMODE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145824i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCONSTRICTION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145825i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145826i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCONSTRICTION_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145827i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTSTEREOMODE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145828i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTEXTENSION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145829i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145830i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145831i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145832i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145833i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145834i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145835i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDRATE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145836i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDFLAG: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145837i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145838i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145839i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145840i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145841i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145842i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145843i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145844i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145845i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145846i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_INVALIDALPHA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145847i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145848i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145849i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145850i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPALETTE_INVALIDALPHA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145851i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145852i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145853i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDRATIO: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145854i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145855i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145856i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDRANGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145857i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMLUMAKEY_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145858i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145859i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145860i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145861i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FLIPUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145862i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_MONOOFFSETUNSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145863i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FORMATUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145864i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145865i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145866i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145867i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145868i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145869i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDFILTER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145870i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145871i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMFILTER_INVALIDLEVEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145872i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMEXTENSION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145873i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMEXTENSION_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145874i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFRAMEFORMAT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145875i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145876i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMOUTPUTRATE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145877i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSOURCERECT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145878i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMDESTRECT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145879i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMALPHA_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145880i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPALETTE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145881i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145882i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMLUMAKEY_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145883i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSTEREOFORMAT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145884i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145885i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFILTER_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145886i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMEXTENSION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145887i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMEXTENSION_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145888i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145889i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDSTREAMCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145890i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_TARGETRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145891i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDOUTPUT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145892i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDPASTFRAMES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145893i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDFUTUREFRAMES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145894i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDSOURCERECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145895i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDDESTRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145896i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDINPUTRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145897i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDARRAYSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145898i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDARRAY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145899i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_RIGHTEXPECTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145900i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_RIGHTNOTEXPECTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145901i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_STEREONOTENABLED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145902i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INVALIDRIGHTRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145903i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_NOSTEREOSTREAMS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145904i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_INPUTHAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145905i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORBLT_OUTPUTHAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145906i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145907i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145908i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145909i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDBIND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145910i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145911i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDMIP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145912i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEMIP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145913i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAYSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145914i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145915i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEODECODEROUTPUTVIEW_INVALIDDIMENSION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145916i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145917i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145918i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145919i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDBIND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145920i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMISC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145921i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145922i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145923i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFOURCC: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145924i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMIP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145925i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_UNSUPPORTEDMIP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145926i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAYSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145927i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145928i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDDIMENSION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145929i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145930i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145931i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145932i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDBIND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145933i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145934i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMIP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145935i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDMIP: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145936i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDARRAY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145937i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDARRAY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145938i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDDIMENSION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145939i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_USE_OF_FORCED_SAMPLE_COUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145940i32);
pub const D3D11_MESSAGE_ID_CREATEBLENDSTATE_INVALIDLOGICOPS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145941i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDDARRAYWITHDECODER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145942i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDDARRAYWITHDECODER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145943i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDDARRAYWITHDECODER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145944i32);
pub const D3D11_MESSAGE_ID_DEVICE_LOCKEDOUT_INTERFACE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145945i32);
pub const D3D11_MESSAGE_ID_REF_WARNING_ATOMIC_INCONSISTENT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145946i32);
pub const D3D11_MESSAGE_ID_REF_WARNING_READING_UNINITIALIZED_RESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145947i32);
pub const D3D11_MESSAGE_ID_REF_WARNING_RAW_HAZARD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145948i32);
pub const D3D11_MESSAGE_ID_REF_WARNING_WAR_HAZARD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145949i32);
pub const D3D11_MESSAGE_ID_REF_WARNING_WAW_HAZARD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145950i32);
pub const D3D11_MESSAGE_ID_CREATECRYPTOSESSION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145951i32);
pub const D3D11_MESSAGE_ID_CREATECRYPTOSESSION_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145952i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOTYPE_NULLPARAM: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145953i32);
pub const D3D11_MESSAGE_ID_GETDECODERPROFILE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145954i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATESIZE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145955i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145956i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOSESSIONCERTIFICATE_WRONGSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145957i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOSESSIONHANDLE_WRONGSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145958i32);
pub const D3D11_MESSAGE_ID_NEGOTIATECRPYTOSESSIONKEYEXCHANGE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145959i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145960i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_NULLPARAM: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145961i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_WRONGDEVICE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145962i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_WRONGDEVICE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145963i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_FORMAT_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145964i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_SIZE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145965i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_MULTISAMPLED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145966i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_NOT_STAGING: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145967i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_MAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145968i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_MAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145969i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_OFFERED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145970i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_DST_OFFERED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145971i32);
pub const D3D11_MESSAGE_ID_ENCRYPTIONBLT_SRC_CONTENT_UNDEFINED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145972i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145973i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_NULLPARAM: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3145974i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_WRONGDEVICE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145975i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_WRONGDEVICE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145976i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_FORMAT_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145977i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_SIZE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145978i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_MULTISAMPLED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145979i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_NOT_STAGING: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145980i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_NOT_RENDER_TARGET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145981i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_MAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145982i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_MAPPED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145983i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_OFFERED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145984i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_DST_OFFERED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145985i32);
pub const D3D11_MESSAGE_ID_DECRYPTIONBLT_SRC_CONTENT_UNDEFINED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145986i32);
pub const D3D11_MESSAGE_ID_STARTSESSIONKEYREFRESH_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145987i32);
pub const D3D11_MESSAGE_ID_STARTSESSIONKEYREFRESH_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145988i32);
pub const D3D11_MESSAGE_ID_FINISHSESSIONKEYREFRESH_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145989i32);
pub const D3D11_MESSAGE_ID_GETENCRYPTIONBLTKEY_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145990i32);
pub const D3D11_MESSAGE_ID_GETENCRYPTIONBLTKEY_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145991i32);
pub const D3D11_MESSAGE_ID_GETCONTENTPROTECTIONCAPS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145992i32);
pub const D3D11_MESSAGE_ID_CHECKCRYPTOKEYEXCHANGE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145993i32);
pub const D3D11_MESSAGE_ID_CHECKCRYPTOKEYEXCHANGE_INVALIDINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145994i32);
pub const D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145995i32);
pub const D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145996i32);
pub const D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145997i32);
pub const D3D11_MESSAGE_ID_CREATEAUTHENTICATEDCHANNEL_OUTOFMEMORY_RETURN: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145998i32);
pub const D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATESIZE_INVALIDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3145999i32);
pub const D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATESIZE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146000i32);
pub const D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_INVALIDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146001i32);
pub const D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146002i32);
pub const D3D11_MESSAGE_ID_GETAUTHENTICATEDCHANNELCERTIFICATE_WRONGSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146003i32);
pub const D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDCHANNEL:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146004i32);
pub const D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146005i32);
pub const D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146006i32);
pub const D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_WRONGCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146007i32);
pub const D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_UNSUPPORTEDQUERY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146008i32);
pub const D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_WRONGSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146009i32);
pub const D3D11_MESSAGE_ID_QUERYAUTHENTICATEDCHANNEL_INVALIDPROCESSINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146010i32);
pub const D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146011i32);
pub const D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_WRONGCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146012i32);
pub const D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_UNSUPPORTEDCONFIGURE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146013i32);
pub const D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_WRONGSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146014i32);
pub const D3D11_MESSAGE_ID_CONFIGUREAUTHENTICATEDCHANNEL_INVALIDPROCESSIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146015i32);
pub const D3D11_MESSAGE_ID_VSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146016i32);
pub const D3D11_MESSAGE_ID_DSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146017i32);
pub const D3D11_MESSAGE_ID_HSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146018i32);
pub const D3D11_MESSAGE_ID_GSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146019i32);
pub const D3D11_MESSAGE_ID_PSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146020i32);
pub const D3D11_MESSAGE_ID_CSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146021i32);
pub const D3D11_MESSAGE_ID_NEGOTIATECRPYTOSESSIONKEYEXCHANGE_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146022i32);
pub const D3D11_MESSAGE_ID_NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146023i32);
pub const D3D11_MESSAGE_ID_OFFERRESOURCES_INVALIDPRIORITY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146024i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOSESSIONHANDLE_OUTOFMEMORY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146025i32);
pub const D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146026i32);
pub const D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146027i32);
pub const D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDBIND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146028i32);
pub const D3D11_MESSAGE_ID_ACQUIREHANDLEFORCAPTURE_INVALIDARRAY: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146029i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146030i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146031i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_INVALID: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146032i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMROTATION_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146033i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMROTATION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146034i32);
pub const D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDVIEW: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146035i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146036i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_SHADEREXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146037i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146038i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_SHADEREXTENSIONSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146039i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146040i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_SHADEREXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146041i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146042i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_SHADEREXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146043i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED : D3D11_MESSAGE_ID = D3D11_MESSAGE_ID ( 3146044i32 ) ;
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_SHADEREXTENSIONSNOTSUPPORTED : D3D11_MESSAGE_ID = D3D11_MESSAGE_ID ( 3146045i32 ) ;
pub const D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146046i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_SHADEREXTENSIONSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146047i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146048i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_SHADEREXTENSIONSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146049i32);
pub const D3D11_MESSAGE_ID_DEVICE_SHADER_LINKAGE_MINPRECISION: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146050i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMALPHA_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146051i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146052i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146053i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146054i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146055i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146056i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146057i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146058i32);
pub const D3D11_MESSAGE_ID_DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146059i32);
pub const D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_INVALIDOFFSET:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146060i32);
pub const D3D11_MESSAGE_ID_DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_TOOMANYVIEWS:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146061i32);
pub const D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_NOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146062i32);
pub const D3D11_MESSAGE_ID_SWAPDEVICECONTEXTSTATE_NOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146063i32);
pub const D3D11_MESSAGE_ID_UPDATESUBRESOURCE_PREFERUPDATESUBRESOURCE1: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146064i32);
pub const D3D11_MESSAGE_ID_GETDC_INACCESSIBLE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146065i32);
pub const D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146066i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_SAMPLE_MASK_IGNORED_ON_FL9: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146067i32);
pub const D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE1_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146068i32);
pub const D3D11_MESSAGE_ID_DEVICE_OPEN_SHARED_RESOURCE_BY_NAME_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146069i32);
pub const D3D11_MESSAGE_ID_ENQUEUESETEVENT_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146070i32);
pub const D3D11_MESSAGE_ID_OFFERRELEASE_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146071i32);
pub const D3D11_MESSAGE_ID_OFFERRESOURCES_INACCESSIBLE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146072i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMSAA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146073i32);
pub const D3D11_MESSAGE_ID_CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMSAA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146074i32);
pub const D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_INVALIDSOURCERECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146075i32);
pub const D3D11_MESSAGE_ID_DEVICE_CLEARVIEW_EMPTYRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146076i32);
pub const D3D11_MESSAGE_ID_UPDATESUBRESOURCE_EMPTYDESTBOX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146077i32);
pub const D3D11_MESSAGE_ID_COPYSUBRESOURCEREGION_EMPTYSOURCEBOX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146078i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146079i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_DEPTHSTENCILVIEW_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146080i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146081i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET_DUE_TO_FLIP_PRESENT:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146082i32);
pub const D3D11_MESSAGE_ID_DEVICE_UNORDEREDACCESSVIEW_NOT_SET_DUE_TO_FLIP_PRESENT:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146083i32);
pub const D3D11_MESSAGE_ID_GETDATAFORNEWHARDWAREKEY_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146084i32);
pub const D3D11_MESSAGE_ID_CHECKCRYPTOSESSIONSTATUS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146085i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOSESSIONPRIVATEDATASIZE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146086i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERCAPS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146087i32);
pub const D3D11_MESSAGE_ID_GETVIDEODECODERCAPS_ZEROWIDTHHEIGHT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146088i32);
pub const D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146089i32);
pub const D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146090i32);
pub const D3D11_MESSAGE_ID_CHECKVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146091i32);
pub const D3D11_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146092i32);
pub const D3D11_MESSAGE_ID_VIDEODECODERENABLEDOWNSAMPLING_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146093i32);
pub const D3D11_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146094i32);
pub const D3D11_MESSAGE_ID_VIDEODECODERUPDATEDOWNSAMPLING_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146095i32);
pub const D3D11_MESSAGE_ID_CHECKVIDEOPROCESSORFORMATCONVERSION_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146096i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTCOLORSPACE1_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146097i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTCOLORSPACE1_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146098i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146099i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMCOLORSPACE1_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146100i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146101i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146102i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMMIRROR_UNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146103i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE1_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146104i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMMIRROR_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146105i32);
pub const D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146106i32);
pub const D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146107i32);
pub const D3D11_MESSAGE_ID_RECOMMENDVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146108i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTSHADERUSAGE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146109i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTSHADERUSAGE_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146110i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146111i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSTREAMCOUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146112i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_TARGETRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146113i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSOURCERECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146114i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDDESTRECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146115i32);
pub const D3D11_MESSAGE_ID_GETCRYPTOSESSIONPRIVATEDATASIZE_INVALID_KEY_EXCHANGE_TYPE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146116i32);
pub const D3D11_MESSAGE_ID_D3D11_1_MESSAGES_END: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146117i32);
pub const D3D11_MESSAGE_ID_D3D11_2_MESSAGES_START: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146118i32);
pub const D3D11_MESSAGE_ID_CREATEBUFFER_INVALIDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146119i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE1D_INVALIDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146120i32);
pub const D3D11_MESSAGE_ID_CREATETEXTURE2D_INVALIDUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146121i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_STEPRATE_NOT_1: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146122i32);
pub const D3D11_MESSAGE_ID_CREATEINPUTLAYOUT_LEVEL9_INSTANCING_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146123i32);
pub const D3D11_MESSAGE_ID_UPDATETILEMAPPINGS_INVALID_PARAMETER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146124i32);
pub const D3D11_MESSAGE_ID_COPYTILEMAPPINGS_INVALID_PARAMETER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146125i32);
pub const D3D11_MESSAGE_ID_COPYTILES_INVALID_PARAMETER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146126i32);
pub const D3D11_MESSAGE_ID_UPDATETILES_INVALID_PARAMETER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146127i32);
pub const D3D11_MESSAGE_ID_RESIZETILEPOOL_INVALID_PARAMETER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146128i32);
pub const D3D11_MESSAGE_ID_TILEDRESOURCEBARRIER_INVALID_PARAMETER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146129i32);
pub const D3D11_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_WARNING: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146130i32);
pub const D3D11_MESSAGE_ID_NULL_TILE_MAPPING_ACCESS_ERROR: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146131i32);
pub const D3D11_MESSAGE_ID_DIRTY_TILE_MAPPING_ACCESS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146132i32);
pub const D3D11_MESSAGE_ID_DUPLICATE_TILE_MAPPINGS_IN_COVERED_AREA: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146133i32);
pub const D3D11_MESSAGE_ID_TILE_MAPPINGS_IN_COVERED_AREA_DUPLICATED_OUTSIDE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146134i32);
pub const D3D11_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INCOMPATIBLE_RESOURCES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146135i32);
pub const D3D11_MESSAGE_ID_TILE_MAPPINGS_SHARED_BETWEEN_INPUT_AND_OUTPUT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146136i32);
pub const D3D11_MESSAGE_ID_CHECKMULTISAMPLEQUALITYLEVELS_INVALIDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146137i32);
pub const D3D11_MESSAGE_ID_GETRESOURCETILING_NONTILED_RESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146138i32);
pub const D3D11_MESSAGE_ID_RESIZETILEPOOL_SHRINK_WITH_MAPPINGS_STILL_DEFINED_PAST_END:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146139i32);
pub const D3D11_MESSAGE_ID_NEED_TO_CALL_TILEDRESOURCEBARRIER: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146140i32);
pub const D3D11_MESSAGE_ID_CREATEDEVICE_INVALIDARGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146141i32);
pub const D3D11_MESSAGE_ID_CREATEDEVICE_WARNING: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146142i32);
pub const D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWUINT_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146143i32);
pub const D3D11_MESSAGE_ID_CLEARUNORDEREDACCESSVIEWFLOAT_HAZARD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146144i32);
pub const D3D11_MESSAGE_ID_TILED_RESOURCE_TIER_1_BUFFER_TEXTURE_MISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146145i32);
pub const D3D11_MESSAGE_ID_CREATE_CRYPTOSESSION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146146i32);
pub const D3D11_MESSAGE_ID_CREATE_AUTHENTICATEDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146147i32);
pub const D3D11_MESSAGE_ID_LIVE_CRYPTOSESSION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146148i32);
pub const D3D11_MESSAGE_ID_LIVE_AUTHENTICATEDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146149i32);
pub const D3D11_MESSAGE_ID_DESTROY_CRYPTOSESSION: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146150i32);
pub const D3D11_MESSAGE_ID_DESTROY_AUTHENTICATEDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146151i32);
pub const D3D11_MESSAGE_ID_D3D11_2_MESSAGES_END: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146152i32);
pub const D3D11_MESSAGE_ID_D3D11_3_MESSAGES_START: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146153i32);
pub const D3D11_MESSAGE_ID_CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146154i32);
pub const D3D11_MESSAGE_ID_DEVICE_DRAW_INVALID_SYSTEMVALUE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146155i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_INVALIDCONTEXTTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146156i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_DECODENOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146157i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_ENCODENOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146158i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146159i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146160i32);
pub const D3D11_MESSAGE_ID_CREATESHADERRESOURCEVIEW_AMBIGUOUSVIDEOPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146161i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146162i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_INVALIDVIDEOPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146163i32);
pub const D3D11_MESSAGE_ID_CREATERENDERTARGETVIEW_AMBIGUOUSVIDEOPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146164i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146165i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146166i32);
pub const D3D11_MESSAGE_ID_CREATEUNORDEREDACCESSVIEW_AMBIGUOUSVIDEOPLANEINDEX: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146167i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSCANDATAOFFSET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146168i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_NOTSUPPORTED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146169i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_DIMENSIONSTOOLARGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146170i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_INVALIDCOMPONENTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146171i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_DESTINATIONNOT2D: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146172i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_TILEDRESOURCESUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146173i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_GUARDRECTSUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146174i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_FORMATUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146175i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146176i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_INVALIDMIPLEVEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146177i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_EMPTYDESTBOX: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146178i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXNOT2D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146179i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXNOTSUB: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146180i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_DESTBOXESINTERSECT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146181i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146182i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146183i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_XSUBSAMPLEODD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146184i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_YSUBSAMPLEODD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146185i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_OUTPUTDIMENSIONSTOOLARGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146186i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_NONPOW2SCALEUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146187i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_FRACTIONALDOWNSCALETOLARGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146188i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_CHROMASIZEMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146189i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_LUMACHROMASIZEMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146190i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_INVALIDNUMDESTINATIONS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146191i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_SUBBOXUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146192i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_1DESTUNSUPPORTEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146193i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_3DESTUNSUPPORTEDFORMAT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146194i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_SCALEUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146195i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_INVALIDSOURCESIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146196i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_INVALIDCOPYFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146197i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_HAZARD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146198i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146199i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDSRCBUFFERMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146200i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPORTEDDSTTEXTUREUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146201i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_BACKBUFFERNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146202i32);
pub const D3D11_MESSAGE_ID_JPEGDECODE_UNSUPPRTEDCOPYFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146203i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_NOTSUPPORTED: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146204i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_INVALIDSCANDATAOFFSET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146205i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_INVALIDCOMPONENTS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146206i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_SOURCENOT2D: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146207i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_TILEDRESOURCESUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146208i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_GUARDRECTSUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146209i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_XSUBSAMPLEMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146210i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_YSUBSAMPLEMISMATCH: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146211i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_FORMATUNSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146212i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_INVALIDSUBRESOURCE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146213i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_INVALIDMIPLEVEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146214i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_DIMENSIONSTOOLARGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146215i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_HAZARD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146216i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146217i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDDSTBUFFERMISCFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146218i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_UNSUPPORTEDSRCTEXTUREUSAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146219i32);
pub const D3D11_MESSAGE_ID_JPEGENCODE_BACKBUFFERNOTSUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146220i32);
pub const D3D11_MESSAGE_ID_CREATEQUERYORPREDICATE_UNSUPPORTEDCONTEXTTTYPEFORQUERY:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146221i32);
pub const D3D11_MESSAGE_ID_FLUSH1_INVALIDCONTEXTTYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146222i32);
pub const D3D11_MESSAGE_ID_DEVICE_SETHARDWAREPROTECTION_INVALIDCONTEXT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146223i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTHDRMETADATA_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146224i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETOUTPUTHDRMETADATA_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146225i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTHDRMETADATA_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146226i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETOUTPUTHDRMETADATA_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146227i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146228i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146229i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146230i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146231i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146232i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146233i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFRAMEFORMAT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146234i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146235i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMOUTPUTRATE_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146236i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSOURCERECT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146237i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMDESTRECT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146238i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMALPHA_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146239i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPALETTE_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146240i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146241i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMLUMAKEY_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146242i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMSTEREOFORMAT_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146243i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146244i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMFILTER_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146245i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMROTATION_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146246i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMCOLORSPACE1_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146247i32);
pub const D3D11_MESSAGE_ID_VIDEOPROCESSORGETSTREAMMIRROR_INVALIDSTREAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146248i32);
pub const D3D11_MESSAGE_ID_CREATE_FENCE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146249i32);
pub const D3D11_MESSAGE_ID_LIVE_FENCE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146250i32);
pub const D3D11_MESSAGE_ID_DESTROY_FENCE: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146251i32);
pub const D3D11_MESSAGE_ID_CREATE_SYNCHRONIZEDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146252i32);
pub const D3D11_MESSAGE_ID_LIVE_SYNCHRONIZEDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146253i32);
pub const D3D11_MESSAGE_ID_DESTROY_SYNCHRONIZEDCHANNEL: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146254i32);
pub const D3D11_MESSAGE_ID_CREATEFENCE_INVALIDFLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146255i32);
pub const D3D11_MESSAGE_ID_D3D11_3_MESSAGES_END: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146256i32);
pub const D3D11_MESSAGE_ID_D3D11_5_MESSAGES_START: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146257i32);
pub const D3D11_MESSAGE_ID_NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_INVALIDKEYEXCHANGETYPE:
    D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146258i32);
pub const D3D11_MESSAGE_ID_NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146259i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT_COUNT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146260i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146261i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_SIZE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146262i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_USAGE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146263i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_MISC_FLAGS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146264i32);
pub const D3D11_MESSAGE_ID_DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_OFFSET: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146265i32);
pub const D3D11_MESSAGE_ID_CREATE_TRACKEDWORKLOAD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146266i32);
pub const D3D11_MESSAGE_ID_LIVE_TRACKEDWORKLOAD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146267i32);
pub const D3D11_MESSAGE_ID_DESTROY_TRACKEDWORKLOAD: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146268i32);
pub const D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_NULLPARAM: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146269i32);
pub const D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_INVALID_MAX_INSTANCES: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146270i32);
pub const D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_INVALID_DEADLINE_TYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146271i32);
pub const D3D11_MESSAGE_ID_CREATE_TRACKED_WORKLOAD_INVALID_ENGINE_TYPE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146272i32);
pub const D3D11_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOADS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146273i32);
pub const D3D11_MESSAGE_ID_MULTIPLE_TRACKED_WORKLOAD_PAIRS: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146274i32);
pub const D3D11_MESSAGE_ID_INCOMPLETE_TRACKED_WORKLOAD_PAIR: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146275i32);
pub const D3D11_MESSAGE_ID_OUT_OF_ORDER_TRACKED_WORKLOAD_PAIR: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146276i32);
pub const D3D11_MESSAGE_ID_CANNOT_ADD_TRACKED_WORKLOAD: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146277i32);
pub const D3D11_MESSAGE_ID_TRACKED_WORKLOAD_NOT_SUPPORTED: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146278i32);
pub const D3D11_MESSAGE_ID_TRACKED_WORKLOAD_ENGINE_TYPE_NOT_FOUND: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146279i32);
pub const D3D11_MESSAGE_ID_NO_TRACKED_WORKLOAD_SLOT_AVAILABLE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146280i32);
pub const D3D11_MESSAGE_ID_END_TRACKED_WORKLOAD_INVALID_ARG: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146281i32);
pub const D3D11_MESSAGE_ID_TRACKED_WORKLOAD_DISJOINT_FAILURE: D3D11_MESSAGE_ID =
    D3D11_MESSAGE_ID(3146282i32);
pub const D3D11_MESSAGE_ID_D3D11_5_MESSAGES_END: D3D11_MESSAGE_ID = D3D11_MESSAGE_ID(3146283i32);
impl ::std::convert::From<i32> for D3D11_MESSAGE_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_MESSAGE_ID {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_MESSAGE_SEVERITY(pub i32);
pub const D3D11_MESSAGE_SEVERITY_CORRUPTION: D3D11_MESSAGE_SEVERITY = D3D11_MESSAGE_SEVERITY(0i32);
pub const D3D11_MESSAGE_SEVERITY_ERROR: D3D11_MESSAGE_SEVERITY = D3D11_MESSAGE_SEVERITY(1i32);
pub const D3D11_MESSAGE_SEVERITY_WARNING: D3D11_MESSAGE_SEVERITY = D3D11_MESSAGE_SEVERITY(2i32);
pub const D3D11_MESSAGE_SEVERITY_INFO: D3D11_MESSAGE_SEVERITY = D3D11_MESSAGE_SEVERITY(3i32);
pub const D3D11_MESSAGE_SEVERITY_MESSAGE: D3D11_MESSAGE_SEVERITY = D3D11_MESSAGE_SEVERITY(4i32);
impl ::std::convert::From<i32> for D3D11_MESSAGE_SEVERITY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_MESSAGE_SEVERITY {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_MINOR_VERSION: u32 = 0u32;
pub const D3D11_MIN_BORDER_COLOR_COMPONENT: f32 = 0f32;
pub const D3D11_MIN_DEPTH: f32 = 0f32;
pub const D3D11_MIN_FILTER_SHIFT: u32 = 4u32;
pub const D3D11_MIN_MAXANISOTROPY: u32 = 0u32;
pub const D3D11_MIP_FILTER_SHIFT: u32 = 0u32;
pub const D3D11_MIP_LOD_BIAS_MAX: f32 = 15.99f32;
pub const D3D11_MIP_LOD_BIAS_MIN: f32 = -16f32;
pub const D3D11_MIP_LOD_FRACTIONAL_BIT_COUNT: u32 = 8u32;
pub const D3D11_MIP_LOD_RANGE_BIT_COUNT: u32 = 8u32;
pub const D3D11_MULTISAMPLE_ANTIALIAS_LINE_WIDTH: f32 = 1.4f32;
pub const D3D11_NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_OMAC {
    pub Omac: [u8; 16],
}
impl D3D11_OMAC {}
impl ::std::default::Default for D3D11_OMAC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_OMAC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_OMAC")
            .field("Omac", &self.Omac)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_OMAC {
    fn eq(&self, other: &Self) -> bool {
        self.Omac == other.Omac
    }
}
impl ::std::cmp::Eq for D3D11_OMAC {}
unsafe impl ::windows::runtime::Abi for D3D11_OMAC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_PACKED_MIP_DESC {
    pub NumStandardMips: u8,
    pub NumPackedMips: u8,
    pub NumTilesForPackedMips: u32,
    pub StartTileIndexInOverallResource: u32,
}
impl D3D11_PACKED_MIP_DESC {}
impl ::std::default::Default for D3D11_PACKED_MIP_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_PACKED_MIP_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_PACKED_MIP_DESC")
            .field("NumStandardMips", &self.NumStandardMips)
            .field("NumPackedMips", &self.NumPackedMips)
            .field("NumTilesForPackedMips", &self.NumTilesForPackedMips)
            .field(
                "StartTileIndexInOverallResource",
                &self.StartTileIndexInOverallResource,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_PACKED_MIP_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.NumStandardMips == other.NumStandardMips
            && self.NumPackedMips == other.NumPackedMips
            && self.NumTilesForPackedMips == other.NumTilesForPackedMips
            && self.StartTileIndexInOverallResource == other.StartTileIndexInOverallResource
    }
}
impl ::std::cmp::Eq for D3D11_PACKED_MIP_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_PACKED_MIP_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_PACKED_TILE: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_PARAMETER_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub SemanticName: super::super::Foundation::PSTR,
    pub Type: D3D_SHADER_VARIABLE_TYPE,
    pub Class: D3D_SHADER_VARIABLE_CLASS,
    pub Rows: u32,
    pub Columns: u32,
    pub InterpolationMode: D3D_INTERPOLATION_MODE,
    pub Flags: D3D_PARAMETER_FLAGS,
    pub FirstInRegister: u32,
    pub FirstInComponent: u32,
    pub FirstOutRegister: u32,
    pub FirstOutComponent: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_PARAMETER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_PARAMETER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_PARAMETER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_PARAMETER_DESC")
            .field("Name", &self.Name)
            .field("SemanticName", &self.SemanticName)
            .field("Type", &self.Type)
            .field("Class", &self.Class)
            .field("Rows", &self.Rows)
            .field("Columns", &self.Columns)
            .field("InterpolationMode", &self.InterpolationMode)
            .field("Flags", &self.Flags)
            .field("FirstInRegister", &self.FirstInRegister)
            .field("FirstInComponent", &self.FirstInComponent)
            .field("FirstOutRegister", &self.FirstOutRegister)
            .field("FirstOutComponent", &self.FirstOutComponent)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_PARAMETER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name
            && self.SemanticName == other.SemanticName
            && self.Type == other.Type
            && self.Class == other.Class
            && self.Rows == other.Rows
            && self.Columns == other.Columns
            && self.InterpolationMode == other.InterpolationMode
            && self.Flags == other.Flags
            && self.FirstInRegister == other.FirstInRegister
            && self.FirstInComponent == other.FirstInComponent
            && self.FirstOutRegister == other.FirstOutRegister
            && self.FirstOutComponent == other.FirstOutComponent
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_PARAMETER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_PARAMETER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 15u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_PIXEL_SHADER_TRACE_DESC {
    pub Invocation: u64,
    pub X: i32,
    pub Y: i32,
    pub SampleMask: u64,
}
impl D3D11_PIXEL_SHADER_TRACE_DESC {}
impl ::std::default::Default for D3D11_PIXEL_SHADER_TRACE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_PIXEL_SHADER_TRACE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_PIXEL_SHADER_TRACE_DESC")
            .field("Invocation", &self.Invocation)
            .field("X", &self.X)
            .field("Y", &self.Y)
            .field("SampleMask", &self.SampleMask)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_PIXEL_SHADER_TRACE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Invocation == other.Invocation
            && self.X == other.X
            && self.Y == other.Y
            && self.SampleMask == other.SampleMask
    }
}
impl ::std::cmp::Eq for D3D11_PIXEL_SHADER_TRACE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_PIXEL_SHADER_TRACE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 16u32;
pub const D3D11_PS_CS_UAV_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_PS_CS_UAV_REGISTER_COUNT: u32 = 8u32;
pub const D3D11_PS_CS_UAV_REGISTER_READS_PER_INST: u32 = 1u32;
pub const D3D11_PS_CS_UAV_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_PS_FRONTFACING_DEFAULT_VALUE: u32 = 4294967295u32;
pub const D3D11_PS_FRONTFACING_FALSE_VALUE: u32 = 0u32;
pub const D3D11_PS_FRONTFACING_TRUE_VALUE: u32 = 4294967295u32;
pub const D3D11_PS_INPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_PS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_PS_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_PS_INPUT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_PS_INPUT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT: f32 = 0f32;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_PS_OUTPUT_DEPTH_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENTS: u32 = 1u32;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_PS_OUTPUT_MASK_REGISTER_COUNT: u32 = 1u32;
pub const D3D11_PS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_PS_OUTPUT_REGISTER_COUNT: u32 = 8u32;
pub const D3D11_PS_PIXEL_CENTER_FRACTIONAL_COMPONENT: f32 = 0.5f32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_QUERY(pub i32);
pub const D3D11_QUERY_EVENT: D3D11_QUERY = D3D11_QUERY(0i32);
pub const D3D11_QUERY_OCCLUSION: D3D11_QUERY = D3D11_QUERY(1i32);
pub const D3D11_QUERY_TIMESTAMP: D3D11_QUERY = D3D11_QUERY(2i32);
pub const D3D11_QUERY_TIMESTAMP_DISJOINT: D3D11_QUERY = D3D11_QUERY(3i32);
pub const D3D11_QUERY_PIPELINE_STATISTICS: D3D11_QUERY = D3D11_QUERY(4i32);
pub const D3D11_QUERY_OCCLUSION_PREDICATE: D3D11_QUERY = D3D11_QUERY(5i32);
pub const D3D11_QUERY_SO_STATISTICS: D3D11_QUERY = D3D11_QUERY(6i32);
pub const D3D11_QUERY_SO_OVERFLOW_PREDICATE: D3D11_QUERY = D3D11_QUERY(7i32);
pub const D3D11_QUERY_SO_STATISTICS_STREAM0: D3D11_QUERY = D3D11_QUERY(8i32);
pub const D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM0: D3D11_QUERY = D3D11_QUERY(9i32);
pub const D3D11_QUERY_SO_STATISTICS_STREAM1: D3D11_QUERY = D3D11_QUERY(10i32);
pub const D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM1: D3D11_QUERY = D3D11_QUERY(11i32);
pub const D3D11_QUERY_SO_STATISTICS_STREAM2: D3D11_QUERY = D3D11_QUERY(12i32);
pub const D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM2: D3D11_QUERY = D3D11_QUERY(13i32);
pub const D3D11_QUERY_SO_STATISTICS_STREAM3: D3D11_QUERY = D3D11_QUERY(14i32);
pub const D3D11_QUERY_SO_OVERFLOW_PREDICATE_STREAM3: D3D11_QUERY = D3D11_QUERY(15i32);
impl ::std::convert::From<i32> for D3D11_QUERY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_QUERY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_QUERY_DATA_PIPELINE_STATISTICS {
    pub IAVertices: u64,
    pub IAPrimitives: u64,
    pub VSInvocations: u64,
    pub GSInvocations: u64,
    pub GSPrimitives: u64,
    pub CInvocations: u64,
    pub CPrimitives: u64,
    pub PSInvocations: u64,
    pub HSInvocations: u64,
    pub DSInvocations: u64,
    pub CSInvocations: u64,
}
impl D3D11_QUERY_DATA_PIPELINE_STATISTICS {}
impl ::std::default::Default for D3D11_QUERY_DATA_PIPELINE_STATISTICS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_QUERY_DATA_PIPELINE_STATISTICS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_QUERY_DATA_PIPELINE_STATISTICS")
            .field("IAVertices", &self.IAVertices)
            .field("IAPrimitives", &self.IAPrimitives)
            .field("VSInvocations", &self.VSInvocations)
            .field("GSInvocations", &self.GSInvocations)
            .field("GSPrimitives", &self.GSPrimitives)
            .field("CInvocations", &self.CInvocations)
            .field("CPrimitives", &self.CPrimitives)
            .field("PSInvocations", &self.PSInvocations)
            .field("HSInvocations", &self.HSInvocations)
            .field("DSInvocations", &self.DSInvocations)
            .field("CSInvocations", &self.CSInvocations)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_QUERY_DATA_PIPELINE_STATISTICS {
    fn eq(&self, other: &Self) -> bool {
        self.IAVertices == other.IAVertices
            && self.IAPrimitives == other.IAPrimitives
            && self.VSInvocations == other.VSInvocations
            && self.GSInvocations == other.GSInvocations
            && self.GSPrimitives == other.GSPrimitives
            && self.CInvocations == other.CInvocations
            && self.CPrimitives == other.CPrimitives
            && self.PSInvocations == other.PSInvocations
            && self.HSInvocations == other.HSInvocations
            && self.DSInvocations == other.DSInvocations
            && self.CSInvocations == other.CSInvocations
    }
}
impl ::std::cmp::Eq for D3D11_QUERY_DATA_PIPELINE_STATISTICS {}
unsafe impl ::windows::runtime::Abi for D3D11_QUERY_DATA_PIPELINE_STATISTICS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_QUERY_DATA_SO_STATISTICS {
    pub NumPrimitivesWritten: u64,
    pub PrimitivesStorageNeeded: u64,
}
impl D3D11_QUERY_DATA_SO_STATISTICS {}
impl ::std::default::Default for D3D11_QUERY_DATA_SO_STATISTICS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_QUERY_DATA_SO_STATISTICS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_QUERY_DATA_SO_STATISTICS")
            .field("NumPrimitivesWritten", &self.NumPrimitivesWritten)
            .field("PrimitivesStorageNeeded", &self.PrimitivesStorageNeeded)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_QUERY_DATA_SO_STATISTICS {
    fn eq(&self, other: &Self) -> bool {
        self.NumPrimitivesWritten == other.NumPrimitivesWritten
            && self.PrimitivesStorageNeeded == other.PrimitivesStorageNeeded
    }
}
impl ::std::cmp::Eq for D3D11_QUERY_DATA_SO_STATISTICS {}
unsafe impl ::windows::runtime::Abi for D3D11_QUERY_DATA_SO_STATISTICS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {
    pub Frequency: u64,
    pub Disjoint: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_QUERY_DATA_TIMESTAMP_DISJOINT")
            .field("Frequency", &self.Frequency)
            .field("Disjoint", &self.Disjoint)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {
    fn eq(&self, other: &Self) -> bool {
        self.Frequency == other.Frequency && self.Disjoint == other.Disjoint
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_QUERY_DATA_TIMESTAMP_DISJOINT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_QUERY_DESC {
    pub Query: D3D11_QUERY,
    pub MiscFlags: u32,
}
impl D3D11_QUERY_DESC {}
impl ::std::default::Default for D3D11_QUERY_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_QUERY_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_QUERY_DESC")
            .field("Query", &self.Query)
            .field("MiscFlags", &self.MiscFlags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_QUERY_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Query == other.Query && self.MiscFlags == other.MiscFlags
    }
}
impl ::std::cmp::Eq for D3D11_QUERY_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_QUERY_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_QUERY_DESC1 {
    pub Query: D3D11_QUERY,
    pub MiscFlags: u32,
    pub ContextType: D3D11_CONTEXT_TYPE,
}
impl D3D11_QUERY_DESC1 {}
impl ::std::default::Default for D3D11_QUERY_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_QUERY_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_QUERY_DESC1")
            .field("Query", &self.Query)
            .field("MiscFlags", &self.MiscFlags)
            .field("ContextType", &self.ContextType)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_QUERY_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.Query == other.Query
            && self.MiscFlags == other.MiscFlags
            && self.ContextType == other.ContextType
    }
}
impl ::std::cmp::Eq for D3D11_QUERY_DESC1 {}
unsafe impl ::windows::runtime::Abi for D3D11_QUERY_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_QUERY_MISC_FLAG(pub i32);
pub const D3D11_QUERY_MISC_PREDICATEHINT: D3D11_QUERY_MISC_FLAG = D3D11_QUERY_MISC_FLAG(1i32);
impl ::std::convert::From<i32> for D3D11_QUERY_MISC_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_QUERY_MISC_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_RAISE_FLAG(pub i32);
pub const D3D11_RAISE_FLAG_DRIVER_INTERNAL_ERROR: D3D11_RAISE_FLAG = D3D11_RAISE_FLAG(1i32);
impl ::std::convert::From<i32> for D3D11_RAISE_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_RAISE_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_RASTERIZER_DESC {
    pub FillMode: D3D11_FILL_MODE,
    pub CullMode: D3D11_CULL_MODE,
    pub FrontCounterClockwise: super::super::Foundation::BOOL,
    pub DepthBias: i32,
    pub DepthBiasClamp: f32,
    pub SlopeScaledDepthBias: f32,
    pub DepthClipEnable: super::super::Foundation::BOOL,
    pub ScissorEnable: super::super::Foundation::BOOL,
    pub MultisampleEnable: super::super::Foundation::BOOL,
    pub AntialiasedLineEnable: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_RASTERIZER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_RASTERIZER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_RASTERIZER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_RASTERIZER_DESC")
            .field("FillMode", &self.FillMode)
            .field("CullMode", &self.CullMode)
            .field("FrontCounterClockwise", &self.FrontCounterClockwise)
            .field("DepthBias", &self.DepthBias)
            .field("DepthBiasClamp", &self.DepthBiasClamp)
            .field("SlopeScaledDepthBias", &self.SlopeScaledDepthBias)
            .field("DepthClipEnable", &self.DepthClipEnable)
            .field("ScissorEnable", &self.ScissorEnable)
            .field("MultisampleEnable", &self.MultisampleEnable)
            .field("AntialiasedLineEnable", &self.AntialiasedLineEnable)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_RASTERIZER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.FillMode == other.FillMode
            && self.CullMode == other.CullMode
            && self.FrontCounterClockwise == other.FrontCounterClockwise
            && self.DepthBias == other.DepthBias
            && self.DepthBiasClamp == other.DepthBiasClamp
            && self.SlopeScaledDepthBias == other.SlopeScaledDepthBias
            && self.DepthClipEnable == other.DepthClipEnable
            && self.ScissorEnable == other.ScissorEnable
            && self.MultisampleEnable == other.MultisampleEnable
            && self.AntialiasedLineEnable == other.AntialiasedLineEnable
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_RASTERIZER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_RASTERIZER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_RASTERIZER_DESC1 {
    pub FillMode: D3D11_FILL_MODE,
    pub CullMode: D3D11_CULL_MODE,
    pub FrontCounterClockwise: super::super::Foundation::BOOL,
    pub DepthBias: i32,
    pub DepthBiasClamp: f32,
    pub SlopeScaledDepthBias: f32,
    pub DepthClipEnable: super::super::Foundation::BOOL,
    pub ScissorEnable: super::super::Foundation::BOOL,
    pub MultisampleEnable: super::super::Foundation::BOOL,
    pub AntialiasedLineEnable: super::super::Foundation::BOOL,
    pub ForcedSampleCount: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_RASTERIZER_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_RASTERIZER_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_RASTERIZER_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_RASTERIZER_DESC1")
            .field("FillMode", &self.FillMode)
            .field("CullMode", &self.CullMode)
            .field("FrontCounterClockwise", &self.FrontCounterClockwise)
            .field("DepthBias", &self.DepthBias)
            .field("DepthBiasClamp", &self.DepthBiasClamp)
            .field("SlopeScaledDepthBias", &self.SlopeScaledDepthBias)
            .field("DepthClipEnable", &self.DepthClipEnable)
            .field("ScissorEnable", &self.ScissorEnable)
            .field("MultisampleEnable", &self.MultisampleEnable)
            .field("AntialiasedLineEnable", &self.AntialiasedLineEnable)
            .field("ForcedSampleCount", &self.ForcedSampleCount)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_RASTERIZER_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.FillMode == other.FillMode
            && self.CullMode == other.CullMode
            && self.FrontCounterClockwise == other.FrontCounterClockwise
            && self.DepthBias == other.DepthBias
            && self.DepthBiasClamp == other.DepthBiasClamp
            && self.SlopeScaledDepthBias == other.SlopeScaledDepthBias
            && self.DepthClipEnable == other.DepthClipEnable
            && self.ScissorEnable == other.ScissorEnable
            && self.MultisampleEnable == other.MultisampleEnable
            && self.AntialiasedLineEnable == other.AntialiasedLineEnable
            && self.ForcedSampleCount == other.ForcedSampleCount
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_RASTERIZER_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_RASTERIZER_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_RASTERIZER_DESC2 {
    pub FillMode: D3D11_FILL_MODE,
    pub CullMode: D3D11_CULL_MODE,
    pub FrontCounterClockwise: super::super::Foundation::BOOL,
    pub DepthBias: i32,
    pub DepthBiasClamp: f32,
    pub SlopeScaledDepthBias: f32,
    pub DepthClipEnable: super::super::Foundation::BOOL,
    pub ScissorEnable: super::super::Foundation::BOOL,
    pub MultisampleEnable: super::super::Foundation::BOOL,
    pub AntialiasedLineEnable: super::super::Foundation::BOOL,
    pub ForcedSampleCount: u32,
    pub ConservativeRaster: D3D11_CONSERVATIVE_RASTERIZATION_MODE,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_RASTERIZER_DESC2 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_RASTERIZER_DESC2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_RASTERIZER_DESC2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_RASTERIZER_DESC2")
            .field("FillMode", &self.FillMode)
            .field("CullMode", &self.CullMode)
            .field("FrontCounterClockwise", &self.FrontCounterClockwise)
            .field("DepthBias", &self.DepthBias)
            .field("DepthBiasClamp", &self.DepthBiasClamp)
            .field("SlopeScaledDepthBias", &self.SlopeScaledDepthBias)
            .field("DepthClipEnable", &self.DepthClipEnable)
            .field("ScissorEnable", &self.ScissorEnable)
            .field("MultisampleEnable", &self.MultisampleEnable)
            .field("AntialiasedLineEnable", &self.AntialiasedLineEnable)
            .field("ForcedSampleCount", &self.ForcedSampleCount)
            .field("ConservativeRaster", &self.ConservativeRaster)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_RASTERIZER_DESC2 {
    fn eq(&self, other: &Self) -> bool {
        self.FillMode == other.FillMode
            && self.CullMode == other.CullMode
            && self.FrontCounterClockwise == other.FrontCounterClockwise
            && self.DepthBias == other.DepthBias
            && self.DepthBiasClamp == other.DepthBiasClamp
            && self.SlopeScaledDepthBias == other.SlopeScaledDepthBias
            && self.DepthClipEnable == other.DepthClipEnable
            && self.ScissorEnable == other.ScissorEnable
            && self.MultisampleEnable == other.MultisampleEnable
            && self.AntialiasedLineEnable == other.AntialiasedLineEnable
            && self.ForcedSampleCount == other.ForcedSampleCount
            && self.ConservativeRaster == other.ConservativeRaster
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_RASTERIZER_DESC2 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_RASTERIZER_DESC2 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_RAW_UAV_SRV_BYTE_ALIGNMENT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_RENDER_TARGET_BLEND_DESC {
    pub BlendEnable: super::super::Foundation::BOOL,
    pub SrcBlend: D3D11_BLEND,
    pub DestBlend: D3D11_BLEND,
    pub BlendOp: D3D11_BLEND_OP,
    pub SrcBlendAlpha: D3D11_BLEND,
    pub DestBlendAlpha: D3D11_BLEND,
    pub BlendOpAlpha: D3D11_BLEND_OP,
    pub RenderTargetWriteMask: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_RENDER_TARGET_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_RENDER_TARGET_BLEND_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_RENDER_TARGET_BLEND_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_RENDER_TARGET_BLEND_DESC")
            .field("BlendEnable", &self.BlendEnable)
            .field("SrcBlend", &self.SrcBlend)
            .field("DestBlend", &self.DestBlend)
            .field("BlendOp", &self.BlendOp)
            .field("SrcBlendAlpha", &self.SrcBlendAlpha)
            .field("DestBlendAlpha", &self.DestBlendAlpha)
            .field("BlendOpAlpha", &self.BlendOpAlpha)
            .field("RenderTargetWriteMask", &self.RenderTargetWriteMask)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_RENDER_TARGET_BLEND_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.BlendEnable == other.BlendEnable
            && self.SrcBlend == other.SrcBlend
            && self.DestBlend == other.DestBlend
            && self.BlendOp == other.BlendOp
            && self.SrcBlendAlpha == other.SrcBlendAlpha
            && self.DestBlendAlpha == other.DestBlendAlpha
            && self.BlendOpAlpha == other.BlendOpAlpha
            && self.RenderTargetWriteMask == other.RenderTargetWriteMask
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_RENDER_TARGET_BLEND_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_RENDER_TARGET_BLEND_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_RENDER_TARGET_BLEND_DESC1 {
    pub BlendEnable: super::super::Foundation::BOOL,
    pub LogicOpEnable: super::super::Foundation::BOOL,
    pub SrcBlend: D3D11_BLEND,
    pub DestBlend: D3D11_BLEND,
    pub BlendOp: D3D11_BLEND_OP,
    pub SrcBlendAlpha: D3D11_BLEND,
    pub DestBlendAlpha: D3D11_BLEND,
    pub BlendOpAlpha: D3D11_BLEND_OP,
    pub LogicOp: D3D11_LOGIC_OP,
    pub RenderTargetWriteMask: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_RENDER_TARGET_BLEND_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_RENDER_TARGET_BLEND_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_RENDER_TARGET_BLEND_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_RENDER_TARGET_BLEND_DESC1")
            .field("BlendEnable", &self.BlendEnable)
            .field("LogicOpEnable", &self.LogicOpEnable)
            .field("SrcBlend", &self.SrcBlend)
            .field("DestBlend", &self.DestBlend)
            .field("BlendOp", &self.BlendOp)
            .field("SrcBlendAlpha", &self.SrcBlendAlpha)
            .field("DestBlendAlpha", &self.DestBlendAlpha)
            .field("BlendOpAlpha", &self.BlendOpAlpha)
            .field("LogicOp", &self.LogicOp)
            .field("RenderTargetWriteMask", &self.RenderTargetWriteMask)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_RENDER_TARGET_BLEND_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.BlendEnable == other.BlendEnable
            && self.LogicOpEnable == other.LogicOpEnable
            && self.SrcBlend == other.SrcBlend
            && self.DestBlend == other.DestBlend
            && self.BlendOp == other.BlendOp
            && self.SrcBlendAlpha == other.SrcBlendAlpha
            && self.DestBlendAlpha == other.DestBlendAlpha
            && self.BlendOpAlpha == other.BlendOpAlpha
            && self.LogicOp == other.LogicOp
            && self.RenderTargetWriteMask == other.RenderTargetWriteMask
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_RENDER_TARGET_BLEND_DESC1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_RENDER_TARGET_BLEND_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_RENDER_TARGET_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D11_RTV_DIMENSION,
    pub Anonymous: D3D11_RENDER_TARGET_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_RENDER_TARGET_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_RENDER_TARGET_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_RENDER_TARGET_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_RENDER_TARGET_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_RENDER_TARGET_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_RENDER_TARGET_VIEW_DESC_0 {
    pub Buffer: D3D11_BUFFER_RTV,
    pub Texture1D: D3D11_TEX1D_RTV,
    pub Texture1DArray: D3D11_TEX1D_ARRAY_RTV,
    pub Texture2D: D3D11_TEX2D_RTV,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_RTV,
    pub Texture2DMS: D3D11_TEX2DMS_RTV,
    pub Texture2DMSArray: D3D11_TEX2DMS_ARRAY_RTV,
    pub Texture3D: D3D11_TEX3D_RTV,
}
impl D3D11_RENDER_TARGET_VIEW_DESC_0 {}
impl ::std::default::Default for D3D11_RENDER_TARGET_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_RENDER_TARGET_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_RENDER_TARGET_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_RENDER_TARGET_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_RENDER_TARGET_VIEW_DESC1 {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D11_RTV_DIMENSION,
    pub Anonymous: D3D11_RENDER_TARGET_VIEW_DESC1_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_RENDER_TARGET_VIEW_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_RENDER_TARGET_VIEW_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_RENDER_TARGET_VIEW_DESC1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_RENDER_TARGET_VIEW_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_RENDER_TARGET_VIEW_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_RENDER_TARGET_VIEW_DESC1_0 {
    pub Buffer: D3D11_BUFFER_RTV,
    pub Texture1D: D3D11_TEX1D_RTV,
    pub Texture1DArray: D3D11_TEX1D_ARRAY_RTV,
    pub Texture2D: D3D11_TEX2D_RTV1,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_RTV1,
    pub Texture2DMS: D3D11_TEX2DMS_RTV,
    pub Texture2DMSArray: D3D11_TEX2DMS_ARRAY_RTV,
    pub Texture3D: D3D11_TEX3D_RTV,
}
impl D3D11_RENDER_TARGET_VIEW_DESC1_0 {}
impl ::std::default::Default for D3D11_RENDER_TARGET_VIEW_DESC1_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_RENDER_TARGET_VIEW_DESC1_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_RENDER_TARGET_VIEW_DESC1_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_RENDER_TARGET_VIEW_DESC1_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_REQ_BLEND_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D11_REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP: u32 = 27u32;
pub const D3D11_REQ_CONSTANT_BUFFER_ELEMENT_COUNT: u32 = 4096u32;
pub const D3D11_REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D11_REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 = 32u32;
pub const D3D11_REQ_DRAW_VERTEX_COUNT_2_TO_EXP: u32 = 32u32;
pub const D3D11_REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION: u32 = 16384u32;
pub const D3D11_REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT: u32 = 1024u32;
pub const D3D11_REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT: u32 = 4096u32;
pub const D3D11_REQ_MAXANISOTROPY: u32 = 16u32;
pub const D3D11_REQ_MIP_LEVELS: u32 = 15u32;
pub const D3D11_REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES: u32 = 2048u32;
pub const D3D11_REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D11_REQ_RENDER_TO_BUFFER_WINDOW_WIDTH: u32 = 16384u32;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM: u32 = 128u32;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM: f32 = 0.25f32;
pub const D3D11_REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM: u32 = 2048u32;
pub const D3D11_REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP: u32 = 20u32;
pub const D3D11_REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE: u32 = 4096u32;
pub const D3D11_REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION: u32 = 2048u32;
pub const D3D11_REQ_TEXTURE1D_U_DIMENSION: u32 = 16384u32;
pub const D3D11_REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION: u32 = 2048u32;
pub const D3D11_REQ_TEXTURE2D_U_OR_V_DIMENSION: u32 = 16384u32;
pub const D3D11_REQ_TEXTURE3D_U_V_OR_W_DIMENSION: u32 = 2048u32;
pub const D3D11_REQ_TEXTURECUBE_DIMENSION: u32 = 16384u32;
pub const D3D11_RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL: u32 = 0u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_RESOURCE_DIMENSION(pub i32);
pub const D3D11_RESOURCE_DIMENSION_UNKNOWN: D3D11_RESOURCE_DIMENSION =
    D3D11_RESOURCE_DIMENSION(0i32);
pub const D3D11_RESOURCE_DIMENSION_BUFFER: D3D11_RESOURCE_DIMENSION =
    D3D11_RESOURCE_DIMENSION(1i32);
pub const D3D11_RESOURCE_DIMENSION_TEXTURE1D: D3D11_RESOURCE_DIMENSION =
    D3D11_RESOURCE_DIMENSION(2i32);
pub const D3D11_RESOURCE_DIMENSION_TEXTURE2D: D3D11_RESOURCE_DIMENSION =
    D3D11_RESOURCE_DIMENSION(3i32);
pub const D3D11_RESOURCE_DIMENSION_TEXTURE3D: D3D11_RESOURCE_DIMENSION =
    D3D11_RESOURCE_DIMENSION(4i32);
impl ::std::convert::From<i32> for D3D11_RESOURCE_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_RESOURCE_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_RESOURCE_MISC_FLAG(pub u32);
pub const D3D11_RESOURCE_MISC_GENERATE_MIPS: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(1u32);
pub const D3D11_RESOURCE_MISC_SHARED: D3D11_RESOURCE_MISC_FLAG = D3D11_RESOURCE_MISC_FLAG(2u32);
pub const D3D11_RESOURCE_MISC_TEXTURECUBE: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(4u32);
pub const D3D11_RESOURCE_MISC_DRAWINDIRECT_ARGS: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(16u32);
pub const D3D11_RESOURCE_MISC_BUFFER_ALLOW_RAW_VIEWS: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(32u32);
pub const D3D11_RESOURCE_MISC_BUFFER_STRUCTURED: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(64u32);
pub const D3D11_RESOURCE_MISC_RESOURCE_CLAMP: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(128u32);
pub const D3D11_RESOURCE_MISC_SHARED_KEYEDMUTEX: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(256u32);
pub const D3D11_RESOURCE_MISC_GDI_COMPATIBLE: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(512u32);
pub const D3D11_RESOURCE_MISC_SHARED_NTHANDLE: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(2048u32);
pub const D3D11_RESOURCE_MISC_RESTRICTED_CONTENT: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(4096u32);
pub const D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(8192u32);
pub const D3D11_RESOURCE_MISC_RESTRICT_SHARED_RESOURCE_DRIVER: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(16384u32);
pub const D3D11_RESOURCE_MISC_GUARDED: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(32768u32);
pub const D3D11_RESOURCE_MISC_TILE_POOL: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(131072u32);
pub const D3D11_RESOURCE_MISC_TILED: D3D11_RESOURCE_MISC_FLAG = D3D11_RESOURCE_MISC_FLAG(262144u32);
pub const D3D11_RESOURCE_MISC_HW_PROTECTED: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(524288u32);
pub const D3D11_RESOURCE_MISC_SHARED_DISPLAYABLE: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(1048576u32);
pub const D3D11_RESOURCE_MISC_SHARED_EXCLUSIVE_WRITER: D3D11_RESOURCE_MISC_FLAG =
    D3D11_RESOURCE_MISC_FLAG(2097152u32);
impl ::std::convert::From<u32> for D3D11_RESOURCE_MISC_FLAG {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_RESOURCE_MISC_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D11_RESOURCE_MISC_FLAG {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D11_RESOURCE_MISC_FLAG {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D11_RESOURCE_MISC_FLAG {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D11_RESOURCE_MISC_FLAG {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D11_RESOURCE_MISC_FLAG {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_RLDO_FLAGS(pub i32);
pub const D3D11_RLDO_SUMMARY: D3D11_RLDO_FLAGS = D3D11_RLDO_FLAGS(1i32);
pub const D3D11_RLDO_DETAIL: D3D11_RLDO_FLAGS = D3D11_RLDO_FLAGS(2i32);
pub const D3D11_RLDO_IGNORE_INTERNAL: D3D11_RLDO_FLAGS = D3D11_RLDO_FLAGS(4i32);
impl ::std::convert::From<i32> for D3D11_RLDO_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_RLDO_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_RTV_DIMENSION(pub i32);
pub const D3D11_RTV_DIMENSION_UNKNOWN: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(0i32);
pub const D3D11_RTV_DIMENSION_BUFFER: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(1i32);
pub const D3D11_RTV_DIMENSION_TEXTURE1D: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(2i32);
pub const D3D11_RTV_DIMENSION_TEXTURE1DARRAY: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(3i32);
pub const D3D11_RTV_DIMENSION_TEXTURE2D: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(4i32);
pub const D3D11_RTV_DIMENSION_TEXTURE2DARRAY: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(5i32);
pub const D3D11_RTV_DIMENSION_TEXTURE2DMS: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(6i32);
pub const D3D11_RTV_DIMENSION_TEXTURE2DMSARRAY: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(7i32);
pub const D3D11_RTV_DIMENSION_TEXTURE3D: D3D11_RTV_DIMENSION = D3D11_RTV_DIMENSION(8i32);
impl ::std::convert::From<i32> for D3D11_RTV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_RTV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_SAMPLER_DESC {
    pub Filter: D3D11_FILTER,
    pub AddressU: D3D11_TEXTURE_ADDRESS_MODE,
    pub AddressV: D3D11_TEXTURE_ADDRESS_MODE,
    pub AddressW: D3D11_TEXTURE_ADDRESS_MODE,
    pub MipLODBias: f32,
    pub MaxAnisotropy: u32,
    pub ComparisonFunc: D3D11_COMPARISON_FUNC,
    pub BorderColor: [f32; 4],
    pub MinLOD: f32,
    pub MaxLOD: f32,
}
impl D3D11_SAMPLER_DESC {}
impl ::std::default::Default for D3D11_SAMPLER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_SAMPLER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SAMPLER_DESC")
            .field("Filter", &self.Filter)
            .field("AddressU", &self.AddressU)
            .field("AddressV", &self.AddressV)
            .field("AddressW", &self.AddressW)
            .field("MipLODBias", &self.MipLODBias)
            .field("MaxAnisotropy", &self.MaxAnisotropy)
            .field("ComparisonFunc", &self.ComparisonFunc)
            .field("BorderColor", &self.BorderColor)
            .field("MinLOD", &self.MinLOD)
            .field("MaxLOD", &self.MaxLOD)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_SAMPLER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Filter == other.Filter
            && self.AddressU == other.AddressU
            && self.AddressV == other.AddressV
            && self.AddressW == other.AddressW
            && self.MipLODBias == other.MipLODBias
            && self.MaxAnisotropy == other.MaxAnisotropy
            && self.ComparisonFunc == other.ComparisonFunc
            && self.BorderColor == other.BorderColor
            && self.MinLOD == other.MinLOD
            && self.MaxLOD == other.MaxLOD
    }
}
impl ::std::cmp::Eq for D3D11_SAMPLER_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_SAMPLER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SDK_LAYERS_VERSION: u32 = 1u32;
pub const D3D11_SDK_VERSION: u32 = 7u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_SHADER_BUFFER_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub Type: D3D_CBUFFER_TYPE,
    pub Variables: u32,
    pub Size: u32,
    pub uFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_SHADER_BUFFER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_SHADER_BUFFER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_SHADER_BUFFER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SHADER_BUFFER_DESC")
            .field("Name", &self.Name)
            .field("Type", &self.Type)
            .field("Variables", &self.Variables)
            .field("Size", &self.Size)
            .field("uFlags", &self.uFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_SHADER_BUFFER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name
            && self.Type == other.Type
            && self.Variables == other.Variables
            && self.Size == other.Size
            && self.uFlags == other.uFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_SHADER_BUFFER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_BUFFER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_SHADER_CACHE_SUPPORT_FLAGS(pub i32);
pub const D3D11_SHADER_CACHE_SUPPORT_NONE: D3D11_SHADER_CACHE_SUPPORT_FLAGS =
    D3D11_SHADER_CACHE_SUPPORT_FLAGS(0i32);
pub const D3D11_SHADER_CACHE_SUPPORT_AUTOMATIC_INPROC_CACHE: D3D11_SHADER_CACHE_SUPPORT_FLAGS =
    D3D11_SHADER_CACHE_SUPPORT_FLAGS(1i32);
pub const D3D11_SHADER_CACHE_SUPPORT_AUTOMATIC_DISK_CACHE: D3D11_SHADER_CACHE_SUPPORT_FLAGS =
    D3D11_SHADER_CACHE_SUPPORT_FLAGS(2i32);
impl ::std::convert::From<i32> for D3D11_SHADER_CACHE_SUPPORT_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_CACHE_SUPPORT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_SHADER_DESC {
    pub Version: u32,
    pub Creator: super::super::Foundation::PSTR,
    pub Flags: u32,
    pub ConstantBuffers: u32,
    pub BoundResources: u32,
    pub InputParameters: u32,
    pub OutputParameters: u32,
    pub InstructionCount: u32,
    pub TempRegisterCount: u32,
    pub TempArrayCount: u32,
    pub DefCount: u32,
    pub DclCount: u32,
    pub TextureNormalInstructions: u32,
    pub TextureLoadInstructions: u32,
    pub TextureCompInstructions: u32,
    pub TextureBiasInstructions: u32,
    pub TextureGradientInstructions: u32,
    pub FloatInstructionCount: u32,
    pub IntInstructionCount: u32,
    pub UintInstructionCount: u32,
    pub StaticFlowControlCount: u32,
    pub DynamicFlowControlCount: u32,
    pub MacroInstructionCount: u32,
    pub ArrayInstructionCount: u32,
    pub CutInstructionCount: u32,
    pub EmitInstructionCount: u32,
    pub GSOutputTopology: D3D_PRIMITIVE_TOPOLOGY,
    pub GSMaxOutputVertexCount: u32,
    pub InputPrimitive: D3D_PRIMITIVE,
    pub PatchConstantParameters: u32,
    pub cGSInstanceCount: u32,
    pub cControlPoints: u32,
    pub HSOutputPrimitive: D3D_TESSELLATOR_OUTPUT_PRIMITIVE,
    pub HSPartitioning: D3D_TESSELLATOR_PARTITIONING,
    pub TessellatorDomain: D3D_TESSELLATOR_DOMAIN,
    pub cBarrierInstructions: u32,
    pub cInterlockedInstructions: u32,
    pub cTextureStoreInstructions: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_SHADER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_SHADER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_SHADER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SHADER_DESC")
            .field("Version", &self.Version)
            .field("Creator", &self.Creator)
            .field("Flags", &self.Flags)
            .field("ConstantBuffers", &self.ConstantBuffers)
            .field("BoundResources", &self.BoundResources)
            .field("InputParameters", &self.InputParameters)
            .field("OutputParameters", &self.OutputParameters)
            .field("InstructionCount", &self.InstructionCount)
            .field("TempRegisterCount", &self.TempRegisterCount)
            .field("TempArrayCount", &self.TempArrayCount)
            .field("DefCount", &self.DefCount)
            .field("DclCount", &self.DclCount)
            .field("TextureNormalInstructions", &self.TextureNormalInstructions)
            .field("TextureLoadInstructions", &self.TextureLoadInstructions)
            .field("TextureCompInstructions", &self.TextureCompInstructions)
            .field("TextureBiasInstructions", &self.TextureBiasInstructions)
            .field(
                "TextureGradientInstructions",
                &self.TextureGradientInstructions,
            )
            .field("FloatInstructionCount", &self.FloatInstructionCount)
            .field("IntInstructionCount", &self.IntInstructionCount)
            .field("UintInstructionCount", &self.UintInstructionCount)
            .field("StaticFlowControlCount", &self.StaticFlowControlCount)
            .field("DynamicFlowControlCount", &self.DynamicFlowControlCount)
            .field("MacroInstructionCount", &self.MacroInstructionCount)
            .field("ArrayInstructionCount", &self.ArrayInstructionCount)
            .field("CutInstructionCount", &self.CutInstructionCount)
            .field("EmitInstructionCount", &self.EmitInstructionCount)
            .field("GSOutputTopology", &self.GSOutputTopology)
            .field("GSMaxOutputVertexCount", &self.GSMaxOutputVertexCount)
            .field("InputPrimitive", &self.InputPrimitive)
            .field("PatchConstantParameters", &self.PatchConstantParameters)
            .field("cGSInstanceCount", &self.cGSInstanceCount)
            .field("cControlPoints", &self.cControlPoints)
            .field("HSOutputPrimitive", &self.HSOutputPrimitive)
            .field("HSPartitioning", &self.HSPartitioning)
            .field("TessellatorDomain", &self.TessellatorDomain)
            .field("cBarrierInstructions", &self.cBarrierInstructions)
            .field("cInterlockedInstructions", &self.cInterlockedInstructions)
            .field("cTextureStoreInstructions", &self.cTextureStoreInstructions)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_SHADER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Version == other.Version
            && self.Creator == other.Creator
            && self.Flags == other.Flags
            && self.ConstantBuffers == other.ConstantBuffers
            && self.BoundResources == other.BoundResources
            && self.InputParameters == other.InputParameters
            && self.OutputParameters == other.OutputParameters
            && self.InstructionCount == other.InstructionCount
            && self.TempRegisterCount == other.TempRegisterCount
            && self.TempArrayCount == other.TempArrayCount
            && self.DefCount == other.DefCount
            && self.DclCount == other.DclCount
            && self.TextureNormalInstructions == other.TextureNormalInstructions
            && self.TextureLoadInstructions == other.TextureLoadInstructions
            && self.TextureCompInstructions == other.TextureCompInstructions
            && self.TextureBiasInstructions == other.TextureBiasInstructions
            && self.TextureGradientInstructions == other.TextureGradientInstructions
            && self.FloatInstructionCount == other.FloatInstructionCount
            && self.IntInstructionCount == other.IntInstructionCount
            && self.UintInstructionCount == other.UintInstructionCount
            && self.StaticFlowControlCount == other.StaticFlowControlCount
            && self.DynamicFlowControlCount == other.DynamicFlowControlCount
            && self.MacroInstructionCount == other.MacroInstructionCount
            && self.ArrayInstructionCount == other.ArrayInstructionCount
            && self.CutInstructionCount == other.CutInstructionCount
            && self.EmitInstructionCount == other.EmitInstructionCount
            && self.GSOutputTopology == other.GSOutputTopology
            && self.GSMaxOutputVertexCount == other.GSMaxOutputVertexCount
            && self.InputPrimitive == other.InputPrimitive
            && self.PatchConstantParameters == other.PatchConstantParameters
            && self.cGSInstanceCount == other.cGSInstanceCount
            && self.cControlPoints == other.cControlPoints
            && self.HSOutputPrimitive == other.HSOutputPrimitive
            && self.HSPartitioning == other.HSPartitioning
            && self.TessellatorDomain == other.TessellatorDomain
            && self.cBarrierInstructions == other.cBarrierInstructions
            && self.cInterlockedInstructions == other.cInterlockedInstructions
            && self.cTextureStoreInstructions == other.cTextureStoreInstructions
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_SHADER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_SHADER_INPUT_BIND_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub Type: D3D_SHADER_INPUT_TYPE,
    pub BindPoint: u32,
    pub BindCount: u32,
    pub uFlags: u32,
    pub ReturnType: D3D_RESOURCE_RETURN_TYPE,
    pub Dimension: D3D_SRV_DIMENSION,
    pub NumSamples: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_SHADER_INPUT_BIND_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_SHADER_INPUT_BIND_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_SHADER_INPUT_BIND_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SHADER_INPUT_BIND_DESC")
            .field("Name", &self.Name)
            .field("Type", &self.Type)
            .field("BindPoint", &self.BindPoint)
            .field("BindCount", &self.BindCount)
            .field("uFlags", &self.uFlags)
            .field("ReturnType", &self.ReturnType)
            .field("Dimension", &self.Dimension)
            .field("NumSamples", &self.NumSamples)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_SHADER_INPUT_BIND_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name
            && self.Type == other.Type
            && self.BindPoint == other.BindPoint
            && self.BindCount == other.BindCount
            && self.uFlags == other.uFlags
            && self.ReturnType == other.ReturnType
            && self.Dimension == other.Dimension
            && self.NumSamples == other.NumSamples
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_SHADER_INPUT_BIND_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_INPUT_BIND_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SHADER_MAJOR_VERSION: u32 = 5u32;
pub const D3D11_SHADER_MAX_INSTANCES: u32 = 65535u32;
pub const D3D11_SHADER_MAX_INTERFACES: u32 = 253u32;
pub const D3D11_SHADER_MAX_INTERFACE_CALL_SITES: u32 = 4096u32;
pub const D3D11_SHADER_MAX_TYPES: u32 = 65535u32;
pub const D3D11_SHADER_MINOR_VERSION: u32 = 0u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_SHADER_MIN_PRECISION_SUPPORT(pub i32);
pub const D3D11_SHADER_MIN_PRECISION_10_BIT: D3D11_SHADER_MIN_PRECISION_SUPPORT =
    D3D11_SHADER_MIN_PRECISION_SUPPORT(1i32);
pub const D3D11_SHADER_MIN_PRECISION_16_BIT: D3D11_SHADER_MIN_PRECISION_SUPPORT =
    D3D11_SHADER_MIN_PRECISION_SUPPORT(2i32);
impl ::std::convert::From<i32> for D3D11_SHADER_MIN_PRECISION_SUPPORT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_MIN_PRECISION_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_SHADER_RESOURCE_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D_SRV_DIMENSION,
    pub Anonymous: D3D11_SHADER_RESOURCE_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_SHADER_RESOURCE_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_SHADER_RESOURCE_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_SHADER_RESOURCE_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_SHADER_RESOURCE_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_RESOURCE_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_SHADER_RESOURCE_VIEW_DESC_0 {
    pub Buffer: D3D11_BUFFER_SRV,
    pub Texture1D: D3D11_TEX1D_SRV,
    pub Texture1DArray: D3D11_TEX1D_ARRAY_SRV,
    pub Texture2D: D3D11_TEX2D_SRV,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_SRV,
    pub Texture2DMS: D3D11_TEX2DMS_SRV,
    pub Texture2DMSArray: D3D11_TEX2DMS_ARRAY_SRV,
    pub Texture3D: D3D11_TEX3D_SRV,
    pub TextureCube: D3D11_TEXCUBE_SRV,
    pub TextureCubeArray: D3D11_TEXCUBE_ARRAY_SRV,
    pub BufferEx: D3D11_BUFFEREX_SRV,
}
impl D3D11_SHADER_RESOURCE_VIEW_DESC_0 {}
impl ::std::default::Default for D3D11_SHADER_RESOURCE_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_SHADER_RESOURCE_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_SHADER_RESOURCE_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_RESOURCE_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_SHADER_RESOURCE_VIEW_DESC1 {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D_SRV_DIMENSION,
    pub Anonymous: D3D11_SHADER_RESOURCE_VIEW_DESC1_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_SHADER_RESOURCE_VIEW_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_SHADER_RESOURCE_VIEW_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_SHADER_RESOURCE_VIEW_DESC1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_SHADER_RESOURCE_VIEW_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_RESOURCE_VIEW_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_SHADER_RESOURCE_VIEW_DESC1_0 {
    pub Buffer: D3D11_BUFFER_SRV,
    pub Texture1D: D3D11_TEX1D_SRV,
    pub Texture1DArray: D3D11_TEX1D_ARRAY_SRV,
    pub Texture2D: D3D11_TEX2D_SRV1,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_SRV1,
    pub Texture2DMS: D3D11_TEX2DMS_SRV,
    pub Texture2DMSArray: D3D11_TEX2DMS_ARRAY_SRV,
    pub Texture3D: D3D11_TEX3D_SRV,
    pub TextureCube: D3D11_TEXCUBE_SRV,
    pub TextureCubeArray: D3D11_TEXCUBE_ARRAY_SRV,
    pub BufferEx: D3D11_BUFFEREX_SRV,
}
impl D3D11_SHADER_RESOURCE_VIEW_DESC1_0 {}
impl ::std::default::Default for D3D11_SHADER_RESOURCE_VIEW_DESC1_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_SHADER_RESOURCE_VIEW_DESC1_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_SHADER_RESOURCE_VIEW_DESC1_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_RESOURCE_VIEW_DESC1_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_SHADER_TRACE_DESC {
    pub Type: D3D11_SHADER_TYPE,
    pub Flags: u32,
    pub Anonymous: D3D11_SHADER_TRACE_DESC_0,
}
impl D3D11_SHADER_TRACE_DESC {}
impl ::std::default::Default for D3D11_SHADER_TRACE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_SHADER_TRACE_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_SHADER_TRACE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_TRACE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_SHADER_TRACE_DESC_0 {
    pub VertexShaderTraceDesc: D3D11_VERTEX_SHADER_TRACE_DESC,
    pub HullShaderTraceDesc: D3D11_HULL_SHADER_TRACE_DESC,
    pub DomainShaderTraceDesc: D3D11_DOMAIN_SHADER_TRACE_DESC,
    pub GeometryShaderTraceDesc: D3D11_GEOMETRY_SHADER_TRACE_DESC,
    pub PixelShaderTraceDesc: D3D11_PIXEL_SHADER_TRACE_DESC,
    pub ComputeShaderTraceDesc: D3D11_COMPUTE_SHADER_TRACE_DESC,
}
impl D3D11_SHADER_TRACE_DESC_0 {}
impl ::std::default::Default for D3D11_SHADER_TRACE_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_SHADER_TRACE_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_SHADER_TRACE_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_TRACE_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SHADER_TRACE_FLAG_RECORD_REGISTER_READS: u32 = 2u32;
pub const D3D11_SHADER_TRACE_FLAG_RECORD_REGISTER_WRITES: u32 = 1u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_SHADER_TRACKING_OPTIONS(pub i32);
pub const D3D11_SHADER_TRACKING_OPTION_IGNORE: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(0i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_UNINITIALIZED: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(1i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_RAW: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(2i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_WAR: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(4i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_WAW: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(8i32);
pub const D3D11_SHADER_TRACKING_OPTION_ALLOW_SAME: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(16i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(32i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_RAW_ACROSS_THREADGROUPS:
    D3D11_SHADER_TRACKING_OPTIONS = D3D11_SHADER_TRACKING_OPTIONS(64i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_WAR_ACROSS_THREADGROUPS:
    D3D11_SHADER_TRACKING_OPTIONS = D3D11_SHADER_TRACKING_OPTIONS(128i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_WAW_ACROSS_THREADGROUPS:
    D3D11_SHADER_TRACKING_OPTIONS = D3D11_SHADER_TRACKING_OPTIONS(256i32);
pub const D3D11_SHADER_TRACKING_OPTION_TRACK_ATOMIC_CONSISTENCY_ACROSS_THREADGROUPS:
    D3D11_SHADER_TRACKING_OPTIONS = D3D11_SHADER_TRACKING_OPTIONS(512i32);
pub const D3D11_SHADER_TRACKING_OPTION_UAV_SPECIFIC_FLAGS: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(960i32);
pub const D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(1006i32);
pub const D3D11_SHADER_TRACKING_OPTION_ALL_HAZARDS_ALLOWING_SAME: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(1022i32);
pub const D3D11_SHADER_TRACKING_OPTION_ALL_OPTIONS: D3D11_SHADER_TRACKING_OPTIONS =
    D3D11_SHADER_TRACKING_OPTIONS(1023i32);
impl ::std::convert::From<i32> for D3D11_SHADER_TRACKING_OPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_TRACKING_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_SHADER_TRACKING_RESOURCE_TYPE(pub i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_NONE: D3D11_SHADER_TRACKING_RESOURCE_TYPE =
    D3D11_SHADER_TRACKING_RESOURCE_TYPE(0i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_UAV_DEVICEMEMORY:
    D3D11_SHADER_TRACKING_RESOURCE_TYPE = D3D11_SHADER_TRACKING_RESOURCE_TYPE(1i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_NON_UAV_DEVICEMEMORY:
    D3D11_SHADER_TRACKING_RESOURCE_TYPE = D3D11_SHADER_TRACKING_RESOURCE_TYPE(2i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL_DEVICEMEMORY:
    D3D11_SHADER_TRACKING_RESOURCE_TYPE = D3D11_SHADER_TRACKING_RESOURCE_TYPE(3i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_GROUPSHARED_MEMORY:
    D3D11_SHADER_TRACKING_RESOURCE_TYPE = D3D11_SHADER_TRACKING_RESOURCE_TYPE(4i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL_SHARED_MEMORY:
    D3D11_SHADER_TRACKING_RESOURCE_TYPE = D3D11_SHADER_TRACKING_RESOURCE_TYPE(5i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_GROUPSHARED_NON_UAV:
    D3D11_SHADER_TRACKING_RESOURCE_TYPE = D3D11_SHADER_TRACKING_RESOURCE_TYPE(6i32);
pub const D3D11_SHADER_TRACKING_RESOURCE_TYPE_ALL: D3D11_SHADER_TRACKING_RESOURCE_TYPE =
    D3D11_SHADER_TRACKING_RESOURCE_TYPE(7i32);
impl ::std::convert::From<i32> for D3D11_SHADER_TRACKING_RESOURCE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_TRACKING_RESOURCE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_SHADER_TYPE(pub i32);
pub const D3D11_VERTEX_SHADER: D3D11_SHADER_TYPE = D3D11_SHADER_TYPE(1i32);
pub const D3D11_HULL_SHADER: D3D11_SHADER_TYPE = D3D11_SHADER_TYPE(2i32);
pub const D3D11_DOMAIN_SHADER: D3D11_SHADER_TYPE = D3D11_SHADER_TYPE(3i32);
pub const D3D11_GEOMETRY_SHADER: D3D11_SHADER_TYPE = D3D11_SHADER_TYPE(4i32);
pub const D3D11_PIXEL_SHADER: D3D11_SHADER_TYPE = D3D11_SHADER_TYPE(5i32);
pub const D3D11_COMPUTE_SHADER: D3D11_SHADER_TYPE = D3D11_SHADER_TYPE(6i32);
impl ::std::convert::From<i32> for D3D11_SHADER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_SHADER_TYPE_DESC {
    pub Class: D3D_SHADER_VARIABLE_CLASS,
    pub Type: D3D_SHADER_VARIABLE_TYPE,
    pub Rows: u32,
    pub Columns: u32,
    pub Elements: u32,
    pub Members: u32,
    pub Offset: u32,
    pub Name: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_SHADER_TYPE_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_SHADER_TYPE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_SHADER_TYPE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SHADER_TYPE_DESC")
            .field("Class", &self.Class)
            .field("Type", &self.Type)
            .field("Rows", &self.Rows)
            .field("Columns", &self.Columns)
            .field("Elements", &self.Elements)
            .field("Members", &self.Members)
            .field("Offset", &self.Offset)
            .field("Name", &self.Name)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_SHADER_TYPE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Class == other.Class
            && self.Type == other.Type
            && self.Rows == other.Rows
            && self.Columns == other.Columns
            && self.Elements == other.Elements
            && self.Members == other.Members
            && self.Offset == other.Offset
            && self.Name == other.Name
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_SHADER_TYPE_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_TYPE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_SHADER_VARIABLE_DESC {
    pub Name: super::super::Foundation::PSTR,
    pub StartOffset: u32,
    pub Size: u32,
    pub uFlags: u32,
    pub DefaultValue: *mut ::std::ffi::c_void,
    pub StartTexture: u32,
    pub TextureSize: u32,
    pub StartSampler: u32,
    pub SamplerSize: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_SHADER_VARIABLE_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_SHADER_VARIABLE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_SHADER_VARIABLE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SHADER_VARIABLE_DESC")
            .field("Name", &self.Name)
            .field("StartOffset", &self.StartOffset)
            .field("Size", &self.Size)
            .field("uFlags", &self.uFlags)
            .field("DefaultValue", &self.DefaultValue)
            .field("StartTexture", &self.StartTexture)
            .field("TextureSize", &self.TextureSize)
            .field("StartSampler", &self.StartSampler)
            .field("SamplerSize", &self.SamplerSize)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_SHADER_VARIABLE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name
            && self.StartOffset == other.StartOffset
            && self.Size == other.Size
            && self.uFlags == other.uFlags
            && self.DefaultValue == other.DefaultValue
            && self.StartTexture == other.StartTexture
            && self.TextureSize == other.TextureSize
            && self.StartSampler == other.StartSampler
            && self.SamplerSize == other.SamplerSize
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_SHADER_VARIABLE_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_VARIABLE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_SHADER_VERSION_TYPE(pub i32);
pub const D3D11_SHVER_PIXEL_SHADER: D3D11_SHADER_VERSION_TYPE = D3D11_SHADER_VERSION_TYPE(0i32);
pub const D3D11_SHVER_VERTEX_SHADER: D3D11_SHADER_VERSION_TYPE = D3D11_SHADER_VERSION_TYPE(1i32);
pub const D3D11_SHVER_GEOMETRY_SHADER: D3D11_SHADER_VERSION_TYPE = D3D11_SHADER_VERSION_TYPE(2i32);
pub const D3D11_SHVER_HULL_SHADER: D3D11_SHADER_VERSION_TYPE = D3D11_SHADER_VERSION_TYPE(3i32);
pub const D3D11_SHVER_DOMAIN_SHADER: D3D11_SHADER_VERSION_TYPE = D3D11_SHADER_VERSION_TYPE(4i32);
pub const D3D11_SHVER_COMPUTE_SHADER: D3D11_SHADER_VERSION_TYPE = D3D11_SHADER_VERSION_TYPE(5i32);
pub const D3D11_SHVER_RESERVED0: D3D11_SHADER_VERSION_TYPE = D3D11_SHADER_VERSION_TYPE(65520i32);
impl ::std::convert::From<i32> for D3D11_SHADER_VERSION_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_SHADER_VERSION_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_SHARED_RESOURCE_TIER(pub i32);
pub const D3D11_SHARED_RESOURCE_TIER_0: D3D11_SHARED_RESOURCE_TIER =
    D3D11_SHARED_RESOURCE_TIER(0i32);
pub const D3D11_SHARED_RESOURCE_TIER_1: D3D11_SHARED_RESOURCE_TIER =
    D3D11_SHARED_RESOURCE_TIER(1i32);
pub const D3D11_SHARED_RESOURCE_TIER_2: D3D11_SHARED_RESOURCE_TIER =
    D3D11_SHARED_RESOURCE_TIER(2i32);
pub const D3D11_SHARED_RESOURCE_TIER_3: D3D11_SHARED_RESOURCE_TIER =
    D3D11_SHARED_RESOURCE_TIER(3i32);
impl ::std::convert::From<i32> for D3D11_SHARED_RESOURCE_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_SHARED_RESOURCE_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SHIFT_INSTRUCTION_PAD_VALUE: u32 = 0u32;
pub const D3D11_SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT: u32 = 5u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_SIGNATURE_PARAMETER_DESC {
    pub SemanticName: super::super::Foundation::PSTR,
    pub SemanticIndex: u32,
    pub Register: u32,
    pub SystemValueType: D3D_NAME,
    pub ComponentType: D3D_REGISTER_COMPONENT_TYPE,
    pub Mask: u8,
    pub ReadWriteMask: u8,
    pub Stream: u32,
    pub MinPrecision: D3D_MIN_PRECISION,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_SIGNATURE_PARAMETER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_SIGNATURE_PARAMETER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_SIGNATURE_PARAMETER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SIGNATURE_PARAMETER_DESC")
            .field("SemanticName", &self.SemanticName)
            .field("SemanticIndex", &self.SemanticIndex)
            .field("Register", &self.Register)
            .field("SystemValueType", &self.SystemValueType)
            .field("ComponentType", &self.ComponentType)
            .field("Mask", &self.Mask)
            .field("ReadWriteMask", &self.ReadWriteMask)
            .field("Stream", &self.Stream)
            .field("MinPrecision", &self.MinPrecision)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_SIGNATURE_PARAMETER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.SemanticName == other.SemanticName
            && self.SemanticIndex == other.SemanticIndex
            && self.Register == other.Register
            && self.SystemValueType == other.SystemValueType
            && self.ComponentType == other.ComponentType
            && self.Mask == other.Mask
            && self.ReadWriteMask == other.ReadWriteMask
            && self.Stream == other.Stream
            && self.MinPrecision == other.MinPrecision
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_SIGNATURE_PARAMETER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_SIGNATURE_PARAMETER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SIMULTANEOUS_RENDER_TARGET_COUNT: u32 = 8u32;
pub const D3D11_SO_BUFFER_MAX_STRIDE_IN_BYTES: u32 = 2048u32;
pub const D3D11_SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES: u32 = 512u32;
pub const D3D11_SO_BUFFER_SLOT_COUNT: u32 = 4u32;
pub const D3D11_SO_DDI_REGISTER_INDEX_DENOTING_GAP: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_SO_DECLARATION_ENTRY {
    pub Stream: u32,
    pub SemanticName: super::super::Foundation::PSTR,
    pub SemanticIndex: u32,
    pub StartComponent: u8,
    pub ComponentCount: u8,
    pub OutputSlot: u8,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_SO_DECLARATION_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_SO_DECLARATION_ENTRY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_SO_DECLARATION_ENTRY {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SO_DECLARATION_ENTRY")
            .field("Stream", &self.Stream)
            .field("SemanticName", &self.SemanticName)
            .field("SemanticIndex", &self.SemanticIndex)
            .field("StartComponent", &self.StartComponent)
            .field("ComponentCount", &self.ComponentCount)
            .field("OutputSlot", &self.OutputSlot)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_SO_DECLARATION_ENTRY {
    fn eq(&self, other: &Self) -> bool {
        self.Stream == other.Stream
            && self.SemanticName == other.SemanticName
            && self.SemanticIndex == other.SemanticIndex
            && self.StartComponent == other.StartComponent
            && self.ComponentCount == other.ComponentCount
            && self.OutputSlot == other.OutputSlot
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_SO_DECLARATION_ENTRY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_SO_DECLARATION_ENTRY {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SO_NO_RASTERIZED_STREAM: u32 = 4294967295u32;
pub const D3D11_SO_OUTPUT_COMPONENT_COUNT: u32 = 128u32;
pub const D3D11_SO_STREAM_COUNT: u32 = 4u32;
pub const D3D11_SPEC_DATE_DAY: u32 = 16u32;
pub const D3D11_SPEC_DATE_MONTH: u32 = 5u32;
pub const D3D11_SPEC_DATE_YEAR: u32 = 2011u32;
pub const D3D11_SPEC_VERSION: f64 = 1.07f64;
pub const D3D11_SRGB_GAMMA: f32 = 2.2f32;
pub const D3D11_SRGB_TO_FLOAT_DENOMINATOR_1: f32 = 12.92f32;
pub const D3D11_SRGB_TO_FLOAT_DENOMINATOR_2: f32 = 1.055f32;
pub const D3D11_SRGB_TO_FLOAT_EXPONENT: f32 = 2.4f32;
pub const D3D11_SRGB_TO_FLOAT_OFFSET: f32 = 0.055f32;
pub const D3D11_SRGB_TO_FLOAT_THRESHOLD: f32 = 0.04045f32;
pub const D3D11_SRGB_TO_FLOAT_TOLERANCE_IN_ULP: f32 = 0.5f32;
pub const D3D11_STANDARD_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_STANDARD_COMPONENT_BIT_COUNT_DOUBLED: u32 = 64u32;
pub const D3D11_STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS(pub i32);
pub const D3D11_STANDARD_MULTISAMPLE_PATTERN: D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS =
    D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS(-1i32);
pub const D3D11_CENTER_MULTISAMPLE_PATTERN: D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS =
    D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS(-2i32);
impl ::std::convert::From<i32> for D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_STANDARD_MULTISAMPLE_QUALITY_LEVELS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_STANDARD_PIXEL_COMPONENT_COUNT: u32 = 128u32;
pub const D3D11_STANDARD_PIXEL_ELEMENT_COUNT: u32 = 32u32;
pub const D3D11_STANDARD_VECTOR_SIZE: u32 = 4u32;
pub const D3D11_STANDARD_VERTEX_ELEMENT_COUNT: u32 = 32u32;
pub const D3D11_STANDARD_VERTEX_TOTAL_COMPONENT_COUNT: u32 = 64u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_STENCIL_OP(pub i32);
pub const D3D11_STENCIL_OP_KEEP: D3D11_STENCIL_OP = D3D11_STENCIL_OP(1i32);
pub const D3D11_STENCIL_OP_ZERO: D3D11_STENCIL_OP = D3D11_STENCIL_OP(2i32);
pub const D3D11_STENCIL_OP_REPLACE: D3D11_STENCIL_OP = D3D11_STENCIL_OP(3i32);
pub const D3D11_STENCIL_OP_INCR_SAT: D3D11_STENCIL_OP = D3D11_STENCIL_OP(4i32);
pub const D3D11_STENCIL_OP_DECR_SAT: D3D11_STENCIL_OP = D3D11_STENCIL_OP(5i32);
pub const D3D11_STENCIL_OP_INVERT: D3D11_STENCIL_OP = D3D11_STENCIL_OP(6i32);
pub const D3D11_STENCIL_OP_INCR: D3D11_STENCIL_OP = D3D11_STENCIL_OP(7i32);
pub const D3D11_STENCIL_OP_DECR: D3D11_STENCIL_OP = D3D11_STENCIL_OP(8i32);
impl ::std::convert::From<i32> for D3D11_STENCIL_OP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_STENCIL_OP {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SUBPIXEL_FRACTIONAL_BIT_COUNT: u32 = 8u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_SUBRESOURCE_DATA {
    pub pSysMem: *mut ::std::ffi::c_void,
    pub SysMemPitch: u32,
    pub SysMemSlicePitch: u32,
}
impl D3D11_SUBRESOURCE_DATA {}
impl ::std::default::Default for D3D11_SUBRESOURCE_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_SUBRESOURCE_DATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SUBRESOURCE_DATA")
            .field("pSysMem", &self.pSysMem)
            .field("SysMemPitch", &self.SysMemPitch)
            .field("SysMemSlicePitch", &self.SysMemSlicePitch)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_SUBRESOURCE_DATA {
    fn eq(&self, other: &Self) -> bool {
        self.pSysMem == other.pSysMem
            && self.SysMemPitch == other.SysMemPitch
            && self.SysMemSlicePitch == other.SysMemSlicePitch
    }
}
impl ::std::cmp::Eq for D3D11_SUBRESOURCE_DATA {}
unsafe impl ::windows::runtime::Abi for D3D11_SUBRESOURCE_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_SUBRESOURCE_TILING {
    pub WidthInTiles: u32,
    pub HeightInTiles: u16,
    pub DepthInTiles: u16,
    pub StartTileIndexInOverallResource: u32,
}
impl D3D11_SUBRESOURCE_TILING {}
impl ::std::default::Default for D3D11_SUBRESOURCE_TILING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_SUBRESOURCE_TILING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_SUBRESOURCE_TILING")
            .field("WidthInTiles", &self.WidthInTiles)
            .field("HeightInTiles", &self.HeightInTiles)
            .field("DepthInTiles", &self.DepthInTiles)
            .field(
                "StartTileIndexInOverallResource",
                &self.StartTileIndexInOverallResource,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_SUBRESOURCE_TILING {
    fn eq(&self, other: &Self) -> bool {
        self.WidthInTiles == other.WidthInTiles
            && self.HeightInTiles == other.HeightInTiles
            && self.DepthInTiles == other.DepthInTiles
            && self.StartTileIndexInOverallResource == other.StartTileIndexInOverallResource
    }
}
impl ::std::cmp::Eq for D3D11_SUBRESOURCE_TILING {}
unsafe impl ::windows::runtime::Abi for D3D11_SUBRESOURCE_TILING {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_SUBTEXEL_FRACTIONAL_BIT_COUNT: u32 = 8u32;
pub const D3D11_TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR: u32 = 64u32;
pub const D3D11_TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 = 64u32;
pub const D3D11_TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR: u32 = 63u32;
pub const D3D11_TESSELLATOR_MAX_TESSELLATION_FACTOR: u32 = 64u32;
pub const D3D11_TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR: u32 = 2u32;
pub const D3D11_TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR: u32 = 1u32;
pub const D3D11_TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_ARRAY_DSV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX1D_ARRAY_DSV {}
impl ::std::default::Default for D3D11_TEX1D_ARRAY_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_ARRAY_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_ARRAY_DSV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_ARRAY_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_ARRAY_DSV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_ARRAY_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_ARRAY_RTV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX1D_ARRAY_RTV {}
impl ::std::default::Default for D3D11_TEX1D_ARRAY_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_ARRAY_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_ARRAY_RTV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_ARRAY_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_ARRAY_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_ARRAY_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_ARRAY_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX1D_ARRAY_SRV {}
impl ::std::default::Default for D3D11_TEX1D_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_ARRAY_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip
            && self.MipLevels == other.MipLevels
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_ARRAY_UAV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX1D_ARRAY_UAV {}
impl ::std::default::Default for D3D11_TEX1D_ARRAY_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_ARRAY_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_ARRAY_UAV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_ARRAY_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_ARRAY_UAV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_ARRAY_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_DSV {
    pub MipSlice: u32,
}
impl D3D11_TEX1D_DSV {}
impl ::std::default::Default for D3D11_TEX1D_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_DSV")
            .field("MipSlice", &self.MipSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_DSV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_RTV {
    pub MipSlice: u32,
}
impl D3D11_TEX1D_RTV {}
impl ::std::default::Default for D3D11_TEX1D_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_RTV")
            .field("MipSlice", &self.MipSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
}
impl D3D11_TEX1D_SRV {}
impl ::std::default::Default for D3D11_TEX1D_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX1D_UAV {
    pub MipSlice: u32,
}
impl D3D11_TEX1D_UAV {}
impl ::std::default::Default for D3D11_TEX1D_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX1D_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX1D_UAV")
            .field("MipSlice", &self.MipSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX1D_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX1D_UAV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX1D_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2DMS_ARRAY_DSV {
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2DMS_ARRAY_DSV {}
impl ::std::default::Default for D3D11_TEX2DMS_ARRAY_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2DMS_ARRAY_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2DMS_ARRAY_DSV")
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2DMS_ARRAY_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2DMS_ARRAY_DSV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2DMS_ARRAY_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2DMS_ARRAY_RTV {
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2DMS_ARRAY_RTV {}
impl ::std::default::Default for D3D11_TEX2DMS_ARRAY_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2DMS_ARRAY_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2DMS_ARRAY_RTV")
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2DMS_ARRAY_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2DMS_ARRAY_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2DMS_ARRAY_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2DMS_ARRAY_SRV {
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2DMS_ARRAY_SRV {}
impl ::std::default::Default for D3D11_TEX2DMS_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2DMS_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2DMS_ARRAY_SRV")
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2DMS_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.FirstArraySlice == other.FirstArraySlice && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2DMS_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2DMS_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2DMS_DSV {
    pub UnusedField_NothingToDefine: u32,
}
impl D3D11_TEX2DMS_DSV {}
impl ::std::default::Default for D3D11_TEX2DMS_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2DMS_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2DMS_DSV")
            .field(
                "UnusedField_NothingToDefine",
                &self.UnusedField_NothingToDefine,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2DMS_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.UnusedField_NothingToDefine == other.UnusedField_NothingToDefine
    }
}
impl ::std::cmp::Eq for D3D11_TEX2DMS_DSV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2DMS_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2DMS_RTV {
    pub UnusedField_NothingToDefine: u32,
}
impl D3D11_TEX2DMS_RTV {}
impl ::std::default::Default for D3D11_TEX2DMS_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2DMS_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2DMS_RTV")
            .field(
                "UnusedField_NothingToDefine",
                &self.UnusedField_NothingToDefine,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2DMS_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.UnusedField_NothingToDefine == other.UnusedField_NothingToDefine
    }
}
impl ::std::cmp::Eq for D3D11_TEX2DMS_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2DMS_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2DMS_SRV {
    pub UnusedField_NothingToDefine: u32,
}
impl D3D11_TEX2DMS_SRV {}
impl ::std::default::Default for D3D11_TEX2DMS_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2DMS_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2DMS_SRV")
            .field(
                "UnusedField_NothingToDefine",
                &self.UnusedField_NothingToDefine,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2DMS_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.UnusedField_NothingToDefine == other.UnusedField_NothingToDefine
    }
}
impl ::std::cmp::Eq for D3D11_TEX2DMS_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2DMS_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_DSV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2D_ARRAY_DSV {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_DSV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_DSV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_RTV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2D_ARRAY_RTV {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_RTV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_RTV1 {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
    pub PlaneSlice: u32,
}
impl D3D11_TEX2D_ARRAY_RTV1 {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_RTV1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_RTV1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_RTV1")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .field("PlaneSlice", &self.PlaneSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_RTV1 {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
            && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_RTV1 {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_RTV1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2D_ARRAY_SRV {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip
            && self.MipLevels == other.MipLevels
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_SRV1 {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
    pub PlaneSlice: u32,
}
impl D3D11_TEX2D_ARRAY_SRV1 {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_SRV1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_SRV1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_SRV1")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .field("PlaneSlice", &self.PlaneSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_SRV1 {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip
            && self.MipLevels == other.MipLevels
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
            && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_SRV1 {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_SRV1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_UAV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2D_ARRAY_UAV {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_UAV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_UAV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_UAV1 {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
    pub PlaneSlice: u32,
}
impl D3D11_TEX2D_ARRAY_UAV1 {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_UAV1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_UAV1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_UAV1")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .field("PlaneSlice", &self.PlaneSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_UAV1 {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
            && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_UAV1 {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_UAV1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_ARRAY_VPOV {
    pub MipSlice: u32,
    pub FirstArraySlice: u32,
    pub ArraySize: u32,
}
impl D3D11_TEX2D_ARRAY_VPOV {}
impl ::std::default::Default for D3D11_TEX2D_ARRAY_VPOV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_ARRAY_VPOV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_ARRAY_VPOV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstArraySlice", &self.FirstArraySlice)
            .field("ArraySize", &self.ArraySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_ARRAY_VPOV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstArraySlice == other.FirstArraySlice
            && self.ArraySize == other.ArraySize
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_ARRAY_VPOV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_ARRAY_VPOV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_DSV {
    pub MipSlice: u32,
}
impl D3D11_TEX2D_DSV {}
impl ::std::default::Default for D3D11_TEX2D_DSV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_DSV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_DSV")
            .field("MipSlice", &self.MipSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_DSV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_DSV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_DSV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_RTV {
    pub MipSlice: u32,
}
impl D3D11_TEX2D_RTV {}
impl ::std::default::Default for D3D11_TEX2D_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_RTV")
            .field("MipSlice", &self.MipSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_RTV1 {
    pub MipSlice: u32,
    pub PlaneSlice: u32,
}
impl D3D11_TEX2D_RTV1 {}
impl ::std::default::Default for D3D11_TEX2D_RTV1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_RTV1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_RTV1")
            .field("MipSlice", &self.MipSlice)
            .field("PlaneSlice", &self.PlaneSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_RTV1 {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_RTV1 {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_RTV1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
}
impl D3D11_TEX2D_SRV {}
impl ::std::default::Default for D3D11_TEX2D_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_SRV1 {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub PlaneSlice: u32,
}
impl D3D11_TEX2D_SRV1 {}
impl ::std::default::Default for D3D11_TEX2D_SRV1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_SRV1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_SRV1")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .field("PlaneSlice", &self.PlaneSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_SRV1 {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip
            && self.MipLevels == other.MipLevels
            && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_SRV1 {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_SRV1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_UAV {
    pub MipSlice: u32,
}
impl D3D11_TEX2D_UAV {}
impl ::std::default::Default for D3D11_TEX2D_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_UAV")
            .field("MipSlice", &self.MipSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_UAV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_UAV1 {
    pub MipSlice: u32,
    pub PlaneSlice: u32,
}
impl D3D11_TEX2D_UAV1 {}
impl ::std::default::Default for D3D11_TEX2D_UAV1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_UAV1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_UAV1")
            .field("MipSlice", &self.MipSlice)
            .field("PlaneSlice", &self.PlaneSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_UAV1 {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.PlaneSlice == other.PlaneSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_UAV1 {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_UAV1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_VDOV {
    pub ArraySlice: u32,
}
impl D3D11_TEX2D_VDOV {}
impl ::std::default::Default for D3D11_TEX2D_VDOV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_VDOV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_VDOV")
            .field("ArraySlice", &self.ArraySlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_VDOV {
    fn eq(&self, other: &Self) -> bool {
        self.ArraySlice == other.ArraySlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_VDOV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_VDOV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_VPIV {
    pub MipSlice: u32,
    pub ArraySlice: u32,
}
impl D3D11_TEX2D_VPIV {}
impl ::std::default::Default for D3D11_TEX2D_VPIV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_VPIV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_VPIV")
            .field("MipSlice", &self.MipSlice)
            .field("ArraySlice", &self.ArraySlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_VPIV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice && self.ArraySlice == other.ArraySlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_VPIV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_VPIV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX2D_VPOV {
    pub MipSlice: u32,
}
impl D3D11_TEX2D_VPOV {}
impl ::std::default::Default for D3D11_TEX2D_VPOV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX2D_VPOV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX2D_VPOV")
            .field("MipSlice", &self.MipSlice)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX2D_VPOV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
    }
}
impl ::std::cmp::Eq for D3D11_TEX2D_VPOV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX2D_VPOV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX3D_RTV {
    pub MipSlice: u32,
    pub FirstWSlice: u32,
    pub WSize: u32,
}
impl D3D11_TEX3D_RTV {}
impl ::std::default::Default for D3D11_TEX3D_RTV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX3D_RTV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX3D_RTV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstWSlice", &self.FirstWSlice)
            .field("WSize", &self.WSize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX3D_RTV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstWSlice == other.FirstWSlice
            && self.WSize == other.WSize
    }
}
impl ::std::cmp::Eq for D3D11_TEX3D_RTV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX3D_RTV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX3D_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
}
impl D3D11_TEX3D_SRV {}
impl ::std::default::Default for D3D11_TEX3D_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX3D_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX3D_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX3D_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels
    }
}
impl ::std::cmp::Eq for D3D11_TEX3D_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX3D_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEX3D_UAV {
    pub MipSlice: u32,
    pub FirstWSlice: u32,
    pub WSize: u32,
}
impl D3D11_TEX3D_UAV {}
impl ::std::default::Default for D3D11_TEX3D_UAV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEX3D_UAV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEX3D_UAV")
            .field("MipSlice", &self.MipSlice)
            .field("FirstWSlice", &self.FirstWSlice)
            .field("WSize", &self.WSize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEX3D_UAV {
    fn eq(&self, other: &Self) -> bool {
        self.MipSlice == other.MipSlice
            && self.FirstWSlice == other.FirstWSlice
            && self.WSize == other.WSize
    }
}
impl ::std::cmp::Eq for D3D11_TEX3D_UAV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEX3D_UAV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEXCUBE_ARRAY_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
    pub First2DArrayFace: u32,
    pub NumCubes: u32,
}
impl D3D11_TEXCUBE_ARRAY_SRV {}
impl ::std::default::Default for D3D11_TEXCUBE_ARRAY_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEXCUBE_ARRAY_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEXCUBE_ARRAY_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .field("First2DArrayFace", &self.First2DArrayFace)
            .field("NumCubes", &self.NumCubes)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEXCUBE_ARRAY_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip
            && self.MipLevels == other.MipLevels
            && self.First2DArrayFace == other.First2DArrayFace
            && self.NumCubes == other.NumCubes
    }
}
impl ::std::cmp::Eq for D3D11_TEXCUBE_ARRAY_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEXCUBE_ARRAY_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TEXCUBE_SRV {
    pub MostDetailedMip: u32,
    pub MipLevels: u32,
}
impl D3D11_TEXCUBE_SRV {}
impl ::std::default::Default for D3D11_TEXCUBE_SRV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TEXCUBE_SRV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEXCUBE_SRV")
            .field("MostDetailedMip", &self.MostDetailedMip)
            .field("MipLevels", &self.MipLevels)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TEXCUBE_SRV {
    fn eq(&self, other: &Self) -> bool {
        self.MostDetailedMip == other.MostDetailedMip && self.MipLevels == other.MipLevels
    }
}
impl ::std::cmp::Eq for D3D11_TEXCUBE_SRV {}
unsafe impl ::windows::runtime::Abi for D3D11_TEXCUBE_SRV {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_TEXEL_ADDRESS_RANGE_BIT_COUNT: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_TEXTURE1D_DESC {
    pub Width: u32,
    pub MipLevels: u32,
    pub ArraySize: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub Usage: D3D11_USAGE,
    pub BindFlags: u32,
    pub CPUAccessFlags: u32,
    pub MiscFlags: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_TEXTURE1D_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_TEXTURE1D_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_TEXTURE1D_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEXTURE1D_DESC")
            .field("Width", &self.Width)
            .field("MipLevels", &self.MipLevels)
            .field("ArraySize", &self.ArraySize)
            .field("Format", &self.Format)
            .field("Usage", &self.Usage)
            .field("BindFlags", &self.BindFlags)
            .field("CPUAccessFlags", &self.CPUAccessFlags)
            .field("MiscFlags", &self.MiscFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_TEXTURE1D_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Width == other.Width
            && self.MipLevels == other.MipLevels
            && self.ArraySize == other.ArraySize
            && self.Format == other.Format
            && self.Usage == other.Usage
            && self.BindFlags == other.BindFlags
            && self.CPUAccessFlags == other.CPUAccessFlags
            && self.MiscFlags == other.MiscFlags
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_TEXTURE1D_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURE1D_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_TEXTURE2D_DESC {
    pub Width: u32,
    pub Height: u32,
    pub MipLevels: u32,
    pub ArraySize: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub SampleDesc: super::Dxgi::DXGI_SAMPLE_DESC,
    pub Usage: D3D11_USAGE,
    pub BindFlags: D3D11_BIND_FLAG,
    pub CPUAccessFlags: D3D11_CPU_ACCESS_FLAG,
    pub MiscFlags: D3D11_RESOURCE_MISC_FLAG,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_TEXTURE2D_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_TEXTURE2D_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_TEXTURE2D_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEXTURE2D_DESC")
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("MipLevels", &self.MipLevels)
            .field("ArraySize", &self.ArraySize)
            .field("Format", &self.Format)
            .field("SampleDesc", &self.SampleDesc)
            .field("Usage", &self.Usage)
            .field("BindFlags", &self.BindFlags)
            .field("CPUAccessFlags", &self.CPUAccessFlags)
            .field("MiscFlags", &self.MiscFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_TEXTURE2D_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Width == other.Width
            && self.Height == other.Height
            && self.MipLevels == other.MipLevels
            && self.ArraySize == other.ArraySize
            && self.Format == other.Format
            && self.SampleDesc == other.SampleDesc
            && self.Usage == other.Usage
            && self.BindFlags == other.BindFlags
            && self.CPUAccessFlags == other.CPUAccessFlags
            && self.MiscFlags == other.MiscFlags
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_TEXTURE2D_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURE2D_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_TEXTURE2D_DESC1 {
    pub Width: u32,
    pub Height: u32,
    pub MipLevels: u32,
    pub ArraySize: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub SampleDesc: super::Dxgi::DXGI_SAMPLE_DESC,
    pub Usage: D3D11_USAGE,
    pub BindFlags: u32,
    pub CPUAccessFlags: u32,
    pub MiscFlags: u32,
    pub TextureLayout: D3D11_TEXTURE_LAYOUT,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_TEXTURE2D_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_TEXTURE2D_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_TEXTURE2D_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEXTURE2D_DESC1")
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("MipLevels", &self.MipLevels)
            .field("ArraySize", &self.ArraySize)
            .field("Format", &self.Format)
            .field("SampleDesc", &self.SampleDesc)
            .field("Usage", &self.Usage)
            .field("BindFlags", &self.BindFlags)
            .field("CPUAccessFlags", &self.CPUAccessFlags)
            .field("MiscFlags", &self.MiscFlags)
            .field("TextureLayout", &self.TextureLayout)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_TEXTURE2D_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.Width == other.Width
            && self.Height == other.Height
            && self.MipLevels == other.MipLevels
            && self.ArraySize == other.ArraySize
            && self.Format == other.Format
            && self.SampleDesc == other.SampleDesc
            && self.Usage == other.Usage
            && self.BindFlags == other.BindFlags
            && self.CPUAccessFlags == other.CPUAccessFlags
            && self.MiscFlags == other.MiscFlags
            && self.TextureLayout == other.TextureLayout
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_TEXTURE2D_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURE2D_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_TEXTURE3D_DESC {
    pub Width: u32,
    pub Height: u32,
    pub Depth: u32,
    pub MipLevels: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub Usage: D3D11_USAGE,
    pub BindFlags: u32,
    pub CPUAccessFlags: u32,
    pub MiscFlags: u32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_TEXTURE3D_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_TEXTURE3D_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_TEXTURE3D_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEXTURE3D_DESC")
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("Depth", &self.Depth)
            .field("MipLevels", &self.MipLevels)
            .field("Format", &self.Format)
            .field("Usage", &self.Usage)
            .field("BindFlags", &self.BindFlags)
            .field("CPUAccessFlags", &self.CPUAccessFlags)
            .field("MiscFlags", &self.MiscFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_TEXTURE3D_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Width == other.Width
            && self.Height == other.Height
            && self.Depth == other.Depth
            && self.MipLevels == other.MipLevels
            && self.Format == other.Format
            && self.Usage == other.Usage
            && self.BindFlags == other.BindFlags
            && self.CPUAccessFlags == other.CPUAccessFlags
            && self.MiscFlags == other.MiscFlags
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_TEXTURE3D_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURE3D_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_TEXTURE3D_DESC1 {
    pub Width: u32,
    pub Height: u32,
    pub Depth: u32,
    pub MipLevels: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub Usage: D3D11_USAGE,
    pub BindFlags: u32,
    pub CPUAccessFlags: u32,
    pub MiscFlags: u32,
    pub TextureLayout: D3D11_TEXTURE_LAYOUT,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_TEXTURE3D_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_TEXTURE3D_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_TEXTURE3D_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TEXTURE3D_DESC1")
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("Depth", &self.Depth)
            .field("MipLevels", &self.MipLevels)
            .field("Format", &self.Format)
            .field("Usage", &self.Usage)
            .field("BindFlags", &self.BindFlags)
            .field("CPUAccessFlags", &self.CPUAccessFlags)
            .field("MiscFlags", &self.MiscFlags)
            .field("TextureLayout", &self.TextureLayout)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_TEXTURE3D_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.Width == other.Width
            && self.Height == other.Height
            && self.Depth == other.Depth
            && self.MipLevels == other.MipLevels
            && self.Format == other.Format
            && self.Usage == other.Usage
            && self.BindFlags == other.BindFlags
            && self.CPUAccessFlags == other.CPUAccessFlags
            && self.MiscFlags == other.MiscFlags
            && self.TextureLayout == other.TextureLayout
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_TEXTURE3D_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURE3D_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TEXTURECUBE_FACE(pub i32);
pub const D3D11_TEXTURECUBE_FACE_POSITIVE_X: D3D11_TEXTURECUBE_FACE = D3D11_TEXTURECUBE_FACE(0i32);
pub const D3D11_TEXTURECUBE_FACE_NEGATIVE_X: D3D11_TEXTURECUBE_FACE = D3D11_TEXTURECUBE_FACE(1i32);
pub const D3D11_TEXTURECUBE_FACE_POSITIVE_Y: D3D11_TEXTURECUBE_FACE = D3D11_TEXTURECUBE_FACE(2i32);
pub const D3D11_TEXTURECUBE_FACE_NEGATIVE_Y: D3D11_TEXTURECUBE_FACE = D3D11_TEXTURECUBE_FACE(3i32);
pub const D3D11_TEXTURECUBE_FACE_POSITIVE_Z: D3D11_TEXTURECUBE_FACE = D3D11_TEXTURECUBE_FACE(4i32);
pub const D3D11_TEXTURECUBE_FACE_NEGATIVE_Z: D3D11_TEXTURECUBE_FACE = D3D11_TEXTURECUBE_FACE(5i32);
impl ::std::convert::From<i32> for D3D11_TEXTURECUBE_FACE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURECUBE_FACE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TEXTURE_ADDRESS_MODE(pub i32);
pub const D3D11_TEXTURE_ADDRESS_WRAP: D3D11_TEXTURE_ADDRESS_MODE = D3D11_TEXTURE_ADDRESS_MODE(1i32);
pub const D3D11_TEXTURE_ADDRESS_MIRROR: D3D11_TEXTURE_ADDRESS_MODE =
    D3D11_TEXTURE_ADDRESS_MODE(2i32);
pub const D3D11_TEXTURE_ADDRESS_CLAMP: D3D11_TEXTURE_ADDRESS_MODE =
    D3D11_TEXTURE_ADDRESS_MODE(3i32);
pub const D3D11_TEXTURE_ADDRESS_BORDER: D3D11_TEXTURE_ADDRESS_MODE =
    D3D11_TEXTURE_ADDRESS_MODE(4i32);
pub const D3D11_TEXTURE_ADDRESS_MIRROR_ONCE: D3D11_TEXTURE_ADDRESS_MODE =
    D3D11_TEXTURE_ADDRESS_MODE(5i32);
impl ::std::convert::From<i32> for D3D11_TEXTURE_ADDRESS_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURE_ADDRESS_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TEXTURE_LAYOUT(pub i32);
pub const D3D11_TEXTURE_LAYOUT_UNDEFINED: D3D11_TEXTURE_LAYOUT = D3D11_TEXTURE_LAYOUT(0i32);
pub const D3D11_TEXTURE_LAYOUT_ROW_MAJOR: D3D11_TEXTURE_LAYOUT = D3D11_TEXTURE_LAYOUT(1i32);
pub const D3D11_TEXTURE_LAYOUT_64K_STANDARD_SWIZZLE: D3D11_TEXTURE_LAYOUT =
    D3D11_TEXTURE_LAYOUT(2i32);
impl ::std::convert::From<i32> for D3D11_TEXTURE_LAYOUT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TEXTURE_LAYOUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TILED_RESOURCES_TIER(pub i32);
pub const D3D11_TILED_RESOURCES_NOT_SUPPORTED: D3D11_TILED_RESOURCES_TIER =
    D3D11_TILED_RESOURCES_TIER(0i32);
pub const D3D11_TILED_RESOURCES_TIER_1: D3D11_TILED_RESOURCES_TIER =
    D3D11_TILED_RESOURCES_TIER(1i32);
pub const D3D11_TILED_RESOURCES_TIER_2: D3D11_TILED_RESOURCES_TIER =
    D3D11_TILED_RESOURCES_TIER(2i32);
pub const D3D11_TILED_RESOURCES_TIER_3: D3D11_TILED_RESOURCES_TIER =
    D3D11_TILED_RESOURCES_TIER(3i32);
impl ::std::convert::From<i32> for D3D11_TILED_RESOURCES_TIER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TILED_RESOURCES_TIER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TILED_RESOURCE_COORDINATE {
    pub X: u32,
    pub Y: u32,
    pub Z: u32,
    pub Subresource: u32,
}
impl D3D11_TILED_RESOURCE_COORDINATE {}
impl ::std::default::Default for D3D11_TILED_RESOURCE_COORDINATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TILED_RESOURCE_COORDINATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TILED_RESOURCE_COORDINATE")
            .field("X", &self.X)
            .field("Y", &self.Y)
            .field("Z", &self.Z)
            .field("Subresource", &self.Subresource)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TILED_RESOURCE_COORDINATE {
    fn eq(&self, other: &Self) -> bool {
        self.X == other.X
            && self.Y == other.Y
            && self.Z == other.Z
            && self.Subresource == other.Subresource
    }
}
impl ::std::cmp::Eq for D3D11_TILED_RESOURCE_COORDINATE {}
unsafe impl ::windows::runtime::Abi for D3D11_TILED_RESOURCE_COORDINATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TILE_COPY_FLAG(pub i32);
pub const D3D11_TILE_COPY_NO_OVERWRITE: D3D11_TILE_COPY_FLAG = D3D11_TILE_COPY_FLAG(1i32);
pub const D3D11_TILE_COPY_LINEAR_BUFFER_TO_SWIZZLED_TILED_RESOURCE: D3D11_TILE_COPY_FLAG =
    D3D11_TILE_COPY_FLAG(2i32);
pub const D3D11_TILE_COPY_SWIZZLED_TILED_RESOURCE_TO_LINEAR_BUFFER: D3D11_TILE_COPY_FLAG =
    D3D11_TILE_COPY_FLAG(4i32);
impl ::std::convert::From<i32> for D3D11_TILE_COPY_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TILE_COPY_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TILE_MAPPING_FLAG(pub i32);
pub const D3D11_TILE_MAPPING_NO_OVERWRITE: D3D11_TILE_MAPPING_FLAG = D3D11_TILE_MAPPING_FLAG(1i32);
impl ::std::convert::From<i32> for D3D11_TILE_MAPPING_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TILE_MAPPING_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TILE_RANGE_FLAG(pub i32);
pub const D3D11_TILE_RANGE_NULL: D3D11_TILE_RANGE_FLAG = D3D11_TILE_RANGE_FLAG(1i32);
pub const D3D11_TILE_RANGE_SKIP: D3D11_TILE_RANGE_FLAG = D3D11_TILE_RANGE_FLAG(2i32);
pub const D3D11_TILE_RANGE_REUSE_SINGLE_TILE: D3D11_TILE_RANGE_FLAG = D3D11_TILE_RANGE_FLAG(4i32);
impl ::std::convert::From<i32> for D3D11_TILE_RANGE_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TILE_RANGE_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_TILE_REGION_SIZE {
    pub NumTiles: u32,
    pub bUseBox: super::super::Foundation::BOOL,
    pub Width: u32,
    pub Height: u16,
    pub Depth: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_TILE_REGION_SIZE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_TILE_REGION_SIZE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_TILE_REGION_SIZE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TILE_REGION_SIZE")
            .field("NumTiles", &self.NumTiles)
            .field("bUseBox", &self.bUseBox)
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("Depth", &self.Depth)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_TILE_REGION_SIZE {
    fn eq(&self, other: &Self) -> bool {
        self.NumTiles == other.NumTiles
            && self.bUseBox == other.bUseBox
            && self.Width == other.Width
            && self.Height == other.Height
            && self.Depth == other.Depth
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_TILE_REGION_SIZE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_TILE_REGION_SIZE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TILE_SHAPE {
    pub WidthInTexels: u32,
    pub HeightInTexels: u32,
    pub DepthInTexels: u32,
}
impl D3D11_TILE_SHAPE {}
impl ::std::default::Default for D3D11_TILE_SHAPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TILE_SHAPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TILE_SHAPE")
            .field("WidthInTexels", &self.WidthInTexels)
            .field("HeightInTexels", &self.HeightInTexels)
            .field("DepthInTexels", &self.DepthInTexels)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TILE_SHAPE {
    fn eq(&self, other: &Self) -> bool {
        self.WidthInTexels == other.WidthInTexels
            && self.HeightInTexels == other.HeightInTexels
            && self.DepthInTexels == other.DepthInTexels
    }
}
impl ::std::cmp::Eq for D3D11_TILE_SHAPE {}
unsafe impl ::windows::runtime::Abi for D3D11_TILE_SHAPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_TRACE_COMPONENT_W: u32 = 8u32;
pub const D3D11_TRACE_COMPONENT_X: u32 = 1u32;
pub const D3D11_TRACE_COMPONENT_Y: u32 = 2u32;
pub const D3D11_TRACE_COMPONENT_Z: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TRACE_GS_INPUT_PRIMITIVE(pub i32);
pub const D3D11_TRACE_GS_INPUT_PRIMITIVE_UNDEFINED: D3D11_TRACE_GS_INPUT_PRIMITIVE =
    D3D11_TRACE_GS_INPUT_PRIMITIVE(0i32);
pub const D3D11_TRACE_GS_INPUT_PRIMITIVE_POINT: D3D11_TRACE_GS_INPUT_PRIMITIVE =
    D3D11_TRACE_GS_INPUT_PRIMITIVE(1i32);
pub const D3D11_TRACE_GS_INPUT_PRIMITIVE_LINE: D3D11_TRACE_GS_INPUT_PRIMITIVE =
    D3D11_TRACE_GS_INPUT_PRIMITIVE(2i32);
pub const D3D11_TRACE_GS_INPUT_PRIMITIVE_TRIANGLE: D3D11_TRACE_GS_INPUT_PRIMITIVE =
    D3D11_TRACE_GS_INPUT_PRIMITIVE(3i32);
pub const D3D11_TRACE_GS_INPUT_PRIMITIVE_LINE_ADJ: D3D11_TRACE_GS_INPUT_PRIMITIVE =
    D3D11_TRACE_GS_INPUT_PRIMITIVE(6i32);
pub const D3D11_TRACE_GS_INPUT_PRIMITIVE_TRIANGLE_ADJ: D3D11_TRACE_GS_INPUT_PRIMITIVE =
    D3D11_TRACE_GS_INPUT_PRIMITIVE(7i32);
impl ::std::convert::From<i32> for D3D11_TRACE_GS_INPUT_PRIMITIVE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TRACE_GS_INPUT_PRIMITIVE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_TRACE_MISC_GS_CUT: u32 = 2u32;
pub const D3D11_TRACE_MISC_GS_CUT_STREAM: u32 = 16u32;
pub const D3D11_TRACE_MISC_GS_EMIT: u32 = 1u32;
pub const D3D11_TRACE_MISC_GS_EMIT_STREAM: u32 = 8u32;
pub const D3D11_TRACE_MISC_HALT: u32 = 32u32;
pub const D3D11_TRACE_MISC_MESSAGE: u32 = 64u32;
pub const D3D11_TRACE_MISC_PS_DISCARD: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TRACE_REGISTER {
    pub RegType: D3D11_TRACE_REGISTER_TYPE,
    pub Anonymous: D3D11_TRACE_REGISTER_0,
    pub OperandIndex: u8,
    pub Flags: u8,
}
impl D3D11_TRACE_REGISTER {}
impl ::std::default::Default for D3D11_TRACE_REGISTER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_TRACE_REGISTER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_TRACE_REGISTER {}
unsafe impl ::windows::runtime::Abi for D3D11_TRACE_REGISTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_TRACE_REGISTER_0 {
    pub Index1D: u16,
    pub Index2D: [u16; 2],
}
impl D3D11_TRACE_REGISTER_0 {}
impl ::std::default::Default for D3D11_TRACE_REGISTER_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_TRACE_REGISTER_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_TRACE_REGISTER_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_TRACE_REGISTER_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_TRACE_REGISTER_FLAGS_RELATIVE_INDEXING: u32 = 1u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_TRACE_REGISTER_TYPE(pub i32);
pub const D3D11_TRACE_OUTPUT_NULL_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(0i32);
pub const D3D11_TRACE_INPUT_REGISTER: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(1i32);
pub const D3D11_TRACE_INPUT_PRIMITIVE_ID_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(2i32);
pub const D3D11_TRACE_IMMEDIATE_CONSTANT_BUFFER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(3i32);
pub const D3D11_TRACE_TEMP_REGISTER: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(4i32);
pub const D3D11_TRACE_INDEXABLE_TEMP_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(5i32);
pub const D3D11_TRACE_OUTPUT_REGISTER: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(6i32);
pub const D3D11_TRACE_OUTPUT_DEPTH_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(7i32);
pub const D3D11_TRACE_CONSTANT_BUFFER: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(8i32);
pub const D3D11_TRACE_IMMEDIATE32: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(9i32);
pub const D3D11_TRACE_SAMPLER: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(10i32);
pub const D3D11_TRACE_RESOURCE: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(11i32);
pub const D3D11_TRACE_RASTERIZER: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(12i32);
pub const D3D11_TRACE_OUTPUT_COVERAGE_MASK: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(13i32);
pub const D3D11_TRACE_STREAM: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(14i32);
pub const D3D11_TRACE_THIS_POINTER: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(15i32);
pub const D3D11_TRACE_OUTPUT_CONTROL_POINT_ID_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(16i32);
pub const D3D11_TRACE_INPUT_FORK_INSTANCE_ID_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(17i32);
pub const D3D11_TRACE_INPUT_JOIN_INSTANCE_ID_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(18i32);
pub const D3D11_TRACE_INPUT_CONTROL_POINT_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(19i32);
pub const D3D11_TRACE_OUTPUT_CONTROL_POINT_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(20i32);
pub const D3D11_TRACE_INPUT_PATCH_CONSTANT_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(21i32);
pub const D3D11_TRACE_INPUT_DOMAIN_POINT_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(22i32);
pub const D3D11_TRACE_UNORDERED_ACCESS_VIEW: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(23i32);
pub const D3D11_TRACE_THREAD_GROUP_SHARED_MEMORY: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(24i32);
pub const D3D11_TRACE_INPUT_THREAD_ID_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(25i32);
pub const D3D11_TRACE_INPUT_THREAD_GROUP_ID_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(26i32);
pub const D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(27i32);
pub const D3D11_TRACE_INPUT_COVERAGE_MASK_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(28i32);
pub const D3D11_TRACE_INPUT_THREAD_ID_IN_GROUP_FLATTENED_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(29i32);
pub const D3D11_TRACE_INPUT_GS_INSTANCE_ID_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(30i32);
pub const D3D11_TRACE_OUTPUT_DEPTH_GREATER_EQUAL_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(31i32);
pub const D3D11_TRACE_OUTPUT_DEPTH_LESS_EQUAL_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(32i32);
pub const D3D11_TRACE_IMMEDIATE64: D3D11_TRACE_REGISTER_TYPE = D3D11_TRACE_REGISTER_TYPE(33i32);
pub const D3D11_TRACE_INPUT_CYCLE_COUNTER_REGISTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(34i32);
pub const D3D11_TRACE_INTERFACE_POINTER: D3D11_TRACE_REGISTER_TYPE =
    D3D11_TRACE_REGISTER_TYPE(35i32);
impl ::std::convert::From<i32> for D3D11_TRACE_REGISTER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_TRACE_REGISTER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_TRACE_STATS {
    pub TraceDesc: D3D11_SHADER_TRACE_DESC,
    pub NumInvocationsInStamp: u8,
    pub TargetStampIndex: u8,
    pub NumTraceSteps: u32,
    pub InputMask: [u8; 32],
    pub OutputMask: [u8; 32],
    pub NumTemps: u16,
    pub MaxIndexableTempIndex: u16,
    pub IndexableTempSize: [u16; 4096],
    pub ImmediateConstantBufferSize: u16,
    pub PixelPosition: [u32; 8],
    pub PixelCoverageMask: [u64; 4],
    pub PixelDiscardedMask: [u64; 4],
    pub PixelCoverageMaskAfterShader: [u64; 4],
    pub PixelCoverageMaskAfterA2CSampleMask: [u64; 4],
    pub PixelCoverageMaskAfterA2CSampleMaskDepth: [u64; 4],
    pub PixelCoverageMaskAfterA2CSampleMaskDepthStencil: [u64; 4],
    pub PSOutputsDepth: super::super::Foundation::BOOL,
    pub PSOutputsMask: super::super::Foundation::BOOL,
    pub GSInputPrimitive: D3D11_TRACE_GS_INPUT_PRIMITIVE,
    pub GSInputsPrimitiveID: super::super::Foundation::BOOL,
    pub HSOutputPatchConstantMask: [u8; 32],
    pub DSInputPatchConstantMask: [u8; 32],
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_TRACE_STATS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_TRACE_STATS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_TRACE_STATS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_TRACE_STATS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_TRACE_STATS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_TRACE_STEP {
    pub ID: u32,
    pub InstructionActive: super::super::Foundation::BOOL,
    pub NumRegistersWritten: u8,
    pub NumRegistersRead: u8,
    pub MiscOperations: u16,
    pub OpcodeType: u32,
    pub CurrentGlobalCycle: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_TRACE_STEP {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_TRACE_STEP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_TRACE_STEP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TRACE_STEP")
            .field("ID", &self.ID)
            .field("InstructionActive", &self.InstructionActive)
            .field("NumRegistersWritten", &self.NumRegistersWritten)
            .field("NumRegistersRead", &self.NumRegistersRead)
            .field("MiscOperations", &self.MiscOperations)
            .field("OpcodeType", &self.OpcodeType)
            .field("CurrentGlobalCycle", &self.CurrentGlobalCycle)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_TRACE_STEP {
    fn eq(&self, other: &Self) -> bool {
        self.ID == other.ID
            && self.InstructionActive == other.InstructionActive
            && self.NumRegistersWritten == other.NumRegistersWritten
            && self.NumRegistersRead == other.NumRegistersRead
            && self.MiscOperations == other.MiscOperations
            && self.OpcodeType == other.OpcodeType
            && self.CurrentGlobalCycle == other.CurrentGlobalCycle
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_TRACE_STEP {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_TRACE_STEP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_TRACE_VALUE {
    pub Bits: [u32; 4],
    pub ValidMask: u8,
}
impl D3D11_TRACE_VALUE {}
impl ::std::default::Default for D3D11_TRACE_VALUE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_TRACE_VALUE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_TRACE_VALUE")
            .field("Bits", &self.Bits)
            .field("ValidMask", &self.ValidMask)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_TRACE_VALUE {
    fn eq(&self, other: &Self) -> bool {
        self.Bits == other.Bits && self.ValidMask == other.ValidMask
    }
}
impl ::std::cmp::Eq for D3D11_TRACE_VALUE {}
unsafe impl ::windows::runtime::Abi for D3D11_TRACE_VALUE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_UAV_DIMENSION(pub i32);
pub const D3D11_UAV_DIMENSION_UNKNOWN: D3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION(0i32);
pub const D3D11_UAV_DIMENSION_BUFFER: D3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION(1i32);
pub const D3D11_UAV_DIMENSION_TEXTURE1D: D3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION(2i32);
pub const D3D11_UAV_DIMENSION_TEXTURE1DARRAY: D3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION(3i32);
pub const D3D11_UAV_DIMENSION_TEXTURE2D: D3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION(4i32);
pub const D3D11_UAV_DIMENSION_TEXTURE2DARRAY: D3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION(5i32);
pub const D3D11_UAV_DIMENSION_TEXTURE3D: D3D11_UAV_DIMENSION = D3D11_UAV_DIMENSION(8i32);
impl ::std::convert::From<i32> for D3D11_UAV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_UAV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_UNBOUND_MEMORY_ACCESS_RESULT: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_UNORDERED_ACCESS_VIEW_DESC {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D11_UAV_DIMENSION,
    pub Anonymous: D3D11_UNORDERED_ACCESS_VIEW_DESC_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_UNORDERED_ACCESS_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_UNORDERED_ACCESS_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_UNORDERED_ACCESS_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_UNORDERED_ACCESS_VIEW_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_UNORDERED_ACCESS_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_UNORDERED_ACCESS_VIEW_DESC_0 {
    pub Buffer: D3D11_BUFFER_UAV,
    pub Texture1D: D3D11_TEX1D_UAV,
    pub Texture1DArray: D3D11_TEX1D_ARRAY_UAV,
    pub Texture2D: D3D11_TEX2D_UAV,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_UAV,
    pub Texture3D: D3D11_TEX3D_UAV,
}
impl D3D11_UNORDERED_ACCESS_VIEW_DESC_0 {}
impl ::std::default::Default for D3D11_UNORDERED_ACCESS_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_UNORDERED_ACCESS_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_UNORDERED_ACCESS_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_UNORDERED_ACCESS_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_UNORDERED_ACCESS_VIEW_DESC1 {
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ViewDimension: D3D11_UAV_DIMENSION,
    pub Anonymous: D3D11_UNORDERED_ACCESS_VIEW_DESC1_0,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_UNORDERED_ACCESS_VIEW_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_UNORDERED_ACCESS_VIEW_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_UNORDERED_ACCESS_VIEW_DESC1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_UNORDERED_ACCESS_VIEW_DESC1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_UNORDERED_ACCESS_VIEW_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_UNORDERED_ACCESS_VIEW_DESC1_0 {
    pub Buffer: D3D11_BUFFER_UAV,
    pub Texture1D: D3D11_TEX1D_UAV,
    pub Texture1DArray: D3D11_TEX1D_ARRAY_UAV,
    pub Texture2D: D3D11_TEX2D_UAV1,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_UAV1,
    pub Texture3D: D3D11_TEX3D_UAV,
}
impl D3D11_UNORDERED_ACCESS_VIEW_DESC1_0 {}
impl ::std::default::Default for D3D11_UNORDERED_ACCESS_VIEW_DESC1_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_UNORDERED_ACCESS_VIEW_DESC1_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_UNORDERED_ACCESS_VIEW_DESC1_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_UNORDERED_ACCESS_VIEW_DESC1_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_USAGE(pub i32);
pub const D3D11_USAGE_DEFAULT: D3D11_USAGE = D3D11_USAGE(0i32);
pub const D3D11_USAGE_IMMUTABLE: D3D11_USAGE = D3D11_USAGE(1i32);
pub const D3D11_USAGE_DYNAMIC: D3D11_USAGE = D3D11_USAGE(2i32);
pub const D3D11_USAGE_STAGING: D3D11_USAGE = D3D11_USAGE(3i32);
impl ::std::convert::From<i32> for D3D11_USAGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_USAGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VDOV_DIMENSION(pub i32);
pub const D3D11_VDOV_DIMENSION_UNKNOWN: D3D11_VDOV_DIMENSION = D3D11_VDOV_DIMENSION(0i32);
pub const D3D11_VDOV_DIMENSION_TEXTURE2D: D3D11_VDOV_DIMENSION = D3D11_VDOV_DIMENSION(1i32);
impl ::std::convert::From<i32> for D3D11_VDOV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VDOV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VERTEX_SHADER_TRACE_DESC {
    pub Invocation: u64,
}
impl D3D11_VERTEX_SHADER_TRACE_DESC {}
impl ::std::default::Default for D3D11_VERTEX_SHADER_TRACE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VERTEX_SHADER_TRACE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VERTEX_SHADER_TRACE_DESC")
            .field("Invocation", &self.Invocation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VERTEX_SHADER_TRACE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Invocation == other.Invocation
    }
}
impl ::std::cmp::Eq for D3D11_VERTEX_SHADER_TRACE_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_VERTEX_SHADER_TRACE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_COLOR {
    pub Anonymous: D3D11_VIDEO_COLOR_0,
}
impl D3D11_VIDEO_COLOR {}
impl ::std::default::Default for D3D11_VIDEO_COLOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_COLOR {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_COLOR {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_COLOR {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_VIDEO_COLOR_0 {
    pub YCbCr: D3D11_VIDEO_COLOR_YCbCrA,
    pub RGBA: D3D11_VIDEO_COLOR_RGBA,
}
impl D3D11_VIDEO_COLOR_0 {}
impl ::std::default::Default for D3D11_VIDEO_COLOR_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_COLOR_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_COLOR_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_COLOR_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_COLOR_RGBA {
    pub R: f32,
    pub G: f32,
    pub B: f32,
    pub A: f32,
}
impl D3D11_VIDEO_COLOR_RGBA {}
impl ::std::default::Default for D3D11_VIDEO_COLOR_RGBA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_COLOR_RGBA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_COLOR_RGBA")
            .field("R", &self.R)
            .field("G", &self.G)
            .field("B", &self.B)
            .field("A", &self.A)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_COLOR_RGBA {
    fn eq(&self, other: &Self) -> bool {
        self.R == other.R && self.G == other.G && self.B == other.B && self.A == other.A
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_COLOR_RGBA {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_COLOR_RGBA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_COLOR_YCbCrA {
    pub Y: f32,
    pub Cb: f32,
    pub Cr: f32,
    pub A: f32,
}
impl D3D11_VIDEO_COLOR_YCbCrA {}
impl ::std::default::Default for D3D11_VIDEO_COLOR_YCbCrA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_COLOR_YCbCrA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_COLOR_YCbCrA")
            .field("Y", &self.Y)
            .field("Cb", &self.Cb)
            .field("Cr", &self.Cr)
            .field("A", &self.A)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_COLOR_YCbCrA {
    fn eq(&self, other: &Self) -> bool {
        self.Y == other.Y && self.Cb == other.Cb && self.Cr == other.Cr && self.A == other.A
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_COLOR_YCbCrA {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_COLOR_YCbCrA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_CONTENT_PROTECTION_CAPS {
    pub Caps: u32,
    pub KeyExchangeTypeCount: u32,
    pub BlockAlignmentSize: u32,
    pub ProtectedMemorySize: u64,
}
impl D3D11_VIDEO_CONTENT_PROTECTION_CAPS {}
impl ::std::default::Default for D3D11_VIDEO_CONTENT_PROTECTION_CAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_CONTENT_PROTECTION_CAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_CONTENT_PROTECTION_CAPS")
            .field("Caps", &self.Caps)
            .field("KeyExchangeTypeCount", &self.KeyExchangeTypeCount)
            .field("BlockAlignmentSize", &self.BlockAlignmentSize)
            .field("ProtectedMemorySize", &self.ProtectedMemorySize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_CONTENT_PROTECTION_CAPS {
    fn eq(&self, other: &Self) -> bool {
        self.Caps == other.Caps
            && self.KeyExchangeTypeCount == other.KeyExchangeTypeCount
            && self.BlockAlignmentSize == other.BlockAlignmentSize
            && self.ProtectedMemorySize == other.ProtectedMemorySize
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_CONTENT_PROTECTION_CAPS {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_CONTENT_PROTECTION_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION {
    pub pCryptoSession: ::std::option::Option<ID3D11CryptoSession>,
    pub BlobSize: u32,
    pub pBlob: *mut ::std::ffi::c_void,
    pub pKeyInfoId: *mut ::windows::runtime::GUID,
    pub PrivateDataSize: u32,
    pub pPrivateData: *mut ::std::ffi::c_void,
}
impl D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION")
            .field("pCryptoSession", &self.pCryptoSession)
            .field("BlobSize", &self.BlobSize)
            .field("pBlob", &self.pBlob)
            .field("pKeyInfoId", &self.pKeyInfoId)
            .field("PrivateDataSize", &self.PrivateDataSize)
            .field("pPrivateData", &self.pPrivateData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION {
    fn eq(&self, other: &Self) -> bool {
        self.pCryptoSession == other.pCryptoSession
            && self.BlobSize == other.BlobSize
            && self.pBlob == other.pBlob
            && self.pKeyInfoId == other.pKeyInfoId
            && self.PrivateDataSize == other.PrivateDataSize
            && self.pPrivateData == other.pPrivateData
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_BEGIN_FRAME_CRYPTO_SESSION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_VIDEO_DECODER_BUFFER_DESC {
    pub BufferType: D3D11_VIDEO_DECODER_BUFFER_TYPE,
    pub BufferIndex: u32,
    pub DataOffset: u32,
    pub DataSize: u32,
    pub FirstMBaddress: u32,
    pub NumMBsInBuffer: u32,
    pub Width: u32,
    pub Height: u32,
    pub Stride: u32,
    pub ReservedBits: u32,
    pub pIV: *mut ::std::ffi::c_void,
    pub IVSize: u32,
    pub PartialEncryption: super::super::Foundation::BOOL,
    pub EncryptedBlockInfo: D3D11_ENCRYPTED_BLOCK_INFO,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_VIDEO_DECODER_BUFFER_DESC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_VIDEO_DECODER_BUFFER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_BUFFER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_BUFFER_DESC")
            .field("BufferType", &self.BufferType)
            .field("BufferIndex", &self.BufferIndex)
            .field("DataOffset", &self.DataOffset)
            .field("DataSize", &self.DataSize)
            .field("FirstMBaddress", &self.FirstMBaddress)
            .field("NumMBsInBuffer", &self.NumMBsInBuffer)
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("Stride", &self.Stride)
            .field("ReservedBits", &self.ReservedBits)
            .field("pIV", &self.pIV)
            .field("IVSize", &self.IVSize)
            .field("PartialEncryption", &self.PartialEncryption)
            .field("EncryptedBlockInfo", &self.EncryptedBlockInfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_BUFFER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.BufferType == other.BufferType
            && self.BufferIndex == other.BufferIndex
            && self.DataOffset == other.DataOffset
            && self.DataSize == other.DataSize
            && self.FirstMBaddress == other.FirstMBaddress
            && self.NumMBsInBuffer == other.NumMBsInBuffer
            && self.Width == other.Width
            && self.Height == other.Height
            && self.Stride == other.Stride
            && self.ReservedBits == other.ReservedBits
            && self.pIV == other.pIV
            && self.IVSize == other.IVSize
            && self.PartialEncryption == other.PartialEncryption
            && self.EncryptedBlockInfo == other.EncryptedBlockInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_BUFFER_DESC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_BUFFER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_DECODER_BUFFER_DESC1 {
    pub BufferType: D3D11_VIDEO_DECODER_BUFFER_TYPE,
    pub DataOffset: u32,
    pub DataSize: u32,
    pub pIV: *mut ::std::ffi::c_void,
    pub IVSize: u32,
    pub pSubSampleMappingBlock: *mut D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK,
    pub SubSampleMappingCount: u32,
}
impl D3D11_VIDEO_DECODER_BUFFER_DESC1 {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_BUFFER_DESC1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_BUFFER_DESC1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_BUFFER_DESC1")
            .field("BufferType", &self.BufferType)
            .field("DataOffset", &self.DataOffset)
            .field("DataSize", &self.DataSize)
            .field("pIV", &self.pIV)
            .field("IVSize", &self.IVSize)
            .field("pSubSampleMappingBlock", &self.pSubSampleMappingBlock)
            .field("SubSampleMappingCount", &self.SubSampleMappingCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_BUFFER_DESC1 {
    fn eq(&self, other: &Self) -> bool {
        self.BufferType == other.BufferType
            && self.DataOffset == other.DataOffset
            && self.DataSize == other.DataSize
            && self.pIV == other.pIV
            && self.IVSize == other.IVSize
            && self.pSubSampleMappingBlock == other.pSubSampleMappingBlock
            && self.SubSampleMappingCount == other.SubSampleMappingCount
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_BUFFER_DESC1 {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_BUFFER_DESC1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_DECODER_BUFFER_DESC2 {
    pub BufferType: D3D11_VIDEO_DECODER_BUFFER_TYPE,
    pub DataOffset: u32,
    pub DataSize: u32,
    pub pIV: *mut ::std::ffi::c_void,
    pub IVSize: u32,
    pub pSubSampleMappingBlock: *mut D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK,
    pub SubSampleMappingCount: u32,
    pub cBlocksStripeEncrypted: u32,
    pub cBlocksStripeClear: u32,
}
impl D3D11_VIDEO_DECODER_BUFFER_DESC2 {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_BUFFER_DESC2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_BUFFER_DESC2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_BUFFER_DESC2")
            .field("BufferType", &self.BufferType)
            .field("DataOffset", &self.DataOffset)
            .field("DataSize", &self.DataSize)
            .field("pIV", &self.pIV)
            .field("IVSize", &self.IVSize)
            .field("pSubSampleMappingBlock", &self.pSubSampleMappingBlock)
            .field("SubSampleMappingCount", &self.SubSampleMappingCount)
            .field("cBlocksStripeEncrypted", &self.cBlocksStripeEncrypted)
            .field("cBlocksStripeClear", &self.cBlocksStripeClear)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_BUFFER_DESC2 {
    fn eq(&self, other: &Self) -> bool {
        self.BufferType == other.BufferType
            && self.DataOffset == other.DataOffset
            && self.DataSize == other.DataSize
            && self.pIV == other.pIV
            && self.IVSize == other.IVSize
            && self.pSubSampleMappingBlock == other.pSubSampleMappingBlock
            && self.SubSampleMappingCount == other.SubSampleMappingCount
            && self.cBlocksStripeEncrypted == other.cBlocksStripeEncrypted
            && self.cBlocksStripeClear == other.cBlocksStripeClear
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_BUFFER_DESC2 {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_BUFFER_DESC2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_DECODER_BUFFER_TYPE(pub i32);
pub const D3D11_VIDEO_DECODER_BUFFER_PICTURE_PARAMETERS: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(0i32);
pub const D3D11_VIDEO_DECODER_BUFFER_MACROBLOCK_CONTROL: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(1i32);
pub const D3D11_VIDEO_DECODER_BUFFER_RESIDUAL_DIFFERENCE: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(2i32);
pub const D3D11_VIDEO_DECODER_BUFFER_DEBLOCKING_CONTROL: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(3i32);
pub const D3D11_VIDEO_DECODER_BUFFER_INVERSE_QUANTIZATION_MATRIX: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(4i32);
pub const D3D11_VIDEO_DECODER_BUFFER_SLICE_CONTROL: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(5i32);
pub const D3D11_VIDEO_DECODER_BUFFER_BITSTREAM: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(6i32);
pub const D3D11_VIDEO_DECODER_BUFFER_MOTION_VECTOR: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(7i32);
pub const D3D11_VIDEO_DECODER_BUFFER_FILM_GRAIN: D3D11_VIDEO_DECODER_BUFFER_TYPE =
    D3D11_VIDEO_DECODER_BUFFER_TYPE(8i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_DECODER_BUFFER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_BUFFER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_DECODER_CAPS(pub i32);
pub const D3D11_VIDEO_DECODER_CAPS_DOWNSAMPLE: D3D11_VIDEO_DECODER_CAPS =
    D3D11_VIDEO_DECODER_CAPS(1i32);
pub const D3D11_VIDEO_DECODER_CAPS_NON_REAL_TIME: D3D11_VIDEO_DECODER_CAPS =
    D3D11_VIDEO_DECODER_CAPS(2i32);
pub const D3D11_VIDEO_DECODER_CAPS_DOWNSAMPLE_DYNAMIC: D3D11_VIDEO_DECODER_CAPS =
    D3D11_VIDEO_DECODER_CAPS(4i32);
pub const D3D11_VIDEO_DECODER_CAPS_DOWNSAMPLE_REQUIRED: D3D11_VIDEO_DECODER_CAPS =
    D3D11_VIDEO_DECODER_CAPS(8i32);
pub const D3D11_VIDEO_DECODER_CAPS_UNSUPPORTED: D3D11_VIDEO_DECODER_CAPS =
    D3D11_VIDEO_DECODER_CAPS(16i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_DECODER_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_DECODER_CONFIG {
    pub guidConfigBitstreamEncryption: ::windows::runtime::GUID,
    pub guidConfigMBcontrolEncryption: ::windows::runtime::GUID,
    pub guidConfigResidDiffEncryption: ::windows::runtime::GUID,
    pub ConfigBitstreamRaw: u32,
    pub ConfigMBcontrolRasterOrder: u32,
    pub ConfigResidDiffHost: u32,
    pub ConfigSpatialResid8: u32,
    pub ConfigResid8Subtraction: u32,
    pub ConfigSpatialHost8or9Clipping: u32,
    pub ConfigSpatialResidInterleaved: u32,
    pub ConfigIntraResidUnsigned: u32,
    pub ConfigResidDiffAccelerator: u32,
    pub ConfigHostInverseScan: u32,
    pub ConfigSpecificIDCT: u32,
    pub Config4GroupedCoefs: u32,
    pub ConfigMinRenderTargetBuffCount: u16,
    pub ConfigDecoderSpecific: u16,
}
impl D3D11_VIDEO_DECODER_CONFIG {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_CONFIG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_CONFIG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_CONFIG")
            .field(
                "guidConfigBitstreamEncryption",
                &self.guidConfigBitstreamEncryption,
            )
            .field(
                "guidConfigMBcontrolEncryption",
                &self.guidConfigMBcontrolEncryption,
            )
            .field(
                "guidConfigResidDiffEncryption",
                &self.guidConfigResidDiffEncryption,
            )
            .field("ConfigBitstreamRaw", &self.ConfigBitstreamRaw)
            .field(
                "ConfigMBcontrolRasterOrder",
                &self.ConfigMBcontrolRasterOrder,
            )
            .field("ConfigResidDiffHost", &self.ConfigResidDiffHost)
            .field("ConfigSpatialResid8", &self.ConfigSpatialResid8)
            .field("ConfigResid8Subtraction", &self.ConfigResid8Subtraction)
            .field(
                "ConfigSpatialHost8or9Clipping",
                &self.ConfigSpatialHost8or9Clipping,
            )
            .field(
                "ConfigSpatialResidInterleaved",
                &self.ConfigSpatialResidInterleaved,
            )
            .field("ConfigIntraResidUnsigned", &self.ConfigIntraResidUnsigned)
            .field(
                "ConfigResidDiffAccelerator",
                &self.ConfigResidDiffAccelerator,
            )
            .field("ConfigHostInverseScan", &self.ConfigHostInverseScan)
            .field("ConfigSpecificIDCT", &self.ConfigSpecificIDCT)
            .field("Config4GroupedCoefs", &self.Config4GroupedCoefs)
            .field(
                "ConfigMinRenderTargetBuffCount",
                &self.ConfigMinRenderTargetBuffCount,
            )
            .field("ConfigDecoderSpecific", &self.ConfigDecoderSpecific)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_CONFIG {
    fn eq(&self, other: &Self) -> bool {
        self.guidConfigBitstreamEncryption == other.guidConfigBitstreamEncryption
            && self.guidConfigMBcontrolEncryption == other.guidConfigMBcontrolEncryption
            && self.guidConfigResidDiffEncryption == other.guidConfigResidDiffEncryption
            && self.ConfigBitstreamRaw == other.ConfigBitstreamRaw
            && self.ConfigMBcontrolRasterOrder == other.ConfigMBcontrolRasterOrder
            && self.ConfigResidDiffHost == other.ConfigResidDiffHost
            && self.ConfigSpatialResid8 == other.ConfigSpatialResid8
            && self.ConfigResid8Subtraction == other.ConfigResid8Subtraction
            && self.ConfigSpatialHost8or9Clipping == other.ConfigSpatialHost8or9Clipping
            && self.ConfigSpatialResidInterleaved == other.ConfigSpatialResidInterleaved
            && self.ConfigIntraResidUnsigned == other.ConfigIntraResidUnsigned
            && self.ConfigResidDiffAccelerator == other.ConfigResidDiffAccelerator
            && self.ConfigHostInverseScan == other.ConfigHostInverseScan
            && self.ConfigSpecificIDCT == other.ConfigSpecificIDCT
            && self.Config4GroupedCoefs == other.Config4GroupedCoefs
            && self.ConfigMinRenderTargetBuffCount == other.ConfigMinRenderTargetBuffCount
            && self.ConfigDecoderSpecific == other.ConfigDecoderSpecific
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_CONFIG {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_CONFIG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_VIDEO_DECODER_DESC {
    pub Guid: ::windows::runtime::GUID,
    pub SampleWidth: u32,
    pub SampleHeight: u32,
    pub OutputFormat: super::Dxgi::DXGI_FORMAT,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_VIDEO_DECODER_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_VIDEO_DECODER_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_DESC")
            .field("Guid", &self.Guid)
            .field("SampleWidth", &self.SampleWidth)
            .field("SampleHeight", &self.SampleHeight)
            .field("OutputFormat", &self.OutputFormat)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Guid == other.Guid
            && self.SampleWidth == other.SampleWidth
            && self.SampleHeight == other.SampleHeight
            && self.OutputFormat == other.OutputFormat
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_DECODER_EXTENSION {
    pub Function: u32,
    pub pPrivateInputData: *mut ::std::ffi::c_void,
    pub PrivateInputDataSize: u32,
    pub pPrivateOutputData: *mut ::std::ffi::c_void,
    pub PrivateOutputDataSize: u32,
    pub ResourceCount: u32,
    pub ppResourceList: *mut ::std::option::Option<ID3D11Resource>,
}
impl D3D11_VIDEO_DECODER_EXTENSION {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_EXTENSION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_EXTENSION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_EXTENSION")
            .field("Function", &self.Function)
            .field("pPrivateInputData", &self.pPrivateInputData)
            .field("PrivateInputDataSize", &self.PrivateInputDataSize)
            .field("pPrivateOutputData", &self.pPrivateOutputData)
            .field("PrivateOutputDataSize", &self.PrivateOutputDataSize)
            .field("ResourceCount", &self.ResourceCount)
            .field("ppResourceList", &self.ppResourceList)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_EXTENSION {
    fn eq(&self, other: &Self) -> bool {
        self.Function == other.Function
            && self.pPrivateInputData == other.pPrivateInputData
            && self.PrivateInputDataSize == other.PrivateInputDataSize
            && self.pPrivateOutputData == other.pPrivateOutputData
            && self.PrivateOutputDataSize == other.PrivateOutputDataSize
            && self.ResourceCount == other.ResourceCount
            && self.ppResourceList == other.ppResourceList
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_EXTENSION {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_EXTENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(pub i32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_Y: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(0i32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_U: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(1i32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_V: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(2i32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_R: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(0i32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_G: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(1i32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_B: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(2i32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_A: D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT(3i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(pub u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_NONE:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(0u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_Y:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(1u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_U:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(2u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_V:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(4u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_R:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(1u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_G:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(2u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_B:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(4u32);
pub const D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAG_A:
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS =
    D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS(8u32);
impl ::std::convert::From<u32> for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D3D11_VIDEO_DECODER_HISTOGRAM_COMPONENT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {
    pub DecodeProfile: ::windows::runtime::GUID,
    pub ViewDimension: D3D11_VDOV_DIMENSION,
    pub Anonymous: D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC_0,
}
impl D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC_0 {
    pub Texture2D: D3D11_TEX2D_VDOV,
}
impl D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC_0 {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_OUTPUT_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK {
    pub ClearSize: u32,
    pub EncryptedSize: u32,
}
impl D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK {}
impl ::std::default::Default for D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK")
            .field("ClearSize", &self.ClearSize)
            .field("EncryptedSize", &self.EncryptedSize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK {
    fn eq(&self, other: &Self) -> bool {
        self.ClearSize == other.ClearSize && self.EncryptedSize == other.EncryptedSize
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_DECODER_SUB_SAMPLE_MAPPING_BLOCK {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_FRAME_FORMAT(pub i32);
pub const D3D11_VIDEO_FRAME_FORMAT_PROGRESSIVE: D3D11_VIDEO_FRAME_FORMAT =
    D3D11_VIDEO_FRAME_FORMAT(0i32);
pub const D3D11_VIDEO_FRAME_FORMAT_INTERLACED_TOP_FIELD_FIRST: D3D11_VIDEO_FRAME_FORMAT =
    D3D11_VIDEO_FRAME_FORMAT(1i32);
pub const D3D11_VIDEO_FRAME_FORMAT_INTERLACED_BOTTOM_FIELD_FIRST: D3D11_VIDEO_FRAME_FORMAT =
    D3D11_VIDEO_FRAME_FORMAT(2i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_FRAME_FORMAT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_FRAME_FORMAT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE(pub i32);
pub const D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_OPAQUE: D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE =
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE(0i32);
pub const D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_BACKGROUND: D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE =
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE(1i32);
pub const D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_DESTINATION: D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE =
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE(2i32);
pub const D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE_SOURCE_STREAM:
    D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE = D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE(3i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_ALPHA_FILL_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DENOISE: D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS =
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_DERINGING: D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS =
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_EDGE_ENHANCEMENT:
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS = D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_COLOR_CORRECTION:
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS = D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(8i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_FLESH_TONE_MAPPING:
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS = D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(16i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_IMAGE_STABILIZATION:
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS = D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(32i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_SUPER_RESOLUTION:
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS = D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(64i32);
pub const D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS_ANAMORPHIC_SCALING:
    D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS = D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS(128i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_AUTO_STREAM_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_MULTIPLANE_OVERLAY_ROTATION:
    D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS = D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS(1i32);
pub const D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_MULTIPLANE_OVERLAY_RESIZE:
    D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS = D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS(2i32);
pub const D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_MULTIPLANE_OVERLAY_COLOR_SPACE_CONVERSION:
    D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS = D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS(4i32);
pub const D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINT_TRIPLE_BUFFER_OUTPUT:
    D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS = D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS(8i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_BEHAVIOR_HINTS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_PROCESSOR_CAPS {
    pub DeviceCaps: u32,
    pub FeatureCaps: u32,
    pub FilterCaps: u32,
    pub InputFormatCaps: u32,
    pub AutoStreamCaps: u32,
    pub StereoCaps: u32,
    pub RateConversionCapsCount: u32,
    pub MaxInputStreams: u32,
    pub MaxStreamStates: u32,
}
impl D3D11_VIDEO_PROCESSOR_CAPS {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_CAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_CAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_CAPS")
            .field("DeviceCaps", &self.DeviceCaps)
            .field("FeatureCaps", &self.FeatureCaps)
            .field("FilterCaps", &self.FilterCaps)
            .field("InputFormatCaps", &self.InputFormatCaps)
            .field("AutoStreamCaps", &self.AutoStreamCaps)
            .field("StereoCaps", &self.StereoCaps)
            .field("RateConversionCapsCount", &self.RateConversionCapsCount)
            .field("MaxInputStreams", &self.MaxInputStreams)
            .field("MaxStreamStates", &self.MaxStreamStates)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_CAPS {
    fn eq(&self, other: &Self) -> bool {
        self.DeviceCaps == other.DeviceCaps
            && self.FeatureCaps == other.FeatureCaps
            && self.FilterCaps == other.FilterCaps
            && self.InputFormatCaps == other.InputFormatCaps
            && self.AutoStreamCaps == other.AutoStreamCaps
            && self.StereoCaps == other.StereoCaps
            && self.RateConversionCapsCount == other.RateConversionCapsCount
            && self.MaxInputStreams == other.MaxInputStreams
            && self.MaxStreamStates == other.MaxStreamStates
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_CAPS {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_PROCESSOR_COLOR_SPACE {
    pub _bitfield: u32,
}
impl D3D11_VIDEO_PROCESSOR_COLOR_SPACE {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_COLOR_SPACE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_COLOR_SPACE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_COLOR_SPACE")
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_COLOR_SPACE {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_COLOR_SPACE {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_COLOR_SPACE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_VIDEO_PROCESSOR_CONTENT_DESC {
    pub InputFrameFormat: D3D11_VIDEO_FRAME_FORMAT,
    pub InputFrameRate: super::Dxgi::DXGI_RATIONAL,
    pub InputWidth: u32,
    pub InputHeight: u32,
    pub OutputFrameRate: super::Dxgi::DXGI_RATIONAL,
    pub OutputWidth: u32,
    pub OutputHeight: u32,
    pub Usage: D3D11_VIDEO_USAGE,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_VIDEO_PROCESSOR_CONTENT_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_CONTENT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_CONTENT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_CONTENT_DESC")
            .field("InputFrameFormat", &self.InputFrameFormat)
            .field("InputFrameRate", &self.InputFrameRate)
            .field("InputWidth", &self.InputWidth)
            .field("InputHeight", &self.InputHeight)
            .field("OutputFrameRate", &self.OutputFrameRate)
            .field("OutputWidth", &self.OutputWidth)
            .field("OutputHeight", &self.OutputHeight)
            .field("Usage", &self.Usage)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_CONTENT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.InputFrameFormat == other.InputFrameFormat
            && self.InputFrameRate == other.InputFrameRate
            && self.InputWidth == other.InputWidth
            && self.InputHeight == other.InputHeight
            && self.OutputFrameRate == other.OutputFrameRate
            && self.OutputWidth == other.OutputWidth
            && self.OutputHeight == other.OutputHeight
            && self.Usage == other.Usage
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_CONTENT_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_CONTENT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {
    pub CustomRate: super::Dxgi::DXGI_RATIONAL,
    pub OutputFrames: u32,
    pub InputInterlaced: super::super::Foundation::BOOL,
    pub InputFramesOrFields: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_CUSTOM_RATE")
            .field("CustomRate", &self.CustomRate)
            .field("OutputFrames", &self.OutputFrames)
            .field("InputInterlaced", &self.InputInterlaced)
            .field("InputFramesOrFields", &self.InputFramesOrFields)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {
    fn eq(&self, other: &Self) -> bool {
        self.CustomRate == other.CustomRate
            && self.OutputFrames == other.OutputFrames
            && self.InputInterlaced == other.InputInterlaced
            && self.InputFramesOrFields == other.InputFramesOrFields
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_CUSTOM_RATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_DEVICE_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_LINEAR_SPACE: D3D11_VIDEO_PROCESSOR_DEVICE_CAPS =
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_xvYCC: D3D11_VIDEO_PROCESSOR_DEVICE_CAPS =
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_RGB_RANGE_CONVERSION:
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS = D3D11_VIDEO_PROCESSOR_DEVICE_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_YCbCr_MATRIX_CONVERSION:
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS = D3D11_VIDEO_PROCESSOR_DEVICE_CAPS(8i32);
pub const D3D11_VIDEO_PROCESSOR_DEVICE_CAPS_NOMINAL_RANGE: D3D11_VIDEO_PROCESSOR_DEVICE_CAPS =
    D3D11_VIDEO_PROCESSOR_DEVICE_CAPS(16i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_DEVICE_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_DEVICE_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_FILL: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_CONSTRICTION: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LUMA_KEY: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_PALETTE: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(8i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_LEGACY: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(16i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_STEREO: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(32i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ROTATION: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(64i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_ALPHA_STREAM: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(128i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_PIXEL_ASPECT_RATIO:
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS = D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(256i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_MIRROR: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(512i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_SHADER_USAGE: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(1024i32);
pub const D3D11_VIDEO_PROCESSOR_FEATURE_CAPS_METADATA_HDR10: D3D11_VIDEO_PROCESSOR_FEATURE_CAPS =
    D3D11_VIDEO_PROCESSOR_FEATURE_CAPS(2048i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_FEATURE_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_FEATURE_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_FILTER(pub i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_BRIGHTNESS: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(0i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CONTRAST: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(1i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_HUE: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(2i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_SATURATION: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(3i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_NOISE_REDUCTION: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(4i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_EDGE_ENHANCEMENT: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(5i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_ANAMORPHIC_SCALING: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(6i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_STEREO_ADJUSTMENT: D3D11_VIDEO_PROCESSOR_FILTER =
    D3D11_VIDEO_PROCESSOR_FILTER(7i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_FILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_FILTER_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_BRIGHTNESS: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_CONTRAST: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_HUE: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_SATURATION: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(8i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_NOISE_REDUCTION: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(16i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_EDGE_ENHANCEMENT: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(32i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_ANAMORPHIC_SCALING: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(64i32);
pub const D3D11_VIDEO_PROCESSOR_FILTER_CAPS_STEREO_ADJUSTMENT: D3D11_VIDEO_PROCESSOR_FILTER_CAPS =
    D3D11_VIDEO_PROCESSOR_FILTER_CAPS(128i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_FILTER_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_FILTER_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_PROCESSOR_FILTER_RANGE {
    pub Minimum: i32,
    pub Maximum: i32,
    pub Default: i32,
    pub Multiplier: f32,
}
impl D3D11_VIDEO_PROCESSOR_FILTER_RANGE {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_FILTER_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_FILTER_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_FILTER_RANGE")
            .field("Minimum", &self.Minimum)
            .field("Maximum", &self.Maximum)
            .field("Default", &self.Default)
            .field("Multiplier", &self.Multiplier)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_FILTER_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.Minimum == other.Minimum
            && self.Maximum == other.Maximum
            && self.Default == other.Default
            && self.Multiplier == other.Multiplier
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_FILTER_RANGE {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_FILTER_RANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_FORMAT_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_INTERLACED: D3D11_VIDEO_PROCESSOR_FORMAT_CAPS =
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_PROCAMP: D3D11_VIDEO_PROCESSOR_FORMAT_CAPS =
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_RGB_LUMA_KEY: D3D11_VIDEO_PROCESSOR_FORMAT_CAPS =
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_FORMAT_CAPS_PALETTE_INTERLACED: D3D11_VIDEO_PROCESSOR_FORMAT_CAPS =
    D3D11_VIDEO_PROCESSOR_FORMAT_CAPS(8i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_FORMAT_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_FORMAT_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT(pub i32);
pub const D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_INPUT: D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT =
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT(1i32);
pub const D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT_OUTPUT: D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT =
    D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT(2i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_FORMAT_SUPPORT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {
    pub FourCC: u32,
    pub ViewDimension: D3D11_VPIV_DIMENSION,
    pub Anonymous: D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC_0,
}
impl D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC_0 {
    pub Texture2D: D3D11_TEX2D_VPIV,
}
impl D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC_0 {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_INPUT_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_22: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2224: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_2332: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(8i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_32322: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(16i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_55: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(32i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_64: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(64i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_87: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(128i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_222222222223: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(256i32);
pub const D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS_OTHER: D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS =
    D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS(-2147483648i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_ITELECINE_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE(pub i32);
pub const D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_UNDEFINED: D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE =
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE(0i32);
pub const D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_16_235: D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE =
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE(1i32);
pub const D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE_0_255: D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE =
    D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE(2i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_NOMINAL_RANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_OUTPUT_RATE(pub i32);
pub const D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_NORMAL: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE =
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE(0i32);
pub const D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_HALF: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE =
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE(1i32);
pub const D3D11_VIDEO_PROCESSOR_OUTPUT_RATE_CUSTOM: D3D11_VIDEO_PROCESSOR_OUTPUT_RATE =
    D3D11_VIDEO_PROCESSOR_OUTPUT_RATE(2i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_OUTPUT_RATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_OUTPUT_RATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {
    pub ViewDimension: D3D11_VPOV_DIMENSION,
    pub Anonymous: D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_0,
}
impl D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_0 {
    pub Texture2D: D3D11_TEX2D_VPOV,
    pub Texture2DArray: D3D11_TEX2D_ARRAY_VPOV,
}
impl D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_0 {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_0 {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_OUTPUT_VIEW_DESC_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BLEND:
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS = D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_BOB:
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS = D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_ADAPTIVE:
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS = D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_DEINTERLACE_MOTION_COMPENSATION:
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS = D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS(8i32);
pub const D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_INVERSE_TELECINE:
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS = D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS(16i32);
pub const D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS_FRAME_RATE_CONVERSION:
    D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS = D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS(32i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_PROCESSOR_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {
    pub PastFrames: u32,
    pub FutureFrames: u32,
    pub ProcessorCaps: u32,
    pub ITelecineCaps: u32,
    pub CustomRateCount: u32,
}
impl D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {}
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS")
            .field("PastFrames", &self.PastFrames)
            .field("FutureFrames", &self.FutureFrames)
            .field("ProcessorCaps", &self.ProcessorCaps)
            .field("ITelecineCaps", &self.ITelecineCaps)
            .field("CustomRateCount", &self.CustomRateCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {
    fn eq(&self, other: &Self) -> bool {
        self.PastFrames == other.PastFrames
            && self.FutureFrames == other.FutureFrames
            && self.ProcessorCaps == other.ProcessorCaps
            && self.ITelecineCaps == other.ITelecineCaps
            && self.CustomRateCount == other.CustomRateCount
    }
}
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_RATE_CONVERSION_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_ROTATION(pub i32);
pub const D3D11_VIDEO_PROCESSOR_ROTATION_IDENTITY: D3D11_VIDEO_PROCESSOR_ROTATION =
    D3D11_VIDEO_PROCESSOR_ROTATION(0i32);
pub const D3D11_VIDEO_PROCESSOR_ROTATION_90: D3D11_VIDEO_PROCESSOR_ROTATION =
    D3D11_VIDEO_PROCESSOR_ROTATION(1i32);
pub const D3D11_VIDEO_PROCESSOR_ROTATION_180: D3D11_VIDEO_PROCESSOR_ROTATION =
    D3D11_VIDEO_PROCESSOR_ROTATION(2i32);
pub const D3D11_VIDEO_PROCESSOR_ROTATION_270: D3D11_VIDEO_PROCESSOR_ROTATION =
    D3D11_VIDEO_PROCESSOR_ROTATION(3i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_ROTATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_ROTATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_STEREO_CAPS(pub i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_CAPS_MONO_OFFSET: D3D11_VIDEO_PROCESSOR_STEREO_CAPS =
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS(1i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_CAPS_ROW_INTERLEAVED: D3D11_VIDEO_PROCESSOR_STEREO_CAPS =
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS(2i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_CAPS_COLUMN_INTERLEAVED: D3D11_VIDEO_PROCESSOR_STEREO_CAPS =
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS(4i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_CAPS_CHECKERBOARD: D3D11_VIDEO_PROCESSOR_STEREO_CAPS =
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS(8i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_CAPS_FLIP_MODE: D3D11_VIDEO_PROCESSOR_STEREO_CAPS =
    D3D11_VIDEO_PROCESSOR_STEREO_CAPS(16i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_STEREO_CAPS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_STEREO_CAPS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE(pub i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FLIP_NONE: D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE =
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE(0i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME0: D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE =
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE(1i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FLIP_FRAME1: D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE =
    D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE(2i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_STEREO_FLIP_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(pub i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT =
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(0i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_HORIZONTAL: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT =
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(1i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_VERTICAL: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT =
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(2i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_SEPARATE: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT =
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(3i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_MONO_OFFSET: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT =
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(4i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_ROW_INTERLEAVED: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT =
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(5i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_COLUMN_INTERLEAVED:
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT = D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(6i32);
pub const D3D11_VIDEO_PROCESSOR_STEREO_FORMAT_CHECKERBOARD: D3D11_VIDEO_PROCESSOR_STEREO_FORMAT =
    D3D11_VIDEO_PROCESSOR_STEREO_FORMAT(7i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_PROCESSOR_STEREO_FORMAT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_STEREO_FORMAT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D11_VIDEO_PROCESSOR_STREAM {
    pub Enable: super::super::Foundation::BOOL,
    pub OutputIndex: u32,
    pub InputFrameOrField: u32,
    pub PastFrames: u32,
    pub FutureFrames: u32,
    pub ppPastSurfaces: *mut ::std::option::Option<ID3D11VideoProcessorInputView>,
    pub pInputSurface: ::std::option::Option<ID3D11VideoProcessorInputView>,
    pub ppFutureSurfaces: *mut ::std::option::Option<ID3D11VideoProcessorInputView>,
    pub ppPastSurfacesRight: *mut ::std::option::Option<ID3D11VideoProcessorInputView>,
    pub pInputSurfaceRight: ::std::option::Option<ID3D11VideoProcessorInputView>,
    pub ppFutureSurfacesRight: *mut ::std::option::Option<ID3D11VideoProcessorInputView>,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D11_VIDEO_PROCESSOR_STREAM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_STREAM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_STREAM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_STREAM")
            .field("Enable", &self.Enable)
            .field("OutputIndex", &self.OutputIndex)
            .field("InputFrameOrField", &self.InputFrameOrField)
            .field("PastFrames", &self.PastFrames)
            .field("FutureFrames", &self.FutureFrames)
            .field("ppPastSurfaces", &self.ppPastSurfaces)
            .field("pInputSurface", &self.pInputSurface)
            .field("ppFutureSurfaces", &self.ppFutureSurfaces)
            .field("ppPastSurfacesRight", &self.ppPastSurfacesRight)
            .field("pInputSurfaceRight", &self.pInputSurfaceRight)
            .field("ppFutureSurfacesRight", &self.ppFutureSurfacesRight)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_STREAM {
    fn eq(&self, other: &Self) -> bool {
        self.Enable == other.Enable
            && self.OutputIndex == other.OutputIndex
            && self.InputFrameOrField == other.InputFrameOrField
            && self.PastFrames == other.PastFrames
            && self.FutureFrames == other.FutureFrames
            && self.ppPastSurfaces == other.ppPastSurfaces
            && self.pInputSurface == other.pInputSurface
            && self.ppFutureSurfaces == other.ppFutureSurfaces
            && self.ppPastSurfacesRight == other.ppPastSurfacesRight
            && self.pInputSurfaceRight == other.pInputSurfaceRight
            && self.ppFutureSurfacesRight == other.ppFutureSurfacesRight
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_STREAM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_STREAM {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT {
    pub Enable: super::super::Foundation::BOOL,
    pub Width: u32,
    pub Height: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT")
            .field("Enable", &self.Enable)
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("Format", &self.Format)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT {
    fn eq(&self, other: &Self) -> bool {
        self.Enable == other.Enable
            && self.Width == other.Width
            && self.Height == other.Height
            && self.Format == other.Format
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_PROCESSOR_STREAM_BEHAVIOR_HINT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D3D11_VIDEO_SAMPLE_DESC {
    pub Width: u32,
    pub Height: u32,
    pub Format: super::Dxgi::DXGI_FORMAT,
    pub ColorSpace: super::Dxgi::DXGI_COLOR_SPACE_TYPE,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D3D11_VIDEO_SAMPLE_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D3D11_VIDEO_SAMPLE_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D3D11_VIDEO_SAMPLE_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIDEO_SAMPLE_DESC")
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("Format", &self.Format)
            .field("ColorSpace", &self.ColorSpace)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D3D11_VIDEO_SAMPLE_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.Width == other.Width
            && self.Height == other.Height
            && self.Format == other.Format
            && self.ColorSpace == other.ColorSpace
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D3D11_VIDEO_SAMPLE_DESC {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_SAMPLE_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VIDEO_USAGE(pub i32);
pub const D3D11_VIDEO_USAGE_PLAYBACK_NORMAL: D3D11_VIDEO_USAGE = D3D11_VIDEO_USAGE(0i32);
pub const D3D11_VIDEO_USAGE_OPTIMAL_SPEED: D3D11_VIDEO_USAGE = D3D11_VIDEO_USAGE(1i32);
pub const D3D11_VIDEO_USAGE_OPTIMAL_QUALITY: D3D11_VIDEO_USAGE = D3D11_VIDEO_USAGE(2i32);
impl ::std::convert::From<i32> for D3D11_VIDEO_USAGE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VIDEO_USAGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3D11_VIEWPORT {
    pub TopLeftX: f32,
    pub TopLeftY: f32,
    pub Width: f32,
    pub Height: f32,
    pub MinDepth: f32,
    pub MaxDepth: f32,
}
impl D3D11_VIEWPORT {}
impl ::std::default::Default for D3D11_VIEWPORT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3D11_VIEWPORT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D11_VIEWPORT")
            .field("TopLeftX", &self.TopLeftX)
            .field("TopLeftY", &self.TopLeftY)
            .field("Width", &self.Width)
            .field("Height", &self.Height)
            .field("MinDepth", &self.MinDepth)
            .field("MaxDepth", &self.MaxDepth)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3D11_VIEWPORT {
    fn eq(&self, other: &Self) -> bool {
        self.TopLeftX == other.TopLeftX
            && self.TopLeftY == other.TopLeftY
            && self.Width == other.Width
            && self.Height == other.Height
            && self.MinDepth == other.MinDepth
            && self.MaxDepth == other.MaxDepth
    }
}
impl ::std::cmp::Eq for D3D11_VIEWPORT {}
unsafe impl ::windows::runtime::Abi for D3D11_VIEWPORT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_VIEWPORT_AND_SCISSORRECT_MAX_INDEX: u32 = 15u32;
pub const D3D11_VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE: u32 = 16u32;
pub const D3D11_VIEWPORT_BOUNDS_MAX: u32 = 32767u32;
pub const D3D11_VIEWPORT_BOUNDS_MIN: i32 = -32768i32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VPIV_DIMENSION(pub i32);
pub const D3D11_VPIV_DIMENSION_UNKNOWN: D3D11_VPIV_DIMENSION = D3D11_VPIV_DIMENSION(0i32);
pub const D3D11_VPIV_DIMENSION_TEXTURE2D: D3D11_VPIV_DIMENSION = D3D11_VPIV_DIMENSION(1i32);
impl ::std::convert::From<i32> for D3D11_VPIV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VPIV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D11_VPOV_DIMENSION(pub i32);
pub const D3D11_VPOV_DIMENSION_UNKNOWN: D3D11_VPOV_DIMENSION = D3D11_VPOV_DIMENSION(0i32);
pub const D3D11_VPOV_DIMENSION_TEXTURE2D: D3D11_VPOV_DIMENSION = D3D11_VPOV_DIMENSION(1i32);
pub const D3D11_VPOV_DIMENSION_TEXTURE2DARRAY: D3D11_VPOV_DIMENSION = D3D11_VPOV_DIMENSION(2i32);
impl ::std::convert::From<i32> for D3D11_VPOV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D11_VPOV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D11_VS_INPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_VS_INPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_VS_INPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_VS_INPUT_REGISTER_READS_PER_INST: u32 = 2u32;
pub const D3D11_VS_INPUT_REGISTER_READ_PORTS: u32 = 1u32;
pub const D3D11_VS_OUTPUT_REGISTER_COMPONENTS: u32 = 4u32;
pub const D3D11_VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT: u32 = 32u32;
pub const D3D11_VS_OUTPUT_REGISTER_COUNT: u32 = 32u32;
pub const D3D11_WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT: u32 = 10u32;
pub const D3D11_WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP: u32 = 25u32;
pub const D3D11_WHQL_DRAW_VERTEX_COUNT_2_TO_EXP: u32 = 25u32;
pub unsafe fn D3DDisassemble11Trace<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, ID3D11ShaderTrace>,
>(
    psrcdata: *const ::std::ffi::c_void,
    srcdatasize: usize,
    ptrace: Param2,
    startstep: u32,
    numsteps: u32,
    flags: u32,
) -> ::windows::runtime::Result<ID3DBlob> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DDisassemble11Trace(
                psrcdata: *const ::std::ffi::c_void,
                srcdatasize: usize,
                ptrace: ::windows::runtime::RawPtr,
                startstep: u32,
                numsteps: u32,
                flags: u32,
                ppdisassembly: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <ID3DBlob as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        D3DDisassemble11Trace(
            ::std::mem::transmute(psrcdata),
            ::std::mem::transmute(srcdatasize),
            ptrace.into_param().abi(),
            ::std::mem::transmute(startstep),
            ::std::mem::transmute(numsteps),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<ID3DBlob>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateFFT<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    pdesc: *const D3DX11_FFT_DESC,
    flags: u32,
    pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
    ppfft: *mut ::std::option::Option<ID3DX11FFT>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateFFT(
                pdevicecontext: ::windows::runtime::RawPtr,
                pdesc: *const D3DX11_FFT_DESC,
                flags: u32,
                pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
                ppfft: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3DX11CreateFFT(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pbufferinfo),
            ::std::mem::transmute(ppfft),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateFFT1DComplex<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    x: u32,
    flags: u32,
    pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
    ppfft: *mut ::std::option::Option<ID3DX11FFT>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateFFT1DComplex(
                pdevicecontext: ::windows::runtime::RawPtr,
                x: u32,
                flags: u32,
                pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
                ppfft: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3DX11CreateFFT1DComplex(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(x),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pbufferinfo),
            ::std::mem::transmute(ppfft),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateFFT1DReal<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    x: u32,
    flags: u32,
    pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
    ppfft: *mut ::std::option::Option<ID3DX11FFT>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateFFT1DReal(
                pdevicecontext: ::windows::runtime::RawPtr,
                x: u32,
                flags: u32,
                pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
                ppfft: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3DX11CreateFFT1DReal(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(x),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pbufferinfo),
            ::std::mem::transmute(ppfft),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateFFT2DComplex<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    x: u32,
    y: u32,
    flags: u32,
    pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
    ppfft: *mut ::std::option::Option<ID3DX11FFT>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateFFT2DComplex(
                pdevicecontext: ::windows::runtime::RawPtr,
                x: u32,
                y: u32,
                flags: u32,
                pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
                ppfft: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3DX11CreateFFT2DComplex(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pbufferinfo),
            ::std::mem::transmute(ppfft),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateFFT2DReal<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    x: u32,
    y: u32,
    flags: u32,
    pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
    ppfft: *mut ::std::option::Option<ID3DX11FFT>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateFFT2DReal(
                pdevicecontext: ::windows::runtime::RawPtr,
                x: u32,
                y: u32,
                flags: u32,
                pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
                ppfft: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3DX11CreateFFT2DReal(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pbufferinfo),
            ::std::mem::transmute(ppfft),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateFFT3DComplex<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    x: u32,
    y: u32,
    z: u32,
    flags: u32,
    pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
    ppfft: *mut ::std::option::Option<ID3DX11FFT>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateFFT3DComplex(
                pdevicecontext: ::windows::runtime::RawPtr,
                x: u32,
                y: u32,
                z: u32,
                flags: u32,
                pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
                ppfft: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3DX11CreateFFT3DComplex(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            ::std::mem::transmute(z),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pbufferinfo),
            ::std::mem::transmute(ppfft),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateFFT3DReal<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    x: u32,
    y: u32,
    z: u32,
    flags: u32,
    pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
    ppfft: *mut ::std::option::Option<ID3DX11FFT>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateFFT3DReal(
                pdevicecontext: ::windows::runtime::RawPtr,
                x: u32,
                y: u32,
                z: u32,
                flags: u32,
                pbufferinfo: *mut D3DX11_FFT_BUFFER_INFO,
                ppfft: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        D3DX11CreateFFT3DReal(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            ::std::mem::transmute(z),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pbufferinfo),
            ::std::mem::transmute(ppfft),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateScan<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    maxelementscansize: u32,
    maxscancount: u32,
) -> ::windows::runtime::Result<ID3DX11Scan> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateScan(
                pdevicecontext: ::windows::runtime::RawPtr,
                maxelementscansize: u32,
                maxscancount: u32,
                ppscan: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <ID3DX11Scan as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        D3DX11CreateScan(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(maxelementscansize),
            ::std::mem::transmute(maxscancount),
            &mut result__,
        )
        .from_abi::<ID3DX11Scan>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D3DX11CreateSegmentedScan<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
>(
    pdevicecontext: Param0,
    maxelementscansize: u32,
) -> ::windows::runtime::Result<ID3DX11SegmentedScan> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D3DX11CreateSegmentedScan(
                pdevicecontext: ::windows::runtime::RawPtr,
                maxelementscansize: u32,
                ppscan: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <ID3DX11SegmentedScan as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        D3DX11CreateSegmentedScan(
            pdevicecontext.into_param().abi(),
            ::std::mem::transmute(maxelementscansize),
            &mut result__,
        )
        .from_abi::<ID3DX11SegmentedScan>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3DX11_FFT_BUFFER_INFO {
    pub NumTempBufferSizes: u32,
    pub TempBufferFloatSizes: [u32; 4],
    pub NumPrecomputeBufferSizes: u32,
    pub PrecomputeBufferFloatSizes: [u32; 4],
}
impl D3DX11_FFT_BUFFER_INFO {}
impl ::std::default::Default for D3DX11_FFT_BUFFER_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DX11_FFT_BUFFER_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DX11_FFT_BUFFER_INFO")
            .field("NumTempBufferSizes", &self.NumTempBufferSizes)
            .field("TempBufferFloatSizes", &self.TempBufferFloatSizes)
            .field("NumPrecomputeBufferSizes", &self.NumPrecomputeBufferSizes)
            .field(
                "PrecomputeBufferFloatSizes",
                &self.PrecomputeBufferFloatSizes,
            )
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DX11_FFT_BUFFER_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.NumTempBufferSizes == other.NumTempBufferSizes
            && self.TempBufferFloatSizes == other.TempBufferFloatSizes
            && self.NumPrecomputeBufferSizes == other.NumPrecomputeBufferSizes
            && self.PrecomputeBufferFloatSizes == other.PrecomputeBufferFloatSizes
    }
}
impl ::std::cmp::Eq for D3DX11_FFT_BUFFER_INFO {}
unsafe impl ::windows::runtime::Abi for D3DX11_FFT_BUFFER_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3DX11_FFT_CREATE_FLAG(pub i32);
pub const D3DX11_FFT_CREATE_FLAG_NO_PRECOMPUTE_BUFFERS: D3DX11_FFT_CREATE_FLAG =
    D3DX11_FFT_CREATE_FLAG(1i32);
impl ::std::convert::From<i32> for D3DX11_FFT_CREATE_FLAG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DX11_FFT_CREATE_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3DX11_FFT_DATA_TYPE(pub i32);
pub const D3DX11_FFT_DATA_TYPE_REAL: D3DX11_FFT_DATA_TYPE = D3DX11_FFT_DATA_TYPE(0i32);
pub const D3DX11_FFT_DATA_TYPE_COMPLEX: D3DX11_FFT_DATA_TYPE = D3DX11_FFT_DATA_TYPE(1i32);
impl ::std::convert::From<i32> for D3DX11_FFT_DATA_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DX11_FFT_DATA_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D3DX11_FFT_DESC {
    pub NumDimensions: u32,
    pub ElementLengths: [u32; 32],
    pub DimensionMask: u32,
    pub Type: D3DX11_FFT_DATA_TYPE,
}
impl D3DX11_FFT_DESC {}
impl ::std::default::Default for D3DX11_FFT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D3DX11_FFT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3DX11_FFT_DESC")
            .field("NumDimensions", &self.NumDimensions)
            .field("ElementLengths", &self.ElementLengths)
            .field("DimensionMask", &self.DimensionMask)
            .field("Type", &self.Type)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D3DX11_FFT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.NumDimensions == other.NumDimensions
            && self.ElementLengths == other.ElementLengths
            && self.DimensionMask == other.DimensionMask
            && self.Type == other.Type
    }
}
impl ::std::cmp::Eq for D3DX11_FFT_DESC {}
unsafe impl ::windows::runtime::Abi for D3DX11_FFT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3DX11_FFT_DIM_MASK(pub i32);
pub const D3DX11_FFT_DIM_MASK_1D: D3DX11_FFT_DIM_MASK = D3DX11_FFT_DIM_MASK(1i32);
pub const D3DX11_FFT_DIM_MASK_2D: D3DX11_FFT_DIM_MASK = D3DX11_FFT_DIM_MASK(3i32);
pub const D3DX11_FFT_DIM_MASK_3D: D3DX11_FFT_DIM_MASK = D3DX11_FFT_DIM_MASK(7i32);
impl ::std::convert::From<i32> for D3DX11_FFT_DIM_MASK {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DX11_FFT_DIM_MASK {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3DX11_FFT_MAX_DIMENSIONS: u32 = 32u32;
pub const D3DX11_FFT_MAX_PRECOMPUTE_BUFFERS: u32 = 4u32;
pub const D3DX11_FFT_MAX_TEMP_BUFFERS: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3DX11_SCAN_DATA_TYPE(pub i32);
pub const D3DX11_SCAN_DATA_TYPE_FLOAT: D3DX11_SCAN_DATA_TYPE = D3DX11_SCAN_DATA_TYPE(1i32);
pub const D3DX11_SCAN_DATA_TYPE_INT: D3DX11_SCAN_DATA_TYPE = D3DX11_SCAN_DATA_TYPE(2i32);
pub const D3DX11_SCAN_DATA_TYPE_UINT: D3DX11_SCAN_DATA_TYPE = D3DX11_SCAN_DATA_TYPE(3i32);
impl ::std::convert::From<i32> for D3DX11_SCAN_DATA_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DX11_SCAN_DATA_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3DX11_SCAN_DIRECTION(pub i32);
pub const D3DX11_SCAN_DIRECTION_FORWARD: D3DX11_SCAN_DIRECTION = D3DX11_SCAN_DIRECTION(1i32);
pub const D3DX11_SCAN_DIRECTION_BACKWARD: D3DX11_SCAN_DIRECTION = D3DX11_SCAN_DIRECTION(2i32);
impl ::std::convert::From<i32> for D3DX11_SCAN_DIRECTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DX11_SCAN_DIRECTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3DX11_SCAN_OPCODE(pub i32);
pub const D3DX11_SCAN_OPCODE_ADD: D3DX11_SCAN_OPCODE = D3DX11_SCAN_OPCODE(1i32);
pub const D3DX11_SCAN_OPCODE_MIN: D3DX11_SCAN_OPCODE = D3DX11_SCAN_OPCODE(2i32);
pub const D3DX11_SCAN_OPCODE_MAX: D3DX11_SCAN_OPCODE = D3DX11_SCAN_OPCODE(3i32);
pub const D3DX11_SCAN_OPCODE_MUL: D3DX11_SCAN_OPCODE = D3DX11_SCAN_OPCODE(4i32);
pub const D3DX11_SCAN_OPCODE_AND: D3DX11_SCAN_OPCODE = D3DX11_SCAN_OPCODE(5i32);
pub const D3DX11_SCAN_OPCODE_OR: D3DX11_SCAN_OPCODE = D3DX11_SCAN_OPCODE(6i32);
pub const D3DX11_SCAN_OPCODE_XOR: D3DX11_SCAN_OPCODE = D3DX11_SCAN_OPCODE(7i32);
impl ::std::convert::From<i32> for D3DX11_SCAN_OPCODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3DX11_SCAN_OPCODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_CBUFFER_TYPE(pub i32);
pub const D3D_CT_CBUFFER: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(0i32);
pub const D3D_CT_TBUFFER: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(1i32);
pub const D3D_CT_INTERFACE_POINTERS: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(2i32);
pub const D3D_CT_RESOURCE_BIND_INFO: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(3i32);
pub const D3D10_CT_CBUFFER: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(0i32);
pub const D3D10_CT_TBUFFER: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(1i32);
pub const D3D11_CT_CBUFFER: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(0i32);
pub const D3D11_CT_TBUFFER: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(1i32);
pub const D3D11_CT_INTERFACE_POINTERS: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(2i32);
pub const D3D11_CT_RESOURCE_BIND_INFO: D3D_CBUFFER_TYPE = D3D_CBUFFER_TYPE(3i32);
impl ::std::convert::From<i32> for D3D_CBUFFER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_CBUFFER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D_COMPONENT_MASK_W: u32 = 8u32;
pub const D3D_COMPONENT_MASK_X: u32 = 1u32;
pub const D3D_COMPONENT_MASK_Y: u32 = 2u32;
pub const D3D_COMPONENT_MASK_Z: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_DRIVER_TYPE(pub i32);
pub const D3D_DRIVER_TYPE_UNKNOWN: D3D_DRIVER_TYPE = D3D_DRIVER_TYPE(0i32);
pub const D3D_DRIVER_TYPE_HARDWARE: D3D_DRIVER_TYPE = D3D_DRIVER_TYPE(1i32);
pub const D3D_DRIVER_TYPE_REFERENCE: D3D_DRIVER_TYPE = D3D_DRIVER_TYPE(2i32);
pub const D3D_DRIVER_TYPE_NULL: D3D_DRIVER_TYPE = D3D_DRIVER_TYPE(3i32);
pub const D3D_DRIVER_TYPE_SOFTWARE: D3D_DRIVER_TYPE = D3D_DRIVER_TYPE(4i32);
pub const D3D_DRIVER_TYPE_WARP: D3D_DRIVER_TYPE = D3D_DRIVER_TYPE(5i32);
impl ::std::convert::From<i32> for D3D_DRIVER_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_DRIVER_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_FEATURE_LEVEL(pub i32);
pub const D3D_FEATURE_LEVEL_1_0_CORE: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(4096i32);
pub const D3D_FEATURE_LEVEL_9_1: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(37120i32);
pub const D3D_FEATURE_LEVEL_9_2: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(37376i32);
pub const D3D_FEATURE_LEVEL_9_3: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(37632i32);
pub const D3D_FEATURE_LEVEL_10_0: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(40960i32);
pub const D3D_FEATURE_LEVEL_10_1: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(41216i32);
pub const D3D_FEATURE_LEVEL_11_0: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(45056i32);
pub const D3D_FEATURE_LEVEL_11_1: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(45312i32);
pub const D3D_FEATURE_LEVEL_12_0: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(49152i32);
pub const D3D_FEATURE_LEVEL_12_1: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(49408i32);
pub const D3D_FEATURE_LEVEL_12_2: D3D_FEATURE_LEVEL = D3D_FEATURE_LEVEL(49664i32);
impl ::std::convert::From<i32> for D3D_FEATURE_LEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_FEATURE_LEVEL {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D_FL9_1_DEFAULT_MAX_ANISOTROPY: u32 = 2u32;
pub const D3D_FL9_1_IA_PRIMITIVE_MAX_COUNT: u32 = 65535u32;
pub const D3D_FL9_1_MAX_TEXTURE_REPEAT: u32 = 128u32;
pub const D3D_FL9_1_REQ_TEXTURE1D_U_DIMENSION: u32 = 2048u32;
pub const D3D_FL9_1_REQ_TEXTURE2D_U_OR_V_DIMENSION: u32 = 2048u32;
pub const D3D_FL9_1_REQ_TEXTURE3D_U_V_OR_W_DIMENSION: u32 = 256u32;
pub const D3D_FL9_1_REQ_TEXTURECUBE_DIMENSION: u32 = 512u32;
pub const D3D_FL9_1_SIMULTANEOUS_RENDER_TARGET_COUNT: u32 = 1u32;
pub const D3D_FL9_2_IA_PRIMITIVE_MAX_COUNT: u32 = 1048575u32;
pub const D3D_FL9_2_MAX_TEXTURE_REPEAT: u32 = 2048u32;
pub const D3D_FL9_3_MAX_TEXTURE_REPEAT: u32 = 8192u32;
pub const D3D_FL9_3_REQ_TEXTURE1D_U_DIMENSION: u32 = 4096u32;
pub const D3D_FL9_3_REQ_TEXTURE2D_U_OR_V_DIMENSION: u32 = 4096u32;
pub const D3D_FL9_3_REQ_TEXTURECUBE_DIMENSION: u32 = 4096u32;
pub const D3D_FL9_3_SIMULTANEOUS_RENDER_TARGET_COUNT: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_INCLUDE_TYPE(pub i32);
pub const D3D_INCLUDE_LOCAL: D3D_INCLUDE_TYPE = D3D_INCLUDE_TYPE(0i32);
pub const D3D_INCLUDE_SYSTEM: D3D_INCLUDE_TYPE = D3D_INCLUDE_TYPE(1i32);
pub const D3D10_INCLUDE_LOCAL: D3D_INCLUDE_TYPE = D3D_INCLUDE_TYPE(0i32);
pub const D3D10_INCLUDE_SYSTEM: D3D_INCLUDE_TYPE = D3D_INCLUDE_TYPE(1i32);
pub const D3D_INCLUDE_FORCE_DWORD: D3D_INCLUDE_TYPE = D3D_INCLUDE_TYPE(2147483647i32);
impl ::std::convert::From<i32> for D3D_INCLUDE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_INCLUDE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_INTERPOLATION_MODE(pub i32);
pub const D3D_INTERPOLATION_UNDEFINED: D3D_INTERPOLATION_MODE = D3D_INTERPOLATION_MODE(0i32);
pub const D3D_INTERPOLATION_CONSTANT: D3D_INTERPOLATION_MODE = D3D_INTERPOLATION_MODE(1i32);
pub const D3D_INTERPOLATION_LINEAR: D3D_INTERPOLATION_MODE = D3D_INTERPOLATION_MODE(2i32);
pub const D3D_INTERPOLATION_LINEAR_CENTROID: D3D_INTERPOLATION_MODE = D3D_INTERPOLATION_MODE(3i32);
pub const D3D_INTERPOLATION_LINEAR_NOPERSPECTIVE: D3D_INTERPOLATION_MODE =
    D3D_INTERPOLATION_MODE(4i32);
pub const D3D_INTERPOLATION_LINEAR_NOPERSPECTIVE_CENTROID: D3D_INTERPOLATION_MODE =
    D3D_INTERPOLATION_MODE(5i32);
pub const D3D_INTERPOLATION_LINEAR_SAMPLE: D3D_INTERPOLATION_MODE = D3D_INTERPOLATION_MODE(6i32);
pub const D3D_INTERPOLATION_LINEAR_NOPERSPECTIVE_SAMPLE: D3D_INTERPOLATION_MODE =
    D3D_INTERPOLATION_MODE(7i32);
impl ::std::convert::From<i32> for D3D_INTERPOLATION_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_MIN_PRECISION(pub i32);
pub const D3D_MIN_PRECISION_DEFAULT: D3D_MIN_PRECISION = D3D_MIN_PRECISION(0i32);
pub const D3D_MIN_PRECISION_FLOAT_16: D3D_MIN_PRECISION = D3D_MIN_PRECISION(1i32);
pub const D3D_MIN_PRECISION_FLOAT_2_8: D3D_MIN_PRECISION = D3D_MIN_PRECISION(2i32);
pub const D3D_MIN_PRECISION_RESERVED: D3D_MIN_PRECISION = D3D_MIN_PRECISION(3i32);
pub const D3D_MIN_PRECISION_SINT_16: D3D_MIN_PRECISION = D3D_MIN_PRECISION(4i32);
pub const D3D_MIN_PRECISION_UINT_16: D3D_MIN_PRECISION = D3D_MIN_PRECISION(5i32);
pub const D3D_MIN_PRECISION_ANY_16: D3D_MIN_PRECISION = D3D_MIN_PRECISION(240i32);
pub const D3D_MIN_PRECISION_ANY_10: D3D_MIN_PRECISION = D3D_MIN_PRECISION(241i32);
impl ::std::convert::From<i32> for D3D_MIN_PRECISION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_MIN_PRECISION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_NAME(pub i32);
pub const D3D_NAME_UNDEFINED: D3D_NAME = D3D_NAME(0i32);
pub const D3D_NAME_POSITION: D3D_NAME = D3D_NAME(1i32);
pub const D3D_NAME_CLIP_DISTANCE: D3D_NAME = D3D_NAME(2i32);
pub const D3D_NAME_CULL_DISTANCE: D3D_NAME = D3D_NAME(3i32);
pub const D3D_NAME_RENDER_TARGET_ARRAY_INDEX: D3D_NAME = D3D_NAME(4i32);
pub const D3D_NAME_VIEWPORT_ARRAY_INDEX: D3D_NAME = D3D_NAME(5i32);
pub const D3D_NAME_VERTEX_ID: D3D_NAME = D3D_NAME(6i32);
pub const D3D_NAME_PRIMITIVE_ID: D3D_NAME = D3D_NAME(7i32);
pub const D3D_NAME_INSTANCE_ID: D3D_NAME = D3D_NAME(8i32);
pub const D3D_NAME_IS_FRONT_FACE: D3D_NAME = D3D_NAME(9i32);
pub const D3D_NAME_SAMPLE_INDEX: D3D_NAME = D3D_NAME(10i32);
pub const D3D_NAME_FINAL_QUAD_EDGE_TESSFACTOR: D3D_NAME = D3D_NAME(11i32);
pub const D3D_NAME_FINAL_QUAD_INSIDE_TESSFACTOR: D3D_NAME = D3D_NAME(12i32);
pub const D3D_NAME_FINAL_TRI_EDGE_TESSFACTOR: D3D_NAME = D3D_NAME(13i32);
pub const D3D_NAME_FINAL_TRI_INSIDE_TESSFACTOR: D3D_NAME = D3D_NAME(14i32);
pub const D3D_NAME_FINAL_LINE_DETAIL_TESSFACTOR: D3D_NAME = D3D_NAME(15i32);
pub const D3D_NAME_FINAL_LINE_DENSITY_TESSFACTOR: D3D_NAME = D3D_NAME(16i32);
pub const D3D_NAME_BARYCENTRICS: D3D_NAME = D3D_NAME(23i32);
pub const D3D_NAME_SHADINGRATE: D3D_NAME = D3D_NAME(24i32);
pub const D3D_NAME_CULLPRIMITIVE: D3D_NAME = D3D_NAME(25i32);
pub const D3D_NAME_TARGET: D3D_NAME = D3D_NAME(64i32);
pub const D3D_NAME_DEPTH: D3D_NAME = D3D_NAME(65i32);
pub const D3D_NAME_COVERAGE: D3D_NAME = D3D_NAME(66i32);
pub const D3D_NAME_DEPTH_GREATER_EQUAL: D3D_NAME = D3D_NAME(67i32);
pub const D3D_NAME_DEPTH_LESS_EQUAL: D3D_NAME = D3D_NAME(68i32);
pub const D3D_NAME_STENCIL_REF: D3D_NAME = D3D_NAME(69i32);
pub const D3D_NAME_INNER_COVERAGE: D3D_NAME = D3D_NAME(70i32);
pub const D3D10_NAME_UNDEFINED: D3D_NAME = D3D_NAME(0i32);
pub const D3D10_NAME_POSITION: D3D_NAME = D3D_NAME(1i32);
pub const D3D10_NAME_CLIP_DISTANCE: D3D_NAME = D3D_NAME(2i32);
pub const D3D10_NAME_CULL_DISTANCE: D3D_NAME = D3D_NAME(3i32);
pub const D3D10_NAME_RENDER_TARGET_ARRAY_INDEX: D3D_NAME = D3D_NAME(4i32);
pub const D3D10_NAME_VIEWPORT_ARRAY_INDEX: D3D_NAME = D3D_NAME(5i32);
pub const D3D10_NAME_VERTEX_ID: D3D_NAME = D3D_NAME(6i32);
pub const D3D10_NAME_PRIMITIVE_ID: D3D_NAME = D3D_NAME(7i32);
pub const D3D10_NAME_INSTANCE_ID: D3D_NAME = D3D_NAME(8i32);
pub const D3D10_NAME_IS_FRONT_FACE: D3D_NAME = D3D_NAME(9i32);
pub const D3D10_NAME_SAMPLE_INDEX: D3D_NAME = D3D_NAME(10i32);
pub const D3D10_NAME_TARGET: D3D_NAME = D3D_NAME(64i32);
pub const D3D10_NAME_DEPTH: D3D_NAME = D3D_NAME(65i32);
pub const D3D10_NAME_COVERAGE: D3D_NAME = D3D_NAME(66i32);
pub const D3D11_NAME_FINAL_QUAD_EDGE_TESSFACTOR: D3D_NAME = D3D_NAME(11i32);
pub const D3D11_NAME_FINAL_QUAD_INSIDE_TESSFACTOR: D3D_NAME = D3D_NAME(12i32);
pub const D3D11_NAME_FINAL_TRI_EDGE_TESSFACTOR: D3D_NAME = D3D_NAME(13i32);
pub const D3D11_NAME_FINAL_TRI_INSIDE_TESSFACTOR: D3D_NAME = D3D_NAME(14i32);
pub const D3D11_NAME_FINAL_LINE_DETAIL_TESSFACTOR: D3D_NAME = D3D_NAME(15i32);
pub const D3D11_NAME_FINAL_LINE_DENSITY_TESSFACTOR: D3D_NAME = D3D_NAME(16i32);
pub const D3D11_NAME_DEPTH_GREATER_EQUAL: D3D_NAME = D3D_NAME(67i32);
pub const D3D11_NAME_DEPTH_LESS_EQUAL: D3D_NAME = D3D_NAME(68i32);
pub const D3D11_NAME_STENCIL_REF: D3D_NAME = D3D_NAME(69i32);
pub const D3D11_NAME_INNER_COVERAGE: D3D_NAME = D3D_NAME(70i32);
pub const D3D12_NAME_BARYCENTRICS: D3D_NAME = D3D_NAME(23i32);
pub const D3D12_NAME_SHADINGRATE: D3D_NAME = D3D_NAME(24i32);
pub const D3D12_NAME_CULLPRIMITIVE: D3D_NAME = D3D_NAME(25i32);
impl ::std::convert::From<i32> for D3D_NAME {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_NAME {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_PARAMETER_FLAGS(pub i32);
pub const D3D_PF_NONE: D3D_PARAMETER_FLAGS = D3D_PARAMETER_FLAGS(0i32);
pub const D3D_PF_IN: D3D_PARAMETER_FLAGS = D3D_PARAMETER_FLAGS(1i32);
pub const D3D_PF_OUT: D3D_PARAMETER_FLAGS = D3D_PARAMETER_FLAGS(2i32);
pub const D3D_PF_FORCE_DWORD: D3D_PARAMETER_FLAGS = D3D_PARAMETER_FLAGS(2147483647i32);
impl ::std::convert::From<i32> for D3D_PARAMETER_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_PARAMETER_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_PRIMITIVE(pub i32);
pub const D3D_PRIMITIVE_UNDEFINED: D3D_PRIMITIVE = D3D_PRIMITIVE(0i32);
pub const D3D_PRIMITIVE_POINT: D3D_PRIMITIVE = D3D_PRIMITIVE(1i32);
pub const D3D_PRIMITIVE_LINE: D3D_PRIMITIVE = D3D_PRIMITIVE(2i32);
pub const D3D_PRIMITIVE_TRIANGLE: D3D_PRIMITIVE = D3D_PRIMITIVE(3i32);
pub const D3D_PRIMITIVE_LINE_ADJ: D3D_PRIMITIVE = D3D_PRIMITIVE(6i32);
pub const D3D_PRIMITIVE_TRIANGLE_ADJ: D3D_PRIMITIVE = D3D_PRIMITIVE(7i32);
pub const D3D_PRIMITIVE_1_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(8i32);
pub const D3D_PRIMITIVE_2_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(9i32);
pub const D3D_PRIMITIVE_3_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(10i32);
pub const D3D_PRIMITIVE_4_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(11i32);
pub const D3D_PRIMITIVE_5_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(12i32);
pub const D3D_PRIMITIVE_6_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(13i32);
pub const D3D_PRIMITIVE_7_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(14i32);
pub const D3D_PRIMITIVE_8_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(15i32);
pub const D3D_PRIMITIVE_9_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(16i32);
pub const D3D_PRIMITIVE_10_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(17i32);
pub const D3D_PRIMITIVE_11_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(18i32);
pub const D3D_PRIMITIVE_12_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(19i32);
pub const D3D_PRIMITIVE_13_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(20i32);
pub const D3D_PRIMITIVE_14_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(21i32);
pub const D3D_PRIMITIVE_15_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(22i32);
pub const D3D_PRIMITIVE_16_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(23i32);
pub const D3D_PRIMITIVE_17_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(24i32);
pub const D3D_PRIMITIVE_18_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(25i32);
pub const D3D_PRIMITIVE_19_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(26i32);
pub const D3D_PRIMITIVE_20_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(27i32);
pub const D3D_PRIMITIVE_21_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(28i32);
pub const D3D_PRIMITIVE_22_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(29i32);
pub const D3D_PRIMITIVE_23_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(30i32);
pub const D3D_PRIMITIVE_24_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(31i32);
pub const D3D_PRIMITIVE_25_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(32i32);
pub const D3D_PRIMITIVE_26_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(33i32);
pub const D3D_PRIMITIVE_27_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(34i32);
pub const D3D_PRIMITIVE_28_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(35i32);
pub const D3D_PRIMITIVE_29_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(36i32);
pub const D3D_PRIMITIVE_30_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(37i32);
pub const D3D_PRIMITIVE_31_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(38i32);
pub const D3D_PRIMITIVE_32_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(39i32);
pub const D3D10_PRIMITIVE_UNDEFINED: D3D_PRIMITIVE = D3D_PRIMITIVE(0i32);
pub const D3D10_PRIMITIVE_POINT: D3D_PRIMITIVE = D3D_PRIMITIVE(1i32);
pub const D3D10_PRIMITIVE_LINE: D3D_PRIMITIVE = D3D_PRIMITIVE(2i32);
pub const D3D10_PRIMITIVE_TRIANGLE: D3D_PRIMITIVE = D3D_PRIMITIVE(3i32);
pub const D3D10_PRIMITIVE_LINE_ADJ: D3D_PRIMITIVE = D3D_PRIMITIVE(6i32);
pub const D3D10_PRIMITIVE_TRIANGLE_ADJ: D3D_PRIMITIVE = D3D_PRIMITIVE(7i32);
pub const D3D11_PRIMITIVE_UNDEFINED: D3D_PRIMITIVE = D3D_PRIMITIVE(0i32);
pub const D3D11_PRIMITIVE_POINT: D3D_PRIMITIVE = D3D_PRIMITIVE(1i32);
pub const D3D11_PRIMITIVE_LINE: D3D_PRIMITIVE = D3D_PRIMITIVE(2i32);
pub const D3D11_PRIMITIVE_TRIANGLE: D3D_PRIMITIVE = D3D_PRIMITIVE(3i32);
pub const D3D11_PRIMITIVE_LINE_ADJ: D3D_PRIMITIVE = D3D_PRIMITIVE(6i32);
pub const D3D11_PRIMITIVE_TRIANGLE_ADJ: D3D_PRIMITIVE = D3D_PRIMITIVE(7i32);
pub const D3D11_PRIMITIVE_1_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(8i32);
pub const D3D11_PRIMITIVE_2_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(9i32);
pub const D3D11_PRIMITIVE_3_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(10i32);
pub const D3D11_PRIMITIVE_4_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(11i32);
pub const D3D11_PRIMITIVE_5_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(12i32);
pub const D3D11_PRIMITIVE_6_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(13i32);
pub const D3D11_PRIMITIVE_7_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(14i32);
pub const D3D11_PRIMITIVE_8_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(15i32);
pub const D3D11_PRIMITIVE_9_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(16i32);
pub const D3D11_PRIMITIVE_10_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(17i32);
pub const D3D11_PRIMITIVE_11_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(18i32);
pub const D3D11_PRIMITIVE_12_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(19i32);
pub const D3D11_PRIMITIVE_13_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(20i32);
pub const D3D11_PRIMITIVE_14_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(21i32);
pub const D3D11_PRIMITIVE_15_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(22i32);
pub const D3D11_PRIMITIVE_16_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(23i32);
pub const D3D11_PRIMITIVE_17_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(24i32);
pub const D3D11_PRIMITIVE_18_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(25i32);
pub const D3D11_PRIMITIVE_19_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(26i32);
pub const D3D11_PRIMITIVE_20_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(27i32);
pub const D3D11_PRIMITIVE_21_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(28i32);
pub const D3D11_PRIMITIVE_22_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(29i32);
pub const D3D11_PRIMITIVE_23_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(30i32);
pub const D3D11_PRIMITIVE_24_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(31i32);
pub const D3D11_PRIMITIVE_25_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(32i32);
pub const D3D11_PRIMITIVE_26_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(33i32);
pub const D3D11_PRIMITIVE_27_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(34i32);
pub const D3D11_PRIMITIVE_28_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(35i32);
pub const D3D11_PRIMITIVE_29_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(36i32);
pub const D3D11_PRIMITIVE_30_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(37i32);
pub const D3D11_PRIMITIVE_31_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(38i32);
pub const D3D11_PRIMITIVE_32_CONTROL_POINT_PATCH: D3D_PRIMITIVE = D3D_PRIMITIVE(39i32);
impl ::std::convert::From<i32> for D3D_PRIMITIVE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_PRIMITIVE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_PRIMITIVE_TOPOLOGY(pub i32);
pub const D3D_PRIMITIVE_TOPOLOGY_UNDEFINED: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(0i32);
pub const D3D_PRIMITIVE_TOPOLOGY_POINTLIST: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(1i32);
pub const D3D_PRIMITIVE_TOPOLOGY_LINELIST: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(2i32);
pub const D3D_PRIMITIVE_TOPOLOGY_LINESTRIP: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(3i32);
pub const D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(4i32);
pub const D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(5i32);
pub const D3D_PRIMITIVE_TOPOLOGY_LINELIST_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(10i32);
pub const D3D_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(11i32);
pub const D3D_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(12i32);
pub const D3D_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(13i32);
pub const D3D_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(33i32);
pub const D3D_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(34i32);
pub const D3D_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(35i32);
pub const D3D_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(36i32);
pub const D3D_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(37i32);
pub const D3D_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(38i32);
pub const D3D_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(39i32);
pub const D3D_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(40i32);
pub const D3D_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(41i32);
pub const D3D_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(42i32);
pub const D3D_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(43i32);
pub const D3D_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(44i32);
pub const D3D_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(45i32);
pub const D3D_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(46i32);
pub const D3D_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(47i32);
pub const D3D_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(48i32);
pub const D3D_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(49i32);
pub const D3D_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(50i32);
pub const D3D_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(51i32);
pub const D3D_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(52i32);
pub const D3D_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(53i32);
pub const D3D_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(54i32);
pub const D3D_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(55i32);
pub const D3D_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(56i32);
pub const D3D_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(57i32);
pub const D3D_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(58i32);
pub const D3D_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(59i32);
pub const D3D_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(60i32);
pub const D3D_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(61i32);
pub const D3D_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(62i32);
pub const D3D_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(63i32);
pub const D3D_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(64i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_UNDEFINED: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(0i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_POINTLIST: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(1i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_LINELIST: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(2i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(3i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(4i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(5i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_LINELIST_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(10i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(11i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(12i32);
pub const D3D10_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(13i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_UNDEFINED: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(0i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_POINTLIST: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(1i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_LINELIST: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(2i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP: D3D_PRIMITIVE_TOPOLOGY = D3D_PRIMITIVE_TOPOLOGY(3i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(4i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(5i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_LINELIST_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(10i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_LINESTRIP_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(11i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_TRIANGLELIST_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(12i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_TRIANGLESTRIP_ADJ: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(13i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_1_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(33i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_2_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(34i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_3_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(35i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_4_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(36i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_5_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(37i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_6_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(38i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_7_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(39i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_8_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(40i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_9_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(41i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_10_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(42i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_11_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(43i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_12_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(44i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_13_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(45i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_14_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(46i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_15_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(47i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_16_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(48i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_17_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(49i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_18_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(50i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_19_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(51i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_20_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(52i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_21_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(53i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_22_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(54i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_23_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(55i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_24_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(56i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_25_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(57i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_26_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(58i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_27_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(59i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_28_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(60i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_29_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(61i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_30_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(62i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_31_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(63i32);
pub const D3D11_PRIMITIVE_TOPOLOGY_32_CONTROL_POINT_PATCHLIST: D3D_PRIMITIVE_TOPOLOGY =
    D3D_PRIMITIVE_TOPOLOGY(64i32);
impl ::std::convert::From<i32> for D3D_PRIMITIVE_TOPOLOGY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_PRIMITIVE_TOPOLOGY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_REGISTER_COMPONENT_TYPE(pub i32);
pub const D3D_REGISTER_COMPONENT_UNKNOWN: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(0i32);
pub const D3D_REGISTER_COMPONENT_UINT32: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(1i32);
pub const D3D_REGISTER_COMPONENT_SINT32: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(2i32);
pub const D3D_REGISTER_COMPONENT_FLOAT32: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(3i32);
pub const D3D10_REGISTER_COMPONENT_UNKNOWN: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(0i32);
pub const D3D10_REGISTER_COMPONENT_UINT32: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(1i32);
pub const D3D10_REGISTER_COMPONENT_SINT32: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(2i32);
pub const D3D10_REGISTER_COMPONENT_FLOAT32: D3D_REGISTER_COMPONENT_TYPE =
    D3D_REGISTER_COMPONENT_TYPE(3i32);
impl ::std::convert::From<i32> for D3D_REGISTER_COMPONENT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_REGISTER_COMPONENT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_RESOURCE_RETURN_TYPE(pub i32);
pub const D3D_RETURN_TYPE_UNORM: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(1i32);
pub const D3D_RETURN_TYPE_SNORM: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(2i32);
pub const D3D_RETURN_TYPE_SINT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(3i32);
pub const D3D_RETURN_TYPE_UINT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(4i32);
pub const D3D_RETURN_TYPE_FLOAT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(5i32);
pub const D3D_RETURN_TYPE_MIXED: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(6i32);
pub const D3D_RETURN_TYPE_DOUBLE: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(7i32);
pub const D3D_RETURN_TYPE_CONTINUED: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(8i32);
pub const D3D10_RETURN_TYPE_UNORM: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(1i32);
pub const D3D10_RETURN_TYPE_SNORM: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(2i32);
pub const D3D10_RETURN_TYPE_SINT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(3i32);
pub const D3D10_RETURN_TYPE_UINT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(4i32);
pub const D3D10_RETURN_TYPE_FLOAT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(5i32);
pub const D3D10_RETURN_TYPE_MIXED: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(6i32);
pub const D3D11_RETURN_TYPE_UNORM: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(1i32);
pub const D3D11_RETURN_TYPE_SNORM: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(2i32);
pub const D3D11_RETURN_TYPE_SINT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(3i32);
pub const D3D11_RETURN_TYPE_UINT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(4i32);
pub const D3D11_RETURN_TYPE_FLOAT: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(5i32);
pub const D3D11_RETURN_TYPE_MIXED: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(6i32);
pub const D3D11_RETURN_TYPE_DOUBLE: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(7i32);
pub const D3D11_RETURN_TYPE_CONTINUED: D3D_RESOURCE_RETURN_TYPE = D3D_RESOURCE_RETURN_TYPE(8i32);
impl ::std::convert::From<i32> for D3D_RESOURCE_RETURN_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_RESOURCE_RETURN_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D_RETURN_PARAMETER_INDEX: i32 = -1i32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_SHADER_CBUFFER_FLAGS(pub i32);
pub const D3D_CBF_USERPACKED: D3D_SHADER_CBUFFER_FLAGS = D3D_SHADER_CBUFFER_FLAGS(1i32);
pub const D3D10_CBF_USERPACKED: D3D_SHADER_CBUFFER_FLAGS = D3D_SHADER_CBUFFER_FLAGS(1i32);
pub const D3D_CBF_FORCE_DWORD: D3D_SHADER_CBUFFER_FLAGS = D3D_SHADER_CBUFFER_FLAGS(2147483647i32);
impl ::std::convert::From<i32> for D3D_SHADER_CBUFFER_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SHADER_CBUFFER_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D_SHADER_FEATURE_11_1_DOUBLE_EXTENSIONS: u32 = 32u32;
pub const D3D_SHADER_FEATURE_11_1_SHADER_EXTENSIONS: u32 = 64u32;
pub const D3D_SHADER_FEATURE_64_UAVS: u32 = 8u32;
pub const D3D_SHADER_FEATURE_ATOMIC_INT64_ON_DESCRIPTOR_HEAP_RESOURCE: u32 = 268435456u32;
pub const D3D_SHADER_FEATURE_ATOMIC_INT64_ON_GROUP_SHARED: u32 = 8388608u32;
pub const D3D_SHADER_FEATURE_ATOMIC_INT64_ON_TYPED_RESOURCE: u32 = 4194304u32;
pub const D3D_SHADER_FEATURE_BARYCENTRICS: u32 = 131072u32;
pub const D3D_SHADER_FEATURE_COMPUTE_SHADERS_PLUS_RAW_AND_STRUCTURED_BUFFERS_VIA_SHADER_4_X: u32 =
    2u32;
pub const D3D_SHADER_FEATURE_DERIVATIVES_IN_MESH_AND_AMPLIFICATION_SHADERS: u32 = 16777216u32;
pub const D3D_SHADER_FEATURE_DOUBLES: u32 = 1u32;
pub const D3D_SHADER_FEATURE_INNER_COVERAGE: u32 = 1024u32;
pub const D3D_SHADER_FEATURE_INT64_OPS: u32 = 32768u32;
pub const D3D_SHADER_FEATURE_LEVEL_9_COMPARISON_FILTERING: u32 = 128u32;
pub const D3D_SHADER_FEATURE_MINIMUM_PRECISION: u32 = 16u32;
pub const D3D_SHADER_FEATURE_NATIVE_16BIT_OPS: u32 = 262144u32;
pub const D3D_SHADER_FEATURE_RAYTRACING_TIER_1_1: u32 = 1048576u32;
pub const D3D_SHADER_FEATURE_RESOURCE_DESCRIPTOR_HEAP_INDEXING: u32 = 33554432u32;
pub const D3D_SHADER_FEATURE_ROVS: u32 = 4096u32;
pub const D3D_SHADER_FEATURE_SAMPLER_DESCRIPTOR_HEAP_INDEXING: u32 = 67108864u32;
pub const D3D_SHADER_FEATURE_SAMPLER_FEEDBACK: u32 = 2097152u32;
pub const D3D_SHADER_FEATURE_SHADING_RATE: u32 = 524288u32;
pub const D3D_SHADER_FEATURE_STENCIL_REF: u32 = 512u32;
pub const D3D_SHADER_FEATURE_TILED_RESOURCES: u32 = 256u32;
pub const D3D_SHADER_FEATURE_TYPED_UAV_LOAD_ADDITIONAL_FORMATS: u32 = 2048u32;
pub const D3D_SHADER_FEATURE_UAVS_AT_EVERY_STAGE: u32 = 4u32;
pub const D3D_SHADER_FEATURE_VIEWPORT_AND_RT_ARRAY_INDEX_FROM_ANY_SHADER_FEEDING_RASTERIZER: u32 =
    8192u32;
pub const D3D_SHADER_FEATURE_VIEW_ID: u32 = 65536u32;
pub const D3D_SHADER_FEATURE_WAVE_MMA: u32 = 134217728u32;
pub const D3D_SHADER_FEATURE_WAVE_OPS: u32 = 16384u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_SHADER_INPUT_FLAGS(pub i32);
pub const D3D_SIF_USERPACKED: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(1i32);
pub const D3D_SIF_COMPARISON_SAMPLER: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(2i32);
pub const D3D_SIF_TEXTURE_COMPONENT_0: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(4i32);
pub const D3D_SIF_TEXTURE_COMPONENT_1: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(8i32);
pub const D3D_SIF_TEXTURE_COMPONENTS: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(12i32);
pub const D3D_SIF_UNUSED: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(16i32);
pub const D3D10_SIF_USERPACKED: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(1i32);
pub const D3D10_SIF_COMPARISON_SAMPLER: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(2i32);
pub const D3D10_SIF_TEXTURE_COMPONENT_0: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(4i32);
pub const D3D10_SIF_TEXTURE_COMPONENT_1: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(8i32);
pub const D3D10_SIF_TEXTURE_COMPONENTS: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(12i32);
pub const D3D_SIF_FORCE_DWORD: D3D_SHADER_INPUT_FLAGS = D3D_SHADER_INPUT_FLAGS(2147483647i32);
impl ::std::convert::From<i32> for D3D_SHADER_INPUT_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SHADER_INPUT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_SHADER_INPUT_TYPE(pub i32);
pub const D3D_SIT_CBUFFER: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(0i32);
pub const D3D_SIT_TBUFFER: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(1i32);
pub const D3D_SIT_TEXTURE: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(2i32);
pub const D3D_SIT_SAMPLER: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(3i32);
pub const D3D_SIT_UAV_RWTYPED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(4i32);
pub const D3D_SIT_STRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(5i32);
pub const D3D_SIT_UAV_RWSTRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(6i32);
pub const D3D_SIT_BYTEADDRESS: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(7i32);
pub const D3D_SIT_UAV_RWBYTEADDRESS: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(8i32);
pub const D3D_SIT_UAV_APPEND_STRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(9i32);
pub const D3D_SIT_UAV_CONSUME_STRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(10i32);
pub const D3D_SIT_UAV_RWSTRUCTURED_WITH_COUNTER: D3D_SHADER_INPUT_TYPE =
    D3D_SHADER_INPUT_TYPE(11i32);
pub const D3D_SIT_RTACCELERATIONSTRUCTURE: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(12i32);
pub const D3D_SIT_UAV_FEEDBACKTEXTURE: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(13i32);
pub const D3D10_SIT_CBUFFER: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(0i32);
pub const D3D10_SIT_TBUFFER: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(1i32);
pub const D3D10_SIT_TEXTURE: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(2i32);
pub const D3D10_SIT_SAMPLER: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(3i32);
pub const D3D11_SIT_UAV_RWTYPED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(4i32);
pub const D3D11_SIT_STRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(5i32);
pub const D3D11_SIT_UAV_RWSTRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(6i32);
pub const D3D11_SIT_BYTEADDRESS: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(7i32);
pub const D3D11_SIT_UAV_RWBYTEADDRESS: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(8i32);
pub const D3D11_SIT_UAV_APPEND_STRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(9i32);
pub const D3D11_SIT_UAV_CONSUME_STRUCTURED: D3D_SHADER_INPUT_TYPE = D3D_SHADER_INPUT_TYPE(10i32);
pub const D3D11_SIT_UAV_RWSTRUCTURED_WITH_COUNTER: D3D_SHADER_INPUT_TYPE =
    D3D_SHADER_INPUT_TYPE(11i32);
impl ::std::convert::From<i32> for D3D_SHADER_INPUT_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SHADER_INPUT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D3D_SHADER_MACRO {
    pub Name: super::super::Foundation::PSTR,
    pub Definition: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl D3D_SHADER_MACRO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D3D_SHADER_MACRO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D3D_SHADER_MACRO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D3D_SHADER_MACRO")
            .field("Name", &self.Name)
            .field("Definition", &self.Definition)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D3D_SHADER_MACRO {
    fn eq(&self, other: &Self) -> bool {
        self.Name == other.Name && self.Definition == other.Definition
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D3D_SHADER_MACRO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D3D_SHADER_MACRO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D_SHADER_REQUIRES_11_1_DOUBLE_EXTENSIONS: u32 = 32u32;
pub const D3D_SHADER_REQUIRES_11_1_SHADER_EXTENSIONS: u32 = 64u32;
pub const D3D_SHADER_REQUIRES_64_UAVS: u32 = 8u32;
pub const D3D_SHADER_REQUIRES_DOUBLES: u32 = 1u32;
pub const D3D_SHADER_REQUIRES_EARLY_DEPTH_STENCIL: u32 = 2u32;
pub const D3D_SHADER_REQUIRES_LEVEL_9_COMPARISON_FILTERING: u32 = 128u32;
pub const D3D_SHADER_REQUIRES_MINIMUM_PRECISION: u32 = 16u32;
pub const D3D_SHADER_REQUIRES_TILED_RESOURCES: u32 = 256u32;
pub const D3D_SHADER_REQUIRES_UAVS_AT_EVERY_STAGE: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_SHADER_VARIABLE_CLASS(pub i32);
pub const D3D_SVC_SCALAR: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(0i32);
pub const D3D_SVC_VECTOR: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(1i32);
pub const D3D_SVC_MATRIX_ROWS: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(2i32);
pub const D3D_SVC_MATRIX_COLUMNS: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(3i32);
pub const D3D_SVC_OBJECT: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(4i32);
pub const D3D_SVC_STRUCT: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(5i32);
pub const D3D_SVC_INTERFACE_CLASS: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(6i32);
pub const D3D_SVC_INTERFACE_POINTER: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(7i32);
pub const D3D10_SVC_SCALAR: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(0i32);
pub const D3D10_SVC_VECTOR: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(1i32);
pub const D3D10_SVC_MATRIX_ROWS: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(2i32);
pub const D3D10_SVC_MATRIX_COLUMNS: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(3i32);
pub const D3D10_SVC_OBJECT: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(4i32);
pub const D3D10_SVC_STRUCT: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(5i32);
pub const D3D11_SVC_INTERFACE_CLASS: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(6i32);
pub const D3D11_SVC_INTERFACE_POINTER: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(7i32);
pub const D3D_SVC_FORCE_DWORD: D3D_SHADER_VARIABLE_CLASS = D3D_SHADER_VARIABLE_CLASS(2147483647i32);
impl ::std::convert::From<i32> for D3D_SHADER_VARIABLE_CLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SHADER_VARIABLE_CLASS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_SHADER_VARIABLE_FLAGS(pub i32);
pub const D3D_SVF_USERPACKED: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(1i32);
pub const D3D_SVF_USED: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(2i32);
pub const D3D_SVF_INTERFACE_POINTER: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(4i32);
pub const D3D_SVF_INTERFACE_PARAMETER: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(8i32);
pub const D3D10_SVF_USERPACKED: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(1i32);
pub const D3D10_SVF_USED: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(2i32);
pub const D3D11_SVF_INTERFACE_POINTER: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(4i32);
pub const D3D11_SVF_INTERFACE_PARAMETER: D3D_SHADER_VARIABLE_FLAGS =
    D3D_SHADER_VARIABLE_FLAGS(8i32);
pub const D3D_SVF_FORCE_DWORD: D3D_SHADER_VARIABLE_FLAGS = D3D_SHADER_VARIABLE_FLAGS(2147483647i32);
impl ::std::convert::From<i32> for D3D_SHADER_VARIABLE_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SHADER_VARIABLE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_SHADER_VARIABLE_TYPE(pub i32);
pub const D3D_SVT_VOID: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(0i32);
pub const D3D_SVT_BOOL: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(1i32);
pub const D3D_SVT_INT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(2i32);
pub const D3D_SVT_FLOAT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(3i32);
pub const D3D_SVT_STRING: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(4i32);
pub const D3D_SVT_TEXTURE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(5i32);
pub const D3D_SVT_TEXTURE1D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(6i32);
pub const D3D_SVT_TEXTURE2D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(7i32);
pub const D3D_SVT_TEXTURE3D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(8i32);
pub const D3D_SVT_TEXTURECUBE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(9i32);
pub const D3D_SVT_SAMPLER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(10i32);
pub const D3D_SVT_SAMPLER1D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(11i32);
pub const D3D_SVT_SAMPLER2D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(12i32);
pub const D3D_SVT_SAMPLER3D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(13i32);
pub const D3D_SVT_SAMPLERCUBE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(14i32);
pub const D3D_SVT_PIXELSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(15i32);
pub const D3D_SVT_VERTEXSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(16i32);
pub const D3D_SVT_PIXELFRAGMENT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(17i32);
pub const D3D_SVT_VERTEXFRAGMENT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(18i32);
pub const D3D_SVT_UINT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(19i32);
pub const D3D_SVT_UINT8: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(20i32);
pub const D3D_SVT_GEOMETRYSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(21i32);
pub const D3D_SVT_RASTERIZER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(22i32);
pub const D3D_SVT_DEPTHSTENCIL: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(23i32);
pub const D3D_SVT_BLEND: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(24i32);
pub const D3D_SVT_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(25i32);
pub const D3D_SVT_CBUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(26i32);
pub const D3D_SVT_TBUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(27i32);
pub const D3D_SVT_TEXTURE1DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(28i32);
pub const D3D_SVT_TEXTURE2DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(29i32);
pub const D3D_SVT_RENDERTARGETVIEW: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(30i32);
pub const D3D_SVT_DEPTHSTENCILVIEW: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(31i32);
pub const D3D_SVT_TEXTURE2DMS: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(32i32);
pub const D3D_SVT_TEXTURE2DMSARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(33i32);
pub const D3D_SVT_TEXTURECUBEARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(34i32);
pub const D3D_SVT_HULLSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(35i32);
pub const D3D_SVT_DOMAINSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(36i32);
pub const D3D_SVT_INTERFACE_POINTER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(37i32);
pub const D3D_SVT_COMPUTESHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(38i32);
pub const D3D_SVT_DOUBLE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(39i32);
pub const D3D_SVT_RWTEXTURE1D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(40i32);
pub const D3D_SVT_RWTEXTURE1DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(41i32);
pub const D3D_SVT_RWTEXTURE2D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(42i32);
pub const D3D_SVT_RWTEXTURE2DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(43i32);
pub const D3D_SVT_RWTEXTURE3D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(44i32);
pub const D3D_SVT_RWBUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(45i32);
pub const D3D_SVT_BYTEADDRESS_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(46i32);
pub const D3D_SVT_RWBYTEADDRESS_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(47i32);
pub const D3D_SVT_STRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(48i32);
pub const D3D_SVT_RWSTRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(49i32);
pub const D3D_SVT_APPEND_STRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE =
    D3D_SHADER_VARIABLE_TYPE(50i32);
pub const D3D_SVT_CONSUME_STRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE =
    D3D_SHADER_VARIABLE_TYPE(51i32);
pub const D3D_SVT_MIN8FLOAT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(52i32);
pub const D3D_SVT_MIN10FLOAT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(53i32);
pub const D3D_SVT_MIN16FLOAT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(54i32);
pub const D3D_SVT_MIN12INT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(55i32);
pub const D3D_SVT_MIN16INT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(56i32);
pub const D3D_SVT_MIN16UINT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(57i32);
pub const D3D_SVT_INT16: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(58i32);
pub const D3D_SVT_UINT16: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(59i32);
pub const D3D_SVT_FLOAT16: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(60i32);
pub const D3D_SVT_INT64: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(61i32);
pub const D3D_SVT_UINT64: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(62i32);
pub const D3D10_SVT_VOID: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(0i32);
pub const D3D10_SVT_BOOL: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(1i32);
pub const D3D10_SVT_INT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(2i32);
pub const D3D10_SVT_FLOAT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(3i32);
pub const D3D10_SVT_STRING: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(4i32);
pub const D3D10_SVT_TEXTURE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(5i32);
pub const D3D10_SVT_TEXTURE1D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(6i32);
pub const D3D10_SVT_TEXTURE2D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(7i32);
pub const D3D10_SVT_TEXTURE3D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(8i32);
pub const D3D10_SVT_TEXTURECUBE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(9i32);
pub const D3D10_SVT_SAMPLER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(10i32);
pub const D3D10_SVT_SAMPLER1D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(11i32);
pub const D3D10_SVT_SAMPLER2D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(12i32);
pub const D3D10_SVT_SAMPLER3D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(13i32);
pub const D3D10_SVT_SAMPLERCUBE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(14i32);
pub const D3D10_SVT_PIXELSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(15i32);
pub const D3D10_SVT_VERTEXSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(16i32);
pub const D3D10_SVT_PIXELFRAGMENT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(17i32);
pub const D3D10_SVT_VERTEXFRAGMENT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(18i32);
pub const D3D10_SVT_UINT: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(19i32);
pub const D3D10_SVT_UINT8: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(20i32);
pub const D3D10_SVT_GEOMETRYSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(21i32);
pub const D3D10_SVT_RASTERIZER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(22i32);
pub const D3D10_SVT_DEPTHSTENCIL: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(23i32);
pub const D3D10_SVT_BLEND: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(24i32);
pub const D3D10_SVT_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(25i32);
pub const D3D10_SVT_CBUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(26i32);
pub const D3D10_SVT_TBUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(27i32);
pub const D3D10_SVT_TEXTURE1DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(28i32);
pub const D3D10_SVT_TEXTURE2DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(29i32);
pub const D3D10_SVT_RENDERTARGETVIEW: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(30i32);
pub const D3D10_SVT_DEPTHSTENCILVIEW: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(31i32);
pub const D3D10_SVT_TEXTURE2DMS: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(32i32);
pub const D3D10_SVT_TEXTURE2DMSARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(33i32);
pub const D3D10_SVT_TEXTURECUBEARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(34i32);
pub const D3D11_SVT_HULLSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(35i32);
pub const D3D11_SVT_DOMAINSHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(36i32);
pub const D3D11_SVT_INTERFACE_POINTER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(37i32);
pub const D3D11_SVT_COMPUTESHADER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(38i32);
pub const D3D11_SVT_DOUBLE: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(39i32);
pub const D3D11_SVT_RWTEXTURE1D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(40i32);
pub const D3D11_SVT_RWTEXTURE1DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(41i32);
pub const D3D11_SVT_RWTEXTURE2D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(42i32);
pub const D3D11_SVT_RWTEXTURE2DARRAY: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(43i32);
pub const D3D11_SVT_RWTEXTURE3D: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(44i32);
pub const D3D11_SVT_RWBUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(45i32);
pub const D3D11_SVT_BYTEADDRESS_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(46i32);
pub const D3D11_SVT_RWBYTEADDRESS_BUFFER: D3D_SHADER_VARIABLE_TYPE =
    D3D_SHADER_VARIABLE_TYPE(47i32);
pub const D3D11_SVT_STRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(48i32);
pub const D3D11_SVT_RWSTRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(49i32);
pub const D3D11_SVT_APPEND_STRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE =
    D3D_SHADER_VARIABLE_TYPE(50i32);
pub const D3D11_SVT_CONSUME_STRUCTURED_BUFFER: D3D_SHADER_VARIABLE_TYPE =
    D3D_SHADER_VARIABLE_TYPE(51i32);
pub const D3D_SVT_FORCE_DWORD: D3D_SHADER_VARIABLE_TYPE = D3D_SHADER_VARIABLE_TYPE(2147483647i32);
impl ::std::convert::From<i32> for D3D_SHADER_VARIABLE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SHADER_VARIABLE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_SRV_DIMENSION(pub i32);
pub const D3D_SRV_DIMENSION_UNKNOWN: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(0i32);
pub const D3D_SRV_DIMENSION_BUFFER: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(1i32);
pub const D3D_SRV_DIMENSION_TEXTURE1D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(2i32);
pub const D3D_SRV_DIMENSION_TEXTURE1DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(3i32);
pub const D3D_SRV_DIMENSION_TEXTURE2D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(4i32);
pub const D3D_SRV_DIMENSION_TEXTURE2DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(5i32);
pub const D3D_SRV_DIMENSION_TEXTURE2DMS: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(6i32);
pub const D3D_SRV_DIMENSION_TEXTURE2DMSARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(7i32);
pub const D3D_SRV_DIMENSION_TEXTURE3D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(8i32);
pub const D3D_SRV_DIMENSION_TEXTURECUBE: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(9i32);
pub const D3D_SRV_DIMENSION_TEXTURECUBEARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(10i32);
pub const D3D_SRV_DIMENSION_BUFFEREX: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(11i32);
pub const D3D10_SRV_DIMENSION_UNKNOWN: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(0i32);
pub const D3D10_SRV_DIMENSION_BUFFER: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(1i32);
pub const D3D10_SRV_DIMENSION_TEXTURE1D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(2i32);
pub const D3D10_SRV_DIMENSION_TEXTURE1DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(3i32);
pub const D3D10_SRV_DIMENSION_TEXTURE2D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(4i32);
pub const D3D10_SRV_DIMENSION_TEXTURE2DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(5i32);
pub const D3D10_SRV_DIMENSION_TEXTURE2DMS: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(6i32);
pub const D3D10_SRV_DIMENSION_TEXTURE2DMSARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(7i32);
pub const D3D10_SRV_DIMENSION_TEXTURE3D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(8i32);
pub const D3D10_SRV_DIMENSION_TEXTURECUBE: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(9i32);
pub const D3D10_1_SRV_DIMENSION_UNKNOWN: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(0i32);
pub const D3D10_1_SRV_DIMENSION_BUFFER: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(1i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURE1D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(2i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURE1DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(3i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURE2D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(4i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURE2DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(5i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURE2DMS: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(6i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURE2DMSARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(7i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURE3D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(8i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURECUBE: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(9i32);
pub const D3D10_1_SRV_DIMENSION_TEXTURECUBEARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(10i32);
pub const D3D11_SRV_DIMENSION_UNKNOWN: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(0i32);
pub const D3D11_SRV_DIMENSION_BUFFER: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(1i32);
pub const D3D11_SRV_DIMENSION_TEXTURE1D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(2i32);
pub const D3D11_SRV_DIMENSION_TEXTURE1DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(3i32);
pub const D3D11_SRV_DIMENSION_TEXTURE2D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(4i32);
pub const D3D11_SRV_DIMENSION_TEXTURE2DARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(5i32);
pub const D3D11_SRV_DIMENSION_TEXTURE2DMS: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(6i32);
pub const D3D11_SRV_DIMENSION_TEXTURE2DMSARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(7i32);
pub const D3D11_SRV_DIMENSION_TEXTURE3D: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(8i32);
pub const D3D11_SRV_DIMENSION_TEXTURECUBE: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(9i32);
pub const D3D11_SRV_DIMENSION_TEXTURECUBEARRAY: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(10i32);
pub const D3D11_SRV_DIMENSION_BUFFEREX: D3D_SRV_DIMENSION = D3D_SRV_DIMENSION(11i32);
impl ::std::convert::From<i32> for D3D_SRV_DIMENSION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_SRV_DIMENSION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_TESSELLATOR_DOMAIN(pub i32);
pub const D3D_TESSELLATOR_DOMAIN_UNDEFINED: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(0i32);
pub const D3D_TESSELLATOR_DOMAIN_ISOLINE: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(1i32);
pub const D3D_TESSELLATOR_DOMAIN_TRI: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(2i32);
pub const D3D_TESSELLATOR_DOMAIN_QUAD: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(3i32);
pub const D3D11_TESSELLATOR_DOMAIN_UNDEFINED: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(0i32);
pub const D3D11_TESSELLATOR_DOMAIN_ISOLINE: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(1i32);
pub const D3D11_TESSELLATOR_DOMAIN_TRI: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(2i32);
pub const D3D11_TESSELLATOR_DOMAIN_QUAD: D3D_TESSELLATOR_DOMAIN = D3D_TESSELLATOR_DOMAIN(3i32);
impl ::std::convert::From<i32> for D3D_TESSELLATOR_DOMAIN {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_TESSELLATOR_DOMAIN {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_TESSELLATOR_OUTPUT_PRIMITIVE(pub i32);
pub const D3D_TESSELLATOR_OUTPUT_UNDEFINED: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(0i32);
pub const D3D_TESSELLATOR_OUTPUT_POINT: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(1i32);
pub const D3D_TESSELLATOR_OUTPUT_LINE: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(2i32);
pub const D3D_TESSELLATOR_OUTPUT_TRIANGLE_CW: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(3i32);
pub const D3D_TESSELLATOR_OUTPUT_TRIANGLE_CCW: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(4i32);
pub const D3D11_TESSELLATOR_OUTPUT_UNDEFINED: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(0i32);
pub const D3D11_TESSELLATOR_OUTPUT_POINT: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(1i32);
pub const D3D11_TESSELLATOR_OUTPUT_LINE: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(2i32);
pub const D3D11_TESSELLATOR_OUTPUT_TRIANGLE_CW: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(3i32);
pub const D3D11_TESSELLATOR_OUTPUT_TRIANGLE_CCW: D3D_TESSELLATOR_OUTPUT_PRIMITIVE =
    D3D_TESSELLATOR_OUTPUT_PRIMITIVE(4i32);
impl ::std::convert::From<i32> for D3D_TESSELLATOR_OUTPUT_PRIMITIVE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_TESSELLATOR_OUTPUT_PRIMITIVE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D3D_TESSELLATOR_PARTITIONING(pub i32);
pub const D3D_TESSELLATOR_PARTITIONING_UNDEFINED: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(0i32);
pub const D3D_TESSELLATOR_PARTITIONING_INTEGER: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(1i32);
pub const D3D_TESSELLATOR_PARTITIONING_POW2: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(2i32);
pub const D3D_TESSELLATOR_PARTITIONING_FRACTIONAL_ODD: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(3i32);
pub const D3D_TESSELLATOR_PARTITIONING_FRACTIONAL_EVEN: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(4i32);
pub const D3D11_TESSELLATOR_PARTITIONING_UNDEFINED: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(0i32);
pub const D3D11_TESSELLATOR_PARTITIONING_INTEGER: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(1i32);
pub const D3D11_TESSELLATOR_PARTITIONING_POW2: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(2i32);
pub const D3D11_TESSELLATOR_PARTITIONING_FRACTIONAL_ODD: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(3i32);
pub const D3D11_TESSELLATOR_PARTITIONING_FRACTIONAL_EVEN: D3D_TESSELLATOR_PARTITIONING =
    D3D_TESSELLATOR_PARTITIONING(4i32);
impl ::std::convert::From<i32> for D3D_TESSELLATOR_PARTITIONING {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D3D_TESSELLATOR_PARTITIONING {
    type Abi = Self;
    type DefaultType = Self;
}
pub const D3D_TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1276062179,
        16223,
        19765,
        [132, 201, 188, 9, 131, 182, 44, 40],
    );
pub const D3D_TEXTURE_LAYOUT_ROW_MAJOR: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3051103055,
        29371,
        19436,
        [151, 5, 140, 242, 88, 223, 107, 108],
    );
pub const DXGI_DEBUG_D3D11: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1268330875,
    44089,
    19110,
    [187, 11, 186, 160, 71, 132, 121, 143],
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Asynchronous(::windows::runtime::IUnknown);
impl ID3D11Asynchronous {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetDataSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Asynchronous {
    type Vtable = ID3D11Asynchronous_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1261818061,
        7701,
        16984,
        [156, 152, 27, 19, 51, 246, 221, 59],
    );
}
impl ::std::convert::From<ID3D11Asynchronous> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Asynchronous) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Asynchronous> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Asynchronous) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Asynchronous {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Asynchronous {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11Asynchronous> for ID3D11DeviceChild {
    fn from(value: ID3D11Asynchronous) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Asynchronous> for ID3D11DeviceChild {
    fn from(value: &ID3D11Asynchronous) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11Asynchronous {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11Asynchronous {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Asynchronous_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11AuthenticatedChannel(::windows::runtime::IUnknown);
impl ID3D11AuthenticatedChannel {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetCertificateSize(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetCertificate(&self, certificatesize: u32) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(certificatesize),
            &mut result__,
        )
        .from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetChannelHandle(&self, pchannelhandle: *mut super::super::Foundation::HANDLE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pchannelhandle),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11AuthenticatedChannel {
    type Vtable = ID3D11AuthenticatedChannel_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        806724360,
        56509,
        18346,
        [167, 71, 25, 36, 134, 209, 77, 74],
    );
}
impl ::std::convert::From<ID3D11AuthenticatedChannel> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11AuthenticatedChannel) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11AuthenticatedChannel> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11AuthenticatedChannel) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ID3D11AuthenticatedChannel
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID3D11AuthenticatedChannel
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11AuthenticatedChannel> for ID3D11DeviceChild {
    fn from(value: ID3D11AuthenticatedChannel) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11AuthenticatedChannel> for ID3D11DeviceChild {
    fn from(value: &ID3D11AuthenticatedChannel) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11AuthenticatedChannel {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11AuthenticatedChannel {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11AuthenticatedChannel_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcertificatesize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        certificatesize: u32,
        pcertificate: *mut u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchannelhandle: *mut super::super::Foundation::HANDLE,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11BlendState(::windows::runtime::IUnknown);
impl ID3D11BlendState {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDesc(&self, pdesc: *mut D3D11_BLEND_DESC) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11BlendState {
    type Vtable = ID3D11BlendState_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1974898602,
        13437,
        16729,
        [143, 69, 160, 100, 15, 1, 205, 154],
    );
}
impl ::std::convert::From<ID3D11BlendState> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11BlendState) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11BlendState> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11BlendState) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11BlendState {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11BlendState {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11BlendState> for ID3D11DeviceChild {
    fn from(value: ID3D11BlendState) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11BlendState> for ID3D11DeviceChild {
    fn from(value: &ID3D11BlendState) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11BlendState {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11BlendState {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11BlendState_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *mut D3D11_BLEND_DESC),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11BlendState1(::windows::runtime::IUnknown);
impl ID3D11BlendState1 {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDesc(&self, pdesc: *mut D3D11_BLEND_DESC) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDesc1(&self, pdesc: *mut D3D11_BLEND_DESC1) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11BlendState1 {
    type Vtable = ID3D11BlendState1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3431398078,
        55893,
        16413,
        [133, 231, 227, 201, 222, 40, 119, 233],
    );
}
impl ::std::convert::From<ID3D11BlendState1> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11BlendState1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11BlendState1> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11BlendState1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11BlendState1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11BlendState1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11BlendState1> for ID3D11BlendState {
    fn from(value: ID3D11BlendState1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11BlendState1> for ID3D11BlendState {
    fn from(value: &ID3D11BlendState1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11BlendState> for ID3D11BlendState1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11BlendState> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11BlendState>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11BlendState> for &ID3D11BlendState1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11BlendState> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11BlendState>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID3D11BlendState1> for ID3D11DeviceChild {
    fn from(value: ID3D11BlendState1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11BlendState1> for ID3D11DeviceChild {
    fn from(value: &ID3D11BlendState1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11BlendState1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11BlendState1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11BlendState1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *mut D3D11_BLEND_DESC),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *mut D3D11_BLEND_DESC1),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Buffer(::windows::runtime::IUnknown);
impl ID3D11Buffer {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetType(&self, presourcedimension: *mut D3D11_RESOURCE_DIMENSION) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(presourcedimension),
        ))
    }
    pub unsafe fn SetEvictionPriority(&self, evictionpriority: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(evictionpriority),
        ))
    }
    pub unsafe fn GetEvictionPriority(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetDesc(&self, pdesc: *mut D3D11_BUFFER_DESC) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Buffer {
    type Vtable = ID3D11Buffer_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1213664133,
        53742,
        20429,
        [162, 80, 235, 53, 7, 34, 176, 55],
    );
}
impl ::std::convert::From<ID3D11Buffer> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Buffer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Buffer> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Buffer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Buffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Buffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11Buffer> for ID3D11Resource {
    fn from(value: ID3D11Buffer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Buffer> for ID3D11Resource {
    fn from(value: &ID3D11Buffer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Resource> for ID3D11Buffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Resource> for &ID3D11Buffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID3D11Buffer> for ID3D11DeviceChild {
    fn from(value: ID3D11Buffer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Buffer> for ID3D11DeviceChild {
    fn from(value: &ID3D11Buffer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11Buffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11Buffer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Buffer_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presourcedimension: *mut D3D11_RESOURCE_DIMENSION,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, evictionpriority: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *mut D3D11_BUFFER_DESC),
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11ClassInstance(::windows::runtime::IUnknown);
impl ID3D11ClassInstance {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetClassLinkage(
        &self,
        pplinkage: *mut ::std::option::Option<ID3D11ClassLinkage>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pplinkage),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDesc(&self, pdesc: *mut D3D11_CLASS_INSTANCE_DESC) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInstanceName(
        &self,
        pinstancename: super::super::Foundation::PSTR,
        pbufferlength: *mut usize,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pinstancename),
            ::std::mem::transmute(pbufferlength),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTypeName(
        &self,
        ptypename: super::super::Foundation::PSTR,
        pbufferlength: *mut usize,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ptypename),
            ::std::mem::transmute(pbufferlength),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11ClassInstance {
    type Vtable = ID3D11ClassInstance_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2798485418,
        45239,
        18991,
        [148, 54, 134, 98, 166, 87, 151, 203],
    );
}
impl ::std::convert::From<ID3D11ClassInstance> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11ClassInstance) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11ClassInstance> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11ClassInstance) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11ClassInstance {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11ClassInstance {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11ClassInstance> for ID3D11DeviceChild {
    fn from(value: ID3D11ClassInstance) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11ClassInstance> for ID3D11DeviceChild {
    fn from(value: &ID3D11ClassInstance) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11ClassInstance {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11ClassInstance {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11ClassInstance_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pplinkage: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *mut D3D11_CLASS_INSTANCE_DESC,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pinstancename: super::super::Foundation::PSTR,
        pbufferlength: *mut usize,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptypename: super::super::Foundation::PSTR,
        pbufferlength: *mut usize,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11ClassLinkage(::windows::runtime::IUnknown);
impl ID3D11ClassLinkage {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetClassInstance<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pclassinstancename: Param0,
        instanceindex: u32,
    ) -> ::windows::runtime::Result<ID3D11ClassInstance> {
        let mut result__: <ID3D11ClassInstance as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pclassinstancename.into_param().abi(),
            ::std::mem::transmute(instanceindex),
            &mut result__,
        )
        .from_abi::<ID3D11ClassInstance>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateClassInstance<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pclasstypename: Param0,
        constantbufferoffset: u32,
        constantvectoroffset: u32,
        textureoffset: u32,
        sampleroffset: u32,
    ) -> ::windows::runtime::Result<ID3D11ClassInstance> {
        let mut result__: <ID3D11ClassInstance as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pclasstypename.into_param().abi(),
            ::std::mem::transmute(constantbufferoffset),
            ::std::mem::transmute(constantvectoroffset),
            ::std::mem::transmute(textureoffset),
            ::std::mem::transmute(sampleroffset),
            &mut result__,
        )
        .from_abi::<ID3D11ClassInstance>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11ClassLinkage {
    type Vtable = ID3D11ClassLinkage_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3723852986,
        38211,
        18148,
        [161, 43, 242, 7, 160, 254, 127, 237],
    );
}
impl ::std::convert::From<ID3D11ClassLinkage> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11ClassLinkage) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11ClassLinkage> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11ClassLinkage) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11ClassLinkage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11ClassLinkage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11ClassLinkage> for ID3D11DeviceChild {
    fn from(value: ID3D11ClassLinkage) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11ClassLinkage> for ID3D11DeviceChild {
    fn from(value: &ID3D11ClassLinkage) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11ClassLinkage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11ClassLinkage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11ClassLinkage_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pclassinstancename: super::super::Foundation::PSTR,
        instanceindex: u32,
        ppinstance: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pclasstypename: super::super::Foundation::PSTR,
        constantbufferoffset: u32,
        constantvectoroffset: u32,
        textureoffset: u32,
        sampleroffset: u32,
        ppinstance: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11CommandList(::windows::runtime::IUnknown);
impl ID3D11CommandList {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetContextFlags(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11CommandList {
    type Vtable = ID3D11CommandList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2722874577,
        30366,
        17399,
        [128, 19, 152, 255, 86, 108, 24, 226],
    );
}
impl ::std::convert::From<ID3D11CommandList> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11CommandList> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11CommandList> for ID3D11DeviceChild {
    fn from(value: ID3D11CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11CommandList> for ID3D11DeviceChild {
    fn from(value: &ID3D11CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11CommandList_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11ComputeShader(::windows::runtime::IUnknown);
impl ID3D11ComputeShader {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11ComputeShader {
    type Vtable = ID3D11ComputeShader_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1331370350,
        49853,
        18782,
        [189, 1, 31, 222, 211, 142, 73, 105],
    );
}
impl ::std::convert::From<ID3D11ComputeShader> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11ComputeShader) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11ComputeShader> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11ComputeShader) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11ComputeShader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11ComputeShader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11ComputeShader> for ID3D11DeviceChild {
    fn from(value: ID3D11ComputeShader) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11ComputeShader> for ID3D11DeviceChild {
    fn from(value: &ID3D11ComputeShader) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11ComputeShader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11ComputeShader {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11ComputeShader_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Counter(::windows::runtime::IUnknown);
impl ID3D11Counter {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetDataSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetDesc(&self, pdesc: *mut D3D11_COUNTER_DESC) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Counter {
    type Vtable = ID3D11Counter_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1854687739,
        41841,
        18288,
        [180, 64, 41, 8, 96, 34, 183, 65],
    );
}
impl ::std::convert::From<ID3D11Counter> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Counter) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Counter> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Counter) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Counter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Counter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11Counter> for ID3D11Asynchronous {
    fn from(value: ID3D11Counter) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Counter> for ID3D11Asynchronous {
    fn from(value: &ID3D11Counter) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Asynchronous> for ID3D11Counter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Asynchronous> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Asynchronous>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Asynchronous> for &ID3D11Counter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Asynchronous> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Asynchronous>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID3D11Counter> for ID3D11DeviceChild {
    fn from(value: ID3D11Counter) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Counter> for ID3D11DeviceChild {
    fn from(value: &ID3D11Counter) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11Counter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11Counter {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Counter_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, pdesc: *mut D3D11_COUNTER_DESC),
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11CryptoSession(::windows::runtime::IUnknown);
impl ID3D11CryptoSession {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetCryptoType(&self, pcryptotype: *mut ::windows::runtime::GUID) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcryptotype),
        ))
    }
    pub unsafe fn GetDecoderProfile(&self, pdecoderprofile: *mut ::windows::runtime::GUID) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdecoderprofile),
        ))
    }
    pub unsafe fn GetCertificateSize(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetCertificate(&self, certificatesize: u32) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(certificatesize),
            &mut result__,
        )
        .from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCryptoSessionHandle(
        &self,
        pcryptosessionhandle: *mut super::super::Foundation::HANDLE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcryptosessionhandle),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11CryptoSession {
    type Vtable = ID3D11CryptoSession_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2603809197,
        48588,
        16550,
        [163, 157, 213, 200, 101, 132, 87, 32],
    );
}
impl ::std::convert::From<ID3D11CryptoSession> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11CryptoSession) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11CryptoSession> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11CryptoSession) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11CryptoSession {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11CryptoSession {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11CryptoSession> for ID3D11DeviceChild {
    fn from(value: ID3D11CryptoSession) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11CryptoSession> for ID3D11DeviceChild {
    fn from(value: &ID3D11CryptoSession) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11CryptoSession {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11CryptoSession {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11CryptoSession_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcryptotype: *mut ::windows::runtime::GUID,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdecoderprofile: *mut ::windows::runtime::GUID,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcertificatesize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        certificatesize: u32,
        pcertificate: *mut u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcryptosessionhandle: *mut super::super::Foundation::HANDLE,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Debug(::windows::runtime::IUnknown);
impl ID3D11Debug {
    pub unsafe fn SetFeatureMask(&self, mask: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(mask),
        )
        .ok()
    }
    pub unsafe fn GetFeatureMask(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetPresentPerRenderOpDelay(
        &self,
        milliseconds: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(milliseconds),
        )
        .ok()
    }
    pub unsafe fn GetPresentPerRenderOpDelay(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn SetSwapChain<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGISwapChain>,
    >(
        &self,
        pswapchain: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pswapchain.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetSwapChain(&self) -> ::windows::runtime::Result<super::Dxgi::IDXGISwapChain> {
        let mut result__: <super::Dxgi::IDXGISwapChain as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Dxgi::IDXGISwapChain>(result__)
    }
    pub unsafe fn ValidateContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
    >(
        &self,
        pcontext: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            pcontext.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ReportLiveDeviceObjects(
        &self,
        flags: D3D11_RLDO_FLAGS,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(flags),
        )
        .ok()
    }
    pub unsafe fn ValidateContextForDispatch<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11DeviceContext>,
    >(
        &self,
        pcontext: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pcontext.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Debug {
    type Vtable = ID3D11Debug_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2043617843,
        30006,
        18760,
        [157, 54, 30, 70, 146, 220, 87, 96],
    );
}
impl ::std::convert::From<ID3D11Debug> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Debug) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Debug> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Debug) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Debug {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Debug {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Debug_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mask: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        milliseconds: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pswapchain: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppswapchain: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcontext: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flags: D3D11_RLDO_FLAGS,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcontext: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11DepthStencilState(::windows::runtime::IUnknown);
impl ID3D11DepthStencilState {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDesc(&self, pdesc: *mut D3D11_DEPTH_STENCIL_DESC) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11DepthStencilState {
    type Vtable = ID3D11DepthStencilState_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        58867451,
        36239,
        19996,
        [154, 162, 246, 75, 178, 203, 253, 241],
    );
}
impl ::std::convert::From<ID3D11DepthStencilState> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11DepthStencilState) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11DepthStencilState> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11DepthStencilState) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ID3D11DepthStencilState
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID3D11DepthStencilState
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11DepthStencilState> for ID3D11DeviceChild {
    fn from(value: ID3D11DepthStencilState) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11DepthStencilState> for ID3D11DeviceChild {
    fn from(value: &ID3D11DepthStencilState) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11DepthStencilState {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11DepthStencilState {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11DepthStencilState_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *mut D3D11_DEPTH_STENCIL_DESC,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11DepthStencilView(::windows::runtime::IUnknown);
impl ID3D11DepthStencilView {
    pub unsafe fn GetDevice(&self, ppdevice: *mut ::std::option::Option<ID3D11Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppdevice),
        ))
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetResource(&self, ppresource: *mut ::std::option::Option<ID3D11Resource>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppresource),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDesc(&self, pdesc: *mut D3D11_DEPTH_STENCIL_VIEW_DESC) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11DepthStencilView {
    type Vtable = ID3D11DepthStencilView_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2681915690,
        6262,
        18627,
        [175, 173, 37, 185, 79, 132, 169, 182],
    );
}
impl ::std::convert::From<ID3D11DepthStencilView> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11DepthStencilView) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11DepthStencilView> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11DepthStencilView) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ID3D11DepthStencilView
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID3D11DepthStencilView
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11DepthStencilView> for ID3D11View {
    fn from(value: ID3D11DepthStencilView) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11DepthStencilView> for ID3D11View {
    fn from(value: &ID3D11DepthStencilView) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11View> for ID3D11DepthStencilView {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11View> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11View>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11View> for &ID3D11DepthStencilView {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11View> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11View>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID3D11DepthStencilView> for ID3D11DeviceChild {
    fn from(value: ID3D11DepthStencilView) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11DepthStencilView> for ID3D11DeviceChild {
    fn from(value: &ID3D11DepthStencilView) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for ID3D11DepthStencilView {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11DeviceChild> for &ID3D11DepthStencilView {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11DeviceChild> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11DeviceChild>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11DepthStencilView_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdevice: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppresource: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *mut D3D11_DEPTH_STENCIL_VIEW_DESC,
    ),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Device(::windows::runtime::IUnknown);
impl ID3D11Device {
    pub unsafe fn CreateBuffer(
        &self,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Buffer> {
        let mut result__: <ID3D11Buffer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Buffer>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture1D(
        &self,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture1D> {
        let mut result__: <ID3D11Texture1D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture1D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture2D(
        &self,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture2D> {
        let mut result__: <ID3D11Texture2D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture2D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture3D(
        &self,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture3D> {
        let mut result__: <ID3D11Texture3D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture3D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11ShaderResourceView> {
        let mut result__: <ID3D11ShaderResourceView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11ShaderResourceView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11UnorderedAccessView> {
        let mut result__: <ID3D11UnorderedAccessView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11UnorderedAccessView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11RenderTargetView> {
        let mut result__: <ID3D11RenderTargetView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RenderTargetView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilView> {
        let mut result__: <ID3D11DepthStencilView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilView>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateInputLayout(
        &self,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
    ) -> ::windows::runtime::Result<ID3D11InputLayout> {
        let mut result__: <ID3D11InputLayout as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pinputelementdescs),
            ::std::mem::transmute(numelements),
            ::std::mem::transmute(pshaderbytecodewithinputsignature),
            ::std::mem::transmute(bytecodelength),
            &mut result__,
        )
        .from_abi::<ID3D11InputLayout>(result__)
    }
    pub unsafe fn CreateVertexShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11VertexShader> {
        let mut result__: <ID3D11VertexShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11VertexShader>(result__)
    }
    pub unsafe fn CreateGeometryShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateGeometryShaderWithStreamOutput<
        'a,
        Param7: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: Param7,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            ::std::mem::transmute(psodeclaration),
            ::std::mem::transmute(numentries),
            ::std::mem::transmute(pbufferstrides),
            ::std::mem::transmute(numstrides),
            ::std::mem::transmute(rasterizedstream),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    pub unsafe fn CreatePixelShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11PixelShader> {
        let mut result__: <ID3D11PixelShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11PixelShader>(result__)
    }
    pub unsafe fn CreateHullShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11HullShader> {
        let mut result__: <ID3D11HullShader as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11HullShader>(result__)
    }
    pub unsafe fn CreateDomainShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11DomainShader> {
        let mut result__: <ID3D11DomainShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11DomainShader>(result__)
    }
    pub unsafe fn CreateComputeShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11ComputeShader> {
        let mut result__: <ID3D11ComputeShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11ComputeShader>(result__)
    }
    pub unsafe fn CreateClassLinkage(&self) -> ::windows::runtime::Result<ID3D11ClassLinkage> {
        let mut result__: <ID3D11ClassLinkage as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID3D11ClassLinkage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBlendState(
        &self,
        pblendstatedesc: *const D3D11_BLEND_DESC,
    ) -> ::windows::runtime::Result<ID3D11BlendState> {
        let mut result__: <ID3D11BlendState as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pblendstatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11BlendState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateDepthStencilState(
        &self,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilState> {
        let mut result__: <ID3D11DepthStencilState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdepthstencildesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState> {
        let mut result__: <ID3D11RasterizerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState>(result__)
    }
    pub unsafe fn CreateSamplerState(
        &self,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
    ) -> ::windows::runtime::Result<ID3D11SamplerState> {
        let mut result__: <ID3D11SamplerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(psamplerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11SamplerState>(result__)
    }
    pub unsafe fn CreateQuery(
        &self,
        pquerydesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Query> {
        let mut result__: <ID3D11Query as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pquerydesc),
            &mut result__,
        )
        .from_abi::<ID3D11Query>(result__)
    }
    pub unsafe fn CreatePredicate(
        &self,
        ppredicatedesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Predicate> {
        let mut result__: <ID3D11Predicate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppredicatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11Predicate>(result__)
    }
    pub unsafe fn CreateCounter(
        &self,
        pcounterdesc: *const D3D11_COUNTER_DESC,
    ) -> ::windows::runtime::Result<ID3D11Counter> {
        let mut result__: <ID3D11Counter as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterdesc),
            &mut result__,
        )
        .from_abi::<ID3D11Counter>(result__)
    }
    pub unsafe fn CreateDeferredContext(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext> {
        let mut result__: <ID3D11DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResource<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        hresource: Param0,
        result__: *mut ::std::option::Option<T>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            hresource.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            result__ as *mut _ as *mut _,
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckFormatSupport(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckMultisampleQualityLevels(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            ::std::mem::transmute(samplecount),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CheckCounterInfo(&self, pcounterinfo: *mut D3D11_COUNTER_INFO) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterinfo),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CheckCounter(
        &self,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pactivecounters),
            ::std::mem::transmute(szname),
            ::std::mem::transmute(pnamelength),
            ::std::mem::transmute(szunits),
            ::std::mem::transmute(punitslength),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pdescriptionlength),
        )
        .ok()
    }
    pub unsafe fn CheckFeatureSupport(
        &self,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(feature),
            ::std::mem::transmute(pfeaturesupportdata),
            ::std::mem::transmute(featuresupportdatasize),
        )
        .ok()
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetFeatureLevel(&self) -> D3D_FEATURE_LEVEL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetCreationFlags(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetImmediateContext(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn SetExceptionMode(&self, raiseflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(raiseflags),
        )
        .ok()
    }
    pub unsafe fn GetExceptionMode(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Device {
    type Vtable = ID3D11Device_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3681512923,
        44151,
        20104,
        [130, 83, 129, 157, 249, 187, 241, 64],
    );
}
impl ::std::convert::From<ID3D11Device> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Device) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Device) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Device_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        ppbuffer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture1d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture2d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture3d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
        ppsrview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
        ppuaview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
        pprtview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
        ppdepthstencilview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
        ppinputlayout: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppvertexshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pppixelshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pphullshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppdomainshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppcomputeshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pplinkage: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pblendstatedesc: *const D3D11_BLEND_DESC,
        ppblendstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
        ppdepthstencilstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
        ppsamplerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pquerydesc: *const D3D11_QUERY_DESC,
        ppquery: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppredicatedesc: *const D3D11_QUERY_DESC,
        pppredicate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterdesc: *const D3D11_COUNTER_DESC,
        ppcounter: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hresource: super::super::Foundation::HANDLE,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        pformatsupport: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        pnumqualitylevels: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterinfo: *mut D3D11_COUNTER_INFO,
    ),
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D_FEATURE_LEVEL,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        raiseflags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Device1(::windows::runtime::IUnknown);
impl ID3D11Device1 {
    pub unsafe fn CreateBuffer(
        &self,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Buffer> {
        let mut result__: <ID3D11Buffer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Buffer>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture1D(
        &self,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture1D> {
        let mut result__: <ID3D11Texture1D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture1D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture2D(
        &self,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture2D> {
        let mut result__: <ID3D11Texture2D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture2D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture3D(
        &self,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture3D> {
        let mut result__: <ID3D11Texture3D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture3D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11ShaderResourceView> {
        let mut result__: <ID3D11ShaderResourceView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11ShaderResourceView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11UnorderedAccessView> {
        let mut result__: <ID3D11UnorderedAccessView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11UnorderedAccessView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11RenderTargetView> {
        let mut result__: <ID3D11RenderTargetView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RenderTargetView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilView> {
        let mut result__: <ID3D11DepthStencilView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilView>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateInputLayout(
        &self,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
    ) -> ::windows::runtime::Result<ID3D11InputLayout> {
        let mut result__: <ID3D11InputLayout as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pinputelementdescs),
            ::std::mem::transmute(numelements),
            ::std::mem::transmute(pshaderbytecodewithinputsignature),
            ::std::mem::transmute(bytecodelength),
            &mut result__,
        )
        .from_abi::<ID3D11InputLayout>(result__)
    }
    pub unsafe fn CreateVertexShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11VertexShader> {
        let mut result__: <ID3D11VertexShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11VertexShader>(result__)
    }
    pub unsafe fn CreateGeometryShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateGeometryShaderWithStreamOutput<
        'a,
        Param7: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: Param7,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            ::std::mem::transmute(psodeclaration),
            ::std::mem::transmute(numentries),
            ::std::mem::transmute(pbufferstrides),
            ::std::mem::transmute(numstrides),
            ::std::mem::transmute(rasterizedstream),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    pub unsafe fn CreatePixelShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11PixelShader> {
        let mut result__: <ID3D11PixelShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11PixelShader>(result__)
    }
    pub unsafe fn CreateHullShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11HullShader> {
        let mut result__: <ID3D11HullShader as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11HullShader>(result__)
    }
    pub unsafe fn CreateDomainShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11DomainShader> {
        let mut result__: <ID3D11DomainShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11DomainShader>(result__)
    }
    pub unsafe fn CreateComputeShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11ComputeShader> {
        let mut result__: <ID3D11ComputeShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11ComputeShader>(result__)
    }
    pub unsafe fn CreateClassLinkage(&self) -> ::windows::runtime::Result<ID3D11ClassLinkage> {
        let mut result__: <ID3D11ClassLinkage as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID3D11ClassLinkage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBlendState(
        &self,
        pblendstatedesc: *const D3D11_BLEND_DESC,
    ) -> ::windows::runtime::Result<ID3D11BlendState> {
        let mut result__: <ID3D11BlendState as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pblendstatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11BlendState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateDepthStencilState(
        &self,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilState> {
        let mut result__: <ID3D11DepthStencilState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdepthstencildesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState> {
        let mut result__: <ID3D11RasterizerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState>(result__)
    }
    pub unsafe fn CreateSamplerState(
        &self,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
    ) -> ::windows::runtime::Result<ID3D11SamplerState> {
        let mut result__: <ID3D11SamplerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(psamplerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11SamplerState>(result__)
    }
    pub unsafe fn CreateQuery(
        &self,
        pquerydesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Query> {
        let mut result__: <ID3D11Query as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pquerydesc),
            &mut result__,
        )
        .from_abi::<ID3D11Query>(result__)
    }
    pub unsafe fn CreatePredicate(
        &self,
        ppredicatedesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Predicate> {
        let mut result__: <ID3D11Predicate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppredicatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11Predicate>(result__)
    }
    pub unsafe fn CreateCounter(
        &self,
        pcounterdesc: *const D3D11_COUNTER_DESC,
    ) -> ::windows::runtime::Result<ID3D11Counter> {
        let mut result__: <ID3D11Counter as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterdesc),
            &mut result__,
        )
        .from_abi::<ID3D11Counter>(result__)
    }
    pub unsafe fn CreateDeferredContext(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext> {
        let mut result__: <ID3D11DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResource<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        hresource: Param0,
        result__: *mut ::std::option::Option<T>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            hresource.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            result__ as *mut _ as *mut _,
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckFormatSupport(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckMultisampleQualityLevels(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            ::std::mem::transmute(samplecount),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CheckCounterInfo(&self, pcounterinfo: *mut D3D11_COUNTER_INFO) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterinfo),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CheckCounter(
        &self,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pactivecounters),
            ::std::mem::transmute(szname),
            ::std::mem::transmute(pnamelength),
            ::std::mem::transmute(szunits),
            ::std::mem::transmute(punitslength),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pdescriptionlength),
        )
        .ok()
    }
    pub unsafe fn CheckFeatureSupport(
        &self,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(feature),
            ::std::mem::transmute(pfeaturesupportdata),
            ::std::mem::transmute(featuresupportdatasize),
        )
        .ok()
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetFeatureLevel(&self) -> D3D_FEATURE_LEVEL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetCreationFlags(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetImmediateContext(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn SetExceptionMode(&self, raiseflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(raiseflags),
        )
        .ok()
    }
    pub unsafe fn GetExceptionMode(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetImmediateContext1(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext1>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn CreateDeferredContext1(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext1> {
        let mut result__: <ID3D11DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext1>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBlendState1(
        &self,
        pblendstatedesc: *const D3D11_BLEND_DESC1,
    ) -> ::windows::runtime::Result<ID3D11BlendState1> {
        let mut result__: <ID3D11BlendState1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pblendstatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11BlendState1>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState1(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC1,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState1> {
        let mut result__: <ID3D11RasterizerState1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState1>(result__)
    }
    pub unsafe fn CreateDeviceContextState(
        &self,
        flags: u32,
        pfeaturelevels: *const D3D_FEATURE_LEVEL,
        featurelevels: u32,
        sdkversion: u32,
        emulatedinterface: *const ::windows::runtime::GUID,
        pchosenfeaturelevel: *mut D3D_FEATURE_LEVEL,
        ppcontextstate: *mut ::std::option::Option<ID3DDeviceContextState>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pfeaturelevels),
            ::std::mem::transmute(featurelevels),
            ::std::mem::transmute(sdkversion),
            ::std::mem::transmute(emulatedinterface),
            ::std::mem::transmute(pchosenfeaturelevel),
            ::std::mem::transmute(ppcontextstate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResource1<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        hresource: Param0,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            hresource.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResourceByName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        lpname: Param0,
        dwdesiredaccess: u32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            lpname.into_param().abi(),
            ::std::mem::transmute(dwdesiredaccess),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Device1 {
    type Vtable = ID3D11Device1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2689334057,
        2287,
        17366,
        [164, 156, 169, 189, 189, 203, 230, 134],
    );
}
impl ::std::convert::From<ID3D11Device1> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device1> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11Device1> for ID3D11Device {
    fn from(value: ID3D11Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device1> for ID3D11Device {
    fn from(value: &ID3D11Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device> for ID3D11Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device> for &ID3D11Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Device1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        ppbuffer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture1d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture2d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture3d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
        ppsrview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
        ppuaview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
        pprtview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
        ppdepthstencilview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
        ppinputlayout: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppvertexshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pppixelshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pphullshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppdomainshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppcomputeshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pplinkage: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pblendstatedesc: *const D3D11_BLEND_DESC,
        ppblendstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
        ppdepthstencilstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
        ppsamplerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pquerydesc: *const D3D11_QUERY_DESC,
        ppquery: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppredicatedesc: *const D3D11_QUERY_DESC,
        pppredicate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterdesc: *const D3D11_COUNTER_DESC,
        ppcounter: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hresource: super::super::Foundation::HANDLE,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        pformatsupport: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        pnumqualitylevels: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterinfo: *mut D3D11_COUNTER_INFO,
    ),
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D_FEATURE_LEVEL,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        raiseflags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pblendstatedesc: *const D3D11_BLEND_DESC1,
        ppblendstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC1,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flags: u32,
        pfeaturelevels: *const D3D_FEATURE_LEVEL,
        featurelevels: u32,
        sdkversion: u32,
        emulatedinterface: *const ::windows::runtime::GUID,
        pchosenfeaturelevel: *mut D3D_FEATURE_LEVEL,
        ppcontextstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hresource: super::super::Foundation::HANDLE,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpname: super::super::Foundation::PWSTR,
        dwdesiredaccess: u32,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Device2(::windows::runtime::IUnknown);
impl ID3D11Device2 {
    pub unsafe fn CreateBuffer(
        &self,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Buffer> {
        let mut result__: <ID3D11Buffer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Buffer>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture1D(
        &self,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture1D> {
        let mut result__: <ID3D11Texture1D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture1D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture2D(
        &self,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture2D> {
        let mut result__: <ID3D11Texture2D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture2D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture3D(
        &self,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture3D> {
        let mut result__: <ID3D11Texture3D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture3D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11ShaderResourceView> {
        let mut result__: <ID3D11ShaderResourceView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11ShaderResourceView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11UnorderedAccessView> {
        let mut result__: <ID3D11UnorderedAccessView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11UnorderedAccessView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11RenderTargetView> {
        let mut result__: <ID3D11RenderTargetView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RenderTargetView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilView> {
        let mut result__: <ID3D11DepthStencilView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilView>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateInputLayout(
        &self,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
    ) -> ::windows::runtime::Result<ID3D11InputLayout> {
        let mut result__: <ID3D11InputLayout as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pinputelementdescs),
            ::std::mem::transmute(numelements),
            ::std::mem::transmute(pshaderbytecodewithinputsignature),
            ::std::mem::transmute(bytecodelength),
            &mut result__,
        )
        .from_abi::<ID3D11InputLayout>(result__)
    }
    pub unsafe fn CreateVertexShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11VertexShader> {
        let mut result__: <ID3D11VertexShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11VertexShader>(result__)
    }
    pub unsafe fn CreateGeometryShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateGeometryShaderWithStreamOutput<
        'a,
        Param7: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: Param7,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            ::std::mem::transmute(psodeclaration),
            ::std::mem::transmute(numentries),
            ::std::mem::transmute(pbufferstrides),
            ::std::mem::transmute(numstrides),
            ::std::mem::transmute(rasterizedstream),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    pub unsafe fn CreatePixelShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11PixelShader> {
        let mut result__: <ID3D11PixelShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11PixelShader>(result__)
    }
    pub unsafe fn CreateHullShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11HullShader> {
        let mut result__: <ID3D11HullShader as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11HullShader>(result__)
    }
    pub unsafe fn CreateDomainShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11DomainShader> {
        let mut result__: <ID3D11DomainShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11DomainShader>(result__)
    }
    pub unsafe fn CreateComputeShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11ComputeShader> {
        let mut result__: <ID3D11ComputeShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11ComputeShader>(result__)
    }
    pub unsafe fn CreateClassLinkage(&self) -> ::windows::runtime::Result<ID3D11ClassLinkage> {
        let mut result__: <ID3D11ClassLinkage as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID3D11ClassLinkage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBlendState(
        &self,
        pblendstatedesc: *const D3D11_BLEND_DESC,
    ) -> ::windows::runtime::Result<ID3D11BlendState> {
        let mut result__: <ID3D11BlendState as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pblendstatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11BlendState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateDepthStencilState(
        &self,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilState> {
        let mut result__: <ID3D11DepthStencilState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdepthstencildesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState> {
        let mut result__: <ID3D11RasterizerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState>(result__)
    }
    pub unsafe fn CreateSamplerState(
        &self,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
    ) -> ::windows::runtime::Result<ID3D11SamplerState> {
        let mut result__: <ID3D11SamplerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(psamplerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11SamplerState>(result__)
    }
    pub unsafe fn CreateQuery(
        &self,
        pquerydesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Query> {
        let mut result__: <ID3D11Query as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pquerydesc),
            &mut result__,
        )
        .from_abi::<ID3D11Query>(result__)
    }
    pub unsafe fn CreatePredicate(
        &self,
        ppredicatedesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Predicate> {
        let mut result__: <ID3D11Predicate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppredicatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11Predicate>(result__)
    }
    pub unsafe fn CreateCounter(
        &self,
        pcounterdesc: *const D3D11_COUNTER_DESC,
    ) -> ::windows::runtime::Result<ID3D11Counter> {
        let mut result__: <ID3D11Counter as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterdesc),
            &mut result__,
        )
        .from_abi::<ID3D11Counter>(result__)
    }
    pub unsafe fn CreateDeferredContext(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext> {
        let mut result__: <ID3D11DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResource<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        hresource: Param0,
        result__: *mut ::std::option::Option<T>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            hresource.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            result__ as *mut _ as *mut _,
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckFormatSupport(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckMultisampleQualityLevels(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            ::std::mem::transmute(samplecount),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CheckCounterInfo(&self, pcounterinfo: *mut D3D11_COUNTER_INFO) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterinfo),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CheckCounter(
        &self,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pactivecounters),
            ::std::mem::transmute(szname),
            ::std::mem::transmute(pnamelength),
            ::std::mem::transmute(szunits),
            ::std::mem::transmute(punitslength),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pdescriptionlength),
        )
        .ok()
    }
    pub unsafe fn CheckFeatureSupport(
        &self,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(feature),
            ::std::mem::transmute(pfeaturesupportdata),
            ::std::mem::transmute(featuresupportdatasize),
        )
        .ok()
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetFeatureLevel(&self) -> D3D_FEATURE_LEVEL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetCreationFlags(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetImmediateContext(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn SetExceptionMode(&self, raiseflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(raiseflags),
        )
        .ok()
    }
    pub unsafe fn GetExceptionMode(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetImmediateContext1(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext1>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn CreateDeferredContext1(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext1> {
        let mut result__: <ID3D11DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext1>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBlendState1(
        &self,
        pblendstatedesc: *const D3D11_BLEND_DESC1,
    ) -> ::windows::runtime::Result<ID3D11BlendState1> {
        let mut result__: <ID3D11BlendState1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pblendstatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11BlendState1>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState1(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC1,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState1> {
        let mut result__: <ID3D11RasterizerState1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState1>(result__)
    }
    pub unsafe fn CreateDeviceContextState(
        &self,
        flags: u32,
        pfeaturelevels: *const D3D_FEATURE_LEVEL,
        featurelevels: u32,
        sdkversion: u32,
        emulatedinterface: *const ::windows::runtime::GUID,
        pchosenfeaturelevel: *mut D3D_FEATURE_LEVEL,
        ppcontextstate: *mut ::std::option::Option<ID3DDeviceContextState>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pfeaturelevels),
            ::std::mem::transmute(featurelevels),
            ::std::mem::transmute(sdkversion),
            ::std::mem::transmute(emulatedinterface),
            ::std::mem::transmute(pchosenfeaturelevel),
            ::std::mem::transmute(ppcontextstate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResource1<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        hresource: Param0,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            hresource.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResourceByName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        lpname: Param0,
        dwdesiredaccess: u32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            lpname.into_param().abi(),
            ::std::mem::transmute(dwdesiredaccess),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetImmediateContext2(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext2>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn CreateDeferredContext2(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext2> {
        let mut result__: <ID3D11DeviceContext2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext2>(result__)
    }
    pub unsafe fn GetResourceTiling<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        ptiledresource: Param0,
        pnumtilesforentireresource: *mut u32,
        ppackedmipdesc: *mut D3D11_PACKED_MIP_DESC,
        pstandardtileshapefornonpackedmips: *mut D3D11_TILE_SHAPE,
        pnumsubresourcetilings: *mut u32,
        firstsubresourcetilingtoget: u32,
        psubresourcetilingsfornonpackedmips: *mut D3D11_SUBRESOURCE_TILING,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ptiledresource.into_param().abi(),
            ::std::mem::transmute(pnumtilesforentireresource),
            ::std::mem::transmute(ppackedmipdesc),
            ::std::mem::transmute(pstandardtileshapefornonpackedmips),
            ::std::mem::transmute(pnumsubresourcetilings),
            ::std::mem::transmute(firstsubresourcetilingtoget),
            ::std::mem::transmute(psubresourcetilingsfornonpackedmips),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckMultisampleQualityLevels1(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        flags: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            ::std::mem::transmute(samplecount),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Device2 {
    type Vtable = ID3D11Device2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2634473466,
        53733,
        19719,
        [131, 168, 27, 177, 35, 242, 248, 65],
    );
}
impl ::std::convert::From<ID3D11Device2> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device2> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11Device2> for ID3D11Device1 {
    fn from(value: ID3D11Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device2> for ID3D11Device1 {
    fn from(value: &ID3D11Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device1> for ID3D11Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device1> for &ID3D11Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID3D11Device2> for ID3D11Device {
    fn from(value: ID3D11Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device2> for ID3D11Device {
    fn from(value: &ID3D11Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device> for ID3D11Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device> for &ID3D11Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Device2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        ppbuffer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture1d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture2d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture3d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
        ppsrview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
        ppuaview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
        pprtview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
        ppdepthstencilview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
        ppinputlayout: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppvertexshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pppixelshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pphullshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppdomainshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppcomputeshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pplinkage: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pblendstatedesc: *const D3D11_BLEND_DESC,
        ppblendstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
        ppdepthstencilstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
        ppsamplerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pquerydesc: *const D3D11_QUERY_DESC,
        ppquery: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppredicatedesc: *const D3D11_QUERY_DESC,
        pppredicate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterdesc: *const D3D11_COUNTER_DESC,
        ppcounter: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hresource: super::super::Foundation::HANDLE,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        pformatsupport: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        pnumqualitylevels: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterinfo: *mut D3D11_COUNTER_INFO,
    ),
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D_FEATURE_LEVEL,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        raiseflags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pblendstatedesc: *const D3D11_BLEND_DESC1,
        ppblendstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC1,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flags: u32,
        pfeaturelevels: *const D3D_FEATURE_LEVEL,
        featurelevels: u32,
        sdkversion: u32,
        emulatedinterface: *const ::windows::runtime::GUID,
        pchosenfeaturelevel: *mut D3D_FEATURE_LEVEL,
        ppcontextstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hresource: super::super::Foundation::HANDLE,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpname: super::super::Foundation::PWSTR,
        dwdesiredaccess: u32,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptiledresource: ::windows::runtime::RawPtr,
        pnumtilesforentireresource: *mut u32,
        ppackedmipdesc: *mut D3D11_PACKED_MIP_DESC,
        pstandardtileshapefornonpackedmips: *mut D3D11_TILE_SHAPE,
        pnumsubresourcetilings: *mut u32,
        firstsubresourcetilingtoget: u32,
        psubresourcetilingsfornonpackedmips: *mut D3D11_SUBRESOURCE_TILING,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        flags: u32,
        pnumqualitylevels: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID3D11Device3(::windows::runtime::IUnknown);
impl ID3D11Device3 {
    pub unsafe fn CreateBuffer(
        &self,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Buffer> {
        let mut result__: <ID3D11Buffer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Buffer>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture1D(
        &self,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture1D> {
        let mut result__: <ID3D11Texture1D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture1D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture2D(
        &self,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture2D> {
        let mut result__: <ID3D11Texture2D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture2D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture3D(
        &self,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture3D> {
        let mut result__: <ID3D11Texture3D as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture3D>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11ShaderResourceView> {
        let mut result__: <ID3D11ShaderResourceView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11ShaderResourceView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11UnorderedAccessView> {
        let mut result__: <ID3D11UnorderedAccessView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11UnorderedAccessView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11RenderTargetView> {
        let mut result__: <ID3D11RenderTargetView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RenderTargetView>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateDepthStencilView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilView> {
        let mut result__: <ID3D11DepthStencilView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilView>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn CreateInputLayout(
        &self,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
    ) -> ::windows::runtime::Result<ID3D11InputLayout> {
        let mut result__: <ID3D11InputLayout as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pinputelementdescs),
            ::std::mem::transmute(numelements),
            ::std::mem::transmute(pshaderbytecodewithinputsignature),
            ::std::mem::transmute(bytecodelength),
            &mut result__,
        )
        .from_abi::<ID3D11InputLayout>(result__)
    }
    pub unsafe fn CreateVertexShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11VertexShader> {
        let mut result__: <ID3D11VertexShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11VertexShader>(result__)
    }
    pub unsafe fn CreateGeometryShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateGeometryShaderWithStreamOutput<
        'a,
        Param7: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: Param7,
    ) -> ::windows::runtime::Result<ID3D11GeometryShader> {
        let mut result__: <ID3D11GeometryShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            ::std::mem::transmute(psodeclaration),
            ::std::mem::transmute(numentries),
            ::std::mem::transmute(pbufferstrides),
            ::std::mem::transmute(numstrides),
            ::std::mem::transmute(rasterizedstream),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11GeometryShader>(result__)
    }
    pub unsafe fn CreatePixelShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11PixelShader> {
        let mut result__: <ID3D11PixelShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11PixelShader>(result__)
    }
    pub unsafe fn CreateHullShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11HullShader> {
        let mut result__: <ID3D11HullShader as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11HullShader>(result__)
    }
    pub unsafe fn CreateDomainShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11DomainShader> {
        let mut result__: <ID3D11DomainShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11DomainShader>(result__)
    }
    pub unsafe fn CreateComputeShader<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID3D11ClassLinkage>,
    >(
        &self,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: Param2,
    ) -> ::windows::runtime::Result<ID3D11ComputeShader> {
        let mut result__: <ID3D11ComputeShader as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshaderbytecode),
            ::std::mem::transmute(bytecodelength),
            pclasslinkage.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID3D11ComputeShader>(result__)
    }
    pub unsafe fn CreateClassLinkage(&self) -> ::windows::runtime::Result<ID3D11ClassLinkage> {
        let mut result__: <ID3D11ClassLinkage as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID3D11ClassLinkage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBlendState(
        &self,
        pblendstatedesc: *const D3D11_BLEND_DESC,
    ) -> ::windows::runtime::Result<ID3D11BlendState> {
        let mut result__: <ID3D11BlendState as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pblendstatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11BlendState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateDepthStencilState(
        &self,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
    ) -> ::windows::runtime::Result<ID3D11DepthStencilState> {
        let mut result__: <ID3D11DepthStencilState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdepthstencildesc),
            &mut result__,
        )
        .from_abi::<ID3D11DepthStencilState>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState> {
        let mut result__: <ID3D11RasterizerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState>(result__)
    }
    pub unsafe fn CreateSamplerState(
        &self,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
    ) -> ::windows::runtime::Result<ID3D11SamplerState> {
        let mut result__: <ID3D11SamplerState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(psamplerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11SamplerState>(result__)
    }
    pub unsafe fn CreateQuery(
        &self,
        pquerydesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Query> {
        let mut result__: <ID3D11Query as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pquerydesc),
            &mut result__,
        )
        .from_abi::<ID3D11Query>(result__)
    }
    pub unsafe fn CreatePredicate(
        &self,
        ppredicatedesc: *const D3D11_QUERY_DESC,
    ) -> ::windows::runtime::Result<ID3D11Predicate> {
        let mut result__: <ID3D11Predicate as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppredicatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11Predicate>(result__)
    }
    pub unsafe fn CreateCounter(
        &self,
        pcounterdesc: *const D3D11_COUNTER_DESC,
    ) -> ::windows::runtime::Result<ID3D11Counter> {
        let mut result__: <ID3D11Counter as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterdesc),
            &mut result__,
        )
        .from_abi::<ID3D11Counter>(result__)
    }
    pub unsafe fn CreateDeferredContext(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext> {
        let mut result__: <ID3D11DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResource<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        hresource: Param0,
        result__: *mut ::std::option::Option<T>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            hresource.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            result__ as *mut _ as *mut _,
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckFormatSupport(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckMultisampleQualityLevels(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            ::std::mem::transmute(samplecount),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CheckCounterInfo(&self, pcounterinfo: *mut D3D11_COUNTER_INFO) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcounterinfo),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CheckCounter(
        &self,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pactivecounters),
            ::std::mem::transmute(szname),
            ::std::mem::transmute(pnamelength),
            ::std::mem::transmute(szunits),
            ::std::mem::transmute(punitslength),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pdescriptionlength),
        )
        .ok()
    }
    pub unsafe fn CheckFeatureSupport(
        &self,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(feature),
            ::std::mem::transmute(pfeaturesupportdata),
            ::std::mem::transmute(featuresupportdatasize),
        )
        .ok()
    }
    pub unsafe fn GetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(pdatasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateData(
        &self,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            ::std::mem::transmute(datasize),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn SetPrivateDataInterface<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        guid: *const ::windows::runtime::GUID,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetFeatureLevel(&self) -> D3D_FEATURE_LEVEL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetCreationFlags(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetDeviceRemovedReason(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetImmediateContext(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn SetExceptionMode(&self, raiseflags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(raiseflags),
        )
        .ok()
    }
    pub unsafe fn GetExceptionMode(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetImmediateContext1(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext1>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn CreateDeferredContext1(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext1> {
        let mut result__: <ID3D11DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext1>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBlendState1(
        &self,
        pblendstatedesc: *const D3D11_BLEND_DESC1,
    ) -> ::windows::runtime::Result<ID3D11BlendState1> {
        let mut result__: <ID3D11BlendState1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pblendstatedesc),
            &mut result__,
        )
        .from_abi::<ID3D11BlendState1>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState1(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC1,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState1> {
        let mut result__: <ID3D11RasterizerState1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState1>(result__)
    }
    pub unsafe fn CreateDeviceContextState(
        &self,
        flags: u32,
        pfeaturelevels: *const D3D_FEATURE_LEVEL,
        featurelevels: u32,
        sdkversion: u32,
        emulatedinterface: *const ::windows::runtime::GUID,
        pchosenfeaturelevel: *mut D3D_FEATURE_LEVEL,
        ppcontextstate: *mut ::std::option::Option<ID3DDeviceContextState>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(flags),
            ::std::mem::transmute(pfeaturelevels),
            ::std::mem::transmute(featurelevels),
            ::std::mem::transmute(sdkversion),
            ::std::mem::transmute(emulatedinterface),
            ::std::mem::transmute(pchosenfeaturelevel),
            ::std::mem::transmute(ppcontextstate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResource1<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        hresource: Param0,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            hresource.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OpenSharedResourceByName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        lpname: Param0,
        dwdesiredaccess: u32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            lpname.into_param().abi(),
            ::std::mem::transmute(dwdesiredaccess),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetImmediateContext2(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext2>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn CreateDeferredContext2(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext2> {
        let mut result__: <ID3D11DeviceContext2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext2>(result__)
    }
    pub unsafe fn GetResourceTiling<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        ptiledresource: Param0,
        pnumtilesforentireresource: *mut u32,
        ppackedmipdesc: *mut D3D11_PACKED_MIP_DESC,
        pstandardtileshapefornonpackedmips: *mut D3D11_TILE_SHAPE,
        pnumsubresourcetilings: *mut u32,
        firstsubresourcetilingtoget: u32,
        psubresourcetilingsfornonpackedmips: *mut D3D11_SUBRESOURCE_TILING,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ptiledresource.into_param().abi(),
            ::std::mem::transmute(pnumtilesforentireresource),
            ::std::mem::transmute(ppackedmipdesc),
            ::std::mem::transmute(pstandardtileshapefornonpackedmips),
            ::std::mem::transmute(pnumsubresourcetilings),
            ::std::mem::transmute(firstsubresourcetilingtoget),
            ::std::mem::transmute(psubresourcetilingsfornonpackedmips),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CheckMultisampleQualityLevels1(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        flags: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
            ::std::mem::transmute(samplecount),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture2D1(
        &self,
        pdesc1: *const D3D11_TEXTURE2D_DESC1,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture2D1> {
        let mut result__: <ID3D11Texture2D1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc1),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture2D1>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateTexture3D1(
        &self,
        pdesc1: *const D3D11_TEXTURE3D_DESC1,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
    ) -> ::windows::runtime::Result<ID3D11Texture3D1> {
        let mut result__: <ID3D11Texture3D1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdesc1),
            ::std::mem::transmute(pinitialdata),
            &mut result__,
        )
        .from_abi::<ID3D11Texture3D1>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateRasterizerState2(
        &self,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC2,
    ) -> ::windows::runtime::Result<ID3D11RasterizerState2> {
        let mut result__: <ID3D11RasterizerState2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prasterizerdesc),
            &mut result__,
        )
        .from_abi::<ID3D11RasterizerState2>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateShaderResourceView1<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc1: *const D3D11_SHADER_RESOURCE_VIEW_DESC1,
    ) -> ::windows::runtime::Result<ID3D11ShaderResourceView1> {
        let mut result__: <ID3D11ShaderResourceView1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc1),
            &mut result__,
        )
        .from_abi::<ID3D11ShaderResourceView1>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateUnorderedAccessView1<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc1: *const D3D11_UNORDERED_ACCESS_VIEW_DESC1,
    ) -> ::windows::runtime::Result<ID3D11UnorderedAccessView1> {
        let mut result__: <ID3D11UnorderedAccessView1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc1),
            &mut result__,
        )
        .from_abi::<ID3D11UnorderedAccessView1>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateRenderTargetView1<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        presource: Param0,
        pdesc1: *const D3D11_RENDER_TARGET_VIEW_DESC1,
    ) -> ::windows::runtime::Result<ID3D11RenderTargetView1> {
        let mut result__: <ID3D11RenderTargetView1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            presource.into_param().abi(),
            ::std::mem::transmute(pdesc1),
            &mut result__,
        )
        .from_abi::<ID3D11RenderTargetView1>(result__)
    }
    pub unsafe fn CreateQuery1(
        &self,
        pquerydesc1: *const D3D11_QUERY_DESC1,
    ) -> ::windows::runtime::Result<ID3D11Query1> {
        let mut result__: <ID3D11Query1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pquerydesc1),
            &mut result__,
        )
        .from_abi::<ID3D11Query1>(result__)
    }
    pub unsafe fn GetImmediateContext3(
        &self,
        ppimmediatecontext: *mut ::std::option::Option<ID3D11DeviceContext3>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppimmediatecontext),
        ))
    }
    pub unsafe fn CreateDeferredContext3(
        &self,
        contextflags: u32,
    ) -> ::windows::runtime::Result<ID3D11DeviceContext3> {
        let mut result__: <ID3D11DeviceContext3 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(contextflags),
            &mut result__,
        )
        .from_abi::<ID3D11DeviceContext3>(result__)
    }
    pub unsafe fn WriteToSubresource<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        pdstresource: Param0,
        dstsubresource: u32,
        pdstbox: *const D3D11_BOX,
        psrcdata: *const ::std::ffi::c_void,
        srcrowpitch: u32,
        srcdepthpitch: u32,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            pdstresource.into_param().abi(),
            ::std::mem::transmute(dstsubresource),
            ::std::mem::transmute(pdstbox),
            ::std::mem::transmute(psrcdata),
            ::std::mem::transmute(srcrowpitch),
            ::std::mem::transmute(srcdepthpitch),
        ))
    }
    pub unsafe fn ReadFromSubresource<
        'a,
        Param3: ::windows::runtime::IntoParam<'a, ID3D11Resource>,
    >(
        &self,
        pdstdata: *mut ::std::ffi::c_void,
        dstrowpitch: u32,
        dstdepthpitch: u32,
        psrcresource: Param3,
        srcsubresource: u32,
        psrcbox: *const D3D11_BOX,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdstdata),
            ::std::mem::transmute(dstrowpitch),
            ::std::mem::transmute(dstdepthpitch),
            psrcresource.into_param().abi(),
            ::std::mem::transmute(srcsubresource),
            ::std::mem::transmute(psrcbox),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID3D11Device3 {
    type Vtable = ID3D11Device3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2690419767,
        53958,
        18226,
        [179, 160, 156, 224, 176, 220, 154, 230],
    );
}
impl ::std::convert::From<ID3D11Device3> for ::windows::runtime::IUnknown {
    fn from(value: ID3D11Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device3> for ::windows::runtime::IUnknown {
    fn from(value: &ID3D11Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID3D11Device3> for ID3D11Device2 {
    fn from(value: ID3D11Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device3> for ID3D11Device2 {
    fn from(value: &ID3D11Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device2> for ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device2> for &ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID3D11Device3> for ID3D11Device1 {
    fn from(value: ID3D11Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device3> for ID3D11Device1 {
    fn from(value: &ID3D11Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device1> for ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device1> for &ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID3D11Device3> for ID3D11Device {
    fn from(value: ID3D11Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID3D11Device3> for ID3D11Device {
    fn from(value: &ID3D11Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device> for ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID3D11Device> for &ID3D11Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID3D11Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID3D11Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID3D11Device3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_BUFFER_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        ppbuffer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE1D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture1d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE2D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture2d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_TEXTURE3D_DESC,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture3d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_SHADER_RESOURCE_VIEW_DESC,
        ppsrview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_UNORDERED_ACCESS_VIEW_DESC,
        ppuaview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_RENDER_TARGET_VIEW_DESC,
        pprtview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_DEPTH_STENCIL_VIEW_DESC,
        ppdepthstencilview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pinputelementdescs: *const D3D11_INPUT_ELEMENT_DESC,
        numelements: u32,
        pshaderbytecodewithinputsignature: *const ::std::ffi::c_void,
        bytecodelength: usize,
        ppinputlayout: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppvertexshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        psodeclaration: *const D3D11_SO_DECLARATION_ENTRY,
        numentries: u32,
        pbufferstrides: *const u32,
        numstrides: u32,
        rasterizedstream: u32,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppgeometryshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pppixelshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        pphullshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppdomainshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshaderbytecode: *const ::std::ffi::c_void,
        bytecodelength: usize,
        pclasslinkage: ::windows::runtime::RawPtr,
        ppcomputeshader: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pplinkage: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pblendstatedesc: *const D3D11_BLEND_DESC,
        ppblendstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdepthstencildesc: *const D3D11_DEPTH_STENCIL_DESC,
        ppdepthstencilstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psamplerdesc: *const D3D11_SAMPLER_DESC,
        ppsamplerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pquerydesc: *const D3D11_QUERY_DESC,
        ppquery: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppredicatedesc: *const D3D11_QUERY_DESC,
        pppredicate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterdesc: *const D3D11_COUNTER_DESC,
        ppcounter: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hresource: super::super::Foundation::HANDLE,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        pformatsupport: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        pnumqualitylevels: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcounterinfo: *mut D3D11_COUNTER_INFO,
    ),
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc: *const D3D11_COUNTER_DESC,
        ptype: *mut D3D11_COUNTER_TYPE,
        pactivecounters: *mut u32,
        szname: super::super::Foundation::PSTR,
        pnamelength: *mut u32,
        szunits: super::super::Foundation::PSTR,
        punitslength: *mut u32,
        szdescription: super::super::Foundation::PSTR,
        pdescriptionlength: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        feature: D3D11_FEATURE,
        pfeaturesupportdata: *mut ::std::ffi::c_void,
        featuresupportdatasize: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdatasize: *mut u32,
        pdata: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        datasize: u32,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D3D_FEATURE_LEVEL,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        raiseflags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pblendstatedesc: *const D3D11_BLEND_DESC1,
        ppblendstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC1,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flags: u32,
        pfeaturelevels: *const D3D_FEATURE_LEVEL,
        featurelevels: u32,
        sdkversion: u32,
        emulatedinterface: *const ::windows::runtime::GUID,
        pchosenfeaturelevel: *mut D3D_FEATURE_LEVEL,
        ppcontextstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hresource: super::super::Foundation::HANDLE,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpname: super::super::Foundation::PWSTR,
        dwdesiredaccess: u32,
        returnedinterface: *const ::windows::runtime::GUID,
        ppresource: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppimmediatecontext: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        contextflags: u32,
        ppdeferredcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptiledresource: ::windows::runtime::RawPtr,
        pnumtilesforentireresource: *mut u32,
        ppackedmipdesc: *mut D3D11_PACKED_MIP_DESC,
        pstandardtileshapefornonpackedmips: *mut D3D11_TILE_SHAPE,
        pnumsubresourcetilings: *mut u32,
        firstsubresourcetilingtoget: u32,
        psubresourcetilingsfornonpackedmips: *mut D3D11_SUBRESOURCE_TILING,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
        samplecount: u32,
        flags: u32,
        pnumqualitylevels: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc1: *const D3D11_TEXTURE2D_DESC1,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture2d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdesc1: *const D3D11_TEXTURE3D_DESC1,
        pinitialdata: *const D3D11_SUBRESOURCE_DATA,
        pptexture3d: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prasterizerdesc: *const D3D11_RASTERIZER_DESC2,
        pprasterizerstate: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
        pdesc1: *const D3D11_SHADER_RESOURCE_VIEW_DESC1,
        ppsrview1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        presource: ::windows::runtime::RawPtr,
 