#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
pub const CLSID_D2D12DAffineTransform: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1789490309,
        25428,
        19708,
        [144, 140, 228, 167, 79, 98, 201, 108],
    );
pub const CLSID_D2D13DPerspectiveTransform: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3263450379,
        15750,
        18151,
        [133, 186, 82, 108, 146, 64, 243, 251],
    );
pub const CLSID_D2D13DTransform: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3896933124,
    60513,
    19338,
    [181, 222, 212, 215, 61, 235, 234, 90],
);
pub const CLSID_D2D1AlphaMask: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3356413936,
    16341,
    20229,
    [131, 40, 197, 209, 114, 75, 79, 10],
);
pub const CLSID_D2D1ArithmeticComposite: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4229239863,
        1178,
        18308,
        [162, 74, 241, 196, 218, 242, 9, 135],
    );
pub const CLSID_D2D1Atlas: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2436770788,
    64975,
    20450,
    [165, 240, 36, 84, 241, 79, 244, 8],
);
pub const CLSID_D2D1BitmapSource: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1605812813,
    50909,
    16945,
    [148, 4, 80, 244, 213, 195, 37, 45],
);
pub const CLSID_D2D1Blend: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2177218427,
    5112,
    19677,
    [173, 32, 200, 144, 84, 122, 198, 93],
);
pub const CLSID_D2D1Border: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    707611072,
    19151,
    17351,
    [140, 106, 124, 74, 39, 135, 77, 39],
);
pub const CLSID_D2D1Brightness: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2364181790,
    30640,
    18822,
    [179, 185, 47, 12, 14, 174, 120, 135],
);
pub const CLSID_D2D1ChromaKey: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1958747995,
    10765,
    16524,
    [136, 226, 199, 163, 199, 25, 119, 66],
);
pub const CLSID_D2D1ColorManagement: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        438850124,
        64982,
        19108,
        [174, 143, 131, 126, 184, 38, 123, 55],
    );
pub const CLSID_D2D1ColorMatrix: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2451506134,
    25628,
    18399,
    [133, 45, 180, 187, 97, 83, 174, 17],
);
pub const CLSID_D2D1Composite: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1224515409,
    63148,
    18673,
    [139, 88, 59, 40, 172, 70, 247, 109],
);
pub const CLSID_D2D1Contrast: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3058214794,
    3797,
    20352,
    [169, 74, 142, 130, 90, 202, 107, 119],
);
pub const CLSID_D2D1ConvolveMatrix: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1082100744,
        21811,
        17201,
        [163, 65, 35, 204, 56, 119, 132, 62],
    );
pub const CLSID_D2D1Crop: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3795808528,
    3738,
    17188,
    [175, 71, 106, 44, 12, 70, 243, 91],
);
pub const CLSID_D2D1CrossFade: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    318076392,
    19889,
    18527,
    [154, 132, 3, 160, 125, 211, 130, 159],
);
pub const CLSID_D2D1DirectionalBlur: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        390273446,
        22761,
        18866,
        [187, 99, 202, 242, 200, 17, 163, 219],
    );
pub const CLSID_D2D1DiscreteTransfer: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2424729549,
        18574,
        17739,
        [175, 6, 229, 4, 27, 102, 195, 108],
    );
pub const CLSID_D2D1DisplacementMap: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3989078884,
        1047,
        16657,
        [148, 80, 67, 132, 95, 169, 248, 144],
    );
pub const CLSID_D2D1DistantDiffuse: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1048509794,
        41773,
        18132,
        [168, 60, 82, 120, 136, 154, 201, 84],
    );
pub const CLSID_D2D1DistantSpecular: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1116479205,
        30648,
        17488,
        [138, 181, 114, 33, 156, 33, 171, 218],
    );
pub const CLSID_D2D1DpiCompensation: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1814480327,
        13536,
        18172,
        [156, 253, 229, 130, 55, 6, 226, 40],
    );
pub const CLSID_D2D1EdgeDetection: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4025844682,
    51975,
    19113,
    [172, 93, 44, 196, 76, 118, 70, 15],
);
pub const CLSID_D2D1Emboss: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2982538027,
    840,
    17392,
    [129, 7, 73, 87, 202, 203, 162, 174],
);
pub const CLSID_D2D1Exposure: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3043790074,
    63028,
    16878,
    [190, 224, 255, 166, 23, 16, 96, 4],
);
pub const CLSID_D2D1Flood: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1640119328,
    44649,
    19854,
    [148, 207, 80, 7, 141, 246, 56, 242],
);
pub const CLSID_D2D1GammaTransfer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1083458756,
    50201,
    16800,
    [176, 193, 140, 208, 192, 161, 142, 66],
);
pub const CLSID_D2D1GaussianBlur: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    535522665,
    12262,
    19145,
    [140, 88, 29, 127, 147, 231, 166, 165],
);
pub const CLSID_D2D1Grayscale: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    920510699,
    14117,
    17120,
    [131, 109, 82, 251, 32, 174, 230, 68],
);
pub const CLSID_D2D1HdrToneMap: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2064348301,
    17936,
    17542,
    [169, 12, 153, 157, 154, 46, 43, 17],
);
pub const CLSID_D2D1HighlightsShadows: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3403449220,
        12863,
        19582,
        [163, 97, 46, 43, 36, 223, 110, 228],
    );
pub const CLSID_D2D1Histogram: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2283648976,
    63470,
    19789,
    [166, 210, 70, 151, 172, 198, 110, 232],
);
pub const CLSID_D2D1HueRotation: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    256137452,
    19250,
    18715,
    [158, 133, 189, 115, 244, 77, 62, 182],
);
pub const CLSID_D2D1HueToRgb: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2071504573,
    321,
    19951,
    [138, 82, 99, 86, 238, 12, 189, 213],
);
pub const CLSID_D2D1Invert: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3770906701,
    52025,
    20100,
    [182, 253, 107, 114, 240, 129, 2, 99],
);
pub const CLSID_D2D1LinearTransfer: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2907162877,
        25583,
        19148,
        [155, 81, 103, 151, 156, 3, 108, 6],
    );
pub const CLSID_D2D1LookupTable3D: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    882773722,
    136,
    19065,
    [156, 163, 199, 227, 0, 32, 32, 32],
);
pub const CLSID_D2D1LuminanceToAlpha: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1092950711,
        3051,
        18168,
        [157, 167, 89, 233, 63, 204, 229, 222],
    );
pub const CLSID_D2D1Morphology: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3940992013,
    25194,
    19501,
    [191, 203, 57, 16, 1, 171, 226, 2],
);
pub const CLSID_D2D1Opacity: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2166192548,
    56872,
    17492,
    [128, 148, 198, 70, 133, 248, 189, 76],
);
pub const CLSID_D2D1OpacityMetadata: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1817378922,
        17488,
        16793,
        [170, 91, 173, 22, 86, 254, 206, 94],
    );
pub const CLSID_D2D1PointDiffuse: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3118662595,
    49292,
    20369,
    [139, 123, 56, 101, 107, 196, 140, 32],
);
pub const CLSID_D2D1PointSpecular: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    163826214,
    15074,
    20233,
    [158, 188, 237, 56, 101, 213, 63, 34],
);
pub const CLSID_D2D1Posterize: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    562599006,
    13219,
    17254,
    [183, 188, 8, 107, 208, 45, 8, 132],
);
pub const CLSID_D2D1Premultiply: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    116044825,
    57069,
    16408,
    [128, 210, 62, 29, 71, 26, 222, 178],
);
pub const CLSID_D2D1RgbToHue: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    603186668,
    37352,
    19773,
    [173, 10, 175, 173, 193, 0, 74, 161],
);
pub const CLSID_D2D1Saturation: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1555225039,
    12925,
    17823,
    [160, 206, 64, 192, 178, 8, 107, 247],
);
pub const CLSID_D2D1Scale: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2645529449,
    14406,
    19726,
    [164, 78, 12, 96, 121, 52, 165, 215],
);
pub const CLSID_D2D1Sepia: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    974844944,
    24349,
    19902,
    [132, 223, 145, 93, 167, 155, 113, 83],
);
pub const CLSID_D2D1Shadow: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3330188129,
    6243,
    20073,
    [137, 219, 105, 93, 62, 154, 91, 107],
);
pub const CLSID_D2D1Sharpen: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3384313803,
    50687,
    19909,
    [151, 121, 39, 61, 207, 65, 124, 125],
);
pub const CLSID_D2D1SpotDiffuse: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2173309189,
    31026,
    17652,
    [170, 134, 8, 174, 123, 47, 44, 147],
);
pub const CLSID_D2D1SpotSpecular: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3987620382,
    30292,
    18999,
    [157, 184, 113, 172, 193, 190, 179, 193],
);
pub const CLSID_D2D1Straighten: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1302625042,
    31139,
    20400,
    [130, 55, 187, 195, 178, 164, 222, 8],
);
pub const CLSID_D2D1TableTransfer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1542985923,
    24131,
    18635,
    [182, 49, 134, 131, 150, 214, 161, 212],
);
pub const CLSID_D2D1TemperatureTint: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2300010631,
        35577,
        18952,
        [174, 177, 137, 95, 56, 219, 23, 102],
    );
pub const CLSID_D2D1Tile: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2960671032,
    15222,
    19397,
    [177, 59, 15, 162, 173, 2, 101, 159],
);
pub const CLSID_D2D1Tint: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    909191959,
    63453,
    16404,
    [145, 93, 255, 202, 118, 140, 242, 17],
);
pub const CLSID_D2D1Turbulence: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3475748526,
    34970,
    19159,
    [186, 41, 162, 253, 115, 44, 159, 201],
);
pub const CLSID_D2D1UnPremultiply: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4221224073,
    44429,
    16877,
    [153, 153, 187, 99, 71, 209, 16, 247],
);
pub const CLSID_D2D1Vignette: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3222028478,
    24167,
    19619,
    [149, 180, 244, 176, 44, 17, 81, 53],
);
pub const CLSID_D2D1WhiteLevelAdjustment: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1151453915,
        27869,
        18456,
        [143, 244, 38, 193, 207, 233, 91, 219],
    );
pub const CLSID_D2D1YCbCr: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2572172481,
    26311,
    17865,
    [168, 117, 138, 216, 167, 145, 68, 1],
);
#[cfg(feature = "Foundation_Numerics")]
pub unsafe fn D2D1ComputeMaximumScaleFactor(
    matrix: *const super::super::super::Foundation::Numerics::Matrix3x2,
) -> f32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1ComputeMaximumScaleFactor(
                matrix: *const super::super::super::Foundation::Numerics::Matrix3x2,
            ) -> f32;
        }
        ::std::mem::transmute(D2D1ComputeMaximumScaleFactor(::std::mem::transmute(matrix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D2D1ConvertColorSpace(
    sourcecolorspace: D2D1_COLOR_SPACE,
    destinationcolorspace: D2D1_COLOR_SPACE,
    color: *const D2D1_COLOR_F,
) -> D2D1_COLOR_F {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1ConvertColorSpace(
                sourcecolorspace: D2D1_COLOR_SPACE,
                destinationcolorspace: D2D1_COLOR_SPACE,
                color: *const D2D1_COLOR_F,
            ) -> D2D1_COLOR_F;
        }
        ::std::mem::transmute(D2D1ConvertColorSpace(
            ::std::mem::transmute(sourcecolorspace),
            ::std::mem::transmute(destinationcolorspace),
            ::std::mem::transmute(color),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub unsafe fn D2D1CreateDevice<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGIDevice>,
>(
    dxgidevice: Param0,
    creationproperties: *const D2D1_CREATION_PROPERTIES,
) -> ::windows::runtime::Result<ID2D1Device> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1CreateDevice(
                dxgidevice: ::windows::runtime::RawPtr,
                creationproperties: *const D2D1_CREATION_PROPERTIES,
                d2ddevice: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <ID2D1Device as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        D2D1CreateDevice(
            dxgidevice.into_param().abi(),
            ::std::mem::transmute(creationproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Device>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub unsafe fn D2D1CreateDeviceContext<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGISurface>,
>(
    dxgisurface: Param0,
    creationproperties: *const D2D1_CREATION_PROPERTIES,
) -> ::windows::runtime::Result<ID2D1DeviceContext> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1CreateDeviceContext(
                dxgisurface: ::windows::runtime::RawPtr,
                creationproperties: *const D2D1_CREATION_PROPERTIES,
                d2ddevicecontext: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        D2D1CreateDeviceContext(
            dxgisurface.into_param().abi(),
            ::std::mem::transmute(creationproperties),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D2D1CreateFactory(
    factorytype: D2D1_FACTORY_TYPE,
    riid: *const ::windows::runtime::GUID,
    pfactoryoptions: *const D2D1_FACTORY_OPTIONS,
    ppifactory: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1CreateFactory(
                factorytype: D2D1_FACTORY_TYPE,
                riid: *const ::windows::runtime::GUID,
                pfactoryoptions: *const D2D1_FACTORY_OPTIONS,
                ppifactory: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        D2D1CreateFactory(
            ::std::mem::transmute(factorytype),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(pfactoryoptions),
            ::std::mem::transmute(ppifactory),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D2D1GetGradientMeshInteriorPointsFromCoonsPatch(
    ppoint0: *const D2D_POINT_2F,
    ppoint1: *const D2D_POINT_2F,
    ppoint2: *const D2D_POINT_2F,
    ppoint3: *const D2D_POINT_2F,
    ppoint4: *const D2D_POINT_2F,
    ppoint5: *const D2D_POINT_2F,
    ppoint6: *const D2D_POINT_2F,
    ppoint7: *const D2D_POINT_2F,
    ppoint8: *const D2D_POINT_2F,
    ppoint9: *const D2D_POINT_2F,
    ppoint10: *const D2D_POINT_2F,
    ppoint11: *const D2D_POINT_2F,
    ptensorpoint11: *mut D2D_POINT_2F,
    ptensorpoint12: *mut D2D_POINT_2F,
    ptensorpoint21: *mut D2D_POINT_2F,
    ptensorpoint22: *mut D2D_POINT_2F,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1GetGradientMeshInteriorPointsFromCoonsPatch(
                ppoint0: *const D2D_POINT_2F,
                ppoint1: *const D2D_POINT_2F,
                ppoint2: *const D2D_POINT_2F,
                ppoint3: *const D2D_POINT_2F,
                ppoint4: *const D2D_POINT_2F,
                ppoint5: *const D2D_POINT_2F,
                ppoint6: *const D2D_POINT_2F,
                ppoint7: *const D2D_POINT_2F,
                ppoint8: *const D2D_POINT_2F,
                ppoint9: *const D2D_POINT_2F,
                ppoint10: *const D2D_POINT_2F,
                ppoint11: *const D2D_POINT_2F,
                ptensorpoint11: *mut D2D_POINT_2F,
                ptensorpoint12: *mut D2D_POINT_2F,
                ptensorpoint21: *mut D2D_POINT_2F,
                ptensorpoint22: *mut D2D_POINT_2F,
            );
        }
        ::std::mem::transmute(D2D1GetGradientMeshInteriorPointsFromCoonsPatch(
            ::std::mem::transmute(ppoint0),
            ::std::mem::transmute(ppoint1),
            ::std::mem::transmute(ppoint2),
            ::std::mem::transmute(ppoint3),
            ::std::mem::transmute(ppoint4),
            ::std::mem::transmute(ppoint5),
            ::std::mem::transmute(ppoint6),
            ::std::mem::transmute(ppoint7),
            ::std::mem::transmute(ppoint8),
            ::std::mem::transmute(ppoint9),
            ::std::mem::transmute(ppoint10),
            ::std::mem::transmute(ppoint11),
            ::std::mem::transmute(ptensorpoint11),
            ::std::mem::transmute(ptensorpoint12),
            ::std::mem::transmute(ptensorpoint21),
            ::std::mem::transmute(ptensorpoint22),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Foundation"))]
pub unsafe fn D2D1InvertMatrix(
    matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1InvertMatrix(
                matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(D2D1InvertMatrix(::std::mem::transmute(matrix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Foundation_Numerics", feature = "Win32_Foundation"))]
pub unsafe fn D2D1IsMatrixInvertible(
    matrix: *const super::super::super::Foundation::Numerics::Matrix3x2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1IsMatrixInvertible(
                matrix: *const super::super::super::Foundation::Numerics::Matrix3x2,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(D2D1IsMatrixInvertible(::std::mem::transmute(matrix)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Foundation_Numerics")]
pub unsafe fn D2D1MakeRotateMatrix<'a, Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>>(
    angle: f32,
    center: Param1,
    matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1MakeRotateMatrix(
                angle: f32,
                center: D2D_POINT_2F,
                matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2,
            );
        }
        ::std::mem::transmute(D2D1MakeRotateMatrix(
            ::std::mem::transmute(angle),
            center.into_param().abi(),
            ::std::mem::transmute(matrix),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Foundation_Numerics")]
pub unsafe fn D2D1MakeSkewMatrix<'a, Param2: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>>(
    anglex: f32,
    angley: f32,
    center: Param2,
    matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1MakeSkewMatrix(
                anglex: f32,
                angley: f32,
                center: D2D_POINT_2F,
                matrix: *mut super::super::super::Foundation::Numerics::Matrix3x2,
            );
        }
        ::std::mem::transmute(D2D1MakeSkewMatrix(
            ::std::mem::transmute(anglex),
            ::std::mem::transmute(angley),
            center.into_param().abi(),
            ::std::mem::transmute(matrix),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D2D1SinCos(angle: f32, s: *mut f32, c: *mut f32) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1SinCos(angle: f32, s: *mut f32, c: *mut f32);
        }
        ::std::mem::transmute(D2D1SinCos(
            ::std::mem::transmute(angle),
            ::std::mem::transmute(s),
            ::std::mem::transmute(c),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D2D1Tan(angle: f32) -> f32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1Tan(angle: f32) -> f32;
        }
        ::std::mem::transmute(D2D1Tan(::std::mem::transmute(angle)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn D2D1Vec3Length(x: f32, y: f32, z: f32) -> f32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn D2D1Vec3Length(x: f32, y: f32, z: f32) -> f32;
        }
        ::std::mem::transmute(D2D1Vec3Length(
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            ::std::mem::transmute(z),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(pub u32);
pub const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR:
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE = D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(0u32);
pub const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_LINEAR:
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE = D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(1u32);
pub const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_CUBIC:
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE = D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(2u32);
pub const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR:
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE = D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(3u32);
pub const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC:
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE = D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(4u32);
pub const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC:
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE = D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(5u32);
pub const D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE_FORCE_DWORD:
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE =
    D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_2DAFFINETRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_2DAFFINETRANSFORM_PROP(pub u32);
pub const D2D1_2DAFFINETRANSFORM_PROP_INTERPOLATION_MODE: D2D1_2DAFFINETRANSFORM_PROP =
    D2D1_2DAFFINETRANSFORM_PROP(0u32);
pub const D2D1_2DAFFINETRANSFORM_PROP_BORDER_MODE: D2D1_2DAFFINETRANSFORM_PROP =
    D2D1_2DAFFINETRANSFORM_PROP(1u32);
pub const D2D1_2DAFFINETRANSFORM_PROP_TRANSFORM_MATRIX: D2D1_2DAFFINETRANSFORM_PROP =
    D2D1_2DAFFINETRANSFORM_PROP(2u32);
pub const D2D1_2DAFFINETRANSFORM_PROP_SHARPNESS: D2D1_2DAFFINETRANSFORM_PROP =
    D2D1_2DAFFINETRANSFORM_PROP(3u32);
pub const D2D1_2DAFFINETRANSFORM_PROP_FORCE_DWORD: D2D1_2DAFFINETRANSFORM_PROP =
    D2D1_2DAFFINETRANSFORM_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_2DAFFINETRANSFORM_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_2DAFFINETRANSFORM_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_2DAFFINETRANSFORM_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_2DAFFINETRANSFORM_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_2DAFFINETRANSFORM_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_2DAFFINETRANSFORM_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_2DAFFINETRANSFORM_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(pub u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR:
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE =
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(0u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_LINEAR:
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE =
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(1u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_CUBIC:
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE =
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(2u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR:
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE =
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(3u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_ANISOTROPIC:
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE =
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(4u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE_FORCE_DWORD:
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE =
    D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_3DPERSPECTIVETRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_3DPERSPECTIVETRANSFORM_PROP(pub u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_INTERPOLATION_MODE: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(0u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_BORDER_MODE: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(1u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_DEPTH: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(2u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_PERSPECTIVE_ORIGIN: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(3u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_LOCAL_OFFSET: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(4u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_GLOBAL_OFFSET: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(5u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION_ORIGIN: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(6u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_ROTATION: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(7u32);
pub const D2D1_3DPERSPECTIVETRANSFORM_PROP_FORCE_DWORD: D2D1_3DPERSPECTIVETRANSFORM_PROP =
    D2D1_3DPERSPECTIVETRANSFORM_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_3DPERSPECTIVETRANSFORM_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_3DTRANSFORM_INTERPOLATION_MODE(pub u32);
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_NEAREST_NEIGHBOR:
    D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(0u32);
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_LINEAR: D2D1_3DTRANSFORM_INTERPOLATION_MODE =
    D2D1_3DTRANSFORM_INTERPOLATION_MODE(1u32);
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_CUBIC: D2D1_3DTRANSFORM_INTERPOLATION_MODE =
    D2D1_3DTRANSFORM_INTERPOLATION_MODE(2u32);
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR:
    D2D1_3DTRANSFORM_INTERPOLATION_MODE = D2D1_3DTRANSFORM_INTERPOLATION_MODE(3u32);
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_ANISOTROPIC: D2D1_3DTRANSFORM_INTERPOLATION_MODE =
    D2D1_3DTRANSFORM_INTERPOLATION_MODE(4u32);
pub const D2D1_3DTRANSFORM_INTERPOLATION_MODE_FORCE_DWORD: D2D1_3DTRANSFORM_INTERPOLATION_MODE =
    D2D1_3DTRANSFORM_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_3DTRANSFORM_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_3DTRANSFORM_PROP(pub u32);
pub const D2D1_3DTRANSFORM_PROP_INTERPOLATION_MODE: D2D1_3DTRANSFORM_PROP =
    D2D1_3DTRANSFORM_PROP(0u32);
pub const D2D1_3DTRANSFORM_PROP_BORDER_MODE: D2D1_3DTRANSFORM_PROP = D2D1_3DTRANSFORM_PROP(1u32);
pub const D2D1_3DTRANSFORM_PROP_TRANSFORM_MATRIX: D2D1_3DTRANSFORM_PROP =
    D2D1_3DTRANSFORM_PROP(2u32);
pub const D2D1_3DTRANSFORM_PROP_FORCE_DWORD: D2D1_3DTRANSFORM_PROP =
    D2D1_3DTRANSFORM_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_3DTRANSFORM_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_3DTRANSFORM_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_3DTRANSFORM_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_3DTRANSFORM_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_3DTRANSFORM_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_3DTRANSFORM_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_3DTRANSFORM_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_ALPHA_MODE(pub u32);
pub const D2D1_ALPHA_MODE_UNKNOWN: D2D1_ALPHA_MODE = D2D1_ALPHA_MODE(0u32);
pub const D2D1_ALPHA_MODE_PREMULTIPLIED: D2D1_ALPHA_MODE = D2D1_ALPHA_MODE(1u32);
pub const D2D1_ALPHA_MODE_STRAIGHT: D2D1_ALPHA_MODE = D2D1_ALPHA_MODE(2u32);
pub const D2D1_ALPHA_MODE_IGNORE: D2D1_ALPHA_MODE = D2D1_ALPHA_MODE(3u32);
pub const D2D1_ALPHA_MODE_FORCE_DWORD: D2D1_ALPHA_MODE = D2D1_ALPHA_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_ALPHA_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_ALPHA_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_ALPHA_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_ALPHA_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_ALPHA_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_ALPHA_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_ALPHA_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_ANTIALIAS_MODE(pub u32);
pub const D2D1_ANTIALIAS_MODE_PER_PRIMITIVE: D2D1_ANTIALIAS_MODE = D2D1_ANTIALIAS_MODE(0u32);
pub const D2D1_ANTIALIAS_MODE_ALIASED: D2D1_ANTIALIAS_MODE = D2D1_ANTIALIAS_MODE(1u32);
pub const D2D1_ANTIALIAS_MODE_FORCE_DWORD: D2D1_ANTIALIAS_MODE = D2D1_ANTIALIAS_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_ANTIALIAS_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_ANTIALIAS_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_ANTIALIAS_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_ANTIALIAS_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_ANTIALIAS_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_ANTIALIAS_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_ANTIALIAS_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D2D1_APPEND_ALIGNED_ELEMENT: u32 = 4294967295u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_ARC_SEGMENT {
    pub point: D2D_POINT_2F,
    pub size: D2D_SIZE_F,
    pub rotationAngle: f32,
    pub sweepDirection: D2D1_SWEEP_DIRECTION,
    pub arcSize: D2D1_ARC_SIZE,
}
impl D2D1_ARC_SEGMENT {}
impl ::std::default::Default for D2D1_ARC_SEGMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_ARC_SEGMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_ARC_SEGMENT")
            .field("point", &self.point)
            .field("size", &self.size)
            .field("rotationAngle", &self.rotationAngle)
            .field("sweepDirection", &self.sweepDirection)
            .field("arcSize", &self.arcSize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_ARC_SEGMENT {
    fn eq(&self, other: &Self) -> bool {
        self.point == other.point
            && self.size == other.size
            && self.rotationAngle == other.rotationAngle
            && self.sweepDirection == other.sweepDirection
            && self.arcSize == other.arcSize
    }
}
impl ::std::cmp::Eq for D2D1_ARC_SEGMENT {}
unsafe impl ::windows::runtime::Abi for D2D1_ARC_SEGMENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_ARC_SIZE(pub u32);
pub const D2D1_ARC_SIZE_SMALL: D2D1_ARC_SIZE = D2D1_ARC_SIZE(0u32);
pub const D2D1_ARC_SIZE_LARGE: D2D1_ARC_SIZE = D2D1_ARC_SIZE(1u32);
pub const D2D1_ARC_SIZE_FORCE_DWORD: D2D1_ARC_SIZE = D2D1_ARC_SIZE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_ARC_SIZE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_ARC_SIZE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_ARC_SIZE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_ARC_SIZE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_ARC_SIZE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_ARC_SIZE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_ARC_SIZE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_ARITHMETICCOMPOSITE_PROP(pub u32);
pub const D2D1_ARITHMETICCOMPOSITE_PROP_COEFFICIENTS: D2D1_ARITHMETICCOMPOSITE_PROP =
    D2D1_ARITHMETICCOMPOSITE_PROP(0u32);
pub const D2D1_ARITHMETICCOMPOSITE_PROP_CLAMP_OUTPUT: D2D1_ARITHMETICCOMPOSITE_PROP =
    D2D1_ARITHMETICCOMPOSITE_PROP(1u32);
pub const D2D1_ARITHMETICCOMPOSITE_PROP_FORCE_DWORD: D2D1_ARITHMETICCOMPOSITE_PROP =
    D2D1_ARITHMETICCOMPOSITE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_ARITHMETICCOMPOSITE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_ARITHMETICCOMPOSITE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_ARITHMETICCOMPOSITE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_ARITHMETICCOMPOSITE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_ARITHMETICCOMPOSITE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_ARITHMETICCOMPOSITE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_ARITHMETICCOMPOSITE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_ATLAS_PROP(pub u32);
pub const D2D1_ATLAS_PROP_INPUT_RECT: D2D1_ATLAS_PROP = D2D1_ATLAS_PROP(0u32);
pub const D2D1_ATLAS_PROP_INPUT_PADDING_RECT: D2D1_ATLAS_PROP = D2D1_ATLAS_PROP(1u32);
pub const D2D1_ATLAS_PROP_FORCE_DWORD: D2D1_ATLAS_PROP = D2D1_ATLAS_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_ATLAS_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_ATLAS_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_ATLAS_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_ATLAS_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_ATLAS_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_ATLAS_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_ATLAS_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_BEZIER_SEGMENT {
    pub point1: D2D_POINT_2F,
    pub point2: D2D_POINT_2F,
    pub point3: D2D_POINT_2F,
}
impl D2D1_BEZIER_SEGMENT {}
impl ::std::default::Default for D2D1_BEZIER_SEGMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_BEZIER_SEGMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_BEZIER_SEGMENT")
            .field("point1", &self.point1)
            .field("point2", &self.point2)
            .field("point3", &self.point3)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_BEZIER_SEGMENT {
    fn eq(&self, other: &Self) -> bool {
        self.point1 == other.point1 && self.point2 == other.point2 && self.point3 == other.point3
    }
}
impl ::std::cmp::Eq for D2D1_BEZIER_SEGMENT {}
unsafe impl ::windows::runtime::Abi for D2D1_BEZIER_SEGMENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BITMAPSOURCE_ALPHA_MODE(pub u32);
pub const D2D1_BITMAPSOURCE_ALPHA_MODE_PREMULTIPLIED: D2D1_BITMAPSOURCE_ALPHA_MODE =
    D2D1_BITMAPSOURCE_ALPHA_MODE(1u32);
pub const D2D1_BITMAPSOURCE_ALPHA_MODE_STRAIGHT: D2D1_BITMAPSOURCE_ALPHA_MODE =
    D2D1_BITMAPSOURCE_ALPHA_MODE(2u32);
pub const D2D1_BITMAPSOURCE_ALPHA_MODE_FORCE_DWORD: D2D1_BITMAPSOURCE_ALPHA_MODE =
    D2D1_BITMAPSOURCE_ALPHA_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BITMAPSOURCE_ALPHA_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAPSOURCE_ALPHA_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BITMAPSOURCE_ALPHA_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BITMAPSOURCE_ALPHA_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BITMAPSOURCE_ALPHA_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BITMAPSOURCE_ALPHA_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BITMAPSOURCE_ALPHA_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BITMAPSOURCE_INTERPOLATION_MODE(pub u32);
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_NEAREST_NEIGHBOR:
    D2D1_BITMAPSOURCE_INTERPOLATION_MODE = D2D1_BITMAPSOURCE_INTERPOLATION_MODE(0u32);
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_LINEAR: D2D1_BITMAPSOURCE_INTERPOLATION_MODE =
    D2D1_BITMAPSOURCE_INTERPOLATION_MODE(1u32);
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_CUBIC: D2D1_BITMAPSOURCE_INTERPOLATION_MODE =
    D2D1_BITMAPSOURCE_INTERPOLATION_MODE(2u32);
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FANT: D2D1_BITMAPSOURCE_INTERPOLATION_MODE =
    D2D1_BITMAPSOURCE_INTERPOLATION_MODE(6u32);
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_MIPMAP_LINEAR: D2D1_BITMAPSOURCE_INTERPOLATION_MODE =
    D2D1_BITMAPSOURCE_INTERPOLATION_MODE(7u32);
pub const D2D1_BITMAPSOURCE_INTERPOLATION_MODE_FORCE_DWORD: D2D1_BITMAPSOURCE_INTERPOLATION_MODE =
    D2D1_BITMAPSOURCE_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BITMAPSOURCE_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BITMAPSOURCE_ORIENTATION(pub u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_DEFAULT: D2D1_BITMAPSOURCE_ORIENTATION =
    D2D1_BITMAPSOURCE_ORIENTATION(1u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_FLIP_HORIZONTAL: D2D1_BITMAPSOURCE_ORIENTATION =
    D2D1_BITMAPSOURCE_ORIENTATION(2u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180: D2D1_BITMAPSOURCE_ORIENTATION =
    D2D1_BITMAPSOURCE_ORIENTATION(3u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL:
    D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(4u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL:
    D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(5u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90: D2D1_BITMAPSOURCE_ORIENTATION =
    D2D1_BITMAPSOURCE_ORIENTATION(6u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL:
    D2D1_BITMAPSOURCE_ORIENTATION = D2D1_BITMAPSOURCE_ORIENTATION(7u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_ROTATE_CLOCKWISE270: D2D1_BITMAPSOURCE_ORIENTATION =
    D2D1_BITMAPSOURCE_ORIENTATION(8u32);
pub const D2D1_BITMAPSOURCE_ORIENTATION_FORCE_DWORD: D2D1_BITMAPSOURCE_ORIENTATION =
    D2D1_BITMAPSOURCE_ORIENTATION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BITMAPSOURCE_ORIENTATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAPSOURCE_ORIENTATION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BITMAPSOURCE_ORIENTATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BITMAPSOURCE_ORIENTATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BITMAPSOURCE_ORIENTATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BITMAPSOURCE_ORIENTATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BITMAPSOURCE_ORIENTATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BITMAPSOURCE_PROP(pub u32);
pub const D2D1_BITMAPSOURCE_PROP_WIC_BITMAP_SOURCE: D2D1_BITMAPSOURCE_PROP =
    D2D1_BITMAPSOURCE_PROP(0u32);
pub const D2D1_BITMAPSOURCE_PROP_SCALE: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(1u32);
pub const D2D1_BITMAPSOURCE_PROP_INTERPOLATION_MODE: D2D1_BITMAPSOURCE_PROP =
    D2D1_BITMAPSOURCE_PROP(2u32);
pub const D2D1_BITMAPSOURCE_PROP_ENABLE_DPI_CORRECTION: D2D1_BITMAPSOURCE_PROP =
    D2D1_BITMAPSOURCE_PROP(3u32);
pub const D2D1_BITMAPSOURCE_PROP_ALPHA_MODE: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(4u32);
pub const D2D1_BITMAPSOURCE_PROP_ORIENTATION: D2D1_BITMAPSOURCE_PROP = D2D1_BITMAPSOURCE_PROP(5u32);
pub const D2D1_BITMAPSOURCE_PROP_FORCE_DWORD: D2D1_BITMAPSOURCE_PROP =
    D2D1_BITMAPSOURCE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BITMAPSOURCE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAPSOURCE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BITMAPSOURCE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BITMAPSOURCE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BITMAPSOURCE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BITMAPSOURCE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BITMAPSOURCE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_BITMAP_BRUSH_PROPERTIES {
    pub extendModeX: D2D1_EXTEND_MODE,
    pub extendModeY: D2D1_EXTEND_MODE,
    pub interpolationMode: D2D1_BITMAP_INTERPOLATION_MODE,
}
impl D2D1_BITMAP_BRUSH_PROPERTIES {}
impl ::std::default::Default for D2D1_BITMAP_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_BITMAP_BRUSH_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_BITMAP_BRUSH_PROPERTIES")
            .field("extendModeX", &self.extendModeX)
            .field("extendModeY", &self.extendModeY)
            .field("interpolationMode", &self.interpolationMode)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_BITMAP_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.extendModeX == other.extendModeX
            && self.extendModeY == other.extendModeY
            && self.interpolationMode == other.interpolationMode
    }
}
impl ::std::cmp::Eq for D2D1_BITMAP_BRUSH_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAP_BRUSH_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_BITMAP_BRUSH_PROPERTIES1 {
    pub extendModeX: D2D1_EXTEND_MODE,
    pub extendModeY: D2D1_EXTEND_MODE,
    pub interpolationMode: D2D1_INTERPOLATION_MODE,
}
impl D2D1_BITMAP_BRUSH_PROPERTIES1 {}
impl ::std::default::Default for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_BITMAP_BRUSH_PROPERTIES1")
            .field("extendModeX", &self.extendModeX)
            .field("extendModeY", &self.extendModeY)
            .field("interpolationMode", &self.interpolationMode)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    fn eq(&self, other: &Self) -> bool {
        self.extendModeX == other.extendModeX
            && self.extendModeY == other.extendModeY
            && self.interpolationMode == other.interpolationMode
    }
}
impl ::std::cmp::Eq for D2D1_BITMAP_BRUSH_PROPERTIES1 {}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAP_BRUSH_PROPERTIES1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BITMAP_INTERPOLATION_MODE(pub u32);
pub const D2D1_BITMAP_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_BITMAP_INTERPOLATION_MODE =
    D2D1_BITMAP_INTERPOLATION_MODE(0u32);
pub const D2D1_BITMAP_INTERPOLATION_MODE_LINEAR: D2D1_BITMAP_INTERPOLATION_MODE =
    D2D1_BITMAP_INTERPOLATION_MODE(1u32);
pub const D2D1_BITMAP_INTERPOLATION_MODE_FORCE_DWORD: D2D1_BITMAP_INTERPOLATION_MODE =
    D2D1_BITMAP_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BITMAP_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAP_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BITMAP_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BITMAP_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BITMAP_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BITMAP_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BITMAP_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BITMAP_OPTIONS(pub u32);
pub const D2D1_BITMAP_OPTIONS_NONE: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(0u32);
pub const D2D1_BITMAP_OPTIONS_TARGET: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(1u32);
pub const D2D1_BITMAP_OPTIONS_CANNOT_DRAW: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(2u32);
pub const D2D1_BITMAP_OPTIONS_CPU_READ: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(4u32);
pub const D2D1_BITMAP_OPTIONS_GDI_COMPATIBLE: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(8u32);
pub const D2D1_BITMAP_OPTIONS_FORCE_DWORD: D2D1_BITMAP_OPTIONS = D2D1_BITMAP_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BITMAP_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BITMAP_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BITMAP_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BITMAP_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BITMAP_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BITMAP_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BITMAP_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D2D1_BITMAP_PROPERTIES {
    pub pixelFormat: D2D1_PIXEL_FORMAT,
    pub dpiX: f32,
    pub dpiY: f32,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D2D1_BITMAP_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D2D1_BITMAP_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D2D1_BITMAP_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_BITMAP_PROPERTIES")
            .field("pixelFormat", &self.pixelFormat)
            .field("dpiX", &self.dpiX)
            .field("dpiY", &self.dpiY)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D2D1_BITMAP_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.pixelFormat == other.pixelFormat && self.dpiX == other.dpiX && self.dpiY == other.dpiY
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D2D1_BITMAP_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D2D1_BITMAP_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D2D1_BITMAP_PROPERTIES1 {
    pub pixelFormat: D2D1_PIXEL_FORMAT,
    pub dpiX: f32,
    pub dpiY: f32,
    pub bitmapOptions: D2D1_BITMAP_OPTIONS,
    pub colorContext: ::std::option::Option<ID2D1ColorContext>,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D2D1_BITMAP_PROPERTIES1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D2D1_BITMAP_PROPERTIES1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D2D1_BITMAP_PROPERTIES1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_BITMAP_PROPERTIES1")
            .field("pixelFormat", &self.pixelFormat)
            .field("dpiX", &self.dpiX)
            .field("dpiY", &self.dpiY)
            .field("bitmapOptions", &self.bitmapOptions)
            .field("colorContext", &self.colorContext)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D2D1_BITMAP_PROPERTIES1 {
    fn eq(&self, other: &Self) -> bool {
        self.pixelFormat == other.pixelFormat
            && self.dpiX == other.dpiX
            && self.dpiY == other.dpiY
            && self.bitmapOptions == other.bitmapOptions
            && self.colorContext == other.colorContext
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D2D1_BITMAP_PROPERTIES1 {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D2D1_BITMAP_PROPERTIES1 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BLEND(pub u32);
pub const D2D1_BLEND_ZERO: D2D1_BLEND = D2D1_BLEND(1u32);
pub const D2D1_BLEND_ONE: D2D1_BLEND = D2D1_BLEND(2u32);
pub const D2D1_BLEND_SRC_COLOR: D2D1_BLEND = D2D1_BLEND(3u32);
pub const D2D1_BLEND_INV_SRC_COLOR: D2D1_BLEND = D2D1_BLEND(4u32);
pub const D2D1_BLEND_SRC_ALPHA: D2D1_BLEND = D2D1_BLEND(5u32);
pub const D2D1_BLEND_INV_SRC_ALPHA: D2D1_BLEND = D2D1_BLEND(6u32);
pub const D2D1_BLEND_DEST_ALPHA: D2D1_BLEND = D2D1_BLEND(7u32);
pub const D2D1_BLEND_INV_DEST_ALPHA: D2D1_BLEND = D2D1_BLEND(8u32);
pub const D2D1_BLEND_DEST_COLOR: D2D1_BLEND = D2D1_BLEND(9u32);
pub const D2D1_BLEND_INV_DEST_COLOR: D2D1_BLEND = D2D1_BLEND(10u32);
pub const D2D1_BLEND_SRC_ALPHA_SAT: D2D1_BLEND = D2D1_BLEND(11u32);
pub const D2D1_BLEND_BLEND_FACTOR: D2D1_BLEND = D2D1_BLEND(14u32);
pub const D2D1_BLEND_INV_BLEND_FACTOR: D2D1_BLEND = D2D1_BLEND(15u32);
pub const D2D1_BLEND_FORCE_DWORD: D2D1_BLEND = D2D1_BLEND(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BLEND {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BLEND {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BLEND {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BLEND {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BLEND {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BLEND {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BLEND {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_BLEND_DESCRIPTION {
    pub sourceBlend: D2D1_BLEND,
    pub destinationBlend: D2D1_BLEND,
    pub blendOperation: D2D1_BLEND_OPERATION,
    pub sourceBlendAlpha: D2D1_BLEND,
    pub destinationBlendAlpha: D2D1_BLEND,
    pub blendOperationAlpha: D2D1_BLEND_OPERATION,
    pub blendFactor: [f32; 4],
}
impl D2D1_BLEND_DESCRIPTION {}
impl ::std::default::Default for D2D1_BLEND_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_BLEND_DESCRIPTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_BLEND_DESCRIPTION")
            .field("sourceBlend", &self.sourceBlend)
            .field("destinationBlend", &self.destinationBlend)
            .field("blendOperation", &self.blendOperation)
            .field("sourceBlendAlpha", &self.sourceBlendAlpha)
            .field("destinationBlendAlpha", &self.destinationBlendAlpha)
            .field("blendOperationAlpha", &self.blendOperationAlpha)
            .field("blendFactor", &self.blendFactor)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_BLEND_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.sourceBlend == other.sourceBlend
            && self.destinationBlend == other.destinationBlend
            && self.blendOperation == other.blendOperation
            && self.sourceBlendAlpha == other.sourceBlendAlpha
            && self.destinationBlendAlpha == other.destinationBlendAlpha
            && self.blendOperationAlpha == other.blendOperationAlpha
            && self.blendFactor == other.blendFactor
    }
}
impl ::std::cmp::Eq for D2D1_BLEND_DESCRIPTION {}
unsafe impl ::windows::runtime::Abi for D2D1_BLEND_DESCRIPTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BLEND_MODE(pub u32);
pub const D2D1_BLEND_MODE_MULTIPLY: D2D1_BLEND_MODE = D2D1_BLEND_MODE(0u32);
pub const D2D1_BLEND_MODE_SCREEN: D2D1_BLEND_MODE = D2D1_BLEND_MODE(1u32);
pub const D2D1_BLEND_MODE_DARKEN: D2D1_BLEND_MODE = D2D1_BLEND_MODE(2u32);
pub const D2D1_BLEND_MODE_LIGHTEN: D2D1_BLEND_MODE = D2D1_BLEND_MODE(3u32);
pub const D2D1_BLEND_MODE_DISSOLVE: D2D1_BLEND_MODE = D2D1_BLEND_MODE(4u32);
pub const D2D1_BLEND_MODE_COLOR_BURN: D2D1_BLEND_MODE = D2D1_BLEND_MODE(5u32);
pub const D2D1_BLEND_MODE_LINEAR_BURN: D2D1_BLEND_MODE = D2D1_BLEND_MODE(6u32);
pub const D2D1_BLEND_MODE_DARKER_COLOR: D2D1_BLEND_MODE = D2D1_BLEND_MODE(7u32);
pub const D2D1_BLEND_MODE_LIGHTER_COLOR: D2D1_BLEND_MODE = D2D1_BLEND_MODE(8u32);
pub const D2D1_BLEND_MODE_COLOR_DODGE: D2D1_BLEND_MODE = D2D1_BLEND_MODE(9u32);
pub const D2D1_BLEND_MODE_LINEAR_DODGE: D2D1_BLEND_MODE = D2D1_BLEND_MODE(10u32);
pub const D2D1_BLEND_MODE_OVERLAY: D2D1_BLEND_MODE = D2D1_BLEND_MODE(11u32);
pub const D2D1_BLEND_MODE_SOFT_LIGHT: D2D1_BLEND_MODE = D2D1_BLEND_MODE(12u32);
pub const D2D1_BLEND_MODE_HARD_LIGHT: D2D1_BLEND_MODE = D2D1_BLEND_MODE(13u32);
pub const D2D1_BLEND_MODE_VIVID_LIGHT: D2D1_BLEND_MODE = D2D1_BLEND_MODE(14u32);
pub const D2D1_BLEND_MODE_LINEAR_LIGHT: D2D1_BLEND_MODE = D2D1_BLEND_MODE(15u32);
pub const D2D1_BLEND_MODE_PIN_LIGHT: D2D1_BLEND_MODE = D2D1_BLEND_MODE(16u32);
pub const D2D1_BLEND_MODE_HARD_MIX: D2D1_BLEND_MODE = D2D1_BLEND_MODE(17u32);
pub const D2D1_BLEND_MODE_DIFFERENCE: D2D1_BLEND_MODE = D2D1_BLEND_MODE(18u32);
pub const D2D1_BLEND_MODE_EXCLUSION: D2D1_BLEND_MODE = D2D1_BLEND_MODE(19u32);
pub const D2D1_BLEND_MODE_HUE: D2D1_BLEND_MODE = D2D1_BLEND_MODE(20u32);
pub const D2D1_BLEND_MODE_SATURATION: D2D1_BLEND_MODE = D2D1_BLEND_MODE(21u32);
pub const D2D1_BLEND_MODE_COLOR: D2D1_BLEND_MODE = D2D1_BLEND_MODE(22u32);
pub const D2D1_BLEND_MODE_LUMINOSITY: D2D1_BLEND_MODE = D2D1_BLEND_MODE(23u32);
pub const D2D1_BLEND_MODE_SUBTRACT: D2D1_BLEND_MODE = D2D1_BLEND_MODE(24u32);
pub const D2D1_BLEND_MODE_DIVISION: D2D1_BLEND_MODE = D2D1_BLEND_MODE(25u32);
pub const D2D1_BLEND_MODE_FORCE_DWORD: D2D1_BLEND_MODE = D2D1_BLEND_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BLEND_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BLEND_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BLEND_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BLEND_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BLEND_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BLEND_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BLEND_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BLEND_OPERATION(pub u32);
pub const D2D1_BLEND_OPERATION_ADD: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(1u32);
pub const D2D1_BLEND_OPERATION_SUBTRACT: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(2u32);
pub const D2D1_BLEND_OPERATION_REV_SUBTRACT: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(3u32);
pub const D2D1_BLEND_OPERATION_MIN: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(4u32);
pub const D2D1_BLEND_OPERATION_MAX: D2D1_BLEND_OPERATION = D2D1_BLEND_OPERATION(5u32);
pub const D2D1_BLEND_OPERATION_FORCE_DWORD: D2D1_BLEND_OPERATION =
    D2D1_BLEND_OPERATION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BLEND_OPERATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BLEND_OPERATION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BLEND_OPERATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BLEND_OPERATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BLEND_OPERATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BLEND_OPERATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BLEND_OPERATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BLEND_PROP(pub u32);
pub const D2D1_BLEND_PROP_MODE: D2D1_BLEND_PROP = D2D1_BLEND_PROP(0u32);
pub const D2D1_BLEND_PROP_FORCE_DWORD: D2D1_BLEND_PROP = D2D1_BLEND_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BLEND_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BLEND_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BLEND_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BLEND_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BLEND_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BLEND_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BLEND_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BORDER_EDGE_MODE(pub u32);
pub const D2D1_BORDER_EDGE_MODE_CLAMP: D2D1_BORDER_EDGE_MODE = D2D1_BORDER_EDGE_MODE(0u32);
pub const D2D1_BORDER_EDGE_MODE_WRAP: D2D1_BORDER_EDGE_MODE = D2D1_BORDER_EDGE_MODE(1u32);
pub const D2D1_BORDER_EDGE_MODE_MIRROR: D2D1_BORDER_EDGE_MODE = D2D1_BORDER_EDGE_MODE(2u32);
pub const D2D1_BORDER_EDGE_MODE_FORCE_DWORD: D2D1_BORDER_EDGE_MODE =
    D2D1_BORDER_EDGE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BORDER_EDGE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BORDER_EDGE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BORDER_EDGE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BORDER_EDGE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BORDER_EDGE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BORDER_EDGE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BORDER_EDGE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BORDER_MODE(pub u32);
pub const D2D1_BORDER_MODE_SOFT: D2D1_BORDER_MODE = D2D1_BORDER_MODE(0u32);
pub const D2D1_BORDER_MODE_HARD: D2D1_BORDER_MODE = D2D1_BORDER_MODE(1u32);
pub const D2D1_BORDER_MODE_FORCE_DWORD: D2D1_BORDER_MODE = D2D1_BORDER_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BORDER_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BORDER_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BORDER_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BORDER_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BORDER_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BORDER_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BORDER_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BORDER_PROP(pub u32);
pub const D2D1_BORDER_PROP_EDGE_MODE_X: D2D1_BORDER_PROP = D2D1_BORDER_PROP(0u32);
pub const D2D1_BORDER_PROP_EDGE_MODE_Y: D2D1_BORDER_PROP = D2D1_BORDER_PROP(1u32);
pub const D2D1_BORDER_PROP_FORCE_DWORD: D2D1_BORDER_PROP = D2D1_BORDER_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BORDER_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BORDER_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BORDER_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BORDER_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BORDER_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BORDER_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BORDER_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BRIGHTNESS_PROP(pub u32);
pub const D2D1_BRIGHTNESS_PROP_WHITE_POINT: D2D1_BRIGHTNESS_PROP = D2D1_BRIGHTNESS_PROP(0u32);
pub const D2D1_BRIGHTNESS_PROP_BLACK_POINT: D2D1_BRIGHTNESS_PROP = D2D1_BRIGHTNESS_PROP(1u32);
pub const D2D1_BRIGHTNESS_PROP_FORCE_DWORD: D2D1_BRIGHTNESS_PROP =
    D2D1_BRIGHTNESS_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BRIGHTNESS_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BRIGHTNESS_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BRIGHTNESS_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BRIGHTNESS_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BRIGHTNESS_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BRIGHTNESS_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BRIGHTNESS_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_BRUSH_PROPERTIES {
    pub opacity: f32,
    pub transform: super::super::super::Foundation::Numerics::Matrix3x2,
}
#[cfg(feature = "Foundation_Numerics")]
impl D2D1_BRUSH_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::default::Default for D2D1_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::fmt::Debug for D2D1_BRUSH_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_BRUSH_PROPERTIES")
            .field("opacity", &self.opacity)
            .field("transform", &self.transform)
            .finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::PartialEq for D2D1_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.opacity == other.opacity && self.transform == other.transform
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::Eq for D2D1_BRUSH_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::runtime::Abi for D2D1_BRUSH_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_BUFFER_PRECISION(pub u32);
pub const D2D1_BUFFER_PRECISION_UNKNOWN: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(0u32);
pub const D2D1_BUFFER_PRECISION_8BPC_UNORM: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(1u32);
pub const D2D1_BUFFER_PRECISION_8BPC_UNORM_SRGB: D2D1_BUFFER_PRECISION =
    D2D1_BUFFER_PRECISION(2u32);
pub const D2D1_BUFFER_PRECISION_16BPC_UNORM: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(3u32);
pub const D2D1_BUFFER_PRECISION_16BPC_FLOAT: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(4u32);
pub const D2D1_BUFFER_PRECISION_32BPC_FLOAT: D2D1_BUFFER_PRECISION = D2D1_BUFFER_PRECISION(5u32);
pub const D2D1_BUFFER_PRECISION_FORCE_DWORD: D2D1_BUFFER_PRECISION =
    D2D1_BUFFER_PRECISION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_BUFFER_PRECISION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_BUFFER_PRECISION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_BUFFER_PRECISION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_BUFFER_PRECISION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_BUFFER_PRECISION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_BUFFER_PRECISION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_BUFFER_PRECISION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CAP_STYLE(pub u32);
pub const D2D1_CAP_STYLE_FLAT: D2D1_CAP_STYLE = D2D1_CAP_STYLE(0u32);
pub const D2D1_CAP_STYLE_SQUARE: D2D1_CAP_STYLE = D2D1_CAP_STYLE(1u32);
pub const D2D1_CAP_STYLE_ROUND: D2D1_CAP_STYLE = D2D1_CAP_STYLE(2u32);
pub const D2D1_CAP_STYLE_TRIANGLE: D2D1_CAP_STYLE = D2D1_CAP_STYLE(3u32);
pub const D2D1_CAP_STYLE_FORCE_DWORD: D2D1_CAP_STYLE = D2D1_CAP_STYLE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CAP_STYLE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CAP_STYLE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CAP_STYLE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CAP_STYLE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CAP_STYLE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CAP_STYLE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CAP_STYLE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CHANGE_TYPE(pub u32);
pub const D2D1_CHANGE_TYPE_NONE: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(0u32);
pub const D2D1_CHANGE_TYPE_PROPERTIES: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(1u32);
pub const D2D1_CHANGE_TYPE_CONTEXT: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(2u32);
pub const D2D1_CHANGE_TYPE_GRAPH: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(3u32);
pub const D2D1_CHANGE_TYPE_FORCE_DWORD: D2D1_CHANGE_TYPE = D2D1_CHANGE_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CHANGE_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CHANGE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CHANGE_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CHANGE_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CHANGE_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CHANGE_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CHANGE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CHANNEL_DEPTH(pub u32);
pub const D2D1_CHANNEL_DEPTH_DEFAULT: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(0u32);
pub const D2D1_CHANNEL_DEPTH_1: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(1u32);
pub const D2D1_CHANNEL_DEPTH_4: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(4u32);
pub const D2D1_CHANNEL_DEPTH_FORCE_DWORD: D2D1_CHANNEL_DEPTH = D2D1_CHANNEL_DEPTH(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CHANNEL_DEPTH {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CHANNEL_DEPTH {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CHANNEL_DEPTH {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CHANNEL_DEPTH {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CHANNEL_DEPTH {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CHANNEL_DEPTH {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CHANNEL_DEPTH {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CHANNEL_SELECTOR(pub u32);
pub const D2D1_CHANNEL_SELECTOR_R: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(0u32);
pub const D2D1_CHANNEL_SELECTOR_G: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(1u32);
pub const D2D1_CHANNEL_SELECTOR_B: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(2u32);
pub const D2D1_CHANNEL_SELECTOR_A: D2D1_CHANNEL_SELECTOR = D2D1_CHANNEL_SELECTOR(3u32);
pub const D2D1_CHANNEL_SELECTOR_FORCE_DWORD: D2D1_CHANNEL_SELECTOR =
    D2D1_CHANNEL_SELECTOR(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CHANNEL_SELECTOR {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CHANNEL_SELECTOR {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CHANNEL_SELECTOR {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CHANNEL_SELECTOR {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CHANNEL_SELECTOR {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CHANNEL_SELECTOR {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CHANNEL_SELECTOR {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CHROMAKEY_PROP(pub u32);
pub const D2D1_CHROMAKEY_PROP_COLOR: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(0u32);
pub const D2D1_CHROMAKEY_PROP_TOLERANCE: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(1u32);
pub const D2D1_CHROMAKEY_PROP_INVERT_ALPHA: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(2u32);
pub const D2D1_CHROMAKEY_PROP_FEATHER: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(3u32);
pub const D2D1_CHROMAKEY_PROP_FORCE_DWORD: D2D1_CHROMAKEY_PROP = D2D1_CHROMAKEY_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CHROMAKEY_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CHROMAKEY_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CHROMAKEY_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CHROMAKEY_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CHROMAKEY_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CHROMAKEY_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CHROMAKEY_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLORMANAGEMENT_ALPHA_MODE(pub u32);
pub const D2D1_COLORMANAGEMENT_ALPHA_MODE_PREMULTIPLIED: D2D1_COLORMANAGEMENT_ALPHA_MODE =
    D2D1_COLORMANAGEMENT_ALPHA_MODE(1u32);
pub const D2D1_COLORMANAGEMENT_ALPHA_MODE_STRAIGHT: D2D1_COLORMANAGEMENT_ALPHA_MODE =
    D2D1_COLORMANAGEMENT_ALPHA_MODE(2u32);
pub const D2D1_COLORMANAGEMENT_ALPHA_MODE_FORCE_DWORD: D2D1_COLORMANAGEMENT_ALPHA_MODE =
    D2D1_COLORMANAGEMENT_ALPHA_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLORMANAGEMENT_ALPHA_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLORMANAGEMENT_PROP(pub u32);
pub const D2D1_COLORMANAGEMENT_PROP_SOURCE_COLOR_CONTEXT: D2D1_COLORMANAGEMENT_PROP =
    D2D1_COLORMANAGEMENT_PROP(0u32);
pub const D2D1_COLORMANAGEMENT_PROP_SOURCE_RENDERING_INTENT: D2D1_COLORMANAGEMENT_PROP =
    D2D1_COLORMANAGEMENT_PROP(1u32);
pub const D2D1_COLORMANAGEMENT_PROP_DESTINATION_COLOR_CONTEXT: D2D1_COLORMANAGEMENT_PROP =
    D2D1_COLORMANAGEMENT_PROP(2u32);
pub const D2D1_COLORMANAGEMENT_PROP_DESTINATION_RENDERING_INTENT: D2D1_COLORMANAGEMENT_PROP =
    D2D1_COLORMANAGEMENT_PROP(3u32);
pub const D2D1_COLORMANAGEMENT_PROP_ALPHA_MODE: D2D1_COLORMANAGEMENT_PROP =
    D2D1_COLORMANAGEMENT_PROP(4u32);
pub const D2D1_COLORMANAGEMENT_PROP_QUALITY: D2D1_COLORMANAGEMENT_PROP =
    D2D1_COLORMANAGEMENT_PROP(5u32);
pub const D2D1_COLORMANAGEMENT_PROP_FORCE_DWORD: D2D1_COLORMANAGEMENT_PROP =
    D2D1_COLORMANAGEMENT_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLORMANAGEMENT_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLORMANAGEMENT_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLORMANAGEMENT_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLORMANAGEMENT_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLORMANAGEMENT_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLORMANAGEMENT_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLORMANAGEMENT_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLORMANAGEMENT_QUALITY(pub u32);
pub const D2D1_COLORMANAGEMENT_QUALITY_PROOF: D2D1_COLORMANAGEMENT_QUALITY =
    D2D1_COLORMANAGEMENT_QUALITY(0u32);
pub const D2D1_COLORMANAGEMENT_QUALITY_NORMAL: D2D1_COLORMANAGEMENT_QUALITY =
    D2D1_COLORMANAGEMENT_QUALITY(1u32);
pub const D2D1_COLORMANAGEMENT_QUALITY_BEST: D2D1_COLORMANAGEMENT_QUALITY =
    D2D1_COLORMANAGEMENT_QUALITY(2u32);
pub const D2D1_COLORMANAGEMENT_QUALITY_FORCE_DWORD: D2D1_COLORMANAGEMENT_QUALITY =
    D2D1_COLORMANAGEMENT_QUALITY(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLORMANAGEMENT_QUALITY {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLORMANAGEMENT_QUALITY {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLORMANAGEMENT_QUALITY {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLORMANAGEMENT_QUALITY {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLORMANAGEMENT_QUALITY {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLORMANAGEMENT_QUALITY {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLORMANAGEMENT_QUALITY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLORMANAGEMENT_RENDERING_INTENT(pub u32);
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_PERCEPTUAL: D2D1_COLORMANAGEMENT_RENDERING_INTENT =
    D2D1_COLORMANAGEMENT_RENDERING_INTENT(0u32);
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_RELATIVE_COLORIMETRIC:
    D2D1_COLORMANAGEMENT_RENDERING_INTENT = D2D1_COLORMANAGEMENT_RENDERING_INTENT(1u32);
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_SATURATION: D2D1_COLORMANAGEMENT_RENDERING_INTENT =
    D2D1_COLORMANAGEMENT_RENDERING_INTENT(2u32);
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_ABSOLUTE_COLORIMETRIC:
    D2D1_COLORMANAGEMENT_RENDERING_INTENT = D2D1_COLORMANAGEMENT_RENDERING_INTENT(3u32);
pub const D2D1_COLORMANAGEMENT_RENDERING_INTENT_FORCE_DWORD: D2D1_COLORMANAGEMENT_RENDERING_INTENT =
    D2D1_COLORMANAGEMENT_RENDERING_INTENT(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLORMANAGEMENT_RENDERING_INTENT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLORMATRIX_ALPHA_MODE(pub u32);
pub const D2D1_COLORMATRIX_ALPHA_MODE_PREMULTIPLIED: D2D1_COLORMATRIX_ALPHA_MODE =
    D2D1_COLORMATRIX_ALPHA_MODE(1u32);
pub const D2D1_COLORMATRIX_ALPHA_MODE_STRAIGHT: D2D1_COLORMATRIX_ALPHA_MODE =
    D2D1_COLORMATRIX_ALPHA_MODE(2u32);
pub const D2D1_COLORMATRIX_ALPHA_MODE_FORCE_DWORD: D2D1_COLORMATRIX_ALPHA_MODE =
    D2D1_COLORMATRIX_ALPHA_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLORMATRIX_ALPHA_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLORMATRIX_ALPHA_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLORMATRIX_ALPHA_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLORMATRIX_ALPHA_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLORMATRIX_ALPHA_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLORMATRIX_ALPHA_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLORMATRIX_ALPHA_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLORMATRIX_PROP(pub u32);
pub const D2D1_COLORMATRIX_PROP_COLOR_MATRIX: D2D1_COLORMATRIX_PROP = D2D1_COLORMATRIX_PROP(0u32);
pub const D2D1_COLORMATRIX_PROP_ALPHA_MODE: D2D1_COLORMATRIX_PROP = D2D1_COLORMATRIX_PROP(1u32);
pub const D2D1_COLORMATRIX_PROP_CLAMP_OUTPUT: D2D1_COLORMATRIX_PROP = D2D1_COLORMATRIX_PROP(2u32);
pub const D2D1_COLORMATRIX_PROP_FORCE_DWORD: D2D1_COLORMATRIX_PROP =
    D2D1_COLORMATRIX_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLORMATRIX_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLORMATRIX_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLORMATRIX_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLORMATRIX_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLORMATRIX_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLORMATRIX_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLORMATRIX_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(pub u32);
pub const D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_DEFAULT: D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION =
    D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(0u32);
pub const D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_DISABLE: D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION =
    D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(1u32);
pub const D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION_FORCE_DWORD: D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION =
    D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLOR_BITMAP_GLYPH_SNAP_OPTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLOR_CONTEXT_TYPE(pub u32);
pub const D2D1_COLOR_CONTEXT_TYPE_ICC: D2D1_COLOR_CONTEXT_TYPE = D2D1_COLOR_CONTEXT_TYPE(0u32);
pub const D2D1_COLOR_CONTEXT_TYPE_SIMPLE: D2D1_COLOR_CONTEXT_TYPE = D2D1_COLOR_CONTEXT_TYPE(1u32);
pub const D2D1_COLOR_CONTEXT_TYPE_DXGI: D2D1_COLOR_CONTEXT_TYPE = D2D1_COLOR_CONTEXT_TYPE(2u32);
pub const D2D1_COLOR_CONTEXT_TYPE_FORCE_DWORD: D2D1_COLOR_CONTEXT_TYPE =
    D2D1_COLOR_CONTEXT_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLOR_CONTEXT_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLOR_CONTEXT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLOR_CONTEXT_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLOR_CONTEXT_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLOR_CONTEXT_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLOR_CONTEXT_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLOR_CONTEXT_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_COLOR_F {
    pub r: f32,
    pub g: f32,
    pub b: f32,
    pub a: f32,
}
impl D2D1_COLOR_F {}
impl ::std::default::Default for D2D1_COLOR_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_COLOR_F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_COLOR_F")
            .field("r", &self.r)
            .field("g", &self.g)
            .field("b", &self.b)
            .field("a", &self.a)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_COLOR_F {
    fn eq(&self, other: &Self) -> bool {
        self.r == other.r && self.g == other.g && self.b == other.b && self.a == other.a
    }
}
impl ::std::cmp::Eq for D2D1_COLOR_F {}
unsafe impl ::windows::runtime::Abi for D2D1_COLOR_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLOR_INTERPOLATION_MODE(pub u32);
pub const D2D1_COLOR_INTERPOLATION_MODE_STRAIGHT: D2D1_COLOR_INTERPOLATION_MODE =
    D2D1_COLOR_INTERPOLATION_MODE(0u32);
pub const D2D1_COLOR_INTERPOLATION_MODE_PREMULTIPLIED: D2D1_COLOR_INTERPOLATION_MODE =
    D2D1_COLOR_INTERPOLATION_MODE(1u32);
pub const D2D1_COLOR_INTERPOLATION_MODE_FORCE_DWORD: D2D1_COLOR_INTERPOLATION_MODE =
    D2D1_COLOR_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLOR_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLOR_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLOR_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLOR_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLOR_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLOR_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLOR_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COLOR_SPACE(pub u32);
pub const D2D1_COLOR_SPACE_CUSTOM: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(0u32);
pub const D2D1_COLOR_SPACE_SRGB: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(1u32);
pub const D2D1_COLOR_SPACE_SCRGB: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(2u32);
pub const D2D1_COLOR_SPACE_FORCE_DWORD: D2D1_COLOR_SPACE = D2D1_COLOR_SPACE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COLOR_SPACE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COLOR_SPACE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COLOR_SPACE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COLOR_SPACE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COLOR_SPACE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COLOR_SPACE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COLOR_SPACE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COMBINE_MODE(pub u32);
pub const D2D1_COMBINE_MODE_UNION: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(0u32);
pub const D2D1_COMBINE_MODE_INTERSECT: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(1u32);
pub const D2D1_COMBINE_MODE_XOR: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(2u32);
pub const D2D1_COMBINE_MODE_EXCLUDE: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(3u32);
pub const D2D1_COMBINE_MODE_FORCE_DWORD: D2D1_COMBINE_MODE = D2D1_COMBINE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COMBINE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COMBINE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COMBINE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COMBINE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COMBINE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COMBINE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COMBINE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(pub u32);
pub const D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_NONE: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS =
    D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(0u32);
pub const D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_GDI_COMPATIBLE:
    D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS = D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(1u32);
pub const D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS_FORCE_DWORD: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS =
    D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COMPOSITE_MODE(pub u32);
pub const D2D1_COMPOSITE_MODE_SOURCE_OVER: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(0u32);
pub const D2D1_COMPOSITE_MODE_DESTINATION_OVER: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(1u32);
pub const D2D1_COMPOSITE_MODE_SOURCE_IN: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(2u32);
pub const D2D1_COMPOSITE_MODE_DESTINATION_IN: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(3u32);
pub const D2D1_COMPOSITE_MODE_SOURCE_OUT: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(4u32);
pub const D2D1_COMPOSITE_MODE_DESTINATION_OUT: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(5u32);
pub const D2D1_COMPOSITE_MODE_SOURCE_ATOP: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(6u32);
pub const D2D1_COMPOSITE_MODE_DESTINATION_ATOP: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(7u32);
pub const D2D1_COMPOSITE_MODE_XOR: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(8u32);
pub const D2D1_COMPOSITE_MODE_PLUS: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(9u32);
pub const D2D1_COMPOSITE_MODE_SOURCE_COPY: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(10u32);
pub const D2D1_COMPOSITE_MODE_BOUNDED_SOURCE_COPY: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(11u32);
pub const D2D1_COMPOSITE_MODE_MASK_INVERT: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(12u32);
pub const D2D1_COMPOSITE_MODE_FORCE_DWORD: D2D1_COMPOSITE_MODE = D2D1_COMPOSITE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COMPOSITE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COMPOSITE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COMPOSITE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COMPOSITE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COMPOSITE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COMPOSITE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COMPOSITE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_COMPOSITE_PROP(pub u32);
pub const D2D1_COMPOSITE_PROP_MODE: D2D1_COMPOSITE_PROP = D2D1_COMPOSITE_PROP(0u32);
pub const D2D1_COMPOSITE_PROP_FORCE_DWORD: D2D1_COMPOSITE_PROP = D2D1_COMPOSITE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_COMPOSITE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_COMPOSITE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_COMPOSITE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_COMPOSITE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_COMPOSITE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_COMPOSITE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_COMPOSITE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CONTRAST_PROP(pub u32);
pub const D2D1_CONTRAST_PROP_CONTRAST: D2D1_CONTRAST_PROP = D2D1_CONTRAST_PROP(0u32);
pub const D2D1_CONTRAST_PROP_CLAMP_INPUT: D2D1_CONTRAST_PROP = D2D1_CONTRAST_PROP(1u32);
pub const D2D1_CONTRAST_PROP_FORCE_DWORD: D2D1_CONTRAST_PROP = D2D1_CONTRAST_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CONTRAST_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CONTRAST_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CONTRAST_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CONTRAST_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CONTRAST_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CONTRAST_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CONTRAST_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CONVOLVEMATRIX_PROP(pub u32);
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_UNIT_LENGTH: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(0u32);
pub const D2D1_CONVOLVEMATRIX_PROP_SCALE_MODE: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(1u32);
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_X: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(2u32);
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_SIZE_Y: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(3u32);
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_MATRIX: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(4u32);
pub const D2D1_CONVOLVEMATRIX_PROP_DIVISOR: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(5u32);
pub const D2D1_CONVOLVEMATRIX_PROP_BIAS: D2D1_CONVOLVEMATRIX_PROP = D2D1_CONVOLVEMATRIX_PROP(6u32);
pub const D2D1_CONVOLVEMATRIX_PROP_KERNEL_OFFSET: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(7u32);
pub const D2D1_CONVOLVEMATRIX_PROP_PRESERVE_ALPHA: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(8u32);
pub const D2D1_CONVOLVEMATRIX_PROP_BORDER_MODE: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(9u32);
pub const D2D1_CONVOLVEMATRIX_PROP_CLAMP_OUTPUT: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(10u32);
pub const D2D1_CONVOLVEMATRIX_PROP_FORCE_DWORD: D2D1_CONVOLVEMATRIX_PROP =
    D2D1_CONVOLVEMATRIX_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CONVOLVEMATRIX_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CONVOLVEMATRIX_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CONVOLVEMATRIX_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CONVOLVEMATRIX_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CONVOLVEMATRIX_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CONVOLVEMATRIX_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CONVOLVEMATRIX_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CONVOLVEMATRIX_SCALE_MODE(pub u32);
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_CONVOLVEMATRIX_SCALE_MODE =
    D2D1_CONVOLVEMATRIX_SCALE_MODE(0u32);
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_LINEAR: D2D1_CONVOLVEMATRIX_SCALE_MODE =
    D2D1_CONVOLVEMATRIX_SCALE_MODE(1u32);
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_CUBIC: D2D1_CONVOLVEMATRIX_SCALE_MODE =
    D2D1_CONVOLVEMATRIX_SCALE_MODE(2u32);
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_CONVOLVEMATRIX_SCALE_MODE =
    D2D1_CONVOLVEMATRIX_SCALE_MODE(3u32);
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_ANISOTROPIC: D2D1_CONVOLVEMATRIX_SCALE_MODE =
    D2D1_CONVOLVEMATRIX_SCALE_MODE(4u32);
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_CONVOLVEMATRIX_SCALE_MODE =
    D2D1_CONVOLVEMATRIX_SCALE_MODE(5u32);
pub const D2D1_CONVOLVEMATRIX_SCALE_MODE_FORCE_DWORD: D2D1_CONVOLVEMATRIX_SCALE_MODE =
    D2D1_CONVOLVEMATRIX_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CONVOLVEMATRIX_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_CREATION_PROPERTIES {
    pub threadingMode: D2D1_THREADING_MODE,
    pub debugLevel: D2D1_DEBUG_LEVEL,
    pub options: D2D1_DEVICE_CONTEXT_OPTIONS,
}
impl D2D1_CREATION_PROPERTIES {}
impl ::std::default::Default for D2D1_CREATION_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_CREATION_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_CREATION_PROPERTIES")
            .field("threadingMode", &self.threadingMode)
            .field("debugLevel", &self.debugLevel)
            .field("options", &self.options)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_CREATION_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.threadingMode == other.threadingMode
            && self.debugLevel == other.debugLevel
            && self.options == other.options
    }
}
impl ::std::cmp::Eq for D2D1_CREATION_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_CREATION_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CROP_PROP(pub u32);
pub const D2D1_CROP_PROP_RECT: D2D1_CROP_PROP = D2D1_CROP_PROP(0u32);
pub const D2D1_CROP_PROP_BORDER_MODE: D2D1_CROP_PROP = D2D1_CROP_PROP(1u32);
pub const D2D1_CROP_PROP_FORCE_DWORD: D2D1_CROP_PROP = D2D1_CROP_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CROP_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CROP_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CROP_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CROP_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CROP_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CROP_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CROP_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_CROSSFADE_PROP(pub u32);
pub const D2D1_CROSSFADE_PROP_WEIGHT: D2D1_CROSSFADE_PROP = D2D1_CROSSFADE_PROP(0u32);
pub const D2D1_CROSSFADE_PROP_FORCE_DWORD: D2D1_CROSSFADE_PROP = D2D1_CROSSFADE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_CROSSFADE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_CROSSFADE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_CROSSFADE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_CROSSFADE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_CROSSFADE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_CROSSFADE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_CROSSFADE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    pub shaderBufferWithInputSignature: *mut u8,
    pub shaderBufferSize: u32,
    pub inputElements: *mut D2D1_INPUT_ELEMENT_DESC,
    pub elementCount: u32,
    pub stride: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES")
            .field(
                "shaderBufferWithInputSignature",
                &self.shaderBufferWithInputSignature,
            )
            .field("shaderBufferSize", &self.shaderBufferSize)
            .field("inputElements", &self.inputElements)
            .field("elementCount", &self.elementCount)
            .field("stride", &self.stride)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.shaderBufferWithInputSignature == other.shaderBufferWithInputSignature
            && self.shaderBufferSize == other.shaderBufferSize
            && self.inputElements == other.inputElements
            && self.elementCount == other.elementCount
            && self.stride == other.stride
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D2D1_CUSTOM_VERTEX_BUFFER_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DASH_STYLE(pub u32);
pub const D2D1_DASH_STYLE_SOLID: D2D1_DASH_STYLE = D2D1_DASH_STYLE(0u32);
pub const D2D1_DASH_STYLE_DASH: D2D1_DASH_STYLE = D2D1_DASH_STYLE(1u32);
pub const D2D1_DASH_STYLE_DOT: D2D1_DASH_STYLE = D2D1_DASH_STYLE(2u32);
pub const D2D1_DASH_STYLE_DASH_DOT: D2D1_DASH_STYLE = D2D1_DASH_STYLE(3u32);
pub const D2D1_DASH_STYLE_DASH_DOT_DOT: D2D1_DASH_STYLE = D2D1_DASH_STYLE(4u32);
pub const D2D1_DASH_STYLE_CUSTOM: D2D1_DASH_STYLE = D2D1_DASH_STYLE(5u32);
pub const D2D1_DASH_STYLE_FORCE_DWORD: D2D1_DASH_STYLE = D2D1_DASH_STYLE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DASH_STYLE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DASH_STYLE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DASH_STYLE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DASH_STYLE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DASH_STYLE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DASH_STYLE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DASH_STYLE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DC_INITIALIZE_MODE(pub u32);
pub const D2D1_DC_INITIALIZE_MODE_COPY: D2D1_DC_INITIALIZE_MODE = D2D1_DC_INITIALIZE_MODE(0u32);
pub const D2D1_DC_INITIALIZE_MODE_CLEAR: D2D1_DC_INITIALIZE_MODE = D2D1_DC_INITIALIZE_MODE(1u32);
pub const D2D1_DC_INITIALIZE_MODE_FORCE_DWORD: D2D1_DC_INITIALIZE_MODE =
    D2D1_DC_INITIALIZE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DC_INITIALIZE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DC_INITIALIZE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DC_INITIALIZE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DC_INITIALIZE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DC_INITIALIZE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DC_INITIALIZE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DC_INITIALIZE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DEBUG_LEVEL(pub u32);
pub const D2D1_DEBUG_LEVEL_NONE: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(0u32);
pub const D2D1_DEBUG_LEVEL_ERROR: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(1u32);
pub const D2D1_DEBUG_LEVEL_WARNING: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(2u32);
pub const D2D1_DEBUG_LEVEL_INFORMATION: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(3u32);
pub const D2D1_DEBUG_LEVEL_FORCE_DWORD: D2D1_DEBUG_LEVEL = D2D1_DEBUG_LEVEL(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DEBUG_LEVEL {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DEBUG_LEVEL {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DEBUG_LEVEL {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DEBUG_LEVEL {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DEBUG_LEVEL {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DEBUG_LEVEL {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DEBUG_LEVEL {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D2D1_DEFAULT_FLATTENING_TOLERANCE: f32 = 0.25f32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DEVICE_CONTEXT_OPTIONS(pub u32);
pub const D2D1_DEVICE_CONTEXT_OPTIONS_NONE: D2D1_DEVICE_CONTEXT_OPTIONS =
    D2D1_DEVICE_CONTEXT_OPTIONS(0u32);
pub const D2D1_DEVICE_CONTEXT_OPTIONS_ENABLE_MULTITHREADED_OPTIMIZATIONS:
    D2D1_DEVICE_CONTEXT_OPTIONS = D2D1_DEVICE_CONTEXT_OPTIONS(1u32);
pub const D2D1_DEVICE_CONTEXT_OPTIONS_FORCE_DWORD: D2D1_DEVICE_CONTEXT_OPTIONS =
    D2D1_DEVICE_CONTEXT_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DEVICE_CONTEXT_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DEVICE_CONTEXT_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DIRECTIONALBLUR_OPTIMIZATION(pub u32);
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_SPEED: D2D1_DIRECTIONALBLUR_OPTIMIZATION =
    D2D1_DIRECTIONALBLUR_OPTIMIZATION(0u32);
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_BALANCED: D2D1_DIRECTIONALBLUR_OPTIMIZATION =
    D2D1_DIRECTIONALBLUR_OPTIMIZATION(1u32);
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_QUALITY: D2D1_DIRECTIONALBLUR_OPTIMIZATION =
    D2D1_DIRECTIONALBLUR_OPTIMIZATION(2u32);
pub const D2D1_DIRECTIONALBLUR_OPTIMIZATION_FORCE_DWORD: D2D1_DIRECTIONALBLUR_OPTIMIZATION =
    D2D1_DIRECTIONALBLUR_OPTIMIZATION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DIRECTIONALBLUR_OPTIMIZATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DIRECTIONALBLUR_PROP(pub u32);
pub const D2D1_DIRECTIONALBLUR_PROP_STANDARD_DEVIATION: D2D1_DIRECTIONALBLUR_PROP =
    D2D1_DIRECTIONALBLUR_PROP(0u32);
pub const D2D1_DIRECTIONALBLUR_PROP_ANGLE: D2D1_DIRECTIONALBLUR_PROP =
    D2D1_DIRECTIONALBLUR_PROP(1u32);
pub const D2D1_DIRECTIONALBLUR_PROP_OPTIMIZATION: D2D1_DIRECTIONALBLUR_PROP =
    D2D1_DIRECTIONALBLUR_PROP(2u32);
pub const D2D1_DIRECTIONALBLUR_PROP_BORDER_MODE: D2D1_DIRECTIONALBLUR_PROP =
    D2D1_DIRECTIONALBLUR_PROP(3u32);
pub const D2D1_DIRECTIONALBLUR_PROP_FORCE_DWORD: D2D1_DIRECTIONALBLUR_PROP =
    D2D1_DIRECTIONALBLUR_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DIRECTIONALBLUR_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DIRECTIONALBLUR_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DIRECTIONALBLUR_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DIRECTIONALBLUR_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DIRECTIONALBLUR_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DIRECTIONALBLUR_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DIRECTIONALBLUR_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DISCRETETRANSFER_PROP(pub u32);
pub const D2D1_DISCRETETRANSFER_PROP_RED_TABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(0u32);
pub const D2D1_DISCRETETRANSFER_PROP_RED_DISABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(1u32);
pub const D2D1_DISCRETETRANSFER_PROP_GREEN_TABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(2u32);
pub const D2D1_DISCRETETRANSFER_PROP_GREEN_DISABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(3u32);
pub const D2D1_DISCRETETRANSFER_PROP_BLUE_TABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(4u32);
pub const D2D1_DISCRETETRANSFER_PROP_BLUE_DISABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(5u32);
pub const D2D1_DISCRETETRANSFER_PROP_ALPHA_TABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(6u32);
pub const D2D1_DISCRETETRANSFER_PROP_ALPHA_DISABLE: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(7u32);
pub const D2D1_DISCRETETRANSFER_PROP_CLAMP_OUTPUT: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(8u32);
pub const D2D1_DISCRETETRANSFER_PROP_FORCE_DWORD: D2D1_DISCRETETRANSFER_PROP =
    D2D1_DISCRETETRANSFER_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DISCRETETRANSFER_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DISCRETETRANSFER_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DISCRETETRANSFER_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DISCRETETRANSFER_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DISCRETETRANSFER_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DISCRETETRANSFER_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DISCRETETRANSFER_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DISPLACEMENTMAP_PROP(pub u32);
pub const D2D1_DISPLACEMENTMAP_PROP_SCALE: D2D1_DISPLACEMENTMAP_PROP =
    D2D1_DISPLACEMENTMAP_PROP(0u32);
pub const D2D1_DISPLACEMENTMAP_PROP_X_CHANNEL_SELECT: D2D1_DISPLACEMENTMAP_PROP =
    D2D1_DISPLACEMENTMAP_PROP(1u32);
pub const D2D1_DISPLACEMENTMAP_PROP_Y_CHANNEL_SELECT: D2D1_DISPLACEMENTMAP_PROP =
    D2D1_DISPLACEMENTMAP_PROP(2u32);
pub const D2D1_DISPLACEMENTMAP_PROP_FORCE_DWORD: D2D1_DISPLACEMENTMAP_PROP =
    D2D1_DISPLACEMENTMAP_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DISPLACEMENTMAP_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DISPLACEMENTMAP_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DISPLACEMENTMAP_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DISPLACEMENTMAP_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DISPLACEMENTMAP_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DISPLACEMENTMAP_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DISPLACEMENTMAP_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DISTANTDIFFUSE_PROP(pub u32);
pub const D2D1_DISTANTDIFFUSE_PROP_AZIMUTH: D2D1_DISTANTDIFFUSE_PROP =
    D2D1_DISTANTDIFFUSE_PROP(0u32);
pub const D2D1_DISTANTDIFFUSE_PROP_ELEVATION: D2D1_DISTANTDIFFUSE_PROP =
    D2D1_DISTANTDIFFUSE_PROP(1u32);
pub const D2D1_DISTANTDIFFUSE_PROP_DIFFUSE_CONSTANT: D2D1_DISTANTDIFFUSE_PROP =
    D2D1_DISTANTDIFFUSE_PROP(2u32);
pub const D2D1_DISTANTDIFFUSE_PROP_SURFACE_SCALE: D2D1_DISTANTDIFFUSE_PROP =
    D2D1_DISTANTDIFFUSE_PROP(3u32);
pub const D2D1_DISTANTDIFFUSE_PROP_COLOR: D2D1_DISTANTDIFFUSE_PROP = D2D1_DISTANTDIFFUSE_PROP(4u32);
pub const D2D1_DISTANTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: D2D1_DISTANTDIFFUSE_PROP =
    D2D1_DISTANTDIFFUSE_PROP(5u32);
pub const D2D1_DISTANTDIFFUSE_PROP_SCALE_MODE: D2D1_DISTANTDIFFUSE_PROP =
    D2D1_DISTANTDIFFUSE_PROP(6u32);
pub const D2D1_DISTANTDIFFUSE_PROP_FORCE_DWORD: D2D1_DISTANTDIFFUSE_PROP =
    D2D1_DISTANTDIFFUSE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DISTANTDIFFUSE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DISTANTDIFFUSE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DISTANTDIFFUSE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DISTANTDIFFUSE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DISTANTDIFFUSE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DISTANTDIFFUSE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DISTANTDIFFUSE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DISTANTDIFFUSE_SCALE_MODE(pub u32);
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_DISTANTDIFFUSE_SCALE_MODE =
    D2D1_DISTANTDIFFUSE_SCALE_MODE(0u32);
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_LINEAR: D2D1_DISTANTDIFFUSE_SCALE_MODE =
    D2D1_DISTANTDIFFUSE_SCALE_MODE(1u32);
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_CUBIC: D2D1_DISTANTDIFFUSE_SCALE_MODE =
    D2D1_DISTANTDIFFUSE_SCALE_MODE(2u32);
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_DISTANTDIFFUSE_SCALE_MODE =
    D2D1_DISTANTDIFFUSE_SCALE_MODE(3u32);
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_ANISOTROPIC: D2D1_DISTANTDIFFUSE_SCALE_MODE =
    D2D1_DISTANTDIFFUSE_SCALE_MODE(4u32);
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_DISTANTDIFFUSE_SCALE_MODE =
    D2D1_DISTANTDIFFUSE_SCALE_MODE(5u32);
pub const D2D1_DISTANTDIFFUSE_SCALE_MODE_FORCE_DWORD: D2D1_DISTANTDIFFUSE_SCALE_MODE =
    D2D1_DISTANTDIFFUSE_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DISTANTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DISTANTSPECULAR_PROP(pub u32);
pub const D2D1_DISTANTSPECULAR_PROP_AZIMUTH: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(0u32);
pub const D2D1_DISTANTSPECULAR_PROP_ELEVATION: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(1u32);
pub const D2D1_DISTANTSPECULAR_PROP_SPECULAR_EXPONENT: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(2u32);
pub const D2D1_DISTANTSPECULAR_PROP_SPECULAR_CONSTANT: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(3u32);
pub const D2D1_DISTANTSPECULAR_PROP_SURFACE_SCALE: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(4u32);
pub const D2D1_DISTANTSPECULAR_PROP_COLOR: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(5u32);
pub const D2D1_DISTANTSPECULAR_PROP_KERNEL_UNIT_LENGTH: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(6u32);
pub const D2D1_DISTANTSPECULAR_PROP_SCALE_MODE: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(7u32);
pub const D2D1_DISTANTSPECULAR_PROP_FORCE_DWORD: D2D1_DISTANTSPECULAR_PROP =
    D2D1_DISTANTSPECULAR_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DISTANTSPECULAR_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DISTANTSPECULAR_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DISTANTSPECULAR_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DISTANTSPECULAR_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DISTANTSPECULAR_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DISTANTSPECULAR_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DISTANTSPECULAR_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DISTANTSPECULAR_SCALE_MODE(pub u32);
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_DISTANTSPECULAR_SCALE_MODE =
    D2D1_DISTANTSPECULAR_SCALE_MODE(0u32);
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_LINEAR: D2D1_DISTANTSPECULAR_SCALE_MODE =
    D2D1_DISTANTSPECULAR_SCALE_MODE(1u32);
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_CUBIC: D2D1_DISTANTSPECULAR_SCALE_MODE =
    D2D1_DISTANTSPECULAR_SCALE_MODE(2u32);
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_DISTANTSPECULAR_SCALE_MODE =
    D2D1_DISTANTSPECULAR_SCALE_MODE(3u32);
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_ANISOTROPIC: D2D1_DISTANTSPECULAR_SCALE_MODE =
    D2D1_DISTANTSPECULAR_SCALE_MODE(4u32);
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_DISTANTSPECULAR_SCALE_MODE =
    D2D1_DISTANTSPECULAR_SCALE_MODE(5u32);
pub const D2D1_DISTANTSPECULAR_SCALE_MODE_FORCE_DWORD: D2D1_DISTANTSPECULAR_SCALE_MODE =
    D2D1_DISTANTSPECULAR_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DISTANTSPECULAR_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DISTANTSPECULAR_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DISTANTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DISTANTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DISTANTSPECULAR_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DISTANTSPECULAR_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DISTANTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DPICOMPENSATION_INTERPOLATION_MODE(pub u32);
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_NEAREST_NEIGHBOR:
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(0u32);
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_LINEAR: D2D1_DPICOMPENSATION_INTERPOLATION_MODE =
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE(1u32);
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_CUBIC: D2D1_DPICOMPENSATION_INTERPOLATION_MODE =
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE(2u32);
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR:
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(3u32);
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_ANISOTROPIC:
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(4u32);
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC:
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE = D2D1_DPICOMPENSATION_INTERPOLATION_MODE(5u32);
pub const D2D1_DPICOMPENSATION_INTERPOLATION_MODE_FORCE_DWORD:
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE =
    D2D1_DPICOMPENSATION_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DPICOMPENSATION_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DPICOMPENSATION_PROP(pub u32);
pub const D2D1_DPICOMPENSATION_PROP_INTERPOLATION_MODE: D2D1_DPICOMPENSATION_PROP =
    D2D1_DPICOMPENSATION_PROP(0u32);
pub const D2D1_DPICOMPENSATION_PROP_BORDER_MODE: D2D1_DPICOMPENSATION_PROP =
    D2D1_DPICOMPENSATION_PROP(1u32);
pub const D2D1_DPICOMPENSATION_PROP_INPUT_DPI: D2D1_DPICOMPENSATION_PROP =
    D2D1_DPICOMPENSATION_PROP(2u32);
pub const D2D1_DPICOMPENSATION_PROP_FORCE_DWORD: D2D1_DPICOMPENSATION_PROP =
    D2D1_DPICOMPENSATION_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DPICOMPENSATION_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DPICOMPENSATION_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DPICOMPENSATION_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DPICOMPENSATION_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DPICOMPENSATION_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DPICOMPENSATION_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DPICOMPENSATION_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_DRAWING_STATE_DESCRIPTION {
    pub antialiasMode: D2D1_ANTIALIAS_MODE,
    pub textAntialiasMode: D2D1_TEXT_ANTIALIAS_MODE,
    pub tag1: u64,
    pub tag2: u64,
    pub transform: super::super::super::Foundation::Numerics::Matrix3x2,
}
#[cfg(feature = "Foundation_Numerics")]
impl D2D1_DRAWING_STATE_DESCRIPTION {}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::default::Default for D2D1_DRAWING_STATE_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::fmt::Debug for D2D1_DRAWING_STATE_DESCRIPTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_DRAWING_STATE_DESCRIPTION")
            .field("antialiasMode", &self.antialiasMode)
            .field("textAntialiasMode", &self.textAntialiasMode)
            .field("tag1", &self.tag1)
            .field("tag2", &self.tag2)
            .field("transform", &self.transform)
            .finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::PartialEq for D2D1_DRAWING_STATE_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.antialiasMode == other.antialiasMode
            && self.textAntialiasMode == other.textAntialiasMode
            && self.tag1 == other.tag1
            && self.tag2 == other.tag2
            && self.transform == other.transform
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::Eq for D2D1_DRAWING_STATE_DESCRIPTION {}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::runtime::Abi for D2D1_DRAWING_STATE_DESCRIPTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_DRAWING_STATE_DESCRIPTION1 {
    pub antialiasMode: D2D1_ANTIALIAS_MODE,
    pub textAntialiasMode: D2D1_TEXT_ANTIALIAS_MODE,
    pub tag1: u64,
    pub tag2: u64,
    pub transform: super::super::super::Foundation::Numerics::Matrix3x2,
    pub primitiveBlend: D2D1_PRIMITIVE_BLEND,
    pub unitMode: D2D1_UNIT_MODE,
}
#[cfg(feature = "Foundation_Numerics")]
impl D2D1_DRAWING_STATE_DESCRIPTION1 {}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::default::Default for D2D1_DRAWING_STATE_DESCRIPTION1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::fmt::Debug for D2D1_DRAWING_STATE_DESCRIPTION1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_DRAWING_STATE_DESCRIPTION1")
            .field("antialiasMode", &self.antialiasMode)
            .field("textAntialiasMode", &self.textAntialiasMode)
            .field("tag1", &self.tag1)
            .field("tag2", &self.tag2)
            .field("transform", &self.transform)
            .field("primitiveBlend", &self.primitiveBlend)
            .field("unitMode", &self.unitMode)
            .finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::PartialEq for D2D1_DRAWING_STATE_DESCRIPTION1 {
    fn eq(&self, other: &Self) -> bool {
        self.antialiasMode == other.antialiasMode
            && self.textAntialiasMode == other.textAntialiasMode
            && self.tag1 == other.tag1
            && self.tag2 == other.tag2
            && self.transform == other.transform
            && self.primitiveBlend == other.primitiveBlend
            && self.unitMode == other.unitMode
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::Eq for D2D1_DRAWING_STATE_DESCRIPTION1 {}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::runtime::Abi for D2D1_DRAWING_STATE_DESCRIPTION1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_DRAW_TEXT_OPTIONS(pub u32);
pub const D2D1_DRAW_TEXT_OPTIONS_NO_SNAP: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(1u32);
pub const D2D1_DRAW_TEXT_OPTIONS_CLIP: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(2u32);
pub const D2D1_DRAW_TEXT_OPTIONS_ENABLE_COLOR_FONT: D2D1_DRAW_TEXT_OPTIONS =
    D2D1_DRAW_TEXT_OPTIONS(4u32);
pub const D2D1_DRAW_TEXT_OPTIONS_DISABLE_COLOR_BITMAP_SNAPPING: D2D1_DRAW_TEXT_OPTIONS =
    D2D1_DRAW_TEXT_OPTIONS(8u32);
pub const D2D1_DRAW_TEXT_OPTIONS_NONE: D2D1_DRAW_TEXT_OPTIONS = D2D1_DRAW_TEXT_OPTIONS(0u32);
pub const D2D1_DRAW_TEXT_OPTIONS_FORCE_DWORD: D2D1_DRAW_TEXT_OPTIONS =
    D2D1_DRAW_TEXT_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_DRAW_TEXT_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_DRAW_TEXT_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_DRAW_TEXT_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_DRAW_TEXT_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_DRAW_TEXT_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_DRAW_TEXT_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_DRAW_TEXT_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_EDGEDETECTION_MODE(pub u32);
pub const D2D1_EDGEDETECTION_MODE_SOBEL: D2D1_EDGEDETECTION_MODE = D2D1_EDGEDETECTION_MODE(0u32);
pub const D2D1_EDGEDETECTION_MODE_PREWITT: D2D1_EDGEDETECTION_MODE = D2D1_EDGEDETECTION_MODE(1u32);
pub const D2D1_EDGEDETECTION_MODE_FORCE_DWORD: D2D1_EDGEDETECTION_MODE =
    D2D1_EDGEDETECTION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_EDGEDETECTION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_EDGEDETECTION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_EDGEDETECTION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_EDGEDETECTION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_EDGEDETECTION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_EDGEDETECTION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_EDGEDETECTION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_EDGEDETECTION_PROP(pub u32);
pub const D2D1_EDGEDETECTION_PROP_STRENGTH: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(0u32);
pub const D2D1_EDGEDETECTION_PROP_BLUR_RADIUS: D2D1_EDGEDETECTION_PROP =
    D2D1_EDGEDETECTION_PROP(1u32);
pub const D2D1_EDGEDETECTION_PROP_MODE: D2D1_EDGEDETECTION_PROP = D2D1_EDGEDETECTION_PROP(2u32);
pub const D2D1_EDGEDETECTION_PROP_OVERLAY_EDGES: D2D1_EDGEDETECTION_PROP =
    D2D1_EDGEDETECTION_PROP(3u32);
pub const D2D1_EDGEDETECTION_PROP_ALPHA_MODE: D2D1_EDGEDETECTION_PROP =
    D2D1_EDGEDETECTION_PROP(4u32);
pub const D2D1_EDGEDETECTION_PROP_FORCE_DWORD: D2D1_EDGEDETECTION_PROP =
    D2D1_EDGEDETECTION_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_EDGEDETECTION_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_EDGEDETECTION_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_EDGEDETECTION_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_EDGEDETECTION_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_EDGEDETECTION_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_EDGEDETECTION_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_EDGEDETECTION_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct D2D1_EFFECT_INPUT_DESCRIPTION {
    pub effect: ::std::option::Option<ID2D1Effect>,
    pub inputIndex: u32,
    pub inputRectangle: D2D_RECT_F,
}
impl D2D1_EFFECT_INPUT_DESCRIPTION {}
impl ::std::default::Default for D2D1_EFFECT_INPUT_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_EFFECT_INPUT_DESCRIPTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_EFFECT_INPUT_DESCRIPTION")
            .field("effect", &self.effect)
            .field("inputIndex", &self.inputIndex)
            .field("inputRectangle", &self.inputRectangle)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_EFFECT_INPUT_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.effect == other.effect
            && self.inputIndex == other.inputIndex
            && self.inputRectangle == other.inputRectangle
    }
}
impl ::std::cmp::Eq for D2D1_EFFECT_INPUT_DESCRIPTION {}
unsafe impl ::windows::runtime::Abi for D2D1_EFFECT_INPUT_DESCRIPTION {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_ELLIPSE {
    pub point: D2D_POINT_2F,
    pub radiusX: f32,
    pub radiusY: f32,
}
impl D2D1_ELLIPSE {}
impl ::std::default::Default for D2D1_ELLIPSE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_ELLIPSE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_ELLIPSE")
            .field("point", &self.point)
            .field("radiusX", &self.radiusX)
            .field("radiusY", &self.radiusY)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_ELLIPSE {
    fn eq(&self, other: &Self) -> bool {
        self.point == other.point && self.radiusX == other.radiusX && self.radiusY == other.radiusY
    }
}
impl ::std::cmp::Eq for D2D1_ELLIPSE {}
unsafe impl ::windows::runtime::Abi for D2D1_ELLIPSE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_EMBOSS_PROP(pub u32);
pub const D2D1_EMBOSS_PROP_HEIGHT: D2D1_EMBOSS_PROP = D2D1_EMBOSS_PROP(0u32);
pub const D2D1_EMBOSS_PROP_DIRECTION: D2D1_EMBOSS_PROP = D2D1_EMBOSS_PROP(1u32);
pub const D2D1_EMBOSS_PROP_FORCE_DWORD: D2D1_EMBOSS_PROP = D2D1_EMBOSS_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_EMBOSS_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_EMBOSS_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_EMBOSS_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_EMBOSS_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_EMBOSS_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_EMBOSS_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_EMBOSS_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_EXPOSURE_PROP(pub u32);
pub const D2D1_EXPOSURE_PROP_EXPOSURE_VALUE: D2D1_EXPOSURE_PROP = D2D1_EXPOSURE_PROP(0u32);
pub const D2D1_EXPOSURE_PROP_FORCE_DWORD: D2D1_EXPOSURE_PROP = D2D1_EXPOSURE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_EXPOSURE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_EXPOSURE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_EXPOSURE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_EXPOSURE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_EXPOSURE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_EXPOSURE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_EXPOSURE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_EXTEND_MODE(pub u32);
pub const D2D1_EXTEND_MODE_CLAMP: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(0u32);
pub const D2D1_EXTEND_MODE_WRAP: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(1u32);
pub const D2D1_EXTEND_MODE_MIRROR: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(2u32);
pub const D2D1_EXTEND_MODE_FORCE_DWORD: D2D1_EXTEND_MODE = D2D1_EXTEND_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_EXTEND_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_EXTEND_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_EXTEND_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_EXTEND_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_EXTEND_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_EXTEND_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_EXTEND_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_FACTORY_OPTIONS {
    pub debugLevel: D2D1_DEBUG_LEVEL,
}
impl D2D1_FACTORY_OPTIONS {}
impl ::std::default::Default for D2D1_FACTORY_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_FACTORY_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_FACTORY_OPTIONS")
            .field("debugLevel", &self.debugLevel)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_FACTORY_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.debugLevel == other.debugLevel
    }
}
impl ::std::cmp::Eq for D2D1_FACTORY_OPTIONS {}
unsafe impl ::windows::runtime::Abi for D2D1_FACTORY_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FACTORY_TYPE(pub u32);
pub const D2D1_FACTORY_TYPE_SINGLE_THREADED: D2D1_FACTORY_TYPE = D2D1_FACTORY_TYPE(0u32);
pub const D2D1_FACTORY_TYPE_MULTI_THREADED: D2D1_FACTORY_TYPE = D2D1_FACTORY_TYPE(1u32);
pub const D2D1_FACTORY_TYPE_FORCE_DWORD: D2D1_FACTORY_TYPE = D2D1_FACTORY_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FACTORY_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FACTORY_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FACTORY_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FACTORY_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FACTORY_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FACTORY_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FACTORY_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FEATURE(pub u32);
pub const D2D1_FEATURE_DOUBLES: D2D1_FEATURE = D2D1_FEATURE(0u32);
pub const D2D1_FEATURE_D3D10_X_HARDWARE_OPTIONS: D2D1_FEATURE = D2D1_FEATURE(1u32);
pub const D2D1_FEATURE_FORCE_DWORD: D2D1_FEATURE = D2D1_FEATURE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FEATURE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FEATURE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FEATURE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FEATURE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FEATURE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FEATURE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FEATURE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    pub computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS")
            .field(
                "computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x",
                &self.computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x
            == other.computeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D2D1_FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_FEATURE_DATA_DOUBLES {
    pub doublePrecisionFloatShaderOps: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl D2D1_FEATURE_DATA_DOUBLES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D2D1_FEATURE_DATA_DOUBLES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D2D1_FEATURE_DATA_DOUBLES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_FEATURE_DATA_DOUBLES")
            .field(
                "doublePrecisionFloatShaderOps",
                &self.doublePrecisionFloatShaderOps,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D2D1_FEATURE_DATA_DOUBLES {
    fn eq(&self, other: &Self) -> bool {
        self.doublePrecisionFloatShaderOps == other.doublePrecisionFloatShaderOps
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D2D1_FEATURE_DATA_DOUBLES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D2D1_FEATURE_DATA_DOUBLES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FEATURE_LEVEL(pub u32);
pub const D2D1_FEATURE_LEVEL_DEFAULT: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(0u32);
pub const D2D1_FEATURE_LEVEL_9: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(37120u32);
pub const D2D1_FEATURE_LEVEL_10: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(40960u32);
pub const D2D1_FEATURE_LEVEL_FORCE_DWORD: D2D1_FEATURE_LEVEL = D2D1_FEATURE_LEVEL(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FEATURE_LEVEL {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FEATURE_LEVEL {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FEATURE_LEVEL {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FEATURE_LEVEL {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FEATURE_LEVEL {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FEATURE_LEVEL {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FEATURE_LEVEL {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FIGURE_BEGIN(pub u32);
pub const D2D1_FIGURE_BEGIN_FILLED: D2D1_FIGURE_BEGIN = D2D1_FIGURE_BEGIN(0u32);
pub const D2D1_FIGURE_BEGIN_HOLLOW: D2D1_FIGURE_BEGIN = D2D1_FIGURE_BEGIN(1u32);
pub const D2D1_FIGURE_BEGIN_FORCE_DWORD: D2D1_FIGURE_BEGIN = D2D1_FIGURE_BEGIN(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FIGURE_BEGIN {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FIGURE_BEGIN {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FIGURE_BEGIN {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FIGURE_BEGIN {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FIGURE_BEGIN {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FIGURE_BEGIN {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FIGURE_BEGIN {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FIGURE_END(pub u32);
pub const D2D1_FIGURE_END_OPEN: D2D1_FIGURE_END = D2D1_FIGURE_END(0u32);
pub const D2D1_FIGURE_END_CLOSED: D2D1_FIGURE_END = D2D1_FIGURE_END(1u32);
pub const D2D1_FIGURE_END_FORCE_DWORD: D2D1_FIGURE_END = D2D1_FIGURE_END(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FIGURE_END {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FIGURE_END {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FIGURE_END {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FIGURE_END {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FIGURE_END {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FIGURE_END {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FIGURE_END {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FILL_MODE(pub u32);
pub const D2D1_FILL_MODE_ALTERNATE: D2D1_FILL_MODE = D2D1_FILL_MODE(0u32);
pub const D2D1_FILL_MODE_WINDING: D2D1_FILL_MODE = D2D1_FILL_MODE(1u32);
pub const D2D1_FILL_MODE_FORCE_DWORD: D2D1_FILL_MODE = D2D1_FILL_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FILL_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FILL_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FILL_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FILL_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FILL_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FILL_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FILL_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FILTER(pub u32);
pub const D2D1_FILTER_MIN_MAG_MIP_POINT: D2D1_FILTER = D2D1_FILTER(0u32);
pub const D2D1_FILTER_MIN_MAG_POINT_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(1u32);
pub const D2D1_FILTER_MIN_POINT_MAG_LINEAR_MIP_POINT: D2D1_FILTER = D2D1_FILTER(4u32);
pub const D2D1_FILTER_MIN_POINT_MAG_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(5u32);
pub const D2D1_FILTER_MIN_LINEAR_MAG_MIP_POINT: D2D1_FILTER = D2D1_FILTER(16u32);
pub const D2D1_FILTER_MIN_LINEAR_MAG_POINT_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(17u32);
pub const D2D1_FILTER_MIN_MAG_LINEAR_MIP_POINT: D2D1_FILTER = D2D1_FILTER(20u32);
pub const D2D1_FILTER_MIN_MAG_MIP_LINEAR: D2D1_FILTER = D2D1_FILTER(21u32);
pub const D2D1_FILTER_ANISOTROPIC: D2D1_FILTER = D2D1_FILTER(85u32);
pub const D2D1_FILTER_FORCE_DWORD: D2D1_FILTER = D2D1_FILTER(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FILTER {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FILTER {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FILTER {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FILTER {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FILTER {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FILTER {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_FLOOD_PROP(pub u32);
pub const D2D1_FLOOD_PROP_COLOR: D2D1_FLOOD_PROP = D2D1_FLOOD_PROP(0u32);
pub const D2D1_FLOOD_PROP_FORCE_DWORD: D2D1_FLOOD_PROP = D2D1_FLOOD_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_FLOOD_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_FLOOD_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_FLOOD_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_FLOOD_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_FLOOD_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_FLOOD_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_FLOOD_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_GAMMA(pub u32);
pub const D2D1_GAMMA_2_2: D2D1_GAMMA = D2D1_GAMMA(0u32);
pub const D2D1_GAMMA_1_0: D2D1_GAMMA = D2D1_GAMMA(1u32);
pub const D2D1_GAMMA_FORCE_DWORD: D2D1_GAMMA = D2D1_GAMMA(4294967295u32);
impl ::std::convert::From<u32> for D2D1_GAMMA {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_GAMMA {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_GAMMA {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_GAMMA {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_GAMMA {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_GAMMA {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_GAMMA {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_GAMMA1(pub u32);
pub const D2D1_GAMMA1_G22: D2D1_GAMMA1 = D2D1_GAMMA1(0u32);
pub const D2D1_GAMMA1_G10: D2D1_GAMMA1 = D2D1_GAMMA1(1u32);
pub const D2D1_GAMMA1_G2084: D2D1_GAMMA1 = D2D1_GAMMA1(2u32);
pub const D2D1_GAMMA1_FORCE_DWORD: D2D1_GAMMA1 = D2D1_GAMMA1(4294967295u32);
impl ::std::convert::From<u32> for D2D1_GAMMA1 {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_GAMMA1 {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_GAMMA1 {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_GAMMA1 {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_GAMMA1 {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_GAMMA1 {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_GAMMA1 {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_GAMMATRANSFER_PROP(pub u32);
pub const D2D1_GAMMATRANSFER_PROP_RED_AMPLITUDE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(0u32);
pub const D2D1_GAMMATRANSFER_PROP_RED_EXPONENT: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(1u32);
pub const D2D1_GAMMATRANSFER_PROP_RED_OFFSET: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(2u32);
pub const D2D1_GAMMATRANSFER_PROP_RED_DISABLE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(3u32);
pub const D2D1_GAMMATRANSFER_PROP_GREEN_AMPLITUDE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(4u32);
pub const D2D1_GAMMATRANSFER_PROP_GREEN_EXPONENT: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(5u32);
pub const D2D1_GAMMATRANSFER_PROP_GREEN_OFFSET: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(6u32);
pub const D2D1_GAMMATRANSFER_PROP_GREEN_DISABLE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(7u32);
pub const D2D1_GAMMATRANSFER_PROP_BLUE_AMPLITUDE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(8u32);
pub const D2D1_GAMMATRANSFER_PROP_BLUE_EXPONENT: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(9u32);
pub const D2D1_GAMMATRANSFER_PROP_BLUE_OFFSET: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(10u32);
pub const D2D1_GAMMATRANSFER_PROP_BLUE_DISABLE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(11u32);
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_AMPLITUDE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(12u32);
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_EXPONENT: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(13u32);
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_OFFSET: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(14u32);
pub const D2D1_GAMMATRANSFER_PROP_ALPHA_DISABLE: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(15u32);
pub const D2D1_GAMMATRANSFER_PROP_CLAMP_OUTPUT: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(16u32);
pub const D2D1_GAMMATRANSFER_PROP_FORCE_DWORD: D2D1_GAMMATRANSFER_PROP =
    D2D1_GAMMATRANSFER_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_GAMMATRANSFER_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_GAMMATRANSFER_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_GAMMATRANSFER_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_GAMMATRANSFER_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_GAMMATRANSFER_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_GAMMATRANSFER_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_GAMMATRANSFER_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_GAUSSIANBLUR_OPTIMIZATION(pub u32);
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_SPEED: D2D1_GAUSSIANBLUR_OPTIMIZATION =
    D2D1_GAUSSIANBLUR_OPTIMIZATION(0u32);
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_BALANCED: D2D1_GAUSSIANBLUR_OPTIMIZATION =
    D2D1_GAUSSIANBLUR_OPTIMIZATION(1u32);
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_QUALITY: D2D1_GAUSSIANBLUR_OPTIMIZATION =
    D2D1_GAUSSIANBLUR_OPTIMIZATION(2u32);
pub const D2D1_GAUSSIANBLUR_OPTIMIZATION_FORCE_DWORD: D2D1_GAUSSIANBLUR_OPTIMIZATION =
    D2D1_GAUSSIANBLUR_OPTIMIZATION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_GAUSSIANBLUR_OPTIMIZATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_GAUSSIANBLUR_PROP(pub u32);
pub const D2D1_GAUSSIANBLUR_PROP_STANDARD_DEVIATION: D2D1_GAUSSIANBLUR_PROP =
    D2D1_GAUSSIANBLUR_PROP(0u32);
pub const D2D1_GAUSSIANBLUR_PROP_OPTIMIZATION: D2D1_GAUSSIANBLUR_PROP =
    D2D1_GAUSSIANBLUR_PROP(1u32);
pub const D2D1_GAUSSIANBLUR_PROP_BORDER_MODE: D2D1_GAUSSIANBLUR_PROP = D2D1_GAUSSIANBLUR_PROP(2u32);
pub const D2D1_GAUSSIANBLUR_PROP_FORCE_DWORD: D2D1_GAUSSIANBLUR_PROP =
    D2D1_GAUSSIANBLUR_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_GAUSSIANBLUR_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_GAUSSIANBLUR_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_GAUSSIANBLUR_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_GAUSSIANBLUR_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_GAUSSIANBLUR_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_GAUSSIANBLUR_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_GAUSSIANBLUR_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_GEOMETRY_RELATION(pub u32);
pub const D2D1_GEOMETRY_RELATION_UNKNOWN: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(0u32);
pub const D2D1_GEOMETRY_RELATION_DISJOINT: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(1u32);
pub const D2D1_GEOMETRY_RELATION_IS_CONTAINED: D2D1_GEOMETRY_RELATION =
    D2D1_GEOMETRY_RELATION(2u32);
pub const D2D1_GEOMETRY_RELATION_CONTAINS: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(3u32);
pub const D2D1_GEOMETRY_RELATION_OVERLAP: D2D1_GEOMETRY_RELATION = D2D1_GEOMETRY_RELATION(4u32);
pub const D2D1_GEOMETRY_RELATION_FORCE_DWORD: D2D1_GEOMETRY_RELATION =
    D2D1_GEOMETRY_RELATION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_GEOMETRY_RELATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_GEOMETRY_RELATION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_GEOMETRY_RELATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_GEOMETRY_RELATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_GEOMETRY_RELATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_GEOMETRY_RELATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_GEOMETRY_RELATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_GEOMETRY_SIMPLIFICATION_OPTION(pub u32);
pub const D2D1_GEOMETRY_SIMPLIFICATION_OPTION_CUBICS_AND_LINES:
    D2D1_GEOMETRY_SIMPLIFICATION_OPTION = D2D1_GEOMETRY_SIMPLIFICATION_OPTION(0u32);
pub const D2D1_GEOMETRY_SIMPLIFICATION_OPTION_LINES: D2D1_GEOMETRY_SIMPLIFICATION_OPTION =
    D2D1_GEOMETRY_SIMPLIFICATION_OPTION(1u32);
pub const D2D1_GEOMETRY_SIMPLIFICATION_OPTION_FORCE_DWORD: D2D1_GEOMETRY_SIMPLIFICATION_OPTION =
    D2D1_GEOMETRY_SIMPLIFICATION_OPTION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_GEOMETRY_SIMPLIFICATION_OPTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_GRADIENT_MESH_PATCH {
    pub point00: D2D_POINT_2F,
    pub point01: D2D_POINT_2F,
    pub point02: D2D_POINT_2F,
    pub point03: D2D_POINT_2F,
    pub point10: D2D_POINT_2F,
    pub point11: D2D_POINT_2F,
    pub point12: D2D_POINT_2F,
    pub point13: D2D_POINT_2F,
    pub point20: D2D_POINT_2F,
    pub point21: D2D_POINT_2F,
    pub point22: D2D_POINT_2F,
    pub point23: D2D_POINT_2F,
    pub point30: D2D_POINT_2F,
    pub point31: D2D_POINT_2F,
    pub point32: D2D_POINT_2F,
    pub point33: D2D_POINT_2F,
    pub color00: D2D1_COLOR_F,
    pub color03: D2D1_COLOR_F,
    pub color30: D2D1_COLOR_F,
    pub color33: D2D1_COLOR_F,
    pub topEdgeMode: D2D1_PATCH_EDGE_MODE,
    pub leftEdgeMode: D2D1_PATCH_EDGE_MODE,
    pub bottomEdgeMode: D2D1_PATCH_EDGE_MODE,
    pub rightEdgeMode: D2D1_PATCH_EDGE_MODE,
}
impl D2D1_GRADIENT_MESH_PATCH {}
impl ::std::default::Default for D2D1_GRADIENT_MESH_PATCH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_GRADIENT_MESH_PATCH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_GRADIENT_MESH_PATCH")
            .field("point00", &self.point00)
            .field("point01", &self.point01)
            .field("point02", &self.point02)
            .field("point03", &self.point03)
            .field("point10", &self.point10)
            .field("point11", &self.point11)
            .field("point12", &self.point12)
            .field("point13", &self.point13)
            .field("point20", &self.point20)
            .field("point21", &self.point21)
            .field("point22", &self.point22)
            .field("point23", &self.point23)
            .field("point30", &self.point30)
            .field("point31", &self.point31)
            .field("point32", &self.point32)
            .field("point33", &self.point33)
            .field("color00", &self.color00)
            .field("color03", &self.color03)
            .field("color30", &self.color30)
            .field("color33", &self.color33)
            .field("topEdgeMode", &self.topEdgeMode)
            .field("leftEdgeMode", &self.leftEdgeMode)
            .field("bottomEdgeMode", &self.bottomEdgeMode)
            .field("rightEdgeMode", &self.rightEdgeMode)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_GRADIENT_MESH_PATCH {
    fn eq(&self, other: &Self) -> bool {
        self.point00 == other.point00
            && self.point01 == other.point01
            && self.point02 == other.point02
            && self.point03 == other.point03
            && self.point10 == other.point10
            && self.point11 == other.point11
            && self.point12 == other.point12
            && self.point13 == other.point13
            && self.point20 == other.point20
            && self.point21 == other.point21
            && self.point22 == other.point22
            && self.point23 == other.point23
            && self.point30 == other.point30
            && self.point31 == other.point31
            && self.point32 == other.point32
            && self.point33 == other.point33
            && self.color00 == other.color00
            && self.color03 == other.color03
            && self.color30 == other.color30
            && self.color33 == other.color33
            && self.topEdgeMode == other.topEdgeMode
            && self.leftEdgeMode == other.leftEdgeMode
            && self.bottomEdgeMode == other.bottomEdgeMode
            && self.rightEdgeMode == other.rightEdgeMode
    }
}
impl ::std::cmp::Eq for D2D1_GRADIENT_MESH_PATCH {}
unsafe impl ::windows::runtime::Abi for D2D1_GRADIENT_MESH_PATCH {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_GRADIENT_STOP {
    pub position: f32,
    pub color: D2D1_COLOR_F,
}
impl D2D1_GRADIENT_STOP {}
impl ::std::default::Default for D2D1_GRADIENT_STOP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_GRADIENT_STOP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_GRADIENT_STOP")
            .field("position", &self.position)
            .field("color", &self.color)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_GRADIENT_STOP {
    fn eq(&self, other: &Self) -> bool {
        self.position == other.position && self.color == other.color
    }
}
impl ::std::cmp::Eq for D2D1_GRADIENT_STOP {}
unsafe impl ::windows::runtime::Abi for D2D1_GRADIENT_STOP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HDRTONEMAP_DISPLAY_MODE(pub u32);
pub const D2D1_HDRTONEMAP_DISPLAY_MODE_SDR: D2D1_HDRTONEMAP_DISPLAY_MODE =
    D2D1_HDRTONEMAP_DISPLAY_MODE(0u32);
pub const D2D1_HDRTONEMAP_DISPLAY_MODE_HDR: D2D1_HDRTONEMAP_DISPLAY_MODE =
    D2D1_HDRTONEMAP_DISPLAY_MODE(1u32);
pub const D2D1_HDRTONEMAP_DISPLAY_MODE_FORCE_DWORD: D2D1_HDRTONEMAP_DISPLAY_MODE =
    D2D1_HDRTONEMAP_DISPLAY_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HDRTONEMAP_DISPLAY_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HDRTONEMAP_DISPLAY_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HDRTONEMAP_DISPLAY_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HDRTONEMAP_DISPLAY_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HDRTONEMAP_DISPLAY_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HDRTONEMAP_DISPLAY_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HDRTONEMAP_DISPLAY_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HDRTONEMAP_PROP(pub u32);
pub const D2D1_HDRTONEMAP_PROP_INPUT_MAX_LUMINANCE: D2D1_HDRTONEMAP_PROP =
    D2D1_HDRTONEMAP_PROP(0u32);
pub const D2D1_HDRTONEMAP_PROP_OUTPUT_MAX_LUMINANCE: D2D1_HDRTONEMAP_PROP =
    D2D1_HDRTONEMAP_PROP(1u32);
pub const D2D1_HDRTONEMAP_PROP_DISPLAY_MODE: D2D1_HDRTONEMAP_PROP = D2D1_HDRTONEMAP_PROP(2u32);
pub const D2D1_HDRTONEMAP_PROP_FORCE_DWORD: D2D1_HDRTONEMAP_PROP =
    D2D1_HDRTONEMAP_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HDRTONEMAP_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HDRTONEMAP_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HDRTONEMAP_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HDRTONEMAP_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HDRTONEMAP_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HDRTONEMAP_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HDRTONEMAP_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(pub u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_LINEAR: D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA =
    D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(0u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_SRGB: D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA =
    D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(1u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA_FORCE_DWORD: D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA =
    D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HIGHLIGHTSANDSHADOWS_INPUT_GAMMA {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HIGHLIGHTSANDSHADOWS_PROP(pub u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_HIGHLIGHTS: D2D1_HIGHLIGHTSANDSHADOWS_PROP =
    D2D1_HIGHLIGHTSANDSHADOWS_PROP(0u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_SHADOWS: D2D1_HIGHLIGHTSANDSHADOWS_PROP =
    D2D1_HIGHLIGHTSANDSHADOWS_PROP(1u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_CLARITY: D2D1_HIGHLIGHTSANDSHADOWS_PROP =
    D2D1_HIGHLIGHTSANDSHADOWS_PROP(2u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_INPUT_GAMMA: D2D1_HIGHLIGHTSANDSHADOWS_PROP =
    D2D1_HIGHLIGHTSANDSHADOWS_PROP(3u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_MASK_BLUR_RADIUS: D2D1_HIGHLIGHTSANDSHADOWS_PROP =
    D2D1_HIGHLIGHTSANDSHADOWS_PROP(4u32);
pub const D2D1_HIGHLIGHTSANDSHADOWS_PROP_FORCE_DWORD: D2D1_HIGHLIGHTSANDSHADOWS_PROP =
    D2D1_HIGHLIGHTSANDSHADOWS_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HIGHLIGHTSANDSHADOWS_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HISTOGRAM_PROP(pub u32);
pub const D2D1_HISTOGRAM_PROP_NUM_BINS: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(0u32);
pub const D2D1_HISTOGRAM_PROP_CHANNEL_SELECT: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(1u32);
pub const D2D1_HISTOGRAM_PROP_HISTOGRAM_OUTPUT: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(2u32);
pub const D2D1_HISTOGRAM_PROP_FORCE_DWORD: D2D1_HISTOGRAM_PROP = D2D1_HISTOGRAM_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HISTOGRAM_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HISTOGRAM_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HISTOGRAM_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HISTOGRAM_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HISTOGRAM_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HISTOGRAM_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HISTOGRAM_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HUEROTATION_PROP(pub u32);
pub const D2D1_HUEROTATION_PROP_ANGLE: D2D1_HUEROTATION_PROP = D2D1_HUEROTATION_PROP(0u32);
pub const D2D1_HUEROTATION_PROP_FORCE_DWORD: D2D1_HUEROTATION_PROP =
    D2D1_HUEROTATION_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HUEROTATION_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HUEROTATION_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HUEROTATION_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HUEROTATION_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HUEROTATION_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HUEROTATION_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HUEROTATION_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HUETORGB_INPUT_COLOR_SPACE(pub u32);
pub const D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_VALUE: D2D1_HUETORGB_INPUT_COLOR_SPACE =
    D2D1_HUETORGB_INPUT_COLOR_SPACE(0u32);
pub const D2D1_HUETORGB_INPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS:
    D2D1_HUETORGB_INPUT_COLOR_SPACE = D2D1_HUETORGB_INPUT_COLOR_SPACE(1u32);
pub const D2D1_HUETORGB_INPUT_COLOR_SPACE_FORCE_DWORD: D2D1_HUETORGB_INPUT_COLOR_SPACE =
    D2D1_HUETORGB_INPUT_COLOR_SPACE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HUETORGB_INPUT_COLOR_SPACE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_HUETORGB_PROP(pub u32);
pub const D2D1_HUETORGB_PROP_INPUT_COLOR_SPACE: D2D1_HUETORGB_PROP = D2D1_HUETORGB_PROP(0u32);
pub const D2D1_HUETORGB_PROP_FORCE_DWORD: D2D1_HUETORGB_PROP = D2D1_HUETORGB_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_HUETORGB_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_HUETORGB_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_HUETORGB_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_HUETORGB_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_HUETORGB_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_HUETORGB_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_HUETORGB_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_HWND_RENDER_TARGET_PROPERTIES {
    pub hwnd: super::super::Foundation::HWND,
    pub pixelSize: D2D_SIZE_U,
    pub presentOptions: D2D1_PRESENT_OPTIONS,
}
#[cfg(feature = "Win32_Foundation")]
impl D2D1_HWND_RENDER_TARGET_PROPERTIES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_HWND_RENDER_TARGET_PROPERTIES")
            .field("hwnd", &self.hwnd)
            .field("pixelSize", &self.pixelSize)
            .field("presentOptions", &self.presentOptions)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.hwnd == other.hwnd
            && self.pixelSize == other.pixelSize
            && self.presentOptions == other.presentOptions
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D2D1_HWND_RENDER_TARGET_PROPERTIES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D2D1_HWND_RENDER_TARGET_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_IMAGE_BRUSH_PROPERTIES {
    pub sourceRectangle: D2D_RECT_F,
    pub extendModeX: D2D1_EXTEND_MODE,
    pub extendModeY: D2D1_EXTEND_MODE,
    pub interpolationMode: D2D1_INTERPOLATION_MODE,
}
impl D2D1_IMAGE_BRUSH_PROPERTIES {}
impl ::std::default::Default for D2D1_IMAGE_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_IMAGE_BRUSH_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_IMAGE_BRUSH_PROPERTIES")
            .field("sourceRectangle", &self.sourceRectangle)
            .field("extendModeX", &self.extendModeX)
            .field("extendModeY", &self.extendModeY)
            .field("interpolationMode", &self.interpolationMode)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_IMAGE_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.sourceRectangle == other.sourceRectangle
            && self.extendModeX == other.extendModeX
            && self.extendModeY == other.extendModeY
            && self.interpolationMode == other.interpolationMode
    }
}
impl ::std::cmp::Eq for D2D1_IMAGE_BRUSH_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_IMAGE_BRUSH_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(pub u32);
pub const D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_NONE: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS =
    D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(0u32);
pub const D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_LOW_QUALITY_PRIMARY_CONVERSION:
    D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS = D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(1u32);
pub const D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS_FORCE_DWORD: D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS =
    D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_IMAGE_SOURCE_FROM_DXGI_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_IMAGE_SOURCE_LOADING_OPTIONS(pub u32);
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_NONE: D2D1_IMAGE_SOURCE_LOADING_OPTIONS =
    D2D1_IMAGE_SOURCE_LOADING_OPTIONS(0u32);
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_RELEASE_SOURCE: D2D1_IMAGE_SOURCE_LOADING_OPTIONS =
    D2D1_IMAGE_SOURCE_LOADING_OPTIONS(1u32);
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_CACHE_ON_DEMAND: D2D1_IMAGE_SOURCE_LOADING_OPTIONS =
    D2D1_IMAGE_SOURCE_LOADING_OPTIONS(2u32);
pub const D2D1_IMAGE_SOURCE_LOADING_OPTIONS_FORCE_DWORD: D2D1_IMAGE_SOURCE_LOADING_OPTIONS =
    D2D1_IMAGE_SOURCE_LOADING_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_IMAGE_SOURCE_LOADING_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_INK_BEZIER_SEGMENT {
    pub point1: D2D1_INK_POINT,
    pub point2: D2D1_INK_POINT,
    pub point3: D2D1_INK_POINT,
}
impl D2D1_INK_BEZIER_SEGMENT {}
impl ::std::default::Default for D2D1_INK_BEZIER_SEGMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_INK_BEZIER_SEGMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_INK_BEZIER_SEGMENT")
            .field("point1", &self.point1)
            .field("point2", &self.point2)
            .field("point3", &self.point3)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_INK_BEZIER_SEGMENT {
    fn eq(&self, other: &Self) -> bool {
        self.point1 == other.point1 && self.point2 == other.point2 && self.point3 == other.point3
    }
}
impl ::std::cmp::Eq for D2D1_INK_BEZIER_SEGMENT {}
unsafe impl ::windows::runtime::Abi for D2D1_INK_BEZIER_SEGMENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_INK_NIB_SHAPE(pub u32);
pub const D2D1_INK_NIB_SHAPE_ROUND: D2D1_INK_NIB_SHAPE = D2D1_INK_NIB_SHAPE(0u32);
pub const D2D1_INK_NIB_SHAPE_SQUARE: D2D1_INK_NIB_SHAPE = D2D1_INK_NIB_SHAPE(1u32);
pub const D2D1_INK_NIB_SHAPE_FORCE_DWORD: D2D1_INK_NIB_SHAPE = D2D1_INK_NIB_SHAPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_INK_NIB_SHAPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_INK_NIB_SHAPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_INK_NIB_SHAPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_INK_NIB_SHAPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_INK_NIB_SHAPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_INK_NIB_SHAPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_INK_NIB_SHAPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_INK_POINT {
    pub x: f32,
    pub y: f32,
    pub radius: f32,
}
impl D2D1_INK_POINT {}
impl ::std::default::Default for D2D1_INK_POINT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_INK_POINT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_INK_POINT")
            .field("x", &self.x)
            .field("y", &self.y)
            .field("radius", &self.radius)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_INK_POINT {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y && self.radius == other.radius
    }
}
impl ::std::cmp::Eq for D2D1_INK_POINT {}
unsafe impl ::windows::runtime::Abi for D2D1_INK_POINT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_INK_STYLE_PROPERTIES {
    pub nibShape: D2D1_INK_NIB_SHAPE,
    pub nibTransform: super::super::super::Foundation::Numerics::Matrix3x2,
}
#[cfg(feature = "Foundation_Numerics")]
impl D2D1_INK_STYLE_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::default::Default for D2D1_INK_STYLE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::fmt::Debug for D2D1_INK_STYLE_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_INK_STYLE_PROPERTIES")
            .field("nibShape", &self.nibShape)
            .field("nibTransform", &self.nibTransform)
            .finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::PartialEq for D2D1_INK_STYLE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.nibShape == other.nibShape && self.nibTransform == other.nibTransform
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::Eq for D2D1_INK_STYLE_PROPERTIES {}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::runtime::Abi for D2D1_INK_STYLE_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_INPUT_DESCRIPTION {
    pub filter: D2D1_FILTER,
    pub levelOfDetailCount: u32,
}
impl D2D1_INPUT_DESCRIPTION {}
impl ::std::default::Default for D2D1_INPUT_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_INPUT_DESCRIPTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_INPUT_DESCRIPTION")
            .field("filter", &self.filter)
            .field("levelOfDetailCount", &self.levelOfDetailCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_INPUT_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.filter == other.filter && self.levelOfDetailCount == other.levelOfDetailCount
    }
}
impl ::std::cmp::Eq for D2D1_INPUT_DESCRIPTION {}
unsafe impl ::windows::runtime::Abi for D2D1_INPUT_DESCRIPTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
pub struct D2D1_INPUT_ELEMENT_DESC {
    pub semanticName: super::super::Foundation::PSTR,
    pub semanticIndex: u32,
    pub format: super::Dxgi::DXGI_FORMAT,
    pub inputSlot: u32,
    pub alignedByteOffset: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl D2D1_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::default::Default for D2D1_INPUT_ELEMENT_DESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::fmt::Debug for D2D1_INPUT_ELEMENT_DESC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_INPUT_ELEMENT_DESC")
            .field("semanticName", &self.semanticName)
            .field("semanticIndex", &self.semanticIndex)
            .field("format", &self.format)
            .field("inputSlot", &self.inputSlot)
            .field("alignedByteOffset", &self.alignedByteOffset)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::PartialEq for D2D1_INPUT_ELEMENT_DESC {
    fn eq(&self, other: &Self) -> bool {
        self.semanticName == other.semanticName
            && self.semanticIndex == other.semanticIndex
            && self.format == other.format
            && self.inputSlot == other.inputSlot
            && self.alignedByteOffset == other.alignedByteOffset
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
impl ::std::cmp::Eq for D2D1_INPUT_ELEMENT_DESC {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
unsafe impl ::windows::runtime::Abi for D2D1_INPUT_ELEMENT_DESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_INTERPOLATION_MODE(pub u32);
pub const D2D1_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_INTERPOLATION_MODE =
    D2D1_INTERPOLATION_MODE(0u32);
pub const D2D1_INTERPOLATION_MODE_LINEAR: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(1u32);
pub const D2D1_INTERPOLATION_MODE_CUBIC: D2D1_INTERPOLATION_MODE = D2D1_INTERPOLATION_MODE(2u32);
pub const D2D1_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_INTERPOLATION_MODE =
    D2D1_INTERPOLATION_MODE(3u32);
pub const D2D1_INTERPOLATION_MODE_ANISOTROPIC: D2D1_INTERPOLATION_MODE =
    D2D1_INTERPOLATION_MODE(4u32);
pub const D2D1_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: D2D1_INTERPOLATION_MODE =
    D2D1_INTERPOLATION_MODE(5u32);
pub const D2D1_INTERPOLATION_MODE_FORCE_DWORD: D2D1_INTERPOLATION_MODE =
    D2D1_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_INTERPOLATION_MODE_DEFINITION(pub i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_NEAREST_NEIGHBOR: D2D1_INTERPOLATION_MODE_DEFINITION =
    D2D1_INTERPOLATION_MODE_DEFINITION(0i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_LINEAR: D2D1_INTERPOLATION_MODE_DEFINITION =
    D2D1_INTERPOLATION_MODE_DEFINITION(1i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_CUBIC: D2D1_INTERPOLATION_MODE_DEFINITION =
    D2D1_INTERPOLATION_MODE_DEFINITION(2i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_MULTI_SAMPLE_LINEAR:
    D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(3i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_ANISOTROPIC: D2D1_INTERPOLATION_MODE_DEFINITION =
    D2D1_INTERPOLATION_MODE_DEFINITION(4i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_HIGH_QUALITY_CUBIC:
    D2D1_INTERPOLATION_MODE_DEFINITION = D2D1_INTERPOLATION_MODE_DEFINITION(5i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_FANT: D2D1_INTERPOLATION_MODE_DEFINITION =
    D2D1_INTERPOLATION_MODE_DEFINITION(6i32);
pub const D2D1_INTERPOLATION_MODE_DEFINITION_MIPMAP_LINEAR: D2D1_INTERPOLATION_MODE_DEFINITION =
    D2D1_INTERPOLATION_MODE_DEFINITION(7i32);
impl ::std::convert::From<i32> for D2D1_INTERPOLATION_MODE_DEFINITION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_INTERPOLATION_MODE_DEFINITION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_LAYER_OPTIONS(pub u32);
pub const D2D1_LAYER_OPTIONS_NONE: D2D1_LAYER_OPTIONS = D2D1_LAYER_OPTIONS(0u32);
pub const D2D1_LAYER_OPTIONS_INITIALIZE_FOR_CLEARTYPE: D2D1_LAYER_OPTIONS =
    D2D1_LAYER_OPTIONS(1u32);
pub const D2D1_LAYER_OPTIONS_FORCE_DWORD: D2D1_LAYER_OPTIONS = D2D1_LAYER_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_LAYER_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_LAYER_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_LAYER_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_LAYER_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_LAYER_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_LAYER_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_LAYER_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_LAYER_OPTIONS1(pub u32);
pub const D2D1_LAYER_OPTIONS1_NONE: D2D1_LAYER_OPTIONS1 = D2D1_LAYER_OPTIONS1(0u32);
pub const D2D1_LAYER_OPTIONS1_INITIALIZE_FROM_BACKGROUND: D2D1_LAYER_OPTIONS1 =
    D2D1_LAYER_OPTIONS1(1u32);
pub const D2D1_LAYER_OPTIONS1_IGNORE_ALPHA: D2D1_LAYER_OPTIONS1 = D2D1_LAYER_OPTIONS1(2u32);
pub const D2D1_LAYER_OPTIONS1_FORCE_DWORD: D2D1_LAYER_OPTIONS1 = D2D1_LAYER_OPTIONS1(4294967295u32);
impl ::std::convert::From<u32> for D2D1_LAYER_OPTIONS1 {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_LAYER_OPTIONS1 {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_LAYER_OPTIONS1 {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_LAYER_OPTIONS1 {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_LAYER_OPTIONS1 {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_LAYER_OPTIONS1 {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_LAYER_OPTIONS1 {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_LAYER_PARAMETERS {
    pub contentBounds: D2D_RECT_F,
    pub geometricMask: ::std::option::Option<ID2D1Geometry>,
    pub maskAntialiasMode: D2D1_ANTIALIAS_MODE,
    pub maskTransform: super::super::super::Foundation::Numerics::Matrix3x2,
    pub opacity: f32,
    pub opacityBrush: ::std::option::Option<ID2D1Brush>,
    pub layerOptions: D2D1_LAYER_OPTIONS,
}
#[cfg(feature = "Foundation_Numerics")]
impl D2D1_LAYER_PARAMETERS {}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::default::Default for D2D1_LAYER_PARAMETERS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::fmt::Debug for D2D1_LAYER_PARAMETERS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_LAYER_PARAMETERS")
            .field("contentBounds", &self.contentBounds)
            .field("geometricMask", &self.geometricMask)
            .field("maskAntialiasMode", &self.maskAntialiasMode)
            .field("maskTransform", &self.maskTransform)
            .field("opacity", &self.opacity)
            .field("opacityBrush", &self.opacityBrush)
            .field("layerOptions", &self.layerOptions)
            .finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::PartialEq for D2D1_LAYER_PARAMETERS {
    fn eq(&self, other: &Self) -> bool {
        self.contentBounds == other.contentBounds
            && self.geometricMask == other.geometricMask
            && self.maskAntialiasMode == other.maskAntialiasMode
            && self.maskTransform == other.maskTransform
            && self.opacity == other.opacity
            && self.opacityBrush == other.opacityBrush
            && self.layerOptions == other.layerOptions
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::Eq for D2D1_LAYER_PARAMETERS {}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::runtime::Abi for D2D1_LAYER_PARAMETERS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Foundation_Numerics")]
pub struct D2D1_LAYER_PARAMETERS1 {
    pub contentBounds: D2D_RECT_F,
    pub geometricMask: ::std::option::Option<ID2D1Geometry>,
    pub maskAntialiasMode: D2D1_ANTIALIAS_MODE,
    pub maskTransform: super::super::super::Foundation::Numerics::Matrix3x2,
    pub opacity: f32,
    pub opacityBrush: ::std::option::Option<ID2D1Brush>,
    pub layerOptions: D2D1_LAYER_OPTIONS1,
}
#[cfg(feature = "Foundation_Numerics")]
impl D2D1_LAYER_PARAMETERS1 {}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::default::Default for D2D1_LAYER_PARAMETERS1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::fmt::Debug for D2D1_LAYER_PARAMETERS1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_LAYER_PARAMETERS1")
            .field("contentBounds", &self.contentBounds)
            .field("geometricMask", &self.geometricMask)
            .field("maskAntialiasMode", &self.maskAntialiasMode)
            .field("maskTransform", &self.maskTransform)
            .field("opacity", &self.opacity)
            .field("opacityBrush", &self.opacityBrush)
            .field("layerOptions", &self.layerOptions)
            .finish()
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::PartialEq for D2D1_LAYER_PARAMETERS1 {
    fn eq(&self, other: &Self) -> bool {
        self.contentBounds == other.contentBounds
            && self.geometricMask == other.geometricMask
            && self.maskAntialiasMode == other.maskAntialiasMode
            && self.maskTransform == other.maskTransform
            && self.opacity == other.opacity
            && self.opacityBrush == other.opacityBrush
            && self.layerOptions == other.layerOptions
    }
}
#[cfg(feature = "Foundation_Numerics")]
impl ::std::cmp::Eq for D2D1_LAYER_PARAMETERS1 {}
#[cfg(feature = "Foundation_Numerics")]
unsafe impl ::windows::runtime::Abi for D2D1_LAYER_PARAMETERS1 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_LINEARTRANSFER_PROP(pub u32);
pub const D2D1_LINEARTRANSFER_PROP_RED_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(0u32);
pub const D2D1_LINEARTRANSFER_PROP_RED_SLOPE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(1u32);
pub const D2D1_LINEARTRANSFER_PROP_RED_DISABLE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(2u32);
pub const D2D1_LINEARTRANSFER_PROP_GREEN_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(3u32);
pub const D2D1_LINEARTRANSFER_PROP_GREEN_SLOPE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(4u32);
pub const D2D1_LINEARTRANSFER_PROP_GREEN_DISABLE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(5u32);
pub const D2D1_LINEARTRANSFER_PROP_BLUE_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(6u32);
pub const D2D1_LINEARTRANSFER_PROP_BLUE_SLOPE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(7u32);
pub const D2D1_LINEARTRANSFER_PROP_BLUE_DISABLE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(8u32);
pub const D2D1_LINEARTRANSFER_PROP_ALPHA_Y_INTERCEPT: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(9u32);
pub const D2D1_LINEARTRANSFER_PROP_ALPHA_SLOPE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(10u32);
pub const D2D1_LINEARTRANSFER_PROP_ALPHA_DISABLE: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(11u32);
pub const D2D1_LINEARTRANSFER_PROP_CLAMP_OUTPUT: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(12u32);
pub const D2D1_LINEARTRANSFER_PROP_FORCE_DWORD: D2D1_LINEARTRANSFER_PROP =
    D2D1_LINEARTRANSFER_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_LINEARTRANSFER_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_LINEARTRANSFER_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_LINEARTRANSFER_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_LINEARTRANSFER_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_LINEARTRANSFER_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_LINEARTRANSFER_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_LINEARTRANSFER_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    pub startPoint: D2D_POINT_2F,
    pub endPoint: D2D_POINT_2F,
}
impl D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {}
impl ::std::default::Default for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES")
            .field("startPoint", &self.startPoint)
            .field("endPoint", &self.endPoint)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.startPoint == other.startPoint && self.endPoint == other.endPoint
    }
}
impl ::std::cmp::Eq for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_LINE_JOIN(pub u32);
pub const D2D1_LINE_JOIN_MITER: D2D1_LINE_JOIN = D2D1_LINE_JOIN(0u32);
pub const D2D1_LINE_JOIN_BEVEL: D2D1_LINE_JOIN = D2D1_LINE_JOIN(1u32);
pub const D2D1_LINE_JOIN_ROUND: D2D1_LINE_JOIN = D2D1_LINE_JOIN(2u32);
pub const D2D1_LINE_JOIN_MITER_OR_BEVEL: D2D1_LINE_JOIN = D2D1_LINE_JOIN(3u32);
pub const D2D1_LINE_JOIN_FORCE_DWORD: D2D1_LINE_JOIN = D2D1_LINE_JOIN(4294967295u32);
impl ::std::convert::From<u32> for D2D1_LINE_JOIN {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_LINE_JOIN {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_LINE_JOIN {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_LINE_JOIN {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_LINE_JOIN {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_LINE_JOIN {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_LINE_JOIN {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_LOOKUPTABLE3D_PROP(pub u32);
pub const D2D1_LOOKUPTABLE3D_PROP_LUT: D2D1_LOOKUPTABLE3D_PROP = D2D1_LOOKUPTABLE3D_PROP(0u32);
pub const D2D1_LOOKUPTABLE3D_PROP_ALPHA_MODE: D2D1_LOOKUPTABLE3D_PROP =
    D2D1_LOOKUPTABLE3D_PROP(1u32);
pub const D2D1_LOOKUPTABLE3D_PROP_FORCE_DWORD: D2D1_LOOKUPTABLE3D_PROP =
    D2D1_LOOKUPTABLE3D_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_LOOKUPTABLE3D_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_LOOKUPTABLE3D_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_LOOKUPTABLE3D_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_LOOKUPTABLE3D_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_LOOKUPTABLE3D_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_LOOKUPTABLE3D_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_LOOKUPTABLE3D_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_MAPPED_RECT {
    pub pitch: u32,
    pub bits: *mut u8,
}
impl D2D1_MAPPED_RECT {}
impl ::std::default::Default for D2D1_MAPPED_RECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_MAPPED_RECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_MAPPED_RECT")
            .field("pitch", &self.pitch)
            .field("bits", &self.bits)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_MAPPED_RECT {
    fn eq(&self, other: &Self) -> bool {
        self.pitch == other.pitch && self.bits == other.bits
    }
}
impl ::std::cmp::Eq for D2D1_MAPPED_RECT {}
unsafe impl ::windows::runtime::Abi for D2D1_MAPPED_RECT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_MAP_OPTIONS(pub u32);
pub const D2D1_MAP_OPTIONS_NONE: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(0u32);
pub const D2D1_MAP_OPTIONS_READ: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(1u32);
pub const D2D1_MAP_OPTIONS_WRITE: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(2u32);
pub const D2D1_MAP_OPTIONS_DISCARD: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(4u32);
pub const D2D1_MAP_OPTIONS_FORCE_DWORD: D2D1_MAP_OPTIONS = D2D1_MAP_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_MAP_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_MAP_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_MAP_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_MAP_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_MAP_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_MAP_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_MAP_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_MORPHOLOGY_MODE(pub u32);
pub const D2D1_MORPHOLOGY_MODE_ERODE: D2D1_MORPHOLOGY_MODE = D2D1_MORPHOLOGY_MODE(0u32);
pub const D2D1_MORPHOLOGY_MODE_DILATE: D2D1_MORPHOLOGY_MODE = D2D1_MORPHOLOGY_MODE(1u32);
pub const D2D1_MORPHOLOGY_MODE_FORCE_DWORD: D2D1_MORPHOLOGY_MODE =
    D2D1_MORPHOLOGY_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_MORPHOLOGY_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_MORPHOLOGY_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_MORPHOLOGY_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_MORPHOLOGY_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_MORPHOLOGY_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_MORPHOLOGY_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_MORPHOLOGY_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_MORPHOLOGY_PROP(pub u32);
pub const D2D1_MORPHOLOGY_PROP_MODE: D2D1_MORPHOLOGY_PROP = D2D1_MORPHOLOGY_PROP(0u32);
pub const D2D1_MORPHOLOGY_PROP_WIDTH: D2D1_MORPHOLOGY_PROP = D2D1_MORPHOLOGY_PROP(1u32);
pub const D2D1_MORPHOLOGY_PROP_HEIGHT: D2D1_MORPHOLOGY_PROP = D2D1_MORPHOLOGY_PROP(2u32);
pub const D2D1_MORPHOLOGY_PROP_FORCE_DWORD: D2D1_MORPHOLOGY_PROP =
    D2D1_MORPHOLOGY_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_MORPHOLOGY_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_MORPHOLOGY_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_MORPHOLOGY_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_MORPHOLOGY_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_MORPHOLOGY_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_MORPHOLOGY_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_MORPHOLOGY_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_OPACITYMETADATA_PROP(pub u32);
pub const D2D1_OPACITYMETADATA_PROP_INPUT_OPAQUE_RECT: D2D1_OPACITYMETADATA_PROP =
    D2D1_OPACITYMETADATA_PROP(0u32);
pub const D2D1_OPACITYMETADATA_PROP_FORCE_DWORD: D2D1_OPACITYMETADATA_PROP =
    D2D1_OPACITYMETADATA_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_OPACITYMETADATA_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_OPACITYMETADATA_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_OPACITYMETADATA_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_OPACITYMETADATA_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_OPACITYMETADATA_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_OPACITYMETADATA_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_OPACITYMETADATA_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_OPACITY_MASK_CONTENT(pub u32);
pub const D2D1_OPACITY_MASK_CONTENT_GRAPHICS: D2D1_OPACITY_MASK_CONTENT =
    D2D1_OPACITY_MASK_CONTENT(0u32);
pub const D2D1_OPACITY_MASK_CONTENT_TEXT_NATURAL: D2D1_OPACITY_MASK_CONTENT =
    D2D1_OPACITY_MASK_CONTENT(1u32);
pub const D2D1_OPACITY_MASK_CONTENT_TEXT_GDI_COMPATIBLE: D2D1_OPACITY_MASK_CONTENT =
    D2D1_OPACITY_MASK_CONTENT(2u32);
pub const D2D1_OPACITY_MASK_CONTENT_FORCE_DWORD: D2D1_OPACITY_MASK_CONTENT =
    D2D1_OPACITY_MASK_CONTENT(4294967295u32);
impl ::std::convert::From<u32> for D2D1_OPACITY_MASK_CONTENT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_OPACITY_MASK_CONTENT {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_OPACITY_MASK_CONTENT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_OPACITY_MASK_CONTENT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_OPACITY_MASK_CONTENT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_OPACITY_MASK_CONTENT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_OPACITY_MASK_CONTENT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_OPACITY_PROP(pub u32);
pub const D2D1_OPACITY_PROP_OPACITY: D2D1_OPACITY_PROP = D2D1_OPACITY_PROP(0u32);
pub const D2D1_OPACITY_PROP_FORCE_DWORD: D2D1_OPACITY_PROP = D2D1_OPACITY_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_OPACITY_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_OPACITY_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_OPACITY_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_OPACITY_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_OPACITY_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_OPACITY_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_OPACITY_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_ORIENTATION(pub u32);
pub const D2D1_ORIENTATION_DEFAULT: D2D1_ORIENTATION = D2D1_ORIENTATION(1u32);
pub const D2D1_ORIENTATION_FLIP_HORIZONTAL: D2D1_ORIENTATION = D2D1_ORIENTATION(2u32);
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE180: D2D1_ORIENTATION = D2D1_ORIENTATION(3u32);
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE180_FLIP_HORIZONTAL: D2D1_ORIENTATION =
    D2D1_ORIENTATION(4u32);
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE90_FLIP_HORIZONTAL: D2D1_ORIENTATION =
    D2D1_ORIENTATION(5u32);
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE270: D2D1_ORIENTATION = D2D1_ORIENTATION(6u32);
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE270_FLIP_HORIZONTAL: D2D1_ORIENTATION =
    D2D1_ORIENTATION(7u32);
pub const D2D1_ORIENTATION_ROTATE_CLOCKWISE90: D2D1_ORIENTATION = D2D1_ORIENTATION(8u32);
pub const D2D1_ORIENTATION_FORCE_DWORD: D2D1_ORIENTATION = D2D1_ORIENTATION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_ORIENTATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_ORIENTATION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_ORIENTATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_ORIENTATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_ORIENTATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_ORIENTATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_ORIENTATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PATCH_EDGE_MODE(pub u32);
pub const D2D1_PATCH_EDGE_MODE_ALIASED: D2D1_PATCH_EDGE_MODE = D2D1_PATCH_EDGE_MODE(0u32);
pub const D2D1_PATCH_EDGE_MODE_ANTIALIASED: D2D1_PATCH_EDGE_MODE = D2D1_PATCH_EDGE_MODE(1u32);
pub const D2D1_PATCH_EDGE_MODE_ALIASED_INFLATED: D2D1_PATCH_EDGE_MODE = D2D1_PATCH_EDGE_MODE(2u32);
pub const D2D1_PATCH_EDGE_MODE_FORCE_DWORD: D2D1_PATCH_EDGE_MODE =
    D2D1_PATCH_EDGE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PATCH_EDGE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PATCH_EDGE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PATCH_EDGE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PATCH_EDGE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PATCH_EDGE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PATCH_EDGE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PATCH_EDGE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PATH_SEGMENT(pub u32);
pub const D2D1_PATH_SEGMENT_NONE: D2D1_PATH_SEGMENT = D2D1_PATH_SEGMENT(0u32);
pub const D2D1_PATH_SEGMENT_FORCE_UNSTROKED: D2D1_PATH_SEGMENT = D2D1_PATH_SEGMENT(1u32);
pub const D2D1_PATH_SEGMENT_FORCE_ROUND_LINE_JOIN: D2D1_PATH_SEGMENT = D2D1_PATH_SEGMENT(2u32);
pub const D2D1_PATH_SEGMENT_FORCE_DWORD: D2D1_PATH_SEGMENT = D2D1_PATH_SEGMENT(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PATH_SEGMENT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PATH_SEGMENT {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PATH_SEGMENT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PATH_SEGMENT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PATH_SEGMENT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PATH_SEGMENT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PATH_SEGMENT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D2D1_PIXEL_FORMAT {
    pub format: super::Dxgi::DXGI_FORMAT,
    pub alphaMode: D2D1_ALPHA_MODE,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D2D1_PIXEL_FORMAT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D2D1_PIXEL_FORMAT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D2D1_PIXEL_FORMAT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_PIXEL_FORMAT")
            .field("format", &self.format)
            .field("alphaMode", &self.alphaMode)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D2D1_PIXEL_FORMAT {
    fn eq(&self, other: &Self) -> bool {
        self.format == other.format && self.alphaMode == other.alphaMode
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D2D1_PIXEL_FORMAT {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D2D1_PIXEL_FORMAT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PIXEL_OPTIONS(pub u32);
pub const D2D1_PIXEL_OPTIONS_NONE: D2D1_PIXEL_OPTIONS = D2D1_PIXEL_OPTIONS(0u32);
pub const D2D1_PIXEL_OPTIONS_TRIVIAL_SAMPLING: D2D1_PIXEL_OPTIONS = D2D1_PIXEL_OPTIONS(1u32);
pub const D2D1_PIXEL_OPTIONS_FORCE_DWORD: D2D1_PIXEL_OPTIONS = D2D1_PIXEL_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PIXEL_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PIXEL_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PIXEL_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PIXEL_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PIXEL_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PIXEL_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PIXEL_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_POINTDIFFUSE_PROP(pub u32);
pub const D2D1_POINTDIFFUSE_PROP_LIGHT_POSITION: D2D1_POINTDIFFUSE_PROP =
    D2D1_POINTDIFFUSE_PROP(0u32);
pub const D2D1_POINTDIFFUSE_PROP_DIFFUSE_CONSTANT: D2D1_POINTDIFFUSE_PROP =
    D2D1_POINTDIFFUSE_PROP(1u32);
pub const D2D1_POINTDIFFUSE_PROP_SURFACE_SCALE: D2D1_POINTDIFFUSE_PROP =
    D2D1_POINTDIFFUSE_PROP(2u32);
pub const D2D1_POINTDIFFUSE_PROP_COLOR: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(3u32);
pub const D2D1_POINTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: D2D1_POINTDIFFUSE_PROP =
    D2D1_POINTDIFFUSE_PROP(4u32);
pub const D2D1_POINTDIFFUSE_PROP_SCALE_MODE: D2D1_POINTDIFFUSE_PROP = D2D1_POINTDIFFUSE_PROP(5u32);
pub const D2D1_POINTDIFFUSE_PROP_FORCE_DWORD: D2D1_POINTDIFFUSE_PROP =
    D2D1_POINTDIFFUSE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_POINTDIFFUSE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_POINTDIFFUSE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_POINTDIFFUSE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_POINTDIFFUSE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_POINTDIFFUSE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_POINTDIFFUSE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_POINTDIFFUSE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_POINTDIFFUSE_SCALE_MODE(pub u32);
pub const D2D1_POINTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_POINTDIFFUSE_SCALE_MODE =
    D2D1_POINTDIFFUSE_SCALE_MODE(0u32);
pub const D2D1_POINTDIFFUSE_SCALE_MODE_LINEAR: D2D1_POINTDIFFUSE_SCALE_MODE =
    D2D1_POINTDIFFUSE_SCALE_MODE(1u32);
pub const D2D1_POINTDIFFUSE_SCALE_MODE_CUBIC: D2D1_POINTDIFFUSE_SCALE_MODE =
    D2D1_POINTDIFFUSE_SCALE_MODE(2u32);
pub const D2D1_POINTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_POINTDIFFUSE_SCALE_MODE =
    D2D1_POINTDIFFUSE_SCALE_MODE(3u32);
pub const D2D1_POINTDIFFUSE_SCALE_MODE_ANISOTROPIC: D2D1_POINTDIFFUSE_SCALE_MODE =
    D2D1_POINTDIFFUSE_SCALE_MODE(4u32);
pub const D2D1_POINTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_POINTDIFFUSE_SCALE_MODE =
    D2D1_POINTDIFFUSE_SCALE_MODE(5u32);
pub const D2D1_POINTDIFFUSE_SCALE_MODE_FORCE_DWORD: D2D1_POINTDIFFUSE_SCALE_MODE =
    D2D1_POINTDIFFUSE_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_POINTDIFFUSE_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_POINTDIFFUSE_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_POINTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_POINTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_POINTDIFFUSE_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_POINTDIFFUSE_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_POINTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_POINTSPECULAR_PROP(pub u32);
pub const D2D1_POINTSPECULAR_PROP_LIGHT_POSITION: D2D1_POINTSPECULAR_PROP =
    D2D1_POINTSPECULAR_PROP(0u32);
pub const D2D1_POINTSPECULAR_PROP_SPECULAR_EXPONENT: D2D1_POINTSPECULAR_PROP =
    D2D1_POINTSPECULAR_PROP(1u32);
pub const D2D1_POINTSPECULAR_PROP_SPECULAR_CONSTANT: D2D1_POINTSPECULAR_PROP =
    D2D1_POINTSPECULAR_PROP(2u32);
pub const D2D1_POINTSPECULAR_PROP_SURFACE_SCALE: D2D1_POINTSPECULAR_PROP =
    D2D1_POINTSPECULAR_PROP(3u32);
pub const D2D1_POINTSPECULAR_PROP_COLOR: D2D1_POINTSPECULAR_PROP = D2D1_POINTSPECULAR_PROP(4u32);
pub const D2D1_POINTSPECULAR_PROP_KERNEL_UNIT_LENGTH: D2D1_POINTSPECULAR_PROP =
    D2D1_POINTSPECULAR_PROP(5u32);
pub const D2D1_POINTSPECULAR_PROP_SCALE_MODE: D2D1_POINTSPECULAR_PROP =
    D2D1_POINTSPECULAR_PROP(6u32);
pub const D2D1_POINTSPECULAR_PROP_FORCE_DWORD: D2D1_POINTSPECULAR_PROP =
    D2D1_POINTSPECULAR_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_POINTSPECULAR_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_POINTSPECULAR_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_POINTSPECULAR_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_POINTSPECULAR_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_POINTSPECULAR_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_POINTSPECULAR_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_POINTSPECULAR_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_POINTSPECULAR_SCALE_MODE(pub u32);
pub const D2D1_POINTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_POINTSPECULAR_SCALE_MODE =
    D2D1_POINTSPECULAR_SCALE_MODE(0u32);
pub const D2D1_POINTSPECULAR_SCALE_MODE_LINEAR: D2D1_POINTSPECULAR_SCALE_MODE =
    D2D1_POINTSPECULAR_SCALE_MODE(1u32);
pub const D2D1_POINTSPECULAR_SCALE_MODE_CUBIC: D2D1_POINTSPECULAR_SCALE_MODE =
    D2D1_POINTSPECULAR_SCALE_MODE(2u32);
pub const D2D1_POINTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_POINTSPECULAR_SCALE_MODE =
    D2D1_POINTSPECULAR_SCALE_MODE(3u32);
pub const D2D1_POINTSPECULAR_SCALE_MODE_ANISOTROPIC: D2D1_POINTSPECULAR_SCALE_MODE =
    D2D1_POINTSPECULAR_SCALE_MODE(4u32);
pub const D2D1_POINTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_POINTSPECULAR_SCALE_MODE =
    D2D1_POINTSPECULAR_SCALE_MODE(5u32);
pub const D2D1_POINTSPECULAR_SCALE_MODE_FORCE_DWORD: D2D1_POINTSPECULAR_SCALE_MODE =
    D2D1_POINTSPECULAR_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_POINTSPECULAR_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_POINTSPECULAR_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_POINTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_POINTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_POINTSPECULAR_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_POINTSPECULAR_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_POINTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_POINT_DESCRIPTION {
    pub point: D2D_POINT_2F,
    pub unitTangentVector: D2D_POINT_2F,
    pub endSegment: u32,
    pub endFigure: u32,
    pub lengthToEndSegment: f32,
}
impl D2D1_POINT_DESCRIPTION {}
impl ::std::default::Default for D2D1_POINT_DESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_POINT_DESCRIPTION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_POINT_DESCRIPTION")
            .field("point", &self.point)
            .field("unitTangentVector", &self.unitTangentVector)
            .field("endSegment", &self.endSegment)
            .field("endFigure", &self.endFigure)
            .field("lengthToEndSegment", &self.lengthToEndSegment)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_POINT_DESCRIPTION {
    fn eq(&self, other: &Self) -> bool {
        self.point == other.point
            && self.unitTangentVector == other.unitTangentVector
            && self.endSegment == other.endSegment
            && self.endFigure == other.endFigure
            && self.lengthToEndSegment == other.lengthToEndSegment
    }
}
impl ::std::cmp::Eq for D2D1_POINT_DESCRIPTION {}
unsafe impl ::windows::runtime::Abi for D2D1_POINT_DESCRIPTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_POSTERIZE_PROP(pub u32);
pub const D2D1_POSTERIZE_PROP_RED_VALUE_COUNT: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(0u32);
pub const D2D1_POSTERIZE_PROP_GREEN_VALUE_COUNT: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(1u32);
pub const D2D1_POSTERIZE_PROP_BLUE_VALUE_COUNT: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(2u32);
pub const D2D1_POSTERIZE_PROP_FORCE_DWORD: D2D1_POSTERIZE_PROP = D2D1_POSTERIZE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_POSTERIZE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_POSTERIZE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_POSTERIZE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_POSTERIZE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_POSTERIZE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_POSTERIZE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_POSTERIZE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PRESENT_OPTIONS(pub u32);
pub const D2D1_PRESENT_OPTIONS_NONE: D2D1_PRESENT_OPTIONS = D2D1_PRESENT_OPTIONS(0u32);
pub const D2D1_PRESENT_OPTIONS_RETAIN_CONTENTS: D2D1_PRESENT_OPTIONS = D2D1_PRESENT_OPTIONS(1u32);
pub const D2D1_PRESENT_OPTIONS_IMMEDIATELY: D2D1_PRESENT_OPTIONS = D2D1_PRESENT_OPTIONS(2u32);
pub const D2D1_PRESENT_OPTIONS_FORCE_DWORD: D2D1_PRESENT_OPTIONS =
    D2D1_PRESENT_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PRESENT_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PRESENT_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PRESENT_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PRESENT_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PRESENT_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PRESENT_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PRESENT_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PRIMITIVE_BLEND(pub u32);
pub const D2D1_PRIMITIVE_BLEND_SOURCE_OVER: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(0u32);
pub const D2D1_PRIMITIVE_BLEND_COPY: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(1u32);
pub const D2D1_PRIMITIVE_BLEND_MIN: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(2u32);
pub const D2D1_PRIMITIVE_BLEND_ADD: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(3u32);
pub const D2D1_PRIMITIVE_BLEND_MAX: D2D1_PRIMITIVE_BLEND = D2D1_PRIMITIVE_BLEND(4u32);
pub const D2D1_PRIMITIVE_BLEND_FORCE_DWORD: D2D1_PRIMITIVE_BLEND =
    D2D1_PRIMITIVE_BLEND(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PRIMITIVE_BLEND {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PRIMITIVE_BLEND {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PRIMITIVE_BLEND {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PRIMITIVE_BLEND {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PRIMITIVE_BLEND {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PRIMITIVE_BLEND {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PRIMITIVE_BLEND {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_PRINT_CONTROL_PROPERTIES {
    pub fontSubset: D2D1_PRINT_FONT_SUBSET_MODE,
    pub rasterDPI: f32,
    pub colorSpace: D2D1_COLOR_SPACE,
}
impl D2D1_PRINT_CONTROL_PROPERTIES {}
impl ::std::default::Default for D2D1_PRINT_CONTROL_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_PRINT_CONTROL_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_PRINT_CONTROL_PROPERTIES")
            .field("fontSubset", &self.fontSubset)
            .field("rasterDPI", &self.rasterDPI)
            .field("colorSpace", &self.colorSpace)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_PRINT_CONTROL_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.fontSubset == other.fontSubset
            && self.rasterDPI == other.rasterDPI
            && self.colorSpace == other.colorSpace
    }
}
impl ::std::cmp::Eq for D2D1_PRINT_CONTROL_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_PRINT_CONTROL_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PRINT_FONT_SUBSET_MODE(pub u32);
pub const D2D1_PRINT_FONT_SUBSET_MODE_DEFAULT: D2D1_PRINT_FONT_SUBSET_MODE =
    D2D1_PRINT_FONT_SUBSET_MODE(0u32);
pub const D2D1_PRINT_FONT_SUBSET_MODE_EACHPAGE: D2D1_PRINT_FONT_SUBSET_MODE =
    D2D1_PRINT_FONT_SUBSET_MODE(1u32);
pub const D2D1_PRINT_FONT_SUBSET_MODE_NONE: D2D1_PRINT_FONT_SUBSET_MODE =
    D2D1_PRINT_FONT_SUBSET_MODE(2u32);
pub const D2D1_PRINT_FONT_SUBSET_MODE_FORCE_DWORD: D2D1_PRINT_FONT_SUBSET_MODE =
    D2D1_PRINT_FONT_SUBSET_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PRINT_FONT_SUBSET_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PRINT_FONT_SUBSET_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PRINT_FONT_SUBSET_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PRINT_FONT_SUBSET_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PRINT_FONT_SUBSET_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PRINT_FONT_SUBSET_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PRINT_FONT_SUBSET_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PROPERTY(pub u32);
pub const D2D1_PROPERTY_CLSID: D2D1_PROPERTY = D2D1_PROPERTY(2147483648u32);
pub const D2D1_PROPERTY_DISPLAYNAME: D2D1_PROPERTY = D2D1_PROPERTY(2147483649u32);
pub const D2D1_PROPERTY_AUTHOR: D2D1_PROPERTY = D2D1_PROPERTY(2147483650u32);
pub const D2D1_PROPERTY_CATEGORY: D2D1_PROPERTY = D2D1_PROPERTY(2147483651u32);
pub const D2D1_PROPERTY_DESCRIPTION: D2D1_PROPERTY = D2D1_PROPERTY(2147483652u32);
pub const D2D1_PROPERTY_INPUTS: D2D1_PROPERTY = D2D1_PROPERTY(2147483653u32);
pub const D2D1_PROPERTY_CACHED: D2D1_PROPERTY = D2D1_PROPERTY(2147483654u32);
pub const D2D1_PROPERTY_PRECISION: D2D1_PROPERTY = D2D1_PROPERTY(2147483655u32);
pub const D2D1_PROPERTY_MIN_INPUTS: D2D1_PROPERTY = D2D1_PROPERTY(2147483656u32);
pub const D2D1_PROPERTY_MAX_INPUTS: D2D1_PROPERTY = D2D1_PROPERTY(2147483657u32);
pub const D2D1_PROPERTY_FORCE_DWORD: D2D1_PROPERTY = D2D1_PROPERTY(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PROPERTY {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PROPERTY {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PROPERTY {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PROPERTY {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PROPERTY {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PROPERTY {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PROPERTY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_PROPERTY_BINDING {
    pub propertyName: super::super::Foundation::PWSTR,
    pub setFunction: ::std::option::Option<PD2D1_PROPERTY_SET_FUNCTION>,
    pub getFunction: ::std::option::Option<PD2D1_PROPERTY_GET_FUNCTION>,
}
#[cfg(feature = "Win32_Foundation")]
impl D2D1_PROPERTY_BINDING {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D2D1_PROPERTY_BINDING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D2D1_PROPERTY_BINDING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_PROPERTY_BINDING")
            .field("propertyName", &self.propertyName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D2D1_PROPERTY_BINDING {
    fn eq(&self, other: &Self) -> bool {
        self.propertyName == other.propertyName
            && self.setFunction.map(|f| f as usize) == other.setFunction.map(|f| f as usize)
            && self.getFunction.map(|f| f as usize) == other.getFunction.map(|f| f as usize)
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D2D1_PROPERTY_BINDING {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D2D1_PROPERTY_BINDING {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_PROPERTY_TYPE(pub u32);
pub const D2D1_PROPERTY_TYPE_UNKNOWN: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(0u32);
pub const D2D1_PROPERTY_TYPE_STRING: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(1u32);
pub const D2D1_PROPERTY_TYPE_BOOL: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(2u32);
pub const D2D1_PROPERTY_TYPE_UINT32: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(3u32);
pub const D2D1_PROPERTY_TYPE_INT32: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(4u32);
pub const D2D1_PROPERTY_TYPE_FLOAT: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(5u32);
pub const D2D1_PROPERTY_TYPE_VECTOR2: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(6u32);
pub const D2D1_PROPERTY_TYPE_VECTOR3: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(7u32);
pub const D2D1_PROPERTY_TYPE_VECTOR4: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(8u32);
pub const D2D1_PROPERTY_TYPE_BLOB: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(9u32);
pub const D2D1_PROPERTY_TYPE_IUNKNOWN: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(10u32);
pub const D2D1_PROPERTY_TYPE_ENUM: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(11u32);
pub const D2D1_PROPERTY_TYPE_ARRAY: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(12u32);
pub const D2D1_PROPERTY_TYPE_CLSID: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(13u32);
pub const D2D1_PROPERTY_TYPE_MATRIX_3X2: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(14u32);
pub const D2D1_PROPERTY_TYPE_MATRIX_4X3: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(15u32);
pub const D2D1_PROPERTY_TYPE_MATRIX_4X4: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(16u32);
pub const D2D1_PROPERTY_TYPE_MATRIX_5X4: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(17u32);
pub const D2D1_PROPERTY_TYPE_COLOR_CONTEXT: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(18u32);
pub const D2D1_PROPERTY_TYPE_FORCE_DWORD: D2D1_PROPERTY_TYPE = D2D1_PROPERTY_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_PROPERTY_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_PROPERTY_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_PROPERTY_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_PROPERTY_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_PROPERTY_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_PROPERTY_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_PROPERTY_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_QUADRATIC_BEZIER_SEGMENT {
    pub point1: D2D_POINT_2F,
    pub point2: D2D_POINT_2F,
}
impl D2D1_QUADRATIC_BEZIER_SEGMENT {}
impl ::std::default::Default for D2D1_QUADRATIC_BEZIER_SEGMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_QUADRATIC_BEZIER_SEGMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_QUADRATIC_BEZIER_SEGMENT")
            .field("point1", &self.point1)
            .field("point2", &self.point2)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_QUADRATIC_BEZIER_SEGMENT {
    fn eq(&self, other: &Self) -> bool {
        self.point1 == other.point1 && self.point2 == other.point2
    }
}
impl ::std::cmp::Eq for D2D1_QUADRATIC_BEZIER_SEGMENT {}
unsafe impl ::windows::runtime::Abi for D2D1_QUADRATIC_BEZIER_SEGMENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    pub center: D2D_POINT_2F,
    pub gradientOriginOffset: D2D_POINT_2F,
    pub radiusX: f32,
    pub radiusY: f32,
}
impl D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {}
impl ::std::default::Default for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES")
            .field("center", &self.center)
            .field("gradientOriginOffset", &self.gradientOriginOffset)
            .field("radiusX", &self.radiusX)
            .field("radiusY", &self.radiusY)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.center == other.center
            && self.gradientOriginOffset == other.gradientOriginOffset
            && self.radiusX == other.radiusX
            && self.radiusY == other.radiusY
    }
}
impl ::std::cmp::Eq for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_RENDERING_CONTROLS {
    pub bufferPrecision: D2D1_BUFFER_PRECISION,
    pub tileSize: D2D_SIZE_U,
}
impl D2D1_RENDERING_CONTROLS {}
impl ::std::default::Default for D2D1_RENDERING_CONTROLS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_RENDERING_CONTROLS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_RENDERING_CONTROLS")
            .field("bufferPrecision", &self.bufferPrecision)
            .field("tileSize", &self.tileSize)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_RENDERING_CONTROLS {
    fn eq(&self, other: &Self) -> bool {
        self.bufferPrecision == other.bufferPrecision && self.tileSize == other.tileSize
    }
}
impl ::std::cmp::Eq for D2D1_RENDERING_CONTROLS {}
unsafe impl ::windows::runtime::Abi for D2D1_RENDERING_CONTROLS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_RENDERING_PRIORITY(pub u32);
pub const D2D1_RENDERING_PRIORITY_NORMAL: D2D1_RENDERING_PRIORITY = D2D1_RENDERING_PRIORITY(0u32);
pub const D2D1_RENDERING_PRIORITY_LOW: D2D1_RENDERING_PRIORITY = D2D1_RENDERING_PRIORITY(1u32);
pub const D2D1_RENDERING_PRIORITY_FORCE_DWORD: D2D1_RENDERING_PRIORITY =
    D2D1_RENDERING_PRIORITY(4294967295u32);
impl ::std::convert::From<u32> for D2D1_RENDERING_PRIORITY {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_RENDERING_PRIORITY {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_RENDERING_PRIORITY {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_RENDERING_PRIORITY {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_RENDERING_PRIORITY {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_RENDERING_PRIORITY {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_RENDERING_PRIORITY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Dxgi")]
pub struct D2D1_RENDER_TARGET_PROPERTIES {
    pub r#type: D2D1_RENDER_TARGET_TYPE,
    pub pixelFormat: D2D1_PIXEL_FORMAT,
    pub dpiX: f32,
    pub dpiY: f32,
    pub usage: D2D1_RENDER_TARGET_USAGE,
    pub minLevel: D2D1_FEATURE_LEVEL,
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl D2D1_RENDER_TARGET_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::default::Default for D2D1_RENDER_TARGET_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::fmt::Debug for D2D1_RENDER_TARGET_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_RENDER_TARGET_PROPERTIES")
            .field("r#type", &self.r#type)
            .field("pixelFormat", &self.pixelFormat)
            .field("dpiX", &self.dpiX)
            .field("dpiY", &self.dpiY)
            .field("usage", &self.usage)
            .field("minLevel", &self.minLevel)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::PartialEq for D2D1_RENDER_TARGET_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.r#type == other.r#type
            && self.pixelFormat == other.pixelFormat
            && self.dpiX == other.dpiX
            && self.dpiY == other.dpiY
            && self.usage == other.usage
            && self.minLevel == other.minLevel
    }
}
#[cfg(feature = "Win32_Graphics_Dxgi")]
impl ::std::cmp::Eq for D2D1_RENDER_TARGET_PROPERTIES {}
#[cfg(feature = "Win32_Graphics_Dxgi")]
unsafe impl ::windows::runtime::Abi for D2D1_RENDER_TARGET_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_RENDER_TARGET_TYPE(pub u32);
pub const D2D1_RENDER_TARGET_TYPE_DEFAULT: D2D1_RENDER_TARGET_TYPE = D2D1_RENDER_TARGET_TYPE(0u32);
pub const D2D1_RENDER_TARGET_TYPE_SOFTWARE: D2D1_RENDER_TARGET_TYPE = D2D1_RENDER_TARGET_TYPE(1u32);
pub const D2D1_RENDER_TARGET_TYPE_HARDWARE: D2D1_RENDER_TARGET_TYPE = D2D1_RENDER_TARGET_TYPE(2u32);
pub const D2D1_RENDER_TARGET_TYPE_FORCE_DWORD: D2D1_RENDER_TARGET_TYPE =
    D2D1_RENDER_TARGET_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_RENDER_TARGET_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_RENDER_TARGET_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_RENDER_TARGET_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_RENDER_TARGET_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_RENDER_TARGET_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_RENDER_TARGET_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_RENDER_TARGET_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_RENDER_TARGET_USAGE(pub u32);
pub const D2D1_RENDER_TARGET_USAGE_NONE: D2D1_RENDER_TARGET_USAGE = D2D1_RENDER_TARGET_USAGE(0u32);
pub const D2D1_RENDER_TARGET_USAGE_FORCE_BITMAP_REMOTING: D2D1_RENDER_TARGET_USAGE =
    D2D1_RENDER_TARGET_USAGE(1u32);
pub const D2D1_RENDER_TARGET_USAGE_GDI_COMPATIBLE: D2D1_RENDER_TARGET_USAGE =
    D2D1_RENDER_TARGET_USAGE(2u32);
pub const D2D1_RENDER_TARGET_USAGE_FORCE_DWORD: D2D1_RENDER_TARGET_USAGE =
    D2D1_RENDER_TARGET_USAGE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_RENDER_TARGET_USAGE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_RENDER_TARGET_USAGE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_RENDER_TARGET_USAGE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_RENDER_TARGET_USAGE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_RENDER_TARGET_USAGE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_RENDER_TARGET_USAGE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_RENDER_TARGET_USAGE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_RESOURCE_TEXTURE_PROPERTIES {
    pub extents: *mut u32,
    pub dimensions: u32,
    pub bufferPrecision: D2D1_BUFFER_PRECISION,
    pub channelDepth: D2D1_CHANNEL_DEPTH,
    pub filter: D2D1_FILTER,
    pub extendModes: *mut D2D1_EXTEND_MODE,
}
impl D2D1_RESOURCE_TEXTURE_PROPERTIES {}
impl ::std::default::Default for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_RESOURCE_TEXTURE_PROPERTIES")
            .field("extents", &self.extents)
            .field("dimensions", &self.dimensions)
            .field("bufferPrecision", &self.bufferPrecision)
            .field("channelDepth", &self.channelDepth)
            .field("filter", &self.filter)
            .field("extendModes", &self.extendModes)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.extents == other.extents
            && self.dimensions == other.dimensions
            && self.bufferPrecision == other.bufferPrecision
            && self.channelDepth == other.channelDepth
            && self.filter == other.filter
            && self.extendModes == other.extendModes
    }
}
impl ::std::cmp::Eq for D2D1_RESOURCE_TEXTURE_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_RESOURCE_TEXTURE_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(pub u32);
pub const D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_VALUE: D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE =
    D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(0u32);
pub const D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_HUE_SATURATION_LIGHTNESS:
    D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE = D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(1u32);
pub const D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE_FORCE_DWORD: D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE =
    D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_RGBTOHUE_OUTPUT_COLOR_SPACE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_RGBTOHUE_PROP(pub u32);
pub const D2D1_RGBTOHUE_PROP_OUTPUT_COLOR_SPACE: D2D1_RGBTOHUE_PROP = D2D1_RGBTOHUE_PROP(0u32);
pub const D2D1_RGBTOHUE_PROP_FORCE_DWORD: D2D1_RGBTOHUE_PROP = D2D1_RGBTOHUE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_RGBTOHUE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_RGBTOHUE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_RGBTOHUE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_RGBTOHUE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_RGBTOHUE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_RGBTOHUE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_RGBTOHUE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_ROUNDED_RECT {
    pub rect: D2D_RECT_F,
    pub radiusX: f32,
    pub radiusY: f32,
}
impl D2D1_ROUNDED_RECT {}
impl ::std::default::Default for D2D1_ROUNDED_RECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_ROUNDED_RECT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_ROUNDED_RECT")
            .field("rect", &self.rect)
            .field("radiusX", &self.radiusX)
            .field("radiusY", &self.radiusY)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_ROUNDED_RECT {
    fn eq(&self, other: &Self) -> bool {
        self.rect == other.rect && self.radiusX == other.radiusX && self.radiusY == other.radiusY
    }
}
impl ::std::cmp::Eq for D2D1_ROUNDED_RECT {}
unsafe impl ::windows::runtime::Abi for D2D1_ROUNDED_RECT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SATURATION_PROP(pub u32);
pub const D2D1_SATURATION_PROP_SATURATION: D2D1_SATURATION_PROP = D2D1_SATURATION_PROP(0u32);
pub const D2D1_SATURATION_PROP_FORCE_DWORD: D2D1_SATURATION_PROP =
    D2D1_SATURATION_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SATURATION_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SATURATION_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SATURATION_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SATURATION_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SATURATION_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SATURATION_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SATURATION_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SCALE_INTERPOLATION_MODE(pub u32);
pub const D2D1_SCALE_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_SCALE_INTERPOLATION_MODE =
    D2D1_SCALE_INTERPOLATION_MODE(0u32);
pub const D2D1_SCALE_INTERPOLATION_MODE_LINEAR: D2D1_SCALE_INTERPOLATION_MODE =
    D2D1_SCALE_INTERPOLATION_MODE(1u32);
pub const D2D1_SCALE_INTERPOLATION_MODE_CUBIC: D2D1_SCALE_INTERPOLATION_MODE =
    D2D1_SCALE_INTERPOLATION_MODE(2u32);
pub const D2D1_SCALE_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_SCALE_INTERPOLATION_MODE =
    D2D1_SCALE_INTERPOLATION_MODE(3u32);
pub const D2D1_SCALE_INTERPOLATION_MODE_ANISOTROPIC: D2D1_SCALE_INTERPOLATION_MODE =
    D2D1_SCALE_INTERPOLATION_MODE(4u32);
pub const D2D1_SCALE_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: D2D1_SCALE_INTERPOLATION_MODE =
    D2D1_SCALE_INTERPOLATION_MODE(5u32);
pub const D2D1_SCALE_INTERPOLATION_MODE_FORCE_DWORD: D2D1_SCALE_INTERPOLATION_MODE =
    D2D1_SCALE_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SCALE_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SCALE_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SCALE_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SCALE_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SCALE_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SCALE_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SCALE_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SCALE_PROP(pub u32);
pub const D2D1_SCALE_PROP_SCALE: D2D1_SCALE_PROP = D2D1_SCALE_PROP(0u32);
pub const D2D1_SCALE_PROP_CENTER_POINT: D2D1_SCALE_PROP = D2D1_SCALE_PROP(1u32);
pub const D2D1_SCALE_PROP_INTERPOLATION_MODE: D2D1_SCALE_PROP = D2D1_SCALE_PROP(2u32);
pub const D2D1_SCALE_PROP_BORDER_MODE: D2D1_SCALE_PROP = D2D1_SCALE_PROP(3u32);
pub const D2D1_SCALE_PROP_SHARPNESS: D2D1_SCALE_PROP = D2D1_SCALE_PROP(4u32);
pub const D2D1_SCALE_PROP_FORCE_DWORD: D2D1_SCALE_PROP = D2D1_SCALE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SCALE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SCALE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SCALE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SCALE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SCALE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SCALE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SCALE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const D2D1_SCENE_REFERRED_SDR_WHITE_LEVEL: f32 = 80f32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SEPIA_PROP(pub u32);
pub const D2D1_SEPIA_PROP_INTENSITY: D2D1_SEPIA_PROP = D2D1_SEPIA_PROP(0u32);
pub const D2D1_SEPIA_PROP_ALPHA_MODE: D2D1_SEPIA_PROP = D2D1_SEPIA_PROP(1u32);
pub const D2D1_SEPIA_PROP_FORCE_DWORD: D2D1_SEPIA_PROP = D2D1_SEPIA_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SEPIA_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SEPIA_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SEPIA_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SEPIA_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SEPIA_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SEPIA_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SEPIA_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SHADOW_OPTIMIZATION(pub u32);
pub const D2D1_SHADOW_OPTIMIZATION_SPEED: D2D1_SHADOW_OPTIMIZATION = D2D1_SHADOW_OPTIMIZATION(0u32);
pub const D2D1_SHADOW_OPTIMIZATION_BALANCED: D2D1_SHADOW_OPTIMIZATION =
    D2D1_SHADOW_OPTIMIZATION(1u32);
pub const D2D1_SHADOW_OPTIMIZATION_QUALITY: D2D1_SHADOW_OPTIMIZATION =
    D2D1_SHADOW_OPTIMIZATION(2u32);
pub const D2D1_SHADOW_OPTIMIZATION_FORCE_DWORD: D2D1_SHADOW_OPTIMIZATION =
    D2D1_SHADOW_OPTIMIZATION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SHADOW_OPTIMIZATION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SHADOW_OPTIMIZATION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SHADOW_OPTIMIZATION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SHADOW_OPTIMIZATION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SHADOW_OPTIMIZATION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SHADOW_OPTIMIZATION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SHADOW_OPTIMIZATION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SHADOW_PROP(pub u32);
pub const D2D1_SHADOW_PROP_BLUR_STANDARD_DEVIATION: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(0u32);
pub const D2D1_SHADOW_PROP_COLOR: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(1u32);
pub const D2D1_SHADOW_PROP_OPTIMIZATION: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(2u32);
pub const D2D1_SHADOW_PROP_FORCE_DWORD: D2D1_SHADOW_PROP = D2D1_SHADOW_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SHADOW_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SHADOW_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SHADOW_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SHADOW_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SHADOW_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SHADOW_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SHADOW_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SHARPEN_PROP(pub u32);
pub const D2D1_SHARPEN_PROP_SHARPNESS: D2D1_SHARPEN_PROP = D2D1_SHARPEN_PROP(0u32);
pub const D2D1_SHARPEN_PROP_THRESHOLD: D2D1_SHARPEN_PROP = D2D1_SHARPEN_PROP(1u32);
pub const D2D1_SHARPEN_PROP_FORCE_DWORD: D2D1_SHARPEN_PROP = D2D1_SHARPEN_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SHARPEN_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SHARPEN_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SHARPEN_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SHARPEN_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SHARPEN_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SHARPEN_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SHARPEN_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_SIMPLE_COLOR_PROFILE {
    pub redPrimary: D2D_POINT_2F,
    pub greenPrimary: D2D_POINT_2F,
    pub bluePrimary: D2D_POINT_2F,
    pub whitePointXZ: D2D_POINT_2F,
    pub gamma: D2D1_GAMMA1,
}
impl D2D1_SIMPLE_COLOR_PROFILE {}
impl ::std::default::Default for D2D1_SIMPLE_COLOR_PROFILE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_SIMPLE_COLOR_PROFILE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_SIMPLE_COLOR_PROFILE")
            .field("redPrimary", &self.redPrimary)
            .field("greenPrimary", &self.greenPrimary)
            .field("bluePrimary", &self.bluePrimary)
            .field("whitePointXZ", &self.whitePointXZ)
            .field("gamma", &self.gamma)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_SIMPLE_COLOR_PROFILE {
    fn eq(&self, other: &Self) -> bool {
        self.redPrimary == other.redPrimary
            && self.greenPrimary == other.greenPrimary
            && self.bluePrimary == other.bluePrimary
            && self.whitePointXZ == other.whitePointXZ
            && self.gamma == other.gamma
    }
}
impl ::std::cmp::Eq for D2D1_SIMPLE_COLOR_PROFILE {}
unsafe impl ::windows::runtime::Abi for D2D1_SIMPLE_COLOR_PROFILE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SPOTDIFFUSE_PROP(pub u32);
pub const D2D1_SPOTDIFFUSE_PROP_LIGHT_POSITION: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(0u32);
pub const D2D1_SPOTDIFFUSE_PROP_POINTS_AT: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(1u32);
pub const D2D1_SPOTDIFFUSE_PROP_FOCUS: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(2u32);
pub const D2D1_SPOTDIFFUSE_PROP_LIMITING_CONE_ANGLE: D2D1_SPOTDIFFUSE_PROP =
    D2D1_SPOTDIFFUSE_PROP(3u32);
pub const D2D1_SPOTDIFFUSE_PROP_DIFFUSE_CONSTANT: D2D1_SPOTDIFFUSE_PROP =
    D2D1_SPOTDIFFUSE_PROP(4u32);
pub const D2D1_SPOTDIFFUSE_PROP_SURFACE_SCALE: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(5u32);
pub const D2D1_SPOTDIFFUSE_PROP_COLOR: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(6u32);
pub const D2D1_SPOTDIFFUSE_PROP_KERNEL_UNIT_LENGTH: D2D1_SPOTDIFFUSE_PROP =
    D2D1_SPOTDIFFUSE_PROP(7u32);
pub const D2D1_SPOTDIFFUSE_PROP_SCALE_MODE: D2D1_SPOTDIFFUSE_PROP = D2D1_SPOTDIFFUSE_PROP(8u32);
pub const D2D1_SPOTDIFFUSE_PROP_FORCE_DWORD: D2D1_SPOTDIFFUSE_PROP =
    D2D1_SPOTDIFFUSE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SPOTDIFFUSE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SPOTDIFFUSE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SPOTDIFFUSE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SPOTDIFFUSE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SPOTDIFFUSE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SPOTDIFFUSE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SPOTDIFFUSE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SPOTDIFFUSE_SCALE_MODE(pub u32);
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_SPOTDIFFUSE_SCALE_MODE =
    D2D1_SPOTDIFFUSE_SCALE_MODE(0u32);
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_LINEAR: D2D1_SPOTDIFFUSE_SCALE_MODE =
    D2D1_SPOTDIFFUSE_SCALE_MODE(1u32);
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_CUBIC: D2D1_SPOTDIFFUSE_SCALE_MODE =
    D2D1_SPOTDIFFUSE_SCALE_MODE(2u32);
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_SPOTDIFFUSE_SCALE_MODE =
    D2D1_SPOTDIFFUSE_SCALE_MODE(3u32);
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_ANISOTROPIC: D2D1_SPOTDIFFUSE_SCALE_MODE =
    D2D1_SPOTDIFFUSE_SCALE_MODE(4u32);
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_SPOTDIFFUSE_SCALE_MODE =
    D2D1_SPOTDIFFUSE_SCALE_MODE(5u32);
pub const D2D1_SPOTDIFFUSE_SCALE_MODE_FORCE_DWORD: D2D1_SPOTDIFFUSE_SCALE_MODE =
    D2D1_SPOTDIFFUSE_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SPOTDIFFUSE_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SPOTDIFFUSE_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SPOTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SPOTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SPOTDIFFUSE_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SPOTDIFFUSE_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SPOTDIFFUSE_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SPOTSPECULAR_PROP(pub u32);
pub const D2D1_SPOTSPECULAR_PROP_LIGHT_POSITION: D2D1_SPOTSPECULAR_PROP =
    D2D1_SPOTSPECULAR_PROP(0u32);
pub const D2D1_SPOTSPECULAR_PROP_POINTS_AT: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(1u32);
pub const D2D1_SPOTSPECULAR_PROP_FOCUS: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(2u32);
pub const D2D1_SPOTSPECULAR_PROP_LIMITING_CONE_ANGLE: D2D1_SPOTSPECULAR_PROP =
    D2D1_SPOTSPECULAR_PROP(3u32);
pub const D2D1_SPOTSPECULAR_PROP_SPECULAR_EXPONENT: D2D1_SPOTSPECULAR_PROP =
    D2D1_SPOTSPECULAR_PROP(4u32);
pub const D2D1_SPOTSPECULAR_PROP_SPECULAR_CONSTANT: D2D1_SPOTSPECULAR_PROP =
    D2D1_SPOTSPECULAR_PROP(5u32);
pub const D2D1_SPOTSPECULAR_PROP_SURFACE_SCALE: D2D1_SPOTSPECULAR_PROP =
    D2D1_SPOTSPECULAR_PROP(6u32);
pub const D2D1_SPOTSPECULAR_PROP_COLOR: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(7u32);
pub const D2D1_SPOTSPECULAR_PROP_KERNEL_UNIT_LENGTH: D2D1_SPOTSPECULAR_PROP =
    D2D1_SPOTSPECULAR_PROP(8u32);
pub const D2D1_SPOTSPECULAR_PROP_SCALE_MODE: D2D1_SPOTSPECULAR_PROP = D2D1_SPOTSPECULAR_PROP(9u32);
pub const D2D1_SPOTSPECULAR_PROP_FORCE_DWORD: D2D1_SPOTSPECULAR_PROP =
    D2D1_SPOTSPECULAR_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SPOTSPECULAR_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SPOTSPECULAR_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SPOTSPECULAR_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SPOTSPECULAR_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SPOTSPECULAR_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SPOTSPECULAR_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SPOTSPECULAR_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SPOTSPECULAR_SCALE_MODE(pub u32);
pub const D2D1_SPOTSPECULAR_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_SPOTSPECULAR_SCALE_MODE =
    D2D1_SPOTSPECULAR_SCALE_MODE(0u32);
pub const D2D1_SPOTSPECULAR_SCALE_MODE_LINEAR: D2D1_SPOTSPECULAR_SCALE_MODE =
    D2D1_SPOTSPECULAR_SCALE_MODE(1u32);
pub const D2D1_SPOTSPECULAR_SCALE_MODE_CUBIC: D2D1_SPOTSPECULAR_SCALE_MODE =
    D2D1_SPOTSPECULAR_SCALE_MODE(2u32);
pub const D2D1_SPOTSPECULAR_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_SPOTSPECULAR_SCALE_MODE =
    D2D1_SPOTSPECULAR_SCALE_MODE(3u32);
pub const D2D1_SPOTSPECULAR_SCALE_MODE_ANISOTROPIC: D2D1_SPOTSPECULAR_SCALE_MODE =
    D2D1_SPOTSPECULAR_SCALE_MODE(4u32);
pub const D2D1_SPOTSPECULAR_SCALE_MODE_HIGH_QUALITY_CUBIC: D2D1_SPOTSPECULAR_SCALE_MODE =
    D2D1_SPOTSPECULAR_SCALE_MODE(5u32);
pub const D2D1_SPOTSPECULAR_SCALE_MODE_FORCE_DWORD: D2D1_SPOTSPECULAR_SCALE_MODE =
    D2D1_SPOTSPECULAR_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SPOTSPECULAR_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SPOTSPECULAR_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SPOTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SPOTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SPOTSPECULAR_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SPOTSPECULAR_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SPOTSPECULAR_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SPRITE_OPTIONS(pub u32);
pub const D2D1_SPRITE_OPTIONS_NONE: D2D1_SPRITE_OPTIONS = D2D1_SPRITE_OPTIONS(0u32);
pub const D2D1_SPRITE_OPTIONS_CLAMP_TO_SOURCE_RECTANGLE: D2D1_SPRITE_OPTIONS =
    D2D1_SPRITE_OPTIONS(1u32);
pub const D2D1_SPRITE_OPTIONS_FORCE_DWORD: D2D1_SPRITE_OPTIONS = D2D1_SPRITE_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SPRITE_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SPRITE_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SPRITE_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SPRITE_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SPRITE_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SPRITE_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SPRITE_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_STRAIGHTEN_PROP(pub u32);
pub const D2D1_STRAIGHTEN_PROP_ANGLE: D2D1_STRAIGHTEN_PROP = D2D1_STRAIGHTEN_PROP(0u32);
pub const D2D1_STRAIGHTEN_PROP_MAINTAIN_SIZE: D2D1_STRAIGHTEN_PROP = D2D1_STRAIGHTEN_PROP(1u32);
pub const D2D1_STRAIGHTEN_PROP_SCALE_MODE: D2D1_STRAIGHTEN_PROP = D2D1_STRAIGHTEN_PROP(2u32);
pub const D2D1_STRAIGHTEN_PROP_FORCE_DWORD: D2D1_STRAIGHTEN_PROP =
    D2D1_STRAIGHTEN_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_STRAIGHTEN_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_STRAIGHTEN_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_STRAIGHTEN_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_STRAIGHTEN_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_STRAIGHTEN_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_STRAIGHTEN_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_STRAIGHTEN_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_STRAIGHTEN_SCALE_MODE(pub u32);
pub const D2D1_STRAIGHTEN_SCALE_MODE_NEAREST_NEIGHBOR: D2D1_STRAIGHTEN_SCALE_MODE =
    D2D1_STRAIGHTEN_SCALE_MODE(0u32);
pub const D2D1_STRAIGHTEN_SCALE_MODE_LINEAR: D2D1_STRAIGHTEN_SCALE_MODE =
    D2D1_STRAIGHTEN_SCALE_MODE(1u32);
pub const D2D1_STRAIGHTEN_SCALE_MODE_CUBIC: D2D1_STRAIGHTEN_SCALE_MODE =
    D2D1_STRAIGHTEN_SCALE_MODE(2u32);
pub const D2D1_STRAIGHTEN_SCALE_MODE_MULTI_SAMPLE_LINEAR: D2D1_STRAIGHTEN_SCALE_MODE =
    D2D1_STRAIGHTEN_SCALE_MODE(3u32);
pub const D2D1_STRAIGHTEN_SCALE_MODE_ANISOTROPIC: D2D1_STRAIGHTEN_SCALE_MODE =
    D2D1_STRAIGHTEN_SCALE_MODE(4u32);
pub const D2D1_STRAIGHTEN_SCALE_MODE_FORCE_DWORD: D2D1_STRAIGHTEN_SCALE_MODE =
    D2D1_STRAIGHTEN_SCALE_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_STRAIGHTEN_SCALE_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_STRAIGHTEN_SCALE_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_STRAIGHTEN_SCALE_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_STRAIGHTEN_SCALE_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_STRAIGHTEN_SCALE_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_STRAIGHTEN_SCALE_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_STRAIGHTEN_SCALE_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_STROKE_STYLE_PROPERTIES {
    pub startCap: D2D1_CAP_STYLE,
    pub endCap: D2D1_CAP_STYLE,
    pub dashCap: D2D1_CAP_STYLE,
    pub lineJoin: D2D1_LINE_JOIN,
    pub miterLimit: f32,
    pub dashStyle: D2D1_DASH_STYLE,
    pub dashOffset: f32,
}
impl D2D1_STROKE_STYLE_PROPERTIES {}
impl ::std::default::Default for D2D1_STROKE_STYLE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_STROKE_STYLE_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_STROKE_STYLE_PROPERTIES")
            .field("startCap", &self.startCap)
            .field("endCap", &self.endCap)
            .field("dashCap", &self.dashCap)
            .field("lineJoin", &self.lineJoin)
            .field("miterLimit", &self.miterLimit)
            .field("dashStyle", &self.dashStyle)
            .field("dashOffset", &self.dashOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_STROKE_STYLE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.startCap == other.startCap
            && self.endCap == other.endCap
            && self.dashCap == other.dashCap
            && self.lineJoin == other.lineJoin
            && self.miterLimit == other.miterLimit
            && self.dashStyle == other.dashStyle
            && self.dashOffset == other.dashOffset
    }
}
impl ::std::cmp::Eq for D2D1_STROKE_STYLE_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_STROKE_STYLE_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_STROKE_STYLE_PROPERTIES1 {
    pub startCap: D2D1_CAP_STYLE,
    pub endCap: D2D1_CAP_STYLE,
    pub dashCap: D2D1_CAP_STYLE,
    pub lineJoin: D2D1_LINE_JOIN,
    pub miterLimit: f32,
    pub dashStyle: D2D1_DASH_STYLE,
    pub dashOffset: f32,
    pub transformType: D2D1_STROKE_TRANSFORM_TYPE,
}
impl D2D1_STROKE_STYLE_PROPERTIES1 {}
impl ::std::default::Default for D2D1_STROKE_STYLE_PROPERTIES1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_STROKE_STYLE_PROPERTIES1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_STROKE_STYLE_PROPERTIES1")
            .field("startCap", &self.startCap)
            .field("endCap", &self.endCap)
            .field("dashCap", &self.dashCap)
            .field("lineJoin", &self.lineJoin)
            .field("miterLimit", &self.miterLimit)
            .field("dashStyle", &self.dashStyle)
            .field("dashOffset", &self.dashOffset)
            .field("transformType", &self.transformType)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_STROKE_STYLE_PROPERTIES1 {
    fn eq(&self, other: &Self) -> bool {
        self.startCap == other.startCap
            && self.endCap == other.endCap
            && self.dashCap == other.dashCap
            && self.lineJoin == other.lineJoin
            && self.miterLimit == other.miterLimit
            && self.dashStyle == other.dashStyle
            && self.dashOffset == other.dashOffset
            && self.transformType == other.transformType
    }
}
impl ::std::cmp::Eq for D2D1_STROKE_STYLE_PROPERTIES1 {}
unsafe impl ::windows::runtime::Abi for D2D1_STROKE_STYLE_PROPERTIES1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_STROKE_TRANSFORM_TYPE(pub u32);
pub const D2D1_STROKE_TRANSFORM_TYPE_NORMAL: D2D1_STROKE_TRANSFORM_TYPE =
    D2D1_STROKE_TRANSFORM_TYPE(0u32);
pub const D2D1_STROKE_TRANSFORM_TYPE_FIXED: D2D1_STROKE_TRANSFORM_TYPE =
    D2D1_STROKE_TRANSFORM_TYPE(1u32);
pub const D2D1_STROKE_TRANSFORM_TYPE_HAIRLINE: D2D1_STROKE_TRANSFORM_TYPE =
    D2D1_STROKE_TRANSFORM_TYPE(2u32);
pub const D2D1_STROKE_TRANSFORM_TYPE_FORCE_DWORD: D2D1_STROKE_TRANSFORM_TYPE =
    D2D1_STROKE_TRANSFORM_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_STROKE_TRANSFORM_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_STROKE_TRANSFORM_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_STROKE_TRANSFORM_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_STROKE_TRANSFORM_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_STROKE_TRANSFORM_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_STROKE_TRANSFORM_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_STROKE_TRANSFORM_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SUBPROPERTY(pub u32);
pub const D2D1_SUBPROPERTY_DISPLAYNAME: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483648u32);
pub const D2D1_SUBPROPERTY_ISREADONLY: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483649u32);
pub const D2D1_SUBPROPERTY_MIN: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483650u32);
pub const D2D1_SUBPROPERTY_MAX: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483651u32);
pub const D2D1_SUBPROPERTY_DEFAULT: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483652u32);
pub const D2D1_SUBPROPERTY_FIELDS: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483653u32);
pub const D2D1_SUBPROPERTY_INDEX: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(2147483654u32);
pub const D2D1_SUBPROPERTY_FORCE_DWORD: D2D1_SUBPROPERTY = D2D1_SUBPROPERTY(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SUBPROPERTY {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SUBPROPERTY {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SUBPROPERTY {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SUBPROPERTY {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SUBPROPERTY {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SUBPROPERTY {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SUBPROPERTY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_ASPECT_ALIGN(pub u32);
pub const D2D1_SVG_ASPECT_ALIGN_NONE: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(0u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MIN: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(1u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MIN: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(2u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MIN: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(3u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MID: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(4u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MID: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(5u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MID: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(6u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MIN_Y_MAX: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(7u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MID_Y_MAX: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(8u32);
pub const D2D1_SVG_ASPECT_ALIGN_X_MAX_Y_MAX: D2D1_SVG_ASPECT_ALIGN = D2D1_SVG_ASPECT_ALIGN(9u32);
pub const D2D1_SVG_ASPECT_ALIGN_FORCE_DWORD: D2D1_SVG_ASPECT_ALIGN =
    D2D1_SVG_ASPECT_ALIGN(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_ASPECT_ALIGN {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_ASPECT_ALIGN {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_ASPECT_ALIGN {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_ASPECT_ALIGN {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_ASPECT_ALIGN {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_ASPECT_ALIGN {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_ASPECT_ALIGN {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_ASPECT_SCALING(pub u32);
pub const D2D1_SVG_ASPECT_SCALING_MEET: D2D1_SVG_ASPECT_SCALING = D2D1_SVG_ASPECT_SCALING(0u32);
pub const D2D1_SVG_ASPECT_SCALING_SLICE: D2D1_SVG_ASPECT_SCALING = D2D1_SVG_ASPECT_SCALING(1u32);
pub const D2D1_SVG_ASPECT_SCALING_FORCE_DWORD: D2D1_SVG_ASPECT_SCALING =
    D2D1_SVG_ASPECT_SCALING(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_ASPECT_SCALING {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_ASPECT_SCALING {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_ASPECT_SCALING {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_ASPECT_SCALING {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_ASPECT_SCALING {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_ASPECT_SCALING {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_ASPECT_SCALING {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_ATTRIBUTE_POD_TYPE(pub u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_FLOAT: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(0u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_COLOR: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(1u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_FILL_MODE: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(2u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_DISPLAY: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(3u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_OVERFLOW: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(4u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_CAP: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(5u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_LINE_JOIN: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(6u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_VISIBILITY: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(7u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_MATRIX: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(8u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_UNIT_TYPE: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(9u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_EXTEND_MODE: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(10u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_PRESERVE_ASPECT_RATIO: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(11u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_VIEWBOX: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(12u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_LENGTH: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(13u32);
pub const D2D1_SVG_ATTRIBUTE_POD_TYPE_FORCE_DWORD: D2D1_SVG_ATTRIBUTE_POD_TYPE =
    D2D1_SVG_ATTRIBUTE_POD_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_ATTRIBUTE_POD_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_ATTRIBUTE_STRING_TYPE(pub u32);
pub const D2D1_SVG_ATTRIBUTE_STRING_TYPE_SVG: D2D1_SVG_ATTRIBUTE_STRING_TYPE =
    D2D1_SVG_ATTRIBUTE_STRING_TYPE(0u32);
pub const D2D1_SVG_ATTRIBUTE_STRING_TYPE_ID: D2D1_SVG_ATTRIBUTE_STRING_TYPE =
    D2D1_SVG_ATTRIBUTE_STRING_TYPE(1u32);
pub const D2D1_SVG_ATTRIBUTE_STRING_TYPE_FORCE_DWORD: D2D1_SVG_ATTRIBUTE_STRING_TYPE =
    D2D1_SVG_ATTRIBUTE_STRING_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_ATTRIBUTE_STRING_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_DISPLAY(pub u32);
pub const D2D1_SVG_DISPLAY_INLINE: D2D1_SVG_DISPLAY = D2D1_SVG_DISPLAY(0u32);
pub const D2D1_SVG_DISPLAY_NONE: D2D1_SVG_DISPLAY = D2D1_SVG_DISPLAY(1u32);
pub const D2D1_SVG_DISPLAY_FORCE_DWORD: D2D1_SVG_DISPLAY = D2D1_SVG_DISPLAY(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_DISPLAY {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_DISPLAY {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_DISPLAY {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_DISPLAY {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_DISPLAY {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_DISPLAY {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_DISPLAY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_SVG_LENGTH {
    pub value: f32,
    pub units: D2D1_SVG_LENGTH_UNITS,
}
impl D2D1_SVG_LENGTH {}
impl ::std::default::Default for D2D1_SVG_LENGTH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_SVG_LENGTH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_SVG_LENGTH")
            .field("value", &self.value)
            .field("units", &self.units)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_SVG_LENGTH {
    fn eq(&self, other: &Self) -> bool {
        self.value == other.value && self.units == other.units
    }
}
impl ::std::cmp::Eq for D2D1_SVG_LENGTH {}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_LENGTH {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_LENGTH_UNITS(pub u32);
pub const D2D1_SVG_LENGTH_UNITS_NUMBER: D2D1_SVG_LENGTH_UNITS = D2D1_SVG_LENGTH_UNITS(0u32);
pub const D2D1_SVG_LENGTH_UNITS_PERCENTAGE: D2D1_SVG_LENGTH_UNITS = D2D1_SVG_LENGTH_UNITS(1u32);
pub const D2D1_SVG_LENGTH_UNITS_FORCE_DWORD: D2D1_SVG_LENGTH_UNITS =
    D2D1_SVG_LENGTH_UNITS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_LENGTH_UNITS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_LENGTH_UNITS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_LENGTH_UNITS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_LENGTH_UNITS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_LENGTH_UNITS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_LENGTH_UNITS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_LENGTH_UNITS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_LINE_CAP(pub u32);
pub const D2D1_SVG_LINE_CAP_BUTT: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(0u32);
pub const D2D1_SVG_LINE_CAP_SQUARE: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(1u32);
pub const D2D1_SVG_LINE_CAP_ROUND: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(2u32);
pub const D2D1_SVG_LINE_CAP_FORCE_DWORD: D2D1_SVG_LINE_CAP = D2D1_SVG_LINE_CAP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_LINE_CAP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_LINE_CAP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_LINE_CAP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_LINE_CAP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_LINE_CAP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_LINE_CAP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_LINE_CAP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_LINE_JOIN(pub u32);
pub const D2D1_SVG_LINE_JOIN_BEVEL: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(1u32);
pub const D2D1_SVG_LINE_JOIN_MITER: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(3u32);
pub const D2D1_SVG_LINE_JOIN_ROUND: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(2u32);
pub const D2D1_SVG_LINE_JOIN_FORCE_DWORD: D2D1_SVG_LINE_JOIN = D2D1_SVG_LINE_JOIN(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_LINE_JOIN {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_LINE_JOIN {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_LINE_JOIN {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_LINE_JOIN {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_LINE_JOIN {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_LINE_JOIN {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_LINE_JOIN {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_OVERFLOW(pub u32);
pub const D2D1_SVG_OVERFLOW_VISIBLE: D2D1_SVG_OVERFLOW = D2D1_SVG_OVERFLOW(0u32);
pub const D2D1_SVG_OVERFLOW_HIDDEN: D2D1_SVG_OVERFLOW = D2D1_SVG_OVERFLOW(1u32);
pub const D2D1_SVG_OVERFLOW_FORCE_DWORD: D2D1_SVG_OVERFLOW = D2D1_SVG_OVERFLOW(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_OVERFLOW {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_OVERFLOW {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_OVERFLOW {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_OVERFLOW {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_OVERFLOW {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_OVERFLOW {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_OVERFLOW {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_PAINT_TYPE(pub u32);
pub const D2D1_SVG_PAINT_TYPE_NONE: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(0u32);
pub const D2D1_SVG_PAINT_TYPE_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(1u32);
pub const D2D1_SVG_PAINT_TYPE_CURRENT_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(2u32);
pub const D2D1_SVG_PAINT_TYPE_URI: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(3u32);
pub const D2D1_SVG_PAINT_TYPE_URI_NONE: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(4u32);
pub const D2D1_SVG_PAINT_TYPE_URI_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(5u32);
pub const D2D1_SVG_PAINT_TYPE_URI_CURRENT_COLOR: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(6u32);
pub const D2D1_SVG_PAINT_TYPE_FORCE_DWORD: D2D1_SVG_PAINT_TYPE = D2D1_SVG_PAINT_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_PAINT_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_PAINT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_PAINT_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_PAINT_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_PAINT_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_PAINT_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_PAINT_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_PATH_COMMAND(pub u32);
pub const D2D1_SVG_PATH_COMMAND_CLOSE_PATH: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(0u32);
pub const D2D1_SVG_PATH_COMMAND_MOVE_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(1u32);
pub const D2D1_SVG_PATH_COMMAND_MOVE_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(2u32);
pub const D2D1_SVG_PATH_COMMAND_LINE_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(3u32);
pub const D2D1_SVG_PATH_COMMAND_LINE_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(4u32);
pub const D2D1_SVG_PATH_COMMAND_CUBIC_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(5u32);
pub const D2D1_SVG_PATH_COMMAND_CUBIC_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(6u32);
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_ABSOLUTE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(7u32);
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_RELATIVE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(8u32);
pub const D2D1_SVG_PATH_COMMAND_ARC_ABSOLUTE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(9u32);
pub const D2D1_SVG_PATH_COMMAND_ARC_RELATIVE: D2D1_SVG_PATH_COMMAND = D2D1_SVG_PATH_COMMAND(10u32);
pub const D2D1_SVG_PATH_COMMAND_HORIZONTAL_ABSOLUTE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(11u32);
pub const D2D1_SVG_PATH_COMMAND_HORIZONTAL_RELATIVE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(12u32);
pub const D2D1_SVG_PATH_COMMAND_VERTICAL_ABSOLUTE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(13u32);
pub const D2D1_SVG_PATH_COMMAND_VERTICAL_RELATIVE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(14u32);
pub const D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_ABSOLUTE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(15u32);
pub const D2D1_SVG_PATH_COMMAND_CUBIC_SMOOTH_RELATIVE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(16u32);
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_ABSOLUTE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(17u32);
pub const D2D1_SVG_PATH_COMMAND_QUADRADIC_SMOOTH_RELATIVE: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(18u32);
pub const D2D1_SVG_PATH_COMMAND_FORCE_DWORD: D2D1_SVG_PATH_COMMAND =
    D2D1_SVG_PATH_COMMAND(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_PATH_COMMAND {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_PATH_COMMAND {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_PATH_COMMAND {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_PATH_COMMAND {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_PATH_COMMAND {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_PATH_COMMAND {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_PATH_COMMAND {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct D2D1_SVG_PRESERVE_ASPECT_RATIO {
    pub defer: super::super::Foundation::BOOL,
    pub align: D2D1_SVG_ASPECT_ALIGN,
    pub meetOrSlice: D2D1_SVG_ASPECT_SCALING,
}
#[cfg(feature = "Win32_Foundation")]
impl D2D1_SVG_PRESERVE_ASPECT_RATIO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_SVG_PRESERVE_ASPECT_RATIO")
            .field("defer", &self.defer)
            .field("align", &self.align)
            .field("meetOrSlice", &self.meetOrSlice)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    fn eq(&self, other: &Self) -> bool {
        self.defer == other.defer
            && self.align == other.align
            && self.meetOrSlice == other.meetOrSlice
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for D2D1_SVG_PRESERVE_ASPECT_RATIO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for D2D1_SVG_PRESERVE_ASPECT_RATIO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_UNIT_TYPE(pub u32);
pub const D2D1_SVG_UNIT_TYPE_USER_SPACE_ON_USE: D2D1_SVG_UNIT_TYPE = D2D1_SVG_UNIT_TYPE(0u32);
pub const D2D1_SVG_UNIT_TYPE_OBJECT_BOUNDING_BOX: D2D1_SVG_UNIT_TYPE = D2D1_SVG_UNIT_TYPE(1u32);
pub const D2D1_SVG_UNIT_TYPE_FORCE_DWORD: D2D1_SVG_UNIT_TYPE = D2D1_SVG_UNIT_TYPE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_UNIT_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_UNIT_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_UNIT_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_UNIT_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_UNIT_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_UNIT_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_UNIT_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_SVG_VIEWBOX {
    pub x: f32,
    pub y: f32,
    pub width: f32,
    pub height: f32,
}
impl D2D1_SVG_VIEWBOX {}
impl ::std::default::Default for D2D1_SVG_VIEWBOX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_SVG_VIEWBOX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_SVG_VIEWBOX")
            .field("x", &self.x)
            .field("y", &self.y)
            .field("width", &self.width)
            .field("height", &self.height)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_SVG_VIEWBOX {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x
            && self.y == other.y
            && self.width == other.width
            && self.height == other.height
    }
}
impl ::std::cmp::Eq for D2D1_SVG_VIEWBOX {}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_VIEWBOX {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SVG_VISIBILITY(pub u32);
pub const D2D1_SVG_VISIBILITY_VISIBLE: D2D1_SVG_VISIBILITY = D2D1_SVG_VISIBILITY(0u32);
pub const D2D1_SVG_VISIBILITY_HIDDEN: D2D1_SVG_VISIBILITY = D2D1_SVG_VISIBILITY(1u32);
pub const D2D1_SVG_VISIBILITY_FORCE_DWORD: D2D1_SVG_VISIBILITY = D2D1_SVG_VISIBILITY(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SVG_VISIBILITY {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SVG_VISIBILITY {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SVG_VISIBILITY {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SVG_VISIBILITY {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SVG_VISIBILITY {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SVG_VISIBILITY {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SVG_VISIBILITY {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_SWEEP_DIRECTION(pub u32);
pub const D2D1_SWEEP_DIRECTION_COUNTER_CLOCKWISE: D2D1_SWEEP_DIRECTION = D2D1_SWEEP_DIRECTION(0u32);
pub const D2D1_SWEEP_DIRECTION_CLOCKWISE: D2D1_SWEEP_DIRECTION = D2D1_SWEEP_DIRECTION(1u32);
pub const D2D1_SWEEP_DIRECTION_FORCE_DWORD: D2D1_SWEEP_DIRECTION =
    D2D1_SWEEP_DIRECTION(4294967295u32);
impl ::std::convert::From<u32> for D2D1_SWEEP_DIRECTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_SWEEP_DIRECTION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_SWEEP_DIRECTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_SWEEP_DIRECTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_SWEEP_DIRECTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_SWEEP_DIRECTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_SWEEP_DIRECTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TABLETRANSFER_PROP(pub u32);
pub const D2D1_TABLETRANSFER_PROP_RED_TABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(0u32);
pub const D2D1_TABLETRANSFER_PROP_RED_DISABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(1u32);
pub const D2D1_TABLETRANSFER_PROP_GREEN_TABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(2u32);
pub const D2D1_TABLETRANSFER_PROP_GREEN_DISABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(3u32);
pub const D2D1_TABLETRANSFER_PROP_BLUE_TABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(4u32);
pub const D2D1_TABLETRANSFER_PROP_BLUE_DISABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(5u32);
pub const D2D1_TABLETRANSFER_PROP_ALPHA_TABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(6u32);
pub const D2D1_TABLETRANSFER_PROP_ALPHA_DISABLE: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(7u32);
pub const D2D1_TABLETRANSFER_PROP_CLAMP_OUTPUT: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(8u32);
pub const D2D1_TABLETRANSFER_PROP_FORCE_DWORD: D2D1_TABLETRANSFER_PROP =
    D2D1_TABLETRANSFER_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TABLETRANSFER_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TABLETRANSFER_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TABLETRANSFER_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TABLETRANSFER_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TABLETRANSFER_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TABLETRANSFER_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TABLETRANSFER_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TEMPERATUREANDTINT_PROP(pub u32);
pub const D2D1_TEMPERATUREANDTINT_PROP_TEMPERATURE: D2D1_TEMPERATUREANDTINT_PROP =
    D2D1_TEMPERATUREANDTINT_PROP(0u32);
pub const D2D1_TEMPERATUREANDTINT_PROP_TINT: D2D1_TEMPERATUREANDTINT_PROP =
    D2D1_TEMPERATUREANDTINT_PROP(1u32);
pub const D2D1_TEMPERATUREANDTINT_PROP_FORCE_DWORD: D2D1_TEMPERATUREANDTINT_PROP =
    D2D1_TEMPERATUREANDTINT_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TEMPERATUREANDTINT_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TEMPERATUREANDTINT_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TEMPERATUREANDTINT_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TEMPERATUREANDTINT_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TEMPERATUREANDTINT_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TEMPERATUREANDTINT_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TEMPERATUREANDTINT_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TEXT_ANTIALIAS_MODE(pub u32);
pub const D2D1_TEXT_ANTIALIAS_MODE_DEFAULT: D2D1_TEXT_ANTIALIAS_MODE =
    D2D1_TEXT_ANTIALIAS_MODE(0u32);
pub const D2D1_TEXT_ANTIALIAS_MODE_CLEARTYPE: D2D1_TEXT_ANTIALIAS_MODE =
    D2D1_TEXT_ANTIALIAS_MODE(1u32);
pub const D2D1_TEXT_ANTIALIAS_MODE_GRAYSCALE: D2D1_TEXT_ANTIALIAS_MODE =
    D2D1_TEXT_ANTIALIAS_MODE(2u32);
pub const D2D1_TEXT_ANTIALIAS_MODE_ALIASED: D2D1_TEXT_ANTIALIAS_MODE =
    D2D1_TEXT_ANTIALIAS_MODE(3u32);
pub const D2D1_TEXT_ANTIALIAS_MODE_FORCE_DWORD: D2D1_TEXT_ANTIALIAS_MODE =
    D2D1_TEXT_ANTIALIAS_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TEXT_ANTIALIAS_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TEXT_ANTIALIAS_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TEXT_ANTIALIAS_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TEXT_ANTIALIAS_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TEXT_ANTIALIAS_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TEXT_ANTIALIAS_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TEXT_ANTIALIAS_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_THREADING_MODE(pub u32);
pub const D2D1_THREADING_MODE_SINGLE_THREADED: D2D1_THREADING_MODE = D2D1_THREADING_MODE(0u32);
pub const D2D1_THREADING_MODE_MULTI_THREADED: D2D1_THREADING_MODE = D2D1_THREADING_MODE(1u32);
pub const D2D1_THREADING_MODE_FORCE_DWORD: D2D1_THREADING_MODE = D2D1_THREADING_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_THREADING_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_THREADING_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_THREADING_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_THREADING_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_THREADING_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_THREADING_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_THREADING_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TILE_PROP(pub u32);
pub const D2D1_TILE_PROP_RECT: D2D1_TILE_PROP = D2D1_TILE_PROP(0u32);
pub const D2D1_TILE_PROP_FORCE_DWORD: D2D1_TILE_PROP = D2D1_TILE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TILE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TILE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TILE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TILE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TILE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TILE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TILE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TINT_PROP(pub u32);
pub const D2D1_TINT_PROP_COLOR: D2D1_TINT_PROP = D2D1_TINT_PROP(0u32);
pub const D2D1_TINT_PROP_CLAMP_OUTPUT: D2D1_TINT_PROP = D2D1_TINT_PROP(1u32);
pub const D2D1_TINT_PROP_FORCE_DWORD: D2D1_TINT_PROP = D2D1_TINT_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TINT_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TINT_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TINT_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TINT_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TINT_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TINT_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TINT_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(pub u32);
pub const D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_NONE: D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS =
    D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(0u32);
pub const D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_DISABLE_DPI_SCALE:
    D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS = D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(1u32);
pub const D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS_FORCE_DWORD: D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS =
    D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    pub orientation: D2D1_ORIENTATION,
    pub scaleX: f32,
    pub scaleY: f32,
    pub interpolationMode: D2D1_INTERPOLATION_MODE,
    pub options: D2D1_TRANSFORMED_IMAGE_SOURCE_OPTIONS,
}
impl D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {}
impl ::std::default::Default for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES")
            .field("orientation", &self.orientation)
            .field("scaleX", &self.scaleX)
            .field("scaleY", &self.scaleY)
            .field("interpolationMode", &self.interpolationMode)
            .field("options", &self.options)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.orientation == other.orientation
            && self.scaleX == other.scaleX
            && self.scaleY == other.scaleY
            && self.interpolationMode == other.interpolationMode
            && self.options == other.options
    }
}
impl ::std::cmp::Eq for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_TRANSFORMED_IMAGE_SOURCE_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_TRIANGLE {
    pub point1: D2D_POINT_2F,
    pub point2: D2D_POINT_2F,
    pub point3: D2D_POINT_2F,
}
impl D2D1_TRIANGLE {}
impl ::std::default::Default for D2D1_TRIANGLE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_TRIANGLE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_TRIANGLE")
            .field("point1", &self.point1)
            .field("point2", &self.point2)
            .field("point3", &self.point3)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_TRIANGLE {
    fn eq(&self, other: &Self) -> bool {
        self.point1 == other.point1 && self.point2 == other.point2 && self.point3 == other.point3
    }
}
impl ::std::cmp::Eq for D2D1_TRIANGLE {}
unsafe impl ::windows::runtime::Abi for D2D1_TRIANGLE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TURBULENCE_NOISE(pub u32);
pub const D2D1_TURBULENCE_NOISE_FRACTAL_SUM: D2D1_TURBULENCE_NOISE = D2D1_TURBULENCE_NOISE(0u32);
pub const D2D1_TURBULENCE_NOISE_TURBULENCE: D2D1_TURBULENCE_NOISE = D2D1_TURBULENCE_NOISE(1u32);
pub const D2D1_TURBULENCE_NOISE_FORCE_DWORD: D2D1_TURBULENCE_NOISE =
    D2D1_TURBULENCE_NOISE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TURBULENCE_NOISE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TURBULENCE_NOISE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TURBULENCE_NOISE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TURBULENCE_NOISE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TURBULENCE_NOISE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TURBULENCE_NOISE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TURBULENCE_NOISE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_TURBULENCE_PROP(pub u32);
pub const D2D1_TURBULENCE_PROP_OFFSET: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(0u32);
pub const D2D1_TURBULENCE_PROP_SIZE: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(1u32);
pub const D2D1_TURBULENCE_PROP_BASE_FREQUENCY: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(2u32);
pub const D2D1_TURBULENCE_PROP_NUM_OCTAVES: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(3u32);
pub const D2D1_TURBULENCE_PROP_SEED: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(4u32);
pub const D2D1_TURBULENCE_PROP_NOISE: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(5u32);
pub const D2D1_TURBULENCE_PROP_STITCHABLE: D2D1_TURBULENCE_PROP = D2D1_TURBULENCE_PROP(6u32);
pub const D2D1_TURBULENCE_PROP_FORCE_DWORD: D2D1_TURBULENCE_PROP =
    D2D1_TURBULENCE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_TURBULENCE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_TURBULENCE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_TURBULENCE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_TURBULENCE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_TURBULENCE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_TURBULENCE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_TURBULENCE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_UNIT_MODE(pub u32);
pub const D2D1_UNIT_MODE_DIPS: D2D1_UNIT_MODE = D2D1_UNIT_MODE(0u32);
pub const D2D1_UNIT_MODE_PIXELS: D2D1_UNIT_MODE = D2D1_UNIT_MODE(1u32);
pub const D2D1_UNIT_MODE_FORCE_DWORD: D2D1_UNIT_MODE = D2D1_UNIT_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_UNIT_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_UNIT_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_UNIT_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_UNIT_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_UNIT_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_UNIT_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_UNIT_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_VERTEX_BUFFER_PROPERTIES {
    pub inputCount: u32,
    pub usage: D2D1_VERTEX_USAGE,
    pub data: *mut u8,
    pub byteWidth: u32,
}
impl D2D1_VERTEX_BUFFER_PROPERTIES {}
impl ::std::default::Default for D2D1_VERTEX_BUFFER_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_VERTEX_BUFFER_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_VERTEX_BUFFER_PROPERTIES")
            .field("inputCount", &self.inputCount)
            .field("usage", &self.usage)
            .field("data", &self.data)
            .field("byteWidth", &self.byteWidth)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_VERTEX_BUFFER_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.inputCount == other.inputCount
            && self.usage == other.usage
            && self.data == other.data
            && self.byteWidth == other.byteWidth
    }
}
impl ::std::cmp::Eq for D2D1_VERTEX_BUFFER_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for D2D1_VERTEX_BUFFER_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_VERTEX_OPTIONS(pub u32);
pub const D2D1_VERTEX_OPTIONS_NONE: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(0u32);
pub const D2D1_VERTEX_OPTIONS_DO_NOT_CLEAR: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(1u32);
pub const D2D1_VERTEX_OPTIONS_USE_DEPTH_BUFFER: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(2u32);
pub const D2D1_VERTEX_OPTIONS_ASSUME_NO_OVERLAP: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(4u32);
pub const D2D1_VERTEX_OPTIONS_FORCE_DWORD: D2D1_VERTEX_OPTIONS = D2D1_VERTEX_OPTIONS(4294967295u32);
impl ::std::convert::From<u32> for D2D1_VERTEX_OPTIONS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_VERTEX_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_VERTEX_OPTIONS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_VERTEX_OPTIONS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_VERTEX_OPTIONS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_VERTEX_OPTIONS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_VERTEX_OPTIONS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D1_VERTEX_RANGE {
    pub startVertex: u32,
    pub vertexCount: u32,
}
impl D2D1_VERTEX_RANGE {}
impl ::std::default::Default for D2D1_VERTEX_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D1_VERTEX_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D1_VERTEX_RANGE")
            .field("startVertex", &self.startVertex)
            .field("vertexCount", &self.vertexCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D1_VERTEX_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.startVertex == other.startVertex && self.vertexCount == other.vertexCount
    }
}
impl ::std::cmp::Eq for D2D1_VERTEX_RANGE {}
unsafe impl ::windows::runtime::Abi for D2D1_VERTEX_RANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_VERTEX_USAGE(pub u32);
pub const D2D1_VERTEX_USAGE_STATIC: D2D1_VERTEX_USAGE = D2D1_VERTEX_USAGE(0u32);
pub const D2D1_VERTEX_USAGE_DYNAMIC: D2D1_VERTEX_USAGE = D2D1_VERTEX_USAGE(1u32);
pub const D2D1_VERTEX_USAGE_FORCE_DWORD: D2D1_VERTEX_USAGE = D2D1_VERTEX_USAGE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_VERTEX_USAGE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_VERTEX_USAGE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_VERTEX_USAGE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_VERTEX_USAGE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_VERTEX_USAGE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_VERTEX_USAGE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_VERTEX_USAGE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_VIGNETTE_PROP(pub u32);
pub const D2D1_VIGNETTE_PROP_COLOR: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(0u32);
pub const D2D1_VIGNETTE_PROP_TRANSITION_SIZE: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(1u32);
pub const D2D1_VIGNETTE_PROP_STRENGTH: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(2u32);
pub const D2D1_VIGNETTE_PROP_FORCE_DWORD: D2D1_VIGNETTE_PROP = D2D1_VIGNETTE_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_VIGNETTE_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_VIGNETTE_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_VIGNETTE_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_VIGNETTE_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_VIGNETTE_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_VIGNETTE_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_VIGNETTE_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_WHITELEVELADJUSTMENT_PROP(pub u32);
pub const D2D1_WHITELEVELADJUSTMENT_PROP_INPUT_WHITE_LEVEL: D2D1_WHITELEVELADJUSTMENT_PROP =
    D2D1_WHITELEVELADJUSTMENT_PROP(0u32);
pub const D2D1_WHITELEVELADJUSTMENT_PROP_OUTPUT_WHITE_LEVEL: D2D1_WHITELEVELADJUSTMENT_PROP =
    D2D1_WHITELEVELADJUSTMENT_PROP(1u32);
pub const D2D1_WHITELEVELADJUSTMENT_PROP_FORCE_DWORD: D2D1_WHITELEVELADJUSTMENT_PROP =
    D2D1_WHITELEVELADJUSTMENT_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_WHITELEVELADJUSTMENT_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_WHITELEVELADJUSTMENT_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_WHITELEVELADJUSTMENT_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_WHITELEVELADJUSTMENT_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_WHITELEVELADJUSTMENT_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_WHITELEVELADJUSTMENT_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_WHITELEVELADJUSTMENT_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_WINDOW_STATE(pub u32);
pub const D2D1_WINDOW_STATE_NONE: D2D1_WINDOW_STATE = D2D1_WINDOW_STATE(0u32);
pub const D2D1_WINDOW_STATE_OCCLUDED: D2D1_WINDOW_STATE = D2D1_WINDOW_STATE(1u32);
pub const D2D1_WINDOW_STATE_FORCE_DWORD: D2D1_WINDOW_STATE = D2D1_WINDOW_STATE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_WINDOW_STATE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_WINDOW_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_WINDOW_STATE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_WINDOW_STATE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_WINDOW_STATE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_WINDOW_STATE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_WINDOW_STATE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_YCBCR_CHROMA_SUBSAMPLING(pub u32);
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_AUTO: D2D1_YCBCR_CHROMA_SUBSAMPLING =
    D2D1_YCBCR_CHROMA_SUBSAMPLING(0u32);
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_420: D2D1_YCBCR_CHROMA_SUBSAMPLING =
    D2D1_YCBCR_CHROMA_SUBSAMPLING(1u32);
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_422: D2D1_YCBCR_CHROMA_SUBSAMPLING =
    D2D1_YCBCR_CHROMA_SUBSAMPLING(2u32);
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_444: D2D1_YCBCR_CHROMA_SUBSAMPLING =
    D2D1_YCBCR_CHROMA_SUBSAMPLING(3u32);
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_440: D2D1_YCBCR_CHROMA_SUBSAMPLING =
    D2D1_YCBCR_CHROMA_SUBSAMPLING(4u32);
pub const D2D1_YCBCR_CHROMA_SUBSAMPLING_FORCE_DWORD: D2D1_YCBCR_CHROMA_SUBSAMPLING =
    D2D1_YCBCR_CHROMA_SUBSAMPLING(4294967295u32);
impl ::std::convert::From<u32> for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_YCBCR_CHROMA_SUBSAMPLING {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_YCBCR_INTERPOLATION_MODE(pub u32);
pub const D2D1_YCBCR_INTERPOLATION_MODE_NEAREST_NEIGHBOR: D2D1_YCBCR_INTERPOLATION_MODE =
    D2D1_YCBCR_INTERPOLATION_MODE(0u32);
pub const D2D1_YCBCR_INTERPOLATION_MODE_LINEAR: D2D1_YCBCR_INTERPOLATION_MODE =
    D2D1_YCBCR_INTERPOLATION_MODE(1u32);
pub const D2D1_YCBCR_INTERPOLATION_MODE_CUBIC: D2D1_YCBCR_INTERPOLATION_MODE =
    D2D1_YCBCR_INTERPOLATION_MODE(2u32);
pub const D2D1_YCBCR_INTERPOLATION_MODE_MULTI_SAMPLE_LINEAR: D2D1_YCBCR_INTERPOLATION_MODE =
    D2D1_YCBCR_INTERPOLATION_MODE(3u32);
pub const D2D1_YCBCR_INTERPOLATION_MODE_ANISOTROPIC: D2D1_YCBCR_INTERPOLATION_MODE =
    D2D1_YCBCR_INTERPOLATION_MODE(4u32);
pub const D2D1_YCBCR_INTERPOLATION_MODE_HIGH_QUALITY_CUBIC: D2D1_YCBCR_INTERPOLATION_MODE =
    D2D1_YCBCR_INTERPOLATION_MODE(5u32);
pub const D2D1_YCBCR_INTERPOLATION_MODE_FORCE_DWORD: D2D1_YCBCR_INTERPOLATION_MODE =
    D2D1_YCBCR_INTERPOLATION_MODE(4294967295u32);
impl ::std::convert::From<u32> for D2D1_YCBCR_INTERPOLATION_MODE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_YCBCR_INTERPOLATION_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_YCBCR_INTERPOLATION_MODE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_YCBCR_INTERPOLATION_MODE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_YCBCR_INTERPOLATION_MODE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_YCBCR_INTERPOLATION_MODE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_YCBCR_INTERPOLATION_MODE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct D2D1_YCBCR_PROP(pub u32);
pub const D2D1_YCBCR_PROP_CHROMA_SUBSAMPLING: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(0u32);
pub const D2D1_YCBCR_PROP_TRANSFORM_MATRIX: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(1u32);
pub const D2D1_YCBCR_PROP_INTERPOLATION_MODE: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(2u32);
pub const D2D1_YCBCR_PROP_FORCE_DWORD: D2D1_YCBCR_PROP = D2D1_YCBCR_PROP(4294967295u32);
impl ::std::convert::From<u32> for D2D1_YCBCR_PROP {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for D2D1_YCBCR_PROP {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for D2D1_YCBCR_PROP {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for D2D1_YCBCR_PROP {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for D2D1_YCBCR_PROP {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for D2D1_YCBCR_PROP {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for D2D1_YCBCR_PROP {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_COLOR_F {
    pub r: f32,
    pub g: f32,
    pub b: f32,
    pub a: f32,
}
impl D2D_COLOR_F {}
impl ::std::default::Default for D2D_COLOR_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_COLOR_F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_COLOR_F")
            .field("r", &self.r)
            .field("g", &self.g)
            .field("b", &self.b)
            .field("a", &self.a)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_COLOR_F {
    fn eq(&self, other: &Self) -> bool {
        self.r == other.r && self.g == other.g && self.b == other.b && self.a == other.a
    }
}
impl ::std::cmp::Eq for D2D_COLOR_F {}
unsafe impl ::windows::runtime::Abi for D2D_COLOR_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_3X2_F {
    pub Anonymous: D2D_MATRIX_3X2_F_0,
}
impl D2D_MATRIX_3X2_F {}
impl ::std::default::Default for D2D_MATRIX_3X2_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_3X2_F {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_3X2_F {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_3X2_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D2D_MATRIX_3X2_F_0 {
    pub Anonymous1: D2D_MATRIX_3X2_F_0_0,
    pub Anonymous2: D2D_MATRIX_3X2_F_0_1,
    pub m: [f32; 6],
}
impl D2D_MATRIX_3X2_F_0 {}
impl ::std::default::Default for D2D_MATRIX_3X2_F_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_3X2_F_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_3X2_F_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_3X2_F_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_3X2_F_0_0 {
    pub m11: f32,
    pub m12: f32,
    pub m21: f32,
    pub m22: f32,
    pub dx: f32,
    pub dy: f32,
}
impl D2D_MATRIX_3X2_F_0_0 {}
impl ::std::default::Default for D2D_MATRIX_3X2_F_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_MATRIX_3X2_F_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous1_e__Struct")
            .field("m11", &self.m11)
            .field("m12", &self.m12)
            .field("m21", &self.m21)
            .field("m22", &self.m22)
            .field("dx", &self.dx)
            .field("dy", &self.dy)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_3X2_F_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self.m11 == other.m11
            && self.m12 == other.m12
            && self.m21 == other.m21
            && self.m22 == other.m22
            && self.dx == other.dx
            && self.dy == other.dy
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_3X2_F_0_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_3X2_F_0_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_3X2_F_0_1 {
    pub _11: f32,
    pub _12: f32,
    pub _21: f32,
    pub _22: f32,
    pub _31: f32,
    pub _32: f32,
}
impl D2D_MATRIX_3X2_F_0_1 {}
impl ::std::default::Default for D2D_MATRIX_3X2_F_0_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_MATRIX_3X2_F_0_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous2_e__Struct")
            .field("_11", &self._11)
            .field("_12", &self._12)
            .field("_21", &self._21)
            .field("_22", &self._22)
            .field("_31", &self._31)
            .field("_32", &self._32)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_3X2_F_0_1 {
    fn eq(&self, other: &Self) -> bool {
        self._11 == other._11
            && self._12 == other._12
            && self._21 == other._21
            && self._22 == other._22
            && self._31 == other._31
            && self._32 == other._32
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_3X2_F_0_1 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_3X2_F_0_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_4X3_F {
    pub Anonymous: D2D_MATRIX_4X3_F_0,
}
impl D2D_MATRIX_4X3_F {}
impl ::std::default::Default for D2D_MATRIX_4X3_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_4X3_F {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_4X3_F {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_4X3_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D2D_MATRIX_4X3_F_0 {
    pub Anonymous: D2D_MATRIX_4X3_F_0_0,
    pub m: [f32; 12],
}
impl D2D_MATRIX_4X3_F_0 {}
impl ::std::default::Default for D2D_MATRIX_4X3_F_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_4X3_F_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_4X3_F_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_4X3_F_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_4X3_F_0_0 {
    pub _11: f32,
    pub _12: f32,
    pub _13: f32,
    pub _21: f32,
    pub _22: f32,
    pub _23: f32,
    pub _31: f32,
    pub _32: f32,
    pub _33: f32,
    pub _41: f32,
    pub _42: f32,
    pub _43: f32,
}
impl D2D_MATRIX_4X3_F_0_0 {}
impl ::std::default::Default for D2D_MATRIX_4X3_F_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_MATRIX_4X3_F_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("_11", &self._11)
            .field("_12", &self._12)
            .field("_13", &self._13)
            .field("_21", &self._21)
            .field("_22", &self._22)
            .field("_23", &self._23)
            .field("_31", &self._31)
            .field("_32", &self._32)
            .field("_33", &self._33)
            .field("_41", &self._41)
            .field("_42", &self._42)
            .field("_43", &self._43)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_4X3_F_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._11 == other._11
            && self._12 == other._12
            && self._13 == other._13
            && self._21 == other._21
            && self._22 == other._22
            && self._23 == other._23
            && self._31 == other._31
            && self._32 == other._32
            && self._33 == other._33
            && self._41 == other._41
            && self._42 == other._42
            && self._43 == other._43
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_4X3_F_0_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_4X3_F_0_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_4X4_F {
    pub Anonymous: D2D_MATRIX_4X4_F_0,
}
impl D2D_MATRIX_4X4_F {}
impl ::std::default::Default for D2D_MATRIX_4X4_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_4X4_F {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_4X4_F {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_4X4_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D2D_MATRIX_4X4_F_0 {
    pub Anonymous: D2D_MATRIX_4X4_F_0_0,
    pub m: [f32; 16],
}
impl D2D_MATRIX_4X4_F_0 {}
impl ::std::default::Default for D2D_MATRIX_4X4_F_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_4X4_F_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_4X4_F_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_4X4_F_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_4X4_F_0_0 {
    pub _11: f32,
    pub _12: f32,
    pub _13: f32,
    pub _14: f32,
    pub _21: f32,
    pub _22: f32,
    pub _23: f32,
    pub _24: f32,
    pub _31: f32,
    pub _32: f32,
    pub _33: f32,
    pub _34: f32,
    pub _41: f32,
    pub _42: f32,
    pub _43: f32,
    pub _44: f32,
}
impl D2D_MATRIX_4X4_F_0_0 {}
impl ::std::default::Default for D2D_MATRIX_4X4_F_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_MATRIX_4X4_F_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("_11", &self._11)
            .field("_12", &self._12)
            .field("_13", &self._13)
            .field("_14", &self._14)
            .field("_21", &self._21)
            .field("_22", &self._22)
            .field("_23", &self._23)
            .field("_24", &self._24)
            .field("_31", &self._31)
            .field("_32", &self._32)
            .field("_33", &self._33)
            .field("_34", &self._34)
            .field("_41", &self._41)
            .field("_42", &self._42)
            .field("_43", &self._43)
            .field("_44", &self._44)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_4X4_F_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._11 == other._11
            && self._12 == other._12
            && self._13 == other._13
            && self._14 == other._14
            && self._21 == other._21
            && self._22 == other._22
            && self._23 == other._23
            && self._24 == other._24
            && self._31 == other._31
            && self._32 == other._32
            && self._33 == other._33
            && self._34 == other._34
            && self._41 == other._41
            && self._42 == other._42
            && self._43 == other._43
            && self._44 == other._44
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_4X4_F_0_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_4X4_F_0_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_5X4_F {
    pub Anonymous: D2D_MATRIX_5X4_F_0,
}
impl D2D_MATRIX_5X4_F {}
impl ::std::default::Default for D2D_MATRIX_5X4_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_5X4_F {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_5X4_F {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_5X4_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union D2D_MATRIX_5X4_F_0 {
    pub Anonymous: D2D_MATRIX_5X4_F_0_0,
    pub m: [f32; 20],
}
impl D2D_MATRIX_5X4_F_0 {}
impl ::std::default::Default for D2D_MATRIX_5X4_F_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_5X4_F_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_5X4_F_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_5X4_F_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_MATRIX_5X4_F_0_0 {
    pub _11: f32,
    pub _12: f32,
    pub _13: f32,
    pub _14: f32,
    pub _21: f32,
    pub _22: f32,
    pub _23: f32,
    pub _24: f32,
    pub _31: f32,
    pub _32: f32,
    pub _33: f32,
    pub _34: f32,
    pub _41: f32,
    pub _42: f32,
    pub _43: f32,
    pub _44: f32,
    pub _51: f32,
    pub _52: f32,
    pub _53: f32,
    pub _54: f32,
}
impl D2D_MATRIX_5X4_F_0_0 {}
impl ::std::default::Default for D2D_MATRIX_5X4_F_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_MATRIX_5X4_F_0_0 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("_Anonymous_e__Struct")
            .field("_11", &self._11)
            .field("_12", &self._12)
            .field("_13", &self._13)
            .field("_14", &self._14)
            .field("_21", &self._21)
            .field("_22", &self._22)
            .field("_23", &self._23)
            .field("_24", &self._24)
            .field("_31", &self._31)
            .field("_32", &self._32)
            .field("_33", &self._33)
            .field("_34", &self._34)
            .field("_41", &self._41)
            .field("_42", &self._42)
            .field("_43", &self._43)
            .field("_44", &self._44)
            .field("_51", &self._51)
            .field("_52", &self._52)
            .field("_53", &self._53)
            .field("_54", &self._54)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_MATRIX_5X4_F_0_0 {
    fn eq(&self, other: &Self) -> bool {
        self._11 == other._11
            && self._12 == other._12
            && self._13 == other._13
            && self._14 == other._14
            && self._21 == other._21
            && self._22 == other._22
            && self._23 == other._23
            && self._24 == other._24
            && self._31 == other._31
            && self._32 == other._32
            && self._33 == other._33
            && self._34 == other._34
            && self._41 == other._41
            && self._42 == other._42
            && self._43 == other._43
            && self._44 == other._44
            && self._51 == other._51
            && self._52 == other._52
            && self._53 == other._53
            && self._54 == other._54
    }
}
impl ::std::cmp::Eq for D2D_MATRIX_5X4_F_0_0 {}
unsafe impl ::windows::runtime::Abi for D2D_MATRIX_5X4_F_0_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_POINT_2F {
    pub x: f32,
    pub y: f32,
}
impl D2D_POINT_2F {}
impl ::std::default::Default for D2D_POINT_2F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_POINT_2F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_POINT_2F")
            .field("x", &self.x)
            .field("y", &self.y)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_POINT_2F {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y
    }
}
impl ::std::cmp::Eq for D2D_POINT_2F {}
unsafe impl ::windows::runtime::Abi for D2D_POINT_2F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_POINT_2U {
    pub x: u32,
    pub y: u32,
}
impl D2D_POINT_2U {}
impl ::std::default::Default for D2D_POINT_2U {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_POINT_2U {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_POINT_2U")
            .field("x", &self.x)
            .field("y", &self.y)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_POINT_2U {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y
    }
}
impl ::std::cmp::Eq for D2D_POINT_2U {}
unsafe impl ::windows::runtime::Abi for D2D_POINT_2U {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_RECT_F {
    pub left: f32,
    pub top: f32,
    pub right: f32,
    pub bottom: f32,
}
impl D2D_RECT_F {}
impl ::std::default::Default for D2D_RECT_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_RECT_F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_RECT_F")
            .field("left", &self.left)
            .field("top", &self.top)
            .field("right", &self.right)
            .field("bottom", &self.bottom)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_RECT_F {
    fn eq(&self, other: &Self) -> bool {
        self.left == other.left
            && self.top == other.top
            && self.right == other.right
            && self.bottom == other.bottom
    }
}
impl ::std::cmp::Eq for D2D_RECT_F {}
unsafe impl ::windows::runtime::Abi for D2D_RECT_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_RECT_U {
    pub left: u32,
    pub top: u32,
    pub right: u32,
    pub bottom: u32,
}
impl D2D_RECT_U {}
impl ::std::default::Default for D2D_RECT_U {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_RECT_U {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_RECT_U")
            .field("left", &self.left)
            .field("top", &self.top)
            .field("right", &self.right)
            .field("bottom", &self.bottom)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_RECT_U {
    fn eq(&self, other: &Self) -> bool {
        self.left == other.left
            && self.top == other.top
            && self.right == other.right
            && self.bottom == other.bottom
    }
}
impl ::std::cmp::Eq for D2D_RECT_U {}
unsafe impl ::windows::runtime::Abi for D2D_RECT_U {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_SIZE_F {
    pub width: f32,
    pub height: f32,
}
impl D2D_SIZE_F {}
impl ::std::default::Default for D2D_SIZE_F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_SIZE_F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_SIZE_F")
            .field("width", &self.width)
            .field("height", &self.height)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_SIZE_F {
    fn eq(&self, other: &Self) -> bool {
        self.width == other.width && self.height == other.height
    }
}
impl ::std::cmp::Eq for D2D_SIZE_F {}
unsafe impl ::windows::runtime::Abi for D2D_SIZE_F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_SIZE_U {
    pub width: u32,
    pub height: u32,
}
impl D2D_SIZE_U {}
impl ::std::default::Default for D2D_SIZE_U {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_SIZE_U {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_SIZE_U")
            .field("width", &self.width)
            .field("height", &self.height)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_SIZE_U {
    fn eq(&self, other: &Self) -> bool {
        self.width == other.width && self.height == other.height
    }
}
impl ::std::cmp::Eq for D2D_SIZE_U {}
unsafe impl ::windows::runtime::Abi for D2D_SIZE_U {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_VECTOR_2F {
    pub x: f32,
    pub y: f32,
}
impl D2D_VECTOR_2F {}
impl ::std::default::Default for D2D_VECTOR_2F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_VECTOR_2F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_VECTOR_2F")
            .field("x", &self.x)
            .field("y", &self.y)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_VECTOR_2F {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y
    }
}
impl ::std::cmp::Eq for D2D_VECTOR_2F {}
unsafe impl ::windows::runtime::Abi for D2D_VECTOR_2F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_VECTOR_3F {
    pub x: f32,
    pub y: f32,
    pub z: f32,
}
impl D2D_VECTOR_3F {}
impl ::std::default::Default for D2D_VECTOR_3F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_VECTOR_3F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_VECTOR_3F")
            .field("x", &self.x)
            .field("y", &self.y)
            .field("z", &self.z)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_VECTOR_3F {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y && self.z == other.z
    }
}
impl ::std::cmp::Eq for D2D_VECTOR_3F {}
unsafe impl ::windows::runtime::Abi for D2D_VECTOR_3F {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct D2D_VECTOR_4F {
    pub x: f32,
    pub y: f32,
    pub z: f32,
    pub w: f32,
}
impl D2D_VECTOR_4F {}
impl ::std::default::Default for D2D_VECTOR_4F {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for D2D_VECTOR_4F {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("D2D_VECTOR_4F")
            .field("x", &self.x)
            .field("y", &self.y)
            .field("z", &self.z)
            .field("w", &self.w)
            .finish()
    }
}
impl ::std::cmp::PartialEq for D2D_VECTOR_4F {
    fn eq(&self, other: &Self) -> bool {
        self.x == other.x && self.y == other.y && self.z == other.z && self.w == other.w
    }
}
impl ::std::cmp::Eq for D2D_VECTOR_4F {}
unsafe impl ::windows::runtime::Abi for D2D_VECTOR_4F {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FACILITY_D2D: u32 = 2201u32;
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1AnalysisTransform(::windows::runtime::IUnknown);
impl ID2D1AnalysisTransform {
    pub unsafe fn ProcessAnalysisResults(
        &self,
        analysisdata: *const u8,
        analysisdatacount: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(analysisdata),
            ::std::mem::transmute(analysisdatacount),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1AnalysisTransform {
    type Vtable = ID2D1AnalysisTransform_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        56220720,
        38374,
        17768,
        [144, 85, 39, 114, 13, 19, 14, 147],
    );
}
impl ::std::convert::From<ID2D1AnalysisTransform> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1AnalysisTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1AnalysisTransform> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1AnalysisTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ID2D1AnalysisTransform
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID2D1AnalysisTransform
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1AnalysisTransform_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        analysisdata: *const u8,
        analysisdatacount: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Bitmap(::windows::runtime::IUnknown);
impl ID2D1Bitmap {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn GetSize(&self) -> D2D_SIZE_F {
        let mut result__: D2D_SIZE_F = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetPixelSize(&self) -> D2D_SIZE_U {
        let mut result__: D2D_SIZE_U = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetPixelFormat(&self) -> D2D1_PIXEL_FORMAT {
        let mut result__: D2D1_PIXEL_FORMAT = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn CopyFromBitmap<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        destpoint: *const D2D_POINT_2U,
        bitmap: Param1,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(destpoint),
            bitmap.into_param().abi(),
            ::std::mem::transmute(srcrect),
        )
        .ok()
    }
    pub unsafe fn CopyFromRenderTarget<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1RenderTarget>,
    >(
        &self,
        destpoint: *const D2D_POINT_2U,
        rendertarget: Param1,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(destpoint),
            rendertarget.into_param().abi(),
            ::std::mem::transmute(srcrect),
        )
        .ok()
    }
    pub unsafe fn CopyFromMemory(
        &self,
        dstrect: *const D2D_RECT_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dstrect),
            ::std::mem::transmute(srcdata),
            ::std::mem::transmute(pitch),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Bitmap {
    type Vtable = ID2D1Bitmap_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2720620631,
        59970,
        16537,
        [152, 59, 83, 159, 182, 80, 84, 38],
    );
}
impl ::std::convert::From<ID2D1Bitmap> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Bitmap) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Bitmap> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Bitmap) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Bitmap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Bitmap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Bitmap> for ID2D1Image {
    fn from(value: ID2D1Bitmap) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Bitmap> for ID2D1Image {
    fn from(value: &ID2D1Bitmap) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Image> for ID2D1Bitmap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Image> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Image>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Image> for &ID2D1Bitmap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Image> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Image>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Bitmap> for ID2D1Resource {
    fn from(value: ID2D1Bitmap) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Bitmap> for ID2D1Resource {
    fn from(value: &ID2D1Bitmap) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Bitmap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Bitmap {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Bitmap_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_U),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        result__: *mut D2D1_PIXEL_FORMAT,
    ),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: *mut f32, dpiy: *mut f32),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        destpoint: *const D2D_POINT_2U,
        bitmap: ::windows::runtime::RawPtr,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        destpoint: *const D2D_POINT_2U,
        rendertarget: ::windows::runtime::RawPtr,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dstrect: *const D2D_RECT_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Bitmap1(::windows::runtime::IUnknown);
impl ID2D1Bitmap1 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn GetSize(&self) -> D2D_SIZE_F {
        let mut result__: D2D_SIZE_F = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetPixelSize(&self) -> D2D_SIZE_U {
        let mut result__: D2D_SIZE_U = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetPixelFormat(&self) -> D2D1_PIXEL_FORMAT {
        let mut result__: D2D1_PIXEL_FORMAT = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn CopyFromBitmap<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        destpoint: *const D2D_POINT_2U,
        bitmap: Param1,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(destpoint),
            bitmap.into_param().abi(),
            ::std::mem::transmute(srcrect),
        )
        .ok()
    }
    pub unsafe fn CopyFromRenderTarget<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1RenderTarget>,
    >(
        &self,
        destpoint: *const D2D_POINT_2U,
        rendertarget: Param1,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(destpoint),
            rendertarget.into_param().abi(),
            ::std::mem::transmute(srcrect),
        )
        .ok()
    }
    pub unsafe fn CopyFromMemory(
        &self,
        dstrect: *const D2D_RECT_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dstrect),
            ::std::mem::transmute(srcdata),
            ::std::mem::transmute(pitch),
        )
        .ok()
    }
    pub unsafe fn GetColorContext(
        &self,
        colorcontext: *mut ::std::option::Option<ID2D1ColorContext>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(colorcontext),
        ))
    }
    pub unsafe fn GetOptions(&self) -> D2D1_BITMAP_OPTIONS {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetSurface(&self) -> ::windows::runtime::Result<super::Dxgi::IDXGISurface> {
        let mut result__: <super::Dxgi::IDXGISurface as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Dxgi::IDXGISurface>(result__)
    }
    pub unsafe fn Map(
        &self,
        options: D2D1_MAP_OPTIONS,
    ) -> ::windows::runtime::Result<D2D1_MAPPED_RECT> {
        let mut result__: <D2D1_MAPPED_RECT as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<D2D1_MAPPED_RECT>(result__)
    }
    pub unsafe fn Unmap(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Bitmap1 {
    type Vtable = ID2D1Bitmap1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2828576844,
        14451,
        17800,
        [176, 139, 235, 191, 151, 141, 240, 65],
    );
}
impl ::std::convert::From<ID2D1Bitmap1> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Bitmap1> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Bitmap1> for ID2D1Bitmap {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Bitmap1> for ID2D1Bitmap {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Bitmap> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Bitmap> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Bitmap>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Bitmap> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Bitmap> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Bitmap>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Bitmap1> for ID2D1Image {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Bitmap1> for ID2D1Image {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Image> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Image> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Image>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Image> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Image> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Image>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Bitmap1> for ID2D1Resource {
    fn from(value: ID2D1Bitmap1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Bitmap1> for ID2D1Resource {
    fn from(value: &ID2D1Bitmap1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Bitmap1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Bitmap1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_U),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        result__: *mut D2D1_PIXEL_FORMAT,
    ),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: *mut f32, dpiy: *mut f32),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        destpoint: *const D2D_POINT_2U,
        bitmap: ::windows::runtime::RawPtr,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        destpoint: *const D2D_POINT_2U,
        rendertarget: ::windows::runtime::RawPtr,
        srcrect: *const D2D_RECT_U,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dstrect: *const D2D_RECT_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        colorcontext: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_BITMAP_OPTIONS,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dxgisurface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_MAP_OPTIONS,
        mappedrect: *mut D2D1_MAPPED_RECT,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1BitmapBrush(::windows::runtime::IUnknown);
impl ID2D1BitmapBrush {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn SetOpacity(&self, opacity: f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(opacity),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn GetOpacity(&self) -> f32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(
        &self,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn SetExtendModeX(&self, extendmodex: D2D1_EXTEND_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(extendmodex),
        ))
    }
    pub unsafe fn SetExtendModeY(&self, extendmodey: D2D1_EXTEND_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(extendmodey),
        ))
    }
    pub unsafe fn SetInterpolationMode(&self, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(interpolationmode),
        ))
    }
    pub unsafe fn SetBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
        ))
    }
    pub unsafe fn GetExtendModeX(&self) -> D2D1_EXTEND_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetExtendModeY(&self) -> D2D1_EXTEND_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetInterpolationMode(&self) -> D2D1_BITMAP_INTERPOLATION_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetBitmap(&self, bitmap: *mut ::std::option::Option<ID2D1Bitmap>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bitmap),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1BitmapBrush {
    type Vtable = ID2D1BitmapBrush_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        752420522,
        4834,
        4572,
        [159, 237, 0, 17, 67, 160, 85, 249],
    );
}
impl ::std::convert::From<ID2D1BitmapBrush> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1BitmapBrush) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapBrush> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1BitmapBrush) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1BitmapBrush> for ID2D1Brush {
    fn from(value: ID2D1BitmapBrush) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapBrush> for ID2D1Brush {
    fn from(value: &ID2D1BitmapBrush) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Brush> for ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Brush> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Brush>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Brush> for &ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Brush> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Brush>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1BitmapBrush> for ID2D1Resource {
    fn from(value: ID2D1BitmapBrush) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapBrush> for ID2D1Resource {
    fn from(value: &ID2D1BitmapBrush) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1BitmapBrush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BitmapBrush_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, opacity: f32),
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> f32,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, extendmodex: D2D1_EXTEND_MODE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, extendmodey: D2D1_EXTEND_MODE),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_EXTEND_MODE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_EXTEND_MODE,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
    ) -> D2D1_BITMAP_INTERPOLATION_MODE,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: *mut ::windows::runtime::RawPtr,
    ),
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1BitmapBrush1(::windows::runtime::IUnknown);
impl ID2D1BitmapBrush1 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn SetOpacity(&self, opacity: f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(opacity),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn GetOpacity(&self) -> f32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(
        &self,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn SetExtendModeX(&self, extendmodex: D2D1_EXTEND_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(extendmodex),
        ))
    }
    pub unsafe fn SetExtendModeY(&self, extendmodey: D2D1_EXTEND_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(extendmodey),
        ))
    }
    pub unsafe fn SetInterpolationMode(&self, interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(interpolationmode),
        ))
    }
    pub unsafe fn SetBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
        ))
    }
    pub unsafe fn GetExtendModeX(&self) -> D2D1_EXTEND_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetExtendModeY(&self) -> D2D1_EXTEND_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetInterpolationMode(&self) -> D2D1_BITMAP_INTERPOLATION_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetBitmap(&self, bitmap: *mut ::std::option::Option<ID2D1Bitmap>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bitmap),
        ))
    }
    pub unsafe fn SetInterpolationMode1(&self, interpolationmode: D2D1_INTERPOLATION_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(interpolationmode),
        ))
    }
    pub unsafe fn GetInterpolationMode1(&self) -> D2D1_INTERPOLATION_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1BitmapBrush1 {
    type Vtable = ID2D1BitmapBrush1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1093941843,
        58394,
        18850,
        [145, 205, 33, 121, 59, 187, 98, 229],
    );
}
impl ::std::convert::From<ID2D1BitmapBrush1> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapBrush1> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1BitmapBrush1> for ID2D1BitmapBrush {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapBrush1> for ID2D1BitmapBrush {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1BitmapBrush> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1BitmapBrush> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1BitmapBrush>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1BitmapBrush> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1BitmapBrush> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1BitmapBrush>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1BitmapBrush1> for ID2D1Brush {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapBrush1> for ID2D1Brush {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Brush> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Brush> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Brush>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Brush> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Brush> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Brush>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1BitmapBrush1> for ID2D1Resource {
    fn from(value: ID2D1BitmapBrush1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapBrush1> for ID2D1Resource {
    fn from(value: &ID2D1BitmapBrush1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1BitmapBrush1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BitmapBrush1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, opacity: f32),
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> f32,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, extendmodex: D2D1_EXTEND_MODE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, extendmodey: D2D1_EXTEND_MODE),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_EXTEND_MODE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_EXTEND_MODE,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
    ) -> D2D1_BITMAP_INTERPOLATION_MODE,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        interpolationmode: D2D1_INTERPOLATION_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_INTERPOLATION_MODE,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1BitmapRenderTarget(::windows::runtime::IUnknown);
impl ID2D1BitmapRenderTarget {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, D2D_SIZE_U>>(
        &self,
        size: Param0,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            size.into_param().abi(),
            ::std::mem::transmute(srcdata),
            ::std::mem::transmute(pitch),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICBitmapSource>,
    >(
        &self,
        wicbitmapsource: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicbitmapsource.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateSharedBitmap(
        &self,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::std::option::Option<ID2D1Bitmap>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(data),
            ::std::mem::transmute(bitmapproperties),
            ::std::mem::transmute(bitmap),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1BitmapBrush> {
        let mut result__: <ID2D1BitmapBrush as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(bitmapbrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateSolidColorBrush(
        &self,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1SolidColorBrush> {
        let mut result__: <ID2D1SolidColorBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1SolidColorBrush>(result__)
    }
    pub unsafe fn CreateGradientStopCollection(
        &self,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
    ) -> ::windows::runtime::Result<ID2D1GradientStopCollection> {
        let mut result__: <ID2D1GradientStopCollection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(gradientstops),
            ::std::mem::transmute(gradientstopscount),
            ::std::mem::transmute(colorinterpolationgamma),
            ::std::mem::transmute(extendmode),
            &mut result__,
        )
        .from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateLinearGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1LinearGradientBrush> {
        let mut result__: <ID2D1LinearGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lineargradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateRadialGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1RadialGradientBrush> {
        let mut result__: <ID2D1RadialGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(radialgradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCompatibleRenderTarget(
        &self,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1BitmapRenderTarget> {
        let mut result__: <ID2D1BitmapRenderTarget as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(desiredsize),
            ::std::mem::transmute(desiredpixelsize),
            ::std::mem::transmute(desiredformat),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    pub unsafe fn CreateLayer(
        &self,
        size: *const D2D_SIZE_F,
    ) -> ::windows::runtime::Result<ID2D1Layer> {
        let mut result__: <ID2D1Layer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(size),
            &mut result__,
        )
        .from_abi::<ID2D1Layer>(result__)
    }
    pub unsafe fn CreateMesh(&self) -> ::windows::runtime::Result<ID2D1Mesh> {
        let mut result__: <ID2D1Mesh as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID2D1Mesh>(result__)
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawEllipse<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillEllipse<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        ))
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(content),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        string: Param0,
        stringlength: u32,
        textformat: Param2,
        layoutrect: *const D2D_RECT_F,
        defaultfillbrush: Param4,
        options: D2D1_DRAW_TEXT_OPTIONS,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            string.into_param().abi(),
            ::std::mem::transmute(stringlength),
            textformat.into_param().abi(),
            ::std::mem::transmute(layoutrect),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn DrawTextLayout<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        origin: Param0,
        textlayout: Param1,
        defaultfillbrush: Param2,
        options: D2D1_DRAW_TEXT_OPTIONS,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            origin.into_param().abi(),
            textlayout.into_param().abi(),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        foregroundbrush: Param2,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(
        &self,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        ))
    }
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(
        &self,
        textrenderingparams: *mut ::std::option::Option<super::DirectWrite::IDWriteRenderingParams>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textrenderingparams),
        ))
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters: *const D2D1_LAYER_PARAMETERS,
        layer: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters),
            layer.into_param().abi(),
        ))
    }
    pub unsafe fn PopLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SaveDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn RestoreDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn PopAxisAlignedClip(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Clear(&self, clearcolor: *const D2D1_COLOR_F) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(clearcolor),
        ))
    }
    pub unsafe fn BeginDraw(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetPixelFormat(&self) -> D2D1_PIXEL_FORMAT {
        let mut result__: D2D1_PIXEL_FORMAT = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetSize(&self) -> D2D_SIZE_F {
        let mut result__: D2D_SIZE_F = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetPixelSize(&self) -> D2D_SIZE_U {
        let mut result__: D2D_SIZE_U = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn IsSupported(
        &self,
        rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rendertargetproperties),
        ))
    }
    pub unsafe fn GetBitmap(&self) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1BitmapRenderTarget {
    type Vtable = ID2D1BitmapRenderTarget_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        752420501,
        4834,
        4572,
        [159, 237, 0, 17, 67, 160, 85, 249],
    );
}
impl ::std::convert::From<ID2D1BitmapRenderTarget> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1BitmapRenderTarget) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapRenderTarget> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1BitmapRenderTarget) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ID2D1BitmapRenderTarget
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID2D1BitmapRenderTarget
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1BitmapRenderTarget> for ID2D1RenderTarget {
    fn from(value: ID2D1BitmapRenderTarget) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapRenderTarget> for ID2D1RenderTarget {
    fn from(value: &ID2D1BitmapRenderTarget) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for &ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1BitmapRenderTarget> for ID2D1Resource {
    fn from(value: ID2D1BitmapRenderTarget) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BitmapRenderTarget> for ID2D1Resource {
    fn from(value: &ID2D1BitmapRenderTarget) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1BitmapRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BitmapRenderTarget_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: D2D_SIZE_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicbitmapsource: ::windows::runtime::RawPtr,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging")))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        bitmapbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        solidcolorbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
        gradientstopcollection: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        lineargradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        radialgradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
        bitmaprendertarget: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: *const D2D_SIZE_F,
        layer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ),
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        string: super::super::Foundation::PWSTR,
        stringlength: u32,
        textformat: ::windows::runtime::RawPtr,
        layoutrect: *const D2D_RECT_F,
        defaultfillbrush: ::windows::runtime::RawPtr,
        options: D2D1_DRAW_TEXT_OPTIONS,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        origin: D2D_POINT_2F,
        textlayout: ::windows::runtime::RawPtr,
        defaultfillbrush: ::windows::runtime::RawPtr,
        options: D2D1_DRAW_TEXT_OPTIONS,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_ANTIALIAS_MODE,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_TEXT_ANTIALIAS_MODE,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tag1: u64, tag2: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tag1: *mut u64, tag2: *mut u64),
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS>,
        layer: ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: *mut u64,
        tag2: *mut u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        drawingstateblock: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        drawingstateblock: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, clearcolor: *const D2D1_COLOR_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: *mut u64,
        tag2: *mut u64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        result__: *mut D2D1_PIXEL_FORMAT,
    ),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: f32, dpiy: f32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: *mut f32, dpiy: *mut f32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_U),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES,
    ) -> super::super::Foundation::BOOL,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1BlendTransform(::windows::runtime::IUnknown);
impl ID2D1BlendTransform {
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetOutputBuffer(
        &self,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bufferprecision),
            ::std::mem::transmute(channeldepth),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        iscached: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            iscached.into_param().abi(),
        ))
    }
    pub unsafe fn SetDescription(&self, description: *const D2D1_BLEND_DESCRIPTION) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(description),
        ))
    }
    pub unsafe fn GetDescription(&self, description: *mut D2D1_BLEND_DESCRIPTION) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(description),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1BlendTransform {
    type Vtable = ID2D1BlendTransform_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1672219442,
        47684,
        17679,
        [136, 6, 127, 76, 161, 255, 47, 27],
    );
}
impl ::std::convert::From<ID2D1BlendTransform> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1BlendTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BlendTransform> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1BlendTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1BlendTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1BlendTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1BlendTransform> for ID2D1ConcreteTransform {
    fn from(value: ID2D1BlendTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BlendTransform> for ID2D1ConcreteTransform {
    fn from(value: &ID2D1BlendTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1ConcreteTransform> for ID2D1BlendTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1ConcreteTransform> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1ConcreteTransform>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1ConcreteTransform> for &ID2D1BlendTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1ConcreteTransform> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1ConcreteTransform>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1BlendTransform> for ID2D1TransformNode {
    fn from(value: ID2D1BlendTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BlendTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1BlendTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for ID2D1BlendTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for &ID2D1BlendTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BlendTransform_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iscached: super::super::Foundation::BOOL,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        description: *const D2D1_BLEND_DESCRIPTION,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        description: *mut D2D1_BLEND_DESCRIPTION,
    ),
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1BorderTransform(::windows::runtime::IUnknown);
impl ID2D1BorderTransform {
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetOutputBuffer(
        &self,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bufferprecision),
            ::std::mem::transmute(channeldepth),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        iscached: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            iscached.into_param().abi(),
        ))
    }
    pub unsafe fn SetExtendModeX(&self, extendmode: D2D1_EXTEND_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(extendmode),
        ))
    }
    pub unsafe fn SetExtendModeY(&self, extendmode: D2D1_EXTEND_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(extendmode),
        ))
    }
    pub unsafe fn GetExtendModeX(&self) -> D2D1_EXTEND_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetExtendModeY(&self) -> D2D1_EXTEND_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1BorderTransform {
    type Vtable = ID2D1BorderTransform_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1234727772,
        14873,
        18236,
        [151, 129, 101, 104, 71, 227, 163, 71],
    );
}
impl ::std::convert::From<ID2D1BorderTransform> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1BorderTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BorderTransform> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1BorderTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1BorderTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1BorderTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1BorderTransform> for ID2D1ConcreteTransform {
    fn from(value: ID2D1BorderTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BorderTransform> for ID2D1ConcreteTransform {
    fn from(value: &ID2D1BorderTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1ConcreteTransform> for ID2D1BorderTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1ConcreteTransform> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1ConcreteTransform>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1ConcreteTransform> for &ID2D1BorderTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1ConcreteTransform> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1ConcreteTransform>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1BorderTransform> for ID2D1TransformNode {
    fn from(value: ID2D1BorderTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BorderTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1BorderTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for ID2D1BorderTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for &ID2D1BorderTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BorderTransform_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iscached: super::super::Foundation::BOOL,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, extendmode: D2D1_EXTEND_MODE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, extendmode: D2D1_EXTEND_MODE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_EXTEND_MODE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_EXTEND_MODE,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1BoundsAdjustmentTransform(::windows::runtime::IUnknown);
impl ID2D1BoundsAdjustmentTransform {
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOutputBounds(&self, outputbounds: *const super::super::Foundation::RECT) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(outputbounds),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOutputBounds(&self, outputbounds: *mut super::super::Foundation::RECT) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(outputbounds),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1BoundsAdjustmentTransform {
    type Vtable = ID2D1BoundsAdjustmentTransform_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2432119522,
        20626,
        17926,
        [168, 25, 134, 81, 151, 11, 172, 205],
    );
}
impl ::std::convert::From<ID2D1BoundsAdjustmentTransform> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1BoundsAdjustmentTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BoundsAdjustmentTransform> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1BoundsAdjustmentTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ID2D1BoundsAdjustmentTransform
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID2D1BoundsAdjustmentTransform
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1BoundsAdjustmentTransform> for ID2D1TransformNode {
    fn from(value: ID2D1BoundsAdjustmentTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1BoundsAdjustmentTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1BoundsAdjustmentTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for ID2D1BoundsAdjustmentTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for &ID2D1BoundsAdjustmentTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1BoundsAdjustmentTransform_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        outputbounds: *const super::super::Foundation::RECT,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        outputbounds: *mut super::super::Foundation::RECT,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Brush(::windows::runtime::IUnknown);
impl ID2D1Brush {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn SetOpacity(&self, opacity: f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(opacity),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn GetOpacity(&self) -> f32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(
        &self,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Brush {
    type Vtable = ID2D1Brush_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        752420520,
        4834,
        4572,
        [159, 237, 0, 17, 67, 160, 85, 249],
    );
}
impl ::std::convert::From<ID2D1Brush> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Brush) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Brush> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Brush) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Brush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Brush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Brush> for ID2D1Resource {
    fn from(value: ID2D1Brush) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Brush> for ID2D1Resource {
    fn from(value: &ID2D1Brush) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Brush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Brush {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Brush_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, opacity: f32),
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> f32,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1ColorContext(::windows::runtime::IUnknown);
impl ID2D1ColorContext {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn GetColorSpace(&self) -> D2D1_COLOR_SPACE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetProfileSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetProfile(
        &self,
        profile: *mut u8,
        profilesize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(profile),
            ::std::mem::transmute(profilesize),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1ColorContext {
    type Vtable = ID2D1ColorContext_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        474489019,
        22385,
        17688,
        [165, 129, 47, 228, 221, 14, 198, 87],
    );
}
impl ::std::convert::From<ID2D1ColorContext> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1ColorContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ColorContext> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1ColorContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1ColorContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1ColorContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1ColorContext> for ID2D1Resource {
    fn from(value: ID2D1ColorContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ColorContext> for ID2D1Resource {
    fn from(value: &ID2D1ColorContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1ColorContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1ColorContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ColorContext_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_COLOR_SPACE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        profile: *mut u8,
        profilesize: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1ColorContext1(::windows::runtime::IUnknown);
impl ID2D1ColorContext1 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn GetColorSpace(&self) -> D2D1_COLOR_SPACE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetProfileSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetProfile(
        &self,
        profile: *mut u8,
        profilesize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(profile),
            ::std::mem::transmute(profilesize),
        )
        .ok()
    }
    pub unsafe fn GetColorContextType(&self) -> D2D1_COLOR_CONTEXT_TYPE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDXGIColorSpace(&self) -> super::Dxgi::DXGI_COLOR_SPACE_TYPE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetSimpleColorProfile(
        &self,
    ) -> ::windows::runtime::Result<D2D1_SIMPLE_COLOR_PROFILE> {
        let mut result__: <D2D1_SIMPLE_COLOR_PROFILE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<D2D1_SIMPLE_COLOR_PROFILE>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1ColorContext1 {
    type Vtable = ID2D1ColorContext1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        448014453,
        50559,
        19433,
        [189, 133, 156, 215, 141, 111, 85, 238],
    );
}
impl ::std::convert::From<ID2D1ColorContext1> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1ColorContext1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ColorContext1> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1ColorContext1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1ColorContext1> for ID2D1ColorContext {
    fn from(value: ID2D1ColorContext1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ColorContext1> for ID2D1ColorContext {
    fn from(value: &ID2D1ColorContext1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1ColorContext> for ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1ColorContext> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1ColorContext>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1ColorContext> for &ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1ColorContext> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1ColorContext>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1ColorContext1> for ID2D1Resource {
    fn from(value: ID2D1ColorContext1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ColorContext1> for ID2D1Resource {
    fn from(value: &ID2D1ColorContext1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1ColorContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ColorContext1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_COLOR_SPACE,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        profile: *mut u8,
        profilesize: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_COLOR_CONTEXT_TYPE,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
    ) -> super::Dxgi::DXGI_COLOR_SPACE_TYPE,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        simpleprofile: *mut D2D1_SIMPLE_COLOR_PROFILE,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1CommandList(::windows::runtime::IUnknown);
impl ID2D1CommandList {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn Stream<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1CommandSink>>(
        &self,
        sink: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            sink.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Close(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1CommandList {
    type Vtable = ID2D1CommandList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3035843097,
        9091,
        19830,
        [148, 246, 236, 52, 54, 87, 195, 220],
    );
}
impl ::std::convert::From<ID2D1CommandList> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandList> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1CommandList> for ID2D1Image {
    fn from(value: ID2D1CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandList> for ID2D1Image {
    fn from(value: &ID2D1CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Image> for ID2D1CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Image> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Image>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Image> for &ID2D1CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Image> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Image>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandList> for ID2D1Resource {
    fn from(value: ID2D1CommandList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandList> for ID2D1Resource {
    fn from(value: &ID2D1CommandList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1CommandList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandList_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        sink: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1CommandSink(::windows::runtime::IUnknown);
impl ID2D1CommandSink {
    pub unsafe fn BeginDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetAntialiasMode(
        &self,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SetTextAntialiasMode(
        &self,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        )
        .ok()
    }
    pub unsafe fn Clear(&self, color: *const D2D1_COLOR_F) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        )
        .ok()
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        )
        .ok()
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        )
        .ok()
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters1: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters1),
            layer.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PopLayer(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1CommandSink {
    type Vtable = ID2D1CommandSink_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1423411594,
        41057,
        16551,
        [190, 199, 228, 101, 188, 186, 44, 79],
    );
}
impl ::std::convert::From<ID2D1CommandSink> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1CommandSink) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1CommandSink) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1CommandSink {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1CommandSink {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: u64,
        tag2: u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unitmode: D2D1_UNIT_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters1: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS1>,
        layer: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1CommandSink1(::windows::runtime::IUnknown);
impl ID2D1CommandSink1 {
    pub unsafe fn BeginDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetAntialiasMode(
        &self,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SetTextAntialiasMode(
        &self,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        )
        .ok()
    }
    pub unsafe fn Clear(&self, color: *const D2D1_COLOR_F) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        )
        .ok()
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        )
        .ok()
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        )
        .ok()
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters1: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters1),
            layer.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PopLayer(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetPrimitiveBlend1(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1CommandSink1 {
    type Vtable = ID2D1CommandSink1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2662819837,
        17001,
        17511,
        [184, 194, 235, 48, 203, 48, 87, 67],
    );
}
impl ::std::convert::From<ID2D1CommandSink1> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1CommandSink1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink1> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1CommandSink1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1CommandSink1> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink1> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: u64,
        tag2: u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unitmode: D2D1_UNIT_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters1: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS1>,
        layer: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1CommandSink2(::windows::runtime::IUnknown);
impl ID2D1CommandSink2 {
    pub unsafe fn BeginDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetAntialiasMode(
        &self,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SetTextAntialiasMode(
        &self,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        )
        .ok()
    }
    pub unsafe fn Clear(&self, color: *const D2D1_COLOR_F) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        )
        .ok()
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        )
        .ok()
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        )
        .ok()
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters1: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters1),
            layer.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PopLayer(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetPrimitiveBlend1(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn DrawInk<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Ink>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1InkStyle>,
    >(
        &self,
        ink: Param0,
        brush: Param1,
        inkstyle: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ink.into_param().abi(),
            brush.into_param().abi(),
            inkstyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGradientMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GradientMesh>,
    >(
        &self,
        gradientmesh: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            gradientmesh.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1CommandSink2 {
    type Vtable = ID2D1CommandSink2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1001079822,
        16766,
        18399,
        [162, 226, 188, 11, 230, 160, 9, 22],
    );
}
impl ::std::convert::From<ID2D1CommandSink2> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1CommandSink2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink2> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1CommandSink2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1CommandSink2> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink2> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink2> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink2> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: u64,
        tag2: u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unitmode: D2D1_UNIT_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters1: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS1>,
        layer: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ink: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        inkstyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientmesh: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1CommandSink3(::windows::runtime::IUnknown);
impl ID2D1CommandSink3 {
    pub unsafe fn BeginDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetAntialiasMode(
        &self,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SetTextAntialiasMode(
        &self,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        )
        .ok()
    }
    pub unsafe fn Clear(&self, color: *const D2D1_COLOR_F) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        )
        .ok()
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        )
        .ok()
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        )
        .ok()
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters1: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters1),
            layer.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PopLayer(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetPrimitiveBlend1(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn DrawInk<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Ink>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1InkStyle>,
    >(
        &self,
        ink: Param0,
        brush: Param1,
        inkstyle: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ink.into_param().abi(),
            brush.into_param().abi(),
            inkstyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGradientMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GradientMesh>,
    >(
        &self,
        gradientmesh: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            gradientmesh.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn DrawSpriteBatch<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1SpriteBatch>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        spritebatch: Param0,
        startindex: u32,
        spritecount: u32,
        bitmap: Param3,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        spriteoptions: D2D1_SPRITE_OPTIONS,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            spritebatch.into_param().abi(),
            ::std::mem::transmute(startindex),
            ::std::mem::transmute(spritecount),
            bitmap.into_param().abi(),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(spriteoptions),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1CommandSink3 {
    type Vtable = ID2D1CommandSink3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        403149109,
        19699,
        18536,
        [188, 142, 6, 6, 126, 109, 36, 45],
    );
}
impl ::std::convert::From<ID2D1CommandSink3> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink3> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1CommandSink3> for ID2D1CommandSink2 {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink3> for ID2D1CommandSink2 {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink2> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink2> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink3> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink3> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink3> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink3> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: u64,
        tag2: u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unitmode: D2D1_UNIT_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters1: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS1>,
        layer: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ink: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        inkstyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientmesh: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        spritebatch: ::windows::runtime::RawPtr,
        startindex: u32,
        spritecount: u32,
        bitmap: ::windows::runtime::RawPtr,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        spriteoptions: D2D1_SPRITE_OPTIONS,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1CommandSink4(::windows::runtime::IUnknown);
impl ID2D1CommandSink4 {
    pub unsafe fn BeginDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetAntialiasMode(
        &self,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SetTextAntialiasMode(
        &self,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        )
        .ok()
    }
    pub unsafe fn Clear(&self, color: *const D2D1_COLOR_F) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        )
        .ok()
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        )
        .ok()
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        )
        .ok()
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters1: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters1),
            layer.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PopLayer(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetPrimitiveBlend1(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn DrawInk<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Ink>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1InkStyle>,
    >(
        &self,
        ink: Param0,
        brush: Param1,
        inkstyle: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ink.into_param().abi(),
            brush.into_param().abi(),
            inkstyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGradientMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GradientMesh>,
    >(
        &self,
        gradientmesh: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            gradientmesh.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn DrawSpriteBatch<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1SpriteBatch>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        spritebatch: Param0,
        startindex: u32,
        spritecount: u32,
        bitmap: Param3,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        spriteoptions: D2D1_SPRITE_OPTIONS,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            spritebatch.into_param().abi(),
            ::std::mem::transmute(startindex),
            ::std::mem::transmute(spritecount),
            bitmap.into_param().abi(),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(spriteoptions),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend2(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1CommandSink4 {
    type Vtable = ID2D1CommandSink4_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3347735833,
        16598,
        16920,
        [178, 222, 190, 238, 183, 68, 187, 62],
    );
}
impl ::std::convert::From<ID2D1CommandSink4> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink4> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1CommandSink4> for ID2D1CommandSink3 {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink3 {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink3> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink3> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink4> for ID2D1CommandSink2 {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink2 {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink2> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink2> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink4> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink4> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink4> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink4_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: u64,
        tag2: u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unitmode: D2D1_UNIT_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters1: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS1>,
        layer: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ink: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        inkstyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientmesh: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        spritebatch: ::windows::runtime::RawPtr,
        startindex: u32,
        spritecount: u32,
        bitmap: ::windows::runtime::RawPtr,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        spriteoptions: D2D1_SPRITE_OPTIONS,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1CommandSink5(::windows::runtime::IUnknown);
impl ID2D1CommandSink5 {
    pub unsafe fn BeginDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn EndDraw(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetAntialiasMode(
        &self,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SetTextAntialiasMode(
        &self,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        )
        .ok()
    }
    pub unsafe fn Clear(&self, color: *const D2D1_COLOR_F) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        )
        .ok()
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        )
        .ok()
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        )
        .ok()
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters1: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters1),
            layer.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PopAxisAlignedClip(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PopLayer(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetPrimitiveBlend1(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn DrawInk<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Ink>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1InkStyle>,
    >(
        &self,
        ink: Param0,
        brush: Param1,
        inkstyle: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ink.into_param().abi(),
            brush.into_param().abi(),
            inkstyle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGradientMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GradientMesh>,
    >(
        &self,
        gradientmesh: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            gradientmesh.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrawGdiMetafile2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        )
        .ok()
    }
    pub unsafe fn DrawSpriteBatch<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1SpriteBatch>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        spritebatch: Param0,
        startindex: u32,
        spritecount: u32,
        bitmap: Param3,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        spriteoptions: D2D1_SPRITE_OPTIONS,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            spritebatch.into_param().abi(),
            ::std::mem::transmute(startindex),
            ::std::mem::transmute(spritecount),
            bitmap.into_param().abi(),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(spriteoptions),
        )
        .ok()
    }
    pub unsafe fn SetPrimitiveBlend2(
        &self,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        )
        .ok()
    }
    pub unsafe fn BlendImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        blendmode: D2D1_BLEND_MODE,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(blendmode),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1CommandSink5 {
    type Vtable = ID2D1CommandSink5_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1883757862,
        45543,
        17575,
        [149, 154, 131, 73, 226, 20, 79, 168],
    );
}
impl ::std::convert::From<ID2D1CommandSink5> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink5> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1CommandSink5> for ID2D1CommandSink4 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink4 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink4> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink4>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink4> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink4>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink5> for ID2D1CommandSink3 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink3 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink3> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink3> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink5> for ID2D1CommandSink2 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink2 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink2> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink2> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink5> for ID2D1CommandSink1 {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink1 {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink1> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1CommandSink5> for ID2D1CommandSink {
    fn from(value: ID2D1CommandSink5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1CommandSink5> for ID2D1CommandSink {
    fn from(value: &ID2D1CommandSink5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1CommandSink> for &ID2D1CommandSink5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1CommandSink> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1CommandSink>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1CommandSink5_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: u64,
        tag2: u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unitmode: D2D1_UNIT_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters1: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS1>,
        layer: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ink: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        inkstyle: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientmesh: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        spritebatch: ::windows::runtime::RawPtr,
        startindex: u32,
        spritecount: u32,
        bitmap: ::windows::runtime::RawPtr,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        spriteoptions: D2D1_SPRITE_OPTIONS,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        blendmode: D2D1_BLEND_MODE,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1ComputeInfo(::windows::runtime::IUnknown);
impl ID2D1ComputeInfo {
    pub unsafe fn SetInputDescription<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, D2D1_INPUT_DESCRIPTION>,
    >(
        &self,
        inputindex: u32,
        inputdescription: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(inputindex),
            inputdescription.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetOutputBuffer(
        &self,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bufferprecision),
            ::std::mem::transmute(channeldepth),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        iscached: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            iscached.into_param().abi(),
        ))
    }
    pub unsafe fn SetInstructionCountHint(&self, instructioncount: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(instructioncount),
        ))
    }
    pub unsafe fn SetComputeShaderConstantBuffer(
        &self,
        buffer: *const u8,
        buffercount: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(buffer),
            ::std::mem::transmute(buffercount),
        )
        .ok()
    }
    pub unsafe fn SetComputeShader(
        &self,
        shaderid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(shaderid),
        )
        .ok()
    }
    pub unsafe fn SetResourceTexture<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1ResourceTexture>,
    >(
        &self,
        textureindex: u32,
        resourcetexture: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textureindex),
            resourcetexture.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1ComputeInfo {
    type Vtable = ID2D1ComputeInfo_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1436070219,
        40919,
        18615,
        [155, 219, 143, 9, 100, 235, 56, 188],
    );
}
impl ::std::convert::From<ID2D1ComputeInfo> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1ComputeInfo) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ComputeInfo> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1ComputeInfo) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1ComputeInfo> for ID2D1RenderInfo {
    fn from(value: ID2D1ComputeInfo) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ComputeInfo> for ID2D1RenderInfo {
    fn from(value: &ID2D1ComputeInfo) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderInfo> for ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderInfo> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderInfo>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderInfo> for &ID2D1ComputeInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderInfo> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderInfo>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ComputeInfo_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        inputindex: u32,
        inputdescription: D2D1_INPUT_DESCRIPTION,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iscached: super::super::Foundation::BOOL,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, instructioncount: u32),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        buffer: *const u8,
        buffercount: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        shaderid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textureindex: u32,
        resourcetexture: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1ComputeTransform(::windows::runtime::IUnknown);
impl ID2D1ComputeTransform {
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MapOutputRectToInputRects(
        &self,
        outputrect: *const super::super::Foundation::RECT,
        inputrects: *mut super::super::Foundation::RECT,
        inputrectscount: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(outputrect),
            ::std::mem::transmute(inputrects),
            ::std::mem::transmute(inputrectscount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MapInputRectsToOutputRect(
        &self,
        inputrects: *const super::super::Foundation::RECT,
        inputopaquesubrects: *const super::super::Foundation::RECT,
        inputrectcount: u32,
        outputrect: *mut super::super::Foundation::RECT,
        outputopaquesubrect: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(inputrects),
            ::std::mem::transmute(inputopaquesubrects),
            ::std::mem::transmute(inputrectcount),
            ::std::mem::transmute(outputrect),
            ::std::mem::transmute(outputopaquesubrect),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MapInvalidRect<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::RECT>,
    >(
        &self,
        inputindex: u32,
        invalidinputrect: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(inputindex),
            invalidinputrect.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    pub unsafe fn SetComputeInfo<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1ComputeInfo>,
    >(
        &self,
        computeinfo: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            computeinfo.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CalculateThreadgroups(
        &self,
        outputrect: *const super::super::Foundation::RECT,
        dimensionx: *mut u32,
        dimensiony: *mut u32,
        dimensionz: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(outputrect),
            ::std::mem::transmute(dimensionx),
            ::std::mem::transmute(dimensiony),
            ::std::mem::transmute(dimensionz),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1ComputeTransform {
    type Vtable = ID2D1ComputeTransform_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        226842428,
        483,
        20349,
        [191, 217, 13, 96, 96, 139, 243, 195],
    );
}
impl ::std::convert::From<ID2D1ComputeTransform> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1ComputeTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ComputeTransform> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1ComputeTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID2D1ComputeTransform
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1ComputeTransform> for ID2D1Transform {
    fn from(value: ID2D1ComputeTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ComputeTransform> for ID2D1Transform {
    fn from(value: &ID2D1ComputeTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Transform> for ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Transform> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Transform>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Transform> for &ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Transform> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Transform>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1ComputeTransform> for ID2D1TransformNode {
    fn from(value: ID2D1ComputeTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ComputeTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1ComputeTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for &ID2D1ComputeTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ComputeTransform_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        outputrect: *const super::super::Foundation::RECT,
        inputrects: *mut super::super::Foundation::RECT,
        inputrectscount: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        inputrects: *const super::super::Foundation::RECT,
        inputopaquesubrects: *const super::super::Foundation::RECT,
        inputrectcount: u32,
        outputrect: *mut super::super::Foundation::RECT,
        outputopaquesubrect: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        inputindex: u32,
        invalidinputrect: super::super::Foundation::RECT,
        invalidoutputrect: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        computeinfo: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        outputrect: *const super::super::Foundation::RECT,
        dimensionx: *mut u32,
        dimensiony: *mut u32,
        dimensionz: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1ConcreteTransform(::windows::runtime::IUnknown);
impl ID2D1ConcreteTransform {
    pub unsafe fn GetInputCount(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetOutputBuffer(
        &self,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bufferprecision),
            ::std::mem::transmute(channeldepth),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCached<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        iscached: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            iscached.into_param().abi(),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1ConcreteTransform {
    type Vtable = ID2D1ConcreteTransform_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        444177802,
        27127,
        20044,
        [159, 237, 67, 124, 204, 102, 132, 204],
    );
}
impl ::std::convert::From<ID2D1ConcreteTransform> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1ConcreteTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ConcreteTransform> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1ConcreteTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ID2D1ConcreteTransform
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ID2D1ConcreteTransform
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1ConcreteTransform> for ID2D1TransformNode {
    fn from(value: ID2D1ConcreteTransform) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1ConcreteTransform> for ID2D1TransformNode {
    fn from(value: &ID2D1ConcreteTransform) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for ID2D1ConcreteTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1TransformNode> for &ID2D1ConcreteTransform {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1TransformNode> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1TransformNode>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1ConcreteTransform_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bufferprecision: D2D1_BUFFER_PRECISION,
        channeldepth: D2D1_CHANNEL_DEPTH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iscached: super::super::Foundation::BOOL,
    ),
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1DCRenderTarget(::windows::runtime::IUnknown);
impl ID2D1DCRenderTarget {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, D2D_SIZE_U>>(
        &self,
        size: Param0,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            size.into_param().abi(),
            ::std::mem::transmute(srcdata),
            ::std::mem::transmute(pitch),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICBitmapSource>,
    >(
        &self,
        wicbitmapsource: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicbitmapsource.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateSharedBitmap(
        &self,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::std::option::Option<ID2D1Bitmap>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(data),
            ::std::mem::transmute(bitmapproperties),
            ::std::mem::transmute(bitmap),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1BitmapBrush> {
        let mut result__: <ID2D1BitmapBrush as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(bitmapbrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateSolidColorBrush(
        &self,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1SolidColorBrush> {
        let mut result__: <ID2D1SolidColorBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1SolidColorBrush>(result__)
    }
    pub unsafe fn CreateGradientStopCollection(
        &self,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
    ) -> ::windows::runtime::Result<ID2D1GradientStopCollection> {
        let mut result__: <ID2D1GradientStopCollection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(gradientstops),
            ::std::mem::transmute(gradientstopscount),
            ::std::mem::transmute(colorinterpolationgamma),
            ::std::mem::transmute(extendmode),
            &mut result__,
        )
        .from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateLinearGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1LinearGradientBrush> {
        let mut result__: <ID2D1LinearGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lineargradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateRadialGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1RadialGradientBrush> {
        let mut result__: <ID2D1RadialGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(radialgradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCompatibleRenderTarget(
        &self,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1BitmapRenderTarget> {
        let mut result__: <ID2D1BitmapRenderTarget as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(desiredsize),
            ::std::mem::transmute(desiredpixelsize),
            ::std::mem::transmute(desiredformat),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    pub unsafe fn CreateLayer(
        &self,
        size: *const D2D_SIZE_F,
    ) -> ::windows::runtime::Result<ID2D1Layer> {
        let mut result__: <ID2D1Layer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(size),
            &mut result__,
        )
        .from_abi::<ID2D1Layer>(result__)
    }
    pub unsafe fn CreateMesh(&self) -> ::windows::runtime::Result<ID2D1Mesh> {
        let mut result__: <ID2D1Mesh as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID2D1Mesh>(result__)
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawEllipse<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillEllipse<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        ))
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(content),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        string: Param0,
        stringlength: u32,
        textformat: Param2,
        layoutrect: *const D2D_RECT_F,
        defaultfillbrush: Param4,
        options: D2D1_DRAW_TEXT_OPTIONS,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            string.into_param().abi(),
            ::std::mem::transmute(stringlength),
            textformat.into_param().abi(),
            ::std::mem::transmute(layoutrect),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn DrawTextLayout<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        origin: Param0,
        textlayout: Param1,
        defaultfillbrush: Param2,
        options: D2D1_DRAW_TEXT_OPTIONS,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            origin.into_param().abi(),
            textlayout.into_param().abi(),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        foregroundbrush: Param2,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(
        &self,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        ))
    }
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(
        &self,
        textrenderingparams: *mut ::std::option::Option<super::DirectWrite::IDWriteRenderingParams>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textrenderingparams),
        ))
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters: *const D2D1_LAYER_PARAMETERS,
        layer: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters),
            layer.into_param().abi(),
        ))
    }
    pub unsafe fn PopLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SaveDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn RestoreDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn PopAxisAlignedClip(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Clear(&self, clearcolor: *const D2D1_COLOR_F) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(clearcolor),
        ))
    }
    pub unsafe fn BeginDraw(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetPixelFormat(&self) -> D2D1_PIXEL_FORMAT {
        let mut result__: D2D1_PIXEL_FORMAT = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetSize(&self) -> D2D_SIZE_F {
        let mut result__: D2D_SIZE_F = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetPixelSize(&self) -> D2D_SIZE_U {
        let mut result__: D2D_SIZE_U = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn IsSupported(
        &self,
        rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rendertargetproperties),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn BindDC<'a, Param0: ::windows::runtime::IntoParam<'a, super::Gdi::HDC>>(
        &self,
        hdc: Param0,
        psubrect: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            hdc.into_param().abi(),
            ::std::mem::transmute(psubrect),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1DCRenderTarget {
    type Vtable = ID2D1DCRenderTarget_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        475118692,
        56929,
        18173,
        [152, 153, 99, 165, 216, 240, 57, 80],
    );
}
impl ::std::convert::From<ID2D1DCRenderTarget> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1DCRenderTarget) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DCRenderTarget> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1DCRenderTarget) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1DCRenderTarget> for ID2D1RenderTarget {
    fn from(value: ID2D1DCRenderTarget) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DCRenderTarget> for ID2D1RenderTarget {
    fn from(value: &ID2D1DCRenderTarget) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1DCRenderTarget> for ID2D1Resource {
    fn from(value: ID2D1DCRenderTarget) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DCRenderTarget> for ID2D1Resource {
    fn from(value: &ID2D1DCRenderTarget) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1DCRenderTarget {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DCRenderTarget_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: D2D_SIZE_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicbitmapsource: ::windows::runtime::RawPtr,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging")))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        bitmapbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        solidcolorbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
        gradientstopcollection: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        lineargradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        radialgradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
        bitmaprendertarget: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: *const D2D_SIZE_F,
        layer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ),
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        string: super::super::Foundation::PWSTR,
        stringlength: u32,
        textformat: ::windows::runtime::RawPtr,
        layoutrect: *const D2D_RECT_F,
        defaultfillbrush: ::windows::runtime::RawPtr,
        options: D2D1_DRAW_TEXT_OPTIONS,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        origin: D2D_POINT_2F,
        textlayout: ::windows::runtime::RawPtr,
        defaultfillbrush: ::windows::runtime::RawPtr,
        options: D2D1_DRAW_TEXT_OPTIONS,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_ANTIALIAS_MODE,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_TEXT_ANTIALIAS_MODE,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tag1: u64, tag2: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tag1: *mut u64, tag2: *mut u64),
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS>,
        layer: ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: *mut u64,
        tag2: *mut u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        drawingstateblock: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        drawingstateblock: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, clearcolor: *const D2D1_COLOR_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: *mut u64,
        tag2: *mut u64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        result__: *mut D2D1_PIXEL_FORMAT,
    ),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: f32, dpiy: f32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: *mut f32, dpiy: *mut f32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_U),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES,
    ) -> super::super::Foundation::BOOL,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hdc: super::Gdi::HDC,
        psubrect: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Device(::windows::runtime::IUnknown);
impl ID2D1Device {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn CreateDeviceContext(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext> {
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub unsafe fn CreatePrintControl<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICImagingFactory>,
        Param1: ::windows::runtime::IntoParam<
            'a,
            super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget,
        >,
    >(
        &self,
        wicfactory: Param0,
        documenttarget: Param1,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1PrintControl> {
        let mut result__: <ID2D1PrintControl as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicfactory.into_param().abi(),
            documenttarget.into_param().abi(),
            ::std::mem::transmute(printcontrolproperties),
            &mut result__,
        )
        .from_abi::<ID2D1PrintControl>(result__)
    }
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(millisecondssinceuse),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Device {
    type Vtable = ID2D1Device_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1205688157,
        44037,
        19677,
        [128, 73, 155, 2, 205, 22, 244, 76],
    );
}
impl ::std::convert::From<ID2D1Device> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Device) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Device) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Device> for ID2D1Resource {
    fn from(value: ID2D1Device) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device> for ID2D1Resource {
    fn from(value: &ID2D1Device) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Device {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicfactory: ::windows::runtime::RawPtr,
        documenttarget: ::windows::runtime::RawPtr,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
        printcontrol: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, millisecondssinceuse: u32),
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Device1(::windows::runtime::IUnknown);
impl ID2D1Device1 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn CreateDeviceContext(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext> {
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub unsafe fn CreatePrintControl<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICImagingFactory>,
        Param1: ::windows::runtime::IntoParam<
            'a,
            super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget,
        >,
    >(
        &self,
        wicfactory: Param0,
        documenttarget: Param1,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1PrintControl> {
        let mut result__: <ID2D1PrintControl as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicfactory.into_param().abi(),
            documenttarget.into_param().abi(),
            ::std::mem::transmute(printcontrolproperties),
            &mut result__,
        )
        .from_abi::<ID2D1PrintControl>(result__)
    }
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(millisecondssinceuse),
        ))
    }
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingpriority),
        ))
    }
    pub unsafe fn CreateDeviceContext2(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext1> {
        let mut result__: <ID2D1DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext1>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Device1 {
    type Vtable = ID2D1Device1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3524749537,
        9124,
        18467,
        [161, 75, 124, 62, 186, 133, 214, 88],
    );
}
impl ::std::convert::From<ID2D1Device1> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device1> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Device1> for ID2D1Device {
    fn from(value: ID2D1Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device1> for ID2D1Device {
    fn from(value: &ID2D1Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for ID2D1Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for &ID2D1Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device1> for ID2D1Resource {
    fn from(value: ID2D1Device1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device1> for ID2D1Resource {
    fn from(value: &ID2D1Device1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Device1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicfactory: ::windows::runtime::RawPtr,
        documenttarget: ::windows::runtime::RawPtr,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
        printcontrol: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, millisecondssinceuse: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_RENDERING_PRIORITY,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingpriority: D2D1_RENDERING_PRIORITY,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Device2(::windows::runtime::IUnknown);
impl ID2D1Device2 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn CreateDeviceContext(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext> {
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub unsafe fn CreatePrintControl<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICImagingFactory>,
        Param1: ::windows::runtime::IntoParam<
            'a,
            super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget,
        >,
    >(
        &self,
        wicfactory: Param0,
        documenttarget: Param1,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1PrintControl> {
        let mut result__: <ID2D1PrintControl as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicfactory.into_param().abi(),
            documenttarget.into_param().abi(),
            ::std::mem::transmute(printcontrolproperties),
            &mut result__,
        )
        .from_abi::<ID2D1PrintControl>(result__)
    }
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(millisecondssinceuse),
        ))
    }
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingpriority),
        ))
    }
    pub unsafe fn CreateDeviceContext2(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext1> {
        let mut result__: <ID2D1DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext1>(result__)
    }
    pub unsafe fn CreateDeviceContext3(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext2> {
        let mut result__: <ID2D1DeviceContext2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext2>(result__)
    }
    pub unsafe fn FlushDeviceContexts<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        bitmap: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::runtime::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: <super::Dxgi::IDXGIDevice as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Device2 {
    type Vtable = ID2D1Device2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2755949281,
        36347,
        20064,
        [132, 146, 110, 40, 97, 201, 202, 139],
    );
}
impl ::std::convert::From<ID2D1Device2> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device2> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Device2> for ID2D1Device1 {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device2> for ID2D1Device1 {
    fn from(value: &ID2D1Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device2> for ID2D1Device {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device2> for ID2D1Device {
    fn from(value: &ID2D1Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device2> for ID2D1Resource {
    fn from(value: ID2D1Device2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device2> for ID2D1Resource {
    fn from(value: &ID2D1Device2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Device2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicfactory: ::windows::runtime::RawPtr,
        documenttarget: ::windows::runtime::RawPtr,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
        printcontrol: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, millisecondssinceuse: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_RENDERING_PRIORITY,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingpriority: D2D1_RENDERING_PRIORITY,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext2: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dxgidevice: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Device3(::windows::runtime::IUnknown);
impl ID2D1Device3 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn CreateDeviceContext(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext> {
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub unsafe fn CreatePrintControl<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICImagingFactory>,
        Param1: ::windows::runtime::IntoParam<
            'a,
            super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget,
        >,
    >(
        &self,
        wicfactory: Param0,
        documenttarget: Param1,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1PrintControl> {
        let mut result__: <ID2D1PrintControl as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicfactory.into_param().abi(),
            documenttarget.into_param().abi(),
            ::std::mem::transmute(printcontrolproperties),
            &mut result__,
        )
        .from_abi::<ID2D1PrintControl>(result__)
    }
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(millisecondssinceuse),
        ))
    }
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingpriority),
        ))
    }
    pub unsafe fn CreateDeviceContext2(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext1> {
        let mut result__: <ID2D1DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext1>(result__)
    }
    pub unsafe fn CreateDeviceContext3(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext2> {
        let mut result__: <ID2D1DeviceContext2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext2>(result__)
    }
    pub unsafe fn FlushDeviceContexts<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        bitmap: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::runtime::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: <super::Dxgi::IDXGIDevice as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    pub unsafe fn CreateDeviceContext4(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext3> {
        let mut result__: <ID2D1DeviceContext3 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext3>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Device3 {
    type Vtable = ID2D1Device3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2234458247,
        32812,
        16439,
        [171, 96, 255, 46, 126, 230, 252, 1],
    );
}
impl ::std::convert::From<ID2D1Device3> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device3> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Device3> for ID2D1Device2 {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device3> for ID2D1Device2 {
    fn from(value: &ID2D1Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device3> for ID2D1Device1 {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device3> for ID2D1Device1 {
    fn from(value: &ID2D1Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device3> for ID2D1Device {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device3> for ID2D1Device {
    fn from(value: &ID2D1Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device3> for ID2D1Resource {
    fn from(value: ID2D1Device3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device3> for ID2D1Resource {
    fn from(value: &ID2D1Device3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Device3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicfactory: ::windows::runtime::RawPtr,
        documenttarget: ::windows::runtime::RawPtr,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
        printcontrol: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, millisecondssinceuse: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_RENDERING_PRIORITY,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingpriority: D2D1_RENDERING_PRIORITY,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext2: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dxgidevice: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext3: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Device4(::windows::runtime::IUnknown);
impl ID2D1Device4 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn CreateDeviceContext(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext> {
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub unsafe fn CreatePrintControl<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICImagingFactory>,
        Param1: ::windows::runtime::IntoParam<
            'a,
            super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget,
        >,
    >(
        &self,
        wicfactory: Param0,
        documenttarget: Param1,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1PrintControl> {
        let mut result__: <ID2D1PrintControl as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicfactory.into_param().abi(),
            documenttarget.into_param().abi(),
            ::std::mem::transmute(printcontrolproperties),
            &mut result__,
        )
        .from_abi::<ID2D1PrintControl>(result__)
    }
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(millisecondssinceuse),
        ))
    }
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingpriority),
        ))
    }
    pub unsafe fn CreateDeviceContext2(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext1> {
        let mut result__: <ID2D1DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext1>(result__)
    }
    pub unsafe fn CreateDeviceContext3(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext2> {
        let mut result__: <ID2D1DeviceContext2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext2>(result__)
    }
    pub unsafe fn FlushDeviceContexts<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        bitmap: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::runtime::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: <super::Dxgi::IDXGIDevice as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    pub unsafe fn CreateDeviceContext4(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext3> {
        let mut result__: <ID2D1DeviceContext3 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext3>(result__)
    }
    pub unsafe fn CreateDeviceContext5(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext4> {
        let mut result__: <ID2D1DeviceContext4 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext4>(result__)
    }
    pub unsafe fn SetMaximumColorGlyphCacheMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumColorGlyphCacheMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Device4 {
    type Vtable = ID2D1Device4_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3619533145,
        22147,
        19014,
        [188, 156, 114, 220, 114, 11, 133, 139],
    );
}
impl ::std::convert::From<ID2D1Device4> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device4> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Device4> for ID2D1Device3 {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device4> for ID2D1Device3 {
    fn from(value: &ID2D1Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device3> for ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device3> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device4> for ID2D1Device2 {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device4> for ID2D1Device2 {
    fn from(value: &ID2D1Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device4> for ID2D1Device1 {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device4> for ID2D1Device1 {
    fn from(value: &ID2D1Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device4> for ID2D1Device {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device4> for ID2D1Device {
    fn from(value: &ID2D1Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device4> for ID2D1Resource {
    fn from(value: ID2D1Device4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device4> for ID2D1Resource {
    fn from(value: &ID2D1Device4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Device4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device4_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicfactory: ::windows::runtime::RawPtr,
        documenttarget: ::windows::runtime::RawPtr,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
        printcontrol: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, millisecondssinceuse: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_RENDERING_PRIORITY,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingpriority: D2D1_RENDERING_PRIORITY,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext2: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dxgidevice: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext3: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext4: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Device5(::windows::runtime::IUnknown);
impl ID2D1Device5 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn CreateDeviceContext(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext> {
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub unsafe fn CreatePrintControl<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICImagingFactory>,
        Param1: ::windows::runtime::IntoParam<
            'a,
            super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget,
        >,
    >(
        &self,
        wicfactory: Param0,
        documenttarget: Param1,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1PrintControl> {
        let mut result__: <ID2D1PrintControl as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicfactory.into_param().abi(),
            documenttarget.into_param().abi(),
            ::std::mem::transmute(printcontrolproperties),
            &mut result__,
        )
        .from_abi::<ID2D1PrintControl>(result__)
    }
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(millisecondssinceuse),
        ))
    }
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingpriority),
        ))
    }
    pub unsafe fn CreateDeviceContext2(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext1> {
        let mut result__: <ID2D1DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext1>(result__)
    }
    pub unsafe fn CreateDeviceContext3(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext2> {
        let mut result__: <ID2D1DeviceContext2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext2>(result__)
    }
    pub unsafe fn FlushDeviceContexts<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        bitmap: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::runtime::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: <super::Dxgi::IDXGIDevice as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    pub unsafe fn CreateDeviceContext4(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext3> {
        let mut result__: <ID2D1DeviceContext3 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext3>(result__)
    }
    pub unsafe fn CreateDeviceContext5(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext4> {
        let mut result__: <ID2D1DeviceContext4 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext4>(result__)
    }
    pub unsafe fn SetMaximumColorGlyphCacheMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumColorGlyphCacheMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn CreateDeviceContext6(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext5> {
        let mut result__: <ID2D1DeviceContext5 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext5>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Device5 {
    type Vtable = ID2D1Device5_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3579551908,
        25605,
        18068,
        [174, 245, 8, 238, 26, 67, 88, 180],
    );
}
impl ::std::convert::From<ID2D1Device5> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device5> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Device5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Device5> for ID2D1Device4 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device5> for ID2D1Device4 {
    fn from(value: &ID2D1Device5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device4> for ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device4>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device4> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device4>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device5> for ID2D1Device3 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device5> for ID2D1Device3 {
    fn from(value: &ID2D1Device5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device3> for ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device3> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device5> for ID2D1Device2 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device5> for ID2D1Device2 {
    fn from(value: &ID2D1Device5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device5> for ID2D1Device1 {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device5> for ID2D1Device1 {
    fn from(value: &ID2D1Device5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device5> for ID2D1Device {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device5> for ID2D1Device {
    fn from(value: &ID2D1Device5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device5> for ID2D1Resource {
    fn from(value: ID2D1Device5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device5> for ID2D1Resource {
    fn from(value: &ID2D1Device5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Device5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device5_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicfactory: ::windows::runtime::RawPtr,
        documenttarget: ::windows::runtime::RawPtr,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
        printcontrol: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, millisecondssinceuse: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_RENDERING_PRIORITY,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingpriority: D2D1_RENDERING_PRIORITY,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext2: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dxgidevice: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext3: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext4: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext5: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1Device6(::windows::runtime::IUnknown);
impl ID2D1Device6 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    pub unsafe fn CreateDeviceContext(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext> {
        let mut result__: <ID2D1DeviceContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub unsafe fn CreatePrintControl<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICImagingFactory>,
        Param1: ::windows::runtime::IntoParam<
            'a,
            super::super::Storage::Xps::Printing::IPrintDocumentPackageTarget,
        >,
    >(
        &self,
        wicfactory: Param0,
        documenttarget: Param1,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1PrintControl> {
        let mut result__: <ID2D1PrintControl as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicfactory.into_param().abi(),
            documenttarget.into_param().abi(),
            ::std::mem::transmute(printcontrolproperties),
            &mut result__,
        )
        .from_abi::<ID2D1PrintControl>(result__)
    }
    pub unsafe fn SetMaximumTextureMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumTextureMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn ClearResources(&self, millisecondssinceuse: u32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(millisecondssinceuse),
        ))
    }
    pub unsafe fn GetRenderingPriority(&self) -> D2D1_RENDERING_PRIORITY {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetRenderingPriority(&self, renderingpriority: D2D1_RENDERING_PRIORITY) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingpriority),
        ))
    }
    pub unsafe fn CreateDeviceContext2(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext1> {
        let mut result__: <ID2D1DeviceContext1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext1>(result__)
    }
    pub unsafe fn CreateDeviceContext3(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext2> {
        let mut result__: <ID2D1DeviceContext2 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext2>(result__)
    }
    pub unsafe fn FlushDeviceContexts<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
    >(
        &self,
        bitmap: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetDxgiDevice(&self) -> ::windows::runtime::Result<super::Dxgi::IDXGIDevice> {
        let mut result__: <super::Dxgi::IDXGIDevice as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Dxgi::IDXGIDevice>(result__)
    }
    pub unsafe fn CreateDeviceContext4(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext3> {
        let mut result__: <ID2D1DeviceContext3 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext3>(result__)
    }
    pub unsafe fn CreateDeviceContext5(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext4> {
        let mut result__: <ID2D1DeviceContext4 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext4>(result__)
    }
    pub unsafe fn SetMaximumColorGlyphCacheMemory(&self, maximuminbytes: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maximuminbytes),
        ))
    }
    pub unsafe fn GetMaximumColorGlyphCacheMemory(&self) -> u64 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn CreateDeviceContext6(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext5> {
        let mut result__: <ID2D1DeviceContext5 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext5>(result__)
    }
    pub unsafe fn CreateDeviceContext7(
        &self,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1DeviceContext6> {
        let mut result__: <ID2D1DeviceContext6 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1DeviceContext6>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1Device6 {
    type Vtable = ID2D1Device6_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2080307476,
        11637,
        19373,
        [190, 135, 225, 141, 219, 7, 123, 109],
    );
}
impl ::std::convert::From<ID2D1Device6> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1Device6> for ID2D1Device5 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ID2D1Device5 {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device5> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device5> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device5>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device5> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device5> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device5>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device6> for ID2D1Device4 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ID2D1Device4 {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device4> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device4>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device4> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device4>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device6> for ID2D1Device3 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ID2D1Device3 {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device3> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device3> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device6> for ID2D1Device2 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ID2D1Device2 {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device2> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device6> for ID2D1Device1 {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ID2D1Device1 {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device1> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device1> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device1>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device6> for ID2D1Device {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ID2D1Device {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Device> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Device> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Device>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1Device6> for ID2D1Resource {
    fn from(value: ID2D1Device6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1Device6> for ID2D1Resource {
    fn from(value: &ID2D1Device6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1Device6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1Device6_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicfactory: ::windows::runtime::RawPtr,
        documenttarget: ::windows::runtime::RawPtr,
        printcontrolproperties: *const D2D1_PRINT_CONTROL_PROPERTIES,
        printcontrol: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Imaging",
        feature = "Win32_Storage_Xps_Printing"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, millisecondssinceuse: u32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_RENDERING_PRIORITY,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingpriority: D2D1_RENDERING_PRIORITY,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext2: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dxgidevice: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext3: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext4: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, maximuminbytes: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u64,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext5: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        options: D2D1_DEVICE_CONTEXT_OPTIONS,
        devicecontext6: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1DeviceContext(::windows::runtime::IUnknown);
impl ID2D1DeviceContext {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, D2D_SIZE_U>>(
        &self,
        size: Param0,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            size.into_param().abi(),
            ::std::mem::transmute(srcdata),
            ::std::mem::transmute(pitch),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICBitmapSource>,
    >(
        &self,
        wicbitmapsource: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicbitmapsource.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateSharedBitmap(
        &self,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::std::option::Option<ID2D1Bitmap>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(data),
            ::std::mem::transmute(bitmapproperties),
            ::std::mem::transmute(bitmap),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1BitmapBrush> {
        let mut result__: <ID2D1BitmapBrush as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(bitmapbrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateSolidColorBrush(
        &self,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1SolidColorBrush> {
        let mut result__: <ID2D1SolidColorBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1SolidColorBrush>(result__)
    }
    pub unsafe fn CreateGradientStopCollection(
        &self,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
    ) -> ::windows::runtime::Result<ID2D1GradientStopCollection> {
        let mut result__: <ID2D1GradientStopCollection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(gradientstops),
            ::std::mem::transmute(gradientstopscount),
            ::std::mem::transmute(colorinterpolationgamma),
            ::std::mem::transmute(extendmode),
            &mut result__,
        )
        .from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateLinearGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1LinearGradientBrush> {
        let mut result__: <ID2D1LinearGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lineargradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateRadialGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1RadialGradientBrush> {
        let mut result__: <ID2D1RadialGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(radialgradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCompatibleRenderTarget(
        &self,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1BitmapRenderTarget> {
        let mut result__: <ID2D1BitmapRenderTarget as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(desiredsize),
            ::std::mem::transmute(desiredpixelsize),
            ::std::mem::transmute(desiredformat),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    pub unsafe fn CreateLayer(
        &self,
        size: *const D2D_SIZE_F,
    ) -> ::windows::runtime::Result<ID2D1Layer> {
        let mut result__: <ID2D1Layer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(size),
            &mut result__,
        )
        .from_abi::<ID2D1Layer>(result__)
    }
    pub unsafe fn CreateMesh(&self) -> ::windows::runtime::Result<ID2D1Mesh> {
        let mut result__: <ID2D1Mesh as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID2D1Mesh>(result__)
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawEllipse<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillEllipse<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        ))
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(content),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        string: Param0,
        stringlength: u32,
        textformat: Param2,
        layoutrect: *const D2D_RECT_F,
        defaultfillbrush: Param4,
        options: D2D1_DRAW_TEXT_OPTIONS,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            string.into_param().abi(),
            ::std::mem::transmute(stringlength),
            textformat.into_param().abi(),
            ::std::mem::transmute(layoutrect),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn DrawTextLayout<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        origin: Param0,
        textlayout: Param1,
        defaultfillbrush: Param2,
        options: D2D1_DRAW_TEXT_OPTIONS,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            origin.into_param().abi(),
            textlayout.into_param().abi(),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        foregroundbrush: Param2,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(
        &self,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        ))
    }
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(
        &self,
        textrenderingparams: *mut ::std::option::Option<super::DirectWrite::IDWriteRenderingParams>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textrenderingparams),
        ))
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters: *const D2D1_LAYER_PARAMETERS,
        layer: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters),
            layer.into_param().abi(),
        ))
    }
    pub unsafe fn PopLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SaveDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn RestoreDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn PopAxisAlignedClip(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Clear(&self, clearcolor: *const D2D1_COLOR_F) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(clearcolor),
        ))
    }
    pub unsafe fn BeginDraw(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetPixelFormat(&self) -> D2D1_PIXEL_FORMAT {
        let mut result__: D2D1_PIXEL_FORMAT = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetSize(&self) -> D2D_SIZE_F {
        let mut result__: D2D_SIZE_F = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetPixelSize(&self) -> D2D_SIZE_U {
        let mut result__: D2D_SIZE_U = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn IsSupported(
        &self,
        rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rendertargetproperties),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmap2<'a, Param0: ::windows::runtime::IntoParam<'a, D2D_SIZE_U>>(
        &self,
        size: Param0,
        sourcedata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES1,
    ) -> ::windows::runtime::Result<ID2D1Bitmap1> {
        let mut result__: <ID2D1Bitmap1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            size.into_param().abi(),
            ::std::mem::transmute(sourcedata),
            ::std::mem::transmute(pitch),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap1>(result__)
    }
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICBitmapSource>,
    >(
        &self,
        wicbitmapsource: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES1,
    ) -> ::windows::runtime::Result<ID2D1Bitmap1> {
        let mut result__: <ID2D1Bitmap1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            wicbitmapsource.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap1>(result__)
    }
    pub unsafe fn CreateColorContext(
        &self,
        space: D2D1_COLOR_SPACE,
        profile: *const u8,
        profilesize: u32,
    ) -> ::windows::runtime::Result<ID2D1ColorContext> {
        let mut result__: <ID2D1ColorContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(space),
            ::std::mem::transmute(profile),
            ::std::mem::transmute(profilesize),
            &mut result__,
        )
        .from_abi::<ID2D1ColorContext>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateColorContextFromFilename<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        filename: Param0,
    ) -> ::windows::runtime::Result<ID2D1ColorContext> {
        let mut result__: <ID2D1ColorContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            filename.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1ColorContext>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub unsafe fn CreateColorContextFromWicColorContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICColorContext>,
    >(
        &self,
        wiccolorcontext: Param0,
    ) -> ::windows::runtime::Result<ID2D1ColorContext> {
        let mut result__: <ID2D1ColorContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            wiccolorcontext.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1ColorContext>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmapFromDxgiSurface<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGISurface>,
    >(
        &self,
        surface: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES1,
    ) -> ::windows::runtime::Result<ID2D1Bitmap1> {
        let mut result__: <ID2D1Bitmap1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            surface.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap1>(result__)
    }
    pub unsafe fn CreateEffect(
        &self,
        effectid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<ID2D1Effect> {
        let mut result__: <ID2D1Effect as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(effectid),
            &mut result__,
        )
        .from_abi::<ID2D1Effect>(result__)
    }
    pub unsafe fn CreateGradientStopCollection2(
        &self,
        straightalphagradientstops: *const D2D1_GRADIENT_STOP,
        straightalphagradientstopscount: u32,
        preinterpolationspace: D2D1_COLOR_SPACE,
        postinterpolationspace: D2D1_COLOR_SPACE,
        bufferprecision: D2D1_BUFFER_PRECISION,
        extendmode: D2D1_EXTEND_MODE,
        colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE,
    ) -> ::windows::runtime::Result<ID2D1GradientStopCollection1> {
        let mut result__: <ID2D1GradientStopCollection1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(straightalphagradientstops),
            ::std::mem::transmute(straightalphagradientstopscount),
            ::std::mem::transmute(preinterpolationspace),
            ::std::mem::transmute(postinterpolationspace),
            ::std::mem::transmute(bufferprecision),
            ::std::mem::transmute(extendmode),
            ::std::mem::transmute(colorinterpolationmode),
            &mut result__,
        )
        .from_abi::<ID2D1GradientStopCollection1>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateImageBrush<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1ImageBrush> {
        let mut result__: <ID2D1ImageBrush as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(imagebrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1ImageBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush2<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1BitmapBrush1> {
        let mut result__: <ID2D1BitmapBrush1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(bitmapbrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapBrush1>(result__)
    }
    pub unsafe fn CreateCommandList(&self) -> ::windows::runtime::Result<ID2D1CommandList> {
        let mut result__: <ID2D1CommandList as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID2D1CommandList>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn IsDxgiFormatSupported(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsBufferPrecisionSupported(
        &self,
        bufferprecision: D2D1_BUFFER_PRECISION,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bufferprecision),
        ))
    }
    pub unsafe fn GetImageLocalBounds<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
    ) -> ::windows::runtime::Result<D2D_RECT_F> {
        let mut result__: <D2D_RECT_F as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            &mut result__,
        )
        .from_abi::<D2D_RECT_F>(result__)
    }
    pub unsafe fn GetImageWorldBounds<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
    ) -> ::windows::runtime::Result<D2D_RECT_F> {
        let mut result__: <D2D_RECT_F as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            &mut result__,
        )
        .from_abi::<D2D_RECT_F>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn GetGlyphRunWorldBounds<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<D2D_RECT_F> {
        let mut result__: <D2D_RECT_F as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(measuringmode),
            &mut result__,
        )
        .from_abi::<D2D_RECT_F>(result__)
    }
    pub unsafe fn GetDevice(&self, device: *mut ::std::option::Option<ID2D1Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(device),
        ))
    }
    pub unsafe fn SetTarget<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
        ))
    }
    pub unsafe fn GetTarget(&self, image: *mut ::std::option::Option<ID2D1Image>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(image),
        ))
    }
    pub unsafe fn SetRenderingControls(&self, renderingcontrols: *const D2D1_RENDERING_CONTROLS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).76)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingcontrols),
        ))
    }
    pub unsafe fn GetRenderingControls(&self, renderingcontrols: *mut D2D1_RENDERING_CONTROLS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingcontrols),
        ))
    }
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).78)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        ))
    }
    pub unsafe fn GetPrimitiveBlend(&self) -> D2D1_PRIMITIVE_BLEND {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        ))
    }
    pub unsafe fn GetUnitMode(&self) -> D2D1_UNIT_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        ))
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        ))
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        ))
    }
    pub unsafe fn DrawBitmap2<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer2<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters),
            layer.into_param().abi(),
        ))
    }
    pub unsafe fn InvalidateEffectInputRectangle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        effect: Param0,
        input: u32,
        inputrectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            effect.into_param().abi(),
            ::std::mem::transmute(input),
            ::std::mem::transmute(inputrectangle),
        )
        .ok()
    }
    pub unsafe fn GetEffectInvalidRectangleCount<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        effect: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            effect.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetEffectInvalidRectangles<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        effect: Param0,
        rectangles: *mut D2D_RECT_F,
        rectanglescount: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            effect.into_param().abi(),
            ::std::mem::transmute(rectangles),
            ::std::mem::transmute(rectanglescount),
        )
        .ok()
    }
    pub unsafe fn GetEffectRequiredInputRectangles<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        rendereffect: Param0,
        renderimagerectangle: *const D2D_RECT_F,
        inputdescriptions: *const D2D1_EFFECT_INPUT_DESCRIPTION,
        requiredinputrects: *mut D2D_RECT_F,
        inputcount: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).90)(
            ::std::mem::transmute_copy(self),
            rendereffect.into_param().abi(),
            ::std::mem::transmute(renderimagerectangle),
            ::std::mem::transmute(inputdescriptions),
            ::std::mem::transmute(requiredinputrects),
            ::std::mem::transmute(inputcount),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).91)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1DeviceContext {
    type Vtable = ID2D1DeviceContext_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3908566650,
        6428,
        18029,
        [173, 149, 151, 86, 120, 189, 169, 152],
    );
}
impl ::std::convert::From<ID2D1DeviceContext> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1DeviceContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DeviceContext> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1DeviceContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1DeviceContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1DeviceContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1DeviceContext> for ID2D1RenderTarget {
    fn from(value: ID2D1DeviceContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DeviceContext> for ID2D1RenderTarget {
    fn from(value: &ID2D1DeviceContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for ID2D1DeviceContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DeviceContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1DeviceContext> for ID2D1Resource {
    fn from(value: ID2D1DeviceContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DeviceContext> for ID2D1Resource {
    fn from(value: &ID2D1DeviceContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1DeviceContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1DeviceContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DeviceContext_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: D2D_SIZE_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicbitmapsource: ::windows::runtime::RawPtr,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging")))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        bitmapbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        solidcolorbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
        gradientstopcollection: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        lineargradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        radialgradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
        bitmaprendertarget: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: *const D2D_SIZE_F,
        layer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ),
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        string: super::super::Foundation::PWSTR,
        stringlength: u32,
        textformat: ::windows::runtime::RawPtr,
        layoutrect: *const D2D_RECT_F,
        defaultfillbrush: ::windows::runtime::RawPtr,
        options: D2D1_DRAW_TEXT_OPTIONS,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        origin: D2D_POINT_2F,
        textlayout: ::windows::runtime::RawPtr,
        defaultfillbrush: ::windows::runtime::RawPtr,
        options: D2D1_DRAW_TEXT_OPTIONS,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_ANTIALIAS_MODE,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_TEXT_ANTIALIAS_MODE,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        textrenderingparams: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Win32_Graphics_DirectWrite"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tag1: u64, tag2: u64),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, tag1: *mut u64, tag2: *mut u64),
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS>,
        layer: ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: *mut u64,
        tag2: *mut u64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        drawingstateblock: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        drawingstateblock: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, clearcolor: *const D2D1_COLOR_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        tag1: *mut u64,
        tag2: *mut u64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        result__: *mut D2D1_PIXEL_FORMAT,
    ),
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: f32, dpiy: f32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, dpix: *mut f32, dpiy: *mut f32),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_F),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, result__: *mut D2D_SIZE_U),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES,
    ) -> super::super::Foundation::BOOL,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: D2D_SIZE_U,
        sourcedata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const ::std::mem::ManuallyDrop<D2D1_BITMAP_PROPERTIES1>,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicbitmapsource: ::windows::runtime::RawPtr,
        bitmapproperties: *const ::std::mem::ManuallyDrop<D2D1_BITMAP_PROPERTIES1>,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        space: D2D1_COLOR_SPACE,
        profile: *const u8,
        profilesize: u32,
        colorcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        filename: super::super::Foundation::PWSTR,
        colorcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wiccolorcontext: ::windows::runtime::RawPtr,
        colorcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Imaging"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        surface: ::windows::runtime::RawPtr,
        bitmapproperties: *const ::std::mem::ManuallyDrop<D2D1_BITMAP_PROPERTIES1>,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        effectid: *const ::windows::runtime::GUID,
        effect: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        straightalphagradientstops: *const D2D1_GRADIENT_STOP,
        straightalphagradientstopscount: u32,
        preinterpolationspace: D2D1_COLOR_SPACE,
        postinterpolationspace: D2D1_COLOR_SPACE,
        bufferprecision: D2D1_BUFFER_PRECISION,
        extendmode: D2D1_EXTEND_MODE,
        colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE,
        gradientstopcollection1: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        imagebrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        bitmapbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        commandlist: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        format: super::Dxgi::DXGI_FORMAT,
    ) -> super::super::Foundation::BOOL,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bufferprecision: D2D1_BUFFER_PRECISION,
    ) -> super::super::Foundation::BOOL,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        localbounds: *mut D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        worldbounds: *mut D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
        bounds: *mut D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        device: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: *mut ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingcontrols: *const D2D1_RENDERING_CONTROLS,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        renderingcontrols: *mut D2D1_RENDERING_CONTROLS,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        primitiveblend: D2D1_PRIMITIVE_BLEND,
    ),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_PRIMITIVE_BLEND,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr, unitmode: D2D1_UNIT_MODE),
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> D2D1_UNIT_MODE,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        baselineorigin: D2D_POINT_2F,
        glyphrun: *const ::std::mem::ManuallyDrop<super::DirectWrite::DWRITE_GLYPH_RUN>,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: ::windows::runtime::RawPtr,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ),
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        image: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gdimetafile: ::windows::runtime::RawPtr,
        targetoffset: *const D2D_POINT_2F,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ),
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        layerparameters: *const ::std::mem::ManuallyDrop<D2D1_LAYER_PARAMETERS1>,
        layer: ::windows::runtime::RawPtr,
    ),
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        effect: ::windows::runtime::RawPtr,
        input: u32,
        inputrectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        effect: ::windows::runtime::RawPtr,
        rectanglecount: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        effect: ::windows::runtime::RawPtr,
        rectangles: *mut D2D_RECT_F,
        rectanglescount: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rendereffect: ::windows::runtime::RawPtr,
        renderimagerectangle: *const D2D_RECT_F,
        inputdescriptions: *const ::std::mem::ManuallyDrop<D2D1_EFFECT_INPUT_DESCRIPTION>,
        requiredinputrects: *mut D2D_RECT_F,
        inputcount: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ),
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ID2D1DeviceContext1(::windows::runtime::IUnknown);
impl ID2D1DeviceContext1 {
    pub unsafe fn GetFactory(&self, factory: *mut ::std::option::Option<ID2D1Factory>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(factory),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, D2D_SIZE_U>>(
        &self,
        size: Param0,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            size.into_param().abi(),
            ::std::mem::transmute(srcdata),
            ::std::mem::transmute(pitch),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICBitmapSource>,
    >(
        &self,
        wicbitmapsource: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1Bitmap> {
        let mut result__: <ID2D1Bitmap as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            wicbitmapsource.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateSharedBitmap(
        &self,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::std::option::Option<ID2D1Bitmap>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(data),
            ::std::mem::transmute(bitmapproperties),
            ::std::mem::transmute(bitmap),
        )
        .ok()
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1BitmapBrush> {
        let mut result__: <ID2D1BitmapBrush as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(bitmapbrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateSolidColorBrush(
        &self,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1SolidColorBrush> {
        let mut result__: <ID2D1SolidColorBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(color),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1SolidColorBrush>(result__)
    }
    pub unsafe fn CreateGradientStopCollection(
        &self,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
    ) -> ::windows::runtime::Result<ID2D1GradientStopCollection> {
        let mut result__: <ID2D1GradientStopCollection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(gradientstops),
            ::std::mem::transmute(gradientstopscount),
            ::std::mem::transmute(colorinterpolationgamma),
            ::std::mem::transmute(extendmode),
            &mut result__,
        )
        .from_abi::<ID2D1GradientStopCollection>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateLinearGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1LinearGradientBrush> {
        let mut result__: <ID2D1LinearGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lineargradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1LinearGradientBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateRadialGradientBrush<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1GradientStopCollection>,
    >(
        &self,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: Param2,
    ) -> ::windows::runtime::Result<ID2D1RadialGradientBrush> {
        let mut result__: <ID2D1RadialGradientBrush as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(radialgradientbrushproperties),
            ::std::mem::transmute(brushproperties),
            gradientstopcollection.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1RadialGradientBrush>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateCompatibleRenderTarget(
        &self,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
    ) -> ::windows::runtime::Result<ID2D1BitmapRenderTarget> {
        let mut result__: <ID2D1BitmapRenderTarget as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(desiredsize),
            ::std::mem::transmute(desiredpixelsize),
            ::std::mem::transmute(desiredformat),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapRenderTarget>(result__)
    }
    pub unsafe fn CreateLayer(
        &self,
        size: *const D2D_SIZE_F,
    ) -> ::windows::runtime::Result<ID2D1Layer> {
        let mut result__: <ID2D1Layer as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(size),
            &mut result__,
        )
        .from_abi::<ID2D1Layer>(result__)
    }
    pub unsafe fn CreateMesh(&self) -> ::windows::runtime::Result<ID2D1Mesh> {
        let mut result__: <ID2D1Mesh as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID2D1Mesh>(result__)
    }
    pub unsafe fn DrawLine<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        point0: Param0,
        point1: Param1,
        brush: Param2,
        strokewidth: f32,
        strokestyle: Param4,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            point0.into_param().abi(),
            point1.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRectangle<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        rect: *const D2D_RECT_F,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillRoundedRectangle<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(roundedrect),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawEllipse<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillEllipse<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>>(
        &self,
        ellipse: *const D2D1_ELLIPSE,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ellipse),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn DrawGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        strokewidth: f32,
        strokestyle: Param3,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
        ))
    }
    pub unsafe fn FillGeometry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometry: Param0,
        brush: Param1,
        opacitybrush: Param2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            brush.into_param().abi(),
            opacitybrush.into_param().abi(),
        ))
    }
    pub unsafe fn FillMesh<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Mesh>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        mesh: Param0,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            mesh.into_param().abi(),
            brush.into_param().abi(),
        ))
    }
    pub unsafe fn FillOpacityMask<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(content),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    pub unsafe fn DrawBitmap<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawText<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextFormat>,
        Param4: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        string: Param0,
        stringlength: u32,
        textformat: Param2,
        layoutrect: *const D2D_RECT_F,
        defaultfillbrush: Param4,
        options: D2D1_DRAW_TEXT_OPTIONS,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            string.into_param().abi(),
            ::std::mem::transmute(stringlength),
            textformat.into_param().abi(),
            ::std::mem::transmute(layoutrect),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn DrawTextLayout<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param1: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteTextLayout>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        origin: Param0,
        textlayout: Param1,
        defaultfillbrush: Param2,
        options: D2D1_DRAW_TEXT_OPTIONS,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            origin.into_param().abi(),
            textlayout.into_param().abi(),
            defaultfillbrush.into_param().abi(),
            ::std::mem::transmute(options),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param2: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        foregroundbrush: Param2,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn SetTransform(
        &self,
        transform: *const super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn GetTransform(
        &self,
        transform: *mut super::super::super::Foundation::Numerics::Matrix3x2,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(transform),
        ))
    }
    pub unsafe fn SetAntialiasMode(&self, antialiasmode: D2D1_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn GetAntialiasMode(&self) -> D2D1_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetTextAntialiasMode(&self, textantialiasmode: D2D1_TEXT_ANTIALIAS_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textantialiasmode),
        ))
    }
    pub unsafe fn GetTextAntialiasMode(&self) -> D2D1_TEXT_ANTIALIAS_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn SetTextRenderingParams<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::DirectWrite::IDWriteRenderingParams>,
    >(
        &self,
        textrenderingparams: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            textrenderingparams.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Graphics_DirectWrite")]
    pub unsafe fn GetTextRenderingParams(
        &self,
        textrenderingparams: *mut ::std::option::Option<super::DirectWrite::IDWriteRenderingParams>,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(textrenderingparams),
        ))
    }
    pub unsafe fn SetTags(&self, tag1: u64, tag2: u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    pub unsafe fn GetTags(&self, tag1: *mut u64, tag2: *mut u64) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters: *const D2D1_LAYER_PARAMETERS,
        layer: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters),
            layer.into_param().abi(),
        ))
    }
    pub unsafe fn PopLayer(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Flush(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    pub unsafe fn SaveDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn RestoreDrawingState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1DrawingStateBlock>,
    >(
        &self,
        drawingstateblock: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            drawingstateblock.into_param().abi(),
        ))
    }
    pub unsafe fn PushAxisAlignedClip(
        &self,
        cliprect: *const D2D_RECT_F,
        antialiasmode: D2D1_ANTIALIAS_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cliprect),
            ::std::mem::transmute(antialiasmode),
        ))
    }
    pub unsafe fn PopAxisAlignedClip(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn Clear(&self, clearcolor: *const D2D1_COLOR_F) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(clearcolor),
        ))
    }
    pub unsafe fn BeginDraw(&self) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn EndDraw(&self, tag1: *mut u64, tag2: *mut u64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(tag1),
            ::std::mem::transmute(tag2),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn GetPixelFormat(&self) -> D2D1_PIXEL_FORMAT {
        let mut result__: D2D1_PIXEL_FORMAT = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn SetDpi(&self, dpix: f32, dpiy: f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetDpi(&self, dpix: *mut f32, dpiy: *mut f32) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        ))
    }
    pub unsafe fn GetSize(&self) -> D2D_SIZE_F {
        let mut result__: D2D_SIZE_F = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetPixelSize(&self) -> D2D_SIZE_U {
        let mut result__: D2D_SIZE_U = ::std::default::Default::default();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        );
        result__
    }
    pub unsafe fn GetMaximumBitmapSize(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn IsSupported(
        &self,
        rendertargetproperties: *const D2D1_RENDER_TARGET_PROPERTIES,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rendertargetproperties),
        ))
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmap2<'a, Param0: ::windows::runtime::IntoParam<'a, D2D_SIZE_U>>(
        &self,
        size: Param0,
        sourcedata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES1,
    ) -> ::windows::runtime::Result<ID2D1Bitmap1> {
        let mut result__: <ID2D1Bitmap1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            size.into_param().abi(),
            ::std::mem::transmute(sourcedata),
            ::std::mem::transmute(pitch),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap1>(result__)
    }
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub unsafe fn CreateBitmapFromWicBitmap2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICBitmapSource>,
    >(
        &self,
        wicbitmapsource: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES1,
    ) -> ::windows::runtime::Result<ID2D1Bitmap1> {
        let mut result__: <ID2D1Bitmap1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            wicbitmapsource.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap1>(result__)
    }
    pub unsafe fn CreateColorContext(
        &self,
        space: D2D1_COLOR_SPACE,
        profile: *const u8,
        profilesize: u32,
    ) -> ::windows::runtime::Result<ID2D1ColorContext> {
        let mut result__: <ID2D1ColorContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(space),
            ::std::mem::transmute(profile),
            ::std::mem::transmute(profilesize),
            &mut result__,
        )
        .from_abi::<ID2D1ColorContext>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateColorContextFromFilename<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        filename: Param0,
    ) -> ::windows::runtime::Result<ID2D1ColorContext> {
        let mut result__: <ID2D1ColorContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            filename.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1ColorContext>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Imaging")]
    pub unsafe fn CreateColorContextFromWicColorContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Imaging::IWICColorContext>,
    >(
        &self,
        wiccolorcontext: Param0,
    ) -> ::windows::runtime::Result<ID2D1ColorContext> {
        let mut result__: <ID2D1ColorContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            wiccolorcontext.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1ColorContext>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn CreateBitmapFromDxgiSurface<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGISurface>,
    >(
        &self,
        surface: Param0,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES1,
    ) -> ::windows::runtime::Result<ID2D1Bitmap1> {
        let mut result__: <ID2D1Bitmap1 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            surface.into_param().abi(),
            ::std::mem::transmute(bitmapproperties),
            &mut result__,
        )
        .from_abi::<ID2D1Bitmap1>(result__)
    }
    pub unsafe fn CreateEffect(
        &self,
        effectid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<ID2D1Effect> {
        let mut result__: <ID2D1Effect as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(effectid),
            &mut result__,
        )
        .from_abi::<ID2D1Effect>(result__)
    }
    pub unsafe fn CreateGradientStopCollection2(
        &self,
        straightalphagradientstops: *const D2D1_GRADIENT_STOP,
        straightalphagradientstopscount: u32,
        preinterpolationspace: D2D1_COLOR_SPACE,
        postinterpolationspace: D2D1_COLOR_SPACE,
        bufferprecision: D2D1_BUFFER_PRECISION,
        extendmode: D2D1_EXTEND_MODE,
        colorinterpolationmode: D2D1_COLOR_INTERPOLATION_MODE,
    ) -> ::windows::runtime::Result<ID2D1GradientStopCollection1> {
        let mut result__: <ID2D1GradientStopCollection1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(straightalphagradientstops),
            ::std::mem::transmute(straightalphagradientstopscount),
            ::std::mem::transmute(preinterpolationspace),
            ::std::mem::transmute(postinterpolationspace),
            ::std::mem::transmute(bufferprecision),
            ::std::mem::transmute(extendmode),
            ::std::mem::transmute(colorinterpolationmode),
            &mut result__,
        )
        .from_abi::<ID2D1GradientStopCollection1>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateImageBrush<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        imagebrushproperties: *const D2D1_IMAGE_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1ImageBrush> {
        let mut result__: <ID2D1ImageBrush as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(imagebrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1ImageBrush>(result__)
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn CreateBitmapBrush2<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES1,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
    ) -> ::windows::runtime::Result<ID2D1BitmapBrush1> {
        let mut result__: <ID2D1BitmapBrush1 as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(bitmapbrushproperties),
            ::std::mem::transmute(brushproperties),
            &mut result__,
        )
        .from_abi::<ID2D1BitmapBrush1>(result__)
    }
    pub unsafe fn CreateCommandList(&self) -> ::windows::runtime::Result<ID2D1CommandList> {
        let mut result__: <ID2D1CommandList as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ID2D1CommandList>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Dxgi"))]
    pub unsafe fn IsDxgiFormatSupported(
        &self,
        format: super::Dxgi::DXGI_FORMAT,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(format),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsBufferPrecisionSupported(
        &self,
        bufferprecision: D2D1_BUFFER_PRECISION,
    ) -> super::super::Foundation::BOOL {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bufferprecision),
        ))
    }
    pub unsafe fn GetImageLocalBounds<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
    ) -> ::windows::runtime::Result<D2D_RECT_F> {
        let mut result__: <D2D_RECT_F as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            &mut result__,
        )
        .from_abi::<D2D_RECT_F>(result__)
    }
    pub unsafe fn GetImageWorldBounds<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
    ) -> ::windows::runtime::Result<D2D_RECT_F> {
        let mut result__: <D2D_RECT_F as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            &mut result__,
        )
        .from_abi::<D2D_RECT_F>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn GetGlyphRunWorldBounds<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) -> ::windows::runtime::Result<D2D_RECT_F> {
        let mut result__: <D2D_RECT_F as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(measuringmode),
            &mut result__,
        )
        .from_abi::<D2D_RECT_F>(result__)
    }
    pub unsafe fn GetDevice(&self, device: *mut ::std::option::Option<ID2D1Device>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(device),
        ))
    }
    pub unsafe fn SetTarget<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
        ))
    }
    pub unsafe fn GetTarget(&self, image: *mut ::std::option::Option<ID2D1Image>) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(image),
        ))
    }
    pub unsafe fn SetRenderingControls(&self, renderingcontrols: *const D2D1_RENDERING_CONTROLS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).76)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingcontrols),
        ))
    }
    pub unsafe fn GetRenderingControls(&self, renderingcontrols: *mut D2D1_RENDERING_CONTROLS) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(renderingcontrols),
        ))
    }
    pub unsafe fn SetPrimitiveBlend(&self, primitiveblend: D2D1_PRIMITIVE_BLEND) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).78)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(primitiveblend),
        ))
    }
    pub unsafe fn GetPrimitiveBlend(&self) -> D2D1_PRIMITIVE_BLEND {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn SetUnitMode(&self, unitmode: D2D1_UNIT_MODE) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unitmode),
        ))
    }
    pub unsafe fn GetUnitMode(&self) -> D2D1_UNIT_MODE {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub unsafe fn DrawGlyphRun2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, D2D_POINT_2F>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        baselineorigin: Param0,
        glyphrun: *const super::DirectWrite::DWRITE_GLYPH_RUN,
        glyphrundescription: *const super::DirectWrite::DWRITE_GLYPH_RUN_DESCRIPTION,
        foregroundbrush: Param3,
        measuringmode: super::DirectWrite::DWRITE_MEASURING_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            baselineorigin.into_param().abi(),
            ::std::mem::transmute(glyphrun),
            ::std::mem::transmute(glyphrundescription),
            foregroundbrush.into_param().abi(),
            ::std::mem::transmute(measuringmode),
        ))
    }
    pub unsafe fn DrawImage<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Image>>(
        &self,
        image: Param0,
        targetoffset: *const D2D_POINT_2F,
        imagerectangle: *const D2D_RECT_F,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        compositemode: D2D1_COMPOSITE_MODE,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
            image.into_param().abi(),
            ::std::mem::transmute(targetoffset),
            ::std::mem::transmute(imagerectangle),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(compositemode),
        ))
    }
    pub unsafe fn DrawGdiMetafile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GdiMetafile>,
    >(
        &self,
        gdimetafile: Param0,
        targetoffset: *const D2D_POINT_2F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            gdimetafile.into_param().abi(),
            ::std::mem::transmute(targetoffset),
        ))
    }
    pub unsafe fn DrawBitmap2<'a, Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>>(
        &self,
        bitmap: Param0,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
        perspectivetransform: *const D2D_MATRIX_4X4_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            bitmap.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(opacity),
            ::std::mem::transmute(interpolationmode),
            ::std::mem::transmute(sourcerectangle),
            ::std::mem::transmute(perspectivetransform),
        ))
    }
    #[cfg(feature = "Foundation_Numerics")]
    pub unsafe fn PushLayer2<'a, Param1: ::windows::runtime::IntoParam<'a, ID2D1Layer>>(
        &self,
        layerparameters: *const D2D1_LAYER_PARAMETERS1,
        layer: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(layerparameters),
            layer.into_param().abi(),
        ))
    }
    pub unsafe fn InvalidateEffectInputRectangle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        effect: Param0,
        input: u32,
        inputrectangle: *const D2D_RECT_F,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            effect.into_param().abi(),
            ::std::mem::transmute(input),
            ::std::mem::transmute(inputrectangle),
        )
        .ok()
    }
    pub unsafe fn GetEffectInvalidRectangleCount<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        effect: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            effect.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetEffectInvalidRectangles<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        effect: Param0,
        rectangles: *mut D2D_RECT_F,
        rectanglescount: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            effect.into_param().abi(),
            ::std::mem::transmute(rectangles),
            ::std::mem::transmute(rectanglescount),
        )
        .ok()
    }
    pub unsafe fn GetEffectRequiredInputRectangles<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Effect>,
    >(
        &self,
        rendereffect: Param0,
        renderimagerectangle: *const D2D_RECT_F,
        inputdescriptions: *const D2D1_EFFECT_INPUT_DESCRIPTION,
        requiredinputrects: *mut D2D_RECT_F,
        inputcount: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).90)(
            ::std::mem::transmute_copy(self),
            rendereffect.into_param().abi(),
            ::std::mem::transmute(renderimagerectangle),
            ::std::mem::transmute(inputdescriptions),
            ::std::mem::transmute(requiredinputrects),
            ::std::mem::transmute(inputcount),
        )
        .ok()
    }
    pub unsafe fn FillOpacityMask2<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Bitmap>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        opacitymask: Param0,
        brush: Param1,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).91)(
            ::std::mem::transmute_copy(self),
            opacitymask.into_param().abi(),
            brush.into_param().abi(),
            ::std::mem::transmute(destinationrectangle),
            ::std::mem::transmute(sourcerectangle),
        ))
    }
    pub unsafe fn CreateFilledGeometryRealization<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
    >(
        &self,
        geometry: Param0,
        flatteningtolerance: f32,
    ) -> ::windows::runtime::Result<ID2D1GeometryRealization> {
        let mut result__: <ID2D1GeometryRealization as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).92)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            ::std::mem::transmute(flatteningtolerance),
            &mut result__,
        )
        .from_abi::<ID2D1GeometryRealization>(result__)
    }
    pub unsafe fn CreateStrokedGeometryRealization<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1Geometry>,
        Param3: ::windows::runtime::IntoParam<'a, ID2D1StrokeStyle>,
    >(
        &self,
        geometry: Param0,
        flatteningtolerance: f32,
        strokewidth: f32,
        strokestyle: Param3,
    ) -> ::windows::runtime::Result<ID2D1GeometryRealization> {
        let mut result__: <ID2D1GeometryRealization as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).93)(
            ::std::mem::transmute_copy(self),
            geometry.into_param().abi(),
            ::std::mem::transmute(flatteningtolerance),
            ::std::mem::transmute(strokewidth),
            strokestyle.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ID2D1GeometryRealization>(result__)
    }
    pub unsafe fn DrawGeometryRealization<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ID2D1GeometryRealization>,
        Param1: ::windows::runtime::IntoParam<'a, ID2D1Brush>,
    >(
        &self,
        geometryrealization: Param0,
        brush: Param1,
    ) {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).94)(
            ::std::mem::transmute_copy(self),
            geometryrealization.into_param().abi(),
            brush.into_param().abi(),
        ))
    }
}
unsafe impl ::windows::runtime::Interface for ID2D1DeviceContext1 {
    type Vtable = ID2D1DeviceContext1_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3548338148,
        26888,
        17823,
        [161, 153, 231, 47, 36, 247, 153, 135],
    );
}
impl ::std::convert::From<ID2D1DeviceContext1> for ::windows::runtime::IUnknown {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DeviceContext1> for ::windows::runtime::IUnknown {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ID2D1DeviceContext1> for ID2D1DeviceContext {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DeviceContext1> for ID2D1DeviceContext {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1DeviceContext> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1DeviceContext> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1DeviceContext>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1DeviceContext> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1DeviceContext> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1DeviceContext>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1DeviceContext1> for ID2D1RenderTarget {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DeviceContext1> for ID2D1RenderTarget {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1RenderTarget> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1RenderTarget> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1RenderTarget>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ID2D1DeviceContext1> for ID2D1Resource {
    fn from(value: ID2D1DeviceContext1) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ID2D1DeviceContext1> for ID2D1Resource {
    fn from(value: &ID2D1DeviceContext1) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ID2D1Resource> for &ID2D1DeviceContext1 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ID2D1Resource> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ID2D1Resource>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ID2D1DeviceContext1_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: *mut ::windows::runtime::RawPtr,
    ),
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: D2D_SIZE_U,
        srcdata: *const ::std::ffi::c_void,
        pitch: u32,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wicbitmapsource: ::windows::runtime::RawPtr,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Graphics_Dxgi", feature = "Win32_Graphics_Imaging")))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        data: *mut ::std::ffi::c_void,
        bitmapproperties: *const D2D1_BITMAP_PROPERTIES,
        bitmap: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        bitmapbrushproperties: *const D2D1_BITMAP_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        bitmapbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        color: *const D2D1_COLOR_F,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        solidcolorbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        gradientstops: *const D2D1_GRADIENT_STOP,
        gradientstopscount: u32,
        colorinterpolationgamma: D2D1_GAMMA,
        extendmode: D2D1_EXTEND_MODE,
        gradientstopcollection: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lineargradientbrushproperties: *const D2D1_LINEAR_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        lineargradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Foundation_Numerics")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        radialgradientbrushproperties: *const D2D1_RADIAL_GRADIENT_BRUSH_PROPERTIES,
        brushproperties: *const D2D1_BRUSH_PROPERTIES,
        gradientstopcollection: ::windows::runtime::RawPtr,
        radialgradientbrush: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Foundation_Numerics"))] usize,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        desiredsize: *const D2D_SIZE_F,
        desiredpixelsize: *const D2D_SIZE_U,
        desiredformat: *const D2D1_PIXEL_FORMAT,
        options: D2D1_COMPATIBLE_RENDER_TARGET_OPTIONS,
        bitmaprendertarget: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        size: *const D2D_SIZE_F,
        layer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point0: D2D_POINT_2F,
        point1: D2D_POINT_2F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rect: *const D2D_RECT_F,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        roundedrect: *const D2D1_ROUNDED_RECT,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ellipse: *const D2D1_ELLIPSE,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        strokewidth: f32,
        strokestyle: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        geometry: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        opacitybrush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mesh: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        opacitymask: ::windows::runtime::RawPtr,
        brush: ::windows::runtime::RawPtr,
        content: D2D1_OPACITY_MASK_CONTENT,
        destinationrectangle: *const D2D_RECT_F,
        sourcerectangle: *const D2D_RECT_F,
    ),
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bitmap: ::windows::runtime::RawPtr,
        destinationrectangle: *const D2D_RECT_F,
        opacity: f32,
        interpolationmode: D2D1_BITMAP_INTERPOLATION_MODE,
        sourcerectangle: *const D2D_RECT_F,
    ),
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_DirectWrite"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        string: super::super::Foundation::PWSTR,
        stringlength: u32,
        textformat: ::windows::runtime::RawPtr,
        