#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
pub const ALL_SERVICES: u32 = 0u32;
pub const ALL_SERVICE_TYPES: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct APPLETIDLIST {
    pub count: i32,
    pub pIIDList: *mut ::windows::runtime::GUID,
}
impl APPLETIDLIST {}
impl ::std::default::Default for APPLETIDLIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for APPLETIDLIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APPLETIDLIST")
            .field("count", &self.count)
            .field("pIIDList", &self.pIIDList)
            .finish()
    }
}
impl ::std::cmp::PartialEq for APPLETIDLIST {
    fn eq(&self, other: &Self) -> bool {
        self.count == other.count && self.pIIDList == other.pIIDList
    }
}
impl ::std::cmp::Eq for APPLETIDLIST {}
unsafe impl ::windows::runtime::Abi for APPLETIDLIST {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct APPLYCANDEXPARAM {
    pub dwSize: u32,
    pub lpwstrDisplay: super::Foundation::PWSTR,
    pub lpwstrReading: super::Foundation::PWSTR,
    pub dwReserved: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl APPLYCANDEXPARAM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for APPLYCANDEXPARAM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for APPLYCANDEXPARAM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APPLYCANDEXPARAM")
            .field("dwSize", &self.dwSize)
            .field("lpwstrDisplay", &self.lpwstrDisplay)
            .field("lpwstrReading", &self.lpwstrReading)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for APPLYCANDEXPARAM {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.lpwstrDisplay == other.lpwstrDisplay
            && self.lpwstrReading == other.lpwstrReading
            && self.dwReserved == other.dwReserved
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for APPLYCANDEXPARAM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for APPLYCANDEXPARAM {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ATTR_CONVERTED: u32 = 2u32;
pub const ATTR_FIXEDCONVERTED: u32 = 5u32;
pub const ATTR_INPUT: u32 = 0u32;
pub const ATTR_INPUT_ERROR: u32 = 4u32;
pub const ATTR_TARGET_CONVERTED: u32 = 1u32;
pub const ATTR_TARGET_NOTCONVERTED: u32 = 3u32;
pub const C1_ALPHA: u32 = 256u32;
pub const C1_BLANK: u32 = 64u32;
pub const C1_CNTRL: u32 = 32u32;
pub const C1_DEFINED: u32 = 512u32;
pub const C1_DIGIT: u32 = 4u32;
pub const C1_LOWER: u32 = 2u32;
pub const C1_PUNCT: u32 = 16u32;
pub const C1_SPACE: u32 = 8u32;
pub const C1_UPPER: u32 = 1u32;
pub const C1_XDIGIT: u32 = 128u32;
pub const C2_ARABICNUMBER: u32 = 6u32;
pub const C2_BLOCKSEPARATOR: u32 = 8u32;
pub const C2_COMMONSEPARATOR: u32 = 7u32;
pub const C2_EUROPENUMBER: u32 = 3u32;
pub const C2_EUROPESEPARATOR: u32 = 4u32;
pub const C2_EUROPETERMINATOR: u32 = 5u32;
pub const C2_LEFTTORIGHT: u32 = 1u32;
pub const C2_NOTAPPLICABLE: u32 = 0u32;
pub const C2_OTHERNEUTRAL: u32 = 11u32;
pub const C2_RIGHTTOLEFT: u32 = 2u32;
pub const C2_SEGMENTSEPARATOR: u32 = 9u32;
pub const C2_WHITESPACE: u32 = 10u32;
pub const C3_ALPHA: u32 = 32768u32;
pub const C3_DIACRITIC: u32 = 2u32;
pub const C3_FULLWIDTH: u32 = 128u32;
pub const C3_HALFWIDTH: u32 = 64u32;
pub const C3_HIGHSURROGATE: u32 = 2048u32;
pub const C3_HIRAGANA: u32 = 32u32;
pub const C3_IDEOGRAPH: u32 = 256u32;
pub const C3_KASHIDA: u32 = 512u32;
pub const C3_KATAKANA: u32 = 16u32;
pub const C3_LEXICAL: u32 = 1024u32;
pub const C3_LOWSURROGATE: u32 = 4096u32;
pub const C3_NONSPACING: u32 = 1u32;
pub const C3_NOTAPPLICABLE: u32 = 0u32;
pub const C3_SYMBOL: u32 = 8u32;
pub const C3_VOWELMARK: u32 = 4u32;
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCA =
    unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCEXA = unsafe extern "system" fn(
    param0: super::Foundation::PSTR,
    param1: u32,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCEXEX = unsafe extern "system" fn(
    param0: super::Foundation::PWSTR,
    param1: u32,
    param2: super::Foundation::PWSTR,
    param3: super::Foundation::LPARAM,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCEXW = unsafe extern "system" fn(
    param0: super::Foundation::PWSTR,
    param1: u32,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type CALINFO_ENUMPROCW =
    unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
pub const CAL_GREGORIAN: u32 = 1u32;
pub const CAL_GREGORIAN_ARABIC: u32 = 10u32;
pub const CAL_GREGORIAN_ME_FRENCH: u32 = 9u32;
pub const CAL_GREGORIAN_US: u32 = 2u32;
pub const CAL_GREGORIAN_XLIT_ENGLISH: u32 = 11u32;
pub const CAL_GREGORIAN_XLIT_FRENCH: u32 = 12u32;
pub const CAL_HEBREW: u32 = 8u32;
pub const CAL_HIJRI: u32 = 6u32;
pub const CAL_ICALINTVALUE: u32 = 1u32;
pub const CAL_ITWODIGITYEARMAX: u32 = 48u32;
pub const CAL_IYEAROFFSETRANGE: u32 = 3u32;
pub const CAL_JAPAN: u32 = 3u32;
pub const CAL_KOREA: u32 = 5u32;
pub const CAL_NOUSEROVERRIDE: u32 = 2147483648u32;
pub const CAL_PERSIAN: u32 = 22u32;
pub const CAL_RETURN_GENITIVE_NAMES: u32 = 268435456u32;
pub const CAL_RETURN_NUMBER: u32 = 536870912u32;
pub const CAL_SABBREVDAYNAME1: u32 = 14u32;
pub const CAL_SABBREVDAYNAME2: u32 = 15u32;
pub const CAL_SABBREVDAYNAME3: u32 = 16u32;
pub const CAL_SABBREVDAYNAME4: u32 = 17u32;
pub const CAL_SABBREVDAYNAME5: u32 = 18u32;
pub const CAL_SABBREVDAYNAME6: u32 = 19u32;
pub const CAL_SABBREVDAYNAME7: u32 = 20u32;
pub const CAL_SABBREVERASTRING: u32 = 57u32;
pub const CAL_SABBREVMONTHNAME1: u32 = 34u32;
pub const CAL_SABBREVMONTHNAME10: u32 = 43u32;
pub const CAL_SABBREVMONTHNAME11: u32 = 44u32;
pub const CAL_SABBREVMONTHNAME12: u32 = 45u32;
pub const CAL_SABBREVMONTHNAME13: u32 = 46u32;
pub const CAL_SABBREVMONTHNAME2: u32 = 35u32;
pub const CAL_SABBREVMONTHNAME3: u32 = 36u32;
pub const CAL_SABBREVMONTHNAME4: u32 = 37u32;
pub const CAL_SABBREVMONTHNAME5: u32 = 38u32;
pub const CAL_SABBREVMONTHNAME6: u32 = 39u32;
pub const CAL_SABBREVMONTHNAME7: u32 = 40u32;
pub const CAL_SABBREVMONTHNAME8: u32 = 41u32;
pub const CAL_SABBREVMONTHNAME9: u32 = 42u32;
pub const CAL_SCALNAME: u32 = 2u32;
pub const CAL_SDAYNAME1: u32 = 7u32;
pub const CAL_SDAYNAME2: u32 = 8u32;
pub const CAL_SDAYNAME3: u32 = 9u32;
pub const CAL_SDAYNAME4: u32 = 10u32;
pub const CAL_SDAYNAME5: u32 = 11u32;
pub const CAL_SDAYNAME6: u32 = 12u32;
pub const CAL_SDAYNAME7: u32 = 13u32;
pub const CAL_SENGLISHABBREVERANAME: u32 = 60u32;
pub const CAL_SENGLISHERANAME: u32 = 59u32;
pub const CAL_SERASTRING: u32 = 4u32;
pub const CAL_SJAPANESEERAFIRSTYEAR: u32 = 61u32;
pub const CAL_SLONGDATE: u32 = 6u32;
pub const CAL_SMONTHDAY: u32 = 56u32;
pub const CAL_SMONTHNAME1: u32 = 21u32;
pub const CAL_SMONTHNAME10: u32 = 30u32;
pub const CAL_SMONTHNAME11: u32 = 31u32;
pub const CAL_SMONTHNAME12: u32 = 32u32;
pub const CAL_SMONTHNAME13: u32 = 33u32;
pub const CAL_SMONTHNAME2: u32 = 22u32;
pub const CAL_SMONTHNAME3: u32 = 23u32;
pub const CAL_SMONTHNAME4: u32 = 24u32;
pub const CAL_SMONTHNAME5: u32 = 25u32;
pub const CAL_SMONTHNAME6: u32 = 26u32;
pub const CAL_SMONTHNAME7: u32 = 27u32;
pub const CAL_SMONTHNAME8: u32 = 28u32;
pub const CAL_SMONTHNAME9: u32 = 29u32;
pub const CAL_SRELATIVELONGDATE: u32 = 58u32;
pub const CAL_SSHORTDATE: u32 = 5u32;
pub const CAL_SSHORTESTDAYNAME1: u32 = 49u32;
pub const CAL_SSHORTESTDAYNAME2: u32 = 50u32;
pub const CAL_SSHORTESTDAYNAME3: u32 = 51u32;
pub const CAL_SSHORTESTDAYNAME4: u32 = 52u32;
pub const CAL_SSHORTESTDAYNAME5: u32 = 53u32;
pub const CAL_SSHORTESTDAYNAME6: u32 = 54u32;
pub const CAL_SSHORTESTDAYNAME7: u32 = 55u32;
pub const CAL_SYEARMONTH: u32 = 47u32;
pub const CAL_TAIWAN: u32 = 4u32;
pub const CAL_THAI: u32 = 7u32;
pub const CAL_UMALQURA: u32 = 23u32;
pub const CAL_USE_CP_ACP: u32 = 1073741824u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CANDIDATEFORM {
    pub dwIndex: u32,
    pub dwStyle: u32,
    pub ptCurrentPos: super::Foundation::POINT,
    pub rcArea: super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl CANDIDATEFORM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CANDIDATEFORM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CANDIDATEFORM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CANDIDATEFORM")
            .field("dwIndex", &self.dwIndex)
            .field("dwStyle", &self.dwStyle)
            .field("ptCurrentPos", &self.ptCurrentPos)
            .field("rcArea", &self.rcArea)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CANDIDATEFORM {
    fn eq(&self, other: &Self) -> bool {
        self.dwIndex == other.dwIndex
            && self.dwStyle == other.dwStyle
            && self.ptCurrentPos == other.ptCurrentPos
            && self.rcArea == other.rcArea
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CANDIDATEFORM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CANDIDATEFORM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CANDIDATEINFO {
    pub dwSize: u32,
    pub dwCount: u32,
    pub dwOffset: [u32; 32],
    pub dwPrivateSize: u32,
    pub dwPrivateOffset: u32,
}
impl CANDIDATEINFO {}
impl ::std::default::Default for CANDIDATEINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CANDIDATEINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CANDIDATEINFO")
            .field("dwSize", &self.dwSize)
            .field("dwCount", &self.dwCount)
            .field("dwOffset", &self.dwOffset)
            .field("dwPrivateSize", &self.dwPrivateSize)
            .field("dwPrivateOffset", &self.dwPrivateOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CANDIDATEINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwCount == other.dwCount
            && self.dwOffset == other.dwOffset
            && self.dwPrivateSize == other.dwPrivateSize
            && self.dwPrivateOffset == other.dwPrivateOffset
    }
}
impl ::std::cmp::Eq for CANDIDATEINFO {}
unsafe impl ::windows::runtime::Abi for CANDIDATEINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CANDIDATELIST {
    pub dwSize: u32,
    pub dwStyle: u32,
    pub dwCount: u32,
    pub dwSelection: u32,
    pub dwPageStart: u32,
    pub dwPageSize: u32,
    pub dwOffset: [u32; 1],
}
impl CANDIDATELIST {}
impl ::std::default::Default for CANDIDATELIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CANDIDATELIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CANDIDATELIST")
            .field("dwSize", &self.dwSize)
            .field("dwStyle", &self.dwStyle)
            .field("dwCount", &self.dwCount)
            .field("dwSelection", &self.dwSelection)
            .field("dwPageStart", &self.dwPageStart)
            .field("dwPageSize", &self.dwPageSize)
            .field("dwOffset", &self.dwOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CANDIDATELIST {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwStyle == other.dwStyle
            && self.dwCount == other.dwCount
            && self.dwSelection == other.dwSelection
            && self.dwPageStart == other.dwPageStart
            && self.dwPageSize == other.dwPageSize
            && self.dwOffset == other.dwOffset
    }
}
impl ::std::cmp::Eq for CANDIDATELIST {}
unsafe impl ::windows::runtime::Abi for CANDIDATELIST {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CANITER_SKIP_ZEROES: u32 = 1u32;
pub const CATID_MSIME_IImePadApplet: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1969670865,
        20169,
        17528,
        [159, 233, 142, 215, 102, 97, 158, 223],
    );
pub const CATID_MSIME_IImePadApplet1000: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3766608342,
        9097,
        17355,
        [182, 111, 96, 159, 130, 61, 159, 156],
    );
pub const CATID_MSIME_IImePadApplet1200: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2759833084,
        32021,
        16931,
        [167, 137, 183, 129, 191, 154, 230, 103],
    );
pub const CATID_MSIME_IImePadApplet900: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4205728191,
        24155,
        18973,
        [141, 225, 23, 193, 217, 225, 114, 141],
    );
pub const CATID_MSIME_IImePadApplet_VER7: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1242533425,
        50158,
        4561,
        [175, 239, 0, 128, 95, 12, 139, 109],
    );
pub const CATID_MSIME_IImePadApplet_VER80: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1459070866,
        65265,
        4563,
        [132, 99, 0, 192, 79, 122, 6, 229],
    );
pub const CATID_MSIME_IImePadApplet_VER81: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1701126320,
        48008,
        4564,
        [132, 192, 0, 192, 79, 122, 6, 229],
    );
pub const CActiveIMM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1230363955,
    45401,
    4560,
    [143, 207, 0, 170, 0, 107, 204, 89],
);
pub const CFS_CANDIDATEPOS: u32 = 64u32;
pub const CFS_DEFAULT: u32 = 0u32;
pub const CFS_EXCLUDE: u32 = 128u32;
pub const CFS_FORCE_POSITION: u32 = 32u32;
pub const CFS_POINT: u32 = 2u32;
pub const CFS_RECT: u32 = 1u32;
pub const CHARINFO_APPLETID_MASK: u32 = 4278190080u32;
pub const CHARINFO_CHARID_MASK: u32 = 65535u32;
pub const CHARINFO_FEID_MASK: u32 = 15728640u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CHARSETINFO {
    pub ciCharset: u32,
    pub ciACP: u32,
    pub fs: FONTSIGNATURE,
}
impl CHARSETINFO {}
impl ::std::default::Default for CHARSETINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CHARSETINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CHARSETINFO")
            .field("ciCharset", &self.ciCharset)
            .field("ciACP", &self.ciACP)
            .field("fs", &self.fs)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CHARSETINFO {
    fn eq(&self, other: &Self) -> bool {
        self.ciCharset == other.ciCharset && self.ciACP == other.ciACP && self.fs == other.fs
    }
}
impl ::std::cmp::Eq for CHARSETINFO {}
unsafe impl ::windows::runtime::Abi for CHARSETINFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CLSID_ImePlugInDictDictionaryList_CHS: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2079330971,
        23535,
        19940,
        [155, 11, 94, 219, 102, 172, 47, 166],
    );
pub const CLSID_ImePlugInDictDictionaryList_JPN: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1340241771,
        45305,
        17302,
        [181, 252, 233, 212, 207, 30, 193, 149],
    );
pub const CLSID_VERSION_DEPENDENT_MSIME_JAPANESE: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1787888286,
        43593,
        18203,
        [174, 231, 125, 51, 39, 133, 102, 13],
    );
pub const CMLangConvertCharset: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3597496217,
    52650,
    4560,
    [184, 34, 0, 192, 79, 201, 179, 31],
);
pub const CMLangString: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3226297807,
    46861,
    4560,
    [177, 136, 0, 170, 0, 56, 201, 105],
);
pub const CMultiLanguage: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    660349922,
    14151,
    4560,
    [159, 234, 0, 170, 0, 63, 134, 70],
);
#[cfg(feature = "Win32_Foundation")]
pub type CODEPAGE_ENUMPROCA =
    unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type CODEPAGE_ENUMPROCW =
    unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct COMPARE_STRING_FLAGS(pub u32);
pub const LINGUISTIC_IGNORECASE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(16u32);
pub const LINGUISTIC_IGNOREDIACRITIC: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(32u32);
pub const NORM_IGNORECASE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(1u32);
pub const NORM_IGNOREKANATYPE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(65536u32);
pub const NORM_IGNORENONSPACE: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(2u32);
pub const NORM_IGNORESYMBOLS: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(4u32);
pub const NORM_IGNOREWIDTH: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(131072u32);
pub const NORM_LINGUISTIC_CASING: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(134217728u32);
pub const SORT_DIGITSASNUMBERS: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(8u32);
pub const SORT_STRINGSORT: COMPARE_STRING_FLAGS = COMPARE_STRING_FLAGS(4096u32);
impl ::std::convert::From<u32> for COMPARE_STRING_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for COMPARE_STRING_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for COMPARE_STRING_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for COMPARE_STRING_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for COMPARE_STRING_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct COMPOSITIONFORM {
    pub dwStyle: u32,
    pub ptCurrentPos: super::Foundation::POINT,
    pub rcArea: super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl COMPOSITIONFORM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for COMPOSITIONFORM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for COMPOSITIONFORM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("COMPOSITIONFORM")
            .field("dwStyle", &self.dwStyle)
            .field("ptCurrentPos", &self.ptCurrentPos)
            .field("rcArea", &self.rcArea)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for COMPOSITIONFORM {
    fn eq(&self, other: &Self) -> bool {
        self.dwStyle == other.dwStyle
            && self.ptCurrentPos == other.ptCurrentPos
            && self.rcArea == other.rcArea
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for COMPOSITIONFORM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for COMPOSITIONFORM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct COMPOSITIONSTRING {
    pub dwSize: u32,
    pub dwCompReadAttrLen: u32,
    pub dwCompReadAttrOffset: u32,
    pub dwCompReadClauseLen: u32,
    pub dwCompReadClauseOffset: u32,
    pub dwCompReadStrLen: u32,
    pub dwCompReadStrOffset: u32,
    pub dwCompAttrLen: u32,
    pub dwCompAttrOffset: u32,
    pub dwCompClauseLen: u32,
    pub dwCompClauseOffset: u32,
    pub dwCompStrLen: u32,
    pub dwCompStrOffset: u32,
    pub dwCursorPos: u32,
    pub dwDeltaStart: u32,
    pub dwResultReadClauseLen: u32,
    pub dwResultReadClauseOffset: u32,
    pub dwResultReadStrLen: u32,
    pub dwResultReadStrOffset: u32,
    pub dwResultClauseLen: u32,
    pub dwResultClauseOffset: u32,
    pub dwResultStrLen: u32,
    pub dwResultStrOffset: u32,
    pub dwPrivateSize: u32,
    pub dwPrivateOffset: u32,
}
impl COMPOSITIONSTRING {}
impl ::std::default::Default for COMPOSITIONSTRING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for COMPOSITIONSTRING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("COMPOSITIONSTRING")
            .field("dwSize", &self.dwSize)
            .field("dwCompReadAttrLen", &self.dwCompReadAttrLen)
            .field("dwCompReadAttrOffset", &self.dwCompReadAttrOffset)
            .field("dwCompReadClauseLen", &self.dwCompReadClauseLen)
            .field("dwCompReadClauseOffset", &self.dwCompReadClauseOffset)
            .field("dwCompReadStrLen", &self.dwCompReadStrLen)
            .field("dwCompReadStrOffset", &self.dwCompReadStrOffset)
            .field("dwCompAttrLen", &self.dwCompAttrLen)
            .field("dwCompAttrOffset", &self.dwCompAttrOffset)
            .field("dwCompClauseLen", &self.dwCompClauseLen)
            .field("dwCompClauseOffset", &self.dwCompClauseOffset)
            .field("dwCompStrLen", &self.dwCompStrLen)
            .field("dwCompStrOffset", &self.dwCompStrOffset)
            .field("dwCursorPos", &self.dwCursorPos)
            .field("dwDeltaStart", &self.dwDeltaStart)
            .field("dwResultReadClauseLen", &self.dwResultReadClauseLen)
            .field("dwResultReadClauseOffset", &self.dwResultReadClauseOffset)
            .field("dwResultReadStrLen", &self.dwResultReadStrLen)
            .field("dwResultReadStrOffset", &self.dwResultReadStrOffset)
            .field("dwResultClauseLen", &self.dwResultClauseLen)
            .field("dwResultClauseOffset", &self.dwResultClauseOffset)
            .field("dwResultStrLen", &self.dwResultStrLen)
            .field("dwResultStrOffset", &self.dwResultStrOffset)
            .field("dwPrivateSize", &self.dwPrivateSize)
            .field("dwPrivateOffset", &self.dwPrivateOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for COMPOSITIONSTRING {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwCompReadAttrLen == other.dwCompReadAttrLen
            && self.dwCompReadAttrOffset == other.dwCompReadAttrOffset
            && self.dwCompReadClauseLen == other.dwCompReadClauseLen
            && self.dwCompReadClauseOffset == other.dwCompReadClauseOffset
            && self.dwCompReadStrLen == other.dwCompReadStrLen
            && self.dwCompReadStrOffset == other.dwCompReadStrOffset
            && self.dwCompAttrLen == other.dwCompAttrLen
            && self.dwCompAttrOffset == other.dwCompAttrOffset
            && self.dwCompClauseLen == other.dwCompClauseLen
            && self.dwCompClauseOffset == other.dwCompClauseOffset
            && self.dwCompStrLen == other.dwCompStrLen
            && self.dwCompStrOffset == other.dwCompStrOffset
            && self.dwCursorPos == other.dwCursorPos
            && self.dwDeltaStart == other.dwDeltaStart
            && self.dwResultReadClauseLen == other.dwResultReadClauseLen
            && self.dwResultReadClauseOffset == other.dwResultReadClauseOffset
            && self.dwResultReadStrLen == other.dwResultReadStrLen
            && self.dwResultReadStrOffset == other.dwResultReadStrOffset
            && self.dwResultClauseLen == other.dwResultClauseLen
            && self.dwResultClauseOffset == other.dwResultClauseOffset
            && self.dwResultStrLen == other.dwResultStrLen
            && self.dwResultStrOffset == other.dwResultStrOffset
            && self.dwPrivateSize == other.dwPrivateSize
            && self.dwPrivateOffset == other.dwPrivateOffset
    }
}
impl ::std::cmp::Eq for COMPOSITIONSTRING {}
unsafe impl ::windows::runtime::Abi for COMPOSITIONSTRING {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CORRECTIVE_ACTION(pub i32);
pub const CORRECTIVE_ACTION_NONE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(0i32);
pub const CORRECTIVE_ACTION_GET_SUGGESTIONS: CORRECTIVE_ACTION = CORRECTIVE_ACTION(1i32);
pub const CORRECTIVE_ACTION_REPLACE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(2i32);
pub const CORRECTIVE_ACTION_DELETE: CORRECTIVE_ACTION = CORRECTIVE_ACTION(3i32);
impl ::std::convert::From<i32> for CORRECTIVE_ACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CORRECTIVE_ACTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CPINFO {
    pub MaxCharSize: u32,
    pub DefaultChar: [u8; 2],
    pub LeadByte: [u8; 12],
}
impl CPINFO {}
impl ::std::default::Default for CPINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CPINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPINFO")
            .field("MaxCharSize", &self.MaxCharSize)
            .field("DefaultChar", &self.DefaultChar)
            .field("LeadByte", &self.LeadByte)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CPINFO {
    fn eq(&self, other: &Self) -> bool {
        self.MaxCharSize == other.MaxCharSize
            && self.DefaultChar == other.DefaultChar
            && self.LeadByte == other.LeadByte
    }
}
impl ::std::cmp::Eq for CPINFO {}
unsafe impl ::windows::runtime::Abi for CPINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_SystemServices")]
pub struct CPINFOEXA {
    pub MaxCharSize: u32,
    pub DefaultChar: [u8; 2],
    pub LeadByte: [u8; 12],
    pub UnicodeDefaultChar: u16,
    pub CodePage: u32,
    pub CodePageName: [super::System::SystemServices::CHAR; 260],
}
#[cfg(feature = "Win32_System_SystemServices")]
impl CPINFOEXA {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::default::Default for CPINFOEXA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::fmt::Debug for CPINFOEXA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPINFOEXA")
            .field("MaxCharSize", &self.MaxCharSize)
            .field("DefaultChar", &self.DefaultChar)
            .field("LeadByte", &self.LeadByte)
            .field("UnicodeDefaultChar", &self.UnicodeDefaultChar)
            .field("CodePage", &self.CodePage)
            .field("CodePageName", &self.CodePageName)
            .finish()
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::PartialEq for CPINFOEXA {
    fn eq(&self, other: &Self) -> bool {
        self.MaxCharSize == other.MaxCharSize
            && self.DefaultChar == other.DefaultChar
            && self.LeadByte == other.LeadByte
            && self.UnicodeDefaultChar == other.UnicodeDefaultChar
            && self.CodePage == other.CodePage
            && self.CodePageName == other.CodePageName
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::Eq for CPINFOEXA {}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::runtime::Abi for CPINFOEXA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CPINFOEXW {
    pub MaxCharSize: u32,
    pub DefaultChar: [u8; 2],
    pub LeadByte: [u8; 12],
    pub UnicodeDefaultChar: u16,
    pub CodePage: u32,
    pub CodePageName: [u16; 260],
}
impl CPINFOEXW {}
impl ::std::default::Default for CPINFOEXW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CPINFOEXW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPINFOEXW")
            .field("MaxCharSize", &self.MaxCharSize)
            .field("DefaultChar", &self.DefaultChar)
            .field("LeadByte", &self.LeadByte)
            .field("UnicodeDefaultChar", &self.UnicodeDefaultChar)
            .field("CodePage", &self.CodePage)
            .field("CodePageName", &self.CodePageName)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CPINFOEXW {
    fn eq(&self, other: &Self) -> bool {
        self.MaxCharSize == other.MaxCharSize
            && self.DefaultChar == other.DefaultChar
            && self.LeadByte == other.LeadByte
            && self.UnicodeDefaultChar == other.UnicodeDefaultChar
            && self.CodePage == other.CodePage
            && self.CodePageName == other.CodePageName
    }
}
impl ::std::cmp::Eq for CPINFOEXW {}
unsafe impl ::windows::runtime::Abi for CPINFOEXW {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CPIOD_FORCE_PROMPT: i32 = -2147483648i32;
pub const CPIOD_PEEK: i32 = 1073741824i32;
pub const CP_ACP: u32 = 0u32;
pub const CP_MACCP: u32 = 2u32;
pub const CP_OEMCP: u32 = 1u32;
pub const CP_SYMBOL: u32 = 42u32;
pub const CP_THREAD_ACP: u32 = 3u32;
pub const CP_UTF7: u32 = 65000u32;
pub const CP_UTF8: u32 = 65001u32;
pub const CSTR_EQUAL: u32 = 2u32;
pub const CSTR_GREATER_THAN: u32 = 3u32;
pub const CSTR_LESS_THAN: u32 = 1u32;
pub const CS_INSERTCHAR: u32 = 8192u32;
pub const CS_NOMOVECARET: u32 = 16384u32;
pub const CTRY_ALBANIA: u32 = 355u32;
pub const CTRY_ALGERIA: u32 = 213u32;
pub const CTRY_ARGENTINA: u32 = 54u32;
pub const CTRY_ARMENIA: u32 = 374u32;
pub const CTRY_AUSTRALIA: u32 = 61u32;
pub const CTRY_AUSTRIA: u32 = 43u32;
pub const CTRY_AZERBAIJAN: u32 = 994u32;
pub const CTRY_BAHRAIN: u32 = 973u32;
pub const CTRY_BELARUS: u32 = 375u32;
pub const CTRY_BELGIUM: u32 = 32u32;
pub const CTRY_BELIZE: u32 = 501u32;
pub const CTRY_BOLIVIA: u32 = 591u32;
pub const CTRY_BRAZIL: u32 = 55u32;
pub const CTRY_BRUNEI_DARUSSALAM: u32 = 673u32;
pub const CTRY_BULGARIA: u32 = 359u32;
pub const CTRY_CANADA: u32 = 2u32;
pub const CTRY_CARIBBEAN: u32 = 1u32;
pub const CTRY_CHILE: u32 = 56u32;
pub const CTRY_COLOMBIA: u32 = 57u32;
pub const CTRY_COSTA_RICA: u32 = 506u32;
pub const CTRY_CROATIA: u32 = 385u32;
pub const CTRY_CZECH: u32 = 420u32;
pub const CTRY_DEFAULT: u32 = 0u32;
pub const CTRY_DENMARK: u32 = 45u32;
pub const CTRY_DOMINICAN_REPUBLIC: u32 = 1u32;
pub const CTRY_ECUADOR: u32 = 593u32;
pub const CTRY_EGYPT: u32 = 20u32;
pub const CTRY_EL_SALVADOR: u32 = 503u32;
pub const CTRY_ESTONIA: u32 = 372u32;
pub const CTRY_FAEROE_ISLANDS: u32 = 298u32;
pub const CTRY_FINLAND: u32 = 358u32;
pub const CTRY_FRANCE: u32 = 33u32;
pub const CTRY_GEORGIA: u32 = 995u32;
pub const CTRY_GERMANY: u32 = 49u32;
pub const CTRY_GREECE: u32 = 30u32;
pub const CTRY_GUATEMALA: u32 = 502u32;
pub const CTRY_HONDURAS: u32 = 504u32;
pub const CTRY_HONG_KONG: u32 = 852u32;
pub const CTRY_HUNGARY: u32 = 36u32;
pub const CTRY_ICELAND: u32 = 354u32;
pub const CTRY_INDIA: u32 = 91u32;
pub const CTRY_INDONESIA: u32 = 62u32;
pub const CTRY_IRAN: u32 = 981u32;
pub const CTRY_IRAQ: u32 = 964u32;
pub const CTRY_IRELAND: u32 = 353u32;
pub const CTRY_ISRAEL: u32 = 972u32;
pub const CTRY_ITALY: u32 = 39u32;
pub const CTRY_JAMAICA: u32 = 1u32;
pub const CTRY_JAPAN: u32 = 81u32;
pub const CTRY_JORDAN: u32 = 962u32;
pub const CTRY_KAZAKSTAN: u32 = 7u32;
pub const CTRY_KENYA: u32 = 254u32;
pub const CTRY_KUWAIT: u32 = 965u32;
pub const CTRY_KYRGYZSTAN: u32 = 996u32;
pub const CTRY_LATVIA: u32 = 371u32;
pub const CTRY_LEBANON: u32 = 961u32;
pub const CTRY_LIBYA: u32 = 218u32;
pub const CTRY_LIECHTENSTEIN: u32 = 41u32;
pub const CTRY_LITHUANIA: u32 = 370u32;
pub const CTRY_LUXEMBOURG: u32 = 352u32;
pub const CTRY_MACAU: u32 = 853u32;
pub const CTRY_MACEDONIA: u32 = 389u32;
pub const CTRY_MALAYSIA: u32 = 60u32;
pub const CTRY_MALDIVES: u32 = 960u32;
pub const CTRY_MEXICO: u32 = 52u32;
pub const CTRY_MONACO: u32 = 33u32;
pub const CTRY_MONGOLIA: u32 = 976u32;
pub const CTRY_MOROCCO: u32 = 212u32;
pub const CTRY_NETHERLANDS: u32 = 31u32;
pub const CTRY_NEW_ZEALAND: u32 = 64u32;
pub const CTRY_NICARAGUA: u32 = 505u32;
pub const CTRY_NORWAY: u32 = 47u32;
pub const CTRY_OMAN: u32 = 968u32;
pub const CTRY_PAKISTAN: u32 = 92u32;
pub const CTRY_PANAMA: u32 = 507u32;
pub const CTRY_PARAGUAY: u32 = 595u32;
pub const CTRY_PERU: u32 = 51u32;
pub const CTRY_PHILIPPINES: u32 = 63u32;
pub const CTRY_POLAND: u32 = 48u32;
pub const CTRY_PORTUGAL: u32 = 351u32;
pub const CTRY_PRCHINA: u32 = 86u32;
pub const CTRY_PUERTO_RICO: u32 = 1u32;
pub const CTRY_QATAR: u32 = 974u32;
pub const CTRY_ROMANIA: u32 = 40u32;
pub const CTRY_RUSSIA: u32 = 7u32;
pub const CTRY_SAUDI_ARABIA: u32 = 966u32;
pub const CTRY_SERBIA: u32 = 381u32;
pub const CTRY_SINGAPORE: u32 = 65u32;
pub const CTRY_SLOVAK: u32 = 421u32;
pub const CTRY_SLOVENIA: u32 = 386u32;
pub const CTRY_SOUTH_AFRICA: u32 = 27u32;
pub const CTRY_SOUTH_KOREA: u32 = 82u32;
pub const CTRY_SPAIN: u32 = 34u32;
pub const CTRY_SWEDEN: u32 = 46u32;
pub const CTRY_SWITZERLAND: u32 = 41u32;
pub const CTRY_SYRIA: u32 = 963u32;
pub const CTRY_TAIWAN: u32 = 886u32;
pub const CTRY_TATARSTAN: u32 = 7u32;
pub const CTRY_THAILAND: u32 = 66u32;
pub const CTRY_TRINIDAD_Y_TOBAGO: u32 = 1u32;
pub const CTRY_TUNISIA: u32 = 216u32;
pub const CTRY_TURKEY: u32 = 90u32;
pub const CTRY_UAE: u32 = 971u32;
pub const CTRY_UKRAINE: u32 = 380u32;
pub const CTRY_UNITED_KINGDOM: u32 = 44u32;
pub const CTRY_UNITED_STATES: u32 = 1u32;
pub const CTRY_URUGUAY: u32 = 598u32;
pub const CTRY_UZBEKISTAN: u32 = 7u32;
pub const CTRY_VENEZUELA: u32 = 58u32;
pub const CTRY_VIET_NAM: u32 = 84u32;
pub const CTRY_YEMEN: u32 = 967u32;
pub const CTRY_ZIMBABWE: u32 = 263u32;
pub const CT_CTYPE1: u32 = 1u32;
pub const CT_CTYPE2: u32 = 2u32;
pub const CT_CTYPE3: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CURRENCYFMTA {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PSTR,
    pub lpThousandSep: super::Foundation::PSTR,
    pub NegativeOrder: u32,
    pub PositiveOrder: u32,
    pub lpCurrencySymbol: super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CURRENCYFMTA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CURRENCYFMTA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CURRENCYFMTA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CURRENCYFMTA")
            .field("NumDigits", &self.NumDigits)
            .field("LeadingZero", &self.LeadingZero)
            .field("Grouping", &self.Grouping)
            .field("lpDecimalSep", &self.lpDecimalSep)
            .field("lpThousandSep", &self.lpThousandSep)
            .field("NegativeOrder", &self.NegativeOrder)
            .field("PositiveOrder", &self.PositiveOrder)
            .field("lpCurrencySymbol", &self.lpCurrencySymbol)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CURRENCYFMTA {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits
            && self.LeadingZero == other.LeadingZero
            && self.Grouping == other.Grouping
            && self.lpDecimalSep == other.lpDecimalSep
            && self.lpThousandSep == other.lpThousandSep
            && self.NegativeOrder == other.NegativeOrder
            && self.PositiveOrder == other.PositiveOrder
            && self.lpCurrencySymbol == other.lpCurrencySymbol
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CURRENCYFMTA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CURRENCYFMTA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CURRENCYFMTW {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PWSTR,
    pub lpThousandSep: super::Foundation::PWSTR,
    pub NegativeOrder: u32,
    pub PositiveOrder: u32,
    pub lpCurrencySymbol: super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl CURRENCYFMTW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CURRENCYFMTW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CURRENCYFMTW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CURRENCYFMTW")
            .field("NumDigits", &self.NumDigits)
            .field("LeadingZero", &self.LeadingZero)
            .field("Grouping", &self.Grouping)
            .field("lpDecimalSep", &self.lpDecimalSep)
            .field("lpThousandSep", &self.lpThousandSep)
            .field("NegativeOrder", &self.NegativeOrder)
            .field("PositiveOrder", &self.PositiveOrder)
            .field("lpCurrencySymbol", &self.lpCurrencySymbol)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CURRENCYFMTW {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits
            && self.LeadingZero == other.LeadingZero
            && self.Grouping == other.Grouping
            && self.lpDecimalSep == other.lpDecimalSep
            && self.lpThousandSep == other.lpThousandSep
            && self.NegativeOrder == other.NegativeOrder
            && self.PositiveOrder == other.PositiveOrder
            && self.lpCurrencySymbol == other.lpCurrencySymbol
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CURRENCYFMTW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CURRENCYFMTW {
    type Abi = Self;
    type DefaultType = Self;
}
pub unsafe fn CompareStringA(
    locale: u32,
    dwcmpflags: u32,
    lpstring1: *const i8,
    cchcount1: i32,
    lpstring2: *const i8,
    cchcount2: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringA(
                locale: u32,
                dwcmpflags: u32,
                lpstring1: *const i8,
                cchcount1: i32,
                lpstring2: *const i8,
                cchcount2: i32,
            ) -> i32;
        }
        ::std::mem::transmute(CompareStringA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwcmpflags),
            ::std::mem::transmute(lpstring1),
            ::std::mem::transmute(cchcount1),
            ::std::mem::transmute(lpstring2),
            ::std::mem::transmute(cchcount2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CompareStringEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param8: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    lplocalename: Param0,
    dwcmpflags: COMPARE_STRING_FLAGS,
    lpstring1: Param2,
    cchcount1: i32,
    lpstring2: Param4,
    cchcount2: i32,
    lpversioninformation: *mut NLSVERSIONINFO,
    lpreserved: *mut ::std::ffi::c_void,
    lparam: Param8,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringEx(
                lplocalename: super::Foundation::PWSTR,
                dwcmpflags: COMPARE_STRING_FLAGS,
                lpstring1: super::Foundation::PWSTR,
                cchcount1: i32,
                lpstring2: super::Foundation::PWSTR,
                cchcount2: i32,
                lpversioninformation: *mut NLSVERSIONINFO,
                lpreserved: *mut ::std::ffi::c_void,
                lparam: super::Foundation::LPARAM,
            ) -> i32;
        }
        ::std::mem::transmute(CompareStringEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwcmpflags),
            lpstring1.into_param().abi(),
            ::std::mem::transmute(cchcount1),
            lpstring2.into_param().abi(),
            ::std::mem::transmute(cchcount2),
            ::std::mem::transmute(lpversioninformation),
            ::std::mem::transmute(lpreserved),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CompareStringOrdinal<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
>(
    lpstring1: Param0,
    cchcount1: i32,
    lpstring2: Param2,
    cchcount2: i32,
    bignorecase: Param4,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringOrdinal(
                lpstring1: super::Foundation::PWSTR,
                cchcount1: i32,
                lpstring2: super::Foundation::PWSTR,
                cchcount2: i32,
                bignorecase: super::Foundation::BOOL,
            ) -> i32;
        }
        ::std::mem::transmute(CompareStringOrdinal(
            lpstring1.into_param().abi(),
            ::std::mem::transmute(cchcount1),
            lpstring2.into_param().abi(),
            ::std::mem::transmute(cchcount2),
            bignorecase.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CompareStringW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwcmpflags: u32,
    lpstring1: Param2,
    cchcount1: i32,
    lpstring2: Param4,
    cchcount2: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn CompareStringW(
                locale: u32,
                dwcmpflags: u32,
                lpstring1: super::Foundation::PWSTR,
                cchcount1: i32,
                lpstring2: super::Foundation::PWSTR,
                cchcount2: i32,
            ) -> i32;
        }
        ::std::mem::transmute(CompareStringW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwcmpflags),
            lpstring1.into_param().abi(),
            ::std::mem::transmute(cchcount1),
            lpstring2.into_param().abi(),
            ::std::mem::transmute(cchcount2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ConvertDefaultLocale(locale: u32) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ConvertDefaultLocale(locale: u32) -> u32;
        }
        ::std::mem::transmute(ConvertDefaultLocale(::std::mem::transmute(locale)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCA =
    unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCEXA = unsafe extern "system" fn(
    param0: super::Foundation::PSTR,
    param1: u32,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCEXEX = unsafe extern "system" fn(
    param0: super::Foundation::PWSTR,
    param1: u32,
    param2: super::Foundation::LPARAM,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCEXW = unsafe extern "system" fn(
    param0: super::Foundation::PWSTR,
    param1: u32,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type DATEFMT_ENUMPROCW =
    unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DetectEncodingInfo {
    pub nLangID: u32,
    pub nCodePage: u32,
    pub nDocPercent: i32,
    pub nConfidence: i32,
}
impl DetectEncodingInfo {}
impl ::std::default::Default for DetectEncodingInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DetectEncodingInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DetectEncodingInfo")
            .field("nLangID", &self.nLangID)
            .field("nCodePage", &self.nCodePage)
            .field("nDocPercent", &self.nDocPercent)
            .field("nConfidence", &self.nConfidence)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DetectEncodingInfo {
    fn eq(&self, other: &Self) -> bool {
        self.nLangID == other.nLangID
            && self.nCodePage == other.nCodePage
            && self.nDocPercent == other.nDocPercent
            && self.nConfidence == other.nConfidence
    }
}
impl ::std::cmp::Eq for DetectEncodingInfo {}
unsafe impl ::windows::runtime::Abi for DetectEncodingInfo {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ELS_GUID_LANGUAGE_DETECTION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3481141425,
        37019,
        19861,
        [168, 244, 97, 31, 124, 55, 119, 2],
    );
pub const ELS_GUID_SCRIPT_DETECTION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        761574457,
        27823,
        20331,
        [182, 136, 229, 208, 244, 250, 167, 215],
    );
pub const ELS_GUID_TRANSLITERATION_BENGALI_TO_LATIN: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4108310565,
        37284,
        18591,
        [133, 94, 154, 217, 190, 229, 87, 39],
    );
pub const ELS_GUID_TRANSLITERATION_CYRILLIC_TO_LATIN: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1037118104,
        23293,
        18691,
        [161, 63, 225, 126, 108, 11, 254, 1],
    );
pub const ELS_GUID_TRANSLITERATION_DEVANAGARI_TO_LATIN: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3299138814,
        9825,
        19714,
        [152, 53, 244, 129, 135, 16, 152, 3],
    );
pub const ELS_GUID_TRANSLITERATION_HANGUL_DECOMPOSITION: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1268950817,
        58429,
        16823,
        [179, 48, 83, 106, 225, 228, 136, 99],
    );
pub const ELS_GUID_TRANSLITERATION_HANS_TO_HANT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1017957832,
        21904,
        17116,
        [154, 123, 181, 166, 181, 179, 182, 59],
    );
pub const ELS_GUID_TRANSLITERATION_HANT_TO_HANS: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2745709371,
        62716,
        17142,
        [160, 196, 4, 98, 254, 115, 23, 203],
    );
pub const ELS_GUID_TRANSLITERATION_MALAYALAM_TO_LATIN: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3636036529,
        63679,
        18987,
        [188, 213, 91, 94, 162, 6, 19, 225],
    );
pub const ENUM_ALL_CALENDARS: u32 = 4294967295u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ENUM_DATE_FORMATS_FLAGS(pub u32);
pub const DATE_SHORTDATE: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(1u32);
pub const DATE_LONGDATE: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(2u32);
pub const DATE_YEARMONTH: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(8u32);
pub const DATE_MONTHDAY: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(128u32);
pub const DATE_AUTOLAYOUT: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(64u32);
pub const DATE_LTRREADING: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(16u32);
pub const DATE_RTLREADING: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(32u32);
pub const DATE_USE_ALT_CALENDAR: ENUM_DATE_FORMATS_FLAGS = ENUM_DATE_FORMATS_FLAGS(4u32);
impl ::std::convert::From<u32> for ENUM_DATE_FORMATS_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENUM_DATE_FORMATS_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for ENUM_DATE_FORMATS_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ENUM_DATE_FORMATS_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ENUM_DATE_FORMATS_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ENUM_DATE_FORMATS_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ENUM_DATE_FORMATS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ENUM_SYSTEM_CODE_PAGES_FLAGS(pub u32);
pub const CP_INSTALLED: ENUM_SYSTEM_CODE_PAGES_FLAGS = ENUM_SYSTEM_CODE_PAGES_FLAGS(1u32);
pub const CP_SUPPORTED: ENUM_SYSTEM_CODE_PAGES_FLAGS = ENUM_SYSTEM_CODE_PAGES_FLAGS(2u32);
impl ::std::convert::From<u32> for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ENUM_SYSTEM_CODE_PAGES_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(pub u32);
pub const LGRPID_INSTALLED: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS =
    ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(1u32);
pub const LGRPID_SUPPORTED: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS =
    ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS(2u32);
impl ::std::convert::From<u32> for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const E_LARGEINPUT: u32 = 51u32;
pub const E_NOCAND: u32 = 48u32;
pub const E_NOTENOUGH_BUFFER: u32 = 49u32;
pub const E_NOTENOUGH_WDD: u32 = 50u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumCalendarInfoA(
    lpcalinfoenumproc: ::std::option::Option<CALINFO_ENUMPROCA>,
    locale: u32,
    calendar: u32,
    caltype: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoA(
                lpcalinfoenumproc: ::windows::runtime::RawPtr,
                locale: u32,
                calendar: u32,
                caltype: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoA(
            ::std::mem::transmute(lpcalinfoenumproc),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumCalendarInfoExA(
    lpcalinfoenumprocex: ::std::option::Option<CALINFO_ENUMPROCEXA>,
    locale: u32,
    calendar: u32,
    caltype: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoExA(
                lpcalinfoenumprocex: ::windows::runtime::RawPtr,
                locale: u32,
                calendar: u32,
                caltype: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoExA(
            ::std::mem::transmute(lpcalinfoenumprocex),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumCalendarInfoExEx<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param5: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    pcalinfoenumprocexex: ::std::option::Option<CALINFO_ENUMPROCEXEX>,
    lplocalename: Param1,
    calendar: u32,
    lpreserved: Param3,
    caltype: u32,
    lparam: Param5,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoExEx(
                pcalinfoenumprocexex: ::windows::runtime::RawPtr,
                lplocalename: super::Foundation::PWSTR,
                calendar: u32,
                lpreserved: super::Foundation::PWSTR,
                caltype: u32,
                lparam: super::Foundation::LPARAM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoExEx(
            ::std::mem::transmute(pcalinfoenumprocexex),
            lplocalename.into_param().abi(),
            ::std::mem::transmute(calendar),
            lpreserved.into_param().abi(),
            ::std::mem::transmute(caltype),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumCalendarInfoExW(
    lpcalinfoenumprocex: ::std::option::Option<CALINFO_ENUMPROCEXW>,
    locale: u32,
    calendar: u32,
    caltype: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoExW(
                lpcalinfoenumprocex: ::windows::runtime::RawPtr,
                locale: u32,
                calendar: u32,
                caltype: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoExW(
            ::std::mem::transmute(lpcalinfoenumprocex),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumCalendarInfoW(
    lpcalinfoenumproc: ::std::option::Option<CALINFO_ENUMPROCW>,
    locale: u32,
    calendar: u32,
    caltype: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumCalendarInfoW(
                lpcalinfoenumproc: ::windows::runtime::RawPtr,
                locale: u32,
                calendar: u32,
                caltype: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumCalendarInfoW(
            ::std::mem::transmute(lpcalinfoenumproc),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumDateFormatsA(
    lpdatefmtenumproc: ::std::option::Option<DATEFMT_ENUMPROCA>,
    locale: u32,
    dwflags: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsA(
                lpdatefmtenumproc: ::windows::runtime::RawPtr,
                locale: u32,
                dwflags: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsA(
            ::std::mem::transmute(lpdatefmtenumproc),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumDateFormatsExA(
    lpdatefmtenumprocex: ::std::option::Option<DATEFMT_ENUMPROCEXA>,
    locale: u32,
    dwflags: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsExA(
                lpdatefmtenumprocex: ::windows::runtime::RawPtr,
                locale: u32,
                dwflags: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsExA(
            ::std::mem::transmute(lpdatefmtenumprocex),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumDateFormatsExEx<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    lpdatefmtenumprocexex: ::std::option::Option<DATEFMT_ENUMPROCEXEX>,
    lplocalename: Param1,
    dwflags: ENUM_DATE_FORMATS_FLAGS,
    lparam: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsExEx(
                lpdatefmtenumprocexex: ::windows::runtime::RawPtr,
                lplocalename: super::Foundation::PWSTR,
                dwflags: ENUM_DATE_FORMATS_FLAGS,
                lparam: super::Foundation::LPARAM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsExEx(
            ::std::mem::transmute(lpdatefmtenumprocexex),
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwflags),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumDateFormatsExW(
    lpdatefmtenumprocex: ::std::option::Option<DATEFMT_ENUMPROCEXW>,
    locale: u32,
    dwflags: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsExW(
                lpdatefmtenumprocex: ::windows::runtime::RawPtr,
                locale: u32,
                dwflags: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsExW(
            ::std::mem::transmute(lpdatefmtenumprocex),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumDateFormatsW(
    lpdatefmtenumproc: ::std::option::Option<DATEFMT_ENUMPROCW>,
    locale: u32,
    dwflags: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumDateFormatsW(
                lpdatefmtenumproc: ::windows::runtime::RawPtr,
                locale: u32,
                dwflags: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumDateFormatsW(
            ::std::mem::transmute(lpdatefmtenumproc),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumLanguageGroupLocalesA(
    lplanggrouplocaleenumproc: ::std::option::Option<LANGGROUPLOCALE_ENUMPROCA>,
    languagegroup: u32,
    dwflags: u32,
    lparam: isize,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumLanguageGroupLocalesA(
                lplanggrouplocaleenumproc: ::windows::runtime::RawPtr,
                languagegroup: u32,
                dwflags: u32,
                lparam: isize,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumLanguageGroupLocalesA(
            ::std::mem::transmute(lplanggrouplocaleenumproc),
            ::std::mem::transmute(languagegroup),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lparam),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumLanguageGroupLocalesW(
    lplanggrouplocaleenumproc: ::std::option::Option<LANGGROUPLOCALE_ENUMPROCW>,
    languagegroup: u32,
    dwflags: u32,
    lparam: isize,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumLanguageGroupLocalesW(
                lplanggrouplocaleenumproc: ::windows::runtime::RawPtr,
                languagegroup: u32,
                dwflags: u32,
                lparam: isize,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumLanguageGroupLocalesW(
            ::std::mem::transmute(lplanggrouplocaleenumproc),
            ::std::mem::transmute(languagegroup),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lparam),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemCodePagesA(
    lpcodepageenumproc: ::std::option::Option<CODEPAGE_ENUMPROCA>,
    dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemCodePagesA(
                lpcodepageenumproc: ::windows::runtime::RawPtr,
                dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemCodePagesA(
            ::std::mem::transmute(lpcodepageenumproc),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemCodePagesW(
    lpcodepageenumproc: ::std::option::Option<CODEPAGE_ENUMPROCW>,
    dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemCodePagesW(
                lpcodepageenumproc: ::windows::runtime::RawPtr,
                dwflags: ENUM_SYSTEM_CODE_PAGES_FLAGS,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemCodePagesW(
            ::std::mem::transmute(lpcodepageenumproc),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemGeoID(
    geoclass: u32,
    parentgeoid: i32,
    lpgeoenumproc: ::std::option::Option<GEO_ENUMPROC>,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemGeoID(
                geoclass: u32,
                parentgeoid: i32,
                lpgeoenumproc: ::windows::runtime::RawPtr,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemGeoID(
            ::std::mem::transmute(geoclass),
            ::std::mem::transmute(parentgeoid),
            ::std::mem::transmute(lpgeoenumproc),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemGeoNames<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    geoclass: u32,
    geoenumproc: ::std::option::Option<GEO_ENUMNAMEPROC>,
    data: Param2,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemGeoNames(
                geoclass: u32,
                geoenumproc: ::windows::runtime::RawPtr,
                data: super::Foundation::LPARAM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemGeoNames(
            ::std::mem::transmute(geoclass),
            ::std::mem::transmute(geoenumproc),
            data.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemLanguageGroupsA(
    lplanguagegroupenumproc: ::std::option::Option<LANGUAGEGROUP_ENUMPROCA>,
    dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS,
    lparam: isize,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLanguageGroupsA(
                lplanguagegroupenumproc: ::windows::runtime::RawPtr,
                dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS,
                lparam: isize,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLanguageGroupsA(
            ::std::mem::transmute(lplanguagegroupenumproc),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lparam),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemLanguageGroupsW(
    lplanguagegroupenumproc: ::std::option::Option<LANGUAGEGROUP_ENUMPROCW>,
    dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS,
    lparam: isize,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLanguageGroupsW(
                lplanguagegroupenumproc: ::windows::runtime::RawPtr,
                dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS,
                lparam: isize,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLanguageGroupsW(
            ::std::mem::transmute(lplanguagegroupenumproc),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lparam),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemLocalesA(
    lplocaleenumproc: ::std::option::Option<LOCALE_ENUMPROCA>,
    dwflags: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLocalesA(
                lplocaleenumproc: ::windows::runtime::RawPtr,
                dwflags: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLocalesA(
            ::std::mem::transmute(lplocaleenumproc),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemLocalesEx<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    lplocaleenumprocex: ::std::option::Option<LOCALE_ENUMPROCEX>,
    dwflags: u32,
    lparam: Param2,
    lpreserved: *const ::std::ffi::c_void,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLocalesEx(
                lplocaleenumprocex: ::windows::runtime::RawPtr,
                dwflags: u32,
                lparam: super::Foundation::LPARAM,
                lpreserved: *const ::std::ffi::c_void,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLocalesEx(
            ::std::mem::transmute(lplocaleenumprocex),
            ::std::mem::transmute(dwflags),
            lparam.into_param().abi(),
            ::std::mem::transmute(lpreserved),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumSystemLocalesW(
    lplocaleenumproc: ::std::option::Option<LOCALE_ENUMPROCW>,
    dwflags: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumSystemLocalesW(
                lplocaleenumproc: ::windows::runtime::RawPtr,
                dwflags: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumSystemLocalesW(
            ::std::mem::transmute(lplocaleenumproc),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumTimeFormatsA(
    lptimefmtenumproc: ::std::option::Option<TIMEFMT_ENUMPROCA>,
    locale: u32,
    dwflags: TIME_FORMAT_FLAGS,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumTimeFormatsA(
                lptimefmtenumproc: ::windows::runtime::RawPtr,
                locale: u32,
                dwflags: TIME_FORMAT_FLAGS,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumTimeFormatsA(
            ::std::mem::transmute(lptimefmtenumproc),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumTimeFormatsEx<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    lptimefmtenumprocex: ::std::option::Option<TIMEFMT_ENUMPROCEX>,
    lplocalename: Param1,
    dwflags: u32,
    lparam: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumTimeFormatsEx(
                lptimefmtenumprocex: ::windows::runtime::RawPtr,
                lplocalename: super::Foundation::PWSTR,
                dwflags: u32,
                lparam: super::Foundation::LPARAM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumTimeFormatsEx(
            ::std::mem::transmute(lptimefmtenumprocex),
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwflags),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumTimeFormatsW(
    lptimefmtenumproc: ::std::option::Option<TIMEFMT_ENUMPROCW>,
    locale: u32,
    dwflags: TIME_FORMAT_FLAGS,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumTimeFormatsW(
                lptimefmtenumproc: ::windows::runtime::RawPtr,
                locale: u32,
                dwflags: TIME_FORMAT_FLAGS,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumTimeFormatsW(
            ::std::mem::transmute(lptimefmtenumproc),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumUILanguagesA(
    lpuilanguageenumproc: ::std::option::Option<UILANGUAGE_ENUMPROCA>,
    dwflags: u32,
    lparam: isize,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumUILanguagesA(
                lpuilanguageenumproc: ::windows::runtime::RawPtr,
                dwflags: u32,
                lparam: isize,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumUILanguagesA(
            ::std::mem::transmute(lpuilanguageenumproc),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lparam),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumUILanguagesW(
    lpuilanguageenumproc: ::std::option::Option<UILANGUAGE_ENUMPROCW>,
    dwflags: u32,
    lparam: isize,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn EnumUILanguagesW(
                lpuilanguageenumproc: ::windows::runtime::RawPtr,
                dwflags: u32,
                lparam: isize,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumUILanguagesW(
            ::std::mem::transmute(lpuilanguageenumproc),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lparam),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const FEID_CHINESE_HONGKONG: u32 = 3u32;
pub const FEID_CHINESE_SIMPLIFIED: u32 = 2u32;
pub const FEID_CHINESE_SINGAPORE: u32 = 4u32;
pub const FEID_CHINESE_TRADITIONAL: u32 = 1u32;
pub const FEID_JAPANESE: u32 = 5u32;
pub const FEID_KOREAN: u32 = 6u32;
pub const FEID_KOREAN_JOHAB: u32 = 7u32;
pub const FEID_NONE: u32 = 0u32;
pub const FELANG_CLMN_FIXD: u32 = 32u32;
pub const FELANG_CLMN_FIXR: u32 = 16u32;
pub const FELANG_CLMN_NOPBREAK: u32 = 8u32;
pub const FELANG_CLMN_NOWBREAK: u32 = 2u32;
pub const FELANG_CLMN_PBREAK: u32 = 4u32;
pub const FELANG_CLMN_WBREAK: u32 = 1u32;
pub const FELANG_CMODE_AUTOMATIC: u32 = 134217728u32;
pub const FELANG_CMODE_BESTFIRST: u32 = 16384u32;
pub const FELANG_CMODE_BOPOMOFO: u32 = 64u32;
pub const FELANG_CMODE_CONVERSATION: u32 = 536870912u32;
pub const FELANG_CMODE_FULLWIDTHOUT: u32 = 32u32;
pub const FELANG_CMODE_HALFWIDTHOUT: u32 = 16u32;
pub const FELANG_CMODE_HANGUL: u32 = 128u32;
pub const FELANG_CMODE_HIRAGANAOUT: u32 = 0u32;
pub const FELANG_CMODE_KATAKANAOUT: u32 = 8u32;
pub const FELANG_CMODE_MERGECAND: u32 = 4096u32;
pub const FELANG_CMODE_MONORUBY: u32 = 2u32;
pub const FELANG_CMODE_NAME: u32 = 268435456u32;
pub const FELANG_CMODE_NOINVISIBLECHAR: u32 = 1073741824u32;
pub const FELANG_CMODE_NONE: u32 = 16777216u32;
pub const FELANG_CMODE_NOPRUNING: u32 = 4u32;
pub const FELANG_CMODE_PHRASEPREDICT: u32 = 268435456u32;
pub const FELANG_CMODE_PINYIN: u32 = 256u32;
pub const FELANG_CMODE_PLAURALCLAUSE: u32 = 33554432u32;
pub const FELANG_CMODE_PRECONV: u32 = 512u32;
pub const FELANG_CMODE_RADICAL: u32 = 1024u32;
pub const FELANG_CMODE_ROMAN: u32 = 8192u32;
pub const FELANG_CMODE_SINGLECONVERT: u32 = 67108864u32;
pub const FELANG_CMODE_UNKNOWNREADING: u32 = 2048u32;
pub const FELANG_CMODE_USENOREVWORDS: u32 = 32768u32;
pub const FELANG_INVALD_PO: u32 = 65535u32;
pub const FELANG_REQ_CONV: u32 = 65536u32;
pub const FELANG_REQ_RECONV: u32 = 131072u32;
pub const FELANG_REQ_REV: u32 = 196608u32;
pub const FID_MSIME_KMS_DEL_KEYLIST: u32 = 4u32;
pub const FID_MSIME_KMS_FUNCDESC: u32 = 9u32;
pub const FID_MSIME_KMS_GETMAP: u32 = 6u32;
pub const FID_MSIME_KMS_GETMAPFAST: u32 = 11u32;
pub const FID_MSIME_KMS_GETMAPSEAMLESS: u32 = 10u32;
pub const FID_MSIME_KMS_INIT: u32 = 2u32;
pub const FID_MSIME_KMS_INVOKE: u32 = 7u32;
pub const FID_MSIME_KMS_NOTIFY: u32 = 5u32;
pub const FID_MSIME_KMS_SETMAP: u32 = 8u32;
pub const FID_MSIME_KMS_TERM: u32 = 3u32;
pub const FID_MSIME_KMS_VERSION: u32 = 1u32;
pub const FID_MSIME_VERSION: u32 = 0u32;
pub const FID_RECONVERT_VERSION: u32 = 268435456u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct FILEMUIINFO {
    pub dwSize: u32,
    pub dwVersion: u32,
    pub dwFileType: u32,
    pub pChecksum: [u8; 16],
    pub pServiceChecksum: [u8; 16],
    pub dwLanguageNameOffset: u32,
    pub dwTypeIDMainSize: u32,
    pub dwTypeIDMainOffset: u32,
    pub dwTypeNameMainOffset: u32,
    pub dwTypeIDMUISize: u32,
    pub dwTypeIDMUIOffset: u32,
    pub dwTypeNameMUIOffset: u32,
    pub abBuffer: [u8; 8],
}
impl FILEMUIINFO {}
impl ::std::default::Default for FILEMUIINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FILEMUIINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FILEMUIINFO")
            .field("dwSize", &self.dwSize)
            .field("dwVersion", &self.dwVersion)
            .field("dwFileType", &self.dwFileType)
            .field("pChecksum", &self.pChecksum)
            .field("pServiceChecksum", &self.pServiceChecksum)
            .field("dwLanguageNameOffset", &self.dwLanguageNameOffset)
            .field("dwTypeIDMainSize", &self.dwTypeIDMainSize)
            .field("dwTypeIDMainOffset", &self.dwTypeIDMainOffset)
            .field("dwTypeNameMainOffset", &self.dwTypeNameMainOffset)
            .field("dwTypeIDMUISize", &self.dwTypeIDMUISize)
            .field("dwTypeIDMUIOffset", &self.dwTypeIDMUIOffset)
            .field("dwTypeNameMUIOffset", &self.dwTypeNameMUIOffset)
            .field("abBuffer", &self.abBuffer)
            .finish()
    }
}
impl ::std::cmp::PartialEq for FILEMUIINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwVersion == other.dwVersion
            && self.dwFileType == other.dwFileType
            && self.pChecksum == other.pChecksum
            && self.pServiceChecksum == other.pServiceChecksum
            && self.dwLanguageNameOffset == other.dwLanguageNameOffset
            && self.dwTypeIDMainSize == other.dwTypeIDMainSize
            && self.dwTypeIDMainOffset == other.dwTypeIDMainOffset
            && self.dwTypeNameMainOffset == other.dwTypeNameMainOffset
            && self.dwTypeIDMUISize == other.dwTypeIDMUISize
            && self.dwTypeIDMUIOffset == other.dwTypeIDMUIOffset
            && self.dwTypeNameMUIOffset == other.dwTypeNameMUIOffset
            && self.abBuffer == other.abBuffer
    }
}
impl ::std::cmp::Eq for FILEMUIINFO {}
unsafe impl ::windows::runtime::Abi for FILEMUIINFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FIND_ENDSWITH: u32 = 2097152u32;
pub const FIND_FROMEND: u32 = 8388608u32;
pub const FIND_FROMSTART: u32 = 4194304u32;
pub const FIND_STARTSWITH: u32 = 1048576u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FOLD_STRING_MAP_FLAGS(pub u32);
pub const MAP_COMPOSITE: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(64u32);
pub const MAP_EXPAND_LIGATURES: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(8192u32);
pub const MAP_FOLDCZONE: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(16u32);
pub const MAP_FOLDDIGITS: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(128u32);
pub const MAP_PRECOMPOSED: FOLD_STRING_MAP_FLAGS = FOLD_STRING_MAP_FLAGS(32u32);
impl ::std::convert::From<u32> for FOLD_STRING_MAP_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FOLD_STRING_MAP_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for FOLD_STRING_MAP_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for FOLD_STRING_MAP_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for FOLD_STRING_MAP_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct FONTSIGNATURE {
    pub fsUsb: [u32; 4],
    pub fsCsb: [u32; 2],
}
impl FONTSIGNATURE {}
impl ::std::default::Default for FONTSIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FONTSIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FONTSIGNATURE")
            .field("fsUsb", &self.fsUsb)
            .field("fsCsb", &self.fsCsb)
            .finish()
    }
}
impl ::std::cmp::PartialEq for FONTSIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.fsUsb == other.fsUsb && self.fsCsb == other.fsCsb
    }
}
impl ::std::cmp::Eq for FONTSIGNATURE {}
unsafe impl ::windows::runtime::Abi for FONTSIGNATURE {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindNLSString<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwfindnlsstringflags: u32,
    lpstringsource: Param2,
    cchsource: i32,
    lpstringvalue: Param4,
    cchvalue: i32,
    pcchfound: *mut i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindNLSString(
                locale: u32,
                dwfindnlsstringflags: u32,
                lpstringsource: super::Foundation::PWSTR,
                cchsource: i32,
                lpstringvalue: super::Foundation::PWSTR,
                cchvalue: i32,
                pcchfound: *mut i32,
            ) -> i32;
        }
        ::std::mem::transmute(FindNLSString(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwfindnlsstringflags),
            lpstringsource.into_param().abi(),
            ::std::mem::transmute(cchsource),
            lpstringvalue.into_param().abi(),
            ::std::mem::transmute(cchvalue),
            ::std::mem::transmute(pcchfound),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindNLSStringEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param9: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    lplocalename: Param0,
    dwfindnlsstringflags: u32,
    lpstringsource: Param2,
    cchsource: i32,
    lpstringvalue: Param4,
    cchvalue: i32,
    pcchfound: *mut i32,
    lpversioninformation: *const NLSVERSIONINFO,
    lpreserved: *const ::std::ffi::c_void,
    sorthandle: Param9,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindNLSStringEx(
                lplocalename: super::Foundation::PWSTR,
                dwfindnlsstringflags: u32,
                lpstringsource: super::Foundation::PWSTR,
                cchsource: i32,
                lpstringvalue: super::Foundation::PWSTR,
                cchvalue: i32,
                pcchfound: *mut i32,
                lpversioninformation: *const NLSVERSIONINFO,
                lpreserved: *const ::std::ffi::c_void,
                sorthandle: super::Foundation::LPARAM,
            ) -> i32;
        }
        ::std::mem::transmute(FindNLSStringEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwfindnlsstringflags),
            lpstringsource.into_param().abi(),
            ::std::mem::transmute(cchsource),
            lpstringvalue.into_param().abi(),
            ::std::mem::transmute(cchvalue),
            ::std::mem::transmute(pcchfound),
            ::std::mem::transmute(lpversioninformation),
            ::std::mem::transmute(lpreserved),
            sorthandle.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindStringOrdinal<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param5: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
>(
    dwfindstringordinalflags: u32,
    lpstringsource: Param1,
    cchsource: i32,
    lpstringvalue: Param3,
    cchvalue: i32,
    bignorecase: Param5,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FindStringOrdinal(
                dwfindstringordinalflags: u32,
                lpstringsource: super::Foundation::PWSTR,
                cchsource: i32,
                lpstringvalue: super::Foundation::PWSTR,
                cchvalue: i32,
                bignorecase: super::Foundation::BOOL,
            ) -> i32;
        }
        ::std::mem::transmute(FindStringOrdinal(
            ::std::mem::transmute(dwfindstringordinalflags),
            lpstringsource.into_param().abi(),
            ::std::mem::transmute(cchsource),
            lpstringvalue.into_param().abi(),
            ::std::mem::transmute(cchvalue),
            bignorecase.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FoldStringA<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    dwmapflags: FOLD_STRING_MAP_FLAGS,
    lpsrcstr: Param1,
    cchsrc: i32,
    lpdeststr: super::Foundation::PSTR,
    cchdest: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FoldStringA(
                dwmapflags: FOLD_STRING_MAP_FLAGS,
                lpsrcstr: super::Foundation::PSTR,
                cchsrc: i32,
                lpdeststr: super::Foundation::PSTR,
                cchdest: i32,
            ) -> i32;
        }
        ::std::mem::transmute(FoldStringA(
            ::std::mem::transmute(dwmapflags),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpdeststr),
            ::std::mem::transmute(cchdest),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FoldStringW<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwmapflags: FOLD_STRING_MAP_FLAGS,
    lpsrcstr: Param1,
    cchsrc: i32,
    lpdeststr: super::Foundation::PWSTR,
    cchdest: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn FoldStringW(
                dwmapflags: FOLD_STRING_MAP_FLAGS,
                lpsrcstr: super::Foundation::PWSTR,
                cchsrc: i32,
                lpdeststr: super::Foundation::PWSTR,
                cchdest: i32,
            ) -> i32;
        }
        ::std::mem::transmute(FoldStringW(
            ::std::mem::transmute(dwmapflags),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpdeststr),
            ::std::mem::transmute(cchdest),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const GCSEX_CANCELRECONVERT: u32 = 268435456u32;
pub const GCS_COMPATTR: u32 = 16u32;
pub const GCS_COMPCLAUSE: u32 = 32u32;
pub const GCS_COMPREADATTR: u32 = 2u32;
pub const GCS_COMPREADCLAUSE: u32 = 4u32;
pub const GCS_COMPREADSTR: u32 = 1u32;
pub const GCS_COMPSTR: u32 = 8u32;
pub const GCS_CURSORPOS: u32 = 128u32;
pub const GCS_DELTASTART: u32 = 256u32;
pub const GCS_RESULTCLAUSE: u32 = 4096u32;
pub const GCS_RESULTREADCLAUSE: u32 = 1024u32;
pub const GCS_RESULTREADSTR: u32 = 512u32;
pub const GCS_RESULTSTR: u32 = 2048u32;
pub const GEOID_NOT_AVAILABLE: i32 = -1i32;
#[cfg(feature = "Win32_Foundation")]
pub type GEO_ENUMNAMEPROC = unsafe extern "system" fn(
    param0: super::Foundation::PWSTR,
    param1: super::Foundation::LPARAM,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type GEO_ENUMPROC = unsafe extern "system" fn(param0: i32) -> super::Foundation::BOOL;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct GET_CONVERSION_LIST_FLAG(pub u32);
pub const GCL_CONVERSION: GET_CONVERSION_LIST_FLAG = GET_CONVERSION_LIST_FLAG(1u32);
pub const GCL_REVERSECONVERSION: GET_CONVERSION_LIST_FLAG = GET_CONVERSION_LIST_FLAG(2u32);
pub const GCL_REVERSE_LENGTH: GET_CONVERSION_LIST_FLAG = GET_CONVERSION_LIST_FLAG(3u32);
impl ::std::convert::From<u32> for GET_CONVERSION_LIST_FLAG {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for GET_CONVERSION_LIST_FLAG {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for GET_CONVERSION_LIST_FLAG {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for GET_CONVERSION_LIST_FLAG {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for GET_CONVERSION_LIST_FLAG {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for GET_CONVERSION_LIST_FLAG {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for GET_CONVERSION_LIST_FLAG {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct GET_GUIDE_LINE_TYPE(pub u32);
pub const GGL_LEVEL: GET_GUIDE_LINE_TYPE = GET_GUIDE_LINE_TYPE(1u32);
pub const GGL_INDEX: GET_GUIDE_LINE_TYPE = GET_GUIDE_LINE_TYPE(2u32);
pub const GGL_STRING: GET_GUIDE_LINE_TYPE = GET_GUIDE_LINE_TYPE(3u32);
pub const GGL_PRIVATE: GET_GUIDE_LINE_TYPE = GET_GUIDE_LINE_TYPE(4u32);
impl ::std::convert::From<u32> for GET_GUIDE_LINE_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for GET_GUIDE_LINE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for GET_GUIDE_LINE_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for GET_GUIDE_LINE_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for GET_GUIDE_LINE_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for GET_GUIDE_LINE_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for GET_GUIDE_LINE_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const GL_ID_CANNOTSAVE: u32 = 17u32;
pub const GL_ID_CHOOSECANDIDATE: u32 = 40u32;
pub const GL_ID_INPUTCODE: u32 = 38u32;
pub const GL_ID_INPUTRADICAL: u32 = 37u32;
pub const GL_ID_INPUTREADING: u32 = 36u32;
pub const GL_ID_INPUTSYMBOL: u32 = 39u32;
pub const GL_ID_NOCONVERT: u32 = 32u32;
pub const GL_ID_NODICTIONARY: u32 = 16u32;
pub const GL_ID_NOMODULE: u32 = 1u32;
pub const GL_ID_PRIVATE_FIRST: u32 = 32768u32;
pub const GL_ID_PRIVATE_LAST: u32 = 65535u32;
pub const GL_ID_READINGCONFLICT: u32 = 35u32;
pub const GL_ID_REVERSECONVERSION: u32 = 41u32;
pub const GL_ID_TOOMANYSTROKE: u32 = 34u32;
pub const GL_ID_TYPINGERROR: u32 = 33u32;
pub const GL_ID_UNKNOWN: u32 = 0u32;
pub const GL_LEVEL_ERROR: u32 = 2u32;
pub const GL_LEVEL_FATAL: u32 = 1u32;
pub const GL_LEVEL_INFORMATION: u32 = 4u32;
pub const GL_LEVEL_NOGUIDELINE: u32 = 0u32;
pub const GL_LEVEL_WARNING: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct GOFFSET {
    pub du: i32,
    pub dv: i32,
}
impl GOFFSET {}
impl ::std::default::Default for GOFFSET {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for GOFFSET {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("GOFFSET")
            .field("du", &self.du)
            .field("dv", &self.dv)
            .finish()
    }
}
impl ::std::cmp::PartialEq for GOFFSET {
    fn eq(&self, other: &Self) -> bool {
        self.du == other.du && self.dv == other.dv
    }
}
impl ::std::cmp::Eq for GOFFSET {}
unsafe impl ::windows::runtime::Abi for GOFFSET {
    type Abi = Self;
    type DefaultType = Self;
}
pub const GSS_ALLOW_INHERITED_COMMON: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct GUIDELINE {
    pub dwSize: u32,
    pub dwLevel: u32,
    pub dwIndex: u32,
    pub dwStrLen: u32,
    pub dwStrOffset: u32,
    pub dwPrivateSize: u32,
    pub dwPrivateOffset: u32,
}
impl GUIDELINE {}
impl ::std::default::Default for GUIDELINE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for GUIDELINE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("GUIDELINE")
            .field("dwSize", &self.dwSize)
            .field("dwLevel", &self.dwLevel)
            .field("dwIndex", &self.dwIndex)
            .field("dwStrLen", &self.dwStrLen)
            .field("dwStrOffset", &self.dwStrOffset)
            .field("dwPrivateSize", &self.dwPrivateSize)
            .field("dwPrivateOffset", &self.dwPrivateOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for GUIDELINE {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwLevel == other.dwLevel
            && self.dwIndex == other.dwIndex
            && self.dwStrLen == other.dwStrLen
            && self.dwStrOffset == other.dwStrOffset
            && self.dwPrivateSize == other.dwPrivateSize
            && self.dwPrivateOffset == other.dwPrivateOffset
    }
}
impl ::std::cmp::Eq for GUIDELINE {}
unsafe impl ::windows::runtime::Abi for GUIDELINE {
    type Abi = Self;
    type DefaultType = Self;
}
pub unsafe fn GetACP() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetACP() -> u32;
        }
        ::std::mem::transmute(GetACP())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCPInfo(codepage: u32, lpcpinfo: *mut CPINFO) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCPInfo(codepage: u32, lpcpinfo: *mut CPINFO) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetCPInfo(
            ::std::mem::transmute(codepage),
            ::std::mem::transmute(lpcpinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
pub unsafe fn GetCPInfoExA(
    codepage: u32,
    dwflags: u32,
    lpcpinfoex: *mut CPINFOEXA,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCPInfoExA(
                codepage: u32,
                dwflags: u32,
                lpcpinfoex: *mut CPINFOEXA,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetCPInfoExA(
            ::std::mem::transmute(codepage),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpcpinfoex),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCPInfoExW(
    codepage: u32,
    dwflags: u32,
    lpcpinfoex: *mut CPINFOEXW,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCPInfoExW(
                codepage: u32,
                dwflags: u32,
                lpcpinfoex: *mut CPINFOEXW,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetCPInfoExW(
            ::std::mem::transmute(codepage),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpcpinfoex),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCalendarInfoA(
    locale: u32,
    calendar: u32,
    caltype: u32,
    lpcaldata: super::Foundation::PSTR,
    cchdata: i32,
    lpvalue: *mut u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCalendarInfoA(
                locale: u32,
                calendar: u32,
                caltype: u32,
                lpcaldata: super::Foundation::PSTR,
                cchdata: i32,
                lpvalue: *mut u32,
            ) -> i32;
        }
        ::std::mem::transmute(GetCalendarInfoA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
            ::std::mem::transmute(lpcaldata),
            ::std::mem::transmute(cchdata),
            ::std::mem::transmute(lpvalue),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCalendarInfoEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
    calendar: u32,
    lpreserved: Param2,
    caltype: u32,
    lpcaldata: super::Foundation::PWSTR,
    cchdata: i32,
    lpvalue: *mut u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCalendarInfoEx(
                lplocalename: super::Foundation::PWSTR,
                calendar: u32,
                lpreserved: super::Foundation::PWSTR,
                caltype: u32,
                lpcaldata: super::Foundation::PWSTR,
                cchdata: i32,
                lpvalue: *mut u32,
            ) -> i32;
        }
        ::std::mem::transmute(GetCalendarInfoEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(calendar),
            lpreserved.into_param().abi(),
            ::std::mem::transmute(caltype),
            ::std::mem::transmute(lpcaldata),
            ::std::mem::transmute(cchdata),
            ::std::mem::transmute(lpvalue),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCalendarInfoW(
    locale: u32,
    calendar: u32,
    caltype: u32,
    lpcaldata: super::Foundation::PWSTR,
    cchdata: i32,
    lpvalue: *mut u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCalendarInfoW(
                locale: u32,
                calendar: u32,
                caltype: u32,
                lpcaldata: super::Foundation::PWSTR,
                cchdata: i32,
                lpvalue: *mut u32,
            ) -> i32;
        }
        ::std::mem::transmute(GetCalendarInfoW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
            ::std::mem::transmute(lpcaldata),
            ::std::mem::transmute(cchdata),
            ::std::mem::transmute(lpvalue),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCurrencyFormatA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    dwflags: u32,
    lpvalue: Param2,
    lpformat: *const CURRENCYFMTA,
    lpcurrencystr: super::Foundation::PSTR,
    cchcurrency: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCurrencyFormatA(
                locale: u32,
                dwflags: u32,
                lpvalue: super::Foundation::PSTR,
                lpformat: *const CURRENCYFMTA,
                lpcurrencystr: super::Foundation::PSTR,
                cchcurrency: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetCurrencyFormatA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            lpvalue.into_param().abi(),
            ::std::mem::transmute(lpformat),
            ::std::mem::transmute(lpcurrencystr),
            ::std::mem::transmute(cchcurrency),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCurrencyFormatEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
    dwflags: u32,
    lpvalue: Param2,
    lpformat: *const CURRENCYFMTW,
    lpcurrencystr: super::Foundation::PWSTR,
    cchcurrency: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCurrencyFormatEx(
                lplocalename: super::Foundation::PWSTR,
                dwflags: u32,
                lpvalue: super::Foundation::PWSTR,
                lpformat: *const CURRENCYFMTW,
                lpcurrencystr: super::Foundation::PWSTR,
                cchcurrency: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetCurrencyFormatEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwflags),
            lpvalue.into_param().abi(),
            ::std::mem::transmute(lpformat),
            ::std::mem::transmute(lpcurrencystr),
            ::std::mem::transmute(cchcurrency),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCurrencyFormatW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwflags: u32,
    lpvalue: Param2,
    lpformat: *const CURRENCYFMTW,
    lpcurrencystr: super::Foundation::PWSTR,
    cchcurrency: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetCurrencyFormatW(
                locale: u32,
                dwflags: u32,
                lpvalue: super::Foundation::PWSTR,
                lpformat: *const CURRENCYFMTW,
                lpcurrencystr: super::Foundation::PWSTR,
                cchcurrency: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetCurrencyFormatW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            lpvalue.into_param().abi(),
            ::std::mem::transmute(lpformat),
            ::std::mem::transmute(lpcurrencystr),
            ::std::mem::transmute(cchcurrency),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDateFormatA<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    dwflags: u32,
    lpdate: *const super::Foundation::SYSTEMTIME,
    lpformat: Param3,
    lpdatestr: super::Foundation::PSTR,
    cchdate: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDateFormatA(
                locale: u32,
                dwflags: u32,
                lpdate: *const super::Foundation::SYSTEMTIME,
                lpformat: super::Foundation::PSTR,
                lpdatestr: super::Foundation::PSTR,
                cchdate: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetDateFormatA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpdate),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lpdatestr),
            ::std::mem::transmute(cchdate),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDateFormatEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param6: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
    dwflags: ENUM_DATE_FORMATS_FLAGS,
    lpdate: *const super::Foundation::SYSTEMTIME,
    lpformat: Param3,
    lpdatestr: super::Foundation::PWSTR,
    cchdate: i32,
    lpcalendar: Param6,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDateFormatEx(
                lplocalename: super::Foundation::PWSTR,
                dwflags: ENUM_DATE_FORMATS_FLAGS,
                lpdate: *const super::Foundation::SYSTEMTIME,
                lpformat: super::Foundation::PWSTR,
                lpdatestr: super::Foundation::PWSTR,
                cchdate: i32,
                lpcalendar: super::Foundation::PWSTR,
            ) -> i32;
        }
        ::std::mem::transmute(GetDateFormatEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpdate),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lpdatestr),
            ::std::mem::transmute(cchdate),
            lpcalendar.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDateFormatW<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwflags: u32,
    lpdate: *const super::Foundation::SYSTEMTIME,
    lpformat: Param3,
    lpdatestr: super::Foundation::PWSTR,
    cchdate: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDateFormatW(
                locale: u32,
                dwflags: u32,
                lpdate: *const super::Foundation::SYSTEMTIME,
                lpformat: super::Foundation::PWSTR,
                lpdatestr: super::Foundation::PWSTR,
                cchdate: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetDateFormatW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpdate),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lpdatestr),
            ::std::mem::transmute(cchdate),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDistanceOfClosestLanguageInList<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    pszlanguage: Param0,
    pszlanguageslist: Param1,
    wchlistdelimiter: u16,
) -> ::windows::runtime::Result<f64> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDistanceOfClosestLanguageInList(
                pszlanguage: super::Foundation::PWSTR,
                pszlanguageslist: super::Foundation::PWSTR,
                wchlistdelimiter: u16,
                pclosestdistance: *mut f64,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        GetDistanceOfClosestLanguageInList(
            pszlanguage.into_param().abi(),
            pszlanguageslist.into_param().abi(),
            ::std::mem::transmute(wchlistdelimiter),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDurationFormat<
    'a,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwflags: u32,
    lpduration: *const super::Foundation::SYSTEMTIME,
    ullduration: u64,
    lpformat: Param4,
    lpdurationstr: super::Foundation::PWSTR,
    cchduration: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDurationFormat(
                locale: u32,
                dwflags: u32,
                lpduration: *const super::Foundation::SYSTEMTIME,
                ullduration: u64,
                lpformat: super::Foundation::PWSTR,
                lpdurationstr: super::Foundation::PWSTR,
                cchduration: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetDurationFormat(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpduration),
            ::std::mem::transmute(ullduration),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lpdurationstr),
            ::std::mem::transmute(cchduration),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDurationFormatEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
    dwflags: u32,
    lpduration: *const super::Foundation::SYSTEMTIME,
    ullduration: u64,
    lpformat: Param4,
    lpdurationstr: super::Foundation::PWSTR,
    cchduration: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetDurationFormatEx(
                lplocalename: super::Foundation::PWSTR,
                dwflags: u32,
                lpduration: *const super::Foundation::SYSTEMTIME,
                ullduration: u64,
                lpformat: super::Foundation::PWSTR,
                lpdurationstr: super::Foundation::PWSTR,
                cchduration: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetDurationFormatEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpduration),
            ::std::mem::transmute(ullduration),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lpdurationstr),
            ::std::mem::transmute(cchduration),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetFileMUIInfo<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    pcwszfilepath: Param1,
    pfilemuiinfo: *mut FILEMUIINFO,
    pcbfilemuiinfo: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetFileMUIInfo(
                dwflags: u32,
                pcwszfilepath: super::Foundation::PWSTR,
                pfilemuiinfo: *mut FILEMUIINFO,
                pcbfilemuiinfo: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetFileMUIInfo(
            ::std::mem::transmute(dwflags),
            pcwszfilepath.into_param().abi(),
            ::std::mem::transmute(pfilemuiinfo),
            ::std::mem::transmute(pcbfilemuiinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetFileMUIPath<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    pcwszfilepath: Param1,
    pwszlanguage: Param2,
    pcchlanguage: *mut u32,
    pwszfilemuipath: super::Foundation::PWSTR,
    pcchfilemuipath: *mut u32,
    pululenumerator: *mut u64,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetFileMUIPath(
                dwflags: u32,
                pcwszfilepath: super::Foundation::PWSTR,
                pwszlanguage: super::Foundation::PWSTR,
                pcchlanguage: *mut u32,
                pwszfilemuipath: super::Foundation::PWSTR,
                pcchfilemuipath: *mut u32,
                pululenumerator: *mut u64,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetFileMUIPath(
            ::std::mem::transmute(dwflags),
            pcwszfilepath.into_param().abi(),
            pwszlanguage.into_param().abi(),
            ::std::mem::transmute(pcchlanguage),
            ::std::mem::transmute(pwszfilemuipath),
            ::std::mem::transmute(pcchfilemuipath),
            ::std::mem::transmute(pululenumerator),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetGeoInfoA(
    location: i32,
    geotype: u32,
    lpgeodata: super::Foundation::PSTR,
    cchdata: i32,
    langid: u16,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetGeoInfoA(
                location: i32,
                geotype: u32,
                lpgeodata: super::Foundation::PSTR,
                cchdata: i32,
                langid: u16,
            ) -> i32;
        }
        ::std::mem::transmute(GetGeoInfoA(
            ::std::mem::transmute(location),
            ::std::mem::transmute(geotype),
            ::std::mem::transmute(lpgeodata),
            ::std::mem::transmute(cchdata),
            ::std::mem::transmute(langid),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetGeoInfoEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    location: Param0,
    geotype: u32,
    geodata: super::Foundation::PWSTR,
    geodatacount: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetGeoInfoEx(
                location: super::Foundation::PWSTR,
                geotype: u32,
                geodata: super::Foundation::PWSTR,
                geodatacount: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetGeoInfoEx(
            location.into_param().abi(),
            ::std::mem::transmute(geotype),
            ::std::mem::transmute(geodata),
            ::std::mem::transmute(geodatacount),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetGeoInfoW(
    location: i32,
    geotype: u32,
    lpgeodata: super::Foundation::PWSTR,
    cchdata: i32,
    langid: u16,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetGeoInfoW(
                location: i32,
                geotype: u32,
                lpgeodata: super::Foundation::PWSTR,
                cchdata: i32,
                langid: u16,
            ) -> i32;
        }
        ::std::mem::transmute(GetGeoInfoW(
            ::std::mem::transmute(location),
            ::std::mem::transmute(geotype),
            ::std::mem::transmute(lpgeodata),
            ::std::mem::transmute(cchdata),
            ::std::mem::transmute(langid),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetLocaleInfoA(
    locale: u32,
    lctype: u32,
    lplcdata: super::Foundation::PSTR,
    cchdata: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetLocaleInfoA(
                locale: u32,
                lctype: u32,
                lplcdata: super::Foundation::PSTR,
                cchdata: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetLocaleInfoA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(lctype),
            ::std::mem::transmute(lplcdata),
            ::std::mem::transmute(cchdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetLocaleInfoEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
    lctype: u32,
    lplcdata: super::Foundation::PWSTR,
    cchdata: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetLocaleInfoEx(
                lplocalename: super::Foundation::PWSTR,
                lctype: u32,
                lplcdata: super::Foundation::PWSTR,
                cchdata: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetLocaleInfoEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(lctype),
            ::std::mem::transmute(lplcdata),
            ::std::mem::transmute(cchdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetLocaleInfoW(
    locale: u32,
    lctype: u32,
    lplcdata: super::Foundation::PWSTR,
    cchdata: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetLocaleInfoW(
                locale: u32,
                lctype: u32,
                lplcdata: super::Foundation::PWSTR,
                cchdata: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetLocaleInfoW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(lctype),
            ::std::mem::transmute(lplcdata),
            ::std::mem::transmute(cchdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetNLSVersion(
    function: u32,
    locale: u32,
    lpversioninformation: *mut NLSVERSIONINFO,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNLSVersion(
                function: u32,
                locale: u32,
                lpversioninformation: *mut NLSVERSIONINFO,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetNLSVersion(
            ::std::mem::transmute(function),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(lpversioninformation),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetNLSVersionEx<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    function: u32,
    lplocalename: Param1,
    lpversioninformation: *mut NLSVERSIONINFOEX,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNLSVersionEx(
                function: u32,
                lplocalename: super::Foundation::PWSTR,
                lpversioninformation: *mut NLSVERSIONINFOEX,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetNLSVersionEx(
            ::std::mem::transmute(function),
            lplocalename.into_param().abi(),
            ::std::mem::transmute(lpversioninformation),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetNumberFormatA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    dwflags: u32,
    lpvalue: Param2,
    lpformat: *const NUMBERFMTA,
    lpnumberstr: super::Foundation::PSTR,
    cchnumber: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNumberFormatA(
                locale: u32,
                dwflags: u32,
                lpvalue: super::Foundation::PSTR,
                lpformat: *const NUMBERFMTA,
                lpnumberstr: super::Foundation::PSTR,
                cchnumber: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetNumberFormatA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            lpvalue.into_param().abi(),
            ::std::mem::transmute(lpformat),
            ::std::mem::transmute(lpnumberstr),
            ::std::mem::transmute(cchnumber),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetNumberFormatEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
    dwflags: u32,
    lpvalue: Param2,
    lpformat: *const NUMBERFMTW,
    lpnumberstr: super::Foundation::PWSTR,
    cchnumber: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNumberFormatEx(
                lplocalename: super::Foundation::PWSTR,
                dwflags: u32,
                lpvalue: super::Foundation::PWSTR,
                lpformat: *const NUMBERFMTW,
                lpnumberstr: super::Foundation::PWSTR,
                cchnumber: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetNumberFormatEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwflags),
            lpvalue.into_param().abi(),
            ::std::mem::transmute(lpformat),
            ::std::mem::transmute(lpnumberstr),
            ::std::mem::transmute(cchnumber),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetNumberFormatW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwflags: u32,
    lpvalue: Param2,
    lpformat: *const NUMBERFMTW,
    lpnumberstr: super::Foundation::PWSTR,
    cchnumber: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetNumberFormatW(
                locale: u32,
                dwflags: u32,
                lpvalue: super::Foundation::PWSTR,
                lpformat: *const NUMBERFMTW,
                lpnumberstr: super::Foundation::PWSTR,
                cchnumber: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetNumberFormatW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            lpvalue.into_param().abi(),
            ::std::mem::transmute(lpformat),
            ::std::mem::transmute(lpnumberstr),
            ::std::mem::transmute(cchnumber),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetOEMCP() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetOEMCP() -> u32;
        }
        ::std::mem::transmute(GetOEMCP())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetProcessPreferredUILanguages(
    dwflags: u32,
    pulnumlanguages: *mut u32,
    pwszlanguagesbuffer: super::Foundation::PWSTR,
    pcchlanguagesbuffer: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetProcessPreferredUILanguages(
                dwflags: u32,
                pulnumlanguages: *mut u32,
                pwszlanguagesbuffer: super::Foundation::PWSTR,
                pcchlanguagesbuffer: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetProcessPreferredUILanguages(
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pulnumlanguages),
            ::std::mem::transmute(pwszlanguagesbuffer),
            ::std::mem::transmute(pcchlanguagesbuffer),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetStringScripts<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    lpstring: Param1,
    cchstring: i32,
    lpscripts: super::Foundation::PWSTR,
    cchscripts: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringScripts(
                dwflags: u32,
                lpstring: super::Foundation::PWSTR,
                cchstring: i32,
                lpscripts: super::Foundation::PWSTR,
                cchscripts: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetStringScripts(
            ::std::mem::transmute(dwflags),
            lpstring.into_param().abi(),
            ::std::mem::transmute(cchstring),
            ::std::mem::transmute(lpscripts),
            ::std::mem::transmute(cchscripts),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetStringTypeA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    dwinfotype: u32,
    lpsrcstr: Param2,
    cchsrc: i32,
    lpchartype: *mut u16,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeA(
                locale: u32,
                dwinfotype: u32,
                lpsrcstr: super::Foundation::PSTR,
                cchsrc: i32,
                lpchartype: *mut u16,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwinfotype),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpchartype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetStringTypeExA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    dwinfotype: u32,
    lpsrcstr: Param2,
    cchsrc: i32,
    lpchartype: *mut u16,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeExA(
                locale: u32,
                dwinfotype: u32,
                lpsrcstr: super::Foundation::PSTR,
                cchsrc: i32,
                lpchartype: *mut u16,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeExA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwinfotype),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpchartype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetStringTypeExW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwinfotype: u32,
    lpsrcstr: Param2,
    cchsrc: i32,
    lpchartype: *mut u16,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeExW(
                locale: u32,
                dwinfotype: u32,
                lpsrcstr: super::Foundation::PWSTR,
                cchsrc: i32,
                lpchartype: *mut u16,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeExW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwinfotype),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpchartype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetStringTypeW<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwinfotype: u32,
    lpsrcstr: Param1,
    cchsrc: i32,
    lpchartype: *mut u16,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetStringTypeW(
                dwinfotype: u32,
                lpsrcstr: super::Foundation::PWSTR,
                cchsrc: i32,
                lpchartype: *mut u16,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetStringTypeW(
            ::std::mem::transmute(dwinfotype),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpchartype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetSystemDefaultLCID() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultLCID() -> u32;
        }
        ::std::mem::transmute(GetSystemDefaultLCID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetSystemDefaultLangID() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultLangID() -> u16;
        }
        ::std::mem::transmute(GetSystemDefaultLangID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetSystemDefaultLocaleName(
    lplocalename: super::Foundation::PWSTR,
    cchlocalename: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultLocaleName(
                lplocalename: super::Foundation::PWSTR,
                cchlocalename: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetSystemDefaultLocaleName(
            ::std::mem::transmute(lplocalename),
            ::std::mem::transmute(cchlocalename),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetSystemDefaultUILanguage() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemDefaultUILanguage() -> u16;
        }
        ::std::mem::transmute(GetSystemDefaultUILanguage())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetSystemPreferredUILanguages(
    dwflags: u32,
    pulnumlanguages: *mut u32,
    pwszlanguagesbuffer: super::Foundation::PWSTR,
    pcchlanguagesbuffer: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetSystemPreferredUILanguages(
                dwflags: u32,
                pulnumlanguages: *mut u32,
                pwszlanguagesbuffer: super::Foundation::PWSTR,
                pcchlanguagesbuffer: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetSystemPreferredUILanguages(
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pulnumlanguages),
            ::std::mem::transmute(pwszlanguagesbuffer),
            ::std::mem::transmute(pcchlanguagesbuffer),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn GetTextCharset<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTextCharset(hdc: super::Graphics::Gdi::HDC) -> i32;
        }
        ::std::mem::transmute(GetTextCharset(hdc.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn GetTextCharsetInfo<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    lpsig: *mut FONTSIGNATURE,
    dwflags: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTextCharsetInfo(
                hdc: super::Graphics::Gdi::HDC,
                lpsig: *mut FONTSIGNATURE,
                dwflags: u32,
            ) -> i32;
        }
        ::std::mem::transmute(GetTextCharsetInfo(
            hdc.into_param().abi(),
            ::std::mem::transmute(lpsig),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetThreadLocale() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadLocale() -> u32;
        }
        ::std::mem::transmute(GetThreadLocale())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetThreadPreferredUILanguages(
    dwflags: u32,
    pulnumlanguages: *mut u32,
    pwszlanguagesbuffer: super::Foundation::PWSTR,
    pcchlanguagesbuffer: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadPreferredUILanguages(
                dwflags: u32,
                pulnumlanguages: *mut u32,
                pwszlanguagesbuffer: super::Foundation::PWSTR,
                pcchlanguagesbuffer: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetThreadPreferredUILanguages(
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pulnumlanguages),
            ::std::mem::transmute(pwszlanguagesbuffer),
            ::std::mem::transmute(pcchlanguagesbuffer),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetThreadUILanguage() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetThreadUILanguage() -> u16;
        }
        ::std::mem::transmute(GetThreadUILanguage())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetTimeFormatA<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    dwflags: u32,
    lptime: *const super::Foundation::SYSTEMTIME,
    lpformat: Param3,
    lptimestr: super::Foundation::PSTR,
    cchtime: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTimeFormatA(
                locale: u32,
                dwflags: u32,
                lptime: *const super::Foundation::SYSTEMTIME,
                lpformat: super::Foundation::PSTR,
                lptimestr: super::Foundation::PSTR,
                cchtime: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetTimeFormatA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lptime),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lptimestr),
            ::std::mem::transmute(cchtime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetTimeFormatEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
    dwflags: TIME_FORMAT_FLAGS,
    lptime: *const super::Foundation::SYSTEMTIME,
    lpformat: Param3,
    lptimestr: super::Foundation::PWSTR,
    cchtime: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTimeFormatEx(
                lplocalename: super::Foundation::PWSTR,
                dwflags: TIME_FORMAT_FLAGS,
                lptime: *const super::Foundation::SYSTEMTIME,
                lpformat: super::Foundation::PWSTR,
                lptimestr: super::Foundation::PWSTR,
                cchtime: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetTimeFormatEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lptime),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lptimestr),
            ::std::mem::transmute(cchtime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetTimeFormatW<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwflags: u32,
    lptime: *const super::Foundation::SYSTEMTIME,
    lpformat: Param3,
    lptimestr: super::Foundation::PWSTR,
    cchtime: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetTimeFormatW(
                locale: u32,
                dwflags: u32,
                lptime: *const super::Foundation::SYSTEMTIME,
                lpformat: super::Foundation::PWSTR,
                lptimestr: super::Foundation::PWSTR,
                cchtime: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetTimeFormatW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lptime),
            lpformat.into_param().abi(),
            ::std::mem::transmute(lptimestr),
            ::std::mem::transmute(cchtime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetUILanguageInfo<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    pwmszlanguage: Param1,
    pwszfallbacklanguages: super::Foundation::PWSTR,
    pcchfallbacklanguages: *mut u32,
    pattributes: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUILanguageInfo(
                dwflags: u32,
                pwmszlanguage: super::Foundation::PWSTR,
                pwszfallbacklanguages: super::Foundation::PWSTR,
                pcchfallbacklanguages: *mut u32,
                pattributes: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetUILanguageInfo(
            ::std::mem::transmute(dwflags),
            pwmszlanguage.into_param().abi(),
            ::std::mem::transmute(pwszfallbacklanguages),
            ::std::mem::transmute(pcchfallbacklanguages),
            ::std::mem::transmute(pattributes),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetUserDefaultGeoName(geoname: super::Foundation::PWSTR, geonamecount: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultGeoName(geoname: super::Foundation::PWSTR, geonamecount: i32) -> i32;
        }
        ::std::mem::transmute(GetUserDefaultGeoName(
            ::std::mem::transmute(geoname),
            ::std::mem::transmute(geonamecount),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetUserDefaultLCID() -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultLCID() -> u32;
        }
        ::std::mem::transmute(GetUserDefaultLCID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetUserDefaultLangID() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultLangID() -> u16;
        }
        ::std::mem::transmute(GetUserDefaultLangID())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetUserDefaultLocaleName(
    lplocalename: super::Foundation::PWSTR,
    cchlocalename: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultLocaleName(
                lplocalename: super::Foundation::PWSTR,
                cchlocalename: i32,
            ) -> i32;
        }
        ::std::mem::transmute(GetUserDefaultLocaleName(
            ::std::mem::transmute(lplocalename),
            ::std::mem::transmute(cchlocalename),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetUserDefaultUILanguage() -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserDefaultUILanguage() -> u16;
        }
        ::std::mem::transmute(GetUserDefaultUILanguage())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetUserGeoID(geoclass: u32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserGeoID(geoclass: u32) -> i32;
        }
        ::std::mem::transmute(GetUserGeoID(::std::mem::transmute(geoclass)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetUserPreferredUILanguages(
    dwflags: u32,
    pulnumlanguages: *mut u32,
    pwszlanguagesbuffer: super::Foundation::PWSTR,
    pcchlanguagesbuffer: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn GetUserPreferredUILanguages(
                dwflags: u32,
                pulnumlanguages: *mut u32,
                pwszlanguagesbuffer: super::Foundation::PWSTR,
                pcchlanguagesbuffer: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetUserPreferredUILanguages(
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pulnumlanguages),
            ::std::mem::transmute(pwszlanguagesbuffer),
            ::std::mem::transmute(pcchlanguagesbuffer),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const HIGHLEVEL_SERVICE_TYPES: u32 = 1u32;
pub const HIGH_SURROGATE_END: u32 = 56319u32;
pub const HIGH_SURROGATE_START: u32 = 55296u32;
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HIMC(pub isize);
impl ::std::default::Default for HIMC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HIMC {}
unsafe impl ::windows::runtime::Abi for HIMC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HIMCC(pub isize);
impl ::std::default::Default for HIMCC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HIMCC {}
unsafe impl ::windows::runtime::Abi for HIMCC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HSAVEDUILANGUAGES(pub isize);
impl ::std::default::Default for HSAVEDUILANGUAGES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HSAVEDUILANGUAGES {}
unsafe impl ::windows::runtime::Abi for HSAVEDUILANGUAGES {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IACE_CHILDREN: u32 = 1u32;
pub const IACE_DEFAULT: u32 = 16u32;
pub const IACE_IGNORENOCONTEXT: u32 = 32u32;
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActiveIME(::windows::runtime::IUnknown);
impl IActiveIME {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Inquire(
        &self,
        dwsysteminfoflags: u32,
        pimeinfo: *mut IMEINFO,
        szwndclass: super::Foundation::PWSTR,
        pdwprivate: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsysteminfoflags),
            ::std::mem::transmute(pimeinfo),
            ::std::mem::transmute(szwndclass),
            ::std::mem::transmute(pdwprivate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConversionList<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        himc: Param0,
        szsource: Param1,
        uflag: u32,
        ubuflen: u32,
        pdest: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            szsource.into_param().abi(),
            ::std::mem::transmute(uflag),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(pdest),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn Configure<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hkl: Param0,
        hwnd: Param1,
        dwmode: u32,
        pregisterword: *const REGISTERWORDW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pregisterword),
        )
        .ok()
    }
    pub unsafe fn Destroy(&self, ureserved: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ureserved),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Escape<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(uescape),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(plresult),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetActiveContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        himc: Param0,
        fflag: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            fflag.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessKey<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        uvirkey: u32,
        lparam: u32,
        pbkeystate: *const u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(uvirkey),
            ::std::mem::transmute(lparam),
            ::std::mem::transmute(pbkeystate),
        )
        .ok()
    }
    pub unsafe fn Notify<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwaction),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwvalue),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Select<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        himc: Param0,
        fselect: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            fselect.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetCompositionString<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(pread),
            ::std::mem::transmute(dwreadlen),
        )
        .ok()
    }
    pub unsafe fn ToAsciiEx<'a, Param4: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        uvirkey: u32,
        uscancode: u32,
        pbkeystate: *const u8,
        fustate: u32,
        himc: Param4,
        pdwtransbuf: *mut u32,
        pusize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uvirkey),
            ::std::mem::transmute(uscancode),
            ::std::mem::transmute(pbkeystate),
            ::std::mem::transmute(fustate),
            himc.into_param().abi(),
            ::std::mem::transmute(pdwtransbuf),
            ::std::mem::transmute(pusize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWord<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szreading: Param0,
        dwstyle: u32,
        szstring: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szstring.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnregisterWord<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szreading: Param0,
        dwstyle: u32,
        szstring: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szstring.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetRegisterWordStyle(
        &self,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pubufsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(pstylebuf),
            ::std::mem::transmute(pubufsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumRegisterWord<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szreading: Param0,
        dwstyle: u32,
        szregister: Param2,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<IEnumRegisterWordW> {
        let mut result__: <IEnumRegisterWordW as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
            ::std::mem::transmute(pdata),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordW>(result__)
    }
    pub unsafe fn GetCodePageA(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetLangId(&self) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u16>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IActiveIME {
    type Vtable = IActiveIME_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1877084514,
        53367,
        4560,
        [143, 231, 0, 170, 0, 107, 204, 89],
    );
}
impl ::std::convert::From<IActiveIME> for ::windows::runtime::IUnknown {
    fn from(value: IActiveIME) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActiveIME> for ::windows::runtime::IUnknown {
    fn from(value: &IActiveIME) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActiveIME {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IActiveIME {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveIME_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsysteminfoflags: u32,
        pimeinfo: *mut IMEINFO,
        szwndclass: super::Foundation::PWSTR,
        pdwprivate: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        szsource: super::Foundation::PWSTR,
        uflag: u32,
        ubuflen: u32,
        pdest: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        hwnd: super::Foundation::HWND,
        dwmode: u32,
        pregisterword: *const REGISTERWORDW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ureserved: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fflag: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        uvirkey: u32,
        lparam: u32,
        pbkeystate: *const u8,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fselect: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uvirkey: u32,
        uscancode: u32,
        pbkeystate: *const u8,
        fustate: u32,
        himc: HIMC,
        pdwtransbuf: *mut u32,
        pusize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szstring: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szstring: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pubufsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szregister: super::Foundation::PWSTR,
        pdata: *const ::std::ffi::c_void,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ucodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plid: *mut u16,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActiveIME2(::windows::runtime::IUnknown);
impl IActiveIME2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Inquire(
        &self,
        dwsysteminfoflags: u32,
        pimeinfo: *mut IMEINFO,
        szwndclass: super::Foundation::PWSTR,
        pdwprivate: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsysteminfoflags),
            ::std::mem::transmute(pimeinfo),
            ::std::mem::transmute(szwndclass),
            ::std::mem::transmute(pdwprivate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConversionList<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        himc: Param0,
        szsource: Param1,
        uflag: u32,
        ubuflen: u32,
        pdest: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            szsource.into_param().abi(),
            ::std::mem::transmute(uflag),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(pdest),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn Configure<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hkl: Param0,
        hwnd: Param1,
        dwmode: u32,
        pregisterword: *const REGISTERWORDW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pregisterword),
        )
        .ok()
    }
    pub unsafe fn Destroy(&self, ureserved: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ureserved),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Escape<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(uescape),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(plresult),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetActiveContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        himc: Param0,
        fflag: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            fflag.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessKey<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        uvirkey: u32,
        lparam: u32,
        pbkeystate: *const u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(uvirkey),
            ::std::mem::transmute(lparam),
            ::std::mem::transmute(pbkeystate),
        )
        .ok()
    }
    pub unsafe fn Notify<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwaction),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwvalue),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Select<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        himc: Param0,
        fselect: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            fselect.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetCompositionString<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(pread),
            ::std::mem::transmute(dwreadlen),
        )
        .ok()
    }
    pub unsafe fn ToAsciiEx<'a, Param4: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        uvirkey: u32,
        uscancode: u32,
        pbkeystate: *const u8,
        fustate: u32,
        himc: Param4,
        pdwtransbuf: *mut u32,
        pusize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uvirkey),
            ::std::mem::transmute(uscancode),
            ::std::mem::transmute(pbkeystate),
            ::std::mem::transmute(fustate),
            himc.into_param().abi(),
            ::std::mem::transmute(pdwtransbuf),
            ::std::mem::transmute(pusize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWord<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szreading: Param0,
        dwstyle: u32,
        szstring: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szstring.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnregisterWord<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szreading: Param0,
        dwstyle: u32,
        szstring: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szstring.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetRegisterWordStyle(
        &self,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pubufsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(pstylebuf),
            ::std::mem::transmute(pubufsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumRegisterWord<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szreading: Param0,
        dwstyle: u32,
        szregister: Param2,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<IEnumRegisterWordW> {
        let mut result__: <IEnumRegisterWordW as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
            ::std::mem::transmute(pdata),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordW>(result__)
    }
    pub unsafe fn GetCodePageA(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetLangId(&self) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u16>(result__)
    }
    pub unsafe fn Sleep(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Unsleep<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        fdead: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            fdead.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActiveIME2 {
    type Vtable = IActiveIME2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3787767566,
        11603,
        4562,
        [147, 225, 0, 96, 176, 103, 184, 110],
    );
}
impl ::std::convert::From<IActiveIME2> for ::windows::runtime::IUnknown {
    fn from(value: IActiveIME2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActiveIME2> for ::windows::runtime::IUnknown {
    fn from(value: &IActiveIME2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActiveIME2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IActiveIME2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IActiveIME2> for IActiveIME {
    fn from(value: IActiveIME2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActiveIME2> for IActiveIME {
    fn from(value: &IActiveIME2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IActiveIME> for IActiveIME2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IActiveIME> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IActiveIME>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IActiveIME> for &IActiveIME2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IActiveIME> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IActiveIME>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveIME2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsysteminfoflags: u32,
        pimeinfo: *mut IMEINFO,
        szwndclass: super::Foundation::PWSTR,
        pdwprivate: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        szsource: super::Foundation::PWSTR,
        uflag: u32,
        ubuflen: u32,
        pdest: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        hwnd: super::Foundation::HWND,
        dwmode: u32,
        pregisterword: *const REGISTERWORDW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ureserved: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fflag: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        uvirkey: u32,
        lparam: u32,
        pbkeystate: *const u8,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fselect: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uvirkey: u32,
        uscancode: u32,
        pbkeystate: *const u8,
        fustate: u32,
        himc: HIMC,
        pdwtransbuf: *mut u32,
        pusize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szstring: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szstring: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pubufsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szregister: super::Foundation::PWSTR,
        pdata: *const ::std::ffi::c_void,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ucodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plid: *mut u16,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fdead: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActiveIMMApp(::windows::runtime::IUnknown);
impl IActiveIMMApp {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssociateContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hwnd: Param0,
        hime: Param1,
    ) -> ::windows::runtime::Result<HIMC> {
        let mut result__: <HIMC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            hime.into_param().abi(),
            &mut result__,
        )
        .from_abi::<HIMC>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn ConfigureIMEA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hkl: Param0,
        hwnd: Param1,
        dwmode: u32,
        pdata: *const REGISTERWORDA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn ConfigureIMEW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hkl: Param0,
        hwnd: Param1,
        dwmode: u32,
        pdata: *const REGISTERWORDW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn CreateContext(&self) -> ::windows::runtime::Result<HIMC> {
        let mut result__: <HIMC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<HIMC>(result__)
    }
    pub unsafe fn DestroyContext<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        hime: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            hime.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EnumRegisterWordA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<IEnumRegisterWordA> {
        let mut result__: <IEnumRegisterWordA as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
            ::std::mem::transmute(pdata),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordA>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EnumRegisterWordW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<IEnumRegisterWordW> {
        let mut result__: <IEnumRegisterWordW as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
            ::std::mem::transmute(pdata),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordW>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EscapeA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            ::std::mem::transmute(uescape),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(plresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EscapeW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            ::std::mem::transmute(uescape),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(plresult),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(pcandlist),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(pcandlist),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListCountA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pdwlistsize),
            ::std::mem::transmute(pdwbuflen),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListCountW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pdwlistsize),
            ::std::mem::transmute(pdwbuflen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCandidateWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
    ) -> ::windows::runtime::Result<CANDIDATEFORM> {
        let mut result__: <CANDIDATEFORM as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            &mut result__,
        )
        .from_abi::<CANDIDATEFORM>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCompositionFontA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<super::Graphics::Gdi::LOGFONTA> {
        let mut result__: <super::Graphics::Gdi::LOGFONTA as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Graphics::Gdi::LOGFONTA>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetCompositionFontW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<super::Graphics::Gdi::LOGFONTW> {
        let mut result__: <super::Graphics::Gdi::LOGFONTW as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Graphics::Gdi::LOGFONTW>(result__)
    }
    pub unsafe fn GetCompositionStringA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(plcopied),
            ::std::mem::transmute(pbuf),
        )
        .ok()
    }
    pub unsafe fn GetCompositionStringW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(plcopied),
            ::std::mem::transmute(pbuf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCompositionWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<COMPOSITIONFORM> {
        let mut result__: <COMPOSITIONFORM as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<COMPOSITIONFORM>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<HIMC> {
        let mut result__: <HIMC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<HIMC>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetConversionListA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        psrc: Param2,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            psrc.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(uflag),
            ::std::mem::transmute(pdst),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetConversionListW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        psrc: Param2,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            psrc.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(uflag),
            ::std::mem::transmute(pdst),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetConversionStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pfdwconversion: *mut u32,
        pfdwsentence: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pfdwconversion),
            ::std::mem::transmute(pfdwsentence),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultIMEWnd<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<super::Foundation::HWND> {
        let mut result__: <super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::HWND>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetDescriptionA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szdescription: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetDescriptionW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szdescription: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetGuideLineA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(pbuf),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetGuideLineW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PWSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(pbuf),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetIMEFileNameA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szfilename: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szfilename),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetIMEFileNameW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szfilename: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szfilename),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetOpenStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetProperty<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        fdwindex: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(fdwindex),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(all(
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_TextServices"
    ))]
    pub unsafe fn GetRegisterWordStyleA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        nitem: u32,
        pstylebuf: *mut STYLEBUFA,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(pstylebuf),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetRegisterWordStyleW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(pstylebuf),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStatusWindowPos<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<super::Foundation::POINT> {
        let mut result__: <super::Foundation::POINT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::POINT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetVirtualKey<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn InstallIMEA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        szimefilename: Param0,
        szlayouttext: Param1,
    ) -> ::windows::runtime::Result<super::UI::TextServices::HKL> {
        let mut result__: <super::UI::TextServices::HKL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            szimefilename.into_param().abi(),
            szlayouttext.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::UI::TextServices::HKL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn InstallIMEW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szimefilename: Param0,
        szlayouttext: Param1,
    ) -> ::windows::runtime::Result<super::UI::TextServices::HKL> {
        let mut result__: <super::UI::TextServices::HKL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            szimefilename.into_param().abi(),
            szlayouttext.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::UI::TextServices::HKL>(result__)
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn IsIME<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsUIMessageA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        hwndime: Param0,
        msg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            hwndime.into_param().abi(),
            ::std::mem::transmute(msg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsUIMessageW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        hwndime: Param0,
        msg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            hwndime.into_param().abi(),
            ::std::mem::transmute(msg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NotifyIME<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwaction),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwvalue),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn RegisterWordA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn RegisterWordW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReleaseContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hwnd: Param0,
        himc: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            himc.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCandidateWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pcandidate: *const CANDIDATEFORM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pcandidate),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn SetCompositionFontA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        plf: *const super::Graphics::Gdi::LOGFONTA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(plf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetCompositionFontW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        plf: *const super::Graphics::Gdi::LOGFONTW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(plf),
        )
        .ok()
    }
    pub unsafe fn SetCompositionStringA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(pread),
            ::std::mem::transmute(dwreadlen),
        )
        .ok()
    }
    pub unsafe fn SetCompositionStringW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(pread),
            ::std::mem::transmute(dwreadlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCompositionWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pcompform: *const COMPOSITIONFORM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pcompform),
        )
        .ok()
    }
    pub unsafe fn SetConversionStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        fdwconversion: u32,
        fdwsentence: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(fdwconversion),
            ::std::mem::transmute(fdwsentence),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOpenStatus<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        himc: Param0,
        fopen: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            fopen.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStatusWindowPos<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pptpos: *const super::Foundation::POINT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pptpos),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SimulateHotKey<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
        dwhotkeyid: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwhotkeyid),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn UnregisterWordA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szunregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szunregister.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn UnregisterWordW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szunregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szunregister.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Activate<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        frestorelayout: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            frestorelayout.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Deactivate(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnDefWindowProc<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        msg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<super::Foundation::LRESULT> {
        let mut result__: <super::Foundation::LRESULT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(msg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::LRESULT>(result__)
    }
    pub unsafe fn FilterClientWindows(
        &self,
        aaclasslist: *const u16,
        usize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(aaclasslist),
            ::std::mem::transmute(usize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetCodePageA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetLangId<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
    ) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u16>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssociateContextEx<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hwnd: Param0,
        himc: Param1,
        dwflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            himc.into_param().abi(),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    pub unsafe fn DisableIME(&self, idthread: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(idthread),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetImeMenuItemsA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOA,
        pimemenu: *mut IMEMENUITEMINFOA,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwtype),
            ::std::mem::transmute(pimeparentmenu),
            ::std::mem::transmute(pimemenu),
            ::std::mem::transmute(dwsize),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetImeMenuItemsW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOW,
        pimemenu: *mut IMEMENUITEMINFOW,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwtype),
            ::std::mem::transmute(pimeparentmenu),
            ::std::mem::transmute(pimemenu),
            ::std::mem::transmute(dwsize),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    pub unsafe fn EnumInputContext(
        &self,
        idthread: u32,
    ) -> ::windows::runtime::Result<IEnumInputContext> {
        let mut result__: <IEnumInputContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(idthread),
            &mut result__,
        )
        .from_abi::<IEnumInputContext>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IActiveIMMApp {
    type Vtable = IActiveIMMApp_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        146858048,
        25297,
        4561,
        [147, 38, 0, 96, 176, 103, 184, 110],
    );
}
impl ::std::convert::From<IActiveIMMApp> for ::windows::runtime::IUnknown {
    fn from(value: IActiveIMMApp) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActiveIMMApp> for ::windows::runtime::IUnknown {
    fn from(value: &IActiveIMMApp) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActiveIMMApp {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IActiveIMMApp {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveIMMApp_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        hime: HIMC,
        phprev: *mut HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        hwnd: super::Foundation::HWND,
        dwmode: u32,
        pdata: *const REGISTERWORDA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        hwnd: super::Foundation::HWND,
        dwmode: u32,
        pdata: *const REGISTERWORDW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phimc: *mut HIMC,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hime: HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PSTR,
        dwstyle: u32,
        szregister: super::Foundation::PSTR,
        pdata: *const ::std::ffi::c_void,
        penum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szregister: super::Foundation::PWSTR,
        pdata: *const ::std::ffi::c_void,
        penum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcandidate: *mut CANDIDATEFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *mut super::Graphics::Gdi::LOGFONTA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *mut super::Graphics::Gdi::LOGFONTW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pcompform: *mut COMPOSITIONFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        phimc: *mut HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        psrc: super::Foundation::PSTR,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        psrc: super::Foundation::PWSTR,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pfdwconversion: *mut u32,
        pfdwsentence: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        phdefwnd: *mut super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szdescription: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szdescription: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PWSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szfilename: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szfilename: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        fdwindex: u32,
        pdwproperty: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(all(
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_TextServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        nitem: u32,
        pstylebuf: *mut STYLEBUFA,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_TextServices"
    )))]
    usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pptpos: *mut super::Foundation::POINT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        puvirtualkey: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szimefilename: super::Foundation::PSTR,
        szlayouttext: super::Foundation::PSTR,
        phkl: *mut super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szimefilename: super::Foundation::PWSTR,
        szlayouttext: super::Foundation::PWSTR,
        phkl: *mut super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndime: super::Foundation::HWND,
        msg: u32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndime: super::Foundation::HWND,
        msg: u32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PSTR,
        dwstyle: u32,
        szregister: super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szregister: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        himc: HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pcandidate: *const CANDIDATEFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *const super::Graphics::Gdi::LOGFONTA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *const super::Graphics::Gdi::LOGFONTW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pcompform: *const COMPOSITIONFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fdwconversion: u32,
        fdwsentence: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fopen: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pptpos: *const super::Foundation::POINT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        dwhotkeyid: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PSTR,
        dwstyle: u32,
        szunregister: super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szunregister: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        frestorelayout: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        msg: u32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        aaclasslist: *const u16,
        usize: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ucodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        plid: *mut u16,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        himc: HIMC,
        dwflags: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        idthread: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOA,
        pimemenu: *mut IMEMENUITEMINFOA,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOW,
        pimemenu: *mut IMEMENUITEMINFOW,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        idthread: u32,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActiveIMMIME(::windows::runtime::IUnknown);
impl IActiveIMMIME {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssociateContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hwnd: Param0,
        hime: Param1,
    ) -> ::windows::runtime::Result<HIMC> {
        let mut result__: <HIMC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            hime.into_param().abi(),
            &mut result__,
        )
        .from_abi::<HIMC>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn ConfigureIMEA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hkl: Param0,
        hwnd: Param1,
        dwmode: u32,
        pdata: *const REGISTERWORDA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn ConfigureIMEW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hkl: Param0,
        hwnd: Param1,
        dwmode: u32,
        pdata: *const REGISTERWORDW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pdata),
        )
        .ok()
    }
    pub unsafe fn CreateContext(&self) -> ::windows::runtime::Result<HIMC> {
        let mut result__: <HIMC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<HIMC>(result__)
    }
    pub unsafe fn DestroyContext<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        hime: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            hime.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EnumRegisterWordA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<IEnumRegisterWordA> {
        let mut result__: <IEnumRegisterWordA as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
            ::std::mem::transmute(pdata),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordA>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EnumRegisterWordW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
        pdata: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<IEnumRegisterWordW> {
        let mut result__: <IEnumRegisterWordW as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
            ::std::mem::transmute(pdata),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordW>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EscapeA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            ::std::mem::transmute(uescape),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(plresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn EscapeW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            ::std::mem::transmute(uescape),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(plresult),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(pcandlist),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(pcandlist),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListCountA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pdwlistsize),
            ::std::mem::transmute(pdwbuflen),
        )
        .ok()
    }
    pub unsafe fn GetCandidateListCountW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pdwlistsize),
            ::std::mem::transmute(pdwbuflen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCandidateWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
    ) -> ::windows::runtime::Result<CANDIDATEFORM> {
        let mut result__: <CANDIDATEFORM as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            &mut result__,
        )
        .from_abi::<CANDIDATEFORM>(result__)
    }
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCompositionFontA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<super::Graphics::Gdi::LOGFONTA> {
        let mut result__: <super::Graphics::Gdi::LOGFONTA as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Graphics::Gdi::LOGFONTA>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetCompositionFontW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<super::Graphics::Gdi::LOGFONTW> {
        let mut result__: <super::Graphics::Gdi::LOGFONTW as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Graphics::Gdi::LOGFONTW>(result__)
    }
    pub unsafe fn GetCompositionStringA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(plcopied),
            ::std::mem::transmute(pbuf),
        )
        .ok()
    }
    pub unsafe fn GetCompositionStringW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(plcopied),
            ::std::mem::transmute(pbuf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCompositionWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<COMPOSITIONFORM> {
        let mut result__: <COMPOSITIONFORM as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<COMPOSITIONFORM>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<HIMC> {
        let mut result__: <HIMC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<HIMC>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetConversionListA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        psrc: Param2,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            psrc.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(uflag),
            ::std::mem::transmute(pdst),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetConversionListW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        himc: Param1,
        psrc: Param2,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            himc.into_param().abi(),
            psrc.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(uflag),
            ::std::mem::transmute(pdst),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetConversionStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pfdwconversion: *mut u32,
        pfdwsentence: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pfdwconversion),
            ::std::mem::transmute(pfdwsentence),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultIMEWnd<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<super::Foundation::HWND> {
        let mut result__: <super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::HWND>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetDescriptionA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szdescription: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetDescriptionW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szdescription: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szdescription),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetGuideLineA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(pbuf),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetGuideLineW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PWSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(pbuf),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetIMEFileNameA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szfilename: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szfilename),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn GetIMEFileNameW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        ubuflen: u32,
        szfilename: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(ubuflen),
            ::std::mem::transmute(szfilename),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    pub unsafe fn GetOpenStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetProperty<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        fdwindex: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(fdwindex),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(all(
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_TextServices"
    ))]
    pub unsafe fn GetRegisterWordStyleA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        nitem: u32,
        pstylebuf: *mut STYLEBUFA,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(pstylebuf),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetRegisterWordStyleW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pucopied: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(pstylebuf),
            ::std::mem::transmute(pucopied),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStatusWindowPos<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<super::Foundation::POINT> {
        let mut result__: <super::Foundation::POINT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::POINT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetVirtualKey<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn InstallIMEA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        szimefilename: Param0,
        szlayouttext: Param1,
    ) -> ::windows::runtime::Result<super::UI::TextServices::HKL> {
        let mut result__: <super::UI::TextServices::HKL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            szimefilename.into_param().abi(),
            szlayouttext.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::UI::TextServices::HKL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn InstallIMEW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        szimefilename: Param0,
        szlayouttext: Param1,
    ) -> ::windows::runtime::Result<super::UI::TextServices::HKL> {
        let mut result__: <super::UI::TextServices::HKL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            szimefilename.into_param().abi(),
            szlayouttext.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::UI::TextServices::HKL>(result__)
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn IsIME<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsUIMessageA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        hwndime: Param0,
        msg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            hwndime.into_param().abi(),
            ::std::mem::transmute(msg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsUIMessageW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        hwndime: Param0,
        msg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            hwndime.into_param().abi(),
            ::std::mem::transmute(msg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NotifyIME<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwaction),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwvalue),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn RegisterWordA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn RegisterWordW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szregister.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReleaseContext<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hwnd: Param0,
        himc: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            himc.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCandidateWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pcandidate: *const CANDIDATEFORM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pcandidate),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn SetCompositionFontA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        plf: *const super::Graphics::Gdi::LOGFONTA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(plf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetCompositionFontW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        plf: *const super::Graphics::Gdi::LOGFONTW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(plf),
        )
        .ok()
    }
    pub unsafe fn SetCompositionStringA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(pread),
            ::std::mem::transmute(dwreadlen),
        )
        .ok()
    }
    pub unsafe fn SetCompositionStringW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(pread),
            ::std::mem::transmute(dwreadlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCompositionWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pcompform: *const COMPOSITIONFORM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pcompform),
        )
        .ok()
    }
    pub unsafe fn SetConversionStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        fdwconversion: u32,
        fdwsentence: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(fdwconversion),
            ::std::mem::transmute(fdwsentence),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOpenStatus<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        himc: Param0,
        fopen: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            fopen.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStatusWindowPos<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        pptpos: *const super::Foundation::POINT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(pptpos),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SimulateHotKey<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
        dwhotkeyid: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwhotkeyid),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn UnregisterWordA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szunregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szunregister.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub unsafe fn UnregisterWordW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        hkl: Param0,
        szreading: Param1,
        dwstyle: u32,
        szunregister: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            szreading.into_param().abi(),
            ::std::mem::transmute(dwstyle),
            szunregister.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GenerateMessage<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn LockIMC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<*mut INPUTCONTEXT> {
        let mut result__: <*mut INPUTCONTEXT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<*mut INPUTCONTEXT>(result__)
    }
    pub unsafe fn UnlockIMC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetIMCLockCount<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CreateIMCC(&self, dwsize: u32) -> ::windows::runtime::Result<HIMCC> {
        let mut result__: <HIMCC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsize),
            &mut result__,
        )
        .from_abi::<HIMCC>(result__)
    }
    pub unsafe fn DestroyIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
        &self,
        himcc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            himcc.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn LockIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
        &self,
        himcc: Param0,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            himcc.into_param().abi(),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    pub unsafe fn UnlockIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
        &self,
        himcc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            himcc.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ReSizeIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
        &self,
        himcc: Param0,
        dwsize: u32,
    ) -> ::windows::runtime::Result<HIMCC> {
        let mut result__: <HIMCC as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            himcc.into_param().abi(),
            ::std::mem::transmute(dwsize),
            &mut result__,
        )
        .from_abi::<HIMCC>(result__)
    }
    pub unsafe fn GetIMCCSize<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
        &self,
        himcc: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            himcc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetIMCCLockCount<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
        &self,
        himcc: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            himcc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetHotKey(
        &self,
        dwhotkeyid: u32,
        pumodifiers: *mut u32,
        puvkey: *mut u32,
        phkl: *mut super::UI::TextServices::HKL,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwhotkeyid),
            ::std::mem::transmute(pumodifiers),
            ::std::mem::transmute(puvkey),
            ::std::mem::transmute(phkl),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn SetHotKey<
        'a,
        Param3: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        dwhotkeyid: u32,
        umodifiers: u32,
        uvkey: u32,
        hkl: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwhotkeyid),
            ::std::mem::transmute(umodifiers),
            ::std::mem::transmute(uvkey),
            hkl.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateSoftKeyboard<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        utype: u32,
        howner: Param1,
        x: i32,
        y: i32,
    ) -> ::windows::runtime::Result<super::Foundation::HWND> {
        let mut result__: <super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(utype),
            howner.into_param().abi(),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            &mut result__,
        )
        .from_abi::<super::Foundation::HWND>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DestroySoftKeyboard<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hsoftkbdwnd: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            hsoftkbdwnd.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowSoftKeyboard<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hsoftkbdwnd: Param0,
        ncmdshow: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            hsoftkbdwnd.into_param().abi(),
            ::std::mem::transmute(ncmdshow),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetCodePageA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).76)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_UI_TextServices")]
    pub unsafe fn GetLangId<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    >(
        &self,
        hkl: Param0,
    ) -> ::windows::runtime::Result<u16> {
        let mut result__: <u16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            hkl.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u16>(result__)
    }
    pub unsafe fn KeybdEvent(
        &self,
        lgidime: u16,
        bvk: u8,
        bscan: u8,
        dwflags: u32,
        dwextrainfo: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).78)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lgidime),
            ::std::mem::transmute(bvk),
            ::std::mem::transmute(bscan),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwextrainfo),
        )
        .ok()
    }
    pub unsafe fn LockModal(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).79)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UnlockModal(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).80)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AssociateContextEx<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    >(
        &self,
        hwnd: Param0,
        himc: Param1,
        dwflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            himc.into_param().abi(),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    pub unsafe fn DisableIME(&self, idthread: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(idthread),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetImeMenuItemsA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOA,
        pimemenu: *mut IMEMENUITEMINFOA,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwtype),
            ::std::mem::transmute(pimeparentmenu),
            ::std::mem::transmute(pimemenu),
            ::std::mem::transmute(dwsize),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetImeMenuItemsW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
        &self,
        himc: Param0,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOW,
        pimemenu: *mut IMEMENUITEMINFOW,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwtype),
            ::std::mem::transmute(pimeparentmenu),
            ::std::mem::transmute(pimemenu),
            ::std::mem::transmute(dwsize),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    pub unsafe fn EnumInputContext(
        &self,
        idthread: u32,
    ) -> ::windows::runtime::Result<IEnumInputContext> {
        let mut result__: <IEnumInputContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(idthread),
            &mut result__,
        )
        .from_abi::<IEnumInputContext>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestMessageA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        himc: Param0,
        wparam: Param1,
        lparam: Param2,
    ) -> ::windows::runtime::Result<super::Foundation::LRESULT> {
        let mut result__: <super::Foundation::LRESULT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::LRESULT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RequestMessageW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, HIMC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        himc: Param0,
        wparam: Param1,
        lparam: Param2,
    ) -> ::windows::runtime::Result<super::Foundation::LRESULT> {
        let mut result__: <super::Foundation::LRESULT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            himc.into_param().abi(),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::LRESULT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SendIMCA<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        umsg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<super::Foundation::LRESULT> {
        let mut result__: <super::Foundation::LRESULT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::LRESULT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SendIMCW<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        umsg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<super::Foundation::LRESULT> {
        let mut result__: <super::Foundation::LRESULT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::LRESULT>(result__)
    }
    pub unsafe fn IsSleeping(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).90)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActiveIMMIME {
    type Vtable = IActiveIMMIME_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        146813969,
        63851,
        4560,
        [164, 117, 0, 170, 0, 107, 204, 89],
    );
}
impl ::std::convert::From<IActiveIMMIME> for ::windows::runtime::IUnknown {
    fn from(value: IActiveIMMIME) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActiveIMMIME> for ::windows::runtime::IUnknown {
    fn from(value: &IActiveIMMIME) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActiveIMMIME {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IActiveIMMIME {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveIMMIME_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        hime: HIMC,
        phprev: *mut HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        hwnd: super::Foundation::HWND,
        dwmode: u32,
        pdata: *const REGISTERWORDA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        hwnd: super::Foundation::HWND,
        dwmode: u32,
        pdata: *const REGISTERWORDW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phimc: *mut HIMC,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hime: HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PSTR,
        dwstyle: u32,
        szregister: super::Foundation::PSTR,
        pdata: *const ::std::ffi::c_void,
        penum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szregister: super::Foundation::PWSTR,
        pdata: *const ::std::ffi::c_void,
        penum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        uescape: u32,
        pdata: *mut ::std::ffi::c_void,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        ubuflen: u32,
        pcandlist: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pdwlistsize: *mut u32,
        pdwbuflen: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcandidate: *mut CANDIDATEFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *mut super::Graphics::Gdi::LOGFONTA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *mut super::Graphics::Gdi::LOGFONTW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        plcopied: *mut i32,
        pbuf: *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pcompform: *mut COMPOSITIONFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        phimc: *mut HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        psrc: super::Foundation::PSTR,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        himc: HIMC,
        psrc: super::Foundation::PWSTR,
        ubuflen: u32,
        uflag: u32,
        pdst: *mut CANDIDATELIST,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pfdwconversion: *mut u32,
        pfdwsentence: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        phdefwnd: *mut super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szdescription: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szdescription: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        dwbuflen: u32,
        pbuf: super::Foundation::PWSTR,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szfilename: super::Foundation::PSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ubuflen: u32,
        szfilename: super::Foundation::PWSTR,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        fdwindex: u32,
        pdwproperty: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(all(
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_TextServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        nitem: u32,
        pstylebuf: *mut STYLEBUFA,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_TextServices"
    )))]
    usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        nitem: u32,
        pstylebuf: *mut STYLEBUFW,
        pucopied: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pptpos: *mut super::Foundation::POINT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        puvirtualkey: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szimefilename: super::Foundation::PSTR,
        szlayouttext: super::Foundation::PSTR,
        phkl: *mut super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szimefilename: super::Foundation::PWSTR,
        szlayouttext: super::Foundation::PWSTR,
        phkl: *mut super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndime: super::Foundation::HWND,
        msg: u32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndime: super::Foundation::HWND,
        msg: u32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwaction: u32,
        dwindex: u32,
        dwvalue: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PSTR,
        dwstyle: u32,
        szregister: super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szregister: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        himc: HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pcandidate: *const CANDIDATEFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *const super::Graphics::Gdi::LOGFONTA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        plf: *const super::Graphics::Gdi::LOGFONTW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwindex: u32,
        pcomp: *const ::std::ffi::c_void,
        dwcomplen: u32,
        pread: *const ::std::ffi::c_void,
        dwreadlen: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pcompform: *const COMPOSITIONFORM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fdwconversion: u32,
        fdwsentence: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        fopen: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pptpos: *const super::Foundation::POINT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        dwhotkeyid: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PSTR,
        dwstyle: u32,
        szunregister: super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        szreading: super::Foundation::PWSTR,
        dwstyle: u32,
        szunregister: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        ppimc: *mut *mut INPUTCONTEXT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        pdwlockcount: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsize: u32,
        phimcc: *mut HIMCC,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himcc: HIMCC,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himcc: HIMCC,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himcc: HIMCC,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himcc: HIMCC,
        dwsize: u32,
        phimcc: *mut HIMCC,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himcc: HIMCC,
        pdwsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himcc: HIMCC,
        pdwlockcount: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwhotkeyid: u32,
        pumodifiers: *mut u32,
        puvkey: *mut u32,
        phkl: *mut super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwhotkeyid: u32,
        umodifiers: u32,
        uvkey: u32,
        hkl: super::UI::TextServices::HKL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        utype: u32,
        howner: super::Foundation::HWND,
        x: i32,
        y: i32,
        phsoftkbdwnd: *mut super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hsoftkbdwnd: super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hsoftkbdwnd: super::Foundation::HWND,
        ncmdshow: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        ucodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    #[cfg(feature = "Win32_UI_TextServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hkl: super::UI::TextServices::HKL,
        plid: *mut u16,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_TextServices"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lgidime: u16,
        bvk: u8,
        bscan: u8,
        dwflags: u32,
        dwextrainfo: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        himc: HIMC,
        dwflags: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        idthread: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOA,
        pimemenu: *mut IMEMENUITEMINFOA,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        dwflags: u32,
        dwtype: u32,
        pimeparentmenu: *const IMEMENUITEMINFOW,
        pimemenu: *mut IMEMENUITEMINFOW,
        dwsize: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        idthread: u32,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        himc: HIMC,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        umsg: u32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
        umsg: u32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
        plresult: *mut super::Foundation::LRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActiveIMMMessagePumpOwner(::windows::runtime::IUnknown);
impl IActiveIMMMessagePumpOwner {
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn End(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnTranslateMessage(
        &self,
        pmsg: *const super::UI::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pmsg),
        )
        .ok()
    }
    pub unsafe fn Pause(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn Resume(&self, dwcookie: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwcookie),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActiveIMMMessagePumpOwner {
    type Vtable = IActiveIMMMessagePumpOwner_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3050253562,
        35563,
        4561,
        [147, 100, 0, 96, 176, 103, 184, 110],
    );
}
impl ::std::convert::From<IActiveIMMMessagePumpOwner> for ::windows::runtime::IUnknown {
    fn from(value: IActiveIMMMessagePumpOwner) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActiveIMMMessagePumpOwner> for ::windows::runtime::IUnknown {
    fn from(value: &IActiveIMMMessagePumpOwner) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IActiveIMMMessagePumpOwner
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IActiveIMMMessagePumpOwner
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveIMMMessagePumpOwner_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pmsg: *const super::UI::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwcookie: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwcookie: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActiveIMMRegistrar(::windows::runtime::IUnknown);
impl IActiveIMMRegistrar {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterIME<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        rclsid: *const ::windows::runtime::GUID,
        lgid: u16,
        psziconfile: Param2,
        pszdesc: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsid),
            ::std::mem::transmute(lgid),
            psziconfile.into_param().abi(),
            pszdesc.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UnregisterIME(
        &self,
        rclsid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsid),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActiveIMMRegistrar {
    type Vtable = IActiveIMMRegistrar_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3007676546,
        48384,
        4561,
        [147, 155, 0, 96, 176, 103, 184, 110],
    );
}
impl ::std::convert::From<IActiveIMMRegistrar> for ::windows::runtime::IUnknown {
    fn from(value: IActiveIMMRegistrar) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActiveIMMRegistrar> for ::windows::runtime::IUnknown {
    fn from(value: &IActiveIMMRegistrar) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActiveIMMRegistrar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IActiveIMMRegistrar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActiveIMMRegistrar_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsid: *const ::windows::runtime::GUID,
        lgid: u16,
        psziconfile: super::Foundation::PWSTR,
        pszdesc: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IComprehensiveSpellCheckProvider(::windows::runtime::IUnknown);
impl IComprehensiveSpellCheckProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComprehensiveCheck<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        text: Param0,
    ) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IEnumSpellingError>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IComprehensiveSpellCheckProvider {
    type Vtable = IComprehensiveSpellCheckProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        207157470,
        36500,
        18334,
        [151, 23, 112, 196, 44, 74, 210, 195],
    );
}
impl ::std::convert::From<IComprehensiveSpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: IComprehensiveSpellCheckProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IComprehensiveSpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IComprehensiveSpellCheckProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IComprehensiveSpellCheckProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IComprehensiveSpellCheckProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IComprehensiveSpellCheckProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
pub const IDN_ALLOW_UNASSIGNED: u32 = 1u32;
pub const IDN_EMAIL_ADDRESS: u32 = 4u32;
pub const IDN_RAW_PUNYCODE: u32 = 8u32;
pub const IDN_USE_STD3_ASCII_RULES: u32 = 2u32;
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IEnumCodePage(::windows::runtime::IUnknown);
impl IEnumCodePage {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IEnumCodePage>(result__)
    }
    pub unsafe fn Next(
        &self,
        celt: u32,
        rgelt: *mut MIMECPINFO,
        pceltfetched: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(celt),
            ::std::mem::transmute(rgelt),
            ::std::mem::transmute(pceltfetched),
        )
        .ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(celt),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumCodePage {
    type Vtable = IEnumCodePage_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        660349923,
        14151,
        4560,
        [159, 234, 0, 170, 0, 63, 134, 70],
    );
}
impl ::std::convert::From<IEnumCodePage> for ::windows::runtime::IUnknown {
    fn from(value: IEnumCodePage) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IEnumCodePage> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumCodePage) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumCodePage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IEnumCodePage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumCodePage_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        celt: u32,
        rgelt: *mut MIMECPINFO,
        pceltfetched: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        celt: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IEnumInputContext(::windows::runtime::IUnknown);
impl IEnumInputContext {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumInputContext> {
        let mut result__: <IEnumInputContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IEnumInputContext>(result__)
    }
    pub unsafe fn Next(
        &self,
        ulcount: u32,
        rginputcontext: *mut HIMC,
        pcfetched: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulcount),
            ::std::mem::transmute(rginputcontext),
            ::std::mem::transmute(pcfetched),
        )
        .ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Skip(&self, ulcount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulcount),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumInputContext {
    type Vtable = IEnumInputContext_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        162917040,
        63895,
        4561,
        [147, 212, 0, 96, 176, 103, 184, 110],
    );
}
impl ::std::convert::From<IEnumInputContext> for ::windows::runtime::IUnknown {
    fn from(value: IEnumInputContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IEnumInputContext> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumInputContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumInputContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IEnumInputContext {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumInputContext_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulcount: u32,
        rginputcontext: *mut HIMC,
        pcfetched: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulcount: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IEnumRegisterWordA(::windows::runtime::IUnknown);
impl IEnumRegisterWordA {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumRegisterWordA> {
        let mut result__: <IEnumRegisterWordA as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordA>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Next(
        &self,
        ulcount: u32,
        rgregisterword: *mut REGISTERWORDA,
        pcfetched: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulcount),
            ::std::mem::transmute(rgregisterword),
            ::std::mem::transmute(pcfetched),
        )
        .ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Skip(&self, ulcount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulcount),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumRegisterWordA {
    type Vtable = IEnumRegisterWordA_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        146813970,
        63851,
        4560,
        [164, 117, 0, 170, 0, 107, 204, 89],
    );
}
impl ::std::convert::From<IEnumRegisterWordA> for ::windows::runtime::IUnknown {
    fn from(value: IEnumRegisterWordA) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IEnumRegisterWordA> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumRegisterWordA) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumRegisterWordA {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IEnumRegisterWordA {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumRegisterWordA_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulcount: u32,
        rgregisterword: *mut REGISTERWORDA,
        pcfetched: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulcount: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IEnumRegisterWordW(::windows::runtime::IUnknown);
impl IEnumRegisterWordW {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumRegisterWordW> {
        let mut result__: <IEnumRegisterWordW as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IEnumRegisterWordW>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Next(
        &self,
        ulcount: u32,
        rgregisterword: *mut REGISTERWORDW,
        pcfetched: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulcount),
            ::std::mem::transmute(rgregisterword),
            ::std::mem::transmute(pcfetched),
        )
        .ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Skip(&self, ulcount: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulcount),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumRegisterWordW {
    type Vtable = IEnumRegisterWordW_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1230363953,
        45401,
        4560,
        [143, 207, 0, 170, 0, 107, 204, 89],
    );
}
impl ::std::convert::From<IEnumRegisterWordW> for ::windows::runtime::IUnknown {
    fn from(value: IEnumRegisterWordW) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IEnumRegisterWordW> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumRegisterWordW) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumRegisterWordW {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IEnumRegisterWordW {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumRegisterWordW_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulcount: u32,
        rgregisterword: *mut REGISTERWORDW,
        pcfetched: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulcount: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IEnumRfc1766(::windows::runtime::IUnknown);
impl IEnumRfc1766 {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IEnumRfc1766>(result__)
    }
    pub unsafe fn Next(
        &self,
        celt: u32,
        rgelt: *mut RFC1766INFO,
        pceltfetched: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(celt),
            ::std::mem::transmute(rgelt),
            ::std::mem::transmute(pceltfetched),
        )
        .ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(celt),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumRfc1766 {
    type Vtable = IEnumRfc1766_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1036229917,
        49200,
        4560,
        [184, 27, 0, 192, 79, 201, 179, 31],
    );
}
impl ::std::convert::From<IEnumRfc1766> for ::windows::runtime::IUnknown {
    fn from(value: IEnumRfc1766) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IEnumRfc1766> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumRfc1766) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumRfc1766 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IEnumRfc1766 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumRfc1766_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        celt: u32,
        rgelt: *mut RFC1766INFO,
        pceltfetched: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        celt: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IEnumScript(::windows::runtime::IUnknown);
impl IEnumScript {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IEnumScript> {
        let mut result__: <IEnumScript as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IEnumScript>(result__)
    }
    pub unsafe fn Next(
        &self,
        celt: u32,
        rgelt: *mut SCRIPTINFO,
        pceltfetched: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(celt),
            ::std::mem::transmute(rgelt),
            ::std::mem::transmute(pceltfetched),
        )
        .ok()
    }
    pub unsafe fn Reset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Skip(&self, celt: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(celt),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IEnumScript {
    type Vtable = IEnumScript_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2925466672,
        14475,
        4562,
        [131, 128, 0, 192, 79, 143, 93, 161],
    );
}
impl ::std::convert::From<IEnumScript> for ::windows::runtime::IUnknown {
    fn from(value: IEnumScript) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IEnumScript> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumScript) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumScript {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IEnumScript {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumScript_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        celt: u32,
        rgelt: *mut SCRIPTINFO,
        pceltfetched: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        celt: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IEnumSpellingError(::windows::runtime::IUnknown);
impl IEnumSpellingError {
    pub unsafe fn Next(&self) -> ::windows::runtime::Result<ISpellingError> {
        let mut result__: <ISpellingError as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ISpellingError>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IEnumSpellingError {
    type Vtable = IEnumSpellingError_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2151562196,
        10280,
        17424,
        [130, 144, 65, 141, 29, 115, 199, 98],
    );
}
impl ::std::convert::From<IEnumSpellingError> for ::windows::runtime::IUnknown {
    fn from(value: IEnumSpellingError) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IEnumSpellingError> for ::windows::runtime::IUnknown {
    fn from(value: &IEnumSpellingError) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IEnumSpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IEnumSpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IEnumSpellingError_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
pub const IFEC_S_ALREADY_DEFAULT: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(291840i32 as _);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IFEClassFactory(::windows::runtime::IUnknown);
impl IFEClassFactory {
    pub unsafe fn CreateInstance<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        punkouter: Param0,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            punkouter.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LockServer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
    >(
        &self,
        flock: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            flock.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IFEClassFactory {
    type Vtable = IFEClassFactory_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IFEClassFactory> for ::windows::runtime::IUnknown {
    fn from(value: IFEClassFactory) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IFEClassFactory> for ::windows::runtime::IUnknown {
    fn from(value: &IFEClassFactory) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IFEClassFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IFEClassFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::convert::From<IFEClassFactory> for super::System::Com::IClassFactory {
    fn from(value: IFEClassFactory) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::convert::From<&IFEClassFactory> for super::System::Com::IClassFactory {
    fn from(value: &IFEClassFactory) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::runtime::IntoParam<'a, super::System::Com::IClassFactory> for IFEClassFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::System::Com::IClassFactory> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<super::System::Com::IClassFactory>::into(self),
        )
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::runtime::IntoParam<'a, super::System::Com::IClassFactory> for &IFEClassFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, super::System::Com::IClassFactory> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<super::System::Com::IClassFactory>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IFEClassFactory_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punkouter: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        ppvobject: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flock: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IFECommon(::windows::runtime::IUnknown);
impl IFECommon {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsDefaultIME<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        szname: Param0,
        cszname: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            szname.into_param().abi(),
            ::std::mem::transmute(cszname),
        )
        .ok()
    }
    pub unsafe fn SetDefaultIME(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeWordRegDialog(
        &self,
        pimedlg: *mut IMEDLG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pimedlg),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn InvokeDictToolDialog(
        &self,
        pimedlg: *mut IMEDLG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pimedlg),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IFECommon {
    type Vtable = IFECommon_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        27226449,
        59099,
        4560,
        [131, 195, 0, 192, 79, 221, 184, 46],
    );
}
impl ::std::convert::From<IFECommon> for ::windows::runtime::IUnknown {
    fn from(value: IFECommon) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IFECommon> for ::windows::runtime::IUnknown {
    fn from(value: &IFECommon) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IFECommon {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IFECommon {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IFECommon_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szname: super::Foundation::PSTR,
        cszname: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pimedlg: *mut IMEDLG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pimedlg: *mut IMEDLG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
pub const IFED_E_INVALID_FORMAT: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192063i32 as _);
pub const IFED_E_NOT_FOUND: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192064i32 as _);
pub const IFED_E_NOT_SUPPORTED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192057i32 as _);
pub const IFED_E_NOT_USER_DIC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192058i32 as _);
pub const IFED_E_NO_ENTRY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192060i32 as _);
pub const IFED_E_OPEN_FAILED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192062i32 as _);
pub const IFED_E_REGISTER_DISCONNECTED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192053i32 as _);
pub const IFED_E_REGISTER_FAILED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192059i32 as _);
pub const IFED_E_REGISTER_ILLEGAL_POS: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192055i32 as _);
pub const IFED_E_REGISTER_IMPROPER_WORD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192054i32 as _);
pub const IFED_E_USER_COMMENT: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192056i32 as _);
pub const IFED_E_WRITE_FAILED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147192061i32 as _);
pub const IFED_POS_ADJECTIVE: u32 = 4u32;
pub const IFED_POS_ADJECTIVE_VERB: u32 = 8u32;
pub const IFED_POS_ADNOUN: u32 = 32u32;
pub const IFED_POS_ADVERB: u32 = 16u32;
pub const IFED_POS_AFFIX: u32 = 1536u32;
pub const IFED_POS_ALL: u32 = 131071u32;
pub const IFED_POS_AUXILIARY_VERB: u32 = 32768u32;
pub const IFED_POS_CONJUNCTION: u32 = 64u32;
pub const IFED_POS_DEPENDENT: u32 = 114688u32;
pub const IFED_POS_IDIOMS: u32 = 4096u32;
pub const IFED_POS_INDEPENDENT: u32 = 255u32;
pub const IFED_POS_INFLECTIONALSUFFIX: u32 = 256u32;
pub const IFED_POS_INTERJECTION: u32 = 128u32;
pub const IFED_POS_NONE: u32 = 0u32;
pub const IFED_POS_NOUN: u32 = 1u32;
pub const IFED_POS_PARTICLE: u32 = 16384u32;
pub const IFED_POS_PREFIX: u32 = 512u32;
pub const IFED_POS_SUB_VERB: u32 = 65536u32;
pub const IFED_POS_SUFFIX: u32 = 1024u32;
pub const IFED_POS_SYMBOLS: u32 = 8192u32;
pub const IFED_POS_TANKANJI: u32 = 2048u32;
pub const IFED_POS_VERB: u32 = 2u32;
pub const IFED_REG_ALL: u32 = 7u32;
pub const IFED_REG_AUTO: u32 = 2u32;
pub const IFED_REG_GRAMMAR: u32 = 4u32;
pub const IFED_REG_NONE: u32 = 0u32;
pub const IFED_REG_USER: u32 = 1u32;
pub const IFED_SELECT_ALL: u32 = 15u32;
pub const IFED_SELECT_COMMENT: u32 = 8u32;
pub const IFED_SELECT_DISPLAY: u32 = 2u32;
pub const IFED_SELECT_NONE: u32 = 0u32;
pub const IFED_SELECT_POS: u32 = 4u32;
pub const IFED_SELECT_READING: u32 = 1u32;
pub const IFED_S_COMMENT_CHANGED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(291331i32 as _);
pub const IFED_S_EMPTY_DICTIONARY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(291329i32 as _);
pub const IFED_S_MORE_ENTRIES: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(291328i32 as _);
pub const IFED_S_WORD_EXISTS: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(291330i32 as _);
pub const IFED_TYPE_ALL: u32 = 31u32;
pub const IFED_TYPE_ENGLISH: u32 = 16u32;
pub const IFED_TYPE_GENERAL: u32 = 1u32;
pub const IFED_TYPE_NAMEPLACE: u32 = 2u32;
pub const IFED_TYPE_NONE: u32 = 0u32;
pub const IFED_TYPE_REVERSE: u32 = 8u32;
pub const IFED_TYPE_SPEECH: u32 = 4u32;
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IFEDictionary(::windows::runtime::IUnknown);
impl IFEDictionary {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
    pub unsafe fn Open<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(
        &self,
        pchdictpath: Param0,
        pshf: *mut IMESHF,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pchdictpath.into_param().abi(),
            ::std::mem::transmute(pshf),
        )
        .ok()
    }
    pub unsafe fn Close(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
    pub unsafe fn GetHeader<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        pchdictpath: Param0,
        pshf: *mut IMESHF,
        pjfmt: *mut IMEFMT,
        pultype: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            pchdictpath.into_param().abi(),
            ::std::mem::transmute(pshf),
            ::std::mem::transmute(pjfmt),
            ::std::mem::transmute(pultype),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayProperty<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetPosTable(
        &self,
        prgpostbl: *mut *mut POSTBL,
        pcpostbl: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prgpostbl),
            ::std::mem::transmute(pcpostbl),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetWords<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pwchfirst: Param0,
        pwchlast: Param1,
        pwchdisplay: Param2,
        ulpos: u32,
        ulselect: u32,
        ulwordsrc: u32,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcwrd: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pwchfirst.into_param().abi(),
            pwchlast.into_param().abi(),
            pwchdisplay.into_param().abi(),
            ::std::mem::transmute(ulpos),
            ::std::mem::transmute(ulselect),
            ::std::mem::transmute(ulwordsrc),
            ::std::mem::transmute(pchbuffer),
            ::std::mem::transmute(cbbuffer),
            ::std::mem::transmute(pcwrd),
        )
        .ok()
    }
    pub unsafe fn NextWords(
        &self,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcwrd: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pchbuffer),
            ::std::mem::transmute(cbbuffer),
            ::std::mem::transmute(pcwrd),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
    pub unsafe fn Create<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>>(
        &self,
        pchdictpath: Param0,
        pshf: *mut IMESHF,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            pchdictpath.into_param().abi(),
            ::std::mem::transmute(pshf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_SystemServices")]
    pub unsafe fn SetHeader(&self, pshf: *mut IMESHF) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pshf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ExistWord(&self, pwrd: *mut IMEWRD) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pwrd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ExistDependency(&self, pdp: *mut IMEDP) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdp),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWord(
        &self,
        reg: IMEREG,
        pwrd: *mut IMEWRD,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(reg),
            ::std::mem::transmute(pwrd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterDependency(
        &self,
        reg: IMEREG,
        pdp: *mut IMEDP,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(reg),
            ::std::mem::transmute(pdp),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDependencies<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pwchkakarireading: Param0,
        pwchkakaridisplay: Param1,
        ulkakaripos: u32,
        pwchukereading: Param3,
        pwchukedisplay: Param4,
        ulukepos: u32,
        jrel: IMEREL,
        ulwordsrc: u32,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcdp: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            pwchkakarireading.into_param().abi(),
            pwchkakaridisplay.into_param().abi(),
            ::std::mem::transmute(ulkakaripos),
            pwchukereading.into_param().abi(),
            pwchukedisplay.into_param().abi(),
            ::std::mem::transmute(ulukepos),
            ::std::mem::transmute(jrel),
            ::std::mem::transmute(ulwordsrc),
            ::std::mem::transmute(pchbuffer),
            ::std::mem::transmute(cbbuffer),
            ::std::mem::transmute(pcdp),
        )
        .ok()
    }
    pub unsafe fn NextDependencies(
        &self,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcdp: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pchbuffer),
            ::std::mem::transmute(cbbuffer),
            ::std::mem::transmute(pcdp),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertFromOldMSIME<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        pchdic: Param0,
        pfnlog: ::std::option::Option<PFNLOG>,
        reg: IMEREG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            pchdic.into_param().abi(),
            ::std::mem::transmute(pfnlog),
            ::std::mem::transmute(reg),
        )
        .ok()
    }
    pub unsafe fn ConvertFromUserToSys(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IFEDictionary {
    type Vtable = IFEDictionary_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        27226451,
        59099,
        4560,
        [131, 195, 0, 192, 79, 221, 184, 46],
    );
}
impl ::std::convert::From<IFEDictionary> for ::windows::runtime::IUnknown {
    fn from(value: IFEDictionary) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IFEDictionary> for ::windows::runtime::IUnknown {
    fn from(value: &IFEDictionary) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IFEDictionary {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IFEDictionary {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IFEDictionary_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchdictpath: super::Foundation::PSTR,
        pshf: *mut IMESHF,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchdictpath: super::Foundation::PSTR,
        pshf: *mut IMESHF,
        pjfmt: *mut IMEFMT,
        pultype: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prgpostbl: *mut *mut POSTBL,
        pcpostbl: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pwchfirst: super::Foundation::PWSTR,
        pwchlast: super::Foundation::PWSTR,
        pwchdisplay: super::Foundation::PWSTR,
        ulpos: u32,
        ulselect: u32,
        ulwordsrc: u32,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcwrd: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcwrd: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchdictpath: super::Foundation::PSTR,
        pshf: *mut IMESHF,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices")))] usize,
    #[cfg(feature = "Win32_System_SystemServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pshf: *mut IMESHF,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_SystemServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pwrd: *mut IMEWRD,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdp: *mut IMEDP,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        reg: IMEREG,
        pwrd: *mut IMEWRD,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        reg: IMEREG,
        pdp: *mut IMEDP,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pwchkakarireading: super::Foundation::PWSTR,
        pwchkakaridisplay: super::Foundation::PWSTR,
        ulkakaripos: u32,
        pwchukereading: super::Foundation::PWSTR,
        pwchukedisplay: super::Foundation::PWSTR,
        ulukepos: u32,
        jrel: IMEREL,
        ulwordsrc: u32,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcdp: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchbuffer: *mut u8,
        cbbuffer: u32,
        pcdp: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchdic: super::Foundation::PSTR,
        pfnlog: ::windows::runtime::RawPtr,
        reg: IMEREG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IFELanguage(::windows::runtime::IUnknown);
impl IFELanguage {
    pub unsafe fn Open(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Close(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetJMorphResult<
        'a,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        dwrequest: u32,
        dwcmode: u32,
        cwchinput: i32,
        pwchinput: Param3,
        pfcinfo: *mut u32,
        ppresult: *mut *mut MORRSLT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwrequest),
            ::std::mem::transmute(dwcmode),
            ::std::mem::transmute(cwchinput),
            pwchinput.into_param().abi(),
            ::std::mem::transmute(pfcinfo),
            ::std::mem::transmute(ppresult),
        )
        .ok()
    }
    pub unsafe fn GetConversionModeCaps(
        &self,
        pdwcaps: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwcaps),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPhonetic<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        string: Param0,
        start: i32,
        length: i32,
        phonetic: *mut super::Foundation::BSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            string.into_param().abi(),
            ::std::mem::transmute(start),
            ::std::mem::transmute(length),
            ::std::mem::transmute(phonetic),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetConversion<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        string: Param0,
        start: i32,
        length: i32,
        result: *mut super::Foundation::BSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            string.into_param().abi(),
            ::std::mem::transmute(start),
            ::std::mem::transmute(length),
            ::std::mem::transmute(result),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IFELanguage {
    type Vtable = IFELanguage_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        27226450,
        59099,
        4560,
        [131, 195, 0, 192, 79, 221, 184, 46],
    );
}
impl ::std::convert::From<IFELanguage> for ::windows::runtime::IUnknown {
    fn from(value: IFELanguage) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IFELanguage> for ::windows::runtime::IUnknown {
    fn from(value: &IFELanguage) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IFELanguage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IFELanguage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IFELanguage_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwrequest: u32,
        dwcmode: u32,
        cwchinput: i32,
        pwchinput: super::Foundation::PWSTR,
        pfcinfo: *mut u32,
        ppresult: *mut *mut MORRSLT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwcaps: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        string: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
        start: i32,
        length: i32,
        phonetic: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        string: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
        start: i32,
        length: i32,
        result: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
pub const IGIMIF_RIGHTMENU: u32 = 1u32;
pub const IGIMII_CMODE: u32 = 1u32;
pub const IGIMII_CONFIGURE: u32 = 4u32;
pub const IGIMII_HELP: u32 = 16u32;
pub const IGIMII_INPUTTOOLS: u32 = 64u32;
pub const IGIMII_OTHER: u32 = 32u32;
pub const IGIMII_SMODE: u32 = 2u32;
pub const IGIMII_TOOLS: u32 = 8u32;
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IImePad(::windows::runtime::IUnknown);
impl IImePad {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Request<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IImePadApplet>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        piimepadapplet: Param0,
        reqid: IME_PAD_REQUEST_FLAGS,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            piimepadapplet.into_param().abi(),
            ::std::mem::transmute(reqid),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IImePad {
    type Vtable = IImePad_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1569612858,
        50089,
        4561,
        [175, 239, 0, 128, 95, 12, 139, 109],
    );
}
impl ::std::convert::From<IImePad> for ::windows::runtime::IUnknown {
    fn from(value: IImePad) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IImePad> for ::windows::runtime::IUnknown {
    fn from(value: &IImePad) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IImePad {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IImePad {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IImePad_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        piimepadapplet: ::windows::runtime::RawPtr,
        reqid: IME_PAD_REQUEST_FLAGS,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IImePadApplet(::windows::runtime::IUnknown);
impl IImePadApplet {
    pub unsafe fn Initialize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        lpiimepad: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            lpiimepad.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Terminate(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn GetAppletConfig(
        &self,
        lpappletcfg: *mut IMEAPPLETCFG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lpappletcfg),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateUI<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        hwndparent: Param0,
        lpimeappletui: *mut IMEAPPLETUI,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwndparent.into_param().abi(),
            ::std::mem::transmute(lpimeappletui),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Notify<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
    >(
        &self,
        lpimepad: Param0,
        notify: i32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            lpimepad.into_param().abi(),
            ::std::mem::transmute(notify),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IImePadApplet {
    type Vtable = IImePadApplet_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1569612859,
        50089,
        4561,
        [175, 239, 0, 128, 95, 12, 139, 109],
    );
}
impl ::std::convert::From<IImePadApplet> for ::windows::runtime::IUnknown {
    fn from(value: IImePadApplet) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IImePadApplet> for ::windows::runtime::IUnknown {
    fn from(value: &IImePadApplet) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IImePadApplet {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IImePadApplet {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IImePadApplet_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpiimepad: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpappletcfg: *mut IMEAPPLETCFG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndparent: super::Foundation::HWND,
        lpimeappletui: *mut IMEAPPLETUI,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpimepad: ::windows::runtime::RawPtr,
        notify: i32,
        wparam: super::Foundation::WPARAM,
        lparam: super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IImePlugInDictDictionaryList(::windows::runtime::IUnknown);
impl IImePlugInDictDictionaryList {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetDictionariesInUse(
        &self,
        prgdictionaryguid: *mut *mut super::System::OleAutomation::SAFEARRAY,
        prgdatecreated: *mut *mut super::System::OleAutomation::SAFEARRAY,
        prgfencrypted: *mut *mut super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prgdictionaryguid),
            ::std::mem::transmute(prgdatecreated),
            ::std::mem::transmute(prgfencrypted),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DeleteDictionary<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        bstrdictionaryguid: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            bstrdictionaryguid.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IImePlugInDictDictionaryList {
    type Vtable = IImePlugInDictDictionaryList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2557815156,
        45222,
        18587,
        [143, 111, 191, 243, 118, 156, 142, 235],
    );
}
impl ::std::convert::From<IImePlugInDictDictionaryList> for ::windows::runtime::IUnknown {
    fn from(value: IImePlugInDictDictionaryList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IImePlugInDictDictionaryList> for ::windows::runtime::IUnknown {
    fn from(value: &IImePlugInDictDictionaryList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IImePlugInDictDictionaryList
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IImePlugInDictDictionaryList
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IImePlugInDictDictionaryList_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prgdictionaryguid: *mut *mut super::System::OleAutomation::SAFEARRAY,
        prgdatecreated: *mut *mut super::System::OleAutomation::SAFEARRAY,
        prgfencrypted: *mut *mut super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrdictionaryguid: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IImeSpecifyApplets(::windows::runtime::IUnknown);
impl IImeSpecifyApplets {
    pub unsafe fn GetAppletIIDList(
        &self,
        refiid: *const ::windows::runtime::GUID,
        lpiidlist: *mut APPLETIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(refiid),
            ::std::mem::transmute(lpiidlist),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IImeSpecifyApplets {
    type Vtable = IImeSpecifyApplets_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1569612860,
        50089,
        4561,
        [175, 239, 0, 128, 95, 12, 139, 109],
    );
}
impl ::std::convert::From<IImeSpecifyApplets> for ::windows::runtime::IUnknown {
    fn from(value: IImeSpecifyApplets) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IImeSpecifyApplets> for ::windows::runtime::IUnknown {
    fn from(value: &IImeSpecifyApplets) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IImeSpecifyApplets {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IImeSpecifyApplets {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IImeSpecifyApplets_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        refiid: *const ::windows::runtime::GUID,
        lpiidlist: *mut APPLETIDLIST,
    ) -> ::windows::runtime::HRESULT,
);
#[cfg(feature = "Win32_Foundation")]
pub type IMCENUMPROC = unsafe extern "system" fn(
    param0: HIMC,
    param1: super::Foundation::LPARAM,
) -> super::Foundation::BOOL;
pub const IMC_CLOSESTATUSWINDOW: u32 = 33u32;
pub const IMC_GETCANDIDATEPOS: u32 = 7u32;
pub const IMC_GETCOMPOSITIONFONT: u32 = 9u32;
pub const IMC_GETCOMPOSITIONWINDOW: u32 = 11u32;
pub const IMC_GETSOFTKBDFONT: u32 = 17u32;
pub const IMC_GETSOFTKBDPOS: u32 = 19u32;
pub const IMC_GETSOFTKBDSUBTYPE: u32 = 21u32;
pub const IMC_GETSTATUSWINDOWPOS: u32 = 15u32;
pub const IMC_OPENSTATUSWINDOW: u32 = 34u32;
pub const IMC_SETCANDIDATEPOS: u32 = 8u32;
pub const IMC_SETCOMPOSITIONFONT: u32 = 10u32;
pub const IMC_SETCOMPOSITIONWINDOW: u32 = 12u32;
pub const IMC_SETCONVERSIONMODE: u32 = 2u32;
pub const IMC_SETOPENSTATUS: u32 = 6u32;
pub const IMC_SETSENTENCEMODE: u32 = 4u32;
pub const IMC_SETSOFTKBDDATA: u32 = 24u32;
pub const IMC_SETSOFTKBDFONT: u32 = 18u32;
pub const IMC_SETSOFTKBDPOS: u32 = 20u32;
pub const IMC_SETSOFTKBDSUBTYPE: u32 = 22u32;
pub const IMC_SETSTATUSWINDOWPOS: u32 = 16u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub struct IMEAPPLETCFG {
    pub dwConfig: u32,
    pub wchTitle: [u16; 64],
    pub wchTitleFontFace: [u16; 32],
    pub dwCharSet: u32,
    pub iCategory: i32,
    pub hIcon: super::UI::WindowsAndMessaging::HICON,
    pub langID: u16,
    pub dummy: u16,
    pub lReserved1: super::Foundation::LPARAM,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl IMEAPPLETCFG {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for IMEAPPLETCFG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::fmt::Debug for IMEAPPLETCFG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMEAPPLETCFG")
            .field("dwConfig", &self.dwConfig)
            .field("wchTitle", &self.wchTitle)
            .field("wchTitleFontFace", &self.wchTitleFontFace)
            .field("dwCharSet", &self.dwCharSet)
            .field("iCategory", &self.iCategory)
            .field("hIcon", &self.hIcon)
            .field("langID", &self.langID)
            .field("dummy", &self.dummy)
            .field("lReserved1", &self.lReserved1)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for IMEAPPLETCFG {
    fn eq(&self, other: &Self) -> bool {
        self.dwConfig == other.dwConfig
            && self.wchTitle == other.wchTitle
            && self.wchTitleFontFace == other.wchTitleFontFace
            && self.dwCharSet == other.dwCharSet
            && self.iCategory == other.iCategory
            && self.hIcon == other.hIcon
            && self.langID == other.langID
            && self.dummy == other.dummy
            && self.lReserved1 == other.lReserved1
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for IMEAPPLETCFG {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for IMEAPPLETCFG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct IMEAPPLETUI {
    pub hwnd: super::Foundation::HWND,
    pub dwStyle: u32,
    pub width: i32,
    pub height: i32,
    pub minWidth: i32,
    pub minHeight: i32,
    pub maxWidth: i32,
    pub maxHeight: i32,
    pub lReserved1: super::Foundation::LPARAM,
    pub lReserved2: super::Foundation::LPARAM,
}
#[cfg(feature = "Win32_Foundation")]
impl IMEAPPLETUI {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMEAPPLETUI {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for IMEAPPLETUI {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMEAPPLETUI")
            .field("hwnd", &self.hwnd)
            .field("dwStyle", &self.dwStyle)
            .field("width", &self.width)
            .field("height", &self.height)
            .field("minWidth", &self.minWidth)
            .field("minHeight", &self.minHeight)
            .field("maxWidth", &self.maxWidth)
            .field("maxHeight", &self.maxHeight)
            .field("lReserved1", &self.lReserved1)
            .field("lReserved2", &self.lReserved2)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMEAPPLETUI {
    fn eq(&self, other: &Self) -> bool {
        self.hwnd == other.hwnd
            && self.dwStyle == other.dwStyle
            && self.width == other.width
            && self.height == other.height
            && self.minWidth == other.minWidth
            && self.minHeight == other.minHeight
            && self.maxWidth == other.maxWidth
            && self.maxHeight == other.maxHeight
            && self.lReserved1 == other.lReserved1
            && self.lReserved2 == other.lReserved2
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMEAPPLETUI {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMEAPPLETUI {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IMECHARINFO {
    pub wch: u16,
    pub dwCharInfo: u32,
}
impl IMECHARINFO {}
impl ::std::default::Default for IMECHARINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMECHARINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMECHARINFO")
            .field("wch", &self.wch)
            .field("dwCharInfo", &self.dwCharInfo)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMECHARINFO {
    fn eq(&self, other: &Self) -> bool {
        self.wch == other.wch && self.dwCharInfo == other.dwCharInfo
    }
}
impl ::std::cmp::Eq for IMECHARINFO {}
unsafe impl ::windows::runtime::Abi for IMECHARINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct IMECHARPOSITION {
    pub dwSize: u32,
    pub dwCharPos: u32,
    pub pt: super::Foundation::POINT,
    pub cLineHeight: u32,
    pub rcDocument: super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl IMECHARPOSITION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMECHARPOSITION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for IMECHARPOSITION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMECHARPOSITION")
            .field("dwSize", &self.dwSize)
            .field("dwCharPos", &self.dwCharPos)
            .field("pt", &self.pt)
            .field("cLineHeight", &self.cLineHeight)
            .field("rcDocument", &self.rcDocument)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMECHARPOSITION {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwCharPos == other.dwCharPos
            && self.pt == other.pt
            && self.cLineHeight == other.cLineHeight
            && self.rcDocument == other.rcDocument
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMECHARPOSITION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMECHARPOSITION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IMECOMPOSITIONSTRINGINFO {
    pub iCompStrLen: i32,
    pub iCaretPos: i32,
    pub iEditStart: i32,
    pub iEditLen: i32,
    pub iTargetStart: i32,
    pub iTargetLen: i32,
}
impl IMECOMPOSITIONSTRINGINFO {}
impl ::std::default::Default for IMECOMPOSITIONSTRINGINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMECOMPOSITIONSTRINGINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMECOMPOSITIONSTRINGINFO")
            .field("iCompStrLen", &self.iCompStrLen)
            .field("iCaretPos", &self.iCaretPos)
            .field("iEditStart", &self.iEditStart)
            .field("iEditLen", &self.iEditLen)
            .field("iTargetStart", &self.iTargetStart)
            .field("iTargetLen", &self.iTargetLen)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMECOMPOSITIONSTRINGINFO {
    fn eq(&self, other: &Self) -> bool {
        self.iCompStrLen == other.iCompStrLen
            && self.iCaretPos == other.iCaretPos
            && self.iEditStart == other.iEditStart
            && self.iEditLen == other.iEditLen
            && self.iTargetStart == other.iTargetStart
            && self.iTargetLen == other.iTargetLen
    }
}
impl ::std::cmp::Eq for IMECOMPOSITIONSTRINGINFO {}
unsafe impl ::windows::runtime::Abi for IMECOMPOSITIONSTRINGINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct IMEDLG {
    pub cbIMEDLG: i32,
    pub hwnd: super::Foundation::HWND,
    pub lpwstrWord: super::Foundation::PWSTR,
    pub nTabId: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl IMEDLG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMEDLG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMEDLG {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMEDLG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMEDLG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct IMEDP {
    pub wrdModifier: IMEWRD,
    pub wrdModifiee: IMEWRD,
    pub relID: IMEREL,
}
#[cfg(feature = "Win32_Foundation")]
impl IMEDP {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMEDP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMEDP {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMEDP {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMEDP {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IMEFAREASTINFO_TYPE_COMMENT: u32 = 2u32;
pub const IMEFAREASTINFO_TYPE_COSTTIME: u32 = 3u32;
pub const IMEFAREASTINFO_TYPE_DEFAULT: u32 = 0u32;
pub const IMEFAREASTINFO_TYPE_READING: u32 = 1u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct IMEFMT(pub i32);
pub const IFED_UNKNOWN: IMEFMT = IMEFMT(0i32);
pub const IFED_MSIME2_BIN_SYSTEM: IMEFMT = IMEFMT(1i32);
pub const IFED_MSIME2_BIN_USER: IMEFMT = IMEFMT(2i32);
pub const IFED_MSIME2_TEXT_USER: IMEFMT = IMEFMT(3i32);
pub const IFED_MSIME95_BIN_SYSTEM: IMEFMT = IMEFMT(4i32);
pub const IFED_MSIME95_BIN_USER: IMEFMT = IMEFMT(5i32);
pub const IFED_MSIME95_TEXT_USER: IMEFMT = IMEFMT(6i32);
pub const IFED_MSIME97_BIN_SYSTEM: IMEFMT = IMEFMT(7i32);
pub const IFED_MSIME97_BIN_USER: IMEFMT = IMEFMT(8i32);
pub const IFED_MSIME97_TEXT_USER: IMEFMT = IMEFMT(9i32);
pub const IFED_MSIME98_BIN_SYSTEM: IMEFMT = IMEFMT(10i32);
pub const IFED_MSIME98_BIN_USER: IMEFMT = IMEFMT(11i32);
pub const IFED_MSIME98_TEXT_USER: IMEFMT = IMEFMT(12i32);
pub const IFED_ACTIVE_DICT: IMEFMT = IMEFMT(13i32);
pub const IFED_ATOK9: IMEFMT = IMEFMT(14i32);
pub const IFED_ATOK10: IMEFMT = IMEFMT(15i32);
pub const IFED_NEC_AI_: IMEFMT = IMEFMT(16i32);
pub const IFED_WX_II: IMEFMT = IMEFMT(17i32);
pub const IFED_WX_III: IMEFMT = IMEFMT(18i32);
pub const IFED_VJE_20: IMEFMT = IMEFMT(19i32);
pub const IFED_MSIME98_SYSTEM_CE: IMEFMT = IMEFMT(20i32);
pub const IFED_MSIME_BIN_SYSTEM: IMEFMT = IMEFMT(21i32);
pub const IFED_MSIME_BIN_USER: IMEFMT = IMEFMT(22i32);
pub const IFED_MSIME_TEXT_USER: IMEFMT = IMEFMT(23i32);
pub const IFED_PIME2_BIN_USER: IMEFMT = IMEFMT(24i32);
pub const IFED_PIME2_BIN_SYSTEM: IMEFMT = IMEFMT(25i32);
pub const IFED_PIME2_BIN_STANDARD_SYSTEM: IMEFMT = IMEFMT(26i32);
impl ::std::convert::From<i32> for IMEFMT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMEFMT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IMEINFO {
    pub dwPrivateDataSize: u32,
    pub fdwProperty: u32,
    pub fdwConversionCaps: u32,
    pub fdwSentenceCaps: u32,
    pub fdwUICaps: u32,
    pub fdwSCSCaps: u32,
    pub fdwSelectCaps: u32,
}
impl IMEINFO {}
impl ::std::default::Default for IMEINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMEINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMEINFO")
            .field("dwPrivateDataSize", &self.dwPrivateDataSize)
            .field("fdwProperty", &self.fdwProperty)
            .field("fdwConversionCaps", &self.fdwConversionCaps)
            .field("fdwSentenceCaps", &self.fdwSentenceCaps)
            .field("fdwUICaps", &self.fdwUICaps)
            .field("fdwSCSCaps", &self.fdwSCSCaps)
            .field("fdwSelectCaps", &self.fdwSelectCaps)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMEINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwPrivateDataSize == other.dwPrivateDataSize
            && self.fdwProperty == other.fdwProperty
            && self.fdwConversionCaps == other.fdwConversionCaps
            && self.fdwSentenceCaps == other.fdwSentenceCaps
            && self.fdwUICaps == other.fdwUICaps
            && self.fdwSCSCaps == other.fdwSCSCaps
            && self.fdwSelectCaps == other.fdwSelectCaps
    }
}
impl ::std::cmp::Eq for IMEINFO {}
unsafe impl ::windows::runtime::Abi for IMEINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IMEITEM {
    pub cbSize: i32,
    pub iType: i32,
    pub lpItemData: *mut ::std::ffi::c_void,
}
impl IMEITEM {}
impl ::std::default::Default for IMEITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMEITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMEITEM")
            .field("cbSize", &self.cbSize)
            .field("iType", &self.iType)
            .field("lpItemData", &self.lpItemData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMEITEM {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.iType == other.iType
            && self.lpItemData == other.lpItemData
    }
}
impl ::std::cmp::Eq for IMEITEM {}
unsafe impl ::windows::runtime::Abi for IMEITEM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IMEITEMCANDIDATE {
    pub uCount: u32,
    pub imeItem: [IMEITEM; 1],
}
impl IMEITEMCANDIDATE {}
impl ::std::default::Default for IMEITEMCANDIDATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IMEITEMCANDIDATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMEITEMCANDIDATE")
            .field("uCount", &self.uCount)
            .field("imeItem", &self.imeItem)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IMEITEMCANDIDATE {
    fn eq(&self, other: &Self) -> bool {
        self.uCount == other.uCount && self.imeItem == other.imeItem
    }
}
impl ::std::cmp::Eq for IMEITEMCANDIDATE {}
unsafe impl ::windows::runtime::Abi for IMEITEMCANDIDATE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IMEKEYCTRLMASK_ALT: u32 = 1u32;
pub const IMEKEYCTRLMASK_CTRL: u32 = 2u32;
pub const IMEKEYCTRLMASK_SHIFT: u32 = 4u32;
pub const IMEKEYCTRL_DOWN: u32 = 0u32;
pub const IMEKEYCTRL_UP: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct IMEKMS {
    pub cbSize: i32,
    pub hIMC: HIMC,
    pub cKeyList: u32,
    pub pKeyList: *mut IMEKMSKEY,
}
impl IMEKMS {}
impl ::std::default::Default for IMEKMS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEKMS {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEKMS {}
unsafe impl ::windows::runtime::Abi for IMEKMS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct IMEKMSFUNCDESC {
    pub cbSize: i32,
    pub idLang: u16,
    pub dwControl: u32,
    pub pwszDescription: [u16; 128],
}
impl IMEKMSFUNCDESC {}
impl ::std::default::Default for IMEKMSFUNCDESC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEKMSFUNCDESC {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEKMSFUNCDESC {}
unsafe impl ::windows::runtime::Abi for IMEKMSFUNCDESC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct IMEKMSINIT {
    pub cbSize: i32,
    pub hWnd: super::Foundation::HWND,
}
#[cfg(feature = "Win32_Foundation")]
impl IMEKMSINIT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMEKMSINIT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMEKMSINIT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMEKMSINIT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMEKMSINIT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct IMEKMSINVK {
    pub cbSize: i32,
    pub hIMC: HIMC,
    pub dwControl: u32,
}
impl IMEKMSINVK {}
impl ::std::default::Default for IMEKMSINVK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEKMSINVK {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEKMSINVK {}
unsafe impl ::windows::runtime::Abi for IMEKMSINVK {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct IMEKMSKEY {
    pub dwStatus: u32,
    pub dwCompStatus: u32,
    pub dwVKEY: u32,
    pub Anonymous1: IMEKMSKEY_0,
    pub Anonymous2: IMEKMSKEY_1,
}
impl IMEKMSKEY {}
impl ::std::default::Default for IMEKMSKEY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEKMSKEY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEKMSKEY {}
unsafe impl ::windows::runtime::Abi for IMEKMSKEY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub union IMEKMSKEY_0 {
    pub dwControl: u32,
    pub dwNotUsed: u32,
}
impl IMEKMSKEY_0 {}
impl ::std::default::Default for IMEKMSKEY_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEKMSKEY_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEKMSKEY_0 {}
unsafe impl ::windows::runtime::Abi for IMEKMSKEY_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub union IMEKMSKEY_1 {
    pub pwszDscr: [u16; 31],
    pub pwszNoUse: [u16; 31],
}
impl IMEKMSKEY_1 {}
impl ::std::default::Default for IMEKMSKEY_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEKMSKEY_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEKMSKEY_1 {}
unsafe impl ::windows::runtime::Abi for IMEKMSKEY_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct IMEKMSKMP {
    pub cbSize: i32,
    pub hIMC: HIMC,
    pub idLang: u16,
    pub wVKStart: u16,
    pub wVKEnd: u16,
    pub cKeyList: i32,
    pub pKeyList: *mut IMEKMSKEY,
}
impl IMEKMSKMP {}
impl ::std::default::Default for IMEKMSKMP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEKMSKMP {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEKMSKMP {}
unsafe impl ::windows::runtime::Abi for IMEKMSKMP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct IMEKMSNTFY {
    pub cbSize: i32,
    pub hIMC: HIMC,
    pub fSelect: super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl IMEKMSNTFY {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMEKMSNTFY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMEKMSNTFY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMEKMSNTFY {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMEKMSNTFY {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IMEKMS_2NDLEVEL: u32 = 4u32;
pub const IMEKMS_CANDIDATE: u32 = 6u32;
pub const IMEKMS_COMPOSITION: u32 = 1u32;
pub const IMEKMS_IMEOFF: u32 = 3u32;
pub const IMEKMS_INPTGL: u32 = 5u32;
pub const IMEKMS_NOCOMPOSITION: u32 = 0u32;
pub const IMEKMS_SELECTION: u32 = 2u32;
pub const IMEKMS_TYPECAND: u32 = 7u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
pub struct IMEMENUITEMINFOA {
    pub cbSize: u32,
    pub fType: u32,
    pub fState: u32,
    pub wID: u32,
    pub hbmpChecked: super::Graphics::Gdi::HBITMAP,
    pub hbmpUnchecked: super::Graphics::Gdi::HBITMAP,
    pub dwItemData: u32,
    pub szString: [super::System::SystemServices::CHAR; 80],
    pub hbmpItem: super::Graphics::Gdi::HBITMAP,
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl IMEMENUITEMINFOA {}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::default::Default for IMEMENUITEMINFOA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::fmt::Debug for IMEMENUITEMINFOA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMEMENUITEMINFOA")
            .field("cbSize", &self.cbSize)
            .field("fType", &self.fType)
            .field("fState", &self.fState)
            .field("wID", &self.wID)
            .field("hbmpChecked", &self.hbmpChecked)
            .field("hbmpUnchecked", &self.hbmpUnchecked)
            .field("dwItemData", &self.dwItemData)
            .field("szString", &self.szString)
            .field("hbmpItem", &self.hbmpItem)
            .finish()
    }
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::cmp::PartialEq for IMEMENUITEMINFOA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.fType == other.fType
            && self.fState == other.fState
            && self.wID == other.wID
            && self.hbmpChecked == other.hbmpChecked
            && self.hbmpUnchecked == other.hbmpUnchecked
            && self.dwItemData == other.dwItemData
            && self.szString == other.szString
            && self.hbmpItem == other.hbmpItem
    }
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::cmp::Eq for IMEMENUITEMINFOA {}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
unsafe impl ::windows::runtime::Abi for IMEMENUITEMINFOA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Graphics_Gdi")]
pub struct IMEMENUITEMINFOW {
    pub cbSize: u32,
    pub fType: u32,
    pub fState: u32,
    pub wID: u32,
    pub hbmpChecked: super::Graphics::Gdi::HBITMAP,
    pub hbmpUnchecked: super::Graphics::Gdi::HBITMAP,
    pub dwItemData: u32,
    pub szString: [u16; 80],
    pub hbmpItem: super::Graphics::Gdi::HBITMAP,
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl IMEMENUITEMINFOW {}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::default::Default for IMEMENUITEMINFOW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::fmt::Debug for IMEMENUITEMINFOW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMEMENUITEMINFOW")
            .field("cbSize", &self.cbSize)
            .field("fType", &self.fType)
            .field("fState", &self.fState)
            .field("wID", &self.wID)
            .field("hbmpChecked", &self.hbmpChecked)
            .field("hbmpUnchecked", &self.hbmpUnchecked)
            .field("dwItemData", &self.dwItemData)
            .field("szString", &self.szString)
            .field("hbmpItem", &self.hbmpItem)
            .finish()
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::PartialEq for IMEMENUITEMINFOW {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.fType == other.fType
            && self.fState == other.fState
            && self.wID == other.wID
            && self.hbmpChecked == other.hbmpChecked
            && self.hbmpUnchecked == other.hbmpUnchecked
            && self.dwItemData == other.dwItemData
            && self.szString == other.szString
            && self.hbmpItem == other.hbmpItem
    }
}
#[cfg(feature = "Win32_Graphics_Gdi")]
impl ::std::cmp::Eq for IMEMENUITEMINFOW {}
#[cfg(feature = "Win32_Graphics_Gdi")]
unsafe impl ::windows::runtime::Abi for IMEMENUITEMINFOW {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IMEMENUITEM_STRING_SIZE: u32 = 80u32;
pub const IMEMOUSERET_NOTHANDLED: i32 = -1i32;
pub const IMEMOUSE_LDOWN: u32 = 1u32;
pub const IMEMOUSE_MDOWN: u32 = 4u32;
pub const IMEMOUSE_NONE: u32 = 0u32;
pub const IMEMOUSE_RDOWN: u32 = 2u32;
pub const IMEMOUSE_VERSION: u32 = 255u32;
pub const IMEMOUSE_WDOWN: u32 = 32u32;
pub const IMEMOUSE_WUP: u32 = 16u32;
pub const IMEPADCTRL_CARETBACKSPACE: u32 = 10u32;
pub const IMEPADCTRL_CARETBOTTOM: u32 = 9u32;
pub const IMEPADCTRL_CARETDELETE: u32 = 11u32;
pub const IMEPADCTRL_CARETLEFT: u32 = 6u32;
pub const IMEPADCTRL_CARETRIGHT: u32 = 7u32;
pub const IMEPADCTRL_CARETSET: u32 = 5u32;
pub const IMEPADCTRL_CARETTOP: u32 = 8u32;
pub const IMEPADCTRL_CLEARALL: u32 = 4u32;
pub const IMEPADCTRL_CONVERTALL: u32 = 1u32;
pub const IMEPADCTRL_DETERMINALL: u32 = 2u32;
pub const IMEPADCTRL_DETERMINCHAR: u32 = 3u32;
pub const IMEPADCTRL_INSERTFULLSPACE: u32 = 14u32;
pub const IMEPADCTRL_INSERTHALFSPACE: u32 = 15u32;
pub const IMEPADCTRL_INSERTSPACE: u32 = 13u32;
pub const IMEPADCTRL_OFFIME: u32 = 17u32;
pub const IMEPADCTRL_OFFPRECONVERSION: u32 = 19u32;
pub const IMEPADCTRL_ONIME: u32 = 16u32;
pub const IMEPADCTRL_ONPRECONVERSION: u32 = 18u32;
pub const IMEPADCTRL_PHONETICCANDIDATE: u32 = 20u32;
pub const IMEPADCTRL_PHRASEDELETE: u32 = 12u32;
pub const IMEPADREQ_CHANGESTRINGCANDIDATEINFO: u32 = 4111u32;
pub const IMEPADREQ_CHANGESTRINGINFO: u32 = 4115u32;
pub const IMEPADREQ_FIRST: u32 = 4096u32;
pub const IMEPADREQ_GETAPPLETDATA: u32 = 4106u32;
pub const IMEPADREQ_GETCOMPOSITIONSTRINGID: u32 = 4109u32;
pub const IMEPADREQ_GETCURRENTUILANGID: u32 = 4120u32;
pub const IMEPADREQ_GETSELECTEDSTRING: u32 = 4103u32;
pub const IMEPADREQ_INSERTITEMCANDIDATE: u32 = 4099u32;
pub const IMEPADREQ_INSERTSTRINGCANDIDATE: u32 = 4098u32;
pub const IMEPADREQ_INSERTSTRINGCANDIDATEINFO: u32 = 4110u32;
pub const IMEPADREQ_INSERTSTRINGINFO: u32 = 4114u32;
pub const IMEPADREQ_SENDKEYCONTROL: u32 = 4101u32;
pub const IMEPADREQ_SETAPPLETDATA: u32 = 4105u32;
pub const IMEPADREQ_SETTITLEFONT: u32 = 4107u32;
pub const IMEPN_ACTIVATE: u32 = 257u32;
pub const IMEPN_APPLYCAND: u32 = 267u32;
pub const IMEPN_APPLYCANDEX: u32 = 268u32;
pub const IMEPN_CONFIG: u32 = 264u32;
pub const IMEPN_FIRST: u32 = 256u32;
pub const IMEPN_HELP: u32 = 265u32;
pub const IMEPN_HIDE: u32 = 261u32;
pub const IMEPN_INACTIVATE: u32 = 258u32;
pub const IMEPN_QUERYCAND: u32 = 266u32;
pub const IMEPN_SETTINGCHANGED: u32 = 269u32;
pub const IMEPN_SHOW: u32 = 260u32;
pub const IMEPN_SIZECHANGED: u32 = 263u32;
pub const IMEPN_SIZECHANGING: u32 = 262u32;
pub const IMEPN_USER: u32 = 356u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct IMEREG(pub i32);
pub const IFED_REG_HEAD: IMEREG = IMEREG(0i32);
pub const IFED_REG_TAIL: IMEREG = IMEREG(1i32);
pub const IFED_REG_DEL: IMEREG = IMEREG(2i32);
impl ::std::convert::From<i32> for IMEREG {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMEREG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct IMEREL(pub i32);
pub const IFED_REL_NONE: IMEREL = IMEREL(0i32);
pub const IFED_REL_NO: IMEREL = IMEREL(1i32);
pub const IFED_REL_GA: IMEREL = IMEREL(2i32);
pub const IFED_REL_WO: IMEREL = IMEREL(3i32);
pub const IFED_REL_NI: IMEREL = IMEREL(4i32);
pub const IFED_REL_DE: IMEREL = IMEREL(5i32);
pub const IFED_REL_YORI: IMEREL = IMEREL(6i32);
pub const IFED_REL_KARA: IMEREL = IMEREL(7i32);
pub const IFED_REL_MADE: IMEREL = IMEREL(8i32);
pub const IFED_REL_HE: IMEREL = IMEREL(9i32);
pub const IFED_REL_TO: IMEREL = IMEREL(10i32);
pub const IFED_REL_IDEOM: IMEREL = IMEREL(11i32);
pub const IFED_REL_FUKU_YOUGEN: IMEREL = IMEREL(12i32);
pub const IFED_REL_KEIYOU_YOUGEN: IMEREL = IMEREL(13i32);
pub const IFED_REL_KEIDOU1_YOUGEN: IMEREL = IMEREL(14i32);
pub const IFED_REL_KEIDOU2_YOUGEN: IMEREL = IMEREL(15i32);
pub const IFED_REL_TAIGEN: IMEREL = IMEREL(16i32);
pub const IFED_REL_YOUGEN: IMEREL = IMEREL(17i32);
pub const IFED_REL_RENTAI_MEI: IMEREL = IMEREL(18i32);
pub const IFED_REL_RENSOU: IMEREL = IMEREL(19i32);
pub const IFED_REL_KEIYOU_TO_YOUGEN: IMEREL = IMEREL(20i32);
pub const IFED_REL_KEIYOU_TARU_YOUGEN: IMEREL = IMEREL(21i32);
pub const IFED_REL_UNKNOWN1: IMEREL = IMEREL(22i32);
pub const IFED_REL_UNKNOWN2: IMEREL = IMEREL(23i32);
pub const IFED_REL_ALL: IMEREL = IMEREL(24i32);
impl ::std::convert::From<i32> for IMEREL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMEREL {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_System_SystemServices")]
pub struct IMESHF {
    pub cbShf: u16,
    pub verDic: u16,
    pub szTitle: [super::System::SystemServices::CHAR; 48],
    pub szDescription: [super::System::SystemServices::CHAR; 256],
    pub szCopyright: [super::System::SystemServices::CHAR; 128],
}
#[cfg(feature = "Win32_System_SystemServices")]
impl IMESHF {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::default::Default for IMESHF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::PartialEq for IMESHF {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::Eq for IMESHF {}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::runtime::Abi for IMESHF {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct IMESTRINGCANDIDATE {
    pub uCount: u32,
    pub lpwstr: [super::Foundation::PWSTR; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl IMESTRINGCANDIDATE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMESTRINGCANDIDATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for IMESTRINGCANDIDATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMESTRINGCANDIDATE")
            .field("uCount", &self.uCount)
            .field("lpwstr", &self.lpwstr)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMESTRINGCANDIDATE {
    fn eq(&self, other: &Self) -> bool {
        self.uCount == other.uCount && self.lpwstr == other.lpwstr
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMESTRINGCANDIDATE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMESTRINGCANDIDATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct IMESTRINGCANDIDATEINFO {
    pub dwFarEastId: u32,
    pub lpFarEastInfo: *mut tabIMEFAREASTINFO,
    pub fInfoMask: u32,
    pub iSelIndex: i32,
    pub uCount: u32,
    pub lpwstr: [super::Foundation::PWSTR; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl IMESTRINGCANDIDATEINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMESTRINGCANDIDATEINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for IMESTRINGCANDIDATEINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IMESTRINGCANDIDATEINFO")
            .field("dwFarEastId", &self.dwFarEastId)
            .field("lpFarEastInfo", &self.lpFarEastInfo)
            .field("fInfoMask", &self.fInfoMask)
            .field("iSelIndex", &self.iSelIndex)
            .field("uCount", &self.uCount)
            .field("lpwstr", &self.lpwstr)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMESTRINGCANDIDATEINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFarEastId == other.dwFarEastId
            && self.lpFarEastInfo == other.lpFarEastInfo
            && self.fInfoMask == other.fInfoMask
            && self.iSelIndex == other.iSelIndex
            && self.uCount == other.uCount
            && self.lpwstr == other.lpwstr
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMESTRINGCANDIDATEINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMESTRINGCANDIDATEINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct IMEUCT(pub i32);
pub const IFED_UCT_NONE: IMEUCT = IMEUCT(0i32);
pub const IFED_UCT_STRING_SJIS: IMEUCT = IMEUCT(1i32);
pub const IFED_UCT_STRING_UNICODE: IMEUCT = IMEUCT(2i32);
pub const IFED_UCT_USER_DEFINED: IMEUCT = IMEUCT(3i32);
pub const IFED_UCT_MAX: IMEUCT = IMEUCT(4i32);
impl ::std::convert::From<i32> for IMEUCT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IMEUCT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IMEVER_0310: u32 = 196618u32;
pub const IMEVER_0400: u32 = 262144u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct IMEWRD {
    pub pwchReading: super::Foundation::PWSTR,
    pub pwchDisplay: super::Foundation::PWSTR,
    pub Anonymous: IMEWRD_0,
    pub rgulAttrs: [u32; 2],
    pub cbComment: i32,
    pub uct: IMEUCT,
    pub pvComment: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl IMEWRD {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for IMEWRD {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for IMEWRD {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for IMEWRD {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for IMEWRD {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub union IMEWRD_0 {
    pub ulPos: u32,
    pub Anonymous: IMEWRD_0_0,
}
impl IMEWRD_0 {}
impl ::std::default::Default for IMEWRD_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEWRD_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEWRD_0 {}
unsafe impl ::windows::runtime::Abi for IMEWRD_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct IMEWRD_0_0 {
    pub nPos1: u16,
    pub nPos2: u16,
}
impl IMEWRD_0_0 {}
impl ::std::default::Default for IMEWRD_0_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for IMEWRD_0_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for IMEWRD_0_0 {}
unsafe impl ::windows::runtime::Abi for IMEWRD_0_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IME_CAND_CODE: u32 = 2u32;
pub const IME_CAND_MEANING: u32 = 3u32;
pub const IME_CAND_RADICAL: u32 = 4u32;
pub const IME_CAND_READ: u32 = 1u32;
pub const IME_CAND_STROKE: u32 = 5u32;
pub const IME_CAND_UNKNOWN: u32 = 0u32;
pub const IME_CHOTKEY_IME_NONIME_TOGGLE: u32 = 16u32;
pub const IME_CHOTKEY_SHAPE_TOGGLE: u32 = 17u32;
pub const IME_CHOTKEY_SYMBOL_TOGGLE: u32 = 18u32;
pub const IME_CMODE_ALPHANUMERIC: u32 = 0u32;
pub const IME_CMODE_CHARCODE: u32 = 32u32;
pub const IME_CMODE_CHINESE: u32 = 1u32;
pub const IME_CMODE_EUDC: u32 = 512u32;
pub const IME_CMODE_FIXED: u32 = 2048u32;
pub const IME_CMODE_FULLSHAPE: u32 = 8u32;
pub const IME_CMODE_HANGUL: u32 = 1u32;
pub const IME_CMODE_HANJACONVERT: u32 = 64u32;
pub const IME_CMODE_JAPANESE: u32 = 1u32;
pub const IME_CMODE_KATAKANA: u32 = 2u32;
pub const IME_CMODE_LANGUAGE: u32 = 3u32;
pub const IME_CMODE_NATIVE: u32 = 1u32;
pub const IME_CMODE_NATIVESYMBOL: u32 = 128u32;
pub const IME_CMODE_NOCONVERSION: u32 = 256u32;
pub const IME_CMODE_RESERVED: u32 = 4026531840u32;
pub const IME_CMODE_ROMAN: u32 = 16u32;
pub const IME_CMODE_SOFTKBD: u32 = 128u32;
pub const IME_CMODE_SYMBOL: u32 = 1024u32;
pub const IME_CONFIG_GENERAL: u32 = 1u32;
pub const IME_CONFIG_REGISTERWORD: u32 = 2u32;
pub const IME_CONFIG_SELECTDICTIONARY: u32 = 3u32;
pub const IME_ESC_AUTOMATA: u32 = 4105u32;
pub const IME_ESC_GETHELPFILENAME: u32 = 4107u32;
pub const IME_ESC_GET_EUDC_DICTIONARY: u32 = 4099u32;
pub const IME_ESC_HANJA_MODE: u32 = 4104u32;
pub const IME_ESC_IME_NAME: u32 = 4102u32;
pub const IME_ESC_MAX_KEY: u32 = 4101u32;
pub const IME_ESC_PRIVATE_FIRST: u32 = 2048u32;
pub const IME_ESC_PRIVATE_HOTKEY: u32 = 4106u32;
pub const IME_ESC_PRIVATE_LAST: u32 = 4095u32;
pub const IME_ESC_QUERY_SUPPORT: u32 = 3u32;
pub const IME_ESC_RESERVED_FIRST: u32 = 4u32;
pub const IME_ESC_RESERVED_LAST: u32 = 2047u32;
pub const IME_ESC_SEQUENCE_TO_INTERNAL: u32 = 4097u32;
pub const IME_ESC_SET_EUDC_DICTIONARY: u32 = 4100u32;
pub const IME_ESC_STRING_BUFFER_SIZE: u32 = 80u32;
pub const IME_ESC_SYNC_HOTKEY: u32 = 4103u32;
pub const IME_HOTKEY_DSWITCH_FIRST: u32 = 256u32;
pub const IME_HOTKEY_DSWITCH_LAST: u32 = 287u32;
pub const IME_HOTKEY_PRIVATE_FIRST: u32 = 512u32;
pub const IME_HOTKEY_PRIVATE_LAST: u32 = 543u32;
pub const IME_ITHOTKEY_PREVIOUS_COMPOSITION: u32 = 513u32;
pub const IME_ITHOTKEY_RECONVERTSTRING: u32 = 515u32;
pub const IME_ITHOTKEY_RESEND_RESULTSTR: u32 = 512u32;
pub const IME_ITHOTKEY_UISTYLE_TOGGLE: u32 = 514u32;
pub const IME_JHOTKEY_CLOSE_OPEN: u32 = 48u32;
pub const IME_KHOTKEY_ENGLISH: u32 = 82u32;
pub const IME_KHOTKEY_HANJACONVERT: u32 = 81u32;
pub const IME_KHOTKEY_SHAPE_TOGGLE: u32 = 80u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct IME_PAD_REQUEST_FLAGS(pub u32);
pub const IMEPADREQ_INSERTSTRING: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4097u32);
pub const IMEPADREQ_SENDCONTROL: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4100u32);
pub const IMEPADREQ_SETAPPLETSIZE: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4104u32);
pub const IMEPADREQ_GETCOMPOSITIONSTRING: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4102u32);
pub const IMEPADREQ_GETCOMPOSITIONSTRINGINFO: IME_PAD_REQUEST_FLAGS =
    IME_PAD_REQUEST_FLAGS(4108u32);
pub const IMEPADREQ_DELETESTRING: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4112u32);
pub const IMEPADREQ_CHANGESTRING: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4113u32);
pub const IMEPADREQ_GETAPPLHWND: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4116u32);
pub const IMEPADREQ_FORCEIMEPADWINDOWSHOW: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4117u32);
pub const IMEPADREQ_POSTMODALNOTIFY: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4118u32);
pub const IMEPADREQ_GETDEFAULTUILANGID: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4119u32);
pub const IMEPADREQ_GETAPPLETUISTYLE: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4121u32);
pub const IMEPADREQ_SETAPPLETUISTYLE: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4122u32);
pub const IMEPADREQ_ISAPPLETACTIVE: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4123u32);
pub const IMEPADREQ_ISIMEPADWINDOWVISIBLE: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4124u32);
pub const IMEPADREQ_SETAPPLETMINMAXSIZE: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4125u32);
pub const IMEPADREQ_GETCONVERSIONSTATUS: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4126u32);
pub const IMEPADREQ_GETVERSION: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4127u32);
pub const IMEPADREQ_GETCURRENTIMEINFO: IME_PAD_REQUEST_FLAGS = IME_PAD_REQUEST_FLAGS(4128u32);
impl ::std::convert::From<u32> for IME_PAD_REQUEST_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IME_PAD_REQUEST_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for IME_PAD_REQUEST_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for IME_PAD_REQUEST_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for IME_PAD_REQUEST_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for IME_PAD_REQUEST_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for IME_PAD_REQUEST_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const IME_PROP_ACCEPT_WIDE_VKEY: u32 = 32u32;
pub const IME_PROP_AT_CARET: u32 = 65536u32;
pub const IME_PROP_CANDLIST_START_FROM_1: u32 = 262144u32;
pub const IME_PROP_COMPLETE_ON_UNSELECT: u32 = 1048576u32;
pub const IME_PROP_END_UNLOAD: u32 = 1u32;
pub const IME_PROP_IGNORE_UPKEYS: u32 = 4u32;
pub const IME_PROP_KBD_CHAR_FIRST: u32 = 2u32;
pub const IME_PROP_NEED_ALTKEY: u32 = 8u32;
pub const IME_PROP_NO_KEYS_ON_CLOSE: u32 = 16u32;
pub const IME_PROP_SPECIAL_UI: u32 = 131072u32;
pub const IME_PROP_UNICODE: u32 = 524288u32;
pub const IME_REGWORD_STYLE_EUDC: u32 = 1u32;
pub const IME_REGWORD_STYLE_USER_FIRST: u32 = 2147483648u32;
pub const IME_REGWORD_STYLE_USER_LAST: u32 = 4294967295u32;
pub const IME_SMODE_AUTOMATIC: u32 = 4u32;
pub const IME_SMODE_CONVERSATION: u32 = 16u32;
pub const IME_SMODE_NONE: u32 = 0u32;
pub const IME_SMODE_PHRASEPREDICT: u32 = 8u32;
pub const IME_SMODE_PLAURALCLAUSE: u32 = 1u32;
pub const IME_SMODE_RESERVED: u32 = 61440u32;
pub const IME_SMODE_SINGLECONVERT: u32 = 2u32;
pub const IME_SYSINFO_WINLOGON: u32 = 1u32;
pub const IME_SYSINFO_WOW16: u32 = 2u32;
pub const IME_THOTKEY_IME_NONIME_TOGGLE: u32 = 112u32;
pub const IME_THOTKEY_SHAPE_TOGGLE: u32 = 113u32;
pub const IME_THOTKEY_SYMBOL_TOGGLE: u32 = 114u32;
pub const IME_UI_CLASS_NAME_SIZE: u32 = 16u32;
pub const IMFT_RADIOCHECK: u32 = 1u32;
pub const IMFT_SEPARATOR: u32 = 2u32;
pub const IMFT_SUBMENU: u32 = 4u32;
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangCodePages(::windows::runtime::IUnknown);
impl IMLangCodePages {
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(chsrc),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStrCodePages<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pszsrc: Param0,
        cchsrc: i32,
        dwprioritycodepages: u32,
        pdwcodepages: *mut u32,
        pcchcodepages: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(dwprioritycodepages),
            ::std::mem::transmute(pdwcodepages),
            ::std::mem::transmute(pcchcodepages),
        )
        .ok()
    }
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ucodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CodePagesToCodePage(
        &self,
        dwcodepages: u32,
        udefaultcodepage: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwcodepages),
            ::std::mem::transmute(udefaultcodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMLangCodePages {
    type Vtable = IMLangCodePages_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        899626051,
        48458,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangCodePages> for ::windows::runtime::IUnknown {
    fn from(value: IMLangCodePages) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangCodePages> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangCodePages) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangCodePages {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangCodePages {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangCodePages_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        chsrc: u16,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszsrc: super::Foundation::PWSTR,
        cchsrc: i32,
        dwprioritycodepages: u32,
        pdwcodepages: *mut u32,
        pcchcodepages: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ucodepage: u32,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwcodepages: u32,
        udefaultcodepage: u32,
        pucodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangConvertCharset(::windows::runtime::IUnknown);
impl IMLangConvertCharset {
    pub unsafe fn Initialize(
        &self,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uisrccodepage),
            ::std::mem::transmute(uidstcodepage),
            ::std::mem::transmute(dwproperty),
        )
        .ok()
    }
    pub unsafe fn GetSourceCodePage(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetDestinationCodePage(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetProperty(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn DoConversion(
        &self,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(psrcstr),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DoConversionToUnicode<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        psrcstr: Param0,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DoConversionFromUnicode<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        psrcstr: Param0,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangConvertCharset {
    type Vtable = IMLangConvertCharset_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3597496216,
        52650,
        4560,
        [184, 34, 0, 192, 79, 201, 179, 31],
    );
}
impl ::std::convert::From<IMLangConvertCharset> for ::windows::runtime::IUnknown {
    fn from(value: IMLangConvertCharset) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangConvertCharset> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangConvertCharset) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangConvertCharset {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangConvertCharset {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangConvertCharset_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puisrccodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puidstcodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwproperty: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psrcstr: super::Foundation::PWSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangFontLink(::windows::runtime::IUnknown);
impl IMLangFontLink {
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(chsrc),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStrCodePages<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pszsrc: Param0,
        cchsrc: i32,
        dwprioritycodepages: u32,
        pdwcodepages: *mut u32,
        pcchcodepages: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(dwprioritycodepages),
            ::std::mem::transmute(pdwcodepages),
            ::std::mem::transmute(pcchcodepages),
        )
        .ok()
    }
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ucodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CodePagesToCodePage(
        &self,
        dwcodepages: u32,
        udefaultcodepage: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwcodepages),
            ::std::mem::transmute(udefaultcodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetFontCodePages<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>,
    >(
        &self,
        hdc: Param0,
        hfont: Param1,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            hdc.into_param().abi(),
            hfont.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn MapFont<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
        Param2: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>,
    >(
        &self,
        hdc: Param0,
        dwcodepages: u32,
        hsrcfont: Param2,
    ) -> ::windows::runtime::Result<super::Graphics::Gdi::HFONT> {
        let mut result__: <super::Graphics::Gdi::HFONT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            hdc.into_param().abi(),
            ::std::mem::transmute(dwcodepages),
            hsrcfont.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Graphics::Gdi::HFONT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn ReleaseFont<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>,
    >(
        &self,
        hfont: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            hfont.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ResetFontMapping(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangFontLink {
    type Vtable = IMLangFontLink_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        899626049,
        48458,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangFontLink> for ::windows::runtime::IUnknown {
    fn from(value: IMLangFontLink) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangFontLink> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangFontLink) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IMLangFontLink> for IMLangCodePages {
    fn from(value: IMLangFontLink) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangFontLink> for IMLangCodePages {
    fn from(value: &IMLangFontLink) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangCodePages>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for &IMLangFontLink {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangCodePages>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangFontLink_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        chsrc: u16,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszsrc: super::Foundation::PWSTR,
        cchsrc: i32,
        dwprioritycodepages: u32,
        pdwcodepages: *mut u32,
        pcchcodepages: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ucodepage: u32,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwcodepages: u32,
        udefaultcodepage: u32,
        pucodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hdc: super::Graphics::Gdi::HDC,
        hfont: super::Graphics::Gdi::HFONT,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hdc: super::Graphics::Gdi::HDC,
        dwcodepages: u32,
        hsrcfont: super::Graphics::Gdi::HFONT,
        phdestfont: *mut super::Graphics::Gdi::HFONT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hfont: super::Graphics::Gdi::HFONT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangFontLink2(::windows::runtime::IUnknown);
impl IMLangFontLink2 {
    pub unsafe fn GetCharCodePages(&self, chsrc: u16) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(chsrc),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStrCodePages<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pszsrc: Param0,
        cchsrc: i32,
        dwprioritycodepages: u32,
        pdwcodepages: *mut u32,
        pcchcodepages: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(dwprioritycodepages),
            ::std::mem::transmute(pdwcodepages),
            ::std::mem::transmute(pcchcodepages),
        )
        .ok()
    }
    pub unsafe fn CodePageToCodePages(&self, ucodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ucodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CodePagesToCodePage(
        &self,
        dwcodepages: u32,
        udefaultcodepage: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwcodepages),
            ::std::mem::transmute(udefaultcodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetFontCodePages<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
        Param1: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>,
    >(
        &self,
        hdc: Param0,
        hfont: Param1,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            hdc.into_param().abi(),
            hfont.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn ReleaseFont<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HFONT>,
    >(
        &self,
        hfont: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            hfont.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ResetFontMapping(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn MapFont<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    >(
        &self,
        hdc: Param0,
        dwcodepages: u32,
        chsrc: u16,
    ) -> ::windows::runtime::Result<super::Graphics::Gdi::HFONT> {
        let mut result__: <super::Graphics::Gdi::HFONT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hdc.into_param().abi(),
            ::std::mem::transmute(dwcodepages),
            ::std::mem::transmute(chsrc),
            &mut result__,
        )
        .from_abi::<super::Graphics::Gdi::HFONT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetFontUnicodeRanges<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    >(
        &self,
        hdc: Param0,
        puiranges: *const u32,
    ) -> ::windows::runtime::Result<UNICODERANGE> {
        let mut result__: <UNICODERANGE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            hdc.into_param().abi(),
            ::std::mem::transmute(puiranges),
            &mut result__,
        )
        .from_abi::<UNICODERANGE>(result__)
    }
    pub unsafe fn GetScriptFontInfo(
        &self,
        sid: u8,
        dwflags: u32,
        puifonts: *mut u32,
        pscriptfont: *mut tagSCRIPFONTINFO,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(sid),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(puifonts),
            ::std::mem::transmute(pscriptfont),
        )
        .ok()
    }
    pub unsafe fn CodePageToScriptID(&self, uicodepage: u32) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            &mut result__,
        )
        .from_abi::<u8>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMLangFontLink2 {
    type Vtable = IMLangFontLink2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3704602978,
        11064,
        4562,
        [183, 236, 0, 192, 79, 143, 93, 154],
    );
}
impl ::std::convert::From<IMLangFontLink2> for ::windows::runtime::IUnknown {
    fn from(value: IMLangFontLink2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangFontLink2> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangFontLink2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IMLangFontLink2> for IMLangCodePages {
    fn from(value: IMLangFontLink2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangFontLink2> for IMLangCodePages {
    fn from(value: &IMLangFontLink2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangCodePages>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangCodePages> for &IMLangFontLink2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangCodePages> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangCodePages>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangFontLink2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        chsrc: u16,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszsrc: super::Foundation::PWSTR,
        cchsrc: i32,
        dwprioritycodepages: u32,
        pdwcodepages: *mut u32,
        pcchcodepages: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ucodepage: u32,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwcodepages: u32,
        udefaultcodepage: u32,
        pucodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hdc: super::Graphics::Gdi::HDC,
        hfont: super::Graphics::Gdi::HFONT,
        pdwcodepages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hfont: super::Graphics::Gdi::HFONT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hdc: super::Graphics::Gdi::HDC,
        dwcodepages: u32,
        chsrc: u16,
        pfont: *mut super::Graphics::Gdi::HFONT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hdc: super::Graphics::Gdi::HDC,
        puiranges: *const u32,
        puranges: *mut UNICODERANGE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        sid: u8,
        dwflags: u32,
        puifonts: *mut u32,
        pscriptfont: *mut tagSCRIPFONTINFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        psid: *mut u8,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangLineBreakConsole(::windows::runtime::IUnknown);
impl IMLangLineBreakConsole {
    pub unsafe fn BreakLineML<'a, Param0: ::windows::runtime::IntoParam<'a, IMLangString>>(
        &self,
        psrcmlstr: Param0,
        lsrcpos: i32,
        lsrclen: i32,
        cmincolumns: i32,
        cmaxcolumns: i32,
        pllinelen: *mut i32,
        plskiplen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            psrcmlstr.into_param().abi(),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            ::std::mem::transmute(cmincolumns),
            ::std::mem::transmute(cmaxcolumns),
            ::std::mem::transmute(pllinelen),
            ::std::mem::transmute(plskiplen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BreakLineW<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        locale: u32,
        pszsrc: Param1,
        cchsrc: i32,
        cmaxcolumns: i32,
        pcchline: *mut i32,
        pcchskip: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(cmaxcolumns),
            ::std::mem::transmute(pcchline),
            ::std::mem::transmute(pcchskip),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BreakLineA<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        locale: u32,
        ucodepage: u32,
        pszsrc: Param2,
        cchsrc: i32,
        cmaxcolumns: i32,
        pcchline: *mut i32,
        pcchskip: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(ucodepage),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(cmaxcolumns),
            ::std::mem::transmute(pcchline),
            ::std::mem::transmute(pcchskip),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangLineBreakConsole {
    type Vtable = IMLangLineBreakConsole_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4122881761,
        49111,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangLineBreakConsole> for ::windows::runtime::IUnknown {
    fn from(value: IMLangLineBreakConsole) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangLineBreakConsole> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangLineBreakConsole) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IMLangLineBreakConsole
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IMLangLineBreakConsole
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangLineBreakConsole_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psrcmlstr: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        cmincolumns: i32,
        cmaxcolumns: i32,
        pllinelen: *mut i32,
        plskiplen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        pszsrc: super::Foundation::PWSTR,
        cchsrc: i32,
        cmaxcolumns: i32,
        pcchline: *mut i32,
        pcchskip: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        ucodepage: u32,
        pszsrc: super::Foundation::PSTR,
        cchsrc: i32,
        cmaxcolumns: i32,
        pcchline: *mut i32,
        pcchskip: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangString(::windows::runtime::IUnknown);
impl IMLangString {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Sync<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(
        &self,
        fnoaccess: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            fnoaccess.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetLength(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn SetMLStr<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        psrcmlstr: Param2,
        lsrcpos: i32,
        lsrclen: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            psrcmlstr.into_param().abi(),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
        )
        .ok()
    }
    pub unsafe fn GetMLStr<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        lsrcpos: i32,
        lsrclen: i32,
        punkouter: Param2,
        dwclscontext: u32,
        piid: *const ::windows::runtime::GUID,
        ppdestmlstr: *mut ::std::option::Option<::windows::runtime::IUnknown>,
        pldestpos: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            punkouter.into_param().abi(),
            ::std::mem::transmute(dwclscontext),
            ::std::mem::transmute(piid),
            ::std::mem::transmute(ppdestmlstr),
            ::std::mem::transmute(pldestpos),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangString {
    type Vtable = IMLangString_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3226297806,
        46861,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangString> for ::windows::runtime::IUnknown {
    fn from(value: IMLangString) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangString> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangString) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangString {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangString {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangString_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fnoaccess: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pllen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        psrcmlstr: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        punkouter: ::windows::runtime::RawPtr,
        dwclscontext: u32,
        piid: *const ::windows::runtime::GUID,
        ppdestmlstr: *mut ::windows::runtime::RawPtr,
        pldestpos: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangStringAStr(::windows::runtime::IUnknown);
impl IMLangStringAStr {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Sync<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(
        &self,
        fnoaccess: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            fnoaccess.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetLength(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn SetMLStr<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        psrcmlstr: Param2,
        lsrcpos: i32,
        lsrclen: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            psrcmlstr.into_param().abi(),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
        )
        .ok()
    }
    pub unsafe fn GetMLStr<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        lsrcpos: i32,
        lsrclen: i32,
        punkouter: Param2,
        dwclscontext: u32,
        piid: *const ::windows::runtime::GUID,
        ppdestmlstr: *mut ::std::option::Option<::windows::runtime::IUnknown>,
        pldestpos: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            punkouter.into_param().abi(),
            ::std::mem::transmute(dwclscontext),
            ::std::mem::transmute(piid),
            ::std::mem::transmute(ppdestmlstr),
            ::std::mem::transmute(pldestpos),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAStr<
        'a,
        Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        ucodepage: u32,
        pszsrc: Param3,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            ::std::mem::transmute(ucodepage),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    pub unsafe fn SetStrBufA<'a, Param3: ::windows::runtime::IntoParam<'a, IMLangStringBufA>>(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        ucodepage: u32,
        psrcbuf: Param3,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            ::std::mem::transmute(ucodepage),
            psrcbuf.into_param().abi(),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetAStr(
        &self,
        lsrcpos: i32,
        lsrclen: i32,
        ucodepagein: u32,
        pucodepageout: *mut u32,
        pszdest: super::Foundation::PSTR,
        cchdest: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            ::std::mem::transmute(ucodepagein),
            ::std::mem::transmute(pucodepageout),
            ::std::mem::transmute(pszdest),
            ::std::mem::transmute(cchdest),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    pub unsafe fn GetStrBufA(
        &self,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        pudestcodepage: *mut u32,
        ppdestbuf: *mut ::std::option::Option<IMLangStringBufA>,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrcmaxlen),
            ::std::mem::transmute(pudestcodepage),
            ::std::mem::transmute(ppdestbuf),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LockAStr(
        &self,
        lsrcpos: i32,
        lsrclen: i32,
        lflags: i32,
        ucodepagein: u32,
        cchrequest: i32,
        pucodepageout: *mut u32,
        ppszdest: *mut super::Foundation::PSTR,
        pcchdest: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            ::std::mem::transmute(lflags),
            ::std::mem::transmute(ucodepagein),
            ::std::mem::transmute(cchrequest),
            ::std::mem::transmute(pucodepageout),
            ::std::mem::transmute(ppszdest),
            ::std::mem::transmute(pcchdest),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnlockAStr<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        pszsrc: Param0,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    pub unsafe fn SetLocale(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        locale: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            ::std::mem::transmute(locale),
        )
        .ok()
    }
    pub unsafe fn GetLocale(
        &self,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        plocale: *mut u32,
        pllocalepos: *mut i32,
        pllocalelen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrcmaxlen),
            ::std::mem::transmute(plocale),
            ::std::mem::transmute(pllocalepos),
            ::std::mem::transmute(pllocalelen),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringAStr {
    type Vtable = IMLangStringAStr_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3226297810,
        46861,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangStringAStr> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringAStr) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringAStr> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringAStr) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IMLangStringAStr> for IMLangString {
    fn from(value: IMLangStringAStr) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringAStr> for IMLangString {
    fn from(value: &IMLangStringAStr) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangString>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for &IMLangStringAStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangString>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringAStr_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fnoaccess: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pllen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        psrcmlstr: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        punkouter: ::windows::runtime::RawPtr,
        dwclscontext: u32,
        piid: *const ::windows::runtime::GUID,
        ppdestmlstr: *mut ::windows::runtime::RawPtr,
        pldestpos: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        ucodepage: u32,
        pszsrc: super::Foundation::PSTR,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        ucodepage: u32,
        psrcbuf: ::windows::runtime::RawPtr,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        ucodepagein: u32,
        pucodepageout: *mut u32,
        pszdest: super::Foundation::PSTR,
        cchdest: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        pudestcodepage: *mut u32,
        ppdestbuf: *mut ::windows::runtime::RawPtr,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        lflags: i32,
        ucodepagein: u32,
        cchrequest: i32,
        pucodepageout: *mut u32,
        ppszdest: *mut super::Foundation::PSTR,
        pcchdest: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszsrc: super::Foundation::PSTR,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        locale: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        plocale: *mut u32,
        pllocalepos: *mut i32,
        pllocalelen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangStringBufA(::windows::runtime::IUnknown);
impl IMLangStringBufA {
    pub unsafe fn GetStatus(
        &self,
        plflags: *mut i32,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(plflags),
            ::std::mem::transmute(pcchbuf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_SystemServices")]
    pub unsafe fn LockBuf(
        &self,
        cchoffset: i32,
        cchmaxlock: i32,
        ppszbuf: *mut *mut super::System::SystemServices::CHAR,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchmaxlock),
            ::std::mem::transmute(ppszbuf),
            ::std::mem::transmute(pcchbuf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnlockBuf<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        pszbuf: Param0,
        cchoffset: i32,
        cchwrite: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            pszbuf.into_param().abi(),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchwrite),
        )
        .ok()
    }
    pub unsafe fn Insert(
        &self,
        cchoffset: i32,
        cchmaxinsert: i32,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchmaxinsert),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn Delete(&self, cchoffset: i32, cchdelete: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchdelete),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringBufA {
    type Vtable = IMLangStringBufA_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3528117539,
        47730,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangStringBufA> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringBufA) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringBufA> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringBufA) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringBufA {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangStringBufA {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringBufA_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plflags: *mut i32,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_SystemServices")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cchoffset: i32,
        cchmaxlock: i32,
        ppszbuf: *mut *mut super::System::SystemServices::CHAR,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_SystemServices"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszbuf: super::Foundation::PSTR,
        cchoffset: i32,
        cchwrite: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cchoffset: i32,
        cchmaxinsert: i32,
        pcchactual: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cchoffset: i32,
        cchdelete: i32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangStringBufW(::windows::runtime::IUnknown);
impl IMLangStringBufW {
    pub unsafe fn GetStatus(
        &self,
        plflags: *mut i32,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(plflags),
            ::std::mem::transmute(pcchbuf),
        )
        .ok()
    }
    pub unsafe fn LockBuf(
        &self,
        cchoffset: i32,
        cchmaxlock: i32,
        ppszbuf: *mut *mut u16,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchmaxlock),
            ::std::mem::transmute(ppszbuf),
            ::std::mem::transmute(pcchbuf),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnlockBuf<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pszbuf: Param0,
        cchoffset: i32,
        cchwrite: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            pszbuf.into_param().abi(),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchwrite),
        )
        .ok()
    }
    pub unsafe fn Insert(
        &self,
        cchoffset: i32,
        cchmaxinsert: i32,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchmaxinsert),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn Delete(&self, cchoffset: i32, cchdelete: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cchoffset),
            ::std::mem::transmute(cchdelete),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringBufW {
    type Vtable = IMLangStringBufW_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3528117537,
        47730,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangStringBufW> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringBufW) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringBufW> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringBufW) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringBufW {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangStringBufW {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringBufW_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plflags: *mut i32,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cchoffset: i32,
        cchmaxlock: i32,
        ppszbuf: *mut *mut u16,
        pcchbuf: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszbuf: super::Foundation::PWSTR,
        cchoffset: i32,
        cchwrite: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cchoffset: i32,
        cchmaxinsert: i32,
        pcchactual: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cchoffset: i32,
        cchdelete: i32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMLangStringWStr(::windows::runtime::IUnknown);
impl IMLangStringWStr {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Sync<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>>(
        &self,
        fnoaccess: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            fnoaccess.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetLength(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn SetMLStr<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        psrcmlstr: Param2,
        lsrcpos: i32,
        lsrclen: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            psrcmlstr.into_param().abi(),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
        )
        .ok()
    }
    pub unsafe fn GetMLStr<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        lsrcpos: i32,
        lsrclen: i32,
        punkouter: Param2,
        dwclscontext: u32,
        piid: *const ::windows::runtime::GUID,
        ppdestmlstr: *mut ::std::option::Option<::windows::runtime::IUnknown>,
        pldestpos: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            punkouter.into_param().abi(),
            ::std::mem::transmute(dwclscontext),
            ::std::mem::transmute(piid),
            ::std::mem::transmute(ppdestmlstr),
            ::std::mem::transmute(pldestpos),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetWStr<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        pszsrc: Param2,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    pub unsafe fn SetStrBufW<'a, Param2: ::windows::runtime::IntoParam<'a, IMLangStringBufW>>(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        psrcbuf: Param2,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            psrcbuf.into_param().abi(),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetWStr(
        &self,
        lsrcpos: i32,
        lsrclen: i32,
        pszdest: super::Foundation::PWSTR,
        cchdest: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            ::std::mem::transmute(pszdest),
            ::std::mem::transmute(cchdest),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    pub unsafe fn GetStrBufW(
        &self,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        ppdestbuf: *mut ::std::option::Option<IMLangStringBufW>,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrcmaxlen),
            ::std::mem::transmute(ppdestbuf),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LockWStr(
        &self,
        lsrcpos: i32,
        lsrclen: i32,
        lflags: i32,
        cchrequest: i32,
        ppszdest: *mut super::Foundation::PWSTR,
        pcchdest: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrclen),
            ::std::mem::transmute(lflags),
            ::std::mem::transmute(cchrequest),
            ::std::mem::transmute(ppszdest),
            ::std::mem::transmute(pcchdest),
            ::std::mem::transmute(pldestlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnlockWStr<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pszsrc: Param0,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(pcchactual),
            ::std::mem::transmute(plactuallen),
        )
        .ok()
    }
    pub unsafe fn SetLocale(
        &self,
        ldestpos: i32,
        ldestlen: i32,
        locale: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ldestpos),
            ::std::mem::transmute(ldestlen),
            ::std::mem::transmute(locale),
        )
        .ok()
    }
    pub unsafe fn GetLocale(
        &self,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        plocale: *mut u32,
        pllocalepos: *mut i32,
        pllocalelen: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lsrcpos),
            ::std::mem::transmute(lsrcmaxlen),
            ::std::mem::transmute(plocale),
            ::std::mem::transmute(pllocalepos),
            ::std::mem::transmute(pllocalelen),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMLangStringWStr {
    type Vtable = IMLangStringWStr_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3226297808,
        46861,
        4560,
        [177, 136, 0, 170, 0, 56, 201, 105],
    );
}
impl ::std::convert::From<IMLangStringWStr> for ::windows::runtime::IUnknown {
    fn from(value: IMLangStringWStr) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringWStr> for ::windows::runtime::IUnknown {
    fn from(value: &IMLangStringWStr) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IMLangStringWStr> for IMLangString {
    fn from(value: IMLangStringWStr) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMLangStringWStr> for IMLangString {
    fn from(value: &IMLangStringWStr) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangString>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMLangString> for &IMLangStringWStr {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMLangString> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMLangString>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMLangStringWStr_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fnoaccess: super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pllen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        psrcmlstr: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        punkouter: ::windows::runtime::RawPtr,
        dwclscontext: u32,
        piid: *const ::windows::runtime::GUID,
        ppdestmlstr: *mut ::windows::runtime::RawPtr,
        pldestpos: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        pszsrc: super::Foundation::PWSTR,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        psrcbuf: ::windows::runtime::RawPtr,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        pszdest: super::Foundation::PWSTR,
        cchdest: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        ppdestbuf: *mut ::windows::runtime::RawPtr,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrclen: i32,
        lflags: i32,
        cchrequest: i32,
        ppszdest: *mut super::Foundation::PWSTR,
        pcchdest: *mut i32,
        pldestlen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszsrc: super::Foundation::PWSTR,
        cchsrc: i32,
        pcchactual: *mut i32,
        plactuallen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ldestpos: i32,
        ldestlen: i32,
        locale: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lsrcpos: i32,
        lsrcmaxlen: i32,
        plocale: *mut u32,
        pllocalepos: *mut i32,
        pllocalelen: *mut i32,
    ) -> ::windows::runtime::HRESULT,
);
pub const IMMGWLP_IMC: u32 = 0u32;
pub const IMMGWL_IMC: u32 = 0u32;
pub const IMM_ERROR_GENERAL: i32 = -2i32;
pub const IMM_ERROR_NODATA: i32 = -1i32;
pub const IMN_CHANGECANDIDATE: u32 = 3u32;
pub const IMN_CLOSECANDIDATE: u32 = 4u32;
pub const IMN_CLOSESTATUSWINDOW: u32 = 1u32;
pub const IMN_GUIDELINE: u32 = 13u32;
pub const IMN_OPENCANDIDATE: u32 = 5u32;
pub const IMN_OPENSTATUSWINDOW: u32 = 2u32;
pub const IMN_PRIVATE: u32 = 14u32;
pub const IMN_SETCANDIDATEPOS: u32 = 9u32;
pub const IMN_SETCOMPOSITIONFONT: u32 = 10u32;
pub const IMN_SETCOMPOSITIONWINDOW: u32 = 11u32;
pub const IMN_SETCONVERSIONMODE: u32 = 6u32;
pub const IMN_SETOPENSTATUS: u32 = 8u32;
pub const IMN_SETSENTENCEMODE: u32 = 7u32;
pub const IMN_SETSTATUSWINDOWPOS: u32 = 12u32;
pub const IMN_SOFTKBDDESTROYED: u32 = 17u32;
pub const IMR_CANDIDATEWINDOW: u32 = 2u32;
pub const IMR_COMPOSITIONFONT: u32 = 3u32;
pub const IMR_COMPOSITIONWINDOW: u32 = 1u32;
pub const IMR_CONFIRMRECONVERTSTRING: u32 = 5u32;
pub const IMR_DOCUMENTFEED: u32 = 7u32;
pub const IMR_QUERYCHARPOSITION: u32 = 6u32;
pub const IMR_RECONVERTSTRING: u32 = 4u32;
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMultiLanguage(::windows::runtime::IUnknown);
impl IMultiLanguage {
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetCodePageInfo(
        &self,
        uicodepage: u32,
    ) -> ::windows::runtime::Result<MIMECPINFO> {
        let mut result__: <MIMECPINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            &mut result__,
        )
        .from_abi::<MIMECPINFO>(result__)
    }
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn EnumCodePages(&self, grfflags: u32) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(grfflags),
            &mut result__,
        )
        .from_abi::<IEnumCodePage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCharsetInfo<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        charset: Param0,
    ) -> ::windows::runtime::Result<MIMECSETINFO> {
        let mut result__: <MIMECSETINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            charset.into_param().abi(),
            &mut result__,
        )
        .from_abi::<MIMECSETINFO>(result__)
    }
    pub unsafe fn IsConvertible(
        &self,
        dwsrcencoding: u32,
        dwdstencoding: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
        )
        .ok()
    }
    pub unsafe fn ConvertString(
        &self,
        pdwmode: *mut u32,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
            ::std::mem::transmute(psrcstr),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringToUnicode<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringFromUnicode<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    pub unsafe fn ConvertStringReset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRfc1766FromLcid(
        &self,
        locale: u32,
    ) -> ::windows::runtime::Result<super::Foundation::BSTR> {
        let mut result__: <super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            &mut result__,
        )
        .from_abi::<super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLcidFromRfc1766<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        plocale: *mut u32,
        bstrrfc1766: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(plocale),
            bstrrfc1766.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn EnumRfc1766(&self) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IEnumRfc1766>(result__)
    }
    pub unsafe fn GetRfc1766Info(&self, locale: u32) -> ::windows::runtime::Result<RFC1766INFO> {
        let mut result__: <RFC1766INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            &mut result__,
        )
        .from_abi::<RFC1766INFO>(result__)
    }
    pub unsafe fn CreateConvertCharset(
        &self,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
    ) -> ::windows::runtime::Result<IMLangConvertCharset> {
        let mut result__: <IMLangConvertCharset as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uisrccodepage),
            ::std::mem::transmute(uidstcodepage),
            ::std::mem::transmute(dwproperty),
            &mut result__,
        )
        .from_abi::<IMLangConvertCharset>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMultiLanguage {
    type Vtable = IMultiLanguage_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        660349921,
        14151,
        4560,
        [159, 234, 0, 170, 0, 63, 134, 70],
    );
}
impl ::std::convert::From<IMultiLanguage> for ::windows::runtime::IUnknown {
    fn from(value: IMultiLanguage) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMultiLanguage> for ::windows::runtime::IUnknown {
    fn from(value: &IMultiLanguage) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMultiLanguage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMultiLanguage {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pccodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        pcodepageinfo: *mut MIMECPINFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        puifamilycodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        grfflags: u32,
        ppenumcodepage: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        charset: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
        pcharsetinfo: *mut MIMECSETINFO,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsrcencoding: u32,
        dwdstencoding: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PWSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        pbstrrfc1766: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plocale: *mut u32,
        bstrrfc1766: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenumrfc1766: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        prfc1766info: *mut RFC1766INFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
        ppmlangconvertcharset: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMultiLanguage2(::windows::runtime::IUnknown);
impl IMultiLanguage2 {
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetCodePageInfo(
        &self,
        uicodepage: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<MIMECPINFO> {
        let mut result__: <MIMECPINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<MIMECPINFO>(result__)
    }
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn EnumCodePages(
        &self,
        grfflags: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(grfflags),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<IEnumCodePage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCharsetInfo<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        charset: Param0,
    ) -> ::windows::runtime::Result<MIMECSETINFO> {
        let mut result__: <MIMECSETINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            charset.into_param().abi(),
            &mut result__,
        )
        .from_abi::<MIMECSETINFO>(result__)
    }
    pub unsafe fn IsConvertible(
        &self,
        dwsrcencoding: u32,
        dwdstencoding: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
        )
        .ok()
    }
    pub unsafe fn ConvertString(
        &self,
        pdwmode: *mut u32,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
            ::std::mem::transmute(psrcstr),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringToUnicode<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringFromUnicode<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    pub unsafe fn ConvertStringReset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRfc1766FromLcid(
        &self,
        locale: u32,
    ) -> ::windows::runtime::Result<super::Foundation::BSTR> {
        let mut result__: <super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            &mut result__,
        )
        .from_abi::<super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLcidFromRfc1766<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        plocale: *mut u32,
        bstrrfc1766: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(plocale),
            bstrrfc1766.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn EnumRfc1766(&self, langid: u16) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<IEnumRfc1766>(result__)
    }
    pub unsafe fn GetRfc1766Info(
        &self,
        locale: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<RFC1766INFO> {
        let mut result__: <RFC1766INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<RFC1766INFO>(result__)
    }
    pub unsafe fn CreateConvertCharset(
        &self,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
    ) -> ::windows::runtime::Result<IMLangConvertCharset> {
        let mut result__: <IMLangConvertCharset as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uisrccodepage),
            ::std::mem::transmute(uidstcodepage),
            ::std::mem::transmute(dwproperty),
            &mut result__,
        )
        .from_abi::<IMLangConvertCharset>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn ConvertStringInIStream<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param5: ::windows::runtime::IntoParam<'a, super::Storage::StructuredStorage::IStream>,
        Param6: ::windows::runtime::IntoParam<'a, super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pdwmode: *mut u32,
        dwflag: u32,
        lpfallback: Param2,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        pstmin: Param5,
        pstmout: Param6,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwflag),
            lpfallback.into_param().abi(),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
            pstmin.into_param().abi(),
            pstmout.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringToUnicodeEx<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: Param7,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
            ::std::mem::transmute(dwflag),
            lpfallback.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringFromUnicodeEx<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: Param7,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
            ::std::mem::transmute(dwflag),
            lpfallback.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn DetectCodepageInIStream<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        dwflag: u32,
        dwprefwincodepage: u32,
        pstmin: Param2,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflag),
            ::std::mem::transmute(dwprefwincodepage),
            pstmin.into_param().abi(),
            ::std::mem::transmute(lpencoding),
            ::std::mem::transmute(pnscores),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DetectInputCodepage<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        dwflag: u32,
        dwprefwincodepage: u32,
        psrcstr: Param2,
        pcsrcsize: *mut i32,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflag),
            ::std::mem::transmute(dwprefwincodepage),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(lpencoding),
            ::std::mem::transmute(pnscores),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePage<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        uicodepage: u32,
        hwnd: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            hwnd.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCodePageDescription(
        &self,
        uicodepage: u32,
        lcid: u32,
        lpwidecharstr: super::Foundation::PWSTR,
        cchwidechar: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(lpwidecharstr),
            ::std::mem::transmute(cchwidechar),
        )
        .ok()
    }
    pub unsafe fn IsCodePageInstallable(&self, uicodepage: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
        )
        .ok()
    }
    pub unsafe fn SetMimeDBSource(&self, dwsource: MIMECONTF) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsource),
        )
        .ok()
    }
    pub unsafe fn GetNumberOfScripts(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn EnumScripts(
        &self,
        dwflags: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<IEnumScript> {
        let mut result__: <IEnumScript as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<IEnumScript>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePageEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        uicodepage: u32,
        hwnd: Param1,
        dwfiodcontrol: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwfiodcontrol),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMultiLanguage2 {
    type Vtable = IMultiLanguage2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3704602980,
        11064,
        4562,
        [183, 236, 0, 192, 79, 143, 93, 154],
    );
}
impl ::std::convert::From<IMultiLanguage2> for ::windows::runtime::IUnknown {
    fn from(value: IMultiLanguage2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMultiLanguage2> for ::windows::runtime::IUnknown {
    fn from(value: &IMultiLanguage2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMultiLanguage2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMultiLanguage2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pccodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        langid: u16,
        pcodepageinfo: *mut MIMECPINFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        puifamilycodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        grfflags: u32,
        langid: u16,
        ppenumcodepage: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        charset: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
        pcharsetinfo: *mut MIMECSETINFO,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsrcencoding: u32,
        dwdstencoding: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PWSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        pbstrrfc1766: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plocale: *mut u32,
        bstrrfc1766: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        langid: u16,
        ppenumrfc1766: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        langid: u16,
        prfc1766info: *mut RFC1766INFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
        ppmlangconvertcharset: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwflag: u32,
        lpfallback: super::Foundation::PWSTR,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        pstmin: ::windows::runtime::RawPtr,
        pstmout: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PWSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflag: u32,
        dwprefwincodepage: u32,
        pstmin: ::windows::runtime::RawPtr,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflag: u32,
        dwprefwincodepage: u32,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut i32,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        hwnd: super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        lcid: u32,
        lpwidecharstr: super::Foundation::PWSTR,
        cchwidechar: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsource: MIMECONTF,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pnscripts: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        langid: u16,
        ppenumscript: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        hwnd: super::Foundation::HWND,
        dwfiodcontrol: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMultiLanguage3(::windows::runtime::IUnknown);
impl IMultiLanguage3 {
    pub unsafe fn GetNumberOfCodePageInfo(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetCodePageInfo(
        &self,
        uicodepage: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<MIMECPINFO> {
        let mut result__: <MIMECPINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<MIMECPINFO>(result__)
    }
    pub unsafe fn GetFamilyCodePage(&self, uicodepage: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn EnumCodePages(
        &self,
        grfflags: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<IEnumCodePage> {
        let mut result__: <IEnumCodePage as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(grfflags),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<IEnumCodePage>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCharsetInfo<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        charset: Param0,
    ) -> ::windows::runtime::Result<MIMECSETINFO> {
        let mut result__: <MIMECSETINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            charset.into_param().abi(),
            &mut result__,
        )
        .from_abi::<MIMECSETINFO>(result__)
    }
    pub unsafe fn IsConvertible(
        &self,
        dwsrcencoding: u32,
        dwdstencoding: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
        )
        .ok()
    }
    pub unsafe fn ConvertString(
        &self,
        pdwmode: *mut u32,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
            ::std::mem::transmute(psrcstr),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringToUnicode<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringFromUnicode<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
        )
        .ok()
    }
    pub unsafe fn ConvertStringReset(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRfc1766FromLcid(
        &self,
        locale: u32,
    ) -> ::windows::runtime::Result<super::Foundation::BSTR> {
        let mut result__: <super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            &mut result__,
        )
        .from_abi::<super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetLcidFromRfc1766<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BSTR>,
    >(
        &self,
        plocale: *mut u32,
        bstrrfc1766: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(plocale),
            bstrrfc1766.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn EnumRfc1766(&self, langid: u16) -> ::windows::runtime::Result<IEnumRfc1766> {
        let mut result__: <IEnumRfc1766 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<IEnumRfc1766>(result__)
    }
    pub unsafe fn GetRfc1766Info(
        &self,
        locale: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<RFC1766INFO> {
        let mut result__: <RFC1766INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(locale),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<RFC1766INFO>(result__)
    }
    pub unsafe fn CreateConvertCharset(
        &self,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
    ) -> ::windows::runtime::Result<IMLangConvertCharset> {
        let mut result__: <IMLangConvertCharset as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uisrccodepage),
            ::std::mem::transmute(uidstcodepage),
            ::std::mem::transmute(dwproperty),
            &mut result__,
        )
        .from_abi::<IMLangConvertCharset>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn ConvertStringInIStream<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param5: ::windows::runtime::IntoParam<'a, super::Storage::StructuredStorage::IStream>,
        Param6: ::windows::runtime::IntoParam<'a, super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pdwmode: *mut u32,
        dwflag: u32,
        lpfallback: Param2,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        pstmin: Param5,
        pstmout: Param6,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwflag),
            lpfallback.into_param().abi(),
            ::std::mem::transmute(dwsrcencoding),
            ::std::mem::transmute(dwdstencoding),
            pstmin.into_param().abi(),
            pstmout.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringToUnicodeEx<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
        Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: Param7,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
            ::std::mem::transmute(dwflag),
            lpfallback.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ConvertStringFromUnicodeEx<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: Param2,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: Param7,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwmode),
            ::std::mem::transmute(dwencoding),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(pdststr),
            ::std::mem::transmute(pcdstsize),
            ::std::mem::transmute(dwflag),
            lpfallback.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn DetectCodepageInIStream<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        dwflag: u32,
        dwprefwincodepage: u32,
        pstmin: Param2,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflag),
            ::std::mem::transmute(dwprefwincodepage),
            pstmin.into_param().abi(),
            ::std::mem::transmute(lpencoding),
            ::std::mem::transmute(pnscores),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DetectInputCodepage<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    >(
        &self,
        dwflag: u32,
        dwprefwincodepage: u32,
        psrcstr: Param2,
        pcsrcsize: *mut i32,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflag),
            ::std::mem::transmute(dwprefwincodepage),
            psrcstr.into_param().abi(),
            ::std::mem::transmute(pcsrcsize),
            ::std::mem::transmute(lpencoding),
            ::std::mem::transmute(pnscores),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePage<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        uicodepage: u32,
        hwnd: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            hwnd.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCodePageDescription(
        &self,
        uicodepage: u32,
        lcid: u32,
        lpwidecharstr: super::Foundation::PWSTR,
        cchwidechar: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(lpwidecharstr),
            ::std::mem::transmute(cchwidechar),
        )
        .ok()
    }
    pub unsafe fn IsCodePageInstallable(&self, uicodepage: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
        )
        .ok()
    }
    pub unsafe fn SetMimeDBSource(&self, dwsource: MIMECONTF) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwsource),
        )
        .ok()
    }
    pub unsafe fn GetNumberOfScripts(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn EnumScripts(
        &self,
        dwflags: u32,
        langid: u16,
    ) -> ::windows::runtime::Result<IEnumScript> {
        let mut result__: <IEnumScript as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(langid),
            &mut result__,
        )
        .from_abi::<IEnumScript>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ValidateCodePageEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    >(
        &self,
        uicodepage: u32,
        hwnd: Param1,
        dwfiodcontrol: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicodepage),
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwfiodcontrol),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DetectOutboundCodePage<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        dwflags: u32,
        lpwidecharstr: Param1,
        cchwidechar: u32,
        puipreferredcodepages: *const u32,
        npreferredcodepages: u32,
        puidetectedcodepages: *mut u32,
        pndetectedcodepages: *mut u32,
        lpspecialchar: Param7,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            lpwidecharstr.into_param().abi(),
            ::std::mem::transmute(cchwidechar),
            ::std::mem::transmute(puipreferredcodepages),
            ::std::mem::transmute(npreferredcodepages),
            ::std::mem::transmute(puidetectedcodepages),
            ::std::mem::transmute(pndetectedcodepages),
            lpspecialchar.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn DetectOutboundCodePageInIStream<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Storage::StructuredStorage::IStream>,
        Param6: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        dwflags: u32,
        pstrin: Param1,
        puipreferredcodepages: *const u32,
        npreferredcodepages: u32,
        puidetectedcodepages: *mut u32,
        pndetectedcodepages: *mut u32,
        lpspecialchar: Param6,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            pstrin.into_param().abi(),
            ::std::mem::transmute(puipreferredcodepages),
            ::std::mem::transmute(npreferredcodepages),
            ::std::mem::transmute(puidetectedcodepages),
            ::std::mem::transmute(pndetectedcodepages),
            lpspecialchar.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IMultiLanguage3 {
    type Vtable = IMultiLanguage3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1314416811,
        45399,
        17955,
        [154, 204, 106, 29, 156, 174, 190, 4],
    );
}
impl ::std::convert::From<IMultiLanguage3> for ::windows::runtime::IUnknown {
    fn from(value: IMultiLanguage3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMultiLanguage3> for ::windows::runtime::IUnknown {
    fn from(value: &IMultiLanguage3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IMultiLanguage3> for IMultiLanguage2 {
    fn from(value: IMultiLanguage3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMultiLanguage3> for IMultiLanguage2 {
    fn from(value: &IMultiLanguage3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMultiLanguage2> for IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMultiLanguage2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMultiLanguage2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IMultiLanguage2> for &IMultiLanguage3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IMultiLanguage2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IMultiLanguage2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultiLanguage3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pccodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        langid: u16,
        pcodepageinfo: *mut MIMECPINFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        puifamilycodepage: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        grfflags: u32,
        langid: u16,
        ppenumcodepage: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        charset: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
        pcharsetinfo: *mut MIMECSETINFO,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsrcencoding: u32,
        dwdstencoding: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        psrcstr: *const u8,
        pcsrcsize: *mut u32,
        pdststr: *mut u8,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PWSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        pbstrrfc1766: *mut ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plocale: *mut u32,
        bstrrfc1766: ::std::mem::ManuallyDrop<super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        langid: u16,
        ppenumrfc1766: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        locale: u32,
        langid: u16,
        prfc1766info: *mut RFC1766INFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uisrccodepage: u32,
        uidstcodepage: u32,
        dwproperty: u32,
        ppmlangconvertcharset: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwflag: u32,
        lpfallback: super::Foundation::PWSTR,
        dwsrcencoding: u32,
        dwdstencoding: u32,
        pstmin: ::windows::runtime::RawPtr,
        pstmout: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PWSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwmode: *mut u32,
        dwencoding: u32,
        psrcstr: super::Foundation::PWSTR,
        pcsrcsize: *mut u32,
        pdststr: super::Foundation::PSTR,
        pcdstsize: *mut u32,
        dwflag: u32,
        lpfallback: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflag: u32,
        dwprefwincodepage: u32,
        pstmin: ::windows::runtime::RawPtr,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflag: u32,
        dwprefwincodepage: u32,
        psrcstr: super::Foundation::PSTR,
        pcsrcsize: *mut i32,
        lpencoding: *mut DetectEncodingInfo,
        pnscores: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        hwnd: super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        lcid: u32,
        lpwidecharstr: super::Foundation::PWSTR,
        cchwidechar: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwsource: MIMECONTF,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pnscripts: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        langid: u16,
        ppenumscript: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicodepage: u32,
        hwnd: super::Foundation::HWND,
        dwfiodcontrol: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        lpwidecharstr: super::Foundation::PWSTR,
        cchwidechar: u32,
        puipreferredcodepages: *const u32,
        npreferredcodepages: u32,
        puidetectedcodepages: *mut u32,
        pndetectedcodepages: *mut u32,
        lpspecialchar: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        pstrin: ::windows::runtime::RawPtr,
        puipreferredcodepages: *const u32,
        npreferredcodepages: u32,
        puidetectedcodepages: *mut u32,
        pndetectedcodepages: *mut u32,
        lpspecialchar: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
);
pub const INFOMASK_APPLY_CAND: u32 = 2u32;
pub const INFOMASK_APPLY_CAND_EX: u32 = 4u32;
pub const INFOMASK_BLOCK_CAND: u32 = 262144u32;
pub const INFOMASK_HIDE_CAND: u32 = 131072u32;
pub const INFOMASK_NONE: u32 = 0u32;
pub const INFOMASK_QUERY_CAND: u32 = 1u32;
pub const INFOMASK_STRING_FIX: u32 = 65536u32;
pub const INIT_COMPFORM: u32 = 16u32;
pub const INIT_CONVERSION: u32 = 2u32;
pub const INIT_LOGFONT: u32 = 8u32;
pub const INIT_SENTENCE: u32 = 4u32;
pub const INIT_SOFTKBDPOS: u32 = 32u32;
pub const INIT_STATUSWNDPOS: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
pub struct INPUTCONTEXT {
    pub hWnd: super::Foundation::HWND,
    pub fOpen: super::Foundation::BOOL,
    pub ptStatusWndPos: super::Foundation::POINT,
    pub ptSoftKbdPos: super::Foundation::POINT,
    pub fdwConversion: u32,
    pub fdwSentence: u32,
    pub lfFont: INPUTCONTEXT_0,
    pub cfCompForm: COMPOSITIONFORM,
    pub cfCandForm: [CANDIDATEFORM; 4],
    pub hCompStr: HIMCC,
    pub hCandInfo: HIMCC,
    pub hGuideLine: HIMCC,
    pub hPrivate: HIMCC,
    pub dwNumMsgBuf: u32,
    pub hMsgBuf: HIMCC,
    pub fdwInit: u32,
    pub dwReserve: [u32; 3],
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl INPUTCONTEXT {}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::default::Default for INPUTCONTEXT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::cmp::PartialEq for INPUTCONTEXT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::cmp::Eq for INPUTCONTEXT {}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
unsafe impl ::windows::runtime::Abi for INPUTCONTEXT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
pub union INPUTCONTEXT_0 {
    pub A: super::Graphics::Gdi::LOGFONTA,
    pub W: super::Graphics::Gdi::LOGFONTW,
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl INPUTCONTEXT_0 {}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::default::Default for INPUTCONTEXT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::cmp::PartialEq for INPUTCONTEXT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
impl ::std::cmp::Eq for INPUTCONTEXT_0 {}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
unsafe impl ::windows::runtime::Abi for INPUTCONTEXT_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IOptionDescription(::windows::runtime::IUnknown);
impl IOptionDescription {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Heading(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Description(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Labels(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IOptionDescription {
    type Vtable = IOptionDescription_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1127112581,
        13775,
        17926,
        [168, 1, 111, 112, 39, 126, 29, 122],
    );
}
impl ::std::convert::From<IOptionDescription> for ::windows::runtime::IUnknown {
    fn from(value: IOptionDescription) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IOptionDescription> for ::windows::runtime::IUnknown {
    fn from(value: &IOptionDescription) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IOptionDescription {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IOptionDescription {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IOptionDescription_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
pub const IPACFG_CATEGORY: i32 = 262144i32;
pub const IPACFG_HELP: i32 = 2i32;
pub const IPACFG_LANG: i32 = 16i32;
pub const IPACFG_NONE: i32 = 0i32;
pub const IPACFG_PROPERTY: i32 = 1i32;
pub const IPACFG_TITLE: i32 = 65536i32;
pub const IPACFG_TITLEFONTFACE: i32 = 131072i32;
pub const IPACID_CHARLIST: u32 = 9u32;
pub const IPACID_EPWING: u32 = 7u32;
pub const IPACID_HANDWRITING: u32 = 2u32;
pub const IPACID_NONE: u32 = 0u32;
pub const IPACID_OCR: u32 = 8u32;
pub const IPACID_RADICALSEARCH: u32 = 4u32;
pub const IPACID_SOFTKEY: u32 = 1u32;
pub const IPACID_STROKESEARCH: u32 = 3u32;
pub const IPACID_SYMBOLSEARCH: u32 = 5u32;
pub const IPACID_USER: u32 = 256u32;
pub const IPACID_VOICE: u32 = 6u32;
pub const IPAWS_ENABLED: i32 = 1i32;
pub const IPAWS_HORIZONTALFIXED: i32 = 512i32;
pub const IPAWS_MAXHEIGHTFIXED: i32 = 8192i32;
pub const IPAWS_MAXSIZEFIXED: i32 = 12288i32;
pub const IPAWS_MAXWIDTHFIXED: i32 = 4096i32;
pub const IPAWS_MINHEIGHTFIXED: i32 = 131072i32;
pub const IPAWS_MINSIZEFIXED: i32 = 196608i32;
pub const IPAWS_MINWIDTHFIXED: i32 = 65536i32;
pub const IPAWS_SIZEFIXED: i32 = 768i32;
pub const IPAWS_SIZINGNOTIFY: i32 = 4i32;
pub const IPAWS_VERTICALFIXED: i32 = 256i32;
pub const ISC_SHOWUIALL: u32 = 3221225487u32;
pub const ISC_SHOWUIALLCANDIDATEWINDOW: u32 = 15u32;
pub const ISC_SHOWUICANDIDATEWINDOW: u32 = 1u32;
pub const ISC_SHOWUICOMPOSITIONWINDOW: u32 = 2147483648u32;
pub const ISC_SHOWUIGUIDELINE: u32 = 1073741824u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct IS_TEXT_UNICODE_RESULT(pub u32);
pub const IS_TEXT_UNICODE_ASCII16: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(1u32);
pub const IS_TEXT_UNICODE_REVERSE_ASCII16: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(16u32);
pub const IS_TEXT_UNICODE_STATISTICS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(2u32);
pub const IS_TEXT_UNICODE_REVERSE_STATISTICS: IS_TEXT_UNICODE_RESULT =
    IS_TEXT_UNICODE_RESULT(32u32);
pub const IS_TEXT_UNICODE_CONTROLS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(4u32);
pub const IS_TEXT_UNICODE_REVERSE_CONTROLS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(64u32);
pub const IS_TEXT_UNICODE_SIGNATURE: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(8u32);
pub const IS_TEXT_UNICODE_REVERSE_SIGNATURE: IS_TEXT_UNICODE_RESULT =
    IS_TEXT_UNICODE_RESULT(128u32);
pub const IS_TEXT_UNICODE_ILLEGAL_CHARS: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(256u32);
pub const IS_TEXT_UNICODE_ODD_LENGTH: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(512u32);
pub const IS_TEXT_UNICODE_NULL_BYTES: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(4096u32);
pub const IS_TEXT_UNICODE_UNICODE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(15u32);
pub const IS_TEXT_UNICODE_REVERSE_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(240u32);
pub const IS_TEXT_UNICODE_NOT_UNICODE_MASK: IS_TEXT_UNICODE_RESULT =
    IS_TEXT_UNICODE_RESULT(3840u32);
pub const IS_TEXT_UNICODE_NOT_ASCII_MASK: IS_TEXT_UNICODE_RESULT = IS_TEXT_UNICODE_RESULT(61440u32);
impl ::std::convert::From<u32> for IS_TEXT_UNICODE_RESULT {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IS_TEXT_UNICODE_RESULT {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for IS_TEXT_UNICODE_RESULT {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for IS_TEXT_UNICODE_RESULT {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for IS_TEXT_UNICODE_RESULT {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct IS_VALID_LOCALE_FLAGS(pub u32);
pub const LCID_INSTALLED: IS_VALID_LOCALE_FLAGS = IS_VALID_LOCALE_FLAGS(1u32);
pub const LCID_SUPPORTED: IS_VALID_LOCALE_FLAGS = IS_VALID_LOCALE_FLAGS(2u32);
impl ::std::convert::From<u32> for IS_VALID_LOCALE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for IS_VALID_LOCALE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for IS_VALID_LOCALE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for IS_VALID_LOCALE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for IS_VALID_LOCALE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for IS_VALID_LOCALE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for IS_VALID_LOCALE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpellCheckProvider(::windows::runtime::IUnknown);
impl ISpellCheckProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LanguageTag(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Check<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(
        &self,
        text: Param0,
    ) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Suggest<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        optionid: Param0,
    ) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            optionid.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOptionValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        optionid: Param0,
        value: u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            optionid.into_param().abi(),
            ::std::mem::transmute(value),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OptionIds(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LocalizedName(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionDescription<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        optionid: Param0,
    ) -> ::windows::runtime::Result<IOptionDescription> {
        let mut result__: <IOptionDescription as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            optionid.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IOptionDescription>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn InitializeWordlist<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::System::Com::IEnumString>,
    >(
        &self,
        wordlisttype: WORDLIST_TYPE,
        words: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(wordlisttype),
            words.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckProvider {
    type Vtable = ISpellCheckProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1944680160,
        36564,
        20145,
        [128, 215, 27, 224, 161, 107, 12, 56],
    );
}
impl ::std::convert::From<ISpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellCheckProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellCheckProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISpellCheckProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        optionid: super::Foundation::PWSTR,
        value: *mut u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        optionid: super::Foundation::PWSTR,
        value: u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        optionid: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wordlisttype: WORDLIST_TYPE,
        words: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpellCheckProviderFactory(::windows::runtime::IUnknown);
impl ISpellCheckProviderFactory {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SupportedLanguages(
        &self,
    ) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        languagetag: Param0,
    ) -> ::windows::runtime::Result<super::Foundation::BOOL> {
        let mut result__: <super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            languagetag.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateSpellCheckProvider<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        languagetag: Param0,
    ) -> ::windows::runtime::Result<ISpellCheckProvider> {
        let mut result__: <ISpellCheckProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            languagetag.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ISpellCheckProvider>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckProviderFactory {
    type Vtable = ISpellCheckProviderFactory_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2674335249,
        30678,
        19602,
        [174, 251, 97, 82, 21, 227, 164, 190],
    );
}
impl ::std::convert::From<ISpellCheckProviderFactory> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckProviderFactory) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellCheckProviderFactory> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckProviderFactory) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ISpellCheckProviderFactory
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ISpellCheckProviderFactory
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckProviderFactory_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        languagetag: super::Foundation::PWSTR,
        value: *mut super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        languagetag: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpellChecker(::windows::runtime::IUnknown);
impl ISpellChecker {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LanguageTag(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Check<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(
        &self,
        text: Param0,
    ) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Suggest<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Add<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Ignore<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AutoCorrect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        from: Param0,
        to: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            from.into_param().abi(),
            to.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        optionid: Param0,
    ) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            optionid.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OptionIds(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LocalizedName(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    pub unsafe fn SpellCheckerChanged<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ISpellCheckerChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn RemoveSpellCheckerChanged(
        &self,
        eventcookie: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventcookie),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionDescription<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        optionid: Param0,
    ) -> ::windows::runtime::Result<IOptionDescription> {
        let mut result__: <IOptionDescription as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            optionid.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IOptionDescription>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComprehensiveCheck<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        text: Param0,
    ) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IEnumSpellingError>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellChecker {
    type Vtable = ISpellChecker_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3070036849,
        58044,
        18003,
        [141, 5, 241, 151, 228, 18, 119, 11],
    );
}
impl ::std::convert::From<ISpellChecker> for ::windows::runtime::IUnknown {
    fn from(value: ISpellChecker) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellChecker> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellChecker) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellChecker {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISpellChecker {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellChecker_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        from: super::Foundation::PWSTR,
        to: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        optionid: super::Foundation::PWSTR,
        value: *mut u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        eventcookie: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventcookie: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        optionid: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpellChecker2(::windows::runtime::IUnknown);
impl ISpellChecker2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LanguageTag(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Check<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(
        &self,
        text: Param0,
    ) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn Suggest<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Add<'a, Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>>(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Ignore<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AutoCorrect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        from: Param0,
        to: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            from.into_param().abi(),
            to.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        optionid: Param0,
    ) -> ::windows::runtime::Result<u8> {
        let mut result__: <u8 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            optionid.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u8>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn OptionIds(&self) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LocalizedName(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
    pub unsafe fn SpellCheckerChanged<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ISpellCheckerChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn RemoveSpellCheckerChanged(
        &self,
        eventcookie: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventcookie),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionDescription<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        optionid: Param0,
    ) -> ::windows::runtime::Result<IOptionDescription> {
        let mut result__: <IOptionDescription as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            optionid.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IOptionDescription>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComprehensiveCheck<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        text: Param0,
    ) -> ::windows::runtime::Result<IEnumSpellingError> {
        let mut result__: <IEnumSpellingError as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IEnumSpellingError>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Remove<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        word: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            word.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpellChecker2 {
    type Vtable = ISpellChecker2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3891076209,
        34807,
        17272,
        [168, 64, 201, 32, 13, 172, 238, 71],
    );
}
impl ::std::convert::From<ISpellChecker2> for ::windows::runtime::IUnknown {
    fn from(value: ISpellChecker2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellChecker2> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellChecker2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ISpellChecker2> for ISpellChecker {
    fn from(value: ISpellChecker2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellChecker2> for ISpellChecker {
    fn from(value: &ISpellChecker2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpellChecker> for ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpellChecker> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ISpellChecker>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISpellChecker> for &ISpellChecker2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISpellChecker> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ISpellChecker>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellChecker2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        from: super::Foundation::PWSTR,
        to: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        optionid: super::Foundation::PWSTR,
        value: *mut u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        eventcookie: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventcookie: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        optionid: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        word: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpellCheckerChangedEventHandler(::windows::runtime::IUnknown);
impl ISpellCheckerChangedEventHandler {
    pub unsafe fn Invoke<'a, Param0: ::windows::runtime::IntoParam<'a, ISpellChecker>>(
        &self,
        sender: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            sender.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckerChangedEventHandler {
    type Vtable = ISpellCheckerChangedEventHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        193177008,
        31023,
        20139,
        [151, 153, 172, 245, 44, 94, 208, 138],
    );
}
impl ::std::convert::From<ISpellCheckerChangedEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckerChangedEventHandler) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellCheckerChangedEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckerChangedEventHandler) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ISpellCheckerChangedEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ISpellCheckerChangedEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckerChangedEventHandler_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        sender: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpellCheckerFactory(::windows::runtime::IUnknown);
impl ISpellCheckerFactory {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn SupportedLanguages(
        &self,
    ) -> ::windows::runtime::Result<super::System::Com::IEnumString> {
        let mut result__: <super::System::Com::IEnumString as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::System::Com::IEnumString>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        languagetag: Param0,
    ) -> ::windows::runtime::Result<super::Foundation::BOOL> {
        let mut result__: <super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            languagetag.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateSpellChecker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        languagetag: Param0,
    ) -> ::windows::runtime::Result<ISpellChecker> {
        let mut result__: <ISpellChecker as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            languagetag.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ISpellChecker>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellCheckerFactory {
    type Vtable = ISpellCheckerFactory_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2382465693,
        9237,
        18039,
        [191, 8, 121, 78, 166, 31, 148, 187],
    );
}
impl ::std::convert::From<ISpellCheckerFactory> for ::windows::runtime::IUnknown {
    fn from(value: ISpellCheckerFactory) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellCheckerFactory> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellCheckerFactory) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellCheckerFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISpellCheckerFactory {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellCheckerFactory_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        languagetag: super::Foundation::PWSTR,
        value: *mut super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        languagetag: super::Foundation::PWSTR,
        value: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpellingError(::windows::runtime::IUnknown);
impl ISpellingError {
    pub unsafe fn StartIndex(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn Length(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CorrectiveAction(&self) -> ::windows::runtime::Result<CORRECTIVE_ACTION> {
        let mut result__: <CORRECTIVE_ACTION as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<CORRECTIVE_ACTION>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Replacement(&self) -> ::windows::runtime::Result<super::Foundation::PWSTR> {
        let mut result__: <super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::Foundation::PWSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpellingError {
    type Vtable = ISpellingError_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3083349345,
        64488,
        19271,
        [155, 39, 108, 13, 46, 13, 224, 163],
    );
}
impl ::std::convert::From<ISpellingError> for ::windows::runtime::IUnknown {
    fn from(value: ISpellingError) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpellingError> for ::windows::runtime::IUnknown {
    fn from(value: &ISpellingError) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISpellingError {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpellingError_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut CORRECTIVE_ACTION,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUserDictionariesRegistrar(::windows::runtime::IUnknown);
impl IUserDictionariesRegistrar {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterUserDictionary<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        dictionarypath: Param0,
        languagetag: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            dictionarypath.into_param().abi(),
            languagetag.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnregisterUserDictionary<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    >(
        &self,
        dictionarypath: Param0,
        languagetag: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            dictionarypath.into_param().abi(),
            languagetag.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUserDictionariesRegistrar {
    type Vtable = IUserDictionariesRegistrar_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2853661573,
        3602,
        18500,
        [142, 26, 238, 241, 218, 119, 245, 134],
    );
}
impl ::std::convert::From<IUserDictionariesRegistrar> for ::windows::runtime::IUnknown {
    fn from(value: IUserDictionariesRegistrar) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUserDictionariesRegistrar> for ::windows::runtime::IUnknown {
    fn from(value: &IUserDictionariesRegistrar) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUserDictionariesRegistrar
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUserDictionariesRegistrar
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUserDictionariesRegistrar_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dictionarypath: super::Foundation::PWSTR,
        languagetag: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dictionarypath: super::Foundation::PWSTR,
        languagetag: super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IdnToAscii<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    lpunicodecharstr: Param1,
    cchunicodechar: i32,
    lpasciicharstr: super::Foundation::PWSTR,
    cchasciichar: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IdnToAscii(
                dwflags: u32,
                lpunicodecharstr: super::Foundation::PWSTR,
                cchunicodechar: i32,
                lpasciicharstr: super::Foundation::PWSTR,
                cchasciichar: i32,
            ) -> i32;
        }
        ::std::mem::transmute(IdnToAscii(
            ::std::mem::transmute(dwflags),
            lpunicodecharstr.into_param().abi(),
            ::std::mem::transmute(cchunicodechar),
            ::std::mem::transmute(lpasciicharstr),
            ::std::mem::transmute(cchasciichar),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IdnToNameprepUnicode<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    lpunicodecharstr: Param1,
    cchunicodechar: i32,
    lpnameprepcharstr: super::Foundation::PWSTR,
    cchnameprepchar: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IdnToNameprepUnicode(
                dwflags: u32,
                lpunicodecharstr: super::Foundation::PWSTR,
                cchunicodechar: i32,
                lpnameprepcharstr: super::Foundation::PWSTR,
                cchnameprepchar: i32,
            ) -> i32;
        }
        ::std::mem::transmute(IdnToNameprepUnicode(
            ::std::mem::transmute(dwflags),
            lpunicodecharstr.into_param().abi(),
            ::std::mem::transmute(cchunicodechar),
            ::std::mem::transmute(lpnameprepcharstr),
            ::std::mem::transmute(cchnameprepchar),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IdnToUnicode<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    lpasciicharstr: Param1,
    cchasciichar: i32,
    lpunicodecharstr: super::Foundation::PWSTR,
    cchunicodechar: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IdnToUnicode(
                dwflags: u32,
                lpasciicharstr: super::Foundation::PWSTR,
                cchasciichar: i32,
                lpunicodecharstr: super::Foundation::PWSTR,
                cchunicodechar: i32,
            ) -> i32;
        }
        ::std::mem::transmute(IdnToUnicode(
            ::std::mem::transmute(dwflags),
            lpasciicharstr.into_param().abi(),
            ::std::mem::transmute(cchasciichar),
            ::std::mem::transmute(lpunicodecharstr),
            ::std::mem::transmute(cchunicodechar),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmAssociateContext<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, HIMC>,
>(
    param0: Param0,
    param1: Param1,
) -> HIMC {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmAssociateContext(param0: super::Foundation::HWND, param1: HIMC) -> HIMC;
        }
        ::std::mem::transmute(ImmAssociateContext(
            param0.into_param().abi(),
            param1.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmAssociateContextEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, HIMC>,
>(
    param0: Param0,
    param1: Param1,
    param2: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmAssociateContextEx(
                param0: super::Foundation::HWND,
                param1: HIMC,
                param2: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmAssociateContextEx(
            param0.into_param().abi(),
            param1.into_param().abi(),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmConfigureIMEA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
    param1: Param1,
    param2: u32,
    param3: *mut ::std::ffi::c_void,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmConfigureIMEA(
                param0: super::UI::TextServices::HKL,
                param1: super::Foundation::HWND,
                param2: u32,
                param3: *mut ::std::ffi::c_void,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmConfigureIMEA(
            param0.into_param().abi(),
            param1.into_param().abi(),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(param3),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmConfigureIMEW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
    param1: Param1,
    param2: u32,
    param3: *mut ::std::ffi::c_void,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmConfigureIMEW(
                param0: super::UI::TextServices::HKL,
                param1: super::Foundation::HWND,
                param2: u32,
                param3: *mut ::std::ffi::c_void,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmConfigureIMEW(
            param0.into_param().abi(),
            param1.into_param().abi(),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(param3),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmCreateContext() -> HIMC {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmCreateContext() -> HIMC;
        }
        ::std::mem::transmute(ImmCreateContext())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmCreateIMCC(param0: u32) -> HIMCC {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmCreateIMCC(param0: u32) -> HIMCC;
        }
        ::std::mem::transmute(ImmCreateIMCC(::std::mem::transmute(param0)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmCreateSoftKeyboard<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: u32,
    param1: Param1,
    param2: i32,
    param3: i32,
) -> super::Foundation::HWND {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmCreateSoftKeyboard(
                param0: u32,
                param1: super::Foundation::HWND,
                param2: i32,
                param3: i32,
            ) -> super::Foundation::HWND;
        }
        ::std::mem::transmute(ImmCreateSoftKeyboard(
            ::std::mem::transmute(param0),
            param1.into_param().abi(),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(param3),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmDestroyContext<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmDestroyContext(param0: HIMC) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmDestroyContext(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmDestroyIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
    param0: Param0,
) -> HIMCC {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmDestroyIMCC(param0: HIMCC) -> HIMCC;
        }
        ::std::mem::transmute(ImmDestroyIMCC(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmDestroySoftKeyboard<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmDestroySoftKeyboard(param0: super::Foundation::HWND) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmDestroySoftKeyboard(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmDisableIME(param0: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmDisableIME(param0: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmDisableIME(::std::mem::transmute(param0)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmDisableLegacyIME() -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmDisableLegacyIME() -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmDisableLegacyIME())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmDisableTextFrameService(idthread: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmDisableTextFrameService(idthread: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmDisableTextFrameService(::std::mem::transmute(idthread)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmEnumInputContext<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    idthread: u32,
    lpfn: ::std::option::Option<IMCENUMPROC>,
    lparam: Param2,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmEnumInputContext(
                idthread: u32,
                lpfn: ::windows::runtime::RawPtr,
                lparam: super::Foundation::LPARAM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmEnumInputContext(
            ::std::mem::transmute(idthread),
            ::std::mem::transmute(lpfn),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmEnumRegisterWordA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    param0: Param0,
    param1: ::std::option::Option<REGISTERWORDENUMPROCA>,
    lpszreading: Param2,
    param3: u32,
    lpszregister: Param4,
    param5: *mut ::std::ffi::c_void,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmEnumRegisterWordA(
                param0: super::UI::TextServices::HKL,
                param1: ::windows::runtime::RawPtr,
                lpszreading: super::Foundation::PSTR,
                param3: u32,
                lpszregister: super::Foundation::PSTR,
                param5: *mut ::std::ffi::c_void,
            ) -> u32;
        }
        ::std::mem::transmute(ImmEnumRegisterWordA(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            lpszreading.into_param().abi(),
            ::std::mem::transmute(param3),
            lpszregister.into_param().abi(),
            ::std::mem::transmute(param5),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmEnumRegisterWordW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    param0: Param0,
    param1: ::std::option::Option<REGISTERWORDENUMPROCW>,
    lpszreading: Param2,
    param3: u32,
    lpszregister: Param4,
    param5: *mut ::std::ffi::c_void,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmEnumRegisterWordW(
                param0: super::UI::TextServices::HKL,
                param1: ::windows::runtime::RawPtr,
                lpszreading: super::Foundation::PWSTR,
                param3: u32,
                lpszregister: super::Foundation::PWSTR,
                param5: *mut ::std::ffi::c_void,
            ) -> u32;
        }
        ::std::mem::transmute(ImmEnumRegisterWordW(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            lpszreading.into_param().abi(),
            ::std::mem::transmute(param3),
            lpszregister.into_param().abi(),
            ::std::mem::transmute(param5),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmEscapeA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, HIMC>,
>(
    param0: Param0,
    param1: Param1,
    param2: u32,
    param3: *mut ::std::ffi::c_void,
) -> super::Foundation::LRESULT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmEscapeA(
                param0: super::UI::TextServices::HKL,
                param1: HIMC,
                param2: u32,
                param3: *mut ::std::ffi::c_void,
            ) -> super::Foundation::LRESULT;
        }
        ::std::mem::transmute(ImmEscapeA(
            param0.into_param().abi(),
            param1.into_param().abi(),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(param3),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmEscapeW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, HIMC>,
>(
    param0: Param0,
    param1: Param1,
    param2: u32,
    param3: *mut ::std::ffi::c_void,
) -> super::Foundation::LRESULT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmEscapeW(
                param0: super::UI::TextServices::HKL,
                param1: HIMC,
                param2: u32,
                param3: *mut ::std::ffi::c_void,
            ) -> super::Foundation::LRESULT;
        }
        ::std::mem::transmute(ImmEscapeW(
            param0.into_param().abi(),
            param1.into_param().abi(),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(param3),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGenerateMessage<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGenerateMessage(param0: HIMC) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGenerateMessage(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetCandidateListA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    deindex: u32,
    lpcandlist: *mut CANDIDATELIST,
    dwbuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCandidateListA(
                param0: HIMC,
                deindex: u32,
                lpcandlist: *mut CANDIDATELIST,
                dwbuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetCandidateListA(
            param0.into_param().abi(),
            ::std::mem::transmute(deindex),
            ::std::mem::transmute(lpcandlist),
            ::std::mem::transmute(dwbuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetCandidateListCountA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpdwlistcount: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCandidateListCountA(param0: HIMC, lpdwlistcount: *mut u32) -> u32;
        }
        ::std::mem::transmute(ImmGetCandidateListCountA(
            param0.into_param().abi(),
            ::std::mem::transmute(lpdwlistcount),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetCandidateListCountW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpdwlistcount: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCandidateListCountW(param0: HIMC, lpdwlistcount: *mut u32) -> u32;
        }
        ::std::mem::transmute(ImmGetCandidateListCountW(
            param0.into_param().abi(),
            ::std::mem::transmute(lpdwlistcount),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetCandidateListW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    deindex: u32,
    lpcandlist: *mut CANDIDATELIST,
    dwbuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCandidateListW(
                param0: HIMC,
                deindex: u32,
                lpcandlist: *mut CANDIDATELIST,
                dwbuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetCandidateListW(
            param0.into_param().abi(),
            ::std::mem::transmute(deindex),
            ::std::mem::transmute(lpcandlist),
            ::std::mem::transmute(dwbuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetCandidateWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    param1: u32,
    lpcandidate: *mut CANDIDATEFORM,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCandidateWindow(
                param0: HIMC,
                param1: u32,
                lpcandidate: *mut CANDIDATEFORM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetCandidateWindow(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(lpcandidate),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn ImmGetCompositionFontA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lplf: *mut super::Graphics::Gdi::LOGFONTA,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCompositionFontA(
                param0: HIMC,
                lplf: *mut super::Graphics::Gdi::LOGFONTA,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetCompositionFontA(
            param0.into_param().abi(),
            ::std::mem::transmute(lplf),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ImmGetCompositionFontW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lplf: *mut super::Graphics::Gdi::LOGFONTW,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCompositionFontW(
                param0: HIMC,
                lplf: *mut super::Graphics::Gdi::LOGFONTW,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetCompositionFontW(
            param0.into_param().abi(),
            ::std::mem::transmute(lplf),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetCompositionStringA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    param1: u32,
    lpbuf: *mut ::std::ffi::c_void,
    dwbuflen: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCompositionStringA(
                param0: HIMC,
                param1: u32,
                lpbuf: *mut ::std::ffi::c_void,
                dwbuflen: u32,
            ) -> i32;
        }
        ::std::mem::transmute(ImmGetCompositionStringA(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(lpbuf),
            ::std::mem::transmute(dwbuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetCompositionStringW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    param1: u32,
    lpbuf: *mut ::std::ffi::c_void,
    dwbuflen: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCompositionStringW(
                param0: HIMC,
                param1: u32,
                lpbuf: *mut ::std::ffi::c_void,
                dwbuflen: u32,
            ) -> i32;
        }
        ::std::mem::transmute(ImmGetCompositionStringW(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(lpbuf),
            ::std::mem::transmute(dwbuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetCompositionWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpcompform: *mut COMPOSITIONFORM,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetCompositionWindow(
                param0: HIMC,
                lpcompform: *mut COMPOSITIONFORM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetCompositionWindow(
            param0.into_param().abi(),
            ::std::mem::transmute(lpcompform),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetContext<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
) -> HIMC {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetContext(param0: super::Foundation::HWND) -> HIMC;
        }
        ::std::mem::transmute(ImmGetContext(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmGetConversionListA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    param0: Param0,
    param1: Param1,
    lpsrc: Param2,
    lpdst: *mut CANDIDATELIST,
    dwbuflen: u32,
    uflag: GET_CONVERSION_LIST_FLAG,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetConversionListA(
                param0: super::UI::TextServices::HKL,
                param1: HIMC,
                lpsrc: super::Foundation::PSTR,
                lpdst: *mut CANDIDATELIST,
                dwbuflen: u32,
                uflag: GET_CONVERSION_LIST_FLAG,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetConversionListA(
            param0.into_param().abi(),
            param1.into_param().abi(),
            lpsrc.into_param().abi(),
            ::std::mem::transmute(lpdst),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(uflag),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmGetConversionListW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, HIMC>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    param0: Param0,
    param1: Param1,
    lpsrc: Param2,
    lpdst: *mut CANDIDATELIST,
    dwbuflen: u32,
    uflag: GET_CONVERSION_LIST_FLAG,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetConversionListW(
                param0: super::UI::TextServices::HKL,
                param1: HIMC,
                lpsrc: super::Foundation::PWSTR,
                lpdst: *mut CANDIDATELIST,
                dwbuflen: u32,
                uflag: GET_CONVERSION_LIST_FLAG,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetConversionListW(
            param0.into_param().abi(),
            param1.into_param().abi(),
            lpsrc.into_param().abi(),
            ::std::mem::transmute(lpdst),
            ::std::mem::transmute(dwbuflen),
            ::std::mem::transmute(uflag),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetConversionStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpfdwconversion: *mut u32,
    lpfdwsentence: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetConversionStatus(
                param0: HIMC,
                lpfdwconversion: *mut u32,
                lpfdwsentence: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetConversionStatus(
            param0.into_param().abi(),
            ::std::mem::transmute(lpfdwconversion),
            ::std::mem::transmute(lpfdwsentence),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetDefaultIMEWnd<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
) -> super::Foundation::HWND {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetDefaultIMEWnd(param0: super::Foundation::HWND) -> super::Foundation::HWND;
        }
        ::std::mem::transmute(ImmGetDefaultIMEWnd(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmGetDescriptionA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
    lpszdescription: super::Foundation::PSTR,
    ubuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetDescriptionA(
                param0: super::UI::TextServices::HKL,
                lpszdescription: super::Foundation::PSTR,
                ubuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetDescriptionA(
            param0.into_param().abi(),
            ::std::mem::transmute(lpszdescription),
            ::std::mem::transmute(ubuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmGetDescriptionW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
    lpszdescription: super::Foundation::PWSTR,
    ubuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetDescriptionW(
                param0: super::UI::TextServices::HKL,
                lpszdescription: super::Foundation::PWSTR,
                ubuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetDescriptionW(
            param0.into_param().abi(),
            ::std::mem::transmute(lpszdescription),
            ::std::mem::transmute(ubuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetGuideLineA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    dwindex: GET_GUIDE_LINE_TYPE,
    lpbuf: super::Foundation::PSTR,
    dwbuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetGuideLineA(
                param0: HIMC,
                dwindex: GET_GUIDE_LINE_TYPE,
                lpbuf: super::Foundation::PSTR,
                dwbuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetGuideLineA(
            param0.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(lpbuf),
            ::std::mem::transmute(dwbuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetGuideLineW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    dwindex: GET_GUIDE_LINE_TYPE,
    lpbuf: super::Foundation::PWSTR,
    dwbuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetGuideLineW(
                param0: HIMC,
                dwindex: GET_GUIDE_LINE_TYPE,
                lpbuf: super::Foundation::PWSTR,
                dwbuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetGuideLineW(
            param0.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(lpbuf),
            ::std::mem::transmute(dwbuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetHotKey(
    param0: u32,
    lpumodifiers: *mut u32,
    lpuvkey: *mut u32,
    phkl: *mut isize,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetHotKey(
                param0: u32,
                lpumodifiers: *mut u32,
                lpuvkey: *mut u32,
                phkl: *mut isize,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetHotKey(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(lpumodifiers),
            ::std::mem::transmute(lpuvkey),
            ::std::mem::transmute(phkl),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetIMCCLockCount<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
    param0: Param0,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetIMCCLockCount(param0: HIMCC) -> u32;
        }
        ::std::mem::transmute(ImmGetIMCCLockCount(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetIMCCSize<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
    param0: Param0,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetIMCCSize(param0: HIMCC) -> u32;
        }
        ::std::mem::transmute(ImmGetIMCCSize(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmGetIMCLockCount<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetIMCLockCount(param0: HIMC) -> u32;
        }
        ::std::mem::transmute(ImmGetIMCLockCount(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmGetIMEFileNameA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
    lpszfilename: super::Foundation::PSTR,
    ubuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetIMEFileNameA(
                param0: super::UI::TextServices::HKL,
                lpszfilename: super::Foundation::PSTR,
                ubuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetIMEFileNameA(
            param0.into_param().abi(),
            ::std::mem::transmute(lpszfilename),
            ::std::mem::transmute(ubuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmGetIMEFileNameW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
    lpszfilename: super::Foundation::PWSTR,
    ubuflen: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetIMEFileNameW(
                param0: super::UI::TextServices::HKL,
                lpszfilename: super::Foundation::PWSTR,
                ubuflen: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetIMEFileNameW(
            param0.into_param().abi(),
            ::std::mem::transmute(lpszfilename),
            ::std::mem::transmute(ubuflen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn ImmGetImeMenuItemsA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    param1: u32,
    param2: u32,
    lpimeparentmenu: *mut IMEMENUITEMINFOA,
    lpimemenu: *mut IMEMENUITEMINFOA,
    dwsize: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetImeMenuItemsA(
                param0: HIMC,
                param1: u32,
                param2: u32,
                lpimeparentmenu: *mut IMEMENUITEMINFOA,
                lpimemenu: *mut IMEMENUITEMINFOA,
                dwsize: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetImeMenuItemsA(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(lpimeparentmenu),
            ::std::mem::transmute(lpimemenu),
            ::std::mem::transmute(dwsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ImmGetImeMenuItemsW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    param1: u32,
    param2: u32,
    lpimeparentmenu: *mut IMEMENUITEMINFOW,
    lpimemenu: *mut IMEMENUITEMINFOW,
    dwsize: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetImeMenuItemsW(
                param0: HIMC,
                param1: u32,
                param2: u32,
                lpimeparentmenu: *mut IMEMENUITEMINFOW,
                lpimemenu: *mut IMEMENUITEMINFOW,
                dwsize: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetImeMenuItemsW(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(lpimeparentmenu),
            ::std::mem::transmute(lpimemenu),
            ::std::mem::transmute(dwsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetOpenStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetOpenStatus(param0: HIMC) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetOpenStatus(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_UI_TextServices")]
pub unsafe fn ImmGetProperty<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
    param1: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetProperty(param0: super::UI::TextServices::HKL, param1: u32) -> u32;
        }
        ::std::mem::transmute(ImmGetProperty(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_System_SystemServices",
    feature = "Win32_UI_TextServices"
))]
pub unsafe fn ImmGetRegisterWordStyleA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
    nitem: u32,
    lpstylebuf: *mut STYLEBUFA,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetRegisterWordStyleA(
                param0: super::UI::TextServices::HKL,
                nitem: u32,
                lpstylebuf: *mut STYLEBUFA,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetRegisterWordStyleA(
            param0.into_param().abi(),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(lpstylebuf),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_UI_TextServices")]
pub unsafe fn ImmGetRegisterWordStyleW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
    nitem: u32,
    lpstylebuf: *mut STYLEBUFW,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetRegisterWordStyleW(
                param0: super::UI::TextServices::HKL,
                nitem: u32,
                lpstylebuf: *mut STYLEBUFW,
            ) -> u32;
        }
        ::std::mem::transmute(ImmGetRegisterWordStyleW(
            param0.into_param().abi(),
            ::std::mem::transmute(nitem),
            ::std::mem::transmute(lpstylebuf),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetStatusWindowPos<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpptpos: *mut super::Foundation::POINT,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetStatusWindowPos(
                param0: HIMC,
                lpptpos: *mut super::Foundation::POINT,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmGetStatusWindowPos(
            param0.into_param().abi(),
            ::std::mem::transmute(lpptpos),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmGetVirtualKey<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmGetVirtualKey(param0: super::Foundation::HWND) -> u32;
        }
        ::std::mem::transmute(ImmGetVirtualKey(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmInstallIMEA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    lpszimefilename: Param0,
    lpszlayouttext: Param1,
) -> super::UI::TextServices::HKL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmInstallIMEA(
                lpszimefilename: super::Foundation::PSTR,
                lpszlayouttext: super::Foundation::PSTR,
            ) -> super::UI::TextServices::HKL;
        }
        ::std::mem::transmute(ImmInstallIMEA(
            lpszimefilename.into_param().abi(),
            lpszlayouttext.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmInstallIMEW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lpszimefilename: Param0,
    lpszlayouttext: Param1,
) -> super::UI::TextServices::HKL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmInstallIMEW(
                lpszimefilename: super::Foundation::PWSTR,
                lpszlayouttext: super::Foundation::PWSTR,
            ) -> super::UI::TextServices::HKL;
        }
        ::std::mem::transmute(ImmInstallIMEW(
            lpszimefilename.into_param().abi(),
            lpszlayouttext.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmIsIME<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmIsIME(param0: super::UI::TextServices::HKL) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmIsIME(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmIsUIMessageA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    param0: Param0,
    param1: u32,
    param2: Param2,
    param3: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmIsUIMessageA(
                param0: super::Foundation::HWND,
                param1: u32,
                param2: super::Foundation::WPARAM,
                param3: super::Foundation::LPARAM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmIsUIMessageA(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            param2.into_param().abi(),
            param3.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmIsUIMessageW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    param0: Param0,
    param1: u32,
    param2: Param2,
    param3: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmIsUIMessageW(
                param0: super::Foundation::HWND,
                param1: u32,
                param2: super::Foundation::WPARAM,
                param3: super::Foundation::LPARAM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmIsUIMessageW(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            param2.into_param().abi(),
            param3.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn ImmLockIMC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
) -> *mut INPUTCONTEXT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmLockIMC(param0: HIMC) -> *mut INPUTCONTEXT;
        }
        ::std::mem::transmute(ImmLockIMC(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmLockIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
    param0: Param0,
) -> *mut ::std::ffi::c_void {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmLockIMCC(param0: HIMCC) -> *mut ::std::ffi::c_void;
        }
        ::std::mem::transmute(ImmLockIMCC(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmNotifyIME<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    dwaction: NOTIFY_IME_ACTION,
    dwindex: NOTIFY_IME_INDEX,
    dwvalue: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmNotifyIME(
                param0: HIMC,
                dwaction: NOTIFY_IME_ACTION,
                dwindex: NOTIFY_IME_INDEX,
                dwvalue: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmNotifyIME(
            param0.into_param().abi(),
            ::std::mem::transmute(dwaction),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(dwvalue),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ImmReSizeIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
    param0: Param0,
    param1: u32,
) -> HIMCC {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmReSizeIMCC(param0: HIMCC, param1: u32) -> HIMCC;
        }
        ::std::mem::transmute(ImmReSizeIMCC(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmRegisterWordA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    param0: Param0,
    lpszreading: Param1,
    param2: u32,
    lpszregister: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmRegisterWordA(
                param0: super::UI::TextServices::HKL,
                lpszreading: super::Foundation::PSTR,
                param2: u32,
                lpszregister: super::Foundation::PSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmRegisterWordA(
            param0.into_param().abi(),
            lpszreading.into_param().abi(),
            ::std::mem::transmute(param2),
            lpszregister.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmRegisterWordW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    param0: Param0,
    lpszreading: Param1,
    param2: u32,
    lpszregister: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmRegisterWordW(
                param0: super::UI::TextServices::HKL,
                lpszreading: super::Foundation::PWSTR,
                param2: u32,
                lpszregister: super::Foundation::PWSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmRegisterWordW(
            param0.into_param().abi(),
            lpszreading.into_param().abi(),
            ::std::mem::transmute(param2),
            lpszregister.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmReleaseContext<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, HIMC>,
>(
    param0: Param0,
    param1: Param1,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmReleaseContext(
                param0: super::Foundation::HWND,
                param1: HIMC,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmReleaseContext(
            param0.into_param().abi(),
            param1.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmRequestMessageA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HIMC>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    param0: Param0,
    param1: Param1,
    param2: Param2,
) -> super::Foundation::LRESULT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmRequestMessageA(
                param0: HIMC,
                param1: super::Foundation::WPARAM,
                param2: super::Foundation::LPARAM,
            ) -> super::Foundation::LRESULT;
        }
        ::std::mem::transmute(ImmRequestMessageA(
            param0.into_param().abi(),
            param1.into_param().abi(),
            param2.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmRequestMessageW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HIMC>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::WPARAM>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    param0: Param0,
    param1: Param1,
    param2: Param2,
) -> super::Foundation::LRESULT {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmRequestMessageW(
                param0: HIMC,
                param1: super::Foundation::WPARAM,
                param2: super::Foundation::LPARAM,
            ) -> super::Foundation::LRESULT;
        }
        ::std::mem::transmute(ImmRequestMessageW(
            param0.into_param().abi(),
            param1.into_param().abi(),
            param2.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSetCandidateWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpcandidate: *const CANDIDATEFORM,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetCandidateWindow(
                param0: HIMC,
                lpcandidate: *const CANDIDATEFORM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetCandidateWindow(
            param0.into_param().abi(),
            ::std::mem::transmute(lpcandidate),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_Graphics_Gdi",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn ImmSetCompositionFontA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lplf: *const super::Graphics::Gdi::LOGFONTA,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetCompositionFontA(
                param0: HIMC,
                lplf: *const super::Graphics::Gdi::LOGFONTA,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetCompositionFontA(
            param0.into_param().abi(),
            ::std::mem::transmute(lplf),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ImmSetCompositionFontW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lplf: *const super::Graphics::Gdi::LOGFONTW,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetCompositionFontW(
                param0: HIMC,
                lplf: *const super::Graphics::Gdi::LOGFONTW,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetCompositionFontW(
            param0.into_param().abi(),
            ::std::mem::transmute(lplf),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSetCompositionStringA<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    dwindex: SET_COMPOSITION_STRING_TYPE,
    lpcomp: *const ::std::ffi::c_void,
    dwcomplen: u32,
    lpread: *const ::std::ffi::c_void,
    dwreadlen: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetCompositionStringA(
                param0: HIMC,
                dwindex: SET_COMPOSITION_STRING_TYPE,
                lpcomp: *const ::std::ffi::c_void,
                dwcomplen: u32,
                lpread: *const ::std::ffi::c_void,
                dwreadlen: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetCompositionStringA(
            param0.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(lpcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(lpread),
            ::std::mem::transmute(dwreadlen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSetCompositionStringW<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    dwindex: SET_COMPOSITION_STRING_TYPE,
    lpcomp: *const ::std::ffi::c_void,
    dwcomplen: u32,
    lpread: *const ::std::ffi::c_void,
    dwreadlen: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetCompositionStringW(
                param0: HIMC,
                dwindex: SET_COMPOSITION_STRING_TYPE,
                lpcomp: *const ::std::ffi::c_void,
                dwcomplen: u32,
                lpread: *const ::std::ffi::c_void,
                dwreadlen: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetCompositionStringW(
            param0.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(lpcomp),
            ::std::mem::transmute(dwcomplen),
            ::std::mem::transmute(lpread),
            ::std::mem::transmute(dwreadlen),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSetCompositionWindow<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpcompform: *const COMPOSITIONFORM,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetCompositionWindow(
                param0: HIMC,
                lpcompform: *const COMPOSITIONFORM,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetCompositionWindow(
            param0.into_param().abi(),
            ::std::mem::transmute(lpcompform),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSetConversionStatus<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    param1: u32,
    param2: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetConversionStatus(
                param0: HIMC,
                param1: u32,
                param2: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetConversionStatus(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmSetHotKey<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
>(
    param0: u32,
    param1: u32,
    param2: u32,
    param3: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetHotKey(
                param0: u32,
                param1: u32,
                param2: u32,
                param3: super::UI::TextServices::HKL,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetHotKey(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
            param3.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSetOpenStatus<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HIMC>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
>(
    param0: Param0,
    param1: Param1,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetOpenStatus(
                param0: HIMC,
                param1: super::Foundation::BOOL,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetOpenStatus(
            param0.into_param().abi(),
            param1.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSetStatusWindowPos<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
    lpptpos: *const super::Foundation::POINT,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSetStatusWindowPos(
                param0: HIMC,
                lpptpos: *const super::Foundation::POINT,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSetStatusWindowPos(
            param0.into_param().abi(),
            ::std::mem::transmute(lpptpos),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmShowSoftKeyboard<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
    param1: i32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmShowSoftKeyboard(
                param0: super::Foundation::HWND,
                param1: i32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmShowSoftKeyboard(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmSimulateHotKey<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::HWND>,
>(
    param0: Param0,
    param1: u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmSimulateHotKey(
                param0: super::Foundation::HWND,
                param1: u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmSimulateHotKey(
            param0.into_param().abi(),
            ::std::mem::transmute(param1),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmUnlockIMC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMC>>(
    param0: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmUnlockIMC(param0: HIMC) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmUnlockIMC(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ImmUnlockIMCC<'a, Param0: ::windows::runtime::IntoParam<'a, HIMCC>>(
    param0: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmUnlockIMCC(param0: HIMCC) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmUnlockIMCC(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmUnregisterWordA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    param0: Param0,
    lpszreading: Param1,
    param2: u32,
    lpszunregister: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmUnregisterWordA(
                param0: super::UI::TextServices::HKL,
                lpszreading: super::Foundation::PSTR,
                param2: u32,
                lpszunregister: super::Foundation::PSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmUnregisterWordA(
            param0.into_param().abi(),
            lpszreading.into_param().abi(),
            ::std::mem::transmute(param2),
            lpszunregister.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_TextServices"))]
pub unsafe fn ImmUnregisterWordW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::UI::TextServices::HKL>,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    param0: Param0,
    lpszreading: Param1,
    param2: u32,
    lpszunregister: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ImmUnregisterWordW(
                param0: super::UI::TextServices::HKL,
                lpszreading: super::Foundation::PWSTR,
                param2: u32,
                lpszunregister: super::Foundation::PWSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(ImmUnregisterWordW(
            param0.into_param().abi(),
            lpszreading.into_param().abi(),
            ::std::mem::transmute(param2),
            lpszunregister.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsDBCSLeadByte(testchar: u8) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsDBCSLeadByte(testchar: u8) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsDBCSLeadByte(::std::mem::transmute(testchar)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsDBCSLeadByteEx(codepage: u32, testchar: u8) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsDBCSLeadByteEx(codepage: u32, testchar: u8) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsDBCSLeadByteEx(
            ::std::mem::transmute(codepage),
            ::std::mem::transmute(testchar),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsNLSDefinedString<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    function: u32,
    dwflags: u32,
    lpversioninformation: *const NLSVERSIONINFO,
    lpstring: Param3,
    cchstr: i32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsNLSDefinedString(
                function: u32,
                dwflags: u32,
                lpversioninformation: *const NLSVERSIONINFO,
                lpstring: super::Foundation::PWSTR,
                cchstr: i32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsNLSDefinedString(
            ::std::mem::transmute(function),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(lpversioninformation),
            lpstring.into_param().abi(),
            ::std::mem::transmute(cchstr),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsNormalizedString<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    normform: NORM_FORM,
    lpstring: Param1,
    cwlength: i32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsNormalizedString(
                normform: NORM_FORM,
                lpstring: super::Foundation::PWSTR,
                cwlength: i32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsNormalizedString(
            ::std::mem::transmute(normform),
            lpstring.into_param().abi(),
            ::std::mem::transmute(cwlength),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsTextUnicode(
    lpv: *const ::std::ffi::c_void,
    isize: i32,
    lpiresult: *mut IS_TEXT_UNICODE_RESULT,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsTextUnicode(
                lpv: *const ::std::ffi::c_void,
                isize: i32,
                lpiresult: *mut IS_TEXT_UNICODE_RESULT,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsTextUnicode(
            ::std::mem::transmute(lpv),
            ::std::mem::transmute(isize),
            ::std::mem::transmute(lpiresult),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsValidCodePage(codepage: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidCodePage(codepage: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidCodePage(::std::mem::transmute(codepage)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsValidLanguageGroup(
    languagegroup: u32,
    dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidLanguageGroup(
                languagegroup: u32,
                dwflags: ENUM_SYSTEM_LANGUAGE_GROUPS_FLAGS,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidLanguageGroup(
            ::std::mem::transmute(languagegroup),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsValidLocale(
    locale: u32,
    dwflags: IS_VALID_LOCALE_FLAGS,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidLocale(
                locale: u32,
                dwflags: IS_VALID_LOCALE_FLAGS,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidLocale(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsValidLocaleName<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lplocalename: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidLocaleName(lplocalename: super::Foundation::PWSTR)
                -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(IsValidLocaleName(lplocalename.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsValidNLSVersion<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    function: u32,
    lplocalename: Param1,
    lpversioninformation: *const NLSVERSIONINFOEX,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsValidNLSVersion(
                function: u32,
                lplocalename: super::Foundation::PWSTR,
                lpversioninformation: *const NLSVERSIONINFOEX,
            ) -> u32;
        }
        ::std::mem::transmute(IsValidNLSVersion(
            ::std::mem::transmute(function),
            lplocalename.into_param().abi(),
            ::std::mem::transmute(lpversioninformation),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn IsWellFormedTag<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    psztag: Param0,
) -> u8 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn IsWellFormedTag(psztag: super::Foundation::PWSTR) -> u8;
        }
        ::std::mem::transmute(IsWellFormedTag(psztag.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const JPOS_1DAN: u32 = 213u32;
pub const JPOS_4DAN_HA: u32 = 212u32;
pub const JPOS_5DAN_AWA: u32 = 200u32;
pub const JPOS_5DAN_AWAUON: u32 = 209u32;
pub const JPOS_5DAN_BA: u32 = 206u32;
pub const JPOS_5DAN_GA: u32 = 202u32;
pub const JPOS_5DAN_KA: u32 = 201u32;
pub const JPOS_5DAN_KASOKUON: u32 = 210u32;
pub const JPOS_5DAN_MA: u32 = 207u32;
pub const JPOS_5DAN_NA: u32 = 205u32;
pub const JPOS_5DAN_RA: u32 = 208u32;
pub const JPOS_5DAN_RAHEN: u32 = 211u32;
pub const JPOS_5DAN_SA: u32 = 203u32;
pub const JPOS_5DAN_TA: u32 = 204u32;
pub const JPOS_BUPPIN: u32 = 122u32;
pub const JPOS_CHIMEI: u32 = 109u32;
pub const JPOS_CHIMEI_EKI: u32 = 117u32;
pub const JPOS_CHIMEI_GUN: u32 = 112u32;
pub const JPOS_CHIMEI_KEN: u32 = 111u32;
pub const JPOS_CHIMEI_KU: u32 = 113u32;
pub const JPOS_CHIMEI_KUNI: u32 = 110u32;
pub const JPOS_CHIMEI_MACHI: u32 = 115u32;
pub const JPOS_CHIMEI_MURA: u32 = 116u32;
pub const JPOS_CHIMEI_SHI: u32 = 114u32;
pub const JPOS_CLOSEBRACE: u32 = 911u32;
pub const JPOS_DAIMEISHI: u32 = 123u32;
pub const JPOS_DAIMEISHI_NINSHOU: u32 = 124u32;
pub const JPOS_DAIMEISHI_SHIJI: u32 = 125u32;
pub const JPOS_DOKURITSUGO: u32 = 903u32;
pub const JPOS_EIJI: u32 = 906u32;
pub const JPOS_FUKUSHI: u32 = 500u32;
pub const JPOS_FUKUSHI_DA: u32 = 504u32;
pub const JPOS_FUKUSHI_NANO: u32 = 503u32;
pub const JPOS_FUKUSHI_NI: u32 = 502u32;
pub const JPOS_FUKUSHI_SAHEN: u32 = 501u32;
pub const JPOS_FUKUSHI_TO: u32 = 505u32;
pub const JPOS_FUKUSHI_TOSURU: u32 = 506u32;
pub const JPOS_FUTEIGO: u32 = 904u32;
pub const JPOS_HUKUSIMEISHI: u32 = 104u32;
pub const JPOS_JINMEI: u32 = 106u32;
pub const JPOS_JINMEI_MEI: u32 = 108u32;
pub const JPOS_JINMEI_SEI: u32 = 107u32;
pub const JPOS_KANDOUSHI: u32 = 670u32;
pub const JPOS_KANJI: u32 = 909u32;
pub const JPOS_KANYOUKU: u32 = 902u32;
pub const JPOS_KAZU: u32 = 126u32;
pub const JPOS_KAZU_SURYOU: u32 = 127u32;
pub const JPOS_KAZU_SUSHI: u32 = 128u32;
pub const JPOS_KEIDOU: u32 = 400u32;
pub const JPOS_KEIDOU_GARU: u32 = 403u32;
pub const JPOS_KEIDOU_NO: u32 = 401u32;
pub const JPOS_KEIDOU_TARU: u32 = 402u32;
pub const JPOS_KEIYOU: u32 = 300u32;
pub const JPOS_KEIYOU_GARU: u32 = 301u32;
pub const JPOS_KEIYOU_GE: u32 = 302u32;
pub const JPOS_KEIYOU_ME: u32 = 303u32;
pub const JPOS_KEIYOU_U: u32 = 305u32;
pub const JPOS_KEIYOU_YUU: u32 = 304u32;
pub const JPOS_KENCHIKU: u32 = 121u32;
pub const JPOS_KIGOU: u32 = 905u32;
pub const JPOS_KURU_KI: u32 = 219u32;
pub const JPOS_KURU_KITA: u32 = 220u32;
pub const JPOS_KURU_KITARA: u32 = 221u32;
pub const JPOS_KURU_KITARI: u32 = 222u32;
pub const JPOS_KURU_KITAROU: u32 = 223u32;
pub const JPOS_KURU_KITE: u32 = 224u32;
pub const JPOS_KURU_KO: u32 = 226u32;
pub const JPOS_KURU_KOI: u32 = 227u32;
pub const JPOS_KURU_KOYOU: u32 = 228u32;
pub const JPOS_KURU_KUREBA: u32 = 225u32;
pub const JPOS_KUTEN: u32 = 907u32;
pub const JPOS_MEISA_KEIDOU: u32 = 105u32;
pub const JPOS_MEISHI_FUTSU: u32 = 100u32;
pub const JPOS_MEISHI_KEIYOUDOUSHI: u32 = 103u32;
pub const JPOS_MEISHI_SAHEN: u32 = 101u32;
pub const JPOS_MEISHI_ZAHEN: u32 = 102u32;
pub const JPOS_OPENBRACE: u32 = 910u32;
pub const JPOS_RENTAISHI: u32 = 600u32;
pub const JPOS_RENTAISHI_SHIJI: u32 = 601u32;
pub const JPOS_RENYOU_SETSUBI: u32 = 826u32;
pub const JPOS_SETSUBI: u32 = 800u32;
pub const JPOS_SETSUBI_CHIMEI: u32 = 811u32;
pub const JPOS_SETSUBI_CHOU: u32 = 818u32;
pub const JPOS_SETSUBI_CHU: u32 = 804u32;
pub const JPOS_SETSUBI_DONO: u32 = 835u32;
pub const JPOS_SETSUBI_EKI: u32 = 821u32;
pub const JPOS_SETSUBI_FU: u32 = 805u32;
pub const JPOS_SETSUBI_FUKUSU: u32 = 836u32;
pub const JPOS_SETSUBI_GUN: u32 = 814u32;
pub const JPOS_SETSUBI_JIKAN: u32 = 829u32;
pub const JPOS_SETSUBI_JIKANPLUS: u32 = 830u32;
pub const JPOS_SETSUBI_JINMEI: u32 = 810u32;
pub const JPOS_SETSUBI_JOSUSHI: u32 = 827u32;
pub const JPOS_SETSUBI_JOSUSHIPLUS: u32 = 828u32;
pub const JPOS_SETSUBI_KA: u32 = 803u32;
pub const JPOS_SETSUBI_KATA: u32 = 808u32;
pub const JPOS_SETSUBI_KEN: u32 = 813u32;
pub const JPOS_SETSUBI_KENCHIKU: u32 = 825u32;
pub const JPOS_SETSUBI_KU: u32 = 815u32;
pub const JPOS_SETSUBI_KUN: u32 = 833u32;
pub const JPOS_SETSUBI_KUNI: u32 = 812u32;
pub const JPOS_SETSUBI_MACHI: u32 = 817u32;
pub const JPOS_SETSUBI_MEISHIRENDAKU: u32 = 809u32;
pub const JPOS_SETSUBI_MURA: u32 = 819u32;
pub const JPOS_SETSUBI_RA: u32 = 838u32;
pub const JPOS_SETSUBI_RYU: u32 = 806u32;
pub const JPOS_SETSUBI_SAMA: u32 = 834u32;
pub const JPOS_SETSUBI_SAN: u32 = 832u32;
pub const JPOS_SETSUBI_SEI: u32 = 802u32;
pub const JPOS_SETSUBI_SHAMEI: u32 = 823u32;
pub const JPOS_SETSUBI_SHI: u32 = 816u32;
pub const JPOS_SETSUBI_SON: u32 = 820u32;
pub const JPOS_SETSUBI_SONOTA: u32 = 822u32;
pub const JPOS_SETSUBI_SOSHIKI: u32 = 824u32;
pub const JPOS_SETSUBI_TACHI: u32 = 837u32;
pub const JPOS_SETSUBI_TEINEI: u32 = 831u32;
pub const JPOS_SETSUBI_TEKI: u32 = 801u32;
pub const JPOS_SETSUBI_YOU: u32 = 807u32;
pub const JPOS_SETSUZOKUSHI: u32 = 650u32;
pub const JPOS_SETTOU: u32 = 700u32;
pub const JPOS_SETTOU_CHIMEI: u32 = 710u32;
pub const JPOS_SETTOU_CHOUTAN: u32 = 707u32;
pub const JPOS_SETTOU_DAISHOU: u32 = 705u32;
pub const JPOS_SETTOU_FUKU: u32 = 703u32;
pub const JPOS_SETTOU_JINMEI: u32 = 709u32;
pub const JPOS_SETTOU_JOSUSHI: u32 = 712u32;
pub const JPOS_SETTOU_KAKU: u32 = 701u32;
pub const JPOS_SETTOU_KOUTEI: u32 = 706u32;
pub const JPOS_SETTOU_MI: u32 = 704u32;
pub const JPOS_SETTOU_SAI: u32 = 702u32;
pub const JPOS_SETTOU_SHINKYU: u32 = 708u32;
pub const JPOS_SETTOU_SONOTA: u32 = 711u32;
pub const JPOS_SETTOU_TEINEI_GO: u32 = 714u32;
pub const JPOS_SETTOU_TEINEI_O: u32 = 713u32;
pub const JPOS_SETTOU_TEINEI_ON: u32 = 715u32;
pub const JPOS_SHAMEI: u32 = 119u32;
pub const JPOS_SONOTA: u32 = 118u32;
pub const JPOS_SOSHIKI: u32 = 120u32;
pub const JPOS_SURU_SA: u32 = 229u32;
pub const JPOS_SURU_SE: u32 = 238u32;
pub const JPOS_SURU_SEYO: u32 = 239u32;
pub const JPOS_SURU_SI: u32 = 230u32;
pub const JPOS_SURU_SIATRI: u32 = 233u32;
pub const JPOS_SURU_SITA: u32 = 231u32;
pub const JPOS_SURU_SITARA: u32 = 232u32;
pub const JPOS_SURU_SITAROU: u32 = 234u32;
pub const JPOS_SURU_SITE: u32 = 235u32;
pub const JPOS_SURU_SIYOU: u32 = 236u32;
pub const JPOS_SURU_SUREBA: u32 = 237u32;
pub const JPOS_TANKANJI: u32 = 900u32;
pub const JPOS_TANKANJI_KAO: u32 = 901u32;
pub const JPOS_TANSHUKU: u32 = 913u32;
pub const JPOS_TOKUSHU_KAHEN: u32 = 214u32;
pub const JPOS_TOKUSHU_NAHEN: u32 = 218u32;
pub const JPOS_TOKUSHU_SAHEN: u32 = 216u32;
pub const JPOS_TOKUSHU_SAHENSURU: u32 = 215u32;
pub const JPOS_TOKUSHU_ZAHEN: u32 = 217u32;
pub const JPOS_TOUTEN: u32 = 908u32;
pub const JPOS_UNDEFINED: u32 = 0u32;
pub const JPOS_YOKUSEI: u32 = 912u32;
#[cfg(feature = "Win32_Foundation")]
pub type LANGGROUPLOCALE_ENUMPROCA = unsafe extern "system" fn(
    param0: u32,
    param1: u32,
    param2: super::Foundation::PSTR,
    param3: isize,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type LANGGROUPLOCALE_ENUMPROCW = unsafe extern "system" fn(
    param0: u32,
    param1: u32,
    param2: super::Foundation::PWSTR,
    param3: isize,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type LANGUAGEGROUP_ENUMPROCA = unsafe extern "system" fn(
    param0: u32,
    param1: super::Foundation::PSTR,
    param2: super::Foundation::PSTR,
    param3: u32,
    param4: isize,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type LANGUAGEGROUP_ENUMPROCW = unsafe extern "system" fn(
    param0: u32,
    param1: super::Foundation::PWSTR,
    param2: super::Foundation::PWSTR,
    param3: u32,
    param4: isize,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn LCIDToLocaleName(
    locale: u32,
    lpname: super::Foundation::PWSTR,
    cchname: i32,
    dwflags: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCIDToLocaleName(
                locale: u32,
                lpname: super::Foundation::PWSTR,
                cchname: i32,
                dwflags: u32,
            ) -> i32;
        }
        ::std::mem::transmute(LCIDToLocaleName(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(lpname),
            ::std::mem::transmute(cchname),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const LCID_ALTERNATE_SORTS: u32 = 4u32;
pub const LCMAP_BYTEREV: u32 = 2048u32;
pub const LCMAP_FULLWIDTH: u32 = 8388608u32;
pub const LCMAP_HALFWIDTH: u32 = 4194304u32;
pub const LCMAP_HASH: u32 = 262144u32;
pub const LCMAP_HIRAGANA: u32 = 1048576u32;
pub const LCMAP_KATAKANA: u32 = 2097152u32;
pub const LCMAP_LINGUISTIC_CASING: u32 = 16777216u32;
pub const LCMAP_LOWERCASE: u32 = 256u32;
pub const LCMAP_SIMPLIFIED_CHINESE: u32 = 33554432u32;
pub const LCMAP_SORTHANDLE: u32 = 536870912u32;
pub const LCMAP_SORTKEY: u32 = 1024u32;
pub const LCMAP_TITLECASE: u32 = 768u32;
pub const LCMAP_TRADITIONAL_CHINESE: u32 = 67108864u32;
pub const LCMAP_UPPERCASE: u32 = 512u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn LCMapStringA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    dwmapflags: u32,
    lpsrcstr: Param2,
    cchsrc: i32,
    lpdeststr: super::Foundation::PSTR,
    cchdest: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCMapStringA(
                locale: u32,
                dwmapflags: u32,
                lpsrcstr: super::Foundation::PSTR,
                cchsrc: i32,
                lpdeststr: super::Foundation::PSTR,
                cchdest: i32,
            ) -> i32;
        }
        ::std::mem::transmute(LCMapStringA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwmapflags),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpdeststr),
            ::std::mem::transmute(cchdest),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn LCMapStringEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param8: ::windows::runtime::IntoParam<'a, super::Foundation::LPARAM>,
>(
    lplocalename: Param0,
    dwmapflags: u32,
    lpsrcstr: Param2,
    cchsrc: i32,
    lpdeststr: super::Foundation::PWSTR,
    cchdest: i32,
    lpversioninformation: *const NLSVERSIONINFO,
    lpreserved: *const ::std::ffi::c_void,
    sorthandle: Param8,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCMapStringEx(
                lplocalename: super::Foundation::PWSTR,
                dwmapflags: u32,
                lpsrcstr: super::Foundation::PWSTR,
                cchsrc: i32,
                lpdeststr: super::Foundation::PWSTR,
                cchdest: i32,
                lpversioninformation: *const NLSVERSIONINFO,
                lpreserved: *const ::std::ffi::c_void,
                sorthandle: super::Foundation::LPARAM,
            ) -> i32;
        }
        ::std::mem::transmute(LCMapStringEx(
            lplocalename.into_param().abi(),
            ::std::mem::transmute(dwmapflags),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpdeststr),
            ::std::mem::transmute(cchdest),
            ::std::mem::transmute(lpversioninformation),
            ::std::mem::transmute(lpreserved),
            sorthandle.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn LCMapStringW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    dwmapflags: u32,
    lpsrcstr: Param2,
    cchsrc: i32,
    lpdeststr: super::Foundation::PWSTR,
    cchdest: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LCMapStringW(
                locale: u32,
                dwmapflags: u32,
                lpsrcstr: super::Foundation::PWSTR,
                cchsrc: i32,
                lpdeststr: super::Foundation::PWSTR,
                cchdest: i32,
            ) -> i32;
        }
        ::std::mem::transmute(LCMapStringW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(dwmapflags),
            lpsrcstr.into_param().abi(),
            ::std::mem::transmute(cchsrc),
            ::std::mem::transmute(lpdeststr),
            ::std::mem::transmute(cchdest),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const LGRPID_ARABIC: u32 = 13u32;
pub const LGRPID_ARMENIAN: u32 = 17u32;
pub const LGRPID_BALTIC: u32 = 3u32;
pub const LGRPID_CENTRAL_EUROPE: u32 = 2u32;
pub const LGRPID_CYRILLIC: u32 = 5u32;
pub const LGRPID_GEORGIAN: u32 = 16u32;
pub const LGRPID_GREEK: u32 = 4u32;
pub const LGRPID_HEBREW: u32 = 12u32;
pub const LGRPID_INDIC: u32 = 15u32;
pub const LGRPID_JAPANESE: u32 = 7u32;
pub const LGRPID_KOREAN: u32 = 8u32;
pub const LGRPID_SIMPLIFIED_CHINESE: u32 = 10u32;
pub const LGRPID_THAI: u32 = 11u32;
pub const LGRPID_TRADITIONAL_CHINESE: u32 = 9u32;
pub const LGRPID_TURKIC: u32 = 6u32;
pub const LGRPID_TURKISH: u32 = 6u32;
pub const LGRPID_VIETNAMESE: u32 = 14u32;
pub const LGRPID_WESTERN_EUROPE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct LOCALESIGNATURE {
    pub lsUsb: [u32; 4],
    pub lsCsbDefault: [u32; 2],
    pub lsCsbSupported: [u32; 2],
}
impl LOCALESIGNATURE {}
impl ::std::default::Default for LOCALESIGNATURE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for LOCALESIGNATURE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("LOCALESIGNATURE")
            .field("lsUsb", &self.lsUsb)
            .field("lsCsbDefault", &self.lsCsbDefault)
            .field("lsCsbSupported", &self.lsCsbSupported)
            .finish()
    }
}
impl ::std::cmp::PartialEq for LOCALESIGNATURE {
    fn eq(&self, other: &Self) -> bool {
        self.lsUsb == other.lsUsb
            && self.lsCsbDefault == other.lsCsbDefault
            && self.lsCsbSupported == other.lsCsbSupported
    }
}
impl ::std::cmp::Eq for LOCALESIGNATURE {}
unsafe impl ::windows::runtime::Abi for LOCALESIGNATURE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const LOCALE_ALL: u32 = 0u32;
pub const LOCALE_ALLOW_NEUTRAL_NAMES: u32 = 134217728u32;
pub const LOCALE_ALTERNATE_SORTS: u32 = 4u32;
#[cfg(feature = "Win32_Foundation")]
pub type LOCALE_ENUMPROCA =
    unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type LOCALE_ENUMPROCEX = unsafe extern "system" fn(
    param0: super::Foundation::PWSTR,
    param1: u32,
    param2: super::Foundation::LPARAM,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type LOCALE_ENUMPROCW =
    unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
pub const LOCALE_FONTSIGNATURE: u32 = 88u32;
pub const LOCALE_ICALENDARTYPE: u32 = 4105u32;
pub const LOCALE_ICENTURY: u32 = 36u32;
pub const LOCALE_ICONSTRUCTEDLOCALE: u32 = 125u32;
pub const LOCALE_ICOUNTRY: u32 = 5u32;
pub const LOCALE_ICURRDIGITS: u32 = 25u32;
pub const LOCALE_ICURRENCY: u32 = 27u32;
pub const LOCALE_IDATE: u32 = 33u32;
pub const LOCALE_IDAYLZERO: u32 = 38u32;
pub const LOCALE_IDEFAULTANSICODEPAGE: u32 = 4100u32;
pub const LOCALE_IDEFAULTCODEPAGE: u32 = 11u32;
pub const LOCALE_IDEFAULTCOUNTRY: u32 = 10u32;
pub const LOCALE_IDEFAULTEBCDICCODEPAGE: u32 = 4114u32;
pub const LOCALE_IDEFAULTLANGUAGE: u32 = 9u32;
pub const LOCALE_IDEFAULTMACCODEPAGE: u32 = 4113u32;
pub const LOCALE_IDIALINGCODE: u32 = 5u32;
pub const LOCALE_IDIGITS: u32 = 17u32;
pub const LOCALE_IDIGITSUBSTITUTION: u32 = 4116u32;
pub const LOCALE_IFIRSTDAYOFWEEK: u32 = 4108u32;
pub const LOCALE_IFIRSTWEEKOFYEAR: u32 = 4109u32;
pub const LOCALE_IGEOID: u32 = 91u32;
pub const LOCALE_IINTLCURRDIGITS: u32 = 26u32;
pub const LOCALE_ILANGUAGE: u32 = 1u32;
pub const LOCALE_ILDATE: u32 = 34u32;
pub const LOCALE_ILZERO: u32 = 18u32;
pub const LOCALE_IMEASURE: u32 = 13u32;
pub const LOCALE_IMONLZERO: u32 = 39u32;
pub const LOCALE_INEGATIVEPERCENT: u32 = 116u32;
pub const LOCALE_INEGCURR: u32 = 28u32;
pub const LOCALE_INEGNUMBER: u32 = 4112u32;
pub const LOCALE_INEGSEPBYSPACE: u32 = 87u32;
pub const LOCALE_INEGSIGNPOSN: u32 = 83u32;
pub const LOCALE_INEGSYMPRECEDES: u32 = 86u32;
pub const LOCALE_INEUTRAL: u32 = 113u32;
pub const LOCALE_IOPTIONALCALENDAR: u32 = 4107u32;
pub const LOCALE_IPAPERSIZE: u32 = 4106u32;
pub const LOCALE_IPOSITIVEPERCENT: u32 = 117u32;
pub const LOCALE_IPOSSEPBYSPACE: u32 = 85u32;
pub const LOCALE_IPOSSIGNPOSN: u32 = 82u32;
pub const LOCALE_IPOSSYMPRECEDES: u32 = 84u32;
pub const LOCALE_IREADINGLAYOUT: u32 = 112u32;
pub const LOCALE_ITIME: u32 = 35u32;
pub const LOCALE_ITIMEMARKPOSN: u32 = 4101u32;
pub const LOCALE_ITLZERO: u32 = 37u32;
pub const LOCALE_IUSEUTF8LEGACYACP: u32 = 1638u32;
pub const LOCALE_IUSEUTF8LEGACYOEMCP: u32 = 2457u32;
pub const LOCALE_NEUTRALDATA: u32 = 16u32;
pub const LOCALE_NOUSEROVERRIDE: u32 = 2147483648u32;
pub const LOCALE_REPLACEMENT: u32 = 8u32;
pub const LOCALE_RETURN_GENITIVE_NAMES: u32 = 268435456u32;
pub const LOCALE_RETURN_NUMBER: u32 = 536870912u32;
pub const LOCALE_S1159: u32 = 40u32;
pub const LOCALE_S2359: u32 = 41u32;
pub const LOCALE_SABBREVCTRYNAME: u32 = 7u32;
pub const LOCALE_SABBREVDAYNAME1: u32 = 49u32;
pub const LOCALE_SABBREVDAYNAME2: u32 = 50u32;
pub const LOCALE_SABBREVDAYNAME3: u32 = 51u32;
pub const LOCALE_SABBREVDAYNAME4: u32 = 52u32;
pub const LOCALE_SABBREVDAYNAME5: u32 = 53u32;
pub const LOCALE_SABBREVDAYNAME6: u32 = 54u32;
pub const LOCALE_SABBREVDAYNAME7: u32 = 55u32;
pub const LOCALE_SABBREVLANGNAME: u32 = 3u32;
pub const LOCALE_SABBREVMONTHNAME1: u32 = 68u32;
pub const LOCALE_SABBREVMONTHNAME10: u32 = 77u32;
pub const LOCALE_SABBREVMONTHNAME11: u32 = 78u32;
pub const LOCALE_SABBREVMONTHNAME12: u32 = 79u32;
pub const LOCALE_SABBREVMONTHNAME13: u32 = 4111u32;
pub const LOCALE_SABBREVMONTHNAME2: u32 = 69u32;
pub const LOCALE_SABBREVMONTHNAME3: u32 = 70u32;
pub const LOCALE_SABBREVMONTHNAME4: u32 = 71u32;
pub const LOCALE_SABBREVMONTHNAME5: u32 = 72u32;
pub const LOCALE_SABBREVMONTHNAME6: u32 = 73u32;
pub const LOCALE_SABBREVMONTHNAME7: u32 = 74u32;
pub const LOCALE_SABBREVMONTHNAME8: u32 = 75u32;
pub const LOCALE_SABBREVMONTHNAME9: u32 = 76u32;
pub const LOCALE_SAM: u32 = 40u32;
pub const LOCALE_SCONSOLEFALLBACKNAME: u32 = 110u32;
pub const LOCALE_SCOUNTRY: u32 = 6u32;
pub const LOCALE_SCURRENCY: u32 = 20u32;
pub const LOCALE_SDATE: u32 = 29u32;
pub const LOCALE_SDAYNAME1: u32 = 42u32;
pub const LOCALE_SDAYNAME2: u32 = 43u32;
pub const LOCALE_SDAYNAME3: u32 = 44u32;
pub const LOCALE_SDAYNAME4: u32 = 45u32;
pub const LOCALE_SDAYNAME5: u32 = 46u32;
pub const LOCALE_SDAYNAME6: u32 = 47u32;
pub const LOCALE_SDAYNAME7: u32 = 48u32;
pub const LOCALE_SDECIMAL: u32 = 14u32;
pub const LOCALE_SDURATION: u32 = 93u32;
pub const LOCALE_SENGCOUNTRY: u32 = 4098u32;
pub const LOCALE_SENGCURRNAME: u32 = 4103u32;
pub const LOCALE_SENGLANGUAGE: u32 = 4097u32;
pub const LOCALE_SENGLISHCOUNTRYNAME: u32 = 4098u32;
pub const LOCALE_SENGLISHDISPLAYNAME: u32 = 114u32;
pub const LOCALE_SENGLISHLANGUAGENAME: u32 = 4097u32;
pub const LOCALE_SGROUPING: u32 = 16u32;
pub const LOCALE_SINTLSYMBOL: u32 = 21u32;
pub const LOCALE_SISO3166CTRYNAME: u32 = 90u32;
pub const LOCALE_SISO3166CTRYNAME2: u32 = 104u32;
pub const LOCALE_SISO639LANGNAME: u32 = 89u32;
pub const LOCALE_SISO639LANGNAME2: u32 = 103u32;
pub const LOCALE_SKEYBOARDSTOINSTALL: u32 = 94u32;
pub const LOCALE_SLANGDISPLAYNAME: u32 = 111u32;
pub const LOCALE_SLANGUAGE: u32 = 2u32;
pub const LOCALE_SLIST: u32 = 12u32;
pub const LOCALE_SLOCALIZEDCOUNTRYNAME: u32 = 6u32;
pub const LOCALE_SLOCALIZEDDISPLAYNAME: u32 = 2u32;
pub const LOCALE_SLOCALIZEDLANGUAGENAME: u32 = 111u32;
pub const LOCALE_SLONGDATE: u32 = 32u32;
pub const LOCALE_SMONDECIMALSEP: u32 = 22u32;
pub const LOCALE_SMONGROUPING: u32 = 24u32;
pub const LOCALE_SMONTHDAY: u32 = 120u32;
pub const LOCALE_SMONTHNAME1: u32 = 56u32;
pub const LOCALE_SMONTHNAME10: u32 = 65u32;
pub const LOCALE_SMONTHNAME11: u32 = 66u32;
pub const LOCALE_SMONTHNAME12: u32 = 67u32;
pub const LOCALE_SMONTHNAME13: u32 = 4110u32;
pub const LOCALE_SMONTHNAME2: u32 = 57u32;
pub const LOCALE_SMONTHNAME3: u32 = 58u32;
pub const LOCALE_SMONTHNAME4: u32 = 59u32;
pub const LOCALE_SMONTHNAME5: u32 = 60u32;
pub const LOCALE_SMONTHNAME6: u32 = 61u32;
pub const LOCALE_SMONTHNAME7: u32 = 62u32;
pub const LOCALE_SMONTHNAME8: u32 = 63u32;
pub const LOCALE_SMONTHNAME9: u32 = 64u32;
pub const LOCALE_SMONTHOUSANDSEP: u32 = 23u32;
pub const LOCALE_SNAME: u32 = 92u32;
pub const LOCALE_SNAN: u32 = 105u32;
pub const LOCALE_SNATIVECOUNTRYNAME: u32 = 8u32;
pub const LOCALE_SNATIVECTRYNAME: u32 = 8u32;
pub const LOCALE_SNATIVECURRNAME: u32 = 4104u32;
pub const LOCALE_SNATIVEDIGITS: u32 = 19u32;
pub const LOCALE_SNATIVEDISPLAYNAME: u32 = 115u32;
pub const LOCALE_SNATIVELANGNAME: u32 = 4u32;
pub const LOCALE_SNATIVELANGUAGENAME: u32 = 4u32;
pub const LOCALE_SNEGATIVESIGN: u32 = 81u32;
pub const LOCALE_SNEGINFINITY: u32 = 107u32;
pub const LOCALE_SOPENTYPELANGUAGETAG: u32 = 122u32;
pub const LOCALE_SPARENT: u32 = 109u32;
pub const LOCALE_SPECIFICDATA: u32 = 32u32;
pub const LOCALE_SPERCENT: u32 = 118u32;
pub const LOCALE_SPERMILLE: u32 = 119u32;
pub const LOCALE_SPM: u32 = 41u32;
pub const LOCALE_SPOSINFINITY: u32 = 106u32;
pub const LOCALE_SPOSITIVESIGN: u32 = 80u32;
pub const LOCALE_SRELATIVELONGDATE: u32 = 124u32;
pub const LOCALE_SSCRIPTS: u32 = 108u32;
pub const LOCALE_SSHORTDATE: u32 = 31u32;
pub const LOCALE_SSHORTESTAM: u32 = 126u32;
pub const LOCALE_SSHORTESTDAYNAME1: u32 = 96u32;
pub const LOCALE_SSHORTESTDAYNAME2: u32 = 97u32;
pub const LOCALE_SSHORTESTDAYNAME3: u32 = 98u32;
pub const LOCALE_SSHORTESTDAYNAME4: u32 = 99u32;
pub const LOCALE_SSHORTESTDAYNAME5: u32 = 100u32;
pub const LOCALE_SSHORTESTDAYNAME6: u32 = 101u32;
pub const LOCALE_SSHORTESTDAYNAME7: u32 = 102u32;
pub const LOCALE_SSHORTESTPM: u32 = 127u32;
pub const LOCALE_SSHORTTIME: u32 = 121u32;
pub const LOCALE_SSORTLOCALE: u32 = 123u32;
pub const LOCALE_SSORTNAME: u32 = 4115u32;
pub const LOCALE_STHOUSAND: u32 = 15u32;
pub const LOCALE_STIME: u32 = 30u32;
pub const LOCALE_STIMEFORMAT: u32 = 4099u32;
pub const LOCALE_SUPPLEMENTAL: u32 = 2u32;
pub const LOCALE_SYEARMONTH: u32 = 4102u32;
pub const LOCALE_USE_CP_ACP: u32 = 1073741824u32;
pub const LOCALE_WINDOWS: u32 = 1u32;
pub const LOWLEVEL_SERVICE_TYPES: u32 = 2u32;
pub const LOW_SURROGATE_END: u32 = 57343u32;
pub const LOW_SURROGATE_START: u32 = 56320u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn LocaleNameToLCID<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lpname: Param0,
    dwflags: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn LocaleNameToLCID(lpname: super::Foundation::PWSTR, dwflags: u32) -> u32;
        }
        ::std::mem::transmute(LocaleNameToLCID(
            lpname.into_param().abi(),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct MAPPING_DATA_RANGE {
    pub dwStartIndex: u32,
    pub dwEndIndex: u32,
    pub pszDescription: super::Foundation::PWSTR,
    pub dwDescriptionLength: u32,
    pub pData: *mut ::std::ffi::c_void,
    pub dwDataSize: u32,
    pub pszContentType: super::Foundation::PWSTR,
    pub prgActionIds: *mut super::Foundation::PWSTR,
    pub dwActionsCount: u32,
    pub prgActionDisplayNames: *mut super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_DATA_RANGE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_DATA_RANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_DATA_RANGE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_DATA_RANGE")
            .field("dwStartIndex", &self.dwStartIndex)
            .field("dwEndIndex", &self.dwEndIndex)
            .field("pszDescription", &self.pszDescription)
            .field("dwDescriptionLength", &self.dwDescriptionLength)
            .field("pData", &self.pData)
            .field("dwDataSize", &self.dwDataSize)
            .field("pszContentType", &self.pszContentType)
            .field("prgActionIds", &self.prgActionIds)
            .field("dwActionsCount", &self.dwActionsCount)
            .field("prgActionDisplayNames", &self.prgActionDisplayNames)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_DATA_RANGE {
    fn eq(&self, other: &Self) -> bool {
        self.dwStartIndex == other.dwStartIndex
            && self.dwEndIndex == other.dwEndIndex
            && self.pszDescription == other.pszDescription
            && self.dwDescriptionLength == other.dwDescriptionLength
            && self.pData == other.pData
            && self.dwDataSize == other.dwDataSize
            && self.pszContentType == other.pszContentType
            && self.prgActionIds == other.prgActionIds
            && self.dwActionsCount == other.dwActionsCount
            && self.prgActionDisplayNames == other.prgActionDisplayNames
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_DATA_RANGE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_DATA_RANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct MAPPING_ENUM_OPTIONS {
    pub Size: usize,
    pub pszCategory: super::Foundation::PWSTR,
    pub pszInputLanguage: super::Foundation::PWSTR,
    pub pszOutputLanguage: super::Foundation::PWSTR,
    pub pszInputScript: super::Foundation::PWSTR,
    pub pszOutputScript: super::Foundation::PWSTR,
    pub pszInputContentType: super::Foundation::PWSTR,
    pub pszOutputContentType: super::Foundation::PWSTR,
    pub pGuid: *mut ::windows::runtime::GUID,
    pub _bitfield: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_ENUM_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_ENUM_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_ENUM_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_ENUM_OPTIONS")
            .field("Size", &self.Size)
            .field("pszCategory", &self.pszCategory)
            .field("pszInputLanguage", &self.pszInputLanguage)
            .field("pszOutputLanguage", &self.pszOutputLanguage)
            .field("pszInputScript", &self.pszInputScript)
            .field("pszOutputScript", &self.pszOutputScript)
            .field("pszInputContentType", &self.pszInputContentType)
            .field("pszOutputContentType", &self.pszOutputContentType)
            .field("pGuid", &self.pGuid)
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_ENUM_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.pszCategory == other.pszCategory
            && self.pszInputLanguage == other.pszInputLanguage
            && self.pszOutputLanguage == other.pszOutputLanguage
            && self.pszInputScript == other.pszInputScript
            && self.pszOutputScript == other.pszOutputScript
            && self.pszInputContentType == other.pszInputContentType
            && self.pszOutputContentType == other.pszOutputContentType
            && self.pGuid == other.pGuid
            && self._bitfield == other._bitfield
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_ENUM_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_ENUM_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct MAPPING_OPTIONS {
    pub Size: usize,
    pub pszInputLanguage: super::Foundation::PWSTR,
    pub pszOutputLanguage: super::Foundation::PWSTR,
    pub pszInputScript: super::Foundation::PWSTR,
    pub pszOutputScript: super::Foundation::PWSTR,
    pub pszInputContentType: super::Foundation::PWSTR,
    pub pszOutputContentType: super::Foundation::PWSTR,
    pub pszUILanguage: super::Foundation::PWSTR,
    pub pfnRecognizeCallback: ::std::option::Option<PFN_MAPPINGCALLBACKPROC>,
    pub pRecognizeCallerData: *mut ::std::ffi::c_void,
    pub dwRecognizeCallerDataSize: u32,
    pub pfnActionCallback: ::std::option::Option<PFN_MAPPINGCALLBACKPROC>,
    pub pActionCallerData: *mut ::std::ffi::c_void,
    pub dwActionCallerDataSize: u32,
    pub dwServiceFlag: u32,
    pub _bitfield: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_OPTIONS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_OPTIONS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_OPTIONS")
            .field("Size", &self.Size)
            .field("pszInputLanguage", &self.pszInputLanguage)
            .field("pszOutputLanguage", &self.pszOutputLanguage)
            .field("pszInputScript", &self.pszInputScript)
            .field("pszOutputScript", &self.pszOutputScript)
            .field("pszInputContentType", &self.pszInputContentType)
            .field("pszOutputContentType", &self.pszOutputContentType)
            .field("pszUILanguage", &self.pszUILanguage)
            .field("pRecognizeCallerData", &self.pRecognizeCallerData)
            .field("dwRecognizeCallerDataSize", &self.dwRecognizeCallerDataSize)
            .field("pActionCallerData", &self.pActionCallerData)
            .field("dwActionCallerDataSize", &self.dwActionCallerDataSize)
            .field("dwServiceFlag", &self.dwServiceFlag)
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_OPTIONS {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.pszInputLanguage == other.pszInputLanguage
            && self.pszOutputLanguage == other.pszOutputLanguage
            && self.pszInputScript == other.pszInputScript
            && self.pszOutputScript == other.pszOutputScript
            && self.pszInputContentType == other.pszInputContentType
            && self.pszOutputContentType == other.pszOutputContentType
            && self.pszUILanguage == other.pszUILanguage
            && self.pfnRecognizeCallback.map(|f| f as usize)
                == other.pfnRecognizeCallback.map(|f| f as usize)
            && self.pRecognizeCallerData == other.pRecognizeCallerData
            && self.dwRecognizeCallerDataSize == other.dwRecognizeCallerDataSize
            && self.pfnActionCallback.map(|f| f as usize)
                == other.pfnActionCallback.map(|f| f as usize)
            && self.pActionCallerData == other.pActionCallerData
            && self.dwActionCallerDataSize == other.dwActionCallerDataSize
            && self.dwServiceFlag == other.dwServiceFlag
            && self._bitfield == other._bitfield
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_OPTIONS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_OPTIONS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct MAPPING_PROPERTY_BAG {
    pub Size: usize,
    pub prgResultRanges: *mut MAPPING_DATA_RANGE,
    pub dwRangesCount: u32,
    pub pServiceData: *mut ::std::ffi::c_void,
    pub dwServiceDataSize: u32,
    pub pCallerData: *mut ::std::ffi::c_void,
    pub dwCallerDataSize: u32,
    pub pContext: *mut ::std::ffi::c_void,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_PROPERTY_BAG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_PROPERTY_BAG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_PROPERTY_BAG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_PROPERTY_BAG")
            .field("Size", &self.Size)
            .field("prgResultRanges", &self.prgResultRanges)
            .field("dwRangesCount", &self.dwRangesCount)
            .field("pServiceData", &self.pServiceData)
            .field("dwServiceDataSize", &self.dwServiceDataSize)
            .field("pCallerData", &self.pCallerData)
            .field("dwCallerDataSize", &self.dwCallerDataSize)
            .field("pContext", &self.pContext)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_PROPERTY_BAG {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.prgResultRanges == other.prgResultRanges
            && self.dwRangesCount == other.dwRangesCount
            && self.pServiceData == other.pServiceData
            && self.dwServiceDataSize == other.dwServiceDataSize
            && self.pCallerData == other.pCallerData
            && self.dwCallerDataSize == other.dwCallerDataSize
            && self.pContext == other.pContext
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_PROPERTY_BAG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_PROPERTY_BAG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct MAPPING_SERVICE_INFO {
    pub Size: usize,
    pub pszCopyright: super::Foundation::PWSTR,
    pub wMajorVersion: u16,
    pub wMinorVersion: u16,
    pub wBuildVersion: u16,
    pub wStepVersion: u16,
    pub dwInputContentTypesCount: u32,
    pub prgInputContentTypes: *mut super::Foundation::PWSTR,
    pub dwOutputContentTypesCount: u32,
    pub prgOutputContentTypes: *mut super::Foundation::PWSTR,
    pub dwInputLanguagesCount: u32,
    pub prgInputLanguages: *mut super::Foundation::PWSTR,
    pub dwOutputLanguagesCount: u32,
    pub prgOutputLanguages: *mut super::Foundation::PWSTR,
    pub dwInputScriptsCount: u32,
    pub prgInputScripts: *mut super::Foundation::PWSTR,
    pub dwOutputScriptsCount: u32,
    pub prgOutputScripts: *mut super::Foundation::PWSTR,
    pub guid: ::windows::runtime::GUID,
    pub pszCategory: super::Foundation::PWSTR,
    pub pszDescription: super::Foundation::PWSTR,
    pub dwPrivateDataSize: u32,
    pub pPrivateData: *mut ::std::ffi::c_void,
    pub pContext: *mut ::std::ffi::c_void,
    pub _bitfield: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl MAPPING_SERVICE_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MAPPING_SERVICE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for MAPPING_SERVICE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MAPPING_SERVICE_INFO")
            .field("Size", &self.Size)
            .field("pszCopyright", &self.pszCopyright)
            .field("wMajorVersion", &self.wMajorVersion)
            .field("wMinorVersion", &self.wMinorVersion)
            .field("wBuildVersion", &self.wBuildVersion)
            .field("wStepVersion", &self.wStepVersion)
            .field("dwInputContentTypesCount", &self.dwInputContentTypesCount)
            .field("prgInputContentTypes", &self.prgInputContentTypes)
            .field("dwOutputContentTypesCount", &self.dwOutputContentTypesCount)
            .field("prgOutputContentTypes", &self.prgOutputContentTypes)
            .field("dwInputLanguagesCount", &self.dwInputLanguagesCount)
            .field("prgInputLanguages", &self.prgInputLanguages)
            .field("dwOutputLanguagesCount", &self.dwOutputLanguagesCount)
            .field("prgOutputLanguages", &self.prgOutputLanguages)
            .field("dwInputScriptsCount", &self.dwInputScriptsCount)
            .field("prgInputScripts", &self.prgInputScripts)
            .field("dwOutputScriptsCount", &self.dwOutputScriptsCount)
            .field("prgOutputScripts", &self.prgOutputScripts)
            .field("guid", &self.guid)
            .field("pszCategory", &self.pszCategory)
            .field("pszDescription", &self.pszDescription)
            .field("dwPrivateDataSize", &self.dwPrivateDataSize)
            .field("pPrivateData", &self.pPrivateData)
            .field("pContext", &self.pContext)
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MAPPING_SERVICE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.pszCopyright == other.pszCopyright
            && self.wMajorVersion == other.wMajorVersion
            && self.wMinorVersion == other.wMinorVersion
            && self.wBuildVersion == other.wBuildVersion
            && self.wStepVersion == other.wStepVersion
            && self.dwInputContentTypesCount == other.dwInputContentTypesCount
            && self.prgInputContentTypes == other.prgInputContentTypes
            && self.dwOutputContentTypesCount == other.dwOutputContentTypesCount
            && self.prgOutputContentTypes == other.prgOutputContentTypes
            && self.dwInputLanguagesCount == other.dwInputLanguagesCount
            && self.prgInputLanguages == other.prgInputLanguages
            && self.dwOutputLanguagesCount == other.dwOutputLanguagesCount
            && self.prgOutputLanguages == other.prgOutputLanguages
            && self.dwInputScriptsCount == other.dwInputScriptsCount
            && self.prgInputScripts == other.prgInputScripts
            && self.dwOutputScriptsCount == other.dwOutputScriptsCount
            && self.prgOutputScripts == other.prgOutputScripts
            && self.guid == other.guid
            && self.pszCategory == other.pszCategory
            && self.pszDescription == other.pszDescription
            && self.dwPrivateDataSize == other.dwPrivateDataSize
            && self.pPrivateData == other.pPrivateData
            && self.pContext == other.pContext
            && self._bitfield == other._bitfield
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MAPPING_SERVICE_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MAPPING_SERVICE_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const MAX_APPLETTITLE: u32 = 64u32;
pub const MAX_DEFAULTCHAR: u32 = 2u32;
pub const MAX_FONTFACE: u32 = 32u32;
pub const MAX_LEADBYTES: u32 = 12u32;
pub const MAX_LOCALE_NAME: u32 = 32u32;
pub const MAX_MIMECP_NAME: u32 = 64u32;
pub const MAX_MIMECSET_NAME: u32 = 50u32;
pub const MAX_MIMEFACE_NAME: u32 = 32u32;
pub const MAX_RFC1766_NAME: u32 = 6u32;
pub const MAX_SCRIPT_NAME: u32 = 48u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct MIMECONTF(pub i32);
pub const MIMECONTF_MAILNEWS: MIMECONTF = MIMECONTF(1i32);
pub const MIMECONTF_BROWSER: MIMECONTF = MIMECONTF(2i32);
pub const MIMECONTF_MINIMAL: MIMECONTF = MIMECONTF(4i32);
pub const MIMECONTF_IMPORT: MIMECONTF = MIMECONTF(8i32);
pub const MIMECONTF_SAVABLE_MAILNEWS: MIMECONTF = MIMECONTF(256i32);
pub const MIMECONTF_SAVABLE_BROWSER: MIMECONTF = MIMECONTF(512i32);
pub const MIMECONTF_EXPORT: MIMECONTF = MIMECONTF(1024i32);
pub const MIMECONTF_PRIVCONVERTER: MIMECONTF = MIMECONTF(65536i32);
pub const MIMECONTF_VALID: MIMECONTF = MIMECONTF(131072i32);
pub const MIMECONTF_VALID_NLS: MIMECONTF = MIMECONTF(262144i32);
pub const MIMECONTF_MIME_IE4: MIMECONTF = MIMECONTF(268435456i32);
pub const MIMECONTF_MIME_LATEST: MIMECONTF = MIMECONTF(536870912i32);
pub const MIMECONTF_MIME_REGISTRY: MIMECONTF = MIMECONTF(1073741824i32);
impl ::std::convert::From<i32> for MIMECONTF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MIMECONTF {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct MIMECPINFO {
    pub dwFlags: u32,
    pub uiCodePage: u32,
    pub uiFamilyCodePage: u32,
    pub wszDescription: [u16; 64],
    pub wszWebCharset: [u16; 50],
    pub wszHeaderCharset: [u16; 50],
    pub wszBodyCharset: [u16; 50],
    pub wszFixedWidthFont: [u16; 32],
    pub wszProportionalFont: [u16; 32],
    pub bGDICharset: u8,
}
impl MIMECPINFO {}
impl ::std::default::Default for MIMECPINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MIMECPINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MIMECPINFO")
            .field("dwFlags", &self.dwFlags)
            .field("uiCodePage", &self.uiCodePage)
            .field("uiFamilyCodePage", &self.uiFamilyCodePage)
            .field("wszDescription", &self.wszDescription)
            .field("wszWebCharset", &self.wszWebCharset)
            .field("wszHeaderCharset", &self.wszHeaderCharset)
            .field("wszBodyCharset", &self.wszBodyCharset)
            .field("wszFixedWidthFont", &self.wszFixedWidthFont)
            .field("wszProportionalFont", &self.wszProportionalFont)
            .field("bGDICharset", &self.bGDICharset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for MIMECPINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwFlags == other.dwFlags
            && self.uiCodePage == other.uiCodePage
            && self.uiFamilyCodePage == other.uiFamilyCodePage
            && self.wszDescription == other.wszDescription
            && self.wszWebCharset == other.wszWebCharset
            && self.wszHeaderCharset == other.wszHeaderCharset
            && self.wszBodyCharset == other.wszBodyCharset
            && self.wszFixedWidthFont == other.wszFixedWidthFont
            && self.wszProportionalFont == other.wszProportionalFont
            && self.bGDICharset == other.bGDICharset
    }
}
impl ::std::cmp::Eq for MIMECPINFO {}
unsafe impl ::windows::runtime::Abi for MIMECPINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct MIMECSETINFO {
    pub uiCodePage: u32,
    pub uiInternetEncoding: u32,
    pub wszCharset: [u16; 50],
}
impl MIMECSETINFO {}
impl ::std::default::Default for MIMECSETINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for MIMECSETINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("MIMECSETINFO")
            .field("uiCodePage", &self.uiCodePage)
            .field("uiInternetEncoding", &self.uiInternetEncoding)
            .field("wszCharset", &self.wszCharset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for MIMECSETINFO {
    fn eq(&self, other: &Self) -> bool {
        self.uiCodePage == other.uiCodePage
            && self.uiInternetEncoding == other.uiInternetEncoding
            && self.wszCharset == other.wszCharset
    }
}
impl ::std::cmp::Eq for MIMECSETINFO {}
unsafe impl ::windows::runtime::Abi for MIMECSETINFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const MIN_SPELLING_NTDDI: u32 = 100794368u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct MLDETECTCP(pub i32);
pub const MLDETECTCP_NONE: MLDETECTCP = MLDETECTCP(0i32);
pub const MLDETECTCP_7BIT: MLDETECTCP = MLDETECTCP(1i32);
pub const MLDETECTCP_8BIT: MLDETECTCP = MLDETECTCP(2i32);
pub const MLDETECTCP_DBCS: MLDETECTCP = MLDETECTCP(4i32);
pub const MLDETECTCP_HTML: MLDETECTCP = MLDETECTCP(8i32);
pub const MLDETECTCP_NUMBER: MLDETECTCP = MLDETECTCP(16i32);
impl ::std::convert::From<i32> for MLDETECTCP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MLDETECTCP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct MLSTR_FLAGS(pub i32);
pub const MLSTR_READ: MLSTR_FLAGS = MLSTR_FLAGS(1i32);
pub const MLSTR_WRITE: MLSTR_FLAGS = MLSTR_FLAGS(2i32);
impl ::std::convert::From<i32> for MLSTR_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MLSTR_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const MODEBIASMODE_DEFAULT: u32 = 0u32;
pub const MODEBIASMODE_DIGIT: u32 = 4u32;
pub const MODEBIASMODE_FILENAME: u32 = 1u32;
pub const MODEBIASMODE_READING: u32 = 2u32;
pub const MODEBIAS_GETVALUE: u32 = 2u32;
pub const MODEBIAS_GETVERSION: u32 = 0u32;
pub const MODEBIAS_SETVALUE: u32 = 1u32;
pub const MOD_IGNORE_ALL_MODIFIER: u32 = 1024u32;
pub const MOD_LEFT: u32 = 32768u32;
pub const MOD_ON_KEYUP: u32 = 2048u32;
pub const MOD_RIGHT: u32 = 16384u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct MORRSLT {
    pub dwSize: u32,
    pub pwchOutput: super::Foundation::PWSTR,
    pub cchOutput: u16,
    pub Anonymous1: MORRSLT_0,
    pub Anonymous2: MORRSLT_1,
    pub pchInputPos: *mut u16,
    pub pchOutputIdxWDD: *mut u16,
    pub Anonymous3: MORRSLT_2,
    pub paMonoRubyPos: *mut u16,
    pub pWDD: *mut WDD,
    pub cWDD: i32,
    pub pPrivate: *mut ::std::ffi::c_void,
    pub BLKBuff: [u16; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl MORRSLT {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MORRSLT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MORRSLT {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MORRSLT {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MORRSLT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub union MORRSLT_0 {
    pub pwchRead: super::Foundation::PWSTR,
    pub pwchComp: super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl MORRSLT_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for MORRSLT_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for MORRSLT_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for MORRSLT_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for MORRSLT_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub union MORRSLT_1 {
    pub cchRead: u16,
    pub cchComp: u16,
}
impl MORRSLT_1 {}
impl ::std::default::Default for MORRSLT_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for MORRSLT_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for MORRSLT_1 {}
unsafe impl ::windows::runtime::Abi for MORRSLT_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub union MORRSLT_2 {
    pub pchReadIdxWDD: *mut u16,
    pub pchCompIdxWDD: *mut u16,
}
impl MORRSLT_2 {}
impl ::std::default::Default for MORRSLT_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for MORRSLT_2 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for MORRSLT_2 {}
unsafe impl ::windows::runtime::Abi for MORRSLT_2 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const MUI_COMPLEX_SCRIPT_FILTER: u32 = 512u32;
pub const MUI_CONSOLE_FILTER: u32 = 256u32;
pub const MUI_FILEINFO_VERSION: u32 = 1u32;
pub const MUI_FILETYPE_LANGUAGE_NEUTRAL_MAIN: u32 = 2u32;
pub const MUI_FILETYPE_LANGUAGE_NEUTRAL_MUI: u32 = 4u32;
pub const MUI_FILETYPE_NOT_LANGUAGE_NEUTRAL: u32 = 1u32;
pub const MUI_FORMAT_INF_COMPAT: u32 = 2u32;
pub const MUI_FORMAT_REG_COMPAT: u32 = 1u32;
pub const MUI_FULL_LANGUAGE: u32 = 1u32;
pub const MUI_IMMUTABLE_LOOKUP: u32 = 16u32;
pub const MUI_LANGUAGE_EXACT: u32 = 16u32;
pub const MUI_LANGUAGE_ID: u32 = 4u32;
pub const MUI_LANGUAGE_INSTALLED: u32 = 32u32;
pub const MUI_LANGUAGE_LICENSED: u32 = 64u32;
pub const MUI_LANGUAGE_NAME: u32 = 8u32;
pub const MUI_LANG_NEUTRAL_PE_FILE: u32 = 256u32;
pub const MUI_LIP_LANGUAGE: u32 = 4u32;
pub const MUI_MACHINE_LANGUAGE_SETTINGS: u32 = 1024u32;
pub const MUI_MERGE_SYSTEM_FALLBACK: u32 = 16u32;
pub const MUI_MERGE_USER_FALLBACK: u32 = 32u32;
pub const MUI_NON_LANG_NEUTRAL_FILE: u32 = 512u32;
pub const MUI_PARTIAL_LANGUAGE: u32 = 2u32;
pub const MUI_QUERY_CHECKSUM: u32 = 2u32;
pub const MUI_QUERY_LANGUAGE_NAME: u32 = 4u32;
pub const MUI_QUERY_RESOURCE_TYPES: u32 = 8u32;
pub const MUI_QUERY_TYPE: u32 = 1u32;
pub const MUI_RESET_FILTERS: u32 = 1u32;
pub const MUI_SKIP_STRING_CACHE: u32 = 8u32;
pub const MUI_THREAD_LANGUAGES: u32 = 64u32;
pub const MUI_USER_PREFERRED_UI_LANGUAGES: u32 = 16u32;
pub const MUI_USE_INSTALLED_LANGUAGES: u32 = 32u32;
pub const MUI_USE_SEARCH_ALL_LANGUAGES: u32 = 64u32;
pub const MUI_VERIFY_FILE_EXISTS: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct MULTI_BYTE_TO_WIDE_CHAR_FLAGS(pub u32);
pub const MB_COMPOSITE: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(2u32);
pub const MB_ERR_INVALID_CHARS: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(8u32);
pub const MB_PRECOMPOSED: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(1u32);
pub const MB_USEGLYPHCHARS: MULTI_BYTE_TO_WIDE_CHAR_FLAGS = MULTI_BYTE_TO_WIDE_CHAR_FLAGS(4u32);
impl ::std::convert::From<u32> for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for MULTI_BYTE_TO_WIDE_CHAR_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn MappingDoAction<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    pbag: *mut MAPPING_PROPERTY_BAG,
    dwrangeindex: u32,
    pszactionid: Param2,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingDoAction(
                pbag: *mut MAPPING_PROPERTY_BAG,
                dwrangeindex: u32,
                pszactionid: super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        MappingDoAction(
            ::std::mem::transmute(pbag),
            ::std::mem::transmute(dwrangeindex),
            pszactionid.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn MappingFreePropertyBag(
    pbag: *const MAPPING_PROPERTY_BAG,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingFreePropertyBag(
                pbag: *const MAPPING_PROPERTY_BAG,
            ) -> ::windows::runtime::HRESULT;
        }
        MappingFreePropertyBag(::std::mem::transmute(pbag)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn MappingFreeServices(
    pserviceinfo: *const MAPPING_SERVICE_INFO,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingFreeServices(
                pserviceinfo: *const MAPPING_SERVICE_INFO,
            ) -> ::windows::runtime::HRESULT;
        }
        MappingFreeServices(::std::mem::transmute(pserviceinfo)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn MappingGetServices(
    poptions: *const MAPPING_ENUM_OPTIONS,
    prgservices: *mut *mut MAPPING_SERVICE_INFO,
    pdwservicescount: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingGetServices(
                poptions: *const MAPPING_ENUM_OPTIONS,
                prgservices: *mut *mut MAPPING_SERVICE_INFO,
                pdwservicescount: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        MappingGetServices(
            ::std::mem::transmute(poptions),
            ::std::mem::transmute(prgservices),
            ::std::mem::transmute(pdwservicescount),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn MappingRecognizeText<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    pserviceinfo: *const MAPPING_SERVICE_INFO,
    psztext: Param1,
    dwlength: u32,
    dwindex: u32,
    poptions: *const MAPPING_OPTIONS,
    pbag: *mut MAPPING_PROPERTY_BAG,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MappingRecognizeText(
                pserviceinfo: *const MAPPING_SERVICE_INFO,
                psztext: super::Foundation::PWSTR,
                dwlength: u32,
                dwindex: u32,
                poptions: *const ::std::mem::ManuallyDrop<MAPPING_OPTIONS>,
                pbag: *mut MAPPING_PROPERTY_BAG,
            ) -> ::windows::runtime::HRESULT;
        }
        MappingRecognizeText(
            ::std::mem::transmute(pserviceinfo),
            psztext.into_param().abi(),
            ::std::mem::transmute(dwlength),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(poptions),
            ::std::mem::transmute(pbag),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn MultiByteToWideChar<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    codepage: u32,
    dwflags: MULTI_BYTE_TO_WIDE_CHAR_FLAGS,
    lpmultibytestr: Param2,
    cbmultibyte: i32,
    lpwidecharstr: super::Foundation::PWSTR,
    cchwidechar: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn MultiByteToWideChar(
                codepage: u32,
                dwflags: MULTI_BYTE_TO_WIDE_CHAR_FLAGS,
                lpmultibytestr: super::Foundation::PSTR,
                cbmultibyte: i32,
                lpwidecharstr: super::Foundation::PWSTR,
                cchwidechar: i32,
            ) -> i32;
        }
        ::std::mem::transmute(MultiByteToWideChar(
            ::std::mem::transmute(codepage),
            ::std::mem::transmute(dwflags),
            lpmultibytestr.into_param().abi(),
            ::std::mem::transmute(cbmultibyte),
            ::std::mem::transmute(lpwidecharstr),
            ::std::mem::transmute(cchwidechar),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const NI_CONTEXTUPDATED: u32 = 3u32;
pub const NI_FINALIZECONVERSIONRESULT: u32 = 20u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct NLSVERSIONINFO {
    pub dwNLSVersionInfoSize: u32,
    pub dwNLSVersion: u32,
    pub dwDefinedVersion: u32,
    pub dwEffectiveId: u32,
    pub guidCustomVersion: ::windows::runtime::GUID,
}
impl NLSVERSIONINFO {}
impl ::std::default::Default for NLSVERSIONINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for NLSVERSIONINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NLSVERSIONINFO")
            .field("dwNLSVersionInfoSize", &self.dwNLSVersionInfoSize)
            .field("dwNLSVersion", &self.dwNLSVersion)
            .field("dwDefinedVersion", &self.dwDefinedVersion)
            .field("dwEffectiveId", &self.dwEffectiveId)
            .field("guidCustomVersion", &self.guidCustomVersion)
            .finish()
    }
}
impl ::std::cmp::PartialEq for NLSVERSIONINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwNLSVersionInfoSize == other.dwNLSVersionInfoSize
            && self.dwNLSVersion == other.dwNLSVersion
            && self.dwDefinedVersion == other.dwDefinedVersion
            && self.dwEffectiveId == other.dwEffectiveId
            && self.guidCustomVersion == other.guidCustomVersion
    }
}
impl ::std::cmp::Eq for NLSVERSIONINFO {}
unsafe impl ::windows::runtime::Abi for NLSVERSIONINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct NLSVERSIONINFOEX {
    pub dwNLSVersionInfoSize: u32,
    pub dwNLSVersion: u32,
    pub dwDefinedVersion: u32,
    pub dwEffectiveId: u32,
    pub guidCustomVersion: ::windows::runtime::GUID,
}
impl NLSVERSIONINFOEX {}
impl ::std::default::Default for NLSVERSIONINFOEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for NLSVERSIONINFOEX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NLSVERSIONINFOEX")
            .field("dwNLSVersionInfoSize", &self.dwNLSVersionInfoSize)
            .field("dwNLSVersion", &self.dwNLSVersion)
            .field("dwDefinedVersion", &self.dwDefinedVersion)
            .field("dwEffectiveId", &self.dwEffectiveId)
            .field("guidCustomVersion", &self.guidCustomVersion)
            .finish()
    }
}
impl ::std::cmp::PartialEq for NLSVERSIONINFOEX {
    fn eq(&self, other: &Self) -> bool {
        self.dwNLSVersionInfoSize == other.dwNLSVersionInfoSize
            && self.dwNLSVersion == other.dwNLSVersion
            && self.dwDefinedVersion == other.dwDefinedVersion
            && self.dwEffectiveId == other.dwEffectiveId
            && self.guidCustomVersion == other.guidCustomVersion
    }
}
impl ::std::cmp::Eq for NLSVERSIONINFOEX {}
unsafe impl ::windows::runtime::Abi for NLSVERSIONINFOEX {
    type Abi = Self;
    type DefaultType = Self;
}
pub const NLS_CP_CPINFO: u32 = 268435456u32;
pub const NLS_CP_MBTOWC: u32 = 1073741824u32;
pub const NLS_CP_WCTOMB: u32 = 2147483648u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct NORM_FORM(pub i32);
pub const NormalizationOther: NORM_FORM = NORM_FORM(0i32);
pub const NormalizationC: NORM_FORM = NORM_FORM(1i32);
pub const NormalizationD: NORM_FORM = NORM_FORM(2i32);
pub const NormalizationKC: NORM_FORM = NORM_FORM(5i32);
pub const NormalizationKD: NORM_FORM = NORM_FORM(6i32);
impl ::std::convert::From<i32> for NORM_FORM {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for NORM_FORM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct NOTIFY_IME_ACTION(pub u32);
pub const NI_CHANGECANDIDATELIST: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(19u32);
pub const NI_CLOSECANDIDATE: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(17u32);
pub const NI_COMPOSITIONSTR: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(21u32);
pub const NI_IMEMENUSELECTED: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(24u32);
pub const NI_OPENCANDIDATE: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(16u32);
pub const NI_SELECTCANDIDATESTR: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(18u32);
pub const NI_SETCANDIDATE_PAGESIZE: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(23u32);
pub const NI_SETCANDIDATE_PAGESTART: NOTIFY_IME_ACTION = NOTIFY_IME_ACTION(22u32);
impl ::std::convert::From<u32> for NOTIFY_IME_ACTION {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for NOTIFY_IME_ACTION {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for NOTIFY_IME_ACTION {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for NOTIFY_IME_ACTION {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for NOTIFY_IME_ACTION {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for NOTIFY_IME_ACTION {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for NOTIFY_IME_ACTION {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct NOTIFY_IME_INDEX(pub u32);
pub const CPS_CANCEL: NOTIFY_IME_INDEX = NOTIFY_IME_INDEX(4u32);
pub const CPS_COMPLETE: NOTIFY_IME_INDEX = NOTIFY_IME_INDEX(1u32);
pub const CPS_CONVERT: NOTIFY_IME_INDEX = NOTIFY_IME_INDEX(2u32);
pub const CPS_REVERT: NOTIFY_IME_INDEX = NOTIFY_IME_INDEX(3u32);
impl ::std::convert::From<u32> for NOTIFY_IME_INDEX {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for NOTIFY_IME_INDEX {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for NOTIFY_IME_INDEX {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for NOTIFY_IME_INDEX {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for NOTIFY_IME_INDEX {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for NOTIFY_IME_INDEX {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for NOTIFY_IME_INDEX {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct NUMBERFMTA {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PSTR,
    pub lpThousandSep: super::Foundation::PSTR,
    pub NegativeOrder: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl NUMBERFMTA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for NUMBERFMTA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for NUMBERFMTA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NUMBERFMTA")
            .field("NumDigits", &self.NumDigits)
            .field("LeadingZero", &self.LeadingZero)
            .field("Grouping", &self.Grouping)
            .field("lpDecimalSep", &self.lpDecimalSep)
            .field("lpThousandSep", &self.lpThousandSep)
            .field("NegativeOrder", &self.NegativeOrder)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for NUMBERFMTA {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits
            && self.LeadingZero == other.LeadingZero
            && self.Grouping == other.Grouping
            && self.lpDecimalSep == other.lpDecimalSep
            && self.lpThousandSep == other.lpThousandSep
            && self.NegativeOrder == other.NegativeOrder
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for NUMBERFMTA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for NUMBERFMTA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct NUMBERFMTW {
    pub NumDigits: u32,
    pub LeadingZero: u32,
    pub Grouping: u32,
    pub lpDecimalSep: super::Foundation::PWSTR,
    pub lpThousandSep: super::Foundation::PWSTR,
    pub NegativeOrder: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl NUMBERFMTW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for NUMBERFMTW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for NUMBERFMTW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("NUMBERFMTW")
            .field("NumDigits", &self.NumDigits)
            .field("LeadingZero", &self.LeadingZero)
            .field("Grouping", &self.Grouping)
            .field("lpDecimalSep", &self.lpDecimalSep)
            .field("lpThousandSep", &self.lpThousandSep)
            .field("NegativeOrder", &self.NegativeOrder)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for NUMBERFMTW {
    fn eq(&self, other: &Self) -> bool {
        self.NumDigits == other.NumDigits
            && self.LeadingZero == other.LeadingZero
            && self.Grouping == other.Grouping
            && self.lpDecimalSep == other.lpDecimalSep
            && self.lpThousandSep == other.lpThousandSep
            && self.NegativeOrder == other.NegativeOrder
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for NUMBERFMTW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for NUMBERFMTW {
    type Abi = Self;
    type DefaultType = Self;
}
pub const NUMSYS_NAME_CAPACITY: u32 = 8u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn NormalizeString<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    normform: NORM_FORM,
    lpsrcstring: Param1,
    cwsrclength: i32,
    lpdststring: super::Foundation::PWSTR,
    cwdstlength: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn NormalizeString(
                normform: NORM_FORM,
                lpsrcstring: super::Foundation::PWSTR,
                cwsrclength: i32,
                lpdststring: super::Foundation::PWSTR,
                cwdstlength: i32,
            ) -> i32;
        }
        ::std::mem::transmute(NormalizeString(
            ::std::mem::transmute(normform),
            lpsrcstring.into_param().abi(),
            ::std::mem::transmute(cwsrclength),
            ::std::mem::transmute(lpdststring),
            ::std::mem::transmute(cwdstlength),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn NotifyUILanguageChange<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    pcwstrnewlanguage: Param1,
    pcwstrpreviouslanguage: Param2,
    dwreserved: u32,
    pdwstatusrtrn: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn NotifyUILanguageChange(
                dwflags: u32,
                pcwstrnewlanguage: super::Foundation::PWSTR,
                pcwstrpreviouslanguage: super::Foundation::PWSTR,
                dwreserved: u32,
                pdwstatusrtrn: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(NotifyUILanguageChange(
            ::std::mem::transmute(dwflags),
            pcwstrnewlanguage.into_param().abi(),
            pcwstrpreviouslanguage.into_param().abi(),
            ::std::mem::transmute(dwreserved),
            ::std::mem::transmute(pdwstatusrtrn),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const OFFLINE_SERVICES: u32 = 2u32;
pub const ONLINE_SERVICES: u32 = 1u32;
#[cfg(feature = "Win32_Foundation")]
pub type PFNLOG = unsafe extern "system" fn(
    param0: *mut IMEDP,
    param1: ::windows::runtime::HRESULT,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type PFN_MAPPINGCALLBACKPROC = unsafe extern "system" fn(
    pbag: *mut MAPPING_PROPERTY_BAG,
    data: *mut ::std::ffi::c_void,
    dwdatasize: u32,
    result: ::windows::runtime::HRESULT,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct POSTBL {
    pub nPos: u16,
    pub szName: *mut u8,
}
impl POSTBL {}
impl ::std::default::Default for POSTBL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for POSTBL {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for POSTBL {}
unsafe impl ::windows::runtime::Abi for POSTBL {
    type Abi = Self;
    type DefaultType = Self;
}
pub const POS_UNDEFINED: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct RECONVERTSTRING {
    pub dwSize: u32,
    pub dwVersion: u32,
    pub dwStrLen: u32,
    pub dwStrOffset: u32,
    pub dwCompStrLen: u32,
    pub dwCompStrOffset: u32,
    pub dwTargetStrLen: u32,
    pub dwTargetStrOffset: u32,
}
impl RECONVERTSTRING {}
impl ::std::default::Default for RECONVERTSTRING {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for RECONVERTSTRING {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("RECONVERTSTRING")
            .field("dwSize", &self.dwSize)
            .field("dwVersion", &self.dwVersion)
            .field("dwStrLen", &self.dwStrLen)
            .field("dwStrOffset", &self.dwStrOffset)
            .field("dwCompStrLen", &self.dwCompStrLen)
            .field("dwCompStrOffset", &self.dwCompStrOffset)
            .field("dwTargetStrLen", &self.dwTargetStrLen)
            .field("dwTargetStrOffset", &self.dwTargetStrOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for RECONVERTSTRING {
    fn eq(&self, other: &Self) -> bool {
        self.dwSize == other.dwSize
            && self.dwVersion == other.dwVersion
            && self.dwStrLen == other.dwStrLen
            && self.dwStrOffset == other.dwStrOffset
            && self.dwCompStrLen == other.dwCompStrLen
            && self.dwCompStrOffset == other.dwCompStrOffset
            && self.dwTargetStrLen == other.dwTargetStrLen
            && self.dwTargetStrOffset == other.dwTargetStrOffset
    }
}
impl ::std::cmp::Eq for RECONVERTSTRING {}
unsafe impl ::windows::runtime::Abi for RECONVERTSTRING {
    type Abi = Self;
    type DefaultType = Self;
}
pub const RECONVOPT_NONE: u32 = 0u32;
pub const RECONVOPT_USECANCELNOTIFY: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct REGISTERWORDA {
    pub lpReading: super::Foundation::PSTR,
    pub lpWord: super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl REGISTERWORDA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for REGISTERWORDA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for REGISTERWORDA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("REGISTERWORDA")
            .field("lpReading", &self.lpReading)
            .field("lpWord", &self.lpWord)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for REGISTERWORDA {
    fn eq(&self, other: &Self) -> bool {
        self.lpReading == other.lpReading && self.lpWord == other.lpWord
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for REGISTERWORDA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for REGISTERWORDA {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub type REGISTERWORDENUMPROCA = unsafe extern "system" fn(
    lpszreading: super::Foundation::PSTR,
    param1: u32,
    lpszstring: super::Foundation::PSTR,
    param3: *mut ::std::ffi::c_void,
) -> i32;
#[cfg(feature = "Win32_Foundation")]
pub type REGISTERWORDENUMPROCW = unsafe extern "system" fn(
    lpszreading: super::Foundation::PWSTR,
    param1: u32,
    lpszstring: super::Foundation::PWSTR,
    param3: *mut ::std::ffi::c_void,
) -> i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct REGISTERWORDW {
    pub lpReading: super::Foundation::PWSTR,
    pub lpWord: super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl REGISTERWORDW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for REGISTERWORDW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for REGISTERWORDW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("REGISTERWORDW")
            .field("lpReading", &self.lpReading)
            .field("lpWord", &self.lpWord)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for REGISTERWORDW {
    fn eq(&self, other: &Self) -> bool {
        self.lpReading == other.lpReading && self.lpWord == other.lpWord
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for REGISTERWORDW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for REGISTERWORDW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct RFC1766INFO {
    pub lcid: u32,
    pub wszRfc1766: [u16; 6],
    pub wszLocaleName: [u16; 32],
}
impl RFC1766INFO {}
impl ::std::default::Default for RFC1766INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for RFC1766INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("RFC1766INFO")
            .field("lcid", &self.lcid)
            .field("wszRfc1766", &self.wszRfc1766)
            .field("wszLocaleName", &self.wszLocaleName)
            .finish()
    }
}
impl ::std::cmp::PartialEq for RFC1766INFO {
    fn eq(&self, other: &Self) -> bool {
        self.lcid == other.lcid
            && self.wszRfc1766 == other.wszRfc1766
            && self.wszLocaleName == other.wszLocaleName
    }
}
impl ::std::cmp::Eq for RFC1766INFO {}
unsafe impl ::windows::runtime::Abi for RFC1766INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ResolveLocaleName<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    lpnametoresolve: Param0,
    lplocalename: super::Foundation::PWSTR,
    cchlocalename: i32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ResolveLocaleName(
                lpnametoresolve: super::Foundation::PWSTR,
                lplocalename: super::Foundation::PWSTR,
                cchlocalename: i32,
            ) -> i32;
        }
        ::std::mem::transmute(ResolveLocaleName(
            lpnametoresolve.into_param().abi(),
            ::std::mem::transmute(lplocalename),
            ::std::mem::transmute(cchlocalename),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn RestoreThreadPreferredUILanguages<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HSAVEDUILANGUAGES>,
>(
    snapshot: Param0,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn RestoreThreadPreferredUILanguages(snapshot: HSAVEDUILANGUAGES);
        }
        ::std::mem::transmute(RestoreThreadPreferredUILanguages(
            snapshot.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SCRIPTCONTF(pub i32);
pub const sidDefault: SCRIPTCONTF = SCRIPTCONTF(0i32);
pub const sidMerge: SCRIPTCONTF = SCRIPTCONTF(1i32);
pub const sidAsciiSym: SCRIPTCONTF = SCRIPTCONTF(2i32);
pub const sidAsciiLatin: SCRIPTCONTF = SCRIPTCONTF(3i32);
pub const sidLatin: SCRIPTCONTF = SCRIPTCONTF(4i32);
pub const sidGreek: SCRIPTCONTF = SCRIPTCONTF(5i32);
pub const sidCyrillic: SCRIPTCONTF = SCRIPTCONTF(6i32);
pub const sidArmenian: SCRIPTCONTF = SCRIPTCONTF(7i32);
pub const sidHebrew: SCRIPTCONTF = SCRIPTCONTF(8i32);
pub const sidArabic: SCRIPTCONTF = SCRIPTCONTF(9i32);
pub const sidDevanagari: SCRIPTCONTF = SCRIPTCONTF(10i32);
pub const sidBengali: SCRIPTCONTF = SCRIPTCONTF(11i32);
pub const sidGurmukhi: SCRIPTCONTF = SCRIPTCONTF(12i32);
pub const sidGujarati: SCRIPTCONTF = SCRIPTCONTF(13i32);
pub const sidOriya: SCRIPTCONTF = SCRIPTCONTF(14i32);
pub const sidTamil: SCRIPTCONTF = SCRIPTCONTF(15i32);
pub const sidTelugu: SCRIPTCONTF = SCRIPTCONTF(16i32);
pub const sidKannada: SCRIPTCONTF = SCRIPTCONTF(17i32);
pub const sidMalayalam: SCRIPTCONTF = SCRIPTCONTF(18i32);
pub const sidThai: SCRIPTCONTF = SCRIPTCONTF(19i32);
pub const sidLao: SCRIPTCONTF = SCRIPTCONTF(20i32);
pub const sidTibetan: SCRIPTCONTF = SCRIPTCONTF(21i32);
pub const sidGeorgian: SCRIPTCONTF = SCRIPTCONTF(22i32);
pub const sidHangul: SCRIPTCONTF = SCRIPTCONTF(23i32);
pub const sidKana: SCRIPTCONTF = SCRIPTCONTF(24i32);
pub const sidBopomofo: SCRIPTCONTF = SCRIPTCONTF(25i32);
pub const sidHan: SCRIPTCONTF = SCRIPTCONTF(26i32);
pub const sidEthiopic: SCRIPTCONTF = SCRIPTCONTF(27i32);
pub const sidCanSyllabic: SCRIPTCONTF = SCRIPTCONTF(28i32);
pub const sidCherokee: SCRIPTCONTF = SCRIPTCONTF(29i32);
pub const sidYi: SCRIPTCONTF = SCRIPTCONTF(30i32);
pub const sidBraille: SCRIPTCONTF = SCRIPTCONTF(31i32);
pub const sidRunic: SCRIPTCONTF = SCRIPTCONTF(32i32);
pub const sidOgham: SCRIPTCONTF = SCRIPTCONTF(33i32);
pub const sidSinhala: SCRIPTCONTF = SCRIPTCONTF(34i32);
pub const sidSyriac: SCRIPTCONTF = SCRIPTCONTF(35i32);
pub const sidBurmese: SCRIPTCONTF = SCRIPTCONTF(36i32);
pub const sidKhmer: SCRIPTCONTF = SCRIPTCONTF(37i32);
pub const sidThaana: SCRIPTCONTF = SCRIPTCONTF(38i32);
pub const sidMongolian: SCRIPTCONTF = SCRIPTCONTF(39i32);
pub const sidUserDefined: SCRIPTCONTF = SCRIPTCONTF(40i32);
pub const sidLim: SCRIPTCONTF = SCRIPTCONTF(41i32);
pub const sidFEFirst: SCRIPTCONTF = SCRIPTCONTF(23i32);
pub const sidFELast: SCRIPTCONTF = SCRIPTCONTF(26i32);
impl ::std::convert::From<i32> for SCRIPTCONTF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPTCONTF {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SCRIPTFONTCONTF(pub i32);
pub const SCRIPTCONTF_FIXED_FONT: SCRIPTFONTCONTF = SCRIPTFONTCONTF(1i32);
pub const SCRIPTCONTF_PROPORTIONAL_FONT: SCRIPTFONTCONTF = SCRIPTFONTCONTF(2i32);
pub const SCRIPTCONTF_SCRIPT_USER: SCRIPTFONTCONTF = SCRIPTFONTCONTF(65536i32);
pub const SCRIPTCONTF_SCRIPT_HIDE: SCRIPTFONTCONTF = SCRIPTFONTCONTF(131072i32);
pub const SCRIPTCONTF_SCRIPT_SYSTEM: SCRIPTFONTCONTF = SCRIPTFONTCONTF(262144i32);
impl ::std::convert::From<i32> for SCRIPTFONTCONTF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPTFONTCONTF {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPTINFO {
    pub ScriptId: u8,
    pub uiCodePage: u32,
    pub wszDescription: [u16; 48],
    pub wszFixedWidthFont: [u16; 32],
    pub wszProportionalFont: [u16; 32],
}
impl SCRIPTINFO {}
impl ::std::default::Default for SCRIPTINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPTINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPTINFO")
            .field("ScriptId", &self.ScriptId)
            .field("uiCodePage", &self.uiCodePage)
            .field("wszDescription", &self.wszDescription)
            .field("wszFixedWidthFont", &self.wszFixedWidthFont)
            .field("wszProportionalFont", &self.wszProportionalFont)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPTINFO {
    fn eq(&self, other: &Self) -> bool {
        self.ScriptId == other.ScriptId
            && self.uiCodePage == other.uiCodePage
            && self.wszDescription == other.wszDescription
            && self.wszFixedWidthFont == other.wszFixedWidthFont
            && self.wszProportionalFont == other.wszProportionalFont
    }
}
impl ::std::cmp::Eq for SCRIPTINFO {}
unsafe impl ::windows::runtime::Abi for SCRIPTINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_ANALYSIS {
    pub _bitfield: u16,
    pub s: SCRIPT_STATE,
}
impl SCRIPT_ANALYSIS {}
impl ::std::default::Default for SCRIPT_ANALYSIS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_ANALYSIS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_ANALYSIS")
            .field("_bitfield", &self._bitfield)
            .field("s", &self.s)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_ANALYSIS {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield && self.s == other.s
    }
}
impl ::std::cmp::Eq for SCRIPT_ANALYSIS {}
unsafe impl ::windows::runtime::Abi for SCRIPT_ANALYSIS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_CONTROL {
    pub _bitfield: u32,
}
impl SCRIPT_CONTROL {}
impl ::std::default::Default for SCRIPT_CONTROL {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_CONTROL {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_CONTROL")
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_CONTROL {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_CONTROL {}
unsafe impl ::windows::runtime::Abi for SCRIPT_CONTROL {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_DIGITSUBSTITUTE {
    pub _bitfield1: u32,
    pub _bitfield2: u32,
    pub dwReserved: u32,
}
impl SCRIPT_DIGITSUBSTITUTE {}
impl ::std::default::Default for SCRIPT_DIGITSUBSTITUTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_DIGITSUBSTITUTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_DIGITSUBSTITUTE")
            .field("_bitfield1", &self._bitfield1)
            .field("_bitfield2", &self._bitfield2)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_DIGITSUBSTITUTE {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield1 == other._bitfield1
            && self._bitfield2 == other._bitfield2
            && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for SCRIPT_DIGITSUBSTITUTE {}
unsafe impl ::windows::runtime::Abi for SCRIPT_DIGITSUBSTITUTE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const SCRIPT_DIGITSUBSTITUTE_CONTEXT: u32 = 0u32;
pub const SCRIPT_DIGITSUBSTITUTE_NATIONAL: u32 = 2u32;
pub const SCRIPT_DIGITSUBSTITUTE_NONE: u32 = 1u32;
pub const SCRIPT_DIGITSUBSTITUTE_TRADITIONAL: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_FONTPROPERTIES {
    pub cBytes: i32,
    pub wgBlank: u16,
    pub wgDefault: u16,
    pub wgInvalid: u16,
    pub wgKashida: u16,
    pub iKashidaWidth: i32,
}
impl SCRIPT_FONTPROPERTIES {}
impl ::std::default::Default for SCRIPT_FONTPROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_FONTPROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_FONTPROPERTIES")
            .field("cBytes", &self.cBytes)
            .field("wgBlank", &self.wgBlank)
            .field("wgDefault", &self.wgDefault)
            .field("wgInvalid", &self.wgInvalid)
            .field("wgKashida", &self.wgKashida)
            .field("iKashidaWidth", &self.iKashidaWidth)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_FONTPROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self.cBytes == other.cBytes
            && self.wgBlank == other.wgBlank
            && self.wgDefault == other.wgDefault
            && self.wgInvalid == other.wgInvalid
            && self.wgKashida == other.wgKashida
            && self.iKashidaWidth == other.iKashidaWidth
    }
}
impl ::std::cmp::Eq for SCRIPT_FONTPROPERTIES {}
unsafe impl ::windows::runtime::Abi for SCRIPT_FONTPROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SCRIPT_IS_COMPLEX_FLAGS(pub u32);
pub const SIC_ASCIIDIGIT: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(2u32);
pub const SIC_COMPLEX: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(1u32);
pub const SIC_NEUTRAL: SCRIPT_IS_COMPLEX_FLAGS = SCRIPT_IS_COMPLEX_FLAGS(4u32);
impl ::std::convert::From<u32> for SCRIPT_IS_COMPLEX_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPT_IS_COMPLEX_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for SCRIPT_IS_COMPLEX_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for SCRIPT_IS_COMPLEX_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for SCRIPT_IS_COMPLEX_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for SCRIPT_IS_COMPLEX_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for SCRIPT_IS_COMPLEX_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_ITEM {
    pub iCharPos: i32,
    pub a: SCRIPT_ANALYSIS,
}
impl SCRIPT_ITEM {}
impl ::std::default::Default for SCRIPT_ITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_ITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_ITEM")
            .field("iCharPos", &self.iCharPos)
            .field("a", &self.a)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_ITEM {
    fn eq(&self, other: &Self) -> bool {
        self.iCharPos == other.iCharPos && self.a == other.a
    }
}
impl ::std::cmp::Eq for SCRIPT_ITEM {}
unsafe impl ::windows::runtime::Abi for SCRIPT_ITEM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SCRIPT_JUSTIFY(pub i32);
pub const SCRIPT_JUSTIFY_NONE: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(0i32);
pub const SCRIPT_JUSTIFY_ARABIC_BLANK: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(1i32);
pub const SCRIPT_JUSTIFY_CHARACTER: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(2i32);
pub const SCRIPT_JUSTIFY_RESERVED1: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(3i32);
pub const SCRIPT_JUSTIFY_BLANK: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(4i32);
pub const SCRIPT_JUSTIFY_RESERVED2: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(5i32);
pub const SCRIPT_JUSTIFY_RESERVED3: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(6i32);
pub const SCRIPT_JUSTIFY_ARABIC_NORMAL: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(7i32);
pub const SCRIPT_JUSTIFY_ARABIC_KASHIDA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(8i32);
pub const SCRIPT_JUSTIFY_ARABIC_ALEF: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(9i32);
pub const SCRIPT_JUSTIFY_ARABIC_HA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(10i32);
pub const SCRIPT_JUSTIFY_ARABIC_RA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(11i32);
pub const SCRIPT_JUSTIFY_ARABIC_BA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(12i32);
pub const SCRIPT_JUSTIFY_ARABIC_BARA: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(13i32);
pub const SCRIPT_JUSTIFY_ARABIC_SEEN: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(14i32);
pub const SCRIPT_JUSTIFY_ARABIC_SEEN_M: SCRIPT_JUSTIFY = SCRIPT_JUSTIFY(15i32);
impl ::std::convert::From<i32> for SCRIPT_JUSTIFY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SCRIPT_JUSTIFY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_LOGATTR {
    pub _bitfield: u8,
}
impl SCRIPT_LOGATTR {}
impl ::std::default::Default for SCRIPT_LOGATTR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_LOGATTR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_LOGATTR")
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_LOGATTR {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_LOGATTR {}
unsafe impl ::windows::runtime::Abi for SCRIPT_LOGATTR {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_PROPERTIES {
    pub _bitfield1: u32,
    pub _bitfield2: u32,
}
impl SCRIPT_PROPERTIES {}
impl ::std::default::Default for SCRIPT_PROPERTIES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_PROPERTIES {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_PROPERTIES")
            .field("_bitfield1", &self._bitfield1)
            .field("_bitfield2", &self._bitfield2)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_PROPERTIES {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield1 == other._bitfield1 && self._bitfield2 == other._bitfield2
    }
}
impl ::std::cmp::Eq for SCRIPT_PROPERTIES {}
unsafe impl ::windows::runtime::Abi for SCRIPT_PROPERTIES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_STATE {
    pub _bitfield: u16,
}
impl SCRIPT_STATE {}
impl ::std::default::Default for SCRIPT_STATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_STATE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_STATE")
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_STATE {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_STATE {}
unsafe impl ::windows::runtime::Abi for SCRIPT_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_TABDEF {
    pub cTabStops: i32,
    pub iScale: i32,
    pub pTabStops: *mut i32,
    pub iTabOrigin: i32,
}
impl SCRIPT_TABDEF {}
impl ::std::default::Default for SCRIPT_TABDEF {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_TABDEF {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_TABDEF")
            .field("cTabStops", &self.cTabStops)
            .field("iScale", &self.iScale)
            .field("pTabStops", &self.pTabStops)
            .field("iTabOrigin", &self.iTabOrigin)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_TABDEF {
    fn eq(&self, other: &Self) -> bool {
        self.cTabStops == other.cTabStops
            && self.iScale == other.iScale
            && self.pTabStops == other.pTabStops
            && self.iTabOrigin == other.iTabOrigin
    }
}
impl ::std::cmp::Eq for SCRIPT_TABDEF {}
unsafe impl ::windows::runtime::Abi for SCRIPT_TABDEF {
    type Abi = Self;
    type DefaultType = Self;
}
pub const SCRIPT_TAG_UNKNOWN: u32 = 0u32;
pub const SCRIPT_UNDEFINED: u32 = 0u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SCRIPT_VISATTR {
    pub _bitfield: u16,
}
impl SCRIPT_VISATTR {}
impl ::std::default::Default for SCRIPT_VISATTR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SCRIPT_VISATTR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SCRIPT_VISATTR")
            .field("_bitfield", &self._bitfield)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SCRIPT_VISATTR {
    fn eq(&self, other: &Self) -> bool {
        self._bitfield == other._bitfield
    }
}
impl ::std::cmp::Eq for SCRIPT_VISATTR {}
unsafe impl ::windows::runtime::Abi for SCRIPT_VISATTR {
    type Abi = Self;
    type DefaultType = Self;
}
pub const SCS_CAP_COMPSTR: u32 = 1u32;
pub const SCS_CAP_MAKEREAD: u32 = 2u32;
pub const SCS_CAP_SETRECONVERTSTRING: u32 = 4u32;
pub const SELECT_CAP_CONVERSION: u32 = 1u32;
pub const SELECT_CAP_SENTENCE: u32 = 2u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SET_COMPOSITION_STRING_TYPE(pub u32);
pub const SCS_SETSTR: SET_COMPOSITION_STRING_TYPE = SET_COMPOSITION_STRING_TYPE(9u32);
pub const SCS_CHANGEATTR: SET_COMPOSITION_STRING_TYPE = SET_COMPOSITION_STRING_TYPE(18u32);
pub const SCS_CHANGECLAUSE: SET_COMPOSITION_STRING_TYPE = SET_COMPOSITION_STRING_TYPE(36u32);
pub const SCS_SETRECONVERTSTRING: SET_COMPOSITION_STRING_TYPE =
    SET_COMPOSITION_STRING_TYPE(65536u32);
pub const SCS_QUERYRECONVERTSTRING: SET_COMPOSITION_STRING_TYPE =
    SET_COMPOSITION_STRING_TYPE(131072u32);
impl ::std::convert::From<u32> for SET_COMPOSITION_STRING_TYPE {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SET_COMPOSITION_STRING_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for SET_COMPOSITION_STRING_TYPE {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for SET_COMPOSITION_STRING_TYPE {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for SET_COMPOSITION_STRING_TYPE {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for SET_COMPOSITION_STRING_TYPE {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for SET_COMPOSITION_STRING_TYPE {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const SGCM_RTL: u32 = 1u32;
pub const SHOWIMEPAD_CATEGORY: u32 = 1u32;
pub const SHOWIMEPAD_DEFAULT: u32 = 0u32;
pub const SHOWIMEPAD_GUID: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct SOFTKBDDATA {
    pub uCount: u32,
    pub wCode: [u16; 256],
}
impl SOFTKBDDATA {}
impl ::std::default::Default for SOFTKBDDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for SOFTKBDDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("SOFTKBDDATA")
            .field("uCount", &self.uCount)
            .field("wCode", &self.wCode)
            .finish()
    }
}
impl ::std::cmp::PartialEq for SOFTKBDDATA {
    fn eq(&self, other: &Self) -> bool {
        self.uCount == other.uCount && self.wCode == other.wCode
    }
}
impl ::std::cmp::Eq for SOFTKBDDATA {}
unsafe impl ::windows::runtime::Abi for SOFTKBDDATA {
    type Abi = Self;
    type DefaultType = Self;
}
pub const SOFTKEYBOARD_TYPE_C1: u32 = 2u32;
pub const SOFTKEYBOARD_TYPE_T1: u32 = 1u32;
pub const SORTING_PARADIGM_ICU: u32 = 16777216u32;
pub const SORTING_PARADIGM_NLS: u32 = 0u32;
pub const SSA_BREAK: u32 = 64u32;
pub const SSA_CLIP: u32 = 4u32;
pub const SSA_DONTGLYPH: u32 = 1073741824u32;
pub const SSA_DZWG: u32 = 16u32;
pub const SSA_FALLBACK: u32 = 32u32;
pub const SSA_FIT: u32 = 8u32;
pub const SSA_FULLMEASURE: u32 = 67108864u32;
pub const SSA_GCP: u32 = 512u32;
pub const SSA_GLYPHS: u32 = 128u32;
pub const SSA_HIDEHOTKEY: u32 = 8192u32;
pub const SSA_HOTKEY: u32 = 1024u32;
pub const SSA_HOTKEYONLY: u32 = 9216u32;
pub const SSA_LAYOUTRTL: u32 = 536870912u32;
pub const SSA_LINK: u32 = 4096u32;
pub const SSA_LPKANSIFALLBACK: u32 = 134217728u32;
pub const SSA_METAFILE: u32 = 2048u32;
pub const SSA_NOKASHIDA: u32 = 2147483648u32;
pub const SSA_PASSWORD: u32 = 1u32;
pub const SSA_PIDX: u32 = 268435456u32;
pub const SSA_RTL: u32 = 256u32;
pub const SSA_TAB: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_SystemServices")]
pub struct STYLEBUFA {
    pub dwStyle: u32,
    pub szDescription: [super::System::SystemServices::CHAR; 32],
}
#[cfg(feature = "Win32_System_SystemServices")]
impl STYLEBUFA {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::default::Default for STYLEBUFA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::fmt::Debug for STYLEBUFA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("STYLEBUFA")
            .field("dwStyle", &self.dwStyle)
            .field("szDescription", &self.szDescription)
            .finish()
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::PartialEq for STYLEBUFA {
    fn eq(&self, other: &Self) -> bool {
        self.dwStyle == other.dwStyle && self.szDescription == other.szDescription
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::Eq for STYLEBUFA {}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::runtime::Abi for STYLEBUFA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct STYLEBUFW {
    pub dwStyle: u32,
    pub szDescription: [u16; 32],
}
impl STYLEBUFW {}
impl ::std::default::Default for STYLEBUFW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for STYLEBUFW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("STYLEBUFW")
            .field("dwStyle", &self.dwStyle)
            .field("szDescription", &self.szDescription)
            .finish()
    }
}
impl ::std::cmp::PartialEq for STYLEBUFW {
    fn eq(&self, other: &Self) -> bool {
        self.dwStyle == other.dwStyle && self.szDescription == other.szDescription
    }
}
impl ::std::cmp::Eq for STYLEBUFW {}
unsafe impl ::windows::runtime::Abi for STYLEBUFW {
    type Abi = Self;
    type DefaultType = Self;
}
pub const STYLE_DESCRIPTION_SIZE: u32 = 32u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SYSGEOCLASS(pub i32);
pub const GEOCLASS_NATION: SYSGEOCLASS = SYSGEOCLASS(16i32);
pub const GEOCLASS_REGION: SYSGEOCLASS = SYSGEOCLASS(14i32);
pub const GEOCLASS_ALL: SYSGEOCLASS = SYSGEOCLASS(0i32);
impl ::std::convert::From<i32> for SYSGEOCLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SYSGEOCLASS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SYSGEOTYPE(pub i32);
pub const GEO_NATION: SYSGEOTYPE = SYSGEOTYPE(1i32);
pub const GEO_LATITUDE: SYSGEOTYPE = SYSGEOTYPE(2i32);
pub const GEO_LONGITUDE: SYSGEOTYPE = SYSGEOTYPE(3i32);
pub const GEO_ISO2: SYSGEOTYPE = SYSGEOTYPE(4i32);
pub const GEO_ISO3: SYSGEOTYPE = SYSGEOTYPE(5i32);
pub const GEO_RFC1766: SYSGEOTYPE = SYSGEOTYPE(6i32);
pub const GEO_LCID: SYSGEOTYPE = SYSGEOTYPE(7i32);
pub const GEO_FRIENDLYNAME: SYSGEOTYPE = SYSGEOTYPE(8i32);
pub const GEO_OFFICIALNAME: SYSGEOTYPE = SYSGEOTYPE(9i32);
pub const GEO_TIMEZONES: SYSGEOTYPE = SYSGEOTYPE(10i32);
pub const GEO_OFFICIALLANGUAGES: SYSGEOTYPE = SYSGEOTYPE(11i32);
pub const GEO_ISO_UN_NUMBER: SYSGEOTYPE = SYSGEOTYPE(12i32);
pub const GEO_PARENT: SYSGEOTYPE = SYSGEOTYPE(13i32);
pub const GEO_DIALINGCODE: SYSGEOTYPE = SYSGEOTYPE(14i32);
pub const GEO_CURRENCYCODE: SYSGEOTYPE = SYSGEOTYPE(15i32);
pub const GEO_CURRENCYSYMBOL: SYSGEOTYPE = SYSGEOTYPE(16i32);
pub const GEO_NAME: SYSGEOTYPE = SYSGEOTYPE(17i32);
pub const GEO_ID: SYSGEOTYPE = SYSGEOTYPE(18i32);
impl ::std::convert::From<i32> for SYSGEOTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SYSGEOTYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct SYSNLS_FUNCTION(pub i32);
pub const COMPARE_STRING: SYSNLS_FUNCTION = SYSNLS_FUNCTION(1i32);
impl ::std::convert::From<i32> for SYSNLS_FUNCTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for SYSNLS_FUNCTION {
    type Abi = Self;
    type DefaultType = Self;
}
pub unsafe fn ScriptApplyDigitSubstitution(
    psds: *const SCRIPT_DIGITSUBSTITUTE,
    psc: *mut SCRIPT_CONTROL,
    pss: *mut SCRIPT_STATE,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptApplyDigitSubstitution(
                psds: *const SCRIPT_DIGITSUBSTITUTE,
                psc: *mut SCRIPT_CONTROL,
                pss: *mut SCRIPT_STATE,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptApplyDigitSubstitution(
            ::std::mem::transmute(psds),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(pss),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptApplyLogicalWidth(
    pidx: *const i32,
    cchars: i32,
    cglyphs: i32,
    pwlogclust: *const u16,
    psva: *const SCRIPT_VISATTR,
    piadvance: *const i32,
    psa: *const SCRIPT_ANALYSIS,
    pabc: *mut super::Graphics::Gdi::ABC,
    pijustify: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptApplyLogicalWidth(
                pidx: *const i32,
                cchars: i32,
                cglyphs: i32,
                pwlogclust: *const u16,
                psva: *const SCRIPT_VISATTR,
                piadvance: *const i32,
                psa: *const SCRIPT_ANALYSIS,
                pabc: *mut super::Graphics::Gdi::ABC,
                pijustify: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptApplyLogicalWidth(
            ::std::mem::transmute(pidx),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(psva),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(pabc),
            ::std::mem::transmute(pijustify),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ScriptBreak<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    pwcchars: Param0,
    cchars: i32,
    psa: *const SCRIPT_ANALYSIS,
) -> ::windows::runtime::Result<SCRIPT_LOGATTR> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptBreak(
                pwcchars: super::Foundation::PWSTR,
                cchars: i32,
                psa: *const SCRIPT_ANALYSIS,
                psla: *mut SCRIPT_LOGATTR,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <SCRIPT_LOGATTR as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ScriptBreak(
            pwcchars.into_param().abi(),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(psa),
            &mut result__,
        )
        .from_abi::<SCRIPT_LOGATTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ScriptCPtoX<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
>(
    icp: i32,
    ftrailing: Param1,
    cchars: i32,
    cglyphs: i32,
    pwlogclust: *const u16,
    psva: *const SCRIPT_VISATTR,
    piadvance: *const i32,
    psa: *const SCRIPT_ANALYSIS,
    pix: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptCPtoX(
                icp: i32,
                ftrailing: super::Foundation::BOOL,
                cchars: i32,
                cglyphs: i32,
                pwlogclust: *const u16,
                psva: *const SCRIPT_VISATTR,
                piadvance: *const i32,
                psa: *const SCRIPT_ANALYSIS,
                pix: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptCPtoX(
            ::std::mem::transmute(icp),
            ftrailing.into_param().abi(),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(psva),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(pix),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptCacheGetHeight<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    tmheight: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptCacheGetHeight(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                tmheight: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptCacheGetHeight(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(tmheight),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptFreeCache(psc: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptFreeCache(psc: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        ScriptFreeCache(::std::mem::transmute(psc)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ScriptGetCMap<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    pwcinchars: Param2,
    cchars: i32,
    dwflags: u32,
    pwoutglyphs: *mut u16,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetCMap(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                pwcinchars: super::Foundation::PWSTR,
                cchars: i32,
                dwflags: u32,
                pwoutglyphs: *mut u16,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetCMap(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            pwcinchars.into_param().abi(),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pwoutglyphs),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptGetFontAlternateGlyphs<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *const SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    tagfeature: u32,
    wglyphid: u16,
    cmaxalternates: i32,
    palternateglyphs: *mut u16,
    pcalternates: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontAlternateGlyphs(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *const SCRIPT_ANALYSIS,
                tagscript: u32,
                taglangsys: u32,
                tagfeature: u32,
                wglyphid: u16,
                cmaxalternates: i32,
                palternateglyphs: *mut u16,
                pcalternates: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontAlternateGlyphs(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(tagfeature),
            ::std::mem::transmute(wglyphid),
            ::std::mem::transmute(cmaxalternates),
            ::std::mem::transmute(palternateglyphs),
            ::std::mem::transmute(pcalternates),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptGetFontFeatureTags<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *const SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    cmaxtags: i32,
    pfeaturetags: *mut u32,
    pctags: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontFeatureTags(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *const SCRIPT_ANALYSIS,
                tagscript: u32,
                taglangsys: u32,
                cmaxtags: i32,
                pfeaturetags: *mut u32,
                pctags: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontFeatureTags(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(cmaxtags),
            ::std::mem::transmute(pfeaturetags),
            ::std::mem::transmute(pctags),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptGetFontLanguageTags<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *const SCRIPT_ANALYSIS,
    tagscript: u32,
    cmaxtags: i32,
    plangsystags: *mut u32,
    pctags: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontLanguageTags(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *const SCRIPT_ANALYSIS,
                tagscript: u32,
                cmaxtags: i32,
                plangsystags: *mut u32,
                pctags: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontLanguageTags(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(cmaxtags),
            ::std::mem::transmute(plangsystags),
            ::std::mem::transmute(pctags),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptGetFontProperties<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    sfp: *mut SCRIPT_FONTPROPERTIES,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontProperties(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                sfp: *mut SCRIPT_FONTPROPERTIES,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontProperties(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(sfp),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptGetFontScriptTags<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *const SCRIPT_ANALYSIS,
    cmaxtags: i32,
    pscripttags: *mut u32,
    pctags: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetFontScriptTags(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *const SCRIPT_ANALYSIS,
                cmaxtags: i32,
                pscripttags: *mut u32,
                pctags: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetFontScriptTags(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(cmaxtags),
            ::std::mem::transmute(pscripttags),
            ::std::mem::transmute(pctags),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptGetGlyphABCWidth<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    wglyph: u16,
    pabc: *mut super::Graphics::Gdi::ABC,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetGlyphABCWidth(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                wglyph: u16,
                pabc: *mut super::Graphics::Gdi::ABC,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetGlyphABCWidth(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(wglyph),
            ::std::mem::transmute(pabc),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptGetLogicalWidths(
    psa: *const SCRIPT_ANALYSIS,
    cchars: i32,
    cglyphs: i32,
    piglyphwidth: *const i32,
    pwlogclust: *const u16,
    psva: *const SCRIPT_VISATTR,
    pidx: *const i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetLogicalWidths(
                psa: *const SCRIPT_ANALYSIS,
                cchars: i32,
                cglyphs: i32,
                piglyphwidth: *const i32,
                pwlogclust: *const u16,
                psva: *const SCRIPT_VISATTR,
                pidx: *const i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetLogicalWidths(
            ::std::mem::transmute(psa),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(piglyphwidth),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(psva),
            ::std::mem::transmute(pidx),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptGetProperties(
    ppsp: *mut *mut *mut SCRIPT_PROPERTIES,
    pinumscripts: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptGetProperties(
                ppsp: *mut *mut *mut SCRIPT_PROPERTIES,
                pinumscripts: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptGetProperties(
            ::std::mem::transmute(ppsp),
            ::std::mem::transmute(pinumscripts),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ScriptIsComplex<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    pwcinchars: Param0,
    cinchars: i32,
    dwflags: SCRIPT_IS_COMPLEX_FLAGS,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptIsComplex(
                pwcinchars: super::Foundation::PWSTR,
                cinchars: i32,
                dwflags: SCRIPT_IS_COMPLEX_FLAGS,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptIsComplex(
            pwcinchars.into_param().abi(),
            ::std::mem::transmute(cinchars),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ScriptItemize<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    pwcinchars: Param0,
    cinchars: i32,
    cmaxitems: i32,
    pscontrol: *const SCRIPT_CONTROL,
    psstate: *const SCRIPT_STATE,
    pitems: *mut SCRIPT_ITEM,
    pcitems: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptItemize(
                pwcinchars: super::Foundation::PWSTR,
                cinchars: i32,
                cmaxitems: i32,
                pscontrol: *const SCRIPT_CONTROL,
                psstate: *const SCRIPT_STATE,
                pitems: *mut SCRIPT_ITEM,
                pcitems: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptItemize(
            pwcinchars.into_param().abi(),
            ::std::mem::transmute(cinchars),
            ::std::mem::transmute(cmaxitems),
            ::std::mem::transmute(pscontrol),
            ::std::mem::transmute(psstate),
            ::std::mem::transmute(pitems),
            ::std::mem::transmute(pcitems),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ScriptItemizeOpenType<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    pwcinchars: Param0,
    cinchars: i32,
    cmaxitems: i32,
    pscontrol: *const SCRIPT_CONTROL,
    psstate: *const SCRIPT_STATE,
    pitems: *mut SCRIPT_ITEM,
    pscripttags: *mut u32,
    pcitems: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptItemizeOpenType(
                pwcinchars: super::Foundation::PWSTR,
                cinchars: i32,
                cmaxitems: i32,
                pscontrol: *const SCRIPT_CONTROL,
                psstate: *const SCRIPT_STATE,
                pitems: *mut SCRIPT_ITEM,
                pscripttags: *mut u32,
                pcitems: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptItemizeOpenType(
            pwcinchars.into_param().abi(),
            ::std::mem::transmute(cinchars),
            ::std::mem::transmute(cmaxitems),
            ::std::mem::transmute(pscontrol),
            ::std::mem::transmute(psstate),
            ::std::mem::transmute(pitems),
            ::std::mem::transmute(pscripttags),
            ::std::mem::transmute(pcitems),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptJustify(
    psva: *const SCRIPT_VISATTR,
    piadvance: *const i32,
    cglyphs: i32,
    idx: i32,
    iminkashida: i32,
) -> ::windows::runtime::Result<i32> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptJustify(
                psva: *const SCRIPT_VISATTR,
                piadvance: *const i32,
                cglyphs: i32,
                idx: i32,
                iminkashida: i32,
                pijustify: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ScriptJustify(
            ::std::mem::transmute(psva),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(idx),
            ::std::mem::transmute(iminkashida),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptLayout(
    cruns: i32,
    pblevel: *const u8,
    pivisualtological: *mut i32,
    pilogicaltovisual: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptLayout(
                cruns: i32,
                pblevel: *const u8,
                pivisualtological: *mut i32,
                pilogicaltovisual: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptLayout(
            ::std::mem::transmute(cruns),
            ::std::mem::transmute(pblevel),
            ::std::mem::transmute(pivisualtological),
            ::std::mem::transmute(pilogicaltovisual),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptPlace<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    pwglyphs: *const u16,
    cglyphs: i32,
    psva: *const SCRIPT_VISATTR,
    psa: *mut SCRIPT_ANALYSIS,
    piadvance: *mut i32,
    pgoffset: *mut GOFFSET,
    pabc: *mut super::Graphics::Gdi::ABC,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptPlace(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                pwglyphs: *const u16,
                cglyphs: i32,
                psva: *const SCRIPT_VISATTR,
                psa: *mut SCRIPT_ANALYSIS,
                piadvance: *mut i32,
                pgoffset: *mut GOFFSET,
                pabc: *mut super::Graphics::Gdi::ABC,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptPlace(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(pwglyphs),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(psva),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(pgoffset),
            ::std::mem::transmute(pabc),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ScriptPlaceOpenType<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    Param8: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *mut SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    rcrangechars: *const i32,
    rprangeproperties: *const *const textrange_properties,
    cranges: i32,
    pwcchars: Param8,
    pwlogclust: *const u16,
    pcharprops: *const script_charprop,
    cchars: i32,
    pwglyphs: *const u16,
    pglyphprops: *const script_glyphprop,
    cglyphs: i32,
    piadvance: *mut i32,
    pgoffset: *mut GOFFSET,
    pabc: *mut super::Graphics::Gdi::ABC,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptPlaceOpenType(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *mut SCRIPT_ANALYSIS,
                tagscript: u32,
                taglangsys: u32,
                rcrangechars: *const i32,
                rprangeproperties: *const *const textrange_properties,
                cranges: i32,
                pwcchars: super::Foundation::PWSTR,
                pwlogclust: *const u16,
                pcharprops: *const script_charprop,
                cchars: i32,
                pwglyphs: *const u16,
                pglyphprops: *const script_glyphprop,
                cglyphs: i32,
                piadvance: *mut i32,
                pgoffset: *mut GOFFSET,
                pabc: *mut super::Graphics::Gdi::ABC,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptPlaceOpenType(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(rcrangechars),
            ::std::mem::transmute(rprangeproperties),
            ::std::mem::transmute(cranges),
            pwcchars.into_param().abi(),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(pcharprops),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(pwglyphs),
            ::std::mem::transmute(pglyphprops),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(pgoffset),
            ::std::mem::transmute(pabc),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptPositionSingleGlyph<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    Param9: ::windows::runtime::IntoParam<'a, GOFFSET>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *const SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    tagfeature: u32,
    lparameter: i32,
    wglyphid: u16,
    iadvance: i32,
    goffset: Param9,
    pioutadvance: *mut i32,
    poutgoffset: *mut GOFFSET,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptPositionSingleGlyph(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *const SCRIPT_ANALYSIS,
                tagscript: u32,
                taglangsys: u32,
                tagfeature: u32,
                lparameter: i32,
                wglyphid: u16,
                iadvance: i32,
                goffset: GOFFSET,
                pioutadvance: *mut i32,
                poutgoffset: *mut GOFFSET,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptPositionSingleGlyph(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(tagfeature),
            ::std::mem::transmute(lparameter),
            ::std::mem::transmute(wglyphid),
            ::std::mem::transmute(iadvance),
            goffset.into_param().abi(),
            ::std::mem::transmute(pioutadvance),
            ::std::mem::transmute(poutgoffset),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptRecordDigitSubstitution(
    locale: u32,
) -> ::windows::runtime::Result<SCRIPT_DIGITSUBSTITUTE> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptRecordDigitSubstitution(
                locale: u32,
                psds: *mut SCRIPT_DIGITSUBSTITUTE,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <SCRIPT_DIGITSUBSTITUTE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        ScriptRecordDigitSubstitution(::std::mem::transmute(locale), &mut result__)
            .from_abi::<SCRIPT_DIGITSUBSTITUTE>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ScriptShape<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    pwcchars: Param2,
    cchars: i32,
    cmaxglyphs: i32,
    psa: *mut SCRIPT_ANALYSIS,
    pwoutglyphs: *mut u16,
    pwlogclust: *mut u16,
    psva: *mut SCRIPT_VISATTR,
    pcglyphs: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptShape(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                pwcchars: super::Foundation::PWSTR,
                cchars: i32,
                cmaxglyphs: i32,
                psa: *mut SCRIPT_ANALYSIS,
                pwoutglyphs: *mut u16,
                pwlogclust: *mut u16,
                psva: *mut SCRIPT_VISATTR,
                pcglyphs: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptShape(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            pwcchars.into_param().abi(),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cmaxglyphs),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(pwoutglyphs),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(psva),
            ::std::mem::transmute(pcglyphs),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ScriptShapeOpenType<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    Param8: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *mut SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    rcrangechars: *const i32,
    rprangeproperties: *const *const textrange_properties,
    cranges: i32,
    pwcchars: Param8,
    cchars: i32,
    cmaxglyphs: i32,
    pwlogclust: *mut u16,
    pcharprops: *mut script_charprop,
    pwoutglyphs: *mut u16,
    poutglyphprops: *mut script_glyphprop,
    pcglyphs: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptShapeOpenType(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *mut SCRIPT_ANALYSIS,
                tagscript: u32,
                taglangsys: u32,
                rcrangechars: *const i32,
                rprangeproperties: *const *const textrange_properties,
                cranges: i32,
                pwcchars: super::Foundation::PWSTR,
                cchars: i32,
                cmaxglyphs: i32,
                pwlogclust: *mut u16,
                pcharprops: *mut script_charprop,
                pwoutglyphs: *mut u16,
                poutglyphprops: *mut script_glyphprop,
                pcglyphs: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptShapeOpenType(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(rcrangechars),
            ::std::mem::transmute(rprangeproperties),
            ::std::mem::transmute(cranges),
            pwcchars.into_param().abi(),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cmaxglyphs),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(pcharprops),
            ::std::mem::transmute(pwoutglyphs),
            ::std::mem::transmute(poutglyphprops),
            ::std::mem::transmute(pcglyphs),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptStringAnalyse<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    pstring: *const ::std::ffi::c_void,
    cstring: i32,
    cglyphs: i32,
    icharset: i32,
    dwflags: u32,
    ireqwidth: i32,
    pscontrol: *const SCRIPT_CONTROL,
    psstate: *const SCRIPT_STATE,
    pidx: *const i32,
    ptabdef: *const SCRIPT_TABDEF,
    pbinclass: *const u8,
    pssa: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringAnalyse(
                hdc: super::Graphics::Gdi::HDC,
                pstring: *const ::std::ffi::c_void,
                cstring: i32,
                cglyphs: i32,
                icharset: i32,
                dwflags: u32,
                ireqwidth: i32,
                pscontrol: *const SCRIPT_CONTROL,
                psstate: *const SCRIPT_STATE,
                pidx: *const i32,
                ptabdef: *const SCRIPT_TABDEF,
                pbinclass: *const u8,
                pssa: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptStringAnalyse(
            hdc.into_param().abi(),
            ::std::mem::transmute(pstring),
            ::std::mem::transmute(cstring),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(icharset),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(ireqwidth),
            ::std::mem::transmute(pscontrol),
            ::std::mem::transmute(psstate),
            ::std::mem::transmute(pidx),
            ::std::mem::transmute(ptabdef),
            ::std::mem::transmute(pbinclass),
            ::std::mem::transmute(pssa),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ScriptStringCPtoX<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
>(
    ssa: *const ::std::ffi::c_void,
    icp: i32,
    ftrailing: Param2,
) -> ::windows::runtime::Result<i32> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringCPtoX(
                ssa: *const ::std::ffi::c_void,
                icp: i32,
                ftrailing: super::Foundation::BOOL,
                px: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        ScriptStringCPtoX(
            ::std::mem::transmute(ssa),
            ::std::mem::transmute(icp),
            ftrailing.into_param().abi(),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptStringFree(
    pssa: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringFree(pssa: *mut *mut ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        ScriptStringFree(::std::mem::transmute(pssa)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptStringGetLogicalWidths(
    ssa: *const ::std::ffi::c_void,
    pidx: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringGetLogicalWidths(
                ssa: *const ::std::ffi::c_void,
                pidx: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptStringGetLogicalWidths(::std::mem::transmute(ssa), ::std::mem::transmute(pidx)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptStringGetOrder(
    ssa: *const ::std::ffi::c_void,
    puorder: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringGetOrder(
                ssa: *const ::std::ffi::c_void,
                puorder: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptStringGetOrder(::std::mem::transmute(ssa), ::std::mem::transmute(puorder)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ScriptStringOut<
    'a,
    Param7: ::windows::runtime::IntoParam<'a, super::Foundation::BOOL>,
>(
    ssa: *const ::std::ffi::c_void,
    ix: i32,
    iy: i32,
    uoptions: super::Graphics::Gdi::ETO_OPTIONS,
    prc: *const super::Foundation::RECT,
    iminsel: i32,
    imaxsel: i32,
    fdisabled: Param7,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringOut(
                ssa: *const ::std::ffi::c_void,
                ix: i32,
                iy: i32,
                uoptions: super::Graphics::Gdi::ETO_OPTIONS,
                prc: *const super::Foundation::RECT,
                iminsel: i32,
                imaxsel: i32,
                fdisabled: super::Foundation::BOOL,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptStringOut(
            ::std::mem::transmute(ssa),
            ::std::mem::transmute(ix),
            ::std::mem::transmute(iy),
            ::std::mem::transmute(uoptions),
            ::std::mem::transmute(prc),
            ::std::mem::transmute(iminsel),
            ::std::mem::transmute(imaxsel),
            fdisabled.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptStringValidate(
    ssa: *const ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringValidate(ssa: *const ::std::ffi::c_void) -> ::windows::runtime::HRESULT;
        }
        ScriptStringValidate(::std::mem::transmute(ssa)).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptStringXtoCP(
    ssa: *const ::std::ffi::c_void,
    ix: i32,
    pich: *mut i32,
    pitrailing: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptStringXtoCP(
                ssa: *const ::std::ffi::c_void,
                ix: i32,
                pich: *mut i32,
                pitrailing: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptStringXtoCP(
            ::std::mem::transmute(ssa),
            ::std::mem::transmute(ix),
            ::std::mem::transmute(pich),
            ::std::mem::transmute(pitrailing),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptString_pLogAttr(ssa: *const ::std::ffi::c_void) -> *mut SCRIPT_LOGATTR {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptString_pLogAttr(ssa: *const ::std::ffi::c_void) -> *mut SCRIPT_LOGATTR;
        }
        ::std::mem::transmute(ScriptString_pLogAttr(::std::mem::transmute(ssa)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ScriptString_pSize(ssa: *const ::std::ffi::c_void) -> *mut super::Foundation::SIZE {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptString_pSize(ssa: *const ::std::ffi::c_void) -> *mut super::Foundation::SIZE;
        }
        ::std::mem::transmute(ScriptString_pSize(::std::mem::transmute(ssa)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptString_pcOutChars(ssa: *const ::std::ffi::c_void) -> *mut i32 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptString_pcOutChars(ssa: *const ::std::ffi::c_void) -> *mut i32;
        }
        ::std::mem::transmute(ScriptString_pcOutChars(::std::mem::transmute(ssa)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn ScriptSubstituteSingleGlyph<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    psa: *const SCRIPT_ANALYSIS,
    tagscript: u32,
    taglangsys: u32,
    tagfeature: u32,
    lparameter: i32,
    wglyphid: u16,
    pwoutglyphid: *mut u16,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptSubstituteSingleGlyph(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                psa: *const SCRIPT_ANALYSIS,
                tagscript: u32,
                taglangsys: u32,
                tagfeature: u32,
                lparameter: i32,
                wglyphid: u16,
                pwoutglyphid: *mut u16,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptSubstituteSingleGlyph(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(tagscript),
            ::std::mem::transmute(taglangsys),
            ::std::mem::transmute(tagfeature),
            ::std::mem::transmute(lparameter),
            ::std::mem::transmute(wglyphid),
            ::std::mem::transmute(pwoutglyphid),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn ScriptTextOut<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Graphics::Gdi::HDC>,
    Param7: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    hdc: Param0,
    psc: *mut *mut ::std::ffi::c_void,
    x: i32,
    y: i32,
    fuoptions: u32,
    lprc: *const super::Foundation::RECT,
    psa: *const SCRIPT_ANALYSIS,
    pwcreserved: Param7,
    ireserved: i32,
    pwglyphs: *const u16,
    cglyphs: i32,
    piadvance: *const i32,
    pijustify: *const i32,
    pgoffset: *const GOFFSET,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptTextOut(
                hdc: super::Graphics::Gdi::HDC,
                psc: *mut *mut ::std::ffi::c_void,
                x: i32,
                y: i32,
                fuoptions: u32,
                lprc: *const super::Foundation::RECT,
                psa: *const SCRIPT_ANALYSIS,
                pwcreserved: super::Foundation::PWSTR,
                ireserved: i32,
                pwglyphs: *const u16,
                cglyphs: i32,
                piadvance: *const i32,
                pijustify: *const i32,
                pgoffset: *const GOFFSET,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptTextOut(
            hdc.into_param().abi(),
            ::std::mem::transmute(psc),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            ::std::mem::transmute(fuoptions),
            ::std::mem::transmute(lprc),
            ::std::mem::transmute(psa),
            pwcreserved.into_param().abi(),
            ::std::mem::transmute(ireserved),
            ::std::mem::transmute(pwglyphs),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(pijustify),
            ::std::mem::transmute(pgoffset),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ScriptXtoCP(
    ix: i32,
    cchars: i32,
    cglyphs: i32,
    pwlogclust: *const u16,
    psva: *const SCRIPT_VISATTR,
    piadvance: *const i32,
    psa: *const SCRIPT_ANALYSIS,
    picp: *mut i32,
    pitrailing: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn ScriptXtoCP(
                ix: i32,
                cchars: i32,
                cglyphs: i32,
                pwlogclust: *const u16,
                psva: *const SCRIPT_VISATTR,
                piadvance: *const i32,
                psa: *const SCRIPT_ANALYSIS,
                picp: *mut i32,
                pitrailing: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        ScriptXtoCP(
            ::std::mem::transmute(ix),
            ::std::mem::transmute(cchars),
            ::std::mem::transmute(cglyphs),
            ::std::mem::transmute(pwlogclust),
            ::std::mem::transmute(psva),
            ::std::mem::transmute(piadvance),
            ::std::mem::transmute(psa),
            ::std::mem::transmute(picp),
            ::std::mem::transmute(pitrailing),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetCalendarInfoA<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    calendar: u32,
    caltype: u32,
    lpcaldata: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetCalendarInfoA(
                locale: u32,
                calendar: u32,
                caltype: u32,
                lpcaldata: super::Foundation::PSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetCalendarInfoA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
            lpcaldata.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetCalendarInfoW<
    'a,
    Param3: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    calendar: u32,
    caltype: u32,
    lpcaldata: Param3,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetCalendarInfoW(
                locale: u32,
                calendar: u32,
                caltype: u32,
                lpcaldata: super::Foundation::PWSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetCalendarInfoW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(calendar),
            ::std::mem::transmute(caltype),
            lpcaldata.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetLocaleInfoA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    locale: u32,
    lctype: u32,
    lplcdata: Param2,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetLocaleInfoA(
                locale: u32,
                lctype: u32,
                lplcdata: super::Foundation::PSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetLocaleInfoA(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(lctype),
            lplcdata.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetLocaleInfoW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    locale: u32,
    lctype: u32,
    lplcdata: Param2,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetLocaleInfoW(
                locale: u32,
                lctype: u32,
                lplcdata: super::Foundation::PWSTR,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetLocaleInfoW(
            ::std::mem::transmute(locale),
            ::std::mem::transmute(lctype),
            lplcdata.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetProcessPreferredUILanguages<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    pwszlanguagesbuffer: Param1,
    pulnumlanguages: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetProcessPreferredUILanguages(
                dwflags: u32,
                pwszlanguagesbuffer: super::Foundation::PWSTR,
                pulnumlanguages: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetProcessPreferredUILanguages(
            ::std::mem::transmute(dwflags),
            pwszlanguagesbuffer.into_param().abi(),
            ::std::mem::transmute(pulnumlanguages),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetThreadLocale(locale: u32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadLocale(locale: u32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetThreadLocale(::std::mem::transmute(locale)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetThreadPreferredUILanguages<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    dwflags: u32,
    pwszlanguagesbuffer: Param1,
    pulnumlanguages: *mut u32,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadPreferredUILanguages(
                dwflags: u32,
                pwszlanguagesbuffer: super::Foundation::PWSTR,
                pulnumlanguages: *mut u32,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetThreadPreferredUILanguages(
            ::std::mem::transmute(dwflags),
            pwszlanguagesbuffer.into_param().abi(),
            ::std::mem::transmute(pulnumlanguages),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetThreadPreferredUILanguages2<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    flags: u32,
    languages: Param1,
    numlanguagesset: *mut u32,
    snapshot: *mut HSAVEDUILANGUAGES,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadPreferredUILanguages2(
                flags: u32,
                languages: super::Foundation::PWSTR,
                numlanguagesset: *mut u32,
                snapshot: *mut HSAVEDUILANGUAGES,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetThreadPreferredUILanguages2(
            ::std::mem::transmute(flags),
            languages.into_param().abi(),
            ::std::mem::transmute(numlanguagesset),
            ::std::mem::transmute(snapshot),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn SetThreadUILanguage(langid: u16) -> u16 {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetThreadUILanguage(langid: u16) -> u16;
        }
        ::std::mem::transmute(SetThreadUILanguage(::std::mem::transmute(langid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetUserGeoID(geoid: i32) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetUserGeoID(geoid: i32) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetUserGeoID(::std::mem::transmute(geoid)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetUserGeoName<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Foundation::PWSTR>,
>(
    geoname: Param0,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn SetUserGeoName(geoname: super::Foundation::PWSTR) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetUserGeoName(geoname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const SpellCheckerFactory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2058577491,
    6038,
    18507,
    [189, 250, 231, 79, 29, 183, 193, 220],
);
#[cfg(feature = "Win32_Foundation")]
pub type TIMEFMT_ENUMPROCA =
    unsafe extern "system" fn(param0: super::Foundation::PSTR) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type TIMEFMT_ENUMPROCEX = unsafe extern "system" fn(
    param0: super::Foundation::PWSTR,
    param1: super::Foundation::LPARAM,
) -> super::Foundation::BOOL;
#[cfg(feature = "Win32_Foundation")]
pub type TIMEFMT_ENUMPROCW =
    unsafe extern "system" fn(param0: super::Foundation::PWSTR) -> super::Foundation::BOOL;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct TIME_FORMAT_FLAGS(pub u32);
pub const TIME_NOMINUTESORSECONDS: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(1u32);
pub const TIME_NOSECONDS: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(2u32);
pub const TIME_NOTIMEMARKER: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(4u32);
pub const TIME_FORCE24HOURFORMAT: TIME_FORMAT_FLAGS = TIME_FORMAT_FLAGS(8u32);
impl ::std::convert::From<u32> for TIME_FORMAT_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for TIME_FORMAT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for TIME_FORMAT_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for TIME_FORMAT_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for TIME_FORMAT_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct TRANSLATE_CHARSET_INFO_FLAGS(pub u32);
pub const TCI_SRCCHARSET: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(1u32);
pub const TCI_SRCCODEPAGE: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(2u32);
pub const TCI_SRCFONTSIG: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(3u32);
pub const TCI_SRCLOCALE: TRANSLATE_CHARSET_INFO_FLAGS = TRANSLATE_CHARSET_INFO_FLAGS(4096u32);
impl ::std::convert::From<u32> for TRANSLATE_CHARSET_INFO_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for TRANSLATE_CHARSET_INFO_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for TRANSLATE_CHARSET_INFO_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for TRANSLATE_CHARSET_INFO_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for TRANSLATE_CHARSET_INFO_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for TRANSLATE_CHARSET_INFO_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for TRANSLATE_CHARSET_INFO_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct TRANSMSG {
    pub message: u32,
    pub wParam: super::Foundation::WPARAM,
    pub lParam: super::Foundation::LPARAM,
}
#[cfg(feature = "Win32_Foundation")]
impl TRANSMSG {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for TRANSMSG {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for TRANSMSG {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("TRANSMSG")
            .field("message", &self.message)
            .field("wParam", &self.wParam)
            .field("lParam", &self.lParam)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for TRANSMSG {
    fn eq(&self, other: &Self) -> bool {
        self.message == other.message && self.wParam == other.wParam && self.lParam == other.lParam
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for TRANSMSG {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for TRANSMSG {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct TRANSMSGLIST {
    pub uMsgCount: u32,
    pub TransMsg: [TRANSMSG; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl TRANSMSGLIST {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for TRANSMSGLIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for TRANSMSGLIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("TRANSMSGLIST")
            .field("uMsgCount", &self.uMsgCount)
            .field("TransMsg", &self.TransMsg)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for TRANSMSGLIST {
    fn eq(&self, other: &Self) -> bool {
        self.uMsgCount == other.uMsgCount && self.TransMsg == other.TransMsg
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for TRANSMSGLIST {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for TRANSMSGLIST {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn TranslateCharsetInfo(
    lpsrc: *mut u32,
    lpcs: *mut CHARSETINFO,
    dwflags: TRANSLATE_CHARSET_INFO_FLAGS,
) -> super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn TranslateCharsetInfo(
                lpsrc: *mut u32,
                lpcs: *mut CHARSETINFO,
                dwflags: TRANSLATE_CHARSET_INFO_FLAGS,
            ) -> super::Foundation::BOOL;
        }
        ::std::mem::transmute(TranslateCharsetInfo(
            ::std::mem::transmute(lpsrc),
            ::std::mem::transmute(lpcs),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const U16_MAX_LENGTH: u32 = 2u32;
pub const U8_MAX_LENGTH: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UAcceptResult(pub i32);
pub const ULOC_ACCEPT_FAILED: UAcceptResult = UAcceptResult(0i32);
pub const ULOC_ACCEPT_VALID: UAcceptResult = UAcceptResult(1i32);
pub const ULOC_ACCEPT_FALLBACK: UAcceptResult = UAcceptResult(2i32);
impl ::std::convert::From<i32> for UAcceptResult {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UAcceptResult {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UAlphabeticIndexLabelType(pub i32);
pub const U_ALPHAINDEX_NORMAL: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(0i32);
pub const U_ALPHAINDEX_UNDERFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(1i32);
pub const U_ALPHAINDEX_INFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(2i32);
pub const U_ALPHAINDEX_OVERFLOW: UAlphabeticIndexLabelType = UAlphabeticIndexLabelType(3i32);
impl ::std::convert::From<i32> for UAlphabeticIndexLabelType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UAlphabeticIndexLabelType {
    type Abi = Self;
    type DefaultType = Self;
}
pub const UBIDI_DEFAULT_LTR: u32 = 254u32;
pub const UBIDI_DEFAULT_RTL: u32 = 255u32;
pub const UBIDI_DO_MIRRORING: u32 = 2u32;
pub const UBIDI_INSERT_LRM_FOR_NUMERIC: u32 = 4u32;
pub const UBIDI_KEEP_BASE_COMBINING: u32 = 1u32;
pub const UBIDI_LEVEL_OVERRIDE: u32 = 128u32;
pub const UBIDI_MAP_NOWHERE: i32 = -1i32;
pub const UBIDI_MAX_EXPLICIT_LEVEL: u32 = 125u32;
pub const UBIDI_OUTPUT_REVERSE: u32 = 16u32;
pub const UBIDI_REMOVE_BIDI_CONTROLS: u32 = 8u32;
#[repr(C)]
#[derive(
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
)]
pub struct UBiDi(pub u8);
pub type UBiDiClassCallback =
    unsafe extern "system" fn(context: *const ::std::ffi::c_void, c: i32) -> UCharDirection;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBiDiDirection(pub i32);
pub const UBIDI_LTR: UBiDiDirection = UBiDiDirection(0i32);
pub const UBIDI_RTL: UBiDiDirection = UBiDiDirection(1i32);
pub const UBIDI_MIXED: UBiDiDirection = UBiDiDirection(2i32);
pub const UBIDI_NEUTRAL: UBiDiDirection = UBiDiDirection(3i32);
impl ::std::convert::From<i32> for UBiDiDirection {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiDirection {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBiDiMirroring(pub i32);
pub const UBIDI_MIRRORING_OFF: UBiDiMirroring = UBiDiMirroring(0i32);
pub const UBIDI_MIRRORING_ON: UBiDiMirroring = UBiDiMirroring(1i32);
impl ::std::convert::From<i32> for UBiDiMirroring {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiMirroring {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBiDiOrder(pub i32);
pub const UBIDI_LOGICAL: UBiDiOrder = UBiDiOrder(0i32);
pub const UBIDI_VISUAL: UBiDiOrder = UBiDiOrder(1i32);
impl ::std::convert::From<i32> for UBiDiOrder {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiOrder {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBiDiReorderingMode(pub i32);
pub const UBIDI_REORDER_DEFAULT: UBiDiReorderingMode = UBiDiReorderingMode(0i32);
pub const UBIDI_REORDER_NUMBERS_SPECIAL: UBiDiReorderingMode = UBiDiReorderingMode(1i32);
pub const UBIDI_REORDER_GROUP_NUMBERS_WITH_R: UBiDiReorderingMode = UBiDiReorderingMode(2i32);
pub const UBIDI_REORDER_RUNS_ONLY: UBiDiReorderingMode = UBiDiReorderingMode(3i32);
pub const UBIDI_REORDER_INVERSE_NUMBERS_AS_L: UBiDiReorderingMode = UBiDiReorderingMode(4i32);
pub const UBIDI_REORDER_INVERSE_LIKE_DIRECT: UBiDiReorderingMode = UBiDiReorderingMode(5i32);
pub const UBIDI_REORDER_INVERSE_FOR_NUMBERS_SPECIAL: UBiDiReorderingMode =
    UBiDiReorderingMode(6i32);
impl ::std::convert::From<i32> for UBiDiReorderingMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiReorderingMode {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBiDiReorderingOption(pub i32);
pub const UBIDI_OPTION_DEFAULT: UBiDiReorderingOption = UBiDiReorderingOption(0i32);
pub const UBIDI_OPTION_INSERT_MARKS: UBiDiReorderingOption = UBiDiReorderingOption(1i32);
pub const UBIDI_OPTION_REMOVE_CONTROLS: UBiDiReorderingOption = UBiDiReorderingOption(2i32);
pub const UBIDI_OPTION_STREAMING: UBiDiReorderingOption = UBiDiReorderingOption(4i32);
impl ::std::convert::From<i32> for UBiDiReorderingOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBiDiReorderingOption {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(C)]
#[derive(
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
)]
pub struct UBiDiTransform(pub u8);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBidiPairedBracketType(pub i32);
pub const U_BPT_NONE: UBidiPairedBracketType = UBidiPairedBracketType(0i32);
pub const U_BPT_OPEN: UBidiPairedBracketType = UBidiPairedBracketType(1i32);
pub const U_BPT_CLOSE: UBidiPairedBracketType = UBidiPairedBracketType(2i32);
impl ::std::convert::From<i32> for UBidiPairedBracketType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBidiPairedBracketType {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBlockCode(pub i32);
pub const UBLOCK_NO_BLOCK: UBlockCode = UBlockCode(0i32);
pub const UBLOCK_BASIC_LATIN: UBlockCode = UBlockCode(1i32);
pub const UBLOCK_LATIN_1_SUPPLEMENT: UBlockCode = UBlockCode(2i32);
pub const UBLOCK_LATIN_EXTENDED_A: UBlockCode = UBlockCode(3i32);
pub const UBLOCK_LATIN_EXTENDED_B: UBlockCode = UBlockCode(4i32);
pub const UBLOCK_IPA_EXTENSIONS: UBlockCode = UBlockCode(5i32);
pub const UBLOCK_SPACING_MODIFIER_LETTERS: UBlockCode = UBlockCode(6i32);
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS: UBlockCode = UBlockCode(7i32);
pub const UBLOCK_GREEK: UBlockCode = UBlockCode(8i32);
pub const UBLOCK_CYRILLIC: UBlockCode = UBlockCode(9i32);
pub const UBLOCK_ARMENIAN: UBlockCode = UBlockCode(10i32);
pub const UBLOCK_HEBREW: UBlockCode = UBlockCode(11i32);
pub const UBLOCK_ARABIC: UBlockCode = UBlockCode(12i32);
pub const UBLOCK_SYRIAC: UBlockCode = UBlockCode(13i32);
pub const UBLOCK_THAANA: UBlockCode = UBlockCode(14i32);
pub const UBLOCK_DEVANAGARI: UBlockCode = UBlockCode(15i32);
pub const UBLOCK_BENGALI: UBlockCode = UBlockCode(16i32);
pub const UBLOCK_GURMUKHI: UBlockCode = UBlockCode(17i32);
pub const UBLOCK_GUJARATI: UBlockCode = UBlockCode(18i32);
pub const UBLOCK_ORIYA: UBlockCode = UBlockCode(19i32);
pub const UBLOCK_TAMIL: UBlockCode = UBlockCode(20i32);
pub const UBLOCK_TELUGU: UBlockCode = UBlockCode(21i32);
pub const UBLOCK_KANNADA: UBlockCode = UBlockCode(22i32);
pub const UBLOCK_MALAYALAM: UBlockCode = UBlockCode(23i32);
pub const UBLOCK_SINHALA: UBlockCode = UBlockCode(24i32);
pub const UBLOCK_THAI: UBlockCode = UBlockCode(25i32);
pub const UBLOCK_LAO: UBlockCode = UBlockCode(26i32);
pub const UBLOCK_TIBETAN: UBlockCode = UBlockCode(27i32);
pub const UBLOCK_MYANMAR: UBlockCode = UBlockCode(28i32);
pub const UBLOCK_GEORGIAN: UBlockCode = UBlockCode(29i32);
pub const UBLOCK_HANGUL_JAMO: UBlockCode = UBlockCode(30i32);
pub const UBLOCK_ETHIOPIC: UBlockCode = UBlockCode(31i32);
pub const UBLOCK_CHEROKEE: UBlockCode = UBlockCode(32i32);
pub const UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS: UBlockCode = UBlockCode(33i32);
pub const UBLOCK_OGHAM: UBlockCode = UBlockCode(34i32);
pub const UBLOCK_RUNIC: UBlockCode = UBlockCode(35i32);
pub const UBLOCK_KHMER: UBlockCode = UBlockCode(36i32);
pub const UBLOCK_MONGOLIAN: UBlockCode = UBlockCode(37i32);
pub const UBLOCK_LATIN_EXTENDED_ADDITIONAL: UBlockCode = UBlockCode(38i32);
pub const UBLOCK_GREEK_EXTENDED: UBlockCode = UBlockCode(39i32);
pub const UBLOCK_GENERAL_PUNCTUATION: UBlockCode = UBlockCode(40i32);
pub const UBLOCK_SUPERSCRIPTS_AND_SUBSCRIPTS: UBlockCode = UBlockCode(41i32);
pub const UBLOCK_CURRENCY_SYMBOLS: UBlockCode = UBlockCode(42i32);
pub const UBLOCK_COMBINING_MARKS_FOR_SYMBOLS: UBlockCode = UBlockCode(43i32);
pub const UBLOCK_LETTERLIKE_SYMBOLS: UBlockCode = UBlockCode(44i32);
pub const UBLOCK_NUMBER_FORMS: UBlockCode = UBlockCode(45i32);
pub const UBLOCK_ARROWS: UBlockCode = UBlockCode(46i32);
pub const UBLOCK_MATHEMATICAL_OPERATORS: UBlockCode = UBlockCode(47i32);
pub const UBLOCK_MISCELLANEOUS_TECHNICAL: UBlockCode = UBlockCode(48i32);
pub const UBLOCK_CONTROL_PICTURES: UBlockCode = UBlockCode(49i32);
pub const UBLOCK_OPTICAL_CHARACTER_RECOGNITION: UBlockCode = UBlockCode(50i32);
pub const UBLOCK_ENCLOSED_ALPHANUMERICS: UBlockCode = UBlockCode(51i32);
pub const UBLOCK_BOX_DRAWING: UBlockCode = UBlockCode(52i32);
pub const UBLOCK_BLOCK_ELEMENTS: UBlockCode = UBlockCode(53i32);
pub const UBLOCK_GEOMETRIC_SHAPES: UBlockCode = UBlockCode(54i32);
pub const UBLOCK_MISCELLANEOUS_SYMBOLS: UBlockCode = UBlockCode(55i32);
pub const UBLOCK_DINGBATS: UBlockCode = UBlockCode(56i32);
pub const UBLOCK_BRAILLE_PATTERNS: UBlockCode = UBlockCode(57i32);
pub const UBLOCK_CJK_RADICALS_SUPPLEMENT: UBlockCode = UBlockCode(58i32);
pub const UBLOCK_KANGXI_RADICALS: UBlockCode = UBlockCode(59i32);
pub const UBLOCK_IDEOGRAPHIC_DESCRIPTION_CHARACTERS: UBlockCode = UBlockCode(60i32);
pub const UBLOCK_CJK_SYMBOLS_AND_PUNCTUATION: UBlockCode = UBlockCode(61i32);
pub const UBLOCK_HIRAGANA: UBlockCode = UBlockCode(62i32);
pub const UBLOCK_KATAKANA: UBlockCode = UBlockCode(63i32);
pub const UBLOCK_BOPOMOFO: UBlockCode = UBlockCode(64i32);
pub const UBLOCK_HANGUL_COMPATIBILITY_JAMO: UBlockCode = UBlockCode(65i32);
pub const UBLOCK_KANBUN: UBlockCode = UBlockCode(66i32);
pub const UBLOCK_BOPOMOFO_EXTENDED: UBlockCode = UBlockCode(67i32);
pub const UBLOCK_ENCLOSED_CJK_LETTERS_AND_MONTHS: UBlockCode = UBlockCode(68i32);
pub const UBLOCK_CJK_COMPATIBILITY: UBlockCode = UBlockCode(69i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A: UBlockCode = UBlockCode(70i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS: UBlockCode = UBlockCode(71i32);
pub const UBLOCK_YI_SYLLABLES: UBlockCode = UBlockCode(72i32);
pub const UBLOCK_YI_RADICALS: UBlockCode = UBlockCode(73i32);
pub const UBLOCK_HANGUL_SYLLABLES: UBlockCode = UBlockCode(74i32);
pub const UBLOCK_HIGH_SURROGATES: UBlockCode = UBlockCode(75i32);
pub const UBLOCK_HIGH_PRIVATE_USE_SURROGATES: UBlockCode = UBlockCode(76i32);
pub const UBLOCK_LOW_SURROGATES: UBlockCode = UBlockCode(77i32);
pub const UBLOCK_PRIVATE_USE_AREA: UBlockCode = UBlockCode(78i32);
pub const UBLOCK_PRIVATE_USE: UBlockCode = UBlockCode(78i32);
pub const UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS: UBlockCode = UBlockCode(79i32);
pub const UBLOCK_ALPHABETIC_PRESENTATION_FORMS: UBlockCode = UBlockCode(80i32);
pub const UBLOCK_ARABIC_PRESENTATION_FORMS_A: UBlockCode = UBlockCode(81i32);
pub const UBLOCK_COMBINING_HALF_MARKS: UBlockCode = UBlockCode(82i32);
pub const UBLOCK_CJK_COMPATIBILITY_FORMS: UBlockCode = UBlockCode(83i32);
pub const UBLOCK_SMALL_FORM_VARIANTS: UBlockCode = UBlockCode(84i32);
pub const UBLOCK_ARABIC_PRESENTATION_FORMS_B: UBlockCode = UBlockCode(85i32);
pub const UBLOCK_SPECIALS: UBlockCode = UBlockCode(86i32);
pub const UBLOCK_HALFWIDTH_AND_FULLWIDTH_FORMS: UBlockCode = UBlockCode(87i32);
pub const UBLOCK_OLD_ITALIC: UBlockCode = UBlockCode(88i32);
pub const UBLOCK_GOTHIC: UBlockCode = UBlockCode(89i32);
pub const UBLOCK_DESERET: UBlockCode = UBlockCode(90i32);
pub const UBLOCK_BYZANTINE_MUSICAL_SYMBOLS: UBlockCode = UBlockCode(91i32);
pub const UBLOCK_MUSICAL_SYMBOLS: UBlockCode = UBlockCode(92i32);
pub const UBLOCK_MATHEMATICAL_ALPHANUMERIC_SYMBOLS: UBlockCode = UBlockCode(93i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B: UBlockCode = UBlockCode(94i32);
pub const UBLOCK_CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT: UBlockCode = UBlockCode(95i32);
pub const UBLOCK_TAGS: UBlockCode = UBlockCode(96i32);
pub const UBLOCK_CYRILLIC_SUPPLEMENT: UBlockCode = UBlockCode(97i32);
pub const UBLOCK_CYRILLIC_SUPPLEMENTARY: UBlockCode = UBlockCode(97i32);
pub const UBLOCK_TAGALOG: UBlockCode = UBlockCode(98i32);
pub const UBLOCK_HANUNOO: UBlockCode = UBlockCode(99i32);
pub const UBLOCK_BUHID: UBlockCode = UBlockCode(100i32);
pub const UBLOCK_TAGBANWA: UBlockCode = UBlockCode(101i32);
pub const UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_A: UBlockCode = UBlockCode(102i32);
pub const UBLOCK_SUPPLEMENTAL_ARROWS_A: UBlockCode = UBlockCode(103i32);
pub const UBLOCK_SUPPLEMENTAL_ARROWS_B: UBlockCode = UBlockCode(104i32);
pub const UBLOCK_MISCELLANEOUS_MATHEMATICAL_SYMBOLS_B: UBlockCode = UBlockCode(105i32);
pub const UBLOCK_SUPPLEMENTAL_MATHEMATICAL_OPERATORS: UBlockCode = UBlockCode(106i32);
pub const UBLOCK_KATAKANA_PHONETIC_EXTENSIONS: UBlockCode = UBlockCode(107i32);
pub const UBLOCK_VARIATION_SELECTORS: UBlockCode = UBlockCode(108i32);
pub const UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_A: UBlockCode = UBlockCode(109i32);
pub const UBLOCK_SUPPLEMENTARY_PRIVATE_USE_AREA_B: UBlockCode = UBlockCode(110i32);
pub const UBLOCK_LIMBU: UBlockCode = UBlockCode(111i32);
pub const UBLOCK_TAI_LE: UBlockCode = UBlockCode(112i32);
pub const UBLOCK_KHMER_SYMBOLS: UBlockCode = UBlockCode(113i32);
pub const UBLOCK_PHONETIC_EXTENSIONS: UBlockCode = UBlockCode(114i32);
pub const UBLOCK_MISCELLANEOUS_SYMBOLS_AND_ARROWS: UBlockCode = UBlockCode(115i32);
pub const UBLOCK_YIJING_HEXAGRAM_SYMBOLS: UBlockCode = UBlockCode(116i32);
pub const UBLOCK_LINEAR_B_SYLLABARY: UBlockCode = UBlockCode(117i32);
pub const UBLOCK_LINEAR_B_IDEOGRAMS: UBlockCode = UBlockCode(118i32);
pub const UBLOCK_AEGEAN_NUMBERS: UBlockCode = UBlockCode(119i32);
pub const UBLOCK_UGARITIC: UBlockCode = UBlockCode(120i32);
pub const UBLOCK_SHAVIAN: UBlockCode = UBlockCode(121i32);
pub const UBLOCK_OSMANYA: UBlockCode = UBlockCode(122i32);
pub const UBLOCK_CYPRIOT_SYLLABARY: UBlockCode = UBlockCode(123i32);
pub const UBLOCK_TAI_XUAN_JING_SYMBOLS: UBlockCode = UBlockCode(124i32);
pub const UBLOCK_VARIATION_SELECTORS_SUPPLEMENT: UBlockCode = UBlockCode(125i32);
pub const UBLOCK_ANCIENT_GREEK_MUSICAL_NOTATION: UBlockCode = UBlockCode(126i32);
pub const UBLOCK_ANCIENT_GREEK_NUMBERS: UBlockCode = UBlockCode(127i32);
pub const UBLOCK_ARABIC_SUPPLEMENT: UBlockCode = UBlockCode(128i32);
pub const UBLOCK_BUGINESE: UBlockCode = UBlockCode(129i32);
pub const UBLOCK_CJK_STROKES: UBlockCode = UBlockCode(130i32);
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS_SUPPLEMENT: UBlockCode = UBlockCode(131i32);
pub const UBLOCK_COPTIC: UBlockCode = UBlockCode(132i32);
pub const UBLOCK_ETHIOPIC_EXTENDED: UBlockCode = UBlockCode(133i32);
pub const UBLOCK_ETHIOPIC_SUPPLEMENT: UBlockCode = UBlockCode(134i32);
pub const UBLOCK_GEORGIAN_SUPPLEMENT: UBlockCode = UBlockCode(135i32);
pub const UBLOCK_GLAGOLITIC: UBlockCode = UBlockCode(136i32);
pub const UBLOCK_KHAROSHTHI: UBlockCode = UBlockCode(137i32);
pub const UBLOCK_MODIFIER_TONE_LETTERS: UBlockCode = UBlockCode(138i32);
pub const UBLOCK_NEW_TAI_LUE: UBlockCode = UBlockCode(139i32);
pub const UBLOCK_OLD_PERSIAN: UBlockCode = UBlockCode(140i32);
pub const UBLOCK_PHONETIC_EXTENSIONS_SUPPLEMENT: UBlockCode = UBlockCode(141i32);
pub const UBLOCK_SUPPLEMENTAL_PUNCTUATION: UBlockCode = UBlockCode(142i32);
pub const UBLOCK_SYLOTI_NAGRI: UBlockCode = UBlockCode(143i32);
pub const UBLOCK_TIFINAGH: UBlockCode = UBlockCode(144i32);
pub const UBLOCK_VERTICAL_FORMS: UBlockCode = UBlockCode(145i32);
pub const UBLOCK_NKO: UBlockCode = UBlockCode(146i32);
pub const UBLOCK_BALINESE: UBlockCode = UBlockCode(147i32);
pub const UBLOCK_LATIN_EXTENDED_C: UBlockCode = UBlockCode(148i32);
pub const UBLOCK_LATIN_EXTENDED_D: UBlockCode = UBlockCode(149i32);
pub const UBLOCK_PHAGS_PA: UBlockCode = UBlockCode(150i32);
pub const UBLOCK_PHOENICIAN: UBlockCode = UBlockCode(151i32);
pub const UBLOCK_CUNEIFORM: UBlockCode = UBlockCode(152i32);
pub const UBLOCK_CUNEIFORM_NUMBERS_AND_PUNCTUATION: UBlockCode = UBlockCode(153i32);
pub const UBLOCK_COUNTING_ROD_NUMERALS: UBlockCode = UBlockCode(154i32);
pub const UBLOCK_SUNDANESE: UBlockCode = UBlockCode(155i32);
pub const UBLOCK_LEPCHA: UBlockCode = UBlockCode(156i32);
pub const UBLOCK_OL_CHIKI: UBlockCode = UBlockCode(157i32);
pub const UBLOCK_CYRILLIC_EXTENDED_A: UBlockCode = UBlockCode(158i32);
pub const UBLOCK_VAI: UBlockCode = UBlockCode(159i32);
pub const UBLOCK_CYRILLIC_EXTENDED_B: UBlockCode = UBlockCode(160i32);
pub const UBLOCK_SAURASHTRA: UBlockCode = UBlockCode(161i32);
pub const UBLOCK_KAYAH_LI: UBlockCode = UBlockCode(162i32);
pub const UBLOCK_REJANG: UBlockCode = UBlockCode(163i32);
pub const UBLOCK_CHAM: UBlockCode = UBlockCode(164i32);
pub const UBLOCK_ANCIENT_SYMBOLS: UBlockCode = UBlockCode(165i32);
pub const UBLOCK_PHAISTOS_DISC: UBlockCode = UBlockCode(166i32);
pub const UBLOCK_LYCIAN: UBlockCode = UBlockCode(167i32);
pub const UBLOCK_CARIAN: UBlockCode = UBlockCode(168i32);
pub const UBLOCK_LYDIAN: UBlockCode = UBlockCode(169i32);
pub const UBLOCK_MAHJONG_TILES: UBlockCode = UBlockCode(170i32);
pub const UBLOCK_DOMINO_TILES: UBlockCode = UBlockCode(171i32);
pub const UBLOCK_SAMARITAN: UBlockCode = UBlockCode(172i32);
pub const UBLOCK_UNIFIED_CANADIAN_ABORIGINAL_SYLLABICS_EXTENDED: UBlockCode = UBlockCode(173i32);
pub const UBLOCK_TAI_THAM: UBlockCode = UBlockCode(174i32);
pub const UBLOCK_VEDIC_EXTENSIONS: UBlockCode = UBlockCode(175i32);
pub const UBLOCK_LISU: UBlockCode = UBlockCode(176i32);
pub const UBLOCK_BAMUM: UBlockCode = UBlockCode(177i32);
pub const UBLOCK_COMMON_INDIC_NUMBER_FORMS: UBlockCode = UBlockCode(178i32);
pub const UBLOCK_DEVANAGARI_EXTENDED: UBlockCode = UBlockCode(179i32);
pub const UBLOCK_HANGUL_JAMO_EXTENDED_A: UBlockCode = UBlockCode(180i32);
pub const UBLOCK_JAVANESE: UBlockCode = UBlockCode(181i32);
pub const UBLOCK_MYANMAR_EXTENDED_A: UBlockCode = UBlockCode(182i32);
pub const UBLOCK_TAI_VIET: UBlockCode = UBlockCode(183i32);
pub const UBLOCK_MEETEI_MAYEK: UBlockCode = UBlockCode(184i32);
pub const UBLOCK_HANGUL_JAMO_EXTENDED_B: UBlockCode = UBlockCode(185i32);
pub const UBLOCK_IMPERIAL_ARAMAIC: UBlockCode = UBlockCode(186i32);
pub const UBLOCK_OLD_SOUTH_ARABIAN: UBlockCode = UBlockCode(187i32);
pub const UBLOCK_AVESTAN: UBlockCode = UBlockCode(188i32);
pub const UBLOCK_INSCRIPTIONAL_PARTHIAN: UBlockCode = UBlockCode(189i32);
pub const UBLOCK_INSCRIPTIONAL_PAHLAVI: UBlockCode = UBlockCode(190i32);
pub const UBLOCK_OLD_TURKIC: UBlockCode = UBlockCode(191i32);
pub const UBLOCK_RUMI_NUMERAL_SYMBOLS: UBlockCode = UBlockCode(192i32);
pub const UBLOCK_KAITHI: UBlockCode = UBlockCode(193i32);
pub const UBLOCK_EGYPTIAN_HIEROGLYPHS: UBlockCode = UBlockCode(194i32);
pub const UBLOCK_ENCLOSED_ALPHANUMERIC_SUPPLEMENT: UBlockCode = UBlockCode(195i32);
pub const UBLOCK_ENCLOSED_IDEOGRAPHIC_SUPPLEMENT: UBlockCode = UBlockCode(196i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C: UBlockCode = UBlockCode(197i32);
pub const UBLOCK_MANDAIC: UBlockCode = UBlockCode(198i32);
pub const UBLOCK_BATAK: UBlockCode = UBlockCode(199i32);
pub const UBLOCK_ETHIOPIC_EXTENDED_A: UBlockCode = UBlockCode(200i32);
pub const UBLOCK_BRAHMI: UBlockCode = UBlockCode(201i32);
pub const UBLOCK_BAMUM_SUPPLEMENT: UBlockCode = UBlockCode(202i32);
pub const UBLOCK_KANA_SUPPLEMENT: UBlockCode = UBlockCode(203i32);
pub const UBLOCK_PLAYING_CARDS: UBlockCode = UBlockCode(204i32);
pub const UBLOCK_MISCELLANEOUS_SYMBOLS_AND_PICTOGRAPHS: UBlockCode = UBlockCode(205i32);
pub const UBLOCK_EMOTICONS: UBlockCode = UBlockCode(206i32);
pub const UBLOCK_TRANSPORT_AND_MAP_SYMBOLS: UBlockCode = UBlockCode(207i32);
pub const UBLOCK_ALCHEMICAL_SYMBOLS: UBlockCode = UBlockCode(208i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D: UBlockCode = UBlockCode(209i32);
pub const UBLOCK_ARABIC_EXTENDED_A: UBlockCode = UBlockCode(210i32);
pub const UBLOCK_ARABIC_MATHEMATICAL_ALPHABETIC_SYMBOLS: UBlockCode = UBlockCode(211i32);
pub const UBLOCK_CHAKMA: UBlockCode = UBlockCode(212i32);
pub const UBLOCK_MEETEI_MAYEK_EXTENSIONS: UBlockCode = UBlockCode(213i32);
pub const UBLOCK_MEROITIC_CURSIVE: UBlockCode = UBlockCode(214i32);
pub const UBLOCK_MEROITIC_HIEROGLYPHS: UBlockCode = UBlockCode(215i32);
pub const UBLOCK_MIAO: UBlockCode = UBlockCode(216i32);
pub const UBLOCK_SHARADA: UBlockCode = UBlockCode(217i32);
pub const UBLOCK_SORA_SOMPENG: UBlockCode = UBlockCode(218i32);
pub const UBLOCK_SUNDANESE_SUPPLEMENT: UBlockCode = UBlockCode(219i32);
pub const UBLOCK_TAKRI: UBlockCode = UBlockCode(220i32);
pub const UBLOCK_BASSA_VAH: UBlockCode = UBlockCode(221i32);
pub const UBLOCK_CAUCASIAN_ALBANIAN: UBlockCode = UBlockCode(222i32);
pub const UBLOCK_COPTIC_EPACT_NUMBERS: UBlockCode = UBlockCode(223i32);
pub const UBLOCK_COMBINING_DIACRITICAL_MARKS_EXTENDED: UBlockCode = UBlockCode(224i32);
pub const UBLOCK_DUPLOYAN: UBlockCode = UBlockCode(225i32);
pub const UBLOCK_ELBASAN: UBlockCode = UBlockCode(226i32);
pub const UBLOCK_GEOMETRIC_SHAPES_EXTENDED: UBlockCode = UBlockCode(227i32);
pub const UBLOCK_GRANTHA: UBlockCode = UBlockCode(228i32);
pub const UBLOCK_KHOJKI: UBlockCode = UBlockCode(229i32);
pub const UBLOCK_KHUDAWADI: UBlockCode = UBlockCode(230i32);
pub const UBLOCK_LATIN_EXTENDED_E: UBlockCode = UBlockCode(231i32);
pub const UBLOCK_LINEAR_A: UBlockCode = UBlockCode(232i32);
pub const UBLOCK_MAHAJANI: UBlockCode = UBlockCode(233i32);
pub const UBLOCK_MANICHAEAN: UBlockCode = UBlockCode(234i32);
pub const UBLOCK_MENDE_KIKAKUI: UBlockCode = UBlockCode(235i32);
pub const UBLOCK_MODI: UBlockCode = UBlockCode(236i32);
pub const UBLOCK_MRO: UBlockCode = UBlockCode(237i32);
pub const UBLOCK_MYANMAR_EXTENDED_B: UBlockCode = UBlockCode(238i32);
pub const UBLOCK_NABATAEAN: UBlockCode = UBlockCode(239i32);
pub const UBLOCK_OLD_NORTH_ARABIAN: UBlockCode = UBlockCode(240i32);
pub const UBLOCK_OLD_PERMIC: UBlockCode = UBlockCode(241i32);
pub const UBLOCK_ORNAMENTAL_DINGBATS: UBlockCode = UBlockCode(242i32);
pub const UBLOCK_PAHAWH_HMONG: UBlockCode = UBlockCode(243i32);
pub const UBLOCK_PALMYRENE: UBlockCode = UBlockCode(244i32);
pub const UBLOCK_PAU_CIN_HAU: UBlockCode = UBlockCode(245i32);
pub const UBLOCK_PSALTER_PAHLAVI: UBlockCode = UBlockCode(246i32);
pub const UBLOCK_SHORTHAND_FORMAT_CONTROLS: UBlockCode = UBlockCode(247i32);
pub const UBLOCK_SIDDHAM: UBlockCode = UBlockCode(248i32);
pub const UBLOCK_SINHALA_ARCHAIC_NUMBERS: UBlockCode = UBlockCode(249i32);
pub const UBLOCK_SUPPLEMENTAL_ARROWS_C: UBlockCode = UBlockCode(250i32);
pub const UBLOCK_TIRHUTA: UBlockCode = UBlockCode(251i32);
pub const UBLOCK_WARANG_CITI: UBlockCode = UBlockCode(252i32);
pub const UBLOCK_AHOM: UBlockCode = UBlockCode(253i32);
pub const UBLOCK_ANATOLIAN_HIEROGLYPHS: UBlockCode = UBlockCode(254i32);
pub const UBLOCK_CHEROKEE_SUPPLEMENT: UBlockCode = UBlockCode(255i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_E: UBlockCode = UBlockCode(256i32);
pub const UBLOCK_EARLY_DYNASTIC_CUNEIFORM: UBlockCode = UBlockCode(257i32);
pub const UBLOCK_HATRAN: UBlockCode = UBlockCode(258i32);
pub const UBLOCK_MULTANI: UBlockCode = UBlockCode(259i32);
pub const UBLOCK_OLD_HUNGARIAN: UBlockCode = UBlockCode(260i32);
pub const UBLOCK_SUPPLEMENTAL_SYMBOLS_AND_PICTOGRAPHS: UBlockCode = UBlockCode(261i32);
pub const UBLOCK_SUTTON_SIGNWRITING: UBlockCode = UBlockCode(262i32);
pub const UBLOCK_ADLAM: UBlockCode = UBlockCode(263i32);
pub const UBLOCK_BHAIKSUKI: UBlockCode = UBlockCode(264i32);
pub const UBLOCK_CYRILLIC_EXTENDED_C: UBlockCode = UBlockCode(265i32);
pub const UBLOCK_GLAGOLITIC_SUPPLEMENT: UBlockCode = UBlockCode(266i32);
pub const UBLOCK_IDEOGRAPHIC_SYMBOLS_AND_PUNCTUATION: UBlockCode = UBlockCode(267i32);
pub const UBLOCK_MARCHEN: UBlockCode = UBlockCode(268i32);
pub const UBLOCK_MONGOLIAN_SUPPLEMENT: UBlockCode = UBlockCode(269i32);
pub const UBLOCK_NEWA: UBlockCode = UBlockCode(270i32);
pub const UBLOCK_OSAGE: UBlockCode = UBlockCode(271i32);
pub const UBLOCK_TANGUT: UBlockCode = UBlockCode(272i32);
pub const UBLOCK_TANGUT_COMPONENTS: UBlockCode = UBlockCode(273i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_F: UBlockCode = UBlockCode(274i32);
pub const UBLOCK_KANA_EXTENDED_A: UBlockCode = UBlockCode(275i32);
pub const UBLOCK_MASARAM_GONDI: UBlockCode = UBlockCode(276i32);
pub const UBLOCK_NUSHU: UBlockCode = UBlockCode(277i32);
pub const UBLOCK_SOYOMBO: UBlockCode = UBlockCode(278i32);
pub const UBLOCK_SYRIAC_SUPPLEMENT: UBlockCode = UBlockCode(279i32);
pub const UBLOCK_ZANABAZAR_SQUARE: UBlockCode = UBlockCode(280i32);
pub const UBLOCK_CHESS_SYMBOLS: UBlockCode = UBlockCode(281i32);
pub const UBLOCK_DOGRA: UBlockCode = UBlockCode(282i32);
pub const UBLOCK_GEORGIAN_EXTENDED: UBlockCode = UBlockCode(283i32);
pub const UBLOCK_GUNJALA_GONDI: UBlockCode = UBlockCode(284i32);
pub const UBLOCK_HANIFI_ROHINGYA: UBlockCode = UBlockCode(285i32);
pub const UBLOCK_INDIC_SIYAQ_NUMBERS: UBlockCode = UBlockCode(286i32);
pub const UBLOCK_MAKASAR: UBlockCode = UBlockCode(287i32);
pub const UBLOCK_MAYAN_NUMERALS: UBlockCode = UBlockCode(288i32);
pub const UBLOCK_MEDEFAIDRIN: UBlockCode = UBlockCode(289i32);
pub const UBLOCK_OLD_SOGDIAN: UBlockCode = UBlockCode(290i32);
pub const UBLOCK_SOGDIAN: UBlockCode = UBlockCode(291i32);
pub const UBLOCK_EGYPTIAN_HIEROGLYPH_FORMAT_CONTROLS: UBlockCode = UBlockCode(292i32);
pub const UBLOCK_ELYMAIC: UBlockCode = UBlockCode(293i32);
pub const UBLOCK_NANDINAGARI: UBlockCode = UBlockCode(294i32);
pub const UBLOCK_NYIAKENG_PUACHUE_HMONG: UBlockCode = UBlockCode(295i32);
pub const UBLOCK_OTTOMAN_SIYAQ_NUMBERS: UBlockCode = UBlockCode(296i32);
pub const UBLOCK_SMALL_KANA_EXTENSION: UBlockCode = UBlockCode(297i32);
pub const UBLOCK_SYMBOLS_AND_PICTOGRAPHS_EXTENDED_A: UBlockCode = UBlockCode(298i32);
pub const UBLOCK_TAMIL_SUPPLEMENT: UBlockCode = UBlockCode(299i32);
pub const UBLOCK_WANCHO: UBlockCode = UBlockCode(300i32);
pub const UBLOCK_CHORASMIAN: UBlockCode = UBlockCode(301i32);
pub const UBLOCK_CJK_UNIFIED_IDEOGRAPHS_EXTENSION_G: UBlockCode = UBlockCode(302i32);
pub const UBLOCK_DIVES_AKURU: UBlockCode = UBlockCode(303i32);
pub const UBLOCK_KHITAN_SMALL_SCRIPT: UBlockCode = UBlockCode(304i32);
pub const UBLOCK_LISU_SUPPLEMENT: UBlockCode = UBlockCode(305i32);
pub const UBLOCK_SYMBOLS_FOR_LEGACY_COMPUTING: UBlockCode = UBlockCode(306i32);
pub const UBLOCK_TANGUT_SUPPLEMENT: UBlockCode = UBlockCode(307i32);
pub const UBLOCK_YEZIDI: UBlockCode = UBlockCode(308i32);
pub const UBLOCK_INVALID_CODE: UBlockCode = UBlockCode(-1i32);
impl ::std::convert::From<i32> for UBlockCode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBlockCode {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(C)]
#[derive(
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
)]
pub struct UBreakIterator(pub u8);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UBreakIteratorType(pub i32);
pub const UBRK_CHARACTER: UBreakIteratorType = UBreakIteratorType(0i32);
pub const UBRK_WORD: UBreakIteratorType = UBreakIteratorType(1i32);
pub const UBRK_LINE: UBreakIteratorType = UBreakIteratorType(2i32);
pub const UBRK_SENTENCE: UBreakIteratorType = UBreakIteratorType(3i32);
impl ::std::convert::From<i32> for UBreakIteratorType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UBreakIteratorType {
    type Abi = Self;
    type DefaultType = Self;
}
pub const UCHAR_MAX_VALUE: u32 = 1114111u32;
pub const UCHAR_MIN_VALUE: u32 = 0u32;
pub const UCLN_NO_AUTO_CLEANUP: u32 = 1u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_FROM_U_CALLBACK_ESCAPE(
    context: *const ::std::ffi::c_void,
    fromuargs: *mut UConverterFromUnicodeArgs,
    codeunits: *const u16,
    length: i32,
    codepoint: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_ESCAPE(
                context: *const ::std::ffi::c_void,
                fromuargs: *mut UConverterFromUnicodeArgs,
                codeunits: *const u16,
                length: i32,
                codepoint: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_ESCAPE(
            ::std::mem::transmute(context),
            ::std::mem::transmute(fromuargs),
            ::std::mem::transmute(codeunits),
            ::std::mem::transmute(length),
            ::std::mem::transmute(codepoint),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_FROM_U_CALLBACK_SKIP(
    context: *const ::std::ffi::c_void,
    fromuargs: *mut UConverterFromUnicodeArgs,
    codeunits: *const u16,
    length: i32,
    codepoint: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_SKIP(
                context: *const ::std::ffi::c_void,
                fromuargs: *mut UConverterFromUnicodeArgs,
                codeunits: *const u16,
                length: i32,
                codepoint: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_SKIP(
            ::std::mem::transmute(context),
            ::std::mem::transmute(fromuargs),
            ::std::mem::transmute(codeunits),
            ::std::mem::transmute(length),
            ::std::mem::transmute(codepoint),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_FROM_U_CALLBACK_STOP(
    context: *const ::std::ffi::c_void,
    fromuargs: *mut UConverterFromUnicodeArgs,
    codeunits: *const u16,
    length: i32,
    codepoint: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_STOP(
                context: *const ::std::ffi::c_void,
                fromuargs: *mut UConverterFromUnicodeArgs,
                codeunits: *const u16,
                length: i32,
                codepoint: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_STOP(
            ::std::mem::transmute(context),
            ::std::mem::transmute(fromuargs),
            ::std::mem::transmute(codeunits),
            ::std::mem::transmute(length),
            ::std::mem::transmute(codepoint),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_FROM_U_CALLBACK_SUBSTITUTE(
    context: *const ::std::ffi::c_void,
    fromuargs: *mut UConverterFromUnicodeArgs,
    codeunits: *const u16,
    length: i32,
    codepoint: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_FROM_U_CALLBACK_SUBSTITUTE(
                context: *const ::std::ffi::c_void,
                fromuargs: *mut UConverterFromUnicodeArgs,
                codeunits: *const u16,
                length: i32,
                codepoint: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_FROM_U_CALLBACK_SUBSTITUTE(
            ::std::mem::transmute(context),
            ::std::mem::transmute(fromuargs),
            ::std::mem::transmute(codeunits),
            ::std::mem::transmute(length),
            ::std::mem::transmute(codepoint),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const UCNV_MAX_CONVERTER_NAME_LENGTH: u32 = 60u32;
pub const UCNV_SI: u32 = 15u32;
pub const UCNV_SO: u32 = 14u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_TO_U_CALLBACK_ESCAPE<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    context: *const ::std::ffi::c_void,
    touargs: *mut UConverterToUnicodeArgs,
    codeunits: Param2,
    length: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_ESCAPE(
                context: *const ::std::ffi::c_void,
                touargs: *mut UConverterToUnicodeArgs,
                codeunits: super::Foundation::PSTR,
                length: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_ESCAPE(
            ::std::mem::transmute(context),
            ::std::mem::transmute(touargs),
            codeunits.into_param().abi(),
            ::std::mem::transmute(length),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_TO_U_CALLBACK_SKIP<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    context: *const ::std::ffi::c_void,
    touargs: *mut UConverterToUnicodeArgs,
    codeunits: Param2,
    length: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_SKIP(
                context: *const ::std::ffi::c_void,
                touargs: *mut UConverterToUnicodeArgs,
                codeunits: super::Foundation::PSTR,
                length: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_SKIP(
            ::std::mem::transmute(context),
            ::std::mem::transmute(touargs),
            codeunits.into_param().abi(),
            ::std::mem::transmute(length),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_TO_U_CALLBACK_STOP<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    context: *const ::std::ffi::c_void,
    touargs: *mut UConverterToUnicodeArgs,
    codeunits: Param2,
    length: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_STOP(
                context: *const ::std::ffi::c_void,
                touargs: *mut UConverterToUnicodeArgs,
                codeunits: super::Foundation::PSTR,
                length: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_STOP(
            ::std::mem::transmute(context),
            ::std::mem::transmute(touargs),
            codeunits.into_param().abi(),
            ::std::mem::transmute(length),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn UCNV_TO_U_CALLBACK_SUBSTITUTE<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::Foundation::PSTR>,
>(
    context: *const ::std::ffi::c_void,
    touargs: *mut UConverterToUnicodeArgs,
    codeunits: Param2,
    length: i32,
    reason: UConverterCallbackReason,
    err: *mut UErrorCode,
) {
    #[cfg(windows)]
    {
        #[link(name = "windows")]
        extern "system" {
            fn UCNV_TO_U_CALLBACK_SUBSTITUTE(
                context: *const ::std::ffi::c_void,
                touargs: *mut UConverterToUnicodeArgs,
                codeunits: super::Foundation::PSTR,
                length: i32,
                reason: UConverterCallbackReason,
                err: *mut UErrorCode,
            );
        }
        ::std::mem::transmute(UCNV_TO_U_CALLBACK_SUBSTITUTE(
            ::std::mem::transmute(context),
            ::std::mem::transmute(touargs),
            codeunits.into_param().abi(),
            ::std::mem::transmute(length),
            ::std::mem::transmute(reason),
            ::std::mem::transmute(err),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const UCONFIG_ENABLE_PLUGINS: u32 = 0u32;
#[repr(C)]
#[derive(
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
)]
pub struct UCPMap(pub u8);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCPMapRangeOption(pub i32);
pub const UCPMAP_RANGE_NORMAL: UCPMapRangeOption = UCPMapRangeOption(0i32);
pub const UCPMAP_RANGE_FIXED_LEAD_SURROGATES: UCPMapRangeOption = UCPMapRangeOption(1i32);
pub const UCPMAP_RANGE_FIXED_ALL_SURROGATES: UCPMapRangeOption = UCPMapRangeOption(2i32);
impl ::std::convert::From<i32> for UCPMapRangeOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCPMapRangeOption {
    type Abi = Self;
    type DefaultType = Self;
}
pub type UCPMapValueFilter =
    unsafe extern "system" fn(context: *const ::std::ffi::c_void, value: u32) -> u32;
pub const UCPTRIE_ERROR_VALUE_NEG_DATA_OFFSET: i32 = 1i32;
pub const UCPTRIE_FAST_DATA_BLOCK_LENGTH: i32 = 64i32;
pub const UCPTRIE_FAST_DATA_MASK: i32 = 63i32;
pub const UCPTRIE_FAST_SHIFT: i32 = 6i32;
pub const UCPTRIE_HIGH_VALUE_NEG_DATA_OFFSET: i32 = 2i32;
pub const UCPTRIE_SMALL_MAX: i32 = 4095i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct UCPTrie {
    pub index: *mut u16,
    pub data: UCPTrieData,
    pub indexLength: i32,
    pub dataLength: i32,
    pub highStart: i32,
    pub shifted12HighStart: u16,
    pub r#type: i8,
    pub valueWidth: i8,
    pub reserved32: u32,
    pub reserved16: u16,
    pub index3NullOffset: u16,
    pub dataNullOffset: i32,
    pub nullValue: u32,
}
impl UCPTrie {}
impl ::std::default::Default for UCPTrie {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for UCPTrie {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for UCPTrie {}
unsafe impl ::windows::runtime::Abi for UCPTrie {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union UCPTrieData {
    pub ptr0: *mut ::std::ffi::c_void,
    pub ptr16: *mut u16,
    pub ptr32: *mut u32,
    pub ptr8: *mut u8,
}
impl UCPTrieData {}
impl ::std::default::Default for UCPTrieData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for UCPTrieData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for UCPTrieData {}
unsafe impl ::windows::runtime::Abi for UCPTrieData {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCPTrieType(pub i32);
pub const UCPTRIE_TYPE_ANY: UCPTrieType = UCPTrieType(-1i32);
pub const UCPTRIE_TYPE_FAST: UCPTrieType = UCPTrieType(0i32);
pub const UCPTRIE_TYPE_SMALL: UCPTrieType = UCPTrieType(1i32);
impl ::std::convert::From<i32> for UCPTrieType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCPTrieType {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCPTrieValueWidth(pub i32);
pub const UCPTRIE_VALUE_BITS_ANY: UCPTrieValueWidth = UCPTrieValueWidth(-1i32);
pub const UCPTRIE_VALUE_BITS_16: UCPTrieValueWidth = UCPTrieValueWidth(0i32);
pub const UCPTRIE_VALUE_BITS_32: UCPTrieValueWidth = UCPTrieValueWidth(1i32);
pub const UCPTRIE_VALUE_BITS_8: UCPTrieValueWidth = UCPTrieValueWidth(2i32);
impl ::std::convert::From<i32> for UCPTrieValueWidth {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCPTrieValueWidth {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarAMPMs(pub i32);
pub const UCAL_AM: UCalendarAMPMs = UCalendarAMPMs(0i32);
pub const UCAL_PM: UCalendarAMPMs = UCalendarAMPMs(1i32);
impl ::std::convert::From<i32> for UCalendarAMPMs {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarAMPMs {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarAttribute(pub i32);
pub const UCAL_LENIENT: UCalendarAttribute = UCalendarAttribute(0i32);
pub const UCAL_FIRST_DAY_OF_WEEK: UCalendarAttribute = UCalendarAttribute(1i32);
pub const UCAL_MINIMAL_DAYS_IN_FIRST_WEEK: UCalendarAttribute = UCalendarAttribute(2i32);
pub const UCAL_REPEATED_WALL_TIME: UCalendarAttribute = UCalendarAttribute(3i32);
pub const UCAL_SKIPPED_WALL_TIME: UCalendarAttribute = UCalendarAttribute(4i32);
impl ::std::convert::From<i32> for UCalendarAttribute {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarAttribute {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarDateFields(pub i32);
pub const UCAL_ERA: UCalendarDateFields = UCalendarDateFields(0i32);
pub const UCAL_YEAR: UCalendarDateFields = UCalendarDateFields(1i32);
pub const UCAL_MONTH: UCalendarDateFields = UCalendarDateFields(2i32);
pub const UCAL_WEEK_OF_YEAR: UCalendarDateFields = UCalendarDateFields(3i32);
pub const UCAL_WEEK_OF_MONTH: UCalendarDateFields = UCalendarDateFields(4i32);
pub const UCAL_DATE: UCalendarDateFields = UCalendarDateFields(5i32);
pub const UCAL_DAY_OF_YEAR: UCalendarDateFields = UCalendarDateFields(6i32);
pub const UCAL_DAY_OF_WEEK: UCalendarDateFields = UCalendarDateFields(7i32);
pub const UCAL_DAY_OF_WEEK_IN_MONTH: UCalendarDateFields = UCalendarDateFields(8i32);
pub const UCAL_AM_PM: UCalendarDateFields = UCalendarDateFields(9i32);
pub const UCAL_HOUR: UCalendarDateFields = UCalendarDateFields(10i32);
pub const UCAL_HOUR_OF_DAY: UCalendarDateFields = UCalendarDateFields(11i32);
pub const UCAL_MINUTE: UCalendarDateFields = UCalendarDateFields(12i32);
pub const UCAL_SECOND: UCalendarDateFields = UCalendarDateFields(13i32);
pub const UCAL_MILLISECOND: UCalendarDateFields = UCalendarDateFields(14i32);
pub const UCAL_ZONE_OFFSET: UCalendarDateFields = UCalendarDateFields(15i32);
pub const UCAL_DST_OFFSET: UCalendarDateFields = UCalendarDateFields(16i32);
pub const UCAL_YEAR_WOY: UCalendarDateFields = UCalendarDateFields(17i32);
pub const UCAL_DOW_LOCAL: UCalendarDateFields = UCalendarDateFields(18i32);
pub const UCAL_EXTENDED_YEAR: UCalendarDateFields = UCalendarDateFields(19i32);
pub const UCAL_JULIAN_DAY: UCalendarDateFields = UCalendarDateFields(20i32);
pub const UCAL_MILLISECONDS_IN_DAY: UCalendarDateFields = UCalendarDateFields(21i32);
pub const UCAL_IS_LEAP_MONTH: UCalendarDateFields = UCalendarDateFields(22i32);
pub const UCAL_FIELD_COUNT: UCalendarDateFields = UCalendarDateFields(23i32);
pub const UCAL_DAY_OF_MONTH: UCalendarDateFields = UCalendarDateFields(5i32);
impl ::std::convert::From<i32> for UCalendarDateFields {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarDateFields {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarDaysOfWeek(pub i32);
pub const UCAL_SUNDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(1i32);
pub const UCAL_MONDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(2i32);
pub const UCAL_TUESDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(3i32);
pub const UCAL_WEDNESDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(4i32);
pub const UCAL_THURSDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(5i32);
pub const UCAL_FRIDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(6i32);
pub const UCAL_SATURDAY: UCalendarDaysOfWeek = UCalendarDaysOfWeek(7i32);
impl ::std::convert::From<i32> for UCalendarDaysOfWeek {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarDaysOfWeek {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarDisplayNameType(pub i32);
pub const UCAL_STANDARD: UCalendarDisplayNameType = UCalendarDisplayNameType(0i32);
pub const UCAL_SHORT_STANDARD: UCalendarDisplayNameType = UCalendarDisplayNameType(1i32);
pub const UCAL_DST: UCalendarDisplayNameType = UCalendarDisplayNameType(2i32);
pub const UCAL_SHORT_DST: UCalendarDisplayNameType = UCalendarDisplayNameType(3i32);
impl ::std::convert::From<i32> for UCalendarDisplayNameType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarDisplayNameType {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarLimitType(pub i32);
pub const UCAL_MINIMUM: UCalendarLimitType = UCalendarLimitType(0i32);
pub const UCAL_MAXIMUM: UCalendarLimitType = UCalendarLimitType(1i32);
pub const UCAL_GREATEST_MINIMUM: UCalendarLimitType = UCalendarLimitType(2i32);
pub const UCAL_LEAST_MAXIMUM: UCalendarLimitType = UCalendarLimitType(3i32);
pub const UCAL_ACTUAL_MINIMUM: UCalendarLimitType = UCalendarLimitType(4i32);
pub const UCAL_ACTUAL_MAXIMUM: UCalendarLimitType = UCalendarLimitType(5i32);
impl ::std::convert::From<i32> for UCalendarLimitType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarLimitType {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarMonths(pub i32);
pub const UCAL_JANUARY: UCalendarMonths = UCalendarMonths(0i32);
pub const UCAL_FEBRUARY: UCalendarMonths = UCalendarMonths(1i32);
pub const UCAL_MARCH: UCalendarMonths = UCalendarMonths(2i32);
pub const UCAL_APRIL: UCalendarMonths = UCalendarMonths(3i32);
pub const UCAL_MAY: UCalendarMonths = UCalendarMonths(4i32);
pub const UCAL_JUNE: UCalendarMonths = UCalendarMonths(5i32);
pub const UCAL_JULY: UCalendarMonths = UCalendarMonths(6i32);
pub const UCAL_AUGUST: UCalendarMonths = UCalendarMonths(7i32);
pub const UCAL_SEPTEMBER: UCalendarMonths = UCalendarMonths(8i32);
pub const UCAL_OCTOBER: UCalendarMonths = UCalendarMonths(9i32);
pub const UCAL_NOVEMBER: UCalendarMonths = UCalendarMonths(10i32);
pub const UCAL_DECEMBER: UCalendarMonths = UCalendarMonths(11i32);
pub const UCAL_UNDECIMBER: UCalendarMonths = UCalendarMonths(12i32);
impl ::std::convert::From<i32> for UCalendarMonths {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarMonths {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarType(pub i32);
pub const UCAL_TRADITIONAL: UCalendarType = UCalendarType(0i32);
pub const UCAL_DEFAULT: UCalendarType = UCalendarType(0i32);
pub const UCAL_GREGORIAN: UCalendarType = UCalendarType(1i32);
impl ::std::convert::From<i32> for UCalendarType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarType {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarWallTimeOption(pub i32);
pub const UCAL_WALLTIME_LAST: UCalendarWallTimeOption = UCalendarWallTimeOption(0i32);
pub const UCAL_WALLTIME_FIRST: UCalendarWallTimeOption = UCalendarWallTimeOption(1i32);
pub const UCAL_WALLTIME_NEXT_VALID: UCalendarWallTimeOption = UCalendarWallTimeOption(2i32);
impl ::std::convert::From<i32> for UCalendarWallTimeOption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarWallTimeOption {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCalendarWeekdayType(pub i32);
pub const UCAL_WEEKDAY: UCalendarWeekdayType = UCalendarWeekdayType(0i32);
pub const UCAL_WEEKEND: UCalendarWeekdayType = UCalendarWeekdayType(1i32);
pub const UCAL_WEEKEND_ONSET: UCalendarWeekdayType = UCalendarWeekdayType(2i32);
pub const UCAL_WEEKEND_CEASE: UCalendarWeekdayType = UCalendarWeekdayType(3i32);
impl ::std::convert::From<i32> for UCalendarWeekdayType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCalendarWeekdayType {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(C)]
#[derive(
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
)]
pub struct UCaseMap(pub u8);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCharCategory(pub i32);
pub const U_UNASSIGNED: UCharCategory = UCharCategory(0i32);
pub const U_GENERAL_OTHER_TYPES: UCharCategory = UCharCategory(0i32);
pub const U_UPPERCASE_LETTER: UCharCategory = UCharCategory(1i32);
pub const U_LOWERCASE_LETTER: UCharCategory = UCharCategory(2i32);
pub const U_TITLECASE_LETTER: UCharCategory = UCharCategory(3i32);
pub const U_MODIFIER_LETTER: UCharCategory = UCharCategory(4i32);
pub const U_OTHER_LETTER: UCharCategory = UCharCategory(5i32);
pub const U_NON_SPACING_MARK: UCharCategory = UCharCategory(6i32);
pub const U_ENCLOSING_MARK: UCharCategory = UCharCategory(7i32);
pub const U_COMBINING_SPACING_MARK: UCharCategory = UCharCategory(8i32);
pub const U_DECIMAL_DIGIT_NUMBER: UCharCategory = UCharCategory(9i32);
pub const U_LETTER_NUMBER: UCharCategory = UCharCategory(10i32);
pub const U_OTHER_NUMBER: UCharCategory = UCharCategory(11i32);
pub const U_SPACE_SEPARATOR: UCharCategory = UCharCategory(12i32);
pub const U_LINE_SEPARATOR: UCharCategory = UCharCategory(13i32);
pub const U_PARAGRAPH_SEPARATOR: UCharCategory = UCharCategory(14i32);
pub const U_CONTROL_CHAR: UCharCategory = UCharCategory(15i32);
pub const U_FORMAT_CHAR: UCharCategory = UCharCategory(16i32);
pub const U_PRIVATE_USE_CHAR: UCharCategory = UCharCategory(17i32);
pub const U_SURROGATE: UCharCategory = UCharCategory(18i32);
pub const U_DASH_PUNCTUATION: UCharCategory = UCharCategory(19i32);
pub const U_START_PUNCTUATION: UCharCategory = UCharCategory(20i32);
pub const U_END_PUNCTUATION: UCharCategory = UCharCategory(21i32);
pub const U_CONNECTOR_PUNCTUATION: UCharCategory = UCharCategory(22i32);
pub const U_OTHER_PUNCTUATION: UCharCategory = UCharCategory(23i32);
pub const U_MATH_SYMBOL: UCharCategory = UCharCategory(24i32);
pub const U_CURRENCY_SYMBOL: UCharCategory = UCharCategory(25i32);
pub const U_MODIFIER_SYMBOL: UCharCategory = UCharCategory(26i32);
pub const U_OTHER_SYMBOL: UCharCategory = UCharCategory(27i32);
pub const U_INITIAL_PUNCTUATION: UCharCategory = UCharCategory(28i32);
pub const U_FINAL_PUNCTUATION: UCharCategory = UCharCategory(29i32);
pub const U_CHAR_CATEGORY_COUNT: UCharCategory = UCharCategory(30i32);
impl ::std::convert::From<i32> for UCharCategory {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCharCategory {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCharDirection(pub i32);
pub const U_LEFT_TO_RIGHT: UCharDirection = UCharDirection(0i32);
pub const U_RIGHT_TO_LEFT: UCharDirection = UCharDirection(1i32);
pub const U_EUROPEAN_NUMBER: UCharDirection = UCharDirection(2i32);
pub const U_EUROPEAN_NUMBER_SEPARATOR: UCharDirection = UCharDirection(3i32);
pub const U_EUROPEAN_NUMBER_TERMINATOR: UCharDirection = UCharDirection(4i32);
pub const U_ARABIC_NUMBER: UCharDirection = UCharDirection(5i32);
pub const U_COMMON_NUMBER_SEPARATOR: UCharDirection = UCharDirection(6i32);
pub const U_BLOCK_SEPARATOR: UCharDirection = UCharDirection(7i32);
pub const U_SEGMENT_SEPARATOR: UCharDirection = UCharDirection(8i32);
pub const U_WHITE_SPACE_NEUTRAL: UCharDirection = UCharDirection(9i32);
pub const U_OTHER_NEUTRAL: UCharDirection = UCharDirection(10i32);
pub const U_LEFT_TO_RIGHT_EMBEDDING: UCharDirection = UCharDirection(11i32);
pub const U_LEFT_TO_RIGHT_OVERRIDE: UCharDirection = UCharDirection(12i32);
pub const U_RIGHT_TO_LEFT_ARABIC: UCharDirection = UCharDirection(13i32);
pub const U_RIGHT_TO_LEFT_EMBEDDING: UCharDirection = UCharDirection(14i32);
pub const U_RIGHT_TO_LEFT_OVERRIDE: UCharDirection = UCharDirection(15i32);
pub const U_POP_DIRECTIONAL_FORMAT: UCharDirection = UCharDirection(16i32);
pub const U_DIR_NON_SPACING_MARK: UCharDirection = UCharDirection(17i32);
pub const U_BOUNDARY_NEUTRAL: UCharDirection = UCharDirection(18i32);
pub const U_FIRST_STRONG_ISOLATE: UCharDirection = UCharDirection(19i32);
pub const U_LEFT_TO_RIGHT_ISOLATE: UCharDirection = UCharDirection(20i32);
pub const U_RIGHT_TO_LEFT_ISOLATE: UCharDirection = UCharDirection(21i32);
pub const U_POP_DIRECTIONAL_ISOLATE: UCharDirection = UCharDirection(22i32);
impl ::std::convert::From<i32> for UCharDirection {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCharDirection {
    type Abi = Self;
    type DefaultType = Self;
}
pub type UCharEnumTypeRange = unsafe extern "system" fn(
    context: *const ::std::ffi::c_void,
    start: i32,
    limit: i32,
    r#type: UCharCategory,
) -> i8;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct UCharIterator {
    pub context: *mut ::std::ffi::c_void,
    pub length: i32,
    pub start: i32,
    pub index: i32,
    pub limit: i32,
    pub reservedField: i32,
    pub getIndex: ::std::option::Option<UCharIteratorGetIndex>,
    pub r#move: ::std::option::Option<UCharIteratorMove>,
    pub hasNext: ::std::option::Option<UCharIteratorHasNext>,
    pub hasPrevious: ::std::option::Option<UCharIteratorHasPrevious>,
    pub current: ::std::option::Option<UCharIteratorCurrent>,
    pub next: ::std::option::Option<UCharIteratorNext>,
    pub previous: ::std::option::Option<UCharIteratorPrevious>,
    pub reservedFn: ::std::option::Option<UCharIteratorReserved>,
    pub getState: ::std::option::Option<UCharIteratorGetState>,
    pub setState: ::std::option::Option<UCharIteratorSetState>,
}
impl UCharIterator {}
impl ::std::default::Default for UCharIterator {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for UCharIterator {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("UCharIterator")
            .field("context", &self.context)
            .field("length", &self.length)
            .field("start", &self.start)
            .field("index", &self.index)
            .field("limit", &self.limit)
            .field("reservedField", &self.reservedField)
            .finish()
    }
}
impl ::std::cmp::PartialEq for UCharIterator {
    fn eq(&self, other: &Self) -> bool {
        self.context == other.context
            && self.length == other.length
            && self.start == other.start
            && self.index == other.index
            && self.limit == other.limit
            && self.reservedField == other.reservedField
            && self.getIndex.map(|f| f as usize) == other.getIndex.map(|f| f as usize)
            && self.r#move.map(|f| f as usize) == other.r#move.map(|f| f as usize)
            && self.hasNext.map(|f| f as usize) == other.hasNext.map(|f| f as usize)
            && self.hasPrevious.map(|f| f as usize) == other.hasPrevious.map(|f| f as usize)
            && self.current.map(|f| f as usize) == other.current.map(|f| f as usize)
            && self.next.map(|f| f as usize) == other.next.map(|f| f as usize)
            && self.previous.map(|f| f as usize) == other.previous.map(|f| f as usize)
            && self.reservedFn.map(|f| f as usize) == other.reservedFn.map(|f| f as usize)
            && self.getState.map(|f| f as usize) == other.getState.map(|f| f as usize)
            && self.setState.map(|f| f as usize) == other.setState.map(|f| f as usize)
    }
}
impl ::std::cmp::Eq for UCharIterator {}
unsafe impl ::windows::runtime::Abi for UCharIterator {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
pub type UCharIteratorCurrent =
    unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i32;
pub type UCharIteratorGetIndex = unsafe extern "system" fn(
    iter: *mut ::std::mem::ManuallyDrop<UCharIterator>,
    origin: UCharIteratorOrigin,
) -> i32;
pub type UCharIteratorGetState =
    unsafe extern "system" fn(iter: *const ::std::mem::ManuallyDrop<UCharIterator>) -> u32;
pub type UCharIteratorHasNext =
    unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i8;
pub type UCharIteratorHasPrevious =
    unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i8;
pub type UCharIteratorMove = unsafe extern "system" fn(
    iter: *mut ::std::mem::ManuallyDrop<UCharIterator>,
    delta: i32,
    origin: UCharIteratorOrigin,
) -> i32;
pub type UCharIteratorNext =
    unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct UCharIteratorOrigin(pub i32);
pub const UITER_START: UCharIteratorOrigin = UCharIteratorOrigin(0i32);
pub const UITER_CURRENT: UCharIteratorOrigin = UCharIteratorOrigin(1i32);
pub const UITER_LIMIT: UCharIteratorOrigin = UCharIteratorOrigin(2i32);
pub const UITER_ZERO: UCharIteratorOrigin = UCharIteratorOrigin(3i32);
pub const UITER_LENGTH: UCharIteratorOrigin = UCharIteratorOrigin(4i32);
impl ::std::convert::From<i32> for UCharIteratorOrigin {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for UCharIteratorOrigin {
    type Abi = Self;
    type DefaultType = Self;
}
pub type UCharIteratorPrevious =
    unsafe extern "system" fn(iter: *mut ::std::mem::ManuallyDrop<UCharIterator>) -> i32;
pub type UCharIteratorReserved = unsafe extern "system" fn(
    iter: *mut ::std::mem::ManuallyDrop<UCharIterator>,
    something: i32,
) -> i32;
pub type UCharIteratorSetState = unsafe extern "system" fn(
    iter: *mut ::std::mem::ManuallyDrop<UCharIterator>,
    state: u32,
    perrorcode: *mut UErrorCode,
);