#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct AASHELLMENUFILENAME {
    pub cbTotal: i16,
    pub rgbReserved: [u8; 12],
    pub szFileName: [u16; 1],
}
impl AASHELLMENUFILENAME {}
impl ::std::default::Default for AASHELLMENUFILENAME {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for AASHELLMENUFILENAME {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AASHELLMENUFILENAME")
            .field("cbTotal", &self.cbTotal)
            .field("rgbReserved", &self.rgbReserved)
            .field("szFileName", &self.szFileName)
            .finish()
    }
}
impl ::std::cmp::PartialEq for AASHELLMENUFILENAME {
    fn eq(&self, other: &Self) -> bool {
        self.cbTotal == other.cbTotal
            && self.rgbReserved == other.rgbReserved
            && self.szFileName == other.szFileName
    }
}
impl ::std::cmp::Eq for AASHELLMENUFILENAME {}
unsafe impl ::windows::runtime::Abi for AASHELLMENUFILENAME {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct AASHELLMENUITEM {
    pub lpReserved1: *mut ::std::ffi::c_void,
    pub iReserved: i32,
    pub uiReserved: u32,
    pub lpName: *mut AASHELLMENUFILENAME,
    pub psz: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl AASHELLMENUITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AASHELLMENUITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for AASHELLMENUITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("AASHELLMENUITEM")
            .field("lpReserved1", &self.lpReserved1)
            .field("iReserved", &self.iReserved)
            .field("uiReserved", &self.uiReserved)
            .field("lpName", &self.lpName)
            .field("psz", &self.psz)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AASHELLMENUITEM {
    fn eq(&self, other: &Self) -> bool {
        self.lpReserved1 == other.lpReserved1
            && self.iReserved == other.iReserved
            && self.uiReserved == other.uiReserved
            && self.lpName == other.lpName
            && self.psz == other.psz
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AASHELLMENUITEM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AASHELLMENUITEM {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ABE_BOTTOM: u32 = 3u32;
pub const ABE_LEFT: u32 = 0u32;
pub const ABE_RIGHT: u32 = 2u32;
pub const ABE_TOP: u32 = 1u32;
pub const ABM_ACTIVATE: u32 = 6u32;
pub const ABM_GETAUTOHIDEBAR: u32 = 7u32;
pub const ABM_GETAUTOHIDEBAREX: u32 = 11u32;
pub const ABM_GETSTATE: u32 = 4u32;
pub const ABM_GETTASKBARPOS: u32 = 5u32;
pub const ABM_NEW: u32 = 0u32;
pub const ABM_QUERYPOS: u32 = 2u32;
pub const ABM_REMOVE: u32 = 1u32;
pub const ABM_SETAUTOHIDEBAR: u32 = 8u32;
pub const ABM_SETAUTOHIDEBAREX: u32 = 12u32;
pub const ABM_SETPOS: u32 = 3u32;
pub const ABM_SETSTATE: u32 = 10u32;
pub const ABM_WINDOWPOSCHANGED: u32 = 9u32;
pub const ABN_FULLSCREENAPP: u32 = 2u32;
pub const ABN_POSCHANGED: u32 = 1u32;
pub const ABN_STATECHANGE: u32 = 0u32;
pub const ABN_WINDOWARRANGE: u32 = 3u32;
pub const ABS_ALWAYSONTOP: u32 = 2u32;
pub const ABS_AUTOHIDE: u32 = 1u32;
pub const ACDD_VISIBLE: u32 = 1u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ACENUMOPTION(pub i32);
pub const ACEO_NONE: ACENUMOPTION = ACENUMOPTION(0i32);
pub const ACEO_MOSTRECENTFIRST: ACENUMOPTION = ACENUMOPTION(1i32);
pub const ACEO_FIRSTUNUSED: ACENUMOPTION = ACENUMOPTION(65536i32);
impl ::std::convert::From<i32> for ACENUMOPTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ACENUMOPTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ACTIVATEOPTIONS(pub i32);
pub const AO_NONE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(0i32);
pub const AO_DESIGNMODE: ACTIVATEOPTIONS = ACTIVATEOPTIONS(1i32);
pub const AO_NOERRORUI: ACTIVATEOPTIONS = ACTIVATEOPTIONS(2i32);
pub const AO_NOSPLASHSCREEN: ACTIVATEOPTIONS = ACTIVATEOPTIONS(4i32);
pub const AO_PRELAUNCH: ACTIVATEOPTIONS = ACTIVATEOPTIONS(33554432i32);
impl ::std::convert::From<i32> for ACTIVATEOPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ACTIVATEOPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ADDURL_SILENT: u32 = 1u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ADJACENT_DISPLAY_EDGES(pub i32);
pub const ADE_NONE: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(0i32);
pub const ADE_LEFT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(1i32);
pub const ADE_RIGHT: ADJACENT_DISPLAY_EDGES = ADJACENT_DISPLAY_EDGES(2i32);
impl ::std::convert::From<i32> for ADJACENT_DISPLAY_EDGES {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ADJACENT_DISPLAY_EDGES {
    type Abi = Self;
    type DefaultType = Self;
}
pub const AD_APPLY_BUFFERED_REFRESH: u32 = 16u32;
pub const AD_APPLY_DYNAMICREFRESH: u32 = 32u32;
pub const AD_APPLY_FORCE: u32 = 8u32;
pub const AD_APPLY_HTMLGEN: u32 = 2u32;
pub const AD_APPLY_REFRESH: u32 = 4u32;
pub const AD_APPLY_SAVE: u32 = 1u32;
pub const AD_GETWP_BMP: u32 = 0u32;
pub const AD_GETWP_IMAGE: u32 = 1u32;
pub const AD_GETWP_LAST_APPLIED: u32 = 2u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AHE_TYPE(pub i32);
pub const AHE_DESKTOP: AHE_TYPE = AHE_TYPE(0i32);
pub const AHE_IMMERSIVE: AHE_TYPE = AHE_TYPE(1i32);
impl ::std::convert::From<i32> for AHE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AHE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AHTYPE(pub i32);
pub const AHTYPE_UNDEFINED: AHTYPE = AHTYPE(0i32);
pub const AHTYPE_USER_APPLICATION: AHTYPE = AHTYPE(8i32);
pub const AHTYPE_ANY_APPLICATION: AHTYPE = AHTYPE(16i32);
pub const AHTYPE_MACHINEDEFAULT: AHTYPE = AHTYPE(32i32);
pub const AHTYPE_PROGID: AHTYPE = AHTYPE(64i32);
pub const AHTYPE_APPLICATION: AHTYPE = AHTYPE(128i32);
pub const AHTYPE_CLASS_APPLICATION: AHTYPE = AHTYPE(256i32);
pub const AHTYPE_ANY_PROGID: AHTYPE = AHTYPE(512i32);
impl ::std::convert::From<i32> for AHTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AHTYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct APPACTIONFLAGS(pub i32);
pub const APPACTION_INSTALL: APPACTIONFLAGS = APPACTIONFLAGS(1i32);
pub const APPACTION_UNINSTALL: APPACTIONFLAGS = APPACTIONFLAGS(2i32);
pub const APPACTION_MODIFY: APPACTIONFLAGS = APPACTIONFLAGS(4i32);
pub const APPACTION_REPAIR: APPACTIONFLAGS = APPACTIONFLAGS(8i32);
pub const APPACTION_UPGRADE: APPACTIONFLAGS = APPACTIONFLAGS(16i32);
pub const APPACTION_CANGETSIZE: APPACTIONFLAGS = APPACTIONFLAGS(32i32);
pub const APPACTION_MODIFYREMOVE: APPACTIONFLAGS = APPACTIONFLAGS(128i32);
pub const APPACTION_ADDLATER: APPACTIONFLAGS = APPACTIONFLAGS(256i32);
pub const APPACTION_UNSCHEDULE: APPACTIONFLAGS = APPACTIONFLAGS(512i32);
impl ::std::convert::From<i32> for APPACTIONFLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPACTIONFLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct APPBARDATA {
    pub cbSize: u32,
    pub hWnd: super::super::Foundation::HWND,
    pub uCallbackMessage: u32,
    pub uEdge: u32,
    pub rc: super::super::Foundation::RECT,
    pub lParam: super::super::Foundation::LPARAM,
}
#[cfg(feature = "Win32_Foundation")]
impl APPBARDATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for APPBARDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for APPBARDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APPBARDATA")
            .field("cbSize", &self.cbSize)
            .field("hWnd", &self.hWnd)
            .field("uCallbackMessage", &self.uCallbackMessage)
            .field("uEdge", &self.uEdge)
            .field("rc", &self.rc)
            .field("lParam", &self.lParam)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for APPBARDATA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.hWnd == other.hWnd
            && self.uCallbackMessage == other.uCallbackMessage
            && self.uEdge == other.uEdge
            && self.rc == other.rc
            && self.lParam == other.lParam
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for APPBARDATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for APPBARDATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct APPCATEGORYINFO {
    pub Locale: u32,
    pub pszDescription: super::super::Foundation::PWSTR,
    pub AppCategoryId: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl APPCATEGORYINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for APPCATEGORYINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for APPCATEGORYINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APPCATEGORYINFO")
            .field("Locale", &self.Locale)
            .field("pszDescription", &self.pszDescription)
            .field("AppCategoryId", &self.AppCategoryId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for APPCATEGORYINFO {
    fn eq(&self, other: &Self) -> bool {
        self.Locale == other.Locale
            && self.pszDescription == other.pszDescription
            && self.AppCategoryId == other.AppCategoryId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for APPCATEGORYINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for APPCATEGORYINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct APPCATEGORYINFOLIST {
    pub cCategory: u32,
    pub pCategoryInfo: *mut APPCATEGORYINFO,
}
#[cfg(feature = "Win32_Foundation")]
impl APPCATEGORYINFOLIST {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for APPCATEGORYINFOLIST {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for APPCATEGORYINFOLIST {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APPCATEGORYINFOLIST")
            .field("cCategory", &self.cCategory)
            .field("pCategoryInfo", &self.pCategoryInfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for APPCATEGORYINFOLIST {
    fn eq(&self, other: &Self) -> bool {
        self.cCategory == other.cCategory && self.pCategoryInfo == other.pCategoryInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for APPCATEGORYINFOLIST {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for APPCATEGORYINFOLIST {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct APPDOCLISTTYPE(pub i32);
pub const ADLT_RECENT: APPDOCLISTTYPE = APPDOCLISTTYPE(0i32);
pub const ADLT_FREQUENT: APPDOCLISTTYPE = APPDOCLISTTYPE(1i32);
impl ::std::convert::From<i32> for APPDOCLISTTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPDOCLISTTYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct APPINFODATA {
    pub cbSize: u32,
    pub dwMask: u32,
    pub pszDisplayName: super::super::Foundation::PWSTR,
    pub pszVersion: super::super::Foundation::PWSTR,
    pub pszPublisher: super::super::Foundation::PWSTR,
    pub pszProductID: super::super::Foundation::PWSTR,
    pub pszRegisteredOwner: super::super::Foundation::PWSTR,
    pub pszRegisteredCompany: super::super::Foundation::PWSTR,
    pub pszLanguage: super::super::Foundation::PWSTR,
    pub pszSupportUrl: super::super::Foundation::PWSTR,
    pub pszSupportTelephone: super::super::Foundation::PWSTR,
    pub pszHelpLink: super::super::Foundation::PWSTR,
    pub pszInstallLocation: super::super::Foundation::PWSTR,
    pub pszInstallSource: super::super::Foundation::PWSTR,
    pub pszInstallDate: super::super::Foundation::PWSTR,
    pub pszContact: super::super::Foundation::PWSTR,
    pub pszComments: super::super::Foundation::PWSTR,
    pub pszImage: super::super::Foundation::PWSTR,
    pub pszReadmeUrl: super::super::Foundation::PWSTR,
    pub pszUpdateInfoUrl: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl APPINFODATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for APPINFODATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for APPINFODATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("APPINFODATA")
            .field("cbSize", &self.cbSize)
            .field("dwMask", &self.dwMask)
            .field("pszDisplayName", &self.pszDisplayName)
            .field("pszVersion", &self.pszVersion)
            .field("pszPublisher", &self.pszPublisher)
            .field("pszProductID", &self.pszProductID)
            .field("pszRegisteredOwner", &self.pszRegisteredOwner)
            .field("pszRegisteredCompany", &self.pszRegisteredCompany)
            .field("pszLanguage", &self.pszLanguage)
            .field("pszSupportUrl", &self.pszSupportUrl)
            .field("pszSupportTelephone", &self.pszSupportTelephone)
            .field("pszHelpLink", &self.pszHelpLink)
            .field("pszInstallLocation", &self.pszInstallLocation)
            .field("pszInstallSource", &self.pszInstallSource)
            .field("pszInstallDate", &self.pszInstallDate)
            .field("pszContact", &self.pszContact)
            .field("pszComments", &self.pszComments)
            .field("pszImage", &self.pszImage)
            .field("pszReadmeUrl", &self.pszReadmeUrl)
            .field("pszUpdateInfoUrl", &self.pszUpdateInfoUrl)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for APPINFODATA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwMask == other.dwMask
            && self.pszDisplayName == other.pszDisplayName
            && self.pszVersion == other.pszVersion
            && self.pszPublisher == other.pszPublisher
            && self.pszProductID == other.pszProductID
            && self.pszRegisteredOwner == other.pszRegisteredOwner
            && self.pszRegisteredCompany == other.pszRegisteredCompany
            && self.pszLanguage == other.pszLanguage
            && self.pszSupportUrl == other.pszSupportUrl
            && self.pszSupportTelephone == other.pszSupportTelephone
            && self.pszHelpLink == other.pszHelpLink
            && self.pszInstallLocation == other.pszInstallLocation
            && self.pszInstallSource == other.pszInstallSource
            && self.pszInstallDate == other.pszInstallDate
            && self.pszContact == other.pszContact
            && self.pszComments == other.pszComments
            && self.pszImage == other.pszImage
            && self.pszReadmeUrl == other.pszReadmeUrl
            && self.pszUpdateInfoUrl == other.pszUpdateInfoUrl
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for APPINFODATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for APPINFODATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct APPINFODATAFLAGS(pub i32);
pub const AIM_DISPLAYNAME: APPINFODATAFLAGS = APPINFODATAFLAGS(1i32);
pub const AIM_VERSION: APPINFODATAFLAGS = APPINFODATAFLAGS(2i32);
pub const AIM_PUBLISHER: APPINFODATAFLAGS = APPINFODATAFLAGS(4i32);
pub const AIM_PRODUCTID: APPINFODATAFLAGS = APPINFODATAFLAGS(8i32);
pub const AIM_REGISTEREDOWNER: APPINFODATAFLAGS = APPINFODATAFLAGS(16i32);
pub const AIM_REGISTEREDCOMPANY: APPINFODATAFLAGS = APPINFODATAFLAGS(32i32);
pub const AIM_LANGUAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(64i32);
pub const AIM_SUPPORTURL: APPINFODATAFLAGS = APPINFODATAFLAGS(128i32);
pub const AIM_SUPPORTTELEPHONE: APPINFODATAFLAGS = APPINFODATAFLAGS(256i32);
pub const AIM_HELPLINK: APPINFODATAFLAGS = APPINFODATAFLAGS(512i32);
pub const AIM_INSTALLLOCATION: APPINFODATAFLAGS = APPINFODATAFLAGS(1024i32);
pub const AIM_INSTALLSOURCE: APPINFODATAFLAGS = APPINFODATAFLAGS(2048i32);
pub const AIM_INSTALLDATE: APPINFODATAFLAGS = APPINFODATAFLAGS(4096i32);
pub const AIM_CONTACT: APPINFODATAFLAGS = APPINFODATAFLAGS(16384i32);
pub const AIM_COMMENTS: APPINFODATAFLAGS = APPINFODATAFLAGS(32768i32);
pub const AIM_IMAGE: APPINFODATAFLAGS = APPINFODATAFLAGS(131072i32);
pub const AIM_READMEURL: APPINFODATAFLAGS = APPINFODATAFLAGS(262144i32);
pub const AIM_UPDATEINFOURL: APPINFODATAFLAGS = APPINFODATAFLAGS(524288i32);
impl ::std::convert::From<i32> for APPINFODATAFLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPINFODATAFLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub type APPLET_PROC = unsafe extern "system" fn(
    hwndcpl: super::super::Foundation::HWND,
    msg: u32,
    lparam1: super::super::Foundation::LPARAM,
    lparam2: super::super::Foundation::LPARAM,
) -> i32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct APPLICATION_VIEW_MIN_WIDTH(pub i32);
pub const AVMW_DEFAULT: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(0i32);
pub const AVMW_320: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(1i32);
pub const AVMW_500: APPLICATION_VIEW_MIN_WIDTH = APPLICATION_VIEW_MIN_WIDTH(2i32);
impl ::std::convert::From<i32> for APPLICATION_VIEW_MIN_WIDTH {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPLICATION_VIEW_MIN_WIDTH {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct APPLICATION_VIEW_ORIENTATION(pub i32);
pub const AVO_LANDSCAPE: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(0i32);
pub const AVO_PORTRAIT: APPLICATION_VIEW_ORIENTATION = APPLICATION_VIEW_ORIENTATION(1i32);
impl ::std::convert::From<i32> for APPLICATION_VIEW_ORIENTATION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPLICATION_VIEW_ORIENTATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct APPLICATION_VIEW_SIZE_PREFERENCE(pub i32);
pub const AVSP_DEFAULT: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(0i32);
pub const AVSP_USE_LESS: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(1i32);
pub const AVSP_USE_HALF: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(2i32);
pub const AVSP_USE_MORE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(3i32);
pub const AVSP_USE_MINIMUM: APPLICATION_VIEW_SIZE_PREFERENCE =
    APPLICATION_VIEW_SIZE_PREFERENCE(4i32);
pub const AVSP_USE_NONE: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(5i32);
pub const AVSP_CUSTOM: APPLICATION_VIEW_SIZE_PREFERENCE = APPLICATION_VIEW_SIZE_PREFERENCE(6i32);
impl ::std::convert::From<i32> for APPLICATION_VIEW_SIZE_PREFERENCE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPLICATION_VIEW_SIZE_PREFERENCE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct APPLICATION_VIEW_STATE(pub i32);
pub const AVS_FULLSCREEN_LANDSCAPE: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(0i32);
pub const AVS_FILLED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(1i32);
pub const AVS_SNAPPED: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(2i32);
pub const AVS_FULLSCREEN_PORTRAIT: APPLICATION_VIEW_STATE = APPLICATION_VIEW_STATE(3i32);
impl ::std::convert::From<i32> for APPLICATION_VIEW_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for APPLICATION_VIEW_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const APPNAMEBUFFERLEN: u32 = 40u32;
pub const ARCONTENT_AUDIOCD: u32 = 4u32;
pub const ARCONTENT_AUTOPLAYMUSIC: u32 = 256u32;
pub const ARCONTENT_AUTOPLAYPIX: u32 = 128u32;
pub const ARCONTENT_AUTOPLAYVIDEO: u32 = 512u32;
pub const ARCONTENT_AUTORUNINF: u32 = 2u32;
pub const ARCONTENT_BLANKBD: u32 = 8192u32;
pub const ARCONTENT_BLANKCD: u32 = 16u32;
pub const ARCONTENT_BLANKDVD: u32 = 32u32;
pub const ARCONTENT_BLURAY: u32 = 16384u32;
pub const ARCONTENT_CAMERASTORAGE: u32 = 32768u32;
pub const ARCONTENT_CUSTOMEVENT: u32 = 65536u32;
pub const ARCONTENT_DVDAUDIO: u32 = 4096u32;
pub const ARCONTENT_DVDMOVIE: u32 = 8u32;
pub const ARCONTENT_MASK: u32 = 131070u32;
pub const ARCONTENT_NONE: u32 = 0u32;
pub const ARCONTENT_PHASE_FINAL: u32 = 1073741824u32;
pub const ARCONTENT_PHASE_MASK: u32 = 1879048192u32;
pub const ARCONTENT_PHASE_PRESNIFF: u32 = 268435456u32;
pub const ARCONTENT_PHASE_SNIFFING: u32 = 536870912u32;
pub const ARCONTENT_PHASE_UNKNOWN: u32 = 0u32;
pub const ARCONTENT_SVCD: u32 = 2048u32;
pub const ARCONTENT_UNKNOWNCONTENT: u32 = 64u32;
pub const ARCONTENT_VCD: u32 = 1024u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOCCLASS(pub i32);
pub const ASSOCCLASS_SHELL_KEY: ASSOCCLASS = ASSOCCLASS(0i32);
pub const ASSOCCLASS_PROGID_KEY: ASSOCCLASS = ASSOCCLASS(1i32);
pub const ASSOCCLASS_PROGID_STR: ASSOCCLASS = ASSOCCLASS(2i32);
pub const ASSOCCLASS_CLSID_KEY: ASSOCCLASS = ASSOCCLASS(3i32);
pub const ASSOCCLASS_CLSID_STR: ASSOCCLASS = ASSOCCLASS(4i32);
pub const ASSOCCLASS_APP_KEY: ASSOCCLASS = ASSOCCLASS(5i32);
pub const ASSOCCLASS_APP_STR: ASSOCCLASS = ASSOCCLASS(6i32);
pub const ASSOCCLASS_SYSTEM_STR: ASSOCCLASS = ASSOCCLASS(7i32);
pub const ASSOCCLASS_FOLDER: ASSOCCLASS = ASSOCCLASS(8i32);
pub const ASSOCCLASS_STAR: ASSOCCLASS = ASSOCCLASS(9i32);
pub const ASSOCCLASS_FIXED_PROGID_STR: ASSOCCLASS = ASSOCCLASS(10i32);
pub const ASSOCCLASS_PROTOCOL_STR: ASSOCCLASS = ASSOCCLASS(11i32);
impl ::std::convert::From<i32> for ASSOCCLASS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOCCLASS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOCDATA(pub i32);
pub const ASSOCDATA_MSIDESCRIPTOR: ASSOCDATA = ASSOCDATA(1i32);
pub const ASSOCDATA_NOACTIVATEHANDLER: ASSOCDATA = ASSOCDATA(2i32);
pub const ASSOCDATA_UNUSED1: ASSOCDATA = ASSOCDATA(3i32);
pub const ASSOCDATA_HASPERUSERASSOC: ASSOCDATA = ASSOCDATA(4i32);
pub const ASSOCDATA_EDITFLAGS: ASSOCDATA = ASSOCDATA(5i32);
pub const ASSOCDATA_VALUE: ASSOCDATA = ASSOCDATA(6i32);
pub const ASSOCDATA_MAX: ASSOCDATA = ASSOCDATA(7i32);
impl ::std::convert::From<i32> for ASSOCDATA {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOCDATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOCENUM(pub i32);
pub const ASSOCENUM_NONE: ASSOCENUM = ASSOCENUM(0i32);
impl ::std::convert::From<i32> for ASSOCENUM {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOCENUM {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ASSOCF_APP_TO_APP: i32 = 65536i32;
pub const ASSOCF_IGNOREBASECLASS: i32 = 512i32;
pub const ASSOCF_INIT_BYEXENAME: i32 = 2i32;
pub const ASSOCF_INIT_DEFAULTTOFOLDER: i32 = 8i32;
pub const ASSOCF_INIT_DEFAULTTOSTAR: i32 = 4i32;
pub const ASSOCF_INIT_FIXED_PROGID: i32 = 2048i32;
pub const ASSOCF_INIT_FOR_FILE: i32 = 8192i32;
pub const ASSOCF_INIT_IGNOREUNKNOWN: i32 = 1024i32;
pub const ASSOCF_INIT_NOREMAPCLSID: i32 = 1i32;
pub const ASSOCF_IS_FULL_URI: i32 = 16384i32;
pub const ASSOCF_IS_PROTOCOL: i32 = 4096i32;
pub const ASSOCF_NOFIXUPS: i32 = 256i32;
pub const ASSOCF_NONE: i32 = 0i32;
pub const ASSOCF_NOTRUNCATE: i32 = 32i32;
pub const ASSOCF_NOUSERSETTINGS: i32 = 16i32;
pub const ASSOCF_OPEN_BYEXENAME: i32 = 2i32;
pub const ASSOCF_PER_MACHINE_ONLY: i32 = 32768i32;
pub const ASSOCF_REMAPRUNDLL: i32 = 128i32;
pub const ASSOCF_VERIFY: i32 = 64i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct ASSOCIATIONELEMENT {
    pub ac: ASSOCCLASS,
    pub hkClass: super::super::System::Registry::HKEY,
    pub pszClass: super::super::Foundation::PWSTR,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ASSOCIATIONELEMENT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::default::Default for ASSOCIATIONELEMENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::fmt::Debug for ASSOCIATIONELEMENT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ASSOCIATIONELEMENT")
            .field("ac", &self.ac)
            .field("hkClass", &self.hkClass)
            .field("pszClass", &self.pszClass)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::PartialEq for ASSOCIATIONELEMENT {
    fn eq(&self, other: &Self) -> bool {
        self.ac == other.ac && self.hkClass == other.hkClass && self.pszClass == other.pszClass
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::Eq for ASSOCIATIONELEMENT {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::runtime::Abi for ASSOCIATIONELEMENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOCIATIONLEVEL(pub i32);
pub const AL_MACHINE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(0i32);
pub const AL_EFFECTIVE: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(1i32);
pub const AL_USER: ASSOCIATIONLEVEL = ASSOCIATIONLEVEL(2i32);
impl ::std::convert::From<i32> for ASSOCIATIONLEVEL {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOCIATIONLEVEL {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOCIATIONTYPE(pub i32);
pub const AT_FILEEXTENSION: ASSOCIATIONTYPE = ASSOCIATIONTYPE(0i32);
pub const AT_URLPROTOCOL: ASSOCIATIONTYPE = ASSOCIATIONTYPE(1i32);
pub const AT_STARTMENUCLIENT: ASSOCIATIONTYPE = ASSOCIATIONTYPE(2i32);
pub const AT_MIMETYPE: ASSOCIATIONTYPE = ASSOCIATIONTYPE(3i32);
impl ::std::convert::From<i32> for ASSOCIATIONTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOCIATIONTYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOCKEY(pub i32);
pub const ASSOCKEY_SHELLEXECCLASS: ASSOCKEY = ASSOCKEY(1i32);
pub const ASSOCKEY_APP: ASSOCKEY = ASSOCKEY(2i32);
pub const ASSOCKEY_CLASS: ASSOCKEY = ASSOCKEY(3i32);
pub const ASSOCKEY_BASECLASS: ASSOCKEY = ASSOCKEY(4i32);
pub const ASSOCKEY_MAX: ASSOCKEY = ASSOCKEY(5i32);
impl ::std::convert::From<i32> for ASSOCKEY {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOCKEY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOCSTR(pub i32);
pub const ASSOCSTR_COMMAND: ASSOCSTR = ASSOCSTR(1i32);
pub const ASSOCSTR_EXECUTABLE: ASSOCSTR = ASSOCSTR(2i32);
pub const ASSOCSTR_FRIENDLYDOCNAME: ASSOCSTR = ASSOCSTR(3i32);
pub const ASSOCSTR_FRIENDLYAPPNAME: ASSOCSTR = ASSOCSTR(4i32);
pub const ASSOCSTR_NOOPEN: ASSOCSTR = ASSOCSTR(5i32);
pub const ASSOCSTR_SHELLNEWVALUE: ASSOCSTR = ASSOCSTR(6i32);
pub const ASSOCSTR_DDECOMMAND: ASSOCSTR = ASSOCSTR(7i32);
pub const ASSOCSTR_DDEIFEXEC: ASSOCSTR = ASSOCSTR(8i32);
pub const ASSOCSTR_DDEAPPLICATION: ASSOCSTR = ASSOCSTR(9i32);
pub const ASSOCSTR_DDETOPIC: ASSOCSTR = ASSOCSTR(10i32);
pub const ASSOCSTR_INFOTIP: ASSOCSTR = ASSOCSTR(11i32);
pub const ASSOCSTR_QUICKTIP: ASSOCSTR = ASSOCSTR(12i32);
pub const ASSOCSTR_TILEINFO: ASSOCSTR = ASSOCSTR(13i32);
pub const ASSOCSTR_CONTENTTYPE: ASSOCSTR = ASSOCSTR(14i32);
pub const ASSOCSTR_DEFAULTICON: ASSOCSTR = ASSOCSTR(15i32);
pub const ASSOCSTR_SHELLEXTENSION: ASSOCSTR = ASSOCSTR(16i32);
pub const ASSOCSTR_DROPTARGET: ASSOCSTR = ASSOCSTR(17i32);
pub const ASSOCSTR_DELEGATEEXECUTE: ASSOCSTR = ASSOCSTR(18i32);
pub const ASSOCSTR_SUPPORTED_URI_PROTOCOLS: ASSOCSTR = ASSOCSTR(19i32);
pub const ASSOCSTR_PROGID: ASSOCSTR = ASSOCSTR(20i32);
pub const ASSOCSTR_APPID: ASSOCSTR = ASSOCSTR(21i32);
pub const ASSOCSTR_APPPUBLISHER: ASSOCSTR = ASSOCSTR(22i32);
pub const ASSOCSTR_APPICONREFERENCE: ASSOCSTR = ASSOCSTR(23i32);
pub const ASSOCSTR_MAX: ASSOCSTR = ASSOCSTR(24i32);
impl ::std::convert::From<i32> for ASSOCSTR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOCSTR {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ASSOC_FILTER(pub i32);
pub const ASSOC_FILTER_NONE: ASSOC_FILTER = ASSOC_FILTER(0i32);
pub const ASSOC_FILTER_RECOMMENDED: ASSOC_FILTER = ASSOC_FILTER(1i32);
impl ::std::convert::From<i32> for ASSOC_FILTER {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ASSOC_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ATTACHMENT_ACTION(pub i32);
pub const ATTACHMENT_ACTION_CANCEL: ATTACHMENT_ACTION = ATTACHMENT_ACTION(0i32);
pub const ATTACHMENT_ACTION_SAVE: ATTACHMENT_ACTION = ATTACHMENT_ACTION(1i32);
pub const ATTACHMENT_ACTION_EXEC: ATTACHMENT_ACTION = ATTACHMENT_ACTION(2i32);
impl ::std::convert::From<i32> for ATTACHMENT_ACTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ATTACHMENT_ACTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ATTACHMENT_PROMPT(pub i32);
pub const ATTACHMENT_PROMPT_NONE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(0i32);
pub const ATTACHMENT_PROMPT_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(1i32);
pub const ATTACHMENT_PROMPT_EXEC: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(2i32);
pub const ATTACHMENT_PROMPT_EXEC_OR_SAVE: ATTACHMENT_PROMPT = ATTACHMENT_PROMPT(3i32);
impl ::std::convert::From<i32> for ATTACHMENT_PROMPT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ATTACHMENT_PROMPT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AUTOCOMPLETELISTOPTIONS(pub i32);
pub const ACLO_NONE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(0i32);
pub const ACLO_CURRENTDIR: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(1i32);
pub const ACLO_MYCOMPUTER: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(2i32);
pub const ACLO_DESKTOP: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(4i32);
pub const ACLO_FAVORITES: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(8i32);
pub const ACLO_FILESYSONLY: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(16i32);
pub const ACLO_FILESYSDIRS: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(32i32);
pub const ACLO_VIRTUALNAMESPACE: AUTOCOMPLETELISTOPTIONS = AUTOCOMPLETELISTOPTIONS(64i32);
impl ::std::convert::From<i32> for AUTOCOMPLETELISTOPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUTOCOMPLETELISTOPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AUTOCOMPLETEOPTIONS(pub i32);
pub const ACO_NONE: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(0i32);
pub const ACO_AUTOSUGGEST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(1i32);
pub const ACO_AUTOAPPEND: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(2i32);
pub const ACO_SEARCH: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(4i32);
pub const ACO_FILTERPREFIXES: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(8i32);
pub const ACO_USETAB: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(16i32);
pub const ACO_UPDOWNKEYDROPSLIST: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(32i32);
pub const ACO_RTLREADING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(64i32);
pub const ACO_WORD_FILTER: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(128i32);
pub const ACO_NOPREFIXFILTERING: AUTOCOMPLETEOPTIONS = AUTOCOMPLETEOPTIONS(256i32);
impl ::std::convert::From<i32> for AUTOCOMPLETEOPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AUTOCOMPLETEOPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct AUTO_SCROLL_DATA {
    pub iNextSample: i32,
    pub dwLastScroll: u32,
    pub bFull: super::super::Foundation::BOOL,
    pub pts: [super::super::Foundation::POINT; 3],
    pub dwTimes: [u32; 3],
}
#[cfg(feature = "Win32_Foundation")]
impl AUTO_SCROLL_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for AUTO_SCROLL_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for AUTO_SCROLL_DATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for AUTO_SCROLL_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for AUTO_SCROLL_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
pub const AccessibilityDockingService: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        701373766,
        46209,
        19104,
        [160, 138, 211, 235, 200, 172, 164, 2],
    );
pub const AlphabeticalCategorizer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1009145030,
    29554,
    20331,
    [179, 16, 85, 214, 18, 143, 73, 210],
);
pub const AppShellVerbHandler: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1322493721,
    52904,
    19417,
    [145, 13, 226, 82, 249, 151, 175, 194],
);
pub const AppStartupLink: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    658421223,
    34992,
    18499,
    [191, 239, 226, 200, 29, 67, 170, 229],
);
pub const AppVisibility: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2120213465,
    39007,
    18696,
    [145, 249, 238, 25, 249, 253, 21, 20],
);
pub const ApplicationActivationManager: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1169822333,
        4264,
        18154,
        [138, 183, 86, 234, 144, 120, 148, 60],
    );
pub const ApplicationAssociationRegistration: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1494354375,
        30331,
        17074,
        [159, 186, 68, 238, 70, 21, 242, 199],
    );
pub const ApplicationAssociationRegistrationUI: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        426250349,
        62389,
        17615,
        [137, 14, 17, 111, 203, 158, 206, 241],
    );
pub const ApplicationDesignModeSettings: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2508877749,
        56498,
        20399,
        [170, 253, 127, 176, 84, 173, 26, 59],
    );
pub const ApplicationDestinations: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2260811779,
    19819,
    20211,
    [167, 180, 5, 6, 102, 59, 46, 104],
);
pub const ApplicationDocumentLists: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2260648482,
        12530,
        18400,
        [159, 37, 96, 209, 28, 215, 92, 40],
    );
pub unsafe fn AssocCreate<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
>(
    clsid: Param0,
    riid: *const ::windows::runtime::GUID,
    ppv: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocCreate(
                clsid: ::windows::runtime::GUID,
                riid: *const ::windows::runtime::GUID,
                ppv: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        AssocCreate(
            clsid.into_param().abi(),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub unsafe fn AssocCreateForClasses<T: ::windows::runtime::Interface>(
    rgclasses: *const ASSOCIATIONELEMENT,
    cclasses: u32,
) -> ::windows::runtime::Result<T> {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn AssocCreateForClasses(
                rgclasses: *const ASSOCIATIONELEMENT,
                cclasses: u32,
                riid: *const ::windows::runtime::GUID,
                ppv: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__ = ::std::option::Option::None;
        AssocCreateForClasses(
            ::std::mem::transmute(rgclasses),
            ::std::mem::transmute(cclasses),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_OleAutomation",
    feature = "Win32_System_PropertiesSystem",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn AssocGetDetailsOfPropKey<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, IShellFolder>,
>(
    psf: Param0,
    pidl: *const ITEMIDLIST,
    pkey: *const super::super::System::PropertiesSystem::PROPERTYKEY,
    pv: *mut super::super::System::OleAutomation::VARIANT,
    pffoundpropkey: *mut super::super::Foundation::BOOL,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn AssocGetDetailsOfPropKey(
                psf: ::windows::runtime::RawPtr,
                pidl: *const ITEMIDLIST,
                pkey: *const super::super::System::PropertiesSystem::PROPERTYKEY,
                pv: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
                pffoundpropkey: *mut super::super::Foundation::BOOL,
            ) -> ::windows::runtime::HRESULT;
        }
        AssocGetDetailsOfPropKey(
            psf.into_param().abi(),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(pkey),
            ::std::mem::transmute(pv),
            ::std::mem::transmute(pffoundpropkey),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AssocGetPerceivedType<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszext: Param0,
    ptype: *mut PERCEIVED,
    pflag: *mut u32,
    ppsztype: *mut super::super::Foundation::PWSTR,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocGetPerceivedType(
                pszext: super::super::Foundation::PWSTR,
                ptype: *mut PERCEIVED,
                pflag: *mut u32,
                ppsztype: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        AssocGetPerceivedType(
            pszext.into_param().abi(),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pflag),
            ::std::mem::transmute(ppsztype),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AssocIsDangerous<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszassoc: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocIsDangerous(
                pszassoc: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AssocIsDangerous(pszassoc.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub unsafe fn AssocQueryKeyA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    flags: u32,
    key: ASSOCKEY,
    pszassoc: Param2,
    pszextra: Param3,
) -> ::windows::runtime::Result<super::super::System::Registry::HKEY> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocQueryKeyA(
                flags: u32,
                key: ASSOCKEY,
                pszassoc: super::super::Foundation::PSTR,
                pszextra: super::super::Foundation::PSTR,
                phkeyout: *mut super::super::System::Registry::HKEY,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::System::Registry::HKEY as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        AssocQueryKeyA(
            ::std::mem::transmute(flags),
            ::std::mem::transmute(key),
            pszassoc.into_param().abi(),
            pszextra.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::Registry::HKEY>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub unsafe fn AssocQueryKeyW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    flags: u32,
    key: ASSOCKEY,
    pszassoc: Param2,
    pszextra: Param3,
) -> ::windows::runtime::Result<super::super::System::Registry::HKEY> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocQueryKeyW(
                flags: u32,
                key: ASSOCKEY,
                pszassoc: super::super::Foundation::PWSTR,
                pszextra: super::super::Foundation::PWSTR,
                phkeyout: *mut super::super::System::Registry::HKEY,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::System::Registry::HKEY as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        AssocQueryKeyW(
            ::std::mem::transmute(flags),
            ::std::mem::transmute(key),
            pszassoc.into_param().abi(),
            pszextra.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::Registry::HKEY>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AssocQueryStringA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    flags: u32,
    str: ASSOCSTR,
    pszassoc: Param2,
    pszextra: Param3,
    pszout: super::super::Foundation::PSTR,
    pcchout: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocQueryStringA(
                flags: u32,
                str: ASSOCSTR,
                pszassoc: super::super::Foundation::PSTR,
                pszextra: super::super::Foundation::PSTR,
                pszout: super::super::Foundation::PSTR,
                pcchout: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        AssocQueryStringA(
            ::std::mem::transmute(flags),
            ::std::mem::transmute(str),
            pszassoc.into_param().abi(),
            pszextra.into_param().abi(),
            ::std::mem::transmute(pszout),
            ::std::mem::transmute(pcchout),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub unsafe fn AssocQueryStringByKeyA<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::System::Registry::HKEY>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    flags: u32,
    str: ASSOCSTR,
    hkassoc: Param2,
    pszextra: Param3,
    pszout: super::super::Foundation::PSTR,
    pcchout: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocQueryStringByKeyA(
                flags: u32,
                str: ASSOCSTR,
                hkassoc: super::super::System::Registry::HKEY,
                pszextra: super::super::Foundation::PSTR,
                pszout: super::super::Foundation::PSTR,
                pcchout: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        AssocQueryStringByKeyA(
            ::std::mem::transmute(flags),
            ::std::mem::transmute(str),
            hkassoc.into_param().abi(),
            pszextra.into_param().abi(),
            ::std::mem::transmute(pszout),
            ::std::mem::transmute(pcchout),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub unsafe fn AssocQueryStringByKeyW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::System::Registry::HKEY>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    flags: u32,
    str: ASSOCSTR,
    hkassoc: Param2,
    pszextra: Param3,
    pszout: super::super::Foundation::PWSTR,
    pcchout: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocQueryStringByKeyW(
                flags: u32,
                str: ASSOCSTR,
                hkassoc: super::super::System::Registry::HKEY,
                pszextra: super::super::Foundation::PWSTR,
                pszout: super::super::Foundation::PWSTR,
                pcchout: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        AssocQueryStringByKeyW(
            ::std::mem::transmute(flags),
            ::std::mem::transmute(str),
            hkassoc.into_param().abi(),
            pszextra.into_param().abi(),
            ::std::mem::transmute(pszout),
            ::std::mem::transmute(pcchout),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AssocQueryStringW<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    flags: u32,
    str: ASSOCSTR,
    pszassoc: Param2,
    pszextra: Param3,
    pszout: super::super::Foundation::PWSTR,
    pcchout: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn AssocQueryStringW(
                flags: u32,
                str: ASSOCSTR,
                pszassoc: super::super::Foundation::PWSTR,
                pszextra: super::super::Foundation::PWSTR,
                pszout: super::super::Foundation::PWSTR,
                pcchout: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        AssocQueryStringW(
            ::std::mem::transmute(flags),
            ::std::mem::transmute(str),
            pszassoc.into_param().abi(),
            pszextra.into_param().abi(),
            ::std::mem::transmute(pszout),
            ::std::mem::transmute(pcchout),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const AttachmentServices: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1093000598,
    57402,
    16643,
    [143, 112, 224, 89, 125, 128, 59, 156],
);
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
pub struct BANDINFOSFB {
    pub dwMask: u32,
    pub dwStateMask: u32,
    pub dwState: u32,
    pub crBkgnd: u32,
    pub crBtnLt: u32,
    pub crBtnDk: u32,
    pub wViewMode: u16,
    pub wAlign: u16,
    pub psf: ::std::option::Option<IShellFolder>,
    pub pidl: *mut ITEMIDLIST,
}
impl BANDINFOSFB {}
impl ::std::default::Default for BANDINFOSFB {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BANDINFOSFB {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BANDINFOSFB")
            .field("dwMask", &self.dwMask)
            .field("dwStateMask", &self.dwStateMask)
            .field("dwState", &self.dwState)
            .field("crBkgnd", &self.crBkgnd)
            .field("crBtnLt", &self.crBtnLt)
            .field("crBtnDk", &self.crBtnDk)
            .field("wViewMode", &self.wViewMode)
            .field("wAlign", &self.wAlign)
            .field("psf", &self.psf)
            .field("pidl", &self.pidl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BANDINFOSFB {
    fn eq(&self, other: &Self) -> bool {
        self.dwMask == other.dwMask
            && self.dwStateMask == other.dwStateMask
            && self.dwState == other.dwState
            && self.crBkgnd == other.crBkgnd
            && self.crBtnLt == other.crBtnLt
            && self.crBtnDk == other.crBtnDk
            && self.wViewMode == other.wViewMode
            && self.wAlign == other.wAlign
            && self.psf == other.psf
            && self.pidl == other.pidl
    }
}
impl ::std::cmp::Eq for BANDINFOSFB {}
unsafe impl ::windows::runtime::Abi for BANDINFOSFB {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct BANDSITECID(pub i32);
pub const BSID_BANDADDED: BANDSITECID = BANDSITECID(0i32);
pub const BSID_BANDREMOVED: BANDSITECID = BANDSITECID(1i32);
impl ::std::convert::From<i32> for BANDSITECID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BANDSITECID {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct BANDSITEINFO {
    pub dwMask: u32,
    pub dwState: u32,
    pub dwStyle: u32,
}
impl BANDSITEINFO {}
impl ::std::default::Default for BANDSITEINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BANDSITEINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BANDSITEINFO")
            .field("dwMask", &self.dwMask)
            .field("dwState", &self.dwState)
            .field("dwStyle", &self.dwStyle)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BANDSITEINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwMask == other.dwMask
            && self.dwState == other.dwState
            && self.dwStyle == other.dwStyle
    }
}
impl ::std::cmp::Eq for BANDSITEINFO {}
unsafe impl ::windows::runtime::Abi for BANDSITEINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BANNER_NOTIFICATION {
    pub event: BANNER_NOTIFICATION_EVENT,
    pub providerIdentity: super::super::Foundation::PWSTR,
    pub contentId: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl BANNER_NOTIFICATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BANNER_NOTIFICATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BANNER_NOTIFICATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BANNER_NOTIFICATION")
            .field("event", &self.event)
            .field("providerIdentity", &self.providerIdentity)
            .field("contentId", &self.contentId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BANNER_NOTIFICATION {
    fn eq(&self, other: &Self) -> bool {
        self.event == other.event
            && self.providerIdentity == other.providerIdentity
            && self.contentId == other.contentId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BANNER_NOTIFICATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BANNER_NOTIFICATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct BANNER_NOTIFICATION_EVENT(pub i32);
pub const BNE_Rendered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(0i32);
pub const BNE_Hovered: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(1i32);
pub const BNE_Closed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(2i32);
pub const BNE_Dismissed: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(3i32);
pub const BNE_Button1Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(4i32);
pub const BNE_Button2Clicked: BANNER_NOTIFICATION_EVENT = BANNER_NOTIFICATION_EVENT(5i32);
impl ::std::convert::From<i32> for BANNER_NOTIFICATION_EVENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BANNER_NOTIFICATION_EVENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
pub struct BASEBROWSERDATALH {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: ::std::option::Option<ITravelLog>,
    pub _phlf: ::std::option::Option<IHlinkFrame>,
    pub _pautoWB2: ::std::option::Option<super::super::System::WindowsProgramming::IWebBrowser2>,
    pub _pautoEDS: ::std::option::Option<IExpDispSupport>,
    pub _pautoSS: ::std::option::Option<IShellService>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut ITEMIDLIST,
    pub _pctView: ::std::option::Option<super::super::System::Com::IOleCommandTarget>,
    pub _pidlCur: *mut ITEMIDLIST,
    pub _psv: ::std::option::Option<IShellView>,
    pub _psf: ::std::option::Option<IShellFolder>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: super::super::Foundation::PWSTR,
    pub _pidlPending: *mut ITEMIDLIST,
    pub _psvPending: ::std::option::Option<IShellView>,
    pub _psfPending: ::std::option::Option<IShellFolder>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: super::super::Foundation::PWSTR,
    pub _fIsViewMSHTML: super::super::Foundation::BOOL,
    pub _fPrivacyImpacted: super::super::Foundation::BOOL,
    pub _clsidView: ::windows::runtime::GUID,
    pub _clsidViewPending: ::windows::runtime::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
    pub _lPhishingFilterStatus: i32,
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl BASEBROWSERDATALH {}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::default::Default for BASEBROWSERDATALH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::fmt::Debug for BASEBROWSERDATALH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BASEBROWSERDATALH")
            .field("_hwnd", &self._hwnd)
            .field("_ptl", &self._ptl)
            .field("_phlf", &self._phlf)
            .field("_pautoWB2", &self._pautoWB2)
            .field("_pautoEDS", &self._pautoEDS)
            .field("_pautoSS", &self._pautoSS)
            .field("_eSecureLockIcon", &self._eSecureLockIcon)
            .field("_bitfield", &self._bitfield)
            .field("_uActivateState", &self._uActivateState)
            .field("_pidlViewState", &self._pidlViewState)
            .field("_pctView", &self._pctView)
            .field("_pidlCur", &self._pidlCur)
            .field("_psv", &self._psv)
            .field("_psf", &self._psf)
            .field("_hwndView", &self._hwndView)
            .field("_pszTitleCur", &self._pszTitleCur)
            .field("_pidlPending", &self._pidlPending)
            .field("_psvPending", &self._psvPending)
            .field("_psfPending", &self._psfPending)
            .field("_hwndViewPending", &self._hwndViewPending)
            .field("_pszTitlePending", &self._pszTitlePending)
            .field("_fIsViewMSHTML", &self._fIsViewMSHTML)
            .field("_fPrivacyImpacted", &self._fPrivacyImpacted)
            .field("_clsidView", &self._clsidView)
            .field("_clsidViewPending", &self._clsidViewPending)
            .field("_hwndFrame", &self._hwndFrame)
            .field("_lPhishingFilterStatus", &self._lPhishingFilterStatus)
            .finish()
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::cmp::PartialEq for BASEBROWSERDATALH {
    fn eq(&self, other: &Self) -> bool {
        self._hwnd == other._hwnd
            && self._ptl == other._ptl
            && self._phlf == other._phlf
            && self._pautoWB2 == other._pautoWB2
            && self._pautoEDS == other._pautoEDS
            && self._pautoSS == other._pautoSS
            && self._eSecureLockIcon == other._eSecureLockIcon
            && self._bitfield == other._bitfield
            && self._uActivateState == other._uActivateState
            && self._pidlViewState == other._pidlViewState
            && self._pctView == other._pctView
            && self._pidlCur == other._pidlCur
            && self._psv == other._psv
            && self._psf == other._psf
            && self._hwndView == other._hwndView
            && self._pszTitleCur == other._pszTitleCur
            && self._pidlPending == other._pidlPending
            && self._psvPending == other._psvPending
            && self._psfPending == other._psfPending
            && self._hwndViewPending == other._hwndViewPending
            && self._pszTitlePending == other._pszTitlePending
            && self._fIsViewMSHTML == other._fIsViewMSHTML
            && self._fPrivacyImpacted == other._fPrivacyImpacted
            && self._clsidView == other._clsidView
            && self._clsidViewPending == other._clsidViewPending
            && self._hwndFrame == other._hwndFrame
            && self._lPhishingFilterStatus == other._lPhishingFilterStatus
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::cmp::Eq for BASEBROWSERDATALH {}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
unsafe impl ::windows::runtime::Abi for BASEBROWSERDATALH {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
pub struct BASEBROWSERDATAXP {
    pub _hwnd: super::super::Foundation::HWND,
    pub _ptl: ::std::option::Option<ITravelLog>,
    pub _phlf: ::std::option::Option<IHlinkFrame>,
    pub _pautoWB2: ::std::option::Option<super::super::System::WindowsProgramming::IWebBrowser2>,
    pub _pautoEDS: ::std::option::Option<IExpDispSupportXP>,
    pub _pautoSS: ::std::option::Option<IShellService>,
    pub _eSecureLockIcon: i32,
    pub _bitfield: u32,
    pub _uActivateState: u32,
    pub _pidlViewState: *mut ITEMIDLIST,
    pub _pctView: ::std::option::Option<super::super::System::Com::IOleCommandTarget>,
    pub _pidlCur: *mut ITEMIDLIST,
    pub _psv: ::std::option::Option<IShellView>,
    pub _psf: ::std::option::Option<IShellFolder>,
    pub _hwndView: super::super::Foundation::HWND,
    pub _pszTitleCur: super::super::Foundation::PWSTR,
    pub _pidlPending: *mut ITEMIDLIST,
    pub _psvPending: ::std::option::Option<IShellView>,
    pub _psfPending: ::std::option::Option<IShellFolder>,
    pub _hwndViewPending: super::super::Foundation::HWND,
    pub _pszTitlePending: super::super::Foundation::PWSTR,
    pub _fIsViewMSHTML: super::super::Foundation::BOOL,
    pub _fPrivacyImpacted: super::super::Foundation::BOOL,
    pub _clsidView: ::windows::runtime::GUID,
    pub _clsidViewPending: ::windows::runtime::GUID,
    pub _hwndFrame: super::super::Foundation::HWND,
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl BASEBROWSERDATAXP {}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::default::Default for BASEBROWSERDATAXP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::fmt::Debug for BASEBROWSERDATAXP {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BASEBROWSERDATAXP")
            .field("_hwnd", &self._hwnd)
            .field("_ptl", &self._ptl)
            .field("_phlf", &self._phlf)
            .field("_pautoWB2", &self._pautoWB2)
            .field("_pautoEDS", &self._pautoEDS)
            .field("_pautoSS", &self._pautoSS)
            .field("_eSecureLockIcon", &self._eSecureLockIcon)
            .field("_bitfield", &self._bitfield)
            .field("_uActivateState", &self._uActivateState)
            .field("_pidlViewState", &self._pidlViewState)
            .field("_pctView", &self._pctView)
            .field("_pidlCur", &self._pidlCur)
            .field("_psv", &self._psv)
            .field("_psf", &self._psf)
            .field("_hwndView", &self._hwndView)
            .field("_pszTitleCur", &self._pszTitleCur)
            .field("_pidlPending", &self._pidlPending)
            .field("_psvPending", &self._psvPending)
            .field("_psfPending", &self._psfPending)
            .field("_hwndViewPending", &self._hwndViewPending)
            .field("_pszTitlePending", &self._pszTitlePending)
            .field("_fIsViewMSHTML", &self._fIsViewMSHTML)
            .field("_fPrivacyImpacted", &self._fPrivacyImpacted)
            .field("_clsidView", &self._clsidView)
            .field("_clsidViewPending", &self._clsidViewPending)
            .field("_hwndFrame", &self._hwndFrame)
            .finish()
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::cmp::PartialEq for BASEBROWSERDATAXP {
    fn eq(&self, other: &Self) -> bool {
        self._hwnd == other._hwnd
            && self._ptl == other._ptl
            && self._phlf == other._phlf
            && self._pautoWB2 == other._pautoWB2
            && self._pautoEDS == other._pautoEDS
            && self._pautoSS == other._pautoSS
            && self._eSecureLockIcon == other._eSecureLockIcon
            && self._bitfield == other._bitfield
            && self._uActivateState == other._uActivateState
            && self._pidlViewState == other._pidlViewState
            && self._pctView == other._pctView
            && self._pidlCur == other._pidlCur
            && self._psv == other._psv
            && self._psf == other._psf
            && self._hwndView == other._hwndView
            && self._pszTitleCur == other._pszTitleCur
            && self._pidlPending == other._pidlPending
            && self._psvPending == other._psvPending
            && self._psfPending == other._psfPending
            && self._hwndViewPending == other._hwndViewPending
            && self._pszTitlePending == other._pszTitlePending
            && self._fIsViewMSHTML == other._fIsViewMSHTML
            && self._fPrivacyImpacted == other._fPrivacyImpacted
            && self._clsidView == other._clsidView
            && self._clsidViewPending == other._clsidViewPending
            && self._hwndFrame == other._hwndFrame
    }
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
impl ::std::cmp::Eq for BASEBROWSERDATAXP {}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_WindowsProgramming"
))]
unsafe impl ::windows::runtime::Abi for BASEBROWSERDATAXP {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub type BFFCALLBACK = unsafe extern "system" fn(
    hwnd: super::super::Foundation::HWND,
    umsg: u32,
    lparam: super::super::Foundation::LPARAM,
    lpdata: super::super::Foundation::LPARAM,
) -> i32;
pub const BFFM_ENABLEOK: u32 = 1125u32;
pub const BFFM_INITIALIZED: u32 = 1u32;
pub const BFFM_IUNKNOWN: u32 = 5u32;
pub const BFFM_SELCHANGED: u32 = 2u32;
pub const BFFM_SETEXPANDED: u32 = 1130u32;
pub const BFFM_SETOKTEXT: u32 = 1129u32;
pub const BFFM_SETSELECTION: u32 = 1127u32;
pub const BFFM_SETSELECTIONA: u32 = 1126u32;
pub const BFFM_SETSELECTIONW: u32 = 1127u32;
pub const BFFM_SETSTATUSTEXT: u32 = 1128u32;
pub const BFFM_SETSTATUSTEXTA: u32 = 1124u32;
pub const BFFM_SETSTATUSTEXTW: u32 = 1128u32;
pub const BFFM_VALIDATEFAILED: u32 = 4u32;
pub const BFFM_VALIDATEFAILEDA: u32 = 3u32;
pub const BFFM_VALIDATEFAILEDW: u32 = 4u32;
pub const BHID_AssociationArray: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3198807831,
    33521,
    20320,
    [146, 132, 79, 141, 183, 92, 59, 233],
);
pub const BHID_DataObject: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3099639199,
    60708,
    17756,
    [131, 230, 213, 57, 12, 79, 232, 196],
);
pub const BHID_EnumAssocHandlers: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3098217372,
    49900,
    20346,
    [145, 141, 49, 73, 0, 230, 40, 10],
);
pub const BHID_EnumItems: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2499151129,
    10320,
    18724,
    [170, 90, 209, 94, 132, 134, 128, 57],
);
pub const BHID_FilePlaceholder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2256002283,
    43744,
    16389,
    [141, 61, 84, 127, 168, 82, 248, 37],
);
pub const BHID_Filter: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    953190264,
    62807,
    18064,
    [158, 191, 186, 84, 112, 106, 216, 247],
);
pub const BHID_LinkTargetItem: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    964813352,
    62809,
    4563,
    [142, 58, 0, 192, 79, 104, 55, 213],
);
pub const BHID_PropertyStore: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    59040164,
    5411,
    17308,
    [164, 200, 171, 145, 16, 82, 245, 134],
);
pub const BHID_RandomAccessStream: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4050635067,
    30638,
    19710,
    [189, 167, 168, 102, 238, 166, 135, 141],
);
pub const BHID_SFObject: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    964813348,
    62809,
    4563,
    [142, 58, 0, 192, 79, 104, 55, 213],
);
pub const BHID_SFUIObject: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    964813349,
    62809,
    4563,
    [142, 58, 0, 192, 79, 104, 55, 213],
);
pub const BHID_SFViewObject: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    964813350,
    62809,
    4563,
    [142, 58, 0, 192, 79, 104, 55, 213],
);
pub const BHID_Storage: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    964813351,
    62809,
    4563,
    [142, 58, 0, 192, 79, 104, 55, 213],
);
pub const BHID_StorageEnum: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1176610019,
    61654,
    18291,
    [138, 156, 70, 231, 123, 23, 72, 64],
);
pub const BHID_StorageItem: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1078862089,
    30674,
    18073,
    [165, 160, 79, 223, 16, 219, 152, 55],
);
pub const BHID_Stream: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    485209003,
    31760,
    18842,
    [164, 23, 146, 202, 22, 196, 203, 131],
);
pub const BHID_ThumbnailHandler: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2066638090,
    36384,
    20298,
    [176, 158, 101, 151, 175, 199, 47, 176],
);
pub const BHID_Transfer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3588441761,
    63315,
    18738,
    [180, 3, 69, 116, 128, 14, 36, 152],
);
pub const BIF_BROWSEFILEJUNCTIONS: u32 = 65536u32;
pub const BIF_BROWSEFORCOMPUTER: u32 = 4096u32;
pub const BIF_BROWSEFORPRINTER: u32 = 8192u32;
pub const BIF_BROWSEINCLUDEFILES: u32 = 16384u32;
pub const BIF_BROWSEINCLUDEURLS: u32 = 128u32;
pub const BIF_DONTGOBELOWDOMAIN: u32 = 2u32;
pub const BIF_EDITBOX: u32 = 16u32;
pub const BIF_NEWDIALOGSTYLE: u32 = 64u32;
pub const BIF_NONEWFOLDERBUTTON: u32 = 512u32;
pub const BIF_NOTRANSLATETARGETS: u32 = 1024u32;
pub const BIF_RETURNFSANCESTORS: u32 = 8u32;
pub const BIF_RETURNONLYFSDIRS: u32 = 1u32;
pub const BIF_SHAREABLE: u32 = 32768u32;
pub const BIF_STATUSTEXT: u32 = 4u32;
pub const BIF_UAHINT: u32 = 256u32;
pub const BIF_VALIDATE: u32 = 32u32;
pub const BIND_INTERRUPTABLE: u32 = 4294967295u32;
pub const BMICON_LARGE: i32 = 0i32;
pub const BMICON_SMALL: i32 = 1i32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct BNSTATE(pub i32);
pub const BNS_NORMAL: BNSTATE = BNSTATE(0i32);
pub const BNS_BEGIN_NAVIGATE: BNSTATE = BNSTATE(1i32);
pub const BNS_NAVIGATE: BNSTATE = BNSTATE(2i32);
impl ::std::convert::From<i32> for BNSTATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BNSTATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BROWSEINFOA {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut ITEMIDLIST,
    pub pszDisplayName: super::super::Foundation::PSTR,
    pub lpszTitle: super::super::Foundation::PSTR,
    pub ulFlags: u32,
    pub lpfn: ::std::option::Option<BFFCALLBACK>,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl BROWSEINFOA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BROWSEINFOA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BROWSEINFOA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BROWSEINFOA")
            .field("hwndOwner", &self.hwndOwner)
            .field("pidlRoot", &self.pidlRoot)
            .field("pszDisplayName", &self.pszDisplayName)
            .field("lpszTitle", &self.lpszTitle)
            .field("ulFlags", &self.ulFlags)
            .field("lParam", &self.lParam)
            .field("iImage", &self.iImage)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BROWSEINFOA {
    fn eq(&self, other: &Self) -> bool {
        self.hwndOwner == other.hwndOwner
            && self.pidlRoot == other.pidlRoot
            && self.pszDisplayName == other.pszDisplayName
            && self.lpszTitle == other.lpszTitle
            && self.ulFlags == other.ulFlags
            && self.lpfn.map(|f| f as usize) == other.lpfn.map(|f| f as usize)
            && self.lParam == other.lParam
            && self.iImage == other.iImage
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BROWSEINFOA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BROWSEINFOA {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BROWSEINFOW {
    pub hwndOwner: super::super::Foundation::HWND,
    pub pidlRoot: *mut ITEMIDLIST,
    pub pszDisplayName: super::super::Foundation::PWSTR,
    pub lpszTitle: super::super::Foundation::PWSTR,
    pub ulFlags: u32,
    pub lpfn: ::std::option::Option<BFFCALLBACK>,
    pub lParam: super::super::Foundation::LPARAM,
    pub iImage: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl BROWSEINFOW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BROWSEINFOW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BROWSEINFOW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BROWSEINFOW")
            .field("hwndOwner", &self.hwndOwner)
            .field("pidlRoot", &self.pidlRoot)
            .field("pszDisplayName", &self.pszDisplayName)
            .field("lpszTitle", &self.lpszTitle)
            .field("ulFlags", &self.ulFlags)
            .field("lParam", &self.lParam)
            .field("iImage", &self.iImage)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BROWSEINFOW {
    fn eq(&self, other: &Self) -> bool {
        self.hwndOwner == other.hwndOwner
            && self.pidlRoot == other.pidlRoot
            && self.pszDisplayName == other.pszDisplayName
            && self.lpszTitle == other.lpszTitle
            && self.ulFlags == other.ulFlags
            && self.lpfn.map(|f| f as usize) == other.lpfn.map(|f| f as usize)
            && self.lParam == other.lParam
            && self.iImage == other.iImage
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BROWSEINFOW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BROWSEINFOW {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
pub const BSF_CANMAXIMIZE: u32 = 1024u32;
pub const BSF_DELEGATEDNAVIGATION: u32 = 65536u32;
pub const BSF_DONTSHOWNAVCANCELPAGE: u32 = 16384u32;
pub const BSF_FEEDNAVIGATION: u32 = 524288u32;
pub const BSF_FEEDSUBSCRIBED: u32 = 1048576u32;
pub const BSF_HTMLNAVCANCELED: u32 = 8192u32;
pub const BSF_MERGEDMENUS: u32 = 262144u32;
pub const BSF_NAVNOHISTORY: u32 = 4096u32;
pub const BSF_NOLOCALFILEWARNING: u32 = 16u32;
pub const BSF_REGISTERASDROPTARGET: u32 = 1u32;
pub const BSF_RESIZABLE: u32 = 512u32;
pub const BSF_SETNAVIGATABLECODEPAGE: u32 = 32768u32;
pub const BSF_THEATERMODE: u32 = 2u32;
pub const BSF_TOPBROWSER: u32 = 2048u32;
pub const BSF_TRUSTEDFORACTIVEX: u32 = 131072u32;
pub const BSF_UISETBYAUTOMATION: u32 = 256u32;
pub const BSIM_STATE: u32 = 1u32;
pub const BSIM_STYLE: u32 = 2u32;
pub const BSIS_ALWAYSGRIPPER: u32 = 2u32;
pub const BSIS_AUTOGRIPPER: u32 = 0u32;
pub const BSIS_FIXEDORDER: u32 = 1024u32;
pub const BSIS_LEFTALIGN: u32 = 4u32;
pub const BSIS_LOCKED: u32 = 256u32;
pub const BSIS_NOCAPTION: u32 = 64u32;
pub const BSIS_NOCONTEXTMENU: u32 = 16u32;
pub const BSIS_NODROPTARGET: u32 = 32u32;
pub const BSIS_NOGRIPPER: u32 = 1u32;
pub const BSIS_PREFERNOLINEBREAK: u32 = 128u32;
pub const BSIS_PRESERVEORDERDURINGLAYOUT: u32 = 512u32;
pub const BSIS_SINGLECLICK: u32 = 8u32;
pub const BSSF_NOTITLE: u32 = 2u32;
pub const BSSF_UNDELETEABLE: u32 = 4096u32;
pub const BSSF_VISIBLE: u32 = 1u32;
pub const BUFFLEN: u32 = 255u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct CABINETSTATE {
    pub cLength: u16,
    pub nVersion: u16,
    pub _bitfield: i32,
    pub fMenuEnumFilter: u32,
}
impl CABINETSTATE {}
impl ::std::default::Default for CABINETSTATE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CABINETSTATE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CABINETSTATE {}
unsafe impl ::windows::runtime::Abi for CABINETSTATE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CABINETSTATE_VERSION: u32 = 2u32;
pub const CAMERAROLL_E_NO_DOWNSAMPLING_REQUIRED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927456i32 as _);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CATEGORYINFO_FLAGS(pub i32);
pub const CATINFO_NORMAL: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(0i32);
pub const CATINFO_COLLAPSED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(1i32);
pub const CATINFO_HIDDEN: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(2i32);
pub const CATINFO_EXPANDED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(4i32);
pub const CATINFO_NOHEADER: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(8i32);
pub const CATINFO_NOTCOLLAPSIBLE: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(16i32);
pub const CATINFO_NOHEADERCOUNT: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(32i32);
pub const CATINFO_SUBSETTED: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(64i32);
pub const CATINFO_SEPARATE_IMAGES: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(128i32);
pub const CATINFO_SHOWEMPTY: CATEGORYINFO_FLAGS = CATEGORYINFO_FLAGS(256i32);
impl ::std::convert::From<i32> for CATEGORYINFO_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CATEGORYINFO_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CATEGORY_INFO {
    pub cif: CATEGORYINFO_FLAGS,
    pub wszName: [u16; 260],
}
impl CATEGORY_INFO {}
impl ::std::default::Default for CATEGORY_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CATEGORY_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CATEGORY_INFO")
            .field("cif", &self.cif)
            .field("wszName", &self.wszName)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CATEGORY_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cif == other.cif && self.wszName == other.wszName
    }
}
impl ::std::cmp::Eq for CATEGORY_INFO {}
unsafe impl ::windows::runtime::Abi for CATEGORY_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CATID_BrowsableShellExt: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136336, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CATID_BrowseInPlace: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136337, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CATID_CommBand: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136340, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CATID_DeskBand: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136338, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CATID_FilePlaceholderMergeHandler: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1050450513,
        54442,
        18544,
        [180, 124, 116, 36, 180, 145, 241, 204],
    );
pub const CATID_InfoBand: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136339, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CATID_LocationFactory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2522631505,
    35702,
    20055,
    [128, 183, 86, 77, 46, 164, 181, 94],
);
pub const CATID_LocationProvider: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    456959092,
    9748,
    16715,
    [184, 19, 26, 206, 202, 62, 61, 216],
);
pub const CATID_SearchableApplication: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        913058090,
        55731,
        19903,
        [187, 112, 230, 46, 195, 208, 187, 191],
    );
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CATSORT_FLAGS(pub i32);
pub const CATSORT_DEFAULT: CATSORT_FLAGS = CATSORT_FLAGS(0i32);
pub const CATSORT_NAME: CATSORT_FLAGS = CATSORT_FLAGS(1i32);
impl ::std::convert::From<i32> for CATSORT_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CATSORT_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CDB2GVF_ADDSHIELD: u32 = 64u32;
pub const CDB2GVF_ALLOWPREVIEWPANE: u32 = 4u32;
pub const CDB2GVF_ISFILESAVE: u32 = 2u32;
pub const CDB2GVF_ISFOLDERPICKER: u32 = 32u32;
pub const CDB2GVF_NOINCLUDEITEM: u32 = 16u32;
pub const CDB2GVF_NOSELECTVERB: u32 = 8u32;
pub const CDB2GVF_SHOWALLFILES: u32 = 1u32;
pub const CDB2N_CONTEXTMENU_DONE: u32 = 1u32;
pub const CDB2N_CONTEXTMENU_START: u32 = 2u32;
pub const CDBOSC_KILLFOCUS: u32 = 1u32;
pub const CDBOSC_RENAME: u32 = 3u32;
pub const CDBOSC_SELCHANGE: u32 = 2u32;
pub const CDBOSC_SETFOCUS: u32 = 0u32;
pub const CDBOSC_STATECHANGE: u32 = 4u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CDBURNINGEXTENSIONRET(pub i32);
pub const CDBE_RET_DEFAULT: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(0i32);
pub const CDBE_RET_DONTRUNOTHEREXTS: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(1i32);
pub const CDBE_RET_STOPWIZARD: CDBURNINGEXTENSIONRET = CDBURNINGEXTENSIONRET(2i32);
impl ::std::convert::From<i32> for CDBURNINGEXTENSIONRET {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CDBURNINGEXTENSIONRET {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CDBurn: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4226517509,
    48878,
    17474,
    [128, 78, 64, 157, 108, 69, 21, 233],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CDCONTROLSTATEF(pub i32);
pub const CDCS_INACTIVE: CDCONTROLSTATEF = CDCONTROLSTATEF(0i32);
pub const CDCS_ENABLED: CDCONTROLSTATEF = CDCONTROLSTATEF(1i32);
pub const CDCS_VISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(2i32);
pub const CDCS_ENABLEDVISIBLE: CDCONTROLSTATEF = CDCONTROLSTATEF(3i32);
impl ::std::convert::From<i32> for CDCONTROLSTATEF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CDCONTROLSTATEF {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_Com",
    feature = "Win32_System_Registry"
))]
pub unsafe fn CDefFolderMenu_Create2<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param4: ::windows::runtime::IntoParam<'a, IShellFolder>,
>(
    pidlfolder: *const ITEMIDLIST,
    hwnd: Param1,
    cidl: u32,
    apidl: *const *const ITEMIDLIST,
    psf: Param4,
    pfn: ::std::option::Option<LPFNDFMCALLBACK>,
    nkeys: u32,
    ahkeys: *const super::super::System::Registry::HKEY,
) -> ::windows::runtime::Result<IContextMenu> {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn CDefFolderMenu_Create2(
                pidlfolder: *const ITEMIDLIST,
                hwnd: super::super::Foundation::HWND,
                cidl: u32,
                apidl: *const *const ITEMIDLIST,
                psf: ::windows::runtime::RawPtr,
                pfn: ::windows::runtime::RawPtr,
                nkeys: u32,
                ahkeys: *const super::super::System::Registry::HKEY,
                ppcm: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IContextMenu as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        CDefFolderMenu_Create2(
            ::std::mem::transmute(pidlfolder),
            hwnd.into_param().abi(),
            ::std::mem::transmute(cidl),
            ::std::mem::transmute(apidl),
            psf.into_param().abi(),
            ::std::mem::transmute(pfn),
            ::std::mem::transmute(nkeys),
            ::std::mem::transmute(ahkeys),
            &mut result__,
        )
        .from_abi::<IContextMenu>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const CGID_DefView: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1257275152,
    53809,
    4560,
    [185, 66, 0, 160, 201, 3, 18, 225],
);
pub const CGID_Explorer: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136400, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CGID_ExplorerBarDoc: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136403, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CGID_MENUDESKBAR: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1553926674,
    38302,
    4560,
    [163, 164, 0, 160, 201, 8, 38, 54],
);
pub const CGID_ShellDocView: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136401, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CGID_ShellServiceObject: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136402, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const CGID_ShortCut: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(2477164368, 38170, 4561, [148, 111, 0, 0, 0, 0, 0, 0]);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct CIDA {
    pub cidl: u32,
    pub aoffset: [u32; 1],
}
impl CIDA {}
impl ::std::default::Default for CIDA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CIDA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CIDA {}
unsafe impl ::windows::runtime::Abi for CIDA {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_System_Com")]
pub unsafe fn CIDLData_CreateFromIDArray(
    pidlfolder: *const ITEMIDLIST,
    cidl: u32,
    apidl: *const *const ITEMIDLIST,
) -> ::windows::runtime::Result<super::super::System::Com::IDataObject> {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn CIDLData_CreateFromIDArray(
                pidlfolder: *const ITEMIDLIST,
                cidl: u32,
                apidl: *const *const ITEMIDLIST,
                ppdtobj: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::System::Com::IDataObject as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        CIDLData_CreateFromIDArray(
            ::std::mem::transmute(pidlfolder),
            ::std::mem::transmute(cidl),
            ::std::mem::transmute(apidl),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IDataObject>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct CIE4ConnectionPoint(::windows::runtime::IUnknown);
impl CIE4ConnectionPoint {
    pub unsafe fn GetConnectionInterface(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::GUID>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetConnectionPointContainer(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IConnectionPointContainer> {
        let mut result__ : < super::super::System::Com:: IConnectionPointContainer as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IConnectionPointContainer>(result__)
    }
    pub unsafe fn Advise<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        punksink: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            punksink.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwcookie),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumConnections(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IEnumConnections> {
        let mut result__ : < super::super::System::Com:: IEnumConnections as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IEnumConnections>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn DoInvokeIE4(
        &self,
        pf: *mut super::super::Foundation::BOOL,
        ppv: *mut *mut ::std::ffi::c_void,
        dispid: i32,
        pdispparams: *mut super::super::System::OleAutomation::DISPPARAMS,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pf),
            ::std::mem::transmute(ppv),
            ::std::mem::transmute(dispid),
            ::std::mem::transmute(pdispparams),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DoInvokePIDLIE4<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        dispid: i32,
        pidl: *mut ITEMIDLIST,
        fcancancel: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispid),
            ::std::mem::transmute(pidl),
            fcancancel.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for CIE4ConnectionPoint {
    type Vtable = CIE4ConnectionPoint_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<CIE4ConnectionPoint> for ::windows::runtime::IUnknown {
    fn from(value: CIE4ConnectionPoint) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&CIE4ConnectionPoint> for ::windows::runtime::IUnknown {
    fn from(value: &CIE4ConnectionPoint) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for CIE4ConnectionPoint {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &CIE4ConnectionPoint {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::convert::From<CIE4ConnectionPoint> for super::super::System::Com::IConnectionPoint {
    fn from(value: CIE4ConnectionPoint) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_Com")]
impl ::std::convert::From<&CIE4ConnectionPoint> for super::super::System::Com::IConnectionPoint {
    fn from(value: &CIE4ConnectionPoint) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Com::IConnectionPoint>
    for CIE4ConnectionPoint
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::Com::IConnectionPoint> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::Com::IConnectionPoint,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_Com")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::Com::IConnectionPoint>
    for &CIE4ConnectionPoint
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::Com::IConnectionPoint> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::Com::IConnectionPoint,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct CIE4ConnectionPoint_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        piid: *mut ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppcpc: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punksink: ::windows::runtime::RawPtr,
        pdwcookie: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwcookie: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppenum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pf: *mut super::super::Foundation::BOOL,
        ppv: *mut *mut ::std::ffi::c_void,
        dispid: i32,
        pdispparams: *mut super::super::System::OleAutomation::DISPPARAMS,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispid: i32,
        pidl: *mut ITEMIDLIST,
        fcancancel: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
pub const CLOSEPROPS_DISCARD: u32 = 1u32;
pub const CLOSEPROPS_NONE: u32 = 0u32;
pub const CLSID_ACLCustomMRU: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1765137299,
    8680,
    19660,
    [190, 185, 159, 227, 199, 122, 41, 122],
);
pub const CLSID_ACLHistory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    12265316,
    27255,
    4560,
    [165, 53, 0, 192, 79, 215, 208, 98],
);
pub const CLSID_ACLMRU: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1733731905,
    56945,
    4560,
    [131, 27, 0, 170, 0, 91, 67, 131],
);
pub const CLSID_ACLMulti: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    12265317,
    27255,
    4560,
    [165, 53, 0, 192, 79, 215, 208, 98],
);
pub const CLSID_ACListISF: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(62928625, 41350, 4560, [130, 74, 0, 170, 0, 91, 67, 131]);
pub const CLSID_ActiveDesktop: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1963230976,
    61215,
    4560,
    [152, 136, 0, 96, 151, 222, 172, 249],
);
pub const CLSID_AutoComplete: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    12265315,
    27255,
    4560,
    [165, 53, 0, 192, 79, 215, 208, 98],
);
pub const CLSID_CAnchorBrowsePropertyPage: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        810611643,
        39093,
        4559,
        [187, 130, 0, 170, 0, 189, 206, 11],
    );
pub const CLSID_CDocBrowsePropertyPage: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        810611636,
        39093,
        4559,
        [187, 130, 0, 170, 0, 189, 206, 11],
    );
pub const CLSID_CFSIconOverlayManager: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1672814465,
        51304,
        4560,
        [153, 156, 0, 192, 79, 214, 85, 225],
    );
pub const CLSID_CImageBrowsePropertyPage: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        810611635,
        39093,
        4559,
        [187, 130, 0, 170, 0, 189, 206, 11],
    );
pub const CLSID_CURLSearchHook: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3485445632,
    6054,
    4560,
    [153, 203, 0, 192, 79, 214, 68, 151],
);
pub const CLSID_CUrlHistory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1010256448,
    47844,
    4559,
    [191, 125, 0, 170, 0, 105, 70, 238],
);
pub const CLSID_ControlPanel: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    569122848,
    15082,
    4201,
    [162, 221, 8, 0, 43, 48, 48, 157],
);
pub const CLSID_DarwinAppPublisher: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3486304160,
        41602,
        4561,
        [144, 130, 0, 96, 8, 5, 147, 130],
    );
pub const CLSID_DocHostUIHandler: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1884809554,
    48411,
    4561,
    [137, 25, 0, 192, 79, 194, 200, 54],
);
pub const CLSID_DragDropHelper: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1180116874,
    16667,
    4562,
    [131, 154, 0, 192, 79, 217, 24, 208],
);
pub const CLSID_FileTypes: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2962351424,
    33763,
    4559,
    [167, 19, 0, 32, 175, 215, 151, 98],
);
pub const CLSID_FolderItemsMultiLevel: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1405569062,
        43929,
        19763,
        [172, 164, 49, 23, 245, 29, 55, 136],
    );
pub const CLSID_FolderShortcut: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    184209105,
    59432,
    4561,
    [145, 135, 181, 50, 241, 233, 87, 93],
);
pub const CLSID_HWShellExecute: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4290274655,
    33209,
    20430,
    [184, 156, 154, 107, 167, 109, 19, 231],
);
pub const CLSID_ISFBand: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3626754736,
    22372,
    4560,
    [169, 110, 0, 192, 79, 215, 5, 162],
);
pub const CLSID_Internet: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2266780544,
    17056,
    4201,
    [162, 234, 8, 0, 43, 48, 48, 157],
);
pub const CLSID_InternetButtons: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    511273344,
    40133,
    4561,
    [168, 63, 0, 192, 79, 201, 157, 97],
);
pub const CLSID_InternetShortcut: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4226956096,
    58352,
    4123,
    [132, 136, 0, 170, 0, 62, 86, 248],
);
pub const CLSID_LinkColumnProvider: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        619794178,
        31516,
        4561,
        [131, 143, 0, 0, 248, 4, 97, 207],
    );
pub const CLSID_MSOButtons: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    395261112,
    41602,
    4562,
    [134, 197, 0, 192, 79, 142, 234, 153],
);
pub const CLSID_MenuBand: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1531817510,
    47111,
    4560,
    [152, 21, 0, 192, 79, 217, 25, 114],
);
pub const CLSID_MenuBandSite: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3778999524,
    54002,
    4560,
    [152, 22, 0, 192, 79, 217, 25, 114],
);
pub const CLSID_MenuToolbarBase: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1085892112,
    46370,
    4561,
    [179, 180, 0, 170, 0, 110, 253, 231],
);
pub const CLSID_MyComputer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    550522848,
    15082,
    4201,
    [162, 216, 8, 0, 43, 48, 48, 157],
);
pub const CLSID_MyDocuments: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(1158516666, 44325, 4560, [152, 168, 8, 0, 54, 27, 17, 3]);
pub const CLSID_NetworkDomain: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1189111424,
    19440,
    4561,
    [131, 238, 0, 160, 201, 13, 200, 73],
);
pub const CLSID_NetworkServer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3226741392,
    19440,
    4561,
    [131, 238, 0, 160, 201, 13, 200, 73],
);
pub const CLSID_NetworkShare: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1420252352,
    19440,
    4561,
    [131, 238, 0, 160, 201, 13, 200, 73],
);
pub const CLSID_NewMenu: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3647578880,
    59391,
    4560,
    [169, 59, 0, 160, 201, 15, 39, 25],
);
pub const CLSID_Printers: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    573022848,
    15082,
    4201,
    [162, 222, 8, 0, 43, 48, 48, 157],
);
pub const CLSID_ProgressDialog: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4164434002,
    64723,
    4561,
    [166, 185, 0, 96, 151, 223, 91, 212],
);
pub const CLSID_QueryAssociations: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2691708157,
    27818,
    18772,
    [172, 63, 151, 162, 114, 22, 249, 138],
);
pub const CLSID_QuickLinks: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(240959265, 53599, 4560, [131, 1, 0, 170, 0, 91, 67, 131]);
pub const CLSID_RecycleBin: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1684009024,
    20609,
    4123,
    [159, 8, 0, 170, 0, 47, 149, 78],
);
pub const CLSID_ShellFldSetExt: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1834161088,
    35938,
    4561,
    [178, 205, 0, 96, 151, 223, 140, 17],
);
pub const CLSID_ShellThumbnailDiskCache: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        515755904,
        41472,
        4560,
        [163, 164, 0, 192, 79, 215, 6, 236],
    );
pub const CLSID_ToolbarExtButtons: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    753186264,
    41615,
    4562,
    [134, 197, 0, 192, 79, 142, 234, 153],
);
pub const CMDID_INTSHORTCUTCREATE: i32 = 1i32;
pub const CMF_ASYNCVERBSTATE: u32 = 1024u32;
pub const CMF_CANRENAME: u32 = 16u32;
pub const CMF_DEFAULTONLY: u32 = 1u32;
pub const CMF_DISABLEDVERBS: u32 = 512u32;
pub const CMF_DONOTPICKDEFAULT: u32 = 8192u32;
pub const CMF_EXPLORE: u32 = 4u32;
pub const CMF_EXTENDEDVERBS: u32 = 256u32;
pub const CMF_INCLUDESTATIC: u32 = 64u32;
pub const CMF_ITEMMENU: u32 = 128u32;
pub const CMF_NODEFAULT: u32 = 32u32;
pub const CMF_NORMAL: u32 = 0u32;
pub const CMF_NOVERBS: u32 = 8u32;
pub const CMF_OPTIMIZEFORINVOKE: u32 = 2048u32;
pub const CMF_RESERVED: u32 = 4294901760u32;
pub const CMF_SYNCCASCADEMENU: u32 = 4096u32;
pub const CMF_VERBSONLY: u32 = 2u32;
pub const CMIC_MASK_CONTROL_DOWN: u32 = 1073741824u32;
pub const CMIC_MASK_PTINVOKE: u32 = 536870912u32;
pub const CMIC_MASK_SHIFT_DOWN: u32 = 268435456u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFO {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: super::super::Foundation::PSTR,
    pub lpParameters: super::super::Foundation::PSTR,
    pub lpDirectory: super::super::Foundation::PSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl CMINVOKECOMMANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMINVOKECOMMANDINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMINVOKECOMMANDINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMINVOKECOMMANDINFO")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("hwnd", &self.hwnd)
            .field("lpVerb", &self.lpVerb)
            .field("lpParameters", &self.lpParameters)
            .field("lpDirectory", &self.lpDirectory)
            .field("nShow", &self.nShow)
            .field("dwHotKey", &self.dwHotKey)
            .field("hIcon", &self.hIcon)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMINVOKECOMMANDINFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.fMask == other.fMask
            && self.hwnd == other.hwnd
            && self.lpVerb == other.lpVerb
            && self.lpParameters == other.lpParameters
            && self.lpDirectory == other.lpDirectory
            && self.nShow == other.nShow
            && self.dwHotKey == other.dwHotKey
            && self.hIcon == other.hIcon
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMINVOKECOMMANDINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMINVOKECOMMANDINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFOEX {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerb: super::super::Foundation::PSTR,
    pub lpParameters: super::super::Foundation::PSTR,
    pub lpDirectory: super::super::Foundation::PSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub hIcon: super::super::Foundation::HANDLE,
    pub lpTitle: super::super::Foundation::PSTR,
    pub lpVerbW: super::super::Foundation::PWSTR,
    pub lpParametersW: super::super::Foundation::PWSTR,
    pub lpDirectoryW: super::super::Foundation::PWSTR,
    pub lpTitleW: super::super::Foundation::PWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
}
#[cfg(feature = "Win32_Foundation")]
impl CMINVOKECOMMANDINFOEX {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMINVOKECOMMANDINFOEX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMINVOKECOMMANDINFOEX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMINVOKECOMMANDINFOEX")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("hwnd", &self.hwnd)
            .field("lpVerb", &self.lpVerb)
            .field("lpParameters", &self.lpParameters)
            .field("lpDirectory", &self.lpDirectory)
            .field("nShow", &self.nShow)
            .field("dwHotKey", &self.dwHotKey)
            .field("hIcon", &self.hIcon)
            .field("lpTitle", &self.lpTitle)
            .field("lpVerbW", &self.lpVerbW)
            .field("lpParametersW", &self.lpParametersW)
            .field("lpDirectoryW", &self.lpDirectoryW)
            .field("lpTitleW", &self.lpTitleW)
            .field("ptInvoke", &self.ptInvoke)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMINVOKECOMMANDINFOEX {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.fMask == other.fMask
            && self.hwnd == other.hwnd
            && self.lpVerb == other.lpVerb
            && self.lpParameters == other.lpParameters
            && self.lpDirectory == other.lpDirectory
            && self.nShow == other.nShow
            && self.dwHotKey == other.dwHotKey
            && self.hIcon == other.hIcon
            && self.lpTitle == other.lpTitle
            && self.lpVerbW == other.lpVerbW
            && self.lpParametersW == other.lpParametersW
            && self.lpDirectoryW == other.lpDirectoryW
            && self.lpTitleW == other.lpTitleW
            && self.ptInvoke == other.ptInvoke
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMINVOKECOMMANDINFOEX {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMINVOKECOMMANDINFOEX {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CMINVOKECOMMANDINFOEX_REMOTE {
    pub cbSize: u32,
    pub fMask: u32,
    pub hwnd: super::super::Foundation::HWND,
    pub lpVerbString: super::super::Foundation::PSTR,
    pub lpParameters: super::super::Foundation::PSTR,
    pub lpDirectory: super::super::Foundation::PSTR,
    pub nShow: i32,
    pub dwHotKey: u32,
    pub lpTitle: super::super::Foundation::PSTR,
    pub lpVerbWString: super::super::Foundation::PWSTR,
    pub lpParametersW: super::super::Foundation::PWSTR,
    pub lpDirectoryW: super::super::Foundation::PWSTR,
    pub lpTitleW: super::super::Foundation::PWSTR,
    pub ptInvoke: super::super::Foundation::POINT,
    pub lpVerbInt: u32,
    pub lpVerbWInt: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CMINVOKECOMMANDINFOEX_REMOTE {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CMINVOKECOMMANDINFOEX_REMOTE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CMINVOKECOMMANDINFOEX_REMOTE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CMINVOKECOMMANDINFOEX_REMOTE")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("hwnd", &self.hwnd)
            .field("lpVerbString", &self.lpVerbString)
            .field("lpParameters", &self.lpParameters)
            .field("lpDirectory", &self.lpDirectory)
            .field("nShow", &self.nShow)
            .field("dwHotKey", &self.dwHotKey)
            .field("lpTitle", &self.lpTitle)
            .field("lpVerbWString", &self.lpVerbWString)
            .field("lpParametersW", &self.lpParametersW)
            .field("lpDirectoryW", &self.lpDirectoryW)
            .field("lpTitleW", &self.lpTitleW)
            .field("ptInvoke", &self.ptInvoke)
            .field("lpVerbInt", &self.lpVerbInt)
            .field("lpVerbWInt", &self.lpVerbWInt)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CMINVOKECOMMANDINFOEX_REMOTE {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.fMask == other.fMask
            && self.hwnd == other.hwnd
            && self.lpVerbString == other.lpVerbString
            && self.lpParameters == other.lpParameters
            && self.lpDirectory == other.lpDirectory
            && self.nShow == other.nShow
            && self.dwHotKey == other.dwHotKey
            && self.lpTitle == other.lpTitle
            && self.lpVerbWString == other.lpVerbWString
            && self.lpParametersW == other.lpParametersW
            && self.lpDirectoryW == other.lpDirectoryW
            && self.lpTitleW == other.lpTitleW
            && self.ptInvoke == other.ptInvoke
            && self.lpVerbInt == other.lpVerbInt
            && self.lpVerbWInt == other.lpVerbWInt
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CMINVOKECOMMANDINFOEX_REMOTE {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CMINVOKECOMMANDINFOEX_REMOTE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CM_COLUMNINFO {
    pub cbSize: u32,
    pub dwMask: u32,
    pub dwState: u32,
    pub uWidth: u32,
    pub uDefaultWidth: u32,
    pub uIdealWidth: u32,
    pub wszName: [u16; 80],
}
impl CM_COLUMNINFO {}
impl ::std::default::Default for CM_COLUMNINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CM_COLUMNINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CM_COLUMNINFO")
            .field("cbSize", &self.cbSize)
            .field("dwMask", &self.dwMask)
            .field("dwState", &self.dwState)
            .field("uWidth", &self.uWidth)
            .field("uDefaultWidth", &self.uDefaultWidth)
            .field("uIdealWidth", &self.uIdealWidth)
            .field("wszName", &self.wszName)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CM_COLUMNINFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwMask == other.dwMask
            && self.dwState == other.dwState
            && self.uWidth == other.uWidth
            && self.uDefaultWidth == other.uDefaultWidth
            && self.uIdealWidth == other.uIdealWidth
            && self.wszName == other.wszName
    }
}
impl ::std::cmp::Eq for CM_COLUMNINFO {}
unsafe impl ::windows::runtime::Abi for CM_COLUMNINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CM_ENUM_FLAGS(pub i32);
pub const CM_ENUM_ALL: CM_ENUM_FLAGS = CM_ENUM_FLAGS(1i32);
pub const CM_ENUM_VISIBLE: CM_ENUM_FLAGS = CM_ENUM_FLAGS(2i32);
impl ::std::convert::From<i32> for CM_ENUM_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CM_ENUM_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CM_MASK(pub i32);
pub const CM_MASK_WIDTH: CM_MASK = CM_MASK(1i32);
pub const CM_MASK_DEFAULTWIDTH: CM_MASK = CM_MASK(2i32);
pub const CM_MASK_IDEALWIDTH: CM_MASK = CM_MASK(4i32);
pub const CM_MASK_NAME: CM_MASK = CM_MASK(8i32);
pub const CM_MASK_STATE: CM_MASK = CM_MASK(16i32);
impl ::std::convert::From<i32> for CM_MASK {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CM_MASK {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CM_SET_WIDTH_VALUE(pub i32);
pub const CM_WIDTH_USEDEFAULT: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-1i32);
pub const CM_WIDTH_AUTOSIZE: CM_SET_WIDTH_VALUE = CM_SET_WIDTH_VALUE(-2i32);
impl ::std::convert::From<i32> for CM_SET_WIDTH_VALUE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CM_SET_WIDTH_VALUE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CM_STATE(pub i32);
pub const CM_STATE_NONE: CM_STATE = CM_STATE(0i32);
pub const CM_STATE_VISIBLE: CM_STATE = CM_STATE(1i32);
pub const CM_STATE_FIXEDWIDTH: CM_STATE = CM_STATE(2i32);
pub const CM_STATE_NOSORTBYFOLDERNESS: CM_STATE = CM_STATE(4i32);
pub const CM_STATE_ALWAYSVISIBLE: CM_STATE = CM_STATE(8i32);
impl ::std::convert::From<i32> for CM_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CM_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct COMDLG_FILTERSPEC {
    pub pszName: super::super::Foundation::PWSTR,
    pub pszSpec: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl COMDLG_FILTERSPEC {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for COMDLG_FILTERSPEC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for COMDLG_FILTERSPEC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("COMDLG_FILTERSPEC")
            .field("pszName", &self.pszName)
            .field("pszSpec", &self.pszSpec)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for COMDLG_FILTERSPEC {
    fn eq(&self, other: &Self) -> bool {
        self.pszName == other.pszName && self.pszSpec == other.pszSpec
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for COMDLG_FILTERSPEC {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for COMDLG_FILTERSPEC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const COMPONENT_DEFAULT_LEFT: u32 = 65535u32;
pub const COMPONENT_DEFAULT_TOP: u32 = 65535u32;
pub const COMPONENT_TOP: u32 = 1073741823u32;
pub const COMP_ELEM_CHECKED: u32 = 2u32;
pub const COMP_ELEM_CURITEMSTATE: u32 = 16384u32;
pub const COMP_ELEM_DIRTY: u32 = 4u32;
pub const COMP_ELEM_FRIENDLYNAME: u32 = 1024u32;
pub const COMP_ELEM_NOSCROLL: u32 = 8u32;
pub const COMP_ELEM_ORIGINAL_CSI: u32 = 4096u32;
pub const COMP_ELEM_POS_LEFT: u32 = 16u32;
pub const COMP_ELEM_POS_TOP: u32 = 32u32;
pub const COMP_ELEM_POS_ZINDEX: u32 = 256u32;
pub const COMP_ELEM_RESTORED_CSI: u32 = 8192u32;
pub const COMP_ELEM_SIZE_HEIGHT: u32 = 128u32;
pub const COMP_ELEM_SIZE_WIDTH: u32 = 64u32;
pub const COMP_ELEM_SOURCE: u32 = 512u32;
pub const COMP_ELEM_SUBSCRIBEDURL: u32 = 2048u32;
pub const COMP_ELEM_TYPE: u32 = 1u32;
pub const COMP_TYPE_CFHTML: u32 = 4u32;
pub const COMP_TYPE_CONTROL: u32 = 3u32;
pub const COMP_TYPE_HTMLDOC: u32 = 0u32;
pub const COMP_TYPE_MAX: u32 = 4u32;
pub const COMP_TYPE_PICTURE: u32 = 1u32;
pub const COMP_TYPE_WEBSITE: u32 = 2u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CONFIRM_CONFLICT_ITEM {
    pub pShellItem: ::std::option::Option<IShellItem2>,
    pub pszOriginalName: super::super::Foundation::PWSTR,
    pub pszAlternateName: super::super::Foundation::PWSTR,
    pub pszLocationShort: super::super::Foundation::PWSTR,
    pub pszLocationFull: super::super::Foundation::PWSTR,
    pub nType: SYNCMGR_CONFLICT_ITEM_TYPE,
}
#[cfg(feature = "Win32_Foundation")]
impl CONFIRM_CONFLICT_ITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CONFIRM_CONFLICT_ITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CONFIRM_CONFLICT_ITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CONFIRM_CONFLICT_ITEM")
            .field("pShellItem", &self.pShellItem)
            .field("pszOriginalName", &self.pszOriginalName)
            .field("pszAlternateName", &self.pszAlternateName)
            .field("pszLocationShort", &self.pszLocationShort)
            .field("pszLocationFull", &self.pszLocationFull)
            .field("nType", &self.nType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CONFIRM_CONFLICT_ITEM {
    fn eq(&self, other: &Self) -> bool {
        self.pShellItem == other.pShellItem
            && self.pszOriginalName == other.pszOriginalName
            && self.pszAlternateName == other.pszAlternateName
            && self.pszLocationShort == other.pszLocationShort
            && self.pszLocationFull == other.pszLocationFull
            && self.nType == other.nType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CONFIRM_CONFLICT_ITEM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CONFIRM_CONFLICT_ITEM {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CONFIRM_CONFLICT_RESULT_INFO {
    pub pszNewName: super::super::Foundation::PWSTR,
    pub iItemIndex: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl CONFIRM_CONFLICT_RESULT_INFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CONFIRM_CONFLICT_RESULT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CONFIRM_CONFLICT_RESULT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CONFIRM_CONFLICT_RESULT_INFO")
            .field("pszNewName", &self.pszNewName)
            .field("iItemIndex", &self.iItemIndex)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CONFIRM_CONFLICT_RESULT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.pszNewName == other.pszNewName && self.iItemIndex == other.iItemIndex
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CONFIRM_CONFLICT_RESULT_INFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CONFIRM_CONFLICT_RESULT_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const COPYENGINE_E_ACCESSDENIED_READONLY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927681i32 as _);
pub const COPYENGINE_E_ACCESS_DENIED_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927710i32 as _);
pub const COPYENGINE_E_ACCESS_DENIED_SRC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927711i32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_FOLDER: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927700i32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_NORMAL: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927703i32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_READONLY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927702i32 as _);
pub const COPYENGINE_E_ALREADY_EXISTS_SYSTEM: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927701i32 as _);
pub const COPYENGINE_E_BLOCKED_BY_DLP_POLICY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927666i32 as _);
pub const COPYENGINE_E_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927670i32 as _);
pub const COPYENGINE_E_BLOCKED_BY_EDP_POLICY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927672i32 as _);
pub const COPYENGINE_E_CANCELLED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927743i32 as _);
pub const COPYENGINE_E_CANNOT_MOVE_FROM_RECYCLE_BIN: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927677i32 as _);
pub const COPYENGINE_E_CANNOT_MOVE_SHARED_FOLDER: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927676i32 as _);
pub const COPYENGINE_E_CANT_REACH_SOURCE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927691i32 as _);
pub const COPYENGINE_E_DEST_IS_RO_CD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927729i32 as _);
pub const COPYENGINE_E_DEST_IS_RO_DVD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927726i32 as _);
pub const COPYENGINE_E_DEST_IS_RW_CD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927728i32 as _);
pub const COPYENGINE_E_DEST_IS_RW_DVD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927725i32 as _);
pub const COPYENGINE_E_DEST_IS_R_CD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927727i32 as _);
pub const COPYENGINE_E_DEST_IS_R_DVD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927724i32 as _);
pub const COPYENGINE_E_DEST_SAME_TREE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927734i32 as _);
pub const COPYENGINE_E_DEST_SUBTREE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927735i32 as _);
pub const COPYENGINE_E_DIFF_DIR: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927740i32 as _);
pub const COPYENGINE_E_DIR_NOT_EMPTY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927683i32 as _);
pub const COPYENGINE_E_DISK_FULL: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927694i32 as _);
pub const COPYENGINE_E_DISK_FULL_CLEAN: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927693i32 as _);
pub const COPYENGINE_E_EA_LOSS: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927698i32 as _);
pub const COPYENGINE_E_EA_NOT_SUPPORTED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927692i32 as _);
pub const COPYENGINE_E_ENCRYPTION_LOSS: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927695i32 as _);
pub const COPYENGINE_E_FAT_MAX_IN_ROOT: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927682i32 as _);
pub const COPYENGINE_E_FILE_IS_FLD_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927732i32 as _);
pub const COPYENGINE_E_FILE_TOO_LARGE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927731i32 as _);
pub const COPYENGINE_E_FLD_IS_FILE_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927733i32 as _);
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_ERROR: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927675i32 as _);
pub const COPYENGINE_E_INTERNET_ITEM_STORAGE_PROVIDER_PAUSED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927674i32 as _);
pub const COPYENGINE_E_INTERNET_ITEM_UNAVAILABLE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927678i32 as _);
pub const COPYENGINE_E_INVALID_FILES_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927716i32 as _);
pub const COPYENGINE_E_INVALID_FILES_SRC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927717i32 as _);
pub const COPYENGINE_E_MANY_SRC_1_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927739i32 as _);
pub const COPYENGINE_E_NET_DISCONNECT_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927706i32 as _);
pub const COPYENGINE_E_NET_DISCONNECT_SRC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927707i32 as _);
pub const COPYENGINE_E_NEWFILE_NAME_TOO_LONG: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927685i32 as _);
pub const COPYENGINE_E_NEWFOLDER_NAME_TOO_LONG: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927684i32 as _);
pub const COPYENGINE_E_PATH_NOT_FOUND_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927708i32 as _);
pub const COPYENGINE_E_PATH_NOT_FOUND_SRC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927709i32 as _);
pub const COPYENGINE_E_PATH_TOO_DEEP_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927714i32 as _);
pub const COPYENGINE_E_PATH_TOO_DEEP_SRC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927715i32 as _);
pub const COPYENGINE_E_PROPERTIES_LOSS: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927696i32 as _);
pub const COPYENGINE_E_PROPERTY_LOSS: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927697i32 as _);
pub const COPYENGINE_E_RECYCLE_BIN_NOT_FOUND: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927686i32 as _);
pub const COPYENGINE_E_RECYCLE_FORCE_NUKE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927690i32 as _);
pub const COPYENGINE_E_RECYCLE_PATH_TOO_LONG: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927688i32 as _);
pub const COPYENGINE_E_RECYCLE_SIZE_TOO_BIG: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927689i32 as _);
pub const COPYENGINE_E_RECYCLE_UNKNOWN_ERROR: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927691i32 as _);
pub const COPYENGINE_E_REDIRECTED_TO_WEBPAGE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927680i32 as _);
pub const COPYENGINE_E_REMOVABLE_FULL: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927730i32 as _);
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927673i32 as _);
pub const COPYENGINE_E_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927671i32 as _);
pub const COPYENGINE_E_REQUIRES_ELEVATION: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927742i32 as _);
pub const COPYENGINE_E_RMS_BLOCKED_BY_EDP_FOR_REMOVABLE_DRIVE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927668i32 as _);
pub const COPYENGINE_E_RMS_REQUIRES_EDP_CONSENT_FOR_REMOVABLE_DRIVE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927669i32 as _);
pub const COPYENGINE_E_ROOT_DIR_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927712i32 as _);
pub const COPYENGINE_E_ROOT_DIR_SRC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927713i32 as _);
pub const COPYENGINE_E_SAME_FILE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927741i32 as _);
pub const COPYENGINE_E_SERVER_BAD_FILE_TYPE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927679i32 as _);
pub const COPYENGINE_E_SHARING_VIOLATION_DEST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927704i32 as _);
pub const COPYENGINE_E_SHARING_VIOLATION_SRC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927705i32 as _);
pub const COPYENGINE_E_SILENT_FAIL_BY_DLP_POLICY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927665i32 as _);
pub const COPYENGINE_E_SRC_IS_RO_CD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927723i32 as _);
pub const COPYENGINE_E_SRC_IS_RO_DVD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927720i32 as _);
pub const COPYENGINE_E_SRC_IS_RW_CD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927722i32 as _);
pub const COPYENGINE_E_SRC_IS_RW_DVD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927719i32 as _);
pub const COPYENGINE_E_SRC_IS_R_CD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927721i32 as _);
pub const COPYENGINE_E_SRC_IS_R_DVD: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927718i32 as _);
pub const COPYENGINE_E_STREAM_LOSS: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927699i32 as _);
pub const COPYENGINE_E_USER_CANCELLED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927744i32 as _);
pub const COPYENGINE_E_WARNED_BY_DLP_POLICY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927667i32 as _);
pub const COPYENGINE_S_ALREADY_DONE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555914i32 as _);
pub const COPYENGINE_S_CLOSE_PROGRAM: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555917i32 as _);
pub const COPYENGINE_S_COLLISIONRESOLVED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555918i32 as _);
pub const COPYENGINE_S_DONT_PROCESS_CHILDREN: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555912i32 as _);
pub const COPYENGINE_S_KEEP_BOTH: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555916i32 as _);
pub const COPYENGINE_S_MERGE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555910i32 as _);
pub const COPYENGINE_S_NOT_HANDLED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555907i32 as _);
pub const COPYENGINE_S_PENDING: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555915i32 as _);
pub const COPYENGINE_S_PROGRESS_PAUSE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555919i32 as _);
pub const COPYENGINE_S_USER_IGNORED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555909i32 as _);
pub const COPYENGINE_S_USER_RETRY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555908i32 as _);
pub const COPYENGINE_S_YES: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(2555905i32 as _);
pub const CPFG_CREDENTIAL_PROVIDER_LABEL: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        678150131,
        47828,
        17295,
        [176, 7, 121, 183, 38, 124, 61, 72],
    );
pub const CPFG_CREDENTIAL_PROVIDER_LOGO: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        763590517,
        63181,
        17998,
        [167, 69, 72, 47, 208, 180, 116, 147],
    );
pub const CPFG_LOGON_PASSWORD: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1617054970,
    42103,
    18353,
    [138, 142, 58, 74, 25, 152, 24, 39],
);
pub const CPFG_LOGON_USERNAME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3658857448,
    38221,
    20435,
    [176, 244, 31, 181, 185, 11, 23, 75],
);
pub const CPFG_SMARTCARD_PIN: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1340417595,
    37249,
    18113,
    [176, 164, 157, 237, 212, 219, 125, 234],
);
pub const CPFG_SMARTCARD_USERNAME: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1042206569,
    22156,
    19862,
    [157, 89, 70, 68, 65, 116, 226, 214],
);
pub const CPFG_STANDALONE_SUBMIT_BUTTON: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        192613080,
        52278,
        19801,
        [128, 43, 130, 247, 20, 250, 112, 34],
    );
pub const CPFG_STYLE_LINK_AS_BUTTON: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        143631624,
        38054,
        17456,
        [164, 203, 111, 198, 227, 192, 185, 226],
    );
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct CPLINFO {
    pub idIcon: i32,
    pub idName: i32,
    pub idInfo: i32,
    pub lData: isize,
}
impl CPLINFO {}
impl ::std::default::Default for CPLINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CPLINFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CPLINFO {}
unsafe impl ::windows::runtime::Abi for CPLINFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CPLPAGE_DISPLAY_BACKGROUND: u32 = 1u32;
pub const CPLPAGE_KEYBOARD_SPEED: u32 = 1u32;
pub const CPLPAGE_MOUSE_BUTTONS: u32 = 1u32;
pub const CPLPAGE_MOUSE_PTRMOTION: u32 = 2u32;
pub const CPLPAGE_MOUSE_WHEEL: u32 = 3u32;
pub const CPL_DBLCLK: u32 = 5u32;
pub const CPL_DYNAMIC_RES: u32 = 0u32;
pub const CPL_EXIT: u32 = 7u32;
pub const CPL_GETCOUNT: u32 = 2u32;
pub const CPL_INIT: u32 = 1u32;
pub const CPL_INQUIRE: u32 = 3u32;
pub const CPL_NEWINQUIRE: u32 = 8u32;
pub const CPL_SELECT: u32 = 4u32;
pub const CPL_SETUP: u32 = 200u32;
pub const CPL_STARTWPARMS: u32 = 10u32;
pub const CPL_STARTWPARMSA: u32 = 9u32;
pub const CPL_STARTWPARMSW: u32 = 10u32;
pub const CPL_STOP: u32 = 6u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CPVIEW(pub i32);
pub const CPVIEW_CLASSIC: CPVIEW = CPVIEW(0i32);
pub const CPVIEW_ALLITEMS: CPVIEW = CPVIEW(0i32);
pub const CPVIEW_CATEGORY: CPVIEW = CPVIEW(1i32);
pub const CPVIEW_HOME: CPVIEW = CPVIEW(1i32);
impl ::std::convert::From<i32> for CPVIEW {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CPVIEW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(pub i32);
pub const CPAO_NONE: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS =
    CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(0i32);
pub const CPAO_EMPTY_LOCAL: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS =
    CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(1i32);
pub const CPAO_EMPTY_CONNECTED: CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS =
    CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS(2i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_ACCOUNT_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(pub i32);
pub const CPCFO_NONE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS =
    CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(0i32);
pub const CPCFO_ENABLE_PASSWORD_REVEAL: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS =
    CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(1i32);
pub const CPCFO_IS_EMAIL_ADDRESS: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS =
    CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(2i32);
pub const CPCFO_ENABLE_TOUCH_KEYBOARD_AUTO_INVOKE: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS =
    CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(4i32);
pub const CPCFO_NUMBERS_ONLY: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS =
    CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(8i32);
pub const CPCFO_SHOW_ENGLISH_KEYBOARD: CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS =
    CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS(16i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_CREDENTIAL_FIELD_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    pub ulAuthenticationPackage: u32,
    pub clsidCredentialProvider: ::windows::runtime::GUID,
    pub cbSerialization: u32,
    pub rgbSerialization: *mut u8,
}
impl CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {}
impl ::std::default::Default for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION")
            .field("ulAuthenticationPackage", &self.ulAuthenticationPackage)
            .field("clsidCredentialProvider", &self.clsidCredentialProvider)
            .field("cbSerialization", &self.cbSerialization)
            .field("rgbSerialization", &self.rgbSerialization)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    fn eq(&self, other: &Self) -> bool {
        self.ulAuthenticationPackage == other.ulAuthenticationPackage
            && self.clsidCredentialProvider == other.clsidCredentialProvider
            && self.cbSerialization == other.cbSerialization
            && self.rgbSerialization == other.rgbSerialization
    }
}
impl ::std::cmp::Eq for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    pub dwFieldID: u32,
    pub cpft: CREDENTIAL_PROVIDER_FIELD_TYPE,
    pub pszLabel: super::super::Foundation::PWSTR,
    pub guidFieldType: ::windows::runtime::GUID,
}
#[cfg(feature = "Win32_Foundation")]
impl CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR")
            .field("dwFieldID", &self.dwFieldID)
            .field("cpft", &self.cpft)
            .field("pszLabel", &self.pszLabel)
            .field("guidFieldType", &self.guidFieldType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    fn eq(&self, other: &Self) -> bool {
        self.dwFieldID == other.dwFieldID
            && self.cpft == other.cpft
            && self.pszLabel == other.pszLabel
            && self.guidFieldType == other.guidFieldType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_FIELD_DESCRIPTOR {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(pub i32);
pub const CPFIS_NONE: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE =
    CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(0i32);
pub const CPFIS_READONLY: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE =
    CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(1i32);
pub const CPFIS_DISABLED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE =
    CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(2i32);
pub const CPFIS_FOCUSED: CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE =
    CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE(3i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_FIELD_STATE(pub i32);
pub const CPFS_HIDDEN: CREDENTIAL_PROVIDER_FIELD_STATE = CREDENTIAL_PROVIDER_FIELD_STATE(0i32);
pub const CPFS_DISPLAY_IN_SELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE =
    CREDENTIAL_PROVIDER_FIELD_STATE(1i32);
pub const CPFS_DISPLAY_IN_DESELECTED_TILE: CREDENTIAL_PROVIDER_FIELD_STATE =
    CREDENTIAL_PROVIDER_FIELD_STATE(2i32);
pub const CPFS_DISPLAY_IN_BOTH: CREDENTIAL_PROVIDER_FIELD_STATE =
    CREDENTIAL_PROVIDER_FIELD_STATE(3i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_FIELD_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_FIELD_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_FIELD_TYPE(pub i32);
pub const CPFT_INVALID: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(0i32);
pub const CPFT_LARGE_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(1i32);
pub const CPFT_SMALL_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(2i32);
pub const CPFT_COMMAND_LINK: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(3i32);
pub const CPFT_EDIT_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(4i32);
pub const CPFT_PASSWORD_TEXT: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(5i32);
pub const CPFT_TILE_IMAGE: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(6i32);
pub const CPFT_CHECKBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(7i32);
pub const CPFT_COMBOBOX: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(8i32);
pub const CPFT_SUBMIT_BUTTON: CREDENTIAL_PROVIDER_FIELD_TYPE = CREDENTIAL_PROVIDER_FIELD_TYPE(9i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_FIELD_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_FIELD_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(pub i32);
pub const CPGSR_NO_CREDENTIAL_NOT_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE =
    CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(0i32);
pub const CPGSR_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE =
    CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(1i32);
pub const CPGSR_RETURN_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE =
    CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(2i32);
pub const CPGSR_RETURN_NO_CREDENTIAL_FINISHED: CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE =
    CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE(3i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CREDENTIAL_PROVIDER_NO_DEFAULT: u32 = 4294967295u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_STATUS_ICON(pub i32);
pub const CPSI_NONE: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(0i32);
pub const CPSI_ERROR: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(1i32);
pub const CPSI_WARNING: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(2i32);
pub const CPSI_SUCCESS: CREDENTIAL_PROVIDER_STATUS_ICON = CREDENTIAL_PROVIDER_STATUS_ICON(3i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_STATUS_ICON {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_STATUS_ICON {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CREDENTIAL_PROVIDER_USAGE_SCENARIO(pub i32);
pub const CPUS_INVALID: CREDENTIAL_PROVIDER_USAGE_SCENARIO =
    CREDENTIAL_PROVIDER_USAGE_SCENARIO(0i32);
pub const CPUS_LOGON: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(1i32);
pub const CPUS_UNLOCK_WORKSTATION: CREDENTIAL_PROVIDER_USAGE_SCENARIO =
    CREDENTIAL_PROVIDER_USAGE_SCENARIO(2i32);
pub const CPUS_CHANGE_PASSWORD: CREDENTIAL_PROVIDER_USAGE_SCENARIO =
    CREDENTIAL_PROVIDER_USAGE_SCENARIO(3i32);
pub const CPUS_CREDUI: CREDENTIAL_PROVIDER_USAGE_SCENARIO =
    CREDENTIAL_PROVIDER_USAGE_SCENARIO(4i32);
pub const CPUS_PLAP: CREDENTIAL_PROVIDER_USAGE_SCENARIO = CREDENTIAL_PROVIDER_USAGE_SCENARIO(5i32);
impl ::std::convert::From<i32> for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CREDENTIAL_PROVIDER_USAGE_SCENARIO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CSFV {
    pub cbSize: u32,
    pub pshf: ::std::option::Option<IShellFolder>,
    pub psvOuter: ::std::option::Option<IShellView>,
    pub pidl: *mut ITEMIDLIST,
    pub lEvents: i32,
    pub pfnCallback: ::std::option::Option<LPFNVIEWCALLBACK>,
    pub fvm: FOLDERVIEWMODE,
}
#[cfg(feature = "Win32_Foundation")]
impl CSFV {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CSFV {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CSFV {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CSFV")
            .field("cbSize", &self.cbSize)
            .field("pshf", &self.pshf)
            .field("psvOuter", &self.psvOuter)
            .field("pidl", &self.pidl)
            .field("lEvents", &self.lEvents)
            .field("fvm", &self.fvm)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CSFV {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.pshf == other.pshf
            && self.psvOuter == other.psvOuter
            && self.pidl == other.pidl
            && self.lEvents == other.lEvents
            && self.pfnCallback.map(|f| f as usize) == other.pfnCallback.map(|f| f as usize)
            && self.fvm == other.fvm
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CSFV {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CSFV {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
pub const CSIDL_ADMINTOOLS: u32 = 48u32;
pub const CSIDL_ALTSTARTUP: u32 = 29u32;
pub const CSIDL_APPDATA: u32 = 26u32;
pub const CSIDL_BITBUCKET: u32 = 10u32;
pub const CSIDL_CDBURN_AREA: u32 = 59u32;
pub const CSIDL_COMMON_ADMINTOOLS: u32 = 47u32;
pub const CSIDL_COMMON_ALTSTARTUP: u32 = 30u32;
pub const CSIDL_COMMON_APPDATA: u32 = 35u32;
pub const CSIDL_COMMON_DESKTOPDIRECTORY: u32 = 25u32;
pub const CSIDL_COMMON_DOCUMENTS: u32 = 46u32;
pub const CSIDL_COMMON_FAVORITES: u32 = 31u32;
pub const CSIDL_COMMON_MUSIC: u32 = 53u32;
pub const CSIDL_COMMON_OEM_LINKS: u32 = 58u32;
pub const CSIDL_COMMON_PICTURES: u32 = 54u32;
pub const CSIDL_COMMON_PROGRAMS: u32 = 23u32;
pub const CSIDL_COMMON_STARTMENU: u32 = 22u32;
pub const CSIDL_COMMON_STARTUP: u32 = 24u32;
pub const CSIDL_COMMON_TEMPLATES: u32 = 45u32;
pub const CSIDL_COMMON_VIDEO: u32 = 55u32;
pub const CSIDL_COMPUTERSNEARME: u32 = 61u32;
pub const CSIDL_CONNECTIONS: u32 = 49u32;
pub const CSIDL_CONTROLS: u32 = 3u32;
pub const CSIDL_COOKIES: u32 = 33u32;
pub const CSIDL_DESKTOP: u32 = 0u32;
pub const CSIDL_DESKTOPDIRECTORY: u32 = 16u32;
pub const CSIDL_DRIVES: u32 = 17u32;
pub const CSIDL_FAVORITES: u32 = 6u32;
pub const CSIDL_FLAG_CREATE: u32 = 32768u32;
pub const CSIDL_FLAG_DONT_UNEXPAND: u32 = 8192u32;
pub const CSIDL_FLAG_DONT_VERIFY: u32 = 16384u32;
pub const CSIDL_FLAG_MASK: u32 = 65280u32;
pub const CSIDL_FLAG_NO_ALIAS: u32 = 4096u32;
pub const CSIDL_FLAG_PER_USER_INIT: u32 = 2048u32;
pub const CSIDL_FLAG_PFTI_TRACKTARGET: u32 = 16384u32;
pub const CSIDL_FONTS: u32 = 20u32;
pub const CSIDL_HISTORY: u32 = 34u32;
pub const CSIDL_INTERNET: u32 = 1u32;
pub const CSIDL_INTERNET_CACHE: u32 = 32u32;
pub const CSIDL_LOCAL_APPDATA: u32 = 28u32;
pub const CSIDL_MYDOCUMENTS: u32 = 5u32;
pub const CSIDL_MYMUSIC: u32 = 13u32;
pub const CSIDL_MYPICTURES: u32 = 39u32;
pub const CSIDL_MYVIDEO: u32 = 14u32;
pub const CSIDL_NETHOOD: u32 = 19u32;
pub const CSIDL_NETWORK: u32 = 18u32;
pub const CSIDL_PERSONAL: u32 = 5u32;
pub const CSIDL_PRINTERS: u32 = 4u32;
pub const CSIDL_PRINTHOOD: u32 = 27u32;
pub const CSIDL_PROFILE: u32 = 40u32;
pub const CSIDL_PROGRAMS: u32 = 2u32;
pub const CSIDL_PROGRAM_FILES: u32 = 38u32;
pub const CSIDL_PROGRAM_FILESX86: u32 = 42u32;
pub const CSIDL_PROGRAM_FILES_COMMON: u32 = 43u32;
pub const CSIDL_PROGRAM_FILES_COMMONX86: u32 = 44u32;
pub const CSIDL_RECENT: u32 = 8u32;
pub const CSIDL_RESOURCES: u32 = 56u32;
pub const CSIDL_RESOURCES_LOCALIZED: u32 = 57u32;
pub const CSIDL_SENDTO: u32 = 9u32;
pub const CSIDL_STARTMENU: u32 = 11u32;
pub const CSIDL_STARTUP: u32 = 7u32;
pub const CSIDL_SYSTEM: u32 = 37u32;
pub const CSIDL_SYSTEMX86: u32 = 41u32;
pub const CSIDL_TEMPLATES: u32 = 21u32;
pub const CSIDL_WINDOWS: u32 = 36u32;
pub const CTF_COINIT: i32 = 8i32;
pub const CTF_COINIT_MTA: i32 = 4096i32;
pub const CTF_COINIT_STA: i32 = 8i32;
pub const CTF_FREELIBANDEXIT: i32 = 16i32;
pub const CTF_INHERITWOW64: i32 = 256i32;
pub const CTF_INSIST: i32 = 1i32;
pub const CTF_KEYBOARD_LOCALE: i32 = 1024i32;
pub const CTF_NOADDREFLIB: i32 = 8192i32;
pub const CTF_OLEINITIALIZE: i32 = 2048i32;
pub const CTF_PROCESS_REF: i32 = 4i32;
pub const CTF_REF_COUNTED: i32 = 32i32;
pub const CTF_THREAD_REF: i32 = 2i32;
pub const CTF_UNUSED: i32 = 128i32;
pub const CTF_WAIT_ALLOWCOM: i32 = 64i32;
pub const CTF_WAIT_NO_REENTRANCY: i32 = 512i32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn ChrCmpIA(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(ChrCmpIA(
            ::std::mem::transmute(w1),
            ::std::mem::transmute(w2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn ChrCmpIW(w1: u16, w2: u16) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(ChrCmpIW(
            ::std::mem::transmute(w1),
            ::std::mem::transmute(w2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ColorAdjustLuma<
    'a,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
>(
    clrrgb: u32,
    n: i32,
    fscale: Param2,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn ColorAdjustLuma(clrrgb: u32, n: i32, fscale: super::super::Foundation::BOOL) -> u32;
        }
        ::std::mem::transmute(ColorAdjustLuma(
            ::std::mem::transmute(clrrgb),
            ::std::mem::transmute(n),
            fscale.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn ColorHLSToRGB(whue: u16, wluminance: u16, wsaturation: u16) -> u32;
        }
        ::std::mem::transmute(ColorHLSToRGB(
            ::std::mem::transmute(whue),
            ::std::mem::transmute(wluminance),
            ::std::mem::transmute(wsaturation),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ColorRGBToHLS(
    clrrgb: u32,
    pwhue: *mut u16,
    pwluminance: *mut u16,
    pwsaturation: *mut u16,
) {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn ColorRGBToHLS(
                clrrgb: u32,
                pwhue: *mut u16,
                pwluminance: *mut u16,
                pwsaturation: *mut u16,
            );
        }
        ::std::mem::transmute(ColorRGBToHLS(
            ::std::mem::transmute(clrrgb),
            ::std::mem::transmute(pwhue),
            ::std::mem::transmute(pwluminance),
            ::std::mem::transmute(pwsaturation),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CommandLineToArgvW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    lpcmdline: Param0,
    pnumargs: *mut i32,
) -> *mut super::super::Foundation::PWSTR {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn CommandLineToArgvW(
                lpcmdline: super::super::Foundation::PWSTR,
                pnumargs: *mut i32,
            ) -> *mut super::super::Foundation::PWSTR;
        }
        ::std::mem::transmute(CommandLineToArgvW(
            lpcmdline.into_param().abi(),
            ::std::mem::transmute(pnumargs),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const ConflictFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    681146540,
    41217,
    17217,
    [168, 23, 33, 235, 167, 253, 4, 109],
);
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn ConnectToConnectionPoint<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    Param3: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
>(
    punk: Param0,
    riidevent: *const ::windows::runtime::GUID,
    fconnect: Param2,
    punktarget: Param3,
    pdwcookie: *mut u32,
    ppcpout: *mut ::std::option::Option<super::super::System::Com::IConnectionPoint>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn ConnectToConnectionPoint(
                punk: ::windows::runtime::RawPtr,
                riidevent: *const ::windows::runtime::GUID,
                fconnect: super::super::Foundation::BOOL,
                punktarget: ::windows::runtime::RawPtr,
                pdwcookie: *mut u32,
                ppcpout: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        ConnectToConnectionPoint(
            punk.into_param().abi(),
            ::std::mem::transmute(riidevent),
            fconnect.into_param().abi(),
            punktarget.into_param().abi(),
            ::std::mem::transmute(pdwcookie),
            ::std::mem::transmute(ppcpout),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CreateProfile<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszusersid: Param0,
    pszusername: Param1,
    pszprofilepath: super::super::Foundation::PWSTR,
    cchprofilepath: u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn CreateProfile(
                pszusersid: super::super::Foundation::PWSTR,
                pszusername: super::super::Foundation::PWSTR,
                pszprofilepath: super::super::Foundation::PWSTR,
                cchprofilepath: u32,
            ) -> ::windows::runtime::HRESULT;
        }
        CreateProfile(
            pszusersid.into_param().abi(),
            pszusername.into_param().abi(),
            ::std::mem::transmute(pszprofilepath),
            ::std::mem::transmute(cchprofilepath),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DAD_AutoScroll<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hwnd: Param0,
    pad: *mut AUTO_SCROLL_DATA,
    pptnow: *const super::super::Foundation::POINT,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DAD_AutoScroll(
                hwnd: super::super::Foundation::HWND,
                pad: *mut AUTO_SCROLL_DATA,
                pptnow: *const super::super::Foundation::POINT,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DAD_AutoScroll(
            hwnd.into_param().abi(),
            ::std::mem::transmute(pad),
            ::std::mem::transmute(pptnow),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DAD_DragEnterEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
>(
    hwndtarget: Param0,
    ptstart: Param1,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DAD_DragEnterEx(
                hwndtarget: super::super::Foundation::HWND,
                ptstart: super::super::Foundation::POINT,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DAD_DragEnterEx(
            hwndtarget.into_param().abi(),
            ptstart.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn DAD_DragEnterEx2<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::System::Com::IDataObject>,
>(
    hwndtarget: Param0,
    ptstart: Param1,
    pdtobject: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DAD_DragEnterEx2(
                hwndtarget: super::super::Foundation::HWND,
                ptstart: super::super::Foundation::POINT,
                pdtobject: ::windows::runtime::RawPtr,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DAD_DragEnterEx2(
            hwndtarget.into_param().abi(),
            ptstart.into_param().abi(),
            pdtobject.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DAD_DragLeave() -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DAD_DragLeave() -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DAD_DragLeave())
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DAD_DragMove<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
>(
    pt: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DAD_DragMove(pt: super::super::Foundation::POINT) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DAD_DragMove(pt.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
pub unsafe fn DAD_SetDragImage<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::Controls::HIMAGELIST>,
>(
    him: Param0,
    pptoffset: *mut super::super::Foundation::POINT,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DAD_SetDragImage(
                him: super::Controls::HIMAGELIST,
                pptoffset: *mut super::super::Foundation::POINT,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DAD_SetDragImage(
            him.into_param().abi(),
            ::std::mem::transmute(pptoffset),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DAD_ShowDragImage<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
>(
    fshow: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DAD_ShowDragImage(
                fshow: super::super::Foundation::BOOL,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DAD_ShowDragImage(fshow.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct DATABLOCK_HEADER {
    pub cbSize: u32,
    pub dwSignature: u32,
}
impl DATABLOCK_HEADER {}
impl ::std::default::Default for DATABLOCK_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DATABLOCK_HEADER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DATABLOCK_HEADER {}
unsafe impl ::windows::runtime::Abi for DATABLOCK_HEADER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DATAOBJ_GET_ITEM_FLAGS(pub i32);
pub const DOGIF_DEFAULT: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(0i32);
pub const DOGIF_TRAVERSE_LINK: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(1i32);
pub const DOGIF_NO_HDROP: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(2i32);
pub const DOGIF_NO_URL: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(4i32);
pub const DOGIF_ONLY_IF_ONE: DATAOBJ_GET_ITEM_FLAGS = DATAOBJ_GET_ITEM_FLAGS(8i32);
impl ::std::convert::From<i32> for DATAOBJ_GET_ITEM_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DATAOBJ_GET_ITEM_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DBCID_CLSIDOFBAR: i32 = 2i32;
pub const DBCID_EMPTY: i32 = 0i32;
pub const DBCID_GETBAR: i32 = 4i32;
pub const DBCID_ONDRAG: i32 = 1i32;
pub const DBCID_RESIZE: i32 = 3i32;
pub const DBCID_UPDATESIZE: i32 = 5i32;
pub const DBC_GS_IDEAL: u32 = 0u32;
pub const DBC_GS_SIZEDOWN: u32 = 1u32;
pub const DBC_HIDE: u32 = 0u32;
pub const DBC_SHOW: u32 = 1u32;
pub const DBC_SHOWOBSCURE: u32 = 2u32;
pub const DBIF_VIEWMODE_FLOATING: u32 = 2u32;
pub const DBIF_VIEWMODE_NORMAL: u32 = 0u32;
pub const DBIF_VIEWMODE_TRANSPARENT: u32 = 4u32;
pub const DBIF_VIEWMODE_VERTICAL: u32 = 1u32;
pub const DBIMF_ADDTOFRONT: u32 = 512u32;
pub const DBIMF_ALWAYSGRIPPER: u32 = 4096u32;
pub const DBIMF_BKCOLOR: u32 = 64u32;
pub const DBIMF_BREAK: u32 = 256u32;
pub const DBIMF_DEBOSSED: u32 = 32u32;
pub const DBIMF_FIXED: u32 = 1u32;
pub const DBIMF_FIXEDBMP: u32 = 4u32;
pub const DBIMF_NOGRIPPER: u32 = 2048u32;
pub const DBIMF_NOMARGINS: u32 = 8192u32;
pub const DBIMF_NORMAL: u32 = 0u32;
pub const DBIMF_TOPALIGN: u32 = 1024u32;
pub const DBIMF_UNDELETEABLE: u32 = 16u32;
pub const DBIMF_USECHEVRON: u32 = 128u32;
pub const DBIMF_VARIABLEHEIGHT: u32 = 8u32;
pub const DBIM_ACTUAL: u32 = 8u32;
pub const DBIM_BKCOLOR: u32 = 64u32;
pub const DBIM_INTEGRAL: u32 = 4u32;
pub const DBIM_MAXSIZE: u32 = 2u32;
pub const DBIM_MINSIZE: u32 = 1u32;
pub const DBIM_MODEFLAGS: u32 = 32u32;
pub const DBIM_TITLE: u32 = 16u32;
pub const DBPC_SELECTFIRST: u32 = 4294967295u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DEFAULTSAVEFOLDERTYPE(pub i32);
pub const DSFT_DETECT: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(1i32);
pub const DSFT_PRIVATE: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(2i32);
pub const DSFT_PUBLIC: DEFAULTSAVEFOLDERTYPE = DEFAULTSAVEFOLDERTYPE(3i32);
impl ::std::convert::From<i32> for DEFAULTSAVEFOLDERTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEFAULTSAVEFOLDERTYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DEFAULT_FOLDER_MENU_RESTRICTIONS(pub i32);
pub const DFMR_DEFAULT: DEFAULT_FOLDER_MENU_RESTRICTIONS = DEFAULT_FOLDER_MENU_RESTRICTIONS(0i32);
pub const DFMR_NO_STATIC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(8i32);
pub const DFMR_STATIC_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(16i32);
pub const DFMR_NO_RESOURCE_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(32i32);
pub const DFMR_OPTIN_HANDLERS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(64i32);
pub const DFMR_RESOURCE_AND_FOLDER_VERBS_ONLY: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(128i32);
pub const DFMR_USE_SPECIFIED_HANDLERS: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(256i32);
pub const DFMR_USE_SPECIFIED_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(512i32);
pub const DFMR_NO_ASYNC_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(1024i32);
pub const DFMR_NO_NATIVECPU_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(2048i32);
pub const DFMR_NO_NONWOW_VERBS: DEFAULT_FOLDER_MENU_RESTRICTIONS =
    DEFAULT_FOLDER_MENU_RESTRICTIONS(4096i32);
impl ::std::convert::From<i32> for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEFAULT_FOLDER_MENU_RESTRICTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
pub struct DEFCONTEXTMENU {
    pub hwnd: super::super::Foundation::HWND,
    pub pcmcb: ::std::option::Option<IContextMenuCB>,
    pub pidlFolder: *mut ITEMIDLIST,
    pub psf: ::std::option::Option<IShellFolder>,
    pub cidl: u32,
    pub apidl: *mut *mut ITEMIDLIST,
    pub punkAssociationInfo: ::std::option::Option<::windows::runtime::IUnknown>,
    pub cKeys: u32,
    pub aKeys: *mut super::super::System::Registry::HKEY,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl DEFCONTEXTMENU {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::default::Default for DEFCONTEXTMENU {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::fmt::Debug for DEFCONTEXTMENU {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEFCONTEXTMENU")
            .field("hwnd", &self.hwnd)
            .field("pcmcb", &self.pcmcb)
            .field("pidlFolder", &self.pidlFolder)
            .field("psf", &self.psf)
            .field("cidl", &self.cidl)
            .field("apidl", &self.apidl)
            .field("punkAssociationInfo", &self.punkAssociationInfo)
            .field("cKeys", &self.cKeys)
            .field("aKeys", &self.aKeys)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::PartialEq for DEFCONTEXTMENU {
    fn eq(&self, other: &Self) -> bool {
        self.hwnd == other.hwnd
            && self.pcmcb == other.pcmcb
            && self.pidlFolder == other.pidlFolder
            && self.psf == other.psf
            && self.cidl == other.cidl
            && self.apidl == other.apidl
            && self.punkAssociationInfo == other.punkAssociationInfo
            && self.cKeys == other.cKeys
            && self.aKeys == other.aKeys
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
impl ::std::cmp::Eq for DEFCONTEXTMENU {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Registry"))]
unsafe impl ::windows::runtime::Abi for DEFCONTEXTMENU {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DEF_SHARE_ID(pub i32);
pub const DEFSHAREID_USERS: DEF_SHARE_ID = DEF_SHARE_ID(1i32);
pub const DEFSHAREID_PUBLIC: DEF_SHARE_ID = DEF_SHARE_ID(2i32);
impl ::std::convert::From<i32> for DEF_SHARE_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEF_SHARE_ID {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct DELEGATEITEMID {
    pub cbSize: u16,
    pub wOuter: u16,
    pub cbInner: u16,
    pub rgb: [u8; 1],
}
impl DELEGATEITEMID {}
impl ::std::default::Default for DELEGATEITEMID {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DELEGATEITEMID {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DELEGATEITEMID {}
unsafe impl ::windows::runtime::Abi for DELEGATEITEMID {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DESKBANDCID(pub i32);
pub const DBID_BANDINFOCHANGED: DESKBANDCID = DESKBANDCID(0i32);
pub const DBID_SHOWONLY: DESKBANDCID = DESKBANDCID(1i32);
pub const DBID_MAXIMIZEBAND: DESKBANDCID = DESKBANDCID(2i32);
pub const DBID_PUSHCHEVRON: DESKBANDCID = DESKBANDCID(3i32);
pub const DBID_DELAYINIT: DESKBANDCID = DESKBANDCID(4i32);
pub const DBID_FINISHINIT: DESKBANDCID = DESKBANDCID(5i32);
pub const DBID_SETWINDOWTHEME: DESKBANDCID = DESKBANDCID(6i32);
pub const DBID_PERMITAUTOHIDE: DESKBANDCID = DESKBANDCID(7i32);
impl ::std::convert::From<i32> for DESKBANDCID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DESKBANDCID {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DESKBANDINFO {
    pub dwMask: u32,
    pub ptMinSize: super::super::Foundation::POINTL,
    pub ptMaxSize: super::super::Foundation::POINTL,
    pub ptIntegral: super::super::Foundation::POINTL,
    pub ptActual: super::super::Foundation::POINTL,
    pub wszTitle: [u16; 256],
    pub dwModeFlags: u32,
    pub crBkgnd: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DESKBANDINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DESKBANDINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DESKBANDINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DESKBANDINFO")
            .field("dwMask", &self.dwMask)
            .field("ptMinSize", &self.ptMinSize)
            .field("ptMaxSize", &self.ptMaxSize)
            .field("ptIntegral", &self.ptIntegral)
            .field("ptActual", &self.ptActual)
            .field("wszTitle", &self.wszTitle)
            .field("dwModeFlags", &self.dwModeFlags)
            .field("crBkgnd", &self.crBkgnd)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DESKBANDINFO {
    fn eq(&self, other: &Self) -> bool {
        self.dwMask == other.dwMask
            && self.ptMinSize == other.ptMinSize
            && self.ptMaxSize == other.ptMaxSize
            && self.ptIntegral == other.ptIntegral
            && self.ptActual == other.ptActual
            && self.wszTitle == other.wszTitle
            && self.dwModeFlags == other.dwModeFlags
            && self.crBkgnd == other.crBkgnd
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DESKBANDINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DESKBANDINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DESKTOP_SLIDESHOW_DIRECTION(pub i32);
pub const DSD_FORWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(0i32);
pub const DSD_BACKWARD: DESKTOP_SLIDESHOW_DIRECTION = DESKTOP_SLIDESHOW_DIRECTION(1i32);
impl ::std::convert::From<i32> for DESKTOP_SLIDESHOW_DIRECTION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DESKTOP_SLIDESHOW_DIRECTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DESKTOP_SLIDESHOW_OPTIONS(pub i32);
pub const DSO_SHUFFLEIMAGES: DESKTOP_SLIDESHOW_OPTIONS = DESKTOP_SLIDESHOW_OPTIONS(1i32);
impl ::std::convert::From<i32> for DESKTOP_SLIDESHOW_OPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DESKTOP_SLIDESHOW_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DESKTOP_SLIDESHOW_STATE(pub i32);
pub const DSS_ENABLED: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(1i32);
pub const DSS_SLIDESHOW: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(2i32);
pub const DSS_DISABLED_BY_REMOTE_SESSION: DESKTOP_SLIDESHOW_STATE = DESKTOP_SLIDESHOW_STATE(4i32);
impl ::std::convert::From<i32> for DESKTOP_SLIDESHOW_STATE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DESKTOP_SLIDESHOW_STATE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DESKTOP_WALLPAPER_POSITION(pub i32);
pub const DWPOS_CENTER: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(0i32);
pub const DWPOS_TILE: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(1i32);
pub const DWPOS_STRETCH: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(2i32);
pub const DWPOS_FIT: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(3i32);
pub const DWPOS_FILL: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(4i32);
pub const DWPOS_SPAN: DESKTOP_WALLPAPER_POSITION = DESKTOP_WALLPAPER_POSITION(5i32);
impl ::std::convert::From<i32> for DESKTOP_WALLPAPER_POSITION {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DESKTOP_WALLPAPER_POSITION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DETAILSINFO {
    pub pidl: *mut ITEMIDLIST,
    pub fmt: i32,
    pub cxChar: i32,
    pub str: STRRET,
    pub iImage: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl DETAILSINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DETAILSINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DETAILSINFO {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DETAILSINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DETAILSINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DEVICE_SCALE_FACTOR(pub i32);
pub const DEVICE_SCALE_FACTOR_INVALID: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(0i32);
pub const SCALE_100_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(100i32);
pub const SCALE_120_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(120i32);
pub const SCALE_125_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(125i32);
pub const SCALE_140_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(140i32);
pub const SCALE_150_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(150i32);
pub const SCALE_160_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(160i32);
pub const SCALE_175_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(175i32);
pub const SCALE_180_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(180i32);
pub const SCALE_200_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(200i32);
pub const SCALE_225_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(225i32);
pub const SCALE_250_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(250i32);
pub const SCALE_300_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(300i32);
pub const SCALE_350_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(350i32);
pub const SCALE_400_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(400i32);
pub const SCALE_450_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(450i32);
pub const SCALE_500_PERCENT: DEVICE_SCALE_FACTOR = DEVICE_SCALE_FACTOR(500i32);
impl ::std::convert::From<i32> for DEVICE_SCALE_FACTOR {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DEVICE_SCALE_FACTOR {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct DFConstraint(::windows::runtime::IUnknown);
impl DFConstraint {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Value(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for DFConstraint {
    type Vtable = DFConstraint_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1245573200,
        9149,
        4562,
        [147, 159, 0, 160, 201, 30, 237, 186],
    );
}
impl ::std::convert::From<DFConstraint> for ::windows::runtime::IUnknown {
    fn from(value: DFConstraint) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&DFConstraint> for ::windows::runtime::IUnknown {
    fn from(value: &DFConstraint) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for DFConstraint {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &DFConstraint {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<DFConstraint> for super::super::System::OleAutomation::IDispatch {
    fn from(value: DFConstraint) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&DFConstraint> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &DFConstraint) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for DFConstraint
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &DFConstraint
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct DFConstraint_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pv: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DFMICS {
    pub cbSize: u32,
    pub fMask: u32,
    pub lParam: super::super::Foundation::LPARAM,
    pub idCmdFirst: u32,
    pub idDefMax: u32,
    pub pici: *mut CMINVOKECOMMANDINFO,
    pub punkSite: ::std::option::Option<::windows::runtime::IUnknown>,
}
#[cfg(feature = "Win32_Foundation")]
impl DFMICS {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DFMICS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DFMICS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DFMICS")
            .field("cbSize", &self.cbSize)
            .field("fMask", &self.fMask)
            .field("lParam", &self.lParam)
            .field("idCmdFirst", &self.idCmdFirst)
            .field("idDefMax", &self.idDefMax)
            .field("pici", &self.pici)
            .field("punkSite", &self.punkSite)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DFMICS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.fMask == other.fMask
            && self.lParam == other.lParam
            && self.idCmdFirst == other.idCmdFirst
            && self.idDefMax == other.idDefMax
            && self.pici == other.pici
            && self.punkSite == other.punkSite
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DFMICS {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DFMICS {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DFM_CMD(pub i32);
pub const DFM_CMD_DELETE: DFM_CMD = DFM_CMD(-1i32);
pub const DFM_CMD_MOVE: DFM_CMD = DFM_CMD(-2i32);
pub const DFM_CMD_COPY: DFM_CMD = DFM_CMD(-3i32);
pub const DFM_CMD_LINK: DFM_CMD = DFM_CMD(-4i32);
pub const DFM_CMD_PROPERTIES: DFM_CMD = DFM_CMD(-5i32);
pub const DFM_CMD_NEWFOLDER: DFM_CMD = DFM_CMD(-6i32);
pub const DFM_CMD_PASTE: DFM_CMD = DFM_CMD(-7i32);
pub const DFM_CMD_VIEWLIST: DFM_CMD = DFM_CMD(-8i32);
pub const DFM_CMD_VIEWDETAILS: DFM_CMD = DFM_CMD(-9i32);
pub const DFM_CMD_PASTELINK: DFM_CMD = DFM_CMD(-10i32);
pub const DFM_CMD_PASTESPECIAL: DFM_CMD = DFM_CMD(-11i32);
pub const DFM_CMD_MODALPROP: DFM_CMD = DFM_CMD(-12i32);
pub const DFM_CMD_RENAME: DFM_CMD = DFM_CMD(-13i32);
impl ::std::convert::From<i32> for DFM_CMD {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DFM_CMD {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DFM_MESSAGE_ID(pub i32);
pub const DFM_MERGECONTEXTMENU: DFM_MESSAGE_ID = DFM_MESSAGE_ID(1i32);
pub const DFM_INVOKECOMMAND: DFM_MESSAGE_ID = DFM_MESSAGE_ID(2i32);
pub const DFM_GETHELPTEXT: DFM_MESSAGE_ID = DFM_MESSAGE_ID(5i32);
pub const DFM_WM_MEASUREITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(6i32);
pub const DFM_WM_DRAWITEM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(7i32);
pub const DFM_WM_INITMENUPOPUP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(8i32);
pub const DFM_VALIDATECMD: DFM_MESSAGE_ID = DFM_MESSAGE_ID(9i32);
pub const DFM_MERGECONTEXTMENU_TOP: DFM_MESSAGE_ID = DFM_MESSAGE_ID(10i32);
pub const DFM_GETHELPTEXTW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(11i32);
pub const DFM_INVOKECOMMANDEX: DFM_MESSAGE_ID = DFM_MESSAGE_ID(12i32);
pub const DFM_MAPCOMMANDNAME: DFM_MESSAGE_ID = DFM_MESSAGE_ID(13i32);
pub const DFM_GETDEFSTATICID: DFM_MESSAGE_ID = DFM_MESSAGE_ID(14i32);
pub const DFM_GETVERBW: DFM_MESSAGE_ID = DFM_MESSAGE_ID(15i32);
pub const DFM_GETVERBA: DFM_MESSAGE_ID = DFM_MESSAGE_ID(16i32);
pub const DFM_MERGECONTEXTMENU_BOTTOM: DFM_MESSAGE_ID = DFM_MESSAGE_ID(17i32);
pub const DFM_MODIFYQCMFLAGS: DFM_MESSAGE_ID = DFM_MESSAGE_ID(18i32);
impl ::std::convert::From<i32> for DFM_MESSAGE_ID {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DFM_MESSAGE_ID {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DISPID_BEGINDRAG: u32 = 204u32;
pub const DISPID_CHECKSTATECHANGED: u32 = 209u32;
pub const DISPID_COLUMNSCHANGED: u32 = 212u32;
pub const DISPID_CONTENTSCHANGED: u32 = 207u32;
pub const DISPID_CTRLMOUSEWHEEL: u32 = 213u32;
pub const DISPID_DEFAULTVERBINVOKED: u32 = 203u32;
pub const DISPID_ENTERPRESSED: u32 = 200u32;
pub const DISPID_ENTERPRISEIDCHANGED: u32 = 224u32;
pub const DISPID_EXPLORERWINDOWREADY: u32 = 221u32;
pub const DISPID_FILELISTENUMDONE: u32 = 201u32;
pub const DISPID_FILTERINVOKED: u32 = 218u32;
pub const DISPID_FOCUSCHANGED: u32 = 208u32;
pub const DISPID_FOLDERCHANGED: u32 = 217u32;
pub const DISPID_IADCCTL_DEFAULTCAT: u32 = 262u32;
pub const DISPID_IADCCTL_DIRTY: u32 = 256u32;
pub const DISPID_IADCCTL_FORCEX86: u32 = 259u32;
pub const DISPID_IADCCTL_ONDOMAIN: u32 = 261u32;
pub const DISPID_IADCCTL_PUBCAT: u32 = 257u32;
pub const DISPID_IADCCTL_SHOWPOSTSETUP: u32 = 260u32;
pub const DISPID_IADCCTL_SORT: u32 = 258u32;
pub const DISPID_ICONSIZECHANGED: u32 = 215u32;
pub const DISPID_INITIALENUMERATIONDONE: u32 = 223u32;
pub const DISPID_NOITEMSTATE_CHANGED: u32 = 206u32;
pub const DISPID_ORDERCHANGED: u32 = 210u32;
pub const DISPID_SEARCHCOMMAND_ABORT: u32 = 3u32;
pub const DISPID_SEARCHCOMMAND_COMPLETE: u32 = 2u32;
pub const DISPID_SEARCHCOMMAND_ERROR: u32 = 6u32;
pub const DISPID_SEARCHCOMMAND_PROGRESSTEXT: u32 = 5u32;
pub const DISPID_SEARCHCOMMAND_RESTORE: u32 = 7u32;
pub const DISPID_SEARCHCOMMAND_START: u32 = 1u32;
pub const DISPID_SEARCHCOMMAND_UPDATE: u32 = 4u32;
pub const DISPID_SELECTEDITEMCHANGED: u32 = 220u32;
pub const DISPID_SELECTIONCHANGED: u32 = 200u32;
pub const DISPID_SORTDONE: u32 = 214u32;
pub const DISPID_UPDATEIMAGE: u32 = 222u32;
pub const DISPID_VERBINVOKED: u32 = 202u32;
pub const DISPID_VIEWMODECHANGED: u32 = 205u32;
pub const DISPID_VIEWPAINTDONE: u32 = 211u32;
pub const DISPID_WORDWHEELEDITED: u32 = 219u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DISPLAY_DEVICE_TYPE(pub i32);
pub const DEVICE_PRIMARY: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(0i32);
pub const DEVICE_IMMERSIVE: DISPLAY_DEVICE_TYPE = DISPLAY_DEVICE_TYPE(1i32);
impl ::std::convert::From<i32> for DISPLAY_DEVICE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DISPLAY_DEVICE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DLG_SCRNSAVECONFIGURE: u32 = 2003u32;
pub type DLLGETVERSIONPROC =
    unsafe extern "system" fn(param0: *mut DLLVERSIONINFO) -> ::windows::runtime::HRESULT;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DLLVERSIONINFO {
    pub cbSize: u32,
    pub dwMajorVersion: u32,
    pub dwMinorVersion: u32,
    pub dwBuildNumber: u32,
    pub dwPlatformID: u32,
}
impl DLLVERSIONINFO {}
impl ::std::default::Default for DLLVERSIONINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DLLVERSIONINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DLLVERSIONINFO")
            .field("cbSize", &self.cbSize)
            .field("dwMajorVersion", &self.dwMajorVersion)
            .field("dwMinorVersion", &self.dwMinorVersion)
            .field("dwBuildNumber", &self.dwBuildNumber)
            .field("dwPlatformID", &self.dwPlatformID)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DLLVERSIONINFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwMajorVersion == other.dwMajorVersion
            && self.dwMinorVersion == other.dwMinorVersion
            && self.dwBuildNumber == other.dwBuildNumber
            && self.dwPlatformID == other.dwPlatformID
    }
}
impl ::std::cmp::Eq for DLLVERSIONINFO {}
unsafe impl ::windows::runtime::Abi for DLLVERSIONINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DLLVERSIONINFO2 {
    pub info1: DLLVERSIONINFO,
    pub dwFlags: u32,
    pub ullVersion: u64,
}
impl DLLVERSIONINFO2 {}
impl ::std::default::Default for DLLVERSIONINFO2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DLLVERSIONINFO2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DLLVERSIONINFO2")
            .field("info1", &self.info1)
            .field("dwFlags", &self.dwFlags)
            .field("ullVersion", &self.ullVersion)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DLLVERSIONINFO2 {
    fn eq(&self, other: &Self) -> bool {
        self.info1 == other.info1
            && self.dwFlags == other.dwFlags
            && self.ullVersion == other.ullVersion
    }
}
impl ::std::cmp::Eq for DLLVERSIONINFO2 {}
unsafe impl ::windows::runtime::Abi for DLLVERSIONINFO2 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DLLVER_BUILD_MASK: u64 = 4294901760u64;
pub const DLLVER_MAJOR_MASK: u64 = 18446462598732840960u64;
pub const DLLVER_MINOR_MASK: u64 = 281470681743360u64;
pub const DLLVER_PLATFORM_NT: u32 = 2u32;
pub const DLLVER_PLATFORM_WINDOWS: u32 = 1u32;
pub const DLLVER_QFE_MASK: u64 = 65535u64;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOA {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: super::super::Foundation::PSTR,
    pub grfKeyState: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DRAGINFOA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRAGINFOA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRAGINFOA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRAGINFOA")
            .field("uSize", &self.uSize)
            .field("pt", &self.pt)
            .field("fNC", &self.fNC)
            .field("lpFileList", &self.lpFileList)
            .field("grfKeyState", &self.grfKeyState)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRAGINFOA {
    fn eq(&self, other: &Self) -> bool {
        self.uSize == other.uSize
            && self.pt == other.pt
            && self.fNC == other.fNC
            && self.lpFileList == other.lpFileList
            && self.grfKeyState == other.grfKeyState
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRAGINFOA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRAGINFOA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRAGINFOW {
    pub uSize: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub lpFileList: super::super::Foundation::PWSTR,
    pub grfKeyState: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DRAGINFOW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRAGINFOW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRAGINFOW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRAGINFOW")
            .field("uSize", &self.uSize)
            .field("pt", &self.pt)
            .field("fNC", &self.fNC)
            .field("lpFileList", &self.lpFileList)
            .field("grfKeyState", &self.grfKeyState)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRAGINFOW {
    fn eq(&self, other: &Self) -> bool {
        self.uSize == other.uSize
            && self.pt == other.pt
            && self.fNC == other.fNC
            && self.lpFileList == other.lpFileList
            && self.grfKeyState == other.grfKeyState
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRAGINFOW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRAGINFOW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct DROPDESCRIPTION {
    pub r#type: DROPIMAGETYPE,
    pub szMessage: [u16; 260],
    pub szInsert: [u16; 260],
}
impl DROPDESCRIPTION {}
impl ::std::default::Default for DROPDESCRIPTION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for DROPDESCRIPTION {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for DROPDESCRIPTION {}
unsafe impl ::windows::runtime::Abi for DROPDESCRIPTION {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct DROPFILES {
    pub pFiles: u32,
    pub pt: super::super::Foundation::POINT,
    pub fNC: super::super::Foundation::BOOL,
    pub fWide: super::super::Foundation::BOOL,
}
#[cfg(feature = "Win32_Foundation")]
impl DROPFILES {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DROPFILES {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DROPFILES {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DROPFILES {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DROPFILES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DROPIMAGETYPE(pub i32);
pub const DROPIMAGE_INVALID: DROPIMAGETYPE = DROPIMAGETYPE(-1i32);
pub const DROPIMAGE_NONE: DROPIMAGETYPE = DROPIMAGETYPE(0i32);
pub const DROPIMAGE_COPY: DROPIMAGETYPE = DROPIMAGETYPE(1i32);
pub const DROPIMAGE_MOVE: DROPIMAGETYPE = DROPIMAGETYPE(2i32);
pub const DROPIMAGE_LINK: DROPIMAGETYPE = DROPIMAGETYPE(4i32);
pub const DROPIMAGE_LABEL: DROPIMAGETYPE = DROPIMAGETYPE(6i32);
pub const DROPIMAGE_WARNING: DROPIMAGETYPE = DROPIMAGETYPE(7i32);
pub const DROPIMAGE_NOIMAGE: DROPIMAGETYPE = DROPIMAGETYPE(8i32);
impl ::std::convert::From<i32> for DROPIMAGETYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DROPIMAGETYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DSH_FLAGS(pub i32);
pub const DSH_ALLOWDROPDESCRIPTIONTEXT: DSH_FLAGS = DSH_FLAGS(1i32);
impl ::std::convert::From<i32> for DSH_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DSH_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct DShellFolderViewEvents(::windows::runtime::IUnknown);
impl DShellFolderViewEvents {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for DShellFolderViewEvents {
    type Vtable = DShellFolderViewEvents_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1645292194,
        60388,
        4559,
        [165, 251, 0, 32, 175, 231, 41, 45],
    );
}
impl ::std::convert::From<DShellFolderViewEvents> for ::windows::runtime::IUnknown {
    fn from(value: DShellFolderViewEvents) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&DShellFolderViewEvents> for ::windows::runtime::IUnknown {
    fn from(value: &DShellFolderViewEvents) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for DShellFolderViewEvents
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &DShellFolderViewEvents
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<DShellFolderViewEvents>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: DShellFolderViewEvents) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&DShellFolderViewEvents>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &DShellFolderViewEvents) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for DShellFolderViewEvents
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &DShellFolderViewEvents
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct DShellFolderViewEvents_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
pub const DVASPECT_COPY: u32 = 3u32;
pub const DVASPECT_LINK: u32 = 4u32;
pub const DVASPECT_SHORTNAME: u32 = 2u32;
pub const DWFAF_AUTOHIDE: u32 = 16u32;
pub const DWFAF_GROUP1: u32 = 2u32;
pub const DWFAF_GROUP2: u32 = 4u32;
pub const DWFAF_HIDDEN: u32 = 1u32;
pub const DWFRF_DELETECONFIGDATA: u32 = 1u32;
pub const DWFRF_NORMAL: u32 = 0u32;
pub const DefFolderMenu: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3325264574,
    31027,
    18640,
    [154, 200, 133, 251, 70, 190, 47, 221],
);
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DefSubclassProc<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
>(
    hwnd: Param0,
    umsg: u32,
    wparam: Param2,
    lparam: Param3,
) -> super::super::Foundation::LRESULT {
    #[cfg(windows)]
    {
        #[link(name = "comctl32")]
        extern "system" {
            fn DefSubclassProc(
                hwnd: super::super::Foundation::HWND,
                umsg: u32,
                wparam: super::super::Foundation::WPARAM,
                lparam: super::super::Foundation::LPARAM,
            ) -> super::super::Foundation::LRESULT;
        }
        ::std::mem::transmute(DefSubclassProc(
            hwnd.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeleteProfileA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    lpsidstring: Param0,
    lpprofilepath: Param1,
    lpcomputername: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn DeleteProfileA(
                lpsidstring: super::super::Foundation::PSTR,
                lpprofilepath: super::super::Foundation::PSTR,
                lpcomputername: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeleteProfileA(
            lpsidstring.into_param().abi(),
            lpprofilepath.into_param().abi(),
            lpcomputername.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeleteProfileW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    lpsidstring: Param0,
    lpprofilepath: Param1,
    lpcomputername: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn DeleteProfileW(
                lpsidstring: super::super::Foundation::PWSTR,
                lpprofilepath: super::super::Foundation::PWSTR,
                lpcomputername: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeleteProfileW(
            lpsidstring.into_param().abi(),
            lpprofilepath.into_param().abi(),
            lpcomputername.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DesktopGadget: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2454506523,
    25954,
    19589,
    [134, 87, 209, 119, 146, 82, 34, 182],
);
pub const DesktopWallpaper: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3268358416,
    17934,
    20417,
    [185, 208, 138, 28, 12, 156, 196, 189],
);
pub const DestinationList: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2012286192,
    15797,
    18790,
    [181, 32, 183, 197, 79, 211, 94, 214],
);
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DoEnvironmentSubstA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pszsrc: Param0,
    cchsrc: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DoEnvironmentSubstA(pszsrc: super::super::Foundation::PSTR, cchsrc: u32) -> u32;
        }
        ::std::mem::transmute(DoEnvironmentSubstA(
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DoEnvironmentSubstW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszsrc: Param0,
    cchsrc: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DoEnvironmentSubstW(pszsrc: super::super::Foundation::PWSTR, cchsrc: u32) -> u32;
        }
        ::std::mem::transmute(DoEnvironmentSubstW(
            pszsrc.into_param().abi(),
            ::std::mem::transmute(cchsrc),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Web_MsHtml"))]
pub unsafe fn DoPrivacyDlg<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Web::MsHtml::IEnumPrivacyRecords>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
>(
    hwndowner: Param0,
    pszurl: Param1,
    pprivacyenum: Param2,
    freportallsites: Param3,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shdocvw")]
        extern "system" {
            fn DoPrivacyDlg(
                hwndowner: super::super::Foundation::HWND,
                pszurl: super::super::Foundation::PWSTR,
                pprivacyenum: ::windows::runtime::RawPtr,
                freportallsites: super::super::Foundation::BOOL,
            ) -> ::windows::runtime::HRESULT;
        }
        DoPrivacyDlg(
            hwndowner.into_param().abi(),
            pszurl.into_param().abi(),
            pprivacyenum.into_param().abi(),
            freportallsites.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DocPropShellExtension: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(2285073347, 49033, 4561, [190, 53, 8, 0, 54, 177, 26, 3]);
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DragAcceptFiles<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
>(
    hwnd: Param0,
    faccept: Param1,
) {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DragAcceptFiles(
                hwnd: super::super::Foundation::HWND,
                faccept: super::super::Foundation::BOOL,
            );
        }
        ::std::mem::transmute(DragAcceptFiles(
            hwnd.into_param().abi(),
            faccept.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn DragFinish<'a, Param0: ::windows::runtime::IntoParam<'a, HDROP>>(hdrop: Param0) {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DragFinish(hdrop: HDROP);
        }
        ::std::mem::transmute(DragFinish(hdrop.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DragQueryFileA<'a, Param0: ::windows::runtime::IntoParam<'a, HDROP>>(
    hdrop: Param0,
    ifile: u32,
    lpszfile: super::super::Foundation::PSTR,
    cch: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DragQueryFileA(
                hdrop: HDROP,
                ifile: u32,
                lpszfile: super::super::Foundation::PSTR,
                cch: u32,
            ) -> u32;
        }
        ::std::mem::transmute(DragQueryFileA(
            hdrop.into_param().abi(),
            ::std::mem::transmute(ifile),
            ::std::mem::transmute(lpszfile),
            ::std::mem::transmute(cch),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DragQueryFileW<'a, Param0: ::windows::runtime::IntoParam<'a, HDROP>>(
    hdrop: Param0,
    ifile: u32,
    lpszfile: super::super::Foundation::PWSTR,
    cch: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DragQueryFileW(
                hdrop: HDROP,
                ifile: u32,
                lpszfile: super::super::Foundation::PWSTR,
                cch: u32,
            ) -> u32;
        }
        ::std::mem::transmute(DragQueryFileW(
            hdrop.into_param().abi(),
            ::std::mem::transmute(ifile),
            ::std::mem::transmute(lpszfile),
            ::std::mem::transmute(cch),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DragQueryPoint<'a, Param0: ::windows::runtime::IntoParam<'a, HDROP>>(
    hdrop: Param0,
    ppt: *mut super::super::Foundation::POINT,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DragQueryPoint(
                hdrop: HDROP,
                ppt: *mut super::super::Foundation::POINT,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DragQueryPoint(
            hdrop.into_param().abi(),
            ::std::mem::transmute(ppt),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DriveSizeCategorizer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2486532947,
    51753,
    19320,
    [131, 174, 232, 254, 116, 9, 19, 79],
);
pub unsafe fn DriveType(idrive: i32) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DriveType(idrive: i32) -> i32;
        }
        ::std::mem::transmute(DriveType(::std::mem::transmute(idrive)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const DriveTypeCategorizer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2963862479,
    17203,
    19371,
    [136, 115, 28, 203, 28, 173, 164, 139],
);
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn DuplicateIcon<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
    Param1: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HICON>,
>(
    hinst: Param0,
    hicon: Param1,
) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn DuplicateIcon(
                hinst: super::super::Foundation::HINSTANCE,
                hicon: super::WindowsAndMessaging::HICON,
            ) -> super::WindowsAndMessaging::HICON;
        }
        ::std::mem::transmute(DuplicateIcon(
            hinst.into_param().abi(),
            hicon.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EC_HOST_UI_MODE(pub i32);
pub const ECHUIM_DESKTOP: EC_HOST_UI_MODE = EC_HOST_UI_MODE(0i32);
pub const ECHUIM_IMMERSIVE: EC_HOST_UI_MODE = EC_HOST_UI_MODE(1i32);
pub const ECHUIM_SYSTEM_LAUNCHER: EC_HOST_UI_MODE = EC_HOST_UI_MODE(2i32);
impl ::std::convert::From<i32> for EC_HOST_UI_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EC_HOST_UI_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EDGE_GESTURE_KIND(pub i32);
pub const EGK_TOUCH: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(0i32);
pub const EGK_KEYBOARD: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(1i32);
pub const EGK_MOUSE: EDGE_GESTURE_KIND = EDGE_GESTURE_KIND(2i32);
impl ::std::convert::From<i32> for EDGE_GESTURE_KIND {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EDGE_GESTURE_KIND {
    type Abi = Self;
    type DefaultType = Self;
}
pub const EP_AdvQueryPane: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3035224971,
    13498,
    19513,
    [181, 204, 22, 161, 189, 44, 65, 28],
);
pub const EP_Commands: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3648280680,
    51807,
    19062,
    [145, 205, 245, 161, 41, 251, 176, 118],
);
pub const EP_Commands_Organize: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1927812864,
    58348,
    18016,
    [191, 36, 60, 59, 123, 100, 136, 6],
);
pub const EP_Commands_View: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    569885485,
    61098,
    17307,
    [187, 81, 55, 185, 111, 214, 169, 67],
);
pub const EP_DetailsPane: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1135344011,
    35256,
    18221,
    [185, 206, 230, 155, 130, 41, 240, 25],
);
pub const EP_NavPane: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3409013538,
    9719,
    17080,
    [138, 9, 84, 13, 35, 164, 60, 47],
);
pub const EP_PreviewPane: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2302436305,
    17864,
    19735,
    [190, 25, 34, 59, 231, 27, 227, 101],
);
pub const EP_QueryPane: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1706876495,
    20231,
    20263,
    [131, 167, 26, 252, 164, 223, 125, 221],
);
pub const EP_Ribbon: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3530892456,
    51698,
    18484,
    [161, 6, 223, 136, 137, 253, 79, 55],
);
pub const EP_StatusBar: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1711167182,
    23806,
    19396,
    [173, 138, 122, 227, 254, 126, 143, 124],
);
pub const EXECUTE_E_LAUNCH_APPLICATION: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927487i32 as _);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EXPLORER_BROWSER_FILL_FLAGS(pub i32);
pub const EBF_NONE: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(0i32);
pub const EBF_SELECTFROMDATAOBJECT: EXPLORER_BROWSER_FILL_FLAGS =
    EXPLORER_BROWSER_FILL_FLAGS(256i32);
pub const EBF_NODROPTARGET: EXPLORER_BROWSER_FILL_FLAGS = EXPLORER_BROWSER_FILL_FLAGS(512i32);
impl ::std::convert::From<i32> for EXPLORER_BROWSER_FILL_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EXPLORER_BROWSER_FILL_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EXPLORER_BROWSER_OPTIONS(pub i32);
pub const EBO_NONE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(0i32);
pub const EBO_NAVIGATEONCE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(1i32);
pub const EBO_SHOWFRAMES: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(2i32);
pub const EBO_ALWAYSNAVIGATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(4i32);
pub const EBO_NOTRAVELLOG: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(8i32);
pub const EBO_NOWRAPPERWINDOW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(16i32);
pub const EBO_HTMLSHAREPOINTVIEW: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(32i32);
pub const EBO_NOBORDER: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(64i32);
pub const EBO_NOPERSISTVIEWSTATE: EXPLORER_BROWSER_OPTIONS = EXPLORER_BROWSER_OPTIONS(128i32);
impl ::std::convert::From<i32> for EXPLORER_BROWSER_OPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EXPLORER_BROWSER_OPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const EXP_DARWIN_ID_SIG: u32 = 2684354566u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_System_SystemServices")]
pub struct EXP_DARWIN_LINK {
    pub dbh: DATABLOCK_HEADER,
    pub szDarwinID: [super::super::System::SystemServices::CHAR; 260],
    pub szwDarwinID: [u16; 260],
}
#[cfg(feature = "Win32_System_SystemServices")]
impl EXP_DARWIN_LINK {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::default::Default for EXP_DARWIN_LINK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::PartialEq for EXP_DARWIN_LINK {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::Eq for EXP_DARWIN_LINK {}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::runtime::Abi for EXP_DARWIN_LINK {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct EXP_PROPERTYSTORAGE {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub abPropertyStorage: [u8; 1],
}
impl EXP_PROPERTYSTORAGE {}
impl ::std::default::Default for EXP_PROPERTYSTORAGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for EXP_PROPERTYSTORAGE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for EXP_PROPERTYSTORAGE {}
unsafe impl ::windows::runtime::Abi for EXP_PROPERTYSTORAGE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const EXP_PROPERTYSTORAGE_SIG: u32 = 2684354569u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct EXP_SPECIAL_FOLDER {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub idSpecialFolder: u32,
    pub cbOffset: u32,
}
impl EXP_SPECIAL_FOLDER {}
impl ::std::default::Default for EXP_SPECIAL_FOLDER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for EXP_SPECIAL_FOLDER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for EXP_SPECIAL_FOLDER {}
unsafe impl ::windows::runtime::Abi for EXP_SPECIAL_FOLDER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const EXP_SPECIAL_FOLDER_SIG: u32 = 2684354565u32;
pub const EXP_SZ_ICON_SIG: u32 = 2684354567u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_System_SystemServices")]
pub struct EXP_SZ_LINK {
    pub cbSize: u32,
    pub dwSignature: u32,
    pub szTarget: [super::super::System::SystemServices::CHAR; 260],
    pub swzTarget: [u16; 260],
}
#[cfg(feature = "Win32_System_SystemServices")]
impl EXP_SZ_LINK {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::default::Default for EXP_SZ_LINK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::PartialEq for EXP_SZ_LINK {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::Eq for EXP_SZ_LINK {}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::runtime::Abi for EXP_SZ_LINK {
    type Abi = Self;
    type DefaultType = Self;
}
pub const EXP_SZ_LINK_SIG: u32 = 2684354561u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct EXTRASEARCH {
    pub guidSearch: ::windows::runtime::GUID,
    pub wszFriendlyName: [u16; 80],
    pub wszUrl: [u16; 2084],
}
impl EXTRASEARCH {}
impl ::std::default::Default for EXTRASEARCH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for EXTRASEARCH {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EXTRASEARCH")
            .field("guidSearch", &self.guidSearch)
            .field("wszFriendlyName", &self.wszFriendlyName)
            .field("wszUrl", &self.wszUrl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for EXTRASEARCH {
    fn eq(&self, other: &Self) -> bool {
        self.guidSearch == other.guidSearch
            && self.wszFriendlyName == other.wszFriendlyName
            && self.wszUrl == other.wszUrl
    }
}
impl ::std::cmp::Eq for EXTRASEARCH {}
unsafe impl ::windows::runtime::Abi for EXTRASEARCH {
    type Abi = Self;
    type DefaultType = Self;
}
pub const E_ACTIVATIONDENIED_SHELLERROR: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927439i32 as _);
pub const E_ACTIVATIONDENIED_SHELLNOTREADY: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927436i32 as _);
pub const E_ACTIVATIONDENIED_SHELLRESTART: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927438i32 as _);
pub const E_ACTIVATIONDENIED_UNEXPECTED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927437i32 as _);
pub const E_ACTIVATIONDENIED_USERCLOSE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927440i32 as _);
pub const E_FILE_PLACEHOLDER_NOT_INITIALIZED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927472i32 as _);
pub const E_FILE_PLACEHOLDER_SERVER_TIMED_OUT: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927470i32 as _);
pub const E_FILE_PLACEHOLDER_STORAGEPROVIDER_NOT_FOUND: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927469i32 as _);
pub const E_FILE_PLACEHOLDER_VERSION_MISMATCH: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927471i32 as _);
pub const E_FLAGS: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(-2147217408i32 as _);
pub const E_IMAGEFEED_CHANGEDISABLED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144926960i32 as _);
pub const E_NOTVALIDFORANIMATEDIMAGE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147221503i32 as _);
pub const E_PREVIEWHANDLER_CORRUPT: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2042494972i32 as _);
pub const E_PREVIEWHANDLER_DRM_FAIL: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2042494975i32 as _);
pub const E_PREVIEWHANDLER_NOAUTH: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2042494974i32 as _);
pub const E_PREVIEWHANDLER_NOTFOUND: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2042494973i32 as _);
pub const E_SHELL_EXTENSION_BLOCKED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144926975i32 as _);
pub const E_TILE_NOTIFICATIONS_PLATFORM_FAILURE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927159i32 as _);
pub const E_USERTILE_CHANGEDISABLED: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927215i32 as _);
pub const E_USERTILE_FILESIZE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927212i32 as _);
pub const E_USERTILE_LARGEORDYNAMIC: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927214i32 as _);
pub const E_USERTILE_UNSUPPORTEDFILETYPE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927216i32 as _);
pub const E_USERTILE_VIDEOFRAMESIZE: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2144927213i32 as _);
pub const EnumerableObjectCollection: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        758409409,
        13991,
        17334,
        [172, 36, 211, 240, 47, 217, 96, 122],
    );
pub const ExecuteFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    299611260,
    42277,
    16395,
    [158, 128, 165, 70, 21, 160, 144, 192],
);
pub const ExecuteUnknown: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3830354984,
    48572,
    18823,
    [160, 153, 64, 220, 143, 210, 85, 231],
);
pub const ExplorerBrowser: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1912169349,
    56790,
    18643,
    [160, 193, 174, 6, 232, 176, 85, 251],
);
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractAssociatedIconA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hinst: Param0,
    psziconpath: Param1,
    piicon: *mut u16,
) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractAssociatedIconA(
                hinst: super::super::Foundation::HINSTANCE,
                psziconpath: super::super::Foundation::PSTR,
                piicon: *mut u16,
            ) -> super::WindowsAndMessaging::HICON;
        }
        ::std::mem::transmute(ExtractAssociatedIconA(
            hinst.into_param().abi(),
            psziconpath.into_param().abi(),
            ::std::mem::transmute(piicon),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractAssociatedIconExA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hinst: Param0,
    psziconpath: Param1,
    piiconindex: *mut u16,
    piiconid: *mut u16,
) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractAssociatedIconExA(
                hinst: super::super::Foundation::HINSTANCE,
                psziconpath: super::super::Foundation::PSTR,
                piiconindex: *mut u16,
                piiconid: *mut u16,
            ) -> super::WindowsAndMessaging::HICON;
        }
        ::std::mem::transmute(ExtractAssociatedIconExA(
            hinst.into_param().abi(),
            psziconpath.into_param().abi(),
            ::std::mem::transmute(piiconindex),
            ::std::mem::transmute(piiconid),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractAssociatedIconExW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hinst: Param0,
    psziconpath: Param1,
    piiconindex: *mut u16,
    piiconid: *mut u16,
) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractAssociatedIconExW(
                hinst: super::super::Foundation::HINSTANCE,
                psziconpath: super::super::Foundation::PWSTR,
                piiconindex: *mut u16,
                piiconid: *mut u16,
            ) -> super::WindowsAndMessaging::HICON;
        }
        ::std::mem::transmute(ExtractAssociatedIconExW(
            hinst.into_param().abi(),
            psziconpath.into_param().abi(),
            ::std::mem::transmute(piiconindex),
            ::std::mem::transmute(piiconid),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractAssociatedIconW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hinst: Param0,
    psziconpath: Param1,
    piicon: *mut u16,
) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractAssociatedIconW(
                hinst: super::super::Foundation::HINSTANCE,
                psziconpath: super::super::Foundation::PWSTR,
                piicon: *mut u16,
            ) -> super::WindowsAndMessaging::HICON;
        }
        ::std::mem::transmute(ExtractAssociatedIconW(
            hinst.into_param().abi(),
            psziconpath.into_param().abi(),
            ::std::mem::transmute(piicon),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractIconA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hinst: Param0,
    pszexefilename: Param1,
    niconindex: u32,
) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractIconA(
                hinst: super::super::Foundation::HINSTANCE,
                pszexefilename: super::super::Foundation::PSTR,
                niconindex: u32,
            ) -> super::WindowsAndMessaging::HICON;
        }
        ::std::mem::transmute(ExtractIconA(
            hinst.into_param().abi(),
            pszexefilename.into_param().abi(),
            ::std::mem::transmute(niconindex),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractIconExA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    lpszfile: Param0,
    niconindex: i32,
    phiconlarge: *mut super::WindowsAndMessaging::HICON,
    phiconsmall: *mut super::WindowsAndMessaging::HICON,
    nicons: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractIconExA(
                lpszfile: super::super::Foundation::PSTR,
                niconindex: i32,
                phiconlarge: *mut super::WindowsAndMessaging::HICON,
                phiconsmall: *mut super::WindowsAndMessaging::HICON,
                nicons: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ExtractIconExA(
            lpszfile.into_param().abi(),
            ::std::mem::transmute(niconindex),
            ::std::mem::transmute(phiconlarge),
            ::std::mem::transmute(phiconsmall),
            ::std::mem::transmute(nicons),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractIconExW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    lpszfile: Param0,
    niconindex: i32,
    phiconlarge: *mut super::WindowsAndMessaging::HICON,
    phiconsmall: *mut super::WindowsAndMessaging::HICON,
    nicons: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractIconExW(
                lpszfile: super::super::Foundation::PWSTR,
                niconindex: i32,
                phiconlarge: *mut super::WindowsAndMessaging::HICON,
                phiconsmall: *mut super::WindowsAndMessaging::HICON,
                nicons: u32,
            ) -> u32;
        }
        ::std::mem::transmute(ExtractIconExW(
            lpszfile.into_param().abi(),
            ::std::mem::transmute(niconindex),
            ::std::mem::transmute(phiconlarge),
            ::std::mem::transmute(phiconsmall),
            ::std::mem::transmute(nicons),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub unsafe fn ExtractIconW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HINSTANCE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hinst: Param0,
    pszexefilename: Param1,
    niconindex: u32,
) -> super::WindowsAndMessaging::HICON {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn ExtractIconW(
                hinst: super::super::Foundation::HINSTANCE,
                pszexefilename: super::super::Foundation::PWSTR,
                niconindex: u32,
            ) -> super::WindowsAndMessaging::HICON;
        }
        ::std::mem::transmute(ExtractIconW(
            hinst.into_param().abi(),
            pszexefilename.into_param().abi(),
            ::std::mem::transmute(niconindex),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const FCIDM_BROWSERFIRST: u32 = 40960u32;
pub const FCIDM_BROWSERLAST: u32 = 48896u32;
pub const FCIDM_GLOBALFIRST: u32 = 32768u32;
pub const FCIDM_GLOBALLAST: u32 = 40959u32;
pub const FCIDM_MENU_EDIT: u32 = 32832u32;
pub const FCIDM_MENU_EXPLORE: u32 = 33104u32;
pub const FCIDM_MENU_FAVORITES: u32 = 33136u32;
pub const FCIDM_MENU_FILE: u32 = 32768u32;
pub const FCIDM_MENU_FIND: u32 = 33088u32;
pub const FCIDM_MENU_HELP: u32 = 33024u32;
pub const FCIDM_MENU_TOOLS: u32 = 32960u32;
pub const FCIDM_MENU_TOOLS_SEP_GOTO: u32 = 32961u32;
pub const FCIDM_MENU_VIEW: u32 = 32896u32;
pub const FCIDM_MENU_VIEW_SEP_OPTIONS: u32 = 32897u32;
pub const FCIDM_SHVIEWFIRST: u32 = 0u32;
pub const FCIDM_SHVIEWLAST: u32 = 32767u32;
pub const FCIDM_STATUS: u32 = 40961u32;
pub const FCIDM_TOOLBAR: u32 = 40960u32;
pub const FCSM_CLSID: u32 = 8u32;
pub const FCSM_FLAGS: u32 = 64u32;
pub const FCSM_ICONFILE: u32 = 16u32;
pub const FCSM_INFOTIP: u32 = 4u32;
pub const FCSM_LOGO: u32 = 32u32;
pub const FCSM_VIEWID: u32 = 1u32;
pub const FCSM_WEBVIEWTEMPLATE: u32 = 2u32;
pub const FCS_FLAG_DRAGDROP: u32 = 2u32;
pub const FCS_FORCEWRITE: u32 = 2u32;
pub const FCS_READ: u32 = 1u32;
pub const FCT_ADDTOEND: u32 = 4u32;
pub const FCT_CONFIGABLE: u32 = 2u32;
pub const FCT_MERGE: u32 = 1u32;
pub const FCW_INTERNETBAR: u32 = 6u32;
pub const FCW_PROGRESS: u32 = 8u32;
pub const FCW_STATUS: u32 = 1u32;
pub const FCW_TOOLBAR: u32 = 2u32;
pub const FCW_TREE: u32 = 3u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FDAP(pub i32);
pub const FDAP_BOTTOM: FDAP = FDAP(0i32);
pub const FDAP_TOP: FDAP = FDAP(1i32);
impl ::std::convert::From<i32> for FDAP {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FDAP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FDE_OVERWRITE_RESPONSE(pub i32);
pub const FDEOR_DEFAULT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(0i32);
pub const FDEOR_ACCEPT: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(1i32);
pub const FDEOR_REFUSE: FDE_OVERWRITE_RESPONSE = FDE_OVERWRITE_RESPONSE(2i32);
impl ::std::convert::From<i32> for FDE_OVERWRITE_RESPONSE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FDE_OVERWRITE_RESPONSE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FDE_SHAREVIOLATION_RESPONSE(pub i32);
pub const FDESVR_DEFAULT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(0i32);
pub const FDESVR_ACCEPT: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(1i32);
pub const FDESVR_REFUSE: FDE_SHAREVIOLATION_RESPONSE = FDE_SHAREVIOLATION_RESPONSE(2i32);
impl ::std::convert::From<i32> for FDE_SHAREVIOLATION_RESPONSE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FDE_SHAREVIOLATION_RESPONSE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FDTF_LONGDATE: u32 = 4u32;
pub const FDTF_LONGTIME: u32 = 8u32;
pub const FDTF_LTRDATE: u32 = 256u32;
pub const FDTF_NOAUTOREADINGORDER: u32 = 1024u32;
pub const FDTF_RELATIVE: u32 = 16u32;
pub const FDTF_RTLDATE: u32 = 512u32;
pub const FDTF_SHORTDATE: u32 = 2u32;
pub const FDTF_SHORTTIME: u32 = 1u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FD_FLAGS(pub i32);
pub const FD_CLSID: FD_FLAGS = FD_FLAGS(1i32);
pub const FD_SIZEPOINT: FD_FLAGS = FD_FLAGS(2i32);
pub const FD_ATTRIBUTES: FD_FLAGS = FD_FLAGS(4i32);
pub const FD_CREATETIME: FD_FLAGS = FD_FLAGS(8i32);
pub const FD_ACCESSTIME: FD_FLAGS = FD_FLAGS(16i32);
pub const FD_WRITESTIME: FD_FLAGS = FD_FLAGS(32i32);
pub const FD_FILESIZE: FD_FLAGS = FD_FLAGS(64i32);
pub const FD_PROGRESSUI: FD_FLAGS = FD_FLAGS(16384i32);
pub const FD_LINKUI: FD_FLAGS = FD_FLAGS(32768i32);
pub const FD_UNICODE: FD_FLAGS = FD_FLAGS(-2147483648i32);
impl ::std::convert::From<i32> for FD_FLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FD_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FFFP_MODE(pub i32);
pub const FFFP_EXACTMATCH: FFFP_MODE = FFFP_MODE(0i32);
pub const FFFP_NEARESTPARENTMATCH: FFFP_MODE = FFFP_MODE(1i32);
impl ::std::convert::From<i32> for FFFP_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FFFP_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
pub struct FILEDESCRIPTORA {
    pub dwFlags: u32,
    pub clsid: ::windows::runtime::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [super::super::System::SystemServices::CHAR; 260],
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl FILEDESCRIPTORA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::default::Default for FILEDESCRIPTORA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::cmp::PartialEq for FILEDESCRIPTORA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::cmp::Eq for FILEDESCRIPTORA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
unsafe impl ::windows::runtime::Abi for FILEDESCRIPTORA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEDESCRIPTORW {
    pub dwFlags: u32,
    pub clsid: ::windows::runtime::GUID,
    pub sizel: super::super::Foundation::SIZE,
    pub pointl: super::super::Foundation::POINTL,
    pub dwFileAttributes: u32,
    pub ftCreationTime: super::super::Foundation::FILETIME,
    pub ftLastAccessTime: super::super::Foundation::FILETIME,
    pub ftLastWriteTime: super::super::Foundation::FILETIME,
    pub nFileSizeHigh: u32,
    pub nFileSizeLow: u32,
    pub cFileName: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl FILEDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for FILEDESCRIPTORW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for FILEDESCRIPTORW {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for FILEDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for FILEDESCRIPTORW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
pub struct FILEGROUPDESCRIPTORA {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORA; 1],
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl FILEGROUPDESCRIPTORA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::default::Default for FILEGROUPDESCRIPTORA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::cmp::PartialEq for FILEGROUPDESCRIPTORA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::cmp::Eq for FILEGROUPDESCRIPTORA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
unsafe impl ::windows::runtime::Abi for FILEGROUPDESCRIPTORA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
#[cfg(feature = "Win32_Foundation")]
pub struct FILEGROUPDESCRIPTORW {
    pub cItems: u32,
    pub fgd: [FILEDESCRIPTORW; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl FILEGROUPDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for FILEGROUPDESCRIPTORW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for FILEGROUPDESCRIPTORW {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for FILEGROUPDESCRIPTORW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for FILEGROUPDESCRIPTORW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FILETYPEATTRIBUTEFLAGS(pub i32);
pub const FTA_None: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(0i32);
pub const FTA_Exclude: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1i32);
pub const FTA_Show: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2i32);
pub const FTA_HasExtension: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4i32);
pub const FTA_NoEdit: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8i32);
pub const FTA_NoRemove: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(16i32);
pub const FTA_NoNewVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32i32);
pub const FTA_NoEditVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(64i32);
pub const FTA_NoRemoveVerb: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(128i32);
pub const FTA_NoEditDesc: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(256i32);
pub const FTA_NoEditIcon: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(512i32);
pub const FTA_NoEditDflt: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1024i32);
pub const FTA_NoEditVerbCmd: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2048i32);
pub const FTA_NoEditVerbExe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4096i32);
pub const FTA_NoDDE: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(8192i32);
pub const FTA_NoEditMIME: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(32768i32);
pub const FTA_OpenIsSafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(65536i32);
pub const FTA_AlwaysUnsafe: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(131072i32);
pub const FTA_NoRecentDocs: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(1048576i32);
pub const FTA_SafeForElevation: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(2097152i32);
pub const FTA_AlwaysUseDirectInvoke: FILETYPEATTRIBUTEFLAGS = FILETYPEATTRIBUTEFLAGS(4194304i32);
impl ::std::convert::From<i32> for FILETYPEATTRIBUTEFLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FILETYPEATTRIBUTEFLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C, packed(1))]
pub struct FILE_ATTRIBUTES_ARRAY {
    pub cItems: u32,
    pub dwSumFileAttributes: u32,
    pub dwProductFileAttributes: u32,
    pub rgdwFileAttributes: [u32; 1],
}
impl FILE_ATTRIBUTES_ARRAY {}
impl ::std::default::Default for FILE_ATTRIBUTES_ARRAY {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for FILE_ATTRIBUTES_ARRAY {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for FILE_ATTRIBUTES_ARRAY {}
unsafe impl ::windows::runtime::Abi for FILE_ATTRIBUTES_ARRAY {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FILE_OPERATION_FLAGS2(pub i32);
pub const FOF2_NONE: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(0i32);
pub const FOF2_MERGEFOLDERSONCOLLISION: FILE_OPERATION_FLAGS2 = FILE_OPERATION_FLAGS2(1i32);
impl ::std::convert::From<i32> for FILE_OPERATION_FLAGS2 {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FILE_OPERATION_FLAGS2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FILE_USAGE_TYPE(pub i32);
pub const FUT_PLAYING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(0i32);
pub const FUT_EDITING: FILE_USAGE_TYPE = FILE_USAGE_TYPE(1i32);
pub const FUT_GENERIC: FILE_USAGE_TYPE = FILE_USAGE_TYPE(2i32);
impl ::std::convert::From<i32> for FILE_USAGE_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FILE_USAGE_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FLYOUT_PLACEMENT(pub i32);
pub const FP_DEFAULT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(0i32);
pub const FP_ABOVE: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(1i32);
pub const FP_BELOW: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(2i32);
pub const FP_LEFT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(3i32);
pub const FP_RIGHT: FLYOUT_PLACEMENT = FLYOUT_PLACEMENT(4i32);
impl ::std::convert::From<i32> for FLYOUT_PLACEMENT {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FLYOUT_PLACEMENT {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FMTID_Briefcase: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    848136993,
    30505,
    19452,
    [149, 76, 144, 43, 50, 157, 86, 176],
);
pub const FMTID_CustomImageProperties: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2127399694,
        49462,
        19099,
        [148, 17, 78, 189, 102, 115, 204, 195],
    );
pub const FMTID_DRM: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2930514404,
    35246,
    17672,
    [185, 183, 187, 134, 122, 190, 226, 237],
);
pub const FMTID_Displaced: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2601995059,
    16639,
    4562,
    [162, 126, 0, 192, 79, 195, 8, 113],
);
pub const FMTID_ImageProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    347610529,
    309,
    19761,
    [150, 217, 108, 191, 201, 103, 26, 153],
);
pub const FMTID_InternetSite: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136353, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const FMTID_Intshcut: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(136352, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
pub const FMTID_LibraryProperties: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1568061055,
    39741,
    17595,
    [182, 174, 37, 218, 79, 99, 138, 103],
);
pub const FMTID_MUSIC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1453537070,
    52892,
    4562,
    [159, 14, 0, 96, 151, 198, 134, 246],
);
pub const FMTID_Misc: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2601995060,
    16639,
    4562,
    [162, 126, 0, 192, 79, 195, 8, 113],
);
pub const FMTID_Query: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1231625360,
    32279,
    4122,
    [169, 28, 8, 0, 43, 46, 205, 169],
);
pub const FMTID_ShellDetails: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    677604006,
    38205,
    4562,
    [181, 214, 0, 192, 79, 217, 24, 208],
);
pub const FMTID_Storage: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3072717104,
    18415,
    4122,
    [165, 241, 2, 96, 140, 158, 235, 172],
);
pub const FMTID_Volume: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2601995061,
    16639,
    4562,
    [162, 126, 0, 192, 79, 195, 8, 113],
);
pub const FMTID_WebView: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4062663808,
    63362,
    17041,
    [189, 148, 241, 54, 147, 81, 58, 236],
);
pub const FOFX_ADDUNDORECORD: u32 = 536870912u32;
pub const FOFX_COPYASDOWNLOAD: u32 = 1073741824u32;
pub const FOFX_DONTDISPLAYDESTPATH: u32 = 134217728u32;
pub const FOFX_DONTDISPLAYLOCATIONS: u32 = 2147483648u32;
pub const FOFX_DONTDISPLAYSOURCEPATH: u32 = 67108864u32;
pub const FOFX_EARLYFAILURE: u32 = 1048576u32;
pub const FOFX_KEEPNEWERFILE: u32 = 4194304u32;
pub const FOFX_MOVEACLSACROSSVOLUMES: u32 = 33554432u32;
pub const FOFX_NOCOPYHOOKS: u32 = 8388608u32;
pub const FOFX_NOMINIMIZEBOX: u32 = 16777216u32;
pub const FOFX_NOSKIPJUNCTIONS: u32 = 65536u32;
pub const FOFX_PREFERHARDLINK: u32 = 131072u32;
pub const FOFX_PRESERVEFILEEXTENSIONS: u32 = 2097152u32;
pub const FOFX_RECYCLEONDELETE: u32 = 524288u32;
pub const FOFX_REQUIREELEVATION: u32 = 268435456u32;
pub const FOFX_SHOWELEVATIONPROMPT: u32 = 262144u32;
pub const FOF_ALLOWUNDO: u32 = 64u32;
pub const FOF_CONFIRMMOUSE: u32 = 2u32;
pub const FOF_FILESONLY: u32 = 128u32;
pub const FOF_MULTIDESTFILES: u32 = 1u32;
pub const FOF_NOCONFIRMATION: u32 = 16u32;
pub const FOF_NOCONFIRMMKDIR: u32 = 512u32;
pub const FOF_NOCOPYSECURITYATTRIBS: u32 = 2048u32;
pub const FOF_NOERRORUI: u32 = 1024u32;
pub const FOF_NORECURSEREPARSE: u32 = 32768u32;
pub const FOF_NORECURSION: u32 = 4096u32;
pub const FOF_NO_CONNECTED_ELEMENTS: u32 = 8192u32;
pub const FOF_RENAMEONCOLLISION: u32 = 8u32;
pub const FOF_SILENT: u32 = 4u32;
pub const FOF_SIMPLEPROGRESS: u32 = 256u32;
pub const FOF_WANTMAPPINGHANDLE: u32 = 32u32;
pub const FOF_WANTNUKEWARNING: u32 = 16384u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FOLDERFLAGS(pub i32);
pub const FWF_NONE: FOLDERFLAGS = FOLDERFLAGS(0i32);
pub const FWF_AUTOARRANGE: FOLDERFLAGS = FOLDERFLAGS(1i32);
pub const FWF_ABBREVIATEDNAMES: FOLDERFLAGS = FOLDERFLAGS(2i32);
pub const FWF_SNAPTOGRID: FOLDERFLAGS = FOLDERFLAGS(4i32);
pub const FWF_OWNERDATA: FOLDERFLAGS = FOLDERFLAGS(8i32);
pub const FWF_BESTFITWINDOW: FOLDERFLAGS = FOLDERFLAGS(16i32);
pub const FWF_DESKTOP: FOLDERFLAGS = FOLDERFLAGS(32i32);
pub const FWF_SINGLESEL: FOLDERFLAGS = FOLDERFLAGS(64i32);
pub const FWF_NOSUBFOLDERS: FOLDERFLAGS = FOLDERFLAGS(128i32);
pub const FWF_TRANSPARENT: FOLDERFLAGS = FOLDERFLAGS(256i32);
pub const FWF_NOCLIENTEDGE: FOLDERFLAGS = FOLDERFLAGS(512i32);
pub const FWF_NOSCROLL: FOLDERFLAGS = FOLDERFLAGS(1024i32);
pub const FWF_ALIGNLEFT: FOLDERFLAGS = FOLDERFLAGS(2048i32);
pub const FWF_NOICONS: FOLDERFLAGS = FOLDERFLAGS(4096i32);
pub const FWF_SHOWSELALWAYS: FOLDERFLAGS = FOLDERFLAGS(8192i32);
pub const FWF_NOVISIBLE: FOLDERFLAGS = FOLDERFLAGS(16384i32);
pub const FWF_SINGLECLICKACTIVATE: FOLDERFLAGS = FOLDERFLAGS(32768i32);
pub const FWF_NOWEBVIEW: FOLDERFLAGS = FOLDERFLAGS(65536i32);
pub const FWF_HIDEFILENAMES: FOLDERFLAGS = FOLDERFLAGS(131072i32);
pub const FWF_CHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(262144i32);
pub const FWF_NOENUMREFRESH: FOLDERFLAGS = FOLDERFLAGS(524288i32);
pub const FWF_NOGROUPING: FOLDERFLAGS = FOLDERFLAGS(1048576i32);
pub const FWF_FULLROWSELECT: FOLDERFLAGS = FOLDERFLAGS(2097152i32);
pub const FWF_NOFILTERS: FOLDERFLAGS = FOLDERFLAGS(4194304i32);
pub const FWF_NOCOLUMNHEADER: FOLDERFLAGS = FOLDERFLAGS(8388608i32);
pub const FWF_NOHEADERINALLVIEWS: FOLDERFLAGS = FOLDERFLAGS(16777216i32);
pub const FWF_EXTENDEDTILES: FOLDERFLAGS = FOLDERFLAGS(33554432i32);
pub const FWF_TRICHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(67108864i32);
pub const FWF_AUTOCHECKSELECT: FOLDERFLAGS = FOLDERFLAGS(134217728i32);
pub const FWF_NOBROWSERVIEWSTATE: FOLDERFLAGS = FOLDERFLAGS(268435456i32);
pub const FWF_SUBSETGROUPS: FOLDERFLAGS = FOLDERFLAGS(536870912i32);
pub const FWF_USESEARCHFOLDER: FOLDERFLAGS = FOLDERFLAGS(1073741824i32);
pub const FWF_ALLOWRTLREADING: FOLDERFLAGS = FOLDERFLAGS(-2147483648i32);
impl ::std::convert::From<i32> for FOLDERFLAGS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FOLDERFLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FOLDERID_AccountPictures: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        9216177,
        21940,
        19542,
        [184, 168, 77, 228, 178, 153, 211, 190],
    );
pub const FOLDERID_AddNewPrograms: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3730954609,
    24252,
    20226,
    [163, 169, 108, 130, 137, 94, 92, 4],
);
pub const FOLDERID_AdminTools: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1917776240,
    42029,
    20463,
    [159, 38, 182, 14, 132, 111, 186, 79],
);
pub const FOLDERID_AllAppMods: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2060875929,
    26287,
    17338,
    [145, 86, 106, 173, 66, 230, 197, 150],
);
pub const FOLDERID_AppCaptures: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3988848241,
    39128,
    20298,
    [185, 32, 200, 220, 19, 60, 177, 101],
);
pub const FOLDERID_AppDataDesktop: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2999313017,
    31453,
    17311,
    [178, 140, 196, 31, 225, 187, 246, 114],
);
pub const FOLDERID_AppDataDocuments: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2078369296,
        8063,
        17580,
        [191, 240, 131, 225, 95, 47, 252, 161],
    );
pub const FOLDERID_AppDataFavorites: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2096885692,
        56863,
        17834,
        [184, 67, 165, 66, 172, 83, 108, 201],
    );
pub const FOLDERID_AppDataProgramData: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1436369059,
        41014,
        16634,
        [175, 97, 132, 203, 67, 10, 77, 52],
    );
pub const FOLDERID_AppUpdates: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2735066777,
    62759,
    18731,
    [139, 26, 126, 118, 250, 152, 214, 228],
);
pub const FOLDERID_ApplicationShortcuts: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2744223617,
        58866,
        18576,
        [179, 217, 167, 229, 67, 50, 50, 140],
    );
pub const FOLDERID_AppsFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    512184461,
    35266,
    17136,
    [138, 126, 100, 90, 15, 80, 202, 88],
);
pub const FOLDERID_CDBurning: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2656217872,
    63501,
    18911,
    [172, 184, 67, 48, 245, 104, 120, 85],
);
pub const FOLDERID_CameraRoll: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2875177083,
    31970,
    20355,
    [145, 93, 85, 8, 70, 201, 83, 123],
);
pub const FOLDERID_CameraRollLibrary: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        723574645,
        7898,
        16441,
        [128, 151, 56, 121, 130, 39, 213, 183],
    );
pub const FOLDERID_ChangeRemovePrograms: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3748816556,
        37492,
        18535,
        [141, 85, 59, 214, 97, 222, 135, 45],
    );
pub const FOLDERID_CommonAdminTools: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3493351037,
        47811,
        18327,
        [143, 20, 203, 162, 41, 179, 146, 181],
    );
pub const FOLDERID_CommonOEMLinks: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3250250448,
    4319,
    17204,
    [190, 221, 122, 162, 11, 34, 122, 157],
);
pub const FOLDERID_CommonPrograms: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    20567118,
    27390,
    18930,
    [134, 144, 61, 175, 202, 230, 255, 184],
);
pub const FOLDERID_CommonStartMenu: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2752599833,
        54830,
        18717,
        [170, 124, 231, 75, 139, 227, 176, 103],
    );
pub const FOLDERID_CommonStartMenuPlaces: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2755692447,
        34720,
        20349,
        [183, 0, 2, 7, 185, 102, 25, 74],
    );
pub const FOLDERID_CommonStartup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2191911477,
    55757,
    18373,
    [150, 41, 225, 93, 47, 113, 78, 110],
);
pub const FOLDERID_CommonTemplates: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3108124647,
        22444,
        17223,
        [145, 81, 176, 140, 108, 50, 209, 247],
    );
pub const FOLDERID_ComputerFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    180388732,
    48120,
    17706,
    [133, 13, 121, 208, 142, 102, 124, 167],
);
pub const FOLDERID_ConflictFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1275001669,
    13437,
    16390,
    [165, 190, 172, 12, 176, 86, 113, 146],
);
pub const FOLDERID_ConnectionsFolder: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1863113003,
        11927,
        17873,
        [136, 255, 176, 209, 134, 184, 222, 221],
    );
pub const FOLDERID_Contacts: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1450723412,
    50891,
    17963,
    [129, 105, 136, 227, 80, 172, 184, 130],
);
pub const FOLDERID_ControlPanelFolder: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2192001771,
        44724,
        18012,
        [160, 20, 208, 151, 238, 52, 109, 99],
    );
pub const FOLDERID_Cookies: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    722433629,
    49385,
    16753,
    [144, 142, 8, 166, 17, 184, 79, 246],
);
pub const FOLDERID_CurrentAppMods: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1035209504,
    10800,
    19902,
    [145, 126, 119, 29, 210, 29, 208, 153],
);
pub const FOLDERID_Desktop: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3032468538,
    56108,
    16972,
    [176, 41, 127, 233, 154, 135, 198, 65],
);
pub const FOLDERID_DevelopmentFiles: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3689472142,
        12371,
        19388,
        [177, 131, 42, 123, 43, 25, 30, 89],
    );
pub const FOLDERID_Device: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    472564188,
    17240,
    19308,
    [151, 51, 175, 33, 21, 101, 118, 240],
);
pub const FOLDERID_DeviceMetadataStore: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1558488553,
        58603,
        18333,
        [184, 159, 19, 12, 2, 136, 97, 85],
    );
pub const FOLDERID_Documents: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4258503376,
    9103,
    18095,
    [173, 180, 108, 133, 72, 3, 105, 199],
);
pub const FOLDERID_DocumentsLibrary: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2064494973,
        40146,
        19091,
        [151, 51, 70, 204, 137, 2, 46, 124],
    );
pub const FOLDERID_Downloads: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    927851152,
    4671,
    17765,
    [145, 100, 57, 196, 146, 94, 70, 123],
);
pub const FOLDERID_Favorites: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    393738081,
    26797,
    19850,
    [135, 189, 48, 183, 89, 250, 51, 221],
);
pub const FOLDERID_Fonts: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4246899895,
    44561,
    19171,
    [134, 76, 22, 243, 145, 10, 184, 254],
);
pub const FOLDERID_GameTasks: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    89108065,
    19928,
    18311,
    [128, 182, 9, 2, 32, 196, 183, 0],
);
pub const FOLDERID_Games: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3401919514,
    46397,
    20188,
    [146, 215, 107, 46, 138, 193, 148, 52],
);
pub const FOLDERID_History: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3655109179,
    46980,
    17198,
    [167, 129, 90, 17, 48, 167, 89, 99],
);
pub const FOLDERID_HomeGroup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1381141099,
    47587,
    19165,
    [182, 13, 88, 140, 45, 186, 132, 45],
);
pub const FOLDERID_HomeGroupCurrentUser: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2608117411,
        3581,
        20241,
        [158, 120, 95, 120, 0, 242, 231, 114],
    );
pub const FOLDERID_ImplicitAppShortcuts: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3165988207,
        31222,
        19694,
        [183, 37, 220, 52, 228, 2, 253, 70],
    );
pub const FOLDERID_InternetCache: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    891585000,
    13246,
    16977,
    [186, 133, 96, 7, 202, 237, 207, 157],
);
pub const FOLDERID_InternetFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1302296692,
    19980,
    18692,
    [150, 123, 64, 176, 210, 12, 62, 75],
);
pub const FOLDERID_Libraries: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    457090524,
    46471,
    18310,
    [180, 239, 189, 29, 195, 50, 174, 174],
);
pub const FOLDERID_Links: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3216627168,
    50857,
    16460,
    [178, 178, 174, 109, 182, 175, 73, 104],
);
pub const FOLDERID_LocalAppData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4055050117,
    28602,
    20431,
    [157, 85, 123, 142, 127, 21, 112, 145],
);
pub const FOLDERID_LocalAppDataLow: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2770379172,
        6016,
        20470,
        [189, 24, 22, 115, 67, 197, 175, 22],
    );
pub const FOLDERID_LocalDocuments: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4096713427,
    37023,
    18695,
    [136, 113, 76, 34, 252, 11, 247, 86],
);
pub const FOLDERID_LocalDownloads: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2105798299,
    8772,
    20080,
    [177, 245, 83, 147, 4, 42, 241, 228],
);
pub const FOLDERID_LocalMusic: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2697370265,
    8648,
    18033,
    [135, 3, 121, 52, 22, 47, 207, 29],
);
pub const FOLDERID_LocalPictures: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    232587613,
    45164,
    17877,
    [140, 76, 245, 151, 19, 133, 70, 57],
);
pub const FOLDERID_LocalStorage: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3018524883,
    41459,
    18795,
    [134, 90, 66, 181, 54, 205, 160, 236],
);
pub const FOLDERID_LocalVideos: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    891841128,
    15447,
    16801,
    [187, 177, 14, 174, 115, 215, 108, 149],
);
pub const FOLDERID_LocalizedResourcesDir: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        704657246,
        8780,
        18910,
        [184, 209, 68, 13, 247, 239, 61, 220],
    );
pub const FOLDERID_Music: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1272501617,
    27929,
    18643,
    [190, 151, 66, 34, 32, 8, 14, 67],
);
pub const FOLDERID_MusicLibrary: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    554871562,
    51306,
    20478,
    [163, 104, 13, 233, 110, 71, 1, 46],
);
pub const FOLDERID_NetHood: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3316367187,
    57727,
    16673,
    [137, 0, 134, 98, 111, 194, 201, 115],
);
pub const FOLDERID_NetworkFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3523997380,
    23720,
    18693,
    [174, 59, 191, 37, 30, 160, 155, 83],
);
pub const FOLDERID_Objects3D: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    834723109,
    37945,
    20242,
    [191, 65, 127, 244, 237, 163, 135, 34],
);
pub const FOLDERID_OneDrive: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2771106374,
    59873,
    17247,
    [179, 217, 40, 218, 166, 72, 192, 246],
);
pub const FOLDERID_OriginalImages: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    741785770,
    22546,
    19335,
    [191, 208, 76, 208, 223, 177, 155, 57],
);
pub const FOLDERID_PhotoAlbums: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1775423376,
    64563,
    20407,
    [154, 12, 235, 176, 240, 252, 180, 60],
);
pub const FOLDERID_Pictures: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    870482224,
    19998,
    18038,
    [131, 90, 152, 57, 92, 59, 195, 187],
);
pub const FOLDERID_PicturesLibrary: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2844831391,
        41019,
        20096,
        [148, 188, 153, 18, 215, 80, 65, 4],
    );
pub const FOLDERID_Playlists: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3734159815,
    33663,
    20329,
    [163, 187, 134, 230, 49, 32, 74, 35],
);
pub const FOLDERID_PrintHood: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2457124237,
    53201,
    16835,
    [179, 94, 177, 63, 85, 167, 88, 244],
);
pub const FOLDERID_PrintersFolder: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1996246573,
    54957,
    17689,
    [166, 99, 55, 189, 86, 6, 129, 133],
);
pub const FOLDERID_Profile: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1584170383,
    3618,
    18272,
    [154, 254, 234, 51, 23, 182, 113, 115],
);
pub const FOLDERID_ProgramData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1655397762,
    64961,
    19907,
    [169, 221, 7, 13, 29, 73, 93, 151],
);
pub const FOLDERID_ProgramFiles: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2422105014,
    49599,
    18766,
    [178, 156, 101, 183, 50, 211, 210, 26],
);
pub const FOLDERID_ProgramFilesCommon: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4159827205,
        40813,
        18338,
        [170, 174, 41, 211, 23, 198, 240, 102],
    );
pub const FOLDERID_ProgramFilesCommonX64: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1667618215,
        3853,
        17893,
        [135, 246, 13, 165, 107, 106, 79, 125],
    );
pub const FOLDERID_ProgramFilesCommonX86: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3734457636,
        55750,
        19774,
        [191, 145, 244, 69, 81, 32, 185, 23],
    );
pub const FOLDERID_ProgramFilesX64: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1837142903,
        27376,
        17483,
        [137, 87, 163, 119, 63, 2, 32, 14],
    );
pub const FOLDERID_ProgramFilesX86: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2086289647,
        41211,
        19452,
        [135, 74, 192, 242, 224, 185, 250, 142],
    );
pub const FOLDERID_Programs: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2810142071,
    11819,
    17603,
    [166, 162, 171, 166, 1, 5, 74, 81],
);
pub const FOLDERID_Public: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3755964066,
    51242,
    19811,
    [144, 106, 86, 68, 172, 69, 115, 133],
);
pub const FOLDERID_PublicDesktop: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3299488781,
    61967,
    18531,
    [175, 239, 248, 126, 242, 230, 186, 37],
);
pub const FOLDERID_PublicDocuments: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3980928175,
        56548,
        17832,
        [129, 226, 252, 121, 101, 8, 54, 52],
    );
pub const FOLDERID_PublicDownloads: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1029983387,
        8120,
        20272,
        [155, 69, 246, 112, 35, 95, 121, 192],
    );
pub const FOLDERID_PublicGameTasks: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3737068854,
        57768,
        19545,
        [182, 162, 65, 69, 134, 71, 106, 234],
    );
pub const FOLDERID_PublicLibraries: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1222309899,
        59087,
        20302,
        [184, 0, 14, 105, 216, 78, 227, 132],
    );
pub const FOLDERID_PublicMusic: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    840235701,
    38743,
    17048,
    [187, 97, 146, 169, 222, 170, 68, 255],
);
pub const FOLDERID_PublicPictures: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3068918662,
    26887,
    16700,
    [154, 247, 79, 194, 171, 240, 124, 197],
);
pub const FOLDERID_PublicRingtones: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3847596896,
        5435,
        19735,
        [159, 4, 165, 254, 153, 252, 21, 236],
    );
pub const FOLDERID_PublicUserTiles: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        75673452,
        2289,
        19508,
        [140, 144, 225, 126, 201, 139, 30, 23],
    );
pub const FOLDERID_PublicVideos: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    603985978,
    24965,
    18939,
    [162, 216, 74, 57, 42, 96, 43, 163],
);
pub const FOLDERID_QuickLaunch: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1386541089,
    31605,
    18601,
    [159, 107, 75, 135, 162, 16, 188, 143],
);
pub const FOLDERID_Recent: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2924527745,
    60370,
    17290,
    [134, 85, 138, 9, 46, 52, 152, 122],
);
pub const FOLDERID_RecordedCalls: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    797655234,
    33773,
    18670,
    [179, 131, 161, 241, 87, 236, 111, 154],
);
pub const FOLDERID_RecordedTVLibrary: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        443538338,
        62509,
        17240,
        [167, 152, 183, 77, 116, 89, 38, 197],
    );
pub const FOLDERID_RecycleBinFolder: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3075686470,
        16075,
        19480,
        [190, 78, 100, 205, 76, 183, 214, 172],
    );
pub const FOLDERID_ResourceDir: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2328955953,
    10971,
    17046,
    [168, 247, 228, 112, 18, 50, 201, 114],
);
pub const FOLDERID_RetailDemo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    315934366,
    9389,
    18723,
    [190, 25, 49, 50, 28, 67, 167, 103],
);
pub const FOLDERID_Ringtones: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3362784331,
    62622,
    16678,
    [169, 195, 181, 42, 31, 244, 17, 232],
);
pub const FOLDERID_RoamedTileImages: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2863191461,
        61910,
        16985,
        [186, 168, 120, 231, 239, 96, 131, 94],
    );
pub const FOLDERID_RoamingAppData: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1052149211,
    26105,
    19702,
    [160, 58, 227, 239, 101, 114, 159, 61],
);
pub const FOLDERID_RoamingTiles: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    12385370,
    60820,
    20040,
    [150, 161, 63, 98, 23, 242, 25, 144],
);
pub const FOLDERID_SEARCH_CSC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3996312646,
    12746,
    19130,
    [129, 79, 165, 235, 210, 253, 109, 94],
);
pub const FOLDERID_SEARCH_MAPI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2565606936,
    8344,
    19780,
    [134, 68, 102, 151, 147, 21, 162, 129],
);
pub const FOLDERID_SampleMusic: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2991638120,
    62845,
    20193,
    [166, 60, 41, 14, 231, 209, 170, 31],
);
pub const FOLDERID_SamplePictures: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3297772864,
    9081,
    19573,
    [132, 75, 100, 230, 250, 248, 113, 107],
);
pub const FOLDERID_SamplePlaylists: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        365586867,
        12526,
        18881,
        [172, 225, 107, 94, 195, 114, 175, 181],
    );
pub const FOLDERID_SampleVideos: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2241768852,
    11909,
    18605,
    [167, 26, 9, 105, 203, 86, 166, 205],
);
pub const FOLDERID_SavedGames: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1281110783,
    48029,
    17328,
    [181, 180, 45, 114, 229, 78, 170, 164],
);
pub const FOLDERID_SavedPictures: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    991508610,
    54189,
    20139,
    [150, 90, 105, 130, 157, 31, 181, 159],
);
pub const FOLDERID_SavedPicturesLibrary: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3797637138,
        48776,
        19417,
        [148, 176, 41, 35, 52, 119, 182, 195],
    );
pub const FOLDERID_SavedSearches: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2099067396,
    57019,
    16661,
    [149, 207, 47, 41, 218, 41, 32, 218],
);
pub const FOLDERID_Screenshots: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3082739329,
    57236,
    18050,
    [167, 216, 87, 165, 38, 32, 184, 111],
);
pub const FOLDERID_SearchHistory: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    223100342,
    931,
    17967,
    [160, 230, 8, 146, 76, 65, 181, 212],
);
pub const FOLDERID_SearchHome: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    419641297,
    47306,
    16673,
    [166, 57, 109, 71, 45, 22, 151, 42],
);
pub const FOLDERID_SearchTemplates: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2120444926,
        57257,
        19806,
        [180, 86, 215, 179, 152, 81, 216, 169],
    );
pub const FOLDERID_SendTo: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2307064684,
    10176,
    16459,
    [143, 8, 16, 45, 16, 220, 253, 116],
);
pub const FOLDERID_SidebarDefaultParts: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2067361364,
        40645,
        17152,
        [190, 10, 36, 130, 235, 174, 26, 38],
    );
pub const FOLDERID_SidebarParts: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2807903790,
    20732,
    20407,
    [172, 44, 168, 190, 170, 49, 68, 147],
);
pub const FOLDERID_SkyDrive: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2771106374,
    59873,
    17247,
    [179, 217, 40, 218, 166, 72, 192, 246],
);
pub const FOLDERID_SkyDriveCameraRoll: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1987995665,
        18891,
        17011,
        [135, 194, 32, 243, 85, 225, 8, 91],
    );
pub const FOLDERID_SkyDriveDocuments: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        618176036,
        12057,
        17716,
        [157, 222, 106, 102, 113, 251, 184, 254],
    );
pub const FOLDERID_SkyDriveMusic: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3287434654,
    32982,
    17884,
    [191, 239, 31, 118, 159, 43, 231, 48],
);
pub const FOLDERID_SkyDrivePictures: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        865540533,
        35911,
        18580,
        [148, 194, 216, 247, 122, 221, 68, 166],
    );
pub const FOLDERID_StartMenu: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1650152387,
    43848,
    20161,
    [186, 31, 161, 239, 65, 70, 252, 25],
);
pub const FOLDERID_StartMenuAllPrograms: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4066575855,
        26952,
        16569,
        [178, 85, 129, 69, 61, 9, 199, 133],
    );
pub const FOLDERID_Startup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3111985339,
    62570,
    19607,
    [186, 16, 94, 54, 8, 67, 8, 84],
);
pub const FOLDERID_SyncManagerFolder: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1130793976,
        49486,
        18866,
        [151, 201, 116, 119, 132, 215, 132, 183],
    );
pub const FOLDERID_SyncResultsFolder: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        681220675,
        48708,
        16471,
        [164, 27, 88, 122, 118, 215, 231, 249],
    );
pub const FOLDERID_SyncSetupFolder: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        253837624,
        45523,
        19088,
        [187, 169, 39, 203, 192, 197, 56, 154],
    );
pub const FOLDERID_System: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    448876151,
    743,
    20061,
    [183, 68, 46, 177, 174, 81, 152, 183],
);
pub const FOLDERID_SystemX86: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3595710896,
    45809,
    18519,
    [164, 206, 168, 231, 198, 234, 125, 39],
);
pub const FOLDERID_Templates: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2788332520,
    26190,
    18651,
    [160, 121, 223, 117, 158, 5, 9, 247],
);
pub const FOLDERID_UserPinned: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2654573995,
    8092,
    20243,
    [184, 39, 72, 178, 75, 108, 113, 116],
);
pub const FOLDERID_UserProfiles: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    123916914,
    50442,
    19376,
    [163, 130, 105, 125, 205, 114, 155, 128],
);
pub const FOLDERID_UserProgramFiles: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1557638882,
        8729,
        19047,
        [184, 93, 108, 156, 225, 86, 96, 203],
    );
pub const FOLDERID_UserProgramFilesCommon: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3166515287,
        51804,
        17954,
        [180, 45, 188, 86, 219, 10, 229, 22],
    );
pub const FOLDERID_UsersFiles: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4090367868,
    18689,
    19148,
    [134, 72, 213, 212, 75, 4, 239, 143],
);
pub const FOLDERID_UsersLibraries: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2734838877,
    57087,
    17995,
    [171, 232, 97, 200, 100, 141, 147, 155],
);
pub const FOLDERID_Videos: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    412654365,
    39349,
    17755,
    [132, 28, 171, 124, 116, 228, 221, 252],
);
pub const FOLDERID_VideosLibrary: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1226740271,
    22083,
    19188,
    [167, 235, 78, 122, 19, 141, 129, 116],
);
pub const FOLDERID_Windows: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4086035460,
    7491,
    17138,
    [147, 5, 103, 222, 11, 40, 252, 35],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FOLDERLOGICALVIEWMODE(pub i32);
pub const FLVM_UNSPECIFIED: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(-1i32);
pub const FLVM_FIRST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
pub const FLVM_DETAILS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(1i32);
pub const FLVM_TILES: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(2i32);
pub const FLVM_ICONS: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(3i32);
pub const FLVM_LIST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(4i32);
pub const FLVM_CONTENT: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
pub const FLVM_LAST: FOLDERLOGICALVIEWMODE = FOLDERLOGICALVIEWMODE(5i32);
impl ::std::convert::From<i32> for FOLDERLOGICALVIEWMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FOLDERLOGICALVIEWMODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct FOLDERSETDATA {
    pub _fs: FOLDERSETTINGS,
    pub _vidRestore: ::windows::runtime::GUID,
    pub _dwViewPriority: u32,
}
impl FOLDERSETDATA {}
impl ::std::default::Default for FOLDERSETDATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FOLDERSETDATA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FOLDERSETDATA")
            .field("_fs", &self._fs)
            .field("_vidRestore", &self._vidRestore)
            .field("_dwViewPriority", &self._dwViewPriority)
            .finish()
    }
}
impl ::std::cmp::PartialEq for FOLDERSETDATA {
    fn eq(&self, other: &Self) -> bool {
        self._fs == other._fs
            && self._vidRestore == other._vidRestore
            && self._dwViewPriority == other._dwViewPriority
    }
}
impl ::std::cmp::Eq for FOLDERSETDATA {}
unsafe impl ::windows::runtime::Abi for FOLDERSETDATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct FOLDERSETTINGS {
    pub ViewMode: u32,
    pub fFlags: u32,
}
impl FOLDERSETTINGS {}
impl ::std::default::Default for FOLDERSETTINGS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FOLDERSETTINGS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FOLDERSETTINGS")
            .field("ViewMode", &self.ViewMode)
            .field("fFlags", &self.fFlags)
            .finish()
    }
}
impl ::std::cmp::PartialEq for FOLDERSETTINGS {
    fn eq(&self, other: &Self) -> bool {
        self.ViewMode == other.ViewMode && self.fFlags == other.fFlags
    }
}
impl ::std::cmp::Eq for FOLDERSETTINGS {}
unsafe impl ::windows::runtime::Abi for FOLDERSETTINGS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FOLDERTYPEID_AccountPictures: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3676986767,
        1766,
        16391,
        [171, 166, 175, 135, 125, 82, 110, 166],
    );
pub const FOLDERTYPEID_Communications: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2437373925,
        22635,
        20154,
        [141, 117, 209, 116, 52, 184, 205, 246],
    );
pub const FOLDERTYPEID_CompressedFolder: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2149662338,
        48381,
        19535,
        [136, 23, 187, 39, 96, 18, 103, 169],
    );
pub const FOLDERTYPEID_Contacts: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3727388908,
    39927,
    19091,
    [189, 61, 36, 63, 120, 129, 212, 146],
);
pub const FOLDERTYPEID_ControlPanelCategory: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3729720928,
        64016,
        19343,
        [164, 148, 6, 139, 32, 178, 35, 7],
    );
pub const FOLDERTYPEID_ControlPanelClassic: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        204969203,
        46405,
        17322,
        [163, 41, 195, 116, 48, 197, 141, 42],
    );
pub const FOLDERTYPEID_Documents: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2101991206,
    15393,
    20229,
    [153, 170, 253, 194, 201, 71, 70, 86],
);
pub const FOLDERTYPEID_Downloads: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2287605870,
    42048,
    19162,
    [129, 43, 219, 135, 27, 148, 34, 89],
);
pub const FOLDERTYPEID_Games: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3062477008,
    30419,
    19643,
    [135, 247, 88, 93, 14, 12, 224, 112],
);
pub const FOLDERTYPEID_Generic: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1548691637,
    63593,
    20100,
    [142, 96, 241, 29, 185, 124, 92, 199],
);
pub const FOLDERTYPEID_GenericLibrary: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1598991258,
        26675,
        20321,
        [137, 157, 49, 207, 70, 151, 157, 73],
    );
pub const FOLDERTYPEID_GenericSearchResults: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2145262110,
        35633,
        18853,
        [147, 184, 107, 225, 76, 250, 73, 67],
    );
pub const FOLDERTYPEID_Invalid: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1468037272,
    35919,
    17506,
    [187, 99, 113, 4, 35, 128, 177, 9],
);
pub const FOLDERTYPEID_Music: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2497109452,
    19048,
    16757,
    [163, 116, 189, 88, 74, 81, 11, 120],
);
pub const FOLDERTYPEID_NetworkExplorer: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        634135595,
        39548,
        20305,
        [128, 224, 122, 41, 40, 254, 190, 66],
    );
pub const FOLDERTYPEID_OpenSearch: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2410649129,
    6528,
    18175,
    [128, 35, 157, 206, 171, 156, 62, 227],
);
pub const FOLDERTYPEID_OtherUsers: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3006790912,
    40405,
    17973,
    [166, 212, 218, 51, 253, 16, 43, 122],
);
pub const FOLDERTYPEID_Pictures: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3010006616,
    59745,
    16955,
    [182, 135, 56, 110, 191, 216, 50, 57],
);
pub const FOLDERTYPEID_Printers: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    746307270,
    51268,
    18954,
    [145, 250, 206, 246, 245, 156, 253, 161],
);
pub const FOLDERTYPEID_PublishedItems: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2133810070,
        65396,
        16858,
        [175, 216, 28, 120, 165, 243, 174, 162],
    );
pub const FOLDERTYPEID_RecordedTV: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1431806607,
    23974,
    20355,
    [136, 9, 194, 201, 138, 17, 166, 250],
);
pub const FOLDERTYPEID_RecycleBin: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3604602884,
    52615,
    17451,
    [157, 87, 94, 10, 235, 79, 111, 114],
);
pub const FOLDERTYPEID_SavedGames: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3493212935,
    10443,
    16646,
    [159, 35, 41, 86, 227, 229, 224, 231],
);
pub const FOLDERTYPEID_SearchConnector: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2552702446,
        28487,
        18334,
        [180, 71, 129, 43, 250, 125, 46, 143],
    );
pub const FOLDERTYPEID_SearchHome: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2202896964,
    2420,
    20182,
    [134, 110, 242, 3, 216, 11, 56, 16],
);
pub const FOLDERTYPEID_Searches: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    185311971,
    16479,
    16734,
    [166, 238, 202, 214, 37, 32, 120, 83],
);
pub const FOLDERTYPEID_SoftwareExplorer: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3597941019,
        21209,
        19975,
        [131, 78, 103, 201, 134, 16, 243, 157],
    );
pub const FOLDERTYPEID_StartMenu: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4018648267,
    62158,
    18309,
    [134, 88, 76, 166, 198, 62, 56, 198],
);
pub const FOLDERTYPEID_StorageProviderDocuments: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3714170214,
        28904,
        18653,
        [150, 85, 101, 197, 225, 170, 194, 209],
    );
pub const FOLDERTYPEID_StorageProviderGeneric: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1325525957,
        9093,
        16882,
        [162, 142, 44, 92, 145, 251, 86, 224],
    );
pub const FOLDERTYPEID_StorageProviderMusic: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1731120510,
        44804,
        17305,
        [135, 92, 2, 144, 132, 91, 98, 71],
    );
pub const FOLDERTYPEID_StorageProviderPictures: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1909867177,
        62129,
        17101,
        [173, 146, 235, 147, 0, 199, 204, 10],
    );
pub const FOLDERTYPEID_StorageProviderVideos: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1361661345,
        55217,
        18523,
        [158, 154, 23, 207, 254, 51, 225, 135],
    );
pub const FOLDERTYPEID_UserFiles: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3440363163,
    29154,
    18149,
    [150, 144, 91, 205, 159, 87, 170, 179],
);
pub const FOLDERTYPEID_UsersLibraries: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3302592265,
        24868,
        20448,
        [153, 66, 130, 100, 22, 8, 45, 169],
    );
pub const FOLDERTYPEID_Videos: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1604936711,
    32375,
    18492,
    [172, 147, 105, 29, 5, 133, 13, 232],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FOLDERVIEWMODE(pub i32);
pub const FVM_AUTO: FOLDERVIEWMODE = FOLDERVIEWMODE(-1i32);
pub const FVM_FIRST: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
pub const FVM_ICON: FOLDERVIEWMODE = FOLDERVIEWMODE(1i32);
pub const FVM_SMALLICON: FOLDERVIEWMODE = FOLDERVIEWMODE(2i32);
pub const FVM_LIST: FOLDERVIEWMODE = FOLDERVIEWMODE(3i32);
pub const FVM_DETAILS: FOLDERVIEWMODE = FOLDERVIEWMODE(4i32);
pub const FVM_THUMBNAIL: FOLDERVIEWMODE = FOLDERVIEWMODE(5i32);
pub const FVM_TILE: FOLDERVIEWMODE = FOLDERVIEWMODE(6i32);
pub const FVM_THUMBSTRIP: FOLDERVIEWMODE = FOLDERVIEWMODE(7i32);
pub const FVM_CONTENT: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
pub const FVM_LAST: FOLDERVIEWMODE = FOLDERVIEWMODE(8i32);
impl ::std::convert::From<i32> for FOLDERVIEWMODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FOLDERVIEWMODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FOLDERVIEWOPTIONS(pub i32);
pub const FVO_DEFAULT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(0i32);
pub const FVO_VISTALAYOUT: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(1i32);
pub const FVO_CUSTOMPOSITION: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(2i32);
pub const FVO_CUSTOMORDERING: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(4i32);
pub const FVO_SUPPORTHYPERLINKS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(8i32);
pub const FVO_NOANIMATIONS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(16i32);
pub const FVO_NOSCROLLTIPS: FOLDERVIEWOPTIONS = FOLDERVIEWOPTIONS(32i32);
impl ::std::convert::From<i32> for FOLDERVIEWOPTIONS {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FOLDERVIEWOPTIONS {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FOLDER_ENUM_MODE(pub i32);
pub const FEM_VIEWRESULT: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(0i32);
pub const FEM_NAVIGATION: FOLDER_ENUM_MODE = FOLDER_ENUM_MODE(1i32);
impl ::std::convert::From<i32> for FOLDER_ENUM_MODE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FOLDER_ENUM_MODE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FO_COPY: u32 = 2u32;
pub const FO_DELETE: u32 = 3u32;
pub const FO_MOVE: u32 = 1u32;
pub const FO_RENAME: u32 = 4u32;
pub const FSCopyHandler: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3516348426,
    2681,
    19912,
    [160, 51, 237, 136, 44, 47, 161, 75],
);
pub const FVSIF_CANVIEWIT: u32 = 1073741824u32;
pub const FVSIF_NEWFAILED: u32 = 134217728u32;
pub const FVSIF_NEWFILE: u32 = 2147483648u32;
pub const FVSIF_PINNED: u32 = 2u32;
pub const FVSIF_RECT: u32 = 1u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FVTEXTTYPE(pub i32);
pub const FVST_EMPTYTEXT: FVTEXTTYPE = FVTEXTTYPE(0i32);
impl ::std::convert::From<i32> for FVTEXTTYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FVTEXTTYPE {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FileOpenDialog: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3692845724,
    59530,
    19934,
    [165, 161, 96, 248, 42, 32, 174, 247],
);
pub const FileOperation: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    986731893,
    34903,
    18512,
    [146, 119, 17, 184, 91, 219, 142, 9],
);
pub const FileSaveDialog: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3233080051,
    47649,
    18291,
    [141, 186, 51, 94, 201, 70, 235, 139],
);
pub const FileSearchBand: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3303944691,
    18280,
    4562,
    [190, 92, 0, 160, 201, 168, 61, 161],
);
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindExecutableA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    lpfile: Param0,
    lpdirectory: Param1,
    lpresult: super::super::Foundation::PSTR,
) -> super::super::Foundation::HINSTANCE {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn FindExecutableA(
                lpfile: super::super::Foundation::PSTR,
                lpdirectory: super::super::Foundation::PSTR,
                lpresult: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::HINSTANCE;
        }
        ::std::mem::transmute(FindExecutableA(
            lpfile.into_param().abi(),
            lpdirectory.into_param().abi(),
            ::std::mem::transmute(lpresult),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindExecutableW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    lpfile: Param0,
    lpdirectory: Param1,
    lpresult: super::super::Foundation::PWSTR,
) -> super::super::Foundation::HINSTANCE {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn FindExecutableW(
                lpfile: super::super::Foundation::PWSTR,
                lpdirectory: super::super::Foundation::PWSTR,
                lpresult: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::HINSTANCE;
        }
        ::std::mem::transmute(FindExecutableW(
            lpfile.into_param().abi(),
            lpdirectory.into_param().abi(),
            ::std::mem::transmute(lpresult),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct Folder(::windows::runtime::IUnknown);
impl Folder {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    pub unsafe fn ParentFolder(&self) -> ::windows::runtime::Result<Folder> {
        let mut result__: <Folder as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<Folder>(result__)
    }
    pub unsafe fn Items(&self) -> ::windows::runtime::Result<FolderItems> {
        let mut result__: <FolderItems as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItems>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ParseName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bname: Param0,
    ) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            bname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn NewFolder<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        bname: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bname.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn MoveHere<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CopyHere<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetDetailsOf<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        icolumn: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            ::std::mem::transmute(icolumn),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for Folder {
    type Vtable = Folder_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3150700128,
        50175,
        4558,
        [131, 80, 68, 69, 83, 84, 0, 0],
    );
}
impl ::std::convert::From<Folder> for ::windows::runtime::IUnknown {
    fn from(value: Folder) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&Folder> for ::windows::runtime::IUnknown {
    fn from(value: &Folder) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for Folder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &Folder {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<Folder> for super::super::System::OleAutomation::IDispatch {
    fn from(value: Folder) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&Folder> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &Folder) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for Folder
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &Folder
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct Folder_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsf: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        icolumn: i32,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct Folder2(::windows::runtime::IUnknown);
impl Folder2 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    pub unsafe fn ParentFolder(&self) -> ::windows::runtime::Result<Folder> {
        let mut result__: <Folder as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<Folder>(result__)
    }
    pub unsafe fn Items(&self) -> ::windows::runtime::Result<FolderItems> {
        let mut result__: <FolderItems as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItems>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ParseName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bname: Param0,
    ) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            bname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn NewFolder<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        bname: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bname.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn MoveHere<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CopyHere<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetDetailsOf<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        icolumn: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            ::std::mem::transmute(icolumn),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Self_(&self) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    pub unsafe fn OfflineStatus(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn Synchronize(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for Folder2 {
    type Vtable = Folder2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4040349935,
        14480,
        4562,
        [191, 139, 0, 192, 79, 185, 54, 97],
    );
}
impl ::std::convert::From<Folder2> for ::windows::runtime::IUnknown {
    fn from(value: Folder2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&Folder2> for ::windows::runtime::IUnknown {
    fn from(value: &Folder2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for Folder2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &Folder2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<Folder2> for Folder {
    fn from(value: Folder2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&Folder2> for Folder {
    fn from(value: &Folder2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, Folder> for Folder2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, Folder> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<Folder>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, Folder> for &Folder2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, Folder> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<Folder>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<Folder2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: Folder2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&Folder2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &Folder2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for Folder2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &Folder2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct Folder2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsf: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        icolumn: i32,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppfi: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pul: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbhavetoshowwebviewbarricade: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct Folder3(::windows::runtime::IUnknown);
impl Folder3 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Title(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    pub unsafe fn ParentFolder(&self) -> ::windows::runtime::Result<Folder> {
        let mut result__: <Folder as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<Folder>(result__)
    }
    pub unsafe fn Items(&self) -> ::windows::runtime::Result<FolderItems> {
        let mut result__: <FolderItems as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItems>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ParseName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bname: Param0,
    ) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            bname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn NewFolder<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        bname: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bname.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn MoveHere<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CopyHere<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        voptions: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            voptions.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetDetailsOf<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vitem: Param0,
        icolumn: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            vitem.into_param().abi(),
            ::std::mem::transmute(icolumn),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Self_(&self) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    pub unsafe fn OfflineStatus(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn Synchronize(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn HaveToShowWebViewBarricade(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn DismissedWebViewBarricade(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ShowWebViewBarricade(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn SetShowWebViewBarricade(
        &self,
        bshowwebviewbarricade: i16,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bshowwebviewbarricade),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for Folder3 {
    type Vtable = Folder3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2813222756,
        50391,
        19839,
        [147, 7, 77, 36, 238, 84, 184, 65],
    );
}
impl ::std::convert::From<Folder3> for ::windows::runtime::IUnknown {
    fn from(value: Folder3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&Folder3> for ::windows::runtime::IUnknown {
    fn from(value: &Folder3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for Folder3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &Folder3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<Folder3> for Folder2 {
    fn from(value: Folder3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&Folder3> for Folder2 {
    fn from(value: &Folder3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, Folder2> for Folder3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, Folder2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<Folder2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, Folder2> for &Folder3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, Folder2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<Folder2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<Folder3> for Folder {
    fn from(value: Folder3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&Folder3> for Folder {
    fn from(value: &Folder3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, Folder> for Folder3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, Folder> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<Folder>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, Folder> for &Folder3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, Folder> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<Folder>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<Folder3> for super::super::System::OleAutomation::IDispatch {
    fn from(value: Folder3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&Folder3> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &Folder3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for Folder3
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &Folder3
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct Folder3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsf: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        voptions: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vitem: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        icolumn: i32,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppfi: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pul: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbhavetoshowwebviewbarricade: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbshowwebviewbarricade: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bshowwebviewbarricade: i16,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct FolderItem(::windows::runtime::IUnknown);
impl FolderItem {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bs: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            bs.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Path(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetLink(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetFolder(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    pub unsafe fn IsLink(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn IsFolder(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn IsFileSystem(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn IsBrowsable(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn ModifyDate(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dt),
        )
        .ok()
    }
    pub unsafe fn Size(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Type(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Verbs(&self) -> ::windows::runtime::Result<FolderItemVerbs> {
        let mut result__: <FolderItemVerbs as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItemVerbs>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn InvokeVerb<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vverb: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            vverb.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for FolderItem {
    type Vtable = FolderItem_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4207094912,
        52196,
        4558,
        [131, 80, 68, 69, 83, 84, 0, 0],
    );
}
impl ::std::convert::From<FolderItem> for ::windows::runtime::IUnknown {
    fn from(value: FolderItem) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItem> for ::windows::runtime::IUnknown {
    fn from(value: &FolderItem) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for FolderItem {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &FolderItem {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<FolderItem> for super::super::System::OleAutomation::IDispatch {
    fn from(value: FolderItem) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&FolderItem> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &FolderItem) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for FolderItem
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &FolderItem
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bs: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdt: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dt: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pul: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppfic: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vverb: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct FolderItem2(::windows::runtime::IUnknown);
impl FolderItem2 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bs: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            bs.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Path(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetLink(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetFolder(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    pub unsafe fn IsLink(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn IsFolder(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn IsFileSystem(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn IsBrowsable(&self) -> ::windows::runtime::Result<i16> {
        let mut result__: <i16 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i16>(result__)
    }
    pub unsafe fn ModifyDate(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn SetModifyDate(&self, dt: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dt),
        )
        .ok()
    }
    pub unsafe fn Size(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Type(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Verbs(&self) -> ::windows::runtime::Result<FolderItemVerbs> {
        let mut result__: <FolderItemVerbs as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItemVerbs>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn InvokeVerb<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vverb: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            vverb.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn InvokeVerbEx<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vverb: Param0,
        vargs: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            vverb.into_param().abi(),
            vargs.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn ExtendedProperty<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrpropname: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            bstrpropname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for FolderItem2 {
    type Vtable = FolderItem2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3989313450,
        37560,
        4561,
        [176, 117, 0, 192, 79, 195, 58, 165],
    );
}
impl ::std::convert::From<FolderItem2> for ::windows::runtime::IUnknown {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItem2> for ::windows::runtime::IUnknown {
    fn from(value: &FolderItem2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for FolderItem2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &FolderItem2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<FolderItem2> for FolderItem {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItem2> for FolderItem {
    fn from(value: &FolderItem2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItem> for FolderItem2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItem> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItem>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItem> for &FolderItem2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItem> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItem>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<FolderItem2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: FolderItem2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&FolderItem2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &FolderItem2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for FolderItem2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &FolderItem2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct FolderItem2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bs: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pb: *mut i16,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdt: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dt: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pul: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppfic: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vverb: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vverb: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        vargs: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrpropname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        pvret: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct FolderItemVerb(::windows::runtime::IUnknown);
impl FolderItemVerb {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn DoIt(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for FolderItemVerb {
    type Vtable = FolderItemVerb_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        149700096,
        20656,
        4559,
        [150, 12, 0, 128, 199, 244, 238, 133],
    );
}
impl ::std::convert::From<FolderItemVerb> for ::windows::runtime::IUnknown {
    fn from(value: FolderItemVerb) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItemVerb> for ::windows::runtime::IUnknown {
    fn from(value: &FolderItemVerb) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for FolderItemVerb {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &FolderItemVerb {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<FolderItemVerb> for super::super::System::OleAutomation::IDispatch {
    fn from(value: FolderItemVerb) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&FolderItemVerb> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &FolderItemVerb) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for FolderItemVerb
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &FolderItemVerb
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerb_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbs: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct FolderItemVerbs(::windows::runtime::IUnknown);
impl FolderItemVerbs {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Item<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        index: Param0,
    ) -> ::windows::runtime::Result<FolderItemVerb> {
        let mut result__: <FolderItemVerb as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            index.into_param().abi(),
            &mut result__,
        )
        .from_abi::<FolderItemVerb>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for FolderItemVerbs {
    type Vtable = FolderItemVerbs_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        528700096,
        20656,
        4559,
        [150, 12, 0, 128, 199, 244, 238, 133],
    );
}
impl ::std::convert::From<FolderItemVerbs> for ::windows::runtime::IUnknown {
    fn from(value: FolderItemVerbs) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItemVerbs> for ::windows::runtime::IUnknown {
    fn from(value: &FolderItemVerbs) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for FolderItemVerbs {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &FolderItemVerbs {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<FolderItemVerbs> for super::super::System::OleAutomation::IDispatch {
    fn from(value: FolderItemVerbs) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&FolderItemVerbs> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &FolderItemVerbs) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for FolderItemVerbs
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &FolderItemVerbs
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct FolderItemVerbs_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plcount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        index: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct FolderItems(::windows::runtime::IUnknown);
impl FolderItems {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Item<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        index: Param0,
    ) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            index.into_param().abi(),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for FolderItems {
    type Vtable = FolderItems_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1950427616,
        52197,
        4558,
        [131, 80, 68, 69, 83, 84, 0, 0],
    );
}
impl ::std::convert::From<FolderItems> for ::windows::runtime::IUnknown {
    fn from(value: FolderItems) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItems> for ::windows::runtime::IUnknown {
    fn from(value: &FolderItems) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for FolderItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &FolderItems {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<FolderItems> for super::super::System::OleAutomation::IDispatch {
    fn from(value: FolderItems) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&FolderItems> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &FolderItems) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for FolderItems
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &FolderItems
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plcount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        index: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct FolderItems2(::windows::runtime::IUnknown);
impl FolderItems2 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Item<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        index: Param0,
    ) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            index.into_param().abi(),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn InvokeVerbEx<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vverb: Param0,
        vargs: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            vverb.into_param().abi(),
            vargs.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for FolderItems2 {
    type Vtable = FolderItems2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3377400528,
        62307,
        4562,
        [163, 39, 0, 192, 79, 142, 236, 127],
    );
}
impl ::std::convert::From<FolderItems2> for ::windows::runtime::IUnknown {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItems2> for ::windows::runtime::IUnknown {
    fn from(value: &FolderItems2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for FolderItems2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &FolderItems2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<FolderItems2> for FolderItems {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItems2> for FolderItems {
    fn from(value: &FolderItems2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItems> for FolderItems2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItems> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItems>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItems> for &FolderItems2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItems> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItems>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<FolderItems2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: FolderItems2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&FolderItems2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &FolderItems2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for FolderItems2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &FolderItems2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plcount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        index: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vverb: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        vargs: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct FolderItems3(::windows::runtime::IUnknown);
impl FolderItems3 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Application(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn Parent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Item<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        index: Param0,
    ) -> ::windows::runtime::Result<FolderItem> {
        let mut result__: <FolderItem as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            index.into_param().abi(),
            &mut result__,
        )
        .from_abi::<FolderItem>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn InvokeVerbEx<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        vverb: Param0,
        vargs: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            vverb.into_param().abi(),
            vargs.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Filter<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        grfflags: i32,
        bstrfilespec: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(grfflags),
            bstrfilespec.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Verbs(&self) -> ::windows::runtime::Result<FolderItemVerbs> {
        let mut result__: <FolderItemVerbs as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<FolderItemVerbs>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for FolderItems3 {
    type Vtable = FolderItems3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3936862985,
        48108,
        18901,
        [130, 29, 100, 217, 102, 203, 102, 127],
    );
}
impl ::std::convert::From<FolderItems3> for ::windows::runtime::IUnknown {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItems3> for ::windows::runtime::IUnknown {
    fn from(value: &FolderItems3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for FolderItems3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &FolderItems3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<FolderItems3> for FolderItems2 {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItems3> for FolderItems2 {
    fn from(value: &FolderItems3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItems2> for FolderItems3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItems2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItems2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItems2> for &FolderItems3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItems2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItems2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<FolderItems3> for FolderItems {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&FolderItems3> for FolderItems {
    fn from(value: &FolderItems3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItems> for FolderItems3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItems> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItems>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, FolderItems> for &FolderItems3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, FolderItems> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<FolderItems>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<FolderItems3> for super::super::System::OleAutomation::IDispatch {
    fn from(value: FolderItems3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&FolderItems3> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &FolderItems3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for FolderItems3
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &FolderItems3
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct FolderItems3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        plcount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        index: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        ppid: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vverb: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        vargs: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        grfflags: i32,
        bstrfilespec: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppfic: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
pub const FolderViewHost: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    548522787,
    26984,
    20153,
    [183, 212, 166, 109, 0, 208, 124, 238],
);
pub const FrameworkInputPane: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3574729379,
    18106,
    17605,
    [130, 45, 202, 128, 146, 193, 252, 114],
);
pub const FreeSpaceCategorizer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3042998163,
    9388,
    17607,
    [130, 226, 131, 23, 38, 170, 108, 183],
);
pub const GADOF_DIRTY: u32 = 1u32;
pub const GCS_HELPTEXT: u32 = 5u32;
pub const GCS_HELPTEXTA: u32 = 1u32;
pub const GCS_HELPTEXTW: u32 = 5u32;
pub const GCS_UNICODE: u32 = 4u32;
pub const GCS_VALIDATE: u32 = 6u32;
pub const GCS_VALIDATEA: u32 = 2u32;
pub const GCS_VALIDATEW: u32 = 6u32;
pub const GCS_VERB: u32 = 4u32;
pub const GCS_VERBA: u32 = 0u32;
pub const GCS_VERBICONW: u32 = 20u32;
pub const GCS_VERBW: u32 = 4u32;
pub const GCT_INVALID: u32 = 0u32;
pub const GCT_LFNCHAR: u32 = 1u32;
pub const GCT_SEPARATOR: u32 = 8u32;
pub const GCT_SHORTCHAR: u32 = 2u32;
pub const GCT_WILD: u32 = 4u32;
pub const GETPROPS_NONE: u32 = 0u32;
pub const GIL_ASYNC: u32 = 32u32;
pub const GIL_CHECKSHIELD: u32 = 512u32;
pub const GIL_DEFAULTICON: u32 = 64u32;
pub const GIL_DONTCACHE: u32 = 16u32;
pub const GIL_FORCENOSHIELD: u32 = 1024u32;
pub const GIL_FORSHELL: u32 = 2u32;
pub const GIL_FORSHORTCUT: u32 = 128u32;
pub const GIL_NOTFILENAME: u32 = 8u32;
pub const GIL_OPENICON: u32 = 1u32;
pub const GIL_PERCLASS: u32 = 4u32;
pub const GIL_PERINSTANCE: u32 = 2u32;
pub const GIL_SHIELD: u32 = 512u32;
pub const GIL_SIMULATEDOC: u32 = 1u32;
pub const GPFIDL_ALTNAME: i32 = 1i32;
pub const GPFIDL_DEFAULT: i32 = 0i32;
pub const GPFIDL_UNCPRINTER: i32 = 2i32;
pub const GenericCredentialProvider: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        634108310,
        37613,
        17790,
        [178, 140, 71, 116, 8, 75, 213, 98],
    );
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetAcceptLanguagesA(
    pszlanguages: super::super::Foundation::PSTR,
    pcchlanguages: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn GetAcceptLanguagesA(
                pszlanguages: super::super::Foundation::PSTR,
                pcchlanguages: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        GetAcceptLanguagesA(
            ::std::mem::transmute(pszlanguages),
            ::std::mem::transmute(pcchlanguages),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetAcceptLanguagesW(
    pszlanguages: super::super::Foundation::PWSTR,
    pcchlanguages: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn GetAcceptLanguagesW(
                pszlanguages: super::super::Foundation::PWSTR,
                pcchlanguages: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        GetAcceptLanguagesW(
            ::std::mem::transmute(pszlanguages),
            ::std::mem::transmute(pcchlanguages),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetAllUsersProfileDirectoryA(
    lpprofiledir: super::super::Foundation::PSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetAllUsersProfileDirectoryA(
                lpprofiledir: super::super::Foundation::PSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetAllUsersProfileDirectoryA(
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetAllUsersProfileDirectoryW(
    lpprofiledir: super::super::Foundation::PWSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetAllUsersProfileDirectoryW(
                lpprofiledir: super::super::Foundation::PWSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetAllUsersProfileDirectoryW(
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCurrentProcessExplicitAppUserModelID(
) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn GetCurrentProcessExplicitAppUserModelID(
                appid: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        GetCurrentProcessExplicitAppUserModelID(&mut result__)
            .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDefaultUserProfileDirectoryA(
    lpprofiledir: super::super::Foundation::PSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetDefaultUserProfileDirectoryA(
                lpprofiledir: super::super::Foundation::PSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetDefaultUserProfileDirectoryA(
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDefaultUserProfileDirectoryW(
    lpprofiledir: super::super::Foundation::PWSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetDefaultUserProfileDirectoryW(
                lpprofiledir: super::super::Foundation::PWSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetDefaultUserProfileDirectoryW(
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "api-ms-win-shcore-scaling-l1-1-2")]
        extern "system" {
            fn GetDpiForShellUIComponent(param0: SHELL_UI_COMPONENT) -> u32;
        }
        ::std::mem::transmute(GetDpiForShellUIComponent(::std::mem::transmute(param0)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetFileNameFromBrowse<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param5: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param6: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hwnd: Param0,
    pszfilepath: Param1,
    cchfilepath: u32,
    pszworkingdir: Param3,
    pszdefext: Param4,
    pszfilters: Param5,
    psztitle: Param6,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "shell32")]
        extern "system" {
            fn GetFileNameFromBrowse(
                hwnd: super::super::Foundation::HWND,
                pszfilepath: super::super::Foundation::PWSTR,
                cchfilepath: u32,
                pszworkingdir: super::super::Foundation::PWSTR,
                pszdefext: super::super::Foundation::PWSTR,
                pszfilters: super::super::Foundation::PWSTR,
                psztitle: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetFileNameFromBrowse(
            hwnd.into_param().abi(),
            pszfilepath.into_param().abi(),
            ::std::mem::transmute(cchfilepath),
            pszworkingdir.into_param().abi(),
            pszdefext.into_param().abi(),
            pszfilters.into_param().abi(),
            psztitle.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
pub unsafe fn GetMenuContextHelpId<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HMENU>,
>(
    param0: Param0,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "user32")]
        extern "system" {
            fn GetMenuContextHelpId(param0: super::WindowsAndMessaging::HMENU) -> u32;
        }
        ::std::mem::transmute(GetMenuContextHelpId(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_UI_WindowsAndMessaging")]
pub unsafe fn GetMenuPosFromID<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HMENU>,
>(
    hmenu: Param0,
    id: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn GetMenuPosFromID(hmenu: super::WindowsAndMessaging::HMENU, id: u32) -> i32;
        }
        ::std::mem::transmute(GetMenuPosFromID(
            hmenu.into_param().abi(),
            ::std::mem::transmute(id),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetProfileType(dwflags: *mut u32) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetProfileType(::std::mem::transmute(dwflags)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetProfilesDirectoryA(
    lpprofiledir: super::super::Foundation::PSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetProfilesDirectoryA(
                lpprofiledir: super::super::Foundation::PSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetProfilesDirectoryA(
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetProfilesDirectoryW(
    lpprofiledir: super::super::Foundation::PWSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetProfilesDirectoryW(
                lpprofiledir: super::super::Foundation::PWSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetProfilesDirectoryW(
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> DEVICE_SCALE_FACTOR {
    #[cfg(windows)]
    {
        #[link(name = "api-ms-win-shcore-scaling-l1-1-0")]
        extern "system" {
            fn GetScaleFactorForDevice(devicetype: DISPLAY_DEVICE_TYPE) -> DEVICE_SCALE_FACTOR;
        }
        ::std::mem::transmute(GetScaleFactorForDevice(::std::mem::transmute(devicetype)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn GetScaleFactorForMonitor<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>,
>(
    hmon: Param0,
) -> ::windows::runtime::Result<DEVICE_SCALE_FACTOR> {
    #[cfg(windows)]
    {
        #[link(name = "api-ms-win-shcore-scaling-l1-1-1")]
        extern "system" {
            fn GetScaleFactorForMonitor(
                hmon: super::super::Graphics::Gdi::HMONITOR,
                pscale: *mut DEVICE_SCALE_FACTOR,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <DEVICE_SCALE_FACTOR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        GetScaleFactorForMonitor(hmon.into_param().abi(), &mut result__)
            .from_abi::<DEVICE_SCALE_FACTOR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetUserProfileDirectoryA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    htoken: Param0,
    lpprofiledir: super::super::Foundation::PSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetUserProfileDirectoryA(
                htoken: super::super::Foundation::HANDLE,
                lpprofiledir: super::super::Foundation::PSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetUserProfileDirectoryA(
            htoken.into_param().abi(),
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetUserProfileDirectoryW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    htoken: Param0,
    lpprofiledir: super::super::Foundation::PWSTR,
    lpcchsize: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "userenv")]
        extern "system" {
            fn GetUserProfileDirectoryW(
                htoken: super::super::Foundation::HANDLE,
                lpprofiledir: super::super::Foundation::PWSTR,
                lpcchsize: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetUserProfileDirectoryW(
            htoken.into_param().abi(),
            ::std::mem::transmute(lpprofiledir),
            ::std::mem::transmute(lpcchsize),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetWindowContextHelpId<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    param0: Param0,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "user32")]
        extern "system" {
            fn GetWindowContextHelpId(param0: super::super::Foundation::HWND) -> u32;
        }
        ::std::mem::transmute(GetWindowContextHelpId(param0.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetWindowSubclass<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hwnd: Param0,
    pfnsubclass: ::std::option::Option<SUBCLASSPROC>,
    uidsubclass: usize,
    pdwrefdata: *mut usize,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "comctl32")]
        extern "system" {
            fn GetWindowSubclass(
                hwnd: super::super::Foundation::HWND,
                pfnsubclass: ::windows::runtime::RawPtr,
                uidsubclass: usize,
                pdwrefdata: *mut usize,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetWindowSubclass(
            hwnd.into_param().abi(),
            ::std::mem::transmute(pfnsubclass),
            ::std::mem::transmute(uidsubclass),
            ::std::mem::transmute(pdwrefdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HDROP(pub isize);
impl ::std::default::Default for HDROP {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HDROP {}
unsafe impl ::windows::runtime::Abi for HDROP {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct HELPINFO {
    pub cbSize: u32,
    pub iContextType: i32,
    pub iCtrlId: i32,
    pub hItemHandle: super::super::Foundation::HANDLE,
    pub dwContextId: usize,
    pub MousePos: super::super::Foundation::POINT,
}
#[cfg(feature = "Win32_Foundation")]
impl HELPINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for HELPINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for HELPINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HELPINFO")
            .field("cbSize", &self.cbSize)
            .field("iContextType", &self.iContextType)
            .field("iCtrlId", &self.iCtrlId)
            .field("hItemHandle", &self.hItemHandle)
            .field("dwContextId", &self.dwContextId)
            .field("MousePos", &self.MousePos)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for HELPINFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.iContextType == other.iContextType
            && self.iCtrlId == other.iCtrlId
            && self.hItemHandle == other.hItemHandle
            && self.dwContextId == other.dwContextId
            && self.MousePos == other.MousePos
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for HELPINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for HELPINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_System_SystemServices")]
pub struct HELPWININFOA {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [super::super::System::SystemServices::CHAR; 2],
}
#[cfg(feature = "Win32_System_SystemServices")]
impl HELPWININFOA {}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::default::Default for HELPWININFOA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::fmt::Debug for HELPWININFOA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HELPWININFOA")
            .field("wStructSize", &self.wStructSize)
            .field("x", &self.x)
            .field("y", &self.y)
            .field("dx", &self.dx)
            .field("dy", &self.dy)
            .field("wMax", &self.wMax)
            .field("rgchMember", &self.rgchMember)
            .finish()
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::PartialEq for HELPWININFOA {
    fn eq(&self, other: &Self) -> bool {
        self.wStructSize == other.wStructSize
            && self.x == other.x
            && self.y == other.y
            && self.dx == other.dx
            && self.dy == other.dy
            && self.wMax == other.wMax
            && self.rgchMember == other.rgchMember
    }
}
#[cfg(feature = "Win32_System_SystemServices")]
impl ::std::cmp::Eq for HELPWININFOA {}
#[cfg(feature = "Win32_System_SystemServices")]
unsafe impl ::windows::runtime::Abi for HELPWININFOA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct HELPWININFOW {
    pub wStructSize: i32,
    pub x: i32,
    pub y: i32,
    pub dx: i32,
    pub dy: i32,
    pub wMax: i32,
    pub rgchMember: [u16; 2],
}
impl HELPWININFOW {}
impl ::std::default::Default for HELPWININFOW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for HELPWININFOW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HELPWININFOW")
            .field("wStructSize", &self.wStructSize)
            .field("x", &self.x)
            .field("y", &self.y)
            .field("dx", &self.dx)
            .field("dy", &self.dy)
            .field("wMax", &self.wMax)
            .field("rgchMember", &self.rgchMember)
            .finish()
    }
}
impl ::std::cmp::PartialEq for HELPWININFOW {
    fn eq(&self, other: &Self) -> bool {
        self.wStructSize == other.wStructSize
            && self.x == other.x
            && self.y == other.y
            && self.dx == other.dx
            && self.dy == other.dy
            && self.wMax == other.wMax
            && self.rgchMember == other.rgchMember
    }
}
impl ::std::cmp::Eq for HELPWININFOW {}
unsafe impl ::windows::runtime::Abi for HELPWININFOW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLBWIF_FLAGS(pub u32);
pub const HLBWIF_HASFRAMEWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(1u32);
pub const HLBWIF_HASDOCWNDINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(2u32);
pub const HLBWIF_FRAMEWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(4u32);
pub const HLBWIF_DOCWNDMAXIMIZED: HLBWIF_FLAGS = HLBWIF_FLAGS(8u32);
pub const HLBWIF_HASWEBTOOLBARINFO: HLBWIF_FLAGS = HLBWIF_FLAGS(16u32);
pub const HLBWIF_WEBTOOLBARHIDDEN: HLBWIF_FLAGS = HLBWIF_FLAGS(32u32);
impl ::std::convert::From<u32> for HLBWIF_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLBWIF_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for HLBWIF_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for HLBWIF_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for HLBWIF_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for HLBWIF_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for HLBWIF_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct HLBWINFO {
    pub cbSize: u32,
    pub grfHLBWIF: u32,
    pub rcFramePos: super::super::Foundation::RECT,
    pub rcDocPos: super::super::Foundation::RECT,
    pub hltbinfo: HLTBINFO,
}
#[cfg(feature = "Win32_Foundation")]
impl HLBWINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for HLBWINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for HLBWINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HLBWINFO")
            .field("cbSize", &self.cbSize)
            .field("grfHLBWIF", &self.grfHLBWIF)
            .field("rcFramePos", &self.rcFramePos)
            .field("rcDocPos", &self.rcDocPos)
            .field("hltbinfo", &self.hltbinfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for HLBWINFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.grfHLBWIF == other.grfHLBWIF
            && self.rcFramePos == other.rcFramePos
            && self.rcDocPos == other.rcDocPos
            && self.hltbinfo == other.hltbinfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for HLBWINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for HLBWINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLFNAMEF(pub u32);
pub const HLFNAMEF_DEFAULT: HLFNAMEF = HLFNAMEF(0u32);
pub const HLFNAMEF_TRYCACHE: HLFNAMEF = HLFNAMEF(1u32);
pub const HLFNAMEF_TRYPRETTYTARGET: HLFNAMEF = HLFNAMEF(2u32);
pub const HLFNAMEF_TRYFULLTARGET: HLFNAMEF = HLFNAMEF(4u32);
pub const HLFNAMEF_TRYWIN95SHORTCUT: HLFNAMEF = HLFNAMEF(8u32);
impl ::std::convert::From<u32> for HLFNAMEF {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLFNAMEF {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for HLFNAMEF {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for HLFNAMEF {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for HLFNAMEF {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for HLFNAMEF {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for HLFNAMEF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLID_INFO(pub u32);
pub const HLID_INVALID: HLID_INFO = HLID_INFO(0u32);
pub const HLID_PREVIOUS: HLID_INFO = HLID_INFO(4294967295u32);
pub const HLID_NEXT: HLID_INFO = HLID_INFO(4294967294u32);
pub const HLID_CURRENT: HLID_INFO = HLID_INFO(4294967293u32);
pub const HLID_STACKBOTTOM: HLID_INFO = HLID_INFO(4294967292u32);
pub const HLID_STACKTOP: HLID_INFO = HLID_INFO(4294967291u32);
impl ::std::convert::From<u32> for HLID_INFO {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLID_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for HLID_INFO {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for HLID_INFO {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for HLID_INFO {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for HLID_INFO {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for HLID_INFO {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLINKGETREF(pub i32);
pub const HLINKGETREF_DEFAULT: HLINKGETREF = HLINKGETREF(0i32);
pub const HLINKGETREF_ABSOLUTE: HLINKGETREF = HLINKGETREF(1i32);
pub const HLINKGETREF_RELATIVE: HLINKGETREF = HLINKGETREF(2i32);
impl ::std::convert::From<i32> for HLINKGETREF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLINKGETREF {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLINKMISC(pub i32);
pub const HLINKMISC_RELATIVE: HLINKMISC = HLINKMISC(1i32);
impl ::std::convert::From<i32> for HLINKMISC {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLINKMISC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLINKSETF(pub i32);
pub const HLINKSETF_TARGET: HLINKSETF = HLINKSETF(1i32);
pub const HLINKSETF_LOCATION: HLINKSETF = HLINKSETF(2i32);
impl ::std::convert::From<i32> for HLINKSETF {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLINKSETF {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLINKWHICHMK(pub i32);
pub const HLINKWHICHMK_CONTAINER: HLINKWHICHMK = HLINKWHICHMK(1i32);
pub const HLINKWHICHMK_BASE: HLINKWHICHMK = HLINKWHICHMK(2i32);
impl ::std::convert::From<i32> for HLINKWHICHMK {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLINKWHICHMK {
    type Abi = Self;
    type DefaultType = Self;
}
pub const HLINK_E_FIRST: ::windows::runtime::HRESULT =
    ::windows::runtime::HRESULT(-2147221248i32 as _);
pub const HLINK_S_DONTHIDE: i32 = 262400i32;
pub const HLINK_S_FIRST: ::windows::runtime::HRESULT = ::windows::runtime::HRESULT(262400i32 as _);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct HLITEM {
    pub uHLID: u32,
    pub pwzFriendlyName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl HLITEM {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for HLITEM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for HLITEM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HLITEM")
            .field("uHLID", &self.uHLID)
            .field("pwzFriendlyName", &self.pwzFriendlyName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for HLITEM {
    fn eq(&self, other: &Self) -> bool {
        self.uHLID == other.uHLID && self.pwzFriendlyName == other.pwzFriendlyName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for HLITEM {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for HLITEM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLNF(pub u32);
pub const HLNF_INTERNALJUMP: HLNF = HLNF(1u32);
pub const HLNF_OPENINNEWWINDOW: HLNF = HLNF(2u32);
pub const HLNF_NAVIGATINGBACK: HLNF = HLNF(4u32);
pub const HLNF_NAVIGATINGFORWARD: HLNF = HLNF(8u32);
pub const HLNF_NAVIGATINGTOSTACKITEM: HLNF = HLNF(16u32);
pub const HLNF_CREATENOHISTORY: HLNF = HLNF(32u32);
impl ::std::convert::From<u32> for HLNF {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLNF {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for HLNF {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for HLNF {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for HLNF {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for HLNF {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for HLNF {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const HLNF_ALLOW_AUTONAVIGATE: u32 = 536870912u32;
pub const HLNF_CALLERUNTRUSTED: u32 = 2097152u32;
pub const HLNF_DISABLEWINDOWRESTRICTIONS: u32 = 8388608u32;
pub const HLNF_EXTERNALNAVIGATE: u32 = 268435456u32;
pub const HLNF_NEWWINDOWSMANAGED: u32 = 2147483648u32;
pub const HLNF_TRUSTEDFORACTIVEX: u32 = 4194304u32;
pub const HLNF_TRUSTFIRSTDOWNLOAD: u32 = 16777216u32;
pub const HLNF_UNTRUSTEDFORDOWNLOAD: u32 = 33554432u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLQF_INFO(pub i32);
pub const HLQF_ISVALID: HLQF_INFO = HLQF_INFO(1i32);
pub const HLQF_ISCURRENT: HLQF_INFO = HLQF_INFO(2i32);
impl ::std::convert::From<i32> for HLQF_INFO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLQF_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct HLTBINFO {
    pub uDockType: u32,
    pub rcTbPos: super::super::Foundation::RECT,
}
#[cfg(feature = "Win32_Foundation")]
impl HLTBINFO {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for HLTBINFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for HLTBINFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HLTBINFO")
            .field("uDockType", &self.uDockType)
            .field("rcTbPos", &self.rcTbPos)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for HLTBINFO {
    fn eq(&self, other: &Self) -> bool {
        self.uDockType == other.uDockType && self.rcTbPos == other.rcTbPos
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for HLTBINFO {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for HLTBINFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HLTB_INFO(pub i32);
pub const HLTB_DOCKEDLEFT: HLTB_INFO = HLTB_INFO(0i32);
pub const HLTB_DOCKEDTOP: HLTB_INFO = HLTB_INFO(1i32);
pub const HLTB_DOCKEDRIGHT: HLTB_INFO = HLTB_INFO(2i32);
pub const HLTB_DOCKEDBOTTOM: HLTB_INFO = HLTB_INFO(3i32);
pub const HLTB_FLOATING: HLTB_INFO = HLTB_INFO(4i32);
impl ::std::convert::From<i32> for HLTB_INFO {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HLTB_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserFree(
    param0: *const u32,
    param1: *const super::super::Graphics::Gdi::HMONITOR,
) {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserFree(
                param0: *const u32,
                param1: *const super::super::Graphics::Gdi::HMONITOR,
            );
        }
        ::std::mem::transmute(HMONITOR_UserFree(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserFree64(
    param0: *const u32,
    param1: *const super::super::Graphics::Gdi::HMONITOR,
) {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserFree64(
                param0: *const u32,
                param1: *const super::super::Graphics::Gdi::HMONITOR,
            );
        }
        ::std::mem::transmute(HMONITOR_UserFree64(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserMarshal(
    param0: *const u32,
    param1: *mut u8,
    param2: *const super::super::Graphics::Gdi::HMONITOR,
) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserMarshal(
                param0: *const u32,
                param1: *mut u8,
                param2: *const super::super::Graphics::Gdi::HMONITOR,
            ) -> *mut u8;
        }
        ::std::mem::transmute(HMONITOR_UserMarshal(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserMarshal64(
    param0: *const u32,
    param1: *mut u8,
    param2: *const super::super::Graphics::Gdi::HMONITOR,
) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserMarshal64(
                param0: *const u32,
                param1: *mut u8,
                param2: *const super::super::Graphics::Gdi::HMONITOR,
            ) -> *mut u8;
        }
        ::std::mem::transmute(HMONITOR_UserMarshal64(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserSize(
    param0: *const u32,
    param1: u32,
    param2: *const super::super::Graphics::Gdi::HMONITOR,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserSize(
                param0: *const u32,
                param1: u32,
                param2: *const super::super::Graphics::Gdi::HMONITOR,
            ) -> u32;
        }
        ::std::mem::transmute(HMONITOR_UserSize(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserSize64(
    param0: *const u32,
    param1: u32,
    param2: *const super::super::Graphics::Gdi::HMONITOR,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserSize64(
                param0: *const u32,
                param1: u32,
                param2: *const super::super::Graphics::Gdi::HMONITOR,
            ) -> u32;
        }
        ::std::mem::transmute(HMONITOR_UserSize64(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserUnmarshal(
    param0: *const u32,
    param1: *const u8,
    param2: *mut super::super::Graphics::Gdi::HMONITOR,
) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserUnmarshal(
                param0: *const u32,
                param1: *const u8,
                param2: *mut super::super::Graphics::Gdi::HMONITOR,
            ) -> *mut u8;
        }
        ::std::mem::transmute(HMONITOR_UserUnmarshal(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Graphics_Gdi")]
pub unsafe fn HMONITOR_UserUnmarshal64(
    param0: *const u32,
    param1: *const u8,
    param2: *mut super::super::Graphics::Gdi::HMONITOR,
) -> *mut u8 {
    #[cfg(windows)]
    {
        #[link(name = "ole32")]
        extern "system" {
            fn HMONITOR_UserUnmarshal64(
                param0: *const u32,
                param1: *const u8,
                param2: *mut super::super::Graphics::Gdi::HMONITOR,
            ) -> *mut u8;
        }
        ::std::mem::transmute(HMONITOR_UserUnmarshal64(
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HOMEGROUPSHARINGCHOICES(pub i32);
pub const HGSC_NONE: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(0i32);
pub const HGSC_MUSICLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(1i32);
pub const HGSC_PICTURESLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(2i32);
pub const HGSC_VIDEOSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(4i32);
pub const HGSC_DOCUMENTSLIBRARY: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(8i32);
pub const HGSC_PRINTERS: HOMEGROUPSHARINGCHOICES = HOMEGROUPSHARINGCHOICES(16i32);
impl ::std::convert::From<i32> for HOMEGROUPSHARINGCHOICES {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HOMEGROUPSHARINGCHOICES {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HPSXA(pub isize);
impl ::std::default::Default for HPSXA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HPSXA {}
unsafe impl ::windows::runtime::Abi for HPSXA {
    type Abi = Self;
    type DefaultType = Self;
}
pub unsafe fn HashData(
    pbdata: *const u8,
    cbdata: u32,
    pbhash: *mut u8,
    cbhash: u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "shlwapi")]
        extern "system" {
            fn HashData(
                pbdata: *const u8,
                cbdata: u32,
                pbhash: *mut u8,
                cbhash: u32,
            ) -> ::windows::runtime::HRESULT;
        }
        HashData(
            ::std::mem::transmute(pbdata),
            ::std::mem::transmute(cbdata),
            ::std::mem::transmute(pbhash),
            ::std::mem::transmute(cbhash),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const HideInputPaneAnimationCoordinator: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        944194225,
        10871,
        19635,
        [140, 248, 17, 54, 245, 225, 126, 89],
    );
pub unsafe fn HlinkClone<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, IHlink>,
    Param2: ::windows::runtime::IntoParam<'a, IHlinkSite>,
>(
    pihl: Param0,
    riid: *const ::windows::runtime::GUID,
    pihlsiteforclone: Param2,
    dwsitedata: u32,
    ppvobj: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkClone(
                pihl: ::windows::runtime::RawPtr,
                riid: *const ::windows::runtime::GUID,
                pihlsiteforclone: ::windows::runtime::RawPtr,
                dwsitedata: u32,
                ppvobj: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkClone(
            pihl.into_param().abi(),
            ::std::mem::transmute(riid),
            pihlsiteforclone.into_param().abi(),
            ::std::mem::transmute(dwsitedata),
            ::std::mem::transmute(ppvobj),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn HlinkCreateBrowseContext<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
>(
    piunkouter: Param0,
    riid: *const ::windows::runtime::GUID,
    ppvobj: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateBrowseContext(
                piunkouter: ::windows::runtime::RawPtr,
                riid: *const ::windows::runtime::GUID,
                ppvobj: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateBrowseContext(
            piunkouter.into_param().abi(),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobj),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkCreateExtensionServices<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
>(
    pwzadditionalheaders: Param0,
    phwnd: Param1,
    pszusername: Param2,
    pszpassword: Param3,
    piunkouter: Param4,
    riid: *const ::windows::runtime::GUID,
    ppvobj: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateExtensionServices(
                pwzadditionalheaders: super::super::Foundation::PWSTR,
                phwnd: super::super::Foundation::HWND,
                pszusername: super::super::Foundation::PWSTR,
                pszpassword: super::super::Foundation::PWSTR,
                piunkouter: ::windows::runtime::RawPtr,
                riid: *const ::windows::runtime::GUID,
                ppvobj: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateExtensionServices(
            pwzadditionalheaders.into_param().abi(),
            phwnd.into_param().abi(),
            pszusername.into_param().abi(),
            pszpassword.into_param().abi(),
            piunkouter.into_param().abi(),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobj),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_System_Com")]
pub unsafe fn HlinkCreateFromData<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IDataObject>,
    Param1: ::windows::runtime::IntoParam<'a, IHlinkSite>,
    Param3: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
>(
    pidataobj: Param0,
    pihlsite: Param1,
    dwsitedata: u32,
    piunkouter: Param3,
    riid: *const ::windows::runtime::GUID,
    ppvobj: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateFromData(
                pidataobj: ::windows::runtime::RawPtr,
                pihlsite: ::windows::runtime::RawPtr,
                dwsitedata: u32,
                piunkouter: ::windows::runtime::RawPtr,
                riid: *const ::windows::runtime::GUID,
                ppvobj: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateFromData(
            pidataobj.into_param().abi(),
            pihlsite.into_param().abi(),
            ::std::mem::transmute(dwsitedata),
            piunkouter.into_param().abi(),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobj),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkCreateFromMoniker<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, IHlinkSite>,
    Param5: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
>(
    pimktrgt: Param0,
    pwzlocation: Param1,
    pwzfriendlyname: Param2,
    pihlsite: Param3,
    dwsitedata: u32,
    piunkouter: Param5,
    riid: *const ::windows::runtime::GUID,
    ppvobj: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateFromMoniker(
                pimktrgt: ::windows::runtime::RawPtr,
                pwzlocation: super::super::Foundation::PWSTR,
                pwzfriendlyname: super::super::Foundation::PWSTR,
                pihlsite: ::windows::runtime::RawPtr,
                dwsitedata: u32,
                piunkouter: ::windows::runtime::RawPtr,
                riid: *const ::windows::runtime::GUID,
                ppvobj: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateFromMoniker(
            pimktrgt.into_param().abi(),
            pwzlocation.into_param().abi(),
            pwzfriendlyname.into_param().abi(),
            pihlsite.into_param().abi(),
            ::std::mem::transmute(dwsitedata),
            piunkouter.into_param().abi(),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobj),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkCreateFromString<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, IHlinkSite>,
    Param5: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
>(
    pwztarget: Param0,
    pwzlocation: Param1,
    pwzfriendlyname: Param2,
    pihlsite: Param3,
    dwsitedata: u32,
    piunkouter: Param5,
    riid: *const ::windows::runtime::GUID,
    ppvobj: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateFromString(
                pwztarget: super::super::Foundation::PWSTR,
                pwzlocation: super::super::Foundation::PWSTR,
                pwzfriendlyname: super::super::Foundation::PWSTR,
                pihlsite: ::windows::runtime::RawPtr,
                dwsitedata: u32,
                piunkouter: ::windows::runtime::RawPtr,
                riid: *const ::windows::runtime::GUID,
                ppvobj: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateFromString(
            pwztarget.into_param().abi(),
            pwzlocation.into_param().abi(),
            pwzfriendlyname.into_param().abi(),
            pihlsite.into_param().abi(),
            ::std::mem::transmute(dwsitedata),
            piunkouter.into_param().abi(),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobj),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkCreateShortcut<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, IHlink>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    grfhlshortcutf: u32,
    pihl: Param1,
    pwzdir: Param2,
    pwzfilename: Param3,
    ppwzshortcutfile: *mut super::super::Foundation::PWSTR,
    dwreserved: u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateShortcut(
                grfhlshortcutf: u32,
                pihl: ::windows::runtime::RawPtr,
                pwzdir: super::super::Foundation::PWSTR,
                pwzfilename: super::super::Foundation::PWSTR,
                ppwzshortcutfile: *mut super::super::Foundation::PWSTR,
                dwreserved: u32,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateShortcut(
            ::std::mem::transmute(grfhlshortcutf),
            pihl.into_param().abi(),
            pwzdir.into_param().abi(),
            pwzfilename.into_param().abi(),
            ::std::mem::transmute(ppwzshortcutfile),
            ::std::mem::transmute(dwreserved),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkCreateShortcutFromMoniker<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    grfhlshortcutf: u32,
    pimktarget: Param1,
    pwzlocation: Param2,
    pwzdir: Param3,
    pwzfilename: Param4,
    ppwzshortcutfile: *mut super::super::Foundation::PWSTR,
    dwreserved: u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateShortcutFromMoniker(
                grfhlshortcutf: u32,
                pimktarget: ::windows::runtime::RawPtr,
                pwzlocation: super::super::Foundation::PWSTR,
                pwzdir: super::super::Foundation::PWSTR,
                pwzfilename: super::super::Foundation::PWSTR,
                ppwzshortcutfile: *mut super::super::Foundation::PWSTR,
                dwreserved: u32,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateShortcutFromMoniker(
            ::std::mem::transmute(grfhlshortcutf),
            pimktarget.into_param().abi(),
            pwzlocation.into_param().abi(),
            pwzdir.into_param().abi(),
            pwzfilename.into_param().abi(),
            ::std::mem::transmute(ppwzshortcutfile),
            ::std::mem::transmute(dwreserved),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkCreateShortcutFromString<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    grfhlshortcutf: u32,
    pwztarget: Param1,
    pwzlocation: Param2,
    pwzdir: Param3,
    pwzfilename: Param4,
    ppwzshortcutfile: *mut super::super::Foundation::PWSTR,
    dwreserved: u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkCreateShortcutFromString(
                grfhlshortcutf: u32,
                pwztarget: super::super::Foundation::PWSTR,
                pwzlocation: super::super::Foundation::PWSTR,
                pwzdir: super::super::Foundation::PWSTR,
                pwzfilename: super::super::Foundation::PWSTR,
                ppwzshortcutfile: *mut super::super::Foundation::PWSTR,
                dwreserved: u32,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkCreateShortcutFromString(
            ::std::mem::transmute(grfhlshortcutf),
            pwztarget.into_param().abi(),
            pwzlocation.into_param().abi(),
            pwzdir.into_param().abi(),
            pwzfilename.into_param().abi(),
            ::std::mem::transmute(ppwzshortcutfile),
            ::std::mem::transmute(dwreserved),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkGetSpecialReference(
    ureference: u32,
) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkGetSpecialReference(
                ureference: u32,
                ppwzreference: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        HlinkGetSpecialReference(::std::mem::transmute(ureference), &mut result__)
            .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkGetValueFromParams<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pwzparams: Param0,
    pwzname: Param1,
) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkGetValueFromParams(
                pwzparams: super::super::Foundation::PWSTR,
                pwzname: super::super::Foundation::PWSTR,
                ppwzvalue: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        HlinkGetValueFromParams(
            pwzparams.into_param().abi(),
            pwzname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkIsShortcut<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pwzfilename: Param0,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkIsShortcut(
                pwzfilename: super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkIsShortcut(pwzfilename.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_System_Com")]
pub unsafe fn HlinkNavigate<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, IHlink>,
    Param1: ::windows::runtime::IntoParam<'a, IHlinkFrame>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindCtx>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindStatusCallback>,
    Param5: ::windows::runtime::IntoParam<'a, IHlinkBrowseContext>,
>(
    pihl: Param0,
    pihlframe: Param1,
    grfhlnf: u32,
    pbc: Param3,
    pibsc: Param4,
    pihlbc: Param5,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkNavigate(
                pihl: ::windows::runtime::RawPtr,
                pihlframe: ::windows::runtime::RawPtr,
                grfhlnf: u32,
                pbc: ::windows::runtime::RawPtr,
                pibsc: ::windows::runtime::RawPtr,
                pihlbc: ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkNavigate(
            pihl.into_param().abi(),
            pihlframe.into_param().abi(),
            ::std::mem::transmute(grfhlnf),
            pbc.into_param().abi(),
            pibsc.into_param().abi(),
            pihlbc.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkNavigateToStringReference<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, IHlinkSite>,
    Param4: ::windows::runtime::IntoParam<'a, IHlinkFrame>,
    Param6: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindCtx>,
    Param7: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindStatusCallback>,
    Param8: ::windows::runtime::IntoParam<'a, IHlinkBrowseContext>,
>(
    pwztarget: Param0,
    pwzlocation: Param1,
    pihlsite: Param2,
    dwsitedata: u32,
    pihlframe: Param4,
    grfhlnf: u32,
    pibc: Param6,
    pibsc: Param7,
    pihlbc: Param8,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkNavigateToStringReference(
                pwztarget: super::super::Foundation::PWSTR,
                pwzlocation: super::super::Foundation::PWSTR,
                pihlsite: ::windows::runtime::RawPtr,
                dwsitedata: u32,
                pihlframe: ::windows::runtime::RawPtr,
                grfhlnf: u32,
                pibc: ::windows::runtime::RawPtr,
                pibsc: ::windows::runtime::RawPtr,
                pihlbc: ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkNavigateToStringReference(
            pwztarget.into_param().abi(),
            pwzlocation.into_param().abi(),
            pihlsite.into_param().abi(),
            ::std::mem::transmute(dwsitedata),
            pihlframe.into_param().abi(),
            ::std::mem::transmute(grfhlnf),
            pibc.into_param().abi(),
            pibsc.into_param().abi(),
            pihlbc.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkOnNavigate<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, IHlinkFrame>,
    Param1: ::windows::runtime::IntoParam<'a, IHlinkBrowseContext>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param5: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pihlframe: Param0,
    pihlbc: Param1,
    grfhlnf: u32,
    pimktarget: Param3,
    pwzlocation: Param4,
    pwzfriendlyname: Param5,
    puhlid: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkOnNavigate(
                pihlframe: ::windows::runtime::RawPtr,
                pihlbc: ::windows::runtime::RawPtr,
                grfhlnf: u32,
                pimktarget: ::windows::runtime::RawPtr,
                pwzlocation: super::super::Foundation::PWSTR,
                pwzfriendlyname: super::super::Foundation::PWSTR,
                puhlid: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkOnNavigate(
            pihlframe.into_param().abi(),
            pihlbc.into_param().abi(),
            ::std::mem::transmute(grfhlnf),
            pimktarget.into_param().abi(),
            pwzlocation.into_param().abi(),
            pwzfriendlyname.into_param().abi(),
            ::std::mem::transmute(puhlid),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_System_Com")]
pub unsafe fn HlinkOnRenameDocument<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, IHlinkBrowseContext>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
>(
    dwreserved: u32,
    pihlbc: Param1,
    pimkold: Param2,
    pimknew: Param3,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkOnRenameDocument(
                dwreserved: u32,
                pihlbc: ::windows::runtime::RawPtr,
                pimkold: ::windows::runtime::RawPtr,
                pimknew: ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkOnRenameDocument(
            ::std::mem::transmute(dwreserved),
            pihlbc.into_param().abi(),
            pimkold.into_param().abi(),
            pimknew.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkParseDisplayName<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindCtx>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
>(
    pibc: Param0,
    pwzdisplayname: Param1,
    fnoforceabs: Param2,
    pccheaten: *mut u32,
    ppimk: *mut ::std::option::Option<super::super::System::Com::IMoniker>,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkParseDisplayName(
                pibc: ::windows::runtime::RawPtr,
                pwzdisplayname: super::super::Foundation::PWSTR,
                fnoforceabs: super::super::Foundation::BOOL,
                pccheaten: *mut u32,
                ppimk: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkParseDisplayName(
            pibc.into_param().abi(),
            pwzdisplayname.into_param().abi(),
            fnoforceabs.into_param().abi(),
            ::std::mem::transmute(pccheaten),
            ::std::mem::transmute(ppimk),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_System_Com")]
pub unsafe fn HlinkPreprocessMoniker<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindCtx>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
>(
    pibc: Param0,
    pimkin: Param1,
) -> ::windows::runtime::Result<super::super::System::Com::IMoniker> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkPreprocessMoniker(
                pibc: ::windows::runtime::RawPtr,
                pimkin: ::windows::runtime::RawPtr,
                ppimkout: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::System::Com::IMoniker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        HlinkPreprocessMoniker(
            pibc.into_param().abi(),
            pimkin.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IMoniker>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_System_Com")]
pub unsafe fn HlinkQueryCreateFromData<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IDataObject>,
>(
    pidataobj: Param0,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkQueryCreateFromData(
                pidataobj: ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkQueryCreateFromData(pidataobj.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_System_Com")]
pub unsafe fn HlinkResolveMonikerForData<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindCtx>,
    Param5: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindStatusCallback>,
    Param6: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
>(
    pimkreference: Param0,
    reserved: u32,
    pibc: Param2,
    cfmtetc: u32,
    rgfmtetc: *mut super::super::System::Com::FORMATETC,
    pibsc: Param5,
    pimkbase: Param6,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkResolveMonikerForData(
                pimkreference: ::windows::runtime::RawPtr,
                reserved: u32,
                pibc: ::windows::runtime::RawPtr,
                cfmtetc: u32,
                rgfmtetc: *mut super::super::System::Com::FORMATETC,
                pibsc: ::windows::runtime::RawPtr,
                pimkbase: ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkResolveMonikerForData(
            pimkreference.into_param().abi(),
            ::std::mem::transmute(reserved),
            pibc.into_param().abi(),
            ::std::mem::transmute(cfmtetc),
            ::std::mem::transmute(rgfmtetc),
            pibsc.into_param().abi(),
            pimkbase.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkResolveShortcut<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, IHlinkSite>,
    Param3: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
>(
    pwzshortcutfilename: Param0,
    pihlsite: Param1,
    dwsitedata: u32,
    piunkouter: Param3,
    riid: *const ::windows::runtime::GUID,
    ppvobj: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkResolveShortcut(
                pwzshortcutfilename: super::super::Foundation::PWSTR,
                pihlsite: ::windows::runtime::RawPtr,
                dwsitedata: u32,
                piunkouter: ::windows::runtime::RawPtr,
                riid: *const ::windows::runtime::GUID,
                ppvobj: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkResolveShortcut(
            pwzshortcutfilename.into_param().abi(),
            pihlsite.into_param().abi(),
            ::std::mem::transmute(dwsitedata),
            piunkouter.into_param().abi(),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobj),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkResolveShortcutToMoniker<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pwzshortcutfilename: Param0,
    ppimktarget: *mut ::std::option::Option<super::super::System::Com::IMoniker>,
    ppwzlocation: *mut super::super::Foundation::PWSTR,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkResolveShortcutToMoniker(
                pwzshortcutfilename: super::super::Foundation::PWSTR,
                ppimktarget: *mut ::windows::runtime::RawPtr,
                ppwzlocation: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkResolveShortcutToMoniker(
            pwzshortcutfilename.into_param().abi(),
            ::std::mem::transmute(ppimktarget),
            ::std::mem::transmute(ppwzlocation),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkResolveShortcutToString<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pwzshortcutfilename: Param0,
    ppwztarget: *mut super::super::Foundation::PWSTR,
    ppwzlocation: *mut super::super::Foundation::PWSTR,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkResolveShortcutToString(
                pwzshortcutfilename: super::super::Foundation::PWSTR,
                ppwztarget: *mut super::super::Foundation::PWSTR,
                ppwzlocation: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkResolveShortcutToString(
            pwzshortcutfilename.into_param().abi(),
            ::std::mem::transmute(ppwztarget),
            ::std::mem::transmute(ppwzlocation),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkResolveStringForData<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindCtx>,
    Param5: ::windows::runtime::IntoParam<'a, super::super::System::Com::IBindStatusCallback>,
    Param6: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
>(
    pwzreference: Param0,
    reserved: u32,
    pibc: Param2,
    cfmtetc: u32,
    rgfmtetc: *mut super::super::System::Com::FORMATETC,
    pibsc: Param5,
    pimkbase: Param6,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkResolveStringForData(
                pwzreference: super::super::Foundation::PWSTR,
                reserved: u32,
                pibc: ::windows::runtime::RawPtr,
                cfmtetc: u32,
                rgfmtetc: *mut super::super::System::Com::FORMATETC,
                pibsc: ::windows::runtime::RawPtr,
                pimkbase: ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkResolveStringForData(
            pwzreference.into_param().abi(),
            ::std::mem::transmute(reserved),
            pibc.into_param().abi(),
            ::std::mem::transmute(cfmtetc),
            ::std::mem::transmute(rgfmtetc),
            pibsc.into_param().abi(),
            pimkbase.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkSetSpecialReference<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    ureference: u32,
    pwzreference: Param1,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkSetSpecialReference(
                ureference: u32,
                pwzreference: super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkSetSpecialReference(
            ::std::mem::transmute(ureference),
            pwzreference.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn HlinkTranslateURL<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pwzurl: Param0,
    grfflags: u32,
) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkTranslateURL(
                pwzurl: super::super::Foundation::PWSTR,
                grfflags: u32,
                ppwztranslatedurl: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        HlinkTranslateURL(
            pwzurl.into_param().abi(),
            ::std::mem::transmute(grfflags),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
pub unsafe fn HlinkUpdateStackItem<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, IHlinkFrame>,
    Param1: ::windows::runtime::IntoParam<'a, IHlinkBrowseContext>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::System::Com::IMoniker>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param5: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pihlframe: Param0,
    pihlbc: Param1,
    uhlid: u32,
    pimktrgt: Param3,
    pwzlocation: Param4,
    pwzfriendlyname: Param5,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "hlink")]
        extern "system" {
            fn HlinkUpdateStackItem(
                pihlframe: ::windows::runtime::RawPtr,
                pihlbc: ::windows::runtime::RawPtr,
                uhlid: u32,
                pimktrgt: ::windows::runtime::RawPtr,
                pwzlocation: super::super::Foundation::PWSTR,
                pwzfriendlyname: super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        HlinkUpdateStackItem(
            pihlframe.into_param().abi(),
            pihlbc.into_param().abi(),
            ::std::mem::transmute(uhlid),
            pimktrgt.into_param().abi(),
            pwzlocation.into_param().abi(),
            pwzfriendlyname.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const HomeGroup: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3732388356,
    15506,
    19729,
    [161, 165, 66, 53, 42, 83, 224, 227],
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IACList(::windows::runtime::IUnknown);
impl IACList {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Expand<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszexpand: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pszexpand.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IACList {
    type Vtable = IACList_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2007052464,
        38141,
        4560,
        [165, 68, 0, 192, 79, 215, 208, 98],
    );
}
impl ::std::convert::From<IACList> for ::windows::runtime::IUnknown {
    fn from(value: IACList) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IACList> for ::windows::runtime::IUnknown {
    fn from(value: &IACList) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IACList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IACList {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszexpand: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IACList2(::windows::runtime::IUnknown);
impl IACList2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Expand<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszexpand: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pszexpand.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflag),
        )
        .ok()
    }
    pub unsafe fn GetOptions(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IACList2 {
    type Vtable = IACList2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1191264672,
        20870,
        4562,
        [187, 182, 0, 96, 151, 123, 70, 76],
    );
}
impl ::std::convert::From<IACList2> for ::windows::runtime::IUnknown {
    fn from(value: IACList2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IACList2> for ::windows::runtime::IUnknown {
    fn from(value: &IACList2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IACList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IACList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IACList2> for IACList {
    fn from(value: IACList2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IACList2> for IACList {
    fn from(value: &IACList2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IACList> for IACList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IACList> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IACList>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IACList> for &IACList2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IACList> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IACList>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IACList2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszexpand: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflag: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflag: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccessibleObject(::windows::runtime::IUnknown);
impl IAccessibleObject {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAccessibleName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszname: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pszname.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAccessibleObject {
    type Vtable = IAccessibleObject_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2510524869,
        40660,
        19496,
        [132, 1, 171, 158, 6, 113, 158, 17],
    );
}
impl ::std::convert::From<IAccessibleObject> for ::windows::runtime::IUnknown {
    fn from(value: IAccessibleObject) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccessibleObject> for ::windows::runtime::IUnknown {
    fn from(value: &IAccessibleObject) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAccessibleObject {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAccessibleObject {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleObject_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActionProgress(::windows::runtime::IUnknown);
impl IActionProgress {
    pub unsafe fn Begin(&self, action: SPACTION, flags: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(action),
            ::std::mem::transmute(flags),
        )
        .ok()
    }
    pub unsafe fn UpdateProgress(
        &self,
        ulcompleted: u64,
        ultotal: u64,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulcompleted),
            ::std::mem::transmute(ultotal),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UpdateText<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        sptext: SPTEXT,
        psztext: Param1,
        fmaycompact: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(sptext),
            psztext.into_param().abi(),
            fmaycompact.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryCancel(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ResetCancel(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn End(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActionProgress {
    type Vtable = IActionProgress_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1241452915,
        60124,
        17517,
        [146, 133, 21, 100, 83, 166, 67, 28],
    );
}
impl ::std::convert::From<IActionProgress> for ::windows::runtime::IUnknown {
    fn from(value: IActionProgress) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActionProgress> for ::windows::runtime::IUnknown {
    fn from(value: &IActionProgress) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActionProgress {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IActionProgress {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgress_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        action: SPACTION,
        flags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulcompleted: u64,
        ultotal: u64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        sptext: SPTEXT,
        psztext: super::super::Foundation::PWSTR,
        fmaycompact: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfcancelled: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IActionProgressDialog(::windows::runtime::IUnknown);
impl IActionProgressDialog {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Initialize<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        flags: u32,
        psztitle: Param1,
        pszcancel: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(flags),
            psztitle.into_param().abi(),
            pszcancel.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Stop(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IActionProgressDialog {
    type Vtable = IActionProgressDialog_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1241452914,
        60124,
        17517,
        [146, 133, 21, 100, 83, 166, 67, 28],
    );
}
impl ::std::convert::From<IActionProgressDialog> for ::windows::runtime::IUnknown {
    fn from(value: IActionProgressDialog) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IActionProgressDialog> for ::windows::runtime::IUnknown {
    fn from(value: &IActionProgressDialog) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IActionProgressDialog {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IActionProgressDialog
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IActionProgressDialog_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flags: u32,
        psztitle: super::super::Foundation::PWSTR,
        pszcancel: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAppActivationUIInfo(::windows::runtime::IUnknown);
impl IAppActivationUIInfo {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetMonitor(
        &self,
    ) -> ::windows::runtime::Result<super::super::Graphics::Gdi::HMONITOR> {
        let mut result__: <super::super::Graphics::Gdi::HMONITOR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Graphics::Gdi::HMONITOR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInvokePoint(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::POINT> {
        let mut result__: <super::super::Foundation::POINT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::POINT>(result__)
    }
    pub unsafe fn GetShowCommand(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetShowUI(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetKeyState(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAppActivationUIInfo {
    type Vtable = IAppActivationUIInfo_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2880247965,
        40867,
        17016,
        [179, 202, 140, 164, 72, 168, 141, 203],
    );
}
impl ::std::convert::From<IAppActivationUIInfo> for ::windows::runtime::IUnknown {
    fn from(value: IAppActivationUIInfo) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAppActivationUIInfo> for ::windows::runtime::IUnknown {
    fn from(value: &IAppActivationUIInfo) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAppActivationUIInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAppActivationUIInfo {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppActivationUIInfo_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::super::Graphics::Gdi::HMONITOR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::super::Foundation::POINT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAppPublisher(::windows::runtime::IUnknown);
impl IAppPublisher {
    pub unsafe fn GetNumberOfCategories(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCategories(&self) -> ::windows::runtime::Result<APPCATEGORYINFOLIST> {
        let mut result__: <APPCATEGORYINFOLIST as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<APPCATEGORYINFOLIST>(result__)
    }
    pub unsafe fn GetNumberOfApps(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn EnumApps(
        &self,
        pappcategoryid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<IEnumPublishedApps> {
        let mut result__: <IEnumPublishedApps as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pappcategoryid),
            &mut result__,
        )
        .from_abi::<IEnumPublishedApps>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAppPublisher {
    type Vtable = IAppPublisher_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        119867920,
        40185,
        4561,
        [144, 118, 0, 96, 8, 5, 147, 130],
    );
}
impl ::std::convert::From<IAppPublisher> for ::windows::runtime::IUnknown {
    fn from(value: IAppPublisher) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAppPublisher> for ::windows::runtime::IUnknown {
    fn from(value: &IAppPublisher) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAppPublisher {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAppPublisher {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppPublisher_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwcat: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pappcategorylist: *mut APPCATEGORYINFOLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwapps: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pappcategoryid: *const ::windows::runtime::GUID,
        ppepa: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAppVisibility(::windows::runtime::IUnknown);
impl IAppVisibility {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetAppVisibilityOnMonitor<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>,
    >(
        &self,
        hmonitor: Param0,
    ) -> ::windows::runtime::Result<MONITOR_APP_VISIBILITY> {
        let mut result__: <MONITOR_APP_VISIBILITY as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hmonitor.into_param().abi(),
            &mut result__,
        )
        .from_abi::<MONITOR_APP_VISIBILITY>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsLauncherVisible(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Advise<'a, Param0: ::windows::runtime::IntoParam<'a, IAppVisibilityEvents>>(
        &self,
        pcallback: Param0,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            pcallback.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn Unadvise(&self, dwcookie: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwcookie),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAppVisibility {
    type Vtable = IAppVisibility_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        575072813,
        51946,
        17476,
        [163, 196, 109, 232, 39, 228, 67, 19],
    );
}
impl ::std::convert::From<IAppVisibility> for ::windows::runtime::IUnknown {
    fn from(value: IAppVisibility) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAppVisibility> for ::windows::runtime::IUnknown {
    fn from(value: &IAppVisibility) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAppVisibility {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAppVisibility {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibility_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hmonitor: super::super::Graphics::Gdi::HMONITOR,
        pmode: *mut MONITOR_APP_VISIBILITY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfvisible: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcallback: ::windows::runtime::RawPtr,
        pdwcookie: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwcookie: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAppVisibilityEvents(::windows::runtime::IUnknown);
impl IAppVisibilityEvents {
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn AppVisibilityOnMonitorChanged<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>,
    >(
        &self,
        hmonitor: Param0,
        previousmode: MONITOR_APP_VISIBILITY,
        currentmode: MONITOR_APP_VISIBILITY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hmonitor.into_param().abi(),
            ::std::mem::transmute(previousmode),
            ::std::mem::transmute(currentmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LauncherVisibilityChange<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        currentvisiblestate: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            currentvisiblestate.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAppVisibilityEvents {
    type Vtable = IAppVisibilityEvents_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1703202411,
        32130,
        18882,
        [137, 201, 198, 188, 2, 186, 140, 56],
    );
}
impl ::std::convert::From<IAppVisibilityEvents> for ::windows::runtime::IUnknown {
    fn from(value: IAppVisibilityEvents) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAppVisibilityEvents> for ::windows::runtime::IUnknown {
    fn from(value: &IAppVisibilityEvents) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAppVisibilityEvents {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAppVisibilityEvents {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAppVisibilityEvents_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hmonitor: super::super::Graphics::Gdi::HMONITOR,
        previousmode: MONITOR_APP_VISIBILITY,
        currentmode: MONITOR_APP_VISIBILITY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        currentvisiblestate: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IApplicationActivationManager(::windows::runtime::IUnknown);
impl IApplicationActivationManager {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateApplication<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        appusermodelid: Param0,
        arguments: Param1,
        options: ACTIVATEOPTIONS,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            appusermodelid.into_param().abi(),
            arguments.into_param().abi(),
            ::std::mem::transmute(options),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateForFile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, IShellItemArray>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        appusermodelid: Param0,
        itemarray: Param1,
        verb: Param2,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            appusermodelid.into_param().abi(),
            itemarray.into_param().abi(),
            verb.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateForProtocol<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, IShellItemArray>,
    >(
        &self,
        appusermodelid: Param0,
        itemarray: Param1,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            appusermodelid.into_param().abi(),
            itemarray.into_param().abi(),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IApplicationActivationManager {
    type Vtable = IApplicationActivationManager_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        781455681,
        32663,
        18262,
        [186, 29, 157, 236, 222, 137, 74, 61],
    );
}
impl ::std::convert::From<IApplicationActivationManager> for ::windows::runtime::IUnknown {
    fn from(value: IApplicationActivationManager) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationActivationManager> for ::windows::runtime::IUnknown {
    fn from(value: &IApplicationActivationManager) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IApplicationActivationManager
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IApplicationActivationManager
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationActivationManager_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        appusermodelid: super::super::Foundation::PWSTR,
        arguments: super::super::Foundation::PWSTR,
        options: ACTIVATEOPTIONS,
        processid: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        appusermodelid: super::super::Foundation::PWSTR,
        itemarray: ::windows::runtime::RawPtr,
        verb: super::super::Foundation::PWSTR,
        processid: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        appusermodelid: super::super::Foundation::PWSTR,
        itemarray: ::windows::runtime::RawPtr,
        processid: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IApplicationAssociationRegistration(::windows::runtime::IUnknown);
impl IApplicationAssociationRegistration {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryCurrentDefault<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszquery: Param0,
        atquerytype: ASSOCIATIONTYPE,
        alquerylevel: ASSOCIATIONLEVEL,
    ) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pszquery.into_param().abi(),
            ::std::mem::transmute(atquerytype),
            ::std::mem::transmute(alquerylevel),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefault<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszquery: Param0,
        atquerytype: ASSOCIATIONTYPE,
        alquerylevel: ASSOCIATIONLEVEL,
        pszappregistryname: Param3,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pszquery.into_param().abi(),
            ::std::mem::transmute(atquerytype),
            ::std::mem::transmute(alquerylevel),
            pszappregistryname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryAppIsDefaultAll<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        alquerylevel: ASSOCIATIONLEVEL,
        pszappregistryname: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(alquerylevel),
            pszappregistryname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppAsDefault<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszappregistryname: Param0,
        pszset: Param1,
        atsettype: ASSOCIATIONTYPE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            pszappregistryname.into_param().abi(),
            pszset.into_param().abi(),
            ::std::mem::transmute(atsettype),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppAsDefaultAll<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszappregistryname: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pszappregistryname.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ClearUserAssociations(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IApplicationAssociationRegistration {
    type Vtable = IApplicationAssociationRegistration_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1314065162,
        58897,
        19575,
        [163, 172, 144, 49, 208, 34, 40, 27],
    );
}
impl ::std::convert::From<IApplicationAssociationRegistration> for ::windows::runtime::IUnknown {
    fn from(value: IApplicationAssociationRegistration) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationAssociationRegistration> for ::windows::runtime::IUnknown {
    fn from(value: &IApplicationAssociationRegistration) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IApplicationAssociationRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IApplicationAssociationRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistration_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszquery: super::super::Foundation::PWSTR,
        atquerytype: ASSOCIATIONTYPE,
        alquerylevel: ASSOCIATIONLEVEL,
        ppszassociation: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszquery: super::super::Foundation::PWSTR,
        atquerytype: ASSOCIATIONTYPE,
        alquerylevel: ASSOCIATIONLEVEL,
        pszappregistryname: super::super::Foundation::PWSTR,
        pfdefault: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        alquerylevel: ASSOCIATIONLEVEL,
        pszappregistryname: super::super::Foundation::PWSTR,
        pfdefault: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszappregistryname: super::super::Foundation::PWSTR,
        pszset: super::super::Foundation::PWSTR,
        atsettype: ASSOCIATIONTYPE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszappregistryname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IApplicationAssociationRegistrationUI(::windows::runtime::IUnknown);
impl IApplicationAssociationRegistrationUI {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn LaunchAdvancedAssociationUI<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszappregistryname: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pszappregistryname.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IApplicationAssociationRegistrationUI {
    type Vtable = IApplicationAssociationRegistrationUI_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        527868265,
        63892,
        16556,
        [143, 200, 9, 89, 232, 135, 71, 16],
    );
}
impl ::std::convert::From<IApplicationAssociationRegistrationUI> for ::windows::runtime::IUnknown {
    fn from(value: IApplicationAssociationRegistrationUI) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationAssociationRegistrationUI> for ::windows::runtime::IUnknown {
    fn from(value: &IApplicationAssociationRegistrationUI) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IApplicationAssociationRegistrationUI
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IApplicationAssociationRegistrationUI
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationAssociationRegistrationUI_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszappregistryname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IApplicationDesignModeSettings(::windows::runtime::IUnknown);
impl IApplicationDesignModeSettings {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::SIZE>,
    >(
        &self,
        nativedisplaysizepixels: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            nativedisplaysizepixels.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetScaleFactor(
        &self,
        scalefactor: DEVICE_SCALE_FACTOR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scalefactor),
        )
        .ok()
    }
    pub unsafe fn SetApplicationViewState(
        &self,
        viewstate: APPLICATION_VIEW_STATE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(viewstate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::SIZE> {
        let mut result__: <super::super::Foundation::SIZE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsApplicationViewStateSupported<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::SIZE>,
    >(
        &self,
        viewstate: APPLICATION_VIEW_STATE,
        nativedisplaysizepixels: Param1,
        scalefactor: DEVICE_SCALE_FACTOR,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(viewstate),
            nativedisplaysizepixels.into_param().abi(),
            ::std::mem::transmute(scalefactor),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn TriggerEdgeGesture(
        &self,
        edgegesturekind: EDGE_GESTURE_KIND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(edgegesturekind),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IApplicationDesignModeSettings {
    type Vtable = IApplicationDesignModeSettings_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        708701850,
        58141,
        18134,
        [133, 8, 188, 197, 151, 219, 53, 87],
    );
}
impl ::std::convert::From<IApplicationDesignModeSettings> for ::windows::runtime::IUnknown {
    fn from(value: IApplicationDesignModeSettings) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationDesignModeSettings> for ::windows::runtime::IUnknown {
    fn from(value: &IApplicationDesignModeSettings) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IApplicationDesignModeSettings
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IApplicationDesignModeSettings
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        nativedisplaysizepixels: super::super::Foundation::SIZE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scalefactor: DEVICE_SCALE_FACTOR,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        viewstate: APPLICATION_VIEW_STATE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        applicationsizepixels: *mut super::super::Foundation::SIZE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        viewstate: APPLICATION_VIEW_STATE,
        nativedisplaysizepixels: super::super::Foundation::SIZE,
        scalefactor: DEVICE_SCALE_FACTOR,
        supported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        edgegesturekind: EDGE_GESTURE_KIND,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IApplicationDesignModeSettings2(::windows::runtime::IUnknown);
impl IApplicationDesignModeSettings2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetNativeDisplaySize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::SIZE>,
    >(
        &self,
        nativedisplaysizepixels: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            nativedisplaysizepixels.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetScaleFactor(
        &self,
        scalefactor: DEVICE_SCALE_FACTOR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scalefactor),
        )
        .ok()
    }
    pub unsafe fn SetApplicationViewState(
        &self,
        viewstate: APPLICATION_VIEW_STATE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(viewstate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComputeApplicationSize(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::SIZE> {
        let mut result__: <super::super::Foundation::SIZE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::SIZE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsApplicationViewStateSupported<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::SIZE>,
    >(
        &self,
        viewstate: APPLICATION_VIEW_STATE,
        nativedisplaysizepixels: Param1,
        scalefactor: DEVICE_SCALE_FACTOR,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(viewstate),
            nativedisplaysizepixels.into_param().abi(),
            ::std::mem::transmute(scalefactor),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn TriggerEdgeGesture(
        &self,
        edgegesturekind: EDGE_GESTURE_KIND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(edgegesturekind),
        )
        .ok()
    }
    pub unsafe fn SetNativeDisplayOrientation(
        &self,
        nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(nativedisplayorientation),
        )
        .ok()
    }
    pub unsafe fn SetApplicationViewOrientation(
        &self,
        vieworientation: APPLICATION_VIEW_ORIENTATION,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(vieworientation),
        )
        .ok()
    }
    pub unsafe fn SetAdjacentDisplayEdges(
        &self,
        adjacentdisplayedges: ADJACENT_DISPLAY_EDGES,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(adjacentdisplayedges),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetIsOnLockScreen<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        isonlockscreen: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            isonlockscreen.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetApplicationViewMinWidth(
        &self,
        viewminwidth: APPLICATION_VIEW_MIN_WIDTH,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(viewminwidth),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationSizeBounds(
        &self,
        minapplicationsizepixels: *mut super::super::Foundation::SIZE,
        maxapplicationsizepixels: *mut super::super::Foundation::SIZE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(minapplicationsizepixels),
            ::std::mem::transmute(maxapplicationsizepixels),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetApplicationViewOrientation<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::SIZE>,
    >(
        &self,
        applicationsizepixels: Param0,
    ) -> ::windows::runtime::Result<APPLICATION_VIEW_ORIENTATION> {
        let mut result__: <APPLICATION_VIEW_ORIENTATION as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            applicationsizepixels.into_param().abi(),
            &mut result__,
        )
        .from_abi::<APPLICATION_VIEW_ORIENTATION>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IApplicationDesignModeSettings2 {
    type Vtable = IApplicationDesignModeSettings2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1225069793,
        26458,
        19822,
        [165, 141, 229, 73, 1, 180, 202, 47],
    );
}
impl ::std::convert::From<IApplicationDesignModeSettings2> for ::windows::runtime::IUnknown {
    fn from(value: IApplicationDesignModeSettings2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationDesignModeSettings2> for ::windows::runtime::IUnknown {
    fn from(value: &IApplicationDesignModeSettings2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IApplicationDesignModeSettings2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IApplicationDesignModeSettings2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IApplicationDesignModeSettings2> for IApplicationDesignModeSettings {
    fn from(value: IApplicationDesignModeSettings2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationDesignModeSettings2> for IApplicationDesignModeSettings {
    fn from(value: &IApplicationDesignModeSettings2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IApplicationDesignModeSettings>
    for IApplicationDesignModeSettings2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IApplicationDesignModeSettings> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IApplicationDesignModeSettings>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IApplicationDesignModeSettings>
    for &IApplicationDesignModeSettings2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IApplicationDesignModeSettings> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IApplicationDesignModeSettings>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDesignModeSettings2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        nativedisplaysizepixels: super::super::Foundation::SIZE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scalefactor: DEVICE_SCALE_FACTOR,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        viewstate: APPLICATION_VIEW_STATE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        applicationsizepixels: *mut super::super::Foundation::SIZE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        viewstate: APPLICATION_VIEW_STATE,
        nativedisplaysizepixels: super::super::Foundation::SIZE,
        scalefactor: DEVICE_SCALE_FACTOR,
        supported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        edgegesturekind: EDGE_GESTURE_KIND,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        nativedisplayorientation: NATIVE_DISPLAY_ORIENTATION,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        vieworientation: APPLICATION_VIEW_ORIENTATION,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        adjacentdisplayedges: ADJACENT_DISPLAY_EDGES,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        isonlockscreen: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        viewminwidth: APPLICATION_VIEW_MIN_WIDTH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        minapplicationsizepixels: *mut super::super::Foundation::SIZE,
        maxapplicationsizepixels: *mut super::super::Foundation::SIZE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        applicationsizepixels: super::super::Foundation::SIZE,
        vieworientation: *mut APPLICATION_VIEW_ORIENTATION,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IApplicationDestinations(::windows::runtime::IUnknown);
impl IApplicationDestinations {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppID<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszappid: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pszappid.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveDestination<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        punk: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            punk.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAllDestinations(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IApplicationDestinations {
    type Vtable = IApplicationDestinations_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        305364277,
        38086,
        18592,
        [188, 231, 106, 156, 105, 212, 214, 0],
    );
}
impl ::std::convert::From<IApplicationDestinations> for ::windows::runtime::IUnknown {
    fn from(value: IApplicationDestinations) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationDestinations> for ::windows::runtime::IUnknown {
    fn from(value: &IApplicationDestinations) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IApplicationDestinations
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IApplicationDestinations
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDestinations_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszappid: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punk: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IApplicationDocumentLists(::windows::runtime::IUnknown);
impl IApplicationDocumentLists {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAppID<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszappid: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pszappid.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetList<T: ::windows::runtime::Interface>(
        &self,
        listtype: APPDOCLISTTYPE,
        citemsdesired: u32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(listtype),
            ::std::mem::transmute(citemsdesired),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IApplicationDocumentLists {
    type Vtable = IApplicationDocumentLists_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1012486047,
        40752,
        18337,
        [151, 154, 201, 232, 61, 61, 10, 6],
    );
}
impl ::std::convert::From<IApplicationDocumentLists> for ::windows::runtime::IUnknown {
    fn from(value: IApplicationDocumentLists) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IApplicationDocumentLists> for ::windows::runtime::IUnknown {
    fn from(value: &IApplicationDocumentLists) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IApplicationDocumentLists
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IApplicationDocumentLists
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IApplicationDocumentLists_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszappid: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        listtype: APPDOCLISTTYPE,
        citemsdesired: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAssocHandler(::windows::runtime::IUnknown);
impl IAssocHandler {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetName(&self) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetUIName(&self) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIconLocation(
        &self,
        ppszpath: *mut super::super::Foundation::PWSTR,
        pindex: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppszpath),
            ::std::mem::transmute(pindex),
        )
        .ok()
    }
    pub unsafe fn IsRecommended(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn MakeDefault<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszdescription: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pszdescription.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IDataObject>,
    >(
        &self,
        pdo: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pdo.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CreateInvoker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IDataObject>,
    >(
        &self,
        pdo: Param0,
    ) -> ::windows::runtime::Result<IAssocHandlerInvoker> {
        let mut result__: <IAssocHandlerInvoker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            pdo.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IAssocHandlerInvoker>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAssocHandler {
    type Vtable = IAssocHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4030751148,
        5721,
        19007,
        [169, 84, 119, 90, 165, 127, 192, 131],
    );
}
impl ::std::convert::From<IAssocHandler> for ::windows::runtime::IUnknown {
    fn from(value: IAssocHandler) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAssocHandler> for ::windows::runtime::IUnknown {
    fn from(value: &IAssocHandler) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAssocHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAssocHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandler_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsz: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsz: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppszpath: *mut super::super::Foundation::PWSTR,
        pindex: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszdescription: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdo: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdo: ::windows::runtime::RawPtr,
        ppinvoker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAssocHandlerInvoker(::windows::runtime::IUnknown);
impl IAssocHandlerInvoker {
    pub unsafe fn SupportsSelection(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Invoke(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAssocHandlerInvoker {
    type Vtable = IAssocHandlerInvoker_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2451672235,
        60586,
        17205,
        [129, 51, 128, 127, 210, 52, 194, 238],
    );
}
impl ::std::convert::From<IAssocHandlerInvoker> for ::windows::runtime::IUnknown {
    fn from(value: IAssocHandlerInvoker) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAssocHandlerInvoker> for ::windows::runtime::IUnknown {
    fn from(value: &IAssocHandlerInvoker) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAssocHandlerInvoker {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAssocHandlerInvoker {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAssocHandlerInvoker_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAttachmentExecute(::windows::runtime::IUnknown);
impl IAttachmentExecute {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetClientTitle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztitle: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            psztitle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetClientGuid(
        &self,
        guid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(guid),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetLocalPath<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszlocalpath: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            pszlocalpath.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFileName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszfilename: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            pszfilename.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSource<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszsource: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pszsource.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetReferrer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pszreferrer: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pszreferrer.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CheckPolicy(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Prompt<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
        prompt: ATTACHMENT_PROMPT,
    ) -> ::windows::runtime::Result<ATTACHMENT_ACTION> {
        let mut result__: <ATTACHMENT_ACTION as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(prompt),
            &mut result__,
        )
        .from_abi::<ATTACHMENT_ACTION>(result__)
    }
    pub unsafe fn Save(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Execute<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hwnd: Param0,
        pszverb: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            pszverb.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SaveWithUI<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ClearClientState(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAttachmentExecute {
    type Vtable = IAttachmentExecute_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1943736897,
        7813,
        17793,
        [142, 79, 168, 30, 29, 15, 140, 87],
    );
}
impl ::std::convert::From<IAttachmentExecute> for ::windows::runtime::IUnknown {
    fn from(value: IAttachmentExecute) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAttachmentExecute> for ::windows::runtime::IUnknown {
    fn from(value: &IAttachmentExecute) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAttachmentExecute {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAttachmentExecute {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAttachmentExecute_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztitle: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        guid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszlocalpath: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfilename: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszsource: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszreferrer: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        prompt: ATTACHMENT_PROMPT,
        paction: *mut ATTACHMENT_ACTION,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        pszverb: super::super::Foundation::PWSTR,
        phprocess: *mut super::super::Foundation::HANDLE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAutoComplete(::windows::runtime::IUnknown);
impl IAutoComplete {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hwndedit: Param0,
        punkacl: Param1,
        pwszregkeypath: Param2,
        pwszquickcomplete: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hwndedit.into_param().abi(),
            punkacl.into_param().abi(),
            pwszregkeypath.into_param().abi(),
            pwszquickcomplete.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fenable: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            fenable.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAutoComplete {
    type Vtable = IAutoComplete_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        12265314,
        27255,
        4560,
        [165, 53, 0, 192, 79, 215, 208, 98],
    );
}
impl ::std::convert::From<IAutoComplete> for ::windows::runtime::IUnknown {
    fn from(value: IAutoComplete) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAutoComplete> for ::windows::runtime::IUnknown {
    fn from(value: &IAutoComplete) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAutoComplete {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAutoComplete {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndedit: super::super::Foundation::HWND,
        punkacl: ::windows::runtime::RawPtr,
        pwszregkeypath: super::super::Foundation::PWSTR,
        pwszquickcomplete: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fenable: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAutoComplete2(::windows::runtime::IUnknown);
impl IAutoComplete2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Init<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hwndedit: Param0,
        punkacl: Param1,
        pwszregkeypath: Param2,
        pwszquickcomplete: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hwndedit.into_param().abi(),
            punkacl.into_param().abi(),
            pwszregkeypath.into_param().abi(),
            pwszquickcomplete.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Enable<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fenable: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            fenable.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetOptions(&self, dwflag: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflag),
        )
        .ok()
    }
    pub unsafe fn GetOptions(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAutoComplete2 {
    type Vtable = IAutoComplete2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3938470848,
        14225,
        4562,
        [187, 149, 0, 96, 151, 123, 70, 76],
    );
}
impl ::std::convert::From<IAutoComplete2> for ::windows::runtime::IUnknown {
    fn from(value: IAutoComplete2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAutoComplete2> for ::windows::runtime::IUnknown {
    fn from(value: &IAutoComplete2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAutoComplete2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAutoComplete2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IAutoComplete2> for IAutoComplete {
    fn from(value: IAutoComplete2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAutoComplete2> for IAutoComplete {
    fn from(value: &IAutoComplete2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAutoComplete> for IAutoComplete2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAutoComplete> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IAutoComplete>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IAutoComplete> for &IAutoComplete2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IAutoComplete> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IAutoComplete>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoComplete2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndedit: super::super::Foundation::HWND,
        punkacl: ::windows::runtime::RawPtr,
        pwszregkeypath: super::super::Foundation::PWSTR,
        pwszquickcomplete: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fenable: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflag: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflag: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAutoCompleteDropDown(::windows::runtime::IUnknown);
impl IAutoCompleteDropDown {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDropDownStatus(
        &self,
        pdwflags: *mut u32,
        ppwszstring: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdwflags),
            ::std::mem::transmute(ppwszstring),
        )
        .ok()
    }
    pub unsafe fn ResetEnumerator(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAutoCompleteDropDown {
    type Vtable = IAutoCompleteDropDown_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1020346868,
        15466,
        4562,
        [188, 170, 0, 192, 79, 217, 41, 219],
    );
}
impl ::std::convert::From<IAutoCompleteDropDown> for ::windows::runtime::IUnknown {
    fn from(value: IAutoCompleteDropDown) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAutoCompleteDropDown> for ::windows::runtime::IUnknown {
    fn from(value: &IAutoCompleteDropDown) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAutoCompleteDropDown {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IAutoCompleteDropDown
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAutoCompleteDropDown_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflags: *mut u32,
        ppwszstring: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBandHost(::windows::runtime::IUnknown);
impl IBandHost {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateBand<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
        T: ::windows::runtime::Interface,
    >(
        &self,
        rclsidband: *const ::windows::runtime::GUID,
        favailable: Param1,
        fvisible: Param2,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsidband),
            favailable.into_param().abi(),
            fvisible.into_param().abi(),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBandAvailability<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        rclsidband: *const ::windows::runtime::GUID,
        favailable: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsidband),
            favailable.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DestroyBand(
        &self,
        rclsidband: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsidband),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IBandHost {
    type Vtable = IBandHost_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3104267388,
        54414,
        16447,
        [171, 153, 214, 199, 122, 16, 132, 172],
    );
}
impl ::std::convert::From<IBandHost> for ::windows::runtime::IUnknown {
    fn from(value: IBandHost) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBandHost> for ::windows::runtime::IUnknown {
    fn from(value: &IBandHost) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBandHost {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBandHost {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandHost_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsidband: *const ::windows::runtime::GUID,
        favailable: super::super::Foundation::BOOL,
        fvisible: super::super::Foundation::BOOL,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsidband: *const ::windows::runtime::GUID,
        favailable: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsidband: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBandSite(::windows::runtime::IUnknown);
impl IBandSite {
    pub unsafe fn AddBand<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        punk: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            punk.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn EnumBands(&self, uband: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uband),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryBand(
        &self,
        dwbandid: u32,
        ppstb: *mut ::std::option::Option<IDeskBand>,
        pdwstate: *mut u32,
        pszname: super::super::Foundation::PWSTR,
        cchname: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwbandid),
            ::std::mem::transmute(ppstb),
            ::std::mem::transmute(pdwstate),
            ::std::mem::transmute(pszname),
            ::std::mem::transmute(cchname),
        )
        .ok()
    }
    pub unsafe fn SetBandState(
        &self,
        dwbandid: u32,
        dwmask: u32,
        dwstate: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwbandid),
            ::std::mem::transmute(dwmask),
            ::std::mem::transmute(dwstate),
        )
        .ok()
    }
    pub unsafe fn RemoveBand(&self, dwbandid: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwbandid),
        )
        .ok()
    }
    pub unsafe fn GetBandObject<T: ::windows::runtime::Interface>(
        &self,
        dwbandid: u32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwbandid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn SetBandSiteInfo(
        &self,
        pbsinfo: *const BANDSITEINFO,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pbsinfo),
        )
        .ok()
    }
    pub unsafe fn GetBandSiteInfo(
        &self,
        pbsinfo: *mut BANDSITEINFO,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pbsinfo),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IBandSite {
    type Vtable = IBandSite_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1291125936,
        56982,
        4560,
        [139, 63, 0, 160, 201, 17, 232, 229],
    );
}
impl ::std::convert::From<IBandSite> for ::windows::runtime::IUnknown {
    fn from(value: IBandSite) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBandSite> for ::windows::runtime::IUnknown {
    fn from(value: &IBandSite) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBandSite {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBandSite {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBandSite_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punk: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uband: u32,
        pdwbandid: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwbandid: u32,
        ppstb: *mut ::windows::runtime::RawPtr,
        pdwstate: *mut u32,
        pszname: super::super::Foundation::PWSTR,
        cchname: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwbandid: u32,
        dwmask: u32,
        dwstate: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwbandid: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwbandid: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbsinfo: *const BANDSITEINFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbsinfo: *mut BANDSITEINFO,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBannerNotificationHandler(::windows::runtime::IUnknown);
impl IBannerNotificationHandler {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnBannerEvent(
        &self,
        notification: *const BANNER_NOTIFICATION,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(notification),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IBannerNotificationHandler {
    type Vtable = IBannerNotificationHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2373659559,
        56069,
        18088,
        [130, 60, 210, 182, 222, 8, 238, 145],
    );
}
impl ::std::convert::From<IBannerNotificationHandler> for ::windows::runtime::IUnknown {
    fn from(value: IBannerNotificationHandler) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBannerNotificationHandler> for ::windows::runtime::IUnknown {
    fn from(value: &IBannerNotificationHandler) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IBannerNotificationHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IBannerNotificationHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBannerNotificationHandler_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        notification: *const BANNER_NOTIFICATION,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBanneredBar(::windows::runtime::IUnknown);
impl IBanneredBar {
    pub unsafe fn SetIconSize(&self, iicon: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(iicon),
        )
        .ok()
    }
    pub unsafe fn GetIconSize(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn SetBitmap<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Graphics::Gdi::HBITMAP>,
    >(
        &self,
        hbitmap: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            hbitmap.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmap(
        &self,
    ) -> ::windows::runtime::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__: <super::super::Graphics::Gdi::HBITMAP as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IBanneredBar {
    type Vtable = IBanneredBar_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1500158612,
        318,
        4561,
        [141, 52, 0, 160, 201, 15, 39, 25],
    );
}
impl ::std::convert::From<IBanneredBar> for ::windows::runtime::IUnknown {
    fn from(value: IBanneredBar) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBanneredBar> for ::windows::runtime::IUnknown {
    fn from(value: &IBanneredBar) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBanneredBar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBanneredBar {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBanneredBar_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iicon: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        piicon: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hbitmap: super::super::Graphics::Gdi::HBITMAP,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phbitmap: *mut super::super::Graphics::Gdi::HBITMAP,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBrowserFrameOptions(::windows::runtime::IUnknown);
impl IBrowserFrameOptions {
    pub unsafe fn GetFrameOptions(&self, dwmask: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmask),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IBrowserFrameOptions {
    type Vtable = IBrowserFrameOptions_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        283067336,
        7614,
        4563,
        [139, 52, 0, 96, 151, 223, 91, 212],
    );
}
impl ::std::convert::From<IBrowserFrameOptions> for ::windows::runtime::IUnknown {
    fn from(value: IBrowserFrameOptions) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserFrameOptions> for ::windows::runtime::IUnknown {
    fn from(value: &IBrowserFrameOptions) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBrowserFrameOptions {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBrowserFrameOptions {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserFrameOptions_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmask: u32,
        pdwoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBrowserService(::windows::runtime::IUnknown);
impl IBrowserService {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParentSite(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleInPlaceSite> {
        let mut result__ : < super::super::System::Com:: IOleInPlaceSite as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleInPlaceSite>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetTitle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psv: Param0,
        pszname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            pszname.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTitle<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pszname),
            ::std::mem::transmute(cchname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetOleObject(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleObject> {
        let mut result__: <super::super::System::Com::IOleObject as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::runtime::Result<ITravelLog> {
        let mut result__: <ITravelLog as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITravelLog>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        id: u32,
        fshow: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            fshow.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(
        &self,
        id: u32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEGetDisplayName(
        &self,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(pwszname),
            ::std::mem::transmute(uflags),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEParseDisplayName<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        uicp: u32,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicp),
            pwszpath.into_param().abi(),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hres: ::windows::runtime::HRESULT,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(hres),
            pwszpath.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToPidl(
        &self,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfhlnf),
        )
        .ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bnstate),
        )
        .ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::runtime::Result<BNSTATE> {
        let mut result__: <BNSTATE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<BNSTATE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pidl),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwflagmask),
        )
        .ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetPidl(&self) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    pub unsafe fn SetReferrer(&self, pidl: *const ITEMIDLIST) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetBrowserByIndex(
        &self,
        dwid: u32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub unsafe fn GetHistoryObject(
        &self,
        ppole: *mut ::std::option::Option<super::super::System::Com::IOleObject>,
        pstm: *mut ::std::option::Option<super::super::Storage::StructuredStorage::IStream>,
        ppbc: *mut ::std::option::Option<super::super::System::Com::IBindCtx>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppole),
            ::std::mem::transmute(pstm),
            ::std::mem::transmute(ppbc),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn SetHistoryObject<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pole: Param0,
        fislocalanchor: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
            fislocalanchor.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CacheOLEServer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
    >(
        &self,
        pole: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetSetCodePage(
        &self,
        pvarin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pvarin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn OnHttpEquiv<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        psv: Param0,
        fdone: Param1,
        pvarargin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            fdone.into_param().abi(),
            ::std::mem::transmute(pvarargin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(
        &self,
    ) -> ::windows::runtime::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: <super::super::Graphics::Gdi::HPALETTE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fforceregister: Param0,
        swc: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            fforceregister.into_param().abi(),
            ::std::mem::transmute(swc),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IBrowserService {
    type Vtable = IBrowserService_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        45759314,
        1351,
        4561,
        [184, 51, 0, 192, 79, 201, 179, 31],
    );
}
impl ::std::convert::From<IBrowserService> for ::windows::runtime::IUnknown {
    fn from(value: IBrowserService) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService> for ::windows::runtime::IUnknown {
    fn from(value: &IBrowserService) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBrowserService {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBrowserService {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppipsite: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppobjv: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pptl: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        fshow: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        pfshown: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicp: u32,
        pwszpath: super::super::Foundation::PWSTR,
        ppidlout: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hres: ::windows::runtime::HRESULT,
        pwszpath: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bnstate: BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbnstate: *mut BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pfdidbrowse: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        dwflagmask: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflags: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppidl: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwid: u32,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppole: *mut ::windows::runtime::RawPtr,
        pstm: *mut ::windows::runtime::RawPtr,
        ppbc: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
        fislocalanchor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvarin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        fdone: super::super::Foundation::BOOL,
        pvarargin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarargout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hpal: *mut super::super::Graphics::Gdi::HPALETTE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fforceregister: super::super::Foundation::BOOL,
        swc: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBrowserService2(::windows::runtime::IUnknown);
impl IBrowserService2 {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParentSite(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleInPlaceSite> {
        let mut result__ : < super::super::System::Com:: IOleInPlaceSite as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleInPlaceSite>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetTitle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psv: Param0,
        pszname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            pszname.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTitle<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pszname),
            ::std::mem::transmute(cchname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetOleObject(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleObject> {
        let mut result__: <super::super::System::Com::IOleObject as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::runtime::Result<ITravelLog> {
        let mut result__: <ITravelLog as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITravelLog>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        id: u32,
        fshow: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            fshow.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(
        &self,
        id: u32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEGetDisplayName(
        &self,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(pwszname),
            ::std::mem::transmute(uflags),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEParseDisplayName<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        uicp: u32,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicp),
            pwszpath.into_param().abi(),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hres: ::windows::runtime::HRESULT,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(hres),
            pwszpath.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToPidl(
        &self,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfhlnf),
        )
        .ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bnstate),
        )
        .ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::runtime::Result<BNSTATE> {
        let mut result__: <BNSTATE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<BNSTATE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pidl),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwflagmask),
        )
        .ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetPidl(&self) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    pub unsafe fn SetReferrer(&self, pidl: *const ITEMIDLIST) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetBrowserByIndex(
        &self,
        dwid: u32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub unsafe fn GetHistoryObject(
        &self,
        ppole: *mut ::std::option::Option<super::super::System::Com::IOleObject>,
        pstm: *mut ::std::option::Option<super::super::Storage::StructuredStorage::IStream>,
        ppbc: *mut ::std::option::Option<super::super::System::Com::IBindCtx>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppole),
            ::std::mem::transmute(pstm),
            ::std::mem::transmute(ppbc),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn SetHistoryObject<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pole: Param0,
        fislocalanchor: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
            fislocalanchor.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CacheOLEServer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
    >(
        &self,
        pole: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetSetCodePage(
        &self,
        pvarin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pvarin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn OnHttpEquiv<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        psv: Param0,
        fdone: Param1,
        pvarargin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            fdone.into_param().abi(),
            ::std::mem::transmute(pvarargin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(
        &self,
    ) -> ::windows::runtime::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: <super::super::Graphics::Gdi::HPALETTE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fforceregister: Param0,
        swc: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            fforceregister.into_param().abi(),
            ::std::mem::transmute(swc),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        umsg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
    >(
        &self,
        wparam: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            wparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(
        &self,
        pcs: *const super::WindowsAndMessaging::CREATESTRUCTW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcs),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        wparam: Param0,
        lparam: Param1,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(
        &self,
        pnm: *const super::Controls::NMHDR,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pnm),
        ))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        factive: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            factive.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).44)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateViewWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, IShellView>,
    >(
        &self,
        psvnew: Param0,
        psvold: Param1,
        prcview: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<super::super::Foundation::HWND> {
        let mut result__: <super::super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            psvnew.into_param().abi(),
            psvold.into_param().abi(),
            ::std::mem::transmute(prcview),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(
        &self,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::HWND> {
        let mut result__: <super::super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::runtime::Result<*mut BASEBROWSERDATALH> {
        let mut result__: <*mut BASEBROWSERDATALH as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn InitializeTravelLog<'a, Param0: ::windows::runtime::IntoParam<'a, ITravelLog>>(
        &self,
        ptl: Param0,
        dw: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ptl.into_param().abi(),
            ::std::mem::transmute(dw),
        )
        .ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(icmd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        f: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            f.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(u),
        )
        .ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(esecurelock),
        )
        .ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).56)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).57)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        hwnd: Param0,
        pauto: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            pauto.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).60)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fpaused: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            fpaused.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _NavigateToPidl2(
        &self,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
        dwflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfhlnf),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    pub unsafe fn _TryShell2Rename<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pidlnew: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pidlnew),
        )
        .ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn _ExecChildren<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        punkbar: Param0,
        fbroadcast: Param1,
        pguidcmdgroup: *const ::windows::runtime::GUID,
        ncmdid: u32,
        ncmdexecopt: u32,
        pvarargin: *const super::super::System::OleAutomation::VARIANT,
        pvarargout: *mut super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            punkbar.into_param().abi(),
            fbroadcast.into_param().abi(),
            ::std::mem::transmute(pguidcmdgroup),
            ::std::mem::transmute(ncmdid),
            ::std::mem::transmute(ncmdexecopt),
            ::std::mem::transmute(pvarargin),
            ::std::mem::transmute(pvarargout),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwndbar: Param0,
        fbroadcast: Param1,
        umsg: u32,
        wparam: Param3,
        lparam: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            hwndbar.into_param().abi(),
            fbroadcast.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetFolderSetData(
        &self,
        pfsd: *mut FOLDERSETDATA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pfsd),
        )
        .ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fchildonly: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            fchildonly.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itblastfocus),
        )
        .ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ustate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(
        &self,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prc),
        )
        .ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).76)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        )
        .ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).78)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>,
    >(
        &self,
        lprectborder: *mut super::super::Foundation::RECT,
        hmon: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lprectborder),
            hmon.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn v_GetViewStream<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pidl: *mut ITEMIDLIST,
        grfmode: u32,
        pwszname: Param2,
    ) -> ::std::option::Option<super::super::Storage::StructuredStorage::IStream> {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfmode),
            pwszname.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        umsg: u32,
        wparam: Param1,
        lparam: Param2,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HACCEL>,
    >(
        &self,
        hacc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            hacc.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        ))
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn _SaveToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pstm: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            pstm.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn _LoadToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pstm: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            pstm.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fclose: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            fclose.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn v_MayGetNextToolbarFocus(
        &self,
        lpmsg: *const super::WindowsAndMessaging::MSG,
        itbnext: u32,
        citb: i32,
        pptbi: *mut *mut TOOLBARITEM,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lpmsg),
            ::std::mem::transmute(itbnext),
            ::std::mem::transmute(citb),
            ::std::mem::transmute(pptbi),
            ::std::mem::transmute(phwnd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        itb: u32,
        busehmonitor: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
            busehmonitor.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _FindTBar<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        punksrc: Param0,
    ) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).90)(
            ::std::mem::transmute_copy(self),
            punksrc.into_param().abi(),
        ))
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn _SetFocus<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        ptbi: *const TOOLBARITEM,
        hwnd: Param1,
        lpmsg: *const super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).91)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ptbi),
            hwnd.into_param().abi(),
            ::std::mem::transmute(lpmsg),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(
        &self,
        pmsg: *mut super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).92)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pmsg),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        punksrc: Param0,
        lprectborder: *mut super::super::Foundation::RECT,
        busehmonitor: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).93)(
            ::std::mem::transmute_copy(self),
            punksrc.into_param().abi(),
            ::std::mem::transmute(lprectborder),
            busehmonitor.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn v_CheckZoneCrossing(
        &self,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).94)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IBrowserService2 {
    type Vtable = IBrowserService2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1757225420,
        17291,
        4562,
        [165, 96, 0, 160, 201, 45, 191, 232],
    );
}
impl ::std::convert::From<IBrowserService2> for ::windows::runtime::IUnknown {
    fn from(value: IBrowserService2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService2> for ::windows::runtime::IUnknown {
    fn from(value: &IBrowserService2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBrowserService2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBrowserService2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IBrowserService2> for IBrowserService {
    fn from(value: IBrowserService2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService2> for IBrowserService {
    fn from(value: &IBrowserService2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService> for IBrowserService2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService> for &IBrowserService2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppipsite: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppobjv: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pptl: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        fshow: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        pfshown: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicp: u32,
        pwszpath: super::super::Foundation::PWSTR,
        ppidlout: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hres: ::windows::runtime::HRESULT,
        pwszpath: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bnstate: BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbnstate: *mut BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pfdidbrowse: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        dwflagmask: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflags: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppidl: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwid: u32,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppole: *mut ::windows::runtime::RawPtr,
        pstm: *mut ::windows::runtime::RawPtr,
        ppbc: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
        fislocalanchor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvarin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        fdone: super::super::Foundation::BOOL,
        pvarargin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarargout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hpal: *mut super::super::Graphics::Gdi::HPALETTE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fforceregister: super::super::Foundation::BOOL,
        swc: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wparam: super::super::Foundation::WPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcs: *const super::WindowsAndMessaging::CREATESTRUCTW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pnm: *const super::Controls::NMHDR,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factive: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psvnew: ::windows::runtime::RawPtr,
        psvold: ::windows::runtime::RawPtr,
        prcview: *const super::super::Foundation::RECT,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phwndview: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbbd: *mut *mut BASEBROWSERDATALH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
    ) -> *mut ::std::mem::ManuallyDrop<BASEBROWSERDATALH>,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptl: ::windows::runtime::RawPtr,
        dw: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        icmd: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        f: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        u: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        esecurelock: i32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        pauto: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fpaused: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
        dwflags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pidlnew: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punkbar: ::windows::runtime::RawPtr,
        fbroadcast: super::super::Foundation::BOOL,
        pguidcmdgroup: *const ::windows::runtime::GUID,
        ncmdid: u32,
        ncmdexecopt: u32,
        pvarargin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarargout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndbar: super::super::Foundation::HWND,
        fbroadcast: super::super::Foundation::BOOL,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfsd: *mut FOLDERSETDATA,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fchildonly: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itblastfocus: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ustate: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lprectborder: *mut super::super::Foundation::RECT,
        hmon: super::super::Graphics::Gdi::HMONITOR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *mut ITEMIDLIST,
        grfmode: u32,
        pwszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::RawPtr,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hacc: super::WindowsAndMessaging::HACCEL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> i32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: i32,
    ) -> *mut ::std::mem::ManuallyDrop<TOOLBARITEM>,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstm: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstm: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fclose: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpmsg: *const super::WindowsAndMessaging::MSG,
        itbnext: u32,
        citb: i32,
        pptbi: *mut *mut TOOLBARITEM,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
        busehmonitor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punksrc: ::windows::runtime::RawPtr,
    ) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptbi: *const ::std::mem::ManuallyDrop<TOOLBARITEM>,
        hwnd: super::super::Foundation::HWND,
        lpmsg: *const super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pmsg: *mut super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punksrc: ::windows::runtime::RawPtr,
        lprectborder: *mut super::super::Foundation::RECT,
        busehmonitor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBrowserService3(::windows::runtime::IUnknown);
impl IBrowserService3 {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParentSite(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleInPlaceSite> {
        let mut result__ : < super::super::System::Com:: IOleInPlaceSite as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleInPlaceSite>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetTitle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psv: Param0,
        pszname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            pszname.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTitle<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pszname),
            ::std::mem::transmute(cchname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetOleObject(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleObject> {
        let mut result__: <super::super::System::Com::IOleObject as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::runtime::Result<ITravelLog> {
        let mut result__: <ITravelLog as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITravelLog>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        id: u32,
        fshow: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            fshow.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(
        &self,
        id: u32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEGetDisplayName(
        &self,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(pwszname),
            ::std::mem::transmute(uflags),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEParseDisplayName<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        uicp: u32,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicp),
            pwszpath.into_param().abi(),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hres: ::windows::runtime::HRESULT,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(hres),
            pwszpath.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToPidl(
        &self,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfhlnf),
        )
        .ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bnstate),
        )
        .ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::runtime::Result<BNSTATE> {
        let mut result__: <BNSTATE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<BNSTATE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pidl),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwflagmask),
        )
        .ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetPidl(&self) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    pub unsafe fn SetReferrer(&self, pidl: *const ITEMIDLIST) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetBrowserByIndex(
        &self,
        dwid: u32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub unsafe fn GetHistoryObject(
        &self,
        ppole: *mut ::std::option::Option<super::super::System::Com::IOleObject>,
        pstm: *mut ::std::option::Option<super::super::Storage::StructuredStorage::IStream>,
        ppbc: *mut ::std::option::Option<super::super::System::Com::IBindCtx>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppole),
            ::std::mem::transmute(pstm),
            ::std::mem::transmute(ppbc),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn SetHistoryObject<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pole: Param0,
        fislocalanchor: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
            fislocalanchor.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CacheOLEServer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
    >(
        &self,
        pole: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetSetCodePage(
        &self,
        pvarin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pvarin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn OnHttpEquiv<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        psv: Param0,
        fdone: Param1,
        pvarargin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            fdone.into_param().abi(),
            ::std::mem::transmute(pvarargin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(
        &self,
    ) -> ::windows::runtime::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: <super::super::Graphics::Gdi::HPALETTE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fforceregister: Param0,
        swc: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            fforceregister.into_param().abi(),
            ::std::mem::transmute(swc),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        umsg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
    >(
        &self,
        wparam: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            wparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(
        &self,
        pcs: *const super::WindowsAndMessaging::CREATESTRUCTW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcs),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        wparam: Param0,
        lparam: Param1,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(
        &self,
        pnm: *const super::Controls::NMHDR,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pnm),
        ))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        factive: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            factive.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).44)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateViewWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, IShellView>,
    >(
        &self,
        psvnew: Param0,
        psvold: Param1,
        prcview: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<super::super::Foundation::HWND> {
        let mut result__: <super::super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            psvnew.into_param().abi(),
            psvold.into_param().abi(),
            ::std::mem::transmute(prcview),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(
        &self,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::HWND> {
        let mut result__: <super::super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::runtime::Result<*mut BASEBROWSERDATALH> {
        let mut result__: <*mut BASEBROWSERDATALH as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn InitializeTravelLog<'a, Param0: ::windows::runtime::IntoParam<'a, ITravelLog>>(
        &self,
        ptl: Param0,
        dw: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ptl.into_param().abi(),
            ::std::mem::transmute(dw),
        )
        .ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(icmd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        f: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            f.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(u),
        )
        .ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(esecurelock),
        )
        .ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).56)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).57)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        hwnd: Param0,
        pauto: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            pauto.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).60)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fpaused: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            fpaused.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _NavigateToPidl2(
        &self,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
        dwflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfhlnf),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    pub unsafe fn _TryShell2Rename<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pidlnew: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pidlnew),
        )
        .ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn _ExecChildren<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        punkbar: Param0,
        fbroadcast: Param1,
        pguidcmdgroup: *const ::windows::runtime::GUID,
        ncmdid: u32,
        ncmdexecopt: u32,
        pvarargin: *const super::super::System::OleAutomation::VARIANT,
        pvarargout: *mut super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            punkbar.into_param().abi(),
            fbroadcast.into_param().abi(),
            ::std::mem::transmute(pguidcmdgroup),
            ::std::mem::transmute(ncmdid),
            ::std::mem::transmute(ncmdexecopt),
            ::std::mem::transmute(pvarargin),
            ::std::mem::transmute(pvarargout),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwndbar: Param0,
        fbroadcast: Param1,
        umsg: u32,
        wparam: Param3,
        lparam: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            hwndbar.into_param().abi(),
            fbroadcast.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetFolderSetData(
        &self,
        pfsd: *mut FOLDERSETDATA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pfsd),
        )
        .ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fchildonly: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            fchildonly.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itblastfocus),
        )
        .ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ustate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(
        &self,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prc),
        )
        .ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).76)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        )
        .ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).78)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>,
    >(
        &self,
        lprectborder: *mut super::super::Foundation::RECT,
        hmon: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lprectborder),
            hmon.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn v_GetViewStream<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pidl: *mut ITEMIDLIST,
        grfmode: u32,
        pwszname: Param2,
    ) -> ::std::option::Option<super::super::Storage::StructuredStorage::IStream> {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfmode),
            pwszname.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        umsg: u32,
        wparam: Param1,
        lparam: Param2,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HACCEL>,
    >(
        &self,
        hacc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            hacc.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        ))
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn _SaveToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pstm: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            pstm.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn _LoadToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pstm: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            pstm.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fclose: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            fclose.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn v_MayGetNextToolbarFocus(
        &self,
        lpmsg: *const super::WindowsAndMessaging::MSG,
        itbnext: u32,
        citb: i32,
        pptbi: *mut *mut TOOLBARITEM,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lpmsg),
            ::std::mem::transmute(itbnext),
            ::std::mem::transmute(citb),
            ::std::mem::transmute(pptbi),
            ::std::mem::transmute(phwnd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        itb: u32,
        busehmonitor: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
            busehmonitor.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _FindTBar<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        punksrc: Param0,
    ) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).90)(
            ::std::mem::transmute_copy(self),
            punksrc.into_param().abi(),
        ))
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn _SetFocus<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        ptbi: *const TOOLBARITEM,
        hwnd: Param1,
        lpmsg: *const super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).91)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ptbi),
            hwnd.into_param().abi(),
            ::std::mem::transmute(lpmsg),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(
        &self,
        pmsg: *mut super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).92)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pmsg),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        punksrc: Param0,
        lprectborder: *mut super::super::Foundation::RECT,
        busehmonitor: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).93)(
            ::std::mem::transmute_copy(self),
            punksrc.into_param().abi(),
            ::std::mem::transmute(lprectborder),
            busehmonitor.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn v_CheckZoneCrossing(
        &self,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).94)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
        prc: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).95)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(prc),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEParseDisplayNameEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        uicp: u32,
        pwszpath: Param1,
        dwflags: u32,
    ) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).96)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicp),
            pwszpath.into_param().abi(),
            ::std::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IBrowserService3 {
    type Vtable = IBrowserService3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        668454433,
        30253,
        18675,
        [134, 243, 64, 226, 253, 55, 73, 196],
    );
}
impl ::std::convert::From<IBrowserService3> for ::windows::runtime::IUnknown {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService3> for ::windows::runtime::IUnknown {
    fn from(value: &IBrowserService3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBrowserService3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBrowserService3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IBrowserService3> for IBrowserService2 {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService3> for IBrowserService2 {
    fn from(value: &IBrowserService3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService2> for IBrowserService3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService2> for &IBrowserService3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IBrowserService3> for IBrowserService {
    fn from(value: IBrowserService3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService3> for IBrowserService {
    fn from(value: &IBrowserService3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService> for IBrowserService3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService> for &IBrowserService3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppipsite: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppobjv: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pptl: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        fshow: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        pfshown: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicp: u32,
        pwszpath: super::super::Foundation::PWSTR,
        ppidlout: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hres: ::windows::runtime::HRESULT,
        pwszpath: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bnstate: BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbnstate: *mut BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pfdidbrowse: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        dwflagmask: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflags: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppidl: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwid: u32,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppole: *mut ::windows::runtime::RawPtr,
        pstm: *mut ::windows::runtime::RawPtr,
        ppbc: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
        fislocalanchor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvarin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        fdone: super::super::Foundation::BOOL,
        pvarargin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarargout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hpal: *mut super::super::Graphics::Gdi::HPALETTE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fforceregister: super::super::Foundation::BOOL,
        swc: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wparam: super::super::Foundation::WPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcs: *const super::WindowsAndMessaging::CREATESTRUCTW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pnm: *const super::Controls::NMHDR,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factive: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psvnew: ::windows::runtime::RawPtr,
        psvold: ::windows::runtime::RawPtr,
        prcview: *const super::super::Foundation::RECT,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phwndview: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbbd: *mut *mut BASEBROWSERDATALH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
    ) -> *mut ::std::mem::ManuallyDrop<BASEBROWSERDATALH>,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptl: ::windows::runtime::RawPtr,
        dw: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        icmd: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        f: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        u: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        esecurelock: i32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        pauto: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fpaused: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
        dwflags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pidlnew: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punkbar: ::windows::runtime::RawPtr,
        fbroadcast: super::super::Foundation::BOOL,
        pguidcmdgroup: *const ::windows::runtime::GUID,
        ncmdid: u32,
        ncmdexecopt: u32,
        pvarargin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarargout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndbar: super::super::Foundation::HWND,
        fbroadcast: super::super::Foundation::BOOL,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfsd: *mut FOLDERSETDATA,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fchildonly: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itblastfocus: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ustate: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lprectborder: *mut super::super::Foundation::RECT,
        hmon: super::super::Graphics::Gdi::HMONITOR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *mut ITEMIDLIST,
        grfmode: u32,
        pwszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::RawPtr,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hacc: super::WindowsAndMessaging::HACCEL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> i32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: i32,
    ) -> *mut ::std::mem::ManuallyDrop<TOOLBARITEM>,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstm: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstm: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fclose: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpmsg: *const super::WindowsAndMessaging::MSG,
        itbnext: u32,
        citb: i32,
        pptbi: *mut *mut TOOLBARITEM,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
        busehmonitor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punksrc: ::windows::runtime::RawPtr,
    ) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptbi: *const ::std::mem::ManuallyDrop<TOOLBARITEM>,
        hwnd: super::super::Foundation::HWND,
        lpmsg: *const super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pmsg: *mut super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punksrc: ::windows::runtime::RawPtr,
        lprectborder: *mut super::super::Foundation::RECT,
        busehmonitor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        prc: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicp: u32,
        pwszpath: super::super::Foundation::PWSTR,
        dwflags: u32,
        ppidlout: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBrowserService4(::windows::runtime::IUnknown);
impl IBrowserService4 {
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetParentSite(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleInPlaceSite> {
        let mut result__ : < super::super::System::Com:: IOleInPlaceSite as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleInPlaceSite>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetTitle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psv: Param0,
        pszname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            pszname.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetTitle<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pszname),
            ::std::mem::transmute(cchname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn GetOleObject(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IOleObject> {
        let mut result__: <super::super::System::Com::IOleObject as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IOleObject>(result__)
    }
    pub unsafe fn GetTravelLog(&self) -> ::windows::runtime::Result<ITravelLog> {
        let mut result__: <ITravelLog as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITravelLog>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ShowControlWindow<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        id: u32,
        fshow: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            fshow.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsControlWindowShown(
        &self,
        id: u32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(id),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEGetDisplayName(
        &self,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(pwszname),
            ::std::mem::transmute(uflags),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEParseDisplayName<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        uicp: u32,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicp),
            pwszpath.into_param().abi(),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayParseError<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hres: ::windows::runtime::HRESULT,
        pwszpath: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(hres),
            pwszpath.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToPidl(
        &self,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfhlnf),
        )
        .ok()
    }
    pub unsafe fn SetNavigateState(&self, bnstate: BNSTATE) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(bnstate),
        )
        .ok()
    }
    pub unsafe fn GetNavigateState(&self) -> ::windows::runtime::Result<BNSTATE> {
        let mut result__: <BNSTATE as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<BNSTATE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NotifyRedirect<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pidl),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn UpdateWindowList(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UpdateBackForwardState(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn SetFlags(&self, dwflags: u32, dwflagmask: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(dwflagmask),
        )
        .ok()
    }
    pub unsafe fn GetFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn CanNavigateNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetPidl(&self) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    pub unsafe fn SetReferrer(&self, pidl: *const ITEMIDLIST) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    pub unsafe fn GetBrowserIndex(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn GetBrowserByIndex(
        &self,
        dwid: u32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub unsafe fn GetHistoryObject(
        &self,
        ppole: *mut ::std::option::Option<super::super::System::Com::IOleObject>,
        pstm: *mut ::std::option::Option<super::super::Storage::StructuredStorage::IStream>,
        ppbc: *mut ::std::option::Option<super::super::System::Com::IBindCtx>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppole),
            ::std::mem::transmute(pstm),
            ::std::mem::transmute(ppbc),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub unsafe fn SetHistoryObject<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pole: Param0,
        fislocalanchor: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
            fislocalanchor.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn CacheOLEServer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::Com::IOleObject>,
    >(
        &self,
        pole: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            pole.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetSetCodePage(
        &self,
        pvarin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pvarin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn OnHttpEquiv<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        psv: Param0,
        fdone: Param1,
        pvarargin: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            fdone.into_param().abi(),
            ::std::mem::transmute(pvarargin),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetPalette(
        &self,
    ) -> ::windows::runtime::Result<super::super::Graphics::Gdi::HPALETTE> {
        let mut result__: <super::super::Graphics::Gdi::HPALETTE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Graphics::Gdi::HPALETTE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RegisterWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fforceregister: Param0,
        swc: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            fforceregister.into_param().abi(),
            ::std::mem::transmute(swc),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WndProcBS<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        umsg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    pub unsafe fn SetAsDefFolderSettings(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewRect(&self) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnSize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
    >(
        &self,
        wparam: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            wparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn OnCreate(
        &self,
        pcs: *const super::WindowsAndMessaging::CREATESTRUCTW,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcs),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnCommand<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        wparam: Param0,
        lparam: Param1,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    pub unsafe fn OnDestroy(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub unsafe fn OnNotify(
        &self,
        pnm: *const super::Controls::NMHDR,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pnm),
        ))
    }
    pub unsafe fn OnSetFocus(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnFrameWindowActivateBS<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        factive: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            factive.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ReleaseShellView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ActivatePendingView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).44)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CreateViewWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IShellView>,
        Param1: ::windows::runtime::IntoParam<'a, IShellView>,
    >(
        &self,
        psvnew: Param0,
        psvold: Param1,
        prcview: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<super::super::Foundation::HWND> {
        let mut result__: <super::super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            psvnew.into_param().abi(),
            psvold.into_param().abi(),
            ::std::mem::transmute(prcview),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HWND>(result__)
    }
    pub unsafe fn CreateBrowserPropSheetExt(
        &self,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewWindow(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::HWND> {
        let mut result__: <super::super::Foundation::HWND as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HWND>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub unsafe fn GetBaseBrowserData(&self) -> ::windows::runtime::Result<*mut BASEBROWSERDATALH> {
        let mut result__: <*mut BASEBROWSERDATALH as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut BASEBROWSERDATALH>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub unsafe fn PutBaseBrowserData(&self) -> *mut BASEBROWSERDATALH {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn InitializeTravelLog<'a, Param0: ::windows::runtime::IntoParam<'a, ITravelLog>>(
        &self,
        ptl: Param0,
        dw: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ptl.into_param().abi(),
            ::std::mem::transmute(dw),
        )
        .ok()
    }
    pub unsafe fn SetTopBrowser(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Offline(&self, icmd: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(icmd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AllowViewResize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        f: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            f.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetActivateState(&self, u: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(u),
        )
        .ok()
    }
    pub unsafe fn UpdateSecureLockIcon(&self, esecurelock: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(esecurelock),
        )
        .ok()
    }
    pub unsafe fn InitializeDownloadManager(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).56)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn InitializeTransitionSite(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).57)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _Initialize<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        hwnd: Param0,
        pauto: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            pauto.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _CancelPendingNavigationAsync(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _CancelPendingView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).60)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _MaySaveChanges(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PauseOrResumeView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fpaused: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            fpaused.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _DisableModeless(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _NavigateToPidl2(
        &self,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
        dwflags: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfhlnf),
            ::std::mem::transmute(dwflags),
        )
        .ok()
    }
    pub unsafe fn _TryShell2Rename<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        psv: Param0,
        pidlnew: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            psv.into_param().abi(),
            ::std::mem::transmute(pidlnew),
        )
        .ok()
    }
    pub unsafe fn _SwitchActivationNow(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn _ExecChildren<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        punkbar: Param0,
        fbroadcast: Param1,
        pguidcmdgroup: *const ::windows::runtime::GUID,
        ncmdid: u32,
        ncmdexecopt: u32,
        pvarargin: *const super::super::System::OleAutomation::VARIANT,
        pvarargout: *mut super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            punkbar.into_param().abi(),
            fbroadcast.into_param().abi(),
            ::std::mem::transmute(pguidcmdgroup),
            ::std::mem::transmute(ncmdid),
            ::std::mem::transmute(ncmdexecopt),
            ::std::mem::transmute(pvarargin),
            ::std::mem::transmute(pvarargout),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _SendChildren<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwndbar: Param0,
        fbroadcast: Param1,
        umsg: u32,
        wparam: Param3,
        lparam: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            hwndbar.into_param().abi(),
            fbroadcast.into_param().abi(),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetFolderSetData(
        &self,
        pfsd: *mut FOLDERSETDATA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pfsd),
        )
        .ok()
    }
    pub unsafe fn _OnFocusChange(&self, itb: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn v_ShowHideChildWindows<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fchildonly: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            fchildonly.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _get_itbLastFocus(&self) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
        ))
    }
    pub unsafe fn _put_itbLastFocus(&self, itblastfocus: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itblastfocus),
        )
        .ok()
    }
    pub unsafe fn _UIActivateView(&self, ustate: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ustate),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetViewBorderRect(
        &self,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(prc),
        )
        .ok()
    }
    pub unsafe fn _UpdateViewRectSize(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).76)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _ResizeNextBorder(&self, itb: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        )
        .ok()
    }
    pub unsafe fn _ResizeView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).78)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetEffectiveClientArea<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Graphics::Gdi::HMONITOR>,
    >(
        &self,
        lprectborder: *mut super::super::Foundation::RECT,
        hmon: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lprectborder),
            hmon.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn v_GetViewStream<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pidl: *mut ITEMIDLIST,
        grfmode: u32,
        pwszname: Param2,
    ) -> ::std::option::Option<super::super::Storage::StructuredStorage::IStream> {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
            ::std::mem::transmute(grfmode),
            pwszname.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ForwardViewMsg<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        umsg: u32,
        wparam: Param1,
        lparam: Param2,
    ) -> super::super::Foundation::LRESULT {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(umsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        ))
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetAcceleratorMenu<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HACCEL>,
    >(
        &self,
        hacc: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            hacc.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _GetToolbarCount(&self) -> i32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
        ))
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn _GetToolbarItem(&self, itb: i32) -> *mut TOOLBARITEM {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
        ))
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn _SaveToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pstm: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            pstm.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn _LoadToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Storage::StructuredStorage::IStream>,
    >(
        &self,
        pstm: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            pstm.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _CloseAndReleaseToolbars<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fclose: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            fclose.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn v_MayGetNextToolbarFocus(
        &self,
        lpmsg: *const super::WindowsAndMessaging::MSG,
        itbnext: u32,
        citb: i32,
        pptbi: *mut *mut TOOLBARITEM,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(lpmsg),
            ::std::mem::transmute(itbnext),
            ::std::mem::transmute(citb),
            ::std::mem::transmute(pptbi),
            ::std::mem::transmute(phwnd),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _ResizeNextBorderHelper<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        itb: u32,
        busehmonitor: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itb),
            busehmonitor.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn _FindTBar<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        punksrc: Param0,
    ) -> u32 {
        ::std::mem::transmute((::windows::runtime::Interface::vtable(self).90)(
            ::std::mem::transmute_copy(self),
            punksrc.into_param().abi(),
        ))
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn _SetFocus<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        ptbi: *const TOOLBARITEM,
        hwnd: Param1,
        lpmsg: *const super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).91)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ptbi),
            hwnd.into_param().abi(),
            ::std::mem::transmute(lpmsg),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn v_MayTranslateAccelerator(
        &self,
        pmsg: *mut super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).92)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pmsg),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _GetBorderDWHelper<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        punksrc: Param0,
        lprectborder: *mut super::super::Foundation::RECT,
        busehmonitor: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).93)(
            ::std::mem::transmute_copy(self),
            punksrc.into_param().abi(),
            ::std::mem::transmute(lprectborder),
            busehmonitor.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn v_CheckZoneCrossing(
        &self,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).94)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn _PositionViewWindow<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
        prc: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).95)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(prc),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IEParseDisplayNameEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        uicp: u32,
        pwszpath: Param1,
        dwflags: u32,
    ) -> ::windows::runtime::Result<*mut ITEMIDLIST> {
        let mut result__: <*mut ITEMIDLIST as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).96)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uicp),
            pwszpath.into_param().abi(),
            ::std::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<*mut ITEMIDLIST>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ActivateView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        fpendingview: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).97)(
            ::std::mem::transmute_copy(self),
            fpendingview.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SaveViewState(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).98)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn _ResizeAllBorders(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).99)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IBrowserService4 {
    type Vtable = IBrowserService4_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1671371775,
        57653,
        16534,
        [171, 216, 224, 245, 4, 214, 73, 164],
    );
}
impl ::std::convert::From<IBrowserService4> for ::windows::runtime::IUnknown {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService4> for ::windows::runtime::IUnknown {
    fn from(value: &IBrowserService4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IBrowserService4> for IBrowserService3 {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService4> for IBrowserService3 {
    fn from(value: &IBrowserService4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService3> for IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService3> for &IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IBrowserService4> for IBrowserService2 {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService4> for IBrowserService2 {
    fn from(value: &IBrowserService4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService2> for IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService2> for &IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IBrowserService4> for IBrowserService {
    fn from(value: IBrowserService4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBrowserService4> for IBrowserService {
    fn from(value: &IBrowserService4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService> for IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IBrowserService> for &IBrowserService4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IBrowserService> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IBrowserService>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBrowserService4_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppipsite: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pszname: super::super::Foundation::PWSTR,
        cchname: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppobjv: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pptl: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        fshow: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        id: u32,
        pfshown: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pwszname: super::super::Foundation::PWSTR,
        uflags: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicp: u32,
        pwszpath: super::super::Foundation::PWSTR,
        ppidlout: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hres: ::windows::runtime::HRESULT,
        pwszpath: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bnstate: BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbnstate: *mut BNSTATE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        pfdidbrowse: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        dwflagmask: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflags: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppidl: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwid: u32,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppole: *mut ::windows::runtime::RawPtr,
        pstm: *mut ::windows::runtime::RawPtr,
        ppbc: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_System_Com"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_Com"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
        fislocalanchor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_Com")))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pole: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvarin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        fdone: super::super::Foundation::BOOL,
        pvarargin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarargout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hpal: *mut super::super::Graphics::Gdi::HPALETTE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fforceregister: super::super::Foundation::BOOL,
        swc: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wparam: super::super::Foundation::WPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcs: *const super::WindowsAndMessaging::CREATESTRUCTW,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pnm: *const super::Controls::NMHDR,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_Controls")))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factive: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psvnew: ::windows::runtime::RawPtr,
        psvold: ::windows::runtime::RawPtr,
        prcview: *const super::super::Foundation::RECT,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phwndview: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbbd: *mut *mut BASEBROWSERDATALH,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
    ) -> *mut ::std::mem::ManuallyDrop<BASEBROWSERDATALH>,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_Com",
        feature = "Win32_System_WindowsProgramming"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptl: ::windows::runtime::RawPtr,
        dw: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        icmd: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        f: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        u: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        esecurelock: i32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        pauto: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fpaused: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
        grfhlnf: u32,
        dwflags: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psv: ::windows::runtime::RawPtr,
        pidlnew: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punkbar: ::windows::runtime::RawPtr,
        fbroadcast: super::super::Foundation::BOOL,
        pguidcmdgroup: *const ::windows::runtime::GUID,
        ncmdid: u32,
        ncmdexecopt: u32,
        pvarargin: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarargout: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwndbar: super::super::Foundation::HWND,
        fbroadcast: super::super::Foundation::BOOL,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfsd: *mut FOLDERSETDATA,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fchildonly: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itblastfocus: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ustate: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lprectborder: *mut super::super::Foundation::RECT,
        hmon: super::super::Graphics::Gdi::HMONITOR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *mut ITEMIDLIST,
        grfmode: u32,
        pwszname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::RawPtr,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        umsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> super::super::Foundation::LRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hacc: super::WindowsAndMessaging::HACCEL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> i32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: i32,
    ) -> *mut ::std::mem::ManuallyDrop<TOOLBARITEM>,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstm: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstm: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fclose: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        lpmsg: *const super::WindowsAndMessaging::MSG,
        itbnext: u32,
        citb: i32,
        pptbi: *mut *mut TOOLBARITEM,
        phwnd: *mut super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itb: u32,
        busehmonitor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punksrc: ::windows::runtime::RawPtr,
    ) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ptbi: *const ::std::mem::ManuallyDrop<TOOLBARITEM>,
        hwnd: super::super::Foundation::HWND,
        lpmsg: *const super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Graphics_Gdi",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pmsg: *mut super::WindowsAndMessaging::MSG,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        punksrc: ::windows::runtime::RawPtr,
        lprectborder: *mut super::super::Foundation::RECT,
        busehmonitor: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        prc: *const super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uicp: u32,
        pwszpath: super::super::Foundation::PWSTR,
        dwflags: u32,
        ppidlout: *mut *mut ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        fpendingview: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICDBurn(::windows::runtime::IUnknown);
impl ICDBurn {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetRecorderDriveLetter(
        &self,
        pszdrive: super::super::Foundation::PWSTR,
        cch: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pszdrive),
            ::std::mem::transmute(cch),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Burn<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HasRecordableDrive(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ICDBurn {
    type Vtable = ICDBurn_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1030989401,
        58832,
        19778,
        [175, 192, 81, 33, 186, 66, 92, 141],
    );
}
impl ::std::convert::From<ICDBurn> for ::windows::runtime::IUnknown {
    fn from(value: ICDBurn) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICDBurn> for ::windows::runtime::IUnknown {
    fn from(value: &ICDBurn) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ICDBurn {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ICDBurn {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurn_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszdrive: super::super::Foundation::PWSTR,
        cch: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfhasrecorder: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICDBurnExt(::windows::runtime::IUnknown);
impl ICDBurnExt {
    pub unsafe fn GetSupportedActionTypes(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ICDBurnExt {
    type Vtable = ICDBurnExt_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        577887434,
        29948,
        17428,
        [143, 183, 197, 107, 5, 172, 226, 215],
    );
}
impl ::std::convert::From<ICDBurnExt> for ::windows::runtime::IUnknown {
    fn from(value: ICDBurnExt) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICDBurnExt> for ::windows::runtime::IUnknown {
    fn from(value: &ICDBurnExt) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ICDBurnExt {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ICDBurnExt {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICDBurnExt_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwactions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICategorizer(::windows::runtime::IUnknown);
impl ICategorizer {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDescription(
        &self,
        pszdesc: super::super::Foundation::PWSTR,
        cch: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pszdesc),
            ::std::mem::transmute(cch),
        )
        .ok()
    }
    pub unsafe fn GetCategory(
        &self,
        cidl: u32,
        apidl: *const *const ITEMIDLIST,
        rgcategoryids: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cidl),
            ::std::mem::transmute(apidl),
            ::std::mem::transmute(rgcategoryids),
        )
        .ok()
    }
    pub unsafe fn GetCategoryInfo(
        &self,
        dwcategoryid: u32,
    ) -> ::windows::runtime::Result<CATEGORY_INFO> {
        let mut result__: <CATEGORY_INFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwcategoryid),
            &mut result__,
        )
        .from_abi::<CATEGORY_INFO>(result__)
    }
    pub unsafe fn CompareCategory(
        &self,
        csfflags: CATSORT_FLAGS,
        dwcategoryid1: u32,
        dwcategoryid2: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(csfflags),
            ::std::mem::transmute(dwcategoryid1),
            ::std::mem::transmute(dwcategoryid2),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ICategorizer {
    type Vtable = ICategorizer_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2746303881,
        37236,
        18856,
        [137, 163, 6, 161, 174, 43, 155, 167],
    );
}
impl ::std::convert::From<ICategorizer> for ::windows::runtime::IUnknown {
    fn from(value: ICategorizer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICategorizer> for ::windows::runtime::IUnknown {
    fn from(value: &ICategorizer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ICategorizer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ICategorizer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategorizer_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszdesc: super::super::Foundation::PWSTR,
        cch: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cidl: u32,
        apidl: *const *const ITEMIDLIST,
        rgcategoryids: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwcategoryid: u32,
        pci: *mut CATEGORY_INFO,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        csfflags: CATSORT_FLAGS,
        dwcategoryid1: u32,
        dwcategoryid2: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICategoryProvider(::windows::runtime::IUnknown);
impl ICategoryProvider {
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn CanCategorizeOnSCID(
        &self,
        pscid: *const super::super::System::PropertiesSystem::PROPERTYKEY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pscid),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn GetDefaultCategory(
        &self,
        pguid: *mut ::windows::runtime::GUID,
        pscid: *mut super::super::System::PropertiesSystem::PROPERTYKEY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pguid),
            ::std::mem::transmute(pscid),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn GetCategoryForSCID(
        &self,
        pscid: *const super::super::System::PropertiesSystem::PROPERTYKEY,
    ) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pscid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::GUID>(result__)
    }
    #[cfg(feature = "Win32_System_Com")]
    pub unsafe fn EnumCategories(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::Com::IEnumGUID> {
        let mut result__: <super::super::System::Com::IEnumGUID as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::Com::IEnumGUID>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCategoryName(
        &self,
        pguid: *const ::windows::runtime::GUID,
        pszname: super::super::Foundation::PWSTR,
        cch: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pguid),
            ::std::mem::transmute(pszname),
            ::std::mem::transmute(cch),
        )
        .ok()
    }
    pub unsafe fn CreateCategory<T: ::windows::runtime::Interface>(
        &self,
        pguid: *const ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pguid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ICategoryProvider {
    type Vtable = ICategoryProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2599831561,
        22628,
        19494,
        [167, 32, 193, 247, 140, 8, 110, 227],
    );
}
impl ::std::convert::From<ICategoryProvider> for ::windows::runtime::IUnknown {
    fn from(value: ICategoryProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICategoryProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ICategoryProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ICategoryProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ICategoryProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICategoryProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pscid: *const super::super::System::PropertiesSystem::PROPERTYKEY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pguid: *mut ::windows::runtime::GUID,
        pscid: *mut super::super::System::PropertiesSystem::PROPERTYKEY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pscid: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        pguid: *mut ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_System_Com")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        penum: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_Com"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pguid: *const ::windows::runtime::GUID,
        pszname: super::super::Foundation::PWSTR,
        cch: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pguid: *const ::windows::runtime::GUID,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IColumnManager(::windows::runtime::IUnknown);
impl IColumnManager {
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn SetColumnInfo(
        &self,
        propkey: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        pcmci: *const CM_COLUMNINFO,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propkey),
            ::std::mem::transmute(pcmci),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(
        &self,
        propkey: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        pcmci: *mut CM_COLUMNINFO,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propkey),
            ::std::mem::transmute(pcmci),
        )
        .ok()
    }
    pub unsafe fn GetColumnCount(&self, dwflags: CM_ENUM_FLAGS) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn GetColumns(
        &self,
        dwflags: CM_ENUM_FLAGS,
        rgkeyorder: *mut super::super::System::PropertiesSystem::PROPERTYKEY,
        ccolumns: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(rgkeyorder),
            ::std::mem::transmute(ccolumns),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn SetColumns(
        &self,
        rgkeyorder: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        cvisible: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rgkeyorder),
            ::std::mem::transmute(cvisible),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IColumnManager {
    type Vtable = IColumnManager_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3639355323,
        16187,
        16450,
        [177, 10, 74, 207, 217, 36, 212, 83],
    );
}
impl ::std::convert::From<IColumnManager> for ::windows::runtime::IUnknown {
    fn from(value: IColumnManager) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IColumnManager> for ::windows::runtime::IUnknown {
    fn from(value: &IColumnManager) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IColumnManager {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IColumnManager {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnManager_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propkey: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        pcmci: *const CM_COLUMNINFO,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propkey: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        pcmci: *mut CM_COLUMNINFO,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: CM_ENUM_FLAGS,
        pucount: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: CM_ENUM_FLAGS,
        rgkeyorder: *mut super::super::System::PropertiesSystem::PROPERTYKEY,
        ccolumns: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rgkeyorder: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        cvisible: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IColumnProvider(::windows::runtime::IUnknown);
impl IColumnProvider {
    pub unsafe fn Initialize(&self, psci: *const SHCOLUMNINIT) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(psci),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub unsafe fn GetColumnInfo(&self, dwindex: u32) -> ::windows::runtime::Result<SHCOLUMNINFO> {
        let mut result__: <SHCOLUMNINFO as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwindex),
            &mut result__,
        )
        .from_abi::<SHCOLUMNINFO>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_PropertiesSystem",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetItemData(
        &self,
        pscid: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        pscd: *const SHCOLUMNDATA,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pscid),
            ::std::mem::transmute(pscd),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IColumnProvider {
    type Vtable = IColumnProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3892465668,
        7234,
        4562,
        [190, 44, 0, 160, 201, 168, 61, 161],
    );
}
impl ::std::convert::From<IColumnProvider> for ::windows::runtime::IUnknown {
    fn from(value: IColumnProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IColumnProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IColumnProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IColumnProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IColumnProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IColumnProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psci: *const SHCOLUMNINIT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_PropertiesSystem")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwindex: u32,
        psci: *mut SHCOLUMNINFO,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_PropertiesSystem"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_PropertiesSystem",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pscid: *const super::super::System::PropertiesSystem::PROPERTYKEY,
        pscd: *const SHCOLUMNDATA,
        pvardata: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_PropertiesSystem",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICommDlgBrowser(::windows::runtime::IUnknown);
impl ICommDlgBrowser {
    pub unsafe fn OnDefaultCommand<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OnStateChange<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        uchange: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(uchange),
        )
        .ok()
    }
    pub unsafe fn IncludeObject<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ICommDlgBrowser {
    type Vtable = ICommDlgBrowser_abi;
    const IID: ::windows::runtime::GUID =
        ::windows::runtime::GUID::from_values(136433, 0, 0, [192, 0, 0, 0, 0, 0, 0, 70]);
}
impl ::std::convert::From<ICommDlgBrowser> for ::windows::runtime::IUnknown {
    fn from(value: ICommDlgBrowser) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICommDlgBrowser> for ::windows::runtime::IUnknown {
    fn from(value: &ICommDlgBrowser) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ICommDlgBrowser {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ICommDlgBrowser {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        uchange: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICommDlgBrowser2(::windows::runtime::IUnknown);
impl ICommDlgBrowser2 {
    pub unsafe fn OnDefaultCommand<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OnStateChange<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        uchange: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(uchange),
        )
        .ok()
    }
    pub unsafe fn IncludeObject<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    pub unsafe fn Notify<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        dwnotifytype: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(dwnotifytype),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultMenuText<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        psztext: super::super::Foundation::PWSTR,
        cchmax: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(psztext),
            ::std::mem::transmute(cchmax),
        )
        .ok()
    }
    pub unsafe fn GetViewFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ICommDlgBrowser2 {
    type Vtable = ICommDlgBrowser2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        271815958,
        10388,
        4562,
        [144, 57, 0, 192, 79, 142, 235, 62],
    );
}
impl ::std::convert::From<ICommDlgBrowser2> for ::windows::runtime::IUnknown {
    fn from(value: ICommDlgBrowser2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICommDlgBrowser2> for ::windows::runtime::IUnknown {
    fn from(value: &ICommDlgBrowser2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ICommDlgBrowser2> for ICommDlgBrowser {
    fn from(value: ICommDlgBrowser2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICommDlgBrowser2> for ICommDlgBrowser {
    fn from(value: &ICommDlgBrowser2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICommDlgBrowser> for ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ICommDlgBrowser> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ICommDlgBrowser>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICommDlgBrowser> for &ICommDlgBrowser2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ICommDlgBrowser> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ICommDlgBrowser>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        uchange: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        dwnotifytype: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        psztext: super::super::Foundation::PWSTR,
        cchmax: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflags: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICommDlgBrowser3(::windows::runtime::IUnknown);
impl ICommDlgBrowser3 {
    pub unsafe fn OnDefaultCommand<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OnStateChange<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        uchange: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(uchange),
        )
        .ok()
    }
    pub unsafe fn IncludeObject<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(pidl),
        )
        .ok()
    }
    pub unsafe fn Notify<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        dwnotifytype: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(dwnotifytype),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetDefaultMenuText<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        psztext: super::super::Foundation::PWSTR,
        cchmax: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(psztext),
            ::std::mem::transmute(cchmax),
        )
        .ok()
    }
    pub unsafe fn GetViewFlags(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn OnColumnClicked<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
        icolumn: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
            ::std::mem::transmute(icolumn),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCurrentFilter(
        &self,
        pszfilespec: super::super::Foundation::PWSTR,
        cchfilespec: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pszfilespec),
            ::std::mem::transmute(cchfilespec),
        )
        .ok()
    }
    pub unsafe fn OnPreViewCreated<'a, Param0: ::windows::runtime::IntoParam<'a, IShellView>>(
        &self,
        ppshv: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ppshv.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ICommDlgBrowser3 {
    type Vtable = ICommDlgBrowser3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3366790561,
        12948,
        16878,
        [129, 101, 113, 23, 75, 208, 28, 87],
    );
}
impl ::std::convert::From<ICommDlgBrowser3> for ::windows::runtime::IUnknown {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICommDlgBrowser3> for ::windows::runtime::IUnknown {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ICommDlgBrowser3> for ICommDlgBrowser2 {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICommDlgBrowser3> for ICommDlgBrowser2 {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICommDlgBrowser2> for ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ICommDlgBrowser2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ICommDlgBrowser2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICommDlgBrowser2> for &ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ICommDlgBrowser2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ICommDlgBrowser2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<ICommDlgBrowser3> for ICommDlgBrowser {
    fn from(value: ICommDlgBrowser3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICommDlgBrowser3> for ICommDlgBrowser {
    fn from(value: &ICommDlgBrowser3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICommDlgBrowser> for ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ICommDlgBrowser> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ICommDlgBrowser>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICommDlgBrowser> for &ICommDlgBrowser3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ICommDlgBrowser> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ICommDlgBrowser>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICommDlgBrowser3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        uchange: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        pidl: *const ITEMIDLIST,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        dwnotifytype: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        psztext: super::super::Foundation::PWSTR,
        cchmax: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwflags: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
        icolumn: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfilespec: super::super::Foundation::PWSTR,
        cchfilespec: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppshv: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IComputerInfoChangeNotify(::windows::runtime::IUnknown);
impl IComputerInfoChangeNotify {
    pub unsafe fn ComputerInfoChanged(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IComputerInfoChangeNotify {
    type Vtable = IComputerInfoChangeNotify_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        234229138,
        26648,
        18134,
        [179, 88, 214, 97, 112, 221, 228, 102],
    );
}
impl ::std::convert::From<IComputerInfoChangeNotify> for ::windows::runtime::IUnknown {
    fn from(value: IComputerInfoChangeNotify) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IComputerInfoChangeNotify> for ::windows::runtime::IUnknown {
    fn from(value: &IComputerInfoChangeNotify) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IComputerInfoChangeNotify
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IComputerInfoChangeNotify
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IComputerInfoChangeNotify_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IConnectableCredentialProviderCredential(::windows::runtime::IUnknown);
impl IConnectableCredentialProviderCredential {
    pub unsafe fn Advise<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ICredentialProviderCredentialEvents>,
    >(
        &self,
        pcpce: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pcpce.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UnAdvise(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetSelected(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SetDeselected(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetFieldState(
        &self,
        dwfieldid: u32,
        pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE,
        pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            ::std::mem::transmute(pcpfs),
            ::std::mem::transmute(pcpfis),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetStringValue(
        &self,
        dwfieldid: u32,
    ) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub unsafe fn GetBitmapValue(
        &self,
        dwfieldid: u32,
    ) -> ::windows::runtime::Result<super::super::Graphics::Gdi::HBITMAP> {
        let mut result__: <super::super::Graphics::Gdi::HBITMAP as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            &mut result__,
        )
        .from_abi::<super::super::Graphics::Gdi::HBITMAP>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCheckboxValue(
        &self,
        dwfieldid: u32,
        pbchecked: *mut super::super::Foundation::BOOL,
        ppszlabel: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            ::std::mem::transmute(pbchecked),
            ::std::mem::transmute(ppszlabel),
        )
        .ok()
    }
    pub unsafe fn GetSubmitButtonValue(&self, dwfieldid: u32) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetComboBoxValueCount(
        &self,
        dwfieldid: u32,
        pcitems: *mut u32,
        pdwselecteditem: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            ::std::mem::transmute(pcitems),
            ::std::mem::transmute(pdwselecteditem),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetComboBoxValueAt(
        &self,
        dwfieldid: u32,
        dwitem: u32,
    ) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            ::std::mem::transmute(dwitem),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetStringValue<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        dwfieldid: u32,
        psz: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            psz.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetCheckboxValue<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        dwfieldid: u32,
        bchecked: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            bchecked.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetComboBoxSelectedValue(
        &self,
        dwfieldid: u32,
        dwselecteditem: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
            ::std::mem::transmute(dwselecteditem),
        )
        .ok()
    }
    pub unsafe fn CommandLinkClicked(&self, dwfieldid: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwfieldid),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSerialization(
        &self,
        pcpgsr: *mut CREDENTIAL_PROVIDER_GET_SERIALIZATION_RESPONSE,
        pcpcs: *mut CREDENTIAL_PROVIDER_CREDENTIAL_SERIALIZATION,
        ppszoptionalstatustext: *mut super::super::Foundation::PWSTR,
        pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pcpgsr),
            ::std::mem::transmute(pcpcs),
            ::std::mem::transmute(ppszoptionalstatustext),
            ::std::mem::transmute(pcpsioptionalstatusicon),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ReportResult<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::NTSTATUS>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::NTSTATUS>,
    >(
        &self,
        ntsstatus: Param0,
        ntssubstatus: Param1,
        ppszoptionalstatustext: *mut super::super::Foundation::PWSTR,
        pcpsioptionalstatusicon: *mut CREDENTIAL_PROVIDER_STATUS_ICON,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            ntsstatus.into_param().abi(),
            ntssubstatus.into_param().abi(),
            ::std::mem::transmute(ppszoptionalstatustext),
            ::std::mem::transmute(pcpsioptionalstatusicon),
        )
        .ok()
    }
    pub unsafe fn Connect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IQueryContinueWithStatus>,
    >(
        &self,
        pqcws: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            pqcws.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Disconnect(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IConnectableCredentialProviderCredential {
    type Vtable = IConnectableCredentialProviderCredential_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2475135627,
        44149,
        19449,
        [138, 178, 43, 147, 196, 165, 82, 144],
    );
}
impl ::std::convert::From<IConnectableCredentialProviderCredential>
    for ::windows::runtime::IUnknown
{
    fn from(value: IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IConnectableCredentialProviderCredential>
    for ::windows::runtime::IUnknown
{
    fn from(value: &IConnectableCredentialProviderCredential) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IConnectableCredentialProviderCredential
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IConnectableCredentialProviderCredential
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IConnectableCredentialProviderCredential>
    for ICredentialProviderCredential
{
    fn from(value: IConnectableCredentialProviderCredential) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IConnectableCredentialProviderCredential>
    for ICredentialProviderCredential
{
    fn from(value: &IConnectableCredentialProviderCredential) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICredentialProviderCredential>
    for IConnectableCredentialProviderCredential
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ICredentialProviderCredential> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<ICredentialProviderCredential>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ICredentialProviderCredential>
    for &IConnectableCredentialProviderCredential
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ICredentialProviderCredential> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<ICredentialProviderCredential>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IConnectableCredentialProviderCredential_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcpce: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbautologon: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwfieldid: u32,
        pcpfs: *mut CREDENTIAL_PROVIDER_FIELD_STATE,
        pcpfis: *mut CREDENTIAL_PROVIDER_FIELD_INTERACTIVE_STATE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwfieldid: u32,
        ppsz: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Graphics_Gdi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwfieldid: u32,
        phbmp: *mut super::super::Graphics::Gdi::HBITMAP,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Gdi"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwfieldid: u32,
        pbchecked: *mut super::super::Foundation::BOOL,
        ppszlabel: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwfieldid: u32,
        pdwadjacentto: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwfieldid: u32,
        pcitems: *mut u32,
        pdwselecteditem: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        thi