#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct ACCESSTIMEOUT {
    pub cbSize: u32,
    pub dwFlags: u32,
    pub iTimeOutMSec: u32,
}
impl ACCESSTIMEOUT {}
impl ::std::default::Default for ACCESSTIMEOUT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ACCESSTIMEOUT {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ACCESSTIMEOUT")
            .field("cbSize", &self.cbSize)
            .field("dwFlags", &self.dwFlags)
            .field("iTimeOutMSec", &self.iTimeOutMSec)
            .finish()
    }
}
impl ::std::cmp::PartialEq for ACCESSTIMEOUT {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwFlags == other.dwFlags
            && self.iTimeOutMSec == other.iTimeOutMSec
    }
}
impl ::std::cmp::Eq for ACCESSTIMEOUT {}
unsafe impl ::windows::runtime::Abi for ACCESSTIMEOUT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ACC_UTILITY_STATE_FLAGS(pub u32);
pub const ANRUS_ON_SCREEN_KEYBOARD_ACTIVE: ACC_UTILITY_STATE_FLAGS = ACC_UTILITY_STATE_FLAGS(1u32);
pub const ANRUS_TOUCH_MODIFICATION_ACTIVE: ACC_UTILITY_STATE_FLAGS = ACC_UTILITY_STATE_FLAGS(2u32);
pub const ANRUS_PRIORITY_AUDIO_ACTIVE: ACC_UTILITY_STATE_FLAGS = ACC_UTILITY_STATE_FLAGS(4u32);
pub const ANRUS_PRIORITY_AUDIO_ACTIVE_NODUCK: ACC_UTILITY_STATE_FLAGS =
    ACC_UTILITY_STATE_FLAGS(8u32);
impl ::std::convert::From<u32> for ACC_UTILITY_STATE_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ACC_UTILITY_STATE_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for ACC_UTILITY_STATE_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for ACC_UTILITY_STATE_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for ACC_UTILITY_STATE_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for ACC_UTILITY_STATE_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for ACC_UTILITY_STATE_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
pub const ANRUS_PRIORITY_AUDIO_DYNAMIC_DUCK: u32 = 16u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AccNotifyTouchInteraction<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
>(
    hwndapp: Param0,
    hwndtarget: Param1,
    pttarget: Param2,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn AccNotifyTouchInteraction(
                hwndapp: super::super::Foundation::HWND,
                hwndtarget: super::super::Foundation::HWND,
                pttarget: super::super::Foundation::POINT,
            ) -> ::windows::runtime::HRESULT;
        }
        AccNotifyTouchInteraction(
            hwndapp.into_param().abi(),
            hwndtarget.into_param().abi(),
            pttarget.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AccSetRunningUtilityState<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hwndapp: Param0,
    dwutilitystatemask: u32,
    dwutilitystate: ACC_UTILITY_STATE_FLAGS,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn AccSetRunningUtilityState(
                hwndapp: super::super::Foundation::HWND,
                dwutilitystatemask: u32,
                dwutilitystate: ACC_UTILITY_STATE_FLAGS,
            ) -> ::windows::runtime::HRESULT;
        }
        AccSetRunningUtilityState(
            hwndapp.into_param().abi(),
            ::std::mem::transmute(dwutilitystatemask),
            ::std::mem::transmute(dwutilitystate),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const AcceleratorKey_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1363699167,
        9559,
        19641,
        [174, 237, 108, 237, 8, 76, 229, 44],
    );
pub const AccessKey_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    109214482,
    43001,
    18965,
    [145, 124, 255, 165, 173, 62, 176, 167],
);
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_OleAutomation",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn AccessibleChildren<'a, Param0: ::windows::runtime::IntoParam<'a, IAccessible>>(
    pacccontainer: Param0,
    ichildstart: i32,
    cchildren: i32,
    rgvarchildren: *mut super::super::System::OleAutomation::VARIANT,
    pcobtained: *mut i32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn AccessibleChildren(
                pacccontainer: ::windows::runtime::RawPtr,
                ichildstart: i32,
                cchildren: i32,
                rgvarchildren: *mut ::std::mem::ManuallyDrop<
                    super::super::System::OleAutomation::VARIANT,
                >,
                pcobtained: *mut i32,
            ) -> ::windows::runtime::HRESULT;
        }
        AccessibleChildren(
            pacccontainer.into_param().abi(),
            ::std::mem::transmute(ichildstart),
            ::std::mem::transmute(cchildren),
            ::std::mem::transmute(rgvarchildren),
            ::std::mem::transmute(pcobtained),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_OleAutomation",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn AccessibleObjectFromEvent<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hwnd: Param0,
    dwid: u32,
    dwchildid: u32,
    ppacc: *mut ::std::option::Option<IAccessible>,
    pvarchild: *mut super::super::System::OleAutomation::VARIANT,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn AccessibleObjectFromEvent(
                hwnd: super::super::Foundation::HWND,
                dwid: u32,
                dwchildid: u32,
                ppacc: *mut ::windows::runtime::RawPtr,
                pvarchild: *mut ::std::mem::ManuallyDrop<
                    super::super::System::OleAutomation::VARIANT,
                >,
            ) -> ::windows::runtime::HRESULT;
        }
        AccessibleObjectFromEvent(
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwid),
            ::std::mem::transmute(dwchildid),
            ::std::mem::transmute(ppacc),
            ::std::mem::transmute(pvarchild),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(
    feature = "Win32_Foundation",
    feature = "Win32_System_OleAutomation",
    feature = "Win32_System_SystemServices"
))]
pub unsafe fn AccessibleObjectFromPoint<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
>(
    ptscreen: Param0,
    ppacc: *mut ::std::option::Option<IAccessible>,
    pvarchild: *mut super::super::System::OleAutomation::VARIANT,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn AccessibleObjectFromPoint(
                ptscreen: super::super::Foundation::POINT,
                ppacc: *mut ::windows::runtime::RawPtr,
                pvarchild: *mut ::std::mem::ManuallyDrop<
                    super::super::System::OleAutomation::VARIANT,
                >,
            ) -> ::windows::runtime::HRESULT;
        }
        AccessibleObjectFromPoint(
            ptscreen.into_param().abi(),
            ::std::mem::transmute(ppacc),
            ::std::mem::transmute(pvarchild),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AccessibleObjectFromWindow<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hwnd: Param0,
    dwid: u32,
    riid: *const ::windows::runtime::GUID,
    ppvobject: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn AccessibleObjectFromWindow(
                hwnd: super::super::Foundation::HWND,
                dwid: u32,
                riid: *const ::windows::runtime::GUID,
                ppvobject: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        AccessibleObjectFromWindow(
            hwnd.into_param().abi(),
            ::std::mem::transmute(dwid),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobject),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ActiveEnd(pub i32);
pub const ActiveEnd_None: ActiveEnd = ActiveEnd(0i32);
pub const ActiveEnd_Start: ActiveEnd = ActiveEnd(1i32);
pub const ActiveEnd_End: ActiveEnd = ActiveEnd(2i32);
impl ::std::convert::From<i32> for ActiveEnd {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ActiveEnd {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ActiveTextPositionChanged_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2780864156,
        51069,
        20261,
        [180, 145, 229, 187, 112, 23, 203, 212],
    );
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AnimationStyle(pub i32);
pub const AnimationStyle_None: AnimationStyle = AnimationStyle(0i32);
pub const AnimationStyle_LasVegasLights: AnimationStyle = AnimationStyle(1i32);
pub const AnimationStyle_BlinkingBackground: AnimationStyle = AnimationStyle(2i32);
pub const AnimationStyle_SparkleText: AnimationStyle = AnimationStyle(3i32);
pub const AnimationStyle_MarchingBlackAnts: AnimationStyle = AnimationStyle(4i32);
pub const AnimationStyle_MarchingRedAnts: AnimationStyle = AnimationStyle(5i32);
pub const AnimationStyle_Shimmer: AnimationStyle = AnimationStyle(6i32);
pub const AnimationStyle_Other: AnimationStyle = AnimationStyle(-1i32);
impl ::std::convert::From<i32> for AnimationStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AnimationStyle {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AnnoScope(pub i32);
pub const ANNO_THIS: AnnoScope = AnnoScope(0i32);
pub const ANNO_CONTAINER: AnnoScope = AnnoScope(1i32);
impl ::std::convert::From<i32> for AnnoScope {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AnnoScope {
    type Abi = Self;
    type DefaultType = Self;
}
pub const AnnotationObjects_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        822677704,
        31854,
        20256,
        [190, 205, 74, 175, 109, 25, 17, 86],
    );
pub const AnnotationType_AdvancedProofingIssue: i32 = 60020i32;
pub const AnnotationType_Author: i32 = 60019i32;
pub const AnnotationType_CircularReferenceError: i32 = 60022i32;
pub const AnnotationType_Comment: i32 = 60003i32;
pub const AnnotationType_ConflictingChange: i32 = 60018i32;
pub const AnnotationType_DataValidationError: i32 = 60021i32;
pub const AnnotationType_DeletionChange: i32 = 60012i32;
pub const AnnotationType_EditingLockedChange: i32 = 60016i32;
pub const AnnotationType_Endnote: i32 = 60009i32;
pub const AnnotationType_ExternalChange: i32 = 60017i32;
pub const AnnotationType_Footer: i32 = 60007i32;
pub const AnnotationType_Footnote: i32 = 60010i32;
pub const AnnotationType_FormatChange: i32 = 60014i32;
pub const AnnotationType_FormulaError: i32 = 60004i32;
pub const AnnotationType_GrammarError: i32 = 60002i32;
pub const AnnotationType_Header: i32 = 60006i32;
pub const AnnotationType_Highlighted: i32 = 60008i32;
pub const AnnotationType_InsertionChange: i32 = 60011i32;
pub const AnnotationType_Mathematics: i32 = 60023i32;
pub const AnnotationType_MoveChange: i32 = 60013i32;
pub const AnnotationType_Sensitive: i32 = 60024i32;
pub const AnnotationType_SpellingError: i32 = 60001i32;
pub const AnnotationType_TrackChanges: i32 = 60005i32;
pub const AnnotationType_Unknown: i32 = 60000i32;
pub const AnnotationType_UnsyncedChange: i32 = 60015i32;
pub const AnnotationTypes_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1689722742,
        21444,
        18070,
        [162, 25, 32, 233, 64, 201, 161, 118],
    );
pub const Annotation_AdvancedProofingIssue_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3670521644,
        49394,
        19332,
        [185, 13, 95, 175, 192, 240, 239, 28],
    );
pub const Annotation_AnnotationTypeId_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        548292687,
        27119,
        19528,
        [143, 91, 196, 147, 139, 32, 106, 199],
    );
pub const Annotation_AnnotationTypeName_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2608957586,
        23241,
        19193,
        [170, 150, 245, 138, 119, 176, 88, 227],
    );
pub const Annotation_Author_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4049720231,
    63515,
    16680,
    [177, 127, 113, 246, 144, 145, 69, 32],
);
pub const Annotation_Author_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2052228194,
        40028,
        18947,
        [169, 116, 139, 48, 122, 153, 55, 242],
    );
pub const Annotation_CircularReferenceError_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        633183476,
        5957,
        18009,
        [186, 103, 114, 127, 3, 24, 198, 22],
    );
pub const Annotation_Comment_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4247771696,
    9907,
    19462,
    [139, 199, 152, 241, 83, 46, 70, 253],
);
pub const Annotation_ConflictingChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2561640450,
        20860,
        17823,
        [175, 19, 1, 109, 63, 171, 135, 126],
    );
pub const Annotation_Custom_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2663917392,
    14641,
    18770,
    [133, 188, 29, 191, 247, 138, 67, 227],
);
pub const Annotation_DataValidationError_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3362037672,
        38773,
        17278,
        [173, 70, 231, 9, 217, 60, 35, 67],
    );
pub const Annotation_DateTime_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2578827869,
        6863,
        16715,
        [164, 208, 107, 53, 11, 4, 117, 120],
    );
pub const Annotation_DeletionChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3191692037,
        38173,
        17127,
        [144, 29, 173, 200, 194, 207, 52, 208],
    );
pub const Annotation_EditingLockedChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3273604636,
        29731,
        19884,
        [131, 72, 65, 240, 153, 255, 111, 100],
    );
pub const Annotation_Endnote_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1969582684,
    11673,
    18489,
    [150, 13, 51, 211, 184, 102, 171, 165],
);
pub const Annotation_ExternalChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1973443377,
        24337,
        17149,
        [136, 125, 223, 160, 16, 219, 35, 146],
    );
pub const Annotation_Footer_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3437932614,
    6195,
    18346,
    [128, 128, 112, 30, 208, 176, 200, 50],
);
pub const Annotation_Footnote_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1038159393,
        16677,
        17115,
        [134, 32, 190, 128, 131, 8, 6, 36],
    );
pub const Annotation_FormatChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3945034565,
        54513,
        16846,
        [142, 82, 247, 155, 105, 99, 94, 72],
    );
pub const Annotation_FormulaError_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2506168706,
        3243,
        18133,
        [162, 240, 227, 13, 25, 5, 248, 191],
    );
pub const Annotation_GrammarError_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1970930829,
        17688,
        16838,
        [133, 76, 220, 0, 155, 124, 251, 83],
    );
pub const Annotation_Header_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2256224411,
    45590,
    17522,
    [162, 25, 82, 94, 49, 6, 129, 248],
);
pub const Annotation_Highlighted_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1971095630,
        32899,
        16513,
        [139, 156, 232, 127, 80, 114, 240, 228],
    );
pub const Annotation_InsertionChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        230601638,
        57109,
        16740,
        [163, 192, 226, 26, 140, 233, 49, 196],
    );
pub const Annotation_Mathematics_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3937100619,
        9936,
        16577,
        [128, 115, 87, 202, 28, 99, 60, 155],
    );
pub const Annotation_MoveChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2644871147,
        9189,
        17552,
        [179, 133, 26, 34, 221, 200, 177, 135],
    );
pub const Annotation_Pattern_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4140247767,
    13676,
    18512,
    [146, 145, 49, 111, 96, 138, 140, 132],
);
pub const Annotation_Sensitive_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        938786895,
        3858,
        17508,
        [146, 156, 130, 143, 209, 82, 146, 227],
    );
pub const Annotation_SpellingError_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2927974014,
        40654,
        16959,
        [129, 183, 150, 196, 61, 83, 229, 14],
    );
pub const Annotation_Target_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3072012333,
        8452,
        17581,
        [156, 92, 9, 43, 73, 7, 215, 15],
    );
pub const Annotation_TrackChanges_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        568780936,
        56340,
        16406,
        [172, 39, 25, 5, 83, 200, 196, 112],
    );
pub const Annotation_UnsyncedChange_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        407966058,
        3655,
        19248,
        [140, 181, 215, 218, 228, 251, 205, 27],
    );
pub const AppBar_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1628737677,
    52226,
    19767,
    [135, 91, 181, 48, 199, 19, 149, 84],
);
pub const AriaProperties_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1108567948,
        57381,
        18722,
        [190, 181, 228, 59, 160, 142, 98, 33],
    );
pub const AriaRole_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3709893525,
    48714,
    19981,
    [183, 39, 99, 172, 233, 75, 105, 22],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AsyncContentLoadedState(pub i32);
pub const AsyncContentLoadedState_Beginning: AsyncContentLoadedState =
    AsyncContentLoadedState(0i32);
pub const AsyncContentLoadedState_Progress: AsyncContentLoadedState = AsyncContentLoadedState(1i32);
pub const AsyncContentLoadedState_Completed: AsyncContentLoadedState =
    AsyncContentLoadedState(2i32);
impl ::std::convert::From<i32> for AsyncContentLoadedState {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AsyncContentLoadedState {
    type Abi = Self;
    type DefaultType = Self;
}
pub const AsyncContentLoaded_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1608442140,
        54010,
        20409,
        [144, 78, 92, 190, 232, 148, 213, 239],
    );
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AutomationElementMode(pub i32);
pub const AutomationElementMode_None: AutomationElementMode = AutomationElementMode(0i32);
pub const AutomationElementMode_Full: AutomationElementMode = AutomationElementMode(1i32);
impl ::std::convert::From<i32> for AutomationElementMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AutomationElementMode {
    type Abi = Self;
    type DefaultType = Self;
}
pub const AutomationFocusChanged_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3062505239,
        62989,
        16807,
        [163, 204, 176, 82, 146, 21, 95, 224],
    );
pub const AutomationId_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3358328064,
        46606,
        17168,
        [162, 103, 48, 60, 83, 31, 142, 229],
    );
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct AutomationIdentifierType(pub i32);
pub const AutomationIdentifierType_Property: AutomationIdentifierType =
    AutomationIdentifierType(0i32);
pub const AutomationIdentifierType_Pattern: AutomationIdentifierType =
    AutomationIdentifierType(1i32);
pub const AutomationIdentifierType_Event: AutomationIdentifierType = AutomationIdentifierType(2i32);
pub const AutomationIdentifierType_ControlType: AutomationIdentifierType =
    AutomationIdentifierType(3i32);
pub const AutomationIdentifierType_TextAttribute: AutomationIdentifierType =
    AutomationIdentifierType(4i32);
pub const AutomationIdentifierType_LandmarkType: AutomationIdentifierType =
    AutomationIdentifierType(5i32);
pub const AutomationIdentifierType_Annotation: AutomationIdentifierType =
    AutomationIdentifierType(6i32);
pub const AutomationIdentifierType_Changes: AutomationIdentifierType =
    AutomationIdentifierType(7i32);
pub const AutomationIdentifierType_Style: AutomationIdentifierType = AutomationIdentifierType(8i32);
impl ::std::convert::From<i32> for AutomationIdentifierType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for AutomationIdentifierType {
    type Abi = Self;
    type DefaultType = Self;
}
pub const AutomationPropertyChanged_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        623377313,
        36218,
        17968,
        [164, 204, 230, 99, 21, 148, 47, 82],
    );
pub const BoundingRectangle_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2076174514,
        15356,
        18653,
        [183, 41, 199, 148, 184, 70, 233, 161],
    );
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct BulletStyle(pub i32);
pub const BulletStyle_None: BulletStyle = BulletStyle(0i32);
pub const BulletStyle_HollowRoundBullet: BulletStyle = BulletStyle(1i32);
pub const BulletStyle_FilledRoundBullet: BulletStyle = BulletStyle(2i32);
pub const BulletStyle_HollowSquareBullet: BulletStyle = BulletStyle(3i32);
pub const BulletStyle_FilledSquareBullet: BulletStyle = BulletStyle(4i32);
pub const BulletStyle_DashBullet: BulletStyle = BulletStyle(5i32);
pub const BulletStyle_Other: BulletStyle = BulletStyle(-1i32);
impl ::std::convert::From<i32> for BulletStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BulletStyle {
    type Abi = Self;
    type DefaultType = Self;
}
pub const Button_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1517871977,
    50849,
    20275,
    [169, 215, 121, 242, 13, 12, 120, 142],
);
pub const CAccPropServices: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3052942603,
    1352,
    18609,
    [166, 238, 136, 189, 0, 180, 165, 231],
);
pub const CLSID_AccPropServices: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3052942603,
    1352,
    18609,
    [166, 238, 136, 189, 0, 180, 165, 231],
);
pub const CUIAutomation: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4282964900,
    24815,
    16897,
    [170, 135, 84, 16, 62, 239, 89, 78],
);
pub const CUIAutomation8: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3794457395,
    45663,
    17932,
    [131, 208, 5, 129, 16, 115, 149, 201],
);
pub const CUIAutomationRegistrar: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1848244927,
    39287,
    17105,
    [141, 14, 202, 126, 97, 173, 135, 230],
);
pub const Calendar_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2299784072,
    229,
    18108,
    [142, 78, 20, 167, 134, 225, 101, 161],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CapStyle(pub i32);
pub const CapStyle_None: CapStyle = CapStyle(0i32);
pub const CapStyle_SmallCap: CapStyle = CapStyle(1i32);
pub const CapStyle_AllCap: CapStyle = CapStyle(2i32);
pub const CapStyle_AllPetiteCaps: CapStyle = CapStyle(3i32);
pub const CapStyle_PetiteCaps: CapStyle = CapStyle(4i32);
pub const CapStyle_Unicase: CapStyle = CapStyle(5i32);
pub const CapStyle_Titling: CapStyle = CapStyle(6i32);
pub const CapStyle_Other: CapStyle = CapStyle(-1i32);
impl ::std::convert::From<i32> for CapStyle {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CapStyle {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CaretBidiMode(pub i32);
pub const CaretBidiMode_LTR: CaretBidiMode = CaretBidiMode(0i32);
pub const CaretBidiMode_RTL: CaretBidiMode = CaretBidiMode(1i32);
impl ::std::convert::From<i32> for CaretBidiMode {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CaretBidiMode {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CaretPosition(pub i32);
pub const CaretPosition_Unknown: CaretPosition = CaretPosition(0i32);
pub const CaretPosition_EndOfLine: CaretPosition = CaretPosition(1i32);
pub const CaretPosition_BeginningOfLine: CaretPosition = CaretPosition(2i32);
impl ::std::convert::From<i32> for CaretPosition {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CaretPosition {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CenterPoint_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        212864008,
        21516,
        20187,
        [148, 69, 38, 53, 158, 166, 151, 133],
    );
pub const Changes_Event_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2113038100,
    24911,
    19973,
    [148, 136, 113, 108, 91, 161, 148, 54],
);
pub const Changes_Summary_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    826107302,
    58895,
    19810,
    [152, 97, 85, 175, 215, 40, 210, 7],
);
pub const CheckBox_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4216387874,
    41947,
    18880,
    [139, 195, 6, 218, 213, 87, 120, 226],
);
pub const ClassName_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    360411669,
    35151,
    19301,
    [132, 226, 170, 192, 218, 8, 177, 107],
);
pub const ClickablePoint_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        26644539,
        45571,
        18456,
        [169, 243, 240, 142, 103, 95, 35, 65],
    );
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct CoalesceEventsOptions(pub i32);
pub const CoalesceEventsOptions_Disabled: CoalesceEventsOptions = CoalesceEventsOptions(0i32);
pub const CoalesceEventsOptions_Enabled: CoalesceEventsOptions = CoalesceEventsOptions(1i32);
impl ::std::convert::From<i32> for CoalesceEventsOptions {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for CoalesceEventsOptions {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ComboBox_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1422606956,
    12083,
    20479,
    [170, 161, 174, 246, 13, 172, 93, 235],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ConditionType(pub i32);
pub const ConditionType_True: ConditionType = ConditionType(0i32);
pub const ConditionType_False: ConditionType = ConditionType(1i32);
pub const ConditionType_Property: ConditionType = ConditionType(2i32);
pub const ConditionType_And: ConditionType = ConditionType(3i32);
pub const ConditionType_Or: ConditionType = ConditionType(4i32);
pub const ConditionType_Not: ConditionType = ConditionType(5i32);
impl ::std::convert::From<i32> for ConditionType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ConditionType {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ConnectionRecoveryBehaviorOptions(pub i32);
pub const ConnectionRecoveryBehaviorOptions_Disabled: ConnectionRecoveryBehaviorOptions =
    ConnectionRecoveryBehaviorOptions(0i32);
pub const ConnectionRecoveryBehaviorOptions_Enabled: ConnectionRecoveryBehaviorOptions =
    ConnectionRecoveryBehaviorOptions(1i32);
impl ::std::convert::From<i32> for ConnectionRecoveryBehaviorOptions {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ConnectionRecoveryBehaviorOptions {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ControlType_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3396816874,
        10412,
        19394,
        [148, 202, 172, 236, 109, 108, 16, 163],
    );
pub const ControllerFor_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1360153738,
        42450,
        20243,
        [155, 230, 127, 168, 186, 157, 58, 144],
    );
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CreateStdAccessibleObject<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hwnd: Param0,
    idobject: i32,
    riid: *const ::windows::runtime::GUID,
    ppvobject: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn CreateStdAccessibleObject(
                hwnd: super::super::Foundation::HWND,
                idobject: i32,
                riid: *const ::windows::runtime::GUID,
                ppvobject: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        CreateStdAccessibleObject(
            hwnd.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobject),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CreateStdAccessibleProxyA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hwnd: Param0,
    pclassname: Param1,
    idobject: i32,
    riid: *const ::windows::runtime::GUID,
    ppvobject: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn CreateStdAccessibleProxyA(
                hwnd: super::super::Foundation::HWND,
                pclassname: super::super::Foundation::PSTR,
                idobject: i32,
                riid: *const ::windows::runtime::GUID,
                ppvobject: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        CreateStdAccessibleProxyA(
            hwnd.into_param().abi(),
            pclassname.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobject),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CreateStdAccessibleProxyW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hwnd: Param0,
    pclassname: Param1,
    idobject: i32,
    riid: *const ::windows::runtime::GUID,
    ppvobject: *mut *mut ::std::ffi::c_void,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn CreateStdAccessibleProxyW(
                hwnd: super::super::Foundation::HWND,
                pclassname: super::super::Foundation::PWSTR,
                idobject: i32,
                riid: *const ::windows::runtime::GUID,
                ppvobject: *mut *mut ::std::ffi::c_void,
            ) -> ::windows::runtime::HRESULT;
        }
        CreateStdAccessibleProxyW(
            hwnd.into_param().abi(),
            pclassname.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppvobject),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const Culture_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3805761319,
    15737,
    19906,
    [184, 139, 48, 68, 150, 58, 138, 251],
);
pub const CustomNavigation_Pattern_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2951385994,
        25118,
        16468,
        [187, 44, 47, 70, 17, 77, 172, 63],
    );
pub const Custom_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4070482115,
    44471,
    17162,
    [186, 144, 229, 44, 115, 19, 230, 237],
);
pub const DISPID_ACC_CHILD: i32 = -5002i32;
pub const DISPID_ACC_CHILDCOUNT: i32 = -5001i32;
pub const DISPID_ACC_DEFAULTACTION: i32 = -5013i32;
pub const DISPID_ACC_DESCRIPTION: i32 = -5005i32;
pub const DISPID_ACC_DODEFAULTACTION: i32 = -5018i32;
pub const DISPID_ACC_FOCUS: i32 = -5011i32;
pub const DISPID_ACC_HELP: i32 = -5008i32;
pub const DISPID_ACC_HELPTOPIC: i32 = -5009i32;
pub const DISPID_ACC_HITTEST: i32 = -5017i32;
pub const DISPID_ACC_KEYBOARDSHORTCUT: i32 = -5010i32;
pub const DISPID_ACC_LOCATION: i32 = -5015i32;
pub const DISPID_ACC_NAME: i32 = -5003i32;
pub const DISPID_ACC_NAVIGATE: i32 = -5016i32;
pub const DISPID_ACC_PARENT: i32 = -5000i32;
pub const DISPID_ACC_ROLE: i32 = -5006i32;
pub const DISPID_ACC_SELECT: i32 = -5014i32;
pub const DISPID_ACC_SELECTION: i32 = -5012i32;
pub const DISPID_ACC_STATE: i32 = -5007i32;
pub const DISPID_ACC_VALUE: i32 = -5004i32;
pub const DataGrid_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2226619311,
    53507,
    19210,
    [132, 21, 231, 57, 66, 65, 15, 75],
);
pub const DataItem_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2685892674,
    55631,
    17061,
    [129, 75, 96, 104, 173, 220, 141, 165],
);
pub const DescribedBy_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2086167992,
        39314,
        16637,
        [141, 176, 107, 241, 211, 23, 249, 152],
    );
pub unsafe fn DockPattern_SetDockPosition<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HUIAPATTERNOBJECT>,
>(
    hobj: Param0,
    dockposition: DockPosition,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "uiautomationcore")]
        extern "system" {
            fn DockPattern_SetDockPosition(
                hobj: HUIAPATTERNOBJECT,
                dockposition: DockPosition,
            ) -> ::windows::runtime::HRESULT;
        }
        DockPattern_SetDockPosition(hobj.into_param().abi(), ::std::mem::transmute(dockposition))
            .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct DockPosition(pub i32);
pub const DockPosition_Top: DockPosition = DockPosition(0i32);
pub const DockPosition_Left: DockPosition = DockPosition(1i32);
pub const DockPosition_Bottom: DockPosition = DockPosition(2i32);
pub const DockPosition_Right: DockPosition = DockPosition(3i32);
pub const DockPosition_Fill: DockPosition = DockPosition(4i32);
pub const DockPosition_None: DockPosition = DockPosition(5i32);
impl ::std::convert::From<i32> for DockPosition {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for DockPosition {
    type Abi = Self;
    type DefaultType = Self;
}
pub const Dock_DockPosition_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1835528238,
        49328,
        19216,
        [181, 185, 24, 214, 236, 249, 135, 96],
    );
pub const Dock_Pattern_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2629478470,
    33736,
    17037,
    [130, 127, 126, 96, 99, 254, 6, 32],
);
pub const Document_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1020705647,
    28424,
    17762,
    [178, 41, 228, 226, 252, 122, 158, 180],
);
pub const Drag_DragCancel_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3287148282,
        13393,
        19983,
        [158, 113, 223, 156, 40, 10, 70, 87],
    );
pub const Drag_DragComplete_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        954818952,
        61215,
        17982,
        [145, 202, 58, 119, 146, 194, 156, 175],
    );
pub const Drag_DragStart_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2285520907,
        15017,
        17053,
        [149, 228, 217, 200, 208, 17, 240, 221],
    );
pub const Drag_DropEffect_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1685006201,
        18643,
        19235,
        [137, 2, 75, 241, 0, 0, 93, 243],
    );
pub const Drag_DropEffects_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4124447062,
        31974,
        18878,
        [168, 54, 146, 105, 220, 236, 146, 15],
    );
pub const Drag_GrabbedItems_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2009159212,
        31622,
        19233,
        [158, 215, 60, 239, 218, 111, 76, 67],
    );
pub const Drag_IsGrabbed_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1173489395,
        30156,
        19658,
        [169, 185, 252, 223, 185, 130, 216, 162],
    );
pub const Drag_Pattern_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3233735199,
    52403,
    20461,
    [153, 91, 17, 79, 110, 61, 39, 40],
);
pub const DropTarget_DragEnter_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2866360731,
        812,
        19080,
        [150, 29, 28, 245, 121, 88, 30, 52],
    );
pub const DropTarget_DragLeave_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        260238101,
        9378,
        18824,
        [146, 23, 222, 22, 42, 238, 39, 43],
    );
pub const DropTarget_DropTargetEffect_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2344049013,
        41162,
        18817,
        [184, 24, 135, 252, 102, 233, 80, 157],
    );
pub const DropTarget_DropTargetEffects_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3156071661,
        52105,
        17905,
        [165, 146, 224, 59, 8, 174, 121, 15],
    );
pub const DropTarget_Dropped_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1647110872,
        7899,
        19005,
        [171, 188, 190, 34, 17, 255, 104, 181],
    );
pub const DropTarget_Pattern_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    197913686,
    48436,
    19323,
    [159, 213, 38, 89, 144, 94, 163, 220],
);
pub const Edit_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1694803400,
    11398,
    20359,
    [174, 123, 26, 189, 220, 129, 12, 249],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EventArgsType(pub i32);
pub const EventArgsType_Simple: EventArgsType = EventArgsType(0i32);
pub const EventArgsType_PropertyChanged: EventArgsType = EventArgsType(1i32);
pub const EventArgsType_StructureChanged: EventArgsType = EventArgsType(2i32);
pub const EventArgsType_AsyncContentLoaded: EventArgsType = EventArgsType(3i32);
pub const EventArgsType_WindowClosed: EventArgsType = EventArgsType(4i32);
pub const EventArgsType_TextEditTextChanged: EventArgsType = EventArgsType(5i32);
pub const EventArgsType_Changes: EventArgsType = EventArgsType(6i32);
pub const EventArgsType_Notification: EventArgsType = EventArgsType(7i32);
pub const EventArgsType_ActiveTextPositionChanged: EventArgsType = EventArgsType(8i32);
pub const EventArgsType_StructuredMarkup: EventArgsType = EventArgsType(9i32);
impl ::std::convert::From<i32> for EventArgsType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EventArgsType {
    type Abi = Self;
    type DefaultType = Self;
}
pub unsafe fn ExpandCollapsePattern_Collapse<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HUIAPATTERNOBJECT>,
>(
    hobj: Param0,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "uiautomationcore")]
        extern "system" {
            fn ExpandCollapsePattern_Collapse(
                hobj: HUIAPATTERNOBJECT,
            ) -> ::windows::runtime::HRESULT;
        }
        ExpandCollapsePattern_Collapse(hobj.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub unsafe fn ExpandCollapsePattern_Expand<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HUIAPATTERNOBJECT>,
>(
    hobj: Param0,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "uiautomationcore")]
        extern "system" {
            fn ExpandCollapsePattern_Expand(hobj: HUIAPATTERNOBJECT)
                -> ::windows::runtime::HRESULT;
        }
        ExpandCollapsePattern_Expand(hobj.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct ExpandCollapseState(pub i32);
pub const ExpandCollapseState_Collapsed: ExpandCollapseState = ExpandCollapseState(0i32);
pub const ExpandCollapseState_Expanded: ExpandCollapseState = ExpandCollapseState(1i32);
pub const ExpandCollapseState_PartiallyExpanded: ExpandCollapseState = ExpandCollapseState(2i32);
pub const ExpandCollapseState_LeafNode: ExpandCollapseState = ExpandCollapseState(3i32);
impl ::std::convert::From<i32> for ExpandCollapseState {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for ExpandCollapseState {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ExpandCollapse_ExpandCollapseState_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        660229192,
        34215,
        20329,
        [171, 160, 175, 21, 118, 16, 0, 43],
    );
pub const ExpandCollapse_Pattern_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2919624610,
        63953,
        17034,
        [131, 76, 83, 165, 197, 47, 155, 139],
    );
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct ExtendedProperty {
    pub PropertyName: super::super::Foundation::BSTR,
    pub PropertyValue: super::super::Foundation::BSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl ExtendedProperty {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for ExtendedProperty {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for ExtendedProperty {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ExtendedProperty")
            .field("PropertyName", &self.PropertyName)
            .field("PropertyValue", &self.PropertyValue)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for ExtendedProperty {
    fn eq(&self, other: &Self) -> bool {
        self.PropertyName == other.PropertyName && self.PropertyValue == other.PropertyValue
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for ExtendedProperty {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for ExtendedProperty {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct FILTERKEYS {
    pub cbSize: u32,
    pub dwFlags: u32,
    pub iWaitMSec: u32,
    pub iDelayMSec: u32,
    pub iRepeatMSec: u32,
    pub iBounceMSec: u32,
}
impl FILTERKEYS {}
impl ::std::default::Default for FILTERKEYS {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for FILTERKEYS {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FILTERKEYS")
            .field("cbSize", &self.cbSize)
            .field("dwFlags", &self.dwFlags)
            .field("iWaitMSec", &self.iWaitMSec)
            .field("iDelayMSec", &self.iDelayMSec)
            .field("iRepeatMSec", &self.iRepeatMSec)
            .field("iBounceMSec", &self.iBounceMSec)
            .finish()
    }
}
impl ::std::cmp::PartialEq for FILTERKEYS {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwFlags == other.dwFlags
            && self.iWaitMSec == other.iWaitMSec
            && self.iDelayMSec == other.iDelayMSec
            && self.iRepeatMSec == other.iRepeatMSec
            && self.iBounceMSec == other.iBounceMSec
    }
}
impl ::std::cmp::Eq for FILTERKEYS {}
unsafe impl ::windows::runtime::Abi for FILTERKEYS {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FillColor_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1846461648,
    58024,
    19030,
    [157, 231, 149, 51, 137, 147, 59, 57],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FillType(pub i32);
pub const FillType_None: FillType = FillType(0i32);
pub const FillType_Color: FillType = FillType(1i32);
pub const FillType_Gradient: FillType = FillType(2i32);
pub const FillType_Picture: FillType = FillType(3i32);
pub const FillType_Pattern: FillType = FillType(4i32);
impl ::std::convert::From<i32> for FillType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FillType {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FillType_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3338433764,
    36025,
    17052,
    [169, 225, 155, 196, 172, 55, 43, 98],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct FlowDirections(pub i32);
pub const FlowDirections_Default: FlowDirections = FlowDirections(0i32);
pub const FlowDirections_RightToLeft: FlowDirections = FlowDirections(1i32);
pub const FlowDirections_BottomToTop: FlowDirections = FlowDirections(2i32);
pub const FlowDirections_Vertical: FlowDirections = FlowDirections(4i32);
impl ::std::convert::From<i32> for FlowDirections {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for FlowDirections {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FlowsFrom_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    96896079,
    6622,
    18680,
    [149, 250, 136, 13, 91, 15, 214, 21],
);
pub const FlowsTo_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3841146144,
    21914,
    18427,
    [168, 48, 249, 203, 79, 241, 167, 10],
);
pub const FrameworkId_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3690830080,
        32282,
        20312,
        [182, 27, 112, 99, 18, 15, 119, 59],
    );
pub const FullDescription_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        222580991,
        27375,
        20275,
        [149, 221, 123, 239, 167, 42, 67, 145],
    );
pub unsafe fn GetOleaccVersionInfo(pver: *mut u32, pbuild: *mut u32) {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn GetOleaccVersionInfo(pver: *mut u32, pbuild: *mut u32);
        }
        ::std::mem::transmute(GetOleaccVersionInfo(
            ::std::mem::transmute(pver),
            ::std::mem::transmute(pbuild),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetRoleTextA(
    lrole: u32,
    lpszrole: super::super::Foundation::PSTR,
    cchrolemax: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn GetRoleTextA(
                lrole: u32,
                lpszrole: super::super::Foundation::PSTR,
                cchrolemax: u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetRoleTextA(
            ::std::mem::transmute(lrole),
            ::std::mem::transmute(lpszrole),
            ::std::mem::transmute(cchrolemax),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetRoleTextW(
    lrole: u32,
    lpszrole: super::super::Foundation::PWSTR,
    cchrolemax: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn GetRoleTextW(
                lrole: u32,
                lpszrole: super::super::Foundation::PWSTR,
                cchrolemax: u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetRoleTextW(
            ::std::mem::transmute(lrole),
            ::std::mem::transmute(lpszrole),
            ::std::mem::transmute(cchrolemax),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetStateTextA(
    lstatebit: u32,
    lpszstate: super::super::Foundation::PSTR,
    cchstate: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn GetStateTextA(
                lstatebit: u32,
                lpszstate: super::super::Foundation::PSTR,
                cchstate: u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetStateTextA(
            ::std::mem::transmute(lstatebit),
            ::std::mem::transmute(lpszstate),
            ::std::mem::transmute(cchstate),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetStateTextW(
    lstatebit: u32,
    lpszstate: super::super::Foundation::PWSTR,
    cchstate: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "oleacc")]
        extern "system" {
            fn GetStateTextW(
                lstatebit: u32,
                lpszstate: super::super::Foundation::PWSTR,
                cchstate: u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetStateTextW(
            ::std::mem::transmute(lstatebit),
            ::std::mem::transmute(lpszstate),
            ::std::mem::transmute(cchstate),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const GridItem_ColumnSpan_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1480500213,
        34512,
        19208,
        [166, 236, 44, 84, 99, 255, 193, 9],
    );
pub const GridItem_Column_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3346317660,
        25280,
        17689,
        [139, 220, 71, 190, 87, 60, 138, 213],
    );
pub const GridItem_Parent_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        2643534418,
        47487,
        20172,
        [133, 16, 234, 14, 51, 66, 124, 114],
    );
pub const GridItem_Pattern_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4074096759,
    42082,
    18775,
    [162, 165, 44, 150, 179, 3, 188, 99],
);
pub const GridItem_RowSpan_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1166158108,
        18027,
        20115,
        [142, 131, 61, 23, 21, 236, 12, 94],
    );
pub const GridItem_Row_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1646499626,
        51525,
        17763,
        [147, 41, 253, 201, 116, 175, 37, 83],
    );
pub unsafe fn GridPattern_GetItem<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, HUIAPATTERNOBJECT>,
>(
    hobj: Param0,
    row: i32,
    column: i32,
    presult: *mut HUIANODE,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "uiautomationcore")]
        extern "system" {
            fn GridPattern_GetItem(
                hobj: HUIAPATTERNOBJECT,
                row: i32,
                column: i32,
                presult: *mut HUIANODE,
            ) -> ::windows::runtime::HRESULT;
        }
        GridPattern_GetItem(
            hobj.into_param().abi(),
            ::std::mem::transmute(row),
            ::std::mem::transmute(column),
            ::std::mem::transmute(presult),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const Grid_ColumnCount_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4271305589,
        17578,
        17718,
        [172, 122, 42, 117, 215, 26, 62, 252],
    );
pub const Grid_Pattern_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    638201035,
    37800,
    20036,
    [164, 193, 61, 243, 151, 242, 176, 43],
);
pub const Grid_RowCount_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        714409407,
        49899,
        20406,
        [179, 86, 130, 69, 174, 83, 112, 62],
    );
pub const Group_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2907744796,
    59592,
    18292,
    [174, 27, 221, 134, 223, 11, 59, 220],
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct HIGHCONTRASTA {
    pub cbSize: u32,
    pub dwFlags: HIGHCONTRASTW_FLAGS,
    pub lpszDefaultScheme: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl HIGHCONTRASTA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for HIGHCONTRASTA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for HIGHCONTRASTA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HIGHCONTRASTA")
            .field("cbSize", &self.cbSize)
            .field("dwFlags", &self.dwFlags)
            .field("lpszDefaultScheme", &self.lpszDefaultScheme)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for HIGHCONTRASTA {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwFlags == other.dwFlags
            && self.lpszDefaultScheme == other.lpszDefaultScheme
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for HIGHCONTRASTA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for HIGHCONTRASTA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct HIGHCONTRASTW {
    pub cbSize: u32,
    pub dwFlags: HIGHCONTRASTW_FLAGS,
    pub lpszDefaultScheme: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl HIGHCONTRASTW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for HIGHCONTRASTW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for HIGHCONTRASTW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("HIGHCONTRASTW")
            .field("cbSize", &self.cbSize)
            .field("dwFlags", &self.dwFlags)
            .field("lpszDefaultScheme", &self.lpszDefaultScheme)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for HIGHCONTRASTW {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.dwFlags == other.dwFlags
            && self.lpszDefaultScheme == other.lpszDefaultScheme
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for HIGHCONTRASTW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for HIGHCONTRASTW {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HIGHCONTRASTW_FLAGS(pub u32);
pub const HCF_HIGHCONTRASTON: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(1u32);
pub const HCF_AVAILABLE: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(2u32);
pub const HCF_HOTKEYACTIVE: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(4u32);
pub const HCF_CONFIRMHOTKEY: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(8u32);
pub const HCF_HOTKEYSOUND: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(16u32);
pub const HCF_INDICATOR: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(32u32);
pub const HCF_HOTKEYAVAILABLE: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(64u32);
pub const HCF_OPTION_NOTHEMECHANGE: HIGHCONTRASTW_FLAGS = HIGHCONTRASTW_FLAGS(4096u32);
impl ::std::convert::From<u32> for HIGHCONTRASTW_FLAGS {
    fn from(value: u32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HIGHCONTRASTW_FLAGS {
    type Abi = Self;
    type DefaultType = Self;
}
impl ::std::ops::BitOr for HIGHCONTRASTW_FLAGS {
    type Output = Self;
    fn bitor(self, rhs: Self) -> Self {
        Self(self.0 | rhs.0)
    }
}
impl ::std::ops::BitAnd for HIGHCONTRASTW_FLAGS {
    type Output = Self;
    fn bitand(self, rhs: Self) -> Self {
        Self(self.0 & rhs.0)
    }
}
impl ::std::ops::BitOrAssign for HIGHCONTRASTW_FLAGS {
    fn bitor_assign(&mut self, rhs: Self) {
        self.0.bitor_assign(rhs.0)
    }
}
impl ::std::ops::BitAndAssign for HIGHCONTRASTW_FLAGS {
    fn bitand_assign(&mut self, rhs: Self) {
        self.0.bitand_assign(rhs.0)
    }
}
impl ::std::ops::Not for HIGHCONTRASTW_FLAGS {
    type Output = Self;
    fn not(self) -> Self {
        Self(self.0.not())
    }
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HUIAEVENT(pub isize);
impl ::std::default::Default for HUIAEVENT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HUIAEVENT {}
unsafe impl ::windows::runtime::Abi for HUIAEVENT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HUIANODE(pub isize);
impl ::std::default::Default for HUIANODE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HUIANODE {}
unsafe impl ::windows::runtime::Abi for HUIANODE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HUIAPATTERNOBJECT(pub isize);
impl ::std::default::Default for HUIAPATTERNOBJECT {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HUIAPATTERNOBJECT {}
unsafe impl ::windows::runtime::Abi for HUIAPATTERNOBJECT {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HUIATEXTRANGE(pub isize);
impl ::std::default::Default for HUIATEXTRANGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HUIATEXTRANGE {}
unsafe impl ::windows::runtime::Abi for HUIATEXTRANGE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: clone :: Clone,
    :: std :: marker :: Copy,
    :: std :: fmt :: Debug,
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
)]
#[repr(transparent)]
pub struct HWINEVENTHOOK(pub isize);
impl ::std::default::Default for HWINEVENTHOOK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
unsafe impl ::windows::runtime::Handle for HWINEVENTHOOK {}
unsafe impl ::windows::runtime::Abi for HWINEVENTHOOK {
    type Abi = Self;
    type DefaultType = Self;
}
pub const HasKeyboardFocus_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3481992505,
        16198,
        18432,
        [150, 86, 178, 191, 18, 82, 153, 5],
    );
pub const HeaderItem_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3871085259,
    31886,
    18895,
    [177, 104, 74, 147, 163, 43, 235, 176],
);
pub const Header_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1536216014,
    30971,
    17940,
    [130, 182, 85, 77, 116, 113, 142, 103],
);
pub const HeadingLevel1: i32 = 80051i32;
pub const HeadingLevel2: i32 = 80052i32;
pub const HeadingLevel3: i32 = 80053i32;
pub const HeadingLevel4: i32 = 80054i32;
pub const HeadingLevel5: i32 = 80055i32;
pub const HeadingLevel6: i32 = 80056i32;
pub const HeadingLevel7: i32 = 80057i32;
pub const HeadingLevel8: i32 = 80058i32;
pub const HeadingLevel9: i32 = 80059i32;
pub const HeadingLevel_None: i32 = 80050i32;
pub const HeadingLevel_Property_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        688407154,
        43695,
        18992,
        [135, 150, 60, 18, 246, 43, 107, 187],
    );
pub const HelpText_Property_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    139810437,
    2423,
    17863,
    [167, 166, 171, 175, 86, 132, 18, 26],
);
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct HorizontalTextAlignment(pub i32);
pub const HorizontalTextAlignment_Left: HorizontalTextAlignment = HorizontalTextAlignment(0i32);
pub const HorizontalTextAlignment_Centered: HorizontalTextAlignment = HorizontalTextAlignment(1i32);
pub const HorizontalTextAlignment_Right: HorizontalTextAlignment = HorizontalTextAlignment(2i32);
pub const HorizontalTextAlignment_Justified: HorizontalTextAlignment =
    HorizontalTextAlignment(3i32);
impl ::std::convert::From<i32> for HorizontalTextAlignment {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for HorizontalTextAlignment {
    type Abi = Self;
    type DefaultType = Self;
}
pub const HostedFragmentRootsInvalidated_Event_GUID: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        3871191102,
        2337,
        20165,
        [141, 207, 234, 232, 119, 176, 66, 107],
    );
pub const Hyperlink_Control_GUID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2320892460,
    45069,
    19733,
    [143, 240, 91, 107, 38, 110, 94, 2],
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccIdentity(::windows::runtime::IUnknown);
impl IAccIdentity {
    pub unsafe fn GetIdentityString(
        &self,
        dwidchild: u32,
        ppidstring: *mut *mut u8,
        pdwidstringlen: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwidchild),
            ::std::mem::transmute(ppidstring),
            ::std::mem::transmute(pdwidstringlen),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAccIdentity {
    type Vtable = IAccIdentity_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2018686861,
        7421,
        16833,
        [166, 21, 156, 12, 133, 150, 11, 95],
    );
}
impl ::std::convert::From<IAccIdentity> for ::windows::runtime::IUnknown {
    fn from(value: IAccIdentity) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccIdentity> for ::windows::runtime::IUnknown {
    fn from(value: &IAccIdentity) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAccIdentity {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAccIdentity {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccIdentity_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwidchild: u32,
        ppidstring: *mut *mut u8,
        pdwidstringlen: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccPropServer(::windows::runtime::IUnknown);
impl IAccPropServer {
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetPropValue<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
    >(
        &self,
        pidstring: *const u8,
        dwidstringlen: u32,
        idprop: Param2,
        pvarvalue: *mut super::super::System::OleAutomation::VARIANT,
        pfhasprop: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidstring),
            ::std::mem::transmute(dwidstringlen),
            idprop.into_param().abi(),
            ::std::mem::transmute(pvarvalue),
            ::std::mem::transmute(pfhasprop),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAccPropServer {
    type Vtable = IAccPropServer_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1992350651,
        5600,
        20091,
        [182, 27, 32, 238, 234, 32, 1, 224],
    );
}
impl ::std::convert::From<IAccPropServer> for ::windows::runtime::IUnknown {
    fn from(value: IAccPropServer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccPropServer> for ::windows::runtime::IUnknown {
    fn from(value: &IAccPropServer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAccPropServer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAccPropServer {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccPropServer_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidstring: *const u8,
        dwidstringlen: u32,
        idprop: ::windows::runtime::GUID,
        pvarvalue: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pfhasprop: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccPropServices(::windows::runtime::IUnknown);
impl IAccPropServices {
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn SetPropValue<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        pidstring: *const u8,
        dwidstringlen: u32,
        idprop: Param2,
        var: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidstring),
            ::std::mem::transmute(dwidstringlen),
            idprop.into_param().abi(),
            var.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetPropServer<'a, Param4: ::windows::runtime::IntoParam<'a, IAccPropServer>>(
        &self,
        pidstring: *const u8,
        dwidstringlen: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
        pserver: Param4,
        annoscope: AnnoScope,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidstring),
            ::std::mem::transmute(dwidstringlen),
            ::std::mem::transmute(paprops),
            ::std::mem::transmute(cprops),
            pserver.into_param().abi(),
            ::std::mem::transmute(annoscope),
        )
        .ok()
    }
    pub unsafe fn ClearProps(
        &self,
        pidstring: *const u8,
        dwidstringlen: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidstring),
            ::std::mem::transmute(dwidstringlen),
            ::std::mem::transmute(paprops),
            ::std::mem::transmute(cprops),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn SetHwndProp<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param3: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
        Param4: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        hwnd: Param0,
        idobject: u32,
        idchild: u32,
        idprop: Param3,
        var: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(idchild),
            idprop.into_param().abi(),
            var.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHwndPropStr<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param3: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
        Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hwnd: Param0,
        idobject: u32,
        idchild: u32,
        idprop: Param3,
        str: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(idchild),
            idprop.into_param().abi(),
            str.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetHwndPropServer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param5: ::windows::runtime::IntoParam<'a, IAccPropServer>,
    >(
        &self,
        hwnd: Param0,
        idobject: u32,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
        pserver: Param5,
        annoscope: AnnoScope,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(idchild),
            ::std::mem::transmute(paprops),
            ::std::mem::transmute(cprops),
            pserver.into_param().abi(),
            ::std::mem::transmute(annoscope),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ClearHwndProps<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
        idobject: u32,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(idchild),
            ::std::mem::transmute(paprops),
            ::std::mem::transmute(cprops),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ComposeHwndIdentityString<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
        idobject: u32,
        idchild: u32,
        ppidstring: *mut *mut u8,
        pdwidstringlen: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(idchild),
            ::std::mem::transmute(ppidstring),
            ::std::mem::transmute(pdwidstringlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DecomposeHwndIdentityString(
        &self,
        pidstring: *const u8,
        dwidstringlen: u32,
        phwnd: *mut super::super::Foundation::HWND,
        pidobject: *mut u32,
        pidchild: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidstring),
            ::std::mem::transmute(dwidstringlen),
            ::std::mem::transmute(phwnd),
            ::std::mem::transmute(pidobject),
            ::std::mem::transmute(pidchild),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn SetHmenuProp<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HMENU>,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        hmenu: Param0,
        idchild: u32,
        idprop: Param2,
        var: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            hmenu.into_param().abi(),
            ::std::mem::transmute(idchild),
            idprop.into_param().abi(),
            var.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub unsafe fn SetHmenuPropStr<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HMENU>,
        Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hmenu: Param0,
        idchild: u32,
        idprop: Param2,
        str: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            hmenu.into_param().abi(),
            ::std::mem::transmute(idchild),
            idprop.into_param().abi(),
            str.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn SetHmenuPropServer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HMENU>,
        Param4: ::windows::runtime::IntoParam<'a, IAccPropServer>,
    >(
        &self,
        hmenu: Param0,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
        pserver: Param4,
        annoscope: AnnoScope,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            hmenu.into_param().abi(),
            ::std::mem::transmute(idchild),
            ::std::mem::transmute(paprops),
            ::std::mem::transmute(cprops),
            pserver.into_param().abi(),
            ::std::mem::transmute(annoscope),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn ClearHmenuProps<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HMENU>,
    >(
        &self,
        hmenu: Param0,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            hmenu.into_param().abi(),
            ::std::mem::transmute(idchild),
            ::std::mem::transmute(paprops),
            ::std::mem::transmute(cprops),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn ComposeHmenuIdentityString<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::WindowsAndMessaging::HMENU>,
    >(
        &self,
        hmenu: Param0,
        idchild: u32,
        ppidstring: *mut *mut u8,
        pdwidstringlen: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            hmenu.into_param().abi(),
            ::std::mem::transmute(idchild),
            ::std::mem::transmute(ppidstring),
            ::std::mem::transmute(pdwidstringlen),
        )
        .ok()
    }
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub unsafe fn DecomposeHmenuIdentityString(
        &self,
        pidstring: *const u8,
        dwidstringlen: u32,
        phmenu: *mut super::WindowsAndMessaging::HMENU,
        pidchild: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pidstring),
            ::std::mem::transmute(dwidstringlen),
            ::std::mem::transmute(phmenu),
            ::std::mem::transmute(pidchild),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAccPropServices {
    type Vtable = IAccPropServices_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1848043382,
        1264,
        18781,
        [128, 228, 51, 48, 53, 46, 49, 105],
    );
}
impl ::std::convert::From<IAccPropServices> for ::windows::runtime::IUnknown {
    fn from(value: IAccPropServices) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccPropServices> for ::windows::runtime::IUnknown {
    fn from(value: &IAccPropServices) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAccPropServices {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAccPropServices {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccPropServices_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidstring: *const u8,
        dwidstringlen: u32,
        idprop: ::windows::runtime::GUID,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidstring: *const u8,
        dwidstringlen: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
        pserver: ::windows::runtime::RawPtr,
        annoscope: AnnoScope,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidstring: *const u8,
        dwidstringlen: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        idobject: u32,
        idchild: u32,
        idprop: ::windows::runtime::GUID,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        idobject: u32,
        idchild: u32,
        idprop: ::windows::runtime::GUID,
        str: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        idobject: u32,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
        pserver: ::windows::runtime::RawPtr,
        annoscope: AnnoScope,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        idobject: u32,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        idobject: u32,
        idchild: u32,
        ppidstring: *mut *mut u8,
        pdwidstringlen: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidstring: *const u8,
        dwidstringlen: u32,
        phwnd: *mut super::super::Foundation::HWND,
        pidobject: *mut u32,
        pidchild: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hmenu: super::WindowsAndMessaging::HMENU,
        idchild: u32,
        idprop: ::windows::runtime::GUID,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hmenu: super::WindowsAndMessaging::HMENU,
        idchild: u32,
        idprop: ::windows::runtime::GUID,
        str: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging")))] usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hmenu: super::WindowsAndMessaging::HMENU,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
        pserver: ::windows::runtime::RawPtr,
        annoscope: AnnoScope,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))] usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hmenu: super::WindowsAndMessaging::HMENU,
        idchild: u32,
        paprops: *const ::windows::runtime::GUID,
        cprops: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))] usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hmenu: super::WindowsAndMessaging::HMENU,
        idchild: u32,
        ppidstring: *mut *mut u8,
        pdwidstringlen: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))] usize,
    #[cfg(feature = "Win32_UI_WindowsAndMessaging")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pidstring: *const u8,
        dwidstringlen: u32,
        phmenu: *mut super::WindowsAndMessaging::HMENU,
        pidchild: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_UI_WindowsAndMessaging"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccessible(::windows::runtime::IUnknown);
impl IAccessible {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn accParent(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    pub unsafe fn accChildCount(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accChild<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::IDispatch> {
        let mut result__ : < super::super::System::OleAutomation:: IDispatch as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::IDispatch>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accDescription<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accRole<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accState<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accHelp<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accHelpTopic<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        pszhelpfile: *mut super::super::Foundation::BSTR,
        varchild: Param1,
        pidtopic: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pszhelpfile),
            varchild.into_param().abi(),
            ::std::mem::transmute(pidtopic),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accKeyboardShortcut<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accSelection(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accDefaultAction<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accSelect<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        flagsselect: i32,
        varchild: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(flagsselect),
            varchild.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accLocation<
        'a,
        Param4: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        pxleft: *mut i32,
        pytop: *mut i32,
        pcxwidth: *mut i32,
        pcyheight: *mut i32,
        varchild: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pxleft),
            ::std::mem::transmute(pytop),
            ::std::mem::transmute(pcxwidth),
            ::std::mem::transmute(pcyheight),
            varchild.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accNavigate<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        navdir: i32,
        varstart: Param1,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(navdir),
            varstart.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accHitTest(
        &self,
        xleft: i32,
        ytop: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(xleft),
            ::std::mem::transmute(ytop),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn accDoDefaultAction<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        varchild: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn SetaccName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        varchild: Param0,
        szname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            szname.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn SetaccValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        varchild: Param0,
        szvalue: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            varchild.into_param().abi(),
            szvalue.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAccessible {
    type Vtable = IAccessible_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1636251360,
        15421,
        4559,
        [129, 12, 0, 170, 0, 56, 155, 113],
    );
}
impl ::std::convert::From<IAccessible> for ::windows::runtime::IUnknown {
    fn from(value: IAccessible) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccessible> for ::windows::runtime::IUnknown {
    fn from(value: &IAccessible) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAccessible {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAccessible {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IAccessible> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IAccessible) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IAccessible> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IAccessible) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IAccessible
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IAccessible
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessible_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppdispparent: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcountchildren: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        ppdispchild: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pszname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pszvalue: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pszdescription: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarrole: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarstate: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pszhelp: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszhelpfile: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pidtopic: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pszkeyboardshortcut: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvarchild: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvarchildren: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pszdefaultaction: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flagsselect: i32,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pxleft: *mut i32,
        pytop: *mut i32,
        pcxwidth: *mut i32,
        pcyheight: *mut i32,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        navdir: i32,
        varstart: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pvarendupat: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        xleft: i32,
        ytop: i32,
        pvarchild: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        szname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        varchild: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        szvalue: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccessibleEx(::windows::runtime::IUnknown);
impl IAccessibleEx {
    pub unsafe fn GetObjectForChild(
        &self,
        idchild: i32,
    ) -> ::windows::runtime::Result<IAccessibleEx> {
        let mut result__: <IAccessibleEx as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(idchild),
            &mut result__,
        )
        .from_abi::<IAccessibleEx>(result__)
    }
    pub unsafe fn GetIAccessiblePair(
        &self,
        ppacc: *mut ::std::option::Option<IAccessible>,
        pidchild: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppacc),
            ::std::mem::transmute(pidchild),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRuntimeId(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn ConvertReturnedElement<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        pin: Param0,
    ) -> ::windows::runtime::Result<IAccessibleEx> {
        let mut result__: <IAccessibleEx as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            pin.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IAccessibleEx>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAccessibleEx {
    type Vtable = IAccessibleEx_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4172810970,
        11332,
        18640,
        [137, 190, 95, 242, 60, 156, 216, 117],
    );
}
impl ::std::convert::From<IAccessibleEx> for ::windows::runtime::IUnknown {
    fn from(value: IAccessibleEx) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccessibleEx> for ::windows::runtime::IUnknown {
    fn from(value: &IAccessibleEx) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAccessibleEx {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAccessibleEx {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleEx_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        idchild: i32,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppacc: *mut ::windows::runtime::RawPtr,
        pidchild: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pin: ::windows::runtime::RawPtr,
        ppretvalout: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccessibleHandler(::windows::runtime::IUnknown);
impl IAccessibleHandler {
    pub unsafe fn AccessibleObjectFromID(
        &self,
        hwnd: i32,
        lobjectid: i32,
    ) -> ::windows::runtime::Result<IAccessible> {
        let mut result__: <IAccessible as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(hwnd),
            ::std::mem::transmute(lobjectid),
            &mut result__,
        )
        .from_abi::<IAccessible>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAccessibleHandler {
    type Vtable = IAccessibleHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        50471984,
        43972,
        4560,
        [189, 226, 0, 170, 0, 26, 25, 83],
    );
}
impl ::std::convert::From<IAccessibleHandler> for ::windows::runtime::IUnknown {
    fn from(value: IAccessibleHandler) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccessibleHandler> for ::windows::runtime::IUnknown {
    fn from(value: &IAccessibleHandler) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAccessibleHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAccessibleHandler {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleHandler_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: i32,
        lobjectid: i32,
        piaccessible: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccessibleHostingElementProviders(::windows::runtime::IUnknown);
impl IAccessibleHostingElementProviders {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetEmbeddedFragmentRoots(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn GetObjectIdForProvider<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        pprovider: Param0,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pprovider.into_param().abi(),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAccessibleHostingElementProviders {
    type Vtable = IAccessibleHostingElementProviders_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        866923291,
        37950,
        16416,
        [178, 149, 219, 55, 120, 73, 116, 163],
    );
}
impl ::std::convert::From<IAccessibleHostingElementProviders> for ::windows::runtime::IUnknown {
    fn from(value: IAccessibleHostingElementProviders) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccessibleHostingElementProviders> for ::windows::runtime::IUnknown {
    fn from(value: &IAccessibleHostingElementProviders) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IAccessibleHostingElementProviders
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IAccessibleHostingElementProviders
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleHostingElementProviders_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprovider: ::windows::runtime::RawPtr,
        pidobject: *mut i32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAccessibleWindowlessSite(::windows::runtime::IUnknown);
impl IAccessibleWindowlessSite {
    pub unsafe fn AcquireObjectIdRange<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IAccessibleHandler>,
    >(
        &self,
        rangesize: i32,
        prangeowner: Param1,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rangesize),
            prangeowner.into_param().abi(),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn ReleaseObjectIdRange<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IAccessibleHandler>,
    >(
        &self,
        rangebase: i32,
        prangeowner: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rangebase),
            prangeowner.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn QueryObjectIdRanges<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessibleHandler>,
    >(
        &self,
        prangesowner: Param0,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            prangesowner.into_param().abi(),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn GetParentAccessible(&self) -> ::windows::runtime::Result<IAccessible> {
        let mut result__: <IAccessible as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IAccessible>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAccessibleWindowlessSite {
    type Vtable = IAccessibleWindowlessSite_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3208297884,
        30426,
        17289,
        [158, 182, 20, 39, 210, 90, 186, 183],
    );
}
impl ::std::convert::From<IAccessibleWindowlessSite> for ::windows::runtime::IUnknown {
    fn from(value: IAccessibleWindowlessSite) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAccessibleWindowlessSite> for ::windows::runtime::IUnknown {
    fn from(value: &IAccessibleWindowlessSite) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IAccessibleWindowlessSite
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IAccessibleWindowlessSite
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAccessibleWindowlessSite_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rangesize: i32,
        prangeowner: ::windows::runtime::RawPtr,
        prangebase: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rangebase: i32,
        prangeowner: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prangesowner: ::windows::runtime::RawPtr,
        psaranges: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppparent: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAnnotationProvider(::windows::runtime::IUnknown);
impl IAnnotationProvider {
    pub unsafe fn AnnotationTypeId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AnnotationTypeName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Author(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DateTime(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Target(&self) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IAnnotationProvider {
    type Vtable = IAnnotationProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4183588480,
        48483,
        17921,
        [151, 130, 68, 94, 191, 240, 17, 252],
    );
}
impl ::std::convert::From<IAnnotationProvider> for ::windows::runtime::IUnknown {
    fn from(value: IAnnotationProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAnnotationProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IAnnotationProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IAnnotationProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IAnnotationProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAnnotationProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ICustomNavigationProvider(::windows::runtime::IUnknown);
impl ICustomNavigationProvider {
    pub unsafe fn Navigate(
        &self,
        direction: NavigateDirection,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(direction),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ICustomNavigationProvider {
    type Vtable = ICustomNavigationProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        543335050,
        35847,
        19348,
        [142, 18, 112, 55, 198, 34, 174, 184],
    );
}
impl ::std::convert::From<ICustomNavigationProvider> for ::windows::runtime::IUnknown {
    fn from(value: ICustomNavigationProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ICustomNavigationProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ICustomNavigationProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ICustomNavigationProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ICustomNavigationProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ICustomNavigationProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        direction: NavigateDirection,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IDockProvider(::windows::runtime::IUnknown);
impl IDockProvider {
    pub unsafe fn SetDockPosition(
        &self,
        dockposition: DockPosition,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dockposition),
        )
        .ok()
    }
    pub unsafe fn DockPosition(&self) -> ::windows::runtime::Result<DockPosition> {
        let mut result__: <DockPosition as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<DockPosition>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IDockProvider {
    type Vtable = IDockProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        362530604,
        19155,
        18526,
        [150, 55, 215, 5, 46, 223, 1, 70],
    );
}
impl ::std::convert::From<IDockProvider> for ::windows::runtime::IUnknown {
    fn from(value: IDockProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IDockProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IDockProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IDockProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IDockProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDockProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dockposition: DockPosition,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut DockPosition,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IDragProvider(::windows::runtime::IUnknown);
impl IDragProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsGrabbed(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DropEffect(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn DropEffects(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetGrabbedItems(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IDragProvider {
    type Vtable = IDragProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1789377467,
        32761,
        18813,
        [144, 79, 210, 11, 137, 121, 41, 216],
    );
}
impl ::std::convert::From<IDragProvider> for ::windows::runtime::IUnknown {
    fn from(value: IDragProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IDragProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IDragProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IDragProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IDragProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDragProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IDropTargetProvider(::windows::runtime::IUnknown);
impl IDropTargetProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DropTargetEffect(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn DropTargetEffects(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IDropTargetProvider {
    type Vtable = IDropTargetProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3135777789,
        13706,
        18460,
        [133, 160, 216, 180, 217, 10, 93, 97],
    );
}
impl ::std::convert::From<IDropTargetProvider> for ::windows::runtime::IUnknown {
    fn from(value: IDropTargetProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IDropTargetProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IDropTargetProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IDropTargetProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IDropTargetProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IDropTargetProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IExpandCollapseProvider(::windows::runtime::IUnknown);
impl IExpandCollapseProvider {
    pub unsafe fn Expand(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Collapse(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ExpandCollapseState(&self) -> ::windows::runtime::Result<ExpandCollapseState> {
        let mut result__: <ExpandCollapseState as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ExpandCollapseState>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IExpandCollapseProvider {
    type Vtable = IExpandCollapseProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3628585893,
        51888,
        19096,
        [140, 50, 236, 180, 92, 89, 173, 36],
    );
}
impl ::std::convert::From<IExpandCollapseProvider> for ::windows::runtime::IUnknown {
    fn from(value: IExpandCollapseProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IExpandCollapseProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IExpandCollapseProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IExpandCollapseProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IExpandCollapseProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IExpandCollapseProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ExpandCollapseState,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IGridItemProvider(::windows::runtime::IUnknown);
impl IGridItemProvider {
    pub unsafe fn Row(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn Column(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn RowSpan(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn ColumnSpan(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn ContainingGrid(&self) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IGridItemProvider {
    type Vtable = IGridItemProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3492102641,
        64385,
        19812,
        [174, 50, 245, 32, 248, 166, 219, 209],
    );
}
impl ::std::convert::From<IGridItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: IGridItemProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IGridItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IGridItemProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IGridItemProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IGridItemProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IGridItemProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IGridProvider(::windows::runtime::IUnknown);
impl IGridProvider {
    pub unsafe fn GetItem(
        &self,
        row: i32,
        column: i32,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(row),
            ::std::mem::transmute(column),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    pub unsafe fn RowCount(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn ColumnCount(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IGridProvider {
    type Vtable = IGridProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2977784199,
        2311,
        17995,
        [161, 104, 14, 241, 122, 21, 114, 177],
    );
}
impl ::std::convert::From<IGridProvider> for ::windows::runtime::IUnknown {
    fn from(value: IGridProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IGridProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IGridProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IGridProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IGridProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IGridProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        row: i32,
        column: i32,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
);
pub const IIS_ControlAccessible: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    952533670,
    38705,
    17394,
    [159, 174, 233, 1, 230, 65, 177, 1],
);
pub const IIS_IsOleaccProxy: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2418448378,
    32996,
    17760,
    [128, 42, 161, 63, 34, 166, 71, 9],
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IInvokeProvider(::windows::runtime::IUnknown);
impl IInvokeProvider {
    pub unsafe fn Invoke(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IInvokeProvider {
    type Vtable = IInvokeProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1425846859,
        57742,
        18338,
        [180, 211, 236, 203, 231, 117, 153, 162],
    );
}
impl ::std::convert::From<IInvokeProvider> for ::windows::runtime::IUnknown {
    fn from(value: IInvokeProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IInvokeProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IInvokeProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IInvokeProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IInvokeProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IInvokeProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IItemContainerProvider(::windows::runtime::IUnknown);
impl IItemContainerProvider {
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn FindItemByProperty<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        pstartafter: Param0,
        propertyid: i32,
        value: Param2,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pstartafter.into_param().abi(),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IItemContainerProvider {
    type Vtable = IItemContainerProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3880220427,
        14798,
        17282,
        [171, 48, 216, 251, 63, 51, 111, 36],
    );
}
impl ::std::convert::From<IItemContainerProvider> for ::windows::runtime::IUnknown {
    fn from(value: IItemContainerProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IItemContainerProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IItemContainerProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IItemContainerProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IItemContainerProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IItemContainerProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstartafter: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pfound: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ILegacyIAccessibleProvider(::windows::runtime::IUnknown);
impl ILegacyIAccessibleProvider {
    pub unsafe fn Select(&self, flagsselect: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(flagsselect),
        )
        .ok()
    }
    pub unsafe fn DoDefaultAction(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        szvalue: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            szvalue.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetIAccessible(&self) -> ::windows::runtime::Result<IAccessible> {
        let mut result__: <IAccessible as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IAccessible>(result__)
    }
    pub unsafe fn ChildId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Value(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Description(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Role(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn State(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Help(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn KeyboardShortcut(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetSelection(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DefaultAction(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ILegacyIAccessibleProvider {
    type Vtable = ILegacyIAccessibleProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3830199654,
        37213,
        16496,
        [153, 198, 4, 123, 255, 90, 8, 245],
    );
}
impl ::std::convert::From<ILegacyIAccessibleProvider> for ::windows::runtime::IUnknown {
    fn from(value: ILegacyIAccessibleProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ILegacyIAccessibleProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ILegacyIAccessibleProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ILegacyIAccessibleProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ILegacyIAccessibleProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ILegacyIAccessibleProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        flagsselect: i32,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        szvalue: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppaccessible: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszvalue: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszdescription: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwrole: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdwstate: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszhelp: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszkeyboardshortcut: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvarselectedchildren: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszdefaultaction: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IMultipleViewProvider(::windows::runtime::IUnknown);
impl IMultipleViewProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetViewName(
        &self,
        viewid: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(viewid),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn SetCurrentView(&self, viewid: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(viewid),
        )
        .ok()
    }
    pub unsafe fn CurrentView(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetSupportedViews(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IMultipleViewProvider {
    type Vtable = IMultipleViewProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1652083377,
        46422,
        18970,
        [180, 224, 65, 138, 204, 82, 50, 1],
    );
}
impl ::std::convert::From<IMultipleViewProvider> for ::windows::runtime::IUnknown {
    fn from(value: IMultipleViewProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IMultipleViewProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IMultipleViewProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IMultipleViewProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IMultipleViewProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IMultipleViewProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        viewid: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        viewid: i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IObjectModelProvider(::windows::runtime::IUnknown);
impl IObjectModelProvider {
    pub unsafe fn GetUnderlyingObjectModel(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IObjectModelProvider {
    type Vtable = IObjectModelProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        987262653,
        62959,
        18493,
        [187, 24, 177, 4, 42, 71, 93, 100],
    );
}
impl ::std::convert::From<IObjectModelProvider> for ::windows::runtime::IUnknown {
    fn from(value: IObjectModelProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IObjectModelProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IObjectModelProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IObjectModelProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IObjectModelProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IObjectModelProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunknown: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IProxyProviderWinEventHandler(::windows::runtime::IUnknown);
impl IProxyProviderWinEventHandler {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn RespondToWinEvent<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param4: ::windows::runtime::IntoParam<'a, IProxyProviderWinEventSink>,
    >(
        &self,
        idwinevent: u32,
        hwnd: Param1,
        idobject: i32,
        idchild: i32,
        psink: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(idwinevent),
            hwnd.into_param().abi(),
            ::std::mem::transmute(idobject),
            ::std::mem::transmute(idchild),
            psink.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IProxyProviderWinEventHandler {
    type Vtable = IProxyProviderWinEventHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2304322260,
        62688,
        17365,
        [163, 182, 186, 215, 225, 17, 180, 53],
    );
}
impl ::std::convert::From<IProxyProviderWinEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: IProxyProviderWinEventHandler) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IProxyProviderWinEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: &IProxyProviderWinEventHandler) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IProxyProviderWinEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IProxyProviderWinEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IProxyProviderWinEventHandler_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        idwinevent: u32,
        hwnd: super::super::Foundation::HWND,
        idobject: i32,
        idchild: i32,
        psink: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IProxyProviderWinEventSink(::windows::runtime::IUnknown);
impl IProxyProviderWinEventSink {
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn AddAutomationPropertyChangedEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        pprovider: Param0,
        id: i32,
        newvalue: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pprovider.into_param().abi(),
            ::std::mem::transmute(id),
            newvalue.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddAutomationEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        pprovider: Param0,
        id: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pprovider.into_param().abi(),
            ::std::mem::transmute(id),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AddStructureChangedEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        pprovider: Param0,
        structurechangetype: StructureChangeType,
        runtimeid: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            pprovider.into_param().abi(),
            ::std::mem::transmute(structurechangetype),
            ::std::mem::transmute(runtimeid),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IProxyProviderWinEventSink {
    type Vtable = IProxyProviderWinEventSink_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1339566968,
        42046,
        18092,
        [152, 3, 10, 105, 105, 199, 193, 131],
    );
}
impl ::std::convert::From<IProxyProviderWinEventSink> for ::windows::runtime::IUnknown {
    fn from(value: IProxyProviderWinEventSink) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IProxyProviderWinEventSink> for ::windows::runtime::IUnknown {
    fn from(value: &IProxyProviderWinEventSink) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IProxyProviderWinEventSink
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IProxyProviderWinEventSink
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IProxyProviderWinEventSink_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprovider: ::windows::runtime::RawPtr,
        id: i32,
        newvalue: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprovider: ::windows::runtime::RawPtr,
        id: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprovider: ::windows::runtime::RawPtr,
        structurechangetype: StructureChangeType,
        runtimeid: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRangeValueProvider(::windows::runtime::IUnknown);
impl IRangeValueProvider {
    pub unsafe fn SetValue(&self, val: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(val),
        )
        .ok()
    }
    pub unsafe fn Value(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsReadOnly(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Maximum(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn Minimum(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn LargeChange(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn SmallChange(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRangeValueProvider {
    type Vtable = IRangeValueProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        920419055,
        13286,
        18065,
        [175, 225, 43, 231, 39, 75, 61, 51],
    );
}
impl ::std::convert::From<IRangeValueProvider> for ::windows::runtime::IUnknown {
    fn from(value: IRangeValueProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRangeValueProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IRangeValueProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IRangeValueProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IRangeValueProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRangeValueProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        val: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderAdviseEvents(::windows::runtime::IUnknown);
impl IRawElementProviderAdviseEvents {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AdviseEventAdded(
        &self,
        eventid: i32,
        propertyids: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            ::std::mem::transmute(propertyids),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AdviseEventRemoved(
        &self,
        eventid: i32,
        propertyids: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            ::std::mem::transmute(propertyids),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderAdviseEvents {
    type Vtable = IRawElementProviderAdviseEvents_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2751967867,
        3949,
        17447,
        [146, 146, 71, 60, 123, 249, 50, 88],
    );
}
impl ::std::convert::From<IRawElementProviderAdviseEvents> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderAdviseEvents) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderAdviseEvents> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderAdviseEvents) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderAdviseEvents
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderAdviseEvents
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderAdviseEvents_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        propertyids: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        propertyids: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderFragment(::windows::runtime::IUnknown);
impl IRawElementProviderFragment {
    pub unsafe fn Navigate(
        &self,
        direction: NavigateDirection,
    ) -> ::windows::runtime::Result<IRawElementProviderFragment> {
        let mut result__: <IRawElementProviderFragment as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(direction),
            &mut result__,
        )
        .from_abi::<IRawElementProviderFragment>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRuntimeId(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn BoundingRectangle(&self) -> ::windows::runtime::Result<UiaRect> {
        let mut result__: <UiaRect as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<UiaRect>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetEmbeddedFragmentRoots(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn SetFocus(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn FragmentRoot(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderFragmentRoot> {
        let mut result__: <IRawElementProviderFragmentRoot as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderFragmentRoot>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderFragment {
    type Vtable = IRawElementProviderFragment_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4144381352,
        33625,
        17308,
        [146, 151, 187, 197, 41, 154, 125, 135],
    );
}
impl ::std::convert::From<IRawElementProviderFragment> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderFragment) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderFragment> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderFragment) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderFragment
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderFragment
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderFragment_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        direction: NavigateDirection,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut UiaRect,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderFragmentRoot(::windows::runtime::IUnknown);
impl IRawElementProviderFragmentRoot {
    pub unsafe fn ElementProviderFromPoint(
        &self,
        x: f64,
        y: f64,
    ) -> ::windows::runtime::Result<IRawElementProviderFragment> {
        let mut result__: <IRawElementProviderFragment as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
            &mut result__,
        )
        .from_abi::<IRawElementProviderFragment>(result__)
    }
    pub unsafe fn GetFocus(&self) -> ::windows::runtime::Result<IRawElementProviderFragment> {
        let mut result__: <IRawElementProviderFragment as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderFragment>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderFragmentRoot {
    type Vtable = IRawElementProviderFragmentRoot_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1645011621,
        43919,
        16553,
        [134, 203, 222, 60, 117, 89, 155, 88],
    );
}
impl ::std::convert::From<IRawElementProviderFragmentRoot> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderFragmentRoot) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderFragmentRoot> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderFragmentRoot) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderFragmentRoot
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderFragmentRoot
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderFragmentRoot_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        x: f64,
        y: f64,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderHostingAccessibles(::windows::runtime::IUnknown);
impl IRawElementProviderHostingAccessibles {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetEmbeddedAccessibles(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderHostingAccessibles {
    type Vtable = IRawElementProviderHostingAccessibles_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        616434439,
        54141,
        18554,
        [152, 207, 161, 62, 212, 101, 233, 179],
    );
}
impl ::std::convert::From<IRawElementProviderHostingAccessibles> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderHostingAccessibles) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderHostingAccessibles> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderHostingAccessibles) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderHostingAccessibles
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderHostingAccessibles
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderHostingAccessibles_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderHwndOverride(::windows::runtime::IUnknown);
impl IRawElementProviderHwndOverride {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOverrideProviderForHwnd<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderHwndOverride {
    type Vtable = IRawElementProviderHwndOverride_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        492696188,
        35143,
        17445,
        [184, 217, 121, 120, 123, 180, 96, 184],
    );
}
impl ::std::convert::From<IRawElementProviderHwndOverride> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderHwndOverride) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderHwndOverride> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderHwndOverride) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderHwndOverride
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderHwndOverride
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderHwndOverride_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderSimple(::windows::runtime::IUnknown);
impl IRawElementProviderSimple {
    pub unsafe fn ProviderOptions(&self) -> ::windows::runtime::Result<ProviderOptions> {
        let mut result__: <ProviderOptions as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ProviderOptions>(result__)
    }
    pub unsafe fn GetPatternProvider(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    pub unsafe fn HostRawElementProvider(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderSimple {
    type Vtable = IRawElementProviderSimple_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3604834513,
        34557,
        17202,
        [134, 102, 154, 190, 222, 162, 210, 76],
    );
}
impl ::std::convert::From<IRawElementProviderSimple> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderSimple) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderSimple> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderSimple) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderSimple
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderSimple
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderSimple_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ProviderOptions,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderSimple2(::windows::runtime::IUnknown);
impl IRawElementProviderSimple2 {
    pub unsafe fn ProviderOptions(&self) -> ::windows::runtime::Result<ProviderOptions> {
        let mut result__: <ProviderOptions as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ProviderOptions>(result__)
    }
    pub unsafe fn GetPatternProvider(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    pub unsafe fn HostRawElementProvider(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    pub unsafe fn ShowContextMenu(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderSimple2 {
    type Vtable = IRawElementProviderSimple2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2695379369,
        36257,
        19074,
        [128, 106, 142, 13, 68, 231, 159, 86],
    );
}
impl ::std::convert::From<IRawElementProviderSimple2> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderSimple2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderSimple2> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderSimple2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderSimple2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderSimple2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IRawElementProviderSimple2> for IRawElementProviderSimple {
    fn from(value: IRawElementProviderSimple2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderSimple2> for IRawElementProviderSimple {
    fn from(value: &IRawElementProviderSimple2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>
    for IRawElementProviderSimple2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IRawElementProviderSimple> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IRawElementProviderSimple>::into(
            self,
        ))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>
    for &IRawElementProviderSimple2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IRawElementProviderSimple> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IRawElementProviderSimple>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderSimple2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ProviderOptions,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderSimple3(::windows::runtime::IUnknown);
impl IRawElementProviderSimple3 {
    pub unsafe fn ProviderOptions(&self) -> ::windows::runtime::Result<ProviderOptions> {
        let mut result__: <ProviderOptions as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ProviderOptions>(result__)
    }
    pub unsafe fn GetPatternProvider(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    pub unsafe fn HostRawElementProvider(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    pub unsafe fn ShowContextMenu(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetMetadataValue(
        &self,
        targetid: i32,
        metadataid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(targetid),
            ::std::mem::transmute(metadataid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderSimple3 {
    type Vtable = IRawElementProviderSimple3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4243970080,
        55276,
        17939,
        [189, 246, 66, 168, 76, 231, 218, 175],
    );
}
impl ::std::convert::From<IRawElementProviderSimple3> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderSimple3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderSimple3> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderSimple3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderSimple3
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderSimple3
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IRawElementProviderSimple3> for IRawElementProviderSimple2 {
    fn from(value: IRawElementProviderSimple3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderSimple3> for IRawElementProviderSimple2 {
    fn from(value: &IRawElementProviderSimple3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IRawElementProviderSimple2>
    for IRawElementProviderSimple3
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IRawElementProviderSimple2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IRawElementProviderSimple2>::into(
            self,
        ))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IRawElementProviderSimple2>
    for &IRawElementProviderSimple3
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IRawElementProviderSimple2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IRawElementProviderSimple2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IRawElementProviderSimple3> for IRawElementProviderSimple {
    fn from(value: IRawElementProviderSimple3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderSimple3> for IRawElementProviderSimple {
    fn from(value: &IRawElementProviderSimple3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>
    for IRawElementProviderSimple3
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IRawElementProviderSimple> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IRawElementProviderSimple>::into(
            self,
        ))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>
    for &IRawElementProviderSimple3
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IRawElementProviderSimple> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IRawElementProviderSimple>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderSimple3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ProviderOptions,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        targetid: i32,
        metadataid: i32,
        returnval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IRawElementProviderWindowlessSite(::windows::runtime::IUnknown);
impl IRawElementProviderWindowlessSite {
    pub unsafe fn GetAdjacentFragment(
        &self,
        direction: NavigateDirection,
    ) -> ::windows::runtime::Result<IRawElementProviderFragment> {
        let mut result__: <IRawElementProviderFragment as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(direction),
            &mut result__,
        )
        .from_abi::<IRawElementProviderFragment>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRuntimeIdPrefix(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IRawElementProviderWindowlessSite {
    type Vtable = IRawElementProviderWindowlessSite_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        170562508,
        49069,
        17068,
        [155, 46, 9, 145, 251, 13, 62, 160],
    );
}
impl ::std::convert::From<IRawElementProviderWindowlessSite> for ::windows::runtime::IUnknown {
    fn from(value: IRawElementProviderWindowlessSite) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IRawElementProviderWindowlessSite> for ::windows::runtime::IUnknown {
    fn from(value: &IRawElementProviderWindowlessSite) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IRawElementProviderWindowlessSite
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IRawElementProviderWindowlessSite
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IRawElementProviderWindowlessSite_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        direction: NavigateDirection,
        ppparent: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IScrollItemProvider(::windows::runtime::IUnknown);
impl IScrollItemProvider {
    pub unsafe fn ScrollIntoView(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IScrollItemProvider {
    type Vtable = IScrollItemProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        593544980,
        19441,
        19238,
        [186, 101, 155, 33, 49, 97, 39, 235],
    );
}
impl ::std::convert::From<IScrollItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: IScrollItemProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IScrollItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IScrollItemProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IScrollItemProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IScrollItemProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IScrollItemProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IScrollProvider(::windows::runtime::IUnknown);
impl IScrollProvider {
    pub unsafe fn Scroll(
        &self,
        horizontalamount: ScrollAmount,
        verticalamount: ScrollAmount,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(horizontalamount),
            ::std::mem::transmute(verticalamount),
        )
        .ok()
    }
    pub unsafe fn SetScrollPercent(
        &self,
        horizontalpercent: f64,
        verticalpercent: f64,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(horizontalpercent),
            ::std::mem::transmute(verticalpercent),
        )
        .ok()
    }
    pub unsafe fn HorizontalScrollPercent(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn VerticalScrollPercent(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn HorizontalViewSize(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn VerticalViewSize(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn HorizontallyScrollable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn VerticallyScrollable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IScrollProvider {
    type Vtable = IScrollProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3012264055,
        8131,
        17061,
        [140, 174, 212, 12, 34, 21, 5, 90],
    );
}
impl ::std::convert::From<IScrollProvider> for ::windows::runtime::IUnknown {
    fn from(value: IScrollProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IScrollProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IScrollProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IScrollProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IScrollProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IScrollProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        horizontalamount: ScrollAmount,
        verticalamount: ScrollAmount,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        horizontalpercent: f64,
        verticalpercent: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISelectionItemProvider(::windows::runtime::IUnknown);
impl ISelectionItemProvider {
    pub unsafe fn Select(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AddToSelection(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn RemoveFromSelection(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSelected(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn SelectionContainer(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISelectionItemProvider {
    type Vtable = ISelectionItemProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        717936648,
        45780,
        17709,
        [164, 7, 145, 255, 26, 209, 103, 178],
    );
}
impl ::std::convert::From<ISelectionItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: ISelectionItemProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISelectionItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ISelectionItemProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ISelectionItemProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ISelectionItemProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISelectionItemProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISelectionProvider(::windows::runtime::IUnknown);
impl ISelectionProvider {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetSelection(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanSelectMultiple(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSelectionRequired(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISelectionProvider {
    type Vtable = ISelectionProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4220191663,
        15327,
        18644,
        [189, 54, 26, 101, 121, 59, 225, 104],
    );
}
impl ::std::convert::From<ISelectionProvider> for ::windows::runtime::IUnknown {
    fn from(value: ISelectionProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISelectionProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ISelectionProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISelectionProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISelectionProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISelectionProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISelectionProvider2(::windows::runtime::IUnknown);
impl ISelectionProvider2 {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetSelection(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanSelectMultiple(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn IsSelectionRequired(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn FirstSelectedItem(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    pub unsafe fn LastSelectedItem(&self) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    pub unsafe fn CurrentSelectedItem(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    pub unsafe fn ItemCount(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISelectionProvider2 {
    type Vtable = ISelectionProvider2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        351700085,
        60956,
        17654,
        [168, 105, 210, 57, 56, 31, 15, 231],
    );
}
impl ::std::convert::From<ISelectionProvider2> for ::windows::runtime::IUnknown {
    fn from(value: ISelectionProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISelectionProvider2> for ::windows::runtime::IUnknown {
    fn from(value: &ISelectionProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISelectionProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISelectionProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ISelectionProvider2> for ISelectionProvider {
    fn from(value: ISelectionProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISelectionProvider2> for ISelectionProvider {
    fn from(value: &ISelectionProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISelectionProvider> for ISelectionProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISelectionProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ISelectionProvider>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ISelectionProvider> for &ISelectionProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ISelectionProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ISelectionProvider>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISelectionProvider2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpreadsheetItemProvider(::windows::runtime::IUnknown);
impl ISpreadsheetItemProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Formula(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetAnnotationObjects(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetAnnotationTypes(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpreadsheetItemProvider {
    type Vtable = ISpreadsheetItemProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3941418592,
        31549,
        18553,
        [162, 230, 54, 92, 230, 3, 243, 208],
    );
}
impl ::std::convert::From<ISpreadsheetItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: ISpreadsheetItemProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpreadsheetItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ISpreadsheetItemProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ISpreadsheetItemProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ISpreadsheetItemProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpreadsheetItemProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISpreadsheetProvider(::windows::runtime::IUnknown);
impl ISpreadsheetProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetItemByName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        name: Param0,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            name.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ISpreadsheetProvider {
    type Vtable = ISpreadsheetProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1869307189,
        21797,
        20352,
        [183, 88, 133, 71, 56, 50, 255, 199],
    );
}
impl ::std::convert::From<ISpreadsheetProvider> for ::windows::runtime::IUnknown {
    fn from(value: ISpreadsheetProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISpreadsheetProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ISpreadsheetProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ISpreadsheetProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ISpreadsheetProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISpreadsheetProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        name: super::super::Foundation::PWSTR,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IStylesProvider(::windows::runtime::IUnknown);
impl IStylesProvider {
    pub unsafe fn StyleId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn StyleName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn FillColor(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FillPatternStyle(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Shape(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn FillPatternColor(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ExtendedProperties(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IStylesProvider {
    type Vtable = IStylesProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        431404617,
        62935,
        19053,
        [189, 203, 18, 146, 82, 190, 88, 138],
    );
}
impl ::std::convert::From<IStylesProvider> for ::windows::runtime::IUnknown {
    fn from(value: IStylesProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IStylesProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IStylesProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IStylesProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IStylesProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IStylesProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ISynchronizedInputProvider(::windows::runtime::IUnknown);
impl ISynchronizedInputProvider {
    pub unsafe fn StartListening(
        &self,
        inputtype: SynchronizedInputType,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(inputtype),
        )
        .ok()
    }
    pub unsafe fn Cancel(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ISynchronizedInputProvider {
    type Vtable = ISynchronizedInputProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        702224902,
        718,
        19703,
        [155, 66, 86, 93, 79, 171, 32, 238],
    );
}
impl ::std::convert::From<ISynchronizedInputProvider> for ::windows::runtime::IUnknown {
    fn from(value: ISynchronizedInputProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ISynchronizedInputProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ISynchronizedInputProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for ISynchronizedInputProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &ISynchronizedInputProvider
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ISynchronizedInputProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        inputtype: SynchronizedInputType,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITableItemProvider(::windows::runtime::IUnknown);
impl ITableItemProvider {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRowHeaderItems(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetColumnHeaderItems(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ITableItemProvider {
    type Vtable = ITableItemProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3111341990,
        30495,
        19832,
        [156, 144, 37, 23, 153, 147, 73, 205],
    );
}
impl ::std::convert::From<ITableItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: ITableItemProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITableItemProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ITableItemProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITableItemProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITableItemProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITableItemProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITableProvider(::windows::runtime::IUnknown);
impl ITableProvider {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRowHeaders(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetColumnHeaders(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn RowOrColumnMajor(&self) -> ::windows::runtime::Result<RowOrColumnMajor> {
        let mut result__: <RowOrColumnMajor as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<RowOrColumnMajor>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ITableProvider {
    type Vtable = ITableProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2626028437,
        38835,
        18698,
        [181, 42, 133, 140, 194, 42, 241, 102],
    );
}
impl ::std::convert::From<ITableProvider> for ::windows::runtime::IUnknown {
    fn from(value: ITableProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITableProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ITableProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITableProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITableProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITableProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut RowOrColumnMajor,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITextChildProvider(::windows::runtime::IUnknown);
impl ITextChildProvider {
    pub unsafe fn TextContainer(&self) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    pub unsafe fn TextRange(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ITextChildProvider {
    type Vtable = ITextChildProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1278075577,
        51343,
        20360,
        [161, 17, 241, 211, 54, 183, 209, 169],
    );
}
impl ::std::convert::From<ITextChildProvider> for ::windows::runtime::IUnknown {
    fn from(value: ITextChildProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextChildProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ITextChildProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITextChildProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITextChildProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITextChildProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITextEditProvider(::windows::runtime::IUnknown);
impl ITextEditProvider {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetSelection(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetVisibleRanges(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn RangeFromChild<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        childelement: Param0,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            childelement.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn RangeFromPoint<'a, Param0: ::windows::runtime::IntoParam<'a, UiaPoint>>(
        &self,
        point: Param0,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            point.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn DocumentRange(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn SupportedTextSelection(
        &self,
    ) -> ::windows::runtime::Result<SupportedTextSelection> {
        let mut result__: <SupportedTextSelection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<SupportedTextSelection>(result__)
    }
    pub unsafe fn GetActiveComposition(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn GetConversionTarget(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ITextEditProvider {
    type Vtable = ITextEditProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3929408948,
        14853,
        16398,
        [181, 249, 78, 145, 180, 15, 97, 118],
    );
}
impl ::std::convert::From<ITextEditProvider> for ::windows::runtime::IUnknown {
    fn from(value: ITextEditProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextEditProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ITextEditProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITextEditProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITextEditProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ITextEditProvider> for ITextProvider {
    fn from(value: ITextEditProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextEditProvider> for ITextProvider {
    fn from(value: &ITextEditProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITextProvider> for ITextEditProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITextProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITextProvider>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITextProvider> for &ITextEditProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITextProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITextProvider>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITextEditProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        childelement: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point: UiaPoint,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut SupportedTextSelection,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITextProvider(::windows::runtime::IUnknown);
impl ITextProvider {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetSelection(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetVisibleRanges(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn RangeFromChild<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        childelement: Param0,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            childelement.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn RangeFromPoint<'a, Param0: ::windows::runtime::IntoParam<'a, UiaPoint>>(
        &self,
        point: Param0,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            point.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn DocumentRange(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn SupportedTextSelection(
        &self,
    ) -> ::windows::runtime::Result<SupportedTextSelection> {
        let mut result__: <SupportedTextSelection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<SupportedTextSelection>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ITextProvider {
    type Vtable = ITextProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        898222380,
        25587,
        17255,
        [153, 187, 173, 166, 83, 183, 124, 242],
    );
}
impl ::std::convert::From<ITextProvider> for ::windows::runtime::IUnknown {
    fn from(value: ITextProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ITextProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITextProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITextProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITextProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        childelement: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point: UiaPoint,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut SupportedTextSelection,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITextProvider2(::windows::runtime::IUnknown);
impl ITextProvider2 {
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetSelection(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetVisibleRanges(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn RangeFromChild<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        childelement: Param0,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            childelement.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn RangeFromPoint<'a, Param0: ::windows::runtime::IntoParam<'a, UiaPoint>>(
        &self,
        point: Param0,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            point.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn DocumentRange(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    pub unsafe fn SupportedTextSelection(
        &self,
    ) -> ::windows::runtime::Result<SupportedTextSelection> {
        let mut result__: <SupportedTextSelection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<SupportedTextSelection>(result__)
    }
    pub unsafe fn RangeFromAnnotation<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IRawElementProviderSimple>,
    >(
        &self,
        annotationelement: Param0,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            annotationelement.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetCaretRange(
        &self,
        isactive: *mut super::super::Foundation::BOOL,
        pretval: *mut ::std::option::Option<ITextRangeProvider>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(isactive),
            ::std::mem::transmute(pretval),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ITextProvider2 {
    type Vtable = ITextProvider2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        231073517,
        15894,
        19441,
        [143, 154, 169, 121, 135, 139, 193, 149],
    );
}
impl ::std::convert::From<ITextProvider2> for ::windows::runtime::IUnknown {
    fn from(value: ITextProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextProvider2> for ::windows::runtime::IUnknown {
    fn from(value: &ITextProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITextProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITextProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ITextProvider2> for ITextProvider {
    fn from(value: ITextProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextProvider2> for ITextProvider {
    fn from(value: &ITextProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITextProvider> for ITextProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITextProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITextProvider>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITextProvider> for &ITextProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITextProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITextProvider>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITextProvider2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        childelement: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        point: UiaPoint,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut SupportedTextSelection,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        annotationelement: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        isactive: *mut super::super::Foundation::BOOL,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITextRangeProvider(::windows::runtime::IUnknown);
impl ITextRangeProvider {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Compare<'a, Param0: ::windows::runtime::IntoParam<'a, ITextRangeProvider>>(
        &self,
        range: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            range.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CompareEndpoints<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ITextRangeProvider>,
    >(
        &self,
        endpoint: TextPatternRangeEndpoint,
        targetrange: Param1,
        targetendpoint: TextPatternRangeEndpoint,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(endpoint),
            targetrange.into_param().abi(),
            ::std::mem::transmute(targetendpoint),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn ExpandToEnclosingUnit(&self, unit: TextUnit) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unit),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn FindAttribute<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        attributeid: i32,
        val: Param1,
        backward: Param2,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(attributeid),
            val.into_param().abi(),
            backward.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindText<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        text: Param0,
        backward: Param1,
        ignorecase: Param2,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            backward.into_param().abi(),
            ignorecase.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetAttributeValue(
        &self,
        attributeid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(attributeid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetBoundingRectangles(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn GetEnclosingElement(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetText(
        &self,
        maxlength: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maxlength),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Move(&self, unit: TextUnit, count: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unit),
            ::std::mem::transmute(count),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn MoveEndpointByUnit(
        &self,
        endpoint: TextPatternRangeEndpoint,
        unit: TextUnit,
        count: i32,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(endpoint),
            ::std::mem::transmute(unit),
            ::std::mem::transmute(count),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn MoveEndpointByRange<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ITextRangeProvider>,
    >(
        &self,
        endpoint: TextPatternRangeEndpoint,
        targetrange: Param1,
        targetendpoint: TextPatternRangeEndpoint,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(endpoint),
            targetrange.into_param().abi(),
            ::std::mem::transmute(targetendpoint),
        )
        .ok()
    }
    pub unsafe fn Select(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AddToSelection(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn RemoveFromSelection(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ScrollIntoView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        aligntotop: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            aligntotop.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetChildren(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ITextRangeProvider {
    type Vtable = ITextRangeProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1397206395,
        50005,
        18168,
        [175, 245, 144, 144, 51, 88, 47, 99],
    );
}
impl ::std::convert::From<ITextRangeProvider> for ::windows::runtime::IUnknown {
    fn from(value: ITextRangeProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextRangeProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ITextRangeProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITextRangeProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITextRangeProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITextRangeProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        range: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        endpoint: TextPatternRangeEndpoint,
        targetrange: ::windows::runtime::RawPtr,
        targetendpoint: TextPatternRangeEndpoint,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unit: TextUnit,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        attributeid: i32,
        val: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        backward: super::super::Foundation::BOOL,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        backward: super::super::Foundation::BOOL,
        ignorecase: super::super::Foundation::BOOL,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        attributeid: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        maxlength: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unit: TextUnit,
        count: i32,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        endpoint: TextPatternRangeEndpoint,
        unit: TextUnit,
        count: i32,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        endpoint: TextPatternRangeEndpoint,
        targetrange: ::windows::runtime::RawPtr,
        targetendpoint: TextPatternRangeEndpoint,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        aligntotop: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITextRangeProvider2(::windows::runtime::IUnknown);
impl ITextRangeProvider2 {
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Compare<'a, Param0: ::windows::runtime::IntoParam<'a, ITextRangeProvider>>(
        &self,
        range: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            range.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CompareEndpoints<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ITextRangeProvider>,
    >(
        &self,
        endpoint: TextPatternRangeEndpoint,
        targetrange: Param1,
        targetendpoint: TextPatternRangeEndpoint,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(endpoint),
            targetrange.into_param().abi(),
            ::std::mem::transmute(targetendpoint),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn ExpandToEnclosingUnit(&self, unit: TextUnit) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unit),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn FindAttribute<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        attributeid: i32,
        val: Param1,
        backward: Param2,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(attributeid),
            val.into_param().abi(),
            backward.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FindText<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        text: Param0,
        backward: Param1,
        ignorecase: Param2,
    ) -> ::windows::runtime::Result<ITextRangeProvider> {
        let mut result__: <ITextRangeProvider as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            text.into_param().abi(),
            backward.into_param().abi(),
            ignorecase.into_param().abi(),
            &mut result__,
        )
        .from_abi::<ITextRangeProvider>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetAttributeValue(
        &self,
        attributeid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(attributeid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetBoundingRectangles(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn GetEnclosingElement(
        &self,
    ) -> ::windows::runtime::Result<IRawElementProviderSimple> {
        let mut result__: <IRawElementProviderSimple as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IRawElementProviderSimple>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetText(
        &self,
        maxlength: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(maxlength),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Move(&self, unit: TextUnit, count: i32) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(unit),
            ::std::mem::transmute(count),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn MoveEndpointByUnit(
        &self,
        endpoint: TextPatternRangeEndpoint,
        unit: TextUnit,
        count: i32,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(endpoint),
            ::std::mem::transmute(unit),
            ::std::mem::transmute(count),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn MoveEndpointByRange<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ITextRangeProvider>,
    >(
        &self,
        endpoint: TextPatternRangeEndpoint,
        targetrange: Param1,
        targetendpoint: TextPatternRangeEndpoint,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(endpoint),
            targetrange.into_param().abi(),
            ::std::mem::transmute(targetendpoint),
        )
        .ok()
    }
    pub unsafe fn Select(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AddToSelection(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn RemoveFromSelection(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ScrollIntoView<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        aligntotop: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            aligntotop.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetChildren(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn ShowContextMenu(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).21)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for ITextRangeProvider2 {
    type Vtable = ITextRangeProvider2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2612847660,
        6433,
        20248,
        [137, 202, 219, 161, 145, 10, 3, 134],
    );
}
impl ::std::convert::From<ITextRangeProvider2> for ::windows::runtime::IUnknown {
    fn from(value: ITextRangeProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextRangeProvider2> for ::windows::runtime::IUnknown {
    fn from(value: &ITextRangeProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITextRangeProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITextRangeProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ITextRangeProvider2> for ITextRangeProvider {
    fn from(value: ITextRangeProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITextRangeProvider2> for ITextRangeProvider {
    fn from(value: &ITextRangeProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITextRangeProvider> for ITextRangeProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITextRangeProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITextRangeProvider>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITextRangeProvider> for &ITextRangeProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITextRangeProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITextRangeProvider>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITextRangeProvider2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        range: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        endpoint: TextPatternRangeEndpoint,
        targetrange: ::windows::runtime::RawPtr,
        targetendpoint: TextPatternRangeEndpoint,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unit: TextUnit,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        attributeid: i32,
        val: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        backward: super::super::Foundation::BOOL,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        text: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        backward: super::super::Foundation::BOOL,
        ignorecase: super::super::Foundation::BOOL,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        attributeid: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        maxlength: i32,
        pretval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        unit: TextUnit,
        count: i32,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        endpoint: TextPatternRangeEndpoint,
        unit: TextUnit,
        count: i32,
        pretval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        endpoint: TextPatternRangeEndpoint,
        targetrange: ::windows::runtime::RawPtr,
        targetendpoint: TextPatternRangeEndpoint,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        aligntotop: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IToggleProvider(::windows::runtime::IUnknown);
impl IToggleProvider {
    pub unsafe fn Toggle(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ToggleState(&self) -> ::windows::runtime::Result<ToggleState> {
        let mut result__: <ToggleState as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ToggleState>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IToggleProvider {
    type Vtable = IToggleProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1456475088,
        50420,
        17212,
        [168, 54, 26, 82, 165, 126, 8, 146],
    );
}
impl ::std::convert::From<IToggleProvider> for ::windows::runtime::IUnknown {
    fn from(value: IToggleProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IToggleProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IToggleProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IToggleProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IToggleProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IToggleProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut ToggleState,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITransformProvider(::windows::runtime::IUnknown);
impl ITransformProvider {
    pub unsafe fn Move(&self, x: f64, y: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
        )
        .ok()
    }
    pub unsafe fn Resize(&self, width: f64, height: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(width),
            ::std::mem::transmute(height),
        )
        .ok()
    }
    pub unsafe fn Rotate(&self, degrees: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(degrees),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanMove(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanResize(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanRotate(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for ITransformProvider {
    type Vtable = ITransformProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1747574212,
        20369,
        20474,
        [184, 111, 189, 62, 41, 135, 203, 76],
    );
}
impl ::std::convert::From<ITransformProvider> for ::windows::runtime::IUnknown {
    fn from(value: ITransformProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITransformProvider> for ::windows::runtime::IUnknown {
    fn from(value: &ITransformProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITransformProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITransformProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITransformProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        x: f64,
        y: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        width: f64,
        height: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        degrees: f64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct ITransformProvider2(::windows::runtime::IUnknown);
impl ITransformProvider2 {
    pub unsafe fn Move(&self, x: f64, y: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(x),
            ::std::mem::transmute(y),
        )
        .ok()
    }
    pub unsafe fn Resize(&self, width: f64, height: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(width),
            ::std::mem::transmute(height),
        )
        .ok()
    }
    pub unsafe fn Rotate(&self, degrees: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(degrees),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanMove(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanResize(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanRotate(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Zoom(&self, zoom: f64) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(zoom),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CanZoom(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ZoomLevel(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn ZoomMinimum(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn ZoomMaximum(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn ZoomByUnit(&self, zoomunit: ZoomUnit) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(zoomunit),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for ITransformProvider2 {
    type Vtable = ITransformProvider2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1196979247,
        31426,
        17932,
        [188, 72, 9, 252, 9, 48, 138, 147],
    );
}
impl ::std::convert::From<ITransformProvider2> for ::windows::runtime::IUnknown {
    fn from(value: ITransformProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITransformProvider2> for ::windows::runtime::IUnknown {
    fn from(value: &ITransformProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for ITransformProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &ITransformProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<ITransformProvider2> for ITransformProvider {
    fn from(value: ITransformProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&ITransformProvider2> for ITransformProvider {
    fn from(value: &ITransformProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITransformProvider> for ITransformProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITransformProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITransformProvider>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ITransformProvider> for &ITransformProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ITransformProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<ITransformProvider>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct ITransformProvider2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        x: f64,
        y: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        width: f64,
        height: f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        degrees: f64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        zoom: f64,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pretval: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        zoomunit: ZoomUnit,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomation(::windows::runtime::IUnknown);
impl IUIAutomation {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CompareElements<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        el1: Param0,
        el2: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            el1.into_param().abi(),
            el2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn CompareRuntimeIds(
        &self,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(runtimeid1),
            ::std::mem::transmute(runtimeid2),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetRootElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPoint<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
    >(
        &self,
        pt: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetRootElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        hwnd: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPointBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        pt: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn CreateTreeWalker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        pcondition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pcondition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ControlViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ContentViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ControlViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ContentViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateCacheRequest(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCacheRequest> {
        let mut result__: <IUIAutomationCacheRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCacheRequest>(result__)
    }
    pub unsafe fn CreateTrueCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateFalseCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyCondition<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyConditionEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
        flags: PropertyConditionFlags,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateAndConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateOrConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateNotCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn AddAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        scope: TreeScope,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        handler: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddPropertyChangedEventHandlerNativeArray<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
            ::std::mem::transmute(propertycount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AddPropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
        )
        .ok()
    }
    pub unsafe fn RemovePropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        cacherequest: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAllEventHandlers(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntNativeArrayToSafeArray(
        &self,
        array: *const i32,
        arraycount: i32,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntSafeArrayToNativeArray(
        &self,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(intarray),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn RectToVariant<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::RECT>,
    >(
        &self,
        rc: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            rc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn VariantToRect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        var: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            var.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn SafeArrayToRectNativeArray(
        &self,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rects),
            ::std::mem::transmute(rectarray),
            ::std::mem::transmute(rectarraycount),
        )
        .ok()
    }
    pub unsafe fn CreateProxyFactoryEntry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationProxyFactory>,
    >(
        &self,
        factory: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryEntry> {
        let mut result__: <IUIAutomationProxyFactoryEntry as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            factory.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryEntry>(result__)
    }
    pub unsafe fn ProxyFactoryMapping(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryMapping> {
        let mut result__: <IUIAutomationProxyFactoryMapping as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryMapping>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyProgrammaticName(
        &self,
        property: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(property),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPatternProgrammaticName(
        &self,
        pattern: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pattern),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedPatterns<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(patternids),
            ::std::mem::transmute(patternnames),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedProperties<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(propertyids),
            ::std::mem::transmute(propertynames),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CheckNotSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        value: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ReservedNotSupportedValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ReservedMixedAttributeValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ElementFromIAccessible<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn ElementFromIAccessibleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomation {
    type Vtable = IUIAutomation_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        818668925,
        55760,
        17706,
        [171, 19, 122, 197, 172, 72, 37, 238],
    );
}
impl ::std::convert::From<IUIAutomation> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomation) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomation) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IUIAutomation {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomation_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        el1: ::windows::runtime::RawPtr,
        el2: ::windows::runtime::RawPtr,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcondition: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        flags: PropertyConditionFlags,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        array: *const i32,
        arraycount: i32,
        safearray: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rc: super::super::Foundation::RECT,
        var: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        rc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: ::windows::runtime::RawPtr,
        factoryentry: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factorymapping: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        property: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pattern: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        isnotsupported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        notsupportedvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mixedattributevalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomation2(::windows::runtime::IUnknown);
impl IUIAutomation2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CompareElements<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        el1: Param0,
        el2: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            el1.into_param().abi(),
            el2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn CompareRuntimeIds(
        &self,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(runtimeid1),
            ::std::mem::transmute(runtimeid2),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetRootElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPoint<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
    >(
        &self,
        pt: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetRootElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        hwnd: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPointBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        pt: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn CreateTreeWalker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        pcondition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pcondition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ControlViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ContentViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ControlViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ContentViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateCacheRequest(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCacheRequest> {
        let mut result__: <IUIAutomationCacheRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCacheRequest>(result__)
    }
    pub unsafe fn CreateTrueCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateFalseCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyCondition<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyConditionEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
        flags: PropertyConditionFlags,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateAndConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateOrConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateNotCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn AddAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        scope: TreeScope,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        handler: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddPropertyChangedEventHandlerNativeArray<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
            ::std::mem::transmute(propertycount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AddPropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
        )
        .ok()
    }
    pub unsafe fn RemovePropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        cacherequest: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAllEventHandlers(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntNativeArrayToSafeArray(
        &self,
        array: *const i32,
        arraycount: i32,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntSafeArrayToNativeArray(
        &self,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(intarray),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn RectToVariant<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::RECT>,
    >(
        &self,
        rc: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            rc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn VariantToRect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        var: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            var.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn SafeArrayToRectNativeArray(
        &self,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rects),
            ::std::mem::transmute(rectarray),
            ::std::mem::transmute(rectarraycount),
        )
        .ok()
    }
    pub unsafe fn CreateProxyFactoryEntry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationProxyFactory>,
    >(
        &self,
        factory: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryEntry> {
        let mut result__: <IUIAutomationProxyFactoryEntry as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            factory.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryEntry>(result__)
    }
    pub unsafe fn ProxyFactoryMapping(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryMapping> {
        let mut result__: <IUIAutomationProxyFactoryMapping as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryMapping>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyProgrammaticName(
        &self,
        property: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(property),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPatternProgrammaticName(
        &self,
        pattern: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pattern),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedPatterns<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(patternids),
            ::std::mem::transmute(patternnames),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedProperties<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(propertyids),
            ::std::mem::transmute(propertynames),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CheckNotSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        value: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ReservedNotSupportedValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ReservedMixedAttributeValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ElementFromIAccessible<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn ElementFromIAccessibleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AutoSetFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAutoSetFocus<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        autosetfocus: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            autosetfocus.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ConnectionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetConnectionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn TransactionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetTransactionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomation2 {
    type Vtable = IUIAutomation2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        879901439,
        3229,
        18896,
        [152, 150, 122, 181, 45, 248, 205, 138],
    );
}
impl ::std::convert::From<IUIAutomation2> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomation2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation2> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomation2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomation2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IUIAutomation2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomation2> for IUIAutomation {
    fn from(value: IUIAutomation2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation2> for IUIAutomation {
    fn from(value: &IUIAutomation2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for IUIAutomation2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for &IUIAutomation2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomation2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        el1: ::windows::runtime::RawPtr,
        el2: ::windows::runtime::RawPtr,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcondition: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        flags: PropertyConditionFlags,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        array: *const i32,
        arraycount: i32,
        safearray: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rc: super::super::Foundation::RECT,
        var: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        rc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: ::windows::runtime::RawPtr,
        factoryentry: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factorymapping: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        property: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pattern: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        isnotsupported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        notsupportedvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mixedattributevalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomation3(::windows::runtime::IUnknown);
impl IUIAutomation3 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CompareElements<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        el1: Param0,
        el2: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            el1.into_param().abi(),
            el2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn CompareRuntimeIds(
        &self,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(runtimeid1),
            ::std::mem::transmute(runtimeid2),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetRootElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPoint<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
    >(
        &self,
        pt: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetRootElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        hwnd: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPointBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        pt: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn CreateTreeWalker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        pcondition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pcondition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ControlViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ContentViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ControlViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ContentViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateCacheRequest(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCacheRequest> {
        let mut result__: <IUIAutomationCacheRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCacheRequest>(result__)
    }
    pub unsafe fn CreateTrueCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateFalseCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyCondition<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyConditionEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
        flags: PropertyConditionFlags,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateAndConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateOrConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateNotCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn AddAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        scope: TreeScope,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        handler: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddPropertyChangedEventHandlerNativeArray<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
            ::std::mem::transmute(propertycount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AddPropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
        )
        .ok()
    }
    pub unsafe fn RemovePropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        cacherequest: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAllEventHandlers(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntNativeArrayToSafeArray(
        &self,
        array: *const i32,
        arraycount: i32,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntSafeArrayToNativeArray(
        &self,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(intarray),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn RectToVariant<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::RECT>,
    >(
        &self,
        rc: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            rc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn VariantToRect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        var: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            var.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn SafeArrayToRectNativeArray(
        &self,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rects),
            ::std::mem::transmute(rectarray),
            ::std::mem::transmute(rectarraycount),
        )
        .ok()
    }
    pub unsafe fn CreateProxyFactoryEntry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationProxyFactory>,
    >(
        &self,
        factory: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryEntry> {
        let mut result__: <IUIAutomationProxyFactoryEntry as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            factory.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryEntry>(result__)
    }
    pub unsafe fn ProxyFactoryMapping(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryMapping> {
        let mut result__: <IUIAutomationProxyFactoryMapping as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryMapping>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyProgrammaticName(
        &self,
        property: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(property),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPatternProgrammaticName(
        &self,
        pattern: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pattern),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedPatterns<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(patternids),
            ::std::mem::transmute(patternnames),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedProperties<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(propertyids),
            ::std::mem::transmute(propertynames),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CheckNotSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        value: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ReservedNotSupportedValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ReservedMixedAttributeValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ElementFromIAccessible<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn ElementFromIAccessibleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AutoSetFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAutoSetFocus<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        autosetfocus: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            autosetfocus.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ConnectionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetConnectionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn TransactionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetTransactionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn AddTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            ::std::mem::transmute(texteditchangetype),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomation3 {
    type Vtable = IUIAutomation3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1943496922,
        39761,
        19337,
        [147, 110, 194, 9, 41, 9, 115, 231],
    );
}
impl ::std::convert::From<IUIAutomation3> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomation3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation3> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomation3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomation3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IUIAutomation3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomation3> for IUIAutomation2 {
    fn from(value: IUIAutomation3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation3> for IUIAutomation2 {
    fn from(value: &IUIAutomation3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for IUIAutomation3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for &IUIAutomation3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation3> for IUIAutomation {
    fn from(value: IUIAutomation3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation3> for IUIAutomation {
    fn from(value: &IUIAutomation3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for IUIAutomation3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for &IUIAutomation3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomation3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        el1: ::windows::runtime::RawPtr,
        el2: ::windows::runtime::RawPtr,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcondition: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        flags: PropertyConditionFlags,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        array: *const i32,
        arraycount: i32,
        safearray: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rc: super::super::Foundation::RECT,
        var: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        rc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: ::windows::runtime::RawPtr,
        factoryentry: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factorymapping: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        property: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pattern: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        isnotsupported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        notsupportedvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mixedattributevalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomation4(::windows::runtime::IUnknown);
impl IUIAutomation4 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CompareElements<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        el1: Param0,
        el2: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            el1.into_param().abi(),
            el2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn CompareRuntimeIds(
        &self,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(runtimeid1),
            ::std::mem::transmute(runtimeid2),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetRootElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPoint<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
    >(
        &self,
        pt: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetRootElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        hwnd: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPointBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        pt: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn CreateTreeWalker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        pcondition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pcondition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ControlViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ContentViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ControlViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ContentViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateCacheRequest(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCacheRequest> {
        let mut result__: <IUIAutomationCacheRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCacheRequest>(result__)
    }
    pub unsafe fn CreateTrueCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateFalseCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyCondition<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyConditionEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
        flags: PropertyConditionFlags,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateAndConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateOrConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateNotCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn AddAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        scope: TreeScope,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        handler: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddPropertyChangedEventHandlerNativeArray<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
            ::std::mem::transmute(propertycount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AddPropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
        )
        .ok()
    }
    pub unsafe fn RemovePropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        cacherequest: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAllEventHandlers(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntNativeArrayToSafeArray(
        &self,
        array: *const i32,
        arraycount: i32,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntSafeArrayToNativeArray(
        &self,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(intarray),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn RectToVariant<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::RECT>,
    >(
        &self,
        rc: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            rc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn VariantToRect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        var: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            var.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn SafeArrayToRectNativeArray(
        &self,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rects),
            ::std::mem::transmute(rectarray),
            ::std::mem::transmute(rectarraycount),
        )
        .ok()
    }
    pub unsafe fn CreateProxyFactoryEntry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationProxyFactory>,
    >(
        &self,
        factory: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryEntry> {
        let mut result__: <IUIAutomationProxyFactoryEntry as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            factory.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryEntry>(result__)
    }
    pub unsafe fn ProxyFactoryMapping(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryMapping> {
        let mut result__: <IUIAutomationProxyFactoryMapping as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryMapping>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyProgrammaticName(
        &self,
        property: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(property),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPatternProgrammaticName(
        &self,
        pattern: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pattern),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedPatterns<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(patternids),
            ::std::mem::transmute(patternnames),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedProperties<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(propertyids),
            ::std::mem::transmute(propertynames),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CheckNotSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        value: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ReservedNotSupportedValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ReservedMixedAttributeValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ElementFromIAccessible<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn ElementFromIAccessibleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AutoSetFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAutoSetFocus<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        autosetfocus: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            autosetfocus.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ConnectionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetConnectionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn TransactionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetTransactionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn AddTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            ::std::mem::transmute(texteditchangetype),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddChangesEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param5: ::windows::runtime::IntoParam<'a, IUIAutomationChangesEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        changetypes: *const i32,
        changescount: i32,
        pcacherequest: Param4,
        handler: Param5,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            ::std::mem::transmute(changetypes),
            ::std::mem::transmute(changescount),
            pcacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveChangesEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationChangesEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomation4 {
    type Vtable = IUIAutomation4_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        294240298,
        1528,
        17177,
        [142, 33, 232, 23, 227, 219, 40, 96],
    );
}
impl ::std::convert::From<IUIAutomation4> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomation4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation4> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomation4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomation4> for IUIAutomation3 {
    fn from(value: IUIAutomation4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation4> for IUIAutomation3 {
    fn from(value: &IUIAutomation4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation3> for IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation3> for &IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation4> for IUIAutomation2 {
    fn from(value: IUIAutomation4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation4> for IUIAutomation2 {
    fn from(value: &IUIAutomation4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for &IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation4> for IUIAutomation {
    fn from(value: IUIAutomation4) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation4> for IUIAutomation {
    fn from(value: &IUIAutomation4) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for &IUIAutomation4 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomation4_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        el1: ::windows::runtime::RawPtr,
        el2: ::windows::runtime::RawPtr,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcondition: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        flags: PropertyConditionFlags,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        array: *const i32,
        arraycount: i32,
        safearray: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rc: super::super::Foundation::RECT,
        var: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        rc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: ::windows::runtime::RawPtr,
        factoryentry: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factorymapping: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        property: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pattern: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        isnotsupported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        notsupportedvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mixedattributevalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        changetypes: *const i32,
        changescount: i32,
        pcacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomation5(::windows::runtime::IUnknown);
impl IUIAutomation5 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CompareElements<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        el1: Param0,
        el2: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            el1.into_param().abi(),
            el2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn CompareRuntimeIds(
        &self,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(runtimeid1),
            ::std::mem::transmute(runtimeid2),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetRootElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPoint<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
    >(
        &self,
        pt: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetRootElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        hwnd: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPointBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        pt: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn CreateTreeWalker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        pcondition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pcondition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ControlViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ContentViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ControlViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ContentViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateCacheRequest(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCacheRequest> {
        let mut result__: <IUIAutomationCacheRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCacheRequest>(result__)
    }
    pub unsafe fn CreateTrueCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateFalseCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyCondition<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyConditionEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
        flags: PropertyConditionFlags,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateAndConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateOrConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateNotCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn AddAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        scope: TreeScope,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        handler: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddPropertyChangedEventHandlerNativeArray<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
            ::std::mem::transmute(propertycount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AddPropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
        )
        .ok()
    }
    pub unsafe fn RemovePropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        cacherequest: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAllEventHandlers(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntNativeArrayToSafeArray(
        &self,
        array: *const i32,
        arraycount: i32,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntSafeArrayToNativeArray(
        &self,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(intarray),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn RectToVariant<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::RECT>,
    >(
        &self,
        rc: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            rc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn VariantToRect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        var: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            var.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn SafeArrayToRectNativeArray(
        &self,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rects),
            ::std::mem::transmute(rectarray),
            ::std::mem::transmute(rectarraycount),
        )
        .ok()
    }
    pub unsafe fn CreateProxyFactoryEntry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationProxyFactory>,
    >(
        &self,
        factory: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryEntry> {
        let mut result__: <IUIAutomationProxyFactoryEntry as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            factory.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryEntry>(result__)
    }
    pub unsafe fn ProxyFactoryMapping(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryMapping> {
        let mut result__: <IUIAutomationProxyFactoryMapping as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryMapping>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyProgrammaticName(
        &self,
        property: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(property),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPatternProgrammaticName(
        &self,
        pattern: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pattern),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedPatterns<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(patternids),
            ::std::mem::transmute(patternnames),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedProperties<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(propertyids),
            ::std::mem::transmute(propertynames),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CheckNotSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        value: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ReservedNotSupportedValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ReservedMixedAttributeValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ElementFromIAccessible<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn ElementFromIAccessibleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AutoSetFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAutoSetFocus<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        autosetfocus: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            autosetfocus.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ConnectionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetConnectionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn TransactionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetTransactionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn AddTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            ::std::mem::transmute(texteditchangetype),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddChangesEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param5: ::windows::runtime::IntoParam<'a, IUIAutomationChangesEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        changetypes: *const i32,
        changescount: i32,
        pcacherequest: Param4,
        handler: Param5,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            ::std::mem::transmute(changetypes),
            ::std::mem::transmute(changescount),
            pcacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveChangesEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationChangesEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddNotificationEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationNotificationEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveNotificationEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationNotificationEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomation5 {
    type Vtable = IUIAutomation5_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        636944584,
        55318,
        16471,
        [169, 220, 60, 189, 238, 119, 226, 86],
    );
}
impl ::std::convert::From<IUIAutomation5> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomation5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation5> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomation5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomation5> for IUIAutomation4 {
    fn from(value: IUIAutomation5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation5> for IUIAutomation4 {
    fn from(value: &IUIAutomation5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation4> for IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation4>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation4> for &IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation4>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation5> for IUIAutomation3 {
    fn from(value: IUIAutomation5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation5> for IUIAutomation3 {
    fn from(value: &IUIAutomation5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation3> for IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation3> for &IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation5> for IUIAutomation2 {
    fn from(value: IUIAutomation5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation5> for IUIAutomation2 {
    fn from(value: &IUIAutomation5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for &IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation5> for IUIAutomation {
    fn from(value: IUIAutomation5) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation5> for IUIAutomation {
    fn from(value: &IUIAutomation5) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for &IUIAutomation5 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomation5_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        el1: ::windows::runtime::RawPtr,
        el2: ::windows::runtime::RawPtr,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcondition: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        flags: PropertyConditionFlags,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        array: *const i32,
        arraycount: i32,
        safearray: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rc: super::super::Foundation::RECT,
        var: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        rc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: ::windows::runtime::RawPtr,
        factoryentry: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factorymapping: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        property: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pattern: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        isnotsupported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        notsupportedvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mixedattributevalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        changetypes: *const i32,
        changescount: i32,
        pcacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomation6(::windows::runtime::IUnknown);
impl IUIAutomation6 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CompareElements<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        el1: Param0,
        el2: Param1,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            el1.into_param().abi(),
            el2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn CompareRuntimeIds(
        &self,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(runtimeid1),
            ::std::mem::transmute(runtimeid2),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn GetRootElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandle<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPoint<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
    >(
        &self,
        pt: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElement(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetRootElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromHandleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        hwnd: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn ElementFromPointBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::POINT>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        pt: Param0,
        cacherequest: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pt.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetFocusedElementBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn CreateTreeWalker<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        pcondition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pcondition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ControlViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn ContentViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewWalker(&self) -> ::windows::runtime::Result<IUIAutomationTreeWalker> {
        let mut result__: <IUIAutomationTreeWalker as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationTreeWalker>(result__)
    }
    pub unsafe fn RawViewCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ControlViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn ContentViewCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateCacheRequest(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCacheRequest> {
        let mut result__: <IUIAutomationCacheRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCacheRequest>(result__)
    }
    pub unsafe fn CreateTrueCondition(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateFalseCondition(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyCondition<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CreatePropertyConditionEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        propertyid: i32,
        value: Param1,
        flags: PropertyConditionFlags,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            value.into_param().abi(),
            ::std::mem::transmute(flags),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateAndConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateAndConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition1: Param0,
        condition2: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            condition1.into_param().abi(),
            condition2.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CreateOrConditionFromArray(
        &self,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateOrConditionFromNativeArray(
        &self,
        conditions: *const ::std::option::Option<IUIAutomationCondition>,
        conditioncount: i32,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(conditions),
            ::std::mem::transmute(conditioncount),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn CreateNotCondition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        condition: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn AddAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        scope: TreeScope,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAutomationEventHandler<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandler>,
    >(
        &self,
        eventid: i32,
        element: Param1,
        handler: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(eventid),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddPropertyChangedEventHandlerNativeArray<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
            ::std::mem::transmute(propertycount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn AddPropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
            ::std::mem::transmute(propertyarray),
        )
        .ok()
    }
    pub unsafe fn RemovePropertyChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationPropertyChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveStructureChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationStructureChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        cacherequest: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveFocusChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationFocusChangedEventHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveAllEventHandlers(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).41)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntNativeArrayToSafeArray(
        &self,
        array: *const i32,
        arraycount: i32,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn IntSafeArrayToNativeArray(
        &self,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(intarray),
            ::std::mem::transmute(array),
            ::std::mem::transmute(arraycount),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn RectToVariant<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::RECT>,
    >(
        &self,
        rc: Param0,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            rc.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn VariantToRect<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        var: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            var.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub unsafe fn SafeArrayToRectNativeArray(
        &self,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rects),
            ::std::mem::transmute(rectarray),
            ::std::mem::transmute(rectarraycount),
        )
        .ok()
    }
    pub unsafe fn CreateProxyFactoryEntry<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationProxyFactory>,
    >(
        &self,
        factory: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryEntry> {
        let mut result__: <IUIAutomationProxyFactoryEntry as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            factory.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryEntry>(result__)
    }
    pub unsafe fn ProxyFactoryMapping(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationProxyFactoryMapping> {
        let mut result__: <IUIAutomationProxyFactoryMapping as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationProxyFactoryMapping>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyProgrammaticName(
        &self,
        property: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(property),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPatternProgrammaticName(
        &self,
        pattern: i32,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pattern),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedPatterns<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(patternids),
            ::std::mem::transmute(patternnames),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn PollForPotentialSupportedProperties<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        pelement: Param0,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            pelement.into_param().abi(),
            ::std::mem::transmute(propertyids),
            ::std::mem::transmute(propertynames),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn CheckNotSupported<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::VARIANT>,
    >(
        &self,
        value: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            value.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn ReservedNotSupportedValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ReservedMixedAttributeValue(
        &self,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn ElementFromIAccessible<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn ElementFromIAccessibleBuildCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAccessible>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        accessible: Param0,
        childid: i32,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            accessible.into_param().abi(),
            ::std::mem::transmute(childid),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn AutoSetFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetAutoSetFocus<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        autosetfocus: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            autosetfocus.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ConnectionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetConnectionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn TransactionTimeout(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetTransactionTimeout(&self, timeout: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(timeout),
        )
        .ok()
    }
    pub unsafe fn AddTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: Param3,
        handler: Param4,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            ::std::mem::transmute(texteditchangetype),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveTextEditTextChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationTextEditTextChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddChangesEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param4: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param5: ::windows::runtime::IntoParam<'a, IUIAutomationChangesEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        changetypes: *const i32,
        changescount: i32,
        pcacherequest: Param4,
        handler: Param5,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            ::std::mem::transmute(changetypes),
            ::std::mem::transmute(changescount),
            pcacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveChangesEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationChangesEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddNotificationEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationNotificationEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveNotificationEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationNotificationEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateEventHandlerGroup(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationEventHandlerGroup> {
        let mut result__: <IUIAutomationEventHandlerGroup as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationEventHandlerGroup>(result__)
    }
    pub unsafe fn AddEventHandlerGroup<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandlerGroup>,
    >(
        &self,
        element: Param0,
        handlergroup: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handlergroup.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveEventHandlerGroup<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationEventHandlerGroup>,
    >(
        &self,
        element: Param0,
        handlergroup: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handlergroup.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ConnectionRecoveryBehavior(
        &self,
    ) -> ::windows::runtime::Result<ConnectionRecoveryBehaviorOptions> {
        let mut result__: <ConnectionRecoveryBehaviorOptions as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<ConnectionRecoveryBehaviorOptions>(result__)
    }
    pub unsafe fn SetConnectionRecoveryBehavior(
        &self,
        connectionrecoverybehavioroptions: ConnectionRecoveryBehaviorOptions,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(connectionrecoverybehavioroptions),
        )
        .ok()
    }
    pub unsafe fn CoalesceEvents(&self) -> ::windows::runtime::Result<CoalesceEventsOptions> {
        let mut result__: <CoalesceEventsOptions as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<CoalesceEventsOptions>(result__)
    }
    pub unsafe fn SetCoalesceEvents(
        &self,
        coalesceeventsoptions: CoalesceEventsOptions,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).76)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(coalesceeventsoptions),
        )
        .ok()
    }
    pub unsafe fn AddActiveTextPositionChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
        Param3: ::windows::runtime::IntoParam<'a, IUIAutomationActiveTextPositionChangedEventHandler>,
    >(
        &self,
        element: Param0,
        scope: TreeScope,
        cacherequest: Param2,
        handler: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            ::std::mem::transmute(scope),
            cacherequest.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveActiveTextPositionChangedEventHandler<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationActiveTextPositionChangedEventHandler>,
    >(
        &self,
        element: Param0,
        handler: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).78)(
            ::std::mem::transmute_copy(self),
            element.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomation6 {
    type Vtable = IUIAutomation6_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2866836186,
        10723,
        16701,
        [135, 167, 25, 45, 191, 129, 237, 16],
    );
}
impl ::std::convert::From<IUIAutomation6> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomation6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation6> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomation6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomation6> for IUIAutomation5 {
    fn from(value: IUIAutomation6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation6> for IUIAutomation5 {
    fn from(value: &IUIAutomation6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation5> for IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation5> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation5>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation5> for &IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation5> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation5>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation6> for IUIAutomation4 {
    fn from(value: IUIAutomation6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation6> for IUIAutomation4 {
    fn from(value: &IUIAutomation6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation4> for IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation4>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation4> for &IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation4> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation4>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation6> for IUIAutomation3 {
    fn from(value: IUIAutomation6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation6> for IUIAutomation3 {
    fn from(value: &IUIAutomation6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation3> for IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation3>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation3> for &IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation3> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation3>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation6> for IUIAutomation2 {
    fn from(value: IUIAutomation6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation6> for IUIAutomation2 {
    fn from(value: &IUIAutomation6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation2> for &IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomation6> for IUIAutomation {
    fn from(value: IUIAutomation6) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomation6> for IUIAutomation {
    fn from(value: &IUIAutomation6) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomation> for &IUIAutomation6 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomation> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomation>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomation6_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        el1: ::windows::runtime::RawPtr,
        el2: ::windows::runtime::RawPtr,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid1: *const super::super::System::OleAutomation::SAFEARRAY,
        runtimeid2: *const super::super::System::OleAutomation::SAFEARRAY,
        aresame: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        root: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pt: super::super::Foundation::POINT,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcondition: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        walker: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        flags: PropertyConditionFlags,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition1: ::windows::runtime::RawPtr,
        condition2: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const super::super::System::OleAutomation::SAFEARRAY,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        conditions: *const ::windows::runtime::RawPtr,
        conditioncount: i32,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        condition: ::windows::runtime::RawPtr,
        newcondition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        eventid: i32,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const i32,
        propertycount: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
        propertyarray: *const super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        array: *const i32,
        arraycount: i32,
        safearray: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        intarray: *const super::super::System::OleAutomation::SAFEARRAY,
        array: *mut *mut i32,
        arraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rc: super::super::Foundation::RECT,
        var: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        var: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        rc: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rects: *const super::super::System::OleAutomation::SAFEARRAY,
        rectarray: *mut *mut super::super::Foundation::RECT,
        rectarraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_System_OleAutomation")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factory: ::windows::runtime::RawPtr,
        factoryentry: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        factorymapping: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        property: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pattern: i32,
        name: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        patternids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        patternnames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pelement: ::windows::runtime::RawPtr,
        propertyids: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
        propertynames: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        value: ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        isnotsupported: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        notsupportedvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mixedattributevalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        accessible: ::windows::runtime::RawPtr,
        childid: i32,
        cacherequest: ::windows::runtime::RawPtr,
        element: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        autosetfocus: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        timeout: u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        texteditchangetype: TextEditChangeType,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        changetypes: *const i32,
        changescount: i32,
        pcacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        handlergroup: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handlergroup: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handlergroup: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        connectionrecoverybehavioroptions: *mut ConnectionRecoveryBehaviorOptions,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        connectionrecoverybehavioroptions: ConnectionRecoveryBehaviorOptions,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        coalesceeventsoptions: *mut CoalesceEventsOptions,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        coalesceeventsoptions: CoalesceEventsOptions,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        scope: TreeScope,
        cacherequest: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        element: ::windows::runtime::RawPtr,
        handler: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationActiveTextPositionChangedEventHandler(::windows::runtime::IUnknown);
impl IUIAutomationActiveTextPositionChangedEventHandler {
    pub unsafe fn HandleActiveTextPositionChangedEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationTextRange>,
    >(
        &self,
        sender: Param0,
        range: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            sender.into_param().abi(),
            range.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationActiveTextPositionChangedEventHandler {
    type Vtable = IUIAutomationActiveTextPositionChangedEventHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4185469872,
        36270,
        17558,
        [137, 151, 91, 160, 21, 254, 13, 130],
    );
}
impl ::std::convert::From<IUIAutomationActiveTextPositionChangedEventHandler>
    for ::windows::runtime::IUnknown
{
    fn from(value: IUIAutomationActiveTextPositionChangedEventHandler) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationActiveTextPositionChangedEventHandler>
    for ::windows::runtime::IUnknown
{
    fn from(value: &IUIAutomationActiveTextPositionChangedEventHandler) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationActiveTextPositionChangedEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationActiveTextPositionChangedEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationActiveTextPositionChangedEventHandler_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        sender: ::windows::runtime::RawPtr,
        range: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationAndCondition(::windows::runtime::IUnknown);
impl IUIAutomationAndCondition {
    pub unsafe fn ChildCount(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn GetChildrenAsNativeArray(
        &self,
        childarray: *mut *mut ::std::option::Option<IUIAutomationCondition>,
        childarraycount: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(childarray),
            ::std::mem::transmute(childarraycount),
        )
        .ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetChildren(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationAndCondition {
    type Vtable = IUIAutomationAndCondition_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2815471414,
        47378,
        17918,
        [152, 85, 9, 29, 220, 23, 74, 236],
    );
}
impl ::std::convert::From<IUIAutomationAndCondition> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationAndCondition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationAndCondition> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationAndCondition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationAndCondition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationAndCondition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomationAndCondition> for IUIAutomationCondition {
    fn from(value: IUIAutomationAndCondition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationAndCondition> for IUIAutomationCondition {
    fn from(value: &IUIAutomationAndCondition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationCondition> for IUIAutomationAndCondition {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationCondition> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationCondition>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationCondition> for &IUIAutomationAndCondition {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationCondition> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationCondition>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationAndCondition_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        childcount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        childarray: *mut *mut ::windows::runtime::RawPtr,
        childarraycount: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        childarray: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationAnnotationPattern(::windows::runtime::IUnknown);
impl IUIAutomationAnnotationPattern {
    pub unsafe fn CurrentAnnotationTypeId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAnnotationTypeName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAuthor(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentDateTime(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CurrentTarget(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn CachedAnnotationTypeId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAnnotationTypeName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAuthor(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedDateTime(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CachedTarget(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationAnnotationPattern {
    type Vtable = IUIAutomationAnnotationPattern_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2585221921,
        13214,
        16817,
        [142, 139, 98, 63, 107, 104, 16, 152],
    );
}
impl ::std::convert::From<IUIAutomationAnnotationPattern> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationAnnotationPattern) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationAnnotationPattern> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationAnnotationPattern) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationAnnotationPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationAnnotationPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationAnnotationPattern_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationBoolCondition(::windows::runtime::IUnknown);
impl IUIAutomationBoolCondition {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BooleanValue(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationBoolCondition {
    type Vtable = IUIAutomationBoolCondition_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        458104622,
        30187,
        19723,
        [137, 82, 90, 105, 152, 142, 35, 7],
    );
}
impl ::std::convert::From<IUIAutomationBoolCondition> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationBoolCondition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationBoolCondition> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationBoolCondition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationBoolCondition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationBoolCondition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomationBoolCondition> for IUIAutomationCondition {
    fn from(value: IUIAutomationBoolCondition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationBoolCondition> for IUIAutomationCondition {
    fn from(value: &IUIAutomationBoolCondition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationCondition> for IUIAutomationBoolCondition {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationCondition> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationCondition>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationCondition> for &IUIAutomationBoolCondition {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationCondition> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationCondition>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationBoolCondition_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        boolval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationCacheRequest(::windows::runtime::IUnknown);
impl IUIAutomationCacheRequest {
    pub unsafe fn AddProperty(&self, propertyid: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
        )
        .ok()
    }
    pub unsafe fn AddPattern(&self, patternid: i32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
        )
        .ok()
    }
    pub unsafe fn Clone(&self) -> ::windows::runtime::Result<IUIAutomationCacheRequest> {
        let mut result__: <IUIAutomationCacheRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCacheRequest>(result__)
    }
    pub unsafe fn TreeScope(&self) -> ::windows::runtime::Result<TreeScope> {
        let mut result__: <TreeScope as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<TreeScope>(result__)
    }
    pub unsafe fn SetTreeScope(&self, scope: TreeScope) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
        )
        .ok()
    }
    pub unsafe fn TreeFilter(&self) -> ::windows::runtime::Result<IUIAutomationCondition> {
        let mut result__: <IUIAutomationCondition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationCondition>(result__)
    }
    pub unsafe fn SetTreeFilter<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        filter: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            filter.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AutomationElementMode(
        &self,
    ) -> ::windows::runtime::Result<AutomationElementMode> {
        let mut result__: <AutomationElementMode as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<AutomationElementMode>(result__)
    }
    pub unsafe fn SetAutomationElementMode(
        &self,
        mode: AutomationElementMode,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(mode),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationCacheRequest {
    type Vtable = IUIAutomationCacheRequest_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3005911733,
        48165,
        16504,
        [156, 8, 215, 238, 149, 196, 142, 3],
    );
}
impl ::std::convert::From<IUIAutomationCacheRequest> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationCacheRequest) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationCacheRequest> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationCacheRequest) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationCacheRequest
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationCacheRequest
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationCacheRequest_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        clonedrequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: *mut TreeScope,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        filter: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        filter: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mode: *mut AutomationElementMode,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        mode: AutomationElementMode,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationChangesEventHandler(::windows::runtime::IUnknown);
impl IUIAutomationChangesEventHandler {
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn HandleChangesEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationElement>,
    >(
        &self,
        sender: Param0,
        uiachanges: *const UiaChangeInfo,
        changescount: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            sender.into_param().abi(),
            ::std::mem::transmute(uiachanges),
            ::std::mem::transmute(changescount),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationChangesEventHandler {
    type Vtable = IUIAutomationChangesEventHandler_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1491978837,
        11326,
        18816,
        [177, 185, 86, 193, 127, 39, 162, 160],
    );
}
impl ::std::convert::From<IUIAutomationChangesEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationChangesEventHandler) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationChangesEventHandler> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationChangesEventHandler) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationChangesEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationChangesEventHandler
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationChangesEventHandler_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        sender: ::windows::runtime::RawPtr,
        uiachanges: *const ::std::mem::ManuallyDrop<UiaChangeInfo>,
        changescount: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationCondition(::windows::runtime::IUnknown);
impl IUIAutomationCondition {}
unsafe impl ::windows::runtime::Interface for IUIAutomationCondition {
    type Vtable = IUIAutomationCondition_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        892337064,
        2419,
        17276,
        [166, 31, 246, 76, 175, 216, 29, 249],
    );
}
impl ::std::convert::From<IUIAutomationCondition> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationCondition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationCondition> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationCondition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationCondition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationCondition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationCondition_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationCustomNavigationPattern(::windows::runtime::IUnknown);
impl IUIAutomationCustomNavigationPattern {
    pub unsafe fn Navigate(
        &self,
        direction: NavigateDirection,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(direction),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationCustomNavigationPattern {
    type Vtable = IUIAutomationCustomNavigationPattern_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        32121210,
        5990,
        18413,
        [166, 204, 172, 244, 146, 133, 75, 31],
    );
}
impl ::std::convert::From<IUIAutomationCustomNavigationPattern> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationCustomNavigationPattern) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationCustomNavigationPattern> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationCustomNavigationPattern) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationCustomNavigationPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationCustomNavigationPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationCustomNavigationPattern_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        direction: NavigateDirection,
        pretval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationDockPattern(::windows::runtime::IUnknown);
impl IUIAutomationDockPattern {
    pub unsafe fn SetDockPosition(&self, dockpos: DockPosition) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dockpos),
        )
        .ok()
    }
    pub unsafe fn CurrentDockPosition(&self) -> ::windows::runtime::Result<DockPosition> {
        let mut result__: <DockPosition as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<DockPosition>(result__)
    }
    pub unsafe fn CachedDockPosition(&self) -> ::windows::runtime::Result<DockPosition> {
        let mut result__: <DockPosition as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<DockPosition>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationDockPattern {
    type Vtable = IUIAutomationDockPattern_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4259704727,
        5220,
        18678,
        [144, 191, 67, 208, 148, 142, 134, 236],
    );
}
impl ::std::convert::From<IUIAutomationDockPattern> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationDockPattern) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationDockPattern> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationDockPattern) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationDockPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationDockPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationDockPattern_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dockpos: DockPosition,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut DockPosition,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut DockPosition,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationDragPattern(::windows::runtime::IUnknown);
impl IUIAutomationDragPattern {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsGrabbed(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsGrabbed(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentDropEffect(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedDropEffect(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CurrentDropEffects(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CachedDropEffects(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn GetCurrentGrabbedItems(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn GetCachedGrabbedItems(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationDragPattern {
    type Vtable = IUIAutomationDragPattern_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        499627376,
        8020,
        19373,
        [188, 218, 211, 106, 114, 47, 183, 189],
    );
}
impl ::std::convert::From<IUIAutomationDragPattern> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationDragPattern) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationDragPattern> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationDragPattern) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationDragPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationDragPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationDragPattern_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationDropTargetPattern(::windows::runtime::IUnknown);
impl IUIAutomationDropTargetPattern {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentDropTargetEffect(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedDropTargetEffect(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CurrentDropTargetEffects(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn CachedDropTargetEffects(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationDropTargetPattern {
    type Vtable = IUIAutomationDropTargetPattern_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1772131831,
        61156,
        17166,
        [164, 107, 251, 115, 177, 174, 57, 165],
    );
}
impl ::std::convert::From<IUIAutomationDropTargetPattern> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationDropTargetPattern) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationDropTargetPattern> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationDropTargetPattern) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IUIAutomationDropTargetPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationDropTargetPattern
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationDropTargetPattern_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationElement(::windows::runtime::IUnknown);
impl IUIAutomationElement {
    pub unsafe fn SetFocus(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRuntimeId(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn FindFirst<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn FindAll<'a, Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>>(
        &self,
        scope: TreeScope,
        condition: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn FindFirstBuildCache<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn FindAllBuildCache<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn BuildUpdatedCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCurrentPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCurrentPropertyValueEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        propertyid: i32,
        ignoredefaultvalue: Param1,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            ignoredefaultvalue.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCachedPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCachedPropertyValueEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        propertyid: i32,
        ignoredefaultvalue: Param1,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            ignoredefaultvalue.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    pub unsafe fn GetCurrentPatternAs<T: ::windows::runtime::Interface>(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetCachedPatternAs<T: ::windows::runtime::Interface>(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetCurrentPattern(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn GetCachedPattern(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn GetCachedParent(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetCachedChildren(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentProcessId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn CurrentControlType(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentLocalizedControlType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAcceleratorKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAccessKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentHasKeyboardFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsKeyboardFocusable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsEnabled(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAutomationId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentClassName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentHelpText(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CurrentCulture(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsControlElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsContentElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsPassword(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentNativeWindowHandle(
        &self,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(retval),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentItemType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsOffscreen(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentOrientation(&self) -> ::windows::runtime::Result<OrientationType> {
        let mut result__: <OrientationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<OrientationType>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentFrameworkId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsRequiredForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentItemStatus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentBoundingRectangle(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    pub unsafe fn CurrentLabeledBy(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAriaRole(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAriaProperties(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsDataValidForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentControllerFor(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentDescribedBy(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentFlowsTo(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentProviderDescription(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CachedProcessId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn CachedControlType(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedLocalizedControlType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAcceleratorKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAccessKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedHasKeyboardFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsKeyboardFocusable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsEnabled(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAutomationId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedClassName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedHelpText(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CachedCulture(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsControlElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsContentElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsPassword(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedNativeWindowHandle(
        &self,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(retval),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedItemType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsOffscreen(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CachedOrientation(&self) -> ::windows::runtime::Result<OrientationType> {
        let mut result__: <OrientationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<OrientationType>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedFrameworkId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsRequiredForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedItemStatus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedBoundingRectangle(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    pub unsafe fn CachedLabeledBy(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).76)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAriaRole(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAriaProperties(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).78)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsDataValidForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CachedControllerFor(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedDescribedBy(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedFlowsTo(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedProviderDescription(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetClickablePoint(
        &self,
        clickable: *mut super::super::Foundation::POINT,
        gotclickable: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(clickable),
            ::std::mem::transmute(gotclickable),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationElement {
    type Vtable = IUIAutomationElement_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3525380266,
        35525,
        18853,
        [131, 123, 55, 187, 179, 215, 89, 30],
    );
}
impl ::std::convert::From<IUIAutomationElement> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationElement) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationElement> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationElement) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomationElement {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IUIAutomationElement {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationElement_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        updatedelement: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        ignoredefaultvalue: super::super::Foundation::BOOL,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        ignoredefaultvalue: super::super::Foundation::BOOL,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        riid: *const ::windows::runtime::GUID,
        patternobject: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        riid: *const ::windows::runtime::GUID,
        patternobject: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        patternobject: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        patternobject: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        parent: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        children: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut OrientationType,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut OrientationType,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        clickable: *mut super::super::Foundation::POINT,
        gotclickable: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationElement2(::windows::runtime::IUnknown);
impl IUIAutomationElement2 {
    pub unsafe fn SetFocus(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRuntimeId(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn FindFirst<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn FindAll<'a, Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>>(
        &self,
        scope: TreeScope,
        condition: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn FindFirstBuildCache<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn FindAllBuildCache<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn BuildUpdatedCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCurrentPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCurrentPropertyValueEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        propertyid: i32,
        ignoredefaultvalue: Param1,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            ignoredefaultvalue.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCachedPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCachedPropertyValueEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        propertyid: i32,
        ignoredefaultvalue: Param1,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            ignoredefaultvalue.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    pub unsafe fn GetCurrentPatternAs<T: ::windows::runtime::Interface>(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetCachedPatternAs<T: ::windows::runtime::Interface>(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetCurrentPattern(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn GetCachedPattern(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn GetCachedParent(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetCachedChildren(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentProcessId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn CurrentControlType(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentLocalizedControlType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAcceleratorKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAccessKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentHasKeyboardFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsKeyboardFocusable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsEnabled(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAutomationId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentClassName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentHelpText(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CurrentCulture(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsControlElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsContentElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsPassword(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentNativeWindowHandle(
        &self,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(retval),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentItemType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsOffscreen(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentOrientation(&self) -> ::windows::runtime::Result<OrientationType> {
        let mut result__: <OrientationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<OrientationType>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentFrameworkId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsRequiredForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentItemStatus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentBoundingRectangle(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    pub unsafe fn CurrentLabeledBy(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAriaRole(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAriaProperties(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsDataValidForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentControllerFor(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentDescribedBy(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentFlowsTo(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentProviderDescription(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CachedProcessId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn CachedControlType(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedLocalizedControlType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAcceleratorKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAccessKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedHasKeyboardFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsKeyboardFocusable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsEnabled(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAutomationId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedClassName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedHelpText(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CachedCulture(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsControlElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsContentElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsPassword(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedNativeWindowHandle(
        &self,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(retval),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedItemType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsOffscreen(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CachedOrientation(&self) -> ::windows::runtime::Result<OrientationType> {
        let mut result__: <OrientationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<OrientationType>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedFrameworkId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsRequiredForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedItemStatus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedBoundingRectangle(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    pub unsafe fn CachedLabeledBy(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).76)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAriaRole(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAriaProperties(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).78)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsDataValidForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CachedControllerFor(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedDescribedBy(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedFlowsTo(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedProviderDescription(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetClickablePoint(
        &self,
        clickable: *mut super::super::Foundation::POINT,
        gotclickable: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(clickable),
            ::std::mem::transmute(gotclickable),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentOptimizeForVisualContent(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedOptimizeForVisualContent(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentLiveSetting(&self) -> ::windows::runtime::Result<LiveSetting> {
        let mut result__: <LiveSetting as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<LiveSetting>(result__)
    }
    pub unsafe fn CachedLiveSetting(&self) -> ::windows::runtime::Result<LiveSetting> {
        let mut result__: <LiveSetting as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<LiveSetting>(result__)
    }
    pub unsafe fn CurrentFlowsFrom(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedFlowsFrom(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).90)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationElement2 {
    type Vtable = IUIAutomationElement2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1732888195,
        63245,
        17543,
        [166, 152, 95, 121, 213, 82, 144, 214],
    );
}
impl ::std::convert::From<IUIAutomationElement2> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationElement2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationElement2> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationElement2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomationElement2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationElement2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomationElement2> for IUIAutomationElement {
    fn from(value: IUIAutomationElement2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationElement2> for IUIAutomationElement {
    fn from(value: &IUIAutomationElement2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationElement> for IUIAutomationElement2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationElement> for &IUIAutomationElement2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationElement2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        updatedelement: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        ignoredefaultvalue: super::super::Foundation::BOOL,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        propertyid: i32,
        ignoredefaultvalue: super::super::Foundation::BOOL,
        retval: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        riid: *const ::windows::runtime::GUID,
        patternobject: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        riid: *const ::windows::runtime::GUID,
        patternobject: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        patternobject: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        patternid: i32,
        patternobject: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        parent: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        children: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut OrientationType,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut OrientationType,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::RECT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        clickable: *mut super::super::Foundation::POINT,
        gotclickable: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut LiveSetting,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut LiveSetting,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        retval: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IUIAutomationElement3(::windows::runtime::IUnknown);
impl IUIAutomationElement3 {
    pub unsafe fn SetFocus(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetRuntimeId(
        &self,
    ) -> ::windows::runtime::Result<*mut super::super::System::OleAutomation::SAFEARRAY> {
        let mut result__ : < * mut super::super::System::OleAutomation:: SAFEARRAY as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<*mut super::super::System::OleAutomation::SAFEARRAY>(result__)
    }
    pub unsafe fn FindFirst<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn FindAll<'a, Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>>(
        &self,
        scope: TreeScope,
        condition: Param1,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn FindFirstBuildCache<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn FindAllBuildCache<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, IUIAutomationCondition>,
        Param2: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        scope: TreeScope,
        condition: Param1,
        cacherequest: Param2,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(scope),
            condition.into_param().abi(),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn BuildUpdatedCache<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IUIAutomationCacheRequest>,
    >(
        &self,
        cacherequest: Param0,
    ) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            cacherequest.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCurrentPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCurrentPropertyValueEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        propertyid: i32,
        ignoredefaultvalue: Param1,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            ignoredefaultvalue.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCachedPropertyValue(
        &self,
        propertyid: i32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn GetCachedPropertyValueEx<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        propertyid: i32,
        ignoredefaultvalue: Param1,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(propertyid),
            ignoredefaultvalue.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    pub unsafe fn GetCurrentPatternAs<T: ::windows::runtime::Interface>(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetCachedPatternAs<T: ::windows::runtime::Interface>(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<T> {
        let mut result__ = ::std::option::Option::None;
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &<T as ::windows::runtime::Interface>::IID,
            &mut result__ as *mut _ as *mut _,
        )
        .and_some(result__)
    }
    pub unsafe fn GetCurrentPattern(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn GetCachedPattern(
        &self,
        patternid: i32,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(patternid),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn GetCachedParent(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    pub unsafe fn GetCachedChildren(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentProcessId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).20)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn CurrentControlType(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).21)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentLocalizedControlType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).22)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).23)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAcceleratorKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).24)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAccessKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).25)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentHasKeyboardFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).26)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsKeyboardFocusable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).27)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsEnabled(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).28)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAutomationId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).29)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentClassName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).30)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentHelpText(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).31)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CurrentCulture(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).32)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsControlElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).33)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsContentElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).34)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsPassword(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).35)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentNativeWindowHandle(
        &self,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).36)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(retval),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentItemType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).37)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsOffscreen(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).38)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentOrientation(&self) -> ::windows::runtime::Result<OrientationType> {
        let mut result__: <OrientationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).39)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<OrientationType>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentFrameworkId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).40)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsRequiredForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).41)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentItemStatus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).42)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentBoundingRectangle(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).43)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    pub unsafe fn CurrentLabeledBy(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).44)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAriaRole(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).45)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentAriaProperties(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).46)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsDataValidForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).47)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentControllerFor(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).48)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentDescribedBy(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).49)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CurrentFlowsTo(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).50)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentProviderDescription(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).51)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CachedProcessId(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).52)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn CachedControlType(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).53)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedLocalizedControlType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).54)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).55)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAcceleratorKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).56)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAccessKey(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).57)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedHasKeyboardFocus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).58)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsKeyboardFocusable(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).59)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsEnabled(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).60)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAutomationId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).61)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedClassName(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).62)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedHelpText(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).63)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn CachedCulture(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).64)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsControlElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).65)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsContentElement(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).66)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsPassword(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).67)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedNativeWindowHandle(
        &self,
        retval: super::super::Foundation::HWND,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).68)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(retval),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedItemType(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).69)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsOffscreen(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).70)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CachedOrientation(&self) -> ::windows::runtime::Result<OrientationType> {
        let mut result__: <OrientationType as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).71)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<OrientationType>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedFrameworkId(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).72)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsRequiredForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).73)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedItemStatus(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).74)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedBoundingRectangle(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::RECT> {
        let mut result__: <super::super::Foundation::RECT as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).75)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::RECT>(result__)
    }
    pub unsafe fn CachedLabeledBy(&self) -> ::windows::runtime::Result<IUIAutomationElement> {
        let mut result__: <IUIAutomationElement as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).76)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElement>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAriaRole(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).77)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedAriaProperties(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).78)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsDataValidForForm(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).79)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CachedControllerFor(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).80)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedDescribedBy(
        &self,
    ) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).81)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedFlowsTo(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).82)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedProviderDescription(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).83)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetClickablePoint(
        &self,
        clickable: *mut super::super::Foundation::POINT,
        gotclickable: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).84)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(clickable),
            ::std::mem::transmute(gotclickable),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentOptimizeForVisualContent(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).85)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedOptimizeForVisualContent(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).86)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn CurrentLiveSetting(&self) -> ::windows::runtime::Result<LiveSetting> {
        let mut result__: <LiveSetting as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).87)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<LiveSetting>(result__)
    }
    pub unsafe fn CachedLiveSetting(&self) -> ::windows::runtime::Result<LiveSetting> {
        let mut result__: <LiveSetting as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).88)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<LiveSetting>(result__)
    }
    pub unsafe fn CurrentFlowsFrom(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).89)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn CachedFlowsFrom(&self) -> ::windows::runtime::Result<IUIAutomationElementArray> {
        let mut result__: <IUIAutomationElementArray as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).90)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IUIAutomationElementArray>(result__)
    }
    pub unsafe fn ShowContextMenu(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).91)(::std::mem::transmute_copy(self)).ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CurrentIsPeripheral(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).92)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn CachedIsPeripheral(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).93)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IUIAutomationElement3 {
    type Vtable = IUIAutomationElement3_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2222055220,
        44768,
        18945,
        [167, 222, 125, 185, 175, 18, 194, 150],
    );
}
impl ::std::convert::From<IUIAutomationElement3> for ::windows::runtime::IUnknown {
    fn from(value: IUIAutomationElement3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationElement3> for ::windows::runtime::IUnknown {
    fn from(value: &IUIAutomationElement3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IUIAutomationElement3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IUIAutomationElement3
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IUIAutomationElement3> for IUIAutomationElement2 {
    fn from(value: IUIAutomationElement3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationElement3> for IUIAutomationElement2 {
    fn from(value: &IUIAutomationElement3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationElement2> for IUIAutomationElement3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationElement2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationElement2>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationElement2> for &IUIAutomationElement3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationElement2> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationElement2>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IUIAutomationElement3> for IUIAutomationElement {
    fn from(value: IUIAutomationElement3) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IUIAutomationElement3> for IUIAutomationElement {
    fn from(value: &IUIAutomationElement3) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationElement> for IUIAutomationElement3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IUIAutomationElement> for &IUIAutomationElement3 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IUIAutomationElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IUIAutomationElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IUIAutomationElement3_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        runtimeid: *mut *mut super::super::System::OleAutomation::SAFEARRAY,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        scope: TreeScope,
        condition: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        found: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cacherequest: ::windows::runtime::RawPtr,
        updatedelement: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
   