#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DYNAMIC_TIME_ZONE_INFORMATION {
    pub Bias: i32,
    pub StandardName: [u16; 32],
    pub StandardDate: super::super::Foundation::SYSTEMTIME,
    pub StandardBias: i32,
    pub DaylightName: [u16; 32],
    pub DaylightDate: super::super::Foundation::SYSTEMTIME,
    pub DaylightBias: i32,
    pub TimeZoneKeyName: [u16; 128],
    pub DynamicDaylightTimeDisabled: super::super::Foundation::BOOLEAN,
}
#[cfg(feature = "Win32_Foundation")]
impl DYNAMIC_TIME_ZONE_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DYNAMIC_TIME_ZONE_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DYNAMIC_TIME_ZONE_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DYNAMIC_TIME_ZONE_INFORMATION")
            .field("Bias", &self.Bias)
            .field("StandardName", &self.StandardName)
            .field("StandardDate", &self.StandardDate)
            .field("StandardBias", &self.StandardBias)
            .field("DaylightName", &self.DaylightName)
            .field("DaylightDate", &self.DaylightDate)
            .field("DaylightBias", &self.DaylightBias)
            .field("TimeZoneKeyName", &self.TimeZoneKeyName)
            .field(
                "DynamicDaylightTimeDisabled",
                &self.DynamicDaylightTimeDisabled,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DYNAMIC_TIME_ZONE_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.Bias == other.Bias
            && self.StandardName == other.StandardName
            && self.StandardDate == other.StandardDate
            && self.StandardBias == other.StandardBias
            && self.DaylightName == other.DaylightName
            && self.DaylightDate == other.DaylightDate
            && self.DaylightBias == other.DaylightBias
            && self.TimeZoneKeyName == other.TimeZoneKeyName
            && self.DynamicDaylightTimeDisabled == other.DynamicDaylightTimeDisabled
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DYNAMIC_TIME_ZONE_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DYNAMIC_TIME_ZONE_INFORMATION {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumDynamicTimeZoneInformation(
    dwindex: u32,
    lptimezoneinformation: *mut DYNAMIC_TIME_ZONE_INFORMATION,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "advapi32")]
        extern "system" {
            fn EnumDynamicTimeZoneInformation(
                dwindex: u32,
                lptimezoneinformation: *mut DYNAMIC_TIME_ZONE_INFORMATION,
            ) -> u32;
        }
        ::std::mem::transmute(EnumDynamicTimeZoneInformation(
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(lptimezoneinformation),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FileTimeToSystemTime(
    lpfiletime: *const super::super::Foundation::FILETIME,
    lpsystemtime: *mut super::super::Foundation::SYSTEMTIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn FileTimeToSystemTime(
                lpfiletime: *const super::super::Foundation::FILETIME,
                lpsystemtime: *mut super::super::Foundation::SYSTEMTIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(FileTimeToSystemTime(
            ::std::mem::transmute(lpfiletime),
            ::std::mem::transmute(lpsystemtime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDynamicTimeZoneInformation(
    ptimezoneinformation: *mut DYNAMIC_TIME_ZONE_INFORMATION,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn GetDynamicTimeZoneInformation(
                ptimezoneinformation: *mut DYNAMIC_TIME_ZONE_INFORMATION,
            ) -> u32;
        }
        ::std::mem::transmute(GetDynamicTimeZoneInformation(::std::mem::transmute(
            ptimezoneinformation,
        )))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDynamicTimeZoneInformationEffectiveYears(
    lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
    firstyear: *mut u32,
    lastyear: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "advapi32")]
        extern "system" {
            fn GetDynamicTimeZoneInformationEffectiveYears(
                lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
                firstyear: *mut u32,
                lastyear: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetDynamicTimeZoneInformationEffectiveYears(
            ::std::mem::transmute(lptimezoneinformation),
            ::std::mem::transmute(firstyear),
            ::std::mem::transmute(lastyear),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetTimeZoneInformation(lptimezoneinformation: *mut TIME_ZONE_INFORMATION) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn GetTimeZoneInformation(lptimezoneinformation: *mut TIME_ZONE_INFORMATION) -> u32;
        }
        ::std::mem::transmute(GetTimeZoneInformation(::std::mem::transmute(
            lptimezoneinformation,
        )))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetTimeZoneInformationForYear(
    wyear: u16,
    pdtzi: *const DYNAMIC_TIME_ZONE_INFORMATION,
    ptzi: *mut TIME_ZONE_INFORMATION,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn GetTimeZoneInformationForYear(
                wyear: u16,
                pdtzi: *const DYNAMIC_TIME_ZONE_INFORMATION,
                ptzi: *mut TIME_ZONE_INFORMATION,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetTimeZoneInformationForYear(
            ::std::mem::transmute(wyear),
            ::std::mem::transmute(pdtzi),
            ::std::mem::transmute(ptzi),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn LocalFileTimeToLocalSystemTime(
    timezoneinformation: *const TIME_ZONE_INFORMATION,
    localfiletime: *const super::super::Foundation::FILETIME,
    localsystemtime: *mut super::super::Foundation::SYSTEMTIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn LocalFileTimeToLocalSystemTime(
                timezoneinformation: *const TIME_ZONE_INFORMATION,
                localfiletime: *const super::super::Foundation::FILETIME,
                localsystemtime: *mut super::super::Foundation::SYSTEMTIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(LocalFileTimeToLocalSystemTime(
            ::std::mem::transmute(timezoneinformation),
            ::std::mem::transmute(localfiletime),
            ::std::mem::transmute(localsystemtime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn LocalSystemTimeToLocalFileTime(
    timezoneinformation: *const TIME_ZONE_INFORMATION,
    localsystemtime: *const super::super::Foundation::SYSTEMTIME,
    localfiletime: *mut super::super::Foundation::FILETIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn LocalSystemTimeToLocalFileTime(
                timezoneinformation: *const TIME_ZONE_INFORMATION,
                localsystemtime: *const super::super::Foundation::SYSTEMTIME,
                localfiletime: *mut super::super::Foundation::FILETIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(LocalSystemTimeToLocalFileTime(
            ::std::mem::transmute(timezoneinformation),
            ::std::mem::transmute(localsystemtime),
            ::std::mem::transmute(localfiletime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetDynamicTimeZoneInformation(
    lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn SetDynamicTimeZoneInformation(
                lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetDynamicTimeZoneInformation(::std::mem::transmute(
            lptimezoneinformation,
        )))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetTimeZoneInformation(
    lptimezoneinformation: *const TIME_ZONE_INFORMATION,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn SetTimeZoneInformation(
                lptimezoneinformation: *const TIME_ZONE_INFORMATION,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetTimeZoneInformation(::std::mem::transmute(
            lptimezoneinformation,
        )))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SystemTimeToFileTime(
    lpsystemtime: *const super::super::Foundation::SYSTEMTIME,
    lpfiletime: *mut super::super::Foundation::FILETIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn SystemTimeToFileTime(
                lpsystemtime: *const super::super::Foundation::SYSTEMTIME,
                lpfiletime: *mut super::super::Foundation::FILETIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(SystemTimeToFileTime(
            ::std::mem::transmute(lpsystemtime),
            ::std::mem::transmute(lpfiletime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SystemTimeToTzSpecificLocalTime(
    lptimezoneinformation: *const TIME_ZONE_INFORMATION,
    lpuniversaltime: *const super::super::Foundation::SYSTEMTIME,
    lplocaltime: *mut super::super::Foundation::SYSTEMTIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn SystemTimeToTzSpecificLocalTime(
                lptimezoneinformation: *const TIME_ZONE_INFORMATION,
                lpuniversaltime: *const super::super::Foundation::SYSTEMTIME,
                lplocaltime: *mut super::super::Foundation::SYSTEMTIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(SystemTimeToTzSpecificLocalTime(
            ::std::mem::transmute(lptimezoneinformation),
            ::std::mem::transmute(lpuniversaltime),
            ::std::mem::transmute(lplocaltime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SystemTimeToTzSpecificLocalTimeEx(
    lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
    lpuniversaltime: *const super::super::Foundation::SYSTEMTIME,
    lplocaltime: *mut super::super::Foundation::SYSTEMTIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn SystemTimeToTzSpecificLocalTimeEx(
                lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
                lpuniversaltime: *const super::super::Foundation::SYSTEMTIME,
                lplocaltime: *mut super::super::Foundation::SYSTEMTIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(SystemTimeToTzSpecificLocalTimeEx(
            ::std::mem::transmute(lptimezoneinformation),
            ::std::mem::transmute(lpuniversaltime),
            ::std::mem::transmute(lplocaltime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct TIME_ZONE_INFORMATION {
    pub Bias: i32,
    pub StandardName: [u16; 32],
    pub StandardDate: super::super::Foundation::SYSTEMTIME,
    pub StandardBias: i32,
    pub DaylightName: [u16; 32],
    pub DaylightDate: super::super::Foundation::SYSTEMTIME,
    pub DaylightBias: i32,
}
#[cfg(feature = "Win32_Foundation")]
impl TIME_ZONE_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for TIME_ZONE_INFORMATION {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for TIME_ZONE_INFORMATION {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("TIME_ZONE_INFORMATION")
            .field("Bias", &self.Bias)
            .field("StandardName", &self.StandardName)
            .field("StandardDate", &self.StandardDate)
            .field("StandardBias", &self.StandardBias)
            .field("DaylightName", &self.DaylightName)
            .field("DaylightDate", &self.DaylightDate)
            .field("DaylightBias", &self.DaylightBias)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for TIME_ZONE_INFORMATION {
    fn eq(&self, other: &Self) -> bool {
        self.Bias == other.Bias
            && self.StandardName == other.StandardName
            && self.StandardDate == other.StandardDate
            && self.StandardBias == other.StandardBias
            && self.DaylightName == other.DaylightName
            && self.DaylightDate == other.DaylightDate
            && self.DaylightBias == other.DaylightBias
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for TIME_ZONE_INFORMATION {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for TIME_ZONE_INFORMATION {
    type Abi = Self;
    type DefaultType = Self;
}
pub const TSF_Authenticated: u32 = 2u32;
pub const TSF_Hardware: u32 = 1u32;
pub const TSF_IPv6: u32 = 4u32;
pub const TSF_SignatureAuthenticated: u32 = 8u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn TzSpecificLocalTimeToSystemTime(
    lptimezoneinformation: *const TIME_ZONE_INFORMATION,
    lplocaltime: *const super::super::Foundation::SYSTEMTIME,
    lpuniversaltime: *mut super::super::Foundation::SYSTEMTIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn TzSpecificLocalTimeToSystemTime(
                lptimezoneinformation: *const TIME_ZONE_INFORMATION,
                lplocaltime: *const super::super::Foundation::SYSTEMTIME,
                lpuniversaltime: *mut super::super::Foundation::SYSTEMTIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(TzSpecificLocalTimeToSystemTime(
            ::std::mem::transmute(lptimezoneinformation),
            ::std::mem::transmute(lplocaltime),
            ::std::mem::transmute(lpuniversaltime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn TzSpecificLocalTimeToSystemTimeEx(
    lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
    lplocaltime: *const super::super::Foundation::SYSTEMTIME,
    lpuniversaltime: *mut super::super::Foundation::SYSTEMTIME,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn TzSpecificLocalTimeToSystemTimeEx(
                lptimezoneinformation: *const DYNAMIC_TIME_ZONE_INFORMATION,
                lplocaltime: *const super::super::Foundation::SYSTEMTIME,
                lpuniversaltime: *mut super::super::Foundation::SYSTEMTIME,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(TzSpecificLocalTimeToSystemTimeEx(
            ::std::mem::transmute(lptimezoneinformation),
            ::std::mem::transmute(lplocaltime),
            ::std::mem::transmute(lpuniversaltime),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
