#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
pub unsafe fn CreateMailslotA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    lpname: Param0,
    nmaxmessagesize: u32,
    lreadtimeout: u32,
    lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn CreateMailslotA(
                lpname: super::super::Foundation::PSTR,
                nmaxmessagesize: u32,
                lreadtimeout: u32,
                lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(CreateMailslotA(
            lpname.into_param().abi(),
            ::std::mem::transmute(nmaxmessagesize),
            ::std::mem::transmute(lreadtimeout),
            ::std::mem::transmute(lpsecurityattributes),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Security"))]
pub unsafe fn CreateMailslotW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    lpname: Param0,
    nmaxmessagesize: u32,
    lreadtimeout: u32,
    lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn CreateMailslotW(
                lpname: super::super::Foundation::PWSTR,
                nmaxmessagesize: u32,
                lreadtimeout: u32,
                lpsecurityattributes: *const super::super::Security::SECURITY_ATTRIBUTES,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(CreateMailslotW(
            lpname.into_param().abi(),
            ::std::mem::transmute(nmaxmessagesize),
            ::std::mem::transmute(lreadtimeout),
            ::std::mem::transmute(lpsecurityattributes),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetMailslotInfo<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hmailslot: Param0,
    lpmaxmessagesize: *mut u32,
    lpnextsize: *mut u32,
    lpmessagecount: *mut u32,
    lpreadtimeout: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn GetMailslotInfo(
                hmailslot: super::super::Foundation::HANDLE,
                lpmaxmessagesize: *mut u32,
                lpnextsize: *mut u32,
                lpmessagecount: *mut u32,
                lpreadtimeout: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetMailslotInfo(
            hmailslot.into_param().abi(),
            ::std::mem::transmute(lpmaxmessagesize),
            ::std::mem::transmute(lpnextsize),
            ::std::mem::transmute(lpmessagecount),
            ::std::mem::transmute(lpreadtimeout),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn SetMailslotInfo<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hmailslot: Param0,
    lreadtimeout: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "kernel32")]
        extern "system" {
            fn SetMailslotInfo(
                hmailslot: super::super::Foundation::HANDLE,
                lreadtimeout: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(SetMailslotInfo(
            hmailslot.into_param().abi(),
            ::std::mem::transmute(lreadtimeout),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
