#![allow(
    unused_variables,
    non_upper_case_globals,
    non_snake_case,
    unused_unsafe,
    non_camel_case_types,
    dead_code,
    clippy::all
)]
#[cfg(feature = "Win32_Graphics_Printing_PrintTicket")]
pub mod PrintTicket;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct ADDJOB_INFO_1A {
    pub Path: super::super::Foundation::PSTR,
    pub JobId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ADDJOB_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for ADDJOB_INFO_1A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for ADDJOB_INFO_1A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ADDJOB_INFO_1A")
            .field("Path", &self.Path)
            .field("JobId", &self.JobId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for ADDJOB_INFO_1A {
    fn eq(&self, other: &Self) -> bool {
        self.Path == other.Path && self.JobId == other.JobId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for ADDJOB_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for ADDJOB_INFO_1A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct ADDJOB_INFO_1W {
    pub Path: super::super::Foundation::PWSTR,
    pub JobId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl ADDJOB_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for ADDJOB_INFO_1W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for ADDJOB_INFO_1W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ADDJOB_INFO_1W")
            .field("Path", &self.Path)
            .field("JobId", &self.JobId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for ADDJOB_INFO_1W {
    fn eq(&self, other: &Self) -> bool {
        self.Path == other.Path && self.JobId == other.JobId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for ADDJOB_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for ADDJOB_INFO_1W {
    type Abi = Self;
    type DefaultType = Self;
}
pub const APD_COPY_ALL_FILES: u32 = 4u32;
pub const APD_COPY_FROM_DIRECTORY: u32 = 16u32;
pub const APD_COPY_NEW_FILES: u32 = 8u32;
pub const APD_STRICT_DOWNGRADE: u32 = 2u32;
pub const APD_STRICT_UPGRADE: u32 = 1u32;
pub const APPLYCPSUI_NO_NEWDEF: u32 = 1u32;
pub const APPLYCPSUI_OK_CANCEL_BUTTON: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct ATTRIBUTE_INFO_1 {
    pub dwJobNumberOfPagesPerSide: u32,
    pub dwDrvNumberOfPagesPerSide: u32,
    pub dwNupBorderFlags: u32,
    pub dwJobPageOrderFlags: u32,
    pub dwDrvPageOrderFlags: u32,
    pub dwJobNumberOfCopies: u32,
    pub dwDrvNumberOfCopies: u32,
}
impl ATTRIBUTE_INFO_1 {}
impl ::std::default::Default for ATTRIBUTE_INFO_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ATTRIBUTE_INFO_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ATTRIBUTE_INFO_1")
            .field("dwJobNumberOfPagesPerSide", &self.dwJobNumberOfPagesPerSide)
            .field("dwDrvNumberOfPagesPerSide", &self.dwDrvNumberOfPagesPerSide)
            .field("dwNupBorderFlags", &self.dwNupBorderFlags)
            .field("dwJobPageOrderFlags", &self.dwJobPageOrderFlags)
            .field("dwDrvPageOrderFlags", &self.dwDrvPageOrderFlags)
            .field("dwJobNumberOfCopies", &self.dwJobNumberOfCopies)
            .field("dwDrvNumberOfCopies", &self.dwDrvNumberOfCopies)
            .finish()
    }
}
impl ::std::cmp::PartialEq for ATTRIBUTE_INFO_1 {
    fn eq(&self, other: &Self) -> bool {
        self.dwJobNumberOfPagesPerSide == other.dwJobNumberOfPagesPerSide
            && self.dwDrvNumberOfPagesPerSide == other.dwDrvNumberOfPagesPerSide
            && self.dwNupBorderFlags == other.dwNupBorderFlags
            && self.dwJobPageOrderFlags == other.dwJobPageOrderFlags
            && self.dwDrvPageOrderFlags == other.dwDrvPageOrderFlags
            && self.dwJobNumberOfCopies == other.dwJobNumberOfCopies
            && self.dwDrvNumberOfCopies == other.dwDrvNumberOfCopies
    }
}
impl ::std::cmp::Eq for ATTRIBUTE_INFO_1 {}
unsafe impl ::windows::runtime::Abi for ATTRIBUTE_INFO_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct ATTRIBUTE_INFO_2 {
    pub dwJobNumberOfPagesPerSide: u32,
    pub dwDrvNumberOfPagesPerSide: u32,
    pub dwNupBorderFlags: u32,
    pub dwJobPageOrderFlags: u32,
    pub dwDrvPageOrderFlags: u32,
    pub dwJobNumberOfCopies: u32,
    pub dwDrvNumberOfCopies: u32,
    pub dwColorOptimization: u32,
}
impl ATTRIBUTE_INFO_2 {}
impl ::std::default::Default for ATTRIBUTE_INFO_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ATTRIBUTE_INFO_2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ATTRIBUTE_INFO_2")
            .field("dwJobNumberOfPagesPerSide", &self.dwJobNumberOfPagesPerSide)
            .field("dwDrvNumberOfPagesPerSide", &self.dwDrvNumberOfPagesPerSide)
            .field("dwNupBorderFlags", &self.dwNupBorderFlags)
            .field("dwJobPageOrderFlags", &self.dwJobPageOrderFlags)
            .field("dwDrvPageOrderFlags", &self.dwDrvPageOrderFlags)
            .field("dwJobNumberOfCopies", &self.dwJobNumberOfCopies)
            .field("dwDrvNumberOfCopies", &self.dwDrvNumberOfCopies)
            .field("dwColorOptimization", &self.dwColorOptimization)
            .finish()
    }
}
impl ::std::cmp::PartialEq for ATTRIBUTE_INFO_2 {
    fn eq(&self, other: &Self) -> bool {
        self.dwJobNumberOfPagesPerSide == other.dwJobNumberOfPagesPerSide
            && self.dwDrvNumberOfPagesPerSide == other.dwDrvNumberOfPagesPerSide
            && self.dwNupBorderFlags == other.dwNupBorderFlags
            && self.dwJobPageOrderFlags == other.dwJobPageOrderFlags
            && self.dwDrvPageOrderFlags == other.dwDrvPageOrderFlags
            && self.dwJobNumberOfCopies == other.dwJobNumberOfCopies
            && self.dwDrvNumberOfCopies == other.dwDrvNumberOfCopies
            && self.dwColorOptimization == other.dwColorOptimization
    }
}
impl ::std::cmp::Eq for ATTRIBUTE_INFO_2 {}
unsafe impl ::windows::runtime::Abi for ATTRIBUTE_INFO_2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct ATTRIBUTE_INFO_3 {
    pub dwJobNumberOfPagesPerSide: u32,
    pub dwDrvNumberOfPagesPerSide: u32,
    pub dwNupBorderFlags: u32,
    pub dwJobPageOrderFlags: u32,
    pub dwDrvPageOrderFlags: u32,
    pub dwJobNumberOfCopies: u32,
    pub dwDrvNumberOfCopies: u32,
    pub dwColorOptimization: u32,
    pub dmPrintQuality: i16,
    pub dmYResolution: i16,
}
impl ATTRIBUTE_INFO_3 {}
impl ::std::default::Default for ATTRIBUTE_INFO_3 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ATTRIBUTE_INFO_3 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ATTRIBUTE_INFO_3")
            .field("dwJobNumberOfPagesPerSide", &self.dwJobNumberOfPagesPerSide)
            .field("dwDrvNumberOfPagesPerSide", &self.dwDrvNumberOfPagesPerSide)
            .field("dwNupBorderFlags", &self.dwNupBorderFlags)
            .field("dwJobPageOrderFlags", &self.dwJobPageOrderFlags)
            .field("dwDrvPageOrderFlags", &self.dwDrvPageOrderFlags)
            .field("dwJobNumberOfCopies", &self.dwJobNumberOfCopies)
            .field("dwDrvNumberOfCopies", &self.dwDrvNumberOfCopies)
            .field("dwColorOptimization", &self.dwColorOptimization)
            .field("dmPrintQuality", &self.dmPrintQuality)
            .field("dmYResolution", &self.dmYResolution)
            .finish()
    }
}
impl ::std::cmp::PartialEq for ATTRIBUTE_INFO_3 {
    fn eq(&self, other: &Self) -> bool {
        self.dwJobNumberOfPagesPerSide == other.dwJobNumberOfPagesPerSide
            && self.dwDrvNumberOfPagesPerSide == other.dwDrvNumberOfPagesPerSide
            && self.dwNupBorderFlags == other.dwNupBorderFlags
            && self.dwJobPageOrderFlags == other.dwJobPageOrderFlags
            && self.dwDrvPageOrderFlags == other.dwDrvPageOrderFlags
            && self.dwJobNumberOfCopies == other.dwJobNumberOfCopies
            && self.dwDrvNumberOfCopies == other.dwDrvNumberOfCopies
            && self.dwColorOptimization == other.dwColorOptimization
            && self.dmPrintQuality == other.dmPrintQuality
            && self.dmYResolution == other.dmYResolution
    }
}
impl ::std::cmp::Eq for ATTRIBUTE_INFO_3 {}
unsafe impl ::windows::runtime::Abi for ATTRIBUTE_INFO_3 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct ATTRIBUTE_INFO_4 {
    pub dwJobNumberOfPagesPerSide: u32,
    pub dwDrvNumberOfPagesPerSide: u32,
    pub dwNupBorderFlags: u32,
    pub dwJobPageOrderFlags: u32,
    pub dwDrvPageOrderFlags: u32,
    pub dwJobNumberOfCopies: u32,
    pub dwDrvNumberOfCopies: u32,
    pub dwColorOptimization: u32,
    pub dmPrintQuality: i16,
    pub dmYResolution: i16,
    pub dwDuplexFlags: u32,
    pub dwNupDirection: u32,
    pub dwBookletFlags: u32,
    pub dwScalingPercentX: u32,
    pub dwScalingPercentY: u32,
}
impl ATTRIBUTE_INFO_4 {}
impl ::std::default::Default for ATTRIBUTE_INFO_4 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for ATTRIBUTE_INFO_4 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("ATTRIBUTE_INFO_4")
            .field("dwJobNumberOfPagesPerSide", &self.dwJobNumberOfPagesPerSide)
            .field("dwDrvNumberOfPagesPerSide", &self.dwDrvNumberOfPagesPerSide)
            .field("dwNupBorderFlags", &self.dwNupBorderFlags)
            .field("dwJobPageOrderFlags", &self.dwJobPageOrderFlags)
            .field("dwDrvPageOrderFlags", &self.dwDrvPageOrderFlags)
            .field("dwJobNumberOfCopies", &self.dwJobNumberOfCopies)
            .field("dwDrvNumberOfCopies", &self.dwDrvNumberOfCopies)
            .field("dwColorOptimization", &self.dwColorOptimization)
            .field("dmPrintQuality", &self.dmPrintQuality)
            .field("dmYResolution", &self.dmYResolution)
            .field("dwDuplexFlags", &self.dwDuplexFlags)
            .field("dwNupDirection", &self.dwNupDirection)
            .field("dwBookletFlags", &self.dwBookletFlags)
            .field("dwScalingPercentX", &self.dwScalingPercentX)
            .field("dwScalingPercentY", &self.dwScalingPercentY)
            .finish()
    }
}
impl ::std::cmp::PartialEq for ATTRIBUTE_INFO_4 {
    fn eq(&self, other: &Self) -> bool {
        self.dwJobNumberOfPagesPerSide == other.dwJobNumberOfPagesPerSide
            && self.dwDrvNumberOfPagesPerSide == other.dwDrvNumberOfPagesPerSide
            && self.dwNupBorderFlags == other.dwNupBorderFlags
            && self.dwJobPageOrderFlags == other.dwJobPageOrderFlags
            && self.dwDrvPageOrderFlags == other.dwDrvPageOrderFlags
            && self.dwJobNumberOfCopies == other.dwJobNumberOfCopies
            && self.dwDrvNumberOfCopies == other.dwDrvNumberOfCopies
            && self.dwColorOptimization == other.dwColorOptimization
            && self.dmPrintQuality == other.dmPrintQuality
            && self.dmYResolution == other.dmYResolution
            && self.dwDuplexFlags == other.dwDuplexFlags
            && self.dwNupDirection == other.dwNupDirection
            && self.dwBookletFlags == other.dwBookletFlags
            && self.dwScalingPercentX == other.dwScalingPercentX
            && self.dwScalingPercentY == other.dwScalingPercentY
    }
}
impl ::std::cmp::Eq for ATTRIBUTE_INFO_4 {}
unsafe impl ::windows::runtime::Abi for ATTRIBUTE_INFO_4 {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AbortPrinter<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AbortPrinter(
                hprinter: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AbortPrinter(hprinter.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddFormA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pform: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddFormA(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pform: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddFormA(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pform),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddFormW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pform: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddFormW(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pform: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddFormW(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pform),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddJobA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pdata: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddJobA(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pdata: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddJobA(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddJobW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pdata: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddJobW(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pdata: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddJobW(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddMonitorA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    level: u32,
    pmonitors: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddMonitorA(
                pname: super::super::Foundation::PSTR,
                level: u32,
                pmonitors: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddMonitorA(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pmonitors),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddMonitorW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    level: u32,
    pmonitors: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddMonitorW(
                pname: super::super::Foundation::PWSTR,
                level: u32,
                pmonitors: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddMonitorW(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pmonitors),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPortA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    hwnd: Param1,
    pmonitorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPortA(
                pname: super::super::Foundation::PSTR,
                hwnd: super::super::Foundation::HWND,
                pmonitorname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPortA(
            pname.into_param().abi(),
            hwnd.into_param().abi(),
            pmonitorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPortW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    hwnd: Param1,
    pmonitorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPortW(
                pname: super::super::Foundation::PWSTR,
                hwnd: super::super::Foundation::HWND,
                pmonitorname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPortW(
            pname.into_param().abi(),
            hwnd.into_param().abi(),
            pmonitorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrintDeviceObject<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
    #[cfg(windows)]
    {
        #[link(name = "spoolss")]
        extern "system" {
            fn AddPrintDeviceObject(
                hprinter: super::super::Foundation::HANDLE,
                phdeviceobject: *mut super::super::Foundation::HANDLE,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        AddPrintDeviceObject(hprinter.into_param().abi(), &mut result__)
            .from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrintProcessorA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    ppathname: Param2,
    pprintprocessorname: Param3,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrintProcessorA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                ppathname: super::super::Foundation::PSTR,
                pprintprocessorname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrintProcessorA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ppathname.into_param().abi(),
            pprintprocessorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrintProcessorW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    ppathname: Param2,
    pprintprocessorname: Param3,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrintProcessorW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                ppathname: super::super::Foundation::PWSTR,
                pprintprocessorname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrintProcessorW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ppathname.into_param().abi(),
            pprintprocessorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrintProvidorA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    level: u32,
    pprovidorinfo: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrintProvidorA(
                pname: super::super::Foundation::PSTR,
                level: u32,
                pprovidorinfo: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrintProvidorA(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprovidorinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrintProvidorW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    level: u32,
    pprovidorinfo: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrintProvidorW(
                pname: super::super::Foundation::PWSTR,
                level: u32,
                pprovidorinfo: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrintProvidorW(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprovidorinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    level: u32,
    pprinter: *const u8,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterA(
                pname: super::super::Foundation::PSTR,
                level: u32,
                pprinter: *const u8,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(AddPrinterA(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprinter),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterConnection2A<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hwnd: Param0,
    pszname: Param1,
    dwlevel: u32,
    pconnectioninfo: *const ::std::ffi::c_void,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterConnection2A(
                hwnd: super::super::Foundation::HWND,
                pszname: super::super::Foundation::PSTR,
                dwlevel: u32,
                pconnectioninfo: *const ::std::ffi::c_void,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterConnection2A(
            hwnd.into_param().abi(),
            pszname.into_param().abi(),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pconnectioninfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterConnection2W<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hwnd: Param0,
    pszname: Param1,
    dwlevel: u32,
    pconnectioninfo: *const ::std::ffi::c_void,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterConnection2W(
                hwnd: super::super::Foundation::HWND,
                pszname: super::super::Foundation::PWSTR,
                dwlevel: u32,
                pconnectioninfo: *const ::std::ffi::c_void,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterConnection2W(
            hwnd.into_param().abi(),
            pszname.into_param().abi(),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pconnectioninfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterConnectionA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterConnectionA(
                pname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterConnectionA(pname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterConnectionW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterConnectionW(
                pname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterConnectionW(pname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterDriverA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    level: u32,
    pdriverinfo: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterDriverA(
                pname: super::super::Foundation::PSTR,
                level: u32,
                pdriverinfo: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterDriverA(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterDriverExA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    level: u32,
    lpbdriverinfo: *const u8,
    dwfilecopyflags: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterDriverExA(
                pname: super::super::Foundation::PSTR,
                level: u32,
                lpbdriverinfo: *const u8,
                dwfilecopyflags: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterDriverExA(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(lpbdriverinfo),
            ::std::mem::transmute(dwfilecopyflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterDriverExW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    level: u32,
    lpbdriverinfo: *const u8,
    dwfilecopyflags: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterDriverExW(
                pname: super::super::Foundation::PWSTR,
                level: u32,
                lpbdriverinfo: *const u8,
                dwfilecopyflags: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterDriverExW(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(lpbdriverinfo),
            ::std::mem::transmute(dwfilecopyflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterDriverW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    level: u32,
    pdriverinfo: *const u8,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterDriverW(
                pname: super::super::Foundation::PWSTR,
                level: u32,
                pdriverinfo: *const u8,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AddPrinterDriverW(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AddPrinterW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    level: u32,
    pprinter: *const u8,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AddPrinterW(
                pname: super::super::Foundation::PWSTR,
                level: u32,
                pprinter: *const u8,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(AddPrinterW(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprinter),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn AdvancedDocumentPropertiesA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hwnd: Param0,
    hprinter: Param1,
    pdevicename: Param2,
    pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEA,
    pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEA,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AdvancedDocumentPropertiesA(
                hwnd: super::super::Foundation::HWND,
                hprinter: super::super::Foundation::HANDLE,
                pdevicename: super::super::Foundation::PSTR,
                pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEA,
                pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEA,
            ) -> i32;
        }
        ::std::mem::transmute(AdvancedDocumentPropertiesA(
            hwnd.into_param().abi(),
            hprinter.into_param().abi(),
            pdevicename.into_param().abi(),
            ::std::mem::transmute(pdevmodeoutput),
            ::std::mem::transmute(pdevmodeinput),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn AdvancedDocumentPropertiesW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hwnd: Param0,
    hprinter: Param1,
    pdevicename: Param2,
    pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEW,
    pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEW,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn AdvancedDocumentPropertiesW(
                hwnd: super::super::Foundation::HWND,
                hprinter: super::super::Foundation::HANDLE,
                pdevicename: super::super::Foundation::PWSTR,
                pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEW,
                pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEW,
            ) -> i32;
        }
        ::std::mem::transmute(AdvancedDocumentPropertiesW(
            hwnd.into_param().abi(),
            hprinter.into_param().abi(),
            pdevicename.into_param().abi(),
            ::std::mem::transmute(pdevmodeoutput),
            ::std::mem::transmute(pdevmodeinput),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn AppendPrinterNotifyInfoData(
    pinfodest: *const PRINTER_NOTIFY_INFO,
    pdatasrc: *const PRINTER_NOTIFY_INFO_DATA,
    fdwflags: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "spoolss")]
        extern "system" {
            fn AppendPrinterNotifyInfoData(
                pinfodest: *const PRINTER_NOTIFY_INFO,
                pdatasrc: *const PRINTER_NOTIFY_INFO_DATA,
                fdwflags: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(AppendPrinterNotifyInfoData(
            ::std::mem::transmute(pinfodest),
            ::std::mem::transmute(pdatasrc),
            ::std::mem::transmute(fdwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const BIDI_ACCESS_ADMINISTRATOR: u32 = 1u32;
pub const BIDI_ACCESS_USER: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BIDI_DATA {
    pub dwBidiType: u32,
    pub u: BIDI_DATA_0,
}
#[cfg(feature = "Win32_Foundation")]
impl BIDI_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BIDI_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BIDI_DATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BIDI_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BIDI_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union BIDI_DATA_0 {
    pub bData: super::super::Foundation::BOOL,
    pub iData: i32,
    pub sData: super::super::Foundation::PWSTR,
    pub fData: f32,
    pub biData: BINARY_CONTAINER,
}
#[cfg(feature = "Win32_Foundation")]
impl BIDI_DATA_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BIDI_DATA_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BIDI_DATA_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BIDI_DATA_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BIDI_DATA_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BIDI_REQUEST_CONTAINER {
    pub Version: u32,
    pub Flags: u32,
    pub Count: u32,
    pub aData: [BIDI_REQUEST_DATA; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl BIDI_REQUEST_CONTAINER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BIDI_REQUEST_CONTAINER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BIDI_REQUEST_CONTAINER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BIDI_REQUEST_CONTAINER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BIDI_REQUEST_CONTAINER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BIDI_REQUEST_DATA {
    pub dwReqNumber: u32,
    pub pSchema: super::super::Foundation::PWSTR,
    pub data: BIDI_DATA,
}
#[cfg(feature = "Win32_Foundation")]
impl BIDI_REQUEST_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BIDI_REQUEST_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BIDI_REQUEST_DATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BIDI_REQUEST_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BIDI_REQUEST_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BIDI_RESPONSE_CONTAINER {
    pub Version: u32,
    pub Flags: u32,
    pub Count: u32,
    pub aData: [BIDI_RESPONSE_DATA; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl BIDI_RESPONSE_CONTAINER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BIDI_RESPONSE_CONTAINER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BIDI_RESPONSE_CONTAINER {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BIDI_RESPONSE_CONTAINER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BIDI_RESPONSE_CONTAINER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BIDI_RESPONSE_DATA {
    pub dwResult: u32,
    pub dwReqNumber: u32,
    pub pSchema: super::super::Foundation::PWSTR,
    pub data: BIDI_DATA,
}
#[cfg(feature = "Win32_Foundation")]
impl BIDI_RESPONSE_DATA {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BIDI_RESPONSE_DATA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BIDI_RESPONSE_DATA {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BIDI_RESPONSE_DATA {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BIDI_RESPONSE_DATA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct BIDI_TYPE(pub i32);
pub const BIDI_NULL: BIDI_TYPE = BIDI_TYPE(0i32);
pub const BIDI_INT: BIDI_TYPE = BIDI_TYPE(1i32);
pub const BIDI_FLOAT: BIDI_TYPE = BIDI_TYPE(2i32);
pub const BIDI_BOOL: BIDI_TYPE = BIDI_TYPE(3i32);
pub const BIDI_STRING: BIDI_TYPE = BIDI_TYPE(4i32);
pub const BIDI_TEXT: BIDI_TYPE = BIDI_TYPE(5i32);
pub const BIDI_ENUM: BIDI_TYPE = BIDI_TYPE(6i32);
pub const BIDI_BLOB: BIDI_TYPE = BIDI_TYPE(7i32);
impl ::std::convert::From<i32> for BIDI_TYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for BIDI_TYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct BINARY_CONTAINER {
    pub cbBuf: u32,
    pub pData: *mut u8,
}
impl BINARY_CONTAINER {}
impl ::std::default::Default for BINARY_CONTAINER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BINARY_CONTAINER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BINARY_CONTAINER")
            .field("cbBuf", &self.cbBuf)
            .field("pData", &self.pData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BINARY_CONTAINER {
    fn eq(&self, other: &Self) -> bool {
        self.cbBuf == other.cbBuf && self.pData == other.pData
    }
}
impl ::std::cmp::Eq for BINARY_CONTAINER {}
unsafe impl ::windows::runtime::Abi for BINARY_CONTAINER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const BOOKLET_EDGE_LEFT: u32 = 0u32;
pub const BOOKLET_EDGE_RIGHT: u32 = 1u32;
pub const BOOKLET_PRINT: u32 = 2u32;
pub const BORDER_PRINT: u32 = 0u32;
pub const BidiRequest: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    3105237539,
    17913,
    18380,
    [128, 245, 254, 15, 233, 185, 225, 162],
);
pub const BidiRequestContainer: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    4233857572,
    56069,
    18945,
    [131, 136, 34, 237, 246, 194, 187, 186],
);
pub const BidiSpl: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    711017024,
    42181,
    19507,
    [189, 135, 27, 199, 9, 51, 22, 57],
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BranchOfficeJobData {
    pub eEventType: EBranchOfficeJobEventType,
    pub JobId: u32,
    pub JobInfo: BranchOfficeJobData_0,
}
#[cfg(feature = "Win32_Foundation")]
impl BranchOfficeJobData {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BranchOfficeJobData {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BranchOfficeJobData {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BranchOfficeJobData {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BranchOfficeJobData {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union BranchOfficeJobData_0 {
    pub LogJobPrinted: BranchOfficeJobDataPrinted,
    pub LogJobRendered: BranchOfficeJobDataRendered,
    pub LogJobError: BranchOfficeJobDataError,
    pub LogPipelineFailed: BranchOfficeJobDataPipelineFailed,
    pub LogOfflineFileFull: BranchOfficeLogOfflineFileFull,
}
#[cfg(feature = "Win32_Foundation")]
impl BranchOfficeJobData_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BranchOfficeJobData_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BranchOfficeJobData_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BranchOfficeJobData_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BranchOfficeJobData_0 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BranchOfficeJobDataContainer {
    pub cJobDataEntries: u32,
    pub JobData: [BranchOfficeJobData; 1],
}
#[cfg(feature = "Win32_Foundation")]
impl BranchOfficeJobDataContainer {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BranchOfficeJobDataContainer {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BranchOfficeJobDataContainer {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BranchOfficeJobDataContainer {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BranchOfficeJobDataContainer {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BranchOfficeJobDataError {
    pub LastError: u32,
    pub pDocumentName: super::super::Foundation::PWSTR,
    pub pUserName: super::super::Foundation::PWSTR,
    pub pPrinterName: super::super::Foundation::PWSTR,
    pub pDataType: super::super::Foundation::PWSTR,
    pub TotalSize: i64,
    pub PrintedSize: i64,
    pub TotalPages: u32,
    pub PrintedPages: u32,
    pub pMachineName: super::super::Foundation::PWSTR,
    pub pJobError: super::super::Foundation::PWSTR,
    pub pErrorDescription: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl BranchOfficeJobDataError {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BranchOfficeJobDataError {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BranchOfficeJobDataError {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BranchOfficeJobDataError")
            .field("LastError", &self.LastError)
            .field("pDocumentName", &self.pDocumentName)
            .field("pUserName", &self.pUserName)
            .field("pPrinterName", &self.pPrinterName)
            .field("pDataType", &self.pDataType)
            .field("TotalSize", &self.TotalSize)
            .field("PrintedSize", &self.PrintedSize)
            .field("TotalPages", &self.TotalPages)
            .field("PrintedPages", &self.PrintedPages)
            .field("pMachineName", &self.pMachineName)
            .field("pJobError", &self.pJobError)
            .field("pErrorDescription", &self.pErrorDescription)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BranchOfficeJobDataError {
    fn eq(&self, other: &Self) -> bool {
        self.LastError == other.LastError
            && self.pDocumentName == other.pDocumentName
            && self.pUserName == other.pUserName
            && self.pPrinterName == other.pPrinterName
            && self.pDataType == other.pDataType
            && self.TotalSize == other.TotalSize
            && self.PrintedSize == other.PrintedSize
            && self.TotalPages == other.TotalPages
            && self.PrintedPages == other.PrintedPages
            && self.pMachineName == other.pMachineName
            && self.pJobError == other.pJobError
            && self.pErrorDescription == other.pErrorDescription
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BranchOfficeJobDataError {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BranchOfficeJobDataError {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BranchOfficeJobDataPipelineFailed {
    pub pDocumentName: super::super::Foundation::PWSTR,
    pub pPrinterName: super::super::Foundation::PWSTR,
    pub pExtraErrorInfo: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl BranchOfficeJobDataPipelineFailed {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BranchOfficeJobDataPipelineFailed {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BranchOfficeJobDataPipelineFailed {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BranchOfficeJobDataPipelineFailed")
            .field("pDocumentName", &self.pDocumentName)
            .field("pPrinterName", &self.pPrinterName)
            .field("pExtraErrorInfo", &self.pExtraErrorInfo)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BranchOfficeJobDataPipelineFailed {
    fn eq(&self, other: &Self) -> bool {
        self.pDocumentName == other.pDocumentName
            && self.pPrinterName == other.pPrinterName
            && self.pExtraErrorInfo == other.pExtraErrorInfo
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BranchOfficeJobDataPipelineFailed {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BranchOfficeJobDataPipelineFailed {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BranchOfficeJobDataPrinted {
    pub Status: u32,
    pub pDocumentName: super::super::Foundation::PWSTR,
    pub pUserName: super::super::Foundation::PWSTR,
    pub pMachineName: super::super::Foundation::PWSTR,
    pub pPrinterName: super::super::Foundation::PWSTR,
    pub pPortName: super::super::Foundation::PWSTR,
    pub Size: i64,
    pub TotalPages: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl BranchOfficeJobDataPrinted {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BranchOfficeJobDataPrinted {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BranchOfficeJobDataPrinted {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BranchOfficeJobDataPrinted")
            .field("Status", &self.Status)
            .field("pDocumentName", &self.pDocumentName)
            .field("pUserName", &self.pUserName)
            .field("pMachineName", &self.pMachineName)
            .field("pPrinterName", &self.pPrinterName)
            .field("pPortName", &self.pPortName)
            .field("Size", &self.Size)
            .field("TotalPages", &self.TotalPages)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BranchOfficeJobDataPrinted {
    fn eq(&self, other: &Self) -> bool {
        self.Status == other.Status
            && self.pDocumentName == other.pDocumentName
            && self.pUserName == other.pUserName
            && self.pMachineName == other.pMachineName
            && self.pPrinterName == other.pPrinterName
            && self.pPortName == other.pPortName
            && self.Size == other.Size
            && self.TotalPages == other.TotalPages
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BranchOfficeJobDataPrinted {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BranchOfficeJobDataPrinted {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct BranchOfficeJobDataRendered {
    pub Size: i64,
    pub ICMMethod: u32,
    pub Color: i16,
    pub PrintQuality: i16,
    pub YResolution: i16,
    pub Copies: i16,
    pub TTOption: i16,
}
impl BranchOfficeJobDataRendered {}
impl ::std::default::Default for BranchOfficeJobDataRendered {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for BranchOfficeJobDataRendered {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BranchOfficeJobDataRendered")
            .field("Size", &self.Size)
            .field("ICMMethod", &self.ICMMethod)
            .field("Color", &self.Color)
            .field("PrintQuality", &self.PrintQuality)
            .field("YResolution", &self.YResolution)
            .field("Copies", &self.Copies)
            .field("TTOption", &self.TTOption)
            .finish()
    }
}
impl ::std::cmp::PartialEq for BranchOfficeJobDataRendered {
    fn eq(&self, other: &Self) -> bool {
        self.Size == other.Size
            && self.ICMMethod == other.ICMMethod
            && self.Color == other.Color
            && self.PrintQuality == other.PrintQuality
            && self.YResolution == other.YResolution
            && self.Copies == other.Copies
            && self.TTOption == other.TTOption
    }
}
impl ::std::cmp::Eq for BranchOfficeJobDataRendered {}
unsafe impl ::windows::runtime::Abi for BranchOfficeJobDataRendered {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct BranchOfficeLogOfflineFileFull {
    pub pMachineName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl BranchOfficeLogOfflineFileFull {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for BranchOfficeLogOfflineFileFull {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for BranchOfficeLogOfflineFileFull {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("BranchOfficeLogOfflineFileFull")
            .field("pMachineName", &self.pMachineName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for BranchOfficeLogOfflineFileFull {
    fn eq(&self, other: &Self) -> bool {
        self.pMachineName == other.pMachineName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for BranchOfficeLogOfflineFileFull {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for BranchOfficeLogOfflineFileFull {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CC_BIG5: i32 = -10i32;
pub const CC_CP437: i32 = -1i32;
pub const CC_CP850: i32 = -2i32;
pub const CC_CP863: i32 = -3i32;
pub const CC_DEFAULT: u32 = 0u32;
pub const CC_GB2312: i32 = -16i32;
pub const CC_ISC: i32 = -11i32;
pub const CC_JIS: i32 = -12i32;
pub const CC_JIS_ANK: i32 = -13i32;
pub const CC_NOPRECNV: u32 = 65535u32;
pub const CC_NS86: i32 = -14i32;
pub const CC_SJIS: i32 = -17i32;
pub const CC_TCA: i32 = -15i32;
pub const CC_WANSUNG: i32 = -18i32;
pub const CDM_CONVERT: u32 = 1u32;
pub const CDM_CONVERT351: u32 = 2u32;
pub const CDM_DRIVER_DEFAULT: u32 = 4u32;
pub const CHKBOXS_FALSE_PDATA: u32 = 3u32;
pub const CHKBOXS_FALSE_TRUE: u32 = 0u32;
pub const CHKBOXS_NONE_PDATA: u32 = 6u32;
pub const CHKBOXS_NO_PDATA: u32 = 4u32;
pub const CHKBOXS_NO_YES: u32 = 1u32;
pub const CHKBOXS_OFF_ON: u32 = 2u32;
pub const CHKBOXS_OFF_PDATA: u32 = 5u32;
pub const CLSID_OEMPTPROVIDER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2440181906,
    17874,
    18658,
    [158, 201, 86, 35, 121, 218, 249, 146],
);
pub const CLSID_OEMRENDER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1835712294,
    40760,
    4561,
    [136, 42, 0, 192, 79, 185, 97, 236],
);
pub const CLSID_OEMUI: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    2882437335,
    40774,
    4561,
    [136, 42, 0, 192, 79, 185, 97, 236],
);
pub const CLSID_OEMUIMXDC: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1309950720,
    23363,
    17032,
    [147, 42, 94, 77, 214, 216, 43, 237],
);
pub const CLSID_PTPROVIDER: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
    1185682715,
    33936,
    17713,
    [150, 204, 85, 191, 43, 241, 158, 17],
);
pub const CLSID_XPSRASTERIZER_FACTORY: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1346271679,
        7433,
        18276,
        [157, 114, 30, 176, 198, 89, 103, 198],
    );
pub const COLOR_OPTIMIZATION: u32 = 1u32;
#[derive(:: std :: clone :: Clone)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub struct COMPROPSHEETUI {
    pub cbSize: u16,
    pub Flags: u16,
    pub hInstCaller: super::super::Foundation::HINSTANCE,
    pub pCallerName: *mut i8,
    pub UserData: usize,
    pub pHelpFile: *mut i8,
    pub pfnCallBack: ::std::option::Option<_CPSUICALLBACK>,
    pub pOptItem: *mut OPTITEM,
    pub pDlgPage: *mut DLGPAGE,
    pub cOptItem: u16,
    pub cDlgPage: u16,
    pub IconID: usize,
    pub pOptItemName: *mut i8,
    pub CallerVersion: u16,
    pub OptItemVersion: u16,
    pub dwReserved: [usize; 4],
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl COMPROPSHEETUI {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for COMPROPSHEETUI {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::fmt::Debug for COMPROPSHEETUI {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("COMPROPSHEETUI")
            .field("cbSize", &self.cbSize)
            .field("Flags", &self.Flags)
            .field("hInstCaller", &self.hInstCaller)
            .field("pCallerName", &self.pCallerName)
            .field("UserData", &self.UserData)
            .field("pHelpFile", &self.pHelpFile)
            .field("pOptItem", &self.pOptItem)
            .field("pDlgPage", &self.pDlgPage)
            .field("cOptItem", &self.cOptItem)
            .field("cDlgPage", &self.cDlgPage)
            .field("IconID", &self.IconID)
            .field("pOptItemName", &self.pOptItemName)
            .field("CallerVersion", &self.CallerVersion)
            .field("OptItemVersion", &self.OptItemVersion)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for COMPROPSHEETUI {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.Flags == other.Flags
            && self.hInstCaller == other.hInstCaller
            && self.pCallerName == other.pCallerName
            && self.UserData == other.UserData
            && self.pHelpFile == other.pHelpFile
            && self.pfnCallBack.map(|f| f as usize) == other.pfnCallBack.map(|f| f as usize)
            && self.pOptItem == other.pOptItem
            && self.pDlgPage == other.pDlgPage
            && self.cOptItem == other.cOptItem
            && self.cDlgPage == other.cDlgPage
            && self.IconID == other.IconID
            && self.pOptItemName == other.pOptItemName
            && self.CallerVersion == other.CallerVersion
            && self.OptItemVersion == other.OptItemVersion
            && self.dwReserved == other.dwReserved
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for COMPROPSHEETUI {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for COMPROPSHEETUI {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CONFIG_INFO_DATA_1 {
    pub Reserved: [u8; 128],
    pub dwVersion: u32,
}
impl CONFIG_INFO_DATA_1 {}
impl ::std::default::Default for CONFIG_INFO_DATA_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CONFIG_INFO_DATA_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CONFIG_INFO_DATA_1")
            .field("Reserved", &self.Reserved)
            .field("dwVersion", &self.dwVersion)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CONFIG_INFO_DATA_1 {
    fn eq(&self, other: &Self) -> bool {
        self.Reserved == other.Reserved && self.dwVersion == other.dwVersion
    }
}
impl ::std::cmp::Eq for CONFIG_INFO_DATA_1 {}
unsafe impl ::windows::runtime::Abi for CONFIG_INFO_DATA_1 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const COPYFILE_EVENT_ADD_PRINTER_CONNECTION: u32 = 3u32;
pub const COPYFILE_EVENT_DELETE_PRINTER: u32 = 2u32;
pub const COPYFILE_EVENT_DELETE_PRINTER_CONNECTION: u32 = 4u32;
pub const COPYFILE_EVENT_FILES_CHANGED: u32 = 5u32;
pub const COPYFILE_EVENT_SET_PRINTER_DATAEX: u32 = 1u32;
pub const COPYFILE_FLAG_CLIENT_SPOOLER: u32 = 1u32;
pub const COPYFILE_FLAG_SERVER_SPOOLER: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
pub struct CORE_PRINTER_DRIVERA {
    pub CoreDriverGUID: ::windows::runtime::GUID,
    pub ftDriverDate: super::super::Foundation::FILETIME,
    pub dwlDriverVersion: u64,
    pub szPackageID: [super::super::System::SystemServices::CHAR; 260],
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl CORE_PRINTER_DRIVERA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::default::Default for CORE_PRINTER_DRIVERA {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::fmt::Debug for CORE_PRINTER_DRIVERA {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CORE_PRINTER_DRIVERA")
            .field("CoreDriverGUID", &self.CoreDriverGUID)
            .field("ftDriverDate", &self.ftDriverDate)
            .field("dwlDriverVersion", &self.dwlDriverVersion)
            .field("szPackageID", &self.szPackageID)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::cmp::PartialEq for CORE_PRINTER_DRIVERA {
    fn eq(&self, other: &Self) -> bool {
        self.CoreDriverGUID == other.CoreDriverGUID
            && self.ftDriverDate == other.ftDriverDate
            && self.dwlDriverVersion == other.dwlDriverVersion
            && self.szPackageID == other.szPackageID
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
impl ::std::cmp::Eq for CORE_PRINTER_DRIVERA {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
unsafe impl ::windows::runtime::Abi for CORE_PRINTER_DRIVERA {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct CORE_PRINTER_DRIVERW {
    pub CoreDriverGUID: ::windows::runtime::GUID,
    pub ftDriverDate: super::super::Foundation::FILETIME,
    pub dwlDriverVersion: u64,
    pub szPackageID: [u16; 260],
}
#[cfg(feature = "Win32_Foundation")]
impl CORE_PRINTER_DRIVERW {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for CORE_PRINTER_DRIVERW {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for CORE_PRINTER_DRIVERW {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CORE_PRINTER_DRIVERW")
            .field("CoreDriverGUID", &self.CoreDriverGUID)
            .field("ftDriverDate", &self.ftDriverDate)
            .field("dwlDriverVersion", &self.dwlDriverVersion)
            .field("szPackageID", &self.szPackageID)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for CORE_PRINTER_DRIVERW {
    fn eq(&self, other: &Self) -> bool {
        self.CoreDriverGUID == other.CoreDriverGUID
            && self.ftDriverDate == other.ftDriverDate
            && self.dwlDriverVersion == other.dwlDriverVersion
            && self.szPackageID == other.szPackageID
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for CORE_PRINTER_DRIVERW {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for CORE_PRINTER_DRIVERW {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CPSFUNC_ADD_HPROPSHEETPAGE: u32 = 0u32;
pub const CPSFUNC_ADD_PCOMPROPSHEETUI: u32 = 3u32;
pub const CPSFUNC_ADD_PCOMPROPSHEETUIA: u32 = 2u32;
pub const CPSFUNC_ADD_PCOMPROPSHEETUIW: u32 = 3u32;
pub const CPSFUNC_ADD_PFNPROPSHEETUI: u32 = 5u32;
pub const CPSFUNC_ADD_PFNPROPSHEETUIA: u32 = 4u32;
pub const CPSFUNC_ADD_PFNPROPSHEETUIW: u32 = 5u32;
pub const CPSFUNC_ADD_PROPSHEETPAGE: u32 = 1u32;
pub const CPSFUNC_ADD_PROPSHEETPAGEA: u32 = 15u32;
pub const CPSFUNC_ADD_PROPSHEETPAGEW: u32 = 1u32;
pub const CPSFUNC_DELETE_HCOMPROPSHEET: u32 = 6u32;
pub const CPSFUNC_DO_APPLY_CPSUI: u32 = 25u32;
pub const CPSFUNC_GET_HPSUIPAGES: u32 = 10u32;
pub const CPSFUNC_GET_PAGECOUNT: u32 = 8u32;
pub const CPSFUNC_GET_PFNPROPSHEETUI_ICON: u32 = 14u32;
pub const CPSFUNC_IGNORE_CPSUI_PSN_APPLY: u32 = 24u32;
pub const CPSFUNC_INSERT_PSUIPAGE: u32 = 17u32;
pub const CPSFUNC_INSERT_PSUIPAGEA: u32 = 16u32;
pub const CPSFUNC_INSERT_PSUIPAGEW: u32 = 17u32;
pub const CPSFUNC_LOAD_CPSUI_ICON: u32 = 13u32;
pub const CPSFUNC_LOAD_CPSUI_STRING: u32 = 12u32;
pub const CPSFUNC_LOAD_CPSUI_STRINGA: u32 = 11u32;
pub const CPSFUNC_LOAD_CPSUI_STRINGW: u32 = 12u32;
pub const CPSFUNC_QUERY_DATABLOCK: u32 = 22u32;
pub const CPSFUNC_SET_DATABLOCK: u32 = 21u32;
pub const CPSFUNC_SET_DMPUB_HIDEBITS: u32 = 23u32;
pub const CPSFUNC_SET_FUSION_CONTEXT: u32 = 26u32;
pub const CPSFUNC_SET_HSTARTPAGE: u32 = 7u32;
pub const CPSFUNC_SET_PSUIPAGE_ICON: u32 = 20u32;
pub const CPSFUNC_SET_PSUIPAGE_TITLE: u32 = 19u32;
pub const CPSFUNC_SET_PSUIPAGE_TITLEA: u32 = 18u32;
pub const CPSFUNC_SET_PSUIPAGE_TITLEW: u32 = 19u32;
pub const CPSFUNC_SET_RESULT: u32 = 9u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub struct CPSUICBPARAM {
    pub cbSize: u16,
    pub Reason: u16,
    pub hDlg: super::super::Foundation::HWND,
    pub pOptItem: *mut OPTITEM,
    pub cOptItem: u16,
    pub Flags: u16,
    pub pCurItem: *mut OPTITEM,
    pub Anonymous: CPSUICBPARAM_0,
    pub UserData: usize,
    pub Result: usize,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl CPSUICBPARAM {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for CPSUICBPARAM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for CPSUICBPARAM {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for CPSUICBPARAM {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for CPSUICBPARAM {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub union CPSUICBPARAM_0 {
    pub OldSel: i32,
    pub pOldSel: *mut i8,
}
impl CPSUICBPARAM_0 {}
impl ::std::default::Default for CPSUICBPARAM_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::cmp::PartialEq for CPSUICBPARAM_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
impl ::std::cmp::Eq for CPSUICBPARAM_0 {}
unsafe impl ::windows::runtime::Abi for CPSUICBPARAM_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CPSUICB_ACTION_ITEMS_APPLIED: u32 = 4u32;
pub const CPSUICB_ACTION_NONE: u32 = 0u32;
pub const CPSUICB_ACTION_NO_APPLY_EXIT: u32 = 3u32;
pub const CPSUICB_ACTION_OPTIF_CHANGED: u32 = 1u32;
pub const CPSUICB_ACTION_REINIT_ITEMS: u32 = 2u32;
pub const CPSUICB_REASON_ABOUT: u32 = 9u32;
pub const CPSUICB_REASON_APPLYNOW: u32 = 6u32;
pub const CPSUICB_REASON_DLGPROC: u32 = 3u32;
pub const CPSUICB_REASON_ECB_CHANGED: u32 = 2u32;
pub const CPSUICB_REASON_EXTPUSH: u32 = 5u32;
pub const CPSUICB_REASON_ITEMS_REVERTED: u32 = 8u32;
pub const CPSUICB_REASON_KILLACTIVE: u32 = 11u32;
pub const CPSUICB_REASON_OPTITEM_SETFOCUS: u32 = 7u32;
pub const CPSUICB_REASON_PUSHBUTTON: u32 = 1u32;
pub const CPSUICB_REASON_SEL_CHANGED: u32 = 0u32;
pub const CPSUICB_REASON_SETACTIVE: u32 = 10u32;
pub const CPSUICB_REASON_UNDO_CHANGES: u32 = 4u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CPSUIDATABLOCK {
    pub cbData: u32,
    pub pbData: *mut u8,
}
impl CPSUIDATABLOCK {}
impl ::std::default::Default for CPSUIDATABLOCK {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CPSUIDATABLOCK {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CPSUIDATABLOCK")
            .field("cbData", &self.cbData)
            .field("pbData", &self.pbData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CPSUIDATABLOCK {
    fn eq(&self, other: &Self) -> bool {
        self.cbData == other.cbData && self.pbData == other.pbData
    }
}
impl ::std::cmp::Eq for CPSUIDATABLOCK {}
unsafe impl ::windows::runtime::Abi for CPSUIDATABLOCK {
    type Abi = Self;
    type DefaultType = Self;
}
pub const CPSUIF_ABOUT_CALLBACK: u32 = 4u32;
pub const CPSUIF_ICONID_AS_HICON: u32 = 2u32;
pub const CPSUIF_UPDATE_PERMISSION: u32 = 1u32;
pub const CPSUI_CANCEL: u32 = 0u32;
pub const CPSUI_OK: u32 = 1u32;
pub const CPSUI_REBOOTSYSTEM: u32 = 3u32;
pub const CPSUI_RESTARTWINDOWS: u32 = 2u32;
pub const CUSTOMPARAM_HEIGHT: u32 = 1u32;
pub const CUSTOMPARAM_HEIGHTOFFSET: u32 = 3u32;
pub const CUSTOMPARAM_MAX: u32 = 5u32;
pub const CUSTOMPARAM_ORIENTATION: u32 = 4u32;
pub const CUSTOMPARAM_WIDTH: u32 = 0u32;
pub const CUSTOMPARAM_WIDTHOFFSET: u32 = 2u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct CUSTOMSIZEPARAM {
    pub dwOrder: i32,
    pub lMinVal: i32,
    pub lMaxVal: i32,
}
impl CUSTOMSIZEPARAM {}
impl ::std::default::Default for CUSTOMSIZEPARAM {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for CUSTOMSIZEPARAM {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("CUSTOMSIZEPARAM")
            .field("dwOrder", &self.dwOrder)
            .field("lMinVal", &self.lMinVal)
            .field("lMaxVal", &self.lMaxVal)
            .finish()
    }
}
impl ::std::cmp::PartialEq for CUSTOMSIZEPARAM {
    fn eq(&self, other: &Self) -> bool {
        self.dwOrder == other.dwOrder
            && self.lMinVal == other.lMinVal
            && self.lMaxVal == other.lMaxVal
    }
}
impl ::std::cmp::Eq for CUSTOMSIZEPARAM {}
unsafe impl ::windows::runtime::Abi for CUSTOMSIZEPARAM {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CallRouterFindFirstPrinterChangeNotification<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinterrpc: Param0,
    fdwfilterflags: u32,
    fdwoptions: u32,
    hnotify: Param3,
    pprinternotifyoptions: *const PRINTER_NOTIFY_OPTIONS,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "spoolss")]
        extern "system" {
            fn CallRouterFindFirstPrinterChangeNotification(
                hprinterrpc: super::super::Foundation::HANDLE,
                fdwfilterflags: u32,
                fdwoptions: u32,
                hnotify: super::super::Foundation::HANDLE,
                pprinternotifyoptions: *const PRINTER_NOTIFY_OPTIONS,
            ) -> u32;
        }
        ::std::mem::transmute(CallRouterFindFirstPrinterChangeNotification(
            hprinterrpc.into_param().abi(),
            ::std::mem::transmute(fdwfilterflags),
            ::std::mem::transmute(fdwoptions),
            hnotify.into_param().abi(),
            ::std::mem::transmute(pprinternotifyoptions),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ClosePrinter<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn ClosePrinter(
                hprinter: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(ClosePrinter(hprinter.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CloseSpoolFileHandle<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    hspoolfile: Param1,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn CloseSpoolFileHandle(
                hprinter: super::super::Foundation::HANDLE,
                hspoolfile: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(CloseSpoolFileHandle(
            hprinter.into_param().abi(),
            hspoolfile.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CommitSpoolData<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    hspoolfile: Param1,
    cbcommit: u32,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn CommitSpoolData(
                hprinter: super::super::Foundation::HANDLE,
                hspoolfile: super::super::Foundation::HANDLE,
                cbcommit: u32,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(CommitSpoolData(
            hprinter.into_param().abi(),
            hspoolfile.into_param().abi(),
            ::std::mem::transmute(cbcommit),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CommonPropertySheetUIA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
>(
    hwndowner: Param0,
    pfnpropsheetui: ::std::option::Option<PFNPROPSHEETUI>,
    lparam: Param2,
    presult: *mut u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "compstui")]
        extern "system" {
            fn CommonPropertySheetUIA(
                hwndowner: super::super::Foundation::HWND,
                pfnpropsheetui: ::windows::runtime::RawPtr,
                lparam: super::super::Foundation::LPARAM,
                presult: *mut u32,
            ) -> i32;
        }
        ::std::mem::transmute(CommonPropertySheetUIA(
            hwndowner.into_param().abi(),
            ::std::mem::transmute(pfnpropsheetui),
            lparam.into_param().abi(),
            ::std::mem::transmute(presult),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CommonPropertySheetUIW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
>(
    hwndowner: Param0,
    pfnpropsheetui: ::std::option::Option<PFNPROPSHEETUI>,
    lparam: Param2,
    presult: *mut u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "compstui")]
        extern "system" {
            fn CommonPropertySheetUIW(
                hwndowner: super::super::Foundation::HWND,
                pfnpropsheetui: ::windows::runtime::RawPtr,
                lparam: super::super::Foundation::LPARAM,
                presult: *mut u32,
            ) -> i32;
        }
        ::std::mem::transmute(CommonPropertySheetUIW(
            hwndowner.into_param().abi(),
            ::std::mem::transmute(pfnpropsheetui),
            lparam.into_param().abi(),
            ::std::mem::transmute(presult),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ConfigurePortA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    hwnd: Param1,
    pportname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn ConfigurePortA(
                pname: super::super::Foundation::PSTR,
                hwnd: super::super::Foundation::HWND,
                pportname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(ConfigurePortA(
            pname.into_param().abi(),
            hwnd.into_param().abi(),
            pportname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ConfigurePortW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    hwnd: Param1,
    pportname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn ConfigurePortW(
                pname: super::super::Foundation::PWSTR,
                hwnd: super::super::Foundation::HWND,
                pportname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(ConfigurePortW(
            pname.into_param().abi(),
            hwnd.into_param().abi(),
            pportname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn ConnectToPrinterDlg<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hwnd: Param0,
    flags: u32,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn ConnectToPrinterDlg(
                hwnd: super::super::Foundation::HWND,
                flags: u32,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(ConnectToPrinterDlg(
            hwnd.into_param().abi(),
            ::std::mem::transmute(flags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CorePrinterDriverInstalledA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::FILETIME>,
>(
    pszserver: Param0,
    pszenvironment: Param1,
    coredriverguid: Param2,
    ftdriverdate: Param3,
    dwldriverversion: u64,
) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn CorePrinterDriverInstalledA(
                pszserver: super::super::Foundation::PSTR,
                pszenvironment: super::super::Foundation::PSTR,
                coredriverguid: ::windows::runtime::GUID,
                ftdriverdate: super::super::Foundation::FILETIME,
                dwldriverversion: u64,
                pbdriverinstalled: *mut super::super::Foundation::BOOL,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        CorePrinterDriverInstalledA(
            pszserver.into_param().abi(),
            pszenvironment.into_param().abi(),
            coredriverguid.into_param().abi(),
            ftdriverdate.into_param().abi(),
            ::std::mem::transmute(dwldriverversion),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CorePrinterDriverInstalledW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::FILETIME>,
>(
    pszserver: Param0,
    pszenvironment: Param1,
    coredriverguid: Param2,
    ftdriverdate: Param3,
    dwldriverversion: u64,
) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn CorePrinterDriverInstalledW(
                pszserver: super::super::Foundation::PWSTR,
                pszenvironment: super::super::Foundation::PWSTR,
                coredriverguid: ::windows::runtime::GUID,
                ftdriverdate: super::super::Foundation::FILETIME,
                dwldriverversion: u64,
                pbdriverinstalled: *mut super::super::Foundation::BOOL,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        CorePrinterDriverInstalledW(
            pszserver.into_param().abi(),
            pszenvironment.into_param().abi(),
            coredriverguid.into_param().abi(),
            ftdriverdate.into_param().abi(),
            ::std::mem::transmute(dwldriverversion),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn CreatePrintAsyncNotifyChannel<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyCallback>,
>(
    pszname: Param0,
    pnotificationtype: *const ::windows::runtime::GUID,
    euserfilter: PrintAsyncNotifyUserFilter,
    econversationstyle: PrintAsyncNotifyConversationStyle,
    pcallback: Param4,
) -> ::windows::runtime::Result<IPrintAsyncNotifyChannel> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn CreatePrintAsyncNotifyChannel(
                pszname: super::super::Foundation::PWSTR,
                pnotificationtype: *const ::windows::runtime::GUID,
                euserfilter: PrintAsyncNotifyUserFilter,
                econversationstyle: PrintAsyncNotifyConversationStyle,
                pcallback: ::windows::runtime::RawPtr,
                ppiasynchnotification: *mut ::windows::runtime::RawPtr,
            ) -> ::windows::runtime::HRESULT;
        }
        let mut result__: <IPrintAsyncNotifyChannel as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        CreatePrintAsyncNotifyChannel(
            pszname.into_param().abi(),
            ::std::mem::transmute(pnotificationtype),
            ::std::mem::transmute(euserfilter),
            ::std::mem::transmute(econversationstyle),
            pcallback.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintAsyncNotifyChannel>(result__)
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn CreatePrinterIC<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    pdevmode: *const super::super::UI::DisplayDevices::DEVMODEW,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn CreatePrinterIC(
                hprinter: super::super::Foundation::HANDLE,
                pdevmode: *const super::super::UI::DisplayDevices::DEVMODEW,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(CreatePrinterIC(
            hprinter.into_param().abi(),
            ::std::mem::transmute(pdevmode),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DATATYPES_INFO_1A {
    pub pName: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DATATYPES_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DATATYPES_INFO_1A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DATATYPES_INFO_1A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DATATYPES_INFO_1A")
            .field("pName", &self.pName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DATATYPES_INFO_1A {
    fn eq(&self, other: &Self) -> bool {
        self.pName == other.pName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DATATYPES_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DATATYPES_INFO_1A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DATATYPES_INFO_1W {
    pub pName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DATATYPES_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DATATYPES_INFO_1W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DATATYPES_INFO_1W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DATATYPES_INFO_1W")
            .field("pName", &self.pName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DATATYPES_INFO_1W {
    fn eq(&self, other: &Self) -> bool {
        self.pName == other.pName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DATATYPES_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DATATYPES_INFO_1W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DATA_HEADER {
    pub dwSignature: u32,
    pub wSize: u16,
    pub wDataID: u16,
    pub dwDataSize: u32,
    pub dwReserved: u32,
}
impl DATA_HEADER {}
impl ::std::default::Default for DATA_HEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DATA_HEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DATA_HEADER")
            .field("dwSignature", &self.dwSignature)
            .field("wSize", &self.wSize)
            .field("wDataID", &self.wDataID)
            .field("dwDataSize", &self.dwDataSize)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DATA_HEADER {
    fn eq(&self, other: &Self) -> bool {
        self.dwSignature == other.dwSignature
            && self.wSize == other.wSize
            && self.wDataID == other.wDataID
            && self.dwDataSize == other.dwDataSize
            && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for DATA_HEADER {}
unsafe impl ::windows::runtime::Abi for DATA_HEADER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DEF_PRIORITY: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DELETE_PORT_DATA_1 {
    pub psztPortName: [u16; 64],
    pub Reserved: [u8; 98],
    pub dwVersion: u32,
    pub dwReserved: u32,
}
impl DELETE_PORT_DATA_1 {}
impl ::std::default::Default for DELETE_PORT_DATA_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DELETE_PORT_DATA_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DELETE_PORT_DATA_1")
            .field("psztPortName", &self.psztPortName)
            .field("Reserved", &self.Reserved)
            .field("dwVersion", &self.dwVersion)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DELETE_PORT_DATA_1 {
    fn eq(&self, other: &Self) -> bool {
        self.psztPortName == other.psztPortName
            && self.Reserved == other.Reserved
            && self.dwVersion == other.dwVersion
            && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for DELETE_PORT_DATA_1 {}
unsafe impl ::windows::runtime::Abi for DELETE_PORT_DATA_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DEVICEPROPERTYHEADER {
    pub cbSize: u16,
    pub Flags: u16,
    pub hPrinter: super::super::Foundation::HANDLE,
    pub pszPrinterName: *mut i8,
}
#[cfg(feature = "Win32_Foundation")]
impl DEVICEPROPERTYHEADER {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DEVICEPROPERTYHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DEVICEPROPERTYHEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVICEPROPERTYHEADER")
            .field("cbSize", &self.cbSize)
            .field("Flags", &self.Flags)
            .field("hPrinter", &self.hPrinter)
            .field("pszPrinterName", &self.pszPrinterName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DEVICEPROPERTYHEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.Flags == other.Flags
            && self.hPrinter == other.hPrinter
            && self.pszPrinterName == other.pszPrinterName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DEVICEPROPERTYHEADER {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DEVICEPROPERTYHEADER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub struct DEVQUERYPRINT_INFO {
    pub cbSize: u16,
    pub Level: u16,
    pub hPrinter: super::super::Foundation::HANDLE,
    pub pDevMode: *mut super::super::UI::DisplayDevices::DEVMODEA,
    pub pszErrorStr: super::super::Foundation::PWSTR,
    pub cchErrorStr: u32,
    pub cchNeeded: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl DEVQUERYPRINT_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for DEVQUERYPRINT_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for DEVQUERYPRINT_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DEVQUERYPRINT_INFO")
            .field("cbSize", &self.cbSize)
            .field("Level", &self.Level)
            .field("hPrinter", &self.hPrinter)
            .field("pDevMode", &self.pDevMode)
            .field("pszErrorStr", &self.pszErrorStr)
            .field("cchErrorStr", &self.cchErrorStr)
            .field("cchNeeded", &self.cchNeeded)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for DEVQUERYPRINT_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.Level == other.Level
            && self.hPrinter == other.hPrinter
            && self.pDevMode == other.pDevMode
            && self.pszErrorStr == other.pszErrorStr
            && self.cchErrorStr == other.cchErrorStr
            && self.cchNeeded == other.cchNeeded
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for DEVQUERYPRINT_INFO {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for DEVQUERYPRINT_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DF_BKSP_OK: u32 = 64u32;
pub const DF_NOITALIC: u32 = 1u32;
pub const DF_NOUNDER: u32 = 2u32;
pub const DF_NO_BOLD: u32 = 8u32;
pub const DF_NO_DOUBLE_UNDERLINE: u32 = 16u32;
pub const DF_NO_STRIKETHRU: u32 = 32u32;
pub const DF_TYPE_CAPSL: u32 = 3u32;
pub const DF_TYPE_HPINTELLIFONT: u32 = 0u32;
pub const DF_TYPE_OEM1: u32 = 4u32;
pub const DF_TYPE_OEM2: u32 = 5u32;
pub const DF_TYPE_PST1: u32 = 2u32;
pub const DF_TYPE_TRUETYPE: u32 = 1u32;
pub const DF_XM_CR: u32 = 4u32;
pub const DISPID_PRINTEREXTENSION_CONTEXT: u32 = 11800u32;
pub const DISPID_PRINTEREXTENSION_CONTEXTCOLLECTION: u32 = 12100u32;
pub const DISPID_PRINTEREXTENSION_CONTEXTCOLLECTION_COUNT: u32 = 12101u32;
pub const DISPID_PRINTEREXTENSION_CONTEXTCOLLECTION_GETAT: u32 = 12102u32;
pub const DISPID_PRINTEREXTENSION_CONTEXT_DRIVERPROPERTIES: u32 = 11803u32;
pub const DISPID_PRINTEREXTENSION_CONTEXT_PRINTERQUEUE: u32 = 11801u32;
pub const DISPID_PRINTEREXTENSION_CONTEXT_PRINTSCHEMATICKET: u32 = 11802u32;
pub const DISPID_PRINTEREXTENSION_CONTEXT_USERPROPERTIES: u32 = 11804u32;
pub const DISPID_PRINTEREXTENSION_EVENT: u32 = 12200u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS: u32 = 12000u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS_BIDINOTIFICATION: u32 = 12001u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS_DETAILEDREASONID: u32 = 12005u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS_REASONID: u32 = 12002u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS_REQUEST: u32 = 12003u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS_SOURCEAPPLICATION: u32 = 12004u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS_WINDOWMODAL: u32 = 12006u32;
pub const DISPID_PRINTEREXTENSION_EVENTARGS_WINDOWPARENT: u32 = 12007u32;
pub const DISPID_PRINTEREXTENSION_EVENT_ONDRIVEREVENT: u32 = 12201u32;
pub const DISPID_PRINTEREXTENSION_EVENT_ONPRINTERQUEUESENUMERATED: u32 = 12202u32;
pub const DISPID_PRINTEREXTENSION_REQUEST: u32 = 11900u32;
pub const DISPID_PRINTEREXTENSION_REQUEST_CANCEL: u32 = 11901u32;
pub const DISPID_PRINTEREXTENSION_REQUEST_COMPLETE: u32 = 11902u32;
pub const DISPID_PRINTERPROPERTYBAG: u32 = 11400u32;
pub const DISPID_PRINTERPROPERTYBAG_GETBOOL: u32 = 11401u32;
pub const DISPID_PRINTERPROPERTYBAG_GETBYTES: u32 = 11407u32;
pub const DISPID_PRINTERPROPERTYBAG_GETINT32: u32 = 11403u32;
pub const DISPID_PRINTERPROPERTYBAG_GETREADSTREAM: u32 = 11409u32;
pub const DISPID_PRINTERPROPERTYBAG_GETSTRING: u32 = 11405u32;
pub const DISPID_PRINTERPROPERTYBAG_GETWRITESTREAM: u32 = 11410u32;
pub const DISPID_PRINTERPROPERTYBAG_SETBOOL: u32 = 11402u32;
pub const DISPID_PRINTERPROPERTYBAG_SETBYTES: u32 = 11408u32;
pub const DISPID_PRINTERPROPERTYBAG_SETINT32: u32 = 11404u32;
pub const DISPID_PRINTERPROPERTYBAG_SETSTRING: u32 = 11406u32;
pub const DISPID_PRINTERQUEUE: u32 = 11600u32;
pub const DISPID_PRINTERQUEUEEVENT: u32 = 11700u32;
pub const DISPID_PRINTERQUEUEEVENT_ONBIDIRESPONSERECEIVED: u32 = 11701u32;
pub const DISPID_PRINTERQUEUEVIEW: u32 = 12700u32;
pub const DISPID_PRINTERQUEUEVIEW_EVENT: u32 = 12800u32;
pub const DISPID_PRINTERQUEUEVIEW_EVENT_ONCHANGED: u32 = 12801u32;
pub const DISPID_PRINTERQUEUEVIEW_SETVIEWRANGE: u32 = 12701u32;
pub const DISPID_PRINTERQUEUE_GETPRINTERQUEUEVIEW: u32 = 11606u32;
pub const DISPID_PRINTERQUEUE_GETPROPERTIES: u32 = 11604u32;
pub const DISPID_PRINTERQUEUE_HANDLE: u32 = 11601u32;
pub const DISPID_PRINTERQUEUE_NAME: u32 = 11602u32;
pub const DISPID_PRINTERQUEUE_SENDBIDIQUERY: u32 = 11603u32;
pub const DISPID_PRINTERQUEUE_SENDBIDISETREQUESTASYNC: u32 = 11605u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG: u32 = 11500u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_GETBOOL: u32 = 11501u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_GETBYTES: u32 = 11507u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_GETINT32: u32 = 11503u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_GETREADSTREAM: u32 = 11509u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_GETSTREAMASXML: u32 = 11411u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_GETSTRING: u32 = 11505u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_GETWRITESTREAM: u32 = 11510u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_SETBOOL: u32 = 11502u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_SETBYTES: u32 = 11508u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_SETINT32: u32 = 11504u32;
pub const DISPID_PRINTERSCRIPTABLEPROPERTYBAG_SETSTRING: u32 = 11506u32;
pub const DISPID_PRINTERSCRIPTABLESEQUENTIALSTREAM: u32 = 11200u32;
pub const DISPID_PRINTERSCRIPTABLESEQUENTIALSTREAM_READ: u32 = 11201u32;
pub const DISPID_PRINTERSCRIPTABLESEQUENTIALSTREAM_WRITE: u32 = 11202u32;
pub const DISPID_PRINTERSCRIPTABLESTREAM: u32 = 11300u32;
pub const DISPID_PRINTERSCRIPTABLESTREAM_COMMIT: u32 = 11301u32;
pub const DISPID_PRINTERSCRIPTABLESTREAM_SEEK: u32 = 11302u32;
pub const DISPID_PRINTERSCRIPTABLESTREAM_SETSIZE: u32 = 11303u32;
pub const DISPID_PRINTERSCRIPTCONTEXT: u32 = 12300u32;
pub const DISPID_PRINTERSCRIPTCONTEXT_DRIVERPROPERTIES: u32 = 12301u32;
pub const DISPID_PRINTERSCRIPTCONTEXT_QUEUEPROPERTIES: u32 = 12302u32;
pub const DISPID_PRINTERSCRIPTCONTEXT_USERPROPERTIES: u32 = 12303u32;
pub const DISPID_PRINTJOBCOLLECTION: u32 = 12600u32;
pub const DISPID_PRINTJOBCOLLECTION_COUNT: u32 = 12601u32;
pub const DISPID_PRINTJOBCOLLECTION_GETAT: u32 = 12602u32;
pub const DISPID_PRINTSCHEMA_ASYNCOPERATION: u32 = 10900u32;
pub const DISPID_PRINTSCHEMA_ASYNCOPERATIONEVENT: u32 = 11100u32;
pub const DISPID_PRINTSCHEMA_ASYNCOPERATIONEVENT_COMPLETED: u32 = 11101u32;
pub const DISPID_PRINTSCHEMA_ASYNCOPERATION_CANCEL: u32 = 10902u32;
pub const DISPID_PRINTSCHEMA_ASYNCOPERATION_START: u32 = 10901u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES: u32 = 10800u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_GETFEATURE: u32 = 10802u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_GETFEATURE_KEYNAME: u32 = 10801u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_GETOPTIONS: u32 = 10807u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_GETPARAMETERDEFINITION: u32 = 10808u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_GETSELECTEDOPTION: u32 = 10806u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_JOBCOPIESMAXVALUE: u32 = 10805u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_JOBCOPIESMINVALUE: u32 = 10804u32;
pub const DISPID_PRINTSCHEMA_CAPABILITIES_PAGEIMAGEABLESIZE: u32 = 10803u32;
pub const DISPID_PRINTSCHEMA_DISPLAYABLEELEMENT: u32 = 10100u32;
pub const DISPID_PRINTSCHEMA_DISPLAYABLEELEMENT_DISPLAYNAME: u32 = 10101u32;
pub const DISPID_PRINTSCHEMA_ELEMENT: u32 = 10000u32;
pub const DISPID_PRINTSCHEMA_ELEMENT_NAME: u32 = 10002u32;
pub const DISPID_PRINTSCHEMA_ELEMENT_NAMESPACEURI: u32 = 10003u32;
pub const DISPID_PRINTSCHEMA_ELEMENT_XMLNODE: u32 = 10001u32;
pub const DISPID_PRINTSCHEMA_FEATURE: u32 = 10600u32;
pub const DISPID_PRINTSCHEMA_FEATURE_DISPLAYUI: u32 = 10604u32;
pub const DISPID_PRINTSCHEMA_FEATURE_GETOPTION: u32 = 10603u32;
pub const DISPID_PRINTSCHEMA_FEATURE_SELECTEDOPTION: u32 = 10601u32;
pub const DISPID_PRINTSCHEMA_FEATURE_SELECTIONTYPE: u32 = 10602u32;
pub const DISPID_PRINTSCHEMA_NUPOPTION: u32 = 10400u32;
pub const DISPID_PRINTSCHEMA_NUPOPTION_PAGESPERSHEET: u32 = 10401u32;
pub const DISPID_PRINTSCHEMA_OPTION: u32 = 10200u32;
pub const DISPID_PRINTSCHEMA_OPTIONCOLLECTION: u32 = 10500u32;
pub const DISPID_PRINTSCHEMA_OPTIONCOLLECTION_COUNT: u32 = 10501u32;
pub const DISPID_PRINTSCHEMA_OPTIONCOLLECTION_GETAT: u32 = 10502u32;
pub const DISPID_PRINTSCHEMA_OPTION_CONSTRAINED: u32 = 10202u32;
pub const DISPID_PRINTSCHEMA_OPTION_GETPROPERTYVALUE: u32 = 10203u32;
pub const DISPID_PRINTSCHEMA_OPTION_SELECTED: u32 = 10201u32;
pub const DISPID_PRINTSCHEMA_PAGEIMAGEABLESIZE: u32 = 10700u32;
pub const DISPID_PRINTSCHEMA_PAGEIMAGEABLESIZE_EXTENT_HEIGHT: u32 = 10706u32;
pub const DISPID_PRINTSCHEMA_PAGEIMAGEABLESIZE_EXTENT_WIDTH: u32 = 10705u32;
pub const DISPID_PRINTSCHEMA_PAGEIMAGEABLESIZE_IMAGEABLE_HEIGHT: u32 = 10702u32;
pub const DISPID_PRINTSCHEMA_PAGEIMAGEABLESIZE_IMAGEABLE_WIDTH: u32 = 10701u32;
pub const DISPID_PRINTSCHEMA_PAGEIMAGEABLESIZE_ORIGIN_HEIGHT: u32 = 10704u32;
pub const DISPID_PRINTSCHEMA_PAGEIMAGEABLESIZE_ORIGIN_WIDTH: u32 = 10703u32;
pub const DISPID_PRINTSCHEMA_PAGEMEDIASIZEOPTION: u32 = 10300u32;
pub const DISPID_PRINTSCHEMA_PAGEMEDIASIZEOPTION_HEIGHT: u32 = 10302u32;
pub const DISPID_PRINTSCHEMA_PAGEMEDIASIZEOPTION_WIDTH: u32 = 10301u32;
pub const DISPID_PRINTSCHEMA_PARAMETERDEFINITION: u32 = 12500u32;
pub const DISPID_PRINTSCHEMA_PARAMETERDEFINITION_DATATYPE: u32 = 12503u32;
pub const DISPID_PRINTSCHEMA_PARAMETERDEFINITION_RANGEMAX: u32 = 12505u32;
pub const DISPID_PRINTSCHEMA_PARAMETERDEFINITION_RANGEMIN: u32 = 12504u32;
pub const DISPID_PRINTSCHEMA_PARAMETERDEFINITION_UNITTYPE: u32 = 12502u32;
pub const DISPID_PRINTSCHEMA_PARAMETERDEFINITION_USERINPUTREQUIRED: u32 = 12501u32;
pub const DISPID_PRINTSCHEMA_PARAMETERINITIALIZER: u32 = 12400u32;
pub const DISPID_PRINTSCHEMA_PARAMETERINITIALIZER_VALUE: u32 = 12401u32;
pub const DISPID_PRINTSCHEMA_TICKET: u32 = 11000u32;
pub const DISPID_PRINTSCHEMA_TICKET_COMMITASYNC: u32 = 11004u32;
pub const DISPID_PRINTSCHEMA_TICKET_GETCAPABILITIES: u32 = 11006u32;
pub const DISPID_PRINTSCHEMA_TICKET_GETFEATURE: u32 = 11002u32;
pub const DISPID_PRINTSCHEMA_TICKET_GETFEATURE_KEYNAME: u32 = 11001u32;
pub const DISPID_PRINTSCHEMA_TICKET_GETPARAMETERINITIALIZER: u32 = 11008u32;
pub const DISPID_PRINTSCHEMA_TICKET_JOBCOPIESALLDOCUMENTS: u32 = 11007u32;
pub const DISPID_PRINTSCHEMA_TICKET_NOTIFYXMLCHANGED: u32 = 11005u32;
pub const DISPID_PRINTSCHEMA_TICKET_VALIDATEASYNC: u32 = 11003u32;
pub const DI_CHANNEL: u32 = 1u32;
pub const DI_MEMORYMAP_WRITE: u32 = 1u32;
pub const DI_READ_SPOOL_JOB: u32 = 3u32;
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::clone::Clone for DLGPAGE {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub struct DLGPAGE {
    pub cbSize: u16,
    pub Flags: u16,
    pub DlgProc: ::std::option::Option<super::super::UI::WindowsAndMessaging::DLGPROC>,
    pub pTabName: *mut i8,
    pub IconID: usize,
    pub Anonymous: DLGPAGE_0,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl DLGPAGE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for DLGPAGE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for DLGPAGE {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for DLGPAGE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for DLGPAGE {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union DLGPAGE_0 {
    pub DlgTemplateID: u16,
    pub hDlgTemplate: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl DLGPAGE_0 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DLGPAGE_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DLGPAGE_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DLGPAGE_0 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DLGPAGE_0 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DMPUB_BOOKLET_EDGE: u32 = 21u32;
pub const DMPUB_COLOR: u32 = 6u32;
pub const DMPUB_COPIES_COLLATE: u32 = 3u32;
pub const DMPUB_DEFSOURCE: u32 = 4u32;
pub const DMPUB_DITHERTYPE: u32 = 13u32;
pub const DMPUB_DUPLEX: u32 = 7u32;
pub const DMPUB_FIRST: u32 = 1u32;
pub const DMPUB_FORMNAME: u32 = 9u32;
pub const DMPUB_ICMINTENT: u32 = 11u32;
pub const DMPUB_ICMMETHOD: u32 = 10u32;
pub const DMPUB_LAST: u32 = 21u32;
pub const DMPUB_MANUAL_DUPLEX: u32 = 19u32;
pub const DMPUB_MEDIATYPE: u32 = 12u32;
pub const DMPUB_NONE: u32 = 0u32;
pub const DMPUB_NUP: u32 = 16u32;
pub const DMPUB_NUP_DIRECTION: u32 = 18u32;
pub const DMPUB_OEM_GRAPHIC_ITEM: u32 = 98u32;
pub const DMPUB_OEM_PAPER_ITEM: u32 = 97u32;
pub const DMPUB_OEM_ROOT_ITEM: u32 = 99u32;
pub const DMPUB_ORIENTATION: u32 = 1u32;
pub const DMPUB_OUTPUTBIN: u32 = 14u32;
pub const DMPUB_PAGEORDER: u32 = 17u32;
pub const DMPUB_PRINTQUALITY: u32 = 5u32;
pub const DMPUB_QUALITY: u32 = 15u32;
pub const DMPUB_SCALE: u32 = 2u32;
pub const DMPUB_STAPLE: u32 = 20u32;
pub const DMPUB_TTOPTION: u32 = 8u32;
pub const DMPUB_USER: u32 = 100u32;
pub const DM_ADVANCED: u32 = 16u32;
pub const DM_INVALIDATE_DRIVER_CACHE: u32 = 536870912u32;
pub const DM_NOPERMISSION: u32 = 32u32;
pub const DM_PROMPT_NON_MODAL: u32 = 1073741824u32;
pub const DM_RESERVED: u32 = 2147483648u32;
pub const DM_USER_DEFAULT: u32 = 64u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub struct DOCEVENT_CREATEDCPRE {
    pub pszDriver: super::super::Foundation::PWSTR,
    pub pszDevice: super::super::Foundation::PWSTR,
    pub pdm: *mut super::super::UI::DisplayDevices::DEVMODEW,
    pub bIC: super::super::Foundation::BOOL,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl DOCEVENT_CREATEDCPRE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for DOCEVENT_CREATEDCPRE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for DOCEVENT_CREATEDCPRE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOCEVENT_CREATEDCPRE")
            .field("pszDriver", &self.pszDriver)
            .field("pszDevice", &self.pszDevice)
            .field("pdm", &self.pdm)
            .field("bIC", &self.bIC)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for DOCEVENT_CREATEDCPRE {
    fn eq(&self, other: &Self) -> bool {
        self.pszDriver == other.pszDriver
            && self.pszDevice == other.pszDevice
            && self.pdm == other.pdm
            && self.bIC == other.bIC
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for DOCEVENT_CREATEDCPRE {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for DOCEVENT_CREATEDCPRE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DOCEVENT_ESCAPE {
    pub iEscape: i32,
    pub cjInput: i32,
    pub pvInData: *mut ::std::ffi::c_void,
}
impl DOCEVENT_ESCAPE {}
impl ::std::default::Default for DOCEVENT_ESCAPE {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DOCEVENT_ESCAPE {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOCEVENT_ESCAPE")
            .field("iEscape", &self.iEscape)
            .field("cjInput", &self.cjInput)
            .field("pvInData", &self.pvInData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DOCEVENT_ESCAPE {
    fn eq(&self, other: &Self) -> bool {
        self.iEscape == other.iEscape
            && self.cjInput == other.cjInput
            && self.pvInData == other.pvInData
    }
}
impl ::std::cmp::Eq for DOCEVENT_ESCAPE {}
unsafe impl ::windows::runtime::Abi for DOCEVENT_ESCAPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DOCEVENT_FILTER {
    pub cbSize: u32,
    pub cElementsAllocated: u32,
    pub cElementsNeeded: u32,
    pub cElementsReturned: u32,
    pub aDocEventCall: [u32; 1],
}
impl DOCEVENT_FILTER {}
impl ::std::default::Default for DOCEVENT_FILTER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DOCEVENT_FILTER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOCEVENT_FILTER")
            .field("cbSize", &self.cbSize)
            .field("cElementsAllocated", &self.cElementsAllocated)
            .field("cElementsNeeded", &self.cElementsNeeded)
            .field("cElementsReturned", &self.cElementsReturned)
            .field("aDocEventCall", &self.aDocEventCall)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DOCEVENT_FILTER {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.cElementsAllocated == other.cElementsAllocated
            && self.cElementsNeeded == other.cElementsNeeded
            && self.cElementsReturned == other.cElementsReturned
            && self.aDocEventCall == other.aDocEventCall
    }
}
impl ::std::cmp::Eq for DOCEVENT_FILTER {}
unsafe impl ::windows::runtime::Abi for DOCEVENT_FILTER {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DOCUMENTEVENT_ABORTDOC: u32 = 9u32;
pub const DOCUMENTEVENT_CREATEDCPOST: u32 = 2u32;
pub const DOCUMENTEVENT_CREATEDCPRE: u32 = 1u32;
pub const DOCUMENTEVENT_DELETEDC: u32 = 10u32;
pub const DOCUMENTEVENT_ENDDOC: u32 = 8u32;
pub const DOCUMENTEVENT_ENDDOCPOST: u32 = 12u32;
pub const DOCUMENTEVENT_ENDDOCPRE: u32 = 8u32;
pub const DOCUMENTEVENT_ENDPAGE: u32 = 7u32;
pub const DOCUMENTEVENT_ESCAPE: u32 = 11u32;
pub const DOCUMENTEVENT_FAILURE: i32 = -1i32;
pub const DOCUMENTEVENT_FIRST: u32 = 1u32;
pub const DOCUMENTEVENT_LAST: u32 = 15u32;
pub const DOCUMENTEVENT_QUERYFILTER: u32 = 14u32;
pub const DOCUMENTEVENT_RESETDCPOST: u32 = 4u32;
pub const DOCUMENTEVENT_RESETDCPRE: u32 = 3u32;
pub const DOCUMENTEVENT_SPOOLED: u32 = 65536u32;
pub const DOCUMENTEVENT_STARTDOC: u32 = 5u32;
pub const DOCUMENTEVENT_STARTDOCPOST: u32 = 13u32;
pub const DOCUMENTEVENT_STARTDOCPRE: u32 = 5u32;
pub const DOCUMENTEVENT_STARTPAGE: u32 = 6u32;
pub const DOCUMENTEVENT_SUCCESS: u32 = 1u32;
pub const DOCUMENTEVENT_UNSUPPORTED: u32 = 0u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTPOST: u32 = 5u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTPRE: u32 = 2u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTPRINTTICKETPOST: u32 = 11u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTPRINTTICKETPRE: u32 = 8u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTSEQUENCEPOST: u32 = 13u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTSEQUENCEPRE: u32 = 1u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTSEQUENCEPRINTTICKETPOST: u32 = 12u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDDOCUMENTSEQUENCEPRINTTICKETPRE: u32 = 7u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDPAGEEPRE: u32 = 3u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDPAGEPOST: u32 = 4u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDPAGEPRINTTICKETPOST: u32 = 10u32;
pub const DOCUMENTEVENT_XPS_ADDFIXEDPAGEPRINTTICKETPRE: u32 = 9u32;
pub const DOCUMENTEVENT_XPS_CANCELJOB: u32 = 6u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub struct DOCUMENTPROPERTYHEADER {
    pub cbSize: u16,
    pub Reserved: u16,
    pub hPrinter: super::super::Foundation::HANDLE,
    pub pszPrinterName: *mut i8,
    pub pdmIn: *mut super::super::UI::DisplayDevices::DEVMODEA,
    pub pdmOut: *mut super::super::UI::DisplayDevices::DEVMODEA,
    pub cbOut: u32,
    pub fMode: u32,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl DOCUMENTPROPERTYHEADER {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::default::Default for DOCUMENTPROPERTYHEADER {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::fmt::Debug for DOCUMENTPROPERTYHEADER {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOCUMENTPROPERTYHEADER")
            .field("cbSize", &self.cbSize)
            .field("Reserved", &self.Reserved)
            .field("hPrinter", &self.hPrinter)
            .field("pszPrinterName", &self.pszPrinterName)
            .field("pdmIn", &self.pdmIn)
            .field("pdmOut", &self.pdmOut)
            .field("cbOut", &self.cbOut)
            .field("fMode", &self.fMode)
            .finish()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::PartialEq for DOCUMENTPROPERTYHEADER {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.Reserved == other.Reserved
            && self.hPrinter == other.hPrinter
            && self.pszPrinterName == other.pszPrinterName
            && self.pdmIn == other.pdmIn
            && self.pdmOut == other.pdmOut
            && self.cbOut == other.cbOut
            && self.fMode == other.fMode
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
impl ::std::cmp::Eq for DOCUMENTPROPERTYHEADER {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
unsafe impl ::windows::runtime::Abi for DOCUMENTPROPERTYHEADER {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DOC_INFO_1A {
    pub pDocName: super::super::Foundation::PSTR,
    pub pOutputFile: super::super::Foundation::PSTR,
    pub pDatatype: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DOC_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DOC_INFO_1A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DOC_INFO_1A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOC_INFO_1A")
            .field("pDocName", &self.pDocName)
            .field("pOutputFile", &self.pOutputFile)
            .field("pDatatype", &self.pDatatype)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DOC_INFO_1A {
    fn eq(&self, other: &Self) -> bool {
        self.pDocName == other.pDocName
            && self.pOutputFile == other.pOutputFile
            && self.pDatatype == other.pDatatype
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DOC_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DOC_INFO_1A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DOC_INFO_1W {
    pub pDocName: super::super::Foundation::PWSTR,
    pub pOutputFile: super::super::Foundation::PWSTR,
    pub pDatatype: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DOC_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DOC_INFO_1W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DOC_INFO_1W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOC_INFO_1W")
            .field("pDocName", &self.pDocName)
            .field("pOutputFile", &self.pOutputFile)
            .field("pDatatype", &self.pDatatype)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DOC_INFO_1W {
    fn eq(&self, other: &Self) -> bool {
        self.pDocName == other.pDocName
            && self.pOutputFile == other.pOutputFile
            && self.pDatatype == other.pDatatype
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DOC_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DOC_INFO_1W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DOC_INFO_2A {
    pub pDocName: super::super::Foundation::PSTR,
    pub pOutputFile: super::super::Foundation::PSTR,
    pub pDatatype: super::super::Foundation::PSTR,
    pub dwMode: u32,
    pub JobId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DOC_INFO_2A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DOC_INFO_2A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DOC_INFO_2A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOC_INFO_2A")
            .field("pDocName", &self.pDocName)
            .field("pOutputFile", &self.pOutputFile)
            .field("pDatatype", &self.pDatatype)
            .field("dwMode", &self.dwMode)
            .field("JobId", &self.JobId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DOC_INFO_2A {
    fn eq(&self, other: &Self) -> bool {
        self.pDocName == other.pDocName
            && self.pOutputFile == other.pOutputFile
            && self.pDatatype == other.pDatatype
            && self.dwMode == other.dwMode
            && self.JobId == other.JobId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DOC_INFO_2A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DOC_INFO_2A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DOC_INFO_2W {
    pub pDocName: super::super::Foundation::PWSTR,
    pub pOutputFile: super::super::Foundation::PWSTR,
    pub pDatatype: super::super::Foundation::PWSTR,
    pub dwMode: u32,
    pub JobId: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DOC_INFO_2W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DOC_INFO_2W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DOC_INFO_2W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOC_INFO_2W")
            .field("pDocName", &self.pDocName)
            .field("pOutputFile", &self.pOutputFile)
            .field("pDatatype", &self.pDatatype)
            .field("dwMode", &self.dwMode)
            .field("JobId", &self.JobId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DOC_INFO_2W {
    fn eq(&self, other: &Self) -> bool {
        self.pDocName == other.pDocName
            && self.pOutputFile == other.pOutputFile
            && self.pDatatype == other.pDatatype
            && self.dwMode == other.dwMode
            && self.JobId == other.JobId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DOC_INFO_2W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DOC_INFO_2W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DOC_INFO_3A {
    pub pDocName: super::super::Foundation::PSTR,
    pub pOutputFile: super::super::Foundation::PSTR,
    pub pDatatype: super::super::Foundation::PSTR,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DOC_INFO_3A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DOC_INFO_3A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DOC_INFO_3A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOC_INFO_3A")
            .field("pDocName", &self.pDocName)
            .field("pOutputFile", &self.pOutputFile)
            .field("pDatatype", &self.pDatatype)
            .field("dwFlags", &self.dwFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DOC_INFO_3A {
    fn eq(&self, other: &Self) -> bool {
        self.pDocName == other.pDocName
            && self.pOutputFile == other.pOutputFile
            && self.pDatatype == other.pDatatype
            && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DOC_INFO_3A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DOC_INFO_3A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DOC_INFO_3W {
    pub pDocName: super::super::Foundation::PWSTR,
    pub pOutputFile: super::super::Foundation::PWSTR,
    pub pDatatype: super::super::Foundation::PWSTR,
    pub dwFlags: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DOC_INFO_3W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DOC_INFO_3W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DOC_INFO_3W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DOC_INFO_3W")
            .field("pDocName", &self.pDocName)
            .field("pOutputFile", &self.pOutputFile)
            .field("pDatatype", &self.pDatatype)
            .field("dwFlags", &self.dwFlags)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DOC_INFO_3W {
    fn eq(&self, other: &Self) -> bool {
        self.pDocName == other.pDocName
            && self.pOutputFile == other.pOutputFile
            && self.pDatatype == other.pDatatype
            && self.dwFlags == other.dwFlags
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DOC_INFO_3W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DOC_INFO_3W {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DPD_DELETE_ALL_FILES: u32 = 4u32;
pub const DPD_DELETE_SPECIFIC_VERSION: u32 = 2u32;
pub const DPD_DELETE_UNUSED_FILES: u32 = 1u32;
pub const DPF_ICONID_AS_HICON: u32 = 1u32;
pub const DPF_USE_HDLGTEMPLATE: u32 = 2u32;
pub const DPS_NOPERMISSION: u32 = 1u32;
pub const DP_STD_DOCPROPPAGE1: u32 = 65533u32;
pub const DP_STD_DOCPROPPAGE2: u32 = 65534u32;
pub const DP_STD_RESERVED_START: u32 = 65520u32;
pub const DP_STD_TREEVIEWPAGE: u32 = 65535u32;
pub const DRIVER_EVENT_DELETE: u32 = 2u32;
pub const DRIVER_EVENT_INITIALIZE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_1A {
    pub pName: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_1A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_1A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_1A")
            .field("pName", &self.pName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_1A {
    fn eq(&self, other: &Self) -> bool {
        self.pName == other.pName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_1A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_1W {
    pub pName: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_1W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_1W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_1W")
            .field("pName", &self.pName)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_1W {
    fn eq(&self, other: &Self) -> bool {
        self.pName == other.pName
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_1W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_2A {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PSTR,
    pub pEnvironment: super::super::Foundation::PSTR,
    pub pDriverPath: super::super::Foundation::PSTR,
    pub pDataFile: super::super::Foundation::PSTR,
    pub pConfigFile: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_2A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_2A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_2A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_2A")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_2A {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_2A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_2A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_2W {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub pEnvironment: super::super::Foundation::PWSTR,
    pub pDriverPath: super::super::Foundation::PWSTR,
    pub pDataFile: super::super::Foundation::PWSTR,
    pub pConfigFile: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_2W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_2W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_2W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_2W")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_2W {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_2W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_2W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_3A {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PSTR,
    pub pEnvironment: super::super::Foundation::PSTR,
    pub pDriverPath: super::super::Foundation::PSTR,
    pub pDataFile: super::super::Foundation::PSTR,
    pub pConfigFile: super::super::Foundation::PSTR,
    pub pHelpFile: super::super::Foundation::PSTR,
    pub pDependentFiles: super::super::Foundation::PSTR,
    pub pMonitorName: super::super::Foundation::PSTR,
    pub pDefaultDataType: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_3A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_3A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_3A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_3A")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_3A {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_3A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_3A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_3W {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub pEnvironment: super::super::Foundation::PWSTR,
    pub pDriverPath: super::super::Foundation::PWSTR,
    pub pDataFile: super::super::Foundation::PWSTR,
    pub pConfigFile: super::super::Foundation::PWSTR,
    pub pHelpFile: super::super::Foundation::PWSTR,
    pub pDependentFiles: super::super::Foundation::PWSTR,
    pub pMonitorName: super::super::Foundation::PWSTR,
    pub pDefaultDataType: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_3W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_3W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_3W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_3W")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_3W {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_3W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_3W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_4A {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PSTR,
    pub pEnvironment: super::super::Foundation::PSTR,
    pub pDriverPath: super::super::Foundation::PSTR,
    pub pDataFile: super::super::Foundation::PSTR,
    pub pConfigFile: super::super::Foundation::PSTR,
    pub pHelpFile: super::super::Foundation::PSTR,
    pub pDependentFiles: super::super::Foundation::PSTR,
    pub pMonitorName: super::super::Foundation::PSTR,
    pub pDefaultDataType: super::super::Foundation::PSTR,
    pub pszzPreviousNames: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_4A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_4A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_4A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_4A")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .field("pszzPreviousNames", &self.pszzPreviousNames)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_4A {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
            && self.pszzPreviousNames == other.pszzPreviousNames
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_4A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_4A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_4W {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub pEnvironment: super::super::Foundation::PWSTR,
    pub pDriverPath: super::super::Foundation::PWSTR,
    pub pDataFile: super::super::Foundation::PWSTR,
    pub pConfigFile: super::super::Foundation::PWSTR,
    pub pHelpFile: super::super::Foundation::PWSTR,
    pub pDependentFiles: super::super::Foundation::PWSTR,
    pub pMonitorName: super::super::Foundation::PWSTR,
    pub pDefaultDataType: super::super::Foundation::PWSTR,
    pub pszzPreviousNames: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_4W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_4W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_4W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_4W")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .field("pszzPreviousNames", &self.pszzPreviousNames)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_4W {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
            && self.pszzPreviousNames == other.pszzPreviousNames
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_4W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_4W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_5A {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PSTR,
    pub pEnvironment: super::super::Foundation::PSTR,
    pub pDriverPath: super::super::Foundation::PSTR,
    pub pDataFile: super::super::Foundation::PSTR,
    pub pConfigFile: super::super::Foundation::PSTR,
    pub dwDriverAttributes: u32,
    pub dwConfigVersion: u32,
    pub dwDriverVersion: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_5A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_5A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_5A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_5A")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("dwDriverAttributes", &self.dwDriverAttributes)
            .field("dwConfigVersion", &self.dwConfigVersion)
            .field("dwDriverVersion", &self.dwDriverVersion)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_5A {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.dwDriverAttributes == other.dwDriverAttributes
            && self.dwConfigVersion == other.dwConfigVersion
            && self.dwDriverVersion == other.dwDriverVersion
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_5A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_5A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_5W {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub pEnvironment: super::super::Foundation::PWSTR,
    pub pDriverPath: super::super::Foundation::PWSTR,
    pub pDataFile: super::super::Foundation::PWSTR,
    pub pConfigFile: super::super::Foundation::PWSTR,
    pub dwDriverAttributes: u32,
    pub dwConfigVersion: u32,
    pub dwDriverVersion: u32,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_5W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_5W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_5W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_5W")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("dwDriverAttributes", &self.dwDriverAttributes)
            .field("dwConfigVersion", &self.dwConfigVersion)
            .field("dwDriverVersion", &self.dwDriverVersion)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_5W {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.dwDriverAttributes == other.dwDriverAttributes
            && self.dwConfigVersion == other.dwConfigVersion
            && self.dwDriverVersion == other.dwDriverVersion
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_5W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_5W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_6A {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PSTR,
    pub pEnvironment: super::super::Foundation::PSTR,
    pub pDriverPath: super::super::Foundation::PSTR,
    pub pDataFile: super::super::Foundation::PSTR,
    pub pConfigFile: super::super::Foundation::PSTR,
    pub pHelpFile: super::super::Foundation::PSTR,
    pub pDependentFiles: super::super::Foundation::PSTR,
    pub pMonitorName: super::super::Foundation::PSTR,
    pub pDefaultDataType: super::super::Foundation::PSTR,
    pub pszzPreviousNames: super::super::Foundation::PSTR,
    pub ftDriverDate: super::super::Foundation::FILETIME,
    pub dwlDriverVersion: u64,
    pub pszMfgName: super::super::Foundation::PSTR,
    pub pszOEMUrl: super::super::Foundation::PSTR,
    pub pszHardwareID: super::super::Foundation::PSTR,
    pub pszProvider: super::super::Foundation::PSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_6A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_6A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_6A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_6A")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .field("pszzPreviousNames", &self.pszzPreviousNames)
            .field("ftDriverDate", &self.ftDriverDate)
            .field("dwlDriverVersion", &self.dwlDriverVersion)
            .field("pszMfgName", &self.pszMfgName)
            .field("pszOEMUrl", &self.pszOEMUrl)
            .field("pszHardwareID", &self.pszHardwareID)
            .field("pszProvider", &self.pszProvider)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_6A {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
            && self.pszzPreviousNames == other.pszzPreviousNames
            && self.ftDriverDate == other.ftDriverDate
            && self.dwlDriverVersion == other.dwlDriverVersion
            && self.pszMfgName == other.pszMfgName
            && self.pszOEMUrl == other.pszOEMUrl
            && self.pszHardwareID == other.pszHardwareID
            && self.pszProvider == other.pszProvider
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_6A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_6A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_6W {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub pEnvironment: super::super::Foundation::PWSTR,
    pub pDriverPath: super::super::Foundation::PWSTR,
    pub pDataFile: super::super::Foundation::PWSTR,
    pub pConfigFile: super::super::Foundation::PWSTR,
    pub pHelpFile: super::super::Foundation::PWSTR,
    pub pDependentFiles: super::super::Foundation::PWSTR,
    pub pMonitorName: super::super::Foundation::PWSTR,
    pub pDefaultDataType: super::super::Foundation::PWSTR,
    pub pszzPreviousNames: super::super::Foundation::PWSTR,
    pub ftDriverDate: super::super::Foundation::FILETIME,
    pub dwlDriverVersion: u64,
    pub pszMfgName: super::super::Foundation::PWSTR,
    pub pszOEMUrl: super::super::Foundation::PWSTR,
    pub pszHardwareID: super::super::Foundation::PWSTR,
    pub pszProvider: super::super::Foundation::PWSTR,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_6W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_6W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_6W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_6W")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .field("pszzPreviousNames", &self.pszzPreviousNames)
            .field("ftDriverDate", &self.ftDriverDate)
            .field("dwlDriverVersion", &self.dwlDriverVersion)
            .field("pszMfgName", &self.pszMfgName)
            .field("pszOEMUrl", &self.pszOEMUrl)
            .field("pszHardwareID", &self.pszHardwareID)
            .field("pszProvider", &self.pszProvider)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_6W {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
            && self.pszzPreviousNames == other.pszzPreviousNames
            && self.ftDriverDate == other.ftDriverDate
            && self.dwlDriverVersion == other.dwlDriverVersion
            && self.pszMfgName == other.pszMfgName
            && self.pszOEMUrl == other.pszOEMUrl
            && self.pszHardwareID == other.pszHardwareID
            && self.pszProvider == other.pszProvider
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_6W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_6W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_8A {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PSTR,
    pub pEnvironment: super::super::Foundation::PSTR,
    pub pDriverPath: super::super::Foundation::PSTR,
    pub pDataFile: super::super::Foundation::PSTR,
    pub pConfigFile: super::super::Foundation::PSTR,
    pub pHelpFile: super::super::Foundation::PSTR,
    pub pDependentFiles: super::super::Foundation::PSTR,
    pub pMonitorName: super::super::Foundation::PSTR,
    pub pDefaultDataType: super::super::Foundation::PSTR,
    pub pszzPreviousNames: super::super::Foundation::PSTR,
    pub ftDriverDate: super::super::Foundation::FILETIME,
    pub dwlDriverVersion: u64,
    pub pszMfgName: super::super::Foundation::PSTR,
    pub pszOEMUrl: super::super::Foundation::PSTR,
    pub pszHardwareID: super::super::Foundation::PSTR,
    pub pszProvider: super::super::Foundation::PSTR,
    pub pszPrintProcessor: super::super::Foundation::PSTR,
    pub pszVendorSetup: super::super::Foundation::PSTR,
    pub pszzColorProfiles: super::super::Foundation::PSTR,
    pub pszInfPath: super::super::Foundation::PSTR,
    pub dwPrinterDriverAttributes: u32,
    pub pszzCoreDriverDependencies: super::super::Foundation::PSTR,
    pub ftMinInboxDriverVerDate: super::super::Foundation::FILETIME,
    pub dwlMinInboxDriverVerVersion: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_8A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_8A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_8A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_8A")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .field("pszzPreviousNames", &self.pszzPreviousNames)
            .field("ftDriverDate", &self.ftDriverDate)
            .field("dwlDriverVersion", &self.dwlDriverVersion)
            .field("pszMfgName", &self.pszMfgName)
            .field("pszOEMUrl", &self.pszOEMUrl)
            .field("pszHardwareID", &self.pszHardwareID)
            .field("pszProvider", &self.pszProvider)
            .field("pszPrintProcessor", &self.pszPrintProcessor)
            .field("pszVendorSetup", &self.pszVendorSetup)
            .field("pszzColorProfiles", &self.pszzColorProfiles)
            .field("pszInfPath", &self.pszInfPath)
            .field("dwPrinterDriverAttributes", &self.dwPrinterDriverAttributes)
            .field(
                "pszzCoreDriverDependencies",
                &self.pszzCoreDriverDependencies,
            )
            .field("ftMinInboxDriverVerDate", &self.ftMinInboxDriverVerDate)
            .field(
                "dwlMinInboxDriverVerVersion",
                &self.dwlMinInboxDriverVerVersion,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_8A {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
            && self.pszzPreviousNames == other.pszzPreviousNames
            && self.ftDriverDate == other.ftDriverDate
            && self.dwlDriverVersion == other.dwlDriverVersion
            && self.pszMfgName == other.pszMfgName
            && self.pszOEMUrl == other.pszOEMUrl
            && self.pszHardwareID == other.pszHardwareID
            && self.pszProvider == other.pszProvider
            && self.pszPrintProcessor == other.pszPrintProcessor
            && self.pszVendorSetup == other.pszVendorSetup
            && self.pszzColorProfiles == other.pszzColorProfiles
            && self.pszInfPath == other.pszInfPath
            && self.dwPrinterDriverAttributes == other.dwPrinterDriverAttributes
            && self.pszzCoreDriverDependencies == other.pszzCoreDriverDependencies
            && self.ftMinInboxDriverVerDate == other.ftMinInboxDriverVerDate
            && self.dwlMinInboxDriverVerVersion == other.dwlMinInboxDriverVerVersion
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_8A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_8A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct DRIVER_INFO_8W {
    pub cVersion: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub pEnvironment: super::super::Foundation::PWSTR,
    pub pDriverPath: super::super::Foundation::PWSTR,
    pub pDataFile: super::super::Foundation::PWSTR,
    pub pConfigFile: super::super::Foundation::PWSTR,
    pub pHelpFile: super::super::Foundation::PWSTR,
    pub pDependentFiles: super::super::Foundation::PWSTR,
    pub pMonitorName: super::super::Foundation::PWSTR,
    pub pDefaultDataType: super::super::Foundation::PWSTR,
    pub pszzPreviousNames: super::super::Foundation::PWSTR,
    pub ftDriverDate: super::super::Foundation::FILETIME,
    pub dwlDriverVersion: u64,
    pub pszMfgName: super::super::Foundation::PWSTR,
    pub pszOEMUrl: super::super::Foundation::PWSTR,
    pub pszHardwareID: super::super::Foundation::PWSTR,
    pub pszProvider: super::super::Foundation::PWSTR,
    pub pszPrintProcessor: super::super::Foundation::PWSTR,
    pub pszVendorSetup: super::super::Foundation::PWSTR,
    pub pszzColorProfiles: super::super::Foundation::PWSTR,
    pub pszInfPath: super::super::Foundation::PWSTR,
    pub dwPrinterDriverAttributes: u32,
    pub pszzCoreDriverDependencies: super::super::Foundation::PWSTR,
    pub ftMinInboxDriverVerDate: super::super::Foundation::FILETIME,
    pub dwlMinInboxDriverVerVersion: u64,
}
#[cfg(feature = "Win32_Foundation")]
impl DRIVER_INFO_8W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for DRIVER_INFO_8W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for DRIVER_INFO_8W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_INFO_8W")
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .field("pszzPreviousNames", &self.pszzPreviousNames)
            .field("ftDriverDate", &self.ftDriverDate)
            .field("dwlDriverVersion", &self.dwlDriverVersion)
            .field("pszMfgName", &self.pszMfgName)
            .field("pszOEMUrl", &self.pszOEMUrl)
            .field("pszHardwareID", &self.pszHardwareID)
            .field("pszProvider", &self.pszProvider)
            .field("pszPrintProcessor", &self.pszPrintProcessor)
            .field("pszVendorSetup", &self.pszVendorSetup)
            .field("pszzColorProfiles", &self.pszzColorProfiles)
            .field("pszInfPath", &self.pszInfPath)
            .field("dwPrinterDriverAttributes", &self.dwPrinterDriverAttributes)
            .field(
                "pszzCoreDriverDependencies",
                &self.pszzCoreDriverDependencies,
            )
            .field("ftMinInboxDriverVerDate", &self.ftMinInboxDriverVerDate)
            .field(
                "dwlMinInboxDriverVerVersion",
                &self.dwlMinInboxDriverVerVersion,
            )
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for DRIVER_INFO_8W {
    fn eq(&self, other: &Self) -> bool {
        self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
            && self.pszzPreviousNames == other.pszzPreviousNames
            && self.ftDriverDate == other.ftDriverDate
            && self.dwlDriverVersion == other.dwlDriverVersion
            && self.pszMfgName == other.pszMfgName
            && self.pszOEMUrl == other.pszOEMUrl
            && self.pszHardwareID == other.pszHardwareID
            && self.pszProvider == other.pszProvider
            && self.pszPrintProcessor == other.pszPrintProcessor
            && self.pszVendorSetup == other.pszVendorSetup
            && self.pszzColorProfiles == other.pszzColorProfiles
            && self.pszInfPath == other.pszInfPath
            && self.dwPrinterDriverAttributes == other.dwPrinterDriverAttributes
            && self.pszzCoreDriverDependencies == other.pszzCoreDriverDependencies
            && self.ftMinInboxDriverVerDate == other.ftMinInboxDriverVerDate
            && self.dwlMinInboxDriverVerVersion == other.dwlMinInboxDriverVerVersion
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for DRIVER_INFO_8W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for DRIVER_INFO_8W {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DRIVER_KERNELMODE: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DRIVER_UPGRADE_INFO_1 {
    pub pPrinterName: *mut i8,
    pub pOldDriverDirectory: *mut i8,
}
impl DRIVER_UPGRADE_INFO_1 {}
impl ::std::default::Default for DRIVER_UPGRADE_INFO_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DRIVER_UPGRADE_INFO_1 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_UPGRADE_INFO_1")
            .field("pPrinterName", &self.pPrinterName)
            .field("pOldDriverDirectory", &self.pOldDriverDirectory)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DRIVER_UPGRADE_INFO_1 {
    fn eq(&self, other: &Self) -> bool {
        self.pPrinterName == other.pPrinterName
            && self.pOldDriverDirectory == other.pOldDriverDirectory
    }
}
impl ::std::cmp::Eq for DRIVER_UPGRADE_INFO_1 {}
unsafe impl ::windows::runtime::Abi for DRIVER_UPGRADE_INFO_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct DRIVER_UPGRADE_INFO_2 {
    pub pPrinterName: *mut i8,
    pub pOldDriverDirectory: *mut i8,
    pub cVersion: u32,
    pub pName: *mut i8,
    pub pEnvironment: *mut i8,
    pub pDriverPath: *mut i8,
    pub pDataFile: *mut i8,
    pub pConfigFile: *mut i8,
    pub pHelpFile: *mut i8,
    pub pDependentFiles: *mut i8,
    pub pMonitorName: *mut i8,
    pub pDefaultDataType: *mut i8,
    pub pszzPreviousNames: *mut i8,
}
impl DRIVER_UPGRADE_INFO_2 {}
impl ::std::default::Default for DRIVER_UPGRADE_INFO_2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for DRIVER_UPGRADE_INFO_2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("DRIVER_UPGRADE_INFO_2")
            .field("pPrinterName", &self.pPrinterName)
            .field("pOldDriverDirectory", &self.pOldDriverDirectory)
            .field("cVersion", &self.cVersion)
            .field("pName", &self.pName)
            .field("pEnvironment", &self.pEnvironment)
            .field("pDriverPath", &self.pDriverPath)
            .field("pDataFile", &self.pDataFile)
            .field("pConfigFile", &self.pConfigFile)
            .field("pHelpFile", &self.pHelpFile)
            .field("pDependentFiles", &self.pDependentFiles)
            .field("pMonitorName", &self.pMonitorName)
            .field("pDefaultDataType", &self.pDefaultDataType)
            .field("pszzPreviousNames", &self.pszzPreviousNames)
            .finish()
    }
}
impl ::std::cmp::PartialEq for DRIVER_UPGRADE_INFO_2 {
    fn eq(&self, other: &Self) -> bool {
        self.pPrinterName == other.pPrinterName
            && self.pOldDriverDirectory == other.pOldDriverDirectory
            && self.cVersion == other.cVersion
            && self.pName == other.pName
            && self.pEnvironment == other.pEnvironment
            && self.pDriverPath == other.pDriverPath
            && self.pDataFile == other.pDataFile
            && self.pConfigFile == other.pConfigFile
            && self.pHelpFile == other.pHelpFile
            && self.pDependentFiles == other.pDependentFiles
            && self.pMonitorName == other.pMonitorName
            && self.pDefaultDataType == other.pDefaultDataType
            && self.pszzPreviousNames == other.pszzPreviousNames
    }
}
impl ::std::cmp::Eq for DRIVER_UPGRADE_INFO_2 {}
unsafe impl ::windows::runtime::Abi for DRIVER_UPGRADE_INFO_2 {
    type Abi = Self;
    type DefaultType = Self;
}
pub const DRIVER_USERMODE: u32 = 2u32;
pub const DSPRINT_PENDING: u32 = 2147483648u32;
pub const DSPRINT_PUBLISH: u32 = 1u32;
pub const DSPRINT_REPUBLISH: u32 = 8u32;
pub const DSPRINT_UNPUBLISH: u32 = 4u32;
pub const DSPRINT_UPDATE: u32 = 2u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeleteFormA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pformname: Param1,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeleteFormA(
                hprinter: super::super::Foundation::HANDLE,
                pformname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeleteFormA(
            hprinter.into_param().abi(),
            pformname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeleteFormW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pformname: Param1,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeleteFormW(
                hprinter: super::super::Foundation::HANDLE,
                pformname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeleteFormW(
            hprinter.into_param().abi(),
            pformname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeleteJobNamedProperty<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    jobid: u32,
    pszname: Param2,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeleteJobNamedProperty(
                hprinter: super::super::Foundation::HANDLE,
                jobid: u32,
                pszname: super::super::Foundation::PWSTR,
            ) -> u32;
        }
        ::std::mem::transmute(DeleteJobNamedProperty(
            hprinter.into_param().abi(),
            ::std::mem::transmute(jobid),
            pszname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeleteMonitorA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pmonitorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeleteMonitorA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                pmonitorname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeleteMonitorA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pmonitorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeleteMonitorW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pmonitorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeleteMonitorW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                pmonitorname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeleteMonitorW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pmonitorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePortA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    hwnd: Param1,
    pportname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePortA(
                pname: super::super::Foundation::PSTR,
                hwnd: super::super::Foundation::HWND,
                pportname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePortA(
            pname.into_param().abi(),
            hwnd.into_param().abi(),
            pportname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePortW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    hwnd: Param1,
    pportname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePortW(
                pname: super::super::Foundation::PWSTR,
                hwnd: super::super::Foundation::HWND,
                pportname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePortW(
            pname.into_param().abi(),
            hwnd.into_param().abi(),
            pportname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrintProcessorA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pprintprocessorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrintProcessorA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                pprintprocessorname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrintProcessorA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pprintprocessorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrintProcessorW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pprintprocessorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrintProcessorW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                pprintprocessorname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrintProcessorW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pprintprocessorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrintProvidorA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pprintprovidorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrintProvidorA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                pprintprovidorname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrintProvidorA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pprintprovidorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrintProvidorW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pprintprovidorname: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrintProvidorW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                pprintprovidorname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrintProvidorW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pprintprovidorname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinter<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinter(
                hprinter: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinter(hprinter.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterConnectionA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterConnectionA(
                pname: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinterConnectionA(pname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterConnectionW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterConnectionW(
                pname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinterConnectionW(pname.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDataA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pvaluename: Param1,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDataA(
                hprinter: super::super::Foundation::HANDLE,
                pvaluename: super::super::Foundation::PSTR,
            ) -> u32;
        }
        ::std::mem::transmute(DeletePrinterDataA(
            hprinter.into_param().abi(),
            pvaluename.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDataExA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    pvaluename: Param2,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDataExA(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PSTR,
                pvaluename: super::super::Foundation::PSTR,
            ) -> u32;
        }
        ::std::mem::transmute(DeletePrinterDataExA(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            pvaluename.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDataExW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    pvaluename: Param2,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDataExW(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PWSTR,
                pvaluename: super::super::Foundation::PWSTR,
            ) -> u32;
        }
        ::std::mem::transmute(DeletePrinterDataExW(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            pvaluename.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDataW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pvaluename: Param1,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDataW(
                hprinter: super::super::Foundation::HANDLE,
                pvaluename: super::super::Foundation::PWSTR,
            ) -> u32;
        }
        ::std::mem::transmute(DeletePrinterDataW(
            hprinter.into_param().abi(),
            pvaluename.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDriverA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pdrivername: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDriverA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                pdrivername: super::super::Foundation::PSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinterDriverA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pdrivername.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDriverExA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pdrivername: Param2,
    dwdeleteflag: u32,
    dwversionflag: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDriverExA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                pdrivername: super::super::Foundation::PSTR,
                dwdeleteflag: u32,
                dwversionflag: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinterDriverExA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pdrivername.into_param().abi(),
            ::std::mem::transmute(dwdeleteflag),
            ::std::mem::transmute(dwversionflag),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDriverExW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pdrivername: Param2,
    dwdeleteflag: u32,
    dwversionflag: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDriverExW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                pdrivername: super::super::Foundation::PWSTR,
                dwdeleteflag: u32,
                dwversionflag: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinterDriverExW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pdrivername.into_param().abi(),
            ::std::mem::transmute(dwdeleteflag),
            ::std::mem::transmute(dwversionflag),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDriverPackageA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pszserver: Param0,
    pszinfpath: Param1,
    pszenvironment: Param2,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDriverPackageA(
                pszserver: super::super::Foundation::PSTR,
                pszinfpath: super::super::Foundation::PSTR,
                pszenvironment: super::super::Foundation::PSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        DeletePrinterDriverPackageA(
            pszserver.into_param().abi(),
            pszinfpath.into_param().abi(),
            pszenvironment.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDriverPackageW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszserver: Param0,
    pszinfpath: Param1,
    pszenvironment: Param2,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDriverPackageW(
                pszserver: super::super::Foundation::PWSTR,
                pszinfpath: super::super::Foundation::PWSTR,
                pszenvironment: super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        DeletePrinterDriverPackageW(
            pszserver.into_param().abi(),
            pszinfpath.into_param().abi(),
            pszenvironment.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterDriverW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    pdrivername: Param2,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterDriverW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                pdrivername: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinterDriverW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            pdrivername.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterIC<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinteric: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterIC(
                hprinteric: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DeletePrinterIC(hprinteric.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterKeyA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterKeyA(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PSTR,
            ) -> u32;
        }
        ::std::mem::transmute(DeletePrinterKeyA(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn DeletePrinterKeyW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DeletePrinterKeyW(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PWSTR,
            ) -> u32;
        }
        ::std::mem::transmute(DeletePrinterKeyW(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn DevQueryPrint<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
    presid: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DevQueryPrint(
                hprinter: super::super::Foundation::HANDLE,
                pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
                presid: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DevQueryPrint(
            hprinter.into_param().abi(),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(presid),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn DevQueryPrintEx(pdqpinfo: *mut DEVQUERYPRINT_INFO) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DevQueryPrintEx(pdqpinfo: *mut DEVQUERYPRINT_INFO)
                -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(DevQueryPrintEx(::std::mem::transmute(pdqpinfo)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn DocumentPropertiesA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hwnd: Param0,
    hprinter: Param1,
    pdevicename: Param2,
    pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEA,
    pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEA,
    fmode: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DocumentPropertiesA(
                hwnd: super::super::Foundation::HWND,
                hprinter: super::super::Foundation::HANDLE,
                pdevicename: super::super::Foundation::PSTR,
                pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEA,
                pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEA,
                fmode: u32,
            ) -> i32;
        }
        ::std::mem::transmute(DocumentPropertiesA(
            hwnd.into_param().abi(),
            hprinter.into_param().abi(),
            pdevicename.into_param().abi(),
            ::std::mem::transmute(pdevmodeoutput),
            ::std::mem::transmute(pdevmodeinput),
            ::std::mem::transmute(fmode),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn DocumentPropertiesW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hwnd: Param0,
    hprinter: Param1,
    pdevicename: Param2,
    pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEW,
    pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEW,
    fmode: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn DocumentPropertiesW(
                hwnd: super::super::Foundation::HWND,
                hprinter: super::super::Foundation::HANDLE,
                pdevicename: super::super::Foundation::PWSTR,
                pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEW,
                pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEW,
                fmode: u32,
            ) -> i32;
        }
        ::std::mem::transmute(DocumentPropertiesW(
            hwnd.into_param().abi(),
            hprinter.into_param().abi(),
            pdevicename.into_param().abi(),
            ::std::mem::transmute(pdevmodeoutput),
            ::std::mem::transmute(pdevmodeinput),
            ::std::mem::transmute(fmode),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EATTRIBUTE_DATATYPE(pub i32);
pub const kADT_UNKNOWN: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(0i32);
pub const kADT_BOOL: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(1i32);
pub const kADT_INT: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(2i32);
pub const kADT_LONG: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(3i32);
pub const kADT_DWORD: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(4i32);
pub const kADT_ASCII: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(5i32);
pub const kADT_UNICODE: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(6i32);
pub const kADT_BINARY: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(7i32);
pub const kADT_SIZE: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(8i32);
pub const kADT_RECT: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(9i32);
pub const kADT_CUSTOMSIZEPARAMS: EATTRIBUTE_DATATYPE = EATTRIBUTE_DATATYPE(10i32);
impl ::std::convert::From<i32> for EATTRIBUTE_DATATYPE {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EATTRIBUTE_DATATYPE {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EBranchOfficeJobEventType(pub i32);
pub const kInvalidJobState: EBranchOfficeJobEventType = EBranchOfficeJobEventType(0i32);
pub const kLogJobPrinted: EBranchOfficeJobEventType = EBranchOfficeJobEventType(1i32);
pub const kLogJobRendered: EBranchOfficeJobEventType = EBranchOfficeJobEventType(2i32);
pub const kLogJobError: EBranchOfficeJobEventType = EBranchOfficeJobEventType(3i32);
pub const kLogJobPipelineError: EBranchOfficeJobEventType = EBranchOfficeJobEventType(4i32);
pub const kLogOfflineFileFull: EBranchOfficeJobEventType = EBranchOfficeJobEventType(5i32);
impl ::std::convert::From<i32> for EBranchOfficeJobEventType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EBranchOfficeJobEventType {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ECBF_CHECKNAME_AT_FRONT: u32 = 1u32;
pub const ECBF_CHECKNAME_ONLY: u32 = 128u32;
pub const ECBF_CHECKNAME_ONLY_ENABLED: u32 = 2u32;
pub const ECBF_ICONID_AS_HICON: u32 = 4u32;
pub const ECBF_MASK: u32 = 255u32;
pub const ECBF_OVERLAY_ECBICON_IF_CHECKED: u32 = 16u32;
pub const ECBF_OVERLAY_NO_ICON: u32 = 64u32;
pub const ECBF_OVERLAY_STOP_ICON: u32 = 32u32;
pub const ECBF_OVERLAY_WARNING_ICON: u32 = 8u32;
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub type EMFPLAYPROC = unsafe extern "system" fn(
    param0: super::Gdi::HDC,
    param1: i32,
    param2: super::super::Foundation::HANDLE,
) -> i32;
pub const EMF_PP_COLOR_OPTIMIZATION: u32 = 1u32;
pub const EPF_ICONID_AS_HICON: u32 = 8u32;
pub const EPF_INCL_SETUP_TITLE: u32 = 2u32;
pub const EPF_MASK: u32 = 255u32;
pub const EPF_NO_DOT_DOT_DOT: u32 = 4u32;
pub const EPF_OVERLAY_NO_ICON: u32 = 64u32;
pub const EPF_OVERLAY_STOP_ICON: u32 = 32u32;
pub const EPF_OVERLAY_WARNING_ICON: u32 = 16u32;
pub const EPF_PUSH_TYPE_DLGPROC: u32 = 1u32;
pub const EPF_USE_HDLGTEMPLATE: u32 = 128u32;
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EPrintPropertyType(pub i32);
pub const kPropertyTypeString: EPrintPropertyType = EPrintPropertyType(1i32);
pub const kPropertyTypeInt32: EPrintPropertyType = EPrintPropertyType(2i32);
pub const kPropertyTypeInt64: EPrintPropertyType = EPrintPropertyType(3i32);
pub const kPropertyTypeByte: EPrintPropertyType = EPrintPropertyType(4i32);
pub const kPropertyTypeTime: EPrintPropertyType = EPrintPropertyType(5i32);
pub const kPropertyTypeDevMode: EPrintPropertyType = EPrintPropertyType(6i32);
pub const kPropertyTypeSD: EPrintPropertyType = EPrintPropertyType(7i32);
pub const kPropertyTypeNotificationReply: EPrintPropertyType = EPrintPropertyType(8i32);
pub const kPropertyTypeNotificationOptions: EPrintPropertyType = EPrintPropertyType(9i32);
pub const kPropertyTypeBuffer: EPrintPropertyType = EPrintPropertyType(10i32);
impl ::std::convert::From<i32> for EPrintPropertyType {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EPrintPropertyType {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EPrintXPSJobOperation(pub i32);
pub const kJobProduction: EPrintXPSJobOperation = EPrintXPSJobOperation(1i32);
pub const kJobConsumption: EPrintXPSJobOperation = EPrintXPSJobOperation(2i32);
impl ::std::convert::From<i32> for EPrintXPSJobOperation {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EPrintXPSJobOperation {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EPrintXPSJobProgress(pub i32);
pub const kAddingDocumentSequence: EPrintXPSJobProgress = EPrintXPSJobProgress(0i32);
pub const kDocumentSequenceAdded: EPrintXPSJobProgress = EPrintXPSJobProgress(1i32);
pub const kAddingFixedDocument: EPrintXPSJobProgress = EPrintXPSJobProgress(2i32);
pub const kFixedDocumentAdded: EPrintXPSJobProgress = EPrintXPSJobProgress(3i32);
pub const kAddingFixedPage: EPrintXPSJobProgress = EPrintXPSJobProgress(4i32);
pub const kFixedPageAdded: EPrintXPSJobProgress = EPrintXPSJobProgress(5i32);
pub const kResourceAdded: EPrintXPSJobProgress = EPrintXPSJobProgress(6i32);
pub const kFontAdded: EPrintXPSJobProgress = EPrintXPSJobProgress(7i32);
pub const kImageAdded: EPrintXPSJobProgress = EPrintXPSJobProgress(8i32);
pub const kXpsDocumentCommitted: EPrintXPSJobProgress = EPrintXPSJobProgress(9i32);
impl ::std::convert::From<i32> for EPrintXPSJobProgress {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EPrintXPSJobProgress {
    type Abi = Self;
    type DefaultType = Self;
}
pub const ERROR_BIDI_DEVICE_CONFIG_UNCHANGED: u32 = 13014u32;
pub const ERROR_BIDI_DEVICE_OFFLINE: u32 = 13004u32;
pub const ERROR_BIDI_ERROR_BASE: u32 = 13000u32;
pub const ERROR_BIDI_GET_ARGUMENT_NOT_SUPPORTED: u32 = 13012u32;
pub const ERROR_BIDI_GET_MISSING_ARGUMENT: u32 = 13013u32;
pub const ERROR_BIDI_GET_REQUIRES_ARGUMENT: u32 = 13011u32;
pub const ERROR_BIDI_NO_BIDI_SCHEMA_EXTENSIONS: u32 = 13016u32;
pub const ERROR_BIDI_NO_LOCALIZED_RESOURCES: u32 = 13015u32;
pub const ERROR_BIDI_SCHEMA_NOT_SUPPORTED: u32 = 13005u32;
pub const ERROR_BIDI_SCHEMA_READ_ONLY: u32 = 13002u32;
pub const ERROR_BIDI_SCHEMA_WRITE_ONLY: u32 = 13010u32;
pub const ERROR_BIDI_SERVER_OFFLINE: u32 = 13003u32;
pub const ERROR_BIDI_SET_DIFFERENT_TYPE: u32 = 13006u32;
pub const ERROR_BIDI_SET_INVALID_SCHEMAPATH: u32 = 13008u32;
pub const ERROR_BIDI_SET_MULTIPLE_SCHEMAPATH: u32 = 13007u32;
pub const ERROR_BIDI_SET_UNKNOWN_FAILURE: u32 = 13009u32;
pub const ERROR_BIDI_STATUS_OK: u32 = 0u32;
pub const ERROR_BIDI_STATUS_WARNING: u32 = 13001u32;
pub const ERROR_BIDI_UNSUPPORTED_CLIENT_LANGUAGE: u32 = 13017u32;
pub const ERROR_BIDI_UNSUPPORTED_RESOURCE_FORMAT: u32 = 13018u32;
pub const ERR_CPSUI_ALLOCMEM_FAILED: i32 = -2i32;
pub const ERR_CPSUI_CREATEPROPPAGE_FAILED: i32 = -10i32;
pub const ERR_CPSUI_CREATE_IMAGELIST_FAILED: i32 = -33i32;
pub const ERR_CPSUI_CREATE_TRACKBAR_FAILED: i32 = -31i32;
pub const ERR_CPSUI_CREATE_UDARROW_FAILED: i32 = -32i32;
pub const ERR_CPSUI_DMCOPIES_USE_EXTPUSH: i32 = -43i32;
pub const ERR_CPSUI_FUNCTION_NOT_IMPLEMENTED: i32 = -9999i32;
pub const ERR_CPSUI_GETLASTERROR: i32 = -1i32;
pub const ERR_CPSUI_INTERNAL_ERROR: i32 = -10000i32;
pub const ERR_CPSUI_INVALID_DLGPAGEIDX: i32 = -16i32;
pub const ERR_CPSUI_INVALID_DLGPAGE_CBSIZE: i32 = -14i32;
pub const ERR_CPSUI_INVALID_DMPUBID: i32 = -29i32;
pub const ERR_CPSUI_INVALID_DMPUB_TVOT: i32 = -30i32;
pub const ERR_CPSUI_INVALID_ECB_CBSIZE: i32 = -26i32;
pub const ERR_CPSUI_INVALID_EDITBOX_BUF_SIZE: i32 = -25i32;
pub const ERR_CPSUI_INVALID_EDITBOX_PSEL: i32 = -24i32;
pub const ERR_CPSUI_INVALID_EXTPUSH_CBSIZE: i32 = -39i32;
pub const ERR_CPSUI_INVALID_LBCB_TYPE: i32 = -35i32;
pub const ERR_CPSUI_INVALID_LPARAM: i32 = -4i32;
pub const ERR_CPSUI_INVALID_OPTITEM_CBSIZE: i32 = -19i32;
pub const ERR_CPSUI_INVALID_OPTPARAM_CBSIZE: i32 = -23i32;
pub const ERR_CPSUI_INVALID_OPTTYPE_CBSIZE: i32 = -20i32;
pub const ERR_CPSUI_INVALID_OPTTYPE_COUNT: i32 = -21i32;
pub const ERR_CPSUI_INVALID_PDATA: i32 = -3i32;
pub const ERR_CPSUI_INVALID_PDLGPAGE: i32 = -13i32;
pub const ERR_CPSUI_INVALID_PUSHBUTTON_TYPE: i32 = -38i32;
pub const ERR_CPSUI_INVALID_TVOT_TYPE: i32 = -34i32;
pub const ERR_CPSUI_MORE_THAN_ONE_STDPAGE: i32 = -12i32;
pub const ERR_CPSUI_MORE_THAN_ONE_TVPAGE: i32 = -11i32;
pub const ERR_CPSUI_NO_EXTPUSH_DLGTEMPLATEID: i32 = -41i32;
pub const ERR_CPSUI_NO_PROPSHEETPAGE: i32 = -8i32;
pub const ERR_CPSUI_NULL_CALLERNAME: i32 = -6i32;
pub const ERR_CPSUI_NULL_ECB_PCHECKEDNAME: i32 = -28i32;
pub const ERR_CPSUI_NULL_ECB_PTITLE: i32 = -27i32;
pub const ERR_CPSUI_NULL_EXTPUSH_CALLBACK: i32 = -42i32;
pub const ERR_CPSUI_NULL_EXTPUSH_DLGPROC: i32 = -40i32;
pub const ERR_CPSUI_NULL_HINST: i32 = -5i32;
pub const ERR_CPSUI_NULL_OPTITEMNAME: i32 = -7i32;
pub const ERR_CPSUI_NULL_POPTITEM: i32 = -18i32;
pub const ERR_CPSUI_NULL_POPTPARAM: i32 = -22i32;
pub const ERR_CPSUI_SUBITEM_DIFF_DLGPAGEIDX: i32 = -17i32;
pub const ERR_CPSUI_SUBITEM_DIFF_OPTIF_HIDE: i32 = -36i32;
pub const ERR_CPSUI_TOO_MANY_DLGPAGES: i32 = -15i32;
pub const ERR_CPSUI_TOO_MANY_PROPSHEETPAGES: i32 = -9i32;
pub const ERR_CPSUI_ZERO_OPTITEM: i32 = -44i32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct EXTCHKBOX {
    pub cbSize: u16,
    pub Flags: u16,
    pub pTitle: *mut i8,
    pub pSeparator: *mut i8,
    pub pCheckedName: *mut i8,
    pub IconID: usize,
    pub wReserved: [u16; 4],
    pub dwReserved: [usize; 2],
}
impl EXTCHKBOX {}
impl ::std::default::Default for EXTCHKBOX {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for EXTCHKBOX {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EXTCHKBOX")
            .field("cbSize", &self.cbSize)
            .field("Flags", &self.Flags)
            .field("pTitle", &self.pTitle)
            .field("pSeparator", &self.pSeparator)
            .field("pCheckedName", &self.pCheckedName)
            .field("IconID", &self.IconID)
            .field("wReserved", &self.wReserved)
            .field("dwReserved", &self.dwReserved)
            .finish()
    }
}
impl ::std::cmp::PartialEq for EXTCHKBOX {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.Flags == other.Flags
            && self.pTitle == other.pTitle
            && self.pSeparator == other.pSeparator
            && self.pCheckedName == other.pCheckedName
            && self.IconID == other.IconID
            && self.wReserved == other.wReserved
            && self.dwReserved == other.dwReserved
    }
}
impl ::std::cmp::Eq for EXTCHKBOX {}
unsafe impl ::windows::runtime::Abi for EXTCHKBOX {
    type Abi = Self;
    type DefaultType = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::clone::Clone for EXTPUSH {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub struct EXTPUSH {
    pub cbSize: u16,
    pub Flags: u16,
    pub pTitle: *mut i8,
    pub Anonymous1: EXTPUSH_0,
    pub IconID: usize,
    pub Anonymous2: EXTPUSH_1,
    pub dwReserved: [usize; 3],
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl EXTPUSH {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for EXTPUSH {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for EXTPUSH {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for EXTPUSH {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for EXTPUSH {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::clone::Clone for EXTPUSH_0 {
    fn clone(&self) -> Self {
        unimplemented!()
    }
}
#[repr(C)]
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
pub union EXTPUSH_0 {
    pub DlgProc: ::windows::runtime::RawPtr,
    pub pfnCallBack: ::windows::runtime::RawPtr,
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl EXTPUSH_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::default::Default for EXTPUSH_0 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::PartialEq for EXTPUSH_0 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
impl ::std::cmp::Eq for EXTPUSH_0 {}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_WindowsAndMessaging"))]
unsafe impl ::windows::runtime::Abi for EXTPUSH_0 {
    type Abi = ::std::mem::ManuallyDrop<Self>;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub union EXTPUSH_1 {
    pub DlgTemplateID: u16,
    pub hDlgTemplate: super::super::Foundation::HANDLE,
}
#[cfg(feature = "Win32_Foundation")]
impl EXTPUSH_1 {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for EXTPUSH_1 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for EXTPUSH_1 {
    fn eq(&self, _other: &Self) -> bool {
        unimplemented!()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for EXTPUSH_1 {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for EXTPUSH_1 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct EXTTEXTMETRIC {
    pub emSize: i16,
    pub emPointSize: i16,
    pub emOrientation: i16,
    pub emMasterHeight: i16,
    pub emMinScale: i16,
    pub emMaxScale: i16,
    pub emMasterUnits: i16,
    pub emCapHeight: i16,
    pub emXHeight: i16,
    pub emLowerCaseAscent: i16,
    pub emLowerCaseDescent: i16,
    pub emSlant: i16,
    pub emSuperScript: i16,
    pub emSubScript: i16,
    pub emSuperScriptSize: i16,
    pub emSubScriptSize: i16,
    pub emUnderlineOffset: i16,
    pub emUnderlineWidth: i16,
    pub emDoubleUpperUnderlineOffset: i16,
    pub emDoubleLowerUnderlineOffset: i16,
    pub emDoubleUpperUnderlineWidth: i16,
    pub emDoubleLowerUnderlineWidth: i16,
    pub emStrikeOutOffset: i16,
    pub emStrikeOutWidth: i16,
    pub emKernPairs: u16,
    pub emKernTracks: u16,
}
impl EXTTEXTMETRIC {}
impl ::std::default::Default for EXTTEXTMETRIC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for EXTTEXTMETRIC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("EXTTEXTMETRIC")
            .field("emSize", &self.emSize)
            .field("emPointSize", &self.emPointSize)
            .field("emOrientation", &self.emOrientation)
            .field("emMasterHeight", &self.emMasterHeight)
            .field("emMinScale", &self.emMinScale)
            .field("emMaxScale", &self.emMaxScale)
            .field("emMasterUnits", &self.emMasterUnits)
            .field("emCapHeight", &self.emCapHeight)
            .field("emXHeight", &self.emXHeight)
            .field("emLowerCaseAscent", &self.emLowerCaseAscent)
            .field("emLowerCaseDescent", &self.emLowerCaseDescent)
            .field("emSlant", &self.emSlant)
            .field("emSuperScript", &self.emSuperScript)
            .field("emSubScript", &self.emSubScript)
            .field("emSuperScriptSize", &self.emSuperScriptSize)
            .field("emSubScriptSize", &self.emSubScriptSize)
            .field("emUnderlineOffset", &self.emUnderlineOffset)
            .field("emUnderlineWidth", &self.emUnderlineWidth)
            .field(
                "emDoubleUpperUnderlineOffset",
                &self.emDoubleUpperUnderlineOffset,
            )
            .field(
                "emDoubleLowerUnderlineOffset",
                &self.emDoubleLowerUnderlineOffset,
            )
            .field(
                "emDoubleUpperUnderlineWidth",
                &self.emDoubleUpperUnderlineWidth,
            )
            .field(
                "emDoubleLowerUnderlineWidth",
                &self.emDoubleLowerUnderlineWidth,
            )
            .field("emStrikeOutOffset", &self.emStrikeOutOffset)
            .field("emStrikeOutWidth", &self.emStrikeOutWidth)
            .field("emKernPairs", &self.emKernPairs)
            .field("emKernTracks", &self.emKernTracks)
            .finish()
    }
}
impl ::std::cmp::PartialEq for EXTTEXTMETRIC {
    fn eq(&self, other: &Self) -> bool {
        self.emSize == other.emSize
            && self.emPointSize == other.emPointSize
            && self.emOrientation == other.emOrientation
            && self.emMasterHeight == other.emMasterHeight
            && self.emMinScale == other.emMinScale
            && self.emMaxScale == other.emMaxScale
            && self.emMasterUnits == other.emMasterUnits
            && self.emCapHeight == other.emCapHeight
            && self.emXHeight == other.emXHeight
            && self.emLowerCaseAscent == other.emLowerCaseAscent
            && self.emLowerCaseDescent == other.emLowerCaseDescent
            && self.emSlant == other.emSlant
            && self.emSuperScript == other.emSuperScript
            && self.emSubScript == other.emSubScript
            && self.emSuperScriptSize == other.emSuperScriptSize
            && self.emSubScriptSize == other.emSubScriptSize
            && self.emUnderlineOffset == other.emUnderlineOffset
            && self.emUnderlineWidth == other.emUnderlineWidth
            && self.emDoubleUpperUnderlineOffset == other.emDoubleUpperUnderlineOffset
            && self.emDoubleLowerUnderlineOffset == other.emDoubleLowerUnderlineOffset
            && self.emDoubleUpperUnderlineWidth == other.emDoubleUpperUnderlineWidth
            && self.emDoubleLowerUnderlineWidth == other.emDoubleLowerUnderlineWidth
            && self.emStrikeOutOffset == other.emStrikeOutOffset
            && self.emStrikeOutWidth == other.emStrikeOutWidth
            && self.emKernPairs == other.emKernPairs
            && self.emKernTracks == other.emKernTracks
    }
}
impl ::std::cmp::Eq for EXTTEXTMETRIC {}
unsafe impl ::windows::runtime::Abi for EXTTEXTMETRIC {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EXpsCompressionOptions(pub i32);
pub const Compression_NotCompressed: EXpsCompressionOptions = EXpsCompressionOptions(0i32);
pub const Compression_Normal: EXpsCompressionOptions = EXpsCompressionOptions(1i32);
pub const Compression_Small: EXpsCompressionOptions = EXpsCompressionOptions(2i32);
pub const Compression_Fast: EXpsCompressionOptions = EXpsCompressionOptions(3i32);
impl ::std::convert::From<i32> for EXpsCompressionOptions {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EXpsCompressionOptions {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EXpsFontOptions(pub i32);
pub const Font_Normal: EXpsFontOptions = EXpsFontOptions(0i32);
pub const Font_Obfusticate: EXpsFontOptions = EXpsFontOptions(1i32);
impl ::std::convert::From<i32> for EXpsFontOptions {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EXpsFontOptions {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EXpsFontRestriction(pub i32);
pub const Xps_Restricted_Font_Installable: EXpsFontRestriction = EXpsFontRestriction(0i32);
pub const Xps_Restricted_Font_NoEmbedding: EXpsFontRestriction = EXpsFontRestriction(2i32);
pub const Xps_Restricted_Font_PreviewPrint: EXpsFontRestriction = EXpsFontRestriction(4i32);
pub const Xps_Restricted_Font_Editable: EXpsFontRestriction = EXpsFontRestriction(8i32);
impl ::std::convert::From<i32> for EXpsFontRestriction {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EXpsFontRestriction {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: marker :: Copy,
    :: std :: clone :: Clone,
    :: std :: default :: Default,
    :: std :: fmt :: Debug,
)]
#[repr(transparent)]
pub struct EXpsJobConsumption(pub i32);
pub const XpsJob_DocumentSequenceAdded: EXpsJobConsumption = EXpsJobConsumption(0i32);
pub const XpsJob_FixedDocumentAdded: EXpsJobConsumption = EXpsJobConsumption(1i32);
pub const XpsJob_FixedPageAdded: EXpsJobConsumption = EXpsJobConsumption(2i32);
impl ::std::convert::From<i32> for EXpsJobConsumption {
    fn from(value: i32) -> Self {
        Self(value)
    }
}
unsafe impl ::windows::runtime::Abi for EXpsJobConsumption {
    type Abi = Self;
    type DefaultType = Self;
}
pub const E_VERSION_NOT_SUPPORTED: u32 = 2147745793u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EndDocPrinter<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EndDocPrinter(
                hprinter: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EndDocPrinter(hprinter.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EndPagePrinter<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EndPagePrinter(
                hprinter: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EndPagePrinter(hprinter.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumFormsA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pform: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumFormsA(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pform: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumFormsA(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pform),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumFormsW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pform: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumFormsW(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pform: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumFormsW(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pform),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumJobNamedProperties<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    jobid: u32,
    pcproperties: *mut u32,
    ppproperties: *mut *mut PrintNamedProperty,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumJobNamedProperties(
                hprinter: super::super::Foundation::HANDLE,
                jobid: u32,
                pcproperties: *mut u32,
                ppproperties: *mut *mut PrintNamedProperty,
            ) -> u32;
        }
        ::std::mem::transmute(EnumJobNamedProperties(
            hprinter.into_param().abi(),
            ::std::mem::transmute(jobid),
            ::std::mem::transmute(pcproperties),
            ::std::mem::transmute(ppproperties),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumJobsA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    firstjob: u32,
    nojobs: u32,
    level: u32,
    pjob: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumJobsA(
                hprinter: super::super::Foundation::HANDLE,
                firstjob: u32,
                nojobs: u32,
                level: u32,
                pjob: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumJobsA(
            hprinter.into_param().abi(),
            ::std::mem::transmute(firstjob),
            ::std::mem::transmute(nojobs),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pjob),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumJobsW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    firstjob: u32,
    nojobs: u32,
    level: u32,
    pjob: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumJobsW(
                hprinter: super::super::Foundation::HANDLE,
                firstjob: u32,
                nojobs: u32,
                level: u32,
                pjob: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumJobsW(
            hprinter.into_param().abi(),
            ::std::mem::transmute(firstjob),
            ::std::mem::transmute(nojobs),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pjob),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumMonitorsA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    level: u32,
    pmonitor: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumMonitorsA(
                pname: super::super::Foundation::PSTR,
                level: u32,
                pmonitor: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumMonitorsA(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pmonitor),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumMonitorsW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    level: u32,
    pmonitor: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumMonitorsW(
                pname: super::super::Foundation::PWSTR,
                level: u32,
                pmonitor: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumMonitorsW(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pmonitor),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPortsA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    level: u32,
    pport: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPortsA(
                pname: super::super::Foundation::PSTR,
                level: u32,
                pport: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPortsA(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pport),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPortsW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    level: u32,
    pport: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPortsW(
                pname: super::super::Foundation::PWSTR,
                level: u32,
                pport: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPortsW(
            pname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pport),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrintProcessorDatatypesA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    pprintprocessorname: Param1,
    level: u32,
    pdatatypes: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrintProcessorDatatypesA(
                pname: super::super::Foundation::PSTR,
                pprintprocessorname: super::super::Foundation::PSTR,
                level: u32,
                pdatatypes: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrintProcessorDatatypesA(
            pname.into_param().abi(),
            pprintprocessorname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdatatypes),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrintProcessorDatatypesW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    pprintprocessorname: Param1,
    level: u32,
    pdatatypes: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrintProcessorDatatypesW(
                pname: super::super::Foundation::PWSTR,
                pprintprocessorname: super::super::Foundation::PWSTR,
                level: u32,
                pdatatypes: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrintProcessorDatatypesW(
            pname.into_param().abi(),
            pprintprocessorname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdatatypes),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrintProcessorsA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pprintprocessorinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrintProcessorsA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                level: u32,
                pprintprocessorinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrintProcessorsA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprintprocessorinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrintProcessorsW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pprintprocessorinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrintProcessorsW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                level: u32,
                pprintprocessorinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrintProcessorsW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprintprocessorinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterDataA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    dwindex: u32,
    pvaluename: super::super::Foundation::PSTR,
    cbvaluename: u32,
    pcbvaluename: *mut u32,
    ptype: *mut u32,
    pdata: *mut u8,
    cbdata: u32,
    pcbdata: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterDataA(
                hprinter: super::super::Foundation::HANDLE,
                dwindex: u32,
                pvaluename: super::super::Foundation::PSTR,
                cbvaluename: u32,
                pcbvaluename: *mut u32,
                ptype: *mut u32,
                pdata: *mut u8,
                cbdata: u32,
                pcbdata: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(EnumPrinterDataA(
            hprinter.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pvaluename),
            ::std::mem::transmute(cbvaluename),
            ::std::mem::transmute(pcbvaluename),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(cbdata),
            ::std::mem::transmute(pcbdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterDataExA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    penumvalues: *mut u8,
    cbenumvalues: u32,
    pcbenumvalues: *mut u32,
    pnenumvalues: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterDataExA(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PSTR,
                penumvalues: *mut u8,
                cbenumvalues: u32,
                pcbenumvalues: *mut u32,
                pnenumvalues: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(EnumPrinterDataExA(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            ::std::mem::transmute(penumvalues),
            ::std::mem::transmute(cbenumvalues),
            ::std::mem::transmute(pcbenumvalues),
            ::std::mem::transmute(pnenumvalues),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterDataExW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    penumvalues: *mut u8,
    cbenumvalues: u32,
    pcbenumvalues: *mut u32,
    pnenumvalues: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterDataExW(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PWSTR,
                penumvalues: *mut u8,
                cbenumvalues: u32,
                pcbenumvalues: *mut u32,
                pnenumvalues: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(EnumPrinterDataExW(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            ::std::mem::transmute(penumvalues),
            ::std::mem::transmute(cbenumvalues),
            ::std::mem::transmute(pcbenumvalues),
            ::std::mem::transmute(pnenumvalues),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterDataW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    dwindex: u32,
    pvaluename: super::super::Foundation::PWSTR,
    cbvaluename: u32,
    pcbvaluename: *mut u32,
    ptype: *mut u32,
    pdata: *mut u8,
    cbdata: u32,
    pcbdata: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterDataW(
                hprinter: super::super::Foundation::HANDLE,
                dwindex: u32,
                pvaluename: super::super::Foundation::PWSTR,
                cbvaluename: u32,
                pcbvaluename: *mut u32,
                ptype: *mut u32,
                pdata: *mut u8,
                cbdata: u32,
                pcbdata: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(EnumPrinterDataW(
            hprinter.into_param().abi(),
            ::std::mem::transmute(dwindex),
            ::std::mem::transmute(pvaluename),
            ::std::mem::transmute(cbvaluename),
            ::std::mem::transmute(pcbvaluename),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(cbdata),
            ::std::mem::transmute(pcbdata),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterDriversA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pdriverinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterDriversA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                level: u32,
                pdriverinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrinterDriversA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterDriversW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pdriverinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterDriversW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                level: u32,
                pdriverinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrinterDriversW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterKeyA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    psubkey: super::super::Foundation::PSTR,
    cbsubkey: u32,
    pcbsubkey: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterKeyA(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PSTR,
                psubkey: super::super::Foundation::PSTR,
                cbsubkey: u32,
                pcbsubkey: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(EnumPrinterKeyA(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            ::std::mem::transmute(psubkey),
            ::std::mem::transmute(cbsubkey),
            ::std::mem::transmute(pcbsubkey),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrinterKeyW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    psubkey: super::super::Foundation::PWSTR,
    cbsubkey: u32,
    pcbsubkey: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrinterKeyW(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PWSTR,
                psubkey: super::super::Foundation::PWSTR,
                cbsubkey: u32,
                pcbsubkey: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(EnumPrinterKeyW(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            ::std::mem::transmute(psubkey),
            ::std::mem::transmute(cbsubkey),
            ::std::mem::transmute(pcbsubkey),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrintersA<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    flags: u32,
    name: Param1,
    level: u32,
    pprinterenum: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrintersA(
                flags: u32,
                name: super::super::Foundation::PSTR,
                level: u32,
                pprinterenum: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrintersA(
            ::std::mem::transmute(flags),
            name.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprinterenum),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn EnumPrintersW<
    'a,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    flags: u32,
    name: Param1,
    level: u32,
    pprinterenum: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
    pcreturned: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn EnumPrintersW(
                flags: u32,
                name: super::super::Foundation::PWSTR,
                level: u32,
                pprinterenum: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
                pcreturned: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(EnumPrintersW(
            ::std::mem::transmute(flags),
            name.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprinterenum),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pcreturned),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn ExtDeviceMode<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param6: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hwnd: Param0,
    hinst: Param1,
    pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEA,
    pdevicename: Param3,
    pport: Param4,
    pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEA,
    pprofile: Param6,
    fmode: u32,
) -> i32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn ExtDeviceMode(
                hwnd: super::super::Foundation::HWND,
                hinst: super::super::Foundation::HANDLE,
                pdevmodeoutput: *mut super::super::UI::DisplayDevices::DEVMODEA,
                pdevicename: super::super::Foundation::PSTR,
                pport: super::super::Foundation::PSTR,
                pdevmodeinput: *const super::super::UI::DisplayDevices::DEVMODEA,
                pprofile: super::super::Foundation::PSTR,
                fmode: u32,
            ) -> i32;
        }
        ::std::mem::transmute(ExtDeviceMode(
            hwnd.into_param().abi(),
            hinst.into_param().abi(),
            ::std::mem::transmute(pdevmodeoutput),
            pdevicename.into_param().abi(),
            pport.into_param().abi(),
            ::std::mem::transmute(pdevmodeinput),
            pprofile.into_param().abi(),
            ::std::mem::transmute(fmode),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
pub const FG_CANCHANGE: u32 = 128u32;
pub const FILL_WITH_DEFAULTS: u32 = 1u32;
pub const FMTID_PrinterPropertyBag: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        1979297226,
        2429,
        17859,
        [166, 228, 186, 178, 158, 39, 111, 62],
    );
pub const FNT_INFO_CURRENTFONTID: u32 = 10u32;
pub const FNT_INFO_FONTBOLD: u32 = 6u32;
pub const FNT_INFO_FONTHEIGHT: u32 = 4u32;
pub const FNT_INFO_FONTITALIC: u32 = 7u32;
pub const FNT_INFO_FONTMAXWIDTH: u32 = 13u32;
pub const FNT_INFO_FONTSTRIKETHRU: u32 = 9u32;
pub const FNT_INFO_FONTUNDERLINE: u32 = 8u32;
pub const FNT_INFO_FONTWIDTH: u32 = 5u32;
pub const FNT_INFO_GRAYPERCENTAGE: u32 = 1u32;
pub const FNT_INFO_MAX: u32 = 14u32;
pub const FNT_INFO_NEXTFONTID: u32 = 2u32;
pub const FNT_INFO_NEXTGLYPH: u32 = 3u32;
pub const FNT_INFO_PRINTDIRINCCDEGREES: u32 = 0u32;
pub const FNT_INFO_TEXTXRES: u32 = 12u32;
pub const FNT_INFO_TEXTYRES: u32 = 11u32;
pub const FONT_DIR_SORTED: u32 = 1u32;
pub const FONT_FL_DEVICEFONT: u32 = 16u32;
pub const FONT_FL_GLYPHSET_GTT: u32 = 32u32;
pub const FONT_FL_GLYPHSET_RLE: u32 = 64u32;
pub const FONT_FL_IFI: u32 = 2u32;
pub const FONT_FL_PERMANENT_SF: u32 = 8u32;
pub const FONT_FL_RESERVED: u32 = 32768u32;
pub const FONT_FL_SOFTFONT: u32 = 4u32;
pub const FONT_FL_UFM: u32 = 1u32;
pub const FORM_BUILTIN: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct FORM_INFO_1A {
    pub Flags: u32,
    pub pName: super::super::Foundation::PSTR,
    pub Size: super::super::Foundation::SIZE,
    pub ImageableArea: super::super::Foundation::RECTL,
}
#[cfg(feature = "Win32_Foundation")]
impl FORM_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for FORM_INFO_1A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for FORM_INFO_1A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FORM_INFO_1A")
            .field("Flags", &self.Flags)
            .field("pName", &self.pName)
            .field("Size", &self.Size)
            .field("ImageableArea", &self.ImageableArea)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for FORM_INFO_1A {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags
            && self.pName == other.pName
            && self.Size == other.Size
            && self.ImageableArea == other.ImageableArea
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for FORM_INFO_1A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for FORM_INFO_1A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct FORM_INFO_1W {
    pub Flags: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub Size: super::super::Foundation::SIZE,
    pub ImageableArea: super::super::Foundation::RECTL,
}
#[cfg(feature = "Win32_Foundation")]
impl FORM_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for FORM_INFO_1W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for FORM_INFO_1W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FORM_INFO_1W")
            .field("Flags", &self.Flags)
            .field("pName", &self.pName)
            .field("Size", &self.Size)
            .field("ImageableArea", &self.ImageableArea)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for FORM_INFO_1W {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags
            && self.pName == other.pName
            && self.Size == other.Size
            && self.ImageableArea == other.ImageableArea
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for FORM_INFO_1W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for FORM_INFO_1W {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct FORM_INFO_2A {
    pub Flags: u32,
    pub pName: super::super::Foundation::PSTR,
    pub Size: super::super::Foundation::SIZE,
    pub ImageableArea: super::super::Foundation::RECTL,
    pub pKeyword: super::super::Foundation::PSTR,
    pub StringType: u32,
    pub pMuiDll: super::super::Foundation::PSTR,
    pub dwResourceId: u32,
    pub pDisplayName: super::super::Foundation::PSTR,
    pub wLangId: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl FORM_INFO_2A {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for FORM_INFO_2A {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for FORM_INFO_2A {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FORM_INFO_2A")
            .field("Flags", &self.Flags)
            .field("pName", &self.pName)
            .field("Size", &self.Size)
            .field("ImageableArea", &self.ImageableArea)
            .field("pKeyword", &self.pKeyword)
            .field("StringType", &self.StringType)
            .field("pMuiDll", &self.pMuiDll)
            .field("dwResourceId", &self.dwResourceId)
            .field("pDisplayName", &self.pDisplayName)
            .field("wLangId", &self.wLangId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for FORM_INFO_2A {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags
            && self.pName == other.pName
            && self.Size == other.Size
            && self.ImageableArea == other.ImageableArea
            && self.pKeyword == other.pKeyword
            && self.StringType == other.StringType
            && self.pMuiDll == other.pMuiDll
            && self.dwResourceId == other.dwResourceId
            && self.pDisplayName == other.pDisplayName
            && self.wLangId == other.wLangId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for FORM_INFO_2A {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for FORM_INFO_2A {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
#[cfg(feature = "Win32_Foundation")]
pub struct FORM_INFO_2W {
    pub Flags: u32,
    pub pName: super::super::Foundation::PWSTR,
    pub Size: super::super::Foundation::SIZE,
    pub ImageableArea: super::super::Foundation::RECTL,
    pub pKeyword: super::super::Foundation::PSTR,
    pub StringType: u32,
    pub pMuiDll: super::super::Foundation::PWSTR,
    pub dwResourceId: u32,
    pub pDisplayName: super::super::Foundation::PWSTR,
    pub wLangId: u16,
}
#[cfg(feature = "Win32_Foundation")]
impl FORM_INFO_2W {}
#[cfg(feature = "Win32_Foundation")]
impl ::std::default::Default for FORM_INFO_2W {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::fmt::Debug for FORM_INFO_2W {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("FORM_INFO_2W")
            .field("Flags", &self.Flags)
            .field("pName", &self.pName)
            .field("Size", &self.Size)
            .field("ImageableArea", &self.ImageableArea)
            .field("pKeyword", &self.pKeyword)
            .field("StringType", &self.StringType)
            .field("pMuiDll", &self.pMuiDll)
            .field("dwResourceId", &self.dwResourceId)
            .field("pDisplayName", &self.pDisplayName)
            .field("wLangId", &self.wLangId)
            .finish()
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::PartialEq for FORM_INFO_2W {
    fn eq(&self, other: &Self) -> bool {
        self.Flags == other.Flags
            && self.pName == other.pName
            && self.Size == other.Size
            && self.ImageableArea == other.ImageableArea
            && self.pKeyword == other.pKeyword
            && self.StringType == other.StringType
            && self.pMuiDll == other.pMuiDll
            && self.dwResourceId == other.dwResourceId
            && self.pDisplayName == other.pDisplayName
            && self.wLangId == other.wLangId
    }
}
#[cfg(feature = "Win32_Foundation")]
impl ::std::cmp::Eq for FORM_INFO_2W {}
#[cfg(feature = "Win32_Foundation")]
unsafe impl ::windows::runtime::Abi for FORM_INFO_2W {
    type Abi = Self;
    type DefaultType = Self;
}
pub const FORM_PRINTER: u32 = 2u32;
pub const FORM_USER: u32 = 0u32;
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindClosePrinterChangeNotification<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hchange: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn FindClosePrinterChangeNotification(
                hchange: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(FindClosePrinterChangeNotification(
            hchange.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindFirstPrinterChangeNotification<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    fdwfilter: u32,
    fdwoptions: u32,
    pprinternotifyoptions: *const ::std::ffi::c_void,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn FindFirstPrinterChangeNotification(
                hprinter: super::super::Foundation::HANDLE,
                fdwfilter: u32,
                fdwoptions: u32,
                pprinternotifyoptions: *const ::std::ffi::c_void,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(FindFirstPrinterChangeNotification(
            hprinter.into_param().abi(),
            ::std::mem::transmute(fdwfilter),
            ::std::mem::transmute(fdwoptions),
            ::std::mem::transmute(pprinternotifyoptions),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FindNextPrinterChangeNotification<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hchange: Param0,
    pdwchange: *mut u32,
    pvreserved: *const ::std::ffi::c_void,
    ppprinternotifyinfo: *mut *mut ::std::ffi::c_void,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn FindNextPrinterChangeNotification(
                hchange: super::super::Foundation::HANDLE,
                pdwchange: *mut u32,
                pvreserved: *const ::std::ffi::c_void,
                ppprinternotifyinfo: *mut *mut ::std::ffi::c_void,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(FindNextPrinterChangeNotification(
            hchange.into_param().abi(),
            ::std::mem::transmute(pdwchange),
            ::std::mem::transmute(pvreserved),
            ::std::mem::transmute(ppprinternotifyinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FlushPrinter<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    pbuf: *const ::std::ffi::c_void,
    cbbuf: u32,
    pcwritten: *mut u32,
    csleep: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn FlushPrinter(
                hprinter: super::super::Foundation::HANDLE,
                pbuf: *const ::std::ffi::c_void,
                cbbuf: u32,
                pcwritten: *mut u32,
                csleep: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(FlushPrinter(
            hprinter.into_param().abi(),
            ::std::mem::transmute(pbuf),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcwritten),
            ::std::mem::transmute(csleep),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FreePrintNamedPropertyArray(
    cproperties: u32,
    ppproperties: *mut *mut PrintNamedProperty,
) {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn FreePrintNamedPropertyArray(
                cproperties: u32,
                ppproperties: *mut *mut PrintNamedProperty,
            );
        }
        ::std::mem::transmute(FreePrintNamedPropertyArray(
            ::std::mem::transmute(cproperties),
            ::std::mem::transmute(ppproperties),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FreePrintPropertyValue(pvalue: *mut PrintPropertyValue) {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn FreePrintPropertyValue(pvalue: *mut PrintPropertyValue);
        }
        ::std::mem::transmute(FreePrintPropertyValue(::std::mem::transmute(pvalue)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn FreePrinterNotifyInfo(
    pprinternotifyinfo: *const PRINTER_NOTIFY_INFO,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn FreePrinterNotifyInfo(
                pprinternotifyinfo: *const PRINTER_NOTIFY_INFO,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(FreePrinterNotifyInfo(::std::mem::transmute(
            pprinternotifyinfo,
        )))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct GLYPHRUN {
    pub wcLow: u16,
    pub wGlyphCount: u16,
}
impl GLYPHRUN {}
impl ::std::default::Default for GLYPHRUN {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for GLYPHRUN {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("GLYPHRUN")
            .field("wcLow", &self.wcLow)
            .field("wGlyphCount", &self.wGlyphCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for GLYPHRUN {
    fn eq(&self, other: &Self) -> bool {
        self.wcLow == other.wcLow && self.wGlyphCount == other.wGlyphCount
    }
}
impl ::std::cmp::Eq for GLYPHRUN {}
unsafe impl ::windows::runtime::Abi for GLYPHRUN {
    type Abi = Self;
    type DefaultType = Self;
}
pub const GPD_OEMCUSTOMDATA: u32 = 1u32;
pub const GUID_DEVINTERFACE_IPPUSB_PRINT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        4076077953,
        62573,
        20049,
        [188, 231, 98, 222, 108, 242, 208, 152],
    );
pub const GUID_DEVINTERFACE_USBPRINT: ::windows::runtime::GUID =
    ::windows::runtime::GUID::from_values(
        685215661,
        23058,
        4561,
        [174, 91, 0, 0, 248, 3, 168, 194],
    );
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GdiDeleteSpoolFileHandle<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiDeleteSpoolFileHandle(
                spoolfilehandle: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiDeleteSpoolFileHandle(spoolfilehandle.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GdiEndDocEMF<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiEndDocEMF(
                spoolfilehandle: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiEndDocEMF(spoolfilehandle.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GdiEndPageEMF<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
    dwoptimization: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiEndPageEMF(
                spoolfilehandle: super::super::Foundation::HANDLE,
                dwoptimization: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiEndPageEMF(
            spoolfilehandle.into_param().abi(),
            ::std::mem::transmute(dwoptimization),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
pub unsafe fn GdiGetDC<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
) -> super::Gdi::HDC {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiGetDC(spoolfilehandle: super::super::Foundation::HANDLE) -> super::Gdi::HDC;
        }
        ::std::mem::transmute(GdiGetDC(spoolfilehandle.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn GdiGetDevmodeForPage<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
    dwpagenumber: u32,
    pcurrdm: *mut *mut super::super::UI::DisplayDevices::DEVMODEW,
    plastdm: *mut *mut super::super::UI::DisplayDevices::DEVMODEW,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiGetDevmodeForPage(
                spoolfilehandle: super::super::Foundation::HANDLE,
                dwpagenumber: u32,
                pcurrdm: *mut *mut super::super::UI::DisplayDevices::DEVMODEW,
                plastdm: *mut *mut super::super::UI::DisplayDevices::DEVMODEW,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiGetDevmodeForPage(
            spoolfilehandle.into_param().abi(),
            ::std::mem::transmute(dwpagenumber),
            ::std::mem::transmute(pcurrdm),
            ::std::mem::transmute(plastdm),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GdiGetPageCount<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiGetPageCount(spoolfilehandle: super::super::Foundation::HANDLE) -> u32;
        }
        ::std::mem::transmute(GdiGetPageCount(spoolfilehandle.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GdiGetPageHandle<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
    page: u32,
    pdwpagetype: *mut u32,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiGetPageHandle(
                spoolfilehandle: super::super::Foundation::HANDLE,
                page: u32,
                pdwpagetype: *mut u32,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(GdiGetPageHandle(
            spoolfilehandle.into_param().abi(),
            ::std::mem::transmute(page),
            ::std::mem::transmute(pdwpagetype),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn GdiGetSpoolFileHandle<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pwszprintername: Param0,
    pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEW,
    pwszdocname: Param2,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiGetSpoolFileHandle(
                pwszprintername: super::super::Foundation::PWSTR,
                pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEW,
                pwszdocname: super::super::Foundation::PWSTR,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(GdiGetSpoolFileHandle(
            pwszprintername.into_param().abi(),
            ::std::mem::transmute(pdevmode),
            pwszdocname.into_param().abi(),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GdiPlayPageEMF<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
    hemf: Param1,
    prectdocument: *mut super::super::Foundation::RECT,
    prectborder: *mut super::super::Foundation::RECT,
    prectclip: *mut super::super::Foundation::RECT,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiPlayPageEMF(
                spoolfilehandle: super::super::Foundation::HANDLE,
                hemf: super::super::Foundation::HANDLE,
                prectdocument: *mut super::super::Foundation::RECT,
                prectborder: *mut super::super::Foundation::RECT,
                prectclip: *mut super::super::Foundation::RECT,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiPlayPageEMF(
            spoolfilehandle.into_param().abi(),
            hemf.into_param().abi(),
            ::std::mem::transmute(prectdocument),
            ::std::mem::transmute(prectborder),
            ::std::mem::transmute(prectclip),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn GdiResetDCEMF<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
    pcurrdm: *mut super::super::UI::DisplayDevices::DEVMODEW,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiResetDCEMF(
                spoolfilehandle: super::super::Foundation::HANDLE,
                pcurrdm: *mut super::super::UI::DisplayDevices::DEVMODEW,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiResetDCEMF(
            spoolfilehandle.into_param().abi(),
            ::std::mem::transmute(pcurrdm),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_Storage_Xps"))]
pub unsafe fn GdiStartDocEMF<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
    pdocinfo: *mut super::super::Storage::Xps::DOCINFOW,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiStartDocEMF(
                spoolfilehandle: super::super::Foundation::HANDLE,
                pdocinfo: *mut super::super::Storage::Xps::DOCINFOW,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiStartDocEMF(
            spoolfilehandle.into_param().abi(),
            ::std::mem::transmute(pdocinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GdiStartPageEMF<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    spoolfilehandle: Param0,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "gdi32")]
        extern "system" {
            fn GdiStartPageEMF(
                spoolfilehandle: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GdiStartPageEMF(spoolfilehandle.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GenerateCopyFilePaths<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param6: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszprintername: Param0,
    pszdirectory: Param1,
    psplclientinfo: *const u8,
    dwlevel: u32,
    pszsourcedir: Param4,
    pcchsourcedirsize: *mut u32,
    psztargetdir: Param6,
    pcchtargetdirsize: *mut u32,
    dwflags: u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "mscms")]
        extern "system" {
            fn GenerateCopyFilePaths(
                pszprintername: super::super::Foundation::PWSTR,
                pszdirectory: super::super::Foundation::PWSTR,
                psplclientinfo: *const u8,
                dwlevel: u32,
                pszsourcedir: super::super::Foundation::PWSTR,
                pcchsourcedirsize: *mut u32,
                psztargetdir: super::super::Foundation::PWSTR,
                pcchtargetdirsize: *mut u32,
                dwflags: u32,
            ) -> u32;
        }
        ::std::mem::transmute(GenerateCopyFilePaths(
            pszprintername.into_param().abi(),
            pszdirectory.into_param().abi(),
            ::std::mem::transmute(psplclientinfo),
            ::std::mem::transmute(dwlevel),
            pszsourcedir.into_param().abi(),
            ::std::mem::transmute(pcchsourcedirsize),
            psztargetdir.into_param().abi(),
            ::std::mem::transmute(pcchtargetdirsize),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCPSUIUserData<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
>(
    hdlg: Param0,
) -> usize {
    #[cfg(windows)]
    {
        #[link(name = "compstui")]
        extern "system" {
            fn GetCPSUIUserData(hdlg: super::super::Foundation::HWND) -> usize;
        }
        ::std::mem::transmute(GetCPSUIUserData(hdlg.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_System_SystemServices"))]
pub unsafe fn GetCorePrinterDriversA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pszserver: Param0,
    pszenvironment: Param1,
    pszzcoredriverdependencies: Param2,
    ccoreprinterdrivers: u32,
    pcoreprinterdrivers: *mut CORE_PRINTER_DRIVERA,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetCorePrinterDriversA(
                pszserver: super::super::Foundation::PSTR,
                pszenvironment: super::super::Foundation::PSTR,
                pszzcoredriverdependencies: super::super::Foundation::PSTR,
                ccoreprinterdrivers: u32,
                pcoreprinterdrivers: *mut CORE_PRINTER_DRIVERA,
            ) -> ::windows::runtime::HRESULT;
        }
        GetCorePrinterDriversA(
            pszserver.into_param().abi(),
            pszenvironment.into_param().abi(),
            pszzcoredriverdependencies.into_param().abi(),
            ::std::mem::transmute(ccoreprinterdrivers),
            ::std::mem::transmute(pcoreprinterdrivers),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetCorePrinterDriversW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszserver: Param0,
    pszenvironment: Param1,
    pszzcoredriverdependencies: Param2,
    ccoreprinterdrivers: u32,
    pcoreprinterdrivers: *mut CORE_PRINTER_DRIVERW,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetCorePrinterDriversW(
                pszserver: super::super::Foundation::PWSTR,
                pszenvironment: super::super::Foundation::PWSTR,
                pszzcoredriverdependencies: super::super::Foundation::PWSTR,
                ccoreprinterdrivers: u32,
                pcoreprinterdrivers: *mut CORE_PRINTER_DRIVERW,
            ) -> ::windows::runtime::HRESULT;
        }
        GetCorePrinterDriversW(
            pszserver.into_param().abi(),
            pszenvironment.into_param().abi(),
            pszzcoredriverdependencies.into_param().abi(),
            ::std::mem::transmute(ccoreprinterdrivers),
            ::std::mem::transmute(pcoreprinterdrivers),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDefaultPrinterA(
    pszbuffer: super::super::Foundation::PSTR,
    pcchbuffer: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetDefaultPrinterA(
                pszbuffer: super::super::Foundation::PSTR,
                pcchbuffer: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetDefaultPrinterA(
            ::std::mem::transmute(pszbuffer),
            ::std::mem::transmute(pcchbuffer),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetDefaultPrinterW(
    pszbuffer: super::super::Foundation::PWSTR,
    pcchbuffer: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetDefaultPrinterW(
                pszbuffer: super::super::Foundation::PWSTR,
                pcchbuffer: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetDefaultPrinterW(
            ::std::mem::transmute(pszbuffer),
            ::std::mem::transmute(pcchbuffer),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetFormA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pformname: Param1,
    level: u32,
    pform: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetFormA(
                hprinter: super::super::Foundation::HANDLE,
                pformname: super::super::Foundation::PSTR,
                level: u32,
                pform: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetFormA(
            hprinter.into_param().abi(),
            pformname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pform),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetFormW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pformname: Param1,
    level: u32,
    pform: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetFormW(
                hprinter: super::super::Foundation::HANDLE,
                pformname: super::super::Foundation::PWSTR,
                level: u32,
                pform: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetFormW(
            hprinter.into_param().abi(),
            pformname.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pform),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetJobA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    jobid: u32,
    level: u32,
    pjob: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetJobA(
                hprinter: super::super::Foundation::HANDLE,
                jobid: u32,
                level: u32,
                pjob: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetJobA(
            hprinter.into_param().abi(),
            ::std::mem::transmute(jobid),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pjob),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn GetJobAttributes<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pprintername: Param0,
    pdevmode: *const super::super::UI::DisplayDevices::DEVMODEW,
    pattributeinfo: *mut ATTRIBUTE_INFO_3,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "spoolss")]
        extern "system" {
            fn GetJobAttributes(
                pprintername: super::super::Foundation::PWSTR,
                pdevmode: *const super::super::UI::DisplayDevices::DEVMODEW,
                pattributeinfo: *mut ATTRIBUTE_INFO_3,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetJobAttributes(
            pprintername.into_param().abi(),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(pattributeinfo),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
pub unsafe fn GetJobAttributesEx<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pprintername: Param0,
    pdevmode: *const super::super::UI::DisplayDevices::DEVMODEW,
    dwlevel: u32,
    pattributeinfo: *mut u8,
    nsize: u32,
    dwflags: u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "spoolss")]
        extern "system" {
            fn GetJobAttributesEx(
                pprintername: super::super::Foundation::PWSTR,
                pdevmode: *const super::super::UI::DisplayDevices::DEVMODEW,
                dwlevel: u32,
                pattributeinfo: *mut u8,
                nsize: u32,
                dwflags: u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetJobAttributesEx(
            pprintername.into_param().abi(),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pattributeinfo),
            ::std::mem::transmute(nsize),
            ::std::mem::transmute(dwflags),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetJobNamedPropertyValue<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    jobid: u32,
    pszname: Param2,
    pvalue: *mut PrintPropertyValue,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetJobNamedPropertyValue(
                hprinter: super::super::Foundation::HANDLE,
                jobid: u32,
                pszname: super::super::Foundation::PWSTR,
                pvalue: *mut PrintPropertyValue,
            ) -> u32;
        }
        ::std::mem::transmute(GetJobNamedPropertyValue(
            hprinter.into_param().abi(),
            ::std::mem::transmute(jobid),
            pszname.into_param().abi(),
            ::std::mem::transmute(pvalue),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetJobW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    jobid: u32,
    level: u32,
    pjob: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetJobW(
                hprinter: super::super::Foundation::HANDLE,
                jobid: u32,
                level: u32,
                pjob: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetJobW(
            hprinter.into_param().abi(),
            ::std::mem::transmute(jobid),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pjob),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrintExecutionData(
    pdata: *mut PRINT_EXECUTION_DATA,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrintExecutionData(
                pdata: *mut PRINT_EXECUTION_DATA,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrintExecutionData(::std::mem::transmute(pdata)))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrintOutputInfo<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hwnd: Param0,
    pszprinter: Param1,
    phfile: *mut super::super::Foundation::HANDLE,
    ppszoutputfile: *mut super::super::Foundation::PWSTR,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrintOutputInfo(
                hwnd: super::super::Foundation::HWND,
                pszprinter: super::super::Foundation::PWSTR,
                phfile: *mut super::super::Foundation::HANDLE,
                ppszoutputfile: *mut super::super::Foundation::PWSTR,
            ) -> ::windows::runtime::HRESULT;
        }
        GetPrintOutputInfo(
            hwnd.into_param().abi(),
            pszprinter.into_param().abi(),
            ::std::mem::transmute(phfile),
            ::std::mem::transmute(ppszoutputfile),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrintProcessorDirectoryA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pprintprocessorinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrintProcessorDirectoryA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                level: u32,
                pprintprocessorinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrintProcessorDirectoryA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprintprocessorinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrintProcessorDirectoryW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pprintprocessorinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrintProcessorDirectoryW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                level: u32,
                pprintprocessorinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrintProcessorDirectoryW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprintprocessorinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pprinter: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterA(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pprinter: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterA(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprinter),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDataA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pvaluename: Param1,
    ptype: *mut u32,
    pdata: *mut u8,
    nsize: u32,
    pcbneeded: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDataA(
                hprinter: super::super::Foundation::HANDLE,
                pvaluename: super::super::Foundation::PSTR,
                ptype: *mut u32,
                pdata: *mut u8,
                nsize: u32,
                pcbneeded: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetPrinterDataA(
            hprinter.into_param().abi(),
            pvaluename.into_param().abi(),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(nsize),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDataExA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    pvaluename: Param2,
    ptype: *mut u32,
    pdata: *mut u8,
    nsize: u32,
    pcbneeded: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDataExA(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PSTR,
                pvaluename: super::super::Foundation::PSTR,
                ptype: *mut u32,
                pdata: *mut u8,
                nsize: u32,
                pcbneeded: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetPrinterDataExA(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            pvaluename.into_param().abi(),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(nsize),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDataExW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pkeyname: Param1,
    pvaluename: Param2,
    ptype: *mut u32,
    pdata: *mut u8,
    nsize: u32,
    pcbneeded: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDataExW(
                hprinter: super::super::Foundation::HANDLE,
                pkeyname: super::super::Foundation::PWSTR,
                pvaluename: super::super::Foundation::PWSTR,
                ptype: *mut u32,
                pdata: *mut u8,
                nsize: u32,
                pcbneeded: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetPrinterDataExW(
            hprinter.into_param().abi(),
            pkeyname.into_param().abi(),
            pvaluename.into_param().abi(),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(nsize),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDataW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    pvaluename: Param1,
    ptype: *mut u32,
    pdata: *mut u8,
    nsize: u32,
    pcbneeded: *mut u32,
) -> u32 {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDataW(
                hprinter: super::super::Foundation::HANDLE,
                pvaluename: super::super::Foundation::PWSTR,
                ptype: *mut u32,
                pdata: *mut u8,
                nsize: u32,
                pcbneeded: *mut u32,
            ) -> u32;
        }
        ::std::mem::transmute(GetPrinterDataW(
            hprinter.into_param().abi(),
            pvaluename.into_param().abi(),
            ::std::mem::transmute(ptype),
            ::std::mem::transmute(pdata),
            ::std::mem::transmute(nsize),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriver2A<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hwnd: Param0,
    hprinter: Param1,
    penvironment: Param2,
    level: u32,
    pdriverinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriver2A(
                hwnd: super::super::Foundation::HWND,
                hprinter: super::super::Foundation::HANDLE,
                penvironment: super::super::Foundation::PSTR,
                level: u32,
                pdriverinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterDriver2A(
            hwnd.into_param().abi(),
            hprinter.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriver2W<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hwnd: Param0,
    hprinter: Param1,
    penvironment: Param2,
    level: u32,
    pdriverinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriver2W(
                hwnd: super::super::Foundation::HWND,
                hprinter: super::super::Foundation::HANDLE,
                penvironment: super::super::Foundation::PWSTR,
                level: u32,
                pdriverinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterDriver2W(
            hwnd.into_param().abi(),
            hprinter.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriverA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    hprinter: Param0,
    penvironment: Param1,
    level: u32,
    pdriverinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriverA(
                hprinter: super::super::Foundation::HANDLE,
                penvironment: super::super::Foundation::PSTR,
                level: u32,
                pdriverinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterDriverA(
            hprinter.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriverDirectoryA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pdriverdirectory: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriverDirectoryA(
                pname: super::super::Foundation::PSTR,
                penvironment: super::super::Foundation::PSTR,
                level: u32,
                pdriverdirectory: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterDriverDirectoryA(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverdirectory),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriverDirectoryW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pname: Param0,
    penvironment: Param1,
    level: u32,
    pdriverdirectory: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriverDirectoryW(
                pname: super::super::Foundation::PWSTR,
                penvironment: super::super::Foundation::PWSTR,
                level: u32,
                pdriverdirectory: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterDriverDirectoryW(
            pname.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverdirectory),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriverPackagePathA<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
>(
    pszserver: Param0,
    pszenvironment: Param1,
    pszlanguage: Param2,
    pszpackageid: Param3,
    pszdriverpackagecab: Param4,
    cchdriverpackagecab: u32,
    pcchrequiredsize: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriverPackagePathA(
                pszserver: super::super::Foundation::PSTR,
                pszenvironment: super::super::Foundation::PSTR,
                pszlanguage: super::super::Foundation::PSTR,
                pszpackageid: super::super::Foundation::PSTR,
                pszdriverpackagecab: super::super::Foundation::PSTR,
                cchdriverpackagecab: u32,
                pcchrequiredsize: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        GetPrinterDriverPackagePathA(
            pszserver.into_param().abi(),
            pszenvironment.into_param().abi(),
            pszlanguage.into_param().abi(),
            pszpackageid.into_param().abi(),
            pszdriverpackagecab.into_param().abi(),
            ::std::mem::transmute(cchdriverpackagecab),
            ::std::mem::transmute(pcchrequiredsize),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriverPackagePathW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    pszserver: Param0,
    pszenvironment: Param1,
    pszlanguage: Param2,
    pszpackageid: Param3,
    pszdriverpackagecab: Param4,
    cchdriverpackagecab: u32,
    pcchrequiredsize: *mut u32,
) -> ::windows::runtime::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriverPackagePathW(
                pszserver: super::super::Foundation::PWSTR,
                pszenvironment: super::super::Foundation::PWSTR,
                pszlanguage: super::super::Foundation::PWSTR,
                pszpackageid: super::super::Foundation::PWSTR,
                pszdriverpackagecab: super::super::Foundation::PWSTR,
                cchdriverpackagecab: u32,
                pcchrequiredsize: *mut u32,
            ) -> ::windows::runtime::HRESULT;
        }
        GetPrinterDriverPackagePathW(
            pszserver.into_param().abi(),
            pszenvironment.into_param().abi(),
            pszlanguage.into_param().abi(),
            pszpackageid.into_param().abi(),
            pszdriverpackagecab.into_param().abi(),
            ::std::mem::transmute(cchdriverpackagecab),
            ::std::mem::transmute(pcchrequiredsize),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterDriverW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
>(
    hprinter: Param0,
    penvironment: Param1,
    level: u32,
    pdriverinfo: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterDriverW(
                hprinter: super::super::Foundation::HANDLE,
                penvironment: super::super::Foundation::PWSTR,
                level: u32,
                pdriverinfo: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterDriverW(
            hprinter.into_param().abi(),
            penvironment.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pdriverinfo),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetPrinterW<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
    level: u32,
    pprinter: *mut u8,
    cbbuf: u32,
    pcbneeded: *mut u32,
) -> super::super::Foundation::BOOL {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetPrinterW(
                hprinter: super::super::Foundation::HANDLE,
                level: u32,
                pprinter: *mut u8,
                cbbuf: u32,
                pcbneeded: *mut u32,
            ) -> super::super::Foundation::BOOL;
        }
        ::std::mem::transmute(GetPrinterW(
            hprinter.into_param().abi(),
            ::std::mem::transmute(level),
            ::std::mem::transmute(pprinter),
            ::std::mem::transmute(cbbuf),
            ::std::mem::transmute(pcbneeded),
        ))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[cfg(feature = "Win32_Foundation")]
pub unsafe fn GetSpoolFileHandle<
    'a,
    Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
>(
    hprinter: Param0,
) -> super::super::Foundation::HANDLE {
    #[cfg(windows)]
    {
        #[link(name = "winspool")]
        extern "system" {
            fn GetSpoolFileHandle(
                hprinter: super::super::Foundation::HANDLE,
            ) -> super::super::Foundation::HANDLE;
        }
        ::std::mem::transmute(GetSpoolFileHandle(hprinter.into_param().abi()))
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAsyncGetSendNotificationCookie(::windows::runtime::IUnknown);
impl IAsyncGetSendNotificationCookie {
    pub unsafe fn FinishAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    pub unsafe fn CancelAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FinishAsyncCallWithData<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        param0: Param0,
        param1: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            param0.into_param().abi(),
            param1.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAsyncGetSendNotificationCookie {
    type Vtable = IAsyncGetSendNotificationCookie_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IAsyncGetSendNotificationCookie> for ::windows::runtime::IUnknown {
    fn from(value: IAsyncGetSendNotificationCookie) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAsyncGetSendNotificationCookie> for ::windows::runtime::IUnknown {
    fn from(value: &IAsyncGetSendNotificationCookie) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IAsyncGetSendNotificationCookie
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IAsyncGetSendNotificationCookie
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IAsyncGetSendNotificationCookie> for IPrintAsyncCookie {
    fn from(value: IAsyncGetSendNotificationCookie) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAsyncGetSendNotificationCookie> for IPrintAsyncCookie {
    fn from(value: &IAsyncGetSendNotificationCookie) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncCookie> for IAsyncGetSendNotificationCookie {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncCookie> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintAsyncCookie>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncCookie> for &IAsyncGetSendNotificationCookie {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncCookie> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintAsyncCookie>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAsyncGetSendNotificationCookie_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::RawPtr,
        param1: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IAsyncGetSrvReferralCookie(::windows::runtime::IUnknown);
impl IAsyncGetSrvReferralCookie {
    pub unsafe fn FinishAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    pub unsafe fn CancelAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FinishAsyncCallWithData<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        param0: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            param0.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IAsyncGetSrvReferralCookie {
    type Vtable = IAsyncGetSrvReferralCookie_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IAsyncGetSrvReferralCookie> for ::windows::runtime::IUnknown {
    fn from(value: IAsyncGetSrvReferralCookie) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IAsyncGetSrvReferralCookie> for ::windows::runtime::IUnknown {
    fn from(value: &IAsyncGetSrvReferralCookie) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IAsyncGetSrvReferralCookie
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IAsyncGetSrvReferralCookie
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IAsyncGetSrvReferralCookie_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IBidiAsyncNotifyChannel(::windows::runtime::IUnknown);
impl IBidiAsyncNotifyChannel {
    pub unsafe fn SendNotification<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
    >(
        &self,
        pdata: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CloseChannel<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
    >(
        &self,
        pdata: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateNotificationChannel(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetPrintName(
        &self,
        param0: *const ::std::option::Option<IPrintAsyncNotifyDataObject>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    pub unsafe fn GetChannelNotificationType(
        &self,
        param0: *const ::std::option::Option<IPrintAsyncNotifyDataObject>,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    pub unsafe fn AsyncGetNotificationSendResponse<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
        Param1: ::windows::runtime::IntoParam<'a, IAsyncGetSendNotificationCookie>,
    >(
        &self,
        param0: Param0,
        param1: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            param0.into_param().abi(),
            param1.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AsyncCloseChannel<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
        Param1: ::windows::runtime::IntoParam<'a, IPrintAsyncCookie>,
    >(
        &self,
        param0: Param0,
        param1: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            param0.into_param().abi(),
            param1.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IBidiAsyncNotifyChannel {
    type Vtable = IBidiAsyncNotifyChannel_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1395136759,
        37403,
        20402,
        [191, 248, 47, 79, 213, 46, 190, 191],
    );
}
impl ::std::convert::From<IBidiAsyncNotifyChannel> for ::windows::runtime::IUnknown {
    fn from(value: IBidiAsyncNotifyChannel) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBidiAsyncNotifyChannel> for ::windows::runtime::IUnknown {
    fn from(value: &IBidiAsyncNotifyChannel) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IBidiAsyncNotifyChannel
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IBidiAsyncNotifyChannel
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IBidiAsyncNotifyChannel> for IPrintAsyncNotifyChannel {
    fn from(value: IBidiAsyncNotifyChannel) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IBidiAsyncNotifyChannel> for IPrintAsyncNotifyChannel {
    fn from(value: &IBidiAsyncNotifyChannel) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyChannel> for IBidiAsyncNotifyChannel {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncNotifyChannel> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintAsyncNotifyChannel>::into(
            self,
        ))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyChannel> for &IBidiAsyncNotifyChannel {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncNotifyChannel> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintAsyncNotifyChannel>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IBidiAsyncNotifyChannel_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: *const ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: *const ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::RawPtr,
        param1: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::RawPtr,
        param1: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiRequest {
    pub lpVtbl: *mut IBidiRequestVtbl,
}
impl IBidiRequest {}
impl ::std::default::Default for IBidiRequest {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiRequest {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiRequest")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiRequest {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IBidiRequest {}
unsafe impl ::windows::runtime::Abi for IBidiRequest {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiRequestContainer {
    pub lpVtbl: *mut IBidiRequestContainerVtbl,
}
impl IBidiRequestContainer {}
impl ::std::default::Default for IBidiRequestContainer {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiRequestContainer {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiRequestContainer")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiRequestContainer {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IBidiRequestContainer {}
unsafe impl ::windows::runtime::Abi for IBidiRequestContainer {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiRequestContainerVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub AddRequest: isize,
    pub GetEnumObject: isize,
    pub GetRequestCount: isize,
}
impl IBidiRequestContainerVtbl {}
impl ::std::default::Default for IBidiRequestContainerVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiRequestContainerVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiRequestContainerVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("AddRequest", &self.AddRequest)
            .field("GetEnumObject", &self.GetEnumObject)
            .field("GetRequestCount", &self.GetRequestCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiRequestContainerVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.AddRequest == other.AddRequest
            && self.GetEnumObject == other.GetEnumObject
            && self.GetRequestCount == other.GetRequestCount
    }
}
impl ::std::cmp::Eq for IBidiRequestContainerVtbl {}
unsafe impl ::windows::runtime::Abi for IBidiRequestContainerVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiRequestVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub SetSchema: isize,
    pub SetInputData: isize,
    pub GetResult: isize,
    pub GetOutputData: isize,
    pub GetEnumCount: isize,
}
impl IBidiRequestVtbl {}
impl ::std::default::Default for IBidiRequestVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiRequestVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiRequestVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("SetSchema", &self.SetSchema)
            .field("SetInputData", &self.SetInputData)
            .field("GetResult", &self.GetResult)
            .field("GetOutputData", &self.GetOutputData)
            .field("GetEnumCount", &self.GetEnumCount)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiRequestVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.SetSchema == other.SetSchema
            && self.SetInputData == other.SetInputData
            && self.GetResult == other.GetResult
            && self.GetOutputData == other.GetOutputData
            && self.GetEnumCount == other.GetEnumCount
    }
}
impl ::std::cmp::Eq for IBidiRequestVtbl {}
unsafe impl ::windows::runtime::Abi for IBidiRequestVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiSpl {
    pub lpVtbl: *mut IBidiSplVtbl,
}
impl IBidiSpl {}
impl ::std::default::Default for IBidiSpl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiSpl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiSpl")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiSpl {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IBidiSpl {}
unsafe impl ::windows::runtime::Abi for IBidiSpl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiSpl2 {
    pub lpVtbl: *mut IBidiSpl2Vtbl,
}
impl IBidiSpl2 {}
impl ::std::default::Default for IBidiSpl2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiSpl2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiSpl2")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiSpl2 {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IBidiSpl2 {}
unsafe impl ::windows::runtime::Abi for IBidiSpl2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiSpl2Vtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub BindDevice: isize,
    pub UnbindDevice: isize,
    pub SendRecvXMLString: isize,
    pub SendRecvXMLStream: isize,
}
impl IBidiSpl2Vtbl {}
impl ::std::default::Default for IBidiSpl2Vtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiSpl2Vtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiSpl2Vtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("BindDevice", &self.BindDevice)
            .field("UnbindDevice", &self.UnbindDevice)
            .field("SendRecvXMLString", &self.SendRecvXMLString)
            .field("SendRecvXMLStream", &self.SendRecvXMLStream)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiSpl2Vtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.BindDevice == other.BindDevice
            && self.UnbindDevice == other.UnbindDevice
            && self.SendRecvXMLString == other.SendRecvXMLString
            && self.SendRecvXMLStream == other.SendRecvXMLStream
    }
}
impl ::std::cmp::Eq for IBidiSpl2Vtbl {}
unsafe impl ::windows::runtime::Abi for IBidiSpl2Vtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IBidiSplVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub BindDevice: isize,
    pub UnbindDevice: isize,
    pub SendRecv: isize,
    pub MultiSendRecv: isize,
}
impl IBidiSplVtbl {}
impl ::std::default::Default for IBidiSplVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IBidiSplVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IBidiSplVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("BindDevice", &self.BindDevice)
            .field("UnbindDevice", &self.UnbindDevice)
            .field("SendRecv", &self.SendRecv)
            .field("MultiSendRecv", &self.MultiSendRecv)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IBidiSplVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.BindDevice == other.BindDevice
            && self.UnbindDevice == other.UnbindDevice
            && self.SendRecv == other.SendRecv
            && self.MultiSendRecv == other.MultiSendRecv
    }
}
impl ::std::cmp::Eq for IBidiSplVtbl {}
unsafe impl ::windows::runtime::Abi for IBidiSplVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IDI_CPSUI_ADVANCE: u32 = 64058u32;
pub const IDI_CPSUI_AUTOSEL: u32 = 64025u32;
pub const IDI_CPSUI_COLLATE: u32 = 64030u32;
pub const IDI_CPSUI_COLOR: u32 = 64040u32;
pub const IDI_CPSUI_COPY: u32 = 64046u32;
pub const IDI_CPSUI_DEVICE: u32 = 64060u32;
pub const IDI_CPSUI_DEVICE2: u32 = 64061u32;
pub const IDI_CPSUI_DEVICE_FEATURE: u32 = 64080u32;
pub const IDI_CPSUI_DITHER_COARSE: u32 = 64042u32;
pub const IDI_CPSUI_DITHER_FINE: u32 = 64043u32;
pub const IDI_CPSUI_DITHER_LINEART: u32 = 64044u32;
pub const IDI_CPSUI_DITHER_NONE: u32 = 64041u32;
pub const IDI_CPSUI_DOCUMENT: u32 = 64059u32;
pub const IDI_CPSUI_DUPLEX_HORZ: u32 = 64032u32;
pub const IDI_CPSUI_DUPLEX_HORZ_L: u32 = 64085u32;
pub const IDI_CPSUI_DUPLEX_NONE: u32 = 64031u32;
pub const IDI_CPSUI_DUPLEX_NONE_L: u32 = 64084u32;
pub const IDI_CPSUI_DUPLEX_VERT: u32 = 64033u32;
pub const IDI_CPSUI_DUPLEX_VERT_L: u32 = 64086u32;
pub const IDI_CPSUI_EMPTY: u32 = 64000u32;
pub const IDI_CPSUI_ENVELOPE: u32 = 64010u32;
pub const IDI_CPSUI_ENVELOPE_FEED: u32 = 64097u32;
pub const IDI_CPSUI_ERROR: u32 = 64050u32;
pub const IDI_CPSUI_FALSE: u32 = 64005u32;
pub const IDI_CPSUI_FAX: u32 = 64095u32;
pub const IDI_CPSUI_FONTCART: u32 = 64013u32;
pub const IDI_CPSUI_FONTCARTHDR: u32 = 64012u32;
pub const IDI_CPSUI_FONTCART_SLOT: u32 = 64098u32;
pub const IDI_CPSUI_FONTSUB: u32 = 64081u32;
pub const IDI_CPSUI_FORMTRAYASSIGN: u32 = 64076u32;
pub const IDI_CPSUI_GENERIC_ITEM: u32 = 64073u32;
pub const IDI_CPSUI_GENERIC_OPTION: u32 = 64072u32;
pub const IDI_CPSUI_GRAPHIC: u32 = 64057u32;
pub const IDI_CPSUI_HALFTONE_SETUP: u32 = 64048u32;
pub const IDI_CPSUI_HTCLRADJ: u32 = 64047u32;
pub const IDI_CPSUI_HT_DEVICE: u32 = 64017u32;
pub const IDI_CPSUI_HT_HOST: u32 = 64016u32;
pub const IDI_CPSUI_ICM_INTENT: u32 = 64053u32;
pub const IDI_CPSUI_ICM_METHOD: u32 = 64052u32;
pub const IDI_CPSUI_ICM_OPTION: u32 = 64051u32;
pub const IDI_CPSUI_ICONID_FIRST: u32 = 64000u32;
pub const IDI_CPSUI_ICONID_LAST: u32 = 64111u32;
pub const IDI_CPSUI_INSTALLABLE_OPTION: u32 = 64078u32;
pub const IDI_CPSUI_LANDSCAPE: u32 = 64023u32;
pub const IDI_CPSUI_LAYOUT_BMP_ARROWL: u32 = 64100u32;
pub const IDI_CPSUI_LAYOUT_BMP_ARROWLR: u32 = 64104u32;
pub const IDI_CPSUI_LAYOUT_BMP_ARROWS: u32 = 64101u32;
pub const IDI_CPSUI_LAYOUT_BMP_BOOKLETL: u32 = 64102u32;
pub const IDI_CPSUI_LAYOUT_BMP_BOOKLETL_NB: u32 = 64106u32;
pub const IDI_CPSUI_LAYOUT_BMP_BOOKLETP: u32 = 64103u32;
pub const IDI_CPSUI_LAYOUT_BMP_BOOKLETP_NB: u32 = 64107u32;
pub const IDI_CPSUI_LAYOUT_BMP_PORTRAIT: u32 = 64099u32;
pub const IDI_CPSUI_LAYOUT_BMP_ROT_PORT: u32 = 64105u32;
pub const IDI_CPSUI_LF_PEN_PLOTTER: u32 = 64087u32;
pub const IDI_CPSUI_LF_RASTER_PLOTTER: u32 = 64089u32;
pub const IDI_CPSUI_MANUAL_FEED: u32 = 64094u32;
pub const IDI_CPSUI_MEM: u32 = 64011u32;
pub const IDI_CPSUI_MONO: u32 = 64039u32;
pub const IDI_CPSUI_NO: u32 = 64003u32;
pub const IDI_CPSUI_NOTINSTALLED: u32 = 64069u32;
pub const IDI_CPSUI_NUP_BORDER: u32 = 64111u32;
pub const IDI_CPSUI_OFF: u32 = 64007u32;
pub const IDI_CPSUI_ON: u32 = 64008u32;
pub const IDI_CPSUI_OPTION: u32 = 64066u32;
pub const IDI_CPSUI_OPTION2: u32 = 64067u32;
pub const IDI_CPSUI_OUTBIN: u32 = 64055u32;
pub const IDI_CPSUI_OUTPUT: u32 = 64056u32;
pub const IDI_CPSUI_PAGE_PROTECT: u32 = 64096u32;
pub const IDI_CPSUI_PAPER_OUTPUT: u32 = 64009u32;
pub const IDI_CPSUI_PAPER_TRAY: u32 = 64026u32;
pub const IDI_CPSUI_PAPER_TRAY2: u32 = 64027u32;
pub const IDI_CPSUI_PAPER_TRAY3: u32 = 64028u32;
pub const IDI_CPSUI_PEN_CARROUSEL: u32 = 64092u32;
pub const IDI_CPSUI_PLOTTER_PEN: u32 = 64093u32;
pub const IDI_CPSUI_PORTRAIT: u32 = 64022u32;
pub const IDI_CPSUI_POSTSCRIPT: u32 = 64082u32;
pub const IDI_CPSUI_PRINTER: u32 = 64062u32;
pub const IDI_CPSUI_PRINTER2: u32 = 64063u32;
pub const IDI_CPSUI_PRINTER3: u32 = 64064u32;
pub const IDI_CPSUI_PRINTER4: u32 = 64065u32;
pub const IDI_CPSUI_PRINTER_FEATURE: u32 = 64079u32;
pub const IDI_CPSUI_PRINTER_FOLDER: u32 = 64077u32;
pub const IDI_CPSUI_QUESTION: u32 = 64075u32;
pub const IDI_CPSUI_RES_DRAFT: u32 = 64034u32;
pub const IDI_CPSUI_RES_HIGH: u32 = 64037u32;
pub const IDI_CPSUI_RES_LOW: u32 = 64035u32;
pub const IDI_CPSUI_RES_MEDIUM: u32 = 64036u32;
pub const IDI_CPSUI_RES_PRESENTATION: u32 = 64038u32;
pub const IDI_CPSUI_ROLL_PAPER: u32 = 64091u32;
pub const IDI_CPSUI_ROT_LAND: u32 = 64024u32;
pub const IDI_CPSUI_ROT_PORT: u32 = 64110u32;
pub const IDI_CPSUI_RUN_DIALOG: u32 = 64074u32;
pub const IDI_CPSUI_SCALING: u32 = 64045u32;
pub const IDI_CPSUI_SEL_NONE: u32 = 64001u32;
pub const IDI_CPSUI_SF_PEN_PLOTTER: u32 = 64088u32;
pub const IDI_CPSUI_SF_RASTER_PLOTTER: u32 = 64090u32;
pub const IDI_CPSUI_STAPLER_OFF: u32 = 64015u32;
pub const IDI_CPSUI_STAPLER_ON: u32 = 64014u32;
pub const IDI_CPSUI_STD_FORM: u32 = 64054u32;
pub const IDI_CPSUI_STOP: u32 = 64068u32;
pub const IDI_CPSUI_STOP_WARNING_OVERLAY: u32 = 64071u32;
pub const IDI_CPSUI_TELEPHONE: u32 = 64083u32;
pub const IDI_CPSUI_TRANSPARENT: u32 = 64029u32;
pub const IDI_CPSUI_TRUE: u32 = 64006u32;
pub const IDI_CPSUI_TT_DOWNLOADSOFT: u32 = 64019u32;
pub const IDI_CPSUI_TT_DOWNLOADVECT: u32 = 64020u32;
pub const IDI_CPSUI_TT_PRINTASGRAPHIC: u32 = 64018u32;
pub const IDI_CPSUI_TT_SUBDEV: u32 = 64021u32;
pub const IDI_CPSUI_WARNING: u32 = 64002u32;
pub const IDI_CPSUI_WARNING_OVERLAY: u32 = 64070u32;
pub const IDI_CPSUI_WATERMARK: u32 = 64049u32;
pub const IDI_CPSUI_YES: u32 = 64004u32;
pub const IDS_CPSUI_ABOUT: u32 = 64848u32;
pub const IDS_CPSUI_ADVANCED: u32 = 64722u32;
pub const IDS_CPSUI_ADVANCEDOCUMENT: u32 = 64716u32;
pub const IDS_CPSUI_ALL: u32 = 64841u32;
pub const IDS_CPSUI_AUTOSELECT: u32 = 64718u32;
pub const IDS_CPSUI_BACKTOFRONT: u32 = 64857u32;
pub const IDS_CPSUI_BOND: u32 = 64786u32;
pub const IDS_CPSUI_BOOKLET: u32 = 64873u32;
pub const IDS_CPSUI_BOOKLET_EDGE: u32 = 64888u32;
pub const IDS_CPSUI_BOOKLET_EDGE_LEFT: u32 = 64889u32;
pub const IDS_CPSUI_BOOKLET_EDGE_RIGHT: u32 = 64890u32;
pub const IDS_CPSUI_CASSETTE_TRAY: u32 = 64810u32;
pub const IDS_CPSUI_CHANGE: u32 = 64702u32;
pub const IDS_CPSUI_CHANGED: u32 = 64846u32;
pub const IDS_CPSUI_CHANGES: u32 = 64845u32;
pub const IDS_CPSUI_COARSE: u32 = 64787u32;
pub const IDS_CPSUI_COLLATE: u32 = 64756u32;
pub const IDS_CPSUI_COLLATED: u32 = 64757u32;
pub const IDS_CPSUI_COLON_SEP: u32 = 64707u32;
pub const IDS_CPSUI_COLOR: u32 = 64764u32;
pub const IDS_CPSUI_COLOR_APPERANCE: u32 = 64744u32;
pub const IDS_CPSUI_COPIES: u32 = 64831u32;
pub const IDS_CPSUI_COPY: u32 = 64830u32;
pub const IDS_CPSUI_DEFAULT: u32 = 64732u32;
pub const IDS_CPSUI_DEFAULTDOCUMENT: u32 = 64714u32;
pub const IDS_CPSUI_DEFAULT_TRAY: u32 = 64811u32;
pub const IDS_CPSUI_DEVICE: u32 = 64842u32;
pub const IDS_CPSUI_DEVICEOPTIONS: u32 = 64725u32;
pub const IDS_CPSUI_DEVICE_SETTINGS: u32 = 64852u32;
pub const IDS_CPSUI_DITHERING: u32 = 64752u32;
pub const IDS_CPSUI_DOCUMENT: u32 = 64715u32;
pub const IDS_CPSUI_DOWN_THEN_LEFT: u32 = 64882u32;
pub const IDS_CPSUI_DOWN_THEN_RIGHT: u32 = 64880u32;
pub const IDS_CPSUI_DRAFT: u32 = 64759u32;
pub const IDS_CPSUI_DUPLEX: u32 = 64745u32;
pub const IDS_CPSUI_ENVELOPE_TRAY: u32 = 64804u32;
pub const IDS_CPSUI_ENVMANUAL_TRAY: u32 = 64805u32;
pub const IDS_CPSUI_ERRDIFFUSE: u32 = 64790u32;
pub const IDS_CPSUI_ERROR: u32 = 64733u32;
pub const IDS_CPSUI_EXIST: u32 = 64736u32;
pub const IDS_CPSUI_FALSE: u32 = 64726u32;
pub const IDS_CPSUI_FAST: u32 = 64838u32;
pub const IDS_CPSUI_FAX: u32 = 64835u32;
pub const IDS_CPSUI_FINE: u32 = 64788u32;
pub const IDS_CPSUI_FORMNAME: u32 = 64747u32;
pub const IDS_CPSUI_FORMSOURCE: u32 = 64812u32;
pub const IDS_CPSUI_FORMTRAYASSIGN: u32 = 64798u32;
pub const IDS_CPSUI_FRONTTOBACK: u32 = 64856u32;
pub const IDS_CPSUI_GLOSSY: u32 = 64783u32;
pub const IDS_CPSUI_GRAPHIC: u32 = 64720u32;
pub const IDS_CPSUI_GRAYSCALE: u32 = 64765u32;
pub const IDS_CPSUI_HALFTONE: u32 = 64791u32;
pub const IDS_CPSUI_HALFTONE_SETUP: u32 = 64817u32;
pub const IDS_CPSUI_HIGH: u32 = 64762u32;
pub const IDS_CPSUI_HORIZONTAL: u32 = 64768u32;
pub const IDS_CPSUI_HTCLRADJ: u32 = 64792u32;
pub const IDS_CPSUI_ICM: u32 = 64748u32;
pub const IDS_CPSUI_ICMINTENT: u32 = 64750u32;
pub const IDS_CPSUI_ICMMETHOD: u32 = 64749u32;
pub const IDS_CPSUI_ICM_BLACKWHITE: u32 = 64776u32;
pub const IDS_CPSUI_ICM_COLORMETRIC: u32 = 64781u32;
pub const IDS_CPSUI_ICM_CONTRAST: u32 = 64780u32;
pub const IDS_CPSUI_ICM_NO: u32 = 64777u32;
pub const IDS_CPSUI_ICM_SATURATION: u32 = 64779u32;
pub const IDS_CPSUI_ICM_YES: u32 = 64778u32;
pub const IDS_CPSUI_INSTFONTCART: u32 = 64818u32;
pub const IDS_CPSUI_LANDSCAPE: u32 = 64754u32;
pub const IDS_CPSUI_LARGECAP_TRAY: u32 = 64809u32;
pub const IDS_CPSUI_LARGEFMT_TRAY: u32 = 64808u32;
pub const IDS_CPSUI_LBCB_NOSEL: u32 = 64712u32;
pub const IDS_CPSUI_LEFT_ANGLE: u32 = 64708u32;
pub const IDS_CPSUI_LEFT_SLOT: u32 = 64823u32;
pub const IDS_CPSUI_LEFT_THEN_DOWN: u32 = 64881u32;
pub const IDS_CPSUI_LINEART: u32 = 64789u32;
pub const IDS_CPSUI_LONG_SIDE: u32 = 64770u32;
pub const IDS_CPSUI_LOW: u32 = 64760u32;
pub const IDS_CPSUI_LOWER_TRAY: u32 = 64801u32;
pub const IDS_CPSUI_MAILBOX: u32 = 64829u32;
pub const IDS_CPSUI_MAKE: u32 = 64833u32;
pub const IDS_CPSUI_MANUALFEED: u32 = 64813u32;
pub const IDS_CPSUI_MANUAL_DUPLEX: u32 = 64883u32;
pub const IDS_CPSUI_MANUAL_DUPLEX_OFF: u32 = 64885u32;
pub const IDS_CPSUI_MANUAL_DUPLEX_ON: u32 = 64884u32;
pub const IDS_CPSUI_MANUAL_TRAY: u32 = 64803u32;
pub const IDS_CPSUI_MEDIA: u32 = 64751u32;
pub const IDS_CPSUI_MEDIUM: u32 = 64761u32;
pub const IDS_CPSUI_MIDDLE_TRAY: u32 = 64802u32;
pub const IDS_CPSUI_MONOCHROME: u32 = 64766u32;
pub const IDS_CPSUI_MORE: u32 = 64701u32;
pub const IDS_CPSUI_NO: u32 = 64728u32;
pub const IDS_CPSUI_NONE: u32 = 64734u32;
pub const IDS_CPSUI_NOT: u32 = 64735u32;
pub const IDS_CPSUI_NOTINSTALLED: u32 = 64737u32;
pub const IDS_CPSUI_NO_NAME: u32 = 64850u32;
pub const IDS_CPSUI_NUM_OF_COPIES: u32 = 64740u32;
pub const IDS_CPSUI_NUP: u32 = 64864u32;
pub const IDS_CPSUI_NUP_BORDER: u32 = 64891u32;
pub const IDS_CPSUI_NUP_BORDERED: u32 = 64892u32;
pub const IDS_CPSUI_NUP_DIRECTION: u32 = 64878u32;
pub const IDS_CPSUI_NUP_FOURUP: u32 = 64867u32;
pub const IDS_CPSUI_NUP_NINEUP: u32 = 64869u32;
pub const IDS_CPSUI_NUP_NORMAL: u32 = 64865u32;
pub const IDS_CPSUI_NUP_SIXTEENUP: u32 = 64870u32;
pub const IDS_CPSUI_NUP_SIXUP: u32 = 64868u32;
pub const IDS_CPSUI_NUP_TWOUP: u32 = 64866u32;
pub const IDS_CPSUI_OF: u32 = 64704u32;
pub const IDS_CPSUI_OFF: u32 = 64730u32;
pub const IDS_CPSUI_ON: u32 = 64731u32;
pub const IDS_CPSUI_ONLYONE: u32 = 64800u32;
pub const IDS_CPSUI_OPTION: u32 = 64703u32;
pub const IDS_CPSUI_OPTIONS: u32 = 64721u32;
pub const IDS_CPSUI_ORIENTATION: u32 = 64738u32;
pub const IDS_CPSUI_OUTBINASSIGN: u32 = 64796u32;
pub const IDS_CPSUI_OUTPUTBIN: u32 = 64863u32;
pub const IDS_CPSUI_PAGEORDER: u32 = 64855u32;
pub const IDS_CPSUI_PAGEPROTECT: u32 = 64816u32;
pub const IDS_CPSUI_PAPER_OUTPUT: u32 = 64719u32;
pub const IDS_CPSUI_PERCENT: u32 = 64711u32;
pub const IDS_CPSUI_PLOT: u32 = 64836u32;
pub const IDS_CPSUI_PORTRAIT: u32 = 64753u32;
pub const IDS_CPSUI_POSTER: u32 = 64874u32;
pub const IDS_CPSUI_POSTER_2x2: u32 = 64875u32;
pub const IDS_CPSUI_POSTER_3x3: u32 = 64876u32;
pub const IDS_CPSUI_POSTER_4x4: u32 = 64877u32;
pub const IDS_CPSUI_PRESENTATION: u32 = 64763u32;
pub const IDS_CPSUI_PRINT: u32 = 64834u32;
pub const IDS_CPSUI_PRINTER: u32 = 64717u32;
pub const IDS_CPSUI_PRINTERMEM_KB: u32 = 64814u32;
pub const IDS_CPSUI_PRINTERMEM_MB: u32 = 64815u32;
pub const IDS_CPSUI_PRINTFLDSETTING: u32 = 64758u32;
pub const IDS_CPSUI_PRINTQUALITY: u32 = 64742u32;
pub const IDS_CPSUI_PROPERTIES: u32 = 64713u32;
pub const IDS_CPSUI_QUALITY_BEST: u32 = 64861u32;
pub const IDS_CPSUI_QUALITY_BETTER: u32 = 64860u32;
pub const IDS_CPSUI_QUALITY_CUSTOM: u32 = 64862u32;
pub const IDS_CPSUI_QUALITY_DRAFT: u32 = 64859u32;
pub const IDS_CPSUI_QUALITY_SETTINGS: u32 = 64858u32;
pub const IDS_CPSUI_RANGE_FROM: u32 = 64705u32;
pub const IDS_CPSUI_REGULAR: u32 = 64785u32;
pub const IDS_CPSUI_RESET: u32 = 64840u32;
pub const IDS_CPSUI_RESOLUTION: u32 = 64743u32;
pub const IDS_CPSUI_REVERT: u32 = 64844u32;
pub const IDS_CPSUI_RIGHT_ANGLE: u32 = 64709u32;
pub const IDS_CPSUI_RIGHT_SLOT: u32 = 64824u32;
pub const IDS_CPSUI_RIGHT_THEN_DOWN: u32 = 64879u32;
pub const IDS_CPSUI_ROTATED: u32 = 64839u32;
pub const IDS_CPSUI_ROT_LAND: u32 = 64755u32;
pub const IDS_CPSUI_ROT_PORT: u32 = 64886u32;
pub const IDS_CPSUI_SCALING: u32 = 64739u32;
pub const IDS_CPSUI_SETTING: u32 = 64851u32;
pub const IDS_CPSUI_SETTINGS: u32 = 64843u32;
pub const IDS_CPSUI_SETUP: u32 = 64700u32;
pub const IDS_CPSUI_SHORT_SIDE: u32 = 64771u32;
pub const IDS_CPSUI_SIDE1: u32 = 64871u32;
pub const IDS_CPSUI_SIDE2: u32 = 64872u32;
pub const IDS_CPSUI_SIMPLEX: u32 = 64767u32;
pub const IDS_CPSUI_SLASH_SEP: u32 = 64710u32;
pub const IDS_CPSUI_SLOT1: u32 = 64819u32;
pub const IDS_CPSUI_SLOT2: u32 = 64820u32;
pub const IDS_CPSUI_SLOT3: u32 = 64821u32;
pub const IDS_CPSUI_SLOT4: u32 = 64822u32;
pub const IDS_CPSUI_SLOW: u32 = 64837u32;
pub const IDS_CPSUI_SMALLFMT_TRAY: u32 = 64807u32;
pub const IDS_CPSUI_SOURCE: u32 = 64741u32;
pub const IDS_CPSUI_STACKER: u32 = 64828u32;
pub const IDS_CPSUI_STANDARD: u32 = 64782u32;
pub const IDS_CPSUI_STAPLE: u32 = 64887u32;
pub const IDS_CPSUI_STAPLER: u32 = 64825u32;
pub const IDS_CPSUI_STAPLER_OFF: u32 = 64827u32;
pub const IDS_CPSUI_STAPLER_ON: u32 = 64826u32;
pub const IDS_CPSUI_STDDOCPROPTAB: u32 = 64723u32;
pub const IDS_CPSUI_STDDOCPROPTAB1: u32 = 64853u32;
pub const IDS_CPSUI_STDDOCPROPTAB2: u32 = 64854u32;
pub const IDS_CPSUI_STDDOCPROPTVTAB: u32 = 64724u32;
pub const IDS_CPSUI_STRID_FIRST: u32 = 64700u32;
pub const IDS_CPSUI_STRID_LAST: u32 = 64892u32;
pub const IDS_CPSUI_TO: u32 = 64706u32;
pub const IDS_CPSUI_TOTAL: u32 = 64832u32;
pub const IDS_CPSUI_TRACTOR_TRAY: u32 = 64806u32;
pub const IDS_CPSUI_TRANSPARENCY: u32 = 64784u32;
pub const IDS_CPSUI_TRUE: u32 = 64727u32;
pub const IDS_CPSUI_TTOPTION: u32 = 64746u32;
pub const IDS_CPSUI_TT_DOWNLOADSOFT: u32 = 64773u32;
pub const IDS_CPSUI_TT_DOWNLOADVECT: u32 = 64774u32;
pub const IDS_CPSUI_TT_PRINTASGRAPHIC: u32 = 64772u32;
pub const IDS_CPSUI_TT_SUBDEV: u32 = 64775u32;
pub const IDS_CPSUI_UPPER_TRAY: u32 = 64799u32;
pub const IDS_CPSUI_USE_DEVICE_HT: u32 = 64794u32;
pub const IDS_CPSUI_USE_HOST_HT: u32 = 64793u32;
pub const IDS_CPSUI_USE_PRINTER_HT: u32 = 64795u32;
pub const IDS_CPSUI_VERSION: u32 = 64849u32;
pub const IDS_CPSUI_VERTICAL: u32 = 64769u32;
pub const IDS_CPSUI_WARNING: u32 = 64847u32;
pub const IDS_CPSUI_WATERMARK: u32 = 64797u32;
pub const IDS_CPSUI_YES: u32 = 64729u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IFixedDocument {
    pub lpVtbl: *mut IFixedDocumentVtbl,
}
impl IFixedDocument {}
impl ::std::default::Default for IFixedDocument {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IFixedDocument {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IFixedDocument")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IFixedDocument {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IFixedDocument {}
unsafe impl ::windows::runtime::Abi for IFixedDocument {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IFixedDocumentSequence {
    pub lpVtbl: *mut IFixedDocumentSequenceVtbl,
}
impl IFixedDocumentSequence {}
impl ::std::default::Default for IFixedDocumentSequence {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IFixedDocumentSequence {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IFixedDocumentSequence")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IFixedDocumentSequence {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IFixedDocumentSequence {}
unsafe impl ::windows::runtime::Abi for IFixedDocumentSequence {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IFixedDocumentSequenceVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetPrintTicket: isize,
    pub SetPrintTicket: isize,
}
impl IFixedDocumentSequenceVtbl {}
impl ::std::default::Default for IFixedDocumentSequenceVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IFixedDocumentSequenceVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IFixedDocumentSequenceVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetPrintTicket", &self.GetPrintTicket)
            .field("SetPrintTicket", &self.SetPrintTicket)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IFixedDocumentSequenceVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetPrintTicket == other.GetPrintTicket
            && self.SetPrintTicket == other.SetPrintTicket
    }
}
impl ::std::cmp::Eq for IFixedDocumentSequenceVtbl {}
unsafe impl ::windows::runtime::Abi for IFixedDocumentSequenceVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IFixedDocumentVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetPrintTicket: isize,
    pub SetPrintTicket: isize,
}
impl IFixedDocumentVtbl {}
impl ::std::default::Default for IFixedDocumentVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IFixedDocumentVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IFixedDocumentVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetPrintTicket", &self.GetPrintTicket)
            .field("SetPrintTicket", &self.SetPrintTicket)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IFixedDocumentVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetPrintTicket == other.GetPrintTicket
            && self.SetPrintTicket == other.SetPrintTicket
    }
}
impl ::std::cmp::Eq for IFixedDocumentVtbl {}
unsafe impl ::windows::runtime::Abi for IFixedDocumentVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IFixedPage {
    pub lpVtbl: *mut IFixedPageVtbl,
}
impl IFixedPage {}
impl ::std::default::Default for IFixedPage {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IFixedPage {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IFixedPage")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IFixedPage {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IFixedPage {}
unsafe impl ::windows::runtime::Abi for IFixedPage {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IFixedPageVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
    pub GetPrintTicket: isize,
    pub GetPagePart: isize,
    pub GetWriteStream: isize,
    pub SetPrintTicket: isize,
    pub SetPagePart: isize,
    pub DeleteResource: isize,
    pub GetXpsPartIterator: isize,
}
impl IFixedPageVtbl {}
impl ::std::default::Default for IFixedPageVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IFixedPageVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IFixedPageVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .field("GetPrintTicket", &self.GetPrintTicket)
            .field("GetPagePart", &self.GetPagePart)
            .field("GetWriteStream", &self.GetWriteStream)
            .field("SetPrintTicket", &self.SetPrintTicket)
            .field("SetPagePart", &self.SetPagePart)
            .field("DeleteResource", &self.DeleteResource)
            .field("GetXpsPartIterator", &self.GetXpsPartIterator)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IFixedPageVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
            && self.GetPrintTicket == other.GetPrintTicket
            && self.GetPagePart == other.GetPagePart
            && self.GetWriteStream == other.GetWriteStream
            && self.SetPrintTicket == other.SetPrintTicket
            && self.SetPagePart == other.SetPagePart
            && self.DeleteResource == other.DeleteResource
            && self.GetXpsPartIterator == other.GetXpsPartIterator
    }
}
impl ::std::cmp::Eq for IFixedPageVtbl {}
unsafe impl ::windows::runtime::Abi for IFixedPageVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IImgCreateErrorInfo {
    pub lpVtbl: *mut IImgCreateErrorInfoVtbl,
}
impl IImgCreateErrorInfo {}
impl ::std::default::Default for IImgCreateErrorInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IImgCreateErrorInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IImgCreateErrorInfo")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IImgCreateErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IImgCreateErrorInfo {}
unsafe impl ::windows::runtime::Abi for IImgCreateErrorInfo {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IImgCreateErrorInfoVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub SetGUID: isize,
    pub SetSource: isize,
    pub SetDescription: isize,
    pub SetHelpFile: isize,
    pub SetHelpContext: isize,
    pub AttachToErrorInfo: isize,
}
impl IImgCreateErrorInfoVtbl {}
impl ::std::default::Default for IImgCreateErrorInfoVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IImgCreateErrorInfoVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IImgCreateErrorInfoVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("SetGUID", &self.SetGUID)
            .field("SetSource", &self.SetSource)
            .field("SetDescription", &self.SetDescription)
            .field("SetHelpFile", &self.SetHelpFile)
            .field("SetHelpContext", &self.SetHelpContext)
            .field("AttachToErrorInfo", &self.AttachToErrorInfo)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IImgCreateErrorInfoVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.SetGUID == other.SetGUID
            && self.SetSource == other.SetSource
            && self.SetDescription == other.SetDescription
            && self.SetHelpFile == other.SetHelpFile
            && self.SetHelpContext == other.SetHelpContext
            && self.AttachToErrorInfo == other.AttachToErrorInfo
    }
}
impl ::std::cmp::Eq for IImgCreateErrorInfoVtbl {}
unsafe impl ::windows::runtime::Abi for IImgCreateErrorInfoVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IImgErrorInfo {
    pub lpVtbl: *mut IImgErrorInfoVtbl,
}
impl IImgErrorInfo {}
impl ::std::default::Default for IImgErrorInfo {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IImgErrorInfo {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IImgErrorInfo")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IImgErrorInfo {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IImgErrorInfo {}
unsafe impl ::windows::runtime::Abi for IImgErrorInfo {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IImgErrorInfoVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetGUID: isize,
    pub GetSource: isize,
    pub GetDescription: isize,
    pub GetHelpFile: isize,
    pub GetHelpContext: isize,
    pub GetDeveloperDescription: isize,
    pub GetUserErrorId: isize,
    pub GetUserParameterCount: isize,
    pub GetUserParameter: isize,
    pub GetUserFallback: isize,
    pub GetExceptionId: isize,
    pub DetachErrorInfo: isize,
}
impl IImgErrorInfoVtbl {}
impl ::std::default::Default for IImgErrorInfoVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IImgErrorInfoVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IImgErrorInfoVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetGUID", &self.GetGUID)
            .field("GetSource", &self.GetSource)
            .field("GetDescription", &self.GetDescription)
            .field("GetHelpFile", &self.GetHelpFile)
            .field("GetHelpContext", &self.GetHelpContext)
            .field("GetDeveloperDescription", &self.GetDeveloperDescription)
            .field("GetUserErrorId", &self.GetUserErrorId)
            .field("GetUserParameterCount", &self.GetUserParameterCount)
            .field("GetUserParameter", &self.GetUserParameter)
            .field("GetUserFallback", &self.GetUserFallback)
            .field("GetExceptionId", &self.GetExceptionId)
            .field("DetachErrorInfo", &self.DetachErrorInfo)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IImgErrorInfoVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetGUID == other.GetGUID
            && self.GetSource == other.GetSource
            && self.GetDescription == other.GetDescription
            && self.GetHelpFile == other.GetHelpFile
            && self.GetHelpContext == other.GetHelpContext
            && self.GetDeveloperDescription == other.GetDeveloperDescription
            && self.GetUserErrorId == other.GetUserErrorId
            && self.GetUserParameterCount == other.GetUserParameterCount
            && self.GetUserParameter == other.GetUserParameter
            && self.GetUserFallback == other.GetUserFallback
            && self.GetExceptionId == other.GetExceptionId
            && self.DetachErrorInfo == other.DetachErrorInfo
    }
}
impl ::std::cmp::Eq for IImgErrorInfoVtbl {}
unsafe impl ::windows::runtime::Abi for IImgErrorInfoVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IInterFilterCommunicator {
    pub lpVtbl: *mut IInterFilterCommunicatorVtbl,
}
impl IInterFilterCommunicator {}
impl ::std::default::Default for IInterFilterCommunicator {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IInterFilterCommunicator {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IInterFilterCommunicator")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IInterFilterCommunicator {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IInterFilterCommunicator {}
unsafe impl ::windows::runtime::Abi for IInterFilterCommunicator {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IInterFilterCommunicatorVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub RequestReader: isize,
    pub RequestWriter: isize,
}
impl IInterFilterCommunicatorVtbl {}
impl ::std::default::Default for IInterFilterCommunicatorVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IInterFilterCommunicatorVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IInterFilterCommunicatorVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("RequestReader", &self.RequestReader)
            .field("RequestWriter", &self.RequestWriter)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IInterFilterCommunicatorVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.RequestReader == other.RequestReader
            && self.RequestWriter == other.RequestWriter
    }
}
impl ::std::cmp::Eq for IInterFilterCommunicatorVtbl {}
unsafe impl ::windows::runtime::Abi for IInterFilterCommunicatorVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct INSERTPSUIPAGE_INFO {
    pub cbSize: u16,
    pub Type: u8,
    pub Mode: u8,
    pub dwData1: usize,
    pub dwData2: usize,
    pub dwData3: usize,
}
impl INSERTPSUIPAGE_INFO {}
impl ::std::default::Default for INSERTPSUIPAGE_INFO {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for INSERTPSUIPAGE_INFO {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("INSERTPSUIPAGE_INFO")
            .field("cbSize", &self.cbSize)
            .field("Type", &self.Type)
            .field("Mode", &self.Mode)
            .field("dwData1", &self.dwData1)
            .field("dwData2", &self.dwData2)
            .field("dwData3", &self.dwData3)
            .finish()
    }
}
impl ::std::cmp::PartialEq for INSERTPSUIPAGE_INFO {
    fn eq(&self, other: &Self) -> bool {
        self.cbSize == other.cbSize
            && self.Type == other.Type
            && self.Mode == other.Mode
            && self.dwData1 == other.dwData1
            && self.dwData2 == other.dwData2
            && self.dwData3 == other.dwData3
    }
}
impl ::std::cmp::Eq for INSERTPSUIPAGE_INFO {}
unsafe impl ::windows::runtime::Abi for INSERTPSUIPAGE_INFO {
    type Abi = Self;
    type DefaultType = Self;
}
pub const INSPSUIPAGE_MODE_AFTER: u32 = 1u32;
pub const INSPSUIPAGE_MODE_BEFORE: u32 = 0u32;
pub const INSPSUIPAGE_MODE_FIRST_CHILD: u32 = 2u32;
pub const INSPSUIPAGE_MODE_INDEX: u32 = 4u32;
pub const INSPSUIPAGE_MODE_LAST_CHILD: u32 = 3u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct INVOC {
    pub dwCount: u32,
    pub loOffset: u32,
}
impl INVOC {}
impl ::std::default::Default for INVOC {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for INVOC {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("INVOC")
            .field("dwCount", &self.dwCount)
            .field("loOffset", &self.loOffset)
            .finish()
    }
}
impl ::std::cmp::PartialEq for INVOC {
    fn eq(&self, other: &Self) -> bool {
        self.dwCount == other.dwCount && self.loOffset == other.loOffset
    }
}
impl ::std::cmp::Eq for INVOC {}
unsafe impl ::windows::runtime::Abi for INVOC {
    type Abi = Self;
    type DefaultType = Self;
}
pub const IOCTL_USBPRINT_ADD_CHILD_DEVICE: u32 = 2228316u32;
pub const IOCTL_USBPRINT_ADD_MSIPP_COMPAT_ID: u32 = 2228308u32;
pub const IOCTL_USBPRINT_CYCLE_PORT: u32 = 2228320u32;
pub const IOCTL_USBPRINT_GET_1284_ID: u32 = 2228276u32;
pub const IOCTL_USBPRINT_GET_INTERFACE_TYPE: u32 = 2228300u32;
pub const IOCTL_USBPRINT_GET_LPT_STATUS: u32 = 2228272u32;
pub const IOCTL_USBPRINT_GET_PROTOCOL: u32 = 2228292u32;
pub const IOCTL_USBPRINT_SET_DEVICE_ID: u32 = 2228312u32;
pub const IOCTL_USBPRINT_SET_PORT_NUMBER: u32 = 2228304u32;
pub const IOCTL_USBPRINT_SET_PROTOCOL: u32 = 2228296u32;
pub const IOCTL_USBPRINT_SOFT_RESET: u32 = 2228288u32;
pub const IOCTL_USBPRINT_VENDOR_GET_COMMAND: u32 = 2228284u32;
pub const IOCTL_USBPRINT_VENDOR_SET_COMMAND: u32 = 2228280u32;
pub const IPDFP_COPY_ALL_FILES: u32 = 1u32;
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartBase {
    pub lpVtbl: *mut IPartBaseVtbl,
}
impl IPartBase {}
impl ::std::default::Default for IPartBase {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartBase {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartBase")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartBase {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartBase {}
unsafe impl ::windows::runtime::Abi for IPartBase {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartBaseVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
}
impl IPartBaseVtbl {}
impl ::std::default::Default for IPartBaseVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartBaseVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartBaseVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartBaseVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
    }
}
impl ::std::cmp::Eq for IPartBaseVtbl {}
unsafe impl ::windows::runtime::Abi for IPartBaseVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartColorProfile {
    pub lpVtbl: *mut IPartColorProfileVtbl,
}
impl IPartColorProfile {}
impl ::std::default::Default for IPartColorProfile {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartColorProfile {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartColorProfile")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartColorProfile {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartColorProfile {}
unsafe impl ::windows::runtime::Abi for IPartColorProfile {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartColorProfileVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
}
impl IPartColorProfileVtbl {}
impl ::std::default::Default for IPartColorProfileVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartColorProfileVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartColorProfileVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartColorProfileVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
    }
}
impl ::std::cmp::Eq for IPartColorProfileVtbl {}
unsafe impl ::windows::runtime::Abi for IPartColorProfileVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartDiscardControl {
    pub lpVtbl: *mut IPartDiscardControlVtbl,
}
impl IPartDiscardControl {}
impl ::std::default::Default for IPartDiscardControl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartDiscardControl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartDiscardControl")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartDiscardControl {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartDiscardControl {}
unsafe impl ::windows::runtime::Abi for IPartDiscardControl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartDiscardControlVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetDiscardProperties: isize,
}
impl IPartDiscardControlVtbl {}
impl ::std::default::Default for IPartDiscardControlVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartDiscardControlVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartDiscardControlVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetDiscardProperties", &self.GetDiscardProperties)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartDiscardControlVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetDiscardProperties == other.GetDiscardProperties
    }
}
impl ::std::cmp::Eq for IPartDiscardControlVtbl {}
unsafe impl ::windows::runtime::Abi for IPartDiscardControlVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartFont {
    pub lpVtbl: *mut IPartFontVtbl,
}
impl IPartFont {}
impl ::std::default::Default for IPartFont {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartFont {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartFont")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartFont {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartFont {}
unsafe impl ::windows::runtime::Abi for IPartFont {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartFont2 {
    pub lpVtbl: *mut IPartFont2Vtbl,
}
impl IPartFont2 {}
impl ::std::default::Default for IPartFont2 {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartFont2 {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartFont2")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartFont2 {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartFont2 {}
unsafe impl ::windows::runtime::Abi for IPartFont2 {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartFont2Vtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
    pub GetFontProperties: isize,
    pub SetFontContent: isize,
    pub SetFontOptions: isize,
    pub GetFontRestriction: isize,
}
impl IPartFont2Vtbl {}
impl ::std::default::Default for IPartFont2Vtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartFont2Vtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartFont2Vtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .field("GetFontProperties", &self.GetFontProperties)
            .field("SetFontContent", &self.SetFontContent)
            .field("SetFontOptions", &self.SetFontOptions)
            .field("GetFontRestriction", &self.GetFontRestriction)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartFont2Vtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
            && self.GetFontProperties == other.GetFontProperties
            && self.SetFontContent == other.SetFontContent
            && self.SetFontOptions == other.SetFontOptions
            && self.GetFontRestriction == other.GetFontRestriction
    }
}
impl ::std::cmp::Eq for IPartFont2Vtbl {}
unsafe impl ::windows::runtime::Abi for IPartFont2Vtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartFontVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
    pub GetFontProperties: isize,
    pub SetFontContent: isize,
    pub SetFontOptions: isize,
}
impl IPartFontVtbl {}
impl ::std::default::Default for IPartFontVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartFontVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartFontVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .field("GetFontProperties", &self.GetFontProperties)
            .field("SetFontContent", &self.SetFontContent)
            .field("SetFontOptions", &self.SetFontOptions)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartFontVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
            && self.GetFontProperties == other.GetFontProperties
            && self.SetFontContent == other.SetFontContent
            && self.SetFontOptions == other.SetFontOptions
    }
}
impl ::std::cmp::Eq for IPartFontVtbl {}
unsafe impl ::windows::runtime::Abi for IPartFontVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartImage {
    pub lpVtbl: *mut IPartImageVtbl,
}
impl IPartImage {}
impl ::std::default::Default for IPartImage {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartImage {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartImage")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartImage {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartImage {}
unsafe impl ::windows::runtime::Abi for IPartImage {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartImageVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
    pub GetImageProperties: isize,
    pub SetImageContent: isize,
}
impl IPartImageVtbl {}
impl ::std::default::Default for IPartImageVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartImageVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartImageVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .field("GetImageProperties", &self.GetImageProperties)
            .field("SetImageContent", &self.SetImageContent)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartImageVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
            && self.GetImageProperties == other.GetImageProperties
            && self.SetImageContent == other.SetImageContent
    }
}
impl ::std::cmp::Eq for IPartImageVtbl {}
unsafe impl ::windows::runtime::Abi for IPartImageVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartPrintTicket {
    pub lpVtbl: *mut IPartPrintTicketVtbl,
}
impl IPartPrintTicket {}
impl ::std::default::Default for IPartPrintTicket {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartPrintTicket {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartPrintTicket")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartPrintTicket {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartPrintTicket {}
unsafe impl ::windows::runtime::Abi for IPartPrintTicket {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartPrintTicketVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
}
impl IPartPrintTicketVtbl {}
impl ::std::default::Default for IPartPrintTicketVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartPrintTicketVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartPrintTicketVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartPrintTicketVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
    }
}
impl ::std::cmp::Eq for IPartPrintTicketVtbl {}
unsafe impl ::windows::runtime::Abi for IPartPrintTicketVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartResourceDictionary {
    pub lpVtbl: *mut IPartResourceDictionaryVtbl,
}
impl IPartResourceDictionary {}
impl ::std::default::Default for IPartResourceDictionary {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartResourceDictionary {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartResourceDictionary")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartResourceDictionary {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartResourceDictionary {}
unsafe impl ::windows::runtime::Abi for IPartResourceDictionary {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartResourceDictionaryVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
}
impl IPartResourceDictionaryVtbl {}
impl ::std::default::Default for IPartResourceDictionaryVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartResourceDictionaryVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartResourceDictionaryVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartResourceDictionaryVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
    }
}
impl ::std::cmp::Eq for IPartResourceDictionaryVtbl {}
unsafe impl ::windows::runtime::Abi for IPartResourceDictionaryVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartThumbnail {
    pub lpVtbl: *mut IPartThumbnailVtbl,
}
impl IPartThumbnail {}
impl ::std::default::Default for IPartThumbnail {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartThumbnail {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartThumbnail")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartThumbnail {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPartThumbnail {}
unsafe impl ::windows::runtime::Abi for IPartThumbnail {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPartThumbnailVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetUri: isize,
    pub GetStream: isize,
    pub GetPartCompression: isize,
    pub SetPartCompression: isize,
    pub GetThumbnailProperties: isize,
    pub SetThumbnailContent: isize,
}
impl IPartThumbnailVtbl {}
impl ::std::default::Default for IPartThumbnailVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPartThumbnailVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPartThumbnailVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetUri", &self.GetUri)
            .field("GetStream", &self.GetStream)
            .field("GetPartCompression", &self.GetPartCompression)
            .field("SetPartCompression", &self.SetPartCompression)
            .field("GetThumbnailProperties", &self.GetThumbnailProperties)
            .field("SetThumbnailContent", &self.SetThumbnailContent)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPartThumbnailVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetUri == other.GetUri
            && self.GetStream == other.GetStream
            && self.GetPartCompression == other.GetPartCompression
            && self.SetPartCompression == other.SetPartCompression
            && self.GetThumbnailProperties == other.GetThumbnailProperties
            && self.SetThumbnailContent == other.SetThumbnailContent
    }
}
impl ::std::cmp::Eq for IPartThumbnailVtbl {}
unsafe impl ::windows::runtime::Abi for IPartThumbnailVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncCookie(::windows::runtime::IUnknown);
impl IPrintAsyncCookie {
    pub unsafe fn FinishAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    pub unsafe fn CancelAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncCookie {
    type Vtable = IPrintAsyncCookie_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IPrintAsyncCookie> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncCookie) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncCookie> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncCookie) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintAsyncCookie {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintAsyncCookie {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncCookie_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncNewChannelCookie(::windows::runtime::IUnknown);
impl IPrintAsyncNewChannelCookie {
    pub unsafe fn FinishAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    pub unsafe fn CancelAsyncCall(
        &self,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
        )
        .ok()
    }
    pub unsafe fn FinishAsyncCallWithData(
        &self,
        param0: *const ::std::option::Option<IPrintAsyncNotifyChannel>,
        param1: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncNewChannelCookie {
    type Vtable = IPrintAsyncNewChannelCookie_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IPrintAsyncNewChannelCookie> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncNewChannelCookie) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNewChannelCookie> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncNewChannelCookie) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintAsyncNewChannelCookie
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintAsyncNewChannelCookie
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintAsyncNewChannelCookie> for IPrintAsyncCookie {
    fn from(value: IPrintAsyncNewChannelCookie) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNewChannelCookie> for IPrintAsyncCookie {
    fn from(value: &IPrintAsyncNewChannelCookie) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncCookie> for IPrintAsyncNewChannelCookie {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncCookie> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintAsyncCookie>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncCookie> for &IPrintAsyncNewChannelCookie {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncCookie> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintAsyncCookie>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncNewChannelCookie_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: *const ::windows::runtime::RawPtr,
        param1: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncNotify(::windows::runtime::IUnknown);
impl IPrintAsyncNotify {
    pub unsafe fn CreatePrintAsyncNotifyChannel<
        'a,
        Param4: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyCallback>,
    >(
        &self,
        param0: u32,
        param1: *const ::windows::runtime::GUID,
        param2: PrintAsyncNotifyUserFilter,
        param3: PrintAsyncNotifyConversationStyle,
        param4: Param4,
    ) -> ::windows::runtime::Result<IPrintAsyncNotifyChannel> {
        let mut result__: <IPrintAsyncNotifyChannel as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
            ::std::mem::transmute(param3),
            param4.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintAsyncNotifyChannel>(result__)
    }
    pub unsafe fn CreatePrintAsyncNotifyRegistration<
        'a,
        Param3: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyCallback>,
    >(
        &self,
        param0: *const ::windows::runtime::GUID,
        param1: PrintAsyncNotifyUserFilter,
        param2: PrintAsyncNotifyConversationStyle,
        param3: Param3,
    ) -> ::windows::runtime::Result<IPrintAsyncNotifyRegistration> {
        let mut result__: <IPrintAsyncNotifyRegistration as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(param0),
            ::std::mem::transmute(param1),
            ::std::mem::transmute(param2),
            param3.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintAsyncNotifyRegistration>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncNotify {
    type Vtable = IPrintAsyncNotify_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1395136759,
        37403,
        20402,
        [191, 248, 47, 79, 213, 46, 190, 191],
    );
}
impl ::std::convert::From<IPrintAsyncNotify> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncNotify) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNotify> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncNotify) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintAsyncNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintAsyncNotify {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncNotify_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: u32,
        param1: *const ::windows::runtime::GUID,
        param2: PrintAsyncNotifyUserFilter,
        param3: PrintAsyncNotifyConversationStyle,
        param4: ::windows::runtime::RawPtr,
        param5: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: *const ::windows::runtime::GUID,
        param1: PrintAsyncNotifyUserFilter,
        param2: PrintAsyncNotifyConversationStyle,
        param3: ::windows::runtime::RawPtr,
        param4: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncNotifyCallback(::windows::runtime::IUnknown);
impl IPrintAsyncNotifyCallback {
    pub unsafe fn OnEventNotify<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyChannel>,
        Param1: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
    >(
        &self,
        pchannel: Param0,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pchannel.into_param().abi(),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ChannelClosed<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyChannel>,
        Param1: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
    >(
        &self,
        pchannel: Param0,
        pdata: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pchannel.into_param().abi(),
            pdata.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncNotifyCallback {
    type Vtable = IPrintAsyncNotifyCallback_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2112828609,
        40338,
        19609,
        [179, 179, 219, 148, 169, 212, 25, 27],
    );
}
impl ::std::convert::From<IPrintAsyncNotifyCallback> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncNotifyCallback) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNotifyCallback> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncNotifyCallback) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintAsyncNotifyCallback
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintAsyncNotifyCallback
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncNotifyCallback_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchannel: ::windows::runtime::RawPtr,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pchannel: ::windows::runtime::RawPtr,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncNotifyChannel(::windows::runtime::IUnknown);
impl IPrintAsyncNotifyChannel {
    pub unsafe fn SendNotification<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
    >(
        &self,
        pdata: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            pdata.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CloseChannel<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyDataObject>,
    >(
        &self,
        pdata: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            pdata.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncNotifyChannel {
    type Vtable = IPrintAsyncNotifyChannel_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1246769585,
        7999,
        19888,
        [164, 98, 69, 48, 237, 139, 4, 81],
    );
}
impl ::std::convert::From<IPrintAsyncNotifyChannel> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncNotifyChannel) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNotifyChannel> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncNotifyChannel) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintAsyncNotifyChannel
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintAsyncNotifyChannel
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncNotifyChannel_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdata: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncNotifyDataObject(::windows::runtime::IUnknown);
impl IPrintAsyncNotifyDataObject {
    pub unsafe fn AcquireData(
        &self,
        ppnotificationdata: *mut *mut u8,
        psize: *mut u32,
        ppschema: *mut *mut ::windows::runtime::GUID,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppnotificationdata),
            ::std::mem::transmute(psize),
            ::std::mem::transmute(ppschema),
        )
        .ok()
    }
    pub unsafe fn ReleaseData(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncNotifyDataObject {
    type Vtable = IPrintAsyncNotifyDataObject_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2010075454,
        23881,
        18313,
        [159, 48, 208, 130, 43, 51, 92, 13],
    );
}
impl ::std::convert::From<IPrintAsyncNotifyDataObject> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncNotifyDataObject) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNotifyDataObject> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncNotifyDataObject) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintAsyncNotifyDataObject
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintAsyncNotifyDataObject
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncNotifyDataObject_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppnotificationdata: *mut *mut u8,
        psize: *mut u32,
        ppschema: *mut *mut ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncNotifyRegistration(::windows::runtime::IUnknown);
impl IPrintAsyncNotifyRegistration {
    pub unsafe fn RegisterForNotifications(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UnregisterForNotifications(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncNotifyRegistration {
    type Vtable = IPrintAsyncNotifyRegistration_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        258942902,
        28550,
        17809,
        [146, 3, 100, 195, 191, 173, 237, 254],
    );
}
impl ::std::convert::From<IPrintAsyncNotifyRegistration> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncNotifyRegistration) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNotifyRegistration> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncNotifyRegistration) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncNotifyRegistration_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintAsyncNotifyServerReferral(::windows::runtime::IUnknown);
impl IPrintAsyncNotifyServerReferral {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetServerReferral(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::PWSTR> {
        let mut result__: <super::super::Foundation::PWSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PWSTR>(result__)
    }
    pub unsafe fn AsyncGetServerReferral<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAsyncGetSrvReferralCookie>,
    >(
        &self,
        param0: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            param0.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetServerReferral<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        prmtserverreferral: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            prmtserverreferral.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintAsyncNotifyServerReferral {
    type Vtable = IPrintAsyncNotifyServerReferral_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IPrintAsyncNotifyServerReferral> for ::windows::runtime::IUnknown {
    fn from(value: IPrintAsyncNotifyServerReferral) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintAsyncNotifyServerReferral> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintAsyncNotifyServerReferral) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintAsyncNotifyServerReferral
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintAsyncNotifyServerReferral
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintAsyncNotifyServerReferral_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prmtserverreferral: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintBidiAsyncNotifyRegistration(::windows::runtime::IUnknown);
impl IPrintBidiAsyncNotifyRegistration {
    pub unsafe fn RegisterForNotifications(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UnregisterForNotifications(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AsyncGetNewChannel<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintAsyncNewChannelCookie>,
    >(
        &self,
        param0: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            param0.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintBidiAsyncNotifyRegistration {
    type Vtable = IPrintBidiAsyncNotifyRegistration_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IPrintBidiAsyncNotifyRegistration> for ::windows::runtime::IUnknown {
    fn from(value: IPrintBidiAsyncNotifyRegistration) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintBidiAsyncNotifyRegistration> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintBidiAsyncNotifyRegistration) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintBidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintBidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintBidiAsyncNotifyRegistration> for IPrintAsyncNotifyRegistration {
    fn from(value: IPrintBidiAsyncNotifyRegistration) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintBidiAsyncNotifyRegistration> for IPrintAsyncNotifyRegistration {
    fn from(value: &IPrintBidiAsyncNotifyRegistration) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyRegistration>
    for IPrintBidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncNotifyRegistration> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintAsyncNotifyRegistration>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyRegistration>
    for &IPrintBidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncNotifyRegistration> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintAsyncNotifyRegistration>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintBidiAsyncNotifyRegistration_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintClassObjectFactory {
    pub lpVtbl: *mut IPrintClassObjectFactoryVtbl,
}
impl IPrintClassObjectFactory {}
impl ::std::default::Default for IPrintClassObjectFactory {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintClassObjectFactory {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintClassObjectFactory")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintClassObjectFactory {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintClassObjectFactory {}
unsafe impl ::windows::runtime::Abi for IPrintClassObjectFactory {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintClassObjectFactoryVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetPrintClassObject: isize,
}
impl IPrintClassObjectFactoryVtbl {}
impl ::std::default::Default for IPrintClassObjectFactoryVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintClassObjectFactoryVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintClassObjectFactoryVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetPrintClassObject", &self.GetPrintClassObject)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintClassObjectFactoryVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetPrintClassObject == other.GetPrintClassObject
    }
}
impl ::std::cmp::Eq for IPrintClassObjectFactoryVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintClassObjectFactoryVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintCoreHelper(::windows::runtime::IUnknown);
impl IPrintCoreHelper {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn GetOption<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: Param2,
    ) -> ::windows::runtime::Result<super::super::Foundation::PSTR> {
        let mut result__: <super::super::Foundation::PSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturerequested.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PSTR>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn SetOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: Param2,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            bresolveconflicts.into_param().abi(),
            ::std::mem::transmute(pfopairs),
            ::std::mem::transmute(cpairs),
            ::std::mem::transmute(pcpairswritten),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn EnumConstrainedOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(pconstrainedoptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn WhyConstrained<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pszoptionkeyword: Param3,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            pszoptionkeyword.into_param().abi(),
            ::std::mem::transmute(ppfoconstraints),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumFeatures(
        &self,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pfeaturelist),
            ::std::mem::transmute(pdwnumfeatures),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumOptions<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pszfeaturekeyword: Param0,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(poptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            ::std::mem::transmute(ppszdevfontname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        pszdevfontname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            pszdevfontname.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateInstanceOfMSXMLObject<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: Param1,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsid),
            punkouter.into_param().abi(),
            ::std::mem::transmute(dwclscontext),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintCoreHelper {
    type Vtable = IPrintCoreHelper_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2828977470,
        14597,
        18886,
        [156, 26, 192, 168, 129, 23, 253, 182],
    );
}
impl ::std::convert::From<IPrintCoreHelper> for ::windows::runtime::IUnknown {
    fn from(value: IPrintCoreHelper) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelper> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintCoreHelper) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintCoreHelper {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintCoreHelper {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintCoreHelper_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: super::super::Foundation::PSTR,
        ppszoption: *mut super::super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: super::super::Foundation::BOOL,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszoptionkeyword: super::super::Foundation::PSTR,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        pszdevfontname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: ::windows::runtime::RawPtr,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintCoreHelperPS(::windows::runtime::IUnknown);
impl IPrintCoreHelperPS {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn GetOption<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: Param2,
    ) -> ::windows::runtime::Result<super::super::Foundation::PSTR> {
        let mut result__: <super::super::Foundation::PSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturerequested.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PSTR>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn SetOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: Param2,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            bresolveconflicts.into_param().abi(),
            ::std::mem::transmute(pfopairs),
            ::std::mem::transmute(cpairs),
            ::std::mem::transmute(pcpairswritten),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn EnumConstrainedOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(pconstrainedoptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn WhyConstrained<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pszoptionkeyword: Param3,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            pszoptionkeyword.into_param().abi(),
            ::std::mem::transmute(ppfoconstraints),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumFeatures(
        &self,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pfeaturelist),
            ::std::mem::transmute(pdwnumfeatures),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumOptions<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pszfeaturekeyword: Param0,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(poptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            ::std::mem::transmute(ppszdevfontname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        pszdevfontname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            pszdevfontname.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateInstanceOfMSXMLObject<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: Param1,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsid),
            punkouter.into_param().abi(),
            ::std::mem::transmute(dwclscontext),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetGlobalAttribute<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pszattribute: Param0,
        pdwdatatype: *mut u32,
        ppbdata: *mut *mut u8,
        pcbsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            pszattribute.into_param().abi(),
            ::std::mem::transmute(pdwdatatype),
            ::std::mem::transmute(ppbdata),
            ::std::mem::transmute(pcbsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeatureAttribute<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pszfeaturekeyword: Param0,
        pszattribute: Param1,
        pdwdatatype: *mut u32,
        ppbdata: *mut *mut u8,
        pcbsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pszfeaturekeyword.into_param().abi(),
            pszattribute.into_param().abi(),
            ::std::mem::transmute(pdwdatatype),
            ::std::mem::transmute(ppbdata),
            ::std::mem::transmute(pcbsize),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionAttribute<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pszfeaturekeyword: Param0,
        pszoptionkeyword: Param1,
        pszattribute: Param2,
        pdwdatatype: *mut u32,
        ppbdata: *mut *mut u8,
        pcbsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            pszfeaturekeyword.into_param().abi(),
            pszoptionkeyword.into_param().abi(),
            pszattribute.into_param().abi(),
            ::std::mem::transmute(pdwdatatype),
            ::std::mem::transmute(ppbdata),
            ::std::mem::transmute(pcbsize),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintCoreHelperPS {
    type Vtable = IPrintCoreHelperPS_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3267448687,
        38355,
        19811,
        [150, 207, 107, 217, 230, 201, 7, 194],
    );
}
impl ::std::convert::From<IPrintCoreHelperPS> for ::windows::runtime::IUnknown {
    fn from(value: IPrintCoreHelperPS) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelperPS> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintCoreHelperPS) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintCoreHelperPS {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintCoreHelperPS {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintCoreHelperPS> for IPrintCoreHelper {
    fn from(value: IPrintCoreHelperPS) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelperPS> for IPrintCoreHelper {
    fn from(value: &IPrintCoreHelperPS) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelper> for IPrintCoreHelperPS {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelper> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelper>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelper> for &IPrintCoreHelperPS {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelper> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelper>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintCoreHelperPS_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: super::super::Foundation::PSTR,
        ppszoption: *mut super::super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: super::super::Foundation::BOOL,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszoptionkeyword: super::super::Foundation::PSTR,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        pszdevfontname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: ::windows::runtime::RawPtr,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszattribute: super::super::Foundation::PSTR,
        pdwdatatype: *mut u32,
        ppbdata: *mut *mut u8,
        pcbsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszattribute: super::super::Foundation::PSTR,
        pdwdatatype: *mut u32,
        ppbdata: *mut *mut u8,
        pcbsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszoptionkeyword: super::super::Foundation::PSTR,
        pszattribute: super::super::Foundation::PSTR,
        pdwdatatype: *mut u32,
        ppbdata: *mut *mut u8,
        pcbsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintCoreHelperUni(::windows::runtime::IUnknown);
impl IPrintCoreHelperUni {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn GetOption<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: Param2,
    ) -> ::windows::runtime::Result<super::super::Foundation::PSTR> {
        let mut result__: <super::super::Foundation::PSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturerequested.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PSTR>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn SetOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: Param2,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            bresolveconflicts.into_param().abi(),
            ::std::mem::transmute(pfopairs),
            ::std::mem::transmute(cpairs),
            ::std::mem::transmute(pcpairswritten),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn EnumConstrainedOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(pconstrainedoptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn WhyConstrained<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pszoptionkeyword: Param3,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            pszoptionkeyword.into_param().abi(),
            ::std::mem::transmute(ppfoconstraints),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumFeatures(
        &self,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pfeaturelist),
            ::std::mem::transmute(pdwnumfeatures),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumOptions<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pszfeaturekeyword: Param0,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(poptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            ::std::mem::transmute(ppszdevfontname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        pszdevfontname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            pszdevfontname.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateInstanceOfMSXMLObject<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: Param1,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsid),
            punkouter.into_param().abi(),
            ::std::mem::transmute(dwclscontext),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub unsafe fn CreateGDLSnapshot(
        &self,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        dwflags: u32,
        ppsnapshotstream: *mut ::std::option::Option<
            super::super::Storage::StructuredStorage::IStream,
        >,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(ppsnapshotstream),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn CreateDefaultGDLSnapshot(
        &self,
        dwflags: u32,
    ) -> ::windows::runtime::Result<super::super::Storage::StructuredStorage::IStream> {
        let mut result__ : < super::super::Storage::StructuredStorage:: IStream as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Storage::StructuredStorage::IStream>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintCoreHelperUni {
    type Vtable = IPrintCoreHelperUni_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2123256278,
        58862,
        17446,
        [129, 123, 149, 139, 148, 68, 235, 121],
    );
}
impl ::std::convert::From<IPrintCoreHelperUni> for ::windows::runtime::IUnknown {
    fn from(value: IPrintCoreHelperUni) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelperUni> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintCoreHelperUni) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintCoreHelperUni {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintCoreHelperUni {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintCoreHelperUni> for IPrintCoreHelper {
    fn from(value: IPrintCoreHelperUni) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelperUni> for IPrintCoreHelper {
    fn from(value: &IPrintCoreHelperUni) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelper> for IPrintCoreHelperUni {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelper> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelper>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelper> for &IPrintCoreHelperUni {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelper> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelper>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintCoreHelperUni_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: super::super::Foundation::PSTR,
        ppszoption: *mut super::super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: super::super::Foundation::BOOL,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszoptionkeyword: super::super::Foundation::PSTR,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        pszdevfontname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: ::windows::runtime::RawPtr,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        dwflags: u32,
        ppsnapshotstream: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_UI_DisplayDevices"
    )))]
    usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        ppsnapshotstream: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintCoreHelperUni2(::windows::runtime::IUnknown);
impl IPrintCoreHelperUni2 {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn GetOption<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: Param2,
    ) -> ::windows::runtime::Result<super::super::Foundation::PSTR> {
        let mut result__: <super::super::Foundation::PSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturerequested.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::PSTR>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn SetOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: Param2,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            bresolveconflicts.into_param().abi(),
            ::std::mem::transmute(pfopairs),
            ::std::mem::transmute(cpairs),
            ::std::mem::transmute(pcpairswritten),
            ::std::mem::transmute(pdwresult),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn EnumConstrainedOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(pconstrainedoptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn WhyConstrained<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: Param2,
        pszoptionkeyword: Param3,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszfeaturekeyword.into_param().abi(),
            pszoptionkeyword.into_param().abi(),
            ::std::mem::transmute(ppfoconstraints),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumFeatures(
        &self,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pfeaturelist),
            ::std::mem::transmute(pdwnumfeatures),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumOptions<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pszfeaturekeyword: Param0,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(poptionlist),
            ::std::mem::transmute(pdwnumoptions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            ::std::mem::transmute(ppszdevfontname),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetFontSubstitution<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        psztruetypefontname: Param0,
        pszdevfontname: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            psztruetypefontname.into_param().abi(),
            pszdevfontname.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateInstanceOfMSXMLObject<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: Param1,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(rclsid),
            punkouter.into_param().abi(),
            ::std::mem::transmute(dwclscontext),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(ppv),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub unsafe fn CreateGDLSnapshot(
        &self,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        dwflags: u32,
        ppsnapshotstream: *mut ::std::option::Option<
            super::super::Storage::StructuredStorage::IStream,
        >,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(ppsnapshotstream),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub unsafe fn CreateDefaultGDLSnapshot(
        &self,
        dwflags: u32,
    ) -> ::windows::runtime::Result<super::super::Storage::StructuredStorage::IStream> {
        let mut result__ : < super::super::Storage::StructuredStorage:: IStream as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwflags),
            &mut result__,
        )
        .from_abi::<super::super::Storage::StructuredStorage::IStream>(result__)
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn GetNamedCommand<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszcommandname: Param2,
        ppcommandbytes: *mut *mut u8,
        pcbcommandsize: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cbsize),
            pszcommandname.into_param().abi(),
            ::std::mem::transmute(ppcommandbytes),
            ::std::mem::transmute(pcbcommandsize),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintCoreHelperUni2 {
    type Vtable = IPrintCoreHelperUni2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1821048316,
        60112,
        19757,
        [128, 113, 155, 240, 23, 90, 108, 58],
    );
}
impl ::std::convert::From<IPrintCoreHelperUni2> for ::windows::runtime::IUnknown {
    fn from(value: IPrintCoreHelperUni2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelperUni2> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintCoreHelperUni2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintCoreHelperUni2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintCoreHelperUni2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintCoreHelperUni2> for IPrintCoreHelperUni {
    fn from(value: IPrintCoreHelperUni2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelperUni2> for IPrintCoreHelperUni {
    fn from(value: &IPrintCoreHelperUni2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelperUni> for IPrintCoreHelperUni2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelperUni> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelperUni>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelperUni> for &IPrintCoreHelperUni2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelperUni> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelperUni>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IPrintCoreHelperUni2> for IPrintCoreHelper {
    fn from(value: IPrintCoreHelperUni2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreHelperUni2> for IPrintCoreHelper {
    fn from(value: &IPrintCoreHelperUni2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelper> for IPrintCoreHelperUni2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelper> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelper>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintCoreHelper> for &IPrintCoreHelperUni2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintCoreHelper> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintCoreHelper>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintCoreHelperUni2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturerequested: super::super::Foundation::PSTR,
        ppszoption: *mut super::super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        bresolveconflicts: super::super::Foundation::BOOL,
        pfopairs: *const PRINT_FEATURE_OPTION,
        cpairs: u32,
        pcpairswritten: *mut u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pconstrainedoptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszoptionkeyword: super::super::Foundation::PSTR,
        ppfoconstraints: *mut *mut PRINT_FEATURE_OPTION,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeaturelist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumfeatures: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        poptionlist: *mut *mut *mut super::super::Foundation::PSTR,
        pdwnumoptions: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        ppszdevfontname: *mut super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psztruetypefontname: super::super::Foundation::PWSTR,
        pszdevfontname: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        rclsid: *const ::windows::runtime::GUID,
        punkouter: ::windows::runtime::RawPtr,
        dwclscontext: u32,
        riid: *const ::windows::runtime::GUID,
        ppv: *mut *mut ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        dwflags: u32,
        ppsnapshotstream: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage",
        feature = "Win32_UI_DisplayDevices"
    )))]
    usize,
    #[cfg(feature = "Win32_Storage_StructuredStorage")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwflags: u32,
        ppsnapshotstream: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Storage_StructuredStorage"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cbsize: u32,
        pszcommandname: super::super::Foundation::PWSTR,
        ppcommandbytes: *mut *mut u8,
        pcbcommandsize: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintCoreUI2(::windows::runtime::IUnknown);
impl IPrintCoreUI2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DrvGetDriverSetting<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pci: *mut ::std::ffi::c_void,
        feature: Param1,
        poutput: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
        pdwoptionsreturned: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pci),
            feature.into_param().abi(),
            ::std::mem::transmute(poutput),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pdwoptionsreturned),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DrvUpgradeRegistrySetting<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        hprinter: Param0,
        pfeature: Param1,
        poption: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            pfeature.into_param().abi(),
            poption.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrvUpdateUISetting(
        &self,
        pci: *mut ::std::ffi::c_void,
        poptitem: *mut ::std::ffi::c_void,
        dwpreviousselection: u32,
        dwmode: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pci),
            ::std::mem::transmute(poptitem),
            ::std::mem::transmute(dwpreviousselection),
            ::std::mem::transmute(dwmode),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptions(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pmszfeaturesrequested: *const i8,
        cbin: u32,
        pmszfeatureoptionbuf: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pmszfeaturesrequested),
            ::std::mem::transmute(cbin),
            ::std::mem::transmute(pmszfeatureoptionbuf),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetOptions(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pmszfeatureoptionbuf: *const i8,
        cbin: u32,
    ) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pmszfeatureoptionbuf),
            ::std::mem::transmute(cbin),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumConstrainedOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: Param2,
        pmszconstrainedoptionlist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(pmszconstrainedoptionlist),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WhyConstrained<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: Param2,
        pszoptionkeyword: Param3,
        pmszreasonlist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            pszfeaturekeyword.into_param().abi(),
            pszoptionkeyword.into_param().abi(),
            ::std::mem::transmute(pmszreasonlist),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetGlobalAttribute<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszattribute: Param2,
        pdwdatatype: *mut u32,
        pbdata: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            pszattribute.into_param().abi(),
            ::std::mem::transmute(pdwdatatype),
            ::std::mem::transmute(pbdata),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeatureAttribute<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: Param2,
        pszattribute: Param3,
        pdwdatatype: *mut u32,
        pbdata: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            pszfeaturekeyword.into_param().abi(),
            pszattribute.into_param().abi(),
            ::std::mem::transmute(pdwdatatype),
            ::std::mem::transmute(pbdata),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOptionAttribute<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param4: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: Param2,
        pszoptionkeyword: Param3,
        pszattribute: Param4,
        pdwdatatype: *mut u32,
        pbdata: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            pszfeaturekeyword.into_param().abi(),
            pszoptionkeyword.into_param().abi(),
            pszattribute.into_param().abi(),
            ::std::mem::transmute(pdwdatatype),
            ::std::mem::transmute(pbdata),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumFeatures(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pmszfeaturelist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            ::std::mem::transmute(pmszfeaturelist),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn EnumOptions<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: Param2,
        pmszoptionlist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(dwflags),
            pszfeaturekeyword.into_param().abi(),
            ::std::mem::transmute(pmszoptionlist),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QuerySimulationSupport<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        dwlevel: u32,
        pcaps: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pcaps),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintCoreUI2 {
    type Vtable = IPrintCoreUI2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        140300234,
        15071,
        19614,
        [180, 145, 216, 81, 166, 237, 201, 151],
    );
}
impl ::std::convert::From<IPrintCoreUI2> for ::windows::runtime::IUnknown {
    fn from(value: IPrintCoreUI2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreUI2> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintCoreUI2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintCoreUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintCoreUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintCoreUI2> for IPrintOemDriverUI {
    fn from(value: IPrintCoreUI2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintCoreUI2> for IPrintOemDriverUI {
    fn from(value: &IPrintCoreUI2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemDriverUI> for IPrintCoreUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemDriverUI> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemDriverUI>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemDriverUI> for &IPrintCoreUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemDriverUI> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemDriverUI>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintCoreUI2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pci: *mut ::std::ffi::c_void,
        feature: super::super::Foundation::PSTR,
        poutput: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
        pdwoptionsreturned: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        pfeature: super::super::Foundation::PSTR,
        poption: super::super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pci: *mut ::std::ffi::c_void,
        poptitem: *mut ::std::ffi::c_void,
        dwpreviousselection: u32,
        dwmode: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pmszfeaturesrequested: *const i8,
        cbin: u32,
        pmszfeatureoptionbuf: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pmszfeatureoptionbuf: *const i8,
        cbin: u32,
        pdwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pmszconstrainedoptionlist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszoptionkeyword: super::super::Foundation::PSTR,
        pmszreasonlist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszattribute: super::super::Foundation::PSTR,
        pdwdatatype: *mut u32,
        pbdata: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszattribute: super::super::Foundation::PSTR,
        pdwdatatype: *mut u32,
        pbdata: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pszoptionkeyword: super::super::Foundation::PSTR,
        pszattribute: super::super::Foundation::PSTR,
        pdwdatatype: *mut u32,
        pbdata: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pmszfeaturelist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        dwflags: u32,
        pszfeaturekeyword: super::super::Foundation::PSTR,
        pmszoptionlist: super::super::Foundation::PSTR,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        dwlevel: u32,
        pcaps: *mut u8,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintJob(::windows::runtime::IUnknown);
impl IPrintJob {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn Id(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn PrintedPages(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn TotalPages(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn Status(&self) -> ::windows::runtime::Result<PrintJobStatus> {
        let mut result__: <PrintJobStatus as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<PrintJobStatus>(result__)
    }
    pub unsafe fn SubmissionTime(&self) -> ::windows::runtime::Result<f64> {
        let mut result__: <f64 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<f64>(result__)
    }
    pub unsafe fn RequestCancel(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintJob {
    type Vtable = IPrintJob_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3077692088,
        4738,
        16823,
        [133, 140, 242, 6, 228, 210, 5, 119],
    );
}
impl ::std::convert::From<IPrintJob> for ::windows::runtime::IUnknown {
    fn from(value: IPrintJob) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintJob> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintJob) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintJob {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintJob {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintJob_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulid: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulpages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulpages: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pstatus: *mut PrintJobStatus,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psubmissiontime: *mut f64,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintJobCollection(::windows::runtime::IUnknown);
impl IPrintJobCollection {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetAt(&self, ulindex: u32) -> ::windows::runtime::Result<IPrintJob> {
        let mut result__: <IPrintJob as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulindex),
            &mut result__,
        )
        .from_abi::<IPrintJob>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintJobCollection {
    type Vtable = IPrintJobCollection_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1924672036,
        42392,
        20103,
        [137, 95, 205, 178, 58, 73, 233, 220],
    );
}
impl ::std::convert::From<IPrintJobCollection> for ::windows::runtime::IUnknown {
    fn from(value: IPrintJobCollection) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintJobCollection> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintJobCollection) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintJobCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintJobCollection {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintJobCollection> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrintJobCollection) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintJobCollection> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrintJobCollection) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintJobCollection
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintJobCollection
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintJobCollection_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulcount: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulindex: u32,
        ppjob: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintOemCommon(::windows::runtime::IUnknown);
impl IPrintOemCommon {
    pub unsafe fn GetInfo(
        &self,
        dwmode: u32,
        pbuffer: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pbuffer),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn DevMode(
        &self,
        dwmode: u32,
        poemdmparam: *mut OEMDMPARAM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(poemdmparam),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintOemCommon {
    type Vtable = IPrintOemCommon_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2135042142,
        37333,
        4561,
        [136, 32, 0, 192, 79, 185, 97, 236],
    );
}
impl ::std::convert::From<IPrintOemCommon> for ::windows::runtime::IUnknown {
    fn from(value: IPrintOemCommon) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemCommon> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintOemCommon) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintOemCommon {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintOemCommon {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintOemCommon_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        pbuffer: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        poemdmparam: *mut OEMDMPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintOemDriverUI(::windows::runtime::IUnknown);
impl IPrintOemDriverUI {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DrvGetDriverSetting<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        pci: *mut ::std::ffi::c_void,
        feature: Param1,
        poutput: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
        pdwoptionsreturned: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pci),
            feature.into_param().abi(),
            ::std::mem::transmute(poutput),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
            ::std::mem::transmute(pdwoptionsreturned),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DrvUpgradeRegistrySetting<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PSTR>,
    >(
        &self,
        hprinter: Param0,
        pfeature: Param1,
        poption: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            pfeature.into_param().abi(),
            poption.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DrvUpdateUISetting(
        &self,
        pci: *mut ::std::ffi::c_void,
        poptitem: *mut ::std::ffi::c_void,
        dwpreviousselection: u32,
        dwmode: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pci),
            ::std::mem::transmute(poptitem),
            ::std::mem::transmute(dwpreviousselection),
            ::std::mem::transmute(dwmode),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintOemDriverUI {
    type Vtable = IPrintOemDriverUI_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2461031760,
        30908,
        4561,
        [148, 128, 0, 160, 201, 6, 64, 184],
    );
}
impl ::std::convert::From<IPrintOemDriverUI> for ::windows::runtime::IUnknown {
    fn from(value: IPrintOemDriverUI) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemDriverUI> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintOemDriverUI) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintOemDriverUI {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintOemDriverUI {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintOemDriverUI_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pci: *mut ::std::ffi::c_void,
        feature: super::super::Foundation::PSTR,
        poutput: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
        pdwoptionsreturned: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        pfeature: super::super::Foundation::PSTR,
        poption: super::super::Foundation::PSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pci: *mut ::std::ffi::c_void,
        poptitem: *mut ::std::ffi::c_void,
        dwpreviousselection: u32,
        dwmode: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintOemUI(::windows::runtime::IUnknown);
impl IPrintOemUI {
    pub unsafe fn GetInfo(
        &self,
        dwmode: u32,
        pbuffer: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pbuffer),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn DevMode(
        &self,
        dwmode: u32,
        poemdmparam: *mut OEMDMPARAM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(poemdmparam),
        )
        .ok()
    }
    pub unsafe fn PublishDriverInterface<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        piunknown: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            piunknown.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn CommonUIProp(
        &self,
        dwmode: u32,
        poemcuipparam: *const OEMCUIPPARAM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(poemcuipparam),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DocumentPropertySheets<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        ppsuiinfo: *mut PROPSHEETUI_INFO,
        lparam: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppsuiinfo),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DevicePropertySheets<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        ppsuiinfo: *const PROPSHEETUI_INFO,
        lparam: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppsuiinfo),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn DevQueryPrintEx(
        &self,
        poemuiobj: *const OEMUIOBJ,
        pdqpinfo: *const DEVQUERYPRINT_INFO,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(pdqpinfo),
            ::std::mem::transmute(ppublicdm),
            ::std::mem::transmute(poemdm),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn DeviceCapabilitiesA<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        poemuiobj: *mut OEMUIOBJ,
        hprinter: Param1,
        pdevicename: Param2,
        wcapability: u16,
        poutput: *mut ::std::ffi::c_void,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        dwold: u32,
        dwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            hprinter.into_param().abi(),
            pdevicename.into_param().abi(),
            ::std::mem::transmute(wcapability),
            ::std::mem::transmute(poutput),
            ::std::mem::transmute(ppublicdm),
            ::std::mem::transmute(poemdm),
            ::std::mem::transmute(dwold),
            ::std::mem::transmute(dwresult),
        )
        .ok()
    }
    pub unsafe fn UpgradePrinter(
        &self,
        dwlevel: u32,
        pdriverupgradeinfo: *const u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pdriverupgradeinfo),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PrinterEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        pprintername: Param0,
        idriverevent: i32,
        dwflags: u32,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            pprintername.into_param().abi(),
            ::std::mem::transmute(idriverevent),
            ::std::mem::transmute(dwflags),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DriverEvent<
        'a,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        dwdriverevent: u32,
        dwlevel: u32,
        pdriverinfo: *const u8,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwdriverevent),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pdriverinfo),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn QueryColorProfile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        poemuiobj: *const OEMUIOBJ,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        ulquerymode: u32,
        pvprofiledata: *mut ::std::ffi::c_void,
        pcbprofiledata: *mut u32,
        pflprofiledata: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(ppublicdm),
            ::std::mem::transmute(poemdm),
            ::std::mem::transmute(ulquerymode),
            ::std::mem::transmute(pvprofiledata),
            ::std::mem::transmute(pcbprofiledata),
            ::std::mem::transmute(pflprofiledata),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FontInstallerDlgProc<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        usmsg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(usmsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UpdateExternalFonts<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hprinter: Param0,
        hheap: Param1,
        pwstrcartridges: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            hheap.into_param().abi(),
            pwstrcartridges.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintOemUI {
    type Vtable = IPrintOemUI_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3332876752,
        30540,
        4561,
        [148, 127, 0, 160, 201, 6, 64, 184],
    );
}
impl ::std::convert::From<IPrintOemUI> for ::windows::runtime::IUnknown {
    fn from(value: IPrintOemUI) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemUI> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintOemUI) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintOemUI {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintOemUI {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintOemUI> for IPrintOemCommon {
    fn from(value: IPrintOemUI) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemUI> for IPrintOemCommon {
    fn from(value: &IPrintOemUI) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemCommon> for IPrintOemUI {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemCommon> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemCommon>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemCommon> for &IPrintOemUI {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemCommon> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemCommon>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintOemUI_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        pbuffer: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        poemdmparam: *mut OEMDMPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        piunknown: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        poemcuipparam: *const ::std::mem::ManuallyDrop<OEMCUIPPARAM>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsuiinfo: *mut ::std::mem::ManuallyDrop<PROPSHEETUI_INFO>,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsuiinfo: *const ::std::mem::ManuallyDrop<PROPSHEETUI_INFO>,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        pdqpinfo: *const DEVQUERYPRINT_INFO,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *mut OEMUIOBJ,
        hprinter: super::super::Foundation::HANDLE,
        pdevicename: super::super::Foundation::PWSTR,
        wcapability: u16,
        poutput: *mut ::std::ffi::c_void,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        dwold: u32,
        dwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwlevel: u32,
        pdriverupgradeinfo: *const u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintername: super::super::Foundation::PWSTR,
        idriverevent: i32,
        dwflags: u32,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwdriverevent: u32,
        dwlevel: u32,
        pdriverinfo: *const u8,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        poemuiobj: *const OEMUIOBJ,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        ulquerymode: u32,
        pvprofiledata: *mut ::std::ffi::c_void,
        pcbprofiledata: *mut u32,
        pflprofiledata: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        usmsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        hheap: super::super::Foundation::HANDLE,
        pwstrcartridges: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintOemUI2(::windows::runtime::IUnknown);
impl IPrintOemUI2 {
    pub unsafe fn GetInfo(
        &self,
        dwmode: u32,
        pbuffer: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(pbuffer),
            ::std::mem::transmute(cbsize),
            ::std::mem::transmute(pcbneeded),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn DevMode(
        &self,
        dwmode: u32,
        poemdmparam: *mut OEMDMPARAM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(poemdmparam),
        )
        .ok()
    }
    pub unsafe fn PublishDriverInterface<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>,
    >(
        &self,
        piunknown: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            piunknown.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub unsafe fn CommonUIProp(
        &self,
        dwmode: u32,
        poemcuipparam: *const OEMCUIPPARAM,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
            ::std::mem::transmute(poemcuipparam),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DocumentPropertySheets<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        ppsuiinfo: *mut PROPSHEETUI_INFO,
        lparam: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppsuiinfo),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DevicePropertySheets<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        ppsuiinfo: *const PROPSHEETUI_INFO,
        lparam: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ppsuiinfo),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn DevQueryPrintEx(
        &self,
        poemuiobj: *const OEMUIOBJ,
        pdqpinfo: *const DEVQUERYPRINT_INFO,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(pdqpinfo),
            ::std::mem::transmute(ppublicdm),
            ::std::mem::transmute(poemdm),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn DeviceCapabilitiesA<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        poemuiobj: *mut OEMUIOBJ,
        hprinter: Param1,
        pdevicename: Param2,
        wcapability: u16,
        poutput: *mut ::std::ffi::c_void,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        dwold: u32,
        dwresult: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(poemuiobj),
            hprinter.into_param().abi(),
            pdevicename.into_param().abi(),
            ::std::mem::transmute(wcapability),
            ::std::mem::transmute(poutput),
            ::std::mem::transmute(ppublicdm),
            ::std::mem::transmute(poemdm),
            ::std::mem::transmute(dwold),
            ::std::mem::transmute(dwresult),
        )
        .ok()
    }
    pub unsafe fn UpgradePrinter(
        &self,
        dwlevel: u32,
        pdriverupgradeinfo: *const u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pdriverupgradeinfo),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn PrinterEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        pprintername: Param0,
        idriverevent: i32,
        dwflags: u32,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            pprintername.into_param().abi(),
            ::std::mem::transmute(idriverevent),
            ::std::mem::transmute(dwflags),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DriverEvent<
        'a,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        dwdriverevent: u32,
        dwlevel: u32,
        pdriverinfo: *const u8,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwdriverevent),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(pdriverinfo),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn QueryColorProfile<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        poemuiobj: *const OEMUIOBJ,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        ulquerymode: u32,
        pvprofiledata: *mut ::std::ffi::c_void,
        pcbprofiledata: *mut u32,
        pflprofiledata: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(poemuiobj),
            ::std::mem::transmute(ppublicdm),
            ::std::mem::transmute(poemdm),
            ::std::mem::transmute(ulquerymode),
            ::std::mem::transmute(pvprofiledata),
            ::std::mem::transmute(pcbprofiledata),
            ::std::mem::transmute(pflprofiledata),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn FontInstallerDlgProc<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HWND>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::WPARAM>,
        Param3: ::windows::runtime::IntoParam<'a, super::super::Foundation::LPARAM>,
    >(
        &self,
        hwnd: Param0,
        usmsg: u32,
        wparam: Param2,
        lparam: Param3,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::std::mem::transmute(usmsg),
            wparam.into_param().abi(),
            lparam.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UpdateExternalFonts<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
    >(
        &self,
        hprinter: Param0,
        hheap: Param1,
        pwstrcartridges: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            hheap.into_param().abi(),
            pwstrcartridges.into_param().abi(),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn QueryJobAttributes<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        dwlevel: u32,
        lpattributeinfo: *const u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(dwlevel),
            ::std::mem::transmute(lpattributeinfo),
        )
        .ok()
    }
    pub unsafe fn HideStandardUI(&self, dwmode: u32) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dwmode),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub unsafe fn DocumentEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
        Param1: ::windows::runtime::IntoParam<'a, super::Gdi::HDC>,
    >(
        &self,
        hprinter: Param0,
        hdc: Param1,
        iesc: i32,
        cbin: u32,
        pvin: *mut ::std::ffi::c_void,
        cbout: u32,
        pvout: *mut ::std::ffi::c_void,
        piresult: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).19)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            hdc.into_param().abi(),
            ::std::mem::transmute(iesc),
            ::std::mem::transmute(cbin),
            ::std::mem::transmute(pvin),
            ::std::mem::transmute(cbout),
            ::std::mem::transmute(pvout),
            ::std::mem::transmute(piresult),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintOemUI2 {
    type Vtable = IPrintOemUI2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        690296313,
        46411,
        18587,
        [146, 117, 186, 181, 104, 33, 57, 94],
    );
}
impl ::std::convert::From<IPrintOemUI2> for ::windows::runtime::IUnknown {
    fn from(value: IPrintOemUI2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemUI2> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintOemUI2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintOemUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintOemUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintOemUI2> for IPrintOemUI {
    fn from(value: IPrintOemUI2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemUI2> for IPrintOemUI {
    fn from(value: &IPrintOemUI2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemUI> for IPrintOemUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemUI> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemUI>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemUI> for &IPrintOemUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemUI> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemUI>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IPrintOemUI2> for IPrintOemCommon {
    fn from(value: IPrintOemUI2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemUI2> for IPrintOemCommon {
    fn from(value: &IPrintOemUI2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemCommon> for IPrintOemUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemCommon> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemCommon>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintOemCommon> for &IPrintOemUI2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintOemCommon> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintOemCommon>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintOemUI2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        pbuffer: *mut ::std::ffi::c_void,
        cbsize: u32,
        pcbneeded: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        poemdmparam: *mut OEMDMPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        piunknown: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices",
        feature = "Win32_UI_WindowsAndMessaging"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
        poemcuipparam: *const ::std::mem::ManuallyDrop<OEMCUIPPARAM>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices",
        feature = "Win32_UI_WindowsAndMessaging"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsuiinfo: *mut ::std::mem::ManuallyDrop<PROPSHEETUI_INFO>,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppsuiinfo: *const ::std::mem::ManuallyDrop<PROPSHEETUI_INFO>,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *const OEMUIOBJ,
        pdqpinfo: *const DEVQUERYPRINT_INFO,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poemuiobj: *mut OEMUIOBJ,
        hprinter: super::super::Foundation::HANDLE,
        pdevicename: super::super::Foundation::PWSTR,
        wcapability: u16,
        poutput: *mut ::std::ffi::c_void,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        dwold: u32,
        dwresult: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwlevel: u32,
        pdriverupgradeinfo: *const u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintername: super::super::Foundation::PWSTR,
        idriverevent: i32,
        dwflags: u32,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwdriverevent: u32,
        dwlevel: u32,
        pdriverinfo: *const u8,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        poemuiobj: *const OEMUIOBJ,
        ppublicdm: *const super::super::UI::DisplayDevices::DEVMODEA,
        poemdm: *const ::std::ffi::c_void,
        ulquerymode: u32,
        pvprofiledata: *mut ::std::ffi::c_void,
        pcbprofiledata: *mut u32,
        pflprofiledata: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hwnd: super::super::Foundation::HWND,
        usmsg: u32,
        wparam: super::super::Foundation::WPARAM,
        lparam: super::super::Foundation::LPARAM,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        hheap: super::super::Foundation::HANDLE,
        pwstrcartridges: super::super::Foundation::PWSTR,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        dwlevel: u32,
        lpattributeinfo: *const u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dwmode: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        hdc: super::Gdi::HDC,
        iesc: i32,
        cbin: u32,
        pvin: *mut ::std::ffi::c_void,
        cbout: u32,
        pvout: *mut ::std::ffi::c_void,
        piresult: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_Graphics_Gdi")))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintOemUIMXDC(::windows::runtime::IUnknown);
impl IPrintOemUIMXDC {
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn AdjustImageableArea<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        cbdevmode: u32,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cboemdm: u32,
        poemdm: *const ::std::ffi::c_void,
        prclimageablearea: *mut super::super::Foundation::RECTL,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(cbdevmode),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cboemdm),
            ::std::mem::transmute(poemdm),
            ::std::mem::transmute(prclimageablearea),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn AdjustImageCompression<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        cbdevmode: u32,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cboemdm: u32,
        poemdm: *const ::std::ffi::c_void,
        pcompressionmode: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(cbdevmode),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cboemdm),
            ::std::mem::transmute(poemdm),
            ::std::mem::transmute(pcompressionmode),
        )
        .ok()
    }
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub unsafe fn AdjustDPI<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        cbdevmode: u32,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cboemdm: u32,
        poemdm: *const ::std::ffi::c_void,
        pdpi: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(cbdevmode),
            ::std::mem::transmute(pdevmode),
            ::std::mem::transmute(cboemdm),
            ::std::mem::transmute(poemdm),
            ::std::mem::transmute(pdpi),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintOemUIMXDC {
    type Vtable = IPrintOemUIMXDC_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1934219045,
        58049,
        19914,
        [175, 181, 193, 62, 145, 188, 147, 6],
    );
}
impl ::std::convert::From<IPrintOemUIMXDC> for ::windows::runtime::IUnknown {
    fn from(value: IPrintOemUIMXDC) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintOemUIMXDC> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintOemUIMXDC) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintOemUIMXDC {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintOemUIMXDC {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintOemUIMXDC_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        cbdevmode: u32,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cboemdm: u32,
        poemdm: *const ::std::ffi::c_void,
        prclimageablearea: *mut super::super::Foundation::RECTL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        cbdevmode: u32,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cboemdm: u32,
        poemdm: *const ::std::ffi::c_void,
        pcompressionmode: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
    #[cfg(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        cbdevmode: u32,
        pdevmode: *const super::super::UI::DisplayDevices::DEVMODEA,
        cboemdm: u32,
        poemdm: *const ::std::ffi::c_void,
        pdpi: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Foundation", feature = "Win32_UI_DisplayDevices")))] usize,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelineFilter {
    pub lpVtbl: *mut IPrintPipelineFilterVtbl,
}
impl IPrintPipelineFilter {}
impl ::std::default::Default for IPrintPipelineFilter {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelineFilter {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelineFilter")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelineFilter {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintPipelineFilter {}
unsafe impl ::windows::runtime::Abi for IPrintPipelineFilter {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelineFilterVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub InitializeFilter: isize,
    pub ShutdownOperation: isize,
    pub StartOperation: isize,
}
impl IPrintPipelineFilterVtbl {}
impl ::std::default::Default for IPrintPipelineFilterVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelineFilterVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelineFilterVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("InitializeFilter", &self.InitializeFilter)
            .field("ShutdownOperation", &self.ShutdownOperation)
            .field("StartOperation", &self.StartOperation)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelineFilterVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.InitializeFilter == other.InitializeFilter
            && self.ShutdownOperation == other.ShutdownOperation
            && self.StartOperation == other.StartOperation
    }
}
impl ::std::cmp::Eq for IPrintPipelineFilterVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintPipelineFilterVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelineManagerControl {
    pub lpVtbl: *mut IPrintPipelineManagerControlVtbl,
}
impl IPrintPipelineManagerControl {}
impl ::std::default::Default for IPrintPipelineManagerControl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelineManagerControl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelineManagerControl")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelineManagerControl {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintPipelineManagerControl {}
unsafe impl ::windows::runtime::Abi for IPrintPipelineManagerControl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelineManagerControlVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub RequestShutdown: isize,
    pub FilterFinished: isize,
}
impl IPrintPipelineManagerControlVtbl {}
impl ::std::default::Default for IPrintPipelineManagerControlVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelineManagerControlVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelineManagerControlVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("RequestShutdown", &self.RequestShutdown)
            .field("FilterFinished", &self.FilterFinished)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelineManagerControlVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.RequestShutdown == other.RequestShutdown
            && self.FilterFinished == other.FilterFinished
    }
}
impl ::std::cmp::Eq for IPrintPipelineManagerControlVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintPipelineManagerControlVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelineProgressReport {
    pub lpVtbl: *mut IPrintPipelineProgressReportVtbl,
}
impl IPrintPipelineProgressReport {}
impl ::std::default::Default for IPrintPipelineProgressReport {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelineProgressReport {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelineProgressReport")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelineProgressReport {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintPipelineProgressReport {}
unsafe impl ::windows::runtime::Abi for IPrintPipelineProgressReport {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelineProgressReportVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub ReportProgress: isize,
}
impl IPrintPipelineProgressReportVtbl {}
impl ::std::default::Default for IPrintPipelineProgressReportVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelineProgressReportVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelineProgressReportVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("ReportProgress", &self.ReportProgress)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelineProgressReportVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.ReportProgress == other.ReportProgress
    }
}
impl ::std::cmp::Eq for IPrintPipelineProgressReportVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintPipelineProgressReportVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelinePropertyBag {
    pub lpVtbl: *mut IPrintPipelinePropertyBagVtbl,
}
impl IPrintPipelinePropertyBag {}
impl ::std::default::Default for IPrintPipelinePropertyBag {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelinePropertyBag {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelinePropertyBag")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelinePropertyBag {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintPipelinePropertyBag {}
unsafe impl ::windows::runtime::Abi for IPrintPipelinePropertyBag {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintPipelinePropertyBagVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub AddProperty: isize,
    pub GetProperty: isize,
    pub DeleteProperty: isize,
}
impl IPrintPipelinePropertyBagVtbl {}
impl ::std::default::Default for IPrintPipelinePropertyBagVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintPipelinePropertyBagVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintPipelinePropertyBagVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("AddProperty", &self.AddProperty)
            .field("GetProperty", &self.GetProperty)
            .field("DeleteProperty", &self.DeleteProperty)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintPipelinePropertyBagVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.AddProperty == other.AddProperty
            && self.GetProperty == other.GetProperty
            && self.DeleteProperty == other.DeleteProperty
    }
}
impl ::std::cmp::Eq for IPrintPipelinePropertyBagVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintPipelinePropertyBagVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintPreviewDxgiPackageTarget(::windows::runtime::IUnknown);
impl IPrintPreviewDxgiPackageTarget {
    pub unsafe fn SetJobPageCount(
        &self,
        counttype: PageCountType,
        count: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(counttype),
            ::std::mem::transmute(count),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub unsafe fn DrawPage<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::Dxgi::IDXGISurface>,
    >(
        &self,
        jobpagenumber: u32,
        pageimage: Param1,
        dpix: f32,
        dpiy: f32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(jobpagenumber),
            pageimage.into_param().abi(),
            ::std::mem::transmute(dpix),
            ::std::mem::transmute(dpiy),
        )
        .ok()
    }
    pub unsafe fn InvalidatePreview(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintPreviewDxgiPackageTarget {
    type Vtable = IPrintPreviewDxgiPackageTarget_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        443404461,
        7722,
        20121,
        [165, 186, 145, 241, 120, 24, 41, 14],
    );
}
impl ::std::convert::From<IPrintPreviewDxgiPackageTarget> for ::windows::runtime::IUnknown {
    fn from(value: IPrintPreviewDxgiPackageTarget) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintPreviewDxgiPackageTarget> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintPreviewDxgiPackageTarget) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintPreviewDxgiPackageTarget
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintPreviewDxgiPackageTarget
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintPreviewDxgiPackageTarget_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        counttype: PageCountType,
        count: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Graphics_Dxgi")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        jobpagenumber: u32,
        pageimage: ::windows::runtime::RawPtr,
        dpix: f32,
        dpiy: f32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Graphics_Dxgi"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintReadStream {
    pub lpVtbl: *mut IPrintReadStreamVtbl,
}
impl IPrintReadStream {}
impl ::std::default::Default for IPrintReadStream {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintReadStream {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintReadStream")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintReadStream {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintReadStream {}
unsafe impl ::windows::runtime::Abi for IPrintReadStream {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintReadStreamFactory {
    pub lpVtbl: *mut IPrintReadStreamFactoryVtbl,
}
impl IPrintReadStreamFactory {}
impl ::std::default::Default for IPrintReadStreamFactory {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintReadStreamFactory {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintReadStreamFactory")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintReadStreamFactory {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintReadStreamFactory {}
unsafe impl ::windows::runtime::Abi for IPrintReadStreamFactory {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintReadStreamFactoryVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub GetStream: isize,
}
impl IPrintReadStreamFactoryVtbl {}
impl ::std::default::Default for IPrintReadStreamFactoryVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintReadStreamFactoryVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintReadStreamFactoryVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("GetStream", &self.GetStream)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintReadStreamFactoryVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.GetStream == other.GetStream
    }
}
impl ::std::cmp::Eq for IPrintReadStreamFactoryVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintReadStreamFactoryVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintReadStreamVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub Seek: isize,
    pub ReadBytes: isize,
}
impl IPrintReadStreamVtbl {}
impl ::std::default::Default for IPrintReadStreamVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintReadStreamVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintReadStreamVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("Seek", &self.Seek)
            .field("ReadBytes", &self.ReadBytes)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintReadStreamVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.Seek == other.Seek
            && self.ReadBytes == other.ReadBytes
    }
}
impl ::std::cmp::Eq for IPrintReadStreamVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintReadStreamVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaAsyncOperation(::windows::runtime::IUnknown);
impl IPrintSchemaAsyncOperation {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Start(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Cancel(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaAsyncOperation {
    type Vtable = IPrintSchemaAsyncOperation_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        339512779,
        54143,
        18423,
        [136, 232, 107, 29, 33, 242, 197, 247],
    );
}
impl ::std::convert::From<IPrintSchemaAsyncOperation> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaAsyncOperation) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaAsyncOperation> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaAsyncOperation) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaAsyncOperation
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaAsyncOperation
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaAsyncOperation>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaAsyncOperation) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaAsyncOperation>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaAsyncOperation) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaAsyncOperation
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaAsyncOperation
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaAsyncOperation_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaAsyncOperationEvent(::windows::runtime::IUnknown);
impl IPrintSchemaAsyncOperationEvent {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Completed<'a, Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaTicket>>(
        &self,
        pticket: Param0,
        hroperation: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            pticket.into_param().abi(),
            ::std::mem::transmute(hroperation),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaAsyncOperationEvent {
    type Vtable = IPrintSchemaAsyncOperationEvent_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        598588182,
        307,
        18694,
        [178, 154, 29, 206, 29, 2, 99, 121],
    );
}
impl ::std::convert::From<IPrintSchemaAsyncOperationEvent> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaAsyncOperationEvent) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaAsyncOperationEvent> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaAsyncOperationEvent) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaAsyncOperationEvent
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaAsyncOperationEvent
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaAsyncOperationEvent>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaAsyncOperationEvent) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaAsyncOperationEvent>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaAsyncOperationEvent) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaAsyncOperationEvent
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaAsyncOperationEvent
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaAsyncOperationEvent_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pticket: ::windows::runtime::RawPtr,
        hroperation: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaCapabilities(::windows::runtime::IUnknown);
impl IPrintSchemaCapabilities {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeatureByKeyName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrkeyname: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            bstrkeyname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeature<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    pub unsafe fn PageImageableSize(
        &self,
    ) -> ::windows::runtime::Result<IPrintSchemaPageImageableSize> {
        let mut result__: <IPrintSchemaPageImageableSize as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaPageImageableSize>(result__)
    }
    pub unsafe fn JobCopiesAllDocumentsMinValue(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn JobCopiesAllDocumentsMaxValue(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetSelectedOptionInPrintTicket<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaFeature>,
    >(
        &self,
        pfeature: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaOption> {
        let mut result__: <IPrintSchemaOption as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            pfeature.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaOption>(result__)
    }
    pub unsafe fn GetOptions<'a, Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaFeature>>(
        &self,
        pfeature: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaOptionCollection> {
        let mut result__: <IPrintSchemaOptionCollection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            pfeature.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaOptionCollection>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaCapabilities {
    type Vtable = IPrintSchemaCapabilities_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1515681344,
        20509,
        18727,
        [188, 208, 94, 245, 122, 126, 209, 117],
    );
}
impl ::std::convert::From<IPrintSchemaCapabilities> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaCapabilities) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaCapabilities> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaCapabilities) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaCapabilities
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaCapabilities
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaCapabilities> for IPrintSchemaElement {
    fn from(value: IPrintSchemaCapabilities) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaCapabilities> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaCapabilities) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaCapabilities {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaCapabilities {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaCapabilities>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaCapabilities) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaCapabilities>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaCapabilities) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaCapabilities
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaCapabilities
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaCapabilities_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrkeyname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppageimageablesize: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puljobcopiesalldocumentsminvalue: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puljobcopiesalldocumentsmaxvalue: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeature: ::windows::runtime::RawPtr,
        ppoption: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeature: ::windows::runtime::RawPtr,
        ppoptioncollection: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaCapabilities2(::windows::runtime::IUnknown);
impl IPrintSchemaCapabilities2 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeatureByKeyName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrkeyname: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            bstrkeyname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeature<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    pub unsafe fn PageImageableSize(
        &self,
    ) -> ::windows::runtime::Result<IPrintSchemaPageImageableSize> {
        let mut result__: <IPrintSchemaPageImageableSize as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaPageImageableSize>(result__)
    }
    pub unsafe fn JobCopiesAllDocumentsMinValue(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn JobCopiesAllDocumentsMaxValue(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetSelectedOptionInPrintTicket<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaFeature>,
    >(
        &self,
        pfeature: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaOption> {
        let mut result__: <IPrintSchemaOption as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            pfeature.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaOption>(result__)
    }
    pub unsafe fn GetOptions<'a, Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaFeature>>(
        &self,
        pfeature: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaOptionCollection> {
        let mut result__: <IPrintSchemaOptionCollection as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            pfeature.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaOptionCollection>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetParameterDefinition<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<IPrintSchemaParameterDefinition> {
        let mut result__: <IPrintSchemaParameterDefinition as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaParameterDefinition>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaCapabilities2 {
    type Vtable = IPrintSchemaCapabilities2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3045606900,
        39280,
        19847,
        [166, 54, 22, 159, 184, 46, 214, 66],
    );
}
impl ::std::convert::From<IPrintSchemaCapabilities2> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaCapabilities2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaCapabilities2> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaCapabilities2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaCapabilities2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaCapabilities2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaCapabilities2> for IPrintSchemaCapabilities {
    fn from(value: IPrintSchemaCapabilities2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaCapabilities2> for IPrintSchemaCapabilities {
    fn from(value: &IPrintSchemaCapabilities2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaCapabilities> for IPrintSchemaCapabilities2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaCapabilities> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaCapabilities>::into(
            self,
        ))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaCapabilities>
    for &IPrintSchemaCapabilities2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaCapabilities> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaCapabilities>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IPrintSchemaCapabilities2> for IPrintSchemaElement {
    fn from(value: IPrintSchemaCapabilities2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaCapabilities2> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaCapabilities2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaCapabilities2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaCapabilities2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaCapabilities2>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaCapabilities2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaCapabilities2>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaCapabilities2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaCapabilities2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaCapabilities2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaCapabilities2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrkeyname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppageimageablesize: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puljobcopiesalldocumentsminvalue: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puljobcopiesalldocumentsmaxvalue: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeature: ::windows::runtime::RawPtr,
        ppoption: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pfeature: ::windows::runtime::RawPtr,
        ppoptioncollection: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppparameterdefinition: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaDisplayableElement(::windows::runtime::IUnknown);
impl IPrintSchemaDisplayableElement {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaDisplayableElement {
    type Vtable = IPrintSchemaDisplayableElement_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2940579657,
        54954,
        16509,
        [191, 135, 57, 18, 35, 110, 157, 148],
    );
}
impl ::std::convert::From<IPrintSchemaDisplayableElement> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaDisplayableElement) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaDisplayableElement> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaDisplayableElement) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaDisplayableElement
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaDisplayableElement
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaDisplayableElement> for IPrintSchemaElement {
    fn from(value: IPrintSchemaDisplayableElement) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaDisplayableElement> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaDisplayableElement) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaDisplayableElement {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement>
    for &IPrintSchemaDisplayableElement
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaDisplayableElement>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaDisplayableElement) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaDisplayableElement>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaDisplayableElement) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaDisplayableElement
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaDisplayableElement
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaDisplayableElement_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrdisplayname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaElement(::windows::runtime::IUnknown);
impl IPrintSchemaElement {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaElement {
    type Vtable = IPrintSchemaElement_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1917589062,
        58955,
        19391,
        [142, 180, 212, 94, 79, 213, 128, 218],
    );
}
impl ::std::convert::From<IPrintSchemaElement> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaElement) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaElement> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaElement) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintSchemaElement {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintSchemaElement {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaElement> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrintSchemaElement) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaElement> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrintSchemaElement) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaElement
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaElement
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaElement_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaFeature(::windows::runtime::IUnknown);
impl IPrintSchemaFeature {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn SelectedOption(&self) -> ::windows::runtime::Result<IPrintSchemaOption> {
        let mut result__: <IPrintSchemaOption as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaOption>(result__)
    }
    pub unsafe fn SetSelectedOption<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaOption>,
    >(
        &self,
        poption: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            poption.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SelectionType(&self) -> ::windows::runtime::Result<PrintSchemaSelectionType> {
        let mut result__: <PrintSchemaSelectionType as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<PrintSchemaSelectionType>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetOption<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<IPrintSchemaOption> {
        let mut result__: <IPrintSchemaOption as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaOption>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayUI(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaFeature {
    type Vtable = IPrintSchemaFeature_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4011365473,
        23906,
        17958,
        [142, 87, 255, 131, 88, 60, 72, 38],
    );
}
impl ::std::convert::From<IPrintSchemaFeature> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaFeature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaFeature> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaFeature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintSchemaFeature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintSchemaFeature {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaFeature> for IPrintSchemaDisplayableElement {
    fn from(value: IPrintSchemaFeature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaFeature> for IPrintSchemaDisplayableElement {
    fn from(value: &IPrintSchemaFeature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement> for IPrintSchemaFeature {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement>
    for &IPrintSchemaFeature
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
impl ::std::convert::From<IPrintSchemaFeature> for IPrintSchemaElement {
    fn from(value: IPrintSchemaFeature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaFeature> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaFeature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaFeature {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaFeature {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaFeature> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrintSchemaFeature) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaFeature> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrintSchemaFeature) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaFeature
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaFeature
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaFeature_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrdisplayname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppoption: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        poption: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pselectiontype: *mut PrintSchemaSelectionType,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppoption: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbshow: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaNUpOption(::windows::runtime::IUnknown);
impl IPrintSchemaNUpOption {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Selected(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Constrained(&self) -> ::windows::runtime::Result<PrintSchemaConstrainedSetting> {
        let mut result__: <PrintSchemaConstrainedSetting as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<PrintSchemaConstrainedSetting>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn PagesPerSheet(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaNUpOption {
    type Vtable = IPrintSchemaNUpOption_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        526598898,
        55368,
        17123,
        [137, 149, 193, 10, 158, 249, 163, 186],
    );
}
impl ::std::convert::From<IPrintSchemaNUpOption> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaNUpOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaNUpOption> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaNUpOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintSchemaNUpOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaNUpOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaNUpOption> for IPrintSchemaOption {
    fn from(value: IPrintSchemaNUpOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaNUpOption> for IPrintSchemaOption {
    fn from(value: &IPrintSchemaNUpOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaOption> for IPrintSchemaNUpOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaOption> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaOption>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaOption> for &IPrintSchemaNUpOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaOption> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaOption>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IPrintSchemaNUpOption> for IPrintSchemaDisplayableElement {
    fn from(value: IPrintSchemaNUpOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaNUpOption> for IPrintSchemaDisplayableElement {
    fn from(value: &IPrintSchemaNUpOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement>
    for IPrintSchemaNUpOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement>
    for &IPrintSchemaNUpOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
impl ::std::convert::From<IPrintSchemaNUpOption> for IPrintSchemaElement {
    fn from(value: IPrintSchemaNUpOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaNUpOption> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaNUpOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaNUpOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaNUpOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaNUpOption>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaNUpOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaNUpOption>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaNUpOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaNUpOption
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaNUpOption
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaNUpOption_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrdisplayname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbisselected: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psetting: *mut PrintSchemaConstrainedSetting,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppxmlvaluenode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulpagespersheet: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaOption(::windows::runtime::IUnknown);
impl IPrintSchemaOption {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Selected(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Constrained(&self) -> ::windows::runtime::Result<PrintSchemaConstrainedSetting> {
        let mut result__: <PrintSchemaConstrainedSetting as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<PrintSchemaConstrainedSetting>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaOption {
    type Vtable = IPrintSchemaOption_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1723543377,
        22596,
        18839,
        [141, 112, 75, 124, 194, 33, 207, 146],
    );
}
impl ::std::convert::From<IPrintSchemaOption> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaOption> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintSchemaOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintSchemaOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaOption> for IPrintSchemaDisplayableElement {
    fn from(value: IPrintSchemaOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaOption> for IPrintSchemaDisplayableElement {
    fn from(value: &IPrintSchemaOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement> for IPrintSchemaOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement> for &IPrintSchemaOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
impl ::std::convert::From<IPrintSchemaOption> for IPrintSchemaElement {
    fn from(value: IPrintSchemaOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaOption> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaOption> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrintSchemaOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaOption> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrintSchemaOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaOption
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaOption
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaOption_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrdisplayname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbisselected: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psetting: *mut PrintSchemaConstrainedSetting,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppxmlvaluenode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaOptionCollection(::windows::runtime::IUnknown);
impl IPrintSchemaOptionCollection {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetAt(&self, ulindex: u32) -> ::windows::runtime::Result<IPrintSchemaOption> {
        let mut result__: <IPrintSchemaOption as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulindex),
            &mut result__,
        )
        .from_abi::<IPrintSchemaOption>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaOptionCollection {
    type Vtable = IPrintSchemaOptionCollection_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3136073917,
        43334,
        18289,
        [188, 48, 232, 178, 79, 141, 69, 193],
    );
}
impl ::std::convert::From<IPrintSchemaOptionCollection> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaOptionCollection) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaOptionCollection> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaOptionCollection) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaOptionCollection
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaOptionCollection
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaOptionCollection>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaOptionCollection) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaOptionCollection>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaOptionCollection) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaOptionCollection
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaOptionCollection
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaOptionCollection_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulcount: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulindex: u32,
        ppoption: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaPageImageableSize(::windows::runtime::IUnknown);
impl IPrintSchemaPageImageableSize {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn ImageableSizeWidthInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn ImageableSizeHeightInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn OriginWidthInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn OriginHeightInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn ExtentWidthInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn ExtentHeightInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaPageImageableSize {
    type Vtable = IPrintSchemaPageImageableSize_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2089140062,
        56444,
        20321,
        [131, 155, 65, 7, 225, 201, 182, 142],
    );
}
impl ::std::convert::From<IPrintSchemaPageImageableSize> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaPageImageableSize) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaPageImageableSize> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaPageImageableSize) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaPageImageableSize
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaPageImageableSize
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaPageImageableSize> for IPrintSchemaElement {
    fn from(value: IPrintSchemaPageImageableSize) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaPageImageableSize> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaPageImageableSize) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaPageImageableSize {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaPageImageableSize {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaPageImageableSize>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaPageImageableSize) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaPageImageableSize>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaPageImageableSize) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaPageImageableSize
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaPageImageableSize
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaPageImageableSize_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulimageablesizewidth: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulimageablesizeheight: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puloriginwidth: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puloriginheight: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulextentwidth: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulextentheight: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaPageMediaSizeOption(::windows::runtime::IUnknown);
impl IPrintSchemaPageMediaSizeOption {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Selected(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    pub unsafe fn Constrained(&self) -> ::windows::runtime::Result<PrintSchemaConstrainedSetting> {
        let mut result__: <PrintSchemaConstrainedSetting as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<PrintSchemaConstrainedSetting>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetPropertyValue<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    pub unsafe fn WidthInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn HeightInMicrons(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaPageMediaSizeOption {
    type Vtable = IPrintSchemaPageMediaSizeOption_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1752459049,
        62611,
        18480,
        [161, 15, 105, 2, 135, 116, 96, 93],
    );
}
impl ::std::convert::From<IPrintSchemaPageMediaSizeOption> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaPageMediaSizeOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaPageMediaSizeOption> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaPageMediaSizeOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaPageMediaSizeOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaPageMediaSizeOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaPageMediaSizeOption> for IPrintSchemaOption {
    fn from(value: IPrintSchemaPageMediaSizeOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaPageMediaSizeOption> for IPrintSchemaOption {
    fn from(value: &IPrintSchemaPageMediaSizeOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaOption> for IPrintSchemaPageMediaSizeOption {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaOption> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaOption>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaOption>
    for &IPrintSchemaPageMediaSizeOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaOption> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaOption>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IPrintSchemaPageMediaSizeOption> for IPrintSchemaDisplayableElement {
    fn from(value: IPrintSchemaPageMediaSizeOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaPageMediaSizeOption> for IPrintSchemaDisplayableElement {
    fn from(value: &IPrintSchemaPageMediaSizeOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement>
    for IPrintSchemaPageMediaSizeOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement>
    for &IPrintSchemaPageMediaSizeOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
impl ::std::convert::From<IPrintSchemaPageMediaSizeOption> for IPrintSchemaElement {
    fn from(value: IPrintSchemaPageMediaSizeOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaPageMediaSizeOption> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaPageMediaSizeOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement>
    for IPrintSchemaPageMediaSizeOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement>
    for &IPrintSchemaPageMediaSizeOption
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaPageMediaSizeOption>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaPageMediaSizeOption) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaPageMediaSizeOption>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaPageMediaSizeOption) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaPageMediaSizeOption
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaPageMediaSizeOption
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaPageMediaSizeOption_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrdisplayname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbisselected: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        psetting: *mut PrintSchemaConstrainedSetting,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppxmlvaluenode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulwidth: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulheight: *mut u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaParameterDefinition(::windows::runtime::IUnknown);
impl IPrintSchemaParameterDefinition {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn DisplayName(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UserInputRequired(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn UnitType(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn DataType(&self) -> ::windows::runtime::Result<PrintSchemaParameterDataType> {
        let mut result__: <PrintSchemaParameterDataType as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<PrintSchemaParameterDataType>(result__)
    }
    pub unsafe fn RangeMin(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    pub unsafe fn RangeMax(&self) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaParameterDefinition {
    type Vtable = IPrintSchemaParameterDefinition_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3048073246,
        3681,
        20449,
        [129, 198, 195, 51, 228, 255, 224, 241],
    );
}
impl ::std::convert::From<IPrintSchemaParameterDefinition> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaParameterDefinition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaParameterDefinition> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaParameterDefinition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaParameterDefinition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaParameterDefinition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaParameterDefinition> for IPrintSchemaDisplayableElement {
    fn from(value: IPrintSchemaParameterDefinition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaParameterDefinition> for IPrintSchemaDisplayableElement {
    fn from(value: &IPrintSchemaParameterDefinition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement>
    for IPrintSchemaParameterDefinition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaDisplayableElement>
    for &IPrintSchemaParameterDefinition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaDisplayableElement> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintSchemaDisplayableElement>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
impl ::std::convert::From<IPrintSchemaParameterDefinition> for IPrintSchemaElement {
    fn from(value: IPrintSchemaParameterDefinition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaParameterDefinition> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaParameterDefinition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement>
    for IPrintSchemaParameterDefinition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement>
    for &IPrintSchemaParameterDefinition
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaParameterDefinition>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaParameterDefinition) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaParameterDefinition>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaParameterDefinition) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaParameterDefinition
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaParameterDefinition
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaParameterDefinition_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrdisplayname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbisrequired: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrunittype: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdatatype: *mut PrintSchemaParameterDataType,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prangemin: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        prangemax: *mut i32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaParameterInitializer(::windows::runtime::IUnknown);
impl IPrintSchemaParameterInitializer {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Value(
        &self,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::VARIANT> {
        let mut result__ : < super::super::System::OleAutomation:: VARIANT as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::VARIANT>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn SetValue(
        &self,
        pvar: *const super::super::System::OleAutomation::VARIANT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pvar),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaParameterInitializer {
    type Vtable = IPrintSchemaParameterInitializer_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1375891586,
        2932,
        17992,
        [149, 100, 130, 140, 198, 203, 101, 108],
    );
}
impl ::std::convert::From<IPrintSchemaParameterInitializer> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaParameterInitializer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaParameterInitializer> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaParameterInitializer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintSchemaParameterInitializer
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintSchemaParameterInitializer
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaParameterInitializer> for IPrintSchemaElement {
    fn from(value: IPrintSchemaParameterInitializer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaParameterInitializer> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaParameterInitializer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement>
    for IPrintSchemaParameterInitializer
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement>
    for &IPrintSchemaParameterInitializer
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaParameterInitializer>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrintSchemaParameterInitializer) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaParameterInitializer>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrintSchemaParameterInitializer) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaParameterInitializer
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaParameterInitializer
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaParameterInitializer_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvar: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pvar: *const ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaTicket(::windows::runtime::IUnknown);
impl IPrintSchemaTicket {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeatureByKeyName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrkeyname: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            bstrkeyname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeature<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    pub unsafe fn ValidateAsync(&self) -> ::windows::runtime::Result<IPrintSchemaAsyncOperation> {
        let mut result__: <IPrintSchemaAsyncOperation as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaAsyncOperation>(result__)
    }
    pub unsafe fn CommitAsync<'a, Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaTicket>>(
        &self,
        pprintticketcommit: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaAsyncOperation> {
        let mut result__: <IPrintSchemaAsyncOperation as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pprintticketcommit.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaAsyncOperation>(result__)
    }
    pub unsafe fn NotifyXmlChanged(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetCapabilities(&self) -> ::windows::runtime::Result<IPrintSchemaCapabilities> {
        let mut result__: <IPrintSchemaCapabilities as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaCapabilities>(result__)
    }
    pub unsafe fn JobCopiesAllDocuments(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetJobCopiesAllDocuments(
        &self,
        uljobcopiesalldocuments: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uljobcopiesalldocuments),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaTicket {
    type Vtable = IPrintSchemaTicket_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3833641057,
        18184,
        20077,
        [165, 180, 162, 180, 238, 185, 186, 164],
    );
}
impl ::std::convert::From<IPrintSchemaTicket> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaTicket) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaTicket> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaTicket) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintSchemaTicket {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintSchemaTicket {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaTicket> for IPrintSchemaElement {
    fn from(value: IPrintSchemaTicket) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaTicket> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaTicket) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaTicket {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaTicket {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaTicket> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrintSchemaTicket) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaTicket> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrintSchemaTicket) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaTicket
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaTicket
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaTicket_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrkeyname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppasyncoperation: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintticketcommit: ::windows::runtime::RawPtr,
        ppasyncoperation: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppcapabilities: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puljobcopiesalldocuments: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uljobcopiesalldocuments: u32,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintSchemaTicket2(::windows::runtime::IUnknown);
impl IPrintSchemaTicket2 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn XmlNode(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn NamespaceUri(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeatureByKeyName<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrkeyname: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            bstrkeyname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetFeature<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<IPrintSchemaFeature> {
        let mut result__: <IPrintSchemaFeature as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaFeature>(result__)
    }
    pub unsafe fn ValidateAsync(&self) -> ::windows::runtime::Result<IPrintSchemaAsyncOperation> {
        let mut result__: <IPrintSchemaAsyncOperation as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaAsyncOperation>(result__)
    }
    pub unsafe fn CommitAsync<'a, Param0: ::windows::runtime::IntoParam<'a, IPrintSchemaTicket>>(
        &self,
        pprintticketcommit: Param0,
    ) -> ::windows::runtime::Result<IPrintSchemaAsyncOperation> {
        let mut result__: <IPrintSchemaAsyncOperation as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            pprintticketcommit.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaAsyncOperation>(result__)
    }
    pub unsafe fn NotifyXmlChanged(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetCapabilities(&self) -> ::windows::runtime::Result<IPrintSchemaCapabilities> {
        let mut result__: <IPrintSchemaCapabilities as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaCapabilities>(result__)
    }
    pub unsafe fn JobCopiesAllDocuments(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn SetJobCopiesAllDocuments(
        &self,
        uljobcopiesalldocuments: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(uljobcopiesalldocuments),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetParameterInitializer<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrnamespaceuri: Param1,
    ) -> ::windows::runtime::Result<IPrintSchemaParameterInitializer> {
        let mut result__: <IPrintSchemaParameterInitializer as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).18)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrnamespaceuri.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrintSchemaParameterInitializer>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintSchemaTicket2 {
    type Vtable = IPrintSchemaTicket2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        784463940,
        30314,
        18337,
        [145, 244, 46, 235, 97, 144, 248, 12],
    );
}
impl ::std::convert::From<IPrintSchemaTicket2> for ::windows::runtime::IUnknown {
    fn from(value: IPrintSchemaTicket2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaTicket2> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintSchemaTicket2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintSchemaTicket2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintSchemaTicket2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintSchemaTicket2> for IPrintSchemaTicket {
    fn from(value: IPrintSchemaTicket2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaTicket2> for IPrintSchemaTicket {
    fn from(value: &IPrintSchemaTicket2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaTicket> for IPrintSchemaTicket2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaTicket> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaTicket>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaTicket> for &IPrintSchemaTicket2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaTicket> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaTicket>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
impl ::std::convert::From<IPrintSchemaTicket2> for IPrintSchemaElement {
    fn from(value: IPrintSchemaTicket2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintSchemaTicket2> for IPrintSchemaElement {
    fn from(value: &IPrintSchemaTicket2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for IPrintSchemaTicket2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintSchemaElement> for &IPrintSchemaTicket2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintSchemaElement> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintSchemaElement>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrintSchemaTicket2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrintSchemaTicket2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrintSchemaTicket2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrintSchemaTicket2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrintSchemaTicket2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrintSchemaTicket2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintSchemaTicket2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppxmlnode: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrnamespaceuri: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrkeyname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppfeature: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppasyncoperation: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintticketcommit: ::windows::runtime::RawPtr,
        ppasyncoperation: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppcapabilities: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        puljobcopiesalldocuments: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        uljobcopiesalldocuments: u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrnamespaceuri: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppparameterinitializer: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintTicketProvider(::windows::runtime::IUnknown);
impl IPrintTicketProvider {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSupportedVersions<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        ppversions: *mut *mut i32,
        cversions: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(ppversions),
            ::std::mem::transmute(cversions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BindPrinter<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        version: i32,
        poptions: *mut SHIMOPTS,
        pdevmodeflags: *mut u32,
        cnamespaces: *mut i32,
        ppnamespaces: *mut *mut super::super::Foundation::BSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(version),
            ::std::mem::transmute(poptions),
            ::std::mem::transmute(pdevmodeflags),
            ::std::mem::transmute(cnamespaces),
            ::std::mem::transmute(ppnamespaces),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryDeviceNamespace(
        &self,
        pdefaultnamespace: *mut super::super::Foundation::BSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdefaultnamespace),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub unsafe fn ConvertPrintTicketToDevMode<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pprintticket: Param0,
        cbdevmodein: u32,
        pdevmodein: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pcbdevmodeout: *mut u32,
        ppdevmodeout: *mut *mut super::super::UI::DisplayDevices::DEVMODEA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            pprintticket.into_param().abi(),
            ::std::mem::transmute(cbdevmodein),
            ::std::mem::transmute(pdevmodein),
            ::std::mem::transmute(pcbdevmodeout),
            ::std::mem::transmute(ppdevmodeout),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub unsafe fn ConvertDevModeToPrintTicket<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        cbdevmode: u32,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pprintticket: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cbdevmode),
            ::std::mem::transmute(pdevmode),
            pprintticket.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub unsafe fn GetPrintCapabilities<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pprintticket: Param0,
    ) -> ::windows::runtime::Result<super::super::Data::Xml::MsXml::IXMLDOMDocument2> {
        let mut result__ : < super::super::Data::Xml::MsXml:: IXMLDOMDocument2 as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pprintticket.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Data::Xml::MsXml::IXMLDOMDocument2>(result__)
    }
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub unsafe fn ValidatePrintTicket<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pbaseticket: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            pbaseticket.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintTicketProvider {
    type Vtable = IPrintTicketProvider_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3142653659,
        2595,
        19514,
        [166, 182, 137, 229, 85, 141, 251, 93],
    );
}
impl ::std::convert::From<IPrintTicketProvider> for ::windows::runtime::IUnknown {
    fn from(value: IPrintTicketProvider) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintTicketProvider> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintTicketProvider) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintTicketProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrintTicketProvider {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintTicketProvider_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        ppversions: *mut *mut i32,
        cversions: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        version: i32,
        poptions: *mut SHIMOPTS,
        pdevmodeflags: *mut u32,
        cnamespaces: *mut i32,
        ppnamespaces: *mut *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdefaultnamespace: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintticket: ::windows::runtime::RawPtr,
        cbdevmodein: u32,
        pdevmodein: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pcbdevmodeout: *mut u32,
        ppdevmodeout: *mut *mut super::super::UI::DisplayDevices::DEVMODEA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cbdevmode: u32,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pprintticket: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    )))]
    usize,
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintticket: ::windows::runtime::RawPtr,
        ppcapabilities: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Data_Xml_MsXml"))] usize,
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbaseticket: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Data_Xml_MsXml"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintTicketProvider2(::windows::runtime::IUnknown);
impl IPrintTicketProvider2 {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetSupportedVersions<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        ppversions: *mut *mut i32,
        cversions: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(ppversions),
            ::std::mem::transmute(cversions),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BindPrinter<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::HANDLE>,
    >(
        &self,
        hprinter: Param0,
        version: i32,
        poptions: *mut SHIMOPTS,
        pdevmodeflags: *mut u32,
        cnamespaces: *mut i32,
        ppnamespaces: *mut *mut super::super::Foundation::BSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            hprinter.into_param().abi(),
            ::std::mem::transmute(version),
            ::std::mem::transmute(poptions),
            ::std::mem::transmute(pdevmodeflags),
            ::std::mem::transmute(cnamespaces),
            ::std::mem::transmute(ppnamespaces),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn QueryDeviceNamespace(
        &self,
        pdefaultnamespace: *mut super::super::Foundation::BSTR,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(pdefaultnamespace),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub unsafe fn ConvertPrintTicketToDevMode<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pprintticket: Param0,
        cbdevmodein: u32,
        pdevmodein: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pcbdevmodeout: *mut u32,
        ppdevmodeout: *mut *mut super::super::UI::DisplayDevices::DEVMODEA,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            pprintticket.into_param().abi(),
            ::std::mem::transmute(cbdevmodein),
            ::std::mem::transmute(pdevmodein),
            ::std::mem::transmute(pcbdevmodeout),
            ::std::mem::transmute(ppdevmodeout),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub unsafe fn ConvertDevModeToPrintTicket<
        'a,
        Param2: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        cbdevmode: u32,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pprintticket: Param2,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(cbdevmode),
            ::std::mem::transmute(pdevmode),
            pprintticket.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub unsafe fn GetPrintCapabilities<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pprintticket: Param0,
    ) -> ::windows::runtime::Result<super::super::Data::Xml::MsXml::IXMLDOMDocument2> {
        let mut result__ : < super::super::Data::Xml::MsXml:: IXMLDOMDocument2 as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pprintticket.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Data::Xml::MsXml::IXMLDOMDocument2>(result__)
    }
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub unsafe fn ValidatePrintTicket<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pbaseticket: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            pbaseticket.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub unsafe fn GetPrintDeviceCapabilities<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pprintticket: Param0,
    ) -> ::windows::runtime::Result<super::super::Data::Xml::MsXml::IXMLDOMDocument2> {
        let mut result__ : < super::super::Data::Xml::MsXml:: IXMLDOMDocument2 as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            pprintticket.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Data::Xml::MsXml::IXMLDOMDocument2>(result__)
    }
    #[cfg(all(feature = "Win32_Data_Xml_MsXml", feature = "Win32_Foundation"))]
    pub unsafe fn GetPrintDeviceResources<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::PWSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Data::Xml::MsXml::IXMLDOMDocument2>,
    >(
        &self,
        pszlocalename: Param0,
        pprintticket: Param1,
    ) -> ::windows::runtime::Result<super::super::Data::Xml::MsXml::IXMLDOMDocument2> {
        let mut result__ : < super::super::Data::Xml::MsXml:: IXMLDOMDocument2 as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            pszlocalename.into_param().abi(),
            pprintticket.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Data::Xml::MsXml::IXMLDOMDocument2>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrintTicketProvider2 {
    type Vtable = IPrintTicketProvider2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3097954994,
        15868,
        20460,
        [160, 116, 81, 27, 19, 198, 81, 203],
    );
}
impl ::std::convert::From<IPrintTicketProvider2> for ::windows::runtime::IUnknown {
    fn from(value: IPrintTicketProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintTicketProvider2> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintTicketProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrintTicketProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintTicketProvider2
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintTicketProvider2> for IPrintTicketProvider {
    fn from(value: IPrintTicketProvider2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintTicketProvider2> for IPrintTicketProvider {
    fn from(value: &IPrintTicketProvider2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintTicketProvider> for IPrintTicketProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintTicketProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintTicketProvider>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintTicketProvider> for &IPrintTicketProvider2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintTicketProvider> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrintTicketProvider>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintTicketProvider2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        ppversions: *mut *mut i32,
        cversions: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hprinter: super::super::Foundation::HANDLE,
        version: i32,
        poptions: *mut SHIMOPTS,
        pdevmodeflags: *mut u32,
        cnamespaces: *mut i32,
        ppnamespaces: *mut *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdefaultnamespace: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintticket: ::windows::runtime::RawPtr,
        cbdevmodein: u32,
        pdevmodein: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pcbdevmodeout: *mut u32,
        ppdevmodeout: *mut *mut super::super::UI::DisplayDevices::DEVMODEA,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        cbdevmode: u32,
        pdevmode: *mut super::super::UI::DisplayDevices::DEVMODEA,
        pprintticket: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Data_Xml_MsXml",
        feature = "Win32_Foundation",
        feature = "Win32_UI_DisplayDevices"
    )))]
    usize,
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintticket: ::windows::runtime::RawPtr,
        ppcapabilities: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Data_Xml_MsXml"))] usize,
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbaseticket: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Data_Xml_MsXml"))] usize,
    #[cfg(feature = "Win32_Data_Xml_MsXml")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprintticket: ::windows::runtime::RawPtr,
        ppdevicecapabilities: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Data_Xml_MsXml"))] usize,
    #[cfg(all(feature = "Win32_Data_Xml_MsXml", feature = "Win32_Foundation"))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pszlocalename: super::super::Foundation::PWSTR,
        pprintticket: ::windows::runtime::RawPtr,
        ppdeviceresources: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(feature = "Win32_Data_Xml_MsXml", feature = "Win32_Foundation")))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrintUnidiAsyncNotifyRegistration(::windows::runtime::IUnknown);
impl IPrintUnidiAsyncNotifyRegistration {
    pub unsafe fn RegisterForNotifications(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn UnregisterForNotifications(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn AsyncGetNotification<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IAsyncGetSendNotificationCookie>,
    >(
        &self,
        param0: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            param0.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrintUnidiAsyncNotifyRegistration {
    type Vtable = IPrintUnidiAsyncNotifyRegistration_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::zeroed();
}
impl ::std::convert::From<IPrintUnidiAsyncNotifyRegistration> for ::windows::runtime::IUnknown {
    fn from(value: IPrintUnidiAsyncNotifyRegistration) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintUnidiAsyncNotifyRegistration> for ::windows::runtime::IUnknown {
    fn from(value: &IPrintUnidiAsyncNotifyRegistration) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrintUnidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrintUnidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrintUnidiAsyncNotifyRegistration> for IPrintAsyncNotifyRegistration {
    fn from(value: IPrintUnidiAsyncNotifyRegistration) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrintUnidiAsyncNotifyRegistration> for IPrintAsyncNotifyRegistration {
    fn from(value: &IPrintUnidiAsyncNotifyRegistration) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyRegistration>
    for IPrintUnidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncNotifyRegistration> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintAsyncNotifyRegistration>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrintAsyncNotifyRegistration>
    for &IPrintUnidiAsyncNotifyRegistration
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrintAsyncNotifyRegistration> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<IPrintAsyncNotifyRegistration>::into(
                ::std::clone::Clone::clone(self),
            ),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrintUnidiAsyncNotifyRegistration_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        param0: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintWriteStream {
    pub lpVtbl: *mut IPrintWriteStreamVtbl,
}
impl IPrintWriteStream {}
impl ::std::default::Default for IPrintWriteStream {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintWriteStream {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintWriteStream")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintWriteStream {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintWriteStream {}
unsafe impl ::windows::runtime::Abi for IPrintWriteStream {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintWriteStreamFlush {
    pub lpVtbl: *mut IPrintWriteStreamFlushVtbl,
}
impl IPrintWriteStreamFlush {}
impl ::std::default::Default for IPrintWriteStreamFlush {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintWriteStreamFlush {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintWriteStreamFlush")
            .field("lpVtbl", &self.lpVtbl)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintWriteStreamFlush {
    fn eq(&self, other: &Self) -> bool {
        self.lpVtbl == other.lpVtbl
    }
}
impl ::std::cmp::Eq for IPrintWriteStreamFlush {}
unsafe impl ::windows::runtime::Abi for IPrintWriteStreamFlush {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintWriteStreamFlushVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub FlushData: isize,
}
impl IPrintWriteStreamFlushVtbl {}
impl ::std::default::Default for IPrintWriteStreamFlushVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintWriteStreamFlushVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintWriteStreamFlushVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("FlushData", &self.FlushData)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintWriteStreamFlushVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.FlushData == other.FlushData
    }
}
impl ::std::cmp::Eq for IPrintWriteStreamFlushVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintWriteStreamFlushVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[derive(:: std :: clone :: Clone, :: std :: marker :: Copy)]
#[repr(C)]
pub struct IPrintWriteStreamVtbl {
    pub QueryInterface: isize,
    pub AddRef: isize,
    pub Release: isize,
    pub WriteBytes: isize,
    pub Close: isize,
}
impl IPrintWriteStreamVtbl {}
impl ::std::default::Default for IPrintWriteStreamVtbl {
    fn default() -> Self {
        unsafe { ::std::mem::zeroed() }
    }
}
impl ::std::fmt::Debug for IPrintWriteStreamVtbl {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.debug_struct("IPrintWriteStreamVtbl")
            .field("QueryInterface", &self.QueryInterface)
            .field("AddRef", &self.AddRef)
            .field("Release", &self.Release)
            .field("WriteBytes", &self.WriteBytes)
            .field("Close", &self.Close)
            .finish()
    }
}
impl ::std::cmp::PartialEq for IPrintWriteStreamVtbl {
    fn eq(&self, other: &Self) -> bool {
        self.QueryInterface == other.QueryInterface
            && self.AddRef == other.AddRef
            && self.Release == other.Release
            && self.WriteBytes == other.WriteBytes
            && self.Close == other.Close
    }
}
impl ::std::cmp::Eq for IPrintWriteStreamVtbl {}
unsafe impl ::windows::runtime::Abi for IPrintWriteStreamVtbl {
    type Abi = Self;
    type DefaultType = Self;
}
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterBidiSetRequestCallback(::windows::runtime::IUnknown);
impl IPrinterBidiSetRequestCallback {
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Completed<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrresponse: Param0,
        hrstatus: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            bstrresponse.into_param().abi(),
            ::std::mem::transmute(hrstatus),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterBidiSetRequestCallback {
    type Vtable = IPrinterBidiSetRequestCallback_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3308073693,
        62132,
        16466,
        [133, 2, 236, 67, 5, 236, 183, 31],
    );
}
impl ::std::convert::From<IPrinterBidiSetRequestCallback> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterBidiSetRequestCallback) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterBidiSetRequestCallback> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterBidiSetRequestCallback) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterBidiSetRequestCallback
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterBidiSetRequestCallback
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterBidiSetRequestCallback_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrresponse: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        hrstatus: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterExtensionAsyncOperation(::windows::runtime::IUnknown);
impl IPrinterExtensionAsyncOperation {
    pub unsafe fn Cancel(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterExtensionAsyncOperation {
    type Vtable = IPrinterExtensionAsyncOperation_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        277703203,
        27211,
        17746,
        [148, 72, 104, 180, 39, 24, 106, 205],
    );
}
impl ::std::convert::From<IPrinterExtensionAsyncOperation> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterExtensionAsyncOperation) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionAsyncOperation> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterExtensionAsyncOperation) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterExtensionAsyncOperation
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterExtensionAsyncOperation
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterExtensionAsyncOperation_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterExtensionContext(::windows::runtime::IUnknown);
impl IPrinterExtensionContext {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn PrinterQueue(&self) -> ::windows::runtime::Result<IPrinterQueue> {
        let mut result__: <IPrinterQueue as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterQueue>(result__)
    }
    pub unsafe fn PrintSchemaTicket(&self) -> ::windows::runtime::Result<IPrintSchemaTicket> {
        let mut result__: <IPrintSchemaTicket as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaTicket>(result__)
    }
    pub unsafe fn DriverProperties(&self) -> ::windows::runtime::Result<IPrinterPropertyBag> {
        let mut result__: <IPrinterPropertyBag as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterPropertyBag>(result__)
    }
    pub unsafe fn UserProperties(&self) -> ::windows::runtime::Result<IPrinterPropertyBag> {
        let mut result__: <IPrinterPropertyBag as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterPropertyBag>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterExtensionContext {
    type Vtable = IPrinterExtensionContext_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        964967410,
        50386,
        16893,
        [180, 178, 174, 219, 238, 94, 25, 0],
    );
}
impl ::std::convert::From<IPrinterExtensionContext> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterExtensionContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionContext> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterExtensionContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterExtensionContext
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterExtensionContext
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterExtensionContext>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrinterExtensionContext) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterExtensionContext>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrinterExtensionContext) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterExtensionContext
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterExtensionContext
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterExtensionContext_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppqueue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppticket: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppropertybag: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppropertybag: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterExtensionContextCollection(::windows::runtime::IUnknown);
impl IPrinterExtensionContextCollection {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn Count(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    pub unsafe fn GetAt(
        &self,
        ulindex: u32,
    ) -> ::windows::runtime::Result<IPrinterExtensionContext> {
        let mut result__: <IPrinterExtensionContext as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulindex),
            &mut result__,
        )
        .from_abi::<IPrinterExtensionContext>(result__)
    }
    pub unsafe fn _NewEnum(&self) -> ::windows::runtime::Result<::windows::runtime::IUnknown> {
        let mut result__: <::windows::runtime::IUnknown as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::IUnknown>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterExtensionContextCollection {
    type Vtable = IPrinterExtensionContextCollection_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4215761264,
        39851,
        18529,
        [129, 30, 62, 152, 176, 197, 173, 223],
    );
}
impl ::std::convert::From<IPrinterExtensionContextCollection> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterExtensionContextCollection) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionContextCollection> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterExtensionContextCollection) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterExtensionContextCollection
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterExtensionContextCollection
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterExtensionContextCollection>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrinterExtensionContextCollection) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterExtensionContextCollection>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrinterExtensionContextCollection) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterExtensionContextCollection
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterExtensionContextCollection
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterExtensionContextCollection_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pulcount: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulindex: u32,
        ppcontext: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppunk: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterExtensionEvent(::windows::runtime::IUnknown);
impl IPrinterExtensionEvent {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn OnDriverEvent<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrinterExtensionEventArgs>,
    >(
        &self,
        peventargs: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            peventargs.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OnPrinterQueuesEnumerated<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, IPrinterExtensionContextCollection>,
    >(
        &self,
        pcontextcollection: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            pcontextcollection.into_param().abi(),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterExtensionEvent {
    type Vtable = IPrinterExtensionEvent_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        3230911331,
        24309,
        17797,
        [175, 142, 77, 86, 55, 72, 123, 87],
    );
}
impl ::std::convert::From<IPrinterExtensionEvent> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterExtensionEvent) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionEvent> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterExtensionEvent) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterExtensionEvent
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterExtensionEvent
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterExtensionEvent>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrinterExtensionEvent) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterExtensionEvent>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrinterExtensionEvent) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterExtensionEvent
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterExtensionEvent
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterExtensionEvent_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        peventargs: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pcontextcollection: ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterExtensionEventArgs(::windows::runtime::IUnknown);
impl IPrinterExtensionEventArgs {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn PrinterQueue(&self) -> ::windows::runtime::Result<IPrinterQueue> {
        let mut result__: <IPrinterQueue as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterQueue>(result__)
    }
    pub unsafe fn PrintSchemaTicket(&self) -> ::windows::runtime::Result<IPrintSchemaTicket> {
        let mut result__: <IPrintSchemaTicket as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrintSchemaTicket>(result__)
    }
    pub unsafe fn DriverProperties(&self) -> ::windows::runtime::Result<IPrinterPropertyBag> {
        let mut result__: <IPrinterPropertyBag as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterPropertyBag>(result__)
    }
    pub unsafe fn UserProperties(&self) -> ::windows::runtime::Result<IPrinterPropertyBag> {
        let mut result__: <IPrinterPropertyBag as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterPropertyBag>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn BidiNotification(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn ReasonId(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::GUID>(result__)
    }
    pub unsafe fn Request(&self) -> ::windows::runtime::Result<IPrinterExtensionRequest> {
        let mut result__: <IPrinterExtensionRequest as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterExtensionRequest>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SourceApplication(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    pub unsafe fn DetailedReasonId(&self) -> ::windows::runtime::Result<::windows::runtime::GUID> {
        let mut result__: <::windows::runtime::GUID as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<::windows::runtime::GUID>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WindowModal(&self) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn WindowParent(
        &self,
    ) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).17)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HANDLE>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterExtensionEventArgs {
    type Vtable = IPrinterExtensionEventArgs_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        964967412,
        50386,
        16893,
        [180, 178, 174, 219, 238, 94, 25, 0],
    );
}
impl ::std::convert::From<IPrinterExtensionEventArgs> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterExtensionEventArgs) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionEventArgs> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterExtensionEventArgs) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterExtensionEventArgs
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterExtensionEventArgs
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrinterExtensionEventArgs> for IPrinterExtensionContext {
    fn from(value: IPrinterExtensionEventArgs) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionEventArgs> for IPrinterExtensionContext {
    fn from(value: &IPrinterExtensionEventArgs) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrinterExtensionContext>
    for IPrinterExtensionEventArgs
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrinterExtensionContext> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrinterExtensionContext>::into(
            self,
        ))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrinterExtensionContext>
    for &IPrinterExtensionEventArgs
{
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrinterExtensionContext> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrinterExtensionContext>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterExtensionEventArgs>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrinterExtensionEventArgs) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterExtensionEventArgs>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrinterExtensionEventArgs) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterExtensionEventArgs
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterExtensionEventArgs
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterExtensionEventArgs_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppqueue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ppticket: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppropertybag: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppropertybag: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrbidinotification: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        preasonid: *mut ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pprequest: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrapplication: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pdetailedreasonid: *mut ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbmodal: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phwndparent: *mut super::super::Foundation::HANDLE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterExtensionManager(::windows::runtime::IUnknown);
impl IPrinterExtensionManager {
    pub unsafe fn EnableEvents<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, ::windows::runtime::GUID>,
    >(
        &self,
        printerdriverid: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            printerdriverid.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DisableEvents(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).4)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterExtensionManager {
    type Vtable = IPrinterExtensionManager_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2479287180,
        45057,
        17237,
        [150, 41, 142, 138, 27, 63, 142, 119],
    );
}
impl ::std::convert::From<IPrinterExtensionManager> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterExtensionManager) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionManager> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterExtensionManager) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterExtensionManager
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterExtensionManager
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterExtensionManager_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        printerdriverid: ::windows::runtime::GUID,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterExtensionRequest(::windows::runtime::IUnknown);
impl IPrinterExtensionRequest {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Cancel<
        'a,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        hrstatus: ::windows::runtime::HRESULT,
        bstrlogmessage: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(hrstatus),
            bstrlogmessage.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Complete(&self) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(::std::mem::transmute_copy(self)).ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterExtensionRequest {
    type Vtable = IPrinterExtensionRequest_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        964967411,
        50386,
        16893,
        [180, 178, 174, 219, 238, 94, 25, 0],
    );
}
impl ::std::convert::From<IPrinterExtensionRequest> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterExtensionRequest) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterExtensionRequest> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterExtensionRequest) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for IPrinterExtensionRequest
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown>
    for &IPrinterExtensionRequest
{
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterExtensionRequest>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: IPrinterExtensionRequest) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterExtensionRequest>
    for super::super::System::OleAutomation::IDispatch
{
    fn from(value: &IPrinterExtensionRequest) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterExtensionRequest
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterExtensionRequest
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterExtensionRequest_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        hrstatus: ::windows::runtime::HRESULT,
        bstrlogmessage: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterPropertyBag(::windows::runtime::IUnknown);
impl IPrinterPropertyBag {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBool<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BOOL> {
        let mut result__: <super::super::Foundation::BOOL as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BOOL>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBool<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BOOL>,
    >(
        &self,
        bstrname: Param0,
        bvalue: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bvalue.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetInt32<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
    ) -> ::windows::runtime::Result<i32> {
        let mut result__: <i32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<i32>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetInt32<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        nvalue: i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            ::std::mem::transmute(nvalue),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetString<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
    ) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetString<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        bstrvalue: Param1,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            bstrvalue.into_param().abi(),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetBytes<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        pcbvalue: *mut u32,
        ppvalue: *mut *mut u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).13)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            ::std::mem::transmute(pcbvalue),
            ::std::mem::transmute(ppvalue),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SetBytes<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
        cbvalue: u32,
        pvalue: *const u8,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).14)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            ::std::mem::transmute(cbvalue),
            ::std::mem::transmute(pvalue),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn GetReadStream<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
    ) -> ::windows::runtime::Result<super::super::Storage::StructuredStorage::IStream> {
        let mut result__ : < super::super::Storage::StructuredStorage:: IStream as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).15)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Storage::StructuredStorage::IStream>(result__)
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub unsafe fn GetWriteStream<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrname: Param0,
    ) -> ::windows::runtime::Result<super::super::Storage::StructuredStorage::IStream> {
        let mut result__ : < super::super::Storage::StructuredStorage:: IStream as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).16)(
            ::std::mem::transmute_copy(self),
            bstrname.into_param().abi(),
            &mut result__,
        )
        .from_abi::<super::super::Storage::StructuredStorage::IStream>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterPropertyBag {
    type Vtable = IPrinterPropertyBag_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        4272386916,
        57237,
        18979,
        [169, 5, 1, 155, 121, 168, 228, 129],
    );
}
impl ::std::convert::From<IPrinterPropertyBag> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterPropertyBag) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterPropertyBag> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterPropertyBag) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrinterPropertyBag {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrinterPropertyBag {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterPropertyBag> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrinterPropertyBag) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterPropertyBag> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrinterPropertyBag) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterPropertyBag
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterPropertyBag
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterPropertyBag_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        pbvalue: *mut super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bvalue: super::super::Foundation::BOOL,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        pnvalue: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        nvalue: i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        pbstrvalue: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        bstrvalue: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        pcbvalue: *mut u32,
        ppvalue: *mut *mut u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        cbvalue: u32,
        pvalue: *const u8,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrname: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        ppvalue: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_Storage_StructuredStorage"
    )))]
    usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterQueue(::windows::runtime::IUnknown);
impl IPrinterQueue {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Handle(&self) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SendBidiQuery<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrbidiquery: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            bstrbidiquery.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetProperties(&self) -> ::windows::runtime::Result<IPrinterPropertyBag> {
        let mut result__: <IPrinterPropertyBag as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterPropertyBag>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterQueue {
    type Vtable = IPrinterQueue_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        897624104,
        2046,
        19348,
        [172, 26, 117, 125, 157, 45, 48, 86],
    );
}
impl ::std::convert::From<IPrinterQueue> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterQueue) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterQueue> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterQueue) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrinterQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrinterQueue {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterQueue> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrinterQueue) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterQueue> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrinterQueue) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterQueue
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterQueue
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterQueue_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phprinter: *mut super::super::Foundation::HANDLE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrbidiquery: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppropertybag: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterQueue2(::windows::runtime::IUnknown);
impl IPrinterQueue2 {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Handle(&self) -> ::windows::runtime::Result<super::super::Foundation::HANDLE> {
        let mut result__: <super::super::Foundation::HANDLE as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::HANDLE>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn Name(&self) -> ::windows::runtime::Result<super::super::Foundation::BSTR> {
        let mut result__: <super::super::Foundation::BSTR as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).8)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<super::super::Foundation::BSTR>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SendBidiQuery<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrbidiquery: Param0,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).9)(
            ::std::mem::transmute_copy(self),
            bstrbidiquery.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetProperties(&self) -> ::windows::runtime::Result<IPrinterPropertyBag> {
        let mut result__: <IPrinterPropertyBag as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).10)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<IPrinterPropertyBag>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn SendBidiSetRequestAsync<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
        Param1: ::windows::runtime::IntoParam<'a, IPrinterBidiSetRequestCallback>,
    >(
        &self,
        bstrbidirequest: Param0,
        pcallback: Param1,
    ) -> ::windows::runtime::Result<IPrinterExtensionAsyncOperation> {
        let mut result__: <IPrinterExtensionAsyncOperation as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).11)(
            ::std::mem::transmute_copy(self),
            bstrbidirequest.into_param().abi(),
            pcallback.into_param().abi(),
            &mut result__,
        )
        .from_abi::<IPrinterExtensionAsyncOperation>(result__)
    }
    pub unsafe fn GetPrinterQueueView(
        &self,
        ulviewoffset: u32,
        ulviewsize: u32,
    ) -> ::windows::runtime::Result<IPrinterQueueView> {
        let mut result__: <IPrinterQueueView as ::windows::runtime::Abi>::Abi =
            ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).12)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulviewoffset),
            ::std::mem::transmute(ulviewsize),
            &mut result__,
        )
        .from_abi::<IPrinterQueueView>(result__)
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterQueue2 {
    type Vtable = IPrinterQueue2_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        2362721512,
        51643,
        18867,
        [142, 56, 224, 50, 9, 65, 97, 49],
    );
}
impl ::std::convert::From<IPrinterQueue2> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterQueue2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterQueue2> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterQueue2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrinterQueue2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrinterQueue2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
impl ::std::convert::From<IPrinterQueue2> for IPrinterQueue {
    fn from(value: IPrinterQueue2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterQueue2> for IPrinterQueue {
    fn from(value: &IPrinterQueue2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrinterQueue> for IPrinterQueue2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrinterQueue> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrinterQueue>::into(self))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, IPrinterQueue> for &IPrinterQueue2 {
    fn into_param(self) -> ::windows::runtime::Param<'a, IPrinterQueue> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<IPrinterQueue>::into(
            ::std::clone::Clone::clone(self),
        ))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterQueue2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrinterQueue2) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterQueue2> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrinterQueue2) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterQueue2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterQueue2
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterQueue2_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        phprinter: *mut super::super::Foundation::HANDLE,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pbstrname: *mut ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrbidiquery: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pppropertybag: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrbidirequest: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        pcallback: ::windows::runtime::RawPtr,
        ppasyncoperation: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        ulviewoffset: u32,
        ulviewsize: u32,
        ppjobview: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterQueueEvent(::windows::runtime::IUnknown);
impl IPrinterQueueEvent {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn OnBidiResponseReceived<
        'a,
        Param0: ::windows::runtime::IntoParam<'a, super::super::Foundation::BSTR>,
    >(
        &self,
        bstrresponse: Param0,
        hrstatus: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            bstrresponse.into_param().abi(),
            ::std::mem::transmute(hrstatus),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterQueueEvent {
    type Vtable = IPrinterQueueEvent_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        558269942,
        31608,
        18049,
        [135, 224, 73, 95, 115, 146, 115, 209],
    );
}
impl ::std::convert::From<IPrinterQueueEvent> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterQueueEvent) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterQueueEvent> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterQueueEvent) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrinterQueueEvent {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrinterQueueEvent {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterQueueEvent> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrinterQueueEvent) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterQueueEvent> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrinterQueueEvent) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterQueueEvent
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterQueueEvent
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterQueueEvent_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        itinfo: u32,
        lcid: u32,
        pptinfo: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_System_OleAutomation"))] usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::VARIANT>,
        pexcepinfo: *mut ::std::mem::ManuallyDrop<super::super::System::OleAutomation::EXCEPINFO>,
        puargerr: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    )))]
    usize,
    #[cfg(feature = "Win32_Foundation")]
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        bstrresponse: ::std::mem::ManuallyDrop<super::super::Foundation::BSTR>,
        hrstatus: ::windows::runtime::HRESULT,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(not(feature = "Win32_Foundation"))] usize,
);
#[repr(transparent)]
#[derive(
    :: std :: cmp :: PartialEq,
    :: std :: cmp :: Eq,
    :: std :: clone :: Clone,
    :: std :: fmt :: Debug,
)]
pub struct IPrinterQueueView(::windows::runtime::IUnknown);
impl IPrinterQueueView {
    pub unsafe fn GetTypeInfoCount(&self) -> ::windows::runtime::Result<u32> {
        let mut result__: <u32 as ::windows::runtime::Abi>::Abi = ::std::mem::zeroed();
        (::windows::runtime::Interface::vtable(self).3)(
            ::std::mem::transmute_copy(self),
            &mut result__,
        )
        .from_abi::<u32>(result__)
    }
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub unsafe fn GetTypeInfo(
        &self,
        itinfo: u32,
        lcid: u32,
    ) -> ::windows::runtime::Result<super::super::System::OleAutomation::ITypeInfo> {
        let mut result__ : < super::super::System::OleAutomation:: ITypeInfo as :: windows :: runtime :: Abi > :: Abi = :: std :: mem :: zeroed ( ) ;
        (::windows::runtime::Interface::vtable(self).4)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(itinfo),
            ::std::mem::transmute(lcid),
            &mut result__,
        )
        .from_abi::<super::super::System::OleAutomation::ITypeInfo>(result__)
    }
    #[cfg(feature = "Win32_Foundation")]
    pub unsafe fn GetIDsOfNames(
        &self,
        riid: *const ::windows::runtime::GUID,
        rgsznames: *const super::super::Foundation::PWSTR,
        cnames: u32,
        lcid: u32,
        rgdispid: *mut i32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).5)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(rgsznames),
            ::std::mem::transmute(cnames),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(rgdispid),
        )
        .ok()
    }
    #[cfg(all(
        feature = "Win32_Foundation",
        feature = "Win32_System_OleAutomation",
        feature = "Win32_System_SystemServices"
    ))]
    pub unsafe fn Invoke(
        &self,
        dispidmember: i32,
        riid: *const ::windows::runtime::GUID,
        lcid: u32,
        wflags: u16,
        pdispparams: *const super::super::System::OleAutomation::DISPPARAMS,
        pvarresult: *mut super::super::System::OleAutomation::VARIANT,
        pexcepinfo: *mut super::super::System::OleAutomation::EXCEPINFO,
        puargerr: *mut u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).6)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(dispidmember),
            ::std::mem::transmute(riid),
            ::std::mem::transmute(lcid),
            ::std::mem::transmute(wflags),
            ::std::mem::transmute(pdispparams),
            ::std::mem::transmute(pvarresult),
            ::std::mem::transmute(pexcepinfo),
            ::std::mem::transmute(puargerr),
        )
        .ok()
    }
    pub unsafe fn SetViewRange(
        &self,
        ulviewoffset: u32,
        ulviewsize: u32,
    ) -> ::windows::runtime::Result<()> {
        (::windows::runtime::Interface::vtable(self).7)(
            ::std::mem::transmute_copy(self),
            ::std::mem::transmute(ulviewoffset),
            ::std::mem::transmute(ulviewsize),
        )
        .ok()
    }
}
unsafe impl ::windows::runtime::Interface for IPrinterQueueView {
    type Vtable = IPrinterQueueView_abi;
    const IID: ::windows::runtime::GUID = ::windows::runtime::GUID::from_values(
        1198401897,
        15147,
        19263,
        [130, 119, 207, 246, 5, 96, 66, 170],
    );
}
impl ::std::convert::From<IPrinterQueueView> for ::windows::runtime::IUnknown {
    fn from(value: IPrinterQueueView) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
impl ::std::convert::From<&IPrinterQueueView> for ::windows::runtime::IUnknown {
    fn from(value: &IPrinterQueueView) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for IPrinterQueueView {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(self),
        )
    }
}
impl<'a> ::windows::runtime::IntoParam<'a, ::windows::runtime::IUnknown> for &IPrinterQueueView {
    fn into_param(self) -> ::windows::runtime::Param<'a, ::windows::runtime::IUnknown> {
        ::windows::runtime::Param::Owned(
            ::std::convert::Into::<::windows::runtime::IUnknown>::into(::std::clone::Clone::clone(
                self,
            )),
        )
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<IPrinterQueueView> for super::super::System::OleAutomation::IDispatch {
    fn from(value: IPrinterQueueView) -> Self {
        unsafe { ::std::mem::transmute(value) }
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl ::std::convert::From<&IPrinterQueueView> for super::super::System::OleAutomation::IDispatch {
    fn from(value: &IPrinterQueueView) -> Self {
        ::std::convert::From::from(::std::clone::Clone::clone(value))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for IPrinterQueueView
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(self))
    }
}
#[cfg(feature = "Win32_System_OleAutomation")]
impl<'a> ::windows::runtime::IntoParam<'a, super::super::System::OleAutomation::IDispatch>
    for &IPrinterQueueView
{
    fn into_param(
        self,
    ) -> ::windows::runtime::Param<'a, super::super::System::OleAutomation::IDispatch> {
        ::windows::runtime::Param::Owned(::std::convert::Into::<
            super::super::System::OleAutomation::IDispatch,
        >::into(::std::clone::Clone::clone(self)))
    }
}
#[repr(C)]
#[doc(hidden)]
pub struct IPrinterQueueView_abi(
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        iid: &::windows::runtime::GUID,
        interface: *mut ::windows::runtime::RawPtr,
    ) -> ::windows::runtime::HRESULT,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub unsafe extern "system" fn(this: ::windows::runtime::RawPtr) -> u32,
    pub  unsafe extern "system" fn(
        this: ::windows::runtime::RawPtr,
        pctinfo: *mut u32,
    ) -> ::windows::runtime::HRESULT,
    #[cfg(feature = "Win32_System_OleAutomation")]
    pub  unsafe extern "system" fn(
        this: ::windows