#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[link(name = "windows")]
extern "system" {}
#[repr(transparent)]
pub struct CausalityRelation(pub i32);
impl CausalityRelation {
    pub const AssignDelegate: Self = Self(0i32);
    pub const Join: Self = Self(1i32);
    pub const Choice: Self = Self(2i32);
    pub const Cancel: Self = Self(3i32);
    pub const Error: Self = Self(4i32);
}
impl ::core::marker::Copy for CausalityRelation {}
impl ::core::clone::Clone for CausalityRelation {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct CausalitySource(pub i32);
impl CausalitySource {
    pub const Application: Self = Self(0i32);
    pub const Library: Self = Self(1i32);
    pub const System: Self = Self(2i32);
}
impl ::core::marker::Copy for CausalitySource {}
impl ::core::clone::Clone for CausalitySource {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct CausalitySynchronousWork(pub i32);
impl CausalitySynchronousWork {
    pub const CompletionNotification: Self = Self(0i32);
    pub const ProgressNotification: Self = Self(1i32);
    pub const Execution: Self = Self(2i32);
}
impl ::core::marker::Copy for CausalitySynchronousWork {}
impl ::core::clone::Clone for CausalitySynchronousWork {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct CausalityTraceLevel(pub i32);
impl CausalityTraceLevel {
    pub const Required: Self = Self(0i32);
    pub const Important: Self = Self(1i32);
    pub const Verbose: Self = Self(2i32);
}
impl ::core::marker::Copy for CausalityTraceLevel {}
impl ::core::clone::Clone for CausalityTraceLevel {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ErrorDetails(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ErrorDetails {}
impl ::core::clone::Clone for ErrorDetails {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ErrorOptions(pub u32);
impl ErrorOptions {
    pub const None: Self = Self(0u32);
    pub const SuppressExceptions: Self = Self(1u32);
    pub const ForceExceptions: Self = Self(2u32);
    pub const UseSetErrorInfo: Self = Self(4u32);
    pub const SuppressSetErrorInfo: Self = Self(8u32);
}
impl ::core::marker::Copy for ErrorOptions {}
impl ::core::clone::Clone for ErrorOptions {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct FileLoggingSession(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for FileLoggingSession {}
impl ::core::clone::Clone for FileLoggingSession {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IAsyncCausalityTracerStatics(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IAsyncCausalityTracerStatics {}
impl ::core::clone::Clone for IAsyncCausalityTracerStatics {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IErrorDetails(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IErrorDetails {}
impl ::core::clone::Clone for IErrorDetails {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IErrorDetailsStatics(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IErrorDetailsStatics {}
impl ::core::clone::Clone for IErrorDetailsStatics {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IErrorReportingSettings(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IErrorReportingSettings {}
impl ::core::clone::Clone for IErrorReportingSettings {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IFileLoggingSession(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IFileLoggingSession {}
impl ::core::clone::Clone for IFileLoggingSession {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IFileLoggingSessionFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IFileLoggingSessionFactory {}
impl ::core::clone::Clone for IFileLoggingSessionFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILogFileGeneratedEventArgs(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILogFileGeneratedEventArgs {}
impl ::core::clone::Clone for ILogFileGeneratedEventArgs {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingActivity(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingActivity {}
impl ::core::clone::Clone for ILoggingActivity {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingActivity2(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingActivity2 {}
impl ::core::clone::Clone for ILoggingActivity2 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingActivityFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingActivityFactory {}
impl ::core::clone::Clone for ILoggingActivityFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingChannel(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingChannel {}
impl ::core::clone::Clone for ILoggingChannel {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingChannel2(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingChannel2 {}
impl ::core::clone::Clone for ILoggingChannel2 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingChannelFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingChannelFactory {}
impl ::core::clone::Clone for ILoggingChannelFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingChannelFactory2(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingChannelFactory2 {}
impl ::core::clone::Clone for ILoggingChannelFactory2 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingChannelOptions(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingChannelOptions {}
impl ::core::clone::Clone for ILoggingChannelOptions {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingChannelOptionsFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingChannelOptionsFactory {}
impl ::core::clone::Clone for ILoggingChannelOptionsFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingFields(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingFields {}
impl ::core::clone::Clone for ILoggingFields {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingOptions(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingOptions {}
impl ::core::clone::Clone for ILoggingOptions {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingOptionsFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingOptionsFactory {}
impl ::core::clone::Clone for ILoggingOptionsFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingSession(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingSession {}
impl ::core::clone::Clone for ILoggingSession {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingSessionFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingSessionFactory {}
impl ::core::clone::Clone for ILoggingSessionFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ILoggingTarget(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ILoggingTarget {}
impl ::core::clone::Clone for ILoggingTarget {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct ITracingStatusChangedEventArgs(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for ITracingStatusChangedEventArgs {}
impl ::core::clone::Clone for ITracingStatusChangedEventArgs {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LogFileGeneratedEventArgs(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for LogFileGeneratedEventArgs {}
impl ::core::clone::Clone for LogFileGeneratedEventArgs {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingActivity(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for LoggingActivity {}
impl ::core::clone::Clone for LoggingActivity {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingChannel(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for LoggingChannel {}
impl ::core::clone::Clone for LoggingChannel {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingChannelOptions(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for LoggingChannelOptions {}
impl ::core::clone::Clone for LoggingChannelOptions {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingFieldFormat(pub i32);
impl LoggingFieldFormat {
    pub const Default: Self = Self(0i32);
    pub const Hidden: Self = Self(1i32);
    pub const String: Self = Self(2i32);
    pub const Boolean: Self = Self(3i32);
    pub const Hexadecimal: Self = Self(4i32);
    pub const ProcessId: Self = Self(5i32);
    pub const ThreadId: Self = Self(6i32);
    pub const Port: Self = Self(7i32);
    pub const Ipv4Address: Self = Self(8i32);
    pub const Ipv6Address: Self = Self(9i32);
    pub const SocketAddress: Self = Self(10i32);
    pub const Xml: Self = Self(11i32);
    pub const Json: Self = Self(12i32);
    pub const Win32Error: Self = Self(13i32);
    pub const NTStatus: Self = Self(14i32);
    pub const HResult: Self = Self(15i32);
    pub const FileTime: Self = Self(16i32);
    pub const Signed: Self = Self(17i32);
    pub const Unsigned: Self = Self(18i32);
}
impl ::core::marker::Copy for LoggingFieldFormat {}
impl ::core::clone::Clone for LoggingFieldFormat {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingFields(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for LoggingFields {}
impl ::core::clone::Clone for LoggingFields {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingLevel(pub i32);
impl LoggingLevel {
    pub const Verbose: Self = Self(0i32);
    pub const Information: Self = Self(1i32);
    pub const Warning: Self = Self(2i32);
    pub const Error: Self = Self(3i32);
    pub const Critical: Self = Self(4i32);
}
impl ::core::marker::Copy for LoggingLevel {}
impl ::core::clone::Clone for LoggingLevel {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingOpcode(pub i32);
impl LoggingOpcode {
    pub const Info: Self = Self(0i32);
    pub const Start: Self = Self(1i32);
    pub const Stop: Self = Self(2i32);
    pub const Reply: Self = Self(6i32);
    pub const Resume: Self = Self(7i32);
    pub const Suspend: Self = Self(8i32);
    pub const Send: Self = Self(9i32);
}
impl ::core::marker::Copy for LoggingOpcode {}
impl ::core::clone::Clone for LoggingOpcode {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingOptions(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for LoggingOptions {}
impl ::core::clone::Clone for LoggingOptions {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct LoggingSession(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for LoggingSession {}
impl ::core::clone::Clone for LoggingSession {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct RuntimeBrokerErrorSettings(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for RuntimeBrokerErrorSettings {}
impl ::core::clone::Clone for RuntimeBrokerErrorSettings {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct TracingStatusChangedEventArgs(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for TracingStatusChangedEventArgs {}
impl ::core::clone::Clone for TracingStatusChangedEventArgs {
    fn clone(&self) -> Self {
        *self
    }
}
