#![allow(non_snake_case, non_camel_case_types, non_upper_case_globals, clashing_extern_declarations, clippy::all)]
#[cfg(feature = "Devices_Gpio_Provider")]
pub mod Provider;
#[link(name = "windows")]
extern "system" {}
#[repr(C)]
#[cfg(feature = "Foundation")]
pub struct GpioChangeCount {
    pub Count: u64,
    pub RelativeTime: super::super::Foundation::TimeSpan,
}
#[cfg(feature = "Foundation")]
impl ::core::marker::Copy for GpioChangeCount {}
#[cfg(feature = "Foundation")]
impl ::core::clone::Clone for GpioChangeCount {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioChangeCounter(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for GpioChangeCounter {}
impl ::core::clone::Clone for GpioChangeCounter {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioChangePolarity(pub i32);
impl GpioChangePolarity {
    pub const Falling: Self = Self(0i32);
    pub const Rising: Self = Self(1i32);
    pub const Both: Self = Self(2i32);
}
impl ::core::marker::Copy for GpioChangePolarity {}
impl ::core::clone::Clone for GpioChangePolarity {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioChangeReader(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for GpioChangeReader {}
impl ::core::clone::Clone for GpioChangeReader {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(C)]
#[cfg(feature = "Foundation")]
pub struct GpioChangeRecord {
    pub RelativeTime: super::super::Foundation::TimeSpan,
    pub Edge: GpioPinEdge,
}
#[cfg(feature = "Foundation")]
impl ::core::marker::Copy for GpioChangeRecord {}
#[cfg(feature = "Foundation")]
impl ::core::clone::Clone for GpioChangeRecord {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioController(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for GpioController {}
impl ::core::clone::Clone for GpioController {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioOpenStatus(pub i32);
impl GpioOpenStatus {
    pub const PinOpened: Self = Self(0i32);
    pub const PinUnavailable: Self = Self(1i32);
    pub const SharingViolation: Self = Self(2i32);
    pub const MuxingConflict: Self = Self(3i32);
    pub const UnknownError: Self = Self(4i32);
}
impl ::core::marker::Copy for GpioOpenStatus {}
impl ::core::clone::Clone for GpioOpenStatus {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioPin(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for GpioPin {}
impl ::core::clone::Clone for GpioPin {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioPinDriveMode(pub i32);
impl GpioPinDriveMode {
    pub const Input: Self = Self(0i32);
    pub const Output: Self = Self(1i32);
    pub const InputPullUp: Self = Self(2i32);
    pub const InputPullDown: Self = Self(3i32);
    pub const OutputOpenDrain: Self = Self(4i32);
    pub const OutputOpenDrainPullUp: Self = Self(5i32);
    pub const OutputOpenSource: Self = Self(6i32);
    pub const OutputOpenSourcePullDown: Self = Self(7i32);
}
impl ::core::marker::Copy for GpioPinDriveMode {}
impl ::core::clone::Clone for GpioPinDriveMode {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioPinEdge(pub i32);
impl GpioPinEdge {
    pub const FallingEdge: Self = Self(0i32);
    pub const RisingEdge: Self = Self(1i32);
}
impl ::core::marker::Copy for GpioPinEdge {}
impl ::core::clone::Clone for GpioPinEdge {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioPinValue(pub i32);
impl GpioPinValue {
    pub const Low: Self = Self(0i32);
    pub const High: Self = Self(1i32);
}
impl ::core::marker::Copy for GpioPinValue {}
impl ::core::clone::Clone for GpioPinValue {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioPinValueChangedEventArgs(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for GpioPinValueChangedEventArgs {}
impl ::core::clone::Clone for GpioPinValueChangedEventArgs {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct GpioSharingMode(pub i32);
impl GpioSharingMode {
    pub const Exclusive: Self = Self(0i32);
    pub const SharedReadOnly: Self = Self(1i32);
}
impl ::core::marker::Copy for GpioSharingMode {}
impl ::core::clone::Clone for GpioSharingMode {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioChangeCounter(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioChangeCounter {}
impl ::core::clone::Clone for IGpioChangeCounter {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioChangeCounterFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioChangeCounterFactory {}
impl ::core::clone::Clone for IGpioChangeCounterFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioChangeReader(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioChangeReader {}
impl ::core::clone::Clone for IGpioChangeReader {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioChangeReaderFactory(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioChangeReaderFactory {}
impl ::core::clone::Clone for IGpioChangeReaderFactory {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioController(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioController {}
impl ::core::clone::Clone for IGpioController {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioControllerStatics(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioControllerStatics {}
impl ::core::clone::Clone for IGpioControllerStatics {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioControllerStatics2(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioControllerStatics2 {}
impl ::core::clone::Clone for IGpioControllerStatics2 {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioPin(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioPin {}
impl ::core::clone::Clone for IGpioPin {
    fn clone(&self) -> Self {
        *self
    }
}
#[repr(transparent)]
pub struct IGpioPinValueChangedEventArgs(pub *mut ::core::ffi::c_void);
impl ::core::marker::Copy for IGpioPinValueChangedEventArgs {}
impl ::core::clone::Clone for IGpioPinValueChangedEventArgs {
    fn clone(&self) -> Self {
        *self
    }
}
