use failure::{Fail, Error as FError};
use std::{result::Result as StdResult};
 
pub type Result<T> = StdResult<T, FError>;
 
#[derive(Debug, Fail)]
pub enum Error {
    #[fail(display = "Couldn't read memory at {:#X}: error {:#X}", _0, _1)]
    MemoryRead(u64, u32),

    #[fail(display = "Couldn't write memory at {:#X}: error {:#X}", _0, _1)]
    MemoryWrite(u64, u32),

    #[fail(display = "Couldn't read memory from process at {:#X}: error {:#X}", _0, _1)]
    ProcessMemoryRead(u64, u32),

    #[fail(display = "Couldn't write memory from process at {:#X}: error {:#X}", _0, _1)]
    ProcessMemoryWrite(u64, u32),

    #[fail(display = "Couldn't read memory at {:#X}: error {:#X} (32 bit)", _0, _1)]
    MemoryRead32(u32, u32),

    #[fail(display = "Couldn't write memory at {:#X}: error {:#X} (32 bit)", _0, _1)]
    MemoryWrite32(u32, u32),

    #[fail(display = "Couldn't read memory from process at {:#X}: error {:#X} (32 bit)", _0, _1)]
    ProcessMemoryRead32(u32, u32),

    #[fail(display = "Couldn't write memory from process at {:#X}: error {:#X} (32 bit)", _0, _1)]
    ProcessMemoryWrite32(u32, u32),

    #[fail(display = "Couldn't get the pid of an executeable \"{}\": error {}", name, error)]
    GetPid {
        name: String,
        error: u32,
    },

    #[fail(display = "Couldn't get the module \"{}\": error {}", module, error)]
    GetModuleBase {
        module: String,
        error: u32,
    },
}