extern crate bindgen;

use std::env;
use std::path::PathBuf;

fn main() {
    // Tell cargo to tell rustc to link the system libwim
    // shared library.
    println!("cargo:rustc-link-lib=wim");

    // The bindgen::Builder is the main entry point
    // to bindgen, and lets you build up options for
    // the resulting bindings.
    let bindings = bindgen::Builder::default()
        // The input header we would like to generate
        // bindings for.
        .header("wrapper.h")
        // whitelist functions
        // list of functions that should be included
        .allowlist_function("wimlib_add_empty_image")
        .allowlist_function("wimlib_add_image")
        .allowlist_function("wimlib_add_image_multisource")
        .allowlist_function("wimlib_add_tree")
        .allowlist_function("wimlib_compress")
        .allowlist_function("wimlib_create_compressor")
        .allowlist_function("wimlib_create_decompressor")
        .allowlist_function("wimlib_create_new_wim")
        .allowlist_function("wimlib_decompress")
        .allowlist_function("wimlib_delete_image")
        .allowlist_function("wimlib_delete_path")
        .allowlist_function("wimlib_export_image")
        .allowlist_function("wimlib_extract_image")
        .allowlist_function("wimlib_extract_image_from_pipe")
        .allowlist_function("wimlib_extract_image_from_pipe_with_progress")
        .allowlist_function("wimlib_extract_pathlist")
        .allowlist_function("wimlib_extract_paths")
        .allowlist_function("wimlib_extract_xml_data")
        .allowlist_function("wimlib_free")
        .allowlist_function("wimlib_free_compressor")
        .allowlist_function("wimlib_free_decompressor")
        .allowlist_function("wimlib_get_compression_type_string")
        .allowlist_function("wimlib_get_compressor_needed_memory")
        .allowlist_function("wimlib_get_error_string")
        .allowlist_function("wimlib_get_image_description")
        .allowlist_function("wimlib_get_image_name")
        .allowlist_function("wimlib_get_image_property")
        .allowlist_function("wimlib_get_version")
        .allowlist_function("wimlib_get_version_string")
        .allowlist_function("wimlib_get_wim_info")
        .allowlist_function("wimlib_get_xml_data")
        .allowlist_function("wimlib_global_cleanup")
        .allowlist_function("wimlib_global_init")
        .allowlist_function("wimlib_image_name_in_use")
        .allowlist_function("wimlib_iterate_dir_tree")
        .allowlist_function("wimlib_iterate_lookup_table")
        .allowlist_function("wimlib_join")
        .allowlist_function("wimlib_join_with_progress")
        .allowlist_function("wimlib_mount_image")
        .allowlist_function("wimlib_open_wim")
        .allowlist_function("wimlib_open_wim_with_progress")
        .allowlist_function("wimlib_overwrite")
        .allowlist_function("wimlib_print_available_images")
        .allowlist_function("wimlib_print_header")
        .allowlist_function("wimlib_reference_resource_files")
        .allowlist_function("wimlib_reference_resources")
        .allowlist_function("wimlib_reference_template_image")
        .allowlist_function("wimlib_register_progress_function")
        .allowlist_function("wimlib_rename_path")
        .allowlist_function("wimlib_resolve_image")
        .allowlist_function("wimlib_set_default_compression_level")
        .allowlist_function("wimlib_set_error_file")
        .allowlist_function("wimlib_set_error_file_by_name")
        .allowlist_function("wimlib_set_image_descripton")
        .allowlist_function("wimlib_set_image_flags")
        .allowlist_function("wimlib_set_image_name")
        .allowlist_function("wimlib_set_image_property")
        .allowlist_function("wimlib_set_memory_allocator")
        .allowlist_function("wimlib_set_output_chunk_size")
        .allowlist_function("wimlib_set_output_compression_type")
        .allowlist_function("wimlib_set_output_pack_chunk_size")
        .allowlist_function("wimlib_set_output_pack_compression_type")
        .allowlist_function("wimlib_set_print_errors")
        .allowlist_function("wimlib_set_wim_info")
        .allowlist_function("wimlib_split")
        .allowlist_function("wimlib_unmount_image")
        .allowlist_function("wimlib_unmount_image_with_progress")
        .allowlist_function("wimlib_update_image")
        .allowlist_function("wimlib_verify_wim")
        .allowlist_function("wimlib_write")
        .allowlist_function("wimlib_write_to_fd")
        // whitelist define'd consts
        .allowlist_var("WIMLIB_CHANGE_READONLY_FLAG")
        .allowlist_var("WIMLIB_CHANGE_GUID")
        .allowlist_var("WIMLIB_CHANGE_BOOT_INDEX")
        .allowlist_var("WIMLIB_CHANGE_RPFIX_FLAG")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_READONLY")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_HIDDEN")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_SYSTEM")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_DIRECTORY")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_ARCHIVE")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_DEVICE")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_NORMAL")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_TEMPORARY")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_SPARSE_FILE")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_REPARSE_POINT")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_COMPRESSED")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_OFFLINE")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_NOT_CONTENT_INDEXED")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_ENCRYPTED")
        .allowlist_var("WIMLIB_FILE_ATTRIBUTE_VIRTUAL")
        .allowlist_var("WIMLIB_REPARSE_TAG_RESERVED_ZERO")
        .allowlist_var("WIMLIB_REPARSE_TAG_RESERVED_ONE")
        .allowlist_var("WIMLIB_REPARSE_TAG_MOUNT_POINT")
        .allowlist_var("WIMLIB_REPARSE_TAG_HSM")
        .allowlist_var("WIMLIB_REPARSE_TAG_HSM2")
        .allowlist_var("WIMLIB_REPARSE_TAG_DRIVER_EXTENDER")
        .allowlist_var("WIMLIB_REPARSE_TAG_SIS")
        .allowlist_var("WIMLIB_REPARSE_TAG_DFS")
        .allowlist_var("WIMLIB_REPARSE_TAG_DFSR")
        .allowlist_var("WIMLIB_REPARSE_TAG_FILTER_MANAGER")
        .allowlist_var("WIMLIB_REPARSE_TAG_WOF")
        .allowlist_var("WIMLIB_REPARSE_TAG_SYMLINK")
        .allowlist_var("WIMLIB_ITERATE_DIR_TREE_FLAG_RECURSIVE")
        .allowlist_var("WIMLIB_ITERATE_DIR_TREE_FLAG_CHILDREN")
        .allowlist_var("WIMLIB_ITERATE_DIR_TREE_FLAG_RESOURCES_NEEDED")
        .allowlist_var("WIMLIB_ADD_FLAG_NTFS")
        .allowlist_var("WIMLIB_ADD_FLAG_DEREFERENCE")
        .allowlist_var("WIMLIB_ADD_FLAG_VERBOSE")
        .allowlist_var("WIMLIB_ADD_FLAG_BOOT")
        .allowlist_var("WIMLIB_ADD_FLAG_UNIX_DATA")
        .allowlist_var("WIMLIB_ADD_FLAG_NO_ACLS")
        .allowlist_var("WIMLIB_ADD_FLAG_STRICT_ACLS")
        .allowlist_var("WIMLIB_ADD_FLAG_EXCLUDE_VERBOSE")
        .allowlist_var("WIMLIB_ADD_FLAG_RPFIX")
        .allowlist_var("WIMLIB_ADD_FLAG_NORPFIX")
        .allowlist_var("WIMLIB_ADD_FLAG_NO_UNSUPPORTED_EXCLUDE")
        .allowlist_var("WIMLIB_ADD_FLAG_WINCONFIG")
        .allowlist_var("WIMLIB_ADD_FLAG_WIMBOOT")
        .allowlist_var("WIMLIB_ADD_FLAG_NO_REPLACE")
        .allowlist_var("WIMLIB_ADD_FLAG_TEST_FILE_EXCLUSION")
        .allowlist_var("WIMLIB_ADD_FLAG_SNAPSHOT")
        .allowlist_var("WIMLIB_ADD_FLAG_FILE_PATHS_UNNEEDED")
        .allowlist_var("WIMLIB_DELETE_FLAG_FORCE")
        .allowlist_var("WIMLIB_DELETE_FLAG_RECURSIVE")
        .allowlist_var("WIMLIB_EXPORT_FLAG_BOOT")
        .allowlist_var("WIMLIB_EXPORT_FLAG_NO_NAMES")
        .allowlist_var("WIMLIB_EXPORT_FLAG_NO_DESCRIPTIONS")
        .allowlist_var("WIMLIB_EXPORT_FLAG_GIFT")
        .allowlist_var("WIMLIB_EXPORT_FLAG_WIMBOOT")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_NTFS")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_UNIX_DATA")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_NO_ACLS")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_STRICT_ACLS")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_RPFIX")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_NORPFIX")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_TO_STDOUT")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_REPLACE_INVALID_FILENAMES")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_ALL_CASE_CONFLICTS")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_STRICT_TIMESTAMPS")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_STRICT_SHORT_NAMES")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_STRICT_SYMLINKS")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_GLOB_PATHS")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_STRICT_GLOB")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_NO_ATTRIBUTES")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_NO_PRESERVE_DIR_STRUCTURE")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_WIMBOOT")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_COMPACT_XPRESS4K")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_COMPACT_XPRESS8K")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_COMPACT_XPRESS16K")
        .allowlist_var("WIMLIB_EXTRACT_FLAG_COMPACT_LZX")
        .allowlist_var("WIMLIB_MOUNT_FLAG_READWRITE")
        .allowlist_var("WIMLIB_MOUNT_FLAG_DEBUG")
        .allowlist_var("WIMLIB_MOUNT_FLAG_STREAM_INTERFACE_NONE")
        .allowlist_var("WIMLIB_MOUNT_FLAG_STREAM_INTERFACE_XATTR")
        .allowlist_var("WIMLIB_MOUNT_FLAG_STREAM_INTERFACE_WINDOWS")
        .allowlist_var("WIMLIB_MOUNT_FLAG_UNIX_DATA")
        .allowlist_var("WIMLIB_MOUNT_FLAG_ALLOW_OTHER")
        .allowlist_var("WIMLIB_OPEN_FLAG_CHECK_INTEGRITY")
        .allowlist_var("WIMLIB_OPEN_FLAG_ERROR_IF_SPLIT")
        .allowlist_var("WIMLIB_OPEN_FLAG_WRITE_ACCESS")
        .allowlist_var("WIMLIB_UNMOUNT_FLAG_CHECK_INTEGRITY")
        .allowlist_var("WIMLIB_UNMOUNT_FLAG_COMMIT")
        .allowlist_var("WIMLIB_UNMOUNT_FLAG_REBUILD")
        .allowlist_var("WIMLIB_UNMOUNT_FLAG_RECOMPRESS")
        .allowlist_var("WIMLIB_UNMOUNT_FLAG_FORCE")
        .allowlist_var("WIMLIB_UNMOUNT_FLAG_NEW_IMAGE")
        .allowlist_var("WIMLIB_UPDATE_FLAG_SEND_PROGRESS")
        .allowlist_var("WIMLIB_WRITE_FLAG_CHECK_INTEGRITY")
        .allowlist_var("WIMLIB_WRITE_FLAG_NO_CHECK_INTEGRITY")
        .allowlist_var("WIMLIB_WRITE_FLAG_PIPABLE")
        .allowlist_var("WIMLIB_WRITE_FLAG_NOT_PIPABLE")
        .allowlist_var("WIMLIB_WRITE_FLAG_RECOMPRESS")
        .allowlist_var("WIMLIB_WRITE_FLAG_FSYNC")
        .allowlist_var("WIMLIB_WRITE_FLAG_REBUILD")
        .allowlist_var("WIMLIB_WRITE_FLAG_SOFT_DELETE")
        .allowlist_var("WIMLIB_WRITE_FLAG_IGNORE_READONLY_FLAG")
        .allowlist_var("WIMLIB_WRITE_FLAG_SKIP_EXTERNAL_WIMS")
        .allowlist_var("WIMLIB_WRITE_FLAG_STREAMS_OK")
        .allowlist_var("WIMLIB_WRITE_FLAG_RETAIN_GUID")
        .allowlist_var("WIMLIB_WRITE_FLAG_SOLID")
        .allowlist_var("WIMLIB_WRITE_FLAG_SEND_DONE_WITH_FILE_MESSAGES")
        .allowlist_var("WIMLIB_WRITE_FLAG_NO_SOLID_SORT")
        .allowlist_var("WIMLIB_WRITE_FLAG_UNSAFE_COMPACT")
        .allowlist_var("WIMLIB_INIT_FLAG_ASSUME_UTF8")
        .allowlist_var("WIMLIB_INIT_FLAG_DONT_ACQUIRE_PRIVILEGES")
        .allowlist_var("WIMLIB_INIT_FLAG_STRICT_CAPTURE_PRIVILEGES")
        .allowlist_var("WIMLIB_INIT_FLAG_STRICT_APPLY_PRIVILEGES")
        .allowlist_var("WIMLIB_INIT_FLAG_DEFAULT_CASE_SENSITIVE")
        .allowlist_var("WIMLIB_INIT_FLAG_DEFAULT_CASE_INSENSITIVE")
        .allowlist_var("WIMLIB_REF_FLAG_GLOB_ENABLE")
        .allowlist_var("WIMLIB_REF_FLAG_GLOB_ERR_ON_NOMATCH")
        // nocopy for handles
        .no_copy("WIMStruct")
        // enum translation settings
        .rustified_enum("wimlib_compression_type")
        .rustified_enum("wimlib_progress_msg")
        .rustified_enum("wimlib_progress_status")
        .rustified_enum("wimlib_update_op")
        .rustified_enum("wimlib_error_code")
        // Finish the builder and generate the bindings.
        .generate()
        // Unwrap the Result and panic on failure.
        .expect("Unable to generate bindings");

    // Write the bindings to the $OUT_DIR/bindings.rs file.
    let out_path = PathBuf::from(env::var("OUT_DIR").unwrap());
    bindings
        .write_to_file(out_path.join("bindings.rs"))
        .expect("Couldn't write bindings!");
}
