[![creats.io shield](https://img.shields.io/crates/v/wimlib-z.svg)](https://crates.io/crates/wimlib-z)
[![GPLv3 license](https://img.shields.io/crates/l/wimlib-z.svg)](https://www.gnu.org/licenses/gpl-3.0.en.html)

# Wimlib Rust bindings

These are Rust bindings for Wimlib, generated by bindgen:

https://rust-lang.github.io/rust-bindgen/

Please note that these are lowlevel bindings to the C lib. I am still working on a more Rust like abstraction for Wimlib that will use this crate for accessing the dynamic library.

## Building

Building has been tested on Arch Linux x86_64, using Rust 1.34, and Wimlib 1.13.0. Versions a little older or newer will probably just work.

The crate has no settings for building, as it doesn't actually build Wimlib. It simply uses the Wimlib provided by your OS.

If your OS's distribution has separate dev packages for header files, please make sure to have `wimlib-dev` (or equivalent) installed.

To build, just run:
`cargo build`

To run the checks, run:
`cargo run -- --test-threads=1`

Running them sequentially is needed because the tests share a state.

### macOS

Not tested yet, but should work.

### Windows

It should work on Windows, but I'm not sure how to make Windows find the dll and C header.

If you find out, please let me know.

## License

This library is licensed under [GPLv3](https://www.gnu.org/licenses/gpl-3.0.en.html) or later and optionally under [LGPLv3](https://www.gnu.org/licenses/lgpl-3.0.en.html) or later. It primarily links to the following resource:

* [Wimlib](https://wimlib.net/)
  * licensed under GPLv3 or later and optionally under LGPLv3 or later:  
  https://wimlib.net/git/?p=wimlib;f=COPYING;hb=HEAD

And uses the following special resource at compile time:

* [cat.jpg](cat.jpg) by [Orangeaurochs](https://www.flickr.com/photos/orangeaurochs/)
  * licensed under CC 2.0