/*
 * Copyright 2021 XXIV
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
//! WikiFeet (The collaborative celebrity feet website) crawler
mod wikifeet;
mod error;
mod random_feet;
mod feet_of_the_day;
mod feet_of_the_week;
mod feet_of_the_year;
mod wikifeet_stats;
mod wikifeet_country_stats;
pub use wikifeet::WikiFeet;
pub use error::WikiFeetError;
pub use random_feet::RandomFeet;
pub use feet_of_the_day::FeetOfTheDay;
pub use feet_of_the_week::FeetOfTheWeek;
pub use feet_of_the_year::FeetOfTheYear;
pub use wikifeet_stats::WikiFeetStats;
pub use wikifeet_country_stats::WikiFeetCountryStats;