/// A struct containing the metadata of a search. All values are optional.
/// This struct is generated by the SearchBuilder and should not be created directly. Instead, use
/// the one the SearchBuilder creates for you
#[derive(Clone)]
pub struct SearchInfo {
    /// The total number of search results. This value is optional
    total_hits: Option<i32>,
    /// A suggestion of what wikipedia thinks you meant by your search query. These could be
    /// corrections of a spelling mistake. This value is optional
    suggestion: Option<String>,
    /// When wikipedia rewrites your query, this will be the rewritten query. This value is
    /// optional
    rewritten_query: Option<String>,
}

/// A helper macro for generating getter functions in the SearchInfo struct
macro_rules! build_getter {
    ($(#[$meta:meta])* $value: ident, $return_type: ty) => {
        $(#[$meta])*
        pub fn $value(&self) -> Option<$return_type> {
            match &self.$value {
                Some(ref value) => Some(value),
                None => None,
            }
        }
    };
}

impl SearchInfo {
    /// Creates a new struct with the given metadata.
    /// This function should not be used directly
    pub fn new(
        total_hits: Option<i32>,
        suggestion: Option<String>,
        rewritten_query: Option<String>,
    ) -> Self {
        SearchInfo {
            total_hits,
            suggestion,
            rewritten_query,
        }
    }

    build_getter!(
        /// The total number of search results. This value is optional.
        total_hits,
        &i32
    );
    build_getter!(
        /// A suggestion of what wikipeida thinks you meant by you search query. These could be
        /// corrections of a spelling mistake. This value is optional.
        suggestion,
        &str
    );
    build_getter!(
        /// When wikipedia rewrites your query, this will be the rewritten query. This value is
        /// optional
        rewritten_query,
        &str
    );
}
