# `wigner-symbols`

[![Documentation](https://docs.rs/wigner-symbols/badge.svg)](https://docs.rs/wigner-symbols)
[![Crates.io](https://img.shields.io/crates/v/wigner-symbols.svg)](https://crates.io/crates/wigner-symbols)
[![Travis CI Build Status](https://travis-ci.org/Rufflewind/wigner-symbols-rs.svg?branch=master)](https://travis-ci.org/Rufflewind/wigner-symbols-rs)

Calculates [Clebsch–Gordan coefficients](https://en.wikipedia.org/wiki/Clebsch%E2%80%93Gordan_coefficients) and Wigner [3-jm](https://en.wikipedia.org/wiki/3-j_symbol), [6-j](https://en.wikipedia.org/wiki/6-j_symbol), and [9-j](https://en.wikipedia.org/wiki/9-j_symbol), and 12-j symbols exactly.  They are often used for coupling and recoupling angular momenta in quantum mechanics.  Based on the [Haskell version of `wigner-symbols`](https://github.com/Rufflewind/wigner-symbols).

The definition of 12-j symbols is based on the equation (19.3) of the following textbook.

* A. P. Yutsis, I. B. Levinson, and V. V. Vanagas, *Mathematical Apparatus of the Theory of Angular Momentum* (Israel Program for Scientific Translations, Jerusalem, 1962).
