/*
 * Decompiled with CFR 0.152.
 */
package concat;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import jbuildgraph.core.Build;
import jbuildgraph.util.Trie;
import jbuildstore.core.Content;
import jbuildstore.core.Key;
import jbuildstore.util.TextFile;
import wy.lang.Plugin;

public class Activator
implements Plugin.Activator {
    public Build.Platform<String> PLATFORM = new Build.Platform<String>(){

        public Task initialise(String context) {
            System.out.println("Initialise concat platform");
            return new Task();
        }
    };

    public Plugin start(Plugin.Context context) {
        context.logTimedMessage("[Concat] starting!", 0L, 0L);
        context.register(Content.Type.class, (Object)TextFile.ContentTypeASCII);
        context.register(Build.Platform.class, this.PLATFORM);
        return new Plugin(){};
    }

    public void stop(Plugin module, Plugin.Context context) {
        context.logTimedMessage("[Concat] finishing", 0L, 0L);
    }

    public static class Task
    implements Build.Task {
        private static final Key<Trie, TextFile> TARGET_ID = new Key.Pair((Object)Trie.fromString((String)"output.txt"), TextFile.ContentTypeASCII);
        private static final Trie SRC_INCLUDES = Trie.fromString((String)"src/*");

        public boolean apply(Content.Store<Trie> repository) {
            try {
                List files = repository.getAll(k -> k.contentType() == TextFile.ContentTypeASCII && SRC_INCLUDES.matches((Trie)k.id()));
                StringBuffer result = new StringBuffer();
                for (TextFile tf : files) {
                    String s = new String(tf.getBytes(StandardCharsets.US_ASCII));
                    result.append(s);
                }
                repository.put(TARGET_ID, (Content)new TextFile(TextFile.ContentTypeASCII, result.toString()));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
    }
}

