/*
 * Decompiled with CFR 0.152.
 */
package basic;

import basic.BasicFile;
import basic.SourceFile;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jbuildgraph.core.Build;
import jbuildgraph.util.Trie;
import jbuildstore.core.Content;
import jbuildstore.core.Key;
import jsynheap.lang.Syntactic;
import jsynheap.util.AbstractCompilationUnit;

public class CompileTask
implements Build.Task {
    public boolean apply(Content.Store<Trie> store) {
        try {
            Trie filename = Trie.fromString((String)"input");
            Key.Pair src_k = new Key.Pair((Object)filename, SourceFile.ContentType);
            Key.Pair bin_k = new Key.Pair((Object)filename, BasicFile.ContentType);
            SourceFile source = (SourceFile)store.get((Key)src_k);
            BasicFile bf = new BasicFile();
            ArrayList<BasicFile.Stmt> stmts = new ArrayList<BasicFile.Stmt>();
            for (String line : CompileTask.getLines(source)) {
                String[] splits = line.split(" ");
                if (splits.length <= 0) continue;
                int lineno = Integer.parseInt(splits[0]);
                BasicFile.Stmt s = this.parseStatement(lineno, splits);
                stmts.add((BasicFile.Stmt)bf.allocate(s));
            }
            bf.setRootItem((Syntactic.Item)new AbstractCompilationUnit.Tuple(stmts));
            store.put((Key)bin_k, (Content)bf);
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private BasicFile.Stmt parseStatement(int lineno, String[] splits) {
        String cmd;
        switch (cmd = splits[1]) {
            case "PRINT": {
                return this.parsePrintStatement(lineno, splits);
            }
            case "GOTO": {
                return this.parseGotoStatement(lineno, splits);
            }
        }
        throw new IllegalArgumentException("Unknown statement encountered");
    }

    private BasicFile.Stmt parseGotoStatement(int lineno, String[] splits) {
        return new BasicFile.Stmt.Goto(lineno, Integer.parseInt(splits[2]));
    }

    private BasicFile.Stmt parsePrintStatement(int lineno, String[] splits) {
        if (splits.length != 3) {
            throw new IllegalArgumentException("invalid print statement");
        }
        BasicFile.Expr expr = this.parseExpression(splits[2]);
        return new BasicFile.Stmt.Print(lineno, expr);
    }

    private BasicFile.Expr parseExpression(String str) {
        return new BasicFile.Expr.Constant(str);
    }

    public static List<String> getLines(SourceFile source) {
        String[] lines = new String(source.getBytes(StandardCharsets.US_ASCII)).split("\n");
        return Arrays.asList(lines);
    }
}

