use clap::Parser;
use nothing::Probably;
use std::env;
use std::path::{Path, PathBuf};

/// find binary for command
///
/// <https://stackoverflow.com/questions/37498864/finding-executable-in-path-with-rust>
pub fn locate<P>(exe_name: P) -> Probably<PathBuf>
where
    P: AsRef<Path>,
{
    env::var_os("PATH")
        .and_then(|paths| {
            env::split_paths(&paths)
                .filter_map(|dir| {
                    let full_path = dir.join(&exe_name);
                    if full_path.is_file() {
                        Some(full_path)
                    } else {
                        None
                    }
                })
                .next()
        })
        .into()
}

/// clap::Parser struct
#[derive(Parser)]
pub struct Args {
    /// command name
    pub command: String,
}

impl Args {
    /// find command path
    pub fn locate(self) -> Probably<PathBuf> {
        locate(self.command)
    }
}
