# webview2-com
This crate implements Rust bindings for the [WebView2](https://aka.ms/webview2) COM APIs, as well as several important Win32 APIs necessary to build a standalone GUI application hosting WebView2. The bindings are generated by the [Windows](https://github.com/microsoft/windows-rs) crate in [webview2-com-sys](https://crates.io/crates/webview2-com-sys).

## Getting Started
Include a reference to `webview2-com` in your `Cargo.toml`:
```toml
[dependencies]
webview2-com = "0.2.0"
```

See the [docs](https://docs.rs/webview2-com/) or take a look at the [sample.rs](https://github.com/wravery/webview2-rs/blob/main/crates/webview2-com/examples/sample.rs) example (adapted from [microsoft/windows-samples-rs](https://github.com/microsoft/windows-samples-rs/tree/master/webview2_win32)) for more details.

## Safety
Most of the bindings are re-exported transparently from `webview2-com-sys`, and they are still marked `unsafe`. Unlike typical idiomatic Rust crates wrapped around a `-sys` crate, the emphasis of this crate is on writing as little manual wrapper code as possible. This way, `webview2-com` can project 100% of the WebView2 COM API, but the downside is you will need to wrap most uses in an `unsafe` block or function.

## Convenience Types
Most of the code added by this crate consists of convenience types to implement COM interfaces that are required for callbacks and setting options:
- [callback.rs](https://github.com/wravery/webview2-rs/blob/main/crates/webview2-com/src/callback.rs): Implements all of the event sink handler interfaces used by WebView2.
- [options.rs](https://github.com/wravery/webview2-rs/blob/main/crates/webview2-com/src/options.rs): Implements the `ICoreWebView2EnvironmentOptions` interface which is passed to `CreateCoreWebView2EnvironmentWithOptions` if you want to customize the environment.

There are also some utilities for dealing with `PWSTR` in/out-params that may be useful:
- [pwstr.rs](https://github.com/wravery/webview2-rs/blob/main/crates/webview2-com/src/pwstr.rs): `string_from_pwstr`, `take_pwstr`, and `pwstr_from_str`.

## Windows Metadata
The Windows crate requires a Windows Metadata (`winmd`) file describing the API. The one used in this crate was generated with the [webview2-win32md](https://github.com/wravery/webview2-win32md) project. This crate needs it to use the `#[implement]` macro from the Windows crate. 
