#![allow(
    non_snake_case,
    non_camel_case_types,
    non_upper_case_globals,
    clashing_extern_declarations,
    clippy::all
)]
pub type COREWEBVIEW2_BOUNDS_MODE = i32;
pub const COREWEBVIEW2_BOUNDS_MODE_USE_RAW_PIXELS: COREWEBVIEW2_BOUNDS_MODE = 0i32;
pub const COREWEBVIEW2_BOUNDS_MODE_USE_RASTERIZATION_SCALE: COREWEBVIEW2_BOUNDS_MODE = 1i32;
pub type COREWEBVIEW2_BROWSER_PROCESS_EXIT_KIND = i32;
pub const COREWEBVIEW2_BROWSER_PROCESS_EXIT_KIND_NORMAL: COREWEBVIEW2_BROWSER_PROCESS_EXIT_KIND =
    0i32;
pub const COREWEBVIEW2_BROWSER_PROCESS_EXIT_KIND_FAILED: COREWEBVIEW2_BROWSER_PROCESS_EXIT_KIND =
    1i32;
pub type COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT = i32;
pub const COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT_PNG: COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT =
    0i32;
pub const COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT_JPEG:
    COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT = 1i32;
pub type COREWEBVIEW2_CLIENT_CERTIFICATE_KIND = i32;
pub const COREWEBVIEW2_CLIENT_CERTIFICATE_KIND_SMART_CARD: COREWEBVIEW2_CLIENT_CERTIFICATE_KIND =
    0i32;
pub const COREWEBVIEW2_CLIENT_CERTIFICATE_KIND_PIN: COREWEBVIEW2_CLIENT_CERTIFICATE_KIND = 1i32;
pub const COREWEBVIEW2_CLIENT_CERTIFICATE_KIND_OTHER: COREWEBVIEW2_CLIENT_CERTIFICATE_KIND = 2i32;
#[repr(C)]
pub struct COREWEBVIEW2_COLOR {
    pub A: u8,
    pub R: u8,
    pub G: u8,
    pub B: u8,
}
impl ::core::marker::Copy for COREWEBVIEW2_COLOR {}
impl ::core::clone::Clone for COREWEBVIEW2_COLOR {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for COREWEBVIEW2_COLOR {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("COREWEBVIEW2_COLOR")
            .field("A", &self.A)
            .field("R", &self.R)
            .field("G", &self.G)
            .field("B", &self.B)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for COREWEBVIEW2_COLOR {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for COREWEBVIEW2_COLOR {
    fn eq(&self, other: &Self) -> bool {
        unsafe {
            ::windows::core::memcmp(
                self as *const _ as _,
                other as *const _ as _,
                core::mem::size_of::<COREWEBVIEW2_COLOR>(),
            ) == 0
        }
    }
}
impl ::core::cmp::Eq for COREWEBVIEW2_COLOR {}
impl ::core::default::Default for COREWEBVIEW2_COLOR {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub type COREWEBVIEW2_COOKIE_SAME_SITE_KIND = i32;
pub const COREWEBVIEW2_COOKIE_SAME_SITE_KIND_NONE: COREWEBVIEW2_COOKIE_SAME_SITE_KIND = 0i32;
pub const COREWEBVIEW2_COOKIE_SAME_SITE_KIND_LAX: COREWEBVIEW2_COOKIE_SAME_SITE_KIND = 1i32;
pub const COREWEBVIEW2_COOKIE_SAME_SITE_KIND_STRICT: COREWEBVIEW2_COOKIE_SAME_SITE_KIND = 2i32;
pub type COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_NONE: COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON =
    0i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_FAILED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 1i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_ACCESS_DENIED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 2i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_NO_SPACE:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 3i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_NAME_TOO_LONG:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 4i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_TOO_LARGE:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 5i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_MALICIOUS:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 6i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_TRANSIENT_ERROR:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 7i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_BLOCKED_BY_POLICY:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 8i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_SECURITY_CHECK_FAILED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 9i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_TOO_SHORT:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 10i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_FILE_HASH_MISMATCH:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 11i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_NETWORK_FAILED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 12i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_NETWORK_TIMEOUT:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 13i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_NETWORK_DISCONNECTED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 14i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_NETWORK_SERVER_DOWN:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 15i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_NETWORK_INVALID_REQUEST:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 16i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_FAILED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 17i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_NO_RANGE:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 18i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_BAD_CONTENT:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 19i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_UNAUTHORIZED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 20i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_CERTIFICATE_PROBLEM:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 21i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_FORBIDDEN:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 22i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_UNEXPECTED_RESPONSE:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 23i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_CONTENT_LENGTH_MISMATCH:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 24i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_SERVER_CROSS_ORIGIN_REDIRECT:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 25i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_USER_CANCELED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 26i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_USER_SHUTDOWN:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 27i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_USER_PAUSED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 28i32;
pub const COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON_DOWNLOAD_PROCESS_CRASHED:
    COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON = 29i32;
pub type COREWEBVIEW2_DOWNLOAD_STATE = i32;
pub const COREWEBVIEW2_DOWNLOAD_STATE_IN_PROGRESS: COREWEBVIEW2_DOWNLOAD_STATE = 0i32;
pub const COREWEBVIEW2_DOWNLOAD_STATE_INTERRUPTED: COREWEBVIEW2_DOWNLOAD_STATE = 1i32;
pub const COREWEBVIEW2_DOWNLOAD_STATE_COMPLETED: COREWEBVIEW2_DOWNLOAD_STATE = 2i32;
pub type COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND = i32;
pub const COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND_DENY: COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND =
    0i32;
pub const COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND_ALLOW: COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND =
    1i32;
pub const COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND_DENY_CORS: COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND =
    2i32;
pub type COREWEBVIEW2_KEY_EVENT_KIND = i32;
pub const COREWEBVIEW2_KEY_EVENT_KIND_KEY_DOWN: COREWEBVIEW2_KEY_EVENT_KIND = 0i32;
pub const COREWEBVIEW2_KEY_EVENT_KIND_KEY_UP: COREWEBVIEW2_KEY_EVENT_KIND = 1i32;
pub const COREWEBVIEW2_KEY_EVENT_KIND_SYSTEM_KEY_DOWN: COREWEBVIEW2_KEY_EVENT_KIND = 2i32;
pub const COREWEBVIEW2_KEY_EVENT_KIND_SYSTEM_KEY_UP: COREWEBVIEW2_KEY_EVENT_KIND = 3i32;
pub type COREWEBVIEW2_MOUSE_EVENT_KIND = i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_HORIZONTAL_WHEEL: COREWEBVIEW2_MOUSE_EVENT_KIND = 526i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_LEFT_BUTTON_DOUBLE_CLICK: COREWEBVIEW2_MOUSE_EVENT_KIND =
    515i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_LEFT_BUTTON_DOWN: COREWEBVIEW2_MOUSE_EVENT_KIND = 513i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_LEFT_BUTTON_UP: COREWEBVIEW2_MOUSE_EVENT_KIND = 514i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_LEAVE: COREWEBVIEW2_MOUSE_EVENT_KIND = 675i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_MIDDLE_BUTTON_DOUBLE_CLICK: COREWEBVIEW2_MOUSE_EVENT_KIND =
    521i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_MIDDLE_BUTTON_DOWN: COREWEBVIEW2_MOUSE_EVENT_KIND = 519i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_MIDDLE_BUTTON_UP: COREWEBVIEW2_MOUSE_EVENT_KIND = 520i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_MOVE: COREWEBVIEW2_MOUSE_EVENT_KIND = 512i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_RIGHT_BUTTON_DOUBLE_CLICK: COREWEBVIEW2_MOUSE_EVENT_KIND =
    518i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_RIGHT_BUTTON_DOWN: COREWEBVIEW2_MOUSE_EVENT_KIND = 516i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_RIGHT_BUTTON_UP: COREWEBVIEW2_MOUSE_EVENT_KIND = 517i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_WHEEL: COREWEBVIEW2_MOUSE_EVENT_KIND = 522i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_X_BUTTON_DOUBLE_CLICK: COREWEBVIEW2_MOUSE_EVENT_KIND =
    525i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_X_BUTTON_DOWN: COREWEBVIEW2_MOUSE_EVENT_KIND = 523i32;
pub const COREWEBVIEW2_MOUSE_EVENT_KIND_X_BUTTON_UP: COREWEBVIEW2_MOUSE_EVENT_KIND = 524i32;
pub type COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS = u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_NONE: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS = 0u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_LEFT_BUTTON: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS =
    1u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_RIGHT_BUTTON:
    COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS = 2u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_SHIFT: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS = 4u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_CONTROL: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS =
    8u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_MIDDLE_BUTTON:
    COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS = 16u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_X_BUTTON1: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS =
    32u32;
pub const COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS_X_BUTTON2: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS =
    64u32;
pub type COREWEBVIEW2_MOVE_FOCUS_REASON = i32;
pub const COREWEBVIEW2_MOVE_FOCUS_REASON_PROGRAMMATIC: COREWEBVIEW2_MOVE_FOCUS_REASON = 0i32;
pub const COREWEBVIEW2_MOVE_FOCUS_REASON_NEXT: COREWEBVIEW2_MOVE_FOCUS_REASON = 1i32;
pub const COREWEBVIEW2_MOVE_FOCUS_REASON_PREVIOUS: COREWEBVIEW2_MOVE_FOCUS_REASON = 2i32;
pub type COREWEBVIEW2_PERMISSION_KIND = i32;
pub const COREWEBVIEW2_PERMISSION_KIND_UNKNOWN_PERMISSION: COREWEBVIEW2_PERMISSION_KIND = 0i32;
pub const COREWEBVIEW2_PERMISSION_KIND_MICROPHONE: COREWEBVIEW2_PERMISSION_KIND = 1i32;
pub const COREWEBVIEW2_PERMISSION_KIND_CAMERA: COREWEBVIEW2_PERMISSION_KIND = 2i32;
pub const COREWEBVIEW2_PERMISSION_KIND_GEOLOCATION: COREWEBVIEW2_PERMISSION_KIND = 3i32;
pub const COREWEBVIEW2_PERMISSION_KIND_NOTIFICATIONS: COREWEBVIEW2_PERMISSION_KIND = 4i32;
pub const COREWEBVIEW2_PERMISSION_KIND_OTHER_SENSORS: COREWEBVIEW2_PERMISSION_KIND = 5i32;
pub const COREWEBVIEW2_PERMISSION_KIND_CLIPBOARD_READ: COREWEBVIEW2_PERMISSION_KIND = 6i32;
pub type COREWEBVIEW2_PERMISSION_STATE = i32;
pub const COREWEBVIEW2_PERMISSION_STATE_DEFAULT: COREWEBVIEW2_PERMISSION_STATE = 0i32;
pub const COREWEBVIEW2_PERMISSION_STATE_ALLOW: COREWEBVIEW2_PERMISSION_STATE = 1i32;
pub const COREWEBVIEW2_PERMISSION_STATE_DENY: COREWEBVIEW2_PERMISSION_STATE = 2i32;
#[repr(C)]
pub struct COREWEBVIEW2_PHYSICAL_KEY_STATUS {
    pub RepeatCount: u32,
    pub ScanCode: u32,
    pub IsExtendedKey: super::super::super::super::Windows::Win32::Foundation::BOOL,
    pub IsMenuKeyDown: super::super::super::super::Windows::Win32::Foundation::BOOL,
    pub WasKeyDown: super::super::super::super::Windows::Win32::Foundation::BOOL,
    pub IsKeyReleased: super::super::super::super::Windows::Win32::Foundation::BOOL,
}
impl ::core::marker::Copy for COREWEBVIEW2_PHYSICAL_KEY_STATUS {}
impl ::core::clone::Clone for COREWEBVIEW2_PHYSICAL_KEY_STATUS {
    fn clone(&self) -> Self {
        *self
    }
}
impl ::core::fmt::Debug for COREWEBVIEW2_PHYSICAL_KEY_STATUS {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_struct("COREWEBVIEW2_PHYSICAL_KEY_STATUS")
            .field("RepeatCount", &self.RepeatCount)
            .field("ScanCode", &self.ScanCode)
            .field("IsExtendedKey", &self.IsExtendedKey)
            .field("IsMenuKeyDown", &self.IsMenuKeyDown)
            .field("WasKeyDown", &self.WasKeyDown)
            .field("IsKeyReleased", &self.IsKeyReleased)
            .finish()
    }
}
unsafe impl ::windows::core::Abi for COREWEBVIEW2_PHYSICAL_KEY_STATUS {
    type Abi = Self;
}
impl ::core::cmp::PartialEq for COREWEBVIEW2_PHYSICAL_KEY_STATUS {
    fn eq(&self, other: &Self) -> bool {
        unsafe {
            ::windows::core::memcmp(
                self as *const _ as _,
                other as *const _ as _,
                core::mem::size_of::<COREWEBVIEW2_PHYSICAL_KEY_STATUS>(),
            ) == 0
        }
    }
}
impl ::core::cmp::Eq for COREWEBVIEW2_PHYSICAL_KEY_STATUS {}
impl ::core::default::Default for COREWEBVIEW2_PHYSICAL_KEY_STATUS {
    fn default() -> Self {
        unsafe { ::core::mem::zeroed() }
    }
}
pub type COREWEBVIEW2_POINTER_EVENT_KIND = i32;
pub const COREWEBVIEW2_POINTER_EVENT_KIND_ACTIVATE: COREWEBVIEW2_POINTER_EVENT_KIND = 587i32;
pub const COREWEBVIEW2_POINTER_EVENT_KIND_DOWN: COREWEBVIEW2_POINTER_EVENT_KIND = 582i32;
pub const COREWEBVIEW2_POINTER_EVENT_KIND_ENTER: COREWEBVIEW2_POINTER_EVENT_KIND = 585i32;
pub const COREWEBVIEW2_POINTER_EVENT_KIND_LEAVE: COREWEBVIEW2_POINTER_EVENT_KIND = 586i32;
pub const COREWEBVIEW2_POINTER_EVENT_KIND_UP: COREWEBVIEW2_POINTER_EVENT_KIND = 583i32;
pub const COREWEBVIEW2_POINTER_EVENT_KIND_UPDATE: COREWEBVIEW2_POINTER_EVENT_KIND = 581i32;
pub type COREWEBVIEW2_PRINT_ORIENTATION = i32;
pub const COREWEBVIEW2_PRINT_ORIENTATION_PORTRAIT: COREWEBVIEW2_PRINT_ORIENTATION = 0i32;
pub const COREWEBVIEW2_PRINT_ORIENTATION_LANDSCAPE: COREWEBVIEW2_PRINT_ORIENTATION = 1i32;
pub type COREWEBVIEW2_PROCESS_FAILED_KIND = i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_BROWSER_PROCESS_EXITED:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 0i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_RENDER_PROCESS_EXITED: COREWEBVIEW2_PROCESS_FAILED_KIND =
    1i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_RENDER_PROCESS_UNRESPONSIVE:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 2i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_FRAME_RENDER_PROCESS_EXITED:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 3i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_UTILITY_PROCESS_EXITED:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 4i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_SANDBOX_HELPER_PROCESS_EXITED:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 5i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_GPU_PROCESS_EXITED: COREWEBVIEW2_PROCESS_FAILED_KIND =
    6i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_PPAPI_PLUGIN_PROCESS_EXITED:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 7i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_PPAPI_BROKER_PROCESS_EXITED:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 8i32;
pub const COREWEBVIEW2_PROCESS_FAILED_KIND_UNKNOWN_PROCESS_EXITED:
    COREWEBVIEW2_PROCESS_FAILED_KIND = 9i32;
pub type COREWEBVIEW2_PROCESS_FAILED_REASON = i32;
pub const COREWEBVIEW2_PROCESS_FAILED_REASON_UNEXPECTED: COREWEBVIEW2_PROCESS_FAILED_REASON = 0i32;
pub const COREWEBVIEW2_PROCESS_FAILED_REASON_UNRESPONSIVE: COREWEBVIEW2_PROCESS_FAILED_REASON =
    1i32;
pub const COREWEBVIEW2_PROCESS_FAILED_REASON_TERMINATED: COREWEBVIEW2_PROCESS_FAILED_REASON = 2i32;
pub const COREWEBVIEW2_PROCESS_FAILED_REASON_CRASHED: COREWEBVIEW2_PROCESS_FAILED_REASON = 3i32;
pub const COREWEBVIEW2_PROCESS_FAILED_REASON_LAUNCH_FAILED: COREWEBVIEW2_PROCESS_FAILED_REASON =
    4i32;
pub const COREWEBVIEW2_PROCESS_FAILED_REASON_OUT_OF_MEMORY: COREWEBVIEW2_PROCESS_FAILED_REASON =
    5i32;
pub type COREWEBVIEW2_SCRIPT_DIALOG_KIND = i32;
pub const COREWEBVIEW2_SCRIPT_DIALOG_KIND_ALERT: COREWEBVIEW2_SCRIPT_DIALOG_KIND = 0i32;
pub const COREWEBVIEW2_SCRIPT_DIALOG_KIND_CONFIRM: COREWEBVIEW2_SCRIPT_DIALOG_KIND = 1i32;
pub const COREWEBVIEW2_SCRIPT_DIALOG_KIND_PROMPT: COREWEBVIEW2_SCRIPT_DIALOG_KIND = 2i32;
pub const COREWEBVIEW2_SCRIPT_DIALOG_KIND_BEFOREUNLOAD: COREWEBVIEW2_SCRIPT_DIALOG_KIND = 3i32;
pub type COREWEBVIEW2_WEB_ERROR_STATUS = i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_UNKNOWN: COREWEBVIEW2_WEB_ERROR_STATUS = 0i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CERTIFICATE_COMMON_NAME_IS_INCORRECT:
    COREWEBVIEW2_WEB_ERROR_STATUS = 1i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CERTIFICATE_EXPIRED: COREWEBVIEW2_WEB_ERROR_STATUS = 2i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CLIENT_CERTIFICATE_CONTAINS_ERRORS:
    COREWEBVIEW2_WEB_ERROR_STATUS = 3i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CERTIFICATE_REVOKED: COREWEBVIEW2_WEB_ERROR_STATUS = 4i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CERTIFICATE_IS_INVALID: COREWEBVIEW2_WEB_ERROR_STATUS =
    5i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_SERVER_UNREACHABLE: COREWEBVIEW2_WEB_ERROR_STATUS = 6i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_TIMEOUT: COREWEBVIEW2_WEB_ERROR_STATUS = 7i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_ERROR_HTTP_INVALID_SERVER_RESPONSE:
    COREWEBVIEW2_WEB_ERROR_STATUS = 8i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CONNECTION_ABORTED: COREWEBVIEW2_WEB_ERROR_STATUS = 9i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CONNECTION_RESET: COREWEBVIEW2_WEB_ERROR_STATUS = 10i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_DISCONNECTED: COREWEBVIEW2_WEB_ERROR_STATUS = 11i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_CANNOT_CONNECT: COREWEBVIEW2_WEB_ERROR_STATUS = 12i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_HOST_NAME_NOT_RESOLVED: COREWEBVIEW2_WEB_ERROR_STATUS =
    13i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_OPERATION_CANCELED: COREWEBVIEW2_WEB_ERROR_STATUS = 14i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_REDIRECT_FAILED: COREWEBVIEW2_WEB_ERROR_STATUS = 15i32;
pub const COREWEBVIEW2_WEB_ERROR_STATUS_UNEXPECTED_ERROR: COREWEBVIEW2_WEB_ERROR_STATUS = 16i32;
pub type COREWEBVIEW2_WEB_RESOURCE_CONTEXT = i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_ALL: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 0i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_DOCUMENT: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 1i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_STYLESHEET: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 2i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_IMAGE: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 3i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_MEDIA: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 4i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_FONT: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 5i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_SCRIPT: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 6i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_XML_HTTP_REQUEST: COREWEBVIEW2_WEB_RESOURCE_CONTEXT =
    7i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_FETCH: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 8i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_TEXT_TRACK: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 9i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_EVENT_SOURCE: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 10i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_WEBSOCKET: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 11i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_MANIFEST: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 12i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_SIGNED_EXCHANGE: COREWEBVIEW2_WEB_RESOURCE_CONTEXT =
    13i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_PING: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 14i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_CSP_VIOLATION_REPORT:
    COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 15i32;
pub const COREWEBVIEW2_WEB_RESOURCE_CONTEXT_OTHER: COREWEBVIEW2_WEB_RESOURCE_CONTEXT = 16i32;
#[inline]
pub unsafe fn CompareBrowserVersions<
    'a,
    Param0: ::windows::core::IntoParam<'a, super::super::super::super::Windows::Win32::Foundation::PWSTR>,
    Param1: ::windows::core::IntoParam<'a, super::super::super::super::Windows::Win32::Foundation::PWSTR>,
>(
    version1: Param0,
    version2: Param1,
    result: *mut i32,
) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "WebView2LoaderStatic", kind = "static")]
        extern "system" {
            fn CompareBrowserVersions(
                version1: super::super::super::super::Windows::Win32::Foundation::PWSTR,
                version2: super::super::super::super::Windows::Win32::Foundation::PWSTR,
                result: *mut i32,
            ) -> ::windows::core::HRESULT;
        }
        CompareBrowserVersions(
            version1.into_param().abi(),
            version2.into_param().abi(),
            ::core::mem::transmute(result),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn CreateCoreWebView2Environment<
    'a,
    Param0: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler>,
>(
    environmentcreatedhandler: Param0,
) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "WebView2LoaderStatic", kind = "static")]
        extern "system" {
            fn CreateCoreWebView2Environment(
                environmentcreatedhandler: ::windows::core::RawPtr,
            ) -> ::windows::core::HRESULT;
        }
        CreateCoreWebView2Environment(environmentcreatedhandler.into_param().abi()).ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn CreateCoreWebView2EnvironmentWithOptions<
    'a,
    Param0: ::windows::core::IntoParam<'a, super::super::super::super::Windows::Win32::Foundation::PWSTR>,
    Param1: ::windows::core::IntoParam<'a, super::super::super::super::Windows::Win32::Foundation::PWSTR>,
    Param2: ::windows::core::IntoParam<'a, ICoreWebView2EnvironmentOptions>,
    Param3: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler>,
>(
    browserexecutablefolder: Param0,
    userdatafolder: Param1,
    environmentoptions: Param2,
    environmentcreatedhandler: Param3,
) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "WebView2LoaderStatic", kind = "static")]
        extern "system" {
            fn CreateCoreWebView2EnvironmentWithOptions(
                browserexecutablefolder : super::super::super::super::Windows::Win32::Foundation:: PWSTR,
                userdatafolder: super::super::super::super::Windows::Win32::Foundation::PWSTR,
                environmentoptions: ::windows::core::RawPtr,
                environmentcreatedhandler: ::windows::core::RawPtr,
            ) -> ::windows::core::HRESULT;
        }
        CreateCoreWebView2EnvironmentWithOptions(
            browserexecutablefolder.into_param().abi(),
            userdatafolder.into_param().abi(),
            environmentoptions.into_param().abi(),
            environmentcreatedhandler.into_param().abi(),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[inline]
pub unsafe fn GetAvailableCoreWebView2BrowserVersionString<
    'a,
    Param0: ::windows::core::IntoParam<'a, super::super::super::super::Windows::Win32::Foundation::PWSTR>,
>(
    browserexecutablefolder: Param0,
    versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
) -> ::windows::core::Result<()> {
    #[cfg(windows)]
    {
        #[link(name = "WebView2LoaderStatic", kind = "static")]
        extern "system" {
            fn GetAvailableCoreWebView2BrowserVersionString(
                browserexecutablefolder : super::super::super::super::Windows::Win32::Foundation:: PWSTR,
                versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
            ) -> ::windows::core::HRESULT;
        }
        GetAvailableCoreWebView2BrowserVersionString(
            browserexecutablefolder.into_param().abi(),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    #[cfg(not(windows))]
    unimplemented!("Unsupported target OS");
}
#[repr(transparent)]
pub struct ICoreWebView2(::windows::core::IUnknown);
impl ICoreWebView2 {
    pub unsafe fn Settings(&self) -> ::windows::core::Result<ICoreWebView2Settings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Settings>(result__)
    }
    pub unsafe fn Source(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn Navigate<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        htmlcontent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            htmlcontent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContentLoadingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2SourceChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveSourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2HistoryChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveHistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ScriptDialogOpeningEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2PermissionRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemovePermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler,
        >,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        id: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            id.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ExecuteScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ExecuteScriptCompletedHandler>,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CapturePreview<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CapturePreviewCompletedHandler>,
    >(
        &self,
        imageformat: COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT,
        imagestream: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(imageformat),
            imagestream.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Reload(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PostWebMessageAsJson<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasjson: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            webmessageasjson.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PostWebMessageAsString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasstring: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(
            ::core::mem::transmute_copy(self),
            webmessageasstring.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebMessageReceivedEventHandler>,
    >(
        &self,
        handler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CallDevToolsProtocolMethod<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CallDevToolsProtocolMethodCompletedHandler>,
    >(
        &self,
        methodname: Param0,
        parametersasjson: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(
            ::core::mem::transmute_copy(self),
            methodname.into_param().abi(),
            parametersasjson.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn BrowserProcessId(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).37)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn CanGoBack(
        &self,
        cangoback: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoback),
        )
        .ok()
    }
    pub unsafe fn CanGoForward(
        &self,
        cangoforward: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).39)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoforward),
        )
        .ok()
    }
    pub unsafe fn GoBack(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GoForward(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetDevToolsProtocolEventReceiver<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        eventname: Param0,
    ) -> ::windows::core::Result<ICoreWebView2DevToolsProtocolEventReceiver> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).42)(
            ::core::mem::transmute_copy(self),
            eventname.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2DevToolsProtocolEventReceiver>(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn NewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).45)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DocumentTitleChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitle(
        &self,
        title: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(title),
        )
        .ok()
    }
    pub unsafe fn AddHostObjectToScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        object: *mut super::super::super::super::Windows::Win32::System::Com::VARIANT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(object),
        )
        .ok()
    }
    pub unsafe fn RemoveHostObjectFromScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OpenDevToolsWindow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContainsFullScreenElementChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContainsFullScreenElement(
        &self,
        containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(containsfullscreenelement),
        )
        .ok()
    }
    pub unsafe fn WebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).56)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn WindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WindowCloseRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).60)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2 {}
impl ::core::fmt::Debug for ICoreWebView2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2 {
    type Vtable = ICoreWebView2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x76eceacb_0462_4d94_ac83_423a6793775e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , settings : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , htmlcontent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , id : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , imageformat : COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT , imagestream : :: windows :: core :: RawPtr , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasstring : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , methodname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , parametersasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut u32 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoback : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoforward : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , receiver : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , title : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , object : * mut super::super::super::super::Windows::Win32::System::Com:: VARIANT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2AcceleratorKeyPressedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2AcceleratorKeyPressedEventArgs {
    pub unsafe fn KeyEventKind(
        &self,
        keyeventkind: *mut COREWEBVIEW2_KEY_EVENT_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(keyeventkind),
        )
        .ok()
    }
    pub unsafe fn VirtualKey(&self, virtualkey: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(virtualkey),
        )
        .ok()
    }
    pub unsafe fn KeyEventLParam(&self, lparam: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(lparam),
        )
        .ok()
    }
    pub unsafe fn PhysicalKeyStatus(
        &self,
        physicalkeystatus: *mut COREWEBVIEW2_PHYSICAL_KEY_STATUS,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(physicalkeystatus),
        )
        .ok()
    }
    pub unsafe fn Handled(
        &self,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(handled),
        )
        .ok()
    }
    pub unsafe fn SetHandled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        handled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            handled.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2AcceleratorKeyPressedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2AcceleratorKeyPressedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2AcceleratorKeyPressedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2AcceleratorKeyPressedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2AcceleratorKeyPressedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2AcceleratorKeyPressedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2AcceleratorKeyPressedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2AcceleratorKeyPressedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2AcceleratorKeyPressedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2AcceleratorKeyPressedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2AcceleratorKeyPressedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2AcceleratorKeyPressedEventArgs {
    type Vtable = ICoreWebView2AcceleratorKeyPressedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x9f760f8a_fb79_42be_9990_7b56900fa9c7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2AcceleratorKeyPressedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        keyeventkind: *mut COREWEBVIEW2_KEY_EVENT_KIND,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        virtualkey: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        lparam: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        physicalkeystatus: *mut COREWEBVIEW2_PHYSICAL_KEY_STATUS,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2AcceleratorKeyPressedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2AcceleratorKeyPressedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Controller>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2AcceleratorKeyPressedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2AcceleratorKeyPressedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2AcceleratorKeyPressedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2AcceleratorKeyPressedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2AcceleratorKeyPressedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2AcceleratorKeyPressedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2AcceleratorKeyPressedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2AcceleratorKeyPressedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2AcceleratorKeyPressedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2AcceleratorKeyPressedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2AcceleratorKeyPressedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2AcceleratorKeyPressedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2AcceleratorKeyPressedEventHandler {
    type Vtable = ICoreWebView2AcceleratorKeyPressedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xb29c7e28_fa79_41a8_8e44_65811c76dcb2);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2AcceleratorKeyPressedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler(
    ::windows::core::IUnknown,
);
impl ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler {
    pub unsafe fn Invoke<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        errorcode: ::windows::core::HRESULT,
        id: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            id.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface
    for ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler
{
    type Vtable = ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xb99369f3_9b11_47b5_bc6f_8e7895fcea17);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        id: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2BrowserProcessExitedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2BrowserProcessExitedEventArgs {
    pub unsafe fn BrowserProcessExitKind(
        &self,
        browserprocessexitkind: *mut COREWEBVIEW2_BROWSER_PROCESS_EXIT_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(browserprocessexitkind),
        )
        .ok()
    }
    pub unsafe fn BrowserProcessId(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2BrowserProcessExitedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2BrowserProcessExitedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2BrowserProcessExitedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2BrowserProcessExitedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2BrowserProcessExitedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2BrowserProcessExitedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2BrowserProcessExitedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2BrowserProcessExitedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2BrowserProcessExitedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2BrowserProcessExitedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2BrowserProcessExitedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2BrowserProcessExitedEventArgs {
    type Vtable = ICoreWebView2BrowserProcessExitedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x1f00663f_af8c_4782_9cdd_dd01c52e34cb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2BrowserProcessExitedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        browserprocessexitkind: *mut COREWEBVIEW2_BROWSER_PROCESS_EXIT_KIND,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut u32,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2BrowserProcessExitedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2BrowserProcessExitedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Environment>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2BrowserProcessExitedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2BrowserProcessExitedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2BrowserProcessExitedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2BrowserProcessExitedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2BrowserProcessExitedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2BrowserProcessExitedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2BrowserProcessExitedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2BrowserProcessExitedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2BrowserProcessExitedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2BrowserProcessExitedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2BrowserProcessExitedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2BrowserProcessExitedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2BrowserProcessExitedEventHandler {
    type Vtable = ICoreWebView2BrowserProcessExitedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xfa504257_a216_4911_a860_fe8825712861);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2BrowserProcessExitedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2BytesReceivedChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2BytesReceivedChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DownloadOperation>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2BytesReceivedChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2BytesReceivedChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2BytesReceivedChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2BytesReceivedChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2BytesReceivedChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2BytesReceivedChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2BytesReceivedChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2BytesReceivedChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2BytesReceivedChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2BytesReceivedChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2BytesReceivedChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2BytesReceivedChangedEventHandler {
    type Vtable = ICoreWebView2BytesReceivedChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x828e8ab6_d94c_4264_9cef_5217170d6251);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2BytesReceivedChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CallDevToolsProtocolMethodCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2CallDevToolsProtocolMethodCompletedHandler {
    pub unsafe fn Invoke<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        errorcode: ::windows::core::HRESULT,
        returnobjectasjson: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            returnobjectasjson.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2CallDevToolsProtocolMethodCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2CallDevToolsProtocolMethodCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CallDevToolsProtocolMethodCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2CallDevToolsProtocolMethodCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CallDevToolsProtocolMethodCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CallDevToolsProtocolMethodCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CallDevToolsProtocolMethodCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CallDevToolsProtocolMethodCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CallDevToolsProtocolMethodCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2CallDevToolsProtocolMethodCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CallDevToolsProtocolMethodCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2CallDevToolsProtocolMethodCompletedHandler {
    type Vtable = ICoreWebView2CallDevToolsProtocolMethodCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x5c4889f0_5ef6_4c5a_952c_d8f1b92d0574);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CallDevToolsProtocolMethodCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        returnobjectasjson: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CapturePreviewCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2CapturePreviewCompletedHandler {
    pub unsafe fn Invoke(
        &self,
        errorcode: ::windows::core::HRESULT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2CapturePreviewCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2CapturePreviewCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CapturePreviewCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2CapturePreviewCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CapturePreviewCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CapturePreviewCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CapturePreviewCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CapturePreviewCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CapturePreviewCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2CapturePreviewCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CapturePreviewCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2CapturePreviewCompletedHandler {
    type Vtable = ICoreWebView2CapturePreviewCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x697e05e9_3d8f_45fa_96f4_8ffe1ededaf5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CapturePreviewCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ClientCertificate(::windows::core::IUnknown);
impl ICoreWebView2ClientCertificate {
    pub unsafe fn Subject(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn Issuer(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn ValidFrom(&self, value: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn ValidTo(&self, value: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn DerEncodedSerialNumber(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn DisplayName(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn ToPemEncoding(
        &self,
        pemencodeddata: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pemencodeddata),
        )
        .ok()
    }
    pub unsafe fn PemEncodedIssuerCertificateChain(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2StringCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2StringCollection>(result__)
    }
    pub unsafe fn Kind(
        &self,
        value: *mut COREWEBVIEW2_CLIENT_CERTIFICATE_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ClientCertificate> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2ClientCertificate) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ClientCertificate> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2ClientCertificate) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ClientCertificate
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ClientCertificate
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ClientCertificate {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ClientCertificate {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ClientCertificate {}
impl ::core::fmt::Debug for ICoreWebView2ClientCertificate {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ClientCertificate")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ClientCertificate {
    type Vtable = ICoreWebView2ClientCertificateVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe7188076_bcc3_11eb_8529_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ClientCertificateVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut f64,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut f64,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pemencodeddata: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut COREWEBVIEW2_CLIENT_CERTIFICATE_KIND,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ClientCertificateCollection(::windows::core::IUnknown);
impl ICoreWebView2ClientCertificateCollection {
    pub unsafe fn Count(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn GetValueAtIndex(
        &self,
        index: u32,
    ) -> ::windows::core::Result<ICoreWebView2ClientCertificate> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(index),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2ClientCertificate>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2ClientCertificateCollection> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2ClientCertificateCollection) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ClientCertificateCollection>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ClientCertificateCollection) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ClientCertificateCollection
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ClientCertificateCollection
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ClientCertificateCollection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ClientCertificateCollection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ClientCertificateCollection {}
impl ::core::fmt::Debug for ICoreWebView2ClientCertificateCollection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ClientCertificateCollection")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ClientCertificateCollection {
    type Vtable = ICoreWebView2ClientCertificateCollectionVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xef5674d2_bcc3_11eb_8529_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ClientCertificateCollectionVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        index: u32,
        certificate: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ClientCertificateRequestedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2ClientCertificateRequestedEventArgs {
    pub unsafe fn Host(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn Port(&self, value: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn IsProxy(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn AllowedCertificateAuthorities(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2StringCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2StringCollection>(result__)
    }
    pub unsafe fn MutuallyTrustedCertificates(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2ClientCertificateCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2ClientCertificateCollection>(result__)
    }
    pub unsafe fn SelectedCertificate(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2ClientCertificate> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2ClientCertificate>(result__)
    }
    pub unsafe fn SetSelectedCertificate<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ClientCertificate>,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Cancel(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetCancel<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Handled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetHandled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetDeferral(&self) -> ::windows::core::Result<ICoreWebView2Deferral> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Deferral>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2ClientCertificateRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2ClientCertificateRequestedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ClientCertificateRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ClientCertificateRequestedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ClientCertificateRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ClientCertificateRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ClientCertificateRequestedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ClientCertificateRequestedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ClientCertificateRequestedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2ClientCertificateRequestedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ClientCertificateRequestedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ClientCertificateRequestedEventArgs {
    type Vtable = ICoreWebView2ClientCertificateRequestedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xbc59db28_bcc3_11eb_8529_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ClientCertificateRequestedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        deferral: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ClientCertificateRequestedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2ClientCertificateRequestedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ClientCertificateRequestedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ClientCertificateRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2ClientCertificateRequestedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ClientCertificateRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ClientCertificateRequestedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ClientCertificateRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ClientCertificateRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ClientCertificateRequestedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ClientCertificateRequestedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ClientCertificateRequestedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2ClientCertificateRequestedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ClientCertificateRequestedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ClientCertificateRequestedEventHandler {
    type Vtable = ICoreWebView2ClientCertificateRequestedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xd7175ba2_bcc3_11eb_8529_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ClientCertificateRequestedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CompositionController(::windows::core::IUnknown);
impl ICoreWebView2CompositionController {
    pub unsafe fn RootVisualTarget(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn SetRootVisualTarget<
        'a,
        Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        target: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            target.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SendMouseInput<
        'a,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::POINT,
        >,
    >(
        &self,
        eventkind: COREWEBVIEW2_MOUSE_EVENT_KIND,
        virtualkeys: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS,
        mousedata: u32,
        point: Param3,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(eventkind),
            ::core::mem::transmute(virtualkeys),
            ::core::mem::transmute(mousedata),
            point.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SendPointerInput<
        'a,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2PointerInfo>,
    >(
        &self,
        eventkind: COREWEBVIEW2_POINTER_EVENT_KIND,
        pointerinfo: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(eventkind),
            pointerinfo.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Cursor(
        &self,
        cursor: *mut super::super::super::super::Windows::Win32::UI::WindowsAndMessaging::HCURSOR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cursor),
        )
        .ok()
    }
    pub unsafe fn SystemCursorId(&self, systemcursorid: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(systemcursorid),
        )
        .ok()
    }
    pub unsafe fn CursorChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2CursorChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveCursorChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2CompositionController> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2CompositionController) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CompositionController> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2CompositionController) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CompositionController
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CompositionController
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CompositionController {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CompositionController {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CompositionController {}
impl ::core::fmt::Debug for ICoreWebView2CompositionController {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CompositionController")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2CompositionController {
    type Vtable = ICoreWebView2CompositionControllerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x3df9b733_b9ae_4a15_86b4_eb9ee9826469);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CompositionControllerVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , target : * mut * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , target : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventkind : COREWEBVIEW2_MOUSE_EVENT_KIND , virtualkeys : COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS , mousedata : u32 , point : super::super::super::super::Windows::Win32::Foundation:: POINT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventkind : COREWEBVIEW2_POINTER_EVENT_KIND , pointerinfo : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cursor : * mut super::super::super::super::Windows::Win32::UI::WindowsAndMessaging:: HCURSOR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , systemcursorid : * mut u32 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2CompositionController2(::windows::core::IUnknown);
impl ICoreWebView2CompositionController2 {
    pub unsafe fn RootVisualTarget(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn SetRootVisualTarget<
        'a,
        Param0: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        target: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            target.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SendMouseInput<
        'a,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::POINT,
        >,
    >(
        &self,
        eventkind: COREWEBVIEW2_MOUSE_EVENT_KIND,
        virtualkeys: COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS,
        mousedata: u32,
        point: Param3,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(eventkind),
            ::core::mem::transmute(virtualkeys),
            ::core::mem::transmute(mousedata),
            point.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SendPointerInput<
        'a,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2PointerInfo>,
    >(
        &self,
        eventkind: COREWEBVIEW2_POINTER_EVENT_KIND,
        pointerinfo: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(eventkind),
            pointerinfo.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Cursor(
        &self,
        cursor: *mut super::super::super::super::Windows::Win32::UI::WindowsAndMessaging::HCURSOR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cursor),
        )
        .ok()
    }
    pub unsafe fn SystemCursorId(&self, systemcursorid: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(systemcursorid),
        )
        .ok()
    }
    pub unsafe fn CursorChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2CursorChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveCursorChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UIAProvider(&self) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2CompositionController2>
    for ICoreWebView2CompositionController
{
    fn from(value: ICoreWebView2CompositionController2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CompositionController2>
    for ICoreWebView2CompositionController
{
    fn from(value: &ICoreWebView2CompositionController2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2CompositionController>
    for ICoreWebView2CompositionController2
{
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2CompositionController> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2CompositionController>
    for &ICoreWebView2CompositionController2
{
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2CompositionController> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2CompositionController2> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2CompositionController2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CompositionController2> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2CompositionController2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CompositionController2
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CompositionController2
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CompositionController2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CompositionController2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CompositionController2 {}
impl ::core::fmt::Debug for ICoreWebView2CompositionController2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CompositionController2")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2CompositionController2 {
    type Vtable = ICoreWebView2CompositionController2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x0b6a3d24_49cb_4806_ba20_b5e0734a7b26);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CompositionController2Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , target : * mut * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , target : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventkind : COREWEBVIEW2_MOUSE_EVENT_KIND , virtualkeys : COREWEBVIEW2_MOUSE_EVENT_VIRTUAL_KEYS , mousedata : u32 , point : super::super::super::super::Windows::Win32::Foundation:: POINT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventkind : COREWEBVIEW2_POINTER_EVENT_KIND , pointerinfo : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cursor : * mut super::super::super::super::Windows::Win32::UI::WindowsAndMessaging:: HCURSOR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , systemcursorid : * mut u32 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , provider : * mut * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2ContainsFullScreenElementChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2ContainsFullScreenElementChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ContainsFullScreenElementChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2ContainsFullScreenElementChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ContainsFullScreenElementChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ContainsFullScreenElementChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ContainsFullScreenElementChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ContainsFullScreenElementChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ContainsFullScreenElementChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ContainsFullScreenElementChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ContainsFullScreenElementChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2ContainsFullScreenElementChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ContainsFullScreenElementChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface
    for ICoreWebView2ContainsFullScreenElementChangedEventHandler
{
    type Vtable = ICoreWebView2ContainsFullScreenElementChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe45d98b1_afef_45be_8baf_6c7728867f73);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ContainsFullScreenElementChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ContentLoadingEventArgs(::windows::core::IUnknown);
impl ICoreWebView2ContentLoadingEventArgs {
    pub unsafe fn IsErrorPage(
        &self,
        iserrorpage: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(iserrorpage),
        )
        .ok()
    }
    pub unsafe fn NavigationId(&self, navigationid: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(navigationid),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ContentLoadingEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2ContentLoadingEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ContentLoadingEventArgs> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2ContentLoadingEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ContentLoadingEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ContentLoadingEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ContentLoadingEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ContentLoadingEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ContentLoadingEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2ContentLoadingEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ContentLoadingEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ContentLoadingEventArgs {
    type Vtable = ICoreWebView2ContentLoadingEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x0c8a1275_9b6b_4901_87ad_70df25bafa6e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ContentLoadingEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iserrorpage: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        navigationid: *mut u64,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ContentLoadingEventHandler(::windows::core::IUnknown);
impl ICoreWebView2ContentLoadingEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ContentLoadingEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ContentLoadingEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2ContentLoadingEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ContentLoadingEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2ContentLoadingEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ContentLoadingEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ContentLoadingEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ContentLoadingEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ContentLoadingEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ContentLoadingEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2ContentLoadingEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ContentLoadingEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ContentLoadingEventHandler {
    type Vtable = ICoreWebView2ContentLoadingEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x364471e7_f2be_4910_bdba_d72077d51c4b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ContentLoadingEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2Controller(::windows::core::IUnknown);
impl ICoreWebView2Controller {
    pub unsafe fn IsVisible(
        &self,
        isvisible: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isvisible),
        )
        .ok()
    }
    pub unsafe fn SetIsVisible<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isvisible: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isvisible.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Bounds(
        &self,
        bounds: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(bounds),
        )
        .ok()
    }
    pub unsafe fn SetBounds<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        bounds: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            bounds.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ZoomFactor(&self, zoomfactor: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn SetZoomFactor(&self, zoomfactor: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn ZoomFactorChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ZoomFactorChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveZoomFactorChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetBoundsAndZoomFactor<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        bounds: Param0,
        zoomfactor: f64,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            bounds.into_param().abi(),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn MoveFocus(
        &self,
        reason: COREWEBVIEW2_MOVE_FOCUS_REASON,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(reason),
        )
        .ok()
    }
    pub unsafe fn MoveFocusRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2MoveFocusRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveMoveFocusRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GotFocus<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FocusChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveGotFocus<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn LostFocus<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FocusChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveLostFocus<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AcceleratorKeyPressed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2AcceleratorKeyPressedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveAcceleratorKeyPressed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ParentWindow(
        &self,
        parentwindow: *mut super::super::super::super::Windows::Win32::Foundation::HWND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(parentwindow),
        )
        .ok()
    }
    pub unsafe fn SetParentWindow<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
    >(
        &self,
        parentwindow: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NotifyParentWindowPositionChanged(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn CoreWebView2(&self) -> ::windows::core::Result<ICoreWebView2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2Controller> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Controller) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Controller> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Controller) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Controller {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Controller {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Controller {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Controller {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Controller {}
impl ::core::fmt::Debug for ICoreWebView2Controller {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Controller")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Controller {
    type Vtable = ICoreWebView2ControllerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x4d00c0d1_9434_4eb6_8078_8697a560334f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ControllerVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isvisible : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isvisible : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : * mut super::super::super::super::Windows::Win32::Foundation:: RECT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : super::super::super::super::Windows::Win32::Foundation:: RECT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , zoomfactor : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , zoomfactor : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : super::super::super::super::Windows::Win32::Foundation:: RECT , zoomfactor : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , reason : COREWEBVIEW2_MOVE_FOCUS_REASON , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : * mut super::super::super::super::Windows::Win32::Foundation:: HWND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , corewebview2 : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Controller2(::windows::core::IUnknown);
impl ICoreWebView2Controller2 {
    pub unsafe fn IsVisible(
        &self,
        isvisible: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isvisible),
        )
        .ok()
    }
    pub unsafe fn SetIsVisible<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isvisible: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isvisible.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Bounds(
        &self,
        bounds: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(bounds),
        )
        .ok()
    }
    pub unsafe fn SetBounds<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        bounds: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            bounds.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ZoomFactor(&self, zoomfactor: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn SetZoomFactor(&self, zoomfactor: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn ZoomFactorChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ZoomFactorChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveZoomFactorChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetBoundsAndZoomFactor<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        bounds: Param0,
        zoomfactor: f64,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            bounds.into_param().abi(),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn MoveFocus(
        &self,
        reason: COREWEBVIEW2_MOVE_FOCUS_REASON,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(reason),
        )
        .ok()
    }
    pub unsafe fn MoveFocusRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2MoveFocusRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveMoveFocusRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GotFocus<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FocusChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveGotFocus<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn LostFocus<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FocusChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveLostFocus<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AcceleratorKeyPressed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2AcceleratorKeyPressedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveAcceleratorKeyPressed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ParentWindow(
        &self,
        parentwindow: *mut super::super::super::super::Windows::Win32::Foundation::HWND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(parentwindow),
        )
        .ok()
    }
    pub unsafe fn SetParentWindow<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
    >(
        &self,
        parentwindow: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NotifyParentWindowPositionChanged(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn CoreWebView2(&self) -> ::windows::core::Result<ICoreWebView2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2>(result__)
    }
    pub unsafe fn DefaultBackgroundColor(
        &self,
        backgroundcolor: *mut COREWEBVIEW2_COLOR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(backgroundcolor),
        )
        .ok()
    }
    pub unsafe fn SetDefaultBackgroundColor<
        'a,
        Param0: ::windows::core::IntoParam<'a, COREWEBVIEW2_COLOR>,
    >(
        &self,
        backgroundcolor: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            backgroundcolor.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Controller2> for ICoreWebView2Controller {
    fn from(value: ICoreWebView2Controller2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Controller2> for ICoreWebView2Controller {
    fn from(value: &ICoreWebView2Controller2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Controller> for ICoreWebView2Controller2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Controller> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Controller> for &ICoreWebView2Controller2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Controller> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Controller2> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Controller2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Controller2> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Controller2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Controller2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Controller2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Controller2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Controller2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Controller2 {}
impl ::core::fmt::Debug for ICoreWebView2Controller2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Controller2")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Controller2 {
    type Vtable = ICoreWebView2Controller2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xc979903e_d4ca_4228_92eb_47ee3fa96eab);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Controller2Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isvisible : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isvisible : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : * mut super::super::super::super::Windows::Win32::Foundation:: RECT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : super::super::super::super::Windows::Win32::Foundation:: RECT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , zoomfactor : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , zoomfactor : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : super::super::super::super::Windows::Win32::Foundation:: RECT , zoomfactor : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , reason : COREWEBVIEW2_MOVE_FOCUS_REASON , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : * mut super::super::super::super::Windows::Win32::Foundation:: HWND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , corewebview2 : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , backgroundcolor : * mut COREWEBVIEW2_COLOR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , backgroundcolor : COREWEBVIEW2_COLOR , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Controller3(::windows::core::IUnknown);
impl ICoreWebView2Controller3 {
    pub unsafe fn IsVisible(
        &self,
        isvisible: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isvisible),
        )
        .ok()
    }
    pub unsafe fn SetIsVisible<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isvisible: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isvisible.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Bounds(
        &self,
        bounds: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(bounds),
        )
        .ok()
    }
    pub unsafe fn SetBounds<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        bounds: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            bounds.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ZoomFactor(&self, zoomfactor: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn SetZoomFactor(&self, zoomfactor: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn ZoomFactorChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ZoomFactorChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveZoomFactorChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SetBoundsAndZoomFactor<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        bounds: Param0,
        zoomfactor: f64,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            bounds.into_param().abi(),
            ::core::mem::transmute(zoomfactor),
        )
        .ok()
    }
    pub unsafe fn MoveFocus(
        &self,
        reason: COREWEBVIEW2_MOVE_FOCUS_REASON,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(reason),
        )
        .ok()
    }
    pub unsafe fn MoveFocusRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2MoveFocusRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveMoveFocusRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GotFocus<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FocusChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveGotFocus<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn LostFocus<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FocusChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveLostFocus<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AcceleratorKeyPressed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2AcceleratorKeyPressedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveAcceleratorKeyPressed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ParentWindow(
        &self,
        parentwindow: *mut super::super::super::super::Windows::Win32::Foundation::HWND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(parentwindow),
        )
        .ok()
    }
    pub unsafe fn SetParentWindow<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
    >(
        &self,
        parentwindow: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NotifyParentWindowPositionChanged(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Close(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn CoreWebView2(&self) -> ::windows::core::Result<ICoreWebView2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2>(result__)
    }
    pub unsafe fn DefaultBackgroundColor(
        &self,
        backgroundcolor: *mut COREWEBVIEW2_COLOR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(backgroundcolor),
        )
        .ok()
    }
    pub unsafe fn SetDefaultBackgroundColor<
        'a,
        Param0: ::windows::core::IntoParam<'a, COREWEBVIEW2_COLOR>,
    >(
        &self,
        backgroundcolor: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            backgroundcolor.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RasterizationScale(&self, scale: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(scale),
        )
        .ok()
    }
    pub unsafe fn SetRasterizationScale(&self, scale: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(scale),
        )
        .ok()
    }
    pub unsafe fn ShouldDetectMonitorScaleChanges(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetShouldDetectMonitorScaleChanges<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RasterizationScaleChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2RasterizationScaleChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveRasterizationScaleChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn BoundsMode(
        &self,
        boundsmode: *mut COREWEBVIEW2_BOUNDS_MODE,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(boundsmode),
        )
        .ok()
    }
    pub unsafe fn SetBoundsMode(
        &self,
        boundsmode: COREWEBVIEW2_BOUNDS_MODE,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(boundsmode),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Controller3> for ICoreWebView2Controller2 {
    fn from(value: ICoreWebView2Controller3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Controller3> for ICoreWebView2Controller2 {
    fn from(value: &ICoreWebView2Controller3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Controller2> for ICoreWebView2Controller3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Controller2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Controller2> for &ICoreWebView2Controller3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Controller2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Controller3> for ICoreWebView2Controller {
    fn from(value: ICoreWebView2Controller3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Controller3> for ICoreWebView2Controller {
    fn from(value: &ICoreWebView2Controller3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Controller> for ICoreWebView2Controller3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Controller> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Controller> for &ICoreWebView2Controller3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Controller> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Controller3> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Controller3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Controller3> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Controller3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Controller3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Controller3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Controller3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Controller3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Controller3 {}
impl ::core::fmt::Debug for ICoreWebView2Controller3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Controller3")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Controller3 {
    type Vtable = ICoreWebView2Controller3Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xf9614724_5d2b_41dc_aef7_73d62b51543b);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Controller3Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isvisible : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isvisible : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : * mut super::super::super::super::Windows::Win32::Foundation:: RECT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : super::super::super::super::Windows::Win32::Foundation:: RECT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , zoomfactor : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , zoomfactor : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bounds : super::super::super::super::Windows::Win32::Foundation:: RECT , zoomfactor : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , reason : COREWEBVIEW2_MOVE_FOCUS_REASON , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : * mut super::super::super::super::Windows::Win32::Foundation:: HWND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , corewebview2 : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , backgroundcolor : * mut COREWEBVIEW2_COLOR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , backgroundcolor : COREWEBVIEW2_COLOR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , scale : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , scale : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , boundsmode : * mut COREWEBVIEW2_BOUNDS_MODE , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , boundsmode : COREWEBVIEW2_BOUNDS_MODE , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Cookie(::windows::core::IUnknown);
impl ICoreWebView2Cookie {
    pub unsafe fn Name(
        &self,
        name: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(name),
        )
        .ok()
    }
    pub unsafe fn Value(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetValue<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Domain(
        &self,
        domain: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(domain),
        )
        .ok()
    }
    pub unsafe fn Path(
        &self,
        path: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(path),
        )
        .ok()
    }
    pub unsafe fn Expires(&self, expires: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(expires),
        )
        .ok()
    }
    pub unsafe fn SetExpires(&self, expires: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(expires),
        )
        .ok()
    }
    pub unsafe fn IsHttpOnly(
        &self,
        ishttponly: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(ishttponly),
        )
        .ok()
    }
    pub unsafe fn SetIsHttpOnly<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        ishttponly: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ishttponly.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SameSite(
        &self,
        samesite: *mut COREWEBVIEW2_COOKIE_SAME_SITE_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(samesite),
        )
        .ok()
    }
    pub unsafe fn SetSameSite(
        &self,
        samesite: COREWEBVIEW2_COOKIE_SAME_SITE_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(samesite),
        )
        .ok()
    }
    pub unsafe fn IsSecure(
        &self,
        issecure: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(issecure),
        )
        .ok()
    }
    pub unsafe fn SetIsSecure<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        issecure: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            issecure.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsSession(
        &self,
        issession: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(issession),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Cookie> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Cookie) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Cookie> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Cookie) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Cookie {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Cookie {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Cookie {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Cookie {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Cookie {}
impl ::core::fmt::Debug for ICoreWebView2Cookie {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Cookie").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Cookie {
    type Vtable = ICoreWebView2CookieVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xad26d6be_1486_43e6_bf87_a2034006ca21);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CookieVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        domain: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        path: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        expires: *mut f64,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        expires: f64,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        ishttponly: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        ishttponly: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        samesite: *mut COREWEBVIEW2_COOKIE_SAME_SITE_KIND,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        samesite: COREWEBVIEW2_COOKIE_SAME_SITE_KIND,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        issecure: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        issecure: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        issession: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CookieList(::windows::core::IUnknown);
impl ICoreWebView2CookieList {
    pub unsafe fn Count(&self, count: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(count),
        )
        .ok()
    }
    pub unsafe fn GetValueAtIndex(
        &self,
        index: u32,
    ) -> ::windows::core::Result<ICoreWebView2Cookie> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(index),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Cookie>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2CookieList> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2CookieList) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CookieList> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2CookieList) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2CookieList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2CookieList {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CookieList {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CookieList {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CookieList {}
impl ::core::fmt::Debug for ICoreWebView2CookieList {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CookieList")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2CookieList {
    type Vtable = ICoreWebView2CookieListVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xf7f6f714_5d2a_43c6_9503_346ece02d186);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CookieListVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        count: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        index: u32,
        cookie: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CookieManager(::windows::core::IUnknown);
impl ICoreWebView2CookieManager {
    pub unsafe fn CreateCookie<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        value: Param1,
        domain: Param2,
        path: Param3,
    ) -> ::windows::core::Result<ICoreWebView2Cookie> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            value.into_param().abi(),
            domain.into_param().abi(),
            path.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Cookie>(result__)
    }
    pub unsafe fn CopyCookie<'a, Param0: ::windows::core::IntoParam<'a, ICoreWebView2Cookie>>(
        &self,
        cookieparam: Param0,
    ) -> ::windows::core::Result<ICoreWebView2Cookie> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            cookieparam.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Cookie>(result__)
    }
    pub unsafe fn GetCookies<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2GetCookiesCompletedHandler>,
    >(
        &self,
        uri: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddOrUpdateCookie<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Cookie>,
    >(
        &self,
        cookie: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            cookie.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DeleteCookie<'a, Param0: ::windows::core::IntoParam<'a, ICoreWebView2Cookie>>(
        &self,
        cookie: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            cookie.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DeleteCookies<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        uri: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DeleteCookiesWithDomainAndPath<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        domain: Param1,
        path: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            domain.into_param().abi(),
            path.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DeleteAllCookies(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ICoreWebView2CookieManager> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2CookieManager) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CookieManager> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2CookieManager) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2CookieManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2CookieManager {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CookieManager {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CookieManager {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CookieManager {}
impl ::core::fmt::Debug for ICoreWebView2CookieManager {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CookieManager")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2CookieManager {
    type Vtable = ICoreWebView2CookieManagerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x177cd9e7_b6f5_451a_94a0_5d7a3a4c4141);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CookieManagerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        value: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        domain: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        path: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        cookie: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        cookieparam: ::windows::core::RawPtr,
        cookie: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        handler: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        cookie: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        cookie: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        uri: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        domain: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        path: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler(
    ::windows::core::IUnknown,
);
impl ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler {
    pub unsafe fn Invoke<
        'a,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CompositionController>,
    >(
        &self,
        errorcode: ::windows::core::HRESULT,
        webview: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            webview.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq
    for ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler
{
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface
    for ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler
{
    type Vtable = ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x02fab84b_1428_4fb7_ad45_1b2e64736184);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        webview: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CreateCoreWebView2ControllerCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2CreateCoreWebView2ControllerCompletedHandler {
    pub unsafe fn Invoke<'a, Param1: ::windows::core::IntoParam<'a, ICoreWebView2Controller>>(
        &self,
        errorcode: ::windows::core::HRESULT,
        createdcontroller: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            createdcontroller.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2CreateCoreWebView2ControllerCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2CreateCoreWebView2ControllerCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CreateCoreWebView2ControllerCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CreateCoreWebView2ControllerCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CreateCoreWebView2ControllerCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CreateCoreWebView2ControllerCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CreateCoreWebView2ControllerCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2CreateCoreWebView2ControllerCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CreateCoreWebView2ControllerCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface
    for ICoreWebView2CreateCoreWebView2ControllerCompletedHandler
{
    type Vtable = ICoreWebView2CreateCoreWebView2ControllerCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x6c4819f3_c9b7_4260_8127_c9f5bde7f68c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CreateCoreWebView2ControllerCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        createdcontroller: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler {
    pub unsafe fn Invoke<'a, Param1: ::windows::core::IntoParam<'a, ICoreWebView2Environment>>(
        &self,
        errorcode: ::windows::core::HRESULT,
        createdenvironment: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            createdenvironment.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface
    for ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandler
{
    type Vtable = ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x4e8a3389_c9d8_4bd2_b6b5_124fee6cc14d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CreateCoreWebView2EnvironmentCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        createdenvironment: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2CursorChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2CursorChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2CompositionController>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2CursorChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2CursorChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2CursorChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2CursorChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2CursorChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2CursorChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2CursorChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2CursorChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2CursorChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2CursorChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2CursorChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2CursorChangedEventHandler {
    type Vtable = ICoreWebView2CursorChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x9da43ccc_26e1_4dad_b56c_d8961c94c571);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2CursorChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2DOMContentLoadedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2DOMContentLoadedEventArgs {
    pub unsafe fn NavigationId(&self, navigationid: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(navigationid),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DOMContentLoadedEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2DOMContentLoadedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DOMContentLoadedEventArgs> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2DOMContentLoadedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DOMContentLoadedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DOMContentLoadedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DOMContentLoadedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DOMContentLoadedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DOMContentLoadedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2DOMContentLoadedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DOMContentLoadedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DOMContentLoadedEventArgs {
    type Vtable = ICoreWebView2DOMContentLoadedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x16b1e21a_c503_44f2_84c9_70aba5031283);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DOMContentLoadedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        navigationid: *mut u64,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2DOMContentLoadedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2DOMContentLoadedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2DOMContentLoadedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DOMContentLoadedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2DOMContentLoadedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DOMContentLoadedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2DOMContentLoadedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DOMContentLoadedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DOMContentLoadedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DOMContentLoadedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DOMContentLoadedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DOMContentLoadedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2DOMContentLoadedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DOMContentLoadedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DOMContentLoadedEventHandler {
    type Vtable = ICoreWebView2DOMContentLoadedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x4bac7e9c_199e_49ed_87ed_249303acf019);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DOMContentLoadedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2Deferral(::windows::core::IUnknown);
impl ICoreWebView2Deferral {
    pub unsafe fn Complete(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(::core::mem::transmute_copy(self)).ok()
    }
}
impl ::core::convert::From<ICoreWebView2Deferral> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Deferral) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Deferral> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Deferral) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Deferral {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Deferral {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Deferral {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Deferral {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Deferral {}
impl ::core::fmt::Debug for ICoreWebView2Deferral {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Deferral")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Deferral {
    type Vtable = ICoreWebView2DeferralVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xc10e7f7b_b585_46f0_a623_8befbf3e4ee0);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DeferralVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2DevToolsProtocolEventReceivedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2DevToolsProtocolEventReceivedEventArgs {
    pub unsafe fn ParameterObjectAsJson(
        &self,
        parameterobjectasjson: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(parameterobjectasjson),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DevToolsProtocolEventReceivedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2DevToolsProtocolEventReceivedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DevToolsProtocolEventReceivedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2DevToolsProtocolEventReceivedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DevToolsProtocolEventReceivedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DevToolsProtocolEventReceivedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DevToolsProtocolEventReceivedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DevToolsProtocolEventReceivedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DevToolsProtocolEventReceivedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2DevToolsProtocolEventReceivedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DevToolsProtocolEventReceivedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DevToolsProtocolEventReceivedEventArgs {
    type Vtable = ICoreWebView2DevToolsProtocolEventReceivedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x653c2959_bb3a_4377_8632_b58ada4e66c4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DevToolsProtocolEventReceivedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        parameterobjectasjson: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2DevToolsProtocolEventReceivedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2DevToolsProtocolEventReceivedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2DevToolsProtocolEventReceivedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DevToolsProtocolEventReceivedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2DevToolsProtocolEventReceivedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DevToolsProtocolEventReceivedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2DevToolsProtocolEventReceivedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DevToolsProtocolEventReceivedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DevToolsProtocolEventReceivedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DevToolsProtocolEventReceivedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DevToolsProtocolEventReceivedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DevToolsProtocolEventReceivedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2DevToolsProtocolEventReceivedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DevToolsProtocolEventReceivedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DevToolsProtocolEventReceivedEventHandler {
    type Vtable = ICoreWebView2DevToolsProtocolEventReceivedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe2fda4be_5456_406c_a261_3d452138362c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DevToolsProtocolEventReceivedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2DevToolsProtocolEventReceiver(::windows::core::IUnknown);
impl ICoreWebView2DevToolsProtocolEventReceiver {
    pub unsafe fn DevToolsProtocolEventReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DevToolsProtocolEventReceivedEventHandler>,
    >(
        &self,
        handler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDevToolsProtocolEventReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DevToolsProtocolEventReceiver>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2DevToolsProtocolEventReceiver) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DevToolsProtocolEventReceiver>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2DevToolsProtocolEventReceiver) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DevToolsProtocolEventReceiver
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DevToolsProtocolEventReceiver
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DevToolsProtocolEventReceiver {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DevToolsProtocolEventReceiver {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DevToolsProtocolEventReceiver {}
impl ::core::fmt::Debug for ICoreWebView2DevToolsProtocolEventReceiver {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DevToolsProtocolEventReceiver")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DevToolsProtocolEventReceiver {
    type Vtable = ICoreWebView2DevToolsProtocolEventReceiverVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xb32ca51a_8371_45e9_9317_af021d080367);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DevToolsProtocolEventReceiverVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2DocumentTitleChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2DocumentTitleChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DocumentTitleChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2DocumentTitleChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DocumentTitleChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2DocumentTitleChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DocumentTitleChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DocumentTitleChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DocumentTitleChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DocumentTitleChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DocumentTitleChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2DocumentTitleChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DocumentTitleChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DocumentTitleChangedEventHandler {
    type Vtable = ICoreWebView2DocumentTitleChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xf5f2b923_953e_4042_9f95_f3a118e1afd4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DocumentTitleChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2DownloadOperation(::windows::core::IUnknown);
impl ICoreWebView2DownloadOperation {
    pub unsafe fn BytesReceivedChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2BytesReceivedChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveBytesReceivedChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn EstimatedEndTimeChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2EstimatedEndTimeChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveEstimatedEndTimeChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn StateChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2StateChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveStateChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Uri(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn ContentDisposition(
        &self,
        contentdisposition: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(contentdisposition),
        )
        .ok()
    }
    pub unsafe fn MimeType(
        &self,
        mimetype: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(mimetype),
        )
        .ok()
    }
    pub unsafe fn TotalBytesToReceive(
        &self,
        totalbytestoreceive: *mut i64,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(totalbytestoreceive),
        )
        .ok()
    }
    pub unsafe fn BytesReceived(&self, bytesreceived: *mut i64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(bytesreceived),
        )
        .ok()
    }
    pub unsafe fn EstimatedEndTime(
        &self,
        estimatedendtime: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(estimatedendtime),
        )
        .ok()
    }
    pub unsafe fn ResultFilePath(
        &self,
        resultfilepath: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(resultfilepath),
        )
        .ok()
    }
    pub unsafe fn State(
        &self,
        downloadstate: *mut COREWEBVIEW2_DOWNLOAD_STATE,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(downloadstate),
        )
        .ok()
    }
    pub unsafe fn InterruptReason(
        &self,
        interruptreason: *mut COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(interruptreason),
        )
        .ok()
    }
    pub unsafe fn Cancel(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Pause(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn CanResume(
        &self,
        canresume: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(canresume),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DownloadOperation> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2DownloadOperation) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DownloadOperation> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2DownloadOperation) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DownloadOperation
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DownloadOperation
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DownloadOperation {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DownloadOperation {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DownloadOperation {}
impl ::core::fmt::Debug for ICoreWebView2DownloadOperation {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DownloadOperation")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DownloadOperation {
    type Vtable = ICoreWebView2DownloadOperationVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x3d6b6cf2_afe1_44c7_a995_c65117714336);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DownloadOperationVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , contentdisposition : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , mimetype : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , totalbytestoreceive : * mut i64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , bytesreceived : * mut i64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , estimatedendtime : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , resultfilepath : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , downloadstate : * mut COREWEBVIEW2_DOWNLOAD_STATE , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , interruptreason : * mut COREWEBVIEW2_DOWNLOAD_INTERRUPT_REASON , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , canresume : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2DownloadStartingEventArgs(::windows::core::IUnknown);
impl ICoreWebView2DownloadStartingEventArgs {
    pub unsafe fn DownloadOperation(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2DownloadOperation> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2DownloadOperation>(result__)
    }
    pub unsafe fn Cancel(
        &self,
        cancel: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cancel),
        )
        .ok()
    }
    pub unsafe fn SetCancel<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        cancel: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            cancel.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ResultFilePath(
        &self,
        resultfilepath: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(resultfilepath),
        )
        .ok()
    }
    pub unsafe fn SetResultFilePath<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        resultfilepath: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            resultfilepath.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Handled(
        &self,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(handled),
        )
        .ok()
    }
    pub unsafe fn SetHandled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        handled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            handled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetDeferral(&self) -> ::windows::core::Result<ICoreWebView2Deferral> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Deferral>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2DownloadStartingEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2DownloadStartingEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DownloadStartingEventArgs> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2DownloadStartingEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DownloadStartingEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DownloadStartingEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DownloadStartingEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DownloadStartingEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DownloadStartingEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2DownloadStartingEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DownloadStartingEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DownloadStartingEventArgs {
    type Vtable = ICoreWebView2DownloadStartingEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe99bbe21_43e9_4544_a732_282764eafa60);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DownloadStartingEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        downloadoperation: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        cancel: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        cancel: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        resultfilepath: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        resultfilepath: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        deferral: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2DownloadStartingEventHandler(::windows::core::IUnknown);
impl ICoreWebView2DownloadStartingEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2DownloadStartingEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2DownloadStartingEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2DownloadStartingEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2DownloadStartingEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2DownloadStartingEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2DownloadStartingEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2DownloadStartingEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2DownloadStartingEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2DownloadStartingEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2DownloadStartingEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2DownloadStartingEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2DownloadStartingEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2DownloadStartingEventHandler {
    type Vtable = ICoreWebView2DownloadStartingEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xefedc989_c396_41ca_83f7_07f845a55724);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2DownloadStartingEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2Environment(::windows::core::IUnknown);
impl ICoreWebView2Environment {
    pub unsafe fn CreateCoreWebView2Controller<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceResponse<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        content: Param0,
        statuscode: i32,
        reasonphrase: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
            ::core::mem::transmute(statuscode),
            reasonphrase.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn BrowserVersionString(
        &self,
        versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    pub unsafe fn NewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewBrowserVersionAvailableEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Environment> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Environment) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Environment) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Environment {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Environment {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Environment {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Environment {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Environment {}
impl ::core::fmt::Debug for ICoreWebView2Environment {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Environment")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Environment {
    type Vtable = ICoreWebView2EnvironmentVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xb96d755e_0319_4e92_a296_23436f46a1fc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2EnvironmentVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , content : :: windows :: core :: RawPtr , statuscode : i32 , reasonphrase : super::super::super::super::Windows::Win32::Foundation:: PWSTR , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , response : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , versioninfo : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Environment2(::windows::core::IUnknown);
impl ICoreWebView2Environment2 {
    pub unsafe fn CreateCoreWebView2Controller<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceResponse<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        content: Param0,
        statuscode: i32,
        reasonphrase: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
            ::core::mem::transmute(statuscode),
            reasonphrase.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn BrowserVersionString(
        &self,
        versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    pub unsafe fn NewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewBrowserVersionAvailableEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        method: Param1,
        postdata: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            method.into_param().abi(),
            postdata.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2Environment2> for ICoreWebView2Environment {
    fn from(value: ICoreWebView2Environment2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment2> for ICoreWebView2Environment {
    fn from(value: &ICoreWebView2Environment2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for ICoreWebView2Environment2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for &ICoreWebView2Environment2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment2> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Environment2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment2> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Environment2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Environment2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Environment2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Environment2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Environment2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Environment2 {}
impl ::core::fmt::Debug for ICoreWebView2Environment2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Environment2")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Environment2 {
    type Vtable = ICoreWebView2Environment2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x41f3632b_5ef4_404f_ad82_2d606c5a9a21);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Environment2Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , content : :: windows :: core :: RawPtr , statuscode : i32 , reasonphrase : super::super::super::super::Windows::Win32::Foundation:: PWSTR , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , response : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , versioninfo : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , method : super::super::super::super::Windows::Win32::Foundation:: PWSTR , postdata : :: windows :: core :: RawPtr , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , request : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Environment3(::windows::core::IUnknown);
impl ICoreWebView2Environment3 {
    pub unsafe fn CreateCoreWebView2Controller<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceResponse<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        content: Param0,
        statuscode: i32,
        reasonphrase: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
            ::core::mem::transmute(statuscode),
            reasonphrase.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn BrowserVersionString(
        &self,
        versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    pub unsafe fn NewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewBrowserVersionAvailableEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        method: Param1,
        postdata: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            method.into_param().abi(),
            postdata.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
    pub unsafe fn CreateCoreWebView2CompositionController<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler,
        >,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateCoreWebView2PointerInfo(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2PointerInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2PointerInfo>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2Environment3> for ICoreWebView2Environment2 {
    fn from(value: ICoreWebView2Environment3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment3> for ICoreWebView2Environment2 {
    fn from(value: &ICoreWebView2Environment3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for ICoreWebView2Environment3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for &ICoreWebView2Environment3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment3> for ICoreWebView2Environment {
    fn from(value: ICoreWebView2Environment3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment3> for ICoreWebView2Environment {
    fn from(value: &ICoreWebView2Environment3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for ICoreWebView2Environment3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for &ICoreWebView2Environment3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment3> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Environment3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment3> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Environment3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Environment3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Environment3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Environment3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Environment3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Environment3 {}
impl ::core::fmt::Debug for ICoreWebView2Environment3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Environment3")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Environment3 {
    type Vtable = ICoreWebView2Environment3Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x80a22ae3_be7c_4ce2_afe1_5a50056cdeeb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Environment3Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , content : :: windows :: core :: RawPtr , statuscode : i32 , reasonphrase : super::super::super::super::Windows::Win32::Foundation:: PWSTR , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , response : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , versioninfo : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , method : super::super::super::super::Windows::Win32::Foundation:: PWSTR , postdata : :: windows :: core :: RawPtr , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , request : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pointerinfo : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Environment4(::windows::core::IUnknown);
impl ICoreWebView2Environment4 {
    pub unsafe fn CreateCoreWebView2Controller<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceResponse<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        content: Param0,
        statuscode: i32,
        reasonphrase: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
            ::core::mem::transmute(statuscode),
            reasonphrase.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn BrowserVersionString(
        &self,
        versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    pub unsafe fn NewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewBrowserVersionAvailableEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        method: Param1,
        postdata: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            method.into_param().abi(),
            postdata.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
    pub unsafe fn CreateCoreWebView2CompositionController<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler,
        >,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateCoreWebView2PointerInfo(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2PointerInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2PointerInfo>(result__)
    }
    pub unsafe fn GetProviderForHwnd<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<::windows::core::IUnknown>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2Environment4> for ICoreWebView2Environment3 {
    fn from(value: ICoreWebView2Environment4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment4> for ICoreWebView2Environment3 {
    fn from(value: &ICoreWebView2Environment4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for &ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment4> for ICoreWebView2Environment2 {
    fn from(value: ICoreWebView2Environment4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment4> for ICoreWebView2Environment2 {
    fn from(value: &ICoreWebView2Environment4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for &ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment4> for ICoreWebView2Environment {
    fn from(value: ICoreWebView2Environment4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment4> for ICoreWebView2Environment {
    fn from(value: &ICoreWebView2Environment4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for &ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment4> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Environment4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment4> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Environment4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Environment4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Environment4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Environment4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Environment4 {}
impl ::core::fmt::Debug for ICoreWebView2Environment4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Environment4")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Environment4 {
    type Vtable = ICoreWebView2Environment4Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x20944379_6dcf_41d6_a0a0_abc0fc50de0d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Environment4Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , content : :: windows :: core :: RawPtr , statuscode : i32 , reasonphrase : super::super::super::super::Windows::Win32::Foundation:: PWSTR , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , response : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , versioninfo : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , method : super::super::super::super::Windows::Win32::Foundation:: PWSTR , postdata : :: windows :: core :: RawPtr , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , request : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pointerinfo : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hwnd : super::super::super::super::Windows::Win32::Foundation:: HWND , provider : * mut * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Environment5(::windows::core::IUnknown);
impl ICoreWebView2Environment5 {
    pub unsafe fn CreateCoreWebView2Controller<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceResponse<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        content: Param0,
        statuscode: i32,
        reasonphrase: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
            ::core::mem::transmute(statuscode),
            reasonphrase.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn BrowserVersionString(
        &self,
        versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    pub unsafe fn NewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewBrowserVersionAvailableEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        method: Param1,
        postdata: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            method.into_param().abi(),
            postdata.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
    pub unsafe fn CreateCoreWebView2CompositionController<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler,
        >,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateCoreWebView2PointerInfo(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2PointerInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2PointerInfo>(result__)
    }
    pub unsafe fn GetProviderForHwnd<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn BrowserProcessExited<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2BrowserProcessExitedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveBrowserProcessExited<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Environment5> for ICoreWebView2Environment4 {
    fn from(value: ICoreWebView2Environment5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment5> for ICoreWebView2Environment4 {
    fn from(value: &ICoreWebView2Environment5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment4> for ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment4> for &ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment5> for ICoreWebView2Environment3 {
    fn from(value: ICoreWebView2Environment5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment5> for ICoreWebView2Environment3 {
    fn from(value: &ICoreWebView2Environment5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for &ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment5> for ICoreWebView2Environment2 {
    fn from(value: ICoreWebView2Environment5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment5> for ICoreWebView2Environment2 {
    fn from(value: &ICoreWebView2Environment5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for &ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment5> for ICoreWebView2Environment {
    fn from(value: ICoreWebView2Environment5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment5> for ICoreWebView2Environment {
    fn from(value: &ICoreWebView2Environment5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for &ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment5> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Environment5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment5> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Environment5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Environment5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Environment5 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Environment5 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Environment5 {}
impl ::core::fmt::Debug for ICoreWebView2Environment5 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Environment5")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Environment5 {
    type Vtable = ICoreWebView2Environment5Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x319e423d_e0d7_4b8d_9254_ae9475de9b17);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Environment5Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , content : :: windows :: core :: RawPtr , statuscode : i32 , reasonphrase : super::super::super::super::Windows::Win32::Foundation:: PWSTR , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , response : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , versioninfo : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , method : super::super::super::super::Windows::Win32::Foundation:: PWSTR , postdata : :: windows :: core :: RawPtr , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , request : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pointerinfo : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hwnd : super::super::super::super::Windows::Win32::Foundation:: HWND , provider : * mut * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Environment6(::windows::core::IUnknown);
impl ICoreWebView2Environment6 {
    pub unsafe fn CreateCoreWebView2Controller<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceResponse<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        content: Param0,
        statuscode: i32,
        reasonphrase: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
            ::core::mem::transmute(statuscode),
            reasonphrase.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn BrowserVersionString(
        &self,
        versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    pub unsafe fn NewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewBrowserVersionAvailableEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        method: Param1,
        postdata: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            method.into_param().abi(),
            postdata.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
    pub unsafe fn CreateCoreWebView2CompositionController<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler,
        >,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateCoreWebView2PointerInfo(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2PointerInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2PointerInfo>(result__)
    }
    pub unsafe fn GetProviderForHwnd<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn BrowserProcessExited<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2BrowserProcessExitedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveBrowserProcessExited<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreatePrintSettings(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2PrintSettings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2PrintSettings>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2Environment6> for ICoreWebView2Environment5 {
    fn from(value: ICoreWebView2Environment6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment6> for ICoreWebView2Environment5 {
    fn from(value: &ICoreWebView2Environment6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment5> for ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment5> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment5> for &ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment5> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment6> for ICoreWebView2Environment4 {
    fn from(value: ICoreWebView2Environment6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment6> for ICoreWebView2Environment4 {
    fn from(value: &ICoreWebView2Environment6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment4> for ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment4> for &ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment6> for ICoreWebView2Environment3 {
    fn from(value: ICoreWebView2Environment6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment6> for ICoreWebView2Environment3 {
    fn from(value: &ICoreWebView2Environment6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for &ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment6> for ICoreWebView2Environment2 {
    fn from(value: ICoreWebView2Environment6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment6> for ICoreWebView2Environment2 {
    fn from(value: &ICoreWebView2Environment6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for &ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment6> for ICoreWebView2Environment {
    fn from(value: ICoreWebView2Environment6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment6> for ICoreWebView2Environment {
    fn from(value: &ICoreWebView2Environment6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for &ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment6> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Environment6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment6> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Environment6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Environment6 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Environment6 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Environment6 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Environment6 {}
impl ::core::fmt::Debug for ICoreWebView2Environment6 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Environment6")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Environment6 {
    type Vtable = ICoreWebView2Environment6Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe59ee362_acbd_4857_9a8e_d3644d9459a9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Environment6Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , content : :: windows :: core :: RawPtr , statuscode : i32 , reasonphrase : super::super::super::super::Windows::Win32::Foundation:: PWSTR , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , response : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , versioninfo : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , method : super::super::super::super::Windows::Win32::Foundation:: PWSTR , postdata : :: windows :: core :: RawPtr , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , request : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pointerinfo : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hwnd : super::super::super::super::Windows::Win32::Foundation:: HWND , provider : * mut * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , printsettings : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Environment7(::windows::core::IUnknown);
impl ICoreWebView2Environment7 {
    pub unsafe fn CreateCoreWebView2Controller<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2CreateCoreWebView2ControllerCompletedHandler>,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceResponse<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        content: Param0,
        statuscode: i32,
        reasonphrase: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
            ::core::mem::transmute(statuscode),
            reasonphrase.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn BrowserVersionString(
        &self,
        versioninfo: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(versioninfo),
        )
        .ok()
    }
    pub unsafe fn NewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewBrowserVersionAvailableEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewBrowserVersionAvailable<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param3: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        method: Param1,
        postdata: Param2,
        headers: Param3,
    ) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            method.into_param().abi(),
            postdata.into_param().abi(),
            headers.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
    pub unsafe fn CreateCoreWebView2CompositionController<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2CreateCoreWebView2CompositionControllerCompletedHandler,
        >,
    >(
        &self,
        parentwindow: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            parentwindow.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreateCoreWebView2PointerInfo(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2PointerInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2PointerInfo>(result__)
    }
    pub unsafe fn GetProviderForHwnd<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::HWND,
        >,
    >(
        &self,
        hwnd: Param0,
    ) -> ::windows::core::Result<::windows::core::IUnknown> {
        let mut result__: *mut ::core::ffi::c_void = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            hwnd.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<::windows::core::IUnknown>(result__)
    }
    pub unsafe fn BrowserProcessExited<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2BrowserProcessExitedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveBrowserProcessExited<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CreatePrintSettings(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2PrintSettings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2PrintSettings>(result__)
    }
    pub unsafe fn UserDataFolder(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Environment7> for ICoreWebView2Environment6 {
    fn from(value: ICoreWebView2Environment7) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment7> for ICoreWebView2Environment6 {
    fn from(value: &ICoreWebView2Environment7) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment6> for ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment6> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment6> for &ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment6> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment7> for ICoreWebView2Environment5 {
    fn from(value: ICoreWebView2Environment7) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment7> for ICoreWebView2Environment5 {
    fn from(value: &ICoreWebView2Environment7) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment5> for ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment5> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment5> for &ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment5> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment7> for ICoreWebView2Environment4 {
    fn from(value: ICoreWebView2Environment7) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment7> for ICoreWebView2Environment4 {
    fn from(value: &ICoreWebView2Environment7) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment4> for ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment4> for &ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment7> for ICoreWebView2Environment3 {
    fn from(value: ICoreWebView2Environment7) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment7> for ICoreWebView2Environment3 {
    fn from(value: &ICoreWebView2Environment7) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment3> for &ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment7> for ICoreWebView2Environment2 {
    fn from(value: ICoreWebView2Environment7) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment7> for ICoreWebView2Environment2 {
    fn from(value: &ICoreWebView2Environment7) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment2> for &ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment7> for ICoreWebView2Environment {
    fn from(value: ICoreWebView2Environment7) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment7> for ICoreWebView2Environment {
    fn from(value: &ICoreWebView2Environment7) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Environment> for &ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Environment> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Environment7> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Environment7) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Environment7> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Environment7) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Environment7 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Environment7 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Environment7 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Environment7 {}
impl ::core::fmt::Debug for ICoreWebView2Environment7 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Environment7")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Environment7 {
    type Vtable = ICoreWebView2Environment7Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x43c22296_3bbd_43a4_9c00_5c0df6dd29a2);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Environment7Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , content : :: windows :: core :: RawPtr , statuscode : i32 , reasonphrase : super::super::super::super::Windows::Win32::Foundation:: PWSTR , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , response : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , versioninfo : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , method : super::super::super::super::Windows::Win32::Foundation:: PWSTR , postdata : :: windows :: core :: RawPtr , headers : super::super::super::super::Windows::Win32::Foundation:: PWSTR , request : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , parentwindow : super::super::super::super::Windows::Win32::Foundation:: HWND , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pointerinfo : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hwnd : super::super::super::super::Windows::Win32::Foundation:: HWND , provider : * mut * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , printsettings : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2EnvironmentOptions(::windows::core::IUnknown);
impl ICoreWebView2EnvironmentOptions {
    pub unsafe fn AdditionalBrowserArguments(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetAdditionalBrowserArguments<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Language(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetLanguage<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn TargetCompatibleBrowserVersion(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetTargetCompatibleBrowserVersion<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AllowSingleSignOnUsingOSPrimaryAccount(
        &self,
        allow: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(allow),
        )
        .ok()
    }
    pub unsafe fn SetAllowSingleSignOnUsingOSPrimaryAccount<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        allow: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            allow.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2EnvironmentOptions> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2EnvironmentOptions) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2EnvironmentOptions> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2EnvironmentOptions) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2EnvironmentOptions
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2EnvironmentOptions
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2EnvironmentOptions {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2EnvironmentOptions {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2EnvironmentOptions {}
impl ::core::fmt::Debug for ICoreWebView2EnvironmentOptions {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2EnvironmentOptions")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2EnvironmentOptions {
    type Vtable = ICoreWebView2EnvironmentOptionsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x2fde08a8_1e9a_4766_8c05_95a9ceb9d1c5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2EnvironmentOptionsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        allow: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        allow: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2EstimatedEndTimeChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2EstimatedEndTimeChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DownloadOperation>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2EstimatedEndTimeChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2EstimatedEndTimeChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2EstimatedEndTimeChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2EstimatedEndTimeChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2EstimatedEndTimeChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2EstimatedEndTimeChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2EstimatedEndTimeChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2EstimatedEndTimeChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2EstimatedEndTimeChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2EstimatedEndTimeChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2EstimatedEndTimeChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2EstimatedEndTimeChangedEventHandler {
    type Vtable = ICoreWebView2EstimatedEndTimeChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x28f0d425_93fe_4e63_9f8d_2aeec6d3ba1e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2EstimatedEndTimeChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ExecuteScriptCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2ExecuteScriptCompletedHandler {
    pub unsafe fn Invoke<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        errorcode: ::windows::core::HRESULT,
        resultobjectasjson: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            resultobjectasjson.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ExecuteScriptCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2ExecuteScriptCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ExecuteScriptCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ExecuteScriptCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ExecuteScriptCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ExecuteScriptCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ExecuteScriptCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ExecuteScriptCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ExecuteScriptCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2ExecuteScriptCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ExecuteScriptCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ExecuteScriptCompletedHandler {
    type Vtable = ICoreWebView2ExecuteScriptCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x49511172_cc67_4bca_9923_137112f4c4cc);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ExecuteScriptCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        resultobjectasjson: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2FocusChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2FocusChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Controller>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2FocusChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2FocusChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FocusChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2FocusChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2FocusChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2FocusChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FocusChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FocusChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FocusChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2FocusChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FocusChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FocusChangedEventHandler {
    type Vtable = ICoreWebView2FocusChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x05ea24bd_6452_4926_9014_4b82b498135d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FocusChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2Frame(::windows::core::IUnknown);
impl ICoreWebView2Frame {
    pub unsafe fn Name(
        &self,
        name: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(name),
        )
        .ok()
    }
    pub unsafe fn NameChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FrameNameChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNameChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddHostObjectToScriptWithOrigins<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        object: *mut super::super::super::super::Windows::Win32::System::Com::VARIANT,
        originscount: u32,
        origins: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(object),
            ::core::mem::transmute(originscount),
            ::core::mem::transmute(origins),
        )
        .ok()
    }
    pub unsafe fn RemoveHostObjectFromScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Destroyed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FrameDestroyedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDestroyed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsDestroyed(
        &self,
        destroyed: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(destroyed),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Frame> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Frame) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Frame> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Frame) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Frame {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Frame {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Frame {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Frame {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Frame {}
impl ::core::fmt::Debug for ICoreWebView2Frame {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Frame").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Frame {
    type Vtable = ICoreWebView2FrameVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xf1131a5e_9ba9_11eb_a8b3_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , object : * mut super::super::super::super::Windows::Win32::System::Com:: VARIANT , originscount : u32 , origins : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , destroyed : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2FrameCreatedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2FrameCreatedEventArgs {
    pub unsafe fn Frame(&self) -> ::windows::core::Result<ICoreWebView2Frame> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Frame>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2FrameCreatedEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2FrameCreatedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FrameCreatedEventArgs> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2FrameCreatedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2FrameCreatedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2FrameCreatedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FrameCreatedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FrameCreatedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FrameCreatedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2FrameCreatedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FrameCreatedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FrameCreatedEventArgs {
    type Vtable = ICoreWebView2FrameCreatedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x4d6e7b5e_9baa_11eb_a8b3_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameCreatedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        frame: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2FrameCreatedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2FrameCreatedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2FrameCreatedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2FrameCreatedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2FrameCreatedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FrameCreatedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2FrameCreatedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2FrameCreatedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2FrameCreatedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FrameCreatedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FrameCreatedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FrameCreatedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2FrameCreatedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FrameCreatedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FrameCreatedEventHandler {
    type Vtable = ICoreWebView2FrameCreatedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x38059770_9baa_11eb_a8b3_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameCreatedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2FrameDestroyedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2FrameDestroyedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Frame>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2FrameDestroyedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2FrameDestroyedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FrameDestroyedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2FrameDestroyedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2FrameDestroyedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2FrameDestroyedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FrameDestroyedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FrameDestroyedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FrameDestroyedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2FrameDestroyedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FrameDestroyedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FrameDestroyedEventHandler {
    type Vtable = ICoreWebView2FrameDestroyedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x59dd7b4c_9baa_11eb_a8b3_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameDestroyedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2FrameInfo(::windows::core::IUnknown);
impl ICoreWebView2FrameInfo {
    pub unsafe fn Name(
        &self,
        name: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(name),
        )
        .ok()
    }
    pub unsafe fn Source(
        &self,
        source: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(source),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2FrameInfo> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2FrameInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FrameInfo> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2FrameInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2FrameInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2FrameInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FrameInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FrameInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FrameInfo {}
impl ::core::fmt::Debug for ICoreWebView2FrameInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FrameInfo")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FrameInfo {
    type Vtable = ICoreWebView2FrameInfoVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xda86b8a1_bdf3_4f11_9955_528cefa59727);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameInfoVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        source: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2FrameInfoCollection(::windows::core::IUnknown);
impl ICoreWebView2FrameInfoCollection {
    pub unsafe fn GetIterator(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2FrameInfoCollectionIterator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2FrameInfoCollectionIterator>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2FrameInfoCollection> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2FrameInfoCollection) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FrameInfoCollection> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2FrameInfoCollection) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2FrameInfoCollection
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2FrameInfoCollection
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FrameInfoCollection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FrameInfoCollection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FrameInfoCollection {}
impl ::core::fmt::Debug for ICoreWebView2FrameInfoCollection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FrameInfoCollection")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FrameInfoCollection {
    type Vtable = ICoreWebView2FrameInfoCollectionVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x8f834154_d38e_4d90_affb_6800a7272839);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameInfoCollectionVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iterator: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2FrameInfoCollectionIterator(::windows::core::IUnknown);
impl ICoreWebView2FrameInfoCollectionIterator {
    pub unsafe fn HasCurrent(
        &self,
        hascurrent: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(hascurrent),
        )
        .ok()
    }
    pub unsafe fn GetCurrent(&self) -> ::windows::core::Result<ICoreWebView2FrameInfo> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2FrameInfo>(result__)
    }
    pub unsafe fn MoveNext(
        &self,
        hasnext: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(hasnext),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2FrameInfoCollectionIterator> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2FrameInfoCollectionIterator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FrameInfoCollectionIterator>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2FrameInfoCollectionIterator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2FrameInfoCollectionIterator
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2FrameInfoCollectionIterator
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FrameInfoCollectionIterator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FrameInfoCollectionIterator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FrameInfoCollectionIterator {}
impl ::core::fmt::Debug for ICoreWebView2FrameInfoCollectionIterator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FrameInfoCollectionIterator")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FrameInfoCollectionIterator {
    type Vtable = ICoreWebView2FrameInfoCollectionIteratorVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x1bf89e2d_1b2b_4629_b28f_05099b41bb03);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameInfoCollectionIteratorVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        hascurrent: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        frameinfo: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        hasnext: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2FrameNameChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2FrameNameChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Frame>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2FrameNameChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2FrameNameChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2FrameNameChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2FrameNameChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2FrameNameChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2FrameNameChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2FrameNameChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2FrameNameChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2FrameNameChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2FrameNameChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2FrameNameChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2FrameNameChangedEventHandler {
    type Vtable = ICoreWebView2FrameNameChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x435c7dc8_9baa_11eb_a8b3_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2FrameNameChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2GetCookiesCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2GetCookiesCompletedHandler {
    pub unsafe fn Invoke<'a, Param1: ::windows::core::IntoParam<'a, ICoreWebView2CookieList>>(
        &self,
        result: ::windows::core::HRESULT,
        cookielist: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(result),
            cookielist.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2GetCookiesCompletedHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2GetCookiesCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2GetCookiesCompletedHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2GetCookiesCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2GetCookiesCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2GetCookiesCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2GetCookiesCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2GetCookiesCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2GetCookiesCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2GetCookiesCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2GetCookiesCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2GetCookiesCompletedHandler {
    type Vtable = ICoreWebView2GetCookiesCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x5a4f5069_5c15_47c3_8646_f4de1c116670);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2GetCookiesCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        result: ::windows::core::HRESULT,
        cookielist: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2HistoryChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2HistoryChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2HistoryChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2HistoryChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2HistoryChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2HistoryChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2HistoryChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2HistoryChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2HistoryChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2HistoryChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2HistoryChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2HistoryChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2HistoryChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2HistoryChangedEventHandler {
    type Vtable = ICoreWebView2HistoryChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xc79a420c_efd9_4058_9295_3e8b4bcab645);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2HistoryChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2HttpHeadersCollectionIterator(::windows::core::IUnknown);
impl ICoreWebView2HttpHeadersCollectionIterator {
    pub unsafe fn GetCurrentHeader(
        &self,
        name: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(name),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn HasCurrentHeader(
        &self,
        hascurrent: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(hascurrent),
        )
        .ok()
    }
    pub unsafe fn MoveNext(
        &self,
        hasnext: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(hasnext),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2HttpHeadersCollectionIterator>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2HttpHeadersCollectionIterator) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2HttpHeadersCollectionIterator>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2HttpHeadersCollectionIterator) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2HttpHeadersCollectionIterator
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2HttpHeadersCollectionIterator
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2HttpHeadersCollectionIterator {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2HttpHeadersCollectionIterator {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2HttpHeadersCollectionIterator {}
impl ::core::fmt::Debug for ICoreWebView2HttpHeadersCollectionIterator {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2HttpHeadersCollectionIterator")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2HttpHeadersCollectionIterator {
    type Vtable = ICoreWebView2HttpHeadersCollectionIteratorVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x0702fc30_f43b_47bb_ab52_a42cb552ad9f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2HttpHeadersCollectionIteratorVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        hascurrent: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        hasnext: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2HttpRequestHeaders(::windows::core::IUnknown);
impl ICoreWebView2HttpRequestHeaders {
    pub unsafe fn GetHeader<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn GetHeaders<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<ICoreWebView2HttpHeadersCollectionIterator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpHeadersCollectionIterator>(result__)
    }
    pub unsafe fn Contains<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        contains: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(contains),
        )
        .ok()
    }
    pub unsafe fn SetHeader<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        value: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveHeader<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetIterator(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2HttpHeadersCollectionIterator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpHeadersCollectionIterator>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2HttpRequestHeaders> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2HttpRequestHeaders) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2HttpRequestHeaders> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2HttpRequestHeaders) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2HttpRequestHeaders
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2HttpRequestHeaders
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2HttpRequestHeaders {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2HttpRequestHeaders {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2HttpRequestHeaders {}
impl ::core::fmt::Debug for ICoreWebView2HttpRequestHeaders {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2HttpRequestHeaders")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2HttpRequestHeaders {
    type Vtable = ICoreWebView2HttpRequestHeadersVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe86cac0e_5523_465c_b536_8fb9fc8c8c60);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2HttpRequestHeadersVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        iterator: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        contains: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        value: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iterator: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2HttpResponseHeaders(::windows::core::IUnknown);
impl ICoreWebView2HttpResponseHeaders {
    pub unsafe fn AppendHeader<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        value: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Contains<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        contains: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(contains),
        )
        .ok()
    }
    pub unsafe fn GetHeader<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn GetHeaders<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<ICoreWebView2HttpHeadersCollectionIterator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpHeadersCollectionIterator>(result__)
    }
    pub unsafe fn GetIterator(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2HttpHeadersCollectionIterator> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpHeadersCollectionIterator>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2HttpResponseHeaders> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2HttpResponseHeaders) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2HttpResponseHeaders> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2HttpResponseHeaders) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2HttpResponseHeaders
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2HttpResponseHeaders
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2HttpResponseHeaders {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2HttpResponseHeaders {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2HttpResponseHeaders {}
impl ::core::fmt::Debug for ICoreWebView2HttpResponseHeaders {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2HttpResponseHeaders")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2HttpResponseHeaders {
    type Vtable = ICoreWebView2HttpResponseHeadersVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x03c5ff5a_9b45_4a88_881c_89a9f328619c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2HttpResponseHeadersVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        value: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        contains: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        name: super::super::super::super::Windows::Win32::Foundation::PWSTR,
        iterator: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iterator: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2MoveFocusRequestedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2MoveFocusRequestedEventArgs {
    pub unsafe fn Reason(
        &self,
        reason: *mut COREWEBVIEW2_MOVE_FOCUS_REASON,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(reason),
        )
        .ok()
    }
    pub unsafe fn Handled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetHandled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2MoveFocusRequestedEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2MoveFocusRequestedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2MoveFocusRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2MoveFocusRequestedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2MoveFocusRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2MoveFocusRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2MoveFocusRequestedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2MoveFocusRequestedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2MoveFocusRequestedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2MoveFocusRequestedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2MoveFocusRequestedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2MoveFocusRequestedEventArgs {
    type Vtable = ICoreWebView2MoveFocusRequestedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x2d6aa13b_3839_4a15_92fc_d88b3c0d9c9d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2MoveFocusRequestedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        reason: *mut COREWEBVIEW2_MOVE_FOCUS_REASON,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2MoveFocusRequestedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2MoveFocusRequestedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Controller>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2MoveFocusRequestedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2MoveFocusRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2MoveFocusRequestedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2MoveFocusRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2MoveFocusRequestedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2MoveFocusRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2MoveFocusRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2MoveFocusRequestedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2MoveFocusRequestedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2MoveFocusRequestedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2MoveFocusRequestedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2MoveFocusRequestedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2MoveFocusRequestedEventHandler {
    type Vtable = ICoreWebView2MoveFocusRequestedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x69035451_6dc7_4cb8_9bce_b2bd70ad289f);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2MoveFocusRequestedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NavigationCompletedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2NavigationCompletedEventArgs {
    pub unsafe fn IsSuccess(
        &self,
        issuccess: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(issuccess),
        )
        .ok()
    }
    pub unsafe fn WebErrorStatus(
        &self,
        weberrorstatus: *mut COREWEBVIEW2_WEB_ERROR_STATUS,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(weberrorstatus),
        )
        .ok()
    }
    pub unsafe fn NavigationId(&self, navigationid: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(navigationid),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2NavigationCompletedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2NavigationCompletedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NavigationCompletedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NavigationCompletedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NavigationCompletedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NavigationCompletedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NavigationCompletedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NavigationCompletedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NavigationCompletedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2NavigationCompletedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NavigationCompletedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NavigationCompletedEventArgs {
    type Vtable = ICoreWebView2NavigationCompletedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x30d68b7d_20d9_4752_a9ca_ec8448fbb5c1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NavigationCompletedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        issuccess: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        weberrorstatus: *mut COREWEBVIEW2_WEB_ERROR_STATUS,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        navigationid: *mut u64,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NavigationCompletedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2NavigationCompletedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2NavigationCompletedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2NavigationCompletedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NavigationCompletedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NavigationCompletedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NavigationCompletedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NavigationCompletedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NavigationCompletedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NavigationCompletedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NavigationCompletedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2NavigationCompletedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NavigationCompletedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NavigationCompletedEventHandler {
    type Vtable = ICoreWebView2NavigationCompletedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xd33a35bf_1c49_4f98_93ab_006e0533fe1c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NavigationCompletedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NavigationStartingEventArgs(::windows::core::IUnknown);
impl ICoreWebView2NavigationStartingEventArgs {
    pub unsafe fn Uri(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn IsUserInitiated(
        &self,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isuserinitiated),
        )
        .ok()
    }
    pub unsafe fn IsRedirected(
        &self,
        isredirected: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isredirected),
        )
        .ok()
    }
    pub unsafe fn RequestHeaders(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2HttpRequestHeaders> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpRequestHeaders>(result__)
    }
    pub unsafe fn Cancel(
        &self,
        cancel: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cancel),
        )
        .ok()
    }
    pub unsafe fn SetCancel<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        cancel: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            cancel.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationId(&self, navigationid: *mut u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(navigationid),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2NavigationStartingEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2NavigationStartingEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NavigationStartingEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NavigationStartingEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NavigationStartingEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NavigationStartingEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NavigationStartingEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NavigationStartingEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NavigationStartingEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2NavigationStartingEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NavigationStartingEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NavigationStartingEventArgs {
    type Vtable = ICoreWebView2NavigationStartingEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x5b495469_e119_438a_9b18_7604f25f2e49);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NavigationStartingEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        isredirected: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        requestheaders: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        cancel: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        cancel: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        navigationid: *mut u64,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NavigationStartingEventHandler(::windows::core::IUnknown);
impl ICoreWebView2NavigationStartingEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2NavigationStartingEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2NavigationStartingEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NavigationStartingEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NavigationStartingEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NavigationStartingEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NavigationStartingEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NavigationStartingEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NavigationStartingEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NavigationStartingEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2NavigationStartingEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NavigationStartingEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NavigationStartingEventHandler {
    type Vtable = ICoreWebView2NavigationStartingEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x9adbe429_f36d_432b_9ddc_f8881fbd76e3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NavigationStartingEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NewBrowserVersionAvailableEventHandler(::windows::core::IUnknown);
impl ICoreWebView2NewBrowserVersionAvailableEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Environment>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2NewBrowserVersionAvailableEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2NewBrowserVersionAvailableEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NewBrowserVersionAvailableEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NewBrowserVersionAvailableEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NewBrowserVersionAvailableEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NewBrowserVersionAvailableEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NewBrowserVersionAvailableEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NewBrowserVersionAvailableEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NewBrowserVersionAvailableEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2NewBrowserVersionAvailableEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NewBrowserVersionAvailableEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NewBrowserVersionAvailableEventHandler {
    type Vtable = ICoreWebView2NewBrowserVersionAvailableEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xf9a2976e_d34e_44fc_adee_81b6b57ca914);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NewBrowserVersionAvailableEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NewWindowRequestedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2NewWindowRequestedEventArgs {
    pub unsafe fn Uri(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn SetNewWindow<'a, Param0: ::windows::core::IntoParam<'a, ICoreWebView2>>(
        &self,
        newwindow: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            newwindow.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NewWindow(&self) -> ::windows::core::Result<ICoreWebView2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2>(result__)
    }
    pub unsafe fn SetHandled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        handled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            handled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Handled(
        &self,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(handled),
        )
        .ok()
    }
    pub unsafe fn IsUserInitiated(
        &self,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isuserinitiated),
        )
        .ok()
    }
    pub unsafe fn GetDeferral(&self) -> ::windows::core::Result<ICoreWebView2Deferral> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Deferral>(result__)
    }
    pub unsafe fn WindowFeatures(&self) -> ::windows::core::Result<ICoreWebView2WindowFeatures> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WindowFeatures>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2NewWindowRequestedEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2NewWindowRequestedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NewWindowRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NewWindowRequestedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NewWindowRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NewWindowRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NewWindowRequestedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NewWindowRequestedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NewWindowRequestedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2NewWindowRequestedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NewWindowRequestedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NewWindowRequestedEventArgs {
    type Vtable = ICoreWebView2NewWindowRequestedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x34acb11c_fc37_4418_9132_f9c21d1eafb9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NewWindowRequestedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        newwindow: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        newwindow: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        deferral: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NewWindowRequestedEventArgs2(::windows::core::IUnknown);
impl ICoreWebView2NewWindowRequestedEventArgs2 {
    pub unsafe fn Uri(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn SetNewWindow<'a, Param0: ::windows::core::IntoParam<'a, ICoreWebView2>>(
        &self,
        newwindow: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            newwindow.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NewWindow(&self) -> ::windows::core::Result<ICoreWebView2> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2>(result__)
    }
    pub unsafe fn SetHandled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        handled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            handled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Handled(
        &self,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(handled),
        )
        .ok()
    }
    pub unsafe fn IsUserInitiated(
        &self,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isuserinitiated),
        )
        .ok()
    }
    pub unsafe fn GetDeferral(&self) -> ::windows::core::Result<ICoreWebView2Deferral> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Deferral>(result__)
    }
    pub unsafe fn WindowFeatures(&self) -> ::windows::core::Result<ICoreWebView2WindowFeatures> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WindowFeatures>(result__)
    }
    pub unsafe fn Name(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2NewWindowRequestedEventArgs2>
    for ICoreWebView2NewWindowRequestedEventArgs
{
    fn from(value: ICoreWebView2NewWindowRequestedEventArgs2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NewWindowRequestedEventArgs2>
    for ICoreWebView2NewWindowRequestedEventArgs
{
    fn from(value: &ICoreWebView2NewWindowRequestedEventArgs2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventArgs>
    for ICoreWebView2NewWindowRequestedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2NewWindowRequestedEventArgs> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventArgs>
    for &ICoreWebView2NewWindowRequestedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2NewWindowRequestedEventArgs> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2NewWindowRequestedEventArgs2>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2NewWindowRequestedEventArgs2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NewWindowRequestedEventArgs2>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NewWindowRequestedEventArgs2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NewWindowRequestedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NewWindowRequestedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NewWindowRequestedEventArgs2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NewWindowRequestedEventArgs2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NewWindowRequestedEventArgs2 {}
impl ::core::fmt::Debug for ICoreWebView2NewWindowRequestedEventArgs2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NewWindowRequestedEventArgs2")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NewWindowRequestedEventArgs2 {
    type Vtable = ICoreWebView2NewWindowRequestedEventArgs2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xbbc7baed_74c6_4c92_b63a_7f5aeae03de3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NewWindowRequestedEventArgs2Vtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        newwindow: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        newwindow: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        deferral: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2NewWindowRequestedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2NewWindowRequestedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2NewWindowRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2NewWindowRequestedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2NewWindowRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2NewWindowRequestedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2NewWindowRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2NewWindowRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2NewWindowRequestedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2NewWindowRequestedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2NewWindowRequestedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2NewWindowRequestedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2NewWindowRequestedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2NewWindowRequestedEventHandler {
    type Vtable = ICoreWebView2NewWindowRequestedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xd4c185fe_c81c_4989_97af_2d3fa7ab5651);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2NewWindowRequestedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2PermissionRequestedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2PermissionRequestedEventArgs {
    pub unsafe fn Uri(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn PermissionKind(
        &self,
        permissionkind: *mut COREWEBVIEW2_PERMISSION_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(permissionkind),
        )
        .ok()
    }
    pub unsafe fn IsUserInitiated(
        &self,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isuserinitiated),
        )
        .ok()
    }
    pub unsafe fn State(
        &self,
        state: *mut COREWEBVIEW2_PERMISSION_STATE,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(state),
        )
        .ok()
    }
    pub unsafe fn SetState(
        &self,
        state: COREWEBVIEW2_PERMISSION_STATE,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(state),
        )
        .ok()
    }
    pub unsafe fn GetDeferral(&self) -> ::windows::core::Result<ICoreWebView2Deferral> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Deferral>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2PermissionRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2PermissionRequestedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2PermissionRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2PermissionRequestedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2PermissionRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2PermissionRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2PermissionRequestedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2PermissionRequestedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2PermissionRequestedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2PermissionRequestedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2PermissionRequestedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2PermissionRequestedEventArgs {
    type Vtable = ICoreWebView2PermissionRequestedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x973ae2ef_ff18_4894_8fb2_3c758f046810);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2PermissionRequestedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        permissionkind: *mut COREWEBVIEW2_PERMISSION_KIND,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        isuserinitiated: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        state: *mut COREWEBVIEW2_PERMISSION_STATE,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        state: COREWEBVIEW2_PERMISSION_STATE,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        deferral: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2PermissionRequestedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2PermissionRequestedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2PermissionRequestedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2PermissionRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2PermissionRequestedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2PermissionRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2PermissionRequestedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2PermissionRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2PermissionRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2PermissionRequestedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2PermissionRequestedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2PermissionRequestedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2PermissionRequestedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2PermissionRequestedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2PermissionRequestedEventHandler {
    type Vtable = ICoreWebView2PermissionRequestedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x15e1c6a3_c72a_4df3_91d7_d097fbec6bfd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2PermissionRequestedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2PointerInfo(::windows::core::IUnknown);
impl ICoreWebView2PointerInfo {
    pub unsafe fn PointerKind(&self, pointerkind: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pointerkind),
        )
        .ok()
    }
    pub unsafe fn SetPointerKind(&self, pointerkind: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pointerkind),
        )
        .ok()
    }
    pub unsafe fn PointerId(&self, pointerid: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pointerid),
        )
        .ok()
    }
    pub unsafe fn SetPointerId(&self, pointerid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pointerid),
        )
        .ok()
    }
    pub unsafe fn FrameId(&self, frameid: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(frameid),
        )
        .ok()
    }
    pub unsafe fn SetFrameId(&self, frameid: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(frameid),
        )
        .ok()
    }
    pub unsafe fn PointerFlags(&self, pointerflags: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pointerflags),
        )
        .ok()
    }
    pub unsafe fn SetPointerFlags(&self, pointerflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pointerflags),
        )
        .ok()
    }
    pub unsafe fn PointerDeviceRect(
        &self,
        pointerdevicerect: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pointerdevicerect),
        )
        .ok()
    }
    pub unsafe fn SetPointerDeviceRect<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        pointerdevicerect: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            pointerdevicerect.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DisplayRect(
        &self,
        displayrect: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(displayrect),
        )
        .ok()
    }
    pub unsafe fn SetDisplayRect<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        displayrect: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            displayrect.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PixelLocation(
        &self,
        pixellocation: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pixellocation),
        )
        .ok()
    }
    pub unsafe fn SetPixelLocation<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::POINT,
        >,
    >(
        &self,
        pixellocation: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            pixellocation.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HimetricLocation(
        &self,
        himetriclocation: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(himetriclocation),
        )
        .ok()
    }
    pub unsafe fn SetHimetricLocation<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::POINT,
        >,
    >(
        &self,
        himetriclocation: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            himetriclocation.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PixelLocationRaw(
        &self,
        pixellocationraw: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pixellocationraw),
        )
        .ok()
    }
    pub unsafe fn SetPixelLocationRaw<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::POINT,
        >,
    >(
        &self,
        pixellocationraw: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            pixellocationraw.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HimetricLocationRaw(
        &self,
        himetriclocationraw: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(himetriclocationraw),
        )
        .ok()
    }
    pub unsafe fn SetHimetricLocationRaw<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::POINT,
        >,
    >(
        &self,
        himetriclocationraw: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            himetriclocationraw.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Time(&self, time: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(time),
        )
        .ok()
    }
    pub unsafe fn SetTime(&self, time: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(time),
        )
        .ok()
    }
    pub unsafe fn HistoryCount(&self, historycount: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(historycount),
        )
        .ok()
    }
    pub unsafe fn SetHistoryCount(&self, historycount: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(historycount),
        )
        .ok()
    }
    pub unsafe fn InputData(&self, inputdata: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(inputdata),
        )
        .ok()
    }
    pub unsafe fn SetInputData(&self, inputdata: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(inputdata),
        )
        .ok()
    }
    pub unsafe fn KeyStates(&self, keystates: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(keystates),
        )
        .ok()
    }
    pub unsafe fn SetKeyStates(&self, keystates: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(keystates),
        )
        .ok()
    }
    pub unsafe fn PerformanceCount(
        &self,
        performancecount: *mut u64,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(performancecount),
        )
        .ok()
    }
    pub unsafe fn SetPerformanceCount(&self, performancecount: u64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(performancecount),
        )
        .ok()
    }
    pub unsafe fn ButtonChangeKind(
        &self,
        buttonchangekind: *mut i32,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(buttonchangekind),
        )
        .ok()
    }
    pub unsafe fn SetButtonChangeKind(&self, buttonchangekind: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(buttonchangekind),
        )
        .ok()
    }
    pub unsafe fn PenFlags(&self, penflags: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penflags),
        )
        .ok()
    }
    pub unsafe fn SetPenFlags(&self, penflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penflags),
        )
        .ok()
    }
    pub unsafe fn PenMask(&self, penmask: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).37)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penmask),
        )
        .ok()
    }
    pub unsafe fn SetPenMask(&self, penmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penmask),
        )
        .ok()
    }
    pub unsafe fn PenPressure(&self, penpressure: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).39)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penpressure),
        )
        .ok()
    }
    pub unsafe fn SetPenPressure(&self, penpressure: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penpressure),
        )
        .ok()
    }
    pub unsafe fn PenRotation(&self, penrotation: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penrotation),
        )
        .ok()
    }
    pub unsafe fn SetPenRotation(&self, penrotation: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).42)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(penrotation),
        )
        .ok()
    }
    pub unsafe fn PenTiltX(&self, pentiltx: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pentiltx),
        )
        .ok()
    }
    pub unsafe fn SetPenTiltX(&self, pentiltx: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pentiltx),
        )
        .ok()
    }
    pub unsafe fn PenTiltY(&self, pentilty: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).45)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pentilty),
        )
        .ok()
    }
    pub unsafe fn SetPenTiltY(&self, pentilty: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pentilty),
        )
        .ok()
    }
    pub unsafe fn TouchFlags(&self, touchflags: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchflags),
        )
        .ok()
    }
    pub unsafe fn SetTouchFlags(&self, touchflags: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchflags),
        )
        .ok()
    }
    pub unsafe fn TouchMask(&self, touchmask: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchmask),
        )
        .ok()
    }
    pub unsafe fn SetTouchMask(&self, touchmask: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchmask),
        )
        .ok()
    }
    pub unsafe fn TouchContact(
        &self,
        touchcontact: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchcontact),
        )
        .ok()
    }
    pub unsafe fn SetTouchContact<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        touchcontact: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(
            ::core::mem::transmute_copy(self),
            touchcontact.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn TouchContactRaw(
        &self,
        touchcontactraw: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchcontactraw),
        )
        .ok()
    }
    pub unsafe fn SetTouchContactRaw<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::RECT,
        >,
    >(
        &self,
        touchcontactraw: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(
            ::core::mem::transmute_copy(self),
            touchcontactraw.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn TouchOrientation(
        &self,
        touchorientation: *mut u32,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchorientation),
        )
        .ok()
    }
    pub unsafe fn SetTouchOrientation(&self, touchorientation: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).56)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchorientation),
        )
        .ok()
    }
    pub unsafe fn TouchPressure(&self, touchpressure: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchpressure),
        )
        .ok()
    }
    pub unsafe fn SetTouchPressure(&self, touchpressure: u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(touchpressure),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2PointerInfo> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2PointerInfo) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2PointerInfo> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2PointerInfo) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2PointerInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2PointerInfo {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2PointerInfo {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2PointerInfo {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2PointerInfo {}
impl ::core::fmt::Debug for ICoreWebView2PointerInfo {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2PointerInfo")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2PointerInfo {
    type Vtable = ICoreWebView2PointerInfoVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe6995887_d10d_4f5d_9359_4ce46e4f96b9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2PointerInfoVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerkind: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerkind: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerid: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerid: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        frameid: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        frameid: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerflags: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerflags: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerdevicerect: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pointerdevicerect: super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        displayrect: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        displayrect: super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pixellocation: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pixellocation: super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        himetriclocation: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        himetriclocation: super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pixellocationraw: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pixellocationraw: super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        himetriclocationraw: *mut super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        himetriclocationraw: super::super::super::super::Windows::Win32::Foundation::POINT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        time: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        time: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        historycount: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        historycount: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        inputdata: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        inputdata: i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        keystates: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        keystates: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        performancecount: *mut u64,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        performancecount: u64,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        buttonchangekind: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        buttonchangekind: i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penflags: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penflags: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penmask: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penmask: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penpressure: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penpressure: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penrotation: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        penrotation: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pentiltx: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pentiltx: i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pentilty: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        pentilty: i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchflags: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchflags: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchmask: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchmask: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchcontact: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchcontact: super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchcontactraw: *mut super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchcontactraw: super::super::super::super::Windows::Win32::Foundation::RECT,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchorientation: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchorientation: u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchpressure: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        touchpressure: u32,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2PrintSettings(::windows::core::IUnknown);
impl ICoreWebView2PrintSettings {
    pub unsafe fn Orientation(
        &self,
        orientation: *mut COREWEBVIEW2_PRINT_ORIENTATION,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(orientation),
        )
        .ok()
    }
    pub unsafe fn SetOrientation(
        &self,
        orientation: COREWEBVIEW2_PRINT_ORIENTATION,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(orientation),
        )
        .ok()
    }
    pub unsafe fn ScaleFactor(&self, scalefactor: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(scalefactor),
        )
        .ok()
    }
    pub unsafe fn SetScaleFactor(&self, scalefactor: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(scalefactor),
        )
        .ok()
    }
    pub unsafe fn PageWidth(&self, pagewidth: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pagewidth),
        )
        .ok()
    }
    pub unsafe fn SetPageWidth(&self, pagewidth: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pagewidth),
        )
        .ok()
    }
    pub unsafe fn PageHeight(&self, pageheight: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pageheight),
        )
        .ok()
    }
    pub unsafe fn SetPageHeight(&self, pageheight: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(pageheight),
        )
        .ok()
    }
    pub unsafe fn MarginTop(&self, margintop: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(margintop),
        )
        .ok()
    }
    pub unsafe fn SetMarginTop(&self, margintop: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(margintop),
        )
        .ok()
    }
    pub unsafe fn MarginBottom(&self, marginbottom: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(marginbottom),
        )
        .ok()
    }
    pub unsafe fn SetMarginBottom(&self, marginbottom: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(marginbottom),
        )
        .ok()
    }
    pub unsafe fn MarginLeft(&self, marginleft: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(marginleft),
        )
        .ok()
    }
    pub unsafe fn SetMarginLeft(&self, marginleft: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(marginleft),
        )
        .ok()
    }
    pub unsafe fn MarginRight(&self, marginright: *mut f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(marginright),
        )
        .ok()
    }
    pub unsafe fn SetMarginRight(&self, marginright: f64) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(marginright),
        )
        .ok()
    }
    pub unsafe fn ShouldPrintBackgrounds(
        &self,
        shouldprintbackgrounds: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(shouldprintbackgrounds),
        )
        .ok()
    }
    pub unsafe fn SetShouldPrintBackgrounds<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        shouldprintbackgrounds: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            shouldprintbackgrounds.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ShouldPrintSelectionOnly(
        &self,
        shouldprintselectiononly: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(shouldprintselectiononly),
        )
        .ok()
    }
    pub unsafe fn SetShouldPrintSelectionOnly<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        shouldprintselectiononly: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            shouldprintselectiononly.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ShouldPrintHeaderAndFooter(
        &self,
        shouldprintheaderandfooter : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(shouldprintheaderandfooter),
        )
        .ok()
    }
    pub unsafe fn SetShouldPrintHeaderAndFooter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        shouldprintheaderandfooter: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            shouldprintheaderandfooter.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HeaderTitle(
        &self,
        headertitle: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(headertitle),
        )
        .ok()
    }
    pub unsafe fn SetHeaderTitle<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        headertitle: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            headertitle.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FooterUri(
        &self,
        footeruri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(footeruri),
        )
        .ok()
    }
    pub unsafe fn SetFooterUri<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        footeruri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            footeruri.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2PrintSettings> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2PrintSettings) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2PrintSettings> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2PrintSettings) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2PrintSettings {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2PrintSettings {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2PrintSettings {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2PrintSettings {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2PrintSettings {}
impl ::core::fmt::Debug for ICoreWebView2PrintSettings {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2PrintSettings")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2PrintSettings {
    type Vtable = ICoreWebView2PrintSettingsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x377f3721_c74e_48ca_8db1_df68e51d60e2);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2PrintSettingsVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , orientation : * mut COREWEBVIEW2_PRINT_ORIENTATION , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , orientation : COREWEBVIEW2_PRINT_ORIENTATION , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , scalefactor : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , scalefactor : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pagewidth : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pagewidth : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pageheight : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , pageheight : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , margintop : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , margintop : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , marginbottom : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , marginbottom : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , marginleft : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , marginleft : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , marginright : * mut f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , marginright : f64 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , shouldprintbackgrounds : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , shouldprintbackgrounds : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , shouldprintselectiononly : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , shouldprintselectiononly : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , shouldprintheaderandfooter : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , shouldprintheaderandfooter : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , headertitle : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , headertitle : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , footeruri : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , footeruri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2PrintToPdfCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2PrintToPdfCompletedHandler {
    pub unsafe fn Invoke<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        errorcode: ::windows::core::HRESULT,
        issuccessful: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            issuccessful.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2PrintToPdfCompletedHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2PrintToPdfCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2PrintToPdfCompletedHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2PrintToPdfCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2PrintToPdfCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2PrintToPdfCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2PrintToPdfCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2PrintToPdfCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2PrintToPdfCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2PrintToPdfCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2PrintToPdfCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2PrintToPdfCompletedHandler {
    type Vtable = ICoreWebView2PrintToPdfCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xccf1ef04_fd8e_4d5f_b2de_0983e41b8c36);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2PrintToPdfCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        issuccessful: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ProcessFailedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2ProcessFailedEventArgs {
    pub unsafe fn ProcessFailedKind(
        &self,
        processfailedkind: *mut COREWEBVIEW2_PROCESS_FAILED_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(processfailedkind),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ProcessFailedEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2ProcessFailedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ProcessFailedEventArgs> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2ProcessFailedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ProcessFailedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ProcessFailedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ProcessFailedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ProcessFailedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ProcessFailedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2ProcessFailedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ProcessFailedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ProcessFailedEventArgs {
    type Vtable = ICoreWebView2ProcessFailedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x8155a9a4_1474_4a86_8cae_151b0fa6b8ca);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ProcessFailedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        processfailedkind: *mut COREWEBVIEW2_PROCESS_FAILED_KIND,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ProcessFailedEventArgs2(::windows::core::IUnknown);
impl ICoreWebView2ProcessFailedEventArgs2 {
    pub unsafe fn ProcessFailedKind(
        &self,
        processfailedkind: *mut COREWEBVIEW2_PROCESS_FAILED_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(processfailedkind),
        )
        .ok()
    }
    pub unsafe fn Reason(
        &self,
        reason: *mut COREWEBVIEW2_PROCESS_FAILED_REASON,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(reason),
        )
        .ok()
    }
    pub unsafe fn ExitCode(&self, exitcode: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(exitcode),
        )
        .ok()
    }
    pub unsafe fn ProcessDescription(
        &self,
        processdescription: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(processdescription),
        )
        .ok()
    }
    pub unsafe fn FrameInfosForFailedProcess(
        &self,
    ) -> ::windows::core::Result<ICoreWebView2FrameInfoCollection> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2FrameInfoCollection>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2ProcessFailedEventArgs2>
    for ICoreWebView2ProcessFailedEventArgs
{
    fn from(value: ICoreWebView2ProcessFailedEventArgs2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ProcessFailedEventArgs2>
    for ICoreWebView2ProcessFailedEventArgs
{
    fn from(value: &ICoreWebView2ProcessFailedEventArgs2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventArgs>
    for ICoreWebView2ProcessFailedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2ProcessFailedEventArgs> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventArgs>
    for &ICoreWebView2ProcessFailedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2ProcessFailedEventArgs> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2ProcessFailedEventArgs2> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2ProcessFailedEventArgs2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ProcessFailedEventArgs2> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2ProcessFailedEventArgs2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ProcessFailedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ProcessFailedEventArgs2
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ProcessFailedEventArgs2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ProcessFailedEventArgs2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ProcessFailedEventArgs2 {}
impl ::core::fmt::Debug for ICoreWebView2ProcessFailedEventArgs2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ProcessFailedEventArgs2")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ProcessFailedEventArgs2 {
    type Vtable = ICoreWebView2ProcessFailedEventArgs2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x4dab9422_46fa_4c3e_a5d2_41d2071d3680);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ProcessFailedEventArgs2Vtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        processfailedkind: *mut COREWEBVIEW2_PROCESS_FAILED_KIND,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        reason: *mut COREWEBVIEW2_PROCESS_FAILED_REASON,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        exitcode: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        processdescription: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        frames: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ProcessFailedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2ProcessFailedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ProcessFailedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2ProcessFailedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ProcessFailedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2ProcessFailedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ProcessFailedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ProcessFailedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ProcessFailedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ProcessFailedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ProcessFailedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2ProcessFailedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ProcessFailedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ProcessFailedEventHandler {
    type Vtable = ICoreWebView2ProcessFailedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x79e0aea4_990b_42d9_aa1d_0fcc2e5bc7f1);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ProcessFailedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2RasterizationScaleChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2RasterizationScaleChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Controller>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2RasterizationScaleChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2RasterizationScaleChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2RasterizationScaleChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2RasterizationScaleChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2RasterizationScaleChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2RasterizationScaleChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2RasterizationScaleChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2RasterizationScaleChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2RasterizationScaleChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2RasterizationScaleChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2RasterizationScaleChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2RasterizationScaleChangedEventHandler {
    type Vtable = ICoreWebView2RasterizationScaleChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x9c98c8b1_ac53_427e_a345_3049b5524bbe);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2RasterizationScaleChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ScriptDialogOpeningEventArgs(::windows::core::IUnknown);
impl ICoreWebView2ScriptDialogOpeningEventArgs {
    pub unsafe fn Uri(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn Kind(
        &self,
        kind: *mut COREWEBVIEW2_SCRIPT_DIALOG_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(kind),
        )
        .ok()
    }
    pub unsafe fn Message(
        &self,
        message: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(message),
        )
        .ok()
    }
    pub unsafe fn Accept(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn DefaultText(
        &self,
        defaulttext: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(defaulttext),
        )
        .ok()
    }
    pub unsafe fn ResultText(
        &self,
        resulttext: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(resulttext),
        )
        .ok()
    }
    pub unsafe fn SetResultText<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        resulttext: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            resulttext.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetDeferral(&self) -> ::windows::core::Result<ICoreWebView2Deferral> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Deferral>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2ScriptDialogOpeningEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2ScriptDialogOpeningEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ScriptDialogOpeningEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ScriptDialogOpeningEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ScriptDialogOpeningEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ScriptDialogOpeningEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ScriptDialogOpeningEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ScriptDialogOpeningEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ScriptDialogOpeningEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2ScriptDialogOpeningEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ScriptDialogOpeningEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ScriptDialogOpeningEventArgs {
    type Vtable = ICoreWebView2ScriptDialogOpeningEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x7390bb70_abe0_4843_9529_f143b31b03d6);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ScriptDialogOpeningEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        kind: *mut COREWEBVIEW2_SCRIPT_DIALOG_KIND,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        message: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        defaulttext: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        resulttext: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        resulttext: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        deferral: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ScriptDialogOpeningEventHandler(::windows::core::IUnknown);
impl ICoreWebView2ScriptDialogOpeningEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ScriptDialogOpeningEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ScriptDialogOpeningEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2ScriptDialogOpeningEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ScriptDialogOpeningEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ScriptDialogOpeningEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ScriptDialogOpeningEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ScriptDialogOpeningEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ScriptDialogOpeningEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ScriptDialogOpeningEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ScriptDialogOpeningEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2ScriptDialogOpeningEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ScriptDialogOpeningEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ScriptDialogOpeningEventHandler {
    type Vtable = ICoreWebView2ScriptDialogOpeningEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xef381bf9_afa8_4e37_91c4_8ac48524bdfb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ScriptDialogOpeningEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2Settings(::windows::core::IUnknown);
impl ICoreWebView2Settings {
    pub unsafe fn IsScriptEnabled(
        &self,
        isscriptenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isscriptenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsScriptEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isscriptenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isscriptenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsWebMessageEnabled(
        &self,
        iswebmessageenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(iswebmessageenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsWebMessageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        iswebmessageenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            iswebmessageenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultScriptDialogsEnabled(
        &self,
        aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredefaultscriptdialogsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultScriptDialogsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredefaultscriptdialogsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            aredefaultscriptdialogsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsStatusBarEnabled(
        &self,
        isstatusbarenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isstatusbarenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsStatusBarEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isstatusbarenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            isstatusbarenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDevToolsEnabled(
        &self,
        aredevtoolsenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredevtoolsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDevToolsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredevtoolsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            aredevtoolsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultContextMenusEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultContextMenusEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreHostObjectsAllowed(
        &self,
        allowed: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(allowed),
        )
        .ok()
    }
    pub unsafe fn SetAreHostObjectsAllowed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        allowed: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            allowed.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsZoomControlEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsZoomControlEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsBuiltInErrorPageEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsBuiltInErrorPageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Settings> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Settings) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Settings) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Settings {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Settings {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Settings {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Settings {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Settings {}
impl ::core::fmt::Debug for ICoreWebView2Settings {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Settings")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Settings {
    type Vtable = ICoreWebView2SettingsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xe562e4f0_d7fa_43ac_8d71_c05150499f00);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2SettingsVtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Settings2(::windows::core::IUnknown);
impl ICoreWebView2Settings2 {
    pub unsafe fn IsScriptEnabled(
        &self,
        isscriptenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isscriptenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsScriptEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isscriptenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isscriptenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsWebMessageEnabled(
        &self,
        iswebmessageenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(iswebmessageenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsWebMessageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        iswebmessageenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            iswebmessageenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultScriptDialogsEnabled(
        &self,
        aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredefaultscriptdialogsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultScriptDialogsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredefaultscriptdialogsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            aredefaultscriptdialogsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsStatusBarEnabled(
        &self,
        isstatusbarenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isstatusbarenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsStatusBarEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isstatusbarenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            isstatusbarenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDevToolsEnabled(
        &self,
        aredevtoolsenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredevtoolsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDevToolsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredevtoolsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            aredevtoolsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultContextMenusEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultContextMenusEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreHostObjectsAllowed(
        &self,
        allowed: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(allowed),
        )
        .ok()
    }
    pub unsafe fn SetAreHostObjectsAllowed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        allowed: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            allowed.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsZoomControlEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsZoomControlEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsBuiltInErrorPageEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsBuiltInErrorPageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UserAgent(
        &self,
        useragent: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(useragent),
        )
        .ok()
    }
    pub unsafe fn SetUserAgent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        useragent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            useragent.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Settings2> for ICoreWebView2Settings {
    fn from(value: ICoreWebView2Settings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings2> for ICoreWebView2Settings {
    fn from(value: &ICoreWebView2Settings2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for ICoreWebView2Settings2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for &ICoreWebView2Settings2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings2> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Settings2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings2> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Settings2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Settings2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Settings2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Settings2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Settings2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Settings2 {}
impl ::core::fmt::Debug for ICoreWebView2Settings2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Settings2")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Settings2 {
    type Vtable = ICoreWebView2Settings2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xee9a0f68_f46c_4e32_ac23_ef8cac224d2a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Settings2Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Settings3(::windows::core::IUnknown);
impl ICoreWebView2Settings3 {
    pub unsafe fn IsScriptEnabled(
        &self,
        isscriptenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isscriptenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsScriptEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isscriptenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isscriptenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsWebMessageEnabled(
        &self,
        iswebmessageenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(iswebmessageenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsWebMessageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        iswebmessageenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            iswebmessageenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultScriptDialogsEnabled(
        &self,
        aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredefaultscriptdialogsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultScriptDialogsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredefaultscriptdialogsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            aredefaultscriptdialogsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsStatusBarEnabled(
        &self,
        isstatusbarenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isstatusbarenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsStatusBarEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isstatusbarenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            isstatusbarenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDevToolsEnabled(
        &self,
        aredevtoolsenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredevtoolsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDevToolsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredevtoolsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            aredevtoolsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultContextMenusEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultContextMenusEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreHostObjectsAllowed(
        &self,
        allowed: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(allowed),
        )
        .ok()
    }
    pub unsafe fn SetAreHostObjectsAllowed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        allowed: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            allowed.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsZoomControlEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsZoomControlEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsBuiltInErrorPageEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsBuiltInErrorPageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UserAgent(
        &self,
        useragent: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(useragent),
        )
        .ok()
    }
    pub unsafe fn SetUserAgent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        useragent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            useragent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreBrowserAcceleratorKeysEnabled(
        &self,
        arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(arebrowseracceleratorkeysenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreBrowserAcceleratorKeysEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        arebrowseracceleratorkeysenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            arebrowseracceleratorkeysenabled.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Settings3> for ICoreWebView2Settings2 {
    fn from(value: ICoreWebView2Settings3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings3> for ICoreWebView2Settings2 {
    fn from(value: &ICoreWebView2Settings3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for ICoreWebView2Settings3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for &ICoreWebView2Settings3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings3> for ICoreWebView2Settings {
    fn from(value: ICoreWebView2Settings3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings3> for ICoreWebView2Settings {
    fn from(value: &ICoreWebView2Settings3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for ICoreWebView2Settings3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for &ICoreWebView2Settings3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings3> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Settings3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings3> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Settings3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Settings3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Settings3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Settings3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Settings3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Settings3 {}
impl ::core::fmt::Debug for ICoreWebView2Settings3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Settings3")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Settings3 {
    type Vtable = ICoreWebView2Settings3Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xfdb5ab74_af33_4854_84f0_0a631deb5eba);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Settings3Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Settings4(::windows::core::IUnknown);
impl ICoreWebView2Settings4 {
    pub unsafe fn IsScriptEnabled(
        &self,
        isscriptenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isscriptenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsScriptEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isscriptenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isscriptenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsWebMessageEnabled(
        &self,
        iswebmessageenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(iswebmessageenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsWebMessageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        iswebmessageenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            iswebmessageenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultScriptDialogsEnabled(
        &self,
        aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredefaultscriptdialogsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultScriptDialogsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredefaultscriptdialogsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            aredefaultscriptdialogsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsStatusBarEnabled(
        &self,
        isstatusbarenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isstatusbarenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsStatusBarEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isstatusbarenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            isstatusbarenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDevToolsEnabled(
        &self,
        aredevtoolsenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredevtoolsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDevToolsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredevtoolsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            aredevtoolsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultContextMenusEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultContextMenusEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreHostObjectsAllowed(
        &self,
        allowed: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(allowed),
        )
        .ok()
    }
    pub unsafe fn SetAreHostObjectsAllowed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        allowed: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            allowed.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsZoomControlEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsZoomControlEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsBuiltInErrorPageEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsBuiltInErrorPageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UserAgent(
        &self,
        useragent: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(useragent),
        )
        .ok()
    }
    pub unsafe fn SetUserAgent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        useragent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            useragent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreBrowserAcceleratorKeysEnabled(
        &self,
        arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(arebrowseracceleratorkeysenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreBrowserAcceleratorKeysEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        arebrowseracceleratorkeysenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            arebrowseracceleratorkeysenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsPasswordAutosaveEnabled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetIsPasswordAutosaveEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsGeneralAutofillEnabled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetIsGeneralAutofillEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Settings4> for ICoreWebView2Settings3 {
    fn from(value: ICoreWebView2Settings4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings4> for ICoreWebView2Settings3 {
    fn from(value: &ICoreWebView2Settings4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings3> for ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings3> for &ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings4> for ICoreWebView2Settings2 {
    fn from(value: ICoreWebView2Settings4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings4> for ICoreWebView2Settings2 {
    fn from(value: &ICoreWebView2Settings4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for &ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings4> for ICoreWebView2Settings {
    fn from(value: ICoreWebView2Settings4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings4> for ICoreWebView2Settings {
    fn from(value: &ICoreWebView2Settings4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for &ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings4> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Settings4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings4> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Settings4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Settings4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Settings4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Settings4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Settings4 {}
impl ::core::fmt::Debug for ICoreWebView2Settings4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Settings4")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Settings4 {
    type Vtable = ICoreWebView2Settings4Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xcb56846c_4168_4d53_b04f_03b6d6796ff2);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Settings4Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Settings5(::windows::core::IUnknown);
impl ICoreWebView2Settings5 {
    pub unsafe fn IsScriptEnabled(
        &self,
        isscriptenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isscriptenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsScriptEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isscriptenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isscriptenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsWebMessageEnabled(
        &self,
        iswebmessageenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(iswebmessageenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsWebMessageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        iswebmessageenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            iswebmessageenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultScriptDialogsEnabled(
        &self,
        aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredefaultscriptdialogsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultScriptDialogsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredefaultscriptdialogsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            aredefaultscriptdialogsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsStatusBarEnabled(
        &self,
        isstatusbarenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isstatusbarenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsStatusBarEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isstatusbarenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            isstatusbarenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDevToolsEnabled(
        &self,
        aredevtoolsenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredevtoolsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDevToolsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredevtoolsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            aredevtoolsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultContextMenusEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultContextMenusEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreHostObjectsAllowed(
        &self,
        allowed: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(allowed),
        )
        .ok()
    }
    pub unsafe fn SetAreHostObjectsAllowed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        allowed: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            allowed.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsZoomControlEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsZoomControlEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsBuiltInErrorPageEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsBuiltInErrorPageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UserAgent(
        &self,
        useragent: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(useragent),
        )
        .ok()
    }
    pub unsafe fn SetUserAgent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        useragent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            useragent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreBrowserAcceleratorKeysEnabled(
        &self,
        arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(arebrowseracceleratorkeysenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreBrowserAcceleratorKeysEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        arebrowseracceleratorkeysenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            arebrowseracceleratorkeysenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsPasswordAutosaveEnabled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetIsPasswordAutosaveEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsGeneralAutofillEnabled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetIsGeneralAutofillEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsPinchZoomEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsPinchZoomEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Settings5> for ICoreWebView2Settings4 {
    fn from(value: ICoreWebView2Settings5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings5> for ICoreWebView2Settings4 {
    fn from(value: &ICoreWebView2Settings5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings4> for ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings4> for &ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings5> for ICoreWebView2Settings3 {
    fn from(value: ICoreWebView2Settings5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings5> for ICoreWebView2Settings3 {
    fn from(value: &ICoreWebView2Settings5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings3> for ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings3> for &ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings5> for ICoreWebView2Settings2 {
    fn from(value: ICoreWebView2Settings5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings5> for ICoreWebView2Settings2 {
    fn from(value: &ICoreWebView2Settings5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for &ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings5> for ICoreWebView2Settings {
    fn from(value: ICoreWebView2Settings5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings5> for ICoreWebView2Settings {
    fn from(value: &ICoreWebView2Settings5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for &ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings5> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Settings5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings5> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Settings5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Settings5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Settings5 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Settings5 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Settings5 {}
impl ::core::fmt::Debug for ICoreWebView2Settings5 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Settings5")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Settings5 {
    type Vtable = ICoreWebView2Settings5Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x183e7052_1d03_43a0_ab99_98e043b66b39);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Settings5Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2Settings6(::windows::core::IUnknown);
impl ICoreWebView2Settings6 {
    pub unsafe fn IsScriptEnabled(
        &self,
        isscriptenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isscriptenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsScriptEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isscriptenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            isscriptenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsWebMessageEnabled(
        &self,
        iswebmessageenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(iswebmessageenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsWebMessageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        iswebmessageenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            iswebmessageenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultScriptDialogsEnabled(
        &self,
        aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredefaultscriptdialogsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultScriptDialogsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredefaultscriptdialogsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            aredefaultscriptdialogsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsStatusBarEnabled(
        &self,
        isstatusbarenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isstatusbarenabled),
        )
        .ok()
    }
    pub unsafe fn SetIsStatusBarEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        isstatusbarenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            isstatusbarenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDevToolsEnabled(
        &self,
        aredevtoolsenabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(aredevtoolsenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDevToolsEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        aredevtoolsenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            aredevtoolsenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreDefaultContextMenusEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetAreDefaultContextMenusEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreHostObjectsAllowed(
        &self,
        allowed: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(allowed),
        )
        .ok()
    }
    pub unsafe fn SetAreHostObjectsAllowed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        allowed: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            allowed.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsZoomControlEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsZoomControlEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsBuiltInErrorPageEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsBuiltInErrorPageEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn UserAgent(
        &self,
        useragent: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(useragent),
        )
        .ok()
    }
    pub unsafe fn SetUserAgent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        useragent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            useragent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AreBrowserAcceleratorKeysEnabled(
        &self,
        arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(arebrowseracceleratorkeysenabled),
        )
        .ok()
    }
    pub unsafe fn SetAreBrowserAcceleratorKeysEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        arebrowseracceleratorkeysenabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            arebrowseracceleratorkeysenabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsPasswordAutosaveEnabled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetIsPasswordAutosaveEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsGeneralAutofillEnabled(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn SetIsGeneralAutofillEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        value: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            value.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsPinchZoomEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsPinchZoomEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn IsSwipeNavigationEnabled(
        &self,
        enabled: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(enabled),
        )
        .ok()
    }
    pub unsafe fn SetIsSwipeNavigationEnabled<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        enabled: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            enabled.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2Settings6> for ICoreWebView2Settings5 {
    fn from(value: ICoreWebView2Settings6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings6> for ICoreWebView2Settings5 {
    fn from(value: &ICoreWebView2Settings6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings5> for ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings5> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings5> for &ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings5> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings6> for ICoreWebView2Settings4 {
    fn from(value: ICoreWebView2Settings6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings6> for ICoreWebView2Settings4 {
    fn from(value: &ICoreWebView2Settings6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings4> for ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings4> for &ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings6> for ICoreWebView2Settings3 {
    fn from(value: ICoreWebView2Settings6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings6> for ICoreWebView2Settings3 {
    fn from(value: &ICoreWebView2Settings6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings3> for ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings3> for &ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings6> for ICoreWebView2Settings2 {
    fn from(value: ICoreWebView2Settings6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings6> for ICoreWebView2Settings2 {
    fn from(value: &ICoreWebView2Settings6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings2> for &ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings6> for ICoreWebView2Settings {
    fn from(value: ICoreWebView2Settings6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings6> for ICoreWebView2Settings {
    fn from(value: &ICoreWebView2Settings6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2Settings> for &ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2Settings> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2Settings6> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2Settings6) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2Settings6> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2Settings6) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2Settings6 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2Settings6 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2Settings6 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2Settings6 {}
impl ::core::fmt::Debug for ICoreWebView2Settings6 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2Settings6")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2Settings6 {
    type Vtable = ICoreWebView2Settings6Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x11cb3acd_9bc8_43b8_83bf_f40753714f87);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2Settings6Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isscriptenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iswebmessageenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredefaultscriptdialogsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , isstatusbarenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , aredevtoolsenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , allowed : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , useragent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , arebrowseracceleratorkeysenabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , enabled : super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2SourceChangedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2SourceChangedEventArgs {
    pub unsafe fn IsNewDocument(
        &self,
        isnewdocument: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(isnewdocument),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2SourceChangedEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2SourceChangedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2SourceChangedEventArgs> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2SourceChangedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2SourceChangedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2SourceChangedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2SourceChangedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2SourceChangedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2SourceChangedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2SourceChangedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2SourceChangedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2SourceChangedEventArgs {
    type Vtable = ICoreWebView2SourceChangedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x31e0e545_1dba_4266_8914_f63848a1f7d7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2SourceChangedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        isnewdocument: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2SourceChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2SourceChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2SourceChangedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2SourceChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2SourceChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2SourceChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2SourceChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2SourceChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2SourceChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2SourceChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2SourceChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2SourceChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2SourceChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2SourceChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2SourceChangedEventHandler {
    type Vtable = ICoreWebView2SourceChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x3c067f9f_5388_4772_8b48_79f7ef1ab37c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2SourceChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2StateChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2StateChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DownloadOperation>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2StateChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2StateChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2StateChangedEventHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2StateChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2StateChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2StateChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2StateChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2StateChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2StateChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2StateChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2StateChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2StateChangedEventHandler {
    type Vtable = ICoreWebView2StateChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x81336594_7ede_4ba9_bf71_acf0a95b58dd);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2StateChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2StringCollection(::windows::core::IUnknown);
impl ICoreWebView2StringCollection {
    pub unsafe fn Count(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn GetValueAtIndex(
        &self,
        index: u32,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(index),
            ::core::mem::transmute(value),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2StringCollection> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2StringCollection) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2StringCollection> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2StringCollection) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2StringCollection
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2StringCollection
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2StringCollection {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2StringCollection {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2StringCollection {}
impl ::core::fmt::Debug for ICoreWebView2StringCollection {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2StringCollection")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2StringCollection {
    type Vtable = ICoreWebView2StringCollectionVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xf41f3f8a_bcc3_11eb_8529_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2StringCollectionVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        index: u32,
        value: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2TrySuspendCompletedHandler(::windows::core::IUnknown);
impl ICoreWebView2TrySuspendCompletedHandler {
    pub unsafe fn Invoke<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::BOOL,
        >,
    >(
        &self,
        errorcode: ::windows::core::HRESULT,
        issuccessful: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            issuccessful.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2TrySuspendCompletedHandler> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2TrySuspendCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2TrySuspendCompletedHandler> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2TrySuspendCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2TrySuspendCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2TrySuspendCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2TrySuspendCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2TrySuspendCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2TrySuspendCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2TrySuspendCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2TrySuspendCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2TrySuspendCompletedHandler {
    type Vtable = ICoreWebView2TrySuspendCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x00f206a7_9d17_4605_91f6_4e8e4de192e3);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2TrySuspendCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        issuccessful: super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebMessageReceivedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2WebMessageReceivedEventArgs {
    pub unsafe fn Source(
        &self,
        source: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(source),
        )
        .ok()
    }
    pub unsafe fn WebMessageAsJson(
        &self,
        webmessageasjson: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(webmessageasjson),
        )
        .ok()
    }
    pub unsafe fn TryGetWebMessageAsString(
        &self,
        webmessageasstring: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(webmessageasstring),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebMessageReceivedEventArgs> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2WebMessageReceivedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebMessageReceivedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WebMessageReceivedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebMessageReceivedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebMessageReceivedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebMessageReceivedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebMessageReceivedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebMessageReceivedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2WebMessageReceivedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebMessageReceivedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebMessageReceivedEventArgs {
    type Vtable = ICoreWebView2WebMessageReceivedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x0f99a40c_e962_4207_9e92_e3d542eff849);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebMessageReceivedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        source: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        webmessageasjson: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        webmessageasstring: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebMessageReceivedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2WebMessageReceivedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2WebMessageReceivedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebMessageReceivedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2WebMessageReceivedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebMessageReceivedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WebMessageReceivedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebMessageReceivedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebMessageReceivedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebMessageReceivedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebMessageReceivedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebMessageReceivedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2WebMessageReceivedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebMessageReceivedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebMessageReceivedEventHandler {
    type Vtable = ICoreWebView2WebMessageReceivedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x57213f19_00e6_49fa_8e07_898ea01ecbd2);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebMessageReceivedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceRequest(::windows::core::IUnknown);
impl ICoreWebView2WebResourceRequest {
    pub unsafe fn Uri(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn SetUri<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Method(
        &self,
        method: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(method),
        )
        .ok()
    }
    pub unsafe fn SetMethod<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        method: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            method.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Content(
        &self,
    ) -> ::windows::core::Result<super::super::super::super::Windows::Win32::System::Com::IStream>
    {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<super::super::super::super::Windows::Win32::System::Com::IStream>(result__)
    }
    pub unsafe fn SetContent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
    >(
        &self,
        content: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Headers(&self) -> ::windows::core::Result<ICoreWebView2HttpRequestHeaders> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpRequestHeaders>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceRequest> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2WebResourceRequest) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceRequest> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2WebResourceRequest) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceRequest
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceRequest
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceRequest {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceRequest {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceRequest {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceRequest {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceRequest")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebResourceRequest {
    type Vtable = ICoreWebView2WebResourceRequestVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x97055cd4_512c_4264_8b5f_e3f446cea6a5);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceRequestVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        uri: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        method: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        method: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        content: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        content: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        headers: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceRequestedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2WebResourceRequestedEventArgs {
    pub unsafe fn Request(&self) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
    pub unsafe fn Response(&self) -> ::windows::core::Result<ICoreWebView2WebResourceResponse> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponse>(result__)
    }
    pub unsafe fn SetResponse<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceResponse>,
    >(
        &self,
        response: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            response.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn GetDeferral(&self) -> ::windows::core::Result<ICoreWebView2Deferral> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Deferral>(result__)
    }
    pub unsafe fn ResourceContext(
        &self,
        context: *mut COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(context),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2WebResourceRequestedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceRequestedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WebResourceRequestedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceRequestedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceRequestedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceRequestedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceRequestedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceRequestedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceRequestedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebResourceRequestedEventArgs {
    type Vtable = ICoreWebView2WebResourceRequestedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x453e667f_12c7_49d4_be6d_ddbe7956f57a);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceRequestedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        request: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        response: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        response: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        deferral: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        context: *mut COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceRequestedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2WebResourceRequestedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequestedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2WebResourceRequestedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WebResourceRequestedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceRequestedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceRequestedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceRequestedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceRequestedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceRequestedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebResourceRequestedEventHandler {
    type Vtable = ICoreWebView2WebResourceRequestedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xab00b74c_15f1_4646_80e8_e76341d25d71);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceRequestedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceResponse(::windows::core::IUnknown);
impl ICoreWebView2WebResourceResponse {
    pub unsafe fn Content(
        &self,
    ) -> ::windows::core::Result<super::super::super::super::Windows::Win32::System::Com::IStream>
    {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<super::super::super::super::Windows::Win32::System::Com::IStream>(result__)
    }
    pub unsafe fn SetContent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
    >(
        &self,
        content: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            content.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Headers(&self) -> ::windows::core::Result<ICoreWebView2HttpResponseHeaders> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpResponseHeaders>(result__)
    }
    pub unsafe fn StatusCode(&self, statuscode: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(statuscode),
        )
        .ok()
    }
    pub unsafe fn SetStatusCode(&self, statuscode: i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(statuscode),
        )
        .ok()
    }
    pub unsafe fn ReasonPhrase(
        &self,
        reasonphrase: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(reasonphrase),
        )
        .ok()
    }
    pub unsafe fn SetReasonPhrase<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        reasonphrase: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            reasonphrase.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceResponse> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2WebResourceResponse) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceResponse> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2WebResourceResponse) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceResponse
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceResponse
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceResponse {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceResponse {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceResponse {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceResponse {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceResponse")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebResourceResponse {
    type Vtable = ICoreWebView2WebResourceResponseVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xaafcc94f_fa27_48fd_97df_830ef75aaec9);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceResponseVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        content: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        content: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        headers: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        statuscode: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        statuscode: i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        reasonphrase: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        reasonphrase: super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceResponseReceivedEventArgs(::windows::core::IUnknown);
impl ICoreWebView2WebResourceResponseReceivedEventArgs {
    pub unsafe fn Request(&self) -> ::windows::core::Result<ICoreWebView2WebResourceRequest> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceRequest>(result__)
    }
    pub unsafe fn Response(&self) -> ::windows::core::Result<ICoreWebView2WebResourceResponseView> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2WebResourceResponseView>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceResponseReceivedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2WebResourceResponseReceivedEventArgs) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceResponseReceivedEventArgs>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WebResourceResponseReceivedEventArgs) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceResponseReceivedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceResponseReceivedEventArgs
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceResponseReceivedEventArgs {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceResponseReceivedEventArgs {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceResponseReceivedEventArgs {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceResponseReceivedEventArgs {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceResponseReceivedEventArgs")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebResourceResponseReceivedEventArgs {
    type Vtable = ICoreWebView2WebResourceResponseReceivedEventArgsVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xd1db483d_6796_4b8b_80fc_13712bb716f4);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceResponseReceivedEventArgsVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        request: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        response: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceResponseReceivedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2WebResourceResponseReceivedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceResponseReceivedEventArgs>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceResponseReceivedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2WebResourceResponseReceivedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceResponseReceivedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WebResourceResponseReceivedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceResponseReceivedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceResponseReceivedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceResponseReceivedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceResponseReceivedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceResponseReceivedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceResponseReceivedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceResponseReceivedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebResourceResponseReceivedEventHandler {
    type Vtable = ICoreWebView2WebResourceResponseReceivedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x7de9898a_24f5_40c3_a2de_d4f458e69828);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceResponseReceivedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceResponseView(::windows::core::IUnknown);
impl ICoreWebView2WebResourceResponseView {
    pub unsafe fn Headers(&self) -> ::windows::core::Result<ICoreWebView2HttpResponseHeaders> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2HttpResponseHeaders>(result__)
    }
    pub unsafe fn StatusCode(&self, statuscode: *mut i32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(statuscode),
        )
        .ok()
    }
    pub unsafe fn ReasonPhrase(
        &self,
        reasonphrase: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(reasonphrase),
        )
        .ok()
    }
    pub unsafe fn GetContent<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            ICoreWebView2WebResourceResponseViewGetContentCompletedHandler,
        >,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceResponseView> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2WebResourceResponseView) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceResponseView> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2WebResourceResponseView) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceResponseView
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceResponseView
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceResponseView {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceResponseView {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceResponseView {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceResponseView {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceResponseView")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WebResourceResponseView {
    type Vtable = ICoreWebView2WebResourceResponseViewVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x79701053_7759_4162_8f7d_f1b3f084928d);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceResponseViewVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        headers: *mut ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        statuscode: *mut i32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        reasonphrase: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        handler: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WebResourceResponseViewGetContentCompletedHandler(
    ::windows::core::IUnknown,
);
impl ICoreWebView2WebResourceResponseViewGetContentCompletedHandler {
    pub unsafe fn Invoke<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
    >(
        &self,
        errorcode: ::windows::core::HRESULT,
        content: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(errorcode),
            content.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WebResourceResponseViewGetContentCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2WebResourceResponseViewGetContentCompletedHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WebResourceResponseViewGetContentCompletedHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WebResourceResponseViewGetContentCompletedHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WebResourceResponseViewGetContentCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WebResourceResponseViewGetContentCompletedHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WebResourceResponseViewGetContentCompletedHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WebResourceResponseViewGetContentCompletedHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WebResourceResponseViewGetContentCompletedHandler {}
impl ::core::fmt::Debug for ICoreWebView2WebResourceResponseViewGetContentCompletedHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WebResourceResponseViewGetContentCompletedHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface
    for ICoreWebView2WebResourceResponseViewGetContentCompletedHandler
{
    type Vtable = ICoreWebView2WebResourceResponseViewGetContentCompletedHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x875738e1_9fa2_40e3_8b74_2e8972dd6fe7);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WebResourceResponseViewGetContentCompletedHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        errorcode: ::windows::core::HRESULT,
        content: ::windows::core::RawPtr,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WindowCloseRequestedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2WindowCloseRequestedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WindowCloseRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2WindowCloseRequestedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WindowCloseRequestedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2WindowCloseRequestedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2WindowCloseRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WindowCloseRequestedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WindowCloseRequestedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WindowCloseRequestedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WindowCloseRequestedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2WindowCloseRequestedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WindowCloseRequestedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WindowCloseRequestedEventHandler {
    type Vtable = ICoreWebView2WindowCloseRequestedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x5c19e9e0_092f_486b_affa_ca8231913039);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WindowCloseRequestedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2WindowFeatures(::windows::core::IUnknown);
impl ICoreWebView2WindowFeatures {
    pub unsafe fn HasPosition(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn HasSize(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn Left(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn Top(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn Height(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn Width(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn ShouldDisplayMenuBar(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn ShouldDisplayStatus(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn ShouldDisplayToolbar(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn ShouldDisplayScrollBars(
        &self,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2WindowFeatures> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2WindowFeatures) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2WindowFeatures> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2WindowFeatures) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2WindowFeatures {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2WindowFeatures
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2WindowFeatures {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2WindowFeatures {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2WindowFeatures {}
impl ::core::fmt::Debug for ICoreWebView2WindowFeatures {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2WindowFeatures")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2WindowFeatures {
    type Vtable = ICoreWebView2WindowFeaturesVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x5eaf559f_b46e_4397_8860_e422f287ff1e);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2WindowFeaturesVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut u32,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        value: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2ZoomFactorChangedEventHandler(::windows::core::IUnknown);
impl ICoreWebView2ZoomFactorChangedEventHandler {
    pub unsafe fn Invoke<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2Controller>,
        Param1: ::windows::core::IntoParam<'a, ::windows::core::IUnknown>,
    >(
        &self,
        sender: Param0,
        args: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            sender.into_param().abi(),
            args.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2ZoomFactorChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: ICoreWebView2ZoomFactorChangedEventHandler) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2ZoomFactorChangedEventHandler>
    for ::windows::core::IUnknown
{
    fn from(value: &ICoreWebView2ZoomFactorChangedEventHandler) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for ICoreWebView2ZoomFactorChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown>
    for &ICoreWebView2ZoomFactorChangedEventHandler
{
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2ZoomFactorChangedEventHandler {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2ZoomFactorChangedEventHandler {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2ZoomFactorChangedEventHandler {}
impl ::core::fmt::Debug for ICoreWebView2ZoomFactorChangedEventHandler {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2ZoomFactorChangedEventHandler")
            .field(&self.0)
            .finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2ZoomFactorChangedEventHandler {
    type Vtable = ICoreWebView2ZoomFactorChangedEventHandlerVtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xb52d71d6_c4df_4543_a90c_64a3e60f38cb);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2ZoomFactorChangedEventHandlerVtbl(
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        iid: &::windows::core::GUID,
        interface: *mut *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub unsafe extern "system" fn(this: *mut ::core::ffi::c_void) -> u32,
    pub  unsafe extern "system" fn(
        this: *mut ::core::ffi::c_void,
        sender: ::windows::core::RawPtr,
        args: *mut ::core::ffi::c_void,
    ) -> ::windows::core::HRESULT,
);
#[repr(transparent)]
pub struct ICoreWebView2_2(::windows::core::IUnknown);
impl ICoreWebView2_2 {
    pub unsafe fn Settings(&self) -> ::windows::core::Result<ICoreWebView2Settings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Settings>(result__)
    }
    pub unsafe fn Source(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn Navigate<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        htmlcontent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            htmlcontent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContentLoadingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2SourceChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveSourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2HistoryChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveHistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ScriptDialogOpeningEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2PermissionRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemovePermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler,
        >,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        id: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            id.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ExecuteScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ExecuteScriptCompletedHandler>,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CapturePreview<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CapturePreviewCompletedHandler>,
    >(
        &self,
        imageformat: COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT,
        imagestream: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(imageformat),
            imagestream.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Reload(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PostWebMessageAsJson<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasjson: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            webmessageasjson.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PostWebMessageAsString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasstring: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(
            ::core::mem::transmute_copy(self),
            webmessageasstring.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebMessageReceivedEventHandler>,
    >(
        &self,
        handler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CallDevToolsProtocolMethod<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CallDevToolsProtocolMethodCompletedHandler>,
    >(
        &self,
        methodname: Param0,
        parametersasjson: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(
            ::core::mem::transmute_copy(self),
            methodname.into_param().abi(),
            parametersasjson.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn BrowserProcessId(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).37)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn CanGoBack(
        &self,
        cangoback: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoback),
        )
        .ok()
    }
    pub unsafe fn CanGoForward(
        &self,
        cangoforward: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).39)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoforward),
        )
        .ok()
    }
    pub unsafe fn GoBack(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GoForward(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetDevToolsProtocolEventReceiver<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        eventname: Param0,
    ) -> ::windows::core::Result<ICoreWebView2DevToolsProtocolEventReceiver> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).42)(
            ::core::mem::transmute_copy(self),
            eventname.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2DevToolsProtocolEventReceiver>(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn NewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).45)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DocumentTitleChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitle(
        &self,
        title: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(title),
        )
        .ok()
    }
    pub unsafe fn AddHostObjectToScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        object: *mut super::super::super::super::Windows::Win32::System::Com::VARIANT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(object),
        )
        .ok()
    }
    pub unsafe fn RemoveHostObjectFromScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OpenDevToolsWindow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContainsFullScreenElementChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContainsFullScreenElement(
        &self,
        containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(containsfullscreenelement),
        )
        .ok()
    }
    pub unsafe fn WebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).56)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn WindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WindowCloseRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).60)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceResponseReceivedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).61)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).62)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateWithWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequest>,
    >(
        &self,
        request: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).63)(
            ::core::mem::transmute_copy(self),
            request.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DOMContentLoadedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).64)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).65)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CookieManager(&self) -> ::windows::core::Result<ICoreWebView2CookieManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).66)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2CookieManager>(result__)
    }
    pub unsafe fn Environment(&self) -> ::windows::core::Result<ICoreWebView2Environment> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).67)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Environment>(result__)
    }
}
impl ::core::convert::From<ICoreWebView2_2> for ICoreWebView2 {
    fn from(value: ICoreWebView2_2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_2> for ICoreWebView2 {
    fn from(value: &ICoreWebView2_2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for ICoreWebView2_2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for &ICoreWebView2_2 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_2> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2_2) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_2> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2_2) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2_2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2_2 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2_2 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2_2 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2_2 {}
impl ::core::fmt::Debug for ICoreWebView2_2 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2_2").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2_2 {
    type Vtable = ICoreWebView2_2Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x9e8f0cf8_e670_4b5e_b2bc_73e061e3184c);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2_2Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , settings : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , htmlcontent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , id : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , imageformat : COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT , imagestream : :: windows :: core :: RawPtr , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasstring : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , methodname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , parametersasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut u32 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoback : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoforward : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , receiver : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , title : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , object : * mut super::super::super::super::Windows::Win32::System::Com:: VARIANT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , request : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cookiemanager : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , environment : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2_3(::windows::core::IUnknown);
impl ICoreWebView2_3 {
    pub unsafe fn Settings(&self) -> ::windows::core::Result<ICoreWebView2Settings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Settings>(result__)
    }
    pub unsafe fn Source(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn Navigate<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        htmlcontent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            htmlcontent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContentLoadingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2SourceChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveSourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2HistoryChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveHistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ScriptDialogOpeningEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2PermissionRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemovePermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler,
        >,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        id: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            id.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ExecuteScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ExecuteScriptCompletedHandler>,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CapturePreview<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CapturePreviewCompletedHandler>,
    >(
        &self,
        imageformat: COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT,
        imagestream: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(imageformat),
            imagestream.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Reload(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PostWebMessageAsJson<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasjson: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            webmessageasjson.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PostWebMessageAsString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasstring: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(
            ::core::mem::transmute_copy(self),
            webmessageasstring.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebMessageReceivedEventHandler>,
    >(
        &self,
        handler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CallDevToolsProtocolMethod<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CallDevToolsProtocolMethodCompletedHandler>,
    >(
        &self,
        methodname: Param0,
        parametersasjson: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(
            ::core::mem::transmute_copy(self),
            methodname.into_param().abi(),
            parametersasjson.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn BrowserProcessId(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).37)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn CanGoBack(
        &self,
        cangoback: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoback),
        )
        .ok()
    }
    pub unsafe fn CanGoForward(
        &self,
        cangoforward: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).39)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoforward),
        )
        .ok()
    }
    pub unsafe fn GoBack(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GoForward(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetDevToolsProtocolEventReceiver<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        eventname: Param0,
    ) -> ::windows::core::Result<ICoreWebView2DevToolsProtocolEventReceiver> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).42)(
            ::core::mem::transmute_copy(self),
            eventname.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2DevToolsProtocolEventReceiver>(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn NewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).45)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DocumentTitleChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitle(
        &self,
        title: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(title),
        )
        .ok()
    }
    pub unsafe fn AddHostObjectToScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        object: *mut super::super::super::super::Windows::Win32::System::Com::VARIANT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(object),
        )
        .ok()
    }
    pub unsafe fn RemoveHostObjectFromScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OpenDevToolsWindow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContainsFullScreenElementChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContainsFullScreenElement(
        &self,
        containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(containsfullscreenelement),
        )
        .ok()
    }
    pub unsafe fn WebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).56)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn WindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WindowCloseRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).60)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceResponseReceivedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).61)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).62)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateWithWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequest>,
    >(
        &self,
        request: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).63)(
            ::core::mem::transmute_copy(self),
            request.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DOMContentLoadedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).64)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).65)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CookieManager(&self) -> ::windows::core::Result<ICoreWebView2CookieManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).66)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2CookieManager>(result__)
    }
    pub unsafe fn Environment(&self) -> ::windows::core::Result<ICoreWebView2Environment> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).67)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Environment>(result__)
    }
    pub unsafe fn TrySuspend<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2TrySuspendCompletedHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).68)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).69)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn IsSuspended(
        &self,
        issuspended: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).70)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(issuspended),
        )
        .ok()
    }
    pub unsafe fn SetVirtualHostNameToFolderMapping<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        hostname: Param0,
        folderpath: Param1,
        accesskind: COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).71)(
            ::core::mem::transmute_copy(self),
            hostname.into_param().abi(),
            folderpath.into_param().abi(),
            ::core::mem::transmute(accesskind),
        )
        .ok()
    }
    pub unsafe fn ClearVirtualHostNameToFolderMapping<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        hostname: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).72)(
            ::core::mem::transmute_copy(self),
            hostname.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2_3> for ICoreWebView2_2 {
    fn from(value: ICoreWebView2_3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_3> for ICoreWebView2_2 {
    fn from(value: &ICoreWebView2_3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_2> for ICoreWebView2_3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_2> for &ICoreWebView2_3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_3> for ICoreWebView2 {
    fn from(value: ICoreWebView2_3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_3> for ICoreWebView2 {
    fn from(value: &ICoreWebView2_3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for ICoreWebView2_3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for &ICoreWebView2_3 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_3> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2_3) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_3> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2_3) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2_3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2_3 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2_3 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2_3 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2_3 {}
impl ::core::fmt::Debug for ICoreWebView2_3 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2_3").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2_3 {
    type Vtable = ICoreWebView2_3Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xa0d6df20_3b92_416d_aa0c_437a9c727857);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2_3Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , settings : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , htmlcontent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , id : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , imageformat : COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT , imagestream : :: windows :: core :: RawPtr , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasstring : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , methodname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , parametersasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut u32 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoback : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoforward : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , receiver : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , title : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , object : * mut super::super::super::super::Windows::Win32::System::Com:: VARIANT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , request : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cookiemanager : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , environment : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , issuspended : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hostname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , folderpath : super::super::super::super::Windows::Win32::Foundation:: PWSTR , accesskind : COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hostname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2_4(::windows::core::IUnknown);
impl ICoreWebView2_4 {
    pub unsafe fn Settings(&self) -> ::windows::core::Result<ICoreWebView2Settings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Settings>(result__)
    }
    pub unsafe fn Source(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn Navigate<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        htmlcontent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            htmlcontent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContentLoadingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2SourceChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveSourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2HistoryChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveHistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ScriptDialogOpeningEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2PermissionRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemovePermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler,
        >,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        id: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            id.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ExecuteScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ExecuteScriptCompletedHandler>,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CapturePreview<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CapturePreviewCompletedHandler>,
    >(
        &self,
        imageformat: COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT,
        imagestream: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(imageformat),
            imagestream.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Reload(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PostWebMessageAsJson<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasjson: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            webmessageasjson.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PostWebMessageAsString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasstring: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(
            ::core::mem::transmute_copy(self),
            webmessageasstring.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebMessageReceivedEventHandler>,
    >(
        &self,
        handler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CallDevToolsProtocolMethod<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CallDevToolsProtocolMethodCompletedHandler>,
    >(
        &self,
        methodname: Param0,
        parametersasjson: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(
            ::core::mem::transmute_copy(self),
            methodname.into_param().abi(),
            parametersasjson.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn BrowserProcessId(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).37)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn CanGoBack(
        &self,
        cangoback: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoback),
        )
        .ok()
    }
    pub unsafe fn CanGoForward(
        &self,
        cangoforward: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).39)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoforward),
        )
        .ok()
    }
    pub unsafe fn GoBack(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GoForward(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetDevToolsProtocolEventReceiver<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        eventname: Param0,
    ) -> ::windows::core::Result<ICoreWebView2DevToolsProtocolEventReceiver> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).42)(
            ::core::mem::transmute_copy(self),
            eventname.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2DevToolsProtocolEventReceiver>(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn NewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).45)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DocumentTitleChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitle(
        &self,
        title: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(title),
        )
        .ok()
    }
    pub unsafe fn AddHostObjectToScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        object: *mut super::super::super::super::Windows::Win32::System::Com::VARIANT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(object),
        )
        .ok()
    }
    pub unsafe fn RemoveHostObjectFromScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OpenDevToolsWindow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContainsFullScreenElementChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContainsFullScreenElement(
        &self,
        containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(containsfullscreenelement),
        )
        .ok()
    }
    pub unsafe fn WebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).56)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn WindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WindowCloseRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).60)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceResponseReceivedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).61)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).62)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateWithWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequest>,
    >(
        &self,
        request: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).63)(
            ::core::mem::transmute_copy(self),
            request.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DOMContentLoadedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).64)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).65)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CookieManager(&self) -> ::windows::core::Result<ICoreWebView2CookieManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).66)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2CookieManager>(result__)
    }
    pub unsafe fn Environment(&self) -> ::windows::core::Result<ICoreWebView2Environment> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).67)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Environment>(result__)
    }
    pub unsafe fn TrySuspend<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2TrySuspendCompletedHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).68)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).69)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn IsSuspended(
        &self,
        issuspended: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).70)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(issuspended),
        )
        .ok()
    }
    pub unsafe fn SetVirtualHostNameToFolderMapping<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        hostname: Param0,
        folderpath: Param1,
        accesskind: COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).71)(
            ::core::mem::transmute_copy(self),
            hostname.into_param().abi(),
            folderpath.into_param().abi(),
            ::core::mem::transmute(accesskind),
        )
        .ok()
    }
    pub unsafe fn ClearVirtualHostNameToFolderMapping<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        hostname: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).72)(
            ::core::mem::transmute_copy(self),
            hostname.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameCreated<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FrameCreatedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).73)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).74)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DownloadStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DownloadStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).75)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDownloadStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).76)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2_4> for ICoreWebView2_3 {
    fn from(value: ICoreWebView2_4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_4> for ICoreWebView2_3 {
    fn from(value: &ICoreWebView2_4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_3> for ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_3> for &ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_4> for ICoreWebView2_2 {
    fn from(value: ICoreWebView2_4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_4> for ICoreWebView2_2 {
    fn from(value: &ICoreWebView2_4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_2> for ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_2> for &ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_4> for ICoreWebView2 {
    fn from(value: ICoreWebView2_4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_4> for ICoreWebView2 {
    fn from(value: &ICoreWebView2_4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for &ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_4> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2_4) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_4> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2_4) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2_4 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2_4 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2_4 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2_4 {}
impl ::core::fmt::Debug for ICoreWebView2_4 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2_4").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2_4 {
    type Vtable = ICoreWebView2_4Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0x20d02d59_6df2_42dc_bd06_f98a694b1302);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2_4Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , settings : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , htmlcontent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , id : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , imageformat : COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT , imagestream : :: windows :: core :: RawPtr , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasstring : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , methodname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , parametersasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut u32 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoback : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoforward : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , receiver : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , title : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , object : * mut super::super::super::super::Windows::Win32::System::Com:: VARIANT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , request : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cookiemanager : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , environment : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , issuspended : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hostname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , folderpath : super::super::super::super::Windows::Win32::Foundation:: PWSTR , accesskind : COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hostname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2_5(::windows::core::IUnknown);
impl ICoreWebView2_5 {
    pub unsafe fn Settings(&self) -> ::windows::core::Result<ICoreWebView2Settings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Settings>(result__)
    }
    pub unsafe fn Source(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn Navigate<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        htmlcontent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            htmlcontent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContentLoadingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2SourceChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveSourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2HistoryChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveHistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ScriptDialogOpeningEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2PermissionRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemovePermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler,
        >,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).27)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        id: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).28)(
            ::core::mem::transmute_copy(self),
            id.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ExecuteScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<'a, ICoreWebView2ExecuteScriptCompletedHandler>,
    >(
        &self,
        javascript: Param0,
        handler: Param1,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).29)(
            ::core::mem::transmute_copy(self),
            javascript.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CapturePreview<
        'a,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::Com::IStream,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CapturePreviewCompletedHandler>,
    >(
        &self,
        imageformat: COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT,
        imagestream: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).30)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(imageformat),
            imagestream.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Reload(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).31)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn PostWebMessageAsJson<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasjson: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).32)(
            ::core::mem::transmute_copy(self),
            webmessageasjson.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PostWebMessageAsString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        webmessageasstring: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).33)(
            ::core::mem::transmute_copy(self),
            webmessageasstring.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebMessageReceivedEventHandler>,
    >(
        &self,
        handler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).34)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebMessageReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).35)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CallDevToolsProtocolMethod<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param2: ::windows::core::IntoParam<'a, ICoreWebView2CallDevToolsProtocolMethodCompletedHandler>,
    >(
        &self,
        methodname: Param0,
        parametersasjson: Param1,
        handler: Param2,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).36)(
            ::core::mem::transmute_copy(self),
            methodname.into_param().abi(),
            parametersasjson.into_param().abi(),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn BrowserProcessId(&self, value: *mut u32) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).37)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(value),
        )
        .ok()
    }
    pub unsafe fn CanGoBack(
        &self,
        cangoback: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).38)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoback),
        )
        .ok()
    }
    pub unsafe fn CanGoForward(
        &self,
        cangoforward: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).39)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(cangoforward),
        )
        .ok()
    }
    pub unsafe fn GoBack(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).40)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GoForward(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).41)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn GetDevToolsProtocolEventReceiver<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        eventname: Param0,
    ) -> ::windows::core::Result<ICoreWebView2DevToolsProtocolEventReceiver> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).42)(
            ::core::mem::transmute_copy(self),
            eventname.into_param().abi(),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2DevToolsProtocolEventReceiver>(result__)
    }
    pub unsafe fn Stop(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).43)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn NewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NewWindowRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).44)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNewWindowRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).45)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DocumentTitleChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).46)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDocumentTitleChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).47)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DocumentTitle(
        &self,
        title: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).48)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(title),
        )
        .ok()
    }
    pub unsafe fn AddHostObjectToScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
        object: *mut super::super::super::super::Windows::Win32::System::Com::VARIANT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).49)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
            ::core::mem::transmute(object),
        )
        .ok()
    }
    pub unsafe fn RemoveHostObjectFromScript<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        name: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).50)(
            ::core::mem::transmute_copy(self),
            name.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn OpenDevToolsWindow(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).51)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn ContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContainsFullScreenElementChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).52)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContainsFullScreenElementChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).53)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContainsFullScreenElement(
        &self,
        containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).54)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(containsfullscreenelement),
        )
        .ok()
    }
    pub unsafe fn WebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).55)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).56)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).57)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceRequestedFilter<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
        resourcecontext: COREWEBVIEW2_WEB_RESOURCE_CONTEXT,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).58)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
            ::core::mem::transmute(resourcecontext),
        )
        .ok()
    }
    pub unsafe fn WindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WindowCloseRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).59)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWindowCloseRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).60)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn WebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceResponseReceivedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).61)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveWebResourceResponseReceived<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).62)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateWithWebResourceRequest<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2WebResourceRequest>,
    >(
        &self,
        request: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).63)(
            ::core::mem::transmute_copy(self),
            request.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DOMContentLoadedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).64)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDOMContentLoaded<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).65)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn CookieManager(&self) -> ::windows::core::Result<ICoreWebView2CookieManager> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).66)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2CookieManager>(result__)
    }
    pub unsafe fn Environment(&self) -> ::windows::core::Result<ICoreWebView2Environment> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).67)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Environment>(result__)
    }
    pub unsafe fn TrySuspend<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2TrySuspendCompletedHandler>,
    >(
        &self,
        handler: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).68)(
            ::core::mem::transmute_copy(self),
            handler.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn Resume(&self) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).69)(::core::mem::transmute_copy(self)).ok()
    }
    pub unsafe fn IsSuspended(
        &self,
        issuspended: *mut super::super::super::super::Windows::Win32::Foundation::BOOL,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).70)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(issuspended),
        )
        .ok()
    }
    pub unsafe fn SetVirtualHostNameToFolderMapping<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        hostname: Param0,
        folderpath: Param1,
        accesskind: COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).71)(
            ::core::mem::transmute_copy(self),
            hostname.into_param().abi(),
            folderpath.into_param().abi(),
            ::core::mem::transmute(accesskind),
        )
        .ok()
    }
    pub unsafe fn ClearVirtualHostNameToFolderMapping<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        hostname: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).72)(
            ::core::mem::transmute_copy(self),
            hostname.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameCreated<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2FrameCreatedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).73)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).74)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn DownloadStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2DownloadStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).75)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveDownloadStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).76)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ClientCertificateRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ClientCertificateRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).77)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveClientCertificateRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).78)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
}
impl ::core::convert::From<ICoreWebView2_5> for ICoreWebView2_4 {
    fn from(value: ICoreWebView2_5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_5> for ICoreWebView2_4 {
    fn from(value: &ICoreWebView2_5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_4> for ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_4> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_4> for &ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_4> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_5> for ICoreWebView2_3 {
    fn from(value: ICoreWebView2_5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_5> for ICoreWebView2_3 {
    fn from(value: &ICoreWebView2_5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_3> for ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_3> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_3> for &ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_3> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_5> for ICoreWebView2_2 {
    fn from(value: ICoreWebView2_5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_5> for ICoreWebView2_2 {
    fn from(value: &ICoreWebView2_5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_2> for ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2_2> for &ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2_2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_5> for ICoreWebView2 {
    fn from(value: ICoreWebView2_5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_5> for ICoreWebView2 {
    fn from(value: &ICoreWebView2_5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ICoreWebView2> for &ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ICoreWebView2> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::convert::From<ICoreWebView2_5> for ::windows::core::IUnknown {
    fn from(value: ICoreWebView2_5) -> Self {
        unsafe { ::core::mem::transmute(value) }
    }
}
impl ::core::convert::From<&ICoreWebView2_5> for ::windows::core::IUnknown {
    fn from(value: &ICoreWebView2_5) -> Self {
        ::core::convert::From::from(::core::clone::Clone::clone(value))
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Owned(unsafe { ::core::mem::transmute(self) })
    }
}
impl<'a> ::windows::core::IntoParam<'a, ::windows::core::IUnknown> for &ICoreWebView2_5 {
    fn into_param(self) -> ::windows::core::Param<'a, ::windows::core::IUnknown> {
        ::windows::core::Param::Borrowed(unsafe { ::core::mem::transmute(self) })
    }
}
impl ::core::clone::Clone for ICoreWebView2_5 {
    fn clone(&self) -> Self {
        Self(self.0.clone())
    }
}
impl ::core::cmp::PartialEq for ICoreWebView2_5 {
    fn eq(&self, other: &Self) -> bool {
        self.0 == other.0
    }
}
impl ::core::cmp::Eq for ICoreWebView2_5 {}
impl ::core::fmt::Debug for ICoreWebView2_5 {
    fn fmt(&self, f: &mut ::core::fmt::Formatter<'_>) -> ::core::fmt::Result {
        f.debug_tuple("ICoreWebView2_5").field(&self.0).finish()
    }
}
unsafe impl ::windows::core::Interface for ICoreWebView2_5 {
    type Vtable = ICoreWebView2_5Vtbl;
    const IID: ::windows::core::GUID =
        ::windows::core::GUID::from_u128(0xbedb11b8_d63c_11eb_b8bc_0242ac130003);
}
#[repr(C)]
#[doc(hidden)]
pub struct ICoreWebView2_5Vtbl ( pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , iid : & :: windows :: core :: GUID , interface : * mut * mut :: core :: ffi :: c_void ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void ) -> u32 , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , settings : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , htmlcontent : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , id : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , javascript : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , imageformat : COREWEBVIEW2_CAPTURE_PREVIEW_IMAGE_FORMAT , imagestream : :: windows :: core :: RawPtr , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , webmessageasstring : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , methodname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , parametersasjson : super::super::super::super::Windows::Win32::Foundation:: PWSTR , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , value : * mut u32 , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoback : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cangoforward : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , receiver : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , title : * mut super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , object : * mut super::super::super::super::Windows::Win32::System::Com:: VARIANT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , name : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , containsfullscreenelement : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , uri : super::super::super::super::Windows::Win32::Foundation:: PWSTR , resourcecontext : COREWEBVIEW2_WEB_RESOURCE_CONTEXT , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , request : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , cookiemanager : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , environment : * mut :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , handler : :: windows :: core :: RawPtr , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , issuspended : * mut super::super::super::super::Windows::Win32::Foundation:: BOOL , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hostname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , folderpath : super::super::super::super::Windows::Win32::Foundation:: PWSTR , accesskind : COREWEBVIEW2_HOST_RESOURCE_ACCESS_KIND , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , hostname : super::super::super::super::Windows::Win32::Foundation:: PWSTR , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , eventhandler : :: windows :: core :: RawPtr , token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , pub unsafe extern "system" fn ( this : * mut :: core :: ffi :: c_void , token : super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken , ) -> :: windows :: core :: HRESULT , ) where ;
#[repr(transparent)]
pub struct ICoreWebView2_6(::windows::core::IUnknown);
impl ICoreWebView2_6 {
    pub unsafe fn Settings(&self) -> ::windows::core::Result<ICoreWebView2Settings> {
        let mut result__: ::windows::core::RawPtr = ::core::mem::zeroed();
        (::windows::core::Interface::vtable(self).3)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(&mut result__),
        )
        .from_abi::<ICoreWebView2Settings>(result__)
    }
    pub unsafe fn Source(
        &self,
        uri: *mut super::super::super::super::Windows::Win32::Foundation::PWSTR,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).4)(
            ::core::mem::transmute_copy(self),
            ::core::mem::transmute(uri),
        )
        .ok()
    }
    pub unsafe fn Navigate<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        uri: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).5)(
            ::core::mem::transmute_copy(self),
            uri.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigateToString<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
    >(
        &self,
        htmlcontent: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).6)(
            ::core::mem::transmute_copy(self),
            htmlcontent.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).7)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).8)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ContentLoadingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).9)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveContentLoading<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).10)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn SourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2SourceChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).11)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveSourceChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).12)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn HistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2HistoryChangedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).13)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveHistoryChanged<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).14)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn NavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).15)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).16)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationStartingEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).17)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationStarting<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).18)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn FrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2NavigationCompletedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).19)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveFrameNavigationCompleted<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).20)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ScriptDialogOpeningEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).21)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveScriptDialogOpening<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).22)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn PermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2PermissionRequestedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).23)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemovePermissionRequested<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).24)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn ProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<'a, ICoreWebView2ProcessFailedEventHandler>,
    >(
        &self,
        eventhandler: Param0,
        token : * mut super::super::super::super::Windows::Win32::System::WinRT:: EventRegistrationToken,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).25)(
            ::core::mem::transmute_copy(self),
            eventhandler.into_param().abi(),
            ::core::mem::transmute(token),
        )
        .ok()
    }
    pub unsafe fn RemoveProcessFailed<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::System::WinRT::EventRegistrationToken,
        >,
    >(
        &self,
        token: Param0,
    ) -> ::windows::core::Result<()> {
        (::windows::core::Interface::vtable(self).26)(
            ::core::mem::transmute_copy(self),
            token.into_param().abi(),
        )
        .ok()
    }
    pub unsafe fn AddScriptToExecuteOnDocumentCreated<
        'a,
        Param0: ::windows::core::IntoParam<
            'a,
            super::super::super::super::Windows::Win32::Foundation::PWSTR,
        >,
        Param1: ::windows::core::IntoParam<
            'a,
            ICoreWebView2AddScriptToExecuteOnDocumentCreatedCompletedHandler,
        >,
    >