# webthing Changelog

## [Unreleased]

## [0.15.0] - 2022-03-07
### Added
- BaseActionGenerator to reduce boilerplate when creating a server which doesn't need actions
### Changed
- BaseThing and the Thing trait now support richer contexts
- Move to actix web 4

## [0.14.0] - 2021-01-05
### Added
- Parameter to disable host validation in server.

## [0.13.2] - 2020-12-29
### Changed
- Added libmdns::Service property called `dns_service` to WebThingServer
- Rust example publishes mDNS-SD (service discovery) correctly

## [0.13.1] - 2020-09-23
### Changed
- Update author and URLs to indicate new project home.

## [0.13.0] - 2020-09-16
### Changed
- Now using 2018 edition of Rust.
- Updated to modern version of actix-web.
- Server is now created and started with `.start()`; `.create()` is no longer present.
- Server no longer takes an optional router. Instead, an optional `configure` closure can be passed to `.start()`, which will be used via `App.configure(<your closure>)`.

## [0.12.4] - 2020-06-18
### Changed
- mDNS record now indicates TLS support.

## [0.12.3] - 2020-05-04
### Changed
- Invalid POST requests to action resources now generate an error status.

## [0.12.2] - 2020-03-27
### Changed
- Updated dependencies.

## [0.12.1] - 2019-11-07
### Changed
- Fixed deprecations.

## [0.12.0] - 2019-07-12
### Changed
- Things now use `title` rather than `name`.
- Things now require a unique ID in the form of a URI.
### Added
- Ability to set a base URL path on server.
- Support for `id`, `base`, `security`, and `securityDefinitions` keys in thing description.

## [0.11.0] - 2019-01-16
### Changed
- `WebThingServer::new()` can now take a configuration function which can add additional API routes.
### Fixed
- Properties could not include a custom `links` array at initialization.

## [0.10.3] - 2018-12-18
### Fixed
- SSL feature compilation.

## [0.10.2] - 2018-12-18
### Changed
- SSL is now an optional feature.

## [0.10.1] - 2018-12-13
### Changed
- Properties, actions, and events should now use `title` rather than `label`.

## [0.10.0] - 2018-11-30
### Changed
- Property, Action, and Event description now use `links` rather than `href`. - [Spec PR](https://github.com/WebThingsIO/wot/pull/119)

[Unreleased]: https://github.com/WebThingsIO/webthing-rust/compare/v0.15.0...HEAD
[0.15.0]: https://github.com/WebThingsIO/webthing-rust/compare/v0.14.0...v0.15.0
[0.14.0]: https://github.com/WebThingsIO/webthing-rust/compare/v0.13.2...v0.14.0
[0.13.2]: https://github.com/WebThingsIO/webthing-rust/compare/v0.13.1...v0.13.2
[0.13.1]: https://github.com/WebThingsIO/webthing-rust/compare/v0.13.0...v0.13.1
[0.13.0]: https://github.com/WebThingsIO/webthing-rust/compare/v0.12.4...v0.13.0
[0.12.4]: https://github.com/WebThingsIO/webthing-rust/compare/v0.12.3...v0.12.4
[0.12.3]: https://github.com/WebThingsIO/webthing-rust/compare/v0.12.2...v0.12.3
[0.12.2]: https://github.com/WebThingsIO/webthing-rust/compare/v0.12.1...v0.12.2
[0.12.1]: https://github.com/WebThingsIO/webthing-rust/compare/v0.12.0...v0.12.1
[0.12.0]: https://github.com/WebThingsIO/webthing-rust/compare/v0.11.0...v0.12.0
[0.11.0]: https://github.com/WebThingsIO/webthing-rust/compare/v0.10.3...v0.11.0
[0.10.3]: https://github.com/WebThingsIO/webthing-rust/compare/v0.10.2...v0.10.3
[0.10.2]: https://github.com/WebThingsIO/webthing-rust/compare/v0.10.1...v0.10.2
[0.10.1]: https://github.com/WebThingsIO/webthing-rust/compare/v0.10.0...v0.10.1
[0.10.0]: https://github.com/WebThingsIO/webthing-rust/compare/v0.9.3...v0.10.0
