use tokio::time;
use cs_trace::{Tracer, child};
use connection_utils::Channel;
use tokio::io::{AsyncWriteExt, AsyncReadExt};

pub async fn handle_channel_messages(
    trace: &Box<dyn Tracer>,
    mut channel: Box<dyn Channel>,
    source_name: &str,
    delay_seconds: u8,
) {
    let channel_trace = child!(trace, "messages");

    let mut buf = [0; 1024];
    loop {
        let message = format!("hey from {}", &source_name);
        channel
            .write(message.as_bytes())
            .await
            .expect("Cannot write initial message to the data channel.");
        // }

        let bytes_read = {
            channel
                .read(&mut buf)
                .await
                .expect("Cannot read from the data channel.")
        };

        let message_str = std::str::from_utf8(&buf[..bytes_read]).unwrap();

        channel_trace.info(
            &format!("\"{}\"", &message_str),
        );

        time::sleep(time::Duration::from_secs(delay_seconds as u64)).await;

        // if should_echo {

        //     let echo_message = format!("echo: {}", &message_str);

        //     channel
        //         .write(echo_message.as_bytes())
        //         .await
        //         .expect("Cannot write to the data channel.");
        // }
    }
}
