// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/tauri-apps/gir-files)
// DO NOT EDIT

use glib::error::ErrorDomain;
use glib::translate::*;
use glib::value::FromValue;
use glib::value::ToValue;
use glib::Quark;
use glib::StaticType;
use glib::Type;
use std::fmt;

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitAuthenticationScheme")]
pub enum AuthenticationScheme {
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_DEFAULT")]
  Default,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_HTTP_BASIC")]
  HttpBasic,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_HTTP_DIGEST")]
  HttpDigest,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_HTML_FORM")]
  HtmlForm,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_NTLM")]
  Ntlm,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_NEGOTIATE")]
  Negotiate,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_REQUESTED")]
  ClientCertificateRequested,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_SERVER_TRUST_EVALUATION_REQUESTED")]
  ServerTrustEvaluationRequested,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_PIN_REQUESTED")]
  ClientCertificatePinRequested,
  #[doc(alias = "WEBKIT_AUTHENTICATION_SCHEME_UNKNOWN")]
  Unknown,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl fmt::Display for AuthenticationScheme {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "AuthenticationScheme::{}",
      match *self {
        Self::Default => "Default",
        Self::HttpBasic => "HttpBasic",
        Self::HttpDigest => "HttpDigest",
        Self::HtmlForm => "HtmlForm",
        Self::Ntlm => "Ntlm",
        Self::Negotiate => "Negotiate",
        Self::ClientCertificateRequested => "ClientCertificateRequested",
        Self::ServerTrustEvaluationRequested => "ServerTrustEvaluationRequested",
        Self::ClientCertificatePinRequested => "ClientCertificatePinRequested",
        Self::Unknown => "Unknown",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
#[doc(hidden)]
impl IntoGlib for AuthenticationScheme {
  type GlibType = ffi::WebKitAuthenticationScheme;

  fn into_glib(self) -> ffi::WebKitAuthenticationScheme {
    match self {
      Self::Default => ffi::WEBKIT_AUTHENTICATION_SCHEME_DEFAULT,
      Self::HttpBasic => ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_BASIC,
      Self::HttpDigest => ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_DIGEST,
      Self::HtmlForm => ffi::WEBKIT_AUTHENTICATION_SCHEME_HTML_FORM,
      Self::Ntlm => ffi::WEBKIT_AUTHENTICATION_SCHEME_NTLM,
      Self::Negotiate => ffi::WEBKIT_AUTHENTICATION_SCHEME_NEGOTIATE,
      Self::ClientCertificateRequested => {
        ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_REQUESTED
      }
      Self::ServerTrustEvaluationRequested => {
        ffi::WEBKIT_AUTHENTICATION_SCHEME_SERVER_TRUST_EVALUATION_REQUESTED
      }
      Self::ClientCertificatePinRequested => {
        ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_PIN_REQUESTED
      }
      Self::Unknown => ffi::WEBKIT_AUTHENTICATION_SCHEME_UNKNOWN,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitAuthenticationScheme> for AuthenticationScheme {
  unsafe fn from_glib(value: ffi::WebKitAuthenticationScheme) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_AUTHENTICATION_SCHEME_DEFAULT => Self::Default,
      ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_BASIC => Self::HttpBasic,
      ffi::WEBKIT_AUTHENTICATION_SCHEME_HTTP_DIGEST => Self::HttpDigest,
      ffi::WEBKIT_AUTHENTICATION_SCHEME_HTML_FORM => Self::HtmlForm,
      ffi::WEBKIT_AUTHENTICATION_SCHEME_NTLM => Self::Ntlm,
      ffi::WEBKIT_AUTHENTICATION_SCHEME_NEGOTIATE => Self::Negotiate,
      ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_REQUESTED => {
        Self::ClientCertificateRequested
      }
      ffi::WEBKIT_AUTHENTICATION_SCHEME_SERVER_TRUST_EVALUATION_REQUESTED => {
        Self::ServerTrustEvaluationRequested
      }
      ffi::WEBKIT_AUTHENTICATION_SCHEME_CLIENT_CERTIFICATE_PIN_REQUESTED => {
        Self::ClientCertificatePinRequested
      }
      ffi::WEBKIT_AUTHENTICATION_SCHEME_UNKNOWN => Self::Unknown,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl StaticType for AuthenticationScheme {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_authentication_scheme_get_type()) }
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl glib::value::ValueType for AuthenticationScheme {
  type Type = Self;
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
unsafe impl<'a> FromValue<'a> for AuthenticationScheme {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl ToValue for AuthenticationScheme {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitAutomationBrowsingContextPresentation")]
pub enum AutomationBrowsingContextPresentation {
  #[doc(alias = "WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_WINDOW")]
  Window,
  #[doc(alias = "WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_TAB")]
  Tab,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl fmt::Display for AutomationBrowsingContextPresentation {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "AutomationBrowsingContextPresentation::{}",
      match *self {
        Self::Window => "Window",
        Self::Tab => "Tab",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[doc(hidden)]
impl IntoGlib for AutomationBrowsingContextPresentation {
  type GlibType = ffi::WebKitAutomationBrowsingContextPresentation;

  fn into_glib(self) -> ffi::WebKitAutomationBrowsingContextPresentation {
    match self {
      Self::Window => ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_WINDOW,
      Self::Tab => ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_TAB,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitAutomationBrowsingContextPresentation>
  for AutomationBrowsingContextPresentation
{
  unsafe fn from_glib(value: ffi::WebKitAutomationBrowsingContextPresentation) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_WINDOW => Self::Window,
      ffi::WEBKIT_AUTOMATION_BROWSING_CONTEXT_PRESENTATION_TAB => Self::Tab,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl StaticType for AutomationBrowsingContextPresentation {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_automation_browsing_context_presentation_get_type()) }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl glib::value::ValueType for AutomationBrowsingContextPresentation {
  type Type = Self;
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
unsafe impl<'a> FromValue<'a> for AutomationBrowsingContextPresentation {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl ToValue for AutomationBrowsingContextPresentation {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitAutoplayPolicy")]
pub enum AutoplayPolicy {
  #[doc(alias = "WEBKIT_AUTOPLAY_ALLOW")]
  Allow,
  #[doc(alias = "WEBKIT_AUTOPLAY_ALLOW_WITHOUT_SOUND")]
  AllowWithoutSound,
  #[doc(alias = "WEBKIT_AUTOPLAY_DENY")]
  Deny,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl fmt::Display for AutoplayPolicy {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "AutoplayPolicy::{}",
      match *self {
        Self::Allow => "Allow",
        Self::AllowWithoutSound => "AllowWithoutSound",
        Self::Deny => "Deny",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
#[doc(hidden)]
impl IntoGlib for AutoplayPolicy {
  type GlibType = ffi::WebKitAutoplayPolicy;

  fn into_glib(self) -> ffi::WebKitAutoplayPolicy {
    match self {
      Self::Allow => ffi::WEBKIT_AUTOPLAY_ALLOW,
      Self::AllowWithoutSound => ffi::WEBKIT_AUTOPLAY_ALLOW_WITHOUT_SOUND,
      Self::Deny => ffi::WEBKIT_AUTOPLAY_DENY,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitAutoplayPolicy> for AutoplayPolicy {
  unsafe fn from_glib(value: ffi::WebKitAutoplayPolicy) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_AUTOPLAY_ALLOW => Self::Allow,
      ffi::WEBKIT_AUTOPLAY_ALLOW_WITHOUT_SOUND => Self::AllowWithoutSound,
      ffi::WEBKIT_AUTOPLAY_DENY => Self::Deny,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl StaticType for AutoplayPolicy {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_autoplay_policy_get_type()) }
  }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl glib::value::ValueType for AutoplayPolicy {
  type Type = Self;
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
unsafe impl<'a> FromValue<'a> for AutoplayPolicy {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_30", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
impl ToValue for AutoplayPolicy {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCacheModel")]
pub enum CacheModel {
  #[doc(alias = "WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER")]
  DocumentViewer,
  #[doc(alias = "WEBKIT_CACHE_MODEL_WEB_BROWSER")]
  WebBrowser,
  #[doc(alias = "WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER")]
  DocumentBrowser,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for CacheModel {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "CacheModel::{}",
      match *self {
        Self::DocumentViewer => "DocumentViewer",
        Self::WebBrowser => "WebBrowser",
        Self::DocumentBrowser => "DocumentBrowser",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for CacheModel {
  type GlibType = ffi::WebKitCacheModel;

  fn into_glib(self) -> ffi::WebKitCacheModel {
    match self {
      Self::DocumentViewer => ffi::WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER,
      Self::WebBrowser => ffi::WEBKIT_CACHE_MODEL_WEB_BROWSER,
      Self::DocumentBrowser => ffi::WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitCacheModel> for CacheModel {
  unsafe fn from_glib(value: ffi::WebKitCacheModel) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_CACHE_MODEL_DOCUMENT_VIEWER => Self::DocumentViewer,
      ffi::WEBKIT_CACHE_MODEL_WEB_BROWSER => Self::WebBrowser,
      ffi::WEBKIT_CACHE_MODEL_DOCUMENT_BROWSER => Self::DocumentBrowser,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for CacheModel {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_cache_model_get_type()) }
  }
}

impl glib::value::ValueType for CacheModel {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CacheModel {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for CacheModel {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitContextMenuAction")]
pub enum ContextMenuAction {
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION")]
  NoAction,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK")]
  OpenLink,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK_IN_NEW_WINDOW")]
  OpenLinkInNewWindow,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_LINK_TO_DISK")]
  DownloadLinkToDisk,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_LINK_TO_CLIPBOARD")]
  CopyLinkToClipboard,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_IMAGE_IN_NEW_WINDOW")]
  OpenImageInNewWindow,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_IMAGE_TO_DISK")]
  DownloadImageToDisk,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_TO_CLIPBOARD")]
  CopyImageToClipboard,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_URL_TO_CLIPBOARD")]
  CopyImageUrlToClipboard,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_FRAME_IN_NEW_WINDOW")]
  OpenFrameInNewWindow,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_GO_BACK")]
  GoBack,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_GO_FORWARD")]
  GoForward,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_STOP")]
  Stop,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_RELOAD")]
  Reload,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY")]
  Copy,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_CUT")]
  Cut,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_PASTE")]
  Paste,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DELETE")]
  Delete,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_SELECT_ALL")]
  SelectAll,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_INPUT_METHODS")]
  InputMethods,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_UNICODE")]
  Unicode,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_SPELLING_GUESS")]
  SpellingGuess,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_NO_GUESSES_FOUND")]
  NoGuessesFound,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_IGNORE_SPELLING")]
  IgnoreSpelling,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_LEARN_SPELLING")]
  LearnSpelling,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_IGNORE_GRAMMAR")]
  IgnoreGrammar,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_FONT_MENU")]
  FontMenu,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_BOLD")]
  Bold,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_ITALIC")]
  Italic,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_UNDERLINE")]
  Underline,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OUTLINE")]
  Outline,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_INSPECT_ELEMENT")]
  InspectElement,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_VIDEO_IN_NEW_WINDOW")]
  OpenVideoInNewWindow,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_OPEN_AUDIO_IN_NEW_WINDOW")]
  OpenAudioInNewWindow,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_VIDEO_LINK_TO_CLIPBOARD")]
  CopyVideoLinkToClipboard,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_COPY_AUDIO_LINK_TO_CLIPBOARD")]
  CopyAudioLinkToClipboard,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_CONTROLS")]
  ToggleMediaControls,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_LOOP")]
  ToggleMediaLoop,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_ENTER_VIDEO_FULLSCREEN")]
  EnterVideoFullscreen,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PLAY")]
  MediaPlay,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PAUSE")]
  MediaPause,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_MEDIA_MUTE")]
  MediaMute,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_VIDEO_TO_DISK")]
  DownloadVideoToDisk,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_AUDIO_TO_DISK")]
  DownloadAudioToDisk,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_INSERT_EMOJI")]
  InsertEmoji,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_PASTE_AS_PLAIN_TEXT")]
  PasteAsPlainText,
  #[doc(alias = "WEBKIT_CONTEXT_MENU_ACTION_CUSTOM")]
  Custom,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for ContextMenuAction {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "ContextMenuAction::{}",
      match *self {
        Self::NoAction => "NoAction",
        Self::OpenLink => "OpenLink",
        Self::OpenLinkInNewWindow => "OpenLinkInNewWindow",
        Self::DownloadLinkToDisk => "DownloadLinkToDisk",
        Self::CopyLinkToClipboard => "CopyLinkToClipboard",
        Self::OpenImageInNewWindow => "OpenImageInNewWindow",
        Self::DownloadImageToDisk => "DownloadImageToDisk",
        Self::CopyImageToClipboard => "CopyImageToClipboard",
        Self::CopyImageUrlToClipboard => "CopyImageUrlToClipboard",
        Self::OpenFrameInNewWindow => "OpenFrameInNewWindow",
        Self::GoBack => "GoBack",
        Self::GoForward => "GoForward",
        Self::Stop => "Stop",
        Self::Reload => "Reload",
        Self::Copy => "Copy",
        Self::Cut => "Cut",
        Self::Paste => "Paste",
        Self::Delete => "Delete",
        Self::SelectAll => "SelectAll",
        Self::InputMethods => "InputMethods",
        Self::Unicode => "Unicode",
        Self::SpellingGuess => "SpellingGuess",
        Self::NoGuessesFound => "NoGuessesFound",
        Self::IgnoreSpelling => "IgnoreSpelling",
        Self::LearnSpelling => "LearnSpelling",
        Self::IgnoreGrammar => "IgnoreGrammar",
        Self::FontMenu => "FontMenu",
        Self::Bold => "Bold",
        Self::Italic => "Italic",
        Self::Underline => "Underline",
        Self::Outline => "Outline",
        Self::InspectElement => "InspectElement",
        Self::OpenVideoInNewWindow => "OpenVideoInNewWindow",
        Self::OpenAudioInNewWindow => "OpenAudioInNewWindow",
        Self::CopyVideoLinkToClipboard => "CopyVideoLinkToClipboard",
        Self::CopyAudioLinkToClipboard => "CopyAudioLinkToClipboard",
        Self::ToggleMediaControls => "ToggleMediaControls",
        Self::ToggleMediaLoop => "ToggleMediaLoop",
        Self::EnterVideoFullscreen => "EnterVideoFullscreen",
        Self::MediaPlay => "MediaPlay",
        Self::MediaPause => "MediaPause",
        Self::MediaMute => "MediaMute",
        Self::DownloadVideoToDisk => "DownloadVideoToDisk",
        Self::DownloadAudioToDisk => "DownloadAudioToDisk",
        Self::InsertEmoji => "InsertEmoji",
        Self::PasteAsPlainText => "PasteAsPlainText",
        Self::Custom => "Custom",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for ContextMenuAction {
  type GlibType = ffi::WebKitContextMenuAction;

  fn into_glib(self) -> ffi::WebKitContextMenuAction {
    match self {
      Self::NoAction => ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION,
      Self::OpenLink => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK,
      Self::OpenLinkInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK_IN_NEW_WINDOW,
      Self::DownloadLinkToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_LINK_TO_DISK,
      Self::CopyLinkToClipboard => ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_LINK_TO_CLIPBOARD,
      Self::OpenImageInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_IMAGE_IN_NEW_WINDOW,
      Self::DownloadImageToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_IMAGE_TO_DISK,
      Self::CopyImageToClipboard => ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_TO_CLIPBOARD,
      Self::CopyImageUrlToClipboard => ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_URL_TO_CLIPBOARD,
      Self::OpenFrameInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_FRAME_IN_NEW_WINDOW,
      Self::GoBack => ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_BACK,
      Self::GoForward => ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_FORWARD,
      Self::Stop => ffi::WEBKIT_CONTEXT_MENU_ACTION_STOP,
      Self::Reload => ffi::WEBKIT_CONTEXT_MENU_ACTION_RELOAD,
      Self::Copy => ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY,
      Self::Cut => ffi::WEBKIT_CONTEXT_MENU_ACTION_CUT,
      Self::Paste => ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE,
      Self::Delete => ffi::WEBKIT_CONTEXT_MENU_ACTION_DELETE,
      Self::SelectAll => ffi::WEBKIT_CONTEXT_MENU_ACTION_SELECT_ALL,
      Self::InputMethods => ffi::WEBKIT_CONTEXT_MENU_ACTION_INPUT_METHODS,
      Self::Unicode => ffi::WEBKIT_CONTEXT_MENU_ACTION_UNICODE,
      Self::SpellingGuess => ffi::WEBKIT_CONTEXT_MENU_ACTION_SPELLING_GUESS,
      Self::NoGuessesFound => ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_GUESSES_FOUND,
      Self::IgnoreSpelling => ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_SPELLING,
      Self::LearnSpelling => ffi::WEBKIT_CONTEXT_MENU_ACTION_LEARN_SPELLING,
      Self::IgnoreGrammar => ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_GRAMMAR,
      Self::FontMenu => ffi::WEBKIT_CONTEXT_MENU_ACTION_FONT_MENU,
      Self::Bold => ffi::WEBKIT_CONTEXT_MENU_ACTION_BOLD,
      Self::Italic => ffi::WEBKIT_CONTEXT_MENU_ACTION_ITALIC,
      Self::Underline => ffi::WEBKIT_CONTEXT_MENU_ACTION_UNDERLINE,
      Self::Outline => ffi::WEBKIT_CONTEXT_MENU_ACTION_OUTLINE,
      Self::InspectElement => ffi::WEBKIT_CONTEXT_MENU_ACTION_INSPECT_ELEMENT,
      Self::OpenVideoInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_VIDEO_IN_NEW_WINDOW,
      Self::OpenAudioInNewWindow => ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_AUDIO_IN_NEW_WINDOW,
      Self::CopyVideoLinkToClipboard => {
        ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_VIDEO_LINK_TO_CLIPBOARD
      }
      Self::CopyAudioLinkToClipboard => {
        ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_AUDIO_LINK_TO_CLIPBOARD
      }
      Self::ToggleMediaControls => ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_CONTROLS,
      Self::ToggleMediaLoop => ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_LOOP,
      Self::EnterVideoFullscreen => ffi::WEBKIT_CONTEXT_MENU_ACTION_ENTER_VIDEO_FULLSCREEN,
      Self::MediaPlay => ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PLAY,
      Self::MediaPause => ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PAUSE,
      Self::MediaMute => ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_MUTE,
      Self::DownloadVideoToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_VIDEO_TO_DISK,
      Self::DownloadAudioToDisk => ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_AUDIO_TO_DISK,
      Self::InsertEmoji => ffi::WEBKIT_CONTEXT_MENU_ACTION_INSERT_EMOJI,
      Self::PasteAsPlainText => ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE_AS_PLAIN_TEXT,
      Self::Custom => ffi::WEBKIT_CONTEXT_MENU_ACTION_CUSTOM,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitContextMenuAction> for ContextMenuAction {
  unsafe fn from_glib(value: ffi::WebKitContextMenuAction) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_ACTION => Self::NoAction,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK => Self::OpenLink,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_LINK_IN_NEW_WINDOW => Self::OpenLinkInNewWindow,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_LINK_TO_DISK => Self::DownloadLinkToDisk,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_LINK_TO_CLIPBOARD => Self::CopyLinkToClipboard,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_IMAGE_IN_NEW_WINDOW => Self::OpenImageInNewWindow,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_IMAGE_TO_DISK => Self::DownloadImageToDisk,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_TO_CLIPBOARD => Self::CopyImageToClipboard,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_IMAGE_URL_TO_CLIPBOARD => Self::CopyImageUrlToClipboard,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_FRAME_IN_NEW_WINDOW => Self::OpenFrameInNewWindow,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_BACK => Self::GoBack,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_GO_FORWARD => Self::GoForward,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_STOP => Self::Stop,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_RELOAD => Self::Reload,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY => Self::Copy,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_CUT => Self::Cut,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE => Self::Paste,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_DELETE => Self::Delete,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_SELECT_ALL => Self::SelectAll,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_INPUT_METHODS => Self::InputMethods,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_UNICODE => Self::Unicode,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_SPELLING_GUESS => Self::SpellingGuess,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_NO_GUESSES_FOUND => Self::NoGuessesFound,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_SPELLING => Self::IgnoreSpelling,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_LEARN_SPELLING => Self::LearnSpelling,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_IGNORE_GRAMMAR => Self::IgnoreGrammar,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_FONT_MENU => Self::FontMenu,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_BOLD => Self::Bold,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_ITALIC => Self::Italic,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_UNDERLINE => Self::Underline,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_OUTLINE => Self::Outline,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_INSPECT_ELEMENT => Self::InspectElement,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_VIDEO_IN_NEW_WINDOW => Self::OpenVideoInNewWindow,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_OPEN_AUDIO_IN_NEW_WINDOW => Self::OpenAudioInNewWindow,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_VIDEO_LINK_TO_CLIPBOARD => {
        Self::CopyVideoLinkToClipboard
      }
      ffi::WEBKIT_CONTEXT_MENU_ACTION_COPY_AUDIO_LINK_TO_CLIPBOARD => {
        Self::CopyAudioLinkToClipboard
      }
      ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_CONTROLS => Self::ToggleMediaControls,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_TOGGLE_MEDIA_LOOP => Self::ToggleMediaLoop,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_ENTER_VIDEO_FULLSCREEN => Self::EnterVideoFullscreen,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PLAY => Self::MediaPlay,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_PAUSE => Self::MediaPause,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_MEDIA_MUTE => Self::MediaMute,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_VIDEO_TO_DISK => Self::DownloadVideoToDisk,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_DOWNLOAD_AUDIO_TO_DISK => Self::DownloadAudioToDisk,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_INSERT_EMOJI => Self::InsertEmoji,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_PASTE_AS_PLAIN_TEXT => Self::PasteAsPlainText,
      ffi::WEBKIT_CONTEXT_MENU_ACTION_CUSTOM => Self::Custom,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for ContextMenuAction {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_context_menu_action_get_type()) }
  }
}

impl glib::value::ValueType for ContextMenuAction {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ContextMenuAction {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for ContextMenuAction {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCookieAcceptPolicy")]
pub enum CookieAcceptPolicy {
  #[doc(alias = "WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS")]
  Always,
  #[doc(alias = "WEBKIT_COOKIE_POLICY_ACCEPT_NEVER")]
  Never,
  #[doc(alias = "WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY")]
  NoThirdParty,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for CookieAcceptPolicy {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "CookieAcceptPolicy::{}",
      match *self {
        Self::Always => "Always",
        Self::Never => "Never",
        Self::NoThirdParty => "NoThirdParty",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for CookieAcceptPolicy {
  type GlibType = ffi::WebKitCookieAcceptPolicy;

  fn into_glib(self) -> ffi::WebKitCookieAcceptPolicy {
    match self {
      Self::Always => ffi::WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS,
      Self::Never => ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NEVER,
      Self::NoThirdParty => ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitCookieAcceptPolicy> for CookieAcceptPolicy {
  unsafe fn from_glib(value: ffi::WebKitCookieAcceptPolicy) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_COOKIE_POLICY_ACCEPT_ALWAYS => Self::Always,
      ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NEVER => Self::Never,
      ffi::WEBKIT_COOKIE_POLICY_ACCEPT_NO_THIRD_PARTY => Self::NoThirdParty,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for CookieAcceptPolicy {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_cookie_accept_policy_get_type()) }
  }
}

impl glib::value::ValueType for CookieAcceptPolicy {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CookieAcceptPolicy {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for CookieAcceptPolicy {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCookiePersistentStorage")]
pub enum CookiePersistentStorage {
  #[doc(alias = "WEBKIT_COOKIE_PERSISTENT_STORAGE_TEXT")]
  Text,
  #[doc(alias = "WEBKIT_COOKIE_PERSISTENT_STORAGE_SQLITE")]
  Sqlite,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for CookiePersistentStorage {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "CookiePersistentStorage::{}",
      match *self {
        Self::Text => "Text",
        Self::Sqlite => "Sqlite",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for CookiePersistentStorage {
  type GlibType = ffi::WebKitCookiePersistentStorage;

  fn into_glib(self) -> ffi::WebKitCookiePersistentStorage {
    match self {
      Self::Text => ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_TEXT,
      Self::Sqlite => ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_SQLITE,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitCookiePersistentStorage> for CookiePersistentStorage {
  unsafe fn from_glib(value: ffi::WebKitCookiePersistentStorage) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_TEXT => Self::Text,
      ffi::WEBKIT_COOKIE_PERSISTENT_STORAGE_SQLITE => Self::Sqlite,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for CookiePersistentStorage {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_cookie_persistent_storage_get_type()) }
  }
}

impl glib::value::ValueType for CookiePersistentStorage {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for CookiePersistentStorage {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for CookiePersistentStorage {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitCredentialPersistence")]
pub enum CredentialPersistence {
  #[doc(alias = "WEBKIT_CREDENTIAL_PERSISTENCE_NONE")]
  None,
  #[doc(alias = "WEBKIT_CREDENTIAL_PERSISTENCE_FOR_SESSION")]
  ForSession,
  #[doc(alias = "WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT")]
  Permanent,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl fmt::Display for CredentialPersistence {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "CredentialPersistence::{}",
      match *self {
        Self::None => "None",
        Self::ForSession => "ForSession",
        Self::Permanent => "Permanent",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
#[doc(hidden)]
impl IntoGlib for CredentialPersistence {
  type GlibType = ffi::WebKitCredentialPersistence;

  fn into_glib(self) -> ffi::WebKitCredentialPersistence {
    match self {
      Self::None => ffi::WEBKIT_CREDENTIAL_PERSISTENCE_NONE,
      Self::ForSession => ffi::WEBKIT_CREDENTIAL_PERSISTENCE_FOR_SESSION,
      Self::Permanent => ffi::WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitCredentialPersistence> for CredentialPersistence {
  unsafe fn from_glib(value: ffi::WebKitCredentialPersistence) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_CREDENTIAL_PERSISTENCE_NONE => Self::None,
      ffi::WEBKIT_CREDENTIAL_PERSISTENCE_FOR_SESSION => Self::ForSession,
      ffi::WEBKIT_CREDENTIAL_PERSISTENCE_PERMANENT => Self::Permanent,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl StaticType for CredentialPersistence {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_credential_persistence_get_type()) }
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl glib::value::ValueType for CredentialPersistence {
  type Type = Self;
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
unsafe impl<'a> FromValue<'a> for CredentialPersistence {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_2", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_2")))]
impl ToValue for CredentialPersistence {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitDownloadError")]
pub enum DownloadError {
  #[doc(alias = "WEBKIT_DOWNLOAD_ERROR_NETWORK")]
  Network,
  #[doc(alias = "WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER")]
  CancelledByUser,
  #[doc(alias = "WEBKIT_DOWNLOAD_ERROR_DESTINATION")]
  Destination,
  #[doc(hidden)]
  __Unknown(i32),
}

impl DownloadError {
  #[doc(alias = "webkit_download_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_download_error_quark()) }
  }
}

impl fmt::Display for DownloadError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "DownloadError::{}",
      match *self {
        Self::Network => "Network",
        Self::CancelledByUser => "CancelledByUser",
        Self::Destination => "Destination",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for DownloadError {
  type GlibType = ffi::WebKitDownloadError;

  fn into_glib(self) -> ffi::WebKitDownloadError {
    match self {
      Self::Network => ffi::WEBKIT_DOWNLOAD_ERROR_NETWORK,
      Self::CancelledByUser => ffi::WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER,
      Self::Destination => ffi::WEBKIT_DOWNLOAD_ERROR_DESTINATION,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitDownloadError> for DownloadError {
  unsafe fn from_glib(value: ffi::WebKitDownloadError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_DOWNLOAD_ERROR_NETWORK => Self::Network,
      ffi::WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER => Self::CancelledByUser,
      ffi::WEBKIT_DOWNLOAD_ERROR_DESTINATION => Self::Destination,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for DownloadError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitDownloadError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_DOWNLOAD_ERROR_NETWORK => Some(Self::Network),
      ffi::WEBKIT_DOWNLOAD_ERROR_CANCELLED_BY_USER => Some(Self::CancelledByUser),
      ffi::WEBKIT_DOWNLOAD_ERROR_DESTINATION => Some(Self::Destination),
      value => Some(Self::__Unknown(value)),
    }
  }
}

impl StaticType for DownloadError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_download_error_get_type()) }
  }
}

impl glib::value::ValueType for DownloadError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for DownloadError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for DownloadError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitFaviconDatabaseError")]
pub enum FaviconDatabaseError {
  #[doc(alias = "WEBKIT_FAVICON_DATABASE_ERROR_NOT_INITIALIZED")]
  NotInitialized,
  #[doc(alias = "WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_NOT_FOUND")]
  FaviconNotFound,
  #[doc(alias = "WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_UNKNOWN")]
  FaviconUnknown,
  #[doc(hidden)]
  __Unknown(i32),
}

impl FaviconDatabaseError {
  #[doc(alias = "webkit_favicon_database_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_favicon_database_error_quark()) }
  }
}

impl fmt::Display for FaviconDatabaseError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "FaviconDatabaseError::{}",
      match *self {
        Self::NotInitialized => "NotInitialized",
        Self::FaviconNotFound => "FaviconNotFound",
        Self::FaviconUnknown => "FaviconUnknown",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for FaviconDatabaseError {
  type GlibType = ffi::WebKitFaviconDatabaseError;

  fn into_glib(self) -> ffi::WebKitFaviconDatabaseError {
    match self {
      Self::NotInitialized => ffi::WEBKIT_FAVICON_DATABASE_ERROR_NOT_INITIALIZED,
      Self::FaviconNotFound => ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_NOT_FOUND,
      Self::FaviconUnknown => ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_UNKNOWN,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitFaviconDatabaseError> for FaviconDatabaseError {
  unsafe fn from_glib(value: ffi::WebKitFaviconDatabaseError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_FAVICON_DATABASE_ERROR_NOT_INITIALIZED => Self::NotInitialized,
      ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_NOT_FOUND => Self::FaviconNotFound,
      ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_UNKNOWN => Self::FaviconUnknown,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for FaviconDatabaseError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitFaviconDatabaseError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_FAVICON_DATABASE_ERROR_NOT_INITIALIZED => Some(Self::NotInitialized),
      ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_NOT_FOUND => Some(Self::FaviconNotFound),
      ffi::WEBKIT_FAVICON_DATABASE_ERROR_FAVICON_UNKNOWN => Some(Self::FaviconUnknown),
      value => Some(Self::__Unknown(value)),
    }
  }
}

impl StaticType for FaviconDatabaseError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_favicon_database_error_get_type()) }
  }
}

impl glib::value::ValueType for FaviconDatabaseError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for FaviconDatabaseError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for FaviconDatabaseError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitHardwareAccelerationPolicy")]
pub enum HardwareAccelerationPolicy {
  #[doc(alias = "WEBKIT_HARDWARE_ACCELERATION_POLICY_ON_DEMAND")]
  OnDemand,
  #[doc(alias = "WEBKIT_HARDWARE_ACCELERATION_POLICY_ALWAYS")]
  Always,
  #[doc(alias = "WEBKIT_HARDWARE_ACCELERATION_POLICY_NEVER")]
  Never,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl fmt::Display for HardwareAccelerationPolicy {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "HardwareAccelerationPolicy::{}",
      match *self {
        Self::OnDemand => "OnDemand",
        Self::Always => "Always",
        Self::Never => "Never",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
#[doc(hidden)]
impl IntoGlib for HardwareAccelerationPolicy {
  type GlibType = ffi::WebKitHardwareAccelerationPolicy;

  fn into_glib(self) -> ffi::WebKitHardwareAccelerationPolicy {
    match self {
      Self::OnDemand => ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_ON_DEMAND,
      Self::Always => ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_ALWAYS,
      Self::Never => ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_NEVER,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitHardwareAccelerationPolicy> for HardwareAccelerationPolicy {
  unsafe fn from_glib(value: ffi::WebKitHardwareAccelerationPolicy) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_ON_DEMAND => Self::OnDemand,
      ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_ALWAYS => Self::Always,
      ffi::WEBKIT_HARDWARE_ACCELERATION_POLICY_NEVER => Self::Never,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl StaticType for HardwareAccelerationPolicy {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_hardware_acceleration_policy_get_type()) }
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl glib::value::ValueType for HardwareAccelerationPolicy {
  type Type = Self;
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
unsafe impl<'a> FromValue<'a> for HardwareAccelerationPolicy {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl ToValue for HardwareAccelerationPolicy {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitInputPurpose")]
pub enum InputPurpose {
  #[doc(alias = "WEBKIT_INPUT_PURPOSE_FREE_FORM")]
  FreeForm,
  #[doc(alias = "WEBKIT_INPUT_PURPOSE_DIGITS")]
  Digits,
  #[doc(alias = "WEBKIT_INPUT_PURPOSE_NUMBER")]
  Number,
  #[doc(alias = "WEBKIT_INPUT_PURPOSE_PHONE")]
  Phone,
  #[doc(alias = "WEBKIT_INPUT_PURPOSE_URL")]
  Url,
  #[doc(alias = "WEBKIT_INPUT_PURPOSE_EMAIL")]
  Email,
  #[doc(alias = "WEBKIT_INPUT_PURPOSE_PASSWORD")]
  Password,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl fmt::Display for InputPurpose {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "InputPurpose::{}",
      match *self {
        Self::FreeForm => "FreeForm",
        Self::Digits => "Digits",
        Self::Number => "Number",
        Self::Phone => "Phone",
        Self::Url => "Url",
        Self::Email => "Email",
        Self::Password => "Password",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[doc(hidden)]
impl IntoGlib for InputPurpose {
  type GlibType = ffi::WebKitInputPurpose;

  fn into_glib(self) -> ffi::WebKitInputPurpose {
    match self {
      Self::FreeForm => ffi::WEBKIT_INPUT_PURPOSE_FREE_FORM,
      Self::Digits => ffi::WEBKIT_INPUT_PURPOSE_DIGITS,
      Self::Number => ffi::WEBKIT_INPUT_PURPOSE_NUMBER,
      Self::Phone => ffi::WEBKIT_INPUT_PURPOSE_PHONE,
      Self::Url => ffi::WEBKIT_INPUT_PURPOSE_URL,
      Self::Email => ffi::WEBKIT_INPUT_PURPOSE_EMAIL,
      Self::Password => ffi::WEBKIT_INPUT_PURPOSE_PASSWORD,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitInputPurpose> for InputPurpose {
  unsafe fn from_glib(value: ffi::WebKitInputPurpose) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_INPUT_PURPOSE_FREE_FORM => Self::FreeForm,
      ffi::WEBKIT_INPUT_PURPOSE_DIGITS => Self::Digits,
      ffi::WEBKIT_INPUT_PURPOSE_NUMBER => Self::Number,
      ffi::WEBKIT_INPUT_PURPOSE_PHONE => Self::Phone,
      ffi::WEBKIT_INPUT_PURPOSE_URL => Self::Url,
      ffi::WEBKIT_INPUT_PURPOSE_EMAIL => Self::Email,
      ffi::WEBKIT_INPUT_PURPOSE_PASSWORD => Self::Password,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl StaticType for InputPurpose {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_input_purpose_get_type()) }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl glib::value::ValueType for InputPurpose {
  type Type = Self;
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
unsafe impl<'a> FromValue<'a> for InputPurpose {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl ToValue for InputPurpose {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitInsecureContentEvent")]
pub enum InsecureContentEvent {
  #[doc(alias = "WEBKIT_INSECURE_CONTENT_RUN")]
  Run,
  #[doc(alias = "WEBKIT_INSECURE_CONTENT_DISPLAYED")]
  Displayed,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for InsecureContentEvent {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "InsecureContentEvent::{}",
      match *self {
        Self::Run => "Run",
        Self::Displayed => "Displayed",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for InsecureContentEvent {
  type GlibType = ffi::WebKitInsecureContentEvent;

  fn into_glib(self) -> ffi::WebKitInsecureContentEvent {
    match self {
      Self::Run => ffi::WEBKIT_INSECURE_CONTENT_RUN,
      Self::Displayed => ffi::WEBKIT_INSECURE_CONTENT_DISPLAYED,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitInsecureContentEvent> for InsecureContentEvent {
  unsafe fn from_glib(value: ffi::WebKitInsecureContentEvent) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_INSECURE_CONTENT_RUN => Self::Run,
      ffi::WEBKIT_INSECURE_CONTENT_DISPLAYED => Self::Displayed,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for InsecureContentEvent {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_insecure_content_event_get_type()) }
  }
}

impl glib::value::ValueType for InsecureContentEvent {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for InsecureContentEvent {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for InsecureContentEvent {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitJavascriptError")]
pub enum JavascriptError {
  #[doc(alias = "WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED")]
  Failed,
  #[doc(hidden)]
  __Unknown(i32),
}

impl JavascriptError {
  #[doc(alias = "webkit_javascript_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_javascript_error_quark()) }
  }
}

impl fmt::Display for JavascriptError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "JavascriptError::{}",
      match *self {
        Self::Failed => "Failed",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for JavascriptError {
  type GlibType = ffi::WebKitJavascriptError;

  fn into_glib(self) -> ffi::WebKitJavascriptError {
    match self {
      Self::Failed => ffi::WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitJavascriptError> for JavascriptError {
  unsafe fn from_glib(value: ffi::WebKitJavascriptError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED => Self::Failed,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for JavascriptError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitJavascriptError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_JAVASCRIPT_ERROR_SCRIPT_FAILED => Some(Self::Failed),
      _ => Some(Self::Failed),
    }
  }
}

impl StaticType for JavascriptError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_javascript_error_get_type()) }
  }
}

impl glib::value::ValueType for JavascriptError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for JavascriptError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for JavascriptError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitLoadEvent")]
pub enum LoadEvent {
  #[doc(alias = "WEBKIT_LOAD_STARTED")]
  Started,
  #[doc(alias = "WEBKIT_LOAD_REDIRECTED")]
  Redirected,
  #[doc(alias = "WEBKIT_LOAD_COMMITTED")]
  Committed,
  #[doc(alias = "WEBKIT_LOAD_FINISHED")]
  Finished,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for LoadEvent {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "LoadEvent::{}",
      match *self {
        Self::Started => "Started",
        Self::Redirected => "Redirected",
        Self::Committed => "Committed",
        Self::Finished => "Finished",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for LoadEvent {
  type GlibType = ffi::WebKitLoadEvent;

  fn into_glib(self) -> ffi::WebKitLoadEvent {
    match self {
      Self::Started => ffi::WEBKIT_LOAD_STARTED,
      Self::Redirected => ffi::WEBKIT_LOAD_REDIRECTED,
      Self::Committed => ffi::WEBKIT_LOAD_COMMITTED,
      Self::Finished => ffi::WEBKIT_LOAD_FINISHED,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitLoadEvent> for LoadEvent {
  unsafe fn from_glib(value: ffi::WebKitLoadEvent) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_LOAD_STARTED => Self::Started,
      ffi::WEBKIT_LOAD_REDIRECTED => Self::Redirected,
      ffi::WEBKIT_LOAD_COMMITTED => Self::Committed,
      ffi::WEBKIT_LOAD_FINISHED => Self::Finished,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for LoadEvent {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_load_event_get_type()) }
  }
}

impl glib::value::ValueType for LoadEvent {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for LoadEvent {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for LoadEvent {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitMediaCaptureState")]
pub enum MediaCaptureState {
  #[doc(alias = "WEBKIT_MEDIA_CAPTURE_STATE_NONE")]
  None,
  #[doc(alias = "WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE")]
  Active,
  #[doc(alias = "WEBKIT_MEDIA_CAPTURE_STATE_MUTED")]
  Muted,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl fmt::Display for MediaCaptureState {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "MediaCaptureState::{}",
      match *self {
        Self::None => "None",
        Self::Active => "Active",
        Self::Muted => "Muted",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
#[doc(hidden)]
impl IntoGlib for MediaCaptureState {
  type GlibType = ffi::WebKitMediaCaptureState;

  fn into_glib(self) -> ffi::WebKitMediaCaptureState {
    match self {
      Self::None => ffi::WEBKIT_MEDIA_CAPTURE_STATE_NONE,
      Self::Active => ffi::WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE,
      Self::Muted => ffi::WEBKIT_MEDIA_CAPTURE_STATE_MUTED,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitMediaCaptureState> for MediaCaptureState {
  unsafe fn from_glib(value: ffi::WebKitMediaCaptureState) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_MEDIA_CAPTURE_STATE_NONE => Self::None,
      ffi::WEBKIT_MEDIA_CAPTURE_STATE_ACTIVE => Self::Active,
      ffi::WEBKIT_MEDIA_CAPTURE_STATE_MUTED => Self::Muted,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl StaticType for MediaCaptureState {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_media_capture_state_get_type()) }
  }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl glib::value::ValueType for MediaCaptureState {
  type Type = Self;
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
unsafe impl<'a> FromValue<'a> for MediaCaptureState {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
impl ToValue for MediaCaptureState {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitNavigationType")]
pub enum NavigationType {
  #[doc(alias = "WEBKIT_NAVIGATION_TYPE_LINK_CLICKED")]
  LinkClicked,
  #[doc(alias = "WEBKIT_NAVIGATION_TYPE_FORM_SUBMITTED")]
  FormSubmitted,
  #[doc(alias = "WEBKIT_NAVIGATION_TYPE_BACK_FORWARD")]
  BackForward,
  #[doc(alias = "WEBKIT_NAVIGATION_TYPE_RELOAD")]
  Reload,
  #[doc(alias = "WEBKIT_NAVIGATION_TYPE_FORM_RESUBMITTED")]
  FormResubmitted,
  #[doc(alias = "WEBKIT_NAVIGATION_TYPE_OTHER")]
  Other,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for NavigationType {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "NavigationType::{}",
      match *self {
        Self::LinkClicked => "LinkClicked",
        Self::FormSubmitted => "FormSubmitted",
        Self::BackForward => "BackForward",
        Self::Reload => "Reload",
        Self::FormResubmitted => "FormResubmitted",
        Self::Other => "Other",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for NavigationType {
  type GlibType = ffi::WebKitNavigationType;

  fn into_glib(self) -> ffi::WebKitNavigationType {
    match self {
      Self::LinkClicked => ffi::WEBKIT_NAVIGATION_TYPE_LINK_CLICKED,
      Self::FormSubmitted => ffi::WEBKIT_NAVIGATION_TYPE_FORM_SUBMITTED,
      Self::BackForward => ffi::WEBKIT_NAVIGATION_TYPE_BACK_FORWARD,
      Self::Reload => ffi::WEBKIT_NAVIGATION_TYPE_RELOAD,
      Self::FormResubmitted => ffi::WEBKIT_NAVIGATION_TYPE_FORM_RESUBMITTED,
      Self::Other => ffi::WEBKIT_NAVIGATION_TYPE_OTHER,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitNavigationType> for NavigationType {
  unsafe fn from_glib(value: ffi::WebKitNavigationType) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_NAVIGATION_TYPE_LINK_CLICKED => Self::LinkClicked,
      ffi::WEBKIT_NAVIGATION_TYPE_FORM_SUBMITTED => Self::FormSubmitted,
      ffi::WEBKIT_NAVIGATION_TYPE_BACK_FORWARD => Self::BackForward,
      ffi::WEBKIT_NAVIGATION_TYPE_RELOAD => Self::Reload,
      ffi::WEBKIT_NAVIGATION_TYPE_FORM_RESUBMITTED => Self::FormResubmitted,
      ffi::WEBKIT_NAVIGATION_TYPE_OTHER => Self::Other,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for NavigationType {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_navigation_type_get_type()) }
  }
}

impl glib::value::ValueType for NavigationType {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for NavigationType {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for NavigationType {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitNetworkError")]
pub enum NetworkError {
  #[doc(alias = "WEBKIT_NETWORK_ERROR_FAILED")]
  Failed,
  #[doc(alias = "WEBKIT_NETWORK_ERROR_TRANSPORT")]
  Transport,
  #[doc(alias = "WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL")]
  UnknownProtocol,
  #[doc(alias = "WEBKIT_NETWORK_ERROR_CANCELLED")]
  Cancelled,
  #[doc(alias = "WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST")]
  FileDoesNotExist,
  #[doc(hidden)]
  __Unknown(i32),
}

impl NetworkError {
  #[doc(alias = "webkit_network_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_network_error_quark()) }
  }
}

impl fmt::Display for NetworkError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "NetworkError::{}",
      match *self {
        Self::Failed => "Failed",
        Self::Transport => "Transport",
        Self::UnknownProtocol => "UnknownProtocol",
        Self::Cancelled => "Cancelled",
        Self::FileDoesNotExist => "FileDoesNotExist",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for NetworkError {
  type GlibType = ffi::WebKitNetworkError;

  fn into_glib(self) -> ffi::WebKitNetworkError {
    match self {
      Self::Failed => ffi::WEBKIT_NETWORK_ERROR_FAILED,
      Self::Transport => ffi::WEBKIT_NETWORK_ERROR_TRANSPORT,
      Self::UnknownProtocol => ffi::WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL,
      Self::Cancelled => ffi::WEBKIT_NETWORK_ERROR_CANCELLED,
      Self::FileDoesNotExist => ffi::WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitNetworkError> for NetworkError {
  unsafe fn from_glib(value: ffi::WebKitNetworkError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_NETWORK_ERROR_FAILED => Self::Failed,
      ffi::WEBKIT_NETWORK_ERROR_TRANSPORT => Self::Transport,
      ffi::WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL => Self::UnknownProtocol,
      ffi::WEBKIT_NETWORK_ERROR_CANCELLED => Self::Cancelled,
      ffi::WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST => Self::FileDoesNotExist,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for NetworkError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitNetworkError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_NETWORK_ERROR_FAILED => Some(Self::Failed),
      ffi::WEBKIT_NETWORK_ERROR_TRANSPORT => Some(Self::Transport),
      ffi::WEBKIT_NETWORK_ERROR_UNKNOWN_PROTOCOL => Some(Self::UnknownProtocol),
      ffi::WEBKIT_NETWORK_ERROR_CANCELLED => Some(Self::Cancelled),
      ffi::WEBKIT_NETWORK_ERROR_FILE_DOES_NOT_EXIST => Some(Self::FileDoesNotExist),
      _ => Some(Self::Failed),
    }
  }
}

impl StaticType for NetworkError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_network_error_get_type()) }
  }
}

impl glib::value::ValueType for NetworkError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for NetworkError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for NetworkError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitNetworkProxyMode")]
pub enum NetworkProxyMode {
  #[doc(alias = "WEBKIT_NETWORK_PROXY_MODE_DEFAULT")]
  Default,
  #[doc(alias = "WEBKIT_NETWORK_PROXY_MODE_NO_PROXY")]
  NoProxy,
  #[doc(alias = "WEBKIT_NETWORK_PROXY_MODE_CUSTOM")]
  Custom,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl fmt::Display for NetworkProxyMode {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "NetworkProxyMode::{}",
      match *self {
        Self::Default => "Default",
        Self::NoProxy => "NoProxy",
        Self::Custom => "Custom",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
#[doc(hidden)]
impl IntoGlib for NetworkProxyMode {
  type GlibType = ffi::WebKitNetworkProxyMode;

  fn into_glib(self) -> ffi::WebKitNetworkProxyMode {
    match self {
      Self::Default => ffi::WEBKIT_NETWORK_PROXY_MODE_DEFAULT,
      Self::NoProxy => ffi::WEBKIT_NETWORK_PROXY_MODE_NO_PROXY,
      Self::Custom => ffi::WEBKIT_NETWORK_PROXY_MODE_CUSTOM,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitNetworkProxyMode> for NetworkProxyMode {
  unsafe fn from_glib(value: ffi::WebKitNetworkProxyMode) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_NETWORK_PROXY_MODE_DEFAULT => Self::Default,
      ffi::WEBKIT_NETWORK_PROXY_MODE_NO_PROXY => Self::NoProxy,
      ffi::WEBKIT_NETWORK_PROXY_MODE_CUSTOM => Self::Custom,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl StaticType for NetworkProxyMode {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_network_proxy_mode_get_type()) }
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl glib::value::ValueType for NetworkProxyMode {
  type Type = Self;
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
unsafe impl<'a> FromValue<'a> for NetworkProxyMode {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
impl ToValue for NetworkProxyMode {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPluginError")]
pub enum PluginError {
  #[doc(alias = "WEBKIT_PLUGIN_ERROR_FAILED")]
  Failed,
  #[doc(alias = "WEBKIT_PLUGIN_ERROR_CANNOT_FIND_PLUGIN")]
  CannotFindPlugin,
  #[doc(alias = "WEBKIT_PLUGIN_ERROR_CANNOT_LOAD_PLUGIN")]
  CannotLoadPlugin,
  #[doc(alias = "WEBKIT_PLUGIN_ERROR_JAVA_UNAVAILABLE")]
  JavaUnavailable,
  #[doc(alias = "WEBKIT_PLUGIN_ERROR_CONNECTION_CANCELLED")]
  ConnectionCancelled,
  #[doc(alias = "WEBKIT_PLUGIN_ERROR_WILL_HANDLE_LOAD")]
  WillHandleLoad,
  #[doc(hidden)]
  __Unknown(i32),
}

impl PluginError {
  #[doc(alias = "webkit_plugin_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_plugin_error_quark()) }
  }
}

impl fmt::Display for PluginError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "PluginError::{}",
      match *self {
        Self::Failed => "Failed",
        Self::CannotFindPlugin => "CannotFindPlugin",
        Self::CannotLoadPlugin => "CannotLoadPlugin",
        Self::JavaUnavailable => "JavaUnavailable",
        Self::ConnectionCancelled => "ConnectionCancelled",
        Self::WillHandleLoad => "WillHandleLoad",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for PluginError {
  type GlibType = ffi::WebKitPluginError;

  fn into_glib(self) -> ffi::WebKitPluginError {
    match self {
      Self::Failed => ffi::WEBKIT_PLUGIN_ERROR_FAILED,
      Self::CannotFindPlugin => ffi::WEBKIT_PLUGIN_ERROR_CANNOT_FIND_PLUGIN,
      Self::CannotLoadPlugin => ffi::WEBKIT_PLUGIN_ERROR_CANNOT_LOAD_PLUGIN,
      Self::JavaUnavailable => ffi::WEBKIT_PLUGIN_ERROR_JAVA_UNAVAILABLE,
      Self::ConnectionCancelled => ffi::WEBKIT_PLUGIN_ERROR_CONNECTION_CANCELLED,
      Self::WillHandleLoad => ffi::WEBKIT_PLUGIN_ERROR_WILL_HANDLE_LOAD,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPluginError> for PluginError {
  unsafe fn from_glib(value: ffi::WebKitPluginError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_PLUGIN_ERROR_FAILED => Self::Failed,
      ffi::WEBKIT_PLUGIN_ERROR_CANNOT_FIND_PLUGIN => Self::CannotFindPlugin,
      ffi::WEBKIT_PLUGIN_ERROR_CANNOT_LOAD_PLUGIN => Self::CannotLoadPlugin,
      ffi::WEBKIT_PLUGIN_ERROR_JAVA_UNAVAILABLE => Self::JavaUnavailable,
      ffi::WEBKIT_PLUGIN_ERROR_CONNECTION_CANCELLED => Self::ConnectionCancelled,
      ffi::WEBKIT_PLUGIN_ERROR_WILL_HANDLE_LOAD => Self::WillHandleLoad,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for PluginError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitPluginError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_PLUGIN_ERROR_FAILED => Some(Self::Failed),
      ffi::WEBKIT_PLUGIN_ERROR_CANNOT_FIND_PLUGIN => Some(Self::CannotFindPlugin),
      ffi::WEBKIT_PLUGIN_ERROR_CANNOT_LOAD_PLUGIN => Some(Self::CannotLoadPlugin),
      ffi::WEBKIT_PLUGIN_ERROR_JAVA_UNAVAILABLE => Some(Self::JavaUnavailable),
      ffi::WEBKIT_PLUGIN_ERROR_CONNECTION_CANCELLED => Some(Self::ConnectionCancelled),
      ffi::WEBKIT_PLUGIN_ERROR_WILL_HANDLE_LOAD => Some(Self::WillHandleLoad),
      _ => Some(Self::Failed),
    }
  }
}

impl StaticType for PluginError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_plugin_error_get_type()) }
  }
}

impl glib::value::ValueType for PluginError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PluginError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for PluginError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPolicyDecisionType")]
pub enum PolicyDecisionType {
  #[doc(alias = "WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION")]
  NavigationAction,
  #[doc(alias = "WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION")]
  NewWindowAction,
  #[doc(alias = "WEBKIT_POLICY_DECISION_TYPE_RESPONSE")]
  Response,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for PolicyDecisionType {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "PolicyDecisionType::{}",
      match *self {
        Self::NavigationAction => "NavigationAction",
        Self::NewWindowAction => "NewWindowAction",
        Self::Response => "Response",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for PolicyDecisionType {
  type GlibType = ffi::WebKitPolicyDecisionType;

  fn into_glib(self) -> ffi::WebKitPolicyDecisionType {
    match self {
      Self::NavigationAction => ffi::WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION,
      Self::NewWindowAction => ffi::WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION,
      Self::Response => ffi::WEBKIT_POLICY_DECISION_TYPE_RESPONSE,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPolicyDecisionType> for PolicyDecisionType {
  unsafe fn from_glib(value: ffi::WebKitPolicyDecisionType) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION => Self::NavigationAction,
      ffi::WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION => Self::NewWindowAction,
      ffi::WEBKIT_POLICY_DECISION_TYPE_RESPONSE => Self::Response,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for PolicyDecisionType {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_policy_decision_type_get_type()) }
  }
}

impl glib::value::ValueType for PolicyDecisionType {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PolicyDecisionType {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for PolicyDecisionType {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPolicyError")]
pub enum PolicyError {
  #[doc(alias = "WEBKIT_POLICY_ERROR_FAILED")]
  Failed,
  #[doc(alias = "WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE")]
  CannotShowMimeType,
  #[doc(alias = "WEBKIT_POLICY_ERROR_CANNOT_SHOW_URI")]
  CannotShowUri,
  #[doc(alias = "WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE")]
  FrameLoadInterruptedByPolicyChange,
  #[doc(alias = "WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT")]
  CannotUseRestrictedPort,
  #[doc(hidden)]
  __Unknown(i32),
}

impl PolicyError {
  #[doc(alias = "webkit_policy_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_policy_error_quark()) }
  }
}

impl fmt::Display for PolicyError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "PolicyError::{}",
      match *self {
        Self::Failed => "Failed",
        Self::CannotShowMimeType => "CannotShowMimeType",
        Self::CannotShowUri => "CannotShowUri",
        Self::FrameLoadInterruptedByPolicyChange => "FrameLoadInterruptedByPolicyChange",
        Self::CannotUseRestrictedPort => "CannotUseRestrictedPort",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for PolicyError {
  type GlibType = ffi::WebKitPolicyError;

  fn into_glib(self) -> ffi::WebKitPolicyError {
    match self {
      Self::Failed => ffi::WEBKIT_POLICY_ERROR_FAILED,
      Self::CannotShowMimeType => ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE,
      Self::CannotShowUri => ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_URI,
      Self::FrameLoadInterruptedByPolicyChange => {
        ffi::WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE
      }
      Self::CannotUseRestrictedPort => ffi::WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPolicyError> for PolicyError {
  unsafe fn from_glib(value: ffi::WebKitPolicyError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_POLICY_ERROR_FAILED => Self::Failed,
      ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE => Self::CannotShowMimeType,
      ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_URI => Self::CannotShowUri,
      ffi::WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE => {
        Self::FrameLoadInterruptedByPolicyChange
      }
      ffi::WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT => Self::CannotUseRestrictedPort,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for PolicyError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitPolicyError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_POLICY_ERROR_FAILED => Some(Self::Failed),
      ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_MIME_TYPE => Some(Self::CannotShowMimeType),
      ffi::WEBKIT_POLICY_ERROR_CANNOT_SHOW_URI => Some(Self::CannotShowUri),
      ffi::WEBKIT_POLICY_ERROR_FRAME_LOAD_INTERRUPTED_BY_POLICY_CHANGE => {
        Some(Self::FrameLoadInterruptedByPolicyChange)
      }
      ffi::WEBKIT_POLICY_ERROR_CANNOT_USE_RESTRICTED_PORT => Some(Self::CannotUseRestrictedPort),
      _ => Some(Self::Failed),
    }
  }
}

impl StaticType for PolicyError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_policy_error_get_type()) }
  }
}

impl glib::value::ValueType for PolicyError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PolicyError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for PolicyError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPrintError")]
pub enum PrintError {
  #[doc(alias = "WEBKIT_PRINT_ERROR_GENERAL")]
  General,
  #[doc(alias = "WEBKIT_PRINT_ERROR_PRINTER_NOT_FOUND")]
  PrinterNotFound,
  #[doc(alias = "WEBKIT_PRINT_ERROR_INVALID_PAGE_RANGE")]
  InvalidPageRange,
  #[doc(hidden)]
  __Unknown(i32),
}

impl PrintError {
  #[doc(alias = "webkit_print_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_print_error_quark()) }
  }
}

impl fmt::Display for PrintError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "PrintError::{}",
      match *self {
        Self::General => "General",
        Self::PrinterNotFound => "PrinterNotFound",
        Self::InvalidPageRange => "InvalidPageRange",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for PrintError {
  type GlibType = ffi::WebKitPrintError;

  fn into_glib(self) -> ffi::WebKitPrintError {
    match self {
      Self::General => ffi::WEBKIT_PRINT_ERROR_GENERAL,
      Self::PrinterNotFound => ffi::WEBKIT_PRINT_ERROR_PRINTER_NOT_FOUND,
      Self::InvalidPageRange => ffi::WEBKIT_PRINT_ERROR_INVALID_PAGE_RANGE,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPrintError> for PrintError {
  unsafe fn from_glib(value: ffi::WebKitPrintError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_PRINT_ERROR_GENERAL => Self::General,
      ffi::WEBKIT_PRINT_ERROR_PRINTER_NOT_FOUND => Self::PrinterNotFound,
      ffi::WEBKIT_PRINT_ERROR_INVALID_PAGE_RANGE => Self::InvalidPageRange,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for PrintError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitPrintError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_PRINT_ERROR_GENERAL => Some(Self::General),
      ffi::WEBKIT_PRINT_ERROR_PRINTER_NOT_FOUND => Some(Self::PrinterNotFound),
      ffi::WEBKIT_PRINT_ERROR_INVALID_PAGE_RANGE => Some(Self::InvalidPageRange),
      value => Some(Self::__Unknown(value)),
    }
  }
}

impl StaticType for PrintError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_print_error_get_type()) }
  }
}

impl glib::value::ValueType for PrintError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for PrintError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitPrintOperationResponse")]
pub enum PrintOperationResponse {
  #[doc(alias = "WEBKIT_PRINT_OPERATION_RESPONSE_PRINT")]
  Print,
  #[doc(alias = "WEBKIT_PRINT_OPERATION_RESPONSE_CANCEL")]
  Cancel,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for PrintOperationResponse {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "PrintOperationResponse::{}",
      match *self {
        Self::Print => "Print",
        Self::Cancel => "Cancel",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for PrintOperationResponse {
  type GlibType = ffi::WebKitPrintOperationResponse;

  fn into_glib(self) -> ffi::WebKitPrintOperationResponse {
    match self {
      Self::Print => ffi::WEBKIT_PRINT_OPERATION_RESPONSE_PRINT,
      Self::Cancel => ffi::WEBKIT_PRINT_OPERATION_RESPONSE_CANCEL,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitPrintOperationResponse> for PrintOperationResponse {
  unsafe fn from_glib(value: ffi::WebKitPrintOperationResponse) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_PRINT_OPERATION_RESPONSE_PRINT => Self::Print,
      ffi::WEBKIT_PRINT_OPERATION_RESPONSE_CANCEL => Self::Cancel,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for PrintOperationResponse {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_print_operation_response_get_type()) }
  }
}

impl glib::value::ValueType for PrintOperationResponse {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for PrintOperationResponse {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for PrintOperationResponse {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitProcessModel")]
pub enum ProcessModel {
  #[doc(alias = "WEBKIT_PROCESS_MODEL_SHARED_SECONDARY_PROCESS")]
  SharedSecondaryProcess,
  #[doc(alias = "WEBKIT_PROCESS_MODEL_MULTIPLE_SECONDARY_PROCESSES")]
  MultipleSecondaryProcesses,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
impl fmt::Display for ProcessModel {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "ProcessModel::{}",
      match *self {
        Self::SharedSecondaryProcess => "SharedSecondaryProcess",
        Self::MultipleSecondaryProcesses => "MultipleSecondaryProcesses",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
#[doc(hidden)]
impl IntoGlib for ProcessModel {
  type GlibType = ffi::WebKitProcessModel;

  fn into_glib(self) -> ffi::WebKitProcessModel {
    match self {
      Self::SharedSecondaryProcess => ffi::WEBKIT_PROCESS_MODEL_SHARED_SECONDARY_PROCESS,
      Self::MultipleSecondaryProcesses => ffi::WEBKIT_PROCESS_MODEL_MULTIPLE_SECONDARY_PROCESSES,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitProcessModel> for ProcessModel {
  unsafe fn from_glib(value: ffi::WebKitProcessModel) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_PROCESS_MODEL_SHARED_SECONDARY_PROCESS => Self::SharedSecondaryProcess,
      ffi::WEBKIT_PROCESS_MODEL_MULTIPLE_SECONDARY_PROCESSES => Self::MultipleSecondaryProcesses,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
impl StaticType for ProcessModel {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_process_model_get_type()) }
  }
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
impl glib::value::ValueType for ProcessModel {
  type Type = Self;
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
unsafe impl<'a> FromValue<'a> for ProcessModel {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_4", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_4")))]
impl ToValue for ProcessModel {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitSaveMode")]
pub enum SaveMode {
  #[doc(alias = "WEBKIT_SAVE_MODE_MHTML")]
  Mhtml,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for SaveMode {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "SaveMode::{}",
      match *self {
        Self::Mhtml => "Mhtml",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for SaveMode {
  type GlibType = ffi::WebKitSaveMode;

  fn into_glib(self) -> ffi::WebKitSaveMode {
    match self {
      Self::Mhtml => ffi::WEBKIT_SAVE_MODE_MHTML,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitSaveMode> for SaveMode {
  unsafe fn from_glib(value: ffi::WebKitSaveMode) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_SAVE_MODE_MHTML => Self::Mhtml,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for SaveMode {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_save_mode_get_type()) }
  }
}

impl glib::value::ValueType for SaveMode {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SaveMode {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for SaveMode {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitScriptDialogType")]
pub enum ScriptDialogType {
  #[doc(alias = "WEBKIT_SCRIPT_DIALOG_ALERT")]
  Alert,
  #[doc(alias = "WEBKIT_SCRIPT_DIALOG_CONFIRM")]
  Confirm,
  #[doc(alias = "WEBKIT_SCRIPT_DIALOG_PROMPT")]
  Prompt,
  #[doc(alias = "WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM")]
  BeforeUnloadConfirm,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for ScriptDialogType {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "ScriptDialogType::{}",
      match *self {
        Self::Alert => "Alert",
        Self::Confirm => "Confirm",
        Self::Prompt => "Prompt",
        Self::BeforeUnloadConfirm => "BeforeUnloadConfirm",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for ScriptDialogType {
  type GlibType = ffi::WebKitScriptDialogType;

  fn into_glib(self) -> ffi::WebKitScriptDialogType {
    match self {
      Self::Alert => ffi::WEBKIT_SCRIPT_DIALOG_ALERT,
      Self::Confirm => ffi::WEBKIT_SCRIPT_DIALOG_CONFIRM,
      Self::Prompt => ffi::WEBKIT_SCRIPT_DIALOG_PROMPT,
      Self::BeforeUnloadConfirm => ffi::WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitScriptDialogType> for ScriptDialogType {
  unsafe fn from_glib(value: ffi::WebKitScriptDialogType) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_SCRIPT_DIALOG_ALERT => Self::Alert,
      ffi::WEBKIT_SCRIPT_DIALOG_CONFIRM => Self::Confirm,
      ffi::WEBKIT_SCRIPT_DIALOG_PROMPT => Self::Prompt,
      ffi::WEBKIT_SCRIPT_DIALOG_BEFORE_UNLOAD_CONFIRM => Self::BeforeUnloadConfirm,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for ScriptDialogType {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_script_dialog_type_get_type()) }
  }
}

impl glib::value::ValueType for ScriptDialogType {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for ScriptDialogType {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for ScriptDialogType {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitSnapshotError")]
pub enum SnapshotError {
  #[doc(alias = "WEBKIT_SNAPSHOT_ERROR_FAILED_TO_CREATE")]
  Create,
  #[doc(hidden)]
  __Unknown(i32),
}

impl SnapshotError {
  #[doc(alias = "webkit_snapshot_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_snapshot_error_quark()) }
  }
}

impl fmt::Display for SnapshotError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "SnapshotError::{}",
      match *self {
        Self::Create => "Create",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for SnapshotError {
  type GlibType = ffi::WebKitSnapshotError;

  fn into_glib(self) -> ffi::WebKitSnapshotError {
    match self {
      Self::Create => ffi::WEBKIT_SNAPSHOT_ERROR_FAILED_TO_CREATE,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitSnapshotError> for SnapshotError {
  unsafe fn from_glib(value: ffi::WebKitSnapshotError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_SNAPSHOT_ERROR_FAILED_TO_CREATE => Self::Create,
      value => Self::__Unknown(value),
    }
  }
}

impl ErrorDomain for SnapshotError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitSnapshotError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_SNAPSHOT_ERROR_FAILED_TO_CREATE => Some(Self::Create),
      value => Some(Self::__Unknown(value)),
    }
  }
}

impl StaticType for SnapshotError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_snapshot_error_get_type()) }
  }
}

impl glib::value::ValueType for SnapshotError {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SnapshotError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for SnapshotError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitSnapshotRegion")]
pub enum SnapshotRegion {
  #[doc(alias = "WEBKIT_SNAPSHOT_REGION_VISIBLE")]
  Visible,
  #[doc(alias = "WEBKIT_SNAPSHOT_REGION_FULL_DOCUMENT")]
  FullDocument,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for SnapshotRegion {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "SnapshotRegion::{}",
      match *self {
        Self::Visible => "Visible",
        Self::FullDocument => "FullDocument",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for SnapshotRegion {
  type GlibType = ffi::WebKitSnapshotRegion;

  fn into_glib(self) -> ffi::WebKitSnapshotRegion {
    match self {
      Self::Visible => ffi::WEBKIT_SNAPSHOT_REGION_VISIBLE,
      Self::FullDocument => ffi::WEBKIT_SNAPSHOT_REGION_FULL_DOCUMENT,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitSnapshotRegion> for SnapshotRegion {
  unsafe fn from_glib(value: ffi::WebKitSnapshotRegion) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_SNAPSHOT_REGION_VISIBLE => Self::Visible,
      ffi::WEBKIT_SNAPSHOT_REGION_FULL_DOCUMENT => Self::FullDocument,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for SnapshotRegion {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_snapshot_region_get_type()) }
  }
}

impl glib::value::ValueType for SnapshotRegion {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for SnapshotRegion {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for SnapshotRegion {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitTLSErrorsPolicy")]
pub enum TLSErrorsPolicy {
  #[doc(alias = "WEBKIT_TLS_ERRORS_POLICY_IGNORE")]
  Ignore,
  #[doc(alias = "WEBKIT_TLS_ERRORS_POLICY_FAIL")]
  Fail,
  #[doc(hidden)]
  __Unknown(i32),
}

impl fmt::Display for TLSErrorsPolicy {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "TLSErrorsPolicy::{}",
      match *self {
        Self::Ignore => "Ignore",
        Self::Fail => "Fail",
        _ => "Unknown",
      }
    )
  }
}

#[doc(hidden)]
impl IntoGlib for TLSErrorsPolicy {
  type GlibType = ffi::WebKitTLSErrorsPolicy;

  fn into_glib(self) -> ffi::WebKitTLSErrorsPolicy {
    match self {
      Self::Ignore => ffi::WEBKIT_TLS_ERRORS_POLICY_IGNORE,
      Self::Fail => ffi::WEBKIT_TLS_ERRORS_POLICY_FAIL,
      Self::__Unknown(value) => value,
    }
  }
}

#[doc(hidden)]
impl FromGlib<ffi::WebKitTLSErrorsPolicy> for TLSErrorsPolicy {
  unsafe fn from_glib(value: ffi::WebKitTLSErrorsPolicy) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_TLS_ERRORS_POLICY_IGNORE => Self::Ignore,
      ffi::WEBKIT_TLS_ERRORS_POLICY_FAIL => Self::Fail,
      value => Self::__Unknown(value),
    }
  }
}

impl StaticType for TLSErrorsPolicy {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_tls_errors_policy_get_type()) }
  }
}

impl glib::value::ValueType for TLSErrorsPolicy {
  type Type = Self;
}

unsafe impl<'a> FromValue<'a> for TLSErrorsPolicy {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

impl ToValue for TLSErrorsPolicy {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserContentFilterError")]
pub enum UserContentFilterError {
  #[doc(alias = "WEBKIT_USER_CONTENT_FILTER_ERROR_INVALID_SOURCE")]
  InvalidSource,
  #[doc(alias = "WEBKIT_USER_CONTENT_FILTER_ERROR_NOT_FOUND")]
  NotFound,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
impl UserContentFilterError {
  #[doc(alias = "webkit_user_content_filter_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_user_content_filter_error_quark()) }
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
impl fmt::Display for UserContentFilterError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "UserContentFilterError::{}",
      match *self {
        Self::InvalidSource => "InvalidSource",
        Self::NotFound => "NotFound",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
#[doc(hidden)]
impl IntoGlib for UserContentFilterError {
  type GlibType = ffi::WebKitUserContentFilterError;

  fn into_glib(self) -> ffi::WebKitUserContentFilterError {
    match self {
      Self::InvalidSource => ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_INVALID_SOURCE,
      Self::NotFound => ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_NOT_FOUND,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitUserContentFilterError> for UserContentFilterError {
  unsafe fn from_glib(value: ffi::WebKitUserContentFilterError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_INVALID_SOURCE => Self::InvalidSource,
      ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_NOT_FOUND => Self::NotFound,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
impl ErrorDomain for UserContentFilterError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> = once_cell::sync::Lazy::new(
      || unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitUserContentFilterError\0".as_ptr() as *const _)
      },
    );
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_INVALID_SOURCE => Some(Self::InvalidSource),
      ffi::WEBKIT_USER_CONTENT_FILTER_ERROR_NOT_FOUND => Some(Self::NotFound),
      value => Some(Self::__Unknown(value)),
    }
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
impl StaticType for UserContentFilterError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_user_content_filter_error_get_type()) }
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
impl glib::value::ValueType for UserContentFilterError {
  type Type = Self;
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
unsafe impl<'a> FromValue<'a> for UserContentFilterError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_24", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
impl ToValue for UserContentFilterError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserContentInjectedFrames")]
pub enum UserContentInjectedFrames {
  #[doc(alias = "WEBKIT_USER_CONTENT_INJECT_ALL_FRAMES")]
  AllFrames,
  #[doc(alias = "WEBKIT_USER_CONTENT_INJECT_TOP_FRAME")]
  TopFrame,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl fmt::Display for UserContentInjectedFrames {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "UserContentInjectedFrames::{}",
      match *self {
        Self::AllFrames => "AllFrames",
        Self::TopFrame => "TopFrame",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[doc(hidden)]
impl IntoGlib for UserContentInjectedFrames {
  type GlibType = ffi::WebKitUserContentInjectedFrames;

  fn into_glib(self) -> ffi::WebKitUserContentInjectedFrames {
    match self {
      Self::AllFrames => ffi::WEBKIT_USER_CONTENT_INJECT_ALL_FRAMES,
      Self::TopFrame => ffi::WEBKIT_USER_CONTENT_INJECT_TOP_FRAME,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitUserContentInjectedFrames> for UserContentInjectedFrames {
  unsafe fn from_glib(value: ffi::WebKitUserContentInjectedFrames) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_USER_CONTENT_INJECT_ALL_FRAMES => Self::AllFrames,
      ffi::WEBKIT_USER_CONTENT_INJECT_TOP_FRAME => Self::TopFrame,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl StaticType for UserContentInjectedFrames {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_user_content_injected_frames_get_type()) }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl glib::value::ValueType for UserContentInjectedFrames {
  type Type = Self;
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
unsafe impl<'a> FromValue<'a> for UserContentInjectedFrames {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl ToValue for UserContentInjectedFrames {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserMessageError")]
pub enum UserMessageError {
  #[doc(alias = "WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE")]
  Message,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl UserMessageError {
  #[doc(alias = "webkit_user_message_error_quark")]
  pub fn quark() -> glib::Quark {
    assert_initialized_main_thread!();
    unsafe { from_glib(ffi::webkit_user_message_error_quark()) }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl fmt::Display for UserMessageError {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "UserMessageError::{}",
      match *self {
        Self::Message => "Message",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[doc(hidden)]
impl IntoGlib for UserMessageError {
  type GlibType = ffi::WebKitUserMessageError;

  fn into_glib(self) -> ffi::WebKitUserMessageError {
    match self {
      Self::Message => ffi::WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitUserMessageError> for UserMessageError {
  unsafe fn from_glib(value: ffi::WebKitUserMessageError) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE => Self::Message,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl ErrorDomain for UserMessageError {
  fn domain() -> Quark {
    skip_assert_initialized!();

    static QUARK: once_cell::sync::Lazy<glib::ffi::GQuark> =
      once_cell::sync::Lazy::new(|| unsafe {
        glib::ffi::g_quark_from_static_string(b"WebKitUserMessageError\0".as_ptr() as *const _)
      });
    unsafe { from_glib(*QUARK) }
  }

  fn code(self) -> i32 {
    self.into_glib()
  }

  fn from(code: i32) -> Option<Self> {
    skip_assert_initialized!();
    match code {
      ffi::WEBKIT_USER_MESSAGE_UNHANDLED_MESSAGE => Some(Self::Message),
      value => Some(Self::__Unknown(value)),
    }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl StaticType for UserMessageError {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_user_message_error_get_type()) }
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl glib::value::ValueType for UserMessageError {
  type Type = Self;
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
unsafe impl<'a> FromValue<'a> for UserMessageError {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_28", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
impl ToValue for UserMessageError {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserScriptInjectionTime")]
pub enum UserScriptInjectionTime {
  #[doc(alias = "WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_START")]
  Start,
  #[doc(alias = "WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_END")]
  End,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl fmt::Display for UserScriptInjectionTime {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "UserScriptInjectionTime::{}",
      match *self {
        Self::Start => "Start",
        Self::End => "End",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[doc(hidden)]
impl IntoGlib for UserScriptInjectionTime {
  type GlibType = ffi::WebKitUserScriptInjectionTime;

  fn into_glib(self) -> ffi::WebKitUserScriptInjectionTime {
    match self {
      Self::Start => ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_START,
      Self::End => ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_END,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitUserScriptInjectionTime> for UserScriptInjectionTime {
  unsafe fn from_glib(value: ffi::WebKitUserScriptInjectionTime) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_START => Self::Start,
      ffi::WEBKIT_USER_SCRIPT_INJECT_AT_DOCUMENT_END => Self::End,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl StaticType for UserScriptInjectionTime {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_user_script_injection_time_get_type()) }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl glib::value::ValueType for UserScriptInjectionTime {
  type Type = Self;
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
unsafe impl<'a> FromValue<'a> for UserScriptInjectionTime {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl ToValue for UserScriptInjectionTime {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitUserStyleLevel")]
pub enum UserStyleLevel {
  #[doc(alias = "WEBKIT_USER_STYLE_LEVEL_USER")]
  User,
  #[doc(alias = "WEBKIT_USER_STYLE_LEVEL_AUTHOR")]
  Author,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl fmt::Display for UserStyleLevel {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "UserStyleLevel::{}",
      match *self {
        Self::User => "User",
        Self::Author => "Author",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[doc(hidden)]
impl IntoGlib for UserStyleLevel {
  type GlibType = ffi::WebKitUserStyleLevel;

  fn into_glib(self) -> ffi::WebKitUserStyleLevel {
    match self {
      Self::User => ffi::WEBKIT_USER_STYLE_LEVEL_USER,
      Self::Author => ffi::WEBKIT_USER_STYLE_LEVEL_AUTHOR,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitUserStyleLevel> for UserStyleLevel {
  unsafe fn from_glib(value: ffi::WebKitUserStyleLevel) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_USER_STYLE_LEVEL_USER => Self::User,
      ffi::WEBKIT_USER_STYLE_LEVEL_AUTHOR => Self::Author,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl StaticType for UserStyleLevel {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_user_style_level_get_type()) }
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl glib::value::ValueType for UserStyleLevel {
  type Type = Self;
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
unsafe impl<'a> FromValue<'a> for UserStyleLevel {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_6", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
impl ToValue for UserStyleLevel {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
#[derive(Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Clone, Copy)]
#[non_exhaustive]
#[doc(alias = "WebKitWebProcessTerminationReason")]
pub enum WebProcessTerminationReason {
  #[doc(alias = "WEBKIT_WEB_PROCESS_CRASHED")]
  Crashed,
  #[doc(alias = "WEBKIT_WEB_PROCESS_EXCEEDED_MEMORY_LIMIT")]
  ExceededMemoryLimit,
  #[doc(alias = "WEBKIT_WEB_PROCESS_TERMINATED_BY_API")]
  TerminatedByApi,
  #[doc(hidden)]
  __Unknown(i32),
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
impl fmt::Display for WebProcessTerminationReason {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    write!(
      f,
      "WebProcessTerminationReason::{}",
      match *self {
        Self::Crashed => "Crashed",
        Self::ExceededMemoryLimit => "ExceededMemoryLimit",
        Self::TerminatedByApi => "TerminatedByApi",
        _ => "Unknown",
      }
    )
  }
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
#[doc(hidden)]
impl IntoGlib for WebProcessTerminationReason {
  type GlibType = ffi::WebKitWebProcessTerminationReason;

  fn into_glib(self) -> ffi::WebKitWebProcessTerminationReason {
    match self {
      Self::Crashed => ffi::WEBKIT_WEB_PROCESS_CRASHED,
      Self::ExceededMemoryLimit => ffi::WEBKIT_WEB_PROCESS_EXCEEDED_MEMORY_LIMIT,
      Self::TerminatedByApi => ffi::WEBKIT_WEB_PROCESS_TERMINATED_BY_API,
      Self::__Unknown(value) => value,
    }
  }
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
#[doc(hidden)]
impl FromGlib<ffi::WebKitWebProcessTerminationReason> for WebProcessTerminationReason {
  unsafe fn from_glib(value: ffi::WebKitWebProcessTerminationReason) -> Self {
    skip_assert_initialized!();
    match value {
      ffi::WEBKIT_WEB_PROCESS_CRASHED => Self::Crashed,
      ffi::WEBKIT_WEB_PROCESS_EXCEEDED_MEMORY_LIMIT => Self::ExceededMemoryLimit,
      ffi::WEBKIT_WEB_PROCESS_TERMINATED_BY_API => Self::TerminatedByApi,
      value => Self::__Unknown(value),
    }
  }
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
impl StaticType for WebProcessTerminationReason {
  fn static_type() -> Type {
    unsafe { from_glib(ffi::webkit_web_process_termination_reason_get_type()) }
  }
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
impl glib::value::ValueType for WebProcessTerminationReason {
  type Type = Self;
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
unsafe impl<'a> FromValue<'a> for WebProcessTerminationReason {
  type Checker = glib::value::GenericValueTypeChecker<Self>;

  unsafe fn from_value(value: &'a glib::Value) -> Self {
    skip_assert_initialized!();
    from_glib(glib::gobject_ffi::g_value_get_enum(value.to_glib_none().0))
  }
}

#[cfg(any(feature = "v2_20", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_20")))]
impl ToValue for WebProcessTerminationReason {
  fn to_value(&self) -> glib::Value {
    let mut value = glib::Value::for_value_type::<Self>();
    unsafe {
      glib::gobject_ffi::g_value_set_enum(value.to_glib_none_mut().0, self.into_glib());
    }
    value
  }

  fn value_type(&self) -> glib::Type {
    Self::static_type()
  }
}
