// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/tauri-apps/gir-files)
// DO NOT EDIT

#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use crate::ApplicationInfo;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use crate::WebView;
use glib::object::Cast;
use glib::object::IsA;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use glib::signal::connect_raw;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use glib::signal::SignalHandlerId;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use std::boxed::Box as Box_;
use std::fmt;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "WebKitAutomationSession")]
    pub struct AutomationSession(Object<ffi::WebKitAutomationSession, ffi::WebKitAutomationSessionClass>);

    match fn {
        type_ => || ffi::webkit_automation_session_get_type(),
    }
}

impl AutomationSession {
  pub const NONE: Option<&'static AutomationSession> = None;

  // rustdoc-stripper-ignore-next
  /// Creates a new builder-pattern struct instance to construct [`AutomationSession`] objects.
  ///
  /// This method returns an instance of [`AutomationSessionBuilder`](crate::builders::AutomationSessionBuilder) which can be used to create [`AutomationSession`] objects.
  pub fn builder() -> AutomationSessionBuilder {
    AutomationSessionBuilder::default()
  }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`AutomationSession`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AutomationSessionBuilder {
  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  id: Option<String>,
}

impl AutomationSessionBuilder {
  // rustdoc-stripper-ignore-next
  /// Create a new [`AutomationSessionBuilder`].
  pub fn new() -> Self {
    Self::default()
  }

  // rustdoc-stripper-ignore-next
  /// Build the [`AutomationSession`].
  #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
  pub fn build(self) -> AutomationSession {
    let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
    #[cfg(any(feature = "v2_18", feature = "dox"))]
    if let Some(ref id) = self.id {
      properties.push(("id", id));
    }
    glib::Object::new::<AutomationSession>(&properties)
      .expect("Failed to create an instance of AutomationSession")
  }

  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  pub fn id(mut self, id: &str) -> Self {
    self.id = Some(id.to_string());
    self
  }
}

pub trait AutomationSessionExt: 'static {
  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  #[doc(alias = "webkit_automation_session_get_application_info")]
  #[doc(alias = "get_application_info")]
  fn application_info(&self) -> Option<ApplicationInfo>;

  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  #[doc(alias = "webkit_automation_session_get_id")]
  #[doc(alias = "get_id")]
  fn id(&self) -> Option<glib::GString>;

  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  #[doc(alias = "webkit_automation_session_set_application_info")]
  fn set_application_info(&self, info: &ApplicationInfo);

  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  #[doc(alias = "create-web-view")]
  fn connect_create_web_view<F: Fn(&Self) -> WebView + 'static>(
    &self,
    detail: Option<&str>,
    f: F,
  ) -> SignalHandlerId;
}

impl<O: IsA<AutomationSession>> AutomationSessionExt for O {
  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  fn application_info(&self) -> Option<ApplicationInfo> {
    unsafe {
      from_glib_none(ffi::webkit_automation_session_get_application_info(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  fn id(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_automation_session_get_id(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  fn set_application_info(&self, info: &ApplicationInfo) {
    unsafe {
      ffi::webkit_automation_session_set_application_info(
        self.as_ref().to_glib_none().0,
        info.to_glib_none().0,
      );
    }
  }

  #[cfg(any(feature = "v2_18", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
  fn connect_create_web_view<F: Fn(&Self) -> WebView + 'static>(
    &self,
    detail: Option<&str>,
    f: F,
  ) -> SignalHandlerId {
    unsafe extern "C" fn create_web_view_trampoline<
      P: IsA<AutomationSession>,
      F: Fn(&P) -> WebView + 'static,
    >(
      this: *mut ffi::WebKitAutomationSession,
      f: glib::ffi::gpointer,
    ) -> *mut ffi::WebKitWebView {
      let f: &F = &*(f as *const F);
      f(AutomationSession::from_glib_borrow(this).unsafe_cast_ref()) /*Not checked*/
        .to_glib_none()
        .0
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      let detailed_signal_name = detail.map(|name| format!("create-web-view::{}\0", name));
      let signal_name: &[u8] = detailed_signal_name
        .as_ref()
        .map_or(&b"create-web-view\0"[..], |n| n.as_bytes());
      connect_raw(
        self.as_ptr() as *mut _,
        signal_name.as_ptr() as *const _,
        Some(transmute::<_, unsafe extern "C" fn()>(
          create_web_view_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }
}

impl fmt::Display for AutomationSession {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    f.write_str("AutomationSession")
  }
}
