// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/vhdirk/gir-files.git)
// DO NOT EDIT

use glib::{
  object::{Cast, IsA},
  signal::{connect_raw, SignalHandlerId},
  translate::*,
  StaticType, ToValue,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "WebKitURIRequest")]
    pub struct URIRequest(Object<ffi::WebKitURIRequest, ffi::WebKitURIRequestClass>);

    match fn {
        type_ => || ffi::webkit_uri_request_get_type(),
    }
}

impl URIRequest {
  #[doc(alias = "webkit_uri_request_new")]
  pub fn new(uri: &str) -> URIRequest {
    assert_initialized_main_thread!();
    unsafe { from_glib_full(ffi::webkit_uri_request_new(uri.to_glib_none().0)) }
  }

  // rustdoc-stripper-ignore-next
  /// Creates a new builder-pattern struct instance to construct [`URIRequest`] objects.
  ///
  /// This method returns an instance of [`URIRequestBuilder`] which can be used to create [`URIRequest`] objects.
  pub fn builder() -> URIRequestBuilder {
    URIRequestBuilder::default()
  }
}

impl Default for URIRequest {
  fn default() -> Self {
    glib::object::Object::new::<Self>(&[])
      .expect("Can't construct URIRequest object with default parameters")
  }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`URIRequest`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
pub struct URIRequestBuilder {
  uri: Option<String>,
}

impl URIRequestBuilder {
  // rustdoc-stripper-ignore-next
  /// Create a new [`URIRequestBuilder`].
  pub fn new() -> Self {
    Self::default()
  }

  // rustdoc-stripper-ignore-next
  /// Build the [`URIRequest`].
  pub fn build(self) -> URIRequest {
    let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
    if let Some(ref uri) = self.uri {
      properties.push(("uri", uri));
    }
    glib::Object::new::<URIRequest>(&properties)
      .expect("Failed to create an instance of URIRequest")
  }

  pub fn uri(mut self, uri: &str) -> Self {
    self.uri = Some(uri.to_string());
    self
  }
}

pub const NONE_URI_REQUEST: Option<&URIRequest> = None;

pub trait URIRequestExt: 'static {
  //#[doc(alias = "webkit_uri_request_get_http_headers")]
  //#[doc(alias = "get_http_headers")]
  //fn http_headers(&self) -> /*Ignored*/Option<soup::MessageHeaders>;

  #[cfg(any(feature = "v2_12", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
  #[doc(alias = "webkit_uri_request_get_http_method")]
  #[doc(alias = "get_http_method")]
  fn http_method(&self) -> Option<glib::GString>;

  #[doc(alias = "webkit_uri_request_get_uri")]
  #[doc(alias = "get_uri")]
  fn uri(&self) -> Option<glib::GString>;

  #[doc(alias = "webkit_uri_request_set_uri")]
  fn set_uri(&self, uri: &str);

  #[doc(alias = "uri")]
  fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<URIRequest>> URIRequestExt for O {
  //fn http_headers(&self) -> /*Ignored*/Option<soup::MessageHeaders> {
  //    unsafe { TODO: call ffi:webkit_uri_request_get_http_headers() }
  //}

  #[cfg(any(feature = "v2_12", feature = "dox"))]
  #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
  fn http_method(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_uri_request_get_http_method(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  fn uri(&self) -> Option<glib::GString> {
    unsafe {
      from_glib_none(ffi::webkit_uri_request_get_uri(
        self.as_ref().to_glib_none().0,
      ))
    }
  }

  fn set_uri(&self, uri: &str) {
    unsafe {
      ffi::webkit_uri_request_set_uri(self.as_ref().to_glib_none().0, uri.to_glib_none().0);
    }
  }

  fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
    unsafe extern "C" fn notify_uri_trampoline<P: IsA<URIRequest>, F: Fn(&P) + 'static>(
      this: *mut ffi::WebKitURIRequest,
      _param_spec: glib::ffi::gpointer,
      f: glib::ffi::gpointer,
    ) {
      let f: &F = &*(f as *const F);
      f(URIRequest::from_glib_borrow(this).unsafe_cast_ref())
    }
    unsafe {
      let f: Box_<F> = Box_::new(f);
      connect_raw(
        self.as_ptr() as *mut _,
        b"notify::uri\0".as_ptr() as *const _,
        Some(transmute::<_, unsafe extern "C" fn()>(
          notify_uri_trampoline::<Self, F> as *const (),
        )),
        Box_::into_raw(f),
      )
    }
  }
}

impl fmt::Display for URIRequest {
  fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
    f.write_str("URIRequest")
  }
}
