// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "WebKitURIResponse")]
    pub struct URIResponse(Object<ffi::WebKitURIResponse, ffi::WebKitURIResponseClass>);

    match fn {
        type_ => || ffi::webkit_uri_response_get_type(),
    }
}

pub const NONE_URI_RESPONSE: Option<&URIResponse> = None;

pub trait URIResponseExt: 'static {
    #[doc(alias = "webkit_uri_response_get_content_length")]
    #[doc(alias = "get_content_length")]
    fn content_length(&self) -> u64;

    //#[cfg(any(feature = "v2_6", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
    //#[doc(alias = "webkit_uri_response_get_http_headers")]
    //#[doc(alias = "get_http_headers")]
    //fn http_headers(&self) -> /*Ignored*/Option<soup::MessageHeaders>;

    #[doc(alias = "webkit_uri_response_get_mime_type")]
    #[doc(alias = "get_mime_type")]
    fn mime_type(&self) -> Option<glib::GString>;

    #[doc(alias = "webkit_uri_response_get_status_code")]
    #[doc(alias = "get_status_code")]
    fn status_code(&self) -> u32;

    #[doc(alias = "webkit_uri_response_get_suggested_filename")]
    #[doc(alias = "get_suggested_filename")]
    fn suggested_filename(&self) -> Option<glib::GString>;

    #[doc(alias = "webkit_uri_response_get_uri")]
    #[doc(alias = "get_uri")]
    fn uri(&self) -> Option<glib::GString>;

    #[doc(alias = "content-length")]
    fn connect_content_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
    #[doc(alias = "http-headers")]
    fn connect_http_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mime-type")]
    fn connect_mime_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "status-code")]
    fn connect_status_code_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "suggested-filename")]
    fn connect_suggested_filename_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "uri")]
    fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<URIResponse>> URIResponseExt for O {
    fn content_length(&self) -> u64 {
        unsafe {
            ffi::webkit_uri_response_get_content_length(self.as_ref().to_glib_none().0)
        }
    }

    //#[cfg(any(feature = "v2_6", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
    //fn http_headers(&self) -> /*Ignored*/Option<soup::MessageHeaders> {
    //    unsafe { TODO: call ffi:webkit_uri_response_get_http_headers() }
    //}

    fn mime_type(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_uri_response_get_mime_type(self.as_ref().to_glib_none().0))
        }
    }

    fn status_code(&self) -> u32 {
        unsafe {
            ffi::webkit_uri_response_get_status_code(self.as_ref().to_glib_none().0)
        }
    }

    fn suggested_filename(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_uri_response_get_suggested_filename(self.as_ref().to_glib_none().0))
        }
    }

    fn uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::webkit_uri_response_get_uri(self.as_ref().to_glib_none().0))
        }
    }

    fn connect_content_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_content_length_trampoline<P: IsA<URIResponse>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitURIResponse, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(URIResponse::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::content-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_content_length_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_6", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_6")))]
    fn connect_http_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_http_headers_trampoline<P: IsA<URIResponse>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitURIResponse, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(URIResponse::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::http-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_http_headers_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_mime_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_mime_type_trampoline<P: IsA<URIResponse>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitURIResponse, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(URIResponse::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::mime-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_mime_type_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_status_code_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_status_code_trampoline<P: IsA<URIResponse>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitURIResponse, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(URIResponse::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::status-code\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_status_code_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_suggested_filename_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_suggested_filename_trampoline<P: IsA<URIResponse>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitURIResponse, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(URIResponse::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::suggested-filename\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_suggested_filename_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_uri_trampoline<P: IsA<URIResponse>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitURIResponse, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(URIResponse::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_uri_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for URIResponse {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("URIResponse")
    }
}
