// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::DOMNode;
use crate::DOMObject;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "WebKitDOMXPathResult")]
    pub struct DOMXPathResult(Object<ffi::WebKitDOMXPathResult, ffi::WebKitDOMXPathResultClass>) @extends DOMObject;

    match fn {
        type_ => || ffi::webkit_dom_xpath_result_get_type(),
    }
}

impl DOMXPathResult {
        pub const NONE: Option<&'static DOMXPathResult> = None;
    
}

pub trait DOMXPathResultExt: 'static {
    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_get_boolean_value")]
    #[doc(alias = "get_boolean_value")]
    fn boolean_value(&self) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_get_invalid_iterator_state")]
    #[doc(alias = "get_invalid_iterator_state")]
    fn is_invalid_iterator_state(&self) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_get_number_value")]
    #[doc(alias = "get_number_value")]
    fn number_value(&self) -> Result<f64, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_get_result_type")]
    #[doc(alias = "get_result_type")]
    fn result_type(&self) -> libc::c_ushort;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_get_single_node_value")]
    #[doc(alias = "get_single_node_value")]
    fn single_node_value(&self) -> Result<DOMNode, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_get_snapshot_length")]
    #[doc(alias = "get_snapshot_length")]
    fn snapshot_length(&self) -> Result<libc::c_ulong, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_get_string_value")]
    #[doc(alias = "get_string_value")]
    fn string_value(&self) -> Result<glib::GString, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_iterate_next")]
    fn iterate_next(&self) -> Result<DOMNode, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_xpath_result_snapshot_item")]
    fn snapshot_item(&self, index: libc::c_ulong) -> Result<DOMNode, glib::Error>;

    #[doc(alias = "boolean-value")]
    fn connect_boolean_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "invalid-iterator-state")]
    fn connect_invalid_iterator_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "number-value")]
    fn connect_number_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "result-type")]
    fn connect_result_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "single-node-value")]
    fn connect_single_node_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "snapshot-length")]
    fn connect_snapshot_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "string-value")]
    fn connect_string_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DOMXPathResult>> DOMXPathResultExt for O {
    fn boolean_value(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::webkit_dom_xpath_result_get_boolean_value(self.as_ref().to_glib_none().0, &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn is_invalid_iterator_state(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_xpath_result_get_invalid_iterator_state(self.as_ref().to_glib_none().0))
        }
    }

    fn number_value(&self) -> Result<f64, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_xpath_result_get_number_value(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(ret) } else { Err(from_glib_full(error)) }
        }
    }

    fn result_type(&self) -> libc::c_ushort {
        unsafe {
            ffi::webkit_dom_xpath_result_get_result_type(self.as_ref().to_glib_none().0)
        }
    }

    fn single_node_value(&self) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_xpath_result_get_single_node_value(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn snapshot_length(&self) -> Result<libc::c_ulong, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_xpath_result_get_snapshot_length(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(ret) } else { Err(from_glib_full(error)) }
        }
    }

    fn string_value(&self) -> Result<glib::GString, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_xpath_result_get_string_value(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn iterate_next(&self) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_xpath_result_iterate_next(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn snapshot_item(&self, index: libc::c_ulong) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_xpath_result_snapshot_item(self.as_ref().to_glib_none().0, index, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn connect_boolean_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_boolean_value_trampoline<P: IsA<DOMXPathResult>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMXPathResult, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMXPathResult::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::boolean-value\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_boolean_value_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_invalid_iterator_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invalid_iterator_state_trampoline<P: IsA<DOMXPathResult>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMXPathResult, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMXPathResult::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::invalid-iterator-state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_invalid_iterator_state_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_number_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_number_value_trampoline<P: IsA<DOMXPathResult>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMXPathResult, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMXPathResult::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::number-value\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_number_value_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_result_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_result_type_trampoline<P: IsA<DOMXPathResult>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMXPathResult, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMXPathResult::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::result-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_result_type_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_single_node_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_single_node_value_trampoline<P: IsA<DOMXPathResult>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMXPathResult, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMXPathResult::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::single-node-value\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_single_node_value_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_snapshot_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_snapshot_length_trampoline<P: IsA<DOMXPathResult>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMXPathResult, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMXPathResult::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::snapshot-length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_snapshot_length_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_string_value_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_string_value_trampoline<P: IsA<DOMXPathResult>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMXPathResult, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMXPathResult::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::string-value\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_string_value_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for DOMXPathResult {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DOMXPathResult")
    }
}
