// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::DOMAttr;
use crate::DOMCSSStyleDeclaration;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use crate::DOMClientRect;
#[cfg(any(feature = "v2_18", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
use crate::DOMClientRectList;
#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
use crate::DOMDOMTokenList;
use crate::DOMEventTarget;
use crate::DOMHTMLCollection;
use crate::DOMNamedNodeMap;
use crate::DOMNode;
use crate::DOMNodeList;
use crate::DOMObject;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "WebKitDOMElement")]
    pub struct DOMElement(Object<ffi::WebKitDOMElement, ffi::WebKitDOMElementClass>) @extends DOMNode, DOMObject, @implements DOMEventTarget;

    match fn {
        type_ => || ffi::webkit_dom_element_get_type(),
    }
}

impl DOMElement {
        pub const NONE: Option<&'static DOMElement> = None;
    
}

pub trait DOMElementExt: 'static {
    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_blur")]
    fn blur(&self);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_closest")]
    fn closest(&self, selectors: &str) -> Result<DOMElement, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_focus")]
    fn focus(&self);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_attribute")]
    #[doc(alias = "get_attribute")]
    fn attribute(&self, name: &str) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_attribute_node")]
    #[doc(alias = "get_attribute_node")]
    fn attribute_node(&self, name: &str) -> Option<DOMAttr>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_attribute_node_ns")]
    #[doc(alias = "get_attribute_node_ns")]
    fn attribute_node_ns(&self, namespaceURI: &str, localName: &str) -> Option<DOMAttr>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_attribute_ns")]
    #[doc(alias = "get_attribute_ns")]
    fn attribute_ns(&self, namespaceURI: &str, localName: &str) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_attributes")]
    #[doc(alias = "get_attributes")]
    fn attributes(&self) -> Option<DOMNamedNodeMap>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
    #[doc(alias = "webkit_dom_element_get_bounding_client_rect")]
    #[doc(alias = "get_bounding_client_rect")]
    fn bounding_client_rect(&self) -> Option<DOMClientRect>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_child_element_count")]
    #[doc(alias = "get_child_element_count")]
    fn child_element_count(&self) -> libc::c_ulong;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_10")))]
    #[doc(alias = "webkit_dom_element_get_children")]
    #[doc(alias = "get_children")]
    fn children(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_get_class_list")]
    #[doc(alias = "get_class_list")]
    fn class_list(&self) -> Option<DOMDOMTokenList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_class_name")]
    #[doc(alias = "get_class_name")]
    fn class_name(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_client_height")]
    #[doc(alias = "get_client_height")]
    fn client_height(&self) -> f64;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_client_left")]
    #[doc(alias = "get_client_left")]
    fn client_left(&self) -> f64;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
    #[doc(alias = "webkit_dom_element_get_client_rects")]
    #[doc(alias = "get_client_rects")]
    fn client_rects(&self) -> Option<DOMClientRectList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_client_top")]
    #[doc(alias = "get_client_top")]
    fn client_top(&self) -> f64;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_client_width")]
    #[doc(alias = "get_client_width")]
    fn client_width(&self) -> f64;

    #[cfg_attr(feature = "v2_12", deprecated = "Since 2.12")]
    #[doc(alias = "webkit_dom_element_get_elements_by_class_name")]
    #[doc(alias = "get_elements_by_class_name")]
    fn elements_by_class_name(&self, class_name: &str) -> Option<DOMNodeList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    #[doc(alias = "webkit_dom_element_get_elements_by_class_name_as_html_collection")]
    #[doc(alias = "get_elements_by_class_name_as_html_collection")]
    fn elements_by_class_name_as_html_collection(&self, name: &str) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_12", deprecated = "Since 2.12")]
    #[doc(alias = "webkit_dom_element_get_elements_by_tag_name")]
    #[doc(alias = "get_elements_by_tag_name")]
    fn elements_by_tag_name(&self, tag_name: &str) -> Option<DOMNodeList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    #[doc(alias = "webkit_dom_element_get_elements_by_tag_name_as_html_collection")]
    #[doc(alias = "get_elements_by_tag_name_as_html_collection")]
    fn elements_by_tag_name_as_html_collection(&self, name: &str) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_12", deprecated = "Since 2.12")]
    #[doc(alias = "webkit_dom_element_get_elements_by_tag_name_ns")]
    #[doc(alias = "get_elements_by_tag_name_ns")]
    fn elements_by_tag_name_ns(&self, namespace_uri: &str, tag_name: &str) -> Option<DOMNodeList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    #[doc(alias = "webkit_dom_element_get_elements_by_tag_name_ns_as_html_collection")]
    #[doc(alias = "get_elements_by_tag_name_ns_as_html_collection")]
    fn elements_by_tag_name_ns_as_html_collection(&self, namespaceURI: &str, localName: &str) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_first_element_child")]
    #[doc(alias = "get_first_element_child")]
#[must_use]
    fn first_element_child(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_id")]
    #[doc(alias = "get_id")]
    fn id(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    #[doc(alias = "webkit_dom_element_get_inner_html")]
    #[doc(alias = "get_inner_html")]
    fn inner_html(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_last_element_child")]
    #[doc(alias = "get_last_element_child")]
#[must_use]
    fn last_element_child(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_next_element_sibling")]
    #[doc(alias = "get_next_element_sibling")]
#[must_use]
    fn next_element_sibling(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_offset_height")]
    #[doc(alias = "get_offset_height")]
    fn offset_height(&self) -> f64;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_offset_left")]
    #[doc(alias = "get_offset_left")]
    fn offset_left(&self) -> f64;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_offset_parent")]
    #[doc(alias = "get_offset_parent")]
#[must_use]
    fn offset_parent(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_offset_top")]
    #[doc(alias = "get_offset_top")]
    fn offset_top(&self) -> f64;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_offset_width")]
    #[doc(alias = "get_offset_width")]
    fn offset_width(&self) -> f64;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    #[doc(alias = "webkit_dom_element_get_outer_html")]
    #[doc(alias = "get_outer_html")]
    fn outer_html(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_previous_element_sibling")]
    #[doc(alias = "get_previous_element_sibling")]
#[must_use]
    fn previous_element_sibling(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_scroll_height")]
    #[doc(alias = "get_scroll_height")]
    fn scroll_height(&self) -> libc::c_long;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_scroll_left")]
    #[doc(alias = "get_scroll_left")]
    fn scroll_left(&self) -> libc::c_long;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_scroll_top")]
    #[doc(alias = "get_scroll_top")]
    fn scroll_top(&self) -> libc::c_long;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_scroll_width")]
    #[doc(alias = "get_scroll_width")]
    fn scroll_width(&self) -> libc::c_long;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_style")]
    #[doc(alias = "get_style")]
    fn style(&self) -> Option<DOMCSSStyleDeclaration>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_get_tag_name")]
    #[doc(alias = "get_tag_name")]
    fn tag_name(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_20", deprecated = "Since 2.20")]
    #[doc(alias = "webkit_dom_element_get_webkit_region_overset")]
    #[doc(alias = "get_webkit_region_overset")]
    fn webkit_region_overset(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_has_attribute")]
    fn has_attribute(&self, name: &str) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_has_attribute_ns")]
    fn has_attribute_ns(&self, namespaceURI: &str, localName: &str) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_has_attributes")]
    fn has_attributes(&self) -> bool;

    #[doc(alias = "webkit_dom_element_html_input_element_get_auto_filled")]
    fn html_input_element_get_auto_filled(&self) -> bool;

    #[cfg(any(feature = "v2_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_22")))]
    #[doc(alias = "webkit_dom_element_html_input_element_is_user_edited")]
    fn html_input_element_is_user_edited(&self) -> bool;

    #[cfg(any(feature = "v2_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_22")))]
    #[doc(alias = "webkit_dom_element_html_input_element_set_auto_filled")]
    fn html_input_element_set_auto_filled(&self, auto_filled: bool);

    #[cfg(any(feature = "v2_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_22")))]
    #[doc(alias = "webkit_dom_element_html_input_element_set_editing_value")]
    fn html_input_element_set_editing_value(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_insert_adjacent_element")]
    fn insert_adjacent_element(&self, where_: &str, element: &impl IsA<DOMElement>) -> Result<DOMElement, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_insert_adjacent_html")]
    fn insert_adjacent_html(&self, where_: &str, html: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_insert_adjacent_text")]
    fn insert_adjacent_text(&self, where_: &str, text: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_matches")]
    fn matches(&self, selectors: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_query_selector")]
    fn query_selector(&self, selectors: &str) -> Result<Option<DOMElement>, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_query_selector_all")]
    fn query_selector_all(&self, selectors: &str) -> Result<DOMNodeList, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_remove")]
    fn remove(&self) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_remove_attribute")]
    fn remove_attribute(&self, name: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_remove_attribute_node")]
    fn remove_attribute_node(&self, oldAttr: &impl IsA<DOMAttr>) -> Result<DOMAttr, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_remove_attribute_ns")]
    fn remove_attribute_ns(&self, namespaceURI: &str, localName: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_request_pointer_lock")]
    fn request_pointer_lock(&self);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_scroll_by_lines")]
    fn scroll_by_lines(&self, lines: libc::c_long);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_scroll_by_pages")]
    fn scroll_by_pages(&self, pages: libc::c_long);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_scroll_into_view")]
    fn scroll_into_view(&self, alignWithTop: bool);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_scroll_into_view_if_needed")]
    fn scroll_into_view_if_needed(&self, centerIfNeeded: bool);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_attribute")]
    fn set_attribute(&self, name: &str, value: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_attribute_node")]
    fn set_attribute_node(&self, newAttr: &impl IsA<DOMAttr>) -> Result<DOMAttr, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_attribute_node_ns")]
    fn set_attribute_node_ns(&self, newAttr: &impl IsA<DOMAttr>) -> Result<DOMAttr, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_attribute_ns")]
    fn set_attribute_ns(&self, namespaceURI: Option<&str>, qualifiedName: &str, value: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_class_name")]
    fn set_class_name(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_id")]
    fn set_id(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    #[doc(alias = "webkit_dom_element_set_inner_html")]
    fn set_inner_html(&self, value: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    #[doc(alias = "webkit_dom_element_set_outer_html")]
    fn set_outer_html(&self, value: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_scroll_left")]
    fn set_scroll_left(&self, value: libc::c_long);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_element_set_scroll_top")]
    fn set_scroll_top(&self, value: libc::c_long);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_webkit_matches_selector")]
    fn webkit_matches_selector(&self, selectors: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_element_webkit_request_fullscreen")]
    fn webkit_request_fullscreen(&self);

    fn get_property_children(&self) -> Option<DOMHTMLCollection>;

    #[doc(alias = "inner-html")]
    fn get_property_inner_html(&self) -> Option<glib::GString>;

    #[doc(alias = "inner-html")]
    fn set_property_inner_html(&self, inner_html: Option<&str>);

    #[doc(alias = "outer-html")]
    fn get_property_outer_html(&self) -> Option<glib::GString>;

    #[doc(alias = "outer-html")]
    fn set_property_outer_html(&self, outer_html: Option<&str>);

    #[doc(alias = "attributes")]
    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "child-element-count")]
    fn connect_child_element_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "children")]
    fn connect_children_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "class-list")]
    fn connect_class_list_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "class-name")]
    fn connect_class_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "client-height")]
    fn connect_client_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "client-left")]
    fn connect_client_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "client-top")]
    fn connect_client_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "client-width")]
    fn connect_client_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "first-element-child")]
    fn connect_first_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "id")]
    fn connect_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "inner-html")]
    fn connect_inner_html_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "last-element-child")]
    fn connect_last_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "local-name")]
    fn connect_local_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "namespace-uri")]
    fn connect_namespace_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "next-element-sibling")]
    fn connect_next_element_sibling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "offset-height")]
    fn connect_offset_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "offset-left")]
    fn connect_offset_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "offset-parent")]
    fn connect_offset_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "offset-top")]
    fn connect_offset_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "offset-width")]
    fn connect_offset_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "outer-html")]
    fn connect_outer_html_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "prefix")]
    fn connect_prefix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "previous-element-sibling")]
    fn connect_previous_element_sibling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scroll-height")]
    fn connect_scroll_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scroll-left")]
    fn connect_scroll_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scroll-top")]
    fn connect_scroll_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scroll-width")]
    fn connect_scroll_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style")]
    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tag-name")]
    fn connect_tag_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "webkit-region-overset")]
    fn connect_webkit_region_overset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DOMElement>> DOMElementExt for O {
    fn blur(&self) {
        unsafe {
            ffi::webkit_dom_element_blur(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn closest(&self, selectors: &str) -> Result<DOMElement, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_element_closest(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn focus(&self) {
        unsafe {
            ffi::webkit_dom_element_focus(self.as_ref().to_glib_none().0);
        }
    }

    fn attribute(&self, name: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_attribute(self.as_ref().to_glib_none().0, name.to_glib_none().0))
        }
    }

    fn attribute_node(&self, name: &str) -> Option<DOMAttr> {
        unsafe {
            from_glib_none(ffi::webkit_dom_element_get_attribute_node(self.as_ref().to_glib_none().0, name.to_glib_none().0))
        }
    }

    fn attribute_node_ns(&self, namespaceURI: &str, localName: &str) -> Option<DOMAttr> {
        unsafe {
            from_glib_none(ffi::webkit_dom_element_get_attribute_node_ns(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, localName.to_glib_none().0))
        }
    }

    fn attribute_ns(&self, namespaceURI: &str, localName: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_attribute_ns(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, localName.to_glib_none().0))
        }
    }

    fn attributes(&self) -> Option<DOMNamedNodeMap> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_attributes(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
    fn bounding_client_rect(&self) -> Option<DOMClientRect> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_bounding_client_rect(self.as_ref().to_glib_none().0))
        }
    }

    fn child_element_count(&self) -> libc::c_ulong {
        unsafe {
            ffi::webkit_dom_element_get_child_element_count(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v2_10", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_10")))]
    fn children(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_children(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn class_list(&self) -> Option<DOMDOMTokenList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_class_list(self.as_ref().to_glib_none().0))
        }
    }

    fn class_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_class_name(self.as_ref().to_glib_none().0))
        }
    }

    fn client_height(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_client_height(self.as_ref().to_glib_none().0)
        }
    }

    fn client_left(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_client_left(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v2_18", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_18")))]
    fn client_rects(&self) -> Option<DOMClientRectList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_client_rects(self.as_ref().to_glib_none().0))
        }
    }

    fn client_top(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_client_top(self.as_ref().to_glib_none().0)
        }
    }

    fn client_width(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_client_width(self.as_ref().to_glib_none().0)
        }
    }

    fn elements_by_class_name(&self, class_name: &str) -> Option<DOMNodeList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_elements_by_class_name(self.as_ref().to_glib_none().0, class_name.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    fn elements_by_class_name_as_html_collection(&self, name: &str) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_elements_by_class_name_as_html_collection(self.as_ref().to_glib_none().0, name.to_glib_none().0))
        }
    }

    fn elements_by_tag_name(&self, tag_name: &str) -> Option<DOMNodeList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_elements_by_tag_name(self.as_ref().to_glib_none().0, tag_name.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    fn elements_by_tag_name_as_html_collection(&self, name: &str) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_elements_by_tag_name_as_html_collection(self.as_ref().to_glib_none().0, name.to_glib_none().0))
        }
    }

    fn elements_by_tag_name_ns(&self, namespace_uri: &str, tag_name: &str) -> Option<DOMNodeList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_elements_by_tag_name_ns(self.as_ref().to_glib_none().0, namespace_uri.to_glib_none().0, tag_name.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    fn elements_by_tag_name_ns_as_html_collection(&self, namespaceURI: &str, localName: &str) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_elements_by_tag_name_ns_as_html_collection(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, localName.to_glib_none().0))
        }
    }

    fn first_element_child(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_element_get_first_element_child(self.as_ref().to_glib_none().0))
        }
    }

    fn id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_id(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    fn inner_html(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_inner_html(self.as_ref().to_glib_none().0))
        }
    }

    fn last_element_child(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_element_get_last_element_child(self.as_ref().to_glib_none().0))
        }
    }

    fn next_element_sibling(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_element_get_next_element_sibling(self.as_ref().to_glib_none().0))
        }
    }

    fn offset_height(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_offset_height(self.as_ref().to_glib_none().0)
        }
    }

    fn offset_left(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_offset_left(self.as_ref().to_glib_none().0)
        }
    }

    fn offset_parent(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_element_get_offset_parent(self.as_ref().to_glib_none().0))
        }
    }

    fn offset_top(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_offset_top(self.as_ref().to_glib_none().0)
        }
    }

    fn offset_width(&self) -> f64 {
        unsafe {
            ffi::webkit_dom_element_get_offset_width(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    fn outer_html(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_outer_html(self.as_ref().to_glib_none().0))
        }
    }

    fn previous_element_sibling(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_element_get_previous_element_sibling(self.as_ref().to_glib_none().0))
        }
    }

    fn scroll_height(&self) -> libc::c_long {
        unsafe {
            ffi::webkit_dom_element_get_scroll_height(self.as_ref().to_glib_none().0)
        }
    }

    fn scroll_left(&self) -> libc::c_long {
        unsafe {
            ffi::webkit_dom_element_get_scroll_left(self.as_ref().to_glib_none().0)
        }
    }

    fn scroll_top(&self) -> libc::c_long {
        unsafe {
            ffi::webkit_dom_element_get_scroll_top(self.as_ref().to_glib_none().0)
        }
    }

    fn scroll_width(&self) -> libc::c_long {
        unsafe {
            ffi::webkit_dom_element_get_scroll_width(self.as_ref().to_glib_none().0)
        }
    }

    fn style(&self) -> Option<DOMCSSStyleDeclaration> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_style(self.as_ref().to_glib_none().0))
        }
    }

    fn tag_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_tag_name(self.as_ref().to_glib_none().0))
        }
    }

    fn webkit_region_overset(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_element_get_webkit_region_overset(self.as_ref().to_glib_none().0))
        }
    }

    fn has_attribute(&self, name: &str) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_element_has_attribute(self.as_ref().to_glib_none().0, name.to_glib_none().0))
        }
    }

    fn has_attribute_ns(&self, namespaceURI: &str, localName: &str) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_element_has_attribute_ns(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, localName.to_glib_none().0))
        }
    }

    fn has_attributes(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_element_has_attributes(self.as_ref().to_glib_none().0))
        }
    }

    fn html_input_element_get_auto_filled(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_element_html_input_element_get_auto_filled(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_22")))]
    fn html_input_element_is_user_edited(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_element_html_input_element_is_user_edited(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_22")))]
    fn html_input_element_set_auto_filled(&self, auto_filled: bool) {
        unsafe {
            ffi::webkit_dom_element_html_input_element_set_auto_filled(self.as_ref().to_glib_none().0, auto_filled.into_glib());
        }
    }

    #[cfg(any(feature = "v2_22", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_22")))]
    fn html_input_element_set_editing_value(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_element_html_input_element_set_editing_value(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn insert_adjacent_element(&self, where_: &str, element: &impl IsA<DOMElement>) -> Result<DOMElement, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_element_insert_adjacent_element(self.as_ref().to_glib_none().0, where_.to_glib_none().0, element.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn insert_adjacent_html(&self, where_: &str, html: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_element_insert_adjacent_html(self.as_ref().to_glib_none().0, where_.to_glib_none().0, html.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn insert_adjacent_text(&self, where_: &str, text: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_element_insert_adjacent_text(self.as_ref().to_glib_none().0, where_.to_glib_none().0, text.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn matches(&self, selectors: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::webkit_dom_element_matches(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn query_selector(&self, selectors: &str) -> Result<Option<DOMElement>, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_element_query_selector(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn query_selector_all(&self, selectors: &str) -> Result<DOMNodeList, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_element_query_selector_all(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn remove(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_element_remove(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn remove_attribute(&self, name: &str) {
        unsafe {
            ffi::webkit_dom_element_remove_attribute(self.as_ref().to_glib_none().0, name.to_glib_none().0);
        }
    }

    fn remove_attribute_node(&self, oldAttr: &impl IsA<DOMAttr>) -> Result<DOMAttr, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_element_remove_attribute_node(self.as_ref().to_glib_none().0, oldAttr.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn remove_attribute_ns(&self, namespaceURI: &str, localName: &str) {
        unsafe {
            ffi::webkit_dom_element_remove_attribute_ns(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, localName.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn request_pointer_lock(&self) {
        unsafe {
            ffi::webkit_dom_element_request_pointer_lock(self.as_ref().to_glib_none().0);
        }
    }

    fn scroll_by_lines(&self, lines: libc::c_long) {
        unsafe {
            ffi::webkit_dom_element_scroll_by_lines(self.as_ref().to_glib_none().0, lines);
        }
    }

    fn scroll_by_pages(&self, pages: libc::c_long) {
        unsafe {
            ffi::webkit_dom_element_scroll_by_pages(self.as_ref().to_glib_none().0, pages);
        }
    }

    fn scroll_into_view(&self, alignWithTop: bool) {
        unsafe {
            ffi::webkit_dom_element_scroll_into_view(self.as_ref().to_glib_none().0, alignWithTop.into_glib());
        }
    }

    fn scroll_into_view_if_needed(&self, centerIfNeeded: bool) {
        unsafe {
            ffi::webkit_dom_element_scroll_into_view_if_needed(self.as_ref().to_glib_none().0, centerIfNeeded.into_glib());
        }
    }

    fn set_attribute(&self, name: &str, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_element_set_attribute(self.as_ref().to_glib_none().0, name.to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_node(&self, newAttr: &impl IsA<DOMAttr>) -> Result<DOMAttr, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_element_set_attribute_node(self.as_ref().to_glib_none().0, newAttr.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_node_ns(&self, newAttr: &impl IsA<DOMAttr>) -> Result<DOMAttr, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_element_set_attribute_node_ns(self.as_ref().to_glib_none().0, newAttr.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_ns(&self, namespaceURI: Option<&str>, qualifiedName: &str, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_element_set_attribute_ns(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, qualifiedName.to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_class_name(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_element_set_class_name(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    fn set_id(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_element_set_id(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    fn set_inner_html(&self, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_element_set_inner_html(self.as_ref().to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_8", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_8")))]
    fn set_outer_html(&self, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_element_set_outer_html(self.as_ref().to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_scroll_left(&self, value: libc::c_long) {
        unsafe {
            ffi::webkit_dom_element_set_scroll_left(self.as_ref().to_glib_none().0, value);
        }
    }

    fn set_scroll_top(&self, value: libc::c_long) {
        unsafe {
            ffi::webkit_dom_element_set_scroll_top(self.as_ref().to_glib_none().0, value);
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn webkit_matches_selector(&self, selectors: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::webkit_dom_element_webkit_matches_selector(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn webkit_request_fullscreen(&self) {
        unsafe {
            ffi::webkit_dom_element_webkit_request_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    fn get_property_children(&self) -> Option<DOMHTMLCollection> {
        glib::ObjectExt::property(self.as_ref(), "children")
    }

    fn get_property_inner_html(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "inner-html")
    }

    fn set_property_inner_html(&self, inner_html: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"inner-html", &inner_html)
    }

    fn get_property_outer_html(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "outer-html")
    }

    fn set_property_outer_html(&self, outer_html: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"outer-html", &outer_html)
    }

    fn connect_attributes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_attributes_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::attributes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_attributes_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_child_element_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_element_count_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::child-element-count\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_child_element_count_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_children_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_children_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::children\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_children_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn connect_class_list_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_class_list_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::class-list\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_class_list_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_class_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_class_name_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::class-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_class_name_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_client_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_client_height_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::client-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_client_height_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_client_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_client_left_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::client-left\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_client_left_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_client_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_client_top_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::client-top\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_client_top_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_client_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_client_width_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::client-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_client_width_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_first_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_first_element_child_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::first-element-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_first_element_child_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_id_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::id\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_id_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_inner_html_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_inner_html_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::inner-html\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_inner_html_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_last_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_last_element_child_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::last-element-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_last_element_child_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_local_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_local_name_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::local-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_local_name_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_namespace_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_namespace_uri_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::namespace-uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_namespace_uri_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_next_element_sibling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_next_element_sibling_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::next-element-sibling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_next_element_sibling_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_offset_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_offset_height_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::offset-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_offset_height_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_offset_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_offset_left_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::offset-left\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_offset_left_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_offset_parent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_offset_parent_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::offset-parent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_offset_parent_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_offset_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_offset_top_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::offset-top\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_offset_top_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_offset_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_offset_width_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::offset-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_offset_width_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_outer_html_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_outer_html_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::outer-html\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_outer_html_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_prefix_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_prefix_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::prefix\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_prefix_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_previous_element_sibling_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_previous_element_sibling_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::previous-element-sibling\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_previous_element_sibling_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scroll_height_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_height_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::scroll-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_scroll_height_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scroll_left_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_left_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::scroll-left\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_scroll_left_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scroll_top_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_top_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::scroll-top\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_scroll_top_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scroll_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scroll_width_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::scroll-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_scroll_width_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_style_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_tag_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tag_name_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::tag-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_tag_name_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_webkit_region_overset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_webkit_region_overset_trampoline<P: IsA<DOMElement>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMElement, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMElement::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::webkit-region-overset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_webkit_region_overset_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for DOMElement {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DOMElement")
    }
}
