// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::DOMAttr;
use crate::DOMCDATASection;
use crate::DOMCSSStyleDeclaration;
use crate::DOMComment;
use crate::DOMDOMImplementation;
use crate::DOMDOMWindow;
#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
use crate::DOMDocumentFragment;
use crate::DOMDocumentType;
use crate::DOMElement;
use crate::DOMEntityReference;
use crate::DOMEvent;
use crate::DOMEventTarget;
use crate::DOMHTMLCollection;
use crate::DOMHTMLElement;
use crate::DOMHTMLHeadElement;
use crate::DOMHTMLScriptElement;
use crate::DOMNode;
use crate::DOMNodeList;
use crate::DOMObject;
use crate::DOMProcessingInstruction;
use crate::DOMRange;
use crate::DOMStyleSheetList;
use crate::DOMText;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "WebKitDOMDocument")]
    pub struct DOMDocument(Object<ffi::WebKitDOMDocument, ffi::WebKitDOMDocumentClass>) @extends DOMNode, DOMObject, @implements DOMEventTarget;

    match fn {
        type_ => || ffi::webkit_dom_document_get_type(),
    }
}

impl DOMDocument {
        pub const NONE: Option<&'static DOMDocument> = None;
    
}

pub trait DOMDocumentExt: 'static {
    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_adopt_node")]
    fn adopt_node(&self, source: &impl IsA<DOMNode>) -> Result<DOMNode, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_caret_range_from_point")]
    fn caret_range_from_point(&self, x: libc::c_long, y: libc::c_long) -> Option<DOMRange>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_attribute")]
    fn create_attribute(&self, name: &str) -> Result<DOMAttr, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_attribute_ns")]
    fn create_attribute_ns(&self, namespaceURI: Option<&str>, qualifiedName: &str) -> Result<DOMAttr, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_cdata_section")]
    fn create_cdata_section(&self, data: &str) -> Result<DOMCDATASection, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_comment")]
    fn create_comment(&self, data: &str) -> Option<DOMComment>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_css_style_declaration")]
    fn create_css_style_declaration(&self) -> Option<DOMCSSStyleDeclaration>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_create_document_fragment")]
    fn create_document_fragment(&self) -> Option<DOMDocumentFragment>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_element")]
    fn create_element(&self, tagName: &str) -> Result<DOMElement, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_element_ns")]
    fn create_element_ns(&self, namespaceURI: Option<&str>, qualifiedName: &str) -> Result<DOMElement, glib::Error>;

    #[cfg_attr(feature = "v2_12", deprecated = "Since 2.12")]
    #[doc(alias = "webkit_dom_document_create_entity_reference")]
    fn create_entity_reference(&self, name: Option<&str>) -> Result<DOMEntityReference, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_event")]
    fn create_event(&self, eventType: &str) -> Result<DOMEvent, glib::Error>;

    //#[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    //#[doc(alias = "webkit_dom_document_create_expression")]
    //fn create_expression(&self, expression: &str, resolver: /*Ignored*/&DOMXPathNSResolver) -> Result<DOMXPathExpression, glib::Error>;

    //#[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    //#[doc(alias = "webkit_dom_document_create_node_iterator")]
    //fn create_node_iterator(&self, root: &impl IsA<DOMNode>, whatToShow: libc::c_ulong, filter: /*Ignored*/Option<&DOMNodeFilter>, expandEntityReferences: bool) -> Result<DOMNodeIterator, glib::Error>;

    //#[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    //#[doc(alias = "webkit_dom_document_create_ns_resolver")]
    //fn create_ns_resolver(&self, nodeResolver: &impl IsA<DOMNode>) -> /*Ignored*/Option<DOMXPathNSResolver>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_processing_instruction")]
    fn create_processing_instruction(&self, target: &str, data: &str) -> Result<DOMProcessingInstruction, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_range")]
    fn create_range(&self) -> Option<DOMRange>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_create_text_node")]
    fn create_text_node(&self, data: &str) -> Option<DOMText>;

    //#[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    //#[doc(alias = "webkit_dom_document_create_tree_walker")]
    //fn create_tree_walker(&self, root: &impl IsA<DOMNode>, whatToShow: libc::c_ulong, filter: /*Ignored*/Option<&DOMNodeFilter>, expandEntityReferences: bool) -> Result<DOMTreeWalker, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_element_from_point")]
    fn element_from_point(&self, x: libc::c_long, y: libc::c_long) -> Option<DOMElement>;

    //#[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    //#[doc(alias = "webkit_dom_document_evaluate")]
    //fn evaluate(&self, expression: &str, contextNode: &impl IsA<DOMNode>, resolver: /*Ignored*/Option<&DOMXPathNSResolver>, type_: libc::c_ushort, inResult: Option<&impl IsA<DOMXPathResult>>) -> Result<DOMXPathResult, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_exec_command")]
    fn exec_command(&self, command: &str, userInterface: bool, value: &str) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_exit_pointer_lock")]
    fn exit_pointer_lock(&self);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_active_element")]
    #[doc(alias = "get_active_element")]
    fn active_element(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_anchors")]
    #[doc(alias = "get_anchors")]
    fn anchors(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_applets")]
    #[doc(alias = "get_applets")]
    fn applets(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_body")]
    #[doc(alias = "get_body")]
    fn body(&self) -> Option<DOMHTMLElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_character_set")]
    #[doc(alias = "get_character_set")]
    fn character_set(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_charset")]
    #[doc(alias = "get_charset")]
    fn charset(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_child_element_count")]
    #[doc(alias = "get_child_element_count")]
    fn child_element_count(&self) -> libc::c_ulong;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_children")]
    #[doc(alias = "get_children")]
    fn children(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    #[doc(alias = "webkit_dom_document_get_compat_mode")]
    #[doc(alias = "get_compat_mode")]
    fn compat_mode(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_content_type")]
    #[doc(alias = "get_content_type")]
    fn content_type(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_cookie")]
    #[doc(alias = "get_cookie")]
    fn cookie(&self) -> Result<glib::GString, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_current_script")]
    #[doc(alias = "get_current_script")]
    fn current_script(&self) -> Option<DOMHTMLScriptElement>;

    #[cfg_attr(feature = "v2_14", deprecated = "Since 2.14")]
    #[doc(alias = "webkit_dom_document_get_default_charset")]
    #[doc(alias = "get_default_charset")]
    fn default_charset(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_default_view")]
    #[doc(alias = "get_default_view")]
    fn default_view(&self) -> Option<DOMDOMWindow>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    #[doc(alias = "webkit_dom_document_get_design_mode")]
    #[doc(alias = "get_design_mode")]
    fn design_mode(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_dir")]
    #[doc(alias = "get_dir")]
    fn dir(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_doctype")]
    #[doc(alias = "get_doctype")]
    fn doctype(&self) -> Option<DOMDocumentType>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_document_element")]
    #[doc(alias = "get_document_element")]
    fn document_element(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_document_uri")]
    #[doc(alias = "get_document_uri")]
    fn document_uri(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_domain")]
    #[doc(alias = "get_domain")]
    fn domain(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_element_by_id")]
    #[doc(alias = "get_element_by_id")]
    fn element_by_id(&self, elementId: &str) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_12", deprecated = "Since 2.12")]
    #[doc(alias = "webkit_dom_document_get_elements_by_class_name")]
    #[doc(alias = "get_elements_by_class_name")]
    fn elements_by_class_name(&self, class_name: &str) -> Option<DOMNodeList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    #[doc(alias = "webkit_dom_document_get_elements_by_class_name_as_html_collection")]
    #[doc(alias = "get_elements_by_class_name_as_html_collection")]
    fn elements_by_class_name_as_html_collection(&self, classNames: &str) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_elements_by_name")]
    #[doc(alias = "get_elements_by_name")]
    fn elements_by_name(&self, elementName: &str) -> Option<DOMNodeList>;

    #[cfg_attr(feature = "v2_12", deprecated = "Since 2.12")]
    #[doc(alias = "webkit_dom_document_get_elements_by_tag_name")]
    #[doc(alias = "get_elements_by_tag_name")]
    fn elements_by_tag_name(&self, tag_name: &str) -> Option<DOMNodeList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    #[doc(alias = "webkit_dom_document_get_elements_by_tag_name_as_html_collection")]
    #[doc(alias = "get_elements_by_tag_name_as_html_collection")]
    fn elements_by_tag_name_as_html_collection(&self, tagname: &str) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_12", deprecated = "Since 2.12")]
    #[doc(alias = "webkit_dom_document_get_elements_by_tag_name_ns")]
    #[doc(alias = "get_elements_by_tag_name_ns")]
    fn elements_by_tag_name_ns(&self, namespace_uri: &str, tag_name: &str) -> Option<DOMNodeList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    #[doc(alias = "webkit_dom_document_get_elements_by_tag_name_ns_as_html_collection")]
    #[doc(alias = "get_elements_by_tag_name_ns_as_html_collection")]
    fn elements_by_tag_name_ns_as_html_collection(&self, namespaceURI: &str, localName: &str) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    #[doc(alias = "webkit_dom_document_get_embeds")]
    #[doc(alias = "get_embeds")]
    fn embeds(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_first_element_child")]
    #[doc(alias = "get_first_element_child")]
    fn first_element_child(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_forms")]
    #[doc(alias = "get_forms")]
    fn forms(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_head")]
    #[doc(alias = "get_head")]
    fn head(&self) -> Option<DOMHTMLHeadElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_hidden")]
    #[doc(alias = "get_hidden")]
    fn is_hidden(&self) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_images")]
    #[doc(alias = "get_images")]
    fn images(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_implementation")]
    #[doc(alias = "get_implementation")]
    fn implementation(&self) -> Option<DOMDOMImplementation>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_input_encoding")]
    #[doc(alias = "get_input_encoding")]
    fn input_encoding(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_last_element_child")]
    #[doc(alias = "get_last_element_child")]
    fn last_element_child(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_last_modified")]
    #[doc(alias = "get_last_modified")]
    fn last_modified(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_links")]
    #[doc(alias = "get_links")]
    fn links(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_origin")]
    #[doc(alias = "get_origin")]
    fn origin(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_override_style")]
    #[doc(alias = "get_override_style")]
    fn override_style(&self, element: &impl IsA<DOMElement>, pseudoElement: Option<&str>) -> Option<DOMCSSStyleDeclaration>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    #[doc(alias = "webkit_dom_document_get_plugins")]
    #[doc(alias = "get_plugins")]
    fn plugins(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_pointer_lock_element")]
    #[doc(alias = "get_pointer_lock_element")]
    fn pointer_lock_element(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_preferred_stylesheet_set")]
    #[doc(alias = "get_preferred_stylesheet_set")]
    fn preferred_stylesheet_set(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_ready_state")]
    #[doc(alias = "get_ready_state")]
    fn ready_state(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_referrer")]
    #[doc(alias = "get_referrer")]
    fn referrer(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    #[doc(alias = "webkit_dom_document_get_scripts")]
    #[doc(alias = "get_scripts")]
    fn scripts(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_scrolling_element")]
    #[doc(alias = "get_scrolling_element")]
    fn scrolling_element(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_selected_stylesheet_set")]
    #[doc(alias = "get_selected_stylesheet_set")]
    fn selected_stylesheet_set(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_style_sheets")]
    #[doc(alias = "get_style_sheets")]
    fn style_sheets(&self) -> Option<DOMStyleSheetList>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_title")]
    #[doc(alias = "get_title")]
    fn title(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_url")]
    #[doc(alias = "get_url")]
    fn url(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_visibility_state")]
    #[doc(alias = "get_visibility_state")]
    fn visibility_state(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_webkit_current_fullscreen_element")]
    #[doc(alias = "get_webkit_current_fullscreen_element")]
    fn webkit_current_fullscreen_element(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_webkit_fullscreen_element")]
    #[doc(alias = "get_webkit_fullscreen_element")]
    fn webkit_fullscreen_element(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_webkit_fullscreen_enabled")]
    #[doc(alias = "get_webkit_fullscreen_enabled")]
    fn is_webkit_fullscreen_enabled(&self) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_webkit_fullscreen_keyboard_input_allowed")]
    #[doc(alias = "get_webkit_fullscreen_keyboard_input_allowed")]
    fn is_webkit_fullscreen_keyboard_input_allowed(&self) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_get_webkit_is_fullscreen")]
    #[doc(alias = "get_webkit_is_fullscreen")]
    fn is_webkit_is_fullscreen(&self) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_xml_encoding")]
    #[doc(alias = "get_xml_encoding")]
    fn xml_encoding(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_xml_standalone")]
    #[doc(alias = "get_xml_standalone")]
    fn is_xml_standalone(&self) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_get_xml_version")]
    #[doc(alias = "get_xml_version")]
    fn xml_version(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_has_focus")]
    fn has_focus(&self) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_import_node")]
    fn import_node(&self, importedNode: &impl IsA<DOMNode>, deep: bool) -> Result<DOMNode, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_query_command_enabled")]
    fn query_command_enabled(&self, command: &str) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_query_command_indeterm")]
    fn query_command_indeterm(&self, command: &str) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_query_command_state")]
    fn query_command_state(&self, command: &str) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_query_command_supported")]
    fn query_command_supported(&self, command: &str) -> bool;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_query_command_value")]
    fn query_command_value(&self, command: &str) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_query_selector")]
    fn query_selector(&self, selectors: &str) -> Result<DOMElement, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_query_selector_all")]
    fn query_selector_all(&self, selectors: &str) -> Result<DOMNodeList, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_body")]
    fn set_body(&self, value: &impl IsA<DOMHTMLElement>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_charset")]
    fn set_charset(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_cookie")]
    fn set_cookie(&self, value: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    #[doc(alias = "webkit_dom_document_set_design_mode")]
    fn set_design_mode(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_set_dir")]
    fn set_dir(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_document_uri")]
    fn set_document_uri(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_selected_stylesheet_set")]
    fn set_selected_stylesheet_set(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_title")]
    fn set_title(&self, value: &str);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_xml_standalone")]
    fn set_xml_standalone(&self, value: bool) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_document_set_xml_version")]
    fn set_xml_version(&self, value: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_webkit_cancel_fullscreen")]
    fn webkit_cancel_fullscreen(&self);

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_webkit_exit_fullscreen")]
    fn webkit_exit_fullscreen(&self);

    #[doc(alias = "child-element-count")]
    fn get_property_child_element_count(&self) -> libc::c_ulong;

    fn get_property_children(&self) -> Option<DOMHTMLCollection>;

    #[doc(alias = "compat-mode")]
    fn get_property_compat_mode(&self) -> Option<glib::GString>;

    #[doc(alias = "content-type")]
    fn get_property_content_type(&self) -> Option<glib::GString>;

    #[doc(alias = "current-script")]
    fn get_property_current_script(&self) -> Option<DOMHTMLScriptElement>;

    #[doc(alias = "design-mode")]
    fn get_property_design_mode(&self) -> Option<glib::GString>;

    #[doc(alias = "design-mode")]
    fn set_property_design_mode(&self, design_mode: Option<&str>);

    fn get_property_dir(&self) -> Option<glib::GString>;

    fn set_property_dir(&self, dir: Option<&str>);

    fn get_property_embeds(&self) -> Option<DOMHTMLCollection>;

    #[doc(alias = "first-element-child")]
    fn get_property_first_element_child(&self) -> Option<DOMElement>;

    fn get_property_hidden(&self) -> bool;

    #[doc(alias = "last-element-child")]
    fn get_property_last_element_child(&self) -> Option<DOMElement>;

    fn get_property_origin(&self) -> Option<glib::GString>;

    fn get_property_plugins(&self) -> Option<DOMHTMLCollection>;

    #[doc(alias = "pointer-lock-element")]
    fn get_property_pointer_lock_element(&self) -> Option<DOMElement>;

    fn get_property_scripts(&self) -> Option<DOMHTMLCollection>;

    #[doc(alias = "scrolling-element")]
    fn get_property_scrolling_element(&self) -> Option<DOMElement>;

    #[doc(alias = "visibility-state")]
    fn get_property_visibility_state(&self) -> Option<glib::GString>;

    #[doc(alias = "webkit-current-full-screen-element")]
    fn webkit_current_full_screen_element(&self) -> Option<DOMElement>;

    #[doc(alias = "webkit-full-screen-keyboard-input-allowed")]
    fn is_webkit_full_screen_keyboard_input_allowed(&self) -> bool;

    #[doc(alias = "webkit-fullscreen-element")]
    fn get_property_webkit_fullscreen_element(&self) -> Option<DOMElement>;

    #[doc(alias = "webkit-fullscreen-enabled")]
    fn get_property_webkit_fullscreen_enabled(&self) -> bool;

    #[doc(alias = "webkit-is-full-screen")]
    fn is_webkit_is_full_screen(&self) -> bool;

    #[doc(alias = "active-element")]
    fn connect_active_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "anchors")]
    fn connect_anchors_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "applets")]
    fn connect_applets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "body")]
    fn connect_body_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "character-set")]
    fn connect_character_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "charset")]
    fn connect_charset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "child-element-count")]
    fn connect_child_element_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "children")]
    fn connect_children_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "compat-mode")]
    fn connect_compat_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "content-type")]
    fn connect_content_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cookie")]
    fn connect_cookie_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "current-script")]
    fn connect_current_script_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "default-view")]
    fn connect_default_view_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "design-mode")]
    fn connect_design_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "dir")]
    fn connect_dir_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "doctype")]
    fn connect_doctype_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "document-element")]
    fn connect_document_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "document-uri")]
    fn connect_document_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "domain")]
    fn connect_domain_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "embeds")]
    fn connect_embeds_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "first-element-child")]
    fn connect_first_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "forms")]
    fn connect_forms_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "head")]
    fn connect_head_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "hidden")]
    fn connect_hidden_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "images")]
    fn connect_images_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "implementation")]
    fn connect_implementation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "input-encoding")]
    fn connect_input_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "last-element-child")]
    fn connect_last_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "last-modified")]
    fn connect_last_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "links")]
    fn connect_links_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "origin")]
    fn connect_origin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "plugins")]
    fn connect_plugins_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pointer-lock-element")]
    fn connect_pointer_lock_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "preferred-stylesheet-set")]
    fn connect_preferred_stylesheet_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "ready-state")]
    fn connect_ready_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "referrer")]
    fn connect_referrer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scripts")]
    fn connect_scripts_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scrolling-element")]
    fn connect_scrolling_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "selected-stylesheet-set")]
    fn connect_selected_stylesheet_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style-sheets")]
    fn connect_style_sheets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "title")]
    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "url")]
    fn connect_url_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "visibility-state")]
    fn connect_visibility_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "webkit-current-full-screen-element")]
    fn connect_webkit_current_full_screen_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "webkit-full-screen-keyboard-input-allowed")]
    fn connect_webkit_full_screen_keyboard_input_allowed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "webkit-fullscreen-element")]
    fn connect_webkit_fullscreen_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "webkit-fullscreen-enabled")]
    fn connect_webkit_fullscreen_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "webkit-is-full-screen")]
    fn connect_webkit_is_full_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "xml-encoding")]
    fn connect_xml_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "xml-standalone")]
    fn connect_xml_standalone_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "xml-version")]
    fn connect_xml_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DOMDocument>> DOMDocumentExt for O {
    fn adopt_node(&self, source: &impl IsA<DOMNode>) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_adopt_node(self.as_ref().to_glib_none().0, source.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn caret_range_from_point(&self, x: libc::c_long, y: libc::c_long) -> Option<DOMRange> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_caret_range_from_point(self.as_ref().to_glib_none().0, x, y))
        }
    }

    fn create_attribute(&self, name: &str) -> Result<DOMAttr, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_attribute(self.as_ref().to_glib_none().0, name.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_attribute_ns(&self, namespaceURI: Option<&str>, qualifiedName: &str) -> Result<DOMAttr, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_attribute_ns(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, qualifiedName.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_cdata_section(&self, data: &str) -> Result<DOMCDATASection, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_cdata_section(self.as_ref().to_glib_none().0, data.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_comment(&self, data: &str) -> Option<DOMComment> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_create_comment(self.as_ref().to_glib_none().0, data.to_glib_none().0))
        }
    }

    fn create_css_style_declaration(&self) -> Option<DOMCSSStyleDeclaration> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_create_css_style_declaration(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn create_document_fragment(&self) -> Option<DOMDocumentFragment> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_create_document_fragment(self.as_ref().to_glib_none().0))
        }
    }

    fn create_element(&self, tagName: &str) -> Result<DOMElement, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_element(self.as_ref().to_glib_none().0, tagName.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_element_ns(&self, namespaceURI: Option<&str>, qualifiedName: &str) -> Result<DOMElement, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_element_ns(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, qualifiedName.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_entity_reference(&self, name: Option<&str>) -> Result<DOMEntityReference, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_entity_reference(self.as_ref().to_glib_none().0, name.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_event(&self, eventType: &str) -> Result<DOMEvent, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_event(self.as_ref().to_glib_none().0, eventType.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    //fn create_expression(&self, expression: &str, resolver: /*Ignored*/&DOMXPathNSResolver) -> Result<DOMXPathExpression, glib::Error> {
    //    unsafe { TODO: call ffi:webkit_dom_document_create_expression() }
    //}

    //fn create_node_iterator(&self, root: &impl IsA<DOMNode>, whatToShow: libc::c_ulong, filter: /*Ignored*/Option<&DOMNodeFilter>, expandEntityReferences: bool) -> Result<DOMNodeIterator, glib::Error> {
    //    unsafe { TODO: call ffi:webkit_dom_document_create_node_iterator() }
    //}

    //fn create_ns_resolver(&self, nodeResolver: &impl IsA<DOMNode>) -> /*Ignored*/Option<DOMXPathNSResolver> {
    //    unsafe { TODO: call ffi:webkit_dom_document_create_ns_resolver() }
    //}

    fn create_processing_instruction(&self, target: &str, data: &str) -> Result<DOMProcessingInstruction, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_create_processing_instruction(self.as_ref().to_glib_none().0, target.to_glib_none().0, data.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_range(&self) -> Option<DOMRange> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_create_range(self.as_ref().to_glib_none().0))
        }
    }

    fn create_text_node(&self, data: &str) -> Option<DOMText> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_create_text_node(self.as_ref().to_glib_none().0, data.to_glib_none().0))
        }
    }

    //fn create_tree_walker(&self, root: &impl IsA<DOMNode>, whatToShow: libc::c_ulong, filter: /*Ignored*/Option<&DOMNodeFilter>, expandEntityReferences: bool) -> Result<DOMTreeWalker, glib::Error> {
    //    unsafe { TODO: call ffi:webkit_dom_document_create_tree_walker() }
    //}

    fn element_from_point(&self, x: libc::c_long, y: libc::c_long) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_element_from_point(self.as_ref().to_glib_none().0, x, y))
        }
    }

    //fn evaluate(&self, expression: &str, contextNode: &impl IsA<DOMNode>, resolver: /*Ignored*/Option<&DOMXPathNSResolver>, type_: libc::c_ushort, inResult: Option<&impl IsA<DOMXPathResult>>) -> Result<DOMXPathResult, glib::Error> {
    //    unsafe { TODO: call ffi:webkit_dom_document_evaluate() }
    //}

    fn exec_command(&self, command: &str, userInterface: bool, value: &str) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_exec_command(self.as_ref().to_glib_none().0, command.to_glib_none().0, userInterface.into_glib(), value.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn exit_pointer_lock(&self) {
        unsafe {
            ffi::webkit_dom_document_exit_pointer_lock(self.as_ref().to_glib_none().0);
        }
    }

    fn active_element(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_active_element(self.as_ref().to_glib_none().0))
        }
    }

    fn anchors(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_anchors(self.as_ref().to_glib_none().0))
        }
    }

    fn applets(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_applets(self.as_ref().to_glib_none().0))
        }
    }

    fn body(&self) -> Option<DOMHTMLElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_body(self.as_ref().to_glib_none().0))
        }
    }

    fn character_set(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_character_set(self.as_ref().to_glib_none().0))
        }
    }

    fn charset(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_charset(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn child_element_count(&self) -> libc::c_ulong {
        unsafe {
            ffi::webkit_dom_document_get_child_element_count(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn children(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_children(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    fn compat_mode(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_compat_mode(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn content_type(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_content_type(self.as_ref().to_glib_none().0))
        }
    }

    fn cookie(&self) -> Result<glib::GString, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_get_cookie(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn current_script(&self) -> Option<DOMHTMLScriptElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_current_script(self.as_ref().to_glib_none().0))
        }
    }

    fn default_charset(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_default_charset(self.as_ref().to_glib_none().0))
        }
    }

    fn default_view(&self) -> Option<DOMDOMWindow> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_default_view(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    fn design_mode(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_design_mode(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn dir(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_dir(self.as_ref().to_glib_none().0))
        }
    }

    fn doctype(&self) -> Option<DOMDocumentType> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_doctype(self.as_ref().to_glib_none().0))
        }
    }

    fn document_element(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_document_element(self.as_ref().to_glib_none().0))
        }
    }

    fn document_uri(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_document_uri(self.as_ref().to_glib_none().0))
        }
    }

    fn domain(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_domain(self.as_ref().to_glib_none().0))
        }
    }

    fn element_by_id(&self, elementId: &str) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_element_by_id(self.as_ref().to_glib_none().0, elementId.to_glib_none().0))
        }
    }

    fn elements_by_class_name(&self, class_name: &str) -> Option<DOMNodeList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_elements_by_class_name(self.as_ref().to_glib_none().0, class_name.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    fn elements_by_class_name_as_html_collection(&self, classNames: &str) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_elements_by_class_name_as_html_collection(self.as_ref().to_glib_none().0, classNames.to_glib_none().0))
        }
    }

    fn elements_by_name(&self, elementName: &str) -> Option<DOMNodeList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_elements_by_name(self.as_ref().to_glib_none().0, elementName.to_glib_none().0))
        }
    }

    fn elements_by_tag_name(&self, tag_name: &str) -> Option<DOMNodeList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_elements_by_tag_name(self.as_ref().to_glib_none().0, tag_name.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    fn elements_by_tag_name_as_html_collection(&self, tagname: &str) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_elements_by_tag_name_as_html_collection(self.as_ref().to_glib_none().0, tagname.to_glib_none().0))
        }
    }

    fn elements_by_tag_name_ns(&self, namespace_uri: &str, tag_name: &str) -> Option<DOMNodeList> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_elements_by_tag_name_ns(self.as_ref().to_glib_none().0, namespace_uri.to_glib_none().0, tag_name.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_12", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_12")))]
    fn elements_by_tag_name_ns_as_html_collection(&self, namespaceURI: &str, localName: &str) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_elements_by_tag_name_ns_as_html_collection(self.as_ref().to_glib_none().0, namespaceURI.to_glib_none().0, localName.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    fn embeds(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_embeds(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn first_element_child(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_first_element_child(self.as_ref().to_glib_none().0))
        }
    }

    fn forms(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_forms(self.as_ref().to_glib_none().0))
        }
    }

    fn head(&self) -> Option<DOMHTMLHeadElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_head(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn is_hidden(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_get_hidden(self.as_ref().to_glib_none().0))
        }
    }

    fn images(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_images(self.as_ref().to_glib_none().0))
        }
    }

    fn implementation(&self) -> Option<DOMDOMImplementation> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_implementation(self.as_ref().to_glib_none().0))
        }
    }

    fn input_encoding(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_input_encoding(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn last_element_child(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_last_element_child(self.as_ref().to_glib_none().0))
        }
    }

    fn last_modified(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_last_modified(self.as_ref().to_glib_none().0))
        }
    }

    fn links(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_links(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn origin(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_origin(self.as_ref().to_glib_none().0))
        }
    }

    fn override_style(&self, element: &impl IsA<DOMElement>, pseudoElement: Option<&str>) -> Option<DOMCSSStyleDeclaration> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_override_style(self.as_ref().to_glib_none().0, element.as_ref().to_glib_none().0, pseudoElement.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    fn plugins(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_plugins(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn pointer_lock_element(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_pointer_lock_element(self.as_ref().to_glib_none().0))
        }
    }

    fn preferred_stylesheet_set(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_preferred_stylesheet_set(self.as_ref().to_glib_none().0))
        }
    }

    fn ready_state(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_ready_state(self.as_ref().to_glib_none().0))
        }
    }

    fn referrer(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_referrer(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    fn scripts(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_scripts(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn scrolling_element(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_scrolling_element(self.as_ref().to_glib_none().0))
        }
    }

    fn selected_stylesheet_set(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_selected_stylesheet_set(self.as_ref().to_glib_none().0))
        }
    }

    fn style_sheets(&self) -> Option<DOMStyleSheetList> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_style_sheets(self.as_ref().to_glib_none().0))
        }
    }

    fn title(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_title(self.as_ref().to_glib_none().0))
        }
    }

    fn url(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_url(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn visibility_state(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_visibility_state(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn webkit_current_fullscreen_element(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_webkit_current_fullscreen_element(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn webkit_fullscreen_element(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_get_webkit_fullscreen_element(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn is_webkit_fullscreen_enabled(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_get_webkit_fullscreen_enabled(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn is_webkit_fullscreen_keyboard_input_allowed(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_get_webkit_fullscreen_keyboard_input_allowed(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn is_webkit_is_fullscreen(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_get_webkit_is_fullscreen(self.as_ref().to_glib_none().0))
        }
    }

    fn xml_encoding(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_xml_encoding(self.as_ref().to_glib_none().0))
        }
    }

    fn is_xml_standalone(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_get_xml_standalone(self.as_ref().to_glib_none().0))
        }
    }

    fn xml_version(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_get_xml_version(self.as_ref().to_glib_none().0))
        }
    }

    fn has_focus(&self) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_has_focus(self.as_ref().to_glib_none().0))
        }
    }

    fn import_node(&self, importedNode: &impl IsA<DOMNode>, deep: bool) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_import_node(self.as_ref().to_glib_none().0, importedNode.as_ref().to_glib_none().0, deep.into_glib(), &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn query_command_enabled(&self, command: &str) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_query_command_enabled(self.as_ref().to_glib_none().0, command.to_glib_none().0))
        }
    }

    fn query_command_indeterm(&self, command: &str) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_query_command_indeterm(self.as_ref().to_glib_none().0, command.to_glib_none().0))
        }
    }

    fn query_command_state(&self, command: &str) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_query_command_state(self.as_ref().to_glib_none().0, command.to_glib_none().0))
        }
    }

    fn query_command_supported(&self, command: &str) -> bool {
        unsafe {
            from_glib(ffi::webkit_dom_document_query_command_supported(self.as_ref().to_glib_none().0, command.to_glib_none().0))
        }
    }

    fn query_command_value(&self, command: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_query_command_value(self.as_ref().to_glib_none().0, command.to_glib_none().0))
        }
    }

    fn query_selector(&self, selectors: &str) -> Result<DOMElement, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_query_selector(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn query_selector_all(&self, selectors: &str) -> Result<DOMNodeList, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_query_selector_all(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_body(&self, value: &impl IsA<DOMHTMLElement>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_document_set_body(self.as_ref().to_glib_none().0, value.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_charset(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_document_set_charset(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    fn set_cookie(&self, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_document_set_cookie(self.as_ref().to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_14", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_14")))]
    fn set_design_mode(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_document_set_design_mode(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn set_dir(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_document_set_dir(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    fn set_document_uri(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_document_set_document_uri(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    fn set_selected_stylesheet_set(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_document_set_selected_stylesheet_set(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    fn set_title(&self, value: &str) {
        unsafe {
            ffi::webkit_dom_document_set_title(self.as_ref().to_glib_none().0, value.to_glib_none().0);
        }
    }

    fn set_xml_standalone(&self, value: bool) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_document_set_xml_standalone(self.as_ref().to_glib_none().0, value.into_glib(), &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_xml_version(&self, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_document_set_xml_version(self.as_ref().to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn webkit_cancel_fullscreen(&self) {
        unsafe {
            ffi::webkit_dom_document_webkit_cancel_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn webkit_exit_fullscreen(&self) {
        unsafe {
            ffi::webkit_dom_document_webkit_exit_fullscreen(self.as_ref().to_glib_none().0);
        }
    }

    fn get_property_child_element_count(&self) -> libc::c_ulong {
        glib::ObjectExt::property(self.as_ref(), "child-element-count")
    }

    fn get_property_children(&self) -> Option<DOMHTMLCollection> {
        glib::ObjectExt::property(self.as_ref(), "children")
    }

    fn get_property_compat_mode(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "compat-mode")
    }

    fn get_property_content_type(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "content-type")
    }

    fn get_property_current_script(&self) -> Option<DOMHTMLScriptElement> {
        glib::ObjectExt::property(self.as_ref(), "current-script")
    }

    fn get_property_design_mode(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "design-mode")
    }

    fn set_property_design_mode(&self, design_mode: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"design-mode", &design_mode)
    }

    fn get_property_dir(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "dir")
    }

    fn set_property_dir(&self, dir: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(),"dir", &dir)
    }

    fn get_property_embeds(&self) -> Option<DOMHTMLCollection> {
        glib::ObjectExt::property(self.as_ref(), "embeds")
    }

    fn get_property_first_element_child(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "first-element-child")
    }

    fn get_property_hidden(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "hidden")
    }

    fn get_property_last_element_child(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "last-element-child")
    }

    fn get_property_origin(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "origin")
    }

    fn get_property_plugins(&self) -> Option<DOMHTMLCollection> {
        glib::ObjectExt::property(self.as_ref(), "plugins")
    }

    fn get_property_pointer_lock_element(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "pointer-lock-element")
    }

    fn get_property_scripts(&self) -> Option<DOMHTMLCollection> {
        glib::ObjectExt::property(self.as_ref(), "scripts")
    }

    fn get_property_scrolling_element(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "scrolling-element")
    }

    fn get_property_visibility_state(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "visibility-state")
    }

    fn webkit_current_full_screen_element(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "webkit-current-full-screen-element")
    }

    fn is_webkit_full_screen_keyboard_input_allowed(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "webkit-full-screen-keyboard-input-allowed")
    }

    fn get_property_webkit_fullscreen_element(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "webkit-fullscreen-element")
    }

    fn get_property_webkit_fullscreen_enabled(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "webkit-fullscreen-enabled")
    }

    fn is_webkit_is_full_screen(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "webkit-is-full-screen")
    }

    fn connect_active_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_active_element_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::active-element\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_active_element_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_anchors_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_anchors_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::anchors\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_anchors_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_applets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_applets_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::applets\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_applets_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_body_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_body_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_body_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_character_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_character_set_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::character-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_character_set_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_charset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_charset_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::charset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_charset_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_child_element_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_element_count_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::child-element-count\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_child_element_count_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_children_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_children_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::children\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_children_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_compat_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_compat_mode_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::compat-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_compat_mode_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_content_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_content_type_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::content-type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_content_type_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_cookie_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cookie_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::cookie\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_cookie_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_current_script_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_current_script_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::current-script\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_current_script_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_default_view_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_view_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::default-view\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_default_view_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_design_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_design_mode_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::design-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_design_mode_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_dir_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_dir_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::dir\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_dir_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_doctype_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_doctype_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::doctype\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_doctype_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_document_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_document_element_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::document-element\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_document_element_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_document_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_document_uri_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::document-uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_document_uri_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_domain_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_domain_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::domain\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_domain_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_embeds_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_embeds_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::embeds\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_embeds_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_first_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_first_element_child_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::first-element-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_first_element_child_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_forms_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_forms_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::forms\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_forms_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_head_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_head_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::head\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_head_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_hidden_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_hidden_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::hidden\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_hidden_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_images_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_images_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::images\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_images_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_implementation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_implementation_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::implementation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_implementation_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_input_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_encoding_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::input-encoding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_input_encoding_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_last_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_last_element_child_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::last-element-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_last_element_child_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_last_modified_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_last_modified_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::last-modified\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_last_modified_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_links_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_links_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::links\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_links_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_origin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_origin_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::origin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_origin_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_plugins_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_plugins_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::plugins\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_plugins_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_pointer_lock_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pointer_lock_element_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::pointer-lock-element\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_pointer_lock_element_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_preferred_stylesheet_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_preferred_stylesheet_set_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::preferred-stylesheet-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_preferred_stylesheet_set_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_ready_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_ready_state_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::ready-state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_ready_state_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_referrer_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_referrer_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::referrer\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_referrer_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scripts_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scripts_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::scripts\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_scripts_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scrolling_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scrolling_element_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::scrolling-element\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_scrolling_element_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_selected_stylesheet_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_selected_stylesheet_set_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::selected-stylesheet-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_selected_stylesheet_set_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_style_sheets_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_sheets_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::style-sheets\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_style_sheets_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::title\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_title_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_url_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_url_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::url\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_url_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_visibility_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_visibility_state_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::visibility-state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_visibility_state_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_webkit_current_full_screen_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_webkit_current_full_screen_element_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::webkit-current-full-screen-element\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_webkit_current_full_screen_element_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_webkit_full_screen_keyboard_input_allowed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_webkit_full_screen_keyboard_input_allowed_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::webkit-full-screen-keyboard-input-allowed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_webkit_full_screen_keyboard_input_allowed_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_webkit_fullscreen_element_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_webkit_fullscreen_element_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::webkit-fullscreen-element\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_webkit_fullscreen_element_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_webkit_fullscreen_enabled_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_webkit_fullscreen_enabled_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::webkit-fullscreen-enabled\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_webkit_fullscreen_enabled_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_webkit_is_full_screen_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_webkit_is_full_screen_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::webkit-is-full-screen\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_webkit_is_full_screen_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_xml_encoding_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xml_encoding_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::xml-encoding\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_xml_encoding_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_xml_standalone_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xml_standalone_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::xml-standalone\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_xml_standalone_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_xml_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_xml_version_trampoline<P: IsA<DOMDocument>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocument, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocument::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::xml-version\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_xml_version_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for DOMDocument {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DOMDocument")
    }
}
