// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
use crate::DOMDocumentFragment;
use crate::DOMNode;
use crate::DOMObject;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "WebKitDOMRange")]
    pub struct DOMRange(Object<ffi::WebKitDOMRange, ffi::WebKitDOMRangeClass>) @extends DOMObject;

    match fn {
        type_ => || ffi::webkit_dom_range_get_type(),
    }
}

impl DOMRange {
        pub const NONE: Option<&'static DOMRange> = None;
    
}

pub trait DOMRangeExt: 'static {
    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_range_clone_contents")]
    fn clone_contents(&self) -> Result<DOMDocumentFragment, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_clone_range")]
    fn clone_range(&self) -> Result<DOMRange, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_collapse")]
    fn collapse(&self, toStart: bool) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_compare_boundary_points")]
    fn compare_boundary_points(&self, how: libc::c_ushort, sourceRange: &impl IsA<DOMRange>) -> Result<libc::c_short, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_compare_node")]
    fn compare_node(&self, refNode: &impl IsA<DOMNode>) -> Result<libc::c_short, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_compare_point")]
    fn compare_point(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<libc::c_short, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_range_create_contextual_fragment")]
    fn create_contextual_fragment(&self, html: &str) -> Result<DOMDocumentFragment, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_delete_contents")]
    fn delete_contents(&self) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_detach")]
    fn detach(&self) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_range_expand")]
    fn expand(&self, unit: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_range_extract_contents")]
    fn extract_contents(&self) -> Result<DOMDocumentFragment, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_get_collapsed")]
    #[doc(alias = "get_collapsed")]
    fn collapsed(&self) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_get_common_ancestor_container")]
    #[doc(alias = "get_common_ancestor_container")]
    fn common_ancestor_container(&self) -> Result<DOMNode, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_get_end_container")]
    #[doc(alias = "get_end_container")]
    fn end_container(&self) -> Result<DOMNode, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_get_end_offset")]
    #[doc(alias = "get_end_offset")]
    fn end_offset(&self) -> Result<libc::c_long, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_get_start_container")]
    #[doc(alias = "get_start_container")]
    fn start_container(&self) -> Result<DOMNode, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_get_start_offset")]
    #[doc(alias = "get_start_offset")]
    fn start_offset(&self) -> Result<libc::c_long, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_get_text")]
    #[doc(alias = "get_text")]
    fn text(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_insert_node")]
    fn insert_node(&self, newNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_intersects_node")]
    fn intersects_node(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_is_point_in_range")]
    fn is_point_in_range(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_select_node")]
    fn select_node(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_select_node_contents")]
    fn select_node_contents(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_set_end")]
    fn set_end(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_set_end_after")]
    fn set_end_after(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_set_end_before")]
    fn set_end_before(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_set_start")]
    fn set_start(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_set_start_after")]
    fn set_start_after(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_set_start_before")]
    fn set_start_before(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_surround_contents")]
    fn surround_contents(&self, newParent: &impl IsA<DOMNode>) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_range_to_string")]
    fn to_string(&self) -> Result<glib::GString, glib::Error>;

    #[doc(alias = "collapsed")]
    fn connect_collapsed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "common-ancestor-container")]
    fn connect_common_ancestor_container_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "end-container")]
    fn connect_end_container_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "end-offset")]
    fn connect_end_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "start-container")]
    fn connect_start_container_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "start-offset")]
    fn connect_start_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "text")]
    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DOMRange>> DOMRangeExt for O {
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn clone_contents(&self) -> Result<DOMDocumentFragment, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_clone_contents(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn clone_range(&self) -> Result<DOMRange, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_clone_range(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn collapse(&self, toStart: bool) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_collapse(self.as_ref().to_glib_none().0, toStart.into_glib(), &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn compare_boundary_points(&self, how: libc::c_ushort, sourceRange: &impl IsA<DOMRange>) -> Result<libc::c_short, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_compare_boundary_points(self.as_ref().to_glib_none().0, how, sourceRange.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(ret) } else { Err(from_glib_full(error)) }
        }
    }

    fn compare_node(&self, refNode: &impl IsA<DOMNode>) -> Result<libc::c_short, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_compare_node(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(ret) } else { Err(from_glib_full(error)) }
        }
    }

    fn compare_point(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<libc::c_short, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_compare_point(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, offset, &mut error);
            if error.is_null() { Ok(ret) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn create_contextual_fragment(&self, html: &str) -> Result<DOMDocumentFragment, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_create_contextual_fragment(self.as_ref().to_glib_none().0, html.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn delete_contents(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_delete_contents(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn detach(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_detach(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn expand(&self, unit: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_expand(self.as_ref().to_glib_none().0, unit.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn extract_contents(&self) -> Result<DOMDocumentFragment, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_extract_contents(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn collapsed(&self) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::webkit_dom_range_get_collapsed(self.as_ref().to_glib_none().0, &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn common_ancestor_container(&self) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_get_common_ancestor_container(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn end_container(&self) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_get_end_container(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn end_offset(&self) -> Result<libc::c_long, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_get_end_offset(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(ret) } else { Err(from_glib_full(error)) }
        }
    }

    fn start_container(&self) -> Result<DOMNode, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_get_start_container(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn start_offset(&self) -> Result<libc::c_long, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_get_start_offset(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(ret) } else { Err(from_glib_full(error)) }
        }
    }

    fn text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_range_get_text(self.as_ref().to_glib_none().0))
        }
    }

    fn insert_node(&self, newNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_insert_node(self.as_ref().to_glib_none().0, newNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn intersects_node(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::webkit_dom_range_intersects_node(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn is_point_in_range(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::webkit_dom_range_is_point_in_range(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, offset, &mut error);
            assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn select_node(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_select_node(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn select_node_contents(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_select_node_contents(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_end(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_set_end(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, offset, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_end_after(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_set_end_after(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_end_before(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_set_end_before(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_start(&self, refNode: &impl IsA<DOMNode>, offset: libc::c_long) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_set_start(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, offset, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_start_after(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_set_start_after(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_start_before(&self, refNode: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_set_start_before(self.as_ref().to_glib_none().0, refNode.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn surround_contents(&self, newParent: &impl IsA<DOMNode>) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_range_surround_contents(self.as_ref().to_glib_none().0, newParent.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn to_string(&self) -> Result<glib::GString, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_range_to_string(self.as_ref().to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn connect_collapsed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_collapsed_trampoline<P: IsA<DOMRange>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMRange, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMRange::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::collapsed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_collapsed_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_common_ancestor_container_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_common_ancestor_container_trampoline<P: IsA<DOMRange>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMRange, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMRange::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::common-ancestor-container\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_common_ancestor_container_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_end_container_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_end_container_trampoline<P: IsA<DOMRange>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMRange, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMRange::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::end-container\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_end_container_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_end_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_end_offset_trampoline<P: IsA<DOMRange>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMRange, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMRange::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::end-offset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_end_offset_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_start_container_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_start_container_trampoline<P: IsA<DOMRange>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMRange, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMRange::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::start-container\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_start_container_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_start_offset_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_start_offset_trampoline<P: IsA<DOMRange>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMRange, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMRange::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::start-offset\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_start_offset_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<P: IsA<DOMRange>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMRange, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMRange::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_text_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for DOMRange {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DOMRange")
    }
}
