// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::DOMObject;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "WebKitDOMMediaList")]
    pub struct DOMMediaList(Object<ffi::WebKitDOMMediaList, ffi::WebKitDOMMediaListClass>) @extends DOMObject;

    match fn {
        type_ => || ffi::webkit_dom_media_list_get_type(),
    }
}

impl DOMMediaList {
        pub const NONE: Option<&'static DOMMediaList> = None;
    
}

pub trait DOMMediaListExt: 'static {
    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_media_list_append_medium")]
    fn append_medium(&self, newMedium: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_media_list_delete_medium")]
    fn delete_medium(&self, oldMedium: &str) -> Result<(), glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_media_list_get_length")]
    #[doc(alias = "get_length")]
    fn length(&self) -> libc::c_ulong;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_media_list_get_media_text")]
    #[doc(alias = "get_media_text")]
    fn media_text(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_media_list_item")]
    fn item(&self, index: libc::c_ulong) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_media_list_set_media_text")]
    fn set_media_text(&self, value: &str) -> Result<(), glib::Error>;

    #[doc(alias = "length")]
    fn connect_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "media-text")]
    fn connect_media_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DOMMediaList>> DOMMediaListExt for O {
    fn append_medium(&self, newMedium: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_media_list_append_medium(self.as_ref().to_glib_none().0, newMedium.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn delete_medium(&self, oldMedium: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_media_list_delete_medium(self.as_ref().to_glib_none().0, oldMedium.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn length(&self) -> libc::c_ulong {
        unsafe {
            ffi::webkit_dom_media_list_get_length(self.as_ref().to_glib_none().0)
        }
    }

    fn media_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_media_list_get_media_text(self.as_ref().to_glib_none().0))
        }
    }

    fn item(&self, index: libc::c_ulong) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_media_list_item(self.as_ref().to_glib_none().0, index))
        }
    }

    fn set_media_text(&self, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_media_list_set_media_text(self.as_ref().to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn connect_length_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_length_trampoline<P: IsA<DOMMediaList>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMMediaList, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMMediaList::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::length\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_length_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_media_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_media_text_trampoline<P: IsA<DOMMediaList>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMMediaList, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMMediaList::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::media-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_media_text_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for DOMMediaList {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DOMMediaList")
    }
}
