// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::DOMElement;
use crate::DOMEventTarget;
use crate::DOMHTMLCollection;
use crate::DOMNode;
#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
use crate::DOMNodeList;
use crate::DOMObject;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
#[cfg(any(feature = "v2_16", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
use std::ptr;

glib::wrapper! {
    #[doc(alias = "WebKitDOMDocumentFragment")]
    pub struct DOMDocumentFragment(Object<ffi::WebKitDOMDocumentFragment, ffi::WebKitDOMDocumentFragmentClass>) @extends DOMNode, DOMObject, @implements DOMEventTarget;

    match fn {
        type_ => || ffi::webkit_dom_document_fragment_get_type(),
    }
}

impl DOMDocumentFragment {
        pub const NONE: Option<&'static DOMDocumentFragment> = None;
    
}

pub trait DOMDocumentFragmentExt: 'static {
    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_fragment_get_child_element_count")]
    #[doc(alias = "get_child_element_count")]
    fn child_element_count(&self) -> libc::c_ulong;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_fragment_get_children")]
    #[doc(alias = "get_children")]
    fn children(&self) -> Option<DOMHTMLCollection>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_fragment_get_element_by_id")]
    #[doc(alias = "get_element_by_id")]
    fn element_by_id(&self, elementId: &str) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_fragment_get_first_element_child")]
    #[doc(alias = "get_first_element_child")]
    fn first_element_child(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_fragment_get_last_element_child")]
    #[doc(alias = "get_last_element_child")]
    fn last_element_child(&self) -> Option<DOMElement>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_fragment_query_selector")]
    fn query_selector(&self, selectors: &str) -> Result<DOMElement, glib::Error>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    #[doc(alias = "webkit_dom_document_fragment_query_selector_all")]
    fn query_selector_all(&self, selectors: &str) -> Result<DOMNodeList, glib::Error>;

    #[doc(alias = "child-element-count")]
    fn get_property_child_element_count(&self) -> libc::c_ulong;

    fn get_property_children(&self) -> Option<DOMHTMLCollection>;

    #[doc(alias = "first-element-child")]
    fn get_property_first_element_child(&self) -> Option<DOMElement>;

    #[doc(alias = "last-element-child")]
    fn get_property_last_element_child(&self) -> Option<DOMElement>;

    #[doc(alias = "child-element-count")]
    fn connect_child_element_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "children")]
    fn connect_children_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "first-element-child")]
    fn connect_first_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "last-element-child")]
    fn connect_last_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DOMDocumentFragment>> DOMDocumentFragmentExt for O {
    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn child_element_count(&self) -> libc::c_ulong {
        unsafe {
            ffi::webkit_dom_document_fragment_get_child_element_count(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn children(&self) -> Option<DOMHTMLCollection> {
        unsafe {
            from_glib_full(ffi::webkit_dom_document_fragment_get_children(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn element_by_id(&self, elementId: &str) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_fragment_get_element_by_id(self.as_ref().to_glib_none().0, elementId.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn first_element_child(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_fragment_get_first_element_child(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn last_element_child(&self) -> Option<DOMElement> {
        unsafe {
            from_glib_none(ffi::webkit_dom_document_fragment_get_last_element_child(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn query_selector(&self, selectors: &str) -> Result<DOMElement, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_fragment_query_selector(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_none(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_16", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_16")))]
    fn query_selector_all(&self, selectors: &str) -> Result<DOMNodeList, glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::webkit_dom_document_fragment_query_selector_all(self.as_ref().to_glib_none().0, selectors.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn get_property_child_element_count(&self) -> libc::c_ulong {
        glib::ObjectExt::property(self.as_ref(), "child-element-count")
    }

    fn get_property_children(&self) -> Option<DOMHTMLCollection> {
        glib::ObjectExt::property(self.as_ref(), "children")
    }

    fn get_property_first_element_child(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "first-element-child")
    }

    fn get_property_last_element_child(&self) -> Option<DOMElement> {
        glib::ObjectExt::property(self.as_ref(), "last-element-child")
    }

    fn connect_child_element_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_child_element_count_trampoline<P: IsA<DOMDocumentFragment>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocumentFragment, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocumentFragment::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::child-element-count\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_child_element_count_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_children_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_children_trampoline<P: IsA<DOMDocumentFragment>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocumentFragment, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocumentFragment::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::children\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_children_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_first_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_first_element_child_trampoline<P: IsA<DOMDocumentFragment>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocumentFragment, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocumentFragment::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::first-element-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_first_element_child_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_last_element_child_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_last_element_child_trampoline<P: IsA<DOMDocumentFragment>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMDocumentFragment, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMDocumentFragment::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::last-element-child\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_last_element_child_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for DOMDocumentFragment {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DOMDocumentFragment")
    }
}
