// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::DOMCSSStyleSheet;
use crate::DOMObject;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use std::ptr;

glib::wrapper! {
    #[doc(alias = "WebKitDOMCSSRule")]
    pub struct DOMCSSRule(Object<ffi::WebKitDOMCSSRule, ffi::WebKitDOMCSSRuleClass>) @extends DOMObject;

    match fn {
        type_ => || ffi::webkit_dom_css_rule_get_type(),
    }
}

impl DOMCSSRule {
        pub const NONE: Option<&'static DOMCSSRule> = None;
    
}

pub trait DOMCSSRuleExt: 'static {
    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_css_rule_get_css_text")]
    #[doc(alias = "get_css_text")]
    fn css_text(&self) -> Option<glib::GString>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_css_rule_get_parent_rule")]
    #[doc(alias = "get_parent_rule")]
#[must_use]
    fn parent_rule(&self) -> Option<DOMCSSRule>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_css_rule_get_parent_style_sheet")]
    #[doc(alias = "get_parent_style_sheet")]
    fn parent_style_sheet(&self) -> Option<DOMCSSStyleSheet>;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_css_rule_get_rule_type")]
    #[doc(alias = "get_rule_type")]
    fn rule_type(&self) -> libc::c_ushort;

    #[cfg_attr(feature = "v2_22", deprecated = "Since 2.22")]
    #[doc(alias = "webkit_dom_css_rule_set_css_text")]
    fn set_css_text(&self, value: &str) -> Result<(), glib::Error>;

    #[doc(alias = "type")]
    fn type_(&self) -> u32;

    #[doc(alias = "css-text")]
    fn connect_css_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "parent-rule")]
    fn connect_parent_rule_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "parent-style-sheet")]
    fn connect_parent_style_sheet_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "type")]
    fn connect_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<DOMCSSRule>> DOMCSSRuleExt for O {
    fn css_text(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::webkit_dom_css_rule_get_css_text(self.as_ref().to_glib_none().0))
        }
    }

    fn parent_rule(&self) -> Option<DOMCSSRule> {
        unsafe {
            from_glib_full(ffi::webkit_dom_css_rule_get_parent_rule(self.as_ref().to_glib_none().0))
        }
    }

    fn parent_style_sheet(&self) -> Option<DOMCSSStyleSheet> {
        unsafe {
            from_glib_full(ffi::webkit_dom_css_rule_get_parent_style_sheet(self.as_ref().to_glib_none().0))
        }
    }

    fn rule_type(&self) -> libc::c_ushort {
        unsafe {
            ffi::webkit_dom_css_rule_get_rule_type(self.as_ref().to_glib_none().0)
        }
    }

    fn set_css_text(&self, value: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::webkit_dom_css_rule_set_css_text(self.as_ref().to_glib_none().0, value.to_glib_none().0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn type_(&self) -> u32 {
        glib::ObjectExt::property(self.as_ref(), "type")
    }

    fn connect_css_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_css_text_trampoline<P: IsA<DOMCSSRule>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMCSSRule, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMCSSRule::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::css-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_css_text_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_parent_rule_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_parent_rule_trampoline<P: IsA<DOMCSSRule>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMCSSRule, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMCSSRule::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::parent-rule\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_parent_rule_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_parent_style_sheet_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_parent_style_sheet_trampoline<P: IsA<DOMCSSRule>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMCSSRule, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMCSSRule::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::parent-style-sheet\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_parent_style_sheet_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_type_trampoline<P: IsA<DOMCSSRule>, F: Fn(&P) + 'static>(this: *mut ffi::WebKitDOMCSSRule, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(DOMCSSRule::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_type_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for DOMCSSRule {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("DOMCSSRule")
    }
}
