# webcat - netcat for websockets

Connect to a websocket server:

    webcat ws://example.com:3000/

Start a websocket server listening on port 3000:

    webcat -l 3000

The server only accepts one client at a time. The client auto-reconnects.

## Setting up a MITM debugging proxy

By redirecting the standard input/output streams of webcat you can turn it into
a man-in-the-middle proxy, particularily useful for debugging stateful protocols
on top of websocket.

    [some client] <-> [webcat server] <-> [webcat client] <-> [some server]
                                     FIFOs

All it takes to set this up is four commands, for example:

    mkfifo client-in server-in
    webcat ws://example.com:3000/ < client-in > server-in
    webcat -l 4000 < server-in > client-in
    echo > server-in # unblock the FIFO deadlock

You can now connect your client to `ws://localhost:4000/`
and inject messages by writing to the named pipes:

    echo "Hello from webcat" > client-in

Webcat does two tricks to make this setup even more convenient:

* When redirecting stdout, the messages are automatically printed
  to stderr, so you can still observe what's happening.

* When the client recognizes the server output `accepted new client`,
  it automatically disconnects and reconnects its server connection
  to prevent stateful application protocols from becoming out of sync.


## Limitations

* no support for binary messages

* no support for messages containing newlines
  (cannot send them, cannot distinguish them from separate messages)

* no support for WebSocket Secure (`wss://`)
  (webcat is meant for local testing & debugging, wss is out of scope)
