# webcat - netcat for websockets

Connect to a websocket server:

    webcat ws://example.com:3000/

Start a websocket server listening on port 3000:

    webcat -l 3000

The server only accepts one client at a time. The client auto-reconnects.

## Setting up a MITM debugging proxy

To debug stateful protocols on top of websockets, it is helpful to be able to
inject messages to the server or the client in a real session, acting as a
man-in-the-middle (MITM).  On Linux you can achieve this using `webcat` and
FIFOs as follows:

    mkfifo client-in server-in
    webcat ws://example.com:3000/ < client-in > server-in
    webcat -l 4000 < server-in > client-in
    echo > server-in # unblock the FIFO deadlock

You can now connect your client to ws://localhost:4000/.
And inject messages by writing to the named pipes:

    echo "Hello from webcat" > client-in

Note that when redirecting stdout the messages are automatically printed to
stderr, so you can still observe what's happening.

## Limitations

* no support for messages containing newlines
  (cannot send them, cannot distinguish them from separate messages)

* no support for WebSocket Secure (`wss://`)
  (webcat is meant for local testing & debugging, wss is out of scope)
