#[allow(dead_code, unused_imports, non_camel_case_types)]
pub mod api {
    #[derive(
        :: subxt :: codec :: Encode,
        :: subxt :: codec :: Decode,
        Debug,
        Eq,
        PartialEq,
        Clone,
    )]
    pub enum Event {
        #[codec(index = 0)]
        System(system::Event),
        #[codec(index = 2)]
        Sudo(sudo::Event),
        #[codec(index = 4)]
        Balances(balances::Event),
        #[codec(index = 8)]
        Grandpa(grandpa::Event),
        #[codec(index = 9)]
        Democracy(democracy::Event),
        #[codec(index = 10)]
        Council(council::Event),
        #[codec(index = 11)]
        Elections(elections::Event),
        #[codec(index = 12)]
        ElectionProviderMultiPhase(election_provider_multi_phase::Event),
        #[codec(index = 13)]
        Staking(staking::Event),
        #[codec(index = 14)]
        Session(session::Event),
        #[codec(index = 16)]
        Treasury(treasury::Event),
        #[codec(index = 17)]
        Bounties(bounties::Event),
        #[codec(index = 18)]
        ChildBounties(child_bounties::Event),
        #[codec(index = 19)]
        BagsList(bags_list::Event),
        #[codec(index = 20)]
        Scheduler(scheduler::Event),
        #[codec(index = 21)]
        Preimage(preimage::Event),
        #[codec(index = 22)]
        Offences(offences::Event),
        #[codec(index = 23)]
        DKG(dkg::Event),
        #[codec(index = 24)]
        DKGProposals(dkg_proposals::Event),
        #[codec(index = 25)]
        DKGProposalHandler(dkg_proposal_handler::Event),
        #[codec(index = 26)]
        HasherBn254(hasher_bn254::Event),
        #[codec(index = 27)]
        AssetRegistry(asset_registry::Event),
        #[codec(index = 28)]
        Currencies(currencies::Event),
        #[codec(index = 29)]
        Tokens(tokens::Event),
        #[codec(index = 30)]
        TokenWrapper(token_wrapper::Event),
        #[codec(index = 31)]
        MixerVerifierBn254(mixer_verifier_bn254::Event),
        #[codec(index = 32)]
        AnchorVerifierBn254(anchor_verifier_bn254::Event),
        #[codec(index = 33)]
        MerkleTreeBn254(merkle_tree_bn254::Event),
        #[codec(index = 34)]
        LinkableTreeBn254(linkable_tree_bn254::Event),
        #[codec(index = 35)]
        MixerBn254(mixer_bn254::Event),
        #[codec(index = 36)]
        AnchorBn254(anchor_bn254::Event),
        #[codec(index = 37)]
        AnchorHandlerBn254(anchor_handler_bn254::Event),
        #[codec(index = 38)]
        Bridge(bridge::Event),
    }
    pub mod system {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct fill_block {
                pub ratio: runtime_types::sp_arithmetic::per_things::Perbill,
            }
            impl ::subxt::Call for fill_block {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "fill_block";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remark {
                pub remark: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for remark {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "remark";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct set_heap_pages {
                pub pages: ::core::primitive::u64,
            }
            impl ::subxt::Call for set_heap_pages {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "set_heap_pages";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_code {
                pub code: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for set_code {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "set_code";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_code_without_checks {
                pub code: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for set_code_without_checks {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "set_code_without_checks";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_storage {
                pub items: ::std::vec::Vec<(
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::std::vec::Vec<::core::primitive::u8>,
                )>,
            }
            impl ::subxt::Call for set_storage {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "set_storage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct kill_storage {
                pub keys:
                    ::std::vec::Vec<::std::vec::Vec<::core::primitive::u8>>,
            }
            impl ::subxt::Call for kill_storage {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "kill_storage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct kill_prefix {
                pub prefix: ::std::vec::Vec<::core::primitive::u8>,
                pub subkeys: ::core::primitive::u32,
            }
            impl ::subxt::Call for kill_prefix {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "kill_prefix";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remark_with_event {
                pub remark: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for remark_with_event {
                const PALLET: &'static str = "System";
                const FUNCTION: &'static str = "remark_with_event";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn fill_block(
                    &self,
                    ratio: runtime_types::sp_arithmetic::per_things::Perbill,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    fill_block,
                    DispatchError,
                > {
                    let call = fill_block { ratio };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remark(
                    &self,
                    remark: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remark,
                    DispatchError,
                > {
                    let call = remark { remark };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_heap_pages(
                    &self,
                    pages: ::core::primitive::u64,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_heap_pages,
                    DispatchError,
                > {
                    let call = set_heap_pages { pages };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_code(
                    &self,
                    code: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_code,
                    DispatchError,
                > {
                    let call = set_code { code };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_code_without_checks(
                    &self,
                    code: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_code_without_checks,
                    DispatchError,
                > {
                    let call = set_code_without_checks { code };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_storage(
                    &self,
                    items: ::std::vec::Vec<(
                        ::std::vec::Vec<::core::primitive::u8>,
                        ::std::vec::Vec<::core::primitive::u8>,
                    )>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_storage,
                    DispatchError,
                > {
                    let call = set_storage { items };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn kill_storage(
                    &self,
                    keys: ::std::vec::Vec<
                        ::std::vec::Vec<::core::primitive::u8>,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    kill_storage,
                    DispatchError,
                > {
                    let call = kill_storage { keys };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn kill_prefix(
                    &self,
                    prefix: ::std::vec::Vec<::core::primitive::u8>,
                    subkeys: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    kill_prefix,
                    DispatchError,
                > {
                    let call = kill_prefix { prefix, subkeys };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remark_with_event(
                    &self,
                    remark: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remark_with_event,
                    DispatchError,
                > {
                    let call = remark_with_event { remark };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::frame_system::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ExtrinsicSuccess {
                pub dispatch_info:
                    runtime_types::frame_support::weights::DispatchInfo,
            }
            impl ::subxt::Event for ExtrinsicSuccess {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "ExtrinsicSuccess";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ExtrinsicFailed {
                pub dispatch_error: runtime_types::sp_runtime::DispatchError,
                pub dispatch_info:
                    runtime_types::frame_support::weights::DispatchInfo,
            }
            impl ::subxt::Event for ExtrinsicFailed {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "ExtrinsicFailed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct CodeUpdated;
            impl ::subxt::Event for CodeUpdated {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "CodeUpdated";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct NewAccount {
                pub account: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for NewAccount {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "NewAccount";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct KilledAccount {
                pub account: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for KilledAccount {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "KilledAccount";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Remarked {
                pub sender: ::subxt::sp_core::crypto::AccountId32,
                pub hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Event for Remarked {
                const PALLET: &'static str = "System";
                const EVENT: &'static str = "Remarked";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Account(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Account {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "Account";
                type Value = runtime_types::frame_system::AccountInfo<
                    ::core::primitive::u32,
                    runtime_types::pallet_balances::AccountData<
                        ::core::primitive::u128,
                    >,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct ExtrinsicCount;
            impl ::subxt::StorageEntry for ExtrinsicCount {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "ExtrinsicCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct BlockWeight;
            impl ::subxt::StorageEntry for BlockWeight {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "BlockWeight";
                type Value =
                    runtime_types::frame_support::weights::PerDispatchClass<
                        ::core::primitive::u64,
                    >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct AllExtrinsicsLen;
            impl ::subxt::StorageEntry for AllExtrinsicsLen {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "AllExtrinsicsLen";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct BlockHash(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for BlockHash {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "BlockHash";
                type Value = ::subxt::sp_core::H256;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ExtrinsicData(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ExtrinsicData {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "ExtrinsicData";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct Number;
            impl ::subxt::StorageEntry for Number {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "Number";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ParentHash;
            impl ::subxt::StorageEntry for ParentHash {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "ParentHash";
                type Value = ::subxt::sp_core::H256;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Digest;
            impl ::subxt::StorageEntry for Digest {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "Digest";
                type Value = runtime_types::sp_runtime::generic::digest::Digest;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Events;
            impl ::subxt::StorageEntry for Events {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "Events";
                type Value = ::std::vec::Vec<
                    runtime_types::frame_system::EventRecord<
                        runtime_types::egg_standalone_runtime::Event,
                        ::subxt::sp_core::H256,
                    >,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct EventCount;
            impl ::subxt::StorageEntry for EventCount {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "EventCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct EventTopics(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for EventTopics {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "EventTopics";
                type Value = ::std::vec::Vec<(
                    ::core::primitive::u32,
                    ::core::primitive::u32,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct LastRuntimeUpgrade;
            impl ::subxt::StorageEntry for LastRuntimeUpgrade {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "LastRuntimeUpgrade";
                type Value =
                    runtime_types::frame_system::LastRuntimeUpgradeInfo;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct UpgradedToU32RefCount;
            impl ::subxt::StorageEntry for UpgradedToU32RefCount {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "UpgradedToU32RefCount";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct UpgradedToTripleRefCount;
            impl ::subxt::StorageEntry for UpgradedToTripleRefCount {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "UpgradedToTripleRefCount";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ExecutionPhase;
            impl ::subxt::StorageEntry for ExecutionPhase {
                const PALLET: &'static str = "System";
                const STORAGE: &'static str = "ExecutionPhase";
                type Value = runtime_types::frame_system::Phase;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn account(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::frame_system::AccountInfo<
                        ::core::primitive::u32,
                        runtime_types::pallet_balances::AccountData<
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Account(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn account_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Account>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn extrinsic_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = ExtrinsicCount;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn block_weight(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::weights::PerDispatchClass<
                        ::core::primitive::u64,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = BlockWeight;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn all_extrinsics_len(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = AllExtrinsicsLen;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn block_hash(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::sp_core::H256,
                    ::subxt::BasicError,
                > {
                    let entry = BlockHash(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn block_hash_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, BlockHash>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn extrinsic_data(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = ExtrinsicData(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn extrinsic_data_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ExtrinsicData>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn number(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = Number;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn parent_hash(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::sp_core::H256,
                    ::subxt::BasicError,
                > {
                    let entry = ParentHash;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn digest(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::sp_runtime::generic::digest::Digest,
                    ::subxt::BasicError,
                > {
                    let entry = Digest;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn events(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<
                        runtime_types::frame_system::EventRecord<
                            runtime_types::egg_standalone_runtime::Event,
                            ::subxt::sp_core::H256,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Events;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn event_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = EventCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn event_topics(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = EventTopics(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn event_topics_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, EventTopics>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn last_runtime_upgrade(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::frame_system::LastRuntimeUpgradeInfo,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = LastRuntimeUpgrade;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn upgraded_to_u32_ref_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = UpgradedToU32RefCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn upgraded_to_triple_ref_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = UpgradedToTripleRefCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn execution_phase(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<runtime_types::frame_system::Phase>,
                    ::subxt::BasicError,
                > {
                    let entry = ExecutionPhase;
                    self.client.storage().fetch(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn block_weights(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_system::limits::BlockWeights,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 242u8, 5u8, 42u8, 1u8, 0u8, 0u8, 0u8, 0u8,
                            136u8, 82u8, 106u8, 116u8, 0u8, 0u8, 0u8, 64u8,
                            89u8, 115u8, 7u8, 0u8, 0u8, 0u8, 0u8, 1u8, 192u8,
                            24u8, 15u8, 164u8, 75u8, 0u8, 0u8, 0u8, 1u8, 0u8,
                            230u8, 189u8, 79u8, 87u8, 0u8, 0u8, 0u8, 1u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 64u8, 89u8,
                            115u8, 7u8, 0u8, 0u8, 0u8, 0u8, 1u8, 192u8, 186u8,
                            163u8, 190u8, 104u8, 0u8, 0u8, 0u8, 1u8, 0u8,
                            136u8, 82u8, 106u8, 116u8, 0u8, 0u8, 0u8, 1u8, 0u8,
                            162u8, 148u8, 26u8, 29u8, 0u8, 0u8, 0u8, 64u8,
                            89u8, 115u8, 7u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            0u8,
                        ][..],
                    )?)
                }
                pub fn block_length(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_system::limits::BlockLength,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 0u8, 60u8, 0u8, 0u8, 0u8, 80u8, 0u8, 0u8, 0u8,
                            80u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn block_hash_count(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[250u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn db_weight(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::weights::RuntimeDbWeight,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            64u8, 120u8, 125u8, 1u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            225u8, 245u8, 5u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn version(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::sp_version::RuntimeVersion,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            52u8, 100u8, 107u8, 103u8, 45u8, 112u8, 97u8,
                            114u8, 97u8, 99u8, 104u8, 97u8, 105u8, 110u8, 52u8,
                            100u8, 107u8, 103u8, 45u8, 112u8, 97u8, 114u8,
                            97u8, 99u8, 104u8, 97u8, 105u8, 110u8, 1u8, 0u8,
                            0u8, 0u8, 1u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            48u8, 223u8, 106u8, 203u8, 104u8, 153u8, 7u8, 96u8,
                            155u8, 4u8, 0u8, 0u8, 0u8, 55u8, 227u8, 151u8,
                            252u8, 124u8, 145u8, 245u8, 228u8, 1u8, 0u8, 0u8,
                            0u8, 64u8, 254u8, 58u8, 212u8, 1u8, 248u8, 149u8,
                            154u8, 5u8, 0u8, 0u8, 0u8, 159u8, 95u8, 130u8,
                            43u8, 111u8, 212u8, 86u8, 246u8, 1u8, 0u8, 0u8,
                            0u8, 210u8, 188u8, 152u8, 151u8, 238u8, 208u8,
                            143u8, 21u8, 3u8, 0u8, 0u8, 0u8, 247u8, 139u8,
                            39u8, 139u8, 229u8, 63u8, 69u8, 76u8, 2u8, 0u8,
                            0u8, 0u8, 171u8, 60u8, 5u8, 114u8, 41u8, 31u8,
                            235u8, 139u8, 1u8, 0u8, 0u8, 0u8, 221u8, 113u8,
                            141u8, 92u8, 197u8, 50u8, 98u8, 212u8, 1u8, 0u8,
                            0u8, 0u8, 188u8, 157u8, 137u8, 144u8, 79u8, 91u8,
                            146u8, 63u8, 1u8, 0u8, 0u8, 0u8, 55u8, 200u8,
                            187u8, 19u8, 80u8, 169u8, 162u8, 168u8, 1u8, 0u8,
                            0u8, 0u8, 237u8, 153u8, 197u8, 172u8, 178u8, 94u8,
                            237u8, 245u8, 3u8, 0u8, 0u8, 0u8, 81u8, 255u8,
                            254u8, 165u8, 111u8, 208u8, 197u8, 212u8, 1u8, 0u8,
                            0u8, 0u8, 1u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn ss58_prefix(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(&mut &[42u8, 0u8][..])?)
                }
            }
        }
    }
    pub mod timestamp {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set {
                #[codec(compact)]
                pub now: ::core::primitive::u64,
            }
            impl ::subxt::Call for set {
                const PALLET: &'static str = "Timestamp";
                const FUNCTION: &'static str = "set";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set(
                    &self,
                    now: ::core::primitive::u64,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set,
                    DispatchError,
                > {
                    let call = set { now };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Now;
            impl ::subxt::StorageEntry for Now {
                const PALLET: &'static str = "Timestamp";
                const STORAGE: &'static str = "Now";
                type Value = ::core::primitive::u64;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct DidUpdate;
            impl ::subxt::StorageEntry for DidUpdate {
                const PALLET: &'static str = "Timestamp";
                const STORAGE: &'static str = "DidUpdate";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn now(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    let entry = Now;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn did_update(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = DidUpdate;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn minimum_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[112u8, 23u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod sudo {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct sudo {
                pub call: ::std::boxed::Box<
                    runtime_types::egg_standalone_runtime::Call,
                >,
            }
            impl ::subxt::Call for sudo {
                const PALLET: &'static str = "Sudo";
                const FUNCTION: &'static str = "sudo";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct sudo_unchecked_weight {
                pub call: ::std::boxed::Box<
                    runtime_types::egg_standalone_runtime::Call,
                >,
                pub weight: ::core::primitive::u64,
            }
            impl ::subxt::Call for sudo_unchecked_weight {
                const PALLET: &'static str = "Sudo";
                const FUNCTION: &'static str = "sudo_unchecked_weight";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_key {
                pub new: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
            }
            impl ::subxt::Call for set_key {
                const PALLET: &'static str = "Sudo";
                const FUNCTION: &'static str = "set_key";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct sudo_as {
                pub who: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub call: ::std::boxed::Box<
                    runtime_types::egg_standalone_runtime::Call,
                >,
            }
            impl ::subxt::Call for sudo_as {
                const PALLET: &'static str = "Sudo";
                const FUNCTION: &'static str = "sudo_as";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn sudo(
                    &self,
                    call: runtime_types::egg_standalone_runtime::Call,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    sudo,
                    DispatchError,
                > {
                    let call = sudo {
                        call: ::std::boxed::Box::new(call),
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn sudo_unchecked_weight(
                    &self,
                    call: runtime_types::egg_standalone_runtime::Call,
                    weight: ::core::primitive::u64,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    sudo_unchecked_weight,
                    DispatchError,
                > {
                    let call = sudo_unchecked_weight {
                        call: ::std::boxed::Box::new(call),
                        weight,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_key(
                    &self,
                    new: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_key,
                    DispatchError,
                > {
                    let call = set_key { new };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn sudo_as(
                    &self,
                    who: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    call: runtime_types::egg_standalone_runtime::Call,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    sudo_as,
                    DispatchError,
                > {
                    let call = sudo_as {
                        who,
                        call: ::std::boxed::Box::new(call),
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_sudo::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Sudid {
                pub sudo_result: ::core::result::Result<
                    (),
                    runtime_types::sp_runtime::DispatchError,
                >,
            }
            impl ::subxt::Event for Sudid {
                const PALLET: &'static str = "Sudo";
                const EVENT: &'static str = "Sudid";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct KeyChanged {
                pub old_sudoer: ::core::option::Option<
                    ::subxt::sp_core::crypto::AccountId32,
                >,
            }
            impl ::subxt::Event for KeyChanged {
                const PALLET: &'static str = "Sudo";
                const EVENT: &'static str = "KeyChanged";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct SudoAsDone {
                pub sudo_result: ::core::result::Result<
                    (),
                    runtime_types::sp_runtime::DispatchError,
                >,
            }
            impl ::subxt::Event for SudoAsDone {
                const PALLET: &'static str = "Sudo";
                const EVENT: &'static str = "SudoAsDone";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Key;
            impl ::subxt::StorageEntry for Key {
                const PALLET: &'static str = "Sudo";
                const STORAGE: &'static str = "Key";
                type Value = ::subxt::sp_core::crypto::AccountId32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn key(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Key;
                    self.client.storage().fetch(&entry, hash).await
                }
            }
        }
    }
    pub mod randomness_collective_flip {
        use super::runtime_types;
        pub mod storage {
            use super::runtime_types;
            pub struct RandomMaterial;
            impl ::subxt::StorageEntry for RandomMaterial {
                const PALLET: &'static str = "RandomnessCollectiveFlip";
                const STORAGE: &'static str = "RandomMaterial";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: subxt :: sp_core :: H256 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }                pub async fn random_material (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: subxt :: sp_core :: H256 > , :: subxt :: BasicError >{
                    let entry = RandomMaterial;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
    }
    pub mod balances {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Call for transfer {
                const PALLET: &'static str = "Balances";
                const FUNCTION: &'static str = "transfer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_balance {
                pub who: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub new_free: ::core::primitive::u128,
                #[codec(compact)]
                pub new_reserved: ::core::primitive::u128,
            }
            impl ::subxt::Call for set_balance {
                const PALLET: &'static str = "Balances";
                const FUNCTION: &'static str = "set_balance";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_transfer {
                pub source: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Call for force_transfer {
                const PALLET: &'static str = "Balances";
                const FUNCTION: &'static str = "force_transfer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer_keep_alive {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Call for transfer_keep_alive {
                const PALLET: &'static str = "Balances";
                const FUNCTION: &'static str = "transfer_keep_alive";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer_all {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub keep_alive: ::core::primitive::bool,
            }
            impl ::subxt::Call for transfer_all {
                const PALLET: &'static str = "Balances";
                const FUNCTION: &'static str = "transfer_all";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_unreserve {
                pub who: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Call for force_unreserve {
                const PALLET: &'static str = "Balances";
                const FUNCTION: &'static str = "force_unreserve";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn transfer(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    value: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer,
                    DispatchError,
                > {
                    let call = transfer { dest, value };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_balance(
                    &self,
                    who: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    new_free: ::core::primitive::u128,
                    new_reserved: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_balance,
                    DispatchError,
                > {
                    let call = set_balance {
                        who,
                        new_free,
                        new_reserved,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_transfer(
                    &self,
                    source: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    value: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_transfer,
                    DispatchError,
                > {
                    let call = force_transfer {
                        source,
                        dest,
                        value,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn transfer_keep_alive(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    value: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer_keep_alive,
                    DispatchError,
                > {
                    let call = transfer_keep_alive { dest, value };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn transfer_all(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    keep_alive: ::core::primitive::bool,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer_all,
                    DispatchError,
                > {
                    let call = transfer_all { dest, keep_alive };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_unreserve(
                    &self,
                    who: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    amount: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_unreserve,
                    DispatchError,
                > {
                    let call = force_unreserve { who, amount };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_balances::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Endowed {
                pub account: ::subxt::sp_core::crypto::AccountId32,
                pub free_balance: ::core::primitive::u128,
            }
            impl ::subxt::Event for Endowed {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Endowed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct DustLost {
                pub account: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for DustLost {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "DustLost";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Transfer {
                pub from: ::subxt::sp_core::crypto::AccountId32,
                pub to: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Transfer {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Transfer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BalanceSet {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub free: ::core::primitive::u128,
                pub reserved: ::core::primitive::u128,
            }
            impl ::subxt::Event for BalanceSet {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "BalanceSet";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Reserved {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Reserved {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Reserved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Unreserved {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Unreserved {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Unreserved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ReserveRepatriated { pub from : :: subxt :: sp_core :: crypto :: AccountId32 , pub to : :: subxt :: sp_core :: crypto :: AccountId32 , pub amount : :: core :: primitive :: u128 , pub destination_status : runtime_types :: frame_support :: traits :: tokens :: misc :: BalanceStatus , }
            impl ::subxt::Event for ReserveRepatriated {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "ReserveRepatriated";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Deposit {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Deposit {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Deposit";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Withdraw {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Withdraw {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Withdraw";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Slashed {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Slashed {
                const PALLET: &'static str = "Balances";
                const EVENT: &'static str = "Slashed";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct TotalIssuance;
            impl ::subxt::StorageEntry for TotalIssuance {
                const PALLET: &'static str = "Balances";
                const STORAGE: &'static str = "TotalIssuance";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Account(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Account {
                const PALLET: &'static str = "Balances";
                const STORAGE: &'static str = "Account";
                type Value = runtime_types::pallet_balances::AccountData<
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct Locks(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Locks {
                const PALLET: &'static str = "Balances";
                const STORAGE: &'static str = "Locks";
                type Value = runtime_types :: frame_support :: storage :: weak_bounded_vec :: WeakBoundedVec < runtime_types :: pallet_balances :: BalanceLock < :: core :: primitive :: u128 > > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct Reserves(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Reserves {
                const PALLET: &'static str = "Balances";
                const STORAGE: &'static str = "Reserves";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < runtime_types :: pallet_balances :: ReserveData < [:: core :: primitive :: u8 ; 8usize] , :: core :: primitive :: u128 > > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageVersion;
            impl ::subxt::StorageEntry for StorageVersion {
                const PALLET: &'static str = "Balances";
                const STORAGE: &'static str = "StorageVersion";
                type Value = runtime_types::pallet_balances::Releases;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn total_issuance(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = TotalIssuance;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn account(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_balances::AccountData<
                        ::core::primitive::u128,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Account(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn account_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Account>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn locks (& self , _0 : :: subxt :: sp_core :: crypto :: AccountId32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: weak_bounded_vec :: WeakBoundedVec < runtime_types :: pallet_balances :: BalanceLock < :: core :: primitive :: u128 > > , :: subxt :: BasicError >{
                    let entry = Locks(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn locks_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Locks>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn reserves (& self , _0 : :: subxt :: sp_core :: crypto :: AccountId32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < runtime_types :: pallet_balances :: ReserveData < [:: core :: primitive :: u8 ; 8usize] , :: core :: primitive :: u128 > > , :: subxt :: BasicError >{
                    let entry = Reserves(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn reserves_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Reserves>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn storage_version(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_balances::Releases,
                    ::subxt::BasicError,
                > {
                    let entry = StorageVersion;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn existential_deposit(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 202u8, 154u8, 59u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn max_locks(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[50u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn max_reserves(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[50u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod transaction_payment {
        use super::runtime_types;
        pub mod storage {
            use super::runtime_types;
            pub struct NextFeeMultiplier;
            impl ::subxt::StorageEntry for NextFeeMultiplier {
                const PALLET: &'static str = "TransactionPayment";
                const STORAGE: &'static str = "NextFeeMultiplier";
                type Value =
                    runtime_types::sp_arithmetic::fixed_point::FixedU128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageVersion;
            impl ::subxt::StorageEntry for StorageVersion {
                const PALLET: &'static str = "TransactionPayment";
                const STORAGE: &'static str = "StorageVersion";
                type Value =
                    runtime_types::pallet_transaction_payment::Releases;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn next_fee_multiplier(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::fixed_point::FixedU128,
                    ::subxt::BasicError,
                > {
                    let entry = NextFeeMultiplier;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn storage_version(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_transaction_payment::Releases,
                    ::subxt::BasicError,
                > {
                    let entry = StorageVersion;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn transaction_byte_fee(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            64u8, 66u8, 15u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn operational_fee_multiplier(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u8,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(&mut &[5u8][..])?)
                }                pub fn weight_to_fee (& self) -> :: core :: result :: Result < :: std :: vec :: Vec < runtime_types :: frame_support :: weights :: WeightToFeeCoefficient < :: core :: primitive :: u128 > > , :: subxt :: BasicError >{
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            4u8, 1u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 1u8,
                        ][..],
                    )?)
                }
            }
        }
    }
    pub mod authorship {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_uncles {
                pub new_uncles: ::std::vec::Vec<
                    runtime_types::sp_runtime::generic::header::Header<
                        ::core::primitive::u32,
                        runtime_types::sp_runtime::traits::BlakeTwo256,
                    >,
                >,
            }
            impl ::subxt::Call for set_uncles {
                const PALLET: &'static str = "Authorship";
                const FUNCTION: &'static str = "set_uncles";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set_uncles(
                    &self,
                    new_uncles: ::std::vec::Vec<
                        runtime_types::sp_runtime::generic::header::Header<
                            ::core::primitive::u32,
                            runtime_types::sp_runtime::traits::BlakeTwo256,
                        >,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_uncles,
                    DispatchError,
                > {
                    let call = set_uncles { new_uncles };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Uncles;
            impl ::subxt::StorageEntry for Uncles {
                const PALLET: &'static str = "Authorship";
                const STORAGE: &'static str = "Uncles";
                type Value = ::std::vec::Vec<
                    runtime_types::pallet_authorship::UncleEntryItem<
                        ::core::primitive::u32,
                        ::subxt::sp_core::H256,
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Author;
            impl ::subxt::StorageEntry for Author {
                const PALLET: &'static str = "Authorship";
                const STORAGE: &'static str = "Author";
                type Value = ::subxt::sp_core::crypto::AccountId32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct DidSetUncles;
            impl ::subxt::StorageEntry for DidSetUncles {
                const PALLET: &'static str = "Authorship";
                const STORAGE: &'static str = "DidSetUncles";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn uncles(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<
                        runtime_types::pallet_authorship::UncleEntryItem<
                            ::core::primitive::u32,
                            ::subxt::sp_core::H256,
                            ::subxt::sp_core::crypto::AccountId32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Uncles;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn author(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Author;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn did_set_uncles(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = DidSetUncles;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn uncle_generations(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod aura {
        use super::runtime_types;
        pub mod storage {
            use super::runtime_types;
            pub struct Authorities;
            impl ::subxt::StorageEntry for Authorities {
                const PALLET: &'static str = "Aura";
                const STORAGE: &'static str = "Authorities";
                type Value = runtime_types :: frame_support :: storage :: weak_bounded_vec :: WeakBoundedVec < runtime_types :: sp_consensus_aura :: sr25519 :: app_sr25519 :: Public > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CurrentSlot;
            impl ::subxt::StorageEntry for CurrentSlot {
                const PALLET: &'static str = "Aura";
                const STORAGE: &'static str = "CurrentSlot";
                type Value = runtime_types::sp_consensus_slots::Slot;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }                pub async fn authorities (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: weak_bounded_vec :: WeakBoundedVec < runtime_types :: sp_consensus_aura :: sr25519 :: app_sr25519 :: Public > , :: subxt :: BasicError >{
                    let entry = Authorities;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn current_slot(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::sp_consensus_slots::Slot,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentSlot;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
    }
    pub mod grandpa {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct report_equivocation {
                pub equivocation_proof: ::std::boxed::Box<
                    runtime_types::sp_finality_grandpa::EquivocationProof<
                        ::subxt::sp_core::H256,
                        ::core::primitive::u32,
                    >,
                >,
                pub key_owner_proof: runtime_types::sp_session::MembershipProof,
            }
            impl ::subxt::Call for report_equivocation {
                const PALLET: &'static str = "Grandpa";
                const FUNCTION: &'static str = "report_equivocation";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct report_equivocation_unsigned {
                pub equivocation_proof: ::std::boxed::Box<
                    runtime_types::sp_finality_grandpa::EquivocationProof<
                        ::subxt::sp_core::H256,
                        ::core::primitive::u32,
                    >,
                >,
                pub key_owner_proof: runtime_types::sp_session::MembershipProof,
            }
            impl ::subxt::Call for report_equivocation_unsigned {
                const PALLET: &'static str = "Grandpa";
                const FUNCTION: &'static str = "report_equivocation_unsigned";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct note_stalled {
                pub delay: ::core::primitive::u32,
                pub best_finalized_block_number: ::core::primitive::u32,
            }
            impl ::subxt::Call for note_stalled {
                const PALLET: &'static str = "Grandpa";
                const FUNCTION: &'static str = "note_stalled";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn report_equivocation(
                    &self,
                    equivocation_proof : runtime_types :: sp_finality_grandpa :: EquivocationProof < :: subxt :: sp_core :: H256 , :: core :: primitive :: u32 >,
                    key_owner_proof: runtime_types::sp_session::MembershipProof,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    report_equivocation,
                    DispatchError,
                > {
                    let call = report_equivocation {
                        equivocation_proof: ::std::boxed::Box::new(
                            equivocation_proof,
                        ),
                        key_owner_proof,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn report_equivocation_unsigned(
                    &self,
                    equivocation_proof : runtime_types :: sp_finality_grandpa :: EquivocationProof < :: subxt :: sp_core :: H256 , :: core :: primitive :: u32 >,
                    key_owner_proof: runtime_types::sp_session::MembershipProof,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    report_equivocation_unsigned,
                    DispatchError,
                > {
                    let call = report_equivocation_unsigned {
                        equivocation_proof: ::std::boxed::Box::new(
                            equivocation_proof,
                        ),
                        key_owner_proof,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn note_stalled(
                    &self,
                    delay: ::core::primitive::u32,
                    best_finalized_block_number: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    note_stalled,
                    DispatchError,
                > {
                    let call = note_stalled {
                        delay,
                        best_finalized_block_number,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_grandpa::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct NewAuthorities {
                pub authority_set: ::std::vec::Vec<(
                    runtime_types::sp_finality_grandpa::app::Public,
                    ::core::primitive::u64,
                )>,
            }
            impl ::subxt::Event for NewAuthorities {
                const PALLET: &'static str = "Grandpa";
                const EVENT: &'static str = "NewAuthorities";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Paused;
            impl ::subxt::Event for Paused {
                const PALLET: &'static str = "Grandpa";
                const EVENT: &'static str = "Paused";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Resumed;
            impl ::subxt::Event for Resumed {
                const PALLET: &'static str = "Grandpa";
                const EVENT: &'static str = "Resumed";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct State;
            impl ::subxt::StorageEntry for State {
                const PALLET: &'static str = "Grandpa";
                const STORAGE: &'static str = "State";
                type Value = runtime_types::pallet_grandpa::StoredState<
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct PendingChange;
            impl ::subxt::StorageEntry for PendingChange {
                const PALLET: &'static str = "Grandpa";
                const STORAGE: &'static str = "PendingChange";
                type Value = runtime_types::pallet_grandpa::StoredPendingChange<
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextForced;
            impl ::subxt::StorageEntry for NextForced {
                const PALLET: &'static str = "Grandpa";
                const STORAGE: &'static str = "NextForced";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Stalled;
            impl ::subxt::StorageEntry for Stalled {
                const PALLET: &'static str = "Grandpa";
                const STORAGE: &'static str = "Stalled";
                type Value = (::core::primitive::u32, ::core::primitive::u32);
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CurrentSetId;
            impl ::subxt::StorageEntry for CurrentSetId {
                const PALLET: &'static str = "Grandpa";
                const STORAGE: &'static str = "CurrentSetId";
                type Value = ::core::primitive::u64;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct SetIdSession(pub ::core::primitive::u64);
            impl ::subxt::StorageEntry for SetIdSession {
                const PALLET: &'static str = "Grandpa";
                const STORAGE: &'static str = "SetIdSession";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn state(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_grandpa::StoredState<
                        ::core::primitive::u32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = State;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn pending_change(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_grandpa::StoredPendingChange<
                            ::core::primitive::u32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = PendingChange;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn next_forced(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = NextForced;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn stalled(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = Stalled;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn current_set_id(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentSetId;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn set_id_session(
                    &self,
                    _0: ::core::primitive::u64,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = SetIdSession(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn set_id_session_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, SetIdSession>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn max_authorities(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[232u8, 3u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod democracy {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct propose {
                pub proposal_hash: ::subxt::sp_core::H256,
                #[codec(compact)]
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Call for propose {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "propose";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct second {
                #[codec(compact)]
                pub proposal: ::core::primitive::u32,
                #[codec(compact)]
                pub seconds_upper_bound: ::core::primitive::u32,
            }
            impl ::subxt::Call for second {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "second";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct vote {
                #[codec(compact)]
                pub ref_index: ::core::primitive::u32,
                pub vote: runtime_types::pallet_democracy::vote::AccountVote<
                    ::core::primitive::u128,
                >,
            }
            impl ::subxt::Call for vote {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "vote";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct emergency_cancel {
                pub ref_index: ::core::primitive::u32,
            }
            impl ::subxt::Call for emergency_cancel {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "emergency_cancel";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct external_propose {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for external_propose {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "external_propose";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct external_propose_majority {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for external_propose_majority {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "external_propose_majority";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct external_propose_default {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for external_propose_default {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "external_propose_default";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct fast_track {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub voting_period: ::core::primitive::u32,
                pub delay: ::core::primitive::u32,
            }
            impl ::subxt::Call for fast_track {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "fast_track";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct veto_external {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for veto_external {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "veto_external";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct cancel_referendum {
                #[codec(compact)]
                pub ref_index: ::core::primitive::u32,
            }
            impl ::subxt::Call for cancel_referendum {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "cancel_referendum";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct cancel_queued {
                pub which: ::core::primitive::u32,
            }
            impl ::subxt::Call for cancel_queued {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "cancel_queued";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct delegate {
                pub to: ::subxt::sp_core::crypto::AccountId32,
                pub conviction:
                    runtime_types::pallet_democracy::conviction::Conviction,
                pub balance: ::core::primitive::u128,
            }
            impl ::subxt::Call for delegate {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "delegate";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct undelegate;
            impl ::subxt::Call for undelegate {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "undelegate";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct clear_public_proposals;
            impl ::subxt::Call for clear_public_proposals {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "clear_public_proposals";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct note_preimage {
                pub encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for note_preimage {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "note_preimage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct note_preimage_operational {
                pub encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for note_preimage_operational {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "note_preimage_operational";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct note_imminent_preimage {
                pub encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for note_imminent_preimage {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "note_imminent_preimage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct note_imminent_preimage_operational {
                pub encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for note_imminent_preimage_operational {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str =
                    "note_imminent_preimage_operational";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct reap_preimage {
                pub proposal_hash: ::subxt::sp_core::H256,
                #[codec(compact)]
                pub proposal_len_upper_bound: ::core::primitive::u32,
            }
            impl ::subxt::Call for reap_preimage {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "reap_preimage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unlock {
                pub target: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for unlock {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "unlock";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct remove_vote {
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Call for remove_vote {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "remove_vote";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remove_other_vote {
                pub target: ::subxt::sp_core::crypto::AccountId32,
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Call for remove_other_vote {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "remove_other_vote";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct enact_proposal {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Call for enact_proposal {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "enact_proposal";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct blacklist {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub maybe_ref_index:
                    ::core::option::Option<::core::primitive::u32>,
            }
            impl ::subxt::Call for blacklist {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "blacklist";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct cancel_proposal {
                #[codec(compact)]
                pub prop_index: ::core::primitive::u32,
            }
            impl ::subxt::Call for cancel_proposal {
                const PALLET: &'static str = "Democracy";
                const FUNCTION: &'static str = "cancel_proposal";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn propose(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                    value: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    propose,
                    DispatchError,
                > {
                    let call = propose {
                        proposal_hash,
                        value,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn second(
                    &self,
                    proposal: ::core::primitive::u32,
                    seconds_upper_bound: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    second,
                    DispatchError,
                > {
                    let call = second {
                        proposal,
                        seconds_upper_bound,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn vote(
                    &self,
                    ref_index: ::core::primitive::u32,
                    vote: runtime_types::pallet_democracy::vote::AccountVote<
                        ::core::primitive::u128,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    vote,
                    DispatchError,
                > {
                    let call = vote { ref_index, vote };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn emergency_cancel(
                    &self,
                    ref_index: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    emergency_cancel,
                    DispatchError,
                > {
                    let call = emergency_cancel { ref_index };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn external_propose(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    external_propose,
                    DispatchError,
                > {
                    let call = external_propose { proposal_hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn external_propose_majority(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    external_propose_majority,
                    DispatchError,
                > {
                    let call = external_propose_majority { proposal_hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn external_propose_default(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    external_propose_default,
                    DispatchError,
                > {
                    let call = external_propose_default { proposal_hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn fast_track(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                    voting_period: ::core::primitive::u32,
                    delay: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    fast_track,
                    DispatchError,
                > {
                    let call = fast_track {
                        proposal_hash,
                        voting_period,
                        delay,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn veto_external(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    veto_external,
                    DispatchError,
                > {
                    let call = veto_external { proposal_hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn cancel_referendum(
                    &self,
                    ref_index: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    cancel_referendum,
                    DispatchError,
                > {
                    let call = cancel_referendum { ref_index };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn cancel_queued(
                    &self,
                    which: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    cancel_queued,
                    DispatchError,
                > {
                    let call = cancel_queued { which };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn delegate(
                    &self,
                    to: ::subxt::sp_core::crypto::AccountId32,
                    conviction : runtime_types :: pallet_democracy :: conviction :: Conviction,
                    balance: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    delegate,
                    DispatchError,
                > {
                    let call = delegate {
                        to,
                        conviction,
                        balance,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn undelegate(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    undelegate,
                    DispatchError,
                > {
                    let call = undelegate {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn clear_public_proposals(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    clear_public_proposals,
                    DispatchError,
                > {
                    let call = clear_public_proposals {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn note_preimage(
                    &self,
                    encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    note_preimage,
                    DispatchError,
                > {
                    let call = note_preimage { encoded_proposal };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn note_preimage_operational(
                    &self,
                    encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    note_preimage_operational,
                    DispatchError,
                > {
                    let call = note_preimage_operational { encoded_proposal };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn note_imminent_preimage(
                    &self,
                    encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    note_imminent_preimage,
                    DispatchError,
                > {
                    let call = note_imminent_preimage { encoded_proposal };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn note_imminent_preimage_operational(
                    &self,
                    encoded_proposal: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    note_imminent_preimage_operational,
                    DispatchError,
                > {
                    let call =
                        note_imminent_preimage_operational { encoded_proposal };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn reap_preimage(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                    proposal_len_upper_bound: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    reap_preimage,
                    DispatchError,
                > {
                    let call = reap_preimage {
                        proposal_hash,
                        proposal_len_upper_bound,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unlock(
                    &self,
                    target: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unlock,
                    DispatchError,
                > {
                    let call = unlock { target };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remove_vote(
                    &self,
                    index: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remove_vote,
                    DispatchError,
                > {
                    let call = remove_vote { index };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remove_other_vote(
                    &self,
                    target: ::subxt::sp_core::crypto::AccountId32,
                    index: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remove_other_vote,
                    DispatchError,
                > {
                    let call = remove_other_vote { target, index };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn enact_proposal(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                    index: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    enact_proposal,
                    DispatchError,
                > {
                    let call = enact_proposal {
                        proposal_hash,
                        index,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn blacklist(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                    maybe_ref_index: ::core::option::Option<
                        ::core::primitive::u32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    blacklist,
                    DispatchError,
                > {
                    let call = blacklist {
                        proposal_hash,
                        maybe_ref_index,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn cancel_proposal(
                    &self,
                    prop_index: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    cancel_proposal,
                    DispatchError,
                > {
                    let call = cancel_proposal { prop_index };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_democracy::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Proposed {
                pub proposal_index: ::core::primitive::u32,
                pub deposit: ::core::primitive::u128,
            }
            impl ::subxt::Event for Proposed {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Proposed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Tabled {
                pub proposal_index: ::core::primitive::u32,
                pub deposit: ::core::primitive::u128,
                pub depositors:
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
            }
            impl ::subxt::Event for Tabled {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Tabled";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ExternalTabled;
            impl ::subxt::Event for ExternalTabled {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "ExternalTabled";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Started { pub ref_index : :: core :: primitive :: u32 , pub threshold : runtime_types :: pallet_democracy :: vote_threshold :: VoteThreshold , }
            impl ::subxt::Event for Started {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Started";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Passed {
                pub ref_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Passed {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Passed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct NotPassed {
                pub ref_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for NotPassed {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "NotPassed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Cancelled {
                pub ref_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Cancelled {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Cancelled";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Executed {
                pub ref_index: ::core::primitive::u32,
                pub result: ::core::result::Result<
                    (),
                    runtime_types::sp_runtime::DispatchError,
                >,
            }
            impl ::subxt::Event for Executed {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Executed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Delegated {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub target: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for Delegated {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Delegated";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Undelegated {
                pub account: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for Undelegated {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Undelegated";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Vetoed {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub proposal_hash: ::subxt::sp_core::H256,
                pub until: ::core::primitive::u32,
            }
            impl ::subxt::Event for Vetoed {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Vetoed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PreimageNoted {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub deposit: ::core::primitive::u128,
            }
            impl ::subxt::Event for PreimageNoted {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "PreimageNoted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PreimageUsed {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub provider: ::subxt::sp_core::crypto::AccountId32,
                pub deposit: ::core::primitive::u128,
            }
            impl ::subxt::Event for PreimageUsed {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "PreimageUsed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PreimageInvalid {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub ref_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for PreimageInvalid {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "PreimageInvalid";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PreimageMissing {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub ref_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for PreimageMissing {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "PreimageMissing";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PreimageReaped {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub provider: ::subxt::sp_core::crypto::AccountId32,
                pub deposit: ::core::primitive::u128,
                pub reaper: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for PreimageReaped {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "PreimageReaped";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Blacklisted {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Event for Blacklisted {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Blacklisted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Voted {
                pub voter: ::subxt::sp_core::crypto::AccountId32,
                pub ref_index: ::core::primitive::u32,
                pub vote: runtime_types::pallet_democracy::vote::AccountVote<
                    ::core::primitive::u128,
                >,
            }
            impl ::subxt::Event for Voted {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Voted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Seconded {
                pub seconder: ::subxt::sp_core::crypto::AccountId32,
                pub prop_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Seconded {
                const PALLET: &'static str = "Democracy";
                const EVENT: &'static str = "Seconded";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct PublicPropCount;
            impl ::subxt::StorageEntry for PublicPropCount {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "PublicPropCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct PublicProps;
            impl ::subxt::StorageEntry for PublicProps {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "PublicProps";
                type Value = ::std::vec::Vec<(
                    ::core::primitive::u32,
                    ::subxt::sp_core::H256,
                    ::subxt::sp_core::crypto::AccountId32,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct DepositOf(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for DepositOf {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "DepositOf";
                type Value = (
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    ::core::primitive::u128,
                );
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct Preimages(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for Preimages {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "Preimages";
                type Value = runtime_types::pallet_democracy::PreimageStatus<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Identity,
                        ),
                    ])
                }
            }
            pub struct ReferendumCount;
            impl ::subxt::StorageEntry for ReferendumCount {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "ReferendumCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct LowestUnbaked;
            impl ::subxt::StorageEntry for LowestUnbaked {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "LowestUnbaked";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ReferendumInfoOf(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ReferendumInfoOf {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "ReferendumInfoOf";
                type Value =
                    runtime_types::pallet_democracy::types::ReferendumInfo<
                        ::core::primitive::u32,
                        ::subxt::sp_core::H256,
                        ::core::primitive::u128,
                    >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct VotingOf(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for VotingOf {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "VotingOf";
                type Value = runtime_types::pallet_democracy::vote::Voting<
                    ::core::primitive::u128,
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct LastTabledWasExternal;
            impl ::subxt::StorageEntry for LastTabledWasExternal {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "LastTabledWasExternal";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextExternal;
            impl ::subxt::StorageEntry for NextExternal {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "NextExternal";
                type Value = (:: subxt :: sp_core :: H256 , runtime_types :: pallet_democracy :: vote_threshold :: VoteThreshold ,) ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Blacklist(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for Blacklist {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "Blacklist";
                type Value = (
                    ::core::primitive::u32,
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                );
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Identity,
                        ),
                    ])
                }
            }
            pub struct Cancellations(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for Cancellations {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "Cancellations";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Identity,
                        ),
                    ])
                }
            }
            pub struct StorageVersion;
            impl ::subxt::StorageEntry for StorageVersion {
                const PALLET: &'static str = "Democracy";
                const STORAGE: &'static str = "StorageVersion";
                type Value = runtime_types::pallet_democracy::Releases;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn public_prop_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = PublicPropCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn public_props(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<(
                        ::core::primitive::u32,
                        ::subxt::sp_core::H256,
                        ::subxt::sp_core::crypto::AccountId32,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = PublicProps;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn deposit_of(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<(
                        ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                        ::core::primitive::u128,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = DepositOf(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn deposit_of_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, DepositOf>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn preimages(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_democracy::PreimageStatus<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                            ::core::primitive::u32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Preimages(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn preimages_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Preimages>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn referendum_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ReferendumCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn lowest_unbaked(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = LowestUnbaked;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn referendum_info_of(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_democracy::types::ReferendumInfo<
                            ::core::primitive::u32,
                            ::subxt::sp_core::H256,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ReferendumInfoOf(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn referendum_info_of_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ReferendumInfoOf>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn voting_of(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_democracy::vote::Voting<
                        ::core::primitive::u128,
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = VotingOf(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn voting_of_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, VotingOf>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn last_tabled_was_external(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = LastTabledWasExternal;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn next_external (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < (:: subxt :: sp_core :: H256 , runtime_types :: pallet_democracy :: vote_threshold :: VoteThreshold ,) > , :: subxt :: BasicError >{
                    let entry = NextExternal;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn blacklist(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<(
                        ::core::primitive::u32,
                        ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = Blacklist(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn blacklist_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Blacklist>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn cancellations(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = Cancellations(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn cancellations_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Cancellations>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn storage_version(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_democracy::Releases,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = StorageVersion;
                    self.client.storage().fetch(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn enactment_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[192u8, 75u8, 3u8, 0u8][..],
                    )?)
                }
                pub fn launch_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[128u8, 19u8, 3u8, 0u8][..],
                    )?)
                }
                pub fn voting_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[128u8, 19u8, 3u8, 0u8][..],
                    )?)
                }
                pub fn vote_locking_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[192u8, 75u8, 3u8, 0u8][..],
                    )?)
                }
                pub fn minimum_deposit(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 64u8, 122u8, 16u8, 243u8, 90u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn instant_allowed(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(&mut &[1u8][..])?)
                }
                pub fn fast_track_voting_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[96u8, 84u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn cooloff_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[128u8, 19u8, 3u8, 0u8][..],
                    )?)
                }
                pub fn preimage_byte_deposit(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 228u8, 11u8, 84u8, 2u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn max_votes(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[100u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn max_proposals(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[100u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod council {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_members {
                pub new_members:
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                pub prime: ::core::option::Option<
                    ::subxt::sp_core::crypto::AccountId32,
                >,
                pub old_count: ::core::primitive::u32,
            }
            impl ::subxt::Call for set_members {
                const PALLET: &'static str = "Council";
                const FUNCTION: &'static str = "set_members";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct execute {
                pub proposal: ::std::boxed::Box<
                    runtime_types::egg_standalone_runtime::Call,
                >,
                #[codec(compact)]
                pub length_bound: ::core::primitive::u32,
            }
            impl ::subxt::Call for execute {
                const PALLET: &'static str = "Council";
                const FUNCTION: &'static str = "execute";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct propose {
                #[codec(compact)]
                pub threshold: ::core::primitive::u32,
                pub proposal: ::std::boxed::Box<
                    runtime_types::egg_standalone_runtime::Call,
                >,
                #[codec(compact)]
                pub length_bound: ::core::primitive::u32,
            }
            impl ::subxt::Call for propose {
                const PALLET: &'static str = "Council";
                const FUNCTION: &'static str = "propose";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct vote {
                pub proposal: ::subxt::sp_core::H256,
                #[codec(compact)]
                pub index: ::core::primitive::u32,
                pub approve: ::core::primitive::bool,
            }
            impl ::subxt::Call for vote {
                const PALLET: &'static str = "Council";
                const FUNCTION: &'static str = "vote";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct close {
                pub proposal_hash: ::subxt::sp_core::H256,
                #[codec(compact)]
                pub index: ::core::primitive::u32,
                #[codec(compact)]
                pub proposal_weight_bound: ::core::primitive::u64,
                #[codec(compact)]
                pub length_bound: ::core::primitive::u32,
            }
            impl ::subxt::Call for close {
                const PALLET: &'static str = "Council";
                const FUNCTION: &'static str = "close";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct disapprove_proposal {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for disapprove_proposal {
                const PALLET: &'static str = "Council";
                const FUNCTION: &'static str = "disapprove_proposal";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set_members(
                    &self,
                    new_members: ::std::vec::Vec<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    prime: ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    old_count: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_members,
                    DispatchError,
                > {
                    let call = set_members {
                        new_members,
                        prime,
                        old_count,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn execute(
                    &self,
                    proposal: runtime_types::egg_standalone_runtime::Call,
                    length_bound: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    execute,
                    DispatchError,
                > {
                    let call = execute {
                        proposal: ::std::boxed::Box::new(proposal),
                        length_bound,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn propose(
                    &self,
                    threshold: ::core::primitive::u32,
                    proposal: runtime_types::egg_standalone_runtime::Call,
                    length_bound: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    propose,
                    DispatchError,
                > {
                    let call = propose {
                        threshold,
                        proposal: ::std::boxed::Box::new(proposal),
                        length_bound,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn vote(
                    &self,
                    proposal: ::subxt::sp_core::H256,
                    index: ::core::primitive::u32,
                    approve: ::core::primitive::bool,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    vote,
                    DispatchError,
                > {
                    let call = vote {
                        proposal,
                        index,
                        approve,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn close(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                    index: ::core::primitive::u32,
                    proposal_weight_bound: ::core::primitive::u64,
                    length_bound: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    close,
                    DispatchError,
                > {
                    let call = close {
                        proposal_hash,
                        index,
                        proposal_weight_bound,
                        length_bound,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn disapprove_proposal(
                    &self,
                    proposal_hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    disapprove_proposal,
                    DispatchError,
                > {
                    let call = disapprove_proposal { proposal_hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_collective::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Proposed {
                pub account: ::subxt::sp_core::crypto::AccountId32,
                pub proposal_index: ::core::primitive::u32,
                pub proposal_hash: ::subxt::sp_core::H256,
                pub threshold: ::core::primitive::u32,
            }
            impl ::subxt::Event for Proposed {
                const PALLET: &'static str = "Council";
                const EVENT: &'static str = "Proposed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Voted {
                pub account: ::subxt::sp_core::crypto::AccountId32,
                pub proposal_hash: ::subxt::sp_core::H256,
                pub voted: ::core::primitive::bool,
                pub yes: ::core::primitive::u32,
                pub no: ::core::primitive::u32,
            }
            impl ::subxt::Event for Voted {
                const PALLET: &'static str = "Council";
                const EVENT: &'static str = "Voted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Approved {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Event for Approved {
                const PALLET: &'static str = "Council";
                const EVENT: &'static str = "Approved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Disapproved {
                pub proposal_hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Event for Disapproved {
                const PALLET: &'static str = "Council";
                const EVENT: &'static str = "Disapproved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Executed {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub result: ::core::result::Result<
                    (),
                    runtime_types::sp_runtime::DispatchError,
                >,
            }
            impl ::subxt::Event for Executed {
                const PALLET: &'static str = "Council";
                const EVENT: &'static str = "Executed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct MemberExecuted {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub result: ::core::result::Result<
                    (),
                    runtime_types::sp_runtime::DispatchError,
                >,
            }
            impl ::subxt::Event for MemberExecuted {
                const PALLET: &'static str = "Council";
                const EVENT: &'static str = "MemberExecuted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Closed {
                pub proposal_hash: ::subxt::sp_core::H256,
                pub yes: ::core::primitive::u32,
                pub no: ::core::primitive::u32,
            }
            impl ::subxt::Event for Closed {
                const PALLET: &'static str = "Council";
                const EVENT: &'static str = "Closed";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Proposals;
            impl ::subxt::StorageEntry for Proposals {
                const PALLET: &'static str = "Council";
                const STORAGE: &'static str = "Proposals";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: subxt :: sp_core :: H256 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ProposalOf(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for ProposalOf {
                const PALLET: &'static str = "Council";
                const STORAGE: &'static str = "ProposalOf";
                type Value = runtime_types::egg_standalone_runtime::Call;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Identity,
                        ),
                    ])
                }
            }
            pub struct Voting(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for Voting {
                const PALLET: &'static str = "Council";
                const STORAGE: &'static str = "Voting";
                type Value = runtime_types::pallet_collective::Votes<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Identity,
                        ),
                    ])
                }
            }
            pub struct ProposalCount;
            impl ::subxt::StorageEntry for ProposalCount {
                const PALLET: &'static str = "Council";
                const STORAGE: &'static str = "ProposalCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Members;
            impl ::subxt::StorageEntry for Members {
                const PALLET: &'static str = "Council";
                const STORAGE: &'static str = "Members";
                type Value =
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Prime;
            impl ::subxt::StorageEntry for Prime {
                const PALLET: &'static str = "Council";
                const STORAGE: &'static str = "Prime";
                type Value = ::subxt::sp_core::crypto::AccountId32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }                pub async fn proposals (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: subxt :: sp_core :: H256 > , :: subxt :: BasicError >{
                    let entry = Proposals;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn proposal_of(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::egg_standalone_runtime::Call,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ProposalOf(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn proposal_of_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ProposalOf>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn voting(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_collective::Votes<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Voting(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn voting_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Voting>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn proposal_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ProposalCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn members(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    ::subxt::BasicError,
                > {
                    let entry = Members;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn prime(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Prime;
                    self.client.storage().fetch(&entry, hash).await
                }
            }
        }
    }
    pub mod elections {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct vote {
                pub votes:
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                #[codec(compact)]
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Call for vote {
                const PALLET: &'static str = "Elections";
                const FUNCTION: &'static str = "vote";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remove_voter;
            impl ::subxt::Call for remove_voter {
                const PALLET: &'static str = "Elections";
                const FUNCTION: &'static str = "remove_voter";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit_candidacy {
                #[codec(compact)]
                pub candidate_count: ::core::primitive::u32,
            }
            impl ::subxt::Call for submit_candidacy {
                const PALLET: &'static str = "Elections";
                const FUNCTION: &'static str = "submit_candidacy";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct renounce_candidacy {
                pub renouncing:
                    runtime_types::pallet_elections_phragmen::Renouncing,
            }
            impl ::subxt::Call for renounce_candidacy {
                const PALLET: &'static str = "Elections";
                const FUNCTION: &'static str = "renounce_candidacy";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remove_member {
                pub who: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub has_replacement: ::core::primitive::bool,
            }
            impl ::subxt::Call for remove_member {
                const PALLET: &'static str = "Elections";
                const FUNCTION: &'static str = "remove_member";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct clean_defunct_voters {
                pub num_voters: ::core::primitive::u32,
                pub num_defunct: ::core::primitive::u32,
            }
            impl ::subxt::Call for clean_defunct_voters {
                const PALLET: &'static str = "Elections";
                const FUNCTION: &'static str = "clean_defunct_voters";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn vote(
                    &self,
                    votes: ::std::vec::Vec<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    value: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    vote,
                    DispatchError,
                > {
                    let call = vote { votes, value };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remove_voter(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remove_voter,
                    DispatchError,
                > {
                    let call = remove_voter {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn submit_candidacy(
                    &self,
                    candidate_count: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit_candidacy,
                    DispatchError,
                > {
                    let call = submit_candidacy { candidate_count };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn renounce_candidacy(
                    &self,
                    renouncing : runtime_types :: pallet_elections_phragmen :: Renouncing,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    renounce_candidacy,
                    DispatchError,
                > {
                    let call = renounce_candidacy { renouncing };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remove_member(
                    &self,
                    who: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    has_replacement: ::core::primitive::bool,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remove_member,
                    DispatchError,
                > {
                    let call = remove_member {
                        who,
                        has_replacement,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn clean_defunct_voters(
                    &self,
                    num_voters: ::core::primitive::u32,
                    num_defunct: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    clean_defunct_voters,
                    DispatchError,
                > {
                    let call = clean_defunct_voters {
                        num_voters,
                        num_defunct,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event =
            runtime_types::pallet_elections_phragmen::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct NewTerm {
                pub new_members: ::std::vec::Vec<(
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                )>,
            }
            impl ::subxt::Event for NewTerm {
                const PALLET: &'static str = "Elections";
                const EVENT: &'static str = "NewTerm";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct EmptyTerm;
            impl ::subxt::Event for EmptyTerm {
                const PALLET: &'static str = "Elections";
                const EVENT: &'static str = "EmptyTerm";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ElectionError;
            impl ::subxt::Event for ElectionError {
                const PALLET: &'static str = "Elections";
                const EVENT: &'static str = "ElectionError";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct MemberKicked {
                pub member: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for MemberKicked {
                const PALLET: &'static str = "Elections";
                const EVENT: &'static str = "MemberKicked";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Renounced {
                pub candidate: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for Renounced {
                const PALLET: &'static str = "Elections";
                const EVENT: &'static str = "Renounced";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct CandidateSlashed {
                pub candidate: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for CandidateSlashed {
                const PALLET: &'static str = "Elections";
                const EVENT: &'static str = "CandidateSlashed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct SeatHolderSlashed {
                pub seat_holder: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for SeatHolderSlashed {
                const PALLET: &'static str = "Elections";
                const EVENT: &'static str = "SeatHolderSlashed";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Members;
            impl ::subxt::StorageEntry for Members {
                const PALLET: &'static str = "Elections";
                const STORAGE: &'static str = "Members";
                type Value = ::std::vec::Vec<
                    runtime_types::pallet_elections_phragmen::SeatHolder<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    >,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct RunnersUp;
            impl ::subxt::StorageEntry for RunnersUp {
                const PALLET: &'static str = "Elections";
                const STORAGE: &'static str = "RunnersUp";
                type Value = ::std::vec::Vec<
                    runtime_types::pallet_elections_phragmen::SeatHolder<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    >,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Candidates;
            impl ::subxt::StorageEntry for Candidates {
                const PALLET: &'static str = "Elections";
                const STORAGE: &'static str = "Candidates";
                type Value = ::std::vec::Vec<(
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ElectionRounds;
            impl ::subxt::StorageEntry for ElectionRounds {
                const PALLET: &'static str = "Elections";
                const STORAGE: &'static str = "ElectionRounds";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Voting(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Voting {
                const PALLET: &'static str = "Elections";
                const STORAGE: &'static str = "Voting";
                type Value = runtime_types::pallet_elections_phragmen::Voter<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn members(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<
                        runtime_types::pallet_elections_phragmen::SeatHolder<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Members;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn runners_up(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<
                        runtime_types::pallet_elections_phragmen::SeatHolder<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = RunnersUp;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn candidates(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<(
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = Candidates;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn election_rounds(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ElectionRounds;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn voting(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_elections_phragmen::Voter<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Voting(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn voting_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Voting>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn pallet_id(
                    &self,
                ) -> ::core::result::Result<
                    [::core::primitive::u8; 8usize],
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            112u8, 104u8, 114u8, 101u8, 108u8, 101u8, 99u8,
                            116u8,
                        ][..],
                    )?)
                }
                pub fn candidacy_bond(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 160u8, 114u8, 78u8, 24u8, 9u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn voting_bond_base(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 32u8, 67u8, 172u8, 102u8, 2u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn voting_bond_factor(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 128u8, 124u8, 129u8, 74u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn desired_members(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[13u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn desired_runners_up(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[7u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn term_duration(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[224u8, 196u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod election_provider_multi_phase {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit_unsigned { pub raw_solution : :: std :: boxed :: Box < runtime_types :: pallet_election_provider_multi_phase :: RawSolution < runtime_types :: egg_standalone_runtime :: NposSolution16 > > , pub witness : runtime_types :: pallet_election_provider_multi_phase :: SolutionOrSnapshotSize , }
            impl ::subxt::Call for submit_unsigned {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const FUNCTION: &'static str = "submit_unsigned";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_minimum_untrusted_score {
                pub maybe_next_score:
                    ::core::option::Option<[::core::primitive::u128; 3usize]>,
            }
            impl ::subxt::Call for set_minimum_untrusted_score {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const FUNCTION: &'static str = "set_minimum_untrusted_score";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_emergency_election_result {
                pub supports: ::std::vec::Vec<(
                    ::subxt::sp_core::crypto::AccountId32,
                    runtime_types::sp_npos_elections::Support<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                )>,
            }
            impl ::subxt::Call for set_emergency_election_result {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const FUNCTION: &'static str = "set_emergency_election_result";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit { pub raw_solution : :: std :: boxed :: Box < runtime_types :: pallet_election_provider_multi_phase :: RawSolution < runtime_types :: egg_standalone_runtime :: NposSolution16 > > , pub num_signed_submissions : :: core :: primitive :: u32 , }
            impl ::subxt::Call for submit {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const FUNCTION: &'static str = "submit";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct governance_fallback {
                pub maybe_max_voters:
                    ::core::option::Option<::core::primitive::u32>,
                pub maybe_max_targets:
                    ::core::option::Option<::core::primitive::u32>,
            }
            impl ::subxt::Call for governance_fallback {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const FUNCTION: &'static str = "governance_fallback";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn submit_unsigned(
                    &self,
                    raw_solution : runtime_types :: pallet_election_provider_multi_phase :: RawSolution < runtime_types :: egg_standalone_runtime :: NposSolution16 >,
                    witness : runtime_types :: pallet_election_provider_multi_phase :: SolutionOrSnapshotSize,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit_unsigned,
                    DispatchError,
                > {
                    let call = submit_unsigned {
                        raw_solution: ::std::boxed::Box::new(raw_solution),
                        witness,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_minimum_untrusted_score(
                    &self,
                    maybe_next_score: ::core::option::Option<
                        [::core::primitive::u128; 3usize],
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_minimum_untrusted_score,
                    DispatchError,
                > {
                    let call = set_minimum_untrusted_score { maybe_next_score };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_emergency_election_result(
                    &self,
                    supports: ::std::vec::Vec<(
                        ::subxt::sp_core::crypto::AccountId32,
                        runtime_types::sp_npos_elections::Support<
                            ::subxt::sp_core::crypto::AccountId32,
                        >,
                    )>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_emergency_election_result,
                    DispatchError,
                > {
                    let call = set_emergency_election_result { supports };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn submit(
                    &self,
                    raw_solution : runtime_types :: pallet_election_provider_multi_phase :: RawSolution < runtime_types :: egg_standalone_runtime :: NposSolution16 >,
                    num_signed_submissions: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit,
                    DispatchError,
                > {
                    let call = submit {
                        raw_solution: ::std::boxed::Box::new(raw_solution),
                        num_signed_submissions,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn governance_fallback(
                    &self,
                    maybe_max_voters: ::core::option::Option<
                        ::core::primitive::u32,
                    >,
                    maybe_max_targets: ::core::option::Option<
                        ::core::primitive::u32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    governance_fallback,
                    DispatchError,
                > {
                    let call = governance_fallback {
                        maybe_max_voters,
                        maybe_max_targets,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event =
            runtime_types::pallet_election_provider_multi_phase::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct SolutionStored { pub election_compute : runtime_types :: pallet_election_provider_multi_phase :: ElectionCompute , pub prev_ejected : :: core :: primitive :: bool , }
            impl ::subxt::Event for SolutionStored {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const EVENT: &'static str = "SolutionStored";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ElectionFinalized { pub election_compute : :: core :: option :: Option < runtime_types :: pallet_election_provider_multi_phase :: ElectionCompute > , }
            impl ::subxt::Event for ElectionFinalized {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const EVENT: &'static str = "ElectionFinalized";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Rewarded {
                pub account: ::subxt::sp_core::crypto::AccountId32,
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Event for Rewarded {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const EVENT: &'static str = "Rewarded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Slashed {
                pub account: ::subxt::sp_core::crypto::AccountId32,
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Event for Slashed {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const EVENT: &'static str = "Slashed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct SignedPhaseStarted {
                pub round: ::core::primitive::u32,
            }
            impl ::subxt::Event for SignedPhaseStarted {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const EVENT: &'static str = "SignedPhaseStarted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct UnsignedPhaseStarted {
                pub round: ::core::primitive::u32,
            }
            impl ::subxt::Event for UnsignedPhaseStarted {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const EVENT: &'static str = "UnsignedPhaseStarted";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Round;
            impl ::subxt::StorageEntry for Round {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "Round";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CurrentPhase;
            impl ::subxt::StorageEntry for CurrentPhase {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "CurrentPhase";
                type Value =
                    runtime_types::pallet_election_provider_multi_phase::Phase<
                        ::core::primitive::u32,
                    >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct QueuedSolution;
            impl ::subxt::StorageEntry for QueuedSolution {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "QueuedSolution";
                type Value = runtime_types :: pallet_election_provider_multi_phase :: ReadySolution < :: subxt :: sp_core :: crypto :: AccountId32 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Snapshot;
            impl ::subxt::StorageEntry for Snapshot {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "Snapshot";
                type Value = runtime_types :: pallet_election_provider_multi_phase :: RoundSnapshot ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct DesiredTargets;
            impl ::subxt::StorageEntry for DesiredTargets {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "DesiredTargets";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct SnapshotMetadata;
            impl ::subxt::StorageEntry for SnapshotMetadata {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "SnapshotMetadata";
                type Value = runtime_types :: pallet_election_provider_multi_phase :: SolutionOrSnapshotSize ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct SignedSubmissionNextIndex;
            impl ::subxt::StorageEntry for SignedSubmissionNextIndex {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "SignedSubmissionNextIndex";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct SignedSubmissionIndices;
            impl ::subxt::StorageEntry for SignedSubmissionIndices {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "SignedSubmissionIndices";
                type Value = runtime_types :: frame_support :: storage :: bounded_btree_map :: BoundedBTreeMap < [:: core :: primitive :: u128 ; 3usize] , :: core :: primitive :: u32 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct SignedSubmissionsMap(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for SignedSubmissionsMap {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "SignedSubmissionsMap";
                type Value = runtime_types :: pallet_election_provider_multi_phase :: signed :: SignedSubmission < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u128 , runtime_types :: egg_standalone_runtime :: NposSolution16 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct MinimumUntrustedScore;
            impl ::subxt::StorageEntry for MinimumUntrustedScore {
                const PALLET: &'static str = "ElectionProviderMultiPhase";
                const STORAGE: &'static str = "MinimumUntrustedScore";
                type Value = [::core::primitive::u128; 3usize];
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn round(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = Round;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn current_phase(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_election_provider_multi_phase::Phase<
                        ::core::primitive::u32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentPhase;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn queued_solution (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_election_provider_multi_phase :: ReadySolution < :: subxt :: sp_core :: crypto :: AccountId32 > > , :: subxt :: BasicError >{
                    let entry = QueuedSolution;
                    self.client.storage().fetch(&entry, hash).await
                }                pub async fn snapshot (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_election_provider_multi_phase :: RoundSnapshot > , :: subxt :: BasicError >{
                    let entry = Snapshot;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn desired_targets(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = DesiredTargets;
                    self.client.storage().fetch(&entry, hash).await
                }                pub async fn snapshot_metadata (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_election_provider_multi_phase :: SolutionOrSnapshotSize > , :: subxt :: BasicError >{
                    let entry = SnapshotMetadata;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn signed_submission_next_index(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = SignedSubmissionNextIndex;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn signed_submission_indices (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: bounded_btree_map :: BoundedBTreeMap < [:: core :: primitive :: u128 ; 3usize] , :: core :: primitive :: u32 > , :: subxt :: BasicError >{
                    let entry = SignedSubmissionIndices;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn signed_submissions_map (& self , _0 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_election_provider_multi_phase :: signed :: SignedSubmission < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u128 , runtime_types :: egg_standalone_runtime :: NposSolution16 > > , :: subxt :: BasicError >{
                    let entry = SignedSubmissionsMap(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn signed_submissions_map_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, SignedSubmissionsMap>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn minimum_untrusted_score(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<[::core::primitive::u128; 3usize]>,
                    ::subxt::BasicError,
                > {
                    let entry = MinimumUntrustedScore;
                    self.client.storage().fetch(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn unsigned_phase(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[12u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn signed_phase(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[12u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn solution_improvement_threshold(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Perbill,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[160u8, 134u8, 1u8, 0u8][..],
                    )?)
                }
                pub fn offchain_repeat(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[5u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn miner_tx_priority(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            254u8, 255u8, 255u8, 255u8, 255u8, 255u8, 255u8,
                            127u8,
                        ][..],
                    )?)
                }
                pub fn miner_max_weight(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[192u8, 38u8, 9u8, 122u8, 74u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn signed_max_submissions(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[10u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn signed_max_weight(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[192u8, 38u8, 9u8, 122u8, 74u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn signed_reward_base(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 16u8, 165u8, 212u8, 232u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn signed_deposit_base(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 16u8, 165u8, 212u8, 232u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn signed_deposit_byte(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 228u8, 11u8, 84u8, 2u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn signed_deposit_weight(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn voter_snapshot_per_block(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[16u8, 39u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn miner_max_length(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 0u8, 54u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod staking {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct bond {
                pub controller: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub value: ::core::primitive::u128,
                pub payee: runtime_types::pallet_staking::RewardDestination<
                    ::subxt::sp_core::crypto::AccountId32,
                >,
            }
            impl ::subxt::Call for bond {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "bond";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct bond_extra {
                #[codec(compact)]
                pub max_additional: ::core::primitive::u128,
            }
            impl ::subxt::Call for bond_extra {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "bond_extra";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unbond {
                #[codec(compact)]
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Call for unbond {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "unbond";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct withdraw_unbonded {
                pub num_slashing_spans: ::core::primitive::u32,
            }
            impl ::subxt::Call for withdraw_unbonded {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "withdraw_unbonded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct validate {
                pub prefs: runtime_types::pallet_staking::ValidatorPrefs,
            }
            impl ::subxt::Call for validate {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "validate";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct nominate {
                pub targets: ::std::vec::Vec<
                    ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                >,
            }
            impl ::subxt::Call for nominate {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "nominate";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct chill;
            impl ::subxt::Call for chill {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "chill";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_payee {
                pub payee: runtime_types::pallet_staking::RewardDestination<
                    ::subxt::sp_core::crypto::AccountId32,
                >,
            }
            impl ::subxt::Call for set_payee {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "set_payee";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_controller {
                pub controller: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
            }
            impl ::subxt::Call for set_controller {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "set_controller";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_validator_count {
                #[codec(compact)]
                pub new: ::core::primitive::u32,
            }
            impl ::subxt::Call for set_validator_count {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "set_validator_count";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct increase_validator_count {
                #[codec(compact)]
                pub additional: ::core::primitive::u32,
            }
            impl ::subxt::Call for increase_validator_count {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "increase_validator_count";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct scale_validator_count {
                pub factor: runtime_types::sp_arithmetic::per_things::Percent,
            }
            impl ::subxt::Call for scale_validator_count {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "scale_validator_count";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_no_eras;
            impl ::subxt::Call for force_no_eras {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "force_no_eras";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_new_era;
            impl ::subxt::Call for force_new_era {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "force_new_era";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_invulnerables {
                pub invulnerables:
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
            }
            impl ::subxt::Call for set_invulnerables {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "set_invulnerables";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_unstake {
                pub stash: ::subxt::sp_core::crypto::AccountId32,
                pub num_slashing_spans: ::core::primitive::u32,
            }
            impl ::subxt::Call for force_unstake {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "force_unstake";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_new_era_always;
            impl ::subxt::Call for force_new_era_always {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "force_new_era_always";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct cancel_deferred_slash {
                pub era: ::core::primitive::u32,
                pub slash_indices: ::std::vec::Vec<::core::primitive::u32>,
            }
            impl ::subxt::Call for cancel_deferred_slash {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "cancel_deferred_slash";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct payout_stakers {
                pub validator_stash: ::subxt::sp_core::crypto::AccountId32,
                pub era: ::core::primitive::u32,
            }
            impl ::subxt::Call for payout_stakers {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "payout_stakers";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct rebond {
                #[codec(compact)]
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Call for rebond {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "rebond";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_history_depth {
                #[codec(compact)]
                pub new_history_depth: ::core::primitive::u32,
                #[codec(compact)]
                pub era_items_deleted: ::core::primitive::u32,
            }
            impl ::subxt::Call for set_history_depth {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "set_history_depth";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct reap_stash {
                pub stash: ::subxt::sp_core::crypto::AccountId32,
                pub num_slashing_spans: ::core::primitive::u32,
            }
            impl ::subxt::Call for reap_stash {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "reap_stash";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct kick {
                pub who: ::std::vec::Vec<
                    ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                >,
            }
            impl ::subxt::Call for kick {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "kick";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_staking_configs {
                pub min_nominator_bond: ::core::primitive::u128,
                pub min_validator_bond: ::core::primitive::u128,
                pub max_nominator_count:
                    ::core::option::Option<::core::primitive::u32>,
                pub max_validator_count:
                    ::core::option::Option<::core::primitive::u32>,
                pub chill_threshold: ::core::option::Option<
                    runtime_types::sp_arithmetic::per_things::Percent,
                >,
                pub min_commission:
                    runtime_types::sp_arithmetic::per_things::Perbill,
            }
            impl ::subxt::Call for set_staking_configs {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "set_staking_configs";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct chill_other {
                pub controller: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for chill_other {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "chill_other";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_apply_min_commission {
                pub validator_stash: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for force_apply_min_commission {
                const PALLET: &'static str = "Staking";
                const FUNCTION: &'static str = "force_apply_min_commission";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn bond(
                    &self,
                    controller: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    value: ::core::primitive::u128,
                    payee: runtime_types::pallet_staking::RewardDestination<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    bond,
                    DispatchError,
                > {
                    let call = bond {
                        controller,
                        value,
                        payee,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn bond_extra(
                    &self,
                    max_additional: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    bond_extra,
                    DispatchError,
                > {
                    let call = bond_extra { max_additional };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unbond(
                    &self,
                    value: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unbond,
                    DispatchError,
                > {
                    let call = unbond { value };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn withdraw_unbonded(
                    &self,
                    num_slashing_spans: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    withdraw_unbonded,
                    DispatchError,
                > {
                    let call = withdraw_unbonded { num_slashing_spans };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn validate(
                    &self,
                    prefs: runtime_types::pallet_staking::ValidatorPrefs,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    validate,
                    DispatchError,
                > {
                    let call = validate { prefs };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn nominate(
                    &self,
                    targets: ::std::vec::Vec<
                        ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    nominate,
                    DispatchError,
                > {
                    let call = nominate { targets };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn chill(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    chill,
                    DispatchError,
                > {
                    let call = chill {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_payee(
                    &self,
                    payee: runtime_types::pallet_staking::RewardDestination<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_payee,
                    DispatchError,
                > {
                    let call = set_payee { payee };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_controller(
                    &self,
                    controller: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_controller,
                    DispatchError,
                > {
                    let call = set_controller { controller };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_validator_count(
                    &self,
                    new: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_validator_count,
                    DispatchError,
                > {
                    let call = set_validator_count { new };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn increase_validator_count(
                    &self,
                    additional: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    increase_validator_count,
                    DispatchError,
                > {
                    let call = increase_validator_count { additional };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn scale_validator_count(
                    &self,
                    factor: runtime_types::sp_arithmetic::per_things::Percent,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    scale_validator_count,
                    DispatchError,
                > {
                    let call = scale_validator_count { factor };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_no_eras(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_no_eras,
                    DispatchError,
                > {
                    let call = force_no_eras {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_new_era(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_new_era,
                    DispatchError,
                > {
                    let call = force_new_era {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_invulnerables(
                    &self,
                    invulnerables: ::std::vec::Vec<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_invulnerables,
                    DispatchError,
                > {
                    let call = set_invulnerables { invulnerables };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_unstake(
                    &self,
                    stash: ::subxt::sp_core::crypto::AccountId32,
                    num_slashing_spans: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_unstake,
                    DispatchError,
                > {
                    let call = force_unstake {
                        stash,
                        num_slashing_spans,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_new_era_always(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_new_era_always,
                    DispatchError,
                > {
                    let call = force_new_era_always {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn cancel_deferred_slash(
                    &self,
                    era: ::core::primitive::u32,
                    slash_indices: ::std::vec::Vec<::core::primitive::u32>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    cancel_deferred_slash,
                    DispatchError,
                > {
                    let call = cancel_deferred_slash { era, slash_indices };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn payout_stakers(
                    &self,
                    validator_stash: ::subxt::sp_core::crypto::AccountId32,
                    era: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    payout_stakers,
                    DispatchError,
                > {
                    let call = payout_stakers {
                        validator_stash,
                        era,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn rebond(
                    &self,
                    value: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    rebond,
                    DispatchError,
                > {
                    let call = rebond { value };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_history_depth(
                    &self,
                    new_history_depth: ::core::primitive::u32,
                    era_items_deleted: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_history_depth,
                    DispatchError,
                > {
                    let call = set_history_depth {
                        new_history_depth,
                        era_items_deleted,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn reap_stash(
                    &self,
                    stash: ::subxt::sp_core::crypto::AccountId32,
                    num_slashing_spans: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    reap_stash,
                    DispatchError,
                > {
                    let call = reap_stash {
                        stash,
                        num_slashing_spans,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn kick(
                    &self,
                    who: ::std::vec::Vec<
                        ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    kick,
                    DispatchError,
                > {
                    let call = kick { who };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_staking_configs(
                    &self,
                    min_nominator_bond: ::core::primitive::u128,
                    min_validator_bond: ::core::primitive::u128,
                    max_nominator_count: ::core::option::Option<
                        ::core::primitive::u32,
                    >,
                    max_validator_count: ::core::option::Option<
                        ::core::primitive::u32,
                    >,
                    chill_threshold: ::core::option::Option<
                        runtime_types::sp_arithmetic::per_things::Percent,
                    >,
                    min_commission : runtime_types :: sp_arithmetic :: per_things :: Perbill,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_staking_configs,
                    DispatchError,
                > {
                    let call = set_staking_configs {
                        min_nominator_bond,
                        min_validator_bond,
                        max_nominator_count,
                        max_validator_count,
                        chill_threshold,
                        min_commission,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn chill_other(
                    &self,
                    controller: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    chill_other,
                    DispatchError,
                > {
                    let call = chill_other { controller };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_apply_min_commission(
                    &self,
                    validator_stash: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_apply_min_commission,
                    DispatchError,
                > {
                    let call = force_apply_min_commission { validator_stash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_staking::pallet::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct EraPaid(
                pub ::core::primitive::u32,
                pub ::core::primitive::u128,
                pub ::core::primitive::u128,
            );
            impl ::subxt::Event for EraPaid {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "EraPaid";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Rewarded(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u128,
            );
            impl ::subxt::Event for Rewarded {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "Rewarded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Slashed(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u128,
            );
            impl ::subxt::Event for Slashed {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "Slashed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct OldSlashingReportDiscarded(pub ::core::primitive::u32);
            impl ::subxt::Event for OldSlashingReportDiscarded {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "OldSlashingReportDiscarded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct StakersElected;
            impl ::subxt::Event for StakersElected {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "StakersElected";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Bonded(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u128,
            );
            impl ::subxt::Event for Bonded {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "Bonded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Unbonded(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u128,
            );
            impl ::subxt::Event for Unbonded {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "Unbonded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Withdrawn(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u128,
            );
            impl ::subxt::Event for Withdrawn {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "Withdrawn";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Kicked(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::Event for Kicked {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "Kicked";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct StakingElectionFailed;
            impl ::subxt::Event for StakingElectionFailed {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "StakingElectionFailed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Chilled(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::Event for Chilled {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "Chilled";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PayoutStarted(
                pub ::core::primitive::u32,
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::Event for PayoutStarted {
                const PALLET: &'static str = "Staking";
                const EVENT: &'static str = "PayoutStarted";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct HistoryDepth;
            impl ::subxt::StorageEntry for HistoryDepth {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "HistoryDepth";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ValidatorCount;
            impl ::subxt::StorageEntry for ValidatorCount {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ValidatorCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct MinimumValidatorCount;
            impl ::subxt::StorageEntry for MinimumValidatorCount {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "MinimumValidatorCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Invulnerables;
            impl ::subxt::StorageEntry for Invulnerables {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "Invulnerables";
                type Value =
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Bonded(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Bonded {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "Bonded";
                type Value = ::subxt::sp_core::crypto::AccountId32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct MinNominatorBond;
            impl ::subxt::StorageEntry for MinNominatorBond {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "MinNominatorBond";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct MinValidatorBond;
            impl ::subxt::StorageEntry for MinValidatorBond {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "MinValidatorBond";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct MinCommission;
            impl ::subxt::StorageEntry for MinCommission {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "MinCommission";
                type Value = runtime_types::sp_arithmetic::per_things::Perbill;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Ledger(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Ledger {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "Ledger";
                type Value = runtime_types::pallet_staking::StakingLedger<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct Payee(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Payee {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "Payee";
                type Value = runtime_types::pallet_staking::RewardDestination<
                    ::subxt::sp_core::crypto::AccountId32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct Validators(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Validators {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "Validators";
                type Value = runtime_types::pallet_staking::ValidatorPrefs;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct CounterForValidators;
            impl ::subxt::StorageEntry for CounterForValidators {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "CounterForValidators";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct MaxValidatorsCount;
            impl ::subxt::StorageEntry for MaxValidatorsCount {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "MaxValidatorsCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Nominators(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Nominators {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "Nominators";
                type Value = runtime_types::pallet_staking::Nominations;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct CounterForNominators;
            impl ::subxt::StorageEntry for CounterForNominators {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "CounterForNominators";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct MaxNominatorsCount;
            impl ::subxt::StorageEntry for MaxNominatorsCount {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "MaxNominatorsCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CurrentEra;
            impl ::subxt::StorageEntry for CurrentEra {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "CurrentEra";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ActiveEra;
            impl ::subxt::StorageEntry for ActiveEra {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ActiveEra";
                type Value = runtime_types::pallet_staking::ActiveEraInfo;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ErasStartSessionIndex(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ErasStartSessionIndex {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ErasStartSessionIndex";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ErasStakers(
                pub ::core::primitive::u32,
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::StorageEntry for ErasStakers {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ErasStakers";
                type Value = runtime_types::pallet_staking::Exposure<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ErasStakersClipped(
                pub ::core::primitive::u32,
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::StorageEntry for ErasStakersClipped {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ErasStakersClipped";
                type Value = runtime_types::pallet_staking::Exposure<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ErasValidatorPrefs(
                pub ::core::primitive::u32,
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::StorageEntry for ErasValidatorPrefs {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ErasValidatorPrefs";
                type Value = runtime_types::pallet_staking::ValidatorPrefs;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ErasValidatorReward(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ErasValidatorReward {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ErasValidatorReward";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ErasRewardPoints(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ErasRewardPoints {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ErasRewardPoints";
                type Value = runtime_types::pallet_staking::EraRewardPoints<
                    ::subxt::sp_core::crypto::AccountId32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ErasTotalStake(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ErasTotalStake {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ErasTotalStake";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ForceEra;
            impl ::subxt::StorageEntry for ForceEra {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ForceEra";
                type Value = runtime_types::pallet_staking::Forcing;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct SlashRewardFraction;
            impl ::subxt::StorageEntry for SlashRewardFraction {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "SlashRewardFraction";
                type Value = runtime_types::sp_arithmetic::per_things::Perbill;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CanceledSlashPayout;
            impl ::subxt::StorageEntry for CanceledSlashPayout {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "CanceledSlashPayout";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct UnappliedSlashes(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for UnappliedSlashes {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "UnappliedSlashes";
                type Value = ::std::vec::Vec<
                    runtime_types::pallet_staking::UnappliedSlash<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    >,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct BondedEras;
            impl ::subxt::StorageEntry for BondedEras {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "BondedEras";
                type Value = ::std::vec::Vec<(
                    ::core::primitive::u32,
                    ::core::primitive::u32,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ValidatorSlashInEra(
                pub ::core::primitive::u32,
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::StorageEntry for ValidatorSlashInEra {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ValidatorSlashInEra";
                type Value = (
                    runtime_types::sp_arithmetic::per_things::Perbill,
                    ::core::primitive::u128,
                );
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct NominatorSlashInEra(
                pub ::core::primitive::u32,
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::StorageEntry for NominatorSlashInEra {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "NominatorSlashInEra";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct SlashingSpans(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for SlashingSpans {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "SlashingSpans";
                type Value =
                    runtime_types::pallet_staking::slashing::SlashingSpans;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct SpanSlash(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u32,
            );
            impl ::subxt::StorageEntry for SpanSlash {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "SpanSlash";
                type Value =
                    runtime_types::pallet_staking::slashing::SpanRecord<
                        ::core::primitive::u128,
                    >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct EarliestUnappliedSlash;
            impl ::subxt::StorageEntry for EarliestUnappliedSlash {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "EarliestUnappliedSlash";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CurrentPlannedSession;
            impl ::subxt::StorageEntry for CurrentPlannedSession {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "CurrentPlannedSession";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct OffendingValidators;
            impl ::subxt::StorageEntry for OffendingValidators {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "OffendingValidators";
                type Value = ::std::vec::Vec<(
                    ::core::primitive::u32,
                    ::core::primitive::bool,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageVersion;
            impl ::subxt::StorageEntry for StorageVersion {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "StorageVersion";
                type Value = runtime_types::pallet_staking::Releases;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ChillThreshold;
            impl ::subxt::StorageEntry for ChillThreshold {
                const PALLET: &'static str = "Staking";
                const STORAGE: &'static str = "ChillThreshold";
                type Value = runtime_types::sp_arithmetic::per_things::Percent;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn history_depth(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = HistoryDepth;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn validator_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ValidatorCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn minimum_validator_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = MinimumValidatorCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn invulnerables(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    ::subxt::BasicError,
                > {
                    let entry = Invulnerables;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn bonded(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Bonded(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn bonded_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Bonded>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn min_nominator_bond(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = MinNominatorBond;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn min_validator_bond(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = MinValidatorBond;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn min_commission(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Perbill,
                    ::subxt::BasicError,
                > {
                    let entry = MinCommission;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn ledger(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_staking::StakingLedger<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Ledger(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn ledger_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Ledger>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn payee(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::RewardDestination<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Payee(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn payee_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Payee>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn validators(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::ValidatorPrefs,
                    ::subxt::BasicError,
                > {
                    let entry = Validators(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn validators_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Validators>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn counter_for_validators(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = CounterForValidators;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn max_validators_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = MaxValidatorsCount;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn nominators(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_staking::Nominations,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Nominators(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn nominators_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Nominators>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn counter_for_nominators(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = CounterForNominators;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn max_nominators_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = MaxNominatorsCount;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn current_era(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentEra;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn active_era(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_staking::ActiveEraInfo,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ActiveEra;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn eras_start_session_index(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = ErasStartSessionIndex(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn eras_start_session_index_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ErasStartSessionIndex>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn eras_stakers(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::Exposure<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ErasStakers(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn eras_stakers_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ErasStakers>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn eras_stakers_clipped(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::Exposure<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ErasStakersClipped(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn eras_stakers_clipped_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ErasStakersClipped>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn eras_validator_prefs(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::ValidatorPrefs,
                    ::subxt::BasicError,
                > {
                    let entry = ErasValidatorPrefs(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn eras_validator_prefs_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ErasValidatorPrefs>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn eras_validator_reward(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u128>,
                    ::subxt::BasicError,
                > {
                    let entry = ErasValidatorReward(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn eras_validator_reward_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ErasValidatorReward>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn eras_reward_points(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::EraRewardPoints<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ErasRewardPoints(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn eras_reward_points_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ErasRewardPoints>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn eras_total_stake(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = ErasTotalStake(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn eras_total_stake_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ErasTotalStake>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn force_era(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::Forcing,
                    ::subxt::BasicError,
                > {
                    let entry = ForceEra;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn slash_reward_fraction(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Perbill,
                    ::subxt::BasicError,
                > {
                    let entry = SlashRewardFraction;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn canceled_slash_payout(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = CanceledSlashPayout;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn unapplied_slashes(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<
                        runtime_types::pallet_staking::UnappliedSlash<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = UnappliedSlashes(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn unapplied_slashes_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, UnappliedSlashes>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn bonded_eras(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = BondedEras;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn validator_slash_in_era(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<(
                        runtime_types::sp_arithmetic::per_things::Perbill,
                        ::core::primitive::u128,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = ValidatorSlashInEra(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn validator_slash_in_era_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ValidatorSlashInEra>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn nominator_slash_in_era(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u128>,
                    ::subxt::BasicError,
                > {
                    let entry = NominatorSlashInEra(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn nominator_slash_in_era_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, NominatorSlashInEra>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn slashing_spans(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_staking::slashing::SlashingSpans,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = SlashingSpans(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn slashing_spans_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, SlashingSpans>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn span_slash(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    _1: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::slashing::SpanRecord<
                        ::core::primitive::u128,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = SpanSlash(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn span_slash_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, SpanSlash>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn earliest_unapplied_slash(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = EarliestUnappliedSlash;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn current_planned_session(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentPlannedSession;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn offending_validators(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<(
                        ::core::primitive::u32,
                        ::core::primitive::bool,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = OffendingValidators;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn storage_version(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_staking::Releases,
                    ::subxt::BasicError,
                > {
                    let entry = StorageVersion;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn chill_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::sp_arithmetic::per_things::Percent,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ChillThreshold;
                    self.client.storage().fetch(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn sessions_per_era(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[6u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn bonding_duration(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[160u8, 2u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn slash_defer_duration(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[168u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn max_nominator_rewarded_per_validator(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 1u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod session {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_keys {
                pub keys:
                    runtime_types::egg_standalone_runtime::opaque::SessionKeys,
                pub proof: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for set_keys {
                const PALLET: &'static str = "Session";
                const FUNCTION: &'static str = "set_keys";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct purge_keys;
            impl ::subxt::Call for purge_keys {
                const PALLET: &'static str = "Session";
                const FUNCTION: &'static str = "purge_keys";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set_keys(
                    &self,
                    keys : runtime_types :: egg_standalone_runtime :: opaque :: SessionKeys,
                    proof: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_keys,
                    DispatchError,
                > {
                    let call = set_keys { keys, proof };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn purge_keys(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    purge_keys,
                    DispatchError,
                > {
                    let call = purge_keys {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_session::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct NewSession {
                pub session_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for NewSession {
                const PALLET: &'static str = "Session";
                const EVENT: &'static str = "NewSession";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Validators;
            impl ::subxt::StorageEntry for Validators {
                const PALLET: &'static str = "Session";
                const STORAGE: &'static str = "Validators";
                type Value =
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CurrentIndex;
            impl ::subxt::StorageEntry for CurrentIndex {
                const PALLET: &'static str = "Session";
                const STORAGE: &'static str = "CurrentIndex";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct QueuedChanged;
            impl ::subxt::StorageEntry for QueuedChanged {
                const PALLET: &'static str = "Session";
                const STORAGE: &'static str = "QueuedChanged";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct QueuedKeys;
            impl ::subxt::StorageEntry for QueuedKeys {
                const PALLET: &'static str = "Session";
                const STORAGE: &'static str = "QueuedKeys";
                type Value = ::std::vec::Vec<(
                    ::subxt::sp_core::crypto::AccountId32,
                    runtime_types::egg_standalone_runtime::opaque::SessionKeys,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct DisabledValidators;
            impl ::subxt::StorageEntry for DisabledValidators {
                const PALLET: &'static str = "Session";
                const STORAGE: &'static str = "DisabledValidators";
                type Value = ::std::vec::Vec<::core::primitive::u32>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextKeys(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for NextKeys {
                const PALLET: &'static str = "Session";
                const STORAGE: &'static str = "NextKeys";
                type Value =
                    runtime_types::egg_standalone_runtime::opaque::SessionKeys;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct KeyOwner(
                pub runtime_types::sp_core::crypto::KeyTypeId,
                pub ::std::vec::Vec<::core::primitive::u8>,
            );
            impl ::subxt::StorageEntry for KeyOwner {
                const PALLET: &'static str = "Session";
                const STORAGE: &'static str = "KeyOwner";
                type Value = ::subxt::sp_core::crypto::AccountId32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn validators(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    ::subxt::BasicError,
                > {
                    let entry = Validators;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn current_index(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentIndex;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn queued_changed(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = QueuedChanged;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn queued_keys (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: std :: vec :: Vec < (:: subxt :: sp_core :: crypto :: AccountId32 , runtime_types :: egg_standalone_runtime :: opaque :: SessionKeys ,) > , :: subxt :: BasicError >{
                    let entry = QueuedKeys;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn disabled_validators(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = DisabledValidators;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn next_keys (& self , _0 : :: subxt :: sp_core :: crypto :: AccountId32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: egg_standalone_runtime :: opaque :: SessionKeys > , :: subxt :: BasicError >{
                    let entry = NextKeys(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn next_keys_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, NextKeys>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn key_owner(
                    &self,
                    _0: runtime_types::sp_core::crypto::KeyTypeId,
                    _1: ::std::vec::Vec<::core::primitive::u8>,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = KeyOwner(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn key_owner_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, KeyOwner>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
    }
    pub mod historical {
        use super::runtime_types;
    }
    pub mod treasury {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct propose_spend {
                #[codec(compact)]
                pub value: ::core::primitive::u128,
                pub beneficiary: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
            }
            impl ::subxt::Call for propose_spend {
                const PALLET: &'static str = "Treasury";
                const FUNCTION: &'static str = "propose_spend";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct reject_proposal {
                #[codec(compact)]
                pub proposal_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for reject_proposal {
                const PALLET: &'static str = "Treasury";
                const FUNCTION: &'static str = "reject_proposal";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct approve_proposal {
                #[codec(compact)]
                pub proposal_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for approve_proposal {
                const PALLET: &'static str = "Treasury";
                const FUNCTION: &'static str = "approve_proposal";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn propose_spend(
                    &self,
                    value: ::core::primitive::u128,
                    beneficiary: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    propose_spend,
                    DispatchError,
                > {
                    let call = propose_spend { value, beneficiary };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn reject_proposal(
                    &self,
                    proposal_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    reject_proposal,
                    DispatchError,
                > {
                    let call = reject_proposal { proposal_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn approve_proposal(
                    &self,
                    proposal_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    approve_proposal,
                    DispatchError,
                > {
                    let call = approve_proposal { proposal_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_treasury::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Proposed {
                pub proposal_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Proposed {
                const PALLET: &'static str = "Treasury";
                const EVENT: &'static str = "Proposed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Spending {
                pub budget_remaining: ::core::primitive::u128,
            }
            impl ::subxt::Event for Spending {
                const PALLET: &'static str = "Treasury";
                const EVENT: &'static str = "Spending";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Awarded {
                pub proposal_index: ::core::primitive::u32,
                pub award: ::core::primitive::u128,
                pub account: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for Awarded {
                const PALLET: &'static str = "Treasury";
                const EVENT: &'static str = "Awarded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Rejected {
                pub proposal_index: ::core::primitive::u32,
                pub slashed: ::core::primitive::u128,
            }
            impl ::subxt::Event for Rejected {
                const PALLET: &'static str = "Treasury";
                const EVENT: &'static str = "Rejected";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Burnt {
                pub burnt_funds: ::core::primitive::u128,
            }
            impl ::subxt::Event for Burnt {
                const PALLET: &'static str = "Treasury";
                const EVENT: &'static str = "Burnt";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Rollover {
                pub rollover_balance: ::core::primitive::u128,
            }
            impl ::subxt::Event for Rollover {
                const PALLET: &'static str = "Treasury";
                const EVENT: &'static str = "Rollover";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Deposit {
                pub value: ::core::primitive::u128,
            }
            impl ::subxt::Event for Deposit {
                const PALLET: &'static str = "Treasury";
                const EVENT: &'static str = "Deposit";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct ProposalCount;
            impl ::subxt::StorageEntry for ProposalCount {
                const PALLET: &'static str = "Treasury";
                const STORAGE: &'static str = "ProposalCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Proposals(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for Proposals {
                const PALLET: &'static str = "Treasury";
                const STORAGE: &'static str = "Proposals";
                type Value = runtime_types::pallet_treasury::Proposal<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct Approvals;
            impl ::subxt::StorageEntry for Approvals {
                const PALLET: &'static str = "Treasury";
                const STORAGE: &'static str = "Approvals";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u32 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn proposal_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ProposalCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn proposals(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_treasury::Proposal<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Proposals(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn proposals_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Proposals>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn approvals (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u32 > , :: subxt :: BasicError >{
                    let entry = Approvals;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn proposal_bond(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Permill,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[80u8, 195u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn proposal_bond_minimum(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 16u8, 165u8, 212u8, 232u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn proposal_bond_maximum(
                    &self,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u128>,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(&mut &[0u8][..])?)
                }
                pub fn spend_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[32u8, 28u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn burn(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Permill,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[32u8, 161u8, 7u8, 0u8][..],
                    )?)
                }
                pub fn pallet_id(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::PalletId,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            112u8, 121u8, 47u8, 116u8, 114u8, 115u8, 114u8,
                            121u8,
                        ][..],
                    )?)
                }
                pub fn max_approvals(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[100u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod bounties {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct propose_bounty {
                #[codec(compact)]
                pub value: ::core::primitive::u128,
                pub description: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for propose_bounty {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "propose_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct approve_bounty {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for approve_bounty {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "approve_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct propose_curator {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
                pub curator: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub fee: ::core::primitive::u128,
            }
            impl ::subxt::Call for propose_curator {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "propose_curator";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unassign_curator {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for unassign_curator {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "unassign_curator";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct accept_curator {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for accept_curator {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "accept_curator";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct award_bounty {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
                pub beneficiary: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
            }
            impl ::subxt::Call for award_bounty {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "award_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct claim_bounty {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for claim_bounty {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "claim_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct close_bounty {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for close_bounty {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "close_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct extend_bounty_expiry {
                #[codec(compact)]
                pub bounty_id: ::core::primitive::u32,
                pub remark: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for extend_bounty_expiry {
                const PALLET: &'static str = "Bounties";
                const FUNCTION: &'static str = "extend_bounty_expiry";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn propose_bounty(
                    &self,
                    value: ::core::primitive::u128,
                    description: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    propose_bounty,
                    DispatchError,
                > {
                    let call = propose_bounty { value, description };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn approve_bounty(
                    &self,
                    bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    approve_bounty,
                    DispatchError,
                > {
                    let call = approve_bounty { bounty_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn propose_curator(
                    &self,
                    bounty_id: ::core::primitive::u32,
                    curator: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    fee: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    propose_curator,
                    DispatchError,
                > {
                    let call = propose_curator {
                        bounty_id,
                        curator,
                        fee,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unassign_curator(
                    &self,
                    bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unassign_curator,
                    DispatchError,
                > {
                    let call = unassign_curator { bounty_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn accept_curator(
                    &self,
                    bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    accept_curator,
                    DispatchError,
                > {
                    let call = accept_curator { bounty_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn award_bounty(
                    &self,
                    bounty_id: ::core::primitive::u32,
                    beneficiary: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    award_bounty,
                    DispatchError,
                > {
                    let call = award_bounty {
                        bounty_id,
                        beneficiary,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn claim_bounty(
                    &self,
                    bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    claim_bounty,
                    DispatchError,
                > {
                    let call = claim_bounty { bounty_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn close_bounty(
                    &self,
                    bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    close_bounty,
                    DispatchError,
                > {
                    let call = close_bounty { bounty_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn extend_bounty_expiry(
                    &self,
                    bounty_id: ::core::primitive::u32,
                    remark: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    extend_bounty_expiry,
                    DispatchError,
                > {
                    let call = extend_bounty_expiry { bounty_id, remark };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_bounties::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct BountyProposed {
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Event for BountyProposed {
                const PALLET: &'static str = "Bounties";
                const EVENT: &'static str = "BountyProposed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BountyRejected {
                pub index: ::core::primitive::u32,
                pub bond: ::core::primitive::u128,
            }
            impl ::subxt::Event for BountyRejected {
                const PALLET: &'static str = "Bounties";
                const EVENT: &'static str = "BountyRejected";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct BountyBecameActive {
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Event for BountyBecameActive {
                const PALLET: &'static str = "Bounties";
                const EVENT: &'static str = "BountyBecameActive";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BountyAwarded {
                pub index: ::core::primitive::u32,
                pub beneficiary: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for BountyAwarded {
                const PALLET: &'static str = "Bounties";
                const EVENT: &'static str = "BountyAwarded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BountyClaimed {
                pub index: ::core::primitive::u32,
                pub payout: ::core::primitive::u128,
                pub beneficiary: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for BountyClaimed {
                const PALLET: &'static str = "Bounties";
                const EVENT: &'static str = "BountyClaimed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct BountyCanceled {
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Event for BountyCanceled {
                const PALLET: &'static str = "Bounties";
                const EVENT: &'static str = "BountyCanceled";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct BountyExtended {
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Event for BountyExtended {
                const PALLET: &'static str = "Bounties";
                const EVENT: &'static str = "BountyExtended";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct BountyCount;
            impl ::subxt::StorageEntry for BountyCount {
                const PALLET: &'static str = "Bounties";
                const STORAGE: &'static str = "BountyCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Bounties(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for Bounties {
                const PALLET: &'static str = "Bounties";
                const STORAGE: &'static str = "Bounties";
                type Value = runtime_types::pallet_bounties::Bounty<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct BountyDescriptions(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for BountyDescriptions {
                const PALLET: &'static str = "Bounties";
                const STORAGE: &'static str = "BountyDescriptions";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct BountyApprovals;
            impl ::subxt::StorageEntry for BountyApprovals {
                const PALLET: &'static str = "Bounties";
                const STORAGE: &'static str = "BountyApprovals";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u32 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn bounty_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = BountyCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn bounties(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_bounties::Bounty<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                            ::core::primitive::u32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Bounties(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn bounties_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Bounties>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn bounty_descriptions (& self , _0 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > > , :: subxt :: BasicError >{
                    let entry = BountyDescriptions(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn bounty_descriptions_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, BountyDescriptions>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn bounty_approvals (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u32 > , :: subxt :: BasicError >{
                    let entry = BountyApprovals;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn bounty_deposit_base(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 16u8, 165u8, 212u8, 232u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn bounty_deposit_payout_delay(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[32u8, 28u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn bounty_update_period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[192u8, 137u8, 1u8, 0u8][..],
                    )?)
                }
                pub fn bounty_curator_deposit(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Permill,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[32u8, 161u8, 7u8, 0u8][..],
                    )?)
                }
                pub fn bounty_value_minimum(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 80u8, 57u8, 39u8, 140u8, 4u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn data_deposit_per_byte(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 228u8, 11u8, 84u8, 2u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn maximum_reason_length(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[44u8, 1u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod child_bounties {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct add_child_bounty {
                #[codec(compact)]
                pub parent_bounty_id: ::core::primitive::u32,
                #[codec(compact)]
                pub value: ::core::primitive::u128,
                pub description: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for add_child_bounty {
                const PALLET: &'static str = "ChildBounties";
                const FUNCTION: &'static str = "add_child_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct propose_curator {
                #[codec(compact)]
                pub parent_bounty_id: ::core::primitive::u32,
                #[codec(compact)]
                pub child_bounty_id: ::core::primitive::u32,
                pub curator: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub fee: ::core::primitive::u128,
            }
            impl ::subxt::Call for propose_curator {
                const PALLET: &'static str = "ChildBounties";
                const FUNCTION: &'static str = "propose_curator";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct accept_curator {
                #[codec(compact)]
                pub parent_bounty_id: ::core::primitive::u32,
                #[codec(compact)]
                pub child_bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for accept_curator {
                const PALLET: &'static str = "ChildBounties";
                const FUNCTION: &'static str = "accept_curator";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unassign_curator {
                #[codec(compact)]
                pub parent_bounty_id: ::core::primitive::u32,
                #[codec(compact)]
                pub child_bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for unassign_curator {
                const PALLET: &'static str = "ChildBounties";
                const FUNCTION: &'static str = "unassign_curator";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct award_child_bounty {
                #[codec(compact)]
                pub parent_bounty_id: ::core::primitive::u32,
                #[codec(compact)]
                pub child_bounty_id: ::core::primitive::u32,
                pub beneficiary: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
            }
            impl ::subxt::Call for award_child_bounty {
                const PALLET: &'static str = "ChildBounties";
                const FUNCTION: &'static str = "award_child_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct claim_child_bounty {
                #[codec(compact)]
                pub parent_bounty_id: ::core::primitive::u32,
                #[codec(compact)]
                pub child_bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for claim_child_bounty {
                const PALLET: &'static str = "ChildBounties";
                const FUNCTION: &'static str = "claim_child_bounty";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct close_child_bounty {
                #[codec(compact)]
                pub parent_bounty_id: ::core::primitive::u32,
                #[codec(compact)]
                pub child_bounty_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for close_child_bounty {
                const PALLET: &'static str = "ChildBounties";
                const FUNCTION: &'static str = "close_child_bounty";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn add_child_bounty(
                    &self,
                    parent_bounty_id: ::core::primitive::u32,
                    value: ::core::primitive::u128,
                    description: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    add_child_bounty,
                    DispatchError,
                > {
                    let call = add_child_bounty {
                        parent_bounty_id,
                        value,
                        description,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn propose_curator(
                    &self,
                    parent_bounty_id: ::core::primitive::u32,
                    child_bounty_id: ::core::primitive::u32,
                    curator: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    fee: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    propose_curator,
                    DispatchError,
                > {
                    let call = propose_curator {
                        parent_bounty_id,
                        child_bounty_id,
                        curator,
                        fee,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn accept_curator(
                    &self,
                    parent_bounty_id: ::core::primitive::u32,
                    child_bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    accept_curator,
                    DispatchError,
                > {
                    let call = accept_curator {
                        parent_bounty_id,
                        child_bounty_id,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unassign_curator(
                    &self,
                    parent_bounty_id: ::core::primitive::u32,
                    child_bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unassign_curator,
                    DispatchError,
                > {
                    let call = unassign_curator {
                        parent_bounty_id,
                        child_bounty_id,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn award_child_bounty(
                    &self,
                    parent_bounty_id: ::core::primitive::u32,
                    child_bounty_id: ::core::primitive::u32,
                    beneficiary: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    award_child_bounty,
                    DispatchError,
                > {
                    let call = award_child_bounty {
                        parent_bounty_id,
                        child_bounty_id,
                        beneficiary,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn claim_child_bounty(
                    &self,
                    parent_bounty_id: ::core::primitive::u32,
                    child_bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    claim_child_bounty,
                    DispatchError,
                > {
                    let call = claim_child_bounty {
                        parent_bounty_id,
                        child_bounty_id,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn close_child_bounty(
                    &self,
                    parent_bounty_id: ::core::primitive::u32,
                    child_bounty_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    close_child_bounty,
                    DispatchError,
                > {
                    let call = close_child_bounty {
                        parent_bounty_id,
                        child_bounty_id,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_child_bounties::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Added {
                pub index: ::core::primitive::u32,
                pub child_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Added {
                const PALLET: &'static str = "ChildBounties";
                const EVENT: &'static str = "Added";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Awarded {
                pub index: ::core::primitive::u32,
                pub child_index: ::core::primitive::u32,
                pub beneficiary: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for Awarded {
                const PALLET: &'static str = "ChildBounties";
                const EVENT: &'static str = "Awarded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Claimed {
                pub index: ::core::primitive::u32,
                pub child_index: ::core::primitive::u32,
                pub payout: ::core::primitive::u128,
                pub beneficiary: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for Claimed {
                const PALLET: &'static str = "ChildBounties";
                const EVENT: &'static str = "Claimed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Canceled {
                pub index: ::core::primitive::u32,
                pub child_index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Canceled {
                const PALLET: &'static str = "ChildBounties";
                const EVENT: &'static str = "Canceled";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct ChildBountyCount;
            impl ::subxt::StorageEntry for ChildBountyCount {
                const PALLET: &'static str = "ChildBounties";
                const STORAGE: &'static str = "ChildBountyCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ParentChildBounties(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ParentChildBounties {
                const PALLET: &'static str = "ChildBounties";
                const STORAGE: &'static str = "ParentChildBounties";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ChildBounties(
                pub ::core::primitive::u32,
                pub ::core::primitive::u32,
            );
            impl ::subxt::StorageEntry for ChildBounties {
                const PALLET: &'static str = "ChildBounties";
                const STORAGE: &'static str = "ChildBounties";
                type Value = runtime_types::pallet_child_bounties::ChildBounty<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ChildBountyDescriptions(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ChildBountyDescriptions {
                const PALLET: &'static str = "ChildBounties";
                const STORAGE: &'static str = "ChildBountyDescriptions";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ChildrenCuratorFees(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for ChildrenCuratorFees {
                const PALLET: &'static str = "ChildBounties";
                const STORAGE: &'static str = "ChildrenCuratorFees";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn child_bounty_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ChildBountyCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn parent_child_bounties(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ParentChildBounties(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn parent_child_bounties_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ParentChildBounties>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn child_bounties(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_child_bounties::ChildBounty<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                            ::core::primitive::u32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ChildBounties(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn child_bounties_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ChildBounties>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn child_bounty_descriptions (& self , _0 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > > , :: subxt :: BasicError >{
                    let entry = ChildBountyDescriptions(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn child_bounty_descriptions_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ChildBountyDescriptions>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn children_curator_fees(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = ChildrenCuratorFees(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn children_curator_fees_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ChildrenCuratorFees>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn max_active_child_bounty_count(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[5u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn child_bounty_value_minimum(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            0u8, 16u8, 165u8, 212u8, 232u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
                pub fn child_bounty_curator_deposit_base(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Permill,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[160u8, 134u8, 1u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod bags_list {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct rebag {
                pub dislocated: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for rebag {
                const PALLET: &'static str = "BagsList";
                const FUNCTION: &'static str = "rebag";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct put_in_front_of {
                pub lighter: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for put_in_front_of {
                const PALLET: &'static str = "BagsList";
                const FUNCTION: &'static str = "put_in_front_of";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn rebag(
                    &self,
                    dislocated: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    rebag,
                    DispatchError,
                > {
                    let call = rebag { dislocated };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn put_in_front_of(
                    &self,
                    lighter: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    put_in_front_of,
                    DispatchError,
                > {
                    let call = put_in_front_of { lighter };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_bags_list::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Rebagged {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub from: ::core::primitive::u64,
                pub to: ::core::primitive::u64,
            }
            impl ::subxt::Event for Rebagged {
                const PALLET: &'static str = "BagsList";
                const EVENT: &'static str = "Rebagged";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct ListNodes(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for ListNodes {
                const PALLET: &'static str = "BagsList";
                const STORAGE: &'static str = "ListNodes";
                type Value = runtime_types::pallet_bags_list::list::Node;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct CounterForListNodes;
            impl ::subxt::StorageEntry for CounterForListNodes {
                const PALLET: &'static str = "BagsList";
                const STORAGE: &'static str = "CounterForListNodes";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ListBags(pub ::core::primitive::u64);
            impl ::subxt::StorageEntry for ListBags {
                const PALLET: &'static str = "BagsList";
                const STORAGE: &'static str = "ListBags";
                type Value = runtime_types::pallet_bags_list::list::Bag;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn list_nodes(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_bags_list::list::Node,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ListNodes(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn list_nodes_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ListNodes>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn counter_for_list_nodes(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = CounterForListNodes;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn list_bags(
                    &self,
                    _0: ::core::primitive::u64,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_bags_list::list::Bag,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ListBags(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn list_bags_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ListBags>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn bag_thresholds(
                    &self,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u64>,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            33u8, 3u8, 0u8, 64u8, 122u8, 16u8, 243u8, 90u8,
                            0u8, 0u8, 106u8, 112u8, 204u8, 212u8, 169u8, 96u8,
                            0u8, 0u8, 158u8, 243u8, 57u8, 127u8, 188u8, 102u8,
                            0u8, 0u8, 169u8, 7u8, 204u8, 213u8, 48u8, 109u8,
                            0u8, 0u8, 61u8, 154u8, 103u8, 251u8, 12u8, 116u8,
                            0u8, 0u8, 169u8, 191u8, 162u8, 117u8, 87u8, 123u8,
                            0u8, 0u8, 166u8, 253u8, 247u8, 50u8, 23u8, 131u8,
                            0u8, 0u8, 3u8, 79u8, 93u8, 145u8, 83u8, 139u8, 0u8,
                            0u8, 19u8, 36u8, 69u8, 101u8, 20u8, 148u8, 0u8,
                            0u8, 120u8, 8u8, 16u8, 1u8, 98u8, 157u8, 0u8, 0u8,
                            3u8, 2u8, 246u8, 60u8, 69u8, 167u8, 0u8, 0u8, 57u8,
                            46u8, 111u8, 127u8, 199u8, 177u8, 0u8, 0u8, 245u8,
                            156u8, 35u8, 198u8, 242u8, 188u8, 0u8, 0u8, 74u8,
                            231u8, 106u8, 175u8, 209u8, 200u8, 0u8, 0u8, 89u8,
                            138u8, 100u8, 132u8, 111u8, 213u8, 0u8, 0u8, 18u8,
                            159u8, 178u8, 67u8, 216u8, 226u8, 0u8, 0u8, 63u8,
                            34u8, 225u8, 172u8, 24u8, 241u8, 0u8, 0u8, 51u8,
                            164u8, 132u8, 76u8, 62u8, 0u8, 1u8, 0u8, 226u8,
                            229u8, 27u8, 137u8, 87u8, 16u8, 1u8, 0u8, 118u8,
                            162u8, 192u8, 176u8, 115u8, 33u8, 1u8, 0u8, 103u8,
                            137u8, 180u8, 7u8, 163u8, 51u8, 1u8, 0u8, 121u8,
                            62u8, 216u8, 215u8, 246u8, 70u8, 1u8, 0u8, 120u8,
                            19u8, 27u8, 129u8, 129u8, 91u8, 1u8, 0u8, 12u8,
                            28u8, 243u8, 138u8, 86u8, 113u8, 1u8, 0u8, 68u8,
                            55u8, 238u8, 182u8, 138u8, 136u8, 1u8, 0u8, 158u8,
                            181u8, 109u8, 20u8, 52u8, 161u8, 1u8, 0u8, 51u8,
                            94u8, 159u8, 21u8, 106u8, 187u8, 1u8, 0u8, 103u8,
                            195u8, 199u8, 165u8, 69u8, 215u8, 1u8, 0u8, 50u8,
                            24u8, 243u8, 64u8, 225u8, 244u8, 1u8, 0u8, 222u8,
                            11u8, 35u8, 13u8, 89u8, 20u8, 2u8, 0u8, 105u8,
                            156u8, 17u8, 245u8, 202u8, 53u8, 2u8, 0u8, 173u8,
                            80u8, 162u8, 196u8, 86u8, 89u8, 2u8, 0u8, 154u8,
                            228u8, 28u8, 71u8, 30u8, 127u8, 2u8, 0u8, 208u8,
                            36u8, 78u8, 103u8, 69u8, 167u8, 2u8, 0u8, 249u8,
                            132u8, 173u8, 81u8, 242u8, 209u8, 2u8, 0u8, 172u8,
                            231u8, 167u8, 152u8, 77u8, 255u8, 2u8, 0u8, 161u8,
                            24u8, 50u8, 91u8, 130u8, 47u8, 3u8, 0u8, 255u8,
                            164u8, 199u8, 109u8, 190u8, 98u8, 3u8, 0u8, 88u8,
                            11u8, 253u8, 133u8, 50u8, 153u8, 3u8, 0u8, 169u8,
                            175u8, 206u8, 104u8, 18u8, 211u8, 3u8, 0u8, 16u8,
                            154u8, 216u8, 27u8, 149u8, 16u8, 4u8, 0u8, 217u8,
                            202u8, 165u8, 25u8, 245u8, 81u8, 4u8, 0u8, 56u8,
                            223u8, 72u8, 137u8, 112u8, 151u8, 4u8, 0u8, 190u8,
                            225u8, 114u8, 121u8, 73u8, 225u8, 4u8, 0u8, 204u8,
                            115u8, 64u8, 31u8, 198u8, 47u8, 5u8, 0u8, 179u8,
                            4u8, 249u8, 24u8, 49u8, 131u8, 5u8, 0u8, 130u8,
                            139u8, 255u8, 180u8, 217u8, 219u8, 5u8, 0u8, 18u8,
                            53u8, 56u8, 61u8, 20u8, 58u8, 6u8, 0u8, 165u8,
                            180u8, 42u8, 71u8, 58u8, 158u8, 6u8, 0u8, 54u8,
                            102u8, 45u8, 9u8, 171u8, 8u8, 7u8, 0u8, 247u8,
                            58u8, 234u8, 180u8, 203u8, 121u8, 7u8, 0u8, 184u8,
                            126u8, 147u8, 215u8, 7u8, 242u8, 7u8, 0u8, 255u8,
                            236u8, 35u8, 192u8, 209u8, 113u8, 8u8, 0u8, 184u8,
                            75u8, 11u8, 236u8, 162u8, 249u8, 8u8, 0u8, 201u8,
                            220u8, 174u8, 122u8, 252u8, 137u8, 9u8, 0u8, 145u8,
                            117u8, 43u8, 168u8, 103u8, 35u8, 10u8, 0u8, 100u8,
                            241u8, 205u8, 79u8, 118u8, 198u8, 10u8, 0u8, 54u8,
                            9u8, 190u8, 118u8, 195u8, 115u8, 11u8, 0u8, 120u8,
                            101u8, 95u8, 223u8, 243u8, 43u8, 12u8, 0u8, 164u8,
                            7u8, 245u8, 165u8, 182u8, 239u8, 12u8, 0u8, 82u8,
                            246u8, 27u8, 231u8, 197u8, 191u8, 13u8, 0u8, 218u8,
                            113u8, 187u8, 112u8, 231u8, 156u8, 14u8, 0u8, 13u8,
                            233u8, 18u8, 126u8, 237u8, 135u8, 15u8, 0u8, 20u8,
                            119u8, 152u8, 127u8, 183u8, 129u8, 16u8, 0u8,
                            235u8, 238u8, 101u8, 239u8, 50u8, 139u8, 17u8, 0u8,
                            18u8, 105u8, 254u8, 50u8, 92u8, 165u8, 18u8, 0u8,
                            51u8, 248u8, 66u8, 139u8, 63u8, 209u8, 19u8, 0u8,
                            139u8, 165u8, 122u8, 19u8, 250u8, 15u8, 21u8, 0u8,
                            27u8, 43u8, 96u8, 208u8, 186u8, 98u8, 22u8, 0u8,
                            13u8, 29u8, 55u8, 208u8, 195u8, 202u8, 23u8, 0u8,
                            108u8, 100u8, 250u8, 92u8, 107u8, 73u8, 25u8, 0u8,
                            38u8, 34u8, 199u8, 65u8, 29u8, 224u8, 26u8, 0u8,
                            4u8, 91u8, 185u8, 36u8, 92u8, 144u8, 28u8, 0u8,
                            35u8, 61u8, 131u8, 246u8, 194u8, 91u8, 30u8, 0u8,
                            200u8, 119u8, 28u8, 121u8, 6u8, 68u8, 32u8, 0u8,
                            48u8, 19u8, 253u8, 222u8, 246u8, 74u8, 34u8, 0u8,
                            170u8, 139u8, 110u8, 132u8, 129u8, 114u8, 36u8,
                            0u8, 130u8, 192u8, 150u8, 196u8, 178u8, 188u8,
                            38u8, 0u8, 22u8, 163u8, 250u8, 235u8, 183u8, 43u8,
                            41u8, 0u8, 130u8, 150u8, 82u8, 74u8, 225u8, 193u8,
                            43u8, 0u8, 166u8, 54u8, 168u8, 101u8, 164u8, 129u8,
                            46u8, 0u8, 208u8, 226u8, 212u8, 80u8, 158u8, 109u8,
                            49u8, 0u8, 156u8, 10u8, 154u8, 39u8, 150u8, 136u8,
                            52u8, 0u8, 228u8, 250u8, 175u8, 178u8, 127u8,
                            213u8, 55u8, 0u8, 230u8, 230u8, 77u8, 54u8, 126u8,
                            87u8, 59u8, 0u8, 14u8, 75u8, 214u8, 109u8, 231u8,
                            17u8, 63u8, 0u8, 136u8, 177u8, 125u8, 183u8, 70u8,
                            8u8, 67u8, 0u8, 176u8, 125u8, 239u8, 114u8, 96u8,
                            62u8, 71u8, 0u8, 52u8, 222u8, 36u8, 150u8, 53u8,
                            184u8, 75u8, 0u8, 212u8, 139u8, 213u8, 123u8, 7u8,
                            122u8, 80u8, 0u8, 208u8, 189u8, 32u8, 239u8, 91u8,
                            136u8, 85u8, 0u8, 184u8, 240u8, 70u8, 120u8, 1u8,
                            232u8, 90u8, 0u8, 16u8, 248u8, 138u8, 238u8, 19u8,
                            158u8, 96u8, 0u8, 56u8, 146u8, 146u8, 83u8, 1u8,
                            176u8, 102u8, 0u8, 156u8, 149u8, 228u8, 252u8,
                            142u8, 35u8, 109u8, 0u8, 180u8, 18u8, 109u8, 16u8,
                            223u8, 254u8, 115u8, 0u8, 40u8, 180u8, 62u8, 89u8,
                            118u8, 72u8, 123u8, 0u8, 160u8, 138u8, 28u8, 122u8,
                            66u8, 7u8, 131u8, 0u8, 176u8, 154u8, 176u8, 131u8,
                            160u8, 66u8, 139u8, 0u8, 40u8, 70u8, 178u8, 244u8,
                            99u8, 2u8, 148u8, 0u8, 200u8, 97u8, 164u8, 42u8,
                            222u8, 78u8, 157u8, 0u8, 80u8, 210u8, 61u8, 74u8,
                            230u8, 48u8, 167u8, 0u8, 128u8, 81u8, 1u8, 167u8,
                            225u8, 177u8, 177u8, 0u8, 56u8, 229u8, 1u8, 178u8,
                            204u8, 219u8, 188u8, 0u8, 32u8, 22u8, 82u8, 120u8,
                            68u8, 185u8, 200u8, 0u8, 56u8, 137u8, 36u8, 186u8,
                            144u8, 85u8, 213u8, 0u8, 112u8, 202u8, 53u8, 164u8,
                            174u8, 188u8, 226u8, 0u8, 128u8, 95u8, 177u8, 53u8,
                            92u8, 251u8, 240u8, 0u8, 128u8, 53u8, 104u8, 93u8,
                            36u8, 31u8, 0u8, 1u8, 160u8, 195u8, 220u8, 217u8,
                            107u8, 54u8, 16u8, 1u8, 208u8, 120u8, 98u8, 232u8,
                            126u8, 80u8, 33u8, 1u8, 96u8, 232u8, 82u8, 208u8,
                            159u8, 125u8, 51u8, 1u8, 144u8, 102u8, 44u8, 88u8,
                            22u8, 207u8, 70u8, 1u8, 16u8, 39u8, 76u8, 51u8,
                            64u8, 87u8, 91u8, 1u8, 128u8, 75u8, 226u8, 119u8,
                            162u8, 41u8, 113u8, 1u8, 48u8, 130u8, 185u8, 45u8,
                            252u8, 90u8, 136u8, 1u8, 128u8, 210u8, 118u8, 7u8,
                            90u8, 1u8, 161u8, 1u8, 176u8, 245u8, 17u8, 89u8,
                            43u8, 52u8, 187u8, 1u8, 64u8, 49u8, 116u8, 95u8,
                            88u8, 12u8, 215u8, 1u8, 128u8, 47u8, 108u8, 238u8,
                            89u8, 164u8, 244u8, 1u8, 64u8, 255u8, 121u8, 155u8,
                            82u8, 24u8, 20u8, 2u8, 96u8, 117u8, 96u8, 125u8,
                            41u8, 134u8, 53u8, 2u8, 96u8, 253u8, 233u8, 153u8,
                            166u8, 13u8, 89u8, 2u8, 0u8, 229u8, 231u8, 28u8,
                            145u8, 208u8, 126u8, 2u8, 192u8, 223u8, 37u8,
                            117u8, 207u8, 242u8, 166u8, 2u8, 160u8, 127u8,
                            217u8, 117u8, 137u8, 154u8, 209u8, 2u8, 160u8,
                            103u8, 0u8, 157u8, 76u8, 240u8, 254u8, 2u8, 32u8,
                            220u8, 41u8, 161u8, 50u8, 31u8, 47u8, 3u8, 32u8,
                            255u8, 82u8, 107u8, 10u8, 85u8, 98u8, 3u8, 128u8,
                            136u8, 202u8, 163u8, 131u8, 194u8, 152u8, 3u8,
                            224u8, 86u8, 131u8, 251u8, 92u8, 155u8, 210u8, 3u8,
                            64u8, 29u8, 215u8, 93u8, 149u8, 22u8, 16u8, 4u8,
                            0u8, 49u8, 126u8, 57u8, 160u8, 110u8, 81u8, 4u8,
                            192u8, 176u8, 113u8, 18u8, 157u8, 225u8, 150u8,
                            4u8, 128u8, 180u8, 140u8, 145u8, 146u8, 177u8,
                            224u8, 4u8, 128u8, 232u8, 18u8, 74u8, 173u8, 36u8,
                            47u8, 5u8, 192u8, 7u8, 202u8, 112u8, 130u8, 133u8,
                            130u8, 5u8, 0u8, 124u8, 19u8, 196u8, 86u8, 35u8,
                            219u8, 5u8, 64u8, 131u8, 111u8, 232u8, 105u8, 82u8,
                            57u8, 6u8, 192u8, 112u8, 15u8, 129u8, 70u8, 108u8,
                            157u8, 6u8, 64u8, 240u8, 156u8, 80u8, 23u8, 208u8,
                            7u8, 7u8, 192u8, 230u8, 36u8, 179u8, 1u8, 227u8,
                            120u8, 7u8, 192u8, 51u8, 42u8, 199u8, 133u8, 16u8,
                            241u8, 7u8, 128u8, 7u8, 76u8, 161u8, 228u8, 202u8,
                            112u8, 8u8, 0u8, 213u8, 169u8, 235u8, 140u8, 139u8,
                            248u8, 8u8, 0u8, 168u8, 73u8, 88u8, 142u8, 211u8,
                            136u8, 9u8, 0u8, 128u8, 66u8, 84u8, 20u8, 44u8,
                            34u8, 10u8, 128u8, 162u8, 81u8, 112u8, 232u8, 38u8,
                            197u8, 10u8, 0u8, 232u8, 213u8, 250u8, 252u8, 94u8,
                            114u8, 11u8, 128u8, 29u8, 246u8, 78u8, 0u8, 121u8,
                            42u8, 12u8, 128u8, 212u8, 254u8, 100u8, 249u8,
                            35u8, 238u8, 12u8, 0u8, 109u8, 208u8, 56u8, 238u8,
                            25u8, 190u8, 13u8, 0u8, 30u8, 144u8, 164u8, 148u8,
                            32u8, 155u8, 14u8, 0u8, 16u8, 191u8, 87u8, 14u8,
                            10u8, 134u8, 15u8, 0u8, 218u8, 106u8, 157u8, 176u8,
                            181u8, 127u8, 16u8, 0u8, 191u8, 100u8, 175u8,
                            216u8, 16u8, 137u8, 17u8, 0u8, 187u8, 91u8, 96u8,
                            205u8, 23u8, 163u8, 18u8, 0u8, 249u8, 99u8, 243u8,
                            174u8, 214u8, 206u8, 19u8, 0u8, 213u8, 240u8, 4u8,
                            118u8, 106u8, 13u8, 21u8, 0u8, 224u8, 153u8, 119u8,
                            2u8, 2u8, 96u8, 22u8, 0u8, 16u8, 61u8, 102u8, 59u8,
                            223u8, 199u8, 23u8, 0u8, 222u8, 62u8, 45u8, 65u8,
                            88u8, 70u8, 25u8, 0u8, 236u8, 219u8, 173u8, 178u8,
                            216u8, 220u8, 26u8, 0u8, 69u8, 199u8, 0u8, 7u8,
                            227u8, 140u8, 28u8, 0u8, 184u8, 189u8, 224u8,
                            252u8, 17u8, 88u8, 30u8, 0u8, 186u8, 92u8, 42u8,
                            33u8, 26u8, 64u8, 32u8, 0u8, 64u8, 125u8, 228u8,
                            109u8, 203u8, 70u8, 34u8, 0u8, 222u8, 165u8, 91u8,
                            3u8, 19u8, 110u8, 36u8, 0u8, 170u8, 241u8, 243u8,
                            252u8, 252u8, 183u8, 38u8, 0u8, 20u8, 34u8, 111u8,
                            99u8, 182u8, 38u8, 41u8, 0u8, 100u8, 146u8, 128u8,
                            62u8, 143u8, 188u8, 43u8, 0u8, 132u8, 134u8, 166u8,
                            199u8, 252u8, 123u8, 46u8, 0u8, 44u8, 240u8, 95u8,
                            192u8, 155u8, 103u8, 49u8, 0u8, 218u8, 99u8, 247u8,
                            237u8, 50u8, 130u8, 52u8, 0u8, 240u8, 177u8, 63u8,
                            189u8, 181u8, 206u8, 55u8, 0u8, 242u8, 145u8,
                            196u8, 16u8, 71u8, 80u8, 59u8, 0u8, 66u8, 42u8,
                            26u8, 60u8, 60u8, 10u8, 63u8, 0u8, 44u8, 36u8,
                            33u8, 47u8, 32u8, 0u8, 67u8, 0u8, 172u8, 147u8,
                            66u8, 212u8, 182u8, 53u8, 71u8, 0u8, 204u8, 110u8,
                            215u8, 164u8, 0u8, 175u8, 75u8, 0u8, 196u8, 208u8,
                            34u8, 119u8, 62u8, 112u8, 80u8, 0u8, 32u8, 1u8,
                            125u8, 137u8, 245u8, 125u8, 85u8, 0u8, 248u8, 99u8,
                            135u8, 206u8, 243u8, 220u8, 90u8, 0u8, 140u8, 76u8,
                            127u8, 126u8, 84u8, 146u8, 96u8, 0u8, 32u8, 98u8,
                            7u8, 242u8, 132u8, 163u8, 102u8, 0u8, 204u8, 30u8,
                            5u8, 203u8, 73u8, 22u8, 109u8, 0u8, 180u8, 42u8,
                            122u8, 112u8, 196u8, 240u8, 115u8, 0u8, 212u8,
                            58u8, 144u8, 226u8, 120u8, 57u8, 123u8, 0u8, 56u8,
                            244u8, 97u8, 236u8, 83u8, 247u8, 130u8, 0u8, 160u8,
                            114u8, 100u8, 185u8, 177u8, 49u8, 139u8, 0u8, 72u8,
                            201u8, 179u8, 212u8, 100u8, 240u8, 147u8, 0u8, 0u8,
                            127u8, 233u8, 152u8, 189u8, 59u8, 157u8, 0u8, 16u8,
                            5u8, 143u8, 23u8, 146u8, 28u8, 167u8, 0u8, 0u8,
                            223u8, 175u8, 127u8, 70u8, 156u8, 177u8, 0u8,
                            232u8, 12u8, 136u8, 11u8, 214u8, 196u8, 188u8, 0u8,
                            88u8, 189u8, 203u8, 125u8, 220u8, 160u8, 200u8,
                            0u8, 56u8, 209u8, 141u8, 55u8, 160u8, 59u8, 213u8,
                            0u8, 48u8, 213u8, 91u8, 240u8, 28u8, 161u8, 226u8,
                            0u8, 112u8, 74u8, 192u8, 26u8, 15u8, 222u8, 240u8,
                            255u8, 255u8, 255u8, 255u8, 255u8, 255u8, 255u8,
                            255u8,
                        ][..],
                    )?)
                }
            }
        }
    }
    pub mod scheduler {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct schedule {
                pub when: ::core::primitive::u32,
                pub maybe_periodic: ::core::option::Option<(
                    ::core::primitive::u32,
                    ::core::primitive::u32,
                )>,
                pub priority: ::core::primitive::u8,
                pub call: ::std::boxed::Box<
                    runtime_types::frame_support::traits::schedule::MaybeHashed<
                        runtime_types::egg_standalone_runtime::Call,
                        ::subxt::sp_core::H256,
                    >,
                >,
            }
            impl ::subxt::Call for schedule {
                const PALLET: &'static str = "Scheduler";
                const FUNCTION: &'static str = "schedule";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct cancel {
                pub when: ::core::primitive::u32,
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Call for cancel {
                const PALLET: &'static str = "Scheduler";
                const FUNCTION: &'static str = "cancel";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct schedule_named {
                pub id: ::std::vec::Vec<::core::primitive::u8>,
                pub when: ::core::primitive::u32,
                pub maybe_periodic: ::core::option::Option<(
                    ::core::primitive::u32,
                    ::core::primitive::u32,
                )>,
                pub priority: ::core::primitive::u8,
                pub call: ::std::boxed::Box<
                    runtime_types::frame_support::traits::schedule::MaybeHashed<
                        runtime_types::egg_standalone_runtime::Call,
                        ::subxt::sp_core::H256,
                    >,
                >,
            }
            impl ::subxt::Call for schedule_named {
                const PALLET: &'static str = "Scheduler";
                const FUNCTION: &'static str = "schedule_named";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct cancel_named {
                pub id: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for cancel_named {
                const PALLET: &'static str = "Scheduler";
                const FUNCTION: &'static str = "cancel_named";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct schedule_after {
                pub after: ::core::primitive::u32,
                pub maybe_periodic: ::core::option::Option<(
                    ::core::primitive::u32,
                    ::core::primitive::u32,
                )>,
                pub priority: ::core::primitive::u8,
                pub call: ::std::boxed::Box<
                    runtime_types::frame_support::traits::schedule::MaybeHashed<
                        runtime_types::egg_standalone_runtime::Call,
                        ::subxt::sp_core::H256,
                    >,
                >,
            }
            impl ::subxt::Call for schedule_after {
                const PALLET: &'static str = "Scheduler";
                const FUNCTION: &'static str = "schedule_after";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct schedule_named_after {
                pub id: ::std::vec::Vec<::core::primitive::u8>,
                pub after: ::core::primitive::u32,
                pub maybe_periodic: ::core::option::Option<(
                    ::core::primitive::u32,
                    ::core::primitive::u32,
                )>,
                pub priority: ::core::primitive::u8,
                pub call: ::std::boxed::Box<
                    runtime_types::frame_support::traits::schedule::MaybeHashed<
                        runtime_types::egg_standalone_runtime::Call,
                        ::subxt::sp_core::H256,
                    >,
                >,
            }
            impl ::subxt::Call for schedule_named_after {
                const PALLET: &'static str = "Scheduler";
                const FUNCTION: &'static str = "schedule_named_after";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn schedule(
                    &self,
                    when: ::core::primitive::u32,
                    maybe_periodic: ::core::option::Option<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    priority: ::core::primitive::u8,
                    call : runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    schedule,
                    DispatchError,
                > {
                    let call = schedule {
                        when,
                        maybe_periodic,
                        priority,
                        call: ::std::boxed::Box::new(call),
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn cancel(
                    &self,
                    when: ::core::primitive::u32,
                    index: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    cancel,
                    DispatchError,
                > {
                    let call = cancel { when, index };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn schedule_named(
                    &self,
                    id: ::std::vec::Vec<::core::primitive::u8>,
                    when: ::core::primitive::u32,
                    maybe_periodic: ::core::option::Option<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    priority: ::core::primitive::u8,
                    call : runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    schedule_named,
                    DispatchError,
                > {
                    let call = schedule_named {
                        id,
                        when,
                        maybe_periodic,
                        priority,
                        call: ::std::boxed::Box::new(call),
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn cancel_named(
                    &self,
                    id: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    cancel_named,
                    DispatchError,
                > {
                    let call = cancel_named { id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn schedule_after(
                    &self,
                    after: ::core::primitive::u32,
                    maybe_periodic: ::core::option::Option<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    priority: ::core::primitive::u8,
                    call : runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    schedule_after,
                    DispatchError,
                > {
                    let call = schedule_after {
                        after,
                        maybe_periodic,
                        priority,
                        call: ::std::boxed::Box::new(call),
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn schedule_named_after(
                    &self,
                    id: ::std::vec::Vec<::core::primitive::u8>,
                    after: ::core::primitive::u32,
                    maybe_periodic: ::core::option::Option<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    priority: ::core::primitive::u8,
                    call : runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    schedule_named_after,
                    DispatchError,
                > {
                    let call = schedule_named_after {
                        id,
                        after,
                        maybe_periodic,
                        priority,
                        call: ::std::boxed::Box::new(call),
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_scheduler::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Scheduled {
                pub when: ::core::primitive::u32,
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Scheduled {
                const PALLET: &'static str = "Scheduler";
                const EVENT: &'static str = "Scheduled";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Canceled {
                pub when: ::core::primitive::u32,
                pub index: ::core::primitive::u32,
            }
            impl ::subxt::Event for Canceled {
                const PALLET: &'static str = "Scheduler";
                const EVENT: &'static str = "Canceled";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Dispatched {
                pub task: (::core::primitive::u32, ::core::primitive::u32),
                pub id: ::core::option::Option<
                    ::std::vec::Vec<::core::primitive::u8>,
                >,
                pub result: ::core::result::Result<
                    (),
                    runtime_types::sp_runtime::DispatchError,
                >,
            }
            impl ::subxt::Event for Dispatched {
                const PALLET: &'static str = "Scheduler";
                const EVENT: &'static str = "Dispatched";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct CallLookupFailed {
                pub task: (::core::primitive::u32, ::core::primitive::u32),
                pub id: ::core::option::Option<
                    ::std::vec::Vec<::core::primitive::u8>,
                >,
                pub error:
                    runtime_types::frame_support::traits::schedule::LookupError,
            }
            impl ::subxt::Event for CallLookupFailed {
                const PALLET: &'static str = "Scheduler";
                const EVENT: &'static str = "CallLookupFailed";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Agenda(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for Agenda {
                const PALLET: &'static str = "Scheduler";
                const STORAGE: &'static str = "Agenda";
                type Value = :: std :: vec :: Vec < :: core :: option :: Option < runtime_types :: pallet_scheduler :: ScheduledV3 < runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 > , :: core :: primitive :: u32 , runtime_types :: egg_standalone_runtime :: OriginCaller , :: subxt :: sp_core :: crypto :: AccountId32 > > > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct Lookup(pub ::std::vec::Vec<::core::primitive::u8>);
            impl ::subxt::StorageEntry for Lookup {
                const PALLET: &'static str = "Scheduler";
                const STORAGE: &'static str = "Lookup";
                type Value = (::core::primitive::u32, ::core::primitive::u32);
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }                pub async fn agenda (& self , _0 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: std :: vec :: Vec < :: core :: option :: Option < runtime_types :: pallet_scheduler :: ScheduledV3 < runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 > , :: core :: primitive :: u32 , runtime_types :: egg_standalone_runtime :: OriginCaller , :: subxt :: sp_core :: crypto :: AccountId32 > > > , :: subxt :: BasicError >{
                    let entry = Agenda(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn agenda_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Agenda>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn lookup(
                    &self,
                    _0: ::std::vec::Vec<::core::primitive::u8>,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<(
                        ::core::primitive::u32,
                        ::core::primitive::u32,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = Lookup(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn lookup_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Lookup>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn maximum_weight(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 160u8, 219u8, 33u8, 93u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn max_scheduled_per_block(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[50u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod preimage {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct note_preimage {
                pub bytes: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for note_preimage {
                const PALLET: &'static str = "Preimage";
                const FUNCTION: &'static str = "note_preimage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unnote_preimage {
                pub hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for unnote_preimage {
                const PALLET: &'static str = "Preimage";
                const FUNCTION: &'static str = "unnote_preimage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct request_preimage {
                pub hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for request_preimage {
                const PALLET: &'static str = "Preimage";
                const FUNCTION: &'static str = "request_preimage";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unrequest_preimage {
                pub hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Call for unrequest_preimage {
                const PALLET: &'static str = "Preimage";
                const FUNCTION: &'static str = "unrequest_preimage";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn note_preimage(
                    &self,
                    bytes: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    note_preimage,
                    DispatchError,
                > {
                    let call = note_preimage { bytes };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unnote_preimage(
                    &self,
                    hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unnote_preimage,
                    DispatchError,
                > {
                    let call = unnote_preimage { hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn request_preimage(
                    &self,
                    hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    request_preimage,
                    DispatchError,
                > {
                    let call = request_preimage { hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unrequest_preimage(
                    &self,
                    hash: ::subxt::sp_core::H256,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unrequest_preimage,
                    DispatchError,
                > {
                    let call = unrequest_preimage { hash };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_preimage::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Noted {
                pub hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Event for Noted {
                const PALLET: &'static str = "Preimage";
                const EVENT: &'static str = "Noted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Requested {
                pub hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Event for Requested {
                const PALLET: &'static str = "Preimage";
                const EVENT: &'static str = "Requested";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Cleared {
                pub hash: ::subxt::sp_core::H256,
            }
            impl ::subxt::Event for Cleared {
                const PALLET: &'static str = "Preimage";
                const EVENT: &'static str = "Cleared";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct StatusFor(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for StatusFor {
                const PALLET: &'static str = "Preimage";
                const STORAGE: &'static str = "StatusFor";
                type Value = runtime_types::pallet_preimage::RequestStatus<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Identity,
                        ),
                    ])
                }
            }
            pub struct PreimageFor(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for PreimageFor {
                const PALLET: &'static str = "Preimage";
                const STORAGE: &'static str = "PreimageFor";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Identity,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn status_for(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_preimage::RequestStatus<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = StatusFor(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn status_for_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, StatusFor>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn preimage_for (& self , _0 : :: subxt :: sp_core :: H256 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > > , :: subxt :: BasicError >{
                    let entry = PreimageFor(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn preimage_for_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, PreimageFor>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
    }
    pub mod offences {
        use super::runtime_types;
        pub type Event = runtime_types::pallet_offences::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Offence {
                pub kind: [::core::primitive::u8; 16usize],
                pub timeslot: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Event for Offence {
                const PALLET: &'static str = "Offences";
                const EVENT: &'static str = "Offence";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Reports(pub ::subxt::sp_core::H256);
            impl ::subxt::StorageEntry for Reports {
                const PALLET: &'static str = "Offences";
                const STORAGE: &'static str = "Reports";
                type Value = runtime_types::sp_staking::offence::OffenceDetails<
                    ::subxt::sp_core::crypto::AccountId32,
                    (
                        ::subxt::sp_core::crypto::AccountId32,
                        runtime_types::pallet_staking::Exposure<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    ),
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ConcurrentReportsIndex(
                pub [::core::primitive::u8; 16usize],
                pub ::std::vec::Vec<::core::primitive::u8>,
            );
            impl ::subxt::StorageEntry for ConcurrentReportsIndex {
                const PALLET: &'static str = "Offences";
                const STORAGE: &'static str = "ConcurrentReportsIndex";
                type Value = ::std::vec::Vec<::subxt::sp_core::H256>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct ReportsByKindIndex(pub [::core::primitive::u8; 16usize]);
            impl ::subxt::StorageEntry for ReportsByKindIndex {
                const PALLET: &'static str = "Offences";
                const STORAGE: &'static str = "ReportsByKindIndex";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn reports(
                    &self,
                    _0: ::subxt::sp_core::H256,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::sp_staking::offence::OffenceDetails<
                            ::subxt::sp_core::crypto::AccountId32,
                            (
                                ::subxt::sp_core::crypto::AccountId32,
                                runtime_types::pallet_staking::Exposure<
                                    ::subxt::sp_core::crypto::AccountId32,
                                    ::core::primitive::u128,
                                >,
                            ),
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Reports(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn reports_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Reports>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn concurrent_reports_index(
                    &self,
                    _0: [::core::primitive::u8; 16usize],
                    _1: ::std::vec::Vec<::core::primitive::u8>,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::subxt::sp_core::H256>,
                    ::subxt::BasicError,
                > {
                    let entry = ConcurrentReportsIndex(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn concurrent_reports_index_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ConcurrentReportsIndex>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn reports_by_kind_index(
                    &self,
                    _0: [::core::primitive::u8; 16usize],
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = ReportsByKindIndex(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn reports_by_kind_index_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ReportsByKindIndex>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
    }
    pub mod dkg {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct set_signature_threshold {
                pub new_threshold: ::core::primitive::u16,
            }
            impl ::subxt::Call for set_signature_threshold {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "set_signature_threshold";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct set_keygen_threshold {
                pub new_threshold: ::core::primitive::u16,
            }
            impl ::subxt::Call for set_keygen_threshold {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "set_keygen_threshold";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct set_refresh_delay {
                pub new_delay: ::core::primitive::u8,
            }
            impl ::subxt::Call for set_refresh_delay {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "set_refresh_delay";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit_public_key {
                pub keys_and_signatures:
                    runtime_types::dkg_runtime_primitives::AggregatedPublicKeys,
            }
            impl ::subxt::Call for submit_public_key {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "submit_public_key";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit_next_public_key {
                pub keys_and_signatures:
                    runtime_types::dkg_runtime_primitives::AggregatedPublicKeys,
            }
            impl ::subxt::Call for submit_next_public_key {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "submit_next_public_key";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit_public_key_signature { pub signature_proposal : runtime_types :: dkg_runtime_primitives :: proposal :: RefreshProposalSigned , }
            impl ::subxt::Call for submit_public_key_signature {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "submit_public_key_signature";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit_misbehaviour_reports { pub reports : runtime_types :: dkg_runtime_primitives :: AggregatedMisbehaviourReports < runtime_types :: dkg_runtime_primitives :: crypto :: Public > , }
            impl ::subxt::Call for submit_misbehaviour_reports {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "submit_misbehaviour_reports";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unjail;
            impl ::subxt::Call for unjail {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "unjail";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_unjail_keygen {
                pub authority:
                    runtime_types::dkg_runtime_primitives::crypto::Public,
            }
            impl ::subxt::Call for force_unjail_keygen {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "force_unjail_keygen";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_unjail_signing {
                pub authority:
                    runtime_types::dkg_runtime_primitives::crypto::Public,
            }
            impl ::subxt::Call for force_unjail_signing {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "force_unjail_signing";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct manual_increment_nonce;
            impl ::subxt::Call for manual_increment_nonce {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "manual_increment_nonce";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct manual_refresh;
            impl ::subxt::Call for manual_refresh {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "manual_refresh";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_change_authorities;
            impl ::subxt::Call for force_change_authorities {
                const PALLET: &'static str = "DKG";
                const FUNCTION: &'static str = "force_change_authorities";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set_signature_threshold(
                    &self,
                    new_threshold: ::core::primitive::u16,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_signature_threshold,
                    DispatchError,
                > {
                    let call = set_signature_threshold { new_threshold };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_keygen_threshold(
                    &self,
                    new_threshold: ::core::primitive::u16,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_keygen_threshold,
                    DispatchError,
                > {
                    let call = set_keygen_threshold { new_threshold };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_refresh_delay(
                    &self,
                    new_delay: ::core::primitive::u8,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_refresh_delay,
                    DispatchError,
                > {
                    let call = set_refresh_delay { new_delay };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn submit_public_key(
                    &self,
                    keys_and_signatures : runtime_types :: dkg_runtime_primitives :: AggregatedPublicKeys,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit_public_key,
                    DispatchError,
                > {
                    let call = submit_public_key {
                        keys_and_signatures,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn submit_next_public_key(
                    &self,
                    keys_and_signatures : runtime_types :: dkg_runtime_primitives :: AggregatedPublicKeys,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit_next_public_key,
                    DispatchError,
                > {
                    let call = submit_next_public_key {
                        keys_and_signatures,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn submit_public_key_signature(
                    &self,
                    signature_proposal : runtime_types :: dkg_runtime_primitives :: proposal :: RefreshProposalSigned,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit_public_key_signature,
                    DispatchError,
                > {
                    let call =
                        submit_public_key_signature { signature_proposal };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn submit_misbehaviour_reports(
                    &self,
                    reports : runtime_types :: dkg_runtime_primitives :: AggregatedMisbehaviourReports < runtime_types :: dkg_runtime_primitives :: crypto :: Public >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit_misbehaviour_reports,
                    DispatchError,
                > {
                    let call = submit_misbehaviour_reports { reports };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unjail(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unjail,
                    DispatchError,
                > {
                    let call = unjail {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_unjail_keygen(
                    &self,
                    authority : runtime_types :: dkg_runtime_primitives :: crypto :: Public,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_unjail_keygen,
                    DispatchError,
                > {
                    let call = force_unjail_keygen { authority };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_unjail_signing(
                    &self,
                    authority : runtime_types :: dkg_runtime_primitives :: crypto :: Public,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_unjail_signing,
                    DispatchError,
                > {
                    let call = force_unjail_signing { authority };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn manual_increment_nonce(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    manual_increment_nonce,
                    DispatchError,
                > {
                    let call = manual_increment_nonce {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn manual_refresh(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    manual_refresh,
                    DispatchError,
                > {
                    let call = manual_refresh {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_change_authorities(
                    &self,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_change_authorities,
                    DispatchError,
                > {
                    let call = force_change_authorities {};
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_dkg_metadata::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PublicKeySubmitted {
                pub compressed_pub_key: ::std::vec::Vec<::core::primitive::u8>,
                pub uncompressed_pub_key:
                    ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Event for PublicKeySubmitted {
                const PALLET: &'static str = "DKG";
                const EVENT: &'static str = "PublicKeySubmitted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct NextPublicKeySubmitted {
                pub compressed_pub_key: ::std::vec::Vec<::core::primitive::u8>,
                pub uncompressed_pub_key:
                    ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Event for NextPublicKeySubmitted {
                const PALLET: &'static str = "DKG";
                const EVENT: &'static str = "NextPublicKeySubmitted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct NextPublicKeySignatureSubmitted {
                pub pub_key_sig: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Event for NextPublicKeySignatureSubmitted {
                const PALLET: &'static str = "DKG";
                const EVENT: &'static str = "NextPublicKeySignatureSubmitted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PublicKeyChanged {
                pub compressed_pub_key: ::std::vec::Vec<::core::primitive::u8>,
                pub uncompressed_pub_key:
                    ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Event for PublicKeyChanged {
                const PALLET: &'static str = "DKG";
                const EVENT: &'static str = "PublicKeyChanged";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PublicKeySignatureChanged {
                pub pub_key_sig: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Event for PublicKeySignatureChanged {
                const PALLET: &'static str = "DKG";
                const EVENT: &'static str = "PublicKeySignatureChanged";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct MisbehaviourReportsSubmitted {
                pub misbehaviour_type:
                    runtime_types::dkg_runtime_primitives::MisbehaviourType,
                pub reporters: ::std::vec::Vec<
                    runtime_types::dkg_runtime_primitives::crypto::Public,
                >,
            }
            impl ::subxt::Event for MisbehaviourReportsSubmitted {
                const PALLET: &'static str = "DKG";
                const EVENT: &'static str = "MisbehaviourReportsSubmitted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct RefreshKeysFinished {
                pub next_authority_set_id: ::core::primitive::u64,
            }
            impl ::subxt::Event for RefreshKeysFinished {
                const PALLET: &'static str = "DKG";
                const EVENT: &'static str = "RefreshKeysFinished";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct UsedSignatures;
            impl ::subxt::StorageEntry for UsedSignatures {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "UsedSignatures";
                type Value =
                    ::std::vec::Vec<::std::vec::Vec<::core::primitive::u8>>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct RefreshNonce;
            impl ::subxt::StorageEntry for RefreshNonce {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "RefreshNonce";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct RefreshDelay;
            impl ::subxt::StorageEntry for RefreshDelay {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "RefreshDelay";
                type Value = runtime_types::sp_arithmetic::per_things::Permill;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct RefreshInProgress;
            impl ::subxt::StorageEntry for RefreshInProgress {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "RefreshInProgress";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ShouldManualRefresh;
            impl ::subxt::StorageEntry for ShouldManualRefresh {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "ShouldManualRefresh";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextDKGPublicKey;
            impl ::subxt::StorageEntry for NextDKGPublicKey {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextDKGPublicKey";
                type Value = (
                    ::core::primitive::u64,
                    ::std::vec::Vec<::core::primitive::u8>,
                );
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextPublicKeySignature;
            impl ::subxt::StorageEntry for NextPublicKeySignature {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextPublicKeySignature";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct DKGPublicKey;
            impl ::subxt::StorageEntry for DKGPublicKey {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "DKGPublicKey";
                type Value = (
                    ::core::primitive::u64,
                    ::std::vec::Vec<::core::primitive::u8>,
                );
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct DKGPublicKeySignature;
            impl ::subxt::StorageEntry for DKGPublicKeySignature {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "DKGPublicKeySignature";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct PreviousPublicKey;
            impl ::subxt::StorageEntry for PreviousPublicKey {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "PreviousPublicKey";
                type Value = (
                    ::core::primitive::u64,
                    ::std::vec::Vec<::core::primitive::u8>,
                );
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct HistoricalRounds(pub ::core::primitive::u64);
            impl ::subxt::StorageEntry for HistoricalRounds {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "HistoricalRounds";
                type Value =
                    runtime_types::pallet_dkg_metadata::types::RoundMetadata;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct SignatureThreshold;
            impl ::subxt::StorageEntry for SignatureThreshold {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "SignatureThreshold";
                type Value = ::core::primitive::u16;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct KeygenThreshold;
            impl ::subxt::StorageEntry for KeygenThreshold {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "KeygenThreshold";
                type Value = ::core::primitive::u16;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextSignatureThreshold;
            impl ::subxt::StorageEntry for NextSignatureThreshold {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextSignatureThreshold";
                type Value = ::core::primitive::u16;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextKeygenThreshold;
            impl ::subxt::StorageEntry for NextKeygenThreshold {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextKeygenThreshold";
                type Value = ::core::primitive::u16;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct PendingSignatureThreshold;
            impl ::subxt::StorageEntry for PendingSignatureThreshold {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "PendingSignatureThreshold";
                type Value = ::core::primitive::u16;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct PendingKeygenThreshold;
            impl ::subxt::StorageEntry for PendingKeygenThreshold {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "PendingKeygenThreshold";
                type Value = ::core::primitive::u16;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Authorities;
            impl ::subxt::StorageEntry for Authorities {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "Authorities";
                type Value = ::std::vec::Vec<
                    runtime_types::dkg_runtime_primitives::crypto::Public,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct AuthoritySetId;
            impl ::subxt::StorageEntry for AuthoritySetId {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "AuthoritySetId";
                type Value = ::core::primitive::u64;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextAuthoritySetId;
            impl ::subxt::StorageEntry for NextAuthoritySetId {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextAuthoritySetId";
                type Value = ::core::primitive::u64;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextAuthorities;
            impl ::subxt::StorageEntry for NextAuthorities {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextAuthorities";
                type Value = ::std::vec::Vec<
                    runtime_types::dkg_runtime_primitives::crypto::Public,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct CurrentAuthoritiesAccounts;
            impl ::subxt::StorageEntry for CurrentAuthoritiesAccounts {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "CurrentAuthoritiesAccounts";
                type Value =
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextAuthoritiesAccounts;
            impl ::subxt::StorageEntry for NextAuthoritiesAccounts {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextAuthoritiesAccounts";
                type Value =
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct AccountToAuthority(
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::StorageEntry for AccountToAuthority {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "AccountToAuthority";
                type Value =
                    runtime_types::dkg_runtime_primitives::crypto::Public;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct MisbehaviourReports(
                pub runtime_types::dkg_runtime_primitives::MisbehaviourType,
                pub ::core::primitive::u64,
                pub runtime_types::dkg_runtime_primitives::crypto::Public,
            );
            impl ::subxt::StorageEntry for MisbehaviourReports {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "MisbehaviourReports";
                type Value = runtime_types :: dkg_runtime_primitives :: AggregatedMisbehaviourReports < runtime_types :: dkg_runtime_primitives :: crypto :: Public > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct AuthorityReputations(
                pub runtime_types::dkg_runtime_primitives::crypto::Public,
            );
            impl ::subxt::StorageEntry for AuthorityReputations {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "AuthorityReputations";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct JailedKeygenAuthorities(
                pub runtime_types::dkg_runtime_primitives::crypto::Public,
            );
            impl ::subxt::StorageEntry for JailedKeygenAuthorities {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "JailedKeygenAuthorities";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct JailedSigningAuthorities(
                pub runtime_types::dkg_runtime_primitives::crypto::Public,
            );
            impl ::subxt::StorageEntry for JailedSigningAuthorities {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "JailedSigningAuthorities";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct BestAuthorities;
            impl ::subxt::StorageEntry for BestAuthorities {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "BestAuthorities";
                type Value = ::std::vec::Vec<(
                    ::core::primitive::u16,
                    runtime_types::dkg_runtime_primitives::crypto::Public,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextBestAuthorities;
            impl ::subxt::StorageEntry for NextBestAuthorities {
                const PALLET: &'static str = "DKG";
                const STORAGE: &'static str = "NextBestAuthorities";
                type Value = ::std::vec::Vec<(
                    ::core::primitive::u16,
                    runtime_types::dkg_runtime_primitives::crypto::Public,
                )>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn used_signatures(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::std::vec::Vec<::core::primitive::u8>>,
                    ::subxt::BasicError,
                > {
                    let entry = UsedSignatures;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn refresh_nonce(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = RefreshNonce;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn refresh_delay(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Permill,
                    ::subxt::BasicError,
                > {
                    let entry = RefreshDelay;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn refresh_in_progress(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = RefreshInProgress;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn should_manual_refresh(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = ShouldManualRefresh;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_dkg_public_key(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<(
                        ::core::primitive::u64,
                        ::std::vec::Vec<::core::primitive::u8>,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = NextDKGPublicKey;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn next_public_key_signature(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::std::vec::Vec<::core::primitive::u8>,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = NextPublicKeySignature;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn dkg_public_key(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    (
                        ::core::primitive::u64,
                        ::std::vec::Vec<::core::primitive::u8>,
                    ),
                    ::subxt::BasicError,
                > {
                    let entry = DKGPublicKey;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn dkg_public_key_signature(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = DKGPublicKeySignature;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn previous_public_key(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    (
                        ::core::primitive::u64,
                        ::std::vec::Vec<::core::primitive::u8>,
                    ),
                    ::subxt::BasicError,
                > {
                    let entry = PreviousPublicKey;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn historical_rounds(
                    &self,
                    _0: ::core::primitive::u64,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::pallet_dkg_metadata::types::RoundMetadata,
                    ::subxt::BasicError,
                > {
                    let entry = HistoricalRounds(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn historical_rounds_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, HistoricalRounds>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn signature_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    let entry = SignatureThreshold;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn keygen_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    let entry = KeygenThreshold;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_signature_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    let entry = NextSignatureThreshold;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_keygen_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    let entry = NextKeygenThreshold;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn pending_signature_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    let entry = PendingSignatureThreshold;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn pending_keygen_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    let entry = PendingKeygenThreshold;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn authorities(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<
                        runtime_types::dkg_runtime_primitives::crypto::Public,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Authorities;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn authority_set_id(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    let entry = AuthoritySetId;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_authority_set_id(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    let entry = NextAuthoritySetId;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_authorities(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<
                        runtime_types::dkg_runtime_primitives::crypto::Public,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = NextAuthorities;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn current_authorities_accounts(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentAuthoritiesAccounts;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_authorities_accounts(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    ::subxt::BasicError,
                > {
                    let entry = NextAuthoritiesAccounts;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn account_to_authority(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::dkg_runtime_primitives::crypto::Public,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = AccountToAuthority(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn account_to_authority_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, AccountToAuthority>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn misbehaviour_reports (& self , _0 : runtime_types :: dkg_runtime_primitives :: MisbehaviourType , _1 : :: core :: primitive :: u64 , _2 : runtime_types :: dkg_runtime_primitives :: crypto :: Public , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: dkg_runtime_primitives :: AggregatedMisbehaviourReports < runtime_types :: dkg_runtime_primitives :: crypto :: Public > > , :: subxt :: BasicError >{
                    let entry = MisbehaviourReports(_0, _1, _2);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn misbehaviour_reports_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, MisbehaviourReports>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn authority_reputations(
                    &self,
                    _0: runtime_types::dkg_runtime_primitives::crypto::Public,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = AuthorityReputations(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn authority_reputations_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, AuthorityReputations>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn jailed_keygen_authorities(
                    &self,
                    _0: runtime_types::dkg_runtime_primitives::crypto::Public,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = JailedKeygenAuthorities(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn jailed_keygen_authorities_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, JailedKeygenAuthorities>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn jailed_signing_authorities(
                    &self,
                    _0: runtime_types::dkg_runtime_primitives::crypto::Public,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = JailedSigningAuthorities(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn jailed_signing_authorities_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, JailedSigningAuthorities>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn best_authorities(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<(
                        ::core::primitive::u16,
                        runtime_types::dkg_runtime_primitives::crypto::Public,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = BestAuthorities;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_best_authorities(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<(
                        ::core::primitive::u16,
                        runtime_types::dkg_runtime_primitives::crypto::Public,
                    )>,
                    ::subxt::BasicError,
                > {
                    let entry = NextBestAuthorities;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn refresh_delay(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::sp_arithmetic::per_things::Permill,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[160u8, 187u8, 13u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod dkg_proposals {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct set_threshold {
                pub threshold: ::core::primitive::u32,
            }
            impl ::subxt::Call for set_threshold {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "set_threshold";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_resource {
                pub id: runtime_types::webb_proposals::header::ResourceId,
                pub method: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for set_resource {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "set_resource";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remove_resource {
                pub id: runtime_types::webb_proposals::header::ResourceId,
            }
            impl ::subxt::Call for remove_resource {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "remove_resource";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct whitelist_chain {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
            }
            impl ::subxt::Call for whitelist_chain {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "whitelist_chain";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct add_proposer {
                pub native_account: ::subxt::sp_core::crypto::AccountId32,
                pub external_account: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for add_proposer {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "add_proposer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remove_proposer {
                pub v: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for remove_proposer {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "remove_proposer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct acknowledge_proposal {
                pub nonce: runtime_types::webb_proposals::nonce::Nonce,
                pub src_chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub r_id: runtime_types::webb_proposals::header::ResourceId,
                pub prop: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for acknowledge_proposal {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "acknowledge_proposal";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct reject_proposal {
                pub nonce: runtime_types::webb_proposals::nonce::Nonce,
                pub src_chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub r_id: runtime_types::webb_proposals::header::ResourceId,
                pub prop: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for reject_proposal {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "reject_proposal";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct eval_vote_state {
                pub nonce: runtime_types::webb_proposals::nonce::Nonce,
                pub src_chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub prop: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for eval_vote_state {
                const PALLET: &'static str = "DKGProposals";
                const FUNCTION: &'static str = "eval_vote_state";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set_threshold(
                    &self,
                    threshold: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_threshold,
                    DispatchError,
                > {
                    let call = set_threshold { threshold };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_resource(
                    &self,
                    id: runtime_types::webb_proposals::header::ResourceId,
                    method: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_resource,
                    DispatchError,
                > {
                    let call = set_resource { id, method };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remove_resource(
                    &self,
                    id: runtime_types::webb_proposals::header::ResourceId,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remove_resource,
                    DispatchError,
                > {
                    let call = remove_resource { id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn whitelist_chain(
                    &self,
                    chain_id : runtime_types :: webb_proposals :: header :: TypedChainId,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    whitelist_chain,
                    DispatchError,
                > {
                    let call = whitelist_chain { chain_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn add_proposer(
                    &self,
                    native_account: ::subxt::sp_core::crypto::AccountId32,
                    external_account: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    add_proposer,
                    DispatchError,
                > {
                    let call = add_proposer {
                        native_account,
                        external_account,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remove_proposer(
                    &self,
                    v: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remove_proposer,
                    DispatchError,
                > {
                    let call = remove_proposer { v };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn acknowledge_proposal(
                    &self,
                    nonce: runtime_types::webb_proposals::nonce::Nonce,
                    src_chain_id : runtime_types :: webb_proposals :: header :: TypedChainId,
                    r_id: runtime_types::webb_proposals::header::ResourceId,
                    prop: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    acknowledge_proposal,
                    DispatchError,
                > {
                    let call = acknowledge_proposal {
                        nonce,
                        src_chain_id,
                        r_id,
                        prop,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn reject_proposal(
                    &self,
                    nonce: runtime_types::webb_proposals::nonce::Nonce,
                    src_chain_id : runtime_types :: webb_proposals :: header :: TypedChainId,
                    r_id: runtime_types::webb_proposals::header::ResourceId,
                    prop: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    reject_proposal,
                    DispatchError,
                > {
                    let call = reject_proposal {
                        nonce,
                        src_chain_id,
                        r_id,
                        prop,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn eval_vote_state(
                    &self,
                    nonce: runtime_types::webb_proposals::nonce::Nonce,
                    src_chain_id : runtime_types :: webb_proposals :: header :: TypedChainId,
                    prop: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    eval_vote_state,
                    DispatchError,
                > {
                    let call = eval_vote_state {
                        nonce,
                        src_chain_id,
                        prop,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_dkg_proposals::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct ProposerThresholdChanged {
                pub new_threshold: ::core::primitive::u32,
            }
            impl ::subxt::Event for ProposerThresholdChanged {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ProposerThresholdChanged";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ChainWhitelisted {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
            }
            impl ::subxt::Event for ChainWhitelisted {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ChainWhitelisted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposerAdded {
                pub proposer_id: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for ProposerAdded {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ProposerAdded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposerRemoved {
                pub proposer_id: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for ProposerRemoved {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ProposerRemoved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct VoteFor {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub proposal_nonce: runtime_types::webb_proposals::nonce::Nonce,
                pub who: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for VoteFor {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "VoteFor";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct VoteAgainst {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub proposal_nonce: runtime_types::webb_proposals::nonce::Nonce,
                pub who: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for VoteAgainst {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "VoteAgainst";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalApproved {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub proposal_nonce: runtime_types::webb_proposals::nonce::Nonce,
            }
            impl ::subxt::Event for ProposalApproved {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ProposalApproved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalRejected {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub proposal_nonce: runtime_types::webb_proposals::nonce::Nonce,
            }
            impl ::subxt::Event for ProposalRejected {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ProposalRejected";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalSucceeded {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub proposal_nonce: runtime_types::webb_proposals::nonce::Nonce,
            }
            impl ::subxt::Event for ProposalSucceeded {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ProposalSucceeded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalFailed {
                pub chain_id:
                    runtime_types::webb_proposals::header::TypedChainId,
                pub proposal_nonce: runtime_types::webb_proposals::nonce::Nonce,
            }
            impl ::subxt::Event for ProposalFailed {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "ProposalFailed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AuthorityProposersReset {
                pub proposers:
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
            }
            impl ::subxt::Event for AuthorityProposersReset {
                const PALLET: &'static str = "DKGProposals";
                const EVENT: &'static str = "AuthorityProposersReset";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct ChainNonces(
                pub runtime_types::webb_proposals::header::TypedChainId,
            );
            impl ::subxt::StorageEntry for ChainNonces {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "ChainNonces";
                type Value = runtime_types::webb_proposals::nonce::Nonce;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct ProposerThreshold;
            impl ::subxt::StorageEntry for ProposerThreshold {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "ProposerThreshold";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ProposerSetUpdateProposalNonce;
            impl ::subxt::StorageEntry for ProposerSetUpdateProposalNonce {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "ProposerSetUpdateProposalNonce";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Proposers(pub ::subxt::sp_core::crypto::AccountId32);
            impl ::subxt::StorageEntry for Proposers {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "Proposers";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct ExternalProposerAccounts(
                pub ::subxt::sp_core::crypto::AccountId32,
            );
            impl ::subxt::StorageEntry for ExternalProposerAccounts {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "ExternalProposerAccounts";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct AuthorityProposers;
            impl ::subxt::StorageEntry for AuthorityProposers {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "AuthorityProposers";
                type Value =
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ExternalAuthorityProposerAccounts;
            impl ::subxt::StorageEntry for ExternalAuthorityProposerAccounts {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str =
                    "ExternalAuthorityProposerAccounts";
                type Value =
                    ::std::vec::Vec<::std::vec::Vec<::core::primitive::u8>>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ProposerCount;
            impl ::subxt::StorageEntry for ProposerCount {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "ProposerCount";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Votes(
                pub runtime_types::webb_proposals::header::TypedChainId,
                pub  (
                    runtime_types::webb_proposals::nonce::Nonce,
                    ::std::vec::Vec<::core::primitive::u8>,
                ),
            );
            impl ::subxt::StorageEntry for Votes {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "Votes";
                type Value =
                    runtime_types::pallet_dkg_proposals::types::ProposalVotes<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct Resources(
                pub runtime_types::webb_proposals::header::ResourceId,
            );
            impl ::subxt::StorageEntry for Resources {
                const PALLET: &'static str = "DKGProposals";
                const STORAGE: &'static str = "Resources";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn chain_nonces(
                    &self,
                    _0: runtime_types::webb_proposals::header::TypedChainId,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::webb_proposals::nonce::Nonce,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = ChainNonces(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn chain_nonces_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ChainNonces>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn proposer_threshold(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ProposerThreshold;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn proposer_set_update_proposal_nonce(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ProposerSetUpdateProposalNonce;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn proposers(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = Proposers(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn proposers_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Proposers>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn external_proposer_accounts(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = ExternalProposerAccounts(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn external_proposer_accounts_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ExternalProposerAccounts>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn authority_proposers(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::subxt::sp_core::crypto::AccountId32>,
                    ::subxt::BasicError,
                > {
                    let entry = AuthorityProposers;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn external_authority_proposer_accounts(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::std::vec::Vec<::core::primitive::u8>>,
                    ::subxt::BasicError,
                > {
                    let entry = ExternalAuthorityProposerAccounts;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn proposer_count(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ProposerCount;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn votes (& self , _0 : runtime_types :: webb_proposals :: header :: TypedChainId , _1 : (runtime_types :: webb_proposals :: nonce :: Nonce , :: std :: vec :: Vec < :: core :: primitive :: u8 > ,) , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_dkg_proposals :: types :: ProposalVotes < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 > > , :: subxt :: BasicError >{
                    let entry = Votes(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn votes_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Votes>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn resources(
                    &self,
                    _0: runtime_types::webb_proposals::header::ResourceId,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::std::vec::Vec<::core::primitive::u8>,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Resources(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn resources_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Resources>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn chain_identifier(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::webb_proposals::header::TypedChainId,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[5u8, 5u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn proposal_lifetime(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[60u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn period(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[8u8, 7u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod dkg_proposal_handler {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct submit_signed_proposals {
                pub props: ::std::vec::Vec<
                    runtime_types::dkg_runtime_primitives::proposal::Proposal,
                >,
            }
            impl ::subxt::Call for submit_signed_proposals {
                const PALLET: &'static str = "DKGProposalHandler";
                const FUNCTION: &'static str = "submit_signed_proposals";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_submit_unsigned_proposal {
                pub prop:
                    runtime_types::dkg_runtime_primitives::proposal::Proposal,
            }
            impl ::subxt::Call for force_submit_unsigned_proposal {
                const PALLET: &'static str = "DKGProposalHandler";
                const FUNCTION: &'static str = "force_submit_unsigned_proposal";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn submit_signed_proposals(
                    &self,
                    props : :: std :: vec :: Vec < runtime_types :: dkg_runtime_primitives :: proposal :: Proposal >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    submit_signed_proposals,
                    DispatchError,
                > {
                    let call = submit_signed_proposals { props };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_submit_unsigned_proposal(
                    &self,
                    prop : runtime_types :: dkg_runtime_primitives :: proposal :: Proposal,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_submit_unsigned_proposal,
                    DispatchError,
                > {
                    let call = force_submit_unsigned_proposal { prop };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event =
            runtime_types::pallet_dkg_proposal_handler::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct InvalidProposalSignature { pub kind : runtime_types :: dkg_runtime_primitives :: proposal :: ProposalKind , pub data : :: std :: vec :: Vec < :: core :: primitive :: u8 > , pub invalid_signature : :: std :: vec :: Vec < :: core :: primitive :: u8 > , }
            impl ::subxt::Event for InvalidProposalSignature {
                const PALLET: &'static str = "DKGProposalHandler";
                const EVENT: &'static str = "InvalidProposalSignature";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalSigned { pub key : runtime_types :: dkg_runtime_primitives :: proposal :: DKGPayloadKey , pub target_chain : runtime_types :: webb_proposals :: header :: TypedChainId , pub data : :: std :: vec :: Vec < :: core :: primitive :: u8 > , pub signature : :: std :: vec :: Vec < :: core :: primitive :: u8 > , }
            impl ::subxt::Event for ProposalSigned {
                const PALLET: &'static str = "DKGProposalHandler";
                const EVENT: &'static str = "ProposalSigned";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct UnsignedProposalQueue (pub runtime_types :: webb_proposals :: header :: TypedChainId , pub runtime_types :: dkg_runtime_primitives :: proposal :: DKGPayloadKey) ;
            impl ::subxt::StorageEntry for UnsignedProposalQueue {
                const PALLET: &'static str = "DKGProposalHandler";
                const STORAGE: &'static str = "UnsignedProposalQueue";
                type Value =
                    runtime_types::dkg_runtime_primitives::proposal::Proposal;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct SignedProposals (pub runtime_types :: webb_proposals :: header :: TypedChainId , pub runtime_types :: dkg_runtime_primitives :: proposal :: DKGPayloadKey) ;
            impl ::subxt::StorageEntry for SignedProposals {
                const PALLET: &'static str = "DKGProposalHandler";
                const STORAGE: &'static str = "SignedProposals";
                type Value =
                    runtime_types::dkg_runtime_primitives::proposal::Proposal;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }                pub async fn unsigned_proposal_queue (& self , _0 : runtime_types :: webb_proposals :: header :: TypedChainId , _1 : runtime_types :: dkg_runtime_primitives :: proposal :: DKGPayloadKey , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: dkg_runtime_primitives :: proposal :: Proposal > , :: subxt :: BasicError >{
                    let entry = UnsignedProposalQueue(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn unsigned_proposal_queue_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, UnsignedProposalQueue>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn signed_proposals (& self , _0 : runtime_types :: webb_proposals :: header :: TypedChainId , _1 : runtime_types :: dkg_runtime_primitives :: proposal :: DKGPayloadKey , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: dkg_runtime_primitives :: proposal :: Proposal > , :: subxt :: BasicError >{
                    let entry = SignedProposals(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn signed_proposals_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, SignedProposals>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn max_submissions_per_batch(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u16,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(&mut &[100u8, 0u8][..])?)
                }
            }
        }
    }
    pub mod hasher_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_set_parameters {
                pub parameters: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for force_set_parameters {
                const PALLET: &'static str = "HasherBn254";
                const FUNCTION: &'static str = "force_set_parameters";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn force_set_parameters(
                    &self,
                    parameters: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_set_parameters,
                    DispatchError,
                > {
                    let call = force_set_parameters { parameters };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_hasher::pallet::Event;
        pub mod events {
            use super::runtime_types;
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Parameters;
            impl ::subxt::StorageEntry for Parameters {
                const PALLET: &'static str = "HasherBn254";
                const STORAGE: &'static str = "Parameters";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn parameters(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = Parameters;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
    }
    pub mod asset_registry {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct register {
                pub name: ::std::vec::Vec<::core::primitive::u8>,
                pub asset_type:
                    runtime_types::pallet_asset_registry::types::AssetType<
                        ::core::primitive::u32,
                    >,
                pub existential_deposit: ::core::primitive::u128,
            }
            impl ::subxt::Call for register {
                const PALLET: &'static str = "AssetRegistry";
                const FUNCTION: &'static str = "register";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct update {
                pub asset_id: ::core::primitive::u32,
                pub name: ::std::vec::Vec<::core::primitive::u8>,
                pub asset_type:
                    runtime_types::pallet_asset_registry::types::AssetType<
                        ::core::primitive::u32,
                    >,
                pub existential_deposit:
                    ::core::option::Option<::core::primitive::u128>,
            }
            impl ::subxt::Call for update {
                const PALLET: &'static str = "AssetRegistry";
                const FUNCTION: &'static str = "update";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_metadata {
                pub asset_id: ::core::primitive::u32,
                pub symbol: ::std::vec::Vec<::core::primitive::u8>,
                pub decimals: ::core::primitive::u8,
            }
            impl ::subxt::Call for set_metadata {
                const PALLET: &'static str = "AssetRegistry";
                const FUNCTION: &'static str = "set_metadata";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_location {
                pub asset_id: ::core::primitive::u32,
                pub location: (),
            }
            impl ::subxt::Call for set_location {
                const PALLET: &'static str = "AssetRegistry";
                const FUNCTION: &'static str = "set_location";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct add_asset_to_pool {
                pub pool: ::std::vec::Vec<::core::primitive::u8>,
                pub asset_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for add_asset_to_pool {
                const PALLET: &'static str = "AssetRegistry";
                const FUNCTION: &'static str = "add_asset_to_pool";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct delete_asset_from_pool {
                pub pool: ::std::vec::Vec<::core::primitive::u8>,
                pub asset_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for delete_asset_from_pool {
                const PALLET: &'static str = "AssetRegistry";
                const FUNCTION: &'static str = "delete_asset_from_pool";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn register(
                    &self,
                    name: ::std::vec::Vec<::core::primitive::u8>,
                    asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 >,
                    existential_deposit: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    register,
                    DispatchError,
                > {
                    let call = register {
                        name,
                        asset_type,
                        existential_deposit,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn update(
                    &self,
                    asset_id: ::core::primitive::u32,
                    name: ::std::vec::Vec<::core::primitive::u8>,
                    asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 >,
                    existential_deposit: ::core::option::Option<
                        ::core::primitive::u128,
                    >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    update,
                    DispatchError,
                > {
                    let call = update {
                        asset_id,
                        name,
                        asset_type,
                        existential_deposit,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_metadata(
                    &self,
                    asset_id: ::core::primitive::u32,
                    symbol: ::std::vec::Vec<::core::primitive::u8>,
                    decimals: ::core::primitive::u8,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_metadata,
                    DispatchError,
                > {
                    let call = set_metadata {
                        asset_id,
                        symbol,
                        decimals,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_location(
                    &self,
                    asset_id: ::core::primitive::u32,
                    location: (),
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_location,
                    DispatchError,
                > {
                    let call = set_location { asset_id, location };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn add_asset_to_pool(
                    &self,
                    pool: ::std::vec::Vec<::core::primitive::u8>,
                    asset_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    add_asset_to_pool,
                    DispatchError,
                > {
                    let call = add_asset_to_pool { pool, asset_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn delete_asset_from_pool(
                    &self,
                    pool: ::std::vec::Vec<::core::primitive::u8>,
                    asset_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    delete_asset_from_pool,
                    DispatchError,
                > {
                    let call = delete_asset_from_pool { pool, asset_id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_asset_registry::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Registered { pub asset_id : :: core :: primitive :: u32 , pub name : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > , pub asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 > , }
            impl ::subxt::Event for Registered {
                const PALLET: &'static str = "AssetRegistry";
                const EVENT: &'static str = "Registered";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Updated { pub asset_id : :: core :: primitive :: u32 , pub name : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > , pub asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 > , }
            impl ::subxt::Event for Updated {
                const PALLET: &'static str = "AssetRegistry";
                const EVENT: &'static str = "Updated";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct MetadataSet { pub asset_id : :: core :: primitive :: u32 , pub symbol : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > , pub decimals : :: core :: primitive :: u8 , }
            impl ::subxt::Event for MetadataSet {
                const PALLET: &'static str = "AssetRegistry";
                const EVENT: &'static str = "MetadataSet";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct LocationSet {
                pub asset_id: ::core::primitive::u32,
                pub location: (),
            }
            impl ::subxt::Event for LocationSet {
                const PALLET: &'static str = "AssetRegistry";
                const EVENT: &'static str = "LocationSet";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Assets(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for Assets {
                const PALLET: &'static str = "AssetRegistry";
                const STORAGE: &'static str = "Assets";
                type Value = runtime_types :: pallet_asset_registry :: types :: AssetDetails < :: core :: primitive :: u32 , :: core :: primitive :: u128 , runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct NextAssetId;
            impl ::subxt::StorageEntry for NextAssetId {
                const PALLET: &'static str = "AssetRegistry";
                const STORAGE: &'static str = "NextAssetId";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct AssetIds (pub runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 >) ;
            impl ::subxt::StorageEntry for AssetIds {
                const PALLET: &'static str = "AssetRegistry";
                const STORAGE: &'static str = "AssetIds";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct AssetLocations(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for AssetLocations {
                const PALLET: &'static str = "AssetRegistry";
                const STORAGE: &'static str = "AssetLocations";
                type Value = ();
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct LocationAssets();
            impl ::subxt::StorageEntry for LocationAssets {
                const PALLET: &'static str = "AssetRegistry";
                const STORAGE: &'static str = "LocationAssets";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![])
                }
            }
            pub struct AssetMetadataMap(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for AssetMetadataMap {
                const PALLET: &'static str = "AssetRegistry";
                const STORAGE: &'static str = "AssetMetadataMap";
                type Value = runtime_types :: pallet_asset_registry :: types :: AssetMetadata < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }                pub async fn assets (& self , _0 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_asset_registry :: types :: AssetDetails < :: core :: primitive :: u32 , :: core :: primitive :: u128 , runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > > > , :: subxt :: BasicError >{
                    let entry = Assets(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn assets_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Assets>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn next_asset_id(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = NextAssetId;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn asset_ids(
                    &self,
                    _0 : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 >,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = AssetIds(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn asset_ids_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, AssetIds>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn asset_locations(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<()>,
                    ::subxt::BasicError,
                > {
                    let entry = AssetLocations(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn asset_locations_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, AssetLocations>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn location_assets(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = LocationAssets();
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn location_assets_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, LocationAssets>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn asset_metadata_map (& self , _0 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_asset_registry :: types :: AssetMetadata < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > > > , :: subxt :: BasicError >{
                    let entry = AssetMetadataMap(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn asset_metadata_map_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, AssetMetadataMap>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn native_asset_id(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod currencies {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub currency_id: ::core::primitive::u32,
                #[codec(compact)]
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Call for transfer {
                const PALLET: &'static str = "Currencies";
                const FUNCTION: &'static str = "transfer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer_native_currency {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                #[codec(compact)]
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Call for transfer_native_currency {
                const PALLET: &'static str = "Currencies";
                const FUNCTION: &'static str = "transfer_native_currency";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct update_balance {
                pub who: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub currency_id: ::core::primitive::u32,
                pub amount: ::core::primitive::i128,
            }
            impl ::subxt::Call for update_balance {
                const PALLET: &'static str = "Currencies";
                const FUNCTION: &'static str = "update_balance";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn transfer(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    currency_id: ::core::primitive::u32,
                    amount: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer,
                    DispatchError,
                > {
                    let call = transfer {
                        dest,
                        currency_id,
                        amount,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn transfer_native_currency(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    amount: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer_native_currency,
                    DispatchError,
                > {
                    let call = transfer_native_currency { dest, amount };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn update_balance(
                    &self,
                    who: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    currency_id: ::core::primitive::u32,
                    amount: ::core::primitive::i128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    update_balance,
                    DispatchError,
                > {
                    let call = update_balance {
                        who,
                        currency_id,
                        amount,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::orml_currencies::module::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Transferred {
                pub currency_id: ::core::primitive::u32,
                pub from: ::subxt::sp_core::crypto::AccountId32,
                pub to: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Transferred {
                const PALLET: &'static str = "Currencies";
                const EVENT: &'static str = "Transferred";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BalanceUpdated {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::i128,
            }
            impl ::subxt::Event for BalanceUpdated {
                const PALLET: &'static str = "Currencies";
                const EVENT: &'static str = "BalanceUpdated";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Deposited {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Deposited {
                const PALLET: &'static str = "Currencies";
                const EVENT: &'static str = "Deposited";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Withdrawn {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Withdrawn {
                const PALLET: &'static str = "Currencies";
                const EVENT: &'static str = "Withdrawn";
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn get_native_currency_id(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod tokens {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub currency_id: ::core::primitive::u32,
                #[codec(compact)]
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Call for transfer {
                const PALLET: &'static str = "Tokens";
                const FUNCTION: &'static str = "transfer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer_all {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub currency_id: ::core::primitive::u32,
                pub keep_alive: ::core::primitive::bool,
            }
            impl ::subxt::Call for transfer_all {
                const PALLET: &'static str = "Tokens";
                const FUNCTION: &'static str = "transfer_all";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct transfer_keep_alive {
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub currency_id: ::core::primitive::u32,
                #[codec(compact)]
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Call for transfer_keep_alive {
                const PALLET: &'static str = "Tokens";
                const FUNCTION: &'static str = "transfer_keep_alive";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_transfer {
                pub source: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub dest: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub currency_id: ::core::primitive::u32,
                #[codec(compact)]
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Call for force_transfer {
                const PALLET: &'static str = "Tokens";
                const FUNCTION: &'static str = "force_transfer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_balance {
                pub who: ::subxt::sp_runtime::MultiAddress<
                    ::subxt::sp_core::crypto::AccountId32,
                    ::core::primitive::u32,
                >,
                pub currency_id: ::core::primitive::u32,
                #[codec(compact)]
                pub new_free: ::core::primitive::u128,
                #[codec(compact)]
                pub new_reserved: ::core::primitive::u128,
            }
            impl ::subxt::Call for set_balance {
                const PALLET: &'static str = "Tokens";
                const FUNCTION: &'static str = "set_balance";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn transfer(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    currency_id: ::core::primitive::u32,
                    amount: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer,
                    DispatchError,
                > {
                    let call = transfer {
                        dest,
                        currency_id,
                        amount,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn transfer_all(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    currency_id: ::core::primitive::u32,
                    keep_alive: ::core::primitive::bool,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer_all,
                    DispatchError,
                > {
                    let call = transfer_all {
                        dest,
                        currency_id,
                        keep_alive,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn transfer_keep_alive(
                    &self,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    currency_id: ::core::primitive::u32,
                    amount: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    transfer_keep_alive,
                    DispatchError,
                > {
                    let call = transfer_keep_alive {
                        dest,
                        currency_id,
                        amount,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_transfer(
                    &self,
                    source: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    dest: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    currency_id: ::core::primitive::u32,
                    amount: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_transfer,
                    DispatchError,
                > {
                    let call = force_transfer {
                        source,
                        dest,
                        currency_id,
                        amount,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_balance(
                    &self,
                    who: ::subxt::sp_runtime::MultiAddress<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u32,
                    >,
                    currency_id: ::core::primitive::u32,
                    new_free: ::core::primitive::u128,
                    new_reserved: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_balance,
                    DispatchError,
                > {
                    let call = set_balance {
                        who,
                        currency_id,
                        new_free,
                        new_reserved,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::orml_tokens::module::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Endowed {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Endowed {
                const PALLET: &'static str = "Tokens";
                const EVENT: &'static str = "Endowed";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct DustLost {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for DustLost {
                const PALLET: &'static str = "Tokens";
                const EVENT: &'static str = "DustLost";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Transfer {
                pub currency_id: ::core::primitive::u32,
                pub from: ::subxt::sp_core::crypto::AccountId32,
                pub to: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Transfer {
                const PALLET: &'static str = "Tokens";
                const EVENT: &'static str = "Transfer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Reserved {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Reserved {
                const PALLET: &'static str = "Tokens";
                const EVENT: &'static str = "Reserved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Unreserved {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Unreserved {
                const PALLET: &'static str = "Tokens";
                const EVENT: &'static str = "Unreserved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct RepatriatedReserve { pub currency_id : :: core :: primitive :: u32 , pub from : :: subxt :: sp_core :: crypto :: AccountId32 , pub to : :: subxt :: sp_core :: crypto :: AccountId32 , pub amount : :: core :: primitive :: u128 , pub status : runtime_types :: frame_support :: traits :: tokens :: misc :: BalanceStatus , }
            impl ::subxt::Event for RepatriatedReserve {
                const PALLET: &'static str = "Tokens";
                const EVENT: &'static str = "RepatriatedReserve";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BalanceSet {
                pub currency_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub free: ::core::primitive::u128,
                pub reserved: ::core::primitive::u128,
            }
            impl ::subxt::Event for BalanceSet {
                const PALLET: &'static str = "Tokens";
                const EVENT: &'static str = "BalanceSet";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct TotalIssuance(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for TotalIssuance {
                const PALLET: &'static str = "Tokens";
                const STORAGE: &'static str = "TotalIssuance";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct Locks(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u32,
            );
            impl ::subxt::StorageEntry for Locks {
                const PALLET: &'static str = "Tokens";
                const STORAGE: &'static str = "Locks";
                type Value = runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < runtime_types :: orml_tokens :: BalanceLock < :: core :: primitive :: u128 > > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct Accounts(
                pub ::subxt::sp_core::crypto::AccountId32,
                pub ::core::primitive::u32,
            );
            impl ::subxt::StorageEntry for Accounts {
                const PALLET: &'static str = "Tokens";
                const STORAGE: &'static str = "Accounts";
                type Value = runtime_types::orml_tokens::AccountData<
                    ::core::primitive::u128,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Twox64Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn total_issuance(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    let entry = TotalIssuance(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn total_issuance_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, TotalIssuance>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn locks (& self , _0 : :: subxt :: sp_core :: crypto :: AccountId32 , _1 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < runtime_types :: orml_tokens :: BalanceLock < :: core :: primitive :: u128 > > , :: subxt :: BasicError >{
                    let entry = Locks(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn locks_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Locks>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn accounts(
                    &self,
                    _0: ::subxt::sp_core::crypto::AccountId32,
                    _1: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    runtime_types::orml_tokens::AccountData<
                        ::core::primitive::u128,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Accounts(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn accounts_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Accounts>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn max_locks(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod token_wrapper {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_wrapping_fee {
                pub fee: ::core::primitive::u128,
                pub into_pool_share_id: ::core::primitive::u32,
            }
            impl ::subxt::Call for set_wrapping_fee {
                const PALLET: &'static str = "TokenWrapper";
                const FUNCTION: &'static str = "set_wrapping_fee";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct wrap {
                pub from_asset_id: ::core::primitive::u32,
                pub into_pool_share_id: ::core::primitive::u32,
                pub amount: ::core::primitive::u128,
                pub recipient: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for wrap {
                const PALLET: &'static str = "TokenWrapper";
                const FUNCTION: &'static str = "wrap";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct unwrap {
                pub from_pool_share_id: ::core::primitive::u32,
                pub into_asset_id: ::core::primitive::u32,
                pub amount: ::core::primitive::u128,
                pub recipient: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Call for unwrap {
                const PALLET: &'static str = "TokenWrapper";
                const FUNCTION: &'static str = "unwrap";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set_wrapping_fee(
                    &self,
                    fee: ::core::primitive::u128,
                    into_pool_share_id: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_wrapping_fee,
                    DispatchError,
                > {
                    let call = set_wrapping_fee {
                        fee,
                        into_pool_share_id,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn wrap(
                    &self,
                    from_asset_id: ::core::primitive::u32,
                    into_pool_share_id: ::core::primitive::u32,
                    amount: ::core::primitive::u128,
                    recipient: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    wrap,
                    DispatchError,
                > {
                    let call = wrap {
                        from_asset_id,
                        into_pool_share_id,
                        amount,
                        recipient,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn unwrap(
                    &self,
                    from_pool_share_id: ::core::primitive::u32,
                    into_asset_id: ::core::primitive::u32,
                    amount: ::core::primitive::u128,
                    recipient: ::subxt::sp_core::crypto::AccountId32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    unwrap,
                    DispatchError,
                > {
                    let call = unwrap {
                        from_pool_share_id,
                        into_asset_id,
                        amount,
                        recipient,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_token_wrapper::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct WrappedToken {
                pub pool_share_asset: ::core::primitive::u32,
                pub asset_id: ::core::primitive::u32,
                pub amount: ::core::primitive::u128,
                pub recipient: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for WrappedToken {
                const PALLET: &'static str = "TokenWrapper";
                const EVENT: &'static str = "WrappedToken";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct UnwrappedToken {
                pub pool_share_asset: ::core::primitive::u32,
                pub asset_id: ::core::primitive::u32,
                pub amount: ::core::primitive::u128,
                pub recipient: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for UnwrappedToken {
                const PALLET: &'static str = "TokenWrapper";
                const EVENT: &'static str = "UnwrappedToken";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct UpdatedWrappingFeePercent {
                pub into_pool_share_id: ::core::primitive::u32,
                pub wrapping_fee_percent: ::core::primitive::u128,
            }
            impl ::subxt::Event for UpdatedWrappingFeePercent {
                const PALLET: &'static str = "TokenWrapper";
                const EVENT: &'static str = "UpdatedWrappingFeePercent";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct WrappingFeePercent(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for WrappingFeePercent {
                const PALLET: &'static str = "TokenWrapper";
                const STORAGE: &'static str = "WrappingFeePercent";
                type Value = ::core::primitive::u128;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn wrapping_fee_percent(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u128>,
                    ::subxt::BasicError,
                > {
                    let entry = WrappingFeePercent(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn wrapping_fee_percent_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, WrappingFeePercent>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn pallet_id(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::PalletId,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            100u8, 119u8, 47u8, 116u8, 107u8, 119u8, 114u8,
                            112u8,
                        ][..],
                    )?)
                }
                pub fn treasury_id(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::PalletId,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            100u8, 119u8, 47u8, 100u8, 107u8, 103u8, 97u8, 99u8,
                        ][..],
                    )?)
                }
                pub fn wrapping_fee_divider(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u128,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            100u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                            0u8, 0u8, 0u8, 0u8, 0u8, 0u8,
                        ][..],
                    )?)
                }
            }
        }
    }
    pub mod mixer_verifier_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_set_parameters {
                pub parameters: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for force_set_parameters {
                const PALLET: &'static str = "MixerVerifierBn254";
                const FUNCTION: &'static str = "force_set_parameters";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn force_set_parameters(
                    &self,
                    parameters: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_set_parameters,
                    DispatchError,
                > {
                    let call = force_set_parameters { parameters };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_verifier::pallet::Event;
        pub mod events {
            use super::runtime_types;
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Parameters;
            impl ::subxt::StorageEntry for Parameters {
                const PALLET: &'static str = "MixerVerifierBn254";
                const STORAGE: &'static str = "Parameters";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn parameters(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = Parameters;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
    }
    pub mod anchor_verifier_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_set_parameters {
                pub parameters: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for force_set_parameters {
                const PALLET: &'static str = "AnchorVerifierBn254";
                const FUNCTION: &'static str = "force_set_parameters";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn force_set_parameters(
                    &self,
                    parameters: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_set_parameters,
                    DispatchError,
                > {
                    let call = force_set_parameters { parameters };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_verifier::pallet::Event;
        pub mod events {
            use super::runtime_types;
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Parameters;
            impl ::subxt::StorageEntry for Parameters {
                const PALLET: &'static str = "AnchorVerifierBn254";
                const STORAGE: &'static str = "Parameters";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn parameters(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = Parameters;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
    }
    pub mod merkle_tree_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct create {
                pub depth: ::core::primitive::u8,
            }
            impl ::subxt::Call for create {
                const PALLET: &'static str = "MerkleTreeBn254";
                const FUNCTION: &'static str = "create";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct insert { pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Call for insert {
                const PALLET: &'static str = "MerkleTreeBn254";
                const FUNCTION: &'static str = "insert";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_set_default_hashes { pub default_hashes : :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > , }
            impl ::subxt::Call for force_set_default_hashes {
                const PALLET: &'static str = "MerkleTreeBn254";
                const FUNCTION: &'static str = "force_set_default_hashes";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn create(
                    &self,
                    depth: ::core::primitive::u8,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    create,
                    DispatchError,
                > {
                    let call = create { depth };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn insert(
                    &self,
                    tree_id: ::core::primitive::u32,
                    leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    insert,
                    DispatchError,
                > {
                    let call = insert { tree_id, leaf };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_set_default_hashes(
                    &self,
                    default_hashes : :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_set_default_hashes,
                    DispatchError,
                > {
                    let call = force_set_default_hashes { default_hashes };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_mt::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct TreeCreation {
                pub tree_id: ::core::primitive::u32,
                pub who: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for TreeCreation {
                const PALLET: &'static str = "MerkleTreeBn254";
                const EVENT: &'static str = "TreeCreation";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct LeafInsertion { pub tree_id : :: core :: primitive :: u32 , pub leaf_index : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Event for LeafInsertion {
                const PALLET: &'static str = "MerkleTreeBn254";
                const EVENT: &'static str = "LeafInsertion";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Deposit;
            impl ::subxt::StorageEntry for Deposit {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "Deposit";
                type Value =
                    runtime_types::webb_primitives::types::DepositDetails<
                        ::subxt::sp_core::crypto::AccountId32,
                        ::core::primitive::u128,
                    >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextTreeId;
            impl ::subxt::StorageEntry for NextTreeId {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "NextTreeId";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Trees(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for Trees {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "Trees";
                type Value = runtime_types :: pallet_mt :: types :: TreeMetadata < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct DefaultHashes;
            impl ::subxt::StorageEntry for DefaultHashes {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "DefaultHashes";
                type Value = :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct Leaves(
                pub ::core::primitive::u32,
                pub ::core::primitive::u32,
            );
            impl ::subxt::StorageEntry for Leaves {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "Leaves";
                type Value = runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct NextRootIndex;
            impl ::subxt::StorageEntry for NextRootIndex {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "NextRootIndex";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct NextLeafIndex(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for NextLeafIndex {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "NextLeafIndex";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct CachedRoots(
                pub ::core::primitive::u32,
                pub ::core::primitive::u32,
            );
            impl ::subxt::StorageEntry for CachedRoots {
                const PALLET: &'static str = "MerkleTreeBn254";
                const STORAGE: &'static str = "CachedRoots";
                type Value = runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn deposit(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::webb_primitives::types::DepositDetails<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Deposit;
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn next_tree_id(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = NextTreeId;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn trees (& self , _0 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: pallet_mt :: types :: TreeMetadata < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > > , :: subxt :: BasicError >{
                    let entry = Trees(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn trees_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Trees>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn default_hashes (& self , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > , :: subxt :: BasicError >{
                    let entry = DefaultHashes;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }                pub async fn leaves (& self , _0 : :: core :: primitive :: u32 , _1 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: subxt :: BasicError >{
                    let entry = Leaves(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn leaves_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Leaves>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn next_root_index(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = NextRootIndex;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_leaf_index(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = NextLeafIndex(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn next_leaf_index_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, NextLeafIndex>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn cached_roots (& self , _0 : :: core :: primitive :: u32 , _1 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: subxt :: BasicError >{
                    let entry = CachedRoots(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn cached_roots_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, CachedRoots>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
    }
    pub mod linkable_tree_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct create {
                pub max_edges: ::core::primitive::u32,
                pub depth: ::core::primitive::u8,
            }
            impl ::subxt::Call for create {
                const PALLET: &'static str = "LinkableTreeBn254";
                const FUNCTION: &'static str = "create";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn create(
                    &self,
                    max_edges: ::core::primitive::u32,
                    depth: ::core::primitive::u8,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    create,
                    DispatchError,
                > {
                    let call = create { max_edges, depth };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_linkable_tree::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct LinkableTreeCreation {
                pub tree_id: ::core::primitive::u32,
            }
            impl ::subxt::Event for LinkableTreeCreation {
                const PALLET: &'static str = "LinkableTreeBn254";
                const EVENT: &'static str = "LinkableTreeCreation";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct MaxEdges(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for MaxEdges {
                const PALLET: &'static str = "LinkableTreeBn254";
                const STORAGE: &'static str = "MaxEdges";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct EdgeList(
                pub ::core::primitive::u32,
                pub ::core::primitive::u64,
            );
            impl ::subxt::StorageEntry for EdgeList {
                const PALLET: &'static str = "LinkableTreeBn254";
                const STORAGE: &'static str = "EdgeList";
                type Value = runtime_types :: pallet_linkable_tree :: types :: EdgeMetadata < :: core :: primitive :: u64 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: core :: primitive :: u32 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct LinkableTreeHasEdge(
                pub ::core::primitive::u32,
                pub ::core::primitive::u64,
            );
            impl ::subxt::StorageEntry for LinkableTreeHasEdge {
                const PALLET: &'static str = "LinkableTreeBn254";
                const STORAGE: &'static str = "LinkableTreeHasEdge";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct NeighborRoots(
                pub (::core::primitive::u32, ::core::primitive::u64),
                pub ::core::primitive::u32,
            );
            impl ::subxt::StorageEntry for NeighborRoots {
                const PALLET: &'static str = "LinkableTreeBn254";
                const STORAGE: &'static str = "NeighborRoots";
                type Value = runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct CurrentNeighborRootIndex(
                pub ::core::primitive::u32,
                pub ::core::primitive::u64,
            );
            impl ::subxt::StorageEntry for CurrentNeighborRootIndex {
                const PALLET: &'static str = "LinkableTreeBn254";
                const STORAGE: &'static str = "CurrentNeighborRootIndex";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn max_edges(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = MaxEdges(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn max_edges_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, MaxEdges>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn edge_list (& self , _0 : :: core :: primitive :: u32 , _1 : :: core :: primitive :: u64 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: pallet_linkable_tree :: types :: EdgeMetadata < :: core :: primitive :: u64 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: core :: primitive :: u32 > , :: subxt :: BasicError >{
                    let entry = EdgeList(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn edge_list_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, EdgeList>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn linkable_tree_has_edge(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::core::primitive::u64,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = LinkableTreeHasEdge(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn linkable_tree_has_edge_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, LinkableTreeHasEdge>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn neighbor_roots (& self , _0 : (:: core :: primitive :: u32 , :: core :: primitive :: u64 ,) , _1 : :: core :: primitive :: u32 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < :: core :: option :: Option < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > , :: subxt :: BasicError >{
                    let entry = NeighborRoots(_0, _1);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn neighbor_roots_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, NeighborRoots>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn current_neighbor_root_index(
                    &self,
                    _0: ::core::primitive::u32,
                    _1: ::core::primitive::u64,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = CurrentNeighborRootIndex(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn current_neighbor_root_index_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, CurrentNeighborRootIndex>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn chain_type(
                    &self,
                ) -> ::core::result::Result<
                    [::core::primitive::u8; 2usize],
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(&mut &[2u8, 1u8][..])?)
                }
                pub fn chain_identifier(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[56u8, 4u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn history_length(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[30u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod mixer_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct create {
                pub deposit_size: ::core::primitive::u128,
                pub depth: ::core::primitive::u8,
                pub asset: ::core::primitive::u32,
            }
            impl ::subxt::Call for create {
                const PALLET: &'static str = "MixerBn254";
                const FUNCTION: &'static str = "create";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct deposit { pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Call for deposit {
                const PALLET: &'static str = "MixerBn254";
                const FUNCTION: &'static str = "deposit";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct withdraw { pub id : :: core :: primitive :: u32 , pub proof_bytes : :: std :: vec :: Vec < :: core :: primitive :: u8 > , pub root : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , pub nullifier_hash : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , pub recipient : :: subxt :: sp_core :: crypto :: AccountId32 , pub relayer : :: subxt :: sp_core :: crypto :: AccountId32 , pub fee : :: core :: primitive :: u128 , pub refund : :: core :: primitive :: u128 , }
            impl ::subxt::Call for withdraw {
                const PALLET: &'static str = "MixerBn254";
                const FUNCTION: &'static str = "withdraw";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn create(
                    &self,
                    deposit_size: ::core::primitive::u128,
                    depth: ::core::primitive::u8,
                    asset: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    create,
                    DispatchError,
                > {
                    let call = create {
                        deposit_size,
                        depth,
                        asset,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn deposit(
                    &self,
                    tree_id: ::core::primitive::u32,
                    leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    deposit,
                    DispatchError,
                > {
                    let call = deposit { tree_id, leaf };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn withdraw(
                    &self,
                    id: ::core::primitive::u32,
                    proof_bytes: ::std::vec::Vec<::core::primitive::u8>,
                    root : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                    nullifier_hash : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                    recipient: ::subxt::sp_core::crypto::AccountId32,
                    relayer: ::subxt::sp_core::crypto::AccountId32,
                    fee: ::core::primitive::u128,
                    refund: ::core::primitive::u128,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    withdraw,
                    DispatchError,
                > {
                    let call = withdraw {
                        id,
                        proof_bytes,
                        root,
                        nullifier_hash,
                        recipient,
                        relayer,
                        fee,
                        refund,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_mixer::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct MixerCreation {
                pub tree_id: ::core::primitive::u32,
            }
            impl ::subxt::Event for MixerCreation {
                const PALLET: &'static str = "MixerBn254";
                const EVENT: &'static str = "MixerCreation";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Deposit { pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Event for Deposit {
                const PALLET: &'static str = "MixerBn254";
                const EVENT: &'static str = "Deposit";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Withdraw {
                pub tree_id: ::core::primitive::u32,
                pub recipient: ::subxt::sp_core::crypto::AccountId32,
            }
            impl ::subxt::Event for Withdraw {
                const PALLET: &'static str = "MixerBn254";
                const EVENT: &'static str = "Withdraw";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Mixers(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for Mixers {
                const PALLET: &'static str = "MixerBn254";
                const STORAGE: &'static str = "Mixers";
                type Value = runtime_types::pallet_mixer::types::MixerMetadata<
                    ::core::primitive::u128,
                    ::core::primitive::u32,
                >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct NullifierHashes (pub :: core :: primitive :: u32 , pub runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element) ;
            impl ::subxt::StorageEntry for NullifierHashes {
                const PALLET: &'static str = "MixerBn254";
                const STORAGE: &'static str = "NullifierHashes";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn mixers(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_mixer::types::MixerMetadata<
                            ::core::primitive::u128,
                            ::core::primitive::u32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Mixers(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn mixers_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Mixers>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn nullifier_hashes(
                    &self,
                    _0: ::core::primitive::u32,
                    _1 : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = NullifierHashes(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn nullifier_hashes_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, NullifierHashes>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn pallet_id(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::PalletId,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            112u8, 121u8, 47u8, 109u8, 105u8, 120u8, 101u8,
                            114u8,
                        ][..],
                    )?)
                }
                pub fn native_currency_id(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod anchor_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct create {
                pub deposit_size: ::core::primitive::u128,
                pub max_edges: ::core::primitive::u32,
                pub depth: ::core::primitive::u8,
                pub asset: ::core::primitive::u32,
            }
            impl ::subxt::Call for create {
                const PALLET: &'static str = "AnchorBn254";
                const FUNCTION: &'static str = "create";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct deposit { pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Call for deposit {
                const PALLET: &'static str = "AnchorBn254";
                const FUNCTION: &'static str = "deposit";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct deposit_and_update_linked_anchors { pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Call for deposit_and_update_linked_anchors {
                const PALLET: &'static str = "AnchorBn254";
                const FUNCTION: &'static str =
                    "deposit_and_update_linked_anchors";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct withdraw { pub id : :: core :: primitive :: u32 , pub proof_bytes : :: std :: vec :: Vec < :: core :: primitive :: u8 > , pub roots : :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > , pub nullifier_hash : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , pub recipient : :: subxt :: sp_core :: crypto :: AccountId32 , pub relayer : :: subxt :: sp_core :: crypto :: AccountId32 , pub fee : :: core :: primitive :: u128 , pub refund : :: core :: primitive :: u128 , pub commitment : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Call for withdraw {
                const PALLET: &'static str = "AnchorBn254";
                const FUNCTION: &'static str = "withdraw";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn create(
                    &self,
                    deposit_size: ::core::primitive::u128,
                    max_edges: ::core::primitive::u32,
                    depth: ::core::primitive::u8,
                    asset: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    create,
                    DispatchError,
                > {
                    let call = create {
                        deposit_size,
                        max_edges,
                        depth,
                        asset,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn deposit(
                    &self,
                    tree_id: ::core::primitive::u32,
                    leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    deposit,
                    DispatchError,
                > {
                    let call = deposit { tree_id, leaf };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn deposit_and_update_linked_anchors(
                    &self,
                    tree_id: ::core::primitive::u32,
                    leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    deposit_and_update_linked_anchors,
                    DispatchError,
                > {
                    let call =
                        deposit_and_update_linked_anchors { tree_id, leaf };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn withdraw(
                    &self,
                    id: ::core::primitive::u32,
                    proof_bytes: ::std::vec::Vec<::core::primitive::u8>,
                    roots : :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element >,
                    nullifier_hash : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                    recipient: ::subxt::sp_core::crypto::AccountId32,
                    relayer: ::subxt::sp_core::crypto::AccountId32,
                    fee: ::core::primitive::u128,
                    refund: ::core::primitive::u128,
                    commitment : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    withdraw,
                    DispatchError,
                > {
                    let call = withdraw {
                        id,
                        proof_bytes,
                        roots,
                        nullifier_hash,
                        recipient,
                        relayer,
                        fee,
                        refund,
                        commitment,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_anchor::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct AnchorCreation {
                pub tree_id: ::core::primitive::u32,
            }
            impl ::subxt::Event for AnchorCreation {
                const PALLET: &'static str = "AnchorBn254";
                const EVENT: &'static str = "AnchorCreation";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Withdraw {
                pub who: ::subxt::sp_core::crypto::AccountId32,
                pub amount: ::core::primitive::u128,
            }
            impl ::subxt::Event for Withdraw {
                const PALLET: &'static str = "AnchorBn254";
                const EVENT: &'static str = "Withdraw";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Refresh { pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Event for Refresh {
                const PALLET: &'static str = "AnchorBn254";
                const EVENT: &'static str = "Refresh";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Deposit { pub depositor : :: subxt :: sp_core :: crypto :: AccountId32 , pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , pub amount : :: core :: primitive :: u128 , }
            impl ::subxt::Event for Deposit {
                const PALLET: &'static str = "AnchorBn254";
                const EVENT: &'static str = "Deposit";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PostDeposit { pub depositor : :: subxt :: sp_core :: crypto :: AccountId32 , pub tree_id : :: core :: primitive :: u32 , pub leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , }
            impl ::subxt::Event for PostDeposit {
                const PALLET: &'static str = "AnchorBn254";
                const EVENT: &'static str = "PostDeposit";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Anchors(pub ::core::primitive::u32);
            impl ::subxt::StorageEntry for Anchors {
                const PALLET: &'static str = "AnchorBn254";
                const STORAGE: &'static str = "Anchors";
                type Value =
                    runtime_types::pallet_anchor::types::AnchorMetadata<
                        ::core::primitive::u128,
                        ::core::primitive::u32,
                    >;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct NullifierHashes (pub :: core :: primitive :: u32 , pub runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element) ;
            impl ::subxt::StorageEntry for NullifierHashes {
                const PALLET: &'static str = "AnchorBn254";
                const STORAGE: &'static str = "NullifierHashes";
                type Value = ::core::primitive::bool;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn anchors(
                    &self,
                    _0: ::core::primitive::u32,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        runtime_types::pallet_anchor::types::AnchorMetadata<
                            ::core::primitive::u128,
                            ::core::primitive::u32,
                        >,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Anchors(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn anchors_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Anchors>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn nullifier_hashes(
                    &self,
                    _0: ::core::primitive::u32,
                    _1 : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::bool,
                    ::subxt::BasicError,
                > {
                    let entry = NullifierHashes(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn nullifier_hashes_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, NullifierHashes>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn pallet_id(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::PalletId,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            112u8, 121u8, 47u8, 97u8, 110u8, 99u8, 104u8, 114u8,
                        ][..],
                    )?)
                }
                pub fn native_currency_id(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
            }
        }
    }
    pub mod anchor_handler_bn254 {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct execute_anchor_create_proposal {
                pub deposit_size: ::core::primitive::u128,
                pub src_chain_id: ::core::primitive::u64,
                pub r_id: [::core::primitive::u8; 32usize],
                pub max_edges: ::core::primitive::u32,
                pub tree_depth: ::core::primitive::u8,
                pub asset: ::core::primitive::u32,
            }
            impl ::subxt::Call for execute_anchor_create_proposal {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const FUNCTION: &'static str = "execute_anchor_create_proposal";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct execute_anchor_update_proposal { pub r_id : [:: core :: primitive :: u8 ; 32usize] , pub anchor_metadata : runtime_types :: pallet_linkable_tree :: types :: EdgeMetadata < :: core :: primitive :: u64 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: core :: primitive :: u32 > , }
            impl ::subxt::Call for execute_anchor_update_proposal {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const FUNCTION: &'static str = "execute_anchor_update_proposal";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn execute_anchor_create_proposal(
                    &self,
                    deposit_size: ::core::primitive::u128,
                    src_chain_id: ::core::primitive::u64,
                    r_id: [::core::primitive::u8; 32usize],
                    max_edges: ::core::primitive::u32,
                    tree_depth: ::core::primitive::u8,
                    asset: ::core::primitive::u32,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    execute_anchor_create_proposal,
                    DispatchError,
                > {
                    let call = execute_anchor_create_proposal {
                        deposit_size,
                        src_chain_id,
                        r_id,
                        max_edges,
                        tree_depth,
                        asset,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn execute_anchor_update_proposal(
                    &self,
                    r_id: [::core::primitive::u8; 32usize],
                    anchor_metadata : runtime_types :: pallet_linkable_tree :: types :: EdgeMetadata < :: core :: primitive :: u64 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: core :: primitive :: u32 >,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    execute_anchor_update_proposal,
                    DispatchError,
                > {
                    let call = execute_anchor_update_proposal {
                        r_id,
                        anchor_metadata,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_anchor_handler::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AnchorCreated;
            impl ::subxt::Event for AnchorCreated {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const EVENT: &'static str = "AnchorCreated";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AnchorEdgeAdded;
            impl ::subxt::Event for AnchorEdgeAdded {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const EVENT: &'static str = "AnchorEdgeAdded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AnchorEdgeUpdated;
            impl ::subxt::Event for AnchorEdgeUpdated {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const EVENT: &'static str = "AnchorEdgeUpdated";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct AnchorList(pub [::core::primitive::u8; 32usize]);
            impl ::subxt::StorageEntry for AnchorList {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const STORAGE: &'static str = "AnchorList";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct UpdateRecords(
                pub ::core::primitive::u64,
                pub ::core::primitive::u64,
            );
            impl ::subxt::StorageEntry for UpdateRecords {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const STORAGE: &'static str = "UpdateRecords";
                type Value = runtime_types :: pallet_anchor_handler :: types :: UpdateRecord < :: core :: primitive :: u32 , [:: core :: primitive :: u8 ; 32usize] , :: core :: primitive :: u64 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: core :: primitive :: u32 > ;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                        ::subxt::StorageMapKey::new(
                            &self.1,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct Counts(pub ::core::primitive::u64);
            impl ::subxt::StorageEntry for Counts {
                const PALLET: &'static str = "AnchorHandlerBn254";
                const STORAGE: &'static str = "Counts";
                type Value = ::core::primitive::u64;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_128Concat,
                        ),
                    ])
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn anchor_list(
                    &self,
                    _0: [::core::primitive::u8; 32usize],
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = AnchorList(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn anchor_list_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, AnchorList>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }                pub async fn update_records (& self , _0 : :: core :: primitive :: u64 , _1 : :: core :: primitive :: u64 , hash : :: core :: option :: Option < T :: Hash > ,) -> :: core :: result :: Result < runtime_types :: pallet_anchor_handler :: types :: UpdateRecord < :: core :: primitive :: u32 , [:: core :: primitive :: u8 ; 32usize] , :: core :: primitive :: u64 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: core :: primitive :: u32 > , :: subxt :: BasicError >{
                    let entry = UpdateRecords(_0, _1);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn update_records_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, UpdateRecords>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn counts(
                    &self,
                    _0: ::core::primitive::u64,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    let entry = Counts(_0);
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn counts_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Counts>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
            }
        }
    }
    pub mod bridge {
        use super::runtime_types;
        pub mod calls {
            use super::runtime_types;
            type DispatchError = runtime_types::sp_runtime::DispatchError;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_maintainer {
                pub message: ::std::vec::Vec<::core::primitive::u8>,
                pub signature: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for set_maintainer {
                const PALLET: &'static str = "Bridge";
                const FUNCTION: &'static str = "set_maintainer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct force_set_maintainer {
                pub new_maintainer: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for force_set_maintainer {
                const PALLET: &'static str = "Bridge";
                const FUNCTION: &'static str = "force_set_maintainer";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct set_resource {
                pub id: [::core::primitive::u8; 32usize],
                pub method: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for set_resource {
                const PALLET: &'static str = "Bridge";
                const FUNCTION: &'static str = "set_resource";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct remove_resource {
                pub id: [::core::primitive::u8; 32usize],
            }
            impl ::subxt::Call for remove_resource {
                const PALLET: &'static str = "Bridge";
                const FUNCTION: &'static str = "remove_resource";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct whitelist_chain {
                pub id: ::core::primitive::u64,
            }
            impl ::subxt::Call for whitelist_chain {
                const PALLET: &'static str = "Bridge";
                const FUNCTION: &'static str = "whitelist_chain";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct execute_proposal {
                pub src_id: ::core::primitive::u64,
                pub call: ::std::boxed::Box<
                    runtime_types::egg_standalone_runtime::Call,
                >,
                pub proposal_data: ::std::vec::Vec<::core::primitive::u8>,
                pub signature: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Call for execute_proposal {
                const PALLET: &'static str = "Bridge";
                const FUNCTION: &'static str = "execute_proposal";
            }
            pub struct TransactionApi<'a, T: ::subxt::Config, X, A> {
                client: &'a ::subxt::Client<T>,
                marker: ::core::marker::PhantomData<(X, A)>,
            }
            impl<'a, T, X, A> TransactionApi<'a, T, X, A>
            where
                T: ::subxt::Config,
                X: ::subxt::SignedExtra<T>,
                A: ::subxt::AccountData,
            {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self {
                        client,
                        marker: ::core::marker::PhantomData,
                    }
                }
                pub fn set_maintainer(
                    &self,
                    message: ::std::vec::Vec<::core::primitive::u8>,
                    signature: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_maintainer,
                    DispatchError,
                > {
                    let call = set_maintainer { message, signature };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn force_set_maintainer(
                    &self,
                    new_maintainer: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    force_set_maintainer,
                    DispatchError,
                > {
                    let call = force_set_maintainer { new_maintainer };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn set_resource(
                    &self,
                    id: [::core::primitive::u8; 32usize],
                    method: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    set_resource,
                    DispatchError,
                > {
                    let call = set_resource { id, method };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn remove_resource(
                    &self,
                    id: [::core::primitive::u8; 32usize],
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    remove_resource,
                    DispatchError,
                > {
                    let call = remove_resource { id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn whitelist_chain(
                    &self,
                    id: ::core::primitive::u64,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    whitelist_chain,
                    DispatchError,
                > {
                    let call = whitelist_chain { id };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
                pub fn execute_proposal(
                    &self,
                    src_id: ::core::primitive::u64,
                    call: runtime_types::egg_standalone_runtime::Call,
                    proposal_data: ::std::vec::Vec<::core::primitive::u8>,
                    signature: ::std::vec::Vec<::core::primitive::u8>,
                ) -> ::subxt::SubmittableExtrinsic<
                    'a,
                    T,
                    X,
                    A,
                    execute_proposal,
                    DispatchError,
                > {
                    let call = execute_proposal {
                        src_id,
                        call: ::std::boxed::Box::new(call),
                        proposal_data,
                        signature,
                    };
                    ::subxt::SubmittableExtrinsic::new(self.client, call)
                }
            }
        }
        pub type Event = runtime_types::pallet_signature_bridge::pallet::Event;
        pub mod events {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct MaintainerSet {
                pub old_maintainer: ::std::vec::Vec<::core::primitive::u8>,
                pub new_maintainer: ::std::vec::Vec<::core::primitive::u8>,
            }
            impl ::subxt::Event for MaintainerSet {
                const PALLET: &'static str = "Bridge";
                const EVENT: &'static str = "MaintainerSet";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct ChainWhitelisted {
                pub chain_id: ::core::primitive::u64,
            }
            impl ::subxt::Event for ChainWhitelisted {
                const PALLET: &'static str = "Bridge";
                const EVENT: &'static str = "ChainWhitelisted";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalApproved {
                pub chain_id: ::core::primitive::u64,
                pub proposal_nonce: ::core::primitive::u32,
            }
            impl ::subxt::Event for ProposalApproved {
                const PALLET: &'static str = "Bridge";
                const EVENT: &'static str = "ProposalApproved";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalSucceeded {
                pub chain_id: ::core::primitive::u64,
                pub proposal_nonce: ::core::primitive::u32,
            }
            impl ::subxt::Event for ProposalSucceeded {
                const PALLET: &'static str = "Bridge";
                const EVENT: &'static str = "ProposalSucceeded";
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ProposalFailed {
                pub chain_id: ::core::primitive::u64,
                pub proposal_nonce: ::core::primitive::u32,
            }
            impl ::subxt::Event for ProposalFailed {
                const PALLET: &'static str = "Bridge";
                const EVENT: &'static str = "ProposalFailed";
            }
        }
        pub mod storage {
            use super::runtime_types;
            pub struct Maintainer;
            impl ::subxt::StorageEntry for Maintainer {
                const PALLET: &'static str = "Bridge";
                const STORAGE: &'static str = "Maintainer";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct ChainNonces(pub ::core::primitive::u64);
            impl ::subxt::StorageEntry for ChainNonces {
                const PALLET: &'static str = "Bridge";
                const STORAGE: &'static str = "ChainNonces";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct Resources(pub [::core::primitive::u8; 32usize]);
            impl ::subxt::StorageEntry for Resources {
                const PALLET: &'static str = "Bridge";
                const STORAGE: &'static str = "Resources";
                type Value = ::std::vec::Vec<::core::primitive::u8>;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Map(vec![
                        ::subxt::StorageMapKey::new(
                            &self.0,
                            ::subxt::StorageHasher::Blake2_256,
                        ),
                    ])
                }
            }
            pub struct ProposalNonce;
            impl ::subxt::StorageEntry for ProposalNonce {
                const PALLET: &'static str = "Bridge";
                const STORAGE: &'static str = "ProposalNonce";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct MaintainerNonce;
            impl ::subxt::StorageEntry for MaintainerNonce {
                const PALLET: &'static str = "Bridge";
                const STORAGE: &'static str = "MaintainerNonce";
                type Value = ::core::primitive::u32;
                fn key(&self) -> ::subxt::StorageEntryKey {
                    ::subxt::StorageEntryKey::Plain
                }
            }
            pub struct StorageApi<'a, T: ::subxt::Config> {
                client: &'a ::subxt::Client<T>,
            }
            impl<'a, T: ::subxt::Config> StorageApi<'a, T> {
                pub fn new(client: &'a ::subxt::Client<T>) -> Self {
                    Self { client }
                }
                pub async fn maintainer(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::subxt::BasicError,
                > {
                    let entry = Maintainer;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn chain_nonces(
                    &self,
                    _0: ::core::primitive::u64,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<::core::primitive::u32>,
                    ::subxt::BasicError,
                > {
                    let entry = ChainNonces(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn chain_nonces_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, ChainNonces>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn resources(
                    &self,
                    _0: [::core::primitive::u8; 32usize],
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::option::Option<
                        ::std::vec::Vec<::core::primitive::u8>,
                    >,
                    ::subxt::BasicError,
                > {
                    let entry = Resources(_0);
                    self.client.storage().fetch(&entry, hash).await
                }
                pub async fn resources_iter(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::subxt::KeyIter<'a, T, Resources>,
                    ::subxt::BasicError,
                > {
                    self.client.storage().iter(hash).await
                }
                pub async fn proposal_nonce(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = ProposalNonce;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
                pub async fn maintainer_nonce(
                    &self,
                    hash: ::core::option::Option<T::Hash>,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    let entry = MaintainerNonce;
                    self.client.storage().fetch_or_default(&entry, hash).await
                }
            }
        }
        pub mod constants {
            use super::runtime_types;
            pub struct ConstantsApi;
            impl ConstantsApi {
                pub fn chain_identifier(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u64,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[56u8, 4u8, 0u8, 0u8, 0u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn chain_type(
                    &self,
                ) -> ::core::result::Result<
                    [::core::primitive::u8; 2usize],
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(&mut &[2u8, 1u8][..])?)
                }
                pub fn proposal_lifetime(
                    &self,
                ) -> ::core::result::Result<
                    ::core::primitive::u32,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[50u8, 0u8, 0u8, 0u8][..],
                    )?)
                }
                pub fn bridge_account_id(
                    &self,
                ) -> ::core::result::Result<
                    runtime_types::frame_support::PalletId,
                    ::subxt::BasicError,
                > {
                    Ok(::subxt::codec::Decode::decode(
                        &mut &[
                            100u8, 119u8, 47u8, 98u8, 114u8, 105u8, 100u8,
                            103u8,
                        ][..],
                    )?)
                }
            }
        }
    }
    pub mod runtime_types {
        use super::runtime_types;
        pub mod dkg_runtime_primitives {
            use super::runtime_types;
            pub mod crypto {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Public(pub runtime_types::sp_core::ecdsa::Public);
            }
            pub mod proposal {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum DKGPayloadKey {
                    #[codec(index = 0)]
                    EVMProposal(runtime_types::webb_proposals::nonce::Nonce),
                    #[codec(index = 1)]
                    RefreshVote(runtime_types::webb_proposals::nonce::Nonce),
                    #[codec(index = 2)]
                    ProposerSetUpdateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 3)]
                    AnchorCreateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 4)]
                    AnchorUpdateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 5)]
                    TokenAddProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 6)]
                    TokenRemoveProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 7)]
                    WrappingFeeUpdateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 8)]
                    ResourceIdUpdateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 9)]
                    RescueTokensProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 10)]
                    MaxDepositLimitUpdateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 11)]
                    MinWithdrawalLimitUpdateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 12)]
                    SetVerifierProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 13)]
                    SetTreasuryHandlerProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                    #[codec(index = 14)]
                    FeeRecipientUpdateProposal(
                        runtime_types::webb_proposals::nonce::Nonce,
                    ),
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Proposal {
                    # [codec (index = 0)] Signed { kind : runtime_types :: dkg_runtime_primitives :: proposal :: ProposalKind , data : :: std :: vec :: Vec < :: core :: primitive :: u8 > , signature : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 1)] Unsigned { kind : runtime_types :: dkg_runtime_primitives :: proposal :: ProposalKind , data : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum ProposalKind {
                    #[codec(index = 0)]
                    Refresh,
                    #[codec(index = 1)]
                    ProposerSetUpdate,
                    #[codec(index = 2)]
                    EVM,
                    #[codec(index = 3)]
                    AnchorCreate,
                    #[codec(index = 4)]
                    AnchorUpdate,
                    #[codec(index = 5)]
                    TokenAdd,
                    #[codec(index = 6)]
                    TokenRemove,
                    #[codec(index = 7)]
                    WrappingFeeUpdate,
                    #[codec(index = 8)]
                    ResourceIdUpdate,
                    #[codec(index = 9)]
                    RescueTokens,
                    #[codec(index = 10)]
                    MaxDepositLimitUpdate,
                    #[codec(index = 11)]
                    MinWithdrawalLimitUpdate,
                    #[codec(index = 12)]
                    SetVerifier,
                    #[codec(index = 13)]
                    SetTreasuryHandler,
                    #[codec(index = 14)]
                    FeeRecipientUpdate,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct RefreshProposalSigned {
                    pub nonce: runtime_types::webb_proposals::nonce::Nonce,
                    pub signature: ::std::vec::Vec<::core::primitive::u8>,
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AggregatedMisbehaviourReports<_0> {
                pub misbehaviour_type:
                    runtime_types::dkg_runtime_primitives::MisbehaviourType,
                pub round_id: ::core::primitive::u64,
                pub offender: _0,
                pub reporters: ::std::vec::Vec<_0>,
                pub signatures:
                    ::std::vec::Vec<::std::vec::Vec<::core::primitive::u8>>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AggregatedPublicKeys {
                pub keys_and_signatures: ::std::vec::Vec<(
                    ::std::vec::Vec<::core::primitive::u8>,
                    ::std::vec::Vec<::core::primitive::u8>,
                )>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum MisbehaviourType {
                #[codec(index = 0)]
                Keygen,
                #[codec(index = 1)]
                Sign,
            }
        }
        pub mod egg_standalone_runtime {
            use super::runtime_types;
            pub mod opaque {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct SessionKeys { pub aura : runtime_types :: sp_consensus_aura :: sr25519 :: app_sr25519 :: Public , pub grandpa : runtime_types :: sp_finality_grandpa :: app :: Public , pub dkg : runtime_types :: dkg_runtime_primitives :: crypto :: Public , }
            }
            pub mod protocol_substrate_config {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Element(pub [::core::primitive::u8; 32usize]);
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Call {
                # [codec (index = 0)] System (runtime_types :: frame_system :: pallet :: Call ,) , # [codec (index = 1)] Timestamp (runtime_types :: pallet_timestamp :: pallet :: Call ,) , # [codec (index = 2)] Sudo (runtime_types :: pallet_sudo :: pallet :: Call ,) , # [codec (index = 4)] Balances (runtime_types :: pallet_balances :: pallet :: Call ,) , # [codec (index = 6)] Authorship (runtime_types :: pallet_authorship :: pallet :: Call ,) , # [codec (index = 8)] Grandpa (runtime_types :: pallet_grandpa :: pallet :: Call ,) , # [codec (index = 9)] Democracy (runtime_types :: pallet_democracy :: pallet :: Call ,) , # [codec (index = 10)] Council (runtime_types :: pallet_collective :: pallet :: Call ,) , # [codec (index = 11)] Elections (runtime_types :: pallet_elections_phragmen :: pallet :: Call ,) , # [codec (index = 12)] ElectionProviderMultiPhase (runtime_types :: pallet_election_provider_multi_phase :: pallet :: Call ,) , # [codec (index = 13)] Staking (runtime_types :: pallet_staking :: pallet :: pallet :: Call ,) , # [codec (index = 14)] Session (runtime_types :: pallet_session :: pallet :: Call ,) , # [codec (index = 16)] Treasury (runtime_types :: pallet_treasury :: pallet :: Call ,) , # [codec (index = 17)] Bounties (runtime_types :: pallet_bounties :: pallet :: Call ,) , # [codec (index = 18)] ChildBounties (runtime_types :: pallet_child_bounties :: pallet :: Call ,) , # [codec (index = 19)] BagsList (runtime_types :: pallet_bags_list :: pallet :: Call ,) , # [codec (index = 20)] Scheduler (runtime_types :: pallet_scheduler :: pallet :: Call ,) , # [codec (index = 21)] Preimage (runtime_types :: pallet_preimage :: pallet :: Call ,) , # [codec (index = 23)] DKG (runtime_types :: pallet_dkg_metadata :: pallet :: Call ,) , # [codec (index = 24)] DKGProposals (runtime_types :: pallet_dkg_proposals :: pallet :: Call ,) , # [codec (index = 25)] DKGProposalHandler (runtime_types :: pallet_dkg_proposal_handler :: pallet :: Call ,) , # [codec (index = 26)] HasherBn254 (runtime_types :: pallet_hasher :: pallet :: Call ,) , # [codec (index = 27)] AssetRegistry (runtime_types :: pallet_asset_registry :: pallet :: Call ,) , # [codec (index = 28)] Currencies (runtime_types :: orml_currencies :: module :: Call ,) , # [codec (index = 29)] Tokens (runtime_types :: orml_tokens :: module :: Call ,) , # [codec (index = 30)] TokenWrapper (runtime_types :: pallet_token_wrapper :: pallet :: Call ,) , # [codec (index = 31)] MixerVerifierBn254 (runtime_types :: pallet_verifier :: pallet :: Call ,) , # [codec (index = 32)] AnchorVerifierBn254 (runtime_types :: pallet_verifier :: pallet :: Call ,) , # [codec (index = 33)] MerkleTreeBn254 (runtime_types :: pallet_mt :: pallet :: Call ,) , # [codec (index = 34)] LinkableTreeBn254 (runtime_types :: pallet_linkable_tree :: pallet :: Call ,) , # [codec (index = 35)] MixerBn254 (runtime_types :: pallet_mixer :: pallet :: Call ,) , # [codec (index = 36)] AnchorBn254 (runtime_types :: pallet_anchor :: pallet :: Call ,) , # [codec (index = 37)] AnchorHandlerBn254 (runtime_types :: pallet_anchor_handler :: pallet :: Call ,) , # [codec (index = 38)] Bridge (runtime_types :: pallet_signature_bridge :: pallet :: Call ,) , }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Event {
                # [codec (index = 0)] System (runtime_types :: frame_system :: pallet :: Event ,) , # [codec (index = 2)] Sudo (runtime_types :: pallet_sudo :: pallet :: Event ,) , # [codec (index = 4)] Balances (runtime_types :: pallet_balances :: pallet :: Event ,) , # [codec (index = 8)] Grandpa (runtime_types :: pallet_grandpa :: pallet :: Event ,) , # [codec (index = 9)] Democracy (runtime_types :: pallet_democracy :: pallet :: Event ,) , # [codec (index = 10)] Council (runtime_types :: pallet_collective :: pallet :: Event ,) , # [codec (index = 11)] Elections (runtime_types :: pallet_elections_phragmen :: pallet :: Event ,) , # [codec (index = 12)] ElectionProviderMultiPhase (runtime_types :: pallet_election_provider_multi_phase :: pallet :: Event ,) , # [codec (index = 13)] Staking (runtime_types :: pallet_staking :: pallet :: pallet :: Event ,) , # [codec (index = 14)] Session (runtime_types :: pallet_session :: pallet :: Event ,) , # [codec (index = 16)] Treasury (runtime_types :: pallet_treasury :: pallet :: Event ,) , # [codec (index = 17)] Bounties (runtime_types :: pallet_bounties :: pallet :: Event ,) , # [codec (index = 18)] ChildBounties (runtime_types :: pallet_child_bounties :: pallet :: Event ,) , # [codec (index = 19)] BagsList (runtime_types :: pallet_bags_list :: pallet :: Event ,) , # [codec (index = 20)] Scheduler (runtime_types :: pallet_scheduler :: pallet :: Event ,) , # [codec (index = 21)] Preimage (runtime_types :: pallet_preimage :: pallet :: Event ,) , # [codec (index = 22)] Offences (runtime_types :: pallet_offences :: pallet :: Event ,) , # [codec (index = 23)] DKG (runtime_types :: pallet_dkg_metadata :: pallet :: Event ,) , # [codec (index = 24)] DKGProposals (runtime_types :: pallet_dkg_proposals :: pallet :: Event ,) , # [codec (index = 25)] DKGProposalHandler (runtime_types :: pallet_dkg_proposal_handler :: pallet :: Event ,) , # [codec (index = 26)] HasherBn254 (runtime_types :: pallet_hasher :: pallet :: Event ,) , # [codec (index = 27)] AssetRegistry (runtime_types :: pallet_asset_registry :: pallet :: Event ,) , # [codec (index = 28)] Currencies (runtime_types :: orml_currencies :: module :: Event ,) , # [codec (index = 29)] Tokens (runtime_types :: orml_tokens :: module :: Event ,) , # [codec (index = 30)] TokenWrapper (runtime_types :: pallet_token_wrapper :: pallet :: Event ,) , # [codec (index = 31)] MixerVerifierBn254 (runtime_types :: pallet_verifier :: pallet :: Event ,) , # [codec (index = 32)] AnchorVerifierBn254 (runtime_types :: pallet_verifier :: pallet :: Event ,) , # [codec (index = 33)] MerkleTreeBn254 (runtime_types :: pallet_mt :: pallet :: Event ,) , # [codec (index = 34)] LinkableTreeBn254 (runtime_types :: pallet_linkable_tree :: pallet :: Event ,) , # [codec (index = 35)] MixerBn254 (runtime_types :: pallet_mixer :: pallet :: Event ,) , # [codec (index = 36)] AnchorBn254 (runtime_types :: pallet_anchor :: pallet :: Event ,) , # [codec (index = 37)] AnchorHandlerBn254 (runtime_types :: pallet_anchor_handler :: pallet :: Event ,) , # [codec (index = 38)] Bridge (runtime_types :: pallet_signature_bridge :: pallet :: Event ,) , }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct NposSolution16 {
                pub votes1: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    ::core::primitive::u16,
                )>,
                pub votes2: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    (
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ),
                    ::core::primitive::u16,
                )>,
                pub votes3: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 2usize],
                    ::core::primitive::u16,
                )>,
                pub votes4: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 3usize],
                    ::core::primitive::u16,
                )>,
                pub votes5: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 4usize],
                    ::core::primitive::u16,
                )>,
                pub votes6: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 5usize],
                    ::core::primitive::u16,
                )>,
                pub votes7: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 6usize],
                    ::core::primitive::u16,
                )>,
                pub votes8: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 7usize],
                    ::core::primitive::u16,
                )>,
                pub votes9: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 8usize],
                    ::core::primitive::u16,
                )>,
                pub votes10: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 9usize],
                    ::core::primitive::u16,
                )>,
                pub votes11: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 10usize],
                    ::core::primitive::u16,
                )>,
                pub votes12: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 11usize],
                    ::core::primitive::u16,
                )>,
                pub votes13: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 12usize],
                    ::core::primitive::u16,
                )>,
                pub votes14: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 13usize],
                    ::core::primitive::u16,
                )>,
                pub votes15: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 14usize],
                    ::core::primitive::u16,
                )>,
                pub votes16: ::std::vec::Vec<(
                    ::core::primitive::u32,
                    [(
                        ::core::primitive::u16,
                        runtime_types::sp_arithmetic::per_things::PerU16,
                    ); 15usize],
                    ::core::primitive::u16,
                )>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum OriginCaller {
                #[codec(index = 0)]
                system(
                    runtime_types::frame_support::dispatch::RawOrigin<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                ),
                #[codec(index = 10)]
                Council(
                    runtime_types::pallet_collective::RawOrigin<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                ),
                #[codec(index = 2)]
                Void(runtime_types::sp_core::Void),
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Runtime;
        }
        pub mod finality_grandpa {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Equivocation<_0, _1, _2> {
                pub round_number: ::core::primitive::u64,
                pub identity: _0,
                pub first: (_1, _2),
                pub second: (_1, _2),
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Precommit<_0, _1> {
                pub target_hash: _0,
                pub target_number: _1,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Prevote<_0, _1> {
                pub target_hash: _0,
                pub target_number: _1,
            }
        }
        pub mod frame_support {
            use super::runtime_types;
            pub mod dispatch {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum RawOrigin<_0> {
                    #[codec(index = 0)]
                    Root,
                    #[codec(index = 1)]
                    Signed(_0),
                    #[codec(index = 2)]
                    None,
                }
            }
            pub mod storage {
                use super::runtime_types;
                pub mod bounded_btree_map {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct BoundedBTreeMap<_0, _1>(
                        pub ::std::collections::BTreeMap<_0, _1>,
                    );
                }
                pub mod bounded_vec {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct BoundedVec<_0>(pub ::std::vec::Vec<_0>);
                }
                pub mod weak_bounded_vec {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct WeakBoundedVec<_0>(pub ::std::vec::Vec<_0>);
                }
            }
            pub mod traits {
                use super::runtime_types;
                pub mod schedule {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub enum LookupError {
                        #[codec(index = 0)]
                        Unknown,
                        #[codec(index = 1)]
                        BadFormat,
                    }
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub enum MaybeHashed<_0, _1> {
                        #[codec(index = 0)]
                        Value(_0),
                        #[codec(index = 1)]
                        Hash(_1),
                    }
                }
                pub mod tokens {
                    use super::runtime_types;
                    pub mod misc {
                        use super::runtime_types;
                        #[derive(
                            :: subxt :: codec :: Encode,
                            :: subxt :: codec :: Decode,
                            Debug,
                            Eq,
                            PartialEq,
                            Clone,
                        )]
                        pub enum BalanceStatus {
                            #[codec(index = 0)]
                            Free,
                            #[codec(index = 1)]
                            Reserved,
                        }
                    }
                }
            }
            pub mod weights {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum DispatchClass {
                    #[codec(index = 0)]
                    Normal,
                    #[codec(index = 1)]
                    Operational,
                    #[codec(index = 2)]
                    Mandatory,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct DispatchInfo {
                    pub weight: ::core::primitive::u64,
                    pub class:
                        runtime_types::frame_support::weights::DispatchClass,
                    pub pays_fee: runtime_types::frame_support::weights::Pays,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Pays {
                    #[codec(index = 0)]
                    Yes,
                    #[codec(index = 1)]
                    No,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct PerDispatchClass<_0> {
                    pub normal: _0,
                    pub operational: _0,
                    pub mandatory: _0,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct RuntimeDbWeight {
                    pub read: ::core::primitive::u64,
                    pub write: ::core::primitive::u64,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct WeightToFeeCoefficient<_0> {
                    pub coeff_integer: _0,
                    pub coeff_frac:
                        runtime_types::sp_arithmetic::per_things::Perbill,
                    pub negative: ::core::primitive::bool,
                    pub degree: ::core::primitive::u8,
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct PalletId(pub [::core::primitive::u8; 8usize]);
        }
        pub mod frame_system {
            use super::runtime_types;
            pub mod extensions {
                use super::runtime_types;
                pub mod check_genesis {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct CheckGenesis;
                }
                pub mod check_mortality {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct CheckMortality(
                        pub runtime_types::sp_runtime::generic::era::Era,
                    );
                }
                pub mod check_nonce {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct CheckNonce(
                        #[codec(compact)] pub ::core::primitive::u32,
                    );
                }
                pub mod check_spec_version {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct CheckSpecVersion;
                }
                pub mod check_tx_version {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct CheckTxVersion;
                }
                pub mod check_weight {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct CheckWeight;
                }
            }
            pub mod limits {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct BlockLength {
                    pub max:
                        runtime_types::frame_support::weights::PerDispatchClass<
                            ::core::primitive::u32,
                        >,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct BlockWeights { pub base_block : :: core :: primitive :: u64 , pub max_block : :: core :: primitive :: u64 , pub per_class : runtime_types :: frame_support :: weights :: PerDispatchClass < runtime_types :: frame_system :: limits :: WeightsPerClass > , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct WeightsPerClass {
                    pub base_extrinsic: ::core::primitive::u64,
                    pub max_extrinsic:
                        ::core::option::Option<::core::primitive::u64>,
                    pub max_total:
                        ::core::option::Option<::core::primitive::u64>,
                    pub reserved:
                        ::core::option::Option<::core::primitive::u64>,
                }
            }
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    fill_block {
                        ratio:
                            runtime_types::sp_arithmetic::per_things::Perbill,
                    },
                    #[codec(index = 1)]
                    remark {
                        remark: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 2)]
                    set_heap_pages { pages: ::core::primitive::u64 },
                    #[codec(index = 3)]
                    set_code {
                        code: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 4)]
                    set_code_without_checks {
                        code: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 5)]
                    set_storage {
                        items: ::std::vec::Vec<(
                            ::std::vec::Vec<::core::primitive::u8>,
                            ::std::vec::Vec<::core::primitive::u8>,
                        )>,
                    },
                    #[codec(index = 6)]
                    kill_storage {
                        keys: ::std::vec::Vec<
                            ::std::vec::Vec<::core::primitive::u8>,
                        >,
                    },
                    #[codec(index = 7)]
                    kill_prefix {
                        prefix: ::std::vec::Vec<::core::primitive::u8>,
                        subkeys: ::core::primitive::u32,
                    },
                    #[codec(index = 8)]
                    remark_with_event {
                        remark: ::std::vec::Vec<::core::primitive::u8>,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidSpecName,
                    #[codec(index = 1)]
                    SpecVersionNeedsToIncrease,
                    #[codec(index = 2)]
                    FailedToExtractRuntimeVersion,
                    #[codec(index = 3)]
                    NonDefaultComposite,
                    #[codec(index = 4)]
                    NonZeroRefCount,
                    #[codec(index = 5)]
                    CallFiltered,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    ExtrinsicSuccess {
                        dispatch_info:
                            runtime_types::frame_support::weights::DispatchInfo,
                    },
                    #[codec(index = 1)]
                    ExtrinsicFailed {
                        dispatch_error:
                            runtime_types::sp_runtime::DispatchError,
                        dispatch_info:
                            runtime_types::frame_support::weights::DispatchInfo,
                    },
                    #[codec(index = 2)]
                    CodeUpdated,
                    #[codec(index = 3)]
                    NewAccount {
                        account: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 4)]
                    KilledAccount {
                        account: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 5)]
                    Remarked {
                        sender: ::subxt::sp_core::crypto::AccountId32,
                        hash: ::subxt::sp_core::H256,
                    },
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AccountInfo<_0, _1> {
                pub nonce: _0,
                pub consumers: _0,
                pub providers: _0,
                pub sufficients: _0,
                pub data: _1,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct EventRecord<_0, _1> {
                pub phase: runtime_types::frame_system::Phase,
                pub event: _0,
                pub topics: ::std::vec::Vec<_1>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct LastRuntimeUpgradeInfo {
                #[codec(compact)]
                pub spec_version: ::core::primitive::u32,
                pub spec_name: ::std::string::String,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Phase {
                #[codec(index = 0)]
                ApplyExtrinsic(::core::primitive::u32),
                #[codec(index = 1)]
                Finalization,
                #[codec(index = 2)]
                Initialization,
            }
        }
        pub mod orml_currencies {
            use super::runtime_types;
            pub mod module {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    transfer {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        currency_id: ::core::primitive::u32,
                        #[codec(compact)]
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 1)]
                    transfer_native_currency {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        #[codec(compact)]
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 2)]
                    update_balance {
                        who: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        currency_id: ::core::primitive::u32,
                        amount: ::core::primitive::i128,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    AmountIntoBalanceFailed,
                    #[codec(index = 1)]
                    BalanceTooLow,
                    #[codec(index = 2)]
                    DepositFailed,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Transferred {
                        currency_id: ::core::primitive::u32,
                        from: ::subxt::sp_core::crypto::AccountId32,
                        to: ::subxt::sp_core::crypto::AccountId32,
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 1)]
                    BalanceUpdated {
                        currency_id: ::core::primitive::u32,
                        who: ::subxt::sp_core::crypto::AccountId32,
                        amount: ::core::primitive::i128,
                    },
                    #[codec(index = 2)]
                    Deposited {
                        currency_id: ::core::primitive::u32,
                        who: ::subxt::sp_core::crypto::AccountId32,
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 3)]
                    Withdrawn {
                        currency_id: ::core::primitive::u32,
                        who: ::subxt::sp_core::crypto::AccountId32,
                        amount: ::core::primitive::u128,
                    },
                }
            }
        }
        pub mod orml_tokens {
            use super::runtime_types;
            pub mod module {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    transfer {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        currency_id: ::core::primitive::u32,
                        #[codec(compact)]
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 1)]
                    transfer_all {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        currency_id: ::core::primitive::u32,
                        keep_alive: ::core::primitive::bool,
                    },
                    #[codec(index = 2)]
                    transfer_keep_alive {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        currency_id: ::core::primitive::u32,
                        #[codec(compact)]
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 3)]
                    force_transfer {
                        source: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        currency_id: ::core::primitive::u32,
                        #[codec(compact)]
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 4)]
                    set_balance {
                        who: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        currency_id: ::core::primitive::u32,
                        #[codec(compact)]
                        new_free: ::core::primitive::u128,
                        #[codec(compact)]
                        new_reserved: ::core::primitive::u128,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    BalanceTooLow,
                    #[codec(index = 1)]
                    AmountIntoBalanceFailed,
                    #[codec(index = 2)]
                    LiquidityRestrictions,
                    #[codec(index = 3)]
                    MaxLocksExceeded,
                    #[codec(index = 4)]
                    KeepAlive,
                    #[codec(index = 5)]
                    ExistentialDeposit,
                    #[codec(index = 6)]
                    DeadAccount,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] Endowed { currency_id : :: core :: primitive :: u32 , who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 1)] DustLost { currency_id : :: core :: primitive :: u32 , who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 2)] Transfer { currency_id : :: core :: primitive :: u32 , from : :: subxt :: sp_core :: crypto :: AccountId32 , to : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 3)] Reserved { currency_id : :: core :: primitive :: u32 , who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 4)] Unreserved { currency_id : :: core :: primitive :: u32 , who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 5)] RepatriatedReserve { currency_id : :: core :: primitive :: u32 , from : :: subxt :: sp_core :: crypto :: AccountId32 , to : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , status : runtime_types :: frame_support :: traits :: tokens :: misc :: BalanceStatus , } , # [codec (index = 6)] BalanceSet { currency_id : :: core :: primitive :: u32 , who : :: subxt :: sp_core :: crypto :: AccountId32 , free : :: core :: primitive :: u128 , reserved : :: core :: primitive :: u128 , } , }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AccountData<_0> {
                pub free: _0,
                pub reserved: _0,
                pub frozen: _0,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BalanceLock<_0> {
                pub id: [::core::primitive::u8; 8usize],
                pub amount: _0,
            }
        }
        pub mod pallet_anchor {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] create { deposit_size : :: core :: primitive :: u128 , max_edges : :: core :: primitive :: u32 , depth : :: core :: primitive :: u8 , asset : :: core :: primitive :: u32 , } , # [codec (index = 1)] deposit { tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , # [codec (index = 2)] deposit_and_update_linked_anchors { tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , # [codec (index = 3)] withdraw { id : :: core :: primitive :: u32 , proof_bytes : :: std :: vec :: Vec < :: core :: primitive :: u8 > , roots : :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > , nullifier_hash : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , recipient : :: subxt :: sp_core :: crypto :: AccountId32 , relayer : :: subxt :: sp_core :: crypto :: AccountId32 , fee : :: core :: primitive :: u128 , refund : :: core :: primitive :: u128 , commitment : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidMerkleRoots,
                    #[codec(index = 1)]
                    UnknownRoot,
                    #[codec(index = 2)]
                    InvalidWithdrawProof,
                    #[codec(index = 3)]
                    NoAnchorFound,
                    #[codec(index = 4)]
                    InvalidArbitraryData,
                    #[codec(index = 5)]
                    AlreadyRevealedNullifier,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] AnchorCreation { tree_id : :: core :: primitive :: u32 , } , # [codec (index = 1)] Withdraw { who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 2)] Refresh { tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , # [codec (index = 3)] Deposit { depositor : :: subxt :: sp_core :: crypto :: AccountId32 , tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , amount : :: core :: primitive :: u128 , } , # [codec (index = 4)] PostDeposit { depositor : :: subxt :: sp_core :: crypto :: AccountId32 , tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct AnchorMetadata<_0, _1> {
                    pub deposit_size: _0,
                    pub asset: _1,
                }
            }
        }
        pub mod pallet_anchor_handler {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] execute_anchor_create_proposal { deposit_size : :: core :: primitive :: u128 , src_chain_id : :: core :: primitive :: u64 , r_id : [:: core :: primitive :: u8 ; 32usize] , max_edges : :: core :: primitive :: u32 , tree_depth : :: core :: primitive :: u8 , asset : :: core :: primitive :: u32 , } , # [codec (index = 1)] execute_anchor_update_proposal { r_id : [:: core :: primitive :: u8 ; 32usize] , anchor_metadata : runtime_types :: pallet_linkable_tree :: types :: EdgeMetadata < :: core :: primitive :: u64 , runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , :: core :: primitive :: u32 > , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidPermissions,
                    #[codec(index = 1)]
                    ResourceIsAlreadyAnchored,
                    #[codec(index = 2)]
                    AnchorHandlerNotFound,
                    #[codec(index = 3)]
                    SourceChainIdNotFound,
                    #[codec(index = 4)]
                    StorageOverflow,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    AnchorCreated,
                    #[codec(index = 1)]
                    AnchorEdgeAdded,
                    #[codec(index = 2)]
                    AnchorEdgeUpdated,
                }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct UpdateRecord < _0 , _1 , _2 , _3 , _4 > { pub tree_id : _0 , pub resource_id : _1 , pub edge_metadata : runtime_types :: pallet_linkable_tree :: types :: EdgeMetadata < _2 , _3 , _0 > , # [codec (skip)] pub __subxt_unused_type_params : :: core :: marker :: PhantomData < _4 > }
            }
        }
        pub mod pallet_asset_registry {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] register { name : :: std :: vec :: Vec < :: core :: primitive :: u8 > , asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 > , existential_deposit : :: core :: primitive :: u128 , } , # [codec (index = 1)] update { asset_id : :: core :: primitive :: u32 , name : :: std :: vec :: Vec < :: core :: primitive :: u8 > , asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 > , existential_deposit : :: core :: option :: Option < :: core :: primitive :: u128 > , } , # [codec (index = 2)] set_metadata { asset_id : :: core :: primitive :: u32 , symbol : :: std :: vec :: Vec < :: core :: primitive :: u8 > , decimals : :: core :: primitive :: u8 , } , # [codec (index = 3)] set_location { asset_id : :: core :: primitive :: u32 , location : () , } , # [codec (index = 4)] add_asset_to_pool { pool : :: std :: vec :: Vec < :: core :: primitive :: u8 > , asset_id : :: core :: primitive :: u32 , } , # [codec (index = 5)] delete_asset_from_pool { pool : :: std :: vec :: Vec < :: core :: primitive :: u8 > , asset_id : :: core :: primitive :: u32 , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    NoIdAvailable,
                    #[codec(index = 1)]
                    AssetNotFound,
                    #[codec(index = 2)]
                    TooLong,
                    #[codec(index = 3)]
                    AssetNotRegistered,
                    #[codec(index = 4)]
                    AssetAlreadyRegistered,
                    #[codec(index = 5)]
                    InvalidSharedAssetLen,
                    #[codec(index = 6)]
                    AssetExistsInPool,
                    #[codec(index = 7)]
                    AssetNotFoundInPool,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] Registered { asset_id : :: core :: primitive :: u32 , name : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > , asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 > , } , # [codec (index = 1)] Updated { asset_id : :: core :: primitive :: u32 , name : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > , asset_type : runtime_types :: pallet_asset_registry :: types :: AssetType < :: core :: primitive :: u32 > , } , # [codec (index = 2)] MetadataSet { asset_id : :: core :: primitive :: u32 , symbol : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: core :: primitive :: u8 > , decimals : :: core :: primitive :: u8 , } , # [codec (index = 3)] LocationSet { asset_id : :: core :: primitive :: u32 , location : () , } , }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct AssetDetails<_0, _1, _2> {
                    pub name: _2,
                    pub asset_type:
                        runtime_types::pallet_asset_registry::types::AssetType<
                            _0,
                        >,
                    pub existential_deposit: _1,
                    pub locked: ::core::primitive::bool,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct AssetMetadata<_0> {
                    pub symbol: _0,
                    pub decimals: ::core::primitive::u8,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum AssetType<_0> {
                    #[codec(index = 0)]
                    Token,
                    #[codec(index = 1)]
                    PoolShare(::std::vec::Vec<_0>),
                }
            }
        }
        pub mod pallet_authorship {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    set_uncles {
                        new_uncles: ::std::vec::Vec<
                            runtime_types::sp_runtime::generic::header::Header<
                                ::core::primitive::u32,
                                runtime_types::sp_runtime::traits::BlakeTwo256,
                            >,
                        >,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidUncleParent,
                    #[codec(index = 1)]
                    UnclesAlreadySet,
                    #[codec(index = 2)]
                    TooManyUncles,
                    #[codec(index = 3)]
                    GenesisUncle,
                    #[codec(index = 4)]
                    TooHighUncle,
                    #[codec(index = 5)]
                    UncleAlreadyIncluded,
                    #[codec(index = 6)]
                    OldUncle,
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum UncleEntryItem<_0, _1, _2> {
                #[codec(index = 0)]
                InclusionHeight(_0),
                #[codec(index = 1)]
                Uncle(_1, ::core::option::Option<_2>),
            }
        }
        pub mod pallet_bags_list {
            use super::runtime_types;
            pub mod list {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Bag {
                    pub head: ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    pub tail: ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Node {
                    pub id: ::subxt::sp_core::crypto::AccountId32,
                    pub prev: ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    pub next: ::core::option::Option<
                        ::subxt::sp_core::crypto::AccountId32,
                    >,
                    pub bag_upper: ::core::primitive::u64,
                }
            }
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    rebag {
                        dislocated: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 1)]
                    put_in_front_of {
                        lighter: ::subxt::sp_core::crypto::AccountId32,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    NotInSameBag,
                    #[codec(index = 1)]
                    IdNotFound,
                    #[codec(index = 2)]
                    NotHeavier,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Rebagged {
                        who: ::subxt::sp_core::crypto::AccountId32,
                        from: ::core::primitive::u64,
                        to: ::core::primitive::u64,
                    },
                }
            }
        }
        pub mod pallet_balances {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    transfer {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        #[codec(compact)]
                        value: ::core::primitive::u128,
                    },
                    #[codec(index = 1)]
                    set_balance {
                        who: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        #[codec(compact)]
                        new_free: ::core::primitive::u128,
                        #[codec(compact)]
                        new_reserved: ::core::primitive::u128,
                    },
                    #[codec(index = 2)]
                    force_transfer {
                        source: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        #[codec(compact)]
                        value: ::core::primitive::u128,
                    },
                    #[codec(index = 3)]
                    transfer_keep_alive {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        #[codec(compact)]
                        value: ::core::primitive::u128,
                    },
                    #[codec(index = 4)]
                    transfer_all {
                        dest: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        keep_alive: ::core::primitive::bool,
                    },
                    #[codec(index = 5)]
                    force_unreserve {
                        who: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        amount: ::core::primitive::u128,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    VestingBalance,
                    #[codec(index = 1)]
                    LiquidityRestrictions,
                    #[codec(index = 2)]
                    InsufficientBalance,
                    #[codec(index = 3)]
                    ExistentialDeposit,
                    #[codec(index = 4)]
                    KeepAlive,
                    #[codec(index = 5)]
                    ExistingVestingSchedule,
                    #[codec(index = 6)]
                    DeadAccount,
                    #[codec(index = 7)]
                    TooManyReserves,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] Endowed { account : :: subxt :: sp_core :: crypto :: AccountId32 , free_balance : :: core :: primitive :: u128 , } , # [codec (index = 1)] DustLost { account : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 2)] Transfer { from : :: subxt :: sp_core :: crypto :: AccountId32 , to : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 3)] BalanceSet { who : :: subxt :: sp_core :: crypto :: AccountId32 , free : :: core :: primitive :: u128 , reserved : :: core :: primitive :: u128 , } , # [codec (index = 4)] Reserved { who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 5)] Unreserved { who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 6)] ReserveRepatriated { from : :: subxt :: sp_core :: crypto :: AccountId32 , to : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , destination_status : runtime_types :: frame_support :: traits :: tokens :: misc :: BalanceStatus , } , # [codec (index = 7)] Deposit { who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 8)] Withdraw { who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , # [codec (index = 9)] Slashed { who : :: subxt :: sp_core :: crypto :: AccountId32 , amount : :: core :: primitive :: u128 , } , }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct AccountData<_0> {
                pub free: _0,
                pub reserved: _0,
                pub misc_frozen: _0,
                pub fee_frozen: _0,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct BalanceLock<_0> {
                pub id: [::core::primitive::u8; 8usize],
                pub amount: _0,
                pub reasons: runtime_types::pallet_balances::Reasons,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Reasons {
                #[codec(index = 0)]
                Fee,
                #[codec(index = 1)]
                Misc,
                #[codec(index = 2)]
                All,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Releases {
                #[codec(index = 0)]
                V1_0_0,
                #[codec(index = 1)]
                V2_0_0,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ReserveData<_0, _1> {
                pub id: _0,
                pub amount: _1,
            }
        }
        pub mod pallet_bounties {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    propose_bounty {
                        #[codec(compact)]
                        value: ::core::primitive::u128,
                        description: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 1)]
                    approve_bounty {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 2)]
                    propose_curator {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                        curator: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        #[codec(compact)]
                        fee: ::core::primitive::u128,
                    },
                    #[codec(index = 3)]
                    unassign_curator {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 4)]
                    accept_curator {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 5)]
                    award_bounty {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                        beneficiary: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                    },
                    #[codec(index = 6)]
                    claim_bounty {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 7)]
                    close_bounty {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 8)]
                    extend_bounty_expiry {
                        #[codec(compact)]
                        bounty_id: ::core::primitive::u32,
                        remark: ::std::vec::Vec<::core::primitive::u8>,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InsufficientProposersBalance,
                    #[codec(index = 1)]
                    InvalidIndex,
                    #[codec(index = 2)]
                    ReasonTooBig,
                    #[codec(index = 3)]
                    UnexpectedStatus,
                    #[codec(index = 4)]
                    RequireCurator,
                    #[codec(index = 5)]
                    InvalidValue,
                    #[codec(index = 6)]
                    InvalidFee,
                    #[codec(index = 7)]
                    PendingPayout,
                    #[codec(index = 8)]
                    Premature,
                    #[codec(index = 9)]
                    HasActiveChildBounty,
                    #[codec(index = 10)]
                    TooManyQueued,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    BountyProposed { index: ::core::primitive::u32 },
                    #[codec(index = 1)]
                    BountyRejected {
                        index: ::core::primitive::u32,
                        bond: ::core::primitive::u128,
                    },
                    #[codec(index = 2)]
                    BountyBecameActive { index: ::core::primitive::u32 },
                    #[codec(index = 3)]
                    BountyAwarded {
                        index: ::core::primitive::u32,
                        beneficiary: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 4)]
                    BountyClaimed {
                        index: ::core::primitive::u32,
                        payout: ::core::primitive::u128,
                        beneficiary: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 5)]
                    BountyCanceled { index: ::core::primitive::u32 },
                    #[codec(index = 6)]
                    BountyExtended { index: ::core::primitive::u32 },
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Bounty<_0, _1, _2> {
                pub proposer: _0,
                pub value: _1,
                pub fee: _1,
                pub curator_deposit: _1,
                pub bond: _1,
                pub status:
                    runtime_types::pallet_bounties::BountyStatus<_0, _2>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum BountyStatus<_0, _1> {
                #[codec(index = 0)]
                Proposed,
                #[codec(index = 1)]
                Approved,
                #[codec(index = 2)]
                Funded,
                #[codec(index = 3)]
                CuratorProposed { curator: _0 },
                #[codec(index = 4)]
                Active { curator: _0, update_due: _1 },
                #[codec(index = 5)]
                PendingPayout {
                    curator: _0,
                    beneficiary: _0,
                    unlock_at: _1,
                },
            }
        }
        pub mod pallet_child_bounties {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    add_child_bounty {
                        #[codec(compact)]
                        parent_bounty_id: ::core::primitive::u32,
                        #[codec(compact)]
                        value: ::core::primitive::u128,
                        description: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 1)]
                    propose_curator {
                        #[codec(compact)]
                        parent_bounty_id: ::core::primitive::u32,
                        #[codec(compact)]
                        child_bounty_id: ::core::primitive::u32,
                        curator: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        #[codec(compact)]
                        fee: ::core::primitive::u128,
                    },
                    #[codec(index = 2)]
                    accept_curator {
                        #[codec(compact)]
                        parent_bounty_id: ::core::primitive::u32,
                        #[codec(compact)]
                        child_bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 3)]
                    unassign_curator {
                        #[codec(compact)]
                        parent_bounty_id: ::core::primitive::u32,
                        #[codec(compact)]
                        child_bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 4)]
                    award_child_bounty {
                        #[codec(compact)]
                        parent_bounty_id: ::core::primitive::u32,
                        #[codec(compact)]
                        child_bounty_id: ::core::primitive::u32,
                        beneficiary: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                    },
                    #[codec(index = 5)]
                    claim_child_bounty {
                        #[codec(compact)]
                        parent_bounty_id: ::core::primitive::u32,
                        #[codec(compact)]
                        child_bounty_id: ::core::primitive::u32,
                    },
                    #[codec(index = 6)]
                    close_child_bounty {
                        #[codec(compact)]
                        parent_bounty_id: ::core::primitive::u32,
                        #[codec(compact)]
                        child_bounty_id: ::core::primitive::u32,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    ParentBountyNotActive,
                    #[codec(index = 1)]
                    InsufficientBountyBalance,
                    #[codec(index = 2)]
                    TooManyChildBounties,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Added {
                        index: ::core::primitive::u32,
                        child_index: ::core::primitive::u32,
                    },
                    #[codec(index = 1)]
                    Awarded {
                        index: ::core::primitive::u32,
                        child_index: ::core::primitive::u32,
                        beneficiary: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 2)]
                    Claimed {
                        index: ::core::primitive::u32,
                        child_index: ::core::primitive::u32,
                        payout: ::core::primitive::u128,
                        beneficiary: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 3)]
                    Canceled {
                        index: ::core::primitive::u32,
                        child_index: ::core::primitive::u32,
                    },
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ChildBounty<_0, _1, _2> {
                pub parent_bounty: _2,
                pub value: _1,
                pub fee: _1,
                pub curator_deposit: _1,
                pub status:
                    runtime_types::pallet_child_bounties::ChildBountyStatus<
                        _0,
                        _2,
                    >,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum ChildBountyStatus<_0, _1> {
                #[codec(index = 0)]
                Added,
                #[codec(index = 1)]
                CuratorProposed { curator: _0 },
                #[codec(index = 2)]
                Active { curator: _0 },
                #[codec(index = 3)]
                PendingPayout {
                    curator: _0,
                    beneficiary: _0,
                    unlock_at: _1,
                },
            }
        }
        pub mod pallet_collective {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    set_members {
                        new_members: ::std::vec::Vec<
                            ::subxt::sp_core::crypto::AccountId32,
                        >,
                        prime: ::core::option::Option<
                            ::subxt::sp_core::crypto::AccountId32,
                        >,
                        old_count: ::core::primitive::u32,
                    },
                    #[codec(index = 1)]
                    execute {
                        proposal: ::std::boxed::Box<
                            runtime_types::egg_standalone_runtime::Call,
                        >,
                        #[codec(compact)]
                        length_bound: ::core::primitive::u32,
                    },
                    #[codec(index = 2)]
                    propose {
                        #[codec(compact)]
                        threshold: ::core::primitive::u32,
                        proposal: ::std::boxed::Box<
                            runtime_types::egg_standalone_runtime::Call,
                        >,
                        #[codec(compact)]
                        length_bound: ::core::primitive::u32,
                    },
                    #[codec(index = 3)]
                    vote {
                        proposal: ::subxt::sp_core::H256,
                        #[codec(compact)]
                        index: ::core::primitive::u32,
                        approve: ::core::primitive::bool,
                    },
                    #[codec(index = 4)]
                    close {
                        proposal_hash: ::subxt::sp_core::H256,
                        #[codec(compact)]
                        index: ::core::primitive::u32,
                        #[codec(compact)]
                        proposal_weight_bound: ::core::primitive::u64,
                        #[codec(compact)]
                        length_bound: ::core::primitive::u32,
                    },
                    #[codec(index = 5)]
                    disapprove_proposal {
                        proposal_hash: ::subxt::sp_core::H256,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    NotMember,
                    #[codec(index = 1)]
                    DuplicateProposal,
                    #[codec(index = 2)]
                    ProposalMissing,
                    #[codec(index = 3)]
                    WrongIndex,
                    #[codec(index = 4)]
                    DuplicateVote,
                    #[codec(index = 5)]
                    AlreadyInitialized,
                    #[codec(index = 6)]
                    TooEarly,
                    #[codec(index = 7)]
                    TooManyProposals,
                    #[codec(index = 8)]
                    WrongProposalWeight,
                    #[codec(index = 9)]
                    WrongProposalLength,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Proposed {
                        account: ::subxt::sp_core::crypto::AccountId32,
                        proposal_index: ::core::primitive::u32,
                        proposal_hash: ::subxt::sp_core::H256,
                        threshold: ::core::primitive::u32,
                    },
                    #[codec(index = 1)]
                    Voted {
                        account: ::subxt::sp_core::crypto::AccountId32,
                        proposal_hash: ::subxt::sp_core::H256,
                        voted: ::core::primitive::bool,
                        yes: ::core::primitive::u32,
                        no: ::core::primitive::u32,
                    },
                    #[codec(index = 2)]
                    Approved {
                        proposal_hash: ::subxt::sp_core::H256,
                    },
                    #[codec(index = 3)]
                    Disapproved {
                        proposal_hash: ::subxt::sp_core::H256,
                    },
                    #[codec(index = 4)]
                    Executed {
                        proposal_hash: ::subxt::sp_core::H256,
                        result: ::core::result::Result<
                            (),
                            runtime_types::sp_runtime::DispatchError,
                        >,
                    },
                    #[codec(index = 5)]
                    MemberExecuted {
                        proposal_hash: ::subxt::sp_core::H256,
                        result: ::core::result::Result<
                            (),
                            runtime_types::sp_runtime::DispatchError,
                        >,
                    },
                    #[codec(index = 6)]
                    Closed {
                        proposal_hash: ::subxt::sp_core::H256,
                        yes: ::core::primitive::u32,
                        no: ::core::primitive::u32,
                    },
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum RawOrigin<_0> {
                #[codec(index = 0)]
                Members(::core::primitive::u32, ::core::primitive::u32),
                #[codec(index = 1)]
                Member(_0),
                #[codec(index = 2)]
                _Phantom,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Votes<_0, _1> {
                pub index: _1,
                pub threshold: _1,
                pub ayes: ::std::vec::Vec<_0>,
                pub nays: ::std::vec::Vec<_0>,
                pub end: _1,
            }
        }
        pub mod pallet_democracy {
            use super::runtime_types;
            pub mod conviction {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Conviction {
                    #[codec(index = 0)]
                    None,
                    #[codec(index = 1)]
                    Locked1x,
                    #[codec(index = 2)]
                    Locked2x,
                    #[codec(index = 3)]
                    Locked3x,
                    #[codec(index = 4)]
                    Locked4x,
                    #[codec(index = 5)]
                    Locked5x,
                    #[codec(index = 6)]
                    Locked6x,
                }
            }
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] propose { proposal_hash : :: subxt :: sp_core :: H256 , # [codec (compact)] value : :: core :: primitive :: u128 , } , # [codec (index = 1)] second { # [codec (compact)] proposal : :: core :: primitive :: u32 , # [codec (compact)] seconds_upper_bound : :: core :: primitive :: u32 , } , # [codec (index = 2)] vote { # [codec (compact)] ref_index : :: core :: primitive :: u32 , vote : runtime_types :: pallet_democracy :: vote :: AccountVote < :: core :: primitive :: u128 > , } , # [codec (index = 3)] emergency_cancel { ref_index : :: core :: primitive :: u32 , } , # [codec (index = 4)] external_propose { proposal_hash : :: subxt :: sp_core :: H256 , } , # [codec (index = 5)] external_propose_majority { proposal_hash : :: subxt :: sp_core :: H256 , } , # [codec (index = 6)] external_propose_default { proposal_hash : :: subxt :: sp_core :: H256 , } , # [codec (index = 7)] fast_track { proposal_hash : :: subxt :: sp_core :: H256 , voting_period : :: core :: primitive :: u32 , delay : :: core :: primitive :: u32 , } , # [codec (index = 8)] veto_external { proposal_hash : :: subxt :: sp_core :: H256 , } , # [codec (index = 9)] cancel_referendum { # [codec (compact)] ref_index : :: core :: primitive :: u32 , } , # [codec (index = 10)] cancel_queued { which : :: core :: primitive :: u32 , } , # [codec (index = 11)] delegate { to : :: subxt :: sp_core :: crypto :: AccountId32 , conviction : runtime_types :: pallet_democracy :: conviction :: Conviction , balance : :: core :: primitive :: u128 , } , # [codec (index = 12)] undelegate , # [codec (index = 13)] clear_public_proposals , # [codec (index = 14)] note_preimage { encoded_proposal : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 15)] note_preimage_operational { encoded_proposal : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 16)] note_imminent_preimage { encoded_proposal : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 17)] note_imminent_preimage_operational { encoded_proposal : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 18)] reap_preimage { proposal_hash : :: subxt :: sp_core :: H256 , # [codec (compact)] proposal_len_upper_bound : :: core :: primitive :: u32 , } , # [codec (index = 19)] unlock { target : :: subxt :: sp_core :: crypto :: AccountId32 , } , # [codec (index = 20)] remove_vote { index : :: core :: primitive :: u32 , } , # [codec (index = 21)] remove_other_vote { target : :: subxt :: sp_core :: crypto :: AccountId32 , index : :: core :: primitive :: u32 , } , # [codec (index = 22)] enact_proposal { proposal_hash : :: subxt :: sp_core :: H256 , index : :: core :: primitive :: u32 , } , # [codec (index = 23)] blacklist { proposal_hash : :: subxt :: sp_core :: H256 , maybe_ref_index : :: core :: option :: Option < :: core :: primitive :: u32 > , } , # [codec (index = 24)] cancel_proposal { # [codec (compact)] prop_index : :: core :: primitive :: u32 , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    ValueLow,
                    #[codec(index = 1)]
                    ProposalMissing,
                    #[codec(index = 2)]
                    AlreadyCanceled,
                    #[codec(index = 3)]
                    DuplicateProposal,
                    #[codec(index = 4)]
                    ProposalBlacklisted,
                    #[codec(index = 5)]
                    NotSimpleMajority,
                    #[codec(index = 6)]
                    InvalidHash,
                    #[codec(index = 7)]
                    NoProposal,
                    #[codec(index = 8)]
                    AlreadyVetoed,
                    #[codec(index = 9)]
                    DuplicatePreimage,
                    #[codec(index = 10)]
                    NotImminent,
                    #[codec(index = 11)]
                    TooEarly,
                    #[codec(index = 12)]
                    Imminent,
                    #[codec(index = 13)]
                    PreimageMissing,
                    #[codec(index = 14)]
                    ReferendumInvalid,
                    #[codec(index = 15)]
                    PreimageInvalid,
                    #[codec(index = 16)]
                    NoneWaiting,
                    #[codec(index = 17)]
                    NotVoter,
                    #[codec(index = 18)]
                    NoPermission,
                    #[codec(index = 19)]
                    AlreadyDelegating,
                    #[codec(index = 20)]
                    InsufficientFunds,
                    #[codec(index = 21)]
                    NotDelegating,
                    #[codec(index = 22)]
                    VotesExist,
                    #[codec(index = 23)]
                    InstantNotAllowed,
                    #[codec(index = 24)]
                    Nonsense,
                    #[codec(index = 25)]
                    WrongUpperBound,
                    #[codec(index = 26)]
                    MaxVotesReached,
                    #[codec(index = 27)]
                    TooManyProposals,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] Proposed { proposal_index : :: core :: primitive :: u32 , deposit : :: core :: primitive :: u128 , } , # [codec (index = 1)] Tabled { proposal_index : :: core :: primitive :: u32 , deposit : :: core :: primitive :: u128 , depositors : :: std :: vec :: Vec < :: subxt :: sp_core :: crypto :: AccountId32 > , } , # [codec (index = 2)] ExternalTabled , # [codec (index = 3)] Started { ref_index : :: core :: primitive :: u32 , threshold : runtime_types :: pallet_democracy :: vote_threshold :: VoteThreshold , } , # [codec (index = 4)] Passed { ref_index : :: core :: primitive :: u32 , } , # [codec (index = 5)] NotPassed { ref_index : :: core :: primitive :: u32 , } , # [codec (index = 6)] Cancelled { ref_index : :: core :: primitive :: u32 , } , # [codec (index = 7)] Executed { ref_index : :: core :: primitive :: u32 , result : :: core :: result :: Result < () , runtime_types :: sp_runtime :: DispatchError > , } , # [codec (index = 8)] Delegated { who : :: subxt :: sp_core :: crypto :: AccountId32 , target : :: subxt :: sp_core :: crypto :: AccountId32 , } , # [codec (index = 9)] Undelegated { account : :: subxt :: sp_core :: crypto :: AccountId32 , } , # [codec (index = 10)] Vetoed { who : :: subxt :: sp_core :: crypto :: AccountId32 , proposal_hash : :: subxt :: sp_core :: H256 , until : :: core :: primitive :: u32 , } , # [codec (index = 11)] PreimageNoted { proposal_hash : :: subxt :: sp_core :: H256 , who : :: subxt :: sp_core :: crypto :: AccountId32 , deposit : :: core :: primitive :: u128 , } , # [codec (index = 12)] PreimageUsed { proposal_hash : :: subxt :: sp_core :: H256 , provider : :: subxt :: sp_core :: crypto :: AccountId32 , deposit : :: core :: primitive :: u128 , } , # [codec (index = 13)] PreimageInvalid { proposal_hash : :: subxt :: sp_core :: H256 , ref_index : :: core :: primitive :: u32 , } , # [codec (index = 14)] PreimageMissing { proposal_hash : :: subxt :: sp_core :: H256 , ref_index : :: core :: primitive :: u32 , } , # [codec (index = 15)] PreimageReaped { proposal_hash : :: subxt :: sp_core :: H256 , provider : :: subxt :: sp_core :: crypto :: AccountId32 , deposit : :: core :: primitive :: u128 , reaper : :: subxt :: sp_core :: crypto :: AccountId32 , } , # [codec (index = 16)] Blacklisted { proposal_hash : :: subxt :: sp_core :: H256 , } , # [codec (index = 17)] Voted { voter : :: subxt :: sp_core :: crypto :: AccountId32 , ref_index : :: core :: primitive :: u32 , vote : runtime_types :: pallet_democracy :: vote :: AccountVote < :: core :: primitive :: u128 > , } , # [codec (index = 18)] Seconded { seconder : :: subxt :: sp_core :: crypto :: AccountId32 , prop_index : :: core :: primitive :: u32 , } , }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Delegations<_0> {
                    pub votes: _0,
                    pub capital: _0,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum ReferendumInfo<_0, _1, _2> {
                    # [codec (index = 0)] Ongoing (runtime_types :: pallet_democracy :: types :: ReferendumStatus < _0 , _1 , _2 > ,) , # [codec (index = 1)] Finished { approved : :: core :: primitive :: bool , end : _0 , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct ReferendumStatus < _0 , _1 , _2 > { pub end : _0 , pub proposal_hash : _1 , pub threshold : runtime_types :: pallet_democracy :: vote_threshold :: VoteThreshold , pub delay : _0 , pub tally : runtime_types :: pallet_democracy :: types :: Tally < _2 > , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Tally<_0> {
                    pub ayes: _0,
                    pub nays: _0,
                    pub turnout: _0,
                }
            }
            pub mod vote {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum AccountVote<_0> {
                    #[codec(index = 0)]
                    Standard {
                        vote: runtime_types::pallet_democracy::vote::Vote,
                        balance: _0,
                    },
                    #[codec(index = 1)]
                    Split { aye: _0, nay: _0 },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct PriorLock<_0, _1>(pub _0, pub _1);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                    :: subxt :: codec :: CompactAs,
                )]
                pub struct Vote(pub ::core::primitive::u8);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Voting<_0, _1, _2> {
                    # [codec (index = 0)] Direct { votes : :: std :: vec :: Vec < (_2 , runtime_types :: pallet_democracy :: vote :: AccountVote < _0 > ,) > , delegations : runtime_types :: pallet_democracy :: types :: Delegations < _0 > , prior : runtime_types :: pallet_democracy :: vote :: PriorLock < _2 , _0 > , } , # [codec (index = 1)] Delegating { balance : _0 , target : _1 , conviction : runtime_types :: pallet_democracy :: conviction :: Conviction , delegations : runtime_types :: pallet_democracy :: types :: Delegations < _0 > , prior : runtime_types :: pallet_democracy :: vote :: PriorLock < _2 , _0 > , } , }
            }
            pub mod vote_threshold {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum VoteThreshold {
                    #[codec(index = 0)]
                    SuperMajorityApprove,
                    #[codec(index = 1)]
                    SuperMajorityAgainst,
                    #[codec(index = 2)]
                    SimpleMajority,
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum PreimageStatus<_0, _1, _2> {
                #[codec(index = 0)]
                Missing(_2),
                #[codec(index = 1)]
                Available {
                    data: ::std::vec::Vec<::core::primitive::u8>,
                    provider: _0,
                    deposit: _1,
                    since: _2,
                    expiry: ::core::option::Option<_2>,
                },
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Releases {
                #[codec(index = 0)]
                V1,
            }
        }
        pub mod pallet_dkg_metadata {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] set_signature_threshold { new_threshold : :: core :: primitive :: u16 , } , # [codec (index = 1)] set_keygen_threshold { new_threshold : :: core :: primitive :: u16 , } , # [codec (index = 2)] set_refresh_delay { new_delay : :: core :: primitive :: u8 , } , # [codec (index = 3)] submit_public_key { keys_and_signatures : runtime_types :: dkg_runtime_primitives :: AggregatedPublicKeys , } , # [codec (index = 4)] submit_next_public_key { keys_and_signatures : runtime_types :: dkg_runtime_primitives :: AggregatedPublicKeys , } , # [codec (index = 5)] submit_public_key_signature { signature_proposal : runtime_types :: dkg_runtime_primitives :: proposal :: RefreshProposalSigned , } , # [codec (index = 6)] submit_misbehaviour_reports { reports : runtime_types :: dkg_runtime_primitives :: AggregatedMisbehaviourReports < runtime_types :: dkg_runtime_primitives :: crypto :: Public > , } , # [codec (index = 7)] unjail , # [codec (index = 8)] force_unjail_keygen { authority : runtime_types :: dkg_runtime_primitives :: crypto :: Public , } , # [codec (index = 9)] force_unjail_signing { authority : runtime_types :: dkg_runtime_primitives :: crypto :: Public , } , # [codec (index = 10)] manual_increment_nonce , # [codec (index = 11)] manual_refresh , # [codec (index = 12)] force_change_authorities , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    NoMappedAccount,
                    #[codec(index = 1)]
                    InvalidThreshold,
                    #[codec(index = 2)]
                    MustBeAQueuedAuthority,
                    #[codec(index = 3)]
                    MustBeAnActiveAuthority,
                    #[codec(index = 4)]
                    InvalidRefreshDelay,
                    #[codec(index = 5)]
                    InvalidPublicKeys,
                    #[codec(index = 6)]
                    AlreadySubmittedPublicKey,
                    #[codec(index = 7)]
                    AlreadySubmittedSignature,
                    #[codec(index = 8)]
                    UsedSignature,
                    #[codec(index = 9)]
                    InvalidSignature,
                    #[codec(index = 10)]
                    InvalidMisbehaviourReports,
                    #[codec(index = 11)]
                    RefreshInProgress,
                    #[codec(index = 12)]
                    ManualRefreshFailed,
                    #[codec(index = 13)]
                    NoNextPublicKey,
                    #[codec(index = 14)]
                    InvalidControllerAccount,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] PublicKeySubmitted { compressed_pub_key : :: std :: vec :: Vec < :: core :: primitive :: u8 > , uncompressed_pub_key : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 1)] NextPublicKeySubmitted { compressed_pub_key : :: std :: vec :: Vec < :: core :: primitive :: u8 > , uncompressed_pub_key : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 2)] NextPublicKeySignatureSubmitted { pub_key_sig : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 3)] PublicKeyChanged { compressed_pub_key : :: std :: vec :: Vec < :: core :: primitive :: u8 > , uncompressed_pub_key : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 4)] PublicKeySignatureChanged { pub_key_sig : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 5)] MisbehaviourReportsSubmitted { misbehaviour_type : runtime_types :: dkg_runtime_primitives :: MisbehaviourType , reporters : :: std :: vec :: Vec < runtime_types :: dkg_runtime_primitives :: crypto :: Public > , } , # [codec (index = 6)] RefreshKeysFinished { next_authority_set_id : :: core :: primitive :: u64 , } , }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct RoundMetadata {
                    pub curr_round_pub_key:
                        ::std::vec::Vec<::core::primitive::u8>,
                    pub next_round_pub_key:
                        ::std::vec::Vec<::core::primitive::u8>,
                    pub refresh_signature:
                        ::std::vec::Vec<::core::primitive::u8>,
                }
            }
        }
        pub mod pallet_dkg_proposal_handler {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] submit_signed_proposals { props : :: std :: vec :: Vec < runtime_types :: dkg_runtime_primitives :: proposal :: Proposal > , } , # [codec (index = 1)] force_submit_unsigned_proposal { prop : runtime_types :: dkg_runtime_primitives :: proposal :: Proposal , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    NoneValue,
                    #[codec(index = 1)]
                    StorageOverflow,
                    #[codec(index = 2)]
                    ProposalFormatInvalid,
                    #[codec(index = 3)]
                    ProposalSignatureInvalid,
                    #[codec(index = 4)]
                    ProposalDoesNotExists,
                    #[codec(index = 5)]
                    ProposalAlreadyExists,
                    #[codec(index = 6)]
                    ChainIdInvalid,
                    #[codec(index = 7)]
                    ProposalsLengthOverflow,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] InvalidProposalSignature { kind : runtime_types :: dkg_runtime_primitives :: proposal :: ProposalKind , data : :: std :: vec :: Vec < :: core :: primitive :: u8 > , invalid_signature : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 1)] ProposalSigned { key : runtime_types :: dkg_runtime_primitives :: proposal :: DKGPayloadKey , target_chain : runtime_types :: webb_proposals :: header :: TypedChainId , data : :: std :: vec :: Vec < :: core :: primitive :: u8 > , signature : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , }
            }
        }
        pub mod pallet_dkg_proposals {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    set_threshold { threshold: ::core::primitive::u32 },
                    #[codec(index = 1)]
                    set_resource {
                        id: runtime_types::webb_proposals::header::ResourceId,
                        method: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 2)]
                    remove_resource {
                        id: runtime_types::webb_proposals::header::ResourceId,
                    },
                    #[codec(index = 3)]
                    whitelist_chain {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                    },
                    #[codec(index = 4)]
                    add_proposer {
                        native_account: ::subxt::sp_core::crypto::AccountId32,
                        external_account:
                            ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 5)]
                    remove_proposer {
                        v: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 6)]
                    acknowledge_proposal {
                        nonce: runtime_types::webb_proposals::nonce::Nonce,
                        src_chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        r_id: runtime_types::webb_proposals::header::ResourceId,
                        prop: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 7)]
                    reject_proposal {
                        nonce: runtime_types::webb_proposals::nonce::Nonce,
                        src_chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        r_id: runtime_types::webb_proposals::header::ResourceId,
                        prop: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 8)]
                    eval_vote_state {
                        nonce: runtime_types::webb_proposals::nonce::Nonce,
                        src_chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        prop: ::std::vec::Vec<::core::primitive::u8>,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidPermissions,
                    #[codec(index = 1)]
                    ThresholdNotSet,
                    #[codec(index = 2)]
                    InvalidChainId,
                    #[codec(index = 3)]
                    InvalidThreshold,
                    #[codec(index = 4)]
                    ChainNotWhitelisted,
                    #[codec(index = 5)]
                    ChainAlreadyWhitelisted,
                    #[codec(index = 6)]
                    ResourceDoesNotExist,
                    #[codec(index = 7)]
                    ProposerAlreadyExists,
                    #[codec(index = 8)]
                    ProposerInvalid,
                    #[codec(index = 9)]
                    MustBeProposer,
                    #[codec(index = 10)]
                    ProposerAlreadyVoted,
                    #[codec(index = 11)]
                    ProposalAlreadyExists,
                    #[codec(index = 12)]
                    ProposalDoesNotExist,
                    #[codec(index = 13)]
                    ProposalNotComplete,
                    #[codec(index = 14)]
                    ProposalAlreadyComplete,
                    #[codec(index = 15)]
                    ProposalExpired,
                    #[codec(index = 16)]
                    ProposerCountIsZero,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    ProposerThresholdChanged {
                        new_threshold: ::core::primitive::u32,
                    },
                    #[codec(index = 1)]
                    ChainWhitelisted {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                    },
                    #[codec(index = 2)]
                    ProposerAdded {
                        proposer_id: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 3)]
                    ProposerRemoved {
                        proposer_id: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 4)]
                    VoteFor {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        proposal_nonce:
                            runtime_types::webb_proposals::nonce::Nonce,
                        who: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 5)]
                    VoteAgainst {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        proposal_nonce:
                            runtime_types::webb_proposals::nonce::Nonce,
                        who: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 6)]
                    ProposalApproved {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        proposal_nonce:
                            runtime_types::webb_proposals::nonce::Nonce,
                    },
                    #[codec(index = 7)]
                    ProposalRejected {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        proposal_nonce:
                            runtime_types::webb_proposals::nonce::Nonce,
                    },
                    #[codec(index = 8)]
                    ProposalSucceeded {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        proposal_nonce:
                            runtime_types::webb_proposals::nonce::Nonce,
                    },
                    #[codec(index = 9)]
                    ProposalFailed {
                        chain_id:
                            runtime_types::webb_proposals::header::TypedChainId,
                        proposal_nonce:
                            runtime_types::webb_proposals::nonce::Nonce,
                    },
                    #[codec(index = 10)]
                    AuthorityProposersReset {
                        proposers: ::std::vec::Vec<
                            ::subxt::sp_core::crypto::AccountId32,
                        >,
                    },
                }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum ProposalStatus {
                    #[codec(index = 0)]
                    Initiated,
                    #[codec(index = 1)]
                    Approved,
                    #[codec(index = 2)]
                    Rejected,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct ProposalVotes < _0 , _1 > { pub votes_for : :: std :: vec :: Vec < _0 > , pub votes_against : :: std :: vec :: Vec < _0 > , pub status : runtime_types :: pallet_dkg_proposals :: types :: ProposalStatus , pub expiry : _1 , }
            }
        }
        pub mod pallet_election_provider_multi_phase {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] submit_unsigned { raw_solution : :: std :: boxed :: Box < runtime_types :: pallet_election_provider_multi_phase :: RawSolution < runtime_types :: egg_standalone_runtime :: NposSolution16 > > , witness : runtime_types :: pallet_election_provider_multi_phase :: SolutionOrSnapshotSize , } , # [codec (index = 1)] set_minimum_untrusted_score { maybe_next_score : :: core :: option :: Option < [:: core :: primitive :: u128 ; 3usize] > , } , # [codec (index = 2)] set_emergency_election_result { supports : :: std :: vec :: Vec < (:: subxt :: sp_core :: crypto :: AccountId32 , runtime_types :: sp_npos_elections :: Support < :: subxt :: sp_core :: crypto :: AccountId32 > ,) > , } , # [codec (index = 3)] submit { raw_solution : :: std :: boxed :: Box < runtime_types :: pallet_election_provider_multi_phase :: RawSolution < runtime_types :: egg_standalone_runtime :: NposSolution16 > > , num_signed_submissions : :: core :: primitive :: u32 , } , # [codec (index = 4)] governance_fallback { maybe_max_voters : :: core :: option :: Option < :: core :: primitive :: u32 > , maybe_max_targets : :: core :: option :: Option < :: core :: primitive :: u32 > , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    PreDispatchEarlySubmission,
                    #[codec(index = 1)]
                    PreDispatchWrongWinnerCount,
                    #[codec(index = 2)]
                    PreDispatchWeakSubmission,
                    #[codec(index = 3)]
                    SignedQueueFull,
                    #[codec(index = 4)]
                    SignedCannotPayDeposit,
                    #[codec(index = 5)]
                    SignedInvalidWitness,
                    #[codec(index = 6)]
                    SignedTooMuchWeight,
                    #[codec(index = 7)]
                    OcwCallWrongEra,
                    #[codec(index = 8)]
                    MissingSnapshotMetadata,
                    #[codec(index = 9)]
                    InvalidSubmissionIndex,
                    #[codec(index = 10)]
                    CallNotAllowed,
                    #[codec(index = 11)]
                    FallbackFailed,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] SolutionStored { election_compute : runtime_types :: pallet_election_provider_multi_phase :: ElectionCompute , prev_ejected : :: core :: primitive :: bool , } , # [codec (index = 1)] ElectionFinalized { election_compute : :: core :: option :: Option < runtime_types :: pallet_election_provider_multi_phase :: ElectionCompute > , } , # [codec (index = 2)] Rewarded { account : :: subxt :: sp_core :: crypto :: AccountId32 , value : :: core :: primitive :: u128 , } , # [codec (index = 3)] Slashed { account : :: subxt :: sp_core :: crypto :: AccountId32 , value : :: core :: primitive :: u128 , } , # [codec (index = 4)] SignedPhaseStarted { round : :: core :: primitive :: u32 , } , # [codec (index = 5)] UnsignedPhaseStarted { round : :: core :: primitive :: u32 , } , }
            }
            pub mod signed {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct SignedSubmission < _0 , _1 , _2 > { pub who : _0 , pub deposit : _1 , pub raw_solution : runtime_types :: pallet_election_provider_multi_phase :: RawSolution < _2 > , pub reward : _1 , }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum ElectionCompute {
                #[codec(index = 0)]
                OnChain,
                #[codec(index = 1)]
                Signed,
                #[codec(index = 2)]
                Unsigned,
                #[codec(index = 3)]
                Fallback,
                #[codec(index = 4)]
                Emergency,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Phase<_0> {
                #[codec(index = 0)]
                Off,
                #[codec(index = 1)]
                Signed,
                #[codec(index = 2)]
                Unsigned((::core::primitive::bool, _0)),
                #[codec(index = 3)]
                Emergency,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct RawSolution<_0> {
                pub solution: _0,
                pub score: [::core::primitive::u128; 3usize],
                pub round: ::core::primitive::u32,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ReadySolution < _0 > { pub supports : :: std :: vec :: Vec < (_0 , runtime_types :: sp_npos_elections :: Support < _0 > ,) > , pub score : [:: core :: primitive :: u128 ; 3usize] , pub compute : runtime_types :: pallet_election_provider_multi_phase :: ElectionCompute , }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct RoundSnapshot { pub voters : :: std :: vec :: Vec < (:: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u64 , runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: subxt :: sp_core :: crypto :: AccountId32 > ,) > , pub targets : :: std :: vec :: Vec < :: subxt :: sp_core :: crypto :: AccountId32 > , }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct SolutionOrSnapshotSize {
                #[codec(compact)]
                pub voters: ::core::primitive::u32,
                #[codec(compact)]
                pub targets: ::core::primitive::u32,
            }
        }
        pub mod pallet_elections_phragmen {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] vote { votes : :: std :: vec :: Vec < :: subxt :: sp_core :: crypto :: AccountId32 > , # [codec (compact)] value : :: core :: primitive :: u128 , } , # [codec (index = 1)] remove_voter , # [codec (index = 2)] submit_candidacy { # [codec (compact)] candidate_count : :: core :: primitive :: u32 , } , # [codec (index = 3)] renounce_candidacy { renouncing : runtime_types :: pallet_elections_phragmen :: Renouncing , } , # [codec (index = 4)] remove_member { who : :: subxt :: sp_runtime :: MultiAddress < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 > , has_replacement : :: core :: primitive :: bool , } , # [codec (index = 5)] clean_defunct_voters { num_voters : :: core :: primitive :: u32 , num_defunct : :: core :: primitive :: u32 , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    UnableToVote,
                    #[codec(index = 1)]
                    NoVotes,
                    #[codec(index = 2)]
                    TooManyVotes,
                    #[codec(index = 3)]
                    MaximumVotesExceeded,
                    #[codec(index = 4)]
                    LowBalance,
                    #[codec(index = 5)]
                    UnableToPayBond,
                    #[codec(index = 6)]
                    MustBeVoter,
                    #[codec(index = 7)]
                    ReportSelf,
                    #[codec(index = 8)]
                    DuplicatedCandidate,
                    #[codec(index = 9)]
                    MemberSubmit,
                    #[codec(index = 10)]
                    RunnerUpSubmit,
                    #[codec(index = 11)]
                    InsufficientCandidateFunds,
                    #[codec(index = 12)]
                    NotMember,
                    #[codec(index = 13)]
                    InvalidWitnessData,
                    #[codec(index = 14)]
                    InvalidVoteCount,
                    #[codec(index = 15)]
                    InvalidRenouncing,
                    #[codec(index = 16)]
                    InvalidReplacement,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    NewTerm {
                        new_members: ::std::vec::Vec<(
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        )>,
                    },
                    #[codec(index = 1)]
                    EmptyTerm,
                    #[codec(index = 2)]
                    ElectionError,
                    #[codec(index = 3)]
                    MemberKicked {
                        member: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 4)]
                    Renounced {
                        candidate: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 5)]
                    CandidateSlashed {
                        candidate: ::subxt::sp_core::crypto::AccountId32,
                        amount: ::core::primitive::u128,
                    },
                    #[codec(index = 6)]
                    SeatHolderSlashed {
                        seat_holder: ::subxt::sp_core::crypto::AccountId32,
                        amount: ::core::primitive::u128,
                    },
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Renouncing {
                #[codec(index = 0)]
                Member,
                #[codec(index = 1)]
                RunnerUp,
                #[codec(index = 2)]
                Candidate(#[codec(compact)] ::core::primitive::u32),
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct SeatHolder<_0, _1> {
                pub who: _0,
                pub stake: _1,
                pub deposit: _1,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Voter<_0, _1> {
                pub votes: ::std::vec::Vec<_0>,
                pub stake: _1,
                pub deposit: _1,
            }
        }
        pub mod pallet_grandpa {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] report_equivocation { equivocation_proof : :: std :: boxed :: Box < runtime_types :: sp_finality_grandpa :: EquivocationProof < :: subxt :: sp_core :: H256 , :: core :: primitive :: u32 > > , key_owner_proof : runtime_types :: sp_session :: MembershipProof , } , # [codec (index = 1)] report_equivocation_unsigned { equivocation_proof : :: std :: boxed :: Box < runtime_types :: sp_finality_grandpa :: EquivocationProof < :: subxt :: sp_core :: H256 , :: core :: primitive :: u32 > > , key_owner_proof : runtime_types :: sp_session :: MembershipProof , } , # [codec (index = 2)] note_stalled { delay : :: core :: primitive :: u32 , best_finalized_block_number : :: core :: primitive :: u32 , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    PauseFailed,
                    #[codec(index = 1)]
                    ResumeFailed,
                    #[codec(index = 2)]
                    ChangePending,
                    #[codec(index = 3)]
                    TooSoon,
                    #[codec(index = 4)]
                    InvalidKeyOwnershipProof,
                    #[codec(index = 5)]
                    InvalidEquivocationProof,
                    #[codec(index = 6)]
                    DuplicateOffenceReport,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    NewAuthorities {
                        authority_set: ::std::vec::Vec<(
                            runtime_types::sp_finality_grandpa::app::Public,
                            ::core::primitive::u64,
                        )>,
                    },
                    #[codec(index = 1)]
                    Paused,
                    #[codec(index = 2)]
                    Resumed,
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct StoredPendingChange < _0 > { pub scheduled_at : _0 , pub delay : _0 , pub next_authorities : runtime_types :: frame_support :: storage :: weak_bounded_vec :: WeakBoundedVec < (runtime_types :: sp_finality_grandpa :: app :: Public , :: core :: primitive :: u64 ,) > , pub forced : :: core :: option :: Option < _0 > , }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum StoredState<_0> {
                #[codec(index = 0)]
                Live,
                #[codec(index = 1)]
                PendingPause { scheduled_at: _0, delay: _0 },
                #[codec(index = 2)]
                Paused,
                #[codec(index = 3)]
                PendingResume { scheduled_at: _0, delay: _0 },
            }
        }
        pub mod pallet_hasher {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    force_set_parameters {
                        parameters: ::std::vec::Vec<::core::primitive::u8>,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    ParametersNotInitialized,
                    #[codec(index = 1)]
                    HashError,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {}
            }
        }
        pub mod pallet_linkable_tree {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    create {
                        max_edges: ::core::primitive::u32,
                        depth: ::core::primitive::u8,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    UnknownRoot,
                    #[codec(index = 1)]
                    InvalidMerkleRoots,
                    #[codec(index = 2)]
                    InvalidNeighborWithdrawRoot,
                    #[codec(index = 3)]
                    TooManyEdges,
                    #[codec(index = 4)]
                    EdgeAlreadyExists,
                    #[codec(index = 5)]
                    EdgeDoesntExists,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    LinkableTreeCreation { tree_id: ::core::primitive::u32 },
                }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct EdgeMetadata<_0, _1, _2> {
                    pub src_chain_id: _0,
                    pub root: _1,
                    pub latest_leaf_index: _2,
                }
            }
        }
        pub mod pallet_mixer {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] create { deposit_size : :: core :: primitive :: u128 , depth : :: core :: primitive :: u8 , asset : :: core :: primitive :: u32 , } , # [codec (index = 1)] deposit { tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , # [codec (index = 2)] withdraw { id : :: core :: primitive :: u32 , proof_bytes : :: std :: vec :: Vec < :: core :: primitive :: u8 > , root : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , nullifier_hash : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , recipient : :: subxt :: sp_core :: crypto :: AccountId32 , relayer : :: subxt :: sp_core :: crypto :: AccountId32 , fee : :: core :: primitive :: u128 , refund : :: core :: primitive :: u128 , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidPermissions,
                    #[codec(index = 1)]
                    InvalidWithdrawProof,
                    #[codec(index = 2)]
                    AlreadyRevealedNullifier,
                    #[codec(index = 3)]
                    InvalidArbitraryData,
                    #[codec(index = 4)]
                    UnknownRoot,
                    #[codec(index = 5)]
                    NoMixerFound,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] MixerCreation { tree_id : :: core :: primitive :: u32 , } , # [codec (index = 1)] Deposit { tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , # [codec (index = 2)] Withdraw { tree_id : :: core :: primitive :: u32 , recipient : :: subxt :: sp_core :: crypto :: AccountId32 , } , }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct MixerMetadata<_0, _1> {
                    pub deposit_size: _0,
                    pub asset: _1,
                }
            }
        }
        pub mod pallet_mt {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] create { depth : :: core :: primitive :: u8 , } , # [codec (index = 1)] insert { tree_id : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , # [codec (index = 2)] force_set_default_hashes { default_hashes : :: std :: vec :: Vec < runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element > , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidPermissions,
                    #[codec(index = 1)]
                    InvalidTreeDepth,
                    #[codec(index = 2)]
                    InvalidLeafIndex,
                    #[codec(index = 3)]
                    ExceedsMaxLeaves,
                    #[codec(index = 4)]
                    TreeDoesntExist,
                    #[codec(index = 5)]
                    ExceedsMaxDefaultHashes,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] TreeCreation { tree_id : :: core :: primitive :: u32 , who : :: subxt :: sp_core :: crypto :: AccountId32 , } , # [codec (index = 1)] LeafInsertion { tree_id : :: core :: primitive :: u32 , leaf_index : :: core :: primitive :: u32 , leaf : runtime_types :: egg_standalone_runtime :: protocol_substrate_config :: Element , } , }
            }
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct TreeMetadata<_0, _1, _2> {
                    pub creator: ::core::option::Option<_0>,
                    pub paused: ::core::primitive::bool,
                    pub leaf_count: _1,
                    pub max_leaves: _1,
                    pub depth: ::core::primitive::u8,
                    pub root: _2,
                    pub edge_nodes: ::std::vec::Vec<_2>,
                }
            }
        }
        pub mod pallet_offences {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Offence {
                        kind: [::core::primitive::u8; 16usize],
                        timeslot: ::std::vec::Vec<::core::primitive::u8>,
                    },
                }
            }
        }
        pub mod pallet_preimage {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    note_preimage {
                        bytes: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 1)]
                    unnote_preimage { hash: ::subxt::sp_core::H256 },
                    #[codec(index = 2)]
                    request_preimage { hash: ::subxt::sp_core::H256 },
                    #[codec(index = 3)]
                    unrequest_preimage { hash: ::subxt::sp_core::H256 },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    TooLarge,
                    #[codec(index = 1)]
                    AlreadyNoted,
                    #[codec(index = 2)]
                    NotAuthorized,
                    #[codec(index = 3)]
                    NotNoted,
                    #[codec(index = 4)]
                    Requested,
                    #[codec(index = 5)]
                    NotRequested,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Noted { hash: ::subxt::sp_core::H256 },
                    #[codec(index = 1)]
                    Requested { hash: ::subxt::sp_core::H256 },
                    #[codec(index = 2)]
                    Cleared { hash: ::subxt::sp_core::H256 },
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum RequestStatus<_0, _1> {
                #[codec(index = 0)]
                Unrequested(::core::option::Option<(_0, _1)>),
                #[codec(index = 1)]
                Requested(::core::primitive::u32),
            }
        }
        pub mod pallet_scheduler {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] schedule { when : :: core :: primitive :: u32 , maybe_periodic : :: core :: option :: Option < (:: core :: primitive :: u32 , :: core :: primitive :: u32 ,) > , priority : :: core :: primitive :: u8 , call : :: std :: boxed :: Box < runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 > > , } , # [codec (index = 1)] cancel { when : :: core :: primitive :: u32 , index : :: core :: primitive :: u32 , } , # [codec (index = 2)] schedule_named { id : :: std :: vec :: Vec < :: core :: primitive :: u8 > , when : :: core :: primitive :: u32 , maybe_periodic : :: core :: option :: Option < (:: core :: primitive :: u32 , :: core :: primitive :: u32 ,) > , priority : :: core :: primitive :: u8 , call : :: std :: boxed :: Box < runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 > > , } , # [codec (index = 3)] cancel_named { id : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 4)] schedule_after { after : :: core :: primitive :: u32 , maybe_periodic : :: core :: option :: Option < (:: core :: primitive :: u32 , :: core :: primitive :: u32 ,) > , priority : :: core :: primitive :: u8 , call : :: std :: boxed :: Box < runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 > > , } , # [codec (index = 5)] schedule_named_after { id : :: std :: vec :: Vec < :: core :: primitive :: u8 > , after : :: core :: primitive :: u32 , maybe_periodic : :: core :: option :: Option < (:: core :: primitive :: u32 , :: core :: primitive :: u32 ,) > , priority : :: core :: primitive :: u8 , call : :: std :: boxed :: Box < runtime_types :: frame_support :: traits :: schedule :: MaybeHashed < runtime_types :: egg_standalone_runtime :: Call , :: subxt :: sp_core :: H256 > > , } , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    FailedToSchedule,
                    #[codec(index = 1)]
                    NotFound,
                    #[codec(index = 2)]
                    TargetBlockNumberInPast,
                    #[codec(index = 3)]
                    RescheduleNoChange,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    # [codec (index = 0)] Scheduled { when : :: core :: primitive :: u32 , index : :: core :: primitive :: u32 , } , # [codec (index = 1)] Canceled { when : :: core :: primitive :: u32 , index : :: core :: primitive :: u32 , } , # [codec (index = 2)] Dispatched { task : (:: core :: primitive :: u32 , :: core :: primitive :: u32 ,) , id : :: core :: option :: Option < :: std :: vec :: Vec < :: core :: primitive :: u8 > > , result : :: core :: result :: Result < () , runtime_types :: sp_runtime :: DispatchError > , } , # [codec (index = 3)] CallLookupFailed { task : (:: core :: primitive :: u32 , :: core :: primitive :: u32 ,) , id : :: core :: option :: Option < :: std :: vec :: Vec < :: core :: primitive :: u8 > > , error : runtime_types :: frame_support :: traits :: schedule :: LookupError , } , }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ScheduledV3<_0, _1, _2, _3> {
                pub maybe_id: ::core::option::Option<
                    ::std::vec::Vec<::core::primitive::u8>,
                >,
                pub priority: ::core::primitive::u8,
                pub call: _0,
                pub maybe_periodic: ::core::option::Option<(_1, _1)>,
                pub origin: _2,
                #[codec(skip)]
                pub __subxt_unused_type_params: ::core::marker::PhantomData<_3>,
            }
        }
        pub mod pallet_session {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    # [codec (index = 0)] set_keys { keys : runtime_types :: egg_standalone_runtime :: opaque :: SessionKeys , proof : :: std :: vec :: Vec < :: core :: primitive :: u8 > , } , # [codec (index = 1)] purge_keys , }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidProof,
                    #[codec(index = 1)]
                    NoAssociatedValidatorId,
                    #[codec(index = 2)]
                    DuplicatedKey,
                    #[codec(index = 3)]
                    NoKeys,
                    #[codec(index = 4)]
                    NoAccount,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    NewSession {
                        session_index: ::core::primitive::u32,
                    },
                }
            }
        }
        pub mod pallet_signature_bridge {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    set_maintainer {
                        message: ::std::vec::Vec<::core::primitive::u8>,
                        signature: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 1)]
                    force_set_maintainer {
                        new_maintainer: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 2)]
                    set_resource {
                        id: [::core::primitive::u8; 32usize],
                        method: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 3)]
                    remove_resource {
                        id: [::core::primitive::u8; 32usize],
                    },
                    #[codec(index = 4)]
                    whitelist_chain { id: ::core::primitive::u64 },
                    #[codec(index = 5)]
                    execute_proposal {
                        src_id: ::core::primitive::u64,
                        call: ::std::boxed::Box<
                            runtime_types::egg_standalone_runtime::Call,
                        >,
                        proposal_data: ::std::vec::Vec<::core::primitive::u8>,
                        signature: ::std::vec::Vec<::core::primitive::u8>,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidPermissions,
                    #[codec(index = 1)]
                    InvalidChainId,
                    #[codec(index = 2)]
                    ChainNotWhitelisted,
                    #[codec(index = 3)]
                    ChainAlreadyWhitelisted,
                    #[codec(index = 4)]
                    ResourceDoesNotExist,
                    #[codec(index = 5)]
                    SignatureInvalid,
                    #[codec(index = 6)]
                    MustBeMaintainer,
                    #[codec(index = 7)]
                    ProposalAlreadyExists,
                    #[codec(index = 8)]
                    CallNotConsistentWithProposalData,
                    #[codec(index = 9)]
                    CallDoesNotMatchResourceId,
                    #[codec(index = 10)]
                    IncorrectExecutionChainIdType,
                    #[codec(index = 11)]
                    InvalidNonce,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    MaintainerSet {
                        old_maintainer: ::std::vec::Vec<::core::primitive::u8>,
                        new_maintainer: ::std::vec::Vec<::core::primitive::u8>,
                    },
                    #[codec(index = 1)]
                    ChainWhitelisted { chain_id: ::core::primitive::u64 },
                    #[codec(index = 2)]
                    ProposalApproved {
                        chain_id: ::core::primitive::u64,
                        proposal_nonce: ::core::primitive::u32,
                    },
                    #[codec(index = 3)]
                    ProposalSucceeded {
                        chain_id: ::core::primitive::u64,
                        proposal_nonce: ::core::primitive::u32,
                    },
                    #[codec(index = 4)]
                    ProposalFailed {
                        chain_id: ::core::primitive::u64,
                        proposal_nonce: ::core::primitive::u32,
                    },
                }
            }
        }
        pub mod pallet_staking {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                pub mod pallet {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub enum Call {
                        # [codec (index = 0)] bond { controller : :: subxt :: sp_runtime :: MultiAddress < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 > , # [codec (compact)] value : :: core :: primitive :: u128 , payee : runtime_types :: pallet_staking :: RewardDestination < :: subxt :: sp_core :: crypto :: AccountId32 > , } , # [codec (index = 1)] bond_extra { # [codec (compact)] max_additional : :: core :: primitive :: u128 , } , # [codec (index = 2)] unbond { # [codec (compact)] value : :: core :: primitive :: u128 , } , # [codec (index = 3)] withdraw_unbonded { num_slashing_spans : :: core :: primitive :: u32 , } , # [codec (index = 4)] validate { prefs : runtime_types :: pallet_staking :: ValidatorPrefs , } , # [codec (index = 5)] nominate { targets : :: std :: vec :: Vec < :: subxt :: sp_runtime :: MultiAddress < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 > > , } , # [codec (index = 6)] chill , # [codec (index = 7)] set_payee { payee : runtime_types :: pallet_staking :: RewardDestination < :: subxt :: sp_core :: crypto :: AccountId32 > , } , # [codec (index = 8)] set_controller { controller : :: subxt :: sp_runtime :: MultiAddress < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 > , } , # [codec (index = 9)] set_validator_count { # [codec (compact)] new : :: core :: primitive :: u32 , } , # [codec (index = 10)] increase_validator_count { # [codec (compact)] additional : :: core :: primitive :: u32 , } , # [codec (index = 11)] scale_validator_count { factor : runtime_types :: sp_arithmetic :: per_things :: Percent , } , # [codec (index = 12)] force_no_eras , # [codec (index = 13)] force_new_era , # [codec (index = 14)] set_invulnerables { invulnerables : :: std :: vec :: Vec < :: subxt :: sp_core :: crypto :: AccountId32 > , } , # [codec (index = 15)] force_unstake { stash : :: subxt :: sp_core :: crypto :: AccountId32 , num_slashing_spans : :: core :: primitive :: u32 , } , # [codec (index = 16)] force_new_era_always , # [codec (index = 17)] cancel_deferred_slash { era : :: core :: primitive :: u32 , slash_indices : :: std :: vec :: Vec < :: core :: primitive :: u32 > , } , # [codec (index = 18)] payout_stakers { validator_stash : :: subxt :: sp_core :: crypto :: AccountId32 , era : :: core :: primitive :: u32 , } , # [codec (index = 19)] rebond { # [codec (compact)] value : :: core :: primitive :: u128 , } , # [codec (index = 20)] set_history_depth { # [codec (compact)] new_history_depth : :: core :: primitive :: u32 , # [codec (compact)] era_items_deleted : :: core :: primitive :: u32 , } , # [codec (index = 21)] reap_stash { stash : :: subxt :: sp_core :: crypto :: AccountId32 , num_slashing_spans : :: core :: primitive :: u32 , } , # [codec (index = 22)] kick { who : :: std :: vec :: Vec < :: subxt :: sp_runtime :: MultiAddress < :: subxt :: sp_core :: crypto :: AccountId32 , :: core :: primitive :: u32 > > , } , # [codec (index = 23)] set_staking_configs { min_nominator_bond : :: core :: primitive :: u128 , min_validator_bond : :: core :: primitive :: u128 , max_nominator_count : :: core :: option :: Option < :: core :: primitive :: u32 > , max_validator_count : :: core :: option :: Option < :: core :: primitive :: u32 > , chill_threshold : :: core :: option :: Option < runtime_types :: sp_arithmetic :: per_things :: Percent > , min_commission : runtime_types :: sp_arithmetic :: per_things :: Perbill , } , # [codec (index = 24)] chill_other { controller : :: subxt :: sp_core :: crypto :: AccountId32 , } , # [codec (index = 25)] force_apply_min_commission { validator_stash : :: subxt :: sp_core :: crypto :: AccountId32 , } , }
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub enum Error {
                        #[codec(index = 0)]
                        NotController,
                        #[codec(index = 1)]
                        NotStash,
                        #[codec(index = 2)]
                        AlreadyBonded,
                        #[codec(index = 3)]
                        AlreadyPaired,
                        #[codec(index = 4)]
                        EmptyTargets,
                        #[codec(index = 5)]
                        DuplicateIndex,
                        #[codec(index = 6)]
                        InvalidSlashIndex,
                        #[codec(index = 7)]
                        InsufficientBond,
                        #[codec(index = 8)]
                        NoMoreChunks,
                        #[codec(index = 9)]
                        NoUnlockChunk,
                        #[codec(index = 10)]
                        FundedTarget,
                        #[codec(index = 11)]
                        InvalidEraToReward,
                        #[codec(index = 12)]
                        InvalidNumberOfNominations,
                        #[codec(index = 13)]
                        NotSortedAndUnique,
                        #[codec(index = 14)]
                        AlreadyClaimed,
                        #[codec(index = 15)]
                        IncorrectHistoryDepth,
                        #[codec(index = 16)]
                        IncorrectSlashingSpans,
                        #[codec(index = 17)]
                        BadState,
                        #[codec(index = 18)]
                        TooManyTargets,
                        #[codec(index = 19)]
                        BadTarget,
                        #[codec(index = 20)]
                        CannotChillOther,
                        #[codec(index = 21)]
                        TooManyNominators,
                        #[codec(index = 22)]
                        TooManyValidators,
                        #[codec(index = 23)]
                        CommissionTooLow,
                    }
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub enum Event {
                        #[codec(index = 0)]
                        EraPaid(
                            ::core::primitive::u32,
                            ::core::primitive::u128,
                            ::core::primitive::u128,
                        ),
                        #[codec(index = 1)]
                        Rewarded(
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        ),
                        #[codec(index = 2)]
                        Slashed(
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        ),
                        #[codec(index = 3)]
                        OldSlashingReportDiscarded(::core::primitive::u32),
                        #[codec(index = 4)]
                        StakersElected,
                        #[codec(index = 5)]
                        Bonded(
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        ),
                        #[codec(index = 6)]
                        Unbonded(
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        ),
                        #[codec(index = 7)]
                        Withdrawn(
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u128,
                        ),
                        #[codec(index = 8)]
                        Kicked(
                            ::subxt::sp_core::crypto::AccountId32,
                            ::subxt::sp_core::crypto::AccountId32,
                        ),
                        #[codec(index = 9)]
                        StakingElectionFailed,
                        #[codec(index = 10)]
                        Chilled(::subxt::sp_core::crypto::AccountId32),
                        #[codec(index = 11)]
                        PayoutStarted(
                            ::core::primitive::u32,
                            ::subxt::sp_core::crypto::AccountId32,
                        ),
                    }
                }
            }
            pub mod slashing {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct SlashingSpans {
                    pub span_index: ::core::primitive::u32,
                    pub last_start: ::core::primitive::u32,
                    pub last_nonzero_slash: ::core::primitive::u32,
                    pub prior: ::std::vec::Vec<::core::primitive::u32>,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct SpanRecord<_0> {
                    pub slashed: _0,
                    pub paid_out: _0,
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ActiveEraInfo {
                pub index: ::core::primitive::u32,
                pub start: ::core::option::Option<::core::primitive::u64>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct EraRewardPoints<_0> {
                pub total: ::core::primitive::u32,
                pub individual:
                    ::std::collections::BTreeMap<_0, ::core::primitive::u32>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Exposure<_0, _1> {
                #[codec(compact)]
                pub total: _1,
                #[codec(compact)]
                pub own: _1,
                pub others: ::std::vec::Vec<
                    runtime_types::pallet_staking::IndividualExposure<_0, _1>,
                >,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Forcing {
                #[codec(index = 0)]
                NotForcing,
                #[codec(index = 1)]
                ForceNew,
                #[codec(index = 2)]
                ForceNone,
                #[codec(index = 3)]
                ForceAlways,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct IndividualExposure<_0, _1> {
                pub who: _0,
                #[codec(compact)]
                pub value: _1,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Nominations { pub targets : runtime_types :: frame_support :: storage :: bounded_vec :: BoundedVec < :: subxt :: sp_core :: crypto :: AccountId32 > , pub submitted_in : :: core :: primitive :: u32 , pub suppressed : :: core :: primitive :: bool , }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Releases {
                #[codec(index = 0)]
                V1_0_0Ancient,
                #[codec(index = 1)]
                V2_0_0,
                #[codec(index = 2)]
                V3_0_0,
                #[codec(index = 3)]
                V4_0_0,
                #[codec(index = 4)]
                V5_0_0,
                #[codec(index = 5)]
                V6_0_0,
                #[codec(index = 6)]
                V7_0_0,
                #[codec(index = 7)]
                V8_0_0,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum RewardDestination<_0> {
                #[codec(index = 0)]
                Staked,
                #[codec(index = 1)]
                Stash,
                #[codec(index = 2)]
                Controller,
                #[codec(index = 3)]
                Account(_0),
                #[codec(index = 4)]
                None,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct StakingLedger<_0, _1> {
                pub stash: _0,
                #[codec(compact)]
                pub total: _1,
                #[codec(compact)]
                pub active: _1,
                pub unlocking: ::std::vec::Vec<
                    runtime_types::pallet_staking::UnlockChunk<_1>,
                >,
                pub claimed_rewards: ::std::vec::Vec<::core::primitive::u32>,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct UnappliedSlash<_0, _1> {
                pub validator: _0,
                pub own: _1,
                pub others: ::std::vec::Vec<(_0, _1)>,
                pub reporters: ::std::vec::Vec<_0>,
                pub payout: _1,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct UnlockChunk<_0> {
                #[codec(compact)]
                pub value: _0,
                #[codec(compact)]
                pub era: ::core::primitive::u32,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ValidatorPrefs {
                #[codec(compact)]
                pub commission:
                    runtime_types::sp_arithmetic::per_things::Perbill,
                pub blocked: ::core::primitive::bool,
            }
        }
        pub mod pallet_sudo {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    sudo {
                        call: ::std::boxed::Box<
                            runtime_types::egg_standalone_runtime::Call,
                        >,
                    },
                    #[codec(index = 1)]
                    sudo_unchecked_weight {
                        call: ::std::boxed::Box<
                            runtime_types::egg_standalone_runtime::Call,
                        >,
                        weight: ::core::primitive::u64,
                    },
                    #[codec(index = 2)]
                    set_key {
                        new: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                    },
                    #[codec(index = 3)]
                    sudo_as {
                        who: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                        call: ::std::boxed::Box<
                            runtime_types::egg_standalone_runtime::Call,
                        >,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    RequireSudo,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Sudid {
                        sudo_result: ::core::result::Result<
                            (),
                            runtime_types::sp_runtime::DispatchError,
                        >,
                    },
                    #[codec(index = 1)]
                    KeyChanged {
                        old_sudoer: ::core::option::Option<
                            ::subxt::sp_core::crypto::AccountId32,
                        >,
                    },
                    #[codec(index = 2)]
                    SudoAsDone {
                        sudo_result: ::core::result::Result<
                            (),
                            runtime_types::sp_runtime::DispatchError,
                        >,
                    },
                }
            }
        }
        pub mod pallet_timestamp {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    set {
                        #[codec(compact)]
                        now: ::core::primitive::u64,
                    },
                }
            }
        }
        pub mod pallet_token_wrapper {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    set_wrapping_fee {
                        fee: ::core::primitive::u128,
                        into_pool_share_id: ::core::primitive::u32,
                    },
                    #[codec(index = 1)]
                    wrap {
                        from_asset_id: ::core::primitive::u32,
                        into_pool_share_id: ::core::primitive::u32,
                        amount: ::core::primitive::u128,
                        recipient: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 2)]
                    unwrap {
                        from_pool_share_id: ::core::primitive::u32,
                        into_asset_id: ::core::primitive::u32,
                        amount: ::core::primitive::u128,
                        recipient: ::subxt::sp_core::crypto::AccountId32,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InvalidAmount,
                    #[codec(index = 1)]
                    UnregisteredAssetId,
                    #[codec(index = 2)]
                    NotFoundInPool,
                    #[codec(index = 3)]
                    InsufficientBalance,
                    #[codec(index = 4)]
                    NoWrappingFeePercentFound,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    WrappedToken {
                        pool_share_asset: ::core::primitive::u32,
                        asset_id: ::core::primitive::u32,
                        amount: ::core::primitive::u128,
                        recipient: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 1)]
                    UnwrappedToken {
                        pool_share_asset: ::core::primitive::u32,
                        asset_id: ::core::primitive::u32,
                        amount: ::core::primitive::u128,
                        recipient: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 2)]
                    UpdatedWrappingFeePercent {
                        into_pool_share_id: ::core::primitive::u32,
                        wrapping_fee_percent: ::core::primitive::u128,
                    },
                }
            }
        }
        pub mod pallet_transaction_payment {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ChargeTransactionPayment(
                #[codec(compact)] pub ::core::primitive::u128,
            );
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Releases {
                #[codec(index = 0)]
                V1Ancient,
                #[codec(index = 1)]
                V2,
            }
        }
        pub mod pallet_treasury {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    propose_spend {
                        #[codec(compact)]
                        value: ::core::primitive::u128,
                        beneficiary: ::subxt::sp_runtime::MultiAddress<
                            ::subxt::sp_core::crypto::AccountId32,
                            ::core::primitive::u32,
                        >,
                    },
                    #[codec(index = 1)]
                    reject_proposal {
                        #[codec(compact)]
                        proposal_id: ::core::primitive::u32,
                    },
                    #[codec(index = 2)]
                    approve_proposal {
                        #[codec(compact)]
                        proposal_id: ::core::primitive::u32,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    InsufficientProposersBalance,
                    #[codec(index = 1)]
                    InvalidIndex,
                    #[codec(index = 2)]
                    TooManyApprovals,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {
                    #[codec(index = 0)]
                    Proposed {
                        proposal_index: ::core::primitive::u32,
                    },
                    #[codec(index = 1)]
                    Spending {
                        budget_remaining: ::core::primitive::u128,
                    },
                    #[codec(index = 2)]
                    Awarded {
                        proposal_index: ::core::primitive::u32,
                        award: ::core::primitive::u128,
                        account: ::subxt::sp_core::crypto::AccountId32,
                    },
                    #[codec(index = 3)]
                    Rejected {
                        proposal_index: ::core::primitive::u32,
                        slashed: ::core::primitive::u128,
                    },
                    #[codec(index = 4)]
                    Burnt {
                        burnt_funds: ::core::primitive::u128,
                    },
                    #[codec(index = 5)]
                    Rollover {
                        rollover_balance: ::core::primitive::u128,
                    },
                    #[codec(index = 6)]
                    Deposit { value: ::core::primitive::u128 },
                }
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Proposal<_0, _1> {
                pub proposer: _0,
                pub value: _1,
                pub beneficiary: _0,
                pub bond: _1,
            }
        }
        pub mod pallet_verifier {
            use super::runtime_types;
            pub mod pallet {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Call {
                    #[codec(index = 0)]
                    force_set_parameters {
                        parameters: ::std::vec::Vec<::core::primitive::u8>,
                    },
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Error {
                    #[codec(index = 0)]
                    ParametersNotInitialized,
                    #[codec(index = 1)]
                    VerifyError,
                }
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum Event {}
            }
        }
        pub mod primitive_types {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct H256(pub [::core::primitive::u8; 32usize]);
        }
        pub mod sp_arithmetic {
            use super::runtime_types;
            pub mod fixed_point {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                    :: subxt :: codec :: CompactAs,
                )]
                pub struct FixedU128(pub ::core::primitive::u128);
            }
            pub mod per_things {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                    :: subxt :: codec :: CompactAs,
                )]
                pub struct PerU16(pub ::core::primitive::u16);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                    :: subxt :: codec :: CompactAs,
                )]
                pub struct Perbill(pub ::core::primitive::u32);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                    :: subxt :: codec :: CompactAs,
                )]
                pub struct Percent(pub ::core::primitive::u8);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                    :: subxt :: codec :: CompactAs,
                )]
                pub struct Permill(pub ::core::primitive::u32);
            }
        }
        pub mod sp_consensus_aura {
            use super::runtime_types;
            pub mod sr25519 {
                use super::runtime_types;
                pub mod app_sr25519 {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct Public(
                        pub runtime_types::sp_core::sr25519::Public,
                    );
                }
            }
        }
        pub mod sp_consensus_slots {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
                :: subxt :: codec :: CompactAs,
            )]
            pub struct Slot(pub ::core::primitive::u64);
        }
        pub mod sp_core {
            use super::runtime_types;
            pub mod crypto {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct AccountId32(pub [::core::primitive::u8; 32usize]);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct KeyTypeId(pub [::core::primitive::u8; 4usize]);
            }
            pub mod ecdsa {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Public(pub [::core::primitive::u8; 33usize]);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Signature(pub [::core::primitive::u8; 65usize]);
            }
            pub mod ed25519 {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Public(pub [::core::primitive::u8; 32usize]);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Signature(pub [::core::primitive::u8; 64usize]);
            }
            pub mod sr25519 {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Public(pub [::core::primitive::u8; 32usize]);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Signature(pub [::core::primitive::u8; 64usize]);
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Void {}
        }
        pub mod sp_finality_grandpa {
            use super::runtime_types;
            pub mod app {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Public(pub runtime_types::sp_core::ed25519::Public);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct Signature(
                    pub runtime_types::sp_core::ed25519::Signature,
                );
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum Equivocation<_0, _1> {
                #[codec(index = 0)]
                Prevote(
                    runtime_types::finality_grandpa::Equivocation<
                        runtime_types::sp_finality_grandpa::app::Public,
                        runtime_types::finality_grandpa::Prevote<_0, _1>,
                        runtime_types::sp_finality_grandpa::app::Signature,
                    >,
                ),
                #[codec(index = 1)]
                Precommit(
                    runtime_types::finality_grandpa::Equivocation<
                        runtime_types::sp_finality_grandpa::app::Public,
                        runtime_types::finality_grandpa::Precommit<_0, _1>,
                        runtime_types::sp_finality_grandpa::app::Signature,
                    >,
                ),
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct EquivocationProof<_0, _1> {
                pub set_id: ::core::primitive::u64,
                pub equivocation:
                    runtime_types::sp_finality_grandpa::Equivocation<_0, _1>,
            }
        }
        pub mod sp_npos_elections {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct Support<_0> {
                pub total: ::core::primitive::u128,
                pub voters: ::std::vec::Vec<(_0, ::core::primitive::u128)>,
            }
        }
        pub mod sp_runtime {
            use super::runtime_types;
            pub mod generic {
                use super::runtime_types;
                pub mod digest {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct Digest { pub logs : :: std :: vec :: Vec < runtime_types :: sp_runtime :: generic :: digest :: DigestItem > , }
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub enum DigestItem {
                        #[codec(index = 6)]
                        PreRuntime(
                            [::core::primitive::u8; 4usize],
                            ::std::vec::Vec<::core::primitive::u8>,
                        ),
                        #[codec(index = 4)]
                        Consensus(
                            [::core::primitive::u8; 4usize],
                            ::std::vec::Vec<::core::primitive::u8>,
                        ),
                        #[codec(index = 5)]
                        Seal(
                            [::core::primitive::u8; 4usize],
                            ::std::vec::Vec<::core::primitive::u8>,
                        ),
                        #[codec(index = 0)]
                        Other(::std::vec::Vec<::core::primitive::u8>),
                        #[codec(index = 8)]
                        RuntimeEnvironmentUpdated,
                    }
                }
                pub mod era {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub enum Era {
                        #[codec(index = 0)]
                        Immortal,
                        #[codec(index = 1)]
                        Mortal1(::core::primitive::u8),
                        #[codec(index = 2)]
                        Mortal2(::core::primitive::u8),
                        #[codec(index = 3)]
                        Mortal3(::core::primitive::u8),
                        #[codec(index = 4)]
                        Mortal4(::core::primitive::u8),
                        #[codec(index = 5)]
                        Mortal5(::core::primitive::u8),
                        #[codec(index = 6)]
                        Mortal6(::core::primitive::u8),
                        #[codec(index = 7)]
                        Mortal7(::core::primitive::u8),
                        #[codec(index = 8)]
                        Mortal8(::core::primitive::u8),
                        #[codec(index = 9)]
                        Mortal9(::core::primitive::u8),
                        #[codec(index = 10)]
                        Mortal10(::core::primitive::u8),
                        #[codec(index = 11)]
                        Mortal11(::core::primitive::u8),
                        #[codec(index = 12)]
                        Mortal12(::core::primitive::u8),
                        #[codec(index = 13)]
                        Mortal13(::core::primitive::u8),
                        #[codec(index = 14)]
                        Mortal14(::core::primitive::u8),
                        #[codec(index = 15)]
                        Mortal15(::core::primitive::u8),
                        #[codec(index = 16)]
                        Mortal16(::core::primitive::u8),
                        #[codec(index = 17)]
                        Mortal17(::core::primitive::u8),
                        #[codec(index = 18)]
                        Mortal18(::core::primitive::u8),
                        #[codec(index = 19)]
                        Mortal19(::core::primitive::u8),
                        #[codec(index = 20)]
                        Mortal20(::core::primitive::u8),
                        #[codec(index = 21)]
                        Mortal21(::core::primitive::u8),
                        #[codec(index = 22)]
                        Mortal22(::core::primitive::u8),
                        #[codec(index = 23)]
                        Mortal23(::core::primitive::u8),
                        #[codec(index = 24)]
                        Mortal24(::core::primitive::u8),
                        #[codec(index = 25)]
                        Mortal25(::core::primitive::u8),
                        #[codec(index = 26)]
                        Mortal26(::core::primitive::u8),
                        #[codec(index = 27)]
                        Mortal27(::core::primitive::u8),
                        #[codec(index = 28)]
                        Mortal28(::core::primitive::u8),
                        #[codec(index = 29)]
                        Mortal29(::core::primitive::u8),
                        #[codec(index = 30)]
                        Mortal30(::core::primitive::u8),
                        #[codec(index = 31)]
                        Mortal31(::core::primitive::u8),
                        #[codec(index = 32)]
                        Mortal32(::core::primitive::u8),
                        #[codec(index = 33)]
                        Mortal33(::core::primitive::u8),
                        #[codec(index = 34)]
                        Mortal34(::core::primitive::u8),
                        #[codec(index = 35)]
                        Mortal35(::core::primitive::u8),
                        #[codec(index = 36)]
                        Mortal36(::core::primitive::u8),
                        #[codec(index = 37)]
                        Mortal37(::core::primitive::u8),
                        #[codec(index = 38)]
                        Mortal38(::core::primitive::u8),
                        #[codec(index = 39)]
                        Mortal39(::core::primitive::u8),
                        #[codec(index = 40)]
                        Mortal40(::core::primitive::u8),
                        #[codec(index = 41)]
                        Mortal41(::core::primitive::u8),
                        #[codec(index = 42)]
                        Mortal42(::core::primitive::u8),
                        #[codec(index = 43)]
                        Mortal43(::core::primitive::u8),
                        #[codec(index = 44)]
                        Mortal44(::core::primitive::u8),
                        #[codec(index = 45)]
                        Mortal45(::core::primitive::u8),
                        #[codec(index = 46)]
                        Mortal46(::core::primitive::u8),
                        #[codec(index = 47)]
                        Mortal47(::core::primitive::u8),
                        #[codec(index = 48)]
                        Mortal48(::core::primitive::u8),
                        #[codec(index = 49)]
                        Mortal49(::core::primitive::u8),
                        #[codec(index = 50)]
                        Mortal50(::core::primitive::u8),
                        #[codec(index = 51)]
                        Mortal51(::core::primitive::u8),
                        #[codec(index = 52)]
                        Mortal52(::core::primitive::u8),
                        #[codec(index = 53)]
                        Mortal53(::core::primitive::u8),
                        #[codec(index = 54)]
                        Mortal54(::core::primitive::u8),
                        #[codec(index = 55)]
                        Mortal55(::core::primitive::u8),
                        #[codec(index = 56)]
                        Mortal56(::core::primitive::u8),
                        #[codec(index = 57)]
                        Mortal57(::core::primitive::u8),
                        #[codec(index = 58)]
                        Mortal58(::core::primitive::u8),
                        #[codec(index = 59)]
                        Mortal59(::core::primitive::u8),
                        #[codec(index = 60)]
                        Mortal60(::core::primitive::u8),
                        #[codec(index = 61)]
                        Mortal61(::core::primitive::u8),
                        #[codec(index = 62)]
                        Mortal62(::core::primitive::u8),
                        #[codec(index = 63)]
                        Mortal63(::core::primitive::u8),
                        #[codec(index = 64)]
                        Mortal64(::core::primitive::u8),
                        #[codec(index = 65)]
                        Mortal65(::core::primitive::u8),
                        #[codec(index = 66)]
                        Mortal66(::core::primitive::u8),
                        #[codec(index = 67)]
                        Mortal67(::core::primitive::u8),
                        #[codec(index = 68)]
                        Mortal68(::core::primitive::u8),
                        #[codec(index = 69)]
                        Mortal69(::core::primitive::u8),
                        #[codec(index = 70)]
                        Mortal70(::core::primitive::u8),
                        #[codec(index = 71)]
                        Mortal71(::core::primitive::u8),
                        #[codec(index = 72)]
                        Mortal72(::core::primitive::u8),
                        #[codec(index = 73)]
                        Mortal73(::core::primitive::u8),
                        #[codec(index = 74)]
                        Mortal74(::core::primitive::u8),
                        #[codec(index = 75)]
                        Mortal75(::core::primitive::u8),
                        #[codec(index = 76)]
                        Mortal76(::core::primitive::u8),
                        #[codec(index = 77)]
                        Mortal77(::core::primitive::u8),
                        #[codec(index = 78)]
                        Mortal78(::core::primitive::u8),
                        #[codec(index = 79)]
                        Mortal79(::core::primitive::u8),
                        #[codec(index = 80)]
                        Mortal80(::core::primitive::u8),
                        #[codec(index = 81)]
                        Mortal81(::core::primitive::u8),
                        #[codec(index = 82)]
                        Mortal82(::core::primitive::u8),
                        #[codec(index = 83)]
                        Mortal83(::core::primitive::u8),
                        #[codec(index = 84)]
                        Mortal84(::core::primitive::u8),
                        #[codec(index = 85)]
                        Mortal85(::core::primitive::u8),
                        #[codec(index = 86)]
                        Mortal86(::core::primitive::u8),
                        #[codec(index = 87)]
                        Mortal87(::core::primitive::u8),
                        #[codec(index = 88)]
                        Mortal88(::core::primitive::u8),
                        #[codec(index = 89)]
                        Mortal89(::core::primitive::u8),
                        #[codec(index = 90)]
                        Mortal90(::core::primitive::u8),
                        #[codec(index = 91)]
                        Mortal91(::core::primitive::u8),
                        #[codec(index = 92)]
                        Mortal92(::core::primitive::u8),
                        #[codec(index = 93)]
                        Mortal93(::core::primitive::u8),
                        #[codec(index = 94)]
                        Mortal94(::core::primitive::u8),
                        #[codec(index = 95)]
                        Mortal95(::core::primitive::u8),
                        #[codec(index = 96)]
                        Mortal96(::core::primitive::u8),
                        #[codec(index = 97)]
                        Mortal97(::core::primitive::u8),
                        #[codec(index = 98)]
                        Mortal98(::core::primitive::u8),
                        #[codec(index = 99)]
                        Mortal99(::core::primitive::u8),
                        #[codec(index = 100)]
                        Mortal100(::core::primitive::u8),
                        #[codec(index = 101)]
                        Mortal101(::core::primitive::u8),
                        #[codec(index = 102)]
                        Mortal102(::core::primitive::u8),
                        #[codec(index = 103)]
                        Mortal103(::core::primitive::u8),
                        #[codec(index = 104)]
                        Mortal104(::core::primitive::u8),
                        #[codec(index = 105)]
                        Mortal105(::core::primitive::u8),
                        #[codec(index = 106)]
                        Mortal106(::core::primitive::u8),
                        #[codec(index = 107)]
                        Mortal107(::core::primitive::u8),
                        #[codec(index = 108)]
                        Mortal108(::core::primitive::u8),
                        #[codec(index = 109)]
                        Mortal109(::core::primitive::u8),
                        #[codec(index = 110)]
                        Mortal110(::core::primitive::u8),
                        #[codec(index = 111)]
                        Mortal111(::core::primitive::u8),
                        #[codec(index = 112)]
                        Mortal112(::core::primitive::u8),
                        #[codec(index = 113)]
                        Mortal113(::core::primitive::u8),
                        #[codec(index = 114)]
                        Mortal114(::core::primitive::u8),
                        #[codec(index = 115)]
                        Mortal115(::core::primitive::u8),
                        #[codec(index = 116)]
                        Mortal116(::core::primitive::u8),
                        #[codec(index = 117)]
                        Mortal117(::core::primitive::u8),
                        #[codec(index = 118)]
                        Mortal118(::core::primitive::u8),
                        #[codec(index = 119)]
                        Mortal119(::core::primitive::u8),
                        #[codec(index = 120)]
                        Mortal120(::core::primitive::u8),
                        #[codec(index = 121)]
                        Mortal121(::core::primitive::u8),
                        #[codec(index = 122)]
                        Mortal122(::core::primitive::u8),
                        #[codec(index = 123)]
                        Mortal123(::core::primitive::u8),
                        #[codec(index = 124)]
                        Mortal124(::core::primitive::u8),
                        #[codec(index = 125)]
                        Mortal125(::core::primitive::u8),
                        #[codec(index = 126)]
                        Mortal126(::core::primitive::u8),
                        #[codec(index = 127)]
                        Mortal127(::core::primitive::u8),
                        #[codec(index = 128)]
                        Mortal128(::core::primitive::u8),
                        #[codec(index = 129)]
                        Mortal129(::core::primitive::u8),
                        #[codec(index = 130)]
                        Mortal130(::core::primitive::u8),
                        #[codec(index = 131)]
                        Mortal131(::core::primitive::u8),
                        #[codec(index = 132)]
                        Mortal132(::core::primitive::u8),
                        #[codec(index = 133)]
                        Mortal133(::core::primitive::u8),
                        #[codec(index = 134)]
                        Mortal134(::core::primitive::u8),
                        #[codec(index = 135)]
                        Mortal135(::core::primitive::u8),
                        #[codec(index = 136)]
                        Mortal136(::core::primitive::u8),
                        #[codec(index = 137)]
                        Mortal137(::core::primitive::u8),
                        #[codec(index = 138)]
                        Mortal138(::core::primitive::u8),
                        #[codec(index = 139)]
                        Mortal139(::core::primitive::u8),
                        #[codec(index = 140)]
                        Mortal140(::core::primitive::u8),
                        #[codec(index = 141)]
                        Mortal141(::core::primitive::u8),
                        #[codec(index = 142)]
                        Mortal142(::core::primitive::u8),
                        #[codec(index = 143)]
                        Mortal143(::core::primitive::u8),
                        #[codec(index = 144)]
                        Mortal144(::core::primitive::u8),
                        #[codec(index = 145)]
                        Mortal145(::core::primitive::u8),
                        #[codec(index = 146)]
                        Mortal146(::core::primitive::u8),
                        #[codec(index = 147)]
                        Mortal147(::core::primitive::u8),
                        #[codec(index = 148)]
                        Mortal148(::core::primitive::u8),
                        #[codec(index = 149)]
                        Mortal149(::core::primitive::u8),
                        #[codec(index = 150)]
                        Mortal150(::core::primitive::u8),
                        #[codec(index = 151)]
                        Mortal151(::core::primitive::u8),
                        #[codec(index = 152)]
                        Mortal152(::core::primitive::u8),
                        #[codec(index = 153)]
                        Mortal153(::core::primitive::u8),
                        #[codec(index = 154)]
                        Mortal154(::core::primitive::u8),
                        #[codec(index = 155)]
                        Mortal155(::core::primitive::u8),
                        #[codec(index = 156)]
                        Mortal156(::core::primitive::u8),
                        #[codec(index = 157)]
                        Mortal157(::core::primitive::u8),
                        #[codec(index = 158)]
                        Mortal158(::core::primitive::u8),
                        #[codec(index = 159)]
                        Mortal159(::core::primitive::u8),
                        #[codec(index = 160)]
                        Mortal160(::core::primitive::u8),
                        #[codec(index = 161)]
                        Mortal161(::core::primitive::u8),
                        #[codec(index = 162)]
                        Mortal162(::core::primitive::u8),
                        #[codec(index = 163)]
                        Mortal163(::core::primitive::u8),
                        #[codec(index = 164)]
                        Mortal164(::core::primitive::u8),
                        #[codec(index = 165)]
                        Mortal165(::core::primitive::u8),
                        #[codec(index = 166)]
                        Mortal166(::core::primitive::u8),
                        #[codec(index = 167)]
                        Mortal167(::core::primitive::u8),
                        #[codec(index = 168)]
                        Mortal168(::core::primitive::u8),
                        #[codec(index = 169)]
                        Mortal169(::core::primitive::u8),
                        #[codec(index = 170)]
                        Mortal170(::core::primitive::u8),
                        #[codec(index = 171)]
                        Mortal171(::core::primitive::u8),
                        #[codec(index = 172)]
                        Mortal172(::core::primitive::u8),
                        #[codec(index = 173)]
                        Mortal173(::core::primitive::u8),
                        #[codec(index = 174)]
                        Mortal174(::core::primitive::u8),
                        #[codec(index = 175)]
                        Mortal175(::core::primitive::u8),
                        #[codec(index = 176)]
                        Mortal176(::core::primitive::u8),
                        #[codec(index = 177)]
                        Mortal177(::core::primitive::u8),
                        #[codec(index = 178)]
                        Mortal178(::core::primitive::u8),
                        #[codec(index = 179)]
                        Mortal179(::core::primitive::u8),
                        #[codec(index = 180)]
                        Mortal180(::core::primitive::u8),
                        #[codec(index = 181)]
                        Mortal181(::core::primitive::u8),
                        #[codec(index = 182)]
                        Mortal182(::core::primitive::u8),
                        #[codec(index = 183)]
                        Mortal183(::core::primitive::u8),
                        #[codec(index = 184)]
                        Mortal184(::core::primitive::u8),
                        #[codec(index = 185)]
                        Mortal185(::core::primitive::u8),
                        #[codec(index = 186)]
                        Mortal186(::core::primitive::u8),
                        #[codec(index = 187)]
                        Mortal187(::core::primitive::u8),
                        #[codec(index = 188)]
                        Mortal188(::core::primitive::u8),
                        #[codec(index = 189)]
                        Mortal189(::core::primitive::u8),
                        #[codec(index = 190)]
                        Mortal190(::core::primitive::u8),
                        #[codec(index = 191)]
                        Mortal191(::core::primitive::u8),
                        #[codec(index = 192)]
                        Mortal192(::core::primitive::u8),
                        #[codec(index = 193)]
                        Mortal193(::core::primitive::u8),
                        #[codec(index = 194)]
                        Mortal194(::core::primitive::u8),
                        #[codec(index = 195)]
                        Mortal195(::core::primitive::u8),
                        #[codec(index = 196)]
                        Mortal196(::core::primitive::u8),
                        #[codec(index = 197)]
                        Mortal197(::core::primitive::u8),
                        #[codec(index = 198)]
                        Mortal198(::core::primitive::u8),
                        #[codec(index = 199)]
                        Mortal199(::core::primitive::u8),
                        #[codec(index = 200)]
                        Mortal200(::core::primitive::u8),
                        #[codec(index = 201)]
                        Mortal201(::core::primitive::u8),
                        #[codec(index = 202)]
                        Mortal202(::core::primitive::u8),
                        #[codec(index = 203)]
                        Mortal203(::core::primitive::u8),
                        #[codec(index = 204)]
                        Mortal204(::core::primitive::u8),
                        #[codec(index = 205)]
                        Mortal205(::core::primitive::u8),
                        #[codec(index = 206)]
                        Mortal206(::core::primitive::u8),
                        #[codec(index = 207)]
                        Mortal207(::core::primitive::u8),
                        #[codec(index = 208)]
                        Mortal208(::core::primitive::u8),
                        #[codec(index = 209)]
                        Mortal209(::core::primitive::u8),
                        #[codec(index = 210)]
                        Mortal210(::core::primitive::u8),
                        #[codec(index = 211)]
                        Mortal211(::core::primitive::u8),
                        #[codec(index = 212)]
                        Mortal212(::core::primitive::u8),
                        #[codec(index = 213)]
                        Mortal213(::core::primitive::u8),
                        #[codec(index = 214)]
                        Mortal214(::core::primitive::u8),
                        #[codec(index = 215)]
                        Mortal215(::core::primitive::u8),
                        #[codec(index = 216)]
                        Mortal216(::core::primitive::u8),
                        #[codec(index = 217)]
                        Mortal217(::core::primitive::u8),
                        #[codec(index = 218)]
                        Mortal218(::core::primitive::u8),
                        #[codec(index = 219)]
                        Mortal219(::core::primitive::u8),
                        #[codec(index = 220)]
                        Mortal220(::core::primitive::u8),
                        #[codec(index = 221)]
                        Mortal221(::core::primitive::u8),
                        #[codec(index = 222)]
                        Mortal222(::core::primitive::u8),
                        #[codec(index = 223)]
                        Mortal223(::core::primitive::u8),
                        #[codec(index = 224)]
                        Mortal224(::core::primitive::u8),
                        #[codec(index = 225)]
                        Mortal225(::core::primitive::u8),
                        #[codec(index = 226)]
                        Mortal226(::core::primitive::u8),
                        #[codec(index = 227)]
                        Mortal227(::core::primitive::u8),
                        #[codec(index = 228)]
                        Mortal228(::core::primitive::u8),
                        #[codec(index = 229)]
                        Mortal229(::core::primitive::u8),
                        #[codec(index = 230)]
                        Mortal230(::core::primitive::u8),
                        #[codec(index = 231)]
                        Mortal231(::core::primitive::u8),
                        #[codec(index = 232)]
                        Mortal232(::core::primitive::u8),
                        #[codec(index = 233)]
                        Mortal233(::core::primitive::u8),
                        #[codec(index = 234)]
                        Mortal234(::core::primitive::u8),
                        #[codec(index = 235)]
                        Mortal235(::core::primitive::u8),
                        #[codec(index = 236)]
                        Mortal236(::core::primitive::u8),
                        #[codec(index = 237)]
                        Mortal237(::core::primitive::u8),
                        #[codec(index = 238)]
                        Mortal238(::core::primitive::u8),
                        #[codec(index = 239)]
                        Mortal239(::core::primitive::u8),
                        #[codec(index = 240)]
                        Mortal240(::core::primitive::u8),
                        #[codec(index = 241)]
                        Mortal241(::core::primitive::u8),
                        #[codec(index = 242)]
                        Mortal242(::core::primitive::u8),
                        #[codec(index = 243)]
                        Mortal243(::core::primitive::u8),
                        #[codec(index = 244)]
                        Mortal244(::core::primitive::u8),
                        #[codec(index = 245)]
                        Mortal245(::core::primitive::u8),
                        #[codec(index = 246)]
                        Mortal246(::core::primitive::u8),
                        #[codec(index = 247)]
                        Mortal247(::core::primitive::u8),
                        #[codec(index = 248)]
                        Mortal248(::core::primitive::u8),
                        #[codec(index = 249)]
                        Mortal249(::core::primitive::u8),
                        #[codec(index = 250)]
                        Mortal250(::core::primitive::u8),
                        #[codec(index = 251)]
                        Mortal251(::core::primitive::u8),
                        #[codec(index = 252)]
                        Mortal252(::core::primitive::u8),
                        #[codec(index = 253)]
                        Mortal253(::core::primitive::u8),
                        #[codec(index = 254)]
                        Mortal254(::core::primitive::u8),
                        #[codec(index = 255)]
                        Mortal255(::core::primitive::u8),
                    }
                }
                pub mod header {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct Header<_0, _1> {
                        pub parent_hash: ::subxt::sp_core::H256,
                        #[codec(compact)]
                        pub number: _0,
                        pub state_root: ::subxt::sp_core::H256,
                        pub extrinsics_root: ::subxt::sp_core::H256,
                        pub digest:
                            runtime_types::sp_runtime::generic::digest::Digest,
                        #[codec(skip)]
                        pub __subxt_unused_type_params:
                            ::core::marker::PhantomData<_1>,
                    }
                }
                pub mod unchecked_extrinsic {
                    use super::runtime_types;
                    #[derive(
                        :: subxt :: codec :: Encode,
                        :: subxt :: codec :: Decode,
                        Debug,
                        Eq,
                        PartialEq,
                        Clone,
                    )]
                    pub struct UncheckedExtrinsic<_0, _1, _2, _3>(
                        pub ::std::vec::Vec<::core::primitive::u8>,
                        #[codec(skip)]
                        pub  ::core::marker::PhantomData<(_1, _0, _2, _3)>,
                    );
                }
            }
            pub mod multiaddress {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum MultiAddress<_0, _1> {
                    #[codec(index = 0)]
                    Id(_0),
                    #[codec(index = 1)]
                    Index(#[codec(compact)] _1),
                    #[codec(index = 2)]
                    Raw(::std::vec::Vec<::core::primitive::u8>),
                    #[codec(index = 3)]
                    Address32([::core::primitive::u8; 32usize]),
                    #[codec(index = 4)]
                    Address20([::core::primitive::u8; 20usize]),
                }
            }
            pub mod traits {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct BlakeTwo256;
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum ArithmeticError {
                #[codec(index = 0)]
                Underflow,
                #[codec(index = 1)]
                Overflow,
                #[codec(index = 2)]
                DivisionByZero,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum DispatchError {
                #[codec(index = 0)]
                Other,
                #[codec(index = 1)]
                CannotLookup,
                #[codec(index = 2)]
                BadOrigin,
                #[codec(index = 3)]
                Module(runtime_types::sp_runtime::ModuleError),
                #[codec(index = 4)]
                ConsumerRemaining,
                #[codec(index = 5)]
                NoProviders,
                #[codec(index = 6)]
                TooManyConsumers,
                #[codec(index = 7)]
                Token(runtime_types::sp_runtime::TokenError),
                #[codec(index = 8)]
                Arithmetic(runtime_types::sp_runtime::ArithmeticError),
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct ModuleError {
                pub index: ::core::primitive::u8,
                pub error: ::core::primitive::u8,
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum MultiSignature {
                #[codec(index = 0)]
                Ed25519(runtime_types::sp_core::ed25519::Signature),
                #[codec(index = 1)]
                Sr25519(runtime_types::sp_core::sr25519::Signature),
                #[codec(index = 2)]
                Ecdsa(runtime_types::sp_core::ecdsa::Signature),
            }
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub enum TokenError {
                #[codec(index = 0)]
                NoFunds,
                #[codec(index = 1)]
                WouldDie,
                #[codec(index = 2)]
                BelowMinimum,
                #[codec(index = 3)]
                CannotCreate,
                #[codec(index = 4)]
                UnknownAsset,
                #[codec(index = 5)]
                Frozen,
                #[codec(index = 6)]
                Unsupported,
            }
        }
        pub mod sp_session {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct MembershipProof {
                pub session: ::core::primitive::u32,
                pub trie_nodes:
                    ::std::vec::Vec<::std::vec::Vec<::core::primitive::u8>>,
                pub validator_count: ::core::primitive::u32,
            }
        }
        pub mod sp_staking {
            use super::runtime_types;
            pub mod offence {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct OffenceDetails<_0, _1> {
                    pub offender: _1,
                    pub reporters: ::std::vec::Vec<_0>,
                }
            }
        }
        pub mod sp_version {
            use super::runtime_types;
            #[derive(
                :: subxt :: codec :: Encode,
                :: subxt :: codec :: Decode,
                Debug,
                Eq,
                PartialEq,
                Clone,
            )]
            pub struct RuntimeVersion {
                pub spec_name: ::std::string::String,
                pub impl_name: ::std::string::String,
                pub authoring_version: ::core::primitive::u32,
                pub spec_version: ::core::primitive::u32,
                pub impl_version: ::core::primitive::u32,
                pub apis: ::std::vec::Vec<(
                    [::core::primitive::u8; 8usize],
                    ::core::primitive::u32,
                )>,
                pub transaction_version: ::core::primitive::u32,
                pub state_version: ::core::primitive::u8,
            }
        }
        pub mod webb_primitives {
            use super::runtime_types;
            pub mod types {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct DepositDetails<_0, _1> {
                    pub depositor: _0,
                    pub deposit: _1,
                }
            }
        }
        pub mod webb_proposals {
            use super::runtime_types;
            pub mod header {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub struct ResourceId(pub [::core::primitive::u8; 32usize]);
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                )]
                pub enum TypedChainId {
                    #[codec(index = 0)]
                    None,
                    #[codec(index = 1)]
                    Evm(::core::primitive::u32),
                    #[codec(index = 2)]
                    Substrate(::core::primitive::u32),
                    #[codec(index = 3)]
                    PolkadotParachain(::core::primitive::u32),
                    #[codec(index = 4)]
                    KusamaParachain(::core::primitive::u32),
                    #[codec(index = 5)]
                    RococoParachain(::core::primitive::u32),
                    #[codec(index = 6)]
                    Cosmos(::core::primitive::u32),
                    #[codec(index = 7)]
                    Solana(::core::primitive::u32),
                }
            }
            pub mod nonce {
                use super::runtime_types;
                #[derive(
                    :: subxt :: codec :: Encode,
                    :: subxt :: codec :: Decode,
                    Debug,
                    Eq,
                    PartialEq,
                    Clone,
                    :: subxt :: codec :: CompactAs,
                )]
                pub struct Nonce(pub ::core::primitive::u32);
            }
        }
    }
    #[doc = r" The default error type returned when there is a runtime issue."]
    pub type DispatchError = self::runtime_types::sp_runtime::DispatchError;
    pub struct ErrorDetails {
        pub pallet: &'static str,
        pub error: &'static str,
        pub docs: &'static str,
    }
    impl DispatchError {
        pub fn details(&self) -> Option<ErrorDetails> {
            if let Self::Module(v) = self {
                match (v.index , v.error) { (0u8 , 0u8) => Some (ErrorDetails { pallet : "System" , error : "InvalidSpecName" , docs : "The name of specification does not match between the current runtime\nand the new runtime." }) , (0u8 , 1u8) => Some (ErrorDetails { pallet : "System" , error : "SpecVersionNeedsToIncrease" , docs : "The specification version is not allowed to decrease between the current runtime\nand the new runtime." }) , (0u8 , 2u8) => Some (ErrorDetails { pallet : "System" , error : "FailedToExtractRuntimeVersion" , docs : "Failed to extract the runtime version from the new runtime.\n\nEither calling `Core_version` or decoding `RuntimeVersion` failed." }) , (0u8 , 3u8) => Some (ErrorDetails { pallet : "System" , error : "NonDefaultComposite" , docs : "Suicide called when the account has non-default composite data." }) , (0u8 , 4u8) => Some (ErrorDetails { pallet : "System" , error : "NonZeroRefCount" , docs : "There is a non-zero reference count preventing the account from being purged." }) , (0u8 , 5u8) => Some (ErrorDetails { pallet : "System" , error : "CallFiltered" , docs : "The origin filter prevent the call to be dispatched." }) , (2u8 , 0u8) => Some (ErrorDetails { pallet : "Sudo" , error : "RequireSudo" , docs : "Sender must be the Sudo account" }) , (4u8 , 0u8) => Some (ErrorDetails { pallet : "Balances" , error : "VestingBalance" , docs : "Vesting balance too high to send value" }) , (4u8 , 1u8) => Some (ErrorDetails { pallet : "Balances" , error : "LiquidityRestrictions" , docs : "Account liquidity restrictions prevent withdrawal" }) , (4u8 , 2u8) => Some (ErrorDetails { pallet : "Balances" , error : "InsufficientBalance" , docs : "Balance too low to send value" }) , (4u8 , 3u8) => Some (ErrorDetails { pallet : "Balances" , error : "ExistentialDeposit" , docs : "Value too low to create account due to existential deposit" }) , (4u8 , 4u8) => Some (ErrorDetails { pallet : "Balances" , error : "KeepAlive" , docs : "Transfer/payment would kill account" }) , (4u8 , 5u8) => Some (ErrorDetails { pallet : "Balances" , error : "ExistingVestingSchedule" , docs : "A vesting schedule already exists for this account" }) , (4u8 , 6u8) => Some (ErrorDetails { pallet : "Balances" , error : "DeadAccount" , docs : "Beneficiary account must pre-exist" }) , (4u8 , 7u8) => Some (ErrorDetails { pallet : "Balances" , error : "TooManyReserves" , docs : "Number of named reserves exceed MaxReserves" }) , (6u8 , 0u8) => Some (ErrorDetails { pallet : "Authorship" , error : "InvalidUncleParent" , docs : "The uncle parent not in the chain." }) , (6u8 , 1u8) => Some (ErrorDetails { pallet : "Authorship" , error : "UnclesAlreadySet" , docs : "Uncles already set in the block." }) , (6u8 , 2u8) => Some (ErrorDetails { pallet : "Authorship" , error : "TooManyUncles" , docs : "Too many uncles." }) , (6u8 , 3u8) => Some (ErrorDetails { pallet : "Authorship" , error : "GenesisUncle" , docs : "The uncle is genesis." }) , (6u8 , 4u8) => Some (ErrorDetails { pallet : "Authorship" , error : "TooHighUncle" , docs : "The uncle is too high in chain." }) , (6u8 , 5u8) => Some (ErrorDetails { pallet : "Authorship" , error : "UncleAlreadyIncluded" , docs : "The uncle is already included." }) , (6u8 , 6u8) => Some (ErrorDetails { pallet : "Authorship" , error : "OldUncle" , docs : "The uncle isn't recent enough to be included." }) , (8u8 , 0u8) => Some (ErrorDetails { pallet : "Grandpa" , error : "PauseFailed" , docs : "Attempt to signal GRANDPA pause when the authority set isn't live\n(either paused or already pending pause)." }) , (8u8 , 1u8) => Some (ErrorDetails { pallet : "Grandpa" , error : "ResumeFailed" , docs : "Attempt to signal GRANDPA resume when the authority set isn't paused\n(either live or already pending resume)." }) , (8u8 , 2u8) => Some (ErrorDetails { pallet : "Grandpa" , error : "ChangePending" , docs : "Attempt to signal GRANDPA change with one already pending." }) , (8u8 , 3u8) => Some (ErrorDetails { pallet : "Grandpa" , error : "TooSoon" , docs : "Cannot signal forced change so soon after last." }) , (8u8 , 4u8) => Some (ErrorDetails { pallet : "Grandpa" , error : "InvalidKeyOwnershipProof" , docs : "A key ownership proof provided as part of an equivocation report is invalid." }) , (8u8 , 5u8) => Some (ErrorDetails { pallet : "Grandpa" , error : "InvalidEquivocationProof" , docs : "An equivocation proof provided as part of an equivocation report is invalid." }) , (8u8 , 6u8) => Some (ErrorDetails { pallet : "Grandpa" , error : "DuplicateOffenceReport" , docs : "A given equivocation report is valid but already previously reported." }) , (9u8 , 0u8) => Some (ErrorDetails { pallet : "Democracy" , error : "ValueLow" , docs : "Value too low" }) , (9u8 , 1u8) => Some (ErrorDetails { pallet : "Democracy" , error : "ProposalMissing" , docs : "Proposal does not exist" }) , (9u8 , 2u8) => Some (ErrorDetails { pallet : "Democracy" , error : "AlreadyCanceled" , docs : "Cannot cancel the same proposal twice" }) , (9u8 , 3u8) => Some (ErrorDetails { pallet : "Democracy" , error : "DuplicateProposal" , docs : "Proposal already made" }) , (9u8 , 4u8) => Some (ErrorDetails { pallet : "Democracy" , error : "ProposalBlacklisted" , docs : "Proposal still blacklisted" }) , (9u8 , 5u8) => Some (ErrorDetails { pallet : "Democracy" , error : "NotSimpleMajority" , docs : "Next external proposal not simple majority" }) , (9u8 , 6u8) => Some (ErrorDetails { pallet : "Democracy" , error : "InvalidHash" , docs : "Invalid hash" }) , (9u8 , 7u8) => Some (ErrorDetails { pallet : "Democracy" , error : "NoProposal" , docs : "No external proposal" }) , (9u8 , 8u8) => Some (ErrorDetails { pallet : "Democracy" , error : "AlreadyVetoed" , docs : "Identity may not veto a proposal twice" }) , (9u8 , 9u8) => Some (ErrorDetails { pallet : "Democracy" , error : "DuplicatePreimage" , docs : "Preimage already noted" }) , (9u8 , 10u8) => Some (ErrorDetails { pallet : "Democracy" , error : "NotImminent" , docs : "Not imminent" }) , (9u8 , 11u8) => Some (ErrorDetails { pallet : "Democracy" , error : "TooEarly" , docs : "Too early" }) , (9u8 , 12u8) => Some (ErrorDetails { pallet : "Democracy" , error : "Imminent" , docs : "Imminent" }) , (9u8 , 13u8) => Some (ErrorDetails { pallet : "Democracy" , error : "PreimageMissing" , docs : "Preimage not found" }) , (9u8 , 14u8) => Some (ErrorDetails { pallet : "Democracy" , error : "ReferendumInvalid" , docs : "Vote given for invalid referendum" }) , (9u8 , 15u8) => Some (ErrorDetails { pallet : "Democracy" , error : "PreimageInvalid" , docs : "Invalid preimage" }) , (9u8 , 16u8) => Some (ErrorDetails { pallet : "Democracy" , error : "NoneWaiting" , docs : "No proposals waiting" }) , (9u8 , 17u8) => Some (ErrorDetails { pallet : "Democracy" , error : "NotVoter" , docs : "The given account did not vote on the referendum." }) , (9u8 , 18u8) => Some (ErrorDetails { pallet : "Democracy" , error : "NoPermission" , docs : "The actor has no permission to conduct the action." }) , (9u8 , 19u8) => Some (ErrorDetails { pallet : "Democracy" , error : "AlreadyDelegating" , docs : "The account is already delegating." }) , (9u8 , 20u8) => Some (ErrorDetails { pallet : "Democracy" , error : "InsufficientFunds" , docs : "Too high a balance was provided that the account cannot afford." }) , (9u8 , 21u8) => Some (ErrorDetails { pallet : "Democracy" , error : "NotDelegating" , docs : "The account is not currently delegating." }) , (9u8 , 22u8) => Some (ErrorDetails { pallet : "Democracy" , error : "VotesExist" , docs : "The account currently has votes attached to it and the operation cannot succeed until\nthese are removed, either through `unvote` or `reap_vote`." }) , (9u8 , 23u8) => Some (ErrorDetails { pallet : "Democracy" , error : "InstantNotAllowed" , docs : "The instant referendum origin is currently disallowed." }) , (9u8 , 24u8) => Some (ErrorDetails { pallet : "Democracy" , error : "Nonsense" , docs : "Delegation to oneself makes no sense." }) , (9u8 , 25u8) => Some (ErrorDetails { pallet : "Democracy" , error : "WrongUpperBound" , docs : "Invalid upper bound." }) , (9u8 , 26u8) => Some (ErrorDetails { pallet : "Democracy" , error : "MaxVotesReached" , docs : "Maximum number of votes reached." }) , (9u8 , 27u8) => Some (ErrorDetails { pallet : "Democracy" , error : "TooManyProposals" , docs : "Maximum number of proposals reached." }) , (10u8 , 0u8) => Some (ErrorDetails { pallet : "Council" , error : "NotMember" , docs : "Account is not a member" }) , (10u8 , 1u8) => Some (ErrorDetails { pallet : "Council" , error : "DuplicateProposal" , docs : "Duplicate proposals not allowed" }) , (10u8 , 2u8) => Some (ErrorDetails { pallet : "Council" , error : "ProposalMissing" , docs : "Proposal must exist" }) , (10u8 , 3u8) => Some (ErrorDetails { pallet : "Council" , error : "WrongIndex" , docs : "Mismatched index" }) , (10u8 , 4u8) => Some (ErrorDetails { pallet : "Council" , error : "DuplicateVote" , docs : "Duplicate vote ignored" }) , (10u8 , 5u8) => Some (ErrorDetails { pallet : "Council" , error : "AlreadyInitialized" , docs : "Members are already initialized!" }) , (10u8 , 6u8) => Some (ErrorDetails { pallet : "Council" , error : "TooEarly" , docs : "The close call was made too early, before the end of the voting." }) , (10u8 , 7u8) => Some (ErrorDetails { pallet : "Council" , error : "TooManyProposals" , docs : "There can only be a maximum of `MaxProposals` active proposals." }) , (10u8 , 8u8) => Some (ErrorDetails { pallet : "Council" , error : "WrongProposalWeight" , docs : "The given weight bound for the proposal was too low." }) , (10u8 , 9u8) => Some (ErrorDetails { pallet : "Council" , error : "WrongProposalLength" , docs : "The given length bound for the proposal was too low." }) , (11u8 , 0u8) => Some (ErrorDetails { pallet : "Elections" , error : "UnableToVote" , docs : "Cannot vote when no candidates or members exist." }) , (11u8 , 1u8) => Some (ErrorDetails { pallet : "Elections" , error : "NoVotes" , docs : "Must vote for at least one candidate." }) , (11u8 , 2u8) => Some (ErrorDetails { pallet : "Elections" , error : "TooManyVotes" , docs : "Cannot vote more than candidates." }) , (11u8 , 3u8) => Some (ErrorDetails { pallet : "Elections" , error : "MaximumVotesExceeded" , docs : "Cannot vote more than maximum allowed." }) , (11u8 , 4u8) => Some (ErrorDetails { pallet : "Elections" , error : "LowBalance" , docs : "Cannot vote with stake less than minimum balance." }) , (11u8 , 5u8) => Some (ErrorDetails { pallet : "Elections" , error : "UnableToPayBond" , docs : "Voter can not pay voting bond." }) , (11u8 , 6u8) => Some (ErrorDetails { pallet : "Elections" , error : "MustBeVoter" , docs : "Must be a voter." }) , (11u8 , 7u8) => Some (ErrorDetails { pallet : "Elections" , error : "ReportSelf" , docs : "Cannot report self." }) , (11u8 , 8u8) => Some (ErrorDetails { pallet : "Elections" , error : "DuplicatedCandidate" , docs : "Duplicated candidate submission." }) , (11u8 , 9u8) => Some (ErrorDetails { pallet : "Elections" , error : "MemberSubmit" , docs : "Member cannot re-submit candidacy." }) , (11u8 , 10u8) => Some (ErrorDetails { pallet : "Elections" , error : "RunnerUpSubmit" , docs : "Runner cannot re-submit candidacy." }) , (11u8 , 11u8) => Some (ErrorDetails { pallet : "Elections" , error : "InsufficientCandidateFunds" , docs : "Candidate does not have enough funds." }) , (11u8 , 12u8) => Some (ErrorDetails { pallet : "Elections" , error : "NotMember" , docs : "Not a member." }) , (11u8 , 13u8) => Some (ErrorDetails { pallet : "Elections" , error : "InvalidWitnessData" , docs : "The provided count of number of candidates is incorrect." }) , (11u8 , 14u8) => Some (ErrorDetails { pallet : "Elections" , error : "InvalidVoteCount" , docs : "The provided count of number of votes is incorrect." }) , (11u8 , 15u8) => Some (ErrorDetails { pallet : "Elections" , error : "InvalidRenouncing" , docs : "The renouncing origin presented a wrong `Renouncing` parameter." }) , (11u8 , 16u8) => Some (ErrorDetails { pallet : "Elections" , error : "InvalidReplacement" , docs : "Prediction regarding replacement after member removal is wrong." }) , (12u8 , 0u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "PreDispatchEarlySubmission" , docs : "Submission was too early." }) , (12u8 , 1u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "PreDispatchWrongWinnerCount" , docs : "Wrong number of winners presented." }) , (12u8 , 2u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "PreDispatchWeakSubmission" , docs : "Submission was too weak, score-wise." }) , (12u8 , 3u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "SignedQueueFull" , docs : "The queue was full, and the solution was not better than any of the existing ones." }) , (12u8 , 4u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "SignedCannotPayDeposit" , docs : "The origin failed to pay the deposit." }) , (12u8 , 5u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "SignedInvalidWitness" , docs : "Witness data to dispatchable is invalid." }) , (12u8 , 6u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "SignedTooMuchWeight" , docs : "The signed submission consumes too much weight" }) , (12u8 , 7u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "OcwCallWrongEra" , docs : "OCW submitted solution for wrong round" }) , (12u8 , 8u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "MissingSnapshotMetadata" , docs : "Snapshot metadata should exist but didn't." }) , (12u8 , 9u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "InvalidSubmissionIndex" , docs : "`Self::insert_submission` returned an invalid index." }) , (12u8 , 10u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "CallNotAllowed" , docs : "The call is not allowed at this point." }) , (12u8 , 11u8) => Some (ErrorDetails { pallet : "ElectionProviderMultiPhase" , error : "FallbackFailed" , docs : "The fallback failed" }) , (13u8 , 0u8) => Some (ErrorDetails { pallet : "Staking" , error : "NotController" , docs : "Not a controller account." }) , (13u8 , 1u8) => Some (ErrorDetails { pallet : "Staking" , error : "NotStash" , docs : "Not a stash account." }) , (13u8 , 2u8) => Some (ErrorDetails { pallet : "Staking" , error : "AlreadyBonded" , docs : "Stash is already bonded." }) , (13u8 , 3u8) => Some (ErrorDetails { pallet : "Staking" , error : "AlreadyPaired" , docs : "Controller is already paired." }) , (13u8 , 4u8) => Some (ErrorDetails { pallet : "Staking" , error : "EmptyTargets" , docs : "Targets cannot be empty." }) , (13u8 , 5u8) => Some (ErrorDetails { pallet : "Staking" , error : "DuplicateIndex" , docs : "Duplicate index." }) , (13u8 , 6u8) => Some (ErrorDetails { pallet : "Staking" , error : "InvalidSlashIndex" , docs : "Slash record index out of bounds." }) , (13u8 , 7u8) => Some (ErrorDetails { pallet : "Staking" , error : "InsufficientBond" , docs : "Cannot have a validator or nominator role, with value less than the minimum defined by\ngovernance (see `MinValidatorBond` and `MinNominatorBond`). If unbonding is the\nintention, `chill` first to remove one's role as validator/nominator." }) , (13u8 , 8u8) => Some (ErrorDetails { pallet : "Staking" , error : "NoMoreChunks" , docs : "Can not schedule more unlock chunks." }) , (13u8 , 9u8) => Some (ErrorDetails { pallet : "Staking" , error : "NoUnlockChunk" , docs : "Can not rebond without unlocking chunks." }) , (13u8 , 10u8) => Some (ErrorDetails { pallet : "Staking" , error : "FundedTarget" , docs : "Attempting to target a stash that still has funds." }) , (13u8 , 11u8) => Some (ErrorDetails { pallet : "Staking" , error : "InvalidEraToReward" , docs : "Invalid era to reward." }) , (13u8 , 12u8) => Some (ErrorDetails { pallet : "Staking" , error : "InvalidNumberOfNominations" , docs : "Invalid number of nominations." }) , (13u8 , 13u8) => Some (ErrorDetails { pallet : "Staking" , error : "NotSortedAndUnique" , docs : "Items are not sorted and unique." }) , (13u8 , 14u8) => Some (ErrorDetails { pallet : "Staking" , error : "AlreadyClaimed" , docs : "Rewards for this era have already been claimed for this validator." }) , (13u8 , 15u8) => Some (ErrorDetails { pallet : "Staking" , error : "IncorrectHistoryDepth" , docs : "Incorrect previous history depth input provided." }) , (13u8 , 16u8) => Some (ErrorDetails { pallet : "Staking" , error : "IncorrectSlashingSpans" , docs : "Incorrect number of slashing spans provided." }) , (13u8 , 17u8) => Some (ErrorDetails { pallet : "Staking" , error : "BadState" , docs : "Internal state has become somehow corrupted and the operation cannot continue." }) , (13u8 , 18u8) => Some (ErrorDetails { pallet : "Staking" , error : "TooManyTargets" , docs : "Too many nomination targets supplied." }) , (13u8 , 19u8) => Some (ErrorDetails { pallet : "Staking" , error : "BadTarget" , docs : "A nominat