The `range_proof_mpc` module contains the API for performing the aggregated multiparty computation protocol for joint range proof proving.

Only the range proofs are supported, while aggregation of constraint system proofs is under development.

API for the aggregated multiparty computation protocol 
------------------------------------------------------

To create the aggregated range proof, \\(m\\) individual parties which each have a secret value exchange messages with one dealer, which does not know their secret values. The protocol to create an aggregated range proof can be run locally or across a network. The protocol should use this API to manage the party states (see [`party`](../range_proof/party/index.html) module), dealer states (see [`dealer`](../range_proof/dealer/index.html) module), and messages (see [`messages`](../range_proof/messages/index.html) module). 

<img width="950" src='data:image/svg+xml;utf8,<svg width="1200" height="700" xmlns="http://www.w3.org/2000/svg"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><path d="M281.674,50 L278.164,42.044 L280.324,42.044 L281.836,45.806 L282.736,48.254 L283.636,45.824 L285.184,42.044 L287.236,42.044 L283.726,50 L281.674,50 Z M292.24,50.18 C290.692,50.18 289.432,49.496 289.432,47.912 C289.432,46.076 291.07,45.59 292.708,45.59 C293.536,45.59 294.418,45.734 294.886,45.878 L294.886,45.23 C294.886,44.204 294.706,43.394 293.23,43.394 C292.114,43.394 291.466,43.844 291.466,44.78 L289.648,44.78 C289.648,42.602 291.43,41.864 293.356,41.864 C295.426,41.864 296.812,42.746 296.812,44.978 L296.812,48.272 C296.812,48.578 296.92,48.686 297.244,48.686 C297.46,48.686 297.784,48.632 298,48.578 L298,49.856 C297.676,50 297.064,50.18 296.47,50.18 C295.462,50.18 295.174,49.658 295.174,49.064 L295.174,48.92 C294.76,49.442 293.878,50.18 292.24,50.18 Z M292.69,48.74 C293.698,48.74 294.49,48.398 294.886,48.074 L294.886,47.066 C294.544,46.976 293.806,46.904 293.122,46.904 C292.06,46.904 291.358,47.102 291.358,47.858 C291.358,48.47 291.808,48.74 292.69,48.74 Z M300.682,50 L300.682,48.488 L303.328,48.488 L303.328,39.866 L300.682,39.866 L300.682,38.354 L305.254,38.354 L305.254,48.488 L307.918,48.488 L307.918,50 L300.682,50 Z M314.452,50.18 C312.94,50.18 311.608,49.532 311.608,46.958 L311.608,42.044 L313.534,42.044 L313.534,46.58 C313.534,47.876 313.804,48.578 314.974,48.578 C315.838,48.578 316.324,48.236 316.666,47.858 L316.666,42.044 L318.592,42.044 L318.592,50 L316.918,50 L316.918,48.92 C316.54,49.442 315.802,50.18 314.452,50.18 Z M326.008,50.18 C323.704,50.18 321.814,49.046 321.814,46.058 C321.814,42.872 323.938,41.864 325.9,41.864 C327.934,41.864 329.986,42.872 329.986,46.022 L329.986,46.454 L323.758,46.454 C323.812,47.84 324.496,48.686 326.044,48.686 C327.106,48.686 327.844,48.254 327.988,47.48 L329.968,47.48 C329.59,49.532 327.736,50.18 326.008,50.18 Z M323.794,45.104 L328.006,45.104 C327.844,43.88 326.944,43.358 325.9,43.358 C324.856,43.358 323.956,43.88 323.794,45.104 Z M335.422,52.826 C334.954,52.826 334.684,52.574 334.684,52.214 C334.684,52.07 334.702,51.944 334.72,51.818 L335.332,47.264 L338.212,47.264 L336.25,52.286 C336.106,52.646 335.89,52.826 335.422,52.826 Z M354.808,50 L354.808,42.044 L356.482,42.044 L356.482,43.124 C356.86,42.602 357.598,41.864 358.948,41.864 C360.46,41.864 361.792,42.512 361.792,45.086 L361.792,50 L359.866,50 L359.866,45.464 C359.866,44.168 359.596,43.466 358.426,43.466 C357.562,43.466 357.076,43.808 356.734,44.186 L356.734,50 L354.808,50 Z" id="value,-n" fill="%23000000"></path><path d="M97.108,166 L97.108,155.704 L100.492,155.704 C102.976,155.704 104.884,156.73 104.884,159.106 C104.884,161.5 102.994,162.508 100.492,162.508 L99.106,162.508 L99.106,166 L97.108,166 Z M99.106,157.396 L99.106,160.834 L100.51,160.834 C102.112,160.834 102.814,160.204 102.814,159.106 C102.814,158.008 102.112,157.396 100.51,157.396 L99.106,157.396 Z M110.14,166.18 C108.592,166.18 107.332,165.496 107.332,163.912 C107.332,162.076 108.97,161.59 110.608,161.59 C111.436,161.59 112.318,161.734 112.786,161.878 L112.786,161.23 C112.786,160.204 112.606,159.394 111.13,159.394 C110.014,159.394 109.366,159.844 109.366,160.78 L107.548,160.78 C107.548,158.602 109.33,157.864 111.256,157.864 C113.326,157.864 114.712,158.746 114.712,160.978 L114.712,164.272 C114.712,164.578 114.82,164.686 115.144,164.686 C115.36,164.686 115.684,164.632 115.9,164.578 L115.9,165.856 C115.576,166 114.964,166.18 114.37,166.18 C113.362,166.18 113.074,165.658 113.074,165.064 L113.074,164.92 C112.66,165.442 111.778,166.18 110.14,166.18 Z M110.59,164.74 C111.598,164.74 112.39,164.398 112.786,164.074 L112.786,163.066 C112.444,162.976 111.706,162.904 111.022,162.904 C109.96,162.904 109.258,163.102 109.258,163.858 C109.258,164.47 109.708,164.74 110.59,164.74 Z M118.582,166 L118.582,164.488 L120.544,164.488 L120.544,159.574 L118.582,159.574 L118.582,158.044 L122.218,158.044 L122.218,159.844 C122.56,158.962 123.352,157.864 124.918,157.864 C125.512,157.864 126.052,158.008 126.412,158.206 L126.412,160.15 C126.016,159.916 125.404,159.772 124.882,159.772 C123.622,159.772 122.866,160.402 122.47,160.924 L122.47,164.488 L125.818,164.488 L125.818,166 L118.582,166 Z M134.242,166.18 C132.19,166.18 131.11,165.388 131.11,162.616 L131.11,159.574 L128.572,159.574 L128.572,158.044 L131.11,158.044 L131.11,154.354 L133.036,154.354 L133.036,158.044 L136.942,158.044 L136.942,159.574 L133.036,159.574 L133.036,162.544 C133.036,164.038 133.324,164.56 134.656,164.56 C135.394,164.56 136.078,164.398 136.636,164.164 L136.636,165.712 C136.06,165.964 135.304,166.18 134.242,166.18 Z M139.642,169.366 L139.642,167.782 C141.37,167.782 142.216,167.242 142.792,165.946 L139.264,158.044 L141.424,158.044 L142.954,161.806 L143.836,164.254 L144.736,161.824 L146.284,158.044 L148.336,158.044 L145.006,165.604 C143.782,168.358 142.612,169.366 139.642,169.366 Z M149.92,166 L153.538,155.704 L155.662,155.704 L159.28,166 L157.138,166 L156.382,163.732 L152.764,163.732 L152.026,166 L149.92,166 Z M153.556,161.086 L153.214,162.148 L155.878,162.148 L155.536,161.086 L154.546,157.756 L153.556,161.086 Z M162.016,166 L160.63,158.044 L162.448,158.044 L163.276,164.47 L164.41,159.628 L166.426,159.628 L167.596,164.47 L168.406,158.044 L170.17,158.044 L168.784,166 L166.534,166 L165.4,161.428 L164.266,166 L162.016,166 Z M174.94,166.18 C173.392,166.18 172.132,165.496 172.132,163.912 C172.132,162.076 173.77,161.59 175.408,161.59 C176.236,161.59 177.118,161.734 177.586,161.878 L177.586,161.23 C177.586,160.204 177.406,159.394 175.93,159.394 C174.814,159.394 174.166,159.844 174.166,160.78 L172.348,160.78 C172.348,158.602 174.13,157.864 176.056,157.864 C178.126,157.864 179.512,158.746 179.512,160.978 L179.512,164.272 C179.512,164.578 179.62,164.686 179.944,164.686 C180.16,164.686 180.484,164.632 180.7,164.578 L180.7,165.856 C180.376,166 179.764,166.18 179.17,166.18 C178.162,166.18 177.874,165.658 177.874,165.064 L177.874,164.92 C177.46,165.442 176.578,166.18 174.94,166.18 Z M175.39,164.74 C176.398,164.74 177.19,164.398 177.586,164.074 L177.586,163.066 C177.244,162.976 176.506,162.904 175.822,162.904 C174.76,162.904 174.058,163.102 174.058,163.858 C174.058,164.47 174.508,164.74 175.39,164.74 Z M183.382,166 L183.382,164.488 L186.154,164.488 L186.154,159.574 L183.382,159.574 L183.382,158.044 L188.08,158.044 L188.08,164.488 L190.618,164.488 L190.618,166 L183.382,166 Z M185.956,156.532 L185.956,154.354 L188.314,154.354 L188.314,156.532 L185.956,156.532 Z M199.042,166.18 C196.99,166.18 195.91,165.388 195.91,162.616 L195.91,159.574 L193.372,159.574 L193.372,158.044 L195.91,158.044 L195.91,154.354 L197.836,154.354 L197.836,158.044 L201.742,158.044 L201.742,159.574 L197.836,159.574 L197.836,162.544 C197.836,164.038 198.124,164.56 199.456,164.56 C200.194,164.56 200.878,164.398 201.436,164.164 L201.436,165.712 C200.86,165.964 200.104,166.18 199.042,166.18 Z M204.982,166 L204.982,164.488 L207.754,164.488 L207.754,159.574 L204.982,159.574 L204.982,158.044 L209.68,158.044 L209.68,164.488 L212.218,164.488 L212.218,166 L204.982,166 Z M207.556,156.532 L207.556,154.354 L209.914,154.354 L209.914,156.532 L207.556,156.532 Z M215.908,166 L215.908,158.044 L217.582,158.044 L217.582,159.124 C217.96,158.602 218.698,157.864 220.048,157.864 C221.56,157.864 222.892,158.512 222.892,161.086 L222.892,166 L220.966,166 L220.966,161.464 C220.966,160.168 220.696,159.466 219.526,159.466 C218.662,159.466 218.176,159.808 217.834,160.186 L217.834,166 L215.908,166 Z M229.858,169.456 C228.094,169.456 226.276,168.97 226.222,166.468 L228.076,166.468 C228.13,167.404 228.562,167.998 229.93,167.998 C231.586,167.998 231.784,167.116 231.784,166.054 L231.784,164.92 C231.406,165.316 230.686,165.874 229.462,165.874 C227.608,165.874 226.078,164.632 226.078,161.896 C226.078,159.142 227.662,157.864 229.462,157.864 C230.758,157.864 231.658,158.512 232.036,159.07 L232.036,158.044 L233.71,158.044 L233.71,166.216 C233.71,168.358 232.486,169.456 229.858,169.456 Z M230.038,164.29 C230.794,164.29 231.37,164.002 231.784,163.606 L231.784,160.15 C231.37,159.754 230.794,159.448 230.038,159.448 C228.652,159.448 228.058,160.438 228.058,161.878 C228.058,163.318 228.652,164.29 230.038,164.29 Z M237.508,166 L237.508,155.704 L240.892,155.704 C243.376,155.704 245.284,156.73 245.284,159.106 C245.284,161.5 243.394,162.508 240.892,162.508 L239.506,162.508 L239.506,166 L237.508,166 Z M239.506,157.396 L239.506,160.834 L240.91,160.834 C242.512,160.834 243.214,160.204 243.214,159.106 C243.214,158.008 242.512,157.396 240.91,157.396 L239.506,157.396 Z M251.8,166.18 C249.784,166.18 247.696,165.244 247.696,162.022 C247.696,158.818 249.91,157.864 251.8,157.864 C253.816,157.864 255.904,158.782 255.904,162.022 C255.904,165.208 253.69,166.18 251.8,166.18 Z M251.8,164.596 C253.168,164.596 253.942,163.786 253.942,162.022 C253.942,160.24 253.168,159.448 251.8,159.448 C250.432,159.448 249.658,160.24 249.658,162.022 C249.658,163.786 250.432,164.596 251.8,164.596 Z M262.546,166.18 C260.422,166.18 258.676,165.46 258.622,163.498 L260.512,163.498 C260.584,164.344 261.448,164.704 262.654,164.704 C263.752,164.704 264.616,164.542 264.616,163.804 C264.616,163.012 263.41,162.886 261.808,162.598 C260.26,162.328 258.766,161.878 258.766,160.204 C258.766,158.566 260.458,157.864 262.42,157.864 C264.382,157.864 266.056,158.386 266.2,160.384 L264.31,160.384 C264.184,159.52 263.266,159.34 262.438,159.34 C261.34,159.34 260.728,159.556 260.728,160.096 C260.728,160.816 261.682,160.942 263.572,161.248 C265.048,161.482 266.596,161.968 266.596,163.606 C266.596,165.532 264.778,166.18 262.546,166.18 Z M269.782,166 L269.782,164.488 L272.554,164.488 L272.554,159.574 L269.782,159.574 L269.782,158.044 L274.48,158.044 L274.48,164.488 L277.018,164.488 L277.018,166 L269.782,166 Z M272.356,156.532 L272.356,154.354 L274.714,154.354 L274.714,156.532 L272.356,156.532 Z M285.442,166.18 C283.39,166.18 282.31,165.388 282.31,162.616 L282.31,159.574 L279.772,159.574 L279.772,158.044 L282.31,158.044 L282.31,154.354 L284.236,154.354 L284.236,158.044 L288.142,158.044 L288.142,159.574 L284.236,159.574 L284.236,162.544 C284.236,164.038 284.524,164.56 285.856,164.56 C286.594,164.56 287.278,164.398 287.836,164.164 L287.836,165.712 C287.26,165.964 286.504,166.18 285.442,166.18 Z M291.382,166 L291.382,164.488 L294.154,164.488 L294.154,159.574 L291.382,159.574 L291.382,158.044 L296.08,158.044 L296.08,164.488 L298.618,164.488 L298.618,166 L291.382,166 Z M293.956,156.532 L293.956,154.354 L296.314,154.354 L296.314,156.532 L293.956,156.532 Z M305.8,166.18 C303.784,166.18 301.696,165.244 301.696,162.022 C301.696,158.818 303.91,157.864 305.8,157.864 C307.816,157.864 309.904,158.782 309.904,162.022 C309.904,165.208 307.69,166.18 305.8,166.18 Z M305.8,164.596 C307.168,164.596 307.942,163.786 307.942,162.022 C307.942,160.24 307.168,159.448 305.8,159.448 C304.432,159.448 303.658,160.24 303.658,162.022 C303.658,163.786 304.432,164.596 305.8,164.596 Z M313.108,166 L313.108,158.044 L314.782,158.044 L314.782,159.124 C315.16,158.602 315.898,157.864 317.248,157.864 C318.76,157.864 320.092,158.512 320.092,161.086 L320.092,166 L318.166,166 L318.166,161.464 C318.166,160.168 317.896,159.466 316.726,159.466 C315.862,159.466 315.376,159.808 315.034,160.186 L315.034,166 L313.108,166 Z" id="PartyAwaitingPositio" fill="%23000000"></path><path d="M796.366,169.276 L796.366,154.354 L802.018,154.354 L802.018,155.866 L798.094,155.866 L798.094,167.764 L802.018,167.764 L802.018,169.276 L796.366,169.276 Z M809.182,166.18 C806.248,166.18 804.934,164.2 804.934,160.906 C804.934,157.594 806.284,155.524 809.218,155.524 C812.17,155.524 813.466,157.54 813.466,160.798 C813.466,164.074 812.134,166.18 809.182,166.18 Z M809.2,164.488 C811.198,164.488 811.432,162.634 811.432,160.852 C811.432,159.034 811.198,157.216 809.2,157.216 C807.202,157.216 806.968,159.034 806.968,160.852 C806.968,162.634 807.202,164.488 809.2,164.488 Z M809.2,161.68 C808.714,161.68 808.372,161.338 808.372,160.852 C808.372,160.366 808.714,160.024 809.2,160.024 C809.686,160.024 810.028,160.366 810.028,160.852 C810.028,161.338 809.686,161.68 809.2,161.68 Z M818.722,168.826 C818.254,168.826 817.984,168.574 817.984,168.214 C817.984,168.07 818.002,167.944 818.02,167.818 L818.632,163.264 L821.512,163.264 L819.55,168.286 C819.406,168.646 819.19,168.826 818.722,168.826 Z M826.444,166 L826.444,158.044 L827.902,158.044 L827.902,159.178 C828.172,158.674 828.73,157.864 829.864,157.864 C830.8,157.864 831.322,158.476 831.484,159.088 C831.7,158.71 832.294,157.864 833.41,157.864 C834.652,157.864 835.156,158.926 835.156,160.51 L835.156,166 L833.446,166 L833.446,160.816 C833.446,159.844 833.266,159.448 832.762,159.448 C832.276,159.448 831.916,159.808 831.664,160.114 L831.664,166 L829.954,166 L829.954,160.816 C829.954,159.844 829.774,159.448 829.27,159.448 C828.784,159.448 828.406,159.808 828.154,160.114 L828.154,166 L826.444,166 Z M838.18,169.276 C841.06,166.36 842.23,164.038 842.23,161.824 C842.23,159.592 841.06,157.27 838.18,154.354 L839.962,154.354 C842.842,156.694 844.03,159.538 844.03,161.824 C844.03,164.11 842.842,166.936 839.962,169.276 L838.18,169.276 Z" id="[0,m)" fill="%23000000"></path><path d="M869.908,326 L869.908,315.704 L873.13,315.704 C876.55,315.704 877.702,317.63 877.702,320.852 C877.702,323.93 876.496,326 873.13,326 L869.908,326 Z M871.906,317.396 L871.906,324.308 L873.13,324.308 C875.308,324.308 875.614,322.67 875.614,320.852 C875.614,319.016 875.308,317.396 873.13,317.396 L871.906,317.396 Z M884.308,326.18 C882.004,326.18 880.114,325.046 880.114,322.058 C880.114,318.872 882.238,317.864 884.2,317.864 C886.234,317.864 888.286,318.872 888.286,322.022 L888.286,322.454 L882.058,322.454 C882.112,323.84 882.796,324.686 884.344,324.686 C885.406,324.686 886.144,324.254 886.288,323.48 L888.268,323.48 C887.89,325.532 886.036,326.18 884.308,326.18 Z M882.094,321.104 L886.306,321.104 C886.144,319.88 885.244,319.358 884.2,319.358 C883.156,319.358 882.256,319.88 882.094,321.104 Z M893.74,326.18 C892.192,326.18 890.932,325.496 890.932,323.912 C890.932,322.076 892.57,321.59 894.208,321.59 C895.036,321.59 895.918,321.734 896.386,321.878 L896.386,321.23 C896.386,320.204 896.206,319.394 894.73,319.394 C893.614,319.394 892.966,319.844 892.966,320.78 L891.148,320.78 C891.148,318.602 892.93,317.864 894.856,317.864 C896.926,317.864 898.312,318.746 898.312,320.978 L898.312,324.272 C898.312,324.578 898.42,324.686 898.744,324.686 C898.96,324.686 899.284,324.632 899.5,324.578 L899.5,325.856 C899.176,326 898.564,326.18 897.97,326.18 C896.962,326.18 896.674,325.658 896.674,325.064 L896.674,324.92 C896.26,325.442 895.378,326.18 893.74,326.18 Z M894.19,324.74 C895.198,324.74 895.99,324.398 896.386,324.074 L896.386,323.066 C896.044,322.976 895.306,322.904 894.622,322.904 C893.56,322.904 892.858,323.102 892.858,323.858 C892.858,324.47 893.308,324.74 894.19,324.74 Z M902.182,326 L902.182,324.488 L904.828,324.488 L904.828,315.866 L902.182,315.866 L902.182,314.354 L906.754,314.354 L906.754,324.488 L909.418,324.488 L909.418,326 L902.182,326 Z M916.708,326.18 C914.404,326.18 912.514,325.046 912.514,322.058 C912.514,318.872 914.638,317.864 916.6,317.864 C918.634,317.864 920.686,318.872 920.686,322.022 L920.686,322.454 L914.458,322.454 C914.512,323.84 915.196,324.686 916.744,324.686 C917.806,324.686 918.544,324.254 918.688,323.48 L920.668,323.48 C920.29,325.532 918.436,326.18 916.708,326.18 Z M914.494,321.104 L918.706,321.104 C918.544,319.88 917.644,319.358 916.6,319.358 C915.556,319.358 914.656,319.88 914.494,321.104 Z M923.782,326 L923.782,324.488 L925.744,324.488 L925.744,319.574 L923.782,319.574 L923.782,318.044 L927.418,318.044 L927.418,319.844 C927.76,318.962 928.552,317.864 930.118,317.864 C930.712,317.864 931.252,318.008 931.612,318.206 L931.612,320.15 C931.216,319.916 930.604,319.772 930.082,319.772 C928.822,319.772 928.066,320.402 927.67,320.924 L927.67,324.488 L931.018,324.488 L931.018,326 L923.782,326 Z M933.52,326 L937.138,315.704 L939.262,315.704 L942.88,326 L940.738,326 L939.982,323.732 L936.364,323.732 L935.626,326 L933.52,326 Z M937.156,321.086 L936.814,322.148 L939.478,322.148 L939.136,321.086 L938.146,317.756 L937.156,321.086 Z M945.616,326 L944.23,318.044 L946.048,318.044 L946.876,324.47 L948.01,319.628 L950.026,319.628 L951.196,324.47 L952.006,318.044 L953.77,318.044 L952.384,326 L950.134,326 L949,321.428 L947.866,326 L945.616,326 Z M958.54,326.18 C956.992,326.18 955.732,325.496 955.732,323.912 C955.732,322.076 957.37,321.59 959.008,321.59 C959.836,321.59 960.718,321.734 961.186,321.878 L961.186,321.23 C961.186,320.204 961.006,319.394 959.53,319.394 C958.414,319.394 957.766,319.844 957.766,320.78 L955.948,320.78 C955.948,318.602 957.73,317.864 959.656,317.864 C961.726,317.864 963.112,318.746 963.112,320.978 L963.112,324.272 C963.112,324.578 963.22,324.686 963.544,324.686 C963.76,324.686 964.084,324.632 964.3,324.578 L964.3,325.856 C963.976,326 963.364,326.18 962.77,326.18 C961.762,326.18 961.474,325.658 961.474,325.064 L961.474,324.92 C961.06,325.442 960.178,326.18 958.54,326.18 Z M958.99,324.74 C959.998,324.74 960.79,324.398 961.186,324.074 L961.186,323.066 C960.844,322.976 960.106,322.904 959.422,322.904 C958.36,322.904 957.658,323.102 957.658,323.858 C957.658,324.47 958.108,324.74 958.99,324.74 Z M966.982,326 L966.982,324.488 L969.754,324.488 L969.754,319.574 L966.982,319.574 L966.982,318.044 L971.68,318.044 L971.68,324.488 L974.218,324.488 L974.218,326 L966.982,326 Z M969.556,316.532 L969.556,314.354 L971.914,314.354 L971.914,316.532 L969.556,316.532 Z M982.642,326.18 C980.59,326.18 979.51,325.388 979.51,322.616 L979.51,319.574 L976.972,319.574 L976.972,318.044 L979.51,318.044 L979.51,314.354 L981.436,314.354 L981.436,318.044 L985.342,318.044 L985.342,319.574 L981.436,319.574 L981.436,322.544 C981.436,324.038 981.724,324.56 983.056,324.56 C983.794,324.56 984.478,324.398 985.036,324.164 L985.036,325.712 C984.46,325.964 983.704,326.18 982.642,326.18 Z M988.582,326 L988.582,324.488 L991.354,324.488 L991.354,319.574 L988.582,319.574 L988.582,318.044 L993.28,318.044 L993.28,324.488 L995.818,324.488 L995.818,326 L988.582,326 Z M991.156,316.532 L991.156,314.354 L993.514,314.354 L993.514,316.532 L991.156,316.532 Z M999.508,326 L999.508,318.044 L1001.182,318.044 L1001.182,319.124 C1001.56,318.602 1002.298,317.864 1003.648,317.864 C1005.16,317.864 1006.492,318.512 1006.492,321.086 L1006.492,326 L1004.566,326 L1004.566,321.464 C1004.566,320.168 1004.296,319.466 1003.126,319.466 C1002.262,319.466 1001.776,319.808 1001.434,320.186 L1001.434,326 L999.508,326 Z M1013.458,329.456 C1011.694,329.456 1009.876,328.97 1009.822,326.468 L1011.676,326.468 C1011.73,327.404 1012.162,327.998 1013.53,327.998 C1015.186,327.998 1015.384,327.116 1015.384,326.054 L1015.384,324.92 C1015.006,325.316 1014.286,325.874 1013.062,325.874 C1011.208,325.874 1009.678,324.632 1009.678,321.896 C1009.678,319.142 1011.262,317.864 1013.062,317.864 C1014.358,317.864 1015.258,318.512 1015.636,319.07 L1015.636,318.044 L1017.31,318.044 L1017.31,326.216 C1017.31,328.358 1016.086,329.456 1013.458,329.456 Z M1013.638,324.29 C1014.394,324.29 1014.97,324.002 1015.384,323.606 L1015.384,320.15 C1014.97,319.754 1014.394,319.448 1013.638,319.448 C1012.252,319.448 1011.658,320.438 1011.658,321.878 C1011.658,323.318 1012.252,324.29 1013.638,324.29 Z M1021.108,326 L1021.108,315.704 L1024.492,315.704 C1026.976,315.704 1028.884,316.73 1028.884,319.106 C1028.884,321.5 1026.994,322.508 1024.492,322.508 L1023.106,322.508 L1023.106,326 L1021.108,326 Z M1023.106,317.396 L1023.106,320.834 L1024.51,320.834 C1026.112,320.834 1026.814,320.204 1026.814,319.106 C1026.814,318.008 1026.112,317.396 1024.51,317.396 L1023.106,317.396 Z M1035.4,326.18 C1033.384,326.18 1031.296,325.244 1031.296,322.022 C1031.296,318.818 1033.51,317.864 1035.4,317.864 C1037.416,317.864 1039.504,318.782 1039.504,322.022 C1039.504,325.208 1037.29,326.18 1035.4,326.18 Z M1035.4,324.596 C1036.768,324.596 1037.542,323.786 1037.542,322.022 C1037.542,320.24 1036.768,319.448 1035.4,319.448 C1034.032,319.448 1033.258,320.24 1033.258,322.022 C1033.258,323.786 1034.032,324.596 1035.4,324.596 Z M1042.582,326 L1042.582,324.488 L1045.228,324.488 L1045.228,315.866 L1042.582,315.866 L1042.582,314.354 L1047.154,314.354 L1047.154,324.488 L1049.818,324.488 L1049.818,326 L1042.582,326 Z M1052.842,329.366 L1052.842,327.782 C1054.57,327.782 1055.416,327.242 1055.992,325.946 L1052.464,318.044 L1054.624,318.044 L1056.154,321.806 L1057.036,324.254 L1057.936,321.824 L1059.484,318.044 L1061.536,318.044 L1058.206,325.604 C1056.982,328.358 1055.812,329.366 1052.842,329.366 Z M1067.908,326.18 C1064.848,326.18 1063.516,324.2 1063.516,320.852 C1063.516,317.54 1065.01,315.524 1067.944,315.524 C1070.338,315.524 1071.958,316.568 1072.084,319.358 L1070.05,319.358 C1069.924,317.9 1069.24,317.234 1067.944,317.234 C1065.928,317.234 1065.586,318.89 1065.586,320.852 C1065.586,322.778 1065.928,324.452 1067.944,324.452 C1069.258,324.452 1069.924,323.786 1070.05,322.346 L1072.084,322.346 C1071.94,325.1 1070.248,326.18 1067.908,326.18 Z M1078.6,326.18 C1076.584,326.18 1074.496,325.244 1074.496,322.022 C1074.496,318.818 1076.71,317.864 1078.6,317.864 C1080.616,317.864 1082.704,318.782 1082.704,322.022 C1082.704,325.208 1080.49,326.18 1078.6,326.18 Z M1078.6,324.596 C1079.968,324.596 1080.742,323.786 1080.742,322.022 C1080.742,320.24 1079.968,319.448 1078.6,319.448 C1077.232,319.448 1076.458,320.24 1076.458,322.022 C1076.458,323.786 1077.232,324.596 1078.6,324.596 Z M1085.044,326 L1085.044,318.044 L1086.502,318.044 L1086.502,319.178 C1086.772,318.674 1087.33,317.864 1088.464,317.864 C1089.4,317.864 1089.922,318.476 1090.084,319.088 C1090.3,318.71 1090.894,317.864 1092.01,317.864 C1093.252,317.864 1093.756,318.926 1093.756,320.51 L1093.756,326 L1092.046,326 L1092.046,320.816 C1092.046,319.844 1091.866,319.448 1091.362,319.448 C1090.876,319.448 1090.516,319.808 1090.264,320.114 L1090.264,326 L1088.554,326 L1088.554,320.816 C1088.554,319.844 1088.374,319.448 1087.87,319.448 C1087.384,319.448 1087.006,319.808 1086.754,320.114 L1086.754,326 L1085.044,326 Z M1095.844,326 L1095.844,318.044 L1097.302,318.044 L1097.302,319.178 C1097.572,318.674 1098.13,317.864 1099.264,317.864 C1100.2,317.864 1100.722,318.476 1100.884,319.088 C1101.1,318.71 1101.694,317.864 1102.81,317.864 C1104.052,317.864 1104.556,318.926 1104.556,320.51 L1104.556,326 L1102.846,326 L1102.846,320.816 C1102.846,319.844 1102.666,319.448 1102.162,319.448 C1101.676,319.448 1101.316,319.808 1101.064,320.114 L1101.064,326 L1099.354,326 L1099.354,320.816 C1099.354,319.844 1099.174,319.448 1098.67,319.448 C1098.184,319.448 1097.806,319.808 1097.554,320.114 L1097.554,326 L1095.844,326 Z M1107.382,326 L1107.382,324.488 L1110.154,324.488 L1110.154,319.574 L1107.382,319.574 L1107.382,318.044 L1112.08,318.044 L1112.08,324.488 L1114.618,324.488 L1114.618,326 L1107.382,326 Z M1109.956,316.532 L1109.956,314.354 L1112.314,314.354 L1112.314,316.532 L1109.956,316.532 Z M1123.042,326.18 C1120.99,326.18 1119.91,325.388 1119.91,322.616 L1119.91,319.574 L1117.372,319.574 L1117.372,318.044 L1119.91,318.044 L1119.91,314.354 L1121.836,314.354 L1121.836,318.044 L1125.742,318.044 L1125.742,319.574 L1121.836,319.574 L1121.836,322.544 C1121.836,324.038 1122.124,324.56 1123.456,324.56 C1124.194,324.56 1124.878,324.398 1125.436,324.164 L1125.436,325.712 C1124.86,325.964 1124.104,326.18 1123.042,326.18 Z M1128.244,326 L1128.244,318.044 L1129.702,318.044 L1129.702,319.178 C1129.972,318.674 1130.53,317.864 1131.664,317.864 C1132.6,317.864 1133.122,318.476 1133.284,319.088 C1133.5,318.71 1134.094,317.864 1135.21,317.864 C1136.452,317.864 1136.956,318.926 1136.956,320.51 L1136.956,326 L1135.246,326 L1135.246,320.816 C1135.246,319.844 1135.066,319.448 1134.562,319.448 C1134.076,319.448 1133.716,319.808 1133.464,320.114 L1133.464,326 L1131.754,326 L1131.754,320.816 C1131.754,319.844 1131.574,319.448 1131.07,319.448 C1130.584,319.448 1130.206,319.808 1129.954,320.114 L1129.954,326 L1128.244,326 Z M1143.508,326.18 C1141.204,326.18 1139.314,325.046 1139.314,322.058 C1139.314,318.872 1141.438,317.864 1143.4,317.864 C1145.434,317.864 1147.486,318.872 1147.486,322.022 L1147.486,322.454 L1141.258,322.454 C1141.312,323.84 1141.996,324.686 1143.544,324.686 C1144.606,324.686 1145.344,324.254 1145.488,323.48 L1147.468,323.48 C1147.09,325.532 1145.236,326.18 1143.508,326.18 Z M1141.294,321.104 L1145.506,321.104 C1145.344,319.88 1144.444,319.358 1143.4,319.358 C1142.356,319.358 1141.456,319.88 1141.294,321.104 Z M1150.708,326 L1150.708,318.044 L1152.382,318.044 L1152.382,319.124 C1152.76,318.602 1153.498,317.864 1154.848,317.864 C1156.36,317.864 1157.692,318.512 1157.692,321.086 L1157.692,326 L1155.766,326 L1155.766,321.464 C1155.766,320.168 1155.496,319.466 1154.326,319.466 C1153.462,319.466 1152.976,319.808 1152.634,320.186 L1152.634,326 L1150.708,326 Z M1166.242,326.18 C1164.19,326.18 1163.11,325.388 1163.11,322.616 L1163.11,319.574 L1160.572,319.574 L1160.572,318.044 L1163.11,318.044 L1163.11,314.354 L1165.036,314.354 L1165.036,318.044 L1168.942,318.044 L1168.942,319.574 L1165.036,319.574 L1165.036,322.544 C1165.036,324.038 1165.324,324.56 1166.656,324.56 C1167.394,324.56 1168.078,324.398 1168.636,324.164 L1168.636,325.712 C1168.06,325.964 1167.304,326.18 1166.242,326.18 Z" id="DealerAwaitingPolyCo" fill="%23000000"></path><path d="M869.908,492 L869.908,481.704 L873.13,481.704 C876.55,481.704 877.702,483.63 877.702,486.852 C877.702,489.93 876.496,492 873.13,492 L869.908,492 Z M871.906,483.396 L871.906,490.308 L873.13,490.308 C875.308,490.308 875.614,488.67 875.614,486.852 C875.614,485.016 875.308,483.396 873.13,483.396 L871.906,483.396 Z M884.308,492.18 C882.004,492.18 880.114,491.046 880.114,488.058 C880.114,484.872 882.238,483.864 884.2,483.864 C886.234,483.864 888.286,484.872 888.286,488.022 L888.286,488.454 L882.058,488.454 C882.112,489.84 882.796,490.686 884.344,490.686 C885.406,490.686 886.144,490.254 886.288,489.48 L888.268,489.48 C887.89,491.532 886.036,492.18 884.308,492.18 Z M882.094,487.104 L886.306,487.104 C886.144,485.88 885.244,485.358 884.2,485.358 C883.156,485.358 882.256,485.88 882.094,487.104 Z M893.74,492.18 C892.192,492.18 890.932,491.496 890.932,489.912 C890.932,488.076 892.57,487.59 894.208,487.59 C895.036,487.59 895.918,487.734 896.386,487.878 L896.386,487.23 C896.386,486.204 896.206,485.394 894.73,485.394 C893.614,485.394 892.966,485.844 892.966,486.78 L891.148,486.78 C891.148,484.602 892.93,483.864 894.856,483.864 C896.926,483.864 898.312,484.746 898.312,486.978 L898.312,490.272 C898.312,490.578 898.42,490.686 898.744,490.686 C898.96,490.686 899.284,490.632 899.5,490.578 L899.5,491.856 C899.176,492 898.564,492.18 897.97,492.18 C896.962,492.18 896.674,491.658 896.674,491.064 L896.674,490.92 C896.26,491.442 895.378,492.18 893.74,492.18 Z M894.19,490.74 C895.198,490.74 895.99,490.398 896.386,490.074 L896.386,489.066 C896.044,488.976 895.306,488.904 894.622,488.904 C893.56,488.904 892.858,489.102 892.858,489.858 C892.858,490.47 893.308,490.74 894.19,490.74 Z M902.182,492 L902.182,490.488 L904.828,490.488 L904.828,481.866 L902.182,481.866 L902.182,480.354 L906.754,480.354 L906.754,490.488 L909.418,490.488 L909.418,492 L902.182,492 Z M916.708,492.18 C914.404,492.18 912.514,491.046 912.514,488.058 C912.514,484.872 914.638,483.864 916.6,483.864 C918.634,483.864 920.686,484.872 920.686,488.022 L920.686,488.454 L914.458,488.454 C914.512,489.84 915.196,490.686 916.744,490.686 C917.806,490.686 918.544,490.254 918.688,489.48 L920.668,489.48 C920.29,491.532 918.436,492.18 916.708,492.18 Z M914.494,487.104 L918.706,487.104 C918.544,485.88 917.644,485.358 916.6,485.358 C915.556,485.358 914.656,485.88 914.494,487.104 Z M923.782,492 L923.782,490.488 L925.744,490.488 L925.744,485.574 L923.782,485.574 L923.782,484.044 L927.418,484.044 L927.418,485.844 C927.76,484.962 928.552,483.864 930.118,483.864 C930.712,483.864 931.252,484.008 931.612,484.206 L931.612,486.15 C931.216,485.916 930.604,485.772 930.082,485.772 C928.822,485.772 928.066,486.402 927.67,486.924 L927.67,490.488 L931.018,490.488 L931.018,492 L923.782,492 Z M933.52,492 L937.138,481.704 L939.262,481.704 L942.88,492 L940.738,492 L939.982,489.732 L936.364,489.732 L935.626,492 L933.52,492 Z M937.156,487.086 L936.814,488.148 L939.478,488.148 L939.136,487.086 L938.146,483.756 L937.156,487.086 Z M945.616,492 L944.23,484.044 L946.048,484.044 L946.876,490.47 L948.01,485.628 L950.026,485.628 L951.196,490.47 L952.006,484.044 L953.77,484.044 L952.384,492 L950.134,492 L949,487.428 L947.866,492 L945.616,492 Z M958.54,492.18 C956.992,492.18 955.732,491.496 955.732,489.912 C955.732,488.076 957.37,487.59 959.008,487.59 C959.836,487.59 960.718,487.734 961.186,487.878 L961.186,487.23 C961.186,486.204 961.006,485.394 959.53,485.394 C958.414,485.394 957.766,485.844 957.766,486.78 L955.948,486.78 C955.948,484.602 957.73,483.864 959.656,483.864 C961.726,483.864 963.112,484.746 963.112,486.978 L963.112,490.272 C963.112,490.578 963.22,490.686 963.544,490.686 C963.76,490.686 964.084,490.632 964.3,490.578 L964.3,491.856 C963.976,492 963.364,492.18 962.77,492.18 C961.762,492.18 961.474,491.658 961.474,491.064 L961.474,490.92 C961.06,491.442 960.178,492.18 958.54,492.18 Z M958.99,490.74 C959.998,490.74 960.79,490.398 961.186,490.074 L961.186,489.066 C960.844,488.976 960.106,488.904 959.422,488.904 C958.36,488.904 957.658,489.102 957.658,489.858 C957.658,490.47 958.108,490.74 958.99,490.74 Z M966.982,492 L966.982,490.488 L969.754,490.488 L969.754,485.574 L966.982,485.574 L966.982,484.044 L971.68,484.044 L971.68,490.488 L974.218,490.488 L974.218,492 L966.982,492 Z M969.556,482.532 L969.556,480.354 L971.914,480.354 L971.914,482.532 L969.556,482.532 Z M982.642,492.18 C980.59,492.18 979.51,491.388 979.51,488.616 L979.51,485.574 L976.972,485.574 L976.972,484.044 L979.51,484.044 L979.51,480.354 L981.436,480.354 L981.436,484.044 L985.342,484.044 L985.342,485.574 L981.436,485.574 L981.436,488.544 C981.436,490.038 981.724,490.56 983.056,490.56 C983.794,490.56 984.478,490.398 985.036,490.164 L985.036,491.712 C984.46,491.964 983.704,492.18 982.642,492.18 Z M988.582,492 L988.582,490.488 L991.354,490.488 L991.354,485.574 L988.582,485.574 L988.582,484.044 L993.28,484.044 L993.28,490.488 L995.818,490.488 L995.818,492 L988.582,492 Z M991.156,482.532 L991.156,480.354 L993.514,480.354 L993.514,482.532 L991.156,482.532 Z M999.508,492 L999.508,484.044 L1001.182,484.044 L1001.182,485.124 C1001.56,484.602 1002.298,483.864 1003.648,483.864 C1005.16,483.864 1006.492,484.512 1006.492,487.086 L1006.492,492 L1004.566,492 L1004.566,487.464 C1004.566,486.168 1004.296,485.466 1003.126,485.466 C1002.262,485.466 1001.776,485.808 1001.434,486.186 L1001.434,492 L999.508,492 Z M1013.458,495.456 C1011.694,495.456 1009.876,494.97 1009.822,492.468 L1011.676,492.468 C1011.73,493.404 1012.162,493.998 1013.53,493.998 C1015.186,493.998 1015.384,493.116 1015.384,492.054 L1015.384,490.92 C1015.006,491.316 1014.286,491.874 1013.062,491.874 C1011.208,491.874 1009.678,490.632 1009.678,487.896 C1009.678,485.142 1011.262,483.864 1013.062,483.864 C1014.358,483.864 1015.258,484.512 1015.636,485.07 L1015.636,484.044 L1017.31,484.044 L1017.31,492.216 C1017.31,494.358 1016.086,495.456 1013.458,495.456 Z M1013.638,490.29 C1014.394,490.29 1014.97,490.002 1015.384,489.606 L1015.384,486.15 C1014.97,485.754 1014.394,485.448 1013.638,485.448 C1012.252,485.448 1011.658,486.438 1011.658,487.878 C1011.658,489.318 1012.252,490.29 1013.638,490.29 Z M1021.108,492 L1021.108,481.704 L1024.492,481.704 C1026.976,481.704 1028.884,482.73 1028.884,485.106 C1028.884,487.5 1026.994,488.508 1024.492,488.508 L1023.106,488.508 L1023.106,492 L1021.108,492 Z M1023.106,483.396 L1023.106,486.834 L1024.51,486.834 C1026.112,486.834 1026.814,486.204 1026.814,485.106 C1026.814,484.008 1026.112,483.396 1024.51,483.396 L1023.106,483.396 Z M1031.782,492 L1031.782,490.488 L1033.744,490.488 L1033.744,485.574 L1031.782,485.574 L1031.782,484.044 L1035.418,484.044 L1035.418,485.844 C1035.76,484.962 1036.552,483.864 1038.118,483.864 C1038.712,483.864 1039.252,484.008 1039.612,484.206 L1039.612,486.15 C1039.216,485.916 1038.604,485.772 1038.082,485.772 C1036.822,485.772 1036.066,486.402 1035.67,486.924 L1035.67,490.488 L1039.018,490.488 L1039.018,492 L1031.782,492 Z M1046.2,492.18 C1044.184,492.18 1042.096,491.244 1042.096,488.022 C1042.096,484.818 1044.31,483.864 1046.2,483.864 C1048.216,483.864 1050.304,484.782 1050.304,488.022 C1050.304,491.208 1048.09,492.18 1046.2,492.18 Z M1046.2,490.596 C1047.568,490.596 1048.342,489.786 1048.342,488.022 C1048.342,486.24 1047.568,485.448 1046.2,485.448 C1044.832,485.448 1044.058,486.24 1044.058,488.022 C1044.058,489.786 1044.832,490.596 1046.2,490.596 Z M1057,492.18 C1054.984,492.18 1052.896,491.244 1052.896,488.022 C1052.896,484.818 1055.11,483.864 1057,483.864 C1059.016,483.864 1061.104,484.782 1061.104,488.022 C1061.104,491.208 1058.89,492.18 1057,492.18 Z M1057,490.596 C1058.368,490.596 1059.142,489.786 1059.142,488.022 C1059.142,486.24 1058.368,485.448 1057,485.448 C1055.632,485.448 1054.858,486.24 1054.858,488.022 C1054.858,489.786 1055.632,490.596 1057,490.596 Z M1064.092,492 L1064.092,490.488 L1066.504,490.488 L1066.504,485.7 L1064.092,485.7 L1064.092,484.188 L1066.504,484.188 L1066.504,484.152 C1066.504,481.362 1068.754,480.264 1071.508,480.264 L1071.508,481.794 C1070.032,481.794 1068.43,482.244 1068.43,484.152 L1068.43,484.188 L1071.508,484.188 L1071.508,485.7 L1068.43,485.7 L1068.43,490.488 L1071.508,490.488 L1071.508,492 L1064.092,492 Z M1078.564,492.18 C1076.242,492.18 1074.55,491.154 1074.55,488.904 L1076.494,488.904 C1076.584,489.984 1077.196,490.524 1078.6,490.524 C1079.878,490.524 1080.652,490.074 1080.652,489.246 C1080.652,488.562 1080.13,488.256 1079.338,487.986 L1077.034,487.23 C1075.774,486.816 1074.802,485.97 1074.802,484.494 C1074.802,482.568 1076.44,481.524 1078.636,481.524 C1080.688,481.524 1082.362,482.442 1082.398,484.746 L1080.436,484.746 C1080.364,483.612 1079.77,483.18 1078.618,483.18 C1077.34,483.18 1076.764,483.702 1076.782,484.368 C1076.8,484.944 1077.07,485.304 1077.916,485.574 L1080.256,486.348 C1081.48,486.762 1082.632,487.446 1082.632,489.102 C1082.632,491.19 1080.832,492.18 1078.564,492.18 Z M1085.908,492 L1085.908,480.354 L1087.834,480.354 L1087.834,484.926 C1088.104,484.566 1088.842,483.864 1090.084,483.864 C1091.596,483.864 1092.892,484.512 1092.892,487.086 L1092.892,492 L1090.966,492 L1090.966,487.464 C1090.966,486.168 1090.696,485.466 1089.526,485.466 C1088.662,485.466 1088.176,485.808 1087.834,486.186 L1087.834,492 L1085.908,492 Z M1098.94,492.18 C1097.392,492.18 1096.132,491.496 1096.132,489.912 C1096.132,488.076 1097.77,487.59 1099.408,487.59 C1100.236,487.59 1101.118,487.734 1101.586,487.878 L1101.586,487.23 C1101.586,486.204 1101.406,485.394 1099.93,485.394 C1098.814,485.394 1098.166,485.844 1098.166,486.78 L1096.348,486.78 C1096.348,484.602 1098.13,483.864 1100.056,483.864 C1102.126,483.864 1103.512,484.746 1103.512,486.978 L1103.512,490.272 C1103.512,490.578 1103.62,490.686 1103.944,490.686 C1104.16,490.686 1104.484,490.632 1104.7,490.578 L1104.7,491.856 C1104.376,492 1103.764,492.18 1103.17,492.18 C1102.162,492.18 1101.874,491.658 1101.874,491.064 L1101.874,490.92 C1101.46,491.442 1100.578,492.18 1098.94,492.18 Z M1099.39,490.74 C1100.398,490.74 1101.19,490.398 1101.586,490.074 L1101.586,489.066 C1101.244,488.976 1100.506,488.904 1099.822,488.904 C1098.76,488.904 1098.058,489.102 1098.058,489.858 C1098.058,490.47 1098.508,490.74 1099.39,490.74 Z M1107.382,492 L1107.382,490.488 L1109.344,490.488 L1109.344,485.574 L1107.382,485.574 L1107.382,484.044 L1111.018,484.044 L1111.018,485.844 C1111.36,484.962 1112.152,483.864 1113.718,483.864 C1114.312,483.864 1114.852,484.008 1115.212,484.206 L1115.212,486.15 C1114.816,485.916 1114.204,485.772 1113.682,485.772 C1112.422,485.772 1111.666,486.402 1111.27,486.924 L1111.27,490.488 L1114.618,490.488 L1114.618,492 L1107.382,492 Z M1121.908,492.18 C1119.604,492.18 1117.714,491.046 1117.714,488.058 C1117.714,484.872 1119.838,483.864 1121.8,483.864 C1123.834,483.864 1125.886,484.872 1125.886,488.022 L1125.886,488.454 L1119.658,488.454 C1119.712,489.84 1120.396,490.686 1121.944,490.686 C1123.006,490.686 1123.744,490.254 1123.888,489.48 L1125.868,489.48 C1125.49,491.532 1123.636,492.18 1121.908,492.18 Z M1119.694,487.104 L1123.906,487.104 C1123.744,485.88 1122.844,485.358 1121.8,485.358 C1120.756,485.358 1119.856,485.88 1119.694,487.104 Z M1132.546,492.18 C1130.422,492.18 1128.676,491.46 1128.622,489.498 L1130.512,489.498 C1130.584,490.344 1131.448,490.704 1132.654,490.704 C1133.752,490.704 1134.616,490.542 1134.616,489.804 C1134.616,489.012 1133.41,488.886 1131.808,488.598 C1130.26,488.328 1128.766,487.878 1128.766,486.204 C1128.766,484.566 1130.458,483.864 1132.42,483.864 C1134.382,483.864 1136.056,484.386 1136.2,486.384 L1134.31,486.384 C1134.184,485.52 1133.266,485.34 1132.438,485.34 C1131.34,485.34 1130.728,485.556 1130.728,486.096 C1130.728,486.816 1131.682,486.942 1133.572,487.248 C1135.048,487.482 1136.596,487.968 1136.596,489.606 C1136.596,491.532 1134.778,492.18 1132.546,492.18 Z" id="DealerAwaitingProofS" fill="%23000000"></path><path d="M518.208,492 L518.208,481.704 L521.592,481.704 C524.076,481.704 525.984,482.73 525.984,485.106 C525.984,487.5 524.094,488.508 521.592,488.508 L520.206,488.508 L520.206,492 L518.208,492 Z M520.206,483.396 L520.206,486.834 L521.61,486.834 C523.212,486.834 523.914,486.204 523.914,485.106 C523.914,484.008 523.212,483.396 521.61,483.396 L520.206,483.396 Z M532.5,492.18 C530.484,492.18 528.396,491.244 528.396,488.022 C528.396,484.818 530.61,483.864 532.5,483.864 C534.516,483.864 536.604,484.782 536.604,488.022 C536.604,491.208 534.39,492.18 532.5,492.18 Z M532.5,490.596 C533.868,490.596 534.642,489.786 534.642,488.022 C534.642,486.24 533.868,485.448 532.5,485.448 C531.132,485.448 530.358,486.24 530.358,488.022 C530.358,489.786 531.132,490.596 532.5,490.596 Z M539.682,492 L539.682,490.488 L542.328,490.488 L542.328,481.866 L539.682,481.866 L539.682,480.354 L544.254,480.354 L544.254,490.488 L546.918,490.488 L546.918,492 L539.682,492 Z M549.942,495.366 L549.942,493.782 C551.67,493.782 552.516,493.242 553.092,491.946 L549.564,484.044 L551.724,484.044 L553.254,487.806 L554.136,490.254 L555.036,487.824 L556.584,484.044 L558.636,484.044 L555.306,491.604 C554.082,494.358 552.912,495.366 549.942,495.366 Z M565.008,492.18 C561.948,492.18 560.616,490.2 560.616,486.852 C560.616,483.54 562.11,481.524 565.044,481.524 C567.438,481.524 569.058,482.568 569.184,485.358 L567.15,485.358 C567.024,483.9 566.34,483.234 565.044,483.234 C563.028,483.234 562.686,484.89 562.686,486.852 C562.686,488.778 563.028,490.452 565.044,490.452 C566.358,490.452 567.024,489.786 567.15,488.346 L569.184,488.346 C569.04,491.1 567.348,492.18 565.008,492.18 Z M572.208,492 L572.208,480.354 L574.134,480.354 L574.134,484.926 C574.404,484.566 575.142,483.864 576.384,483.864 C577.896,483.864 579.192,484.512 579.192,487.086 L579.192,492 L577.266,492 L577.266,487.464 C577.266,486.168 576.996,485.466 575.826,485.466 C574.962,485.466 574.476,485.808 574.134,486.186 L574.134,492 L572.208,492 Z M585.24,492.18 C583.692,492.18 582.432,491.496 582.432,489.912 C582.432,488.076 584.07,487.59 585.708,487.59 C586.536,487.59 587.418,487.734 587.886,487.878 L587.886,487.23 C587.886,486.204 587.706,485.394 586.23,485.394 C585.114,485.394 584.466,485.844 584.466,486.78 L582.648,486.78 C582.648,484.602 584.43,483.864 586.356,483.864 C588.426,483.864 589.812,484.746 589.812,486.978 L589.812,490.272 C589.812,490.578 589.92,490.686 590.244,490.686 C590.46,490.686 590.784,490.632 591,490.578 L591,491.856 C590.676,492 590.064,492.18 589.47,492.18 C588.462,492.18 588.174,491.658 588.174,491.064 L588.174,490.92 C587.76,491.442 586.878,492.18 585.24,492.18 Z M585.69,490.74 C586.698,490.74 587.49,490.398 587.886,490.074 L587.886,489.066 C587.544,488.976 586.806,488.904 586.122,488.904 C585.06,488.904 584.358,489.102 584.358,489.858 C584.358,490.47 584.808,490.74 585.69,490.74 Z M593.682,492 L593.682,490.488 L596.328,490.488 L596.328,481.866 L593.682,481.866 L593.682,480.354 L598.254,480.354 L598.254,490.488 L600.918,490.488 L600.918,492 L593.682,492 Z M604.482,492 L604.482,490.488 L607.128,490.488 L607.128,481.866 L604.482,481.866 L604.482,480.354 L609.054,480.354 L609.054,490.488 L611.718,490.488 L611.718,492 L604.482,492 Z M619.008,492.18 C616.704,492.18 614.814,491.046 614.814,488.058 C614.814,484.872 616.938,483.864 618.9,483.864 C620.934,483.864 622.986,484.872 622.986,488.022 L622.986,488.454 L616.758,488.454 C616.812,489.84 617.496,490.686 619.044,490.686 C620.106,490.686 620.844,490.254 620.988,489.48 L622.968,489.48 C622.59,491.532 620.736,492.18 619.008,492.18 Z M616.794,487.104 L621.006,487.104 C620.844,485.88 619.944,485.358 618.9,485.358 C617.856,485.358 616.956,485.88 616.794,487.104 Z M626.208,492 L626.208,484.044 L627.882,484.044 L627.882,485.124 C628.26,484.602 628.998,483.864 630.348,483.864 C631.86,483.864 633.192,484.512 633.192,487.086 L633.192,492 L631.266,492 L631.266,487.464 C631.266,486.168 630.996,485.466 629.826,485.466 C628.962,485.466 628.476,485.808 628.134,486.186 L628.134,492 L626.208,492 Z M640.158,495.456 C638.394,495.456 636.576,494.97 636.522,492.468 L638.376,492.468 C638.43,493.404 638.862,493.998 640.23,493.998 C641.886,493.998 642.084,493.116 642.084,492.054 L642.084,490.92 C641.706,491.316 640.986,491.874 639.762,491.874 C637.908,491.874 636.378,490.632 636.378,487.896 C636.378,485.142 637.962,483.864 639.762,483.864 C641.058,483.864 641.958,484.512 642.336,485.07 L642.336,484.044 L644.01,484.044 L644.01,492.216 C644.01,494.358 642.786,495.456 640.158,495.456 Z M640.338,490.29 C641.094,490.29 641.67,490.002 642.084,489.606 L642.084,486.15 C641.67,485.754 641.094,485.448 640.338,485.448 C638.952,485.448 638.358,486.438 638.358,487.878 C638.358,489.318 638.952,490.29 640.338,490.29 Z M651.408,492.18 C649.104,492.18 647.214,491.046 647.214,488.058 C647.214,484.872 649.338,483.864 651.3,483.864 C653.334,483.864 655.386,484.872 655.386,488.022 L655.386,488.454 L649.158,488.454 C649.212,489.84 649.896,490.686 651.444,490.686 C652.506,490.686 653.244,490.254 653.388,489.48 L655.368,489.48 C654.99,491.532 653.136,492.18 651.408,492.18 Z M649.194,487.104 L653.406,487.104 C653.244,485.88 652.344,485.358 651.3,485.358 C650.256,485.358 649.356,485.88 649.194,487.104 Z" id="PolyChallenge" fill="%23000000"></path><path d="M421.404,169.366 L421.404,167.854 C423.402,167.854 424.644,167.224 424.644,165.01 L424.644,159.574 L421.566,159.574 L421.566,158.044 L426.57,158.044 L426.57,165.19 C426.57,168.304 424.464,169.366 421.404,169.366 Z M424.446,156.532 L424.446,154.354 L426.804,154.354 L426.804,156.532 L424.446,156.532 Z" id="j" fill="%23000000"></path><path d="M375.908,408 L375.908,397.704 L379.292,397.704 C381.776,397.704 383.684,398.73 383.684,401.106 C383.684,403.5 381.794,404.508 379.292,404.508 L377.906,404.508 L377.906,408 L375.908,408 Z M377.906,399.396 L377.906,402.834 L379.31,402.834 C380.912,402.834 381.614,402.204 381.614,401.106 C381.614,400.008 380.912,399.396 379.31,399.396 L377.906,399.396 Z M390.2,408.18 C388.184,408.18 386.096,407.244 386.096,404.022 C386.096,400.818 388.31,399.864 390.2,399.864 C392.216,399.864 394.304,400.782 394.304,404.022 C394.304,407.208 392.09,408.18 390.2,408.18 Z M390.2,406.596 C391.568,406.596 392.342,405.786 392.342,404.022 C392.342,402.24 391.568,401.448 390.2,401.448 C388.832,401.448 388.058,402.24 388.058,404.022 C388.058,405.786 388.832,406.596 390.2,406.596 Z M397.382,408 L397.382,406.488 L400.028,406.488 L400.028,397.866 L397.382,397.866 L397.382,396.354 L401.954,396.354 L401.954,406.488 L404.618,406.488 L404.618,408 L397.382,408 Z M407.642,411.366 L407.642,409.782 C409.37,409.782 410.216,409.242 410.792,407.946 L407.264,400.044 L409.424,400.044 L410.954,403.806 L411.836,406.254 L412.736,403.824 L414.284,400.044 L416.336,400.044 L413.006,407.604 C411.782,410.358 410.612,411.366 407.642,411.366 Z M422.708,408.18 C419.648,408.18 418.316,406.2 418.316,402.852 C418.316,399.54 419.81,397.524 422.744,397.524 C425.138,397.524 426.758,398.568 426.884,401.358 L424.85,401.358 C424.724,399.9 424.04,399.234 422.744,399.234 C420.728,399.234 420.386,400.89 420.386,402.852 C420.386,404.778 420.728,406.452 422.744,406.452 C424.058,406.452 424.724,405.786 424.85,404.346 L426.884,404.346 C426.74,407.1 425.048,408.18 422.708,408.18 Z M433.4,408.18 C431.384,408.18 429.296,407.244 429.296,404.022 C429.296,400.818 431.51,399.864 433.4,399.864 C435.416,399.864 437.504,400.782 437.504,404.022 C437.504,407.208 435.29,408.18 433.4,408.18 Z M433.4,406.596 C434.768,406.596 435.542,405.786 435.542,404.022 C435.542,402.24 434.768,401.448 433.4,401.448 C432.032,401.448 431.258,402.24 431.258,404.022 C431.258,405.786 432.032,406.596 433.4,406.596 Z M439.844,408 L439.844,400.044 L441.302,400.044 L441.302,401.178 C441.572,400.674 442.13,399.864 443.264,399.864 C444.2,399.864 444.722,400.476 444.884,401.088 C445.1,400.71 445.694,399.864 446.81,399.864 C448.052,399.864 448.556,400.926 448.556,402.51 L448.556,408 L446.846,408 L446.846,402.816 C446.846,401.844 446.666,401.448 446.162,401.448 C445.676,401.448 445.316,401.808 445.064,402.114 L445.064,408 L443.354,408 L443.354,402.816 C443.354,401.844 443.174,401.448 442.67,401.448 C442.184,401.448 441.806,401.808 441.554,402.114 L441.554,408 L439.844,408 Z M450.644,408 L450.644,400.044 L452.102,400.044 L452.102,401.178 C452.372,400.674 452.93,399.864 454.064,399.864 C455,399.864 455.522,400.476 455.684,401.088 C455.9,400.71 456.494,399.864 457.61,399.864 C458.852,399.864 459.356,400.926 459.356,402.51 L459.356,408 L457.646,408 L457.646,402.816 C457.646,401.844 457.466,401.448 456.962,401.448 C456.476,401.448 456.116,401.808 455.864,402.114 L455.864,408 L454.154,408 L454.154,402.816 C454.154,401.844 453.974,401.448 453.47,401.448 C452.984,401.448 452.606,401.808 452.354,402.114 L452.354,408 L450.644,408 Z M462.182,408 L462.182,406.488 L464.954,406.488 L464.954,401.574 L462.182,401.574 L462.182,400.044 L466.88,400.044 L466.88,406.488 L469.418,406.488 L469.418,408 L462.182,408 Z M464.756,398.532 L464.756,396.354 L467.114,396.354 L467.114,398.532 L464.756,398.532 Z M477.842,408.18 C475.79,408.18 474.71,407.388 474.71,404.616 L474.71,401.574 L472.172,401.574 L472.172,400.044 L474.71,400.044 L474.71,396.354 L476.636,396.354 L476.636,400.044 L480.542,400.044 L480.542,401.574 L476.636,401.574 L476.636,404.544 C476.636,406.038 476.924,406.56 478.256,406.56 C478.994,406.56 479.678,406.398 480.236,406.164 L480.236,407.712 C479.66,407.964 478.904,408.18 477.842,408.18 Z M483.044,408 L483.044,400.044 L484.502,400.044 L484.502,401.178 C484.772,400.674 485.33,399.864 486.464,399.864 C487.4,399.864 487.922,400.476 488.084,401.088 C488.3,400.71 488.894,399.864 490.01,399.864 C491.252,399.864 491.756,400.926 491.756,402.51 L491.756,408 L490.046,408 L490.046,402.816 C490.046,401.844 489.866,401.448 489.362,401.448 C488.876,401.448 488.516,401.808 488.264,402.114 L488.264,408 L486.554,408 L486.554,402.816 C486.554,401.844 486.374,401.448 485.87,401.448 C485.384,401.448 485.006,401.808 484.754,402.114 L484.754,408 L483.044,408 Z M498.308,408.18 C496.004,408.18 494.114,407.046 494.114,404.058 C494.114,400.872 496.238,399.864 498.2,399.864 C500.234,399.864 502.286,400.872 502.286,404.022 L502.286,404.454 L496.058,404.454 C496.112,405.84 496.796,406.686 498.344,406.686 C499.406,406.686 500.144,406.254 500.288,405.48 L502.268,405.48 C501.89,407.532 500.036,408.18 498.308,408.18 Z M496.094,403.104 L500.306,403.104 C500.144,401.88 499.244,401.358 498.2,401.358 C497.156,401.358 496.256,401.88 496.094,403.104 Z M505.508,408 L505.508,400.044 L507.182,400.044 L507.182,401.124 C507.56,400.602 508.298,399.864 509.648,399.864 C511.16,399.864 512.492,400.512 512.492,403.086 L512.492,408 L510.566,408 L510.566,403.464 C510.566,402.168 510.296,401.466 509.126,401.466 C508.262,401.466 507.776,401.808 507.434,402.186 L507.434,408 L505.508,408 Z M521.042,408.18 C518.99,408.18 517.91,407.388 517.91,404.616 L517.91,401.574 L515.372,401.574 L515.372,400.044 L517.91,400.044 L517.91,396.354 L519.836,396.354 L519.836,400.044 L523.742,400.044 L523.742,401.574 L519.836,401.574 L519.836,404.544 C519.836,406.038 520.124,406.56 521.456,406.56 C522.194,406.56 522.878,406.398 523.436,406.164 L523.436,407.712 C522.86,407.964 522.104,408.18 521.042,408.18 Z" id="PolyCommitment" fill="%23000000"></path><path d="M375.908,574 L375.908,563.704 L379.292,563.704 C381.776,563.704 383.684,564.73 383.684,567.106 C383.684,569.5 381.794,570.508 379.292,570.508 L377.906,570.508 L377.906,574 L375.908,574 Z M377.906,565.396 L377.906,568.834 L379.31,568.834 C380.912,568.834 381.614,568.204 381.614,567.106 C381.614,566.008 380.912,565.396 379.31,565.396 L377.906,565.396 Z M386.582,574 L386.582,572.488 L388.544,572.488 L388.544,567.574 L386.582,567.574 L386.582,566.044 L390.218,566.044 L390.218,567.844 C390.56,566.962 391.352,565.864 392.918,565.864 C393.512,565.864 394.052,566.008 394.412,566.206 L394.412,568.15 C394.016,567.916 393.404,567.772 392.882,567.772 C391.622,567.772 390.866,568.402 390.47,568.924 L390.47,572.488 L393.818,572.488 L393.818,574 L386.582,574 Z M401,574.18 C398.984,574.18 396.896,573.244 396.896,570.022 C396.896,566.818 399.11,565.864 401,565.864 C403.016,565.864 405.104,566.782 405.104,570.022 C405.104,573.208 402.89,574.18 401,574.18 Z M401,572.596 C402.368,572.596 403.142,571.786 403.142,570.022 C403.142,568.24 402.368,567.448 401,567.448 C399.632,567.448 398.858,568.24 398.858,570.022 C398.858,571.786 399.632,572.596 401,572.596 Z M411.8,574.18 C409.784,574.18 407.696,573.244 407.696,570.022 C407.696,566.818 409.91,565.864 411.8,565.864 C413.816,565.864 415.904,566.782 415.904,570.022 C415.904,573.208 413.69,574.18 411.8,574.18 Z M411.8,572.596 C413.168,572.596 413.942,571.786 413.942,570.022 C413.942,568.24 413.168,567.448 411.8,567.448 C410.432,567.448 409.658,568.24 409.658,570.022 C409.658,571.786 410.432,572.596 411.8,572.596 Z M418.892,574 L418.892,572.488 L421.304,572.488 L421.304,567.7 L418.892,567.7 L418.892,566.188 L421.304,566.188 L421.304,566.152 C421.304,563.362 423.554,562.264 426.308,562.264 L426.308,563.794 C424.832,563.794 423.23,564.244 423.23,566.152 L423.23,566.188 L426.308,566.188 L426.308,567.7 L423.23,567.7 L423.23,572.488 L426.308,572.488 L426.308,574 L418.892,574 Z M433.364,574.18 C431.042,574.18 429.35,573.154 429.35,570.904 L431.294,570.904 C431.384,571.984 431.996,572.524 433.4,572.524 C434.678,572.524 435.452,572.074 435.452,571.246 C435.452,570.562 434.93,570.256 434.138,569.986 L431.834,569.23 C430.574,568.816 429.602,567.97 429.602,566.494 C429.602,564.568 431.24,563.524 433.436,563.524 C435.488,563.524 437.162,564.442 437.198,566.746 L435.236,566.746 C435.164,565.612 434.57,565.18 433.418,565.18 C432.14,565.18 431.564,565.702 431.582,566.368 C431.6,566.944 431.87,567.304 432.716,567.574 L435.056,568.348 C436.28,568.762 437.432,569.446 437.432,571.102 C437.432,573.19 435.632,574.18 433.364,574.18 Z M440.708,574 L440.708,562.354 L442.634,562.354 L442.634,566.926 C442.904,566.566 443.642,565.864 444.884,565.864 C446.396,565.864 447.692,566.512 447.692,569.086 L447.692,574 L445.766,574 L445.766,569.464 C445.766,568.168 445.496,567.466 444.326,567.466 C443.462,567.466 442.976,567.808 442.634,568.186 L442.634,574 L440.708,574 Z M453.74,574.18 C452.192,574.18 450.932,573.496 450.932,571.912 C450.932,570.076 452.57,569.59 454.208,569.59 C455.036,569.59 455.918,569.734 456.386,569.878 L456.386,569.23 C456.386,568.204 456.206,567.394 454.73,567.394 C453.614,567.394 452.966,567.844 452.966,568.78 L451.148,568.78 C451.148,566.602 452.93,565.864 454.856,565.864 C456.926,565.864 458.312,566.746 458.312,568.978 L458.312,572.272 C458.312,572.578 458.42,572.686 458.744,572.686 C458.96,572.686 459.284,572.632 459.5,572.578 L459.5,573.856 C459.176,574 458.564,574.18 457.97,574.18 C456.962,574.18 456.674,573.658 456.674,573.064 L456.674,572.92 C456.26,573.442 455.378,574.18 453.74,574.18 Z M454.19,572.74 C455.198,572.74 455.99,572.398 456.386,572.074 L456.386,571.066 C456.044,570.976 455.306,570.904 454.622,570.904 C453.56,570.904 452.858,571.102 452.858,571.858 C452.858,572.47 453.308,572.74 454.19,572.74 Z M462.182,574 L462.182,572.488 L464.144,572.488 L464.144,567.574 L462.182,567.574 L462.182,566.044 L465.818,566.044 L465.818,567.844 C466.16,566.962 466.952,565.864 468.518,565.864 C469.112,565.864 469.652,566.008 470.012,566.206 L470.012,568.15 C469.616,567.916 469.004,567.772 468.482,567.772 C467.222,567.772 466.466,568.402 466.07,568.924 L466.07,572.488 L469.418,572.488 L469.418,574 L462.182,574 Z M476.708,574.18 C474.404,574.18 472.514,573.046 472.514,570.058 C472.514,566.872 474.638,565.864 476.6,565.864 C478.634,565.864 480.686,566.872 480.686,570.022 L480.686,570.454 L474.458,570.454 C474.512,571.84 475.196,572.686 476.744,572.686 C477.806,572.686 478.544,572.254 478.688,571.48 L480.668,571.48 C480.29,573.532 478.436,574.18 476.708,574.18 Z M474.494,569.104 L478.706,569.104 C478.544,567.88 477.644,567.358 476.6,567.358 C475.556,567.358 474.656,567.88 474.494,569.104 Z" id="ProofShare" fill="%23000000"></path><path d="M709.908,652 L709.908,641.704 L712.932,641.704 C715.506,641.704 717.324,642.694 717.324,645.088 C717.324,646.564 716.334,647.626 715.11,648.04 L718.062,652 L715.614,652 L713.148,648.4 L711.906,648.4 L711.906,652 L709.908,652 Z M711.906,643.396 L711.906,646.78 L712.932,646.78 C714.534,646.78 715.272,646.186 715.272,645.088 C715.272,643.99 714.534,643.396 712.932,643.396 L711.906,643.396 Z M722.94,652.18 C721.392,652.18 720.132,651.496 720.132,649.912 C720.132,648.076 721.77,647.59 723.408,647.59 C724.236,647.59 725.118,647.734 725.586,647.878 L725.586,647.23 C725.586,646.204 725.406,645.394 723.93,645.394 C722.814,645.394 722.166,645.844 722.166,646.78 L720.348,646.78 C720.348,644.602 722.13,643.864 724.056,643.864 C726.126,643.864 727.512,644.746 727.512,646.978 L727.512,650.272 C727.512,650.578 727.62,650.686 727.944,650.686 C728.16,650.686 728.484,650.632 728.7,650.578 L728.7,651.856 C728.376,652 727.764,652.18 727.17,652.18 C726.162,652.18 725.874,651.658 725.874,651.064 L725.874,650.92 C725.46,651.442 724.578,652.18 722.94,652.18 Z M723.39,650.74 C724.398,650.74 725.19,650.398 725.586,650.074 L725.586,649.066 C725.244,648.976 724.506,648.904 723.822,648.904 C722.76,648.904 722.058,649.102 722.058,649.858 C722.058,650.47 722.508,650.74 723.39,650.74 Z M731.508,652 L731.508,644.044 L733.182,644.044 L733.182,645.124 C733.56,644.602 734.298,643.864 735.648,643.864 C737.16,643.864 738.492,644.512 738.492,647.086 L738.492,652 L736.566,652 L736.566,647.464 C736.566,646.168 736.296,645.466 735.126,645.466 C734.262,645.466 733.776,645.808 733.434,646.186 L733.434,652 L731.508,652 Z M745.458,655.456 C743.694,655.456 741.876,654.97 741.822,652.468 L743.676,652.468 C743.73,653.404 744.162,653.998 745.53,653.998 C747.186,653.998 747.384,653.116 747.384,652.054 L747.384,650.92 C747.006,651.316 746.286,651.874 745.062,651.874 C743.208,651.874 741.678,650.632 741.678,647.896 C741.678,645.142 743.262,643.864 745.062,643.864 C746.358,643.864 747.258,644.512 747.636,645.07 L747.636,644.044 L749.31,644.044 L749.31,652.216 C749.31,654.358 748.086,655.456 745.458,655.456 Z M745.638,650.29 C746.394,650.29 746.97,650.002 747.384,649.606 L747.384,646.15 C746.97,645.754 746.394,645.448 745.638,645.448 C744.252,645.448 743.658,646.438 743.658,647.878 C743.658,649.318 744.252,650.29 745.638,650.29 Z M756.708,652.18 C754.404,652.18 752.514,651.046 752.514,648.058 C752.514,644.872 754.638,643.864 756.6,643.864 C758.634,643.864 760.686,644.872 760.686,648.022 L760.686,648.454 L754.458,648.454 C754.512,649.84 755.196,650.686 756.744,650.686 C757.806,650.686 758.544,650.254 758.688,649.48 L760.668,649.48 C760.29,651.532 758.436,652.18 756.708,652.18 Z M754.494,647.104 L758.706,647.104 C758.544,645.88 757.644,645.358 756.6,645.358 C755.556,645.358 754.656,645.88 754.494,647.104 Z M763.908,652 L763.908,641.704 L767.292,641.704 C769.776,641.704 771.684,642.73 771.684,645.106 C771.684,647.5 769.794,648.508 767.292,648.508 L765.906,648.508 L765.906,652 L763.908,652 Z M765.906,643.396 L765.906,646.834 L767.31,646.834 C768.912,646.834 769.614,646.204 769.614,645.106 C769.614,644.008 768.912,643.396 767.31,643.396 L765.906,643.396 Z M774.582,652 L774.582,650.488 L776.544,650.488 L776.544,645.574 L774.582,645.574 L774.582,644.044 L778.218,644.044 L778.218,645.844 C778.56,644.962 779.352,643.864 780.918,643.864 C781.512,643.864 782.052,644.008 782.412,644.206 L782.412,646.15 C782.016,645.916 781.404,645.772 780.882,645.772 C779.622,645.772 778.866,646.402 778.47,646.924 L778.47,650.488 L781.818,650.488 L781.818,652 L774.582,652 Z M789,652.18 C786.984,652.18 784.896,651.244 784.896,648.022 C784.896,644.818 787.11,643.864 789,643.864 C791.016,643.864 793.104,644.782 793.104,648.022 C793.104,651.208 790.89,652.18 789,652.18 Z M789,650.596 C790.368,650.596 791.142,649.786 791.142,648.022 C791.142,646.24 790.368,645.448 789,645.448 C787.632,645.448 786.858,646.24 786.858,648.022 C786.858,649.786 787.632,650.596 789,650.596 Z M799.8,652.18 C797.784,652.18 795.696,651.244 795.696,648.022 C795.696,644.818 797.91,643.864 799.8,643.864 C801.816,643.864 803.904,644.782 803.904,648.022 C803.904,651.208 801.69,652.18 799.8,652.18 Z M799.8,650.596 C801.168,650.596 801.942,649.786 801.942,648.022 C801.942,646.24 801.168,645.448 799.8,645.448 C798.432,645.448 797.658,646.24 797.658,648.022 C797.658,649.786 798.432,650.596 799.8,650.596 Z M806.892,652 L806.892,650.488 L809.304,650.488 L809.304,645.7 L806.892,645.7 L806.892,644.188 L809.304,644.188 L809.304,644.152 C809.304,641.362 811.554,640.264 814.308,640.264 L814.308,641.794 C812.832,641.794 811.23,642.244 811.23,644.152 L811.23,644.188 L814.308,644.188 L814.308,645.7 L811.23,645.7 L811.23,650.488 L814.308,650.488 L814.308,652 L806.892,652 Z" id="RangeProof" fill="%23000000"></path><path d="M689.766,577.276 L689.766,562.354 L695.418,562.354 L695.418,563.866 L691.494,563.866 L691.494,575.764 L695.418,575.764 L695.418,577.276 L689.766,577.276 Z M699.108,574 L699.108,563.704 L702.492,563.704 C704.976,563.704 706.884,564.73 706.884,567.106 C706.884,569.5 704.994,570.508 702.492,570.508 L701.106,570.508 L701.106,574 L699.108,574 Z M701.106,565.396 L701.106,568.834 L702.51,568.834 C704.112,568.834 704.814,568.204 704.814,567.106 C704.814,566.008 704.112,565.396 702.51,565.396 L701.106,565.396 Z M709.782,574 L709.782,572.488 L711.744,572.488 L711.744,567.574 L709.782,567.574 L709.782,566.044 L713.418,566.044 L713.418,567.844 C713.76,566.962 714.552,565.864 716.118,565.864 C716.712,565.864 717.252,566.008 717.612,566.206 L717.612,568.15 C717.216,567.916 716.604,567.772 716.082,567.772 C714.822,567.772 714.066,568.402 713.67,568.924 L713.67,572.488 L717.018,572.488 L717.018,574 L709.782,574 Z M724.2,574.18 C722.184,574.18 720.096,573.244 720.096,570.022 C720.096,566.818 722.31,565.864 724.2,565.864 C726.216,565.864 728.304,566.782 728.304,570.022 C728.304,573.208 726.09,574.18 724.2,574.18 Z M724.2,572.596 C725.568,572.596 726.342,571.786 726.342,570.022 C726.342,568.24 725.568,567.448 724.2,567.448 C722.832,567.448 722.058,568.24 722.058,570.022 C722.058,571.786 722.832,572.596 724.2,572.596 Z M735,574.18 C732.984,574.18 730.896,573.244 730.896,570.022 C730.896,566.818 733.11,565.864 735,565.864 C737.016,565.864 739.104,566.782 739.104,570.022 C739.104,573.208 736.89,574.18 735,574.18 Z M735,572.596 C736.368,572.596 737.142,571.786 737.142,570.022 C737.142,568.24 736.368,567.448 735,567.448 C733.632,567.448 732.858,568.24 732.858,570.022 C732.858,571.786 733.632,572.596 735,572.596 Z M742.092,574 L742.092,572.488 L744.504,572.488 L744.504,567.7 L742.092,567.7 L742.092,566.188 L744.504,566.188 L744.504,566.152 C744.504,563.362 746.754,562.264 749.508,562.264 L749.508,563.794 C748.032,563.794 746.43,564.244 746.43,566.152 L746.43,566.188 L749.508,566.188 L749.508,567.7 L746.43,567.7 L746.43,572.488 L749.508,572.488 L749.508,574 L742.092,574 Z M756.564,574.18 C754.242,574.18 752.55,573.154 752.55,570.904 L754.494,570.904 C754.584,571.984 755.196,572.524 756.6,572.524 C757.878,572.524 758.652,572.074 758.652,571.246 C758.652,570.562 758.13,570.256 757.338,569.986 L755.034,569.23 C753.774,568.816 752.802,567.97 752.802,566.494 C752.802,564.568 754.44,563.524 756.636,563.524 C758.688,563.524 760.362,564.442 760.398,566.746 L758.436,566.746 C758.364,565.612 757.77,565.18 756.618,565.18 C755.34,565.18 754.764,565.702 754.782,566.368 C754.8,566.944 755.07,567.304 755.916,567.574 L758.256,568.348 C759.48,568.762 760.632,569.446 760.632,571.102 C760.632,573.19 758.832,574.18 756.564,574.18 Z M763.908,574 L763.908,562.354 L765.834,562.354 L765.834,566.926 C766.104,566.566 766.842,565.864 768.084,565.864 C769.596,565.864 770.892,566.512 770.892,569.086 L770.892,574 L768.966,574 L768.966,569.464 C768.966,568.168 768.696,567.466 767.526,567.466 C766.662,567.466 766.176,567.808 765.834,568.186 L765.834,574 L763.908,574 Z M776.94,574.18 C775.392,574.18 774.132,573.496 774.132,571.912 C774.132,570.076 775.77,569.59 777.408,569.59 C778.236,569.59 779.118,569.734 779.586,569.878 L779.586,569.23 C779.586,568.204 779.406,567.394 777.93,567.394 C776.814,567.394 776.166,567.844 776.166,568.78 L774.348,568.78 C774.348,566.602 776.13,565.864 778.056,565.864 C780.126,565.864 781.512,566.746 781.512,568.978 L781.512,572.272 C781.512,572.578 781.62,572.686 781.944,572.686 C782.16,572.686 782.484,572.632 782.7,572.578 L782.7,573.856 C782.376,574 781.764,574.18 781.17,574.18 C780.162,574.18 779.874,573.658 779.874,573.064 L779.874,572.92 C779.46,573.442 778.578,574.18 776.94,574.18 Z M777.39,572.74 C778.398,572.74 779.19,572.398 779.586,572.074 L779.586,571.066 C779.244,570.976 778.506,570.904 777.822,570.904 C776.76,570.904 776.058,571.102 776.058,571.858 C776.058,572.47 776.508,572.74 777.39,572.74 Z M785.382,574 L785.382,572.488 L787.344,572.488 L787.344,567.574 L785.382,567.574 L785.382,566.044 L789.018,566.044 L789.018,567.844 C789.36,566.962 790.152,565.864 791.718,565.864 C792.312,565.864 792.852,566.008 793.212,566.206 L793.212,568.15 C792.816,567.916 792.204,567.772 791.682,567.772 C790.422,567.772 789.666,568.402 789.27,568.924 L789.27,572.488 L792.618,572.488 L792.618,574 L785.382,574 Z M799.908,574.18 C797.604,574.18 795.714,573.046 795.714,570.058 C795.714,566.872 797.838,565.864 799.8,565.864 C801.834,565.864 803.886,566.872 803.886,570.022 L803.886,570.454 L797.658,570.454 C797.712,571.84 798.396,572.686 799.944,572.686 C801.006,572.686 801.744,572.254 801.888,571.48 L803.868,571.48 C803.49,573.532 801.636,574.18 799.908,574.18 Z M797.694,569.104 L801.906,569.104 C801.744,567.88 800.844,567.358 799.8,567.358 C798.756,567.358 797.856,567.88 797.694,569.104 Z M807,577.276 L807,575.764 L810.924,575.764 L810.924,563.866 L807,563.866 L807,562.354 L812.634,562.354 L812.634,577.276 L807,577.276 Z" id="[ProofShare]" fill="%23000000"></path><path d="M646.566,411.276 L646.566,396.354 L652.218,396.354 L652.218,397.866 L648.294,397.866 L648.294,409.764 L652.218,409.764 L652.218,411.276 L646.566,411.276 Z M655.908,408 L655.908,397.704 L659.292,397.704 C661.776,397.704 663.684,398.73 663.684,401.106 C663.684,403.5 661.794,404.508 659.292,404.508 L657.906,404.508 L657.906,408 L655.908,408 Z M657.906,399.396 L657.906,402.834 L659.31,402.834 C660.912,402.834 661.614,402.204 661.614,401.106 C661.614,400.008 660.912,399.396 659.31,399.396 L657.906,399.396 Z M670.2,408.18 C668.184,408.18 666.096,407.244 666.096,404.022 C666.096,400.818 668.31,399.864 670.2,399.864 C672.216,399.864 674.304,400.782 674.304,404.022 C674.304,407.208 672.09,408.18 670.2,408.18 Z M670.2,406.596 C671.568,406.596 672.342,405.786 672.342,404.022 C672.342,402.24 671.568,401.448 670.2,401.448 C668.832,401.448 668.058,402.24 668.058,404.022 C668.058,405.786 668.832,406.596 670.2,406.596 Z M677.382,408 L677.382,406.488 L680.028,406.488 L680.028,397.866 L677.382,397.866 L677.382,396.354 L681.954,396.354 L681.954,406.488 L684.618,406.488 L684.618,408 L677.382,408 Z M687.642,411.366 L687.642,409.782 C689.37,409.782 690.216,409.242 690.792,407.946 L687.264,400.044 L689.424,400.044 L690.954,403.806 L691.836,406.254 L692.736,403.824 L694.284,400.044 L696.336,400.044 L693.006,407.604 C691.782,410.358 690.612,411.366 687.642,411.366 Z M702.708,408.18 C699.648,408.18 698.316,406.2 698.316,402.852 C698.316,399.54 699.81,397.524 702.744,397.524 C705.138,397.524 706.758,398.568 706.884,401.358 L704.85,401.358 C704.724,399.9 704.04,399.234 702.744,399.234 C700.728,399.234 700.386,400.89 700.386,402.852 C700.386,404.778 700.728,406.452 702.744,406.452 C704.058,406.452 704.724,405.786 704.85,404.346 L706.884,404.346 C706.74,407.1 705.048,408.18 702.708,408.18 Z M713.4,408.18 C711.384,408.18 709.296,407.244 709.296,404.022 C709.296,400.818 711.51,399.864 713.4,399.864 C715.416,399.864 717.504,400.782 717.504,404.022 C717.504,407.208 715.29,408.18 713.4,408.18 Z M713.4,406.596 C714.768,406.596 715.542,405.786 715.542,404.022 C715.542,402.24 714.768,401.448 713.4,401.448 C712.032,401.448 711.258,402.24 711.258,404.022 C711.258,405.786 712.032,406.596 713.4,406.596 Z M719.844,408 L719.844,400.044 L721.302,400.044 L721.302,401.178 C721.572,400.674 722.13,399.864 723.264,399.864 C724.2,399.864 724.722,400.476 724.884,401.088 C725.1,400.71 725.694,399.864 726.81,399.864 C728.052,399.864 728.556,400.926 728.556,402.51 L728.556,408 L726.846,408 L726.846,402.816 C726.846,401.844 726.666,401.448 726.162,401.448 C725.676,401.448 725.316,401.808 725.064,402.114 L725.064,408 L723.354,408 L723.354,402.816 C723.354,401.844 723.174,401.448 722.67,401.448 C722.184,401.448 721.806,401.808 721.554,402.114 L721.554,408 L719.844,408 Z M730.644,408 L730.644,400.044 L732.102,400.044 L732.102,401.178 C732.372,400.674 732.93,399.864 734.064,399.864 C735,399.864 735.522,400.476 735.684,401.088 C735.9,400.71 736.494,399.864 737.61,399.864 C738.852,399.864 739.356,400.926 739.356,402.51 L739.356,408 L737.646,408 L737.646,402.816 C737.646,401.844 737.466,401.448 736.962,401.448 C736.476,401.448 736.116,401.808 735.864,402.114 L735.864,408 L734.154,408 L734.154,402.816 C734.154,401.844 733.974,401.448 733.47,401.448 C732.984,401.448 732.606,401.808 732.354,402.114 L732.354,408 L730.644,408 Z M742.182,408 L742.182,406.488 L744.954,406.488 L744.954,401.574 L742.182,401.574 L742.182,400.044 L746.88,400.044 L746.88,406.488 L749.418,406.488 L749.418,408 L742.182,408 Z M744.756,398.532 L744.756,396.354 L747.114,396.354 L747.114,398.532 L744.756,398.532 Z M757.842,408.18 C755.79,408.18 754.71,407.388 754.71,404.616 L754.71,401.574 L752.172,401.574 L752.172,400.044 L754.71,400.044 L754.71,396.354 L756.636,396.354 L756.636,400.044 L760.542,400.044 L760.542,401.574 L756.636,401.574 L756.636,404.544 C756.636,406.038 756.924,406.56 758.256,406.56 C758.994,406.56 759.678,406.398 760.236,406.164 L760.236,407.712 C759.66,407.964 758.904,408.18 757.842,408.18 Z M763.044,408 L763.044,400.044 L764.502,400.044 L764.502,401.178 C764.772,400.674 765.33,399.864 766.464,399.864 C767.4,399.864 767.922,400.476 768.084,401.088 C768.3,400.71 768.894,399.864 770.01,399.864 C771.252,399.864 771.756,400.926 771.756,402.51 L771.756,408 L770.046,408 L770.046,402.816 C770.046,401.844 769.866,401.448 769.362,401.448 C768.876,401.448 768.516,401.808 768.264,402.114 L768.264,408 L766.554,408 L766.554,402.816 C766.554,401.844 766.374,401.448 765.87,401.448 C765.384,401.448 765.006,401.808 764.754,402.114 L764.754,408 L763.044,408 Z M778.308,408.18 C776.004,408.18 774.114,407.046 774.114,404.058 C774.114,400.872 776.238,399.864 778.2,399.864 C780.234,399.864 782.286,400.872 782.286,404.022 L782.286,404.454 L776.058,404.454 C776.112,405.84 776.796,406.686 778.344,406.686 C779.406,406.686 780.144,406.254 780.288,405.48 L782.268,405.48 C781.89,407.532 780.036,408.18 778.308,408.18 Z M776.094,403.104 L780.306,403.104 C780.144,401.88 779.244,401.358 778.2,401.358 C777.156,401.358 776.256,401.88 776.094,403.104 Z M785.508,408 L785.508,400.044 L787.182,400.044 L787.182,401.124 C787.56,400.602 788.298,399.864 789.648,399.864 C791.16,399.864 792.492,400.512 792.492,403.086 L792.492,408 L790.566,408 L790.566,403.464 C790.566,402.168 790.296,401.466 789.126,401.466 C788.262,401.466 787.776,401.808 787.434,402.186 L787.434,408 L785.508,408 Z M801.042,408.18 C798.99,408.18 797.91,407.388 797.91,404.616 L797.91,401.574 L795.372,401.574 L795.372,400.044 L797.91,400.044 L797.91,396.354 L799.836,396.354 L799.836,400.044 L803.742,400.044 L803.742,401.574 L799.836,401.574 L799.836,404.544 C799.836,406.038 800.124,406.56 801.456,406.56 C802.194,406.56 802.878,406.398 803.436,406.164 L803.436,407.712 C802.86,407.964 802.104,408.18 801.042,408.18 Z M807,411.276 L807,409.764 L810.924,409.764 L810.924,397.866 L807,397.866 L807,396.354 L812.634,396.354 L812.634,411.276 L807,411.276 Z" id="[PolyCommitment]" fill="%23000000"></path><path d="M43.108,408 L43.108,397.704 L46.492,397.704 C48.976,397.704 50.884,398.73 50.884,401.106 C50.884,403.5 48.994,404.508 46.492,404.508 L45.106,404.508 L45.106,408 L43.108,408 Z M45.106,399.396 L45.106,402.834 L46.51,402.834 C48.112,402.834 48.814,402.204 48.814,401.106 C48.814,400.008 48.112,399.396 46.51,399.396 L45.106,399.396 Z M56.14,408.18 C54.592,408.18 53.332,407.496 53.332,405.912 C53.332,404.076 54.97,403.59 56.608,403.59 C57.436,403.59 58.318,403.734 58.786,403.878 L58.786,403.23 C58.786,402.204 58.606,401.394 57.13,401.394 C56.014,401.394 55.366,401.844 55.366,402.78 L53.548,402.78 C53.548,400.602 55.33,399.864 57.256,399.864 C59.326,399.864 60.712,400.746 60.712,402.978 L60.712,406.272 C60.712,406.578 60.82,406.686 61.144,406.686 C61.36,406.686 61.684,406.632 61.9,406.578 L61.9,407.856 C61.576,408 60.964,408.18 60.37,408.18 C59.362,408.18 59.074,407.658 59.074,407.064 L59.074,406.92 C58.66,407.442 57.778,408.18 56.14,408.18 Z M56.59,406.74 C57.598,406.74 58.39,406.398 58.786,406.074 L58.786,405.066 C58.444,404.976 57.706,404.904 57.022,404.904 C55.96,404.904 55.258,405.102 55.258,405.858 C55.258,406.47 55.708,406.74 56.59,406.74 Z M64.582,408 L64.582,406.488 L66.544,406.488 L66.544,401.574 L64.582,401.574 L64.582,400.044 L68.218,400.044 L68.218,401.844 C68.56,400.962 69.352,399.864 70.918,399.864 C71.512,399.864 72.052,400.008 72.412,400.206 L72.412,402.15 C72.016,401.916 71.404,401.772 70.882,401.772 C69.622,401.772 68.866,402.402 68.47,402.924 L68.47,406.488 L71.818,406.488 L71.818,408 L64.582,408 Z M80.242,408.18 C78.19,408.18 77.11,407.388 77.11,404.616 L77.11,401.574 L74.572,401.574 L74.572,400.044 L77.11,400.044 L77.11,396.354 L79.036,396.354 L79.036,400.044 L82.942,400.044 L82.942,401.574 L79.036,401.574 L79.036,404.544 C79.036,406.038 79.324,406.56 80.656,406.56 C81.394,406.56 82.078,406.398 82.636,406.164 L82.636,407.712 C82.06,407.964 81.304,408.18 80.242,408.18 Z M85.642,411.366 L85.642,409.782 C87.37,409.782 88.216,409.242 88.792,407.946 L85.264,400.044 L87.424,400.044 L88.954,403.806 L89.836,406.254 L90.736,403.824 L92.284,400.044 L94.336,400.044 L91.006,407.604 C89.782,410.358 88.612,411.366 85.642,411.366 Z M95.92,408 L99.538,397.704 L101.662,397.704 L105.28,408 L103.138,408 L102.382,405.732 L98.764,405.732 L98.026,408 L95.92,408 Z M99.556,403.086 L99.214,404.148 L101.878,404.148 L101.536,403.086 L100.546,399.756 L99.556,403.086 Z M108.016,408 L106.63,400.044 L108.448,400.044 L109.276,406.47 L110.41,401.628 L112.426,401.628 L113.596,406.47 L114.406,400.044 L116.17,400.044 L114.784,408 L112.534,408 L111.4,403.428 L110.266,408 L108.016,408 Z M120.94,408.18 C119.392,408.18 118.132,407.496 118.132,405.912 C118.132,404.076 119.77,403.59 121.408,403.59 C122.236,403.59 123.118,403.734 123.586,403.878 L123.586,403.23 C123.586,402.204 123.406,401.394 121.93,401.394 C120.814,401.394 120.166,401.844 120.166,402.78 L118.348,402.78 C118.348,400.602 120.13,399.864 122.056,399.864 C124.126,399.864 125.512,400.746 125.512,402.978 L125.512,406.272 C125.512,406.578 125.62,406.686 125.944,406.686 C126.16,406.686 126.484,406.632 126.7,406.578 L126.7,407.856 C126.376,408 125.764,408.18 125.17,408.18 C124.162,408.18 123.874,407.658 123.874,407.064 L123.874,406.92 C123.46,407.442 122.578,408.18 120.94,408.18 Z M121.39,406.74 C122.398,406.74 123.19,406.398 123.586,406.074 L123.586,405.066 C123.244,404.976 122.506,404.904 121.822,404.904 C120.76,404.904 120.058,405.102 120.058,405.858 C120.058,406.47 120.508,406.74 121.39,406.74 Z M129.382,408 L129.382,406.488 L132.154,406.488 L132.154,401.574 L129.382,401.574 L129.382,400.044 L134.08,400.044 L134.08,406.488 L136.618,406.488 L136.618,408 L129.382,408 Z M131.956,398.532 L131.956,396.354 L134.314,396.354 L134.314,398.532 L131.956,398.532 Z M145.042,408.18 C142.99,408.18 141.91,407.388 141.91,404.616 L141.91,401.574 L139.372,401.574 L139.372,400.044 L141.91,400.044 L141.91,396.354 L143.836,396.354 L143.836,400.044 L147.742,400.044 L147.742,401.574 L143.836,401.574 L143.836,404.544 C143.836,406.038 144.124,406.56 145.456,406.56 C146.194,406.56 146.878,406.398 147.436,406.164 L147.436,407.712 C146.86,407.964 146.104,408.18 145.042,408.18 Z M150.982,408 L150.982,406.488 L153.754,406.488 L153.754,401.574 L150.982,401.574 L150.982,400.044 L155.68,400.044 L155.68,406.488 L158.218,406.488 L158.218,408 L150.982,408 Z M153.556,398.532 L153.556,396.354 L155.914,396.354 L155.914,398.532 L153.556,398.532 Z M161.908,408 L161.908,400.044 L163.582,400.044 L163.582,401.124 C163.96,400.602 164.698,399.864 166.048,399.864 C167.56,399.864 168.892,400.512 168.892,403.086 L168.892,408 L166.966,408 L166.966,403.464 C166.966,402.168 166.696,401.466 165.526,401.466 C164.662,401.466 164.176,401.808 163.834,402.186 L163.834,408 L161.908,408 Z M175.858,411.456 C174.094,411.456 172.276,410.97 172.222,408.468 L174.076,408.468 C174.13,409.404 174.562,409.998 175.93,409.998 C177.586,409.998 177.784,409.116 177.784,408.054 L177.784,406.92 C177.406,407.316 176.686,407.874 175.462,407.874 C173.608,407.874 172.078,406.632 172.078,403.896 C172.078,401.142 173.662,399.864 175.462,399.864 C176.758,399.864 177.658,400.512 178.036,401.07 L178.036,400.044 L179.71,400.044 L179.71,408.216 C179.71,410.358 178.486,411.456 175.858,411.456 Z M176.038,406.29 C176.794,406.29 177.37,406.002 177.784,405.606 L177.784,402.15 C177.37,401.754 176.794,401.448 176.038,401.448 C174.652,401.448 174.058,402.438 174.058,403.878 C174.058,405.318 174.652,406.29 176.038,406.29 Z M183.508,408 L183.508,397.704 L186.892,397.704 C189.376,397.704 191.284,398.73 191.284,401.106 C191.284,403.5 189.394,404.508 186.892,404.508 L185.506,404.508 L185.506,408 L183.508,408 Z M185.506,399.396 L185.506,402.834 L186.91,402.834 C188.512,402.834 189.214,402.204 189.214,401.106 C189.214,400.008 188.512,399.396 186.91,399.396 L185.506,399.396 Z M197.8,408.18 C195.784,408.18 193.696,407.244 193.696,404.022 C193.696,400.818 195.91,399.864 197.8,399.864 C199.816,399.864 201.904,400.782 201.904,404.022 C201.904,407.208 199.69,408.18 197.8,408.18 Z M197.8,406.596 C199.168,406.596 199.942,405.786 199.942,404.022 C199.942,402.24 199.168,401.448 197.8,401.448 C196.432,401.448 195.658,402.24 195.658,404.022 C195.658,405.786 196.432,406.596 197.8,406.596 Z M204.982,408 L204.982,406.488 L207.628,406.488 L207.628,397.866 L204.982,397.866 L204.982,396.354 L209.554,396.354 L209.554,406.488 L212.218,406.488 L212.218,408 L204.982,408 Z M215.242,411.366 L215.242,409.782 C216.97,409.782 217.816,409.242 218.392,407.946 L214.864,400.044 L217.024,400.044 L218.554,403.806 L219.436,406.254 L220.336,403.824 L221.884,400.044 L223.936,400.044 L220.606,407.604 C219.382,410.358 218.212,411.366 215.242,411.366 Z M230.308,408.18 C227.248,408.18 225.916,406.2 225.916,402.852 C225.916,399.54 227.41,397.524 230.344,397.524 C232.738,397.524 234.358,398.568 234.484,401.358 L232.45,401.358 C232.324,399.9 231.64,399.234 230.344,399.234 C228.328,399.234 227.986,400.89 227.986,402.852 C227.986,404.778 228.328,406.452 230.344,406.452 C231.658,406.452 232.324,405.786 232.45,404.346 L234.484,404.346 C234.34,407.1 232.648,408.18 230.308,408.18 Z M237.508,408 L237.508,396.354 L239.434,396.354 L239.434,400.926 C239.704,400.566 240.442,399.864 241.684,399.864 C243.196,399.864 244.492,400.512 244.492,403.086 L244.492,408 L242.566,408 L242.566,403.464 C242.566,402.168 242.296,401.466 241.126,401.466 C240.262,401.466 239.776,401.808 239.434,402.186 L239.434,408 L237.508,408 Z M250.54,408.18 C248.992,408.18 247.732,407.496 247.732,405.912 C247.732,404.076 249.37,403.59 251.008,403.59 C251.836,403.59 252.718,403.734 253.186,403.878 L253.186,403.23 C253.186,402.204 253.006,401.394 251.53,401.394 C250.414,401.394 249.766,401.844 249.766,402.78 L247.948,402.78 C247.948,400.602 249.73,399.864 251.656,399.864 C253.726,399.864 255.112,400.746 255.112,402.978 L255.112,406.272 C255.112,406.578 255.22,406.686 255.544,406.686 C255.76,406.686 256.084,406.632 256.3,406.578 L256.3,407.856 C255.976,408 255.364,408.18 254.77,408.18 C253.762,408.18 253.474,407.658 253.474,407.064 L253.474,406.92 C253.06,407.442 252.178,408.18 250.54,408.18 Z M250.99,406.74 C251.998,406.74 252.79,406.398 253.186,406.074 L253.186,405.066 C252.844,404.976 252.106,404.904 251.422,404.904 C250.36,404.904 249.658,405.102 249.658,405.858 C249.658,406.47 250.108,406.74 250.99,406.74 Z M258.982,408 L258.982,406.488 L261.628,406.488 L261.628,397.866 L258.982,397.866 L258.982,396.354 L263.554,396.354 L263.554,406.488 L266.218,406.488 L266.218,408 L258.982,408 Z M269.782,408 L269.782,406.488 L272.428,406.488 L272.428,397.866 L269.782,397.866 L269.782,396.354 L274.354,396.354 L274.354,406.488 L277.018,406.488 L277.018,408 L269.782,408 Z M284.308,408.18 C282.004,408.18 280.114,407.046 280.114,404.058 C280.114,400.872 282.238,399.864 284.2,399.864 C286.234,399.864 288.286,400.872 288.286,404.022 L288.286,404.454 L282.058,404.454 C282.112,405.84 282.796,406.686 284.344,406.686 C285.406,406.686 286.144,406.254 286.288,405.48 L288.268,405.48 C287.89,407.532 286.036,408.18 284.308,408.18 Z M282.094,403.104 L286.306,403.104 C286.144,401.88 285.244,401.358 284.2,401.358 C283.156,401.358 282.256,401.88 282.094,403.104 Z M291.508,408 L291.508,400.044 L293.182,400.044 L293.182,401.124 C293.56,400.602 294.298,399.864 295.648,399.864 C297.16,399.864 298.492,400.512 298.492,403.086 L298.492,408 L296.566,408 L296.566,403.464 C296.566,402.168 296.296,401.466 295.126,401.466 C294.262,401.466 293.776,401.808 293.434,402.186 L293.434,408 L291.508,408 Z M305.458,411.456 C303.694,411.456 301.876,410.97 301.822,408.468 L303.676,408.468 C303.73,409.404 304.162,409.998 305.53,409.998 C307.186,409.998 307.384,409.116 307.384,408.054 L307.384,406.92 C307.006,407.316 306.286,407.874 305.062,407.874 C303.208,407.874 301.678,406.632 301.678,403.896 C301.678,401.142 303.262,399.864 305.062,399.864 C306.358,399.864 307.258,400.512 307.636,401.07 L307.636,400.044 L309.31,400.044 L309.31,408.216 C309.31,410.358 308.086,411.456 305.458,411.456 Z M305.638,406.29 C306.394,406.29 306.97,406.002 307.384,405.606 L307.384,402.15 C306.97,401.754 306.394,401.448 305.638,401.448 C304.252,401.448 303.658,402.438 303.658,403.878 C303.658,405.318 304.252,406.29 305.638,406.29 Z M316.708,408.18 C314.404,408.18 312.514,407.046 312.514,404.058 C312.514,400.872 314.638,399.864 316.6,399.864 C318.634,399.864 320.686,400.872 320.686,404.022 L320.686,404.454 L314.458,404.454 C314.512,405.84 315.196,406.686 316.744,406.686 C317.806,406.686 318.544,406.254 318.688,405.48 L320.668,405.48 C320.29,407.532 318.436,408.18 316.708,408.18 Z M314.494,403.104 L318.706,403.104 C318.544,401.88 317.644,401.358 316.6,401.358 C315.556,401.358 314.656,401.88 314.494,403.104 Z" id="PartyAwaitingPolyCha" fill="%23000000"></path><path d="M837.308,50 L837.308,42.044 L838.982,42.044 L838.982,43.124 C839.36,42.602 840.098,41.864 841.448,41.864 C842.96,41.864 844.292,42.512 844.292,45.086 L844.292,50 L842.366,50 L842.366,45.464 C842.366,44.168 842.096,43.466 840.926,43.466 C840.062,43.466 839.576,43.808 839.234,44.186 L839.234,50 L837.308,50 Z M850.322,52.826 C849.854,52.826 849.584,52.574 849.584,52.214 C849.584,52.07 849.602,51.944 849.62,51.818 L850.232,47.264 L853.112,47.264 L851.15,52.286 C851.006,52.646 850.79,52.826 850.322,52.826 Z M868.844,50 L868.844,42.044 L870.302,42.044 L870.302,43.178 C870.572,42.674 871.13,41.864 872.264,41.864 C873.2,41.864 873.722,42.476 873.884,43.088 C874.1,42.71 874.694,41.864 875.81,41.864 C877.052,41.864 877.556,42.926 877.556,44.51 L877.556,50 L875.846,50 L875.846,44.816 C875.846,43.844 875.666,43.448 875.162,43.448 C874.676,43.448 874.316,43.808 874.064,44.114 L874.064,50 L872.354,50 L872.354,44.816 C872.354,43.844 872.174,43.448 871.67,43.448 C871.184,43.448 870.806,43.808 870.554,44.114 L870.554,50 L868.844,50 Z" id="n,-m" fill="%23000000"></path><rect id="Rectangle" fill="%23000000" x="277" y="90" width="87" height="28" rx="5"></rect><rect id="Rectangle-Copy-2" fill="%23000000" x="815" y="90" width="87" height="28" rx="5"></rect><path d="M298.696,108 L298.696,98.848 L301.704,98.848 C303.912,98.848 305.608,99.76 305.608,101.872 C305.608,104 303.928,104.896 301.704,104.896 L300.472,104.896 L300.472,108 L298.696,108 Z M300.472,100.352 L300.472,103.408 L301.72,103.408 C303.144,103.408 303.768,102.848 303.768,101.872 C303.768,100.896 303.144,100.352 301.72,100.352 L300.472,100.352 Z M310.28,108.16 C308.904,108.16 307.784,107.552 307.784,106.144 C307.784,104.512 309.24,104.08 310.696,104.08 C311.432,104.08 312.216,104.208 312.632,104.336 L312.632,103.76 C312.632,102.848 312.472,102.128 311.16,102.128 C310.168,102.128 309.592,102.528 309.592,103.36 L307.976,103.36 C307.976,101.424 309.56,100.768 311.272,100.768 C313.112,100.768 314.344,101.552 314.344,103.536 L314.344,106.464 C314.344,106.736 314.44,106.832 314.728,106.832 C314.92,106.832 315.208,106.784 315.4,106.736 L315.4,107.872 C315.112,108 314.568,108.16 314.04,108.16 C313.144,108.16 312.888,107.696 312.888,107.168 L312.888,107.04 C312.52,107.504 311.736,108.16 310.28,108.16 Z M310.68,106.88 C311.576,106.88 312.28,106.576 312.632,106.288 L312.632,105.392 C312.328,105.312 311.672,105.248 311.064,105.248 C310.12,105.248 309.496,105.424 309.496,106.096 C309.496,106.64 309.896,106.88 310.68,106.88 Z M317.784,108 L317.784,106.656 L319.528,106.656 L319.528,102.288 L317.784,102.288 L317.784,100.928 L321.016,100.928 L321.016,102.528 C321.32,101.744 322.024,100.768 323.416,100.768 C323.944,100.768 324.424,100.896 324.744,101.072 L324.744,102.8 C324.392,102.592 323.848,102.464 323.384,102.464 C322.264,102.464 321.592,103.024 321.24,103.488 L321.24,106.656 L324.216,106.656 L324.216,108 L317.784,108 Z M331.704,108.16 C329.88,108.16 328.92,107.456 328.92,104.992 L328.92,102.288 L326.664,102.288 L326.664,100.928 L328.92,100.928 L328.92,97.648 L330.632,97.648 L330.632,100.928 L334.104,100.928 L334.104,102.288 L330.632,102.288 L330.632,104.928 C330.632,106.256 330.888,106.72 332.072,106.72 C332.728,106.72 333.336,106.576 333.832,106.368 L333.832,107.744 C333.32,107.968 332.648,108.16 331.704,108.16 Z M336.504,110.992 L336.504,109.584 C338.04,109.584 338.792,109.104 339.304,107.952 L336.168,100.928 L338.088,100.928 L339.448,104.272 L340.232,106.448 L341.032,104.288 L342.408,100.928 L344.232,100.928 L341.272,107.648 C340.184,110.096 339.144,110.992 336.504,110.992 Z" id="Party" fill="%23FFFFFF"></path><path d="M831.896,108 L831.896,98.848 L834.76,98.848 C837.8,98.848 838.824,100.56 838.824,103.424 C838.824,106.16 837.752,108 834.76,108 L831.896,108 Z M833.672,100.352 L833.672,106.496 L834.76,106.496 C836.696,106.496 836.968,105.04 836.968,103.424 C836.968,101.792 836.696,100.352 834.76,100.352 L833.672,100.352 Z M844.696,108.16 C842.648,108.16 840.968,107.152 840.968,104.496 C840.968,101.664 842.856,100.768 844.6,100.768 C846.408,100.768 848.232,101.664 848.232,104.464 L848.232,104.848 L842.696,104.848 C842.744,106.08 843.352,106.832 844.728,106.832 C845.672,106.832 846.328,106.448 846.456,105.76 L848.216,105.76 C847.88,107.584 846.232,108.16 844.696,108.16 Z M842.728,103.648 L846.472,103.648 C846.328,102.56 845.528,102.096 844.6,102.096 C843.672,102.096 842.872,102.56 842.728,103.648 Z M853.08,108.16 C851.704,108.16 850.584,107.552 850.584,106.144 C850.584,104.512 852.04,104.08 853.496,104.08 C854.232,104.08 855.016,104.208 855.432,104.336 L855.432,103.76 C855.432,102.848 855.272,102.128 853.96,102.128 C852.968,102.128 852.392,102.528 852.392,103.36 L850.776,103.36 C850.776,101.424 852.36,100.768 854.072,100.768 C855.912,100.768 857.144,101.552 857.144,103.536 L857.144,106.464 C857.144,106.736 857.24,106.832 857.528,106.832 C857.72,106.832 858.008,106.784 858.2,106.736 L858.2,107.872 C857.912,108 857.368,108.16 856.84,108.16 C855.944,108.16 855.688,107.696 855.688,107.168 L855.688,107.04 C855.32,107.504 854.536,108.16 853.08,108.16 Z M853.48,106.88 C854.376,106.88 855.08,106.576 855.432,106.288 L855.432,105.392 C855.128,105.312 854.472,105.248 853.864,105.248 C852.92,105.248 852.296,105.424 852.296,106.096 C852.296,106.64 852.696,106.88 853.48,106.88 Z M860.584,108 L860.584,106.656 L862.936,106.656 L862.936,98.992 L860.584,98.992 L860.584,97.648 L864.648,97.648 L864.648,106.656 L867.016,106.656 L867.016,108 L860.584,108 Z M873.496,108.16 C871.448,108.16 869.768,107.152 869.768,104.496 C869.768,101.664 871.656,100.768 873.4,100.768 C875.208,100.768 877.032,101.664 877.032,104.464 L877.032,104.848 L871.496,104.848 C871.544,106.08 872.152,106.832 873.528,106.832 C874.472,106.832 875.128,106.448 875.256,105.76 L877.016,105.76 C876.68,107.584 875.032,108.16 873.496,108.16 Z M871.528,103.648 L875.272,103.648 C875.128,102.56 874.328,102.096 873.4,102.096 C872.472,102.096 871.672,102.56 871.528,103.648 Z M879.784,108 L879.784,106.656 L881.528,106.656 L881.528,102.288 L879.784,102.288 L879.784,100.928 L883.016,100.928 L883.016,102.528 C883.32,101.744 884.024,100.768 885.416,100.768 C885.944,100.768 886.424,100.896 886.744,101.072 L886.744,102.8 C886.392,102.592 885.848,102.464 885.384,102.464 C884.264,102.464 883.592,103.024 883.24,103.488 L883.24,106.656 L886.216,106.656 L886.216,108 L879.784,108 Z" id="Dealer" fill="%23FFFFFF"></path><g id="Wireframe-Line-01" transform="translate(321.000000, 73.000000) rotate(-270.000000) translate(-321.000000, -73.000000) translate(306.000000, 64.000000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="22.75 1.375 29.25 7.875 22.75 14.375"></polyline>    <path d="M28,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(857.000000, 73.000000) rotate(-270.000000) translate(-857.000000, -73.000000) translate(842.000000, 64.000000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="22.75 1.375 29.25 7.875 22.75 14.375"></polyline>    <path d="M28,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(321.000000, 133.000000) rotate(-270.000000) translate(-321.000000, -133.000000) translate(306.000000, 124.000000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="22.75 1.375 29.25 7.875 22.75 14.375"></polyline>    <path d="M28,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(841.000000, 132.500000) rotate(-270.000000) translate(-841.000000, -132.500000) translate(826.500000, 123.500000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="21.75 1.375 28.25 7.875 21.75 14.375"></polyline>    <path d="M27,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(610.500000, 160.500000) rotate(-180.000000) translate(-610.500000, -160.500000) translate(442.000000, 153.000000)" stroke="%23000000"><g transform="translate(0.000000, 0.937500)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="329.75 0.0625 336.25 6.5625 329.75 13.0625"></polyline>    <path d="M335,6.5625 L0,6.5625" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(547.000000, 231.000000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="69.75 1.375 76.25 7.875 69.75 14.375"></polyline>    <path d="M75,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(541.000000, 394.000000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="81.75 1.375 88.25 7.875 81.75 14.375"></polyline>    <path d="M87,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(494.000000, 560.000000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="176.75 1.375 183.25 7.875 176.75 14.375"></polyline>    <path d="M182,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><g id="arrowhead" transform="translate(373.778175, 553.778175) rotate(-315.000000) translate(-373.778175, -553.778175) translate(369.778175, 546.778175)" stroke="%23000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><polyline points="0.75 0.5 7.25 7 0.75 13.5"></polyline></g><g id="arrowhead" transform="translate(821.778175, 630.778175) scale(-1, 1) rotate(-315.000000) translate(-821.778175, -630.778175) translate(817.778175, 623.778175)" stroke="%23000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><polyline points="0.75 0.5 7.25 7 0.75 13.5"></polyline></g><g id="arrowhead" transform="translate(676.000000, 486.000000) scale(-1, 1) translate(-676.000000, -486.000000) translate(672.000000, 479.000000)" stroke="%23000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><polyline points="0.75 0.5 7.25 7 0.75 13.5"></polyline></g><g id="arrowhead" transform="translate(676.000000, 321.500000) scale(-1, 1) translate(-676.000000, -321.500000) translate(672.000000, 314.500000)" stroke="%23000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><polyline points="0.75 0.5 7.25 7 0.75 13.5"></polyline></g><g id="arrowhead" transform="translate(373.778175, 384.778175) rotate(-315.000000) translate(-373.778175, -384.778175) translate(369.778175, 377.778175)" stroke="%23000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><polyline points="0.75 0.5 7.25 7 0.75 13.5"></polyline></g><g id="arrowhead" transform="translate(322.778175, 384.778175) scale(-1, 1) rotate(-315.000000) translate(-322.778175, -384.778175) translate(318.778175, 377.778175)" stroke="%23000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><polyline points="0.75 0.5 7.25 7 0.75 13.5"></polyline></g><g id="arrowhead" transform="translate(322.778175, 224.778175) scale(-1, 1) rotate(-315.000000) translate(-322.778175, -224.778175) translate(318.778175, 217.778175)" stroke="%23000000" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"><polyline points="0.75 0.5 7.25 7 0.75 13.5"></polyline></g><g id="Wireframe-Line-01" transform="translate(843.924414, 279.924414) rotate(-315.000000) translate(-843.924414, -279.924414) translate(804.583794, 271.288668)" stroke="%23000000"><g transform="translate(0.000000, 1.062500)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="71.75 0.9375 78.25 7.4375 71.75 13.9375"></polyline>    <path d="M77,7.4375 L0,7.4375" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(348.052514, 200.052514) rotate(-315.000000) translate(-348.052514, -200.052514) translate(309.143169, 191.511438)" stroke="%23000000"><g transform="translate(0.000000, 1.062500)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="70.75 0.9375 77.25 7.4375 70.75 13.9375"></polyline>    <path d="M76,7.4375 L0,7.4375" id="Line" stroke-width="2"></path></g></g><g id="Wireframe-Line-01" transform="translate(843.924414, 443.924414) rotate(-315.000000) translate(-843.924414, -443.924414) translate(804.583794, 435.288668)" stroke="%23000000"><g transform="translate(0.000000, 1.062500)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="71.75 0.9375 78.25 7.4375 71.75 13.9375"></polyline>    <path d="M77,7.4375 L0,7.4375" id="Line" stroke-width="2"></path></g></g><path d="M845.836047,606.191416 L821.206849,581.562218" id="Line" stroke="%23000000" stroke-width="2"></path><g id="Wireframe-Line-01" transform="translate(870.000000, 132.500000) rotate(-270.000000) translate(-870.000000, -132.500000) translate(855.500000, 123.500000)" stroke="%23000000"><g transform="translate(0.000000, 1.125000)">    <polyline id="arrowhead" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" points="21.75 1.375 28.25 7.875 21.75 14.375"></polyline>    <path d="M27,7.875 L0,7.875" id="Line" stroke-width="2"></path></g></g><path d="M870.516,177 L870.516,246.492644 C870.516,251.655184 868.519722,256.617752 864.944776,260.342209 L812.19419,315.298908 C808.42267,319.228159 803.211823,321.449344 797.765414,321.449344 L674.834952,321.449344" id="Line" stroke="%23000000" stroke-width="2" stroke-linecap="square"></path><path d="M494.255431,321 L435.991617,379.600514 C432.23763,383.376194 427.133095,385.499183 421.808795,385.499183 L321.899766,385.499183" id="Line-Copy-3" stroke="%23000000" stroke-width="2" stroke-linecap="square" transform="translate(408.077598, 353.249591) scale(-1, -1) translate(-408.077598, -353.249591) "></path><path d="M499.255431,485 L464.321993,519.975603 C460.570575,523.73155 455.47984,525.842 450.17133,525.842 L350.235595,525.842" id="Line-Copy-7" stroke="%23000000" stroke-width="2" stroke-linecap="square" transform="translate(424.745513, 505.421000) scale(-1, -1) translate(-424.745513, -505.421000) "></path><path d="M415.366581,291.03335 L369.250677,338.328995 C365.486474,342.189494 360.322983,344.366581 354.931075,344.366581 L279.96665,344.366581" id="Line-Copy-5" stroke="%23000000" stroke-width="2" stroke-linecap="square" transform="translate(347.666615, 317.699965) scale(-1, -1) rotate(-90.000000) translate(-347.666615, -317.699965) "></path><path d="M415.366581,460.03335 L369.250677,507.328995 C365.486474,511.189494 360.322983,513.366581 354.931075,513.366581 L279.96665,513.366581" id="Line-Copy-6" stroke="%23000000" stroke-width="2" stroke-linecap="square" transform="translate(347.666615, 486.699965) scale(-1, -1) rotate(-90.000000) translate(-347.666615, -486.699965) "></path><path d="M404.636204,161 L346.256104,219.772164 C342.501601,223.551881 337.394246,225.677436 332.066719,225.677436 L321.782378,225.677436" id="Line-Copy-4" stroke="%23000000" stroke-width="2" stroke-linecap="square" transform="translate(363.209291, 193.338718) scale(-1, -1) translate(-363.209291, -193.338718) "></path><path d="M870.516,338 L870.516,410.492644 C870.516,415.655184 868.519722,420.617752 864.944776,424.342209 L812.19419,479.298908 C808.42267,483.228159 803.211823,485.449344 797.765414,485.449344 L674.385158,485.449344" id="Line-Copy" stroke="%23000000" stroke-width="2" stroke-linecap="square"></path><path d="M870.516,503 L870.516,573.297182 C870.516,578.595077 868.413958,583.676527 864.67126,587.426181 L821.139355,631.038998" id="Line-Copy-2" stroke="%23000000" stroke-width="2" stroke-linecap="square"></path><circle id="Oval" stroke="%23000000" stroke-width="2" fill="%23FFFFFF" cx="845" cy="281" r="11"></circle><circle id="Oval-Copy-3" stroke="%23000000" stroke-width="2" fill="%23FFFFFF" cx="348" cy="200" r="11"></circle><circle id="Oval-Copy-4" stroke="%23000000" stroke-width="2" fill="%23FFFFFF" cx="348" cy="360" r="11"></circle><circle id="Oval-Copy-5" stroke="%23000000" stroke-width="2" fill="%23FFFFFF" cx="348" cy="528" r="11"></circle><circle id="Oval-Copy" stroke="%23000000" stroke-width="2" fill="%23FFFFFF" cx="845" cy="445" r="11"></circle><circle id="Oval-Copy-2" stroke="%23000000" stroke-width="2" fill="%23FFFFFF" cx="846" cy="606" r="11"></circle><path d="M868,166.646 L868,156.35 L871.222,156.35 C874.642,156.35 875.794,158.276 875.794,161.498 C875.794,164.576 874.588,166.646 871.222,166.646 L868,166.646 Z M869.998,158.042 L869.998,164.954 L871.222,164.954 C873.4,164.954 873.706,163.316 873.706,161.498 C873.706,159.662 873.4,158.042 871.222,158.042 L869.998,158.042 Z M882.4,166.826 C880.096,166.826 878.206,165.692 878.206,162.704 C878.206,159.518 880.33,158.51 882.292,158.51 C884.326,158.51 886.378,159.518 886.378,162.668 L886.378,163.1 L880.15,163.1 C880.204,164.486 880.888,165.332 882.436,165.332 C883.498,165.332 884.236,164.9 884.38,164.126 L886.36,164.126 C885.982,166.178 884.128,166.826 882.4,166.826 Z M880.186,161.75 L884.398,161.75 C884.236,160.526 883.336,160.004 882.292,160.004 C881.248,160.004 880.348,160.526 880.186,161.75 Z M891.832,166.826 C890.284,166.826 889.024,166.142 889.024,164.558 C889.024,162.722 890.662,162.236 892.3,162.236 C893.128,162.236 894.01,162.38 894.478,162.524 L894.478,161.876 C894.478,160.85 894.298,160.04 892.822,160.04 C891.706,160.04 891.058,160.49 891.058,161.426 L889.24,161.426 C889.24,159.248 891.022,158.51 892.948,158.51 C895.018,158.51 896.404,159.392 896.404,161.624 L896.404,164.918 C896.404,165.224 896.512,165.332 896.836,165.332 C897.052,165.332 897.376,165.278 897.592,165.224 L897.592,166.502 C897.268,166.646 896.656,166.826 896.062,166.826 C895.054,166.826 894.766,166.304 894.766,165.71 L894.766,165.566 C894.352,166.088 893.47,166.826 891.832,166.826 Z M892.282,165.386 C893.29,165.386 894.082,165.044 894.478,164.72 L894.478,163.712 C894.136,163.622 893.398,163.55 892.714,163.55 C891.652,163.55 890.95,163.748 890.95,164.504 C890.95,165.116 891.4,165.386 892.282,165.386 Z M900.274,166.646 L900.274,165.134 L902.92,165.134 L902.92,156.512 L900.274,156.512 L900.274,155 L904.846,155 L904.846,165.134 L907.51,165.134 L907.51,166.646 L900.274,166.646 Z M914.8,166.826 C912.496,166.826 910.606,165.692 910.606,162.704 C910.606,159.518 912.73,158.51 914.692,158.51 C916.726,158.51 918.778,159.518 918.778,162.668 L918.778,163.1 L912.55,163.1 C912.604,164.486 913.288,165.332 914.836,165.332 C915.898,165.332 916.636,164.9 916.78,164.126 L918.76,164.126 C918.382,166.178 916.528,166.826 914.8,166.826 Z M912.586,161.75 L916.798,161.75 C916.636,160.526 915.736,160.004 914.692,160.004 C913.648,160.004 912.748,160.526 912.586,161.75 Z M921.874,166.646 L921.874,165.134 L923.836,165.134 L923.836,160.22 L921.874,160.22 L921.874,158.69 L925.51,158.69 L925.51,160.49 C925.852,159.608 926.644,158.51 928.21,158.51 C928.804,158.51 929.344,158.654 929.704,158.852 L929.704,160.796 C929.308,160.562 928.696,160.418 928.174,160.418 C926.914,160.418 926.158,161.048 925.762,161.57 L925.762,165.134 L929.11,165.134 L929.11,166.646 L921.874,166.646 Z M931.612,166.646 L935.23,156.35 L937.354,156.35 L940.972,166.646 L938.83,166.646 L938.074,164.378 L934.456,164.378 L933.718,166.646 L931.612,166.646 Z M935.248,161.732 L934.906,162.794 L937.57,162.794 L937.228,161.732 L936.238,158.402 L935.248,161.732 Z M943.708,166.646 L942.322,158.69 L944.14,158.69 L944.968,165.116 L946.102,160.274 L948.118,160.274 L949.288,165.116 L950.098,158.69 L951.862,158.69 L950.476,166.646 L948.226,166.646 L947.092,162.074 L945.958,166.646 L943.708,166.646 Z M956.632,166.826 C955.084,166.826 953.824,166.142 953.824,164.558 C953.824,162.722 955.462,162.236 957.1,162.236 C957.928,162.236 958.81,162.38 959.278,162.524 L959.278,161.876 C959.278,160.85 959.098,160.04 957.622,160.04 C956.506,160.04 955.858,160.49 955.858,161.426 L954.04,161.426 C954.04,159.248 955.822,158.51 957.748,158.51 C959.818,158.51 961.204,159.392 961.204,161.624 L961.204,164.918 C961.204,165.224 961.312,165.332 961.636,165.332 C961.852,165.332 962.176,165.278 962.392,165.224 L962.392,166.502 C962.068,166.646 961.456,166.826 960.862,166.826 C959.854,166.826 959.566,166.304 959.566,165.71 L959.566,165.566 C959.152,166.088 958.27,166.826 956.632,166.826 Z M957.082,165.386 C958.09,165.386 958.882,165.044 959.278,164.72 L959.278,163.712 C958.936,163.622 958.198,163.55 957.514,163.55 C956.452,163.55 955.75,163.748 955.75,164.504 C955.75,165.116 956.2,165.386 957.082,165.386 Z M965.074,166.646 L965.074,165.134 L967.846,165.134 L967.846,160.22 L965.074,160.22 L965.074,158.69 L969.772,158.69 L969.772,165.134 L972.31,165.134 L972.31,166.646 L965.074,166.646 Z M967.648,157.178 L967.648,155 L970.006,155 L970.006,157.178 L967.648,157.178 Z M980.734,166.826 C978.682,166.826 977.602,166.034 977.602,163.262 L977.602,160.22 L975.064,160.22 L975.064,158.69 L977.602,158.69 L977.602,155 L979.528,155 L979.528,158.69 L983.434,158.69 L983.434,160.22 L979.528,160.22 L979.528,163.19 C979.528,164.684 979.816,165.206 981.148,165.206 C981.886,165.206 982.57,165.044 983.128,164.81 L983.128,166.358 C982.552,166.61 981.796,166.826 980.734,166.826 Z M986.674,166.646 L986.674,165.134 L989.446,165.134 L989.446,160.22 L986.674,160.22 L986.674,158.69 L991.372,158.69 L991.372,165.134 L993.91,165.134 L993.91,166.646 L986.674,166.646 Z M989.248,157.178 L989.248,155 L991.606,155 L991.606,157.178 L989.248,157.178 Z M997.6,166.646 L997.6,158.69 L999.274,158.69 L999.274,159.77 C999.652,159.248 1000.39,158.51 1001.74,158.51 C1003.252,158.51 1004.584,159.158 1004.584,161.732 L1004.584,166.646 L1002.658,166.646 L1002.658,162.11 C1002.658,160.814 1002.388,160.112 1001.218,160.112 C1000.354,160.112 999.868,160.454 999.526,160.832 L999.526,166.646 L997.6,166.646 Z M1011.55,170.102 C1009.786,170.102 1007.968,169.616 1007.914,167.114 L1009.768,167.114 C1009.822,168.05 1010.254,168.644 1011.622,168.644 C1013.278,168.644 1013.476,167.762 1013.476,166.7 L1013.476,165.566 C1013.098,165.962 1012.378,166.52 1011.154,166.52 C1009.3,166.52 1007.77,165.278 1007.77,162.542 C1007.77,159.788 1009.354,158.51 1011.154,158.51 C1012.45,158.51 1013.35,159.158 1013.728,159.716 L1013.728,158.69 L1015.402,158.69 L1015.402,166.862 C1015.402,169.004 1014.178,170.102 1011.55,170.102 Z M1011.73,164.936 C1012.486,164.936 1013.062,164.648 1013.476,164.252 L1013.476,160.796 C1013.062,160.4 1012.486,160.094 1011.73,160.094 C1010.344,160.094 1009.75,161.084 1009.75,162.524 C1009.75,163.964 1010.344,164.936 1011.73,164.936 Z M1019.2,166.646 L1019.2,156.35 L1022.728,156.35 C1025.104,156.35 1026.598,157.466 1026.598,159.23 C1026.598,160.382 1025.968,160.958 1025.248,161.3 C1026.04,161.57 1026.994,162.272 1026.994,163.658 C1026.994,165.44 1025.392,166.646 1023.052,166.646 L1019.2,166.646 Z M1021.198,162.2 L1021.198,164.99 L1022.926,164.99 C1024.474,164.99 1024.906,164.288 1024.906,163.568 C1024.906,162.776 1024.384,162.2 1022.89,162.2 L1021.198,162.2 Z M1021.198,158.024 L1021.198,160.616 L1022.494,160.616 C1023.988,160.616 1024.51,160.166 1024.51,159.356 C1024.51,158.618 1024.096,158.024 1022.548,158.024 L1021.198,158.024 Z M1029.874,166.646 L1029.874,165.134 L1032.646,165.134 L1032.646,160.22 L1029.874,160.22 L1029.874,158.69 L1034.572,158.69 L1034.572,165.134 L1037.11,165.134 L1037.11,166.646 L1029.874,166.646 Z M1032.448,157.178 L1032.448,155 L1034.806,155 L1034.806,157.178 L1032.448,157.178 Z M1045.534,166.826 C1043.482,166.826 1042.402,166.034 1042.402,163.262 L1042.402,160.22 L1039.864,160.22 L1039.864,158.69 L1042.402,158.69 L1042.402,155 L1044.328,155 L1044.328,158.69 L1048.234,158.69 L1048.234,160.22 L1044.328,160.22 L1044.328,163.19 C1044.328,164.684 1044.616,165.206 1045.948,165.206 C1046.686,165.206 1047.37,165.044 1047.928,164.81 L1047.928,166.358 C1047.352,166.61 1046.596,166.826 1045.534,166.826 Z M1055.2,166.826 C1052.14,166.826 1050.808,164.846 1050.808,161.498 C1050.808,158.186 1052.302,156.17 1055.236,156.17 C1057.63,156.17 1059.25,157.214 1059.376,160.004 L1057.342,160.004 C1057.216,158.546 1056.532,157.88 1055.236,157.88 C1053.22,157.88 1052.878,159.536 1052.878,161.498 C1052.878,163.424 1053.22,165.098 1055.236,165.098 C1056.55,165.098 1057.216,164.432 1057.342,162.992 L1059.376,162.992 C1059.232,165.746 1057.54,166.826 1055.2,166.826 Z M1065.892,166.826 C1063.876,166.826 1061.788,165.89 1061.788,162.668 C1061.788,159.464 1064.002,158.51 1065.892,158.51 C1067.908,158.51 1069.996,159.428 1069.996,162.668 C1069.996,165.854 1067.782,166.826 1065.892,166.826 Z M1065.892,165.242 C1067.26,165.242 1068.034,164.432 1068.034,162.668 C1068.034,160.886 1067.26,160.094 1065.892,160.094 C1064.524,160.094 1063.75,160.886 1063.75,162.668 C1063.75,164.432 1064.524,165.242 1065.892,165.242 Z M1072.336,166.646 L1072.336,158.69 L1073.794,158.69 L1073.794,159.824 C1074.064,159.32 1074.622,158.51 1075.756,158.51 C1076.692,158.51 1077.214,159.122 1077.376,159.734 C1077.592,159.356 1078.186,158.51 1079.302,158.51 C1080.544,158.51 1081.048,159.572 1081.048,161.156 L1081.048,166.646 L1079.338,166.646 L1079.338,161.462 C1079.338,160.49 1079.158,160.094 1078.654,160.094 C1078.168,160.094 1077.808,160.454 1077.556,160.76 L1077.556,166.646 L1075.846,166.646 L1075.846,161.462 C1075.846,160.49 1075.666,160.094 1075.162,160.094 C1074.676,160.094 1074.298,160.454 1074.046,160.76 L1074.046,166.646 L1072.336,166.646 Z M1083.136,166.646 L1083.136,158.69 L1084.594,158.69 L1084.594,159.824 C1084.864,159.32 1085.422,158.51 1086.556,158.51 C1087.492,158.51 1088.014,159.122 1088.176,159.734 C1088.392,159.356 1088.986,158.51 1090.102,158.51 C1091.344,158.51 1091.848,159.572 1091.848,161.156 L1091.848,166.646 L1090.138,166.646 L1090.138,161.462 C1090.138,160.49 1089.958,160.094 1089.454,160.094 C1088.968,160.094 1088.608,160.454 1088.356,160.76 L1088.356,166.646 L1086.646,166.646 L1086.646,161.462 C1086.646,160.49 1086.466,160.094 1085.962,160.094 C1085.476,160.094 1085.098,160.454 1084.846,160.76 L1084.846,166.646 L1083.136,166.646 Z M1094.674,166.646 L1094.674,165.134 L1097.446,165.134 L1097.446,160.22 L1094.674,160.22 L1094.674,158.69 L1099.372,158.69 L1099.372,165.134 L1101.91,165.134 L1101.91,166.646 L1094.674,166.646 Z M1097.248,157.178 L1097.248,155 L1099.606,155 L1099.606,157.178 L1097.248,157.178 Z M1110.334,166.826 C1108.282,166.826 1107.202,166.034 1107.202,163.262 L1107.202,160.22 L1104.664,160.22 L1104.664,158.69 L1107.202,158.69 L1107.202,155 L1109.128,155 L1109.128,158.69 L1113.034,158.69 L1113.034,160.22 L1109.128,160.22 L1109.128,163.19 C1109.128,164.684 1109.416,165.206 1110.748,165.206 C1111.486,165.206 1112.17,165.044 1112.728,164.81 L1112.728,166.358 C1112.152,166.61 1111.396,166.826 1110.334,166.826 Z M1115.536,166.646 L1115.536,158.69 L1116.994,158.69 L1116.994,159.824 C1117.264,159.32 1117.822,158.51 1118.956,158.51 C1119.892,158.51 1120.414,159.122 1120.576,159.734 C1120.792,159.356 1121.386,158.51 1122.502,158.51 C1123.744,158.51 1124.248,159.572 1124.248,161.156 L1124.248,166.646 L1122.538,166.646 L1122.538,161.462 C1122.538,160.49 1122.358,160.094 1121.854,160.094 C1121.368,160.094 1121.008,160.454 1120.756,160.76 L1120.756,166.646 L1119.046,166.646 L1119.046,161.462 C1119.046,160.49 1118.866,160.094 1118.362,160.094 C1117.876,160.094 1117.498,160.454 1117.246,160.76 L1117.246,166.646 L1115.536,166.646 Z M1130.8,166.826 C1128.496,166.826 1126.606,165.692 1126.606,162.704 C1126.606,159.518 1128.73,158.51 1130.692,158.51 C1132.726,158.51 1134.778,159.518 1134.778,162.668 L1134.778,163.1 L1128.55,163.1 C1128.604,164.486 1129.288,165.332 1130.836,165.332 C1131.898,165.332 1132.636,164.9 1132.78,164.126 L1134.76,164.126 C1134.382,166.178 1132.528,166.826 1130.8,166.826 Z M1128.586,161.75 L1132.798,161.75 C1132.636,160.526 1131.736,160.004 1130.692,160.004 C1129.648,160.004 1128.748,160.526 1128.586,161.75 Z M1138,166.646 L1138,158.69 L1139.674,158.69 L1139.674,159.77 C1140.052,159.248 1140.79,158.51 1142.14,158.51 C1143.652,158.51 1144.984,159.158 1144.984,161.732 L1144.984,166.646 L1143.058,166.646 L1143.058,162.11 C1143.058,160.814 1142.788,160.112 1141.618,160.112 C1140.754,160.112 1140.268,160.454 1139.926,160.832 L1139.926,166.646 L1138,166.646 Z M1153.534,166.826 C1151.482,166.826 1150.402,166.034 1150.402,163.262 L1150.402,160.22 L1147.864,160.22 L1147.864,158.69 L1150.402,158.69 L1150.402,155 L1152.328,155 L1152.328,158.69 L1156.234,158.69 L1156.234,160.22 L1152.328,160.22 L1152.328,163.19 C1152.328,164.684 1152.616,165.206 1153.948,165.206 C1154.686,165.206 1155.37,165.044 1155.928,164.81 L1155.928,166.358 C1155.352,166.61 1154.596,166.826 1153.534,166.826 Z" id="DealerAwaitingBitCom" fill="%23000000"></path><path d="M521,325.646 L521,315.35 L524.528,315.35 C526.904,315.35 528.398,316.466 528.398,318.23 C528.398,319.382 527.768,319.958 527.048,320.3 C527.84,320.57 528.794,321.272 528.794,322.658 C528.794,324.44 527.192,325.646 524.852,325.646 L521,325.646 Z M522.998,321.2 L522.998,323.99 L524.726,323.99 C526.274,323.99 526.706,323.288 526.706,322.568 C526.706,321.776 526.184,321.2 524.69,321.2 L522.998,321.2 Z M522.998,317.024 L522.998,319.616 L524.294,319.616 C525.788,319.616 526.31,319.166 526.31,318.356 C526.31,317.618 525.896,317.024 524.348,317.024 L522.998,317.024 Z M531.674,325.646 L531.674,324.134 L534.446,324.134 L534.446,319.22 L531.674,319.22 L531.674,317.69 L536.372,317.69 L536.372,324.134 L538.91,324.134 L538.91,325.646 L531.674,325.646 Z M534.248,316.178 L534.248,314 L536.606,314 L536.606,316.178 L534.248,316.178 Z M547.334,325.826 C545.282,325.826 544.202,325.034 544.202,322.262 L544.202,319.22 L541.664,319.22 L541.664,317.69 L544.202,317.69 L544.202,314 L546.128,314 L546.128,317.69 L550.034,317.69 L550.034,319.22 L546.128,319.22 L546.128,322.19 C546.128,323.684 546.416,324.206 547.748,324.206 C548.486,324.206 549.17,324.044 549.728,323.81 L549.728,325.358 C549.152,325.61 548.396,325.826 547.334,325.826 Z M557,325.826 C553.94,325.826 552.608,323.846 552.608,320.498 C552.608,317.186 554.102,315.17 557.036,315.17 C559.43,315.17 561.05,316.214 561.176,319.004 L559.142,319.004 C559.016,317.546 558.332,316.88 557.036,316.88 C555.02,316.88 554.678,318.536 554.678,320.498 C554.678,322.424 555.02,324.098 557.036,324.098 C558.35,324.098 559.016,323.432 559.142,321.992 L561.176,321.992 C561.032,324.746 559.34,325.826 557,325.826 Z M564.2,325.646 L564.2,314 L566.126,314 L566.126,318.572 C566.396,318.212 567.134,317.51 568.376,317.51 C569.888,317.51 571.184,318.158 571.184,320.732 L571.184,325.646 L569.258,325.646 L569.258,321.11 C569.258,319.814 568.988,319.112 567.818,319.112 C566.954,319.112 566.468,319.454 566.126,319.832 L566.126,325.646 L564.2,325.646 Z M577.232,325.826 C575.684,325.826 574.424,325.142 574.424,323.558 C574.424,321.722 576.062,321.236 577.7,321.236 C578.528,321.236 579.41,321.38 579.878,321.524 L579.878,320.876 C579.878,319.85 579.698,319.04 578.222,319.04 C577.106,319.04 576.458,319.49 576.458,320.426 L574.64,320.426 C574.64,318.248 576.422,317.51 578.348,317.51 C580.418,317.51 581.804,318.392 581.804,320.624 L581.804,323.918 C581.804,324.224 581.912,324.332 582.236,324.332 C582.452,324.332 582.776,324.278 582.992,324.224 L582.992,325.502 C582.668,325.646 582.056,325.826 581.462,325.826 C580.454,325.826 580.166,325.304 580.166,324.71 L580.166,324.566 C579.752,325.088 578.87,325.826 577.232,325.826 Z M577.682,324.386 C578.69,324.386 579.482,324.044 579.878,323.72 L579.878,322.712 C579.536,322.622 578.798,322.55 578.114,322.55 C577.052,322.55 576.35,322.748 576.35,323.504 C576.35,324.116 576.8,324.386 577.682,324.386 Z M585.674,325.646 L585.674,324.134 L588.32,324.134 L588.32,315.512 L585.674,315.512 L585.674,314 L590.246,314 L590.246,324.134 L592.91,324.134 L592.91,325.646 L585.674,325.646 Z M596.474,325.646 L596.474,324.134 L599.12,324.134 L599.12,315.512 L596.474,315.512 L596.474,314 L601.046,314 L601.046,324.134 L603.71,324.134 L603.71,325.646 L596.474,325.646 Z M611,325.826 C608.696,325.826 606.806,324.692 606.806,321.704 C606.806,318.518 608.93,317.51 610.892,317.51 C612.926,317.51 614.978,318.518 614.978,321.668 L614.978,322.1 L608.75,322.1 C608.804,323.486 609.488,324.332 611.036,324.332 C612.098,324.332 612.836,323.9 612.98,323.126 L614.96,323.126 C614.582,325.178 612.728,325.826 611,325.826 Z M608.786,320.75 L612.998,320.75 C612.836,319.526 611.936,319.004 610.892,319.004 C609.848,319.004 608.948,319.526 608.786,320.75 Z M618.2,325.646 L618.2,317.69 L619.874,317.69 L619.874,318.77 C620.252,318.248 620.99,317.51 622.34,317.51 C623.852,317.51 625.184,318.158 625.184,320.732 L625.184,325.646 L623.258,325.646 L623.258,321.11 C623.258,319.814 622.988,319.112 621.818,319.112 C620.954,319.112 620.468,319.454 620.126,319.832 L620.126,325.646 L618.2,325.646 Z M632.15,329.102 C630.386,329.102 628.568,328.616 628.514,326.114 L630.368,326.114 C630.422,327.05 630.854,327.644 632.222,327.644 C633.878,327.644 634.076,326.762 634.076,325.7 L634.076,324.566 C633.698,324.962 632.978,325.52 631.754,325.52 C629.9,325.52 628.37,324.278 628.37,321.542 C628.37,318.788 629.954,317.51 631.754,317.51 C633.05,317.51 633.95,318.158 634.328,318.716 L634.328,317.69 L636.002,317.69 L636.002,325.862 C636.002,328.004 634.778,329.102 632.15,329.102 Z M632.33,323.936 C633.086,323.936 633.662,323.648 634.076,323.252 L634.076,319.796 C633.662,319.4 633.086,319.094 632.33,319.094 C630.944,319.094 630.35,320.084 630.35,321.524 C630.35,322.964 630.944,323.936 632.33,323.936 Z M643.4,325.826 C641.096,325.826 639.206,324.692 639.206,321.704 C639.206,318.518 641.33,317.51 643.292,317.51 C645.326,317.51 647.378,318.518 647.378,321.668 L647.378,322.1 L641.15,322.1 C641.204,323.486 641.888,324.332 643.436,324.332 C644.498,324.332 645.236,323.9 645.38,323.126 L647.36,323.126 C646.982,325.178 645.128,325.826 643.4,325.826 Z M641.186,320.75 L645.398,320.75 C645.236,319.526 644.336,319.004 643.292,319.004 C642.248,319.004 641.348,319.526 641.186,320.75 Z" id="BitChallenge" fill="%23000000"></path><path d="M391,244.646 L391,234.35 L394.528,234.35 C396.904,234.35 398.398,235.466 398.398,237.23 C398.398,238.382 397.768,238.958 397.048,239.3 C397.84,239.57 398.794,240.272 398.794,241.658 C398.794,243.44 397.192,244.646 394.852,244.646 L391,244.646 Z M392.998,240.2 L392.998,242.99 L394.726,242.99 C396.274,242.99 396.706,242.288 396.706,241.568 C396.706,240.776 396.184,240.2 394.69,240.2 L392.998,240.2 Z M392.998,236.024 L392.998,238.616 L394.294,238.616 C395.788,238.616 396.31,238.166 396.31,237.356 C396.31,236.618 395.896,236.024 394.348,236.024 L392.998,236.024 Z M401.674,244.646 L401.674,243.134 L404.446,243.134 L404.446,238.22 L401.674,238.22 L401.674,236.69 L406.372,236.69 L406.372,243.134 L408.91,243.134 L408.91,244.646 L401.674,244.646 Z M404.248,235.178 L404.248,233 L406.606,233 L406.606,235.178 L404.248,235.178 Z M417.334,244.826 C415.282,244.826 414.202,244.034 414.202,241.262 L414.202,238.22 L411.664,238.22 L411.664,236.69 L414.202,236.69 L414.202,233 L416.128,233 L416.128,236.69 L420.034,236.69 L420.034,238.22 L416.128,238.22 L416.128,241.19 C416.128,242.684 416.416,243.206 417.748,243.206 C418.486,243.206 419.17,243.044 419.728,242.81 L419.728,244.358 C419.152,244.61 418.396,244.826 417.334,244.826 Z M427,244.826 C423.94,244.826 422.608,242.846 422.608,239.498 C422.608,236.186 424.102,234.17 427.036,234.17 C429.43,234.17 431.05,235.214 431.176,238.004 L429.142,238.004 C429.016,236.546 428.332,235.88 427.036,235.88 C425.02,235.88 424.678,237.536 424.678,239.498 C424.678,241.424 425.02,243.098 427.036,243.098 C428.35,243.098 429.016,242.432 429.142,240.992 L431.176,240.992 C431.032,243.746 429.34,244.826 427,244.826 Z M437.692,244.826 C435.676,244.826 433.588,243.89 433.588,240.668 C433.588,237.464 435.802,236.51 437.692,236.51 C439.708,236.51 441.796,237.428 441.796,240.668 C441.796,243.854 439.582,244.826 437.692,244.826 Z M437.692,243.242 C439.06,243.242 439.834,242.432 439.834,240.668 C439.834,238.886 439.06,238.094 437.692,238.094 C436.324,238.094 435.55,238.886 435.55,240.668 C435.55,242.432 436.324,243.242 437.692,243.242 Z M444.136,244.646 L444.136,236.69 L445.594,236.69 L445.594,237.824 C445.864,237.32 446.422,236.51 447.556,236.51 C448.492,236.51 449.014,237.122 449.176,237.734 C449.392,237.356 449.986,236.51 451.102,236.51 C452.344,236.51 452.848,237.572 452.848,239.156 L452.848,244.646 L451.138,244.646 L451.138,239.462 C451.138,238.49 450.958,238.094 450.454,238.094 C449.968,238.094 449.608,238.454 449.356,238.76 L449.356,244.646 L447.646,244.646 L447.646,239.462 C447.646,238.49 447.466,238.094 446.962,238.094 C446.476,238.094 446.098,238.454 445.846,238.76 L445.846,244.646 L444.136,244.646 Z M454.936,244.646 L454.936,236.69 L456.394,236.69 L456.394,237.824 C456.664,237.32 457.222,236.51 458.356,236.51 C459.292,236.51 459.814,237.122 459.976,237.734 C460.192,237.356 460.786,236.51 461.902,236.51 C463.144,236.51 463.648,237.572 463.648,239.156 L463.648,244.646 L461.938,244.646 L461.938,239.462 C461.938,238.49 461.758,238.094 461.254,238.094 C460.768,238.094 460.408,238.454 460.156,238.76 L460.156,244.646 L458.446,244.646 L458.446,239.462 C458.446,238.49 458.266,238.094 457.762,238.094 C457.276,238.094 456.898,238.454 456.646,238.76 L456.646,244.646 L454.936,244.646 Z M466.474,244.646 L466.474,243.134 L469.246,243.134 L469.246,238.22 L466.474,238.22 L466.474,236.69 L471.172,236.69 L471.172,243.134 L473.71,243.134 L473.71,244.646 L466.474,244.646 Z M469.048,235.178 L469.048,233 L471.406,233 L471.406,235.178 L469.048,235.178 Z M482.134,244.826 C480.082,244.826 479.002,244.034 479.002,241.262 L479.002,238.22 L476.464,238.22 L476.464,236.69 L479.002,236.69 L479.002,233 L480.928,233 L480.928,236.69 L484.834,236.69 L484.834,238.22 L480.928,238.22 L480.928,241.19 C480.928,242.684 481.216,243.206 482.548,243.206 C483.286,243.206 483.97,243.044 484.528,242.81 L484.528,244.358 C483.952,244.61 483.196,244.826 482.134,244.826 Z M487.336,244.646 L487.336,236.69 L488.794,236.69 L488.794,237.824 C489.064,237.32 489.622,236.51 490.756,236.51 C491.692,236.51 492.214,237.122 492.376,237.734 C492.592,237.356 493.186,236.51 494.302,236.51 C495.544,236.51 496.048,237.572 496.048,239.156 L496.048,244.646 L494.338,244.646 L494.338,239.462 C494.338,238.49 494.158,238.094 493.654,238.094 C493.168,238.094 492.808,238.454 492.556,238.76 L492.556,244.646 L490.846,244.646 L490.846,239.462 C490.846,238.49 490.666,238.094 490.162,238.094 C489.676,238.094 489.298,238.454 489.046,238.76 L489.046,244.646 L487.336,244.646 Z M502.6,244.826 C500.296,244.826 498.406,243.692 498.406,240.704 C498.406,237.518 500.53,236.51 502.492,236.51 C504.526,236.51 506.578,237.518 506.578,240.668 L506.578,241.1 L500.35,241.1 C500.404,242.486 501.088,243.332 502.636,243.332 C503.698,243.332 504.436,242.9 504.58,242.126 L506.56,242.126 C506.182,244.178 504.328,244.826 502.6,244.826 Z M500.386,239.75 L504.598,239.75 C504.436,238.526 503.536,238.004 502.492,238.004 C501.448,238.004 500.548,238.526 500.386,239.75 Z M509.8,244.646 L509.8,236.69 L511.474,236.69 L511.474,237.77 C511.852,237.248 512.59,236.51 513.94,236.51 C515.452,236.51 516.784,237.158 516.784,239.732 L516.784,244.646 L514.858,244.646 L514.858,240.11 C514.858,238.814 514.588,238.112 513.418,238.112 C512.554,238.112 512.068,238.454 511.726,238.832 L511.726,244.646 L509.8,244.646 Z M525.334,244.826 C523.282,244.826 522.202,244.034 522.202,241.262 L522.202,238.22 L519.664,238.22 L519.664,236.69 L522.202,236.69 L522.202,233 L524.128,233 L524.128,236.69 L528.034,236.69 L528.034,238.22 L524.128,238.22 L524.128,241.19 C524.128,242.684 524.416,243.206 525.748,243.206 C526.486,243.206 527.17,243.044 527.728,242.81 L527.728,244.358 C527.152,244.61 526.396,244.826 525.334,244.826 Z" id="BitCommitment" fill="%23000000"></path><path d="M643,247.922 L643,233 L648.652,233 L648.652,234.512 L644.728,234.512 L644.728,246.41 L648.652,246.41 L648.652,247.922 L643,247.922 Z M652.342,244.646 L652.342,234.35 L655.87,234.35 C658.246,234.35 659.74,235.466 659.74,237.23 C659.74,238.382 659.11,238.958 658.39,239.3 C659.182,239.57 660.136,240.272 660.136,241.658 C660.136,243.44 658.534,244.646 656.194,244.646 L652.342,244.646 Z M654.34,240.2 L654.34,242.99 L656.068,242.99 C657.616,242.99 658.048,242.288 658.048,241.568 C658.048,240.776 657.526,240.2 656.032,240.2 L654.34,240.2 Z M654.34,236.024 L654.34,238.616 L655.636,238.616 C657.13,238.616 657.652,238.166 657.652,237.356 C657.652,236.618 657.238,236.024 655.69,236.024 L654.34,236.024 Z M663.016,244.646 L663.016,243.134 L665.788,243.134 L665.788,238.22 L663.016,238.22 L663.016,236.69 L667.714,236.69 L667.714,243.134 L670.252,243.134 L670.252,244.646 L663.016,244.646 Z M665.59,235.178 L665.59,233 L667.948,233 L667.948,235.178 L665.59,235.178 Z M678.676,244.826 C676.624,244.826 675.544,244.034 675.544,241.262 L675.544,238.22 L673.006,238.22 L673.006,236.69 L675.544,236.69 L675.544,233 L677.47,233 L677.47,236.69 L681.376,236.69 L681.376,238.22 L677.47,238.22 L677.47,241.19 C677.47,242.684 677.758,243.206 679.09,243.206 C679.828,243.206 680.512,243.044 681.07,242.81 L681.07,244.358 C680.494,244.61 679.738,244.826 678.676,244.826 Z M688.342,244.826 C685.282,244.826 683.95,242.846 683.95,239.498 C683.95,236.186 685.444,234.17 688.378,234.17 C690.772,234.17 692.392,235.214 692.518,238.004 L690.484,238.004 C690.358,236.546 689.674,235.88 688.378,235.88 C686.362,235.88 686.02,237.536 686.02,239.498 C686.02,241.424 686.362,243.098 688.378,243.098 C689.692,243.098 690.358,242.432 690.484,240.992 L692.518,240.992 C692.374,243.746 690.682,244.826 688.342,244.826 Z M699.034,244.826 C697.018,244.826 694.93,243.89 694.93,240.668 C694.93,237.464 697.144,236.51 699.034,236.51 C701.05,236.51 703.138,237.428 703.138,240.668 C703.138,243.854 700.924,244.826 699.034,244.826 Z M699.034,243.242 C700.402,243.242 701.176,242.432 701.176,240.668 C701.176,238.886 700.402,238.094 699.034,238.094 C697.666,238.094 696.892,238.886 696.892,240.668 C696.892,242.432 697.666,243.242 699.034,243.242 Z M705.478,244.646 L705.478,236.69 L706.936,236.69 L706.936,237.824 C707.206,237.32 707.764,236.51 708.898,236.51 C709.834,236.51 710.356,237.122 710.518,237.734 C710.734,237.356 711.328,236.51 712.444,236.51 C713.686,236.51 714.19,237.572 714.19,239.156 L714.19,244.646 L712.48,244.646 L712.48,239.462 C712.48,238.49 712.3,238.094 711.796,238.094 C711.31,238.094 710.95,238.454 710.698,238.76 L710.698,244.646 L708.988,244.646 L708.988,239.462 C708.988,238.49 708.808,238.094 708.304,238.094 C707.818,238.094 707.44,238.454 707.188,238.76 L707.188,244.646 L705.478,244.646 Z M716.278,244.646 L716.278,236.69 L717.736,236.69 L717.736,237.824 C718.006,237.32 718.564,236.51 719.698,236.51 C720.634,236.51 721.156,237.122 721.318,237.734 C721.534,237.356 722.128,236.51 723.244,236.51 C724.486,236.51 724.99,237.572 724.99,239.156 L724.99,244.646 L723.28,244.646 L723.28,239.462 C723.28,238.49 723.1,238.094 722.596,238.094 C722.11,238.094 721.75,238.454 721.498,238.76 L721.498,244.646 L719.788,244.646 L719.788,239.462 C719.788,238.49 719.608,238.094 719.104,238.094 C718.618,238.094 718.24,238.454 717.988,238.76 L717.988,244.646 L716.278,244.646 Z M727.816,244.646 L727.816,243.134 L730.588,243.134 L730.588,238.22 L727.816,238.22 L727.816,236.69 L732.514,236.69 L732.514,243.134 L735.052,243.134 L735.052,244.646 L727.816,244.646 Z M730.39,235.178 L730.39,233 L732.748,233 L732.748,235.178 L730.39,235.178 Z M743.476,244.826 C741.424,244.826 740.344,244.034 740.344,241.262 L740.344,238.22 L737.806,238.22 L737.806,236.69 L740.344,236.69 L740.344,233 L742.27,233 L742.27,236.69 L746.176,236.69 L746.176,238.22 L742.27,238.22 L742.27,241.19 C742.27,242.684 742.558,243.206 743.89,243.206 C744.628,243.206 745.312,243.044 745.87,242.81 L745.87,244.358 C745.294,244.61 744.538,244.826 743.476,244.826 Z M748.678,244.646 L748.678,236.69 L750.136,236.69 L750.136,237.824 C750.406,237.32 750.964,236.51 752.098,236.51 C753.034,236.51 753.556,237.122 753.718,237.734 C753.934,237.356 754.528,236.51 755.644,236.51 C756.886,236.51 757.39,237.572 757.39,239.156 L757.39,244.646 L755.68,244.646 L755.68,239.462 C755.68,238.49 755.5,238.094 754.996,238.094 C754.51,238.094 754.15,238.454 753.898,238.76 L753.898,244.646 L752.188,244.646 L752.188,239.462 C752.188,238.49 752.008,238.094 751.504,238.094 C751.018,238.094 750.64,238.454 750.388,238.76 L750.388,244.646 L748.678,244.646 Z M763.942,244.826 C761.638,244.826 759.748,243.692 759.748,240.704 C759.748,237.518 761.872,236.51 763.834,236.51 C765.868,236.51 767.92,237.518 767.92,240.668 L767.92,241.1 L761.692,241.1 C761.746,242.486 762.43,243.332 763.978,243.332 C765.04,243.332 765.778,242.9 765.922,242.126 L767.902,242.126 C767.524,244.178 765.67,244.826 763.942,244.826 Z M761.728,239.75 L765.94,239.75 C765.778,238.526 764.878,238.004 763.834,238.004 C762.79,238.004 761.89,238.526 761.728,239.75 Z M771.142,244.646 L771.142,236.69 L772.816,236.69 L772.816,237.77 C773.194,237.248 773.932,236.51 775.282,236.51 C776.794,236.51 778.126,237.158 778.126,239.732 L778.126,244.646 L776.2,244.646 L776.2,240.11 C776.2,238.814 775.93,238.112 774.76,238.112 C773.896,238.112 773.41,238.454 773.068,238.832 L773.068,244.646 L771.142,244.646 Z M786.676,244.826 C784.624,244.826 783.544,244.034 783.544,241.262 L783.544,238.22 L781.006,238.22 L781.006,236.69 L783.544,236.69 L783.544,233 L785.47,233 L785.47,236.69 L789.376,236.69 L789.376,238.22 L785.47,238.22 L785.47,241.19 C785.47,242.684 785.758,243.206 787.09,243.206 C787.828,243.206 788.512,243.044 789.07,242.81 L789.07,244.358 C788.494,244.61 787.738,244.826 786.676,244.826 Z M792.634,247.922 L792.634,246.41 L796.558,246.41 L796.558,234.512 L792.634,234.512 L792.634,233 L798.268,233 L798.268,247.922 L792.634,247.922 Z" id="[BitCommitment]" fill="%23000000"></path><path d="M51,242.646 L51,232.35 L54.384,232.35 C56.868,232.35 58.776,233.376 58.776,235.752 C58.776,238.146 56.886,239.154 54.384,239.154 L52.998,239.154 L52.998,242.646 L51,242.646 Z M52.998,234.042 L52.998,237.48 L54.402,237.48 C56.004,237.48 56.706,236.85 56.706,235.752 C56.706,234.654 56.004,234.042 54.402,234.042 L52.998,234.042 Z M64.032,242.826 C62.484,242.826 61.224,242.142 61.224,240.558 C61.224,238.722 62.862,238.236 64.5,238.236 C65.328,238.236 66.21,238.38 66.678,238.524 L66.678,237.876 C66.678,236.85 66.498,236.04 65.022,236.04 C63.906,236.04 63.258,236.49 63.258,237.426 L61.44,237.426 C61.44,235.248 63.222,234.51 65.148,234.51 C67.218,234.51 68.604,235.392 68.604,237.624 L68.604,240.918 C68.604,241.224 68.712,241.332 69.036,241.332 C69.252,241.332 69.576,241.278 69.792,241.224 L69.792,242.502 C69.468,242.646 68.856,242.826 68.262,242.826 C67.254,242.826 66.966,242.304 66.966,241.71 L66.966,241.566 C66.552,242.088 65.67,242.826 64.032,242.826 Z M64.482,241.386 C65.49,241.386 66.282,241.044 66.678,240.72 L66.678,239.712 C66.336,239.622 65.598,239.55 64.914,239.55 C63.852,239.55 63.15,239.748 63.15,240.504 C63.15,241.116 63.6,241.386 64.482,241.386 Z M72.474,242.646 L72.474,241.134 L74.436,241.134 L74.436,236.22 L72.474,236.22 L72.474,234.69 L76.11,234.69 L76.11,236.49 C76.452,235.608 77.244,234.51 78.81,234.51 C79.404,234.51 79.944,234.654 80.304,234.852 L80.304,236.796 C79.908,236.562 79.296,236.418 78.774,236.418 C77.514,236.418 76.758,237.048 76.362,237.57 L76.362,241.134 L79.71,241.134 L79.71,242.646 L72.474,242.646 Z M88.134,242.826 C86.082,242.826 85.002,242.034 85.002,239.262 L85.002,236.22 L82.464,236.22 L82.464,234.69 L85.002,234.69 L85.002,231 L86.928,231 L86.928,234.69 L90.834,234.69 L90.834,236.22 L86.928,236.22 L86.928,239.19 C86.928,240.684 87.216,241.206 88.548,241.206 C89.286,241.206 89.97,241.044 90.528,240.81 L90.528,242.358 C89.952,242.61 89.196,242.826 88.134,242.826 Z M93.534,246.012 L93.534,244.428 C95.262,244.428 96.108,243.888 96.684,242.592 L93.156,234.69 L95.316,234.69 L96.846,238.452 L97.728,240.9 L98.628,238.47 L100.176,234.69 L102.228,234.69 L98.898,242.25 C97.674,245.004 96.504,246.012 93.534,246.012 Z M103.812,242.646 L107.43,232.35 L109.554,232.35 L113.172,242.646 L111.03,242.646 L110.274,240.378 L106.656,240.378 L105.918,242.646 L103.812,242.646 Z M107.448,237.732 L107.106,238.794 L109.77,238.794 L109.428,237.732 L108.438,234.402 L107.448,237.732 Z M115.908,242.646 L114.522,234.69 L116.34,234.69 L117.168,241.116 L118.302,236.274 L120.318,236.274 L121.488,241.116 L122.298,234.69 L124.062,234.69 L122.676,242.646 L120.426,242.646 L119.292,238.074 L118.158,242.646 L115.908,242.646 Z M128.832,242.826 C127.284,242.826 126.024,242.142 126.024,240.558 C126.024,238.722 127.662,238.236 129.3,238.236 C130.128,238.236 131.01,238.38 131.478,238.524 L131.478,237.876 C131.478,236.85 131.298,236.04 129.822,236.04 C128.706,236.04 128.058,236.49 128.058,237.426 L126.24,237.426 C126.24,235.248 128.022,234.51 129.948,234.51 C132.018,234.51 133.404,235.392 133.404,237.624 L133.404,240.918 C133.404,241.224 133.512,241.332 133.836,241.332 C134.052,241.332 134.376,241.278 134.592,241.224 L134.592,242.502 C134.268,242.646 133.656,242.826 133.062,242.826 C132.054,242.826 131.766,242.304 131.766,241.71 L131.766,241.566 C131.352,242.088 130.47,242.826 128.832,242.826 Z M129.282,241.386 C130.29,241.386 131.082,241.044 131.478,240.72 L131.478,239.712 C131.136,239.622 130.398,239.55 129.714,239.55 C128.652,239.55 127.95,239.748 127.95,240.504 C127.95,241.116 128.4,241.386 129.282,241.386 Z M137.274,242.646 L137.274,241.134 L140.046,241.134 L140.046,236.22 L137.274,236.22 L137.274,234.69 L141.972,234.69 L141.972,241.134 L144.51,241.134 L144.51,242.646 L137.274,242.646 Z M139.848,233.178 L139.848,231 L142.206,231 L142.206,233.178 L139.848,233.178 Z M152.934,242.826 C150.882,242.826 149.802,242.034 149.802,239.262 L149.802,236.22 L147.264,236.22 L147.264,234.69 L149.802,234.69 L149.802,231 L151.728,231 L151.728,234.69 L155.634,234.69 L155.634,236.22 L151.728,236.22 L151.728,239.19 C151.728,240.684 152.016,241.206 153.348,241.206 C154.086,241.206 154.77,241.044 155.328,240.81 L155.328,242.358 C154.752,242.61 153.996,242.826 152.934,242.826 Z M158.874,242.646 L158.874,241.134 L161.646,241.134 L161.646,236.22 L158.874,236.22 L158.874,234.69 L163.572,234.69 L163.572,241.134 L166.11,241.134 L166.11,242.646 L158.874,242.646 Z M161.448,233.178 L161.448,231 L163.806,231 L163.806,233.178 L161.448,233.178 Z M169.8,242.646 L169.8,234.69 L171.474,234.69 L171.474,235.77 C171.852,235.248 172.59,234.51 173.94,234.51 C175.452,234.51 176.784,235.158 176.784,237.732 L176.784,242.646 L174.858,242.646 L174.858,238.11 C174.858,236.814 174.588,236.112 173.418,236.112 C172.554,236.112 172.068,236.454 171.726,236.832 L171.726,242.646 L169.8,242.646 Z M183.75,246.102 C181.986,246.102 180.168,245.616 180.114,243.114 L181.968,243.114 C182.022,244.05 182.454,244.644 183.822,244.644 C185.478,244.644 185.676,243.762 185.676,242.7 L185.676,241.566 C185.298,241.962 184.578,242.52 183.354,242.52 C181.5,242.52 179.97,241.278 179.97,238.542 C179.97,235.788 181.554,234.51 183.354,234.51 C184.65,234.51 185.55,235.158 185.928,235.716 L185.928,234.69 L187.602,234.69 L187.602,242.862 C187.602,245.004 186.378,246.102 183.75,246.102 Z M183.93,240.936 C184.686,240.936 185.262,240.648 185.676,240.252 L185.676,236.796 C185.262,236.4 184.686,236.094 183.93,236.094 C182.544,236.094 181.95,237.084 181.95,238.524 C181.95,239.964 182.544,240.936 183.93,240.936 Z M191.4,242.646 L191.4,232.35 L194.928,232.35 C197.304,232.35 198.798,233.466 198.798,235.23 C198.798,236.382 198.168,236.958 197.448,237.3 C198.24,237.57 199.194,238.272 199.194,239.658 C199.194,241.44 197.592,242.646 195.252,242.646 L191.4,242.646 Z M193.398,238.2 L193.398,240.99 L195.126,240.99 C196.674,240.99 197.106,240.288 197.106,239.568 C197.106,238.776 196.584,238.2 195.09,238.2 L193.398,238.2 Z M193.398,234.024 L193.398,236.616 L194.694,236.616 C196.188,236.616 196.71,236.166 196.71,235.356 C196.71,234.618 196.296,234.024 194.748,234.024 L193.398,234.024 Z M202.074,242.646 L202.074,241.134 L204.846,241.134 L204.846,236.22 L202.074,236.22 L202.074,234.69 L206.772,234.69 L206.772,241.134 L209.31,241.134 L209.31,242.646 L202.074,242.646 Z M204.648,233.178 L204.648,231 L207.006,231 L207.006,233.178 L204.648,233.178 Z M217.734,242.826 C215.682,242.826 214.602,242.034 214.602,239.262 L214.602,236.22 L212.064,236.22 L212.064,234.69 L214.602,234.69 L214.602,231 L216.528,231 L216.528,234.69 L220.434,234.69 L220.434,236.22 L216.528,236.22 L216.528,239.19 C216.528,240.684 216.816,241.206 218.148,241.206 C218.886,241.206 219.57,241.044 220.128,240.81 L220.128,242.358 C219.552,242.61 218.796,242.826 217.734,242.826 Z M227.4,242.826 C224.34,242.826 223.008,240.846 223.008,237.498 C223.008,234.186 224.502,232.17 227.436,232.17 C229.83,232.17 231.45,233.214 231.576,236.004 L229.542,236.004 C229.416,234.546 228.732,233.88 227.436,233.88 C225.42,233.88 225.078,235.536 225.078,237.498 C225.078,239.424 225.42,241.098 227.436,241.098 C228.75,241.098 229.416,240.432 229.542,238.992 L231.576,238.992 C231.432,241.746 229.74,242.826 227.4,242.826 Z M234.6,242.646 L234.6,231 L236.526,231 L236.526,235.572 C236.796,235.212 237.534,234.51 238.776,234.51 C240.288,234.51 241.584,235.158 241.584,237.732 L241.584,242.646 L239.658,242.646 L239.658,238.11 C239.658,236.814 239.388,236.112 238.218,236.112 C237.354,236.112 236.868,236.454 236.526,236.832 L236.526,242.646 L234.6,242.646 Z M247.632,242.826 C246.084,242.826 244.824,242.142 244.824,240.558 C244.824,238.722 246.462,238.236 248.1,238.236 C248.928,238.236 249.81,238.38 250.278,238.524 L250.278,237.876 C250.278,236.85 250.098,236.04 248.622,236.04 C247.506,236.04 246.858,236.49 246.858,237.426 L245.04,237.426 C245.04,235.248 246.822,234.51 248.748,234.51 C250.818,234.51 252.204,235.392 252.204,237.624 L252.204,240.918 C252.204,241.224 252.312,241.332 252.636,241.332 C252.852,241.332 253.176,241.278 253.392,241.224 L253.392,242.502 C253.068,242.646 252.456,242.826 251.862,242.826 C250.854,242.826 250.566,242.304 250.566,241.71 L250.566,241.566 C250.152,242.088 249.27,242.826 247.632,242.826 Z M248.082,241.386 C249.09,241.386 249.882,241.044 250.278,240.72 L250.278,239.712 C249.936,239.622 249.198,239.55 248.514,239.55 C247.452,239.55 246.75,239.748 246.75,240.504 C246.75,241.116 247.2,241.386 248.082,241.386 Z M256.074,242.646 L256.074,241.134 L258.72,241.134 L258.72,232.512 L256.074,232.512 L256.074,231 L260.646,231 L260.646,241.134 L263.31,241.134 L263.31,242.646 L256.074,242.646 Z M266.874,242.646 L266.874,241.134 L269.52,241.134 L269.52,232.512 L266.874,232.512 L266.874,231 L271.446,231 L271.446,241.134 L274.11,241.134 L274.11,242.646 L266.874,242.646 Z M281.4,242.826 C279.096,242.826 277.206,241.692 277.206,238.704 C277.206,235.518 279.33,234.51 281.292,234.51 C283.326,234.51 285.378,235.518 285.378,238.668 L285.378,239.1 L279.15,239.1 C279.204,240.486 279.888,241.332 281.436,241.332 C282.498,241.332 283.236,240.9 283.38,240.126 L285.36,240.126 C284.982,242.178 283.128,242.826 281.4,242.826 Z M279.186,237.75 L283.398,237.75 C283.236,236.526 282.336,236.004 281.292,236.004 C280.248,236.004 279.348,236.526 279.186,237.75 Z M288.6,242.646 L288.6,234.69 L290.274,234.69 L290.274,235.77 C290.652,235.248 291.39,234.51 292.74,234.51 C294.252,234.51 295.584,235.158 295.584,237.732 L295.584,242.646 L293.658,242.646 L293.658,238.11 C293.658,236.814 293.388,236.112 292.218,236.112 C291.354,236.112 290.868,236.454 290.526,236.832 L290.526,242.646 L288.6,242.646 Z M302.55,246.102 C300.786,246.102 298.968,245.616 298.914,243.114 L300.768,243.114 C300.822,244.05 301.254,244.644 302.622,244.644 C304.278,244.644 304.476,243.762 304.476,242.7 L304.476,241.566 C304.098,241.962 303.378,242.52 302.154,242.52 C300.3,242.52 298.77,241.278 298.77,238.542 C298.77,235.788 300.354,234.51 302.154,234.51 C303.45,234.51 304.35,235.158 304.728,235.716 L304.728,234.69 L306.402,234.69 L306.402,242.862 C306.402,245.004 305.178,246.102 302.55,246.102 Z M302.73,240.936 C303.486,240.936 304.062,240.648 304.476,240.252 L304.476,236.796 C304.062,236.4 303.486,236.094 302.73,236.094 C301.344,236.094 300.75,237.084 300.75,238.524 C300.75,239.964 301.344,240.936 302.73,240.936 Z M313.8,242.826 C311.496,242.826 309.606,241.692 309.606,238.704 C309.606,235.518 311.73,234.51 313.692,234.51 C315.726,234.51 317.778,235.518 317.778,238.668 L317.778,239.1 L311.55,239.1 C311.604,240.486 312.288,241.332 313.836,241.332 C314.898,241.332 315.636,240.9 315.78,240.126 L317.76,240.126 C317.382,242.178 315.528,242.826 313.8,242.826 Z M311.586,237.75 L315.798,237.75 C315.636,236.526 314.736,236.004 313.692,236.004 C312.648,236.004 311.748,236.526 311.586,237.75 Z" id="PartyAwaitingBitChal" fill="%23000000"></path></g></svg>'/>

First, \\(m\\) [`Party`](../range_proof/party/struct.Party.html) objects are instantiated with their secret values and the range for the range proof. A [`Dealer`](../range_proof/dealer/struct.Dealer.html) object is instantiated with \\(n\\) and \\(m\\). The dealer assigns a unique index \\(j\\) to each party.

Next, each `Party` commits to their secret value, bits, and blinding factors via \\(V_{(j)}, A_{(j)}, S_{(j)}\\) and sends this data in a [`BitCommitment`](../range_proof/messages/struct.BitCommitment.html) to the dealer. The dealer receives and combines all of the `BitCommitment` messages from all of the parties, generates challenges \\(y, z\\), and sends \\(y, z\\) as [`BitChallenge`](../range_proof/messages/struct.BitChallenge.html) to all of the parties.

Then, each party commits to the resulting polynomials via \\(T_{1, (j)}, T_{2, (j)}\\) and sends this data in a `PolyCommitment` to the dealer. The dealer receives and combines all of the [`PolyCommitment`](../range_proof/messages/struct.PolyCommitment.html) messages from all of the parties, generates challenge \\(x\\), and sends \\(x\\) as [`PolyChallenge`](../range_proof/messages/struct.PolyChallenge.html) to all of the parties.

Finally, each party evaluates their polynomial at \\(x\\) and returns the result as [`ProofShare`](../range_proof/messages/struct.ProofShare.html) to the dealer. The dealer combines all \\(m\\) `ProofShare` messages and returns the aggregated range proof, [`RangeProof`](../struct.RangeProof.html).

Party and Dealer state machines
-------------------------------

We wanted a foolproof model that would prevent users from performing any step other than the correct next step of the protocol. In our implementation, we treated each party and dealer as a state machine, and modeled each party and dealer state as a distinct type. We used move semantics to ensure that a previous state is consumed as it transitions to the next state. 

Due to the type system, we have a guarantee that one step of the protocol can't be performed twice, since the first function call for that step would consume the object, and therefore the function would not be able to be called on that object another time. We also have a guarantee that the user can't perform steps out of order or skip steps, since it is impossible to call a function on an object that is not of the correct corresponding type. 
