pub const WORDS: [&str; 5000] = [
    "book",
    "on",
    "his",
    "forefinger",
    "to",
    "look",
    "at",
    "the",
    "name",
    "of",
    "the",
    "author.",
    "Swinburne!",
    "he",
    "would",
    "remember",
    "that",
    "name.",
    "That",
    "fellow",
    "had",
    "eyes,",
    "and",
    "he",
    "had",
    "certainly",
    "seen",
    "color",
    "and",
    "flashing",
    "light.",
    "But",
    "who",
    "was",
    "Swinburne?",
    "Was",
    "he",
    "dead",
    "a",
    "hundred",
    "years",
    "or",
    "so,",
    "like",
    "most",
    "of",
    "the",
    "poets?",
    "Or",
    "was",
    "he",
    "alive",
    "still,",
    "and",
    "writing?",
    "He",
    "turned",
    "to",
    "the",
    "title-page�",
    "yes,",
    "he",
    "had",
    "written",
    "other",
    "books;",
    "well,",
    "he",
    "would",
    "go",
    "to",
    "the",
    "free",
    "library",
    "the",
    "first",
    "thing",
    "in",
    "the",
    "morning",
    "and",
    "try",
    "to",
    "get",
    "hold",
    "of",
    "some",
    "of",
    "Swinburne�s",
    "stuff.",
    "He",
    "went",
    "back",
    "to",
    "the",
    "text",
    "and",
    "lost",
    "himself.",
    "He",
    "did",
    "not",
    "notice",
    "that",
    "a",
    "young",
    "woman",
    "had",
    "entered",
    "the",
    "room.",
    "The",
    "first",
    "he",
    "knew",
    "was",
    "when",
    "he",
    "heard",
    "Arthur�s",
    "voice",
    "saying:-",
    "Ruth,",
    "this",
    "is",
    "Mr.",
    "Eden.",
    "The",
    "book",
    "was",
    "closed",
    "on",
    "his",
    "forefinger,",
    "and",
    "before",
    "he",
    "turned",
    "he",
    "was",
    "thrilling",
    "to",
    "the",
    "first",
    "new",
    "impression,",
    "which",
    "was",
    "not",
    "of",
    "the",
    "girl,",
    "but",
    "of",
    "her",
    "brother�s",
    "words.",
    "Under",
    "that",
    "muscled",
    "body",
    "of",
    "his",
    "he",
    "was",
    "a",
    "mass",
    "of",
    "quivering",
    "sensibilities.",
    "At",
    "the",
    "slightest",
    "impact",
    "of",
    "the",
    "outside",
    "world",
    "upon",
    "his",
    "consciousness,",
    "his",
    "thoughts,",
    "sympathies,",
    "and",
    "emotions",
    "leapt",
    "and",
    "played",
    "like",
    "lambent",
    "flame.",
    "He",
    "was",
    "extraordinarily",
    "receptive",
    "and",
    "responsive,",
    "while",
    "his",
    "imagination,",
    "pitched",
    "high,",
    "was",
    "ever",
    "at",
    "work",
    "establishing",
    "relations",
    "of",
    "likeness",
    "and",
    "difference.",
    "Mr.",
    "Eden,",
    "was",
    "what",
    "he",
    "had",
    "thrilled",
    "to-he",
    "who",
    "had",
    "been",
    "called",
    "Eden,",
    "or",
    "Martin",
    "Eden,",
    "or",
    "just",
    "Martin,",
    "all",
    "his",
    "life.",
    "And",
    "",
    "Mister",
    "!",
    "It",
    "was",
    "certainly",
    "going",
    "some,",
    "was",
    "his",
    "internal",
    "comment.",
    "His",
    "mind",
    "seemed",
    "to",
    "turn,",
    "on",
    "the",
    "instant,",
    "into",
    "a",
    "vast",
    "camera",
    "obscura,",
    "and",
    "he",
    "saw",
    "arrayed",
    "around",
    "his",
    "consciousness",
    "endless",
    "pictures",
    "from",
    "his",
    "life,",
    "of",
    "stoke-holes",
    "and",
    "forecastles,",
    "camps",
    "and",
    "beaches,",
    "jails",
    "and",
    "boozing-kens,",
    "fever-hospitals",
    "and",
    "slum",
    "streets,",
    "wherein",
    "the",
    "thread",
    "of",
    "association",
    "was",
    "the",
    "fashion",
    "in",
    "which",
    "he",
    "had",
    "been",
    "addressed",
    "in",
    "those",
    "various",
    "situations.",
    "And",
    "then",
    "he",
    "turned",
    "and",
    "saw",
    "the",
    "girl.",
    "The",
    "phantasmagoria",
    "of",
    "his",
    "brain",
    "vanished",
    "at",
    "sight",
    "of",
    "her.",
    "She",
    "was",
    "a",
    "pale,",
    "ethereal",
    "creature,",
    "with",
    "wide,",
    "spiritual",
    "blue",
    "eyes",
    "and",
    "a",
    "wealth",
    "of",
    "golden",
    "hair.",
    "He",
    "did",
    "not",
    "know",
    "how",
    "she",
    "was",
    "dressed,",
    "except",
    "that",
    "the",
    "dress",
    "was",
    "as",
    "wonderful",
    "as",
    "she.",
    "He",
    "likened",
    "her",
    "to",
    "a",
    "pale",
    "gold",
    "flower",
    "upon",
    "a",
    "slender",
    "stem.",
    "No,",
    "she",
    "was",
    "a",
    "spirit,",
    "a",
    "divinity,",
    "a",
    "goddess;",
    "such",
    "sublimated",
    "beauty",
    "was",
    "not",
    "of",
    "the",
    "earth.",
    "Or",
    "perhaps",
    "the",
    "books",
    "were",
    "right,",
    "and",
    "there",
    "were",
    "many",
    "such",
    "as",
    "she",
    "in",
    "the",
    "upper",
    "walks",
    "of",
    "life.",
    "She",
    "might",
    "well",
    "be",
    "sung",
    "by",
    "that",
    "chap,",
    "Swinburne.",
    "Perhaps",
    "he",
    "had",
    "had",
    "somebody",
    "like",
    "her",
    "in",
    "mind",
    "when",
    "he",
    "painted",
    "that",
    "girl,",
    "Iseult,",
    "in",
    "the",
    "book",
    "there",
    "on",
    "the",
    "table.",
    "All",
    "this",
    "plethora",
    "of",
    "sight,",
    "and",
    "feeling,",
    "and",
    "thought",
    "occurred",
    "on",
    "the",
    "instant.",
    "There",
    "was",
    "no",
    "pause",
    "of",
    "the",
    "realities",
    "wherein",
    "he",
    "moved.",
    "He",
    "saw",
    "her",
    "hand",
    "coming",
    "out",
    "to",
    "his,",
    "and",
    "she",
    "looked",
    "him",
    "straight",
    "in",
    "the",
    "eyes",
    "as",
    "she",
    "shook",
    "hands,",
    "frankly,",
    "like",
    "a",
    "man.",
    "The",
    "women",
    "he",
    "had",
    "known",
    "did",
    "not",
    "shake",
    "hands",
    "that",
    "way.",
    "For",
    "that",
    "matter,",
    "most",
    "of",
    "them",
    "did",
    "not",
    "shake",
    "hands",
    "at",
    "all.",
    "A",
    "flood",
    "of",
    "associations,",
    "visions",
    "of",
    "various",
    "ways",
    "he",
    "had",
    "made",
    "the",
    "acquaintance",
    "of",
    "women,",
    "rushed",
    "into",
    "his",
    "mind",
    "and",
    "threatened",
    "to",
    "swamp",
    "it.",
    "But",
    "he",
    "shook",
    "them",
    "aside",
    "and",
    "looked",
    "at",
    "her.",
    "Never",
    "had",
    "he",
    "seen",
    "such",
    "a",
    "woman.",
    "The",
    "women",
    "he",
    "had",
    "known!",
    "Immediately,",
    "beside",
    "her,",
    "on",
    "either",
    "hand,",
    "ranged",
    "the",
    "women",
    "he",
    "had",
    "known.",
    "For",
    "an",
    "eternal",
    "second",
    "he",
    "stood",
    "in",
    "the",
    "midst",
    "of",
    "a",
    "portrait",
    "gallery,",
    "wherein",
    "she",
    "occupied",
    "the",
    "central",
    "place,",
    "while",
    "about",
    "her",
    "were",
    "limned",
    "many",
    "women,",
    "all",
    "to",
    "be",
    "weighed",
    "and",
    "measured",
    "by",
    "a",
    "fleeting",
    "glance,",
    "herself",
    "the",
    "unit",
    "of",
    "weight",
    "and",
    "measure.",
    "He",
    "saw",
    "the",
    "weak",
    "and",
    "sickly",
    "faces",
    "of",
    "the",
    "girls",
    "of",
    "the",
    "factories,",
    "and",
    "the",
    "simpering,",
    "boisterous",
    "girls",
    "from",
    "the",
    "south",
    "of",
    "Market.",
    "There",
    "were",
    "women",
    "of",
    "the",
    "cattle",
    "camps,",
    "and",
    "swarthy",
    "cigarette-smoking",
    "women",
    "of",
    "Old",
    "Mexico.",
    "These,",
    "in",
    "turn,",
    "were",
    "crowded",
    "out",
    "by",
    "Japanese",
    "women,",
    "doll-like,",
    "stepping",
    "mincingly",
    "on",
    "wooden",
    "clogs;",
    "by",
    "Eurasians,",
    "delicate",
    "featured,",
    "stamped",
    "with",
    "degeneracy;",
    "by",
    "full-bodied",
    "South-Sea-Island",
    "women,",
    "flower-crowned",
    "and",
    "brown-skinned.",
    "All",
    "these",
    "were",
    "blotted",
    "out",
    "by",
    "a",
    "grotesque",
    "and",
    "terrible",
    "nightmare",
    "brood-frowsy,",
    "shuffling",
    "creatures",
    "from",
    "the",
    "pavements",
    "of",
    "Whitechapel,",
    "gin-bloated",
    "hags",
    "of",
    "the",
    "stews,",
    "and",
    "all",
    "the",
    "vast",
    "hell�s",
    "following",
    "of",
    "harpies,",
    "vile-mouthed",
    "and",
    "filthy,",
    "that",
    "under",
    "the",
    "guise",
    "of",
    "monstrous",
    "female",
    "form",
    "prey",
    "upon",
    "sailors,",
    "the",
    "scrapings",
    "of",
    "the",
    "ports,",
    "the",
    "scum",
    "and",
    "slime",
    "of",
    "the",
    "human",
    "pit.",
    "Won�t",
    "you",
    "sit",
    "down,",
    "Mr.",
    "Eden?",
    "the",
    "girl",
    "was",
    "saying.",
    "I",
    "have",
    "been",
    "looking",
    "forward",
    "to",
    "meeting",
    "you",
    "ever",
    "since",
    "Arthur",
    "told",
    "us.",
    "It",
    "was",
    "brave",
    "of",
    "you-",
    "He",
    "waved",
    "his",
    "hand",
    "deprecatingly",
    "and",
    "muttered",
    "that",
    "it",
    "was",
    "nothing",
    "at",
    "all,",
    "what",
    "he",
    "had",
    "done,",
    "and",
    "that",
    "any",
    "fellow",
    "would",
    "have",
    "done",
    "it.",
    "She",
    "noticed",
    "that",
    "the",
    "hand",
    "he",
    "waved",
    "was",
    "covered",
    "with",
    "fresh",
    "abrasions,",
    "in",
    "the",
    "process",
    "of",
    "healing,",
    "and",
    "a",
    "glance",
    "at",
    "the",
    "other",
    "loose-hanging",
    "hand",
    "showed",
    "it",
    "to",
    "be",
    "in",
    "the",
    "same",
    "condition.",
    "Also,",
    "with",
    "quick,",
    "critical",
    "eye,",
    "she",
    "noted",
    "a",
    "scar",
    "on",
    "his",
    "cheek,",
    "another",
    "that",
    "peeped",
    "out",
    "from",
    "under",
    "the",
    "hair",
    "of",
    "the",
    "forehead,",
    "and",
    "a",
    "third",
    "that",
    "ran",
    "down",
    "and",
    "disappeared",
    "under",
    "the",
    "starched",
    "collar.",
    "She",
    "repressed",
    "a",
    "smile",
    "at",
    "sight",
    "of",
    "the",
    "red",
    "line",
    "that",
    "marked",
    "the",
    "chafe",
    "of",
    "the",
    "collar",
    "against",
    "the",
    "bronzed",
    "neck.",
    "He",
    "was",
    "evidently",
    "unused",
    "to",
    "stiff",
    "collars.",
    "Likewise",
    "her",
    "feminine",
    "eye",
    "took",
    "in",
    "the",
    "clothes",
    "he",
    "wore,",
    "the",
    "cheap",
    "and",
    "unaesthetic",
    "cut,",
    "the",
    "wrinkling",
    "of",
    "the",
    "coat",
    "across",
    "the",
    "shoulders,",
    "and",
    "the",
    "series",
    "of",
    "wrinkles",
    "in",
    "the",
    "sleeves",
    "that",
    "advertised",
    "bulging",
    "biceps",
    "muscles.",
    "While",
    "he",
    "waved",
    "his",
    "hand",
    "and",
    "muttered",
    "that",
    "he",
    "had",
    "done",
    "nothing",
    "at",
    "all,",
    "he",
    "was",
    "obeying",
    "her",
    "behest",
    "by",
    "trying",
    "to",
    "get",
    "into",
    "a",
    "chair.",
    "He",
    "found",
    "time",
    "to",
    "admire",
    "the",
    "ease",
    "with",
    "which",
    "she",
    "sat",
    "down,",
    "then",
    "lurched",
    "toward",
    "a",
    "chair",
    "facing",
    "her,",
    "overwhelmed",
    "with",
    "consciousness",
    "of",
    "the",
    "awkward",
    "figure",
    "he",
    "was",
    "cutting.",
    "This",
    "was",
    "a",
    "new",
    "experience",
    "for",
    "him.",
    "All",
    "his",
    "life,",
    "up",
    "to",
    "then,",
    "he",
    "had",
    "been",
    "unaware",
    "of",
    "being",
    "either",
    "graceful",
    "or",
    "awkward.",
    "Such",
    "thoughts",
    "of",
    "self",
    "had",
    "never",
    "entered",
    "his",
    "mind.",
    "He",
    "sat",
    "down",
    "gingerly",
    "on",
    "the",
    "edge",
    "of",
    "the",
    "chair,",
    "greatly",
    "worried",
    "by",
    "his",
    "hands.",
    "They",
    "were",
    "in",
    "the",
    "way",
    "wherever",
    "he",
    "put",
    "them.",
    "Arthur",
    "was",
    "leaving",
    "the",
    "room,",
    "and",
    "Martin",
    "Eden",
    "followed",
    "his",
    "exit",
    "with",
    "longing",
    "eyes.",
    "He",
    "felt",
    "lost,",
    "alone",
    "there",
    "in",
    "the",
    "room",
    "with",
    "that",
    "pale",
    "spirit",
    "of",
    "a",
    "woman.",
    "There",
    "was",
    "no",
    "bar-keeper",
    "upon",
    "whom",
    "to",
    "call",
    "for",
    "drinks,",
    "no",
    "small",
    "boy",
    "to",
    "send",
    "around",
    "the",
    "corner",
    "for",
    "a",
    "can",
    "of",
    "beer",
    "and",
    "by",
    "means",
    "of",
    "that",
    "social",
    "fluid",
    "start",
    "the",
    "amenities",
    "of",
    "friendship",
    "flowing.",
    "You",
    "have",
    "such",
    "a",
    "scar",
    "on",
    "your",
    "neck,",
    "Mr.",
    "Eden,",
    "the",
    "girl",
    "was",
    "saying.",
    "How",
    "did",
    "it",
    "happen?",
    "I",
    "am",
    "sure",
    "it",
    "must",
    "have",
    "been",
    "some",
    "adventure.",
    "A",
    "Mexican",
    "with",
    "a",
    "knife,",
    "miss,",
    "he",
    "answered,",
    "moistening",
    "his",
    "parched",
    "lips",
    "and",
    "clearing",
    "hip",
    "throat.",
    "It",
    "was",
    "just",
    "a",
    "fight.",
    "After",
    "I",
    "got",
    "the",
    "knife",
    "away,",
    "he",
    "tried",
    "to",
    "bite",
    "off",
    "my",
    "nose.",
    "Baldly",
    "as",
    "he",
    "had",
    "stated",
    "it,",
    "in",
    "his",
    "eyes",
    "was",
    "a",
    "rich",
    "vision",
    "of",
    "that",
    "hot,",
    "starry",
    "night",
    "at",
    "Salina",
    "Cruz,",
    "the",
    "white",
    "strip",
    "of",
    "beach,",
    "the",
    "lights",
    "of",
    "the",
    "sugar",
    "steamers",
    "in",
    "the",
    "harbor,",
    "the",
    "voices",
    "of",
    "the",
    "drunken",
    "sailors",
    "in",
    "the",
    "distance,",
    "the",
    "jostling",
    "stevedores,",
    "the",
    "flaming",
    "passion",
    "in",
    "the",
    "Mexican�s",
    "face,",
    "the",
    "glint",
    "of",
    "the",
    "beast-eyes",
    "in",
    "the",
    "starlight,",
    "the",
    "sting",
    "of",
    "the",
    "steel",
    "in",
    "his",
    "neck,",
    "and",
    "the",
    "rush",
    "of",
    "blood,",
    "the",
    "crowd",
    "and",
    "the",
    "cries,",
    "the",
    "two",
    "bodies,",
    "his",
    "and",
    "the",
    "Mexican�s,",
    "locked",
    "together,",
    "rolling",
    "over",
    "and",
    "over",
    "and",
    "tearing",
    "up",
    "the",
    "sand,",
    "and",
    "from",
    "away",
    "off",
    "somewhere",
    "the",
    "mellow",
    "tinkling",
    "of",
    "a",
    "guitar.",
    "Such",
    "was",
    "the",
    "picture,",
    "and",
    "he",
    "thrilled",
    "to",
    "the",
    "memory",
    "of",
    "it,",
    "wondering",
    "if",
    "the",
    "man",
    "could",
    "paint",
    "it",
    "who",
    "had",
    "painted",
    "the",
    "pilot-schooner",
    "on",
    "the",
    "wall.",
    "The",
    "white",
    "beach,",
    "the",
    "stars,",
    "and",
    "the",
    "lights",
    "of",
    "the",
    "sugar",
    "steamers",
    "would",
    "look",
    "great,",
    "he",
    "thought,",
    "and",
    "midway",
    "on",
    "the",
    "sand",
    "the",
    "dark",
    "group",
    "of",
    "figures",
    "that",
    "surrounded",
    "the",
    "fighters.",
    "The",
    "knife",
    "occupied",
    "a",
    "place",
    "in",
    "the",
    "picture,",
    "he",
    "decided,",
    "and",
    "would",
    "show",
    "well,",
    "with",
    "a",
    "sort",
    "of",
    "gleam,",
    "in",
    "the",
    "light",
    "of",
    "the",
    "stars.",
    "But",
    "of",
    "all",
    "this",
    "no",
    "hint",
    "had",
    "crept",
    "into",
    "his",
    "speech.",
    "He",
    "tried",
    "to",
    "bite",
    "off",
    "my",
    "nose,",
    "he",
    "concluded.",
    "Oh,",
    "the",
    "girl",
    "said,",
    "in",
    "a",
    "faint,",
    "far",
    "voice,",
    "and",
    "he",
    "noticed",
    "the",
    "shock",
    "in",
    "her",
    "sensitive",
    "face.",
    "He",
    "felt",
    "a",
    "shock",
    "himself,",
    "and",
    "a",
    "blush",
    "of",
    "embarrassment",
    "shone",
    "faintly",
    "on",
    "his",
    "sunburned",
    "cheeks,",
    "though",
    "to",
    "him",
    "it",
    "burned",
    "as",
    "hotly",
    "as",
    "when",
    "his",
    "cheeks",
    "had",
    "been",
    "exposed",
    "to",
    "the",
    "open",
    "furnace-door",
    "in",
    "the",
    "fire-room.",
    "Such",
    "sordid",
    "things",
    "as",
    "stabbing",
    "affrays",
    "were",
    "evidently",
    "not",
    "fit",
    "subjects",
    "for",
    "conversation",
    "with",
    "a",
    "lady.",
    "People",
    "in",
    "the",
    "books,",
    "in",
    "her",
    "walk",
    "of",
    "life,",
    "did",
    "not",
    "talk",
    "about",
    "such",
    "things-perhaps",
    "they",
    "did",
    "not",
    "know",
    "about",
    "them,",
    "either.",
    "There",
    "was",
    "a",
    "brief",
    "pause",
    "in",
    "the",
    "conversation",
    "they",
    "were",
    "trying",
    "to",
    "get",
    "started.",
    "Then",
    "she",
    "asked",
    "tentatively",
    "about",
    "the",
    "scar",
    "on",
    "his",
    "cheek.",
    "Even",
    "as",
    "she",
    "asked,",
    "he",
    "realized",
    "that",
    "she",
    "was",
    "making",
    "an",
    "effort",
    "to",
    "talk",
    "his",
    "talk,",
    "and",
    "he",
    "resolved",
    "to",
    "get",
    "away",
    "from",
    "it",
    "and",
    "talk",
    "hers.",
    "It",
    "was",
    "just",
    "an",
    "accident,",
    "he",
    "said,",
    "putting",
    "his",
    "hand",
    "to",
    "his",
    "cheek.",
    "One",
    "night,",
    "in",
    "a",
    "calm,",
    "with",
    "a",
    "heavy",
    "sea",
    "running,",
    "the",
    "main-boom-lift",
    "carried",
    "away,",
    "an�",
    "next",
    "the",
    "tackle.",
    "The",
    "lift",
    "was",
    "wire,",
    "an�",
    "it",
    "was",
    "threshin�",
    "around",
    "like",
    "a",
    "snake.",
    "The",
    "whole",
    "watch",
    "was",
    "tryin�",
    "to",
    "grab",
    "it,",
    "an�",
    "I",
    "rushed",
    "in",
    "an�",
    "got",
    "swatted.",
    "Oh,",
    "she",
    "said,",
    "this",
    "time",
    "with",
    "an",
    "accent",
    "of",
    "comprehension,",
    "though",
    "secretly",
    "his",
    "speech",
    "had",
    "been",
    "so",
    "much",
    "Greek",
    "to",
    "her",
    "and",
    "she",
    "was",
    "wondering",
    "what",
    "a",
    "lift",
    "was",
    "and",
    "what",
    "swatted",
    "meant.",
    "This",
    "man",
    "Swineburne,",
    "he",
    "began,",
    "attempting",
    "to",
    "put",
    "his",
    "plan",
    "into",
    "execution",
    "and",
    "pronouncing",
    "the",
    "i",
    "long.",
    "Who?",
    "Swineburne,",
    "he",
    "repeated,",
    "with",
    "the",
    "same",
    "mispronunciation.",
    "The",
    "poet.",
    "Swinburne,",
    "she",
    "corrected.",
    "Yes,",
    "that�s",
    "the",
    "chap,",
    "he",
    "stammered,",
    "his",
    "cheeks",
    "hot",
    "again.",
    "How",
    "long",
    "since",
    "he",
    "died?",
    "Why,",
    "I",
    "haven�t",
    "heard",
    "that",
    "he",
    "was",
    "dead.",
    "She",
    "looked",
    "at",
    "him",
    "curiously.",
    "Where",
    "did",
    "you",
    "make",
    "his",
    "acquaintance?",
    "I",
    "never",
    "clapped",
    "eyes",
    "on",
    "him,",
    "was",
    "the",
    "reply.",
    "But",
    "I",
    "read",
    "some",
    "of",
    "his",
    "poetry",
    "out",
    "of",
    "that",
    "book",
    "there",
    "on",
    "the",
    "table",
    "just",
    "before",
    "you",
    "come",
    "in.",
    "How",
    "do",
    "you",
    "like",
    "his",
    "poetry?",
    "And",
    "thereat",
    "she",
    "began",
    "to",
    "talk",
    "quickly",
    "and",
    "easily",
    "upon",
    "the",
    "subject",
    "he",
    "had",
    "suggested.",
    "He",
    "felt",
    "better,",
    "and",
    "settled",
    "back",
    "slightly",
    "from",
    "the",
    "edge",
    "of",
    "the",
    "chair,",
    "holding",
    "tightly",
    "to",
    "its",
    "arms",
    "with",
    "his",
    "hands,",
    "as",
    "if",
    "it",
    "might",
    "get",
    "away",
    "from",
    "him",
    "and",
    "buck",
    "him",
    "to",
    "the",
    "floor.",
    "He",
    "had",
    "succeeded",
    "in",
    "making",
    "her",
    "talk",
    "her",
    "talk,",
    "and",
    "while",
    "she",
    "rattled",
    "on,",
    "he",
    "strove",
    "to",
    "follow",
    "her,",
    "marvelling",
    "at",
    "all",
    "the",
    "knowledge",
    "that",
    "was",
    "stowed",
    "away",
    "in",
    "that",
    "pretty",
    "head",
    "of",
    "hers,",
    "and",
    "drinking",
    "in",
    "the",
    "pale",
    "beauty",
    "of",
    "her",
    "face.",
    "Follow",
    "her",
    "he",
    "did,",
    "though",
    "bothered",
    "by",
    "unfamiliar",
    "words",
    "that",
    "fell",
    "glibly",
    "from",
    "her",
    "lips",
    "and",
    "by",
    "critical",
    "phrases",
    "and",
    "thought-processes",
    "that",
    "were",
    "foreign",
    "to",
    "his",
    "mind,",
    "but",
    "that",
    "nevertheless",
    "stimulated",
    "his",
    "mind",
    "and",
    "set",
    "it",
    "tingling.",
    "Here",
    "was",
    "intellectual",
    "life,",
    "he",
    "thought,",
    "and",
    "here",
    "was",
    "beauty,",
    "warm",
    "and",
    "wonderful",
    "as",
    "he",
    "had",
    "never",
    "dreamed",
    "it",
    "could",
    "be.",
    "He",
    "forgot",
    "himself",
    "and",
    "stared",
    "at",
    "her",
    "with",
    "hungry",
    "eyes.",
    "Here",
    "was",
    "something",
    "to",
    "live",
    "for,",
    "to",
    "win",
    "to,",
    "to",
    "fight",
    "for-ay,",
    "and",
    "die",
    "for.",
    "The",
    "books",
    "were",
    "true.",
    "There",
    "were",
    "such",
    "women",
    "in",
    "the",
    "world.",
    "She",
    "was",
    "one",
    "of",
    "them.",
    "She",
    "lent",
    "wings",
    "to",
    "his",
    "imagination,",
    "and",
    "great,",
    "luminous",
    "canvases",
    "spread",
    "themselves",
    "before",
    "him",
    "whereon",
    "loomed",
    "vague,",
    "gigantic",
    "figures",
    "of",
    "love",
    "and",
    "romance,",
    "and",
    "of",
    "heroic",
    "deeds",
    "for",
    "woman�s",
    "sake-for",
    "a",
    "pale",
    "woman,",
    "a",
    "flower",
    "of",
    "gold.",
    "And",
    "through",
    "the",
    "swaying,",
    "palpitant",
    "vision,",
    "as",
    "through",
    "a",
    "fairy",
    "mirage,",
    "he",
    "stared",
    "at",
    "the",
    "real",
    "woman,",
    "sitting",
    "there",
    "and",
    "talking",
    "of",
    "literature",
    "and",
    "art.",
    "He",
    "listened",
    "as",
    "well,",
    "but",
    "he",
    "stared,",
    "unconscious",
    "of",
    "the",
    "fixity",
    "of",
    "his",
    "gaze",
    "or",
    "of",
    "the",
    "fact",
    "that",
    "all",
    "that",
    "was",
    "essentially",
    "masculine",
    "in",
    "his",
    "nature",
    "was",
    "shining",
    "in",
    "his",
    "eyes.",
    "But",
    "she,",
    "who",
    "knew",
    "little",
    "of",
    "the",
    "world",
    "of",
    "men,",
    "being",
    "a",
    "woman,",
    "was",
    "keenly",
    "aware",
    "of",
    "his",
    "burning",
    "eyes.",
    "She",
    "had",
    "never",
    "had",
    "men",
    "look",
    "at",
    "her",
    "in",
    "such",
    "fashion,",
    "and",
    "it",
    "embarrassed",
    "her.",
    "She",
    "stumbled",
    "and",
    "halted",
    "in",
    "her",
    "utterance.",
    "The",
    "thread",
    "of",
    "argument",
    "slipped",
    "from",
    "her.",
    "He",
    "frightened",
    "her,",
    "and",
    "at",
    "the",
    "same",
    "time",
    "it",
    "was",
    "strangely",
    "pleasant",
    "to",
    "be",
    "so",
    "looked",
    "upon.",
    "Her",
    "training",
    "warned",
    "her",
    "of",
    "peril",
    "and",
    "of",
    "wrong,",
    "subtle,",
    "mysterious,",
    "luring;",
    "while",
    "her",
    "instincts",
    "rang",
    "clarion-voiced",
    "through",
    "her",
    "being,",
    "impelling",
    "her",
    "to",
    "hurdle",
    "caste",
    "and",
    "place",
    "and",
    "gain",
    "to",
    "this",
    "traveller",
    "from",
    "another",
    "world,",
    "to",
    "this",
    "uncouth",
    "young",
    "fellow",
    "with",
    "lacerated",
    "hands",
    "and",
    "a",
    "line",
    "of",
    "raw",
    "red",
    "caused",
    "by",
    "the",
    "unaccustomed",
    "linen",
    "at",
    "his",
    "throat,",
    "who,",
    "all",
    "too",
    "evidently,",
    "was",
    "soiled",
    "and",
    "tainted",
    "by",
    "ungracious",
    "existence.",
    "She",
    "was",
    "clean,",
    "and",
    "her",
    "cleanness",
    "revolted;",
    "but",
    "she",
    "was",
    "woman,",
    "and",
    "she",
    "was",
    "just",
    "beginning",
    "to",
    "learn",
    "the",
    "paradox",
    "of",
    "woman.",
    "As",
    "I",
    "was",
    "saying-what",
    "was",
    "I",
    "saying?",
    "She",
    "broke",
    "off",
    "abruptly",
    "and",
    "laughed",
    "merrily",
    "at",
    "her",
    "predicament.",
    "You",
    "was",
    "saying",
    "that",
    "this",
    "man",
    "Swinburne",
    "failed",
    "bein�",
    "a",
    "great",
    "poet",
    "because-an�",
    "that",
    "was",
    "as",
    "far",
    "as",
    "you",
    "got,",
    "miss,",
    "he",
    "prompted,",
    "while",
    "to",
    "himself",
    "he",
    "seemed",
    "suddenly",
    "hungry,",
    "and",
    "delicious",
    "little",
    "thrills",
    "crawled",
    "up",
    "and",
    "down",
    "his",
    "spine",
    "at",
    "the",
    "sound",
    "of",
    "her",
    "laughter.",
    "Like",
    "silver,",
    "he",
    "thought",
    "to",
    "himself,",
    "like",
    "tinkling",
    "silver",
    "bells;",
    "and",
    "on",
    "the",
    "instant,",
    "and",
    "for",
    "an",
    "instant,",
    "he",
    "was",
    "transported",
    "to",
    "a",
    "far",
    "land,",
    "where",
    "under",
    "pink",
    "cherry",
    "blossoms,",
    "he",
    "smoked",
    "a",
    "cigarette",
    "and",
    "listened",
    "to",
    "the",
    "bells",
    "of",
    "the",
    "peaked",
    "pagoda",
    "calling",
    "straw-sandalled",
    "devotees",
    "to",
    "worship.",
    "Yes,",
    "thank",
    "you,",
    "she",
    "said.",
    "Swinburne",
    "fails,",
    "when",
    "all",
    "is",
    "said,",
    "because",
    "he",
    "is,",
    "well,",
    "indelicate.",
    "There",
    "are",
    "many",
    "of",
    "his",
    "poems",
    "that",
    "should",
    "never",
    "be",
    "read.",
    "Every",
    "line",
    "of",
    "the",
    "really",
    "great",
    "poets",
    "is",
    "filled",
    "with",
    "beautiful",
    "truth,",
    "and",
    "calls",
    "to",
    "all",
    "that",
    "is",
    "high",
    "and",
    "noble",
    "in",
    "the",
    "human.",
    "Not",
    "a",
    "line",
    "of",
    "the",
    "great",
    "poets",
    "can",
    "be",
    "spared",
    "without",
    "impoverishing",
    "the",
    "world",
    "by",
    "that",
    "much.",
    "I",
    "thought",
    "it",
    "was",
    "great,",
    "he",
    "said",
    "hesitatingly,",
    "the",
    "little",
    "I",
    "read.",
    "I",
    "had",
    "no",
    "idea",
    "he",
    "was",
    "such",
    "a-a",
    "scoundrel.",
    "I",
    "guess",
    "that",
    "crops",
    "out",
    "in",
    "his",
    "other",
    "books.",
    "There",
    "are",
    "many",
    "lines",
    "that",
    "could",
    "be",
    "spared",
    "from",
    "the",
    "book",
    "you",
    "were",
    "reading,",
    "she",
    "said,",
    "her",
    "voice",
    "primly",
    "firm",
    "and",
    "dogmatic.",
    "I",
    "must",
    "�a�",
    "missed",
    "�em,",
    "he",
    "announced.",
    "What",
    "I",
    "read",
    "was",
    "the",
    "real",
    "goods.",
    "It",
    "was",
    "all",
    "lighted",
    "up",
    "an�",
    "shining,",
    "an�",
    "it",
    "shun",
    "right",
    "into",
    "me",
    "an�",
    "lighted",
    "me",
    "up",
    "inside,",
    "like",
    "the",
    "sun",
    "or",
    "a",
    "searchlight.",
    "That�s",
    "the",
    "way",
    "it",
    "landed",
    "on",
    "me,",
    "but",
    "I",
    "guess",
    "I",
    "ain�t",
    "up",
    "much",
    "on",
    "poetry,",
    "miss.",
    "He",
    "broke",
    "off",
    "lamely.",
    "He",
    "was",
    "confused,",
    "painfully",
    "conscious",
    "of",
    "his",
    "inarticulateness.",
    "He",
    "had",
    "felt",
    "the",
    "bigness",
    "and",
    "glow",
    "of",
    "life",
    "in",
    "what",
    "he",
    "had",
    "read,",
    "but",
    "his",
    "speech",
    "was",
    "inadequate.",
    "He",
    "could",
    "not",
    "express",
    "what",
    "he",
    "felt,",
    "and",
    "to",
    "himself",
    "he",
    "likened",
    "himself",
    "to",
    "a",
    "sailor,",
    "in",
    "a",
    "strange",
    "ship,",
    "on",
    "a",
    "dark",
    "night,",
    "groping",
    "about",
    "in",
    "the",
    "unfamiliar",
    "running",
    "rigging.",
    "Well,",
    "he",
    "decided,",
    "it",
    "was",
    "up",
    "to",
    "him",
    "to",
    "get",
    "acquainted",
    "in",
    "this",
    "new",
    "world.",
    "He",
    "had",
    "never",
    "seen",
    "anything",
    "that",
    "he",
    "couldn�t",
    "get",
    "the",
    "hang",
    "of",
    "when",
    "he",
    "wanted",
    "to",
    "and",
    "it",
    "was",
    "about",
    "time",
    "for",
    "him",
    "to",
    "want",
    "to",
    "learn",
    "to",
    "talk",
    "the",
    "things",
    "that",
    "were",
    "inside",
    "of",
    "him",
    "so",
    "that",
    "she",
    "could",
    "understand.",
    "She",
    "was",
    "bulking",
    "large",
    "on",
    "his",
    "horizon.",
    "Now",
    "Longfellow-",
    "she",
    "was",
    "saying.",
    "Yes,",
    "I�ve",
    "read",
    "�m,",
    "he",
    "broke",
    "in",
    "impulsively,",
    "spurred",
    "on",
    "to",
    "exhibit",
    "and",
    "make",
    "the",
    "most",
    "of",
    "his",
    "little",
    "store",
    "of",
    "book",
    "knowledge,",
    "desirous",
    "of",
    "showing",
    "her",
    "that",
    "he",
    "was",
    "not",
    "wholly",
    "a",
    "stupid",
    "clod.",
    "�The",
    "Psalm",
    "of",
    "Life,�",
    "�Excelsior,�",
    "an��",
    "I",
    "guess",
    "that�s",
    "all.",
    "She",
    "nodded",
    "her",
    "head",
    "and",
    "smiled,",
    "and",
    "he",
    "felt,",
    "somehow,",
    "that",
    "her",
    "smile",
    "was",
    "tolerant,",
    "pitifully",
    "tolerant.",
    "He",
    "was",
    "a",
    "fool",
    "to",
    "attempt",
    "to",
    "make",
    "a",
    "pretence",
    "that",
    "way.",
    "That",
    "Longfellow",
    "chap",
    "most",
    "likely",
    "had",
    "written",
    "countless",
    "books",
    "of",
    "poetry.",
    "Excuse",
    "me,",
    "miss,",
    "for",
    "buttin�",
    "in",
    "that",
    "way.",
    "I",
    "guess",
    "the",
    "real",
    "facts",
    "is",
    "that",
    "I",
    "don�t",
    "know",
    "nothin�",
    "much",
    "about",
    "such",
    "things.",
    "It",
    "ain�t",
    "in",
    "my",
    "class.",
    "But",
    "I�m",
    "goin�",
    "to",
    "make",
    "it",
    "in",
    "my",
    "class.",
    "It",
    "sounded",
    "like",
    "a",
    "threat.",
    "His",
    "voice",
    "was",
    "determined,",
    "his",
    "eyes",
    "were",
    "flashing,",
    "the",
    "lines",
    "of",
    "his",
    "face",
    "had",
    "grown",
    "harsh.",
    "And",
    "to",
    "her",
    "it",
    "seemed",
    "that",
    "the",
    "angle",
    "of",
    "his",
    "jaw",
    "had",
    "changed;",
    "its",
    "pitch",
    "had",
    "become",
    "unpleasantly",
    "aggressive.",
    "At",
    "the",
    "same",
    "time",
    "a",
    "wave",
    "of",
    "intense",
    "virility",
    "seemed",
    "to",
    "surge",
    "out",
    "from",
    "him",
    "and",
    "impinge",
    "upon",
    "her.",
    "I",
    "think",
    "you",
    "could",
    "make",
    "it",
    "in-in",
    "your",
    "class,",
    "she",
    "finished",
    "with",
    "a",
    "laugh.",
    "You",
    "are",
    "very",
    "strong.",
    "Her",
    "gaze",
    "rested",
    "for",
    "a",
    "moment",
    "on",
    "the",
    "muscular",
    "neck,",
    "heavy",
    "corded,",
    "almost",
    "bull-like,",
    "bronzed",
    "by",
    "the",
    "sun,",
    "spilling",
    "over",
    "with",
    "rugged",
    "health",
    "and",
    "strength.",
    "And",
    "though",
    "he",
    "sat",
    "there,",
    "blushing",
    "and",
    "humble,",
    "again",
    "she",
    "felt",
    "drawn",
    "to",
    "him.",
    "She",
    "was",
    "surprised",
    "by",
    "a",
    "wanton",
    "thought",
    "that",
    "rushed",
    "into",
    "her",
    "mind.",
    "It",
    "seemed",
    "to",
    "her",
    "that",
    "if",
    "she",
    "could",
    "lay",
    "her",
    "two",
    "hands",
    "upon",
    "that",
    "neck",
    "that",
    "all",
    "its",
    "strength",
    "and",
    "vigor",
    "would",
    "flow",
    "out",
    "to",
    "her.",
    "She",
    "was",
    "shocked",
    "by",
    "this",
    "thought.",
    "It",
    "seemed",
    "to",
    "reveal",
    "to",
    "her",
    "an",
    "undreamed",
    "depravity",
    "in",
    "her",
    "nature.",
    "Besides,",
    "strength",
    "to",
    "her",
    "was",
    "a",
    "gross",
    "and",
    "brutish",
    "thing.",
    "Her",
    "ideal",
    "of",
    "masculine",
    "beauty",
    "had",
    "always",
    "been",
    "slender",
    "gracefulness.",
    "Yet",
    "the",
    "thought",
    "still",
    "persisted.",
    "It",
    "bewildered",
    "her",
    "that",
    "she",
    "should",
    "desire",
    "to",
    "place",
    "her",
    "hands",
    "on",
    "that",
    "sunburned",
    "neck.",
    "In",
    "truth,",
    "she",
    "was",
    "far",
    "from",
    "robust,",
    "and",
    "the",
    "need",
    "of",
    "her",
    "body",
    "and",
    "mind",
    "was",
    "for",
    "strength.",
    "But",
    "she",
    "did",
    "not",
    "know",
    "it.",
    "She",
    "knew",
    "only",
    "that",
    "no",
    "man",
    "had",
    "ever",
    "affected",
    "her",
    "before",
    "as",
    "this",
    "one",
    "had,",
    "who",
    "shocked",
    "her",
    "from",
    "moment",
    "to",
    "moment",
    "with",
    "his",
    "awful",
    "grammar.",
    "Yes,",
    "I",
    "ain�t",
    "no",
    "invalid,",
    "he",
    "said.",
    "When",
    "it",
    "comes",
    "down",
    "to",
    "hard-pan,",
    "I",
    "can",
    "digest",
    "scrap-iron.",
    "But",
    "just",
    "now",
    "I�ve",
    "got",
    "dyspepsia.",
    "Most",
    "of",
    "what",
    "you",
    "was",
    "sayin�",
    "I",
    "can�t",
    "digest.",
    "Never",
    "trained",
    "that",
    "way,",
    "you",
    "see.",
    "I",
    "like",
    "books",
    "and",
    "poetry,",
    "and",
    "what",
    "time",
    "I�ve",
    "had",
    "I�ve",
    "read",
    "�em,",
    "but",
    "I�ve",
    "never",
    "thought",
    "about",
    "�em",
    "the",
    "way",
    "you",
    "have.",
    "That�s",
    "why",
    "I",
    "can�t",
    "talk",
    "about",
    "�em.",
    "I�m",
    "like",
    "a",
    "navigator",
    "adrift",
    "on",
    "a",
    "strange",
    "sea",
    "without",
    "chart",
    "or",
    "compass.",
    "Now",
    "I",
    "want",
    "to",
    "get",
    "my",
    "bearin�s.",
    "Mebbe",
    "you",
    "can",
    "put",
    "me",
    "right.",
    "How",
    "did",
    "you",
    "learn",
    "all",
    "this",
    "you�ve",
    "ben",
    "talkin�?",
    "By",
    "going",
    "to",
    "school,",
    "I",
    "fancy,",
    "and",
    "by",
    "studying,",
    "she",
    "answered.",
    "I",
    "went",
    "to",
    "school",
    "when",
    "I",
    "was",
    "a",
    "kid,",
    "he",
    "began",
    "to",
    "object.",
    "Yes;",
    "but",
    "I",
    "mean",
    "high",
    "school,",
    "and",
    "lectures,",
    "and",
    "the",
    "university.",
    "You�ve",
    "gone",
    "to",
    "the",
    "university?",
    "he",
    "demanded",
    "in",
    "frank",
    "amazement.",
    "He",
    "felt",
    "that",
    "she",
    "had",
    "become",
    "remoter",
    "from",
    "him",
    "by",
    "at",
    "least",
    "a",
    "million",
    "miles.",
    "I�m",
    "going",
    "there",
    "now.",
    "I�m",
    "taking",
    "special",
    "courses",
    "in",
    "English.",
    "He",
    "did",
    "not",
    "know",
    "what",
    "English",
    "meant,",
    "but",
    "he",
    "made",
    "a",
    "mental",
    "note",
    "of",
    "that",
    "item",
    "of",
    "ignorance",
    "and",
    "passed",
    "on.",
    "How",
    "long",
    "would",
    "I",
    "have",
    "to",
    "study",
    "before",
    "I",
    "could",
    "go",
    "to",
    "the",
    "university?",
    "he",
    "asked.",
    "She",
    "beamed",
    "encouragement",
    "upon",
    "his",
    "desire",
    "for",
    "knowledge,",
    "and",
    "said:",
    "That",
    "depends",
    "upon",
    "how",
    "much",
    "studying",
    "you",
    "have",
    "already",
    "done.",
    "You",
    "have",
    "never",
    "attended",
    "high",
    "school?",
    "Of",
    "course",
    "not.",
    "But",
    "did",
    "you",
    "finish",
    "grammar",
    "school?",
    "I",
    "had",
    "two",
    "years",
    "to",
    "run,",
    "when",
    "I",
    "left,",
    "he",
    "answered.",
    "But",
    "I",
    "was",
    "always",
    "honorably",
    "promoted",
    "at",
    "school.",
    "The",
    "next",
    "moment,",
    "angry",
    "with",
    "himself",
    "for",
    "the",
    "boast,",
    "he",
    "had",
    "gripped",
    "the",
    "arms",
    "of",
    "the",
    "chair",
    "so",
    "savagely",
    "that",
    "every",
    "finger-end",
    "was",
    "stinging.",
    "At",
    "the",
    "same",
    "moment",
    "he",
    "became",
    "aware",
    "that",
    "a",
    "woman",
    "was",
    "entering",
    "the",
    "room.",
    "He",
    "saw",
    "the",
    "girl",
    "leave",
    "her",
    "chair",
    "and",
    "trip",
    "swiftly",
    "across",
    "the",
    "floor",
    "to",
    "the",
    "newcomer.",
    "They",
    "kissed",
    "each",
    "other,",
    "and,",
    "with",
    "arms",
    "around",
    "each",
    "other�s",
    "waists,",
    "they",
    "advanced",
    "toward",
    "him.",
    "That",
    "must",
    "be",
    "her",
    "mother,",
    "he",
    "thought.",
    "She",
    "was",
    "a",
    "tall,",
    "blond",
    "woman,",
    "slender,",
    "and",
    "stately,",
    "and",
    "beautiful.",
    "Her",
    "gown",
    "was",
    "what",
    "he",
    "might",
    "expect",
    "in",
    "such",
    "a",
    "house.",
    "His",
    "eyes",
    "delighted",
    "in",
    "the",
    "graceful",
    "lines",
    "of",
    "it.",
    "She",
    "and",
    "her",
    "dress",
    "together",
    "reminded",
    "him",
    "of",
    "women",
    "on",
    "the",
    "stage.",
    "Then",
    "he",
    "remembered",
    "seeing",
    "similar",
    "grand",
    "ladies",
    "and",
    "gowns",
    "entering",
    "the",
    "London",
    "theatres",
    "while",
    "he",
    "stood",
    "and",
    "watched",
    "and",
    "the",
    "policemen",
    "shoved",
    "him",
    "back",
    "into",
    "the",
    "drizzle",
    "beyond",
    "the",
    "awning.",
    "Next",
    "his",
    "mind",
    "leaped",
    "to",
    "the",
    "Grand",
    "Hotel",
    "at",
    "Yokohama,",
    "where,",
    "too,",
    "from",
    "the",
    "sidewalk,",
    "he",
    "had",
    "seen",
    "grand",
    "ladies.",
    "Then",
    "the",
    "city",
    "and",
    "the",
    "harbor",
    "of",
    "Yokohama,",
    "in",
    "a",
    "thousand",
    "pictures,",
    "began",
    "flashing",
    "before",
    "his",
    "eyes.",
    "But",
    "he",
    "swiftly",
    "dismissed",
    "the",
    "kaleidoscope",
    "of",
    "memory,",
    "oppressed",
    "by",
    "the",
    "urgent",
    "need",
    "of",
    "the",
    "present.",
    "He",
    "knew",
    "that",
    "he",
    "must",
    "stand",
    "up",
    "to",
    "be",
    "introduced,",
    "and",
    "he",
    "struggled",
    "painfully",
    "to",
    "his",
    "feet,",
    "where",
    "he",
    "stood",
    "with",
    "trousers",
    "bagging",
    "at",
    "the",
    "knees,",
    "his",
    "arms",
    "loose-hanging",
    "and",
    "ludicrous,",
    "his",
    "face",
    "set",
    "hard",
    "for",
    "the",
    "impending",
    "ordeal.",
    "CHAPTER",
    "II",
    "The",
    "process",
    "of",
    "getting",
    "into",
    "the",
    "dining",
    "room",
    "was",
    "a",
    "nightmare",
    "to",
    "him.",
    "Between",
    "halts",
    "and",
    "stumbles,",
    "jerks",
    "and",
    "lurches,",
    "locomotion",
    "had",
    "at",
    "times",
    "seemed",
    "impossible.",
    "But",
    "at",
    "last",
    "he",
    "had",
    "made",
    "it,",
    "and",
    "was",
    "seated",
    "alongside",
    "of",
    "Her.",
    "The",
    "array",
    "of",
    "knives",
    "and",
    "forks",
    "frightened",
    "him.",
    "They",
    "bristled",
    "with",
    "unknown",
    "perils,",
    "and",
    "he",
    "gazed",
    "at",
    "them,",
    "fascinated,",
    "till",
    "their",
    "dazzle",
    "became",
    "a",
    "background",
    "across",
    "which",
    "moved",
    "a",
    "succession",
    "of",
    "forecastle",
    "pictures,",
    "wherein",
    "he",
    "and",
    "his",
    "mates",
    "sat",
    "eating",
    "salt",
    "beef",
    "with",
    "sheath-knives",
    "and",
    "fingers,",
    "or",
    "scooping",
    "thick",
    "pea-soup",
    "out",
    "of",
    "pannikins",
    "by",
    "means",
    "of",
    "battered",
    "iron",
    "spoons.",
    "The",
    "stench",
    "of",
    "bad",
    "beef",
    "was",
    "in",
    "his",
    "nostrils,",
    "while",
    "in",
    "his",
    "ears,",
    "to",
    "the",
    "accompaniment",
    "of",
    "creaking",
    "timbers",
    "and",
    "groaning",
    "bulkheads,",
    "echoed",
    "the",
    "loud",
    "mouth-noises",
    "of",
    "the",
    "eaters.",
    "He",
    "watched",
    "them",
    "eating,",
    "and",
    "decided",
    "that",
    "they",
    "ate",
    "like",
    "pigs.",
    "Well,",
    "he",
    "would",
    "be",
    "careful",
    "here.",
    "He",
    "would",
    "make",
    "no",
    "noise.",
    "He",
    "would",
    "keep",
    "his",
    "mind",
    "upon",
    "it",
    "all",
    "the",
    "time.",
    "He",
    "glanced",
    "around",
    "the",
    "table.",
    "Opposite",
    "him",
    "was",
    "Arthur,",
    "and",
    "Arthur�s",
    "brother,",
    "Norman.",
    "They",
    "were",
    "her",
    "brothers,",
    "he",
    "reminded",
    "himself,",
    "and",
    "his",
    "heart",
    "warmed",
    "toward",
    "them.",
    "How",
    "they",
    "loved",
    "each",
    "other,",
    "the",
    "members",
    "of",
    "this",
    "family!",
    "There",
    "flashed",
    "into",
    "his",
    "mind",
    "the",
    "picture",
    "of",
    "her",
    "mother,",
    "of",
    "the",
    "kiss",
    "of",
    "greeting,",
    "and",
    "of",
    "the",
    "pair",
    "of",
    "them",
    "walking",
    "toward",
    "him",
    "with",
    "arms",
    "entwined.",
    "Not",
    "in",
    "his",
    "world",
    "were",
    "such",
    "displays",
    "of",
    "affection",
    "between",
    "parents",
    "and",
    "children",
    "made.",
    "It",
    "was",
    "a",
    "revelation",
    "of",
    "the",
    "heights",
    "of",
    "existence",
    "that",
    "were",
    "attained",
    "in",
    "the",
    "world",
    "above.",
    "It",
    "was",
    "the",
    "finest",
    "thing",
    "yet",
    "that",
    "he",
    "had",
    "seen",
    "in",
    "this",
    "small",
    "glimpse",
    "of",
    "that",
    "world.",
    "He",
    "was",
    "moved",
    "deeply",
    "by",
    "appreciation",
    "of",
    "it,",
    "and",
    "his",
    "heart",
    "was",
    "melting",
    "with",
    "sympathetic",
    "tenderness.",
    "He",
    "had",
    "starved",
    "for",
    "love",
    "all",
    "his",
    "life.",
    "His",
    "nature",
    "craved",
    "love.",
    "It",
    "was",
    "an",
    "organic",
    "demand",
    "of",
    "his",
    "being.",
    "Yet",
    "he",
    "had",
    "gone",
    "without,",
    "and",
    "hardened",
    "himself",
    "in",
    "the",
    "process.",
    "He",
    "had",
    "not",
    "known",
    "that",
    "he",
    "needed",
    "love.",
    "Nor",
    "did",
    "he",
    "know",
    "it",
    "now.",
    "He",
    "merely",
    "saw",
    "it",
    "in",
    "operation,",
    "and",
    "thrilled",
    "to",
    "it,",
    "and",
    "thought",
    "it",
    "fine,",
    "and",
    "high,",
    "and",
    "splendid.",
    "He",
    "was",
    "glad",
    "that",
    "Mr.",
    "Morse",
    "was",
    "not",
    "there.",
    "It",
    "was",
    "difficult",
    "enough",
    "getting",
    "acquainted",
    "with",
    "her,",
    "and",
    "her",
    "mother,",
    "and",
    "her",
    "brother,",
    "Norman.",
    "Arthur",
    "he",
    "already",
    "knew",
    "somewhat.",
    "The",
    "father",
    "would",
    "have",
    "been",
    "too",
    "much",
    "for",
    "him,",
    "he",
    "felt",
    "sure.",
    "It",
    "seemed",
    "to",
    "him",
    "that",
    "he",
    "had",
    "never",
    "worked",
    "so",
    "hard",
    "in",
    "his",
    "life.",
    "The",
    "severest",
    "toil",
    "was",
    "child�s",
    "play",
    "compared",
    "with",
    "this.",
    "Tiny",
    "nodules",
    "of",
    "moisture",
    "stood",
    "out",
    "on",
    "his",
    "forehead,",
    "and",
    "his",
    "shirt",
    "was",
    "wet",
    "with",
    "sweat",
    "from",
    "the",
    "exertion",
    "of",
    "doing",
    "so",
    "many",
    "unaccustomed",
    "things",
    "at",
    "once.",
    "He",
    "had",
    "to",
    "eat",
    "as",
    "he",
    "had",
    "never",
    "eaten",
    "before,",
    "to",
    "handle",
    "strange",
    "tools,",
    "to",
    "glance",
    "surreptitiously",
    "about",
    "and",
    "learn",
    "how",
    "to",
    "accomplish",
    "each",
    "new",
    "thing,",
    "to",
    "receive",
    "the",
    "flood",
    "of",
    "impressions",
    "that",
    "was",
    "pouring",
    "in",
    "upon",
    "him",
    "and",
    "being",
    "mentally",
    "annotated",
    "and",
    "classified;",
    "to",
    "be",
    "conscious",
    "of",
    "a",
    "yearning",
    "for",
    "her",
    "that",
    "perturbed",
    "him",
    "in",
    "the",
    "form",
    "of",
    "a",
    "dull,",
    "aching",
    "restlessness;",
    "to",
    "feel",
    "the",
    "prod",
    "of",
    "desire",
    "to",
    "win",
    "to",
    "the",
    "walk",
    "in",
    "life",
    "whereon",
    "she",
    "trod,",
    "and",
    "to",
    "have",
    "his",
    "mind",
    "ever",
    "and",
    "again",
    "straying",
    "off",
    "in",
    "speculation",
    "and",
    "vague",
    "plans",
    "of",
    "how",
    "to",
    "reach",
    "to",
    "her.",
    "Also,",
    "when",
    "his",
    "secret",
    "glance",
    "went",
    "across",
    "to",
    "Norman",
    "opposite",
    "him,",
    "or",
    "to",
    "any",
    "one",
    "else,",
    "to",
    "ascertain",
    "just",
    "what",
    "knife",
    "or",
    "fork",
    "was",
    "to",
    "be",
    "used",
    "in",
    "any",
    "particular",
    "occasion,",
    "that",
    "person�s",
    "features",
    "were",
    "seized",
    "upon",
    "by",
    "his",
    "mind,",
    "which",
    "automatically",
    "strove",
    "to",
    "appraise",
    "them",
    "and",
    "to",
    "divine",
    "what",
    "they",
    "were-all",
    "in",
    "relation",
    "to",
    "her.",
    "Then",
    "he",
    "had",
    "to",
    "talk,",
    "to",
    "hear",
    "what",
    "was",
    "said",
    "to",
    "him",
    "and",
    "what",
    "was",
    "said",
    "back",
    "and",
    "forth,",
    "and",
    "to",
    "answer,",
    "when",
    "it",
    "was",
    "necessary,",
    "with",
    "a",
    "tongue",
    "prone",
    "to",
    "looseness",
    "of",
    "speech",
    "that",
    "required",
    "a",
    "constant",
    "curb.",
    "And",
    "to",
    "add",
    "confusion",
    "to",
    "confusion,",
    "there",
    "was",
    "the",
    "servant,",
    "an",
    "unceasing",
    "menace,",
    "that",
    "appeared",
    "noiselessly",
    "at",
    "his",
    "shoulder,",
    "a",
    "dire",
    "Sphinx",
    "that",
    "propounded",
    "puzzles",
    "and",
    "conundrums",
    "demanding",
    "instantaneous",
    "solution.",
    "He",
    "was",
    "oppressed",
    "throughout",
    "the",
    "meal",
    "by",
    "the",
    "thought",
    "of",
    "finger-bowls.",
    "Irrelevantly,",
    "insistently,",
    "scores",
    "of",
    "times,",
    "he",
    "wondered",
    "when",
    "they",
    "would",
    "come",
    "on",
    "and",
    "what",
    "they",
    "looked",
    "like.",
    "He",
    "had",
    "heard",
    "of",
    "such",
    "things,",
    "and",
    "now,",
    "sooner",
    "or",
    "later,",
    "somewhere",
    "in",
    "the",
    "next",
    "few",
    "minutes,",
    "he",
    "would",
    "see",
    "them,",
    "sit",
    "at",
    "table",
    "with",
    "exalted",
    "beings",
    "who",
    "used",
    "them-ay,",
    "and",
    "he",
    "would",
    "use",
    "them",
    "himself.",
    "And",
    "most",
    "important",
    "of",
    "all,",
    "far",
    "down",
    "and",
    "yet",
    "always",
    "at",
    "the",
    "surface",
    "of",
    "his",
    "thought,",
    "was",
    "the",
    "problem",
    "of",
    "how",
    "he",
    "should",
    "comport",
    "himself",
    "toward",
    "these",
    "persons.",
    "What",
    "should",
    "his",
    "attitude",
    "be?",
    "He",
    "wrestled",
    "continually",
    "and",
    "anxiously",
    "with",
    "the",
    "problem.",
    "There",
    "were",
    "cowardly",
    "suggestions",
    "that",
    "he",
    "should",
    "make",
    "believe,",
    "assume",
    "a",
    "part;",
    "and",
    "there",
    "were",
    "still",
    "more",
    "cowardly",
    "suggestions",
    "that",
    "warned",
    "him",
    "he",
    "would",
    "fail",
    "in",
    "such",
    "course,",
    "that",
    "his",
    "nature",
    "was",
    "not",
    "fitted",
    "to",
    "live",
    "up",
    "to",
    "it,",
    "and",
    "that",
    "he",
    "would",
    "make",
    "a",
    "fool",
    "of",
    "himself.",
    "It",
    "was",
    "during",
    "the",
    "first",
    "part",
    "of",
    "the",
    "dinner,",
    "struggling",
    "to",
    "decide",
    "upon",
    "his",
    "attitude,",
    "that",
    "he",
    "was",
    "very",
    "quiet.",
    "He",
    "did",
    "not",
    "know",
    "that",
    "his",
    "quietness",
    "was",
    "giving",
    "the",
    "lie",
    "to",
    "Arthur�s",
    "words",
    "of",
    "the",
    "day",
    "before,",
    "when",
    "that",
    "brother",
    "of",
    "hers",
    "had",
    "announced",
    "that",
    "he",
    "was",
    "going",
    "to",
    "bring",
    "a",
    "wild",
    "man",
    "home",
    "to",
    "dinner",
    "and",
    "for",
    "them",
    "not",
    "to",
    "be",
    "alarmed,",
    "because",
    "they",
    "would",
    "find",
    "him",
    "an",
    "interesting",
    "wild",
    "man.",
    "Martin",
    "Eden",
    "could",
    "not",
    "have",
    "found",
    "it",
    "in",
    "him,",
    "just",
    "then,",
    "to",
    "believe",
    "that",
    "her",
    "brother",
    "could",
    "be",
    "guilty",
    "of",
    "such",
    "treachery-especially",
    "when",
    "he",
    "had",
    "been",
    "the",
    "means",
    "of",
    "getting",
    "this",
    "particular",
    "brother",
    "out",
    "of",
    "an",
    "unpleasant",
    "row.",
    "So",
    "he",
    "sat",
    "at",
    "table,",
    "perturbed",
    "by",
    "his",
    "own",
    "unfitness",
    "and",
    "at",
    "the",
    "same",
    "time",
    "charmed",
    "by",
    "all",
    "that",
    "went",
    "on",
    "about",
    "him.",
    "For",
    "the",
    "first",
    "time",
    "he",
    "realized",
    "that",
    "eating",
    "was",
    "something",
    "more",
    "than",
    "a",
    "utilitarian",
    "function.",
    "He",
    "was",
    "unaware",
    "of",
    "what",
    "he",
    "ate.",
    "It",
    "was",
    "merely",
    "food.",
    "He",
    "was",
    "feasting",
    "his",
    "love",
    "of",
    "beauty",
    "at",
    "this",
    "table",
    "where",
    "eating",
    "was",
    "an",
    "aesthetic",
    "function.",
    "It",
    "was",
    "an",
    "intellectual",
    "function,",
    "too.",
    "His",
    "mind",
    "was",
    "stirred.",
    "He",
    "heard",
    "words",
    "spoken",
    "that",
    "were",
    "meaningless",
    "to",
    "him,",
    "and",
    "other",
    "words",
    "that",
    "he",
    "had",
    "seen",
    "only",
    "in",
    "books",
    "and",
    "that",
    "no",
    "man",
    "or",
    "woman",
    "he",
    "had",
    "known",
    "was",
    "of",
    "large",
    "enough",
    "mental",
    "caliber",
    "to",
    "pronounce.",
    "When",
    "he",
    "heard",
    "such",
    "words",
    "dropping",
    "carelessly",
    "from",
    "the",
    "lips",
    "of",
    "the",
    "members",
    "of",
    "this",
    "marvellous",
    "family,",
    "her",
    "family,",
    "he",
    "thrilled",
    "with",
    "delight.",
    "The",
    "romance,",
    "and",
    "beauty,",
    "and",
    "high",
    "vigor",
    "of",
    "the",
    "books",
    "were",
    "coming",
    "true.",
    "He",
    "was",
    "in",
    "that",
    "rare",
    "and",
    "blissful",
    "state",
    "wherein",
    "a",
    "man",
    "sees",
    "his",
    "dreams",
    "stalk",
    "out",
    "from",
    "the",
    "crannies",
    "of",
    "fantasy",
    "and",
    "become",
    "fact.",
    "Never",
    "had",
    "he",
    "been",
    "at",
    "such",
    "an",
    "altitude",
    "of",
    "living,",
    "and",
    "he",
    "kept",
    "himself",
    "in",
    "the",
    "background,",
    "listening,",
    "observing,",
    "and",
    "pleasuring,",
    "replying",
    "in",
    "reticent",
    "monosyllables,",
    "saying,",
    "Yes,",
    "miss,",
    "and",
    "No,",
    "miss,",
    "to",
    "her,",
    "and",
    "Yes,",
    "ma�am,",
    "and",
    "No,",
    "ma�am,",
    "to",
    "her",
    "mother.",
    "He",
    "curbed",
    "the",
    "impulse,",
    "arising",
    "out",
    "of",
    "his",
    "sea-training,",
    "to",
    "say",
    "Yes,",
    "sir,",
    "and",
    "No,",
    "sir,",
    "to",
    "her",
    "brothers.",
    "He",
    "felt",
    "that",
    "it",
    "would",
    "be",
    "inappropriate",
    "and",
    "a",
    "confession",
    "of",
    "inferiority",
    "on",
    "his",
    "part-which",
    "would",
    "never",
    "do",
    "if",
    "he",
    "was",
    "to",
    "win",
    "to",
    "her.",
    "Also,",
    "it",
    "was",
    "a",
    "dictate",
    "of",
    "his",
    "pride.",
    "By",
    "God!",
    "he",
    "cried",
    "to",
    "himself,",
    "once;",
    "I�m",
    "just",
    "as",
    "good",
    "as",
    "them,",
    "and",
    "if",
    "they",
    "do",
    "know",
    "lots",
    "that",
    "I",
    "don�t,",
    "I",
    "could",
    "learn",
    "�m",
    "a",
    "few",
    "myself,",
    "all",
    "the",
    "same!",
    "And",
    "the",
    "next",
    "moment,",
    "when",
    "she",
    "or",
    "her",
    "mother",
    "addressed",
    "him",
    "as",
    "Mr.",
    "Eden,",
    "his",
    "aggressive",
    "pride",
    "was",
    "forgotten,",
    "and",
    "he",
    "was",
    "glowing",
    "and",
    "warm",
    "with",
    "delight.",
    "He",
    "was",
    "a",
    "civilized",
    "man,",
    "that",
    "was",
    "what",
    "he",
    "was,",
    "shoulder",
    "to",
    "shoulder,",
    "at",
    "dinner,",
    "with",
    "people",
    "he",
    "had",
    "read",
    "about",
    "in",
    "books.",
    "He",
    "was",
    "in",
    "the",
    "books",
    "himself,",
    "adventuring",
    "through",
    "the",
    "printed",
    "pages",
    "of",
    "bound",
    "volumes.",
    "But",
    "while",
    "he",
    "belied",
    "Arthur�s",
    "description,",
    "and",
    "appeared",
    "a",
    "gentle",
    "lamb",
    "rather",
    "than",
    "a",
    "wild",
    "man,",
    "he",
    "was",
    "racking",
    "his",
    "brains",
    "for",
    "a",
    "course",
    "of",
    "action.",
    "He",
    "was",
    "no",
    "gentle",
    "lamb,",
    "and",
    "the",
    "part",
    "of",
    "second",
    "fiddle",
    "would",
    "never",
    "do",
    "for",
    "the",
    "high-pitched",
    "dominance",
    "of",
    "his",
    "nature.",
    "He",
    "talked",
    "only",
    "when",
    "he",
    "had",
    "to,",
    "and",
    "then",
    "his",
    "speech",
    "was",
    "like",
    "his",
    "walk",
    "to",
    "the",
    "table,",
    "filled",
    "with",
    "jerks",
    "and",
    "halts",
    "as",
    "he",
    "groped",
    "in",
    "his",
    "polyglot",
    "vocabulary",
    "for",
    "words,",
    "debating",
    "over",
    "words",
    "he",
    "knew",
    "were",
    "fit",
    "but",
    "which",
    "he",
    "feared",
    "he",
    "could",
    "not",
    "pronounce,",
    "rejecting",
    "other",
    "words",
    "he",
    "knew",
    "would",
    "not",
    "be",
    "understood",
    "or",
    "would",
    "be",
    "raw",
    "and",
    "harsh.",
    "But",
    "all",
    "the",
    "time",
    "he",
    "was",
    "oppressed",
    "by",
    "the",
    "consciousness",
    "that",
    "this",
    "carefulness",
    "of",
    "diction",
    "was",
    "making",
    "a",
    "booby",
    "of",
    "him,",
    "preventing",
    "him",
    "from",
    "expressing",
    "what",
    "he",
    "had",
    "in",
    "him.",
    "Also,",
    "his",
    "love",
    "of",
    "freedom",
    "chafed",
    "against",
    "the",
    "restriction",
    "in",
    "much",
    "the",
    "same",
    "way",
    "his",
    "neck",
    "chafed",
    "against",
    "the",
    "starched",
    "fetter",
    "of",
    "a",
    "collar.",
    "Besides,",
    "he",
    "was",
    "confident",
    "that",
    "he",
    "could",
    "not",
    "keep",
    "it",
    "up.",
    "He",
    "was",
    "by",
    "nature",
    "powerful",
    "of",
    "thought",
    "and",
    "sensibility,",
    "and",
    "the",
    "creative",
    "spirit",
    "was",
    "restive",
    "and",
    "urgent.",
    "He",
    "was",
    "swiftly",
    "mastered",
    "by",
    "the",
    "concept",
    "or",
    "sensation",
    "in",
    "him",
    "that",
    "struggled",
    "in",
    "birth-throes",
    "to",
    "receive",
    "expression",
    "and",
    "form,",
    "and",
    "then",
    "he",
    "forgot",
    "himself",
    "and",
    "where",
    "he",
    "was,",
    "and",
    "the",
    "old",
    "words-the",
    "tools",
    "of",
    "speech",
    "he",
    "knew-slipped",
    "out.",
    "Once,",
    "he",
    "declined",
    "something",
    "from",
    "the",
    "servant",
    "who",
    "interrupted",
    "and",
    "pestered",
    "at",
    "his",
    "shoulder,",
    "and",
    "he",
    "said,",
    "shortly",
    "and",
    "emphatically,",
    "Pew!",
    "On",
    "the",
    "instant",
    "those",
    "at",
    "the",
    "table",
    "were",
    "keyed",
    "up",
    "and",
    "expectant,",
];

pub fn long_comp_strings() -> Vec<String> {
    vec![
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
        String::from("truhdkiufyhnsryfsjnf"),
        String::from("gdsuhdjjjidjsdjdsjud"),
        String::from("5783uhffffffffffffffffff"),
        String::from("fhjsjfj"),
        String::from("gdsuhdjjj744748748"),
        String::from("46yfhjnamzndgansjehan"),
    ]
}
