use crate::util::cmd::run::{ArgsManager, CmdInfo,parse_args};
use std::future::Future;
use std::pin::Pin;
use wd_event::Context;

#[macro_use]
mod util;

#[tokio::main]
async fn main() {
    ArgsManager::new()
        .register_init(
            |ctx: Context| -> Pin<Box<dyn Future<Output = Context> + Send>> {
                Box::pin(async move {
                    ctx.set("hello", "world").await;
                    println!("init success");
                    return ctx;
                })
            },
        )
        .register_cmd(
            CmdInfo::new("run", "run application")
                .add("c", "./src/util/conf/config.toml", "config path")
                .add("max",3,"max thread")
            ,|ctx: Context| -> Pin<Box<dyn Future<Output = Context> + Send>> {
                Box::pin(async move {
                    let path = parse_args::<_,i32>(&ctx,"max").await.unwrap();
                    println!("config: {}",path);
                    return ctx;
                })
            },
        )
        .register_exit(
            |ctx: Context| -> Pin<Box<dyn Future<Output = Context> + Send>> {
                Box::pin(async move {
                    let world = ctx.copy("hello").await.unwrap_or("get world failed");
                    println!("game over: {}", world);
                    return ctx;
                })
            },
        )
        .run()
        .await;
}
