use wd_run::{CmdInfo, KE_ARGS, ExecManager};
use std::collections::HashMap;
use wd_event::Context;
use std::sync::Arc;

#[tokio::main]
async fn main() {
    let mut em = ExecManager::new().await;
    let cr = CoreRun{};
    em.registered(cr.clone(), CoreRun::get_flag_default());
    em.registered(cr, CoreRun::get_flag_exit());
    em.run().await.unwrap();
}


#[derive(Clone)]
pub struct CoreRun {
}
impl CoreRun {
    //获取命令行参数参数设置
    pub fn get_flag_default() -> CmdInfo {
        let mut ci = CmdInfo::new("run", "", "start run core");
        ci.set_flag("-c", "./src/util/conf/config.toml", "config file path");
        ci
    }
    pub fn get_flags(ctx: Arc<Context>) -> HashMap<String, String> {
        match ctx.get_value::<&str, HashMap<String, String>>(&KE_ARGS) {
            Some(s) => s,
            None => HashMap::new(),
        }
    }
    pub fn get_flag_exit() -> CmdInfo {
        CmdInfo::new("exit", "", "automatically when exiting the service")
    }
    async fn run(&self, ctx: Arc<Context>) {
        //解析输入参数，获取配置文件路径
        let flags = CoreRun::get_flags(ctx);
        let path = flags.get("-c").expect("未获取到配置文件路径").clone();
        println!("{}",path);
        //TODO server do something
        //...
    }
}
//回调事件
#[wd_event::event_trait]
impl wd_event::AsyncEvent for CoreRun {
    async fn handle(&self, ctx: Arc<Context>) {
        let opt_cmd = ctx.get_msg::<String>();
        if let None = opt_cmd {
            return;
        }
        let cmd = String::clone(&opt_cmd.unwrap());
        match cmd.as_str() {
            "run" => {
                self.run(ctx).await;
            }
            "exit" => {
                println!("-----> stop")
                // self.stop();
            }
            _ => {
                println!("Unprocessed commands:{}", cmd)
            }
        }
    }
}