[wd_run][docsrs]: a project operation management tool
========================================

[![wd_run GitHub Actions][gh-image]][gh-checks]
[![wd_run on crates.io][cratesio-image]][cratesio]
[![wd_run on docs.rs][docsrs-image]][docsrs]
[![License](https://img.shields.io/crates/l/lazy_static.svg)](https://gitee.com/yutiandou/wd_run/blob/master/LICENSE)

[gh-image]: https://github.com/chronotope/chrono/workflows/test/badge.svg
[gh-checks]: https://gitee.com/yutiandou/wd_run/tree/master
[cratesio-image]: https://img.shields.io/crates/v/wd_run.svg
[cratesio]: https://crates.io/crates/wd_run
[docsrs-image]: https://docs.rs/wd_run/badge.svg
[docsrs]: https://docs.rs/wd_run
[gitter-image]: https://badges.gitter.im/wd_run-rs/wd_run.svg
[gitter]: https://gitter.im/wd_run-rs/wd_run

> wd_run supports command line parsing and configuration file parsing. It is mainly achieved through the method of registering callbacks.

The following configuration file parsing formats are supported:
- [x] json
- [x] yaml
- [x] toml
- [ ] http (coding)

## Getting Started

```rust
[dependencies]
wd_run = "0.2"
```
## Example
```rust
use std::future::Future;
use std::pin::Pin;
use wd_run::*;

#[tokio::main]

async fn main() {
    ArgsManager::new()
        .add_global_flag("name", "wd_run_test", "server name")
        .register_init(init_one)
        .register_init(init_two)
        .register_cmd(
            CmdInfo::new("run", "run appliation").add("cycle", 5, "cycle index"),
            cmd_run,
        )
        .register_cmd(
            CmdInfo::new("show", "show init value").add("desc", "show info", "none"),
            cmd_show,
        )
        .register_exit(exit)
        .run()
        .await;
}

pub fn init_one(ctx: Context) -> Pin<Box<dyn Future<Output = Context> + Send>> {
    Box::pin(async move {
        //load config
        // let result:Config = load_config("./config.yaml").unwrap();
        ctx.set("init_one", "success".to_string()).await;
        return ctx;
    })
}
pub fn init_two(ctx: Context) -> Pin<Box<dyn Future<Output = Context> + Send>> {
    Box::pin(async move {
        ctx.set("init_two", "success".to_string()).await;
        return ctx;
    })
}
pub fn cmd_run(ctx: Context) -> Pin<Box<dyn Future<Output = Context> + Send>> {
    Box::pin(async move {
        let cycle = parse_args::<_, u32>(&ctx, "cycle").await.unwrap();
        for i in 0..cycle {
            tokio::time::sleep(tokio::time::Duration::from_secs(1)).await;
            println!("--->{}", i);
        }
        return ctx;
    })
}
pub fn cmd_show(ctx: Context) -> Pin<Box<dyn Future<Output = Context> + Send>> {
    Box::pin(async move {
        let name = ctx.copy::<_, String>("name").await.unwrap();
        let desc = ctx.copy::<_, String>("desc").await.unwrap();
        println!("----------> {}:{} <---------------", name, desc);
        let one = ctx.copy::<_, String>("init_one").await.unwrap();
        let two = ctx.copy::<_, String>("init_two").await.unwrap();
        println!("init one:{}  two:{}", one, two);
        return ctx;
    })
}
pub fn exit(ctx: Context) -> Pin<Box<dyn Future<Output = Context> + Send>> {
    Box::pin(async move {
        println!("game over");
        return ctx;
    })
}
```
Run the following command：
```bash
cargo run -- run --cycle 3
```
```bash
cargo run -- show --name wd_run
```

## License

Licensed under either of

 * Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

## Contribution
Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without any additional terms or conditions.