#![allow(unused_imports)]

use crate::util::conf::config;
use serde::{Deserialize, Serialize};

#[derive(Debug, Deserialize, Serialize)]
struct Like {
    eta: String,
}

#[derive(Debug, Deserialize, Serialize)]
struct Teststruct {
    name: String,
    age: u8,
    #[serde(rename = "love")]
    like: Like,
}

#[test]
fn test() {
    let c: Result<Teststruct, config::Error> =
        config::load_config_from_path(config::File::new("./src/conf/config.yaml"));
    match c {
        Err(e) => println!("{}", e.error()),
        Ok(conf) => println!("{:?}", conf),
    }
}

#[cfg(test)]
mod test{
    use serde::{Serialize,Deserialize};

    #[derive(Deserialize,Debug)]
    pub struct Config{
        name:String,
        #[serde(default = "i32::default")]
        age:i32,
        #[serde(default = "Server::new")]
        server:Server,
    }
    #[derive(Deserialize,Debug)]
    struct Server{
        addr:String
    }
    impl Server{
        fn new()->Self{
            Server{addr:"localhost".to_string()}
        }
    }
    #[test]
    fn test_toml(){
        let cfg:Config = toml::from_str(r#"
        name = "hello world"
        "#).expect("解析错误");
        println!("res:{:?}",cfg)
    }
}