#![allow(unused_imports)]

use crate::util::conf::config;
use serde::{Deserialize, Serialize};

#[derive(Debug, Deserialize, Serialize)]
struct Like {
    eta: String,
}

#[derive(Debug, Deserialize, Serialize)]
struct Teststruct {
    name: String,
    age: u8,
    #[serde(rename = "love")]
    like: Like,
}

#[test]
fn test() {
    let c: Result<Teststruct, config::Error> =
        config::load_config_from_path(config::File::new("./src/conf/config.yaml"));
    match c {
        Err(e) => println!("{}", e.error()),
        Ok(conf) => println!("{:?}", conf),
    }
}
