use once_cell::sync::OnceCell;
use std::sync::Arc;
use wd_event::*;

pub static WD_EVENT: OnceCell<Arc<EventManage<String>>> = OnceCell::new();

#[allow(dead_code)]
pub async fn init_event() {
    let event = Arc::new(EventManage::new_async(EConfig::default()).await);
    if let Ok(_) = WD_EVENT.set(event) {
        return;
    }
    panic!("core init failed！！！");
}

#[allow(dead_code)]
pub fn get_event() -> Arc<EventManage<String>> {
    if let Some(s) = WD_EVENT.get() {
        return s.clone();
    }
    let event = Arc::new(EventManage::new(EConfig::default()));
    WD_EVENT.set(event.clone()).expect_err("core init error");
    return event;
}
