[wd_run][docsrs]: A Rust library providing a lightweight logging facade
========================================

[![wd_run GitHub Actions][gh-image]][gh-checks]
[![wd_run on crates.io][cratesio-image]][cratesio]
[![wd_run on docs.rs][docsrs-image]][docsrs]
[![License](https://img.shields.io/crates/l/lazy_static.svg)](https://gitee.com/yutiandou/wd_run/blob/master/LICENSE)

[gh-image]: https://github.com/chronotope/chrono/workflows/test/badge.svg
[gh-checks]: https://gitee.com/yutiandou/wd_run/tree/master
[cratesio-image]: https://img.shields.io/crates/v/wd_run.svg
[cratesio]: https://crates.io/crates/wd_run
[docsrs-image]: https://docs.rs/wd_run/badge.svg
[docsrs]: https://docs.rs/wd_run
[gitter-image]: https://badges.gitter.im/wd_run-rs/wd_run.svg
[gitter]: https://gitter.im/wd_run-rs/wd_run

> wd_run supports command line parsing and configuration file parsing. It is mainly achieved through the method of registering callbacks.

The following configuration file parsing formats are supported:
- [x] json
- [x] yaml
- [x] json
- [ ] http (coding)

## Getting Started

```rust
[dependencies]
wd_run = "0.1"
```
## Example
#### cmd
- ExecManager : a global processor
- AsyncEvent : the interface to the callback function
- CmdInfo : command registration tool

Run the following code and the command line
```bash
//help
cargo run -- -h
//run
cargo run -- run
```
```rust
use wd_run::{CmdInfo, KE_ARGS, ExecManager,Context};
use std::collections::HashMap;
use std::sync::Arc;

#[tokio::main]
async fn main() {
    let mut em = ExecManager::new().await;
    let cr = CoreRun{};
    em.registered(cr.clone(), CoreRun::get_flag_default());
    em.registered(cr, CoreRun::get_flag_exit());
    em.run().await.unwrap();
}


#[derive(Clone)]
pub struct CoreRun {
}
impl CoreRun {
    //获取命令行参数参数设置
    pub fn get_flag_default() -> CmdInfo {
        let mut ci = CmdInfo::new("run", "", "start run core");
        ci.set_flag("-c", "./src/util/conf/config.toml", "config file path");
        ci
    }
    pub fn get_flags(ctx: Arc<Context>) -> HashMap<String, String> {
        match ctx.get_value::<&str, HashMap<String, String>>(&KE_ARGS) {
            Some(s) => s,
            None => HashMap::new(),
        }
    }
    pub fn get_flag_exit() -> CmdInfo {
        CmdInfo::new("exit", "", "automatically when exiting the service")
    }
    async fn run(&self, ctx: Arc<Context>) {
        //解析输入参数，获取配置文件路径
        let flags = CoreRun::get_flags(ctx);
        let path = flags.get("-c").expect("未获取到配置文件路径").clone();
        println!("{}",path);
        //TODO server do something
        //...
    }
}
//回调事件
#[wd_run::event_trait]
impl wd_run::AsyncEvent for CoreRun {
    async fn handle(&self, ctx: Arc<Context>) {
        let opt_cmd = ctx.get_msg::<String>();
        if let None = opt_cmd {
            return;
        }
        let cmd = String::clone(&opt_cmd.unwrap());
        match cmd.as_str() {
            "run" => {
                self.run(ctx).await;
            }
            "exit" => {
                println!("-----> stop")
                // self.stop();
            }
            _ => {
                println!("Unprocessed commands:{}", cmd)
            }
        }
    }
}
```
#### config
```rust
#[derive(Debug,Deserialize)]
pub struct Config {
    pub log: i32,
    pub server: String,
    pub stream: String,
}
#[test]
fn test_config () {
    let conf:Config = wd_run::load_config("./src/util/conf/config.toml").unwrap();
    println!("{:?}",conf)
}
```

## License

Licensed under either of

 * Apache License, Version 2.0, ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.

## Contribution
Unless you explicitly state otherwise, any contribution intentionally submitted for inclusion in the work by you, as defined in the Apache-2.0 license, shall be dual licensed as above, without any additional terms or conditions.