use proc_macro::{TokenStream};
use quote::{quote, ToTokens};
use syn::{parse_macro_input,ItemImpl,ImplItem};

pub fn wd_async_trait(_args: TokenStream, input: TokenStream) -> TokenStream {
    // let args = parse_macro_input!(args as Args);
    let mut expanded = quote! {};
    let mut item = parse_macro_input!(input as ItemImpl);
    for item in item.items.iter_mut() {
        match item {
            ImplItem::Method(ref mut method)=>{
                let header = &method.sig;
                let body = &method.block;
                expanded = quote! {
                    #expanded
                    #header {
                            let (send,recv) = crossbeam::channel::unbounded();
                            tokio::spawn(async move{
                                let async_function = tokio::spawn(async move{
                                       #body
                                });
                                let return_result = async_function.await.expect("async trait await error");
                                send.send(return_result);
                            });
                            let res = recv.recv().expect("async trait recv error");
                            return res;
                    }
                };
            }
            _=>{}
        }
    }
    let struct_name = &item.self_ty.to_token_stream();
    let trait_name = &item.trait_.unwrap().1.to_token_stream();
    expanded = quote! {
        impl #trait_name for #struct_name {
            #expanded
        }
    };
    TokenStream::from(expanded)
}