use proc_macro::{TokenStream};
use quote::{quote, ToTokens};
use syn::{parse_macro_input, DeriveInput,Ident};
use syn::__private::Span;

/// 为结构体生成链式设置参数的方法
pub fn chain_set(input: TokenStream) -> TokenStream {
    let input = parse_macro_input!(input as DeriveInput);
    let mut expanded = quote! {
    };
    //解析出所有字段
    let struct_data = match &input.data {
        syn::Data::Struct(s)=>{
            match &s.fields {
                syn::Fields::Named(fields)=>{
                    fields
                }
                _ =>{
                    return TokenStream::from(expanded);
                }
            }
        }
        _=>{
            return TokenStream::from(expanded);
        }
    };
    //遍历字段
    struct_data.named.iter().for_each(|f|{
        let fname = if let Some(ref ident) = f.ident{
            ident
        }else{
            return
        };
        let func_name = format!("cset_{}",fname.to_token_stream());
        let func_name = &Ident::new(func_name.as_str(), Span::call_site());
        let ty = &f.ty;
        expanded = quote! {
            #expanded
            pub fn #func_name(mut self,value:#ty)->Self{
                self.#fname = value;self
            }
        }
    });
    let struct_generics = &input.generics;
    let struct_name = &input.ident;
    expanded = quote! {
        impl#struct_generics #struct_name#struct_generics{
            pub fn say_hello_cset(&self){
                println!("hello world")
            }
            #expanded
        }
    };
    TokenStream::from(expanded)
}

/// 为结构体生成参数获取的方法
pub fn get(input: TokenStream) -> TokenStream {
    let input = parse_macro_input!(input as DeriveInput);
    let mut expanded = quote! {
    };
    //解析出所有字段
    let struct_data = match &input.data {
        syn::Data::Struct(s)=>{
            match &s.fields {
                syn::Fields::Named(fields)=>{
                    fields
                }
                _ =>{
                    return TokenStream::from(expanded);
                }
            }
        }
        _=>{
            return TokenStream::from(expanded);
        }
    };
    //遍历字段
    struct_data.named.iter().for_each(|field|{
        let fname = if let Some(ref ident) = field.ident{
            ident
        }else{
            return
        };
        let func_name = format!("get_{}",fname.to_token_stream());
        let func_name = &Ident::new(func_name.as_str(), Span::call_site());
        let ty = &field.ty;
        expanded = quote! {
            #expanded
            pub fn #func_name<'a>(&'a self)->&'a #ty{
                &(self.#fname)
            }
        }
    });
    //返回
    let struct_generics = &input.generics;
    let struct_name = &input.ident;
    expanded = quote! {
        impl#struct_generics #struct_name#struct_generics{
            pub fn say_hello_get(&self){
                println!("hello world")
            }
            #expanded
        }
    };
    TokenStream::from(expanded)
}
